#!/bin/bash
BASEDIR="$( cd -- "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
BASEDIR=$(echo "$BASEDIR" | sed -e 's/\/[^\/]*$//')

RED='\033[0;31m'
NC='\033[0m'
GREEN='\033[0;32m'

if [ -f "$BASEDIR"/bin/kendis/kendis.pid ];then
   kpid=`cat "$BASEDIR"/bin/kendis/kendis.pid`
   #if ps -p $kpid > /dev/null ; then
      printf "${GREEN}shutting down Kendis server ...${NC}\n"
      kill -9 $kpid
      #rm kendis.pid
      printf "${GREEN}Kendis sever shutdown completed ...${NC}\n"
      else
          printf "${RED}Kendis sever is already down!${NC}\n"
     #fi
fi

printf "${GREEN}shutting down data server ...${NC}\n"
"$BASEDIR"/mongodb-linux-aarch64-rhel82-6.0.13/bin/mongo --eval "db.getSiblingDB('admin').shutdownServer()"
printf "${GREEN}data server shutdown completed ...${NC}\n"
