function getJiraOrAzureCreatedOnForBacklogItem(dbItem) {

    if (dbItem.hasOwnProperty("fields") && dbItem.fields !== null ) {
        var fields = dbItem.fields;
        
        if (fields.hasOwnProperty("CreatedDate")) {
            return fields.CreatedDate;
        } else if (fields.hasOwnProperty("created")) {
            return fields.created;
        }
    } else if (dbItem.itemType == "BASE_ITEM") {
        return dbItem.baseItemCreatedOn;
    }

    return null;
}

function dateDiffInDays(almCreationDateStr, eventTimeStr) {
    var almCreationDate = new Date(almCreationDateStr);
    var eventTime = new Date(eventTimeStr);

    const diffInMillies = Math.abs(eventTime - almCreationDate);
    const diffInDays = Math.floor(diffInMillies / (1000 * 60 * 60 * 24));

    return diffInDays;
}

var backlogItemIds = [
    "660cf8ae798f0f0e13069d56",
    "6603e6cf8526350b31c78ad8",
    "660f97637f09017192d73082",
    "660cf8ae798f0f0e13069d55",
    "660cf8ae798f0f0e13069d54"    
]

var timeseriesResult = [];
db.getCollection("timeSeriesLog").aggregate([
    {
        $match: {
            "itemId":{ 
                $in: backlogItemIds
            },
            "changes.status.category": "Done"
        }
    },
    {
        $lookup: {
            from: "backlogItem",
            let: { itemIdObj: { $convert: { input: "$itemId", to: "objectId" } } }, // Convert itemId to ObjectId
            pipeline: [
                {
                    $match: {
                        $expr: { $eq: ["$_id", "$$itemIdObj"] } // Match ObjectId with _id
                    }
                }
            ],
            as: "backlogItem"
        }
    },
    {
        $unwind: {
            path: "$backlogItem",
            preserveNullAndEmptyArrays: true
        }
    },
    {
        $group: {
            _id: "$itemId",
            itemType: {$first: "$itemType"},
            items: {
                $push: {
                    $mergeObjects: {
                        changes: "$changes",
                        eventTime: "$eventTime"
                    }
                }
            },
            fields: { $first: "$backlogItem.fields" }
        }
    }
]).forEach(function(doc) {
    var almCreationDate = getJiraOrAzureCreatedOnForBacklogItem(doc);
    
    if (almCreationDate) {
        doc.almCreationDate = almCreationDate;
    }

    delete doc["fields"];
    
    timeseriesResult.push(doc);
});

print(timeseriesResult);

var series = [];

timeseriesResult.forEach(data => {
    if (data.items) {
        var items = data.items;
        var latestChange = items[items.length - 1];
        var doneEventTimeStr = latestChange.eventTime;
        var almCreationDateStr = data.almCreationDate;
        var completionDays = dateDiffInDays(almCreationDateStr, doneEventTimeStr);
        series.push({
            name: data._id,
            data: [completionDays]
        })
    }
})

print(series);
