function getJiraOrAzureCreatedOnForBacklogItem(dbItem) {

    if (dbItem.hasOwnProperty("fields") && dbItem.fields !== null ) {
        var fields = dbItem.fields;
        
        if (fields.hasOwnProperty("CreatedDate")) {
            return fields.CreatedDate;
        } else if (fields.hasOwnProperty("created")) {
            return fields.created;
        }
    } else if (dbItem.itemType == "BASE_ITEM") {
        return dbItem.baseItemCreatedOn;
    }

    return null;
}

function dateDiffInDays(almCreationDateStr, eventTimeStr) {
    var almCreationDate = new Date(almCreationDateStr);
    var eventTime = new Date(eventTimeStr);

    const diffInMillies = Math.abs(eventTime - almCreationDate);
    const diffInDays = Math.floor(diffInMillies / (1000 * 60 * 60 * 24));

    return diffInDays;
}

var linkedItemIds = [
    "664457ae8a0386440ed30452",
    "664457ae8a0386440ed30451",
    "664457ae8a0386440ed30450",
    "664457ae8a0386440ed3044f",
    "664457ae8a0386440ed3044e",
    "664457ae8a0386440ed3044d",
    "662f396763372d5441625b91"
]

var timeseriesResult = [];
db.getCollection("timeSeriesLog").aggregate([
    {
        $match: {
            "itemId":{ 
                $in: [
                    "665f02f7c2f7da430bf90817",             // Time Series Batch
                    "665f0306c2f7da430bf90820",              // Sub batch of Timeseries batch
                    
                    "664457ae8a0386440ed30452",             // Linked Item IDs
                    "664457ae8a0386440ed30451",
                    "664457ae8a0386440ed30450",
                    "664457ae8a0386440ed3044f",
                    "664457ae8a0386440ed3044e",
                    "664457ae8a0386440ed3044d",
                    "662f396763372d5441625b91",
                ]
            },
            "changes.status.category": "Done"
        }
    },
    {
        $lookup: {
            from: "baseItem",
            let: { itemIdObj: { $convert: { input: "$itemId", to: "objectId" } } }, // Convert itemId to ObjectId
            pipeline: [
                {
                    $match: {
                        $expr: { $eq: ["$_id", "$$itemIdObj"] } // Match ObjectId with _id
                    }
                }
            ],
            as: "baseItem"
        }
    },
    {
        $unwind: {
            path: "$baseItem",
            preserveNullAndEmptyArrays: true
        }
    },
    {
        $lookup: {
            from: "backlogItem",
            let: { itemIdObj: { $convert: { input: "$itemId", to: "objectId" } } }, // Convert itemId to ObjectId
            pipeline: [
                {
                    $match: {
                        $expr: { $eq: ["$_id", "$$itemIdObj"] } // Match ObjectId with _id
                    }
                }
            ],
            as: "backlogItem"
        }
    },
    {
        $unwind: {
            path: "$backlogItem",
            preserveNullAndEmptyArrays: true
        }
    },
    {
        $group: {
            _id: "$itemId",
            itemType: {$first: "$itemType"},
            items: {
                $push: {
                    $mergeObjects: {
                        changes: "$changes",
                        eventTime: "$eventTime"
                    }
                }
            },
            fields: { $first: "$backlogItem.fields" },
            baseItemCreatedOn: {$first: "$baseItem.createdOn"}
        }
    }
]).forEach(function(doc) {
    var almCreationDate = getJiraOrAzureCreatedOnForBacklogItem(doc);
    
    if (almCreationDate) {
        doc.almCreationDate = almCreationDate;
    }

    delete doc["fields"];
    delete doc["baseItem"];    
    
    timeseriesResult.push(doc);
});

print(timeseriesResult);

var itemIdAgainstLeadTime = {};

timeseriesResult.forEach(data => {
    if (data.items) {
        var items = data.items;
        var latestChange = items[items.length - 1];
        var doneEventTimeStr = latestChange.eventTime;
        var almCreationDateStr = data.almCreationDate;
        var completionDays = dateDiffInDays(almCreationDateStr, doneEventTimeStr);
        itemIdAgainstLeadTime[data._id] = completionDays;
    }
})

print(itemIdAgainstLeadTime);
var drilldownSeries = [];
var topLevelBatchData = [];
topLevelBatchData.push({
    name: 'TimeSeries Batch - 665f02f7c2f7da430bf90817',
    y: itemIdAgainstLeadTime['665f02f7c2f7da430bf90817'],
    drilldown: '665f0306c2f7da430bf90820'                       // sub batch
});

drilldownSeries.push({
    name: "TimeSeries Batch - 665f02f7c2f7da430bf90817",
    id: "665f02f7c2f7da430bf90817",
    colorByPoint: true,
    data: topLevelBatchData
})

var subBatchData = [];
subBatchData.push({
    name: 'TimeSeries Sub batch - 665f0306c2f7da430bf90820',
    y: itemIdAgainstLeadTime['665f0306c2f7da430bf90820'],
    drilldown: 'linkedItems'
})

drilldownSeries.push({
    name: 'TimeSeries Sub batch - 665f0306c2f7da430bf90820',
    id: '665f0306c2f7da430bf90820',
    data: subBatchData
});

var linkedItemsData = [];

linkedItemIds.forEach(linkedItem => {
    var data = [];
    data.push(linkedItem);
    data.push(itemIdAgainstLeadTime[linkedItem]);

    linkedItemsData.push(data);
});

drilldownSeries.push({
    name: "linkedItems",
    id: "linkedItems",
    data: linkedItemsData
})

print(drilldownSeries);


var series = [];

series.push({
    colorByPoint: true,
    data: [{
        name: "TimeSeries Batch - 665f02f7c2f7da430bf90817",
        y: itemIdAgainstLeadTime["665f02f7c2f7da430bf90817"],
        drilldown: "665f02f7c2f7da430bf90817"
    }]
})

print(series);