// Helper function to add days to a date
function addDays(date, days) {
    var result = new Date(date);
    result.setDate(result.getDate() + days);
    return result;
}

// Helper function to format date as "yyyy-MM-dd"
function formatDate(date) {
    return date.toISOString().split('T')[0];
}

// Function to initialize date intervals
function initializeIntervals(startDate, endDate, intervalDays) {
    var intervals = [];
    var currentDate = new Date(startDate);
    while (currentDate <= endDate) {
        intervals.push({
            start: new Date(currentDate),
            end: addDays(new Date(currentDate), intervalDays - 1)
        });
        currentDate = addDays(currentDate, intervalDays);
    }
    return intervals;
}

// Function to count items in intervals
function countItemsInIntervals(items, intervals) {
    var counts = new Array(intervals.length).fill(0);
    items.forEach(item => {
        var eventDate = new Date(item.eventTime);
        intervals.forEach((interval, index) => {
            if (eventDate >= interval.start && eventDate <= interval.end) {
                counts[index]++;
            }
        });
    });
    return counts;
}

// Function to ensure no zero counts
function ensureNoZeroCounts(counts) {
    for (var i = 1; i < counts.length; i++) {
        if (counts[i] === 0) {
            counts[i] = counts[i - 1];
        }
    }
    return counts;
}

// Main function to process the data
function processItemCounts(data, startDate, endDate, intervalDays) {
    var intervals = initializeIntervals(startDate, endDate, intervalDays);
    data.forEach(category => {
        var itemCounts = countItemsInIntervals(category.items, intervals);
        itemCounts = ensureNoZeroCounts(itemCounts);
        category.itemCounts = itemCounts;
    });
}
function transformMapToCount(originalMap) {
    var countMap = {};
    for (var [key, value] of Object.entries(originalMap)) {
        countMap[key] = value.length;
    }
    return countMap;
}


var linkedItemIds = [
    "6666cdeb5a356378bf8966c0",
    "6666cdeb5a356378bf8966c1",
    "6666cdeb5a356378bf8966c4",
    "6666cdeb5a356378bf8966c5",
    "6666ce495a356378bf89670d",
    "6666ce5c5a356378bf896713",
    "6666ce665a356378bf896719",
    "6666ce795a356378bf896725",
    "6666ce6f5a356378bf89671f"
]

var statusItemMap = {};

var timeseriesResult = [];
db.getCollection("timeSeriesLog").aggregate([
    {
        $match: {
            "itemType": "BASE_ITEM",
            "changes.status": {$exists: true},
            "itemId":{
                $in: [
                    "6666b0255a356378bf8965db",             // Batches and Sub-batches
                    "6666b0315a356378bf8965e4",
                    "6666b03a5a356378bf8965f4",
                    "6666b0435a356378bf896608",
                    "6666b0e45a356378bf89661a",
                    "6666b0f05a356378bf89662a",
                    "6666b0fc5a356378bf89663c",
                    "6666b1085a356378bf896650",
                    "6666b1145a356378bf896660",
                    "6666b1265a356378bf896671",
                    "6666b2165a356378bf896686",
                    "6666b2205a356378bf89669b",


                    "6666cdeb5a356378bf8966c0",             // Linked Items
                    "6666cdeb5a356378bf8966c1",
                    "6666cdeb5a356378bf8966c4",
                    "6666cdeb5a356378bf8966c5",
                    "6666ce495a356378bf89670d",
                    "6666ce5c5a356378bf896713",
                    "6666ce665a356378bf896719",
                    "6666ce795a356378bf896725",
                    "6666ce6f5a356378bf89671f"
                ]
            },

        }
    },
    {
        $group: {
            _id: "$changes.status.category",
            itemType: {$first: "$itemType"},
            items: {
                $push: {
                    $mergeObjects: {
                        itemId: "$itemId",
                        eventTime: "$eventTime"
                    }
                }
            }
        }
    }
]).forEach(function(doc) {
    timeseriesResult.push(doc);
});

print(timeseriesResult);

var startDate = new Date("2024-06-10");
var endDate = new Date("2024-07-30");
var intervalDays = 5;

// Process the data
processItemCounts(timeseriesResult, startDate, endDate, intervalDays);

// Output the results
print(timeseriesResult);

// Transform the data
var series = timeseriesResult.map(item => ({
    name: item._id,
    data: item.itemCounts
}));

// Output the results
print(series);

