let fixDates = true;
const milestoneResourceId = "-1001"
function isDarkColor(color){
    if(!color ) return false;
    let c = color.substring(1);      // strip #
    let rgb = parseInt(c, 16);   // convert rrggbb to decimal
    let r = (rgb >> 16) & 0xff;  // extract red
    let g = (rgb >>  8) & 0xff;  // extract green
    let b = (rgb >>  0) & 0xff;  // extract blue

    let luma = 0.2126 * r + 0.7152 * g + 0.0722 * b; // per ITU-R BT.709
    return luma <90;
}

function isLessThan(date1, date2) {
    return date1.getFullYear() < date2.getFullYear() ||
        (date1.getFullYear() === date2.getFullYear() && date1.getMonth() < date2.getMonth()) ||
        (date1.getFullYear() === date2.getFullYear() && date1.getMonth() === date2.getMonth() && date1.getDate() < date2.getDate());
}


function isGreaterThan(date1, date2) {
    return date1.getFullYear() > date2.getFullYear() ||
        (date1.getFullYear() === date2.getFullYear() && date1.getMonth() > date2.getMonth()) ||
        (date1.getFullYear() === date2.getFullYear() && date1.getMonth() === date2.getMonth() && date1.getDate() > date2.getDate());
}

function isSameDate(date1, date2) {
    return date1.getFullYear() === date2.getFullYear() &&
        date1.getMonth() === date2.getMonth() &&
        date1.getDate() === date2.getDate();
}
function getPresetFactory(scheduler, presetKey) {
    // Define a reference client width (the width you originally designed for)
    const REFERENCE_CLIENT_WIDTH = 1364;

    // Calculate scaling factor based on current client width
    const currentClientWidth = scheduler.element.clientWidth;
    const scale = currentClientWidth / REFERENCE_CLIENT_WIDTH;

    const presets = {
        'w': {
            timeResolution: {
                unit: 'day',
                increment: 1
            },
            headers: [
                {
                    unit: 'month',
                    dateFormat: 'MMM YY'
                },
                {
                    unit: 'day',
                    dateFormat: 'DD'
                }
            ],
            tickWidth: Math.round(150 * scale),  // Scaled tick width for week view
        },
        'm': {
            timeResolution: {
                unit: 'day',
                increment: 1
            },
            headers: [
                {
                    unit: 'month',
                    dateFormat: 'MMMM YYYY'
                },
                {
                    unit: 'day',
                    dateFormat: 'DD'
                }
            ],
            tickWidth: Math.round(37 * scale),  // Scaled tick width for month view
        },
        'q': {
            timeResolution: {
                unit: 'day',
                increment: 1
            },
            headers: [
                {
                    unit: 'quarter',
                    renderer: (startDate, endDate) => `Q${Math.ceil(Number(dateFormat(startDate, 'm')) / 3)} ${dateFormat(startDate, 'yyyy')}`
                },
                {
                    unit: 'month',
                    dateFormat: 'MMM YYYY'
                }
            ],
            tickWidth: Math.round(380 * scale),  // Scaled tick width for quarter view
        },
        'h': {
            timeResolution: {
                unit: 'day',
                increment: 1
            },
            headers: [
                {
                    unit: 'quarter',
                    renderer: (startDate, endDate) => `H${startDate.getMonth() < 6 ? 1 : 2} ${startDate.getFullYear()}`
                },
                {
                    unit: 'month',
                    dateFormat: 'MMM'
                }
            ],
            tickWidth: Math.round(380 * scale),  // Scaled tick width for half-year view
        },
        'y': {
            timeResolution: {
                unit: 'day',
                increment: 1
            },
            headers: [
                {
                    unit: 'year',
                    dateFormat: 'YYYY'
                },
                {
                    unit: 'quarter',
                    renderer: (startDate, endDate) => {
                        return 'Q' + Math.ceil((startDate.getMonth() + 1) / 3);
                    }
                },
                {
                    unit: 'month',
                    dateFormat: 'MMM'
                }
            ],
            tickWidth: Math.round(100 * scale),  // Scaled tick width for year view
        }
    };

    return presets[presetKey] || presets['m'];  // Default to month if no match
}
const messageCodeMap = {
    datesBeforeBatch: 1,
    startDateBeforeBatchStart: 2,
    endDateAfterBatchEnd: 3,
    endDateAfterBatchMissingStartDate: 4,
    datesOutsideBatch: 5,
    datesAfterBatch: 6,
    endDateBeforeBatchMissingStartDate: 7,
    missingBothDates: 8,
    onlyStartDateAfterBatchEnd: 9,
    onlyEndDateMissingStartDate: 10,
    onlyStartDateBeforeBatchStart: 11
};
let shadedItemsMessageCodes = [3,6,5,4,11]

var roadmapVue;

function CustomDragHelper1(config) {
    bryntum.schedulerpro.DragHelper.call(this, config);
}
function generateColorFromStatus(item){
    if(item.status && item.status.category){
        if(item.status.category === "Done"){
            return "#3FCA93";
        }else if(item.status.category === "InProgress"){
            return "#3792C9";
        }else if(item.status.category === "ToDo"){
            return "#E79362";
        }else{
            return "#7c50b1";
        }
    }
    return "#DBC3E6";
}
function readServerStreamdata(response,callback,endCallback,dataPassedToCallback) {
    const reader = response.body.getReader();
    let decoder = new TextDecoder();
    let buffer = '';

    function readChunk() {
        reader.read().then(({done, value}) => {
            if (done) {
                console.log('Stream complete');
                // Handle any remaining buffer data
                endCallback(buffer,dataPassedToCallback);
                return;
            }

            // Decode the chunk
            let chunk = decoder.decode(value, {stream: true});
            buffer += chunk;
            // console.log('Received chunk:', chunk);

            // Find the end of the JSON object
            let jsonEndIndex = buffer.indexOf('\n');
            while (jsonEndIndex > 0) {
                let jsonData = buffer.substring(0, jsonEndIndex);
                buffer = buffer.substring(jsonEndIndex + 1);
                callback(jsonData,dataPassedToCallback);
                jsonEndIndex = buffer.indexOf('\n');
            }

            // Read the next chunk
            readChunk();
        });
    }
    readChunk();

}
function generateKey(item){
    if(item.almKey){
        return item.almKey;
    }
    if (item.tfsId) {
        return item.tfsId;
    }
    if (item.jiraId) {
        return item.jiraKey;
    }
    else if (item.kendisKey) {
        return item.kendisKey;
    }
    else if (item.jiraKey) {
        return item.jiraKey;
    }
    return "";
}
function checkChildrenAreCovered(newStartDate,newEndDate,childrenBatches,scheduler){
    if(!childrenBatches || childrenBatches.length === 0){
        return true;
    }
    let minStartDate = new Date(newStartDate.getTime());
    let maxEndDate = new Date(newEndDate.getTime());
    childrenBatches.forEach(childEventId => {
        let childEvent = scheduler.eventStore.getById(childEventId);
        if (childEvent.startDate < minStartDate) {
            minStartDate = childEvent.startDate;
        }
        if (childEvent.endDate > maxEndDate) {
            maxEndDate = childEvent.endDate;
        }
    });
    return !(minStartDate < newStartDate || maxEndDate > newEndDate);
}
function getItemStatusClass(item){
    try {
        let itemStatus = item.status
        if (!itemStatus || !itemStatus.category) {
            return 'd';
        } else if (itemStatus.category === 'ToDo') {
            return 'a';
        } else if (itemStatus.category === 'InProgress') {
            return 'b';
        } else if (itemStatus.category === 'Done') {
            return 'c';
        } else {
            return 'd';
        }
    }
    catch (e) {
        return 'd';
    }
}
async function modifyBatchDates(batchEventRecord, startDate, endDate) {
    startDate.setHours(0);
    startDate.setMinutes(1);
    startDate.setSeconds(1);
    endDate.setHours(23);
    endDate.setMinutes(59);
    endDate.setSeconds(59);
    let batchId = ParentIdUtils.getBatchId(batchEventRecord.id);
    const isSuccess = await persistBatchDates(batchId, startDate, endDate);
    if (isSuccess) {
        if (fixDates) {
            adjustBatchParentsDates(roadmapVue.$options.roadmap, batchEventRecord.id, startDate, endDate);
        }
        modifyOriginalDatesOfParents(roadmapVue.$options.roadmap, batchEventRecord.id, startDate, endDate);
    }
}
function updateBatchesMap(updatedBatch){
    try{
        if(roadmapVue){
            let batch = roadmapVue.batchesMap[updatedBatch.id];
            if(batch){
                let copyBaseItemList = _.cloneDeep(batch.baseItemList);
                roadmapVue.batchesMap[updatedBatch.id]= updatedBatch;
                if(copyBaseItemList){
                    updatedBatch.baseItemList = copyBaseItemList;
                }
            }
        }
    }
    catch (e) {
        console.log(e);
    }
}
async function addBatchBaseItemLinks(batch,newItems,releaseTrainId){
    try {
        newItems && batch && newItems.forEach(item =>
            batch.baseItemLinks.push({
                    baseItemId: item.id,
                    linkType: BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM,
                    releaseTrainId: releaseTrainId
                }
            ));
    }catch (e) {
        console.log(e);
    }
}
CustomDragHelper1.prototype = Object.create(bryntum.schedulerpro.DragHelper.prototype);
CustomDragHelper1.prototype.constructor = CustomDragHelper1;
CustomDragHelper1.prototype.createProxy = function(element) {};
const roadMapStartDate = new Date(2023, 0, 1);
const roadMapEndDate = new Date(2028, 11, 31);
const useTimeCapsules = true;
const resourceRowHeight = 100;
const barMargin =20;
const ROADMAP_BAR_HEADERS = [
    { unit: 'w', increment: 1, renderer: formateTimlineW },
    { unit: 'day', increment: 1, renderer: formateTimlineDD }
];
const ROADMAP_PRESET = {
        base: 'weekAndDay',
        tickWidth: 30,
        rowHeight: 100,
        shiftIncrement: 1,
        shiftUnit: 'week',
        timeResolution: { unit: 'd', increment: 1 },
        defaultSpan: 1,
        mainHeaderLevel: 1,
        headers: ROADMAP_BAR_HEADERS
}
const defaultResourceRowHeight = 150;
const defaultResourceRowHeightMinimized = 90;
const showArchivedItems = false;
const enableBatchPlanningSearch = true;
/**
 * Filters or clears filters for events in the Bryntum Scheduler based on tags and event types.
 * Adds a named filter if tags are provided, and removes it if tags are empty.
 * @param {Scheduler} scheduler - The Bryntum Scheduler instance.
 * @param {Array} tags - The list of tags to filter the events by. Tags can match either the 'key' or 'name' of the events.
 * @param {Array} eventTypes - The types of events to filter, e.g., ['Batch', 'BatchGroup'].
 * @param roadMapVueComp
 */
function filterOrClearEvents(scheduler, tags, eventTypes = [EventTypes.BATCH_GROUP,EventTypes.BATCH], roadMapVueComp) {
    const eventStore = scheduler.eventStore;
    const filterId = 'tagTypeFilterWithChildren';
    if (!tags || tags.length === 0) {
        eventStore.removeFilter(filterId);
        return;
    }
    eventStore.filter({
        id: filterId,
        filterBy: function (event) {
            function matchesTags(event) {
                if(event.type === EventTypes.ITEM){
                    let item  = roadMapVueComp.itemsByIdMap[ChildIdUtils.getItemId(event.id)]
                    let key = generateKey(item);
                    for(let tag of tags){
                        if(tag.id) {
                            if (tag.id === item.id) {
                                return true;
                            }
                            continue;
                        }
                        if ( item.title.toLowerCase().includes(tag.title) || key.toLowerCase().includes(tag.title)) {
                            return true;
                        }
                    }
                    return false;
                }else if(event.type === EventTypes.BATCH || event.type === EventTypes.BATCH_GROUP) {
                    for(let tag of tags){
                        if(tag.id) {
                            if (tag.id === event.orgId) {
                                return true;
                            }
                           continue;
                        }
                        if ( event.name.toLowerCase().includes(tag.title) || event.key.toLowerCase().includes(tag.title)) {
                            return true;
                        }
                    }
                    return false;
                }
                return false;
            }

            let matches = matchesTags(event);
            let children = eventStore.allRecords.filter(child => child.parentId === event.id);
            let childMatches  = children.some(child => matchesTags(child));
            if (matches || childMatches) {
                // Return true to include this parent and all its children
                return true;
            }
            return matches && eventTypes.includes(event.type);
        }
    });

}
/**
 * Recursively retrieves IDs of all child events for a given parent event.
 * @param {Object} scheduler - The scheduler object containing the events.
 * @param {Number} eventId - The ID of the parent event.
 * @param {Set} collectedIds - A set to collect all child event IDs.
 */
/**
 * Recursively retrieves a map of parent event IDs to their direct children event IDs.
 * @param {Object} scheduler - The scheduler object containing the events.
 * @param {Number} eventId - The ID of the parent event.
 * @param {Object} parentToChildrenMap - A map to collect IDs of direct children for each parent.
 */
function mapParentToDirectChildrenIds(scheduler, eventId, parentToChildrenMap = {}) {
    // Get direct children IDs for the current event
    let directChildrenIds = getChildrenEventIds(scheduler, eventId); // Assume this function exists and fetches direct child IDs

    // Initialize the array for the current parent if it doesn't exist
    if (!parentToChildrenMap[eventId]) {
        parentToChildrenMap[eventId] = [];
    }

    // Process each child ID
    directChildrenIds.forEach(childId => {
        // Add child ID to the current parent's list if not already included
        if (!parentToChildrenMap[eventId].includes(childId)) {
            parentToChildrenMap[eventId].push(childId);

            // Recursive call to process children of the current child
            mapParentToDirectChildrenIds(scheduler, childId, parentToChildrenMap);
        }
    });

    return parentToChildrenMap;
}

/**
 * Filters events in the scheduler that are not dependant (i.e., not children or nested children) of a given parent event.
 * @param {Object} parentEvent - The parent event object.
 * @param {Object} scheduler - The scheduler object containing the events.
 */
function filterDependantEvents(parentEvent, scheduler) {
    let childrenEventIds = new Set();
    let map = mapParentToDirectChildrenIds(scheduler, parentEvent.id, childrenEventIds);
    hideDependantEventsForMap(map,parentEvent,scheduler)
    for(let key in map){
        scheduler.eventStore.filter({
            id: key,
            filterBy: (ev) => ev.parent?.id !== key
        });
        scheduler.eventStore.filter({
            id: key + "-dependant-filter",
            filter: event => {
                return !(map[key].includes(event.id));
            }
        });
    }
}
 function hideDependantEventsForMap(parentToChildrenMap,selectedEvent,scheduler){
    for(let key in parentToChildrenMap){
        if(selectedEvent.id === key){
            hideBatchItemsAndMinimize(scheduler,selectedEvent,scheduler.resourceStore.getById(selectedEvent.resourceId));
            continue;
        }
        let parentEvent = scheduler.eventStore.getById(key);
        if(parentEvent){
            parentEvent.showDependantEvents = false
            hideBatchItemsAndMinimize(scheduler,parentEvent,scheduler.resourceStore.getById(parentEvent.resourceId));
        }
    }
}

/**
 * Filters nested child events of the parentEventRecord and shorten the height
 * @param schedule
 * @param parentEventRecord
 * @param resourceRecord
 */
function hideBatchItemsAndMinimize(schedule,parentEventRecord,resourceRecord){
    try {
        if (!parentEventRecord || !resourceRecord || !schedule) {
            console.log("parentEventRecord or resourceRecord or schedule is not available");
            throw new Error('Something went wrong');
        }
        let parentEventElement = document.querySelector(`[data-event-id="${parentEventRecord.id}"]`); // Adjust this selector based on your actual event id attribute
        if(parentEventElement)
            parentEventElement.style.height = defaultResourceRowHeightMinimized + 'px';

        schedule.eventStore.filter({
            id: parentEventRecord.id,
            filterBy: (ev) => ev.parent?.id !== parentEventRecord.id
        });
        parentEventRecord.isChildrenToggled = true;
        parentEventRecord.cls = ["kendis-roadmap-planned-batch-event","roadmap-batch-close"]
        //change height of parent event

        //check if all the resourceRecord evnets are closed
        if (checkResourceParentsAreExpanded(resourceRecord)) {
            resourceRecord.rowHeight = defaultResourceRowHeight;
        }
        schedule.refresh();
    }catch (e) {
        throw e;
    }
}
function showBatchItemsAndMaximize(schedule,parentEventRecord,resourceRecord){
    try {
        schedule.eventStore.removeFilter(parentEventRecord.id);
        parentEventRecord.isChildrenToggled = false;
        parentEventRecord.cls = ["kendis-roadmap-planned-batch-event","roadmap-batch-open"]

        // let defaultHeight = _this.$options.roadmap.rowHeight -50;
        // parentEventElement.style.height = defaultHeight + 'px';
        if (resourceRecord.rowHeight !== 500) {
            resourceRecord.rowHeight = 500;
        }
    }catch (e) {
        console.log(e)
        showTopMessage("Error while expanding batch items. Please reload", "error");
    }
}


function createCollectionGridItem(item) {

    item.orgId = item.id;
    // this.setRequiredProppertiesOfItem(item);

    //......   set dates
    if (item._fields && item._fields.StartDate && item._fields.EndDate) {
        if (item._fields.StartDate) {
            item.startDate = new Date(item._fields.StartDate);
        }
        if (item._fields.EndDate) {
            item.endDate = new Date(item._fields.EndDate);
        }
    }

    if(item.almFields && this.almFieldsMap){
        item.custFields={}
        for(let key in item.almFields){
            if(this.almFieldsMap[key] && this.almFieldsMap[key].name){
                item["Custom_"+(this.almFieldsMap[key].name).replaceAll(/ /g,'')] = item.almFields[key];
            }
        }

    }
    return item;
}
function showDependantEvents(parentEvent, scheduler) {
    scheduler.eventStore.removeFilter(parentEvent.id+"-dependant-filter");
    // parentEvent.showDependantEvents = true;
}

function checkResourceParentsAreExpanded(resourceRecord) {
    // Filter events to only include those of type BATCH or BATCH_GROUP using native filter method
    let resourceRecordBatchEvents = resourceRecord.events.filter(event =>
        event.type === EventTypes.BATCH || event.type === EventTypes.BATCH_GROUP
    );

    // Iterate over filtered events using a for loop to allow early return
    for (let i = 0; i < resourceRecordBatchEvents.length; i++) {
        if (!resourceRecordBatchEvents[i].isChildrenToggled) {
            return false; // Return true as soon as an expanded event is found
        }
    }

    // If no expanded event is found, return false
    return true;
}
//create enum
const styledClasses = {
    schedulerColumnName:"kendis-scheduler-column-name",
    unplannedBatchEvent:"kendis-roadmap-unplanned-batch-event",
    plannedBatchEvent:"kendis-roadmap-planned-batch-event",
    highlightedItem:"kendis-roadmap-highlighted-item",
    rawViewPlannedItems:"kendis-roadmap-planned-event-dm-items",
    rawViewUnplannedItems:"kendis-roadmap-unplanned-event-dm-items",
    bucketChildPlanned:"kendis-roadmap-bucket-child-planned",
    bucketChildUnplanned:"kendis-roadmap-bucket-child-unplanned",
    timeCapsuleBucket:"kendis-roadmap-time-capsule-bucket",
    batchContainerEventParent:"kendis-batch-container-event-parent",
    batchContainerEventChild:"kendis-batch-container-event-child",
    batchContainerEventChildFaultDate:"kendis-class-batch-container-event-child-fault-date",
    dateChangePopup:"kendis-date-change-popup",
    resourceForBatchLevel : "kendis-resource-for-batch-level",
    collectionItemUnplanned:"kendis-collection-item-unplanned",
    collectionGrid:"kendis-collection-items-grid",
    newDraggedItem:"kendis-new-dragged-item",
    greyedOutItem:"kendis-greyed-out-item",
    shadedItemEnd : "kendis-shaded-item-end",

}
const ALM_ACCOUNT_TYPES={
    TFS : "tfs",
    JIRA:"jira",
}
const localStorageKeys = {
   selectedYearWiseTimeCapsules: "_selectedYearWiseTimeCapsules",
}
const EventTypes = {
    BATCH: 'batch',
    BATCH_GROUP: 'batchGroup',
    ITEM: 'item',
    TIME_CAPSULE: 'timeCapsule'
};
const DisplayModes = {
    BATCHES: 'batches',
    BUCKETS: "itemsInTimePeriods",
    RAW_ITEMS:"items"
}
function isQuarter(start, end) {
    // Create date objects from the input
    const startDate = new Date(start);
    const endDate = new Date(end);

    // Check if start date is the first day of the month
    if (startDate.getDate() !== 1) return false;

    // Check if end date is the last day of a month
    const lastDayOfMonth = new Date(endDate.getFullYear(), endDate.getMonth() + 1, 0).getDate();
    if (endDate.getDate() !== lastDayOfMonth) return false;

    // Calculate the month difference between start and end dates
    const monthDiff = (endDate.getMonth() - startDate.getMonth()) + (12 * (endDate.getFullYear() - startDate.getFullYear()));

    // Check if the month difference is 2 (forming a complete quarter)
    if (monthDiff !== 2) return false;

    // Check if the start date is the beginning of a quarter
    const quarters = [0, 3, 6, 9]; // Months are 0-indexed (January is 0)
    if (!quarters.includes(startDate.getMonth())) return false;

    // If all checks pass, the dates form a complete quarter
    return true;
}
function isHalfYear(start, end) {
    // Create date objects from the input
    const startDate = new Date(start);
    const endDate = new Date(end);

    // Check if start date is the first day of the month
    if (startDate.getDate() !== 1) return false;

    // Check if end date is the last day of a month
    const lastDayOfMonth = new Date(endDate.getFullYear(), endDate.getMonth() + 1, 0).getDate();
    if (endDate.getDate() !== lastDayOfMonth) return false;

    // Calculate the month difference between start and end dates
    const monthDiff = (endDate.getMonth() - startDate.getMonth()) + (12 * (endDate.getFullYear() - startDate.getFullYear()));

    // Check if the month difference is 5 (forming a complete half year)
    if (monthDiff !== 5) return false;

    // Check if the start date is the beginning of a half year
    const halfYears = [0, 6]; // Months are 0-indexed (January is 0)
    if (!halfYears.includes(startDate.getMonth())) return false;

    // If all checks pass, the dates form a complete half year
    return true;

}
function isYear(start, end) {
    // Create date objects from the input
    const startDate = new Date(start);
    const endDate = new Date(end);

    // Check if start date is the first day of the month
    if (startDate.getDate() !== 1) return false;

    // Check if end date is the last day of a month
    const lastDayOfMonth = new Date(endDate.getFullYear(), endDate.getMonth() + 1, 0).getDate();
    if (endDate.getDate() !== lastDayOfMonth) return false;

    // Calculate the month difference between start and end dates
    const monthDiff = (endDate.getMonth() - startDate.getMonth()) + (12 * (endDate.getFullYear() - startDate.getFullYear()));

    // Check if the month difference is 11 (forming a complete year)
    if (monthDiff !== 11) return false;

    // Check if the start date is the beginning of a year
    if (startDate.getMonth() !== 0) return false;

    // If all checks pass, the dates form a complete year
    return true;
}
function daysBetweenDates(date1, date2) {
    // Parse both dates as Date objects if they're not already
    const startDate = (date1);
    const endDate = (date2);

    // Calculate the difference in milliseconds
    const differenceInMilliseconds = endDate - startDate;

    // Convert milliseconds to days
    // (1000 milliseconds = 1 second, 60 seconds = 1 minute, 60 minutes = 1 hour, 24 hours = 1 day)
    const differenceInDays = differenceInMilliseconds / (1000 * 60 * 60 * 24);

    // Return the absolute value to avoid negative values if dates are swapped
    return Math.abs(differenceInDays);
}
function hexToRgb(hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
}
function lightenHexColor(hex, amount,opacity) {
    // Remove the '#' if it's there
    hex = hex.replace(/^\s*#|\s*$/g, '');

    // Convert the hex string to RGB
    let r = parseInt(hex.substring(0, 2), 16);
    let g = parseInt(hex.substring(2, 4), 16);
    let b = parseInt(hex.substring(4, 6), 16);

    // Increase each component by the amount and cap it at 255
    r = Math.min(255, r + amount);
    g = Math.min(255, g + amount);
    b = Math.min(255, b + amount);
    return  `rgb(${r}, ${g}, ${b}, ${opacity})`;
}
function createDynamicTimeRangeStyles(timeRanges) {
    // Create a style element
    const style = document.createElement('style');
    style.type = 'text/css';

    // Generate CSS rules for each TimeRange
    let cssRules = '';
    timeRanges.forEach(range => {
        const className = `.b-grid-header .b-sch-timeranges-canvas .time-range-${range.id}`; // Generate a unique class name based on the TimeRange ID or name
        const textColor = range.textColor; // Assume each range has a textColor property
        const bgColor = range.bgColor; // Assume each range has a bgColor property
        //convert bgColor to rgb
        const rgb = hexToRgb(bgColor);
        //rgb to string
        const rgbString = `rgb(${rgb.r}, ${rgb.g}, ${rgb.b}, 0.5)`;


        // Create CSS rule
        cssRules += `
            ${className} {
                color: ${textColor} !important;
                background-color: ${rgbString} !important;
                
            
            }
        `;
    });

    // Add the generated rules to the style element
    if (style.styleSheet) {
        // This is required for IE8 and below.
        style.styleSheet.cssText = cssRules;
    } else {
        style.appendChild(document.createTextNode(cssRules));
    }

    // Inject the style element into the head of the document
    document.head.appendChild(style);
}
function createFieldMap(fieldList){
    let fieldsMap = {};
    if( fieldList && fieldList.length > 0) {
        fieldList.forEach(function (field) {
            fieldsMap[field.id] = {}
            fieldsMap[field.id].title = field.title;
            fieldsMap[field.id].type = field.type;
        })
    }
    return  fieldsMap;
}
function getStartDateFromFields(fields, fieldMap){
    let startDate = undefined;
    if(fields){
        for(let fieldId in fields){
            if(fieldMap[fieldId] && fieldMap[fieldId].title && fieldMap[fieldId].title === 'Start Date'){
                startDate = fields[fieldId];
                //convert to date
                startDate = new Date(startDate);
                return startDate;
            }
        }

    }
    return startDate;
}
function getEndDateFromFields(fields, fieldMap){
    let endDate = undefined;
    if(fields){
        for(let fieldId in fields){
            if(fieldMap[fieldId] && fieldMap[fieldId].title && fieldMap[fieldId].title === 'End Date'){
                endDate = fields[fieldId];
                //convert to date
                endDate = new Date(endDate);
                return endDate;
            }
        }
    }
    return endDate;
}
// Function to find the earliest start date among children
function getDefaultDate() {
    return new Date(); // Returns today's date
}
function adjustEventHeight(scheduler,eventRecord, eventElement, expand) {
    if (expand) {
        // Example: Set height based on the number of nested events
        // This could involve calculating the total height needed to display all nested events
        const nestedEvents = eventRecord.children;
        if(!nestedEvents || nestedEvents.length === 0){
            eventElement.style.height = `100px`;

        }else {
            const totalHeight = nestedEvents.length * 60;  // Assuming each nested event needs 30px of height
           if(totalHeight > 500){
               eventElement.style.height = `500px`;

           }else {
               eventElement.style.height = `${totalHeight}px`;
           }
        }
    } else {
        // Reset to default height
        eventElement.style.height = '';  // Remove the inline style to revert to the original CSS-defined height
    }

    scheduler.refresh();  // Refresh the scheduler view to apply changes
}
function createBatchResourcesEvents(batches, fieldMap, itemMap) {
    let resources = [];
    let events = [];
    let assignments = [];
    let dependencies = [];

    try {
        if (batches) {
            _.each(batches, batchGroup => {
                // Recurse with the top-level resource ID starting from level 0
                updateResourcesEventsAssignmentsForBatchGroup(batchGroup.id, batchGroup, fieldMap, itemMap, resources, events, assignments, dependencies, 0,undefined,batchGroup);
            });
        }
    } catch (e) {
        console.error(e);
    }

    return { resources, events, assignments, dependencies };
}
function getFormattedDate(date){
    return  date.toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'short',
        day: 'numeric'
    });
}

//ID UTILS////
class ParentIdUtils
{
    static creatBatchEventId(resourceId, batchId) {
        return   "event_" +resourceId+"_"+ batchId;
    }
    static getBatchId(eventId) {
        return eventId.split("_")[2];
    }
    static getResourceId(eventId) {
        return eventId.split("_")[1];
    }
}
class ChildIdUtils
{
    static createLinkedItemEventId(itemId, batchId) {
        return "event_" + getNewUUID() + "_" + itemId + "_" + batchId;
    }
    static getItemId(eventId) {
        return eventId.split("_")[2];
    }
    static getBatchId(eventId) {
        return eventId.split("_")[3];
    }
}
//ID UTILS////
function differenceInDays(date1, date2) {
    // Convert input to Date objects if they are not already
    const d1 = new Date(date1);
    const d2 = new Date(date2);

    // Get the timestamp for each date
    const timestamp1 = d1.getTime();
    const timestamp2 = d2.getTime();

    // Calculate the difference in milliseconds
    const differenceInMilliseconds = Math.abs(timestamp2 - timestamp1);

    // Convert milliseconds to days
    const millisecondsInOneDay = 1000 * 60 * 60 * 24;
    const differenceInDays = differenceInMilliseconds / millisecondsInOneDay;

    return Math.floor(differenceInDays); // Use Math.floor to get the integer part
}

//create a method that assigns all the parent and children batches to a resource with resourceId as batch group id
function createBatchEventForBatchesView(resourceId, batch, fieldMap, itemMap, assignments,isNew,parentBatchEvent) {
    let batchStartDate = getStartDateFromFields(batch.fields, fieldMap);
    let batchEndDate = getEndDateFromFields(batch.fields, fieldMap);
    let batchStyleClass = "";
    let orgStartDate = batchStartDate? new Date(batchStartDate):undefined;
    let orgEndDate= batchEndDate? new Date(batchEndDate):undefined;

    if(!batchStartDate || !batchEndDate){
        if(parentBatchEvent){
            batchStartDate = new Date(parentBatchEvent.startDate);
            batchStartDate.setDate(batchStartDate.getDate() + 1); //add 1 day to start date (next day of parent batch end date
            batchEndDate = new Date(parentBatchEvent.endDate);
            batchEndDate.setDate(batchEndDate.getDate() -1); //subtract 1 day from end date (previous day of parent batch end date
        }else{
            //if start date or end date is not available then set start date as today and end date as 8 days from today
            batchStartDate = new Date();

            //add 8 days in batch start date
            batchEndDate = new Date(batchStartDate);
            batchEndDate.setDate(batchEndDate.getDate() + 90); //1.5 months

        }
        batchStyleClass = [styledClasses.unplannedBatchEvent,"roadmap-batch-close"]

    }else {
        batchStyleClass = [styledClasses.plannedBatchEvent,"roadmap-batch-close"];
    }
    batchStartDate.setHours(0);
    batchStartDate.setMinutes(1);
    batchStartDate.setSeconds(1);
    batchEndDate.setHours(23);
    batchEndDate.setMinutes(59);
    batchEndDate.setSeconds(59);
    // Create an event linked to the current batch
    return  {
        id: "event_" +resourceId+"_"+ batch.id, // Ensure unique event ID
        name: batch.title, // Use batch title for the event name
        startDate: batchStartDate,
        endDate: batchEndDate,
        orgStartDate: orgStartDate,
        orgEndDate: orgEndDate,
        resourceId: resourceId,
        children: [],
            manuallyScheduled: true, //disables shrinking once the children are removed
        type: EventTypes.BATCH,
        cls:batchStyleClass,
        orgId: batch.id,
        key: batch.key,
        isChildrenToggled: true,
        batchFields: batch.fields,
        showDependantEvents : true,
        status: batch.status,
    }
}
function generateStatusClass (status) {
    let result= "";
    if(status){
        result =  [status.category ==='ToDo' ? 'a' :
            (status.category === 'InProgress' ? 'b' :
                (status.category === 'Done' ? 'c':
                    'd'))];
    }
    return result;
}
function userImageOrInitialHtml (user, short) {

    var html = "";
    if (user && user.picturePath && (typeof agendaPublicShare =="undefined" || !agendaPublicShare)) {
        var imgPath = s3_resource_url + user.picturePath;
        html = '<img src="' + imgPath +'" alt="' + user.fullName + '" title="' + user.fullName + '" />';
    } else {
        if (user.fullName) {
            var initials = getInitials(user.fullName);
            html = '<div class="initial" style="background-color:' + user.backgroundColor +'" >' + initials + '</div>';
        }
    }
    if (short) {
        return html;
    }else {
        return html +" "+ user.fullName;
    }
}

//DFS algorithm
function updateResourcesEventsAssignmentsForBatchGroup(parentResourceId, batch, fieldMap, itemMap, resources, events,
                                                       assignments, dependencies, level, parentEvent,topParent) {
    // Create a new resource for the current level if it doesn't exist
    const resourceId = `${level}`;
    if (!resources.some(resource => resource.id === resourceId)) {
        resources.push({
            id: resourceId,  // Unique resource ID
            name: `Level ${level+1}`,
            expanded: true,
            children: [],
            cls: styledClasses.resourceForBatchLevel,
            topParentId: topParent.id,
            topParentName: topParent.title,
            rowHeight : defaultResourceRowHeight,
        });
    }

    let batchEvent = createBatchEventForBatchesView(resourceId, batch, fieldMap, itemMap, assignments, false,parentEvent);


    events.push(batchEvent);
    assignments.push({
        id: `assign_${batch.id}`, // Ensure unique assignment ID
        resourceId: resourceId,
        eventId: batchEvent.id
    });
    // Recurse into child batches
    if (batch.baseItemList) {

        let minDate = new Date(batchEvent.startDate);
        let maxDate = new Date(batchEvent.endDate);

        _.each(batch.baseItemList, childBatch => {

            let latestChildBatch   = roadmapVue.batchesMap[childBatch.id]

            //if event already exists , in case multi parent only add the dependency
            let existingEvent = events.find(event => ParentIdUtils.getBatchId(event.id) === childBatch.id);
            if (existingEvent) {
                dependencies.push({
                    id: `dep_${batch.id}_${latestChildBatch.id}`,  // Unique ID for the dependency
                    from: batchEvent.id,
                    to: existingEvent.id,
                    type: 2, // Finish-to-Start dependency
                    fromSide: 'bottom',
                    toSide: 'top',
                });
                // Fetch the event for the current child batch
                if (fixDates) {

                    let childEvent = existingEvent;
                    let childStartDate = new Date(childEvent.startDate);
                    let childEndDate = new Date(childEvent.endDate);

                    // Update the parent event's dates based on child dates
                    if (childStartDate < minDate) minDate = childStartDate;
                    if (childEndDate > maxDate) maxDate = childEndDate;
                }
                return;
            }

            //in case of single parent
            let childEventId = `event_${level + 1}_${latestChildBatch.id}`;
            dependencies.push({
                id: `dep_${batch.id}_${latestChildBatch.id}`,  // Unique ID for the dependency
                from: batchEvent.id,
                to: childEventId,
                type: 2, // Finish-to-Start dependency
                fromSide: 'bottom',
                toSide: 'top',
            });


            updateResourcesEventsAssignmentsForBatchGroup(resourceId, latestChildBatch, fieldMap, itemMap, resources, events, assignments, dependencies, level + 1,batchEvent,topParent);

            // Fetch the event for the current child batch
            if (fixDates) {

                let childEvent = events.find(e => e.id === childEventId);
                let childStartDate = new Date(childEvent.startDate);
                let childEndDate = new Date(childEvent.endDate);

                // Update the parent event's dates based on child dates
                if (childStartDate < minDate) minDate = childStartDate;
                if (childEndDate > maxDate) maxDate = childEndDate;
            }
        });

        // After processing children, update this batch's start and end dates
        if (fixDates) {
            batchEvent.startDate = minDate;
            batchEvent.endDate = maxDate;
        }
    }

    batchEvent.children = getItemsfromItemMap(resourceId, batch, batch, itemMap, batchEvent.startDate, batchEvent.endDate, assignments); // children are set once the new dates are known
}


function getResourceBelowId(resourceId,scheduler) {
    const resourceStore = scheduler.resourceStore;

    // Find the index of the current resource
    const currentIndex = scheduler.resourceStore.indexOf(resourceStore.getById(resourceId));
    const lastResource = resourceStore.getAt(currentIndex)
    // Get the next resource
    const nextIndex = currentIndex + 1;
    if (nextIndex < resourceStore.count) {
        return resourceStore.getAt(nextIndex).id;
    } else {
        // create new resource
        let newResource = {
            id : currentIndex+1,
            name: `Level ${currentIndex+2}`,
            expanded: true,
            children: [],
            cls: styledClasses.resourceForBatchLevel,
            topParentId: lastResource.topParentId,
            topParentName: lastResource.topParentName,
        }
        resourceStore.add(newResource);
        return newResource.id; // No resource below the current one
    }
}
function applyAlertToItemEvent(itemEvent,orgItemData){
    let parentEvent = itemEvent._parent;
    let {messageCode, message, itemStartDate, itemEndDate}= getMessageCodeForItem(orgItemData, parentEvent.startDate, parentEvent.endDate);

    itemEvent.setStartDate( itemStartDate);
    itemEvent.setEndDate(itemEndDate);
    itemEvent.originalData.messageCode = messageCode
    itemEvent.originalData.message = message
}
/*
* get message code, message & dates for item
 */
function getMessageCodeForItem(item, batchStartDate, batchEndDate) {
    let itemStartDate;
    let itemEndDate;
    let message = "";
    let messageCode = 0;
    let formattedBatchStartDate =  getFormattedDate(batchStartDate)
    let formattedBatchEndDate = getFormattedDate(batchEndDate)
    try {
        if (fixDates) {
            if (item.fields && item.fields.StartDate && item.fields.EndDate) {
                itemStartDate = new Date(item.fields.StartDate);
                itemEndDate = new Date(item.fields.EndDate);

                if (isLessThan(itemStartDate, batchStartDate) && isLessThan(itemEndDate, batchStartDate)) {
                    messageCode = 1;
                    message = `<div class='kendis-tooltip-roadmap-date-issue redtxt'> 
                        Item dates are before Batch Date Range (${formattedBatchStartDate} - ${formattedBatchEndDate})
                    </div>`;
                    itemStartDate = new Date(batchStartDate);
                    itemEndDate = new Date(batchEndDate);
                } else if (isGreaterThan(itemStartDate, batchEndDate) && isGreaterThan(itemEndDate, batchEndDate)) {
                    messageCode = 6;
                    message = `<div class='kendis-tooltip-roadmap-date-issue redtxt'> 
                        Item dates are after Batch Date Range (${formattedBatchStartDate} - ${formattedBatchEndDate})
                    </div>`;
                    itemStartDate = new Date(batchStartDate);
                    itemEndDate = new Date(batchEndDate);
                } else if (isLessThan(itemStartDate, batchStartDate) && isGreaterThan(itemEndDate, batchEndDate)) {
                    messageCode = 5;
                    message = `<div class='kendis-tooltip-roadmap-date-issue redtxt'> 
                        Item dates are outside Batch Date Range (${formattedBatchStartDate} - ${formattedBatchEndDate})
                    </div>`;
                    itemStartDate = new Date(batchStartDate);
                    itemEndDate = new Date(batchEndDate);
                } else if (isLessThan(itemStartDate, batchStartDate)) {
                    messageCode = 2;
                    message = `<div class='kendis-tooltip-roadmap-date-issue redtxt'>
                        Item StartDate is smaller than Batch StartDate (${formattedBatchStartDate} - ${formattedBatchEndDate})
                    </div>`;
                    itemStartDate = new Date(batchStartDate);
                } else if (isGreaterThan(itemEndDate, batchEndDate)) {
                    messageCode = 3;
                    message = `<div class='kendis-tooltip-roadmap-date-issue redtxt'>
                        Item EndDate is greater than Batch EndDate (${formattedBatchStartDate} - ${formattedBatchEndDate})
                    </div>`;
                    itemEndDate = new Date(batchEndDate);
                }
            } else if (item.fields && item.fields.StartDate) {
                itemStartDate = new Date(item.fields.StartDate);
                itemEndDate = new Date(item.fields.StartDate);
                messageCode = 9;
                message = `Item end date is missing`;
                itemEndDate = new Date(batchEndDate);
                if (isLessThan(itemStartDate, batchStartDate)) {
                    message += ` and start date is before batch start date (${formattedBatchStartDate} - ${formattedBatchEndDate})`;
                    itemStartDate = new Date(batchStartDate);
                } else if (isGreaterThan(itemStartDate, batchEndDate)) {
                    messageCode = 11;
                    message += ` and start date is after batch end date (${formattedBatchStartDate} - ${formattedBatchEndDate})`;
                    itemStartDate = new Date(batchStartDate);
                }
            } else if (item.fields && item.fields.EndDate) {
                itemStartDate = new Date(item.fields.EndDate);
                itemEndDate = new Date(item.fields.EndDate);
                messageCode = 10;
                message = `Item start date is missing`;
                itemStartDate = new Date(batchStartDate);
                if (isGreaterThan(itemEndDate, batchEndDate)) {
                    messageCode = 4;
                    message += ` and end date is after batch end date (${formattedBatchStartDate} - ${formattedBatchEndDate})`;
                    itemEndDate = new Date(batchEndDate);
                } else if (isLessThan(itemEndDate, batchStartDate)) {
                    messageCode = 7;
                    message += ` and end date is before batch start date (${formattedBatchStartDate} - ${formattedBatchEndDate})`;
                    itemEndDate = new Date(batchEndDate);
                }
            } else {
                messageCode = 8;
                message = `Item start and end dates are missing, item will be adjusted to batch dates (${formattedBatchStartDate} - ${formattedBatchEndDate})`;
                itemStartDate = new Date(batchEndDate); // Start from the end of the batch

// Calculate 25% interval from the end of the batch
                const interval = (batchEndDate - batchStartDate) * 0.25;
                itemStartDate = new Date(batchEndDate.getTime() - interval); // Set start date 25% before the batch end date
                itemEndDate = new Date(batchEndDate); // Set end date at the end of the batch
            }
        }
    } catch (e) {
        showTopMessage("Error while adjusting item dates", "error");
        console.error(e);
    }
    itemStartDate.setHours(0);
    itemStartDate.setMinutes(1);
    itemStartDate.setSeconds(1);
    itemEndDate.setHours(23);
    itemEndDate.setMinutes(59);
    itemEndDate.setSeconds(59);
    return {messageCode, message, itemStartDate, itemEndDate};
}
function generateStyledClassForItem(messageCode, isNew) {
    let classes = [];
    if(isNew){
        classes.push(styledClasses.newDraggedItem);
    }
    if(messageCode === messageCodeMap.missingBothDates){
        classes.push(styledClasses.greyedOutItem);
    }else if( shadedItemsMessageCodes.includes(messageCode)){
        classes.push(styledClasses.shadedItemEnd);
    }
    return classes
}

function createItemEventForBatchesView(item, batchEndDate,batchStartDate,resourceId,batchId,isNew) {
    let itemEvent;
    let itemAssignment;

    if (item) {
        let {messageCode, message, itemStartDate, itemEndDate}= getMessageCodeForItem(item, batchStartDate, batchEndDate);
        itemEndDate.setHours(23);
        itemEndDate.setMinutes(59);
        itemEndDate.setSeconds(59);
        let uniqueEventId = ChildIdUtils.createLinkedItemEventId(item.id,batchId);
        itemEvent = {
            id: uniqueEventId, // UUID is used to make each item separate as Bryntum doesn't allow duplicate events
            name: item.title,
            startDate: itemStartDate,
            endDate: itemEndDate,
            // duration : itemEndDate-itemStartDate / (1000 * 60 * 60 * 24),
            type: EventTypes.ITEM,
            messageCode: messageCode,
            message: message,
            orgId : item.id,
            orgItemData: _.cloneDeep(item),
            cls: generateStyledClassForItem(messageCode,isNew),
        };
        // Assign the item to the correct level resource based on whether it's a top-level batch
        itemAssignment={
            id: "assign_" + uniqueEventId,
            resourceId:resourceId, // Use generic level-based resource ID
            eventId: uniqueEventId
        };
    }
    return {itemEvent, itemAssignment};
}

function isItemArchivedFromAllCollections(item){
    if(item.artRelationMap){
        for(let artId in item.artRelationMap){
            if(item.artRelationMap[artId].rowStatus === 0){
                return false;
            }
        }
    }
    return true;
}
function isItemArchivedFromAllCollectionsAttachedToBatch(item,baseItemLinks,showMessage){

    let attachedCollectionIds = baseItemLinks.filter(
        baseItemLink => baseItemLink.linkType === BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM
            && baseItemLink.baseItemId === item.id)
        .map(baseItemLink => baseItemLink.releaseTrainId);
    if(attachedCollectionIds.length === 0){
        return false;
    }
    if(item.artRelationMap){
        for(let artId of attachedCollectionIds){
            if(item.artRelationMap[artId] && item.artRelationMap[artId].rowStatus === 0){
                return false;
            }
        }
    }
    if(showMessage){
        showTopMessage(`Item ${item.title} is already attached but archived in collection`, "warning");
    }
    return true;
}

function getItemsfromItemMap(resourceId, parentBatch, childBatch, itemMap, batchStartDate, batchEndDate, assignments) {
    let itemEvents = [];
    if (childBatch.baseItemLinks) {
        childBatch.baseItemLinks.filter(baseItemLink => (baseItemLink.linkType === BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM))
            .forEach(
                function (baseItemLink) {
                    let item = itemMap[baseItemLink.baseItemId];

                    if(!showArchivedItems && isItemArchivedFromAllCollectionsAttachedToBatch(item,childBatch.baseItemLinks)){
                      return;
                    }
                    let {itemEvent, itemAssignment} =  createItemEventForBatchesView(item, batchEndDate, batchStartDate,resourceId,childBatch.id);
                    if(itemEvent && itemEvent){
                        itemEvents.push(itemEvent);
                        assignments.push(itemAssignment);
                    }

                });
    }
    //remove duplicate eventsbased on orgId
    itemEvents = _.uniqBy(itemEvents, 'orgId');
    return itemEvents;
}
function findInMapByAttributeValue(map, attribute, value) {
    for (let key in map) {
        if (map[key][attribute] === value) {
            return map[key];
        }
    }
    return null;
}

async function loadRoadmapBatchesData(scheduler) {
    try {
        // Fetch batch data
        const response = await axios.post('/batch/get-all-batches', {
            isTreeView: true,
            isListView: true,
            isFields: true,
        });

        if (response.status!==200) {
            throw new Error('Failed to fetch batches: ' + response.statusText);
        }
        const data =  response.data;
        console.log('Fetched batch data:', data);

        // Process fetched data
        let itemIds = fetchBatchesItemIds(data.batches);
        let reqData = {
            itemIds: Array.from(itemIds)
        };

        // Fetch items by IDs
        const itemsResponse = await axios.post('/releasetrain/get/items-by-ids', reqData);
        // if (!itemsResponse.data.success) {
        //     throw new Error('Error retrieving items: ' + (itemsResponse.data.message || 'Unknown error'));
        // }

        let items = itemsResponse.data.items;
        let itemMap = items.reduce((acc, item) => {
            acc[item.id] = item;
            return acc;
        }, {});

        // Generate scheduler data
        // reDrawBatchEvents(scheduler, data.batches, itemMap, data.fieldList);

        return {
            fetchedBatchGroups: data.batches,
            batchesLinkedItemsMap: itemMap,
            batchesFieldList: data.fieldList
        };
    } catch (error) {
        console.error('Error loading roadmap batches data:', error);
        throw error;  // Rethrow the error if you need to handle it further up the chain
    }
}
function reDrawBatchEvents(scheduler, fetchedBatchGroups, batchesLinkedItemsMap, batchesFieldList) {
    // Create a field map first to avoid recalculating it multiple times
    const fieldMap = createFieldMap(batchesFieldList);

    // Create resources, events, and assignments
    let {resources, events, assignments,dependencies} = createBatchResourcesEvents(fetchedBatchGroups, fieldMap, batchesLinkedItemsMap);
    console.log("-------------------------------------");
    console.log("ELEMENTS TO DRAW ON ROADMAP");
    // console.log("RESOURCES: " +JSON.stringify(resources));
    // console.log("EVENTS: " +JSON.stringify(events));
    // console.log("ASSIGNMENTS: " +JSON.stringify(assignments));
    console.log("-------------------------------------");

    // Suspend the scheduler's drawing operations
    scheduler.suspendRefresh();

    try {
        // Update resources
        scheduler.resourceStore.clear();
        resources.sort((a, b) => a.sequence - b.sequence); // Sort resources by sequence
        scheduler.resourceStore.add(resources);

        // Clear and add new events
        scheduler.eventStore.clear();
        scheduler.eventStore.add(events);

        // Clear and re-add assignments
        scheduler.assignmentStore.removeAll();
        scheduler.assignmentStore.add(assignments);
        scheduler.dependencyStore.data = dependencies;


    } catch (error) {
        console.error('Error updating the scheduler:', error);
    } finally {
        // Resume and force a refresh
        scheduler.resumeRefresh(true);

        //minimize the top parent
        try {
            for (let parentBatch of fetchedBatchGroups) {
                let batchEvent =
                    scheduler.eventStore.getById(ParentIdUtils.creatBatchEventId(0, parentBatch.id));
                filterDependantEvents(batchEvent, scheduler);
                batchEvent.showDependantEvents = false;
            }
        }catch (e) {
            console.log(e);
        }
    }
}


function fetchBatchesItemIds(batches) {
    let itemIds = new Set();  // Use a Set to automatically handle duplicate IDs

    // Recursive function to process each batch and its children
    function processBatch(batch) {
        if (batch.baseItemLinks) {
            let filteredLinks = batch.baseItemLinks.filter(baseItemLink => baseItemLink.linkType === BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM);
            for (let link of filteredLinks) {
                itemIds.add(link.baseItemId);  // Add each found ID to the set
            }
        }
        if (batch.baseItemList) {
            for (let childBatch of batch.baseItemList) {
                processBatch(childBatch);  // Recurse into child batches
            }
        }
    }

    // Start processing from the top-level batches
    for (let batch of batches) {
        processBatch(batch);
    }

    return itemIds;  // Return all collected IDs as a Set
}
function createRequestDataForBacklogItemsFetch(itemIds) {
    let data = {};
    data.rollupBatches = true;
    data.rollupSprints = true;
    data.rollupSprints = true;
    data.rollupStoryPointsArray = true;
    data.sortBy = "sequence";
    data.sortOrder = "1"
    data.requestId = getNewUUID();
    data.filter = {};
    data.filter.rules = [];
    data.filter.condition = "AND";
    data.loadStatuses = true;
    data.filter.rules.push({key: "itemIds", value: itemIds , type: "array", almType: "",});
    return data;
}
function zoomToCompleteTimeRange(scheduler, viewPreset, useCurrentDate) {
    console.log("center data:"+scheduler.state.zoomLevelOptions.centerDate);
    let startDate = useCurrentDate ? new Date() : scheduler.state.zoomLevelOptions.centerDate;
    let endDate = startDate
    const start = new Date(startDate);
    const end = new Date(endDate);

    // Adjust dates based on the current view preset
    switch (viewPreset) {
        case 'm':
            start.setDate(1); // Start of the month
            end.setMonth(end.getMonth() + 1, 0); // End of the month
            break;
        case 'q':
            start.setMonth(Math.floor(start.getMonth() / 3) * 3, 1); // Start of the quarter
            end.setMonth(Math.floor(end.getMonth() / 3) * 3 + 3, 0); // End of the quarter
            break;
        case 'y':
            start.setFullYear(start.getFullYear(), 0, 1); // Start of the year
            end.setFullYear(end.getFullYear() + 1, 0, 0); // End of the year
            break;
        case 'h':
            // Start of the half-year
            start.setMonth(start.getMonth() < 6 ? 0 : 6, 1);
            // End of the half-year
            end.setMonth(start.getMonth() < 6 ? 6 : 12, 0);
        case 'w':
            start.setDate(start.getDate() - start.getDay()); // Start of the week (Sunday)
            end.setDate(end.getDate() + (6 - end.getDay())); // End of the week (Saturday)
            break;
        default:
            console.error('Unsupported view preset');
            return;
    }

    // Zoom scheduler to the calculated time span
    let {minStartDate, maxEndDate} = calculateMaxMinDates();
    maxEndDate.setFullYear(maxEndDate.getFullYear() + 5);
    console.log("Setting span to :"+minStartDate+" - "+ maxEndDate   );
    scheduler.setTimeSpan(minStartDate,  maxEndDate);
    console.log('scrollToTime ->', start, end);
    scheduler.scrollToDate(start,{
        block: 'start',  // Aligns the target date at the start of the scheduler view
        animate: true   // Smooth scrolling animation
    });

    // scheduler.zoomToSpan({ startDate: start, endDate: end });
}
function calculateMaxMinDates() {
    let minStartDate = new Date();
    let maxEndDate = new Date();
    // Add a quarter to the maxEndDate
    maxEndDate = new Date(maxEndDate.setFullYear(maxEndDate.getFullYear() + 5));

    try {
        const allEvents = roadmapVue.$options.roadmap.eventStore.allRecords.filter(record =>
            !record.originalData.isHeader && record.originalData.groupId !== milestoneResourceId);

        if (allEvents.length === 0) {
            return { minStartDate, maxEndDate }; // No events to fit
        }

        // Initialize minStartDate and maxEndDate with copies of the dates from the first event
        minStartDate = new Date(allEvents[0].startDate);
        maxEndDate = new Date(allEvents[0].endDate);

        allEvents.forEach(event => {
            if (event.startDate < minStartDate) {
                minStartDate = new Date(event.startDate);
            }
            if (event.endDate > maxEndDate) {
                maxEndDate = new Date(event.endDate);
            }
        });
    } catch (e) {
        console.error("Error calculating max and min dates: ", e);
    }

    return { minStartDate, maxEndDate };
}
function zoomToCurrentDate(scheduler){
    try {// Initialize current date
        const currentDate = new Date();

        // Calculate start and end dates
        const startDate = new Date();
        // startDate.setDate(currentDate.getDate() - 90); // 5 days before today

        const endDate = new Date();
        endDate.setDate(currentDate.getDate() + 90); // 5 days after today

        // Call zoomToSpan with the calculated dates
        scheduler.zoomTo({
            startDate: startDate,
            endDate: endDate,
        });
    }catch (e) {
        console.log(e)
    }
}

function fitSchedulerToEvents(scheduler) {
    console.log('fitSchedulerToEvents');
    // Use allRecords to include hidden or filtered records
    // Filter out header events and milestone resource events
    const allEvents = scheduler.eventStore.allRecords.filter(record => {
        // Check for header events using multiple possible identifiers
        const isHeaderEvent = record.get('isHeader') || 
                             record.originalData?.isHeader || 
                             record.originalData?.isHeader === true;
        
        // Check for milestone resource events
        const isMilestoneEvent = record.originalData?.groupId === milestoneResourceId || 
                                record.resourceId === milestoneResourceId;
        
        // Include only non-header, non-milestone events
        return !isHeaderEvent && !isMilestoneEvent;
    });

    if (allEvents.length === 0) {
        console.log('No events to fit - all events are headers or milestones');
        return; // No events to fit
    }

    let minStartDate = allEvents[0].startDate;
    let maxEndDate = allEvents[0].endDate;

    allEvents.forEach(event => {
        if (event.startDate < minStartDate) {
            minStartDate = event.startDate;
        }
        if (event.endDate > maxEndDate) {
            maxEndDate = event.endDate;
        }
    });

    console.log(`Fitting to events from ${minStartDate} to ${maxEndDate} (${allEvents.length} events)`);

    // Add some padding to the date range for better visualization
    const padding = (maxEndDate - minStartDate) * 0.1; // 10% padding on each side
    const paddedStartDate = new Date(minStartDate.getTime() - padding);
    const paddedEndDate = new Date(maxEndDate.getTime() + padding);

    console.log(`Fitting with padding from ${paddedStartDate} to ${paddedEndDate}`);

    // Use zoomToSpan with animation disabled for consistent behavior
    try {
        scheduler.zoomToSpan({
            startDate: paddedStartDate,
            endDate: paddedEndDate,
            leftMargin: 30,
            rightMargin: 30,
            animate: false // Disable animation to prevent conflicts
        });
    } catch (error) {
        console.error('Error during zoomToSpan:', error);
        // Fallback to setTimeSpan if zoomToSpan fails
        scheduler.setTimeSpan(paddedStartDate, paddedEndDate);
    }
}
function copyItem(item) {
    let copy = { ...item };
    return copy;
}
function generateTimeCapsulesEvents(resourceId,timeCapsules){
    let timeCapsuleEvents = [];
    let assignmentstimeCapsulesAsignment = []
    try {
        timeCapsules.forEach(timeCapsule => {
            let timeCapsuleEvent = {
                id: "timeCapsule_" + timeCapsule.id+"_"+resourceId, // Ensure unique event ID
                name: timeCapsule.label,
                startDate: new Date(timeCapsule.startDate),
                endDate: new Date(timeCapsule.endDate),
                type: EventTypes.TIME_CAPSULE,
                eventColor: timeCapsule.bgColor,
                children:[],
                cls: styledClasses.timeCapsuleBucket,
            };
            timeCapsuleEvents.push(timeCapsuleEvent);

            // Assign the event to the current level's resource
            assignmentstimeCapsulesAsignment.push({
                id: "assign_timeCapsule_" + timeCapsule.id+ "_"+ resourceId, // Ensure unique assignment ID
                resourceId: resourceId,
                eventId: timeCapsuleEvent.id
            });
        });
    }catch (e) {
        console.error(e);
        throw e;
    }
    return {timeCapsuleEvents, assignmentstimeCapsulesAsignment};
}
function clearData() {
    this.$options.roadmap.eventStore.removeAll();
    this.$options.roadmap.resourceStore.removeAll();
    this.$options.unplannedGrid.store.data = [];
}
class BucketViewUtils{
    constructor(roadMapComponentInstance){
        this.roadMapComponentInstance = roadMapComponentInstance;
    }

    handleUngroupedItems(items){
        let resources = [];
        let events = [];
        let assignments = [];
        let unplannedEvents = [];
        try {
            let noGroup = this.roadMapComponentInstance.createGroupItemForRoadmap({});
            noGroup.title = "All Items";
            noGroup.id = "all_items";
            resources.push(noGroup);

            let timeCapsuleData = generateTimeCapsulesEvents("all_items", this.roadMapComponentInstance.store.gettimeCapsules);
            events = timeCapsuleData.timeCapsuleEvents;
            assignments = timeCapsuleData.assignmentstimeCapsulesAsignment;

            items.forEach(item => {
                let event = this.roadMapComponentInstance.createItemForRoadmap(copyItem(item));
                event.id = item.id;
                event.orgId = item.id;
                event.ttype = "item";
                event.title = item.title;
                event.name = item.title;

                if (item.timeCapsuleRelation) {
                    let timeCapsule = this.roadMapComponentInstance.getTimeCapsule(item.timeCapsuleRelation.customId);
                    event.startDate = new Date(timeCapsule.startDate);
                    event.endDate = new Date(timeCapsule.endDate);
                    event.cls = styledClasses.bucketChildPlanned;
                    let index = events.findIndex(e => e.id === "timeCapsule_" + timeCapsule.id+"_"+"all_items");
                    if (index >= 0) {
                        events[index].children.push(event);
                    }
                    assignments.push({
                        id: "assign_" + item.id,
                        resourceId: "all_items",
                        eventId: item.id,
                    });
                } else {
                    event.startDate = '';
                    event.endDate = '';
                    event.duration = this.roadMapComponentInstance.defaultDuration;
                    event.durationUnit = this.roadMapComponentInstance.defaultDurationUnit;
                    event.cls = styledClasses.bucketChildUnplanned;

                    unplannedEvents.push(event);
                }
            });
        }catch (e) {
            console.log(e)
        }
        return {resources, events, assignments, unplannedEvents};
    }
    handleGroupedItems(items) {
        let resources = [];
        let events = [];
        let assignments = [];
        let unplannedEvents = [];
        try {
            let groupedItems = _.cloneDeep(items);
            groupedItems.forEach(group => {
                resources.push(this.roadMapComponentInstance.createGroupItemForRoadmap(group));
            });

            groupedItems.forEach(group => {
                let timeCapsuleData = generateTimeCapsulesEvents(group.id, this.roadMapComponentInstance.store.gettimeCapsules);
                events = events.concat(timeCapsuleData.timeCapsuleEvents);
                assignments = assignments.concat(timeCapsuleData.assignmentstimeCapsulesAsignment);

                if (!_.isEmpty(group.groupItems)) {
                    group.groupItems.forEach(item => {
                        let event = this.roadMapComponentInstance.createItemForRoadmap(copyItem(item));
                        event.id = item.id;
                        event.orgId = item.id;
                        event.ttype = "item";
                        event.title = item.title;
                        event.name = item.title;
                        if (item.timeCapsuleRelation) {
                            let timeCapsule = this.roadMapComponentInstance.getTimeCapsule(item.timeCapsuleRelation.customId);
                            event.startDate = new Date(timeCapsule.startDate);
                            event.endDate = new Date(timeCapsule.endDate);
                            let index = events.findIndex(e => e.id === "timeCapsule_" + timeCapsule.id+"_"+group.id);
                            if (index >= 0) {
                                events[index].children.push(event);
                            }
                            assignments.push({
                                id: "assign_" + item.id,
                                resourceId: group.id,
                                eventId: item.id,
                            });
                        } else {
                            event.startDate = '';
                            event.endDate = '';
                            event.duration = this.roadMapComponentInstance.defaultDuration;
                            event.durationUnit = this.roadMapComponentInstance.defaultDurationUnit;
                            unplannedEvents.push(event);
                        }
                    });
                }
            });
        }
        catch (e) {
            console.log(e)
        }
        return {resources, events, assignments, unplannedEvents};
    }

}
class BatchViewUtils {
    constructor(roadMapComponentInstance, schedulerInstance ,gridInstance) {
        this.roadMapComponentInstance = roadMapComponentInstance;
        this.schedulerInstance = schedulerInstance;
        this.gridInstance=gridInstance
    }
    refreshBatchItems(batchEvent){
        try {
            if(batchEvent.children) {
                batchEvent.children.forEach(childEvent => {
                    let item = this.roadMapComponentInstance.itemsByIdMap[ChildIdUtils.getItemId(childEvent.id)];
                    if (item) {
                        applyAlertToItemEvent(childEvent, item);
                    }
                });
            }
        }
        catch (e) {
            console.error(e);
        }
    }
     moveLinkedItemsToSelectedBatch(sourceBatchId,sourceBaseItemLinks, targetBatchId, itemId,eventContext) {
        let _this = this;
        let trimmedSelectedItemsMap = getItemLinksMapFromBatchAllCollections(sourceBatchId,sourceBaseItemLinks, itemId);
        let requestBody = {
            destinationBatchIds: [targetBatchId],
            baseItemLinksMap: trimmedSelectedItemsMap,
        }
        if(_this.roadMapComponentInstance.selectedReleaseTrain) {
            _this.roadMapComponentInstance.$options.batchViewUtils.loadUnplannedItems(_this.roadMapComponentInstance.selectedReleaseTrain.id, true);
        }
         axios.post('/batch/move-backlog-items-batches/'+syncId,requestBody).then(function (response) {
            if(response.status == 200) {
                eventContext.finalize(true);
                showBatchItemsAndMaximize(roadmapVue.$options.roadmap,eventContext.targetEventRecord,
                    roadmapVue.$options.roadmap.resourceStore.getById(eventContext.targetEventRecord.resourceId))
                //expanding the batch container
                //add item to baseitemlinks of targetbatch
                if(_this.roadMapComponentInstance.batchesMap[targetBatchId] &&
                    _this.roadMapComponentInstance.batchesMap[targetBatchId].baseItemLinks) {
                    _this.roadMapComponentInstance.batchesMap[targetBatchId]
                        .baseItemLinks.push(trimmedSelectedItemsMap[sourceBatchId][0]);
                }
                //remove from source batch
                if(_this.roadMapComponentInstance.batchesMap[sourceBatchId] &&
                    _this.roadMapComponentInstance.batchesMap[sourceBatchId].baseItemLinks) {
                    let index = _this.roadMapComponentInstance.batchesMap[sourceBatchId]
                        .baseItemLinks.findIndex(item => item.baseItemId === itemId);
                    if(index >= 0) {
                        _this.roadMapComponentInstance.batchesMap[sourceBatchId]
                            .baseItemLinks.splice(index, 1);
                    }
                }
            }
        }).catch(function (error) {
            console.log(error);
        });
    }
     copyLinkedItemsToSelectedBatch(sourceBatchId,sourceBaseItemLinks, targetBatchId, itemId,eventContext,targetEventRecord) {
        let _this = this;
         let trimmedSelectedItemsMap = getItemLinksMapFromBatchAllCollections(sourceBatchId,sourceBaseItemLinks, itemId);
         let requestBody = {
            selectedBatchesIds: [targetBatchId],
            selectedItemsMap: trimmedSelectedItemsMap,
        }
        if(_this.roadMapComponentInstance.selectedReleaseTrain) {
            _this.roadMapComponentInstance.$options.batchViewUtils.loadUnplannedItems(_this.roadMapComponentInstance.selectedReleaseTrain.id, true);
        }
         axios.post('/batch/copy-backlog-items-batches/'+syncId,requestBody).then(function (response) {
            if(response.status == 200) {

                eventContext.finalize(false); //in case of copy we don't want to remove the item from source batch
                showBatchItemsAndMaximize(roadmapVue.$options.roadmap,eventContext.targetEventRecord,
                    roadmapVue.$options.roadmap.resourceStore.getById(eventContext.targetEventRecord.resourceId))
                let generatedId = _this.generateNewEventId(eventContext.eventRecord.id);
                _this.schedulerInstance.eventStore.add({
                    id: generatedId,
                    name: eventContext.eventRecord.name,
                    startDate: targetEventRecord.startDate,
                    endDate: new Date(targetEventRecord.endDate),
                    resourceId: targetEventRecord.resourceId,
                    parentId: targetEventRecord.id,
                    type: EventTypes.ITEM,
                    messageCode:  eventContext.eventRecord.originalData.messageCode,
                    message:  eventContext.eventRecord.originalData.message,
                    orgId:  eventContext.eventRecord.originalData.orgId,
                    orgItemData:  eventContext.eventRecord.originalData.orgItemData,
                });
                let itemAssignment={
                        id: "assign_" +  generatedId,
                        resourceId:targetEventRecord.resourceId, // Use generic level-based resource ID
                        eventId: generatedId
                    };
                _this.schedulerInstance.assignmentStore.add(itemAssignment);
                //add item to baseitemlinks of targetbatch
                if(_this.roadMapComponentInstance.batchesMap[targetBatchId] && _this.roadMapComponentInstance.batchesMap[targetBatchId].baseItemLinks) {
                    _this.roadMapComponentInstance.batchesMap[targetBatchId].baseItemLinks.push(trimmedSelectedItemsMap[sourceBatchId][0]);
                }
                //refresh schdueler
                _this.schedulerInstance.refresh();
            }
        }).catch(function (error) {
            console.log(error);
        });
    }
    generateNewEventId(oldId) {
        const parts = oldId.split("_");
        const newUUID = getNewUUID();
        return `event_${newUUID}_${parts[2]}_${parts[3]}`;
    }

    static findEventsBySegment(eventStore, segment) {
        let matchingEvents = eventStore.query(record => {
            // Split the event's ID and check if the third segment matches the target segment
            let parts = record.id.split('_');
            return parts.length > 2 && parts[2] === segment;
        });
        return matchingEvents;
    }
    static modifyAllRelatedItems(eventStore,item,targetItemEventId){
        ///////change all duplicate items //////
        try {
            let matchingEvents = this.findEventsBySegment(eventStore, item.id)
                // Start a batch operation for efficient processing
                eventStore.beginBatch();
                matchingEvents.forEach(event => {
                    if(event.id === targetItemEventId){
                        return;
                    }
                    let parentEvent = event._parent
                    let {messageCode, message, itemStartDate, itemEndDate}=
                        getMessageCodeForItem(item,parentEvent.startDate, parentEvent.endDate)
                    //for same start and end date
                    itemStartDate.setHours(0);
                    itemStartDate.setMinutes(1);
                    itemStartDate.setSeconds(1);
                    itemEndDate.setHours(23);
                    itemEndDate.setMinutes(59);
                    itemEndDate.setSeconds(59);
                    event.set({
                        name: item.title,
                        orgItemData: _.cloneDeep(item),
                        startDate: itemStartDate,
                        endDate: itemEndDate,
                        messageCode: messageCode,
                        message: message
                    });
                    event.originalData.messageCode = messageCode
                    event.originalData.message = message
                    event.originalData.orgItemData = _.cloneDeep(item);
                });
                // End the batch operation
                eventStore.endBatch();
                eventStore.commit();
        }
        catch (e) {
            console.log(e);
            showTopMessage("Error while updating items, Please reload", 'error', 5000);
        }
    }
    reloadMembers() {
        this.schedulerInstance  = this.roadMapComponentInstance.$options.roadmap;
        this.gridInstance = this.roadMapComponentInstance.$options.unplannedGrid;
    }
    static unscheduleItemInBatch(scheduler, itemEventIds ,parentEvent) {
        // Start a batch operation on the stores
        let eventStore = scheduler.eventStore;
        let assignmentStore = scheduler.assignmentStore;

        eventStore.beginBatch();
        assignmentStore.beginBatch();

        try {
            // Iterate over each itemEventId and remove the corresponding event and assignment
            itemEventIds.forEach(itemEventId => {
                let event = eventStore.getById(itemEventId);
                let assignment = assignmentStore.getById("assign_" + itemEventId);

                if (event) {
                    eventStore.remove(event);
                }
                if (assignment) {
                    assignmentStore.remove(assignment);
                }
                //remove child from parent
            });

            // Commit all changes in a single batch
            eventStore.endBatch();
            assignmentStore.endBatch();
        } catch (error) {
            // If an error occurs, we should safely end the batch operations
            console.error("Error during batch unschedule: ", error);
            eventStore.endBatch();
            assignmentStore.endBatch();
        }
    }

    scheduleItemInBatch(batchEventRecord,items){
        let targetResourceId = batchEventRecord.resourceId;
        let batchId = batchEventRecord.id.split("_")[2];
        let batchStartDate = batchEventRecord.startDate;
        let batchEndDate = batchEventRecord.endDate;
        let childEvents= [];
        let assignments = [];

        for(let item of items) {
            if (item) {
                let {itemEvent, itemAssignment} =
                    createItemEventForBatchesView(item, batchEndDate, batchStartDate,targetResourceId,batchId,true);
                if(itemEvent && itemAssignment){
                    itemEvent.parentId = batchEventRecord.id; //set parent id
                    childEvents.push(itemEvent);
                    assignments.push(itemAssignment);
                }
            }
        }

        this.schedulerInstance.eventStore.add(childEvents);
        this.schedulerInstance.assignmentStore.add(assignments);
        this.schedulerInstance.refresh();

    }
   static unlinkBackLogItem(roadmapComponent,itemId,baseItemId,callbackAfterPersistance){
        if(!itemId || itemId === "" || !baseItemId || baseItemId === ""){
            console.log("Item Id or Base Item Id is not available")
            return;
        }
        let _this = this;
        let data = {};
        data.backlogItemId = itemId;
        data.batchId = baseItemId;
        let url = '/batch/unlink-backlog-item-batch/' + syncId;

        axios.post( url, data)
            .then(res => {
                if (res.status=="200"  ) {
                    showTopMessage("Backlog Item Unlinked Successfully.", "success");
                    if(roadmapComponent.batchesMap[baseItemId] && roadmapComponent.batchesMap[baseItemId].baseItemLinks) {
                        let index = roadmapComponent.batchesMap[baseItemId].baseItemLinks.findIndex(item => item.baseItemId === itemId);
                        if(index >= 0) {
                            roadmapComponent.batchesMap[baseItemId].baseItemLinks.splice(index, 1);
                        }
                    }
                    callbackAfterPersistance();
                }
            })
            .catch(err => {
                console.log(err);
            }).finally(() => {
        });

    }

    async linkItemsToBatch(batch, items, releaseTrainId) {
        try {
            var _this = this;
            var itemContainers = [];
            var linkedItemMap = {};

            //create link map of already attached items
            _.each(batch.baseItemLinks, link => {
                if (link.baseItemId && link.linkType === BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM && link.releaseTrainId === releaseTrainId) {
                    linkedItemMap[link.baseItemId] = link;
                }
            });
            _.each(items, item => {
                var itemContainer = {};
                if (linkedItemMap[item.id]) {
                    itemContainer.id = linkedItemMap[item.id].id;
                }
                // itemContainer.sessionId = item.sessionBoards[0].session.id;
                itemContainer.baseItemId = item.id;
                itemContainer.releaseTrainId = releaseTrainId;
                itemContainers.push(itemContainer);
            });

            var requestBody = {};
            requestBody.id = batch.id;
            requestBody.baseItemLinks = itemContainers;
            let response = await axios.post('/batch/link-backLogItems-with-batch/' + syncId, requestBody);
            if (response.status == "200" && response.data) {
                return response.data;  // Returning response data directly
            } else {
                throw new Error("No data received or wrong status");
            }
        }catch (e) {
            console.log(e);
            throw e;
        }
    }
    popuplateUnplannedItems(items,fetchedStatuses) {
        let _this = this;
        try {
            let resources = [];
            let events = [];
            let unplannedEvents = [];
            this.gridInstance.store.data = [];

            //......   add item placeholder resource
            //
            //     let noGroup = _this.createGroupItemForRoadmap({});
            //     noGroup.title = "All Items";
            //     noGroup.id = "all_items";
            //     resources.push(noGroup);

            _.each(items, item => {
                let compositeKey = item.id;
                let event = createCollectionGridItem(copyItem(item));
                event.status = item.status? _.find(fetchedStatuses, {id: item.status.id}): undefined;
                event.id = compositeKey;
                event.orgId = compositeKey;
                // event.resourceId = "all_items";
                // event.sessionBoardId = boardLink.sessionBoardId;
                event.ttype = "item";
                // if (item.fields.StartDate && item.fields.EndDate) {
                //     // event.startDate = new Date(item.fields.StartDate);
                //     // event.endDate = new Date(item.fields.EndDate);
                //     // events.push(event);
                //
                // } else if (item.timeCapsuleRelation) {
                //     // let timeCapsule = _this.getTimeCapsule(item.timeCapsuleRelation.customId);
                //     // event.startDate = new Date(timeCapsule.startDate);
                //     // event.endDate = new Date(timeCapsule.endDate);
                //     // events.push(event);
                // } else {
                event.cls = styledClasses.collectionItemUnplanned;
                event.startDate = '';
                event.endDate = '';
                event.duration = _this.roadMapComponentInstance.defaultDuration;
                event.durationUnit = _this.roadMapComponentInstance.defaultDurationUnit;
                unplannedEvents.push(event);
            });

            _this.gridInstance.store.data = (unplannedEvents);
            // _this.$options.roadmap.resources = resources;
            // _this.$options.roadmap.events = events;
            _this.schedulerInstance.refresh();
        } catch (error) {
            console.log(error);
        }
    }
    loadUnplannedItems(releaseTrainId,refresh) {
        try {
            if (!releaseTrainId || releaseTrainId === "") {
                console.log("Release Train Id is not available")
                return;
            }
            if(!refresh){this.gridInstance.maskBody('Loading data');}
            let _this = this;
            let data = {}
            // data.hierachLevel = "" + this.roadMapComponentInstance.level;
            if (this.roadMapComponentInstance.gridFilters.filter) {
                let filters = this.roadMapComponentInstance.getFilterCriteria(this.roadMapComponentInstance.roadmap, this.roadMapComponentInstance.gridFilters.filter.criteria, this.roadMapComponentInstance.gridFilters.searchText);
                if (!_.isEmpty(filters.rules)) {
                    data.filter = filters;
                }
            } else {
                let filters = this.roadMapComponentInstance.getFilterCriteria(this.roadMapComponentInstance.roadmap, {}, this.roadMapComponentInstance.gridFilters.searchText);
                if (!_.isEmpty(filters.rules)) {
                    data.filter = filters;
                }
            }
            data.pageStart = "" + (this.roadMapComponentInstance.gridPagination.pageIndex * this.roadMapComponentInstance.gridPagination.pageSize);
            data.pageSize = "" + (this.roadMapComponentInstance.gridPagination.pageSize);
            data.requestId = getNewUUID();
            this.roadMapComponentInstance.loadingItems = true;
            data.hierachLevel = this.roadMapComponentInstance.selectedReleaseTrainMeta.selectedHierarchyLevel.level.toString();
            RoadMapLocalStorageManager.saveCollectionGridState(_this.roadMapComponentInstance.batchToBePlannedKey,
                {
                    selectedHierarchyLevel:this.roadMapComponentInstance.selectedReleaseTrainMeta.selectedHierarchyLevel,
                    selectedReleaseTrain:this.roadMapComponentInstance.selectedReleaseTrain
                }
                )
            data.loadStatuses =true;
            axios.post("/releasetrain/" + releaseTrainId + "/backlog", data).then(res => {
                _this.roadMapComponentInstance.loader.show = false;
                if (res.data) {
                    let fetchedStatuses = res.data.statuses;
                    _this.popuplateUnplannedItems(res.data.result.items,fetchedStatuses);
                    this.roadMapComponentInstance.gridPagination.totalItemSize = res.data.result.total;
                    _this.roadMapComponentInstance.loadingItems = false;
                    _this.roadMapComponentInstance.populateLoadedMap(res.data.result.items,fetchedStatuses);
                    // fitSchedulerToEvents(_this.schedulerInstance);
                    if(!refresh){   _this.gridInstance.unmaskBody();}


                    _this.populatePaginationPageSelectionDropDown(res.data.result.total, _this.roadMapComponentInstance.gridPagination.pageSize);
                }
            }).catch(error => {
                _this.roadMapComponentInstance.loader.show = false;
                console.log(error);
            });
        }catch (e) {
            showTopMessage("Error loading unplanned items.",'error',5000);
            console.log(e);
            if(!refresh){ this.gridInstance.unmaskBody();}
        }finally {
        }
    }
    populatePaginationPageSelectionDropDown(totalItems,pageSize){
        //options should be like 1-50,51-100,101-150
        if(totalItems>0){
            let options = [];
            let totalPages = Math.ceil(totalItems/pageSize);
            for(let i=0;i<totalPages;i++){
                let start = i*pageSize+1;
                let end = (i+1)*pageSize;
                if(end>totalItems){
                    end = totalItems;
                }
                options.push({index:i ,text:start+"-"+end+ "("+totalItems+")"});
            }

            if(this.roadMapComponentInstance.$options.unplannedGrid
                && this.roadMapComponentInstance.$options.unplannedGrid.widgetMap['kendis-page-index-dropdown-widget']
                && this.roadMapComponentInstance.$options.unplannedGrid.widgetMap['kendis-page-size-dropdown-widget']){

                this.roadMapComponentInstance.$options.unplannedGrid.widgetMap['kendis-page-index-dropdown-widget'].items = options;
                if(this.roadMapComponentInstance.$options._resetPageIndex ) {
                    this.roadMapComponentInstance.$options._suppressChangeEvent = true;
                    this.roadMapComponentInstance.$options.unplannedGrid.widgetMap['kendis-page-index-dropdown-widget'].value = options[0];
                    this.roadMapComponentInstance.$options._suppressChangeEvent = false;
                }
                this.roadMapComponentInstance.$options._resetPageIndex = false;

                this.roadMapComponentInstance.$options.unplannedGrid.widgetMap['kendis-page-size-dropdown-widget'].items = this.roadMapComponentInstance.gridPagination.pageSizeOptions;
                this.roadMapComponentInstance.$options.unplannedGrid.widgetMap['kendis-page-size-dropdown-widget'].value            = this.roadMapComponentInstance.gridPagination.pageSize;

            }
        }

    }
    drawNewBatchEvent(newBatch,resourceId,parentBatchEvent){
        let _this = this;
        let batchEvent = null;
        axios.get('/batch/get-fields-list-for-batch/' + newBatch.id).then(response => {
            if (response.status === 200) {
                let fieldMap = createFieldMap(response.data.fieldList);
                batchEvent  = createBatchEventForBatchesView(resourceId,newBatch, fieldMap,
                    undefined,undefined,true,parentBatchEvent);
                let assignment = ({
                    id: "assign_" + newBatch.id, // Ensure unique assignment ID
                    resourceId: getResourceBelowId(resourceId,_this.schedulerInstance)!=null?
                        getResourceBelowId(resourceId,_this.schedulerInstance):resourceId,//draw new batch on next level
                    eventId: batchEvent.id
                });
                _this.schedulerInstance.eventStore.add(batchEvent);
                _this.schedulerInstance.assignmentStore.add(assignment);
                _this.schedulerInstance.refresh();
            }
        }).catch(error => {
            console.error("Error drawing new batch", error);
        }).finally(() => {
            let event = _this.schedulerInstance.eventStore.getById(batchEvent.id);
            adjustBatchParentsDates(_this.schedulerInstance, event.id,event.startDate,event.endDate);
        });
    }
}
function validateItemAlreadyLinked(itemId, batch, releaseTrainId) {
    let itemAlreadyLinked = false;
    if (batch && batch.baseItemLinks) {
        let itemLink = batch.baseItemLinks.find(link => link.baseItemId === itemId && link.releaseTrainId === releaseTrainId);
        if (itemLink) {
            itemAlreadyLinked = true;
            showTopMessage("Item is already linked to this batch.",'warning');
        }
    }
    return itemAlreadyLinked;
}
function validateItemAlreadyLinkedAnyCollection(itemId, batch) {
    let itemAlreadyLinked = false;

    if (batch && batch.baseItemLinks) {
        // console.log(batch.baseItemLinks);
        let itemLink = batch.baseItemLinks.find(link => link && link.baseItemId === itemId);
        if (itemLink) {
            showTopMessage("Item is already linked to this batch.",'warning');
            return true;
        }
    }
    return itemAlreadyLinked;
}

class RawItemsViewUtils{
    constructor(roadMapComponentInstance, schedulerInstance ,gridInstance) {
        this.roadMapComponentInstance = roadMapComponentInstance;
        this.schedulerInstance = schedulerInstance;
        this.gridInstance=gridInstance
    }
    reloadMembers() {
        this.schedulerInstance  = this.roadMapComponentInstance.$options.roadmap;
        this.gridInstance = this.roadMapComponentInstance.$options.unplannedGrid;
    }
    static findEventsBySegment(eventStore, segment) {
        return eventStore.query(record => {
            // Split the event's ID and check if the third segment matches the target segment
            let parts = record.id.split('_');
            return parts.length > 1 && parts[0] === segment;
        });
    }
    static modifyAllRelatedItems(eventStore,item,dontModifyEventDate){
        ///////change all duplicate items //////
        try {
            let matchingEvents = this.findEventsBySegment(eventStore, item.id)
            // Start a batch operation for efficient processing
            let itemStartDate = new Date(item.fields.StartDate);
            let itemEndDate = new Date(item.fields.EndDate);
            itemStartDate.setHours(0);
            itemStartDate.setMinutes(1);
            itemStartDate.setSeconds(1);
            itemEndDate.setHours(23);
            itemEndDate.setMinutes(59);
            itemEndDate.setSeconds(59);

            eventStore.beginBatch();
            matchingEvents.forEach(event => {
                event.set({
                    name: item.title,
                });
                if(!dontModifyEventDate) {
                    event.set({
                        startDate: new Date(item.fields.StartDate),
                        endDate: new Date(item.fields.EndDate),
                    });
                }
                let color = "";
                if (item.fields && item.fields.Color) {
                     color = item.fields.Color;
                    event.style = "background-color:" + color + ";";
                }
            });

            // End the batch operation
            eventStore.endBatch();
            eventStore.commit();
        }
        catch (e) {
            console.log(e);
            showTopMessage("Error while updating items, Please reload", 'error', 5000);
        }
    }

    moveAllEventsToNewResource(newResourceId, oldResourceId) {
        if(!newResourceId || !oldResourceId){
            return;
        }
        let matchingEvents = this.roadMapComponentInstance.$options.roadmap.eventStore.query(record => {
           return record.resourceId === oldResourceId && !record.originalData.isHeader;
        });
        matchingEvents.forEach(event => {
            event.groupId = newResourceId;
        });
        //modify the assignments
        let matchingAssignments = this.roadMapComponentInstance.$options.roadmap.assignmentStore.query(assignment => {
            return assignment.resourceId === oldResourceId && !assignment.id.includes('a-full-span-event');
        })
        matchingAssignments.forEach(assignment => {
            assignment.resourceId = newResourceId;
        })
        // this.roadMapComponentInstance.$options.roadmap.refresh();
    }
}
class RoadMapLocalStorageManager{
     static async saveCollectionGridState(batchId,state){
        let uniqueId = batchId+"_collection_grid_state";
        localStorage.setItem(uniqueId, JSON.stringify(state));
    }
    static getCollectionGridState(batchId) {
        let uniqueId = batchId+"_collection_grid_state"
        return JSON.parse(localStorage.getItem(uniqueId));
    }
     static async saveDisplaySettings(batchId,displaySettings){
        let uniqueId = batchId+"_display_settings";
        localStorage.setItem(uniqueId, JSON.stringify(displaySettings));
    }
    static getDisplaySettings(batchId) {
        let uniqueId = batchId+"_display_settings"
        return JSON.parse(localStorage.getItem(uniqueId));
    }
     static async saveCollectionCollapsedState(batchId,collapsedState){
        let uniqueId = batchId+"_collection_collapsed_state";
        localStorage.setItem(uniqueId, JSON.stringify(collapsedState));
    }
    static getCollectionCollapsedState(batchId) {
        let uniqueId = batchId+"_collection_collapsed_state"
        return JSON.parse(localStorage.getItem(uniqueId));
    }
    static getSearchTags(batchId){
        let _tags = localStorage.getItem(batchId + '-fil-tags');
        if(_tags == null || _tags === ""){
            return [];
        }
        if (_tags && !_.isEmpty(_tags)) {
            _tags = JSON.parse(_tags);
        }
        return _tags
    }
    static setSearchTags(batchId,tags){
        if (_.isEmpty(tags)) {
            localStorage.setItem(batchId + '-fil-tags', '');
        } else {
            let tagsStr = JSON.stringify(tags);
            localStorage.setItem(batchId + '-fil-tags', tagsStr);
        }
    }

}
class BatchStatsCalculator {
    static calculateStatsForBatch(batch, itemMap,filter) {
        let stats = {
            totalItems: 0,
            totalDoneItems: 0,
            totalInProgressItems: 0,
            totalTodoItems: 0,
            totalMiscItems: 0,
            totalStoryPoints: 0,
            totalDoneStoryPoints: 0,
            totalInProgressStoryPoints: 0,
            totalMiscStoryPoints: 0,
            totalTodoStoryPoints: 0,
            percentageCompletionByStatus: 0,
            percentageCompletionByStoryPoints: 0,
        };
        try {
            if (batch.baseItemLinks) {
                // Use a Set to track processed baseItemIds
                const processedBaseItemIds = new Set();

                batch.baseItemLinks.forEach(baseItemLink => {
                    if (baseItemLink.linkType && baseItemLink.linkType === BASE_ITEM_LINK_TYPES_ENUM.BACKLOGITEM &&
                        processedBaseItemIds.has(baseItemLink.baseItemId)) {
                        return; // Skip if baseItemId is already processed
                    }
                    processedBaseItemIds.add(baseItemLink.baseItemId);

                    let item = itemMap[baseItemLink.baseItemId];

                    if (item) {
                        if(enableBatchPlanningSearch){
                            if(filter.searchTags && filter.searchTags.length>0) {
                                let tags = filter.searchTags
                                const lowerTags = tags.map(tag => tag.title.toLowerCase());
                                let key = generateKey(item);
                                let keyMatch = key && lowerTags.some(tag => key.toLowerCase().includes(tag));
                                let nameMatch = item.title && lowerTags.some(tag => item.title.toLowerCase().includes(tag));
                                if (!keyMatch && !nameMatch) {
                                    return;
                                }
                            }
                        }
                        if (!showArchivedItems && isItemArchivedFromAllCollectionsAttachedToBatch(item, batch.baseItemLinks)) {
                            return;
                        }
                        stats.totalItems++;
                        stats.totalStoryPoints += item.storyPoints;
                        if (!item.status) {
                            stats.totalMiscItems++;
                            stats.totalMiscStoryPoints += item.storyPoints;
                        } else if (item.status.category === "Done") {
                            stats.totalDoneItems++;
                            stats.totalDoneStoryPoints += item.storyPoints;
                        } else if (item.status.category === "InProgress") {
                            stats.totalInProgressItems++;
                            stats.totalInProgressStoryPoints += item.storyPoints;
                        } else if (item.status.category === "ToDo") {
                            stats.totalTodoItems++;
                            stats.totalTodoStoryPoints += item.storyPoints;
                        } else {
                            stats.totalMiscItems++;
                            stats.totalMiscStoryPoints += item.storyPoints;
                        }
                    }
                });
            }
            if (stats.totalItems > 0) {
                stats.percentageCompletionByStatus = Math.round((stats.totalDoneItems / stats.totalItems) * 100);
            }
            if (stats.totalStoryPoints > 0) {
                stats.percentageCompletionByStoryPoints = Math.round((stats.totalDoneStoryPoints / stats.totalStoryPoints) * 100);
            }
        } catch (e) {
            console.log(e);
        }
        return stats;
    }
}
class CollectionGridUtils{
    static updateGridItem(grid,item){
        let event = grid.store.getById(item.id);
        if (event) {
            event.title = item.title;
            event.name = item.title;
            event.cls = "kendis-new-collection-item"
            event.status = item.status
            event.batchRelations = item.batchRelations
            grid.store.commit();
        }
    }
    static addGridItem(grid,item){
        try {
            //add new item in grid
            let compositeKey = item.id;
            let event = createCollectionGridItem(copyItem(item));
            event.id = compositeKey;
            event.orgId = compositeKey;
            event.ttype = "item";
            event.duration = 14;
            event.durationUnit ="d";
            event.title = item.title;
            event.name = item.title;
            event.cls = "kendis-new-collection-item"
            grid.store.insert(0, event);
        }catch (e) {
            console.log(e)
        }
    }

}
class Paginator {
    constructor(data, pageSize = 10, updateCallback) {
        this.data = data; // Full dataset
        this.pageSize = pageSize; // Items per page
        this.currentPage = 1; // Current page
        this.updateCallback = updateCallback; // Callback to update the data in the grid
    }

    // Sets the data and resets the paginator
    setData(newData) {
        this.data = newData;
        this.currentPage = 1;
        this.updatePage();
    }

    // Sets the current page size
    setPageSize(newPageSize) {
        this.pageSize = newPageSize;
        this.currentPage = 1; // Reset to first page on page size change
        this.updatePage();
    }

    // Go to the specified page number
    goToPage(pageNumber) {
        if (pageNumber > 0 && pageNumber <= this.totalPages()) {
            this.currentPage = pageNumber;
            this.updatePage();
        }
    }

    // Go to the next page
    nextPage() {
        if (this.currentPage < this.totalPages()) {
            this.currentPage++;
            this.updatePage();
        }
    }

    // Go to the previous page
    prevPage() {
        if (this.currentPage > 1) {
            this.currentPage--;
            this.updatePage();
        }
    }

    // Calculate total pages
    totalPages() {
        return Math.ceil(this.data.length / this.pageSize);
    }

    getAllPageNumbers(){
        // let pages = [];
        // for (let i = 1; i <= this.totalPages(); i++) {
        //     pages.push(i);
        // }
        // return pages;
        //all page numbers should show link pages 1-10,11-20,21-30 with total items in brackets

       return  generatePageNumbers(this.data.length, this.pageSize);

        function generatePageNumbers(totalItems, itemsPerPage) {
            let pages = [];
            let totalPages = Math.ceil(totalItems / itemsPerPage); // Calculate total pages

            for (let i = 0; i < totalPages; i++) {
                let startItem = i * itemsPerPage + 1;
                let endItem = Math.min((i + 1) * itemsPerPage, totalItems);

                // Create page object with index and display value
                pages.push({
                    index: i + 1,
                    display: `${startItem}-${endItem}  (${totalItems})`
                });
            }

            return pages;
        }
    }

    // Update the grid with the current page's data
    updatePage() {
        const startIndex = (this.currentPage - 1) * this.pageSize;
        const endIndex = startIndex + this.pageSize;
        const pageData = this.data.slice(startIndex, endIndex);
        this.updateCallback(pageData);
    }
}
function toggleResourceExpand(resource, selectedGroup, scheduler) {
    const { expanded, id: groupId } = resource;
    expanded ? collapseResource(scheduler, resource, selectedGroup) :
        expandResource(scheduler, resource, selectedGroup);
}
function toggleResourceExpandByAssignments(resource, selectedGroup, scheduler) {
    const { expanded, id: groupId } = resource;
    expanded ? collapseResourceByAssignments(scheduler, resource, selectedGroup) :
        expandResourceByAssignments(scheduler, resource, selectedGroup);
}

function collapseResource(scheduler, resourceRecord, groupValue) {
    resourceRecord.set({ expanded: false });
    let groupId = resourceRecord.id;
    scheduler.eventStore.filter({
        id: `filter-${groupId}-${groupValue}`,
        filterBy: event => event.id.includes('full-span-event') ||
            (event.resource && event.resource.id !== groupId),
    });
}

function expandResource(scheduler, resourceRecord, groupValue) {
    try {
        resourceRecord.set({expanded: true});
        let groupId = resourceRecord.id;
        scheduler.eventStore.removeFilter(`filter-${groupId}-${groupValue}`);
        // fitSchedulerToEvents(scheduler);
    }catch (e) {
        console.log(e)
    }
}
function collapseResourceByAssignments(scheduler, resourceRecord, groupValue) {
    resourceRecord.set({ expanded: false });
    let groupId = resourceRecord.id;

    scheduler.assignmentStore.filter({
        id: `filter-${groupId}-${groupValue}`,
        filterBy: assignment => assignment.id.includes('a-full-span-event') || assignment.resource.id !== groupId
    });
}

function expandResourceByAssignments(scheduler, resourceRecord, groupValue) {
    try {
        resourceRecord.set({ expanded: true });
        let groupId = resourceRecord.id;
        scheduler.assignmentStore.removeFilter(`filter-${groupId}-${groupValue}`);
    } catch (e) {
        console.log(e);
    }
}

function showBryntumToastMessage(message, type = 'success') {
    showTopMessage(message,type)
}
class RoadmapSection {
    constructor(id, name ) {
        this.id = id;
        this.name = name;
    }

}
class RoadmapSectionsCrud{
    constructor(sections){
        this.sections = sections;
    }
    /**
     * method to craete a section at the end of list, the sequence will be taken from abckend to ensure the
     * data integrity
     * @param section
     * @returns {Promise<void>}
     */
    async addSectionAtEnd(section){

        let response = await fetch('/roadmap-section/add-roadmap-section-at-last', {
            method: 'POST',
            headers: getFetchAPIHeadersForKendis(),
            body: JSON.stringify(section),
            credentials: 'include', // Include cookies for CSRF-TOKEN
        });
        if(response.ok){
            let responseJson = await response.json();
            roadmapVue.$options.roadmap.resourceStore.add(responseJson);
            roadmapVue.drawGroupHeaderEvents([roadmapVue.$options.roadmap.resourceStore.getById(responseJson.id)])
            this.sections.push(responseJson);
            roadmapVue.$options.roadmap.features.eventMenu.items.linkToRoadmapSection.menu.items
                = roadmapVue.getLinkToRoadmapSectionMenuItems();
            showBryntumToastMessage("Section added successfully", 'success');
            console.log("Section added successfully "+responseJson);
            roadmapVue.$options.roadmap.refresh();
            // roadmapVue.$options.roadmap.resourceStore.sort('sequence')
        }
    }
    getNewSectionName(){
        //new name should be like "New Section 1"
        let newSectionName = "New Section 1";
        let existingSections = this.sections.map(sec => sec.name);
        let index = 1;
        while(existingSections.includes(newSectionName)){
            index++;
            newSectionName = "New Section "+index;
        }
        return newSectionName;
    }
    async addSection(section,index){

        let response = await fetch('/roadmap-section/add-roadmap-section', {
            method: 'POST',
            headers: getFetchAPIHeadersForKendis(),
            body: JSON.stringify(section),
            credentials: 'include', // Include cookies for CSRF-TOKEN
        });
        if(response.ok){
            let newSection = await response.json();
            
            // Find the correct insertion point to ensure the new section is added at the same level
            let insertIndex = index + 1;
            let currentResource = roadmapVue.$options.roadmap.resourceStore.getAt(index);
            
            // If the current resource has children and is expanded, we need to find the next sibling
            if (currentResource && currentResource.children && currentResource.children.length > 0) {
                // Find the next sibling at the same level
                let nextSiblingIndex = this.findNextSiblingIndex(roadmapVue.$options.roadmap.resourceStore, index);
                if (nextSiblingIndex !== -1) {
                    insertIndex = nextSiblingIndex;
                } else {
                    // If no next sibling, insert at the end of the current level
                    insertIndex = this.findEndOfCurrentLevel(roadmapVue.$options.roadmap.resourceStore, index);
                }
            }
            
            roadmapVue.$options.roadmap.resourceStore.insert(insertIndex, newSection);
            roadmapVue.drawGroupHeaderEvents([roadmapVue.$options.roadmap.resourceStore.getById(newSection.id)])

            this.sections.push(newSection);
            showBryntumToastMessage("Section added successfully", 'success');
            roadmapVue.$options.roadmap.features.eventMenu.items.linkToRoadmapSection.menu.items
                = roadmapVue.getLinkToRoadmapSectionMenuItems();
            console.log("Section added successfully "+newSection);
            // roadmapVue.$options.roadmap.resourceStore.sort('sequence')
        }
    }
    async removeSection(section) {
        try {
            let response = await fetch(`/roadmap-section/delete-roadmap-section?roadmapSectionId=${section.id}`, {
                method: 'DELETE',
                headers: getFetchAPIHeadersForKendis(),
                credentials: 'include', // Include cookies for CSRF-TOKEN
            });
            
            if (response.ok) {
                // Move all events from this section to the default section
                roadmapVue.$options.rawItemsViewUtils.moveAllEventsToNewResource("null", section.id);
                
                // Remove the section from the sections array
                this.sections = this.sections.filter(sec => sec.id !== section.id);
                
                // Get all child resources that need to be removed
                let childResourcesToRemove = this.getAllChildResources(section.id);
                
                // Remove all child resources first (to maintain proper order)
                childResourcesToRemove.forEach(childResourceId => {
                    roadmapVue.$options.roadmap.resourceStore.remove(childResourceId);
                    console.log(`Removed child resource: ${childResourceId}`);
                });
                
                // Remove the main section resource
                roadmapVue.$options.roadmap.resourceStore.remove(section.id);
                console.log(`Removed section resource: ${section.id}`);
                
                // Update the event menu items
                roadmapVue.$options.roadmap.features.eventMenu.items.linkToRoadmapSection.menu.items
                    = roadmapVue.getLinkToRoadmapSectionMenuItems();
                
                // Refresh the roadmap
                roadmapVue.$options.roadmap.refresh();
                
                console.log(`Section "${section.name}" and ${childResourcesToRemove.length} child resources removed successfully`);
            } else {
                console.error('Failed to delete section from server:', response.status, response.statusText);
                showBryntumToastMessage("Failed to delete section from server", "error");
            }
        } catch (error) {
            console.error('Error removing section:', error);
            showBryntumToastMessage("Error removing section", "error");
        }
    }
    getSections(){
        return this.sections;
    }
    getSectionById(id){
        return this.sections.find(sec => sec.id === id);
    }
    getDefaultSection(){
        return this.sections.find(sec => sec.defaultSection &&  sec.defaultSection === true);
    }
    checkNameExists(name){
        return this.sections.some(sec => sec.name === name);
    }
    updateSection(editedSection){
        //persist in db
        let dto = {
            id:editedSection.id,
            name: editedSection.name,
            parentRoadmapId: editedSection.parentRoadmapId,
            color: editedSection.color? editedSection.color : defaultGroupColor
        }

        fetch('/roadmap-section/update-roadmap-section', {
            method: 'PATCH',
            headers: getFetchAPIHeadersForKendis(),
            body: JSON.stringify(dto),
            credentials: 'include', // Include cookies for CSRF-TOKEN
        }).then(response =>
            {
                //update the resource
                let section;
                let actualtResourceId = "null"
                if(editedSection.defaultSection){
                    section = this.getDefaultSection()
                }else{
                    actualtResourceId = editedSection.id;
                    section = this.getSectionById(editedSection.id);
                }
                section.name = editedSection.name;
                section.color = editedSection.color;

                //change color of section
                let resourceRecord = roadmapVue.$options.roadmap.resourceStore.getById(actualtResourceId);
                resourceRecord.name = editedSection.name;
                resourceRecord.color = editedSection.color;

                // Update colors of all child resources
                this.updateChildResourceColors(actualtResourceId, editedSection.color);

                //modify item menu
                roadmapVue.$options.roadmap.features.eventMenu.items.linkToRoadmapSection.menu.items
                    = roadmapVue.getLinkToRoadmapSectionMenuItems();

                //edit header item color
                let headerEvents = roadmapVue.$options.roadmap.eventStore.query(event => {
                    return event.resourceId === actualtResourceId && event.originalData.isHeader;
                })

                headerEvents.forEach(event => {
                    event.eventColor =  editedSection.color ;
                    event.title = editedSection.name;
                });
                
                console.log(`Section "${editedSection.name}" and all child resources updated with color: ${editedSection.color}`);
            }
        ).catch(e=>{
                console.log(e)
                showBryntumToastMessage("Error while updating section", 'warning');
            }
        )

    }
    updateSectionName(id,newName){
        let section = this.getSectionById(id);
        section.name = newName;
        //persist in db
        let dto = {
            id:section.id,
            name: section.name,
            parentRoadmapId: section.parentRoadmapId,
            color: section.color? section.color : defaultGroupColor
        }

        fetch('/roadmap-section/update-roadmap-section', {
            method: 'PATCH',
            headers: getFetchAPIHeadersForKendis(),
            body: JSON.stringify(dto),
            credentials: 'include', // Include cookies for CSRF-TOKEN
        }).then(response =>
            {
                roadmapVue.$options.roadmap.features.eventMenu.items.linkToRoadmapSection.menu.items
                    = roadmapVue.getLinkToRoadmapSectionMenuItems();
                //edit header item color
                let headerEvents = roadmapVue.$options.roadmap.eventStore.query(event => {
                    return event.resourceId === section.id && event.originalData.isHeader;
                })

                headerEvents.forEach(event => {
                    event.eventColor =  section.color ;
                    event.title = section.name;
                });
                showBryntumToastMessage("Section updated successfully", 'success');
            }
        ).catch(e=>{
                console.log(e)
                showBryntumToastMessage("Error while updating section", 'warning');
            }
        )

    }
    async updateSectionSequence(draggedResourceId,previousResourceId,nextSectionId) {
        let response =  fetch("/roadmap-section/update-roadmap-section-sequence", {
            method: 'PATCH',
            headers: getFetchAPIHeadersForKendis(),
            body: JSON.stringify({
                modifiedObjectId: draggedResourceId,
                prevObjectId: previousResourceId,
                nextObjectId: nextSectionId
            })
        })
        if(response.ok){
            let responseData = await response.json();
            this.getSectionById(draggedResourceId).sequence = responseData.sequence;
            let resourceRecord = roadmapVue.$options.roadmap.resourceStore.getById(responseData.id);
            resourceRecord.sequence = responseData.sequence;
        }

    }
    
    /**
     * Finds the next sibling index at the same level as the given index
     * @param {Object} resourceStore - The resource store
     * @param {number} currentIndex - The current resource index
     * @returns {number} - The next sibling index or -1 if not found
     */
    findNextSiblingIndex(resourceStore, currentIndex) {
        let currentResource = resourceStore.getAt(currentIndex);
        if (!currentResource) return -1;
        
        let currentLevel = this.getResourceLevel(resourceStore, currentIndex);
        
        // Look for the next resource at the same level
        for (let i = currentIndex + 1; i < resourceStore.count; i++) {
            let resource = resourceStore.getAt(i);
            if (this.getResourceLevel(resourceStore, i) === currentLevel) {
                return i;
            }
        }
        
        return -1;
    }
    
    /**
     * Finds the end of the current level (where to insert if no next sibling)
     * @param {Object} resourceStore - The resource store
     * @param {number} currentIndex - The current resource index
     * @returns {number} - The insertion index at the end of current level
     */
    findEndOfCurrentLevel(resourceStore, currentIndex) {
        let currentResource = resourceStore.getAt(currentIndex);
        if (!currentResource) return currentIndex + 1;
        
        let currentLevel = this.getResourceLevel(resourceStore, currentIndex);
        
        // Find the last resource at the same level
        for (let i = currentIndex + 1; i < resourceStore.count; i++) {
            let resource = resourceStore.getAt(i);
            let resourceLevel = this.getResourceLevel(resourceStore, i);
            
            if (resourceLevel < currentLevel) {
                // We've gone up a level, so we're done
                return i;
            }
        }
        
        // If we reach here, insert at the end
        return resourceStore.count;
    }
    
    /**
     * Gets the level (depth) of a resource in the tree
     * @param {Object} resourceStore - The resource store
     * @param {number} index - The resource index
     * @returns {number} - The level (0 = root, 1 = first child, etc.)
     */
    getResourceLevel(resourceStore, index) {
        let level = 0;
        let resource = resourceStore.getAt(index);
        
        while (resource && resource.parentId) {
            level++;
            resource = resourceStore.getById(resource.parentId);
        }
        
        return level;
    }
    
    /**
     * Gets all child resources (recursively) of a given parent resource
     * @param {string} parentResourceId - The ID of the parent resource
     * @returns {Array} - Array of child resource IDs to be removed
     */
    getAllChildResources(parentResourceId) {
        const childResources = [];
        const resourceStore = roadmapVue.$options.roadmap.resourceStore;
        
        // Recursive function to find all descendants
        const findDescendants = (parentId) => {
            const parentResource = resourceStore.getById(parentId);
            if (!parentResource || !parentResource.children) {
                return;
            }
            
            // Process all children
            parentResource.children.forEach(child => {
                childResources.push(child.id);
                // Recursively find descendants of this child
                findDescendants(child.id);
            });
        };
        
        // Start the recursive search
        findDescendants(parentResourceId);
        
        console.log(`Found ${childResources.length} child resources for parent ${parentResourceId}:`, childResources);
        return childResources;
    }
    
    /**
     * Updates the colors of all child resources recursively
     * @param {string} parentResourceId - The ID of the parent resource
     * @param {string} newColor - The new color to apply
     */
    updateChildResourceColors(parentResourceId, newColor) {
        const resourceStore = roadmapVue.$options.roadmap.resourceStore;
        const parentResource = resourceStore.getById(parentResourceId);
        
        if (!parentResource || !parentResource.children) {
            return;
        }
        
        // Recursive function to update all descendants
        const updateDescendants = (parentId) => {
            const parent = resourceStore.getById(parentId);
            if (!parent || !parent.children) {
                return;
            }
            
            // Update all children
            parent.children.forEach(child => {
                const childResource = resourceStore.getById(child.id);
                if (childResource) {
                    // Update the child resource color
                    childResource.color = newColor;
                    console.log(`Updated child resource color: ${childResource.name} (${child.id}) -> ${newColor}`);
                    
                    // Recursively update descendants of this child
                    updateDescendants(child.id);
                }
            });
        };
        
        // Start the recursive update
        updateDescendants(parentResourceId);
        
        // Refresh the roadmap to reflect the color changes
        roadmapVue.$options.roadmap.refresh();
    }
}
class SequenceManager{
    static generateNewItemSequence(seqeunceOfPreviousItem){
        if(seqeunceOfPreviousItem===null){
            return 1.0;
        }
        return seqeunceOfPreviousItem+1.0;
    }
    static generateSeqeunceOnReorder(sequenceOfNextItem,sequenceOfPreviousItem){
        if(sequenceOfNextItem===null){
            return sequenceOfPreviousItem+1.0;
        }
        return (sequenceOfNextItem+sequenceOfPreviousItem)/2.0;
    }
}


/**
 * RoadmapIdUtils - A utility class for handling ID derivations across different roadmap types
 * 
 * This class provides a flexible structure for extracting and manipulating IDs
 * in different roadmap implementations (Item Roadmap, OKR Roadmap, etc.)
 * 
 * @abstract
 */
class RoadmapIdUtils {
    /**
     * Constructor for RoadmapIdUtils
     * @param {Object} roadmapComponent - The roadmap component instance
     * @param {Object} options - Configuration options for the specific roadmap type
     */
    constructor(roadmapComponent, options = {}) {
        this.roadmapComponent = roadmapComponent;
        this.options = {
            // Default options
            resourceIdSeparator: '_',
            itemResourceIdFormat: 'groupId_item_itemId',
            itemsResourceIdFormat: 'groupId_items',
            defaultSectionId: 'null',
            ...options
        };
    }

    /**
     * Extract section ID from a resource ID
     * This is the main method that different roadmap types will implement
     * 
     * @param {string} resourceId - The resource ID to extract section from
     * @param {Object} context - Additional context (eventRecord, mode, etc.)
     * @returns {string} The extracted section ID
     */
    extractSectionId(resourceId, context = {}) {
        throw new Error('extractSectionId must be implemented by the specific roadmap type');
    }

    /**
     * Extract group ID from a resource ID
     * 
     * @param {string} resourceId - The resource ID to extract group from
     * @param {Object} context - Additional context
     * @returns {string} The extracted group ID
     */
    extractGroupId(resourceId, context = {}) {
        throw new Error('extractGroupId must be implemented by the specific roadmap type');
    }

    /**
     * Extract item ID from a resource ID
     * 
     * @param {string} resourceId - The resource ID to extract item from
     * @param {Object} context - Additional context
     * @returns {string} The extracted item ID
     */
    extractItemId(resourceId, context = {}) {
        throw new Error('extractItemId must be implemented by the specific roadmap type');
    }

    /**
     * Check if a resource ID represents a default section
     * 
     * @param {string} resourceId - The resource ID to check
     * @returns {boolean} True if it's a default section
     */
    isDefaultSection(resourceId) {
        return resourceId === this.options.defaultSectionId;
    }

    /**
     * Check if a resource ID represents an item resource
     * 
     * @param {string} resourceId - The resource ID to check
     * @returns {boolean} True if it's an item resource
     */
    isItemResource(resourceId) {
        const parts = resourceId.split(this.options.resourceIdSeparator);
        return parts.length >= 3 && parts[1] === 'item';
    }

    /**
     * Check if a resource ID represents an items resource (plural)
     * 
     * @param {string} resourceId - The resource ID to check
     * @returns {boolean} True if it's an items resource
     */
    isItemsResource(resourceId) {
        const parts = resourceId.split(this.options.resourceIdSeparator);
        return parts.length >= 2 && parts[1] === 'items';
    }

    /**
     * Get the resource type from a resource ID
     * 
     * @param {string} resourceId - The resource ID to analyze
     * @returns {string} The resource type ('item', 'items', 'section', 'default', 'unknown')
     */
    getResourceType(resourceId) {
        if (this.isDefaultSection(resourceId)) {
            return 'default';
        }
        if (this.isItemResource(resourceId)) {
            return 'item';
        }
        if (this.isItemsResource(resourceId)) {
            return 'items';
        }
        // Assume it's a section if it doesn't match other patterns
        return 'section';
    }

    /**
     * Parse a resource ID into its components
     * 
     * @param {string} resourceId - The resource ID to parse
     * @returns {Object} Parsed components {groupId, type, itemId, fullId}
     */
    parseResourceId(resourceId) {
        const parts = resourceId.split(this.options.resourceIdSeparator);
        
        if (this.isDefaultSection(resourceId)) {
            return {
                groupId: this.options.defaultSectionId,
                type: 'default',
                itemId: null,
                fullId: resourceId
            };
        }
        
        if (this.isItemResource(resourceId)) {
            return {
                groupId: parts[0],
                type: 'item',
                itemId: parts[2],
                fullId: resourceId
            };
        }
        
        if (this.isItemsResource(resourceId)) {
            return {
                groupId: parts[0],
                type: 'items',
                itemId: null,
                fullId: resourceId
            };
        }
        
        // Assume it's a section
        return {
            groupId: resourceId,
            type: 'section',
            itemId: null,
            fullId: resourceId
        };
    }
}

/**
 * ItemRoadmapIdUtils - Implementation for Item Roadmap
 * Handles both individual item resources mode and traditional mode
 */
class ItemRoadmapIdUtils extends RoadmapIdUtils {
    /**
     * Constructor for ItemRoadmapIdUtils
     * @param {Object} roadmapComponent - The item roadmap component instance
     * @param {Object} options - Additional options
     */
    constructor(roadmapComponent, options = {}) {
        super(roadmapComponent, {
            // Item roadmap specific options
            ...options
        });
    }

    /**
     * Extract section ID from a resource ID for Item Roadmap
     * Handles both individual item resources mode and traditional mode
     * 
     * @param {string} resourceId - The resource ID to extract section from
     * @param {Object} context - Additional context
     * @returns {string} The extracted section ID
     */
    extractSectionId(resourceId, context = {}) {
        if (!resourceId) {
            throw new Error('Resource ID is required');
        }

        // Handle default section
        if (this.isDefaultSection(resourceId)) {
            return this.options.defaultSectionId;
        }

        // Get the current mode from the roadmap component
        const showIndividualItemResources = this.roadmapComponent.showIndividualItemResources;
        
        if (showIndividualItemResources) {
            // Individual item resources mode: resourceId format is "groupId_item_itemId"
            if (this.isItemResource(resourceId)) {
                const parts = resourceId.split(this.options.resourceIdSeparator);
                return parts[0]; // Return group ID as section ID
            }
        } else {
            // Traditional mode: resourceId could be "groupId_items" or just "groupId"
            if (this.isItemsResource(resourceId)) {
                const parts = resourceId.split(this.options.resourceIdSeparator);
                return parts[0]; // Return group ID as section ID
            }
        }

        // If it doesn't match expected patterns, assume it's already a section ID
        return resourceId;
    }

    /**
     * Extract group ID from a resource ID for Item Roadmap
     * 
     * @param {string} resourceId - The resource ID to extract group from
     * @param {Object} context - Additional context
     * @returns {string} The extracted group ID
     */
    extractGroupId(resourceId, context = {}) {
        return this.extractSectionId(resourceId, context);
    }

    /**
     * Extract item ID from a resource ID for Item Roadmap
     * 
     * @param {string} resourceId - The resource ID to extract item from
     * @param {Object} context - Additional context
     * @returns {string|null} The extracted item ID or null if not applicable
     */
    extractItemId(resourceId, context = {}) {
        if (this.isItemResource(resourceId)) {
            const parts = resourceId.split(this.options.resourceIdSeparator);
            return parts[2]; // Return item ID
        }
        return null;
    }

    /**
     * Get the current section ID from an event record
     * This is a convenience method that combines context from eventRecord
     * 
     * @param {Object} eventRecord - The event record
     * @returns {string} The current section ID
     */
    getCurrentSectionIdFromEvent(eventRecord) {
        if (!eventRecord || !eventRecord.resource) {
            return this.options.defaultSectionId;
        }
        
        return this.extractSectionId(eventRecord.resource.id, {
            eventRecord: eventRecord,
            mode: this.roadmapComponent.showIndividualItemResources ? 'individual' : 'traditional'
        });
    }

    /**
     * Generate an item resource ID for individual item resources mode
     * 
     * @param {string} groupId - The group/section ID
     * @param {string} itemId - The item ID
     * @returns {string} The generated item resource ID
     */
    generateItemResourceId(groupId, itemId) {
        return `${groupId}_item_${itemId}`;
    }

    /**
     * Check if a resource ID is in the same section as another resource ID
     * 
     * @param {string} resourceId1 - First resource ID
     * @param {string} resourceId2 - Second resource ID
     * @returns {boolean} True if both are in the same section
     */
    isSameSection(resourceId1, resourceId2) {
        const section1 = this.extractSectionId(resourceId1);
        const section2 = this.extractSectionId(resourceId2);
        return section1 === section2;
    }

    /**
     * Get all possible section IDs that an item could be moved to
     * Excludes the current section
     * 
     * @param {string} currentResourceId - Current resource ID
     * @param {Array} availableSections - Array of available sections
     * @returns {Array} Filtered array of sections excluding current section
     */
    getAvailableSectionsForMove(currentResourceId, availableSections) {
        const currentSectionId = this.extractSectionId(currentResourceId);
        
        return availableSections.filter(section => {
            const sectionId = section.defaultSection ? this.options.defaultSectionId : section.id;
            return sectionId !== currentSectionId;
        });
    }
}

/**
 * OKRRoadmapIdUtils - Implementation for OKR Roadmap
 * This is a placeholder for future OKR roadmap implementation
 */
class OKRRoadmapIdUtils extends RoadmapIdUtils {
    /**
     * Extract section ID from a resource ID for OKR Roadmap
     * 
     * @param {string} resourceId - The resource ID to extract section from
     * @param {Object} context - Additional context
     * @returns {string} The extracted section ID
     */
    extractSectionId(resourceId, context = {}) {
        // TODO: Implement OKR roadmap specific logic
        // For now, return the resourceId as-is
        return resourceId || this.options.defaultSectionId;
    }

    /**
     * Extract group ID from a resource ID for OKR Roadmap
     * 
     * @param {string} resourceId - The resource ID to extract group from
     * @param {Object} context - Additional context
     * @returns {string} The extracted group ID
     */
    extractGroupId(resourceId, context = {}) {
        // TODO: Implement OKR roadmap specific logic
        return resourceId || this.options.defaultSectionId;
    }

    /**
     * Extract item ID from a resource ID for OKR Roadmap
     * 
     * @param {string} resourceId - The resource ID to extract item from
     * @param {Object} context - Additional context
     * @returns {string|null} The extracted item ID or null if not applicable
     */
    extractItemId(resourceId, context = {}) {
        // TODO: Implement OKR roadmap specific logic
        return null;
    }
}

/**
 * Factory function to create the appropriate ID utils instance
 * 
 * @param {string} roadmapType - Type of roadmap ('item', 'okr', etc.)
 * @param {Object} roadmapComponent - The roadmap component instance
 * @param {Object} options - Additional options
 * @returns {RoadmapIdUtils} The appropriate ID utils instance
 */
function createRoadmapIdUtils(roadmapType, roadmapComponent, options = {}) {
    switch (roadmapType.toLowerCase()) {
        case 'item':
            return new ItemRoadmapIdUtils(roadmapComponent, options);
        case 'okr':
            return new OKRRoadmapIdUtils(roadmapComponent, options);
        default:
            throw new Error(`Unknown roadmap type: ${roadmapType}`);
    }
}

// // Export the classes and factory function
// if (typeof module !== 'undefined' && module.exports) {
//     // Node.js environment
//     module.exports = {
//         RoadmapIdUtils,
//         ItemRoadmapIdUtils,
//         OKRRoadmapIdUtils,
//         createRoadmapIdUtils
//     };
// } else {
//     // Browser environment
//     window.RoadmapIdUtils = RoadmapIdUtils;
//     window.ItemRoadmapIdUtils = ItemRoadmapIdUtils;
//     window.OKRRoadmapIdUtils = OKRRoadmapIdUtils;
//     window.createRoadmapIdUtils = createRoadmapIdUtils;
// }
