var ROADMAP_MODULE

function initScheduler(_module) {
     ROADMAP_MODULE = _module;
}
loadModuleScript('/assets/js/lib/roadmap/v6.3.1/schedulerpro.module.min.js', initScheduler);

// Enhanced UX Helper Functions
function getStatusColor(category) {
    const statusColors = {
        'ToDo': '#5B6D86',
        'InProgress': '#007bff', 
        'Done': '#28a745',
        'Blocked': '#E3554E',
        'OnHold': '#ffc107'
    };
    return statusColors[category] || '##5B6D86';
}

/**
 * Get KR icon class based on progress criteria field
 * @param {Object} item - The objective or key result object
 * @param {string} progressCriteriaFieldId - The field ID for progress criteria
 * @returns {string} - The CSS class for the icon
 */
function getKrIconClass(item, progressCriteriaFieldId) {
    if (progressCriteriaFieldId && item && item.fields && item.fields[progressCriteriaFieldId]) {
        if (item.fields[progressCriteriaFieldId] === "By Items") {
            return "kricon3";
        } else if (item.fields[progressCriteriaFieldId] === "By Objectives") {
            return "kricon2";
        } else if (item.fields[progressCriteriaFieldId] === "Target") {
            return "kricon1";
        }
    }
    return "";
}

function addEnhancedStyles() {
    if (document.getElementById('okrs-roadmap-enhanced-styles')) return;
    
    const style = document.createElement('style');
    style.id = 'okrs-roadmap-enhanced-styles';
    style.textContent = `
        /* Enhanced OKRs Roadmap Styles */
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }
        
        @keyframes slideInRight {
            from { transform: translateX(20px); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        
        .enhanced-milestone-section {
            animation: slideInRight 0.3s ease-out;
        }
        
        .enhanced-group-header {
            transition: all 0.2s ease;
        }
        
        .enhanced-add-btn:hover {
            animation: pulse 1.5s infinite;
        }
        
        .enhanced-collection-icon:hover {
            transform: scale(1.05) !important;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15);
        }
        
        .enhanced-count {
            transition: all 0.3s ease;
        }
        /*
        .enhanced-objective-event:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        */
        .enhanced-kr-event:hover {
            transform: translateY(-1px);
            box-shadow: 0 2px 8px rgba(156, 39, 176, 0.2);
        }
        
        .enhanced-milestone-event:hover {
            transform: scale(1.02);
            box-shadow: 0 4px 12px rgba(108, 92, 231, 0.3);
        }
        
        .progress-mini {
            transition: all 0.3s ease;
        }
        
        /*
        .enhanced-header-event:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
        }
        */
        /* Tooltip animations */
        .enhanced-tooltip {
            animation: slideInRight 0.2s ease-out;
        }
        
        .enhanced-objective-tooltip {
            animation: slideInRight 0.2s ease-out;
        }
        
        /* Loading spinner enhancement */
        .enhanced-loader .loaderinteg {
            animation: spin 1s linear infinite;
        }
        
       
			        /* Toggle Buttons for Objectives View */
			        .toggle-buttons {
			            display: flex;
			            border: 1px solid #d1d5db;
			            border-radius: 6px;
			            overflow: hidden;
			            margin-right: 10px;
			        }
			        
			        .toggle-btn {
			            background: #f9fafb;
			            border: none;
			            padding: 8px 16px;
			            font-size: 13px;
			            font-weight: 500;
			            color: #6b7280;
			            cursor: pointer;
			            transition: all 0.2s ease;
			            white-space: nowrap;
			            border-right: 1px solid #d1d5db;
			        }
			        
			        .toggle-btn:last-child {
			            border-right: none;
			        }
			        
			        .toggle-btn:hover {
			            background: #f3f4f6;
			            color: #374151;
			        }
			        
			        .toggle-btn.active {
			            background: rgb(38, 186, 161);
			            color: white;
			            font-weight: 600;
			        }
			        
			        .toggle-btn.active:hover {
			            background: rgb(34, 167, 145);
			        }
        
        /* Milestone section enhancements */
        .milestone-arrow, .objective-arrow {
            transition: transform 0.2s ease;
        }
        
        .custom-view-badge, .group-icon {
            filter: drop-shadow(0 1px 2px rgba(0,0,0,0.2));
        }
        
        /* Progress ring animation */
        .enhanced-count-ring svg circle:last-child {
            transition: stroke-dashoffset 0.5s ease;
        }
        
        /* Status badge enhancements
        .enhanced-status-badge {
            text-transform: uppercase;
            letter-spacing: 0.5px;
            border: 1px solid rgba(255,255,255,0.2);
        } */
        
        /* Responsive tooltip improvements */
        @media (max-width: 768px) {
            .enhanced-objective-tooltip {
                min-width: 280px !important;
                max-width: 320px !important;
            }
        }
        
        /* Enhanced Context Menu Styles */
        .enhanced-menu-item {
            transition: all 0.2s ease !important;
            border-radius: 4px !important;
            margin: 2px 4px !important;
        }
        
        .enhanced-menu-item:hover {
            transform: translateX(4px) !important;
            box-shadow: 2px 0 8px rgba(0,0,0,0.1) !important;
        }
        
        .enhanced-menu-item.edit-item:hover {
            background: linear-gradient(135deg, #4CAF50, #45a049) !important;
            color: white !important;
        }
        
        .enhanced-menu-item.progress-item:hover {
            background: linear-gradient(135deg, #2196F3, #1976D2) !important;
            color: white !important;
        }
        
        .enhanced-menu-item.add-item:hover {
            background: linear-gradient(135deg, #FF9800, #F57C00) !important;
            color: white !important;
        }
        
        .enhanced-menu-item.delete-item:hover {
            background: linear-gradient(135deg, #f44336, #d32f2f) !important;
            color: white !important;
        }
        
        /* Enhanced scroll buttons */
        .b-scrollbutton {
            transition: all 0.2s ease !important;
            border-radius: 6px !important;
            cursor: pointer !important;
            position: relative !important;
        }
        
        .b-scrollbutton:hover {
            transform: scale(1.05) !important;
            box-shadow: 0 2px 8px rgba(0,0,0,0.15) !important;
            background: linear-gradient(135deg, #4CAF50, #45a049) !important;
            color: white !important;
        }
        
        .b-scrollbutton:active {
            transform: scale(0.95) !important;
            transition: transform 0.1s ease !important;
        }
        
        /* Add a subtle indicator for expandable groups */
        .b-scrollbutton[data-resource-id]:not([data-resource-id="-1001"]) {
            border-left: 3px solid #2196F3 !important;
        }
        
        /* Loading state for scroll buttons */
        .b-scrollbutton.loading {
            background: linear-gradient(135deg, #FF9800, #F57C00) !important;
            color: white !important;
            pointer-events: none !important;
        }
        
        .b-scrollbutton.loading::after {
            content: '⏳' !important;
            margin-left: 4px !important;
            animation: spin 1s linear infinite !important;
        }
        
        /* Minimized Splitter Styling */
        .b-splitter {
            width: 2px !important;
            background: rgba(0, 0, 0, 0.05) !important;
            border: none !important;
            transition: all 0.2s ease !important;
        }
        
        .b-splitter:hover {
            width: 4px !important;
            background: rgba(0, 0, 0, 0.1) !important;
            box-shadow: 0 0 4px rgba(0, 0, 0, 0.1) !important;
        }
        
        .b-splitter-handle {
            background: transparent !important;
            border: none !important;
            width: 2px !important;
        }
        
        .b-splitter-handle:hover {
            background: rgba(0, 0, 0, 0.1) !important;
            width: 4px !important;
        }
        
        /* Alternative minimal splitter - almost invisible */
        .b-grid-splitter {
            width: 1px !important;
            background: rgba(0, 0, 0, 0.03) !important;
            border: none !important;
        }
        
        .b-grid-splitter:hover {
            width: 3px !important;
            background: rgba(0, 0, 0, 0.08) !important;
        }
        
        /* Splitter resize cursor area */
        .b-splitter-element {
            width: 6px !important; /* Larger hit area for usability */
            margin-left: -2px !important; /* Center the hit area */
        }
        
        /* Custom minimal splitter class */
        .minimal-splitter {
            width: 1px !important;
            background: rgba(0, 0, 0, 0.02) !important;
            border: none !important;
            box-shadow: none !important;
        }
        
        .minimal-splitter:hover {
            width: 2px !important;
            background: rgba(0, 0, 0, 0.06) !important;
        }
        
        /* Hide splitter completely on mobile */
        @media (max-width: 768px) {
            .b-splitter, .b-grid-splitter, .minimal-splitter {
                display: none !important;
            }
        }
        
        /* Enhanced Expand/Collapse Indicator */
        .expand-indicator {
            transition: all 0.2s ease !important;
        }
        
        .expand-indicator:hover {
            background: rgba(255,255,255,0.3) !important;
            transform: scale(1.05) !important;
        }
        
        /* Enhanced Milestone Eye Icon
        .milestone-eye {
            transition: all 0.3s ease !important;
        }
        
        .milestone-eye:hover {
            background: rgba(255,255,255,0.2) !important;
            transform: scale(1.1) !important;
        }
        
        .milestone-eye.ti-eye {
            color: rgba(255,255,255,0.9) !important;
        }
        
        .milestone-eye.ti-eye-off {
            color: rgba(255,255,255,0.6) !important;
        } */
        .objective-resource-counts {
            font-size: 11px;
            color: #888;
            margin-top: 2px;
            letter-spacing: 0.2px;
            font-family: inherit;
        }
        .batch-board .timelineview.okrsrdmp.isFullScreen,
        body.fullscreen .batch-board .timelineview.okrsrdmp {
            margin-left: 0 !important;
        }
    `;
    document.head.appendChild(style);
}

// Initialize enhanced styles when DOM is ready
if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', addEnhancedStyles);
} else {
    addEnhancedStyles();
}

// Add enhanced tooltip scrollability for large content
if (!document.getElementById('kendis-tooltip-scroll-style')) {
    const style = document.createElement('style');
    style.id = 'kendis-tooltip-scroll-style';
    style.textContent = `
        .kendis-objective-tooltip, .kendis-milestone-tooltip {
            max-height: 350px;
            overflow-y: auto;
            overscroll-behavior: contain;
            scrollbar-width: thin;
        }
        .kendis-objective-tooltip::-webkit-scrollbar, .kendis-milestone-tooltip::-webkit-scrollbar {
            width: 6px;
            background: #f0f0f0;
        }
        .kendis-objective-tooltip::-webkit-scrollbar-thumb, .kendis-milestone-tooltip::-webkit-scrollbar-thumb {
            background: #d1d5db;
            border-radius: 3px;
        }
        /* Styles for association tags */
        .clctg, .clctg-more {
            display: inline-block;
            padding: 2px 8px;
            margin: 2px 4px 2px 0;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 500;
            color: white;
            white-space: nowrap;
        }
        .clctg-more {
            background-color: #6c757d !important;
            cursor: help;
            transition: background-color 0.2s ease;
        }
        .clctg-more:hover {
            background-color: #5a6268 !important;
        }
        /* Nested tooltip for associations */
        .association-nested-tooltip {
            position: absolute;
            background: #333;
            color: white;
            padding: 8px 12px;
            border-radius: 6px;
            font-size: 12px;
            line-height: 1.4;
            max-width: 250px;
            z-index: 10001;
            box-shadow: 0 2px 8px rgba(0,0,0,0.3);
            white-space: pre-line;
            pointer-events: none;
        }
        .association-nested-tooltip::before {
            content: '';
            position: absolute;
            top: -5px;
            left: 50%;
            transform: translateX(-50%);
            width: 0;
            height: 0;
            border-left: 5px solid transparent;
            border-right: 5px solid transparent;
            border-bottom: 5px solid #333;
        }
    `;
    document.head.appendChild(style);
}

// Global functions for association nested tooltips with delayed display
window.showAssociationTooltipDelayed = function(event, type, items, tooltipId) {
    // Clear any existing tooltip for this specific ID
    window.hideAssociationTooltipDelayed(tooltipId);
    
    // Add a delay to prevent conflicts with Bryntum's eventTooltip
    const delay = 800; // 800ms delay to ensure Bryntum tooltip has time to show
    
    const timeoutId = setTimeout(() => {
        // Check if the element is still being hovered and the main tooltip is visible
        const element = event.target;
        if (!element || !element.matches(':hover')) {
            return;
        }
        
        // Check if the parent tooltip is still visible
        const parentTooltip = element.closest('.b-tooltip-content, .kendis-objective-tooltip');
        if (!parentTooltip || !parentTooltip.offsetParent) {
            return; // Parent tooltip is not visible
        }
        
        const tooltip = document.createElement('div');
        tooltip.className = 'association-nested-tooltip';
        tooltip.id = tooltipId;
        tooltip.style.cssText = `
            position: absolute;
            background: #fff;
            border: 1px solid #ddd;
            border-radius: 6px;
            padding: 8px 12px;
            font-size: 12px;
            color: #333;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 10000;
            max-width: 250px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        `;

        // Create formatted list of items
        const itemList = items.map(item =>
            `• ${item.title || item.shortName || item.key || item.prefix || 'Unknown'}`
        ).join('<br>');
        tooltip.innerHTML = itemList;

        // Use the already found parent tooltip container
        const tooltipContainer = parentTooltip || document.body;

        // Position relative to the '+X more' tag inside the parent tooltip
        const tagRect = element.getBoundingClientRect();
        const parentRect = tooltipContainer.getBoundingClientRect();

        // Position just below the '+X more' tag, but inside the parent tooltip
        tooltip.style.left = (tagRect.left - parentRect.left) + 'px';
        tooltip.style.top = (tagRect.bottom - parentRect.top + 6) + 'px'; // 6px gap

        tooltipContainer.appendChild(tooltip);

        // Adjust if tooltip goes out of parent bounds
        const tooltipRect = tooltip.getBoundingClientRect();
        if (tooltipRect.right > parentRect.right) {
            tooltip.style.left = (parentRect.width - tooltipRect.width - 10) + 'px';
        }
        if (tooltipRect.left < parentRect.left) {
            tooltip.style.left = '10px';
        }
        if (tooltipRect.bottom > parentRect.bottom) {
            // show above the tag
            tooltip.style.top = (tagRect.top - parentRect.top - tooltipRect.height - 6) + 'px';
        }
        
        // Store the timeout ID for cleanup
        element.dataset.tooltipTimeoutId = timeoutId;
    }, delay);
    
    // Store the timeout ID for cleanup
    event.target.dataset.tooltipTimeoutId = timeoutId;
};

window.hideAssociationTooltipDelayed = function(tooltipId) {
    // Clear the timeout if it exists
    const element = document.querySelector(`[data-tooltip-id="${tooltipId}"]`);
    if (element && element.dataset.tooltipTimeoutId) {
        clearTimeout(parseInt(element.dataset.tooltipTimeoutId));
        delete element.dataset.tooltipTimeoutId;
    }
    
    // Remove the tooltip
    const existingTooltip = document.getElementById(tooltipId);
    if (existingTooltip) {
        existingTooltip.remove();
    }
};

// Legacy functions for backward compatibility
window.showAssociationTooltip = function(event, type, items) {
    window.showAssociationTooltipDelayed(event, type, items, 'association-nested-tooltip');
};

window.hideAssociationTooltip = function() {
    window.hideAssociationTooltipDelayed('association-nested-tooltip');
};

async function handleDateChange(eventRecord, startDate, endDate, context) {
    // Enhanced visual feedback during date change
    const eventElement = document.querySelector(`[data-event-id="${eventRecord.id}"]`);
    if (eventElement) {
        eventElement.style.transition = 'all 0.3s ease';
        eventElement.style.opacity = '0.7';
        eventElement.style.transform = 'scale(1.02)';
    }

    let input = {
        itemIdentifier:  (eventRecord.get('type') === 'Milestone' || eventRecord.get('type') === 'Phase' ) ? eventRecord.get("title"): eventRecord.name,
        startDate: startDate,
        endDate: endDate,
        prevStartDate: eventRecord.startDate,  // Previous start date (before drag/resize)
        prevEndDate: eventRecord.endDate,      // Previous end date (before drag/resize)
        showDateFields: true
    };

    if (eventRecord.get('type') === 'Milestone') {
        input.singleDateMode = true;
    } else {
        input.showTimePeriod = true;
    }

    // Add date restrictions for KR and child objective drag/resize operations
    if (eventRecord.get('type') === 'keyResult') {
        // Get the parent objective from the resource - handle prefixed resource IDs
        let parentResourceId = eventRecord.resource.id;
        let parentObjectiveId = eventRecord.resource.get('originalObjectiveId') || parentResourceId;
        
        // If the resource ID contains a dash and is not the milestone resource, extract the objective part
        if (parentObjectiveId.includes('-') && parentObjectiveId !== "-1001") {
            parentObjectiveId = parentObjectiveId.split('-').pop(); // Get the last part after the last dash
        }
        
        let parentObjective = roadmapVue.$options.cache.objectivesMap.get(parentObjectiveId);

        if (parentObjective) {
            input.parentObjective = parentObjective;
            input.isKrCreation = true; // Reuse the same logic as creation
            input.dateRestrictions = roadmapVue.getKrDateRestrictions(parentObjective);

            // Pre-validate the proposed dates before opening popup
            if (input.dateRestrictions) {
                const proposedStart = new Date(startDate);
                const proposedEnd = new Date(endDate);

                if ((proposedStart < input.dateRestrictions.minDate || proposedStart > input.dateRestrictions.maxDate) ||
                    (proposedEnd < input.dateRestrictions.minDate || proposedEnd > input.dateRestrictions.maxDate)) {

                    // Show warning and cancel the operation immediately
                    showTopMessageTargeted(
                        `KR dates must be within parent objective's timeframe: ${input.dateRestrictions.tooltip}`,
                        'warning',
                        5000,
                        roadmapVue.isFullScreen ? '.okrsrdmp' : null
                    );

                    // Restore original dates
                    eventRecord.startDate = input.prevStartDate;
                    eventRecord.endDate = input.prevEndDate;
                    context.finalize(false);
                    return;
                }
            }
        }
    } else if (eventRecord.get('type') === 'child-objective') {
        // Get the parent objective from the resource - handle prefixed resource IDs
        let parentResourceId = eventRecord.resource.id;
        let parentObjectiveId = eventRecord.resource.get('originalObjectiveId') || parentResourceId;
        
        // If the resource ID contains a dash and is not the milestone resource, extract the objective part
        if (parentObjectiveId.includes('-') && parentObjectiveId !== "-1001") {
            parentObjectiveId = parentObjectiveId.split('-').pop(); // Get the last part after the last dash
        }
        
        let parentObjective = roadmapVue.$options.cache.objectivesMap.get(parentObjectiveId);

        if (parentObjective) {
            input.parentObjective = parentObjective;
            input.isChildObjectiveCreation = true; // Reuse the same logic as creation
            input.dateRestrictions = roadmapVue.getChildObjectiveDateRestrictions(parentObjective);

            // Pre-validate the proposed dates before opening popup
            if (input.dateRestrictions) {
                const proposedStart = new Date(startDate);
                const proposedEnd = new Date(endDate);

                if ((proposedStart < input.dateRestrictions.minDate || proposedStart > input.dateRestrictions.maxDate) ||
                    (proposedEnd < input.dateRestrictions.minDate || proposedEnd > input.dateRestrictions.maxDate)) {

                    // Show warning and cancel the operation immediately
                    showTopMessageTargeted(
                        `Child objective dates must be within parent objective's timeframe: ${input.dateRestrictions.tooltip}`,
                        'warning',
                        5000,
                        roadmapVue.isFullScreen ? '.okrsrdmp' : null
                    );

                    // Restore original dates
                    eventRecord.startDate = input.prevStartDate;
                    eventRecord.endDate = input.prevEndDate;
                    context.finalize(false);
                    return;
                }
            }
        }
    }

    try {
        const response = await roadmapVue.openAndHandlePopup(input);
        
        // Success animation
        if (eventElement) {
            eventElement.style.opacity = '1';
            eventElement.style.transform = 'scale(1)';
            // eventElement.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
            setTimeout(() => {
                eventElement.style.background = '';
            }, 2000);
        }
        
        context.finalize(true);

        if (eventRecord.get('type') === 'Milestone' || eventRecord.get('type') === 'Phase') {
            roadmapVue.onChangeDatesMilestone(response.startDate, response.endDate, eventRecord.id);
        } else {
            roadmapVue.onChangeDates(response.startDate, response.endDate, eventRecord.id);
        }
        
        // Show success message with better styling
                            showTopMessageTargeted("Date updated successfully", 'success', 2000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
        
    } catch (error) {
        // Error animation
        if (eventElement) {
            eventElement.style.opacity = '1';
            eventElement.style.transform = 'scale(1)';
            eventElement.style.background = 'linear-gradient(135deg, #f44336, #d32f2f)';
            setTimeout(() => {
                eventElement.style.background = '';
            }, 2000);
        }
        // Restore original dates on cancel
        eventRecord.startDate = input.prevStartDate;
        eventRecord.endDate = input.prevEndDate;
        console.log(error);
        context.finalize(false);
        showTopMessageTargeted("Date change cancelled", 'warning', 4000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
    }
}

async function handleResourceChange(eventRecord, newResource, oldResource, context) {
    // Enhanced validation and UX feedback
    if(newResource.id===milestoneResourceId){
        // Enhanced error message with icon and better styling
        showTopMessageTargeted("Objectives cannot be moved to Milestones section", 'warning', 3000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
        context.finalize(false);
        return
    }
    
    // Visual feedback - highlight the target resource
    const targetResourceElement = document.querySelector(`[data-resource-id="${newResource.id}"]`);
    if (targetResourceElement) {
        targetResourceElement.style.transition = 'all 0.3s ease';
        targetResourceElement.style.background = 'linear-gradient(135deg, #2196F3, #1976D2)';
        targetResourceElement.style.boxShadow = '0 4px 12px rgba(33, 150, 243, 0.3)';
    }
    
    if (!newResource.expanded) {
        // Show loading indicator with better messaging
                        showTopMessageTargeted("Expanding objective group...", 'info', 1500, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
        
        scheduler.resourceStore.toggleCollapse(newResource.id)
        if (newResource.expanded) {
            await roadmapVue.loadObjectivesOfGroups(newResource.id);
        }
    }

    const fromGroup = roadmapVue.$options.cache.objectiveGroupsMap.get(oldResource.id);
    const toGroup = roadmapVue.$options.cache.objectiveGroupsMap.get(newResource.id);
    const objective = roadmapVue.$options.cache.objectivesMap.get(eventRecord.id);

    const objIdsList = roadmapVue.$options.cache.ObjectiveGroupsAndObjectivesRelationMap.get(toGroup.id);
    let objectiveListTemp = objIdsList.map(objId => roadmapVue.$options.cache.objectivesMap.get(objId));
    objectiveListTemp = _.orderBy(objectiveListTemp, ['sequence'], ['asc']);
    objectiveListTemp.push(objective);

    const evt = {
        newIndex: 0,
        oldIndex: 0,
        list: objectiveListTemp,
    };

    const obj = {
        evt: evt,
        list: objectiveListTemp,
        objective: objective,
        fromGroup: fromGroup,
        toGroup: toGroup,
        eventContext: context
    };

    // Enhanced confirmation dialog with better styling and context
    // Determine target container for fullscreen mode
    let targetContainer = null;
    if (roadmapVue.isFullScreen) {
        targetContainer = document.querySelector('.okrsrdmp');
    }
    
    // Get group names using the same logic as the resource renderer
    let getGroupDisplayName = (groupData) => {
        if (!roadmapVue.isGlobalObj && groupData && groupData.linkedCustomView && roadmapVue.linkedCustomViewsMap.has(groupData.linkedCustomView)) {
            const customView = roadmapVue.linkedCustomViewsMap.get(groupData.linkedCustomView);
            return `<span class="custom-view-badge"></span> ${customView.key} ${customView.title}`;
        } else {
            return `<span class="group-icon"></span> ${groupData.title}`;
        }
    };

    let fromGroupName = getGroupDisplayName(fromGroup);
    let toGroupName = getGroupDisplayName(toGroup);

    roadmapVue.$refs['kendis-alert'].fire({
        title: '🔄 Move Objective',
        text: `<div style="background: #f8f9fa; padding: 12px; border-radius: 8px; margin: 10px 0;    max-height: 105px;   overflow: hidden;">
            <strong>📋 ${objective.title}</strong><br>
            <small style="color: #5B6D86;">From: <span style="color: #dc3545;">${fromGroupName}</span> → To: <span style="color: #28a745;">${toGroupName}</span></small>
        </div>
        This action will move the objective to a different group.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Yes, move it!',
        cancelButtonText: 'Cancel',
        target: targetContainer
    }).then((result) => {
        if (result.isConfirmed) {
            roadmapVue.doUpdateSequenceInDB(obj);
        } else {
            // Cleanup visual feedback on cancel
            if (targetResourceElement) {
                targetResourceElement.style.background = '';
                targetResourceElement.style.boxShadow = '';
            }
            roadmapVue.revertFrontEndChanges(context);
        }
    });
}

function getOkrsRoadmapSchedulerConfig(roadmapComponent,project) {
    let _this = roadmapComponent;
    return {
        milestoneLayoutMode : 'data',
        milestoneCharWidth : 7,
        milestoneAlign : 'center',
        milestoneTextPosition : 'always-outside',
        // Set a very wide date range to support infinite scrolling
        startDate: new Date(1900, 0, 1),
        endDate: new Date(2100, 11, 31),
        // Enable infinite scrolling for unlimited timeline navigation
        infiniteScroll: true,
        createEventOnDblClick: false,
        columns: [
            {
                text: `Objective Groups`,
                field: 'name',
                type: roadmapComponent.isMultilevel ? 'tree' : undefined, // Set column type to 'tree' only in multilevel mode
                // flex:4,
                //minWidth: 242,
                minWidth: 210,
                //width: '100%',
                // readOnly: true,
                htmlEncode : false,
                // enableCellContextMenu:false,
                resizable  : false,
                sortable : false,
                filterable : false,
                groupable: false,
                hideable: false,
                editor: false,
                // expandedFolderIconCls  : null,
                // collapsedFolderIconCls : null,
                // leafIconCls            : null,
                renderer: function (data) {
                    // Enhanced styling with better color contrast and visual hierarchy
                    let baseColor = data.record.color ? data.record.color : "#3DC198";

                    if(data.record.isLeaf && data.record.id !== "-1001"){
                        //get the parent color
                        let parentResource = scheduler.resourceStore.getById(data.record.parentId);
                        baseColor = parentResource.color || "#3DC198";
                    }


                    const lightColor = lightenHexColor(baseColor, 0, 0.19);
                    data.cellElement.style.background = `linear-gradient(135deg, ${lightColor}, ${lightenHexColor(baseColor, 0, 0.25)})`;
                    data.cellElement.style.borderLeft = `4px solid ${baseColor}`;
                    data.cellElement.style.transition = 'all 0.2s ease';
                    data.cellElement.style.position = 'relative';
                    data.cellElement.style.overflow = 'hidden';
                    data.cellElement.addEventListener('mouseenter', function() {
                        this.style.transform = 'translateX(2px)';
                        this.style.boxShadow = '2px 0 8px rgba(0,0,0,0.1)';
                    });
                    data.cellElement.addEventListener('mouseleave', function() {
                        this.style.transform = 'translateX(0)';
                        this.style.boxShadow = 'none';
                    });
                    let keyHtml = '';
                    let cachedObj = roadmapVue.$options.cache.objectiveGroupsMap.get(data.record.id) || roadmapVue.$options.cache.objectivesMap.get(data.record.id);
                    if (cachedObj && cachedObj.key) {
                        keyHtml = `<span class='kendis-ir-item-key enhanced-key' style="margin-right:6px;">${cachedObj.key}</span>`;
                    }
                    let lastResourceId = scheduler.resourceStore.last.id;
                    let countOfAssignments = scheduler.assignmentStore.getAssignmentsForResource(data.record).length;

                    // Handle milestone resource
                    if (data.record.id === "-1001") {
                        data.cellElement.style.background = '#4587D5';
                        data.cellElement.style.borderLeft = '4px solid #3764B0';
                        let miletonesCount = roadmapVue.milestoneData.milestones.length;
                        return `
                            <div class="titleout resource-scheduler enhanced-milestone-section">
                                <div class="roadmap-arrow-show-resource-items mr-10">
                                    <i class="arrdokrw trnsn c-point DIB ${data.record.expanded ? 'active' : ''}"></i>
                                </div>
                                <div class="milestone-header">Milestones</div>
                                <div class='ml-10 cntval enhanced-count'>${miletonesCount}</div>
                                <a class='add ico ti-plus addButtonMile ml-10 enhanced-add-btn' 
                                   href='javascript:void(0);' 
                                   onclick='roadmapVue.showMilestoneMenu(event); event.stopPropagation();'
                                   title="Add New Milestone"></a>
                            </div>`;
                    }
                    
                    // Handle objectives (leaf resources) - only in multilevel mode
                    if (roadmapComponent.isMultilevel && data.record.isLeaf && data.record.id !== "-1001") {
                        // Extract original objective ID from prefixed resource ID
                        let objectiveId = data.record.get('originalObjectiveId') || data.record.id;
                        // If the ID contains a dash, it's prefixed with group ID, so extract the objective part
                        if (objectiveId.includes('-') && objectiveId !== "-1001") {
                            objectiveId = objectiveId.split('-').pop(); // Get the last part after the last dash
                        }
                        let objectiveData = roadmapVue.$options.cache.objectivesMap.get(objectiveId);
                        let progressPercent = objectiveData ? (objectiveData.percentDone || 0) : 0;
                        // Permission checks
                        let canEdit = ComponentPermissionManager.hasPermission(roadmapVue, 'EDIT_OBJECTIVE');
                        let canCreateKR = ComponentPermissionManager.hasPermission(roadmapVue, 'EDIT_OKR');
                        let canLink = ComponentPermissionManager.hasPermission(roadmapVue, 'LINK_UNLINK_OBJECTIVE_ITEMS');
                        let canCreateObjective = ComponentPermissionManager.hasPermission(roadmapVue, 'EDIT_OBJECTIVE');
                        let canDelete = ComponentPermissionManager.hasPermission(roadmapVue, 'DELETE_OBJECTIVE');
                        // Key and name vertical
                        let keyHtml = '';
                        if (objectiveData && objectiveData.key) {
                            keyHtml = `<div class='kendis-ir-item-key enhanced-key c-point' 
                                         style="font-size:12px; font-weight:600; color:#26baa1; cursor: pointer; text-decoration: underline;" 
                                         onclick="event.stopPropagation(); roadmapVue.openObjectiveEditPopup(roadmapVue.$options.cache.objectivesMap.get('${objectiveId}'));"
                                         title="Click to edit objective">
                                         ${objectiveData.key}
                                       </div>`;
                        }
                        let nameHtml = `<div class='objective-resource-name' style="font-size:13px; font-weight:500; color:#222;">${data.record.name}</div>`;
                        
                        // Progress information
                        let progressHtml = '';
                        if (objectiveData && objectiveData.percentDone !== undefined) {
                            let progressColor = objectiveData.percentDone >= 75 ? '#4CAF50' : 
                                              objectiveData.percentDone >= 50 ? '#FF9800' : 
                                              objectiveData.percentDone >= 25 ? '#2196F3' : '#D3605E';
                            progressHtml = `<div class='objective-resource-progress' style="font-size:11px; color:${progressColor}; font-weight:600; margin-top:2px;">${objectiveData.percentDone}%</div>`;
                        }
                        
                        // Status information
                        let statusHtml = '';
                        if (objectiveData && objectiveData.status) {
                            let statusColor = getStatusColor(objectiveData.status.category);
                            statusHtml = `<div class='objective-resource-status' style="font-size:10px; background:${statusColor}; color:white; padding:1px 6px; border-radius:8px; margin-top:2px; display:inline-block;">${objectiveData.status.title}</div>`;
                        }
                        
                        // Responsible person
                        // let responsibleHtml = '';
                        // if (objectiveData && objectiveData.fields) {
                        //     let responsibleFieldId = roadmapVue.getResponsibleFieldIdFromBaseItem("Objective");
                        //     let responsible = objectiveData.fields[responsibleFieldId];
                        //     if (responsible) {
                        //         let avatar = getUserIcon(responsible);
                        //         responsibleHtml = `<div class='objective-resource-responsible' style="font-size:11px; color:#666; margin-top:2px; display:flex; align-items:center; gap:4px;">${avatar} ${responsible.fullName || responsible.name || 'Unknown'}</div>`;
                        //     }
                        // }
                        //
                        // Count of linked KRs and child objectives
                        let krCount = 0, objCount = 0;
                        if (objectiveData && Array.isArray(objectiveData.baseItemList)) {
                            for (var i = 0; i < objectiveData.baseItemList.length; i++) {
                                var item = objectiveData.baseItemList[i];
                                if (item.type === 'KR' || item.type === 'KeyResult') krCount++;
                                if (item.type === 'Objective' || item.type === 'Objective-Committed') objCount++;
                            }
                        }
                        // Only show count if there are items (greater than 0) in multilevel mode
                        let countHtml = '';
                        if (roadmapComponent.isMultilevel && (krCount > 0 || objCount > 0)) {
                            let countText = '';
                            if (krCount > 0 && objCount > 0) {
                                countText = `KR: ${krCount}, OBJ: ${objCount}`;
                            } else if (krCount > 0) {
                                countText = `KR: ${krCount}`;
                            } else if (objCount > 0) {
                                countText = `OBJ: ${objCount}`;
                            }
                            countHtml = `<div class='objective-resource-counts' style="font-size:11px; color:#888; margin-top:2px;">${countText}</div>`;
                        }
                        return `
                            <div class="titleout resource-scheduler enhanced-objective-resource" style="flex: 1;">
                                <div class='roadmapLevels resource-scheduler objective-title' style="flex: 1; display: flex; flex-direction: column; align-items: flex-start; gap: 2px;">
                                    ${keyHtml}
                                    ${nameHtml}
                                    ${progressHtml}
                                    ${statusHtml}
                                    ${countHtml}
                                </div>
                                <span class="rnd4 hovbtns trnsn b resource-actions">
                                    ${canEdit ? `<div class="obedit c-point tooltip action-icon" onclick="event.stopPropagation(); roadmapVue.handleObjectiveEdit('${objectiveId}');">
                                        <div class="hovtooltipBbtm">Edit</div>
                                    </div>` : ''}
                                    ${canCreateKR ? `<div class="obtarg c-point tooltip action-icon" onclick="event.stopPropagation(); roadmapVue.handleCreateKR('${objectiveId}');">
                                        <div class="hovtooltipBbtm">Create Key Result</div>
                                    </div>` : ''}
                                    ${canCreateObjective ? `<div class="obmadd c-point tooltip action-icon" onclick="event.stopPropagation(); roadmapVue.handleCreateChildObjective('${objectiveId}');">
                                        <div class="hovtooltipBbtm">Create Objective</div>
                                    </div>` : ''}
                                    ${canLink ? `<div class="oblnk2 c-point tooltip action-icon" onclick="event.stopPropagation(); roadmapVue.handleLinkObjective('${objectiveId}');">
                                        <div class="hovtooltipBbtm">Link Objective</div>
                                    </div>` : ''}
                                    ${canDelete ? `<div class="delokr c-point tooltip action-icon" onclick="event.stopPropagation(); roadmapVue.confirmDeleteObjective(roadmapVue.$options.cache.objectivesMap.get('${objectiveId}'));">
                                        <div class="hovtooltipBbtm">Delete Objective</div>
                                    </div>` : ''}
                                </span>
                            </div>`;
                    }

                    // Handle objective groups (non-leaf resources)
                    let objectiveGroupName = '';
                    let cachedData = roadmapVue.$options.cache.objectiveGroupsMap.get(data.record.id)
                    let resource =``;
                    if(!data.record.isLeaf){
                        // In multilevel mode, do not render the expand/collapse arrow for groups
                        if (roadmapComponent.isMultilevel) {
                            resource = `<div class="roadmap-arrow-show-resource-items mr-10">
                                <i class="arrdokrb trnsn c-point DIB ${data.record.isExpanded() ? 'active' : ''} objective-arrow"></i>
                            </div>`;
                        } else {
                            resource = `<div class="roadmap-arrow-show-resource-items mr-10">
                                <i class="arrdokrb trnsn c-point DIB ${data.record.expanded ? 'active' : ''} objective-arrow"></i>
                            </div>`;
                        }
                    }
                    if(!roadmapVue.isGlobalObj && cachedData && cachedData.linkedCustomView && roadmapVue.linkedCustomViewsMap.has(cachedData.linkedCustomView)){
                        const customView = roadmapVue.linkedCustomViewsMap.get(cachedData.linkedCustomView);
                        objectiveGroupName = `<span class="custom-view-badge"></span> ${customView.key} ${customView.title}`;
                    } else {
                        objectiveGroupName = `<span class="group-icon"></span> ${keyHtml}${data.record.name}`;
                    }
                    // Enhanced collection icon
                        let collection = roadmapVue.getCollection(data.record.id);
                        let collectionIcon = '';
                        if(roadmapVue.isGlobalObj && collection && collection.type){
                            collectionIcon = `<div data-key="${collection.key}" 
                                data-type="${collection.type.prefix}" 
                                onclick="roadmapVue.onClickCollectionObjectiveIcon(this)" 
                                class="ml-10 group-coll-icon c-point enhanced-collection-icon"
                                title="View in ${collection.type.title}"
                                style="background: rgba(255,255,255,0.15); border-radius: 6px; padding: 4px; transition: all 0.2s ease;"
                                onmouseenter="this.style.background='rgba(255,255,255,0.25)'; this.style.transform='scale(1.05)'"
                                onmouseleave="this.style.background='rgba(255,255,255,0.15)'; this.style.transform='scale(1)'">
                                <i class="material-symbols-outlined icol" style="color: rgb(51, 137, 202); font-size: 18px;">${collection.type.icon}</i>
                            </div>`;
                        }

                        // Enhanced loading indicator
                        if(data.record.isLoading){
                            resource += `<div class="loader enhanced-loader" style="
                                        background-color: transparent;
                                        position: static;
                                margin-left: 10px;
                                                            ">
                                <div style="display: flex; align-items: center;">
                                    <div class="loaderinteg" style="width: 16px; height: 16px; border: 2px solid rgba(255,255,255,0.3); border-top: 2px solid white; border-radius: 50%; animation: spin 1s linear infinite;"></div>
                                    <span style="margin-left: 8px; font-size: 11px; color: rgba(255,255,255,0.8);">Loading...</span>
                                        </div>
                            </div>`;
                        }
                    return `${resource}<div class="titleout resource-scheduler enhanced-group-header" style="flex: 1;">
                        <div class='roadmapLevels resource-scheduler objective-group-title' style="flex: 1;">${objectiveGroupName}</div>
                        ${collectionIcon}
                        <div class="resource-actions">
                            <div class="action-icon DFCB edit-group tooltip" 
                                 onclick="event.stopPropagation(); roadmapVue.openObjectiveGroupEditPopup(roadmapVue.$options.cache.objectiveGroupsMap.get('${data.record.id}'));">
                                <i class="editokr ico"></i>
                                <div class="hovtooltipBbtm">Edit Group</div>
                            </div>
                            <div class="action-icon DFCB add-objective tooltip" 
                                 onclick="event.stopPropagation(); roadmapVue.addObjectiveToObjectiveGroup({dataset: {id: '${data.record.id}'}});">
                                <i class="addokr ico"></i>
                                <div class="hovtooltipBbtm">Add Objective</div>
                            </div>                            
                            <div class="action-icon DFCB show-progress tooltip"
                                 onclick="event.stopPropagation(); roadmapVue.initGroupProgressPopup('${data.record.id}')">
                                <i class="progokr ico"></i>
                                <div class="hovtooltipBbtm">Show Progress</div>
                            </div>
                            <div class="action-icon DFCB delete-group tooltip" 
                                onclick="event.stopPropagation(); roadmapVue.onDeleteObjGrpPopup('${data.record.id}');">
                                <i class="delokr ico"></i>
                                <div class="hovtooltipBbtm">Delete Group</div>
                        </div>
                        </div>
                    </div>`;
                
                 

                },

                // renderer: function (data) {
                //
                // },
                // headerRenderer: ({ column }) => {
                //
                // }
                // cellCls: 'vertical-resource'
            }
        ],
        // autoHeight: true,
        eventRenderer(event) {
            try {
                // Enhanced header events with better visual design
                if (event.eventRecord.get('isHeader')) {
                    // Use stable count from cached data instead of dynamic assignment calculation
                    let resourceId = event.eventRecord.resource.id;
                    let cachedObjGrp = roadmapVue.$options.cache.objectiveGroupsMap.get(event.eventRecord.id.split('-')[3]);
                    let resourceRecord = event.eventRecord.resource;
                    
                    // Use centralized count management utility
                    const countData = roadmapVue.getObjectiveGroupCount(resourceId);
                    let stableCount = countData.count;

                    // Enhanced status display with better styling
                    let statusColor = getStatusColor(cachedObjGrp.status.category);
                    let statusDiv = `<div class="status nw DAJ enhanced-status">
                        <span class="sts enhanced-status-badge" 
                              style="background: ${statusColor};">
                            ${cachedObjGrp.status.title}
                        </span>
                    </div>`;

                    // Enhanced count display with progress ring (using stable count)
                    let countDiv = stableCount > 0 ? `
                        <div class="ml-10 cntval DAJ kendis-items-roadmap-item-count enhanced-count-ring ${countData.cssClass}" 
                             title="${countData.tooltip}">                            
                            ${stableCount}
                        </div>
                    ` : ``;
                    
                    // Enhanced progress percentage with gradient
                    let progressColor = event.eventRecord.percentDoneGroup >= 75 ? '#4CAF50' : 
                                      event.eventRecord.percentDoneGroup >= 50 ? '#FF9800' : 
                                      event.eventRecord.percentDoneGroup >= 25 ? '#2196F3' : '#D3605E';
                    
                    // Expanded/Collapsed indicator

                    
                    // Returns expand/collapse indicator based on isMultilevel logic
                    var isExpanded = false;
                    if (roadmapComponent.isMultilevel) {
                        // In multilevel mode, use isExpanded() method
                        isExpanded = resourceRecord.isExpanded();
                    } else {
                        // Otherwise, use expanded property
                        isExpanded = resourceRecord.expanded;
                    }
                    var expandIndicator = isExpanded
                        ? '<em class="arrdokrb DIB c-point mr-10 active"></em>'
                        : '<em class="arrdokrb DIB c-point mr-10"></em>';
                    // Add Objective button for group header
                    let  addButton = '';
                    if ( PermissionManager.hasPermission('EDIT_OBJECTIVE')) {
                        addButton=   `<div class="action-icon DFCB add-objective-header-btn" 
                             onclick="event.stopPropagation(); roadmapVue.addObjectiveToObjectiveGroup({dataset: {id: '${resourceId}'}});"
                             title="Add Objective">
                            <i class="ti-plus ico"></i> 
                        </div>
                    `;
                    }
                    
                    return `<div class='DFA length a enhanced-header-event' style="padding: 0 5px;">
                        <div class='kendis-items-roadmap-item-title enhanced-title ${event.eventRecord.eventColor !== "" && isDarkColor(event.eventRecord.eventColor) ? 'whtclr' : ''}' 
                             style="font-weight: 500; font-size: 13px; display: flex; align-items: center; color: #000;">
                             ${expandIndicator} ${event.eventRecord.name}
                        </div>                
                        ${addButton}
                        ${countDiv}
                        
                        <div class="kendis-items-roadmap-item-percent enhanced-progress ml-10 mr-10" style="background: ${progressColor};">
                            ${event.eventRecord.percentDoneGroup}%
                        </div>
                        
                        ${statusDiv}
                    </div>`;
                }

                // Enhanced objective events
                if (event.eventRecord.get('type') === 'objective' || event.eventRecord.get('type') === 'child-objective') {
                    // Use event ID directly since we're no longer using prefixed event IDs
                    let objective = roadmapVue.$options.cache.objectivesMap.get(event.eventRecord.id);
                    let keySpan = event.eventRecord.get('type') === 'objective' ? 
                                `<span class="kendis-ir-item-key enhanced-key c-point" 
                                       style="background-color: ${objective.status.category === "ToDo" ? "#E79362" : objective.status.category === "InProgress" ? "#3792C9" : objective.status.category === "Done" ? "#3FCA93" : "#7c50b1"}; cursor: pointer; text-decoration: underline;" 
                                       onclick="event.stopPropagation(); roadmapVue.openObjectiveEditPopup(roadmapVue.$options.cache.objectivesMap.get('${event.eventRecord.id}'));"
                                       title="Click to edit objective">
                                    ${objective ? objective.key : ''}
                                   </span>`
                            : `<span class="kendis-ir-item-key enhanced-key c-point" 
                                     style="cursor: pointer; text-decoration: underline;" 
                                     onclick="event.stopPropagation(); roadmapVue.openObjectiveEditPopup(roadmapVue.$options.cache.objectivesMap.get('${event.eventRecord.id}'));"
                                     title="Click to edit objective">
                                    ${objective ? objective.key : ''}
                                   </span>`;

                    if(objective.fields) {
                        let responsible = objective.fields[roadmapVue.getResponsibleFieldIdFromBaseItem("Objective")];
                        let avatar = responsible ? getUserIcon(objective.fields[roadmapVue.getResponsibleFieldIdFromBaseItem("Objective")]) : '';
                        
                        // Enhanced progress indicator
                        let progressPercent = event.eventRecord.percentDone || 0;
                        
                        // Get KR icon for child objectives
                        let krIcon = '';
                        if (event.eventRecord.get('type') === 'child-objective' && roadmapVue.okrProgressCriteriaField && roadmapVue.okrProgressCriteriaField.id) {
                            let iconClass = getKrIconClass(objective, roadmapVue.okrProgressCriteriaField.id);
                            if (iconClass) {
                                krIcon = `<i class="${iconClass}" style="margin-left: 8px; font-size: 14px; color: #26BAA1;" title="Progress Criteria"></i>`;
                            }
                        }
                        
                        return `<div class='DFA length b enhanced-objective-event'>
                            ${keySpan}     
                            <span class='kendis-items-roadmap-item-title elips enhanced-objective-title ${event.eventRecord.eventColor !== "" && isDarkColor(event.eventRecord.eventColor) ? 'whtclr' : ''}' 
                                  style=" flex: 1;">
                                 ${event.eventRecord.name}
                            </span>
                            <div class="prcnt">${progressPercent}%${krIcon}</div>                            
                        </div> 
                        <span class='pic ml-10 enhanced-avatar' style="display: flex; align-items: center;">${avatar}</span>`;
                    } else {
                        return `<div class='DFA length b enhanced-objective-event'>
                            ${keySpan}     
                            <span class='kendis-items-roadmap-item-title elips enhanced-objective-title ${event.eventRecord.eventColor !== "" && isDarkColor(event.eventRecord.eventColor) ? 'whtclr' : ''}'>
                                ${event.eventRecord.name}
                            </span>
                        </div>`;
                    }
                }
                
                // Enhanced key result events - only in multilevel mode
                if (roadmapComponent.isMultilevel && event.eventRecord.get('type') === 'keyResult') {
                    // Use event ID directly since we're no longer using prefixed event IDs
                    let keyResult = roadmapVue.$options.cache.keyResultsMap.get(event.eventRecord.id);
                    let keySpan = `<span class="kendis-ir-item-key enhanced-kr-key c-point" 
                                       style="cursor: pointer; text-decoration: underline;" 
                                       onclick="event.stopPropagation(); roadmapVue.openKRModelForEditing(roadmapVue.$options.cache.keyResultsMap.get('${event.eventRecord.id}'), true, roadmapVue.$options.cache.objectivesMap.get('${event.eventRecord.resource.get('originalObjectiveId') || event.eventRecord.resource.id.split('-').pop()}'));"
                                       title="Click to edit key result">
                                    ${keyResult ? keyResult.key : ''}
                                   </span>`;

                    if(keyResult.fields){
                        let responsible = keyResult.fields[roadmapVue.getResponsibleFieldIdFromBaseItem("KeyResult")];
                        let avatar = responsible ? getUserIcon(keyResult.fields[roadmapVue.getResponsibleFieldIdFromBaseItem("KeyResult")]) : '';

                        // Enhanced progress indicator
                        let progressPercent = event.eventRecord.percentDone || 0;
                        
                        // Get KR icon for key results
                        let krIcon = '';
                        if (roadmapVue.okrProgressCriteriaField && roadmapVue.okrProgressCriteriaField.id) {
                            let iconClass = getKrIconClass(keyResult, roadmapVue.okrProgressCriteriaField.id);
                            if (iconClass) {
                                krIcon = `<i class=" DIB kricona ${iconClass}" title="Progress Criteria"></i>`;
                            }
                        }

                        return `<div class='DFA length b enhanced-objective-event'>
                            ${keySpan}     
                            <span class='kendis-items-roadmap-item-title elips enhanced-objective-title ${event.eventRecord.eventColor !== "" && isDarkColor(event.eventRecord.eventColor) ? 'whtclr' : ''}' 
                                  style=" flex: 1;">
                                 ${event.eventRecord.name}
                            </span>
                            <div class="prcnt">${progressPercent}%</div>     
                            ${krIcon}                       
                        </div> 
                        <span class='pic ml-10 enhanced-avatar' style="display: flex; align-items: center;">${avatar}</span>`;
                    }else{
                        return `<div class='DFA length b enhanced-objective-event'>
                            ${keySpan}     
                            <span class='kendis-items-roadmap-item-title elips enhanced-objective-title ${event.eventRecord.eventColor !== "" && isDarkColor(event.eventRecord.eventColor) ? 'whtclr' : ''}'>
                                ${event.eventRecord.name}
                            </span>
                        </div>`;
                    }
                    return `<div class='DFA length c enhanced-kr-event' style="padding: 6px 8px; border-radius: 6px; background: rgba(156, 39, 176, 0.1); border-left: 3px solid #9C27B0;">
                            ${keySpan}     
                            <span class='kendis-items-roadmap-item-title elips enhanced-kr-title ${event.eventRecord.eventColor !== "" && isDarkColor(event.eventRecord.eventColor) ? 'whtclr' : ''}'>
                    			${event.eventRecord.name}
                            </span>
                        </div>`;
                } 
                
                // Enhanced milestone events
                else if(event.eventRecord.resource.id === milestoneResourceId){
                    return `<div class='DFA length d'>
					<span class='kendis-items-roadmap-item-title' style="margin-left: 20px;">${event.eventRecord.originalData.kendisKey}</span>
						</div>`;
                }
                else {
                    return `<div class='DFA length d ' >
                        <span class='kendis-items-roadmap-item-title' 
                              style="margin-left: 12px; font-weight: 500; font-size: 12px;">
                            <em class="objectives2"></em> Objective
                        </span>
						</div>`;
                }
            } catch (e) {
                return `<div class='DFA length d enhanced-error-event' style="padding: 6px 8px; border-radius: 6px; background: rgba(244, 67, 54, 0.1); border-left: 3px solid #f44336;">
                    <span class="error-icon" style="margin-right: 8px; color: #f44336;">⚠️</span>
                    <span class='kendis-items-roadmap-item-title enhanced-error-title mr-10' 
                          style="color: #f44336; font-weight: 500; font-size: 12px;">
                        Invalid item
                    </span>
                </div>`;
            }
        },
        listeners: {
            cellClick({record,column,event}) {
                if (event.target.closest('.roadmap-arrow-show-resource-items') || event.target.closest('.resource-scheduler')) {

                    if(record.id===milestoneResourceId ){
                       toggleResourceExpandByAssignments(record, 'X', scheduler);
                       if(record.expanded){
                        _this.addMilestones();
                    }
                    } else {
                        if(record.isLeaf){
                            return;
                        }
                        if(roadmapComponent.isMultilevel){
                            scheduler.resourceStore.toggleCollapse(record.id)
                            _this.loadObjectivesOfGroups(record.id)
                        }else{
                            toggleResourceExpandByAssignments(record, 'X', scheduler);
                            if(record.expanded){
                                _this.loadObjectivesOfGroups(record.id)
                            }
                          
                        }
                    }
                    scheduler.refresh();
                }
            },
            eventClick: async function (event) {
                let eventRecord = event.eventRecord;
                if (eventRecord.get('isHeader')) {
                    if(roadmapComponent.isMultilevel){
                        scheduler.resourceStore.toggleCollapse(eventRecord.resource.id);
                        scheduler.refresh();
                        _this.loadObjectivesOfGroups(eventRecord.resource.id)
                    }else{
                        toggleResourceExpandByAssignments(eventRecord.resource, 'X', scheduler);
                        if(eventRecord.resource.expanded){
                            _this.loadObjectivesOfGroups(eventRecord.resource.id)
                        }
                    }
                
                    
                }
                if (eventRecord.get('type') === 'objective' || eventRecord.get('type') === 'child-objective') {
                    // Use event ID directly since we're no longer using prefixed event IDs
                    let objective = roadmapVue.$options.cache.objectivesMap.get(eventRecord.id);
                    roadmapVue.openObjectiveEditPopup(objective);
                }
                if(eventRecord.get('type') === 'keyResult'){
                    // Use event ID directly since we're no longer using prefixed event IDs
                    let keyResult = roadmapVue.$options.cache.keyResultsMap.get(eventRecord.id);
                    // Extract original objective ID from resource ID for parent lookup
                    let parentObjectiveId = eventRecord.resource.get('originalObjectiveId') || eventRecord.resource.id;
                    // If the ID contains a dash, it's prefixed with group ID, so extract the objective part
                    if (parentObjectiveId.includes('-') && parentObjectiveId !== "-1001") {
                        parentObjectiveId = parentObjectiveId.split('-').pop(); // Get the last part after the last dash
                    }
                    let parent = roadmapVue.$options.cache.objectivesMap.get(parentObjectiveId);
                    roadmapVue.openKRModelForEditing(keyResult,true,parent);
                }
                if(_this.milestoneMapById[eventRecord.id]){
                    let item = roadmapVue.milestoneMapById[eventRecord.id];
                    if (item) {
                        item = _.cloneDeep(item);
                        roadmapVue.onCreateMilestonePopup(null, item);
                    }
                }
            },
            beforeEventResizeFinalize: async function(event) {
                let { source, context, eventRecord, startDate,
                    endDate, originalStartDate, originalEndDate,
                    async, finalize, resizeData } = event;

                await handleDateChange(eventRecord, startDate, endDate, event.context);

            },
            beforeEventDropFinalize: async function (event) {
                let { startDate, endDate, newResource, resourceRecord: oldResource, eventRecords } = event.context;
                let eventRecord = eventRecords[0];
                event.context.async = true;

                if (newResource.id === oldResource.id) {
                    await handleDateChange(eventRecord, startDate, endDate, event.context);
                } else {
                    // Block moving between resources
                    showTopMessageTargeted("Drag & drop between resources is disabled", 'warning', 3000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                    event.context.finalize(false);
                    return;
                }
                scheduler.refresh()
            },
            beforeDragCreate(event) {
                return false;
                let resourceRecord = event.resourceRecord;
                
                // Check EDIT_OBJECTIVE permission
                if (!PermissionManager.checkPermissionWithMessage('EDIT_OBJECTIVE', 'create objectives')) {
                    return false;
                }
                
                // Block drag-to-create on the milestones resource
                if (resourceRecord.id === milestoneResourceId) {
                    // showTopMessageTargeted("Cannot create items directly in the Milestones section", 'warning', 3000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                    return false;
                }
                // Enhanced visual feedback for drag creation
                if (!resourceRecord.expanded) {
                    // Add visual feedback for unexpanded groups
                    const resourceElement = document.querySelector(`[data-resource-id="${resourceRecord.id}"]`);
                    if (resourceElement) {
                        resourceElement.style.animation = 'pulse 0.5s ease-in-out 2';
                        //resourceElement.style.border = '2px dashed #ff9800';
                        setTimeout(() => {
                            resourceElement.style.animation = '';
                            resourceElement.style.border = '';
                        }, 1500);
                    }
                    showTopMessageTargeted("Please expand the Objective Group first to add objectives", 'warning', 3000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                    return false;
                }
                // Success feedback for valid drag creation
                const resourceElement = document.querySelector(`[data-resource-id="${resourceRecord.id}"]`);
                if (resourceElement) {
                    resourceElement.style.background = 'linear-gradient(135deg, #4CAF50, #45a049)';
                    resourceElement.style.transition = 'all 0.3s ease';
                    setTimeout(() => {
                        resourceElement.style.background = '';
                    }, 1000);
                }
                showTopMessageTargeted("Drag to create a new objective in this timeline", 'info', 2000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                return true;
            },
            beforeDragCreateFinalize:  async function (event) {
                event.context.async = true
                let eventRecord = event.eventRecord;
                let resourceRecord = event.resourceRecord;
                let elementRect = event.eventElement.getBoundingClientRect();

                if(!resourceRecord.expanded){

                    event.context.finalize(false) ;
                    showTopMessageTargeted("Please first expand the Objective Group", 'warning', 4000, roadmapVue.isFullScreen ? '.okrsrdmp' : null)
                    return

                }
                let fieldsMap = kendisStore.getters.getObjectiveTemplate().fieldsMap;
                let startDateFieldId, endDateFieldId,timePeriodFieldId

                // Loop through the fieldsMap to find the IDs for 'Start Date' and 'End Date'
                for (let fieldId in fieldsMap) {
                    if (fieldsMap[fieldId] === 'Start Date') {
                        startDateFieldId = fieldId;
                    } else if (fieldsMap[fieldId] === 'End Date') {
                        endDateFieldId = fieldId;
                    } else if (fieldsMap[fieldId] === 'Time Period'){
                        timePeriodFieldId = fieldId
                    }
                }

                let input = {};
                input.itemIdentifier = "New Item";
                input.startDate = _.clone(event.context.startDate)
                input.endDate = _.clone(event.context.endDate)
                input.showTextField = true;
                input.showDateFields = true;
                input.textValue ="Objective title";
                input.textInputLabel = "Enter Objective title"
                input.showTimePeriod = true
                input.maxLength = 750; // Add character limit for objective creation

                let promise = roadmapVue.openAndHandlePopup(input);
                promise.then(async (response) => {
                    let newObj = {
                        title: response.textValue,

                    }
                    newObj.fields = newObj.fields || {};
                    if (response.startDate) {
                        newObj.fields[startDateFieldId] = response.startDate;
                    }
                    if (response.endDate) {
                        newObj.fields[endDateFieldId] = response.endDate;
                    }
                    if(response.timePeriod){
                        newObj.fields[timePeriodFieldId] = response.timePeriod
                    }


                    let newObjResponse = await roadmapVue.addNewObjective(newObj, resourceRecord.id);

                    // Update objective group cache (objective cache is already updated in addNewObjective)
                    roadmapVue.$options.cache.objectiveGroupsMap.set(newObjResponse.objGroup.id, newObjResponse.objGroup);
                    
                    // Progress calculation is already handled in addNewObjective method

                }).catch((error) => {
                    console.log(error);
                    showTopMessageTargeted("Action cancelled", 'warning', 4000, roadmapVue.isFullScreen ? '.okrsrdmp' : null)
                });

                event.context.finalize(false);

            },
            beforeEventResize(event) {
                // Check EDIT_OBJECTIVE permission for resizing
                if (event.resourceRecord.id === milestoneResourceId) {
                    return true;
                }
                return PermissionManager.checkPermissionWithMessage('EDIT_OBJECTIVE', 'resize objectives');
            },
            beforeEventDrag(event) {
                if (event.resourceRecord.id === milestoneResourceId) {
                    return true;
                }
                // Check EDIT_OBJECTIVE permission for dragging/moving
                return PermissionManager.checkPermissionWithMessage('EDIT_OBJECTIVE', 'move objectives');
            }
        },
        eventStyle: 'border',
        useInitialAnimation : false,
         // Handle scroll button clicks to expand objective groups
         onScrollButtonClick: function(event) {



            // Find the scroll button element for visual feedback
            // const scrollButton = document.querySelector(`.b-scrollbutton[data-resource-id="${resourceRecord.id}"]`);

            // // Add loading state to scroll button
            // if (scrollButton) {
            //     scrollButton.classList.add('loading');
            // }



            // // Use the component method for better organization and error handling
            // roadmapVue.handleScrollButtonExpansion(resourceRecord, isBefore, nbrEvents)
            //     .then(() => {
            //         // Remove loading state on success
            //         if (scrollButton) {
            //             scrollButton.classList.remove('loading');
            //         }
            //     })
            //     .catch((error) => {
            //         // Remove loading state on error
            //         if (scrollButton) {
            //             scrollButton.classList.remove('loading');
            //         }
            //         console.error('Scroll button expansion failed:', error);
            //     });
        },
        features: {
            pdfExport: {
                exportServer: `${window.location.origin}/proxy/pdf-export/roadmaps`, // Required
                translateURLsToAbsolute : window.location.origin,  // Use current base URL dynamically                alignRows: true,
                paperFormat: 'A0',
                rowsRange: 'all',
                scheduleRange: 'currentview',
                orientation: 'portrait',
                fetchOptions: {
                    credentials: 'include',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="_csrf"]').getAttribute('content'),
                        'X-Requested-With': 'XMLHttpRequest',
                        'Content-Type': 'application/json;charset=UTF-8',
                    }
                },
                showErrorToast:false,
                sendAsBinary : true,
            },

            tree: roadmapComponent.isMultilevel, // Enable tree mode only in multilevel view

            percentBar   : {
                allowResize    : false,
                showPercentage : true // showing a tooltip instead
            },
            scrollButtons : {
                labelRenderer({ resourceRecord, isBefore, nbrEvents }) {
                    if(resourceRecord.id === "-1001"){
                        return `${nbrEvents} ${nbrEvents > 1 ? 'Milestones' : 'Milestone'}`;
                    }
                    return `${nbrEvents} ${nbrEvents > 1 ? 'Objectives' : 'Objective'}`;
                },

            },
            eventMenu: {
                items: {
                    // Custom item with inline handler
                    editEvent: false, // Disable edit option
                    deleteEvent: false, // Disable delete option
                    addEvent: false, // Disable add event option
                    cutEvent: false, // Disable cut option
                    copyEvent: false, // Disable cut option
                    splitEvent: false, // Disable cut option
                    unassignEvent:false,
                    // showOkrs:{
                    //     text: 'Show KRs',
                    //     icon: 'b-fa b-fa-fw b-fa-eye',
                    //     weight: 200,
                    //     onItem: ({eventRecord}) => {
                    //         roadmapVue.showKRsObjectives(eventRecord.id);
                    //     }
                    // },
                    // hideOkrs:{
                    //     text: 'Hide KRs',
                    //     icon: 'b-fa b-fa-fw b-fa-eye-slash',
                    //     weight: 200,
                    //     onItem: ({eventRecord}) => {
                    //         roadmapVue.hideKRsObjectives(eventRecord.id);
                    //     }
                    // },
                    }
                },
            cellMenu : {
                processItems: ({items, record}) => {
                    if(roadmapComponent.isMultilevel){
                        delete items.editObjGroup;
                        delete items.groupProgress;
                        delete items.removeRow;
                        delete items.addObjective;
                        return items;

                    }
                    // Hide all menu options for milestone resource
                    if (record.id === milestoneResourceId) {
                        // Clear all items to show no menu options
                        Object.keys(items).forEach(key => delete items[key]);
                        return items;
                    }

                    // Check if this is a linked custom view objective group
                    let cachedData = roadmapVue.$options.cache.objectiveGroupsMap.get(record.id);
                    let isLinkedCustomView = !roadmapVue.isGlobalObj && 
                                           cachedData && 
                                           cachedData.linkedCustomView && 
                                           roadmapVue.linkedCustomViewsMap.has(cachedData.linkedCustomView);
                    
                    // Check if this is a collection objective group
                    let collection = roadmapVue.getCollection(record.id);
                    let isCollection = roadmapVue.isGlobalObj && collection && collection.type;
                    
                    // Hide editObjGroup and removeRow for linked custom views or collections
                    if (isLinkedCustomView || isCollection) {
                        delete items.editObjGroup;
                        // delete items.removeRow;
                    }

                    if (!PermissionManager.hasPermission('DELETE_OBJECTIVE_GROUP')) {
                        // Remove delete-related options
                        delete items.removeRow;
                    }

                    if (!PermissionManager.hasPermission('EDIT_OBJECTIVE_GROUP')) {
                        // Remove delete-related options
                        delete items.editObjGroup;
                    }
                    return items;

                },
                items : {
                    editObjGroup: {
                        text: 'Edit Objective Group',
                        icon: 'b-fa b-fa-fw b-fa-edit',
                        weight: 1,
                        cls: 'enhanced-menu-item edit-item',
                        onItem: ({record}) => {
                            let cachedObjGroup = roadmapVue.$options.cache.objectiveGroupsMap.get(record.id);
                            showTopMessageTargeted("Opening edit dialog...", 'info', 1500, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                            roadmapVue.openObjectiveGroupEditPopup(cachedObjGroup);
                        }
                    },
                    groupProgress:{
                        text: 'Group Progress',
                        icon: 'b-fa b-fa-fw b-fa-chart-line',
                        weight: 2,
                        cls: 'enhanced-menu-item progress-item',
                        onItem: ({record}) => {
                            showTopMessageTargeted("Loading progress analytics...", 'info', 1500, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                            roadmapVue.initGroupProgressPopup(record.id);
                        }
                    },
                    // addObjective: {
                    //     text: 'Add New Objective',
                    //     icon: 'b-fa b-fa-fw b-fa-plus',
                    //     weight: 2.5,
                    //     cls: 'enhanced-menu-item add-item',
                    //     onItem: ({record}) => {
                    //         if (!record.expanded) {
                    //             showTopMessage("📂 Expanding group to add objective...", 'info', 1500);
                    //             toggleResourceExpandByAssignments(record, 'X', scheduler);
                    //             if (record.expanded) {
                    //                 roadmapVue.loadObjectivesOfGroups(record.id);
                    //             }
                    //         }
                    //         showTopMessage("✨ Click and drag on the timeline to create an objective", 'info', 3000);
                    //     }
                    // },
                    removeRow:{
                        text: 'Delete Objective Group',
                        icon: 'b-fa b-fa-fw b-fa-trash',
                        weight: 3,
                        cls: 'enhanced-menu-item delete-item',
                        onItem: ({record}) => {
                            let cachedObjGroup = roadmapVue.$options.cache.objectiveGroupsMap.get(record.id);
                            
                            // Enhanced validation with better messages
                            if(!roadmapVue.isGlobalObj && cachedObjGroup && cachedObjGroup.linkedCustomView){
                                showTopMessageTargeted("Cannot delete Custom View referenced groups", 'warning', 3000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                                return;
                            }

                            if(roadmapVue.isGlobalObj && roadmapVue.getCollection(record.id) && roadmapVue.getCollection(record.id).type){
                                showTopMessageTargeted("Cannot delete collection groups", 'warning', 3000, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                                return;
                            }
                            
                            showTopMessageTargeted("Preparing deletion confirmation...", 'warning', 1500, roadmapVue.isFullScreen ? '.okrsrdmp' : null);
                            roadmapVue.onDeleteObjGrpPopup(cachedObjGroup.id);
                        }
                    }
                }
            },
            scheduleTooltip : false,
            // cellTooltip : {
            //     tooltipRenderer : ({ record, column }) => record[column.field],
            //     hoverDelay      : 2000,
            // },
            eventTooltip: {
                hoverDelay: 500,
                // Allow tooltip to position itself optimally to avoid clipping
                constrainTo: window,
                // Enable smart positioning to avoid viewport edges
                autoShow: true,
                // Set minimum dimensions for consistent spacing
                allowOver : true,
                minWidth: 350,
                // Allow tooltip to flip position when near edges
                align: {
                    align: 'b-t', // Default: bottom-top
                    axisLock: false, // Allow repositioning on both axes
                    constrainTo: window,
                    // Fallback positions when default doesn't fit
                    fallbackPlacements: ['t-b', 'l-r', 'r-l', 'b-t']
                },
                // Ensure tooltip stays within viewport bounds
                scrollAction: 'realign',
                template: (data) => {
                    // Handle header events
                    if (data.eventRecord.get('isHeader')) {
                        return renderHeaderTooltip(data);
                    }
                    // Handle milestone events
                    if (data.eventRecord.resource.id === milestoneResourceId) {
                        return renderMilestoneTooltip(data);
                    }
                    // Handle objective events with new design
                    if(data.eventRecord.get('type')==="keyResult"){
                        // Use event ID directly since we're no longer using prefixed event IDs
                        let keyResult = roadmapVue.$options.cache.keyResultsMap.get(data.eventRecord.id);
                        return renderObjectiveTooltip(keyResult, data);
                    }
                    // Use event ID directly since we're no longer using prefixed event IDs
                    let objective = roadmapVue.$options.cache.objectivesMap.get(data.eventRecord.id);
                    if (!objective) {
                        return `<div class="enhanced-tooltip-error" style="
                            background: #fff;
                            color: #dc3545;
                            padding: 12px;
                            border-radius: 8px;
                            font-size: 13px;
                            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
                            border: 1px solid #dc3545;
                        ">⚠️ Objective data not available</div>`;
                    }
                    return renderObjectiveTooltip(objective, data);
                }
            },


            scheduleMenu: false, // Turn off schedule menu
            eventMenu: {
                processItems({ eventRecord, resourceRecord, items }) {
                    if(roadmapComponent.isMultilevel){
                        
                        return false;
                    }
                    // Don't show context menu for header events, milestones, or phases
                    if (!eventRecord || 
                        eventRecord.originalData.isHeader || 
                        eventRecord.resource.id === 'milestone-resource' ||
                        eventRecord.get('type') === 'Milestone' ||
                        eventRecord.get('type') === 'Phase') {
                        // Clear all items to show no menu options
                        Object.keys(items).forEach(key => delete items[key]);
                        return items;
                    }


                    // Clear default items and add custom menu items for objectives
                    Object.keys(items).forEach(key => delete items[key]);

                    // Add custom menu items
                    items.editObjective = {
                        text: 'Edit Objective',
                        icon: 'b-fa b-fa-edit',
                        cls: 'enhanced-menu-item edit-item',
                        weight: 100,
                        // Use event ID directly since we're no longer using prefixed event IDs
                        onItem: () => roadmapVue.openObjectiveEditPopup(roadmapVue.$options.cache.objectivesMap.get(eventRecord.id))
                    };
                    
                    items.deleteObjective = {
                        text: 'Delete Objective',
                        icon: 'b-fa b-fa-trash',
                        cls: 'enhanced-menu-item delete-item',
                        weight: 500,
                        onItem: () => {
                            // Use event ID directly since we're no longer using prefixed event IDs
                            const objective = roadmapVue.$options.cache.objectivesMap.get(eventRecord.id);
                            if (objective) {
                                roadmapVue.confirmDeleteObjective(objective);
                    }
                        }
                    };
                    // Check DELETE_OBJECTIVE permission for objective events
                    if (!PermissionManager.hasPermission('DELETE_OBJECTIVE')) {
                        delete items.deleteObjective;
                    }

                    // Check EDIT_OBJECTIVE permission for objective events
                    if (!PermissionManager.hasPermission('EDIT_OBJECTIVE')) {
                        delete items.editObjective;
                    }
                        return items;
                }
            },
            columnLines: false,
            // rowReorder : {
            //     showGrip : can i filter out css files that are used by VUejs2 component true,
            //     gripOnly : false,
            // },
            stripe: true,
            columnAutoWidth: true,
            dependencies : false,
            timeRanges: {
                showHeaderElements: true, // Set to true if you want markers in the header as well
                showCurrentTimeLine: {name:getFormattedDate(new Date())}, // Optional, depending on whether you want the current time line
            },
            eventResize: {
                tooltipTemplate({ eventRecord, startDate, endDate }) {
                    const format = (date) => (date ? ROADMAP_MODULE.DateHelper.format(date, 'DD MMM YYYY') : '-');

                  
                    // Use DateHelper to format dates (date only)
                    return  `<div style="font-family:inherit;">
                        <span style="display:inline-block;margin-top:6px;">
                            <span style="margin: 4px 4px 0 0;display:inline-block;background:#e3f2fd;color:#1976d2;border-radius:12px;padding:3px 12px;font-size:12px;font-weight:500;margin-right:6px;vertical-align:middle;">
                                Start Date: ${format(startDate)}
                            </span>
                            <span style="margin: 4px 4px 0 0;display:inline-block;background:#fce4ec;color:#c2185b;border-radius:12px;padding:3px 12px;font-size:12px;font-weight:500;vertical-align:middle;">
                                End Date: ${format(endDate)}
                            </span>
                        </span>
                    </div>`;

                }
                        },
            eventDrag: {
                tooltipTemplate({ eventRecord, startDate, endDate }) {
                    const format = (date) => (date ? ROADMAP_MODULE.DateHelper.format(date, 'DD MMM YYYY') : '-');

                    if ( eventRecord.get('type') === 'Milestone' ) {
                        return  `<div style="font-family:inherit;">
                        <span style="display:inline-block;margin-top:6px;">
                            <span style="display:inline-block;background:#e3f2fd;color:#1976d2;border-radius:12px;padding:3px 12px;font-size:12px;font-weight:500;margin-right:6px;vertical-align:middle;">
                                Milestone Date: ${format(startDate)}
                            </span>
                        </span>
                    </div>`;

                    }
                    // Use DateHelper to format dates (date only)
                    return  `<div style="font-family:inherit;">
                        <span style="display:inline-block;margin-top:6px;">
                            <span style="margin: 4px 4px 0 0;display:inline-block;background:#e3f2fd;color:#1976d2;border-radius:12px;padding:3px 12px;font-size:12px;font-weight:500;margin-right:6px;vertical-align:middle;">
                                Start Date: ${format(startDate)}
                            </span>
                            <span style="margin: 4px 4px 0 0;display:inline-block;background:#fce4ec;color:#c2185b;border-radius:12px;padding:3px 12px;font-size:12px;font-weight:500;vertical-align:middle;">
                                End Date: ${format(endDate)}
                            </span>
                        </span>
                    </div>`;

                }
            },
        },
        // timeRanges: _this.getTimeRanges(),
        timeAxis: {
            mainUnit: 'day',
            autoAdjust: false,
            // Enable continuous scrolling without bounds
            continuous: true
        },
        viewPreset: {
            base              : 'dayAndWeek',
            tickWidth         : 40,
            displayDateFormat : 'LL',
            timeResolution: {
                increment : 1,
                unit      : 'd'
            },
            headers: [
                {
                    unit       : 'w',
                    align      : 'start',
                    dateFormat : 'LL'
                },
                {
                    unit       : 'd',
                    align      : 'center',
                    dateFormat : 'DD'
                }
            ]
        },
        zoomOnMouseWheel: false,
        rowHeight: 80,
        barMargin: 20,
        project: project,
        insertFirst: "okrs-roadmap-bryntum",
        
        // Custom overlapping event sorter to ensure proper hierarchy display
        overlappingEventSorter(a, b) {
            const isHeaderA = a.get('isHeader');
            const isHeaderB = b.get('isHeader');
            const typeA = a.get('type');
            const typeB = b.get('type');
            
            // Headers always go on top
            if (isHeaderA && !isHeaderB) {
                return -1; // A (header) goes above B
            }
            if (!isHeaderA && isHeaderB) {
                return 1; // B (header) goes above A
            }
            
            // If both are headers or both are not headers, sort by type priority
            const getTypePriority = (type, isHeader) => {
                if (isHeader) {
                    return 0; // Headers have highest priority
                }
                switch (type) {
                    case 'objective': return 1; // Parent objectives
                    case 'child-objective': return 2; // Child objectives
                    case 'keyResult': return 3; // Key results
                    case 'Milestone': return 4; // Milestones
                    case 'Phase': return 4; // Phases
                    default: return 5; // Other types at the bottom
                }
            };
            
            const priorityA = getTypePriority(typeA, isHeaderA);
            const priorityB = getTypePriority(typeB, isHeaderB);
            
            // If different priorities, sort by priority (lower number = higher priority = on top)
            if (priorityA !== priorityB) {
                return priorityA - priorityB;
            }
            
            // If same type/priority, sort by dates (default behavior)
            const startA = a.startDate;
            const startB = b.startDate;
            const endA = a.endDate;
            const endB = b.endDate;
            
            const sameStart = (startA - startB === 0);
            
            if (sameStart) {
                // If start dates are the same, earlier end date goes first
                return endA > endB ? -1 : 1;
            } else {
                // Earlier start date goes first
                return (startA < startB) ? -1 : 1;
            }
        },
        
        // Minimized splitter configuration
        splitterWidth: 2,
        subGridConfigs: {
            locked: {
                splitterCls: 'minimal-splitter'
            }
        },
        

    }
}

/**
 * Renders the tooltip for an objective event in the roadmap.
 * @param {Object} objective - The objective object from cache
 * @param {Object} data - The eventTooltip data object
 * @returns {string} HTML string for the tooltip
 */
function renderObjectiveTooltip(objective, data) {
    // Utility: Format date as 'Jan 1, 2025'
    function formatDate(date) {
        if (!date) return 'Not set';
        return new Date(date).toLocaleDateString('en-US', {
            year: 'numeric',
            month: 'short',
            day: 'numeric'
        });
    }
    // Utility: Render association items as colored tags with limit
    function renderAssociationItems(items, type) {
        if (!Array.isArray(items) || items.length === 0) return '<span style="color: #999; font-style: italic;">None</span>';
        
        const colors = {
            collections: '#e74c3c',
            sessions: '#3498db',
            batches: '#f39c12'
        };
        
        const maxVisible = 3;
        const visibleItems = items.slice(0, maxVisible);
        const remainingItems = items.slice(maxVisible);
        
        let html = visibleItems.map(item => {
            const colorStyle = item.color || item.prefixColor || item.headerColor || colors[type] || '#6c757d';
            return `
                <span class="clctg" style="background-color: ${colorStyle};" title="${item.title || ''}">
                    ${item.shortName || item.key || item.prefix || item.title || 'Unknown'}
                </span>
            `;
        }).join('');
        
        // Add "+X more" indicator if there are remaining items
        if (remainingItems.length > 0) {
            const remainingList = remainingItems.map(item => 
                `• ${item.title || item.shortName || item.key || item.prefix || 'Unknown'}`
            ).join('\n');
            
            // Use a unique ID for each tooltip to prevent conflicts
            const tooltipId = `association-tooltip-${type}-${Date.now()}-${Math.random().toString(36).substr(2, 9)}`;
            
            html += `
                <span class="clctg-more" 
                      style="background-color: #6c757d; color: white; cursor: pointer; position: relative;" 
                      data-tooltip-id="${tooltipId}"
                      data-items='${JSON.stringify(remainingItems)}'
                      data-type="${type}"
                      onmouseenter="showAssociationTooltipDelayed(event, '${type}', ${JSON.stringify(remainingItems).replace(/\"/g, '&quot;')}, '${tooltipId}')"
                      onmouseleave="hideAssociationTooltipDelayed('${tooltipId}')">
                    +${remainingItems.length} more
                </span>
            `;
        }
        
        return html;
    }
    const percentageDone = data.eventRecord.percentDone || 0;
    const status = objective.status?.title || "Unknown";
    const statusColor = getStatusColor(objective.status?.category || 'ToDo');
    const objectiveKey = objective.key || data.eventRecord.originalData.kendisKey || '';
    const objectiveTitle = data.eventRecord.name;
    let responsibleName = 'Not assigned';
    let responsible = {}
    let avatar = '';
    if(objective.fields) {
        // Use correct type for responsible field lookup
        let responsibleFieldType = (objective.type === 'KR' || objective.type === 'keyResult') ? 'KeyResult' : 'Objective';
        responsible = objective.fields[roadmapVue.getResponsibleFieldIdFromBaseItem(responsibleFieldType)];
        responsibleName = responsible?.fullName || 'Not assigned';
        avatar = responsible ? getUserIcon(objective.fields[roadmapVue.getResponsibleFieldIdFromBaseItem(responsibleFieldType)]) : '';
    }
    const timeOutput = (data.eventRecord.startDate && data.eventRecord.endDate)
        ? `${formatDate(data.eventRecord.startDate)} - ${formatDate(data.eventRecord.endDate)}`
        : 'Date range not available';

    // Get time period information
    let timePeriodDisplay = '';
    //if key result then use timePeriodKRFieldId else use timePeriodFieldId
    let timePeriodFieldId = objective.type === 'KR' || objective.type === 'keyResult' ? roadmapVue.timePeriodKRFieldId : roadmapVue.timePeriodFieldId;

    if (objective.fields && timePeriodFieldId && objective.fields[timePeriodFieldId]) {
        const timePeriod = objective.fields[timePeriodFieldId];
        const periodTitle = timePeriod.title === 'Yearly' ? 'Year' : timePeriod.title;
        timePeriodDisplay = `${periodTitle} ${timePeriod.selectedYear}`;
    }

    const associations = data.eventRecord.originalData.associations || {};
    return `
        <div class="kendis-objective-tooltip">
            <!-- Objective Key and Title -->
            <div class="tpname mb-10">
                ${objectiveKey ? `
                    <div class="key">${objectiveKey}</div>
                ` : ''}
                	<div class="ttl">${objectiveTitle}</div>
            </div>
            <!-- Progress Section -->
            <div class="tpprgout">
            	<div class="DFCB mb-10">
                	<label class="lblm mb-0">Progress:</label>
                	<div class="prcbx">${percentageDone}%</div>
            	</div>
            	<div class="prgbar"><div class="bar" style="background: ${percentageDone >= 75 ? '#4CAF50' : percentageDone >= 50 ? '#FF9800' : percentageDone >= 25 ? '#2196F3' : '#F44336'}; width: ${percentageDone}%"></div></div>
            </div>
            
            ${timePeriodDisplay ? `
            <!-- Time Period Section -->
            <div class="tpscnd ful mb-5">
                <div class="lft">
                    <div class="nm">Time Period</div>
                    <div class="mr-5 slc-year-border button-w c-point tooltip">
                        <div>${timePeriodDisplay}</div>
                        <div class="hovtooltipB sml">${timeOutput}</div>
                    </div>
                </div>
            </div>
            ` : ''}
            
            <!-- Details Section (including associations) -->
            <div class="tpscnd hlf mb-5">
            	<!-- Timeline -->
            	<div class="lft">
    				<div class="nm">Dates</div>
                    <div class="txt">${timeOutput}</div>                        				
                </div>
                <!-- Collections -->
                ${associations.collections?.length ? `
                    <div class="rht">
                        <div class="nm">Collections</div>
                        <div class="clctn">${renderAssociationItems(associations.collections, 'collections')}</div>
                    </div>
                ` : ''}
            </div>
            <!-- Responsible -->
            <div class="tpscnd ful mb-5">
            	<div class="lft">
	            	<div class="nm">Responsible</div>
	                <div class="users pic DFA gap-1">${avatar} ${responsibleName}</div> 
                </div>
            </div>
            
            <div class="tpscnd hlf">
            	<!-- Status -->
            	<div class="lft">
	            	<div class="nm">Status</div>
	                <div class="sts" style="background: ${statusColor};">${status}</div>
                </div> 
                ${associations.batches?.length ? `
                <!-- Batches -->
                <div class="rht">
	            	<div class="nm">Batches</div>
	                <div class="txt btch">${renderAssociationItems(associations.batches, 'batches')}</div>
                </div> 
                ` : ''}
            </div>  
            <div class="tpscnd ful">
            	 <!-- Program Boards -->
                ${associations.sessions?.length ? `
                <div class="rht">
                    <div class="nm">Program Boards</div>
                    <div class="txt pbrd">${renderAssociationItems(associations.sessions, 'sessions')}</div>
                </div>
            	` : ''}
            </div>          
        </div>
    `;
}

/**
 * Renders the tooltip for a header event (objective group header) in the roadmap.
 * @param {Object} data - The eventTooltip data object
 * @returns {string} HTML string for the header tooltip
 */
function renderHeaderTooltip(data) {
    let cachedObjGrp = roadmapVue.$options.cache.objectiveGroupsMap.get(data.eventRecord.id.split('-')[3]);
    // Use centralized count management utility
    const countData = roadmapVue.getObjectiveGroupCount(data.eventRecord.resource.id);
    let count = countData.count;
                        // Use the objective group's color for header tooltip
                        const groupColor = cachedObjGrp?.color || data.eventRecord.eventColor || '#667eea';
                        const lightGroupColor = lightenHexColor(groupColor, 0, 0.15);
                        return `
                            <div class="kendis-group-header enhanced-tooltip">
                                <div class="DF mb-20">
                                    <span class="okttlic mr-10"></span>
                                    <span class="tpname">${data.eventRecord.name}</span>
                                </div>                               
                                <div class="tpprgout">
                                	<div class="DFCB mb-10">
	                                	<label class="lblm mb-0">Progress:</label>
	                                	<div class="prcbx">${data.eventRecord.percentDoneGroup}%</div>
                                	</div>
                                	<div class="prgbar"><div class="bar" style="width: ${data.eventRecord.percentDoneGroup}%"></div></div>
                                </div>
                                <div class="tpscnd">
			                        ${count > 0 ? `
                        			<div class="lft">
                        				<div class="nm mb-5">Objectives</div>
                                        <div class="cnt">${count}</div>                        				
                                    </div>                                 
                                ` : `                                   
                                `}
                                ${cachedObjGrp ? `
                                    <div class="rht">                                        
                                    	<div class="nm mb-5">Status</div>                                            
                                    	<span class="sts" style="background-color: ${getStatusColor(cachedObjGrp.status.category)};">${cachedObjGrp.status.title}</span>
                                    </div>
                                ` : ''}
                                </div>
                            </div>
                        `;
                    }
                    
/**
 * Renders the tooltip for a milestone event in the roadmap.
 * @param {Object} data - The eventTooltip data object
 * @returns {string} HTML string for the milestone tooltip
 */
function renderMilestoneTooltip(data) {
    let milestone = roadmapVue.milestoneMapById[data.eventRecord.id];
    if (!milestone) {
        return `<div class="enhanced-tooltip-error" style="
            background: linear-gradient(135deg, #ff7675, #d63031);
            color: white;
            padding: 12px;
            border-radius: 8px;
            font-size: 13px;
        ">⚠️ Milestone data not available</div>`;
    }
    function formatDate(date) {
        if (!date) return 'Not set';
        return new Date(date).toLocaleDateString('en-US', {
            year: 'numeric',
            month: 'short',
            day: 'numeric'
        });
    }
    const milestoneKey = milestone.key || data.eventRecord.originalData.kendisKey || '';
    const milestoneTitle = milestone.title || data.eventRecord.name || 'Untitled Milestone';
    const startDate = formatDate(milestone.fields.StartDate || data.eventRecord.startDate);
    const endDate = formatDate(milestone.fields.EndDate || data.eventRecord.endDate);
    const description = milestone.description || '';
    const status = milestone.status?.title || 'Unknown';
    const statusColor = milestone.status ? getStatusColor(milestone.status.category) : '#5B6D86';
    return `
        <div class="kendis-objective-tooltip kendis-milestone-tooltip">
            <!-- Milestone Key and Title -->
            <div class="tpname mb-10">
                ${milestoneKey ? `<div class="key">${milestoneKey}</div>` : ''}
                <div class="ttl">${milestoneTitle}</div>
            </div>
            <!-- Timeline Section -->
            <div class="tpscnd hlf mb-5">
                <div class="lft">
                    <div class="nm mb-5">Dates</div>
                    <div class="txt">${startDate} - ${endDate}</div>
                </div>
            </div>
            <!-- Status Section -->
            <div class="tpscnd hlf">
                <div class="lft">
                    <div class="nm mb-5">Status</div>
                    <div class="sts" style="background: ${statusColor};">${status}</div>
                </div>
            </div>
            <!-- Description Section -->
            ${description ? `
            <div class="tpscnd ful mt-10">
                <div class="lft">
                    <div class="nm mb-5">Description</div>
                    <div class="txt">${description}</div>
                </div>
            </div>
            ` : ''}
        </div>
    `;
}

// Permission utility for OKRs roadmap
const PermissionManager = {
    /**
     * Check if user has a specific permission
     * @param {string} permission - The permission to check
     * @returns {boolean} - True if user has permission
     */
    hasPermission(permission) {
        return roadmapVue?.$options?.permissions?.[permission] || false;
    },

    /**
     * Show permission denied message
     * @param {string} action - Description of the action being blocked
     */
    showPermissionDenied(action = 'perform this action') {
        showTopMessageTargeted(
            `You don't have permission to ${action}`, 
            'warning', 
            3000, 
            roadmapVue?.isFullScreen ? '.okrsrdmp' : null
        );
    },

    /**
     * Check permission and show message if denied
     * @param {string} permission - The permission to check
     * @param {string} action - Description of the action
     * @returns {boolean} - True if permission granted
     */
    checkPermissionWithMessage(permission, action) {
        if (!this.hasPermission(permission)) {
            this.showPermissionDenied(action);
            return false;
        }
        return true;
    }
};