Vue.use(Pinia.PiniaVuePlugin);
Vue.use(Pinia.createPinia());
const vzTreeStore = Pinia.defineStore('vzTreeStore', {
	state() {
		return {
			selectedItemId: "-1"
        }
	},
	getters: {
		getSelectedItemId: function () {
			return this.selectedItemId;
		}
	},
	actions: {
		setSelectedItemId: function (selectedItemId) {
			this.selectedItemId = selectedItemId;
		}
	},
});

const treeSelectRow = Vue.component('vz-tree-select-row', {
		store: vzTreeStore,
		template : `
		<div class="">
        	<div class="rec brd" :class="{'active':expand,'act-tick':($store.selectedItemId == item[trackBy])}">
        		<em v-if="item.children && item.children.length > 0" @click="onClickExpandSubItems" class="ti-angle-right arrd mr-10 c-point"></em> 
        		<div @click="onClickSelectItem" class="prow c-point label">{{item[label]}} <em class=" ml-10" :class="{'tick-grn':($store.selectedItemId == item[trackBy])}"></em></div>
        	</div>			
            <div v-if="expand" class="insd">
           		<vz-tree-select-row v-for="subItem in item.children" :item="subItem" 
           			:label="label"
					:track-by="trackBy"
           			@select="onSelectSubItem">
           		</vz-tree-select-row>
            </div>			
		</div>
		`,
		props:  ["item","label","trackBy"],
		
		computed: {
			
		},
		
		data() {
			return {
				expand: true,	
			}
		},
		watch: {
		},
		
		created () {
			
		},

		mounted: function () {
			
		},
		methods: {
			//////////////////////////////////////////////////
			///////////////    LOGIC
			onClickSelectItem: function (event) {
				event.stopPropagation();
				this.$emit("select",this.item);
			},
			onClickExpandSubItems: function (event) {
				event.stopPropagation();
				this.expand = !this.expand;
			},
			onSelectSubItem: function (item) {
				this.$emit("select",item);
			}
		}
	});
const vzTreeSelect = Vue.component('vz-tree-select', {
		store: vzTreeStore,
		template : `
		<div class="p-rel usrpkr">
			<div class="slctdn DFA c-point" @click="onClickDropdown">
				<template v-if="selectedValue">{{selectedValue[label]}}</template>
				<template v-else>Select</template>
			</div>
            <vuepopup v-if="showDropdown" @close="onClickOutside">
	            <div class="drop_box iteration-tree" style="display:block;">
	            	<div class="dialgtl">{{title}} <em class="rmv-ico ti-close" @click="onClickCloseButton" style="color:#000"></em></div>
	            	<div class="cntr table brd rnd4">
						<vz-tree-select-row v-for="item in options" :key="item[trackBy]" 
							:item="item" @select="onSelectItem" 
							:label="label"
							:track-by="trackBy"
							/>
					</div>
				</div>
			</vuepopup>
		</div>
		`,
		
		props:  {
			id: {
				type: String,
			    default: () => { return undefined }
			},
			title: {
				type: String,
			default: () => { return 'Select' }
			},
			options: {
				type: Array,
			    required: true
			},
			label: {
				type: String,
			default: () => { return 'title' }
			},
			trackBy: {
				type: String,
			default: () => { return 'id' }
			},
			value: {
				type: null,
		        default () {
		          return []
		        }
			},
			valueType: {
				type: String,
			    default: () => { return 'object' }
			},
			change: {
			    type: Function,
			    default: () => { }
			},
		},
		
		computed: {
			/*buttonTitle: function () {
				
			},*/
		},
		
		data() {
			return {
				searchQuery: '',
				showDropdown: false,
				selectedValue: undefined
			}
		},
		watch: {
			'options':  {
				handler (val, oldVal) {
					/*var self = this;
					this.data = val;
					Vue.nextTick(function(){
						$(self.$el).multiselect('refresh');
						self.setSelectedValues(self.value);
					});*/
		        },
		        deep: true,
	            immediate: true
			},
			'value': {
				handler (val, oldVal) {
					this.setSelectedValues(val);
		        },
		        deep: true,
		        immediate: true
			},
		},
		model: {
			event: `select`
		},
		created () {
			
		},

		mounted: function () {
			
		},
		methods: {

			//////////////////////////////////////////////////
			///////////////    LOGIC
			setSelectedValues: function (val) {
				
				let selecteValueId;
				let _this = this;
				
				if (this.valueType == "object") {
					selecteValueId = val[this.trackBy];
				}
				else {
					selecteValueId = val;
				}
				
				let selectedValue = findRecursive(this.options);
				if (selectedValue) {
					this.selectedValue = selectedValue;
					this.$store.setSelectedItemId(selectedValue[this.trackBy]);
				}
				
				function findRecursive(objs) {
					
					for (let i=0; i < objs.length ; i ++) {
						let obj = objs[i];
						if (obj[_this.trackBy] == selecteValueId) {
							return obj;
						}
						if (obj.children) {
							return findRecursive(obj.children);
						}
					}
					return null;
				}
			},
			//////////////////////////////////////////////////
			///////////////    EVENTS
			onClickOutside: function () {
				this.showDropdown = false;
			},
			onClickCloseButton: function () {
				this.showDropdown = false;
			},
			onSelectItem: function (item) {
				if (this.valueType == "object") {
					this.$emit("select",item);
				}
				else {
					this.$emit("select",item[this.trackBy]);
				}
				this.$store.setSelectedItemId(item[this.trackBy]);
				this.showDropdown = false;
			},
			onChangeSearchQuery: function () {
				
			},
			onTextFocusIn: function () {
				this.showDropdown = true;
			},
			onTextFocusOut: function () {
				this.showDropdown = false;
			},
			onClickDropdown: function () {
				this.showDropdown = !this.showDropdown;
			},
			onSearchItemsKeyUp: function () {
				
			}
			
		}
	});






