var vsselect = null;
$(document).ready(function () {

const MULTI_SELECT = Vue.component('vz-select',{
	template : `
		<select :id="id" ref="multi" multiple="multiple" :title="tooltipText" :class="normalClass">
		
		     <template v-if="groupsEnabled">
		     	<template v-for="group in data">
		     		<template v-if="group.hide">
		     			<option v-for="option in group[groupValues]" :data-work-space-type-icon="getWorkSpaceTyepIcon(option)" :data-option-key="itemKey(option)" :data-tfs-icon="getTfsItemIcon(option)" :data-icon="getItemIcon(option)" :data-is-deleted="getDeletedOpt(option)" :title="getCleanedTitleString(option[optionTitle])" :value="option[trackBy]" :disabled="option.disabled" :selected="option.disabled" :label="option[label]" v-html="option[label]"></option>
		     		</template>
		     		<template v-else>
		     			<optgroup :label="group[groupLabel]" :id="group[groupLabel]">
				        	<option v-for="option in group[groupValues]" :data-work-space-type-icon="getWorkSpaceTyepIcon(option)" :data-option-key="itemKey(option)" :data-tfs-icon="getTfsItemIcon(option)" :data-icon="getItemIcon(option)" :data-is-deleted="getDeletedOpt(option)" :title="getCleanedTitleString(option[optionTitle])" :value="option[trackBy]" :disabled="option.disabled" :selected="option.disabled" :label="option[label]" v-html="option[label]"></option>
				        </optgroup>
		     		</template>
		     	</template>
		        
		     </template>
		 		
		     <template v-else>
		     	<option v-for="option in data" :data-work-space-type-icon="getWorkSpaceTyepIcon(option)" :data-option-key="itemKey(option)" :data-tfs-icon="getTfsItemIcon(option)" :data-icon="getItemIcon(option)" :data-is-deleted="getDeletedOpt(option)" :title="getCleanedTitleString(option[optionTitle])" :value="option[trackBy]" :disabled="option.disabled" v-html="option[label]"></option>
		     </template>
			 
			<template v-if="showBottomButton">
				<option class="bottom-button" value="select-button" >{{bottomButtonText}}</option>
			</template>
		</select>
		`,
		props:  {

			id: {
				type: String,
			    default: () => { return undefined }
			},
			options: {
				type: Array,
			    required: true
			},
			label: {
				type: String,
			default: () => { return 'title' }
			},
			trackBy: {
				type: String,
			default: () => { return 'id' }
			},
			multiple: {
				type: Boolean,
			default: () => { return false }
			},
			value: {
				type: null,
		        default () {
		          return []
		        }
			},
			valueType: {
				type: String,
			    default: () => { return 'object' }
			},
			groupBy: {
				type: String,
			    default: () => { return 'value' }
			},
			groupValues: {
				type: String,
			    default: () => { return 'items' }
			},
			groupLabel: {
				type: String,
			    default: () => { return 'title' }
			},
			groupsEnabled: {
				type: Boolean,
			    default: () => { return false }
			},
			normalClass: {
				type: String,
			    default: () => { return '' }
			},
			appendTo: {
				type: String,
		    default: () => { return '' }
			},
			position: {
				type: Object,
		    default: () => { return {} }
			},
			emptySelectionText: {
				type: String,
		    default: () => { return 'Select' }
			},
			selectedTitle: {
				type: String,
		    default: () => { return '' }
			},
			selectedTitleClass: {
				type: String,
		    default: () => { return '' }
			},
			hideDoneButton: {
				type: Boolean,
		    default: () => { return false }
			},
			showSelectAll:{
				type: Boolean,
		    default: () => { return false }
			},
			showSelectAllOnGroup:{
				type: Boolean,
		    default: () => { return false }
			},
			showBottomButton:{
				type: Boolean,
		    default: () => { return false }
			},
			bottomButtonText :{
				type: String,
		    default: () => { return '' }
			},
			tooltipText :{
				type: String,
		    default: () => { return '' }
			},
			optionTitle : {
				type : String,
			default: () => { return '' }
			},
			showTfsJiraIcons: {
				type: Boolean,
			    default: () => { return false }
			},
			showItemKey: {
				type: Boolean,
			    default: () => { return false }
			},
			showIcon: {
				type: Boolean,
			    default: () => { return false }
			},
            defaultColumns: {
                type: Array,
                default: () => { return [] }
			},
			change: {
			    type: Function,
			    default: () => { }
			},
		},
		destroyed: function () {
			var ele = $(this.$el);
			// var data = ele.data();
			if (ele.data('echMultiselect'))
				ele.multiselect('destroy');
				
			// Ensure any document listeners are removed
			if (this.removeScrollbarClickBlocker) {
				this.removeScrollbarClickBlocker();
			}
		},
		watch: {
			'options':  {
				handler (val, oldVal) {
					var self = this;
					this.data = val;
					Vue.nextTick(function(){
						$(self.$el).multiselect('refresh');
						self.setSelectedValues(self.value);
					});
		        },
		        deep: true,
	            immediate: true
			},
			'value': {
				handler (val, oldVal) {
					this.setSelectedValues(val);
		        },
		        deep: true,
		        immediate: true
			},
		},
		data() {
			return {
				multi : "",
				data : [],
			}
		},
		model: {
			event: `select`
		},
		_colors : [],
		created() {
			vsselect = this;
		},
		mounted() {
			this.createMultiSelect();
		},

		methods: {
			/**
			 * Detect if a mouse event occurred on the browser scrollbars
			 * and not inside the document content area.
			 * This helps us avoid closing the dropdown when the user
			 * clicks and drags the page scrollbar to scroll.
			 */
			isClickOnScrollbar: function (event) {
				// Heuristic scrollbar thickness for overlay scrollbars
				var DEFAULT_SCROLLBAR_THICKNESS = 14;

				function isOnElementScrollbar(el, e) {
					if (!el) return false;
					var hasV = el.scrollHeight > el.clientHeight;
					var hasH = el.scrollWidth > el.clientWidth;
					if (!hasV && !hasH) return false;
					var rect = el.getBoundingClientRect();
					// If scrollbars take up layout space, compute thickness; else use heuristic
					var vThickness = Math.max((rect.width - el.clientWidth), DEFAULT_SCROLLBAR_THICKNESS);
					var hThickness = Math.max((rect.height - el.clientHeight), DEFAULT_SCROLLBAR_THICKNESS);
					var onV = hasV && e.clientX >= (rect.right - vThickness) && e.clientX <= rect.right && e.clientY >= rect.top && e.clientY <= rect.bottom;
					var onH = hasH && e.clientY >= (rect.bottom - hThickness) && e.clientY <= rect.bottom && e.clientX >= rect.left && e.clientX <= rect.right;
					return onV || onH;
				}

				// Walk up from the event target to detect any scrollable ancestor (e.g., popup/modal body)
				var node = event.target;
				while (node && node !== document) {
					if (node instanceof Element) {
						if (isOnElementScrollbar(node, event)) {
							return true;
						}
					}
					node = node.parentNode;
				}

				// Fallback: also check the viewport/window scrollbar areas
				var docEl = document.documentElement;
				var winInnerWidth = window.innerWidth || docEl.clientWidth;
				var winInnerHeight = window.innerHeight || docEl.clientHeight;
				var verticalScrollbarWidth = winInnerWidth - docEl.clientWidth;
				var horizontalScrollbarHeight = winInnerHeight - docEl.clientHeight;
				var verticalThreshold = verticalScrollbarWidth > 0 ? verticalScrollbarWidth : DEFAULT_SCROLLBAR_THICKNESS;
				var horizontalThreshold = horizontalScrollbarHeight > 0 ? horizontalScrollbarHeight : DEFAULT_SCROLLBAR_THICKNESS;
				var hasVerticalScrollbar = docEl.scrollHeight >= docEl.clientHeight;
				var hasHorizontalScrollbar = docEl.scrollWidth >= docEl.clientWidth;
				var onVerticalScrollbar = hasVerticalScrollbar && (event.clientX >= (winInnerWidth - verticalThreshold));
				var onHorizontalScrollbar = hasHorizontalScrollbar && (event.clientY >= (winInnerHeight - horizontalThreshold));
				return onVerticalScrollbar || onHorizontalScrollbar;
			},

			/**
			 * Install a capture-phase mousedown handler that stops propagation
			 * when the user clicks the browser scrollbars. This prevents the
			 * global outside-click handler (from the multiselect plugin) from
			 * closing the dropdown while still allowing the page to scroll.
			 */
			installScrollbarClickBlocker: function () {
				var _this = this;
				if (this._scrollbarClickBlocker) {
					return;
				}
				this._scrollbarClickBlocker = function (e) {
					if (_this.isClickOnScrollbar(e)) {
						if (e && e.stopPropagation) {
							e.stopPropagation();
						}
					}
				};
				document.addEventListener('mousedown', this._scrollbarClickBlocker, true);
			},

			/**
			 * Remove the scrollbar click blocker when the dropdown closes
			 * or the component is destroyed to avoid leaks.
			 */
			removeScrollbarClickBlocker: function () {
				if (this._scrollbarClickBlocker) {
					document.removeEventListener('mousedown', this._scrollbarClickBlocker, true);
					this._scrollbarClickBlocker = null;
				}
			},

			itemKey: function (item) {
				if(!this.showItemKey){
					return '';
				}
				if(!item){
					return '';
				}
				if (item.tfsId) {
					return item.tfsId;
				}
				if (item.jiraId) {
					return item.jiraKey;
				}
				else if (item.kendisKey) {
					return item.kendisKey;
				}
				else if (item.jiraKey) {
					return item.jiraKey;
				} else if(item.key) {
					return item.key
				}
				else {
					return "";
				}
			},
			getTfsItemIcon : function(item){
				if(this.showTfsJiraIcons){
					if(item){
					if(item.tfsItemTypeIcon != undefined){
						return item.tfsItemTypeIcon;
					}else if(item.icon != undefined){
						return item.icon;
					}
					}
				}
				return ''
			},
			getItemIcon : function(item){
				if(item && item.jiraIssueTypeId != undefined && this.showTfsJiraIcons){
					return ' jira-icon jira-icon_'+item.jiraIssueTypeId;
				}
				return ''
			},

			getWorkSpaceTyepIcon : function(item){
				if(item && item.icon != undefined && this.showIcon){
					return '<i style="color:'+ item.color +'" class="material-symbols-outlined">'+ item.icon +'</i>';
				}
				return ''
			},
			getDeletedOpt : function(item){
				if(item && item.isDeleted === true){
					return 'true';
				}
				return ''
			},
			getCleanedTitleString : function (title) {
				if(title) {
					var cleanTitle = title.replace(/<\/?[^>]+(>|$)/g, "");
					return cleanTitle;
				}else {
					return "";
				}
			},
			getJQureyValues: function (_values) {
				var values = [];
				_.each(_values,v=>{
					values.push(v[label]);
				});
				return values;
			},

			setSelectedValues: function (_values) {

				var _this = this;

				var jquery = $(this.$el);
				var values = [];
				if (this.valueType === 'value') {
					if (!_.isEmpty(_values)) {
						values = _values;
					}
				}else if (!_.isEmpty(_values)){
					if (this.multiple) {
						_.each(_values,v=>{
							values.push(v[_this.trackBy]);
						});
					}else {
						values = _values[_this.trackBy];
					}
				}
				jquery.val(values).multiselect('refresh');

				if(_this.showSelectAllOnGroup && _this.$el){			// again creating group select all after refresh
					_this.createGroupSelectAll(_this.$el,_this);
				}
				if (_this.$el) {
					_this.createSelectAll(_this.$el,_this);
				}
				// Calling the on change listener in parent.
				this.change();
			},

			open: function () {
				var jquery = $(this.$el);
				jquery.multiselect('open');
			},
			close: function () {
				var jquery = $(this.$el);
				jquery.multiselect('close');
			},

			createMultiSelect:function () {
				var _this = this;

				var jquery = $(this.$el);

				jquery.multiselect({
					position: _this.position,
					appendTo: _this.appendTo,
					multiple: _this.multiple,
					noneSelectedText : function(a,b,c){
						return _this.emptySelectionText;
					},
					selectedText:function(numChecked, numTotal, checkedItems){
						if (_.isEmpty(_this.selectedTitle)) {

							// Filter out the "Select All" checkbox from checkedItems
							var actualItems = Array.from(checkedItems).filter(function(item) {
								return !item.classList.contains('select-all-items');
							});

							// If no actual items are selected, let the plugin show the empty text
							if (actualItems.length === 0) {
								return _this.emptySelectionText;
							}

							if (_.isEmpty(_this.selectedTitleClass)) {
								return checkedItems.map(function(x){return x.getAttribute('title');}).join(', ');
							}
							else {
								return "<span class='"+_this.selectedTitleClass+"'>"+checkedItems.map(function(x){return x.getAttribute('title');}).join(', ')+"</span>";
							}

						}else {
							return _this.selectedTitle;
						}
					},
					click:function(event,ui){
						var vue = _this;
						if(ui.checked){
							vue.$emit('checked',ui.value, true);
						}else{
							vue.$emit('checked',ui.value, false);
						}
					},
					open:function(){
						$(this).multiselect().multiselectfilter({autoReset: true});
						var vue = _this;
						var multiselect = this;
						if(vue.showSelectAllOnGroup){
							vue.createGroupSelectAll(multiselect,vue);
						}
                        // Avoid closing when clicking the window scrollbars while open
                        vue.installScrollbarClickBlocker();
                        if (vue.defaultColumns && vue.defaultColumns.length > 0) {
                            if (!_this.arraysAreEqual(vue.value, vue.defaultColumns)){
                                var $widget = $(multiselect).multiselect('widget');
                                var $ul = $widget.find(".ui-helper-reset");
                                var $li = $ul.find(".ui-multiselect-close.done");
                                var $revertButton = $('<li class="ui-reset-default revertLabel"><a class="ui-multiselect-none">Revert columns</a></li>');
                                $revertButton.find('a').click(function () {
                                    $(_this.$el).data('revertClicked', true);
                                    _this.revertToDefaultColumns();
                                });
                                if ($ul.find(".ui-reset-default").length == 0) {
                                    $li.after($revertButton);
                                }
                            }else{
                                var $widget = $(multiselect).multiselect('widget');
                                var $ul = $widget.find(".ui-helper-reset");
                                $ul.find(".ui-reset-default").remove();
                            }
                        }

						vue.$emit('open',this);
					},
					close:function(event){
						var vue = _this;
                        // Cleanup the scrollbar blocker on close
                        vue.removeScrollbarClickBlocker();
						if (vue && vue != null) {
							vue.$emit('close',this);
						}
					}
				}).change(function(event){

					event.stopImmediatePropagation();

					var target = $(event.target);
					var value = target.val();
					if (value == null) {
						value = undefined;
					}
					var vue = _this;
					vue.handleChangeValue(value, vue);
				});

				Vue.nextTick(function () {
					$(_this.$el).next().next().find(".ui-multiselect-close").click(function () {
						_this.$emit("on-select-done");
					});
					if (_this.hideDoneButton) {
						$(_this.$el).next().next().find(".ui-multiselect-close").hide();
					}
				});
				if (this.value) {
					this.setSelectedValues(this.value);
				}
			},
			handleChangeValue: function(value, vue) {
                var _this = this;
				var returnValue;
				if (vue.multiple) {

					if (vue.valueType === 'value') {
                        // Check if revert was clicked and value is undefined
                        var revertClicked = $(this.$el).data('revertClicked');
                        if (revertClicked && value === undefined) {
                            returnValue = vue.value;
                            // Reset the revertClicked data attribute after checking
                            $(this.$el).removeData('revertClicked');
                        } else {
                            returnValue = value;
                        }

                        if (vue.defaultColumns && vue.defaultColumns.length > 0) {
                            if (!_this.arraysAreEqual(returnValue, vue.defaultColumns)) {
                                var $widget = $(vue.$el).multiselect('widget');
                                var $ul = $widget.find(".ui-helper-reset");
                                var $li = $ul.find(".ui-multiselect-close.done");
                                var $revertButton = $('<li class="ui-reset-default revertLabel"><a class="ui-multiselect-none">Revert columns</a></li>');
                                $revertButton.find('a').click(function () {
                                    $(_this.$el).data('revertClicked', true);
                                    _this.revertToDefaultColumns();
                                });
                                if ($ul.find(".ui-reset-default").length == 0) {
                                    $li.after($revertButton);
                                }
                            } else {
                                var $widget = $(vue.$el).multiselect('widget');
                                var $ul = $widget.find(".ui-helper-reset");
                                $ul.find(".ui-reset-default").remove();
                            }
                        }
					}
					else {

						var allOptions;
						if (vue.groupsEnabled) {
							allOptions = [];
							_.each(vue.data, g => {
								if (!_.isEmpty(g[vue.groupValues])) {
									allOptions = _.concat(allOptions, g[vue.groupValues]);
								}
							});
						} else {
							allOptions = vue.data;
						}

						var values = [];
						if (!_.isEmpty(value)) {
							_.each(value, v => {
								var obj = _.find(allOptions, function(o) {
									return o[vue.trackBy] === v;
								});
								values.push(obj);
							});
						}
						returnValue = values;
					}
				}
				else {

					if (vue.valueType === 'value') {
						returnValue = value[0];
					}
					else {

						var allOptions;
						if (vue.groupsEnabled) {
							allOptions = [];
							_.each(vue.data, g => {
								if (!_.isEmpty(g[[vue.groupValues]])) {
									allOptions = _.concat(allOptions, g[vue.groupValues]);
								}
							});
						} else {
							allOptions = vue.data;
						}
						var obj = _.find(allOptions, function(o) {
							return o[vue.trackBy] === value[0];
						});
						returnValue = obj;
					}
				}
				if (vue.showBottomButton && !returnValue && value[0] == "select-button") {  // for bottom button
					returnValue = {
						id: "select-button",
						type: vue.id
					};
				}
				vue.$emit('select', returnValue, vue);
			},
			createSelectAll: function(multiselect,vue){

				let _this = this;

				Vue.nextTick(function() {
					var $widget = $(multiselect).multiselect('widget');
					let element = $widget.find(".ui-helper-reset").not('.ui-multiselect-checkboxes');

					let checked = false;
					if (_this.showSelectAll) {
						let allLis;
						if (vue.groupsEnabled) {
							allLis = $widget.find('li.groupedLi');
						}
						else {
							let checkboxesRoot = $widget.find('.ui-multiselect-checkboxes');
							allLis = checkboxesRoot.find('li');
						}
						let checkedLis = allLis.find('input:checked');
						checked = allLis.length == checkedLis.length ? 'checked="checked"' : '';
					}

					let find = element.find("#check-all-label-"+ (_this.id || 'default'));
					if (find.length > 0) {
						for (let i = 0; i < find.length ; i ++) {
							find[i].remove();
						}
					}
					if (_this.showSelectAll) {
						$('<label />', {
							id: "check-all-label-"+ (_this.id || 'default'),
							class: "ctgrlbl custom-checkbox p-rel",
							text: "",
							html: '<input class="select-all-items" id="check-all-input-' + (_this.id || 'default') + '" type="checkbox"' + checked + ' /><label for="check-all-input-' + (_this.id || 'default') + '" class="lbl">Select All</label>',
							on: {
								click: function(event) {
									event.stopPropagation();
									if (event.target.className == "select-all-items") {
										let $inp;
										if (vue.groupsEnabled) {
											$inp = $widget.find('li.groupedLi');
										}
										else {
											let checkboxesRoot = $widget.find('.ui-multiselect-checkboxes');
											$inp = checkboxesRoot.find('li');
										}
										let value = "";
										if (vue.multiple) {
											if (event.target.checked) {
												var allOptions;
												if (vue.groupsEnabled) {
													allOptions = [];
													_.each(vue.data, g => {
														if (!_.isEmpty(g[_this.groupValues])) {
															allOptions = _.concat(allOptions, g[_this.groupValues]);
														}
													});
												} else {
													allOptions = vue.data;
												}
												value = _.map(allOptions,opt=>opt[vue.trackBy]);

											} else {
												value = [];
											}
										}
										$(multiselect).val(value).multiselect('refresh');
										vue.handleChangeValue(value, vue);
									}
								}
							}
						}).appendTo(element);
					}
					else {
						if (find && find.length > 0) {
							for (let i = 0; i < find.length; i++) {
								find[i].remove();
							}
						}
					}
				});
			},
			createGroupSelectAll: function(multiselect,vue){
				Vue.nextTick(function() {
					var $widget = $(multiselect).multiselect('widget');
					$widget.find('.ui-multiselect-optgroup-label').each(function(index, el) {
						var $lis = $(el).nextUntil('.ui-multiselect-optgroup-label');
						var checked = '';
						if ($lis.find('input:checked').length == $lis.length) {
							checked = ' checked="checked" '
						}
						$('<label />', {
							id: "foo",
							class: "ctgrlbl",
							text: "test",          // jQuery text() is called,
							html: '<input class="group-items" id="' + vue.data[index].title + '" type="checkbox"' + checked + ' /><span class="lbl" ></span>', // jQuery html() is called,
							on: {                     // calls jQuery's .on('click' ...
								click: function(event) {
									if (event.target.className == "group-items") {
										var $inp = $(event.target.parentElement).parent().nextUntil('li.ui-multiselect-optgroup-label');
										if (event.target.checked) {
											$inp.find('input:visible:not(:checked)').click();
										} else {
											$inp.find('input:visible:checked').click();
										}
									}
								}
							}
						}).appendTo(el);
					});
				});
			},
			setDoneButtonTitle: function (title) {
				var jquery = $(this.$el);
				jquery.multiselect('widget').find('.ui-icon-circle-close').text(title);
			},
			setDoneButtonCallback: function (_function) {
				var jquery = $(this.$el);
				this.$options.doneCallback = _function;
				jquery.multiselect('widget').find('.ui-icon-circle-close').attr('onclick',this.doneButtonCallback());
			},
			doneButtonCallback: function (event) {
				if (this.$options.doneCallback) {
					this.$options.doneCallback ();
				}
			},
            arraysAreEqual: function (arr1, arr2) {
                if (!arr1 || !arr2) {
                    return false;
                }

                if (arr1.length !== arr2.length) {
                    return false;
                }

                let sortedArr1 = arr1.slice().sort();
                let sortedArr2 = arr2.slice().sort();

                for (let i = 0; i < sortedArr1.length; i++) {
                    if (sortedArr1[i] !== sortedArr2[i]) {
                        return false;
                    }
                }

                return true;
            },
            revertToDefaultColumns: function () {
                this.$emit("on-revert");
            }
		}
});

});