const select_user = Vue.component('vz-select-user', {
		template : `
		<div class="">
            <div ref="userDropdown" class="users pic" @click="onClickDropdown" v-html="buttonTitle"></div> 
            <vuepopup v-if="showList" @close="showList = false;" class="drop_boxa" style="position:fixed;" >
				<div class="srch">
					<input placeholder="Enter keywords" type="search" v-model="query" @input="onEnterSearchText" />
				</div>
				<ul style="display: block;">
					<li v-for="(user,userIndex) in copyUsers" class="pic" :class="[user.selected ? 'selected' : '']" @click="onSelectUser(user,userIndex)" :data-vid="user.id">					
					<template v-if="profilePic(user)">
						<img class="pin" :src="profilePic(user)" alt='' width='80px' height='80px'></img>
					</template>
					<template v-else>
						<div class="pin initial" :style="{'background-color': user.backgroundColor}">{{userInitials(user)}}</div>
					</template>
					<div class="name">{{user.fullName}}</div>					
					</li> 
				</ul>
			</vuepopup>
		</div>
		`,
		/*<div class="FR mnuout ">
			<div class="button-w ico ar users pic" @click="onClickDropdown" v-html="buttonTitle"></div>*/
		props:  {
			users: {
				type: Array,
			    default: () => { return [] }
			},
			value: {
				type: null,
			    default: () => { return [] }
			},
			label: {
				type: String,
			default: () => { return 'fullName' }
			},
			trackBy: {
				type: String,
			default: () => { return 'id' }
			},
			multiple: {
				type: Boolean,
			default: () => { return false }
			},
			placeholder: {
				type: String,
			default: () => { return "<div class='initial icon-user-add add'></div>" }
			}
		},
		
		computed: {
			buttonTitle: function () {
				if (_.isEmpty(this.value)) {
					return this.placeholder;
				}
				else if (this.multiple === true){
					var text = "";
					/*_.each(this.value,user=>{
						if (_.isEmpty(text)) 
							text = user[this.label];
						else 
							text += (", "+user[this.label]);
					});*/
					for (var i = 0; i < this.value.length; i++) {
						if(i > 2){
							text += '<i class="ti-more-alt icmr"></i>';
							break;
						}
						text += this.getUserHTML(this.value[i]);
					}
					text += '<div class="initial icon-user-add add"></div>';
					return text;
					
				}else {
					//return this.value[this.label];
					return this.getUserHTML(this.value, this.value[this.label]);
					
				}
			},
			
			profilePic: function () {
				return function (user) {
					if (user.picturePath) {
						return s3_resource_url + user.picturePath;
					}else {
						return undefined;
					}
				};
			},
			userInitials: function () {
				return function(user) {
					var initials = "";
					if (!_.isEmpty(user.firstName)) {
						initials +=  user.firstName.substring(0,1);
					}
					if (!_.isEmpty(user.lastName)) {
						initials +=  user.lastName.substring(0,1);
					}
					return initials;
				};
			},
		},
		
		data() {
			return {
				showList : false,
				query : "",
				copyUsers : [],
                styleObject: {}				
			}
		},
		watch: {
			'users':  {
				handler (val, oldVal) {
					this.copyUsers = JSON.parse(JSON.stringify(val));
					this.onSetUsers();
		        },
		        deep: true,
	            immediate: true
			},
			'value': {
				handler (val, oldVal) {
					this.onSetSelectedUsers(val);
		        },
		        deep: true,
		        immediate: true
			}
		},
		model: {
			event: `select`
		},
		
		created () {
			this.copyUsers = JSON.parse(JSON.stringify(this.users));
			this.onSetUsers();
		},

		mounted: function () {
			
		},
		methods: {
			
			//////////////////////////////////////////////////
			///////////////    LOGIC
			onSetUsers: function () {
				
				var _this = this;
				
				var selectedMap = {};
				if (!_.isEmpty(this.value)) {
					if (this.multiple === true) {
						_.each(this.value,user=>{
							selectedMap[user.id] = user;
						});
					}else {
						selectedMap[this.value.id] = this.value;
					}
				}
				
				if (!_.isEmpty(_this.copyUsers)) {
					_.each(_this.copyUsers,user=>{
						var find = selectedMap[user.id];
						user.selected = find ? true : false;
					});
				}
			},
			onSetSelectedUsers: function (selectedUsers) {
				
				var _this = this;
				
				var selectedMap = {};
				if (!_.isEmpty(selectedUsers)) {
					if (this.multiple === true) {
						_.each(selectedUsers,user=>{
							selectedMap[user.id] = user;
						});
					}else {
						selectedMap[selectedUsers.id] = selectedUsers;
					}
				}
				if (!_.isEmpty(_this.copyUsers)) {
					_.each(_this.copyUsers,(user,ind)=>{
						var find = selectedMap[user.id];
						user.selected = find ? true : false;
					});
				}
			},
			setSelectedValues: function () {
				
				var _this = this;
				var value;
				if (_this.multiple === false) {
					_.each(_this.copyUsers,(rs,ind)=>{
						if (rs.selected) {
							var user = JSON.parse(JSON.stringify(rs));
							delete user.selected;
							value = user;
							return;
						}
					});
				}else {
					var users = [];
					_.each(_this.copyUsers,(rs,ind)=>{
						if (rs.selected) {
							var user = JSON.parse(JSON.stringify(rs));
							delete user.selected;
							users.push(user);
						}
					});
					value = users;
				}
				return value;
			},
			
			//////////////////////////////////////////////////
			///////////////   API CALLS
			
			
			//////////////////////////////////////////////////
			//////////////     UI ACTIONS
			onClickDropdown: function () {
                this.showList 			= true;
                let _this = this;
                //this.styleObject.left 	= this.$refs.userDropdown.getBoundingClientRect().left;
                //this.styleObject.right 	= this.$refs.userDropdown.getBoundingClientRect().right;
                //this.styleObject.top 	= this.$refs.userDropdown.getBoundingClientRect().top;
                //this.styleObject.bottom = this.$refs.userDropdown.getBoundingClientRect().bottom;
                //this.styleObject.height = this.$refs.userDropdown.clientHeight;
                //this.$forceUpdate();
                Vue.nextTick(function () {
                	let $el = $(_this.$el.children[1]);
                	adjustDivOffset($el, $el.parent(), $el.closest('.dropdown_container'));
				});
			},
			onSelectUser: function (user,index) {
				
				var _this = this;
				
				_this.copyUsers[index].selected = !_this.copyUsers[index].selected;
				
				if (_this.copyUsers[index].selected && _this.multiple === false) {
					_.each(_this.copyUsers,(rs,ind)=>{
						if (ind !== index) {
							_this.copyUsers[ind].selected = false;
						}
					});
				}
				
				var value = _this.setSelectedValues();
				_this.$emit('select',value,_this);

				if (!this.multiple) {
					this.showList = false;
				}
			},
			onEnterSearchText: function () {
				var _this = this;
				if (_.isEmpty(_this.query)) {
					_this.copyUsers = JSON.parse(JSON.stringify(_this.users));
				}
				else {
					var users = [];
					var query = _this.query.toLowerCase();
					_.each(_this.users,user=>{
						var lowerFullName = '';
						var lowerUserName = '';
						if(!_.isEmpty(user.fullName)) {
							lowerFullName = user.fullName.toLowerCase();
						}
						if(!_.isEmpty(user.userName)) {
							lowerUserName = user.userName.toLowerCase();
						}
						if ((lowerFullName.includes(query)) || (lowerUserName.includes(query))) {
							users.push(user);
						}
					});
					this.copyUsers = users;
				}
				this.onSetUsers();
			},
			getUserHTML : function(user, label){
				var dp = '';
				if (user.picturePath) {
					dp = '<img class="pin" src="'+s3_resource_url + user.picturePath+'" alt="" width="80px" height="80px"></img>';
				}else {
					dp = '<div class="pin initial" style="background-color: '+user.backgroundColor+';" >'+getUserInitials(user)+'</div>';
				}
				if(label){
					dp += '<div class="name" style="display:block;">'+label+'</div>';	
				}
				return dp;
			}
		}
	});






