// $(document).ready(function () {
	Vue.directive('click-outside', {
        bind: function (el, binding, vnode) {
            el.clickOutsideEvent = function (event) {
                // Check that the click was outside the element and its children
                if (!(el == event.target || el.contains(event.target))) {
                    // Call the method provided in the attribute value
                    vnode.context[binding.expression](event);
                }
            };
            el.attachClickOutsideEvent = function () {
                document.body.addEventListener('click', el.clickOutsideEvent);
                document.body.addEventListener('contextmenu', el.clickOutsideEvent);
            };
            // Add a small delay before attaching the event listener
            setTimeout(el.attachClickOutsideEvent, 10);
        },
        unbind: function (el) {
            document.body.removeEventListener('click', el.clickOutsideEvent);
            document.body.removeEventListener('contextmenu', el.clickOutsideEvent);
        },
	});
// });

const POPUP = Vue.component('vuepopup', {
	template: '<div v-click-outside="onClickOutside"><slot></slot></div>',
	props: {
		model : {
			type : Boolean,
		default () {return false}
		}
	},
	data() {
		return {
			
		}
	},
	mounted () {
		
	},
	methods: {
		onClickOutside : function (event) {
			if(this.$children != undefined && this.$children[0] != undefined && this.$children[0].$el.id == 'featurePopup'){
				if(this.$children[0].$options.itemPopup != undefined && 
				 $(this.$children[0].$options.itemPopup._activePanelId).is(':visible'))
				{
					return;
				}
			}
			this.$emit('close',event);
		}
	}
});

const POPUP_BUTTON = Vue.component('vuepopup_button', {
	template: '<div><div @click="onClickButton"><slot></slot></div><div v-if="show" v-click-outside="onClickOutside"><slot name="content"></slot></div></div>',
	props: {
		model : {
			type : Boolean,
		default () {return false}
		}
	},
	data() {
		return {
			show : false,
		}
	},
	methods: {
		onClickOutside : function (event) {
			this.show = false;
		},
		onClickButton: function () {
			this.show = true;
		}
	}
});
