var HIGH_CHART_MIXIN = {
	template : `
	<div>
		<div class="prevent r-icons">
			<!-- <i class="ti-more" style="cursor: pointer;" @click="showExportPopup = true;"></i>
			<vuepopup v-if="showExportPopup" @close="showExportPopup = false;">
				<div class="drop_box" style="display: block; width: 300px;">
					<ul>
						<li><a href="javascript:void(0);" @click="onClickExportButton('pdf');showExportPopup = false;">Export As PDF</a></li> 
						<li><a href="javascript:void(0);" @click="onClickExportButton('png');showExportPopup = false;">Export As PNG</a></li>
					</ul> 
				</div>
			</vuepopup> -->
		</div>
		<div ref="chart"></div>
	</div>
	`,
	name: 'chart1',
	props: {
		options : {
			type : Object,
			default () {return undefined}
		}
	},
	data() {
		return {
			_chart : undefined,
			showExportPopup : false,
			originalDimensions: {
				width: null,
				height: null
			},
			originalFullScreenDimensions: {
				width: null,
				height: null
			}
		}
	},
	watch: {
		options : {
			handler (val, oldVal) {
				this.drawChartWithData();
			},
			deep: true
		},
	},
	created () {
		this._chart = undefined;
	},
	mounted() {
		this.drawChartWithData();
		this.addFullscreenChangeListener();
	},
	beforeDestroy() {
		this.removeFullscreenChangeListener();
	},
	methods: {
		getChart() {
			if (!this._chart) {
				this._chart = new Highcharts.chart(this.$refs.chart, this.options);
			}
			return this._chart;
		},
		createChart() {},
		drawChartWithData() {
			if (this.options && this.options.series) {
				this.getChart().update(this.options, true);
				this.storeOriginalDimensions();
			}

		},
		addFullscreenChangeListener() {
			document.addEventListener('fullscreenchange', this.handleFullscreenChange);
			document.addEventListener('webkitfullscreenchange', this.handleFullscreenChange);
			document.addEventListener('mozfullscreenchange', this.handleFullscreenChange);
			document.addEventListener('MSFullscreenChange', this.handleFullscreenChange);
		},
		removeFullscreenChangeListener() {
			document.removeEventListener('fullscreenchange', this.handleFullscreenChange);
			document.removeEventListener('webkitfullscreenchange', this.handleFullscreenChange);
			document.removeEventListener('mozfullscreenchange', this.handleFullscreenChange);
			document.removeEventListener('MSFullscreenChange', this.handleFullscreenChange);
		},
		handleFullscreenChange() {
			const chartContainer = this.$refs.chart;

			if (document.fullscreenElement || document.webkitFullscreenElement ||
				document.mozFullScreenElement || document.msFullscreenElement) {
				if (this.originalFullScreenDimensions.width === null || this.originalFullScreenDimensions.height === null) {
					this.originalFullScreenDimensions.width = chartContainer.offsetWidth;
					this.originalFullScreenDimensions.height = chartContainer.offsetHeight;
				}
				const fullWidth = window.innerWidth;
				const fullHeight = window.innerHeight;

				chartContainer.style.width = fullWidth + 'px';
				chartContainer.style.height = fullHeight + 'px';
				this.getChart().setSize(fullWidth, fullHeight, false);
			} else {
				this.restoreOriginalDimensions();
			}
		},
		storeOriginalDimensions() {
			const chartContainer = this.$refs.chart;
			this.originalDimensions.width = chartContainer.offsetWidth;
			this.originalDimensions.height = chartContainer.offsetHeight;
		},
		restoreOriginalDimensions() {
			const chartContainer = this.$refs.chart;
			if (this.originalDimensions.width !== null && this.originalDimensions.height !== null) {
				chartContainer.style.width = this.originalDimensions.width + 'px'; // Add 'px'
				chartContainer.style.height = this.originalDimensions.height + 'px'; // Add 'px'
				this.getChart().setSize(this.originalDimensions.width, this.originalDimensions.height, false);
			}
		},
		restoreFullScreenDimensions() {
			const chartContainer = this.$refs.chart;
			if (this.originalFullScreenDimensions.width !== null && this.originalFullScreenDimensions.height !== null) {
				chartContainer.style.width = this.originalFullScreenDimensions.width + 'px'; // Add 'px'
				chartContainer.style.height = this.originalFullScreenDimensions.height + 'px'; // Add 'px'
				this.getChart().setSize(this.originalFullScreenDimensions.width, this.originalFullScreenDimensions.height, false);
			}
		},
	}
};

const CHART1 = Vue.component('chart1', HIGH_CHART_MIXIN);
