const CUSTOM_TIME_PICKER = Vue.component('custom-time-picker', {
	props: {
		stepMinutes: {
			type: Number,
		    default: () => { return 10 }
		},
		stepHours: {
			type: Number,
		    default: () => { return 1 }
		},
		clear: {
			type: Boolean,
		    default: () => { return true }
		},
		format: {
			type: Number,
		    default: () => { return 24 }
		},
		value: {
			type: null,
	        default () {
		      return ""
			}
		}
	},
	template:`
		<div class="p-rel">
			<div @click="showList = true;" class="nwtminp">
				<input v-model="selectedHours" ref="hourInput" @input="setTime('hour')" class="a" type="number" placeholder="HH" />
				<input v-model="selectedMinutes" ref="MinuteInput" @input="setTime('minute')" class="b" type="number" placeholder="mm" />
				<a v-if="clear" href="javascript:void(0);" @click="clearTime" class="rmv-ico ti-close" title="Clear"></a>
			</div>
			<div v-if="showList" v-click-outside="onClickOutsideOfList" id="time-list" class="drop_boxa nwtmr dd-list">
				<ul>
					<template v-if="format==24" class="rec stin" v-for="(hour, hourIndex) in stepHoursArray">
						<template class="rec stin" v-for="(minute, minuteIndex) in stepMinutesArray">
							<li @click ="selectTime(hour,minute,null)" :id="'custom_time_'+hour+'_'+minute" :class="highlightSelectedTime(hour, minute)">
								<span class="a">{{hour | doubleDigitTime}}</span> <span class="sp">:</span> <span class="b">{{minute | doubleDigitTime}}</span>
							</li>
						</template>
					</template>
					<template v-else-if="format==12" class="rec stin" v-for="(period, periodIndex) in periods">					
						<template class="rec stin" v-for="(hour, hourIndex) in stepHoursArray">
							<template class="rec stin" v-for="(minute, minuteIndex) in stepMinutesArray">
								<li @click ="selectTime(hour,minute,period)" :id="'custom_time_'+hour+ '_' + minute">
									<span class="a">{{hour | doubleDigitTime}}</span> <span class="sp">:</span> <span class="b">{{minute | doubleDigitTime}} {{period}}</span>
								</li>
							</template>
						</template>
					</template>
				</ul>
			</div>
		</div>
	`,
	data() {
		return {
			hours: [],
			minutes: [],
			periods: ['am', 'pm'],
			showList : false,
			time: '',
			selectedHours: '',
			selectedMinutes: '',
		}
	},
	watch: {
		'showList': {
			handler(val, oldVal) {
				if (val) {
					var _this = this;
					Vue.nextTick(function () {
						_this.popupAutoDirection();
						_this.gotoElement();
					});
				}
			},
			immediate: true
		},
		'showAdd': {
			handler(val, oldVal) {
				if (val) {
					var _this = this;
					Vue.nextTick(function () {
						_this.popupAutoDirection();
					});
				}
			},
			immediate: true
		},
		'value': {
			handler(val, oldVal) {
				var components = this.value.split(":");
				this.selectedHours = components[0];
				this.selectedMinutes = components[0]==""?"":components[1];
				this.time = this.selectedHours + ":"+ this.selectedMinutes;
			},
			immediate: true
		},
		'selectedHours' : {
			handler(val, oldVal) {
				if(this.selectedHours == "" || this.selectedMinutes == "") {
					this.time = ""
				}
				else {
					this.time = this.selectedHours + ":"+ this.selectedMinutes;
				}
				this.$emit('selected', this.time);
			}
		},
		'selectedMinutes' : {
			handler(val, oldVal) {
				if(this.selectedHours == "" || this.selectedMinutes == "") {
					this.time = ""
				}
				else {
					this.time = this.selectedHours + ":"+ this.selectedMinutes;
				}
				this.$emit('selected', this.time);
			}
		}		
	},
	filters: {
		doubleDigitTime : function(time) {
			var num = ("0" + time).slice(-2);
			return `${num}`;
		}
	},
	created() {
		if(this.format === 24) {
			for(var i = 0; i< this.format; i++){
				this.hours.push(i);
			}
		}
		else {
			this.hours.push(12);
			for(var i = 0; i < this.format - 1; i++){
				this.hours.push(i+1);
			}
		}
		for(var i = 0; i < 60; i++){
			this.minutes.push(i);
		}
	},
	model: {
		event: `selected`
	},
	mounted() {

	},
	computed: {
		stepMinutesArray: function() {
			return this.minutes.filter((e, i) => i % this.stepMinutes === 0);
		},
		stepHoursArray: function() {
			return this.hours.filter((e, i) => i % this.stepHours === this.stepHours - 1);
		},
	},
	methods: {
		onClickOutsideOfList: function () {
			if (!this.$el.contains(event.target)) {
				this.showList = false;
			}
		},
		popupAutoDirection: function () {
			var popup = $(this.$el).find(".dd-list");
			var popupPosition = popup.offset();

			var popupHeight = popup.height()
			var windowHeight = $(window).height();
			
			var spaceAtTop  = popupPosition.top;
			var spaceAtDown = windowHeight - popupPosition.top;

			var topDiff    = spaceAtTop - popupHeight;
			var bottomDiff = spaceAtDown - popupHeight;
			
			if (topDiff > bottomDiff) {
				popup.removeClass("dir-down");
				popup.addClass("dir-up");
			} else {
				popup.removeClass("dir-up");
				popup.addClass("dir-down");
			}
		},
		selectTime: function(hour, minute, period) {
			this.time = ("0" + hour).slice(-2) + ":" + ("0" + minute).slice(-2);
			this.showList = false;
			var components = this.time.split(":");
			this.selectedHours = components[0];
			this.selectedMinutes = components[1];
			this.$emit('selected', this.time);
		},
		setTime: function(type) {
			if(type == 'hour') {
				if(this.format == 12) {
					if(this.selectedHours < 0)
						this.selectedHours = 1;
					else if(this.selectedHours > 12)
						this.selectedHours = 12;
				}
				else if(this.format == 24) {
					if(this.selectedHours < 0)
						this.selectedHours = 0;
					else if(this.selectedHours > 23)
						this.selectedHours = 23;		
				}
				//this.selectedHours = ("0" + parseInt(this.selectedHours)).slice(-2);
				let hh = parseInt(this.selectedHours);
				if(isNaN(hh)){
					this.selectedHours = "00";
				}else{
					this.selectedHours = ("0" + hh).slice(-2);
				}
			}
			else if(type == 'minute') {
				if(this.selectedMinutes < 0){
					this.selectedMinutes = 0;
				} else if(this.selectedMinutes > 59){
					this.selectedMinutes = 59;
				}
				//this.selectedMinutes = ("0" + parseInt(this.selectedMinutes)).slice(-2);
				let mm = parseInt(this.selectedMinutes);
				if(isNaN(mm)){
					this.selectedMinutes = "00";
				}else{
					this.selectedMinutes = ("0" + mm).slice(-2);
				}
			}
		},
		clearTime: function() {
			this.time = '';
			this.selectedHours = '';
			this.selectedMinutes = '';
		},
		gotoElement: function() {
			var refName = Number.parseInt(this.selectedHours).toString() + "_" + (Math.round(Number.parseInt(this.selectedMinutes)/10)*10).toString();
			var ct = document.getElementById("custom_time_"+refName);
			if(ct){
				ct.parentElement.scrollTop = ct.offsetHeight * $(ct.parentElement.children).index(ct);
			}			
		},
		highlightSelectedTime: function(hour, minute) {
			if(this.selectedMinutes % 10 == 0 && this.selectedMinutes == minute && this.selectedHours == hour){
				return 'highlight-selected-time'
			}
			return ''
		}
	}
});