
function GET_SUB_ITEMS_LISTING_TEMPLATE(){
	return Vue.component('sub-items-listing',{
		template : /*html*/`
			<div class="lnkitm-o">
				<ul class="table inn sub-items-listing">
					<template v-if="items">
						<template v-if="isObjectiveLinkingView">
						    <template v-if="committedObjs.length > 0">
                                <div :class="['ftsb', 'fs-16', 'DFA', 'prow', 'mb-10', expandCollapseCommittedObjs ? 'active' : '']"><em @click="expandCollapseCommittedObjs=!expandCollapseCommittedObjs" class="arrdrpico arr DIB trnsn c-point"></em>Objectives</div>
                                <template v-if="expandCollapseCommittedObjs">
                                    <li v-for="(obj,index) in committedObjs" class="rec DFA mb-0">
                                        <div class="rc c2 title">
                                        	<span @click="openSubItem(obj)" class="key fs-13 c-point">{{obj.key}}</span>
                                        	<span class="title" v-html="obj.title"></span>
											<div v-for="(pi, piIndex) in getParentSessions(obj)" class="tm lbl-bg" :title="pi.title" :style="{'color': pi.prefixColor ? pi.prefixColor : ''}" @click="redirectToSession(pi)">
												<div class="line" :style="{'background-color': pi.prefixColor ? pi.prefixColor : ''}"></div>
												{{pi.prefix? pi.prefix: pi.title}}
											</div>
                                        </div>
                                        <div v-if="obj.status" class="rc c4 status ml-20 mr-30">
                                            <span class="sts" :class="statusCategoryClass(obj)">{{obj.status.title}}</span>
                                        </div>
                                        <div class="achivt">
                                            <div><span :style="{width: subItemCompletion(obj)+'%'}"></span></div>
                                            <strong :data-real-value="subItemCompletion(obj)">{{subItemCompletion(obj)}}%</strong>
                                        </div>
                                        <em v-if="removeItemPermission" class="rmv-ico ti-close rnd sml DAJ w" @click.stop="onClickUnlinkObj(obj)" title="Remove"></em>
                                    </li>
                                </template>
							</template>
							<template v-if="unCommittedObjs.length > 0">
                                <div :class="['ftsb', 'fs-16', 'DFA', 'prow', 'mb-10', 'mt-20', expandCollapseUncommittedObjs ? 'active' : '']"><em @click="expandCollapseUncommittedObjs=!expandCollapseUncommittedObjs" class="arrdrpico arr DIB trnsn c-point"></em> Uncommitted Objectives</div>
                                <template v-if="expandCollapseUncommittedObjs">
                                    <li v-for="(obj,index) in unCommittedObjs" class="rec DFA mb-0">
                                    	<div class="rc c2 title">
                                        	<span @click="openSubItem(obj)" class="key fs-13 c-point">{{obj.key}}</span>
                                        	<span class="title" v-html="obj.title"></span>
											<div v-for="(pi, piIndex) in getParentSessions(obj)" class="tm lbl-bg" :title="pi.title" :style="{'color': pi.prefixColor ? pi.prefixColor : ''}" @click="redirectToSession(pi)">
												<div class="line" :style="{'background-color': pi.prefixColor ? pi.prefixColor : ''}"></div>
												{{pi.prefix? pi.prefix: pi.title}}
											</div>
                                        </div>
                                        <div class="rc c4 status ml-20 mr-30"v-if="obj.status">
                                            <span class="sts" :class="statusCategoryClass(obj)">{{obj.status.title}}</span>
                                        </div>
                                        <div class="achivt">
                                            <div><span :style="{width: subItemCompletion(obj)+'%'}"></span></div>
                                            <strong :data-real-value="subItemCompletion(obj)">{{subItemCompletion(obj)}}%</strong>
                                        </div>
                                        <em v-if="removeItemPermission" class="rmv-ico ti-close rnd sml DAJ w" @click.stop="onClickUnlinkObj(obj)" title="Remove"></em>						
                                    </li>
                                </template>
							</template>
						</template>
						<template v-else>
							<li v-for="(item,index) in items" class="rec aa DFA mb-0">
								<div class="rc c2 title">
									<span @click="openSubItem(item)" class="key fs-13 c-point">{{item.key}}</span>
									<span class="title" v-html="item.title"></span>
								</div>
								<div class="rc c4 status ml-20 mr-30"v-if="item.status">
									<span class="sts" :class="statusCategoryClass(item)">{{item.status.title}}</span>
								</div>
								<div class="achivt prog_2 prg">
                                   <div><span :style="{width: subItemCompletion(item)+'%'}"></span></div>
                                   <strong :data-real-value="subItemCompletion(item)">{{subItemCompletion(item)}}%</strong>
                               </div>
					            <em v-if="removeItemPermission" class="rmv-ico ti-close rnd sml DAJ w" @click.stop="onClickRemoveLink(index)" title="Remove"></em>						
							</li>
						</template>
					</template>
					<template v-else>
						<div class="nofound">No sub items linked</div>
					</template>	
				</ul>						
			</div>
		`,
		props : {
			allowOpenSubItem:{
				type: Boolean,
				default: () =>{ return true }
			},
			configureFields: {
				type: Array,
				default: () => { return [] }
			},
			itemsList: {
				type: Array,
				default: () => { return [] }				
			},			
			itemId: {
				type: String,
				default: () => { return null }
			},
			editPermission: {
				type: Boolean,
				default: () =>{ return true }
			},
			isObjectiveLinkingView: {
				type: Boolean,
				default: () =>{ return false }
			},
			removeItemPermission: {
				type: Boolean,
				default: () =>{ return true }				
			},
			isMockingMode: {
                type: Boolean,
                default: () =>{ return false }
            },
			subItemsCompletionData: {
                type: Array,
                default: () =>{ return [] }
            },
            board: {
                type: Object,
                default: () => { return {} }
            },
			sessionsMap: {
				type: Object,
				default: () => { return {} }			
			},
		},
		data : function (){
			return {
				model : {
					startDateFieldId 	: '',
					endDateFieldId   	: '',
				},
				piObjectiveByMap				: {},
				items                       	: [],
				committedObjs               	: [],
				unCommittedObjs             	: [],
				expandCollapseCommittedObjs 	: true,
				expandCollapseUncommittedObjs 	: true,
			}
		},
		watch: {
			getOkrCompletionMap: {
				handler: function(_new, _old) {
					this.$forceUpdate();
				},
				deep: true,
				immediate: true,
			}			
		},
		computed: {
			getOkrCompletionMap: function() {
				return kendisStore.getters.getOkrCompletionMap();
			},
            subItemCompletion: function (){
				return function(item) {
	                let _this = this;
					if(_this.isMockingMode) {
						if(this.getOkrCompletionMap) {
							if(this.getOkrCompletionMap[item.id]) {
								return this.getOkrCompletionMap[item.id];
							}else{
	                            return 0;
	                        }
						}					
					} else {
		                let okr = _.find(_this.subItemsCompletionData, {id : item.id});
		                return okr.completion;
					}
				}
            }		
		},
		created (){
			let _this = this;
			if(_.isEmpty(_this.itemsList)) {
				_this.fetchItems();
			}
			else {
				_this.items = _this.itemsList
			}
			_this.setFields();
            if (_this.isObjectiveLinkingView){
                _this.sortObjectives(_this.itemsList);
            }
		},
		methods : {
		
			fetchItems: function (){
				var _this = this;
				
				axios.get('external-entitites/get-sub-items/'+_this.itemId)
				.then(response=>{
					if(response.data.subItems){
						_this.items = response.data.subItems;
					}
				})
				.catch(error=>{
					
				});
				
			},
			sortObjectives: function(objectives){
                let _this = this;
                if (objectives){
                    _.each(objectives, obj => {
                        if (obj.type === "Objective-Committed"){
                            _this.committedObjs.push(obj);
                        }else{
                            _this.unCommittedObjs.push(obj);
                        }
                    });
                }
			},
			editSubItem : function (id){
				this.$emit('edit',id);
			},
			setFields : function () {
				if(this.configureFields){
					for (var i = 0; i< this.configureFields.length; i++){
						if(this.configureFields[i].title == "Start Date"){
							this.model.startDateFieldId = this.configureFields[i].id
						}
						if(this.configureFields[i].title == "End Date"){
							this.model.endDateFieldId = this.configureFields[i].id
						}
					}
				}
			},
			convertDate : function (date){
				const months = ["January", "Feburary", "March","April", "May", "June", "July", "August", "September", "October", "November", "December"];
				var dateObj = new Date(date);
				
				return (dateObj.getDate() +" "+ months[dateObj.getMonth()] + " " + dateObj.getFullYear());
			},
	        onClickRemoveLink: function (index) {
	            let _this = this;
                let msg = "";
                if (_this.items[index].type === "KR"){
                    msg = "remove this key result?";
                }else{
                    msg = "unlink this objective?";
                }
	            askFromSweetAlertWrapper("Do you want to " + msg,
	                [_this.unlinkItem, _this.items[index]],
	                [takeNoAction]);
	        },
	        onClickUnlinkObj: function (obj) {
	            let _this = this;
                let msg = "";
                if (obj.type === "KR"){
                    msg = "remove this key result?";
                }else{
                    msg = "unlink this objective?";
                }
	            askFromSweetAlertWrapper("Do you want to " + msg,
	                [_this.unlinkItem, obj],
	                [takeNoAction]);
	        },
	
	        unlinkItem: function (item) {
	            let _this = this;
	            let requestBody = {};
                let metaMap = {};
                metaMap.syncId = syncId;

                if (_this.isMockingMode){
                    metaMap.sessionId = _.isEmpty(_this.board) ? "-1" : _this.board.session.id;
                }else{
                    metaMap.sessionId = vueInstance.activeBoard.session.id;
                }
                
                if (!metaMap.createOkrFromObjPopup && _this.$parent.displayMode === "Objective"){
                    metaMap.createOkrFromObjPopup = true;
                }
                if (_this.$parent.fieldsValue){
                   requestBody.groupId = _this.$parent.fieldsValue.id;
                }
                requestBody.objId = item.id;

                let msg = "";

                if (item.type.includes("Objective") && _this.$parent.fieldsValue && (_this.$parent.fieldsValue.key.includes("KR") || _this.$parent.fieldsValue.key.includes("OBJ"))){
                    requestBody.unlinkObjective = true;
                    msg += "Objective Unlinked."
                }else{
                    msg += "Key Result Deleted."
                }
                requestBody.metaMap = JSON.stringify(metaMap);

	            axios.post('/objective/delete-objective', requestBody)
	                .then(response => {
	                    if (response && response.status == "200") {
	                        _.remove(_this.items, {id: item.id});
	                        _this.$forceUpdate();
                            showTopMessage(msg, 'success');
	                        _this.$emit("remove-item", item);
                        }
                    })
                    .catch(error => {
                        console.error("Item Link remove error", error);
                        handleSoSErrorMsg(error);
                    });
		    },
		    openSubItem: function (item){
								if(this.allowOpenSubItem) {
									this.$emit("open-sub-item", item);
								}
								else{
									showTopMessage("You can edit Objectives / Key Results from OKRs List view",'success');
								}

		    },
		    statusCategoryClass: function(item) {
                if(item.status.category == "ToDo") {
                    return 'a';
                } else if(item.status.category == "InProgress") {
                    return 'b';
                } else if(item.status.category == "Done") {
                    return 'c';
                } else if(item.status.category == "Misc") {
                    return 'd';
                }
            },
			redirectToSession: function(pi) {
	            let url = "/session?id="+pi.activeSessionBoard;
	            window.open(url, "_blank");			
			},
			getParentSessions: function(item) {
				let _this = this;
				let sessions = [];
				let sessionIdsMap = {};			
				_.each(item.baseItemLinks, link=>{
	    			if((link.linkType && link.linkType ==  "session_linked_objective" && link.type == "Objective") || (link.type == "Objective" && !_.isEmpty(link.sessionBoardId))) {
						sessionIdsMap[link.sessionId] = 1;
	    			}
				});
				_.each(Object.keys(sessionIdsMap), sessionId =>{
	                if (_this.sessionsMap[sessionId]){
					    sessions.push(_this.sessionsMap[sessionId]);
	                }
				})			
				return sessions;			
			}
		
		},		
	});
}