/*!
 *
 * Bryntum Scheduler Pro 6.3.1
 *
 * Copyright(c) 2025 Bryntum AB
 * https://bryntum.com/contact
 * https://bryntum.com/license
 *
 * Bryntum incorporates third-party code licensed under the MIT and Apache-2.0 licenses.
 * See the licenses below or visit https://bryntum.com/products/schedulerpro/docs/guide/SchedulerPro/licenses
 *
 * # Third Party Notices
 * 
 * Bryntum uses the following third party libraries:
 * 
 * * [Font Awesome 6 Free](https://fontawesome.com/license/free) (MIT/SIL OFL 1.1)
 * * [Roboto font (for Material theme only)](https://github.com/google/roboto) (Apache-2.0)
 * * [Styling Cross-Browser Compatible Range Inputs with Sass](https://github.com/darlanrod/input-range-sass) (MIT)
 * * [Tree Walker polyfill (only applies to Salesforce)](https://github.com/Krinkle/dom-TreeWalker-polyfill) (MIT)
 * * [chronograph](https://github.com/bryntum/chronograph) (MIT)
 * * [later.js](https://github.com/bunkat/later) (MIT)
 * * [Monaco editor (only used in our demos)](https://microsoft.github.io/monaco-editor) (MIT)
 * * Map/Set polyfill to fix performance issues for Salesforce LWS (MIT)
 * * [Chart.js (when using Chart package)](https://github.com/chartjs/Chart.js) (MIT)
 * 
 * Note: the **chronograph** and **later.js** libraries are used in Bryntum Scheduler Pro and Bryntum Gantt, but they are
 * listed for all Bryntum products since the distribution contains trial versions of the thin bundles for all other
 * products. TreeWalker is only used in the LWC bundle for Salesforce. Roboto font is only used in the material theme.
 * 
 * ## Font Awesome 6 Free
 * 
 * [Font Awesome Free 6 by @fontawesome](https://fontawesome.com/)
 * 
 * Font Awesome Free is free, open source, and GPL friendly. You can use it for commercial projects, open source projects,
 * or really almost whatever you want.
 * 
 * [Full Font Awesome Free license](https://fontawesome.com/license/free)
 * 
 * ## Roboto font
 * 
 * [Apache License Version 2.0, January 2004](https://www.apache.org/licenses/LICENSE-2.0)
 * 
 * TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 * 
 * 1. Definitions.
 * 
 * "License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9
 * of this document.
 * 
 * "Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.
 * 
 * "Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are
 * under common control with that entity. For the purposes of this definition,
 * "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by
 * contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial
 * ownership of such entity.
 * 
 * "You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.
 * 
 * "Source" form shall mean the preferred form for making modifications, including but not limited to software source code,
 * documentation source, and configuration files.
 * 
 * "Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including
 * but not limited to compiled object code, generated documentation, and conversions to other media types.
 * 
 * "Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as
 * indicated by a copyright notice that is included in or attached to the work
 * (an example is provided in the Appendix below).
 * 
 * "Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work
 * and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an
 * original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain
 * separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.
 * 
 * "Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or
 * additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the
 * Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner.
 * For the purposes of this definition, "submitted"
 * means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including
 * but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems
 * that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding
 * communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a
 * Contribution."
 * 
 * "Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received
 * by Licensor and subsequently incorporated within the Work.
 * 
 * 2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to
 *    You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce,
 *    prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such
 *    Derivative Works in Source or Object form.
 * 
 * 3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a
 *    perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *    (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise
 *    transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are
 *    necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s)
 *    with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (
 *    including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within
 *    the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this
 *    License for that Work shall terminate as of the date such litigation is filed.
 * 
 * 4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with
 *    or without modifications, and in Source or Object form, provided that You meet the following conditions:
 * 
 * (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and
 * 
 * (b) You must cause any modified files to carry prominent notices stating that You changed the files; and
 * 
 * (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark,
 * and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the
 * Derivative Works; and
 * 
 * (d) If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute
 * must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that
 * do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file
 * distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the
 * Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices
 * normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You
 * may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the
 * NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the
 * License.
 * 
 * You may add Your own copyright statement to Your modifications and may provide additional or different license terms and
 * conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole,
 * provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this
 * License.
 * 
 * 5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for
 *    inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any
 *    additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any
 *    separate license agreement you may have executed with Licensor regarding such Contributions.
 * 
 * 6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product
 *    names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and
 *    reproducing the content of the NOTICE file.
 * 
 * 7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and
 *    each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 *    either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT,
 *    MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness
 *    of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this
 *    License.
 * 
 * 8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or
 *    otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing,
 *    shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or
 *    consequential damages of any character arising as a result of this License or out of the use or inability to use the
 *    Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or
 *    any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such
 *    damages.
 * 
 * 9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose
 *    to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or
 *    rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and
 *    on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and
 *    hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason
 *    of your accepting any such warranty or additional liability.
 * 
 * END OF TERMS AND CONDITIONS
 * 
 * APPENDIX: How to apply the Apache License to your work.
 * 
 * To apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by
 * brackets "[]"
 * replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the
 * appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose
 * be included on the same "printed page" as the copyright notice for easier identification within third-party archives.
 * 
 * Copyright [yyyy] [name of copyright owner]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 * [APACHE LICENSE, VERSION 2.0](http://www.apache.org/licenses/LICENSE-2.0)
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "
 * AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * ## Styling Cross-Browser Compatible Range Inputs with Sass
 * 
 * Github: [input-range-sass](https://github.com/darlanrod/input-range-sass)
 * 
 * Author: [Darlan Rod](https://github.com/darlanrod)
 * 
 * Version 1.4.1
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 Darlan Rod
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Tree Walker polyfill
 * 
 * The MIT License (MIT)
 * 
 * [Copyright 2013–2017 Timo Tijhof](https://github.com/Krinkle/dom-TreeWalker-polyfill)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## chronograph
 * 
 * GitHub: [chronograph](https://github.com/bryntum/chronograph)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2023 Bryntum
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## later.js
 * 
 * GitHub: [later.js](https://github.com/bunkat/later)
 * 
 * The MIT License (MIT)
 * 
 * Copyright © 2013 BunKat
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Monaco editor
 * 
 * GitHub: [Monaco editor](https://microsoft.github.io/monaco-editor) (MIT)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 - present Microsoft Corporation
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Map/Set polyfill to fix performance issues for Salesforce LWS
 * 
 * Copyright © 2024 Certinia Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 * ## Chart.js
 * 
 * GitHub: [Chart.js](https://github.com/chartjs/Chart.js)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014-2022 Chart.js Contributors
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).bryntum=e.bryntum||{},e.bryntum.schedulerpro={}))}(this,(function(e){"use strict";const t="schedulerpro",n=Object.create(null),i=["Array","Browser",["Css","CSSHelper"],"Date","Dom","Event","Function","Object","String","TimeZone","Version"].map((e=>Array.isArray(e)?e:[e,`${e}Helper`])),r=e=>Object.assign(Object.create(null),Object.fromEntries(e)),s=r(i),o=r(i.map((([e,t])=>[t,e]))),a=e=>(t,n)=>{throw new Error(`Cannot ${e} "Helpers.${n}": object is readonly`)},l=new Proxy(n,{defineProperty:a("define property"),deleteProperty:a("delete"),set:a("assign"),get(e,t){const i=n[t];if(!i)throw new Error(`Property not defined "Helpers.${t}": ${t in s?`import ${s[t]} before using it`:"invalid helper name"}`);return i}});var c;Object.defineProperty(n,"register",{value(e){const t=e.$name,i=o[t];n[i]=e}}),i.forEach((e=>n[e[0]]=null)),(globalThis.bryntum||(globalThis.bryntum={})).Helpers=l;class d{static $name="BrowserHelper";static supportsPointerEvents=Boolean(globalThis.PointerEvent||globalThis.MSPointerEvent);static supportsPointerEventConstructor="undefined"!=typeof PointerEvent;static PointerEventConstructor=globalThis.PointerEvent||globalThis.CustomEvent;static isPhone=null===(c=globalThis.matchMedia)||void 0===c?void 0:c.call(globalThis,"(max-height:414px) or (max-width:414px)").matches;static cacheFlags(e=navigator.platform,t=navigator.userAgent){const n=this;n._isLinux=Boolean(e.match(/Linux/)),n._isMac=Boolean(e.match(/Mac/)),n._isWindows=Boolean(e.match(/Win32/)),n._isMobile=Boolean(t.match(/Mobile|Opera Mini|Opera Mobi|Puffin/)||"number"==typeof globalThis.orientation),n._isWebkit=Boolean(t.match(/WebKit/)&&!t.match(/Edg/)),n._firefoxVersion=n.getVersion(t,/Firefox\/(\d+)\./),n._isFirefox=n._firefoxVersion>0,n._chromeVersion=n.getVersion(t,/Chrom(?:e|ium)\/(\d+)\./),n._isChrome=n._chromeVersion>0,n._isSafari=Boolean(t.match(/Safari/))&&!n._isChrome,n._isMobileSafari=n._isSafari&&n.isMobile,n._safariVersion=n.getVersion(t,/Version\/(.*).Safari/),n._isAndroid=Boolean(t.match(/Android/g))}static get supportsOverflowClip(){if(null==this._supportsOverflowClip){const e=document.createElement("div");e.style.overflow="clip",e.style.display="none",document.documentElement.appendChild(e),this._supportsOverflowClip="clip"===e.ownerDocument.defaultView.getComputedStyle(e).getPropertyValue("overflow"),e.remove()}return this._supportsOverflowClip}static get supportsSticky(){return!0}static getVersion(e,t){const n=e.match(t);return n?parseFloat(n[1]):0}static get isTouchDevice(){return void 0===this._isTouchDevice&&(this._isTouchDevice=globalThis.matchMedia("(any-pointer:coarse)").matches),this._isTouchDevice}static get isHoverableDevice(){return void 0===this._isHoverableDevice&&(this._isHoverableDevice=globalThis.matchMedia("(any-hover: hover)").matches),this._isHoverableDevice}static get isBrowserEnv(){return"undefined"!=typeof window}static get isMac(){return this._isMac}static get isWindows(){return this._isWindows}static get isLinux(){return this._isLinux}static get isAndroid(){return this._isAndroid}static get isWebkit(){return this._isWebkit}static get isChrome(){return this._isChrome}static get chromeVersion(){return this._chromeVersion}static get isFirefox(){return this._isFirefox}static get firefoxVersion(){return this._firefoxVersion}static get isSafari(){return this._isSafari}static get safariVersion(){return this._safariVersion}static get isMobileSafari(){return this._isMobileSafari}static get isMobile(){return this._isMobile}static get platform(){const e=this;return e._isLinux?"linux":e._isMac?"mac":e._isWindows?"windows":e._isAndroid?"android":e._isMobileSafari?"ios":null}static get supportsRandomUUID(){if(void 0===this._supportsRandomUUID)try{var e,t;this._supportsRandomUUID=Boolean((null===(e=(t=globalThis.crypto).randomUUID)||void 0===e?void 0:e.call(t).length)>0)}catch(e){this._supportsRandomUUID=!1}return this._supportsRandomUUID}static get storageAvailable(){let e,t;try{return e=localStorage,t="__storage_test__",e.setItem(t,t),e.removeItem(t),!0}catch(t){return t instanceof DOMException&&(22===t.code||1014===t.code||"QuotaExceededError"===t.name||"NS_ERROR_DOM_QUOTA_REACHED"===t.name)&&0!==e.length}}static setLocalStorageItem(e,t){this.storageAvailable&&localStorage.setItem(e,t)}static getLocalStorageItem(e){return this.storageAvailable&&localStorage.getItem(e)}static removeLocalStorageItem(e){this.storageAvailable&&localStorage.removeItem(e)}static get ctrlKey(){return this.isMac?"metaKey":"ctrlKey"}static get metaKey(){return this.isMac?"ctrlKey":"metaKey"}static searchParam(e,t=null,n=document.location.search){const i=new RegExp(`[?&]${e}=?([^&]*)`),r=n.match(i);return r&&r[1]||t}static getCookie(e){const t=encodeURIComponent(e)+"=",n=document.cookie.split(";");for(let e=0;e<n.length;e++){let i=n[e];for(;" "===i.charAt(0);)i=i.substring(1,i.length);if(0===i.indexOf(t))return decodeURIComponent(i.substring(t.length,i.length))}return""}static download(e,t){const n=document.createElement("a");n.download=e,n.href=t||e,n.style.cssText="display:none",document.body.appendChild(n),n.click(),document.body.removeChild(n)}static downloadBlob(e,t){const n=globalThis.URL.createObjectURL(e);this.download(t,n),globalThis.URL.revokeObjectURL(n)}static get queryString(){var e;const t=new URL(globalThis.location.href).searchParams;return null===(e=Object.fromEntries)||void 0===e?void 0:e.call(Object,t.entries())}static copyToClipboard(e){let t=!0;const n=document.createElement("textarea");n.value=e,n.style.height=n.style.width=0,document.body.appendChild(n),n.select();try{document.execCommand("copy")}catch(e){t=!1}return n.remove(),t}static isBryntumOnline(e){var t;return e=Array.isArray(e)?e:[e],Boolean(/^(www\.)?bryntum\.com$/.test(globalThis.location.host)||(null===(t=e)||void 0===t?void 0:t.some((e=>null!=this.queryString[e]))))}static get isCSP(){const{bryntum:e,document:t}=globalThis;return null==e.CSP&&(e.CSP=Boolean(t.querySelector('meta[http-equiv="Content-Security-Policy"]'))),e.CSP}}l.register(d),d.isBrowserEnv&&d.cacheFlags(),d._$name="BrowserHelper";const{hasOwnProperty:u,propertyIsEnumerable:h,toString:g}=Object.prototype,{isFrozen:m}=Object,p=/\s*<\s*/,f=/\s*>\s*/,v={},y={},b=Object.freeze({});class C{static assign(e,...t){for(let n,i,r=0;r<t.length;r++)if(n=t[r],n)for(i in n)"__proto__"!==i&&"constructor"!==i&&(e[i]=n[i]);return e}static assignIf(e,...t){for(let n,i,r=0;r<t.length;r++)if(n=t[r],n)for(i in n)"__proto__"!==i&&"constructor"!==i&&(i in e&&void 0!==e[i]||(e[i]=n[i]));return e}static blend(e,t,n){n=n||v,e=e||{};const{clone:i=C.clone,merge:r=C.blend}=n;if(Array.isArray(t)){if(t.length>1)return t.forEach((t=>{e=C.blend(e,t,n)})),e;t=t[0]}if(t){let s,o,a;for(o in t)"__proto__"!==o&&"constructor"!==o&&(a=t[o],a&&C.isObject(a)&&(s=e[o],n.key=o,s&&C.isObject(s)?(m(s)&&(e[o]=s=i(s,n)),a=r(s,a,n)):a=m(a)?a:i(a,n)),e[o]=a)}return e}static clone(e,t){let n,i=e;if(e&&"object"==typeof e&&!(e instanceof Event)){if(t&&"object"==typeof t&&t&&(t=null),C.isObject(e))if(e.skipClone)i=e;else for(n in i={},e)"__proto__"!==n&&"constructor"!==n&&(i[n]=C.clone(e[n]));else if(Array.isArray(e))for(i=[],n=e.length;n-- >0;)i[n]=C.clone(e[n]);else C.isDate(e)?i=new Date(e.getTime()):t&&(i=t(e))}return i}static mergeUniformObjects(e,...t){for(const n of t)for(const t in n)if("__proto__"!==t&&"constructor"!==t){const i=n[t];i&&(this.isObject(i)?this.mergeUniformObjects(e[t]||(e[t]={}),i):Array.isArray(i)?(t in e||(e[t]=[]),this.mergeArrayOfIdentityObjects(e[t],i)):e[t]=this.clone(i))}return e}static mergeArrayOfIdentityObjects(e,t){for(const n of t)if(this.isObject(n)){const t=e.find((e=>e.id===n.id));t?this.mergeUniformObjects(t,n):e.push(this.clone(n))}else e.push(n)}static createTruthyKeys(e){const t=V.split(e),n=t&&{};if(t)for(const e of t)e&&(n[e]=!0);return n}static getPath(e,t){return t.split(".").reduce(((e,t)=>(e||b)[t]),e)}static getPathDefault(e,t,n){const i=Array.isArray(t)?t:"string"==typeof t?t.split("."):[t],r=i.length-1;return i.reduce(((e,t,i)=>(n&&!(t in e)&&(e[t]=i===r?n:{}),(e||b)[t])),e)}static getPropertyDescriptor(e,t){let n=null;for(let i=e;i&&!n&&!C.hasOwn(i,"isBase");i=Object.getPrototypeOf(i))n=Object.getOwnPropertyDescriptor(i,t);return n}static hasPath(e,t){return t.split(".").every((t=>!(!e||!(t in e))&&(e=e[t],!0)))}static getTruthyKeys(e){let t;if("string"==typeof e)t=[e];else if(Array.isArray(e))t=e.slice();else if(t=[],e)for(const n in e)e[n]&&t.push(n);return t}static getTruthyValues(e){const t=[];if(e)for(const n in e)e[n]&&t.push(e[n]);return t}static isClass(e){var t;return"function"==typeof e&&(null===(t=e.prototype)||void 0===t?void 0:t.constructor)===e}static isDate(e){return Boolean(null==e?void 0:e.getUTCDate)&&"date"===C.typeOf(e)}static isPromise(e){if(null!=Promise&&Promise.resolve)return Promise.resolve(e)===e||"function"==typeof(null==e?void 0:e.then);throw new Error("Promise not supported in your environment")}static isEmpty(e){if(e&&"object"==typeof e)for(const t in e)return!1;return!0}static isObject(e){const t=null==e?void 0:e.constructor;return Boolean(!t||"function"!=typeof t||C.hasOwn(e,"constructor")||h.call(e,"constructor")?e&&"object"==typeof e:(t===Object||t.getPrototypeOf&&t.prototype&&!Object.getPrototypeOf(t.prototype))&&e!==globalThis)}static isInstantiated(e){return!!e&&("object"==typeof e&&!C.isObject(e))}static merge(e,...t){return C.blend(e,t)}static mergeItems(e,t,n){let i,r,s,o,a,l,c;n=n||v;const{merge:d=C.blend}=n;if(e=e||{},Array.isArray(t))t.forEach((t=>{e=C.mergeItems(e,t,n)}));else if(t)for(a in t)if("__proto__"!==a&&"constructor"!==a)if(c=t[a],i=null,a.includes(">")?([a,i]=a.split(f),r=0):a.includes("<")&&([i,a]=a.split(p),r=1),a in e)c&&e[a]&&d&&(n.key=a,c=d(e[a],c,n)),e[a]=c;else if(i){if(!o){o=new Map,s=0;for(const t in e)o.set(t,s++)}if(s=o.get(i),e[a]=c,null==s&&r)s=o.size;else{l=l||[],s=(s||0)+r;for(const e of o){const[t,n]=e;s<=n&&(l&&(l[o.size-n-1]=t),o.set(t,n+1))}if(l)for(;l.length;){const t=l.pop(),n=e[t];delete e[t],e[t]=n}}o.set(a,s)}else{var u;e[a]=c,null===(u=o)||void 0===u||u.set(a,o.size)}return e}static setPath(e,t,n){return t.split(".").reduce(((e,t,i,r)=>i===r.length-1?e[t]=n:(e[t]instanceof Object||(e[t]={}),e[t])),e),e}static typeOf(e){let t,n;return null===e?n="null":e!=e?n="nan":(n=typeof e,"object"===n?e.isBase?n="instance":Array.isArray(e)?n="array":(n=y[t=g.call(e)])||(y[t]=n=t.slice(8,-1).toLowerCase()):"function"===n&&e.isBase&&(n="class")),n}}let S,w,D,E;Object.defineProperty(C,"hasOwn",{value:Object.hasOwn||((e,t)=>u.call(e,t))}),C._$name="Objects";const x=/([a-z])([A-Z])/g,R=/[\n\r]/g,T=/[.*+?^${}()|[\]\\]/g,M=/[&<]/,I=/(^[^a-z]+[^\w]+)/gi,k=/\s+/,F=/^[^a-z]+|[^\w:.-]+/gi,A=(e,t)=>w[t.toLowerCase()]||String.fromCharCode(parseInt(t.substr(2),10)),P=(e,t)=>S[t],L=(e,t,n)=>`${t}-${n.toLowerCase()}`,O=(e,t,n)=>`${t} ${n.toLowerCase()}`,$=e=>e?`_x${[...e].map((e=>e.charCodeAt(0).toString(16))).join("")}`:"__blank__",_={},j={},B=[];class V{static $name="StringHelper";static circularReplacer(e,t){if(null!=t&&t.isBase)return t.id;if(t&&"object"==typeof t){for(;B.length&&B[B.length-1]!==this;)B.pop();if(B.includes(t))return"[Circular]";B.push(t)}return t}static capitalize(e){return e&&e[0].toUpperCase()+e.substr(1)}static uncapitalize(e){return e&&e[0].toLowerCase()+e.substr(1)}static hyphenate(e){const t=_[e];return t||(_[e]=e.replace(x,L))}static hyphenateAttributeName(e){return/^(data|aria)[A-Z]/.test(e)?e.replace(/^(data|aria)([A-Z])/,((e,t,n)=>`${t}-${n}`)).replace(/([a-z0-9])([A-Z])/g,"$1-$2").toLowerCase():e}static separate(e){const t=j[e];return t||(j[e]=this.capitalize(e.replace(x,O)))}static createId(e){return String(e).replace(I,$)}static makeValidDomId(e,t=""){return null==e?null:String(e).replace(F,t)}static escapeRegExp(e,t){let n=e.replace(T,"\\$&");return void 0!==t&&(n=new RegExp(n,t)),n}static decodeHtml(e){return e&&String(e).replace(E,A)}static encodeHtml(e=""){return e&&String(e).replace(D,P)}static encodeHtmlBR(e){var t;return null===(t=V.encodeHtml(e))||void 0===t?void 0:t.replace(R,"<br>")}static isHtml(e){return"string"==typeof e&&M.test(e||"")}static initHtmlEntities(e){e=e||{"&":"&amp;",">":"&gt;","<":"&lt;",'"':"&quot;","'":"&#39;"};const t=Object.keys(e);S=e,w=t.reduce(((t,n)=>(t[e[n]]=n,t)),{}),D=new RegExp(`([${t.map((e=>"[-]".includes(e)?"\\"+e:e)).join("")}])`,"g"),E=new RegExp(`(${Object.values(e).join("|")}|&#[0-9]+;)`,"ig")}static safeJsonParse(e){let t=null;try{t=JSON.parse(e)}catch(e){}return t}static safeJsonStringify(e,t=null,n=null){let i=null;try{"circular"===t&&(B.length=0,t=this.circularReplacer),i=JSON.stringify(e,t,n)}catch{}return i}static joinPaths(e,t="/"){return e.join(t).replace(new RegExp("\\"+t+"+","g"),t)}static split(e,t=k){let n=e;return"string"==typeof n&&(n=e.trim(),n=n?n.split(t):[]),n}static xss(e,...t){const n=[];let i=t.length;for(n[i]=e[i];i-- >0;)n[i]=e[i]+V.encodeHtml(t[i]);return n.join("")}static xssBR(e,...t){const n=[];let i=t.length;for(n[i]=e[i];i-- >0;)n[i]=e[i]+V.encodeHtmlBR(t[i]);return n.join("")}static toJavaScriptValue(e,t){const n=C.typeOf(e);if("boolean"===n||"string"===n||"number"===n||null===e)return V.safeJsonStringify(e);if(e===globalThis)return"window";if("date"===n)return`new Date(${e.getFullYear()}, ${e.getMonth()}, ${e.getDate()}, ${e.getHours()}, ${e.getMinutes()}, ${e.getSeconds()}, ${e.getMilliseconds()})`;if("array"===n)return`[${e.map((e=>V.toJavaScriptValue(e,t)))}]`;if("object"===n||"instance"===n)return this.toJavaScriptString(e,t);if("function"===n){let t=e.toString();return t.match(/^async (\w+?)\(/)?t=t.replace(/^async (\w+?)\(/,"async function("):!t.startsWith("async(")&&t.match(/^(\w+?)\(/)&&(t=t.replace(/^(\w+?)\(/,"function(")),t}return"class"===n?e.toJavaScriptValue?e.toJavaScriptValue(t):Object.prototype.hasOwnProperty.call(e,"$name")?e.$name:e.name:void 0}static toJavaScriptString(e,t={}){const n=t.level??0;return"{\n"+Object.keys(e).map((i=>" ".repeat(2*(n+1))+(i.match(/[- *]/)?`"${i}"`:i)+`: ${V.toJavaScriptValue(e[i],{...t,level:n+1})}`)).join(",\n")+"\n"+" ".repeat(2*n)+"}"}static encodeAttributeSelector(e,t){return`[${e}="${String(t).replace(/["\\]/g,"\\$&")}"]`}static fakeNodeUUIDIndex=0;static generateUUID(){var e;return d.supportsRandomUUID?globalThis.crypto.randomUUID():null!==(e=globalThis.crypto)&&void 0!==e&&e.getRandomValues?([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g,(e=>(e^globalThis.crypto.getRandomValues(new Uint8Array(1))[0]&15>>e/4).toString(16))):`${Date.now()}-${++V.fakeNodeUUIDIndex}`}}V.initHtmlEntities(),l.register(V),V._$name="StringHelper";const H=Object.freeze([]),{hasOwn:z}=C,N="1.01"===1.005.toFixed(2)?null:(e,t)=>{const n=e.toString().split("."),i=+(n[1]?n.join(".")+"1":n[0]);return e.toFixed.call(i,t)},W=(e,t,n,i=[])=>{if(!e||!C.isObject(e)&&!Array.isArray(e))return e;if(n.has(e))return n.get(e);const r=new Proxy(e,{get:(e,r,s)=>W(Reflect.get(e,r,s),t,n,i.concat(r)),set(e,r,s,o){const a=e[r],l=Reflect.set(e,r,W(s,t,n,i.concat(r)),o);return l&&a!==s&&t({oldValue:a,path:i.concat(r),newValue:s}),l},deleteProperty(e,n){const r=e[n],s=Reflect.deleteProperty(e,n);return s&&t({oldValue:r,path:i.concat(n),deleted:!0}),s}});return n.set(e,r),r};class U extends C{static $name="ObjectHelper";static observeObject(e,t){return W(e,t,new WeakMap)}static filter(e,t){let n,i,r,s,o=null;if(e)for(i of(o=Object.getPrototypeOf(e)?{}:Object.create(null),r=Array.isArray(e)?e:[e],r))for(n in i)t(s=i[n],n,i)&&(o[n]=s);return o}static forEach(e,t){let n;if(e)if(Array.isArray(e))e.forEach(t);else for(n in e)t(e[n],n)}static transformArrayToNamedObject(e,t="ref"){const n={};return e.forEach(((e,i)=>{const r=null!=e[t]&&e[t].toString().length?e[t]:i;n[r]=e})),n}static transformNamedObjectToArray(e,t="ref"){return Object.keys(e).filter((t=>e[t])).map((n=>{const i=e[n];return i[t]=n,i}))}static isEqual(e,t,n=!1,i=!1){if(e===t)return!0;if(null==e||null==t)return i&&e==t;if(e.isModel&&t.isModel)return e.equals(t);if(e.isBase||t.isBase)return!1;const r=Array.isArray(e)+Array.isArray(t);if(r)return 2===r&&e.length===t.length&&e.every(((e,i)=>G.isEqual(e,t[i],n)));if(e instanceof Date&&t instanceof Date)return e.getTime()===t.getTime();const s=typeof e;return s===typeof t&&"object"===s&&e.constructor.prototype===t.constructor.prototype?n?G.isDeeplyEqual(e,t,n):l.String.safeJsonStringify(e,"circular")===l.String.safeJsonStringify(t,"circular"):String(e)===String(t)}static isDeeplyEqual(e,t,n={}){if(e===t)return!0;if(!e||!t)return!1;const i=G.keys(e,n.ignore),r=G.keys(t,n.ignore);if(i.length!==r.length)return!1;for(let s=0;s<i.length;s++){const o=i[s],a=r[s];if(o!==a)return!1;const l=e[o],c=t[a];if(!n.shouldEvaluate||!1!==n.shouldEvaluate(o,{value:l,object:e},{value:c,object:t})){if(n.evaluate){const i=n.evaluate(o,{value:l,object:e},{value:c,object:t});if(!1===i)return!1;if(!0===i)continue}if(!G.isEqual(l,c,n))return!1}}return!0}static isPartial(e,t){return e=String(e).toLowerCase(),t=String(t).toLowerCase(),-1!==e.indexOf(t)}static isLessThan(e,t){return e instanceof Date&&t instanceof Date?l.Date.isBefore(e,t):e<t}static isMoreThan(e,t){return e instanceof Date&&t instanceof Date?l.Date.isAfter(e,t):e>t}static first(e,t){let n,i=t;if(e)if(e[Symbol.iterator])for(i of e)break;else if(e[Symbol.asyncIterator])i=(async(e,t)=>{let n=t;for await(n of e)break;return n})(e,t);else if(U.isObject(e))for(n in void 0===i&&(i=H),e){i=[n,e[n]];break}return i}static fork(e){let t,n,i;if(e&&e.constructor===Object)for(n in t=Object.create(e),e)i=e[n],i&&(i.constructor===Object?t[n]=G.fork(i):i instanceof Array&&(t[n]=i.slice()));else t=e;return t}static copyProperties(e,t,n){let i,r;for(r=0;r<n.length;r++)i=n[r],i in t&&(e[i]=t[i]);return e}static copyPropertiesIf(e,t,n){if(t)for(const i of n)!(i in e)&&i in t&&(e[i]=t[i]);return e}static copyPropertiesExcept(e,t,n){if(t)for(const i in t)null!=n&&n[i]||(e[i]=t[i]);return e}static entries(e,t){const n=[],i="function"==typeof t;if(e)for(const r in e)(i?t(r,e[r]):null!=t&&t[r])||n.push([r,e[r]]);return n}static fromEntries(e,t){if(t=t||{},e)for(let n=0;n<e.length;++n)t[e[n][0]]=e[n][1];return t}static keys(e,t,n){const i=[],r="function"==typeof t;if(e){let s=0;for(const o in e)(r?t(o,e[o]):null!=t&&t[o])||(i.push(n?n(o,s):o),++s)}return i}static values(e,t,n){const i=[],r="function"==typeof t;if(e){let s=0;for(const o in e)(r?t(o,e[o]):null!=t&&t[o])||(i.push(n?n(e[o],s):e[o]),++s)}return i}static pathExists(e,t){return t.split(".").every((t=>!(!e||!(t in e))&&(e=e[t],!0)))}static pathifyKeys(e,t){const n={};for(const i in e)if(z(e,i)){const r=null==t?void 0:t[i],s="object"===(null==r?void 0:r.type)||(null==r?void 0:r.complexMapping)||!Boolean(t);if(s&&Array.isArray(e[i]))n[i]=e[i].slice();else if(s&&e[i]instanceof Object){const t=this.pathifyKeys(e[i]);for(const e in t)n[`${i}.${e}`]=t[e]}else n[i]=e[i]}return n}static deletePath(e,t){t.split(".").reduce(((e,t,n,i)=>{if(null==e)return null;if(z(e,t)){if(n!==i.length-1)return e[t];delete e[t]}}),e)}static coerce(e,t){const n=C.typeOf(e),i=C.typeOf(t),r="string"==typeof e;if(n!==i)switch(i){case"string":return String(e);case"number":return Number(e);case"boolean":return!(r&&(!e||"false"===e||"0"===e))&&Boolean(e);case"null":return!(!r||e&&"null"!==e)&&null;case"undefined":return!(!r||e&&"undefined"!==e)&&void 0;case"date":return r&&isNaN(e)?l.Date.parse(e):Date(Number(e))}return e}static wrapProperty(e,t,n,i,r=!0){const s={};let o=Object.getPrototypeOf(e),a=Object.getOwnPropertyDescriptor(o,t);for(;!a&&o&&r;)o=Object.getPrototypeOf(o),o&&(a=Object.getOwnPropertyDescriptor(o,t));a?(a.set?s.set=t=>{a.set.call(e,t),i&&i.call(e,a.get.call(e))}:s.set=i,a.get?s.get=()=>{let t=a.get.call(e);return n&&(t=n.call(e,t)),t}:s.get=n):(s.set=n=>{e[`_${t}`]=n,i&&i.call(e,n)},s.get=()=>{let i=e[`_${t}`];return n&&(i=n.call(e,i)),i}),Object.defineProperty(e,t,s)}static hookProperty(e,t,n){const i=U.getPropertyDescriptor(n.prototype,"value"),r=U.getPropertyDescriptor(e,t),s=`_${t}`,o=class{get value(){return r?r.get.call(this):this[s]}set value(e){r?r.set.call(this,e):this[s]=e}},a=U.getPropertyDescriptor(o.prototype,"value");return Object.setPrototypeOf(n.prototype,o.prototype),Object.defineProperty(e,t,{configurable:!0,get:i.get||a.get,set:i.set||a.set}),()=>delete e[t]}static cleanupProperties(e,t=!1){return Object.entries(e).forEach((([n,i])=>{t?void 0===i&&delete e[n]:null==i&&delete e[n]})),e}static removeAllProperties(e){return Object.keys(e).forEach((t=>delete e[t])),e}static assertType(e,t,n){const i=C.typeOf(e);if(null!=e&&i!==t)throw new Error(`Incorrect type "${i}" for ${n}, expected "${t}"`)}static assertObject(e,t){G.assertType(e,"object",t)}static assertInstance(e,t){G.assertType(e,"instance",t)}static assertClass(e,t){G.assertType(e,"class",t)}static assertFunction(e,t){if("function"!=typeof e||e.isBase||e.$$name)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a function)`)}static assertNumber(e,t,n){const i=Number(e);if("number"!=typeof e||isNaN(i)||n&&e<0)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a ${n?"positive ":""}Number)`)}static assertBoolean(e,t){G.assertType(e,"boolean",t)}static assertString(e,t){G.assertType(e,"string",t)}static assertArray(e,t){G.assertType(e,"array",t)}static toFixed(e,t){return N?N(e,t):e.toFixed(t)}static roundTo(e,t=1){return Math.round(e/t)*t}static round(e,t){if(null==t)return e;const n=10**t;return Math.round(e*n)/n}static getMapPath(e,t,n){const i=Array.isArray(t)?t:"string"==typeof t?t.split("."):[t],r=1===i.length,s=i[0],o=e.has(s)?e.get(s):e.set(s,r?n:{}).get(s);return r?o:G.getPathDefault(o,i.slice(1),n)}}l.register(U);const G=U;U._$name="ObjectHelper";class q{static $name="VersionHelper";static setVersion(e,n){e=e.toLowerCase(),Y[e]={version:n,isNewerThan:e=>q.semanticCompareVersion(e,n,"<"),isOlderThan:e=>q.semanticCompareVersion(e,n,">")};let i="";i=`${t}.`;const r=`${i}${e}${n.replace(/\./g,"-")}`;if(d.isBrowserEnv&&!globalThis.bryntum.silenceBundleException)if(!0===globalThis.bryntum[r]){if(!this.isTestEnv){let t=i||e;"core"===t&&(t="grid");let n=V.capitalize(t);throw"schedulerpro"===t&&(n="SchedulerPro"),new Error(`The Bryntum ${n} bundle was loaded multiple times by the application.\n\nCommon reasons you are getting this error includes:\n\n* Imports point to different types of the bundle (e.g. *.module.js and *.umd.js)\n* Imports point to both sources and bundle\n* Imports do not use the shortest relative path, JS treats them as different files\n* Cache busters differ between imports, JS treats ${t}.module.js?1 and ${t}.module.js?2 as different files\n* Imports missing file type, verify they all end in .js\n\nSee https://bryntum.com/products/${t}/docs/guide/${n}/gettingstarted/es6bundle#troubleshooting for more information\n\n`)}globalThis.BUNDLE_EXCEPTION=!0}else globalThis.bryntum[r]=!0}static getVersion(e){if(e=e.toLowerCase(),!Y[e])throw new Error([`No version specified for the "${e}" product!`,"Please check that you import VersionHelper correctly into the class from where you call `deprecate` function."].join("\n"));return Y[e].version}static semanticCompareVersion(e,t,n="="){t=t||"";const i=(e=e||"").split(/[-.]/),r=t.split(/[-.]/),s=n.includes("<"),o=(e,t)=>{const n=["rc","beta","alpha"],i=e.map((e=>{if(n.includes(e))return-n.indexOf(e)-2;const t=Number.parseInt(e);return Number.isNaN(t)?-n.length:t}));for(;i.length<t;)i.push(-1);return i},a=()=>{const e=Math.max(i.length,r.length),t=o(i,e),n=o(r,e);for(let i=0;i<e;i++)if(t[i]!==n[i])return s?t[i]<n[i]:t[i]>n[i];return!0};switch(n){case"=":return e===t;case"<=":case">=":return e===t||a();case"<":case">":return e!==t&&a()}return!1}static checkVersion(e,t,n){return q.semanticCompareVersion(Y.getVersion(e),t,n)}static deprecate(e,t,n){if(!Y.checkVersion(e,t,"<"))throw new Error(`Deprecated API use. ${n}`);console.warn(`Deprecation warning: You are using a deprecated API which will change in v${t}. ${n}`)}static get isTestEnv(){var e;const t=Boolean(null===(e=globalThis.bryntum)||void 0===e?void 0:e.isTestEnv);try{var n;return t||Boolean(null===(n=globalThis.parent)||void 0===n||null===(n=n.bryntum)||void 0===n?void 0:n.isTestEnv)}catch(e){return t}}static get isDebug(){return!1}}const Y=q;d.isBrowserEnv&&(Y.isTestEnv&&(d._isHoverableDevice=!0),globalThis.bryntum=Object.assign(globalThis.bryntum||{},{getVersion:Y.getVersion.bind(Y),checkVersion:Y.checkVersion.bind(Y),deprecate:Y.deprecate.bind(Y),license:"9c07f388-a9e9-11ec-9e5c-d094663d5c88"})),l.register(q),q._$name="VersionHelper";const K=/,\s*/,X=Symbol("decompiled"),Z=/^\s*(async\s+)?([a-z_]\w*)\s*=>([\s\S]+)$/i,J=/^\s*(async\s*)?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)\s+=>([\s\S]+)$/i,Q=/^(\s*async)?(?:\s*function)?(?:\s*([a-z_]\w*))?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)([\s\S]+)$/i,{hasOwnProperty:ee}=Object.prototype;class te{static $name="FunctionHelper";static after(e,t,n,i,r){const s="string"==typeof n,o=!1!==(null==r?void 0:r.return),a=(...t)=>{const r=a.$nextHook.call(e,...t),l=null!=i&&i.isDestroyed?void 0:o?s?i[n](r,...t):n.call(i,r,...t):s?i[n](...t):n.call(i,...t);return void 0===l?r:l};return te.hookMethod(e,t,a)}static before(e,t,n,i){const r="string"==typeof n,s=(...t)=>{const o=null!=i&&i.isDestroyed?0:r?i[n](...t):n.call(i,...t);return!1===o?o:s.$nextHook.call(e,...t)};return te.hookMethod(e,t,s)}static curry(e){return function t(...n){return n.length>=e.length?e.apply(this,n):function(...e){return t.apply(this,n.concat(e))}}}static bindAll(e){for(const t in e)"function"==typeof e[t]&&(e[t]=e[t].bind(e))}static createInterceptor(e,t,n){return function(...i){const r=n||this;return!1!==t.call(r,...i)&&e.call(r,...i)}}static createSequence(e,t,n,i){return function(...r){const s=e.call(n=n||this,...r),o=t.call(i||n,...r);return void 0===o?s:o}}static createThrottled(e,t,n,i,r){let s,o,a=-Number.MAX_VALUE;const l=()=>{o=0,a=performance.now(),s.push.apply(s,i),e.apply(n,s)},c=function(...e){const c=performance.now()-a;s=e,c>=t?(clearTimeout(o),l()):(o||(o=setTimeout(l,t-c)),r&&(s.push.apply(s,i),r.apply(n,s)))};return c.cancel=()=>clearTimeout(o),c}static createBuffered(e,t,n,i){let r,s;const o=()=>{s=0,a.isPending=!1,r.push.apply(r,i),e.apply(n,r)},a=function(...e){r=e,s&&clearTimeout(s),a.isPending=!0,s=setTimeout(o,t)};return a.cancel=()=>{a.isPending=!1,clearTimeout(s)},a}static decompile(e){if(!(X in e)){var t,n;const i=e.toString();let r,s,o,a,l,c=Z.exec(i);c?(r=[c[2]],s=c[3]):(c=J.exec(i))?(l=c[2].trim(),r=l?l.split(K):[],s=c[3]):(c=Q.exec(i))&&(o=c[2],l=c[3].trim(),r=l?l.split(K):[],s=c[4]),s=null===(t=s)||void 0===t?void 0:t.trim(),e[X]=a=c&&{args:r,async:Boolean(c[1]),body:null!==(n=s)&&void 0!==n&&n.startsWith("{")?s.substring(1,s.length-1).trim():s},o&&(a.name=o)}return e[X]}static hookMethod(e,t,n){return n.$nextHook=e[t],e[t]=n,()=>{if(ee.call(e,t)){let s,o=e[t];var i;if(o===n)(null===(i=Object.getPrototypeOf(e))||void 0===i?void 0:i[t])===n.$nextHook?delete e[t]:e[t]=n.$nextHook;else for(;s=null===(r=o)||void 0===r?void 0:r.$nextHook;o=s){var r;if(s===n){o.$nextHook=n.$nextHook;break}}}}}static noThrow(e,t,n){const i=e[t];e[t]=(...t)=>{try{return i.apply(e,t)}catch(e){return null==n?void 0:n(e)}}}static returnTrue(){return!0}static animate(e,t,n,i="linear"){let r=!1;const s=new Promise((s=>{const o=performance.now(),a=()=>{const l=Math.min((performance.now()-o)/e,1),c=null!=n&&n.setTimeout?n:globalThis;r||!1===t.call(n,this.easingFunctions[i](l))&&s(),r||1===l?c.requestAnimationFrame((()=>s())):c.requestAnimationFrame(a)};a()}));return s.cancel=()=>(r=!0,s.cancelled=!0,!1),s}static getAbortController(){return"undefined"==typeof AbortController?{abort:()=>{}}:AbortController}static abortablePromise(e,t){const n=(t=t||new(this.getAbortController())).signal;return{promise:new Promise(((t,i)=>{function r(){i(n.reason)}n.aborted?i(n.reason):(n.addEventListener("abort",r),e(((...e)=>{n.removeEventListener("abort",r),t(...e)}),((...e)=>{n.removeEventListener("abort",r),i(...e)}),n))})),controller:t}}}l.register(te);const ne=.5,ie=1.70158,re=7.5625,se=1.525,oe=2/2.75,ae=2.25/2.75,le=1/2.75,ce=1.5/2.75,de=2.5/2.75,ue=2.625/2.75,he=.75,ge=.9375,me=.984375;te.easingFunctions={linear:e=>e,easeInQuad:e=>Math.pow(e,2),easeOutQuad:e=>-(Math.pow(e-1,2)-1),easeInOutQuad:e=>(e/=ne)<1?ne*Math.pow(e,2):-.5*((e-=2)*e-2),easeInCubic:e=>Math.pow(e,3),easeOutCubic:e=>Math.pow(e-1,3)+1,easeInOutCubic:e=>(e/=ne)<1?ne*Math.pow(e,3):ne*(Math.pow(e-2,3)+2),easeInQuart:e=>Math.pow(e,4),easeOutQuart:e=>-(Math.pow(e-1,4)-1),easeInOutQuart:e=>(e/=ne)<1?ne*Math.pow(e,4):-.5*((e-=2)*Math.pow(e,3)-2),easeInQuint:e=>Math.pow(e,5),easeOutQuint:e=>Math.pow(e-1,5)+1,easeInOutQuint:e=>(e/=ne)<1?ne*Math.pow(e,5):ne*(Math.pow(e-2,5)+2),easeInSine:e=>1-Math.cos(e*(Math.PI/2)),easeOutSine:e=>Math.sin(e*(Math.PI/2)),easeInOutSine:e=>-.5*(Math.cos(Math.PI*e)-1),easeInExpo:e=>0===e?0:Math.pow(2,10*(e-1)),easeOutExpo:e=>1===e?1:1-Math.pow(2,-10*e),easeInOutExpo:e=>0===e?0:1===e?1:(e/=ne)<1?ne*Math.pow(2,10*(e-1)):ne*(2-Math.pow(2,-10*--e)),easeInCirc:e=>-(Math.sqrt(1-e*e)-1),easeOutCirc:e=>Math.sqrt(1-Math.pow(e-1,2)),easeInOutCirc:e=>(e/=ne)<1?-.5*(Math.sqrt(1-e*e)-1):ne*(Math.sqrt(1-(e-=2)*e)+1),easeOutBounce:e=>e<le?re*e*e:e<oe?re*(e-=ce)*e+he:e<de?re*(e-=ae)*e+ge:re*(e-=ue)*e+me,easeInBack:e=>e*e*((ie+1)*e-ie),easeOutBack:e=>(e-=1)*e*((ie+1)*e+ie)+1,easeInOutBack:e=>{let t=1.70158;return(e/=ne)<1?ne*(e*e*((1+(t*=se))*e-t)):ne*((e-=2)*e*((1+(t*=se))*e+t)+2)},elastic:e=>-1*Math.pow(4,-8*e)*Math.sin((6*e-1)*(2*Math.PI)/2)+1,swingFromTo:e=>{let t=1.70158;return(e/=ne)<1?ne*(e*e*((1+(t*=se))*e-t)):ne*((e-=2)*e*((1+(t*=se))*e+t)+2)},swingFrom:e=>e*e*((ie+1)*e-ie),swingTo:e=>(e-=1)*e*((ie+1)*e+ie)+1,bounce:e=>e<le?re*e*e:e<oe?re*(e-=ce)*e+he:e<de?re*(e-=ae)*e+ge:re*(e-=ue)*e+me,bouncePast:e=>e<le?re*e*e:e<oe?2-(re*(e-=ce)*e+he):e<de?2-(re*(e-=ae)*e+ge):2-(re*(e-=ue)*e+me),easeFromTo:e=>(e/=ne)<1?ne*Math.pow(e,4):-.5*((e-=2)*Math.pow(e,3)-2),easeFrom:e=>Math.pow(e,4),easeTo:e=>Math.pow(e,.25)},te._$name="FunctionHelper";const{defineProperty:pe,getOwnPropertyDescriptor:fe}=Reflect,{hasOwnProperty:ve,toString:ye}=Object.prototype,be=Symbol("instanceProperties"),Ce=Symbol("configuring"),Se=Symbol("lazyConfigValues"),we=ye.call(new Date),De=/\s+/,Ee=Object.hasOwn||((e,t)=>ve.call(e,t)),xe=(e,t)=>e===t||!(!e||!t||ye.call(e)!==we||ye.call(t)!==we)&&e.getTime()===t.getTime(),Re=(e,t)=>(e.setHours(0,0,0,0),t&&e.setDate(e.getDate()+t),e),Te={now:()=>new Date,today:()=>Re(new Date),tomorrow:()=>Re(new Date,1),yesterday:()=>Re(new Date,-1)},Me=(e,t)=>(e[t]=1,e),Ie=(e,t)=>function(){var n;return null===(n=this.configObserver)||void 0===n||n.get(e,this),t.call(this)};class ke{static get(e,t){const{cache:n}=this,i=n[e]||(n[e]=new ke(e));let r,s=i;return t&&(r=ke.makeCacheKey(e,t),(s=r&&n[r])||(s=i.extend(t),r&&(n[r]=s))),s}constructor(e){const t=this,n=e[0].toUpperCase()+e.substr(1);t.base=t,t.name=e,t.field="_"+e,t.capName=n,t.changer="change"+n,t.initializing="initializing"+n,t.updater="update"+n,t.updaterResult=`${e}Updated`}get descriptor(){let e=this._descriptor;return e&&Ee(this,"_descriptor")||(this._descriptor=e=this.makeDescriptor()),e}get initDescriptor(){let e=this._initDescriptor;return e&&Ee(this,"_initDescriptor")||(this._initDescriptor=e=this.makeInitter()),e}convert(e,t){return e}equal(e,t){return e===t}extend(e){const t=Object.assign(Object.create(this),e),{convert:n,equal:i,merge:r}=e,{convertMethods:s,equalityMethods:o}=ke;return"string"==typeof n&&!(t.convert=s[n])&&n.endsWith("[]")&&(t.convert=s[n]=ke.makeArrayConvert(s[n.slice(0,-2)])),"string"==typeof i&&!(t.equal=o[i])&&i.endsWith("[]")&&(t.equal=o[i]=ke.makeArrayEquals(o[i.slice(0,-2)])),"string"==typeof r&&(t.merge=ke.mergeMethods[r]),t}define(e){const{name:t}=this,n=fe(e,t);let i=this.descriptor;null!=n&&n.get&&(i=Object.assign({},i),i.get=Ie(t,n.get)),pe(e,t,i)}defineInitter(e,t){const n=this,{name:i}=n,r=e[be];let s,o;r[i]||!(o=fe(e,i))||"value"in o||(r[i]=o),pe(e,i,n.initDescriptor),n.lazy&&(s=e[Se]||(e[Se]=new Map),s.set(i,t))}static makeArrayConvert(e){return function(t,n){return null!=t&&(t=Array.isArray(t)?t.map(((t,i)=>e.call(this,t,n))):[e.call(this,t,n)]),t}}static makeArrayEquals(e){return(t,n)=>{let i,r=t&&n&&t.length===(i=n.length);if(r&&Array.isArray(t)&&Array.isArray(n))if(e)for(;r&&i-- >0;)r=e(t[i],n[i]);else for(;r&&i-- >0;)r=t[i]===n[i];else r=e?e(t,n):t===n;return r}}static makeCacheKey(e,t){const n=Object.keys(t).sort();for(let e,i,r,s=n.length;s-- >0;)if(r=t[e=n[s]],null==r&&!1===r)n.splice(s,1);else{if(i=typeof r,"function"===i)return null;"string"===i?n[s]=`${e}:"${r}"`:"number"===i&&(n[s]=`${e}:${r}`)}return n.length?`${e}>${n.join("|")}`:e}makeDescriptor(){const{base:e,field:t,changer:n,updater:i,name:r,updaterResult:s}=this;return e!==this?e.descriptor:{get(){var e;return null===(e=this.configObserver)||void 0===e||e.get(r,this),this[t]},set(e){const o=this,a=e,l=o.$meta.configs[r];let c,d,u=o[t];if("string"==typeof e){let t=e;var h;if(e.startsWith("up."))t=null===(h=o.owner)||void 0===h?void 0:h.resolveProperty(e.slice(3));else e.startsWith("this.")&&(t=o.resolveProperty(e.slice(5)));void 0!==t&&"function"!=typeof t&&(e=t)}var g;(l.convert!==Ae&&(e=l.convert(e,o)),o[n]&&(c=void 0===(d=o[n](e,u))&&1,c||(e=d,u=o[t])),c||(l.equal===Pe?u===e:l.equal(u,e)))||(o[t]=e,c=2,o[s]=null===(g=o[i])||void 0===g?void 0:g.call(o,e,u));!c||o.isDestroyed||o.onConfigChange.$nullFn||o.onConfigChange({name:r,value:e,was:u,config:l,applied:c,origPassedValue:a})}}}makeInitter(){const e=this;return e!==e.base?e.lazy?e.makeLazyInitter():e.base.initDescriptor:e.makeBasicInitter()}makeBasicInitter(){const e=this,{initializing:t,name:n}=e;return{configurable:!0,get(){const i=this;return e.removeInitter(i),i[t]=!0,i[n]=i[Ce][n],i[t]=!1,i.configDone[n]=!0,i[n]},set(t){e.removeInitter(this),this.configDone[n]=!0,this[n]=t}}}makeLazyInitter(){const e=this,{initializing:t,name:n}=e;return{configurable:!0,get(){const i=this,r=i[Se].get(n);return e.removeInitter(i),i.isDestroying||(i[t]=!0,i[n]=r,i[t]=!1),i[n]},set(t){e.removeInitter(this),this[n]=t}}}removeInitter(e){const{name:t}=this,n=e[be][t],i=e[Se];n?pe(e,t,n):delete e[t],null!=i&&i.delete(t)&&!i.size&&delete e[Se]}setDefault(e,t){pe(e.prototype,this.field,{configurable:!0,writable:!0,value:t})}merge(e,t){if(t&&e&&C.isObject(e)){if(t.isBase)return t.setConfig(e);C.isObject(t)&&(e=C.merge(C.clone(t),e))}return e}}const{prototype:Fe}=ke,{convert:Ae,equal:Pe}=Fe;ke.symbols={configuring:Ce,instanceProperties:be,lazyConfigs:Se},ke.cache=Object.create(null),ke.convertMethods={array:ke.makeArrayConvert(Ae),date(e,t){let n,i,r,s=e;if(Te[e])s=Te[e]();else if(null!=e){if("string"!=typeof e)n=new Date(e);else{if(r=this.formats,r)for(i of(r=r.flatMap((e=>e in t?t[e]:e)),r))if(n=i&&l.Date.parse(e,i),n)break;n||(n=l.Date.parse(e))}if(isNaN(n)){if(this.strict)throw new Error(`Invalid date: ${e}`)}else s=n}return s},day(e,t){var n;return null===(n=e=ke.convertMethods.date.call(this,e,t))||void 0===n||n.setMinutes(0,0,0),e}},ke.equalityMethods={array:ke.makeArrayEquals(),date:xe,day:xe,strict:ke.equal=Pe},ke.mergeMethods={distinct(e,t){let n=t?t.slice():[];if(null!=e)if(C.isObject(e))if(void 0===t)n=e;else{let t,i;for(t in e)i=n.indexOf(t),e[t]?i<0&&n.push(t):i>-1&&n.splice(i,1)}else Array.isArray(e)?e.forEach((e=>!n.includes(e)&&n.push(e))):n.includes(e)||n.push(e);return n},merge:ke.merge=Fe.merge,classList(e,t){if("string"==typeof e){if(!e.length)return t;e=e.split(De)}return Array.isArray(e)&&(e=e.reduce(Me,{})),ke.merge(e,t)},objects:(e,t)=>!0===e?t||{}:ke.merge(e,t),replace:e=>e,items:(e,t,n,i)=>i?C.mergeItems(t,e,{merge:(e,t)=>Fe.merge(t,e)}):Fe.merge(e,t)},Object.assign(Fe,{_descriptor:null,_initDescriptor:null,date:!1,lazy:!1,nullify:!1,render:!1}),ke._$name="Config";class Le{constructor(e,t,n,i){const r=this;let s,o;for(s in r.destroyed=!1,r.mapFwd={},r.mapRev={},r.source=e,r.syncing=!1,r.target=t,r.sourceHook=l.Function.after(e,"onConfigChange",(e=>r.onConfigChange(e,!0)),r,Ke),r.targetHook=null!=i&&i.oneway?null:l.Function.after(t,"onConfigChange",(e=>r.onConfigChange(e,!1)),r,Ke),n)o=n[s],o&&("string"!=typeof o&&(o=s),r.mapFwd[s]=o,r.mapRev[o]=s);r.unbind=r.destroy.bind(r),r.unbind.binding=r}destroy(){var e,t;this.destroyed||(this.destroyed=!0,null===(e=this.sourceHook)||void 0===e||e.call(this),null===(t=this.targetHook)||void 0===t||t.call(this))}onConfigChange(e,t){const n=this;(t?n.mapFwd:n.mapRev)[e.name]&&n.sync(t)}sync(e){e=!1!==e;const t=this,[n,i,r]=e?[t.source,t.target,t.mapFwd]:[t.target,t.source,t.mapRev];if(!t.syncing&&!n.isDestroying&&!i.isDestroying){let e,s,o,a,l,c,d=0;for(s in t.syncing=!0,r)a=r[s],o=n[s],o!==i[a]&&(++d,(e||(e={}))[l=a]=c=o);d>1?i.setConfig(e):d&&(i[l]=c),t.syncing=!1}}}class Oe{constructor(e){e&&Object.assign(this,e)}getInherited(e,t=!0){let n=this[e];var i;e in this||(n=null===(i=this.super)||void 0===i?void 0:i.getInherited(e,t),(n||t)&&(this[e]=n=Object.create(n||null),_e(n,"$meta",{value:this})));return n}}const{getPrototypeOf:$e}=Object,{defineProperty:_e}=Reflect,je=(e=>(t,n)=>e.call(t,n))(Object.prototype.hasOwnProperty),Be=Symbol("classMetaData"),Ve=Symbol("mixinTag"),He=Symbol("originalConfig"),ze=ke.symbols.configuring,Ne=ke.symbols.instanceProperties,We=ke.symbols.lazyConfigs,Ue={merge:"replace",simple:!0},Ge=e=>l.Object.clone(e),qe=()=>{},Ye=e=>l.Object.isObject(e),Ke={return:!1},Xe={},Ze=Object.freeze({}),Je=Object.freeze([]),Qe=/^(date|day)(\[])?$/,et=e=>e&&(e.destroy?e.destroy():Array.isArray(e)&&e.forEach(et));class tt{static get isBase(){return!0}get isBase(){return!0}static get declarable(){return["declarable","configurable","defaultConfig","properties","prototypeProperties"]}constructor(...e){const t=this,n=t.constructor;t.$meta.class!==n&&(n.$meta.initialized=!0),t.construct(...e),t.afterConstruct(),t.isConstructing=!1}static new(...e){return new this(e=(e=e.filter((e=>e))).length>1?this.mergeConfigs(...e):e[0])}construct(...e){null!==e[0]&&this.configure(...e),this.afterConfigure()}static destroy(...e){et(e)}destroy(){const e=this,{id:t}=e;e.isDestroying=!0,e.destroy=qe,e.doDestroy(),Object.setPrototypeOf(e,null);for(const t in e)"destroy"!==t&&"isDestroying"!==t&&delete e[t];delete e[He],e.isDestroyed=!0,e.id=t}destroyMember(e){tt.destroy(this[e]),this[e]=null}_thisIsAUsedExpression(e){}static get $$name(){return je(this,"$name")&&this.$name||je(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}startConfigure(e){}finishConfigure(e){}afterConfigure(){}afterConstruct(){}animateProperty(e,t,n=1e3,i){const r=null==t,s=this[e]||0,o=(t||0)-s,a=te.animate(n,(t=>this[e]=s+o*t),null,i);return r&&a.then((()=>this[e]=null)),a}callback(e,t,n=Je){const{handler:i,thisObj:r}=this.resolveCallback(e,"this"===t?this:t)||Ze;return null==i?void 0:i.apply(r,n)}resolveProperty(e){let t=this;for(;t;){if(tt.hasConfigPath(t,e,!0))return l.Object.getPath(t,e);t=t.owner}}resolveCallback(e,t=this,n=!0){var i;if(null!==(i=e)&&void 0!==i&&i.substring){if(e.endsWith("?")&&(n=!1,e=e.substring(0,e.length-1)),e.startsWith("up.")){for(e=e.substring(3),t=this.owner;t&&!t[e];t=t.owner);if(!t)return}else e.startsWith("this.")&&(e=e.substring(5),t=this);if(!(t&&t instanceof Object))return;e=t[e]}if("function"==typeof e)return{handler:e,thisObj:t};if(n)throw new Error(`No method named ${e} on ${t.$$name||"thisObj object"}`)}bindCallback(e,t=this){if(e){const{handler:n,thisObj:i}=this.resolveCallback(e,t);if(n)return n.bind(i)}}delay(e,t,n=e.name||e){e=this.setTimeout?e:e.bind(this);return(this.setTimeout?this:globalThis)["number"==typeof t?"setTimeout":"requestAnimationFrame"](e,t,n)}doDestroy(){const e=this,{nullify:t}=e.$meta;if(t)for(let n=0;n<t.length;++n)null!=e[t[n].field]&&(e[t[n].name]=null)}destroyProperties(...e){const t=this;let n;for(n of e){var i,r;if(n in t&&(!t[ze]||!t[ze][n]))null===(i=t[n])||void 0===i||null===(r=i.destroy)||void 0===r||r.call(i),delete t[n]}}configure(e={}){const t=this,n=t.$meta,{beforeConfigure:i}=t.initialConfig=e,{configs:r}=n,s=t.getDefaultConfiguration();let o,a,l;for(a in t.isConfiguring=!0,Object.assign(t,t.getProperties()),e)l=e[a],o=r[a],s[a]=o?o.merge(l,s[a],null,n):l;i&&(delete s.beforeConfigure,i(t,s)),t.setConfig(t[He]=s,!0),t.isConfiguring=!1}bindConfigs(e,t,n){const i=new Le(this,e,t,n);return!1!==(null==n?void 0:n.sync)&&i.sync(),i.unbind}getConfig(e,...t){const n=this[e];return t.length?[n,...t.map((e=>this[e]))]:n}updateConfiguration(e){const t=this,{configDone:n}=t,{configs:i}=t.$meta,r=t[ze],s=t[We];t.recompose.suspend();for(const a in e){var o;if(n[a])t[a]=e[a];else null!==(o=i[a])&&void 0!==o&&o.lazy?s.set(a,e[a]):r[a]=e[a]}t.recompose.resume(),t.recompose.flush()}setConfig(e,t=!1){const n=this,i=n[ze],r=i?n.configDone:n.configDone={},s=n.$meta.configs,o=n[We];let a,l;for(l in n[Ne]={},n[ze]=i?Object.assign(Object.create(i),e):e,e)a=s[l]||ke.get(l),null!==e[l]||je(e,l)||null===a.default?(null!=o&&o.has(l)||a.defineInitter(n,e[l]),t||(r[l]=!1)):r[l]=!0;for(l in t&&n.startConfigure(e),e){var c;r[l]||t&&null!==(c=s[l])&&void 0!==c&&c.lazy||(n[l]=e[l])}return i?n[ze]=i:delete n[ze],t&&n.finishConfigure(e),n}hasConfig(e){var t;const n=this,i=n[ze];return Boolean(null!=n["_"+e]||null!=(null===(t=n[We])||void 0===t?void 0:t.get(e))||!n.configDone[e]&&i&&(null!=i[e]||je(i,e)))}static hasConfigPath(e,t){return t.split(".").every((t=>{var n,i;const r=null===(n=e)||void 0===n||null===(n=n.$meta)||void 0===n||null===(n=n.configs)||void 0===n?void 0:n[t];return!!(r&&r.descriptor.get===(null===(i=l.Object.getPropertyDescriptor(e,t))||void 0===i?void 0:i.get)?e.hasConfig(t):t in e)&&(e=e[t],void 0!==Object)}))}peekConfig(e){const t=this,n=t[We],i=t[ze];if(null!=n&&n.has(e))return n.get(e);if(i&&e in i){if(t.configDone[e])return t[e];if(null!=i[e]||je(i,e))return i[e]}}triggerConfig(e){const t=this,{configDone:n}=t,i=t[We],r=t[ze],s=null!=i&&i.has(e)||r&&(null!=r[e]||je(r,e))?!n[e]:null;return s&&t.getConfig(e),s}triggerConfigs(e){const t=this,n=t.$meta.configs,i=t[We],r=i?[...i.keys()].filter((t=>n[t].lazy===e)):Je;for(const e of r)t.triggerConfig(e);return r.length?r:null}onConfigChange(){}get config(){const e={},t=this[He];for(const n in t)e[n]=t[n];return e}static processConfigValue(e,t){if(e===globalThis)return globalThis;if(Array.isArray(e))return e.map((e=>tt.processConfigValue(e,t)));if(e instanceof tt){if(t.visited.has(e))return;return e.getCurrentConfig(t)}if(e instanceof HTMLElement||e instanceof DocumentFragment)return null;if(Ye(e)){const n={};for(const i in e)"owner"!==i&&(n[i]=tt.processConfigValue(e[i],t));return n}return e}getConfigValue(e,t){var n;const i=this,r=i[We];return null!==(n=i.$meta.configs[e])&&void 0!==n&&n.lazy?null!=r&&r.has(e)?tt.processConfigValue(r.get(e),t):void 0:tt.processConfigValue(i[e],t)}preProcessCurrentConfigs(){}getCurrentConfig(e={}){const t=this,n="all"===e.configs?t.config:Ge(t.initialConfig),i=e.skip||{},r=e.visited||(e.visited=new Set),s=e.depth||(e.depth=0),o={};if(!r.has(t)){r.add(t),this.preProcessCurrentConfigs(n);for(const r in n){if(i[r])continue;const n=t.getConfigValue(r,{...e,depth:s+1});void 0!==n&&(o[r]=n)}return o}}getConfigString(e={}){return l.String.toJavaScriptString(this.getCurrentConfig(e))}getTestCase(e={}){const t=this.isGantt?"Gantt":this.isSchedulerPro?"SchedulerPro":this.isCalendar?"Calendar":this.isScheduler?"Scheduler":this.isGrid?"Grid":this.isTaskBoard?"TaskBoard":null;if(t){const n=t.toLowerCase(),i=`../../build/${n}.module.js`;let r,s;"static"===e.import?(r=`import * as module from "${i}";Object.assign(window, module);`,s=""):(r=`import("${i}").then(module => { Object.assign(window, module);\n`,s="});");const o=q.getVersion(n);return o&&(r+=`\nconsole.log('${t} ${o}');\n`),`${r}      \nconst ${n} = new ${t}(${this.getConfigString(e)});\n${s}`}}downloadTestCase(e={}){e.output="return";const t=this.getTestCase(e);l.Browser.download("app.js","data:application/javascript;charset=utf-8,"+escape(t))}static initClass(){return this.$meta.class}static get $meta(){if(!je(this,Be)){const e=this[Be]=new Oe;return e.class=this,this.setupClass(e),e}return this[Be]}static onClassMixedIn(){}static mergeConfigs(e,...t){const n=this.$meta.configs,i=Ge(e)||{};let r,s,o,a;for(s=0;s<t.length;++s)if(r=t[s],r)for(o in r)a=r[o],n[o]?a=n[o].merge(a,i[o]):i[o]&&a&&(a=ke.merge(a,i[o])),i[o]=a;return i}static mixin(...e){let t,n=this;for(t=0;t<e.length;++t){const i=e[t],r=i[Ve]||(i[Ve]=Symbol("mixinTag"));n[r]||(n=i(n),n[r]=!0,je(n,"onClassMixedIn")&&n.onClassMixedIn())}return n}static setupClass(e){var t;const n=e.class,i=$e(n).$meta,r=n.$$name,s=i.names,o=n.prototype;if(_e(o,"$meta",{value:e}),Object.assign(e,{super:i,config:Object.create(i.config),configs:Object.create(i.configs),declarables:i.declarables,forkConfigs:i.forkConfigs,hierarchy:Object.freeze([...i.hierarchy,n]),names:s.includes(r)?s:Object.freeze([...s,r]),properties:i.properties,nullify:null===(t=i.nullify)||void 0===t?void 0:t.slice()}),s!==e.names){const e=`is${r}`,t=t=>{je(t,e)||_e(t,e,{get:()=>!0})};t(o),t(n)}for(let t,i,r=0;r<e.declarables.length;++r)t=e.declarables[r],je(n,t)&&(i=Xe[t]||(Xe[t]=`setup${l.String.capitalize(t)}`),n[i](n,e))}static setupConfigs(e,t,n){const i=e.config,r=e.configs,s=e.class,o=e.super;let a,c,d,u,h,g,{nullify:m}=e;for(const p in t)h=t[p],n?(a=r[p])?h=a.merge(h,i[p],e,o):a=ke.get(p,Ue):(c=d=u=void 0,h&&"object"==typeof h&&"$config"in h&&(d=h.$config,Qe.test(String(d))&&(d={type:d}),d&&(Ye(d)?d.type&&(d={convert:d.type,equal:d.type,...d},delete d.type):d=l.Object.createTruthyKeys(d)),u="default"in h,c=u?h.default:c,h="value"in h?h.value:null),(a=r[p])?(g=a.nullify,d&&(a=a.extend(d)),h=a.merge(h,i[p],e,o)):(a=ke.get(p,d),a.define(s.prototype),u=!(a.field in s.prototype),g=!1),u&&a.setDefault(s,c),a.nullify&&!g&&(m||(m=e.nullify||(e.nullify=[]))).push(a)),h&&(Ye(h)||Array.isArray(h))&&!Object.isFrozen(h)&&(e.forkConfigs=!0),r[p]=a,i[p]=h}static setupConfigurable(e,t){e.setupConfigs(t,e.configurable,!1)}static setupDefaultConfig(e,t){e.setupConfigs(t,e.defaultConfig,!0)}static setupDeclarable(e,t){const n=e.declarable;let i,r,s=t.declarables;for(r=0;r<n.length;++r)s.includes(n[r])||(i||(t.declarables=i=s=s.slice()),s.push(n[r]))}static setupProperties(e,t){t.properties=t.super.properties.slice(),t.properties.push(e),Object.freeze(t.properties)}static setupPrototypeProperties(e){Object.assign(e.prototype,e.prototypeProperties)}static fork(e){let t,n,i=e;if(e&&Ye(e)&&!Object.isFrozen(e))for(t in i=Object.create(e),e)n=e[t],n&&(Ye(n)?i[t]=tt.fork(n):Array.isArray(n)&&(i[t]=n.slice()));return i}static getDefaultConfiguration(){return this.$meta.class.prototype.getDefaultConfiguration()}getDefaultConfiguration(){const e=this.$meta,t=e.forkConfigs?tt.fork(e.config):Object.create(e.config);if(q.isTestEnv&&l.Browser.isBrowserEnv&&t.testConfig&&globalThis.__applyTestConfigs)for(const e in t.testConfig)t[e]=t.testConfig[e];return t}getProperties(){const e=this.$meta.properties,t={};for(let n=0;n<e.length;n++){const i=Object.getOwnPropertyDescriptor(e[n],"properties");Object.assign(t,void 0!==i.get?e[n].properties:Ge(i.value))}return t}static applyDefaults(e){for(const t in e)this.$meta.config[t]=e[t]}static get superclass(){return $e(this)}classHierarchy(e){const t=this.$meta.hierarchy,n=e?t.indexOf(e):0;return n>0?t.slice(n):t}static isOfTypeName(e){return this.$meta.names.includes(e)}detachListeners(...e){const{$detachers:t}=this;if(t)for(let n,i=0,{length:r}=e;i<r;i++)if(n=t[e[i]])for(;n.length;)n.pop()()}trackDetacher(e,t){const n=this.$detachers||(this.$detachers={});(n[e]||(n[e]=[])).push(t)}untrackDetachers(e){const t=this.$detachers;if(t)for(const n in t){const i=t[n];for(let t=i.length;t-- >0;)i[t].eventer===e&&i.splice(t,1)}}}const nt=tt.prototype;var it;nt.onConfigChange.$nullFn=qe.$nullFn=!0,tt[Be]=nt.$meta=(it={class:tt,config:Object.freeze({}),configs:Object.create(null),declarables:tt.declarable,forkConfigs:!1,hierarchy:Object.freeze([tt]),names:Object.freeze(["Base"]),nullify:null,properties:Object.freeze([]),super:null},new Oe(it)),Object.assign(nt,{$detachers:null,configObserver:null,isConstructing:!0,isDestroyed:!1,isDestroying:!1}),tt.emptyFn=qe,q.setVersion("core","6.3.1"),tt._$name="Base";class rt{static $name="ArrayHelper";static clean(e){return e.reduce(((e,t)=>(null==t||Array.isArray(t)&&0===t.length||""===t||e.push(t),e)),[])}static from(e,t,n){const i=[];if(e)for(const r of e)t&&!t(r)||i.push(n?n(r):r);return i}static remove(e,...t){let n,i,r=!1;t=t[0]instanceof Set?[...t[0]]:t;for(let s=0;s<t.length;s++)i=t[s],-1!==(n=e.indexOf(i))&&(e.splice(n,1),r=!0);return r}static findInsertionIndex(e,t,n=this.lexicalCompare,i){const r=t.length;let s,o;return i<r&&(s=i>0?n(t[i-1],e):0,o=i<r-1?n(e,t[i]):0,s<1&&o<1)?i:this.binarySearch(t,e,n)}static findLast(e,t,n){for(let{length:i}=e,r=i-1;r>=0;r--)if(t.call(n,e[r],r,e))return e[r]}static binarySearch(e,t,n=0,i=e.length,r=this.lexicalCompare){const s=e.length;let o,a;for(n instanceof Function?(r=n,n=0):i instanceof Function&&(r=i,i=s),--i;n<=i;)o=n+i>>1,a=r(t,e[o]),a>=0?n=o+1:a<0&&(i=o-1);return n}magnitudeCompare(e,t){return e<t?-1:e>t?1:0}lexicalCompare(e,t){return(e=String(e))<(t=String(t))?-1:e>t?1:0}static fill(e,t={},n=null){const i=[],r=Array.isArray(t)?t:[t];for(let t=0;t<e;t++)for(const e of r){const r=Object.assign({},e);n&&n(r,t),i.push(r)}return i}static populate(e,t,n=!1){const i=[];for(let r=0;r<e;r++)i.push(t(r+(n?1:0)));return i}static include(e,...t){for(const n of t)e.includes(n)||e.push(n)}static unique(e){return[...new Set(e)]}static countUnique(e){const t=new Map;for(const n of e){const e=t.get(n);t.set(n,void 0===e?1:e+1)}return[...t.entries()].map((([e,t])=>({value:e,count:t})))}static allowNegative(e){return new Proxy(e,{get(e,t,n){if("string"!=typeof t)return Reflect.get(e,t,n);const i=Number(t);return Number.isNaN(i)?Reflect.get(e,t,n):e[i<0?e.length+i:i]},set(e,t,n,i){if("string"!=typeof t)return Reflect.set(e,t,n,i);const r=Number(t);return Number.isNaN(r)?Reflect.set(e,t,n,i):(e[r<0?e.length+r:r]=n,!0)}})}static delta(e,t,n=!1){if(!t)return n?{toAdd:e,toRemove:[],toKeep:[]}:{onlyInA:e,onlyInB:[],inBoth:[]};const i=[],r=[],s=new Set,o=new Set(t);for(let t=0;t<e.length;t++){const n=e[t];o.has(n)?s.add(n):i.push(n)}for(let e=0;e<t.length;e++){const n=t[e];s.has(n)||r.push(n)}return n?{toAdd:i,toRemove:r,toKeep:s}:{onlyInA:i,onlyInB:r,inBoth:[...s]}}static asArray(e){return null==e?e:e instanceof Set?Array.from(e):Array.isArray(e)?e:[e]}static identity(e){return e}static keyBy(e,t,n=rt.identity){const i="string"==typeof t?e=>null==e?void 0:e[t]:t,r="string"==typeof n?e=>null==e?void 0:e[n]:n;return e.reduce(((e,t)=>(e[i(t)]=r(t),e)),{})}static aggregate(e,t,n,i,r={}){const s=e.length,o=[];if(!s)return o;const a=e[0].length;r.targetArray=o,r.arrays=e;for(let e=0;e<a;e++)r.entryIndex=e,o.push(i(e,r));for(let i=0;i<s;i++){const s=e[i];r.rowIndex=i;for(let e=0;e<a;e++){r.entryIndex=e;const a=t(s[e],r);o[e]=n(o[e],a,i,e,r)}}return o}static groupBy(e,t){const n="string"==typeof t?e=>null==e?void 0:e[t]:t;return e.reduce(((e,t)=>{const i=n(t);return(e[i]=e[i]||[]).push(t),e}),{})}static groupByIndexed(e,t){return e.reduce(((e,n)=>{const i=t(n);let r=e.get(i);return void 0===r&&(r=new Set,e.set(i,r)),r.add(n),e}),new Map)}static chunkedInsert(e,t,n,i=5e4){const r=n.length/i;for(let s=0;s<r;s++){const r=s*i,o=(s+1)*i;e.splice(t+r,0,...n.slice(r,o))}}static chunkedPush(e,t){for(const n of t)e.push(n)}}l.register(rt),rt._$name="ArrayHelper";const{isArray:st}=Array,{hasOwnProperty:ot}=Object.prototype,at={thisObj:1,detachable:1,once:1,detacher:1,prio:1,args:1,expires:1,buffer:1,throttle:1,name:1,$internal:1},lt=(e,t)=>t.prio-e.prio,ct=(e,t)=>{if(null!==e){if(!e)return t;t&&(e=e?[e]:[]).push[st(t)?"apply":"call"](e,t)}return e};var dt=e=>class t extends(e||tt){eventsSuspended=null;static $name="Events";static get declarable(){return["deprecatedEvents"]}static setupDeprecatedEvents(e,t){const n=t.getInherited("deprecatedEvents"),i=e.deprecatedEvents;for(const e in i)n[e.toLowerCase()]=n[e]=i[e]}static get configurable(){return{listeners:{value:null,$config:{merge:ct}},internalListeners:{value:null,$config:{merge:ct}},bubbleEvents:null}}destroy(){this.trigger("beforeDestroy"),super.destroy()}construct(e,...t){var n;(this.configuredListeners=null===(n=e)||void 0===n?void 0:n.listeners)&&delete(e=C.assign({},e)).listeners,super.construct(e,...t),this.processConfiguredListeners()}processConfiguredListeners(){if(this.configuredListeners){const e=this,{isConfiguring:t}=e;e.isConfiguring=!1,e.listeners=e.configuredListeners,e.configuredListeners=null,e.isConfiguring=t}}doDestroy(){this.trigger("destroy"),this.removeAllListeners(!1),super.doDestroy()}static setupClass(e){super.setupClass(e),t.prototype.onListen.$nullFn=!0,t.prototype.onUnlisten.$nullFn=!0}addListener(e,t,n){if(st(e)){for(let n=0,{length:i}=e;n<i;n++)this.addListener(e[n],t);return}const i=this,r=i.$meta.getInherited("deprecatedEvents");if("string"==typeof e)return i.addListener({[e]:t,detachable:!1!==t.detachable,thisObj:n});{t=e.thisObj=void 0!==e.thisObj?e.thisObj:t;for(const n in e)if(!at[n]&&null!=e[n]){const o=n.toLowerCase(),a=null==r?void 0:r[o],l=i.eventListeners||(i.eventListeners={}),c=rt.asArray(e[n]);if(a){const{product:e,invalidAsOfVersion:t,message:n}=a;q.deprecate(e,t,n)}for(const r of c){var s;const a=r.expires||e.expires,c={fn:"object"==typeof r?r.fn:r,thisObj:void 0!==r.thisObj?r.thisObj:t,args:r.args||e.args,prio:void 0!==r.prio?r.prio:void 0!==e.prio?e.prio:0,once:void 0!==r.once?r.once:void 0!==e.once&&e.once,buffer:r.buffer||e.buffer,throttle:r.throttle||e.throttle,$internal:e.$internal,catchAll:"catchAll"===n};if(a){const{alt:r}=a,s=r?a.delay:a,l=e.name||n,d=()=>{i.un(o,c),r&&!c.called&&i.callback(r,t)};i.isDelayable?i.setTimeout({fn:d,name:l,cancelOutstanding:!0,delay:s}):globalThis.setTimeout(d,s)}let d=l[o]||(l[o]=[]);d.$firing&&(l[o]=d=d.slice()),d.splice(rt.findInsertionIndex(c,d,lt,d.length),0,c),!i.onListen.$nullFn&&d.length<2&&i.onListen(o),null===(s=i.afterAddListener)||void 0===s||s.call(i,o,c)}}e.relayAll&&i.relayAll(e.relayAll),t&&t!==i&&i.attachAutoDetacher(e,t);const n=!1!==e.detachable,a=e.name,l=e.expires||n||a?()=>{i.isDestroyed||i.removeListener(e,t)}:null;var o;if(l)if(l.eventer=i,l.listenerName=a,a&&null!==(o=t)&&void 0!==o&&o.trackDetacher&&t.trackDetacher(a,l),e.expires&&i.delay(l,isNaN(e.expires)?e.expires.delay:e.expires,a),n)return l}}on(e,t,n){return this.addListener(e,t,n)}ion(e){return e.$internal=!0,this.on(e)}un(...e){return this.removeListener(...e)}updateInternalListeners(e,t){null==t||t.detach(),e&&(e.detach=this.ion(e))}get listeners(){return this.eventListeners}changeListeners(e){if(!this.isConfiguring){if(Array.isArray(e))for(let t=0,n=e[0],{length:i}=e;t<i;n=e[++t])"thisObj"in n||(e[t]=C.assign({thisObj:this},n));else e&&!("thisObj"in e)&&(e=C.assign({thisObj:this},e));return e}this.getConfig("internalListeners"),e&&this.on(e,this)}updateListeners(e,t){t&&this.un(t),e&&this.on(e)}removeListener(e,t=e.thisObj,n){const i=this;if("string"==typeof e)return i.removeListener({[e]:t},n);let r=!1;for(let n in e){const o=e[n];if(!at[n]&&null!=o){n=n.toLowerCase();const{eventListeners:e}=i,a=i.findListener(n,o,t);if(a>=0){var s;let t=e[n];null===(s=i.afterRemoveListener)||void 0===s||s.call(i,n,t[a]),r=!0,t.length>1?(t.$firing&&(e[n]=t=t.slice()),t.splice(a,1)):(delete e[n],i.onUnlisten.$nullFn||i.onUnlisten(n))}}}return e.thisObj&&!e.thisObj.isDestroyed&&i.detachAutoDetacher(e),r}findListener(e,t,n){var i;const r=null===(i=this.eventListeners)||void 0===i?void 0:i[e],s=t.fn||t,o=t.thisObj||n;if(r)for(let e,t=0,{length:n}=r;t<n;t++)if(e=r[t],e.fn===s&&e.thisObj===o)return t;return-1}hasListener(e){const{eventListeners:t}=this;return e?Boolean(null==t?void 0:t[e.toLowerCase()]):!C.isEmpty(t)}numListeners(e){const{eventListeners:t}=this;return(e?[e.toLowerCase()]:Object.keys(t)).reduce(((e,n)=>e+t[n].length),0)}relayAll(e,t,n=!0){this.relayAllTargets||(this.relayAllTargets=[]);const{relayAllTargets:i}=this;e.ion({beforeDestroy:({source:t})=>{if(t===e){i.filter((t=>t.through===e)).forEach((e=>rt.remove(i,e)))}}}),i.push({through:e,prefix:t,transformCase:n})}removeAllListeners(e=!0){const t=this.eventListeners;let n,i;for(const o in t){const a=t[o];for(n=a.length;n-- >0;){const t=a[n];var r,s;if(!t.$internal||!e)this.removeListener(o,t),i=t.thisObj,null===(r=i)||void 0===r||null===(s=r.untrackDetachers)||void 0===s||s.call(r,this)}}}relayEvents(e,t,n="",i){const r={detachable:!0,thisObj:this};return t.forEach((e=>{n&&(e=V.capitalize(e)),r[e]=(t,...r)=>(i&&(t=Object.assign({},t,{source:this})),this.trigger(n+e,t,...r))})),e.on(r)}onListen(){}onUnlisten(){}destructorInterceptor(){const{autoDetachers:e,target:t,oldDestructor:n}=this;for(let n=0;n<e.length;n++){const{dispatcher:i,config:r}=e[n];i.isDestroyed||i.removeListener(r,t)}n.call(t)}attachAutoDetacher(e,t){const n=e.thisObj||t,i="doDestroy"in n?"doDestroy":"destroy";if(i in n){let{$autoDetachers:t}=n;t||(n.$autoDetachers=t=[]),n.$oldDestructor||(n.$oldDestructor=n[i],n[i]=this.destructorInterceptor.bind({autoDetachers:t,oldDestructor:n.$oldDestructor,target:n})),t.push({config:e,dispatcher:this})}else n[i]=()=>{this.removeListener(e)}}detachAutoDetacher(e){const t=e.thisObj;t.$oldDestructor&&!t.isDestroying&&(rt.remove(t.$autoDetachers,t.$autoDetachers.find((t=>t.config===e&&t.dispatcher===this))),t.$autoDetachers.length||(t["doDestroy"in t?"doDestroy":"destroy"]=t.$oldDestructor,t.$oldDestructor=null))}once(e,t){return this.ion({[e]:e=>this.callback(t,this,[e]),once:!0})}await(e,t={checkLog:!0,resetLog:!0,args:null,expires:null}){const n=this;!1===t&&(t={checkLog:!1});const{args:i}=t;return new Promise((r=>{var s;if(t.checkLog&&null!==(s=n._triggered)&&void 0!==s&&s[e]&&(r(),t.resetLog&&n.clearLog(e)),i){const s=n.on({[e]:(...o)=>{("function"==typeof i?i(...o):Object.keys(i).every((e=>e in o[0]&&o[0][e]===i[e])))&&(r(...o),t.resetLog&&n.clearLog(e),s())},expires:t.expires,prio:-1e4})}else n.on({[e]:(...i)=>{r(...i),t.resetLog&&n.clearLog(e)},expires:t.expires,prio:-1e4,once:!0})}))}clearLog(e){this._triggered&&(e?delete this._triggered[e]:this._triggered={})}trigger(e,t){var n,i,r,s,o;const a=this,l=e.toLowerCase(),{eventsSuspended:c,relayAllTargets:d,callOnFunctions:u}=a;let h,g,m=null===(n=a.eventListeners)||void 0===n?void 0:n[l];if(a._triggered||(a._triggered={}),a._triggered[e]=!0,c)return c.shouldQueue&&c.queue.push(arguments),!0;if(null!==(i=a.eventListeners)&&void 0!==i&&i.catchall&&((m=m?m.slice():[]).push(...a.eventListeners.catchall),m.sort(lt)),!m&&!d&&!u)return!0;if(t?"source"in t||(Object.isExtensible(t)?t.source=a:(t=Object.create(t),Object.assign(t,{source:a}))):t={source:a},t.type!==l&&(t.constructor!==Object?Reflect.defineProperty(t,"type",{get:()=>l}):t.type=l),t.eventName=e,!("bubbles"in t)&&null!==(r=a.bubbleEvents)&&void 0!==r&&r[e]&&(t.bubbles=a.bubbleEvents[e]),u){const n="on"+V.capitalize(e);if(n in a){var p;const e=!a[n]||a.callback(a[n],a,[t]);let i;if(C.isPromise(e)?(h||(h=[])).push(e):i=!1===e||i,!a.isDestroyed&&ot.call(a,n)&&(null===(p=a.pluginFunctionChain)||void 0===p||!p[n])){const e=Object.getPrototypeOf(a);if(n in e){const r=e[n].call(a,t);if(C.isPromise(r)?(h||(h=[])).push(r):i=!1===r||i,a.isDestroyed)return}}if(i)return!1}}if(m){let e=0,n=!1;for(m.$firing=!0;e<m.length&&!a.isDestroyed&&!n;e++){const i=m[e];if(!1===g&&!i.$internal)continue;let r,s=i.thisObj;if(!s||!s.isDestroyed){if(i.called=!0,i.once&&a.removeListener(l,i),"string"==typeof i.fn){if(s&&(r=s[i.fn]),!r){const e=a.resolveCallback(i.fn);r=e.handler,s=e.thisObj}}else r=i.fn;if(i.buffer){if(!i.bufferFn){const e=Number(i.buffer);if("number"!=typeof e||isNaN(e))throw new Error(`Incorrect type for buffer, got "${e}" (expected a Number)`);i.bufferFn=te.createBuffered(r,e,s,i.args)}r=i.bufferFn}if(i.throttle){const e=Number(i.throttle);if("number"!=typeof e||isNaN(e))throw new Error(`Incorrect type for throttle, got "${e}" (expected a Number)`);i.throttledFn||(i.throttledFn=te.createThrottled(r,e,s,i.args)),r=i.throttledFn}const e=r.call(s||a,...i.args||[],t);!1!==g&&(g=e),i.$internal&&!1===e&&(n=!0),C.isPromise(e)&&(e.$internal=i.$internal,(h||(h=[])).push(e))}}if(m.$firing=!1,n)return!1}return null==d||d.forEach((n=>{let i=e;if(n.transformCase&&(i=V.capitalize(i)),n.prefix&&(i=n.prefix+i),!1===n.through.trigger(i,t))return!1})),t.bubbles&&a.owner&&!a.owner.isDestroyed?a.owner.trigger(e,t):(h=null===(s=h)||void 0===s?void 0:s.filter((e=>!1!==g||e.$internal)),null!==(o=h)&&void 0!==o&&o.length?new Promise((e=>{Promise.allSettled(h).then((t=>{const n=!t.some((e=>"fulfilled"===e.status&&!1===e.value));e(n)}))})):!1!==g)}suspendEvents(e=!1){(this.eventsSuspended||(this.eventsSuspended={shouldQueue:e,queue:[],count:0})).count++}resumeEvents(){const e=this.eventsSuspended;if(e&&0==--e.count&&(this.eventsSuspended=null,e.shouldQueue))for(const t of e.queue)this.trigger(...t);return!Boolean(this.eventsSuspended)}};class ut{static animationFrame(){return new Promise((e=>{requestAnimationFrame(e)}))}static sleep(e){return new Promise((t=>{setTimeout((()=>{t()}),e)}))}static waitFor(e,t=6e4,n=100){let i;const r=new Promise(((r,s)=>{let o;i=r;const a=()=>{const t=e();if(t)return clearInterval(o),r(t),!0};a()||(o=setInterval(a,n),t&&setTimeout((()=>{clearInterval(o),t>0?s():r()}),Math.abs(t)))}));return r.resolve=i,r}static yield(){return Promise.resolve()}static async waitForAnimations(e,t=!0){const n=e.getAnimations({subtree:t}).flatMap((e=>e.effect.getTiming().iterations!==1/0?e.finished:[]));n.length&&await Promise.all(n)}}let ht;ut._$name="AsyncHelper";const gt=["border-top-width","border-right-width","border-bottom-width","border-left-width"],mt=["margin-top","margin-right","margin-bottom","margin-left"],pt=["padding-top","padding-right","padding-bottom","padding-left"],ft="border-top-width",vt="border-right-width",yt="border-bottom-width",bt="border-left-width",Ct="padding-top",St="padding-right",wt="padding-bottom",Dt="padding-left",Et=/^([trblc])(\d*)-([trblc])(\d*)$/i,xt=/^([trblc])(\d*)$/i,Rt=["top","right","bottom","left"],Tt={t:0,r:1,b:2,l:3},Mt=["b-t","l-r","t-b","r-l"],It={bt:1,tb:1,lr:2,rl:2},kt=Object.freeze([0,0]),Ft=["width","height"],At=(e,t=e,n=e,i=t)=>Array.isArray(e)?At.apply(null,e):[e,t,n,i],Pt=(e,t,n,i)=>Array.isArray(e)?At.apply(null,e):"number"==typeof e.top?[e.top,e.right,e.bottom,e.left]:[e,t,n,i],Lt=(e,t)=>{const n=Et.exec(e),i=n[1],r=n[3],s=parseInt(n[2]||50),o=parseInt(n[4]||50),a=!t||1&Tt[i]?s:100-s,l=!t||1&Tt[r]?o:100-o;return{myAlignmentPoint:i+a,myEdge:i,myOffset:a,targetAlignmentPoint:r+l,targetEdge:r,targetOffset:l,startZone:Tt[r],edgeAligned:It[i+r]}},Ot=e=>`${Rt[(Tt[e.myEdge]+2)%4][0]}${e.myOffset}-${Rt[(Tt[e.targetEdge]+2)%4][0]}${e.targetOffset}`,$t={hidden:1,clip:1};class _t{isRectangle=!0;static from(e,t,n){var i,r;if("string"==typeof e?e=document.querySelector(e):(null===(i=e)||void 0===i?void 0:i.nodeType)===Node.DOCUMENT_FRAGMENT_NODE&&(e=e.host||e.ownerDocument),"string"==typeof t&&(t=document.querySelector(t)),null==e||e.isRectangle)return e;if(e=e.element||e,void 0===n&&"boolean"==typeof t&&(n=t,t=null),null===(r=t)||void 0===r||!r.isRectangle)if(t){let{scrollLeft:e,scrollTop:n}=t;d.isSafari&&t===document.body&&(e=n=0),t=_t.from(t).translate(-e,-n)}else ht||(ht=new _t(0,0,0,0)),t=ht;const s=e===document||e===globalThis,o=e===document.body&&0===document.body.offsetHeight,a=o&&e.getBoundingClientRect(),l=o?new _t(a.left,a.top,a.width,document.body.parentElement.scrollHeight):s?new _t(0,0,globalThis.innerWidth,globalThis.innerHeight):e.getBoundingClientRect(),c=n||s?[0,0]:[globalThis.pageXOffset,globalThis.pageYOffset];return new _t(l.left+c[0]-t.x,l.top+c[1]-t.y,l.width,l.height)}static fromScreen(e,t){return _t.from(e,t,!0)}static inner(e,t,n=!1){const i=this.from(e,t,n);if(document.body.contains(e)){const t=ki.getStyleValue(e,gt);i.x+=parseFloat(t[bt]),i.y+=parseFloat(t[ft]),i.right-=parseFloat(t[vt]),i.bottom-=parseFloat(t[yt])}return i}static content(e,t,n=!1){const i=this.from(e,t,n);if(document.body.contains(e)){const t=ki.getStyleValue(e,gt),n=ki.getStyleValue(e,pt);i.x+=parseFloat(t[bt])+parseFloat(n[Dt]),i.y+=parseFloat(t[ft])+parseFloat(n[Ct]),i.right-=parseFloat(t[vt])+parseFloat(n[St]),i.bottom-=parseFloat(t[yt])+parseFloat(n[wt])}return i}static client(e,t,n=!1,i,r,s=!0){const o=this[s?"content":"inner"](e,t,n),a=ki.scrollBarWidth;let l;return a&&!e.classList.contains("b-hide-scroll")&&(e.scrollHeight>e.clientHeight&&!$t[ki.getStyleValue(e,"overflow-y")]&&(l=s?parseFloat(ki.getStyleValue(e,"padding-inline-end")):0,"rtl"===ki.getStyleValue(e,"direction")?o.x+=l+Math.max(l,a):o.right+=l-Math.max(l,a)),e.scrollWidth>e.clientWidth&&!$t[ki.getStyleValue(e,"overflow-x")]&&(l=s?parseFloat(ki.getStyleValue(e,"padding-bottom")):0,o.bottom+=l-Math.max(l,a))),i&&this.clipStickies(o,e,t,n=!1,r),o}static clipStickies(e,t,n,i=!1,r){let s=[...t.children].filter((e=>"sticky"===ki.getStyleValue(e,"position")));if(r){const e=r&&_t.from(r,n,i);s=s.filter((t=>!t.contains(r)&&e.intersect(_t.from(t))))}for(let t=0,{length:n}=s;t<n;t++){const n=s[t],i=this.fromScreen(n);0===parseFloat(ki.getStyleValue(n,"left"))?e.x+=i.width:0===parseFloat(ki.getStyleValue(n,"right"))?e.right-=i.width:0===parseFloat(ki.getStyleValue(n,"top"))?e.y+=i.height:0===parseFloat(ki.getStyleValue(n,"bottom"))&&(e.bottom-=i.height)}return e}static outer(e,t,n=!1){const i=this.from(e,t,n);if(document.body.contains(e)){const t=ki.getStyleValue(e,mt);i.x-=parseFloat(t["margin-left"]),i.y-=parseFloat(t["margin-top"]),i.right+=parseFloat(t["margin-right"]),i.bottom+=parseFloat(t["margin-bottom"])}return i}static union(...e){let t,{x:n,y:i,right:r,bottom:s}=e[0];if(e.length>1)for(let o=1;o<e.length;o++)t=e[o],t.x<n&&(n=t.x),t.y<i&&(i=t.y),t.right>r&&(r=t.right),t.bottom>s&&(s=t.bottom);return new _t(n,i,r-n,s-i)}roundPx(e=globalThis.devicePixelRatio||1){const t=this;return t._x=ki.roundPx(t._x,e),t._y=ki.roundPx(t._y,e),t._width=ki.roundPx(t._width,e),t._height=ki.roundPx(t._height,e),t}static get $$name(){return hasOwnProperty.call(this,"$name")&&this.$name||hasOwnProperty.call(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}constructor(e,t,n,i,r=!0){r&&(U.assertNumber(e,"Rectangle.x"),U.assertNumber(t,"Rectangle.y"),U.assertNumber(n,"Rectangle.width",!0),U.assertNumber(i,"Rectangle.height",!0));const s=this;n<0&&(e+=n,n=-n),i<0&&(t+=i,i=-i),s._x=e,s._y=t,s._width=n,s._height=i}clone(){const e=this,t=new _t(e.x,e.y,e.width,e.height,!1);return t.isAlignRectangle=e.isAlignRectangle,t.minHeight=e.minHeight,t.minWidth=e.minWidth,t}contains(e){const t=this;return!!e.isRectangle&&(e._x>=t._x&&e._y>=t._y&&e.right<=t.right&&e.bottom<=t.bottom)}exclude(...e){const t=this;let n,i=t.clone();for(n of Array.from(e).flat()){var r,s;let e,o,a=[0,0,0,0];((e=n.x<=t.x)||n.right>=t.right)&&(null===(r=o=n.intersect(t))||void 0===r?void 0:r.height)>=t.height?a[e?3:1]=-o.width:((e=n.y<=t.y)||n.bottom>=t.bottom)&&(null===(s=o=n.intersect(t))||void 0===s?void 0:s.width)>=t.width&&(a[e?0:2]=-o.height),i=i.inflate(...a)}return i}intersect(e,t=!1,n=!1){const i=this,r=Math.max(i.y,e.y),s=Math.min(i.right,e.right),o=Math.min(i.bottom,e.bottom),a=Math.max(i.x,e.x);return!!(n?o>=r&&s>=a:o>r&&s>a)&&(!!t||new _t(a,r,s-a,o-r))}equals(e,t=!1){const n=t?e=>Math.round(e):e=>e;return e.isRectangle&&n(e.x)===n(this.x)&&n(e.y)===n(this.y)&&n(e.width)===n(this.width)&&n(e.height)===n(this.height)}translate(e,t){return this._x+=e||0,this._y+=t||0,this}moveTo(e,t){return null!=e&&(this._x=e),null!=t&&(this._y=t),this}getDelta(e){return[e.x-this.x,e.y-this.y]}get center(){const e=new jt(this.x+this.width/2,this.y+this.height/2,0,0);return e.target=this.target,e}set x(e){const t=e-this._x;this._x=e,this._width-=t}get x(){return this._x}get start(){return this.left}set left(e){this.x=e}get left(){return this.x}set top(e){this.y=e}get top(){return this.y}set y(e){const t=e-this._y;this._y=e,this._height-=t}get y(){return this._y}set width(e){U.assertNumber(e,"Rectangle.width",!this._allowNegative),this._width=e}get width(){return this._width}set height(e){U.assertNumber(e,"Rectangle.height",!this._allowNegative),this._height=e}get height(){return this._height}set right(e){this._width=e-this._x}get right(){return this._x+this._width}get end(){return this.right}set bottom(e){this._height=e-this._y}get bottom(){return this._y+this._height}getStart(e,t=!0){return t?e?this.right:this.left:this.top}getEnd(e,t=!0){return t?e?this.left:this.right:this.bottom}get area(){return this.width*this.height}set minWidth(e){const t=this;isNaN(e)?t._minWidth=null:(t._minWidth=Number(e),t.isAlignRectangle||(t.width=Math.max(t.width,t._minWidth)))}get minWidth(){return this._minWidth}set minHeight(e){const t=this;isNaN(e)?t._minHeight=null:(t._minHeight=Number(e),t.isAlignRectangle||(t.height=Math.max(t.height,t._minHeight)))}get minHeight(){return this._minHeight}adjust(e,t,n,i,r){const s=this;return s._allowNegative=r,s.x+=e,s.y+=t,s.width+=n,s.height+=i,s}inflate(e,t=e,n=e,i=t){return[e,t,n,i]=Pt(e,t,n,i),this.adjust(-i,-e,t,n)}deflate(e,t=e,n=e,i=t){return[e,t,n,i]=Pt(e,t,n,i),this.adjust(i,e,-t,-n)}constrainTo(e,t){const n=this,i=n.height,r=n.y,s=n.minWidth||n.width,o=n.minHeight||n.height;if(n.height>=e.height){if(t&&o>e.height)return!1;n._y=e.y,n.height=e.height}if(n.width>=e.width){if(t&&s>e.width)return n.y=r,n.height=i,!1;n._x=e.x,n.width=e.width}return n.translate.apply(n,n.constrainVector=[Math.min(e.right-n.right,0),Math.min(e.bottom-n.bottom,0)]),n.translate(Math.max(e.x-n.x,0),Math.max(e.y-n.y,0)),n}alignTo(e){let t,n,i,r,s=this.clone(),{target:o,constrainTo:a,constrainPadding:l,inflate:c}=e;if(o&&(o=o.isRectangle?o.clone():_t.from(o.element?o.element:o),c&&o.inflate.apply(o,Array.isArray(c)?c:[c])),a){if(!a.isRectangle){r=a===globalThis||a===document;const t="ignorePageScroll"in e?e.ignorePageScroll:!r;a=_t.from(a.element?a.element:a,null,t)}l&&(l=At(l),l[0]=Math.min(l[0],o.top),l[1]=Math.min(l[1],a.right-o.right),l[2]=Math.min(l[2],a.bottom-o.bottom),l[3]=Math.min(l[3],o.left),a=a.deflate.apply(a.clone(),l))}const d=this,u=null==(R=e.offset)?kt:"number"==typeof R?[R,R]:R,{align:h,axisLock:g,anchorSize:m,anchorPosition:p,matchSize:f,position:v,rtl:y}=e,b=o&&o.width<2&&o.height<2,C=Lt(h,y),S=a&&a.clone(),w=[],D=[{zone:n=C.startZone,align:h}],E=f&&Ft[1&C.startZone],x=d[E];var R;if(E&&g?s[E]="min"===f?Math.max(s.width,o[E]):o[E]:!C.edgeAligned&&f&&(s.width=o.width,s.height=o.height),a&&s.constrainTo(a),a&&null!=C.startZone)if(g)D.push({zone:n=(n+2)%4,align:Ot(C)}),"flexible"===g&&(D.push({zone:n=(C.startZone+1)%4,align:Mt[n]}),D.push({zone:n=(n+2)%4,align:Mt[n]}));else for(let e=1;e<4;e++)D.push({zone:n=(n+1)%4,align:Mt[n]});if(p){const e=1&C.startZone?"y":"x";t={[e]:p[e],edge:Rt[(C.startZone+2)%4]}}if(S&&o&&(S.adjust(-o.width,-o.height,o.width,o.height),o.constrainTo(S)),s.minWidth=d.minWidth,s.minHeight=d.minHeight,v)s.moveTo(v.x,v.y),s.translate.apply(s,u),a&&s.constrainTo(a);else{const e="c"===C.myEdge||"c"===C.targetEdge,n=m&&!e?[m[1]+u[0],m[1]+u[1]]:u,l=o.getAlignmentPoint(C.targetAlignmentPoint),c=o.getAlignmentPoint(C.targetAlignmentPoint,n);let h=s.getAlignmentPoint(C.myAlignmentPoint),p=!b&&s.clone().translate(l[0]-h[0],l[1]-h[1]).intersect(o,!0);if(s.translate(c[0]-h[0],c[1]-h[1]),p)s.translate(-(c[0]-h[0]),-(c[1]-h[1])),h=s.getAlignmentPoint(C.myAlignmentPoint),s.translate(l[0]-h[0],l[1]-h[1]),s.translate(...n),a&&s.constrainTo(a),i=C.startZone;else if(a&&!a.contains(s)){const e=s.clone(),l=[];let c,u;t=null,w[0]=c=a.clone(),c.bottom=o.y-n[1],w[1]=c=a.clone(),c.x=o.right+n[0],w[2]=c=a.clone(),c.y=o.bottom+n[1],w[3]=c=a.clone(),c.right=o.x-n[0];for(let e=0;e<D.length;e++){if(E&&2===e&&(s[E]=x),c=w[i=D[e].zone],s=s.alignTo({target:o,offsets:n,align:D[e].align}),s.constrainTo(c,!0)&&(l.push({result:s,zone:i}),!u||s.width<d.width||s.height<d.height)){s.align=D[e].align;break}if(!u||c.area>u.area){const e=s.clone();switch(i){case 0:e.moveTo(null,c.bottom-e.height);break;case 1:e.moveTo(c.left);break;case 2:e.moveTo(null,c.top);break;case 3:e.moveTo(c.right-e.width)}u={area:c.area,result:e,zone:i}}}l.length?(l.length>1&&!g&&l.sort(((t,n)=>Math.sqrt((e.x-t.result.x)**2+(e.y-t.result.y)**2)-Math.sqrt((e.x-n.result.x)**2+(e.y-n.result.y)**2))),s=l[0].result,i=l[0].zone):(s=u.result,i=u.zone,r&&s.constrainTo(a))}else i=C.startZone;if(s.overlap=p=!b&&s.intersect(o,!0),s.zone=i,m&&!p){if(!t){const e=1&i,n=e?"y":"x",r=e?"bottom":"right",a=Math.max(o[n],s[n]);let l=a+(Math.min(o[r],s[r])-a)/2-m[0]/2;const c=l+m[0];c>s[r]&&(l-=c-s[r]),l<s[n]&&(l+=s[n]-l),t={[n]:l-s[n],edge:Rt[(i+2)%4]}}s.anchor=t}}return s}getAlignmentPoint(e,t=kt){e=String(e);const n=this,i=xt.exec(e)||Et.exec(e),r=i&&i[1].toLowerCase(),s=i&&Math.min(Math.max(parseInt(i[2]||50),0),100)/100;switch(r){case"t":return[n.x+n.width*s,n.y-t[1]];case"r":return[n.right+t[0],n.y+n.height*s];case"b":return[n.x+n.width*s,n.bottom+t[1]];case"l":return[n.x-t[0],n.y+n.height*s];case"c":return[n.x+n.width/2,n.y+n.height/2]}}highlight(){const e=this,t=ki.createElement({parent:document.body,style:`position:absolute;z-index:9999999;pointer-events:none;\n                            left:${e.x}px;top:${e.y}px;width:${e.width}px;height:${e.height}px`});return ki.highlight(t).then((()=>t.remove()))}visualize(e,t=!1,n=!1){const i=this,r=U.merge({style:{width:`${i.width}px`,height:`${i.height}px`,pointerEvents:"none",...e.class?{}:{position:"absolute","z-index":9999999},...n?{insetInlineStart:i.x,top:i.y}:{left:0,top:0,transform:`translate(${i.x}px, ${i.y}px)`}}},e);return t?r:ki.createElement(r)}toString(e=","){return[`${this.top}px`,`${this.right}px`,`${this.bottom}px`,`${this.left}px`].join(e)}}class jt extends _t{static from(e,t=!0){const n=t?"client":"screen";e.changedTouches&&(e=e.changedTouches[0]);return new this(e[`${n}X`],e[`${n}Y`])}constructor(e,t){super(e,t,0,0)}constrain(e){return this.x=Math.min(Math.max(this.x,e.x),e.right-1),this.y=Math.min(Math.max(this.y,e.y),e.bottom-1),this}toArray(){return[this.x,this.y]}}_t._$name="Rectangle";const Bt=Symbol("value"),Vt=Symbol("length");class Ht{static change(e,t,n,i="string"){n=Ht.normalize(n,"object");const r=Ht.normalize(e,"array").filter((e=>!n[e]));if(t){t=Ht.normalize(t,"array");for(let e=0;e<t.length;++e)r.includes(t[e])||r.push(t[e])}return Ht.normalize(r,i)}static from(e,t){return e&&(e.isDomClassList?t=t??!0:(t=t??(C.isObject(e)&&!C.isEmpty(e)),e=new Ht(e)),e.value||t||(e=null)),e||(t?new Ht:null)}static normalize(e,t="string"){const n=typeof(e=e||""),i="array"===t,r=!i&&!("object"===t);let s,o,a,l="string"===n;var c;"object"===n&&(e.nodeType===Element.ELEMENT_NODE&&"function"==typeof e.getAttribute?(e=e.getAttribute("class")||"",l=!0):null!==(c=e)&&void 0!==c&&c.isDomClassList?e=e.values:e instanceof DOMTokenList?e=Array.from(e):e instanceof Map?e=Array.from(e.keys()).filter((t=>e.get(t))):e instanceof Set?e=Array.from(e):Array.isArray(e)||(e=C.getTruthyKeys(e)));for(l&&(e=V.split(e)),o=e.length;o-- >0;)s=e[o],s.length?s.includes(" ")&&e.splice(o,1,...V.split(s)):e.splice(o,1);if(e=[...new Set(e)],i)a=e;else if(r)a=e.join(" ");else for(a=Object.create(null),o=0;o<e.length;++o)a[e[o]]=!0;return a}constructor(...e){this.process(1,e)}clear(){for(const e in this)this[e]=!1;return this}set(...e){return this.clear().process(1,e)}get isDomClassList(){return!0}clone(){return new Ht(this)}contains(e){return!("string"!=typeof e||!e)&&Boolean(this[e])}toString(){return this.length?`${this.value} `:""}toJSON(){return this.toString()}trim(){return this.value}isEqual(e){const t=Ht.normalize(e,"array"),n=t.length;if(this.length===n){for(let e=0;e<n;e++)if(!this[t[e]])return!1;return!0}return!1}get value(){let e,t=this[Bt];return null==t&&(e=C.getTruthyKeys(this),this[Vt]=e.length,this[Bt]=t=e.join(" ")),t}set value(e){const t=this,n=Object.keys(t),i=n.length;for(let e=0;e<i;e++)delete t[n[e]];e?t.process(1,[e]):delete t[Bt]}get values(){return C.getTruthyKeys(this)}get length(){return this.value?this[Vt]:0}process(e,t){for(let n,i,r=0;r<t.length;r++)if(t[r])if(n=t[r],n.isDomClassList||C.isObject(n))for(i in n)this[i]=e?n[i]:!n[i];else for(n=Ht.normalize(t[r],"array"),i=0;i<n.length;++i)this[n[i]]=e;return delete this[Bt],this}assign(e){for(const t in e)!this[t]!=!e[t]&&(this[t]=e[t],delete this[Bt]);return this}assignTo(e){const t=e.nodeType===Element.ELEMENT_NODE?e.classList:e,n=Ht.from(t);n.add(this),t.value=n.value}add(...e){return this.process(1,e)}remove(...e){return this.process(0,e)}toggle(e,t=Boolean(!this[e])){if(t=Boolean(t),Boolean(this[e])!==t)return this[e]=t,delete this[Bt],!0}split(){return C.getTruthyKeys(this)}forEach(e){return C.getTruthyKeys(this).forEach(e)}}function zt(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var i=n.call(e,t||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Ht.prototype[Bt]=null,Ht._$name="DomClassList";const Nt=()=>performance.now();class Wt{constructor(e){const t=this;t.id=e.pointerId,t.downEvent=t.event=e,t.t0=Nt(),t.xy=t.xy0=[e.pageX,e.pageY]}get distance(){const[e,t]=this.dxy;return Math.sqrt(e*e+t*t)}get dt(){return Nt()-this.t0}get dxy(){const{xy:e,xy0:t}=this,n=e[0]-t[0],i=e[1]-t[1];return[n,i,Math.abs(n),Math.abs(i),...e]}clone(){const e=this,t=new Wt(e.downEvent);return t.t0=e.t0,t.xy=e.xy.slice(),t.xy0=e.xy0.slice(),t}track(e){this.event=e,this.xy=[e.pageX,e.pageY]}}class Ut extends tt{static configurable={currentEvent:null};construct(...e){this.active=[],this.current=null,super.construct(...e)}get empty(){return!this.length}get length(){return this.active.length}get primary(){return this.active[0]??null}get secondary(){return this.active[1]??null}get single(){return 1===this.length}clone(){const e=new Ut,{current:t,currentEvent:n}=this;let i,r;for(r of this.active)e.active.push(i=r.clone()),r===t&&(e.current=i);return e.current||(e.current=null==t?void 0:t.clone()),e._currentEvent=n,e}get(e){let t,n=null;for(t of this.active)if(t.id===e){n=t;break}return n}track(e){return this.currentEvent=e,this}updateCurrentEvent(e){const t=this,n=e.type.slice(7);let i=t.get(e.pointerId);var r;("move"!==n&&(t.active=t.active.filter((e=>e!==i))),"down"===n)?t.active.push(i=new Wt(e)):null===(r=i)||void 0===r||r.track(e);t.current=i}}Ut.initClass(),Ut._$name="Pointers";const{defineProperty:Gt}=Reflect;let qt;qt=d.isBrowserEnv?globalThis.performance:{now:()=>(new Date).getTime()};let Yt=null;if(q.isTestEnv){const e=globalThis.bryntum||(globalThis.bryntum={});Yt=e.globalDelays={timeouts:new Map,intervals:new Map,animationFrames:new Map,idleCallbacks:new Map,isEmpty:(e=!1)=>Yt.timeouts.size+Yt.animationFrames.size+Yt.idleCallbacks.size+(e?Yt.intervals.size:0)===0,getFiltered({ignoreTimeouts:e=[],maxDelay:t=5e3,includeIntervals:n=!1}){const i=[],r=["timeouts","animationFrames","idleCallbacks"];n&&r.push("intervals");for(const n of r){const r=Yt[n];for(const[,n]of r.entries())e.includes(n.name)||Number.isInteger(n.delay)&&!(n.delay<t)||i.push(n)}return i}}}const Kt=Promise.resolve(),Xt=Object.freeze([]),Zt=()=>{},Jt=Object.freeze({}),Qt=globalThis.queueMicrotask,en=(e,t,n,i)=>{const r="string"==typeof t,s=(null==i?void 0:i.appendArgs)||Xt,o=()=>{n.timerId=null,n.lastCallTime=qt.now();const i=n.args;n.args=null,r?e[t](...i,...s):t.call(e,...i,...s),n.called=!0,++n.calls};return e=(null==i?void 0:i.thisObj)||e,n.lastCallTime=-9e9,n.calls=0,n.suspended=null==i?void 0:i.suspended,n.invoker=o,o.wrapFn=n,o.fn=t,o.this=e,o},tn=(e,t,n="clearTimeout")=>(t.cancel=()=>{t.isPending&&(e[n](t.timerId),t.args=t.timerId=null)},t.flush=()=>{t.isPending&&(e[n](t.timerId),t.timerId=null,t.invoker())},t.now=(...e)=>{t.cancel(),t.args=e,t.invoker()},t.resume=e=>{const n=t.suspended;t.suspended=e||n<1?0:n-1},t.suspend=()=>{++t.suspended},t.immediate=!1,t.suspended=t.suspended?1:0,t.timerId=null,Gt(t,"isPending",{get:()=>null!==t.timerId}),t);var nn=e=>class extends(e||tt){static $name="Delayable";static get declarable(){return["delayable"]}doDestroy(){super.doDestroy(),this.clearDelayables()}clearDelayables(){const e=this,[t,n,i,r,s,o]=[e.idleCallbackIds,e.animationFrameIds,e.intervalIds,e.timeoutMap,e.timeoutIds,e.microtasksPending];e.idleCallbackIds=e.animationFrameIds=e.intervalIds=e.timeoutMap=e.timeoutIds=e.microtasksPending=null,null==s||s.forEach(((e,t)=>{var n;"function"==typeof e&&e(),clearTimeout(t),null===(n=Yt)||void 0===n||n.timeouts.delete(t)})),null==r||r.forEach(((e,t)=>clearTimeout(t))),null==i||i.forEach((e=>{var t;clearInterval(e),null===(t=Yt)||void 0===t||t.intervals.delete(e)})),null==n||n.forEach((e=>{var t;cancelAnimationFrame(e),null===(t=Yt)||void 0===t||t.animationFrames.delete(e)})),null==t||t.forEach((e=>{var t;cancelIdleCallback(e),null===(t=Yt)||void 0===t||t.idleCallbacks.delete(e)})),null==o||o.forEach((e=>e.cancel()))}hasTimeout(e){var t;return Boolean(null===(t=this.timeoutMap)||void 0===t?void 0:t.has(e))}asap(e,t){const n=this,i=(...e)=>{i.suspended||(i.called=!1,i.args=e,i.immediate?r():i.isPending||(i.timerId=n.queueMicrotask(r)))},r=en(n,e,i,t);return tn(n,i,"cancelMicrotask")}queueMicrotask(e,t,n){let i,r;n||!t||Array.isArray(t)||(n=t,t=null),n=n||Jt,t=t||n.args||Xt;const s=this,o="string"==typeof e,a=o?e:e.name,l=s.microtasksPending||(s.microtasksPending=new Map),c=()=>l.delete(i),d=()=>{r===l.get(i)&&(l.delete(i),o?!s.isDestroyed&&s[e](...t):e.apply(s,t))};return s.isDestroying&&!n.runOnDestroy?Zt:(i=n.cancelOutstanding?a||e:c,r={key:i,name:a,fn:e,args:t,options:n,cancel:c,wrapFn:d},c.taskDef=r,Qt?Qt(d):Kt.then(d),l.set(i,r),c)}cancelMicrotask(e){null==e||e()}setTimeout({fn:e,delay:t,name:n,runOnDestroy:i,cancelOutstanding:r,args:s}){var o;(arguments.length>1||"function"==typeof arguments[0])&&([e,t,n,i,r]=arguments),"string"==typeof e?n=e:n||(n=e.name||e),r&&this.clearTimeout(n);const a=this,l=a.timeoutIds||(a.timeoutIds=new Map),c=a.timeoutMap||(a.timeoutMap=new Map),d=setTimeout((()=>{var t;"string"==typeof e&&(e=a[n]),null==l||l.delete(d),null==c||c.delete(n),null===(t=Yt)||void 0===t||t.timeouts.delete(d),e.apply(a,s)}),t);return l.set(d,!i||e),null===(o=Yt)||void 0===o||o.timeouts.set(d,{fn:e,delay:t,name:n}),n&&c.set(n,d),d}clearTimeout(e){var t,n;let i=e;if("string"==typeof i){if(!this.timeoutMap)return;i=this.timeoutMap.get(e),this.timeoutMap.delete(e)}clearTimeout(i),null===(t=this.timeoutIds)||void 0===t||t.delete(i),null===(n=Yt)||void 0===n||n.timeouts.delete(i)}clearInterval(e){var t,n;clearInterval(e),null===(t=this.intervalIds)||void 0===t||t.delete(e),null===(n=Yt)||void 0===n||n.intervals.delete(e)}setInterval(e,t,n){var i;const r=setInterval(e,t);return(this.intervalIds||(this.intervalIds=new Set)).add(r),null===(i=Yt)||void 0===i||i.intervals.set(r,{fn:e,delay:t,name:n}),r}requestAnimationFrame(e,t=[],n=this){var i;const r=this.animationFrameIds||(this.animationFrameIds=new Set),s=requestAnimationFrame((()=>{var i;null===(i=Yt)||void 0===i||i.animationFrames.delete(s),r.delete(s)&&e.apply(n,t)}));return r.add(s),null===(i=Yt)||void 0===i||i.animationFrames.set(s,{fn:e,extraArgs:t,thisObj:n}),s}requestIdleCallback(e,t=[],n=this){var i;const r=this.idleCallbackIds||(this.idleCallbackIds=new Set),s=requestIdleCallback((()=>{var i;null===(i=Yt)||void 0===i||i.idleCallbacks.delete(s),r.delete(s)&&e.apply(n,t)}));return r.add(s),null===(i=Yt)||void 0===i||i.idleCallbacks.set(s,{fn:e,extraArgs:t,thisObj:n}),s}createOnFrame(e,t=[],n=this,i){let r;const s=(...s)=>{null!=r&&i&&(this.cancelAnimationFrame(r),r=null),null==r&&(r=this.requestAnimationFrame((()=>{"string"==typeof e&&(e=n[e]),r=null,s.push(...t),e.apply(n,s)})))};return s.cancel=()=>this.cancelAnimationFrame(r),s}cancelAnimationFrame(e){var t,n;cancelAnimationFrame(e),null===(t=this.animationFrameIds)||void 0===t||t.delete(e),null===(n=Yt)||void 0===n||n.animationFrames.delete(e)}cancelIdleCallback(e){var t,n;cancelIdleCallback(e),null===(t=this.idleCallbackIds)||void 0===t||t.delete(e),null===(n=Yt)||void 0===n||n.idleCallbacks.delete(e)}async nextAnimationFrame(){return new Promise((e=>this.requestAnimationFrame(e)))}buffer(e,t){let n=t;t&&"number"!=typeof t?n=t.delay:t=null;const i=(...e)=>{if(i.suspended)return;const{delay:t}=i;i.cancel(),i.called=!1,i.args=e,i.immediate||!t?r():i.timerId=this.setTimeout(r,t)},r=en(this,e,i,t);return i.delay=n,tn(this,i)}raf(e,t){let n=t;t&&"boolean"!=typeof t?n=t.cancelOutstanding:t=null;const i=(...e)=>{i.suspended||((i.cancelOutstanding||i.immediate)&&i.cancel(),i.called=!1,i.args=e,i.immediate?r():i.isPending||(i.timerId=this.requestAnimationFrame(r)))},r=en(this,e,i,t);return i.cancelOutstanding=n,i.raf=!0,tn(this,i,"cancelAnimationFrame")}idle(e,t){let n=t;t&&"boolean"!=typeof t?n=t.cancelOutstanding:t=null;const i=(...e)=>{i.suspended||((i.cancelOutstanding||i.immediate)&&i.cancel(),i.called=!1,i.args=e,i.immediate?r():i.isPending||(i.timerId=this.requestIdleCallback(r)))},r=en(this,e,i,t);return i.cancelOutstanding=n,this.setTimeout((()=>this.idleCallbackIds.delete(i.timerId)&&i.now()),100),tn(this,i,"cancelIdleCallback")}throttle(e,t){let n,i=t;t&&"number"!=typeof t?(i=t.delay,n=t.throttled):t=null;const r=this,s=(...e)=>{if(s.suspended)return;const{delay:t}=s,i=qt.now()-s.lastCallTime;s.args=e,s.immediate||i>=t?(r.clearTimeout(s.timerId),o()):(s.isPending||(s.timerId=r.setTimeout(o,t-i),s.called=!1),n&&(n.wrapFn.args=e,n()))},o=en(r,e,s,t);return s.delay=i,n&&(n=en(r,n,(()=>{}),t)),tn(r,s)}static setupDelayable(e){e.setupDelayableMethods(e.delayable)}static setupDelayableMethods(e,t=null){const n=e.static,i=t||this.prototype;n&&delete e.static;for(const t in e){let n=e[t];const r=t+"Now",s=typeof n;i[r]||(i[r]=i[t]),"number"===s?n={type:"buffer",delay:n}:"string"===s&&(n={type:n}),Gt(i,t,{get(){const e=this;if(e.isDestroyed)return;const i=(...t)=>e[r](...t),s=e[n.type](i,n);return Gt(e,t,{value:s,configurable:!0,writable:!0}),i.methodName=t,s}})}}get widgetClass(){}};const rn=U.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null)),sn={string:1,number:1};var on=e=>class extends(e||tt){static $name="Identifiable";static get declarable(){return["identifiable"]}static get configurable(){return{id:""}}static setupIdentifiable(e,t){const{identifiable:n}=e;n.idMap=Object.create(null),Reflect.defineProperty(e,"identifiable",{get:()=>n})}doDestroy(){this.constructor.unregisterInstance(this),super.doDestroy()}changeId(e){return(this.hasGeneratedId=!e)?this.generateAutoId():e}updateId(e,t){const n=this,i=n.constructor;t&&i.unregisterInstance(n,t),n.hasGeneratedId&&!1===i.identifiable.registerGeneratedId||i.registerInstance(n,e)}generateAutoId(){return this.constructor.generateId(`b-${this.$$name.toLowerCase()}-`)}static get all(){return Object.values(this.identifiable.idMap)}static generateId(e="generatedId"){return e+(rn[e]=(rn[e]||0)+1)}static registerInstance(e,t=e.id){const{idMap:n}=this.identifiable;if(t in n&&!this.disableThrow)throw new Error("Id "+t+" already in use");n[t]=e}static unregisterInstance(e,t=e.id){const{idMap:n}=this.identifiable;sn[typeof e]?delete n[e]:n[t]===e&&delete n[t]}static getById(e){const t=this.identifiable.idMap;if(t)return t[e]}static get registeredInstances(){const e=this.identifiable.idMap;return e?Object.values(e):[]}};const an=e=>"touch"===e.pointerType,ln=()=>performance.now();class cn extends(tt.mixin(dt)){static configurable={gestureClass:null,options:null};isEqual(e,t){return this.gestureClass===e&&l.Object.isEqual(this.options,t)}start(e){const t=this,n=l.Object.clone(t.options)||{};n.element=e.element,n.handler=t,n.recognition=e;const i=new t.gestureClass(n);return i.onBegin(),i}}cn.initClass();class dn extends(tt.mixin(nn,on)){static $name="Gesture";static configurable={durationLimit:null,element:{value:null,$config:"nullify"},handler:null,idleLimit:null,recognition:null,state:null,targetEvents:null};static declarable=["fires"];static identifiable={};static gestureName="none";static registry=Object.create(null);static touchPoints=0;static begin(e){const{touchPoints:t}=this;return!t||t===e.length}static setupFires(e){e.fires.forEach((t=>dn.registry[t.toLowerCase()]=dn.registry[t]=e))}static getRecognizer(e,t,n=!0){const{registry:i}=this;return[dn.Recognizer.from(e,n),i[t]||i[t.toLowerCase()]]}static is(e){const{registry:t}=this;return e in t||e.toLowerCase()in t}static on(e,t,n,i){const[r,s]=this.getRecognizer(e,t);r.on(s,t,n,i)}static un(e,t,n){const[i,r]=this.getRecognizer(e,t,!1);null!=i&&i.un(r,t,n)&&!i.handlers.length&&i.destroy()}get elapsedTime(){return ln()-this.startTime}get gestureName(){return this.constructor.gestureName}get recognized(){return Boolean(this.state)}set recognized(e){const t=this,{recognition:n}=t,{gestures:i}=n;e?t.state||!1!==t.beforeStart()&&(n.recognized=t,t.state="active"):i.includes(t)&&(n.gestures=i.filter((e=>e!==t)),"active"===t.state?t.cancel():t.destroy())}get pointers(){return this.recognition.recognizer.pointers}beforeStart(){return this.trigger("before"+this.gestureName)}cancel(){"active"===this.state&&(this.state="cancel")}end(){"active"===this.state&&(this.state="done")}getDetails(e){var t;const{pointers:n}=this;return{...e,event:null===(t=n.current)||void 0===t?void 0:t.event,gesture:this,pointers:n.clone()}}move(e){this.unrecognize(e)&&this.cancel(e)}onBegin(){this.startTime=this.lastTime=ln()}onCancel(){this.trigger(this.gestureName+"Cancel")}onEnd(){this.trigger(this.gestureName)}onStart(){this.trigger(this.gestureName+"Start")}recognize(e){var t;const{durationLimit:n,elapsedTime:i,idleLimit:r,lastTime:s}=this,o=ln();if(null!==(t=e.currentEvent)&&void 0!==t&&t.defaultPrevented||n&&i>n||r&&o>s+r)return!1;this.lastTime=o}reset(){var e;null===(e=this.recognition)||void 0===e||null===(e=e.recognizer)||void 0===e||e.reset()}toString(){return this.constructor.$$name}trigger(e,t){const n=this,{registry:i}=n.constructor;if(e in i||e.toLowerCase()in i)return n.handler.trigger(e,n.getDetails(t))}unrecognize(e){return!1===this.recognize(e)}updateElement(e){var t;const n=this,{targetEvents:i}=n;null===(t=n.unlisten)||void 0===t||t.call(n),n.unlisten=e&&i&&l.Event.on(l.Object.assign({thisObj:n,element:e},i))}updateState(e){const t=this;"active"===e?t.onStart():"cancel"===e?(t.onCancel(),t.reset()):"done"===e&&(t.onEnd(),t.reset())}static#e=(()=>{zt(this,"Recognizer",class extends(tt.mixin(on)){static $name="Recognizer";static configurable={element:{value:null,$config:"nullify"},handlers:[],recognition:null};static identifiable={};static from(e,t=!0){let n=l.Dom.getExpando(e,"gestures");return!n&&t&&l.Dom.setExpando(e,"gestures",n=new dn.Recognizer({element:e})),n}get pointers(){return this._pointers||(this._pointers=new Ut)}changeHandlers(e){return(null==e?void 0:e.slice())||[]}filterHandlers(e){const{pointers:t}=this;return t.currentEvent=e,this.handlers.filter((e=>e.gestureClass.begin(t)))}on(e,t,n,i){const r=this,{handlers:s}=r;let o=s.find((t=>t.isEqual(e,i)));o||(o=new cn({gestureClass:e,options:i}),r.handlers=[...s,o]),o.on({[t]:n})}un(e,t,n){const i=this,{handlers:r}=i,s={[t]:n};for(const t of r)if(t.gestureClass===e&&t.un(s))return t.hasListener()||(i.handlers=r.filter((e=>e!==t)),t.destroy()),!0}onPointerCancel(e){if(an(e)){var t;const n=this,{pointers:i}=n;i.currentEvent=e,null===(t=n.recognition)||void 0===t||t.cancel(i),n.reset()}}onPointerDown(e){if(an(e)){var t;const n=this,i=n.pointers.track(e),r=n.handlers.filter((e=>e.gestureClass.begin(i)));null===(t=n.recognition)||void 0===t||t.destroy(),n.recognition=r.length&&new dn.Recognition({element:n.element,recognizer:n,currentEvent:e,startEvent:e,gestures:r})||null}}onPointerUp(e){if(an(e)){var t;const n=this,{pointers:i}=n;i.currentEvent=e,null===(t=n.recognition)||void 0===t||t.onPointerUp(i),n.reset()}}updateElement(e,t){var n;const i=this;i.reset(),null===(n=i.unlisten)||void 0===n||n.call(i),i.unlisten=e&&l.Event.on({thisObj:i,passive:!1,pointercancel:"onPointerCancel",pointerdown:"onPointerDown",pointerup:"onPointerUp",element:e}),e&&(e.style.touchAction="none"),l.Dom.removeExpando(t,"gestures",i),l.Dom.setExpando(e,"gestures",i)}reset(){this.destroyMember("recognition")}}),zt(this,"Recognition",class extends(tt.mixin(on)){static $name="Recognition";static configurable={element:null,gestures:null,recognized:null,recognizer:null,startEvent:null};static identifiable={};get pointers(){var e;return null===(e=this.recognizer)||void 0===e?void 0:e.pointers}cancel(e){var t;null===(t=this.recognized)||void 0===t||t.cancel(e)}changeGestures(e){return null==e?void 0:e.map((e=>e.isGesture?e:e.start(this)))}doDestroy(){this.destroyMember("gestures"),this.element=null,super.doDestroy()}onPointerUp(e){var t;return null===(t=this.recognized)||void 0===t?void 0:t.end(e)}onPointerMove(e){if(an(e)){var t;const n=this,{gestures:i,pointers:r}=n;let s,o,{recognized:a}=n;if(r.currentEvent=e,!a)for(s of i)if(o=s.recognize(r),!1!==o&&!0!==o||(s.recognized=o),a=n.recognized,a)break;return null===(t=a)||void 0===t?void 0:t.move(r)}}updateElement(e){var t;null===(t=this.unlisten)||void 0===t||t.call(this),this.unlisten=e&&l.Event.on({thisObj:this,passive:!1,pointermove:"onPointerMove",element:e})}updateGestures(e){var t;(null==e||!e.length)&&(null===(t=this.recognizer)||void 0===t||t.reset())}updateRecognized(e){const t=this,{gestures:n}=t,i=n.filter((t=>t!==e));if(n.length===i.length)throw new Error(`Gesture is not active for element ${t.element.id}: ${e}`);tt.destroy(i),t.gestures=[e]}})})()}dn.initClass(),dn.Recognition.initClass(),dn.Recognizer.initClass(),dn._$name="Gesture";class un extends dn{static $name="LongPress";static gestureName="longPress";static configurable={duration:700,native:null,targetEvents:{contextmenu:"onContextMenu"},tolerance:5};static fires=["beforeLongPress","longPress"];static touchPoints=1;detect(){this.recognized=!0,this.end()}onContextMenu(e){"touch"===e.pointerType&&(e.preventDefault(),!1!==this.native&&this.detect())}recognize(e){let t=super.recognize(e);if(!1!==t){const[,,n,i]=e.current.dxy;Math.max(n,i)>this.tolerance&&(t=!1)}return t}updateDuration(e){e&&this.setTimeout((()=>this.detect()),e)}}un.initClass(),un._$name="LongPress";const hn=(e,t,n)=>Math.abs(t)<n?"":`${t<0?"-":"+"}${e}`;class gn extends dn{static $name="Swipe";static gestureName="swipe";static configurable={axis:null,durationLimit:700,idleLimit:250,targetEvents:{contextmenu:"onContextMenu",scroll:{capture:!0,handler:"onTargetScroll"}},threshold:80,tolerance:100};static fires=["beforeSwipe","swipe","swipeStart","swipeCancel"];static touchPoints=1;getDetails(e){const t=this,n=t.pointers.current;if(n){const[i,r,s,o,a,l]=n.dxy;e={...e,swipe:t.axis,dx:i,dy:r,adx:s,ady:o,x:a,y:l}}else e={...e,swipe:t.axis};return super.getDetails(e)}onContextMenu(e){"touch"===e.pointerType&&(this.recognized=!1)}onTargetScroll(){this.recognized=!1}recognize(e){let t=super.recognize(e);if(!1!==t){const n=this,{axis:i,threshold:r,tolerance:s}=n,[o,a,l,c]=e.current.dxy,d=hn("x",o,r)+hn("y",a,r);!o&&!a||l>s&&c>s||i&&i!==d?t=!1:d&&(n.axis=d,t=!0)}return t}}gn.initClass(),gn._$name="Swipe";const mn=["clientX","clientY","pageX","pageY","screenX","screenY"],pn={element:1,expires:1,handler:1},fn={element:1,thisObj:1,once:1,delegate:1,delay:1,capture:1,passive:1,throttled:1,autoDetach:1,expires:1,block:1,raw:1,fromGlobal:1},vn={Spacebar:"Space",Del:"Delete",Esc:"Escape",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown"},yn={Control:"ctrl",Alt:"alt",Shift:"shift",Meta:"meta"},bn=/^(ctrl|shift|alt|meta)$/,Cn=["altKey","bubbles","button","buttons","cancelable","clientX","clientY","ctrlKey","layerX","layerY","metaKey","pageX","pageY","returnValue","screenX","screenY","shiftKey"],Sn=Object.fromEntries("abcdefghijklmnopqrstuvwxyz".split("").map((e=>[e,e.toUpperCase()]))),wn=((...e)=>e.reduce(((e,t)=>{for(let n=0,i=e.length;n<i;++n)e.push(n?`${e[n]}+${t}`:t);return e}),[""]))("Ctrl","Alt","Meta","Shift"),Dn=e=>wn[(e.ctrlKey&&1)|(e.altKey&&2)|(e.metaKey&&4)|(e.shiftKey&&8)],{isSafari:En,isMobileSafari:xn}=d,Rn=new WeakMap,Tn=e=>(null==e?void 0:e.nodeType)===Element.TEXT_NODE?e.parentElement:e;class Mn{static $name="EventHelper";static eventNameMap={mousedown:"MouseDown",mouseup:"MouseUp",click:"Click",dblclick:"DblClick",contextmenu:"ContextMenu",mouseenter:"MouseEnter",mouseleave:"MouseLeave",mousemove:"MouseMove",mouseover:"MouseOver",mouseout:"MouseOut",keyup:"KeyUp",keydown:"KeyDown",keypress:"KeyPress"};static normalizeEvent(e){return U.copyPropertiesIf(e,e.changedTouches[0]||e.touches[0],mn)}static copyEvent(e,t){return U.copyProperties(e,t,Cn)}static getXY(e){return e.touches&&(e=e.touches[0]),[e.clientX,e.clientY]}static getDistanceBetween(e,t,n){const i=In.getXY(e),r=In.getXY(t),s=i[0]-r[0],o=i[1]-r[1];return null!=n&&n.x?s:null!=n&&n.y?o:Math.sqrt(Math.pow(s,2)+Math.pow(o,2))}static getPagePoint(e){return new jt(e.pageX,e.pageY)}static getClientPoint(e){return new jt(e.clientX,e.clientY)}static addListener(e,t,n,i){return i=e.nodeType?"string"==typeof t?Object.assign({element:e,[t]:n},i):Object.assign({element:e},t):e,In.on(i)}static on(e){const t=e.element,n=e.thisObj,i=[];for(const n in e)if(!fn[n]){let r=e[n];"object"!=typeof r&&(r={handler:r});const s=r.element||t;i.push(In.addElementListener(s,n,r,e))}const r=()=>{for(let e,t=0;t<i.length;t++)e=i[t],In.removeEventListener(e[0],e[1],e[2]);i.length=0};return n&&!1!==e.autoDetach&&(n.doDestroy=te.createInterceptor(n.doDestroy,r,n)),r}static addElementListener(e,t,n,i){const r=In.createHandler(e,t,n,i),{spec:s}=r,o=n.expires||i.expires,a=null!=s.capture||null!=s.passive?{capture:s.capture,passive:s.passive}:void 0;if(dn.is(t)?dn.on(e,t,r,l.Object.filter(n,((e,t)=>!pn[t]))):e.addEventListener(t,r,a),o){const s=n.thisObj||i.thisObj,a=null!=s&&s.isDelayable?s:globalThis,{alt:l}=o,c=l?o.delay:o,{spec:d}=r;d.expires=o,d.timerId=a["number"==typeof c?"setTimeout":"requestAnimationFrame"]((()=>{d.timerId=null,In.removeEventListener(e,t,r),l&&!r.called&&("string"==typeof l?s[l]:l).call(s)}),c,`listener-timer-${performance.now()}`)}return[e,t,r,a]}static getComposedPathTarget(e){var t;return e.composedPath()[0]||(null===(t=e.path)||void 0===t?void 0:t[0])}static fixEvent(e,t){var n;if(e.isBryntumEvent)return e;if(Rn.has(e))return Rn.get(e);const{ctrlKey:i,metaKey:r,type:s,target:o}=e,a=this.getComposedPathTarget(e),l="open"===(null==a||null===(n=a.getRootNode)||void 0===n||null===(n=n.call(a))||void 0===n?void 0:n.mode),c={set(e,t,n){var i;return t in e&&null!==(i=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(e),"type"))&&void 0!==i&&i.set?Reflect.set(e,t,n):(c[t]=n,!0)},get(e,t){if(U.hasOwn(c,t))return c[t];switch(t){case"fixed":case"isBryntumEvent":return!0;case"key":return vn[e.key]||e.key;case"code":return" "!==e.key||e.code?e.code:"Space";case"ctrlKey":return d.isMac&&r!==i?r:i;case"metaKey":return d.isMac&&r!==i?i:r;case"virtualKey":return(e=>{const t=[Dn(e)],{code:n,key:i}=e;return t[t[0]?1:0]=null!=n&&n.includes("Numpad")?n:Sn[i]||i,t.join("+")})(u);case"virtualModKeys":return Dn(u);case"borderOffsetX":return isNaN(e.offsetX)?void 0:e.offsetX+(En?0:parseInt(o.ownerDocument.defaultView.getComputedStyle(Tn(o)).getPropertyValue("border-left-width")));case"borderOffsetY":return isNaN(e.offsetY)?void 0:e.offsetY+(En?0:parseInt(o.ownerDocument.defaultView.getComputedStyle(Tn(o)).getPropertyValue("border-top-width")));case"target":return l?a:Tn(e.target);case"relatedTarget":return Tn(e.relatedTarget);case"originalTarget":return o;case"deepTarget":return a;case"currentTarget":return c.delegatedTarget||e.currentTarget;case"browserEvent":return e;case"timeStamp":xn&&(c.timeStamp||(c.timeStamp=Date.now()));default:if(t in c)return c[t];{const n=Reflect.get(e,t);return"function"==typeof n?n.bind(e):n}}},has:(e,t)=>t in e||t in c},u=new Proxy(e,c);if(Rn.set(e,u),s.startsWith("touch")&&this.normalizeEvent(u),!t)switch(s){case"keydown":Hi.currentKeyDown=u;break;case"mousedown":Hi.currentMouseDown=u;break;case"pointerdown":Hi.currentPointerDown=u;break;case"touchstart":Hi.currentTouch=u}return u}static createHandler(e,t,n,i){const r=dn.is(t),s=n.delay||i.delay,o=n.throttled||i.throttled,a=n.block||i.block,l="once"in n?n.once:i.once,c="capture"in n?n.capture:i.capture,d="passive"in n?n.passive:i.passive,u="delegate"in n?n.delegate:i.delegate,h="fromGlobal"in n?n.fromGlobal:i.fromGlobal,g=n.handler,m=n.expires,p=n.thisObj||i.thisObj;let f=(...e)=>{const t=e[0];In.playingDemo&&t.isTrusted||null!=p&&p.isDestroyed||(f.called=!0,r||(e[0]=In.fixEvent(t,h)),"string"==typeof g?p[g](...e):g.apply(p,e))};if(a){const e=f;let t,n;f=(i,...r)=>{const s=performance.now();(!t||i.target!==n||s-t>a)&&(n=i.target,t=s,e(i,...r))}}if(null!=s){const e=f,t=null!=p&&p.setTimeout?p:globalThis;f=(...n)=>{t.setTimeout((()=>{e(...n)}),s)}}if(null!=o){let e,t=o;o.buffer&&(e=e=>o.alt.call(In,In.fixEvent(e,h)),t=o.buffer),f=null!=p&&p.isDelayable?p.throttle(f,{delay:t,throttled:e}):te.createThrottled(f,t,p,null,e)}if(l){const n=f;f=(...i)=>{In.removeEventListener(e,t,f),n(...i)}}if(u){const e=f;f=(t,...n)=>{var i,r;const s=null===(i=(r=(t=In.fixEvent(t,h)).target).closest)||void 0===i?void 0:i.call(r,u);s&&(t.delegatedTarget=s,e(t,...n))}}return n.thisObj&&!1!==n.autoDetach&&(p.doDestroy=te.createInterceptor(p.doDestroy,(()=>In.removeEventListener(e,t,f)),p)),f.spec={delay:s,throttled:o,block:a,once:l,thisObj:p,capture:c,expires:m,passive:d,delegate:u},f}static removeEventListener(e,t,n){const{expires:i,timerId:r,thisObj:s,capture:o}=n.spec;if(null!=i&&i.alt&&r){(null!=s&&s.isDelayable?s:globalThis)["number"==typeof i.delay?"clearTimeout":"cancelAnimationFrame"](r)}dn.is(t)?dn.un(e,t,n):e.removeEventListener(t,n,o)}static onTransitionEnd({element:e,animationName:t,property:n,handler:i,mode:r=(t?"animation":"transition"),duration:s=ki[`get${"transition"===r?"Property":""}${V.capitalize(r)}Duration`](e,n),timeout:o,thisObj:a=globalThis,args:l=[],timerSource:c,runOnDestroy:d}){let u,h;c=c||(a.isDelayable?a:globalThis);const{isDelayable:g}=c,m=performance.now(),p=`transitionTimer${m}`,f=`timeoutTimer${m}`,v=[e,n,...l],y=()=>{var e;(b(),a.isDestroyed)||(null!==(e=a.$meta)&&void 0!==e&&e.class.isBase?a.callback(i,a,v):i.apply(a,v))},b=In.on({element:e,[`${r}end`]({animationName:i,propertyName:r,target:s}){if(s===e&&(r===n||null!=i&&i.match(t))){if(u){var o,a,l,d;if(h)null===(l=(d=c).clearTimeout)||void 0===l||l.call(d,g?f:h);null===(o=(a=c).clearTimeout)||void 0===o||o.call(a,g?p:u),u=null}y()}}});return o&&(h=c.setTimeout(y,Math.max(o,(s||0)+100),f)),null!=s&&(u=c.setTimeout(y,s+50,p,d)),b}static async waitForTransitionEnd(e){return new Promise((t=>{e.handler=t,Mn.onTransitionEnd(e)}))}static createDblClickWrapper(e,t,n){let i,r,s;return()=>{r||(r=In.on({element:e,touchstart:e=>{i=e.changedTouches[0].identifier,e.preventDefault()},touchend:e=>{if(e.changedTouches[0].identifier===i){e.preventDefault(),clearTimeout(s),i=r=null;const o=_t.from(e.changedTouches[0].target,null,!0),a=e.changedTouches[0].pageX-o.x,l=e.changedTouches[0].pageY-o.y,c=Object.assign({browserEvent:e},e),d=new MouseEvent("dblclick",c);Object.defineProperties(d,{target:{value:e.target},offsetX:{value:a},offsetY:{value:l}}),"string"==typeof t&&(t=n[t]),t.call(n,d)}},once:!0}),s=setTimeout((()=>{r(),i=r=null}),In.dblClickTime))}}static toSpecialKey(e,t="ctrlKey"){let n=!1;return!0===e?n=t:"string"==typeof e&&(e=e.toLowerCase()).match(bn)&&(n=`${e}Key`),n}static specialKeyFromEventKey(e){return yn[e]||"no-special-key"}}l.register(Mn);const In=Mn;In.longPressTime=700,In.dblClickTime=300,d.isTouchDevice&&In.on({element:document,touchmove:e=>{e.target.closest(".b-dragging")&&e.preventDefault()},passive:!1,capture:!0}),Mn._$name="EventHelper";const kn={align:"t0-t0"},{DOCUMENT_NODE:Fn,ELEMENT_NODE:An,TEXT_NODE:Pn,DOCUMENT_FRAGMENT_NODE:Ln}=Node,On={text:1,password:1,date:1,search:1,email:1,number:1,time:1,"datetime-local":1,tel:1,url:1,month:1,week:1},{isObject:$n}=U,_n=/[+-]?\d*\.?\d+[eE]?-?\d*/g,jn=_n.source,Bn=new RegExp(`matrix\\((?:${jn}),\\s?(?:${jn}),\\s?(?:${jn}),\\s?(?:${jn}),\\s?(${jn}),\\s?(${jn})`),Vn=new RegExp("matrix3d\\((?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(-?\\d*),\\s?(-?\\d*)"),Hn=new RegExp(`(?:${Bn.source})|(?:${Vn.source})`),zn=new RegExp(`translate(3d|X)?\\((${jn})px(?:,\\s?(${jn})px)?`),Nn=new RegExp(`translate(3d|Y)?\\((${jn})px(?:,\\s?(${jn})px)?`),Wn=/\s+/,Un=/\s*;\s*/,Gn=/\s*:\s*/,qn=/^-?((\d+(\.\d*)?)|(\.?\d+))$/,Yn=/^[\w-]+$/i,Kn="$bryntum",Xn={},Zn={elementData:"",for:"htmlFor",retainElement:""},Jn={tag:1,html:1,text:1,children:1,tooltip:1,style:1,dataset:1,parent:1,nextSibling:1,ns:1,reference:1,class:1,className:1,unmatched:1,onlyChildren:1,listeners:1,compareHtml:1,syncOptions:1,keepChildren:1},Qn=[["f","focusable"],["n","natural"],["p","programmatic"],["t","tabbable"]],ei=(e,t)=>t.reduce(((e,t)=>e[t]||(e[t]=Object.create(null))),e),ti=(...e)=>[Kn,...e.flatMap((e=>Array.isArray(e)?e:e.split(".")))],ni=(e,t)=>{const n=ti(t),i=n.pop();return[e&&ei(e,n),i]},ii={length:1,parentRule:1,style:1},ri={INPUT:1,TEXTAREA:1},si={BUTTON:1,IFRAME:1,EMBED:1,INPUT:1,OBJECT:1,SELECT:1,TEXTAREA:1,BODY:1},oi=globalThis,ai=document,li=Object.freeze({}),ci=Array.prototype.slice,di=Promise.resolve(),ui=["font-size","font-size-adjust","font-style","font-weight","font-family","font-kerning","font-stretch","line-height","text-transform","text-decoration","letter-spacing","word-break"],hi=e=>e._hidden,gi=e=>e instanceof Ht||U.isObject(e),mi=(e,t,n)=>"children"===n.key?U.mergeItems(e,t,n):U.blend(e,t,n),pi=(e,t)=>{if(e.isConnected){const n=e.ownerDocument.defaultView.getComputedStyle(e);return"none"!==n.getPropertyValue("display")&&(t||"hidden"!==n.getPropertyValue("visibility"))}},fi=e=>e&&e.isConnected&&(e===ai.body||Boolean(e.offsetParent)||(e.ownerDocument.defaultView&&"offsetParent"in e&&"fixed"!==ki.getStyleValue(e,"position")?e.offsetParent:fi(e.parentNode))),vi=e=>e instanceof Node?e:"string"==typeof e?Fi.createElementFromTemplate(e):Fi.createElement(e),yi=Object.create(null),bi=(e,t)=>{const n=yi[e]||[V.hyphenate(e),t];return yi[e]||(yi[n[0]]=yi[e]=n),n},Ci=/b-slide-in-from-\w+/,Si=(e,t)=>{if(e){var n;const i=((e=1===(null===(n=e.target)||void 0===n?void 0:n.nodeType)?e.target:e).ownerSVGElement||e)[t&&"static"!==ki.getStyleValue(e,"position")?"offsetParent":"parentNode"];return(null==i?void 0:i.nodeType)===Ln?i.host:i}},wi=e=>(null==e?void 0:e.nodeType)===An,Di=(e=ai)=>{var t;return(null===(t=e.getAnimations())||void 0===t?void 0:t.reduce(((e,{effect:t,playState:n})=>("running"===n&&t.getTiming().iterations!==1/0&&e.push(t.target),e)),[]))||[]};["top","right","bottom","left","width","height","maxWidth","maxHeight","minWidth","minHeight","borderSpacing","borderWidth","borderTopWidth","borderRightWidth","borderBottomWidth","borderLeftWidth","insetBlockEnd","insetBlockStart","insetInlineEnd","insetInlineStart","marginTop","marginRight","marginBottom","marginLeft","marginInlineStart","marginInlineEnd","paddingTop","paddingRight","paddingBottom","paddingLeft","fontSize","letterSpacing","lineHeight","outlineWidth","textIndent","wordSpacing","insetInlineStart","insetBlockStart","insetInlineEnd","insetBlockEnd"].forEach((e=>bi(e,!0)));let Ei,xi,Ri,Ti=null,Mi=0,Ii=null;class ki{static $name="DomHelper";static _usingKeyboard=!1;static enableKeyboardCssModifiers=!0;static get devicePixelRatio(){let e=globalThis.devicePixelRatio;if(null==e){const t=.05,n=.5,i=e=>`(-webkit-min-device-pixel-ratio: ${e}),\n                (min--moz-device-pixel-ratio: ${e}),\n                (min-resolution: ${e}dppx)`;for(let r=100*5;r>=100*n;r-=100*t)if(globalThis.matchMedia(i(r/100)).matches){e=r/100;break}}return e}static get usingKeyboard(){return Fi._usingKeyboard}static set usingKeyboard(e){return Fi._usingKeyboard=e}static setUsingKeyboard(e,t){Fi.setFocusRendition(e,t),Fi._usingKeyboard=t}static setFocusRendition(e,t){var n;Fi.enableKeyboardCssModifiers&&(e.nodeType===Ln?t?Array.from(e.children).forEach((e=>{var t;return(null===(t=e.matches)||void 0===t?void 0:t.call(e,".b-outer"))&&e.classList.add("b-using-keyboard")})):Fi.removeClsGlobally(e,"b-using-keyboard"):null===(n=e.classList)||void 0===n||n.toggle("b-using-keyboard",t))}static findParent(e,t,n){return this.closest(null==e?void 0:e.parentNode,t,n)}static closest(e,t,n){if(e&&e!==n)return t(e)?e:this.closest(e.parentNode,t,n)}static async slideIn(e,t=1){const n="b-slide-in-"+(t>0?"next":"previous"),{classList:i,parentNode:{classList:r}}=e;r.add("b-sliding-child-element"),i.add(n),await Mn.waitForTransitionEnd({element:e,animationName:Ci}),i.remove(n),r.remove("b-sliding-child-element")}static getExpando(e,t,n){const[i,r]=ni(e,t);return i&&r in i?i[r]:n}static getExpandos(e,t){return ei(e,ti(t))}static removeExpando(e,t,n){const[i,r]=ni(e,t);!i||n&&i[r]!==n||delete i[r]}static setExpando(e,t,n){const[i,r]=ni(e,t);return i&&(i[r]=n),e}static getFocusability(e){let t="";if(e&&!e.hasAttribute("inert")){const{nodeName:n}=e,i=e.getAttribute("tabIndex");t=si[n]||("A"===n||"LINK"===n)&&e.href||"true"===e.contentEditable?"n":"","-1"===i?t+="fp":(t||null!=i)&&(t+="ft")}return Xn[t]||(Xn[t]=(n=t,Object.freeze(Object.fromEntries(Qn.map((([e,t])=>[t,n.includes(e)]))))));var n}static isFocusable(e,t){return(null==e?void 0:e.nodeType)===An&&(!(e&&!t&&(!Fi.isVisible(e)||Fi.Widget.fromElement(e,hi)))&&Fi.getFocusability(e).focusable)}static isEditable(e,t){return Boolean((e.isContentEditable||ri[e.nodeName])&&(!t||"INPUT"!==e.nodeName||On[e.type.toLowerCase()])&&!(e.readOnly||e.disabled||e.closest("[inert]")))}static isTextualInput(e){return ri[e.nodeName]&&("INPUT"!==e.nodeName||On[e.type.toLowerCase()])}static isInView(e,t=!1,n){if(!e||!fi(wi(e.target)?e.target:e))return!1;const i=(null==n?void 0:n.positioned)&&"fixed"!==ki.getStyleValue(n.element,"position"),r=_t.from(globalThis),s=t?"contains":"intersect",o=i&&n.element.offsetParent,a=i&&_t.from(o);if(r.height=ai.scrollingElement.scrollHeight,e===ai.body)return r;const l=this.getViewportIntersection(e,r,s);return l&&i&&l.translate(ai.scrollingElement.scrollLeft,ai.scrollingElement.scrollTop),i&&l?l.translate(-a.x+o.scrollLeft,-a.y+o.scrollTop):l}static getViewportIntersection(e,t,n){var i;const r=wi(e.target)?e.target:null,s=r||e,o=ki.getVisibleViewport(Si(s,1),t,s),a=_t.from(s,null,!0);return r&&(a.translate(e.offsetX+1,e.offsetY+1),a.height=a.width=0),null==o||null===(i=o[n])||void 0===i?void 0:i.call(o,a,!1,!0)}static getVisibleViewport(e,t,n){const{fullscreenElement:i}=ai;let r,s,o,a,l,c=t;for(l=e;!s&&l&&l!==ai.body;l=Si(l,1))if((r=s=l===i)||(a=l.ownerDocument.defaultView.getComputedStyle(l),r=("visible"!==a.overflowX||"visible"!==a.overflowY)&&"contents"!==a.display),r){var d;const e=_t.client(l,null,!0,!1,n,!1);if(!e.height||!e.width)return!1;c=(null===(d=c)||void 0===d?void 0:d.intersect(e))||e,o=l}return o&&(c=_t.clipStickies(c,o,null,!0,n)),c}static isVisible(e){let t=!1;for(;e;e=Si(e)){if(e.nodeType===Fn)return!0;if(e.nodeType===An){var n;const i=null===(n=e.ownerDocument)||void 0===n?void 0:n.defaultView.getComputedStyle(e);if(t=t||"visible"===i.getPropertyValue("visibility"),wi(e)&&!pi(e,t))return!1}}return!1}static isDOMEvent(e){return e instanceof Event}static merge(e,...t){return U.blend(e,t,{isObject:gi,merge:mi})}static normalizeChildren(e,t,n){var i;let r,s,o,a,l,c=null==e?void 0:e.children;if(null!=e&&null!==(i=e.syncOptions)&&void 0!==i&&i.ignoreRefs&&(n=!0),c&&!(e instanceof Node))if(Array.isArray(c))for(s=0;s<c.length;++s)Fi.normalizeChildren(c[s],t,n);else for(o in a=c,e.children=c=[],a){var d;r=a[o],null!==(d=r)&&void 0!==d&&d.isWidget&&(r=r.element),l=!o.startsWith("$")&&!Fi.isElement(r),l&&(null==t||t(o,!n)),r&&(r instanceof Node||(!1===r.reference?delete r.reference:l&&"string"!=typeof r&&(r.reference=o),Fi.normalizeChildren(r,t,n)),c.push(r))}return e}static roundPx(e,t=globalThis.devicePixelRatio||1){const n=1/t;return Math.round(e/n)*n}static floorPx(e,t=globalThis.devicePixelRatio||1){const n=1/t;return Math.floor(e*n)/n}static isCustomElement(e){return Boolean(null==e?void 0:e.shadowRoot)}static elementFromPoint(e,t){let n=document.elementFromPoint(e,t);return Fi.isCustomElement(n)&&(n=n.shadowRoot.elementFromPoint(e,t)||n),n}static childFromPoint(e,t,n,i=e){const r=null==n?t:new _t(t,n,0,0);let s=null;return Array.from(e.children).reverse().some((e=>{if(_t.from(e,i).contains(r))return s=e.children.length&&Fi.childFromPoint(e,r,null,i)||e,!0})),s}static unitize(e,t,n="px"){const[i,r]=bi(e);return null!=t&&(t=String(t),t=r&&qn.test(t)?t+n:t),[i,t]}static get activeElement(){let e=document.activeElement;for(;e.shadowRoot;)e=e.shadowRoot.activeElement;return e}static getActiveElement(e){var t,n;null!==(t=e)&&void 0!==t&&t.isWidget&&(e=e.element);let i=((null===(n=e)||void 0===n?void 0:n.getRootNode())||document).activeElement;for(;null!==(r=i)&&void 0!==r&&r.shadowRoot;){var r;i=i.shadowRoot.activeElement}return i}static getRootElement(e){var t;const n=null===(t=e.getRootNode)||void 0===t?void 0:t.call(e),{nodeType:i}=n;return i===Fn?n.body:i===Ln?n:e.ownerDocument.contains(e)?e.ownerDocument.body:null}static getOutermostElement(e){var t,n;const i=null===(t=(n=e).getRootNode)||void 0===t?void 0:t.call(n);if(null!=i&&i.body)return null==i?void 0:i.body;for(;e.parentNode!==i&&e.parentNode;)e=e.parentNode;return e}static isValidFloatRootParent(e){var t;return"BODY"===(null===(t=e.tagName)||void 0===t?void 0:t.toUpperCase())||e.getRootNode().nodeType===Ln}static getId(e){return e.id||(e.id="b-element-"+ ++Mi)}static getCommonAncestor(e,t){if(e===t)return e;for(;e&&!(null!==(n=(i=e)[e.isWidget?"owns":"contains"])&&void 0!==n&&n.call(i,t)||e===t);){var n,i,r;e=wi(e)?Si(e):null!==(r=e.owner)&&void 0!==r&&r.isWidget&&e.owner!==e?e.owner:null}return e}static waitForSelector(e,t=5e3,n=100){if(null!=e){var i;const r=null===(i=e.endsWith)||void 0===i?void 0:i.call(e,"?"),s=e.nodeType?e:document.querySelector(r?e.substring(0,e.length-1):e);if(r){if(!s)return;t>0&&(t=-t)}return s&&ki.isVisible(s)&&!Di().some((e=>e.contains(s)))&&ki.isInView(s,!1)?s:ut.waitFor((()=>{const t=s||document.querySelector(e);if(t&&ki.isVisible(t)&&!Di().some((e=>e.contains(t)))&&ki.isInView(t,!1))return t}),t,n)}}static getElement(e){return"string"==typeof e?ai.querySelector(e):e}static setAttributes(e,t){const n=Fi.getElement(e);if(n&&t)for(const e in t)null==t[e]?n.removeAttribute(e):n.setAttribute(e,t[e])}static toggleAttribute(e,t,n){const i=Fi.getElement(e);i&&(i.toggleAttribute?i.toggleAttribute(t,n):null!=n?i[n?"setAttribute":"removeAttribute"](t,""):i.hasAttribute(t)?i.removeAttribute(t):i.setAttribute(t,""))}static addAttributeValue(e,t,n){const i=Fi.getElement(e);var r;i&&n&&i.setAttribute(t,[...new Set(null===(r=i.getAttribute(t))||void 0===r?void 0:r.split(" ")).add(n)].join(" "))}static removeAttributeValue(e,t,n){const i=Fi.getElement(e);if(i&&n){var r;const e=new Set(null===(r=i.getAttribute(t))||void 0===r?void 0:r.split(" "));e.delete(n),e.size?i.setAttribute(t,[...e].join(" ")):i.removeAttribute(t)}}static setLength(e,t,n){return n=1===arguments.length?"number"==typeof e?`${e}px`:e??"":(e=Fi.getElement(e)).style[t]="number"==typeof n?`${n}px`:n??""}static percentify(e,t=2){const n=Math.pow(10,t);return null==e||""===e||isNaN(e)?"":Math.round(e*n)/n+"%"}static getChild(e,t){return e.querySelector(":scope>"+t)}static hasChild(e,t){return null!=Fi.getChild(e,t)}static children(e,t){return(">"===t[0]||t.startsWith("# "))&&("#"===t[0]&&(t=t.substr(2)),t=":scope "+t),Array.from(e.querySelectorAll(t))}static getChildElementCount(e){return e.childElementCount}static down(e,t){var n;return e?null!==(n=e.matches)&&void 0!==n&&n.call(e,t)?e:(t=":scope "+t,e.querySelector(t)):null}static isDescendant(e,t){const n=e.contains(t);if(!n&&t){const n=Fi.getRootElement(e),i=Fi.getRootElement(t);if(i&&n!==i&&i.host)return Fi.isDescendant(n,i.host)}return n}static getEventElement(e,t="target"){return!e||Fi.isElement(e)?e:e[t]}static isElement(e){return(null==e?void 0:e.nodeType)===An&&Fi.isNode(e)}static isReactElement(e){var t;return Boolean(null===(t=globalThis.bryntum)||void 0===t||null===(t=t.react)||void 0===t?void 0:t.isReactElement(e))}static handleReactElement(e,t){var n;return Boolean(null===(n=globalThis.bryntum)||void 0===n||null===(n=n.react)||void 0===n?void 0:n.handleReactElement(e,t))}static handleReactHeaderElement(e,t,n){var i;return Boolean(null===(i=globalThis.bryntum)||void 0===i||null===(i=i.react)||void 0===i?void 0:i.handleReactHeaderElement(e,t,n))}static isVueConfig(e){var t;return Boolean(null===(t=globalThis.bryntum)||void 0===t||null===(t=t.vue)||void 0===t?void 0:t.isVueConfig(e))}static handleVueContent(e,t){var n;null===(n=globalThis.bryntum)||void 0===n||null===(n=n.vue)||void 0===n||n.handleVueContent(e,t)}static isNode(e){return Boolean(e)&&"number"==typeof e.nodeType&&!$n(e)}static forEachSelector(e,t,n){if("string"==typeof e)throw new Error("DomHelper.forEachSelector must provide a root element context (for shadow root scenario)");Fi.children(e,t).forEach(n)}static forEachChild(e,t){Array.from(e.children).forEach(t)}static removeEachSelector(e,t){Fi.forEachSelector(e,t,(e=>e.remove()))}static removeClsGlobally(e,...t){t.forEach((t=>Fi.forEachSelector(e,"."+t,(e=>e.classList.remove(t)))))}static getAncestor(e,t,n=null){let i,r=!1,s=e;for(t=rt.asArray(t);s=s.parentElement;){if(t.includes(s)){r=!0;break}if(n&&s===n)break;i=s}return r?i||e:null}static getParents(e){const t=[];for(;e.parentElement;)t.push(e.parentElement),e=e.parentElement;return t}static makeValidId(e,t=""){return V.makeValidDomId(e,t)}static createElement(e={},t){var n,i,r;let s,o,a,l,c,d,u,h,g,m,p,f=t;if("boolean"==typeof f)throw new Error("Clean up");t&&(c=t.ignoreRefs,g=t.refOwner,m=t.refs,f=t.returnAll,p=t.syncIdField,c&&(a=!0,c="children"!==c)),"string"==typeof e.parent&&(e.parent=document.getElementById(e.parent));const v=e.parent||e.nextSibling&&e.nextSibling.parentNode,{dataset:y,html:b,reference:C,syncOptions:S,text:w}=e;if(S&&(p=S.syncIdField||p,l=S.ignoreRefs,l&&(a=!0,c="children"!==l,t={...t,ignoreRefs:!0})),c&&(g=null),s=e.ns?ai.createElementNS(e.ns,e.tag||"svg"):"#fragment"===e.tag?ai.createDocumentFragment():ai.createElement(e.tag||"div"),null!=w?Fi.setInnerText(s,w):null!=b&&(b instanceof DocumentFragment?s.appendChild(b):s.innerHTML=b),e.tooltip&&Fi.Widget.attachTooltip(s,e.tooltip),e.style&&Fi.applyStyle(s,e.style),y)for(u in y)h=y[u],null!=h&&(s.dataset[u]=h);v&&this.addChild(v,s,e.nextSibling),g&&(s.$refOwnerId=g.id),C&&!c&&(g?(s.$reference=C,g.attachRef(C,s,e)):(m||((t=Object.assign({},t)).refs=m={}),m[C]=s,s.setAttribute("data-reference",C)));const D=e.className||e.class,E=Object.keys(e);for(D&&s.setAttribute("class",Ht.normalize(D)),o=0;o<E.length;++o)u=E[o],h=e[u],null!=(d=Zn[u])?s[d||u]=h:!Jn[u]&&u&&null!=h&&s.setAttribute(u,h);s.nodeType!==An||e["aria-hidden"]||"role"in e||e.tabIndex||e.alt||ki.isFocusable(s,!0)||s.htmlFor||s.setAttribute("role","presentation"),null===(n=t)||void 0===n||null===(i=n.callback)||void 0===i||i.call(n,{action:"newElement",domConfig:e,targetElement:s,syncId:g?C:t.syncIdField&&(null===(r=e.dataset)||void 0===r?void 0:r[t.syncIdField])}),!0===f?t.returnAll=f=[s]:Array.isArray(f)&&f.push(s),e.children&&(p&&(s.syncIdMap={}),rt.asArray(e.children).forEach((n=>{if(n)if("string"==typeof n){const e=document.createTextNode(n);g&&(e.$refOwnerId=g.id),s.appendChild(e)}else if(this.isReactElement(n)){var i,r;null===(i=t)||void 0===i||null===(r=i.reactCallback)||void 0===r||r.call(i,{jsx:n,domConfig:e,targetElement:s})}else if(isNaN(n.nodeType)){var o,l;n.parent=s,!n.ns&&e.ns&&(n.ns=e.ns);const i=Fi.createElement(n,{...t,ignoreRefs:(null===(o=e.syncOptions)||void 0===o?void 0:o.ignoreRef)??a}),r=null===(l=n.dataset)||void 0===l?void 0:l[p];null!=r&&(s.syncIdMap[r]=i),delete n.parent}else s.appendChild(n)}))),s.lastDomConfig=e;const x=m||f||s;return e.replaceElement&&e.replaceElement.replaceWith(x),x}static createElementFromTemplate(e,t=li){const{array:n,raw:i,fragment:r}=t;let s;if(Fi.supportsTemplate){if((Ei||(Ei=ai.createElement("template"))).innerHTML=e,s=Ei.content,r)return s.cloneNode(!0)}else if(s=(xi||(xi=new DOMParser)).parseFromString(e,"text/html").body,r){const e=s.childNodes;for(s=document.createDocumentFragment();e.length;)s.appendChild(e[0]);return s}return s=i?s.childNodes:s.children,1!==s.length||n?ci.call(s):s[0]}static triggerMouseEvent(e,t="contextmenu",n={}){const i=this.isInView(e),r=null==i?void 0:i.center;if(i){const s=new MouseEvent(t,{clientX:r.x,clientY:r.y,offsetX:i.width/2,offsetY:i.height/2,bubbles:!0,...n});return e.dispatchEvent(s),s}}static insertFirst(e,t){return t&&t.nodeType!==An&&t.tag&&(t=Fi.createElement(t)),e.insertBefore(t,e.firstElementChild)}static insertBefore(e,t,n){return t&&t.nodeType!==An&&t.tag&&(t=Fi.createElement(t)),n?e.insertBefore(t,n):Fi.insertFirst(e,t)}static insertAt(e,t,n){const i=Array.from(e.children);if(n>=i.length)return Fi.append(e,t);const r=i[n];return Fi.insertBefore(e,t,r)}static append(e,t){if(t.forEach){if(Array.isArray(t)&&(t=t.map((e=>vi(e)))),e.append)e.append(...t);else{const n=document.createDocumentFragment();t.forEach((function(e){n.appendChild(e)})),e.appendChild(n)}return t}return e.appendChild(vi(t))}static getTranslateX(e){const t=e.style.transform;let n=zn.exec(t);return n?parseFloat(n[2]):(n=Hn.exec(t)||Hn.exec(Fi.getStyleValue(e,"transform")),n?parseFloat(n[1]||n[3]):0)}static getTranslateY(e){const t=e.style.transform;let n=Nn.exec(t);if(n){const e=parseFloat(n["Y"===n[1]?2:3]);return isNaN(e)?0:e}return n=Hn.exec(t)||Hn.exec(Fi.getStyleValue(e,"transform")),n?parseFloat(n[2]||n[4]):0}static getTranslateXY(e){return[Fi.getTranslateX(e),Fi.getTranslateY(e)]}static getOffsetX(e,t=null){return t?e.getBoundingClientRect().left-t.getBoundingClientRect().left:e.offsetLeft}static getOffsetY(e,t=null){return t?e.getBoundingClientRect().top-t.getBoundingClientRect().top:e.offsetTop}static getOffsetXY(e,t=null){return[Fi.getOffsetX(e,t),Fi.getOffsetY(e,t)]}static getPageX(e){return e.getBoundingClientRect().left+oi.pageXOffset}static getPageY(e){return e.getBoundingClientRect().top+oi.pageYOffset}static getExtremalSizePX(e,t){const n=V.hyphenate(t),i=n.split("-")[1];let r=Fi.getStyleValue(e,n);return r=/%/.test(r)?e.parentElement?parseInt(Fi.getStyleValue(e.parentElement,i),10):NaN:parseInt(r,10),r}static setScale(e,t,n=t){const i=Fi.getStyleValue(e,"transform").split(/,\s*/);i.length>1?(i[0].startsWith("matrix3d")?(i[0]=`matrix3d(${t}`,i[5]=n):(i[0]=`matrix(${t}`,i[3]=n),e.style.transform=i.join(",")):e.style.transform=`scale(${t}, ${n})`}static setTranslateX(e,t){const n=Fi.getStyleValue(e,"transform").split(/,\s*/);t=Fi.roundPx(t),n.length>1?(n[n[0].startsWith("matrix3d")?12:4]=t,e.style.transform=n.join(",")):e.style.transform=`translateX(${t}px)`}static setTranslateY(e,t){const n=Fi.getStyleValue(e,"transform").split(/,\s*/);t=Fi.roundPx(t),n.length>1?(n[n[0].startsWith("matrix3d")?13:5]=t,e.style.transform=n.join(",")+")"):e.style.transform=`translateY(${t}px)`}static setTop(e,t){Fi.setLength(e,"top",t)}static setLeft(e,t){Fi.setLength(e,"left",t)}static setTopLeft(e,t,n){Fi.setLength(e,"top",t),Fi.setLength(e,"left",n)}static setTopInsetInlineStart(e,t,n){Fi.setLength(e,"top",t),Fi.setLength(e,"inset-inline-start",n)}static setRect(e,{x:t,y:n,width:i,height:r}){Fi.setTopInsetInlineStart(e,n,t),Fi.setLength(e,"width",i),Fi.setLength(e,"height",r)}static setTranslateXY(e,t,n){if(null==t)return Fi.setTranslateY(e,n);if(null==n)return Fi.setTranslateX(e,t);t=Fi.roundPx(t),n=Fi.roundPx(n);const i=Fi.getStyleValue(e,"transform").split(/,\s*/),r=i[0].startsWith("matrix3d");i.length>1?(i[r?12:4]=t,i[r?13:5]=n,e.style.transform=i.join(",")+")"):e.style.transform=`translate(${t}px, ${n}px)`}static addTranslateX(e,t){Fi.setTranslateX(e,Fi.getTranslateX(e)+t)}static addTranslateY(e,t){Fi.setTranslateY(e,Fi.getTranslateY(e)+t)}static addLeft(e,t){Fi.setLeft(e,Fi.getOffsetX(e)+t)}static addTop(e,t){Fi.setTop(e,Fi.getOffsetY(e)+t)}static alignTo(e,t,n=kn,i,r="translate"){t=t instanceof _t?t:_t.from(t,!0);const s=_t.from(e,!0);i&&(s.roundPx(),t.roundPx());const o=s.alignTo(Object.assign(n,{target:t}));if("topInset"===r){const t=[parseInt(e.style.insetInlineStart||0,10),parseInt(e.style.top||0,10)];Fi.setTopInsetInlineStart(e,t[1]+o.y-s.y,t[0]+o.x-s.x)}else if("topLeft"===r){const t=[parseInt(e.style.left||0,10),parseInt(e.style.top||0,10)];Fi.setTopLeft(e,t[1]+o.y-s.y,t[0]+o.x-s.x)}else{const t=Fi.getTranslateXY(e);Fi.setTranslateXY(e,t[0]+o.x-s.x,t[1]+o.y-s.y)}}static getStyleValue(e,t,n,i){const r=n?e.style:e.ownerDocument.defaultView.getComputedStyle(e,i);if(Array.isArray(t)){const e={};for(const n of t)e[n]=r.getPropertyValue(V.hyphenate(n));return e}return r.getPropertyValue(V.hyphenate(t))}static getEdgeSize(e,t,n){const i="border"===t?"-width":"",r={raw:{}};for(const s of["top","right","bottom","left"])n&&!n.includes(s[0])||(r[s]=parseFloat(r.raw[s]=Fi.getStyleValue(e,`${t}-${s}${i}`)));return r.width=(r.left||0)+(r.right||0),r.height=(r.top||0)+(r.bottom||0),r}static parseStyle(e){if("string"==typeof e){const t=e.split(Un);e={};for(let n=0,{length:i}=t;n<i;n++){const i=t[n].split(Gn);e[i[0]]=i[1]}}return e||{}}static applyStyle(e,t,n=!1){if("string"==typeof t)n?(t.length||e.style.cssText.length)&&(e.style.cssText=t):e.style.cssText+=t;else if(t){let i,r;for(i in n&&(e.style.cssText=""),t.style&&"string"!=typeof t.style&&(t=U.assign({},t,t.style)),t)ii[i]||([i,r]=Fi.unitize(i,t[i]),null==r?e.style.removeProperty(i):e.style.setProperty(i,r));"string"==typeof t.style&&(e.style.cssText+=t.style)}}static getCSSText(e){if("string"==typeof e)return e;let t="";for(const n in e)ii[n]||(t+=`${V.hyphenate(n)}:${e[n]};`);return t}static assignClasses(e,t){U.forEach(t,((t,n)=>e.classList.toggle(n,Boolean(t))))}static toggleClasses(e,t,n=null){t=rt.asArray(t),!0===n?e.classList.add(...t):!1===n?e.classList.remove(...t):t.forEach((t=>e.classList.toggle(t)))}static addTemporaryClass(e,t,n,i=globalThis,r=t){n>0&&(e.classList.add(t),i===globalThis?i.setTimeout((()=>null==e?void 0:e.classList.remove(t)),n):i.setTimeout({fn:t=>e.classList.remove(t),delay:n,name:r,args:[t],cancelOutstanding:!0}))}static getPropertyTransitionDuration(e,t){const n=globalThis.getComputedStyle(e),i=n.transitionProperty.split(", "),r=n.transitionDuration.split(", "),s=i.indexOf(V.hyphenate(t));let o;return-1!==s&&(o=1e3*parseFloat(r[s])),o}static getAnimationDuration(e){return 1e3*parseFloat(Fi.getStyleValue(e,"animation-duration"))}static highlight(e,t=globalThis){return e instanceof _t?e.highlight():new Promise((n=>{t.setTimeout((()=>{e.classList.add("b-fx-highlight"),t.setTimeout((()=>{e.classList.remove("b-fx-highlight"),n()}),2e3)}),0)}))}static get scrollBarWidth(){if(null===Ti){const e=Ri||(Ri=Fi.createElement({parent:ai.documentElement,className:"b-scrollbar-measure-element",style:"position:absolute;top:-9999em;height:100px;overflow-y:scroll"}));e.parentNode!==ai.documentElement&&ai.documentElement.appendChild(e),Ti=e.offsetWidth,ai.documentElement.style.setProperty("--b-scrollbar-width",`${Ti}px`)}return Ti}static get scrollBarPadElement(){return{className:"b-yscroll-pad",children:[{className:"b-yscroll-pad-sizer"}]}}static get scrollLimit(){const e=ki.createElement({parent:document.body,style:"position:absolute; left:-999px; top:0; width:5px; height:5px",children:[{style:"position:absolute; width:1px; height:1px"}]}),t=e.firstElementChild;let n=0,i=2e7;for(;i>1e6&&(t.style.transform=`translateY(${i}px)`,e.style.lineHeight=""+(n=1-n),!(e.scrollHeight>=i));)i-=1e6;return Object.defineProperty(ki,"scrollLimit",{value:i}),e.remove(),i}static resetScrollBarWidth(){Ti=null}static measureText(e,t,n=!1,i=void 0){const r=Fi.getMeasureElement(t,i);r[n?"innerHTML":"innerText"]=e;const s=r.clientWidth;return r.className="",s}static measureSize(e,t,n=!0){if(!e)return 0;if("number"==typeof e)return e;if(!e.length)return 0;if(/^\d+(px)?$/.test(e))return parseInt(e);if(t){var i;const r=null===(i=e.includes)||void 0===i?void 0:i.call(e,"%"),s=Fi.getMeasureElement(t,r?t.parentNode:void 0),{parentElement:o}=s;s.innerHTML="",r&&(o.style.display="contents"),s.style.minWidth=s.style.maxWidth=Fi.setLength(e);const a=n?s.offsetWidth:s.getBoundingClientRect().width;return o.style.display="",s.style.minWidth=s.style.maxWidth=s.className="",a}return/^\d+em$/.test(e)?14*parseInt(e):isNaN(e)?0:parseInt(e)}static getMeasureElement(e,t){t=t||ai.body;const n=oi.getComputedStyle(e),i=t.offScreenDiv=t.offScreenDiv||Fi.createElement({parent:t,style:"position:fixed;top:-10000px;left:-10000px;visibility:hidden;contain:strict",className:"b-measure-element",children:[{style:"white-space:nowrap;display:inline-block;will-change:contents;width:auto;contain:none"}]},{returnAll:!0})[1];return ui.forEach((e=>{i.style[e]!==n[e]&&(i.style[e]=n[e])})),i.className=e.className,i.parentElement.parentElement!==t&&t.appendChild(i.parentElement),i}static stripTags(e){return(Fi.$domParser||(Fi.$domParser=new DOMParser)).parseFromString(e,"text/html").body.textContent}static sync(e,t){if("string"==typeof e){if(""===e)return void(t.innerHTML="");e=Fi.createElementFromTemplate(e)}return Fi.performSync(e,t),t}static performSync(e,t){return e.outerHTML!==t.outerHTML&&(Fi.syncAttributes(e,t),Fi.syncContent(e,t),Fi.syncChildren(e,t),!0)}static getSyncAttributes(e){const t={},n=[];for(let i=0;i<e.attributes.length;i++){const r=e.attributes[i];if(r.specified){const e=r.name.toLowerCase();t[e]=r.value,n.push(e)}}return{attributes:t,names:n}}static syncAttributes(e,t){const{attributes:n,names:i}=Fi.getSyncAttributes(e),{attributes:r,names:s}=Fi.getSyncAttributes(t),o=i.includes("dataset"),a=i.filter((e=>!s.includes(e))),l=s.filter((e=>!(i.includes(e)||o&&e.startsWith("data-")))),c=i.filter((e=>s.includes(e)));if(a.length>0)for(let e=0;e<a.length;e++){const i=a[e];"style"===i?Fi.applyStyle(t,n.style,!0):"dataset"===i?Object.assign(t.dataset,n.dataset):t.setAttribute(i,n[i])}if(l.length>0)for(let e=0;e<l.length;e++)t.removeAttribute(l[e]);if(c.length>0)for(let e=0;e<c.length;e++){const i=c[e];if("style"===i)Fi.applyStyle(t,n.style,!0);else if("dataset"===i)Object.assign(t.dataset,n.dataset);else if("class"!==i||!n.class.isDomClassList&&"object"!=typeof n.class)r[i]!==n[i]&&t.setAttribute(i,n[i]);else{let e;e=n.class.isDomClassList?n.class:new Ht(n.class),e.isEqual(r.class)||t.setAttribute("class",e)}}}static syncContent(e,t){0===Fi.getChildElementCount(e)&&(t.innerText=e.innerText)}static setInnerText(e,t){const{firstChild:n}=e;(null==n?void 0:n.nodeType)===Pn?n.data=t:e.textContent=t}static syncChildren(e,t){const n=this,i=ci.call(e.childNodes),r=ci.call(t.childNodes);for(;i.length;){const e=i.shift(),s=r.shift();if(e&&e.nodeType!==Pn&&e.nodeType!==An)throw new Error(`Source node type ${e.nodeType} not supported by DomHelper.sync()`);if(s&&s.nodeType!==Pn&&s.nodeType!==An)throw new Error(`Target node type ${s.nodeType} not supported by DomHelper.sync()`);if(s)if(e.nodeType===s.nodeType)e.nodeType===Pn?s.data=e.data:e.tagName===s.tagName?n.performSync(e,s):(t.insertBefore(e,s),s.remove());else{if(e.nodeType!==Pn||s.nodeType!==An){const t=e.parentElement||e;throw new Error(`Currently no support for transforming nodeType.\n${t.outerHTML}`)}t.innerText=e.data.trim()}else t.appendChild(e)}r.forEach((e=>{e.remove()}))}static syncClassList(e,t){const{classList:n}=e,i="string"==typeof t,r=i?t.split(Wn):Ht.normalize(t,"array"),s=r.length;let o,a=n.length!==s;for(o=0;!a&&o<s;o++)a=!n.contains(r[o]);return a&&(e.className=i?t:r.join(" ")),a}static updateClassList(e,t){const{classList:n}=e;let i,r,s=!1;for(i in t)r=Boolean(t[i]),n.contains(i)!==r&&(n[r?"add":"remove"](i),s=!0);return s}static setTheme(e,t){e=e.toLowerCase();const{head:n}=document,i=Fi.getThemeInfo(t).name.toLowerCase();let r=n.querySelectorAll("[data-bryntum-theme]:not([data-loading])"),s=0;if(i===e)return di;Fi.removeEachSelector(n,"#bryntum-theme[data-loading],link[data-bryntum-theme][data-loading]");const o={theme:e,prev:i};function a(t,n,a){const l=ki.createElement({tag:"link",rel:"stylesheet",dataset:{loading:!0,bryntumTheme:!0},href:t.href.replace(i,e),nextSibling:t});l.addEventListener("load",(()=>{delete l.dataset.loading,Ii=null,++s===r.length&&(Fi._isDarkTheme=null,r.forEach((e=>e.remove())),Hi.trigger("theme",o),n(o))})),l.addEventListener("error",(e=>{delete l.dataset.loading,a(e)}))}if(r.length)return new Promise(((e,t)=>{r.forEach(((n,i)=>{a(n,e,t,r.length)}))}));{const e=n.querySelector("#bryntum-theme:not([data-loading])")||n.querySelector(`[href*="${i}.css"]:not([data-loading])`);if(null==e||!e.href.includes(`${i}.css`))throw new Error(`Theme link for ${i} not found`);return r=[e],new Promise(((t,n)=>a(e,t,n)))}}static get themeInfo(){return ki.getThemeInfo()}static getThemeInfo(e){if(!Ii){const t=Fi.createElement({parent:document.body,className:"b-theme-info"}),n=Fi.getStyleValue(t,"content",!1,":before");if(n)try{Ii=JSON.parse(n.replace(/^["']|["']$|\\/g,""))}catch(e){Ii=null}Ii=Ii||(e?{name:e}:null),t.remove()}return Ii}static get isDarkTheme(){if(null==Fi._isDarkTheme){const e=ki.createElement({className:"b-widget",parent:document.body});Fi._isDarkTheme="dark"===Fi.getStyleValue(e,"color-scheme"),e.remove()}return Fi._isDarkTheme}static async transition({element:e,selector:t="[data-dom-transition]",duration:n,action:i,thisObj:r=this,addTransition:s={},removeTransition:o={}}){const a=new Set,l=!e.style.height,c=Array.from(e.querySelectorAll(t)),d=new Map(c.map((t=>{let n=0,i=t.parentElement;for(;i&&i!==e;)n++,i=i.parentElement;t.$depth=n,t.scrollHeight>t.offsetHeight&&"auto"===getComputedStyle(t).overflow&&(t.$scrollTop=t.scrollTop,a.add(t));const{parentElement:r}=t,s=_t.from(t,e),o=_t.from(t,r),l=getComputedStyle(r),c=parseFloat(l.borderLeftWidth);return c&&(s.left-=c,o.left-=c),[t.id,{element:t,globalBounds:s,localBounds:o,depth:n,parentElement:r}]})));l&&(e.style.height=e.offsetHeight+"px"),i.call(r);const u=Array.from(e.querySelectorAll(t)),h=new Map(u.map((t=>{const n=_t.from(t,e),i=_t.from(t,t.parentElement),r=globalThis.getComputedStyle(t.parentElement),s=parseFloat(r.borderLeftWidth);return s&&(n.left-=s,i.left-=s),[t.id,{element:t,globalBounds:n,localBounds:i}]}))),g=["position","top","left","width","height","padding","margin","zIndex","minWidth","minHeight","opacity","overflow"];e.classList.add("b-dom-transition-snapshot");for(const[t,n]of d){const i=h.get(t);if(i){const{element:t}=i,{style:r,parentElement:s}=t,o=parseInt(Fi.getStyleValue(t,"zIndex")),{globalBounds:l,localBounds:c,depth:d,parentElement:u}=n,h=u!==s;let m;U.copyProperties(t.$initial={parentElement:s},r,g),h?(i.bounds=i.globalBounds,m=l,e.appendChild(t)):(i.bounds=i.localBounds,m=c,u.appendChild(t));let p="hidden";a.has(t)&&(t.$scrollPlaceholder=Fi.createElement({parent:t,style:{height:t.scrollHeight}}),p="auto");const f={position:"absolute",top:`${m.top}px`,left:`${m.left}px`,width:`${m.width}px`,height:`${m.height}px`,minWidth:0,minHeight:0,margin:0,zIndex:d+(o||0),overflow:p};"preserve-padding"!==t.dataset.domTransition&&(f.padding=0),Object.assign(r,f),i.processed=!0}else{const{element:e,localBounds:i,depth:r,parentElement:s}=n;e.$initial={removed:!0},Object.assign(e.style,{position:"absolute",top:`${i.top}px`,left:`${i.left}px`,width:`${i.width}px`,height:`${i.height}px`,minWidth:0,minHeight:0,padding:0,margin:0,zIndex:r,overflow:"hidden"}),s.appendChild(e),h.set(t,{element:e,bounds:i,removed:!0,processed:!0}),u.push(e)}}for(const[,e]of h)if(!e.processed){const{element:t}=e,{style:n,parentElement:i}=t,r=e.bounds=e.localBounds;t.classList.add("b-dom-transition-adding"),U.copyProperties(t.$initial={parentElement:i},n,g),Object.assign(n,{position:"absolute",top:s.top?0:`${r.top}px`,left:s.left?0:`${r.left}px`,width:s.width?0:`${r.width}px`,height:s.height?0:`${r.height}px`,opacity:s.opacity?0:null,zIndex:i.$depth+1,overflow:"hidden"})}for(const e of a)e.scrollTop=e.$scrollTop;e.classList.add("b-dom-transition"),e.firstElementChild.offsetWidth;for(const[,{element:e,bounds:t,removed:n}]of h)n?Object.assign(e.style,{top:o.top?0:`${t.top}px`,left:o.left?0:`${t.left}px`,width:o.width?0:`${t.width}px`,height:o.height?0:`${t.height}px`,opacity:o.opacity?0:e.$initial.opacity}):Object.assign(e.style,{top:`${t.top}px`,left:`${t.left}px`,width:`${t.width}px`,height:`${t.height}px`,opacity:e.$initial.opacity});await ut.sleep(n),e.classList.remove("b-dom-transition","b-dom-transition-snapshot");for(const e of u)e.$initial&&(e.$initial.removed?e.remove():(U.copyProperties(e.style,e.$initial,g),e.$scrollPlaceholder&&(e.$scrollPlaceholder.remove(),delete e.$scrollPlaceholder),e.classList.remove("b-dom-transition-adding"),e.$initial.parentElement.appendChild(e)));l&&(e.style.height="");for(const e of a)e.scrollTop=e.$scrollTop,delete e.$scrollTop}static async loadScript(e){return new Promise(((t,n)=>{const i=document.createElement("script");i.src=e,i.onload=t,i.onerror=n,document.head.appendChild(i)}))}static isNamedColor(e){return e&&Yn.test(e)}static createColorStyle(e){return null!=e&&e.length?this.isNamedColor(e)?`var(--cal-color-${e})`:e:""}static get NodeFilter(){return NodeFilter}static addChild(e,t,n){e.insertBefore(t,n)}static cloneStylesIntoShadowRoot(e,t){return new Promise(((n,i)=>{t&&e.querySelectorAll('style, link[rel="stylesheet"]').forEach((e=>e.remove()));const r=document.querySelectorAll('link[rel="stylesheet"]');let s=0;r.forEach((t=>{const o=t.cloneNode();o.addEventListener("load",(()=>{s+=1,s===r.length&&n()})),o.addEventListener("error",(e=>{i(o.href)})),e.appendChild(o)})),document.querySelectorAll("style").forEach((t=>{const n=t.cloneNode();n.innerHTML=t.innerHTML,e.appendChild(n)})),r.length||n()}))}}l.register(ki);const Fi=ki;let Ai;const Pi=()=>Fi.isTouchEvent=!1,Li=()=>{Fi.isTouchEvent=!0,clearTimeout(Ai),Ai=setTimeout(Pi,400)};ai.addEventListener("touchstart",Li,!0),ai.addEventListener("touchend",Li,!0),Fi.canonicalStyles=yi,Fi.supportsTemplate="content"in ai.createElement("template"),Fi.elementExpandoKey=Kn,Fi.numberRe=_n,Node.prototype.closest=function(e){var t;return null===(t=this.parentNode)||void 0===t?void 0:t.closest(e)},globalThis.addEventListener("resize",(()=>Ti=null)),ki._$name="DomHelper";const Oi=new Map,$i=e=>e.floating,_i={touchend:1,pointerup:1},ji={Meta:1,Control:1,Alt:1,Shift:1},Bi=e=>{var t;(null===(t=Yi)||void 0===t?void 0:t.pointerId)===e.pointerId&&(Yi=null)},Vi=e=>{const{touches:t}=e;if(Oi.clear(),t)for(let n=0;n<t.length;n++){const i=t.item(n);Oi.set(i.identifier,[i,e])}},Hi=new class extends(tt.mixin(dt)){suspendFocusEvents(){Zi=!0}resumeFocusEvents(){Zi=!1}setupFocusListenersOnce(e,t){e&&!Hi.observedElements.has(e)&&(Hi.setupFocusListeners(e,t),Hi.observedElements.add(e))}detachFocusListeners(e){e.$globalEventsDetacher&&(e.$globalEventsDetacher(),e.$globalEventsDetacher=null,Hi.observedElements.delete(e))}setupFocusListeners(e=document,t,n=!1){var i;let r,s,o;const a={element:e,fromGlobal:!0,touchstart(e){const{touches:n}=e;if(Vi(e),2===n.length&&n[0].target.closest(".b-widget")&&n[1].target.closest(".b-widget"))return r=[n[0],n[1]],s=[(r[0].clientX+r[1].clientX)/2,(r[0].clientY+r[1].clientY)/2],void(o=ki.elementFromPoint(s[0],s[1]));if(Ni||1!==e.changedTouches.length)Ni=null;else if(Ni=e.changedTouches[0],!d.isAndroid){const n=({clientX:e,clientY:t,type:n})=>{(_i[n]||!Ni||Math.max(Math.abs(e-Ni.clientX),Math.abs(t-Ni.clientY))>5)&&(Wi=null,i(),clearTimeout(r))},i=t.on({element:document,touchmove:n,touchend:n,pointermove:n,pointerup:n,capture:!0}),r=setTimeout((()=>{Wi=Ni.identifier,i(),e.target.dispatchEvent(new MouseEvent("contextmenu",t.copyEvent({},e)))}),t.longPressTime)}},touchmove:{passive:!1,handler:e=>{const{touches:n}=e;if(2===n.length&&r){const i=[n[0],n[1]],a=t.getDistanceBetween(r[0],r[1])-t.getDistanceBetween(i[0],i[1]),l=Math.abs(r[0].clientX-r[1].clientX)-Math.abs(i[0].clientX-i[1].clientX),c=Math.abs(r[0].clientY-r[1].clientY)-Math.abs(i[0].clientY-i[1].clientY);if(Math.abs(a)>2){const t={clientX:s[0],clientY:s[1],bubbles:!0};if(Hi.Widget.convertPinchToMousewheel){e.preventDefault(),e.stopImmediatePropagation();const n=new MouseEvent("wheel",{...t,ctrlKey:!0});n.deltaY=c,n.deltaX=l,o.dispatchEvent(n)}const n=new MouseEvent("bryntum-pinch",t);n.deltaY=c,n.deltaX=l,n.touchMove=e,o.dispatchEvent(n)}r=i}}},touchend:{passive:!1,handler:e=>{Vi(e),2!==e.touches.length&&(r=null),Ni&&(e.changedTouches[0].identifier===Wi?(e.stopImmediatePropagation(),!1!==e.cancelable&&e.preventDefault()):1===e.changedTouches.length&&e.changedTouches[0].identifier===Ni.identifier&&Hi.trigger("globaltap",{event:e}),Ni=null)}},touchcancel:{passive:!1,handler:Vi},mousedown:{handler:e=>{Ui="mouse",Ni||Hi.trigger("globaltap",{event:e}),qi=e;const t=e.ctrlKey||e.altKey||e.shiftKey||e.metaKey;!Gi&&t?Gi=new KeyboardEvent("keydown",{key:e.ctrlKey?"Control":e.shiftKey?"Shift":e.altKey?"Alt":"Meta",ctrlKey:e.ctrlKey,altKey:e.altKey,shiftKey:e.shiftKey,metaKey:e.metaKey}):Gi&&!t&&(Gi=null)},passive:!1},mouseup:{handler:e=>{Hi.trigger("mouseup",{event:e}),qi=null},passive:!1},pointerdown:{passive:!1,handler:t=>{Yi=t,ki.setUsingKeyboard(e,!1)}},pointerup:{passive:!1,handler:Bi},pointercancel:{passive:!1,handler:Bi},keydown(t){const{key:n,target:i}=t;if(Ui="key",Gi=t,Ki=i,!ji[n]){if(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE)for(const t of e.children)t.matches(".b-outer")&&ki.setUsingKeyboard(t,!0);else ki.setUsingKeyboard(e,!0);"Escape"===n&&Hi.Widget.queryAll((e=>e.isTooltip&&e.isVisible)).forEach((e=>e.hide()))}},mouseenter(e){Ki=e.target},keypress(){Ui="key"},keyup(){Gi=null},focusin(e){const{Widget:t}=Hi,{target:n}=e;if(null!=n&&n.shadowRoot||null!=n&&n._shadowRoot)return;if(d.supportsPointerEvents&&null!=n&&n.matches(":focus-visible")&&!bryntum.fromElement(n,(e=>e.isDestroying||e.isDestroyed))){const e=n.matches("[class*=event-wrap],[class*=task-wrap]")?n.firstElementChild:n,t=_t.from(e).center;e.dispatchEvent(new PointerEvent("pointerover",{bubbles:!0,clientX:t.x,clientY:t.y,pointerType:"focus"}))}if(Zi||n&&!n.isConnected)return;const i=e.relatedTarget?e.relatedTarget instanceof HTMLElement?e.relatedTarget:document.body:null,r=n||document.body,s=t.fromElement(i),o=t.fromElement(r),a=ki.getCommonAncestor(s,o||r),l=Boolean(i&&4&r.compareDocumentPosition(i)),c=t.query(zi);let u=null;if(u=r&&r!==document.body?ki.getActiveElement(r):ki.getActiveElement(document),c&&!c._isRevertingFocus&&(!o||!c.owns(o)&&!(4&c.element.compareDocumentPosition(o.element)&&o.up($i))))return c.focus();let h=Ji("focusout",i,n,s,o,l);for(let e,t=s;t&&t!==a;t=e)if(e=t.owner,!t.isDestroying&&t.onFocusOut&&(t.onFocusOut(h),n&&u!==ki.getActiveElement(n)))return;if(a&&n===a.element)!a.isDestroying&&ki.getActiveElement(a)===r&&a.focusElement&&a.focusElement!==a.element&&(a.element.contains(u)&&!a.focusDescendant||a.setTimeout((()=>{var e;return null===(e=a.focus)||void 0===e?void 0:e.call(a)}),0));else{h=Ji("focusin",r,i,s,o,l);for(let e=o;e&&e!==a;e=e.owner){var g,m;if(!e.isDestroying)null===(g=(m=e).onFocusIn)||void 0===g||g.call(m,h)}}const p=ki.getCommonAncestor((null==i?void 0:i.nodeType)===Element.ELEMENT_NODE?i:null,r)||r.parentNode;p&&(h=Ji("focusmove",r,i,s,o,l,{bubbles:!0}),p.dispatchEvent(h))},focusout(e){if(!Zi&&(!e.target.classList.contains("tox-tinymce-aux")||e.isTrusted)&&(!e.relatedTarget||!Hi.Widget.fromElement(e.relatedTarget))){const t=e.relatedTarget&&e.relatedTarget instanceof HTMLElement?e.relatedTarget:null;a.focusin({target:t,relatedTarget:e.target}),Gi=qi=null}},blur:{element:globalThis,handler(e){e.target===globalThis&&(Gi=null,qi=null)}},capture:!0,passive:!0};n&&(null===(i=Xi)||void 0===i||i()),Xi=this.detachEvents=e.$globalEventsDetacher=t.on(a)}get activeTouchCount(){return Oi.size}get activeTouches(){return Array.from(Oi.values())}get hasActiveTouches(){return Oi.size>0}get lastInteractionType(){return Ui}get shiftKeyDown(){var e;return Boolean(null===(e=Gi)||void 0===e?void 0:e.shiftKey)}get ctrlKeyDown(){var e,t;return Boolean((null===(e=Gi)||void 0===e?void 0:e.ctrlKey)||(null===(t=Gi)||void 0===t?void 0:t.metaKey))}get altKeyDown(){var e;return Boolean(null===(e=Gi)||void 0===e?void 0:e.altKey)}get currentOverElement(){return Ki}isKeyDown(e){var t;return e?(null===(t=Gi)||void 0===t?void 0:t.key)===e||!0===Gi[(null==e?void 0:e.toLowerCase())+"Key"]:Boolean(Gi)}isMouseDown(e=0){var t;return(null===(t=qi)||void 0===t?void 0:t.button)===e}get currentMouseDown(){return qi}set currentMouseDown(e){qi=e}get currentPointerDown(){return Yi}set currentPointerDown(e){Yi=e}get currentTouch(){return Ni}set currentTouch(e){Ni=e}get currentKeyDown(){return Gi}set currentKeyDown(e){Gi=e}},zi=e=>e.isTopModal;Hi.observedElements=new Set;let Ni,Wi,Ui,Gi,qi,Yi,Ki,Xi,Zi=!1;function Ji(e,t,n,i,r,s,o){const a=new CustomEvent(e,o);return Object.defineProperty(a,"_target",{get:()=>t}),Object.defineProperty(a,"relatedTarget",{get:()=>n}),a.fromWidget=i,a.toWidget=r,a.backwards=s,a}const Qi=/^(\w+)=(.*)$/;class er{static DEFAULT_FETCH_OPTIONS={};static get(e,t){return this.fetch(e,t)}static post(e,t,n={}){return n=C.assign({},n),t instanceof FormData||"string"==typeof t||(t=JSON.stringify(t),n.headers=n.headers||{},n.headers["Content-Type"]=n.headers["Content-Type"]||"application/json"),this.fetch(e,Object.assign({method:"POST",body:t},n))}static fetch(e,t){let n;if(t=C.merge({},er.DEFAULT_FETCH_OPTIONS,t),"undefined"!=typeof AbortController&&(n=t.abortController?t.abortController:t.abortController=new AbortController,t.signal=n.signal),t.queryParams){const n=Object.entries(t.queryParams);if(n.length){let i=!1;if(t.headers&&!0===t.addQueryParamsToBody){let e;switch(new Headers(t.headers).get("Content-Type")){case"application/x-www-form-urlencoded":e=URLSearchParams;break;case"multipart/form-data":e=FormData}if(e){const r=t.body||(t.body=new e);r instanceof e&&(n.forEach((([e,t])=>r.set(e,t))),i=!0)}}i||(e+=(e.includes("?")?"&":"?")+n.map((([e,t])=>`${e}=${encodeURIComponent(t)}`)).join("&"))}}const i=new Promise(((n,r)=>{fetch(e,t).then((e=>{t.parseJson?e.json().then((t=>{e.parsedJson=t,n(e)})).catch((t=>{e.parsedJson=null,e.error=t,r(e)})):n(e)})).catch((e=>{e.stack=i.stack,r(e)}))}));return i.stack=(new Error).stack,i.abort=function(){var e;null===(e=n)||void 0===e||e.abort(new DOMException("User aborted request","AbortError")),this.aborted=!0},i}static mockUrl(e,t){const n=this;(n.mockAjaxMap||(n.mockAjaxMap={}))[e]=t,er.originalFetch||(er.originalFetch=er.fetch,er.fetch=n.mockAjaxFetch.bind(n))}static async mockAjaxFetch(e,t){const n=e.split("?");let i=this.mockAjaxMap[n[0]],r=null;if(i){"function"==typeof i&&(i=await i(n[0],n[1]&&function(e){const t={},n=e.split("&");for(const e of n){const[n,i,r]=Qi.exec(e),s=decodeURIComponent(i),o=decodeURIComponent(r);if(n){let e=t[s];e?(Array.isArray(e)||(e=t[s]=[e]),e.push(o)):t[s]=o}}return t}(n[1]),t));try{r=(null==t?void 0:t.parseJson)&&JSON.parse(i.responseText)}catch(e){r=null,i.error=e}return i=Object.assign({status:200,ok:!0,headers:new Headers,statusText:"OK",url:e,parsedJson:r,text:()=>new Promise((e=>{e(i.responseText)})),json:()=>new Promise((e=>{e(r)}))},i),new Promise((function(e,t){i.synchronous?e(i):setTimeout((function(){e(i)}),"delay"in i?i.delay:100)}))}return er.originalFetch(e,t)}}er._$name="AjaxHelper";class tr{static skipLocaleIntegrityCheck=!1;static mergeLocales(...e){const t={};return e.forEach((e=>{Object.keys(e).forEach((n=>{"object"==typeof e[n]?t[n]={...t[n],...e[n]}:t[n]=e[n]}))})),t}static trimLocale(e,t){const n=(t,n)=>{e[t]&&(n?e[t][n]&&delete e[t][n]:delete e[t])};Object.keys(t).forEach((e=>{Object.keys(t[e]).length>0?Object.keys(t[e]).forEach((t=>n(e,t))):n(e)}))}static normalizeLocale(e,t){if(!e)throw new Error('"nameOrConfig" parameter can not be empty');if("string"==typeof e){if(!t)throw new Error('"config" parameter can not be empty');t.locale?t.name=e||t.name:t.localeName=e}else t=e;let n={};if(t.name||t.locale)n=Object.assign({localeName:t.name},t.locale),t.desc&&(n.localeDesc=t.desc),t.code&&(n.localeCode=t.code),t.path&&(n.localePath=t.path);else{if(!t.localeName)throw new Error('"config" parameter doesn\'t have "localeName" property');n=Object.assign({},t)}for(const e of["name","desc","code","path"])n[e]&&delete n[e];if(!n.localeName)throw new Error("Locale name can not be empty");return n}static get locales(){return tr.global.bryntum.locales||{}}static set locales(e){tr.global.bryntum.locales=e}static get localeName(){return tr.global.bryntum.locale||"En"}static set localeName(e){tr.global.bryntum.locale=e||tr.localeName}static get locale(){return tr.localeName&&this.locales[tr.localeName]||this.locales.En||Object.values(this.locales)[0]||{localeName:"",localeDesc:"",localeCoode:""}}static publishLocale(e,t){const{locales:n}=tr.global.bryntum,i=tr.normalizeLocale(e,t),{localeName:r}=i;return n[r]&&!0!==t?n[r]=this.mergeLocales(n[r]||{},i||{}):n[r]=i,n[r]}static get global(){return globalThis}}tr.global.bryntum=tr.global.bryntum||{},tr.global.bryntum.locales=tr.global.bryntum.locales||{},tr._$name="LocaleHelper";class nr extends(dt(tt)){static configurable={throwOnMissingLocale:q.isTestEnv};construct(...e){const t=this;if(super.construct(...e),d.isBrowserEnv){var n;const e=document.querySelector("script[data-default-locale]");e?t.applyLocale(e.dataset.defaultLocale):null!==(n=t.locale)&&void 0!==n&&n.localeName&&t.applyLocale(t.locale.localeName)}}get locales(){return tr.locales}set locales(e){tr.locales=e}set locale(e){this.applyLocale(e)}get locale(){return tr.locale}get localeCode(){var e;return(null===(e=this.locale)||void 0===e?void 0:e.localeCode)??"en-US"}applyLocale(e,t,n=!1){const i=this;let r;if("string"==typeof e)if("object"!=typeof t){if(r=i.locales[e],!r){if(n)return!0;throw new Error(`Locale "${e}" is not published. Publish with LocaleHelper.publishLocale() before applying.`)}}else r=tr.publishLocale(e,t);else r=tr.publishLocale(e);if(i.locale.localeName&&i.locale.localeName===r.localeName&&!0!==t)return i.locale;r.oldLocaleName=i.locale.localeName,r.oldLocaleCode=i.locale.localeCode,tr.localeName=r.localeName;const s=()=>{i.trigger("locale",r)};return r.localePath?new Promise(((e,t)=>{i.loadLocale(r.localePath).then((t=>{t.text().then((t=>{new Function(t)(),d.isBrowserEnv&&(r=i.locales[r.localeName],r&&delete r.localePath),s(),e(r)}))})).catch((e=>t(e)))})):(s(),r)}loadLocale(e){return er.get(e)}}const ir=new nr,rr=Object.getPrototypeOf(Object),sr=/L{.*?}/g,or=/L{(.*?)}/g,ar=/((.*?)\.)?(.+)/g,lr=e=>e.replace(/\[\[(\d+)]]/gm,"{$1}"),cr=Object.freeze(Object.create(null));var dr=e=>class t extends(e||tt){static $name="Localizable";static get configurable(){return{localeClass:null,localizable:null,localizableProperties:{value:[],$config:{merge:"distinct"}}}}static clsName(e){var t,n;return"string"==typeof e?e:e===rr?"Object":e.$$name||e.name||(null===(t=e.prototype)||void 0===t?void 0:t.$$name)||(null===(n=e.prototype)||void 0===n?void 0:n.name)}static parseLocaleString(e){var t;const n=[];let i;if(null!==(t=e)&&void 0!==t&&t.includes("L{"))for(e=e.replace(/{(\d+)}/gm,"[[$1]]"),or.lastIndex=0;null!=(i=or.exec(e));){ar.lastIndex=0;const e=ar.exec(i[1]);n.push({match:lr(i[0]),localeKey:lr(e[3]),localeClass:e[2]})}return n.length>0?n:[{match:e,localeKey:e,localeClass:void 0}]}construct(e={},...t){super.construct(e,...t),ir.ion({locale:"updateLocalization",thisObj:this}),this.updateLocalization()}get localeClass(){return this._localeClass||null}localizeProperty(e){var n,i;const r=this,s=C.getPath(r,e),o=(null===(n=r.$meta.configs[e])||void 0===n?void 0:n.localeKey)||(null===(i=r.fieldMap)||void 0===i||null===(i=i[e])||void 0===i?void 0:i.defaultValue);let a;if(o){if(a=t.localize(o,r,r.localeClass||r),!a||e in(r.initialConfig||cr)||e in(r.originalData||cr))return s;C.setPath(r.isColumn?r.data:r,e,a)}else"string"==typeof s&&(r.originalLocales=r.originalLocales||{},a=C.getPath(r.originalLocales,e),void 0===a&&(C.setPath(r.originalLocales,e,s),a=s),a&&C.setPath(r,e,a=r.optionalL(a,r)));return a||s}updateLocalization(){var e,t;!1!==this.localizable&&(null===(e=this.localizableProperties)||void 0===e||e.forEach(this.localizeProperty,this),null===(t=this.trigger)||void 0===t||t.call(this,"localized"))}static getTranslation(e,n,i){const r=ir.locale;let s,o,a=null;if(r)for(const{match:l,localeKey:c,localeClass:d}of this.parseLocaleString(e)){const u=t=>{var s;const o=null===(s=r[t])||void 0===s?void 0:s[c];return o&&(a="function"==typeof o?null!=n?o(n):o:"object"==typeof o||e===l?o:(a||e).replace(l,o),"string"==typeof o&&o.includes("L{")&&(a=this.getTranslation(o,n,i))),o};let h=!1;for(o=i;o&&(s=t.clsName(o))&&!(h=u(s))&&"string"!=typeof o;o=Object.getPrototypeOf(o));!h&&d&&u(d)}return a}static localize(e,n=void 0,...i){var r;0===(null===(r=i)||void 0===r?void 0:r.length)&&(i=[this]);let s=null;return i.some((i=>(s=t.getTranslation(e,n,i),null!=s))),s}static L(e,n=void 0,...i){var r;0===(null===(r=i)||void 0===r?void 0:r.length)&&(i=[this]);const s=this.localize(e,n,...i);if(null==s&&ir.throwOnMissingLocale&&e.includes("L{"))throw new Error(`Localization is not found for '${e}' in '${i.map((e=>t.clsName(e))).join(", ")}'. ${ir.locale.localeName?`Locale : ${ir.locale.localeName}`:""}`);return s??e}L(e,n,i=this.localeClass){const{constructor:r}=this;return i&&t.clsName(i)!==t.clsName(r)?t.L(e,n,i,r):t.L(e,n,r)}static optionalL(e,n=void 0,...i){var r;const s=ir.throwOnMissingLocale;ir.throwOnMissingLocale=s&&sr.test(e),0===(null===(r=i)||void 0===r?void 0:r.length)&&(i=[this]);const o=t.L(e,n,...i);return ir.throwOnMissingLocale=s,o}optionalL(e,t=this,n=!1){const i=ir.throwOnMissingLocale;ir.throwOnMissingLocale=i&&sr.test(e)&&!n;const r=this.L(e,t);return ir.throwOnMissingLocale=i,r}get localeManager(){return ir}get localeHelper(){return tr}};class ur extends(tt.mixin(dt,dr)){static $name="InstancePlugin";static configurable={disabled:!1,client:null,keyMap:null};static properties={clientListeners:null};onConfigChange(...e){var t,n;(super.onConfigChange(...e),this.isConfiguring)||(null===(t=this.client)||void 0===t||null===(n=t.afterPluginConfigChange)||void 0===n||n.call(t,{plugin:this,...e[0]}))}updateClient(e){this.owner||(this.owner=e)}updateKeyMap(e){const{client:t}=this;t.keyMap=t.mergeKeyMaps(t.keyMap,e,V.uncapitalize(this.constructor.$name))}static initPlugins(e,...t){for(const n of t)this.initPlugin(e,n)}static initPlugin(e,t,n){const i=e.plugins||(e.plugins={}),r=[e];return n&&r.push(n),i[t.$$name]=new t(...r)}get enabled(){return!this.disabled}getFocusRevertTarget(){var e;return null===(e=this.client)||void 0===e?void 0:e.getFocusRevertTarget()}construct(...e){const t=this;let n,[i,r]=e;1===e.length?U.isObject(i)&&(r=i,i=r.client):(r=U.assign({},r),delete r.client),t.client=i,super.construct(r),t.applyPluginConfig(i),n=t.clientListeners,n&&(n=U.assign({},n),n.thisObj=t,i.ion(n))}applyPluginConfig(e){const t=this,n=t.pluginConfig||t.constructor.pluginConfig;if(n){const{assign:i,chain:r,after:s,before:o,override:a}=n;i&&t.applyAssign(e,i),(r||s)&&t.applyChain(e,r||s),o&&t.applyChain(e,o,!1),a&&t.applyOverride(e,a)}}applyAssign(e,t){t.forEach((t=>this.assign(e,t)))}applyChain(e,t,n=!0){if(Array.isArray(t))for(const i of t)this.chain(e,i,i,n);else for(const i in t)this.chain(e,i,t[i],n)}applyOverride(e,t){const n=this;n.overridden||(n.overridden={}),t.forEach((t=>{if(!n[t])throw new Error(`Trying to chain fn ${e.$$name}#${t}, but plugin fn ${n.$$name}#${t} does not exist`);"function"==typeof e[t]&&(n.overridden[t]=e[t].bind(e)),e[t]=n[t].bind(n)}))}assign(e,t){const n=this,i=function(e,t){const n=U.getPropertyDescriptor(e,t);return n&&(n.get||n.set)?n:null}(n,t);i?Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get:i.get&&i.get.bind(n),set:i.set&&i.set.bind(n)}):e[t]=n[t].bind(n)}chain(e,t,n,i=!0){let r=0;"object"==typeof t&&(t=t.fn),"object"==typeof n&&(r=n.prio||0,n=n.fn);const s=this,o=e.pluginFunctionChain||(e.pluginFunctionChain={}),a=s[n]&&s[n].bind(s),l=s.functionChainRunner;if(!a)throw new Error(`Trying to chain fn ${e.$$name}#${n}, but plugin fn ${s.$$name}#${n} does not exist`);if(!o[t]){let n=e[t];n&&(n=n.bind(e),n.$this=e,n.$prio=0),o[t]=n?[n]:[],e[t]=(...e)=>l(o[t],e)}a.$this=s,a.$prio=r,o[t][i?"push":"unshift"](a),o[t].$sorted=!1}functionChainRunner(e,t){let n,i,r;for(e.$sorted||(e.sort(((e,t)=>t.$prio-e.$prio)),e.$sorted=!0),i=0;i<e.length&&(n=e[i],n.$this.isDestroyed||(r=n(...t),!1!==r));i++);return r}doDisable(e){const t=this,{constructor:n}=t,i="featureClass"in n?n.featureClass:`b-${n.$$name.toLowerCase()}`,r=V.uncapitalize(n.$$name);var s,o,a;i&&(null===(s=t.client)||void 0===s||null===(s=s._element)||void 0===s||s.classList[e?"remove":"add"](i));t.isConfiguring||(e?t.trigger("disable"):t.trigger("enable"),null===(o=(a=t.client).syncSplits)||void 0===o||o.call(a,(t=>{const n=t.features[r];n&&(n.disabled=e)})))}updateDisabled(e){this.doDisable(e)}throwOverrideIsMissing(e){throw new Error(`Trying to override fn ${e.plugIntoName}#${e.fnName}, but plugin fn ${e.pluginName}#${e.fnName} does not exist`)}get rootElement(){return this.client.rootElement}get state(){var e;return null===(e=this.constructor.stateProperties)||void 0===e?void 0:e.reduce(((e,t)=>(e[t]=this[t],e)),{})}}ur._$name="InstancePlugin";var hr=e=>class extends(e||tt){static $name="Pluggable";get plugins(){return this._plugins||(this._plugins={}),this._plugins}set plugins(e){e&&(Array.isArray(e)||(e=[e]),ur.initPlugins(this,...e)),this.initPlugins()}initPlugins(){}addPlugins(...e){ur.initPlugins(this,...e)}addPlugin(e,t){return ur.initPlugin(this,e,t)}hasPlugin(e){return null!=this.getPlugin(e)}getPlugin(e){var t;return"function"==typeof e&&(e=e.$$name),null===(t=this.plugins)||void 0===t?void 0:t[e]}get widgetClass(){}};tr.publishLocale({localeName:"En",localeDesc:"English (US)",localeCode:"en-US",localeRtl:!1,Object:{Yes:"Yes",No:"No",Cancel:"Cancel",Ok:"OK",Week:"Week",None:"None",previous:"Previous",next:"Next",to:"to",at:"At",on:"On",editing:e=>`Editing ${e}`,settings:"Settings",close:"Close",go:"Go",save:"Save",cancel:"Cancel",revert:"Revert",collapse:"Collapse",expand:"Expand",today:"Today"},CheckboxGroup:{wrongNbrOfOptionsSelected:e=>`Select exactly ${e}`,tooFewOptionsSelected:e=>`Select at least ${e}`,tooManyOptionsSelected:e=>`Select no more than ${e}`},CodeEditor:{apply:"Apply",autoApply:"Auto apply",downloadCode:"Download code",editor:"Code editor",viewer:"Code viewer"},ColorPicker:{noColor:"No color"},Combo:{noResults:"No results",recordNotCommitted:"Record could not be added",addNewValue:e=>`Add ${e}`},FilePicker:{file:"File"},Field:{badInput:"Invalid field value",patternMismatch:"Value should match a specific pattern",rangeOverflow:e=>`Value must be less than or equal to ${e.max}`,rangeUnderflow:e=>`Value must be greater than or equal to ${e.min}`,stepMismatch:"Value should fit the step",tooLong:"Value should be shorter",tooShort:"Value should be longer",typeMismatch:"Value is required to be in a special format",valueMissing:"This field is required",invalidValue:"Invalid field value",minimumValueViolation:"Minimum value violation",maximumValueViolation:"Maximum value violation",fieldRequired:"This field is required",validateFilter:"Value must be selected from the list"},DateField:{invalidDate:e=>"Invalid date input, expected format is "+e},DatePicker:{gotoPrevYear:"Go to previous year",gotoPrevMonth:"Go to previous month",gotoNextMonth:"Go to next month",gotoNextYear:"Go to next year"},Hint:{dontShowAgain:"Don't show again"},NumberFormat:{locale:"en-US",currency:"USD"},DurationField:{invalidUnit:"Invalid unit"},TimeField:{invalidTime:"Invalid time input"},TimePicker:{hour:"Hour",minute:"Minute",second:"Second"},List:{loading:"Loading...",selectAll:"Select All"},GridBase:{loadMask:"Loading...",syncMask:"Saving changes, please wait..."},PagingToolbar:{firstPage:"Go to first page",prevPage:"Go to previous page",page:"Page",nextPage:"Go to next page",lastPage:"Go to last page",reload:"Reload current page",noRecords:"No records to display",pageCountTemplate:e=>`of ${e.lastPage}`,summaryTemplate:e=>`Displaying records ${e.start} - ${e.end} of ${e.allCount}`},Popup:{close:"Close",maximize:"Maximize"},TabPanel:{containsInvalidFields:"Tab contains invalid fields"},Toolbar:{showOverflowingItems:"Show overflowing items",scrollForMore:"Scroll for more"},UndoRedo:{Undo:"Undo",Redo:"Redo",UndoLastAction:"Undo last action",RedoLastAction:"Redo last undone action",NoActions:"No items in the undo queue"},FieldFilterPicker:{equals:"equals",doesNotEqual:"does not equal",isEmpty:"empty",isNotEmpty:"not empty",contains:"contains",doesNotContain:"does not contain",startsWith:"starts with",endsWith:"ends with",isOneOf:"one of",isNotOneOf:"not one of",isGreaterThan:"greater than",isLessThan:"less than",isGreaterThanOrEqualTo:"greater or equals",isLessThanOrEqualTo:"less or equals",isBetween:"between",isNotBetween:"not between",isBefore:"before",isAfter:"after",timeEquals:"time equals",timeDoesNotEqual:"time does not equal",isToday:"today",isTomorrow:"tomorrow",isYesterday:"yesterday",isThisWeek:"this week",isNextWeek:"next week",isLastWeek:"last week",isThisMonth:"this month",isNextMonth:"next month",isLastMonth:"last month",isThisYear:"this year",isNextYear:"next year",isLastYear:"last year",isYearToDate:"year to date",isTrue:"true",isFalse:"false",selectAProperty:"Select property",selectAnOperator:"Select operator",caseSensitive:"Case-sensitive",and:"and",dateFormat:"D/M/YY",selectValue:"Select value",selectOneOrMoreValues:"Select value(s)",enterAValue:"Enter value",enterANumber:"Enter number",selectADate:"Select date",selectATime:"Select time"},FieldFilterPickerGroup:{addFilter:"Add filter",applyCond:e=>e?"Skip filter (currently applied)":"Apply filter (currently skipped)"},DateHelper:{locale:"en-US",weekStartDay:0,nonWorkingDays:{0:!0,6:!0},weekends:{0:!0,6:!0},unitNames:[{single:"millisecond",plural:"ms",abbrev:"ms"},{single:"emillisecond",plural:"ems",abbrev:"ems"},{single:"second",plural:"seconds",abbrev:"s"},{single:"esecond",plural:"eseconds",abbrev:"es"},{single:"minute",plural:"minutes",abbrev:"min"},{single:"eminute",plural:"eminutes",abbrev:"emin"},{single:"hour",plural:"hours",abbrev:"h"},{single:"ehour",plural:"ehours",abbrev:"eh"},{single:"day",plural:"days",abbrev:"d"},{single:"eday",plural:"edays",abbrev:"ed"},{single:"week",plural:"weeks",abbrev:"w"},{single:"eweek",plural:"eweeks",abbrev:"ew"},{single:"month",plural:"months",abbrev:"mon"},{single:"emonth",plural:"emonths",abbrev:"emon"},{single:"quarter",plural:"quarters",abbrev:"q"},{single:"equarter",plural:"equarters",abbrev:"eq"},{single:"year",plural:"years",abbrev:"yr"},{single:"eyear",plural:"eyears",abbrev:"eyr"},{single:"decade",plural:"decades",abbrev:"dec"},{single:"edecade",plural:"edecades",abbrev:"edec"}],unitAbbreviations:[["mil"],["emil"],["s","sec"],["es","esec"],["m","min"],["em","emin"],["h","hr"],["eh","ehr"],["d"],["ed"],["w","wk"],["ew","ewk"],["mo","mon","mnt","M"],["emo","emon","emnt"],["q","quar","qrt"],["eq","equar","eqrt"],["y","yr"],["ey","eyr"],["dec"],["edec"]],parsers:{L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A"},ordinalSuffix:e=>{let t="th";if(!["11","12","13"].find((t=>e.endsWith(t)))){t={1:"st",2:"nd",3:"rd"}[e[e.length-1]]||"th"}return e+t},decade:e=>{const t="number"==typeof e?e:e.getFullYear();return t-t%10+"s"}}});const{toString:gr}=Object.prototype,mr=gr.call(new Date),pr=new Date,fr=36e5,vr=(e,t)=>isNaN(e)||null==e?t:e,yr=/([ES]){([^}]+)}/g,br=e=>{let t="th";if(!["11","12","13"].find((t=>e.endsWith(t)))){t={1:"st",2:"nd",3:"rd"}[e[e.length-1]]||"th"}return e+t},Cr=(e,t,n,i=Qr)=>(i[e]=i[e]||{[e]:1},i[t]=i[t]||{[t]:1},i[e][t]=n,i[t][e]=1/n,i),Sr=(e,t,n)=>($r[e]||($r[e]=new Intl.DateTimeFormat(Ar,t))).format(n),wr=(e,t,n,i=!1)=>{let r=Sr(e,t,n);return/am|pm/i.test(r)&&(r=r.replace(/^0/,""),i&&(r=r.replace(/:00/,""))),r},Dr=e=>e>=0?e:e+7,Er=/([^\w])(S+)/gm,xr=(e,t)=>t+"SSS",Rr=/[:.\-/\s]/,Tr=/^(?:יום |ال)/,Mr=/(Z{1,2})$/,Ir=/(?:Z|[+-]\d{2}:\d{2})$/;let kr,Fr,Ar="en-US",Pr=br,Lr={},Or={},$r={},_r={},jr={},Br="AM",Vr="PM",Hr=fr;const zr=e=>{const t=Wr[e];if(!t)throw new Error("Only international formats should be used here");if(void 0!==Or[e])return Or[e];const n=new Intl.DateTimeFormat(Ar,t).formatToParts(new Date(2001,1,2,3,4,5,6)).map((e=>{const n=e.type,i=t[n];return"literal"===n?e.value.replace(/,/g,""):"day"===n?"numeric"===i?"D":"DD":"month"===n?"short"===i?"MMM":"long"===i?"MMMM":"numeric"===i?"M":"MM":"year"===n?"numeric"===i?"YYYY":"YY":void 0})).join("");return Or[e]=n},Nr=2020,Wr={l:{year:"numeric",month:"numeric",day:"numeric"},ll:{year:"numeric",month:"short",day:"numeric"}},Ur={M:e=>e.getMonth()+1,Mo:e=>Pr(Ur.M(e).toString()),MM:e=>(e.getMonth()+1).toString().padStart(2,"0"),MMM:e=>Sr("MMM",{month:"short"},e),MMMM:e=>Sr("MMMM",{month:"long"},e),DC:e=>us.localize("L{decade}",e),Q:e=>Math.ceil((e.getMonth()+1)/3),Qo:e=>Pr(Ur.Q(e).toString()),D:e=>e.getDate(),Do:e=>Pr(Ur.D(e).toString()),DD:e=>e.getDate().toString().padStart(2,"0"),DDD:e=>Math.ceil((new Date(e.getFullYear(),e.getMonth(),e.getDate(),12,0,0)-new Date(e.getFullYear(),0,0,12,0,0))/Qr.day.millisecond),DDDo:e=>Pr(Ur.DDD(e).toString()),DDDD:e=>Ur.DDD(e).toString().padStart(3,"0"),d:e=>e.getDay(),do:e=>Pr(e.getDay().toString()),d1:e=>Sr("d1",{weekday:"narrow"},e).substr(0,1),dd:e=>Ur.ddd(e).substring(0,2),ddd:e=>{var t;return kr=Sr("ddd",{weekday:"short"},e),Fr=null===(t=kr.match(Tr))||void 0===t?void 0:t[0],kr.substring(Fr?Fr.length:0)},dddd:e=>{var t;return kr=Sr("dddd",{weekday:"long"},e),Fr=null===(t=kr.match(Tr))||void 0===t?void 0:t[0],kr.substring(Fr?Fr.length:0)},u:e=>{const t=($r.u||($r.u=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",year:"numeric",month:"2-digit",day:"2-digit"}))).formatToParts(e);return`${t[4].value}${t[2].value}${t[0].value}Z`},uu:e=>{const t=($r.uu||($r.uu=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",hour12:!1,year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit"}))).formatToParts(e);return`${t[4].value}${t[2].value}${t[0].value}T${t[6].value}${t[8].value}${t[10].value}Z`},e:e=>e.getDay(),E:e=>e.getDay()+1,W:e=>us.getWeekNumber(e)[1],Wo:e=>Pr(Ur.W(e).toString()),WW:e=>Ur.W(e).toString().padStart(2,"0"),Wp:e=>`${us.localize("L{Week}")} ${Ur.W(e)}`,WWp:e=>`${us.localize("L{Week}")} ${Ur.WW(e)}`,Wp0:e=>`${us.localize("L{Week}")[0]}${Ur.W(e)}`,WWp0:e=>`${us.localize("L{Week}")[0]}${Ur.WW(e)}`,Y:e=>e.getFullYear(),YY:e=>(e.getFullYear()%100).toString().padStart(2,"0"),YYYY:e=>e.getFullYear(),A:e=>(e.getHours()<12?Br:Vr).toLocaleUpperCase(),a:e=>(e.getHours()<12?Br:Vr).toLocaleLowerCase(),H:e=>e.getHours(),HH:e=>e.getHours().toString().padStart(2,"0"),h:e=>e.getHours()%12||12,hh:e=>Ur.h(e).toString().padStart(2,"0"),k:e=>e.getHours()||24,kk:e=>Ur.k(e).toString().padStart(2,"0"),K:e=>wr("K",{hour:"numeric"},e),KK:e=>wr("KK",{hour:"2-digit"},e),m:e=>e.getMinutes(),mm:e=>Ur.m(e).toString().padStart(2,"0"),s:e=>e.getSeconds(),ss:e=>Ur.s(e).toString().padStart(2,"0"),S:e=>Math.floor(e.getMilliseconds()/100).toString(),SS:e=>Math.floor(e.getMilliseconds()/10).toString().padStart(2,"0"),SSS:e=>e.getMilliseconds().toString().padStart(3,"0"),z:e=>Sr("z",{timeZoneName:"short"},e),zz:e=>Sr("zz",{timeZoneName:"long"},e),Z:e=>hs.getGMTOffset(e),LT:e=>wr("LT",{hour:"2-digit",minute:"2-digit"},e),LST:e=>wr("LST",{hour:"numeric",minute:"2-digit"},e,!0),LTS:e=>wr("LTS",{hour:"2-digit",minute:"2-digit",second:"2-digit"},e),L:e=>Sr("L",{year:"numeric",month:"2-digit",day:"2-digit"},e),l:e=>Sr("l",Wr.l,e),LL:e=>Sr("LL",{year:"numeric",month:"long",day:"numeric"},e),ll:e=>Sr("ll",Wr.ll,e),LLL:e=>Sr("LLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit"},e),lll:e=>Sr("lll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit"},e),LLLL:e=>Sr("LLLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"long"},e),llll:e=>Sr("llll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"short"},e)},Gr=`^(?:${Object.keys(Ur).sort(((e,t)=>t.length-e.length)).join("|")})`,qr=()=>({}),Yr=e=>(e=>as.test(e))(e)&&{milliseconds:parseInt(e.padEnd(3,"0").substring(0,3))},Kr={YYYY:e=>{const t=parseInt(e);return{year:t>=1e3&&t<=9999?t:NaN}},Y:e=>({year:parseInt(e)}),YY:e=>{const t=parseInt(e);return{year:t+(t>1968?1900:2e3)}},M:e=>({month:parseInt(e)-1}),MM:e=>({month:parseInt(e)-1}),Mo:e=>({month:parseInt(e)-1}),MMM:e=>{const t=(e||"").toLowerCase();for(const[e,n]of Object.entries(us._monthShortNamesIndex))if(t.startsWith(e))return{month:n.value}},MMMM:e=>{const t=(e||"").toLowerCase();for(const[e,n]of Object.entries(us._monthNamesIndex))if(t.startsWith(e))return{month:n.value}},DD:e=>({date:parseInt(e)}),D:e=>({date:parseInt(e)}),Do:e=>({date:parseInt(e)}),DDD:qr,DDDo:qr,DDDD:qr,d:qr,do:qr,d1:qr,dd:qr,ddd:qr,dddd:qr,Q:qr,Qo:qr,W:qr,Wo:qr,WW:qr,e:qr,E:qr,HH:e=>({hours:parseInt(e)}),hh:e=>({hours:parseInt(e)}),mm:e=>({minutes:parseInt(e)}),H:e=>({hours:parseInt(e)}),m:e=>({minutes:parseInt(e)}),ss:e=>({seconds:parseInt(e)}),s:e=>({seconds:parseInt(e)}),S:Yr,SS:Yr,SSS:Yr,A:e=>({amPm:e.toLowerCase()}),a:e=>({amPm:e.toLowerCase()}),L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A",l:{type:"dynamic",parser:()=>zr("l")},ll:{type:"dynamic",parser:()=>zr("ll")},Z:e=>{if(!e||!ls.test(e)&&"Z"!==e)return null;let t=0;if("Z"!==e){const n=ls.exec(e);if(n){t=("+"===n[1]?1:-1)*(60*(parseInt(n[2])||0)+(parseInt(n[3])||0))}else t=-1*(new Date).getTimezoneOffset()}return{timeZone:t}}},Xr=Object.keys(Kr).sort(((e,t)=>t.length-e.length)),Zr=new RegExp(`(${Xr.join("|")})`),Jr=new RegExp("^(LL|LLL|lll|LLLL|llll)$"),Qr={decade:{decade:1,year:10,quarter:40,month:120,week:520,day:3652,hour:87648,minute:5258880,second:315532800,millisecond:3155328e5},year:{decade:.1,year:1,quarter:4,month:12,week:52,day:365,hour:8760,minute:525600,second:31536e3,millisecond:31536e6},quarter:{decade:1/40,year:1/4,quarter:1,month:3,week:4,day:91,hour:2184,minute:131040,second:7862400,millisecond:78624e5},month:{decade:1/120,year:1/12,quarter:1/3,month:1,week:4,day:-30,hour:-720,minute:-43200,second:-2592e3,millisecond:-2592e6},week:{decade:-1/520,year:-1/52,quarter:-1/13,month:-1/4,day:7,hour:168,minute:10080,second:604800,millisecond:6048e5},day:{decade:-1/3652,year:-1/365,quarter:-1/91,month:-1/30,week:1/7,hour:24,minute:1440,second:86400,millisecond:864e5},hour:{decade:-1/87648,year:-1/8760,quarter:-1/2184,month:-1/720,week:1/168,day:1/24,minute:60,second:3600,millisecond:36e5},minute:{decade:-1/5258880,year:-1/525600,quarter:-1/131040,month:-1/43200,week:1/10080,day:1/1440,hour:1/60,second:60,millisecond:6e4},second:{decade:-1/315532800,year:-1/31536e3,quarter:-1/7862400,month:-1/2592e3,week:1/604800,day:1/86400,hour:1/3600,minute:1/60,millisecond:1e3},millisecond:{decade:-1/3155328e5,year:-1/31536e6,quarter:-1/78624e5,month:-1/2592e6,week:1/6048e5,day:1/864e5,hour:1/36e5,minute:1/6e4,second:.001}},es={ms:"millisecond",milliseconds:"millisecond",ems:"emillisecond",emilliseconds:"emillisecond",s:"second",seconds:"second",es:"esecond",eseconds:"esecond",m:"minute",mi:"minute",min:"minute",minutes:"minute",em:"eminute",emi:"eminute",emin:"eminute",eminutes:"eminute",h:"hour",hours:"hour",eh:"ehour",ehours:"ehour",d:"day",days:"day",ed:"eday",edays:"eday",w:"week",weeks:"week",ew:"eweek",eweeks:"eweek",M:"month",mo:"month",mon:"month",months:"month",EM:"emonth",eM:"emonth",emo:"emonth",emon:"emonth",emonths:"emonth",q:"quarter",quarters:"quarter",eq:"equarter",equarters:"equarter",y:"year",years:"year",ey:"eyear",eyears:"eyear",dec:"decade",decades:"decade",edec:"edecade",edecades:"edecade"},ts=/^\s*([-+]?\d+(?:[.,]\d*)?|[-+]?(?:[.,]\d+))\s*([^\s]+)?/i,ns=/^\s*([-+]?\d+)(?![.,])\s*([^\s]+)?/i,is=["millisecond","emillisecond","second","esecond","minute","eminute","hour","ehour","day","eday","week","eweek","month","emonth","quarter","equarter","year","eyear","decade","edecade"],rs=[["ms","mil"],["ems","emil"],["s","sec"],["es","esec"],["m","min"],["em","emin"],["h","hr"],["eh","ehr"],["d"],["ed"],["w","wk"],["ew","ewk"],["mo","mon","mnt","M"],["emo","emon","emnt"],["q","quar","qrt"],["eq","equar","eqrt"],["y","yr"],["ey","eyr"],["dec"],["edec"]],ss=["decade","year","month","week","day","hour","minute","second","millisecond"],os=["milliseconds","seconds","minutes","hours","date","month","year"],as=/^[0-9]+$/,ls=/([+-])(\d\d):*(\d\d)*$/,cs={millisecond:{magnitude:0,smaller:void 0,greater:"second"},second:{magnitude:2,smaller:"millisecond",greater:"minute"},minute:{magnitude:4,smaller:"second",greater:"hour"},hour:{magnitude:6,smaller:"minute",greater:"day"},day:{magnitude:8,smaller:"hour",greater:"week"},week:{magnitude:10,smaller:"day",greater:"month"},month:{magnitude:12,smaller:"week",greater:"quarter"},quarter:{magnitude:14,smaller:"month",greater:"year"},year:{magnitude:16,smaller:"quarter",greater:"decade"},decade:{magnitude:18,smaller:"year"},emillisecond:{magnitude:1,smaller:void 0,greater:"esecond"},esecond:{magnitude:3,smaller:"emillisecond",greater:"eminute"},eminute:{magnitude:5,smaller:"esecond",greater:"ehour"},ehour:{magnitude:7,smaller:"eminute",greater:"eday"},eday:{magnitude:9,smaller:"ehour",greater:"eweek"},eweek:{magnitude:11,smaller:"eday",greater:"emonth"},emonth:{magnitude:12,smaller:"eweek",greater:"equarter"},equarter:{magnitude:14,smaller:"emonth",greater:"eyear"},eyear:{magnitude:16,smaller:"equarter",greater:"edecade"},edecade:{magnitude:18,smaller:"eyear"}},ds={round:(e,t=1)=>Math.round(e/t)*t,floor:(e,t=1)=>Math.floor(e/t)*t,ceil:(e,t=1)=>Math.ceil(e/t)*t};Cr("edecade","millisecond",31104e7),Cr("eyear","millisecond",31104e6),Cr("equarter","millisecond",7776e6),Cr("emonth","millisecond",2592e6),Cr("eweek","millisecond",6048e5),Cr("eday","millisecond",864e5),Cr("ehour","millisecond",36e5),Cr("eminute","millisecond",6e4),Cr("esecond","millisecond",1e3),Cr("emillisecond","millisecond",1e3);class us extends(dr()){static MS_PER_DAY=864e5;static $name="DateHelper";static set defaultFormat(e){hs._defaultFormat=e}static get defaultFormat(){return hs._defaultFormat||"YYYY-MM-DDTHH:mm:ssZ"}static set defaultParseFormat(e){this._defaultParseFormat=e}static get defaultParseFormat(){return this._defaultParseFormat||this._defaultFormat||"YYYY-MM-DDTHH:mm:ss.SSSZ"}static get today(){return us.clearTime(new Date,!1)}static get tomorrow(){return us.add(us.today,1,"day")}static get yesterday(){return us.add(us.today,-1,"day")}static buildParser(e){const t=e.split(Zr),n=[];return 1===t.length||Jr.test(e)?[]:(t.reduce(((t,i,r,s)=>{if(0!==r||""!==i)if(Zr.test(i)){const o=(this.localize("L{parsers}")||{})[i]||Kr[i];if("Z"===i&&r<s.length-2)throw new Error(`Invalid format ${e} TimeZone (Z) must be last token`);const a="function"==typeof o||"string"==typeof o?o:o.parser();if("string"==typeof a){const e=hs.buildParser(a),i=e.pop();delete i.last,n.push(...e),t=i}else t.pattern=i,t.fn=a}else t.splitter=i,t.escapedSplitter=V.escapeRegExp(i),t.canUseUnstrictSplitter=Rr.test(i),n.push(t),t={};else Object.prototype.hasOwnProperty.call(t,"pattern")&&n.push(t);return t}),{}),n[n.length-1].last=!0,n.parseTimeZone=Mr.test(e),n)}static makeKey(e){if(10===e.length)return e;e.getTime&&(e=e.getTime());const t=jr[Math.trunc(e/Hr)];if(t)return t;pr.setTime(e);const n=pr.getMonth()+1,i=pr.getDate();return jr[Math.trunc(e/Hr)]=`${pr.getFullYear()}-${n<10?"0"+n:n}-${i<10?"0"+i:i}`}static parseKey(e){const t="-"===(null==e?void 0:e[0]),n=hs.parse(t?e.slice(1):e,"YYYY-MM-DD");return t&&n.setFullYear(-n.getFullYear()),n}static parse(e,t=hs.defaultParseFormat,n=!1){if(e instanceof Date)return e;if("string"!=typeof e||!e)return null;const i={year:null,month:null,date:null,hours:null,minutes:null,seconds:null,milliseconds:null};t=t.replace(Er,xr);let r=_r[t],s=null,o=null;if(r||(r=_r[t]=hs.buildParser(t)),e.includes(" ")&&(e=e.replace(/\s/g," ")),r.parseTimeZone){const t=e.match(Ir);t&&(o=t[0],e=e.slice(0,t.index))}if(r.reduce(((e,t)=>{if(!t.last){let s,o,a;if("T"===t.splitter&&-1===e.indexOf("T"))s=e.indexOf(" ");else{var r;let i;i=!n&&t.canUseUnstrictSplitter?Rr:t.escapedSplitter,s=""!==i?e.search(i):(null===(r=t.pattern)||void 0===r?void 0:r.length)||-1}if(-1===s||"SSS"===t.pattern&&e.match(/^\d+Z$/)){const t=e.split(/([Z\-+])/);1===t.length?(o=e,a=""):(o=t[0],a=`${t[1]}${t[2]}`)}else o=e.substring(0,s)||e,a=e.substring(s+t.splitter.length);if(t.fn){const e=t.fn(o);e?C.assign(i,e):a=o+a}return a}e=o||e,C.assign(i,t.fn(e))}),e),i.year&&!i.date&&(i.date=1),i.date>31||i.month>12)return null;const a=hs.create(i,n,!1);return a?s=a:!n&&e.length>3&&(s=new Date(e),s.getFullYear()<1900&&(s=null)),s}static create(e,t=!1,n=!0){const i=n?{...e}:e;let r=isNaN(i.year)||t&&(isNaN(i.month)||isNaN(i.date)),s=!1;if(!r){let e=!0;for(let t=0;t<os.length;t++){const n=os[t];!(n in i)||isNaN(i[n])?i[n]=0:e&&(e=null===i[n])}r=e}return r?null:("am"===i.amPm?i.hours=i.hours%12:"pm"===i.amPm&&(i.hours=i.hours%12+12),"timeZone"in i&&(s=!0,i.minutes-=i.timeZone),!t||null!=i.year&&null!=i.month&&null!=i.date?s?new Date(Date.UTC(vr(i.year,Nr),vr(i.month,0),vr(i.date,1),i.hours,i.minutes,i.seconds,i.milliseconds)):new Date(vr(i.year,Nr),vr(i.month,0),vr(i.date,1),i.hours,i.minutes,i.seconds,i.milliseconds):null)}static toUTC(e){return new Date(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds()))}static format(e,t=hs.defaultFormat){if(!e||isNaN(e))return null;if("function"==typeof t)return t(e);let n=Lr[t],i="";if(!n){n=Lr[t]=[];for(let e=0;e<t.length;e++){const i=t.slice(e).match(Gr),r=null==i?void 0:i[0];if(r){const t=(this.localize("L{formats}")||{})[r]||Ur[r];n.push(t),e+=r.length-1}else if("{"===t[e]){const i=t.indexOf("}",e+1);-1===i?(n.push(t.substr(e+1)),e=t.length):(n.push(t.substring(e+1,i)),e=i)}else n.push(t[e])}}return n.forEach((t=>{i+="string"==typeof t?t:t(e)})),i}static formatRange(e,t){return t.replace(yr,((t,n,i)=>us.format(e["S"===n?0:1],i)))}static asMilliseconds(e,t=null){return"string"==typeof e&&(t=e,e=1),hs.as("millisecond",e,t)}static asMonths(e){const t=hs.as("ms",hs.daysInMonth(e),"day"),n=(e.valueOf()-hs.startOf(e,"month").valueOf())/t;return 12*e.getYear()+e.getMonth()+n}static monthsToDate(e){const t=Math.floor(e),n=e-t,i=new Date(0,t),r=hs.as("ms",hs.daysInMonth(i),"days");return i.setTime(i.getTime()+n*r),i}static formatDelta(e,t){let n,i,r=", ";"boolean"==typeof t?n=t:t&&(n=t.abbrev,r=t.unitSeparator||r);const s=this.getDelta(e,t),o=[],a=(null==t?void 0:t.separator)||(n?"":" ");for(i in s)o.push(`${s[i]}${a}${i}`);return!1===(null==t?void 0:t.asString)?o:o.join(r)}static getDelta(e,t){let n,i,r,s,o,a,l;"boolean"==typeof t?n=t:t&&(n=t.abbrev,s=hs.normalizeUnit(t.precision),a=t.maxUnit,l=!n&&t.ignoreLocale);const c={},d=n?hs.getShortNameOfUnit:hs.getLocalizedNameOfUnit,u=a?ss.slice(ss.indexOf(a)):ss;for(o of u)if(i=hs.as(o,e),r=s===o,i=Math[r?"round":"floor"](i),(i||r&&!c.length)&&(c[l?o:d.call(hs,o,1!==i)]=i,e-=hs.as("ms",i,o)),r||!e)break;return c}static as(e,t,n="ms"){return"string"==typeof t&&(t=hs.parseDuration(t)),"object"==typeof t&&(n=t.unit,t=t.magnitude),e!==n&&n&&e?(e=hs.normalizeUnit(e))===(n=hs.normalizeUnit(n))?t:cs[n].magnitude>cs[e].magnitude?t*Math.abs(Qr[n][e]):t/Math.abs(Qr[e][n]):t}static formatContainsHourInfo(e){return/([HhKkmSsAa]|LT|L{3,}|l{3,})/.test(e.replace(/(\\.)/g,""))}static is24HourFormat(e){return hs.format(hs.getTime(13,0,0),e).includes("13")}static add(e,t,n="ms",i=!0){let r;if(r="string"==typeof e?hs.parse(e):i?new Date(e.getTime()):e,"string"==typeof t){const e=us.parseDuration(t);t=e.magnitude,n=e.unit}else t&&"object"==typeof t&&(n=t.unit,t=t.magnitude);if(!n||0===t)return r;switch(n=hs.normalizeUnit(n)){case"millisecond":r.setTime(r.getTime()+t);break;case"second":r.setTime(r.getTime()+1e3*t);break;case"minute":r.setTime(r.getTime()+6e4*t);break;case"hour":r.setTime(r.getTime()+36e5*t);break;case"day":t%1==0?(r.setDate(r.getDate()+t),23===r.getHours()&&0===e.getHours()&&r.setHours(r.getHours()+1)):r.setTime(r.getTime()+864e5*t);break;case"week":r.setDate(r.getDate()+7*t);break;case"month":{let e=r.getDate();e>28&&(e=Math.min(e,hs.getLastDateOfMonth(hs.add(hs.getFirstDateOfMonth(r),t,"month")).getDate())),r.setDate(e),r.setMonth(r.getMonth()+t);break}case"quarter":hs.add(r,3*t,"month",!1);break;case"year":hs.add(r,12*t,"month",!1);break;case"decade":r.setFullYear(r.getFullYear()+10*t)}return r}static diff(e,t,n="ms",i=!0){if(n=hs.normalizeUnit(n),!e||!t)return 0;let r;switch(n){case"year":r=hs.diff(e,t,"month")/12;break;case"quarter":r=hs.diff(e,t,"month")/3;break;case"month":r=12*(t.getFullYear()-e.getFullYear())+(t.getMonth()-e.getMonth()),0===r&&i&&(r=hs.diff(e,t,"day",i)/hs.daysInMonth(e));break;case"week":r=hs.diff(e,t,"day")/7;break;case"day":{const n=e.getTimezoneOffset()-t.getTimezoneOffset();r=(t-e+60*n*1e3)/864e5;break}case"hour":r=(t-e)/36e5;break;case"minute":r=(t-e)/6e4;break;case"second":r=(t-e)/1e3;break;case"millisecond":r=t-e}return i?r:Math.round(r)}static startOf(e,t="day",n=!0,i=hs.weekStartDay){if(!e)return null;switch(t=hs.normalizeUnit(t),n&&(e=hs.clone(e)),t){case"year":return e.setMonth(0,1),e.setHours(0,0,0,0),e;case"quarter":return e.setMonth(3*(hs.get(e,"quarter")-1),1),e.setHours(0,0,0,0),e;case"month":return e.setDate(1),e.setHours(0,0,0,0),e;case"week":{let t=e.getDay()-i;return t<0&&(t+=7),e.setDate(e.getDate()-t),e.setHours(0,0,0,0),e}case"day":return e.setHours(0,0,0,0),e;case"hour":e.getMinutes()>0&&e.setMinutes(0);case"minute":e.getSeconds()>0&&e.setSeconds(0);case"second":e.getMilliseconds()>0&&e.setMilliseconds(0);case"millisecond":return e}}static endOf(e){return new Date(e.getFullYear(),e.getMonth(),e.getDate()+1)}static clone(e){return new Date(e.getTime())}static clearTime(e,t=!0){return e?(t&&(e=new Date(e.getTime())),e.setHours(0,0,0,0),e):null}static midnight(e,t){let n=hs.clearTime(e);return t&&n<e&&(n=hs.add(n,1,"d")),n}static isMidnight(e){return hs.midnight(e).getTime()===e.getTime()}static getTimeOfDay(e,t="ms"){const n=e.getHours()*Qr.hour.millisecond+e.getMinutes()*Qr.minute.millisecond+e.getSeconds()*Qr.second.millisecond+e.getMilliseconds();return"ms"===t?n:hs.as(t,n,"ms")}static set(e,t,n){if(!t)return e;if("string"==typeof t)switch(hs.normalizeUnit(t)){case"millisecond":(0!==n||e.getMilliseconds()>0)&&e.setMilliseconds(n);break;case"second":(0!==n||e.getSeconds()>0)&&e.setSeconds(n);break;case"minute":(0!==n||e.getMinutes()>0)&&e.setMinutes(n);break;case"hour":e.setHours(n);break;case"day":case"date":e.setDate(n);break;case"week":throw new Error("week not implemented");case"month":e.setMonth(n);break;case"quarter":e.setDate(1),e.setMonth(3*(n-1));break;case"year":e.setFullYear(n)}else Object.entries(t).sort(((e,t)=>{const n=e[0],i=t[0],r=cs["date"===i?"day":i];return cs["date"===n?"day":n].magnitude-r.magnitude})).forEach((([t,n])=>{hs.set(e,t,n)}));return e}static setDateToMidday(e,t=!0){return hs.set(hs.clearTime(e,t),"hour",12)}static constrain(e,t,n){return null!=t&&(e=hs.max(e,t)),null==n?e:hs.min(e,n)}static getTime(e,t=0,n=0,i=0){return e instanceof Date&&(i=e.getMilliseconds(),n=e.getSeconds(),t=e.getMinutes(),e=e.getHours()),new Date(Nr,0,1,e,t,n,i)}static copyTimeValues(e,t){return e.setHours(t.getHours()),e.setMinutes(t.getMinutes()),e.setSeconds(t.getSeconds()),e.setMilliseconds(t.getMilliseconds()),e}static combineDateAndTime(e,t){return us.copyTimeValues(new Date(e),t)}static get isDSTEnabled(){const e=(new Date).getFullYear(),t=new Date(e,0,1),n=new Date(e,6,1);return t.getTimezoneOffset()!==n.getTimezoneOffset()}static isDST(e){const t=e.getFullYear(),n=new Date(t,0,1),i=new Date(t,6,1);return e.getTimezoneOffset()<Math.max(n.getTimezoneOffset(),i.getTimezoneOffset())}static isToday(e,t){return hs.isEqual(hs.clearTime(e),t?hs.clearTime(l.TimeZone.toTimeZone(hs.today,t)):hs.today)}static isBefore(e,t){return e<t}static isAfter(e,t){return e>t}static isEqual(e,t,n=null){return null===n?e&&t&&e.getTime()===t.getTime():hs.startOf(e,n)-hs.startOf(t,n)==0}static compare(e,t,n=null){return n&&(e=hs.startOf(e,n),t=hs.startOf(t,n)),e<t?-1:e>t?1:0}static clamp(e,t,n){if(!isNaN(e))return null!=t&&(e=Math.max(e,t)),null!=n&&(e=Math.min(e,n)),new Date(e)}static isSameDate(e,t){return 0===hs.compare(e,t,"d")}static isSameTime(e,t){return e.getHours()===t.getHours()&&e.getMinutes()===t.getMinutes()&&e.getSeconds()===t.getSeconds()&&e.getMilliseconds()===t.getMilliseconds()}static isStartOf(e,t){return hs.isEqual(e,hs.startOf(e,t))}static betweenLesser(e,t,n){return t.getTime()<=e.getTime()&&e.getTime()<n.getTime()}static betweenLesserEqual(e,t,n){return t.getTime()<=e.getTime()&&e.getTime()<=n.getTime()}static intersectSpans(e,t,n,i){return hs.betweenLesser(e,n,i)||hs.betweenLesser(n,e,t)}static compareUnits(e,t){const n=cs[hs.normalizeUnit(e)],i=cs[hs.normalizeUnit(t)];return Math.sign(((null==n?void 0:n.magnitude)||0)-((null==i?void 0:i.magnitude)||0))}static timeSpanContains(e,t,n,i){return n-e>=0&&t-i>=0}static get amIndicator(){return Br}static get pmIndicator(){return Vr}static get weekStartDay(){return null==hs._weekStartDay&&(hs._weekStartDay=this.localize("L{weekStartDay}")||0),hs._weekStartDay}static get nonWorkingDays(){return{...this.localize("L{nonWorkingDays}")}}static get nonWorkingDaysAsArray(){return Object.keys(this.nonWorkingDays).map(Number)}static get weekends(){return{...this.localize("L{weekends}")}}static get(e,t){switch(hs.normalizeUnit(t)){case"millisecond":return e.getMilliseconds();case"second":return e.getSeconds();case"minute":return e.getMinutes();case"hour":return e.getHours();case"date":case"day":return e.getDate();case"week":return Ur.W(e);case"month":return e.getMonth();case"quarter":return Math.floor(e.getMonth()/3)+1;case"year":return e.getFullYear()}return null}static daysInYear(e){const t=e.getFullYear(),n=new Date(t+1,0,1)-new Date(t,0,1);return this.as("day",n)}static daysInMonth(e){return 32-new Date(e.getFullYear(),e.getMonth(),32).getDate()}static hoursInDay(e){const t=e.getFullYear(),n=e.getMonth(),i=e.getDate(),r=new Date(t,n,i+1)-new Date(t,n,i);return this.as("hour",r)}static getNormalizedUnitDuration(e,t){let n;switch(t){case"month":n=hs.asMilliseconds(hs.daysInMonth(e),"day");break;case"year":n=hs.asMilliseconds(hs.daysInYear(e),"day");break;case"day":n=hs.asMilliseconds(hs.hoursInDay(e),"hour");break;default:n=hs.asMilliseconds(t)}return n}static getFirstDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth(),1)}static getLastDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth()+1,0)}static min(e,t){return e.getTime()<t.getTime()?e:t}static max(e,t){return e.getTime()>t.getTime()?e:t}static getNext(e,t,n=1,i=hs.weekStartDay){if("week"===t){const t=hs.clone(e),r=t.getDay();return hs.startOf(t,"day",!1),hs.add(t,i-r+7*(n-(i<=r?0:1)),"day",!1),t.getDay()!==i&&hs.add(t,1,"hour"),t}return hs.startOf(hs.add(e,n,t),t,!1)}static isValidDate(e){return hs.isDate(e)&&!isNaN(e)}static isDate(e){return e&&gr.call(e)===mr}static getStartOfNextDay(e,t=!1,n=!1){let i=hs.add(n?e:hs.clearTime(e,t),1,"day");if(i.getDate()===e.getDate()){const n=hs.add(hs.clearTime(e,t),2,"day").getTimezoneOffset(),r=e.getTimezoneOffset();i=hs.add(i,r-n,"minute")}return i}static getEndOfPreviousDay(e,t=!1){const n=t?e:hs.clearTime(e,!0);return n-e?n:hs.add(n,-1,"day")}static getWeekDescription(e,t=e){const n=e.getMonth()===t.getMonth()?us.format(e,"MMMM"):`${us.format(e,"MMM")} - ${us.format(t,"MMM")}`,i=us.getWeekNumber(e);return`${i[1]}, ${n} ${i[0]}`}static getWeekNumber(e,t=us.weekStartDay){const n=new Date(e.getFullYear(),0,1),i=new Date(e.getFullYear(),11,31),r=Dr(n.getDay()-t),s=Dr(i.getDay()-t),o=(a=e,l=n,Math.floor((a.getTime()-l.getTime()-(a.getTimezoneOffset()-l.getTimezoneOffset())*Qr.minute.millisecond)/Qr.day.millisecond)+1);var a,l;let c;if(c=r<4?Math.floor((o+r-1)/7)+1:Math.floor((o+r-1)/7),c){let t=e.getFullYear();return 53===c&&s<3&&(t++,c=1),[t,c]}const d=us.getWeekNumber(new Date(e.getFullYear()-1,11,31))[1];return[e.getFullYear()-1,d]}static getDateFromISOWeek(e,t,n=1){const i=new Date(e,0,1+7*(t-1)),r=i.getDay(),s=n-(0===r?7:r);return i.setDate(i.getDate()+s),i}static formatCount(e,t){return t=hs.normalizeUnit(t),1!==e&&(t+="s"),e+" "+t}static getUnitToBaseUnitRatio(e,t,n=!1){return(e=hs.normalizeUnit(e))===(t=hs.normalizeUnit(t))?1:Qr[e]&&Qr[e][t]&&(n||Qr[e][t]>0)?1/hs.as(t,1,e):Qr[t]&&Qr[t][e]&&(n||Qr[t][e]>0)?hs.as(e,1,t):-1}static getShortNameOfUnit(e){return e=hs.parseTimeUnit(e),hs.unitLookup[e].abbrev}static getLocalizedNameOfUnit(e,t=!1){const n=e.charAt(0)===e.charAt(0).toUpperCase();return e=hs.normalizeUnit(e),e=hs.parseTimeUnit(e),e=hs.unitLookup[e][t?"plural":"single"],n&&(e=V.capitalize(e)),e}static normalizeUnit(e){if(!e)return null;const t=e.toLowerCase();return"date"===t||is.includes(t)?t:es[e]||es[t]}static getUnitByName(e){return hs.normalizeUnit(e)||hs.normalizeUnit(hs.parseTimeUnit(e))}static getDurationInUnit(e,t,n,i){return hs.diff(e,t,n,i)}static doesUnitsAlign(e,t){return!(e!==t&&"week"===t)}static getSmallerUnit(e){var t,n;e=hs.normalizeUnit(e);const i=null===(t=cs[e])||void 0===t?void 0:t.smaller;return is[null===(n=cs[i])||void 0===n?void 0:n.magnitude]||null}static getLargerUnit(e){var t,n;e=hs.normalizeUnit(e);const i=null===(t=cs[e])||void 0===t?void 0:t.greater;return is[null===(n=cs[i])||void 0===n?void 0:n.magnitude]||null}static round(e,t,n,i){return hs.snap("round",e,t,n,i)}static floor(e,t,n,i){return hs.snap("floor",e,t,n,i)}static ceil(e,t,n,i){return hs.snap("ceil",e,t,n,i)}static snap(e,t,n,i,r=hs.weekStartDay){const s=ds[e];if("string"==typeof n&&(n=hs.parseDuration(n)),C.isObject(n)){const o=n.magnitude||n.increment;switch(n.unit){case"week":if(!i){const e=t.getDay();i=hs.add(hs.clearTime(t),e>=r?r-e:-(e-r+7),"day")}return hs[e](t,7*o+" days",i);case"month":{let e;return t=hs.asMonths(t),e=i?(i=hs.asMonths(i))+s(t-i,o):s(t,o),hs.monthsToDate(e)}case"quarter":return hs[e](t,3*o+" months",i);case"year":return hs[e](t,12*o+" months",i);case"decade":return hs[e](t,10*o+" years",i)}n=hs.as("ms",o,n.unit)}const o=1e3*t.getTimezoneOffset()*60;if(i){const e=1e3*i.getTimezoneOffset()*60,r=t-i+e-o,a=new Date(i.getTime()+s(r,n)),l=e-1e3*a.getTimezoneOffset()*60;return l&&hs.add(a,-l,"ms",!1),new Date(a)}return new Date(s(t.valueOf()-o,n)+o)}static parseDuration(e,t=!0,n){var i;const r=(t?ts:ns).exec(e);if(null==e||!r)return null;const s=(e=>{const t=parseFloat(e);return isNaN(t)?null:t})(null===(i=r[1])||void 0===i?void 0:i.replace(",",".")),o=hs.parseTimeUnit(r[2])||n;return o?{magnitude:s,unit:o}:null}static parseTimeUnit(e){const t=null==e?null:hs.durationRegEx.exec(e)||hs.durationRegEx.exec(e.toLowerCase());if(!t)return null;for(let e=0;e<is.length;e++)if(t[e+1])return is[e]}static getGMTOffset(e=new Date){if(!e)return;const t=e.getTimezoneOffset();return t?(t>0?"-":"+")+Math.abs(Math.trunc(t/60)).toString().padStart(2,"0")+":"+Math.abs(t%60).toString().padStart(2,"0"):"Z"}static fillDayNames(){const e=new Date("2000-01-01T12:00:00"),t=hs._dayNames||[],n=hs._dayShortNames||[];t.length=0,n.length=0;for(let i=2;i<9;i++)e.setDate(i),t.push(hs.format(e,"dddd")),n.push(hs.format(e,"ddd"));hs._dayNames=t,hs._dayShortNames=n}static getDayNames(){return hs._dayNames}static getDayName(e){return hs._dayNames[e]}static getDayShortNames(){return hs._dayShortNames}static getDayShortName(e){return hs._dayShortNames[e]}static fillMonthNames(){const e=new Date("2000-01-15T12:00:00"),t=hs._monthNames||[],n=hs._monthShortNames||[],i={},r={};t.length=0,n.length=0;for(let s=0;s<12;s++){e.setMonth(s);const o=hs.format(e,"MMMM");t.push(o);const a=hs.format(e,"MMM");n.push(a),i[o.toLowerCase()]={name:o,value:s},r[a.toLowerCase()]={name:a,value:s}}hs._monthNames=t,hs._monthShortNames=n,hs._monthNamesIndex=i,hs._monthShortNamesIndex=r}static getMonthShortNames(){return hs._monthShortNames}static getMonthShortName(e){return hs._monthShortNames[e]}static getMonthNames(){return hs._monthNames}static getMonthName(e){return hs._monthNames[e]}static set locale(e){Ar=e,$r={},Lr={},Or={}}static get locale(){return Ar}static setupDurationRegEx(e=[],t=[]){const n=this,i={};let r="";for(let s=0;s<t.length;s++){const o=t[s],a=e[s];a.canonicalUnitName=is[s],i[a.single]=i[a.single.toUpperCase()]=i[a.canonicalUnitName]=i[a.canonicalUnitName.toUpperCase()]=a,r+=(s?"|":"")+"(";for(let e=0;e<o.length;e++)r+=`${o[e]}|`;if(Ar=n.localize("L{locale}")||"en-US","en-US"!==Ar){const e=rs[s];for(let t=0;t<e.length;t++)r+=`${e[t]}|`}r+=`${a.single}|${a.plural}|${a.canonicalUnitName}|${a.canonicalUnitName}s)`}n.unitLookup=i,n.durationRegEx=new RegExp(`^(?:${r})$`)}static applyLocale(){const e=this,t=e.localize("L{unitAbbreviations}")||[],n=e.unitNames=e.localize("L{unitNames}"),i=new Date(2020,6,15,6),r=Math.abs(i.getTimezoneOffset()%60);if("unitNames"===n)return;Ar=e.localize("L{locale}")||"en-US";const s=$r.a||($r.a=new Intl.DateTimeFormat(Ar,{hour:"numeric",hourCycle:"h12"}));Br=s.formatToParts(i)[2].value,Vr=s.formatToParts(new Date(2020,6,15,18))[2].value,Pr="en-US"===Ar?br:e.localize("L{ordinalSuffix}")||Pr,Lr={},Or={},_r={},$r={},jr={},Hr=6e4*(!r||r>30?60-r:r),hs._weekStartDay=null,hs.setupDurationRegEx(n,t),hs.fillDayNames(),hs.fillMonthNames()}}l.register(us);const hs=us;hs.useIntlFormat=Sr,ir.ion({locale:"applyLocale",prio:1e3,thisObj:hs}),ir.locale&&hs.applyLocale();class gs extends Set{get isDateSet(){return!0}add(e){return e=us.makeKey(e),this.has(e)||(this.generation=(this.generation||0)+1),super.add(e)}delete(e){return e=us.makeKey(e),this.has(e)&&this.generation++,super.delete(e)}has(e){return super.has(us.makeKey(e))}clear(){return this.size&&this.generation++,super.clear()}equals(e){return Array.isArray(e)&&(e=new gs(e)),e.size===this.size&&[...this].every((t=>e.has(t)))}get dates(){return[...this].sort().map((e=>us.parseKey(e)))}}us.DateSet=gs,us._$name="DateHelper";class ms{get data(){return Object.create(null)}get keys(){return[]}clear(){}getItem(e){return null}removeItem(e){}setItem(e,t){}}ms._$name="StateStorage";const ps=()=>Object.create(null),fs=(e,t=0)=>{const n=[],i=localStorage.length;for(let r,s=0;s<i;++s)r=localStorage.key(s),r.startsWith(e)&&n.push(r.slice(t));return n},vs=new ms,ys={local:class extends ms{constructor(e){super(),this.prefix=e.prefix||""}get isLocal(){return!0}get data(){const e=ps(),t=this.keys;for(const n of t)e[n]=this.getItem(n);return e}get keys(){return fs(this.prefix,this.prefix.length)}clear(){const e=fs(this.prefix);for(const t of e)localStorage.removeItem(t)}getItem(e){const t=localStorage.getItem(this.prefix+e);return null===t?t:JSON.parse(t)}removeItem(e){return localStorage.removeItem(this.prefix+e)}setItem(e,t){return localStorage.setItem(this.prefix+e,JSON.stringify(t))}},memory:class extends ms{constructor(){super(),this.clear()}get isMemory(){return!0}get data(){return U.clone(this._data)}get keys(){return Object.keys(this._data)}clear(){this._data=ps()}getItem(e){return e in this._data?this._data[e]:null}removeItem(e){delete this._data[e]}setItem(e,t){this._data[e]=t}}};class bs extends(tt.mixin(nn,dt)){static $name="StateProvider";static get configurable(){return{prefix:"bryntum-state:",storage:"local"}}static get delayable(){return{writeStatefuls:50}}static get instance(){return this._instance}static set instance(e){null==e?e=Cs:(("string"==typeof e||U.isClass(e)||e instanceof ms)&&(e={storage:e}),U.isObject(e)&&(e=new bs(e))),this._instance=e}static setup(e){return this.instance=e,this.instance}doDestroy(){self.writeStatefuls.flush(),super.doDestroy()}get data(){return this.storage.data}set data(e){if(e)for(const t in e)this.setValue(t,e[t]);else this.clear()}clear(){return this.storage.clear(),this}changeStorage(e){if(null==e)e=vs;else{if("string"==typeof e){if(!ys[e])throw new Error(`Invalid storage type "${e}" (expected one of: "${Object.keys(ys).join('", "')}")`);e=ys[e]}U.isClass(e)&&(e=new e(this))}return e}saveStateful(e,t){(this.pendingSaves||(this.pendingSaves=[])).push([e,t]),this.writeStatefuls()}writeStatefuls(){const e=this,{pendingSaves:t}=e,n=null==t?void 0:t.length,i=[],r=[];if(e.pendingSaves=null,n){for(let e,s,o,a=0;a<n;++a)[s,e]=t[a],!s.isDestroying&&s.isSaveStatePending&&(o=s.saveState({...e,immediate:!0}),o&&(i.push(o),r.push(s)));i.length&&e.trigger("save",{stateIds:i,saved:r})}}getValue(e){return this.writeStatefuls.flush(),this.storage.getItem(e)}setValue(e,t){const n=this,{storage:i}=n,r=n.getValue(e);return null!=t?(i.setItem(e,t),n.trigger("set",{key:e,value:t,was:r})):null!==r&&(i.removeItem(e),n.trigger("remove",{key:e,was:r})),n}}const Cs=new bs({storage:vs});bs._instance=Cs,bs._$name="StateProvider";const Ss=/boolean|number|string/;var ws=e=>class extends((e||tt).mixin(dt)){static $name="State";static configurable={stateful:{value:null,$config:{merge:"classList"}},statefulEvents:{$config:{merge:"classList"},value:["stateChange"]},stateId:null,stateProvider:null};static prototypeProperties={statefulLoaded:!1,statefulSuspended:0};afterConstruct(){super.afterConstruct(),this.stateProvider&&this.loadState()}finalizeInit(){this.stateProvider&&this.loadState(),super.finalizeInit()}get isStateful(){return!0}get isStatefulActive(){return!this.statefulSuspended&&!this.isResponsivePending&&!this.isResponsiveUpdating}get state(){return this._state=this.getState()}set state(e){this._state=e,e&&!1!==this.trigger("beforeStateApply",{state:e})&&this.applyState(e)}updateStatefulEvents(e){const t=this,n={name:"statefulEvents",thisObj:t};if(t.detachListeners(n.name),e&&("string"==typeof e?e=V.split(e):Array.isArray(e)||(e=U.getTruthyKeys(e)),e.length)){var i;for(const t of e)n[t]="onStatefulEvent";null===(i=t.ion)||void 0===i||i.call(t,n)}}get statefulId(){const e=this,{responsiveState:t}=e;let n=e.stateId;return null==n&&!1===e.hasGeneratedId&&!1!==e.stateful&&(n=e.id),n&&t&&(n=`${n}[${t}]`),n}get statefulness(){const{stateful:e}=this;return Array.isArray(e)?U.createTruthyKeys(e):e}get stateProvider(){return this._stateProvider??(this._stateId&&bs.instance)}applyState(e){(e=this.pruneState(e))&&this.setConfig(e)}getState(){const e=this,{initialConfig:t,statefulness:n,isConstructing:i}=e,{configs:r}=e.$meta,s=i?Object.assign(Object.create(e.$meta.config),t):e;let o,a,l=null;if(n)for(o in l={},n)if(n[o]){var c;if(a=s[o],null!==(c=a)&&void 0!==c&&c.isStateful)a=a.state;else if(!i&&(U.isDate(a)&&(a=us.format(a,"YYYY-MM-DDTHH:mm:ssZ")),r[o].equal(a,null==t?void 0:t[o])||!Ss.test(typeof a)))continue;l[o]=a}return l}loadState(e,t){"boolean"==typeof e&&(t=e,e=null);const n=this,{statefulLoaded:i}=n;if(n.isStatefulActive&&(t||!i)){const t=n.loadStatefulData(e||(e=n.statefulId));!i&&e&&(n.defaultState=n.state,n.statefulLoaded=!0),t&&(n.state=t)}}loadStatefulData(e){var t;return(e=this.isStatefulActive?e||this.statefulId:null)&&(null===(t=this.stateProvider)||void 0===t?void 0:t.getValue(e))}resetDefaultState(){this.defaultState&&(this.state=this.defaultState)}resumeStateful(e=!1){this.statefulSuspended=e?0:Math.max(this.statefulSuspended-1,0)}saveState(e){e="string"==typeof e?{id:e}:e||{};const t=this,{stateProvider:n}=t,i=e.id||t.isStatefulActive&&t.statefulId;if(i&&n){if(e.immediate){t.isSaveStatePending=!1;const{state:e}=t;!1!==t.trigger("beforeStateSave",{state:e})&&n.setValue(i,e)}else t.isSaveStatePending||(t.isSaveStatePending=!0,n.saveStateful(t,e));return i}}suspendStateful(){++this.statefulSuspended}onConfigChange({name:e,value:t,was:n,config:i}){if(super.onConfigChange({name:e,value:t,was:n,config:i}),!this.isConstructing&&this.isStatefulActive&&this.statefulId){const{stateful:t}=this;(Array.isArray(t)?t.includes(e):null==t?void 0:t[e])&&this.saveState()}}onStatefulEvent(){this.isConstructing||this.saveState()}pruneState(e){const{statefulness:t}=this;if(t){const n={};for(const i in e)t[i]&&(n[i]=e[i]);e=n}return e}get widgetClass(){}};const Ds={parentIndex:1,orderedParentIndex:1};var Es=e=>class extends(e||tt){static $name="ModelStm";static configurable={stm:null};joinStore(e){this.stm||(this.stm=e.stm)}unjoinStore(e,t=!1){var n;this.stm===e.stm&&(this.stm=null),null===(n=super.unjoinStore)||void 0===n||n.call(this,e,t)}beforeChronoFieldSet(e,t){var n;const i=this;return i.inSetting||null===(n=i.stm)||void 0===n||!n.enabled||Ds[e]||i.constructor.nonPersistableFields[e]||!i.getFieldDefinition(e)?null:{[e]:{value:t,oldValue:i.graph.activeTransaction.readCurrentOrProposedOrPrevious(i.$[e])}}}afterChronoFieldSet(e,t,n){n&&this.afterSet(e,t,!1,!1,n,!0)}shouldRecordFieldChange(e,t,n){const i=this.firstStore;return!(this.constructor.nonPersistableFields[e]||null==t&&null==n||t===n||t instanceof Date&&n instanceof Date&&t.getTime()===n.getTime()||"id"===e||"$PhantomId"===e||"parentId"===e&&i&&i.oldIdMap[t]===i.getById(n))}afterSet(e,t,n,i,r,s){const{stm:o}=this,a=this.constructor.nonPersistableFields;if(null!=o&&o.isBase&&o.shouldRecordAction&&!Ds[e]&&!a[e]&&r){let e;const[t,n]=Object.keys(r).reduce(((t,n)=>{const{value:i,oldValue:s}=r[n];return this.shouldRecordFieldChange(n,s,i)&&(e=!0,t[0][n]=i,t[1][n]=s),t}),[{},{}]);e&&o.onModelUpdate(this,t,n,s)}}beforeInsertChild(e){var t;const n=(null===(t=super.beforeInsertChild)||void 0===t?void 0:t.call(this,e))||[],{stm:i}=this;return null!=i&&i.enabled&&n.push(e.reduce(((e,t)=>(t.root===this.root&&e.set(t,{parent:t.parent,index:t.parent?t.parentIndex:void 0}),e)),new Map)),n}afterInsertChild(e,t,n,i,r){var s;const{stm:o}=this;if(null!=o&&o.shouldRecordAction){const t=n.pop();i&&o.onModelInsertChild(this,e,i,t,r)}null===(s=super.afterInsertChild)||void 0===s||s.call(this,e,t,n,i)}beforeRemoveChild(e,t){const n=super.beforeRemoveChild?super.beforeRemoveChild(e,t):[],{stm:i}=this;return null!=i&&i.shouldRecordAction&&!t&&n.push(e.reduce(((e,t)=>(e.set(t,{parentIndex:t.parentIndex,orderedParentIndex:t.orderedParentIndex}),e)),new Map)),n}afterRemoveChild(e,t,n){var i;const{stm:r}=this;if(null!=r&&r.shouldRecordAction&&!n){const n=t.pop();e&&e.length&&r.onModelRemoveChild(this,e,n)}null===(i=super.afterRemoveChild)||void 0===i||i.call(this,e,t,n)}};const xs={includeFilteredOutRecords:!1},Rs=e=>("boolean"==typeof(e=e||!1)&&(e={includeFilteredOutRecords:e}),e||xs);var Ts=e=>class extends(e||tt){static $name="TreeNode";static set convertEmptyParentToLeaf(e){!0===e?e={onLoad:!0,onRemove:!0}:!1===e&&(e={onLoad:!1,onRemove:!1}),this._convertEmptyParentToLeaf=e}constructor(...e){super(...e),this.children&&(this.orderedChildren=this.orderedChildren||[])}static get convertEmptyParentToLeaf(){return this._convertEmptyParentToLeaf||{onLoad:!1,onRemove:!1}}ingestChildren(e,t=this.stores){const{inProcessChildren:n,constructor:i}=this,r=null==t?void 0:t[0];if(!0===e)return!!n||[];if(e){let t=rt.asArray(e);if(!t.length)return[];const n=t.length,s=[];t=(null==r?void 0:r.cloneImmutable(t))??t;for(let e,o=0;o<n;o++)e=t[o],e=e.isModel?e:(null==r?void 0:r.createRecord(e,!1,!0))??new i(e,null,null,!0),e=(null==r?void 0:r.processRecord(e))??e,s.push(e);if(!0===this.children&&r){const e=r.createSorterFn(r.sorters);s.sort(e)}return s}}processChildren(e=this.stores){const t=this,{meta:n}=t;t.inProcessChildren=!0;const i=t.ingestChildren(t.data[t.constructor.childrenField],e);if(i){const{convertEmptyParentToLeaf:e}=t.constructor;if(!0===e||e.onLoad?i.length:Array.isArray(i)){if(n.isLeaf=!1,!0===t.children)t.children=[];else if(0===i.length)return void(t.children=i);t.insertChild(i)}else!0===i?(n.isLeaf=!1,t.children=!0):t.isRoot||(n.isLeaf=t.constructor.convertEmptyParentToLeaf.onLoad)}t.inProcessChildren=!1}ancestorsExpanded(e=this.firstStore){const{parent:t}=this;return null==e||!e.isTree||(!t||t.isExpanded(e)&&t.ancestorsExpanded(e))}isExpanded(e=this.firstStore){const t=this.instanceMeta(e.id);return Object.prototype.hasOwnProperty.call(t,"collapsed")||(t.collapsed=!this.expanded),!t.collapsed}get expanded(){return this.data.expanded}get childLevel(){let e=this,t=-1;for(;e&&!e.isRoot;)++t,e=e.parent;return t}get isLeaf(){return!1!==this.meta.isLeaf&&!this.isRoot}get isParent(){return!this.isLeaf}get isLoaded(){return this.isParent&&Array.isArray(this.children)}get hierarchyModificationDataToWrite(){const{parentIdField:e}=this.constructor,t=[e,"parentIndex","orderedParentIndex"].reduce(((t,n)=>{if(n in this.meta.modified){const i=this.constructor.getFieldDefinition(n);n===e?t[(null==i?void 0:i.dataSource)??e]=this.getFieldPersistentValue(n):i.persist&&(t[i.dataSource]=this.getFieldPersistentValue(n))}return t}),{});return Object.keys(t).length>0?t:null}get descendantCount(){return this.getDescendantCount()}get visibleDescendantCount(){return this.getDescendantCount(!0)}getDescendantCount(e=!1,t=this.firstStore,n=!1){let{children:i}=this;return n&&this.unfilteredChildren&&(i=this.unfilteredChildren),!i||!Array.isArray(i)||e&&!this.isExpanded(t)?0:i.reduce(((i,r)=>i+r.getDescendantCount(e,t,n)),i.length)}get allChildren(){return this.getAllChildren(!1)}get allUnfilteredChildren(){return this.getAllChildren(!0)}getAllChildren(e=!1){const t=e&&this.unfilteredChildren||this.children;return t&&!0!==t?t.reduce(((t,n)=>(t.push(n),t.push.apply(t,e?n.allUnfilteredChildren:n.allChildren),t)),[]):[]}get firstChild(){const{children:e}=this;return(null==e?void 0:e.length)&&e[0]||null}get lastChild(){const{children:e}=this;return(null==e?void 0:e.length)&&e[e.length-1]||null}get previousSiblingsTotalCount(){let e=this.previousSibling,t=this.parentIndex;for(;e;)t+=e.descendantCount,e=e.previousSibling;return t}get previousOrderedSibling(){var e;return(null===(e=this.parent)||void 0===e?void 0:e.orderedChildren[this.orderedParentIndex-1])??null}get nextOrderedSibling(){var e;return(null===(e=this.parent)||void 0===e?void 0:e.orderedChildren[this.orderedParentIndex+1])??null}get root(){var e;return(null===(e=this.parent)||void 0===e?void 0:e.root)||this}get parentId(){return this.parent&&!this.parent.isAutoRoot?this.parent.id:null}set parentId(e){this.setParentId(e)}setParentId(e){const t=this,{firstStore:n}=t;if(n){const{parent:i}=t,r=null===e?n.rootNode:n.getById(e);r!==i&&(i||r)&&(t.isBatchUpdating?t.meta.batchChanges.parentId=e:r?r.appendChild(t):i.removeChild(t))}else t.setData(t.constructor.parentIdField,e)}static set parentIdField(e){this._parentIdField=e,Object.defineProperty(this.prototype,e,{set:function(e){this.parentId=e},get:function(){return this.parentId}})}static get parentIdField(){return this._parentIdField||"parentId"}getChildren(e){let t;return t=e.includeFilteredOutRecords?this.unfilteredChildren||this.children:e.useOrderedTree?this.orderedChildren:this.children,t}traverse(e,t,n){n=Rs(n);const i=this,r=i.getChildren(n);t||e.call(i,i);for(let t=0,i=null==r?void 0:r.length;t<i;t++)r[t].traverse(e,!1,n)}traverseBefore(e,t,n){n=Rs(n);const i=this,r=i.getChildren(n);for(let t=0,i=null==r?void 0:r.length;t<i;t++)r[t].traverse(e,!1,n);t||e.call(i,i)}traverseWhile(e,t,n){n=Rs(n);const i=this;let r=t||!1!==e.call(i,i);if(r){const t=i.getChildren(n);null!=t&&t.length&&(r=t.every((t=>t.traverseWhile(e,!1,n))))}return r}bubble(e,t=!1){let n=this;for(t||e.call(n,n);n.parent;)n=n.parent,e.call(n,n)}bubbleWhile(e,t=!1){let n=this,i=!0;for(t||(i=e.call(n,n));i&&n.parent;)n=n.parent,i=e.call(n,n);return i}contains(e,t=!1,n=void 0){return e&&"object"==typeof e&&(e=e.id),!this.traverseWhile((t=>t.id!=e),t,n)}getTopParent(e){let t;return e?(t=[],this.bubbleWhile((e=>(t.push(e),e.parent&&!e.parent.isRoot)))):(t=null,this.bubbleWhile((e=>(t=e,e.parent&&!e.parent.isRoot)))),t}appendChild(e,t=!1,n={}){return this.insertChild(e,null,t,n)}insertChild(e,t=null,n=!1,i={}){var r,s,o,a,l;const c=this,d=Array.isArray(e);var u;"number"==typeof t&&(t=(null===(u=c.children)||void 0===u?void 0:u[t])??null);if(c.isLinked&&!c.meta.isFillingFromMaster){var h;let r=e;return c.firstStore.isChainedTree&&(r=Array.isArray(e)?e.map((e=>e.$original??e)):e.$original??e),c.$original.insertChild(r,null===(h=t)||void 0===h?void 0:h.$original,n,i)}if(e=rt.asArray(e),!n&&!c.isLoading&&!1===(null===(r=c.stores)||void 0===r?void 0:r.every((t=>!1!==t.trigger("beforeAdd",{records:e,parent:c})))))return null;e=c.ingestChildren(e);const g=(null===(s=t)||void 0===s?void 0:s.parentIndex)??(null===(o=c.children)||void 0===o?void 0:o.length)??0,m=null===(a=c.beforeInsertChild)||void 0===a?void 0:a.call(c,e),p=c.internalAppendInsert(e,t,n,i);return p.length&&c.convertToParent(n),null===(l=c.afterInsertChild)||void 0===l||l.call(c,g,e,m,p,i.orderedBeforeNode),d||!p?p:p[0]}convertToParent(e=!1){const t=this,n=t.isLeaf;t.meta.isLeaf=!1,t.children||(t.children=[]),!n||t.root.isLoading||e||t.signalNodeChanged({isLeaf:{value:!1,oldValue:!0}})}signalNodeChanged(e,t=this.stores){null==t||t.forEach((t=>{t.trigger("update",{record:this,records:[this],changes:e}),t.trigger("change",{action:"update",record:this,records:[this],changes:e})}))}tryInsertChild(...e){return this.insertChild(...e)}internalAppendInsert(e,t,n,i){const r=this,{stores:s,root:o,children:a}=r,{firstStore:l}=o,{parentIdField:c}=r.constructor,d=r.id;let u,h,g,m,p,f={};if(!o.isLoading&&l)for(p=[],g=0;g<e.length;g++){const t=e[g];f[t.id]=t.root===o,p[g]=t.parentIndex}if(t&&t.parent!==r&&(t=null),a){const n=t?t.parentIndex:a.length;if(a[h=n]===e[0]||a[h=n-1]===e[0])for(u=!0,g=0;u&&g<e.length;g++)e[g]!==a[h+g]&&(u=!1)}if(u)return e;for(g=0;g<e.length;g++){const t=e[g],s=t.parent;l&&!o.isLoading&&t.traverse((e=>{e.root===o&&(f[e.id]=!0)}));const a=Boolean(f[t.id]),u=s===r&&a;if(!1===(null==s?void 0:s.removeChild(t,a,n,{isInserting:!0,skipIndexUpdate:u,...i})))m||(e=e.slice(),m=!0),e.splice(g--,1);else{t.parent=r,t.setData("parentId",d);const{meta:e}=t;e.modified[c]!==d||s||(e.oldParentId=d),s&&(e.oldParentId=s.id)}}if(e.length){Array.isArray(a)||(r.children=[]),Array.isArray(r.orderedChildren)||(r.orderedChildren=[]);const o=r.addToChildren(t,e,i);null==s||s.forEach((t=>{t.isChained&&!t.isChainedTree||(e.forEach((e=>e.joinStore(t))),t.onNodeAddChild(r,e,o,f,n),e.forEach(((e,i)=>{if(null!=e.meta.oldParentId&&(!r.inProcessChildren&&!r.isLoading||f[e.id])){const s={[c]:d,[r.getDataSource("parentIndex")]:e.parentIndex},o={},{modified:a,oldParentId:l}=e.meta,u=p[i];if(delete e.meta.oldParentId,r.id!==l&&(o[c]={value:d,oldValue:l}),e.parentIndex!==u&&(o.parentIndex={value:e.parentIndex,oldValue:u}),a[c]===r.id?Reflect.deleteProperty(a,c):c in a||(a[c]=l),f[e.id]){const e=t.getById(l);e.isLeaf&&!n&&e.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}},[t])}e.afterChange(s,o)}e.traverse((e=>{e.ignoreBag||e.isLinked||t.updateModifiedBagForRecord(e)}))})))}))}return e}removeChild(e,t=!1,n=!1,i={}){var r,s,o;const a=this,l=[],c=a.isLeaf,{children:d,stores:u}=a;if(e=(e=rt.asArray(e)).filter((e=>e.parent===a)),null!==(r=a.firstStore)&&void 0!==r&&r.isChainedTree)return a.$original.removeChild(e.map((e=>e.$original)),t,n,i);if(!n&&u)for(const n of u)if(!n.isChained&&!1===n.trigger("beforeRemove",{parent:a,records:e,isMove:t}))return!1;const h=null===(s=a.beforeRemoveChild)||void 0===s?void 0:s.call(a,e,t);for(const r of e){const{parentIdField:e}=r.constructor,{modified:s}=r.meta,o=r.parent?r.parent.id:null;e in s||r.isLinked||(s[e]=o);const c=a.removeFromChildren(r,i);null==u||u.forEach((e=>{if(!e.isChained){const{isRemoving:s}=e;e.isRemoving=!0;const o=e.onNodeRemoveChild(a,[r],c,{isMove:t,silent:n,...i});rt.chunkedPush(l,o),e.isRemoving=s}})),t||(r.parent=r.parentIndex=r.unfilteredIndex=r.nextSibling=r.previousSibling=null,r.data[e]=null)}return 0===(a.unfilteredChildren||d).length&&a.constructor.convertEmptyParentToLeaf.onRemove&&!a.isRoot&&(a.meta.isLeaf=!0),a.isLeaf===c||n||t||a.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}}),null===(o=a.afterRemoveChild)||void 0===o||o.call(a,e,h,t),l}clearParentId(){const e=this,{parentIdField:t}=e.constructor;Reflect.deleteProperty(e.data,t),Reflect.deleteProperty(e.originalData,t),e.meta.modified&&Reflect.deleteProperty(e.meta.modified,t)}replaceChildren(e){return this.clearChildren(),this.data[this.constructor.childrenField]=e,this.processChildren(),this.children}clearChildren(e=!1){const t=this,{stores:n}=t,i=t.unfilteredChildren||t.children;t.children=[],t.orderedChildren=[],i&&!0!==i&&n&&n.forEach((n=>{n.isChained||n.onNodeRemoveChild(t,i,0,{unfiltered:!0,silent:e})})),t.unfilteredChildren&&(t.unfilteredChildren=[]);const{convertEmptyParentToLeaf:r}=t.constructor;(!0===r||r.onRemove)&&(t.meta.isLeaf=!0)}clear(){var e;const t=this,{stores:n}=t,i=null===(e=t.unfilteredChildren||t.children)||void 0===e?void 0:e.slice();if(t.isRoot&&i){for(const e of n)if(!e.isChained&&!1===e.trigger("beforeRemove",{parent:t,records:i,isMove:!1,removingAll:!0}))return!1;t.children.length=t.orderedChildren.length=0,t.unfilteredChildren&&(t.unfilteredChildren.length=0),n.forEach((e=>{i.forEach((t=>{t.stores.includes(e)&&t.unjoinStore(e),t.parent=t.parentIndex=t.nextSibling=t.previousSibling=null})),e.storage.suspendEvents(),e.storage.clear(),e.storage.resumeEvents(),e.added.clear(),e.modified.clear(),e.trigger("removeAll"),e.trigger("change",{action:"removeall"})}))}}updateChildrenIndices(e,t,n=!1){let i=null;for(let o=0;o<e.length;o++){const a=e[o],l=a[t];if("parentIndex"===t||"orderedParentIndex"===t){if(void 0===l||n)a.setData(t,o);else if(l!==o){var r,s;null===(r=a.stores)||void 0===r||r.forEach((e=>{e.suspendSortOnUpdate(),e.suspendFilterOnUpdate()})),a.set(t,o,!0),null===(s=a.stores)||void 0===s||s.forEach((e=>{e.resumeSortOnUpdate(!1),e.resumeFilterOnUpdate(!1)}))}}else a[t]=o;"parentIndex"===t&&(a.previousSibling=i,i&&(i.nextSibling=a),o===e.length-1&&(a.nextSibling=null),i=a)}}addToChildren(e,t,n={}){const i=this,r=[[i.children,"parentIndex",e],[i.unfilteredChildren,"unfilteredIndex",e],[i.orderedChildren,"orderedParentIndex",void 0===(null==n?void 0:n.orderedBeforeNode)?void 0!==(null==n?void 0:n.orderedParentIndex)?i.orderedChildren[n.orderedParentIndex.index??n.orderedParentIndex]:e:null==n?void 0:n.orderedBeforeNode]];for(const e of r){const[r,o,a]=e;if(r){var s;let l;a?(l=r.indexOf(a),-1===l&&(l=r.length)):l=r.length,e.push(l),rt.chunkedInsert(r,l,t),null!=n&&n.skipIndexUpdate||null!=n&&null!==(s=n[o])&&void 0!==s&&s.skip||i.updateChildrenIndices(r,o)}}return r[0][3]}removeFromChildren(e,t){const n=[[this.children,"parentIndex"],[this.unfilteredChildren,"unfilteredIndex"],[this.orderedChildren,"orderedParentIndex"]];for(const r of n){const[n,s]=r;if(n){const o=n.indexOf(e);var i;if(r.push(o),o>-1)n.splice(o,1),null!=t&&t.skipIndexUpdate||null!=t&&null!==(i=t[s])&&void 0!==i&&i.skip||this.updateChildrenIndices(n,s)}}return n[0][2]}sortOrderedChildren(e=!0,t=!1){const n=this,i=[];return n.isLeaf||(n.orderedChildren.sort(((e,n)=>{if(t){const t=(e.meta.modified.orderedParentIndex??e.orderedParentIndex)-(n.meta.modified.orderedParentIndex??n.orderedParentIndex);return 0!==t&&(i.push(e),i.push(n)),t}return e.orderedParentIndex-n.orderedParentIndex})),e&&n.orderedChildren.forEach((n=>{const r=n.sortOrderedChildren(e,t);rt.chunkedPush(i,r)})),n.updateChildrenIndices(n.orderedChildren,"orderedParentIndex",!0)),new Set(i)}sortVisibleChildren(e=!0,t){const n=this;n.isLeaf||(n.children.sort(t),e&&n.orderedChildren.forEach((n=>n.sortVisibleChildren(e,t))),n.updateChildrenIndices(n.children,"parentIndex",!0))}sortUnfilteredChildren(e=!0,t){const n=this;!n.isLeaf&&n.unfilteredChildren&&(n.unfilteredChildren.sort(t),e&&n.orderedChildren.forEach((n=>n.sortUnfilteredChildren(e,t))),n.updateChildrenIndices(n.unfilteredChildren,"unfilteredIndex",!0))}unjoinStore(e,t=!1){var n;const i=this;i.unfilteredChildren&&(i.children=i.unfilteredChildren.slice(),i.unfilteredChildren=null),null===(n=super.unjoinStore)||void 0===n||n.call(this,e,t)}};const Ms={id:1,internalId:1,stores:1,unjoinedStores:1,parentIndex:1,parent:1,unfilteredChildren:1,children:1,orderedChildren:1,parentId:1,previousSibling:1,nextSibling:1,unfilteredIndex:1},Is={get(e,t){switch(t){case"proxyMeta":return this.proxyMeta;case"constructor":return e.constructor;case"setData":return this.setDataOverride;case"set":return this.setOverride;case"instanceMeta":return this.instanceMetaOverride}return Ms[t]?this.proxyMeta.data[t]:Reflect.get(e,t,this.proxyRecord)},set(e,t,n,i){return"parentId"===t?i.setParentId(n):Ms[t]?this.proxyMeta.data[t]=n:e[t]=n,!0},instanceMetaOverride(e){const{proxyMeta:t}=this,n=e.id||e,i=t.map||(t.map=U.clone(t.originalRecord.instanceMeta(n)));return i[n]||(i[n]={})},setDataOverride(e,t){"parentIndex"===e?this.proxyMeta.data.parentIndex=t:"parentId"===e?this.proxyMeta.data.parentId=t:this.proxyMeta.originalRecord.setData(e,t)},setOverride(e,t,...n){"parentIndex"===e?this.proxyMeta.data.parentIndex=t:this.proxyMeta.originalRecord.set(e,t,...n)}};var ks=e=>class extends(e||tt){static $name="ModelLink";static isModel=!0;link(){if(this.isLinked)return this.$original.link();const e=this,t={...Is,proxyMeta:{originalRecord:e,data:{id:`${e.id}_link_${e.constructor._internalIdCounter}`,internalId:e.constructor._internalIdCounter++,stores:[],unjoinedStores:[],...e.children?{unfilteredChildren:[],children:[],orderedChildren:[]}:{}}}},n=new Proxy(e,t);return t.proxyRecord=n,(e.meta.linkedRecords||(e.meta.linkedRecords=[])).push(n),n}get isLinked(){var e;return Boolean(null===(e=this.proxyMeta)||void 0===e?void 0:e.originalRecord)}get hasLinks(){return Boolean(!this.proxyMeta&&this.$links.length)}get recordLinks(){return this.$links}get originalRecord(){return this.$original}getStoreLink(e){if(e.includes(this))return this;for(const t of this.$links)if(e.includes(t))return t;return null}removeLink(e,t=null,n=!1){if(e.hasLinks)for(const i of e.$links.slice())t?rt.include(t,i):i.remove(n);else e.isLinked&&rt.remove(e.$original.$links,e)}beforeRemove(e){this.removeLink(this,e)}removeChild(e,t,n,i){if(null==i||!i.isInserting){e=rt.asArray(e);for(const t of e)this.removeLink(t,null,n)}return super.removeChild(e,t,n,i)}get $originalId(){return this.$original.id}get $links(){return this.meta.linkedRecords??[]}};const{defineProperty:Fs}=Reflect,As=Symbol("owner"),Ps=/[\s,]+/;var Ls=e=>class extends(e||tt){static $name="Factoryable";static get declarable(){return["factoryable","alias","type"]}static register(e,t,n=globalThis.__BRYNTUM_EXAMPLE||(e=>null===(e=globalThis.DocsBrowser)||void 0===e?void 0:e.isDocsBrowser)()){const{factoryable:i}=this.initClass(),{caseless:r,registry:s}=i,o=V.split(e,Ps);for(let e,a,l=0;l<o.length;++l){if(a=o[l],e=r?a.toLowerCase():a,!n&&e in s)throw new Error(`Type "${a}" already registered with ${i.class.name} factory`);s[a]=s[e]=t.initClass()}}static isA(e,t){return this.isType(e,t,!0)}static isType(e,t,n){const{factoryable:i}=this,{caseless:r,registry:s}=i,o=s[r?t.toLowerCase():t];return!!o&&(n?e instanceof o:e.constructor===o)}static setupAlias(e){e.register(e.alias,e)}static setupFactoryable(e,t){const n=t.super.class;let{factoryable:i}=e;i={caseless:!0,defaultType:null,extends:n.factoryable?[n]:null,typeKey:"type",...i},i.class=e,i.registry=Object.create(null),i.extends&&!Array.isArray(i.extends)&&(i.extends=[i.extends]),Fs(e,"factoryable",{get:()=>i})}static setupType(e,t){const{type:n}=e;e.register(n,e,t.replaceType),Fs(e.prototype,"type",{get:()=>n,set:e=>{if(e!==n)throw new Error("Can not mutate `type` config to different value")}})}static create(e,t){return this.reconfigure(null,e,t)}static reconfigure(e,t,n){const i=this,{factoryable:r}=i,{typeKey:s}=r;let o,a,l,c,d,u,h,g,m,p=n;if(n&&!U.isClass(n)&&(p=null,h=typeof n,"function"===h?u=n:"string"===h?p=n:U.isObject(n)?(o=n.cleanup,a=n.defaults,c=n.owner,u=n.setup,p=n.type,g=n.transform):c=n),g&&(t="string"==typeof g?c[g](t):g(t)),m=t,"string"==typeof m)t={};else if(t){if(!0===t&&(t={}),!U.isObject(t)){var f;if(c&&t!==e&&(null==e?void 0:e[As])===c)"string"==typeof o?c[o](e):null===(f=o)||void 0===f||f(e),e.destroy();return t}m=t[s]}if(m=m&&i.resolveType(m),e){if(t&&(!m||e.constructor===m))return s in t&&delete(t=U.assign({},t))[s],e.setConfig(t),e;var v;if(c&&e[As]===c)"string"==typeof o?c[o](e):null===(v=o)||void 0===v||v(e),e.destroy()}if(t){if(a){if(!(l=m)){if(!(l=a[s]||p||r.defaultType))throw new Error(`No default mergeType defined for ${r.class.name} factory`);l=i.resolveType(l)}l&&(t=l.mergeConfigs(a,t))}if(u){if(d="string"==typeof u?c[u](t,m,a):u(t,m,a),null===d)return d;t=d||t}if(!m){if(!(m=t[s]||p||r.defaultType))throw new Error(`No default type defined for ${r.class.name} factory`);m=i.resolveType(m)}a&&!l&&(t=m.mergeConfigs(a,t)),s in t&&delete(t=U.assign({},t))[s],t=new m(t),c&&(t[As]=c)}return t||null}static resolveType(e,t){if("string"!=typeof e)return e;const{factoryable:n}=this,i=n.extends;let r,s=n.registry[n.caseless?e.toLowerCase():e];for(r=0;!s&&i&&r<i.length;++r)s=i[r].resolveType(e,!0);if(!s&&!t)throw new Error(`Invalid type name "${e}" passed to ${n.class.name} factory`);return s}};const Os=/^([A-Z]+)(?:F|f)ormula/,$s=/^(.*)$/,_s={this:1,data:1},js=e=>{var t;return null===(t=e.fields)||void 0===t?void 0:t.reduce(((t,n)=>{if(n.persist){e.get(n.name)&&(t[n.name]=String(e.get(n.name)))}return t}),{})};class Bs extends(tt.mixin(Ls,dt)){static $name="FormulaProvider";static type="formula";static configurable={callOnFunctions:!0,record:null,store:null,inputField:{$config:"nullify",value:null},handleFormulaInput:null,handleFormulaChange:null,url:null,method:"POST",fetchOptions:null,paramName:"prompt",responseField:"content",headers:{Accept:"application/json","Content-Type":"application/json"},generateContent:null,prefix:null};static factoryable={defaultType:"formula"};fieldMatchRE=/\$([a-zA-Z\-_]+)/g;fieldDelimiterRE=/[^a-zA-Z\-$_]/;changeHeaders(e){return U.clone(e)}updateInputField(e,t){var n;return null===(n=this.inputListenerRemover)||void 0===n||n.call(this),e&&(this.inputListenerRemover=e.ion({thisObj:this,input:"onFieldInput",change:"onFieldChange"})),this.owner=e}onFieldInput(){var e;const t=this,{inputField:n}=t,i=(null===(e=t.store)||void 0===e?void 0:e.modelClass)||(t.record||n.record).constructor,r=t.fieldNames||(t.fieldNames=Object.keys(_s).concat(Object.keys(i.fieldMap)));if(n.formulaProvider===t){var s,o,a;const e=null===(s=n.getCurrentToken(t.fieldDelimiterRE))||void 0===s?void 0:s.token,l=null!=e&&e.startsWith("$")?e.substring(1):null,c=null===(o=n.value.matchAll(t.fieldMatchRE))||void 0===o||null===(a=o.reduce)||void 0===a?void 0:a.call(o,((e,[,t])=>(t===l?r.some((e=>e.startsWith(t)))||e.push(t):_s[t]||i.fieldMap[t]||e.push(t),e)),[]);null!=c&&c.length?n.setError(`Undefined data field(s) ${c.join(",")}`,!1,!0):n.clearError();const d=t.resolveCallback(t.handleFormulaInput,t,!1);null==d||d.handler.call(d.thisObj,n,this)}}onFieldChange(){var e;const t=this,{inputField:n}=t,{value:i}=n,r=t.formulaRE?null===(e=i.trim().match(t.formulaRE||t.constructor.formulaRE||$s))||void 0===e?void 0:e[1]:i,s=t.resolveCallback(t.handleFormulaChange,t,!1);if(r&&s){const e=t.createFormula(r,t.record||n.record,t.store);null==s||s.handler.call(s.thisObj,t,e,n)}}async calculate(e){return this.callback(this.generateContent,this,[e])}updatePrefix(e){this.formulaRE=new RegExp(`^=${e}\\((.+)\\)$`)}updateUrl(e){this.generateContent=e?this.getRemoteContent:null}async getRemoteContent(e){let t;try{const n=this,{method:i,headers:r}=n,s={...n.body};U.setPath(s,n.paramName,e);const o=await er.fetch(n.url,U.assign({credentials:void 0,method:i,headers:r,body:JSON.stringify(s)},n.fetchOptions));if(!o.ok)return n.trigger("formulaNetworkError",{response:o,bubbles:!0}),"";t=await o.json()}catch(e){console.error("Error:",e)}return U.getPath(t,this.responseField)}createFormula(e,t,n){const i={formula:e.replaceAll(this.fieldMatchRE,((e,i)=>{switch(i){case"this":return JSON.stringify(js(t));case"data":return JSON.stringify(n.allRecords.map((e=>js(e))));default:return t.get(i)??""}}))};return this.trigger("formulaChange",i),i.formula}get store(){var e;return this._store||(null===(e=this.record)||void 0===e?void 0:e.firstStore)}static get(e,t){var n;let i=null===(n=this.map)||void 0===n?void 0:n.get(e);return i&&t&&(i=new i(t)),i}static initClass(){var e;const t=Bs,n=this,i=n===t?"FORMULA":(null===(e=n.$name)||void 0===e||null===(e=e.match(Os))||void 0===e?void 0:e[1])||n.formulaPrefix;if(i){n.formulaPrefix||(n.formulaPrefix=i),n.inputPrefixRE=new RegExp(`^=${i}\\(.*`),n.formulaRE=new RegExp(`^=${i}\\((.+)\\)`),(t.map||(t.map=new Map)).set(i,n);const e=[...t.map.keys()].map((e=>e)).join("|");t.inputPrefixRE=new RegExp(`^=(${e})\\(.*`)}return super.initClass()}}Bs.initClass(),Bs._$name="FormulaProvider";const{getOwnPropertyDescriptor:Vs}=Reflect;class Hs extends(tt.mixin(Ls)){static $name="DataField";static type="auto";static factoryable={defaultType:"auto"};static prototypeProperties={compare:null,compareItems:null,dataSource:null,alwaysWrite:!1,nullable:!0,nullText:null,nullValue:void 0,persist:!0,readOnly:!1,internal:!1,calculated:!1,calculate:null,useProp:null,bypassEqualityOnSyncDataset:!1,complexMapping:null};static configurable={formulaProviders:null};construct(e){const t=this;e&&(t.name=e.name,Object.assign(t,e)),t.compare&&(t.compareItems=(e,n)=>t.compare(null==e?void 0:e[t.name],null==n?void 0:n[t.name]))}changeFormulaProviders(e){const t=this;return new Proxy({...e},{set(e,n,i){const r=Reflect.set(e,n,i);return t.updateFormulaProviders(e),r}})}updateFormulaProviders(e){this.inputPrefixRE=e?new RegExp(`^=(${Object.keys(e).join("|")})\\(.*`):null}getFormulaProvider(e){const t=this.formulaProviders[e];if(t){if(t.isFormulaProvider)return t;let{instance:n}=t;if(!n){const i={...t,prefix:e};n=t.instance=Bs.get(e,i)||Bs.create(i)}return n}}get label(){return this._label||V.separate(this.name)}set label(e){this._label=e}defineAccessor(e,t){const{name:n,dataSource:i}=this;!t&&n in e&&e.$meta.hierarchy.some((e=>{var t;return!1===(null===(t=Vs(e.prototype,n))||void 0===t?void 0:t.enumerable)}))||(this.formulaProviders&&e.$meta.class.addField(`#${n}`),Reflect.defineProperty(e,n,{configurable:!0,enumerable:!0,get:this.complexMapping?function(){return this.complexGet(n,i)}:function(){return this.batching&&n in this.meta.batchChanges?this.meta.batchChanges[n]:this.data[i]},set(e){const t=this.$meta.fields.map[n];t&&t.readOnly||this.set(n,e)}}))}isEqual(e,t){return U.isEqual(e,t)}print(e){return null==e?this.nullText:this.printValue(e)}printValue(e){return String(e)}getCurrentConfig(){const e={};for(const t in this.constructor.prototypeProperties)e[t]=this[t];return delete e.isConstructing,e}get calculated(){return Boolean(this.calculate||this._calculated)}set calculated(e){this._calculated=e}get calculate(){return this._calculate}set calculate(e){"function"==typeof e&&(e={fn:e}),this._calculate=e}}Hs._$name="DataField";class zs extends Hs{static $name="ArrayDataField";static type="array";static dataConstructor=Array;isEqual(e,t){return e===t}getAt(e,t){return e.get(this.name)[t]}}zs.initClass(),zs._$name="ArrayDataField";class Ns extends Hs{static $name="BooleanDataField";static type="boolean";static dataConstructor=Boolean;static alias="bool";static get prototypeProperties(){return{nullValue:!1}}isEqual(e,t){return null==e&&null==t||super.isEqual(e,t)}convert(e){var t;return null==e?this.nullable?e:this.nullValue:"false"!==(null===(t=e.toLowerCase)||void 0===t?void 0:t.call(e))&&Boolean(e)}}Ns.initClass(),Ns._$name="BooleanDataField";class Ws extends Hs{static $name="DateDataField";static type="date";static dataConstructor=Date;static get prototypeProperties(){return{format:null}}convert(e){if(null==e)this.nullable||(e=this.nullValue);else if("now"===e)e=new Date;else if(!(e instanceof Date)){const t=e;(e=us.parse(e,this.format||us.defaultParseFormat))&&!isNaN(e)||(e=void 0,""!==t&&console.warn(`Date parsing failed for "${this.name}" field, input: ${JSON.stringify(t)}. ${this.format?`Expected format: ${this.format}.`:'You should configure your Model field with a "format" to specify how dates should be parsed. See docs for DateDataField here: https://bryntum.com/products/scheduler/docs/api/Core/data/field/DateDataField, and see https://bryntum.com/products/scheduler/docs/api/Core/helper/DateHelper for the different formats.'}"`))}return e}serialize(e){return e instanceof Date&&(e=us.format(e,this.format||us.defaultFormat)),e}printValue(e){return us.format(e,this.format||us.defaultFormat)}}Ws.initClass(),Ws._$name="DateDataField";class Us extends Hs{static $name="StringDataField";static type="string";static dataConstructor=String;static get prototypeProperties(){return{nullValue:""}}convert(e){return null==e?this.nullable?e:this.nullValue:String(e)}}Us.initClass(),Us._$name="StringDataField";class Gs extends Us{static $name="DurationUnitDataField";static type="durationunit";isEqual(e,t){return 0===us.compareUnits(e,t)}}Gs.initClass(),Gs._$name="DurationUnitDataField";class qs extends Hs{static $name="IntegerDataField";static type="integer";static alias="int";static dataConstructor=Number;static get prototypeProperties(){return{nullValue:0,rounding:"round"}}convert(e){return null==e?this.nullable?e:this.nullValue:Math[this.rounding](Number(e))}}qs.initClass(),qs._$name="IntegerDataField";class Ys extends Hs{static $name="ModelDataField";static type="model";static configurable={modelClass:null};static get prototypeProperties(){return{complexMapping:!0}}isEqual(e,t){return e&&t&&t instanceof e.constructor&&t.id==e.id}}Ys.initClass(),Ys._$name="ModelDataField";class Ks extends Hs{static $name="NumberDataField";static type="number";static alias="float";static dataConstructor=Number;static get prototypeProperties(){return{nullValue:0,precision:null}}isEqual(e,t){return isNaN(Number(e))&&isNaN(Number(t))||super.isEqual(e,t)}convert(e){if(null==e)return this.nullable?e:this.nullValue;if(e=Number(e),isNaN(e))return;let t=this.precision;return t?(t=10**t,e=Math.round(e*t)/t):0===t&&(e=Math.round(e)),e}}Ks.initClass(),Ks._$name="NumberDataField";class Xs extends Hs{static $name="ObjectDataField";static type="object";static dataConstructor=Object;static get prototypeProperties(){return{complexMapping:!0}}}Xs.initClass(),Xs._$name="ObjectDataField";const Zs=e=>"string"==typeof e&&e.startsWith("_generated");class Js extends Hs{static $name="StoreDataField";static type="store";init(e,t,n){var i;const r=this,s=`${r.name}Store`,o={skipStack:!0,syncDataOnLoad:!0,useRawData:!1};if(r.store&&U.assign(o,r.store),r.modelClass&&(o.modelClass=r.modelClass),null===(i=t[`init${V.capitalize(s)}`])||void 0===i||i.call(t,o),!o.storeClass&&!r.storeClass)throw new Error(`Field '${r.name}' with type 'store' must have a storeClass configured`);const a=t.meta[s]=new(o.storeClass||r.storeClass)(o);r.complexMapping?U.setPath(e,r.dataSource,a):e[r.dataSource]=a,a.verifyNoGeneratedIds=!1,a.usesId=r.usesId||!a.count||!a.every((e=>e.hasGeneratedId)),a.$currentValue=r.getValue(a,t),a.ion({change:({action:e})=>{const n=r.getValue(a,t);if(!a.$isSettingStoreFieldData){const i=a.$preserveCurrentDataset;a.$preserveCurrentDataset=r.subStore&&("update"===e||"remove"===e||"add"===e),r.$isUpdatingRecord=!0,t.set(r.name,n),r.$isUpdatingRecord=!1,a.$preserveCurrentDataset=i}a.$currentValue=n}}),r.$chrono&&n(r,a)}set(e,t,n){var i,r;const s=this,o=`${s.name}Store`,{[o]:a}=n.meta;if(null!==(i=e)&&void 0!==i&&i.isStore&&(e=e.$currentValue),!a)return n.meta.initableValues.set(s,e),!1;a.$isSettingStoreFieldData||(a.$isSettingStoreFieldData=!0,e=(null===(r=n[`process${V.capitalize(o)}Data`])||void 0===r?void 0:r.call(n,e,n))??e,a.$preserveCurrentDataset||(a.data=e),a.$isSettingStoreFieldData=!1,a.usesId=s.usesId||!a.count||!a.every((e=>e.hasGeneratedId)))}serialize(e,t){const n=t.meta[`${this.name}Store`];return this.$isUpdatingRecord?this.getValue(n,t):n.$currentValue}getValue(e,t){const n=`get${V.capitalize(this.name)}StoreValue`;return t[n]?t[n](e):e.allRecords.map((t=>{const n=t.persistableData;return e.usesId||delete n.id,n}))}isEqual(e,t){if(null==e&&null==t)return!0;if(null==e&&null!=t||null!=e&&null==t)return!1;if(e.isStore&&t.isStore)return U.isDeeplyEqual(e.$currentValue,t.$currentValue);if(e.isStore&&t.isStore||!e.isStore&&!t.isStore)return U.isEqual(e,t,!0);{const n=(e.isStore?e:t).modelClass,i=n.$meta.fields.defs,r=e.isStore?e.$currentValue:t.$currentValue,s=e.isStore?t:e;if(r.length!==s.length)return!1;for(let e=0;e<i.length;e++){const t=i[e];if(t.persist)for(let e=0;e<r.length;e++){const i=r[e][t.dataSource],o=s[e][t.dataSource];if(void 0!==i&&void 0===o){if(t.dataSource===n.idField&&Zs(i))continue;if(void 0!==t.defaultValue&&U.isEqual(t.defaultValue,i,!0))continue}if(!U.isEqual(i,o,!0))return!1}}return!0}}getOldValue(e){const t=e.meta[`${this.name}Store`];return t?U.clone(t.$currentValue):null}getAt(e,t){const n=e.meta[`${this.name}Store`];return null==n?void 0:n.getAt(t)}}Js.initClass(),Js._$name="StoreDataField";const Qs=/^(.*?)\.(.*)/,eo=/(.*)\[(.*)]\.?(.*)/,{defineProperty:to}=Reflect,{hasOwn:no}=U,io=void 0,ro={children:1,data:1,meta:1},so=["name","title","text","label","description"],oo={boolean:1,number:1,date:1,object:1},ao={parentId:1,$PhantomId:2,id:3};class lo extends(tt.mixin(Es,Ts,ks)){static $name="Model";static get declarable(){return["fields"]}static get fields(){return[{name:"parentIndex",type:"number",persist:!1,internal:!0},{name:"orderedParentIndex",type:"number",persist:!1,internal:!0},{name:"readOnly",type:"boolean"},{name:"expanded",internal:!0}]}static relations=null;static set idField(e){this._assignedIdField=!0,this._idField=e}static get idField(){return this._idField}get id(){return this._id??this.getData("id")}set id(e){this.set("id",e)}static set childrenField(e){this._childrenField=e}static get childrenField(){if(!this._childrenField){const e=this.fieldMap.children;this._childrenField=(null==e?void 0:e.dataSource)||"children"}return this._childrenField}get indexPath(){const e=[];let t=this,n=t.childLevel;for(t=this;t&&!t.isRoot;t=t.parent)e[n--]=t.parentIndex+1;return e}construct(e={},t=null,n=null,i=!1,r=!1,s=!1){var o;const a=this,{constructor:l,fieldMap:c}=a;if(a.meta={modified:{},...l.metaConfig,...n},l.applyConfigs){const t={};a.useRawData&&a.useRawData.enabled||(e={...e});const n=a.getDefaultConfiguration();if(l.autoExposeFields)for(const i in n)i in e&&(void 0!==e[i]&&(t[i]=e[i]),delete e[i]);else for(const i in e)i in l.fieldMap||(void 0===e[i]?t[i]=n[i]:t[i]=e[i],delete e[i]);super.construct(t)}if(i||l.exposeProperties(e,s),!no(l,"idFieldProcessed")){let e=a.meta.idField;e||l._assignedIdField&&(e=l.idField),e&&e!==c.id.dataSource&&l.addField({name:"id",dataSource:e,internal:!0}),l._idField=c.id.dataSource,l.idFieldProcessed=!0}a._internalId=lo._internalIdCounter++,a.originalData||(a.originalData=e);const d=l.processData(e,!1,t,a,r);a._id=c.id.complexMapping?U.getPath(d,l._idField):d[l._idField],(null===(o=a.meta.initableValues)||void 0===o?void 0:o.size)&&a.assignInitables(),null!=a._id||l.allowNullId&&null===a._id||a.setData("id",a.generateId(t)),d[l.childrenField]&&a.processChildren(rt.asArray(t)??[]),a.generation=0}set isCreating(e){const t=this;var n;Boolean(t.meta.isCreating)!==e&&(t.meta.isCreating=e,null===(n=t.stores)||void 0===n||n.forEach((n=>n.onIsCreatingToggle(t,e))))}get isCreating(){return Boolean(this.meta.isCreating)}equals(e){if(e instanceof this.constructor){for(let t=this.$meta.fields.defs,n=0,{length:i}=t;n<i;n++){const i=t[n],{name:r}=i;if("id"!==r&&!i.isEqual(this.getValue(r),e.getValue(r)))return!1}return!0}return!1}static processData(e,t=!1,n,i,r){const s=this,{map:o,defaults:a,chronoProps:l}=s.$meta.fields,{useRawData:c={enabled:!1}}=n||{},d=r||c.enabled?e:U.clone(e),u=Boolean(i.$entity);let h,g;if(i.isConstructing&&(i.data=d),u&&!t){g={};for(const e of l)g[e.name]=i.createFieldIdentifier(e);Object.defineProperty(i,"$",{value:g,enumerable:!0,configurable:!0})}const m=t||c.disableDefaultValue||r;if(!m||!c.disableTypeConversion&&!r||u)for(h in o){const n=o[h],{name:l,dataSource:u}=n,p=u!==l,f=n.complexMapping,v=f?U.getPath(d,u):d[u],y=void 0===v?f?U.getPath(d,l):d[l]:void 0,b=void 0!==v,C=void 0!==y,S=!b&&C,w=b||C,D=!c.disableTypeConversion&&n.convert;let E=S?y:v;if(!m&&u in a&&!w&&!n.fromData){let e=a[u];Array.isArray(e)?e=e.slice():e instanceof Date?e=new Date(e):e&&"object"==typeof e&&(e=U.clone(e)),f?U.setPath(d,u,e):d[u]=e,E=e}if((S||D)&&(!m||w)&&!r&&!n.calculate){let t=D?n.convert(E,e,i):E;s.processFieldData&&(t=s.processFieldData(n,t,E,e,i)),(void 0!==t||void 0!==E||b)&&(f?U.setPath(d,u,t):d[u]=t,p&&delete d[l],E=t)}if(!t&&n.$chrono){(g[l]=i.createFieldIdentifier(n.$chrono)).DATA=E}}return s.$meta.fields.calculated.forEach((e=>{const{calculate:t}=e;if(!e._cachedDependencies&&!t.dependsOn){e._cachedDependencies=!0;const n=new Set,r=new Proxy(d,{get:(e,t)=>(n.add(t),d[t])});let o;try{t.fn(r,i),t.dependsOn=Array.from(n),s.setupDependentCalcFields(e),o=0===n.size}catch(e){o=!0}o&&console.warn(`Failed to auto-detect dependent fields for "${e.name}" field. Add "dependsOn" in your calculate config.`)}d[e.name]=i.refreshCalculatedField(e)})),s.$meta.fields.initable.length&&s.initInitables(i,d,((e,t)=>{(g[e.name]=i.createFieldIdentifier(e.$chrono)).DATA=t})),d}static setupClass(e){super.setupClass(e),e.fields||this.setupFields(this,e)}static setupFields(e,t){var n;const i=no(e,"fields")&&e.fields,r=t.super.fields,s=t.fields={defs:(null==r?void 0:r.defs.slice())??[],calculated:(null==r?void 0:r.calculated.slice())??[],exposedData:!1,defaults:r?{...r.defaults}:{},exposed:Object.create((null==r?void 0:r.exposed)??null),ordinals:Object.create((null==r?void 0:r.ordinals)??null),map:r?{...r.map}:{},sources:r?{...r.sources}:{},chronoProps:[],subModels:[]};if(e!==lo){let n=t;do{n=n.super,n.fields.subModels.push(e)}while(n.class!==lo)}if(no(e,"defaults")&&Object.assign(s.defaults,e.defaults),no(e,"idField")&&(e.addField({name:"id",dataSource:e.idField,internal:!0}),s.exposed[e.idField]=!0),null!=i&&i.length&&i.map(e.addField,e),s.initable=s.defs.filter((e=>e.init)),null!==(n=e.$entity)&&void 0!==n&&n.allFields.size)for(const t of e.$entity.allFields.values())s.map[t.name]||s.chronoProps.push(t);e.exposeRelations()}static get defaultValues(){return this.$meta.fields.defaults}static get allFields(){return this.$meta.fields.defs}get allFields(){return this.$meta.fields.defs}static get fieldMap(){return this.$meta.fields.map}get fieldMap(){return this.$meta.fields.map}static get fieldDataSourceMap(){return this.$meta.fields.sources}static exposeProperties(e,t=!0){const n=this,i=n.$meta.fields,r=t?"exposed":"map";if(e&&n.autoExposeFields&&!i.exposedData){let t,s,o;for(t in e)i[r][t]||t===n.childrenField||(o=U.typeOf(e[t]),s={name:t,dataSource:t,fromData:!0},oo[o]&&(s.type=o),n.addField(s));i.exposedData=!0}n.exposeRelations()}static addField(e){if(null==e)return;"string"==typeof e&&(e={name:e});const t=this.initClass(),n=t.$meta.fields,{ordinals:i,calculated:r,subModels:s}=n,o=n.exposed,{name:a}=e,l=n.map[a],c=e.dataSource||(e.dataSource=a);let d,u;var h;if(!l||e.type&&e.type!==l.type)e.model=t,d=Hs.create(e),e.model=null,d.definedBy=l?l.definedBy:t,d.ordinal=l?l.ordinal:i[a]=n.defs.length,null!==(h=d.calculate)&&void 0!==h&&h.dependsOn&&t.setupDependentCalcFields(d);else for(u in d=Object.create(l),e)"type"!==u&&(d[u]=e[u]);d.owner=t,n.defs[d.ordinal]=d,n.map[a]=d,n.sources[c]=d;for(const e of s)e.$meta.fields.map[a]=d;return!1!==d.complexMapping&&c.includes(".")&&(d.complexMapping=!0),d.complexMapping?o[c.split(".")[0]]=!0:o[c]=!0,"defaultValue"in d&&(n.defaults[c]=d.defaultValue),ro[a]||d.defineAccessor(t.prototype),d.calculate&&r.push(d),t._nonPersistableFields=null,t._alwaysWriteFields=null,d}static setupDependentCalcFields(e){const t=this.$meta.fields;e.calculate.dependsOn.forEach((n=>{if(!t.map[n])throw new Error(`No "${n}" field defined in ${this.$name} class`);t.map[n].dependentFields=t.map[n].dependentFields||[],t.map[n].dependentFields.push(e.name)}))}static removeField(e){const t=this.initClass(),n=t.$meta.fields,i=n.map[e],{ordinals:r}=n,s=r[e];if(i){n.defs.splice(s,1),delete r[e],delete n.defaults[e],delete n.exposed[e],delete n.map[e],delete n.sources[i.dataSource];for(const e in r)r[e]>s&&--r[e];delete t.prototype[e]}}static exposeRelations(){const e=this;if(!no(e,"exposedRelations")&&e.relations){e.exposedRelations=[];for(const t in e.relations){const n=e.relations[t];n.relationName=t,e.exposedRelations.push(n),Reflect.ownKeys(e.prototype).includes(t)||to(e.prototype,t,{enumerable:!0,get:function(){return this.getForeign(t)},set:function(e){this.setForeign(t,e,n)}})}}}static initInitables(e,t,n){const i=e.meta.initableValues=new Map;for(const r of this.$meta.fields.initable){const s=U.getPath(t,r.dataSource);void 0!==s&&i.set(r,s),!r.lazy&&r.init(t,e,n)}}assignInitables(){const{initableValues:e}=this.meta;for(const[t,n]of e)!1!==t.set(n,this.data,this)&&e.delete(t)}static get autoExposeFields(){return!0}static fieldSorter(e,t){return(ao[e]||100)-(ao[t]||100)}get fields(){return this.$meta.fields.defs}getFieldDefinition(e){return this.constructor.getFieldDefinition(e)}getFieldDefinitionFromDataSource(e){return this.$meta.fields.sources[e]}get fieldNames(){return Object.keys(this.data)}static getFieldDefinition(e){const t=this.fieldMap[e];if(!t)if(e.includes("[")){const[,t,,i]=e.match(eo),r=t.includes(".")?this.getFieldDefinition(t):this.fieldMap[t];var n;if(null!=r&&r.isStoreDataField)return null===(n=r.modelClass)||void 0===n?void 0:n.getFieldDefinition(i)}else if(e.includes(".")){const[t,n]=e.split(".",2),i=this.fieldMap[t];if(null!=i&&i.isModelDataField&&i.modelClass)return i.modelClass.getFieldDefinition(n)}return t}static getFieldDataSource(e){var t;return(null===(t=this.getFieldDefinition(e))||void 0===t?void 0:t.dataSource)||e}getDataSource(e){const t=this.constructor.getFieldDefinition(e);return(null==t?void 0:t.dataSource)||(null==t?void 0:t.name)}static processField(e,t,n){const i=this.fieldMap[e];return null!=i&&i.convert?i.convert(t,this.data,n):t}initRelations(){const e=this;e.constructor.exposedRelations&&e.stores.forEach((t=>{var n;t.modelRelations||t.initRelations();const i=[];null===(n=t.modelRelations)||void 0===n||n.forEach((t=>{i.push({related:e.initRelation(t),config:t})})),t.updateRecordRelationCache(e,i)}))}initRelation(e){const t=this,n=t.get(e.foreignKey),i=n!==io&&"string"!=typeof e.foreignStore&&e.foreignStore.getById(n);return(t.meta.relationCache||(t.meta.relationCache={}))[e.relationName]=i||(null!=n?{id:n,placeHolder:!0}:null),i}removeRelation(e){const{relationName:t,foreignKey:n,nullFieldOnRemove:i}=e;this.meta.relationCache[t]&&(delete this.meta.relationCache[t],i&&this.setData(n,null))}getForeign(e){var t;return null===(t=this.meta.relationCache)||void 0===t?void 0:t[e]}setForeign(e,t,n){const i=lo.asId(t);return this.set(n.foreignKey,i)}getRelationConfig(e){var t;return null===(t=this.firstStore)||void 0===t||null===(t=t.modelRelations)||void 0===t?void 0:t.find((t=>t.foreignKey===e))}flatGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:this.data[t]}complexGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:U.getPath(this.data,t)}get(e){if(!e)return;const t=this,{fieldMap:n}=t,i=n[e];if(!i){if(e.includes("[")){const[,i,r,s]=e.match(eo),o=n[i];if(null!=o&&o.getAt){t._thisIsAUsedExpression(t[i]);const e=o.getAt(t,r);return e&&s?e.isModel?e.getValue(s):e[s]:e}return null}if(e.includes(".")){const[i,r]=e.split(".",2),s=n[i];if(null!=s&&s.isStoreDataField){const e=t[i];return r in e.modelClass.fieldMap||!(r in e)?null==e?void 0:e.getDistinctValues(r):e[r]}return U.hasPath(t.data,e)?t.complexGet(e,e):U.getPath(t,e)}}return null!=i&&i.complexMapping?t.complexGet(e,i.dataSource):t.flatGet(e,(null==i?void 0:i.dataSource)||e)}getValue(e){if(e)return e in this&&!e.includes(".")?this[e]:this.get(e)}setValue(e,t){e in this?this[e]=t:this.set(e,t)}setData(e,t){const{data:n,fieldMap:i}=this;if("string"==typeof e){const r=i[e],s=(null==r?void 0:r.dataSource)??e;null!=r&&r.set?r.set(t,this.data,this):null!=r&&r.complexMapping?U.setPath(n,s,t):n[s]=t,"id"===r?this._id=t:"parentId"===e&&(n[this.constructor.parentIdField]=t)}else{const r=Object.keys(e);for(let s=0;s<r.length;s++){const o=r[s],a=i[o],l=(null==a?void 0:a.dataSource)??o;null!=a&&a.set?a.set(t,this.data,this):l&&(null!=a&&a.complexMapping?U.setPath(n,l,e[o]):n[l]=e[o],"id"===o?this._id=t:"parentId"===o&&(n[this.constructor.parentIdField]=t))}}}getData(e){const t=this.fieldMap[e],n=(null==t?void 0:t.dataSource)??e;if(n)return null!=t&&t.complexMapping?U.getPath(this.data,n):this.data[n]}syncId(e){const t=this.id;if(t!==e){this._id=e,this.setData("id",e);const n={id:{value:e,oldValue:t}};this.afterChange(n,n)}}set(e,t,n=!1,i=!1,r=!1,s=!1,o=!0){const a=this;if(!a.isBatchUpdating){var l;const c=a.inSet(e,t,n,i,r,s,o);return null===(l=a.afterSet)||void 0===l||l.call(a,e,t,n,i,c),c}a.inBatchSet(e,t,n||a.$silenceBatch)}updateDependentFieldValues(e){if("object"==typeof e)Object.keys(e).forEach((e=>this.updateDependentFieldValues(e)));else{e.startsWith("#")&&(e=e.substring(0));for(const[t,n]of Object.entries(this.constructor.dependentFields||{}))e in n&&this.set(t,this.get(`#${t}`))}}fieldToKeys(e,t){return"string"!=typeof e?U.assign({},e):{[e]:t}}inBatchSet(e,t,n){const i=this,{meta:r,constructor:s,fieldMap:o}=i,a={};let l,c=!1;if("string"!=typeof e?Object.keys(i.fieldToKeys(e,t)).forEach((n=>{l=o[n]||U,t=s.processField(n,e[n],i),l.isEqual(r.batchChanges[n],t)||(a[n]={value:t,oldValue:i.get(n)},r.batchChanges[n]=t,c=!0)})):(l=o[e]||U,l.isEqual(r.batchChanges[e],t)||(a[e]={value:t,oldValue:i.get(e)},r.batchChanges[e]=t,c=!0)),c&&(i.generation++,!n)){var d;const e={action:"update",record:i,records:[i],changes:a};null===(d=i.stores)||void 0===d||d.forEach((t=>t.trigger("batchedUpdate",{...e}))),i.forEachLinked(((t,n)=>t.trigger("batchedUpdate",{...e,record:n,records:[n]})))}}inSet(e,t,n,i,r=!1,s=!1,o=!0){var a,l;const c=this,{data:d,meta:u,fieldMap:h,constructor:g}=c,{prototype:m,childrenField:p,relations:f}=g,v={},y=c.fieldToKeys(e,t),b=Object.keys(y).sort(g.fieldSorter),C=null===(a=c.stores)||void 0===a?void 0:a.some((e=>e.isSyncingDataOnLoad)),S=null===(l=c.stores)||void 0===l?void 0:l.some((e=>e.modificationsTracking>0));if(!n&&o&&!c.triggerBeforeUpdate(y))return null;let w,D,E,x=!1;if("object"==typeof e&&1===Object.keys(e).length&&(t=Object.values(e)[0],e=Object.keys(e)[0]),"string"==typeof e&&(w=c.getFieldDefinition(e))&&w.formulaProviders){var R,T;const n=null===(R=t)||void 0===R||null===(R=R.match(w.inputPrefixRE))||void 0===R?void 0:R[1];var M,I;if(E=`#${e}`,D=null===(T=w.formulaProviders[n])||void 0===T?void 0:T.instance,!D)D=null===(M=(I=w).getFormulaProvider)||void 0===M?void 0:M.call(I,n);b.push(E),y[E]=t}if(D){var k,F;const{formulaRE:n}=D,i=n?null===(k=(F=t.trim()).match)||void 0===k||null===(k=k.call(F,n))||void 0===k?void 0:k[1]:t;if(i){var A,P;const n=c.constructor,r=n.dependentFields||(n.dependentFields={}),s=D.createFormula(i,c,c.firstStore),o=D.calculate(s);null==i||null===(A=i.matchAll(D.fieldMatchRE))||void 0===A||null===(P=A.forEach)||void 0===P||P.call(A,(([,t])=>{t!==e&&((r[e]||(r[e]={}))[t]=1)})),y[e]=o,u.pendingFormulae=(u.pendingFormulae||0)+1;try{var L;null===(L=o.then)||void 0===L||L.call(o,(n=>{u.pendingFormulae=Math.max(0,u.pendingFormulae-1),c.set({[e]:n,[E]:t})}))}catch(n){u.pendingFormulae=Math.max(0,u.pendingFormulae-1),c.firstStore.trigger("formulaError",{record:c,field:e,error:n,formula:t}),c.set(e,"")}}}c.inSetting=!0;for(let e=0;e<b.length;e++){const t=b[e];if(t===p)continue;if(t.includes("[")){const[,e,n,i]=t.match(eo),r=c.fieldMap[e];if(null!=r&&r.getAt){var O;const s=r.getAt(c,n)??(null===(O=r.onSubRecordMissingInSet)||void 0===O?void 0:O.call(r,c,n));if(null==s)throw new Error(`The store field '${e}' does not contain a record at index ${n} - can not set the data`);s.isModel?s.set(i,y[t]):U.setPath(s,i,y[t]);continue}}const n=t.includes(".");if(f&&n){const[,e,n]=t.match(Qs);if(f[e]){n.includes(".")?c[e].set(n,y[t]):c[e][n]=y[t];continue}}const o=h[t],a=o||U,l=null==o?void 0:o.readOnly,w=(null==o?void 0:o.dataSource)??t,D=!r&&!o&&t in m||(null==o?void 0:o.useProp),E=D?c[w]:null!=o&&o.complexMapping||n?U.getPath(d,w):d[w],R=g.processField(t,y[t],c),T=y[t]={value:R},M=U.isPromise(R),I=c.getRelationConfig(t);var $;if(!l&&(C&&null!=o&&o.bypassEqualityOnSyncDataset||!a.isEqual(E,R))&&(!s||void 0!==R))c.generation++,T.oldValue=(null==o||null===($=o.getOldValue)||void 0===$?void 0:$.call(o,c))??E,x=!0,t in u.modified&&a.isEqual(u.modified[t],R,!1,!0)?(Reflect.deleteProperty(u.modified,t),c.isReverting&&(c.data[w]=R)):c.ignoreBag||S?S&&Reflect.deleteProperty(u.modified,t):(t in u.modified||null==E&&null==R||M||c.storeFieldChange(t,E),T.oldValue===io&&Reflect.deleteProperty(T,"oldValue")),v[t]=T,c.applyValue(D,w,R,r,o),I&&!i&&(c.initRelation(I),c.stores.forEach((e=>e.cacheRelatedRecord(c,R,I.relationName,T.oldValue))))}return x&&c.afterChange(y,v,n,i,r),c.updateDependentFieldValues(e),c.inSetting=!1,x?v:null}applyValue(e,t,n,i,r){var s,o,a;const l=this;var c,d;if(((null===(s=r)||void 0===s?void 0:s.dataSource)||t)===l.constructor.idField&&(l.$isPhantom=!1,l._id=n),((null===(o=r)||void 0===o?void 0:o.dataSource)||t)===l.constructor.parentIdField)null!==(c=l.firstStore)&&void 0!==c&&c.tree&&(null===(d=l.parent)||void 0===d||!d.isRoot||null!=n&&l.firstStore.getById(n))&&(l.firstStore.getById(n)||l.firstStore.rootNode).insertChild(l,null,!1,{orderedParentIndex:{skip:!0}});else if(e){var u;l[(null===(u=r)||void 0===u?void 0:u.name)||t]=n}else if(null!==(a=r)&&void 0!==a&&a.set)r.set(n,l.data,l);else{var h;let e=null===(h=r)||void 0===h?void 0:h.complexMapping;if(!r&&t.includes(".")){var g,m;const n=t.split(".")[0];e=(null===(g=r=l.constructor.fieldMap[n])||void 0===g?void 0:g.complexMapping)||"object"===(null===(m=r)||void 0===m?void 0:m.type)}e?U.setPath(l.data,t,n):l.data[t]=n}}afterChange(e,t,n,i,r){const s=this.updateDependentFields(Object.keys(t));if(s&&Object.assign(t,s),this.stores)for(const s of this.stores)s.onModelChange(this,e,t,n,i,r);this.forEachLinked(((s,o)=>s.onModelChange(o,e,t,n,i,r)))}updateDependentFields(e){const t={};return e.forEach((e=>{var n;null===(n=this.getFieldDefinition(e))||void 0===n||null===(n=n.dependentFields)||void 0===n||n.forEach((e=>{const n=this.fieldMap[e],i=this.refreshCalculatedField(n);t[e]=i}))})),Object.keys(t).length>0?this.set(t,void 0,!0):t}refreshCalculatedField(e){var t;const n=this;"string"==typeof e&&(e=n.getFieldDefinition(e));const i=null===(t=e.calculate)||void 0===t?void 0:t.fn.call(e,n);return U.isPromise(i)&&(n.isConstructing?n.data[e.name]=i:n[e.name]=i,i.then((t=>n[e.name]=t))),i}forEachLinked(e){for(const t of this.$links)for(const n of t.stores)e(n,t)}get isPersistable(){return!this.isBatchUpdating&&!this.isCreating}get isModified(){return Boolean(this.meta.modified&&Object.keys(this.meta.modified).length>0)}get hasPersistableChanges(){return this.isPersistable&&!U.isEmpty(this.rawModificationData)}isFieldModified(e){return this.isModified&&e in this.meta.modified}getUnmodified(e){return this.isModified?this.meta.modified[e]:this.get(e)}getFieldPersistentValue(e){const t="string"==typeof e?this.getFieldDefinition(e):e,n=(null==t?void 0:t.name)||e;let i;return t&&!t.persist||(i=this.getValue(n),null!=t&&t.serialize&&(i=t.serialize(i,this))),i}get modifications(){const e=this.rawModifications;return e&&Object.keys(e).length&&(e[this.constructor.idField]=this.id),e}get rawModifications(){const e=this,t={};if(!e.isModified)return null;let n=!1;return Object.keys(e.meta.modified).forEach((i=>{const r=e.getFieldPersistentValue(i);r!==io&&(t[i]=r,n=!0)})),n?t:null}get modificationData(){const e=this.rawModificationData;return e&&Object.keys(e).length&&U.setPath(e,this.constructor.idField,this.id),e}get rawModificationData(){const e=this,{fieldMap:t}=e.constructor,n={};if(!e.isModified)return null;let i=!1;return Object.keys(e.meta.modified).forEach((r=>{var s,o;let a=t[r],l=null===(s=a)||void 0===s?void 0:s.dataSource;if(r.includes(".")){const e=r.match(Qs)[1];a=t[e],l=r}if(null!==(o=a)&&void 0!==o&&o.persist){const t=e.getFieldPersistentValue(r);t!==io&&(U.setPath(n,l,t),i=!0)}})),i?n:null}get modificationDataToWrite(){const e=this,{modificationData:t,constructor:n}=e,i=t??{},r=n.alwaysWriteFields;let s=Boolean(t);return r.forEach((t=>{U.setPath(i,t.dataSource,e.getFieldPersistentValue(t)),s=!0})),s&&!t&&U.setPath(i,n.idField,e.id),s?i:null}get persistableData(){const e=this,t={};return e.fields.forEach((n=>{const i=e.getFieldPersistentValue(n);i!==io&&(null!=n&&n.complexMapping?U.setPath(t,n.dataSource,i):t[n.dataSource]=i)})),t}get dataByFieldName(){const{data:e}=this;return this.fields.reduce(((t,n)=>(U.hasPath(e,n.dataSource)&&(t[n.name]=e[n.dataSource]),t)),{})}get isCommitting(){return Boolean(this.meta.committing)}clearChanges(e){var t;this.internalClearChanges(e),null===(t=this.stores)||void 0===t||t.forEach((e=>e.trigger("clearChanges",{record:this})))}internalClearChanges(e=!0,t=!0,n=null,i=!1){const r=this,{meta:s}=r;if(n){const{modified:e}=s;for(const t in n)delete e[t];for(const t in e){var o,a;(null!==(o=e[t])&&void 0!==o&&o.isStore&&!e[t].changes||i&&(null===(a=r.getFieldDefinition(t))||void 0===a||!a.persist))&&delete e[t]}}else s.modified=Object.assign({},s.modifiedMaterialized),s.modifiedMaterialized=null;const l=U.isEmpty(s.modified);var c;(s.committing=!1,t)&&(null===(c=r.stores)||void 0===c||c.forEach((t=>{if(l&&t.modified.remove(r),t.added.remove(r),e){const e=t.collectDescendants(r).all;t.added.remove(e),l&&t.modified.remove(e)}})))}storeFieldChange(e,t){const{meta:n}=this;n.modified[e]=t,this.isBeingMaterialized&&(n.modifiedMaterialized=n.modifiedMaterialized??{},n.modifiedMaterialized[e]=t)}revertChanges(e=!1){this.isReverting=!0,this.set(this.meta.modified,io,e),this.isReverting=!1}setByDataSource(e){const{fieldDataSourceMap:t}=this.constructor,n=U.pathifyKeys(e,t),i={};for(const e in n){const r=t[e];i[(null==r?void 0:r.name)??e]=n[e]}return this.set(i)}applyChangeset(e,t="$PhantomId",n=!0){const i=this,r=i.constructor,{idField:s,fieldDataSourceMap:o}=r,a=U.pathifyKeys(e,o),l=U.pathifyKeys(i.modificationData),c={};!(t in e&&!(s in e))&&t in a&&delete a[t];for(const e in a){const t=o[e],i=(null==t?void 0:t.name)??e;(n||l[e]===a[e])&&(c[i]=a[e])}const d=i.set(c);return i.internalClearChanges(!1,!0,c),d?Object.entries(d).reduce(((e,[t,n])=>(e[t]=n.value,e)),{}):{}}get internalId(){return this._internalId}get isPhantom(){return""===this.id||null==this.id||this.hasGeneratedId||Boolean(this.$isPhantom)}get isModel(){return!0}get hasGeneratedId(){return"string"==typeof this.id&&this.id.startsWith("_generated")}static generateId(e=this.$$name){return`_generated${e}_${V.generateUUID()}`}generateId(){return this.constructor.generateId()}static asId(e){return null!=e&&e.isModel?e.id:U.isObject(e)?e[this.fieldMap.id.dataSource]:e}get json(){return V.safeJsonStringify(this)}toJSON(){const{children:e,unfilteredChildren:t}=this,n=this.persistableData;return(t||e)&&(n[this.constructor.childrenField]=(t||e).map((e=>e.toJSON()))),n}toString(){const e=this,t=so.find((t=>t in e.constructor.fieldMap)),n=t?{[e.constructor.idField]:e.id,[t]:e[t]}:e.data;return V.safeJsonStringify(n)}get isBatchUpdating(){return Boolean(this.batching)}hasBatchedChange(e){var t;return null===(t=this.meta)||void 0===t||null===(t=t.batchChanges)||void 0===t?void 0:t[e]}beginBatch(e=!1){const t=this;t.batching||(t.batching=0,t.meta.batchChanges={}),e&&(t.$silenceBatch=(t.$silenceBatch||0)+1),t.batching++}endBatch(e=!1,t=!1,n=!0){const i=this,{parentIdField:r}=i.constructor;if(i.batching&&(i.batching--,i.$silenceBatch&&i.$silenceBatch--,!(i.batching>0||U.isEmpty(i.meta.batchChanges)))){let{batchChanges:s}=i.meta;i.meta.batchChanges=null,s[r]&&(s={...s},i.parentId=s[r],delete s[r]),i.set(s,io,e,!1,t,void 0,n)}}cancelBatch(){if(this.batching){const t=this,{batchChanges:n}=t.meta,i={};if(t.batching=null,t.meta.batchChanges=null,t.generation++,!t.$silenceBatch){var e;Object.entries(n).forEach((([e,n])=>{i[e]={oldValue:n,value:t[e]}}));const r={action:"update",record:t,records:[t],changes:i};null===(e=t.stores)||void 0===e||e.forEach((e=>e.trigger("batchedUpdate",{...r}))),t.forEachLinked(((e,t)=>e.trigger("batchedUpdate",{...r,record:t,records:[t]})))}t.$silenceBatch&&t.$silenceBatch--}}triggerBeforeUpdate(e){var t;return!(null!==(t=this.stores)&&void 0!==t&&t.some((t=>!1===t.trigger("beforeUpdate",{record:this,changes:e}))))}copy(e=null,t){const n=this,i=U.clone(n.data),r=n.constructor.idField,s=U.isObject(t)?t.deep:t;let o;if(e&&"object"==typeof e?(o=e[r],Object.assign(i,e)):o=e,s&&n.children?i.children=n.children.map((n=>n.copy(!1!==e&&void 0,t))):(delete i.children,delete i.expanded),n.$meta.fields.initable.length>0){const e=n.toJSON();for(const t of n.$meta.fields.initable)i[t.name]=e[t.name]}!1!==e&&(i[r]=o||n.generateId(n.firstStore));const a=new n.constructor(i,null,null,!1,!0);return a.originalInternalId=n.internalId,a.copyOf=n,a}copyData(e,t,n){const i={},r=this.skipCopyFields||{};e.allFields.forEach((({name:n})=>{n===e.constructor.idField||n in r||(i[n]=t?e.get(n):e.getValue(n))})),this.set(i,null,n)}remove(e=!1){const t=this,{parent:n,stores:i}=t;if(n)n.removeChild(t,!1,e,{unfiltered:!0});else if(null!=i&&i.length&&!t.isSpecialRow){i.slice().forEach((n=>n.remove(t,e,!1,!0)))}}beforeRemove(e,t){return super.beforeRemove(e,t)}get isValid(){return!0}get firstStore(){var e;return null===(e=this.stores)||void 0===e?void 0:e[0]}joinStore(e){const t=this;var n,i;t.stores&&t.stores.includes(e)||(super.joinStore(e),e.register(t),t.stores?t.stores.push(e):t.stores=[e],t.unjoinedStores&&t.unjoinedStores.includes(e)&&t.unjoinedStores.splice(t.unjoinedStores.indexOf(e),1),(null===(n=t.children)||void 0===n?void 0:n.length)&&t.children.forEach((t=>t.joinStore(e))),t.constructor.exposedRelations&&t.initRelations(),!e.tree||t.isRoot||null!==(i=e.stm)&&void 0!==i&&i.isRestoring||(t.instanceMeta(e.id).collapsed=!t.expanded))}unjoinStore(e,t=!1){const n=this,{stores:i}=n;var r,s,o;null!=i&&i.includes(e)&&(e.isDestroying||(e.unregister(n),n.unjoinedStores?n.unjoinedStores.push(e):n.unjoinedStores=[e]),null===(r=n.unfilteredChildren||n.children)||void 0===r||null===(s=r.forEach)||void 0===s||s.call(r,(n=>n.unjoinStore(e,t))),i.splice(i.indexOf(e),1),null===(o=super.unjoinStore)||void 0===o||o.call(this,e,t),e.uncacheRelatedRecord(n),n.meta.map&&!e.stm&&delete n.meta.map[e.id])}isPartOfStore(e){var t;return e?e.includes(this):(null===(t=this.stores)||void 0===t?void 0:t.length)>0}get isRemoved(){return!this.isPartOfStore()}isEditable(e){const t=this.getFieldDefinition(e);return(null==t||!t.calculated)&&(this.readOnly?"readOnly"===e:!!t||void 0)}instanceMeta(e){var t;const{meta:n}=this,i=e.id||e;return(null===(t=n.map)||void 0===t?void 0:t[i])||this.setInstanceMeta(i,{})}setInstanceMeta(e,t){const{meta:n}=this,i=e.id||e;return n.map||(n.map={}),n.map[i]=t}get isGroupHeader(){return"groupRowFor"in this.meta}get isGroupFooter(){return"groupFooterFor"in this.meta}get isSpecialRow(){var e;return Boolean(null===(e=this.meta)||void 0===e?void 0:e.specialRow)}get $original(){return this.isLinked?this.proxyMeta.originalRecord:this}static get nonPersistableFields(){const e=this;return e._nonPersistableFields||(e._nonPersistableFields={},e.allFields.forEach((t=>{t.persist&&!t.calculated||(e._nonPersistableFields[t.name]=1)}))),e._nonPersistableFields}static get alwaysWriteFields(){const e=this;return e._alwaysWriteFields||(e._alwaysWriteFields=e.allFields.filter((e=>e.alwaysWrite))),e._alwaysWriteFields}get domId(){return"string"==typeof this.id?this.id.replace(/[ .]/g,"-"):this.id}static toJavaScriptValue(e){const{names:t}=this.$meta;return`class ${t[t.length-2]} extends ${t[t.length-3]} { static fields = ${V.toJavaScriptValue(this.fields,e)}; }`}getCurrentConfig(e){const{data:t,children:n}=this,{defaultValues:i,applyConfigs:r}=this.constructor,s=r?super.getCurrentConfig(e):{};if(s){for(const n of this.fields)if(n.persist){const r=U.getPath(t,n.dataSource);null==r||n.isEqual(r,i[n.name])||U.setPath(s,n.dataSource,tt.processConfigValue(r,e))}if(n)if(Array.isArray(n)){s.children=[];for(const t of n)s.children.push(t.getCurrentConfig(e))}else s.children=n;this.hasGeneratedId&&delete s.id,delete s.parentId,delete s.parentIndex}return s}}lo._idField="id",lo._internalIdCounter=1,lo._assignedIdField=!1,lo.exposeProperties(),lo._$name="Model";class co{static preWalk(e,t,n){const i=[e];let r,s;for(;i.length;)r=i.pop(),n(r),s=t(r),s&&i.push.apply(i,s.slice().reverse())}static walkWhile(e,t,n){const i=Array.isArray(e)?e.slice():[e];let r,s;for(;i.length;){if(r=i.pop(),!n(r))return!1;if(s=t(r),Array.isArray(s))for(let e=0;e<s.length;e++)i.push(s[e])}return!0}static preWalkWithParent(e,t,n){const i=[{node:e,parent:null}];for(;i.length;){const{parent:e,node:r}=i.pop();n(e,r);const s=t(r);if(Array.isArray(s))for(let e=s.length-1;e>=0;e--)i.push({node:s[e],parent:r})}}static preWalkUnordered(e,t,n){const i=[e];let r,s;for(;i.length;)r=i.pop(),n(r),s=t(r),s&&i.push.apply(i,s)}static postWalk(e,t,n){const i=new Map,r=[e];let s,o;for(;r.length;)if(s=r[r.length-1],i.has(s))n(s),r.pop();else{if(o=t(s),o)for(let e=o.length-1;e>=0;e--)r.push(o[e]);i.set(s,s)}}static prePostWalk(e,t,n,i){const r=new Map,s=[e];let o,a;for(;s.length;)if(o=s[s.length-1],r.has(o))i(o),s.pop();else{if(n(o),a=t(o),a)for(let e=a.length-1;e>=0;e--)s.push(a[e]);r.set(o,o)}}}co._$name="WalkHelper";const uo=Object.hasOwn||((e,t)=>Object.prototype.hasOwnProperty.call(e,t));let ho=null;class go{constructor(e){this.formatter=e}format(e){return this.formatter.defaultFormat(e)}parse(e,t){return this.formatter.defaultParse(e,t)}resolvedOptions(){return null}}class mo{static standardOptions=Object.freeze([]);static get(e){if(null==e)return this.NULL;if(e instanceof this)return e;const t="string"==typeof e?e:JSON.stringify(e),n=this.cache;let i=n.get(t);return i||(ho=t,i=new this(e),n.set(t,i)),i}static get cache(){return uo(this,"_cache")&&this._cache||(this._cache=new Map)}static get NULL(){return uo(this,"_null")?this._null:this._null=new this(null)}constructor(e){const t=this,{standardOptions:n}=t.constructor;if(t.cacheKey=ho,ho=null,t.initialize(),null===e)t.formatter=new go(t);else{t.configure(e);for(const[e,i]of Object.entries(t.resolvedOptions()))null!=i&&n.includes(e)&&(t[e]=i)}}get parser(){return e=this,t=new this.constructor.Parser(this),Object.defineProperty(e,"parser",{value:t}),t;var e,t}defaultFormat(e){return null==e?e:String(e)}defaultParse(e){return e}format(e){return null==e?e:this.formatter.format(e)}parse(e,t){return null==e?e:this.parser.parse(e,t)}parseStrict(e){return this.parse(e,!0)}resolvedOptions(){return this.formatter.resolvedOptions()}}mo._$name="Formatter";const po=V.escapeRegExp,fo=/[\d+-]/g,vo=(e,t)=>new Intl.NumberFormat(e||void 0,t),yo=/^(?:([$])\s*)?(?:(\d+)>)?\d+(,\d+)?(?:\.((\d*)(?:#*)|[*]))?(?:\s*([%])?)?$/;class bo extends mo{static $name="NumberFormat";static decimalSeparator;static groupSeparator;decimalSeparator;groupSeparator;static standardOptions=["currency","currencyDisplay","locale","maximumFractionDigits","minimumFractionDigits","minimumIntegerDigits","maximumSignificantDigits","minimumSignificantDigits","style","useGrouping"];initialize(){this._as={},this.is={decimal:!1,currency:!1,percent:!1,null:!0,from:null}}get truncator(){const e=this.maximumFractionDigits+(this.is.percent?2:1),t=Math.min(20,e);return this.as({style:"decimal",maximumFractionDigits:t,minimumFractionDigits:t},"truncator")}configure(e){const{decimalSeparator:t,groupSeparator:n}=bo;Object.assign(this,{...t?{decimalSeparator:t}:{},...n?{groupSeparator:n}:{}}),"string"!=typeof e?Object.assign(this,e):this.template=e;const i=this,r={},s=i.locale?ir.locales[i.locale]||Object.values(ir.locales).find((e=>e.localeCode===i.locale)):ir.locale,o=null==s?void 0:s.NumberFormat,{template:a}=i,{standardOptions:l}=i.constructor;if(o)for(const e in o)null==i[e]&&"function"!=typeof o[e]&&(i[e]=o[e]);if(a){const e=yo.exec(a),t=e[2],n=e[4];i.useGrouping=Boolean(e[3]),i.style=e[1]?"currency":e[6]?"percent":"decimal",t&&(i.integer=+t),"*"===n?i.fraction=[0,20]:null!=n&&(i.fraction=[e[5].length,n.length])}i._minMax("fraction",!0,!0),i._minMax("integer",!0,!1),i._minMax("significant",!1,!0);for(const e of l)null!=i[e]&&(r[e]=i[e]);if(i.is.from=i.from&&i.from.is,i.is[i.style]=!(i.is.null=!1),i.formatter=vo(i.locale,r),i.decimalSeparator||i.groupSeparator){const{groupSeparator:e,decimalSeparator:t}=i.getLocaleSeparators();i.separatorRegex=new RegExp(`[${e}${t}]`,"g"),i.separatorReplace={[e]:i.groupSeparator??e,[t]:i.decimalSeparator??t}}}as(e,t=null){const n=this.resolvedOptions()||{template:"9.*"},i=this._as;let r=t&&i[t];return r||("string"==typeof e?n.style=e:Object.assign(n,e),n.from=this,r=new bo(n)),t&&(i[t]=r),r}defaultParse(e,t){return null==e?e:t?Number(e):parseFloat(e)}getLocaleSeparators(){const e=this.formatter.formatToParts(1234567.89);let t=".",n=",";for(const i of e)"decimal"===i.type&&(t=i.value),"group"===i.type&&(n=i.value);return{decimalSeparator:t,groupSeparator:n}}format(e){const t=this,{separatorRegex:n,separatorReplace:i}=t;if("string"==typeof e){const n=Number(e);e=isNaN(n)?t.parse(e):n}return e=super.format(e),n&&(e=String(e).replace(n,(e=>i[e]))),e}round(e){return this.parse(this.format(e))}truncate(e){const t=this,n=t.maximumFractionDigits+(t.is.percent?2:0),{truncator:i}=t;let r,s=t.parse(e);return i&&(s=i.format(s),r=s.indexOf(i.parser.decimal),r>-1&&s.length-r-1>n&&(s=s.slice(0,r+n+1)),s=i.parse(s)),s}resolvedOptions(){const e=super.resolvedOptions();for(const t in e)void 0===e[t]&&(e[t]=this[t]);return e}_minMax(e,t,n){const i=this,r=i[e];if(null!=r){const s=V.capitalize(e),o=`maximum${s}Digits`,a=`minimum${s}Digits`;"number"==typeof r?(t&&(i[a]=r),n&&(i[o]=r)):(i[a]=r[0],i[o]=r[1])}}}bo.Parser=class{constructor(e){const t=this,n=e.locale,i=vo(n,{maximumFractionDigits:3}),r=e.is.currency?t._decodeStyle(n,{style:"currency",currency:e.currency,currencyDisplay:e.currencyDisplay}):null,s=e.is.percent?t._decodeStyle(n,{style:"percent"}):null,o=i.format(1.2).replace(fo,"")[0],a=i.format(1e9).replace(fo,"")[0]||"";Object.assign(t,{currency:r,decimal:o,formatter:e,grouper:a,percent:s}),t.decimal=o,t.decimalRe=po(o,"g"),t.grouper=a,t.stripRe=new RegExp(`(?:\\s+|${po(a)})`+(r?`|(?:${po(r.text)})`:"")+(s?`|(?:${po(s.text)})`:""),"g")}decimalPlaces(e){const t=(e=e.replace(this.stripRe,"")).indexOf(this.decimal)+1;return t&&e.length-t}parse(e,t){return"string"==typeof e&&(e=e.replace(this.stripRe,"").replace(this.decimalRe,".").replace("−","-"),e=t?Number(e):parseFloat(e),this.formatter.is.percent&&(e/=100)),e}_decodeStyle(e,t){const n=vo(e,t),i=vo(e,Object.assign(n.resolvedOptions(),{style:"decimal"})),r=n.format(0),s=i.format(0);return{suffix:r.startsWith(s),text:r.replace(s,"").trim()}}},Object.assign(bo.prototype,{currency:null,currencyDisplay:"symbol",fraction:null,from:null,integer:null,locale:null,maximumFractionDigits:null,minimumFractionDigits:null,minimumIntegerDigits:null,maximumSignificantDigits:null,minimumSignificantDigits:null,significant:null,style:"decimal",template:null,useGrouping:!0}),mo.number=(e,t)=>bo.get(e).format(t),ir.ion({locale:()=>bo.cache.clear()}),bo._$name="NumberFormat";class Co{constructor(e,t){"number"==typeof e||null===e?(this._magnitude=e,this._unit=t):("string"==typeof e&&Object.assign(this,us.parseDuration(e)),"object"==typeof e&&(this.magnitude=e.magnitude,this.unit=e.unit))}static from(e){return null==e?null:e.isDuration?e:new Co(e)}negate(){return new Co(-this.magnitude,this.unit)}get magnitude(){return this._magnitude}set magnitude(e){this._magnitude="number"==typeof e&&e}get unit(){return this._unit}set unit(e){this._unit=us.parseTimeUnit(e)}get isValid(){return null!=this._magnitude&&Boolean(us.normalizeUnit(this._unit))}get milliseconds(){return this.isValid?Math.round(us.asMilliseconds(this._magnitude,this._unit)):0}isEqual(e){return Boolean(e)&&null!=this._magnitude&&null!=e._magnitude&&this.milliseconds===e.milliseconds}toString(e,t=10){const n=this,i=e?"getShortNameOfUnit":"getLocalizedNameOfUnit",r=e?"":" ";return n.isValid?`${bo.get("9."+"#".repeat(t)).format(n._magnitude)}${r}${us[i](n._unit,1!==Math.abs(n._magnitude))}`:""}toJSON(){return this.toString()}valueOf(){return this.milliseconds}add(e){return new Co({unit:this.unit,magnitude:us.as(this.unit,this.milliseconds+new Co({magnitude:e.magnitude,unit:e.unit||this.unit}).milliseconds)})}diff(e){return new Co({unit:this.unit,magnitude:us.as(this.unit,this.milliseconds-e.milliseconds)})}}Co._$name="Duration";const So=(e,t)=>null==e?void 0:e[t],wo=/^is(this|next|last)(week|month|year)$/i,Do=["isToday","isTomorrow","isYesterday","isThisWeek","isNextWeek","isLastWeek","isThisMonth","isNextMonth","isLastMonth","isThisYear","isNextYear","isLastYear","isYearToDate"];class Eo extends(tt.mixin(on)){static $name="CollectionFilter";static configurable={value:null,operator:null,filterBy:null,caseSensitive:!0,id:null,type:null,internal:null,disabled:!1,property:null,children:null};construct(e){"function"==typeof e&&(e={filterBy:e}),e.type?"date"===e.type&&null!=e.value?Array.isArray(e.value)?e.value=e.value.map((e=>e instanceof Date?e:new Date(e))):e.value=new Date(e.value):"duration"===e.type&&null!=e.value&&(Array.isArray(e.value)?e.value=e.value.map((e=>e.isDuration?e:new Co(e))):e.value=new Co(e.value)):us.isDate(e.value)||Array.isArray(e.value)&&e.value.every(us.isDate)?e.type="date":e.value instanceof Co&&(e.type="duration"),super.construct(e)}changeChildren(e){if(e){const{operator:t}=this;if("and"!==t&&"or"!==t)throw new Error(`CollectionFilter children can only be used with 'and' or 'or' operators, not '${t}'`);e=e.map((e=>e.isCollectionFilter?e:new Eo(e)))}return e}get id(){return this._id||(this.internal?this._id=Eo.generateId(`b-internal-${this.property}-filter-`):this._id=this.property&&`${this.property}-${this.operator}`||Eo.generateId("b-filter-")),this._id}set id(e){this._id=e}onChange(e){var t;const n=this;n.isConfiguring||null===(t=n.owner)||void 0===t||!t.onFilterChanged||n.owner.isConfiguring||n.owner.onFilterChanged(n,e)}get filterBy(){return this._filterBy||this.defaultFilterBy}defaultFilterBy(e){var t;const n=this;let i;return n.children?n[n.operator](e):(i=e.isModel?e.getValue(n.property):(null===(t=n._propertyItems)||void 0===t?void 0:t.length)>1?n._propertyItems.reduce(So,e):e[n.property],n[n.operator](n.convert(i)))}updateProperty(e){this._propertyItems=e.split("."),this.onChange("property")}updateValue(e){const t=this;Array.isArray(e)&&({date:1,duration:1}[t.type]||e.length>0&&"string"==typeof e[0])?t._filterValue=e.map((e=>t.convert(e))):!t.caseSensitive&&Array.isArray(e)&&e.length>0&&"string"==typeof e[0]?t._filterValue=e.map((e=>null==e?void 0:e.toLowerCase())):t.caseSensitive||"string"!=typeof e?t._filterValue=t.convert(e):t._filterValue=e.toLowerCase(),t.updateInternalFilterValue(),t.onChange("value")}get filterValue(){return this._filterValue}updateInternalFilterValue(){const e=this,{value:t}=e;Array.isArray(t)&&({date:1,duration:1}[e.type]||t.length>0&&"string"==typeof t[0])?e._filterValue=t.map((t=>e.convert(t))):!e._caseSensitive&&Array.isArray(t)&&t.length>0&&"string"==typeof t[0]?e._filterValue=t.map((e=>null==e?void 0:e.toLowerCase())):e._caseSensitive||"string"!=typeof t?e._filterValue=e.convert(t):e._filterValue=t.toLowerCase()}updateOperator(){this.onChange("operator")}get operator(){const e=this;return e._operator?e._operator:Array.isArray(e.filterValue)?"isIncludedIn":"string"==typeof e.filterValue?"*":"="}updateCaseSensitive(){this.updateInternalFilterValue()}convert(e){const t=this;var n;"sameTime"===t.operator||"notSameTime"===t.operator||"string"==typeof t.filterValue&&e instanceof Date||("sameDay"!==t.operator&&"notSameDay"!==t.operator||(e=us.clearTime(e)),e=(null===(n=e)||void 0===n?void 0:n.valueOf())??e);return e=t.caseSensitive||"string"!=typeof e?e:e.toLowerCase()}filter(e){return this.filterBy(e)}startsWith(e){return String(e).startsWith(this.filterValue)}endsWith(e){return String(e).endsWith(this.filterValue)}isIncludedIn(e){return 0===this.filterValue.length||this.filterValue.includes(e)}isNotIncludedIn(e){return!this.isIncludedIn(e)}includes(e){return 0===this.filterValue.length||String(e).includes(this.filterValue)}doesNotInclude(e){return!this.includes(e)}sameTime(e){return null!=e&&us.isSameTime(e,this.filterValue)}notSameTime(e){return!this.sameTime(e)}sameDay(e){return e===this.filterValue}notSameDay(e){return e!==this.filterValue}"="(e){return U.isEqual(e,this.filterValue)}"!="(e){return!U.isEqual(e,this.filterValue)}">"(e){return U.isMoreThan(e,this.filterValue)}">="(e){return U.isMoreThan(e,this.filterValue)||U.isEqual(e,this.filterValue)}"<"(e){return U.isLessThan(e,this.filterValue)}"<="(e){return U.isLessThan(e,this.filterValue)||U.isEqual(e,this.filterValue)}"*"(e){return U.isPartial(e,this.filterValue)}between(e){const[t,n]=this._filterValue;return(U.isMoreThan(e,t)||U.isEqual(e,t))&&(U.isLessThan(e,n)||U.isEqual(e,n))}notBetween(e){return!this.between(e)}betweenLesser(e){const[t,n]=this._filterValue;return e>=t&&e<n}empty(e){return null==e||0===String(e).length}notEmpty(e){return!this.empty(e)}isToday(e){return this.betweenLesser(e)}isTomorrow(e){return this.betweenLesser(e)}isYesterday(e){return this.betweenLesser(e)}isThisWeek(e){return this.betweenLesser(e)}isNextWeek(e){return this.betweenLesser(e)}isLastWeek(e){return this.betweenLesser(e)}isThisMonth(e){return this.betweenLesser(e)}isNextMonth(e){return this.betweenLesser(e)}isLastMonth(e){return this.betweenLesser(e)}isThisYear(e){return this.betweenLesser(e)}isNextYear(e){return this.betweenLesser(e)}isLastYear(e){return this.betweenLesser(e)}isYearToDate(e){return this.between(e)}isTrue(e){return!0===e}isFalse(e){return!1===e}or(e){return this.children.some((t=>t.filter(e)))}and(e){return this.children.every((t=>t.filter(e)))}getState(){const{caseSensitive:e,disabled:t,id:n,internal:i,operator:r,property:s,type:o,value:a,columnOwned:l,filterBy:c,children:d}=this,u={caseSensitive:e,disabled:t,id:n,internal:i,operator:r,property:s,type:o,value:a,columnOwned:l,filterBy:c,children:null!=d&&d.length?d.map((e=>e.getState())):void 0};return U.cleanupProperties(u,!0),u.filterBy===this.defaultFilterBy&&delete u.filterBy,u}toJSON(){if(!this._filterBy){const{operator:e,children:t,value:n,caseSensitive:i}=this;return this.children?{operator:e,children:t}:{field:this.property,operator:e,value:n,caseSensitive:i}}}setRelativeDateValues(){this._filterValue=Eo.getRelativeDateRange(this._operator).map((e=>e.valueOf()))}get isNoOp(){var e;return("includes"===this.operator||"isIncludedIn"===this.operator)&&0===(null===(e=this.filterValue)||void 0===e?void 0:e.length)}static getRelativeDateRange(e,t=new Date){let n,i,r,s,o,a,l;switch(e){case"isYearToDate":return[us.floor(t,"1 year"),t];case"isToday":return n=us.floor(t,"1 day"),[n,us.add(n,1,"day")];case"isYesterday":return n=us.floor(t,"1 day"),[us.add(n,-1,"day"),n];case"isTomorrow":return i=us.getStartOfNextDay(t),[i,us.add(i,1,"day")];case"isThisWeek":case"isNextWeek":case"isLastWeek":case"isThisMonth":case"isNextMonth":case"isLastMonth":case"isThisYear":case"isNextYear":case"isLastYear":if(r=e.toLowerCase().match(wo),!r)throw new Error(`Unrecognized relative date expression: ${e}`);return[,a,l]=r,s=`1 ${l}`,o=us.floor(t,s),"next"===a?o=us.add(o,1,l):"last"===a&&(o=us.add(o,-1,l)),[o,us.add(o,1,l)]}}static generateFiltersFunction(e){if(!e||!e.length&&!e.count)return te.returnTrue;for(const t of e)"date"===t.type&&Do.includes(t._operator)&&t.setRelativeDateValues();return function(t){let n=!0;for(const i of e)if(i.disabled||(n=i.filter(t)),!n)break;return n}}}Eo._$name="CollectionFilter";const xo=U.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null));class Ro{static generateId(e="generatedId"){return e+(xo[e]=(xo[e]||0)+1)}static reset(e){xo[e]=0}}Ro._$name="IdHelper";class To extends tt{static configurable={property:null,caseSensitive:!0,direction:"ASC",sortFn:null,convert:null,id:null,useLocaleSort:null};construct(e){"function"==typeof e&&(e={sortFn:e}),super.construct(e)}get id(){return this._id||(this._id=this.property||Ro.generateId("b-sorter"))}get sortFn(){return this._sortFn||this.defaultSortFn}defaultSortFn(e,t){const{convert:n,property:i,useLocaleSort:r,caseSensitive:s}=this,o="desc"===this.direction.toLowerCase()?-1:1;if(e=e[i],t=t[i],n&&(e=n(e),t=n(t)),s||("string"==typeof e&&(e=e.toLowerCase()),"string"==typeof t&&(t=t.toLowerCase())),r&&null!=e&&null!=t&&"string"==typeof e){if(!0===r)return e.localeCompare(t);if("string"==typeof r)return e.localeCompare(t,r);if("object"==typeof r)return e.localeCompare(t,r.locale,r)}return(e>t?1:e<t?-1:0)*o}static generateSortFunction(e,t){const n=e.isCollection?e.values:e,i=n.length;return(e,r)=>{let s,o,a;for(o=0;o<i;++o)if(a=n[o],s=a.sortFn(e,r,a.direction),s)return s;return t?t(e,r):0}}}To._$name="CollectionSorter";const Mo=()=>0,Io=(e,t)=>t-e,ko=Symbol("filteredIndicesProperty"),Fo=Object.freeze([]),Ao=Object.freeze({action:"sort",added:Fo,removed:Fo,replaced:Fo}),Po=Object.freeze({action:"filter",added:Fo,removed:Fo,replaced:Fo}),Lo={string:1,number:1};function Oo(e,t,n,i){if(!1!==t.unique)t.set(n,e),i&&t.count++;else{let i=t.get(n);i||(i=new Set,t.set(n,i)),i.add(e)}}function $o(e,t,n,i,r=!1){for(let s=0;s<e.length;s++){const o=e[s];if(o)for(let e=0;e<i;e++){const i=n[e],s=o[i],a=t[i];void 0!==s&&Oo(o,a,s,!r&&a.onDuplicate)}}}class _o extends(tt.mixin(dt)){_sortFunction=null;_addedValues=null;static get configurable(){return{idProperty:"id",extraKeys:null,autoFilter:!0,sorters:{$config:["lazy"],value:[]}}}get isCollection(){return!0}construct(e){this.generation=0,this._values=[],super.construct(e)}doDestroy(){var e;super.doDestroy();const t=this;t._values.length=0,t.isFiltered&&(t._filteredValues.length=0,t.filters.destroy()),null===(e=t._sorters)||void 0===e||e.destroy()}clear(){const e=this,t=e._values.filter((e=>e));e.totalCount&&(e._values.length=0,e._filteredValues&&(e._filteredValues.length=0),e._indicesInvalid=!0,e.generation++,e.trigger("change",{action:"clear",removed:t}))}equals(e,t){if(e.isCollection&&(e=e.values),e.length===this.count){let{values:n}=this;return t&&(e=e.map(t),n=n.map(t)),rt.delta(e,n).inBoth.length===this.count}return!1}replaceValues({values:e,filteredValues:t,silent:n=!1,isNewDataset:i=!1}){const r=this;let s,o;if(r.isFiltered&&!i){Boolean(t)?e&&(s=r._values,r._values=e.slice()):(t=e.slice(),e=null),o=r._filteredValues,r._filteredValues=t.slice()}else s=r._values,r._values=e.slice(),t=null,r.isFiltered&&i&&r.autoFilter?(r._filterFunction=null,r._filteredValues=r._values.filter(r.filterFunction)):r._filteredValues&&(r._filteredValues.length=0);r._indicesInvalid=!0,r._addedValues=void 0,r.generation++,n||r.trigger("change",{action:"replaceValues",replacedValues:s,replacedFilteredValues:o,values:e,filteredValues:t})}set values(e){this.invalidateIndices(),this.splice(0,this._values.length,e)}get values(){return this.isFiltered?this._filteredValues:this._values}get filteredValues(){return this._filteredValues}[Symbol.iterator](){return this.values[Symbol.iterator]()}forEach(e,t=!1){(this.isFiltered&&!t?this._filteredValues:this._values).forEach(e)}map(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).map(e)}reduce(e,t=!1,n=[]){return(this.isFiltered&&!t?this._filteredValues:this._values).reduce(e,n)}find(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).find(e)}get first(){return this.values[0]}get last(){return this.values[this.count-1]}get allValues(){return this._values}get addedValues(){return this._addedValues}match(e,t=!0){const n=this,{_values:i}=n,r=[];return n.forEach((s=>{const o=e.get(s.id,!0);if(o){const e=n.indexOf(s,!0),t=i[e];i[e]=o,n.removeFromIndices(t),n.addToIndices(o)}else t&&r.push(s)})),r.length&&n.remove(r),n.isFiltered&&(n._filteredValues=n._values.filter(n.filterFunction)),r}add(...e){1===e.length?this.splice(this._values.length,null,...e):this.splice(this._values.length,null,e)}remove(...e){1===e.length?this.splice(0,...e):this.splice(0,e)}move(e,t){for(e=rt.asArray(e);e.length&&e[0]===t;)e.shift();if(!e.length)return;const n=this,{_values:i}=n,r=n.indexOf(e[0],!0);if(1===e.length&&i[r+1]===t)return;n.suspendEvents(),n.remove(e),n.resumeEvents();const s=t?n.indexOf(t,!0):i.length;if(-1===s)throw new Error("Collection move beforeItem parameter must be present in Collection");return i.splice(s,0,...e),n._indicesInvalid=1,n.trigger("change",{action:"move",items:e,from:r,to:s}),s}splice(e=0,t,...n){var i;const r=this,s=r.idProperty,o=r._values,a={},l=[],c=r.totalCount;let d,u,h=[];if(1===(null===(i=n)||void 0===i?void 0:i.length)&&Array.isArray(n[0])&&(n=n[0]),!1!==r.trigger("beforeSplice",{index:e,toRemove:t,toAdd:n})){if(n)if(c&&n.length){const e=r.indices[s];d=[];for(let t=0;t<n.length;t++){const i=n[t],r=i[s],c=e.get(r),u=c?o.indexOf(c):-1;a[r]=!0,-1!==u?o[u]!==i&&(l.push([o[u],i]),o[u]=i):d.push(i)}}else d=n;if(t){if("number"==typeof t){var g;if(t=Math.min(t,o.length-e),null!==(g=n)&&void 0!==g&&g.length)for(let n=e;t;--t){a[o[n][s]]?(e++,n++):(h.push(o[n]),o.splice(n,1),u=!0)}else h=o.slice(e,e+t),o.splice(e,t),u=!0}else{let e,n=0===d.length;const i=(t=rt.asArray(t)).reduce(((t,i)=>{const s="number"==typeof i,o=s?i:r.indexOf(i,!0);return n&&(null!=e&&o!==e+1||s)&&(n=!1),o>=0&&o<c&&t.push(o),e=o,t}),[]).sort(Io);if(n)i.length&&(h.push.apply(h,t),o.splice(i[i.length-1],i.length),u=!0);else for(let e=0;e<i.length;e++){const t=i[e];if(-1!==t){a[o[t][s]]||(h.unshift(o[t]),o.splice(t,1),u=!0)}}}h.length&&!r._indicesInvalid&&h.forEach(r.removeFromIndices,r)}if(d.length){rt.chunkedInsert(o,Math.min(e,o.length),d),u=!0,r._indicesInvalid||d.forEach(r.addToIndices,r),r._addedValues||(r._addedValues=new Set);for(const e of d)r._addedValues.add(e)}if(h.length&&r._addedValues)for(const e of h)r._addedValues.delete(e);l.length&&!r._indicesInvalid&&l.forEach((e=>{r.removeFromIndices(e[0]),r.addToIndices(e[1])})),u||l.length?(r.isSorted?r.onSortersChanged():r.isFiltered&&(r.autoFilter?r.onFiltersChanged({action:"splice",oldCount:1}):r._filteredValues.splice(Math.min(e,r._filteredValues.length),0,...d)),r.generation++,r.trigger("change",{action:"splice",removed:h,added:d,replaced:l,oldCount:c})):r.trigger("noChange",{index:e,toRemove:t,toAdd:n})}}changeId(e,t){const n=this,{idProperty:i}=n,r=Lo[typeof e]?e:e[i],s=n.get(r);if(s){const o=n.get(t);if(o&&s!==o)throw new Error(`Attempt to set item ${r} to already existing member's id ${t}`);n.removeIndexEntry(e,i,r),n.addIndexEntry(e,i,t),s[i]=t}}get(e,t=!1){return this.getBy(this.idProperty,e,t)}getAt(e,t=!1){return this.isFiltered&&!t?this._filteredValues[e]:this._values[e]}getBy(e,t,n=!1){return this.findItem(e,t,this.isFiltered&&n)}get count(){return this.values.length}get totalCount(){return this._values.length}updateIdProperty(e){this.addIndex({property:e,unique:!0})}changeSorters(e){return new _o({values:rt.asArray(e),internalListeners:{change:"onSortersChanged",thisObj:this}})}addSorter(e){const t=e instanceof To?e:new To(e);return this.sorters.add(t),t}get isSorted(){var e;return Boolean(null===(e=this._sorters)||void 0===e?void 0:e.count)}onSortersChanged(){const e=this;e._sortFunction=null,e._addedValues=null,e._values.sort(e.sortFunction),e.trigger("change",Ao)}get sortFunction(){return this._sortFunction||(this.isSorted?this._sortFunction=To.generateSortFunction(this.sorters.values):this._sortFunction=Mo),this._sortFunction}get filters(){return this._filters||(this._filters=new _o({internalListeners:{change:"onFiltersChanged",thisObj:this}})),this._filters}addFilter(e){const t=e instanceof Eo?e:new Eo(e);return this.filters.add(t),t}removeFilter(e){const{filters:t}=this;e.isCollectionFilter||(e=t.get(e)),t.remove(e)}clearFilters(){this.filters.clear()}get isFiltered(){return Boolean(this._filters&&this._filters.count)}onFiltersChanged({action:e,removed:t,oldCount:n}){const i=this,r=n||"clear"===e&&t.length?i._filteredValues:i._values;i._filterFunction=null,i._filteredValues=i._values.filter(i.filterFunction),i._indicesInvalid=!0;const{toAdd:s,toRemove:o}=rt.delta(i._filteredValues,r,!0);i.trigger("change",{...Po,added:s,removed:o})}get filterFunction(){return this._filterFunction||(this.isFiltered?this._filterFunction=Eo.generateFiltersFunction(this.filters.values):this._filterFunction=te.returnTrue),this._filterFunction}changeExtraKeys(e){return rt.asArray(e).map((e=>"string"==typeof e?{property:e,unique:!0}:e))}updateExtraKeys(e){for(let t=0;t<e.length;t++)this.addIndex(e[t])}addIndex(e){const t=this;e&&((t._indices||(t._indices={}))[e.property]=new Map,Object.assign(t._indices[e.property],e),t.invalidateIndices(),e.dependentOn&&(t.hasCompositeIndex=!0))}findIndex(e,t,n=!1){const i=this.findItem(e,t,n);if(!i)return-1;return(this.isFiltered&&!n?this._filteredValues:this._values).indexOf(i)}findItem(e,t,n=!1){const i=this,{isFiltered:r}=i,s=r&&!n?i.indices[ko][e]:i.indices[e];if(s){const e=s.get(t)??("string"==typeof t&&t.length&&!isNaN(t)&&s.get(Number(t))||null);if(null!=e)return e}else{const s=r&&!n?i._filteredValues:i._values,o=s.length;for(let n=0;n<o;n++){const i=s[n];if(i[e]==t)return i}}return null}removeIndex(e){delete this._indices[e],this.hasCompositeIndex=Object.values(this.indices).some((e=>e.dependentOn))}indexOf(e,t=!1){return this.findIndex(this.idProperty,Lo[typeof e]?e:e[this.idProperty],t)}includes(e,t=!1){return Array.isArray(e)?e.some((e=>this.includes(e))):Boolean(this.findItem(this.idProperty,Lo[typeof e]?e:e[this.idProperty],t))}get indices(){return this._indicesInvalid&&this.rebuildIndices(),this._indices}invalidateIndices(){this._indicesInvalid=!0}rebuildIndices(){const e=this,t=e.isFiltered,n=e._indices||(e._indices={}),i=Object.keys(n),r=i.length,s=e._values;let o,a=!1;t&&(o=n[ko]={});for(let e=0;e<r;e++){const r=n[i[e]];if(r.clear(),r.onDuplicate&&(r.count=0,a=!0),t){let t=o[i[e]];t?t.clear():(t=o[i[e]]=new Map,t.unique=r.unique)}}if($o(s,n,i,r),a)for(let e=0;e<r;e++){const t=n[i[e]];if(t.onDuplicate&&t.count>t.size){const n=new Set;for(let r=0;r<s.length;r++){const o=s[r],a=o[i[e]];n.has(a)&&t.onDuplicate(o,a,t),n.add(a)}}}t&&$o(e._filteredValues,o,i,r,!0),e._indicesInvalid=!1}getIndices(e){const t=[this.indices[e]];return this.isFiltered&&t.push(this.indices[ko][e]),t}addToIndices(e){Object.keys(this.indices).forEach((t=>{this.addIndexEntry(e,t,e[t])}))}removeFromIndices(e){Object.keys(this.indices).forEach((t=>{this.removeIndexEntry(e,t,e[t])}))}removeIndexEntry(e,t,n){this.getIndices(t).forEach((t=>function(e,t,n){!1!==t.unique?t.delete(n):t.has(n)&&(t.get(n).delete(e),t.get(n).size||t.delete(n))}(e,t,n)))}addIndexEntry(e,t,n){this.getIndices(t).forEach((t=>Oo(e,t,n)))}onItemMutation(e,t){const n=this;!n._indicesInvalid&&Object.keys(n.indices).length>1&&Object.keys(t).forEach((i=>{if(n.indices[i]){const{value:r,oldValue:s}=t[i];n.removeIndexEntry(e,i,s),n.addIndexEntry(e,i,r)}if(n.hasCompositeIndex){const s=Object.values(n.indices).find((e=>{var t;return null===(t=e.dependentOn)||void 0===t?void 0:t[i]}));if(s){const i={};for(const n in s.dependentOn){var r;i[n]=(null===(r=t[n])||void 0===r?void 0:r.oldValue)||e[n]}const o=e.buildIndexKey(i);n.removeIndexEntry(e,s.property,o),n.addIndexEntry(e,s.property,e[s.property])}}}))}}_o._$name="Collection";const jo=new WeakMap,Bo=e=>{if(e&&"object"==typeof e){let t=jo.get(e);void 0===t&&(t=Symbol("bscik"),jo.set(e,t)),e=t}return e};class Vo{constructor(e){const t=this;t.generation=0,t.items=new Set,t.idMap={},t.idProperty="id",e&&(e.idProperty&&(t.idProperty=e.idProperty),e.values&&(t.values=e.values))}get(e){return this.idMap[Bo(e)]}get count(){return this.items.size}add(...e){1===e.length&&Array.isArray(e[0])&&(e=e[0]);const t=this,{items:n,idMap:i,idProperty:r}=t,s=e.length;for(let o=0;o<s;o++){const s=e[o],a=Lo[typeof s]?s:Bo(s[r]),l=i[a];null==l?(i[a]=s,n.add(s),t.generation++):l!==s&&(i[a]=s,n.delete(l),n.add(s))}}at(e){let t,n;for(t of(e<0&&(e+=this.count),this.items))if(!e--){n=t;break}return n}remove(e){e=rt.asArray(e);const{items:t,idMap:n,idProperty:i}=this,r=e.length;for(let s=0;s<r;s++){const r=e[s],o=Lo[typeof r]?r:Bo(r[i]),a=n[o];null!=a&&(t.delete(a),delete n[o],this.generation++)}}clear(){this.items.clear(),this.idMap={},this.generation++}countOf(e){let t,n=0;for(t of this.items)e(t)&&++n;return n}changeId(e,t){const n=this,{idMap:i,idProperty:r}=n,s=Lo[typeof e]?e:Bo(e[r]),o=n.get(s);if(o){const e=n.get(t);if(e&&o!==e)throw new Error(`Attempt to set item ${s} to already existing member's id ${t}`);o[r]=t,delete i[s],i[t]=o}}filter(e,t){const{items:n}=this,i=[];let r=0;return n.forEach((s=>{e.call(t,s,r++,n)&&i.push(s)})),i}includes(e){const t=Lo[typeof e]?e:Bo(e[this.idProperty]);return Boolean(this.idMap[t])}map(e,t){const{items:n}=this,i=new Array(n.size);let r=0;return n.forEach((s=>{i[r]=e.call(t,s,r++,n)})),i}forEach(e,t){return this.items.forEach(e,t)}find(e,t=0){let n,i;for(n of(t<0&&(t+=this.countOf(e)),this.items))if(e(n)&&!t--){i=n;break}return i}[Symbol.iterator](){return this.items[Symbol.iterator]()}indexOf(e,t){let n,i=-1;for(n of this.items)if((!t||t(n))&&(++i,n===e))return i;return-1}get values(){return[...this.items]}set values(e){e=rt.asArray(e),this.clear(),this.add.apply(this,e),this.generation++}get first(){for(const e of this.items)return e;return null}get last(){let e=null;for(const t of this.items)e=t;return e}sort(e){this.values=this.values.sort(e)}some(e,t){return this.values.some(e,t)}}Vo._$name="Bag";class Ho extends Vo{add(...e){return 1===e.length&&Array.isArray(e[0])&&(e=e[0]),super.add(...e.filter((e=>e.isPersistable)))}}Ho._$name="StoreBag";const zo=(e,t)=>{const n=e.meta.modified,i=t.meta.modified;return"parentId"in n&&"parentId"in i&&n.parentId===i.parentId?n.parentIndex-i.parentIndex:0};var No=e=>class extends(e||tt){static $name="StoreCRUD";static configurable={autoCommit:!1};static get properties(){return{isRemoving:!1,suspendCount:0}}remove(e,t=!1){const n=this,{storage:i}=n;if(0===(e=rt.asArray(e).reduce(((e,t)=>((t=n.getById(t))&&e.push(t),e)),[])).length)return e;if(!n.tree&&!t&&!1===n.trigger("beforeRemove",{records:e}))return[];if(n.isRemoving=!0,n.isGrouped){const t=i.count,r=[],s=new Set;for(const t of e){const{groupParent:e}=t.instanceMeta(n);e.meta.collapsed&&r.push(t),rt.remove(e.groupChildren,t),rt.remove(e.unfilteredGroupChildren,t),e.meta.childCount--,s.add(e)}for(const e of s)e.groupChildren.length>0&&n.onModelChange(e,{},{});r.length&&i.trigger("change",{action:"splice",removed:r,added:[],replaced:[],oldCount:t})}else if(n.tree){const r=[],s=new Set,o=e.length>1,a=e[0],l=o?void 0:i.indexOf(a),c=e.reduce(((e,t)=>{const{parent:n}=t;return n&&(e[n.id]||(e[n.id]=[n,[]]),e[n.id][1].push(t)),e}),{}),d=Array.from(Object.values(c));if(!t&&!1===n.trigger("beforeRemove",{records:e,isMove:!1,parent:o?void 0:a.parent}))return n.isRemoving=!1,[];n.suspendAutoCommit(),d.sort(((e,t)=>t[0].childLevel-e[0].childLevel));for(const[e,t]of d){const n=e.removeChild(t,!1,!0,{skipIndexUpdate:!0});rt.chunkedPush(r,n),s.add(e)}for(const e of s)r.includes(e)||(e.updateChildrenIndices(e.children,"parentIndex"),e.unfilteredChildren&&e.updateChildrenIndices(e.unfilteredChildren,"unfilteredIndex"),e.orderedChildren&&e.updateChildrenIndices(e.orderedChildren,"orderedParentIndex"));return t||(n.trigger("remove",{parent:o?void 0:a.parent,index:l,isChild:!0,allRecords:r,isMove:!1,records:e}),n.trigger("change",{action:"remove",records:e})),n.resumeAutoCommit(),n.isRemoving=!1,e}if(0===e.length)return n.isRemoving=!1,e;for(const t of e)t.beforeRemove(e);return t&&n.suspendEvents(),i.remove(e),t&&n.resumeEvents(),n.autoCommit&&n.doAutoCommit(),n.isRemoving=!1,e}clear(e=!1){var t;const n=this,{storage:i}=n;if(n.storage.totalCount||null!==(t=n.rootNode)&&void 0!==t&&null!==(t=t.unfilteredChildren)&&void 0!==t&&t.length){if(!e&&!1===n.trigger("beforeRemove",{records:i.allValues,removingAll:!0}))return null;if(n.rootNode)if(n.isChained&&!n.isChainedTree){const e=n.getAllDataRecords();for(let t,i=e.length-1;i>=0;i--)t=e[i],t&&!t.isDestroyed&&t.unjoinStore(n)}else n.rootNode.clearChildren(e);else if(e){const e=n.registeredRecords;for(let t,i=e.length-1;i>=0;i--)t=e[i],t&&!t.isDestroyed&&t.unjoinStore(n)}e&&(n.removed.clear(),i.suspendEvents()),i.clear(),e&&i.resumeEvents(),n.added.clear(),n.modified.clear()}}removeAll(e=!1){const t=this,n=t.storage;let i;if(t.isRemoving=!0,e){n.suspendEvents();const e=t.registeredRecords;for(let n,i=e.length-1;i>=0;i--)n=e[i],!n||n.isDestroyed||n.isRoot||n.unjoinStore(t)}return i=t.tree?!1!==t.rootNode.clear():null!==t.clear(),e&&n.resumeEvents(),t.isRemoving=!1,i}add(e,t=!1,n={}){var i;const r=this,{storage:s}=r;if(null===(i=e=rt.asArray(e))||void 0===i||!i.length)return;if(r.tree=r.tree||Boolean(r.autoTree&&e[0].children),r.tree){const i=new Map,s=r.modelClass.getFieldDataSource("parentIndex"),o=r.modelClass.getFieldDataSource("orderedParentIndex"),{parentIdField:a}=r.modelClass,l=[];let c;return e.forEach((e=>{c=c||(!(s in e)&&o in e?o:s);const t=e[a];i.has(t)||i.set(t,{append:[],insert:[]});const n=i.get(t);!e.isModel&&c in e?n.insert.push(e):n.append.push(e)})),i.forEach((({append:e,insert:i},s)=>{const o=null==s?r.rootNode:r.getById(s);if(!o)throw new Error(`Parent node with id ${s} not found, cannot add children.`);if(e.length){const i=o.appendChild(e,t,n);rt.chunkedPush(l,i)}if(i.length)for(const e of i)"orderedParentIndex"in e&&("orderedParentIndex"in n&&U.isObject(n.orderedParentIndex)?n.orderedParentIndex.index=e.orderedParentIndex:n.orderedParentIndex=e.orderedParentIndex),l.push(o.insertChild(e,e[c],t,n))})),r.isFiltered&&r.reapplyFilterOnAdd&&r.filter({silent:!0}),r.reapplySortersOnAdd&&!r.isSyncingDataOnLoad&&r.sort(),l}if(!t&&!1===r.trigger("beforeAdd",{records:e}))return null;if(r.tree=r.tree||Boolean(r.autoTree&&e[0].children),r.tree)return r.rootNode.appendChild(e);const o=r.processRecords(e);return t&&r.suspendEvents(),r.addingClean=n.clean,s.add(o),r.addingClean=!1,t&&r.resumeEvents(),r.autoCommit&&r.doAutoCommit(),o}cloneImmutable(e){return!this.useRawData.enabled||e[0].isModel||Object.isExtensible(e[0])||(e=U.clone(e)),e}processRecords(e,t){return this.cloneImmutable(e).map((e=>{const n=this.processRecord(e.isModel?e:this.createRecord(e));return null==t||t.call(this,n),n}))}insert(e,t,n=!1){const i=this,r=i.storage,s=r.getAt(e),o=r.values,a=[];if(t=rt.asArray(t),i.tree){var l;const r=i.rootNode;return r.insertChild(t,null===(l=r.children)||void 0===l?void 0:l[e],n)}if(!n&&!1===i.trigger("beforeAdd",{records:t}))return null;let c,d,u;if(o[d=e]===t[0]||o[d=e-1]===t[0])for(c=!0,u=0;c&&u<t.length;u++)t[u]!==o[d+u]&&(c=!1);if(c)return null;const h=i.processRecords(t,(t=>{const n=r.indexOf(t);t.children&&t.children.length&&i.autoTree&&(i.tree=!0),n>-1&&(n<e&&s&&e--,a.push(n)),t.meta.previousIndex=n}));return i.suspendEvents(),i.storage.remove(a),i.resumeEvents(),n&&i.suspendEvents(),r.splice(e,0,h),n&&i.resumeEvents(),i.autoCommit&&i.doAutoCommit(),h}move(e,t){const n=this;n.isTree?t.parent.insertChild(e,t):(n.storage.move(e,t),n.isChained&&n.syncOrder&&n.$master.storage.move(e,t))}acceptChanges(){const e=this;e.added.forEach((e=>e.internalClearChanges(!0,!1))),e.modified.forEach((e=>e.internalClearChanges(!0,!1))),e.added.clear(),e.modified.clear(),e.removed.clear()}commit(e=!1){const{changes:t}=this;return!(!e&&!1===this.trigger("beforeCommit",{changes:t}))&&(this.acceptChanges(),e||this.trigger("commit",{changes:t}),t)}revertChanges(){const e=this,{changes:t}=e;if(t){const n={action:"clearchanges",changes:t},i=e.modified.values;e.add(e.removed.values,!0),e.remove(e.added.values,!0),i.sort(zo),i.forEach((e=>e.revertChanges(!0))),e.added.clear(),e.modified.clear(),e.removed.clear(),e.trigger("change",n),e.trigger("refresh",n)}}get changes(){const e=this,t=e.modified.values.filter((e=>e.rawModifications));return e.added.count||t.length||e.removed.count?{added:e.added.values.slice(),modified:t,removed:e.removed.values.slice()}:null}get hasChanges(){return Boolean(this.added.count||this.removed.count||this.modified.values.some((e=>e.rawModifications)))}updateAutoCommit(e){e&&this.hasChanges&&this.commit()}suspendAutoCommit(){this.suspendCount++}resumeAutoCommit(e=!0){this.suspendCount--,this.autoCommit&&e&&this.doAutoCommit()}doAutoCommit(){this.suspendCount<=0&&this.commit()}},Wo=e=>class extends(e||tt){static $name="StoreChanges";static get configurable(){return{applyChangesetFilterSortTarget:"changes"}}applyChangesFromStore(e){const t=this,{changes:n}=e;n&&(n.added&&t.add(n.added),n.removed&&t.remove(n.removed.map((e=>e.id))),n.modified&&n.modified.forEach((e=>{const n=t.getById(e.id);null==n||n.set(e.modifications)})))}applyChangeset(e,t=null,n="$PhantomId",i=!0,r=!1){const s=this,o=(null==t?void 0:t(e,s))??e,a=o.$input||o,{added:l,updated:c,modified:d,removed:u}=a,h=c??d??[],g=s.modelClass.getFieldDataSource("id"),m=s.modelClass.getFieldDataSource("parentId"),p=r?new Map:null,f=s.tree,v=[],y=[],b=new Set;let C=!1,S=[];if(s.trigger("startApplyChangeset"),s._groupVisibleRecordIds=[],s.isGrouped&&s.forEach((e=>{s._groupVisibleRecordIds.push(e.id)})),(null==l?void 0:l.length)>0){const e=[],t=[];for(const i of l){const r=s.getById(i[n])||s.getById(U.getPath(i,g));if(r)e.push(i),f&&b.add(r.parent);else{s.removed.get(i[n])||s.removed.get(U.getPath(i,g))||t.push(i)}}h.unshift.apply(h,e);const r=s.reapplySortersOnAdd;s.reapplySortersOnAdd=!1;const o=s.add(t,!1,{orderedParentIndex:{skip:!0},clean:i})??[];if(rt.chunkedPush(v,o),s.reapplySortersOnAdd=r,f)for(const e of o){const{parent:t}=e;if(t.isRoot){C=!0,S=[t];break}!t.isRoot&&S.every((e=>!e.contains(t)))&&S.push(t),"orderedParentIndex"in e.originalData&&b.add(t)}for(const e of o)null==p||p.set(e.id,e.data),e.internalClearChanges();f&&b.forEach((e=>{e.updateChildrenIndices(e.orderedChildren,"orderedParentIndex",!0)}))}if((null==h?void 0:h.length)>0)for(const e of h){const t=e[n],i=U.getPath(e,g),r=U.getPath(e,m),o=s.removed.get(t)??s.removed.get(i),a=o??s.getById(t)??s.getById(i);if(a){var w;const l=null!=r&&(null===(w=s.getById(r))||void 0===w?void 0:w.isLeaf);this.filterTreeHierarchyChanges(b,a,e);const c=a.applyChangeset(e,n);o&&g in c&&t&&s.onRecordIdChange({record:a,oldValue:t,value:i}),l&&s.toggleCollapse(a.parent,!1),f&&a.parent&&!C&&S.every((e=>!e.contains(a)))&&(a.parent.isRoot?(C=!0,S=[a.parent]):S.push(a.parent)),null==p||p.set(i,c),y.push(a)}}if((null==u?void 0:u.length)>0&&s.applyRemovals(u),"changes"===s.applyChangesetFilterSortTarget&&!s.remoteFilter){const e=s.filterChangeset(v,y);S.push(...e)}if(s.afterChangesetApplied(S),f&&s.isSorted&&s.reapplySortersOnAdd&&(null!=l&&l.length||null!=h&&h.length)){const e=new Set;S.forEach((t=>{e.has(t)||(e.add(t),t.sortVisibleChildren(!1,s.sorterFn),t.sortUnfilteredChildren(!1,s.sorterFn))})),s.storage.replaceValues({values:s.collectDescendants(s.rootNode).visible,silent:!0}),s.afterPerformSort(!1)}return s._groupVisibleRecordIds=null,s.trigger("endApplyChangeset"),p}afterChangesetApplied(e){const t=new Set;e.forEach((e=>{t.has(e)||e.traverse((e=>{t.has(e)||(t.add(e),e.sortOrderedChildren(!1,!1),e.children&&e.updateChildrenIndices(e.children,"parentIndex",!0),e.unfilteredChildren&&e.updateChildrenIndices(e.unfilteredChildren,"unfilteredIndex",!0))}))}))}applyRemovals(e){const t=this,{removed:n}=t,i=t.modelClass.idField,r=[];for(const t of e){const e=U.getPath(t,i);if(n.includes(e)){const t=n.get(e);t.internalClearChanges(!1,!0,null),t.$isPhantom=!0,n.remove(e)}else r.push(e)}if(t.tree){const e=r.reduce(((e,n)=>(t.getById(n)&&e.add(t.getById(n).parentNode??t.rootNode),e)),new Set);e.forEach((e=>e.sortOrderedChildren(!1,!1)))}t.remove(r);for(const e of r)n.remove(e)}filterChangeset(e,t){const n=this,{isFiltered:i,tree:r,isGrouped:s,filtersFunction:o}=n,a=n.isSorted?n.createSorterFn(n.sorters):void 0,{allValues:l,addedValues:c,isSorted:d}=n.storage,u=null!=a||d?a??n.storage.sortFunction:null,h=new Set;if(!i)return[];let g,m=!1;if(s&&(g=n.groupers,n.clearGroupers(!0)),r){const i=new Set(t.filter(o));for(const t of e.filter(o))i.add(t);i.forEach((e=>e.bubble((e=>i.add(e))))),i.delete(n.rootNode);const r=rt.groupByIndexed(Array.from(i).filter((e=>{var t;return!(null!==(t=e.parent)&&void 0!==t&&null!==(t=t.children)&&void 0!==t&&t.includes(e))})),(e=>e.parent));for(const[e,t]of r)e.unfilteredChildren&&(e.children.push(...t),h.add(e),n.traverseFilter(e,!1,t))}else if(u&&!s){const{filteredValues:e}=n.storage,i=c?e.findLastIndex((e=>!c.has(e)))+1:e.length,r=e.slice(0,i),s=new Set(t.filter(o));for(const t of e)s.has(t)&&s.delete(t);for(const e of s)r.push(e);r.sort(u),e.splice(0,i,...r),m=!0}else{const e=t.filter((e=>o(e)&&!n.storage.includes(e)));e.length>0&&(n.includeInSubset(l,n.storage.filteredValues,e),m=!0)}const p=new Set(e.filter((e=>!o(e))));if(p.size>0){if(r)for(const e of p)rt.remove(e.parent.children,e),h.add(e.parent);else rt.remove(n.storage.filteredValues,p);m=!0}return g&&(n.group(g[0],null,!1,!0,!0),m=!1,n._idMap=null),r&&h.size>0?n.storage.replaceValues({values:n.collectDescendants(n.rootNode).visible,silent:!0}):m&&(n._idMap=null,n.trigger("refresh")),Array.from(h)}filterTreeHierarchyChanges(e,t,n){this.tree&&e.has(t.parent)&&(delete n.orderedParentIndex,delete n.parentIndex)}includeInSubset(e,t,n){const i=new Set(n);let r=0,s=0,o=0===i.size;for(;s<e.length&&!o;){const n=t[r];let a=e[s];for(;n!==a;)i.has(a)&&(t.splice(r,0,a),r++,i.delete(a),o=0===i.size),a=e[++s];i.has(n)&&i.delete(n),r<t.length&&r++}return t}},Uo=e=>class extends(e||tt){static $name="StoreFilter";static configurable={remoteFilter:!1,filterParamName:null,filters:void 0,reapplyFilterOnAdd:!1,reapplyFilterOnUpdate:!1};static properties={filterBatching:0,needsFiltering:!1};updateFilterParamName(e){this.remoteFilter=null!=e}updateReapplyFilterOnAdd(e){this.storage.autoFilter=e}get reapplyFilterOnAdd(){return this.storage.autoFilter}changeFilters(e,t){const n=this;if(t?t.clear():t=new _o({extraKeys:["property"]}),n._filtersFunction=null,e){if("Object"===e.constructor.name)for(const n of Object.entries(e))"filterBy"===n[0]&&"function"==typeof n[1]?t.add(new Eo({filterBy:n[1]})):t.add(new Eo("Object"===n[1].constructor.name?Object.assign({property:n[0]},n[1]):{property:n[0],value:n[1]}));else Array.isArray(e)?t.add(...e.map((e=>e instanceof Eo?e:new Eo(e)))):e.isCollection?t.add(...e.values):t.add(new Eo({filterBy:e}));t.forEach((e=>e.owner=n))}return t}set filtersFunction(e){this._filtersFunction=e}get filtersFunction(){const e=this,{filters:t,isGrouped:n}=e;if(!e._filtersFunction)if(t.count){const i=Eo.generateFiltersFunction(t);e._filtersFunction=e=>n&&e.isSpecialRow?e.groupChildren.some(i):!!e.isCreating||i(e)}else e._filtersFunction=te.returnTrue;return e._filtersFunction}get isFiltered(){return!!(this._filters||this.isConfiguring&&this.initialConfig.filters)&&this.filters.values.some((e=>!e.disabled))}isFilteredOut(e){return this.isFiltered&&!this.filtersFunction(e)}traverseFilter(e,t=!0,n=void 0){const i=this,{filtersFunction:r}=i,s=!e.isRoot&&r(e),o=e.unfilteredChildren||e.children;return o&&o.length?(e.unfilteredChildren||(e.unfilteredChildren=e.children.slice()),e.children=e.unfilteredChildren.filter((e=>t?i.traverseFilter(e,t):r(e)||(null==n?void 0:n.has(e)))),i.isSorted&&e.children.sort(i.sorterFn),e.updateChildrenIndices(e.unfilteredChildren,"unfilteredIndex",!0),e.updateChildrenIndices(e.children,"parentIndex",!0),s||Boolean(e.children.length)):s}traverseClearFilter(e){const t=this;e.unfilteredChildren&&(e.children=e.orderedChildren.slice(),e.unfilteredChildren=null),e.children&&(t.isSorted&&e.children.sort(t.sorterFn),e.children.forEach((e=>t.traverseClearFilter(e))),e.updateChildrenIndices(e.children,"parentIndex",!0))}get latestFilterField(){return this.filters.last?this.filters.last.property:null}addFilter(e,t=!1){const n=this;if((e=e instanceof Eo?e:new Eo(e)).owner=n,n.filters.add(e),!t){if(n.remoteFilter)return n.filter().then((()=>e));n.filter()}return e}filter(e){const t=this;let n,i=!1;if(e){let r=typeof e;if("object"===r&&("silent"in e||"replace"in e||e.filters)&&(i=e.silent,e.replace&&t.clearFilters(e.silent||0!==e.filters.length),n=e.internal,r=typeof(e=e.filters)),e){const i=t.isFiltered;if(t.isConfiguring=!0,Array.isArray(e))e.forEach((e=>t.addFilter(e,!0)),t);else if("function"===r){const i=new Eo(e);i.internal=n,t.addFilter(i,!0)}else"string"===r?t.addFilter({property:e,value:arguments[1]},!0):t.addFilter(e,!0);if(t.isConfiguring=!1,!t.isFiltered&&!i)return null}}t.filtersFunction=null;const r=t.remoteFilter?t.performRemoteFilter(i):t.performFilter(i);return t._idMap=null,r}suspendFilterOnUpdate(){this.filterBatching++}resumeFilterOnUpdate(e){if(this.filterBatching--,this.filterBatching<0)throw new Error("No matching `startFilterBatching` call");0===this.filterBatching&&this.needsFiltering&&(this.needsFiltering=!1,this.performFilter(e))}performFilter(e){const t=this;if(t.filterBatching>0)return void(t.needsFiltering=!0);const{storage:n,filters:i,rootNode:r}=t,s=t.count;let o,a;if(e||t.trigger("beforeFilter",{filters:i}),t.tree){const e=n.values;t.isFiltered?t.traverseFilter(r):t.traverseClearFilter(r);const i=t.collectDescendants(r).visible;n.replaceValues({values:i,silent:!0});const s=rt.delta(i,e,!0);o=s.toAdd,a=s.toRemove}else n.ion({change({removed:e,added:t}){a=e,o=t},once:!0}),t.isFiltered?(t.isGrouped&&t.includeCollapsed(),n.addFilter({id:"primary-filter",filterBy:t.filtersFunction}),t.isGrouped&&t.excludeCollapsed()):n.filters.clear();t.afterPerformFilter(e||t.isRemoteDataLoading?null:{action:"filter",filters:i,oldCount:s,added:o,removed:a,records:t.storage.values})}async performRemoteFilter(e){var t;const n=this,{filters:i,count:r}=n;if(!1===await(null===(t=n.beforePerformFilter)||void 0===t?void 0:t.call(n,{filters:i,oldCount:r})))return;if(n.currentPage=1,!1===await n.performDataRequest(e))return;const s=e?null:{action:"filter",filters:i,oldCount:r,records:n.storage.values};n.afterPerformFilter(s),n.trigger("refresh",s)}buildRemoteParams(e={},t=!1){var n;null===(n=super.buildRemoteParams)||void 0===n||n.call(this,e,t);const i=this,{filters:r}=i;return i.isFiltered&&(e[i.filterParamName??"filters"]=t?i.encodeFilterParams(r):i.getFilterParams(r)),e}afterPerformFilter(e){this.resetRelationCache(),e&&this.triggerFilterEvent(e)}getFilterParams(e){return e.values.filter((e=>!e.disabled&&!e._filterBy)).map((e=>e.toJSON()))}triggerFilterEvent(e){this.trigger("filter",e),this.remoteFilter||(this.trigger("refresh",e),this.trigger("change",e))}filterBy(e){return this.filter(e)}removeFilter(e,t=!1){const n=this,i=e instanceof Eo?e:n.filters.get(e)??n.filters.getBy("property",e);if(i){var r;if(null===(r=n._filters)||void 0===r||r.remove(i),n._filtersFunction=null,!t){if(n.remoteFilter)return n.filter().then((()=>i));n.filter()}return i}}clearFilters(e=!1){if(this.filters.remove(this.filters.values.filter((e=>!e.internal))),!e)return this.filter()}convertFilterToString(e){const t=this.filters.getBy("property",e);return t&&!t.filterBy?String(t):""}doDestroy(){var e;null===(e=this._filters)||void 0===e||e.destroy(),super.doDestroy()}};const Go={add:1,replace:1},qo="!!novalue!!",Yo=({_groupValue:e},{_groupValue:t})=>e<t?-1:e>t?1:0;var Ko=e=>class extends(e||tt){static $name="StoreGroup";static configurable={groupers:null,useGroupFooters:!1,startGroupsCollapsed:null};static get properties(){return{collapsedGroups:new Set}}construct(e){super.construct(e),this.ion({change:"onDataChanged",thisObj:this})}get GroupRow(){return this._GroupRowClass||(this._GroupRowClass=class extends this.modelClass{static isSpecialRow=!0;static fields=[{name:"_groupValue"}];get isCollapsed(){return this.meta.collapsed}})}updateGroupers(e){this.setGroupers(e)}setGroupers(e,t=null){const n=this,{storage:i}=n;let r;return n._idMap=null,null!=e&&e.length?n._groupers=e.map((e=>n.createGrouper(e))):n.groupers&&(delete n._groupers,n.includeCollapsed(),i.replaceValues({values:n.removeHeadersAndFooters(i._values),filteredValues:i.isFiltered?n.removeHeadersAndFooters(i._filteredValues):null,silent:!0}),r=n.group(null,null,null,!1,null==t?void 0:t.silent)),r}createGrouper(e,t){if(!e||e.isGrouper)return e;"string"==typeof e&&(e={field:e,["boolean"==typeof t?"ascending":void 0]:t});const{field:n}=e,i=null==n?void 0:n.indexOf("."),r=i>0,s=null==n?void 0:n.split("."),o=r?s[0]:n,a=r?(c=s)[(d=-1)<0?c.length+d:d]:n,l=r?n.slice(i+1):n;var c,d;return{isGrouper:!0,...e,complexMapping:r,rootFieldName:o,leafFieldName:a,fieldPath:l}}get unfilteredGroupRecords(){const e=this;if(e.isGrouped){var t;const{generation:n}=e.storage;(null===(t=e._unfilteredGroupRecords)||void 0===t?void 0:t.generation)!==n&&(e._unfilteredGroupRecords=e.storage.allValues.filter((e=>e.isSpecialRow)),e._unfilteredGroupRecords.generation=n)}return e._unfilteredGroupRecords||[]}getGroupHeaderForRecord(e,t=!1){if(this.isGrouped)return e?"groupRowFor"in e.meta?e:e.instanceMeta(this).groupParent:this.groupRecords.last}includeCollapsed(){for(const e of this.collapsedGroups)this.expand(this.getById(e),!1)}excludeCollapsed(){for(const e of this.collapsedGroups)this.collapse(this.getById(e))}onDataChange({source:e,action:t,removed:n}){var i;const r=this,{groupers:s}=r;s&&(s.length?"splice"!==t&&"move"!==t||e.replaceValues({...r.prepareGroupRecords(),silent:!0}):e.replaceValues({values:r.removeHeadersAndFooters(e._values),filteredValues:e.isFiltered?r.removeHeadersAndFooters(e._filteredValues):null,silent:!0})),null===(i=super.onDataChange)||void 0===i||i.call(this,...arguments)}move(e,t){const n=this;let i;if(n.isGrouped&&!n.tree){var r,s;let o=t;if(null!==(r=t)&&void 0!==r&&r.isSpecialRow&&(o=n.getPrev(t,!1,!1),!o))return;const a=n.getGroupHeaderForRecord(o),l=n.groupers[0].field,{reapplyFilterOnUpdate:c}=n,d="array"===n.modelClass.getFieldDefinition(l).type;let u=a.meta.groupRowFor;if(n.reapplyFilterOnUpdate=!1,n.beginBatch(),e.forEach((e=>{if(d){const t=e.get(l)||[];if(t.includes(u))return;{const n=e.instanceMeta(this).groupParent,r=a._groupValue;rt.remove(t,n),u=t.slice(),r===qo?u=void 0:Array.isArray(r)&&0===r.length?u=[]:u.push(r),i=!0}}e.setValue(l,u)})),n.endBatch(),d&&!i)return;if(n.reapplyFilterOnUpdate=c,n.isFiltered&&null!==(s=t)&&void 0!==s&&s.isSpecialRow){const{unfilteredGroupRecords:e}=n,i=e.indexOf(a);t=e[i+1]}}super.move(e,t),i&&n.group(n.groupers[0])}collapse(e){let t=!1;return e&&(e=rt.asArray(e)).forEach((e=>{e&&!e.meta.collapsed&&(this.excludeGroupRecords(e),e.meta.collapsed=!0,this.collapsedGroups.add(e.id),this.trigger("toggleGroup",{groupRecord:e,collapse:!0}),t=!0)})),t}expand(e,t=!0){let n=!1;return e&&(e=rt.asArray(e)).forEach((e=>{null!=e&&e.meta.collapsed&&(this.includeGroupRecords(e),e.meta.collapsed=!1,t&&this.collapsedGroups.delete(e.id),t&&this.trigger("toggleGroup",{groupRecord:e,collapse:!1}),n=!0)})),n}removeHeadersAndFooters(e){return e.filter((e=>(null!=e&&e.unfilteredGroupChildren&&(e.groupChildren.length=e.unfilteredGroupChildren.length=e.meta.childCount=0),!(null!=e&&e.isSpecialRow||null!=e&&e.isLinked&&e.instanceMeta(this).groupParent)||(this.unregister(e),!1))))}prepareGroupRecords(){var e;const t=this,{GroupRow:n,isFiltered:i,reapplyFilterOnUpdate:r,groupRecords:s}=t,o=t.groupers[0],a=!1!==o.ascending?1:-1,{field:l,fn:c=Yo,leafFieldName:d}=o,u="function"==typeof l,h=l===t.modelClass.idField,g=new _o,m=t._groupVisibleRecordIds||[],p=e=>{const n=!i||t.filtersFunction(e);return r?n:n||m.includes(e.id)},f=Boolean(t.startGroupsCollapsed&&!(null!=s&&s.count));null==s||s.forEach((e=>{e.isCollapsed&&t.includeGroupRecords(e)}));const v=t.removeHeadersAndFooters(t.storage._values);if(t.sorters.length&&v.sort(t.sorterFn),i&&(t.filtersFunction=null),v.forEach((e=>{const i=e,r=u?l(e):e.getValue(l),o=rt.asArray(null==r?qo:r),a=Array.isArray(o)&&!o.length,c=a?1:o.length;for(let r=0;r<c;r++){const l=a?[]:o[r],c=`group-header-${"number"==typeof l?l:V.createId(l)}`;let u=g.get(c);if(u||(u=(null==s?void 0:s.get(c))||new n({[t.modelClass.idField]:c,[h?"":d]:l,_groupValue:l},t,{collapsed:f,specialRow:!0,groupRowFor:l,groupField:d,emptyArray:a}),g.add(u),u.meta.childCount=0,u.groupChildren=[],u.unfilteredGroupChildren=[],u.stores=[t]),t.register(u),r>0){const n=i.groupLinks||(i.groupLinks={});(e=n[l]||(n[l]=i.link())).stores=[t],t.register(e)}e.instanceMeta(t).groupParent=u,p(e)&&(u.groupChildren.push(e),u.meta.childCount++),u.unfilteredGroupChildren.push(e)}})),g._values.sort(((e,t)=>c(e,t)*a)),t.useGroupFooters)for(let e=0,i=g.count;e<i;e++){const r=g.values[e],s=r.meta.groupRowFor,o=`group-footer-${"number"==typeof s?s:V.createId(s)}`,a=t.getById(o)||new n({[t.modelClass.idField]:o,[h?"":d]:s,_groupValue:s},t,{specialRow:!0,groupFooterFor:s,groupRecord:r});a.stores=[t],t.register(a),a.groupChildren=r.groupChildren,g.splice(++e,0,a),i++,r.groupChildren.push(a),r.unfilteredGroupChildren.push(a),r.meta.childCount++}t._idMap=null;const y={values:g.reduce(((e,t)=>(t.isGroupFooter||(e.push(t),t.meta.collapsed||e.push(...t.unfilteredGroupChildren)),e)),!1,[])};return i&&(y.filteredValues=y.values.filter(p)),null===(e=t.groupRecords)||void 0===e||e.forEach((e=>{g.includes(e)||e.destroy()})),t.groupRecords=g,y}get isGrouped(){var e;return Boolean(null===(e=this.groupers)||void 0===e?void 0:e.length)}group(e,t,n=!1,i=!0,r=!1){const s=this,{sorters:o=[]}=s,a=s.createGrouper(e,t);let l,c=!1;if(n)s.groupers.push(a);else if(e){var d,u;if(null==t&&!("ascending"in a))a.ascending=!a.fn||(null===(d=s.groupInfo)||void 0===d?void 0:d.field)!==a.field||(null===(u=s.groupInfo)||void 0===u?void 0:u.fn)!==a.fn||!s.groupInfo.ascending;s.groupInfo=l=a,s.groupers=[s.groupInfo],o.some((t=>t.field===e))&&(s.sorters=o.filter((t=>t.field!==e)),c=!0)}else null===e&&null===t?(i=!0,c=!0):!c&&o.length&&i&&(c=!0);if(l){const{prototype:t}=s.modelClass;l.complexMapping&&!Object.prototype.hasOwnProperty.call(t,e)&&Object.defineProperty(t,e,{get(){return U.getPath(this,e)}})}if(!1!==i){if(s.remoteSort&&!s.isRemoteDataLoading)return s.sort(null,null,!1,!c).then((()=>s.onAfterGrouping(r,!c)));s.sort(null,null,!1,!c)}s.onAfterGrouping(r,!c)}onAfterGrouping(e,t=!0){if(e)return;const n=this,i=n.groupers||[];n.trigger("group",{isGrouped:n.isGrouped,groupers:i,records:n.storage.values}),t&&n.trigger("refresh",{action:"group",isGrouped:n.isGrouped,groupers:i,records:n.storage.values})}addGrouper(e,t=!0){return this.group(e,t,!0)}removeGrouper(e){const t=this,{groupers:n}=t;if(!n)return;const i=n.findIndex((t=>t.field===e));return i>-1?(n.splice(i,1),n.length?t.group():t.clearGroupers()):void 0}clearGroupers(e=!1){return this.setGroupers(null,{silent:e})}isRecordInGroup(e,t){var n;if(!this.isGrouped)return!1;const i=null===(n=this.groupers[0])||void 0===n?void 0:n.field;return e.getValue(i)===t&&!e.isSpecialRow}isInCollapsedGroup(e){const{groupParent:t}=e.instanceMeta(this);return null==t?void 0:t.meta.collapsed}getGroupRecords(e){return this.isGrouped?this.storage.values.filter((t=>this.isRecordInGroup(t,e))):null}getGroupTitles(){return this.isGrouped?this.getDistinctValues(this.groupers[0].field):null}get groupHeaderRecords(){return this.useGroupFooters?this.groupRecords.values.filter((e=>e.isGroupHeader)):this.groupRecords.values}onDataChanged({changes:e,action:t}){this.isGrouped&&(!e&&Go[t]||e&&this.groupers.some((t=>t.rootFieldName in e)))&&this.sort()}internalIncludeExcludeGroupRecords(e,t){const n=this,i=n.indexOf(e),r=n.allIndexOf(e),{id:s,storage:o}=n,{_filteredValues:a,_values:l}=o,{meta:c,groupChildren:d,unfilteredGroupChildren:u}=e;-1===r||c.collapsed&&!t||!c.collapsed&&t||(u.forEach((e=>e.instanceMeta(s).hiddenByCollapse=!t)),t?(a&&a.splice(i+1,0,...d.filter((e=>!n.isAvailable(e.id)))),o._values.splice(r+1,0,...u.filter((e=>!n.isAvailable(e.id))))):(a&&a.splice(i+1,d.length),l.splice(r+1,u.length)),o._indicesInvalid=!0,n._idMap=null)}excludeGroupRecords(e){this.internalIncludeExcludeGroupRecords(e,!1)}includeGroupRecords(e){this.internalIncludeExcludeGroupRecords(e,!0)}collectGroupRecords(e,t=!0){return(e?this.storage.allValues:this.storage.values).reduce(((n,i)=>(i.isSpecialRow&&(t&&!i.isGroupFooter&&n.push(i),i.isGroupHeader&&n.push.apply(n,e?i.unfilteredGroupChildren:i.groupChildren)),n)),[])}};const Xo=Promise.resolve();var Zo=e=>class extends(e||tt){static $name="StorePaging";static configurable={pageSize:50,pageSizeParamName:"pageSize",pageParamName:null,pageStartParamName:null,remotePaging:!1};get currentPage(){return this._currentPage??1}set currentPage(e){this.totalCount&&(e=Math.min(e,this.lastPage)),this._currentPage=e}updatePageParamName(e){if(this.pageStartParamName)throw new Error("Configs pageStartParamName and pageParamName are mutually exclusive");this.remotePaging=null!=e}updatePageStartParamName(e){if(this.pageParamName)throw new Error("Configs pageParamName and pageStartParamName are mutually exclusive");this.remotePaging=null!=e}get defaultPageParamName(){return this.pageParamName??this.pageStartParamName??"page"}updateRemotePaging(e){if(e&&this.tree)throw new Error("Paging cannot be supported for tree stores")}updatePageSize(e){const t=this;!t.isConfiguring&&e&&(t.currentPage=t.currentPage?Math.min(t.currentPage,Math.floor((t.totalCount+e-1)/e)):1,t.loadPage(t.currentPage))}get isPaged(){return this.remotePaging}set pagedTotal(e){this.remoteTotal=e}get lastPage(){if(this.isPaged)return Math.floor((this.totalCount+this.pageSize-1)/this.pageSize)}async loadPage(e,t={}){if(t=this.getPagingParams({...t,page:e}),!1===await this.trigger("beforeLoadPage",{params:t}))return!1;var n;!1!==await this.performDataRequest(!1,t,(()=>{this.currentPage=e}))&&(null===(n=this.trigger)||void 0===n||n.call(this,"loadPage",t))}async nextPage(e){const t=this;return t.isPaged&&t.currentPage!==t.lastPage?t.loadPage(t.currentPage+1,e):Xo}async previousPage(e){return this.isPaged&&1!==this.currentPage?this.loadPage(this.currentPage-1,e):Xo}buildRemoteParams(e={},t=!1){var n;return this.getPagingParams((null===(n=super.buildRemoteParams)||void 0===n?void 0:n.call(this,e,t))??e)}getPagingParams(e){const t=this;if(t.isPaged){let n=e[t.defaultPageParamName]??t.currentPage;this.pageStartParamName&&(n=Math.max(0,n-1)*this.pageSize),e[t.defaultPageParamName]=n,e[t.pageSizeParamName]=t.pageSize}return e}},Jo=e=>class extends(e||tt){static get configurable(){return{objectify:null}}initProxy(){if(!globalThis.Proxy)throw new Error("Proxy not supported");return new Proxy(this,{get(e,t){if(t in e)return e[t];if("$store"===t)return e;let n=e.getById(t);return n||isNaN(parseInt(t))||(n=e.getAt(parseInt(t))),n},set:(e,t,n)=>(t in e||e.isDestroying||t.startsWith("_")?e[t]=n:e.add({[e.modelClass.idField]:t,...n}),!0),deleteProperty:(e,t)=>e.isDestroying?(delete e[t],!0):Boolean(e.remove(t).length),has(e,t){if(t in e)return!0;if(t.startsWith("{")&&t.endsWith("}")){const e=V.safeJsonParse(t);t=null==e?void 0:e.id}return e.includes(t)}})}},Qo=e=>class extends(e||tt){static $name="StoreRelation";initRelations(e){const t=this,n=t.modelClass.exposedRelations;e&&t.modelRelations&&t.modelRelations.forEach((e=>{var t;return null===(t=e.storeDetacher)||void 0===t?void 0:t.call(e)})),t.modelRelations&&0!==t.modelRelations.length&&!e||t.isChained||(t.modelRelations=[],null==n||n.forEach((n=>{const i={...n},{foreignStore:r,relationName:s,relatedCollectionName:o}=i,a="string"==typeof r?t[r]:r;if(i.dependentStore=t,t.modelRelations.push(i),a){i.foreignStoreProperty=i.foreignStore,i.foreignStore=a;const n=a.dependentStoreConfigs;if(n.has(t)){const r=n.get(t);if(e){const e=r.find((e=>e.relationName===s));e&&rt.remove(r,e)}r.push(i)}else n.set(t,[i]);o&&a.initRelationCollection(i,t),a.count>0&&a.updateDependentStores("dataset",a.records)}})))}initRelationCollection(e,t){const n=this,i=e.relatedCollectionName;(n.collectionStores||(n.collectionStores={}))[i]={store:t,config:e},n[i+"Store"]||(n[i+"Store"]=t),n.allRecords.length&&n.initModelRelationCollection(i,n.allRecords)}initModelRelationCollection(e,t){const n=this;t.forEach((t=>{t.traverse((t=>{const i=e in t?`$related${V.capitalize(e)}`:e;Object.defineProperty(t,i,{enumerable:!0,configurable:!0,get:function(){return n.getCollection(this,e)},set:function(t){return n.setCollection(this,e,t)}})}))}))}resetRelationCache(){this.relationCache={},this.forEach((e=>e.initRelations()))}updateRecordRelationCache(e,t){null==t||t.forEach((t=>{const{config:n}=t,i=t.related?t.related.id:e.getValue(n.foreignKey);void 0!==i&&this.cacheRelatedRecord(e,i,n.relationName,i)}))}getRelationCollection(e,t){var n;const i=lo.asId(t);return(null===(n=this.relationCache[e])||void 0===n?void 0:n[i])||[]}getCollection(e,t){var n;const{config:i,store:r}=this.collectionStores[t];return(null===(n=r.relationCache[i.relationName])||void 0===n?void 0:n[e.id])||[]}setCollection(e,t,n){const{config:i,store:r}=this.collectionStores[t],s=((r.relationCache[i.relationName]||(r.relationCache[i.relationName]={}))[e.id]||[]).slice(),o=[],a=[];r.suspendEvents(),s.forEach((e=>{n.includes(e)||(e[i.foreignKey]=null,r.remove(e),a.push(e))})),n.forEach((t=>{t.isModel instanceof lo?t.stores.includes(r)||(r.add(t),o.push(t)):([t]=r.add(t),o.push(t)),t[i.foreignKey]=e.id})),r.resumeEvents(),a.length&&(r.trigger("remove",{records:a}),r.trigger("change",{action:"remove",records:a})),o.length&&(r.trigger("add",{records:o}),r.trigger("change",{action:"add",records:o}))}cacheRelatedRecord(e,t,n,i=null){const r=this,s=r.relationCache[n]||(r.relationCache[n]={});null!==i&&r.uncacheRelatedRecord(e,n,i),null!=t&&rt.include(s[t]||(s[t]=[]),e)}uncacheRelatedRecord(e,t=null,n=null){const i=this;function r(t,n){const r=i.relationCache[t],s=null==r?void 0:r[n];if(s){const t=s.indexOf(e);t>=0&&s.splice(t,1),0===s.length&&delete r[n]}}null!=n?r(t,n):e.meta.relationCache&&Object.entries(e.meta.relationCache).forEach((([e,t])=>r(e,null==t?void 0:t.id)))}updateDependentStores(e,t,n){var i;const r=this,s="dataset"===e;var o;(r.dependentStoreConfigs.forEach((i=>{i.forEach((i=>{const{dependentStore:o,relatedCollectionName:a,relationName:l,foreignKey:c,propagateRecordChanges:d}=i,u=o.relationCache[l];if(s)a&&r.initModelRelationCollection(a,t),o.forEach((e=>{const t=e.initRelation(i);t&&o.cacheRelatedRecord(e,t.id,l,t.id)})),d&&o.totalCount&&o.trigger("refresh",{action:"relatedstoredataset",records:o.records});else{if("removeall"===e)return o.forEach((e=>e.removeRelation(i))),void delete o.relationCache[l];"replace"===e&&(t=t.map((e=>e[1])))}"add"!==e&&"replace"!==e||a&&r.initModelRelationCollection(a,t),s||t.forEach((t=>{const s=null==u?void 0:u[t.id];switch(e){case"remove":s&&s.forEach((e=>e.removeRelation(i)));break;case"add":case"replace":o.forEach((e=>{e.getValue(c)==t.id&&(e.initRelation(i),o.cacheRelatedRecord(e,t.id,l))}))}!n&&null!=s&&s.length&&d&&s.forEach((e=>e.stores.forEach((n=>r.notifyRelatedStore(n,e,i.relationName,t)))))}))}))})),null!==(i=t)&&void 0!==i&&i.length)&&(null===(o=r.modelRelations)||void 0===o||o.forEach((e=>{e.propagateRecordChanges&&(s?e.foreignStore.totalCount&&e.foreignStore.trigger("refresh",{action:"relatedstoredataset",records:e.foreignStore.records}):t.forEach((t=>{var n;const i=t[e.relationName];null==i||null===(n=i.stores)||void 0===n||n.forEach((n=>{r.notifyRelatedStore(n,i,e.relatedCollectionName,t)}))})))})))}notifyRelatedStore(e,t,n,{meta:i}){var r;if(this.isChained||e.isChained)return;let{_ignoreRelationUpdate:s}=i,o=!1;null!==(r=s)&&void 0!==r&&r.size||(i._ignoreRelationUpdate=s=new Set,o=!0),s.has(e)||(s.add(this).add(e),t.meta._ignoreRelationUpdate=s,e.onModelChange(t,{[n]:t[n]},{[n]:t[n]},!1,!0),o&&s.clear())}updateDependentRecordIds(e,t){var n;null===(n=this.dependentStoreConfigs)||void 0===n||n.forEach((n=>{n.forEach((n=>{var i;const{dependentStore:r,relationName:s,foreignKey:o}=n,a=r.relationCache[s],l=null==a||null===(i=a[e])||void 0===i?void 0:i.slice();null==l||l.forEach((n=>{r.cacheRelatedRecord(n,t,s,e),n.meta._ignoreRelatedIdUpdate=!0,n.set(o,t,!1,!0),delete n.meta._ignoreRelatedIdUpdate}))}))}))}},ea=e=>class extends(e||tt){static $name="StoreSum";sum(e,t=this.storage.values){return t?t.reduce(((t,n)=>{if(n.isSpecialRow)return t;const i=Number(n.getValue(e));return isNaN(i)?t:t+i}),0):0}min(e,t=this.storage.values){return null!=t&&t.length?t.reduce(((t,n)=>{const i=n.getValue(e);return"number"===typeof(null==i?void 0:i.valueOf())&&(i<t||null==t)&&(t=i),t}),t[0].getValue(e)):0}max(e,t=this.storage.values){return null!=t&&t.length?t.reduce(((t,n)=>{const i=n.getValue(e);return"number"===typeof(null==i?void 0:i.valueOf())&&(i>t||null==t)&&(t=i),t}),t[0].getValue(e)):0}average(e,t=this.storage.values){if(null==t||!t.length)return 0;let n=0;const i=t.reduce(((t,i)=>{if(i.isSpecialRow)return t;const r=parseFloat(i.getValue(e));return isNaN(r)?t:(n++,t+r)}),0);return n>0?i/n:0}groupSum(e,t){return this.sum(t,this.getGroupRecords(e))}};const ta=(e,t)=>String(e).toLowerCase().includes(t),na={string:ta,number:(e,t)=>e===Number(t),boolean:ta,date:(e,t)=>e instanceof Date&&t instanceof Date?e-t==0:String(e.getMonth()+1).includes(t)||String(e.getDate()).includes(t)||String(e.getFullYear()).includes(t),object:(e,t)=>e===t,undefined:(e,t)=>e===t};var ia=e=>class extends(e||tt){static $name="StoreSearch";search(e,t=null,n,i){const r=this.isTree&&!i?this.rootNode.allChildren:this.getAllDataRecords(i),s=r.length,o=[];if(null==e)return[];let a,l,c,d,u,h;for("string"==typeof e&&(e=e.toLowerCase()),t||(t=this.modelClass.allFields.map((e=>e.name))),a=0;a<s;a++){c=r[a],l=0;for(const i of t){var g;d=c.getValue(i),u=d instanceof Date?"date":typeof d;const t=null==n?void 0:n[l];t&&(d=t(d),u="string"),h=na[u],d&&null!==(g=h)&&void 0!==g&&g(d,e)&&o.push({index:a,data:c,field:i,id:c.id}),l++}}return o}findByField(e,t,n=!1,i=!1){const r=this.getAllDataRecords(i),s=r.length,o=new Set,a=[];let l,c,d;for(null!=t&&(t=String(t).toLowerCase()),l=0;l<s;l++)if(c=r[l],d=c.getValue(e),!n||!o.has(d)){const e=d instanceof Date?"date":typeof d;(null==t&&d===t||""===t&&""===d||t&&(0,na[e])(d,t))&&(a.push({id:c.id,index:l,data:c}),n&&o.add(d))}return a}find(e,t=!1){return this.getAllDataRecords(t).find(e)}findRecord(e,t,n=!1){const i=n=>U.isEqual(n[e],t);return this.isTree?this.query(i,n)[0]:this.getAllDataRecords(n).find(i)}query(e,t=!1){return this.getAllDataRecords(t).filter(e)}some(e,t=!1){return this.getAllDataRecords(t).some(e)}},ra=e=>class extends(e||tt){static $name="StoreSort";static configurable={useLocaleSort:null,sorters:[],reapplySortersOnAdd:!1,reapplySortersOnUpdate:!1,remoteSort:!1,sortParamName:null};get isSorted(){return Boolean(this.sorters.length)||this.isGrouped}changeSorters(e){return e.map((e=>this.normalizeSorterConfig(e,!0)))}updateSortParamName(e){this.remoteSort=null!=e}sort(e,t,n=!1,i=!1){const r=this,s=r.allRecords,o=r.sorters?r.sorters.slice():[];let a,l=null;if(e)if(Array.isArray(e))r.sorters=e.map((e=>r.normalizeSorterConfig(e,"string"==typeof e||t)));else{const i=r.normalizeSorterConfig(e,t);n?(a=r.getCurrentSorterByField(i.field),a?(l=a.ascending,a.ascending=i.ascending):r.sorters.push(i)):r.sorters=[i]}return i||!1!==r.trigger("beforeSort",{sorters:r.sorters,records:s,currentSorters:o})?r.remoteSort?r.performRemoteSort(i):r.performSort(i):(r.sorters=o,null!==l&&(a.ascending=l),null)}normalizeSorterConfig(e,t){const n=this,i={ascending:t};if("object"==typeof e?(U.assign(i,e),e.fn&&(delete i.fn,i.sortFn=e.fn),i.ascending=e.ascending??t):"function"==typeof e?i.sortFn=e:i.field=e,null==i.ascending){const e=n.getCurrentSorterByField(i.field);i.ascending=!e||!e.ascending}if(null==i.sortFn){var r;const e=null===(r=n.modelClass)||void 0===r||null===(r=r.$meta.fields.map[i.field])||void 0===r?void 0:r.compareItems;e&&(i.sortFn=e)}return i}getCurrentSorterByField(e){return"string"==typeof e&&this.sorters.find((t=>t.field===e))||null}addSorter(e,t=!0){return this.sort(e,t,!0)}removeSorter(e){const t=this.sorters.findIndex((t=>t.field===e||t.sortFn===e));if(t>-1)return this.sorters.splice(t,1),this.sort()}clearSorters(e=!1){if(this.sorters.length)return this.sorters.length=0,this.sort(void 0,void 0,void 0,e)}suspendSortOnUpdate(){"_reapplySortersSuspended"in this||(this._reapplySortersSuspended=0),this._reapplySortersSuspended++}resumeSortOnUpdate(e=!0){const t=this;t._reapplySortersSuspended&&(t._reapplySortersSuspended--,!t._reapplySortersSuspended&&t._shouldReapplySorters&&(e&&t.sort(),t._shouldReapplySorters=!1))}createSorterFn(e){const t=this.useLocaleSort;return(n,i)=>{for(let r=0;r<e.length;r++){const s=e[r],{field:o,ascending:a=!0,useLocaleSort:l=t,caseSensitive:c=!0}=s,d=s.fn||s.sortFn,u=a?1:-1;if(d){const e=d.call(s,n,i);if(0===e)continue;if(null!==e)return e*u}let h=n.isModel?n.getValue(o):n[o],g=i.isModel?i.getValue(o):i[o];if(c||("string"==typeof h&&(h=h.toLowerCase()),"string"==typeof g&&(g=g.toLowerCase())),h!==g){if(null==h)return-u;if(null==g)return u;if(l&&"string"==typeof h){if(!0===l)return String(h).localeCompare(g)*u;if("string"==typeof l)return String(h).localeCompare(g,l)*u;if("object"==typeof l)return String(h).localeCompare(g,l.locale,l)*u}if(h>g)return u;if(h<g)return-u}}return 0}}get sorterFn(){return this.createSorterFn(this.remoteSort?[{field:"_remoteSortIndex"}]:this.sorters)}performSort(e){const t=this,{rootNode:n,storage:i,sorterFn:r}=t;t.tree?((!t.isChained||t.isChainedTree)&&n.traverse((e=>{e.isLoaded&&e.isParent&&(e.children.sort(r),e.updateChildrenIndices(e.children,"parentIndex",!0))})),i.replaceValues({values:t.collectDescendants(n).visible,silent:!0})):t.isGrouped?i.replaceValues({...t.prepareGroupRecords(),silent:!0}):i.replaceValues({values:i.values.sort(r),silent:!0}),t.afterPerformSort(e||t.isRemoteDataLoading)}async performRemoteSort(e){var t;!1!==await(null===(t=this.beforePerformSort)||void 0===t?void 0:t.call(this))&&!1!==await this.performDataRequest(e)&&this.afterPerformSort(e)}buildRemoteParams(e={},t=!1){var n;let{sorters:i,groupers:r,sortParamName:s="sorters"}=this;return null===(n=super.buildRemoteParams)||void 0===n||n.call(this,e,t),r&&(i=r.concat(i)),i.length&&(e[s]=t?this.encodeSorterParams(i):this.getSorterParams(i)),e}getSorterParams(e){return e.filter((e=>!e.sortFn)).map((({field:e,ascending:t})=>({field:e,ascending:t})))}afterPerformSort(e){if(e)return;const t=this;t._idMap=null;const n={action:"sort",sorters:t.sorters,records:t.allRecords};t.trigger("sort",n),t.trigger("refresh",n)}};const sa=()=>!0;var oa=e=>class extends(e||tt){static $name="StoreChained";static configurable={chainedFilterFn:null,chainedFields:null,masterStore:null,doRelayToMaster:["add","remove","insert"],dontRelayToMaster:[],excludeCollapsedRecords:!0,syncSort:!0,syncOrder:null,ignoreLinkRecords:null,chainFilters:null,chainSuspended:0};static get properties(){return{chainedStores:null,isChainedTree:null}}construct(e){super.construct(e);const t=this,{masterStore:n}=t;n&&(t.methodNamesToRelay.forEach((e=>t[e]=(...n)=>t.relayToMaster(e,n))),t.removeAll=(...e)=>{n.remove(t.getRange(),...e)},n.ion({name:"masterStoreListeners",changePreCommit:t.onMasterDataChangedPreCommit,change:t.onMasterDataChanged,prio:1,thisObj:t}),t.syncSort&&n.ion({sort:()=>t.sort(n.sorters),thisObj:t}),n.chainedStores||(n.chainedStores=[]),n.chainedStores.push(t),t.fillFromMaster())}get $master(){return this.masterStore||this}get isChained(){return Boolean(this.masterStore)}changeChainedFilterFn(e){return this.thisObj?e.bind(this.thisObj):e}get chainedFilterFn(){return this._chainedFilterFn||sa}get methodNamesToRelay(){const e=Array.isArray(this.doRelayToMaster),t=Array.isArray(this.dontRelayToMaster);return e&&this.doRelayToMaster.filter((e=>!t||!this.dontRelayToMaster.includes(e)))||[]}updateChainedStores(){var e;null===(e=this.chainedStores)||void 0===e||e.forEach((e=>e.fillFromMaster()))}fillFromMaster(){const e=this,{masterStore:t,isTree:n}=e,{isFiltered:i}=t;if(!e.isChained)throw new Error("fillFromMaster only allowed on chained store");if(e.isChainSuspended)return;let r,s=null;if(e.chainFilters&&i){const e=t.filters.values.filter((e=>!e.ignoreForChain));e.length&&(s=Eo.generateFiltersFunction(e))}if(e.isChainedTree)return e.fillTreeFromMaster(s);if(r=t.allRecords.filter((n=>{if(!n.isSpecialRow&&(!e.ignoreLinkRecords||!n.isLinked)&&e.chainedFilterFn(n)&&(!s||s(n)))return!(e.excludeCollapsedRecords&&!n.ancestorsExpanded(t))})),e.masterStore.sorterFn&&i&&t.isSorted&&!t.remoteSort&&r.sort(t.sorterFn),n)if(e.idRegister={},e.internalIdRegister={},r.forEach((t=>{t.stores.includes(e)?e.register(t):t.joinStore(e)})),e.excludeCollapsedRecords){const t=e.getChildren(e.rootNode);r=e.doIncludeExclude(t,!0)}else r.forEach((t=>t.instanceMeta(e).collapsed=!1));e.isFillingFromMaster=!0,e.data=r,e.isFillingFromMaster=!1}fillTreeFromMaster(e){const t=this,{chainedFilterFn:n}=t,i=t.masterStore.rootNode,r=[],s=t.treeLinkMap||{},o=t.idRegister={},a=t.internalIdRegister={};t.treeLinkMap={},co.postWalk({children:i.unfilteredChildren||i.children},(e=>!e.isLeaf&&(e.unfilteredChildren||e.children)),(i=>{var l;if(i.isLeaf&&(!e||e(i))&&n(i)||!i.isLeaf&&null!==(l=i.meta)&&void 0!==l&&null!==(l=l.tempChildren)&&void 0!==l&&l.length){var c;const e=null===(c=i.parent)||void 0===c?void 0:c.meta,n=s[i.id],l=i.isLeaf&&n,d=l||i.link(),u=d.proxyMeta.data;t.treeLinkMap[i.id]=d,l?(u.parent=u.parentIndex=u.unfilteredIndex=u.parentId=u.children=u.orderedChildren=u.unfilteredChildren=null,o[d.id]=n,a[d.internalId]=n):n&&d.removeLink(n),e.tempChildren||(e.tempChildren=[]),e.tempChildren.push(d),i.isParent&&r.unshift(d)}})),t.rootNode.meta.isFillingFromMaster=t.isFillingFromMaster=!0;for(let e=r.length-1;e>=0;e--){const t=r[e],{meta:n}=t.$original;n.tempChildren&&(t.meta.isFillingFromMaster=!0,t.appendChild(n.tempChildren,!0),t.meta.isFillingFromMaster=!1,n.tempChildren=null)}t.data=i.meta.tempChildren||[],t.rootNode.meta.isFillingFromMaster=t.isFillingFromMaster=!1,i.meta.tempChildren=null}commitToMaster(){const e=this,t=e.masterStore;if(!e.isChained)throw new Error("commitToMaster only allowed on chained store");return t.beginBatch(),t.remove(e.removed.values),t.add(e.added.values),t.endBatch(),e.commit()}relayToMaster(e,t){return this.masterStore[e](...t)}onMasterDataChangedPreCommit(e){this.onMasterDataChanged(e),this.$masterEventhandled=!0}onMasterDataChanged({action:e,changes:t,isMove:n}){var i;const r=this;r.$masterEventhandled?r.$masterEventhandled=!1:n&&"remove"===e||("update"!==e||"*"===r.chainedFields||null!==(i=r.chainedFields)&&void 0!==i&&i.some((e=>e in t))||"isLeaf"in t||"parentId"in t)&&r.fillFromMaster()}makeChained(e=sa,t,n){return q.deprecate("core","7.0.0","makeChained() deprecated in favor of chain() and chainTree()"),this.chain(e,t,n)}chain(e=sa,t,n){if(this.isChained){const t=e;e=e=>t(e)&&this.chainedFilterFn(e)}return new((null==n?void 0:n.storeClass)||this.constructor)({id:`${this.id}-chained-${V.generateUUID()}`,tree:!1,autoTree:!1,...n||{},masterStore:this.$master,modelClass:this.modelClass,syncDataOnLoad:!1,chainedFilterFn:e,chainedFields:t})}chainTree(e,t,n){if(!this.tree)throw new Error("chainTree only allowed on tree stores");return this.chain(e,t,{tree:!0,isChainedTree:!0,rootNode:this.rootNode.link(),...n})}doDestroy(){var e;this.detachListeners("masterStoreListeners"),null===(e=this.chainedStores)||void 0===e||e.forEach((e=>e.destroy())),super.doDestroy()}suspendChain(){this.chainSuspended++}resumeChain(e=!1){this.chainSuspended&&! --this.chainSuspended&&e&&this.fillFromMaster()}get isChainSuspended(){return this.chainSuspended>0}},aa=e=>class extends(e||tt){static $name="StoreState";getState(){const{sorters:e,groupers:t,filters:n}=this,i={};return null!=e&&e.length&&(i.sorters=e.map((e=>{const t=U.cleanupProperties(U.clone(e));return delete t.fn,delete t.sortFn,t}))),null!=t&&t.length&&(i.groupers=t.map((e=>{const t=U.cleanupProperties(U.clone(e));return delete t.fn,t})),i.collapsedGroups=[...this.collapsedGroups]),null!=n&&n.values.length&&(i.filters=n.allValues.map((e=>e.getState()))),i}applyState(e){var t;const n=this,{sorters:i=[],groupers:r=[],filters:s=[]}=e,{sortParamName:o,filterParamName:a}=n;(n.isSorted||0!==i.length||0!==r.length)&&(n.sorters=i.filter((e=>e.field||e.sortFn&&!o)),n.groupers=r.slice(),r.length?n.group():n.sort()),null===(t=e.collapsedGroups)||void 0===t||t.forEach((e=>{const t=n.getById(e);t&&n.collapse(t,!0)})),(n.isFiltered||0!==s.length)&&(n.filters=s.filter((e=>e.property||e.filterBy&&!a)),n.filter())}};const la=e=>String(e).padStart(6,"0");class ca{constructor(e){this.value=e,this._padded=null}set value(e){this._value=String(e??"")}get value(){return this._value}static from(e){return null==e||e instanceof ca?e:new ca(e)}static pad(e){return e instanceof ca?e.valueOf():ca.split(e).map(la).join(".")}static split(e){let t,n;if(e||0===e)switch(typeof e){case"object":e=String(e);case"string":for(n=e.split("."),t=n.length;t-- >0;)n[t]=parseInt(n[t],10);break;case"number":n=[e]}return n||[]}static compare(e,t){return e===t?0:e&&t?(e=ca.pad(e))<(t=ca.pad(t))?-1:t<e?1:0:e?1:t?-1:0}append(e){const t=this.value;return ca.from(t?`${t}.${e}`:e)}isEqual(e){return!ca.compare(this,e)}match(e){let t=!1;if(e){const n=this.value,i="*"===e[0],r=e.endsWith("*"),s=e.length;t=i===r?n.indexOf(i?e.substr(1,s-2):e)>-1:i?n.endsWith(e.substr(1)):n.startsWith(e.substr(0,s-1))}return t}toString(){return this.value}toJSON(){return this.toString()}valueOf(){return this._padded??(this._padded=ca.pad(this.value))}}ca._$name="Wbs";const da=Object.freeze([]),ua=Symbol("StopBranch"),ha=V.generateUUID();var ga=e=>class extends(e||tt){static $name="StoreTree";static StopBranch=ua;get StopBranch(){return ua}static configurable={transformFlatData:null,fireRemoveEventForMoveAction:!1,keepExpandedOnLoad:!1};get isTree(){var e;return this.tree??(null===(e=this.masterStore)||void 0===e?void 0:e.tree)}get leaves(){const e=[];return this.isTree?this.traverse((t=>{t.isLeaf&&e.push(t)})):this.allRecords.forEach((t=>{t.isLeaf&&e.push(t),t.traverse((t=>{t.isLeaf&&e.push(t)}),!0)})),e}async loadChildren(e){}onNodeAddChild(e,t,n,i,r=!1){const s=this,o=e===s.rootNode&&e.isLoading,{storage:a}=s,{previousSibling:l}=t[0];let c;const{visible:d,all:u}=s.collectDescendants(t,void 0,void 0,{inCollapsedBranch:!(e.isExpanded(s)&&e.ancestorsExpanded(s)),applyFilter:s.isFiltered&&s.reapplyFilterOnAdd});if(!o&&u.length)for(const e of u)s.modified.includes(e)||i[e.id]||(s.removed.includes(e)?s.removed.remove(e):e.isLinked||s.added.add(e));var h;if(o&&s.rootVisible&&(d.unshift(e),u.unshift(e)),d.length?(c=0!==n&&l?a.indexOf(l)+l.getDescendantCount(!0,s):a.indexOf(e),a.suspendEvents(),s.storage.splice(++c,0,d),a.resumeEvents(),s._idMap=null):s._allRecords=null,s.updateDependentStores("add",t),o&&d.length){if(s.sorters.length&&s.sort(null,null,!1,!0),null===(h=s.afterLoadData)||void 0===h||h.call(s),!r){const e={action:"dataset",data:s._data,records:d};s.trigger("refresh",e),s.trigger("change",e)}}else if(!r){const n={action:"add",parent:e,isChild:!0,isMove:i,records:t,allRecords:u,index:c};if(s.trigger("add",n),s.trigger("change",n),i&&Object.values(i).some((e=>e))){const n={newParent:e,records:t.filter((e=>i[e.id])),oldParents:t.map((e=>s.getById(e.meta.oldParentId)))};s.trigger("move",n)}}}onNodeRemoveChild(e,t,n,i={isMove:!1,silent:!1,unfiltered:!1}){const r=this,{storage:s}=r,o=[],a=[],{isMove:l,silent:c,unfiltered:d}=i,u=d&&r.isFiltered;if(r.collectDescendants(t,o,a,{inCollapsedBranch:!(e.isExpanded(r)&&e.ancestorsExpanded(r)),unfiltered:u}),!l){for(const e of t)e.unjoinStore(r);for(const e of a)e.stores.includes(r)&&e.unjoinStore(r),r.added.includes(e)?r.added.remove(e):e.isLinked||r.removed.add(e);r.modified.remove(a)}if(o.length?(n=s.indexOf(o[0]))>-1&&(s.suspendEvents(),s.splice(n,o.length),s.resumeEvents(),r._idMap=null):(n=-1,r._allRecords=null),!c&&(r.fireRemoveEventForMoveAction||!l)){const i={action:"remove",parent:e,isChild:!0,isMove:l,records:t,allRecords:a,index:n};r.trigger("remove",i),r.trigger("change",i)}return a}collectDescendants(e,t=[],n=[],i={}){const r=this,{inCollapsedBranch:s=!1,unfiltered:o=!1,applyFilter:a=!1}=i,l=Array.isArray(e)?e:r.getChildren(e,o)??[];if(a)return{visible:!s&&l.flatMap((e=>r.collectVisibleNodeDescendantsFiltered(e))),all:l.concat(l.flatMap((e=>e.allChildren)))};for(let e,i=0,a=l.length;i<a;i++)e=l[i],s||t.push(e),n.push(e),r.collectDescendants(e,t,n,{inCollapsedBranch:s||!e.isExpanded(r),unfiltered:o});return{visible:t,all:n}}collectVisibleNodeDescendantsFiltered(e){const t=e.unfilteredChildren||e.children;if(!t||0===t.length||!e.isLeaf&&!e.isExpanded(this))return this.filtersFunction(e)?[e]:[];const n=t.flatMap((e=>this.collectVisibleNodeDescendantsFiltered(e)));return n.length||this.filtersFunction(e)?[e].concat(n):[]}getChildren(e,t=!1){const n=this,i=n.isChained&&!n.isChainedTree,r=(t||i)&&e.unfilteredChildren||e.children;return null!=r&&r.length?i?r.filter(n.chainedFilterFn).sort(n.sorterFn):r:da}internalToggleTreeSubRecords(e,t){const n=this,{storage:i}=n,r=i.indexOf(e),s=n.doIncludeExclude(n.getChildren(e),t);if(n.isFiltered&&t&&e.unfilteredChildren&&n.updateChildrenHiddenState(e),s.length&&!1!==r){if(i.suspendEvents(),t){i.splice(r+1,0,s);const t={action:"add",isExpand:!0,parent:e,records:s,index:r+1};n.trigger("add",t),n.trigger("change",t)}else{i.splice(r+1,s.length);const t={action:"remove",isCollapse:!0,parent:e,records:s,index:r+1};n.trigger("remove",t),n.trigger("change",t)}i.resumeEvents(),n._idMap=null}}updateChildrenHiddenState(e){var t;null===(t=e.unfilteredChildren)||void 0===t||t.forEach((e=>{e.instanceMeta(this.id).hidden=!1,e.isLeaf||this.updateChildrenHiddenState(e)}))}doIncludeExclude(e,t,n=[]){const i=this,r=(null==e?void 0:e.length)||0;for(let s=0;s<r;s++){const r=e[s];if(!i.isChained||i.chainedFilterFn(r)){const e=r.instanceMeta(i.id);!t&&e.hidden||n.push(r),e.hidden=!t,r.isExpanded(i)&&i.doIncludeExclude(i.getChildren(r),t,n)}}return n}async toggleCollapse(e,t){const n=this,i=n.getById(e),r=i.instanceMeta(n);if(void 0===t&&(t=!r.collapsed),!r.isLoadingChildren&&!i.isLeaf&&i.isExpanded(n)===t){if(n.trigger("beforeToggleNode",{record:i,collapse:t}),r.collapsed=t,r.collapsed)return n.onNodeCollapse(i),!0;{n.onNodeExpand(i);let e=!0;if(!i.isLoaded){r.isLoadingChildren=!0;try{await n.loadChildren(i)}catch(t){r.collapsed=!0,e=!1,n.trigger("loadChildrenException",{record:i,exception:t})}finally{r.isLoadingChildren=!1}}return e}}}onNodeCollapse(e){if(e.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(e,!1)}onNodeExpand(e){if(e.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(e,!0)}transformToTree(e){var t;const{parentIdField:n,idField:i,childrenField:r}=this.modelClass,s=(null===(t=this.modelClass.fieldMap[n])||void 0===t?void 0:t.dataSource)||"parentId",o=new Map,a=new Set,l=[];for(const t of e){const e=null==t?void 0:t[i];null!=e&&o.set(e,t)}const c=e=>{const t=Object.assign({},e);return t[r]=[],o.set(t[i],t),a.add(e[i]),t};for(let t of e)if(t){const e=t[i];t=a.has(e)?o.get(e):c(t);const n=t[s];if(null!=n){let e=o.get(n);e&&(e[r]||(e=c(e)),e[r].push(t))}else t[r]?l.push(t):null!=t[i]?l.push(c(t)):l.push(t)}return o.forEach((e=>{var t,n;null===(t=(n=e[r]).sort)||void 0===t||t.call(n,((e,t)=>e.parentIndex-t.parentIndex))})),l}treeifyData(e,t,n,i=!1,r,s=null){const{length:o}=t,a=[],l=[],c={};let d,u;for(d=0;d<o;d++){let e=t[d];e=e.field||e,t[d].call||(t[d]=t=>t[e],t[d].fieldName=e),a[d]=new Map}co.preWalkWithParent({isRoot:!0,id:this.rootNode.id,children:e},(e=>e.children),((e,n)=>{if(u=[],n.isLeaf){for(d=0;d<o;d++){const e=t[d],i=r?r(e(n),e.fieldName):e(n),s=a[d],o=""===i?ha:i,l=rt.asArray(o)||[ha],c=[];if(l[0]===ua)break;(u.length>0?u:[null]).forEach((t=>{for(let i=0,{length:r}=l;i<r;i++){const r=l[i],o=`${((null==t?void 0:t.path)??"")+(null!=r&&r.isModel?r.id:r)}/`,a=V.makeValidDomId(`generated_${o}`,"_"),d=s.get(a)||s.set(a,{id:a,key:l[i]===ha?"":r,path:o,readOnly:!0,children:[],generatedParent:!0,field:e.fieldName,firstGroupChild:n}).get(a);c.push(d),t&&!t.children.includes(d)&&t.children.push(d)}})),u=c}u.length?u.forEach(((e,t)=>e.children.push(t?n.link():n))):l.push(n)}}),!0),(n||i)&&a.forEach((e=>e.forEach(((e,t,r)=>{null==n||n(e),i&&(e=this.createRecord(e),r.set(t,e))})))),c.children=[...a[0].values(),...l];const h=(e,n)=>((e,t,n)=>{if(e.isLeaf===t.isLeaf){if(e.isLeaf){let i;for(let r=0;!i&&r<n.length;r++){const s=n[r](e),o=n[r](t);if(s===ua||o===ua)return e.isLeaf<t.isLeaf?-1:e.isLeaf>t.isLeaf?1:0;i=s<o?-1:o<s?1:0}return i}return"string"==typeof e.key&&"string"==typeof t.key?e.key.localeCompare(t.key,void 0,{numeric:!0}):e.key<t.key?-1:e.key>t.key?1:0}return e.isLeaf<t.isLeaf?-1:e.isLeaf>t.isLeaf?1:0})(e,n,t),g=e=>{if(e.children){const t=s&&e.children.length&&!e.children[0].isLeaf;e.children.sort(t?s:h),e.children.forEach(g)}};return g(c),c}treeify(e,t,n=!1,i){return this.treeifyData(this.rootNode.children,e,t,!1,i)}treeifyFlatData(e){var t;const{childrenField:n,parentIdField:i}=this.modelClass,r=(null===(t=this.modelClass.fieldMap[i])||void 0===t?void 0:t.dataSource)||"parentId";let s=!1,o=!0;for(const t of e){if(null!=t&&t.isModel||Array.isArray(null==t?void 0:t[n])){o=!1;break}null!=(null==t?void 0:t[r])&&(s=!0)}return o&&s&&(e=this.transformToTree(e)),e}async indent(e){const t=this;if((e=(e=Array.isArray(e)?e:[e]).filter((t=>{let n=Boolean(t.previousSibling);for(;n&&!t.isRoot;)n=!e.includes(t.parent),t=t.parent;return n}))).length&&!1!==t.trigger("beforeIndent",{records:e})){e.sort(((e,t)=>ca.compare(e.wbsCode,t.wbsCode))),t.beginBatch();for(const n of e){const e=n.previousSibling;e.appendChild(n),t.toggleCollapse(e,!1)}t.endBatch(),t.trigger("indent",{records:e}),t.trigger("change",{action:"indent",records:e})}}async outdent(e){const t=this;if((e=(e=Array.isArray(e)?e:[e]).filter((t=>{const{parent:n}=t;let i=n&&!n.isRoot;for(;i&&!t.isRoot;)i=!e.includes(n),t=t.parent;return i}))).length&&!1!==t.trigger("beforeOutdent",{records:e})){e.sort(((e,t)=>ca.compare(e.wbsCode,t.wbsCode))),t.beginBatch();for(const n of e){const{parent:e}=n,i=e.children.slice(e.children.indexOf(n)+1);e.parent.insertChild(n,e.nextSibling),n.appendChild(i),t.toggleCollapse(n,!1)}t.endBatch(),t.trigger("outdent",{records:e}),t.trigger("change",{action:"outdent",records:e})}}},ma=e=>class extends(e||tt){static $name="StoreSync";static get configurable(){return{syncDataOnLoad:null,shouldSyncDataset:null,shouldSyncRecord:null,reorderOnSync:!0}}syncDataset(e){var t,n,i,r;const s=this,{storage:o}=s,a=(null===(t=s.shouldSyncDataset)||void 0===t?void 0:t.call(s,{data:e,store:s,records:s.records}))??(null===(n=s.project)||void 0===n||null===(i=n.shouldSyncDataset)||void 0===i?void 0:i.call(n,{data:e,store:s,records:s.records}));if(!1===a)return;s.trigger("startApplyChangeset"),s.isSyncingDataOnLoad=!0;const{toAdd:l,toRemove:c,toMove:d,updated:u,ids:h}=s.tree?s.syncTreeDataset(e,a):s.syncFlatDataset(e,a);let g=null===(r=s.syncDataOnLoad)||void 0===r?void 0:r.threshold,m=!1;if(g&&("string"==typeof g&&(g=parseInt(g,10)/100*s.count),m=l.length+c.length+d.length+u.length>g),s.tree){if(l.length){s.add(l,m).forEach((e=>e.clearParentId()))}if(d.length)for(const{parent:e,node:t,index:n}of d){s.getById(e.id).insertChild(t,n)}s.remove(c,m)}else m&&s.suspendEvents(),s.remove(c),s.add(l),m&&s.resumeEvents();g&&!m&&u.forEach((({record:e,toSet:t,wasSet:n})=>s.onModelChange(e,t,n))),s.$isSettingStoreFieldData||s.acceptChanges();const p={added:l,removed:c,updated:u,thresholdSurpassed:m};if(s.isFiltered&&!s.remoteFilter&&s.filter({silent:s.isRemoteDataLoading}),s.isGrouped)s.group(null,null,!1,!0,s.isRemoteDataLoading);else if(s.isSorted)s.remoteSort?o.replaceValues({values:o.values.sort(s.createSorterFn(s.sorters)),silent:!0}):s.sort();else if(s.reorderOnSync)if(s.tree){let e=!1,t=0;co.preWalk(s.rootNode,(t=>Array.isArray(t.children)&&!e?t.children:null),(n=>{n.id!==h[t++]&&(e=!0)})),e&&(s.sort(((e,t)=>h[e.id]-h[t.id]),void 0,void 0,!0),s.clearSorters(!0),!m&&s.afterPerformSort())}else o.values.some(((e,t)=>h[e.id]!==t))&&(o.replaceValues({values:o.values.sort(((e,t)=>h[e.id]-h[t.id])),silent:!0}),!m&&s.afterPerformSort());m&&s.trigger("refresh",{action:"batch",data:e,records:o.values,syncInfo:p}),s.isSyncingDataOnLoad=!1,s.trigger("endApplyChangeset"),s.trigger("loadSync",p)}syncFlatDataset(e,t){if(!e)return{toRemove:this.records};const n=this,{idField:i,allFields:r}=n.modelClass,s=[],o=[],a=[],l={},c={},d=t instanceof Set,{threshold:u,keepMissingValues:h}=n.syncDataOnLoad;let g=0;if(e.forEach(((e,s)=>{const m=(e=e.isModel?e.data:e)[i],p=n.getById(m);if(!d||t.has(m))if(p){if(n.shouldSyncRecord?!1!==n.shouldSyncRecord({record:p,data:e,store:n}):e!==p.data){var f,v;if(null===(f=n.beforeSyncRecord)||void 0===f||f.call(n,{record:p,data:e}),!1===h)for(const t of r)!(t.dataSource in e)&&t.dataSource in p.data&&(e[t.dataSource]=t.defaultValue);const t=p.set(e,null,Boolean(u));t&&a.push({record:p,wasSet:t,toSet:e}),null===(v=n.afterSyncRecord)||void 0===v||v.call(n,{record:p,data:e})}}else o.push(n.processRecord(n.createRecord(e)));p&&g++,l[m]=1,c[m]=s})),g<n.allRecords.filter((e=>!e.isSpecialRow)).length)if(t)for(const e of t)l[e]||s.push(n.getById(e));else n.forEach((e=>{l[e.id]||s.push(e)}),n,{includeFilteredOutRecords:!0,includeCollapsedGroupRecords:!0});return{toAdd:o,toRemove:s,toMove:[],updated:a,ids:c}}syncTreeDataset(e){if(!e)return{toRemove:this.records};const t=this,{idField:n,parentIdField:i,childrenField:r,allFields:s}=t.modelClass,{keepMissingValues:o,threshold:a}=t.syncDataOnLoad??{},l=[],c=[],d=[],u=[],h=new Set,g={};let m=0;return t.transformFlatData&&(e=t.treeifyFlatData(e)),co.preWalkWithParent({isRoot:!0,id:t.rootNode.id,children:e},(e=>e.children),((e,l)=>{if(e){const{id:p,node:f}=t.resolveSyncNode(l);if(f){if(t.shouldSyncRecord?!1!==t.shouldSyncRecord({record:f,data:l,store:t}):l!==f.data){let i;const c=f.children;let h;if(f.parent.id!==e[n]&&d.push({node:f,parent:e,index:e[r].indexOf(l)}),f!==l){if(!0!==c&&!0===l[r]&&(f.clearChildren(),f.data[r]=f.children=!0,delete l[r],t.toggleCollapse(f,!0),i=!0),!1===o)for(const e of s)"parentId"!==e.name&&!(e.dataSource in l)&&e.dataSource in f.data&&(l[e.dataSource]=e.defaultValue);"boolean"==typeof l.expanded&&this.toggleCollapse(f,!l.expanded),h=f.set(l,null,Boolean(a))}h?u.push({record:f,wasSet:h,toSet:l}):i&&f.signalNodeChanged({[r]:{value:!0,oldValue:c}})}h.add(f)}else l[i]=e[n],l.isModel?c.push(l):c.push({...l,...Array.isArray(l[r])?{children:[]}:void 0});g[p]=m++}})),t.totalCount!==h.size&&t.traverse((e=>{h.has(e)||l.push(e)})),{toAdd:c,toRemove:l,toMove:d,updated:u,ids:g}}resolveSyncNode(e){const t=e[this.modelClass.idField];return{id:t,node:this.getById(t)}}};class pa extends Error{constructor(...e){super(...e),this.name="RevisionException"}}pa._$name="RevisionException";const fa=()=>{throw new Error("Abstract method call!")},va=()=>{throw new Error("Method cannot be called at this state!")};class ya extends tt{canUndo(e){fa()}canRedo(e){fa()}canCheckoutTo(e){fa()}onUndo(e){fa()}onRedo(e){fa()}onCheckoutTo(e){fa()}onCheckoutToHead(e){fa()}onStartRevision(e,t){fa()}onStartTemporaryRevision(e,t,n){fa()}onStopRevision(e){fa()}onStartTransaction(e){fa()}onStopTransaction(e){fa()}onStopTransactionDelayed(e){fa()}onRejectTransaction(e){fa()}onEnable(e){fa()}onDisable(e){fa()}onAutoRecordOn(e){fa()}onAutoRecordOff(e){fa()}onResetQueue(e){fa()}onModelUpdate(e){fa()}onStoreModelAdd(e){fa()}onStoreModelInsert(e){fa()}onStoreModelRemove(e){fa()}onStoreModelRemoveAll(e){fa()}onModelInsertChild(e){fa()}onModelRemoveChild(e){fa()}}ya._$name="StateBase";const ba=Symbol("STATE_PROP"),Ca=Symbol("STORES_PROP"),Sa=Symbol("QUEUE_PROP"),wa=Symbol("POS_PROP"),Da=Symbol("ACTION_QUEUE_PROP"),Ea=Symbol("REVISION_NAMES_PROP"),xa=Symbol("REVISION_QUEUE_PROP"),Ra=Symbol("REVISION_INDEX_PROP"),Ta=Symbol("CURRENT_REV_ID_PROP"),Ma=Symbol("TRANSACTION_PROP"),Ia=Symbol("TRANSACTION_TIMER_PROP"),ka=Symbol("AUTO_RECORD_PROP"),Fa=Symbol("IS_APPLYING_STASH");Object.freeze([ba,Ca,Sa,wa,Da,Ea,xa,Ra,Ta,Ma,Ia,ka,Fa]);const Aa=new Map;var Pa=(e,t)=>{Aa.set(e,t)},La=e=>("string"==typeof e&&(e=Aa.get(e)),e);const Oa=(e,t)=>{const{undo:n,redo:i,revision:r}=t;let s;return s=n&&!i?{[Sa]:e[Sa].slice(e.position),[wa]:0}:i&&!n?{[Sa]:e[Sa].slice(0,e.position)}:{[Sa]:[],[wa]:0},r&&(s=Object.assign(s??{},{[Ea]:["base"],[Ra]:0,[xa]:[]})),[s,()=>{e.notifyStoresAboutQueueReset(t)}]};const $a=new class extends ya{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){va()}onRedo(){va()}onEnable(e){return e.autoRecord?"autoreadystate":"readystate"}onDisable(){va()}onAutoRecordOn(){return{[ka]:!0}}onAutoRecordOff(){return{[ka]:!1}}onStartTransaction(){va()}onStopTransaction(){va()}onStopTransactionDelayed(){va()}onRejectTransaction(){va()}onResetQueue(e,t){return Oa(e,t)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};Pa("disabledstate",$a);class _a extends tt{static configurable={inversed:!1};get type(){return this.constructor.name}undo(){fa()}redo(){fa()}invert(){const e=new this.constructor({...this.initialConfig,isUserInput:this.isUserInput,inversed:!0}),{undo:t,redo:n}=e;return e.undo=n,e.redo=t,e}}const ja="AddAction",Ba="InsertAction",Va="InsertChildAction",Ha="RemoveAction",za="RemoveAllAction",Na="RemoveChildAction",Wa="UpdateAction",Ua="EventUpdateAction";_a._$name="ActionBase";class Ga extends _a{static $name="UpdateAction";static configurable={model:void 0,newData:void 0,oldData:void 0,isInitialUserAction:!1};get type(){return Wa}changeModel(e){return e}changeNewData(e){return{...e}}changeOldData(e){return{...e}}undo(){const{model:e,oldData:t}=this;e.$&&Object.assign(e,t),e.set(t,null,null,null,Boolean(e.$))}redo(){const{model:e,newData:t}=this;e.$&&Object.assign(e,t),e.set(t,null,null,null,Boolean(e.$))}}Ga._$name="UpdateAction";class qa extends _a{static $name="InsertChildAction";static configurable={parentModel:void 0,childModels:void 0,insertIndex:void 0,orderedBeforeNode:void 0,context:void 0,stores:void 0};get type(){return Va}changeParentModel(e){return e}changeChildModels(e){return e.slice(0)}changeInsertIndex(e){return e}changeContext(e){return e}changeStores(e){return e}undo(){const{parentModel:e,context:t,childModels:n}=this,i=new Map,r=new Set;for(const s of n){const n=t.get(s);if(n){let t=i.get(n.parent);t||(t={moveRight:[],moveLeft:[],moveFromAnotherParent:[]},i.set(n.parent,t)),n.parent===e?n.index>s.parentIndex?t.moveRight.push({parent:n.parent,model:s,index:n.index+1}):t.moveLeft.push({parent:n.parent,model:s,index:n.index}):t.moveFromAnotherParent.push({parent:n.parent,model:s,index:n.index})}else r.add(s)}r.forEach((e=>{var t;return null===(t=e.parent)||void 0===t?void 0:t.removeChild(e)}));for(const e of i.values()){const{moveRight:t,moveLeft:n,moveFromAnotherParent:i}=e;i.forEach((e=>{e.parent.insertChild(e.model,e.index)})),n.sort(((e,t)=>e.index-t.index)),t.sort(((e,t)=>t.index-e.index))}for(const e of i.values()){const{moveRight:t,moveLeft:n}=e;n.forEach((e=>{e.parent.insertChild(e.model,e.index)})),t.forEach((e=>{e.parent.insertChild(e.model,e.index)}))}}redo(){var e,t;const{parentModel:n,insertIndex:i,childModels:r,orderedBeforeNode:s}=this,o=null===(e=n.children)||void 0===e?void 0:e[i];n.insertChild(r,o,!1,{orderedBeforeNode:s??(null==o||null===(t=o.previousSibling)||void 0===t?void 0:t.nextOrderedSibling)})}}qa._$name="InsertChildAction";class Ya extends _a{static $name="RemoveChildAction";static configurable={parentModel:void 0,childModels:void 0,context:void 0,stores:void 0};get type(){return Na}changeParentModel(e){return e}changeChildModels(e){return e.slice(0)}changeContext(e){return e}changeStores(e){return e}undo(){const{parentModel:e,context:t,childModels:n}=this;n.sort(((e,n)=>t.get(e).parentIndex-t.get(n).parentIndex)),n.forEach((n=>{const i=t.get(n);e.insertChild(n,i.parentIndex,void 0,{orderedParentIndex:i.orderedParentIndex})}))}redo(){this.parentModel.removeChild(this.childModels)}}Ya._$name="RemoveChildAction";class Ka extends _a{static $name="AddAction";static configurable={store:void 0,modelList:void 0,silent:!1};get type(){return ja}changeStore(e){return e}changeModelList(e){return e.slice(0)}undo(){this.store.remove(this.modelList,this.silent)}redo(){this.store.add(this.modelList,this.silent)}}Ka._$name="AddAction";class Xa extends _a{static $name="InsertAction";static configurable={store:void 0,modelList:void 0,insertIndex:void 0,context:void 0,silent:!1,reportUndoneRemoval:!0};get type(){return Ba}changeStore(e){return e}changeModelList(e){return e.slice(0)}changeInsertIndex(e){return e}changeContext(e){return e}undo(){const{store:e,modelList:t,context:n,silent:i,reportUndoneRemoval:r}=this;t.sort(((e,t)=>{const i=n.get(e),r=n.get(t);return void 0!==i&&void 0!==r?i-r:0})),t.forEach((t=>{const s=n.get(t);t._undoingInsertion=r,void 0!==s?e.insert(s,t,i):e.remove(t,i),t._undoingInsertion=!1}))}redo(){const e=this;e.store.insert(e.insertIndex,e.modelList,e.silent)}}Xa._$name="InsertAction";class Za extends _a{static $name="RemoveAction";static configurable={store:void 0,modelList:void 0,context:void 0,silent:!1};get type(){return Ha}changeStore(e){return e}changeModelList(e){return e.slice(0)}changeContext(e){return e}undo(){const{store:e,context:t,modelList:n,silent:i}=this;n.sort(((e,n)=>t.get(e)-t.get(n))),n.forEach((n=>{const r=t.get(n);e.insert(r,n,i)}))}redo(){this.store.remove(this.modelList,this.silent)}}Za._$name="RemoveAction";class Ja extends _a{static $name="RemoveAllAction";static configurable={store:void 0,allRecords:void 0,silent:!1};get type(){return za}changeStore(e){return e}changeAllRecords(e){return e.slice(0)}undo(){const{store:e,allRecords:t,silent:n}=this;e.add(t,n)}redo(){this.store.removeAll(this.silent)}}Ja._$name="RemoveAllAction";const Qa=(e,t,n,i)=>new Ga({model:e,newData:t,oldData:n,isInitialUserAction:i}),el=(e,t,n,i,r,s)=>new qa({parentModel:e,childModels:n,insertIndex:t,orderedBeforeNode:r,context:i,stores:s}),tl=(e,t,n,i)=>new Ya({parentModel:e,childModels:t,context:n,stores:i}),nl=(e,t,n)=>new Ka({store:e,modelList:t,silent:n}),il=(e,t,n,i,r)=>new Xa({store:e,insertIndex:t,modelList:n,context:i,silent:r}),rl=(e,t,n,i)=>new Za({store:e,modelList:t,context:n,silent:i}),sl=(e,t,n)=>new Ja({store:e,allRecords:t,silent:n}),ol="DATA_CORRECTION",al="TEMPORARY",ll="CONFLICT_RESOLUTION";class cl extends tt{static get configurable(){return{title:null,committed:!1,inputGeneration:0}}static from(e,t={}){const n=new this({...this.initialConfig,...t,inputGeneration:e.reduce(((e,t)=>Math.max(e,t.inputGeneration??0)),0),committed:!1});return n[Da]=e.flatMap((e=>e[Da].filter((n=>e.inputGeneration>0?t.conflictResolutionFor?n.isUserInput===e.inputGeneration:n.isUserInput:n)))),n}static createTransactionWithOriginalInput(e){const t=new this({...this.initialConfig,title:e.title,committed:!1});return t[Da]=e[Da].filter((e=>e.isUserInput?1===e.isUserInput:!e.isUserInput)),t}construct(...e){this[Da]=[],super.construct(...e)}get queue(){return this[Da].slice(0)}get length(){return this[Da].length}get filterUserInput(){return this.inputGeneration>0}addAction(e){Array.isArray(e)||(e=[e]),this[Da].push(...e)}undo(){const e=this[Da];for(let t=e.length-1;t>=0;--t)e[t].undo()}redo(){const e=this[Da];for(let t=0,n=e.length;t<n;++t)e[t].redo()}mergeUpdateModelActions(){const e=this[Da],t=new Map,n=[];for(const s of e){var i;if(s.isUpdateAction&&null!==(i=s.model)&&void 0!==i&&i.isModel){const e=s.isUserInput??0;let i=t.get(s.model);i||(i=[],t.set(s.model,i));const r=i[e];if(r)for(const e in s.oldData)s.newData.hasOwnProperty(e)&&(r.oldData.hasOwnProperty(e)||(r.oldData[e]=s.oldData[e]),r.newData[e]=s.newData[e]);else i[e]=s,n.push(s)}else{var r;if(n.push(s),s.isRemoveAction&&null!==(r=s.modelList)&&void 0!==r&&r.length)for(const e of s.modelList)t.delete(e)}}this[Da]=n,this.inputGeneration=Math.max(...n.map((e=>e.isUserInput??0)),0)}mergeAddUpdateModelActions(){const e=this[Da],t=new Set,n=[];for(const i of e)i.isAddAction||i.isInsertAction?i.modelList.forEach((e=>t.add(e))):i.isInsertChildAction&&i.childModels.forEach((e=>t.add(e))),(i.isUpdateAction||i.isEventUpdateAction)&&t.has(i.model)||n.push(i);this[Da]=n,this.inputGeneration=Math.max(...n.map((e=>e.isUserInput??0)),0)}invert(){const e=new this.constructor({...this.initialConfig,title:this.title});return e[Da]=this[Da].map((e=>(e=>e.invert())(e))).reverse(),e}groupUserInput(){return this[Da].reduce(((e,t)=>{const n=t.isUserInput??"default";return e.has(n)||e.set(n,[]),e.get(n).push(t),e}),new Map)}getUserInput(e){const t=new Map,n={},i=this.groupUserInput().get(e??(this.inputGeneration||"default")),r=(e,t)=>(t in n?e in n[t]||(n[t][e]=[]):n[t]={[e]:[]},n[t][e]);for(const s of i)switch(s.type){case ja:case Ba:if(s.inversed){r("removed",s.store.id).push(...s.modelList)}else{r("added",s.store.id).push(...s.modelList)}break;case Ha:case za:if(s.inversed){r("added",s.store.id).push(...s.modelList||s.allRecords)}else{r("removed",s.store.id).push(...s.modelList||s.allRecords)}break;case Va:{const o=(e,t)=>{var n;t.added.includes(e)?r("added",t.id).push(e):t.removed.includes(e)&&r("removed",t.id).push(e),null===(n=e.children)||void 0===n||n.forEach((e=>o(e,t)))};for(const a of s.stores)s.childModels.forEach((e=>o(e,a))),a.modified.forEach((e=>{const n=e.hierarchyModificationDataToWrite;n&&(t.has(e)?t.set(e,{...t.get(e),...n}):t.set(e,n))}));break}case Na:{function l(e,t){e.forEach((e=>{t.push(e),e.children&&l(e.children,t)}))}for(const c of s.stores)if(s.inversed){const d=r("added",c.id);l(s.childModels,d)}else{const u=r("removed",c.id);l(s.childModels,u)}break}case Wa:case Ua:t.has(s.model)?t.set(s.model,{...t.get(s.model),...s[s.inversed?"oldData":"newData"]}):t.set(s.model,{...s[s.inversed?"oldData":"newData"]})}if(t.size>0&&(n.updated=t),Object.keys(n).length>0)return n}markCurrentTransactionContentUserInput(){const e=this.inputGeneration+1,t=this[Da];let n=!1;t.forEach((t=>{void 0!==t.isUserInput||t.isCalculated||(t.isUserInput=e,n=!0)})),n&&(this.inputGeneration=e)}markCurrentTransactionContentCalculated(){const e=this.inputGeneration;this[Da].forEach((t=>{void 0!==t.isCalculated||t.isUserInput||(t.isCalculated=e)}))}normalizeUserInputGeneration(){this[Da].forEach((e=>e.isUserInput=this.inputGeneration))}}cl._$name="Transaction";class dl extends ya{canUndo(e){return 0<e.position&&e.position<=e.length}canRedo(e){return 0<=e.position&&e.position<e.length}canCheckoutTo(e,t){return e.revisionsEnabled?!!e[Ea].includes(t)||(console.warn("Revision is not found"),!1):(console.warn("Revisions are disabled"),!1)}onUndo(e,t){let n=e.position;const i=e[Sa],r=Math.max(0,n-t);return[{[ba]:"restoringstate",[wa]:r},()=>{e.notifyStoresAboutStateRestoringStart();const t=[];for(;n!==r;){const e=i[--n];e.undo(),t.push(e)}return[e.autoRecord?"autoreadystate":"readystate",()=>{e.notifyStoresAboutStateRestoringStop({cause:"undo",transactions:t})}]}]}onRedo(e,t){let n=e.position;const i=e[Sa],r=Math.min(i.length,n+t);return[{[ba]:"restoringstate",[wa]:r},()=>{e.notifyStoresAboutStateRestoringStart();const t=[];do{const e=i[n++];e.redo(),t.push(e)}while(n!==r);return[e.autoRecord?"autoreadystate":"readystate",()=>{e.notifyStoresAboutStateRestoringStop({cause:"redo",transactions:t})}]}]}onCheckoutTo(e,t){const n=e[Ea].indexOf(t),i=Math.min(n,e[Ra]),r=Math.max(n,e[Ra]),s=n<e[Ra];let o=e[xa].slice(i,r);if(s){o=o.filter((e=>!e.conflictResolutionFor||e.type===al)).reverse();e[xa].filter(((e,t)=>t>=i&&e.dummy)).forEach((t=>{e[xa].splice(e[xa].indexOf(t),1),e[Ea].splice(e[Ea].indexOf(t.title),1)}))}return[{[ba]:"checkoutstate",[Ra]:n},()=>{e.notifyStoresAboutCheckoutStart();for(const e of o)e[s?"undo":"redo"]()}]}onCheckoutToHead(e){va()}onEnable(){va()}onDisable(){return"disabledstate"}onAutoRecordOn(){return{[ba]:"autoreadystate",[ka]:!0}}onAutoRecordOff(){va()}onStartTransaction(e,t){const n=new cl({title:t});return[{[ba]:"recordingstate",[Ma]:n},()=>{e.notifyStoresAboutStateRecordingStart(n)}]}onStopTransaction(){va()}onStopTransactionDelayed(){va()}onRejectTransaction(){va()}onResetQueue(e,t){return Oa(e,t)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}}const ul=new dl;Pa("readystate",ul);class hl extends ya{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onEnable(){}onDisable(e){const t=e[Ma];return e.notifyStoresAboutStateRecordingStop(t,{disabled:!0}),{[ba]:"disabledstate",[Ma]:null}}onAutoRecordOn(e){return[{[ba]:"autorecordingstate",[ka]:!0},()=>{e.stopTransactionDelayed()}]}onAutoRecordOff(){va()}onStartTransaction(){va()}onStopTransaction(e,t){const n=e[Ma],i=e[Sa];let r=e[wa];return n.length&&(n.title||t||!e.getTransactionTitle?t&&(n.title=t):n.title=e.getTransactionTitle(n),i[r]=n,i.length=++r),[{[ba]:"readystate",[wa]:r,[Ma]:null},()=>{e.notifyStoresAboutStateRecordingStop(n,{stop:!0})}]}onRejectTransaction(e){const t=e[Ma];return[{[ba]:"restoringstate",[Ma]:null},()=>(t.length&&t.undo(),["readystate",()=>{e.notifyStoresAboutStateRecordingStop(t,{rejected:!0})}])]}onStopTransactionDelayed(){va()}onResetQueue(e,t){return Oa(e,t)}onModelUpdate(e,t,n,i,r){e[Ma].addAction(e.makeModelUpdateAction(t,n,i,r))}onModelInsertChild(e,t,n,i,r,s){const o=e[Ma],a=t.stores.filter((t=>e.stores.includes(t)));o.addAction(e.makeModelInsertChildAction(t,n,i,r,s,a))}onModelRemoveChild(e,t,n,i){const r=e[Ma],s=t.stores.filter((t=>e.stores.includes(t)));r.addAction(e.makeModelRemoveChildAction(t,n,i,s))}onStoreModelAdd(e,t,n,i){e[Ma].addAction(e.makeStoreModelAddAction(t,n,i))}onStoreModelInsert(e,t,n,i,r,s){const o=e[Ma],a=e.makeStoreModelInsertAction(t,n,i,r,s);a.reportUndoneRemoval=!e.revisionsEnabled,o.addAction(a)}onStoreModelRemove(e,t,n,i,r){e[Ma].addAction(e.makeStoreModelRemoveAction(t,n,i,r))}onStoreRemoveAll(e,t,n,i){e[Ma].addAction(e.makeStoreRemoveAllAction(t,n,i))}}const gl=new hl;Pa("recordingstate",gl);const ml=new class extends ya{static $name="RestoringStateClass";canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){va()}onRedo(){va()}onEnable(){va()}onDisable(){va()}onAutoRecordOn(){return{[ka]:!0}}onAutoRecordOff(){return{[ka]:!1}}onStartTransaction(){va()}onStopTransaction(){va()}onStopTransactionDelayed(){va()}onRejectTransaction(){va()}onQueueReset(){va()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};Pa("restoringstate",ml);const pl=new class extends dl{onAutoRecordOn(){va()}onAutoRecordOff(){return{[ba]:"readystate",[ka]:!1}}onStartTransaction(e,t){const n=new cl({title:t});return[{[ba]:"autorecordingstate",[Ma]:n},()=>{e.notifyStoresAboutStateRecordingStart(n),e.stopTransactionDelayed()}]}onModelUpdate(e,t,n,i){e.startTransaction(),e.onModelUpdate(t,n,i)}onModelInsertChild(e,t,n,i,r){e.startTransaction(),e.onModelInsertChild(t,n,i,r)}onModelRemoveChild(e,t,n,i){e.startTransaction(),e.onModelRemoveChild(t,n,i)}onStoreModelAdd(e,t,n,i){e.startTransaction(),e.onStoreModelAdd(t,n,i)}onStoreModelInsert(e,t,n,i,r,s){e.startTransaction(),e.onStoreModelInsert(t,n,i,r,s)}onStoreModelRemove(e,t,n,i,r){e.startTransaction(),e.onStoreModelRemove(t,n,i,r)}onStoreRemoveAll(e,t,n,i){e.startTransaction(),e.onStoreRemoveAll(t,n,i)}};Pa("autoreadystate",pl);class fl extends(hl.mixin(nn)){onDisable(e){const t=e[Ma],n=e[Ia];return n&&this.clearTimeout(n),e.notifyStoresAboutStateRecordingStop(t,{disabled:!0}),{[ba]:"disabledstate",[Ma]:null,[Ia]:null}}onAutoRecordOn(e){va()}onAutoRecordOff(e){const t=e[Ia];return t&&this.clearTimeout(t),{[ba]:"recordingstate",[ka]:!1,[Ia]:null}}onStopTransaction(e,t){const n=e[Ma],i=e[Ia],r=e[Sa];let s=e[wa];return i&&this.clearTimeout(i),n.length&&(n.title||t||!e.getTransactionTitle?t&&(n.title=t):n.title=e.getTransactionTitle(n),r[s]=n,r.length=++s),[{[ba]:"autoreadystate",[wa]:s,[Ma]:null,[Ia]:null},()=>{e.notifyStoresAboutStateRecordingStop(n,{stop:!0})}]}onStopTransactionDelayed(e){let t=e[Ia];return t&&this.clearTimeout(t),t=this.setTimeout((()=>{e.stopTransaction()}),e.autoRecordTransactionStopTimeout),{[ba]:vl,[Ia]:t}}onResetQueue(e,t){return Oa(e,t)}onRejectTransaction(e){const t=e[Ma],n=e[Ia];return n&&this.clearTimeout(n),[{[ba]:"restoringstate",[Ma]:null,[Ia]:null},()=>(t.length&&t.undo(),["autoreadystate",()=>{e.notifyStoresAboutStateRecordingStop(t,{rejected:!0})}])]}onModelUpdate(e,...t){super.onModelUpdate(e,...t),e.stopTransactionDelayed()}onModelInsertChild(e,...t){super.onModelInsertChild(e,...t),e.stopTransactionDelayed()}onModelRemoveChild(e,...t){super.onModelRemoveChild(e,...t),e.stopTransactionDelayed()}onStoreModelAdd(e,...t){super.onStoreModelAdd(e,...t),e.stopTransactionDelayed()}onStoreModelInsert(e,...t){super.onStoreModelInsert(e,...t),e.stopTransactionDelayed()}onStoreModelRemove(e,...t){super.onStoreModelRemove(e,...t),e.stopTransactionDelayed()}onStoreRemoveAll(e,...t){super.onStoreRemoveAll(e,...t),e.stopTransactionDelayed()}}const vl=new fl;Pa("autorecordingstate",vl);const yl=new class extends dl{canUndo(e){return!1}canRedo(e){return!1}onUndo(e){va()}onRedo(e){va()}onStartRevision(e,t){const n=new cl({title:t});return[{[ba]:"revisionrecordingstate",[Ma]:n},()=>{e.notifyStoresAboutRevRecordingStart()}]}onStartTemporaryRevision(e,t,n){const i=new cl({title:t});return n&&(i[Da]=n[Da].slice()),[{[ba]:"temporaryrevisionrecordingstate",[Ma]:i},()=>{e.notifyStoresAboutTempRevRecordingStart()}]}onCheckoutToHead(e){return e.notifyStoresAboutCheckoutToHead({revision:e[Ea][e[Ea].length-1]}),e.autoRecord?"autoreadystate":"readystate"}onStartTransaction(e){va()}onStopTransaction(e){va()}onStopTransactionDelayed(e){va()}onRejectTransaction(e){va()}onEnable(e){va()}onDisable(e){va()}onAutoRecordOn(e){va()}onAutoRecordOff(e){va()}onResetQueue(e){va()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};Pa("checkoutstate",yl);const bl=new class extends hl{canUndo(e){return!1}canRedo(e){return!1}canCheckoutTo(){return!1}onUndo(e){va()}onRedo(e){va()}onCheckoutToHead(e){va()}onStopRevision(e,t){const n=e[Ma],i=e[xa],r=e[Ea],s=e[Ra]+1,o=cl.createTransactionWithOriginalInput(n);return r.splice(s,0,o.title),i.splice(s-1,0,o),e.commitRevision(o.title),[{[ba]:"checkoutstate",[Ra]:s,[Ma]:null},()=>{e.notifyStoresAboutRevRecordingStop(o)}]}onStartTransaction(e){va()}onStopTransaction(e){va()}onStopTransactionDelayed(e){va()}onRejectTransaction(e){va()}onEnable(e){va()}onDisable(e){va()}onAutoRecordOn(e){va()}onAutoRecordOff(e){va()}onResetQueue(e){va()}};Pa("revisionrecordingstate",bl);const Cl=new class extends hl{canUndo(e){return!1}canRedo(e){return!1}canCheckoutTo(){return!1}onUndo(e){va()}onRedo(e){va()}onCheckoutToHead(e){va()}onStopRevision(e,t){const n=e[Ma];return[{[ba]:"checkoutstate",[Ma]:null},()=>{e.notifyStoresAboutTempRevRecordingStop(n)}]}onStartTransaction(e){va()}onStopTransaction(e){va()}onStopTransactionDelayed(e){va()}onRejectTransaction(e){va()}onEnable(e){va()}onDisable(e){va()}onAutoRecordOn(e){va()}onAutoRecordOff(e){va()}onResetQueue(e){va()}};Pa("temporaryrevisionrecordingstate",Cl);const Sl=(e,t,...n)=>{const i=e.state,r=t.call(e[ba],e,...n);if("string"==typeof r)e[ba]=La(r);else if(r instanceof ya)e[ba]=r;else if(Array.isArray(r)){const[t,i]=r;"string"==typeof t?e[ba]=La(t):t instanceof ya?e[ba]=t:t&&"object"==typeof t&&((e=Object.assign(e,t))[ba]=La(e[ba])),"function"==typeof i&&Sl(e,i,...n)}else r&&"object"==typeof r&&((e=Object.assign(e,r))[ba]=La(e[ba]));i!==ul&&i!==pl&&r!==ul&&r!==pl&&e.trigger("ready")};class wl extends(dt(tt)){static $name="StateTrackingManager";static configurable={disabled:!0,autoRecord:!1,autoRecordTransactionStopTimeout:100,autoRecordMergeUpdateActions:!0,mergeAddUpdateActions:!1,makeModelUpdateAction:Qa,makeModelInsertChildAction:el,makeModelRemoveChildAction:tl,makeStoreModelAddAction:nl,makeStoreModelInsertAction:il,makeStoreModelRemoveAction:rl,makeStoreRemoveAllAction:sl,getTransactionTitle:null,revisionsEnabled:!1,asyncUndoRedo:!1,revisionLocalPrefix:"local-",revisionQueueMaxLength:20,revisionQueueCommittedMinLength:1};construct(...e){Object.assign(this,{[ba]:ul,[Ca]:[],[Sa]:[],[wa]:0,[Ma]:null,[Ia]:null,[ka]:!1,[Fa]:!1,stashedTransactions:{}}),super.construct(...e)}get state(){return this[ba]}get position(){return this[wa]}get length(){return this[Sa].length}get stores(){return Array.from(this[Ca])}hasStore(e){return this[Ca].includes(e)}addStore(e){this.hasStore(e)||(this[Ca].push(e),e.stm=this,e.forEach((e=>e.stm=this)),e.isTree&&(e.rootNode.stm=this))}removeStore(e){this.hasStore(e)&&(this[Ca]=this[Ca].filter((t=>t!==e)),e.stm=null,e.forEach((e=>e.stm=null)))}forEachStore(e){this[Ca].forEach((t=>e(t,t.id)))}get disabled(){return this.state===$a}changeDisabled(e){if(this.disabled!==e)return e}updateDisabled(e){const t=this;Sl(t,e?t.state.onDisable:t.state.onEnable,t),t.trigger("stmDisabled",{disabled:e}),t.trigger("disabled",{disabled:e})}get enabled(){return!this.disabled}enable(){this.disabled=!1}disable(){this.disabled=!0}get isReady(){return this.state===ul||this.state===pl}waitForReadiness(){return this.await("ready",!1)}get isRecording(){return this.state===gl||this.state===vl}get isApplyingStash(){return this[Fa]}get shouldRecordAction(){return this.enabled&&(!this.isRestoringState||this.isApplyingStash)&&!this.isCheckingOut}get autoRecord(){return this[ka]}changeAutoRecord(e){if(this.autoRecord!==e)return e}updateAutoRecord(e){const t=this;Sl(t,e?t.state.onAutoRecordOn:t.state.onAutoRecordOff,t)}startTransaction(e=null){Sl(this,this.state.onStartTransaction,e)}stopTransaction(e=null){const t=this;t.autoRecord&&t.autoRecordMergeUpdateActions&&t.mergeTransactionUpdateActions(),t.mergeAddUpdateActions&&t.mergeTransactionAddUpdateActions(),Sl(t,t.state.onStopTransaction,e)}stopTransactionDelayed(){Sl(this,this.state.onStopTransactionDelayed)}rejectTransaction(){Sl(this,this.state.onRejectTransaction)}get transaction(){return this[Ma]}get queue(){return this[Sa].map((e=>e.title))}get rawQueue(){return this[Sa]}get isRestoringState(){return this.state===ml}get isRestoring(){return this.state===ml||this.isApplyingStash||this.isNavigatingRevisions}get canUndo(){return this.state.canUndo(this)}get canRedo(){return this.state.canRedo(this)}async undo(e=1){this.isReady||await this.waitForReadiness(),Sl(this,this.state.onUndo,e)}async undoAll(){this.isReady||await this.waitForReadiness(),this.undo(this.length)}async redo(e=1){this.isReady||await this.waitForReadiness(),Sl(this,this.state.onRedo,e)}async redoAll(){this.isReady||await this.waitForReadiness(),this.redo(this.length)}resetQueue(e={undo:!0,redo:!0,revision:!0}){Sl(this,this.state.onResetQueue,e)}resetUndoQueue(){this.resetQueue({undo:!0})}resetRedoQueue(){this.resetQueue({redo:!0})}resetRevisionQueue(){this.resetQueue({revision:!0})}notifyStoresAboutStateRecordingStart(e){this.forEachStore((t=>{var n;return null===(n=t.onStmRecordingStart)||void 0===n?void 0:n.call(t,this,e)})),this.trigger("recordingStart",{stm:this,transaction:e})}notifyStoresAboutStateRecordingStop(e,t){const n=this;n.forEachStore((i=>{var r;return null===(r=i.onStmRecordingStop)||void 0===r?void 0:r.call(i,n,e,t)})),n.trigger("recordingStop",{stm:n,transaction:e,reason:t}),n.revisionsEnabled&&t.stop&&n.increaseRevision(cl.from([e]))}notifyStoresAboutStateRestoringStart(){this.forEachStore((e=>{var t;return null===(t=e.onStmRestoringStart)||void 0===t?void 0:t.call(e,this)})),this.trigger("restoringStart",{stm:this})}notifyStoresAboutStateRestoringStop({cause:e,transactions:t}){const n=this;if(n.forEachStore((e=>{var t;return null===(t=e.onStmRestoringStop)||void 0===t?void 0:t.call(e,n)})),n.trigger("restoringStop",{stm:n,cause:e,transactions:t}),n.revisionsEnabled)if(n.asyncUndoRedo){const i=()=>{const i=cl.from(t);n.increaseRevision("undo"===e?i.invert():i)};n.trigger("increaseRevisionAsync",{callback:i})}else{const i=cl.from(t);n.increaseRevision("undo"===e?i.invert():i)}}notifyStoresAboutQueueReset(e){this.forEachStore((t=>{var n;return null===(n=t.onStmQueueReset)||void 0===n?void 0:n.call(t,this,e)})),this.trigger("queueReset",{stm:this,options:e})}notifyStoresAboutCheckoutStart(){this.trigger("checkoutStart",{stm:this})}notifyStoresAboutRevRecordingStart(){this.trigger("revisionRecordingStart",{stm:this})}notifyStoresAboutTempRevRecordingStart(){this.trigger("temporaryRevisionRecordingStart",{stm:this})}notifyStoresAboutRevRecordingStop(e){this.trigger("revisionRecordingStop",{stm:this,revision:e.title})}notifyStoresAboutTempRevRecordingStop(e){this.trigger("temporaryRevisionRecordingStop",{stm:this,revision:e.title})}notifyStoresAboutCheckoutToHead({revision:e}){this.trigger("checkoutToHead",{stm:this,revision:e})}onModelUpdate(e,t,n,i){Sl(this,this.state.onModelUpdate,e,t,n,i)}onModelInsertChild(e,t,n,i,r){Sl(this,this.state.onModelInsertChild,e,t,n,i,r)}onModelRemoveChild(e,t,n){Sl(this,this.state.onModelRemoveChild,e,t,n)}onStoreModelAdd(e,t,n){Sl(this,this.state.onStoreModelAdd,e,t,n)}onStoreModelInsert(e,t,n,i,r){Sl(this,this.state.onStoreModelInsert,e,t,n,i,r)}onStoreModelRemove(e,t,n,i){Sl(this,this.state.onStoreModelRemove,e,t,n,i)}onStoreRemoveAll(e,t,n){Sl(this,this.state.onStoreRemoveAll,e,t,n)}onUndoKeyPress(e){const t=this;t.enabled&&(e.shiftKey?t.canRedo&&(e.preventDefault(),t.redo()):t.canUndo&&(e.preventDefault(),t.undo()))}stash(){const e=this;if(e.transaction){const t=Ro.generateId("_stashedTransactionGeneratedId_");return e.stashedTransactions[t]=e.transaction,e.rejectTransaction(),t}}applyStash(e){const t=this,n=t.stashedTransactions[e];t[Fa]=!0,n&&(t.startTransaction(n.title),n.redo(),delete t.stashedTransactions[e]),t[Fa]=!1}mergeTransactionUpdateActions(e=this.transaction){e.mergeUpdateModelActions()}mergeTransactionAddUpdateActions(e=this.transaction){e.mergeAddUpdateModelActions()}canCheckoutTo(e){return(this.isReady||this.state===yl)&&this.state.canCheckoutTo(this,e)}get currentRevision(){if(this.revisionsEnabled)return this[Ea][this[Ra]]}get lastRevision(){if(this.revisionsEnabled)return this[Ea][this[Ea].length-1]}get currentRevisionTransaction(){if(this.revisionsEnabled)return this[xa][this[Ra]-1]}get lastCommittedRevision(){const e=this[xa];let t;for(let n=e.length-1;n>=0;n--)if(e[n].committed){t=e[n];break}return t}get lastCommittedRevisionId(){var e;return(null===(e=this.lastCommittedRevision)||void 0===e?void 0:e.title)??this[Ea][0]}get localRevisions(){return this[xa].slice(this[xa].findIndex((e=>!e.committed)))}get isCheckingOut(){return this.state===yl}get isRecordingRevision(){return this.state===bl}get isRecordingTemporaryRevision(){return this.state===Cl}get isNavigatingRevisions(){return this.state===yl||this.state===bl||this.state===Cl}initRevision(e,t=!0){const n=this;n.revisionsEnabled&&(n.autoRecord=t,n[Ea]=[e],n[xa]=[],n[Ra]=0)}increaseRevision(e,t){const n=this;let i;if(!(Ea in n))throw new Error("Revisions should be initialized first with `project.initRevisions(<client id>)` call");if(!n.revisionsEnabled)return;if(n.isNavigatingRevisions&&!e.type)throw new pa("Cannot add new revision when in the checkout state");if(!e[Da].length&&!e.type)return;const r=Ro.generateId(n.revisionLocalPrefix);e.title=r;const s=e.type===ll;if(!1===n.trigger("beforeRevisionAdd",{localRevisionId:r,isConflictResolution:s}))return;const o=e.conflictResolutionFor&&n[xa].find((t=>t.type===al&&t.conflictResolutionFor===e.conflictResolutionFor));if(o?(n[Ea].splice(n[Ea].indexOf(o.title),1,r),n[xa].splice(n[xa].indexOf(o),1,e)):(n[Ea].push(r),n[xa].push(e)),e.conflictResolutionFor||(n[Ra]=n[Ea].length-1),e.type===al)return;e.filterUserInput&&(e.conflictResolutionFor||e.normalizeUserInputGeneration(),i=e.getUserInput()),!t&&n[xa].length>n.revisionQueueMaxLength&&!e.type&&n.cleanUpRevisions();const a={localRevisionId:r,userInput:i};e.conflictResolutionFor&&(a.conflictResolutionFor=e.conflictResolutionFor,a.revisionChanges=t),n.trigger("revisionAdd",a)}createDataCorrectionTransaction(){const e=new cl({type:ol});this.increaseRevision(e)}createConflictResolutionRevision(e,t,n){const{transaction:i}=this;if(n=U.clone(n),t){const n=this[xa].find((e=>e.conflictResolutionFor===t));n&&(n.conflictResolutionFor=e)}this.increaseRevision(cl.from([i],{conflictResolutionFor:e??i.title,type:ll}),n)}createTemporaryConflictResolutionRevision(e,t){const{transaction:n}=this;this.increaseRevision(cl.from([n],{conflictResolutionFor:e??n.title,type:al}),t)}checkoutTo(e){if(!this.canCheckoutTo(e))return!1;Sl(this,this.state.onCheckoutTo,e)}checkoutToLastCommittedRevision(){this.checkoutTo(this.lastCommittedRevisionId)}checkoutToHead(){this.checkoutTo(this[Ea][this[Ea].length-1]),Sl(this,this.state.onCheckoutToHead)}checkoutToNext(){return this[Ra]+1<this[Ea].length&&this.checkoutTo(this[Ea][this[Ra]+1])}startRevision(e){Sl(this,this.state.onStartRevision,e)}stopRevision(){Sl(this,this.state.onStopRevision)}startTemporaryRevision(e,t){Sl(this,this.state.onStartTemporaryRevision,e,t)}stopTemporaryRevision(){Sl(this,this.state.onStopRevision)}commitRevision(e,t){const n=this[Ea],i=this[xa],r=i.find((t=>t.title===e));for(let e=i.indexOf(r)-1;e>=0;e--)if(!1===i[e].committed&&i[e].type!==al&&!i[e].conflictResolutionFor)throw new pa(`Cannot commit revision because it is preceded by an uncommitted rev id ${i[e].title}`,i);if(t){if(n.includes(t))throw new pa(`Proposed revision id (${t}) already exists`);r.title=n[n.indexOf(r.title)]=t,i.forEach((n=>{n.type===al&&n.conflictResolutionFor===e&&(n.conflictResolutionFor=t)}))}r.committed=!0}cleanUpRevisions(e=this.revisionQueueCommittedMinLength){const t=this[Ea],n=this[xa],i=[];for(let e=0;e<n.length;e++){const t=n[e];if(!t.committed)break;i.push(t)}i.splice(Math.max(0,i.length-1-e),Math.min(i.length,e)),n.splice(0,i.length),t.splice(1,i.length)}markCurrentTransactionContentUserInput(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentUserInput()}markCurrentTransactionContentCalculated(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentCalculated()}}wl._$name="StateTrackingManager";var Dl=e=>class extends(e||tt){static $name="StoreStm";static configurable={stm:null,ignoreRemoteChangesInSTM:!1};changeStm(e,t){var n;return null!=t&&null!==(n=t.hasStore)&&void 0!==n&&n.call(t,this)&&t.removeStore(this),e&&(e.isStateTrackingManager||(e=new wl(e)),e.hasStore(this)||e.addStore(this)),e}add(e,t=!1,n={}){let i;const{stm:r}=this;var s;!this.tree&&null!=r&&r.shouldRecordAction?(i=super.add(e,t,n),null!==(s=i)&&void 0!==s&&s.length&&r.onStoreModelAdd(this,i,t)):i=super.add(e,t,n);return i}insert(e,t,n=!1){let i;const{stm:r}=this;if(!this.tree&&null!=r&&r.shouldRecordAction){var s;const o=(Array.isArray(t)?t:[t]).reduce(((e,t)=>{const n=t instanceof lo?this.indexOf(t):void 0;return void 0!==n&&-1!==n&&e.set(t,n),e}),new Map);i=super.insert(e,t),null!==(s=i)&&void 0!==s&&s.length&&(e=this.indexOf(i[0]),r.onStoreModelInsert(this,e,i,o,n))}else i=super.insert(e,t,n);return i}remove(e,t=!1,n){let i;const{stm:r}=this;if(!this.tree&&null!=r&&r.shouldRecordAction){var s;const o=(Array.isArray(e)?e:[e]).map((e=>this.getById(e))).filter((e=>Boolean(e))).reduce(((e,t)=>{const n=this.indexOf(t);return void 0!==n&&-1!==n&&e.set(t,n),e}),new Map);i=super.remove(e,t,n),null!==(s=i)&&void 0!==s&&s.length&&r.onStoreModelRemove(this,i,o,t)}else i=super.remove(e,t,n);return i}removeAll(e){const{stm:t}=this;let n;if(null!=t&&t.shouldRecordAction){const{tree:i,rootNode:r,allRecords:s}=this,o=s.length,a=i?r.children.slice():s.slice();n=super.removeAll(e),o&&0===this.count&&t.onStoreRemoveAll(this,a,e)}else n=super.removeAll(e);return n}beforeApplyChangeset(){const{stm:e,crudManager:t}=this;let n=!1,i=null;return null!=t&&t.applyingChangeset||null==e||!e.enabled||e.isNavigatingRevisions||(n=!0,e.isRecording&&(i=e.stash()),this.ignoreRemoteChangesInSTM?e.disable():e.startTransaction()),{shouldResume:n,transactionId:i}}applyChangeset(e,...t){const{shouldResume:n,transactionId:i}=this.beforeApplyChangeset(),r=super.applyChangeset(e,...t);return this.afterApplyChangeset(n,i),r}afterApplyChangeset(e,t){if(e){const{stm:e}=this;this.ignoreRemoteChangesInSTM?e.enable():e.stopTransaction(),e.applyStash(t)}}};class El{static new(e){return new this(e)}constructor(e){this.promise=new Promise(((e,t)=>{this.resolve=e,this.reject=t})),e&&e(this)}catch(e){return this.promise=this.promise.catch(e),this}finally(e){return this.promise=this.promise.finally(e),this}then(...e){return this.promise=this.promise.then(...e),this}}El._$name="Promissory";class xl extends(ur.mixin(nn)){static $name="StoreLazyLoadPlugin";static get pluginConfig(){return{override:["updateAutoLoad","performDataRequest"],assign:["load","isLoading","lazyGetAt","unload"],after:["afterLoadData"],before:["setStoreData","destroy"]}}static configurable={totalCountProperty:"total",dataProperty:"data",chunkSize:100};static get properties(){return{loadQueue:{}}}get isLoading(){return this.client._isLoading||Object.values(this.loadQueue).some((e=>U.isPromise(e)))}get storage(){return this.client.storage}set totalCount(e){this._totalCount=e}get totalCount(){return this._totalCount}setEstimatedTotalCount(e){this.totalCount=e}afterConstruct(){const e=this,{client:t}=e;t.syncDataOnLoad&&(t.syncDataOnLoad=!1),e.storeListenersDetacher=t.ion({beforeAdd:"internalOnBeforeAdd",beforeRemove:"internalOnBeforeAdd",change:"internalOnChange",commit:"internalOnCommit",endApplyChangeset:"internalOnCommit",appliedCrudChangesToStore:"internalOnCommit",thisObj:e}),t.requestData||(t.requestData=e.requestData),t.autoLoad&&!t.readUrl&&this.requestAnimationFrame(this.doAutoLoad)}updateAutoLoad(e){e&&!this.client.readUrl&&this.doAutoLoad()}internalOnBeforeAdd(){if(this.isLoading)throw new Error("Removing or adding is not allowed when a lazy loaded Store is loading")}internalOnChange(){this.$loadLock||!this.client.added.count&&!this.client.removed.count||(this.$loadLock=new El)}internalOnCommit(){!this.client.changes&&this.$loadLock&&(this.$loadLock.resolve(),this.$loadLock=null)}performDataRequest(){return this.load()}afterLoadData(){this.totalCount&&(this.storage.values.length=this.totalCount)}setStoreData(e){null!=e&&e.length||!this.client.records.some(Boolean)||this.clear()}clear(){this.totalCount=null,this.loadQueue={}}async requestData({startIndex:e,count:t}){}lazyGetAt(e){return this.getAt(e)}async getAt(e){var t;const n=this,{loadQueue:i,totalCount:r}=n;if(e<0||null!=r&&e>r)return null;const s=n.getFromStorage(e);return s||(await(null===(t=n.$loadLock)||void 0===t?void 0:t.promise),n.isDestroyed?void 0:(i[e]?await i[e]:await n.doLazyLoad(n.calculateRange(e)),n.getFromStorage(e)))}getFromStorage(e){return this.storage.getAt(e)}calculateRange(e){const{totalCount:t,loadQueue:n,chunkSize:i}=this,r=Math.max(0,e-i),s=(t?Math.min(e+i,t):e+i)-1;let o=e,a=e;for(;o>r&&!n[o-1]&&!this.getFromStorage(o-1);)o-=1;for(;a<s&&!n[a+1]&&!this.getFromStorage(a+1);)a+=1;return{startIndex:o,count:a-o+1}}async doLazyLoad({isReload:e,...t}){const n=this;n.triggerLazyLoadStart(arguments[0]),e&&(n.clear(),n.$isCrudManager&&(t.isReload=!0));const{loadQueue:i,client:r}=n,{startIndex:s,count:o}=t,a=s+o-1,l=r.requestData(r.readUrl?t:r.buildRemoteParams(t));for(let e=s;e<=a;e++)i[e]=l;const c=await l;if(!c)return;const{[n.totalCountProperty]:d,[n.dataProperty]:u}=c;for(let e=s;e<=a;e++)i[e]=null;null!=d?n.totalCount=d:null==n.totalCount&&o>u.length&&n.setEstimatedTotalCount(s+u.length),n.addData(u,s,e),null!=n.totalCount&&(n.storage.values.length=n.totalCount),e&&(n._isReloading=!1),n.triggerLazyLoadEnd(arguments[0],u)}addData(e,t,n){var i;const{client:r,storage:s}=this;if(!(null!=e&&e.length||n))return;if(this.pauseStm(),(!r.count||n)&&!t)return void(r.data=e);for(let t=e.length-1;t>=0;t--){const n=e[t],i=r.idRegister[n.id];i&&(i.setByDataSource(n,!0),i.internalClearChanges(!1,!0,n),e.splice(t,1))}if(!e.length)return;const{values:o}=s,a=e.map((e=>r.processRecord(r.createRecord(e),!0)));o.length<t&&(o.length=t),null==t&&(t=o.length),o.splice(t,a.length,...a),r.joinRecordsToStore(a),null===(i=this.processAddedRecords)||void 0===i||i.call(this,a),r.updateDependentStores("add",a);for(const e of a)r.idMap[e.id]={index:t,visibleIndex:t,record:e},t+=1,s.addToIndices(e);r.trigger("change",{action:"lazyload",records:a}),this.resumeStm()}checkDuplicates(e){const{storage:t}=this;for(const n of e){const e=t.indexOf(n.id);e>=0&&t.values.splice(e,1)}}triggerLazyLoadStart(e){const t=this;t.isLoading||(t.isConfiguring?t.delay((()=>t.trigger("lazyLoadStarted",{...e})),0):t.client.trigger("lazyLoadStarted",{...e})),t.client.trigger("beforeLazyLoad",{...e})}triggerLazyLoadEnd(e,t){this.isLoading||this.client.trigger("lazyLoadEnded"),this.client.trigger("afterLazyLoad",{...e,data:t})}load(e){const t=this,n=!U.isEmpty(t.loadQueue);return t._loadedOnce=!0,t._isReloading=n,t.doLazyLoad({isReload:n,startIndex:0,count:t.chunkSize,...e})}unload({records:e,...t}){if(this.$isCrudManager)return void console.warn("It is not supported to unload records from the Store when using a lazy loaded CrudManager");const{client:n}=this;for(let i of rt.asArray(e))i.isModel||(i=n.getById(i)),this.internalUnloadRecord({record:i,...t});n.trigger("refresh",{action:"lazyload"})}internalUnloadRecord({record:e}){const{loadQueue:t,client:n}=this,{id:i}=e,r=n.indexOf(i);t[i]&&(t[i]=void 0),r>=0&&(n.records[r]=void 0,e.unjoinStore(n))}pauseStm(){const{stm:e}=this.client;null!=e&&e.enabled&&e.autoRecord&&(this.$stmIsPaused=!0,e.disable())}async resumeStm(e){const{stm:t}=this.client;this.$stmIsPaused&&(this.$stmIsPaused=!1,await e,t.disabled&&t.enable())}doAutoLoad(){this._loadedOnce||this.load()}destroy(){var e;null===(e=this.storeListenersDetacher)||void 0===e||e.call(this),this.clear(),super.destroy()}}xl._$name="StoreLazyLoadPlugin";const Rl=e=>{var t;return(null===(t=e.children)||void 0===t?void 0:t.reduce(((e,t)=>e+(t.remoteChildCount??0)+1),0))??0},Tl=e=>Rl(e)>=e.remoteChildCount;var Ml=e=>class extends e{static $name="TreeStoreLazyLoadPlugin";static get pluginConfig(){var e;const t={};for(const e in super.pluginConfig)t[e]=[...super.pluginConfig[e]];t.override=t.override??[],t.override.push("loadChildren","getAt");const n=null===(e=t.assign)||void 0===e?void 0:e.indexOf("lazyGetAt");return n>=0&&t.assign.splice(n,1),t}static configurable={chunkSize:50};constructor(...e){super(...e),this.totalCount=0}async load(e){const t=this,n=t._loadedOnce;return t.client.autoLoad&&!n&&await new Promise((e=>t.requestAnimationFrame(e))),t._loadedOnce=!0,t._isReloading=n,t.doLazyLoad({parent:t.client.rootNode,isReload:n,startIndex:0,...e})}changeRemoteChildCount(e,t,n){if(null!=e&&e.length){const i=e.map((e=>{var t;return e.parent??this.client.getById(e.parentId??(null===(t=e.originalData)||void 0===t?void 0:t.parentId))}));for(;i.length;){const e=i.shift();e&&(e.isRoot||i.push(e.parent),e.set("remoteChildCount",(e.remoteChildCount?e.remoteChildCount+t:e.children.length)??0,!0),null==n||n.add(e))}}}internalOnCommit({changes:e}){const t=this,{$loadLock:n,client:i}=t;if(null!=n&&n.size&&[...n.keys()].forEach((e=>{i.added.some((t=>t.parent===e))||i.removed.some((t=>t.parent===e))||(n.get(e).resolve(),n.delete(e))})),t.$legacyCountMode){const n=new Set;t.changeRemoteChildCount(e.added,1,n),t.changeRemoteChildCount(e.removed,-1,n),n.forEach((e=>{e.isFullyLoaded=Tl(e)}))}}internalOnChange(){const{$loadLock:e=(this.$loadLock=new Map)}=this,{added:t,removed:n}=this.client;if(t.count||n.count){[...new Set(t.map((e=>e.parent)).concat(n.map((e=>e.parent))))].forEach((t=>!e.get(t)&&e.set(t,new El)))}}async loadChildren(e){return this.doLazyLoad({parent:e,startIndex:0})}getAt(e){const t=this.client.records[e];return t&&!this._isReloading&&this.loadMoreChildren(t),t}async loadMoreChildren(e){var t;const n=this,{parent:i}=e;if(!e.expanded||null!==(t=e.children)&&void 0!==t&&t.length||e.isFullyLoaded||n.loadQueue[e.id]||n.doLazyLoad({parent:e,startIndex:0}),e===i.lastChild&&!i.isFullyLoaded&&!n.loadQueue[i.id]){var r;const t=null===(r=n.$loadLock)||void 0===r?void 0:r.get(i);if(t){const e=i.instanceMeta(n.client);if(e.isLoadingChildren=!0,await t.promise,n.isDestroyed)return;var s,o;if(i.isFullyLoaded)return e.isLoadingChildren=!1,void(null===(s=(o=n.client).trigger)||void 0===s||s.call(o,"refresh",{action:"lazyload"}))}n.doLazyLoad({startIndex:e.parentIndex+1,parent:i})}}async doLazyLoad({parent:e,isReload:t,...n}){t&&this.clear();const i=this,{client:r}=i,{id:s}=e;if(i.isDestroyed)return;e.instanceMeta(r).isLoadingChildren=!0,i.triggerLazyLoadStart(arguments[0]);const o=i.loadQueue[s]=r.requestData({...r.readUrl?n:r.buildRemoteParams(n),parentId:e.isRoot?"root":s,count:i.chunkSize,...i.$isCrudManager&&{isReload:t}}),{[i.totalCountProperty]:a,[i.dataProperty]:l,...c}=await o;if(!i.isDestroyed&&i.loadQueue[s]===o){var d;if(delete i.loadQueue[s],e.isRoot&&l.length&&void 0===i.$legacyCountMode&&(i.$legacyCountMode=l[0].remoteChildCount>=0)&&!q.isTestEnv&&q.deprecate("core","7.0.0","remoteChildCount is deprecated in favor of autodetection and the isFullyLoaded field"),e.isRoot&&a>=0&&i.$legacyCountMode&&e.set("remoteChildCount",a,!0),i.addData(l,e,t),e.set("isFullyLoaded",c.isFullyLoaded??(i.$legacyCountMode?Tl(e):l.length<i.chunkSize),!0),i.totalCount=r.count,t&&(i._isReloading=!1),!i.isLoading)null===(d=r.trigger)||void 0===d||d.call(r,"refresh",{action:"lazyload"});i.triggerLazyLoadEnd(arguments[0],l),e.instanceMeta(r).isLoadingChildren=!1}}addData(e,t,n){const{client:i,$legacyCountMode:r}=this,s=[];if(i.modelClass.fieldMap.isFullyLoaded||i.modelClass.addField({name:"isFullyLoaded",persist:!1}),r&&(i.modelClass.fieldMap.remoteChildCount||i.modelClass.addField("remoteChildCount"),!e.length)){const e=Rl(t),n=t.remoteChildCount-e;0!==n&&(t.set("remoteChildCount",e,!0),this.changeRemoteChildCount([t],n))}co.preWalk({children:e,$fake:!0},(({children:e})=>null!=e&&e.length?e:null),(e=>{const{expanded:t}=e;var n,i,o;(e.$fake||s.push(e),null!=t&&!r||e.children||e.remoteChildCount>0)&&(null===(n=this.$removedDescendants)||void 0===n||n.forEach((t=>{var n,i;t.parentId!==e.id||null!==(n=e.children)&&void 0!==n&&null!==(i=n.some)&&void 0!==i&&i.call(n,(e=>e.id===t.id))||(e.children.push(t),s.push(t),t.meta.parentWasFullyLoaded&&(e.isFullyLoaded=!0))})),!1!==t||null!==(i=e.children)&&void 0!==i&&i.length?r&&null!==(o=e.children)&&void 0!==o&&o.length&&!e.isFullyLoaded&&Tl(e)?e.isFullyLoaded=!0:e.children||(e.children=[]):e.children=!0)})),n?i.data=e:(t.appendChild(e,!0),i.added.remove(s))}unload(){super.unload(...arguments),this.client.trigger("refresh",{action:"lazyload"})}internalUnloadRecord({record:e,includeDescendants:t,cacheDescendants:n}){var i;if(!e.isParent)return;const r=this,{loadQueue:s,client:o,$removedDescendants:a=(r.$removedDescendants=[])}=r;if(null!==(i=e.children)&&void 0!==i&&i.length){e.traverse((e=>r.internalUnloadRecord({record:e,includeDescendants:t,cacheDescendants:!t})),!0);const i=[...e.children];e.clearChildren(!0),o.removed.remove(i),n&&(a.push(...i),i[0].meta.parentWasFullyLoaded=e.isFullyLoaded)}e.isFullyLoaded=!1,s[e.id]=void 0}};const Il={splice:1,clear:1},kl={includeFilteredOutRecords:!1,includeCollapsedGroupRecords:!1},Fl=(e,t)=>("boolean"==typeof(t=t||!1)&&(t={includeFilteredOutRecords:t,includeCollapsedGroupRecords:!1}),t||kl),Al=Symbol("useRawDataUnset"),Pl={enabled:!0,disableDuplicateIdCheck:!0,disableDefaultValue:!1,disableTypeConversion:!1},Ll={enabled:!0,disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1};class Ol extends(tt.mixin(nn,on,dt,hr,ws,Uo,Wo,No,Qo,ea,ia,ra,Ko,oa,aa,ga,Dl,ma,Zo,Jo)){crudManager=void 0;static $name="Store";static get properties(){return{relationCache:{},dependentStoreConfigs:new Map,addingClean:!1}}static configurable={id:!0,modelClass:lo,verifyNoGeneratedIds:!0,lazyLoad:null,autoLoad:null,requestData:null,useRawData:Al,fields:null,autoTree:!0,tree:null,callOnFunctions:!0,storage:{},allowNoId:!0,preventSubClassingModel:null,storeClass:null};static get identifiable(){return{registerGeneratedId:!1}}updateAutoLoad(e){!e||this.readUrl||this.lazyLoad||this.requestAnimationFrame(this.performDataRequest)}constructor(...e){if(super(...e),this.objectify)return this.initProxy()}construct(e={}){Object.assign(this,{added:new Ho,removed:new Ho,modified:new Ho,idRegister:{},internalIdRegister:{},oldIdMap:{}}),super.construct(e),this.initRelations()}static from(e,t={},n=null){return e&&!e.isStore&&("string"==typeof e?e=Ol.getStore(e):(Array.isArray(e)?(n&&(e=e.map((e=>e.isModel?e:n(e)))),e=U.assign({},t,{data:e})):e=U.assign({},t,e),e=new Ol(e))),e}equals(e){return e.isStore&&e.$master===this.$master}doDestroy(){var e,t,n;const i=this,r=i.registeredRecords;null===(e=i.stm)||void 0===e||null===(t=e.removeStore)||void 0===t||t.call(e,i);for(let e,t=r.length-1;t>=0;t--){var s;e=r[t],null!==(s=e)&&void 0!==s&&s.isDestroyed||e.unjoinStore(i)}var o;(null===(n=i._storage)||void 0===n||n.destroy(),i.isChained)?i.masterStore.isDestroying||rt.remove(i.masterStore.chainedStores,i):null===(o=i.rootNode)||void 0===o||o.destroy();super.doDestroy()}beginBatch(){this.suspendEvents()}endBatch(){if(this.resumeEvents()){const{values:e}=this.storage;this.trigger("refresh",{action:"batch",data:e,records:e})}}changeStorage(e){return null!=e&&e.isCollection?e:new _o(e)}updateStorage(e){e.autoFilter=this.reapplyFilterOnAdd;for(const t of e)t.joinStore(this);e.ion({change:"onDataChange",thisObj:this})}get allRecords(){var e;const t=this;if((null===(e=t._allRecords)||void 0===e?void 0:e.generation)!==t.storage.generation){if(t.isTree){const e=t.collectDescendants(t.rootNode,void 0,void 0,{unfiltered:!0}).all;t.rootVisible&&e.unshift(t.rootNode),t._allRecords=e}else t._allRecords=t.isGrouped?t.collectGroupRecords(!0,!0):t.storage.allValues;t._allRecords.generation=t.storage.generation}return t._allRecords}getAllDataRecords(e){const t=this;return t.tree?e?t.allRecords:t.rootNode.allChildren:t.isGrouped?t.collectGroupRecords(e,!1):(e?t.storage.allValues:t.storage.values).filter((e=>e))}onIsCreatingToggle(e,t){const n=this,i=e.isPersistable&&!t;n.added[i?"add":"remove"](e),i&&(n.trigger("addConfirmed",{record:e}),n.autoCommit&&n.doAutoCommit())}joinRecordsToStore(e){const{totalCount:t}=this;for(let n=0;n<e.length;n++){const i=e[n];i.setData("parentIndex",t+n-e.length),i.joinStore(this)}}onDataChange({source:e,action:t,added:n,removed:i,replaced:r,oldCount:s,items:o,from:a,to:l}){const c=this,d=Il[t],u=d&&(null==n?void 0:n.length),h=d&&(null==i?void 0:i.length),{generation:g}=e,m=c.isFiltered&&!c.remoteFilter;let p,f;if(c._idMap=null,u&&c.joinRecordsToStore(n),null==r||r.forEach((([e,t])=>{e.unjoinStore(c,!0),t.joinStore(c)})),super.onDataChange(...arguments),u&&e.generation!==g&&!m&&c.trigger("refresh",arguments[0]),!c.isTree){if(u){for(const e of n)c.removed.includes(e)?c.removed.remove(e):c.addingClean||e.isLinked||c.added.add(e);p=!c.remoteFilter&&c.isFiltered&&c.reapplyFilterOnAdd,p&&c.filter({silent:!0}),f=!c.remoteSort&&c.isSorted&&c.reapplySortersOnAdd,f&&c.sort(null,null,!1,!0)}if(h){for(const e of i)e.cancelBatch(),e.unjoinStore(c),c.added.includes(e)?(c.added.remove(e),e.isBeingMaterialized&&c.removed.add(e)):e._undoingInsertion||e.isCreating||e.isLinked||c.removed.add(e);c.modified.remove(i),p=m,p&&c.filter({silent:!0})}}switch(t){case"clear":c.relationCache={},c.updateDependentStores("removeall"),c.trigger("removeAll"),c.trigger("change",{action:"removeall"});break;case"splice":if(u){c.updateDependentStores("add",n);const t=n.reduce(((e,t)=>{const{previousIndex:n}=t.meta;return n>-1&&n<e&&(e=n),e}),n[0].meta.previousIndex),i={records:n,index:e.indexOf(n[0],!e.autoFilter)};t>-1&&(i.oldIndex=t),c.trigger("add",i),c.trigger("change",Object.assign({action:"add"},i)),p&&c.triggerFilterEvent({action:"filter",filters:c.filters,oldCount:s,records:c.storage.allValues}),f&&c.trigger("sort",{action:"sort",sorters:c.sorters,records:c.storage.allValues})}i.length&&(c.updateDependentStores("remove",i),c.trigger("remove",{records:i}),c.trigger("change",{action:"remove",records:i})),r.length&&(c.updateDependentStores("replace",r),c.trigger("replace",{records:r,all:c.records.length===r.length}),c.trigger("change",{action:"replace",replaced:r,all:c.records.length===r.length}));break;case"filter":(c.isGrouped||c.isSorted)&&c.performSort(!0);break;case"move":{const e=Math.min(a,l),n=Math.min(c.storage.allValues.length-1,Math.max(a,l));for(let t=c.storage.allValues,i=e;i<=n;i++)t[i].setData("parentIndex",i);c.trigger("move",{records:o,from:a,to:l}),c.isFiltered&&c.performFilter(),c.trigger("change",{action:t,record:o[0],records:o,from:a,to:l});break}}}onDataReplaced(e,t){var n;const i=this,{storage:r}=i,s=r.allValues,o=Boolean(i.sorters.length>0);for(let e=0;e<s.length;e++){var a;null===(a=s[e])||void 0===a||a.joinStore(i)}if(!i.remoteFilter&&i.isFiltered&&i.filter({silent:!0}),i.remoteSort?i.isGrouped&&r.replaceValues({...i.prepareGroupRecords(),silent:!0}):(i.isGrouped&&i.group(null,null,!1,!o,!0),o&&i.sort(null,null,!1,!0)),!i.useRawData.disableDuplicateIdCheck){const{idMap:e}=i;if(Object.keys(e).length<r.values.length){const t=[];throw r.values.forEach((n=>e[n.id]?delete e[n.id]:t.push(n))),new Error(`Id collision on ${t.map((e=>e.id))}`)}}const l={action:e,data:t,records:r.values};i.updateDependentStores(e,l.records),null===(n=i.afterLoadData)||void 0===n||n.call(i),i.isRemoteDataLoading||i.trigger("refresh",l),i.trigger("change",l)}onModelChange(e,t,n,i,r){var s;const o=this,a={record:e,records:[e],changes:n,batch:null!=e.batching,fromRelationUpdate:r};if(o.storage.onItemMutation(e,n),"id"in n){const{oldValue:n,value:i}=t.id;o.updateDependentRecordIds(n,i),o.onRecordIdChange({record:e,oldValue:n,value:i})}else e.meta._ignoreRelatedIdUpdate||o.updateDependentStores("update",[e],i);const l=!e.ignoreBag&&!e.isLinked&&o.updateModifiedBagForRecord(e)&&!(null!==(s=e.meta)&&void 0!==s&&s.pendingFormulae);if(o.onUpdateRecord(e,n),!i){if("id"in n){const{oldValue:n,value:i}=t.id;o.trigger("idChange",{store:o,record:e,oldValue:n,value:i})}o.trigger("update",a),o.trigger("change",Object.assign({action:"update"},a))}o.autoCommit&&l&&o.doAutoCommit()}updateModifiedBagForRecord(e){const t=this,{modified:n,added:i}=t;return e.isModified&&!e.isRoot&&t.idRegister[e.id]?(n.includes(e)||i.includes(e)||(e.isPhantom?i.add(e):n.add(e)),e.isBeingMaterialized&&(t.modifiedMaterialized=t.modifiedMaterialized??new Set,t.modifiedMaterialized.add(e)),!0):(n.remove(e),!1)}get idMap(){const e=this,t=!e._idMap,n=e._idMap||(e._idMap={});if(t){const t=e.storage.values;for(let e,r=0,s=0;r<t.length;r++){var i;e=t[r],e&&(n[e.id]={index:r,visibleIndex:s,record:e}),null!==(i=e)&&void 0!==i&&i.isSpecialRow||s++}if(e.isFiltered)for(let t=0,i=e.storage._values.length;t<i;t++){const i=e.storage._values[t];i&&(i.id in n?n[i.id].unfilteredIndex=t:n[i.id]={index:-1,unfilteredIndex:t,record:i})}}return n}changeModelClass(e){const{fields:t}=this;this.originalModelClass=e;let n=e;if(null!=t&&t.length){class i extends e{static get fields(){return t}}n=i}else if(!this.preventSubClassingModel){class t extends e{}n=t}return n.initClass(),n}get $lazyLoadPluginClass(){return xl}changeLazyLoad(e){const t=this;let n=t.$lazyLoadPluginClass;t.isTree&&!n.isOfTypeName("DateStoreLazyLoadPlugin")&&(t.treeLazyLoadClass||(t.treeLazyLoadClass=class extends(Ml(n)){}),n=t.treeLazyLoadClass);let i=t.getPlugin(n);if(e){const r=U.isObject(e);return i?r&&U.assign(i,e):i=t.addPlugin(n,r?e:null),i}var r;return null===(r=i)||void 0===r||r.destroy(),!1}changeId(e,t){return super.changeId(!0!==e&&e,t)}updateId(e,t){const n=Ol.getById(e);n&&Ol.unregisterInstance(n),super.updateId(e,t)}generateAutoId(){return Ol.generateId("store-")}updateTree(e){e&&!this.rootNode&&(this.rootNode=this.buildRootNode(),this.rootNode.isAutoRoot=!0)}get autoTree(){return!1!==this.tree&&this._autoTree}buildRootNode(){return{}}static getStore(e,t){if(e instanceof Ol)return e;if(this.getById(e))return this.getById(e);if(Array.isArray(e)){let n;const i=e.map((e=>(e instanceof lo?n=e.constructor:"string"==typeof e&&(e={text:e}),e)));if(!n){class e extends lo{}n=e}e={autoCreated:!0,data:i,modelClass:n,allowNoId:!0},t||(t=Ol)}return t?new t(e):void 0}static get stores(){return Ol.registeredInstances}get rootNode(){return!this.isChainedTree&&this.masterStore?this.masterStore.rootNode:this._rootNode}set rootNode(e){var t;const n=this,i=n._rootNode;e!==i&&(i&&(n.clear(!0),n.removed.clear()),e instanceof lo?(e.instanceMeta(n).collapsed=!1,n._rootNode=e):n._rootNode=e=new n.modelClass({expanded:!0,[n.modelClass.idField]:`${n.id}-rootNode`,...e},n,{isRoot:!0},!0),n._tree=!0,e.isRoot=!0,e.joinStore(n),(null!==(t=e.children)&&void 0!==t&&t.length||n.rootVisible)&&(e.isLoading=!0,n.onNodeAddChild(e,e.children||[],0),e.isLoading=!1),n.trigger("rootChange",{oldRoot:i,rootNode:e}))}set data(e){this.setStoreData(e)}get data(){return this.getAllDataRecords(!0).map((e=>e.data))}setStoreData(e){var t;const n=this,{idField:i,childrenField:r}=n.modelClass;e&&!Array.isArray(e)&&(e=U.transformNamedObjectToArray(e,i));const s=co.walkWhile(e??[],(e=>e[r]),Object.isExtensible);var o;(null!==(t=e)&&void 0!==t&&t.length&&!s&&(n.transformFlatData||n.useRawData.enabled)&&(n.transformFlatData&&(n.useRawData=n.useRawData||{disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1}),e=U.clone(e)),n.getConfig("plugins"),n.processConfiguredListeners(),!n.isChained||n.isChainedTree)&&(n.autoTree&&null!==(o=e)&&void 0!==o&&o.some((e=>e[r]))&&(n.tree=!0));if(e&&(n.remoteSort||n.remoteFilter))for(let t=0;t<e.length;t++)e[t]._remoteSortIndex=t;n.syncDataOnLoad&&n._data?n.syncDataset(e):(n._data=e,n.tree?n.loadTreeData(e):n.loadData(e),n.added.clear(),n.removed.clear(),n.modified.clear())}loadTreeData(e){const t=this,n=t.rootNode,i=new Map;if(t.transformFlatData&&(e=t.treeifyFlatData(e)),n.isLoading=!0,t.records.length&&t.keepExpandedOnLoad&&t.traverse((e=>{e.isLeaf||i.set(e.id,e.instanceMeta(t).collapsed)})),e.sort(((e,t)=>e.parentIndex-t.parentIndex)),t.clear(!0),t.suspendEvents(!0),n.appendChild(e),i.forEach(((e,n)=>{const i=t.getById(n);i&&t.toggleCollapse(i,e)})),t.resumeEvents(),t.updateDependentStores("dataset",[n]),n.isLoading=!1,0===e.length){const e={action:"dataset",data:[],records:[]};t.trigger("refresh",e),t.trigger("change",e)}else t.isFiltered&&!t.remoteFilter&&t.filter()}loadData(e,t="dataset"){const n=this,{storage:i,allowNoId:r}=n,s=n.modelClass.fieldMap.id.dataSource,o=n.find((e=>e.isCreating));o&&i.values.splice(n.records.indexOf(o),1);let a=n.verifyNoGeneratedIds;if(n.removeHeadersAndFooters(n.storage.values),n._idMap=null,n.oldIdMap={},e){const c=!(e[0]instanceof lo),d=e.length,u=new Array(d);c&&n.modelClass.exposeProperties(e[0]);for(let t=0;t<d;t++){let i=e[t];if(c){var l;const e=i[s];if(!r&&null==e)throw new Error(`Id required but not found on row ${t}`);a&&null!=e&&null!==(l=e.startsWith)&&void 0!==l&&l.call(e,"_generated")&&(console.warn(`Generated id found in data: ${e}. Generated ids are temporary and should be replaced with real ids by the backend`),a=!1),i=n.createRecord(i,!0)}n.isFillingFromMaster||(i=n.processRecord(i,!0),i.setData("parentIndex",t)),u[t]=i}n.clear(!0),i.replaceValues({values:u,isNewDataset:!0,silent:!0}),o&&!i.values.includes(o)&&i.values.push(o),n._data=e,n.onDataReplaced(t,e)}else n.clear(!0),n._data=null;n.isSyncingDataOnLoad=!1}getRange(e,t,n=!0){return(n?this.storage.allValues:this.storage.values).slice(e,t)}createRecord(e,t=!1,n=!1){return new this._modelClass(e,this,null,t,!1,n)}processRecord(e,t=!1){return e}refreshData(){this.filter(),this.sort()}onRecordIdChange({record:e,oldValue:t,value:n}){const i=this,r=i._idMap,{idRegister:s,oldIdMap:o}=i;if(i.storage._indicesInvalid=!0,o[t]=e,r&&!r[n]){const e=r[t];delete r[t],r[n]=e}i.added.changeId(t,n),i.removed.changeId(t,n),i.modified.changeId(t,n),delete s[t],s[n]=e,e.index=i.storage.indexOf(e)}onUpdateRecord(e,t){var n,i;const r=this,{internalId:s}=t,{internalIdRegister:o,reapplyFilterOnUpdate:a,reapplySortersOnUpdate:l}=r;s&&(this.storage._indicesInvalid=!0,delete o[s.oldValue],o[s.value]=e),(!0===a||null!==(n=a.fields)&&void 0!==n&&n.some((e=>e in t)))&&r.isFiltered&&(r.filterBatching||r.filter()),(!0===l||null!==(i=l.fields)&&void 0!==i&&i.some((e=>e in t)))&&r.isSorted&&(r._reapplySortersSuspended?r._shouldReapplySorters=!0:r.sort())}get useRawData(){var e;return this._useRawData===Al?this.readUrl||null!==(e=this.crudManager)&&void 0!==e&&e.loadUrl?Ll:{enabled:!1}:this._useRawData}changeUseRawData(e){return e===Al?Al:!0===e?Pl:e?Object.assign(e,{enabled:!0}):{enabled:!1}}async performDataRequest(e,t,n){var i,r;const s=this,o=s.buildRemoteParams(t);let a,l;if(!e&&(!1===await s.trigger("beforeRequest",{action:"read",params:o})||!1===await(null===(i=s.trigger)||void 0===i?void 0:i.call(s,"requestData",o))))return!1;if(!s.isDestroyed){if(s.requestData){if(({data:a,total:l}=await s.requestData(o)),s.isDestroyed)return;null==n||n(),s.data=a,null!=l&&(s.remoteTotal=l)}else null==n||n();await(null===(r=s.trigger)||void 0===r?void 0:r.call(s,"afterRequest",{response:{data:a,total:l},params:o,action:"read"}))}}getCount(e=!0){const t=this,{storage:n,groupRecords:i,isFiltered:r,isGrouped:s,isTree:o,rootNode:a}=t;if("boolean"==typeof e)return q.deprecate("core","7.0.0","getCount(true/false) deprecated in favor of getCount(options)"),e?t.count:n.totalCount-((null==i?void 0:i.count)||0);if(e.all)return this.allRecords.length;"visibleData"in e||(e.visibleData=!0);let l=0;const{visibleData:c,headersFooters:d,filteredOut:u,collapsed:h}=e,g=r?(null==i?void 0:i.values.reduce(((e,n)=>e+(t.includes(n)?1:0)),0))??0:(null==i?void 0:i.count)??0,m=n.count-g;if(c&&(l+=m),d&&s&&(l+=r&&u?i.count??0:g),u&&r&&(l+=o?a.getDescendantCount(!1,t,!0)-a.getDescendantCount(!1,t,!1):n.allValues.length-n.values.length),h)if(s)for(const e of i)l+=e.meta.collapsed?e.groupChildren.length:0;else o&&(l+=a.descendantCount-m);return l}get count(){return this.storage.count}get originalCount(){var e;return q.deprecate("core","7.0.0","originalCount was deprecated in favor of getCount()"),this.storage.totalCount-((null===(e=this.groupRecords)||void 0===e?void 0:e.count)||0)}get allCount(){return q.deprecate("core","7.0.0","allCount was deprecated in favor of totalCount"),this.isTree?this.rootNode.descendantCount:this.storage.totalCount}get totalCount(){return this.isPaged&&"remoteTotal"in this?this.remoteTotal:this.getCount({all:!0})}set totalCount(e){this.isPaged&&(this.remoteTotal=e)}get records(){return this.storage.values}get first(){return this.storage.values[0]}get last(){return this.storage.values[this.storage.values.length-1]}getAt(e,t=!1){return this.storage.getAt(e,t)}register(e){const t=this;if(!t.useRawData.disableDuplicateIdCheck){const n=t.isTree&&t.idRegister[e.id];if(n&&n!==e)throw new Error(`Id collision on ${e.id}`)}t.idRegister[e.id]=e,t.internalIdRegister[e.internalId]=e}unregister(e){delete this.idRegister[e.id],delete this.internalIdRegister[e.internalId]}get registeredRecords(){return Object.values(this.idRegister)}getById(e){var t;const n=this;let i;null!==(t=e)&&void 0!==t&&t.isModel&&(i=e,e=i.id);const r=n.idRegister[e];if(i){var s;if(null!==(s=i)&&void 0!==s&&s.hasLinks&&!r){const{allValues:e}=n.storage;return i.$links.find((t=>e.includes(t)))}return i}return r}isAvailable(e){const t=this.getById(e);return t&&this.storage.includes(t)||!1}getByInternalId(e){return this.internalIdRegister[e]}includes(e){return this.isTree?null!=this.idRegister[lo.asId(e)]:this.indexOf(e)>-1}indexOf(e,t=!1,n=!1){var i;if(null!=e&&e.isModel&&(null===(i=e.stores)||void 0===i||!i.includes(this.$store||this))){const n=e.$links.find((e=>this.storage.allValues.includes(e)));return n?this.indexOf(n,t):-1}if(this.isTree)return(n?this.rootNode.allChildren:this.storage.values).indexOf(this.getById(e));const r=lo.asId(e);if(null==r)return-1;const s=this.idMap[r];return s?s[t?"visibleIndex":"index"]:-1}allIndexOf(e){return this.isTree?this.allRecords.indexOf(this.getById(e)):this.storage.indexOf(e,!0)}getDistinctValues(e,t=!1,n=!1){const i=[],r={};let s;return this.forEach((t=>{if(!t.isSpecialRow&&!t.isRoot){s=t.getValue(e);const n=s instanceof Date?s.getTime():s;void 0===r[n]?(i.push(s),r[n]={value:s,count:1}):r[n].count++}}),this,{includeCollapsedGroupRecords:!0,includeFilteredOutRecords:t}),n?Object.values(r):i}getValueCount(e,t){let n=0;return this.forEach((i=>{U.isEqual(i.getValue(e),t)&&n++})),n}set json(e){"string"==typeof e&&(e=V.safeJsonParse(e)),this.data=e}get json(){return V.safeJsonStringify(this)}get formattedJSON(){return V.safeJsonStringify(this,null,4)}toJSON(){const e=this,{persistable:t,dataSource:n}=e.modelClass.getFieldDefinition("expanded");return(e.isTree?e.rootNode.unfilteredChildren||e.rootNode.children||[]:e.allRecords).map((i=>{const r=i.toJSON();return e.tree&&i.isParent&&t&&(r[n]=i.isExpanded(e)),r}))}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.project}getInlineData(e){const t=[];var n;this.tree?null===(n=this.rootNode.children)||void 0===n||n.forEach((n=>t.push(n.getCurrentConfig(e)))):this.forEach((n=>t.push(n.getCurrentConfig(e))));return t}getCurrentConfig(e){const t=super.getCurrentConfig(e),{state:n}=this;return t&&(t.data&&(t.data=this.getInlineData(e)),delete t.project,delete t.stm,delete t.asyncEvents,delete t.modelClass,this.tree||delete t.tree,n&&Object.assign(t,n)),t}forEach(e,t=this,n){const i=this,r=(n,i)=>{if(n&&!n.isRoot&&!n.isSpecialRow)return e.call(t,n,i)};if(n=Fl(0,n),i.isTree)i.isChained&&(n={...n,sorterFn:i.sorterFn}),i.rootNode.traverseWhile(r,!1,n);else{const e=n.includeFilteredOutRecords?i.storage.allValues:i.storage.values;if(i.isGrouped&&n.includeCollapsedGroupRecords)for(let t=0;t<e.length;t++){const i=e[t],s=n.includeFilteredOutRecords?i.unfilteredGroupChildren:i.groupChildren;if(s&&!0===i.meta.collapsed)for(let e=0;e<s.length;e++){if(!1===r(s[e],e))return}else if(!1===r(i,t))return}else for(let t=0;t<e.length;t++)if(!1===r(e[t],t))return}}map(e,t=this){return this.storage.values.map(e,t)}flatMap(e,t=this){return this.storage.values.flatMap(e,t)}every(e,t=this,n){return this.storage[n?"allValues":"values"].every(e,t)}reduce(e,t=[],n=this){return n!==this&&(e=e.bind(n)),this.storage.values.reduce(e,t,n)}[Symbol.iterator](){return this.storage.values[Symbol.iterator]()}traverse(e,t=this.rootNode,n=t===this.rootNode,i){const r=this;if(i=Fl(0,i),r.isTree){if("boolean"==typeof t&&(n=t,t=r.rootNode),r.isChained){const t=e;e=e=>{r.chainedFilterFn(e)&&t(e)}}t.traverse(e,n,i)}else r.forEach((t=>t.traverse(e,!1,i)),r,i)}traverseWhile(e,t=this.rootNode,n=t===this.rootNode,i){const r=this;if(i=Fl(0,i),r.isTree){if("boolean"==typeof t&&(n=t,t=r.rootNode),r.isChained){const t=e;e=e=>{r.chainedFilterFn(e)&&t(e)}}t.traverseWhile(e,n,i)}else for(const t of r.storage)if(!1===t.traverse(e,!1,i))break}getNext(e,t=!1,n=!1){const i=this,r=i.storage.values;let s=i.indexOf(e);if(s>=r.length-1){if(!t)return null;s=-1}const o=r[s+1];return n&&o&&(o.isSpecialRow||"function"==typeof n&&n(o))?i.getNext(r[s+1],t,n):o}getPrev(e,t=!1,n=!1){const i=this,r=i.storage.values;let s=i.indexOf(e);if(0===s){if(!t)return null;s=r.length}const o=r[s-1];return s>0&&n&&o&&(o.isSpecialRow||"function"==typeof n&&n(o))?i.getPrev(r[s-1],t,n):o}getAdjacent(e,t=!0,n=!1,i=!1){return t?this.getNext(e,n,i):this.getPrev(e,n,i)}getNextLeaf(e,t=!1){const n=this.leaves,i=this.getById(e);let r=n.indexOf(i);if(r>=n.length-1){if(!t)return null;r=-1}return n[r+1]}getPrevLeaf(e,t=!1){const n=this.leaves,i=this.getById(e);let r=n.indexOf(i);if(0===r){if(!t)return null;r=n.length}return n[r-1]}getAdjacentLeaf(e,t=!0,n=!1){return t?this.getNextLeaf(e,n):this.getPrevLeaf(e,n)}}Ol.initClass(),Ol._$name="Store";class $l extends xl{static $name="AjaxStoreLazyLoadPlugin";static get pluginConfig(){const e={};for(const t in super.pluginConfig)e[t]=[...super.pluginConfig[t]];return e.assign.push("updateResponseTotalProperty","updateResponseDataProperty"),e}updateResponseTotalProperty(e){this.totalCountProperty=e}updateResponseDataProperty(e){this.dataProperty=e}async requestData(e){const{totalCountProperty:t,dataProperty:n}=this.lazyLoad,i=await this.internalLoad(e,"",void 0,!1);return{[t]:i.json[t],[n]:i.data}}async load(e){const{client:t}=this,n=t.params;e&&(t.params={...e,...n}),t.autoLoad&&t.isConstructing&&await new Promise((e=>this.requestAnimationFrame(e))),await super.load(),e&&(t.params=n)}}$l._$name="AjaxStoreLazyLoad";const _l=(e,t)=>(Array.isArray(t[1])?t[1].forEach((n=>e.push(encodeURIComponent(t[0])+"="+encodeURIComponent(n)))):e.push(encodeURIComponent(t[0])+"="+encodeURIComponent(t[1])),e),jl=Promise.resolve(),Bl=e=>String(e).padStart(2,"0"),Vl=e=>e.persistableData,Hl=e=>!U.isEmpty(e);class zl extends Ol{static $name="AjaxStore";static configurable={responseSuccessProperty:"success",responseDataProperty:"data",responseTotalProperty:"total",params:null,autoCommitTimeout:10,includeChildrenInRemoveRequest:!0,transformLoadedData:null,transformCreationData:null,transformModificationData:null,transformRemovalData:null,ignoreLoadPropagationChanges:!1,restfulFilter:!1,headers:null,fetchOptions:null,sendAsFormData:null,writeAllFields:null,parentIdParamName:"id",useRestfulMethods:null,httpMethods:{create:"POST",read:"GET",update:"PUT",delete:"DELETE"},paramsInBody:q.checkVersion("core","6.0",">=")};modificationsTracking=0;suspendModificationsTracking(){this.modificationsTracking++}resumeModificationsTracking(){this.modificationsTracking--}afterConstruct(e){super.afterConstruct(e),this.autoLoad&&this.readUrl&&this.load().catch((()=>{}))}get $lazyLoadPluginClass(){return $l}get isLoading(){return super.isLoading||this._isLoading?2:!!this.loadTriggerPromise&&1}get isCommitting(){return Boolean(this.commitPromise??this.autoCommitTimeoutPromise)}updateFilterParamName(e){super.updateFilterParamName(e),this.remoteFilter=this.remoteFilter||this.restfulFilter}updateRestfulFilter(e,t){this.remoteFilter=e||Boolean(this.filterParamName)||this.remoteFilter&&!t}buildQueryString(e,...t){const n=e.includes("?"),i=Object.entries(Object.assign({},...t)).reduce(_l,[]).join("&");return i?(n?"&":"?")+i:""}async performRemoteSort(e){const t=this;if(t.readUrl&&!t.isRemoteDataLoading){var n;if(t.isRemoteDataLoading=!0,!1===await(null===(n=t.beforePerformSort)||void 0===n?void 0:n.call(t)))return;const i=await t.load();return t.afterPerformSort(e),t.isRemoteDataLoading=!1,i}super.performSort(e)}async performRemoteFilter(e){const t=this;if(t.filterBatching>0)t.needsFiltering=!0;else{if(t.readUrl){var n,i;null===(n=t.loadingPromise)||void 0===n||n.abort(),t.isRemoteDataLoading=!0;const r=t.count,{filters:s}=t;if(!1===await(null===(i=t.beforePerformFilter)||void 0===i?void 0:i.call(t,{filters:s,oldCount:r})))return;const o=await t.load(),a=e?null:{action:"filter",filters:s,oldCount:r,records:t.storage.values};return t.afterPerformFilter(a),t.trigger("refresh",a),t.isRemoteDataLoading=!1,o}super.performRemoteFilter(e)}}encodeFilterParams(e){const t=this.getFilterParams(e);return JSON.stringify(t,(function(e,t){return""===e?t:this[e]instanceof Date?`${(n=this[e]).getFullYear()}-${Bl(n.getMonth()+1)}-${Bl(n.getDate())}T${Bl(n.getHours())}:${Bl(n.getMinutes())}:${Bl(n.getSeconds())}.${n.getMilliseconds()}`:t;var n}))}encodeSorterParams(e){return JSON.stringify(this.getSorterParams(e))}buildReadUrl(){const{readUrl:e}=this;if(this.restfulFilter&&this.filters.count){return(e.endsWith("/")?e:e+"/")+this.filters.first.value}return e}internalLoad(e,t,n,i=0){e=U.assign({},this.params,e);const r=this,s={action:"read"+t,params:e,url:r.buildReadUrl()};if(r.buildRemoteParams(e,!0),!1===r.trigger("beforeLoad"+t,s))throw!1;return r.loadArgs=[s,e,t,n],!1===i?new Promise(((e,t)=>r.sendLoadRequest(e,t))):r.loadTriggerPromise||(r.loadTriggerPromise=new Promise(((e,t)=>{r.setTimeout({delay:i,fn:"sendLoadRequest",args:[e,t],cancelOutstanding:!0})})))}async sendLoadRequest(e,t){const n=this,[i,r,s,o]=n.loadArgs;if(n.loadTriggerPromise=null,i.url){n._isLoading=!0,n.trigger(`load${s}Start`,i),!1===await n.trigger("beforeRequest",i)&&(n._isLoading=!1,e(i));const d={parseJson:!0};n.headers&&(d.headers=U.clone(n.headers)),n.useRestfulMethods&&(d.method=n.httpMethods.read,i.body&&(d.body=JSON.stringify(i.body)));try{var a,l;const u=n.paramsInBody&&("POST"===(null===(a=d.method)||void 0===a?void 0:a.toUpperCase())||"PUT"===(null===(l=d.method)||void 0===l?void 0:l.toUpperCase()))&&null==d.body,h=i.url+(u?"":n.buildQueryString(i.url,r)),g=n.loadingPromise=er.get(h,U.assign(d,n.fetchOptions,u?{body:JSON.stringify(r)}:null)),m=await g;if(n.isDestroyed)return;const p=n.transformLoadedData?n.transformLoadedData(m.parsedJson):m.parsedJson,f=Array.isArray(p),v=f||p&&!1!==U.getPath(p,n.responseSuccessProperty),y=f?null:U.getPath(p,n.responseTotalProperty);if(n.loadingPromise=null,n._isLoading=!1,i.response=m,i.json=p,v){if(null!=y&&(n.remoteTotal=parseInt(y,10)),n.isPaged&&!n.lazyLoad){if(!(n.remoteTotal>=0))throw new Error("A paged store must receive its responseTotalProperty in each data packet");n.currentPage=n.pageStartParamName?r[n.pageStartParamName]/n.pageSize+1:r[n.defaultPageParamName]}var c;if(i.data=f?p:U.getPath(p,n.responseDataProperty),n.suspendModificationsTracking(),await(null==o?void 0:o(i)),n.resumeModificationsTracking(),n.isPartOfProjectRaw)n.ignoreLoadPropagationChanges&&n.suspendModificationsTracking(),await(null===(c=n.getProject())||void 0===c?void 0:c.commitAsync()),n.ignoreLoadPropagationChanges&&n.resumeModificationsTracking();!n.isDestroyed&&n.trigger("load"+s,i),e(i)}else Object.assign(i,{exception:!0,exceptionType:"server",error:null==p?void 0:p.error}),!n.isDestroyed&&n.trigger("exception",i),t(i)}catch(e){n._isLoading=!1,i.exception=!0,e instanceof Response?(i.exceptionType=e.ok?"server":"network",i.response=e,i.error=e.error):(i.exceptionType="server",i.error=e),!n.isDestroyed&&n.trigger("exception",i),t(i)}finally{!n.isDestroyed&&n.trigger("afterRequest",i)}}}async load(e){const t=this;return t.isPaged?t.loadPage(t.currentPage||1,e):t.internalLoad(e,"",(e=>{t.data=e.data}))}async loadChildren(e){return this.readUrl?this.internalLoad({[this.parentIdParamName]:e.id},"Children",(t=>{t.parentRecord=e,e.children.length&&e.clearChildren(!0),e.data[e.constructor.childrenField]=t.data,e.processChildren(e.stores)}),!1):this.immediatePromise}async loadPage(e,t={}){return this.readUrl?(t[this.defaultPageParamName]=e??1,this.internalLoad(t,"Page",(e=>{this.loadData(e.data,"pageLoad")}))):super.loadPage(e)}async commit(){return this.clearTimeout("autoCommit"),this.autoCommitTimeoutPromise=null,this.queueCommit()}queueCommit(){var e;const t=this;let n;return t.commitPromise?n=t.commitPromise.then((()=>t.performCommit())):(t._commitPromiseQueueLength=0,n=t.performCommit()),t._commitPromiseQueueLength+=1,t.commitPromise=null===(e=n)||void 0===e?void 0:e.finally((()=>{t._commitPromiseQueueLength-=1,0===t._commitPromiseQueueLength&&(t.commitPromise=null)}))}performCommit(){const e=this,{changes:t}=e,n=[];if(!t)return e.modified.count&&(e.modified.forEach((e=>e.internalClearChanges(!0,!1))),e.modified.clear()),jl;if(!1!==e.trigger("beforeCommit",{changes:t})){[...t.added,...t.modified,...t.removed].forEach((e=>e.meta.committing=!0)),e.trigger("commitStart",{changes:t});const i={action:"commit",exception:!1,changes:t};let r=e.commitRemoved(i);return r&&n.push(r),r=e.commitAdded(i),r&&n.push(r),r=e.commitModified(i),r&&n.push(r),n.length?(r=1===n.length?n[0]:Promise.all(n),new Promise(((n,s)=>{r.then((()=>{i.exception?(e.trigger("exception",i),s(i)):(e.trigger("commit",{changes:t}),n(i))})).catch((()=>{s(i)}))}))):(e.modified.forEach((e=>e.internalClearChanges(!0,!1))),e.modified.clear(),e.added.forEach((e=>e.internalClearChanges(!0,!1))),e.added.clear(),e.removed.clear(),e.trigger("commit",{changes:t}),jl)}return jl}doAutoCommit(){const e=this;e.suspendCount<=0&&!e.hasTimeout("autoCommit")&&(e.autoCommitTimeoutPromise=new Promise((t=>{e.setTimeout({name:"autoCommit",fn:()=>{e.autoCommitTimeoutPromise=null,e.commit().then().catch((e=>{const{response:t}=e;if(!t||!(t.ok&&t.parsedJson||[500,404].includes(t.status)))throw e})),t()},delay:e.autoCommitTimeout})})))}buildCommitUrl(e){return e+this.buildQueryString(e,this.params)}commitAdded(e){return this.added.count&&this.createUrl?this.commitAddedAsync(e):null}async commitAddedAsync(e){const t=this,n=Array.from(t.added),i=n.map(Vl),r={action:"create",params:t.params,url:t.buildCommitUrl(t.createUrl)};if(e.create=r,r.body={data:i},!1===await t.trigger("beforeRequest",r))return n.forEach((e=>e.meta.committing=!1)),e;let s=t.transformCreationData?t.transformCreationData(r.body):r.body;if(t.sendAsFormData){const e=new FormData;e.append("data",JSON.stringify(s.data)),s=e}const o={parseJson:!0};t.headers&&(o.headers=U.clone(t.headers)),t.useRestfulMethods&&(o.method=t.httpMethods.create);try{const a=await er.post(r.url,s,U.assign(o,t.fetchOptions));if(t.isDestroyed)return;const l=a.parsedJson,c=Array.isArray(l)||l&&!1!==l.success;if(e.response=a,r.json=l,r.response=a,c){const e=t.processReturnedData(l,n,i);t.added.remove(e),t.modified.add(e.filter((e=>e.meta.modified&&!U.isEmpty(e.meta.modified)))),t.trigger("commitAdded"),t.trigger("refresh",r)}else n.forEach((e=>e.meta.committing=!1)),e.exception=r.exception=!0,e.exceptionType=r.exceptionType="server",t.trigger("exception",r)}catch(i){n.forEach((e=>e.meta.committing=!1)),e.exception=r.exception=!0,i instanceof Response?(e.response=i,r.exceptionType=i.ok?"server":"network",r.response=i,r.error=i.error):(r.exceptionType="server",r.error=i),!t.isDestroyed&&t.trigger("exception",r)}finally{!t.isDestroyed&&t.trigger("afterRequest",r)}return e}commitModified(e){return this.modified.count&&this.updateUrl?this.commitModifiedAsync(e):null}async commitModifiedAsync(e){const t=this,n=Array.from(t.changes.modified),i={action:"update",params:t.params,url:t.buildCommitUrl(t.updateUrl)},r=n.map((e=>t.writeAllFields?e.persistableData:e.modificationDataToWrite)).filter(Hl);if(0===r.length)return t.modified.clear(),void n.forEach((e=>e.meta.committing=!1));if(e.update=i,i.body={data:r},!1===await t.trigger("beforeRequest",i))return e;let s=t.transformModificationData?t.transformModificationData(i.body):i.body;if(t.sendAsFormData){const e=new FormData;e.append("data",JSON.stringify(s.data)),s=e}const o={parseJson:!0};t.headers&&(o.headers=U.clone(t.headers)),t.useRestfulMethods&&(o.method=t.httpMethods.update);try{const a=await er.post(i.url,s,U.assign(o,t.fetchOptions));if(t.isDestroyed)return;const l=a.parsedJson,c=Array.isArray(l)||l&&!1!==l.success;e.response=a,i.json=l,i.response=a,c?(t.processReturnedData(l,n,r,!0,!0),t.trigger("commitModified"),t.trigger("refresh",i)):(n.forEach((e=>e.meta.committing=!1)),e.exception=i.exception=!0,i.exceptionType="server",t.trigger("exception",i))}catch(r){n.forEach((e=>e.meta.committing=!1)),e.exception=i.exception=!0,r instanceof Response?(e.response=r,i.exceptionType=r.ok?"server":"network",i.response=r,i.error=r.error):(i.exceptionType="server",i.error=r),!t.isDestroyed&&t.trigger("exception",i)}finally{!t.isDestroyed&&t.trigger("afterRequest",i)}return!n.length&&t.modified.count&&t.modified.clear(),e}processReturnedData(e,t,n,i=!1){Array.isArray(e)||(e=U.getPath(e,this.responseDataProperty));const{idField:r}=t[0].constructor,s=!e||e.length===t.length,o=[];return t.forEach(((t,a)=>{var l,c;const d=i?null===(l=e)||void 0===l?void 0:l.find((e=>e[r]===t.id)):null===(c=e)||void 0===c?void 0:c[a];if(s||d){const e=t.modificationDataToWrite,s=i?n.find((e=>e[r]===t.id)):n[a],l={};if(t.meta.committing=!1,d&&(t.syncId(d[r]),Object.assign(t.data,this.modelClass.processData(d,i,this,t))),e)for(const n in s)if(e[n]===s[n]){const e=t.getFieldDefinitionFromDataSource(n);null!=e&&e.persist&&(l[e.name]=1)}t.internalClearChanges(!0,!0,l,!0),o.push(t)}})),o}commitRemoved(e){return this.removed.count&&this.deleteUrl?this.commitRemovedAsync(e):null}async commitRemovedAsync(e){const t=this,{removed:n,includeChildrenInRemoveRequest:i}=t;let r;if(i)r=n.values;else{r=[];for(const e of n.values){var s;const i=e.parentId??(null===(s=e.meta.modified)||void 0===s?void 0:s.parentId);null==i||i!==t.rootNode.id&&n.includes(i)||r.push(e)}}const o={action:"delete",params:t.params,url:t.buildCommitUrl(t.deleteUrl),body:{ids:r.map((e=>e.id))}};if(e.delete=o,!1===await t.trigger("beforeRequest",o))return e;let a=t.transformRemovalData?t.transformRemovalData(o.body):o.body;if(t.sendAsFormData){const e=new FormData;e.append("id",JSON.stringify(a.ids)),a=e}const l={parseJson:!0};t.headers&&(l.headers=U.clone(t.headers)),t.useRestfulMethods&&(l.method=t.httpMethods.delete);try{const i=await er.post(o.url,a,U.assign(l,t.fetchOptions)),r=i.parsedJson,s=Array.isArray(r)||r&&!1!==r.success;e.response=i,o.json=r,o.response=i,s?(n.forEach((e=>e.meta.committing=!1)),n.clear(),t.trigger("commitRemoved"),t.trigger("refresh",o)):(n.forEach((e=>e.meta.committing=!1)),e.exception=o.exception=!0,o.exceptionType="server",t.trigger("exception",o))}catch(i){n.forEach((e=>e.meta.committing=!1)),e.exception=o.exception=!0,i instanceof Response?(e.response=i,o.exceptionType=i.ok?"server":"network",o.response=i,o.error=i.error):(o.exceptionType="server",o.error=i),!t.isDestroyed&&t.trigger("exception",o)}finally{!t.isDestroyed&&t.trigger("afterRequest",o)}return e}}zl._$name="AjaxStore";class Nl extends lo{static $name="ComboModel";static fields=[{name:"value"},{name:"text"}]}Nl._$name="ComboModel";const Wl={};class Ul{static get(e,t=Wl){const n=e._domData||(e._domData={});return t===Wl?n:n[t]}static remove(e,t){const{_domData:n}=e,i=null==n?void 0:n[t];return null==n||delete n[t],i}static set(e,t,n=Wl){return n===Wl?e._domData=n=t:(e._domData||(e._domData={}))[t]=n,n}static assign(e,t){Object.assign(e._domData||(e._domData={}),t)}}Ul._$name="DomDataStore";class Gl{static $name="CSSHelper";static insertRule(e,t=document.head){const n=this.getStyleSheet(t),{cssRules:i}=n,r=i.length,s="string"==typeof e;if((s?[e]:e).forEach(((e,t)=>n.insertRule(e,t))),i.length>r)return s?i[0]:Array.from(i).slice(0,e.length)}static findRule(e){let t;const n="function"==typeof e;return Array.prototype.find.call(document.head.querySelectorAll("link[rel=stylesheet],style[type*=css]"),(i=>{if(t=Array.prototype.find.call(i.sheet.rules||i.sheet.cssRules,(t=>n?e(t):t.selectorText===e)),t)return!0})),t}static getStyleSheet(e=document.head){return e.$bryntumStylesheet||(e.$bryntumStylesheet=ki.createElement({tag:"style",type:"text/css",parent:e}).sheet),e.$bryntumStylesheet}static getCSSVersion(){return getComputedStyle(document.documentElement).getPropertyValue("--bryntum-version").replace(/[" ]/gm,"")}}l.register(Gl),Gl._$name="CSSHelper";var ql=e=>class extends(e||tt){static $name="DragHelperContainer";initContainerDrag(){const e=this;if(e.mode||(e.mode="container"),"container"===e.mode&&!e.containers)throw new Error("Container drag mode must specify containers")}grabContainerDrag(e){const t=this;if(!t.ignoreSelector||!e.target.closest(t.ignoreSelector)){const n=ki.getAncestor(e.target,t.containers,t.outerElement);if(n){const i=n.getBoundingClientRect();t.context={element:n,position:ki.getStyleValue(n,"position"),valid:!0,action:"container",offsetX:e.pageX-i.left,offsetY:e.pageY-i.top,originalPosition:{parent:n.parentElement,prev:n.previousElementSibling,next:n.nextElementSibling}}}return!0}return!1}startContainerDrag(e){const t=this,{context:n,floatRootOwner:i}=t,{element:r}=n,s=r.cloneNode(!0),o=null==i?void 0:i.element.closest(".b-outer");s.classList.add(t.dragProxyCls,t.draggingCls),((null==i?void 0:i.floatRoot)||ki.getRootElement(r)).appendChild(s),n.dragProxy=s,n.dragging=r,r.classList.add(t.dropPlaceholderCls),i&&i.element.classList.add("b-dragging-child"),o&&(s.style.zIndex=i.floatRootMaxZIndex+1)}onContainerDragStarted(e){const t=this,{context:n}=t,{element:i,dragProxy:r}=n,s=i.getBoundingClientRect();if(t.autoSizeClonedTarget)r.style.width=s.width+"px",r.style.height=s.height+"px",ki.setTranslateXY(n.dragProxy,s.left,s.top);else if(t.useCenteredCursor){const t=r.getBoundingClientRect();Object.assign(n,{offsetX:t.width/2,offsetY:t.height/2}),ki.setTranslateXY(r,e.clientX,e.clientY)}}updateContainerDrag(e){var t;const n=this,{context:i}=n,{targetElement:r}=i;if(!i.started||!r)return;let s=ki.getAncestor(r,n.containers);const o=null===(t=i.dragging)||void 0===t?void 0:t.contains(ki.getActiveElement(i.dragging));s&&ki.isDescendant(i.element,s)||(o&&Hi.suspendFocusEvents(),i.valid&&(s||n.containers.some((e=>e.contains(r))))?(s||(s=n.containers.find((e=>e.contains(r))).lastElementChild),n.moveNextTo(s,e)):n.revertPosition(),o&&Hi.resumeFocusEvents(),e.preventDefault())}finishContainerDrag(e){const t=this,{context:n}=t,{dragging:i,dragProxy:r,valid:s,draggedTo:o,insertBefore:a,originalPosition:l}=n;i&&(n.valid=Boolean(s&&(o||t.externalDropTargetSelector&&e.target.closest(t.externalDropTargetSelector))&&(i!==a||l.parent!==o)),n.finalize=(e=n.valid)=>{!e&&t.context&&t.revertPosition(),i.classList.remove(t.dropPlaceholderCls),r.remove(),t.reset()},n.async=!1,t.trigger("drop",{context:n,event:e}),n.async||n.finalize())}abortContainerDrag(e=!1,t=null,n=!1){const i=this,{context:r}=i;r.dragging&&(r.dragging.classList.remove(i.dropPlaceholderCls),r.dragProxy.remove(),i.revertPosition()),n||i.trigger(e?"drop":"abort",{context:r,event:t}),i.reset()}updateContainerProxy(e){var t,n;const i=this,{context:r}=i,s=r.dragProxy;let o,a=e.pageX-r.offsetX,l=e.pageY-r.offsetY;if("number"==typeof i.minX&&(a=Math.max(i.minX,a)),"number"==typeof i.maxX&&(a=Math.min(i.maxX-s.offsetWidth,a)),"number"==typeof i.minY&&(l=Math.max(i.minY,l)),"number"==typeof i.maxY&&(l=Math.min(i.maxY-s.offsetHeight,l)),i.lockX?ki.setTranslateY(s,l):i.lockY?ki.setTranslateX(s,a):ki.setTranslateXY(s,a,l),"touchmove"===e.type){const t=e.changedTouches[0];o=ki.elementFromPoint(t.clientX,t.clientY)}else o=e.target;r.targetElement=(null===(t=i.resolveTargetElement)||void 0===t?void 0:t.call(i,o))||o,null!==(n=r.targetElement.nextElementSibling)&&void 0!==n&&n.matches(`.${i.dropPlaceholderCls}`)||(r.insertBefore=r.targetElement.nextElementSibling)}moveNextTo(e,t){const{context:n}=this,i=n.dragging,r=e.parentElement;if(e!==i){const s=_t.from(e).center.x;if(this.isRTL&&t.pageX>s||!this.isRTL&&t.pageX<s){const s=e.previousElementSibling;r.insertBefore(i,e),n.insertBefore=e,s!==i&&this.trigger("itemMove",{context:n,event:t})}else e.nextElementSibling?e.nextElementSibling!==i?(n.insertBefore=e.nextElementSibling,r.insertBefore(i,e.nextElementSibling),this.trigger("itemMove",{context:n,event:t})):n.insertBefore||i.parentElement.lastElementChild===i||(n.insertBefore=e.nextElementSibling):(r.appendChild(i),this.trigger("itemMove",{context:n,event:t}),n.insertBefore=null);n.draggedTo=r}}revertPosition(){const{context:e}=this,{dragging:t,originalPosition:n}=e,{parent:i,next:r}=n;n.parent===t.parent&&n.prev===t.previousElementSibling&&n.next===t.nextElementSibling||(r?i.insertBefore(t,r):i.appendChild(t),this.trigger("itemMove",{context:e})),e.draggedTo=null}};const Yl={pageXOffset:0,pageYOffset:0};var Kl=e=>class extends(nn(e||tt)){static $name="DragHelperTranslate";static get configurable(){return{positioning:null,skipUpdatingElement:null}}initTranslateDrag(){const e=this;!e.isElementDraggable&&e.targetSelector&&(e.isElementDraggable=t=>t.closest(e.targetSelector))}grabTranslateDrag(e){const t=this.getTarget(e);return!!t&&(this.context={valid:!0,element:t,position:ki.getStyleValue(t,"position"),startPageX:e.pageX,startPageY:e.pageY,startClientX:e.clientX,startClientY:e.clientY},!0)}getTarget(e){const{targetSelector:t,target:n}=this;if(t)return e.target.closest(t);const i=n.isWidget?n.element:n;return i.contains(e.target)?i:null}getX(e){return"absolute"===this.positioning?parseFloat(e.style.left,10):"inset"===this.positioning?parseFloat(getComputedStyle(e).insetInlineStart,10):ki.getTranslateX(e)}getY(e){return"absolute"===this.positioning?parseFloat(e.style.top,10):"inset"===this.positioning?parseFloat(getComputedStyle(e).top,10):ki.getTranslateY(e)}getXY(e){if("absolute"===this.positioning)return[e.offsetLeft,e.offsetTop];if("inset"===this.positioning){const t=getComputedStyle(e);return[parseFloat(t.insetInlineStart,10),parseFloat(t.top,10)]}return ki.getTranslateXY(e)}setXY(e,t,n){this.skipUpdatingElement||("absolute"===this.positioning?(e.style.left=t+"px",e.style.top=n+"px"):"inset"===this.positioning?(e.style.insetInlineStart=t+"px",e.style.top=n+"px"):ki.setTranslateXY(e,t,n))}startTranslateDrag(e){const t=this,{context:n,outerElement:i,proxySelector:r}=t,s=t.dragWithin=t.dragWithin||t.cloneTarget&&document.body;let o=n.dragProxy||n.element;const a=o,l=o.parentElement;if(t.cloneTarget){const i=r?o.querySelector(r):o;let{width:l,height:c,x:d,y:u}=_t.from(i,_t.outer(s));t.isRTL&&o.style.insetInlineStart&&(d=_t.outer(s).right-_t.from(o).right),o=t.createProxy(o);let h=d,g=u;if(t.autoSizeClonedTarget&&(o.style.width=`${l}px`,o.style.height=`${c}px`),o.classList.add(t.dragProxyCls,t.draggingCls),o.classList.remove("b-hover","b-selected","b-focused"),s.appendChild(o),!t.autoSizeClonedTarget||r){const t=o.getBoundingClientRect(),{x:i,y:r}=s.getBoundingClientRect(),a=e.clientX-i,l=e.clientY-r+(s!==document.body?document.body.getBoundingClientRect().y:0);h=a-t.width/2,g=l-t.height/2,n.startPageX=e.pageX,n.startPageY=e.pageY}t.setXY(o,h,g),a.classList.add("b-drag-original"),t.hideOriginalElement&&a.classList.add("b-hidden")}o.classList.add(t.draggingCls);const c=t.getX(o),d=t.getY(o);Object.assign(n,{element:o,grabbed:a,grabbedParent:l,grabbedNextSibling:o.nextElementSibling,elementStartX:c,elementStartY:d,elementX:"inset"===t.positioning?c:ki.getOffsetX(o,s||i),elementY:"inset"===t.positioning?d:ki.getOffsetY(o,s||i),scrollX:0,scrollY:0,scrollManagerElementContainsDragProxy:!t.cloneTarget||s===i}),s&&(n.parentElement=o.parentElement,s!==o.parentElement&&s.appendChild(o),t.updateTranslateProxy(e))}onTranslateDragStarted(){var e;const t=this,{context:n}=t;let{relatedElements:i}=n;if(t.unifiedProxy&&n.element.classList.add("b-drag-main","b-drag-unified-proxy"),(null===(e=i)||void 0===e?void 0:e.length)>0){n.relatedElStartPos=[],n.relatedElDragFromPos=[];const{proxySelector:e}=t;let[r,s]=[n.elementStartX,n.elementStartY];n.originalRelatedElements=i,i=n.relatedElements=i.map(((i,o)=>{const a=e?i.querySelector(e):i,{x:l,y:c,width:d,height:u}=_t.from(a,t.dragWithin),h=t.cloneTarget?t.createProxy(i):i;return h.classList.add(t.draggingCls),h.classList.remove("b-hover","b-selected","b-focused"),t.cloneTarget&&(t.setXY(h,l,c),t.dragWithin.appendChild(h),h.classList.add(t.dragProxyCls),t.autoSizeClonedTarget&&(h.style.width=`${d}px`,h.style.height=`${u}px`),t.hideOriginalElement&&i.classList.add("b-hidden"),i.classList.add("b-drag-original")),n.relatedElStartPos[o]=n.relatedElDragFromPos[o]=t.getXY(h),t.unifiedProxy&&(h.classList.add("b-drag-unified-animation","b-drag-unified-proxy"),r+=t.unifiedOffset,s+=t.unifiedOffset,t.setXY(h,r,s),n.relatedElDragFromPos[o]=[r,s],h.style.zIndex=100-o),h})),t.unifiedProxy&&i&&i.length>0&&Mn.onTransitionEnd({element:i[0],property:"transform",handler(){i.forEach((e=>e.classList.remove("b-drag-unified-animation")))},thisObj:t,once:!0})}}applyConstraints(e,t,n){const i=this,{constrain:r,dragWithin:s}=i,{pageXOffset:o,pageYOffset:a}=s===document.body?globalThis:Yl;if(s&&r){const r=new _t(t,n,e.offsetWidth,e.offsetHeight),o=_t.from(s);"fixed"!==i.context.position&&(o.height=s.scrollHeight,o.width=s.scrollWidth,o.moveTo(0,0)),({x:t,y:n}=r.constrainTo(o))}return"number"==typeof i.minX&&(t=Math.max(i.minX+o,t)),"number"==typeof i.maxX&&(t=Math.min(i.maxX+o,t)),"number"==typeof i.minY&&(n=Math.max(i.minY+a,n)),"number"==typeof i.maxY&&(n=Math.min(i.maxY+a,n)),{constrainedX:t,constrainedY:n}}updateTranslateProxy(e,t){const n=this,{lockX:i,lockY:r,context:s}=n,o=s.dragProxy||s.element,{relatedElements:a,relatedElDragFromPos:l}=s,c=n.isRTL&&"inset"===n.positioning?-1:1;s.scrollManagerElementContainsDragProxy&&t&&(s.scrollX=t.getRelativeLeftScroll(o),s.scrollY=t.getRelativeTopScroll(o)),s.pageX=e.pageX,s.pageY=e.pageY,s.clientX=e.clientX,s.clientY=e.clientY;let d=s.elementStartX+(e.pageX-s.startPageX+s.scrollX)*c,u=s.elementStartY+e.pageY-s.startPageY+s.scrollY;if(n.snapCoordinates){const e=n.snapCoordinates({element:o,newX:d,newY:u});d=e.x,u=e.y}const{constrainedX:h,constrainedY:g}=n.applyConstraints(o,d,u);if((s.started||h!==d||g!==u)&&n.setXY(o,i?void 0:h,r?void 0:g),a){const e=i?0:h-s.elementStartX,t=r?0:g-s.elementStartY;a.forEach(((i,r)=>{const[s,o]=l[r];n.setXY(i,s+e,o+t)}))}s.newX=h,s.newY=g}async finishTranslateDrag(e){const t=this,n=t.context,{target:i}=e,r=!t.lockX&&Math.round(n.newX)!==Math.round(n.elementStartX),s=!t.lockY&&Math.round(n.newY)!==Math.round(n.elementStartY),o=n.dragProxy||n.element,{relatedElements:a}=n;if(!t.ignoreSamePositionDrop||r||s)if(!1===n.valid)await t.abortTranslateDrag(!0,e);else{const r=!t.allowDropOutside&&_t.from(t.dragWithin||t.outerElement);r&&("number"!=typeof t.minX&&!0!==t.minX&&e.pageX<r.left||"number"!=typeof t.maxX&&!0!==t.maxX&&e.pageX>r.right||"number"!=typeof t.minY&&!0!==t.minY&&e.pageY<r.top||"number"!=typeof t.maxY&&!0!==t.maxY&&e.pageY>r.bottom)?await t.abortTranslateDrag(!0,e):(n.finalize=async(r=n.valid)=>{n.finalized?console.warn("DragHelper: Finalizing already finalized drag"):(n.finalized=!0,!r&&t.context&&await t.abortTranslateDrag(!0,null,!0),t.isDestroyed||(t.trigger("dropFinalized",{context:n,event:e,target:i}),t.reset()),t.cloneTarget||o.parentElement===n.grabbedParent||[o,...a||[]].forEach((e=>e.style.transform="")))},n.async=!1,await t.trigger("drop",{context:n,event:e,target:i}),n.async||await n.finalize())}else t.abortTranslateDrag(!1,e)}async abortTranslateDrag(e=!1,t=null,n=!1){var i,r;const s=this,{cloneTarget:o,context:a,proxySelector:l,dragWithin:c,draggingCls:d}=s,{relatedElements:u,relatedElStartPos:h,grabbed:g}=a,m=a.dragProxy||a.element;if(a.valid=!1,null===(i=s.scrollManager)||void 0===i||i.stopMonitoring(),a.aborted)return void console.warn("DragHelper: Aborting already aborted drag");let{elementStartX:p,elementStartY:f}=a;const v=p!==s.getX(m)||f!==s.getY(m);if(m&&a.started){if(!o&&c&&c!==a.grabbedParent&&a.grabbedParent.insertBefore(m,a.grabbedNextSibling),o&&l){const e=g.querySelector(l)||g,{x:t,y:n}=_t.from(e);p=t,f=n}if(m.classList.add("b-aborting"),s.setXY(m,p,f),null==u||u.forEach(((e,t)=>{e.classList.remove(d),e.classList.add("b-aborting"),s.setXY(e,h[t][0],h[t][1])})),n||s.trigger(e?"drop":"abort",{context:a,event:t}),m.isConnected&&!s.isDestroying&&v){var y;const e="inset"===s.positioning?"inset":"transform";null!==(y=m.getAnimations)&&void 0!==y&&y.call(m).length&&await Mn.waitForTransitionEnd({element:m,property:ki.getPropertyTransitionDuration(m,e)?e:"all",thisObj:s,once:!0,timeout:300,runOnDestroy:!0})}s.isDestroyed||s.trigger("abortFinalized",{context:a,event:t})}null!==(r=s.context)&&void 0!==r&&r.started&&s.reset()}cleanUp(){const{context:e,cloneTarget:t,draggingCls:n,dragProxyCls:i}=this,r=e.dragProxy||e.element,{relatedElements:s,originalRelatedElements:o,grabbed:a}=e,l=t&&(this.removeProxyAfterDrop||!e.valid),c=[n,"b-aborting",i,"b-drag-main","b-drag-unified-proxy"];r.classList.remove(...c),l&&r.remove(),null==s||s.forEach((e=>{l?e.remove():e.classList.remove(...c)})),a.classList.remove("b-drag-original","b-hidden"),null==o||o.forEach((e=>e.classList.remove("b-hidden","b-drag-original")))}};const Xl=Symbol("body"),Zl="onMouseMove",Jl="onMouseUp",Ql="onDocumentClick",ec="onTouchMove",tc="onTouchEnd",nc="onKeyDown",ic="onKeyDownUp";class rc extends(tt.mixin(dt,ql,Kl)){static configurable={dragProxyCls:"b-drag-proxy",invalidCls:"b-drag-invalid",draggingCls:"b-dragging",dropPlaceholderCls:"b-drop-placeholder",dragThreshold:5,outerElement:Xl,dragWithin:null,unifiedProxy:null,monitoringConfig:null,constrain:!0,minX:null,maxX:null,minY:null,maxY:null,mode:"translateXY",isElementDraggable:null,targetSelector:null,target:null,dropTargetSelector:null,dropTargetCls:null,proxySelector:null,cloneTarget:!1,autoSizeClonedTarget:!0,hideOriginalElement:!1,containers:null,ignoreSelector:null,startEvent:null,lockX:!1,lockY:!1,touchStartDelay:200,scrollManager:null,snapCoordinates:null,unifiedOffset:5,removeProxyAfterDrop:!0,clickSwallowDuration:50,ignoreSamePositionDrop:!0,allowDropOutside:null,floatRootOwner:null,mouseMoveListenerElement:document,externalDropTargetSelector:null,testConfig:{clickSwallowDuration:50,touchStartDelay:100},rtlSource:null,resolveTargetElement:null,disabled:!1};construct(e){const t=this;super.construct(e),t.initListeners(),t.isContainerDrag?t.initContainerDrag():t.initTranslateDrag(),t.onScrollManagerScrollCallback=t.onScrollManagerScrollCallback.bind(t)}doDestroy(){this.reset(!0),super.doDestroy()}changeOuterElement(e){return e===Xl?document.body:e}initListeners(){const e=this,{outerElement:t}=e,n={element:t,pointerdown:"onPointerDown",thisObj:e};e.mouseMoveListenerElement=e.getMouseMoveListenerTarget(t),Mn.on(n)}getMouseMoveListenerTarget(e){const t=e.getRootNode();let n=this.mouseMoveListenerElement;return t.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&"closed"===t.mode&&(n=e.closest(".b-outer")||n),n}get isRTL(){var e;return Boolean(null===(e=this.rtlSource)||void 0===e?void 0:e.rtl)}onPointerDown(e){const t=this;if(0!==e.button||t.context||t.disabled||t.isElementDraggable&&!t.isElementDraggable(e.target,e))return;t.startEvent=e;if(t.isContainerDrag?t.grabContainerDrag(e):t.grabTranslateDrag(e)){const n=globalThis;t.blurDetacher=Mn.on({element:n,blur:t.onWindowBlur,thisObj:t});const i={element:t.mouseMoveListenerElement,thisObj:t,capture:!0,keydown:nc,keyup:ic};if("touch"===e.pointerType?(t.touchStartTimer=t.setTimeout((()=>t.touchStartTimer=null),t.touchStartDelay,"touchStartDelay"),i.touchmove={handler:ec,passive:!1},i.touchend=i.pointerup=tc):(i.pointermove=Zl,i.pointerup=Jl),t.dragListenersDetacher=Mn.on(i),t.dragWithin&&t.dragWithin!==t.outerElement&&t.outerElement.contains(t.dragWithin)){const e=_t.from(t.dragWithin,t.outerElement);t.minY=e.top,t.maxY=e.bottom,t.minX=e.left,t.maxX=e.right}}}async internalMove(e){var t;if(e.scrollInitiated)return;const n=this,{context:i}=n,r=Mn.getDistanceBetween(n.startEvent,e);if(n.touchStartTimer&&r>n.dragThreshold)n.abort(!0);else if(!n.touchStartTimer&&null!=i&&i.element&&(i.started||r>=n.dragThreshold)&&(null===(t=e.target)||void 0===t?void 0:t.nodeType)===Node.ELEMENT_NODE){if(!i.started){var s,o,a;const t=Mn.getXY(n.startEvent),r=Mn.getXY(e),l=Math.abs(t[0]-r[0])>=Math.abs(t[1]-r[1])?"horizontal":"vertical";if(!i.beforeDragStartFired&&!1===n.trigger("beforeDragStart",{context:i,event:e,initialDirection:l}))return n.abort();if(i.beforeDragStartFired=!0,Math.abs(Mn.getDistanceBetween(n.startEvent,e,{x:n.lockY,y:n.lockX}))<n.dragThreshold)return;n.isContainerDrag?n.startContainerDrag(e):n.startTranslateDrag(e),null!==(s=i.dragProxy)&&void 0!==s&&null!==(o=s.closest)&&void 0!==o&&o.call(s,".b-float-root")&&(i.dragProxy.style.fontSize=ki.getStyleValue(i.element,"fontSize")),i.started=rc.dragging=!0,null===(a=n.scrollManager)||void 0===a||a.startMonitoring(U.merge({scrollables:[{element:n.dragWithin||n.outerElement}],callback:n.onScrollManagerScrollCallback},n.monitoringConfig)),i.outermostEl=ki.getOutermostElement(e.target),i.outermostEl.classList.add("b-draghelper-active"),n.dropTargetSelector&&n.dropTargetCls&&ki.getRootElement(n.outerElement).querySelectorAll(n.dropTargetSelector).forEach((e=>e.classList.add(n.dropTargetCls)));const c=n.trigger("dragStart",{context:i,event:e,initialDirection:l});U.isPromise(c)&&await c,n.onKeyDownUp(e),i.moveUnblocked=!0,n.isContainerDrag?n.onContainerDragStarted(e):n.onTranslateDragStarted(e),n.trigger("afterDragStart",{context:i,event:e,initialDirection:l})}i.moveUnblocked?n._cachedMouseEvent?(n.update(e),n.update(n._cachedMouseEvent),delete n._cachedMouseEvent):n.update(e):n._cachedMouseEvent=e}}onScrollManagerScrollCallback(e){var t;const{lastMouseMoveEvent:n}=this;null!==(t=this.context)&&void 0!==t&&t.element&&n&&(n.isScroll=!0,this.update(n,e))}onTouchMove(e){var t;1===(null===(t=e.changedTouches)||void 0===t?void 0:t.length)&&(this.context&&!this.touchStartTimer&&e.preventDefault(),this.internalMove(e))}onMouseMove(e){this.internalMove(e)}update(e,t){const n=this,i=document.scrollingElement||document.body,{context:r}=n;let s=n.getMouseMoveEventTarget(e);if("touchmove"===e.type){const t=e.changedTouches[0];s=ki.getRootElement(e.target).getRootNode().elementFromPoint(t.clientX+i.scrollLeft,t.clientY+i.scrollTop)}r.target=s;let o=n.allowDropOutside||!n.dragWithin||n.dragWithin.contains(e.target);var a;o&&n.dropTargetSelector&&(o=o&&Boolean(null===(a=s)||void 0===a?void 0:a.closest(n.dropTargetSelector)));n.isContainerDrag?n.updateContainerProxy(e,t):n.updateTranslateProxy(e,t),r.valid=o,n.trigger("drag",{context:r,event:e}),n.isContainerDrag&&n.updateContainerDrag(e,t),r.valid=r.valid&&o;for(const e of n.draggedElements)e.classList.toggle(n.invalidCls,!r.valid);e&&(n.lastMouseMoveEvent=e)}get draggedElements(){const{context:e}=this;return[e.dragProxy||e.element,...e.relatedElements??[]]}async abort(e=!1){var t,n;const i=this,{context:r}=i;null===(t=i.scrollManager)||void 0===t||null===(n=t.stopMonitoring)||void 0===n||n.call(t),i.removeListeners(),null!=r&&r.started&&!r.aborted?(r.element.getBoundingClientRect(),r.valid=!1,i.isContainerDrag?i.abortContainerDrag(void 0,void 0,e):i.abortTranslateDrag(void 0,void 0,e),r.aborted=!0):i.reset(!0)}removeListeners(){var e,t;null===(e=this.dragListenersDetacher)||void 0===e||e.call(this),null===(t=this.blurDetacher)||void 0===t||t.call(this)}reset(e){const t=this,{context:n}=t;if(null!=n&&n.started){for(const e of t.draggedElements)e.classList.remove(t.invalidCls);var i;if(n.outermostEl.classList.remove("b-draghelper-active"),t.isContainerDrag)n.dragProxy.remove(),null===(i=t.floatRootOwner)||void 0===i||i.element.classList.remove("b-dragging-child");else t.cleanUp();t.dropTargetSelector&&t.dropTargetCls&&ki.getRootElement(t.outerElement).querySelectorAll(t.dropTargetSelector).forEach((e=>e.classList.remove(t.dropTargetCls)))}t.removeListeners(),e||t.trigger("reset"),t.context=t.lastMouseMoveEvent=null,rc.dragging=!1}onTouchEnd(e){ki.getOutermostElement(e.target).classList.remove("b-no-touch-scroll"),this.onMouseUp(e)}onDocumentClick(e){e.stopPropagation()}onMouseUp(e){const t=this,{context:n}=t;var i;(t.removeListeners(),n)&&(null===(i=t.scrollManager)||void 0===i||i.stopMonitoring(),n.started?n.moveUnblocked?(e.stopPropagation(),n.finalizing=!0,t.isContainerDrag?t.finishContainerDrag(e):t.finishTranslateDrag(e),Mn.on({element:document,thisObj:t,click:Ql,capture:!0,expires:t.clickSwallowDuration,once:!0})):t.ion({drag(){t.onMouseUp(e)},once:!0}):t.reset(!0))}onKeyDown(e){var t;null!==(t=this.context)&&void 0!==t&&t.started&&"Escape"===e.key&&(e.stopImmediatePropagation(),this.abort()),this.onKeyDownUp(e)}onKeyDownUp(e){var t;null===(t=this.context)||void 0===t||t.element.classList.toggle("b-drag-copy",e[d.ctrlKey]||e[d.metaKey])}onWindowBlur(){this.context&&!this.context.finalizing&&this.abort()}createProxy(e){this.proxySelector&&(e=e.querySelector(this.proxySelector)||e);const t=e.cloneNode(!0);return t.removeAttribute("id"),t}get isContainerDrag(){return"container"===this.mode}async animateProxyTo(e,t={align:"c-c"}){const{context:n,draggedElements:i}=this,{element:r}=n,s=e.isRectangle?e:_t.from(e);i.forEach((e=>{e.classList.add("b-drag-final-transition"),ki.alignTo(e,s,t,void 0,void 0,"inset"===this.positioning?"topInset":"translate")})),await Mn.waitForTransitionEnd({element:r,property:"all",thisObj:this,once:!0}),i.forEach((e=>e.classList.remove("b-drag-final-transition")))}get isDragging(){var e;return Boolean(null===(e=this.context)||void 0===e?void 0:e.started)}getMouseMoveEventTarget(e){return e.isScroll?ki.elementFromPoint(e.clientX,e.clientY):e.target}}rc._$name="DragHelper";const sc=Array.prototype.slice,oc=Object.freeze([]),ac=Object.freeze({}),lc=/[&<]/,{getPrototypeOf:cc}=Object,{toString:dc}=Object.prototype,{isEqual:uc,isObject:hc}=U,gc={parent:1,elementData:1,ns:1,syncOptions:1},mc=()=>({ignore:gc,refsFound:new Set}),pc={class:1,className:1,classname:1},fc={bigint:1,boolean:1,function:1,number:1,string:1,symbol:1},vc={tag:1,html:1,text:1,children:1,tooltip:1,parent:1,nextSibling:1,ns:1,reference:1,elementData:1,retainElement:1,compareHtml:1,syncOptions:1,listeners:1,isReleased:1,null:1,"":1,keepChildren:1,retainChildren:1};class yc{static checkEquality(e,t,n,i){if(e===t)return!0;if(null==e)return null==t;if(!e||!t)return!1;const r=typeof e;if(r!==typeof t||fc[r])return!1;let s,o,a,l,c,d,u,h=n.equalityCache||(n.equalityCache=new Map),g=Boolean(i);if(h=h.get(e)||h.set(e,new Map).get(e),s=h.get(t),void 0===s){if(s=!0,cc(e)!==cc(t)||e instanceof Node)s=!1;else if(Array.isArray(e)){if(o=e.length,o!==t.length)s=!1;else for(;o-- >0;)if(!yc.checkEquality(e[o],t[o],n,g)){s=!1;break}}else{var m;for(c in d=e.syncOptions,l=null===(m=d)||void 0===m?void 0:m.ignoreRefs,l&&(g=!0,i="children"!==l),a=n.ignore||ac,t)if(!(a[c]||c in e||i&&"reference"===c)){s=!1;break}if(s)if("[object Date]"===dc.call(t))s=e.getTime()===t.getTime();else if(ki.isReactElement(e)||ki.isReactElement(t)||ki.isVueConfig(e)||ki.isVueConfig(t))s=!1;else for(c in e)if(!(a[c]||i&&"reference"===c)){if(!(c in t)){s=!1;break}if(u=e[c],!yc.checkEquality(u,t[c],n,g)){s=!1;break}}}var p;if(!i&&hc(e)&&e.reference)null===(p=n.refsFound)||void 0===p||p.add(e.reference);h.set(t,s)}return s}static sync(e){const t=e,{refOwner:n}=e,i=null==n?void 0:n.byRef,r=mc();let s,o,a,l,c=e.affected;if("string"==typeof c&&(c=[c]),e={...e,checkEqualityOptions:r},n){if(n.byRef={},c)for(o in i)c.includes(o)||(n.byRef[o]=i[o]);e.refsWas=i}if(t.changed=yc.performSync(e,e.targetElement),n&&i&&(c=c||Object.keys(i)))for(s=0;s<c.length;++s){var d,u;if(o=c[s],a=i[o],r.refsFound.has(o)||a.retainElement)n.byRef[o]=a;else l=a.lastDomConfig,null===(d=(u=a).blur)||void 0===d||d.call(u),a.remove(),n.detachRef(o,a,l)}return e.targetElement}static performSync(e,t){const{domConfig:n,callback:i}=e,{lastDomConfig:r}=t;return(e.configEquality||yc.checkEquality)(n,r,e.checkEqualityOptions,e.ignoreRefs)?(null==i||i({action:"none",domConfig:n,targetElement:t}),!1):(n?(n.onlyChildren||(yc.syncAttributes(n,t,e),yc.syncContent(n,t)),n.keepChildren||yc.syncChildren(e,t)):(t.innerHTML=null,t.syncIdMap=null),t.lastDomConfig=null!=n&&n.onlyChildren&&r?{...r,children:n.children}:n,!0)}static syncDataset(e,t){const{lastDomConfig:n}=t,i=e===n,r=Object.keys(e.dataset),s=n&&n.dataset&&Object.keys(n.dataset),o=rt.delta(r,s);let a,l,c,d;for(l=0;l<o.onlyInA.length;l++)a=o.onlyInA[l],d=e.dataset[a],null!=d&&t.setAttribute(`data-${V.hyphenate(a)}`,d);for(l=0;l<o.inBoth.length;l++)a=o.inBoth[l],d=e.dataset[a],(i||d!=n.dataset[a])&&(c=`data-${V.hyphenate(a)}`,null==d?t.removeAttribute(c):t.setAttribute(c,d));for(l=0;l<o.onlyInB.length;l++)t.removeAttribute(`data-${V.hyphenate(o.onlyInB[l])}`)}static addCls(e,t){const{lastDomConfig:n}=t;(e=Ht.normalize(e,"array")).forEach((e=>{t.classList.add(e),((e,t)=>{const n="className"in t?"className":"class",i=t[n];if(i)if("string"==typeof i){const r=i.split(" ");r.includes(e)||(r.push(e),t[n]=r.join(" "))}else Array.isArray(i)?i.includes(e)||i.push(e):i.isDomClassList?i.add(e):U.isObject(i)&&(i[e]=1)})(e,n)}))}static removeCls(e,t){const{lastDomConfig:n}=t;(e=Ht.normalize(e,"array")).forEach((e=>{t.classList.remove(e),((e,t)=>{const n="className"in t?"className":"class",i=t[n];if(i)if("string"==typeof i){const r=i.split(" ");r.includes(e)&&(r.splice(r.indexOf(e),1),t[n]=r.join(" "))}else Array.isArray(i)?i.includes(e)&&i.splice(i.indexOf(e),1):i.isDomClassList?i.remove(e):U.isObject(i)&&delete i[e]})(e,n)}))}static syncClassList(e,t,n){let i,r,s,o,a,l,c=e.className||e.class,d=!1;if(n){for(r=Ht.normalize(t,"array"),c=Ht.normalize(c,"object"),l=Ht.normalize(n.className||n.class,"object"),a=[],s=0,o=r.length;s<o;++s)i=r[s],c[i]||!(i in l)?(l[i]=1,a.push(i)):d=!0;for(i in c)l[i]||(a.push(i),d=!0);if(!d)return;c=a.join(" ")}else c=Ht.normalize(c);t.setAttribute("class",c)}static getSyncAttributes(e){const t={},n=[];return e&&Object.keys(e).forEach((i=>{if(!vc[i]){const r=i.toLowerCase();t[r]=e[i],n.push(r)}})),{attributes:t,names:n}}static syncAttributes(e,t,n){const{lastDomConfig:i}=t,r=e===i,s=yc.getSyncAttributes(e),{attributes:o,names:a}=s,{attributes:l,names:c}=r?s:yc.getSyncAttributes(i),{onlyInA:d,onlyInB:u,inBoth:h}=r?{onlyInA:oc,onlyInB:oc,inBoth:a}:rt.delta(a,c);let g,m,p=!1;for(m=0;m<d.length;m++){g=d[m];const n=o[g];"style"===g&&null!=n?ki.applyStyle(t,n,!0):"dataset"===g?yc.syncDataset(e,t):pc[g]?(yc.syncClassList(e,t),p=!0):null!=n&&t.setAttribute(g,n)}for(m=0;m<h.length;m++){g=h[m];const i=o[g],s=l[g];null==i?t.removeAttribute(g):"style"===g?n.strict?r?yc.syncStyles(t,i):uc(i,s,!0)||yc.syncStyles(t,i,s):!r&&uc(i,s,!0)||ki.applyStyle(t,i,!0):"dataset"===g?yc.syncDataset(e,t):pc[g]?(yc.syncClassList(e,t,n.strict&&t.lastDomConfig),p=!0):(r||i!==s)&&t.setAttribute(g,i)}for(m=0;m<u.length;m++)g=u[m],pc[g]&&p||t.removeAttribute(g)}static syncStyles(e,t,n){let i,r,s;if(n){if(i={},t=ki.parseStyle(t),n=ki.parseStyle(n),t)for(r in t)s=t[r],n[r]!==s&&(i[r]=s);for(r in n)r in t||(i[r]="")}else i=t;ki.applyStyle(e,i)}static syncContent(e,t){const{html:n,text:i}=e,r=i??n;if(t.didSetTextContent=!1,e.elementData&&(t.elementData=e.elementData),r instanceof DocumentFragment)1===t.childNodes.length&&0===ki.getChildElementCount(t)&&1===r.childNodes.length&&0===ki.getChildElementCount(r)?ki.setInnerText(t,r.firstChild.data):(t.innerHTML="",t.appendChild(r));else if(null!=n&&lc.test(n))t.innerHTML=String(n);else if(null!=r){var s;const{lastDomConfig:e}=t;(null!=e&&null!==(s=e.children)&&void 0!==s&&s.length||null!=e&&e.html&&lc.test(t.lastDomConfig.html))&&(t.innerHTML=""),ki.setInnerText(t,String(r)),t.didSetTextContent=!0}}static insertTextNode(e,t,n,i,r,s=null){const o=document.createTextNode(e);t.insertBefore(o,s),i&&(o.$refOwnerId=i.id),r&&(o.$domSyncOwner=r),null==n||n({action:"newNode",domConfig:e,targetElement:o})}static insertElement(e,t,n,i,r,s,o,a){var l;const c=a.ns?document.createElementNS(a.ns,e.tag||"svg"):document.createElement(e.tag||"div");e.elementData&&(c.elementData=e.elementData),o&&(c.$domSyncOwner=o),t.insertBefore(c,n),yc.performSync(a,c),null!=s&&(r[s]=c),"role"in e||e.tabIndex||e["aria-hidden"]||e.alt||ki.isFocusable(c,!0)||c.htmlFor||c.setAttribute("role","presentation"),i&&(c.$refOwnerId=i.id,s&&(c.$reference=s,i.attachRef(s,c,e))),null===(l=a.callback)||void 0===l||l.call(a,{action:"newElement",domConfig:e,targetElement:c,syncId:s})}static syncChildren(e,t){let n,i,r,s,o,{domConfig:a,syncIdField:l,callback:c,releaseThreshold:d,configEquality:u,ns:h,refOwner:g,refsWas:m,strict:p,syncOwner:f,checkEqualityOptions:v,ignoreRefs:y}=e,b=null;const C=a.syncOptions||{};if(a.html??a.text)return;y=Boolean(C.ignoreRefs??y),y&&(g=m=null),"strict"in C&&(p=C.strict);const S=g?g.byRef:{},w=sc.call(a.children||[]),D=[],E=m||t.syncIdMap||{},x=t.releasedIdMap||{},R=e=>{for(;D.length&&D[0].parentNode!==t;)D.shift();return(e?D.shift():D[0])||null};for(n of t.childNodes)i=n.$domSyncOwner,(f?f!==i:i)||D.push(n);l=C.syncIdField||l,p=C.strict||p,c=C.callback||c,u=C.configEquality||u,d="releaseThreshold"in C?C.releaseThreshold:d,l&&(t.syncIdMap=S);const T={checkEqualityOptions:v||mc(),ignoreRefs:y,refOwner:g,refsWas:m,strict:p,syncIdField:l,releaseThreshold:d,syncOwner:f,callback:c,configEquality:u};for(;w.length;){const n=w.shift();if(o=null,!n)continue;if(ki.isReactElement(n)||ki.isVueConfig(n)){c({jsx:n,targetElement:t,domConfig:a});continue}if(Array.isArray(n)){this.syncChildren({...e,domConfig:{...e.domConfig,children:n}},t);continue}if(n instanceof Node){s=R(),n!==s&&t.insertBefore(n,s),r=D.indexOf(n),r>-1&&D.splice(r,1);continue}const i="string"==typeof n;if(T.domConfig=n,T.ns=n.ns||h,!i){if(g?o=n.reference:l&&n.dataset&&(o=n.dataset[l]),null!=o&&!n.unmatched){const e=E[o]||x[o];if(e){const{lastDomConfig:i}=e;if(e.retainElement&&"prevent-release"!==e.retainElement);else if(yc.performSync(T,e)){var M;null===(M=c)||void 0===M||M({action:"reuseOwnElement",domConfig:n,targetElement:e,lastDomConfig:i,syncId:o})}n.retainElement&&(e.retainElement=!0),S[o]=e,rt.remove(D,e),delete x[o],e.isReleased=!1,s=R(),(e.parentNode!==t||p&&e.nextSibling!==s)&&t.insertBefore(e,s)}else p?yc.insertElement(n,t,R(),g,S,o,f,T):(w.push(n),n.unmatched=!0);continue}n.unmatched&&delete n.unmatched}let d,u=null,m=null;for(;!m&&(d=R(!0));){if(g){if(d.$refOwnerId!==g.id)continue;if(d.$reference){if(!p)continue;u=d;break}m=d}else d.retainElement||(m=d);m||(b||(b=[])).push(d)}if(u||!m)i?yc.insertTextNode(n,t,c,g,f,u):yc.insertElement(n,t,u,g,S,o,f,T);else if(i||m.nodeType!==Node.ELEMENT_NODE||(n.tag||"div").toLowerCase()!==m.tagName.toLowerCase())if(i&&m.nodeType===Node.TEXT_NODE)m.data=n;else{var I,k;i?yc.insertTextNode(n,t,c,g,f,m):yc.insertElement(n,t,m,g,S,o,f,T),null===(I=(k=m).blur)||void 0===I||I.call(k),m.remove()}else{var F,A;const{lastDomConfig:e}=m,t=yc.performSync(T,m);if(l&&null!=(null==e||null===(F=e.dataset)||void 0===F?void 0:F[l])){const t=e.dataset[l];delete x[t],delete E[t]}null!=o&&(S[o]=m),m.isReleased=!1,t&&(null===(A=c)||void 0===A||A({action:"reuseElement",domConfig:n,targetElement:m,lastDomConfig:e,syncId:o}))}}if(!(t.didSetTextContent&&1===D.length&&D[0].nodeType===Node.TEXT_NODE||a.retainChildren)){for(;s=R(!0);)g&&(s.$refOwnerId!==g.id||s.$reference)||(b||(b=[])).push(s);b&&yc.syncChildrenCleanup(t,b,S,c,g,d,l)}}static syncChildrenCleanup(e,t,n,i,r,s,o){let a,l=0;for(const d of t){const{lastDomConfig:t}=d;var c;if(d.nodeType!==Element.TEXT_NODE)if(d.retainElement)o&&t&&(n[d.dataset[o]]=d);else if(!r&&o&&(null==s||l<s))d.isReleased||(d.className="b-released",d.isReleased=!0,null!=t&&t.dataset&&(e.releasedIdMap||(e.releasedIdMap={}),e.releasedIdMap[t.dataset[o]]=d),null==i||i({action:"releaseElement",domConfig:t,lastDomConfig:t,targetElement:d}),t&&(t.isReleased=!0,t.className&&(t.className="b-released"),t.class&&(t.class="b-released"),t.style&&(t.style=null))),l++;else null===(c=d.blur)||void 0===c||c.call(d),d.remove(),r&&(a=d.$reference,a&&r.detachRef(a,d,t)),e.releasedIdMap&&o&&null!=t&&t.dataset&&delete e.releasedIdMap[t.dataset[o]],null==i||i({action:"removeElement",domConfig:d.lastDomConfig,lastDomConfig:d.lastDomConfig,targetElement:d});else d.remove()}}static removeChild(e,t){if(e.contains(t)){const n=e.syncIdMap;if(n){const e=Object.values(n).indexOf(t);e>-1&&delete n[Object.keys(n)[e]]}e.removeChild(t)}}static addChild(e,t,n){e.appendChild(t),e.syncIdMap||(e.syncIdMap={}),e.syncIdMap[n]=t}static getChild(e,t){const n=String(t).split(".");for(const t of n){var i;if(!(e=null===(i=e)||void 0===i||null===(i=i.syncIdMap)||void 0===i?void 0:i[t]))return null}return e}}yc._$name="DomSync";class bc{static init(){const e=["fullscreenEnabled","requestFullscreen","exitFullscreen","fullscreenElement"],t=t=>e.map((e=>{let n=t+V.capitalize(e);return"moz"===t&&(n=n.replace("screen","Screen"),"mozCancelFullScreen"in document&&"exitFullscreen"===e&&(n="mozCancelFullScreen")),n}));this.functions="fullscreenEnabled"in document&&e||"webkitFullscreenEnabled"in document&&t("webkit")||"mozFullScreenEnabled"in document&&t("moz")||"msFullscreenEnabled"in document&&t("ms")||[];const n=["fullscreenchange","fullscreenerror"],i=e=>n.map((t=>e+V.capitalize(t)));this.events="fullscreenEnabled"in document&&n||"webkitFullscreenEnabled"in document&&i("webkit")||"mozFullscreenEnabled"in document&&i("moz")||"msFullscreenEnabled"in document&&["MSFullscreenChange","MSFullscreenError"]||[],this.onFullscreenChange(this.onInternalFullscreenChange.bind(this))}static get enabled(){return Boolean(this.functions[0]&&document[this.functions[0]])}static async request(e){return this.functions[1]&&(null==e?void 0:e[this.functions[1]]())}static async exit(){return this.functions[2]&&document[this.functions[2]]()}static get isFullscreen(){return Boolean(this.element)}static get element(){return this.functions[3]&&document[this.functions[3]]}static onFullscreenChange(e){this.events[0]&&document.addEventListener(this.events[0],e)}static unFullscreenChange(e){this.events[0]&&document.removeEventListener(this.events[0],e)}static onInternalFullscreenChange(e){const t=globalThis.bryntum,{element:n}=bc;if(bc.isFullscreen&&t._floatRoot||!bc.isFullscreen&&!t._floatRoot)return;let i,r;if(n){if(!n.closest(".b-floatroot")){i=ki.getRootElement(n).floatRoot,i&&(t._floatRoot=i,t._oldParent=i.parentElement,r=n)}}else i=t._floatRoot,r=i&&t._oldParent,t._oldParent=t._floatRoot=null;if(r){const e=Array.from(i.querySelectorAll(".b-widget")).map((e=>hd.fromElement(e)));e.forEach((e=>{var t;return null===(t=e.beforeFloatReparent)||void 0===t?void 0:t.call(e)})),r.appendChild(i),e.forEach((e=>{var t;return null===(t=e.afterFloatReparent)||void 0===t?void 0:t.call(e)}))}Hi.trigger("fullScreenChange",{event:e})}}bc.init(),bc._$name="Fullscreen";let Cc=null;const Sc=[],wc=e=>{var t;return e.nodeType===e.ELEMENT_NODE&&"absolute"===(null===(t=e.ownerDocument.defaultView)||void 0===t?void 0:t.getComputedStyle(e).getPropertyValue("position"))};class Dc{static addResizeListener(e,t){const n=this;if(e!==document&&e!==globalThis||(e=document.body),e.nodeType===e.DOCUMENT_FRAGMENT_NODE&&(e=e.host),e.classList.contains("b-resize-monitored")||(e.classList.add("b-resize-monitored"),e._bResizemonitor={handlers:[]}),e===document.body)n.hasWindowResizeListener||(globalThis.addEventListener("resize",n.onWindowResize),n.hasWindowResizeListener=!0);else if(globalThis.ResizeObserver)n.resizeObserver||(n.resizeObserver=new ResizeObserver(n.onElementResize)),n.resizeObserver.observe(e);else{e.classList.add("b-no-resizeobserver");const[i,r,s]=ki.createElement({parent:e,className:"b-resize-monitors",children:[{className:"b-resize-monitor-expand"},{className:"b-resize-monitor-shrink"}]},{returnAll:!0});r.scrollLeft=r.scrollTop=s.scrollLeft=s.scrollTop=1e6,r.addEventListener("scroll",n.onSizeMonitorScroll,!0),s.addEventListener("scroll",n.onSizeMonitorScroll,!0),(t.targetMutationMonitor=new MutationObserver((e=>{const t=[],n=[];for(const i of e)"childList"===i.type&&(t.push.apply(t,i.addedNodes),n.push.apply(n,i.removedNodes));const i=[...t.filter((e=>!n.includes(e))),...n.filter((e=>!t.includes(e)))];0!==i.length&&(i.length>0&&i.every(wc)||r.dispatchEvent(new CustomEvent("scroll",{bubbles:!1})))}))).observe(e,{childList:!0,subtree:!0}),t.monitorElement=i}e._bResizemonitor.handlers.push(t)}static removeResizeListener(e,t){if(e){e!==document&&e!==globalThis||(e=document.body);const n=e._bResizemonitor;let i=0;n&&n.handlers&&(rt.remove(n.handlers,t),i=n.handlers.length),i||(e.classList.remove("b-resize-monitored"),this.resizeObserver?this.resizeObserver.unobserve(e):(t.monitorElement&&(t.monitorElement.remove(),t.monitorElement=null),t.targetMutationMonitor&&t.targetMutationMonitor.disconnect()))}}static onElementResize(e){for(const t of e){const e=t.target,n=e._bResizemonitor,i=t.contentRect||e.getBoundingClientRect();if(fi(e)&&(!n.rectangle||i.width!==n.rectangle.width||i.height!==n.rectangle.height)){const t=n.rectangle;n.rectangle=i;for(const r of n.handlers)r(e,t,i)}}}static onSizeMonitorScroll(e){var t;if(e.target.isConnected||null!==(t=document.body)&&void 0!==t&&t.contains(e.target)){e.stopImmediatePropagation();const t=e.target.parentNode,n=t.parentNode,i=n._bResizemonitor,r=n.getBoundingClientRect();i.rectangle&&r.width===i.rectangle.width&&r.height===i.rectangle.height||(Sc.push([n,i.rectangle,r]),i.rectangle=r,Cc||(Cc=requestAnimationFrame(Dc.fireResizeEvents))),t.firstChild.scrollLeft=t.firstChild.scrollTop=t.childNodes[1].scrollTop=t.childNodes[1].scrollLeft=1e6}}static onWindowResize(e){const t=document.body,n=t._bResizemonitor,i=n.rectangle;n.rectangle=document.documentElement.getBoundingClientRect();for(const e of n.handlers)e(t,i,n.rectangle)}static fireResizeEvents(){for(const e of Sc)for(const t of e[0]._bResizemonitor.handlers)e[0].offsetParent&&t.apply(this,e);Cc=null,Sc.length=0}static removeGlobalListeners(){globalThis.removeEventListener("resize",this.onWindowResize)}}Dc._$name="ResizeMonitor";const Ec={auto:"auto",true:"auto",false:"hidden","hidden-scroll":"auto",clip:d.supportsOverflowClip?"clip":"hidden"},xc="b-widget-scroller",Rc={block:"nearest"},Tc=Promise.resolve(),Mc=e=>new Promise((t=>Mn.on({element:e===document.documentElement?globalThis:e,scroll:t,once:!0}))),Ic={x:1},kc={auto:1,scroll:1},Fc={true:1,auto:1},Ac={overflowX:"auto",overflowY:"auto"};class Pc extends(nn(dt(tt))){static get configurable(){return{widget:null,element:{$config:{nullify:!0},value:null},contentElement:{$config:{nullify:!0},value:null},overflowX:null,overflowY:null,translate:null,behavior:null,x:0,y:0,rtlSource:null,propagateSync:null,stickies:null}}static get delayable(){return{onScrollEnd:{type:"buffer",delay:100}}}get isRTL(){var e;return Boolean(null===(e=this.rtlSource)||void 0===e?void 0:e.rtl)}syncOverflowState(){const e=this,{hasOverflowX:t,hasOverflowY:n,element:i}=e,r=e.hasOverflowX=i.scrollWidth>i.clientWidth,s=e.hasOverflowY=i.scrollHeight>i.clientHeight;if(t!==r||n!==s){const t=new Ht(i.classList,{"b-horizontal-overflow":r,"b-vertical-overflow":s});ki.syncClassList(i,t),e.isConfiguring||e.trigger("overflowChange",{x:r,y:s})}}hasOverflow(e="y"){const t=this,n=t[`overflow${e.toUpperCase()}`],i=t["overflow"+("y"===e?"x":"y")];if(!ki.scrollBarWidth||!Fc[n]||"hidden-scroll"===i){const n="y"===e?"Height":"Width";return t[`scroll${n}`]>t[`client${n}`]}return t[`hasOverflow${e.toUpperCase()}`]}hasScrollbar(e="y"){const{element:t}=this;if(t&&ki.scrollBarWidth){const n="y"===e,i=n?"Width":"Height",r=t[`client${i}`],s=parseInt(ki.getStyleValue(t,`border${n?"Left":"Top"}Width`))+parseInt(ki.getStyleValue(t,`border${n?"Right":"Bottom"}Width`)),o=t[`offset${i}`]-s-r;return Math.abs(o-ki.scrollBarWidth)<2}}addPartner(e,t=Ic){const n=this;"string"==typeof t&&(t={[t]:1}),n.partners||(n.partners={}),n.partners[e.id]={scroller:e,axes:t},t.x&&(e.x=n.x),t.y&&(e.y=n.y),e.isPartneredWith(n)||e.addPartner(n,t)}eachPartner(e){const{partners:t}=this;t&&Object.values(t).forEach(e)}removePartner(e){e&&this.isPartneredWith(e)&&(delete this.partners[e.id],e.removePartner(this))}isPartneredWith(e){var t;return Boolean(null===(t=this.partners)||void 0===t?void 0:t[e.id])}clearPartners(){this.partners&&Object.values(this.partners).forEach((e=>e.scroller.removePartner(this)))}async scrollIntoView(e,t=Rc){const n=this,{isRectangle:i}=e,r=i?e:_t.from(e),{xDelta:s,yDelta:o}=n.getDeltaTo(e,t),a=n.scrollBy(s,o,t);return(t.highlight||t.focus)&&a.then((()=>{var a;if(e=i?r.translate(-s,-o):(null===(a=t.elementAfterScroll)||void 0===a?void 0:a.call(t))??e,t.highlight)if(isNaN(t.highlight)){const i=n.widget||n;i.callback(t.highlight,i,[e])}else ki.highlight(e,n);t.focus&&e.focus({preventScroll:!0})})),a}static async scrollIntoView(e,t=Rc,n=!1){const i=_t.from(e),r="object"==typeof t?t.animate:t,s=Pc._globalScroller||(Pc._globalScroller=new Pc),o=[];s.rtlSource={rtl:n};let a,l=0,c=0;t.maxWidth&&(i.width=Math.min(i.width,t.maxWidth),t.maxWidth=null),t.maxHeight&&(i.height=Math.min(i.height,t.maxHeight),t.maxHeight=null);for(let n=e.parentNode;n.nodeType===Node.ELEMENT_NODE;n=n.parentNode){if(n===document.body&&n!==document.scrollingElement)continue;const e=n===document.scrollingElement?Ac:n.ownerDocument.defaultView.getComputedStyle(n),r=Ul.get(n,"scroller");if(!1!==t.y&&(null!=r&&r.hasOverflowY||kc[e.overflowY]&&n.scrollHeight>n.clientHeight)||!1!==t.x&&(null!=r&&r.hasOverflowX||kc[e.overflowX]&&n.scrollWidth>n.clientWidth)){let e=s;r?e=r:(s.element=n,s.positionDirty=!0);const{xDelta:a,yDelta:d}=e.getDeltaTo(i,t);(a||d)&&(o.push({element:n,x:n.scrollLeft,y:n.scrollTop,xDelta:a,yDelta:d}),i.translate(-a,-d),l+=a,c+=d)}}if(o.length){const e=Math.abs(l),t=Math.abs(c);let i=r&&("number"==typeof r?r:"number"==typeof r.duration?r.duration:300);if(i&&(e>10||t>10))Math.max(e,t)<50&&(i=Math.min(i,500)),a=s.scrollAnimation=te.animate(i,(e=>{const t=1===e;for(const{element:i,x:r,y:a,xDelta:l,yDelta:c}of o)s.element=i,l&&(s.x=Math[n?"min":"max"](r+(t?l:Math.round(l*e)),0)),c&&(s.y=Math.max(a+(t?c:Math.round(c*e)),0))}),null,r.easing),a.then((()=>{s.scrollAnimation=null}));else if(e>=1||t>=1){for(const{element:e,xDelta:t,yDelta:n}of o)e.scrollTop+=n,e.scrollLeft+=t;a=Mc(o[o.length-1].element)}}return(t.highlight||t.focus)&&(await a,t.highlight&&(isNaN(t.highlight)?s.callback(t.highlight,null,[e]):ki.highlight(e,s)),t.focus&&e.focus({preventScroll:!0})),a}scrollBy(e=0,t=0,n=Rc){const i=this,r="object"==typeof n?n.animate:n,s=Math.abs(e),o=Math.abs(t);i.scrollAnimation&&(i.scrollAnimation.cancel(),i.scrollAnimation=null),(e||t)&&(i.silent=n.silent);let a=r&&("number"==typeof r?r:"number"==typeof r.duration?r.duration:300);if(a&&(s>10||o>10)){const{x:l,y:c}=i;let d=l,u=c;return Math.max(s,o)<50&&(a=Math.min(a,500)),i.scrollAnimation=te.animate(a,(r=>{const s=1===r;if(e){var o;if(Math.abs(i.x-d)>1&&!n.force)return null===(o=i.scrollAnimation)||void 0===o?void 0:o.cancel();i.x=Math.max(l+(s?e:Math.round(e*r)),0)}if(t){var a;if(Math.abs(i.y-u)>1&&!n.force)return null===(a=i.scrollAnimation)||void 0===a?void 0:a.cancel();i.y=Math.max(c+(s?t:Math.round(t*r)),0)}d=i.x,u=i.y}),i,r.easing),i.element.classList.add("b-scrolling"),i.scrollAnimation.then((()=>{i.isDestroyed||(i.element.classList.remove("b-scrolling"),i.scrollAnimation=null)})),i.scrollAnimation}if(e||t){const n=i.x,r=i.y;if(Math.round(s)>=1&&(i.x+=e),Math.round(o)>=1&&(i.y+=t),i.x!==n||i.y!==r)return Mc(i.element)}return Tc}async scrollTo(e,t,n){const{x:i,y:r}=this,s=null==e?0:e-i,o=null==t?0:t-r;return this.scrollingToCenter=null==n?void 0:n.scrollingToCenter,this.scrollBy(s,o,n)}doDestroy(){var e;const t=this;var n;t._element&&(t._element.removeEventListener("scroll",t.scrollHandler),null===(n=t.wheelListenerRemover)||void 0===n||n.call(t),t._contentElement&&Dc.removeResizeListener(t.contentElement,t.resizeHandler),Dc.removeResizeListener(t._element,t.resizeHandler));null===(e=t.scrollAnimation)||void 0===e||e.cancel(),Object.values(t.partners||{}).forEach((({scroller:e})=>e.removePartner(t))),super.doDestroy()}onElMutation(e){const t=this,[n,i]=ki.getTranslateXY(t.element);if(t._x!==-n||t.y!==-i){const e=new CustomEvent("scroll",{bubbles:!0});Object.defineProperty(e,"target",{get:()=>t.element}),t.onScroll(e)}}onElResize(){const e=this,{widget:t}=e;null!=t&&t.isAnimating?-1===t.findListener("animationend","onElResize",e)&&t.ion({animationEnd:"onElResize",thisObj:e,once:!0}):e.syncOverflowState()}onScroll(e){var t;const n=this,{element:i}=n;null!==(t=n.widget)&&void 0!==t&&t.isDestroyed||(n.positionDirty=!0,i.classList.contains("b-scrolling")||i.classList.add("b-scrolling"),e.widget=n.widget,e.scrollingToCenter=n.scrollingToCenter,n.silent||n.trigger("scroll",e),n.syncPartners(),n.controllingPartner=null,n.onScrollEnd(e))}syncPartners(e,t=this.propagateSync){const n=this;n.partners&&Object.values(n.partners).forEach((({axes:i,scroller:r})=>{(r!==n.controllingPartner||e)&&r.sync(n,i)&&t&&r.syncPartners(e,t)}))}onScrollEnd(e){const t=this;t.silent&&(t.silent=!1),t.trigger("scrollEnd",e),t.scrollingToCenter=!1,t.controllingPartner=null,t.element.classList.remove("b-scrolling")}getDeltaTo(e,t){const n=this,{x:i,y:r}=n,{precise:s}=t,o=t.viewport||n.viewport;if(!o)return{xDelta:0,yDelta:0};const a=(e=>{let t,n,i,r;return e?"number"==typeof e?t=n=i=r=e:(t=e.top??0,n=e.bottom??0,i=e.start??0,r=e.end??0):t=n=i=r=0,{block:{start:t,end:n},inline:{start:i,end:r}}})(t.edgeOffset),l=e instanceof _t?e:_t.from(e);let c=!1===t.x?0:n.getDelta({viewport:o,targetRect:l,edgeOffset:a.inline,flow:"inline",targetEdge:t.inline||t.block||"nearest",maxSize:t.maxWidth,precise:s})*(n.isRTL?-1:1),d=!1===t.y?0:n.getDelta({viewport:o,targetRect:l,edgeOffset:a.block,flow:"block",targetEdge:t.block||"nearest",maxSize:t.maxHeight,precise:s});return!1!==t.constrainToScrollable&&(c=Math.max(Math.min(c,Math.max(n.maxX-i,0)),-i),d=Math.max(Math.min(d,Math.max(n.maxY-r,0)),-r)),{xDelta:c,yDelta:d}}getDelta({viewport:e,targetRect:t,edgeOffset:n={start:0,end:0},flow:i,targetEdge:r="nearest",maxSize:s,precise:o}){const a="block"===i,l=!a&&this.isRTL,c=a?"y":"x",d=a?"bottom":"right",u=a?"y":l?"right":"x",h=a?"bottom":l?"x":"right",g=a?"height":"width";let m=0;if("center"===r)m=t.center[c]-e.center[c];else if("start"===r||"end"===r){const i="start"===r,s=i?u:h,o=n[r],c=e[g]>o?(i?-1:1)*(a||!l?1:-1):0;m=t[s]+o*c-e[s]}else{const a=Math.max(t[c],e[c]),l=Math.min(t[d],e[d]),p=l>a?l-a:0,f=t[g];p<=Math.min(s||Number.MAX_SAFE_INTEGER,f)&&f>p&&((t=t.clone())[g]>s&&(t[c]<e[c]?t[c]=Math.max(t[c],t[d]-s):t[g]=Math.min(f,s),n=void 0),r=Math.min(t[g],s||Number.MAX_SAFE_INTEGER)>e[g]||Math.abs(t[u]-e[u])<Math.abs(t[h]-e[h])?"start":"end",m=this.getDelta({viewport:e,targetRect:t,edgeOffset:n,flow:i,targetEdge:r,maxSize:s,precise:o}))}return o?m:Math.round(m)}get viewport(){const e=this.stickies?rt.asArray(this.stickies).flatMap((e=>"string"==typeof e?Array.from(this.element.querySelectorAll(e)):e)):null,t=_t.client(this.element);return e?t.exclude(e.map((e=>_t.from(e)))):t}updateWidget(e){this.rtlSource=this.owner=e}updateElement(e,t){const n=this;if(n===Pc._globalScroller)return n._element=e,void(n.positionDirty=!0);const i=n.scrollHandler||(n.scrollHandler=n.onScroll.bind(n)),r=n.resizeHandler||(n.resizeHandler=n.onElResize.bind(n));if(t){var s;if(Ul.remove(t,"scroller"),n.translate)null===(s=n.mutationObserver)||void 0===s||s.disconnect();else t.removeEventListener("scroll",i),t.classList.remove(xc),t.style.overflowX=t.style.overflowY="";Dc.removeResizeListener(t,r)}if(e){if(Ul.set(e,"scroller",n),n.translate){if(n.mutationObserver||(n.mutationObserver=new MutationObserver(n.mutationHandler||(n.mutationHandler=n.onElMutation.bind(n)))),n._x=n._y=0,document.contains(e)){const[t,i]=ki.getTranslateXY(e);n._x=-t,n._y=-i}n.mutationObserver.observe(e,{attributes:!0})}else e.addEventListener("scroll",i),e.classList.add(xc);Dc.addResizeListener(e,r),n.widget||(n.rtlSource={get rtl(){return"rtl"===ki.getStyleValue(e,"direction")}}),n.isRTL&&e.classList.add("b-rtl"),n.positionDirty&&(n.updateOverflowX(n.overflowX),n.updateOverflowY(n.overflowY)),n.syncOverflowState(),n.isConfiguring&&(n._x&&n.updateX(n._x),n._y&&n.updateY(n._y))}n.positionDirty=!0}get unsynced(){const e=this,[t,n]=e.xy;return e._x!==t||e._y!==n}get xy(){const{element:e}=this;let t,n;return e&&(this.translate?([t,n]=ki.getTranslateXY(e),t=-t,n=-n):(t=Math.abs(e.scrollLeft),n=e.scrollTop)),[t,n]}refreshPosition(){const e=this,[t,n]=e.xy;e._x=t,e._y=n,e.positionDirty=!1}fixPositionSync(){const e=this,{element:t,xy:n,_x:i,_y:r}=e;e.positionDirty||i===n[0]&&r===n[1]||(e.translate?(ki.setTranslateX(t,-i),ki.setTranslateY(t,-r)):t.scrollTo({behavior:"instant",left:e.isRTL?-i:i,top:r}))}get x(){return this.positionDirty&&this.refreshPosition(),this._x}get scrollLeft(){return this.x*(this.isRTL?-1:1)}changeX(e){if(e=Math.max(e,0),!this.isConfiguring||e)return e;this._x=e}updateContentElement(e){e&&(e="string"==typeof e?this.element.querySelector(e):e,Dc.addResizeListener(e,this.resizeHandler))}updateX(e){var t;const n=this,{behavior:i,element:r}=n;!r||null!==(t=n.widget)&&void 0!==t&&t.isConfiguring||(e=Math.round(e),n.trigger("scrollStart",{x:e}),n.translate?ki.setTranslateX(r,-e):i?r.scrollTo({behavior:i,left:n.isRTL?-e:e}):r.scrollLeft=n.isRTL?-e:e),n.positionDirty=!0}sync(e,t){const n=this,{x:i,y:r}=t;let s=!1;return i&&n.x!==e.x&&(n.controllingPartner=e,n.x=e.x,s=!0),r&&n.y!==e.y&&(n.controllingPartner=e,n.y=e.y,s=!0),s}get y(){return this.positionDirty&&this.refreshPosition(),this._y}changeY(e){if(!this.isConfiguring||e)return e;this._y=e}updateY(e){const t=this,{behavior:n,element:i,widget:r}=t;!i||null!=r&&r.isConfiguring||(t.trigger("scrollStart",{y:e}),t.translate?ki.setTranslateY(i,-e):n?i.scrollTo({behavior:n,top:e}):i.scrollTop=e),t.positionDirty=!0}get maxX(){return this.scrollWidth-this.clientWidth}get maxY(){return this.scrollHeight-this.clientHeight}get lastScrollLeft(){return(this.scrollWidth-this.clientWidth)*(this.isRTL?-1:1)}updateOverflowX(e,t){const n=this,{element:i,translate:r}=n,{style:s,classList:o}=i;if("hidden-scroll"===t&&o.remove("b-hide-scroll"),"hidden-scroll"===e&&!r){kc[n.overflowY]?(e="hidden",n.enableWheel()):o.add("b-hide-scroll")}r||(s.overflowX=Ec[e]||e),n.isConfiguring||(n.positionDirty=!0,n.syncOverflowState())}updateOverflowY(e,t){const n=this,{element:i,translate:r}=n,{style:s,classList:o}=i;if("hidden-scroll"===t&&o.remove("b-hide-scroll"),"hidden-scroll"===e&&!r){kc[n.overflowX]?(e="hidden",n.enableWheel()):o.add("b-hide-scroll")}r||(s.overflowY=Ec[e]||e),n.isConfiguring||(n.positionDirty=!0,n.syncOverflowState())}enableWheel(){this.wheelListenerRemover||(this.wheelListenerRemover=Mn.on({element:this.element,wheel:"onWheel",thisObj:this}))}onWheel(e){const t=this,{overflowX:n,overflowY:i}=t,r=e.deltaX,s=e.deltaY,o=Math.abs(r)-Math.abs(s);"hidden-scroll"===n&&kc[i]&&o>0?t.x+=r:"hidden-scroll"===i&&kc[n]&&o<0&&(t.y+=s)}get scrollWidth(){var e;return(null===(e=this.element)||void 0===e?void 0:e.scrollWidth)??0}set scrollWidth(e){const t=this,{element:n,isRTL:i}=t;let r=t.widthStretcher;r&&null==e?(r.remove(),t.widthStretcher=null):e&&(e=Math.abs(e),r||(r=t.widthStretcher=ki.createElement({className:"b-scroller-stretcher b-horizontal-stretcher",role:null,retainElement:!0})),r.style.transform=`translateX(${(e-1)*(i?-1:1)}px)`,n&&!n.contains(r)&&n.insertBefore(r,n.firstElementChild)),n.style.setProperty("--scroll-width",ki.setLength(e)),!1!==t.propagate&&t.eachPartner((({scroller:t})=>{t.propagate=!1,t.scrollWidth=e,delete t.propagate})),t.positionDirty=!0,t.syncOverflowState()}get scrollHeight(){var e;return(null===(e=this.element)||void 0===e?void 0:e.scrollHeight)??0}set scrollHeight(e){const t=this,n=t.stretcher||(t.stretcher=ki.createElement({className:"b-scroller-stretcher",role:null}));n.style.transform=`translateY(${e-1}px)`,t.element&&t.element.lastChild!==n&&t.element.appendChild(n),t.positionDirty=!0,t.syncOverflowState()}get clientWidth(){var e;return(null===(e=this.element)||void 0===e?void 0:e.clientWidth)||0}get clientHeight(){var e;return(null===(e=this.element)||void 0===e?void 0:e.clientHeight)||0}get id(){return this._id||(this._id=Ro.generateId(this.widget?`${this.widget.id}-`:"scroller-")),this._id}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(),delete e.widget,delete e.element}}Pc._$name="Scroller";const Lc=/\/[^/]+\//,Oc={};var $c=e=>class extends(e||tt){static $name="KeyMap";static configurable={keyMap:{value:null,$config:{merge:"objects",nullify:!0}}};get widgetClass(){}get keyMapElement(){return this.element}get keyMapSubComponents(){return this.features}addKeyBinding(e,t){const n=this.keyMap,i=this.mergeKeyMaps({[e]:null==n?void 0:n[e]},{[e]:t})[e];n?n[e]=i:this.keyMap={[e]:i}}removeKeyBinding(e,t){var n;const i=null===(n=this.keyMap)||void 0===n?void 0:n[e];if(i){let n=0;Array.isArray(i)?(n=i.findIndex((e=>e===t||e.handler===t)),n>-1&&i.splice(n,1)):i!==t&&i.handler!==t||delete this.keyMap[e]}}matchKeyMapEntry(e,t=this.keyMap){const{input:n}=this,{altKey:i,ctrlKey:r,metaKey:s,shiftKey:o,target:a}=e;return!(1!==e.key.length||i||r||s||o||n&&e.composedPath().includes(n)||!ki.isEditable(a,!0))||(t&&!e.handled&&void 0!==e.key?U.keys(t).find((t=>{const n="+"===t?[]:t.toLowerCase().split("+"),a=t.endsWith("+")?"+":n.pop(),l="space"===a?" ":a,c=n.includes("alt"),d=n.includes("ctrl"),u=n.includes("meta"),h=n.includes("shift"),g=Lc.test(l)&&(Oc[l]||(Oc[l]=new RegExp(l.substring(1,l.length-1))));return(g?g.test(e.key.toLowerCase()):l===e.key.toLowerCase())&&(c?i:!i)&&(d?r:!r)&&(u?s:!s)&&(h?o:!o)})):void 0)}async performKeyMapAction(e){const t=this,{keyMap:n}=t;let i,r,s,o,a=!1;if(n&&!e.handled&&void 0!==e.key){const h=t.matchKeyMapEntry(e);if(n[h]){const r=rt.asArray(n[h]);for(i of(e.fromKeyMap=!0,e.widget=this,r)){if(o=!0,U.isObject(i)){if(!i.handler)continue;!1===i.preventDefault&&(o=!1),i=i.handler}if("string"==typeof i){var l;const{thisObj:n,handler:r}=t.resolveKeyMapAction(i);if(!1!==(null===(l=n.isActionAvailable)||void 0===l?void 0:l.call(n,{key:h,action:i,event:e,actionName:i.split(".").pop()}))){let t=r.call(n,e);if(U.isPromise(t)&&(t=await t),!1!==t){a=!0;break}}}else if(!1!==i.call(t,e)){a=!0;break}}a&&(o&&e.preventDefault(),e.handled=!0)}if(!a){if(s=U.getTruthyKeys(n.delegate))for(r of s){var c,d;if(r=U.getPath(t,r),a=null===(c=r)||void 0===c||null===(d=c.performKeyMapAction)||void 0===d?void 0:d.call(c,e),U.isPromise(a)&&(a=await a),a)break}var u;if(!a)null===(u=t.defaultKeyHandler)||void 0===u||u.call(t,e)}}return a}resolveKeyMapAction(e){const t=this,{keyMapSubComponents:n}=t;if(e.startsWith("up.")||e.startsWith("this."))return t.resolveCallback(e);if(n&&e.includes(".")){const[t,i]=e.split(".");if(t&&i)return{thisObj:n[t],handler:n[t][i]}}return{thisObj:t,handler:t[e]}}updateKeyMap(e){var t;const n=this,i=U.keys(e);null===(t=n.keyMapDetacher)||void 0===t||t.call(n),n.keyMapDetacher=i.length?Mn.on({element:n.keyMapElement,keydown:"keyMapOnKeyDown",thisObj:n}):null}keyMapOnKeyDown(e){this.performKeyMapAction(e)}mergeKeyMaps(e,t,n=null){const i={};e&&U.assign(i,e);for(const r in t){if(!t[r])continue;const s=rt.asArray(null==e?void 0:e[r]),o=[];if(null!=s&&s.length&&o.push(...s),null==s||!s.some((e=>{const t=e.handler?e.handler:e;return"string"==typeof t&&t.startsWith(n+".")}))){for(const e of rt.asArray(t[r]))U.isObject(e)&&e.handler?o.push(U.assignIf({handler:(n?n+".":"")+e.handler},e)):"function"==typeof e?o.push(e):o.push((n?n+".":"")+e);o.sort(((e,t)=>{const n=(e.weight||0)-(t.weight||0);return 0===n&&null!=s&&s.length?s.indexOf(e)-s.indexOf(t):n}))}i[r]=o}return i}},_c=e=>class extends(e||tt){static $name="RTL";get widgetClass(){}static configurable={rtl:null};get isRTL(){return this.rtl}updateRtl(e){const{element:t}=this;t&&(t.classList.toggle("b-rtl",!0===e),t.classList.toggle("b-ltr",!1===e))}startConfigure(e){var t;if(null===(t=super.startConfigure)||void 0===t||t.call(this,arguments),!e.floating&&null==e.rtl){var n;const t=this,i=e.rootElement||e.forElement||(null===(n=t.parent)||void 0===n?void 0:n.contentElement)||(t.floating?t.floatRoot:t.changeElementRef(t.getRenderContext(e)[0]||e.adopt));if(i)e.rtl=1===i.nodeType&&"rtl"===getComputedStyle(i).getPropertyValue("direction");else{const t=e.owner||e.parent;e.rtl=t?t[t.isConfiguring?"peekConfig":"getConfig"]("rtl"):"rtl"===getComputedStyle(document.body).getPropertyValue("direction")}e.rtl&&(t.configDone.rtl=!1)}}render(...e){var t,n,i;(null===(t=super.render)||void 0===t||t.call(this,...e),(d.isChrome&&d.chromeVersion<87||d.isFirefox&&d.firefoxVersion<66||d.isSafari&&d.safariVersion<14.1)&&this.element.classList.add("b-legacy-inset"),"rtl"===getComputedStyle(this.element).direction||null!==(n=this.owner)&&void 0!==n&&n.rtl)&&(this.rtl=!0,null===(i=this.childItems)||void 0===i||i.forEach((e=>e.rtl=!0)))}};const jc=Object.freeze({highlight:!1,onlyName:!1}),Bc=Object.freeze([]),Vc=Object.freeze({sync:!1}),Hc=[],zc=["clip","display","opacity"],Nc="highlightExternalChange",Wc=/transparent|rgba\(0,\s*0,\s*0,\s*0\)/,Uc=Symbol("renderConfigObserver"),Gc=/<div|<button|<input|<p|<br|<li/,qc=(e,t,n,i)=>{var r;let s=(null==n?void 0:n.listeners)||(null==n?void 0:n.internalListeners);if(s=(null===(r=s)||void 0===r?void 0:r.on)||s,s){const r=Mn.on(U.assign({element:t,thisObj:e},s));i?(e._refListeners||(e._refListeners=Object.create(null)))[i]=r:n.listeners={on:s,un:r}}},Yc=(e,t)=>e&&t&&t[U.keys(e)[0]]?ke.merge(e,t):e,Kc=e=>{e.isVisible&&e.triggerPaint()},Xc=/^:not\((.+)\)$/,Zc=/absolute|fixed/i,Jc=e=>null!=e.scale,{hasOwn:Qc}=U,{defineProperty:ed}=Reflect,td=e=>parseFloat(e)*(e.endsWith("ms")?1:1e3),nd=["b-aligned-above","b-aligned-right","b-aligned-below","b-aligned-left"],id={configurable:!0,value:!1},rd=/(?:L\{([ \w.]+?)\})/,sd=/^([trblc])(\d*)-([trblc])(\d*)$/i,od=(e,t)=>(sd.test(e)&&(e={align:e}),sd.test(t)&&(t={align:t}),ke.merge(e,t)),ad=/^[\w.]+$/,ld={1:"maxHeight",2:"height",4:"maxWidth",8:"width"},cd=e=>!e.isRipple&&!e.closest((e=>e.isMessageDialog||e.isSharedTooltip)),dd=e=>"contents"===ki.getStyleValue(e,"display")?dd(e.parentNode):e,ud=(e,t)=>(e.push((t.text||t.html||"").trim()),e);class hd extends(tt.mixin(dr,dt,nn,on,Ls,$c,_c)){static mergeCls(e,t){return t&&e?e=new Ht(t).assign("string"==typeof e?new Ht(e):e):e&&!e.isDomClassList&&(e=new Ht(e)),e}static $name="Widget";static type="widget";static convertPinchToMousewheel=!0;static get configurable(){return{element:!0,callOnFunctions:!0,hideMode:{$config:null,default:"display"},id:null,html:{$config:"lazy",value:null},content:{$config:"lazy",value:null},cls:{$config:{merge:"classList"},value:null},ui:{$config:{merge:"classList"},value:null},collapsify:null,contentElementCls:{$config:{merge:"classList"},value:null},defaultCls:{$config:{merge:"classList"},value:null},dock:null,parent:null,tab:null,elementAttributes:null,htmlCls:{$config:{merge:"classList"},value:{"b-html":1}},style:null,disabled:null,readOnly:{value:null,default:!1,$config:null},ignoreParentReadOnly:null,adopt:null,appendTo:null,insertBefore:null,insertFirst:null,dataset:null,tooltip:{$config:["lazy","nullify"],value:null},showTooltipWhenDisabled:!0,preventTooltipOnTouch:null,monitorResize:{$config:["lazy","nullify"],value:null},masked:{$config:"nullify",value:null},maskDefaults:{target:"element"},floating:null,positionable:null,positioned:null,draggable:{$config:["lazy","nullify"],value:null},align:{$config:{merge:od},value:"t-b"},centered:null,constrainTo:void 0,anchor:null,owner:{$config:["lazy","nullify"],value:null},scrollAction:null,hideAnimation:{$config:{merge:Yc},value:null},showAnimation:{$config:{merge:Yc},value:null},top:null,right:null,bottom:null,left:null,x:null,y:null,scrollable:{$config:["lazy","nullify"],value:null},scrollerClass:Pc,defaultBindProperty:"html",defaultAction:null,overflowable:{value:null,default:!0,$config:null},width:null,height:null,maxHeight:null,maxWidth:null,minWidth:null,minHeight:null,scaleToFitWidth:null,allowGrowWidth:!0,margin:null,flex:null,weight:null,alignSelf:null,ripple:null,title:null,localizableProperties:["title","ariaLabel","ariaDescription","dataset.text"],requireSize:!1,ref:null,hidden:null,textAlign:null,ignoreScrollDuration:500,tag:"div",recomposeAsync:null,rootElement:null,htmlMutationObserver:{$config:["lazy","nullify"],value:{childList:!0,subtree:!0}},role:{$config:{lazy:!0,default:null},value:"presentation"},ariaLabel:{$config:"lazy",value:null},ariaDescription:{$config:"lazy",value:null},ariaLive:{$config:"lazy",value:null},ariaElement:"element",ariaHasPopup:null,realignTimeout:300,testConfig:{ignoreScrollDuration:100,realignTimeout:50},maximizeOnMobile:null,twinForwardEvents:{$config:{merge:"classList"},value:null},twinSyncConfigs:{$config:{merge:"classList"},value:["disabled"]}}}static get prototypeProperties(){return{hasGeneratedId:!1,hasPainted:!1,innerItem:!0}}static get declarable(){return["renderConfigs"]}static get delayable(){return{recompose:"raf",doHideOrRealign:"raf",onAlignConstraintChange:"raf"}}static get factoryable(){return{defaultType:"widget"}}static get identifiable(){return{}}static get all(){return super.all}static get recomposeAsync(){return hd._recomposeAsync}static set recomposeAsync(e){if(hd._recomposeAsync=e,null!=e){const{all:t}=hd;for(let n=0;n<t.length;++n)t[n].isComposable&&(t[n].recomposeAsync=e)}}updateWeight(){var e,t;this.isPainted&&(null===(e=this.parent)||void 0===e||null===(t=e.onChildWeightChange)||void 0===t||t.call(e,this))}isA(e){return this.isType(e,!0)}isType(e,t){return hd.isType(this,e,t)}static setupRenderConfigs(e,t){const n=t.getInherited("renderConfigs"),{renderConfigs:i}=e;if(i){if(Array.isArray(i))for(const e of i)n[e]=!0;else U.assign(n,i);n[Uc]=null}}static weightSortFn({weight:e},{weight:t}){return"string"==typeof e||"string"==typeof t?String(e).localeCompare(String(t)):(e??Number.MAX_SAFE_INTEGER)-(t??Number.MAX_SAFE_INTEGER)}construct(e={},...t){const n=this,{domSyncCallback:i}=n,{recomposeAsync:r}=hd;if(null!=r&&null==n.recomposeAsync&&(n.recomposeAsync=r),!globalThis.bryntum.cssVersion){const e=globalThis.bryntum.cssVersion=Gl.getCSSVersion(),t=q.getVersion("core");e&&e!==t&&console.warn(`CSS version ${e} doesn't match bundle version ${t}!\nMake sure you have imported css from the appropriate product version.`)}n.configureAriaDescription=e.ariaDescription,n._isAnimatingCounter=0,n.alignmentChanges=0,n.byRef=Object.create(null),n.onTargetResize=n.onTargetResize.bind(n),n.onFullscreenChange=n.onFullscreenChange.bind(n),n.domSyncCallback=i.$nullFn?null:i.bind(n),n._isUserAction=!1,super.construct(e,...t),n.finalizeInit()}startConfigure(e){super.startConfigure(e),this.getConfig("element")}finalizeInit(){const e=this,{adopt:t}=e,n=e.insertBefore||e.appendTo||e.insertFirst||t,{classList:i}=e.element;var r;(e.getConfig("html","content"),n)&&(t&&(i.remove("b-hidden"),e._hidden=!1),e.owner||null!==(r=n.nodeType?n:document.getElementById(n))&&void 0!==r&&r.isConnected?e.render():(e.onFirstResizeAfterConnect=e.onFirstResizeAfterConnect.bind(e),Dc.addResizeListener(n,e.onFirstResizeAfterConnect)));i.remove("b-initializing")}onFirstResizeAfterConnect(e){Dc.removeResizeListener(e,this.onFirstResizeAfterConnect),this.isDestroyed||this.rendered||this.render()}doDestroy(){var e,t;const n=this,{preExistingElements:i,element:r,adopt:s,_refListeners:o,_rootElement:a,eventRoot:l,ownedWidgets:c,parent:d}=n;if(n.updateOwner(null,n.owner),bc.element===r&&bc.exit(),o&&(Object.values(o,(e=>e())),n._refListeners=null),r){var u;const e=!n._tooltip&&a&&(null===(u=hd.Tooltip)||void 0===u?void 0:u.getSharedTooltip(a,l,!0));if((null==e?void 0:e.owner)===n&&(e.owner=null,e.hide()),n.onExitFullscreen(),n.clearTimeout("scrollListenerTimeout"),n.clearTimeout("resizeListenerTimeout"),n.removeTransientListeners(),n.floating||n.positioned||n.positionable?n.isPainted&&n.hide(!1):n.revertFocus(),Dc.removeResizeListener(r.parentElement,n.onParentElementResize),Dc.removeResizeListener(r,n.onElementResize),s){for(let e=Array.from(r.childNodes),t=0,{length:s}=e;t<s;t++){const r=e[t];i.includes(r)||r===n.floatRoot||r.remove()}r.className=n.adoptedElementClassName,r.style.cssText=n.adoptedElementCssText}}null===(e=n.connectedObserver)||void 0===e||e.disconnect(),(null==d?void 0:d.isContainer)&&!d.isDestroying&&(null===(t=d._items)||void 0===t?void 0:t.includes(n))&&d.remove(n),super.doDestroy(),c&&Object.values(c).forEach((e=>{var t;return null===(t=e.destroy)||void 0===t?void 0:t.call(e)})),l&&Promise.resolve().then((()=>{var e,t;Object.values(hd.identifiable.idMap).some(cd)||(null===(e=hd.Ripple)||void 0===e||null===(t=e.cleanUpRippleListeners)||void 0===t||t.call(e),Hi.detachFocusListeners(l))})),s||r.remove()}get assignValueDefaults(){return jc}get valueName(){return this.name||this.ref||this.id}getValueName(e){return(e=e&&"object"==typeof e?e.onlyName:e)?this.name:this.valueName}assignFieldValue(e,t,n){const i=this,r=i.defaultBindProperty;r in i&&(i[r]=n)}assignValue(e,t=jc){const n=this,i=n[Nc],r=n.getValueName(t);!r||e&&!(r in e)||(!1===t.highlight&&(n[Nc]=!1),n.assignFieldValue(e,r,e?e[r]:null),n[Nc]=i)}gatherValue(e){const t=this,n=t.defaultBindProperty;t.constructor!==hd&&n in t&&(e[t.name||t.ref||t.id]=t[n])}gatherValues(e){this.eachWidget((t=>t.gatherValue(e)),!1)}addToOverflowMenu(e,t,n){const i=this.ensureOverflowTwin(t,n);return e.items.push(i),i}get twinForwardEventPairs(){const e=this._twinForwardEvents;return e?U.entries(e):Bc}configureOverflowTwin(e){const t=this,{twinSyncConfigs:n}=t;let i,r,s=U.clone(t.initialConfig);if(delete s.id,delete s.listeners,delete s.internalListeners,delete s.parent,s.hidden=!1,s.type=t.type,s._overflowTwinOrigin=t,s.owner=t.owner,t.twinForwardEventPairs.forEach((([e])=>{delete s[`on${V.capitalize(e)}`]})),n)for(i in n)r=n[i],r&&(delete s[i],s["string"==typeof r?r:i]=t[i]);return e&&(s="function"==typeof e?e(s)||s:U.assign(s,e)),s}createOverflowTwin(e){const t=this,n=t.configureOverflowTwin(e),i=hd.create(n),{twinSyncConfigs:r}=t;return r&&t.bindConfigs(i,r,Vc),t.twinForwardEventPairs.forEach((([e,n])=>{i.ion({[e]:e=>{t.overflowTwin===e.source&&(delete(e=U.assign({},e)).source,t.trigger("string"==typeof n?n:e.eventName,e))}})})),i}ensureOverflowTwin(e,t){let{overflowTwin:n}=this;return n||(this.overflowTwin=n=this.createOverflowTwin(e),null==t||t(n)),n}get isComposable(){return!this.compose.$nullFn}adoptElement(e){const t=this,n="string"==typeof e?document.getElementById(e):e,i=hd.fromElement(n);if(i&&i.adopt&&i!==t){("string"==typeof i.adopt?document.getElementById(i.adopt):i.adopt)===n&&i.destroy()}return t.preExistingElements=Array.from(n.childNodes),t.adoptedElementClassName=n.className,t.adoptedElementCssText=n.style.cssText,n.lastDomConfig=null,n.$refOwnerId=t.id,n.className=n.style.cssText="",n}addRefAccessor(e,t){const{prototype:n}=this.constructor;ed(n,t,{writable:!0,value:null}),ed(n,e,{get(){return this.recompose.flush(),this[t]},set(e){this[t]=e}})}attachRef(e,t,n){const i=this,r="_"+e;t.dataset&&(t.dataset.ownerCmp=i.id),i.isComposable&&(r in i||i.addRefAccessor(e,r),qc(i,t,n,e)),i.byRef[e]=t,i[e]=t}detachRef(e,t,n){const i=this,r=i._refListeners;null!=r&&r[e]&&(r[e](),delete r[e]),i[e]=null,delete i.byRef[e]}afterRecompose(){}compose(){const{widgetClassList:e}=this;return{class:{...Ht.normalize(e,"object")}}}doCompose(){const e=this,{$meta:t}=e,n=t.hierarchy,i=t.renderConfigs||t.getInherited("renderConfigs");let r,s,o,a,{composers:l}=t,c=null;if(e.recompose.suspend(),!l){for(t.composers=l=[],o=n.indexOf(hd);o<n.length;++o)a=n[o].prototype,Qc(a,"compose")&&l.push(a);Qc(i,Uc)||(i[Uc]={get(e){"element"!==e&&(i[e]=!0)}})}for(e.configObserver=i[Uc],o=0;o<l.length;++o)r=l[o].compose.call(e,c),c=c?ki.merge(c,r):r;return Qc(e,"compose")&&ki.merge(c,e.compose(c)),e.configObserver=null,ki.normalizeChildren(c,((t,n)=>{n&&(s="_"+t,s in e||e.addRefAccessor(t,s))}))}get element(){return this.isComposable&&!this.isDestroying&&this.recompose.flush(),this._element}domSyncCallback(e){}changeElement(e){const t=this,n=t.isComposable,{adopt:i}=t;return t.id=t.id||(null==i?void 0:i.id)||null,i?e=t.adoptElement(i):n&&(e=t.doCompose()),"string"==typeof e?e=ki.createElementFromTemplate(e):U.isObject(e)?(e=ki.createElement(e,{refOwner:t,callback:t.domSyncCallback}),t.recompose.resume()):ki.isReactElement(t.peekConfig("html"))||ki.isVueConfig(t.peekConfig("html"))?e=document.createElement("div"):1!==e.nodeType&&(e=ki.createElementFromTemplate(t.template(t))),!e.id&&(e.id=t.id),t.elementAttributes&&ki.setAttributes(e,t.elementAttributes),e}updateElement(e){const t=this,n=t.isComposable;t.adopt&&(t._hidden=!0,n&&t.recomposeNow()),n&&qc(t,e,e.lastDomConfig);const{className:i}=e,{contentElement:r,contentElementCls:s,isComposable:o}=t,a=r!==e,l=!o&&e.querySelectorAll("[data-reference]"),c=o?[]:t.widgetClassList;let d=(a||!o)&&t.uiClasses;if(i&&c.unshift(i),t._hidden&&c.push("b-hidden",`b-hide-mode-${t.hideMode}`),t._readOnly&&c.push("b-readonly"),c.push("b-initializing"),te.noThrow(e,"remove"),d?(null!=s&&s.value&&(d=d.slice(),d.push(s.value)),d=d.join(" ")):d=null==s?void 0:s.value,d&&(a?r.className+=" "+d:c.push(d)),!t.parent){const{defaultCls:e}=t,{outerCls:n}=hd;c.push(...e?n.filter((t=>!(t in e)||e[t])):n)}if(e.className=c.join(" "),l)for(let e,n=0;n<l.length;++n)e=l[n],t.attachRef(e.getAttribute("data-reference"),e),e.removeAttribute("data-reference");t.scaleToFitWidth||t.getConfig("monitorResize"),t.getConfig("role","ariaLabel","ariaDescription"),t._html&&t.getConfig("htmlMutationObserver"),t.owner&&!t._owner&&t.updateOwner(t.owner),ki.isVueConfig(t._html)&&ki.handleVueContent(t,t.html),t.trigger("elementCreated",{element:e})}localizeText(e){return e.match(rd)?this.L(e,this):e}updateAriaDescription(e){const t=this,{ariaElement:n}=t,i=`${t.id}-aria-desc-el`;if(e){(t._ariaDescEl||(t._ariaDescEl=ki.createElement({className:"b-aria-desc-element",id:i,parent:n}))).innerText=t.localizeText(e),ki.addAttributeValue(n,"aria-describedBy",i)}else ki.removeAttributeValue(n,"aria-describedBy",i)}updateAriaLabel(e=""){const t=this.labelledElement||this.ariaElement;t&&ki.setAttributes(t,{"aria-label":e?this.localizeText(e):null})}updateAriaHasPopup(e){var t,n;e?null===(t=this.ariaElement)||void 0===t||t.setAttribute("aria-haspopup",e):null===(n=this.ariaElement)||void 0===n||n.removeAttribute("aria-haspopup")}updateAriaLive(e){ki.setAttributes(this.ariaElement,{"aria-live":e})}updateRole(e){var t,n;e?null===(t=this.ariaElement)||void 0===t||t.setAttribute("role",e):null===(n=this.ariaElement)||void 0===n||n.removeAttribute("role")}get ownersRole(){let{role:e}=this;var t;"presentation"===e&&(e=null===(t=this.query((e=>"presentation"!==e.role)))||void 0===t?void 0:t.role);return e}get ariaElement(){this.getConfig("element");const{_ariaElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:U.getPath(this,e)}isCollapsified({collapsed:e,alt:t}){const{collapsify:n}=this,i=null==n;return t?"overlay"===n||i&&e:!1===n||"hide"===n||i&&!e}async recompose(){return this.recomposeInternal()}async recomposeInternal(){const e=this,t={targetElement:e.element,domConfig:e.doCompose(),refOwner:e,callback:e.domSyncCallback,strict:!0};if(e.transitionRecompose){if(e.isTransitioningDom=!0,await ki.transition(U.assign({element:e.element,action(){yc.sync(t)}},e.transitionRecompose)),e.isDestroyed)return;e.isTransitioningDom=!1,e.trigger("transitionedRecompose")}else yc.sync(t);t.changed&&(e.afterRecompose(),e.trigger("recompose")),e.resumeRecompose()}resumeRecompose(){this.recompose.resume()}changeElementRef(e){if("string"==typeof e){const t=e;if(!(e=document.getElementById(t)))throw new Error(`No element found with id '${t}'`)}return e}changeAppendTo(e){return this.changeElementRef(e)}updateAppendTo(e){!this.isConfiguring&&e&&this.render()}changeInsertBefore(e){return this.changeElementRef(e)}updateInsertBefore(e){!this.isConfiguring&&e&&this.render()}changeInsertFirst(e){return this.changeElementRef(e)}updateInsertFirst(e){!this.isConfiguring&&e&&this.render()}getRenderContext(e=this,t){let n=t||e.appendTo,{insertFirst:i,insertBefore:r}=e;return i&&(n=i,r=n.firstChild),r&&(n=r.parentElement),[n,r||void 0]}render(e,t=!0){var n;const i=this,{element:r}=i,[s,o]=i.getRenderContext(i,e);i.emptyCache(),i.syncElement&&i.currentElement?ki.sync(r,i.currentElement):(null==s||s.insertBefore(r,o),i.currentElement=r),null!==(n=r.parentElement)&&void 0!==n&&n.closest(".b-widget")&&r.classList.remove(...hd.outerCls),super.render(s,t),i.rendered=!0,i.getConfig("role"),t&&(i.getConfig("contentRange"),i.triggerPaint()),i.setupFocusListeners()}template({tag:e,html:t,htmlCls:n,name:i}){var r;const s=this;"string"==typeof t&&ad.test(t)&&s.resolveCallback(t,s,!1)&&(t=s.callback(t,s,[s]));const o=null!==(r=t)&&void 0!==r&&r.call?t.call(s,s):t;return`<${e} class="${o?n:""}" ${i?`data-name="${i}"`:""}>${o||""}</${e}>`}updateRecomposeAsync(e){this.recompose.immediate=!e}onConfigChange({name:e}){var t;this._element&&!this.isDestroying&&null!==(t=this.$meta.renderConfigs)&&void 0!==t&&t[e]&&this.recompose()}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.parent}getConfigValue(e,t){return"style"===e?this._style:super.getConfigValue(e,t)}getCurrentConfig(e){const t=super.getCurrentConfig(e);return(null==e?void 0:e.depth)>0&&(t.type=this.type),t}get dataset(){var e;return(null===(e=this.element)||void 0===e?void 0:e.dataset)||Bc}changeDataset(e){U.assign(this.dataset,e)}updateParent(e){const{_element:t}=this;t&&t.classList[e?"remove":"add"](...hd.outerCls)}get constrainTo(){var e;let t=this._constrainTo;if(t=void 0===t?globalThis:(null===(e=t)||void 0===e?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE?t.host||t.ownerDocument:t,this.positioned){const{offsetParent:e}=this.element;if(e&&"hidden"===ki.getStyleValue(e,"overflow"))t=_t.from(e).moveTo(0,0);else if(t&&!t.isRectangle){const n=t===document||t===globalThis;t=_t.from(t,e),n&&t.translate(globalThis.pageXOffset,globalThis.pageYOffset)}}return t}updateCentered(e){const t=this,{element:n,_anchorElement:i}=t;if(e&&!t.floating&&!t.positioned)throw new Error("`centered` is only relevant when a Widget is `floating` or `positioned`");e?(n.classList.add("b-centered"),n.style.transform=n.style.left=n.style.insetInlineStart=n.style.right=n.style.top="",null==i||i.classList.add("b-hide-display"),n.classList.remove("b-anchored")):n.classList.remove("b-centered")}get contentElement(){return this.element}get contentRange(){const e=this,t=e._contentRange||(e._contentRange=new Range);return t.collapsed&&(e.initializingHtml&&e.adopt?t.setStart(e.contentElement,0):t.selectNodeContents(e.contentElement)),t}fixRefOwnerId(e,t,n){if(e.$refOwnerId===n){e.$refOwnerId=t;for(let{childNodes:i}=e,r=i.length;r-- >0;)this.fixRefOwnerId(i[r],t,n)}}get placement(){const{element:e}=this;let t,n,i;if(null!=e&&e.offsetParent&&!Zc.test(ki.getStyleValue(e,"position"))){const s=e.nextElementSibling,o=e.previousElementSibling,a=!s&&o;var r;if(n=ki.getStyleValue(e.parentElement,"flex-direction"),n)n=n.startsWith("row")?"h":"v";else t=null===(r=s||o)||void 0===r?void 0:r.getBoundingClientRect(),i=t&&e.getBoundingClientRect(),n=t&&Math.abs(t.top-i.top)<Math.abs(t.left-i.left)?"h":"v";n+="h"===n?a?"r":"l":a?"b":"t"}return n}updateId(e,t){if(super.updateId(e,t),t){const{byRef:n,element:i}=this;for(const t in n)n[t].dataset&&(n[t].dataset.ownerCmp=e);i.id=e,this.fixRefOwnerId(i,e,t)}}get style(){const{element:e}=this;return(null==e?void 0:e.ownerDocument.defaultView.getComputedStyle(e))||this._style}updateStyle(e){this.element&&ki.applyStyle(this.element,e)}updateTitle(e){this.titleElement&&(this.titleElement.innerHTML=e)}beforeAlignTo(e){}alignTo(e){var t,n,i;const r=this,{lastAlignSpec:s,element:o}=r,{offsetParent:a,style:l,classList:c}=o;if(s&&(s.monitorIntersection&&r.intersectionObserver.unobserve(s.target),isFinite(s.zone)&&o.classList.remove(nd[s.zone])),!e)return r.removeTransientListeners(),void(r.anchor=r.lastAlignSpec=null);r.beforeAlignTo(e),(e.nodeType===Element.ELEMENT_NODE||e.isWidget||"Point"===e.$$name)&&(e={target:e}),r.releaseSizeConstraints();const{scrollable:u,constrainTo:h}=r,g=ki.measureSize(ki.getStyleValue(o,"minHeight"),o),m=ki.measureSize(ki.getStyleValue(o,"minWidth"),o),p=r.positioned&&"fixed"!==ki.getStyleValue(o,"position"),f=r.scale||1,v=e.target,y=e.realignEvent||(e=>{if(null!=e&&e.target){const{ownerSVGElement:t}=e.target,n=null==t?void 0:t.getBoundingClientRect(),i=dd(e.target),r=ki.getStyleValue(e.target,"display");if(t)return{target:e.target.ownerSVGElement,offsetX:e.clientX-n.x,offsetY:e.clientY-n.y};let{offsetX:s,offsetY:o}=e;if("inline"===r){const t=i.getBoundingClientRect();s=e.clientX-t.left,o=e.clientY-t.top}else if("contents"===r){const e=i.getBoundingClientRect(i);s-=e.x,o-=e.y}return{target:dd(e.target),offsetX:s,offsetY:o}}})(e.domEvent||e.event||((null==v||null===(t=v.target)||void 0===t?void 0:t.nodeType)===Node.ELEMENT_NODE?v:null)),b=(null==y||null===(n=y.target)||void 0===n?void 0:n.nodeType)===Element.ELEMENT_NODE,C=b?y.target:null!=v&&v.isRectangle?v:(null==v?void 0:v.element)||v,S=(null==C?void 0:C.nodeType)===Element.ELEMENT_NODE;e=e.realignTarget?U.clone(e):U.merge({aligningToEvent:b,aligningToElement:S,constrainTo:h,align:"b-t",axisLock:r.axisLock,anchor:r.anchor},r.align,e),b&&(e.domEvent=y);const w=e.minWidth||m,D=e.minHeight||g;if(r.lastAlignSpec=e,S&&(e.target=e.anchoredTo=C,fi(C instanceof SVGElement?C.closest("svg"):C))){if((e=Object.create(e)).target=r.lastAlignSpec.targetRect=e.realignTarget||(e.allowTargetOut?_t.from(C,p?a:null,!p):ki.isInView(b?y:C,!1,r)),!e.target){const e=r.hide();return r.isDestroyed||(r.lastAlignSpec.targetOutOfView=!0),e}e.target.height=Math.max(e.target.height,1),e.target.width=Math.max(e.target.width,1)}if(e.anchor&&(e.anchorSize=r.anchorSize,o.contains(r.anchorPathElement)||o.appendChild(r.anchorElement)),"string"==typeof e.offset){const t=o.querySelector(e.offset),n=_t.from(t).getAlignmentPoint(e.align),i=_t.from(o).getAlignmentPoint(e.align);e.offset=[i[0]-n[0],i[1]-n[1]]}r.isAligning=!0,r.trigger("beforeAlign",e);const E=_t.from(o,p?a:null,!0),{width:x,height:R}=E;E.isAlignRectangle=!0,w&&(E.minWidth=w*f),D&&(E.minHeight=D*f),r.isAligning=!1,e.rtl=r.rtl,(e.align.includes("s")||e.align.includes("e"))&&(r.rtl?e.align=e.align.replace(/s/g,"r").replace(/e/g,"l"):e.align=e.align.replace(/s/g,"l").replace(/e/g,"r"));const T=r.lastAlignSpec.result=E.alignTo(e);let{align:M,anchor:I,x:k,y:F,width:A,height:P,overlap:L}=T;if(r.lastAlignSpec.zone=T.zone,P!=R){const e=P<R;r.alignmentChanges=r.alignmentChanges|(e?1:2),l[r.alignedHeightStyle=ld[3&r.alignmentChanges]]=P/f+"px",e&&!r._minHeight&&g&&(l.minHeight=Math.min(P,g)/f+"px"),u&&(u.overflowY=e)}if(A!=x){const e=A<x;r.alignmentChanges=r.alignmentChanges|(e?4:8),l[r.alignedWidthStyle=ld[12&r.alignmentChanges]]=A/f+"px",e&&!r._minWidth&&m&&(l.minWidth=Math.min(A,m)/f+"px"),u&&(u.overflowX=e)}if(M&&r.alignmentChanges){const t=_t.from(o,p?a:null,!0);e.align=M;const n=r.lastAlignSpec.result=t.alignTo(e);I=n.anchor,k=n.x,F=n.y,A=n.width,P=n.height}if(r.centered||r.setXY(k,F),!T.overlap&&isFinite(T.zone)&&c.add(nd[T.zone]),null!==(i=I)&&void 0!==i&&i.edge){var O;let{edge:e}=I;const{anchorElement:t,masked:n}=r,{style:i}=t,{style:s}=t.firstChild,a=_t.from(o),l=[];"top"===e||"bottom"===e?(l[0]=I.x,l[1]="top"===e?1:a.height-1):(l[0]="left"===e?1:a.width-1,l[1]=I.y),i.display="none",n&&(n.element.style.display="none");let d=ki.childFromPoint(o,...l);if((null!==(O=d)&&void 0!==O&&O.matches(":focus")||d===Hi.currentOverElement)&&o.compareDocumentPosition(d)&Node.DOCUMENT_POSITION_CONTAINED_BY&&(d=d.parentNode),d&&d!==document){let e=ki.getStyleValue(d,"background-color");for(;e.match(Wc)&&"absolute"!==ki.getStyleValue(d,"position")&&(d=d.parentNode,d!==document);)e=ki.getStyleValue(d,"background-color");e.match(Wc)?r.anchorPathElement.setAttribute("fill",r.defaultAnchorBackgroundColor):r.anchorPathElement.setAttribute("fill",e)}i.transform=i.display="",n&&(n.element.style.display=""),"left"!==e&&"right"!==e||(e="left"===e?r.rtl?"end":"start":r.rtl?"start":"end"),t.className=`b-anchor b-anchor-${e}`,I.x&&(I.x/=f),I.y&&(I.y/=f),s.left=`${I.x||0}px`,s.translate=`0 ${I.y||0}px`,c.add("b-anchored")}else r._anchorElement&&(r.anchorElement.classList.add("b-hide-display"),c.remove("b-anchored"));if(!S){l.pointerEvents="none";const e=ki.elementFromPoint(k,F);r.owns(e)||(r.lastAlignSpec.anchoredTo=e),l.pointerEvents=""}if(("realign"===r.scrollAction&&S||"hide"===r.scrollAction)&&!r.documentScrollListener){if(r.clearTimeout("scrollListenerTimeout"),e.monitorTargetMutation&&!r.targetObserver){(r.targetObserver||(r.targetObserver=new MutationObserver(r.onTargetParentMutation.bind(r)))).observe(ki.getRootElement(C),{childList:!0,attributes:!0,subtree:!0})}r.setTimeout((()=>{const e=S?C:r.lastAlignSpec.anchoredTo,t=e?ki.getRootElement(e):null;r.documentScrollListener=Mn.addListener({element:document,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:r}),null!=t&&t.mode&&(r.targetRootScrollListener=Mn.addListener({element:t,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:r}))}),"hide"===r.scrollAction?r.ignoreScrollDuration:0,"scrollListenerTimeout")}if(S&&(e.monitorResize&&!r.observedTargetEl&&(Dc.addResizeListener(C,r.onTargetResize),r.observedTargetEl=C),e.monitorIntersection&&!(L||C.contains(o)||C.ownerSVGElement)&&r.intersectionObserver.observe(C)),!d.isAndroid&&!r.observedConstrainEl){const e=null!=h&&h.isRectangle?globalThis:h;r.clearTimeout("resizeListenerTimeout"),r.setTimeout((()=>{r.observedConstrainEl=e||globalThis,Dc.addResizeListener(r.observedConstrainEl,r.onAlignConstraintChange)}),r.ignoreScrollDuration,"resizeListenerTimeout")}}onTargetParentMutation(e){const{element:t,lastAlignSpec:n}=this;var i;null!=n&&n.aligningToElement&&(null!==(i=n.target)&&void 0!==i&&i.isConnected?e.some((({target:e})=>e.contains(n.target)&&!t.contains(e)))&&this.realign():this.hide())}get intersectionObserver(){return this._intersectionObserver||(this._intersectionObserver=new IntersectionObserver(this.onTargetIntersectionChange.bind(this),{root:d.isSafari?this.rootElement:this.rootElement.ownerDocument}))}onTargetIntersectionChange(e){if(!this.isDestroyed){const t=e[e.length-1];t.isIntersecting||this.onAlignTargetOutOfView(t.target)}}onTargetResize(...e){const{lastAlignSpec:t}=this;if(t){const{width:n,height:i}=t.targetRect,{width:r,height:s}=t.target.getBoundingClientRect();r===n&&s===i||this.onAlignConstraintChange(...e)}}onAlignTargetOutOfView(e){this.hide(),this.lastAlignSpec&&(this.lastAlignSpec.targetOutOfView=!0)}onAlignConstraintChange(e,t,{height:n}){const{style:i}=this.contentElement,{overflowY:r}=i;this.setTimeout(this.realign,50),t&&n>t.height&&(i.overflowY="hidden",this.requestAnimationFrame((()=>i.overflowY=r)))}realign(){const e=this,{lastAlignSpec:t}=e;if((e.floating||e.positioned)&&t&&e.isVisible){if(t.aligningToElement){const n=t.target.contains(this.element),i=ki.isInView(t.target,!1,e);if(!(t.allowTargetOut||fi(t.target)&&i))return e.hide(),void(e.isDestroyed||(e.lastAlignSpec.targetOutOfView=!0));t.realignEvent=t.domEvent,t.realignTarget=n||t.aligningToEvent?null:i}ki.addTemporaryClass(e.element,"b-realigning",e.realignTimeout,e),e.alignTo(t)}}rectangle(e,t,n){return this.rectangleOf("element",e,t,n)}rectangleOf(e,t,n,i){var r;return"string"!=typeof t?(i=n,n=t,t=""):"border"===t&&(t=""),"boolean"==typeof n&&(i=n,n=void 0),"element"!==e&&void 0===n&&(n=this.element),n=null!==(r=n)&&void 0!==r&&r.isWidget?n.element:n,"string"==typeof e&&(e=this[e]),_t[t||"from"](e,n,i)}releaseSizeConstraints(){const e=this,{scrollable:t,element:n,alignmentChanges:i}=e,{style:r}=n;e.centered||ki.setTopInsetInlineStart(n,0,0),12&i&&(ki.setLength(n,e.alignedWidthStyle,e[`_last${V.capitalize(e.alignedWidthStyle)}`]||""),r.minWidth=e._minWidth||"",t&&(t.overflowY=t.config.overflowY)),3&i&&(ki.setLength(n,e.alignedHeightStyle,e[`_last${V.capitalize(e.alignedHeightStyle)}`]||""),r.minHeight=e._minHeight||"",t&&(t.overflowX=t.config.overflowX)),e.alignmentChanges=0}toFront(){const{element:e}=this,t=this.floating?this.floatRoot:this.positioned?null==e?void 0:e.parentNode:null,n=document.createDocumentFragment();if(this.containsFocus){for(let s,o=e.nextSibling;o;o=s){var i,r;s=o.nextSibling,t.contains(o)&&null!==(i=(r=o).matches)&&void 0!==i&&i.call(r,".b-floating,.b-positioned")&&!this.owns(o)&&n.appendChild(o)}n.childElementCount&&t.insertBefore(n,e)}else e.nextElementSibling&&t.appendChild(e)}updateRef(e){this.element.dataset.ref=e}get overflowElement(){return this.contentElement}get maxHeightElement(){return this.element}changeAlign(e){return"string"==typeof e?{align:e}:e}changeScrollable(e,t){return"boolean"==typeof e&&(e={overflowX:e,overflowY:e}),e?(e.element=this.overflowElement,e.widget=this,e.isScroller||(e=t?t.setConfig(e):new this.scrollerClass(e)),e.syncOverflowState()):null==t||t.destroy(),e}get html(){return this.isConfiguring?this.content||this._html:this.contentElement.innerHTML}changeHtml(e){return!e||"object"!=typeof e||ki.isVueConfig(e)||ki.isReactElement(e)||Array.isArray(e)||(e=[e]),e}updateHtml(e){const t=this;t.noChildElements="string"==typeof e&&!Gc.test(e),t.initializingElement||t.insertContent(e,!(t.initializingHtml&&t.adopt))}changeHtmlMutationObserver(e,t){const n=this,{contentElement:i}=n;if(null==t||t.disconnect(),e){const t=new MutationObserver((()=>{n.updatingHtml?n.updatingHtml=!1:n._html=i.innerHTML}));return t.observe(i,e),t}}updateContent(e){this.initializingElement||this.insertContent(e)}insertContent(e,t=!1){const n=this,{element:i,contentElement:r,htmlCls:s,contentRange:o,autoClose:a}=n,l=t&&r===i&&n._anchorElement;if(ki.isVueConfig(e))return ki.handleVueContent(n,e);if(ki.handleReactElement(n,e),!ki.isReactElement(e)){if(n.updatingHtml=!0,n.getConfig("htmlMutationObserver"),l&&i.removeChild(l),s&&s.values.forEach((t=>i.classList[e?"add":"remove"](t))),n.autoClose=!1,e){let n,s;"object"==typeof e?(s=document.createDocumentFragment(),Array.isArray(e)?yc.sync({domConfig:{children:e,onlyChildren:!0},targetElement:s}):yc.sync({domConfig:{...e,onlyChildren:!0},targetElement:s})):t?(r.innerHTML=e,n=!0):(o.deleteContents(),o.insertNode(o.createContextualFragment(e)),n=!0),n||(t?(r.innerHTML="",r.appendChild(s)):i.isConnected?o.insertNode(s):r.insertBefore(s,r.firstChild))}else t||!i.isConnected?r.innerHTML="":o.deleteContents();n.autoClose=a,l&&i.appendChild(l),n.contentRangeStartOffset=o.startOffset,n.contentRangeEndOffset=o.endOffset,r.classList.toggle("b-no-child-elements",n.noChildElements),n.isComposable&&n.recompose(),!n.floating&&!n.positioned||n.isAligning||n.realign()}}onThemeChange(){var e;this._anchorSize=null,null!==(e=this.anchorElement)&&void 0!==e&&e.offsetParent&&this.realign()}get anchorSize(){const e=this;let t=this._anchorSize;if(!t){const n=parseFloat(ki.getStyleValue(e.element,"border-top-width")),i=ki.getStyleValue(e.element,"border-top-color"),r=e.anchorElement,{className:s}=r,o=r.firstElementChild,a=e.anchorPathElement=o.lastElementChild,l=e._hidden;r.className="b-anchor b-anchor-top";let c=ki.getStyleValue(e.contentElement,"background-color");c.match(Wc)&&(c=ki.getStyleValue(e.element,"background-color")),e.defaultAnchorBackgroundColor=c,t=o.getBoundingClientRect();const[d,u]=t=e._anchorSize=[t.width,t.height];r.className=s,o.setAttribute("height",u+n),o.setAttribute("width",d),a.setAttribute("d",`M0,${u}L${d/2},0.5L${d},${u}`),n&&(a.setAttribute("stroke-width",n),a.setAttribute("stroke",i)),t[1]-=n,l&&e.syncHiddenCls(),e.themeChangeListener||(e.themeChangeListener=Hi.ion({theme:"onThemeChange",thisObj:e})),e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}return t}get anchorElement(){const e=this;if(!e._anchorElement){const t=e.floating||e.positioned,n=`${e.id}-shadow-filter`;e._anchorElement=ki.createElement({parent:e.element,className:"b-anchor b-anchor-top",children:[{tag:"svg",ns:"http://www.w3.org/2000/svg",version:"1.1",class:"b-pointer-el",children:[t?{tag:"defs",children:[{tag:"filter",id:n,children:[{tag:"feDropShadow",dx:0,dy:-1,stdDeviation:1,"flood-opacity":.2}]}]}:null,{tag:"path",[t?"filter":""]:`url(#${n})`}]}]})}return e._anchorElement}updateAnchor(e){var t;null===(t=this._anchorElement)||void 0===t||t.classList.toggle("b-hide-display",!e)}changeDraggable(e,t){var n;const i=this;if(null==t||null===(n=t.destroy)||void 0===n||n.call(t),e){const t="object"==typeof e?e:{};i.draggableHandleSelector=t.handleSelector,delete t.handleSelector,e=new rc(U.merge({name:"widget",target:i,floatRootOwner:i,rtlSource:i,positioning:i.floating?"inset":"",dragWithin:i.floating?void 0:i.element.parentNode,internalListeners:{beforeDragStart:i.onBeforeDragStart,dragStart:i.onWidgetDragStart,thisObj:i}},t))}return e}onBeforeDragStart(){const e=this;if(e.validateDragStartEvent(e.draggable.startEvent)){const{x:t,y:n,element:i}=e;return i.classList.remove("b-centered"),e.alignTo(),e.centered&&ki.setTopInsetInlineStart(i,n,t),!0}return!1}validateDragStartEvent(e){const t=ki.elementFromPoint(e.clientX,e.clientY),{draggableHandleSelector:n,draggableBlacklistSelector:i}=this;if(i&&t.closest(i))return!1;if(n){var r;const e=null===(r=Xc.exec(n))||void 0===r?void 0:r[1];if(e&&t.closest(e))return!1;if(!t.closest(`${n}`))return!1}return!0}setStyle(e,t){return ki.applyStyle(this.element,U.isObject(e)?e:{[e]:t}),this}changeFloating(e){return Boolean(e)}changePositioned(e){return Boolean(e)}updatePositionable(e){this.element.classList.toggle("b-positionable",Boolean(e)),e&&(this.innerItem=!1)}updatePositioned(e){const{element:t}=this;t.classList.toggle("b-positioned",Boolean(e)),e&&(this.innerItem=!1),t[e?"setAttribute":"removeAttribute"]("tabindex",e?"-1":void 0)}getXY(){const{element:e}=this;return[ki.getPageX(e),ki.getPageY(e)]}setXY(e,t){const n=this,{element:i}=n;if(n.floating||n.positioned){if(null!=e?n._x=e:e=n._x,null!=t?n._y=t:t=n._y,"fixed"===ki.getStyleValue(i,"position")){const n=i.getBoundingClientRect(),[r,s]=ki.getTranslateXY(i),o=e-n.x,a=t-n.y;ki.setTranslateXY(i,r+o,s+a)}else n.rtl?ki.setTopInsetInlineStart(i,t,i.offsetParent.offsetWidth-i.offsetWidth-e-1):ki.setTopInsetInlineStart(i,t,e);n.isConstructing?n.centered=!1:i.classList.remove("b-centered")}}setPos(e,t){const n=this,{positionable:i}=n;[e,t]=ki.unitize(e,t??""),n.element.style[e]=t,null==n.top&&null==n.right&&null==n.bottom&&null==n.left?"after"!==i&&"before"!==i||(n.positionable=null):i||(n.positionable="before")}updateBottom(e){this.setPos("bottom",e)}updateLeft(e){this.setPos("inset-inline-start",e)}updateRight(e){this.setPos("inset-inline-end",e)}updateTop(e){this.setPos("top",e)}get x(){return this.getXY()[0]}changeX(e){this.setXY(e)}get y(){return this.getXY()[1]}changeY(e){this.setXY(null,e)}get width(){const e=this,t=e.element;return e.monitorResize?(null==e._width&&(e._width=t.offsetWidth),e._width):t.offsetWidth}changeWidth(e){const t=this;if(ki.setLength(t.element,"width",e),t._lastWidth=e,t._flex=null,t.element.style.flex="",!t.monitorResize)return e;t._oldWidth=t._width,t._width=null}clearWidthCache(){this._width=null}get maxWidth(){return ki.measureSize(this.element.style.maxWidth,this.element)}updateMaxWidth(e){this._lastMaxWidth=e,ki.setLength(this.element,"maxWidth",e)}get minWidth(){return ki.measureSize(this.element.style.minWidth,this.element)}updateMinWidth(e){ki.setLength(this.element,"minWidth",e)}updateFlex(e){this.getConfig("width"),"number"!=typeof e&&isNaN(e)||(e=`${e} ${e}`),this.element.style.flex=e,this.element.style.width=""}updateAlignSelf(e){this.element.style.alignSelf=e}updateMargin(e){this.element.style.margin=this.parseTRBL(e).join(" ")}updateTextAlign(e,t){t&&this.element.classList.remove(`b-text-align-${t}`),this.element.classList.add(`b-text-align-${e}`)}get height(){const e=this,t=e.element;return e.monitorResize?(null==e._height&&(e._height=t.offsetHeight),e._height):t.offsetHeight}changeHeight(e){ki.setLength(this.element,"height",e),this._lastHeight=e,this._height=null}get maxHeight(){return ki.measureSize(this.maxHeightElement.style.maxHeight,this.element)}updateMaxHeight(e){this._lastMaxHeight=e,ki.setLength(this.maxHeightElement,"maxHeight",e)}get minHeight(){return ki.measureSize(this.element.style.minHeight,this.element)}updateMinHeight(e){ki.setLength(this.element,"minHeight",e)}updateDisabled(e=!1,t){const n=this,{element:i,focusElement:r,ariaElement:s}=n;n.trigger("beforeUpdateDisabled",{disabled:e}),e&&(n.revertFocus(),!n._disabled!=!e)||(i&&(i.classList[e?"add":"remove"]("b-disabled"),"inert"===e?i.inert=!0:"inert"===t&&(i.inert=!1),r&&(r.disabled=e),s&&s.setAttribute("aria-disabled",Boolean(e))),n.onDisabled(e))}onDisabled(e){}disable(){this.disabled=!0}enable(){this.disabled=!1}requestFullscreen(){const e=this,t=bc.request(e.floating?e.floatRoot:e.element);return bc.onFullscreenChange(e.onFullscreenChange),e.element.classList.add("b-fullscreen"),t}exitFullscreen(){return bc.exit()}onFullscreenChange(){bc.isFullscreen||this.onExitFullscreen()}onExitFullscreen(){bc.unFullscreenChange(this.onFullscreenChange),this.element.classList.remove("b-fullscreen")}get tooltip(){const e=this;if(e._tooltip)return e._tooltip;{var t;const n=null===(t=hd.Tooltip)||void 0===t?void 0:t.getSharedTooltip(e.rootElement,e.eventRoot);if(n&&n.activeTarget===e._element&&n.isVisible)return n}}changeTooltip(e,t){const n=this,{element:i}=n;let r;if(e){if(!n.preventTooltipOnTouch||!d.isTouchDevice){const s=(null==t?void 0:t.isTooltip)||e.newInstance||e.items||e.bbar||e.tbar;e.isTooltip||"Object"===e.constructor.name||(e={html:"string"==typeof e?e:n.placeholder,textContent:!0}),s?(e.type="tooltip",e.forElement||(e.forElement=i),"showOnHover"in e||e.forSelector||(e.showOnHover=!0),"autoClose"in e||(e.autoClose=!0),r=e=hd.reconfigure(t,e,n),n.detachListeners("tooltipValueListener"),n.configureAriaDescription||e.ion({name:"tooltipValueListener",innerHtmlUpdate:"onTooltipValueChange",thisObj:n})):(i.dataset.btip=!0,n.tipConfig=e)}}else if(t){if(null!=e||!t.isTooltip)return void(t.html=null);t.destroy()}else delete i.dataset.btip;return e&&!n.ariaLabel&&n.tooltipText&&i.setAttribute("aria-label",n.localizeText(n.tooltipText)),r}onTooltipValueChange({value:e,source:t}){this.ariaDescription="string"==typeof e?e:t.contentElement.innerText}get tooltipText(){const e=this._tooltip;return e?e.isTooltip?e.contentElement.innerText:"string"==typeof e?e:e.html:this.tipConfig?this.tipConfig.html:void 0}get isVisible(){const e=this;let t;return Boolean(!e._hidden&&(t=this.element)&&!e.isDestroying&&t.isConnected&&(!e.requireSize||fi(t))&&(!e.parent||e.parent.isVisible))}get isVisibleForValidation(){const e=this,{element:t}=e;let n;return Boolean(t&&(!e._hidden||e.tab&&!e.tab.hidden)&&!e.isDestroying&&t.isConnected&&(!(n=e.containingWidget)||n.isVisibleForValidation))}whenVisible(e,t=this,n,i=e.toString()){const r=this;var s;r.isVisible&&r.isPainted?(null===(s=r.toCallWhenVisible)||void 0===s||s.delete(i),r.callback(e,t,n)):(r.toCallWhenVisible||(r.toCallWhenVisible=new Map)).set(i,{callback:e,thisObj:t,args:n})}focus(){var e;null===(e=this.focusableElement)||void 0===e||e.focus({preventScroll:!0})}get focusability(){return ki.getFocusability(this.focusElement)}get focusableElement(){const e=this,t=!e.isDestroying&&e.isVisible&&!e.disabled&&e.focusElement;return(t===document.body||(null==t?void 0:t.offsetParent))&&t}get focusElement(){}get isFocusable(){return Boolean(this.focusableElement)}get isTabbable(){return this.focusability.tabbable}set isTabbable(e){const{focusability:t,focusElement:n}=this,[i,r]=t.natural?[!e&&"-1",e]:[e&&"0",!e];n&&!e!=!t.tabbable&&(r&&n.removeAttribute("tabIndex"),i&&n.setAttribute("tabIndex",i))}async show({align:e,animate:t=!0}={}){var n;const i=this,{element:r,floating:s}=i,{style:o}=r,a=t&&i.showAnimation;let l,c,d=!i.isVisible;return d&&(d=i.trigger("beforeShow"),U.isPromise(d)&&(d=await d)),!1!==d&&!1!==(null===(n=i.internalBeforeShow)||void 0===n?void 0:n.call(i))?new Promise((t=>{if(i.cancelHideShowAnimation(),i.updateCentered(i._centered),s){const e=i.floatRoot;e.contains(r)||(i.rendered?e.appendChild(i.element):i.render(e,!1)),o.transform.includes("scale")&&(i.scale=null,o.transform=o.transformOrigin="");const t=i.closest(Jc);if(t){const{scale:e}=t;i.scale=e,o.transform=`scale(${e})`,o.transformOrigin="0 0"}}if(i._hidden=!1,i.syncHiddenCls(),s&&!pi(r))return i.hide(!1),t();if(i.onConfigChange({name:"hidden",value:!1,was:!0,config:i.$meta.configs.hidden}),i.afterShow(e,a?null:t),a){l=Object.keys(a)[0],c=a[l];const e=i.currentAnimation={showing:!0,styleProp:l,resolve:t};i.isAnimating=!0,o.transition="none",o[l]=c.from,ki.getStyleValue(r,l),i.currentAnimation.detacher=Mn.onTransitionEnd({element:r,property:l,duration:td(c.duration)+20,handler:()=>i.afterHideShowAnimate(e),thisObj:i}),o.transition=`${l} ${c.duration} ease ${c.delay}`,o[l]=c.to}})):Promise.resolve()}async showBy(e,t,n){const i=this,r=Array.isArray(e);if(r||"number"==typeof e){const i=r?e:[e,t];e=Object.assign({target:new jt(i[0]+1,i[1]+1),matchSize:!1,align:"t0-b0"},r?t:n)}if(i.requireSize=!0,!i.isVisible)return i.show({align:e});ki.addTemporaryClass(i.element,"b-realigning",300,i),i.alignTo(e)}afterShow(e,t){var n,i;const r=this;r.trigger("show"),r._configuredAnchorState=r.anchor,null===(n=r.owner)||void 0===n||null===(i=n.onChildShow)||void 0===i||i.call(n,r),r.triggerPaint(),(r.floating||r.positioned)&&(e?r.alignTo(e):r.centered?r.alignTo({target:r.constrainTo,align:"c-c"}):r.forElement&&r.alignTo(r.forElement)),null==t||t()}onChildHide(e){const{ariaElement:t}=this,{ownersRole:n}=e;if(e.floating&&t)if("tooltip"===n){const{titleElement:n}=e,i=n&&ki.getId(n),r=ki.getId(e.contentElement);i&&ki.removeAttributeValue(t,"aria-describedby",i),ki.removeAttributeValue(t,"aria-describedby",r)}else this.ariaHasPopup=null,ki.removeAttributeValue(t,"aria-controls",ki.getId(e.ariaElement||e.element))}onChildShow(e){const{ariaElement:t}=this,{ownersRole:n}=e;if(e.floating&&t)if("tooltip"===n){const{titleElement:n}=e,i=n&&ki.getId(n),r=ki.getId(e.contentElement);i&&ki.addAttributeValue(t,"aria-describedby",i),ki.addAttributeValue(t,"aria-describedby",r)}else this.ariaHasPopup=n,ki.addAttributeValue(t,"aria-controls",ki.getId(e.ariaElement||e.element))}triggerPaint(){const e=this,{element:t,toCallWhenVisible:n}=e,i=!e.isPainted;if(e.isVisible){var r;if(i&&(e.getConfig("scrollable",e.floating||e.positioned?"draggable":null),e.scaleToFitWidth&&!e.monitorResize&&(e.onParentElementResize=e.onParentElementResize.bind(e),Dc.addResizeListener(t.parentElement,e.onParentElementResize),e.updateScale()),!e.hideBryntumDomMessage&&(e.isTaskBoardBase||e.isGridBase||e.isCalendar)&&t.insertBefore(new Comment("POWERED BY BRYNTUM (https://bryntum.com)"),t.firstChild),e.onConnectedCallback&&globalThis.ResizeObserver&&(e.connectedObserver=new ResizeObserver((()=>{e.isElementConnected&&!t.isConnected?(e.onConnectedCallback(!1),e.isElementConnected=!1):!e.isElementConnected&&t.isConnected&&(e.onConnectedCallback(!0,null==e.isElementConnected),e.isElementConnected=!0)})),e.connectedObserver.observe(t))),e.eachWidget(Kc,!1),i&&(e.getConfig("tooltip"),!hd.Ripple&&hd.RippleClass&&(hd.Ripple=new hd.RippleClass({rootElement:e.rootElement})),globalThis.DocsBrowser&&e.floating&&e.closest((e=>{var t;return null===(t=e.element)||void 0===t?void 0:t.closest(".fiddlePanelResult,.b-owned-by-fiddle")}))&&t.classList.add("b-owned-by-fiddle")),e.isPainted=!0,i&&e.triggerConfigs("paint"),e.onInternalPaint({firstPaint:i}),e.trigger("paint",{firstPaint:i}),null===(r=e.afterInternalPaint)||void 0===r||r.call(e,{firstPaint:i}),null!=n&&n.size){for(const{callback:t,thisObj:i,args:r}of n.values())e.callback(t,i,r);n.clear()}i&&e.monitorResize&&!e.scaleToFitWidth&&Dc.onElementResize([{target:t}]),e.hasPainted=!0}}onInternalPaint(){}cancelHideShowAnimation(){const e=this,{currentAnimation:t,element:n}=e;t&&(e.isAnimating=!1,n.classList.contains("b-hiding")&&(n.classList.remove("b-hiding"),e._hidden=!1),t.detacher(),t.resolve(),n.style.transition=n.style[t.styleProp]="",e.currentAnimation=null,e.trigger((t.showing?"show":"hide")+"AnimationEnd"))}afterHideShowAnimate(e){const t=this;e===t.currentAnimation&&(t.element.classList.remove("b-hiding"),t.cancelHideShowAnimation(),t._hidden&&t.afterHideAnimation())}suspendVisibility(){this._visibilitySuspended=(this._visibilitySuspended||0)+1,Object.defineProperty(this,"isVisible",id)}resumeVisibility(e=!0){--this._visibilitySuspended||(delete this.isVisible,e&&this.triggerPaint())}hide(e=!0){return new Promise((t=>{const n=this;if(n._hidden||!1===n.trigger("beforeHide",{animate:e}))t(!1);else{const{element:i,lastAlignSpec:r}=n,{style:s}=i,o=e&&n.hideAnimation;if(n.clearTimeout("scrollListenerTimeout"),n.clearTimeout("resizeListenerTimeout"),n._hidden=!0,r&&(r.targetOutOfView=null,r.monitorIntersection&&(n.intersectionObserver.takeRecords(),n.intersectionObserver.unobserve(r.target))),n.onConfigChange({name:"hidden",value:!0,was:!1,config:n.$meta.configs.hidden}),!i)return void t();if(i.matches(":focus-within")&&n.revertFocus(!0),n.isDestroyed)return void t();if(n.cancelHideShowAnimation(),o){const e=Object.keys(o)[0],r=o[e];if(Number(getComputedStyle(n.element)[e])!==r.to){const o=n.currentAnimation={hiding:!0,styleProp:e,resolve:t};i.classList.add("b-hiding"),n.isAnimating=!0,o.detacher=Mn.onTransitionEnd({element:i,property:e,duration:td(r.duration)+20,handler:()=>{o===n.currentAnimation?n.afterHideShowAnimate(o):n.isAnimating=!1},thisObj:n}),s[e]=r.from,ki.getStyleValue(i,e),s.transition=`${e} ${r.duration} ease ${r.delay}`,s[e]=r.to}else n.syncHiddenCls()}else n.syncHiddenCls();n.ownedWidgets&&Object.values(n.ownedWidgets).forEach((t=>{var n;return t.floating&&(null===(n=t.hide)||void 0===n?void 0:n.call(t,e))})),n.afterHide(!o&&t,o)}}))}realignOnTransitionEnd(e){this.doHideOrRealign(e)}doHideOrRealign({target:e,type:t,isTrusted:n}){const i=this,{lastAlignSpec:r,element:s}=i,o=null==r?void 0:r.anchoredTo,a=null==r?void 0:r.target,l=null==r?void 0:r.position,c=ki.getActiveElement(i);if(!n||!fi(s)||e&&("scroll"===t&&!ki.isVisible(e)||s.contains(e)||e.nodeType===Element.ELEMENT_NODE&&i.owns(e)||e.nodeType===Element.DOCUMENT_NODE&&s.contains(c)&&ki.isTextualInput(c)&&globalThis.innerHeight<document.body.offsetHeight))return;if(r.aligningToElement){const e=ki.isInView(a,!1,i);if(e&&e.equals(r.targetRect))return}const d="hide"===i.scrollAction&&i.getXY();if(i.scrollRealigning="scroll"===t,i.realign(),i.scrollRealigning=!1,!i.isDestroyed&&pi(s)&&"hide"===i.scrollAction){const[t,n]=i.getXY(),s=t!==d[0]||n!==d[1];(null!=r&&r.aligningToEvent||(s||"Point"===(null==a?void 0:a.$$name)||l)&&(!o||!fi(o)||e&&ki.isDescendant(e,o)))&&i.hide()}}afterHide(e=null,t=this.hideAnimation){var n,i;const r=this;r._anchor=r._configuredAnchorState,r.removeTransientListeners(),t||r.afterHideAnimation(),r.trigger("hide"),null===(n=r.owner)||void 0===n||null===(i=n.onChildHide)||void 0===i||i.call(n,r),e&&e()}removeTransientListeners(){var e,t;const n=this,{targetObserver:i}=n;n.clearTimeout("resizeListenerTimeout"),n.clearTimeout("scrollListenerTimeout"),i&&(i.disconnect(),delete n.targetObserver),n.documentScrollListener=null===(e=n.documentScrollListener)||void 0===e?void 0:e.call(n),n.targetRootScrollListener=null===(t=n.targetRootScrollListener)||void 0===t?void 0:t.call(n),n.observedTargetEl&&(Dc.removeResizeListener(n.observedTargetEl,n.onTargetResize),n.observedTargetEl=!1),n.observedConstrainEl&&(Dc.removeResizeListener(n.observedConstrainEl,n.onAlignConstraintChange),n.observedConstrainEl=!1)}afterHideAnimation(){const e=this,{element:t}=e;!e.hasOwnProperty("_hideMode")&&e.floating&&e.floatRoot.contains(t)?t.remove():e.syncHiddenCls(),e.defaultAnchorBackgroundColor&&e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}changeHidden(e){const t=this;let n;return t.isConfiguring?(n=Boolean(e),t.syncHiddenCls(n)):(t.trigger("beforeChangeHidden",{hidden:e}),e?t.hide():t.show()),n}syncHiddenCls(e=this._hidden){const{element:t,hideMode:n}=this,i={"b-hidden":e};for(const t of zc)i[`b-hide-mode-${t}`]=t===n&&(e||"display"!==t);ki.assignClasses(t,i)}get assignedId(){return this.hasGeneratedId?null:this.id}get owner(){return this.parent||this._owner||this.containingWidget}changeOwner(e){if(!this.parent)return e}updateOwner(e,t){const n=this,{id:i}=n;t&&t.ownedWidgets&&delete t.ownedWidgets[i],e&&e!==n.parent&&((e.ownedWidgets||(e.ownedWidgets={}))[i]=n)}get containingWidget(){let e=this.parent;if(!e){var t,n;const i=(null===(t=this.forElement)||void 0===t?void 0:t.nodeType)===Element.ELEMENT_NODE?this.forElement:null===(n=this.element)||void 0===n?void 0:n.parentNode;e=(null==i?void 0:i.closest(".b-widget"))&&hd.fromElement(i)}return e}get previousSibling(){return this.getSibling(-1)}get nextSibling(){return this.getSibling(1)}getSibling(e){var t;const n=this,{parent:i}=n,r=i?i.childItems:Array.from((null===(t=n.element.parentElement)||void 0===t?void 0:t.querySelectorAll(".b-widget"))??[]);return i?r[r.indexOf(n)+e]:hd.fromElement(r[r.indexOf(n.element)+e])}up(e,t,n){var i;const{owner:r}=this;return e?null==r||null===(i=r.closest)||void 0===i?void 0:i.call(r,e,t,n):r}closest(e,t,n){const i=typeof n,r="number"===i,s="string"===i;for(let i=this,o=1;i;i=i.owner,o++){if(hd.widgetMatches(i,e,t))return i;if(r&&o>=n)return;if(s&&hd.widgetMatches(i,n,t))return;if(i===n)return}}owns(e,t){if(e){if("eventPhase"in e&&(e=e.target),e.nodeType===Element.ELEMENT_NODE){if(this.element.contains(e))return!0;e=e.getAttribute("owned-by")?hd.getById(e.getAttribute("owned-by")):hd.fromElement(e)}for(;e;){if(e.isHint||e===this||t&&this.ownedWidgets&&Object.values(this.ownedWidgets).some((t=>t.owns(e,!0))))return!0;e=e.owner}}return!1}eachAncestor(e){let t=this.owner;for(;t;){if(!1===e(t))return!1;t=t.owner}return!0}changeMaximizeOnMobile(e){const t=this;if(t.floating&&d.isMobile){const{initialConfig:n}=t;e?(t.centered=t.modal=!1,t.maximized=!0):(t.centered=n.centered,t.modal=n.modal,t.maximized=n.maximized)}}changeMonitorResize(e,t){const n=!this.scaleToFitWidth&&Boolean(e);if(n!==Boolean(t))return n}updateMonitorResize(e){const t=this;Qc(t,"onElementResize")||(t.onElementResize=t.onElementResize.bind(t)),Dc[e?"addResizeListener":"removeResizeListener"](t.element,t.onElementResize)}changeReadOnly(e){if(e=Boolean(e),Boolean(this._readOnly)!==e)return e}updateReadOnly(e){var t;null===(t=this.element)||void 0===t||t.classList[e?"add":"remove"]("b-readonly"),this.isConfiguring||(this.eachWidget((t=>{t.ignoreParentReadOnly||("_originalReadOnly"in t||(t._originalReadOnly=t.config.readOnly||!1),t.readOnly=e||t._originalReadOnly)}),!1),this.trigger("readOnly",{readOnly:e}))}eachWidget(e,t=!0,n){const i=n?this.childItemsOrderedByRelevance:this.childItems,r=(null==i?void 0:i.length)||0,s={};for(let o=0;o<r;o++){const r=i[o];if(s.down=t,!1===e(r,s))return!1;if(s.down&&r.eachWidget&&!1===r.eachWidget(e,t,n))return!1}return!0}queryAll(e){const t=[];return this.eachWidget((n=>{e(n)&&t.push(n)})),t}query(e,t){let n=null;return this.eachWidget((t=>{if(e(t))return n=t,!1}),!0,t),n}getWidgetByRef(e){var t,n;return e instanceof hd?e:(null==this||null===(t=this.widgetMap)||void 0===t?void 0:t[e])||(null==this||null===(n=this.owner)||void 0===n?void 0:n.getWidgetByRef(e))}onFocusIn(e){const t=this,{element:n}=t;t.containsFocus=!0,t.focusInEvent=e,(t.floating||t.positioned)&&t.toFront(),n.classList.add("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),n.contains(e._target)&&t.onInternalKeyDown&&!t.keyDownListenerRemover&&(t.keyDownListenerRemover=Mn.on({element:n,keydown:"onInternalKeyDown",thisObj:t})),t.trigger("focusin",e)}onFocusOut(e){const t=this;t.keyDownListenerRemover&&(t.keyDownListenerRemover(),t.keyDownListenerRemover=null),t.isDestroyed||(e.relatedTarget||t.revertFocus(!t.isVisible),t.containsFocus=!1,t.element.classList.remove("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),t.trigger("focusout",e))}captureFocus(){const e=this,t=ki.getActiveElement(e),n=e.contains(t)&&e.captureFocusItem(t);return(i,r)=>{if(n&&!e.isDestroying){(ki.getActiveElement(e)!==t||r)&&n(i)}}}captureFocusItem(e){return(t=!0)=>{this.contains(e)&&(t?e.focus():e.focus({preventScroll:!0}))}}contains(e,t){const{element:n}=this;if(e&&n)return e.isWidget&&(e=e.element),n.contains(e)&&(!t||n!==e)}revertFocus(e){var t,n;const i=this,r=ki.getActiveElement(i);let s=null===(t=i.focusInEvent)||void 0===t?void 0:t.relatedTarget;(e||i.containsFocus&&(null===(n=s)||void 0===n?void 0:n.nodeType)===Element.ELEMENT_NODE&&i.element.contains(r))&&(s&&ki.isFocusable(s)||(s=i.getFocusRevertTarget()),i._isRevertingFocus=!0,s&&ki.isFocusable(s)?(s._isRevertingFocus=!0,s.focus({preventScroll:!0}),s._isRevertingFocus=!1):null==r||r.blur(),i._isRevertingFocus=!1)}getFocusRevertTarget(){const e=this,{owner:t,focusInEvent:n}=e,i=n&&n.backwards?1:-1;let r=n&&n.relatedTarget;const s=r&&hd.fromElement(r);if(t&&!t.isDestroyed&&(!r||!ki.isFocusable(r)||s&&!s.isFocusable)){var o;if(r=null,t.eachWidget){const n=[];if(t.eachWidget((t=>{(t===e||t.isFocusable)&&n.push(t)}),!1),n.length>1){const t=n.indexOf(e);r=n[t+i]||n[t-i]}}!r&&t.isFocusable&&(r=t),r=r?r.focusElement:null===(o=t.getFocusRevertTarget)||void 0===o?void 0:o.call(t)}return r}getStaticWidgetClasses(e,t){const n=new Ht,i=this.$meta.hierarchy;let r,s,o,a,l;for(s=i.indexOf(e);s<i.length;++s){var c;r=i[s],l=Reflect.getOwnPropertyDescriptor(r.prototype,"widgetClass"),null!==(c=l)&&void 0!==c&&c.get?a=l.get.call(this):(o=Qc(r,"$$name")||Qc(r,"$name")||Qc(r,"_$name")?r.$$name:r.name,(o.length<3||o.includes("$"))&&console.warn(`Class "${o}" extending "${r.$name}" should have "$name" static getter with no less than 3 chars.`),a=`b-${o.toLowerCase()}`),a&&n.add(t?a+t:a)}return n}get rootUiClass(){return hd}get staticClassList(){const{$meta:e}=this;let t=e.staticClassList;return t||(e.staticClassList=t=this.getStaticWidgetClasses(hd),d.isTouchDevice&&t.add("b-touch")),t}get uiClasses(){return this.getConfig("ui"),this._uiClasses}get uiClassList(){return this.getConfig("ui"),this._uiClassList}get widgetClassList(){const e=this,{cls:t,defaultCls:n,uiClasses:i}=e;let{staticClassList:r}=e;(n||t)&&(r=r.clone(),n&&r.assign(n),t&&r.assign(t));const s=r.values;return i&&s.push(...i),e.floating&&s.push("b-floating"),"hide"===e.collapsify&&s.push("b-collapsify-hide"),s}changeCls(e){return Ht.from(e)}updateCls(e,t){if(!this.isConfiguring&&!this.isComposable){const{element:n}=this;t&&U.getTruthyKeys(t).forEach((e=>n.classList.remove(e))),e.assignTo(n)}}changeContentElementCls(e){return Ht.from(e)}changeHtmlCls(e){return Ht.from(e)}changeDefaultCls(e){return Ht.from(e,!0)}updateHideMode(){this.hasPainted&&this.syncHiddenCls()}changeUi(e){return Ht.from(e)}updateUi(e){var t;let n,i,r=null;if(e){const t=this.getStaticWidgetClasses(this.rootUiClass);for(i in e)if(e[i])for(n in t)t[n]&&((r||(r=new Ht))[`${n}-ui-${i}`]=1)}this._uiClasses=null===(t=r)||void 0===t?void 0:t.values,this._uiClassList=r}fromCache(e,t=!1,n=this.element){var i;if(!n)return null;const r=this;return null!==(i=r.cache)&&void 0!==i&&i[e]?r.cache[e]:(r.cache||(r.cache={}),r.cache[e]=t?ki.children(n,e):n.querySelector(e))}emptyCache(){this.cache&&(this.cache={})}changeMasked(e,t){var n;if("trial"!==(null===(n=this.masked)||void 0===n?void 0:n.type)){if(!0!==e&&""!==e||(e=" "),t&&!t.isDestroyed)"string"==typeof e?(t.text=e,e=t):e?(t.setConfig(e),e=t):t.destroy();else if(e){const t=hd.resolveType("mask");(e=t.mergeConfigs(this.maskDefaults,e)).owner=this,e=t.mask(e)}return e||null}}onMaskAutoClose(e){e.isDestroyed&&e===this.masked&&(this.masked=null)}mask(e){return this.masked=e,this.masked}unmask(){this.masked=null}onInternalResize(e,t,n,i,r){this._width=e.offsetWidth,this._height=e.offsetHeight}onElementResize(e,t,...n){const i=this,{element:r}=i,s=i._width??i._oldWidth,o=i._height,a=r.offsetWidth,l=r.offsetHeight;i.floating&&t&&i.onFloatingWidgetResize(e,t,...n),i.suspendResizeMonitor||s===a&&o===l||(i.onInternalResize(r,a,l,s,o),i.trigger("resize",{width:a,height:l,oldWidth:s,oldHeight:o}))}onFloatingWidgetResize(e,t,n){const i=this,{lastAlignSpec:r,constrainTo:s}=i;if(i.isVisible&&r&&r.target){const e=!t||n.height!==t.height,o=!t||n.width!==t.width,a=s&&!_t.from(s).contains(_t.from(i.element,null,!0));(e&&2!==r.zone||o&&1!==r.zone||a)&&i.requestAnimationFrame((()=>i.realign()))}}updateScale(){const e=this,t=e.element,n=t.parentElement;e.configuredWidth||(e.configuredWidth=e.width),t.style.display="none";const i=_t.client(n).width/e.configuredWidth,r=e.scale=e.allowGrowWidth?Math.min(i,1):i;t.style.transform=`scale(${r})`,t.style.transformOrigin="top left",t.style.display="",e.allowGrowWidth&&i>1&&(e.width=e.configuredWidth*i)}onParentElementResize(e){this.updateScale()}parseTRBL(e,t="px"){if("number"==typeof(e=e||0))return[`${e}${t}`,`${e}${t}`,`${e}${t}`,`${e}${t}`];const n=e.split(" "),i=n.length;return 1===i?n[1]=n[2]=n[3]=n[0]:2===i?(n[2]=n[0],n[3]=n[1]):3===i&&(n[3]=n[1]),[isFinite(n[0])?`${n[0]}${t}`:n[0],isFinite(n[1])?`${n[1]}${t}`:n[2],isFinite(n[2])?`${n[2]}${t}`:n[3],isFinite(n[3])?`${n[3]}${t}`:n[4]]}get documentRoot(){var e;return(null===(e=this.owner)||void 0===e?void 0:e.documentRoot)||this.element.getRootNode()}get eventRoot(){var e,t;return null!==(e=this.element)&&void 0!==e&&e.isConnected?ki.getRootElement(this.element):(null===(t=this.owner)||void 0===t?void 0:t.eventRoot)||this._rootElement}get rootElement(){const e=this;if(!e._rootElement){var t,n;let i=(null===(t=e.owner)||void 0===t?void 0:t.rootElement)||ki.getRootElement(e.forElement||(null!==(n=e.element)&&void 0!==n&&n.isConnected?e.element:e.getRenderContext()[0]||e.element));i||(i=document.body),e._rootElement=i}return e._rootElement}get floatRoot(){const{rootElement:e}=this;let{floatRoot:t}=e;if(t)e.contains(t)||e.appendChild(t);else{var n;const{outerCls:i}=hd,r=null===(n=ki.getThemeInfo(null,e))||void 0===n?void 0:n.name;if(!ki.isValidFloatRootParent(e))throw new Error("Attaching float root to wrong root");r&&i.push(`b-theme-${r.toLowerCase()}`),t=e.floatRoot=ki.createElement({className:`b-float-root ${i.join(" ")}`,parent:e}),Hc.push(t),d.isAndroid&&(t.style.height="100dvh",Mn.on({element:globalThis,orientationchange:()=>t.style.height=`${screen.height}px`,thisObj:this})),Hi.ion({theme:({theme:e,prev:n})=>{t.classList.add(`b-theme-${e.toLowerCase()}`),t.classList.remove(`b-theme-${n.toLowerCase()}`)}})}return t.classList.toggle("b-rtl",Boolean(this.rtl)),t}get floatRootMaxZIndex(){let e=1;return Array.from(this.floatRoot.children).forEach((t=>{const n=parseInt(getComputedStyle(t).zIndex||0,10);n>e&&(e=n)})),e}get focusVisible(){return ki.getActiveElement(this.element).matches(":focus-visible")}static get focusVisible(){return ki.getActiveElement().matches(":focus-visible")}static get floatRoots(){return Hc}static removeFloatRoot(e){Hc.splice(Hc.indexOf(e),1)}static get outerCls(){const e=["b-outer"],{platform:t}=d;return t&&e.push(`b-${t}`),d.isTouchDevice&&e.push("b-touch-events"),d.isMobile&&e.push("b-mobile"),ki.scrollBarWidth?e.push("b-visible-scrollbar"):e.push("b-overlay-scrollbar"),d.isChrome?e.push("b-chrome"):d.isSafari?e.push("b-safari"):d.isFirefox&&e.push("b-firefox"),d.isPhone&&e.push("b-phone"),globalThis.ResizeObserver||e.push("b-no-resizeobserver"),e}get isAnimating(){return this._isAnimatingCounter>0}set isAnimating(e){const t=this,{_isAnimatingCounter:n}=t;t._isAnimatingCounter=Math.max(0,n+(e?1:-1)),0===n&&e?(t.element.classList.add("b-animating"),t.trigger("animationStart")):1!==n||e||(t.element.classList.remove("b-animating"),t.trigger("animationEnd"))}async waitForAnimations(){this.isAnimating&&await this.await("animationEnd",{checkLog:!1})}async executeAndAwaitAnimations(e,t,n){const i=e.getAnimations({subtree:!0});await t();const r=e.getAnimations({subtree:!0}),s=rt.delta(i,r).onlyInB.filter((e=>e.effect.getTiming().iterations!==1/0));s.length&&await Promise.allSettled(s.map((e=>e.finished))),this.isDestroyed||null==n||n()}static query(e,t=!1){const{idMap:n}=hd.identifiable;for(const i in n)if(hd.widgetMatches(n[i],e,t))return n[i];return null}static queryAll(e,t=!1){const{idMap:n}=hd.identifiable,i=[];for(const r in n)hd.widgetMatches(n[r],e,t)&&i.push(n[r]);return i}static fromElement(e,t,n){const i=typeof t;"string"==typeof e&&(e=document.querySelector(e)),e&&!e.nodeType&&(e=e.target),("number"===i||t&&t.nodeType===Element.ELEMENT_NODE)&&(n=t,t=null);let r,s,o,a=e,l=0;for("number"!=typeof n&&(r=n,n=Number.MAX_VALUE),"string"===i&&(t=t.toLowerCase());a&&a.nodeType===Element.ELEMENT_NODE&&l<n&&a!==r;){if(s=a.dataset&&a.dataset.ownerCmp||a.id,s){if(o=hd.getById(s),o){if(!t)return o;if("function"===i){if(t(o))return o}else if(hd.widgetMatches(o,t,!0))return o}l++}a=Si(a)}return null}static fromSelector(e){const t=document.querySelector(e);return t?hd.fromElement(t):null}triggerFieldChange(e,t=!0){var n;t?this.trigger("change",e):e.source=this,null===(n=this.eachAncestor)||void 0===n||n.call(this,(t=>{var n,i;if(null===(n=t.onFieldChange)||void 0===n||n.call(t,e),null!==(i=t.isolateFieldChange)&&void 0!==i&&i.call(t,this))return!1}))}isolateFieldChange(e){return this.isolateFields}setupFocusListeners(){var e,t;Hi.setupFocusListenersOnce(this.eventRoot,Mn),null===(e=hd.Ripple)||void 0===e||null===(t=e.setupRippleListenerOnce)||void 0===t||t.call(e)}static widgetMatches(e,t,n){return"*"===t||("function"==typeof t?t(e):hd.isType(e,t,n))}static attachTooltip(e,t){return"string"==typeof t&&(t={html:t}),hd.create(Object.assign({forElement:e},t),"tooltip"),e}static append(e,t={}){return(t instanceof HTMLElement||"string"==typeof t)&&(t={appendTo:t}),rt.asArray(e).map((e=>hd.create(U.assign({},t,e))))}changeDock(e){return"start"===e?"left":"end"===e?"right":e}updateRtl(e){super.updateRtl(e),this.eachWidget((t=>{"rtl"in t.initialConfig||(t.rtl=e)})),this.ownedWidgets&&Object.values(this.ownedWidgets).forEach((t=>{"rtl"in t.initialConfig||(t.rtl=e)}))}get scrollAction(){let{_scrollAction:e}=this;return!e&&this.anchor&&(e="realign"),e}announceAriaLive(e="",t="polite"){var n;const i=this.ariaLiveEl||(this.ariaLiveEl=ki.createElement({parent:this.element,className:"b-arialive-el","aria-live":t,"aria-atomic":!0}));if(null!==(n=this.element)&&void 0!==n&&n.isConnected){const t=e.children?e.children.reduce(ud,[]).join(" "):e.text||e;i.textContent=t}}}const gd=hd.prototype;["compose","domSyncCallback"].forEach((e=>gd[e].$nullFn=!0)),hd.initClass(),ki.Widget=hd,Hi.Widget=hd,Object.assign(globalThis.bryntum||(globalThis.bryntum={}),{Widget:hd,get:(e=globalThis.$0)=>e.nodeType?hd.fromElement(e):hd.getById(e),query:hd.query,queryAll:hd.queryAll,fromElement:hd.fromElement,fromSelector:hd.fromSelector}),hd._$name="Widget";class md extends(tt.mixin(dt,Ls)){static type="default";static configurable={owner:null,containerCls:"b-auto-container",itemCls:null};static factoryable={defaultType:"default"};get contentElement(){var e;return null===(e=this.owner)||void 0===e?void 0:e.contentElement}onChildAdd(e){}onChildRemove(e){}renderChildren(){const e=this,{owner:t,itemCls:n}=e,{contentElement:i,items:r}=t,s=t.itemCls,o=null==r?void 0:r.length;if(o){t.textContent=!1;for(let e,a,l=0;l<o;l++){const o=r[l],{element:c,positionable:d}=o,{classList:u}=c;c.dataset.itemIndex=l,u.contains("b-outer")&&u.remove(...hd.outerCls),n&&u.add(n),s&&u.add(s),a=i,d&&(e=t.getPositionableLocation(d),(a=e[0])||(a=e[1].parentElement,o.insertBefore=e[1])),o.render(a,Boolean(t.isPainted))}}e.syncPendingConfigs(),e.syncChildCount()}removeChild(e){const t=this,{element:n}=e,{owner:i,itemCls:r}=t,{contentElement:s}=i,o=i.itemCls;s.contains(n)&&n.remove(),delete n.dataset.itemIndex,r&&n.classList.remove(r),o&&n.classList.remove(o),t.fixChildIndices(),t.syncChildCount()}appendChild(e){const{element:t}=e,{owner:n,itemCls:i}=this,{contentElement:r}=n,s=n.itemCls;t.dataset.itemIndex=n.indexOfChild(e),n.textContent=!1,i&&t.classList.add(i),s&&t.classList.add(s),e.render(r,Boolean(n.isPainted)),this.syncChildCount()}insertChild(e,t){const n=this,{element:i}=e,{owner:r,itemCls:s}=n,{contentElement:o}=r,a=ki.getChild(o,`[data-item-index="${t}"]`),l=r.itemCls;r.textContent=!1,s&&i.classList.add(s),l&&i.classList.add(l);const c=o.contains(i);o.insertBefore(i,a),c||e.render(null,Boolean(r.isPainted)),n.fixChildIndices(),n.syncChildCount()}fixChildIndices(){this.owner.items.forEach(((e,t)=>{e.element.dataset.itemIndex=t}))}syncChildCount(){var e;const{owner:t}=this,{length:n}=t.items;null===(e=t.contentElement)||void 0===e||e.classList[1===n?"add":"remove"]("b-single-child")}syncConfigLater(e){const t=this.pendingConfigs||(this.pendingConfigs=[]);t.includes(e)||t.push(e)}syncConfigStyle({name:e,style:t,classes:n,map:i}){const r=this,s=`b-box-${e}-`,{contentElement:o}=r,a=r[e];let l=(null==i?void 0:i[a])||a;if(o){if(n){const{classList:e}=o;n.forEach((t=>{t!==l&&e.remove(s+t)})),n.includes(l)&&(e.add(s+l),l="")}o.style[t]=l}else r.syncConfigLater(e)}syncPendingConfigs(){const e=this,{pendingConfigs:t}=e;let n;if(t)for(e.pendingConfigs=null;n=t.pop();)e[e.$meta.configs[n].updater](e[n])}}md.initClass(),md._$name="Layout";let pd=0;const fd=e=>e.ripple;class vd extends hd{static $name="Ripple";static type="ripple";static configurable={old_element:{children:[{className:"b-ripple-inner",reference:"rippleElement"}]},element:{children:[{tag:"svg",class:"b-ripple-inner",reference:"rippleElement",ns:"http://www.w3.org/2000/svg",version:"1.1",viewBox:"0 0 100 100",children:[{reference:"circleElement",tag:"circle",cx:"0",cy:"0",r:10}]}]},floating:!0,hideAnimation:!1,showAnimation:!1,color:"rgba(0,0,0,.3)",startRadius:10,radius:100};afterConstruct(){super.afterConstruct(),this.setupRippleListenerOnce()}setupRippleListenerOnce(){this.rippleControlEventDetacher||(this.rippleControlEventDetacher=Mn.on({element:this.rootElement,mousedown:"onRippleControllingEvent",thisObj:this,capture:!0,once:!0}))}cleanUpRippleListeners(){var e,t;null===(e=this.rippleControlEventDetacher)||void 0===e||e.call(this),null===(t=this.listenerDetacher)||void 0===t||t.call(this),this.rippleControlEventDetacher=null,this.listenerDetacher=null}onRippleControllingEvent(e){var t;const n=this;n.show();const i=ki.getStyleValue(n.circleElement,"animationName");n.hide(),null===(t=n.listenerDetacher)||void 0===t||t.call(n),i&&"none"!==i&&(n.listenerDetacher=Mn.on({mousedown:{element:n.rootElement,capture:!0,handler:"onMousedown"},touchstart:{element:n.rootElement,capture:!0,handler:"onTouchStart"},animationend:{element:n.circleElement,handler:"onAnimationEnd"},thisObj:n}),"mousedown"===e.type&&(n.onMousedown(e),n.listenerDetacher=te.createSequence(n.listenerDetacher,Hi.ion({theme:"onRippleControllingEvent",thisObj:n}),n,n)))}onTouchStart(e){pd=performance.now(),this.handleTriggerEvent(e)}onMousedown(e){performance.now()-pd>200&&this.handleTriggerEvent(e)}handleTriggerEvent(e){const t=hd.fromElement(e.target,fd);if(t){const n=t.ripple,i=n.delegate?e.target.closest(n.delegate):t.focusElement||t.element;if(i){const r=U.assign({event:e,target:i,radius:this.radius},n);if("string"==typeof r.clip&&(r.clip=t[r.clip]||e.target.closest(r.clip),!r.clip))return;this.ripple(r)}}}ripple({event:e,point:t=Mn.getClientPoint(e),target:n=e.target,clip:i=n,radius:r=this.radius,color:s=this.color}){this.clip=i;const o=this,a=(i=_t.from(i,null,!0)).getDelta(t),l=o.rippleElement.style,c=o.circleElement,d=ki.getStyleValue(n,"border-radius");o.hide(),l.transform=`translateX(${a[0]}px) translateY(${a[1]}px)`,l.height=l.width=`${r}px`,o.element.style.borderRadius=d,c.setAttribute("r",r),c.setAttribute("fill",s),o.showBy({target:i,align:"c-c",matchSize:!0})}onAnimationEnd(e){"b-ripple-expand"===e.animationName&&this.hide()}}hd.RippleClass=vd,vd._$name="Ripple";const yd=e=>e.element.classList.contains("b-visible"),bd=e=>!yd(e)&&e.isVisible;class Cd extends hd{static $name="Mask";static type="mask";static configurable={autoClose:null,cover:null,icon:"b-icon b-icon-spinner",errorDefaults:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},maxProgress:null,mode:"dark",progress:null,target:{$config:"nullify",value:void 0},text:null,type:null,showDelay:null,useTransition:!1};static delayable={deferredClose:0,delayedShow:0,syncCover:{type:"throttle",delay:100}};static counter=0;static get(e){return Ul.get(e,"masks")||Ul.set(e,"masks",[])}static getActive(e){return Cd.get(e).find(yd)||null}static getPending(e){return Cd.get(e).filter(bd).sort(hd.weightSortFn)}static mask(e,t=document.body){return Cd.new({target:t},e)}static mergeConfigs(...e){return e=e.map((e=>"string"==typeof e?{text:e}:e)),super.mergeConfigs(...e)}static sync(e){const t=Cd.getActive(e),n=!t&&Cd.getPending(e)[0]||null,i=t||n,r=(null==i?void 0:i.mode)||"",s=r.endsWith("blur")?`b-masked-${r}`:"";let o,a,l;for(o of(n&&(a=n.element.classList,n.showDelay&&!e.classList.contains("b-masked")&&(a.add("b-delayed-show"),n.delayedShow()),a.add("b-visible")),e.classList.toggle("b-masked",Boolean(i)),e.children))a=o.classList,a.contains("b-mask")||(l=Array.from(a).filter((e=>e.startsWith("b-masked-")&&s!==e)),l.length&&a.remove(...l),s&&a.add(s))}static unmask(e=document.body){var t;const n=Cd.get(e),i=n.length;return i?null===(t=n[i-1])||void 0===t?void 0:t.close():null}static unmaskAll(e=document.body){return Cd.get(e).filter((e=>!yd(e))).forEach((e=>e.destroy())),Cd.unmask(e)}destroy(){"trial"!==this.type&&super.destroy()}compose(){const{icon:e,maxProgress:t,mode:n,progress:i,showDelay:r,text:s,html:o,useTransition:a}=this;return{class:{"b-mask":1,"b-delayed-show":r,"b-progress":t,"b-prevent-transitions":!a,[`b-mask-${n}`]:1},children:{maskContent:{class:"b-mask-content",children:{progressElement:t?{class:"b-mask-progress-bar",style:{width:`${Math.max(0,Math.min(100,Math.round(i/t*100)))}%`}}:null,maskText:{class:"b-mask-text",html:`${e?`<i class="b-mask-icon ${e}"></i>`:""}${s||o||""}`}}}},listeners:{mousedown:"onMaskMouseDown",capture:!0}}}onMaskMouseDown(e){e.preventDefault()}generateAutoId(){const{type:e}=this;return`mask${"string"==typeof e?e.trim():""}-${Cd.counter++}`}updateAutoClose(e){this.deferredClose.cancel(),e&&(this.deferredClose.delay=e,this.deferredClose())}updateCover(){this.syncCover()}syncCover(){var e,t;null===(e=this.owner)||void 0===e||null===(t=e.syncMaskCover)||void 0===t||t.call(e,this)}set error(e){this.setConfig({...this.errorDefaults,text:e})}onOwnerResize(){this.syncCover()}updateOwner(e){this.detachListeners("cover"),null==e||e.ion({name:"cover",recompose:"onOwnerResize",resize:"onOwnerResize",thisObj:this})}updateShowDelay(e){const{delayedShow:t}=this;t.delay=e,e||t.flush()}changeTarget(e){return void 0===e?e=document.body:"string"==typeof e&&(e=this.owner[e]),e}updateTarget(e,t){const n=this,{id:i,element:r}=n,s=t&&Cd.get(t);t&&(t[i]===n&&delete t[i],rt.remove(s,n),Cd.sync(t)),e?(e[i]||(e[i]=n),r.parentNode!==e&&e.appendChild(r),rt.include(Cd.get(e),n),Cd.sync(e)):r.remove()}deferredClose(){var e;const t=this,{owner:n}=t;t.close().then((()=>{var e;return null==n||null===(e=n.onMaskAutoClose)||void 0===e?void 0:e.call(n,t)})),null==n||null===(e=n.onMaskAutoClosing)||void 0===e||e.call(n,t)}delayedShow(){this.element.classList.remove("b-delayed-show")}updateHidden(e,t){var n;null===(n=super.updateHidden)||void 0===n||n.call(this,e,t),e&&this.element.classList.remove("b-visible"),Cd.sync(this.target)}afterShow(...e){var t;null===(t=super.afterShow)||void 0===t||t.call(this,...e),Cd.sync(this.target)}afterHide(...e){var t;null===(t=super.afterHide)||void 0===t||t.call(this,...e),this.element.classList.remove("b-visible"),Cd.sync(this.target)}async close(){await this.hide(),this.destroy()}}Cd.initClass(),Cd._$name="Mask";const Sd=Object.freeze({}),{isArray:wd}=Array,Dd=e=>e.weight,Ed=e=>e&&!e.hidden,xd=e=>e.isFocusable,Rd=["display","flex-direction"],Td={default:1,box:1},Md=Symbol("options");class Id extends hd{static $name="Container";static type="container";static get configurable(){return{items:null,lazyItems:{$config:["lazy"],value:null},tabBarItems:null,defaults:null,defaultType:"widget",layoutStyle:null,itemCls:null,layout:{type:"default"},namedItems:{$config:"lazy",value:null},overflowable:{value:null,default:!1,$config:null},textContent:!0,record:null,strictRecordMapping:null,autoUpdateRecord:null,autoUpdateUserChangesOnly:!0,autoUpdateFields:null,hideWhenEmpty:null,contentElMutationObserver:{$config:["lazy","nullify"],value:!0},isolateFields:!1,focusDescendant:!1,defaultBindProperty:null,defaultFocus:null}}static get prototypeProperties(){return{flexRowCls:"b-flex-row",flexColCls:"b-flex-column",initialItems:!0}}startConfigure(e){const t=e.items||e.lazyItems;(this.hasItems=Boolean(t&&(wd(t)?t:Object.keys(t)).length))||(this.initialItems=!1),super.startConfigure(e)}get firstItem(){return this.getAt(0)}get lastItem(){return this.getAt(-1)}getPositionableItems(e,t){var n;const i=(null===(n=this._items)||void 0===n?void 0:n.filter((t=>e?t.positionable===e:t.positionable)))||[];return t?Object.fromEntries(i.map(((e,t)=>[`$${e.positionable}${t}`,e.element]))):i}getPositionableLocation(e){return[this.contentElement]}getAt(e){return this.ensureItems().at(e)}remove(...e){let t=!0;1===e.length&&(wd(e[0])?e=e[0]:t=!1);const n=this,{_items:i}=n,r=[];for(let t=0;t<e.length;t++){const s=e[t];i.includes(s)&&(i.remove(s),n.layout.removeChild(s),r.push(s),n.onChildRemove(s))}return t?r:r[0]}removeAll(){return this.remove(this.items)}add(...e){const t=this,n=t.ensureItems(),i=[];let r,s,o,a=!0;for(1===e.length&&(wd(e[0])?e=e[0]:a=!1),s=0;s<e.length;s++){var l;r=e[s],r.isWidget?r.parent=t:r=t.createWidget(r),null!=(null===(l=r)||void 0===l?void 0:l.weight)?(o=rt.findInsertionIndex(r,n.values,hd.weightSortFn),i.push(t.insert(r,o))):r&&(n.includes(r)||(n.add(r),t.onChildAdd(r),t.layout.appendChild(r),i.push(r)))}return a?i:i[0]}ensureItems(){const e=this;return e.getConfig("items"),e.getConfig("lazyItems"),e._items||(e.items=[]),e._items}insert(e,t){const n=this,i=n.ensureItems();e instanceof hd?e.parent=n:e=n.createWidget(e),i.includes(t)&&(t=n.indexOfChild(t)-1),t=Math.min(t,i.count);const r=i.values;if(r.includes(e)){var s;const o=r.indexOf(e);r.splice(o,1),r.splice(t,0,e),i.values=r,n.syncChildCount(),null===(s=n.onChildMove)||void 0===s||s.call(n,e),n.layout.insertChild(e,t<o?t:t+1)}else r.splice(t,0,e),i.values=r,n.onChildAdd(e),n.layout.insertChild(e,t);return e}indexOfChild(e){return this.items.indexOf(e)}changeLazyItems(e){this.items=e,this.layout.renderChildren()}onChildWeightChange(e){if(this.items.length>1){var t;const{lastItem:n}=this;this._items.sort(hd.weightSortFn);const{items:i}=this;this.contentElement.insertBefore(e.element,(null===(t=i[i.indexOf(e)+1])||void 0===t?void 0:t.element)||n.element.nextSibling)}}changeItems(e,t){const n=this,i=[],r=new Vo;return wd(e)?n.processItemsArray(e,i):e&&n.processItemsObject(e,n.namedItems,i),i.some(Dd)&&i.sort(hd.weightSortFn),r.add(i),t&&t.forEach((e=>{n.remove(e),r.includes(e)||e._createdBy!==n||e.destroy()})),r}afterConstruct(){const{rtl:e}=this,{classList:t}=this.contentElement;t.toggle("b-rtl",!0===e),t.toggle("b-ltr",!1===e)}updateRtl(e){super.updateRtl(e);const{contentElement:t}=this;t&&(t.classList.toggle("b-rtl",!0===e),t.classList.toggle("b-ltr",!1===e))}updateItems(e,t){let n=0;e.forEach((e=>{this.onChildAdd(e),t&&!t.temporary&&this.layout.insertChild(e,n),++n})),this.initialItems=!1}updateHideWhenEmpty(){this.syncChildCount(this.rendered)}get items(){const e=this;if(e.getConfig("lazyItems"),!e._items){if(e.initializingItems)return[];e._items=new Vo,e._items.temporary=!0}return e._items.values}processItemsArray(e,t){const n=e.length;let i,r;for(i=0;i<n;i++)r=e[i],r instanceof hd?(r.parent=this,r.element.classList.remove(...hd.outerCls)):r=this.createWidget(r),r&&((r.ref||r.id)&&this.addDescendant(r),t.push(r))}processItemsObject(e,t,n=[]){let i,r;for(r in e)i=e[r],i&&(t&&r in t&&(i="object"==typeof i?U.merge(U.clone(t[r]),i):t[r]),i&&(i instanceof hd?i.parent=this:(i instanceof Object&&(i.ref=r),i=this.createWidget(i)),i&&(i.ref=r,this.addDescendant(i),n.push(i))));return n}onChildAdd(e){const t=this;if(e.innerItem&&t.readOnly&&!e.ignoreParentReadOnly&&(e.readOnly=!0),t.onChildAddLayout(e),e.ref||e.id)for(let n=t;n;n=n.parent)n.addDescendant(e);t.syncChildCount(!0),!t.onConfigChange.$nullFn&&t.onConfigChange({name:"items",config:t.$meta.configs.items})}onChildAddLayout(e){e.innerItem&&this.layout.onChildAdd(e)}onChildHide(e){var t;super.onChildHide(e),null!==(t=this._items)&&void 0!==t&&t.includes(e)&&this.syncChildCount(!0)}onChildShow(e){var t;super.onChildShow(e),null!==(t=this._items)&&void 0!==t&&t.includes(e)&&this.syncChildCount(!0)}syncChildCount(e){if(!this.isConfiguring&&!this.isDestroying){const t=this,{items:n,hasItems:i}=t,r=n.filter(Ed),{length:s}=r;if(t.visibleChildCount=s,t.hideWhenEmpty&&e){const e=Boolean(!s);Boolean(t._hidden)!==e&&(t.hidden=e)}n.forEach((e=>e.element.classList.remove("b-last-visible-child","b-first-visible-child"))),s&&(r[0].element.classList.add("b-first-visible-child"),r[s-1].element.classList.add("b-last-visible-child")),t.hasItems=Boolean(t.childItems.length),t.contentElement.classList[s?"remove":"add"]("b-no-visible-children"),t.isComposable?i!==t.hasItems&&t.recompose():t.updateTextContent(t._textContent)}}syncFlexDirection(){const{contentElement:e,flexColCls:t,flexRowCls:n}=this,i=new Ht(e.className),r=ki.getStyleValue(e,Rd);i[n]=i[t]=0,"flex"===r.display&&(i["row"===r["flex-direction"]?n:t]=1),ki.syncClassList(e,i)}addDescendant(e){const t=e.ref||e.id,n=this._widgetMap||(this._widgetMap={});n[t]||(n[t]=e)}cleanupWidgetMap(e){const t=this,n=new Map,i=e.ref||e.id;i&&n.set(i,e),e.eachWidget((e=>{const t=e.ref||e.id;t&&n.set(t,e)}));for(let e=t;e;e=e.parent)for(const[t,i]of n)e.widgetMap[t]===i&&delete e.widgetMap[t]}onChildRemove(e){const t=this;t.cleanupWidgetMap(e),t.layout.onChildRemove(e),t.syncChildCount(!0),!t.onConfigChange.$nullFn&&t.onConfigChange({name:"items",config:t.$meta.configs.items})}get widgetMap(){return this._widgetMap||(this._widgetMap={}),this.initializingItems||this.getConfig("items"),this._widgetMap}changeRecord(e){return this._record=null==e?Sd:null,e}updateRecord(e){var t;const n=this;null===(t=n.recordUpdateDetacher)||void 0===t||t.call(n),n._hasChanges=!1,n.changeSet={},n.clearError(),n.trigger("beforeSetRecord",{record:e}),n.setValues(e,{onlyName:n.strictRecordMapping,highlight:Boolean(n.$highlight)}),n.autoUpdateFields&&null!=e&&e.firstStore&&(n.recordUpdateDetacher=e.firstStore.ion({update:n.onRecordUpdated,thisObj:n}))}setRecord(e,t){this.$highlight=t,this.record=e,this.$highlight=!1}onRecordUpdated({record:e}){e===this.record&&this.setValues(this.record,!0,!0)}shouldUpdateRecordOnAction(e,t){return e&&(t.userAction||!this.autoUpdateUserChangesOnly)}onFieldChange(e){const t=this,{source:n}=e,{hasChanges:i,isConfiguring:r,isSettingValues:s,initialValues:o}=t;if(!s&&!r){const{record:r}=t;let s=!1;if(t.autoUpdateRecord&&t.shouldUpdateRecordOnAction(r,e)){const{strictRecordMapping:e}=t,{name:i,ref:o,isValid:a=!0,defaultBindProperty:l}=n,c=n[l||"value"],d=e?i:i||o;r&&d&&a&&(r.isModel?r.setValue(d,c):r[d]=c,s=!0)}if(r&&o){const e=n.getValueName(o[Md]);if(e&&(!r.isModel||r.getFieldDefinition(e))){const{changeSet:i}=t;t.autoUpdateRecord&&s||U.isEqual(n.value,o[e])?i&&delete i[e]:(i||(t.changeSet={}))[e]=!0,t._hasChanges=void 0}}t.hasChanges!==i&&t.trigger("dirtyStateChange",{dirty:t.hasChanges})}}get hasChanges(){let{_hasChanges:e}=this;if(void 0===e){const{changeSet:t}=this;e=this._hasChanges=Boolean(t&&Object.values(t).some((e=>e)))}return Boolean(e)}getValues(e){const t={};return this.eachWidget(((n,i)=>{n.isolateFields?i.down=!1:!("name"in n)||e&&!e(n)||(t[n.name]=n.value)}),!0),t}get values(){const e={};return this.gatherValue(e),e}set values(e){this.assignValue(e)}get isSettingValues(){return Boolean(this.assigningValues)}get assigningValues(){var e;return this._assigningValues||(null===(e=this.parent)||void 0===e?void 0:e.assigningValues)}set assigningValues(e){this._assigningValues=e}assignValue(e,t){super.assignValue(e,t),this.isolateFields||this.setValues(e,t)}gatherValue(e){super.gatherValue(e),this.isolateFields||this.gatherValues(e)}setValues(e,t=this.assignValueDefaults){const n=this;n.assigningValues=t,n.initialValues={optionsProp:t},n.eachWidget((i=>{const r=i.getValueName(t);!r||e&&!(r in e)||(n.initialValues[r]=(null==e?void 0:e[r])||null),i.assignValue(e,t)}),!1),n.assigningValues=!1}get hasNoChildren(){const e=this,{items:t,lazyItems:n}=e.initialConfig,i=t&&(wd(t)?t:U.values(t)),r=n&&(wd(n)?n:U.values(n)),s=e.isConfiguring?r||i:e.items;return!(null!=s&&s.filter(Ed).length)}afterRecompose(){super.afterRecompose(),this.realign()}updateTextContent(e){const t=this;if(!t.isComposable){const n=Boolean(e&&t.hasNoChildren),{classList:i}=t.contentElement;n!==i.contains("b-text-content")&&(i[n?"add":"remove"]("b-text-content"),t.rendered&&t.realign())}}updateLayoutStyle(e){ki.applyStyle(this.contentElement,e)}updateElement(e,t){if(super.updateElement(e,t),e){const{classList:e}=this.contentElement,{containerCls:t}=this.layout;e.add("b-content-element"),t&&e.add(t)}}onInternalPaint(...e){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...e),this.getConfig("contentElMutationObserver")}changeContentElMutationObserver(e,t){if(t&&(t.takeRecords(),t.disconnect()),e){const t=this,{element:n,contentElement:i}=t;(e=new MutationObserver((e=>t.onContentElMutation(e)))).observe(i,{attributes:!0}),i!==n&&e.observe(n,{attributes:!0}),t.syncFlexDirection()}return e}onContentElMutation(e){Td[this.layout.type]&&!this.textContent&&this.isVisible&&e.some((e=>this.contentElement.contains(e.target)))&&this.syncFlexDirection()}changeLayout(e,t){return md.reconfigure(t,e,{owner:this,defaults:{owner:this}})}get childItems(){return this.items}get childItemsOrderedByRelevance(){return this.items}getWidgetById(e){return this.widgetMap[e]}processWidgetConfig(e){}setupWidgetConfig(e,t){const n=this;"string"==typeof e?e={html:e}:e.nodeType===Element.ELEMENT_NODE&&(e={element:e,id:e.id}),("string"==typeof t||!t&&(t=e.type))&&("checkbox"===t&&d.isMobile&&hd.resolveType("slidetoggle",!0)&&(t=e.type="slidetoggle"),t=hd.resolveType(t,!0));for(let i=(e=(t||hd).mergeConfigs(n.defaults,e,{parent:n})).parent;i;i=i.parent)if(!1===i.processWidgetConfig(e))return null;return!1===n.trigger("beforeWidgetCreate",{widgetConfig:e})?null:e}createWidget(e){const t=hd.create(this.setupWidgetConfig(e),this.defaultType);return t&&(t._createdBy=this),t}updateDefaults(e,t){if(!this.isConfiguring&&e){const n=Object.entries(e);this.eachWidget((e=>{n.forEach((([n,i])=>{t&&e[n]!==t[n]||(e[n]=i)}))}),!1)}}render(...e){this.getConfig("lazyItems"),this.layout.renderChildren(),this.syncChildCount(),super.render(...e)}get focusElement(){const{defaultFocus:e}=this;if("string"==typeof e)return this.element.querySelector(e);let t=e&&this.query(e);return e&&t||(t=this.query(xd,!0)),t?t.focusElement:super.focusElement}doDestroy(){var e;null===(e=this._items)||void 0===e||e.forEach((e=>{var t;return null===(t=e.destroy)||void 0===t?void 0:t.call(e)})),this.layout.destroy(),super.doDestroy()}get isValid(){let e=!0;return this.eachWidget((t=>{"isValid"in t&&t.isVisibleForValidation&&!t.isValid&&(e=!1)}),!0),e}clearError(){this.eachWidget((e=>{var t;return null===(t=e.clearError)||void 0===t?void 0:t.call(e)}))}}Id.initClass(),Id._$name="Container";const{assign:kd}=U,Fd=()=>performance.now(),Ad={start:!1},Pd=/^[.\d]+([^\d].*)?$/,Ld=e=>ki.getExpandos(e,"transitions"),Od=(e,t)=>{var n;"string"==typeof e&&(t=null===(n=Pd.exec(e))||void 0===n?void 0:n[1],e=parseFloat(e));return e&&e*("s"===t||!t&&e<10?1e3:1)},$d=e=>{const t=U.values(Ld(e)).filter((e=>null==e.completed)).map((e=>e.toString()));e.style.transition=t.join(", ")},_d=e=>class extends e{static get prototypeProperties(){return{_delay:null,_duration:null,_retain:null,_timing:null,_unit:null,owner:null,reverting:null}}constructor(...e){super(...e),this.id=++jd}start(){this.startTime=Fd()}get delay(){var e;return Od(this._delay??(null===(e=this.owner)||void 0===e?void 0:e.delay)??0,this.unit)}set delay(e){this._delay=e}get duration(){const{owner:e,unit:t}=this;return Od(this._duration??(e?e.duration:Vd.defaultDuration),t)}set duration(e){this._duration=e}get elapsed(){return Fd()-this.startTime}get remaining(){return this.duration-this.elapsed}get retain(){var e;return this._retain??(null===(e=this.owner)||void 0===e?void 0:e.retain)}set retain(e){this._retain=e}get timing(){var e;return this._timing??(null===(e=this.owner)||void 0===e?void 0:e.timing)}set timing(e){this._timing=e}get unit(){var e;return this._unit??(null===(e=this.owner)||void 0===e?void 0:e.unit)}set unit(e){this._unit=e}};let jd=0;class Bd extends(tt.mixin(_d)){static $name="AnimatorTransition";static get prototypeProperties(){return{element:null,property:null,from:null,to:null,completed:null,promissory:null,reverting:null}}afterConstruct(){super.afterConstruct();const e=this,{element:t,transitions:n}=e;let{property:i}=e;[i,e.to]=ki.unitize(i,e.to),e.from=ki.unitize(i,e.from)[1],e.promissory=new El,e.property=i;const r=n[i];n[i]=e;let{from:s}=e;r&&(e.from=r.to,s=null,r.destroy()),null===s&&(s=e.getCurrentStyleValue(),r||(e.from=s)),t.style[i]=s,e.getCurrentStyleValue()}doDestroy(){const e=this;e.finish(!1),e.completed&&!e.retain&&e.clearStyle(),super.doDestroy()}get promise(){var e;return null===(e=this.promissory)||void 0===e?void 0:e.promise}get transitions(){return Ld(this.element)}clearStyle(){this.setStyle("")}finish(e){const t=this,{transitions:n,promissory:i,property:r}=t;i&&(t.completed=e,t.promissory=null,i.resolve(e),n[r]===t?(delete n[r],e||($d(t.element),t.clearStyle())):t.completed=!1)}getCurrentStyleValue(){return ki.getStyleValue(this.element,this.property)}revert(){const{duration:e,elapsed:t,element:n,from:i,property:r,_retain:s,_timing:o}=this;return new Bd({element:n,property:r,retain:s,timing:o,duration:Math.round(Math.min(e,t)),reverting:this,to:i,unit:"ms"})}setStyle(e){this.element.style[this.property]=e}start(){const e=this,{delay:t,duration:n,element:i,property:r}=e;Mn.onTransitionEnd({element:i,property:r,duration:t+n+20,thisObj:e.owner,handler:()=>{var t;return null===(t=e.finish)||void 0===t?void 0:t.call(e,!0)}}),super.start(),e.setStyle(e.to)}toString(){const{delay:e,duration:t,property:n,timing:i}=this;return`${n} ${t}ms ${i||"ease-in-out"}${e?` ${e}ms`:""}`}}Bd.initClass();class Vd extends(tt.mixin(_d)){static $name="Animator";static get prototypeProperties(){return{element:null,finalize:null,prefinalize:null,completed:null,items:null}}static register(e,t){U.isObject(e)?U.entries(e).forEach((e=>Vd.register(...e))):(Vd.fx[e]=t,Vd[e]=t=>(ki.isElement(t)?t={element:t,[e]:{}}:delete(t={element:t.element,[e]:t})[e].element,Vd.run(t)))}static run(e){return new Vd(e).start()}constructor(e){var t;super(null);const n=this,i=[],r={};let s,o,a,l;if(Array.isArray(e))n.items=e;else for(a in e)(Vd.specialPropsRe.test(a)?n:r)[a]=e[a];U.keys(r).forEach((e=>{l=r[e],null!=l&&!1!==l&&l==l&&((o=Vd.fx[e])?(l=kd(n.defaults,o(l,n,e)),l.owner=n,s=new Vd(l)):(l=kd(n.defaults,"object"==typeof l?l:{to:l}),l.owner=n,l.property=e,s=new Bd(l)),i.push(s))})),null===(t=n.items)||void 0===t||t.forEach((e=>{U.isInstantiated(e)?e.owner=n:((e=kd(n.defaults,e)).owner=n,e=new Vd(e)),i.push(e)})),n.items=i,n.promise=(1===i.length?i[0].promise:Promise.all(i.map((e=>e.promise)))).then((e=>{var t;return null===(t=n.finish)||void 0===t||t.call(n,e),n.completed||!1}))}doDestroy(){this.items.forEach((e=>e.destroy())),super.doDestroy()}get defaults(){return{element:this.element}}get retain(){const{_retain:e,finalize:t,owner:n}=this;return e??(!t&&(!n||n.retain))}set retain(e){super.retain=e}done(){return this.promise}finish(e){var t,n;const i=this,{items:r}=i;for($d(i.element),i.completed="boolean"==typeof e?e:!e.some((e=>!e)),null===(t=i.prefinalize)||void 0===t||t.call(i,i.completed,i);r.length;)r.pop().destroy();null===(n=i.finalize)||void 0===n||n.call(i,i.completed,i)}revert(e){const t=this,{reverting:n}=t,i=!e||(e.start??!0);let r=t.defaults;return n&&(n.finalize&&(r.finalize=n.finalize),n.prefinalize&&(r.prefinalize=n.prefinalize),r.retain=n._retain),r=kd(r,e,{items:t.items.map((e=>e.revert(Ad))),reverting:t}),r=new Vd(r),i&&r.start(),r}start(){const{element:e,items:t}=this;return super.start(),t.length&&($d(e),t.forEach((e=>e.start()))),this}}Vd.initClass().Transition=Bd,Vd.specialPropsRe=new RegExp(`^(?:${Object.keys(Vd.prototypeProperties).concat(Object.keys(Vd.superclass.prototypeProperties)).map((e=>"_"===e[0]?e.substr(1):e)).join("|")})$`),Vd.defaultDuration=200,Vd.fx={},Vd.register({puff:e=>(!0===e?e={}:"object"!=typeof e?e={transform:`scale(${e})`}:e.scale&&((e=U.clone(e)).transform=`scale(${e.scale})`,delete e.scale),kd({opacity:0,transform:"scale(8)"},e))}),Vd._$name="Animator";class Hd extends(tt.mixin(nn)){static get configurable(){return{element:null,delegate:null,delay:500,startRate:2,endRate:20,accelerateDuration:4e3,pressedCls:"b-pressed"}}doDestroy(){var e;null===(e=this.mousedownRemover)||void 0===e||e.call(this),this.cancel(),super.doDestroy()}cancel(){var e,t,n;const i=this;null===(e=i.activeElement)||void 0===e||e.classList.remove(i.pressedCls),i.activeElement=null,null===(t=i.acceleration)||void 0===t||t.cancel(),i.activeListenerRemover=null===(n=i.activeListenerRemover)||void 0===n?void 0:n.call(i),i.clearTimeout(i.autoRepeatTimer),i.clearTimeout(i.repeatTimer)}updateElement(e){var t;null===(t=this.mousedownRemover)||void 0===t||t.call(this),this.mousedownRemover=Mn.on({element:e,mousedown:"onMouseDown",thisObj:this})}onMouseDown(e){const t=this,n=t.delegate?e.target.closest(t.delegate):t.element;t.cancel(),n&&(t.activeElement=n,t.triggerEvent=e,n.classList.add(t.pressedCls),t.activeListenerRemover=Mn.on({mouseup:{element:document,capture:!0,handler:"onMouseUp"},mousemove:{element:n,handler:"onTargetMouseMove"},mouseleave:{element:n,handler:"onTargetMouseLeave"},mouseenter:{element:n,handler:"onTargetMouseEnter"},thisObj:t}),t.autoRepeatTimer=t.setTimeout("startAutoRepeat",t.delay))}onMouseUp(){this.cancel()}onTargetMouseLeave(){this.activeElement.classList.remove(this.pressedCls),this.clearTimeout(this.repeatTimer)}onTargetMouseEnter(e){const t=this;e.buttons?(t.activeElement.classList.add(t.pressedCls),t.triggerEvent=e,t.fireClick()):t.cancel()}onTargetMouseMove(e){this.triggerEvent=e}startAutoRepeat(){const e=this;e.interval=e.startInterval=1e3/e.startRate,e.accelerationDelta=e.startInterval-1e3/e.endRate,e.fireClick(),e.acceleration=te.animate(e.accelerateDuration,e.nextTick,e,"easeOutQuad")}nextTick(e){this.interval=this.startInterval-this.accelerationDelta*e}fireClick(){const e=this,t=new MouseEvent("click",e.triggerEvent);e.triggerEvent.target.dispatchEvent(t),e.repeatTimer=e.setTimeout(e.fireClick,e.interval)}}Hd._$name="ClickRepeater";const zd=/^(?:undefined|null|LEFT|RIGHT)$/,Nd={TOP:"BOTTOM",RIGHT:"LEFT",BOTTOM:"TOP",LEFT:"RIGHT"},Wd=e=>{const t=null==e?void 0:e.toUpperCase();return[t,"LEFT"===t||"RIGHT"===t]};var Ud=e=>class extends(e||tt){static $name="Rotatable";static get configurable(){return{rotate:null,invertRotate:null}}compose(){const{rotate:e}=this;return{class:{[`b-rotate-${(e||"").toLowerCase()}`]:e,"b-rotate-vertical":e}}}syncRotationToDock(e){if(zd.test(String(this.rotate))){const[t,n]=Wd(e);this.rotate=n?this.invertRotate?Nd[t]:t:null}}get widgetClass(){return null}};class Gd extends(hd.mixin(Ud)){static $name="Tool";static type="tool";static configurable={align:{value:null,$config:{merge:"replace"}},href:null,repeat:null,defaultBindProperty:null,role:""};compose(){const{align:e,href:t}=this,n={tag:null!=t?"a":"button",class:{[`b-align-${e||"end"}`]:1,"b-icon":1},listeners:{click:"onInternalClick"}};return t||(n.type="button"),n}get focusElement(){return this.element}get panel(){var e,t;if(null!==(e=this.parent)&&void 0!==e&&e.isPanel&&null!==(t=this.element)&&void 0!==t&&t.parentNode.matches(".b-panel-header"))return this.parent}changeAlign(e){return e}onInternalClick(e){const t=this,{handler:n,panel:i}=t,r={domEvent:e,tool:t};t.disabled||(t.trigger("click",r),t.isDestroyed||(t.trigger("action",r),t.isDestroyed||!1===(null==i?void 0:i.trigger("toolClick",r))||n&&t.callback(n,i,[e,i,t])))}onInternalKeyDown(e){"Enter"===(e.key.trim()||e.code)&&e.stopPropagation()}updateDisabled(e,t){var n;super.updateDisabled(e,t),e&&(null===(n=this.repeat)||void 0===n||n.cancel())}changeRepeat(e,t){return null==t||t.destroy(),e&&Hd.new({element:this.element},e)}changeTooltip(e,t){const n=this,i=(null==e?void 0:e.html)||e;return n.ariaLabel||n.text||"string"!=typeof i||(n.ariaLabel=n.optionalL(i,n)),super.changeTooltip(e,t)}}Gd.initClass(),Gd._$name="Tool";const qd=/right/i,Yd=e=>(e.collapsed||e.collapsing)&&"top"===e.owner.expandedHeaderDock&&e.owner.collapsible.direction.match(qd)?"start":"end";class Kd extends(Gd.mixin(dr)){static $name="CollapseTool";static type="collapsetool";static get configurable(){return{autoAlign:!0,collapsed:null,collapsing:null,collapsify:!1,direction:"up",defaultBindProperty:null}}compose(){const{collapsed:e,direction:t}=this;return{"aria-label":this.L(`L{Object.${e?"expand":"collapse"}}`),class:{[`b-icon-collapse-${t}`]:1,"b-collapsed":e}}}changeAutoAlign(e){return!0===e?Yd:e}syncAutoAlign(){const{autoAlign:e}=this;e&&(this.align=e(this))}updateAutoAlign(){this.syncAutoAlign()}updateCollapsed(){this.syncAutoAlign()}updateCollapsing(){this.syncAutoAlign()}updateDirection(){this.syncAutoAlign()}}Kd.initClass(),Kd._$name="CollapseTool";const Xd=/^(?:UP|DOWN|LEFT|RIGHT)$/,Zd=/^(left|top)$/i,Jd={},Qd=/^b-dock-(top|left|right|bottom)$/,eu="b-panel-collapse-revealer",tu=/^(?:left|right)$/i,nu="b-collapse-unflex",{round:iu}=Math,ru=["up","down","left","right"].reduce(((e,t)=>(e[t.toUpperCase()]=e[t]=t,e)),{}),su={top:["top","bottom"],right:["right","left"],bottom:["bottom","top"],left:["left","right"]},ou={hl:"LEFT",hr:"RIGHT",vb:"DOWN",vt:"UP"},au={h:"w",w:"h"},lu={up:"top",right:"right",down:"bottom",left:"left"},cu={top:!1,right:!0,bottom:!1,left:!0},du={top:"UP",right:"RIGHT",bottom:"DOWN",left:"LEFT"},uu={top:e=>`translate(0, -${iu(e.height||0)}px)`,bottom:e=>`translate(0, ${iu(e.height||0)}px)`,right:e=>`translate(${iu(e.width||0)}px, 0)`,left:e=>`translate(-${iu(e.width||0)}px, 0)`};let hu=0;class gu extends(tt.mixin(Ls,dr)){static $name="PanelCollapser";static type="inline";static get configurable(){return{animation:{duration:200},collapsed:{value:null,$config:null,default:!1},direction:null,collapseTooltip:"L{Object.collapse}",expandTooltip:"L{Object.expand}",panel:{value:null,$config:"nullify"},supportAxis:null,tool:{type:"collapsetool",handler(e){var t;null===(t=this.collapsible)||void 0===t||t.onCollapseClick(e)}}}}static get factoryable(){return{defaultType:"inline"}}get collapsing(){return"collapsing"===this.collapsingExpanding}get collapsingExpanding(){var e;const t=null===(e=this.currentOperation)||void 0===e?void 0:e.collapsing;return null==t?null:t?"collapsing":"expanding"}get currentDock(){var e;return(null===(e=this.panel)||void 0===e||null===(e=e.header)||void 0===e||null===(e=e.dock)||void 0===e?void 0:e.toLowerCase())??"top"}get expanding(){return"expanding"===this.collapsingExpanding}get collapseTool(){var e;return null===(e=this.panel)||void 0===e||null===(e=e.tools)||void 0===e?void 0:e.collapse}get collapseDim(){return tu.test(this.collapseDir)?"width":"height"}getCollapseDir(e){let{direction:t,panel:n}=this;if(!t||Xd.test(t)){const e=null==n?void 0:n.placement;var i;if(e)t=ou[e];else t=du[(null==n||null===(i=n.header)||void 0===i?void 0:i.dock)||"top"]}return e?ru[t]:t}get collapseDir(){return this.getCollapseDir(!0)}get collapseDock(){return this.collapseInfo[0]}get collapseInfo(){const{panel:e}=this,t=e.hasHeader&&e.expandedHeaderDock;let n=lu[this.collapseDir],i=!1;return t&&((i=cu[n]!==cu[t])||(n=t)),[n,i]}get toolsConfig(){const{direction:e,tool:t}=this;return t&&{collapse:U.assign({direction:e.toLowerCase(),tooltip:this.L(this[this.collapsed?"expandTooltip":"collapseTooltip"])},t)}}beforeCollapse(e){const{panel:t}=this,{element:n}=t;n.matches(":focus-within")&&t.revertFocus(!0)}changeTool(e){const t=this,{panel:n}=t;if(t.isConfiguring||t.isDestroying||!n||n.isDestroying)return e;n.tools={collapse:e}}collapse(e){var t;const n=this,{panel:i}=n,r={id:++hu,completed:!1,panel:i};let{currentOperation:s}=n;return e=e??!0,U.isObject(e)&&(r.collapsed=!0,U.assign(r,e),e=r.collapsed,delete r.collapsed),r.collapsing=e,r.previous=s??null,e!==n.collapsed?s?s.collapsing!==e&&(r.animation=s.animation.revert({finalize(){var e;null===(e=n.collapseFinalize)||void 0===e||e.call(n,r,!0)}}),r.collapsing=e,s=r):(r.animation=U.clone(("animation"in r?r:n).animation),!1!==n.beforeCollapse(r)&&(r.animation&&(r.animation.finalize=e=>{var t;return null===(t=n.collapseFinalize)||void 0===t?void 0:t.call(n,r,e)}),i.changingCollapse=!0,n[e?"collapseBegin":"expandBegin"](r),r.animation?s=r:(r.completed=!0,n[e?"collapseEnd":"expandEnd"](r)),i.changingCollapse=!1,r.animation||n.onComplete(e?"collapse":"expand"))):s&&s.collapsing!==e&&(n[e?"expandRevert":"collapseRevert"](r),r.animation=s.animation.revert({finalize(){var e;null===(e=n.collapseFinalize)||void 0===e||e.call(n,r,!1)}}),s=r),n.currentOperation=s,(null===(t=s)||void 0===t||null===(t=t.animation)||void 0===t?void 0:t.done())??Promise.resolve(e===n.collapsed)}collapseFinalize(e,t){const n=this,{currentOperation:i,panel:r}=n,s=r.collapsed?"expand":"collapse";i===e&&(n.currentOperation=null,e.completed=t,r.changingCollapse=!0,n[s+"End"](e),r.changingCollapse=!1,t&&n.onComplete(s))}applyHeaderDock(e,t=!0){const{currentDock:n,panel:i}=this,{header:r}=i,s=e?this.collapseDock:i.expandedHeaderDock;s!==n&&i.hasHeader&&(i.header=r?"string"==typeof r?{title:r}:U.clone(i.header):{},i.header.dock=s,t&&i.recompose.flush())}composeHeader(e){const{panel:t}=this,{class:n}=e,i=t.expandedHeaderDock||Object.keys(n).filter((e=>n[e]&&Qd.test(e))).map((e=>Qd.exec(e)[1][0]));return n[eu]=1,n[`b-collapsible-${i[0]}${this.collapseDir[0]}`]=1,e}composeTitle(e){return e.class[eu]=1,e}collapseBegin(e){var t;const n=this,{animation:i}=e,{collapseDim:r,collapseTool:s,panel:o}=n,{element:a,placement:l}=o,[c,d]=n.collapseInfo,u=null==s?void 0:s.element.classList,h=!l||"h"===l[0]&&"width"===r||"v"===l[0]&&"height"===r;n.configuredWidth=o._lastWidth,n.configuredHeight=o._lastHeight,n.transverseCollapse=d,n.applyHeaderDock(!0);const g=o.rectangle(),m=n.lockInnerSize().moveTo(0,0),p=m.clone(),f=su[c],v=null===(t=o.headerElement)||void 0===t?void 0:t.getBoundingClientRect(),y=iu((null==v?void 0:v[r])||0);a.classList.toggle(nu,h),i?(p[f[0]]=p[f[1]],a.classList.add("b-collapsing"),null==u||u.add("b-collapsed","b-collapsing"),s&&(s.collapsing=!0,s.tooltip=void 0),u&&(u.remove("b-collapsed"),o.rectangle(),u.remove("b-collapsing"),u.add("b-collapsed")),i.element=a,i.retain=!0,i[r]={from:iu(g[r]),to:y},i.items=[{element:n.innerElement,retain:!1,clip:{from:`rect(${m})`,to:`rect(${p})`}}],d&&i.items.push({element:o.headerElement,duration:i.duration,retain:!1,transform:{from:uu[c](v),to:"translate(0, 0)"}}),e.animation=Vd.run(i)):(a.style[r]=`${y}px`,s&&(u.add("b-collapsing","b-collapsed"),s.rectangle(),u.remove("b-collapsing")))}collapseEnd(e){const t=this,{collapseTool:n,expandTooltip:i}=t;t.panel.isDestroyed||(t.panel.element.classList.remove("b-collapsing"),n&&(n.collapsing=!1,n.tooltip=this.L(i)),e.completed?t.collapsed=!0:(t.applyHeaderDock(!1),t.restoreConfiguredSize(),t.lockInnerSize(!1)))}collapseRevert(e){var t;null===(t=this.collapseTool)||void 0===t||t.element.classList.remove("b-collapsed")}expandBegin(e){const t=this,{animation:n}=e,{collapseDim:i,collapseTool:r,panel:s}=t,[o,a]=t.collapseInfo,{element:l}=s,c=l.classList,d=c.contains(nu),u=s.rectangle();c.remove("b-collapsed","b-collapsing"),r&&(r.tooltip=void 0),s.element.style[i]="",t.restoreConfiguredSize(),t.lockInnerSize(!1);const h=s.rectangle(),g=t.lockInnerSize().moveTo(0,0),m=g.clone(),p=su[t.collapseDock];null==r||r.element.classList.remove("b-collapsed"),n&&(m[p[0]]=m[p[1]],c.add("b-collapsed","b-expanding"),d&&c.add(nu),n.element=l,n[i]={from:iu(u[i]),to:iu(h[i])},n.items=[{element:t.innerElement,retain:!1,clip:{from:`rect(${m})`,to:`rect(${g})`}}],a&&n.items.push({element:s.headerElement,duration:n.duration,retain:!1,transform:{from:"translate(0, 0)",to:uu[o](u)}}),e.animation=Vd.run(n))}expandEnd(e){const t=this,{collapseTool:n,collapseTooltip:i}=t;t.panel.element.classList.remove("b-expanding"),e.completed&&(t.collapsed=!1,n&&(n.tooltip=t.L(i)),t.applyHeaderDock(!1),t.restoreConfiguredSize(),t.lockInnerSize(!1))}expandRevert(e){var t;null===(t=this.collapseTool)||void 0===t||t.element.classList.add("b-collapsed")}get innerElement(){return this.panel.collapseWrapElement||this.panel.bodyWrapElement}get innerSizeElement(){return this.transverseCollapse?this.panel.element:this.innerElement}get supportAxis(){let{_supportAxis:e}=this;const t=!0===e;return(t||null==e)&&(e=this.collapseDim[0],(t||"absolute"===ki.getStyleValue(this.panel.element,"position"))&&(e+=au[e])),e||""}lockInnerSize(e=!0){const t=this,{innerElement:n,panel:i}=t,r=e?t.supportAxis:"",s=i.element,o=i.headerElement,a=e&&o&&_t.from(o,s),l=e&&_t.from(t.innerSizeElement,s),c=n.style;return o&&(o.style.minWidth=r.includes("w")?`${a.width}px`:"",o.style.minHeight=r.includes("h")?`${a.height}px`:""),c.width=e?`${l.width}px`:"",c.height=e?`${l.height}px`:"",n.classList[e?"add":"remove"]("b-panel-collapse-size-locker"),l}onCollapseClick(e){let t=!this.collapsing&&(!!this.expanding||!this.collapsed);e.altKey&&(t={animation:null,collapsed:t}),this.collapse(t)}onComplete(e){var t,n;null===(t=this.panel)||void 0===t||null===(n=t.trigger)||void 0===n||n.call(t,e)}onPanelHeaderClick({event:e}){0===e.button&&this.panel.collapsed&&e.target.classList.contains(eu)&&this.onRevealerClick()}onPanelConfigChange({name:e,value:t}){const n=this,{panel:i}=n;"collapsed"===e?i.isPainted&&(n.collapsed=t):"header"!==e||i.changingCollapse||n.syncDirection()}onPanelPaint(){this.syncDirection(),this.panel.collapsed&&!this.collapsed&&this.collapse({animation:null,collapsed:!0})}onRevealerClick(){this.panel._collapse({collapsed:!1})}restoreConfiguredSize(e){const{configuredHeight:t,configuredWidth:n,panel:i}=this;e=e??"wh",i.element.classList.remove(nu),null!=n&&e.includes("w")&&(i.width=n),null!=t&&e.includes("h")&&(i.height=t)}splitHeaderItems({as:e,dock:t}=Jd){var n;return null===(n=this.panel)||void 0===n?void 0:n.splitHeaderItems({as:e,dock:t,alt:!0})}syncDirection(){const e=this,{direction:t}=e;t&&!Xd.test(t)||(e.direction=e.getCollapseDir())}changeCollapsed(e){return Boolean(e)}updateCollapsed(e){const{collapseTool:t,panel:n}=this;n&&(n.collapsed=e,n.element.classList[e?"add":"remove"]("b-collapsed")),t&&(t.collapsed=e)}updateDirection(e){const{collapseTool:t,panel:n}=this;t&&(t.direction=ru[e]),null!=n&&n.rendered&&n.recompose()}updatePanel(e){var t;const n=this;n.syncDirection(),null===(t=n.panelChangeDetacher)||void 0===t||t.call(n),n.panelChangeDetacher=e&&te.after(e,"onConfigChange","onPanelConfigChange",n,{return:!1})}wrapCollapser(e,t){var n;const i=this,[r,s]=i.collapseInfo;if(!s)return[e,t];const{collapseDir:o,panel:a}=i,{expandedHeaderDock:l,header:c,uiClassList:d}=a,u=null===(n=a.tools)||void 0===n?void 0:n.recollapse,[h,g]=i.splitHeaderItems({as:"element",dock:r}),m=a.hasHeader?a.title||(null==c?void 0:c.title)||" ":null,p=m&&{tag:"header",class:new Ht({...d,[`b-dock-${l}`]:1,"b-panel-header":1,"b-panel-collapser-header":1},null==c?void 0:c.cls),style:null==c?void 0:c.style,children:[...h,{reference:"collapserTitleElement",html:m,class:{...d,[`b-align-${(null==c?void 0:c.titleAlign)||"start"}`]:1,"b-header-title":1}},...g]};return u&&(u.direction=o),["collapseWrapElement",{class:{...d,[`b-panel-collapser-header-${l}`]:1,[`b-panel-collapser-${o}`]:1,[`b-${cu[l]?"h":"v"}box`]:1,"b-panel-collapser":1,"b-box-center":1},children:Zd.test(l)?{collapserHeaderElement:p,[e]:t}:{[e]:t,collapserHeaderElement:p}}]}}gu.maps={clipByDock:su,dockByDirection:lu,dockIsHorz:cu},gu.initClass(),gu._$name="PanelCollapser";const mu=Symbol("pendingCreate");class pu extends tt{static get prototypeProperties(){return{cleanup:null,configName:null,created:null,factory:null,inferType:"name",owner:null,ownerName:null,proxyable:"undefined"!=typeof Proxy,setup:null,transform:null}}static get properties(){return{defaults:{},instances:{},object:Object.create({})}}get proxy(){const e=this;let t=null;return e.proxyable&&(t=new Proxy(e.instances,{get:(t,n)=>e.get(n),set:(t,n,i)=>(e.set(n,i),!0),deleteProperty:(t,n)=>(e.set(n,null),!0)})),Reflect.defineProperty(e,"proxy",{configurable:!0,value:t}),t}get target(){return this.proxy||this.object}define(e,t){const n=this,{transform:i}=n,r=i?i(t,e):t,s=U.isInstantiated(r);n.instances[e]=mu,s||n.setDefaults(e,r),n.defineProp(e,!0),s&&n.set(e,r)}defineProp(e,t){const n=this,{object:i}=n;n.proxy||Reflect.defineProperty(t?Object.getPrototypeOf(i):i,e,{configurable:!t,enumerable:!0,get:()=>n.get(e),set:t=>n.set(e,t)})}flush(){const e=this;try{var t;e.updating=!0;for(const t in e.defaults)e.get(t);e.afterConfigureOwner=null===(t=e.afterConfigureOwner)||void 0===t?void 0:t.call(e)}finally{e.updating=!1}}get(e){const{defaults:t,instances:n}=this;return n[e]===mu&&this.set(e,mu),n[e]||t[e]&&null}set(e,t){const n=this,{cleanup:i,configName:r,defaults:s,factory:o,instances:a,owner:l,setup:c,transform:d,updating:u}=n,h=l&&r&&!u,g=a[e]===mu?null:a[e],m=o.reconfigure(g,t===mu?{}:t||null,{cleanup:i&&(t=>i(t,e)),defaults:s[e]||n.setDefaults(e,{}),owner:n.owner,setup:c&&((t,n,i)=>c(t,e,n,i)),transform:d&&(t=>d(t,e))});if(m!==g){const t=h&&{...a};var p;if(a[e]=m,m)n.defineProp(e),null===(p=n.created)||void 0===p||p.call(n,m,e);else delete n.object[e],delete a[e];h&&l.onConfigChange({name:r,config:l.$meta.configs[r],value:n.target,was:t})}}setDefaults(e,t){const{defaults:n,factory:i,inferType:r,instances:s,owner:o,ownerName:a}=this,{typeKey:l}=i.factoryable;return t=!0===t?{}:U.assign({},t),("name"===r||!0===r&&!t[l])&&(t[l]=e),a&&(t[a]=o),t.beforeConfigure=t=>{s[e]=t},n[e]=t}update(e){const t=this,{owner:n}=t;let i,r;try{if(t.updating=!0,e)for(i in e)r=e[i],t.defaults[i]?t.set(i,r):r&&t.define(i,r);else for(i in t.instances)t.set(i,null)}finally{t.updating=!1}n&&(n.isConfiguring?t.afterConfigureOwner||(t.afterConfigureOwner=te.before(n,"afterConfigure","flush",t)):t.flush())}}pu.initClass(),pu._$name="DynamicObject";const fu=[],vu={},yu={align:1,weight:1};var bu=e=>class extends(e||hd){static $name="Toolable";static get configurable(){return{tools:{value:null,$config:{nullify:!0}},toolDefaults:{"*":{type:"tool",align:"end"}}}}byWeightSortFn(e,t){return(e.weight||0)-(t.weight||0)}byWeightReverseSortFn(e,t){return(t.weight||0)-(e.weight||0)}gatherTools({align:e,alt:t,refs:n}=vu){const{collapsed:i,tools:r}=this,s={collapsed:i,alt:t};let o,a,l,c,d,u=[];for(a in r){var h,g;d=r[a],o=(null===(h=d)||void 0===h||null===(h=h.align)||void 0===h?void 0:h.align)??(null===(g=d)||void 0===g?void 0:g.align)??"end",o===e&&d.isCollapsified(s)&&u.push(d)}if(u.sort(this["end"===e?"byWeightReverseSortFn":"byWeightSortFn"]),n){const e="widget"===n,t={};for(l=0;l<u.length;++l)c=u[l],t[c.ref]=e?c:c.element;u=t}return u}getEndTools({alt:e,refs:t}=vu){return this.gatherTools({align:"end",alt:e,refs:t})}getStartTools({alt:e,refs:t}=vu){return this.gatherTools({align:"start",alt:e,refs:t})}get childItems(){return[...this.getStartTools(),...this._items||fu,...this.getEndTools()]}changeTools(e,t){const n=this,i=n.$tools||(n.$tools=new pu({configName:"tools",factory:hd,inferType:!1,owner:n,created(e){var t,r;e.innerItem=!1,null===(t=e.syncRotationToDock)||void 0===t||t.call(e,null===(r=n.header)||void 0===r?void 0:r.dock),te.after(e,"onConfigChange",((e,{name:t})=>{yu[t]&&n.onConfigChange({name:"tools",value:i.target})})),n.onChildAdd(e)},setup:(e,t)=>((e=U.merge({},n.toolDefaults["*"],n.toolDefaults[t],e)).parent=n,e.ref=t,e)}));if(i.update(e),!t)return i.target}get widgetClass(){}};const Cu=["b-hbox","b-vbox"],Su={name:"align",style:"alignItems"},wu={name:"contentAlign",style:"alignContent"},Du={name:"direction",style:"flexDirection"},Eu={name:"justify",style:"justifyContent",classes:["stretch"]},xu={name:"wrap",style:"flexWrap",map:{false:"nowrap",true:"wrap",reverse:"wrap-reverse"}};class Ru extends md{static $name="Box";static type="box";static alias="hbox";static configurable={containerCls:"b-box-container",itemCls:"b-box-item",align:null,contentAlign:null,direction:null,horizontal:!0,justify:null,reverse:null,wrap:null,gap:null};get vertical(){return!1===this.horizontal}set vertical(e){return this.horizontal=!e}updateAlign(){this.syncConfigStyle(Su)}updateContentAlign(){this.syncConfigStyle(wu)}updateDirection(){this.syncConfigStyle(Du)}updateHorizontal(){var e;const t=this,n=null===(e=t.contentElement)||void 0===e?void 0:e.classList,i=Number(t.vertical);n?(n.remove(Cu[1-i]),n.add(Cu[i])):t.syncConfigLater("horizontal"),t.syncDirection()}updateJustify(){this.syncConfigStyle(Eu)}updateReverse(){this.syncDirection()}updateWrap(){this.syncConfigStyle(xu)}syncDirection(){const e=this,{reverse:t}=e;e.direction=t?`${e.vertical?"column":"row"}${t?"-reverse":""}`:null}changeGap(e){return"number"==typeof e&&(e=`${e}px`),e}updateGap(e){this.syncConfigStyle({name:"gap",style:"gap"})}}Ru.initClass(),Ru._$name="Box";class Tu extends Ru{static $name="VBox";static type="vbox";static configurable={horizontal:!1}}Tu.initClass(),Tu._$name="VBox";var Mu=e=>class extends(e||tt){static $name="Badge";static get configurable(){return{badge:null}}compose(){const{badge:e}=this;return{dataset:{badge:e},class:{"b-badge":null!=e&&""!==e}}}};const Iu=/(?:^|\s)b-icon-/,ku=/(?:^|\s)b-fa-/,Fu=["items","type","widgets","html","listeners"],Au=Symbol("defaultListener");class Pu extends(hd.mixin(Mu,Ud)){static $name="Button";static type="button";static get configurable(){return{icon:null,menuIcon:"b-icon-picker",pressedIcon:null,pressedCls:null,iconAlign:"start",behaviorType:"button",text:{value:null,$config:null,default:""},color:null,toggleable:void 0,pressed:!1,toggleGroup:null,supportsPressedClick:!1,supportsUnpressing:!1,ripple:{radius:75},twinForwardEvents:{item:"action"},twinSyncConfigs:null,localizableProperties:["text"],menu:{$config:["lazy","nullify"],value:null},menuDefaults:{type:"menu",autoShow:!1,autoClose:!0,floating:!0,scrollAction:"realign",align:"t0-b0"},href:null,target:null,tabIndex:null,defaultBindProperty:null,split:null,keyMap:{ArrowDown:"onArrowDown"},role:""}}construct(...e){super.construct(...e),this.ion({hide:"onInternalHide"})}get twinSyncConfigs(){const e={onAction:"onItem",onClick:"onItem"};return this.toggleable&&!this.hasConfig("menu")&&(e.pressed="checked"),e}updateElement(e,t){var n,i;const r=this,{constructor:s}=r,o=super.updateElement(e,t),a=r.peekConfig("menu"),l=!!a&&(a.isWidget?a.role:(null===(n=s.resolveType(a.type))||void 0===n||null===(n=n.configurable)||void 0===n?void 0:n.role)||(null===(i=s.configurable.menuDefaults)||void 0===i?void 0:i.type)||"menu");return r.ariaHasPopup=l,o}compose(){const{color:e,href:t,icon:n,iconAlign:i,pressed:r,pressedIcon:s,target:o,text:a,toggleable:l,toggleGroup:c,menuIcon:d,behaviorType:u,tabIndex:h,pressedCls:g,split:m}=this,p=this.hasConfig("menu"),f=r&&s?s:n,v="object"==typeof a;return{tag:t?"a":"button",href:t,target:o,tabIndex:h,type:u,class:{[`b-icon-align-${i}`]:n,[e]:Boolean(e),"b-pressed":r&&l,"b-text":Boolean(a),"b-has-menu":p,"b-splitbutton":m,...r&&g?Object.fromEntries(g.split(" ").map((e=>[e,1]))):{}},[l&&!p?"aria-pressed":""]:r,dataset:{group:c},listeners:{click:"onInternalClick",mousedown:"onInternalMousedown"},children:{iconElement:null!=n&&n.includes("/")?{"aria-hidden":!0,src:n,tag:"img",class:{"b-button-icon":1,"b-button-image":1}}:(n||s)&&{"aria-hidden":!0,tag:"i",class:{...Ht.normalize(f,"object"),"b-button-icon":1,"b-icon":Iu.test(f),"b-fa":ku.test(f)}},label:a&&this.ariaLabel!==a&&{tag:"label",for:this.id,[v?"children":"text"]:v?rt.asArray(a):a,class:{"b-button-custom-content":v}},menuIconElement:p&&d&&{tag:"i",class:{"b-icon":Iu.test(d),"b-fa":ku.test(d),"b-button-menu-icon":1,[d]:1}}}}}onInternalHide(){var e;null===(e=this._menu)||void 0===e||e.hide()}get childItems(){return this._menu&&[this.menu]}onFocusOut(e){var t;super.onFocusOut(e),null===(t=this.menu)||void 0===t||t.hide()}get focusElement(){return this.element}changeText(e){return null==e?"":e}changeToggleable(e){return void 0===e&&(e=Boolean(this.toggleGroup||this.config.menu)),e}changeMenu(e,t){const n=this,{element:i}=n;return e?(e.isWidget?(e.forElement=i,e.owner=n,e.constrainTo=n.rootElement):("object"!=typeof e||Fu.some((t=>t in e))||(e={lazyItems:e}),e=hd.reconfigure(t,e?U.merge({owner:n,constrainTo:n.rootElement,forElement:i},n.menuDefaults,e):null,n)),e.align.constrainPadding=10,n.detachListeners(Au),e.ion({name:Au,beforeShow:"onMenuBeforeShow",hide:"onMenuHide",show:"onMenuShow",thisObj:this})):null==t||t.destroy(),e}onMenuBeforeShow({source:e}){return this.trigger("beforeShowMenu",{menu:e})}onMenuShow(){this.ariaElement.setAttribute("aria-expanded",!0)}onMenuHide(){this.ariaElement.setAttribute("aria-expanded",!1),this.toggle(!1)}updateMenu(e){this.toggleable=Boolean(e)}updatePressed(e){const t=this;t.toggleable&&!t.isConfiguring&&(e&&ki.forEachSelector(t.rootElement,`button[data-group=${t.toggleGroup}]`,(e=>{e!==t.element&&(hd.getById(e.id).pressed=!1)})),t.toggleMenu(!t.split&&e),t.trigger("toggle",{pressed:e,userAction:Boolean(t.triggeredByEvent)}))}configureOverflowTwin(e){const t=this,n=super.configureOverflowTwin(e),{menu:i}=t;return n.type=hd.resolveType("menuitem"),i?n.menu=t.constructor.mergeConfigs(n.menu,{type:"menu",items:i.items.map((e=>e.ensureOverflowTwin()))}):t.toggleable&&(n.checked=t.pressed),n.text||(n.text=t.text||t.tooltipText),n}onInternalMousedown(e){var t;(d.isSafari||null!==(t=this._menu)&&void 0!==t&&t.containsFocus&&this.pressed)&&e.preventDefault()}changeTooltip(e,t){const n=this,i=(null==e?void 0:e.html)||e;return n.ariaLabel||n.text||"string"!=typeof i||(n.ariaLabel=n.optionalL(i,n)),super.changeTooltip(e,t)}onArrowDown(){if(!this.menu)return!1;this.toggleMenu(!0)}onInternalClick(e){const t=this,n={event:e};if(!t.disabled)if(t.split&&e.target.closest(".b-button-menu-icon")){var i;t.toggleMenu(!(null!==(i=t._menu)&&void 0!==i&&i.isVisible))}else{if(t.triggeredByEvent=e,t.toggleable){const e=t.toggleGroup&&t.pressed&&!t.supportsUnpressing;if(e&&!t.supportsPressedClick)return;if(e||t.toggle(!t.pressed),t.isDestroyed)return}t.trigger("click",n),t.isDestroyed||t.trigger("action",n),t.href||(e.preventDefault(),e.stopPropagation()),t.triggeredByEvent=null}}toggle(e=!this.pressed){!1!==this.trigger("beforeToggle",{pressed:e,userAction:Boolean(this.triggeredByEvent)})&&(this.pressed=e)}toggleMenu(e){if(e){const{menu:e}=this;e&&(e.owner=this,e.forElement=this.element,e.initialConfig.minWidth||(e.minWidth=this.width),e.align.minHeight=e._minHeight??100,e.align.minWidth=e._minWidth??100,e.show())}else{var t;null===(t=this._menu)||void 0===t||t.hide()}}}Pu.initClass(),Pu._$name="Button";const Lu={refs:"element"},Ou=e=>e.element.style.margin="",$u=e=>e.isToolbar,_u=e=>e[0]+(e[1].minifiable?0:9e9),ju={hidden:!1,width:""},Bu={...ju,flex:""},Vu={flex:1,hidden:1,maxWidth:1,minWidth:1,width:1,disabled:1},Hu=[{box:"hbox",clientSizeProp:"clientWidth",edgeProp:"right",flexDir:"row",horizontal:!0,max:"maxX",overflow:"overflowX",pos:"x",scrollSize:"scrollWidth",sizeProp:"width"},{box:"vbox",clientSizeProp:"clientHeight",edgeProp:"bottom",flexDir:"column",horizontal:!1,max:"maxY",overflow:"overflowY",pos:"y",scrollSize:"scrollHeight",sizeProp:"height"}],zu={delay:0,startRate:40,endRate:200,accelerateDuration:500},Nu={menu:1,pressed:1};class Wu extends(Id.mixin(bu)){static $name="Toolbar";static type="toolbar";static delayable={syncOverflowVisibility:{type:"raf",cancelOutstanding:!0}};static configurable={role:"toolbar",defaultType:"button",dock:"top",layout:{type:"box"},enableReordering:null,overflow:{$config:["lazy","nullify"],value:{type:"menu"}},toolDefaults:{overflowMenuButton:{type:"button",hidden:!0,icon:"b-icon-menu",menuIcon:null,ariaLabel:"L{Toolbar.showOverflowingItems}",defaultCls:{"b-overflow-button":1}},overflowScrollEnd:{handler:"up.onEndScrollClick",hidden:!0,ariaLabel:"L{Toolbar.scrollForMore}",defaultCls:{"b-icon-angle-right":1,"b-overflow-button":1,"b-icon":1}},overflowScrollStart:{align:"start",handler:"up.onStartScrollClick",hidden:!0,ariaLabel:"L{Toolbar.scrollForMore}",defaultCls:{"b-icon-angle-left":1,"b-overflow-button":1,"b-icon":1}}},widgetCls:null,ignoreParentReadOnly:!0};static prototypeProperties={flexRowCls:"b-hbox",flexColCls:"b-vbox"};static getEvictionList(e){const t=e.filter((e=>"none"!==e.overflowable));return t.forEach(((e,n)=>t[n]=[n,e])),t.sort(((e,t)=>_u(t)-_u(e))),t}updateEnableReordering(e){const t=this;var n;e?t.dragHelper=new rc({name:"itemReorder",mode:"container",lockY:!0,dragThreshold:10,targetSelector:".b-widget",floatRootOwner:t,rtlSource:t,outerElement:t.contentElement,containers:[t.contentElement],internalListeners:{beforeDragStart:t.onBeforeDragStart,dragstart:t.onDragStart,itemMove:t.onItemMove,drop:t.onDrop,thisObj:t}}):null===(n=t.dragHelper)||void 0===n||n.destroy()}compose(){const e=this,{axisProps:t,dock:n}=e,i=e.getEndTools(Lu),r=e.getStartTools(Lu);return{class:{[`b-dock-${n}`]:1,[`b-${n}-toolbar`]:1,[`b-${t.box}`]:1},children:{...r,toolbarContent:{class:{"b-box-center":1,"b-toolbar-content":1}},...i}}}get axisProps(){return Hu[this.layout.horizontal?0:1]}get contentElement(){return this.toolbarContent}get overflowMenuButton(){var e;return null===(e=this.tools)||void 0===e?void 0:e.overflowMenuButton}get overflowType(){const{overflow:e}=this;return"string"==typeof e?e:null==e?void 0:e.type}onChildAdd(e){var t;super.onChildAdd(e),this.processAddedLeafItem(e),null===(t=e.syncRotationToDock)||void 0===t||t.call(e,this.dock)}onChildRemove(e){super.onChildRemove(e),this.syncOverflowVisibility()}processAddedLeafItem(e){te.after(e,"onConfigChange",this.onLeafItemConfigChange,e),e.isContainer&&e.eachWidget((e=>this.processAddedLeafItem(e)))}onInternalPaint({firstPaint:e}){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...arguments),e&&this.getConfig("overflow")}updateDock(e){const t=this,{layout:n}=t,{vertical:i}=n;if(n.vertical=Wd(e)[1],!t.initialItems){i!==n.vertical&&t.updateOverflow(t.overflow);for(const n of t.childItems){var r;null===(r=n.syncRotationToDock)||void 0===r||r.call(n,e)}}}updateOverflow(e,t){var n;const i=this,{axisProps:r,contentElement:s,overflowType:o}=i,{flexDir:a}=r,l=null===(n=i.overflowMenuButton)||void 0===n?void 0:n._menu,c={};var d;if(l&&(e?null==l||l.removeAll():l.eachWidget((e=>{e._overflowTwinOrigin.overflowTwin=null}))),"menu"===t?c.overflowMenuButton=null:"scroll"===t&&(c.overflowScrollStart=c.overflowScrollEnd=null),"menu"===o)null===(d=i.scrollable)||void 0===d||d.destroy(),s.style.overflow=s.style.overflowX=s.style.overflowY="",c.overflowMenuButton={cls:{[`b-${a}-menu`]:1}};else if("scroll"===o){const t="object"==typeof e&&(null==e?void 0:e.repeat)||zu;i.scrollable={[r.overflow]:"hidden-scroll",element:s,internalListeners:{scroll:"onContentScroll",thisObj:i}},c.overflowScrollStart={repeat:t,invertRotate:!0,cls:{[`b-${a}-start-scroller`]:1}},c.overflowScrollEnd={repeat:t,invertRotate:!0,cls:{[`b-${a}-end-scroller`]:1}}}i.tools=c,o?(s.classList.add("b-overflow"),i.monitorResize=!0,i.syncOverflowVisibility()):(s.classList.remove("b-overflow"),i.monitorResize=!1)}onContentScroll(){this.syncScrollerState()}onStartScrollClick(){this.scrollable[this.axisProps.pos]-=2}onEndScrollClick(){this.scrollable[this.axisProps.pos]+=2}onInternalResize(...e){super.onInternalResize(...e),this.isPainted&&this.syncOverflowVisibility()}syncOverflowVisibility(){const e=this,{overflowType:t,contentElement:n,isVisible:i}=e,{clientSizeProp:r,edgeProp:s,sizeProp:o}=e.axisProps,{overflowMenuButton:a,overflowScrollStart:l,overflowScrollEnd:c}=e.tools,d=e.rtl&&e.layout.horizontal,u="menu"===t,h=()=>Math.ceil(n[r]+(!l||l.hidden?0:l.rectangle("outer")[o])+(!c||c.hidden?0:c.rectangle("outer")[o])),g=()=>{if(0===x.length)return 0;const e=x[x.length-1].rectangle(n);return Math.floor(d?n[r]-e.left:e[s])};let m,p,f,v,y,b,C,S,w,D,E,x;if(i&&t&&0!==e.items.length){if(e.inSyncOverflowVisibility=!0,null==a||a.hide(),e.eachWidget(((e,t)=>{C=e.minifiable,D=e.overflowable,D=C?D||C:D,e.floating?t.down=!1:(t.down=!D,e.innerItem&&(e._toolbarOverflow&&(e.hidden=e._toolbarOverflow=!1),e._toolbarMinified&&(e.minified=e._toolbarMinified=!1),e.isVisible&&(C&&(S||(S=[])).push(e),D&&(x||(x=[])).push(e))))})),x&&(m=h(),p=g()),x&&p>m)if(u){for(;p>m&&(y=null===(R=S)||void 0===R?void 0:R.pop());){var R;b=p,y._toolbarMinified=!0,y.minified=!0,p=g(),b-=p,(w||(w=[])).push([y,b])}if(p>m){for(f of(a.show(),m=h(),v=Wu.getEvictionList(x),v))p>m&&(y=f[1],y._toolbarOverflowWidth=y.width,y._toolbarOverflow=!0,y.hidden=!0,x.splice(x.indexOf(y),1),(E||(E=[])).push(f),p=g());if(E){for(E.sort(((e,t)=>e[0]-t[0])).forEach(((e,t)=>E[t]=e[1]));null!==(T=w)&&void 0!==T&&T.length;){var T;[y,b]=w.pop(),p+b<=m&&!y._toolbarOverflow&&(p+=b,y.minified=y._toolbarMinified=!1)}e.syncOverflowMenuButton(E)}else a.hide()}}else c.show(),l.show(),e.syncScrollerState();else u||(null==c||c.hide(),null==l||l.hide());e.inSyncOverflowVisibility=!1}}syncOverflowMenuButton(e){var t;const n=this,{axisProps:i,overflowMenuButton:r}=n,s={cls:"b-toolbar-overflow-menu",minWidth:280,items:[],align:{align:i.horizontal?"t100-b100":"r100-l100",axisLock:"flexible"}};for(const t of e)n.overflowItemFilter(t)&&t.addToOverflowMenu(s,n.horizontal?Bu:ju,Ou);if(s.items.forEach((e=>{let t=e._overflowTwinOrigin,i=t.parent.indexOfChild(t);t.parent!==n&&(i=n.indexOfChild(t.parent)+i/1e5),e.weight=i})),null!==(t=r._menu)&&void 0!==t&&t.isMenu){const e=r.menu,{toAdd:t,toRemove:n}=rt.delta(s.items,e.items,!0);e.remove(n),e.add(t)}else r.menu=s}syncScrollerState(){const{axisProps:e,scrollable:t}=this,{overflowScrollStart:n,overflowScrollEnd:i}=this.tools,r=t[e.pos],s=t[e.max];n.disabled=!r,i.disabled=Math.abs(Math.ceil(r))>=Math.abs(s)}overflowItemFilter(e){const{filter:t}=this.overflow;return Boolean(t?t.call(this,e):ki.getChildElementCount(e.element))}onLeafItemConfigChange(e,{name:t,value:n}){const i=this,r=i.up($u),s=r.hasConfig("overflow"),{overflowTwin:o}=i;!s||null!=r&&r.inSyncOverflowVisibility||"hidden"===t&&n===i._toolbarOverflow||!Vu[t]&&(null!=i._width&&!i.monitorResize||i._flex&&!String(i._flex).endsWith("auto"))||(o&&!Nu[t]&&(o[t]=n),null!=r&&r.isPainted&&"overflowMenuButton"!==i.ref&&((i.isTextField||i.isSlider||i.isCheckbox)&&"value"===t&&(i.containsFocus||null!=o&&o.containsFocus)||r.syncOverflowVisibility()))}createWidget(e){"->"===e?e={type:"widget",cls:"b-toolbar-fill"}:"|"===e?e={type:"widget",cls:"b-toolbar-separator"}:"string"==typeof e&&(e={type:"widget",cls:"b-toolbar-text",html:e});const t=super.createWidget(e);return this.widgetCls&&t.element.classList.add(this.widgetCls),t}onBeforeDragStart({context:e,event:t}){const n=e.item=this.items[e.element.dataset.itemIndex];return e.oldIndex=Number.parseInt(n.element.dataset.itemIndex,10),this.trigger("beforeItemDragStart",{item:n,domEvent:t})}onDragStart({context:e,event:t}){const{item:n}=e;e.dragProxy.style.backgroundColor=globalThis.getComputedStyle(this.element).backgroundColor,this.trigger("itemDragStart",{item:n,domEvent:t})}onItemMove({context:e,event:t}){const{item:n}=e,i=Array.from(n.element.parentElement.children).indexOf(n.element);this.insert(n,i),this.trigger("itemDragMove",{item:n,domEvent:t})}onDrop({context:e,event:t}){const{item:n,valid:i}=e;this.trigger("itemDrop",{item:n,domEvent:t,valid:i})}doDestroy(){var e;null===(e=this.dragHelper)||void 0===e||e.destroy(),super.doDestroy()}}Wu.initClass(),Wu._$name="Toolbar";const Uu=e=>e.classList.contains("b-focus-trap")||e.classList.contains("b-hidden")||!ki.getFocusability(e).focusable?ki.NodeFilter.FILTER_SKIP:ki.NodeFilter.FILTER_ACCEPT,Gu=[],qu={},Yu=[Gu,Gu],Ku=(e,t,n)=>{const{vertical:i}=e;return delete e.vertical,{...e,class:{...t,[`b-${i?"v":"h"}box`]:1,"b-box-center":1,"b-panel-bar-wrap":!n}}},Xu=(e,t,n=!1)=>{const i={vertical:n,children:e?[e]:[]};return t&&(i.tag=t),i},Zu=(e,t)=>{null!=e&&e.classList?null==e||e.classList.add(t):null!=e&&e.class&&("string"==typeof e.class&&(e.class={[e.class]:1}),e.class[t]=1)},Ju={dock:1,hidden:1,weight:1},Qu={top:[!0,!0],bottom:[!0,!1],left:[!1,!0],right:[!1,!1]},eh={header:1,"pre-header":1},th={top:"up",right:"right",bottom:"down",left:"left"};class nh extends(Id.mixin(ws,bu)){static $name="Panel";static type="panel";static get configurable(){return{localizableProperties:["title"],collapsed:{value:null,$config:null,default:!1},collapsible:{value:null,$config:"nullify"},bodyCls:{$config:{merge:"classList"},value:null},bodyTag:null,bodyWrapTag:null,trapFocus:null,title:null,header:null,stateful:["collapsed"],stripDefaults:{"*":{type:"toolbar",dock:"top"},bbar:{dock:"bottom",weight:-1e3},tbar:{weight:-1e3}},strips:{value:null,$config:"nullify"},toolDefaults:{close:{weight:-1e3},collapse:{weight:-990}},footer:null,revealed:null,tbar:null,bbar:null,role:null,drawer:{$config:"lazy",value:null}}}get bodyWrapRootElement(){return this[this._bodyWrapRootName]}changeFooter(e){return e&&("start"===e.dock?e.dock="left":"end"===e.dock&&(e.dock="right")),e}compose(){var e;const t=this,{collapsible:n,focusable:i,revealed:r,tools:s,role:o,floating:a}=t,l=t.composeHeader(),c=t.getPositionableItems("after",!0),d=t.getPositionableItems("before",!0),u=(null==l?void 0:l.class["b-dock-left"])||(null==l?void 0:l.class["b-dock-right"]),h=null==l||null===(e=l.children)||void 0===e||null===(e=e[0])||void 0===e?void 0:e.id;let g=t.composeBody(),m="bodyWrapElement";n&&([m,g]=n.wrapCollapser(m,g)),t._bodyWrapRootName=m;const p={role:o&&"element"===t._ariaElement?o:a?"dialog":"region",tabIndex:(a||t.peekConfig("positioned"))&&!1!==i?-1:i?0:null,class:{[`b-panel-collapsible-${null==n?void 0:n.type}`]:n,[`b-panel-collapse-${null==n?void 0:n.collapseDir}`]:n,[`b-${u?"h":"v"}box`]:1,"b-panel-collapsible":n,"b-panel-has-header":l,"b-panel-has-tools":s?1:0,"b-panel-overlay-revealed":r},children:{topFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-top-focus-trap":1}},...d,headerElement:l,[m]:g,...c,bottomFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-end-focus-trap":1}}}};return h&&(p["aria-labelledby"]=h),p}updateElement(...e){this.getConfig("drawer"),super.updateElement(...e)}updateDrawer(e){var t;let{side:n="end",inline:i}=e;const r=this,{element:s,rtl:o}=r,a=r.getRenderContext()[0]||(i?document.body:null),l=r.parent||a&&!i?"positioned":"floating";n="start"===n?o?"right":"left":"end"===n?o?"left":"right":n,r.updateConfiguration({forElement:null,closable:!1,align:null,autoShow:!1,monitorResize:!1,centered:!1,anchor:!1,hidden:!1,draggable:!1,appendTo:a||(null===(t=r.owner)||void 0===t?void 0:t.floatRoot)||r.floatRoot,hideMode:"collapse",trapFocus:!0,[l]:!i,collapsed:"object"!=typeof e||!("collapsed"in e)||e.collapsed,collapsible:{...e,type:i?"inline":"overlay",direction:th[n||"end"]}}),s.classList.add("b-drawer-panel"),s.classList.remove("b-popup"),s.style.setProperty("--b-drawer-size",ki.setLength(null==e?void 0:e.size)),r.ion({thisObj:r,reveal:()=>r.trigger("show"),unreveal:()=>r.trigger("hide")})}get isVisible(){return this.drawer?!this.collapsible.collapsed||this.revealed:super.isVisible}hide(...e){const t=this;if(!t.drawer)return super.hide(...e);if(!1!==t.trigger("beforeHide")){const e="inline"===t.collapsible.type?t.collapse():t.collapsible.toggleReveal(!1);return t.trigger("hide"),e}}show(...e){const t=this;if(!t.drawer)return super.show(...e);if(!1!==t.trigger("beforeShow")){const e="inline"===t.collapsible.type?t.expand():t.collapsible.toggleReveal(!0);return t.afterShow(),t.focus(),e}}showBy(...e){return this.drawer?this.show():super.showBy(...e)}composeBody(){var e,t;const n=this,{bodyCls:i,bodyConfig:r,bodyWrapTag:s,footer:o,uiClassList:a}=n,l=U.values(n.strips,((e,t)=>!Qu[null==t?void 0:t.dock])).sort(n.byWeightSortFn),c={top:null,right:null,bottom:null,left:null};let d,u,h,g,m,p,f;for(o&&(h=o.dock||"bottom",l.unshift({dock:h,element:{tag:"footer",reference:"footerElement",html:"string"==typeof o?o:o.html,class:{...a,[`b-dock-${h}`]:1,[`${o.cls||""}`]:1}}})),i&&(r[m="className"]||(m="class"),r[m]=new Ht(r[m]).assign(i)),g=l.length;g-- >0;)d=l[g],[p,u]=Qu[d.dock],f?f.vertical!==p&&(f=Xu(Ku(f,a),"",p)):f=Xu(r,s,p),f.children[u?"unshift":"push"](d.element),c[d.dock]=d;Zu(c.top,"b-innermost"),Zu(c.right,"b-innermost"),Zu(c.bottom,"b-innermost"),Zu(c.left,"b-innermost");const v=Ku(f||Xu(r,s),a,!0);return v.class[`${null===(e=n.layout)||void 0===e?void 0:e.containerCls}-panel`]=Boolean(null===(t=n.layout)||void 0===t?void 0:t.containerCls),v.class["b-panel-body-wrap"]=1,v.class[`b-${n.$$name.toLowerCase()}-body-wrap`]=1,v}get hasHeader(){if(!1===this.header)return!1;const{header:e,title:t,tools:n,parent:i}=this,r=this.maximizable||Object.values(n||{}).some((e=>!e.hidden));return e||!(null!=i&&i.suppressChildHeaders)&&(t||r)}get rootUiClass(){return nh}changeHeader(e){return"string"==typeof e?{title:e}:e}composeHeader(e){var t;const n=this;if(!n.hasHeader&&!e)return;const i=n.header||{},r=i.dock||"top",[s,o]=n.splitHeaderItems({as:"element",dock:r}),a=n.$meta.hierarchy,l=n.composeTitle(i),c=new Ht({[`b-dock-${r}`]:1,...n.uiClassList},i.cls);let d,u;for(d=a.indexOf(nh);d<a.length;++d)u=a[d].$$name,"Grid"!==u&&(c[`b-${u.toLowerCase()}-header`]=1);const h={...i,tag:"header",class:c,children:[...s,l,...o]};return(null===(t=n.collapsible)||void 0===t?void 0:t.composeHeader(h))||h}composeTitle(e){var t;const n=this.title||e.title,i={reference:"titleElement",id:`${this.id}-panel-title`,"aria-live":"polite",class:{[`b-align-${e.titleAlign||"start"}`]:1,"b-header-title":1,...this.uiClassList}};if(n)if(U.isObject(n))U.merge(i,n);else{const{iconCls:t}=e;t?i.children=[{tag:"i",class:"b-panel-title-icon "+t},n]:i.html=n}return(null===(t=this.collapsible)||void 0===t?void 0:t.composeTitle(i))||i}updateTitle(){}afterRecompose(){var e;super.afterRecompose();const t=this,{headerElement:n}=t;null===(e=t._headerClickDetacher)||void 0===e||e.call(t),t._headerClickDetacher=n&&Mn.on({element:n,click:e=>{var n;return null===(n=t.trigger)||void 0===n?void 0:n.call(t,"panelHeaderClick",{event:e})}})}onPanelHeaderClick(e){var t;null===(t=this.collapsible)||void 0===t||t.onPanelHeaderClick(e)}onInternalPaint(...e){var t;super.onInternalPaint(...e),null===(t=this.collapsible)||void 0===t||t.onPanelPaint(this)}splitHeaderItems({as:e,dock:t,alt:n}=qu){const i=this,r="element"===e,{collapsed:s}=i,o=i.getEndTools({alt:n}),a=i.getStartTools({alt:n}),l=U.values(i.strips,((e,t)=>!eh[null==t?void 0:t.dock]&&t.isCollapsified({collapsed:s,alt:n})));let c,d,u,h=Yu;if(l.length+o.length+a.length){for(h=[d=[...a,...l.filter((e=>"pre-header"===e.dock)).sort(i.byWeightSortFn)],c=[...l.filter((e=>"header"===e.dock)).sort(i.byWeightReverseSortFn),...o]],u=0;u<d.length;++u){var g,m;t&&(null===(g=(m=d[u]).syncRotationToDock)||void 0===g||g.call(m,t)),r&&(d[u]=d[u].element)}for(u=0;u<c.length;++u){var p,f;t&&(null===(p=(f=c[u]).syncRotationToDock)||void 0===p||p.call(f,t)),r&&(c[u]=c[u].element)}}return h}set bodyConfig(e){this._bodyConfig=e}get bodyConfig(){const e=this,{bodyTag:t}=e,n=U.merge({reference:"bodyElement",className:{...e.getStaticWidgetClasses(nh,"-content"),"b-box-center":1,"b-text-content":e.textContent&&e.hasNoChildren}},e._bodyConfig);return t&&(n.tag=t),n}changeBodyCls(e){return Ht.from(e)}changeTbar(e){return this.getConfig("strips"),this.strips={tbar:e},this.strips.tbar}changeBbar(e){return this.getConfig("strips"),this.strips={bbar:e},this.strips.bbar}get childItems(){var e;const t=this,n=U.values(t.strips,((e,t)=>!Qu[null==t?void 0:t.dock])).sort(t.byWeightSortFn),[i,r]=t.splitHeaderItems(),[s,o]=(null===(e=t.collapsible)||void 0===e?void 0:e.splitHeaderItems())||Yu;return[...i,...s,...r,...o,...n.filter((e=>Qu[e.dock][1])),...t.items,...n.filter((e=>!Qu[e.dock][1])).reverse()]}get childItemsOrderedByRelevance(){var e;const t=this,n=U.values(t.strips,((e,t)=>!Qu[null==t?void 0:t.dock])).sort(t.byWeightSortFn),[i,r]=t.splitHeaderItems(),[s,o]=(null===(e=t.collapsible)||void 0===e?void 0:e.splitHeaderItems())||Yu;return[...t.items,...n.filter((e=>!Qu[e.dock][1])).reverse(),...i,...s,...r,...o,...n.filter((e=>Qu[e.dock][1]))]}changeStrips(e,t){const n=this,i=n.$strips||(n.$strips=new pu({configName:"strips",factory:hd,inferType:!1,owner:n,created(e){var t;const{dock:r}=e;if(!eh[r]&&!Qu[r])throw new Error(`Invalid dock value "${r}"; must be: top, left, right, bottom, header, or pre-header`);te.after(e,"onConfigChange",((e,{name:t})=>{Ju[t]&&n.onConfigChange({name:"strips",value:i.target})})),e.innerItem=!1,n.onChildAdd(e),e.parent=n,null===(t=e.layout)||void 0===t||t.renderChildren(),e.hasItems&&(n.hasItems=!0)},setup:(e,t)=>((e=U.merge(U.clone(n.stripDefaults["*"]),n.stripDefaults[t],e)).parent=n,e.ref=t,e),transform:e=>(Array.isArray(e)&&(e={items:e}),e||null)}));if(i.update(e),!t)return i.target}get collapsing(){var e;return null===(e=this.collapsible)||void 0===e?void 0:e.collapsing}get collapsingExpanding(){var e;return null===(e=this.collapsible)||void 0===e?void 0:e.collapsingExpanding}get expanding(){var e;return null===(e=this.collapsible)||void 0===e?void 0:e.expanding}changeCollapsed(e){const t=this,{collapsible:n}=t;if(t.recompose.flush(),e=Boolean(e),!n||t.changingCollapse||!t.isPainted)return e;null==n||n.collapse({animation:null,collapsed:e})}changeCollapsible(e,t){const n=this;return n.getConfig("tools"),e&&(!0===e?e={}:"string"==typeof e&&(e={[Qu[e]?"direction":"type"]:e})),gu.reconfigure(t,e,{owner:n,defaults:{panel:n},cleanup(){n.collapsed&&!e&&(t.collapse({animation:null,collapsed:!1}),n._collapsed=1)}})}updateCollapsible(e){const t=this,n=null==e?void 0:e.toolsConfig;t.tools={collapse:(null==n?void 0:n.collapse)||null,recollapse:(null==n?void 0:n.recollapse)||null},e&&t.isPainted&&t.collapsed&&(t._collapsed=1),1===t.collapsed&&(t.collapsed=!0)}_collapse(e,t){var n;return!0!==t&&void 0!==t&&(!1===t?e.collapsed=!e.collapsed:"number"==typeof t?e.animation={duration:t}:null===t?e.animation=t:!0===t||("animation"in t?U.merge(e,t):e.animation=t)),null===(n=this.collapsible)||void 0===n?void 0:n.collapse(e)}collapse(e){return this.collapsePanel(e)}expand(e){return this.expandPanel(e)}collapsePanel(e){return this._collapse({collapsed:!0},e)}expandPanel(e){return this._collapse({collapsed:!1},e)}toggleCollapsed(e,t){return"boolean"==typeof e?e?this.collapse(t):this.expand(t):this.collapsed?this.expand(t):this.collapse(t)}get expandedHeaderDock(){var e;return this._expandedHeaderDock??(null===(e=this.initialConfig.header)||void 0===e?void 0:e.dock)??"top"}set expandedHeaderDock(e){this._expandedHeaderDock=null==e?void 0:e.toLowerCase()}updateHeader(e){this.changingCollapse||(this.expandedHeaderDock=null==e?void 0:e.dock)}updateTrapFocus(e){var t;const n=this,{element:i}=n,{classList:r}=i,s="before"===e,o="after"===e;r.toggle("b-focus-trapped",e&&!s&&!o),r.toggle("b-focus-trapped-before",s),r.toggle("b-focus-trapped-after",o),n.focusTrapListener=null===(t=n.focusTrapListener)||void 0===t?void 0:t.call(n),n[e?"addKeyBinding":"removeKeyBinding"]("shift+Tab","trapTabOut"),e&&(n.focusTrapListener=Mn.on({element:i,focusin:"onFocusTrapped",delegate:".b-focus-trap",thisObj:n}),n.treeWalker||(n.treeWalker=n.setupTreeWalker(i,ki.NodeFilter.SHOW_ELEMENT,Uu)))}setupTreeWalker(e,t,n){return document.createTreeWalker(e,t,n)}trapTabOut(e){if(e.target!==this.element)return!1;e.preventDefault(),this.bottomFocusTrap.focus()}onFocusTrapped(e){const t=this,{target:n}=e,i=t.treeWalker,r=n===t.bottomFocusTrap,s=n===t.topFocusTrap;!1!==t.trigger("focusTrap",{target:n,bottom:r,top:s})&&(s||r)&&(r||e.relatedTarget===t.element&&e.shiftKey?(i.currentNode=t.topFocusTrap,i.nextNode()):(i.currentNode=t.bottomFocusTrap,i.previousNode()),t.requestAnimationFrame((()=>i.currentNode.focus())))}get focusElement(){return this.hasItems&&(super.focusElement||this.element)}get contentElement(){return this.element&&this.bodyElement}getPositionableLocation(e){let t,n;return"before"===e?n=this.headerElement||this.bodyWrapRootElement:"after"===e?n=this.bottomFocusTrap:t=this.contentElement,[t,n]}get widgetClassList(){const e=this,t=super.widgetClassList;var n;e.hasHeader&&t.push("b-panel-has-header",`b-header-dock-${(null===(n=e.header)||void 0===n?void 0:n.dock)||"top"}`);return e.tbar&&t.push("b-panel-has-top-toolbar"),e.bbar&&t.push("b-panel-has-bottom-toolbar"),t}}nh.initClass(),nh._$name="Panel";const ih={topStart:"top-start",topEnd:"top-end",bottomEnd:"bottom-end",bottomStart:"bottom-start",top:"top",end:"end",bottom:"bottom",start:"start"};class rh extends(tt.mixin(dt)){static configurable={element:null,minWidth:50,maxWidth:null,minHeight:50,maxHeight:null,rtl:null,handles:{topStart:!0,top:!0,topEnd:!0,end:!0,bottomEnd:!0,bottom:!0,bottomStart:!0,start:!0}};construct(e){if(super.construct(e),!this.element)throw new Error("ElementResizeHelper: `element` is required.")}updateElement(e){var t;"static"===globalThis.getComputedStyle(e).position&&console.warn("ElementResizeHelper: `element` must be positioned (absolute or relative) for resizing to work."),null===(t=this.pointerDownListeners)||void 0===t||t.call(this),this.pointerDownListeners=Mn.on({element:e,pointerdown:"onResizePointerDown",delegate:".b-resize-grip",thisObj:this})}updateHandles(e){const{element:t}=this;ki.removeEachSelector(t,".b-resize-grip");for(const n in e)if(!1!==e[n]){const e=document.createElement("div");e.className=`b-resize-grip b-resize-grip-${ih[n]}`,t.appendChild(e)}}onResizePointerDown(e){var t;const n=this,{element:i}=n;if(n.handleType=e.target.className.replace("b-resize-grip b-resize-grip-","").trim(),0!==e.button||!1===n.trigger("beforeResizeStart",{element:i,handle:n.handleType}))return;e.preventDefault();const r=globalThis.getComputedStyle(i),s=i.getBoundingClientRect(),o=parseFloat(r.top)||0,a=parseFloat(r.insetInlineStart)||0;n.initialX=e.clientX,n.initialY=e.clientY,n.initialTop=o,n.initialStart=a,n.initialWidth=s.width,n.initialHeight=s.height,n.trigger("resizeStart",{element:i,handle:n.handleType}),null===(t=n.removeMoveListeners)||void 0===t||t.call(n),n.removeMoveListeners=Mn.on({element:document.body,pointermove:"onResizePointerMove",thisObj:n}),n.removeDocUpListeners=Mn.on({element:document,pointerup:"onResizePointerUp",capture:!0,thisObj:n,once:!0})}onResizePointerMove(e){const{element:t,handleType:n,rtl:i,minHeight:r,minWidth:s,initialStart:o,initialTop:a,initialWidth:l,initialHeight:c,initialX:d,initialY:u,maxWidth:h,maxHeight:g}=this,m=e.clientX-d,p=e.clientY-u,f=l-(s||1),v=i?-1:1,{shiftKey:y}=e;let b=o,C=a,S=l,w=c;if(n.includes("start")?(b=o+Math.min(m,f)*v,S=l-m*v):n.includes("end")&&(S=l+m*v),n.includes("top")?(C=a+Math.min(p,c-(r||1)),w=c-p):n.includes("bottom")&&(w=c+p),y){const e=l/c;Math.abs(m)>Math.abs(p)?w=S/e:S=w*e}null!==s&&(S=Math.max(S,s)),null!==h&&(S=Math.min(S,h||document.body.offsetWidth)),null!==r&&(w=Math.max(w,r)),null!==g&&(w=Math.min(w,g||document.body.offsetWidth)),(!i||!n.includes("start")||S>s)&&(t.style.insetInlineStart=Math.max(b,0)+"px"),t.style.top=C+"px",t.style.width=S+"px",t.style.height=w+"px"}onResizePointerUp(e){var t,n;null===(t=this.removeDocUpListeners)||void 0===t||t.call(this),null===(n=this.removeMoveListeners)||void 0===n||n.call(this),this.removeMoveListeners=null,this.removeDocUpListeners=null}get isResizing(){return Boolean(this.removeMoveListeners)}doDestroy(){this.onResizePointerUp(),this.pointerDownListeners(),ki.removeEachSelector(this.element,".b-resize-grip"),super.doDestroy()}}rh._$name="ElementResizeHelper";var sh=e=>class extends(e||tt){static $name="Resizable";static configurable={resizable:null};updateResizable(e){const t=this;if(e){const n="object"==typeof e?e:{};t.resizeHelper=new rh(U.assign({element:t.element,internalListeners:{resizeStart:t.onResizeStart,thisObj:t}},n))}else{var n;null===(n=t.resizeHelper)||void 0===n||n.destroy()}}onResizeStart(){this.alignTo(null)}doDestroy(){var e;null===(e=this.resizeHelper)||void 0===e||e.destroy(),super.doDestroy()}updateRtl(e){super.updateRtl(e),this.resizeHelper&&(this.resizeHelper.rtl=e)}};class oh extends(nh.mixin(sh)){static $name="Popup";static type="popup";static configurable={autoShow:!0,autoClose:!0,showOnClick:!1,forElement:null,monitorResize:!0,floating:!0,hidden:!0,axisLock:!0,draggable:!0,draggableBlacklistSelector:"button,.b-field-inner,.b-gridbase,.b-calendarmixin,.b-resize-grip,input",hideAnimation:{opacity:{from:1,to:0,duration:".3s",delay:"0s"}},showAnimation:{opacity:{from:0,to:1,duration:".4s",delay:"0s"}},stripDefaults:{bbar:{layout:{justify:"flex-end"}}},testConfig:{hideAnimation:null,showAnimation:null},closeAction:"hide",trapFocus:!0,focusOnToFront:!0,closable:null,maximizable:null,modal:null,maximized:null,tools:{close:{cls:"b-popup-close",handler:"close",weight:-1e3,ariaLabel:"L{Popup.close}",hidden:!0},maximize:{cls:"b-popup-expand",handler:"toggleMaximized",weight:-999,ariaLabel:"L{Popup.maximize}",hidden:!0}},highlightReturnedFocus:!0,role:"dialog",closeOnEscape:!0};finalizeInit(){const e=this,{forElement:t}=e;e.anchoredTo=t,e.initialAnchor=e.anchor,t&&!1!==e.showOnClick&&(e.initialConfig.autoShow||(e.autoShow=!1),Mn.on({element:t,[2===e.showOnClick?"contextmenu":"click"]:"onElementUserAction",thisObj:e,capture:!0})),super.finalizeInit(),!e.autoShow||t&&!ki.isVisible(t)||(!0===e.autoShow?e.show():e.setTimeout((()=>e.show()),e.autoShow))}onInternalPaint({firstPaint:e}){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...arguments);const n=this;e&&n.headerElement&&Mn.on({element:n.headerElement,dblclick:n.onHeaderDblClick,thisObj:n})}doDestroy(){this.syncModalMask(),super.doDestroy()}compose(){const{hasNoChildren:e,textContent:t}=this;return{class:{"b-text-popup":Boolean(t&&e)}}}close(){if(!this._hidden){const e=this.trigger("beforeClose");if(U.isPromise(e))return e.then((e=>{!1!==e&&this.doClose()})),e;if(!1===e)return e}this.doClose()}doClose(){const e=this,{closeAction:t}=e;if(!e._hidden||"destroy"===t){var n;e.modal&&"destroy"===t&&e.revertFocus(),e.unmask();const r=e.items.length&&(null===(n=e.items.find((e=>e.errorTip)))||void 0===n?void 0:n.errorTip);var i;if(r)null===(i=r.pointerOverOutDetacher)||void 0===i||i.call(r),r.hide();return e[t]()}}toggleMaximized(){this.maximized=!this.maximized}updateMaximized(e){e=Boolean(e),this.element.classList.toggle("b-maximized",Boolean(e)),this.draggable&&(this.draggable.disabled=e)}onInternalKeyDown(e){const t=this;"Escape"===e.key&&t.closeOnEscape&&(e.stopImmediatePropagation(),t.floating||t.positioned?t.close(!0):t.collapsible&&(t.revealed?t.collapsible.toggleReveal():t.collapse()))}onDocumentMouseDown({event:e}){const t=this,{owner:n}=t,{target:i}=e;if(t.isVisible){if("touchend"!==e.type&&null!=n&&n.isButton&&n._menu===t&&n.element.contains(i))return e.preventDefault(),!1;if(t.modal&&i===oh.modalMask)e.preventDefault(),t.modal.closeOnMaskTap?t.close():t.containsFocus||t.focus();else if(!t.owns(i,!0)&&t.autoClose&&"mousedown"===e.type)if(t.containsFocus){const n=ki.getActiveElement(t.element),r=n&&oh.fromElement(n,"widget");if(null!=r&&r.owns(i,!0))return;Mn.on({element:document,once:!0,expires:100,[e.type]:e=>{e.defaultPrevented&&ki.getActiveElement(t.element)===n&&t.close()}})}else t.close()}}get isTopModal(){return!this._isRevertingFocus&&ki.isVisible(oh.modalMask)&&this.element.previousElementSibling===oh.modalMask}onFocusIn(e){const t=ki.getActiveElement(this);super.onFocusIn(e),ki.getActiveElement(this)===t&&e.target===this.element&&this.focus()}onFocusOut(e){globalThis.visualViewport&&globalThis.visualViewport.height<document.documentElement.clientHeight-1||this.modal||!this.autoClose||this.close(),super.onFocusOut(e)}afterShow(...e){const t=this;(t.autoClose||t.modal)&&t.addDocumentMouseDownListener(),super.afterShow(...e),t.toFront()}toFront(){this.floating&&(super.toFront(),this.syncModalMask()),this.focusOnToFront&&!this.containsFocus&&this.focus()}addDocumentMouseDownListener(){this.mouseDownRemover||(this.mouseDownRemover=Hi.ion({globaltap:"onDocumentMouseDown",thisObj:this}))}updateModal(e){const t=this;e?(t.element.setAttribute("aria-modal",!0),t.floating=!0,"number"==typeof t._x||"number"==typeof t._y||t.hasConfig("centered")||(t.centered=!0,t.anchor=!1)):t.element.removeAttribute("aria-modal")}syncModalMask(){const e=this,{modal:t,element:n}=e;if(t&&e.isVisible)e.modalMask.classList.remove("b-hide-display"),e.modalMask.classList.toggle("b-modal-transparent",Boolean(t.transparent)),n.classList.add("b-modal"),e.modalMask.setAttribute("owned-by",e.id);else if(e.isPainted){n.classList.remove("b-modal");const t=e.floatRoot.querySelectorAll(".b-modal"),i=t.length?oh.fromElement(t[t.length-1],"popup"):null;i?i.syncModalMask():oh.modalMask.classList.add("b-hide-display")}}afterHide(...e){var t;const n=this;super.afterHide(...e),null===(t=n.mouseDownRemover)||void 0===t||t.call(n),n.mouseDownRemover=null,n.syncModalMask()}onElementUserAction(e){const{showOnClick:t}=this;"number"==typeof t&&t!==e.button||(2===e.button&&e.preventDefault(),this.show())}onHeaderDblClick(){this.maximizable&&this.toggleMaximized()}updateClosable(e){this.tools.close.hidden=!e}updateMaximizable(e){this.tools.maximize.hidden=!e}get modalMask(){const{modalMask:e}=oh;return e.nextElementSibling!==this.element&&this.floatRoot.insertBefore(e,this.element),e}static get modalMask(){return this._modalMask||(this._modalMask=ki.createElement({className:"b-modal-mask b-hide-display"}),Mn.on({element:this._modalMask,wheel:e=>e.preventDefault()})),this._modalMask}}oh.initClass(),oh._$name="Popup";const ah=/^b-icon-/,lh=/^b-fa-/;class ch extends hd{static $name="MenuItem";static type="menuitem";static get configurable(){return{checked:null,separator:null,toggleGroup:null,menu:{value:null,$config:["lazy","nullify"]},menuDefaults:{type:"menu",align:"s0-e0",anchor:!0,autoClose:!0,floating:!0,autoShow:!1,cls:{"b-sub-menu":1}},icon:null,text:null,closeParent:null,href:null,radio:null,target:null,localizableProperties:["text"],role:"menuitem",openMenuDelay:120}}updateElement(e,t){const n=this,i=super.updateElement(e,t);return"boolean"==typeof n.checked?n.role="menuitemcheckbox":n.href&&(n.role=null),n.ariaHasPopup=!!n.hasMenu&&"menu",i}compose(){var e;const t=this,{checked:n,href:i,hasMenu:r,radio:s,separator:o,target:a,text:l}=t,c="boolean"==typeof n,d=t.icon||(c?"b-fw-icon":""),u="b-icon-"+(s?"radio-":""),h="object"==typeof l;return{tag:i?"a":"div",tabIndex:-1,href:i,target:a,class:{"b-has-submenu":r,"b-checked":n,"b-separator":o||(null===(e=t.cls)||void 0===e?void 0:e["b-separator"])},dataset:{group:t.toggleGroup},[c?"aria-checked":""]:n,[r?"aria-expanded":""]:!1,children:{iconElement:d&&{"aria-hidden":!0,tag:"i",class:{"b-fa":lh.test(d),"b-icon":ah.test(d),"b-menuitem-icon":1,[`${u}checked`]:!0===n,[`${u}unchecked`]:!1===n,...Ht.normalize(d,"object")}},textElement:{tag:"span",[h?void 0:"text"]:h?void 0:l,class:{"b-menu-text":1,"b-menu-custom-content":h},children:h?rt.asArray(l):null},subMenuIcon:r&&{"aria-hidden":!0,tag:"i",class:{"b-fw-icon":1,"b-icon-sub-menu":1}}}}}doAction(e){const t=this,n=this.parent,i={menu:n,item:t,element:t.element,bubbles:!0,domEvent:e};if("boolean"==typeof t.checked){const e=!t.checked;t.toggleGroup&&!e||(t.checked=!t.checked)}else t.href&&e.key&&t.element.click();t.trigger("beforeItem",i),t.trigger("item",i),t.closeParent&&n&&(n.rootMenu.close(),e&&!t.href&&e.preventDefault())}get focusElement(){return this.element}get contentElement(){return this.textElement}get isFocusable(){const{focusElement:e}=this;return e&&this.isVisible&&(e===document.body||e.offsetParent)}get hasMenu(){return this.hasConfig("menu")}get childItems(){const{_menu:e}=this;return e?[e]:[]}get radio(){return Boolean(this._radio??this.toggleGroup)}onFocusIn(e){const{menu:t}=this;super.onFocusIn(e),!this.disabled&&t&&(t.clearTimeout(t.closeTimer),this.delay("openMenu",t.closeTimer?0:this.openMenuDelay),t.closeTimer=null)}onFocusOut(e){var t;const n=this;n.clearTimeout("openMenu"),super.onFocusOut(e);const i=n._menu;!i||null!==(t=n.owner)&&void 0!==t&&t.ignoreFocusOut||(ki.usingKeyboard?n.closeMenu():(i.clearTimeout(i.closeTimer),i.closeTimer=i.setTimeout((()=>n.closeMenu()),i.closeMenuDelay),i.once("hide",(()=>i.clearTimeout(i.closeTimer)))))}openMenu(e){const{menu:t,parent:n}=this;!this.disabled&&t&&(t.focusOnToFront=e,n.isMenu?n.openSubMenu(this.element,this):t.show())}onChildShow(e){super.onChildShow(e),this.ariaElement.setAttribute("aria-expanded",!0)}closeMenu(){this._menu.isWidget&&this.menu.close(),this.menu.closeTimer=null}onChildHide(e){super.onChildHide(e),this.ariaElement.setAttribute("aria-expanded",!1)}changeToggleGroup(e){return e&&"boolean"!=typeof this.checked&&(this.checked=!1),e}changeChecked(e,t){if(this.isConfiguring||"boolean"==typeof t)return Boolean(e)}updateChecked(e){const t=this;t.isConfiguring||(t.toggleGroup&&t.uncheckToggleGroupMembers(),t.element.setAttribute("aria-checked",e),t.trigger("toggle",{menu:t.owner,item:t,element:t.element,bubbles:!0,checked:e}))}getToggleGroupMembers(){const e=this,{checked:t,toggleGroup:n,element:i}=e,r=[];return t&&n&&ki.forEachSelector(e.rootElement,`[data-group=${n}]`,(e=>{if(e!==i){const t=hd.fromElement(e);t&&r.push(t)}})),r}uncheckToggleGroupMembers(){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach((e=>e.checked=!1))}get closeParent(){return("boolean"==typeof this.checked?this._closeParent:!1!==this._closeParent)&&!this.hasMenu}changeMenu(e,t){const n=this,{constrainTo:i,scrollAction:r,focusOnHover:s}=n.owner;return!e||"object"!=typeof e||"type"in e&&"menu"!==e.type||"items"in e||"widgets"in e||"html"in e||(e={lazyItems:e}),uh.reconfigure(t,e?uh.mergeConfigs(n.menuDefaults,{owner:n,forElement:n.element,ariaLabel:n.text,[t?"positioned":"_"]:!1,focusOnHover:s,constrainTo:i,scrollAction:r},e):null,n)}}ch.initClass(),ch._$name="MenuItem";const dh={ArrowUp:1,ArrowDown:1,ArrowRight:1,ArrowLeft:1,Enter:1,Escape:1};class uh extends oh{static $name="Menu";static type="menu";static configurable={layout:"vbox",focusable:!0,draggable:!1,showAnimation:null,hideAnimation:{opacity:{from:1,to:0,duration:".15s",delay:"0s"}},align:{align:"t-b"},scrollAction:"hide",focusOnHover:null,scrollable:!1,defaultType:"menuitem",tools:{close:!1},role:"menu",closeMenuDelay:200,testConfig:{hideAnimation:null,closeMenuDelay:1}};construct(e){Array.isArray(e)&&(e={lazyItems:e}),super.construct(e),Mn.on({element:this.element,click:"onMouseClick",mouseover:"onMouseOver",mouseenter:"onMouseEnter",mouseleave:"onMouseLeave",thisObj:this})}afterShow(...e){const{items:t,element:n}=this;t.some((e=>e.hasConfig("menu")))&&n.classList.add("b-menu-with-submenu");t.some((e=>e.icon))&&n.classList.add("b-menu-with-icon"),super.afterShow(...e)}createWidget(e){return"string"==typeof e&&(e={text:e}),super.createWidget(e)}get focusElement(){var e;const t=this,n=null===(e=t.parentMenu)||void 0===e?void 0:e.element.contains(ki.getActiveElement(t.parentMenu)),i=t.items[0];return!n&&!ki.usingKeyboard&&i instanceof ch?t.element:super.focusElement}onDocumentMouseDown({event:e}){if(!this.parentMenu||!this.parentMenu.owns(e.target))return super.onDocumentMouseDown(...arguments)}hide(e){const t=this,n=super.hide(e);var i,r;t.isVisible||(null===(i=t.currentSubMenu)||void 0===i||null===(r=i.hide)||void 0===r||r.call(i,e),t.parentMenu&&(t.parentMenu.currentSubMenu=null));return n}show(...e){const t=super.show(...e),{parentMenu:n}=this;return this.isVisible&&n&&(n.currentSubMenu=this),t}onMouseClick(e){const t=e.target.closest(".b-menuitem");t&&this.triggerElement(t,e)}onMouseOver(e){if(!1!==this.focusOnHover){var t;const n=null===(t=e.relatedTarget)||void 0===t?void 0:t.closest(".b-widget"),i=e.target.closest(".b-widget"),r=hd.fromElement(i);!ki.isTouchEvent&&i&&i!==n&&r.parent===this&&this.setTimeout({fn:"handleMouseOver",delay:30,args:[r],cancelOutstanding:!0})}}handleMouseOver(e){e.focus()}onMouseEnter(){this.clearTimeout(this.closeTimer);const{parentMenu:e}=this;e&&(e.ignoreFocusOut=!0,e.setTimeout((()=>e.ignoreFocusOut=!1),500),e.clearTimeout(e.hideSubMenuTimer))}onMouseLeave(e){const t=this,{relatedTarget:n}=e,i=n&&t.owns(n);let r=n instanceof HTMLElement&&hd.fromElement(n),s=!i&&!1!==t.focusOnHover;if(r){for(;r.ownerCmp;)r=r.ownerCmp;s&=!ki.getAncestor(r.element,[e.target])}!i&&s&&(t.currentSubMenu&&(t.hideSubMenuTimer=t.setTimeout((()=>{var e;return null===(e=t.currentSubMenu)||void 0===e?void 0:e.hide()}),t.closeMenuDelay)),t.element.contains(ki.getActiveElement(t))&&ki.getActiveElement(t).matches(".b-menuitem")&&t.focusElement.focus())}onInternalKeyDown(e){const t=hd.fromElement(e),n=t&&t!==this&&!(t instanceof ch);if("Escape"===e.key)return void(n?this:this.rootMenu).close();if(super.onInternalKeyDown(e),n)return;dh[e.key]&&e.preventDefault();const i=this.element,r=ki.getActiveElement(i);this.navigateFrom(r!==i&&i.contains(r)?r:null,e.key,e)}navigateFrom(e,t,n){var i,r;const s=this,{treeWalker:o}=s,a=e&&s.getItem(e),l=s.rtl?"ArrowLeft":"ArrowRight",c=s.rtl?"ArrowRight":"ArrowLeft";let d;switch(t){case"ArrowUp":o.currentNode=e||(e=s.bottomFocusTrap),o.previousNode(),d=o.currentNode,null==a||null===(i=a.menu)||void 0===i||i.hide(!1);break;case"ArrowDown":o.currentNode=e||(e=s.topFocusTrap),o.nextNode(),d=o.currentNode,null==a||null===(r=a.menu)||void 0===r||r.hide(!1);break;case" ":e&&!e.classList.contains("b-disabled")&&(null!=a&&a.menu?s.openSubMenu(e,a):s.triggerElement(e,n));break;case l:if(e&&null!=a&&a.menu&&!e.classList.contains("b-disabled")){const t=s.openSubMenu(e,a);null==t||t.focus()}else o.currentNode=e||(e=s.topFocusTrap),o.nextNode(),d=o.currentNode;break;case c:s.isSubMenu?s.hide():e||(o.currentNode=e||(e=s.topFocusTrap),o.nextNode(),d=o.currentNode);break;case"Enter":e&&!e.classList.contains("b-disabled")&&s.triggerElement(e,n)}d&&(d===s.element?s.navigateFrom(s.bottomFocusTrap,"ArrowUp",n):d===e?s.navigateFrom(s.topFocusTrap,"ArrowDown",n):d.focus())}getItem(e){if(null!=e)return"number"==typeof e?this.items[e]:e.nodeType===Element.ELEMENT_NODE?hd.fromElement(e,"menuitem",this.contentElement):this.items.find((t=>t.id==e))}triggerElement(e,t){const n=this.getItem(e);n&&!n.disabled&&n.doAction(t)}get isSubMenu(){var e;return this===(null===(e=this.owner)||void 0===e?void 0:e.menu)}openSubMenu(e,t){const n=this,i=t.menu;if(i){if(!i.isVisible){var r;const s={item:t,element:e};if(!1===n.trigger("beforeSubMenu",s))return;if(!1===(null===(r=t.onBeforeSubMenu)||void 0===r?void 0:r.call(t,s)))return;i.show(),i.isVisible&&!i.isMenu&&(n.currentSubMenu=i)}return i}}set selectedElement(e){const t=this,n=t._selectedElement;if(n){const e=t.getItem(n),i=null==e?void 0:e.menu;null==i||i.hide(),n.classList.remove("b-active")}if(t._selectedElement=e,e){const n=ki.isFocusable(e);e.classList.add("b-active"),t.scrollable.scrollIntoView(e,{animate:!n,focus:n})}}get selectedElement(){return this._selectedElement}selectFirst(){const e=this.treeWalker;e.currentNode=this.topFocusTrap,e.nextNode(),this.requestAnimationFrame((()=>e.currentNode.focus()))}get parentMenu(){var e;const t=this.owner;return t&&(t.isMenu?t:null===(e=t.up)||void 0===e?void 0:e.call(t,"menu"))}get rootMenu(){let e=this;for(;e.parentMenu instanceof this.constructor;)e=e.parentMenu;return e}}let hh;uh.initClass(),uh._$name="Menu";class gh extends ur{static $name="ContextMenuBase";static get configurable(){return{type:null,menu:{$config:["lazy","nullify"],value:{type:"menu",autoShow:!1,closeAction:"hide",constrainTo:globalThis,scrollAction:null}},items:{},triggerEvent:null,clickTriggerSelector:null,preventNativeMenu:null,keyMap:{" ":{handler:"showContextMenuByKey",weight:100},"Ctrl+Space":"showContextMenuByKey"}}}static get pluginConfig(){return{assign:["showContextMenu"],chain:["onElementContextMenu","onElementClick","onElementDblClick"]}}construct(...e){var t;if(super.construct(...e),null===(t=this.type)||void 0===t||!t.length)throw new Error("Config 'type' is required to be specified for context menu")}onElementContextMenu(e){this.onElementEvent(e)}onElementClick(e){this.onElementEvent(e)}onElementDblClick(e){this.onElementEvent(e)}onElementEvent(e){if(e.handled||this.triggerEvent!==e.type)"click"===e.type&&this.clickTriggerSelector&&e.target.matches(this.clickTriggerSelector)&&this.internalShowContextMenu(e,{align:"l-r",target:e.target});else{if(!0===e.ctrlKey&&!d.isMac)return void e.preventDefault();const t=e;if(hh){const{target:n}=hh;e=Mn.fixEvent(new MouseEvent(e.type,e)),Object.defineProperties(e,{target:{value:n},offsetX:{value:t.offsetX},offsetY:{value:t.offsetY}}),e.preventDefault=function(){t.preventDefault(),t.handled=!0}}this.internalShowContextMenu(e)}}showContextMenuByKey(e){if(!ki.isEditable(e.target)){const{target:t}=e;if(t)return hh=e,ki.triggerMouseEvent(t,this.triggerEvent),e.handled=!0,e.preventDefault(),e.stopImmediatePropagation(),hh=null,!0}return!1}internalShowContextMenu(e,t){const n=this;let i;n.disabled||!e.handled&&!e.defaultPrevented&&(i=n.getDataFromEvent(e))&&n.shouldShowMenu(i)&&("contextmenu"===e.type&&d.isSafari&&!e.ctrlKey&&e.metaKey&&Mn.on({element:e.target,capture:!0,once:!0,thisObj:this,click(e){e.preventDefault(),e.stopImmediatePropagation()}}),i.domEvent=e,n.showContextMenu(i,t))}getDataFromEvent(e){return{feature:this,event:e,targetElement:this.getTargetElementFromEvent(e)}}getTargetElementFromEvent(e){return e.target}async showContextMenu(e,t){var n,i;const r=this,s=ki.isDOMEvent(e),o=s?r.getDataFromEvent(e):e,a=s?e:o.domEvent,l=null===(n=ki.isInView(o.targetElement))||void 0===n?void 0:n.center;if(null===(i=r._menu)||void 0===i||i.hide(),r.disabled||!l)return;r.menuContext=o;const{type:c,client:d,processItems:u}=r;if(C.assign(o,{point:null!=a&&a.clientX?[a.clientX+1,a.clientY+1]:[l.x,l.y],menu:r,items:{},selection:d.selectedRecords}),r.callChainablePopulateMenuMethod(o),C.merge(o.items,r.baseItems),r.preventNativeMenu&&r.preventDefaultEvent(o),(!u||!1!==await r.callback(u,d,[o]))&&r.hasActiveMenuItems(o)&&(r.populateItemsWithData(o),!1!==r.beforeContextMenuShow(o))){const{menu:e}=r,{featureItems:n}=e,{items:i}=o;r.preventDefaultEvent(o);let s=d.trigger(`${c}MenuBeforeShow`,o);if(U.isPromise(s)&&(a.handled=!0,s=await s),!Object.values(i).some((e=>e)))return;var h;if(!1!==s)n&&(e.remove(n),rt.asArray(n).forEach((e=>e.destroy()))),e.featureItems=e.add(...Array.isArray(i)?i:e.processItemsObject(i)),e.showBy(t||{target:o.domEvent,align:"s0-e100"}),null===(h=r.touchMoveDetacher)||void 0===h||h.call(r),r.touchMoveDetacher=Mn.on({element:d.element,touchmove:()=>e.hide(),thisObj:e,once:!0}),a&&(a.preventDefault(),a.handled=!0)}}get baseItems(){if(!this._baseItems){const e=this,{namedItems:t}=e,n=e._baseItems=C.assign({},e.items);for(const e in n){const i=n[e];i&&(t&&e in t?n[e]="object"==typeof i?C.merge(C.clone(t[e]),i):t[e]:!0===i&&delete n[e])}}return this._baseItems}hideContextMenu(e){var t;null===(t=this.menu)||void 0===t||t.hide(e)}callChainablePopulateMenuMethod(e){var t,n;null===(t=(n=this.client)[`populate${V.capitalize(this.type)}Menu`])||void 0===t||t.call(n,e)}hasActiveMenuItems(e){return Object.values(e.items).some((e=>e&&!e.hidden))}shouldShowMenu(){return!0}beforeContextMenuShow(e){}populateItemsWithData(e){}preventDefaultEvent(e){var t;null===(t=e.event)||void 0===t||t.preventDefault()}get triggerEvent(){return this._triggerEvent||this.client.contextMenuTriggerEvent}changeMenu(e,t){const n=this,{client:i,type:r}=n;if(e)return uh.reconfigure(t,e?uh.mergeConfigs({owner:i,rootElement:i.rootElement,onItem(e){i.trigger(`${r}MenuItem`,e)},onToggle(e){i.trigger(`${r}MenuToggleItem`,e)},onDestroy(){n.menu=null},onBeforeItem(e){Object.assign(e,n.menuContext)},onShow({source:e}){n.menuContext.menu=e,i.trigger(`${r}MenuShow`,n.menuContext)}},e):null,n);null!=t&&t.isWidget&&t.destroy()}}gh._$name="ContextMenuBase";const mh={down:"onMouseDown",move:"onMouseMove",up:"onMouseUp",docclick:"onDocumentClick",touchstart:{handler:"onTouchStart",passive:!1},touchmove:"onTouchMove",touchend:"onTouchEnd",keydown:"onKeyDown"};class ph extends(dt(tt)){static configurable={resizingCls:"b-resizing",dragThreshold:5,handleSize:10,dynamicHandleSize:null,reservedSpace:10,touchHandleSize:30,minWidth:1,maxWidth:0,minHeight:1,maxHeight:0,outerElement:!0,scroller:null,allowResize:null,dragWithin:null,isElementResizable:null,targetSelector:null,leftHandle:!0,rightHandle:!0,topHandle:!0,bottomHandle:!0,handleSelector:null,handleContainerSelector:null,startEvent:null,grab:null,invalidCls:"b-resize-invalid",handleVisibilityThreshold:null,skipTranslate:!1,direction:"horizontal",clickSwallowDuration:50,constrainToParent:!0,rtlSource:null,skipUpdatingElement:null};construct(e){const t=this;super.construct(e),t.handleSelector||d.isHoverableDevice||(t.handleSize=t.touchHandleSize),t.handleVisibilityThreshold=t.handleVisibilityThreshold||2*t.handleSize,t.initListeners(),t.initResize()}doDestroy(){this.abort(!0),super.doDestroy()}changeOuterElement(e){return!0===e?document.body:e}updateSkipUpdatingElement(e){e&&(this.skipTranslate=!0)}getX(e){return"inset"===this.positioning?parseFloat(getComputedStyle(e).insetInlineStart,10):ki.getTranslateX(e)}getY(e){return"inset"===this.positioning?parseFloat(getComputedStyle(e).insetBlockStart,10):ki.getTranslateY(e)}setX(e,t){"inset"===this.positioning?e.style.insetInlineStart=t+"px":ki.setTranslateX(e,t)}setY(e,t){"inset"===this.positioning?e.style.insetBlockStart=t+"px":ki.setTranslateY(e,t)}initResize(){const e=this;if(!e.isElementResizable&&e.targetSelector&&(e.isElementResizable=t=>t.closest(e.targetSelector)),e.grab){const{edge:t,element:n,event:i}=e.grab;e.startEvent=i;const r=e.getX(n)||n.offsetLeft,s=e.getY(n)||n.offsetTop;e.context={element:n,edge:t,valid:!0,async:!1,elementStartX:r,elementStartY:s,newX:r,newY:s,elementWidth:n.offsetWidth,elementHeight:n.offsetHeight,startX:i.clientX+e.scrollLeft,startY:i.clientY+e.scrollTop,finalize:()=>{var t;return null===(t=e.reset)||void 0===t?void 0:t.call(e)}},n.classList.add(e.resizingCls),e.internalStartResize(e.isTouch)}}initListeners(){const e=this,t={element:e.outerElement,mousedown:mh.down,touchstart:mh.touchstart,thisObj:e};!e.handleSelector&&d.isHoverableDevice&&(t.mousemove={handler:mh.move,delegate:e.targetSelector},t.mouseleave={handler:"onMouseLeaveTarget",delegate:e.targetSelector,capture:!0}),Mn.on(t)}get isRTL(){var e;return Boolean(null===(e=this.rtlSource)||void 0===e?void 0:e.rtl)}get scrollLeft(){return this.scroller?this.scroller.x:this.outerElement.scrollLeft}get scrollTop(){return this.scroller?this.scroller.y:this.outerElement.scrollTop}internalStartResize(e){var t;const n={element:document,keydown:mh.keydown,thisObj:this};e?(n.touchmove=mh.touchmove,n.touchend=n.pointerup=mh.touchend):(n.mousemove=mh.move,n.mouseup=mh.up),this.removeDragListeners=Mn.on(n),null===(t=this.onResizeHandlePointerDown)||void 0===t||t.call(this,this.startEvent)}removeDragListeners(){}reset(){var e;null===(e=this.removeDragListeners)||void 0===e||e.call(this),this.context=null,this.trigger("reset")}canResize(e,t){return!this.isElementResizable||this.isElementResizable(e,t)}onPointerDown(e,t){const n=this;n.startEvent=t,n.canResize(t.target,t)&&n.grabResizeHandle(e,t)&&(t.stopImmediatePropagation(),"touchstart"===t.type&&t.preventDefault(),n.internalStartResize(e))}onTouchStart(e){e.touches.length>1||this.onPointerDown(!0,e)}onMouseDown(e){0===e.button&&this.onPointerDown(!1,e)}internalMove(e,t){const n=this,{context:i,direction:r}=n;if(null!=i&&i.element&&(i.started||Mn.getDistanceBetween(n.startEvent,t)>=n.dragThreshold)){var s;if(!i.started)null===(s=n.scrollManager)||void 0===s||s.startMonitoring(U.merge({scrollables:[{element:n.dragWithin||n.outerElement,direction:r}],callback:e=>{var t;return(null===(t=n.context)||void 0===t?void 0:t.element)&&n.lastMouseMoveEvent&&n.update(n.lastMouseMoveEvent,e)}},n.monitoringConfig)),n.trigger("resizeStart",{context:i,event:t}),i.started=!0;n.update(t)}else e||n.handleSelector||n.checkResizeHandles(t)}onTouchMove(e){this.internalMove(!0,e)}onMouseMove(e){this.internalMove(!1,e)}onPointerUp(e,t){var n;const i=this,r=i.context;var s,o;(null===(n=i.removeDragListeners)||void 0===n||n.call(i),r)?(null===(s=i.scrollManager)||void 0===s||s.stopMonitoring(),r.started&&Mn.on({element:ki.getRootElement(t.target),thisObj:i,click:mh.docclick,expires:i.clickSwallowDuration,capture:!0,once:!0}),i.finishResize(t)):null===(o=i.reset)||void 0===o||o.call(i)}onTouchEnd(e){this.onPointerUp(!0,e)}onMouseUp(e){this.onPointerUp(!1,e)}onDocumentClick(e){e.stopPropagation()}onKeyDown(e){"Escape"===e.key&&this.abort()}update(e){const t=this,{context:n,constrainToParent:i}=t,{element:r}=n;if(i){const i=_t.from(t.outerElement);n.currentX=Math.max(Math.min(e.clientX,i.right),i.x)+t.scrollLeft,n.currentY=Math.max(Math.min(e.clientY,i.bottom),i.y)+t.scrollTop}else n.currentX=e.clientX+t.scrollLeft,n.currentY=e.clientY+t.scrollTop;r.classList.add(t.resizingCls),t.updateResize(e)&&(t.trigger("resizing",{context:n,event:e}),r.classList.toggle(t.invalidCls,!1===n.valid)),t.lastMouseMoveEvent=e}abort(e=!1){var t,n;const i=this;null===(t=i.scrollManager)||void 0===t||null===(n=t.stopMonitoring)||void 0===n||n.call(t),i.context?i.abortResize(null,e):i.isDestroyed||i.reset()}grabResizeHandle(e,t){const n=this;if(n.allowResize&&!n.allowResize(t.target,t))return!1;const i=n.handleSelector,r="touchstart"===t.type?t.changedTouches[0]:t,s=r.clientX,o=r.clientY;let a=n.targetSelector?t.target.closest(n.targetSelector):t.target;if(a){var l;let r;if(i){if(!t.target.matches(i))return!1;r="horizontal"===n.direction?t.pageX<ki.getPageX(a)+a.offsetWidth/2?n.isRTL?"right":"left":n.isRTL?"left":"right":t.pageY<ki.getPageY(a)+a.offsetHeight/2?"top":"bottom"}else if("horizontal"===n.direction?n.overLeftHandle(t,a)?r=n.isRTL?"right":"left":n.overRightHandle(t,a)&&(r=n.isRTL?"left":"right"):n.overTopHandle(t,a)?r="top":n.overBottomHandle(t,a)&&(r="bottom"),!r)return n.context=null,!1;"touchstart"===t.type&&t.preventDefault();const c=null===(l=n.internalBeforeStart)||void 0===l?void 0:l.call(n,{element:a,edge:r});if(c&&(a=c.element,r=c.edge),!1!==n.trigger("beforeResizeStart",{element:a,event:t})){const t=n.getX(a)||a.offsetLeft,i=n.getY(a)||a.offsetTop;return n.context={element:a,edge:r,isTouch:e,valid:!0,async:!1,direction:n.direction,elementStartX:t,elementStartY:i,newX:t,newY:i,elementWidth:a.offsetWidth,elementHeight:a.offsetHeight,startX:s+n.scrollLeft,startY:o+n.scrollTop,finalize:()=>{var e;return null===(e=n.reset)||void 0===e?void 0:e.call(n)}},a.classList.add(n.resizingCls),!0}}return!1}checkResizeHandles(e){const t=this,n=t.targetSelector?e.target.closest(t.targetSelector):e.target;let i=!1;return!n||t.allowResize&&!t.allowResize(e.target,e)?t.currentElement&&t.unHighlightHandle():(t.currentElement=t.handleContainerSelector?e.target.closest(t.handleContainerSelector):e.target,t.currentElement&&(i="horizontal"===t.direction?t.overLeftHandle(e,n)||t.overRightHandle(e,n):t.overTopHandle(e,n)||t.overBottomHandle(e,n),i?t.highlightHandle():t.unHighlightHandle())),i}onMouseLeaveTarget(e){const t=this;t.currentElement=t.handleContainerSelector?e.target.closest(t.handleContainerSelector):e.target,t.currentElement&&t.unHighlightHandle()}updateResize(e){const t=this,{context:n,allowEdgeSwitch:i,skipTranslate:r,skipUpdatingElement:s}=t;let o;i&&("horizontal"===t.direction?n.edge=n.currentX>n.startX?"right":"left":n.edge=n.currentY>n.startY?"bottom":"top");const{element:a,elementStartX:l,elementStartY:c,elementWidth:d,elementHeight:u,edge:h}=n,{style:g}=a,m=(n.currentX-n.startX)*("inset"===t.positioning&&t.isRTL?-1:1),p=n.currentY-n.startY,f=ki.getExtremalSizePX(a,"minWidth")||t.minWidth,v=ki.getExtremalSizePX(a,"maxWidth")||t.maxWidth,y=ki.getExtremalSizePX(a,"minHeight")||t.minHeight,b=ki.getExtremalSizePX(a,"maxHeight")||t.maxHeight,C=("right"!==h||t.isRTL&&"inset"!==t.positioning)&&"bottom"!==h?-1:1,S=d+m*C,w=u+p*C;let D=Math.max(f,S),E=Math.max(y,w);if(v>0&&(D=Math.min(D,v)),b>0&&(E=Math.min(E,b)),"horizontal"===t.direction&&d!==D){if(s||(g.flex="",g.width=Math.abs(D)+"px"),n.newWidth=D,"left"===h||D<0){const e=Math.max(Math.min(l+d-t.minWidth,l+m),0);r||t.setX(a,Math.round(e)),n.newX=e}else"right"===h&&i&&!r&&t.setX(a,l);o=!0}else"vertical"===t.direction&&u!==w&&(s||(g.flex="",g.height=Math.abs(E)+"px"),n.newHeight=E,"top"===h||E<0?(n.newY=Math.max(Math.min(c+u-t.minHeight,c+p),0),r||t.setY(a,n.newY)):"bottom"===h&&i&&!r&&t.setY(a,c),o=!0);return o}finishResize(e){const t=this,n=t.context,i={context:n,event:e};if(n.element.classList.remove(t.resizingCls),n.started){let e=!1;e="horizontal"===t.direction?n.newWidth&&n.newWidth!==n.elementWidth:n.newHeight&&n.newHeight!==n.elementHeight,t.trigger(e?"resize":"cancel",i),n.async||n.finalize()}else{var r;null===(r=t.reset)||void 0===r||r.call(t)}}abortResize(e=null,t=!1){const n=this,i=n.context;i.element.classList.remove(n.resizingCls),"horizontal"===n.direction?(("left"===i.edge||i.allowEdgeSwitch&&!i.skipTranslate)&&n.setX(i.element,i.elementStartX),i.element.style.width=i.elementWidth+"px"):(n.setY(i.element,i.elementStartY),i.element.style.height=i.elementHeight+"px"),!t&&n.trigger("cancel",{context:i,event:e}),n.isDestroyed||n.reset()}highlightHandle(){const e=this,t=e.targetSelector?e.currentElement.closest(e.targetSelector):e.currentElement;e.currentElement.classList.add("b-resize-handle"),t.classList.add("b-over-resize-handle")}unHighlightHandle(){const e=this,t=e.targetSelector?e.currentElement.closest(e.targetSelector):e.currentElement;t&&t.classList.remove("b-over-resize-handle"),e.currentElement.classList.remove("b-resize-handle"),e.currentElement=null}overAnyHandle(e,t){return this.overStartHandle(e,t)||this.overEndHandle(e,t)}overStartHandle(e,t){return"horizontal"===this.direction?this.overLeftHandle(e,t):this.overTopHandle(e,t)}overEndHandle(e,t){return"horizontal"===this.direction?this.overRightHandle(e,t):this.overBottomHandle(e,t)}getDynamicHandleSize(e,t){const n=e?2:1,{handleSize:i}=this;return this.dynamicHandleSize&&i*n>t-this.reservedSpace?Math.max(Math.floor((t-this.reservedSpace)/n),0):i}overLeftHandle(e,t){const n=this,{offsetWidth:i}=t;if(n.leftHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=_t.from(t);return r.width=n.getDynamicHandleSize(n.rightHandle,i),r.width>0&&r.contains(Mn.getPagePoint(e))}return!1}overRightHandle(e,t){const n=this,{offsetWidth:i}=t;if(n.rightHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=_t.from(t);return r.x=r.right-n.getDynamicHandleSize(n.leftHandle,i),r.width>0&&r.contains(Mn.getPagePoint(e))}return!1}overTopHandle(e,t){const n=this,{offsetHeight:i}=t;if(n.topHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=_t.from(t);return r.height=n.getDynamicHandleSize(n.bottomHandle,i),r.height>0&&r.contains(Mn.getPagePoint(e))}return!1}overBottomHandle(e,t){const n=this,{offsetHeight:i}=t;if(n.bottomHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=_t.from(t);return r.y=r.bottom-n.getDynamicHandleSize(n.bottomHandle,i),r.height>0&&r.contains(Mn.getPagePoint(e))}return!1}}ph._$name="ResizeHelper";const fh=/>[ \t\r\n]+</g,vh=/\s\s+/g;class yh{static tpl(e,...t){let n=0,i=t.map(((t,i)=>{let r=e[i];return Array.isArray(t)?r+=t.reduce(((e,t)=>e+(("string"==typeof t?t.trim():t)+"\n")),""):(void 0===t&&(t=""),r+="string"==typeof t?t.trim():t),n++,r})).join("");return n<=e.length&&(i+=e[e.length-1]),i.replace(fh,"><").replace(vh," ").trim()}static docsTpl(e,...t){let n=0,i=t.map(((t,i)=>{let r=e[i];return Array.isArray(t)?r+=t.reduce(((e,t)=>e+(("string"==typeof t?t.trim():t)+"\n")),""):(void 0===t&&(t=""),r+="string"==typeof t?t.trim():t),n++,r})).join("");return n<=e.length&&(i+=e[e.length-1]),i.replace(fh,"><").trim()}static repeat(e){return function(...t){return yh.tpl(...t).repeat(e)}}static loop(e){}}yh._$name="TemplateHelper";class bh extends Array{constructor(e,t){super(),this.timeZone=e,this.year=t}}class Ch{constructor(e,t){this.asString=e,this.timeZone=t,this.asArray=Dh(e)}get asLocalDate(){return this._asLocalDate||(this._asLocalDate=new Date(...this.asArray)),this._asLocalDate}get asTicksUtc(){return this._asTicksUtc||(this._asTicksUtc=new Date(Date.UTC(...this.asArray)).getTime()),this._asTicksUtc}}const Sh=(e,t)=>{const n=e.toLocaleString("sv-SE",{timeZone:t});return new Ch(n,t)},wh=(e,t)=>{const{asTicksUtc:n,asString:i}=Sh(new Date(e),t);return{offset:(e-n)/6e4,tzTicksUtc:n,tzString:i}},Dh=e=>{const t=e.split(/[\s-:]/).map((e=>1*e));return t[1]-=1,t},Eh=-864e5,xh=2592e6,Rh=(e,t)=>{const n=Th.get(e,t);if(n)return n;const i=new bh(e,t),r=new Date(Date.UTC(t,0,1)).getTime();let s,o,a,l,c=r,d=xh,u=0,h=[],g=null;for(;!l;)({offset:a,tzTicksUtc:s,tzString:o}=wh(c,e)),null==g?(g=a,i.push({offset:a})):d>0&&a!==g?d=d===xh?Eh:-6e4:d<0&&a===g&&(d===Eh?d=36e5:(1===i.length?(i.push(h),g=h.offset):(i[0].startTicks=h.startTicks,i[0].startDateString=h.startDateString,l=!0),d=xh)),h={offset:a,startDateString:o,startTicks:s},d===xh&&(c=r,c+=u*xh,u+=1),c+=d,u>11&&(l=!0);return Th.set(i),i},Th={_cache:{},get(e,t){var n;return null===(n=this._cache[e])||void 0===n?void 0:n[t]},set(e){const{timeZone:t}=e,{_cache:n}=this;n[t]||(n[t]={}),n[t][e.year]=e}};class Mh{static $name="TimeZoneHelper";static toTimeZone(e,t){if("number"==typeof t)return this.toUtcOffset(e,t);const n=Sh(e,t);return n.asArray[3]!==n.asLocalDate.getHours()&&console.warn("Incorrect time zone conversion due to local DST-switch detected"),n.asLocalDate}static fromTimeZone(e,t){if("number"==typeof t)return this.fromUtcOffset(e,t);const n=this.dateAsArray(e),i=Rh(t,e.getUTCFullYear());let r=i[0].offset;if(2===i.length){const e=Date.UTC(...n);e>=i[1].startTicks&&e<i[0].startTicks&&(r=i[1].offset)}return n[4]+=r,new Date(Date.UTC(...n))}static toUtcOffset(e,t){const n=e.getTimezoneOffset()+t;return new Date(e.getTime()+60*n*1e3)}static fromUtcOffset(e,t){const n=-e.getTimezoneOffset()-t;return new Date(e.getTime()+60*n*1e3)}static dateAsArray(e){return[e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()]}}Mh.findOffsetDates=Rh,l.register(Mh),Mh._$name="TimeZoneHelper";class Ih extends hd{static $name="Toast";static type="toast";static get configurable(){return{testConfig:{destroyTimeout:1,timeout:400},floating:!0,timeout:2500,autoDestroy:null,destroyTimeout:200,showProgress:!0,color:null,sideMargin:20,side:"bottom",role:"alert"}}static toasts={"top-start":[],"top-end":[],"bottom-start":[],"bottom-end":[]};changeSide(e){return"top"==e||"bottom"==e?e+="-end":"start"!==e&&"end"!=e||(e="bottom-"+e),e}compose(){const{appendTo:e,color:t,html:n,showProgress:i,style:r,timeout:s,side:o}=this;return{parent:e||this.floatRoot,class:{...Ht.normalize(t,"object"),[`b-side-${o}`]:1,"b-toast-hide":1},"aria-atomic":!1,html:n,style:{...ki.parseStyle(r),"--side":o.split("-")[0]},children:{progressElement:i&&{style:`animation-duration:${s}ms;`,class:{"b-toast-progress":1}}},listeners:{click:"hide"}}}doDestroy(){this.untoast(),super.doDestroy()}getNextInset(e){const{sideMargin:t,element:n}=this;return parseInt(n.style[e],10)+n.offsetHeight+t}async show(...e){var t;await super.show(...e);const n=this,{element:i,side:r}=n,s=Ih.toasts[r],o=r.split("-")[0],a=n.timeout*(null!==(t=ki.getActiveElement())&&void 0!==t&&t.matches(":focus-visible")?3:1);var l;s.includes(n)||(i.style[o]=((null===(l=s[0])||void 0===l?void 0:l.getNextInset(o))??n.sideMargin)+"px",s.unshift(n),i.getBoundingClientRect(),i.classList.remove("b-toast-hide"),a>0&&(n.hideTimeout=n.setTimeout("hide",a)))}async hide(){const e=this;e.untoast(),e.element.classList.add("b-toast-hide"),e.autoDestroy&&!e.destroyTimer&&(e.destroyTimer=e.setTimeout("destroy",e.destroyTimeout))}untoast(){const e=Ih.toasts[this.side];e.includes(this)&&e.splice(e.indexOf(this),1),ki.removeAttributeValue(document.body,"aria-describedby",this.id)}static hideAll(){Object.keys(Ih.toasts).forEach((e=>Ih.toasts[e].slice().reverse().forEach((e=>e.hide()))))}static show(e){var t;const n=Ih.new({autoDestroy:!0,rootElement:document.body,autoShow:!1},"string"==typeof e?{html:e}:e);return null!==(t=ki.getActiveElement())&&void 0!==t&&t.matches(":focus-visible")&&Object.values(this.toasts).flat().length?ut.waitFor((()=>!Object.values(this.toasts).flat().length)).then((()=>setTimeout((()=>n.show()),250))):n.show(),n}}Ih.initClass(),Ih._$name="Toast";class kh{static getById(e){return q.deprecate("core","7.0.0","Use Widget.getById instead"),hd.getById(e)}static fromElement(e,t,n){return q.deprecate("core","7.0.0","Use Widget.fromElement instead"),hd.fromElement(e,t,n)}static createWidget(e={}){return q.deprecate("core","7.0.0","Use Widget.create instead"),e.isWidget?e:hd.create(e)}static append(e,t){if(q.deprecate("core","7.0.0","Use a Container instead"),e=Array.isArray(e)&&e||[e],(t instanceof HTMLElement||"string"==typeof t)&&(t={appendTo:t}),t.insertFirst){const e="string"==typeof t.insertFirst?document.getElementById(t.insertFirst):t.insertFirst;e.firstChild?t.insertBefore=e.firstChild:t.appendTo=e}return e.map((e=>hd.create(U.assign({},t||{},e))))}static openPopup(e,t){return q.deprecate("core","7.0.0","Use Popup directly instead"),hd.create(U.assign({forElement:e},"string"==typeof t?{html:t}:t),"popup")}static showContextMenu(e,t){q.deprecate("core","7.0.0","Use Menu directly instead");const n=this;return n.currentContextMenu&&n.currentContextMenu.destroy(),e instanceof HTMLElement?t.forElement=e:(t.forElement=document.body,Array.isArray(e)&&(e=new jt(...e)),e instanceof jt&&(t.align={position:e})),t.internalListeners={destroy:n.currentContextMenu=null},n.currentContextMenu=hd.create(t,"menu")}static attachTooltip(e,t){return q.deprecate("core","7.0.0","Use Tooltip directly instead"),hd.attachTooltip(e,t)}static hasTooltipAttached(e){return q.deprecate("core","7.0.0","Will be removed"),hd.resolveType("tooltip").hasTooltipAttached(e)}static destroyTooltipAttached(e){return q.deprecate("core","7.0.0","Will be removed"),hd.resolveType("tooltip").destroyTooltipAttached(e)}static mask(e,t="Loading"){if(q.deprecate("core","7.0.0","Use Mask directly instead"),e)return e instanceof HTMLElement&&(e={target:e,text:t}),Cd.mask(e,e.target)}static unmask(e,t=!0){q.deprecate("core","7.0.0","Use Mask directly instead"),e.mask&&(t?e.mask.close():e.mask.hide())}static toast(e){return q.deprecate("core","7.0.0","Use Toast directly instead"),Ih.show(e)}}kh._$name="WidgetHelper";class Fh{static convertFromObject(e,t={}){C.assignIf(t,{rootName:"root",elementName:"element",includeHeader:!0,rootElementForArray:!0});const{rootName:n,elementName:i,includeHeader:r,rootElementForArray:s}=t;let{xmlns:o}=t;o=o?` xmlns="${o}"`:"";const a=e=>{const t=[];for(const n in e){const r=e[n];if(Array.isArray(r)){s&&t.push(`<${n}>`);for(const e of r)i.length?t.push(`<${i}>`):t.push(`<${n}>`),t.push(a(e)),i.length?t.push(`</${i}>`):t.push(`</${n}>`);s&&t.push(`</${n}>`)}else C.isObject(r)?t.push(`<${n}>${a(r)}</${n}>`):null==r?t.push(`<${n}/>`):t.push(`<${n}>${V.encodeHtml(r)}</${n}>`)}return t.join("")};return`${r?'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>':""}<${n}${o}>${a(e)}</${n}>`}}Fh._$name="XMLHelper";class Ah{constructor(){this.random100=[46,2,36,46,54,59,18,20,71,55,88,98,13,61,61,40,2,15,3,32,51,45,64,25,81,85,54,13,57,49,64,22,81,94,0,62,17,7,11,2,33,99,85,26,83,83,96,26,20,89,91,38,26,13,11,79,32,30,5,51,70,7,5,56,58,77,37,89,40,80,78,59,26,36,8,51,60,23,86,5,11,96,64,94,87,64,4,78,17,85,35,0,90,86,23,55,53,9,35,59,29,2,64,42,8,49,43,73,6,53,38,9,39,31,32,40,49,13,78,68,20,99,24,78,35,91,73,46,67,76,89,69,30,69,25,3,4,55,1,65,66,76,83,19,67,1,95,24,54,45,56,40,67,92,72,4,69,8,47,50,27,2,38,9,14,83,12,14,62,95,22,47,35,18,38,14,86,64,68,61,52,69,39,93,20,73,32,52,74,6,56,68,99,29,24,92,40,67,6,72,31,41,91,53,80,55,33,97,97,99,18,20,5,27,82,84,61,78,27,67,7,42,75,95,91,25,63,21,70,36,46,0,1,45,84,6,86,15,10,62,96,94,10,23,93,83,94,47,5,29,29,52,51,37,77,96,43,72,43,14,54,14,72,52,4,39,15,26,68,28,25,76,60,50,22,40,72,74,68,58,8,48,40,62,52,24,9,26,47,44,49,96,7,77,90,45,76,47,5,86,1,36,18,42,19,90,34,23,70,32,69,79,0,99,57,80,72,21,19,72,85,68,4,40,86,62,0,63,4,11,69,31,78,31,21,78,29,84,13,53,57,10,26,50,24,30,90,42,51,96,93,21,99,23,81,0,89,43,86,63,93,19,54,71,92,36,4,95,37,99,60,29,23,50,68,95,57,95,77,53,99,78,75,12,92,47,23,14,0,41,98,11,34,64,26,90,50,23,38,31,74,76,16,76,66,23,22,72,48,50,20,36,37,58,5,43,49,64,81,30,8,21,98,75,60,17,50,42,27,38,90,74,45,68,67,27,31,15,58,76,41,99,23,98,53,98,56,19,79,2,4,38,96,24,65,51,43,42,41,60,46,7,90,65,3,27,63,99,51,44,86,1,54,40,15,74,3,81,51,63,87,79,84,72,22,38,96,95,33,41,21,99,21,69,7,49,40,52,41,6,91,19,76,40,54,17,33,11,11,0,1,32,94,33,13,18,45,7,85,61,42,54,45,72,78,96,17,9,80,87,41,96,66,0,8,59,18,21,2,28,64,75,97,32,80,86,97,97,55,2,73,75,11,89,67,58,70,76,12,46,64,17,22,97,25,35,93,57,82,46,57,61,31,74,27,4,32,85,53,86,53,53,42,5,28,50,65,63,70,61,73,37,13,80,7,34,22,3,26,6,62,78,12,56,87,41,58,64,31,27,45,35,18,66,62,43,89,69,94,93,33,74,2,43,85,37,82,41,74,9,15,44,33,42,65,19,1,49,78,12,29,9,78,7,55,12,45,40,33,16,86,14,52,16,73,76,0,98,75,91,78,46,99,95,90,69,78,45,62,55,37,88,49,77,27,83,38,73,39,1,75,40,65,83,54,95,7,73,4,30,26,36,89,21,5,95,11,14,87,45,36,21,77,55,5,66,51,98,48,62,74,58,23,82,30,28,19,53,89,76,98,8,34,70,28,54,16,52,35,93,54,54,72,49,18,93,72,90,71,73,15,60,38,80,76,53,70,39,69,25,5,31,61,46,6,54,34,31,52,33,36,79,76,44,29,28,38,1,66,2,90,91,1,76,78,31,55,37,71,2,3,38,85,0,95,42,2,39,57,87,61,77,98,2,24,80,48,27,47,71,15,7,49,60,86,3,2,29,38,54,36,59,83,27,47,9,36,42,8,73,85,9,16,73,60,39,12,43,25,23,29,28,47,40,77,20,89,22,30,41,59,96,19,56,20,76,73,39,46,72,40,47,37,52,29,79,37,39,50,41,87,66,17,75,31,45,26,88,70,11,90,40,74,9,32,65,72,61,6,93,54,15,84,22,99,47,10,96,4,84,19,85,73,45,25,16,8,94,99,39,28,26,68,87,48,1,65,86,46,86,7,60,82,45,75,38,56,41,35,30,86,91,97,85,45,5,14,69,85,96,37,18,26,16,38,16,1,44,94,85,58,60,20,5,47,52,41,50,71,43,42,67,64,38,65,83,99,78,96,33,20,98,24,6,2,25,16,16,44,63,24,68,56,49,91,15,59,99,27,43,34,28,36,45,1,10,19,54,26,75,17,88,96,63,24,71,93,72,97,66,87,18,86],this.randomCache={},this.rndIndex=0}nextRandom(e){const{randomCache:t}=this;let n;return t[e]?n=t[e]:(n=this.random100.filter((t=>t<e)),t[e]=n),n[this.rndIndex++%n.length]}reset(){this.rndIndex=0}fromArray(e){return e[this.nextRandom(e.length)]}randomArray(e,t){const n=[],i=this.nextRandom(t+1),r={};for(let t=0,s=this.nextRandom(e.length);t<i;t++){for(;r[s];)s=this.nextRandom(e.length);r[s]=!0,n.push(e[s])}return n}}Ah._$name="RandomGenerator";const Ph=["Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.","Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.","Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.","Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui atione voluptatem sequi nesciunt.","Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.","Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?","Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"];class Lh{static reset(){this.rnd.reset(),this.rndTime.reset(),this.rndRating.reset()}static rnd=new Ah;static rndTime=new Ah;static rndRating=new Ah;static rndText=new Ah;static get cities(){return["Stockholm","Barcelona","Paris","Dubai","New York","San Francisco","Washington","Montreal"]}static get namesWithAvatars(){return["Adam","Amit","Angelo","Arcady","Arnold","Barbara","Celia","Chang","Dan","Daniel","Dave","David","Don","Doug","Emilia","George","Gloria","Henrik","Hitomi","James","Jane","Jenny","John","Jong","Karen","Kate","Lee","Linda","Lisa","Lola","Macy","Madison","Malik","Mark","Mary","Maxim","Melissa","Mike","Rob","Steve","Team","Theo"]}static get firstNames(){return["Mike","Linda","Don","Karen","Doug","Jenny","Daniel","Melissa","John","Jane","Theo","Lisa","Adam","Mary","Barbara","James","David"]}static get surNames(){return["McGregor","Ewans","Scott","Smith","Johnson","Adams","Williams","Brown","Jones","Miller","Davis","More","Wilson","Taylor","Anderson","Thomas","Jackson"]}static get teams(){return["Lions","Eagles","Tigers","Horses","Dogs","Cats","Panthers","Rats","Ducks","Cougars","Hens","Roosters"]}static get foods(){return["Pancake","Burger","Fish n chips","Carbonara","Taco","Salad","Bolognese","Mac n cheese","Waffles"]}static get colors(){return["Blue","Green","Red","Yellow","Pink","Purple","Orange","Teal","Black"]}static get skills(){return["JavaScript","CSS","TypeScript","React","Vue","Angular","Java","PHP","Python","C#","C++","BASIC","COBOL","FORTRAN","PASCAL","SQL"]}static get tasks(){return["Meetings","Documentation","Email communication","Project management","Budgeting","Marketing and advertising","Customer service","Research and analysis","Data entry","IT support","Employee management","Sales and business development","Event planning","Graphic design","Writing and editing","Presentation","Travel arrangements and expense management","Training and development","Quality assurance","Customer support","Technical writing","Social media management","Translation","Legal research","Data analysis and visualization","Video editing and production","Network admin","Content creation","Market research","Public relations","Teaching and training","Recruiting","Product development"]}static generateName(){const{namesWithAvatars:e,surNames:t}=this;return`${e[Math.round(Math.random()*(e.length-1))]} ${t[Math.round(Math.random()*(t.length-1))]}`}static*generate(e,t=!1,n=1){let i,r;"object"==typeof e&&(t=e.randomHeight,n=e.initialId??1,i=e.addSkills,r=e.rowCallback,e=e.count);const{rnd:s,rndTime:o,rndRating:a,rndText:l,firstNames:c,surNames:d,teams:u,foods:h,colors:g,cities:m,skills:p}=this;for(let v=0;v<e;v++){var f;const y=s.fromArray(c),b=s.fromArray(d),C=`${y} ${String.fromCharCode(65+v%25)} ${b}`,S=s.nextRandom(60)+1,w=new Date(2019,0,S),D=new Date(2019,0,S+s.nextRandom(30)+2),E={id:n>-1?v+n:void 0,title:"Row "+v,name:C,firstName:y,surName:b,city:s.fromArray(m),team:s.fromArray(m)+" "+s.fromArray(u),age:10+s.nextRandom(80),food:s.fromArray(h),color:s.fromArray(g),score:10*s.nextRandom(100),rank:s.nextRandom(100)+1,start:w,finish:D,time:us.getTime(o.nextRandom(24),5*o.nextRandom(12)),percent:s.nextRandom(100),done:s.nextRandom(100)<50,rating:a.nextRandom(5),active:S>30,relatedTo:Math.min(e-1,v+n+s.nextRandom(10)),notes:Ph[l.nextRandom(7)+1]};i&&(E.skills=s.randomArray(p,"number"==typeof i?i:7));const x=null===(f=r)||void 0===f?void 0:f(E);x&&Object.assign(E,x),t&&(E.rowHeight=5*s.nextRandom(!0===t?20:t)+20),yield E}}static generateData(e,t=!1,n=1,i=!0){let r=e;"object"!=typeof e&&(r={count:e,randomHeight:t,initialId:n,reset:i}),!1!==r.reset&&this.reset(),Lh.overrideRowCount&&(r.count=Lh.overrideRowCount);const s=[],o=this.generate(r);for(let e=0;e<r.count;e++)s.push(o.next().value);return s}static generateEvents({viewStartDate:e,viewEndDate:t,nbrResources:n=50,nbrEvents:i=5,dependencies:r,tickUnit:s="days",minDuration:o=2,maxDuration:a=10,gap:l=1,eventCallback:c}){const d=this.generateData(n),u=[];let h,g;r=[];for(let t=0;t<=n;t++)for(let n=0;n<=i;n++){const i=Math.round(Math.random()*(a-1-o))+o,d=u.length+1;h=0===n?us.add(e,Math.round(3*Math.random())*l,s):us.add(g,l,s),g=us.add(h,i,s),u.push({id:d,name:this.tasks[(t+n)%(this.tasks.length-1)],startDate:h,duration:i,endDate:g,resourceId:t}),null==c||c(u[u.length-1]),r&&t>0&&r.push({id:r.length+1,from:d-1,to:d})}return{resources:d,events:u,dependencies:r}}static generateOneEventPerTickAndResource({startDate:e,endDate:t,nbrResources:n=50,tickUnit:i="days"}){const r=this.generateData(n),s=[],o=us.getDurationInUnit(e,t,i);for(let t=0;t<=n;t++)for(let n=0;n<o;n++)s.push({id:s.length+1,resourceId:t,name:this.tasks[(t+n)%(this.tasks.length-1)],startDate:us.add(e,n,i),duration:1,durationUnit:i});return{resources:r,events:s}}static generateRow(){return Lh.generateData(1,!1,-1,!1)[0]}}Lh._$name="DataGenerator";const Oh=["action","target","to","deltaX","deltaY","x","y","text"];class $h extends(dt(nn())){static configurable={repeat:!0,outerElement:!0,callOnFunctions:!0};construct(e){super.construct(e);const t=this;t.widget&&(t.outerElement=t.widget.element,t.widget.playingDemo=!0),Mn.playingDemo=!0,Object.assign(t,{prevTarget:null,currentStep:0,mouse:ki.createElement({parent:t.outerElement,tag:"div",className:"simulated-mouse"}),timeoutId:null,innerIntervalId:null,mouseOutElements:[]}),t.intervalId=t.setInterval(t.nextStep.bind(t),1e3),t.outerElement.classList.add("b-playing-demo"),t.outerElement.addEventListener("click",(e=>{e.isTrusted&&t.abort()}))}doDestroy(){this.abort()}changeOuterElement(e){return!0===e?document.body:e}abort(e=!1){const t=this;t.mouse.style.top="-100px",t.clearInterval(t.intervalId),t.timeoutId&&t.clearTimeout(t.timeoutId),t.innerIntervalId&&t.clearInterval(t.innerIntervalId),t.outerElement.classList.remove("b-playing-demo"),t.widget&&(t.widget.playingDemo=!1),Mn.playingDemo=!1,t.trigger(e?"done":"abort")}triggerEvent(e,t,n){if(!e)return null;let i;if(t.startsWith("mouse")){const e=this.mouse.getBoundingClientRect();i=new MouseEvent(t,Object.assign({view:globalThis,bubbles:!0,cancelable:!0,clientX:e.left,clientY:e.top},n||{}))}else i=document.createEvent("Event"),i.initEvent(t,!0,!1);return e.dispatchEvent(i),i}handleMouseMove(e,t){const n=this,i=n.mouse;i.classList.add("quick"),n.mouseDown&&i.classList.add("drag");const r=_t.from(i,n.outerElement),s=r.x,o=r.y;let a=0,l=0;if(e.to)if("string"==typeof e.to){const t=n.outerElement.querySelector(e.to);if(t){const e=_t.from(t,n.outerElement),i=e.x+e.width/2,r=e.y+e.height/2;a=(i-s)/10,l=(r-o)/10}}else e.to.x?a=(e.to.x-s)/10:(a=e.to[0]/10,l=e.to[1]/10);else e.deltaX?a=e.deltaX/10:e.x&&(a=(e.x-s)/10);e.deltaY&&(l=e.deltaY/10);let c=0;n.innerIntervalId=n.setInterval((()=>{if(n.shouldPause)return;9==c++&&(clearInterval(n.innerIntervalId),e.then&&e.then());const t=s+a*c,r=o+l*c;i.style.left=t+"px",i.style.top=r+"px";const d=i.getBoundingClientRect(),u=d.left,h=d.top,g=ki.elementFromPoint(u,h);g!==n.prevTarget&&(n.prevTarget&&(n.mouseOutElements.push(n.prevTarget),ki.isDescendant(n.mouseOutElements[0],g)||(n.mouseOutElements.forEach((e=>n.triggerEvent(e,"mouseout"))),n.mouseOutElements.length=0)),n.prevTarget=g,n.triggerEvent(g,"mouseover")),n.triggerEvent(g,e.action,{clientX:u,clientY:h})}),50)}getTarget(e){const t=this,n=e.target;return n?"function"==typeof n?n(e):document.querySelector(n):t.prevTarget||t.outerElement}normalizeStep(e){if(e.action)return"function"==typeof e.action?e.action(e):e;if("function"==typeof e)return e(),e;for(const t in e)Object.hasOwnProperty.call(e,t)&&!Oh.includes(t)&&(e.action=t.toLowerCase(),e.to=e[t]);return e.target||"string"!=typeof e.to&&"function"!=typeof e.to||(e.target=e.to),e}get isScrolling(){const e=this,t=e.outerElement.getBoundingClientRect(),n=e.lastTop&&t.top!==e.lastTop;return e.lastTop=t.top,n}get isInView(){const e=this.outerElement.getBoundingClientRect();return e.top<globalThis.innerHeight&&e.bottom>0}get shouldPause(){return!this.isInView||this.isScrolling||document.hidden||!document.hasFocus()}nextStep(){const e=this;if(e.shouldPause)return;if(e.currentStep===e.steps.length){if(!e.repeat)return e.abort(!0);e.currentStep=0}0===e.currentStep&&e.trigger("initialize");const t=e.mouse,n=e.normalizeStep(e.steps[e.currentStep++]),i=e.getTarget(n),r=n.action;if(i&&r)if(t.className="simulated-mouse","mousemove"===r)e.handleMouseMove(n,i);else{if(i!==e.prevTarget){const n=_t.from(i,e.outerElement);t.style.left=n.x+n.width/2+"px",t.style.top=n.y+n.height/2+"px"}"mousedown"===r&&(e.mouseDown=!0),"mouseup"===r&&(e.mouseDown=!1),e.timeoutId=e.setTimeout((()=>{if(e.prevTarget=i,t.classList.add(r),"type"===r){const e=hd.fromElement(i),t=n.text.split("|");e.value=t[1===t.length||e.value!=t[0]?0:1]}else e.triggerEvent(i,r)}),"type"===r?100:550)}}}$h._$name="DemoBot";const{defineProperty:_h}=Object,jh=Symbol("fencible"),Bh=[],Vh=e=>Array.from(new Set(e)),Hh=e=>e?Vh(V.split(e)):Bh;var zh=e=>class extends(e||tt){static $name="Fencible";static declarable=["fenced"];static setupFenced(e,t){const{fenced:n}=e,i=t.getInherited("fenced");let r,s,o,a,l;for(a in n)l=n[a],!0===l&&(l=a),U.isObject(l)||(l={all:l}),r=Hh(l.all),s=Hh(l.any),o=l.lock?Hh(l.lock):Vh(r.concat(s)),s=s.length?s:null,i[a]={any:s,all:r,lock:o}}construct(...e){const t=this,n=Object.getPrototypeOf(t),i=t.$meta.getInherited("fenced"),r=t[jh]={},s=e=>!r[e];return U.forEach(i,(({any:e,all:i,lock:o},a)=>{_h(t,a,{configurable:!0,value(...l){if(i.every(s)&&(!e||e.some(s))){let e;try{for(e of o)r[e]=(r[e]||0)+1;return n[a].apply(t,l)}finally{for(e of o)--r[e]}}}})})),super.construct(...e)}get widgetClass(){}};const{floor:Nh,max:Wh,min:Uh}=Math,Gh=(e,t,n)=>Uh(Wh(e,t),n);class qh extends(tt.mixin(zh)){static configurable={owner:null,drift:null,overflow:null,pos:{value:null,default:0,$config:"lazy"},range:{value:null,$config:"lazy"},scrollSize:null};static fenced={sync:!0};get direction(){const{name:e}=this,{events:t,scrollStarted:n}=this.owner;let i,r,s,o=0;for(i=t.length;i-- >0&&(s=t[i][e],null==r||(o=r-s,!o));)r=s;return o||null==r||(o=r-n[e]),o}get drift(){return this._drift||0}get driftRange(){const{range:e}=this;return[e[0],Wh(e[0],e[1]-this.scrollSize)]}get items(){var e;return null===(e=this.owner)||void 0===e?void 0:e.items}get safeZone(){const{drift:e,scrollSize:t}=this,n=Nh(this.owner.safetyMargin*t);return[e+n,e+t-n]}get scroller(){var e;return null===(e=this.owner)||void 0===e||null===(e=e.client)||void 0===e?void 0:e.scrollable}get scrollLimit(){var e;return null===(e=this.owner)||void 0===e?void 0:e.scrollLimit}get vast(){const{range:e}=this;return!!e&&e[1]-e[0]>this.scrollSize}changePos(e){const{range:t}=this;return Gh(e||0,t[0],t[1])}updatePos(e){this.sync({pos:e})}updateDrift(e){const t=this,{pos:n,range:i}=t,r=n-e;if(t.scrollPos===r){const e=new CustomEvent("scroll",{detail:"driftChange"});t.owner.scroller.element.dispatchEvent(e)}else i[0]<=n&&n<i[1]&&(t.scrollPos=r)}changeRange(e,t){const[n,i]=Array.isArray(e)?e:[0,e],r=[n||0,null==i?1/0:i];if(!t||r[0]!==t[0]||r[1]!==t[1])return r}updateRange(e){this.scrollSize=e[1]-e[0],this.sync({range:e})}changeScrollSize(e){return Uh(e,this.scrollLimit)}snap(){const e=this,{direction:t,items:n,owner:i,pos:r,range:s}=e;let o,a,l,c,d;for(o of n)if([a,l]=e.getItemSpan(o),a<=r&&r<l){a<r?(d=i.snapThreshold,d<1&&(d*=l-a),d=Wh(1,d),c=t<0?l-r>d?a:l:r-a>d?l:a,c=Gh(c,s[0],s[1]),e.pos=c,i.watchForEnd()):i.scrolling=!1;break}}sync(e){const t=Object.assign(this,e),{_drift:n,range:i,vast:r}=t;if(i&&i[0]!==i[1]){let s,{pos:o}=t;const a=o<i[0]||o>=i[1];if((null==o||a)&&(o=i[1]<0?i[0]:Gh(0,i[0],i[1])),r){const{driftRange:e,safeZone:i,scrollSize:r}=t;s=null==n||o<i[0]||o>i[1]?Gh(Nh(o-r/2),e[0],e[1]):n}else s=i[0];t.scroller.positionDirty=!0,t.overflow="hidden-scroll",t.drift=s,s!==n?a?(t.positionDirty=!1,t._pos=null,t.pos=o):t.positionDirty=!0:null!=(null==e?void 0:e.pos)?(t.scrollPos=o-s,t.positionDirty=!0):(t.positionDirty&&(t.positionDirty=!1,t._pos=null),t.pos=t.scrollPos+s),(null!=e&&e.range||s!==n)&&t.owner.syncItems()}else t.overflow="hidden"}toLogical(e){return e+this.drift}toPhysical(e){const t=e-this.drift;return t>=0&&t<this.scrollLimit?t:NaN}}qh.X=class extends qh{get name(){return"x"}get other(){var e;return null===(e=this.owner)||void 0===e?void 0:e.y}get scrollPos(){return Math.round(this.scroller.x)}set scrollPos(e){this.scroller.x=e}get scrollSize(){return this.scroller.scrollWidth}set scrollSize(e){super.scrollSize=e}getItemSpan(e){const t=e.$vxy,{x:n}=t;return[n,n+t.width]}updateScrollSize(e){this.scroller.scrollWidth=e}updateOverflow(e){this.scroller.overflowX=e}},qh.Y=class extends qh{get name(){return"y"}get other(){var e;return null===(e=this.owner)||void 0===e?void 0:e.x}get scrollPos(){return Math.round(this.scroller.y)}set scrollPos(e){this.scroller.y=e}get scrollSize(){return this.scroller.scrollHeight}set scrollSize(e){super.scrollSize=e}getItemSpan(e){const t=e.$vxy,{y:n}=t;return[n,n+t.height]}updateScrollSize(e){this.scroller.scrollHeight=e}updateOverflow(e){this.scroller.overflowY=e}},qh._$name="Axis";const Yh="b-infinity-scroller",Kh=Object.freeze({width:0,height:0}),Xh=(e,t)=>{const n="v"+t;n in e||Object.defineProperty(e,n,{configurable:!0,get(){var e;return null===(e=this.$vxy)||void 0===e?void 0:e[t]},set(e){this.$vxy&&(this.$vxy[t]=e)}})};class Zh extends tt{static configurable={hidden:null,owner:null,widget:null};static prototypeProperties={_height:0,_width:0,_x:0,_y:0};get height(){return this.getDim("height")}get width(){return this.getDim("width")}get x(){return this._x}set x(e){this.moveTo(e)}get xy(){return[this._x,this._y]}set xy(e){this.moveTo(...e)}get y(){return this._y}set y(e){this.moveTo(null,e)}getDim(e){const t=this,{widget:n}=t,i="_"+e;return n?n.monitorResize?n[e]:t[i]||(t[i]=n[e]):0}moveTo(e,t){null!=e&&(this._x=e),null!=t&&(this._y=t),this.sync()}sync(){const e=this,{owner:t,widget:n}=e,{element:i}=n,r=t.x.toPhysical(e.x),s=t.y.toPhysical(e.y),o=isNaN(r+s);e.hidden=o,o?e.size=Kh:i.style.transform=`translate(${r}px, ${s}px)`}updateHidden(e){var t;null===(t=this.widget)||void 0===t||null===(t=t.element)||void 0===t||t.classList.toggle("b-scroll-hidden",e)}updateWidget(e,t){null==t||t.element.classList.remove("b-infinity-scroller-item"),e&&(e.element.classList.add("b-infinity-scroller-item"),Xh(e,"x"),Xh(e,"y"),Xh(e,"xy"))}}class Jh extends(tt.mixin(dt)){static configurable={animate:"smooth",client:null,safetyMargin:.01,scroller:null,scrollIdle:8,scrolling:null,scrollLimit:{value:0,$config:"lazy"},snap:null,snapThreshold:.1,x:{},y:{}};get element(){var e;return null===(e=this.scroller)||void 0===e?void 0:e.element}get events(){return this._events||(this._events=[])}get items(){var e;return((null===(e=this.client)||void 0===e?void 0:e.items)||[]).filter((e=>e.$vxy))}get lastEvent(){var e;return null===(e=this._events)||void 0===e?void 0:e[this._events.length-1]}get pos(){return[this.x.pos,this.y.pos]}changeScrollLimit(e){return e||ki.scrollLimit}updateAnimate(e,t){var n;const i=null===(n=this.element)||void 0===n?void 0:n.classList;t&&(null==i||i.remove(`b-infinity-scroller-${t}`)),e&&(null==i||i.add(`b-infinity-scroller-${e}`))}updateClient(e){this.scroller=(null==e?void 0:e.scrollable)||null}updateScroller(e,t){var n;this.detachListeners("scroller"),null==t||null===(n=t.element)||void 0===n||n.classList.remove(Yh),e&&(e.element.classList.add(Yh),e.ion({thisObj:this,name:"scroller",scroll:"onInternalScroll"}))}changeX(e){return qh.X.new(e,{owner:this})}changeY(e){return qh.Y.new(e,{owner:this})}onInternalScroll(e){const t=this,{lastPos:n,scrolling:i}=t;i||(t.scrolling="maybe"),t.sync();const r=[t.x.pos,t.y.pos];n&&n[0]===r[0]&&n[1]===r[1]?t.scrolling=i:(t.lastPos=r,t.pushEvent(e),i||(t.scrolling=!0),t.triggerScroll("scroll",e))}onInternalScrollEnd(){const e=this,{scrolling:t}=e;t&&("snap"===t?e.updateScrolling(t):e.scrolling=!!e.snap&&"snap")}pushEvent(e){const t=this,{events:n}=t,i={event:e,x:t.x.pos,y:t.y.pos},r=n[n.length-1];if(e.type===(null==r?void 0:r.event.type)&&r.x===i.x&&r.y===i.y)r.event=e;else for(r||(t.scrollStarted=i),n.push(i);n.length>3;)n.shift()}scrollTo(e){const t=this,{scrollingTo:n}=t,i=t.x.pos,r=t.y.pos,s=(null==e?void 0:e.x)??(i+(null==e?void 0:e.dx)||0),o=(null==e?void 0:e.y)??(r+(null==e?void 0:e.dy)||0),a=s-i,l=o-r,c=a||l,d=!1!==(null==e?void 0:e.animate)&&null!==(null==e?void 0:e.animate);if(n){if(n.scroll.x===s&&n.scroll.y===o&&n.scroll.animate===d)return n.promise;n.finish()}const u=t.scrollingTo=El.new();return u.scroll={x:s,y:o,animate:d},c&&t.unanimated(!d,(()=>{a&&(t.x.pos=s),l&&(t.y.pos=o)})),c&&d?(u.cancel=t.ion({once:!0,scrollEnd(){u.resolve(t.x.pos===s&&t.y.pos===o)}}),u.finish=()=>{u.cancel&&(u.cancel(),u.cancel=null,u.resolve(!1),t.scrollStarted=null)}):u.resolve(!0),u.finally((()=>{t.scrollingTo===u&&(t.scrollingTo=null)})),u.promise}suppressAnim(e){const t=this,n=t._suppressAnim||0,i=t._suppressAnim=Math.max(0,n+(e?1:-1));t.scroller.behavior=i?"instant":null}sync(){this.unanimated((()=>{this.x.sync(),this.y.sync()}))}syncItems(){for(const e of this.items)e.$vxy.sync()}triggerScroll(e,t,n=this.x.pos,i=this.y.pos){this.trigger(e,{widget:this.client,relatedEvent:t,x:n,y:i})}updateScrolling(e,t){const n=this,i="maybe"===t,{lastEvent:r}=n;e?i?(n.watchForEnd(),n.scrollEnded=null,n.triggerScroll("scrollStart",r.event,r.x,r.y),n.element.classList.add("b-scrolling")):"snap"===e&&n[n.snap].snap():!t||"driftChange"!==(null==r?void 0:r.event.detail)&&i||(n.scrollEnded=r,n.events.length=0,n.triggerScroll("scrollEnd",r.event,r.x,r.y),n.element.classList.remove("b-scrolling"))}unanimated(e,t){if("function"==typeof e&&(t=e,e=!0),e){this.suppressAnim(!0);try{t()}finally{this.suppressAnim(!1)}}else t()}virtualize(e){"string"==typeof e&&(e=this.client.widgetMap[e]);let t=e.$vxy;var n;t&&t.owner===this||(null===(n=t)||void 0===n||n.destroy(),e.$vxy=t=new Zh({owner:this,widget:e}));return t}watchForEnd(){const e=this,{client:t,scrollIdle:n,scrollStarted:i}=e;let r,s,o=0;!function a(){if(!e.isDestroyed&&!t.isDestroyed&&i===e.scrollStarted){if(s=e.pos,r&&r[0]===s[0]&&r[1]===s[1]){if(++o>=n&&!Hi.hasActiveTouches)return void e.onInternalScrollEnd()}else r=s,o=0;t.requestAnimationFrame(a)}}()}}Jh._$name="InfinityScroller";var Qh=e=>class extends e{static configurable={animate:"smooth",infinityScroller:{value:{},$config:"lazy"},monitorResize:!0,scrollable:{}};static delayable={syncSoon:"raf"};get infinityScrollerDefaults(){return{animate:this.animate}}compose(){return{}}changeInfinityScroller(e,t){return t?t.setConfig(e):t=Jh.new({client:this},this.infinityScrollerDefaults,e),t}onChildAdd(e){var t;return e.innerItem&&(null===(t=this._infinityScroller)||void 0===t||t.virtualize(e)),super.onChildAdd(e)}onInfiniteScroll(){this.syncSoon()}onInfiniteScrollEnd(){this.syncSoon.now()}onInfiniteScrollStart(){}onInternalResize(e,t,n,i,r){super.onInternalResize(e,t,n,i,r),this.hasPainted&&this.syncSoon()}onInternalPaint(e){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,e),e.firstPaint&&(this.syncSoon.now(),this.infinityScroller.ion({thisObj:this,scroll:"onInfiniteScroll",scrollStart:"onInfiniteScrollStart",scrollEnd:"onInfiniteScrollEnd"}))}get scrollingTo(){return this.infinityScroller.scrollingTo}scrollTo(e){return this.infinityScroller.scrollTo(e)}sync(){this.infinityScroller.sync()}syncSoon(){const e=this;e.isPainted&&(e.recompose.flush(),e.infinityScroller.animate=e.animate,e.sync())}unanimated(e,t){return this.infinityScroller.unanimated(e,t)}updateAnimation(){this._infinityScroller&&this.syncSoon()}get widgetClass(){}};class eg extends(tt.mixin(dt,Ls)){static $name="Navigator";static type="navigator";static get configurable(){return{ownerCmp:null,itemsTabbable:null,target:null,keyEventTarget:null,processEvent:null,itemSelector:null,activeItem:null,focusCls:"b-active",keys:null,allowCtrlKey:null,allowShiftKey:null,activateOnMouseover:null,scrollDuration:50,disabled:null,datasetIdProperty:"id",columnCount:null,testConfig:{scrollDuration:1}}}static get factoryable(){return{defaultType:"navigator"}}get activeItem(){const{_activeItem:e}=this;if(this.target.contains(e))return e;this._activeItem=null}updateOwnerCmp(e){this.itemSelector||(this.itemSelector=`.${e.itemCls}:not([data-noselect])`),e.itemsFocusable||ki.setAttributes(this.keyEventTarget,{"aria-activedescendant":`${this.owner.id}-active-descendant`})}set navigationEvent(e){const{owner:t}=this;this._navigationEvent=t.navigationEvent=e,e&&Promise.resolve(1).then((()=>this.navigationEvent=null))}get navigationEvent(){return this._navigationEvent}static getComposedKeyName(e){const t=(e.key||"").trim()||e.code;return`${e.ctrlKey?"CTRL+":""}${e.shiftKey?"SHIFT+":""}${e.altKey?"ALT+":""}${t}`}onKeyDown(e){const t=this,{ownerCmp:n,itemSelector:i,activeItem:r,itemsTabbable:s}=t,{target:o}=e,a=t.firstItem,l=(e.key||"").trim()||e.code,c=t.constructor.getComposedKeyName(e),d=o.matches(i)||o===t.keyEventTarget;if(!t.disabled&&t.processEvent&&(e=t.callback(t.processEvent,t.thisObj||n,[e])),e&&!t.disabled&&a&&t.target.offsetParent&&d){if(!s){if(null==t.inlineFlow){const e=t.itemContainer=a.parentNode,n=ki.getStyleValue(e,"display"),i=ki.getStyleValue(a,"position"),r=ki.getStyleValue(a,"display"),s=ki.getStyleValue(a,"float");t.columnCount||(t.columnCount=ki.getStyleValue(e,"grid-template-columns").split(" ").length),t.inlineFlow="absolute"===i||"inline"===r||"inline-block"===r||"left"===s||"right"===s||"flex"===n&&"row"===ki.getStyleValue(e,"flex-direction")||"grid"===n&&t.columnCount>1,t.columnCount>1&&(t.prevRowKey="ArrowUp",t.nextRowKey="ArrowDown")}t.prevKey||(t.inlineFlow?(t.prevKey="ArrowLeft",t.nextKey="ArrowRight"):(t.prevKey="ArrowUp",t.nextKey="ArrowDown"))}if(t.navigationEvent=e,r&&!t.disabled)switch(l){case t.prevKey:if(e.ctrlKey&&!t.allowCtrlKey||e.shiftKey&&!t.allowShiftKey)return;e.preventDefault(),e.handled=!0,t.navigatePrevious(e);break;case t.nextKey:if(e.ctrlKey&&!t.allowCtrlKey||e.shiftKey&&!t.allowShiftKey)return;e.preventDefault(),e.handled=!0,t.navigateNext(e);break;case t.prevRowKey:{if(e.ctrlKey&&!t.allowCtrlKey||e.shiftKey&&!t.allowShiftKey)return;e.preventDefault();const n=Array.from(t.itemContainer.querySelectorAll(t.itemSelector));t.activeItem=n[Math.max(n.indexOf(r)-t.columnCount,0)],e.handled=!0}break;case t.nextRowKey:{if(e.ctrlKey&&!t.allowCtrlKey||e.shiftKey&&!t.allowShiftKey)return;e.preventDefault();const n=Array.from(t.itemContainer.querySelectorAll(t.itemSelector));t.activeItem=n[Math.min(n.indexOf(r)+t.columnCount,n.length-1)],e.handled=!0}break;default:{var u;const i=null===(u=t.keys)||void 0===u?void 0:u[c];if(i&&!t.disabled){if(!1===t.callback(i,t.thisObj||n,[e,t,r]))return}else n.onInternalKeyDown&&n.onInternalKeyDown(e);if(ki.getActiveElement(o)!==o&&e.preventDefault(),s)return}}else{if(s)return;l!==t.nextKey&&l!==t.prevKey||(t.activeItem=t.getDefaultNavigationItem(e))}t.activeItem!==r&&t.triggerNavigate(e)}}getDefaultNavigationItem(e){const{target:t,itemSelector:n,prevKey:i,nextKey:r}=this;return 4&t.compareDocumentPosition(e.target)&&e.key===i?t.querySelector(`${n}:last-of-type`):2&t.compareDocumentPosition(e.target)&&e.key===r?t.querySelector(`${n}`):void 0}navigatePrevious(e){const t=this,n=t.previous;e.preventDefault(),n&&t.ownerCmp.scrollable.scrollIntoView(n,{animate:t.scrollDuration}).then((()=>{t.activeItem=n,t.triggerNavigate(e)}))}navigateNext(e){const t=this,n=t.next;e.preventDefault(),n&&t.ownerCmp.scrollable.scrollIntoView(n,{animate:t.scrollDuration}).then((()=>{t.activeItem=n,t.triggerNavigate(e)}))}get owner(){return this.ownerCmp}get firstItem(){return this.target.querySelector(this.itemSelector)}get previous(){return this.getAdjacent(-1)}get next(){return this.getAdjacent(1)}getAdjacent(e=1,t=this.activeItem){const n=this.treeWalker;if(n.currentNode=t,n[e<0?"previousNode":"nextNode"](),n.currentNode!==this.activeItem)return n.currentNode}shouldIgnoreFocusIn(e){return this.ignoreEvent===e?(this.ignoreEvent=null,!0):e.target.matches(".b-focus-trap")}onTargetFocusIn(e){const t=this,{target:n,relatedTarget:i}=e,{owner:r,itemsTabbable:s,skipScrollIntoView:o,previousActiveItem:a}=t;if(!t.shouldIgnoreFocusIn(e))if(n.matches(t.itemSelector))t.skipScrollIntoView=!0,t.activeItem=n,t.skipScrollIntoView=o,t.activeItem&&s&&t.triggerNavigate(e);else if(n===t.target){var l;if((i?n.compareDocumentPosition(i):0)&Node.DOCUMENT_POSITION_CONTAINED_BY)null===(l=r.previousSibling)||void 0===l||l.focus();else t.skipScrollIntoView=!0,t.activeItem=a&&t.target.contains(a)?a:0,t.skipScrollIntoView=o}}onTargetFocusOut(e){const t=this,{relatedTarget:n}=e;null!=n&&n.matches(".b-focus-trap")||n&&t.target.contains(n)&&n.matches(t.itemSelector)||t.activeItem&&(t.activeItem=null,t.itemsTabbable&&t.triggerNavigate(e))}onTargetMouseDown(e){const t=this,n=e.target.closest(t.itemSelector);t.navigationEvent=e,t.itemsTabbable?n===t.activeItem&&t.triggerNavigate(e):!1===t.ownerCmp.itemsFocusable?t.onFocusGesture(e):n&&(e.preventDefault(),n.focus({preventScroll:!0}))}onTargetMouseover({target:e}){this.activeItem=e}onTargetClick(e){var t;const n=this,{skipScrollIntoView:i}=n;n.skipNextClick||null!==(t=n.navigationEvent)&&void 0!==t&&t.ignoreNavigation?n.skipNextClick=!1:n.disabled||(n.skipScrollIntoView=n.activateOnMouseover,n.processEvent&&(e=n.callback(n.processEvent,n.thisObj||n.ownerCmp,[e])),e&&(n.activeItem=e.target.closest(n.itemSelector),n.triggerNavigate(e)),n.skipScrollIntoView=i)}onFocusGesture(e){(e.target===this.ownerCmp.contentElement||e.target.closest(this.itemSelector)&&!1===this.ownerCmp.itemsFocusable)&&e.preventDefault()}acceptNode(e){return e.offsetParent&&e.matches&&e.matches(this.itemSelector)?ki.NodeFilter.FILTER_ACCEPT:ki.NodeFilter.FILTER_SKIP}changeActiveItem(e){var t;return null!=e&&(this.ownerCmp.getItem?e=this.ownerCmp.getItem(e):"number"==typeof e&&(e=this.target.querySelector(this.itemSelector+`:nth-child(${e+1})`))),null!==(t=e)&&void 0!==t&&t.matches(this.itemSelector)?e:null}updateActiveItem(e,t){const n=this,{ownerCmp:i}=n,r=t&&n.target.contains(t),s=e&&ki.isFocusable(e)&&e!==ki.getActiveElement(e),o=e===t&&r;if(o||(r&&(n.previousActiveItem=t),t&&(t.classList.remove(n.focusCls),t.removeAttribute("id"))),null!=e){var a;if(n.skipScrollIntoView)s&&e.focus({preventScroll:!0});else null===(a=i.scrollable)||void 0===a||a.scrollIntoView(e,{block:"nearest",focus:s,silent:n.scrollSilently});if(o)return;e.classList.contains(n.focusCls)||e.classList.add(n.focusCls),e.id=`${n.owner.id}-active-descendant`,n._activeItem=e}else n._activeItem=null,t===ki.getActiveElement(t)&&i.revertFocus()}updateTarget(e,t){const n=this,i={element:e,thisObj:n,focusin:"onTargetFocusIn",focusout:"onTargetFocusOut",mousedown:{handler:"onTargetMouseDown",delegate:n.itemSelector}};n.itemsTabbable||n.itemsFocusable||(i.click="onTargetClick"),n.activateOnMouseover&&(i.mouseover={handler:"onTargetMouseover",delegate:n.itemSelector,delay:30}),Object.prototype.hasOwnProperty.call(n,"acceptNode")||(n.acceptNode=n.acceptNode.bind(n)),Mn.on(i),n.treeWalker=n.setupTreeWalker(e,ki.NodeFilter.SHOW_ELEMENT,n.acceptNode),n.keyEventTarget||(n.keyEventTarget=e),(n.targetMutationMonitor=new MutationObserver(n.onTargetChildListChange.bind(n))).observe(e,{childList:!0,subtree:!0})}setupTreeWalker(e,t,n){return document.createTreeWalker(e,t,n)}onTargetChildListChange(){const e=this,{activeItem:t,datasetIdProperty:n}=e;var i;t&&(e.target.contains(t)?t.classList.contains(e.focusCls)||t.classList.add(e.focusCls):e.activeItem=e.target.querySelector(`${e.itemSelector}.${e.focusCls}[data-${V.hyphenate(n)}="${t.dataset[n]}"]`)||(null===(i=e.target.querySelector(`${e.itemSelector}.${e.focusCls}`))||void 0===i?void 0:i[t.dataset.index])||null)}updateKeyEventTarget(e){var t;null===(t=this.keyListenerRemover)||void 0===t||t.call(this),this.keyListenerRemover=Mn.on({element:e,keydown:"onKeyDown",thisObj:this})}triggerNavigate(e,t=this.activeItem){var n;const i={event:e,item:t,oldItem:this.previousActiveItem};this.trigger("navigate",i),null===(n=this.ownerCmp)||void 0===n||n.trigger("navigate",i)}}eg._$name="Navigator";class tg extends(tt.mixin(dt)){hasNativeAccess=!0;_content=null;async writeText(e,t){const n=this,{_content:i}=n;if(t&&n.hasNativeAccess)try{await navigator.clipboard.writeText(e)}catch(e){n.hasNativeAccess=!1}i!==e&&(n._content=e,n.triggerContentChange(i,!1,!0))}writeData(e,t){this._dataContent=e,this._contentSource=t}async readText(e){const t=this,{_content:n}=t;if(e&&t.hasNativeAccess)try{const e=await navigator.clipboard.readText();return n!==e&&(t._content=e,t._dataContent=t._contentSource=null,t.triggerContentChange(n,!0)),e}catch(e){t.hasNativeAccess=!1}return n}readData(e){if(!e||rt.asArray(e).includes(this._contentSource))return this._dataContent}triggerPaste(e){this.trigger("paste",{source:e,text:this._content})}triggerContentChange(e,t=!1,n=!1){this.trigger("contentChange",{fromRead:t,fromWrite:n,oldText:e,newText:this._content})}async clear(e){await this.writeText("",e),this.writeData(null)}}var ng=e=>class extends(e||tt){static $name="Clipboardable";static configurable={useNativeClipboard:!1,allowedDataSources:null};construct(...e){super.construct(...e),globalThis.bryntum.clipboard||(globalThis.bryntum.clipboard=new tg),globalThis.bryntum.clipboard.ion({paste:"onClipboardPaste",contentChange:"onClipboardContentChange",thisObj:this})}get clipboard(){return globalThis.bryntum.clipboard}onClipboardPaste({text:e,source:t}){const n=this,{clipboardText:i,isCut:r}=n,s=n.compareClipboardText(i,e);var o;s&&r?(null===(o=n.handleCutData)||void 0===o||o.call(n,{text:e,source:t}),n.isCut=!1,n.cutData=null):s||n.clearClipboard(!1)}onClipboardContentChange({newText:e}){this.compareClipboardText(this.clipboardText,e)||this.clearClipboard(!1)}set cutData(e){var t,n;const i=this;null===(t=i._cutData)||void 0===t||t.forEach((e=>i.setIsCut(e,!1))),i._cutData=rt.asArray(e),null===(n=i._cutData)||void 0===n||n.forEach((e=>i.setIsCut(e,!0)))}get cutData(){return this._cutData}async writeToClipboard(e,t,n={}){if(!1===await this.beforeCopy({data:e,isCut:t,...n}))return;const i=this,r="string"==typeof e,s=r?e:i.stringConverter?i.stringConverter(e):V.safeJsonStringify(e),o=r?s:i.cloneData?i.cloneData({data:e,stringData:s,isPaste:!1}):U.clone(e);return i.clipboardText=s,i.clipboard.writeData(o,i.$$name),await i.clipboard.writeText(s,i.useNativeClipboard),i.clipboardData=o,i.originalData=e,i.isCut=t,i.cutData=t&&!r?e:null,{data:t?e:o,clonedData:o,originalData:e,stringData:s}}async readFromClipboard(e={},t=!1){var n;const i=this,{clipboard:r}=i,s=await r.readText(i.useNativeClipboard),o=i.compareClipboardText(i.clipboardText,s),a=o?i.originalData:[];let l=r.readData(i.allowedDataSources);o||i.clearClipboard(!1);const{isCut:c}=i;if(!c&&l&&l!==s||(l=i.transformClipboardText(s)),l&&!c&&"string"!=typeof l&&i.cloneData&&(l=i.cloneData({data:l,isPaste:!0})),!(null==l||Array.isArray(l)&&0===l.length||!1===await(null===(n=i.beforePaste)||void 0===n?void 0:n.call(i,{data:l,text:s,originalData:a,...e,isCut:c,isOwn:o}))))return t||r.triggerPaste(i),{data:l,text:s,isOwn:o,isCut:c,originalData:a}}async clearClipboard(e=!0){const t=this;t.clipboardData=t.originalData=t.clipboardText=t.cutData=null,t.isCut=!1,e&&await t.clipboard.clear(t.useNativeClipboard)}compareClipboardText(e,t){const n=/\r\n|(?!\r\n)[\n-\r\x85\u2028\u2029]/g;return(null==e?void 0:e.replace(n,"\n"))===(null==t?void 0:t.replace(n,"\n"))}transformClipboardText(e){const t=this;return t.compareClipboardText(t.clipboardText,e)?t.isCut?t.originalData:t.clipboardData:t.stringParser&&e?t.stringParser(e):e}hasClipboardData(){const{clipboard:e}=this,{_content:t}=e;if(!this.useNativeClipboard||!e.hasNativeAccess)return Boolean(t&&this.transformClipboardText(t))}},ig=e=>class extends(e||tt){static $name="Finalizable";construct(...e){super.construct(...e),this.finalizer=null,this.finalizing=null,this.isFinalized=!1,this.isFinalizing=!1}doFinalize(){this.destroy()}finalize(){const e=this;let t=e.finalizing;return t||e.isFinalized||(e.isFinalizing=!0,e.finalizing=t=e._awaitFinalizer()),t}async _awaitFinalizer(){const e=this;try{await e.finalizer}finally{e.finalizing=null,e.isFinalized=!0,e.doFinalize()}}};const rg=Symbol("dragAbort"),sg=Symbol("dragInit"),og=Symbol("dragDrag"),ag=Symbol("dragDrop"),lg={x:"horizontal",y:"vertical"};class cg extends(tt.mixin(ig,nn,on)){static $name="DragContext";static get configurable(){return{itemElement:null,scrollManager:null,monitoringConfig:null,source:null,target:null,targetElement:null,threshold:5,touchStartDelay:300,event:null}}static get identifiable(){return{}}construct(...e){super.construct(...e);const t=this,{event:n}=t;Object.assign(t,{altKey:null,cleaners:[],ctrlKey:null,data:new Map,element:n.target,endEvent:null,lastMoveEvent:null,metaKey:null,previousTarget:null,scrollerAction:null,shiftKey:null,state:sg,startEvent:n,touchStartTimer:null,_valid:!0}),"touches"in n&&t.touchStartDelay&&(t.touchStartTimer=t.setTimeout((()=>t.touchStartTimer=null),t.touchStartDelay,"touchStartDelay"));const i=globalThis;Mn.on({element:i,blur:"onWindowBlur",thisObj:t,autoDetach:!0})}doDestroy(){const e=this,{source:t,target:n}=e;e.cleanup(),(null==n?void 0:n.dropping)===e&&(n.dropping=null),(null==t?void 0:t.dragging)===e&&(t.dragging=null),super.doDestroy()}onWindowBlur(){this.started&&!this.completed&&this.abort()}get aborted(){return this.state===rg}get completed(){return this.isDestroying||this.aborted||null!==this.endEvent}get pending(){return this.state===sg}get started(){return this.state!==sg&&!this.aborted}get valid(){return this.started&&null!=this.targetElement&&this._valid}set valid(e){this._valid=e}async get(e){if(this.aborted)throw new Error("Data is not available on aborted drag");if(!this.completed)throw new Error("Data is not available until drag completion");if(Array.isArray(e))return Promise.all(e.map((e=>this.get(e))));let t=this.data.get(e);return"function"==typeof t&&(t=await t(),this.data.set(e,t)),t}has(e){return this.data.has(e)}peek(e){if(this.aborted)throw new Error("Data is not available on aborted drag");if(Array.isArray(e))return e.map((e=>this.peek(e)));let t=this.data.get(e);return"function"==typeof t&&(t=!0),t}set(e,t){this.data.set(e,t)}changeTarget(e,t){if(e!==t){const n=this;n._target=e,n.previousTarget=t,t&&(t.dropping=null),e&&(e.dropping=n,e.dropping!==n&&(e=null,n.valid=!1)),n._target=t}return e}updateTarget(e,t){const n=this;t&&n.source.dragLeaveTarget(n,t),e&&(n.valid=!0,e.dragMove(n),n.source.dragEnterTarget(n))}updateTargetElement(e){let t,n,i,r,s;for(s=e;s;s=s.parentElement)if(n=Ul.get(s,"droppables"),n)for(r=0;r<n.length;++r)if(t=n[r],t.dropRootElement.contains(e)&&(i=t.droppableSelector,(!i||e.closest(`#${ki.getId(t.dropRootElement)} ${i}`))&&(this.target=t,this.target===t)))return}abort(){const e=this,{element:t,source:n}=e;null==t||t.getBoundingClientRect(),e.state!==ag&&(e.state=rg,e.cleanup()),null==n||n.endDrag(e)}begin(){const e=this,{source:t}=e,n=t.beforeDrag(e);return!1!==n&&(t.dragging=e),n}cleanup(){let e;for(;e=this.cleaners.pop();)e()}end(e){const t=this,{lastMoveEvent:n,target:i}=t,{dragSwallowClickTime:r}=t.source;if(t.event=t.domEvent=t.endEvent=e,t.syncFlags(),t.started){if((null==n?void 0:n.clientX)===e.clientX&&(null==n?void 0:n.clientY)===e.clientY&&(null==n?void 0:n.target)===e.target||t.track(),r){const e=globalThis;Mn.on({element:e,capture:!0,expires:r,once:!0,click(e){e.stopPropagation()}})}t.state=ag,i!==t.source&&(null==i||i.dragDrop(t))}}fakeKey(e,t){const n=this,{lastMoveEvent:i}=n;if(i&&n.element){let r;i.isKey=!0,"Alt"===e.key?n.altKey!==t&&(n.altKey=t,r=!0):"Control"===e.key&&n.ctrlKey!==t&&(n.ctrlKey=t,r=!0),r&&(n.event=n.domEvent=i,n.track())}}keyDown(e){this.completed||("Escape"===e.key?this.abort():this.isDragToggleKey(e.key)&&this.fakeKey(e,!0))}keyUp(e){!this.completed&&this.isDragToggleKey(e.key)&&this.fakeKey(e,!1)}getDistance(e){return Mn.getDistanceBetween(this.startEvent,e)}isDragToggleKey(e){return"Control"===e||"Alt"===e}move(e){const t=this,{target:n}=e,i=t.getDistance(e)>=t.threshold;if(t.syncFlags(),t.touchStartTimer)i&&t.abort();else if(n&&n.nodeType===Node.ELEMENT_NODE&&n.isConnected){if(i&&!t.started&&(t.event=t.domEvent=e,!1===t.start()))return void t.abort();e.touches&&(t.startEvent.preventDefault(),e.preventDefault(),e.stopPropagation()),t.started&&!t.completed&&(t.lastMoveEvent=t.event=t.domEvent=e,"touchmove"===e.type&&(e.preventDefault(),e.stopImmediatePropagation()),t.track())}}start(){const e=this,{scrollManager:t,monitoringConfig:n,source:i}=e,{draggingBodyCls:r,dragLock:s}=i,o=i.dragRootElement;if(e.state=og,t){const i=t.startMonitoring(C.merge({scrollables:[{element:o}],direction:lg[s]||s||"both",callback(t){const{lastMoveEvent:n}=e;n&&e.element&&(n.isScroll=!0,e.event=e.domEvent=n,e.scrollerAction=t,e.track(),e.scrollerAction=null)}},n));e.cleaners.push(i)}const a=i.dragRootElement.closest(".b-outer")||document.body;if(a.classList.add(r),e.cleaners.push((()=>a.classList.remove(r))),!1===i.startDrag(e))return e.cleanup(),!1}syncFlags(){const e=this,{event:t}=e;e.altKey=t.altKey,e.ctrlKey=t.ctrlKey||t.metaKey,e.metaKey=t.metaKey,e.shiftKey=t.shiftKey}track(){const e=this,{event:t,source:n,target:i}=e;let r,s=t.target;"touchmove"===t.type&&(r=t.changedTouches[0],s=ki.elementFromPoint(r.clientX,r.clientY)),e.targetElement=s,i===e.target&&(null==i||i.dragMove(e)),n.trackDrag(e)}}cg.prototype.STATE=cg.STATE=Object.freeze({ABORTED:rg,INIT:sg,DRAGGING:og,DROPPED:ag}),cg._$name="DragContext";class dg extends(tt.mixin(Ls)){static type="default";static get configurable(){return{dragging:null}}static get factoryable(){return{defaultType:dg}}updateDragging(e,t){t&&this.close(t),e&&this.open(e)}close(e){}open(e){}dragStart(e){this.dragging=e}dragMove(e){}dragEnd(e){this.dragging=null}}dg.initClass(),dg._$name="DragProxy";var ug=e=>class extends(e||tt){static $name="Draggable";static configurable={dragging:{$config:"nullify",value:null},draggingClsSelector:null,dragDocumentListeners:{element:document,keydown:"onDragKeyDown",keyup:"onDragKeyUp",contextmenu:"onDragContextMenu",mousemove:"onDragPointerMove",mouseup:"onDragPointerUp",pointerup:"onDragPointerUp",touchend:"onDragPointerUp",touchmove:{handler:"onDragPointerMove",passive:!1}},dragItemSelector:null,dragItemOverCls:null,dragLock:null,dragMinDistance:1,dragProxy:{$config:["lazy","nullify"],value:null},dragRootElement:{$config:"nullify",value:null},dragSameTargetDrop:!1,dragSelector:null,ignoreSelector:null,dragSwallowClickTime:50,dragThreshold:5,dragTouchStartDelay:300,dropTargetSelector:null,overItem:null,testConfig:{dragSwallowClickTime:50}};static properties={draggingCls:"b-draggable-active",draggingBodyCls:"b-draghelper-active",draggingItemCls:"b-dragging-item",draggingStartedCls:"b-draggable-started",draggableCls:"b-draggable"};beforeDrag(e){const{dragRootElement:t,dragSelector:n,ignoreSelector:i}=this,r=n&&e.element.closest(n);return!n||Boolean(r&&r===t||t.contains(r)&&(!i||!e.element.matches(i)))}dragStart(e){}dragOver(e){}dragEnterTarget(e){}dragLeaveTarget(e,t){}async dragDrop(e){}dragEnd(e){}get activeDrag(){const{dragging:e}=this;return null!=e&&e.started&&!e.completed?e:null}get dragEventer(){return this.trigger?this:null}get draggingClassElement(){const{draggingClsSelector:e,dragRootElement:t}=this;return e?null==t?void 0:t.closest(e):t}beginDrag(e){const{draggingCls:t,draggingClassElement:n}=this;t&&n&&(n.classList.add(t),e.cleaners.push((()=>n.classList.remove(t))))}async endDrag(e){const t=this,{dragEventer:n,dragProxy:i}=t;e.valid&&await t.dragDrop(e),t.isDestroyed||(e.pending?e.destroy():(t.dragEnd(e),null==i||i.dragEnd(e),null==n||n.trigger(e.valid?"drop":"dragCancel",{drag:e,event:e.event}),t.finalizeDrag(e)))}async finalizeDrag(e){var t;await(null===(t=e.finalize)||void 0===t?void 0:t.call(e))}moveDrag(e){if(!1!==this.dragOver(e)){const{dragEventer:t,dragProxy:n}=this;null==n||n.dragMove(e),null==t||t.trigger("drag",{drag:e,event:e.event})}}setupDragContext(e){const t=this,{dragItemSelector:n,id:i}=t,{target:r}=e;return{event:e,id:i?`${i}-drag-${t._nextDragId=(t._nextDragId||0)+1}`:null,itemElement:n?r.closest(n):r,touchStartDelay:t.dragTouchStartDelay,source:t,threshold:t.dragThreshold}}startDrag(e){const{draggingStartedCls:t,draggingClassElement:n,draggingItemCls:i,dragEventer:r,dragProxy:s}=this,{itemElement:o}=e;if(!1===(null==r?void 0:r.trigger("beforeDragStart",{drag:e,event:e.event})))return!1;t&&n&&(n.classList.add(t),e.cleaners.push((()=>n.classList.remove(t)))),i&&o&&(o.classList.add(i),e.cleaners.push((()=>o.classList.remove(i)))),null==s||s.dragStart(e);const a=this.dragStart(e);return!1!==a&&(null==r||r.trigger("dragStart",{drag:e,event:e.event})),a}trackDrag(e){var t;const{dropTargetSelector:n}=this;e.valid=!(n&&(null===(t=e.targetElement)||void 0===t||!t.closest(n))),this.moveDrag(e)}configureListeners(e){const t=this,n=U.assign({thisObj:t},t.dragDocumentListeners);return"touches"in e.startEvent?(delete n.mousemove,delete n.mouseup):(delete n.contextmenu,delete n.touchmove,delete n.touchend,delete n.pointerup),n.element=ki.getRootElement(t.dragRootElement),n}updateDragging(e,t){const n=this;if(e){const t=n.configureListeners(e);e.cleaners.push(Mn.on(t)),n.beginDrag(e)}else t&&t.destroy()}changeDragProxy(e,t){return dg.reconfigure(t,e,{owner:this,defaults:{owner:this}})}updateDragRootElement(e,t){var n;const i=this,{draggableCls:r,dragItemSelector:s,onDragItemMouseMove:o}=i;if(null==t||t.classList.remove(r),null===(n=i._dragRootDetacher)||void 0===n||n.call(i),e){const t={thisObj:i,element:e,mousedown:"onDragMouseDown",touchstart:"onDragTouchStart",pointerdown:e=>{var t,n;return e.pointerId&&(null===(t=(n=e.target).releasePointerCapture)||void 0===t?void 0:t.call(n,e.pointerId))}};o&&(t.mousemove={delegate:s,handler:"onDragItemMouseMove"}),(i.dragItemOverCls||o||i.onDragItemMouseEnter||i.onDragItemMouseLeave)&&Object.assign(t,{mouseover:{delegate:s,handler:"onDragItemMouseOver"},mouseout:{delegate:s,handler:"onDragItemMouseOut"}}),e.classList.add(r),i._dragRootDetacher=Mn.on(t)}}onDragItemMouseOver(e){this.overItem=e}onDragItemMouseOut(e){this.dragging||(this.overItem=e)}changeOverItem(e){var t;return this.enterLeaveEvent=e,"mouseout"===e.type?(null===(t=e.relatedTarget)||void 0===t?void 0:t.closest(this.dragItemSelector))||null:e.target.closest(this.dragItemSelector)}updateOverItem(e,t){const n=this,{dragItemOverCls:i}=n;var r,s;t&&(i&&t.classList.remove(i),null===(r=n.onDragItemMouseLeave)||void 0===r||r.call(n,n.enterLeaveEvent,t));e&&(i&&e.classList.add(i),null===(s=n.onDragItemMouseEnter)||void 0===s||s.call(n,n.enterLeaveEvent,e))}onDragContextMenu(e){e.preventDefault()}onDragKeyDown(e){this.dragging.keyDown(e)}onDragKeyUp(e){this.dragging.keyUp(e)}onDragMouseDown(e){0===e.button&&this.onDragPointerDown(e)}onDragPointerDown(e){let{dragging:t}=this;t?t.isFinalizing||t.abort():(t=this.setupDragContext(e),t&&(t=new cg(t),!1===t.begin()&&t.destroy()))}changeDragging(e,t){return null==t||t.destroy(),e}onDragPointerMove(e){const{changedTouches:t}=e,{dragging:n}=this;!n||n.completed||t&&1!==t.length||null==n||n.move(e)}onDragPointerUp(e){const{dragging:t}=this;t&&!t.completed&&(t.end(e),this.endDrag(t))}onDragTouchStart(e){1===e.touches.length&&this.onDragPointerDown(e)}},hg=e=>class extends(e||tt){static $name="Droppable";static get configurable(){return{droppableSelector:null,dropping:null,dropRootElement:{$config:"nullify",value:null}}}get dropEventer(){return this.trigger?this:null}get droppableCls(){return"b-droppable"}dragEnter(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("dragEnter",{drag:e,event:e.event})}dragMove(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("dragMove",{drag:e,event:e.event})}dragDrop(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("drop",{drag:e,event:e.event})}dragLeave(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("dragLeave",{drag:e,event:e.event})}changeDropping(e,t){if(e!==t){const n=this;t&&(!t.aborted&&t.completed||n.dragLeave(t)),e&&(n._dropping=e,!1===n.dragEnter(e)&&(e=null),n._dropping=t)}return e}updateDropRootElement(e,t){const n=this,{droppableCls:i}=n;let r,s,o;t&&(r=Ul.get(t,"droppables"),o=!0,Array.isArray(r)&&(s=r.indexOf(n))>-1&&(r.length<2?Ul.remove(t,"droppables"):(r.splice(s,1),r.forEach((e=>{i===e.droppableCls&&(o=!1)})))),o&&t.classList.remove(i)),e&&(r=Ul.get(e,"droppables"),r?r.push(n):Ul.set(e,"droppables",[n]),e.classList.add(i))}};const gg="b-hover-edge",mg="b-hover-top",pg="b-hover-right",fg="b-hover-bottom",vg="b-hover-left",yg={[gg]:1,[mg]:1,[pg]:1,[fg]:1,[vg]:1},bg={t:[gg,mg],r:[gg,pg],b:[gg,fg],l:[gg,vg],tr:[gg,mg,pg],bl:[gg,fg,vg],tl:[gg,mg,vg],br:[gg,fg,pg]};var Cg=e=>class extends e{static $name="LoadMaskable";static get configurable(){return{loadMaskDefaults:{useTransition:!0,showDelay:1e3},loadMaskError:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},loadMask:{text:"L{GridBase.loadMask}"},syncMask:{text:"L{GridBase.syncMask}"},localizableProperties:["loadMask.text","syncMask.text"],testConfig:{loadMaskError:{icon:"b-icon b-icon-warning",autoClose:500,showDelay:0}}}}applyLoadMask(){const e=this,{loadMask:t}=e;return t&&(e.masked=Cd.mergeConfigs(e.loadMaskDefaults,t)),e.masked}applyMaskError(e){const{loadMaskError:t,masked:n}=this;return!1===t?n.hide():n&&(U.assign(n.errorDefaults,t),n.error=e),n}get widgetClass(){}};const Sg={constructor:1,prototype:1,name:1,length:1,arguments:1,caller:1,callee:1,__proto__:1};class wg{static apply(e){if(!e.target)throw new Error("Override must specify what it overrides, using static getter target");if(!e.target.class)throw new Error("Override must specify which class it overrides, using target.class");if(!this.shouldApplyOverride(e))return!1;const t=Object.getOwnPropertyNames(e),n=Object.getOwnPropertyNames(e.prototype);return t.splice(t.indexOf("target"),1),this.internalOverrideAll(e.target.class,t,e),this.internalOverrideAll(e.target.class.prototype,n,e.prototype),!0}static internalOverrideAll(e,t,n){Reflect.ownKeys(n).forEach((i=>{if(t.includes(i)&&!Sg[i]){const t=Object.getOwnPropertyDescriptor(n,i);let r=e,s=null;for(;!s&&r;)s=Object.getOwnPropertyDescriptor(r,i),s||(r=Object.getPrototypeOf(r));s&&this.internalOverride(r,i,t,s)}}))}static internalOverride(e,t,n,i){(e._overridden=e._overridden||{})[t]=e[t],i.get?Object.defineProperty(e,t,{enumerable:!1,configurable:!0,get:n.get}):e[t]=n.value}static shouldApplyOverride(e){const t=e.target;if(!t.maxVersion&&!t.minVersion)return!0;if(!t.product)throw new Error("Override must specify product when using versioning");return(!t.maxVersion||!q[t.product].isNewerThan(t.maxVersion))&&(!t.minVersion||!q[t.product].isOlderThan(t.minVersion))}}wg._$name="Override";const Dg=6e4,Eg=36e5,xg=864e5,Rg=/(\d+)?:?(\d*)/;class Tg{static format(e){const t=Math.floor(e/Eg),n=Math.floor(e/Dg)%60;return`${t}:${n<10?"0":""}${n}`}static parse(e){const t=typeof e;if("string"===t){const t=Rg.exec(e);e=Number(t[1]||0)*Eg+Number(t[2]||0)*Dg}else"number"!==t?e=us.getTimeOfDay(e):e<=24&&(e*=Eg);return Math.min(Math.max(Math.floor(e),0),xg)}constructor(e){let t,n,i=0;null!=e&&e.isDayView?(i=e.dayStartShift,t=e.dayStartTime,n=e.dayEndTime):"number"==typeof e?i=t=n=e:e&&(i=e.startShift,t=e.timeStart,n=e.timeEnd),this.startShift=i=Tg.parse(i||0),this.timeEnd=(null==n?(i+xg)%xg:Tg.parse(n))||xg,this.timeStart=null==t?i:Tg.parse(t)}get startHour(){return Math.floor(this.timeStart/Eg)}get endHour(){return Math.floor(this.timeEnd/Eg)}get startTimeOffsetMs(){const{startShift:e,timeStart:t}=this;return t<e?xg-e+t:t-e}get today(){return this.startOfDay(new Date)}ceil(e){const t=this.startOfDay(e);return t<e&&t.setDate(t.getDate()+1),t}contains(e){return!this.outside(e)}dateKey(e){return e=this.shiftDate(e,-1),us.makeKey(e)}dayOfDate(e){return this.shiftDate(us.clearTime(e))}dayOfWeek(e){return(e=this.shiftDate(e,-1)).getDay()}delta(e,t="ms"){const{timeStart:n}=this,i=Tg.parse(e),r=(this.startShift&&i<n?i+xg:i)-n;return"ms"===t?r:us.as(t,r,"ms")}duration(e="ms"){const{timeStart:t,timeEnd:n}=this,i=t<n?n-t:xg-t+n;return"ms"===e?i:us.as(e,i,"ms")}equals(e){return this.startShift===(null==e?void 0:e.startShift)&&this.timeStart===e.timeStart&&this.timeEnd===e.timeEnd}intersects(e,t){const n=this,{timeStart:i,timeEnd:r}=n,[s,o]=n._dateRangeArgs(e,t),[a,l]=n.timeRange(s,o);return i<r?a<l?a<r&&i<l:a<r||i<l:!(a<l)||a<r||i<l}isIntraDay(e,t){const[n,i]=this._dateRangeArgs(e,t),r=this.startOfDay(n),s=xg-us.diff(r,i,"ms");return!(s<0)&&(s>0||r<n)}isInterDay(e){return e.allDay||!this.isIntraDay(...arguments)}outside(e){const{startShift:t,timeStart:n,timeEnd:i}=this,r=Tg.parse(e);return n<i?r<n?r<t?1:-1:r<i?0:r<t?-1:1:r<i||r>=n?0:r<t?1:-1}parseKey(e){return this.dayOfDate(us.parseKey(e))}shiftDate(e,t=1){const{startShift:n}=this,i=typeof e;return e="number"===i?new Date(e):"string"===i?us.parse(e):new Date(e.getTime()),t&&n&&e.setMilliseconds(t>0?n:-n),e}sortEvents(e,t){const n=this.startOfDay(e);return null==t?void 0:t.sort(((e,t)=>{e=e.eventRecord||e,t=t.eventRecord||t;let{startDate:i}=e,{startDate:r}=t;return i?r?(i=i<n?n:i,r=r<n?n:r,i-r||t.endDate-r-(e.endDate-i)):1:-1}))}startOfDay(e){return e=this.shiftDate(e,-1),e=us.clearTime(e),e=this.shiftDate(e)}timeRange(e,t){const[n,i]=this._dateRangeArgs(e,t);return[us.getTimeOfDay(n),us.getTimeOfDay(i)]}toString(){const{startShift:e,timeEnd:t,timeStart:n}=this,i=e?`@${Tg.format(e)}`:"",r=Tg.format(n);return n===t?e?i:r:`${r}-${Tg.format(t)}${i}`}_dateRangeArgs(e,t){return e.isModel?[e.startDate,e.endingDate]:[e,t]}}Tg.MIDNIGHT=new Tg({startShift:0,timeStart:0,timeEnd:24}),Tg.MILLIS_PER_MINUTE=Dg,Tg.MILLIS_PER_HOUR=Eg,Tg.MILLIS_PER_DAY=xg,Tg._$name="DayTime";class Mg extends tt{static $name="ElementVisitor";static configurable={element:null,selector:null};static elementVisitorMap=new WeakMap;static getVisitor(e,t){const{elementVisitorMap:n}=this,i=n.get(e)||n.set(e,new Map).get(e),r="string"==typeof t?t:t.toString();return i.get(r)||i.set(r,new Mg({element:e,selector:t})).get(r)}updateSelector(e){this.treeWalker=document.createTreeWalker(this.element,NodeFilter.SHOW_ELEMENT,"string"==typeof e?t=>{var n;return null!==(n=t.matches)&&void 0!==n&&n.call(t,e)?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_SKIP}:e)}first(){return this.treeWalker.currentNode=this.element,this.treeWalker.firstChild()}previous(e){return e&&(this.treeWalker.currentNode=e),this.treeWalker.previousNode()}next(e){return e&&(this.treeWalker.currentNode=e),this.treeWalker.nextNode()}last(){return this.treeWalker.currentNode=this.element,this.treeWalker.lastChild()}}Mg._$name="ElementVisitor";class Ig extends oh{static $name="Hint";static type="hint";static configurable={ui:"plain",defaultFocus:e=>!e.hidden&&("next"===e.ref||"stop"===e.ref),align:{align:"t-b",allowTargetOut:!0},anchor:!0,autoShow:!1,autoClose:!1,centered:!1,allowOver:!0,closable:!0,minWidth:"max-content",closeAction:"stop",previousAction:null,nextAction:null,keyMap:{P:"previous",N:"next",S:"stop"},buttons:null,maxWait:1e4,highlightTarget:null,highlighter:{$config:["lazy","nullify"],value:{floating:!0,cls:"b-hint-highlighter"}},autoNext:null,target:null};afterShow(...e){super.afterShow(...e),this.addDocumentMouseDownListener()}realign(...e){super.realign(...e),this.syncTargetHighlighting()}get isTopModal(){return!1}owns(...e){return!!this.masked||super.owns(...e)}onDocumentMouseDown({event:e}){e.isTrusted&&(this.owns(e.target)?super.onDocumentMouseDown(...arguments):this.hintFlow.stop())}changeTarget(e){return e&&("string"==typeof e&&(this._target=this._forElement=null),e=this.hintFlow.normalizeTarget(e),U.isPromise(e))?(e.then((e=>!this.isDestroyed&&(this.target=e))),void this.setTimeout("hide",this.maxWait)):e}updateButtons(e){this.bbar={items:e}}updateHighlightTarget(e,t){const n=null==e?void 0:e.inflate;n?(this.initialInflate=this.align.inflate,this.align.inflate=n):this.align.inflate=this.initialInflate}updateTarget(e){e instanceof Element&&(this.forElement=e)}changeHighlighter(e,t){if(e)return hd.reconfigure(t,hd.mergeConfigs({owner:this},e),this);null==t||t.destroy()}async updateForElement(e){const t=this,{autoNext:n,owner:i,index:r}=t;if(t.syncTargetHighlighting(),t.clearTimeout("hide"),t.hidden=!1,t.showBy({target:t.align.target||t.forElement}),!t.element.matches(":focus-within")&&t.focus(),n)switch(typeof n){case"number":t.setTimeout((()=>i.navigate(1)),n);break;case"string":if(await ut.sleep(500),t.index===r){const e=await(t.autoNextPromise=i.normalizeTarget(n,!1));t.autoNextPromise=null,e&&i.navigate(1,!1)}break;case"function":await ut.waitFor(n,1e4),i.navigate(1,!1)}}syncTargetHighlighting(){if(!this.isVisible)return;const e=this,{highlightTarget:t,highlighter:n,forElement:i}=e,{classList:r}=e.element,s={"--b-hint-highlight-color":""},o=null==n?void 0:n.element,a=null==o?void 0:o.classList,l=null==t?void 0:t.inflate;if(null==a||a.remove("b-hint-highlighter-ping","b-hint-highlighter-center"),r[e.scrollRealigning?"add":"remove"]("b-scroll-realigning"),i){const{style:n}=e.floatRoot,r=i.ownerDocument.defaultView.getComputedStyle(i),o=ki.isInView(i,!1,this),a=null!=t&&t.center?o.center.inflate(10):o;if(l&&a.inflate.apply(a,Array.isArray(l)?l:[l]),t&&(null==t||!t.center))for(const e of["top","bottom"])for(const t of["left","right"]){const n=r.getPropertyValue(`border-${e}-${t}-radius`);s[`border-${e}-${t}-radius`]=parseInt(n)?n:""}"string"==typeof(null==t?void 0:t.center)&&(s["--b-hint-highlight-color"]=t.center),n.setProperty("--b-highlight-top",`${a.top}px`),n.setProperty("--b-highlight-left",`${a.x}px`),n.setProperty("--b-highlight-width",`${a.width}px`),n.setProperty("--b-highlight-height",`${a.height}px`)}t&&(a[e.scrollRealigning?"add":"remove"]("b-realigning"),ki.applyStyle(o,s),n.show(),t.ping&&Mn.onTransitionEnd({element:o,property:"inset-inline-start",once:!0,thisObj:e,timeout:500,handler:()=>{a.add("b-hint-highlighter-ping")}}),t.center&&a.add("b-hint-highlighter-center")),e.requestAnimationFrame((()=>{r.remove("b-scroll-realigning"),a.remove("b-realigning")}))}next(){this.index<this.owner.hints.length-1&&this.owner.navigate(1)}previous(){this.index&&this.owner.navigate(-1)}stop(){this.owner.stop()}}Ig.initClass(),Ig._$name="Hint";const kg=(e,t)=>({previous:{weight:100,text:"L{Object.previous}",cls:"b-raised b-previous",hidden:!e,onClick:"up.onHintButtonClick"},next:{weight:100,text:"L{Object.next}",cls:"b-raised b-blue b-next",hidden:e===t-1,onClick:"up.onHintButtonClick"},stop:{weight:300,text:"L{Object.close}",cls:"b-raised b-red b-stop",hidden:e!==t-1,onClick:"up.onHintButtonClick"}}),Fg=/\[(?:([\w+]+)\+)?(\w+)\]|./g;class Ag extends(tt.mixin(dr,dt,nn)){waitInterval=100;maxWait=1e4;keyStrokeIntervalRandomness=100;static configurable={activeIndex:0,hints:null,defaults:{type:"hint",align:{allowTargetOut:!0},closable:!0,draggable:!1,buttons:{},autoNext:null,nextAction:null,previousAction:null,minWidth:null,trapFocus:!0,title:new String("")}};onHintButtonClick({source:e}){const t=this;switch(e.ref){case"next":t.navigate(1);break;case"previous":t.navigate(-1);break;case"stop":t.stop();break;case"completed":t.trigger("completed"),t.stop()}}async fakeType(e){let{target:t,text:n,initialDelay:i=0,focus:r}=e;"string"==typeof e&&(t=document.activeElement,n=e),!1!==r&&this.activeHint.revertFocus(),t?(t=await this.normalizeTarget(t),!1!==r&&t.focus()):t=ki.getActiveElement(this.activeHint.element),e.clear&&(t.value=""),await ut.sleep(i);for(let e=Fg.exec(n);e;e=Fg.exec(n)){if(e[2]){var s;const n=((null===(s=e[1])||void 0===s?void 0:s.split("+"))||[]).reduce(((e,t)=>(e[`${t.toLowerCase()}Key`]=!0,e)),{}),i={key:e[2],bubbles:!0,...n};t.dispatchEvent(new KeyboardEvent("keydown",i)),t.dispatchEvent(new KeyboardEvent("keyup",i))}else t.value+=e[0],t.dispatchEvent(new Event("input",{data:e[0]}));await ut.sleep(Math.random()*this.keyStrokeIntervalRandomness+30)}t.dispatchEvent(new Event("change"))}normalizeTarget(e,t=this.maxWait){return ki.waitForSelector(e,t,this.waitInterval)}navigate(e,t=!0){this.navigationOngoing||(this.navigationOngoing=new Promise((async n=>{const i=this,{activeHint:r}=i,s=i.activeIndex+e,o=Hi.ion({mouseup:({event:e})=>i.squashDocumentEvents(e)}),a=Mn.on({element:document,mousedown:"squashDocumentEvents",keydown:"squashDocumentEvents",thisObj:i,capture:!0});try{if(r.masked=!0,i.allowInteraction=!1,t){const t=i.processActions(i.activeHint[1===e?"nextAction":"previousAction"]);if(await ut.animationFrame(),1!==i.normalizeTarget(r.target,-1).nodeType){const e=i.normalizeTarget(i.hints[s].target,-1);1===(null==e?void 0:e.nodeType)?r.target=e:ki.applyStyle(r.floatRoot,{"--b-highlight-width":"0px","--b-highlight-height":"0px"})}await t}i.activeIndex=s,await i.activeIndexUpdated,i.navigationOngoing=null,r.masked=!1}finally{null==o||o(),null==a||a(),i.navigationOngoing&&(i.navigationOngoing=null,r.element.classList.remove("b-no-title"),r.hide(!1),Ig.reconfigure(r,{hidden:!1,masked:!1,centered:!0,title:"Navigation timed out",content:"Navigation could not be completed.",nextAction:null,bbar:{items:kg(0,1)}})),n()}})))}squashDocumentEvents(e){e.isTrusted&&(!this.activeHint.element.contains(e.target)&&this.allowInteraction||(e.preventDefault(),e.stopImmediatePropagation()))}async processActions(e){const t=this;if(e)if(Array.isArray(e))for(const n of e)await t.processActions(n);else for(const[i,r]of Object.entries(e))switch(i){case"type":await t.fakeType(r);break;case"dblclick":case"click":case"contextmenu":{const e="string"==typeof r,s=await t.normalizeTarget(e?r:r.target),o=!e&&r.focus;if(o){const e=ki.getActiveElement(s);var n;if(!ki.triggerMouseEvent(s,"mousedown").defaultPrevented&&ki.getActiveElement(s)===e)null===(n=ki.closest(s,ki.isFocusable))||void 0===n||n.focus()}ki.triggerMouseEvent(s,i),o&&ki.triggerMouseEvent(s,"mouseup")}break;case"fn":await t.activeHint.callback(r,t.activeHint);break;case"drag":await t.drag(r);break;case"waitFor":isNaN(r)?await t.normalizeTarget(r):await ut.sleep(r);break;case"allowInteraction":t.allowInteraction=r}}async drag({target:e=this.activeHint.target,by:[t,n],duration:i=500}){const r=await this.normalizeTarget(e),{ownerDocument:s}=r,{activeHint:o}=this,{modalMask:a}=o,{x:l,y:c}=_t.from(r).center.roundPx(1),d=ki.createElement({parent:s.body,className:"b-mouse-pointer b-icon b-fa-mouse-pointer",style:{left:`${l}px`,top:`${c}px`}}),u={clientX:l,clientY:c,bubbles:!0},{style:h}=o.floatRoot;let g,m;a&&(a.style.pointerEvents="none",h.setProperty("--b-highlight-width","0px"),h.setProperty("--b-highlight-height","0px")),r.dispatchEvent(new PointerEvent("pointerover",u)),r.dispatchEvent(new MouseEvent("mouseover",u)),r.dispatchEvent(new PointerEvent("pointerdown",u)),r.dispatchEvent(new MouseEvent("mousedown",u)),await ut.animationFrame(),await te.animate(i,(async e=>{u.clientX=l+t*e,u.clientY=c+n*e,a.style.pointerEvents="none",g=s.elementFromPoint(u.clientX,u.clientY),d.style.cssText=`left:${u.clientX}px;top:${u.clientY}px`,g.dispatchEvent(new PointerEvent("pointermove",u)),g.dispatchEvent(new MouseEvent("mousemove",u)),g!==m&&(g.dispatchEvent(new PointerEvent("pointerenter",u)),g.dispatchEvent(new MouseEvent("mouseenter",u)),g.dispatchEvent(new PointerEvent("pointerover",u)),g.dispatchEvent(new MouseEvent("mouseover",u)),m=g),a.style.pointerEvents=""})),h.setProperty("--b-highlight-top",`${u.clientY}px`),h.setProperty("--b-highlight-left",`${u.clientX}px`),g.dispatchEvent(new PointerEvent("pointerup",u)),g.dispatchEvent(new MouseEvent("mouseup",u)),d.remove()}async updateActiveIndex(e,t){var n;const i=this,{hints:r,activeHint:s}=i,o=r.length,a=r[e];if(null==s||null===(n=s.autoNextPromise)||void 0===n||n.resolve(),a){var l,c;const n=await i.normalizeTarget(a.target);let{align:r}=a;if("string"==typeof(null===(l=r)||void 0===l?void 0:l.target)&&(r={...r,target:await i.normalizeTarget(r.target)}),!1===n)return void(i.activeIndex=++e);s?("string"==typeof a.target&&(s._target=s._forElement=null),s.bbar.element.matches(":focus-within")&&s.element.focus()):i.returnFocusTo=ki.getActiveElement();const u={steps:{type:"widget",content:`${e+1}/${o}`,weight:-1e3},completed:{text:i.L("L{Hint.dontShowAgain}"),cls:"b-transparent",weight:10,onClick:"up.onHintButtonClick"},...U.merge(kg(e,o),Array.isArray(a.buttons)?U.transformArrayToNamedObject(a.buttons):a.buttons)},h=i.activeHint=Ig.reconfigure(s,Ig.mergeConfigs(i.defaults,{index:e,hintFlow:i,owner:i,maxWait:i.maxWait,rootElement:document.body},a,{target:n,buttons:u,["string"==typeof(null===(c=r)||void 0===c?void 0:c.target)?"align":"_"]:r}));var d;if(i.owner=Ig.fromElement(n),h.element.classList.toggle("b-no-title",Boolean(!a.title)),await Promise.all([h.highlighter.element.isConnected&&ki.waitForSelector(h.highlighter.element,-1e3),ki.waitForSelector(h.element,-1e3)]),h.isVisible)null===(d=h.bbar.widgetMap[e===o-1?"stop":e&&e<t?"previous":"next"])||void 0===d||d.focus()}else i.stop()}async stop(){var e;const t=this;t.activeIndex===t.hints.length-1&&await t.processActions(t.activeHint.nextAction),t.activeHint.owner=null,bryntum.queryAll("hint").forEach((e=>e.hintFlow===t&&e.destroy())),t.activeHint=null,null===(e=t.returnFocusTo)||void 0===e||e.focus()}}Ag._$name="HintFlow";class Pg extends(dt(tt)){static $name="Month";static get configurable(){return{date:{$config:{equal:"date"},value:us.clearTime(new Date)},month:null,year:null,weekStartDay:null,hideNonWorkingDays:null,nonWorkingDays:null,sixWeeks:null}}configure(e){super.configure(e),this.updateDayNumbers(),e.date&&(this.date=e.date),this.generation=0}changeDate(e){if(!this.isConfiguring){if(e="string"==typeof e?us.parse(e,"YYYY-MM-DD"):new Date(e),isNaN(e))throw new Error("Month date ingestion must be passed a Date, or a valid YYYY-MM-DD date string");return e}}updateDate(e,t){const n=this,{dayColumnIndex:i,weekCount:r}=n,s=us.getFirstDateOfMonth(e),o=us.getLastDateOfMonth(s),a=i[s.getDay()],l=i[o.getDay()],c=!t||e.getFullYear()!==t.getFullYear(),d=!t||e.getMonth()!==t.getMonth(),u=n.eventListeners&&(t?e.getDate()!==t.getDate()|(n.getWeekId(e)!==n.getWeekId(t))<<1|d<<2|c<<3:15);if(n._year=e.getFullYear(),n._month=e.getMonth(),n.startDayOfMonth=1-a,n.endDayOfMonth=o.getDate()+(6-l),n.sixWeeks&&(n.endDayOfMonth+=7*(6-n.weekCount)),n.weekBase&&!c||n.calculateWeekBase(),(d||c)&&n.generation++,u){const i={newDate:e,oldDate:t,changes:{d:!0,w:Boolean(2&u),m:Boolean(12&u),y:Boolean(8&u),r:n.weekCount!==r}};n.trigger("dateChange",i),2&u&&n.trigger("weekChange",i),12&u&&n.trigger("monthChange",i),8&u&&n.trigger("yearChange",i)}}calculateWeekBase(){const e=this,{dayColumnIndex:t}=e,n=new Date(e.year,0,1),i=new Date(e.year,11,31),r=e.month?e.getOtherMonth(n):e;e.dayColumnIndex[n.getDay()]>3?e.weekBase=r.startDate:e.weekBase=new Date(e.year,0,r.startDayOfMonth-7);const s=Math.floor(us.diff(e.weekBase,i,"day")/7);e.has53weeks=53===s&&t[i.getDay()]>2}getWeekStart(e){if("number"==typeof e)return us.add(this.weekBase,7*Math.max(e,1),"day");const t=this,[n,i]=e;return n===t.year?t.getWeekStart(i):t.getOtherMonth(new Date(n,0,1)).getWeekStart(i)}getOtherMonth(e){const t=this,n=t===Lg?new Pg(null):Lg;return n.configure({weekBase:null,weekStartDay:t.weekStartDay,nonWorkingDays:t.nonWorkingDays,hideNonWorkingDays:t.hideNonWorkingDays,sixWeeks:t.sixWeeks,date:new Date(e.getFullYear(),0,1)}),n.date=e,n.updateDate(n.date,n.date),n}changeYear(e){const t=new Date(this.date);t.setFullYear(e),this.date=t}changeMonth(e){const t=new Date(this.date);t.setMonth(e),this.date=t}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:us.weekStartDay}updateWeekStartDay(){const e=this;e.updateDayNumbers(),!e.isConfiguring&&e.date&&(e.weekBase=null,e.updateDate(e.date,e.date))}get nonWorkingDays(){return this._nonWorkingDays||us.nonWorkingDays}changeNonWorkingDays(e){return U.assign({},e)}updateNonWorkingDays(){this.updateDayNumbers()}updateHideNonWorkingDays(){this.updateDayNumbers()}updateSixWeeks(){this.isConfiguring||this.updateDate(this.date,this.date)}get dayCount(){return this.endDayOfMonth+1-this.startDayOfMonth}get weekCount(){return this.dayCount/7}get startDate(){const e=this;if(null!=e.year&&null!=e.month&&null!=e.startDayOfMonth)return new Date(e.year,e.month,e.startDayOfMonth)}get endDate(){const e=this;if(null!=e.year&&null!=e.month&&null!=e.startDayOfMonth)return new Date(e.year,e.month,e.endDayOfMonth)}get firstDate(){const e=this;if(null!=e.year&&null!=e.month&&null!=e.startDayOfMonth)return new Date(e.year,e.month,1)}get lastDate(){const e=this;if(null!=e.year&&null!=e.month&&null!=e.startDayOfMonth)return new Date(e.year,e.month+1,0)}eachDay(e){for(let t=this.startDayOfMonth;t<=this.endDayOfMonth;t++)e(new Date(this.year,this.month,t))}eachWeek(e){const t=this,{weekCount:n}=t;for(let i=t.startDayOfMonth,r=0;r<n;r++){const s=[],o=t.getWeekNumber(new Date(t.year,t.month,i));for(let e=0;e<7;e++,i++)s.push(new Date(t.year,t.month,i));e(o,s,r,r===n-1)}}getWeekNumber(e){const t=this;if((e=us.clearTime(e)).getFullYear()!==t.year)return t.getOtherMonth(new Date(e.getFullYear(),0,1)).getWeekNumber(e);let n=Math.floor(us.diff(t.weekBase,e,"day")/7),i=e.getFullYear();return n?(53!==n||t.has53weeks?n>53&&(n%=52):(n=1,i++),[i,n]):t.getOtherMonth(new Date(t.year-1,0,1)).getWeekNumber(new Date(t.year,0,0))}getWeekId(e){const t=this.getWeekNumber(e);return 100*t[0]+t[1]}getCellData(e,t,n=Tg.MIDNIGHT){const i=this,r=e.getDay(),s=i.visibleDayColumnIndex[r],o=i.nonWorkingDays[r],a=i.hideNonWorkingDays&&o;return(e<i.startDate||e>i.endDate)&&(i.month=e.getMonth()),{day:r,dayTime:n,visibleColumnIndex:s,isNonWorking:o,week:i.getOtherMonth(e).getWeekNumber(e),key:us.format(e,"YYYY-MM-DD"),columnIndex:i.dayColumnIndex[r],date:new Date(e),dayEnd:n.duration("s"),tomorrow:n.dayOfDate(us.add(e,1,"day")),isOtherMonth:Math.sign(e.getMonth()+12*e.getFullYear()-(t.month+12*t.year)),visible:!a&&e>=t.startDate&&e<us.add(t.endDate,1,"day"),isRowStart:0===s,isRowEnd:s===i.visibleColumnCount-1}}updateDayNumbers(){const e=this,{weekStartDay:t,nonWorkingDays:n,hideNonWorkingDays:i}=e,r=e.dayColumnIndex=[],s=e.canonicalDayNumbers=[],o=e.visibleDayColumnIndex=[];let a=0;for(let e=0;e<7;e++){const l=(t+e)%7;s[e]=l,r[l]=e,i&&n[l]||(o[l]=a++)}e.visibleColumnCount=a,e.weekLength=i?7-U.keys(n).length:7}}const Lg=new Pg(null);Pg._$name="Month";let Og=0;const $g=new WeakMap,_g=e=>{const t=new Map;return(...n)=>{const i=((...e)=>e.map((e=>{let t;return e&&"object"==typeof e||"function"==typeof e?(t=$g.get(e),void 0===t&&(t=++Og,$g.set(e,t))):t=String(e),t})).join("-"))(n);let r=t.get(i);return void 0===r&&(r=e(...n),t.set(i,r)),r}},jg=e=>{const t=new Map,n=e=>e[0],i=e=>e[1],r=(e,t)=>n(e).push(t);return(s,o)=>{const a=(e=>{let n=t.get(e);return void 0===n&&(n=[[],[]],t.set(e,n)),n})(s);(e=>!i(e).length&&!n(e).length)(a)?(r(a,o),e(s,(e=>{((e,t)=>i(e).some((e=>U.isEqual(e,t))))(a,e)||(((e,t)=>{i(e).push(t)})(a,e),n(a).forEach((t=>t(e))))}))):(r(a,o),i(a).forEach((e=>o(e))))}},Bg=Symbol("success"),Vg=Symbol("failure"),Hg=(e,t)=>[Bg,e,t],zg=e=>[Vg,e],Ng=e=>e.length&&e[0]===Bg,Wg=e=>"function"!=typeof e||e.length?e:e(),Ug=_g((e=>jg(((t,n)=>n(Hg(e,t)))))),Gg=_g((e=>jg(((t,n)=>{const i=Math.min(e.length,t.length),r=t.substr(0,i),s=t.substr(i);n(r===e?Hg(r,s):zg(s))})))),qg=(e,t)=>(n,i)=>Wg(e)(n,(e=>{if(Ng(e)){const[,n,r]=e;t(n)(r,i)}else i(e)})),Yg=_g(((...e)=>{const t=_g(((e,t)=>jg(qg(e,(e=>qg(t,(t=>Ug([].concat(e,t)))))))));return e.reduce(t,Ug([]))})),Kg=_g(((...e)=>jg(((t,n)=>e.forEach((e=>Wg(e)(t,n))))))),Xg=_g((e=>(t,n)=>{const i=new RegExp(`^${e}`).exec(t);if(i){const e=i[0],r=t.substr(e.length);n(Hg(e,r))}else n(zg(t))})),Zg=_g(((e,t)=>qg(e,((...e)=>Ug(t(...[].concat.apply([],e))))))),Jg=(e,t)=>{const n=[];return e(t,(e=>{if(Ng(e)){const[,,t]=e;""===t&&n.push(e)}})),n};var Qg={memo:_g,memoCps:jg,success:Hg,failure:zg,isSuccess:Ng,resolveParser:Wg,succeed:Ug,string:Gg,bind:qg,seq:Yg,alt:Kg,regexp:Xg,red:Zg,runParser:Jg,defineParser:e=>(t,n)=>n?Wg(e)(t,n):Jg(Wg(e),t)};class em extends(tt.mixin(nn,dt)){static get configurable(){return{element:null,zoneWidth:50,scrollSpeed:5,direction:"both",startScrollDelay:500,stopScrollWhenPointerOut:!1,testConfig:{scrollSpeed:2,startScrollDelay:100},activeScroll:{$config:["lazy"],value:{}},monitoring:{$config:["lazy","nullify"],value:!0},owner:null}}changeMonitoring(e,t){return null==t||t.clear(),new Map}doDestroy(){this.stopMonitoring(),super.doDestroy()}get isScrolling(){return 0!==Object.keys(this.activeScroll).length}get rtl(){var e;return null===(e=this.owner)||void 0===e?void 0:e.rtl}startMonitoring(e={}){const t=this,{element:n,direction:i}=t,{scrollables:r=[],direction:s=i,callback:o}=e,a=[];return r.length||r.push({element:n}),r.forEach((e=>{const i=e.element;"string"==typeof i?ki.forEachSelector(n,i,(n=>{t.createMonitor(n,e.direction||s,e.callback||o),a.push(n)})):(t.createMonitor(i,e.direction||s,e.callback||o),a.push(i))})),function(){var e;null===(e=t.stopMonitoring)||void 0===e||e.call(t,a)}}createMonitor(e,t,n){const{monitoring:i}=this;i.has(e)||i.set(e,new tm({scrollManager:this,element:e,direction:t,callback:n}))}stopMonitoring(e){const t=this,{monitoring:n}=t;if(e=rt.asArray(e),n){if(!e)return void n.forEach((e=>t.stopMonitoring(e.element)));e.forEach((e=>{const t=n.get(e);e.classList.remove("b-scrolling"),t&&(t.destroy(),n.delete(e))}))}}requestScroll(e,t){const{activeScroll:n}=this;return(!(e in n)||n[e]===t)&&(n[e]=t,!0)}releaseScroll(e){const{activeScroll:t={}}=this;Object.keys(t).forEach((n=>{t[n]===e&&delete t[n]}))}getRelativeScroll(e,t="left"){let n=0;return this.monitoring.forEach(((i,r)=>{ki.isDescendant(r,e)&&(n+="left"===t?i.scrollRelativeLeft:i.scrollRelativeTop)})),n}}class tm extends tt{construct(e){const{element:t}=e,n=t.scrollLeft,i=t.scrollTop;Object.assign(e,{startScrollLeft:n,startScrollTop:i}),super.construct(e),Mn.on({element:t,scroll:"onElementScroll",pointermove:"onMouseMove",capture:!0,thisObj:this}),Mn.on({element:t,pointerleave:"onPointerLeave",thisObj:this})}doDestroy(){this.stopScroll(!0),super.doDestroy()}startScroll(){const e=this;e.pendingScrollFinalize&&(e.scrollManager.releaseScroll(e),e.pendingScrollFinalize=!1),e.scrolling=!0,e.performScroll()}stopScroll(e=null){const t=this,n=()=>{t.pendingScrollFinalize=!1,t.isDestroyed||(t.scrollManager.releaseScroll(t),t.scrolling=!1)};t.scrollRequested&&(t.scrollManager.cancelAnimationFrame(t.frameId),t.scrollRequested=!1),t.scrollManager.clearTimeout(t.scrollTimeout),t.scrollTimeout=null,e||!t.ongoingScrollTop&&!t.ongoingScrollLeft?(t.ongoingScrollTop=t.ongoingScrollLeft=null,n()):(t.pendingScrollFinalize=!0,Promise.all([t.ongoingScrollTop,t.ongoingScrollLeft].filter(Boolean)).then((()=>t.pendingScrollFinalize&&n())))}onPointerLeave(){this.scrollManager.stopScrollWhenPointerOut&&this.stopScroll()}onMouseMove(e){const t=this,{scrollManager:n}=t,i=t.element.getBoundingClientRect(),r=n.zoneWidth,s=n.scrollSpeed;if(t.scrollDeltaX=t.scrollDeltaY=0,"vertical"!==t.direction){const{scrollLeft:o,scrollWidth:a,clientWidth:l}=t.element;n.rtl?e.clientX<i.left+r&&a+o-l>=1?t.scrollDeltaX=-Math.round((r+(i.left-e.clientX))/s)-1:e.clientX>i.right-r&&o<0&&(t.scrollDeltaX=Math.round((r-(i.right-e.clientX))/s)+1):e.clientX>i.right-r&&a-o-l>=1?t.scrollDeltaX=Math.round((r-(i.right-e.clientX))/s)+1:e.clientX<i.left+r&&o>0&&(t.scrollDeltaX=-Math.round((r+(i.left-e.clientX))/s)-1)}if("horizontal"!==t.direction){const{scrollTop:n,scrollHeight:o,clientHeight:a}=t.element;e.clientY>i.bottom-r&&o-n-a>=1?t.scrollDeltaY=Math.round((r-(i.bottom-e.clientY))/s)+1:e.clientY<i.top+r&&n>0&&(t.scrollDeltaY=-Math.round((r+(i.top-e.clientY))/s)-1)}0===t.scrollDeltaX||n.requestScroll("horizontal",t)||(t.scrollDeltaX=0),0===t.scrollDeltaY||n.requestScroll("vertical",t)||(t.scrollDeltaY=0),0===t.scrollDeltaX&&0===t.scrollDeltaY?t.scrolling&&t.stopScroll():t.scrollTimeout||(t.scrollTimeout=n.setTimeout((()=>t.startScroll()),n.startScrollDelay))}performScroll(){const e=this,{element:t,scrollManager:n}=e;if(e.scrolling&&!e.scrollRequested){if(0!==e.scrollDeltaX){const i=t.scrollLeft,r=Math.min(i+e.scrollDeltaX,t.scrollWidth-t.clientWidth);t.scrollLeft=r,t.scrollLeft!==i?e.ongoingScrollLeft=new Promise((i=>t.addEventListener("scroll",(t=>{var r;null===(r=n.trigger)||void 0===r||r.call(n,"scroll",{event:t,deltaY:e.scrollDeltaY,deltaX:e.scrollDeltaX}),i()}),{once:!0}))):(e.ongoingScrollLeft=null,e.scrollDeltaX=0)}if(0!==e.scrollDeltaY){const i=t.scrollTop,r=Math.min(i+e.scrollDeltaY,t.scrollHeight-t.clientHeight);t.scrollTop=r,t.scrollTop!==i?e.ongoingScrollTop=new Promise((i=>t.addEventListener("scroll",(t=>{var r;null===(r=n.trigger)||void 0===r||r.call(n,"scroll",{event:t,deltaY:e.scrollDeltaY,deltaX:e.scrollDeltaX}),i()}),{once:!0}))):(e.ongoingScrollTop=null,e.scrollDeltaY=0)}0!==e.scrollDeltaX||0!==e.scrollDeltaY?(e.scrollRequested=!0,e.frameId=e.scrollManager.requestAnimationFrame((()=>{e.scrollRequested=!1,e.performScroll(e)}))):e.stopScroll()}}onElementScroll(){var e;null===(e=this.config)||void 0===e||null===(e=e.callback)||void 0===e||e.call(this.thisObj||this.scrollManager,this)}get scrollLeft(){return this.element.scrollLeft}get scrollTop(){return this.verticalElement?this.verticalElement.scrollTop:this.element.scrollTop}get scrollRelativeLeft(){return this.scrollLeft-this.startScrollLeft}get scrollRelativeTop(){return this.scrollTop-this.startScrollTop}getRelativeLeftScroll(e){return this.scrollManager.getRelativeScroll(e,"left")}getRelativeTopScroll(e){return this.scrollManager.getRelativeScroll(e,"top")}}em._$name="ScrollManager";const nm={left:!0,right:!0,top:!0,bottom:!0,transform:!0},im={true:1,false:1},rm=Promise.resolve();class sm extends oh{static $name="Tooltip";static type="tooltip";static get configurable(){return{autoHide:!0,mouseOffsetX:15,mouseOffsetY:15,html:{$config:{equals:()=>!1}},getHtml:null,forElement:null,trackMouse:null,updateContentOnMouseMove:!1,forSelector:null,hideOnDelegateChange:null,anchorToTarget:!0,showOnHover:null,hoverDelay:500,autoShow:!1,dismissDelay:0,hideDelay:500,loadingMsg:"Loading...",allowOver:null,anchor:!0,draggable:!1,align:{align:"b-t",minHeight:300},axisLock:!0,activeTarget:{$config:{equal:(e,t)=>null==e&&null==t||e===t},value:null},testConfig:{hideDelay:100,hoverDelay:100,showAnimation:null,hideAnimation:null},role:"tooltip",describedElement:null}}afterConfigure(){const e=this,{forSelector:t}=e;t&&(e.showOnHover=!1!==e.showOnHover,e.forElement||(e.anchorToTarget||(e.trackMouse=!0),e.forElement=e.rootElement.host||e.rootElement)),super.afterConfigure(),e.forElement&&e.showOnHover&&(e.pointerOverOutDetacher=Mn.on({element:e.forElement,pointerover:"internalOnPointerOver",pointerout:"internalOnPointerOut",thisObj:e}))}doDestroy(){var e;null===(e=this.pointerOverOutDetacher)||void 0===e||e.call(this),super.doDestroy()}set focusOnToFront(e){super.focusOnToFront=e}get focusOnToFront(){var e;return"focus"!==(null===(e=this.triggeredByEvent)||void 0===e?void 0:e.pointerType)&&(super.focusOnToFront&&ki.usingKeyboard)}get focusElement(){const e=super.focusElement;if(e!==this.element)return e}get anchorToTarget(){return this._anchorToTarget&&!this.trackMouse}get anchor(){return super.anchor&&!this.trackMouse}set anchor(e){super.anchor=e}onDocumentMouseDown({event:e}){const t=this,{triggeredByEvent:n}=t;var i;if(n&&ki.isTouchEvent&&(e.pageX===n.pageX&&e.pageY===n.pageY&&null!==(i=t.activeTarget)&&void 0!==i&&i.contains(e.target)&&performance.now()-n.timeStamp<500))return;t.abortDelayedShow(),super.onDocumentMouseDown({event:e})}internalOnPointerOver(e){const t=this,{target:n,relatedTarget:i}=e,{forElement:r,forSelector:s,activeTarget:o}=t;let a;if(!(t.disabled||t.owner&&!t.owner.showTooltipWhenDisabled&&t.owner.disabled||t.allowOver&&t.element.contains(n))){if(s){const r=e.target.closest("[data-btip]");if(r&&!r.matches(s))return void(o&&t.handleForElementOut());if(a=t.filterTarget(e),!t.hasTimeout("hide")&&null!=o&&o.contains(n)&&o.contains(i)&&a===o)return;if(a&&(null==i?void 0:i.closest(s))===a&&!i.dataset.btip)return}else{if(r.contains(i))return;a=r}a?t.handleForElementOver(e,a):o&&t.handleForElementOut()}}filterTarget({target:e}){return e.closest(this.forSelector)}realignOnTransitionEnd(e){const t=this,{currentOverElement:n}=sm;if(nm[e.propertyName]){var i;if(t.allowOver&&t.element.contains(n))return;null!==(i=t.activeTarget)&&void 0!==i&&i.contains(n)&&!t.trackMouse&&t.realign()}}async handleForElementOver(e,t){const n=this,{activeTarget:i,hideOnDelegateChange:r,anchorToTarget:s}=n,o=t!==i,a=o&&r;if(!1===n.trigger("pointerOver",{event:e,target:t}))n.internalOnPointerOut(e);else{if(n.triggeredByEvent=e,n.hasTimeout("hide")&&(n.abortDelayedHide(),!o))return;if(!r&&n.element.classList.contains("b-hiding")&&n.cancelHideShowAnimation(),!n._hidden&&a&&n.hide(!1),n.activeTarget&&n.hasTimeout("show")&&n.clearTimeout("show"),n.activeTarget=t,n.activeTarget!==t)return void n.internalOnPointerOut(e);if(n.isVisible){n.lastAlignSpec=null;const e=n.updateContent();if(C.isPromise(e)&&!n.loadingMsg&&await e,!1===n.trigger("beforeShow"))return n.hide();n.alignTo({[s?"target":"position"]:s?t:"mouse",overlap:!(s&&n.anchor)}),n.trigger("show"),n.afterShowByTarget()}else n.activeTarget=t,n.delayShow(t)}}async delayShow(e){var t;const n=this;if(null!==(t=n.currentAnimation)&&void 0!==t&&t.showing&&n.cancelHideShowAnimation(),n.isVisible||n.hasTimeout("show"))n.isVisible&&n.showByTarget(e);else if(!n.hoverDelay||n.forSelector&&Date.now()-n.lastHidden<n.quickShowInterval){const t=n.updateContent();C.isPromise(t)&&!n.loadingMsg&&await t,n.showByTarget(e)}else n.addDocumentMouseDownListener(),n.listeningForMouseMove||n.anchorToTarget||(n.mouseMoveRemover=Mn.on({element:n.rootElement,mousemove:"onMouseMove",thisObj:n})),n.setTimeout((async()=>{if(n.activeTarget===e&&e.isConnected){const t=n.updateContent();C.isPromise(t)&&!n.loadingMsg&&await t,n.showByTarget(e)}}),n.triggeredByEvent&&"pointerover"!==n.triggeredByEvent.type?0:n.hoverDelay,"show")}changeAllowOver(e){return this.inAfterShow||(this.configuredAllowOver=e),e}updateAllowOver(e){const t=this,{element:n}=t;var i;(n.classList.toggle("b-allow-over",Boolean(e)),e)?t.allowOverlisteners=Mn.on({element:n,mouseenter:"onOwnElementMouseEnter",mouseleave:"internalOnPointerOut",thisObj:t}):null===(i=t.allowOverlisteners)||void 0===i||i.call(t)}updateContent(){const e=this;if(e.getHtml){const t=e.callback(e.getHtml,e,[{tip:e,element:e.element,activeTarget:e.activeTarget,event:e.triggeredByEvent}]);return e.html=t,t}}get hasContent(){return Boolean(ki.isVueConfig(this._html)||ki.isReactElement(this._html)||""!==this._html&&"string"==typeof this.html&&this.html.length||this.items.length)}internalBeforeShow(){const e=this;return(!e.isSharedTooltip||!rc.dragging)&&((e.updateContentOnMouseMove||e.hasContent)&&!e.disabled)}showAsyncMessage(e=this.optionalL(this.loadingMsg)){e&&(this.html=`\n                <div class="b-tooltip-loading">\n                    <i class="b-icon b-icon-spinner"></i>\n                    ${V.encodeHtml(e)}\n                </div>\n            `)}showByTarget(e){var t;const n=this,{anchorToTarget:i}=n;n.mouseMoveRemover=null===(t=n.mouseMoveRemover)||void 0===t?void 0:t.call(n),n.showBy({[i?"target":"position"]:i?e:"mouse",overlap:!(i&&n.anchor)})}afterShowByTarget(){const e=this,{dismissDelay:t,activeTarget:n}=e,i=ki.getActiveElement(e.activeTarget);e.abortDelayedShow(),t&&e.setTimeout("hide",t),e.element.parentNode&&e.toFront(),e.mouseMoveRemover||!e.trackMouse&&!e.updateContentOnMouseMove||(e.mouseMoveRemover=Mn.on({element:e.rootElement,pointermove:"onMouseMove",thisObj:e})),e.describedElement=null!=n&&n.contains(i)?i:null,e.inAfterShow=!0,e.allowOver=e.allowOver||0!=e.configuredAllowOver&&e.childItems.some((e=>e.isVisible&&!e.disabled&&e.focusElement)),e.inAfterShow=!1}changeActiveTarget(e,t){const n=this;if(e){if(!n.isConfiguring&&!1===n.trigger("overTarget",{newTarget:e,lastTarget:t}))return}else n.trigger("targetOut",{lastTarget:t});return e}updateDescribedElement(e,t){const{titleElement:n}=this,i=n&&ki.getId(n),r=ki.getId(this.contentElement);e&&e.getAttribute("aria-label")!==this.html&&(i&&ki.addAttributeValue(e,"aria-describedby",i),ki.addAttributeValue(e,"aria-describedby",r)),t&&(i&&ki.removeAttributeValue(t,"aria-describedby",i),ki.removeAttributeValue(t,"aria-describedby",r))}internalOnPointerOut(e){var t;const n=this,i="pointerover"===e.type?e.target:e.relatedTarget;n.allowOver&&(n.element.contains(i)||n.owns(i,!0))||n.element.contains(i)&&null!==(t=n.activeTarget)&&void 0!==t&&t.contains(i)||n.activeTarget&&!n.activeTarget.contains(i)&&n.handleForElementOut()}handleForElementOut(){const e=this,{hideDelay:t}=e;if(!1===e.trigger("pointerOut"))return e.activeTarget=null,!0;e.abortDelayedShow(),e.isVisible&&!1!==t&&(e.abortDelayedHide(),t>0?e.setTimeout("hide",t):e.hide())}show(e,...t){const n=this;!e&&n.forElement&&n.anchorToTarget&&!n.forSelector?n.showByTarget(n.forElement):super.show(e,...t),n.isVisible?n.afterShowByTarget():n.activeTarget=null}get hoverDelay(){var e;return"focus"===(null===(e=this.triggeredByEvent)||void 0===e?void 0:e.pointerType)?0:this._hoverDelay}get hideDelay(){var e;return"focus"===(null===(e=this.triggeredByEvent)||void 0===e?void 0:e.pointerType)?0:!!this.autoHide&&this._hideDelay}hide(...e){const t=this;if(t.abortDelayedShow(),t._hidden)return rm;{var n,i;t.abortDelayedHide();const r=super.hide(...e);return t.lastHidden=Date.now(),t.activeTarget=null,null===(n=t.mouseMoveRemover)||void 0===n||n.call(t),t.mouseMoveRemover=null,null===(i=t.transitionEndDetacher)||void 0===i||i.call(t),t.transitionEndDetacher=null,t.describedElement=null,r}}abortDelayedShow(){const e=this;var t,n,i;e.hasTimeout("show")&&(null===(t=e.mouseDownRemover)||void 0===t||t.call(e),e.mouseDownRemover=null,e.clearTimeout("show"),null===(n=e.mouseMoveRemover)||void 0===n||n.call(e),e.mouseMoveRemover=null,null===(i=e.transitionEndDetacher)||void 0===i||i.call(e),e.transitionEndDetacher=null)}abortDelayedHide(){this.clearTimeout("hide")}realign(){const e=this,t=e.lastAlignSpec;e.isConfiguring||e.isVisible||null==t||!t.targetOutOfView||(t.allowTargetOut||ki.isInView(t.target,!1,e))&&(e.show(),t.targetOutOfView=!1),super.realign()}alignTo(e){const t=this,n=(t.mouseOffsetX||1)*(t.rtl?-1:1),i=t.mouseOffsetY||1,r=Math.max(Math.min(n,5),0),s=Math.max(Math.min(i,5),0);if(!t.isVisible)return;let o;t.anchorToTarget||"mouse"!==e.position||(o=new jt(t.triggeredByEvent.pageX-globalThis.scrollX,t.triggeredByEvent.pageY-globalThis.scrollY),e.position=new jt(o.x+(n||1)-(n<0?t.width:0),o.y+(i||1)-(i<0?t.height:0))),!e||t.triggeredByEvent&&t.element.contains(t.triggeredByEvent.target)||e.nodeType===Node.ELEMENT_NODE&&(e={target:e}),super.alignTo(e),o&&t.lastAlignSpec.result.inflate(s,r).contains(o)&&(t.lastAlignSpec.position="mouse",t.mouseOffsetY=-i,t.mouseOffsetX=-n,t.realign(),t.mouseOffsetY=i,t.mouseOffsetX=n)}set html(e){super.html=e,this.isVisible&&this.realign()}get html(){return super.html}changeHtml(e){const t=this;return C.isPromise(e)?(t.showAsyncMessage(),e.target=t.activeTarget,void e.then((n=>{e.target===t.activeTarget&&(t.html=n)}))):("object"!=typeof e&&(e=null!=e?t.optionalL(String(e)):""),e)}updateHtml(e,t){const n=this;let i=""===e;i&&!ki.isVueConfig(e)||(super.updateHtml(e,t),n.hasContent?C.isPromise(e)||n.trigger("innerHtmlUpdate",{value:e}):i=!0),i&&n.hide()}onMouseMove(e){const t=this,{forElement:n,activeTarget:i}=t,r=t.hasTimeout("hide"),s=e.target;if(t.triggeredByEvent=e,!t._hidden){let o;const a=!(null==i?void 0:i.contains(s))&&t.forSelector&&i&&!r&&s.nodeType===Node.ELEMENT_NODE&&!s.matches(t.forSelector)&&!(t.allowOver&&t.element.contains(s)),l=null!=n&&n.document?n.document.documentElement:n,c=l&&(l.contains?l.contains(s):16&l.compareDocumentPosition(s));if(a&&(o=t.handleForElementOut()),o||!r||c){if(t.dismissDelay&&!r&&t.setTimeout("hide",t.dismissDelay),t.updateContentOnMouseMove&&t.getHtml&&(t.html=t.callback(t.getHtml,t,[{tip:t,element:t.element,forElement:i,activeTarget:i,event:e}]),!t.html))return void t.hide();t.trackMouse&&t.alignTo({position:"mouse",ignorePageScroll:!0})}}}onElementUserAction(e){const{showOnClick:t}=this;"number"==typeof t&&t!==e.button||(2===e.button&&e.preventDefault(),this.internalOnPointerOver(e))}onOwnElementMouseEnter(e){this.abortDelayedHide()}static getSharedTooltip(e,t,n){var i;let r=null===(i=t.bryntum)||void 0===i||null===(i=i.tooltip)||void 0===i?void 0:i.get(sm);if(!r&&!n){var s;null!==(s=t.bryntum)&&void 0!==s&&s.tooltip||U.setPath(t,"bryntum.tooltip",new Map);const n=t.bryntum.tooltip;n.set(sm,!0),r=new sm({forElement:t,rootElement:e,forSelector:"[data-btip]",resetCfg:{},isSharedTooltip:!0,cls:"b-tooltip-shared",internalListeners:{pointerOver({target:e}){if(r.isOverflowDetail)return;for(const e in r.resetCfg)"listeners"===e?r.un(r.resetCfg[e].set):"html"!==e&&(r[e]=r.resetCfg[e].was);r.resetCfg={};const t=hd.getById(e.id),n=(null==t?void 0:t.tipConfig)||r.gatherDataConfigs(e);if(t&&t.element!==e||!t&&e.matches(".b-widget")||null!=t&&t.disabled&&!t.showTooltipWhenDisabled)return!1;r._owner=t,r.element.classList.toggle("b-target-disabled",Boolean(null==t?void 0:t.disabled));for(const e in n)r.resetCfg[e]={set:n[e],was:r[e]},"listeners"===e?r.ion(n[e]):r[e]=n[e]},hide({source:e}){e.owner=null}},gatherDataConfigs(e){const{dataset:t}=e,n={};for(const e in t)if(e.startsWith("btip"))if(e.length>4){const i=V.uncapitalize(e.substr(4));if(i in r.getDefaultConfiguration()){const r=t[e];n[i]=im[r]?"true"===r:isNaN(r)?r:parseInt(r,10)}}else n.html=t[e];return e.hasAttribute("aria-label")&&!n.html?n.html=V.encodeHtml(r.optionalL(e.getAttribute("aria-label"))):e.hasAttribute("aria-labelledby")&&(n.html=V.encodeHtml(r.optionalL(document.getElementById(e.getAttribute("aria-labelledby").textContent)))),n},filterTarget({target:e}){r.isOverflowDetail=!1;const t=e.closest(r.forSelector);if(t)return t;if(sm.showOverflow&&e.closest(".b-widget"))for(;(null===(n=e)||void 0===n?void 0:n.nodeType)===Element.ELEMENT_NODE;){var n;if("ellipsis"===ki.getStyleValue(e,"text-overflow")&&e.clientWidth<e.scrollWidth)return r.html=V.encodeHtml(e.textContent),r.isOverflowDetail=!0,e;e=e.parentNode}}}),Mn.on({element:t,mouseenter:e=>sm.currentOverElement=e.target,keydown:e=>sm.currentOverElement=e.target,capture:!0,thisObj:r}),n.set(sm,r)}return r}static encodeConfig(e){const t={};if("string"==typeof e)t.btip=e;else for(const n in e)t[`btip${"html"===n?"":V.capitalize(n)}`]=e[n];return t}}sm.initClass(),Object.defineProperty(hd,"tooltip",{get:()=>sm.getSharedTooltip(document.body,document.body)}),hd.Tooltip=sm,sm._$name="Tooltip";class om extends dg{static type="tip";static get configurable(){return{align:"t10-b50",offset:20,tooltip:{$config:["lazy","nullify"],value:{type:"tooltip"}}}}open(){this.getConfig("tooltip")}close(){var e;null===(e=this.tooltip)||void 0===e||e.hide()}dragMove(e){const{offset:t,tooltip:n}=this,{event:i}=e;n&&(n.isVisible||n.show(),n.alignTo({align:this.align,target:new _t(i.clientX-t,i.clientY-t,2*t,2*t)}))}changeTooltip(e,t){return hd.reconfigure(t,e,this)}}om.initClass(),om._$name="DragTipProxy";var am=e=>class extends(e||tt){static $name="Labelable";static configurable={label:null,labelPosition:"before",labelCls:null,labelWidth:{value:null,$config:{localeKey:"L{labelWidth}"}}};get hasLabel(){return Boolean(this.label)}compose(){const{hasLabel:e,labelPosition:t}=this;return{class:{[`b-label-${t}`]:e,"b-has-label":e}}}changeLabel(e){return e||""}setupLabel(e){return U.assign({tag:"label",for:`${this.id}-input`,class:`b-label b-align-${e.align||"start"}`},e)}updateLabelWidth(e){this.labelElement&&(this.labelElement.style.flex=`0 0 ${ki.setLength(e)}`,this.inputWrap&&(this.inputWrap.style.flexBasis=null==e?"":"auto"))}get widgetClass(){}},lm=(e=tt)=>class extends(e.mixin(dr)){static $name="Validatable";get widgetClass(){}doDestroy(){const e=this,t=e._rootElement&&e.constructor.getSharedErrorTooltip(e._rootElement,{doNotCreate:!0,cachePath:e.errorTooltipCachePath});super.doDestroy(),(null==t?void 0:t.field)===e&&t.hide()}get errorTip(){return this.constructor.getSharedErrorTooltip(this.rootElement,{cachePath:this.errorTooltipCachePath,tooltipConfig:this.errorTooltipConfig})}static get errorTip(){return this.getSharedErrorTooltip(document.body)}static getSharedErrorTooltip(e,t={}){var n;const{doNotCreate:i,cachePath:r="errorTooltip",tooltipConfig:s}=t;let o=null===(n=e.bryntum)||void 0===n?void 0:n[r];return o||i||(e.bryntum=e.bryntum||{},o=sm.new({cls:"b-field-error-tip",forSelector:".b-field.b-invalid .b-field-inner",align:{align:"l-r",monitorTargetMutation:!0},axisLock:"flexible",scrollAction:"realign",trapFocus:!1,rootElement:e,onBeforeShow(){const e=this,t=hd.fromElement(e.activeTarget);if(t){const n=t.getErrors();if(n)return e.html=n.join("<br>"),e.field=t,!0}return!1}},s),e.bryntum[r]=o),o}setError(e,t,n){const i=this,r=Object.keys(i.errors||{}).length;(i.errors||(i.errors={}))[e]=i.optionalL(e);const s=Object.keys(i.errors).length;if(s!==r&&i.trigger("validityChange",{valid:0===s,bubbles:!0}),t||i.syncInvalid(),n){const t=()=>{i.clearError(e),n()},n=i.ion({keydown:t,focusOut:t})}}clearError(e,t){const n=this;n.errors&&Object.keys(n.errors).length>0&&(e?delete n.errors[e]:n.errors={},n.trigger("validityChange",{valid:0===Object.keys(n.errors).length,bubbles:!0})),t||n.syncInvalid()}getErrors(){const e=this;if(!e.isValid){var t,n;const i=e.validity,r=U.keys(i).find((e=>"valid"!==e&&"customError"!==e&&i[e])),s=e.errors&&Object.values(e.errors),o=(null===(t=e.formatter)||void 0===t?void 0:t.is.percent)??!1;let a;if(a=null!=s&&s.length?s:i.customError?[e.input.validationMessage]:r?[e.L(r,{min:o?100*e.min+"%":e.min,max:o?100*e.max+"%":e.max})]:[e.L(e.invalidValueError)],(null===(n=a)||void 0===n?void 0:n.length)>0)return a}}syncInvalid(){const e=this,{isPainted:t}=e;if(e.updatingInvalid=!0,t){const{isValid:t,element:n,inputWrap:i}=e;if(n.classList[t?"remove":"add"]("b-invalid"),t){const t=e.constructor.getSharedErrorTooltip(e.rootElement,{doNotCreate:!0,cachePath:this.errorTooltipCachePath});null!=t&&t.isVisible&&t.field===e&&t.hide()}else if(i){const t=e.errorTip;t&&(e.containsFocus||e.isVisible&&ki.isDescendant(i,sm.currentOverElement))&&(t.activeTarget===i&&t.isVisible?t.onBeforeShow():(t.activeTarget=i,t.showBy(i)))}}e.updatingInvalid=!1}};class cm extends Id{static $name="FieldContainer";static type="fieldcontainer";static get configurable(){return{animation:{duration:300},collapsed:null,collapser:{value:null,$config:"nullify"},syncableConfigs:null,syncConfigTriggers:{$config:{merge:"classList"},value:null},testConfig:{animation:{duration:10}}}}static get delayable(){return{syncChildConfigs:"raf"}}get inline(){return this.owner.inline??1===this.ensureItems().count}changeCollapsed(e){if(this.togglingCollapse)return this.togglingCollapse=!1,e;this.toggleCollapse(Boolean(e))}updateCollapsed(e){var t;this.collapser=null===(t=this.collapser)||void 0===t?void 0:t.destroy(),this.setCollapsedCls(e)}updateCollapser(e,t){t&&null==t.completed&&(t.reverting&&e||t.destroy()),this.setOwnerCls("b-collapsing",e)}get collapsing(){const{collapser:e}=this;return null!=e&&e.collapsed}get collapsingExpanding(){return null!=this.collapser}get expanding(){const{collapser:e}=this;return null!=e&&!e.collapsed}collapse(e){this.toggleCollapse(!0,e)}expand(e){this.toggleCollapse(!1,e)}setCollapsedCls(e){this.setOwnerCls("b-collapsed",e)}setOwnerCls(e,t){var n;null===(n=this.owner)||void 0===n||null===(n=n.element)||void 0===n||n.classList[t?"add":"remove"](e)}syncChildConfigs(){const e=this,{owner:t,syncableConfigs:n}=e;if(n){let i,r;for(i in n)r=n[i](t),e.eachWidget((e=>{e[i]=r}),!1)}t.afterSyncChildConfigs(e)}syncContainer(){const{inline:e,layout:t}=this;this.autoLayout&&(t.horizontal=e,t.justify=e?"center":"stretch")}toggleCollapse(e,t){const n=this,{animation:i,collapser:r,inline:s}=n,{containerWrapElement:o}=n.owner,a=t=>{t&&(n.element.style.height="",n.togglingCollapse=!0,n.collapsed=e,n.collapser=null)};if(null==e&&(e=!n.collapsed),!1!==t&&null!==t&&(o&&n.isVisible?(!0===t?t={}:"number"==typeof t&&(t={duration:t}),t=i||t?U.merge({},i,t):null):t=null),t){if(r&&e!==r.collapsed)n.collapser=r.revert({finalize:a}),n.collapser.collapsed=e;else if(!r&&e!==n.collapsed){!e&&n.setCollapsedCls(!1);const{element:i}=n,{height:r}=i.getBoundingClientRect(),l=s?1:r;!e&&n.setCollapsedCls(!0),i.style.height=`${r}px`,n.collapser=Vd.run(U.merge({finalize:a,element:o,[s?"opacity":"height"]:{from:e?l:0,to:e?0:l}},t)),n.collapser.collapsed=e}}else n.togglingCollapse=!0,n.collapsed=e}}cm.initClass(),cm._$name="FieldContainer";const dm=(e,t)=>(e.weight||0)-(t.weight||0),um=(e,t)=>(t.weight||0)-(e.weight||0),hm=[],gm={align:!0,weight:!0};class mm extends(hd.mixin(Mu,am,lm)){static $name="Field";static type="field";static configurable={role:null,defaultBindProperty:"value",skipValidation:null,placeholder:null,value:"",name:null,labels:null,required:null,showRequiredIndicator:null,clearable:null,revertOnEscape:null,hint:null,hintHtml:null,inputWidth:null,keyStrokeChangeDelay:0,readOnly:null,editable:!0,defaultAction:"change",stepTriggers:null,triggers:null,highlightExternalChange:!1,localizableProperties:["label","title","placeholder","labelWidth","hint"],autoSelect:!1,autoComplete:"off",spellCheck:null,validateOnInput:!0,inputAttributes:null,inputType:"text",inputAlign:null,attributes:{value:["placeholder","ariaLabel","autoComplete","spellCheck","minLength","maxLength","pattern","tabIndex","min","max"],$config:{merge:"distinct"}},nullValue:{$config:null,value:null,default:null},updatedClsDuration:500,inputReadOnly:!1,ariaElement:"input",container:{$config:"nullify",value:null},containerDefaults:{type:"fieldcontainer",syncableConfigs:{disabled:e=>e.disabled},syncConfigTriggers:{disabled:1}},containValues:null,inline:null,testConfig:{updatedClsDuration:10},keyMap:{},twinSyncConfigs:["value"],inputTag:{$config:null,value:"input",default:"input"}};static get delayable(){return{highlightChanged:"raf"}}doDestroy(){var e,t,n;const i=this,{triggers:r}=i;if(null===(e=i.inputListenerRemover)||void 0===e||e.call(i),null===(t=i.keyListenerRemover)||void 0===t||t.call(i),null===(n=i.container)||void 0===n||n.destroy(),super.doDestroy(),r)for(const e of Object.values(r))e.destroy()}get childItems(){const{container:e,triggers:t}=this,n=t?Object.values(t):[];return e?[...n,...e.childItems]:n}get invalidValueError(){return"L{invalidValue}"}construct(e={}){super.construct(e);const t=this;t.keyStrokeChangeDelay&&(t.changeOnKeyStroke=t.buffer(t.internalOnChange,t.keyStrokeChangeDelay)),!t.ariaLabel&&t.placeholder&&t.updateAriaLabel(t.placeholder)}changeKeyMap(e){const t=this;let n={};e&&(t._fieldKeyMap?U.assign(n,t._fieldKeyMap):(t._fieldKeyMap=e,U.assign(n,e)));for(const e in t.triggers){var i;null!==(i=t.triggers[e])&&void 0!==i&&i.keyMap&&(n=t.mergeKeyMaps(n,t.triggers[e].keyMap,e))}return n}get keyMapSubComponents(){return this.triggers}onFocusIn(e){const t=this;t.valueOnFocus=U.clone(t.value),t.validOnFocus=!(t.errors&&Object.keys(t.errors).length),super.onFocusIn(e),t.focusing=!0,t.syncInvalid(),t.focusing=!1}onFocusOut(e){super.onFocusOut(e),this.syncRequired(),this.onEditComplete()}onEditComplete(){}get rootUiClass(){return mm}compose(){this.getConfig("clearable");const e=this,{container:t,innerElements:n,label:i,labels:r,labelCls:s,readOnly:o,stepTriggers:a,triggers:l,required:c,showRequiredIndicator:d}=e,u=U.values(l,((e,t)=>!t)),h=u.filter((e=>"start"===e.align)).sort(dm),g=u.filter((e=>"start"!==e.align)).sort(um),m=e.setupLabel.bind(e),p=[...h.map((e=>e.element)),...n,...g.map((e=>e.element))];return{class:{"b-has-step-triggers":a,"b-has-start-trigger":h.length,"b-no-input":!n.length,"b-readonly":o,"b-field-container":Boolean(t),"b-field-container-inline":null==t?void 0:t.inline,"b-required":Boolean(c&&d)},children:[...(r||hm).filter((e=>e&&"end"!==e.align)).map(m),i?m({reference:"labelElement",class:`b-label b-align-start ${s||""}`,html:i}):null,p.length?{class:"b-field-inner",reference:"inputWrap",children:p}:null,...(r||hm).filter((e=>"end"===(null==e?void 0:e.align))).map(m),...t?[{reference:"containerWrapElement",children:[t.element],class:{"b-field-container-wrap":1}}]:hm]}}updateElement(e,t){var n;const i=this,r=i.initialConfig.value,{input:s}=i;super.updateElement(e,t),null!=r&&(i.value=r),i.syncEmpty(),i.updateInputReadOnly(i.inputReadOnly),i.syncInvalid();const o=s||i.focusElement;null===(n=i.keyListenerRemover)||void 0===n||n.call(i),i.keyListenerRemover=o&&Mn.on({element:o,thisObj:i,keydown:"internalOnKeyEvent",keypress:"internalOnKeyEvent",keyup:"internalOnKeyEvent"})}get innerElements(){return[this.inputElement]}get inputElement(){const{attributes:e,inputAttributes:t,id:n,inputCls:i,inputType:r,name:s,inputTag:o}=this,a=U.merge({reference:"input",tag:o,type:r,name:s||n,id:`${n}-input`,retainElement:"prevent-release",dataset:this.isPasswordField?null:{opIgnore:!0}},t);i&&(a.class=i);for(let t,n,i=e.length;i-- >0;)t=e[i],n=this[t],null!=n&&(a[V.hyphenateAttributeName(t)]=n);return a}get caretPos(){return this.textSelection[0]}set caretPos(e){this.textSelection=e}get focusElement(){return this.input}get textSelection(){const e=this.input;let t;try{t=[e.selectionStart,e.selectionEnd,e.selectionDirection]}catch(i){var n;t=(null===(n=e.value)||void 0===n?void 0:n.length)||0,t=[t,t]}return t}set textSelection(e){"number"==typeof e?this.select(e,e):this.select(...e)}get hasTextSelection(){const[e,t]=this.textSelection;return e&&t-e>0}getAfterValue(e){const[t,n]=this.textSelection,i=this.input.value;return`${i.substr(0,t)}${e}${i.substr(n||t)}`}select(e,t){const n=this.focusElement;if(n.value.length){if(0===arguments.length)return void this.selectAll();if(!this.supportsTextSelection)return;n.setSelectionRange(e,t)}}moveCaretToEnd(){const e=this.input;if(e.createTextRange){const t=e.createTextRange();t.collapse(!1),t.select()}else this.supportsTextSelection&&this.select(e.value.length,e.value.length)}selectAll(){var e,t;null===(e=(t=this.focusElement).select)||void 0===e||e.call(t)}get caretAtEnd(){return this.textSelection[1]===this.input.value.length}get caretAtStart(){return!this.textSelection[1]}get selectedAll(){const{textSelection:e}=this;return!e[0]&&e[1]===this.input.value.length}syncEmpty(){var e;const{isEmptyInput:t,isEmpty:n,element:i}=this,r=null===(e=this.triggers)||void 0===e?void 0:e.clear,s=t&&n;i&&(r&&r[s?"hide":"show"](),i.classList.toggle("b-empty",s))}updateHint(){this.syncHint()}updateHintHtml(){this.syncHint()}syncHint(){const e=this,{input:t,hint:n,hintHtml:i}=e,r=null==t?void 0:t.parentElement;if(t){let s=i||n;const o=e.hintElement||s&&(e.hintElement=ki.createElement({parent:r,className:"b-field-hint",nextSibling:t.nextSibling,children:[{className:"b-field-hint-content"}]}));o&&("function"==typeof s&&(s=s({source:e,value:e.value})),o.firstChild[i?"innerHTML":"textContent"]=s||""),e.element.classList[s?"remove":"add"]("b-field-no-hint")}}updateInputTag(e){e&&e!==this.getDefaultConfiguration().inputTag&&(this.dontCache=!0)}updateEditable(){this.syncInputReadOnly()}syncInputReadOnly(){this.getConfig("readOnly"),this.inputReadOnly=this._readOnly||!1===this.editable}updateInputReadOnly(e){const t=this,{input:n,inputListenerRemover:i}=t;n&&(n.readOnly=e?"readOnly":null,e?t.inputListenerRemover=null==i?void 0:i():i||(t.inputListenerRemover=Mn.on({element:n,thisObj:t,focus:"internalOnInputFocus",change:"internalOnChange",input:"internalOnInput"})))}changeReadOnly(e){return Boolean(e)}updateReadOnly(e){this.syncInputReadOnly()}updateRequired(e){this.syncRequired()}updateClearable(e){const t=this;t.getConfig("triggers"),t.triggers={clear:e&&U.assign({cls:"b-icon-remove",weight:1e3,handler:t.clear},e)||null}}changeTriggers(e,t){const n=this,i=n.$triggers||(n.$triggers=new pu({configName:"triggers",factory:mm.Trigger,inferType:!1,owner:n,created(e){te.after(e,"onConfigChange",((e,{name:t})=>{gm[t]&&n.onConfigChange({name:"triggers",value:i.target})}))},setup(e,t){e.reference=e.ref=t,e.parent=n}}));if(e&&!n.stepTriggers&&(e.back||e.forward)&&(delete(e=U.assign({},e)).back,delete e.forward),i.update(e),n.element&&(n.keyMap=n.keyMap),!t)return i.target}updateInputWidth(e){this.input.style.width=ki.setLength(e),this.element.classList.add("b-has-width")}updateInputAlign(e){this.input.style.textAlign=e}get isValid(){const e=this;if(!e.disabled&&!e.skipValidation){if(e.syncRequired(),e.checkValidity&&e.callback(e.checkValidity,e,[e]),e.errors&&Object.keys(e.errors).length)return!1;const t=e.validity;if(t)return t.valid}return!0}get isClear(){return this.isEmpty&&this.isEmptyInput}get isEmpty(){const{value:e}=this;return null==e||""===e||e===this.nullValue}get isEmptyInput(){return!this.input||null==this.input.value||""===this.input.value}get validity(){const e=this.input;return null==e?void 0:e.validity}async setValue(e){this.value=e}changeValue(e,t){return null==e&&(e=this.nullValue),this.hasChanged(t,e)?e:(""===e&&this.syncRequired(),t)}updateValue(e,t){const n=this;n.isConfiguring||(n.syncRequired(),n.inputting||n.triggerChange()),n.inputting||(n._lastValue=e),n.syncInputFieldValue()}hasChanged(e,t){return t!==e}syncInputFieldValue(e=!1){const t=this,{input:n,parent:i,inputValueAttr:r,inputValue:s}=t;if(n&&!t.inputting&&n[r]!==s&&(n[r]=s,!t.isConfiguring&&!t.containsFocus&&t.highlightExternalChange)){if(n.classList.remove("b-field-updated"),t.clearTimeout("removeUpdatedCls"),i){const{assigningValues:t}=i;!0!==t&&!1!==(null==t?void 0:t.highlight)||(e=!0)}e||t.highlightChanged()}t.syncEmpty(),t.syncInvalid()}setValueSilently(e){this.inputting=!0,this._value=e,this.syncInputFieldValue(),this.inputting=!1}highlightChanged(){this.input.classList.add("b-field-updated"),this.setTimeout("removeUpdatedCls",this.updatedClsDuration)}removeUpdatedCls(){this.input.classList.remove("b-field-updated")}get inputValue(){return null==this.value?"":this.value}get inputValueAttr(){return"value"}get supportsTextSelection(){const e=this.focusElement;return e&&ki.isTextualInput(e)}updatePlaceholder(e){this.ariaLabel||this.updateAriaLabel(e),this.input&&(null==e?this.input.removeAttribute("placeholder"):this.input.placeholder=e)}internalOnInputFocus(){this.autoSelect&&this.selectAll()}internalOnChange(e){const t=this;t.hasChanged(t._lastValue,t.value)&&t.isValid&&(t.triggerChange(e,!0),t._lastValue=t.value)}triggerChange(e,t=Boolean(this._isUserAction)){const n=this,{value:i,_lastValue:r,isValid:s}=n;n.syncHint(),n.triggerFieldChange({value:i,oldValue:r,event:e,userAction:t,valid:s}),"change"===n.defaultAction&&n.trigger("action",{value:i,oldValue:r,event:e,userAction:t,valid:s})}fetchInputValue(){this.value=this.input[this.inputValueAttr]}internalOnInput(e){var t;const n=this;n.validateOnInput||n.errorTip.hide(),n.inputting=!0,n.fetchInputValue(),n.inputting=!1,n.trigger("input",{value:n.value,event:e}),null===(t=n.changeOnKeyStroke)||void 0===t||t.call(n,e)}get needsInputSync(){return this.input[this.inputValueAttr]!==String(this.inputValue??"")}internalOnKeyEvent(e){const t=this,{value:n}=t;let i=!1;if(t._isUserAction=!0,"keydown"===e.type&&"Escape"===e.key&&!t.readOnly&&!t.disabled){const r=t.isValid,s="initialValue"in t?t.initialValue:t.valueOnFocus,o=t.hasChanged(s,n),{needsInputSync:a}=t;t.revertOnEscape&&(!r||o||a)?(!o&&r||(t.value=s),a&&t.syncInputFieldValue(!0),t.clearError(),i=(o||a)&&t.isValid||r!==t.validOnFocus):!t.isEmpty&&t.clearable&&t.revertOnEscape&&!r&&(t.clear(),e.stopPropagation())}t.isDestroyed||(i&&e.stopImmediatePropagation(),t.trigger(e.type,{event:e})),t._isUserAction=!1}clear(e){const t=this;t.isClear||(t.value=t.nullValue,t.clearError(),t.syncInvalid(),t.input&&ki.isTextualInput(t.input)&&(t.input.value=""),t.trigger("clear",{event:e}),null==e||e.stopImmediatePropagation())}onDisabled(){this.syncInvalid()}syncRequired(){var e;const t=this;t.isConfiguring||t.focusing&&!t.focusVisible||!t.required||!t.isEmpty||null!==(e=t.parent)&&void 0!==e&&e.isSettingValues?t.clearError("L{fieldRequired}",t.updatingInvalid):t.setError("L{fieldRequired}",t.updatingInvalid)}get containerCollapsed(){var e;return null===(e=this.container)||void 0===e?void 0:e.collapsed}set containerCollapsed(e){const{container:t}=this;t&&(t.collapsed=e)}afterSyncChildConfigs(e){}changeContainer(e,t){e&&(Array.isArray(e)||!("type"in e)&&!("items"in e))&&(e={items:e});const n=this,i=e&&U.merge({owner:n,layout:"box"},n.containerDefaults),r=hd.reconfigure(t,e,{owner:n,defaults:i});if(!r||(r.autoLayout="box"===(null==i?void 0:i.layout),r!==t))return r;r.syncContainer()}onConfigChange(e){var t;super.onConfigChange(e),null!==(t=this.container)&&void 0!==t&&null!==(t=t.syncConfigTriggers)&&void 0!==t&&t[e.name]&&this.container.syncChildConfigs()}assignValue(e,t){const n=this,{container:i,containValues:r}=n,s=n.getValueName(t),o=e&&s in e;n.assigningValue=!0,i&&!1!==r?e&&"nested"===r?o&&(e=U.clone(e[s]),super.assignValue({[s]:e&&!("value"in e)||e.value},t),e&&delete e.value,i.assignValue(e,t)):(super.assignValue(e,t),i.assignValue(e,t)):super.assignValue(e,t),n.assigningValue=!1}gatherValue(e){super.gatherValue(e),this.gatherValues(e)}gatherValues(e,t){const n=this,{container:i,containValues:r,valueName:s}=n,o=typeof r;t=t??s in e,i&&!1!==r&&("nested"===r?t&&(e[s]={value:e[s],...i.values}):(!0===r||null==r&&t||"string"===o&&n[r]||"function"===o&&r(n))&&i.gatherValues(e))}updateContainer(e,t){t&&this.detachListeners(t.id),e&&(e.rendered||e.render(),e.syncContainer(),e.syncChildConfigs())}}mm.Trigger=class extends hd{static $name="FieldTrigger";static get factoryable(){return{defaultType:mm.Trigger,extends:null}}static type="trigger";static configurable={align:null,weight:null,role:null};get field(){return this.parent}construct(...e){super.construct(...e),this.key&&(this.keyMap={[this.key]:"onClick"})}compose(){return{"aria-hidden":!0,class:{[`b-align-${this.align||"end"}`]:1,"b-icon":1},listeners:{click:"onClick",mousedown:"onMousedown"}}}changeAlign(e){return e}onClick(e){const t=this,{field:n}=t;n.disabled||n.readOnly||(e.key&&e.preventDefault(),!1!==n.trigger("trigger",{trigger:t})&&t.handler&&(n._isUserAction=!0,n.callback(t.handler,n,[e,t]),n._isUserAction=!1))}onMousedown(e){const t=this.field;!("key"in e)&&ki.isTouchEvent&&t.editable&&(t.editable=!1,t.setTimeout((()=>t.editable=!0),500)),e.preventDefault(),ki.getActiveElement(t.input)!==t.input&&t.focus()}},mm.SpinTrigger=class extends mm.Trigger{static $name="SpinTrigger";static type="spintrigger";static configurable={repeat:{$config:["nullify"],value:!0}};compose(){return{children:{upButton:{class:{"b-icon":1,"b-spin-up":1}},downButton:{class:{"b-icon":1,"b-spin-down":1}}}}}updateRepeat(e){var t;null===(t=this.clickRepeater)||void 0===t||t.destroy(),this.clickRepeater=e?Hd.new({element:this.element},e):null}onClick(e){const t=this,{field:n}=t;n._isUserAction=!0,n.disabled||n.readOnly||(e.target===t.upButton?n.doSpinUp(e.shiftKey):e.target===t.downButton&&n.doSpinDown(e.shiftKey)),n._isUserAction=!1}get isFocusable(){return!this.disabled&&super.isFocusable}},mm.Trigger.initClass(),mm.SpinTrigger.initClass(),hd.register(mm.Trigger,"trigger"),hd.register(mm.SpinTrigger,"spintrigger"),mm._$name="Field";class pm extends md{static $name="Fit";static type="fit";static configurable={containerCls:"b-fit-container",itemCls:"b-fit-item"}}pm.initClass(),pm._$name="Fit";const fm=document.createRange();class vm extends hd{static $name="List";static type="list";static configurable={itemCls:"b-list-item",selectedCls:"b-selected",selectIconCls:"b-icon-check",tag:"ul",items:null,displayField:"text",store:{value:{},$config:"lazy"},navigator:!0,scrollable:{overflowX:!1,overflowY:!0},itemsFocusable:!0,multiSelect:!1,toggleAllIfCtrlPressed:!1,collapsibleGroups:!1,selectAllItem:!1,itemTpl(e){let t=V.encodeHtml(e.getValue(this.displayField));return null!=t&&""!==t||(t="&nbsp;"),t},tooltipTemplate:null,getItemStyle:null,getItemCls:null,groupHeaderTpl(e,t){let n=V.encodeHtml(t);return null!=n&&""!==n||(n="&nbsp;"),`${(this.allowGroupSelect||e.isParent)&&this.isSelectable(e)?this.itemIconTpl(e):""}${n}`},allowGroupSelect:!0,clearSelectionOnEmptySpaceClick:!1,selected:{$config:["nullify","lazy"],value:[]},activateOnMouseover:null,role:"listbox",keyMap:{"Ctrl+a":"selectAll"},title:null,virtualize:null,listItemHeight:10,isSelectable:()=>!0,emptyText:null};construct(e,...t){var n;const i=this;Array.isArray(e)&&(e={items:e}),super.construct(e,...t);const{element:r}=i,{classList:s}=r;i.multiSelect&&s.add("b-multiselect"),null!==(n=i.store)&&void 0!==n&&n.count?i.refresh():s.add("b-empty"),Mn.on({element:r,click:"onClick",thisObj:i})}doDestroy(){var e;this.detachListeners("store"),null===(e=this.navigator)||void 0===e||e.destroy(),super.doDestroy()}changeScrollable(e){return(e=super.changeScrollable(e))&&this.title&&(e.stickies=".b-list-title"),e}onFocusIn(e){var t;this.restoreActiveItem(null===(t=e._target)||void 0===t?void 0:t.closest(this.itemSelector)),super.onFocusIn(e)}get isVirtualized(){return"number"==typeof this.virtualize?this.store.count>this.virtualize:Boolean(this.virtualize)}outOfViewTpl(e,t){return`<li class="b-list-item b-out-of-view" data-index="${t}" aria-posinset="${t+1}" aria-setsize="${this.store.count}" data-id="${V.encodeHtml(e.id)}"></li>`}onItemIntersection(e,t){if(t){const t=this,n=parseInt(e.dataset.index),i=t.store.getAt(n);i&&ki.sync(t.callback(t.itemWrapperTpl,t,[i,n,t]),e),t.itemIntersectionObserver.unobserve(e)}}contentTpl(){const e=this,t=Math.ceil(e.height/e.listItemHeight),n=e.store.records.map(((n,i)=>!e.isVirtualized||i<t?e.callback(e.itemWrapperTpl,e,[n,i,e]):e.outOfViewTpl(n,i)));if(e.multiSelect&&!1!==e.selectAllItem&&n.unshift(e.selectAllItemTpl()),e.title){const t=`${e.id}-title`;n.unshift(`<li id="${t}" class="b-list-item b-list-title" data-noselect>${V.encodeHtml(e.title)}</li>`),e.element.setAttribute("aria-labelledby",t)}else e.element.removeAttribute("aria-labelledby");return e.emptyText&&0===e.store.count&&n.push(`<li class="b-list-item b-empty-text">${e.L(e.emptyText)}</li>`),yh.tpl`${n}`}itemWrapperTpl(e,t,n){const{selected:i,getItemStyle:r,store:s,tooltipTemplate:o}=n,a=(null==o?void 0:o(e))||"",l=[...s.excludeCollapsedRecords?[`--tree-level:${e.childLevel||0}`]:[],...r?[n.callback(r,n,[e])]:[]].join(";"),c=l.length?`style="${l}"`:"",d=n.callback(n.isSelectable,n,[e]);return s.isGrouped&&!e.isGroupHeader&&e.instanceMeta(s).groupParent.meta.collapsed?"":e.ancestorsExpanded(s)?yh.tpl`<li ${c} aria-posinset="${t+1}" aria-setsize="${this.store.count}" class="${n.getItemClasses(e,t)}" role="option" ${a?`data-btip="${V.encodeHtml(a)}"`:""} aria-selected="${i.includes(e)}" data-index="${t}" ${d?"":"data-noselect"} data-id="${V.encodeHtml(e.id)}" ${n.itemsFocusable?'tabindex="-1"':""}>${n.itemContentTpl(e,t)}</li>`:""}itemContentTpl(e,t){const n=this;if(e.isGroupHeader||e.isParent&&!1!==n.store.excludeCollapsedRecords){let t=n.groupHeaderTpl(e,e.isParent?n.callback(n.itemTpl,n,[e]):V.capitalize(e.meta.groupRowFor));if(n.collapsibleGroups||e.isParent){const i=e.isParent?e.instanceMeta(n.store).collapsed:e.meta.collapsed,r=i?"right":"down";t+=`<button aria-label="${n.L("L{Object."+(i?"expand":"collapse")+"}")}" class="b-button b-tool b-icon b-icon-collapse-${r} b-list-expander-icon" data-noselect></button>`}return t}return`${n.itemIconTpl(e,t)}${n.callback(n.itemTpl,n,[e])}`}itemIconTpl(e,t){return this.multiSelect&&this.callback(this.isSelectable,this,[e])?`<i aria-hidden="true" role="presentation" class="b-selected-icon b-icon ${this.selectIconCls}"></i>`:""}selectAllItemTpl(){const e=this.allSelected?"b-selected":"";return`<li class="${this.itemCls} b-select-all-item ${e}" data-select-all data-id="select-all" ${this.itemsFocusable?'tabindex="-1"':""}>${this.itemIconTpl({})}<div>${this.L("L{selectAll}")}</div></li>`}getItemClasses(e){var t,n;const i=this,{getItemCls:r,store:s}=i,o=null===(t=i._navigator)||void 0===t?void 0:t.activeItem,a=(null==o?void 0:o.dataset.id)==e.id,l="groupRowFor"in e.meta?"b-list-item-group-header":s.excludeCollapsedRecords&&e.isParent?"b-list-item-tree-parent":"",c=i.selected.includes(e)||(null===(n=e.groupChildren)||void 0===n?void 0:n.every((e=>i.selected.includes(e)))),d=r?this.callback(r,this,[e]):"";return`${i.itemCls} ${e.cls||""} ${d} ${c?i.selectedCls:""} ${a?i.navigator.focusCls:""} ${l}`}onBeforeStoreLoad(){this.mask(this.L("L{loading}"))}onAfterStoreRequest(){this.unmask()}onStoreChange({source:e,action:t,records:n,record:i,changes:r,isCollapse:s}){const o=this,{selected:a}=o;switch(t){case"dataset":a.match(e.storage,!o._externallyOwnedSelection);break;case"remove":s||a.remove(n);break;case"clear":o.deselectAll();break;case"update":{const{id:e}=r;return e&&ki.setAttributes(o.contentElement.querySelector(V.encodeAttributeSelector("data-id",e.oldValue)),{"data-id":e.value}),void o.refreshItem(i)}}o.refresh()}onStoreRefresh(){this._selected?this.refresh():this.getConfig("selected")}refresh(){const e=this;if(e.isVisible&&e.store){var t;const i=null===(t=e.navigator)||void 0===t?void 0:t.activeItem;e.itemIntersectionObserver&&(e.itemIntersectionObserver.disconnect(),e.itemIntersectionObserver=null),e.paintListener=null;const r=ki.createElementFromTemplate(e.contentTpl(),{fragment:!0});if(e.clearItems().insertNode(r),e.element.classList.toggle("b-virtualized",e.isVirtualized),e.isVirtualized){var n;e.itemIntersectionObserver=new IntersectionObserver((t=>{for(const n of t)e.onItemIntersection(n.target,n.isIntersecting,n)}));for(const t of e.element.querySelectorAll(e.itemSelector))e.itemIntersectionObserver.observe(t);e.listItemHeight=null===(n=e.element.children[0])||void 0===n?void 0:n.clientHeight}i&&e.restoreActiveItem(i),e.refreshCount=(e.refreshCount||0)+1,e.element.classList.toggle("b-empty",0===e.store.count),e.updateSelectAllState()}else e.paintListener||(e.paintListener=e.once("paint","refresh"))}clearItems(){const e=this,{contentElement:t}=e,n=t.querySelector(e.itemSelector),i=t.lastChild;if(n){const i=t.querySelectorAll(`${e.itemSelector}:not(.b-mask)`);fm.setStartBefore(n),fm.setEndAfter(i[i.length-1]),fm.deleteContents()}else i?(fm.setStartAfter(i),fm.setEndAfter(i)):(fm.setStart(t,0),fm.setEnd(t,0));return fm}refreshItem(...e){for(const t of e){const e=this,n=e.getItem(t);if(n){const i=e.store.indexOf(t),r=ki.createElementFromTemplate(e.callback(e.itemWrapperTpl,e,[t,i,e]));ki.sync(r,n)}}}getItem(e){var t;if(null!=e)return"number"==typeof e?this.contentElement.querySelector(`[data-index="${e<0?this.store.count+e:e}"]`):(e.nodeType===Element.ELEMENT_NODE&&(e=e.dataset.id),null!=(null===(t=e)||void 0===t?void 0:t.id)&&(e=e.id),this.contentElement.querySelector(V.encodeAttributeSelector("data-id",e)))}getRecordFromElement(e){return e.target&&(e=e.target),e=e.closest(this.itemSelector),this.store.getAt(parseInt(e.dataset.index))}updateItems(e){this.store.data=rt.asArray(e??[]).map((e=>"string"==typeof e?{[this.displayField]:e}:e))}updateDisabled(e,t){super.updateDisabled(e,t),this.navigator&&(this.navigator.disabled=e)}updateLocalization(){super.updateLocalization(),this.refresh()}updateTitle(){this.refresh()}changeSelected(e,t){const n=this,i={change:"onInternalSelectionChange",thisObj:n};if(e){if(e.isCollection)n._externallyOwnedSelection=!0,e.ion(i);else if(n._externallyOwnedSelection=!1,e=rt.asArray(e).reduce(((e,t)=>((t=t.isModel?t:n.store.getById(t))&&n.callback(n.isSelectable,n,[t])&&e.push(t),e)),[]),t)t.splice(0,t.count,e),e=t,n.refresh();else{const t=e;(e=n._selected=new _o({internalListeners:i})).add(t)}e!==t&&(null==t||t.un(i))}else null==t||t.destroy();return e}updateSelected(e){e&&this.refresh()}get itemSelector(){return`.${this.itemCls}`}get selected(){return this._selected}updateMultiSelect(e,t){const{_selected:n}=this;!e&&t&&(null==n?void 0:n.count)>1&&(n.suspendEvents(),this.deselect(n.allValues.slice(1)),n.resumeEvents()),this.isConfiguring||this.refresh()}get store(){return this.getConfig("items"),this._store}changeStore(e){const t=this;if(e instanceof Ol||(Array.isArray(e)&&(e={data:e}),e=new Ol(e)),t.detachListeners("store"),e){const n={name:"store",change:"onStoreChange",refresh:"onStoreRefresh",thisObj:t};e.readUrl&&(n.beforeLoad="onBeforeStoreLoad",n.afterRequest="onAfterStoreRequest"),e.isGrouped&&(t.element.classList.add("b-grouped"),n.groupchange="onStoreRefresh"),e.ion(n),e.tree&&e.traverse((t=>{t.isParent&&!t.expanded&&e.onNodeExpand(t)}))}return e}updateStore(e){null!=e&&e.records.length&&this.getConfig("selected"),this.refresh()}changeNavigator(e,t){const n=this,{element:i}=n;var r;i&&((null===(r=e=eg.reconfigure(t,e?eg.mergeConfigs({ownerCmp:n,disabled:n.disabled,target:i,keyEventTarget:i,activateOnMouseover:n.activateOnMouseover},e):null,n))||void 0===r?void 0:r.keyEventTarget)!==i||n.itemsTabbable||(i.tabIndex=0));return e}get minAlignHeight(){const e=this.element.lastElementChild,t=this.minHeight;if(null!=t)return e?Math.min(e.offsetTop+e.offsetHeight,t):0}alignTo(...e){super.minHeight=this.minAlignHeight,super.alignTo(...e)}hide(...e){return this.navigator&&(this.navigator.activeItem=null),super.hide(...e)}show(...e){const t=this,{refreshCount:n,navigator:i}=t,{previousActiveItem:r}=i;super.minHeight=t._minHeight;const s=super.show(...e);return t.refreshCount===n&&t.containsFocus&&t.restoreActiveItem(r,!0),s}restoreActiveItem(e=this.navigator.previousActiveItem,t="nearest"){const n=this,{navigator:i,lastAlignSpec:r}=n;if(null!=e){if("string"!=typeof t){const e=r?r.zone:1;t=1&e?"nearest":e?"start":"end"}(e=n.getItem(e))&&!n.disabled&&(n.scrollable.scrollIntoView(e,{block:t}),i.activeItem=e)}}onClick(e){const t=e.target.closest(this.itemSelector);t?this.onItemClick(t,e):this.clearSelectionOnEmptySpaceClick&&this.deselectAll()}onSpaceKey(e){const t=e.target.nodeName.toUpperCase();("INPUT"!==t&&"TEXTAREA"!==t||e.target.readOnly)&&this.onEnterKey(e)}onEnterKey(e){const t=this.navigator.activeItem;t&&!this.disabled&&(e.target=t,this.onItemClick(t,e),e.stopImmediatePropagation(),e.preventDefault())}onInternalKeyDown(e){const t=this;switch(e.key){case"ArrowLeft":t.collapseItem();break;case"ArrowRight":t.expandItem();break;case" ":t.onSpaceKey(e);break;case"Enter":t.onEnterKey(e)}}collapseItem(){const{activeItem:e}=this.navigator;e&&this.toggleCollapse(this.getRecordFromElement(e),!0)}expandItem(){const{activeItem:e}=this.navigator;e&&this.toggleCollapse(this.getRecordFromElement(e),!1)}onItemClick(e,t){const n=this,{allowGroupSelect:i}=n,r=parseInt(e.dataset.index),s=n.store.getAt(r),o=null==s?void 0:s.isSpecialRow,a=e.contains(t.target.closest("[data-noselect]"));if(!n.disabled&&!1!==n.trigger("beforeItem",{item:e,record:s,index:r,event:t,userAction:!0})){if(n._isUserAction=!0,e.contains(t.target.closest("[data-select-all]")))n.onSelectAllClick(e,t);else{if(t.target.matches(".b-list-expander-icon"))return void n.toggleCollapse(s);if(s&&!a&&(!o||i)){const{selected:r}=n,{groupParent:a}=s.instanceMeta(n.store);if(n.multiSelect){let l=r.includes(s),c=s;if(n.toggleAllIfCtrlPressed&&t.ctrlKey?c=n.store.records:i&&o&&(l=!s.groupChildren.some((e=>!r.includes(e))),e.classList.toggle("b-selected",!l),c=s.groupChildren),r[l?"remove":"add"](c),!o&&a&&i){n.getItem(a).classList.toggle("b-selected",a.groupChildren.every((e=>r.includes(e))))}}else r.splice(0,r.count,s)}}n.isDestroyed||(n.lastClicked=s,n.trigger("item",{item:e,record:s,index:r,event:t,userAction:!0}),n._isUserAction=!1)}}onInternalSelectionChange({action:e,removed:t,added:n,replaced:i}){const r=this,{selectedCls:s,unselectedCls:o}=r;let a,l;if("clear"===e)for(l of r.element.querySelectorAll(`.${s}`))l.classList.remove(s),l.setAttribute("aria-selected",!1),o&&l.classList.remove(o);else if("replaceValues"!==e){for(a of t)l=r.getItem(a),l&&(l.classList.remove(s),l.setAttribute("aria-selected",!1));for(a of n)l=r.getItem(a),l&&(l.classList.add(s),l.setAttribute("aria-selected",!0))}r.selectAllItem&&r.updateSelectAllState(),r.trigger("selectionChange",{selected:r.selected.values})}onSelectAllClick(e){e.classList.contains(this.selectedCls)?this.deselectAll():this.selectAll()}updateSelectAllState(){var e;null===(e=this.element.querySelector(".b-select-all-item"))||void 0===e||e.classList.toggle(this.selectedCls,this.allSelected)}updateAllowGroupSelect(){this.refresh()}get allSelected(){const{selected:e,store:t}=this;return e.count&&(t.isFiltered?t.records.every((t=>e.includes(t))):t.count===e.count)}selectAll(e){const t=this;!t.multiSelect&&e||(t.selected.add(t.store.records),e&&!t.navigator.activeItem&&(t.navigator.activeItem=t.getItem(-1)))}deselectAll(){this.selected.clear()}select(e,t=!1){const{store:n,selected:i}=this,{modelClass:r}=n;e=rt.asArray(e).reduce(((e,t)=>((t=n.getById(r.asId(t)))&&e.push(t),e)),[]),t&&i.count?i.splice(0,i.count,e):i.add(e)}deselect(e){const{modelClass:t}=this.store;e=rt.asArray(e).reduce(((e,n)=>((n=this.selected.get(t.asId(n)))&&e.push(n),e)),[]),this.selected.remove(e)}toggleCollapse(e,t){const{store:n}=this;e.isGroupHeader?(n[(t=void 0===t?!e.meta.collapsed:t)?"collapse":"expand"](e),this.refresh(),this.trigger("toggleGroup",{groupRecord:e,collapse:t})):e.isParent&&(t=void 0===t?!e.instanceMeta(n).collapsed:t,e.instanceMeta(n).collapsed=t,this.refresh(),this.trigger("toggleNode",{record:e,collapse:t}))}updateCollapsibleGroups(e,t){if(t&&!e){const{store:e}=this;e.groupRecords.forEach((t=>e.expand(t)))}this.refresh()}}vm.initClass(),vm.prototype.navigatorClass=eg,vm._$name="List";const ym=()=>!0,bm=(e,t)=>e.text.localeCompare(t.text);var Cm=e=>class extends e{static $name="FormulaField";static configurable={dataField:null,formulaPrefix:null};onFocusIn(...e){var t;(super.onFocusIn(...e),this.formulaProvider)&&(null===(t=this.fieldsList)||void 0===t||t.show())}onFocusOut(...e){var t;null===(t=this.fieldsList)||void 0===t||t.hide(),super.onFocusOut(...e)}internalOnKeyEvent(e,...t){const n=this,{key:i}=e,{fieldsList:r}=n;if("keydown"===e.type){if("Enter"!==e.key&&(n.lastKey=e.key),"Escape"===i&&null!=r&&r.isVisible)return e.stopImmediatePropagation(),void r.hide();n.formulaPrefix&&"ArrowDown"===i&&(e.preventDefault(),null!=r&&r.isVisible||n.showFieldsList())}super.internalOnKeyEvent(e,...t)}internalOnInput(...e){super.internalOnInput(...e),this.checkForFormula()}updateValue(...e){super.updateValue(...e),this.checkForFormula()}checkForFormula(){var e,t;this.formulaPrefix=null!==(e=this.dataField)&&void 0!==e&&e.inputPrefixRE?null===(t=this.value.match(this.dataField.inputPrefixRE))||void 0===t?void 0:t[1]:null}updateFormulaPrefix(e,t){var n,i;const r=this;var s;(r.formulaProvider=e&&(null===(n=r.dataField)||void 0===n||null===(i=n.getFormulaProvider)||void 0===i?void 0:i.call(n,e)),t&&r.input.classList.toggle(`b-${t.toLowerCase()}-input`,!1),r.formulaProvider)?(r.input.classList.toggle(`b-${e.toLowerCase()}-input`,!0),r.formulaProvider.setConfig({inputField:r,store:r.formulaStore}),r.whenVisible("showFieldsList")):null===(s=r.fieldsList)||void 0===s||s.hide()}get formula(){const{formulaProvider:e,value:t}=this;if(e){const{formulaRE:n}=e;return n?t.match(n):t}return""}showFieldsList(){var e;const t=this,{input:n}=t,i=null===(e=t.name)||void 0===e?void 0:e.replace(/^#/,""),r=t.up("gridbase",!0);let s=t.fieldsList;if(s)s.owner=t,s.widgetMap.fields.navigator.keyEventTarget=n;else{var o;t.fieldFilter=i&&new Eo((({id:e})=>e!==i));const{fieldNames:e}=t;s=t.fieldsList=new nh({title:"Fields",cls:"b-formula-fieldlist",floating:!0,forElement:t.inputWrap,scrollAction:"realign",owner:t,autoShow:!1,align:{matchSize:"min",align:"t0-b0",axisLock:!0,minHeight:40*Math.min(3,e.length)},layoutStyle:{padding:0},layout:"fit",items:{fields:{type:"list",items:e,itemsFocusable:!1,scrollable:{overflowY:!0},navigator:{keyEventTarget:n,activateOnMouseover:!0},getItemCls(e){if("this"===e.id||"data"===e.id)return"b-special-field"},onItem({event:e,record:n}){"click"===e.type&&(t.lastKey=null),e.key&&("Enter"!==e.key||"ArrowDown"!==t.lastKey&&"ArrowUp"!==t.lastKey)?e.stopImmediatePropagation=()=>delete e.stopImmediatePropagation:t.selectField(n.id)}}}}),null!==(o=t.owner)&&void 0!==o&&o.cellEditorContext?(r.ion({cellMousedown:"onCellMousedown",cellClick:"onCellClick",thisObj:t,prio:99999}),t.record=t.owner.cellEditorContext.record):t.record||(t.record=t.formulaProvider.record)}s.show(),s.activeItem=null}onCellMousedown({event:e}){this.fieldsList.isVisible&&(e.preventDefault(),e.stopImmediatePropagation())}onCellClick({event:e,column:{field:t}}){if(this.fieldsList.isVisible)return e.stopImmediatePropagation(),this.selectField(t),!1}selectField(e){var t;const n=this,{input:i}=n,r=i.value.trim(),{selectionStart:s}=i,o=s>=r.length,a=r.endsWith(")")?r.length:r.length+2;if(s>((null===(t=n.formulaProvider.prefix)||void 0===t?void 0:t.length)||0)+1&&s<a){var l,c;const t=`${o||null!==(l=r[s-1])&&void 0!==l&&l.match(/\s|\(/)?"":" "}$${e}${o||null!==(c=r[s])&&void 0!==c&&c.match(/\s|\)$/)?"":" "}`;i.setRangeText(t,s,s),i.selectionStart=s+t.length,n.inputting=!0,n.fetchInputValue(),n.inputting=!1}}get fieldNames(){const e=this;if(!e._fields){var t;const n=(null===(t=e.formulaStore)||void 0===t?void 0:t.modelClass)||e.record.constructor,{fieldMap:i}=n,{fieldFilter:r}=e,s=e._fields=n.fields.map((e=>{const t="string"==typeof e?e:e.name;return{id:t,text:i[t].label}})).filter(r?Eo.generateFiltersFunction([r]):ym).sort(bm);s.push({text:"Record",id:"this"},{text:"Store",id:"data"})}return e._fields}};class Sm extends(mm.mixin(Cm)){static $name="TextField";static type="textfield";static alias="text";static configurable={nullValue:""};construct(e,...t){"hidden"===(null==e?void 0:e.inputType)&&(e.hidden=!0),super.construct(e,...t)}getCurrentToken(e=/\s/){const{value:t,selectionStart:n}=this.input;let i=n,r=n+1;if(!t.length||null==n)return null;for(;i>0&&!t[i-1].match(e);)i--;for(;r<t.length&&!t[r].match(e);)r++;return{token:t.substring(i,r),cursor:n,start:i,end:r}}}Sm.initClass(),Sm._$name="TextField";class wm extends Sm{static $name="PickerField";static type="pickerfield";static get configurable(){return{editable:!0,pickerAlignElement:"inputWrap",value:null,triggers:{expand:{cls:"bars"}},autoExpand:null,picker:{value:{floating:!0},$config:["lazy","nullify"]},inputType:"text",monitorResize:!0,nullValue:null}}doDestroy(){var e;null===(e=this.globalTapListener)||void 0===e||e.call(this),super.doDestroy()}changeEditable(e){return d.isMobile&&!0!==this.initialConfig.editable&&(e=!1),e}updateEditable(e,...t){var n,i;const r=this,{element:s,ariaElement:o,nonEditableClickTarget:a}=r,{expand:l}=r.triggers,c=globalThis.matchMedia("(max-width: 410px)").matches;super.updateEditable(e,...t),s.classList.toggle("b-not-editable",!e),null===(n=r.globalTapListener)||void 0===n||n.call(r),null===(i=r.nonEditableClickTargetListener)||void 0===i||i.call(r),!1===e?(d.isMobile&&c&&(null==l||l.hide()),null==o||o.removeAttribute("aria-autocomplete"),a&&(r.nonEditableClickTargetListener=Mn.on({element:a,click:e=>{const t=a.getRootNode().elementFromPoint(e.clientX,e.clientY);e.originalTarget===a&&t===a&&r.onTriggerClick(e)},thisObj:r}))):(null==l||l.show(),null==o||o.setAttribute("aria-autocomplete","list"),r.globalTapListener=Hi.ion({globaltap:"showKeyboard",thisObj:r}))}get nonEditableClickTarget(){return this.input}get pickerAlignElement(){const{_pickerAlignElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:U.getPath(this,e)}changePicker(e,t){const n=this;return wm.reconfigure(t,e?C.merge({id:n.id+"-picker",owner:n,forElement:n.pickerAlignElement,align:{matchSize:null==e.width,anchor:n.overlayAnchor,target:n.pickerAlignElement}},e):null,n)}updatePicker(e){const t=this;t.detachListeners("pickerField.picker"),e&&(e.ion({name:"pickerField.picker",thisObj:t,show:"onPickerShow",hide:"onPickerHide"}),ki.setAttributes(t.ariaElement,{role:t.role,"aria-haspopup":e.ownersRole,"aria-controls":e.id,"aria-expanded":e.isVisible}))}updateRole(e){this.isConfiguring&&"textbox"!==e||this.ariaElement.setAttribute("role",e)}get childItems(){const e=super.childItems;return this._picker&&e.push(this.picker),e}onEditComplete(){super.onEditComplete(),this.hidePicker()}onElementResize(e){const t=this;t.pickerVisible&&t.picker.requestAnimationFrame(t.picker.realign,null,t.picker),super.onElementResize(e)}internalOnKeyEvent(e){const t=this;let n=!0;var i;if("keydown"===e.type&&!t.disabled&&!e.shiftKey&&!e.ctrlKey)if(t.pickerVisible){const{picker:i}=t;"Escape"===e.key?(e.preventDefault(),e.stopImmediatePropagation(),t.hidePicker(),n=!1):i.onInternalKeyDown?i.onInternalKeyDown(e):"ArrowDown"===e.key&&i.focusable&&i.focus()}else"ArrowDown"!==e.key||!t.picker||null!==(i=t.triggers)&&void 0!==i&&null!==(i=i.expand)&&void 0!==i&&i.keyMap||t.onTriggerKeyDown(e);n&&super.internalOnKeyEvent(e)}onFocusIn(e){var t;const n=this,i=null===(t=Hi.currentPointerDown)||void 0===t?void 0:t.target;super.onFocusIn(e),!n.autoExpand||null!=i&&i.matches(".b-fieldtrigger")||(n.minChars=0,n.onTriggerClick(e))}onTriggerClick(e){this.disabled||this.togglePicker("key"in e)}onTriggerKeyDown(e){!1!==this.trigger("triggerKey",{event:e})&&(e.stopImmediatePropagation(),e.preventDefault(),this.onTriggerClick(e))}showKeyboard({event:e}){const t=this.input;ki.isTouchEvent&&ki.getActiveElement(t)===t&&e.target===t&&(Hi.suspendFocusEvents(),t.blur(),t.focus(),Hi.resumeFocusEvents())}togglePicker(e){this.pickerVisible?this.hidePicker():this.showPicker(e)}showPicker(e){const t=this,{picker:n}=t;var i;n&&(n.show(),null===(i=t.ariaElement)||void 0===i||i.setAttribute("aria-expanded",!0),n.isVisible&&e&&t.focusPicker())}onPickerShow(){const e=this;e.pickerActiveDescendant&&e.ariaElement.setAttribute("aria-activedescendant",e.pickerActiveDescendant),e.pickerVisible=!0,e.element.classList.add("b-open"),e.trigger("togglePicker",{show:!0}),e.pickerTapOutRemover=Hi.ion({globaltap:"onPickerTapOut",thisObj:e}),e.pickerKeyDownRemover=Mn.on({element:e.picker.element,keydown:"onPickerKeyDown",thisObj:e})}onPickerHide(){var e,t;const n=this,{ariaElement:i}=n;n.pickerActiveDescendant=null==i?void 0:i.getAttribute("aria-activedescendant"),null==i||i.removeAttribute("aria-activedescendant"),null==i||i.setAttribute("aria-expanded",!1),n.pickerVisible=!1,n.element.classList.remove("b-open"),n.trigger("togglePicker",{show:!1}),null===(e=n.pickerTapOutRemover)||void 0===e||e.call(n),null===(t=n.pickerKeyDownRemover)||void 0===t||t.call(n)}onPickerTapOut({event:e}){this.containsFocus||this.owns(e.target)||this.hidePicker()}onPickerKeyDown(e){if("Tab"===e.key&&!this.picker.trapFocus){const t=ki.getActiveElement(this.input),n=new KeyboardEvent("keydown",e);this.input.dispatchEvent(n),n.defaultPrevented&&e.preventDefault(),ki.getActiveElement(this.input)===t?this.input.focus():e.preventDefault(),this.isDestroyed||this.hidePicker()}}hidePicker(){this.pickerVisible&&this.picker.hide()}focusPicker(){}focus(){const e=this.input;ki.isTouchEvent&&this.editable&&(e.readOnly=!0,this.setTimeout((()=>e.readOnly=!1),500)),super.focus()}}wm._$name="PickerField";class Dm extends vm{static $name="ChipView";static type="chipview";static configurable={itemCls:"b-chip",multiSelect:!1,closable:!0,iconTpl:null,closeHandler:null};itemContentTpl(e,t){const n=this;return yh.tpl`${n.iconTpl?this.iconTpl(e):""}
            ${n.itemTpl(e,t)}
            ${n.closable?'<div class="b-icon b-close-icon b-icon-clear" data-noselect></div>':""}`}onInternalKeyDown(e){const t=this,{selected:n}=t,{generation:i}=n;t.closable&&n.count&&("Delete"===e.key||"Backspace"===e.key)?(t.closeHandler?t.callback(t.closeHandler,t.owner,[n.values,{isKeyEvent:!0}]):t.store.remove(n.values),n.generation!==i&&e.stopImmediatePropagation()):super.onInternalKeyDown(e)}updateClosable(e){this.element.classList[e?"add":"remove"]("b-chips-closable"),this.isConfiguring||this.refresh()}onClick(e){const t=this,n=e.target.closest(`.${t.itemCls}`);if(t.closable&&e.target.classList.contains("b-close-icon")){const e=t.store.getAt(parseInt(n.dataset.index));t.closeHandler?t.callback(t.closeHandler,t.owner,[[e]]):t.store.remove(e)}else super.onClick(e)}}Dm.initClass(),Dm._$name="ChipView";const Em="L{fieldRequired}",xm="L{validateFilter}",Rm=/[\w\s]/;class Tm extends wm{static $name="Combo";static type="combo";static alias="combobox,dropdown";static delayable={filterOnInput:0};static get configurable(){return{primaryFilter:{},picker:{type:"list",floating:!0,scrollAction:"realign",itemsFocusable:!1,align:{align:"t0-b0",axisLock:!0},maxHeight:324,scrollable:{overflowY:!0},autoShow:!1,focusOnHover:!1},multiSelect:null,items:null,store:null,valueField:void 0,displayField:"text",clearWhenInputEmpty:null,pickerWidth:null,minChars:null,selected:null,listItemTpl:null,displayValueRenderer:null,listCls:null,triggers:{expand:{cls:"b-icon-picker",handler:"onTriggerClick"}},filterParamName:null,encodeFilterParams:e=>e.map((e=>e.value)),filterOnEnter:!1,hideTrigger:null,overlayAnchor:null,keyStrokeFilterDelay:null,defaultAction:"select",triggerAction:"all",filterOperator:"startsWith",caseSensitive:!1,hidePickerOnSelect:null,chipView:{$config:["lazy","nullify"],value:{type:"combochipview"}},chipStore:{$config:["lazy","nullify"],value:{}},filterSelected:null,emptyText:"L{Combo.noResults}",value:null,valueCollection:{$config:["nullify","lazy"],value:{}},validateFilter:!0,clearTextOnPickerHide:!0,clearTextOnSelection:!0,destroyStore:!1,multiValueSeparator:",",createOnUnmatched:null,role:"combobox",inlinePicker:null,testConfig:{keyStrokeFilterDelay:0,nonEditableFilterTimeout:200},localizeDisplayFields:!1,buildItems:null,sortItemsOnLocaleChange:!1,nonEditableFilterTimeout:2e3}}static get queryLast(){return"last"}construct(e){super.construct(...arguments),this.store||(this.items=[]),this.filterOnEnter&&(this.hideTrigger=!0)}startConfigure(e){this.usingRecordAsValue=null===e.valueField,super.startConfigure(...arguments)}afterConfigure(){super.afterConfigure();const e=this;U.hasOwn(e,"_value")||(e._value=e.nullValue,e._lastValue=e._lastValue||e._value)}get childItems(){const{_chipView:e}=this,t=super.childItems;return e&&t.push(e),t}get innerElements(){var e;const t=null===(e=this._chipView)||void 0===e?void 0:e.element,{input:n,inputElement:i}=this;return t&&yc.sync({targetElement:n,domConfig:i}),[t||i]}updateInlinePicker(e){e&&(this.element.classList.add("b-inline-picker"),this.getConfig("picker"),this.triggers.expand=null,this.pickerVisible=!0)}hidePicker(...e){if(!this.inlinePicker)return super.hidePicker(...e)}changeChipStore(e){return!e||e instanceof Ol||(e=new Ol(Ol.mergeConfigs({storage:this.valueCollection},e))),e}updateChipStore(e,t){null==t||t.destroy()}changeChipView(e,t){const n=this;if(n.element.classList[e?"add":"remove"]("b-uses-chipview"),e){const{input:i}=n;return n.chipStore||(n.chipStore={}),Mm.reconfigure(t,e,{defaults:{parent:n,insertBefore:i,store:n.chipStore,closable:!n.readOnly,label:n.label,ariaLabel:n.ariaLabel,navigator:{type:"combochipnavigator",disabled:n.readOnly,keyEventTarget:i}}})}null==t||t.destroy()}updateChipView(e){var t;const n=this;n._chipViewEventDetacher=null===(t=n._chipViewEventDetacher)||void 0===t?void 0:t.call(n),n.chipStore=null==e?void 0:e.store,e&&(e.element.appendChild(n.input),n._chipViewEventDetacher=Mn.on({element:e.element,mousedown:"onChipViewMousedown",thisObj:n}))}updateMultiSelect(e,t){const n=this,{input:i,element:r}=n,s=!n.isConfiguring;let{value:o}=n;if(r.classList[e?"add":"remove"]("b-multiselect"),e){const{chipView:e}=n,{parentNode:t}=i,a=null==e?void 0:e.element;a&&a!==t&&(t.insertBefore(a,i),a.appendChild(i),n.chipView.refresh(),r.classList.add("b-uses-chipview")),i.value="",s&&(o=rt.asArray(o))}else{const e=n._chipView,{parentNode:t}=i,l=null==e?void 0:e.element;var a;if(l===t&&(l.parentNode.insertBefore(i,l),l.remove(),r.classList.remove("b-uses-chipview")),s&&"string"!=typeof o)o=null!==(a=o)&&void 0!==a&&a.length?o[0]:null}s&&(n.value=o),n.isConfiguring||n.updateEditable(n.editable,null)}onChipViewMousedown(e){e.preventDefault(),this.containsFocus||this.focus()}onChipClose(e,t={}){(t.isKeyEvent&&""===this.input.value||!t.isKeyEvent)&&(this._isUserAction=!0,this.valueCollection.remove(e),this._isUserAction=!1)}updateFilterParamName(e){!1!==this.hideTrigger&&(this.hideTrigger=Boolean(e))}updateHideTrigger(e){this.element.classList[e?"add":"remove"]("b-hide-trigger")}updateKeyStrokeFilterDelay(e){this.filterOnInput.delay=e}updateReadOnly(e){super.updateReadOnly(...arguments),this._chipView&&(this._chipView.closable=!e)}updateDisabled(e,t){super.updateDisabled(e,t),this._chipView&&(this._chipView.closable=!e)}updateFilterOperator(e){this.primaryFilter&&(this.primaryFilter.operator=e)}get minChars(){return this._minChars??(this.remoteFilter?4:1)}get validateFilter(){return this._validateFilter&&!this.createOnUnmatched}get items(){return this.store.allRecords}updateBuildItems(e){e&&(this.items=e.call(this))}changeItems(e){var t;const n=this;if(null==e){if(n.store&&!n.store.isItemStore)return;e=[]}if(!n.buildItems||null!==(t=e)&&void 0!==t&&t.length||(e=n.buildItems()),e instanceof Ol)return void(n.store=e);const i=!("valueField"in n.initialConfig),r=n.displayField;let s,o,a=n.valueField;Array.isArray(e)?o=e.map((e=>{let t=e;return e instanceof lo?(s=e.constructor,i&&!a&&(n.valueField=a=s.idField)):"string"==typeof e||"number"==typeof e?(i&&!a&&(n.valueField=a=n.displayField),t={[a]:e,[r]:e}):(i&&!a&&(n.valueField=a="value"),Array.isArray(e)&&(t={[a]:e[0],[r]:e[1]})),e.selected&&(n.value=t),t})):(i&&!a&&(n.valueField=a="value"),o=[],Object.entries(e).forEach((([e,t])=>{o.push({[a]:e,[r]:t})})));const l=a===r?{name:"value",dataSource:r}:a;if(!s){class e extends lo{static get idField(){return n.valueField}static set idField(e){super.idField=e}static get fields(){const e=[l,r];return n.localizeDisplayFields&&e.push("localeClass"),e}}s=e}n.store?n.store.setConfig({modelClass:s,data:o}):n.store=new Ol({isItemStore:!0,data:o,idField:a,verifyNoGeneratedIds:!1,modelClass:s,useRawData:!1})}get value(){const e=this,{valueCollection:t,valueField:n}=e;if(null==n)return e.multiSelect?t.values.slice():t.first;let i;return i=e.multiSelect?t.count?t.map((e=>e[n])):e._unmatchedValue||[]:t.count?t.first[n]:e._unmatchedValue||e.nullValue,i}set value(e){super.value=e}get needsInputSync(){return!this.usesChipView&&!this.editable}changeValue(e,t){const n=this,{multiSelect:i}=n;if(n._unmatchedValue=null,e===t)return void n.syncInputFieldValue(!0);if(!i&&Array.isArray(e)&&e.length>1)throw new Error("Multiple values cannot be set to a non-multiSelect Combo");var r;(n.triggerConfig("items"),n.inputting)||(null===(r=n._chipView)||void 0===r||r.selected.clear());n.store||(n.items=[]);const{valueField:s,displayField:o,nullValue:a,store:l,valueCollection:c,_picker:d}=n,{storage:u}=l,h=n.hidePickerOnSelect??!i,g=n._isUserAction||(null==d?void 0:d._isUserAction)||h&&n.pickerVisible||!1;if(e!=a&&null!=e){let i;if(!n.remoteFilter&&l.isAjaxStore&&!l.count)return l.ion({load:()=>n.value=e,once:!0,thisObj:n}),void(n._unmatchedValue=e);const r=Array.isArray(e),a=r?e.slice():[e];if(n.remoteFilter){if(U.isObject(e)||e.isModel)l.getById(e.id)?n.valueCollection.splice(0,n.valueCollection.count,l.getById(e.id)):(l.data=[e],n.valueCollection.splice(0,n.valueCollection.count,l.first));else{const t=n.isConfiguring;n.primaryFilter.setConfig({value:e,disabled:!1}),l.performRemoteFilter(!0).then((()=>{if(n.isDestroyed)return;const{isConfiguring:e}=n;n.isConfiguring=t,c.splice(0,c.count,l.allRecords),n.isConfiguring=e}))}return}l.isFiltered?(l.isChained&&l.fillFromMaster(),n.primaryFilter.disabled=!0,l.filter()):l.isChained&&l.fillFromMaster();for(let e=0,t=a.length;e<t;e++){let n=a[e];if(n instanceof lo)u.includes(n,!0)||l.add(n);else{const r=U.isObject(n);r&&s&&(n=n[l.modelClass.fieldMap[s].dataSource]),i=u.getBy(o,n)||u.getBy(s,n)||c.getBy(o,n)||c.getBy(s,n),i instanceof Set&&(i=[...i][0]),i?(r&&i.set(a[e]),a[e]=i):(a.splice(e,1),t--,e--)}}const d=!a.length,h=c.generation;c.splice(0,c.count,a),d&&(n._value=r&&0===e.length?null:e,n._unmatchedValue=n._value),(d||c.generation===h)&&n.syncInputFieldValue(),n.syncEmpty(),d&&!n.isConfiguring&&n.triggerFieldChange({value:e,oldValue:t,userAction:g,valid:n.isValid})}else if(c.count)c.clear();else{const t=n._value;n._value=null,n.syncInputFieldValue(),n.syncEmpty(),n.isConfiguring||n.triggerFieldChange({value:e,oldValue:t,userAction:g,valid:n.isValid})}n.remoteFilter||(n._lastValue=n._value)}hasChanged(e,t){return this.multiSelect?!U.isEqual(e,t):super.hasChanged(...arguments)}onComboStoreChange({action:e}){"filter"!==e&&this.syncInputFieldValue(!0)}syncInputFieldValue(e){var t;this.usesChipView?null===(t=this.chipView)||void 0===t||t.refresh():super.syncInputFieldValue(e)}get usesChipView(){return Boolean(this.multiSelect&&this._chipView)}get isEmpty(){return 0===this.valueCollection.count&&!this._unmatchedValue}get inputValue(){const e=this;let t=e.selected?e.selected[e.displayField]:e.value;return e.displayValueRenderer&&(t=e.callback(e.displayValueRenderer,e,[e.selected,e])),null==t?"":t}get nonEditableClickTarget(){var e;return this.multiSelect&&(null===(e=this.chipView)||void 0===e?void 0:e.element)||super.nonEditableClickTarget}changeValueCollection(e,t){if(null==t||t.destroy(),e)return e.isCollection||(e=new _o({internalListeners:{noChange:"onValueCollectionNoChange",change:"onValueCollectionChange",prio:-1e3,thisObj:this}})),e}changePrimaryFilter(e){return e.isCollectionFilter?e.setConfig({disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive}):("function"==typeof e&&(e={filterBy:e}),e=new Eo({id:"primary",disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive,...e})),e}changeStore(e){const t=this,n=[],{valueCollection:i,keyStrokeFilterDelay:r,filterParamName:s}=t;if(Array.isArray(e))return void(t.items=e);let o;if(e){if(e.isStore){const i=e.filters.get("primary");t.remoteFilter&&(e.filterParamName=s),o=e.remoteFilter,i?t.primaryFilter=i:n.push(t.primaryFilter)}else"string"==typeof e?e=Ol.getStore(e):(e=new(e.readUrl?zl:Ol)(e),t.destroyStore=!0),o=t.remoteFilter||e.restfulFilter,o&&s&&(e.filterParamName=s,t.encodeFilterParams&&(e.encodeFilterParams=t.encodeFilterParams)),n.push(t.primaryFilter);if(t.valueField||t.usingRecordAsValue||(t.valueField=e.modelClass.idField),t.filterSelected){const r=e=>!t.containsFocus||!i.includes(e);o?(e.storage.autoFilter=!0,e.storage.addFilter({id:`${t.id}-selected-filter`,filterBy:r})):(n.push(r),e.reapplyFilterOnAdd=!0)}i.addIndex({property:t.displayField,unique:!1}),i.addIndex({property:t.valueField,unique:!0}),n.forEach((t=>e.addFilter(t,!0))),t.keyStrokeFilterDelay=o?Math.max(300,r||0):r??10}return t.valueField!==t.displayField||t.peekConfig("multiSelect")||(t.nullValue=""),e}updateStore(e,t){const n=this,{_picker:i}=n;let r;n.destroyStore&&t&&t.destroy(),i&&(i.store=e),e.storage.addIndex({property:n.displayField,unique:!1}),e.storage.addIndex({property:n.valueField,unique:!0}),r={filter:"onStoreFilter"},n.displayValueRenderer&&((r||(r={})).change="onComboStoreChange"),n.detachListeners("store"),(null==e?void 0:e.storage)&&n.valueCollection.match(e.storage),n.syncInputFieldValue(),r&&(r.name="store",r.thisObj=n,e.ion(r))}get remoteFilter(){var e;return Boolean(this.filterParamName||(null===(e=this._store)||void 0===e?void 0:e.restfulFilter))}get record(){return this.selected}get records(){return this.valueCollection.values.slice()}get selected(){const{store:e}=this;return this.multiSelect?this.valueCollection.values.slice().sort(((t,n)=>e.indexOf(t)-e.indexOf(n)))[0]:this.valueCollection.first}onEditComplete(){const e=this,t=e.valueCollection.count;super.onEditComplete(),t&&(e.clearError(xm),e.syncInputFieldValue()),e.required&&!t&&e.setError(Em)}onTriggerClick(e){const t=this,n="key"in e;if(!t.remoteFilter||!t.filterOnEnter)if(t.pickerVisible)t.hidePicker();else if(!t.readOnly&&!t.disabled){var i;switch(null===(i=t.triggerAction)||void 0===i?void 0:i.toLowerCase()){case"all":t.doFilter(null,n);break;case"last":t.doFilter(t.lastQuery,n);break;default:t.doFilter(t.input.value,n)}}}internalOnInput(e){const t=this;t.clearWhenInputEmpty&&""===t.input.value&&(t._isUserAction=!0,t.clear(),t._isUserAction=!1),t.syncEmpty(),t.syncInputWidth(),t.filterOnInput(e),t.trigger("input",{value:t.input.value,event:e})}filterOnInput(e){const t=this,{value:n}="input"===e.type?e.target:t.input,i=n.length;t.inputting=!0,t.inlinePicker||i>=t.minChars&&(!t.filterOnEnter||"Enter"===e.key)?t.doFilter(n):(t.validateFilter&&!t.remoteFilter&&t[i?"setError":"clearError"](xm),t.hidePicker()),t.inputting=!1}syncInputWidth(){const e=this;if(e.usesChipView){const t=e.input,n=e._inputPadding||(e._inputPadding=ki.getEdgeSize(t,"padding","lr")),i=t.value||"",r=ki.measureText(i+"W",t,!1,e.element)+n.width;t.style.flex=`1 1 ${Math.ceil(r)}px`}}doFilter(e,t){var n;const i=this,{store:r,picker:s}=i,o=null==e||""===e;i.lastQuery=e,i.primaryFilter.setConfig({value:e,disabled:o}),i.remoteFilter&&r.clear(!0);const a=()=>{const{navigator:e,isVisible:t}=s;r.count?!o&&e&&(e.activeItem=0):i.remoteFilter||o||(e&&(e.activeItem=null),i.editable&&i.validateFilter&&i.setError(xm)),t&&s.realign()};null===(n=i.filterPromise=r.filter())||void 0===n||n.then((()=>{i.filterPromise=null,a()})),i.inlinePicker||(null!=s&&s.isVisible?0===s.lastAlignSpec.zone&&s.realign():i.showPicker(t)),i.filterPromise||a()}onStoreFilter({source:e}){const t=this,n=t._picker,i=null==n?void 0:n.element.dataset,{count:r}=e;t.remoteFilter&&(r?n&&(n.navigator.activeItem=0):t.validateFilter&&t.setError(xm),t.filterSelected&&t.valueCollection.count&&(e.storage.onFiltersChanged({action:"splice",oldCount:1}),n&&n.refresh())),i&&(t.createOnUnmatched&&!r&&null!=t.primaryFilter.value?i.addNewValue=t.L("L{addNewValue}")(t.primaryFilter.value):null==i||delete i.addNewValue)}onValueCollectionChange({source:e}){const t=this,{multiSelect:n,_picker:i,nullValue:r}=t,s=t.hidePickerOnSelect??!n,o=n?e.values.slice():e.first,a=e.values.slice(),l=t._isUserAction||(null==i?void 0:i._isUserAction)||s&&t.pickerVisible||!1,c=t._value;if(s&&t.hidePicker(),n&&t.clearTextOnSelection&&(t.input.value=""),!e.count&&t.required?t.setError(Em):(t.clearError(Em),t.clearError(xm)),t.validateFilter&&o&&t.clearError(xm),t.filterSelected){var d;const e=null==i?void 0:i.navigator,n=Number(null==e||null===(d=e.activeItem)||void 0===d||null===(d=d.dataset)||void 0===d?void 0:d.index);t.remoteFilter?(t.store.storage.onFiltersChanged({action:"splice",oldCount:1}),t._picker&&t._picker.refresh()):t.store.filter(),isNaN(n)||(e.activeItem=Math.min(i.store.count,n))}t._value=r;const u=t._lastValue=t.cacheCurrentValue(t.value);var h;(t.syncInputFieldValue(),t.syncEmpty(),t.isConfiguring)||(u===c||t.onConfigChange.$nullFn||t.onConfigChange({name:"value",value:u,was:c,config:t.$meta.configs.value}),t.triggerFieldChange({value:u,oldValue:c,userAction:l,valid:t.isValid}),null===(h=t.trigger)||void 0===h||h.call(t,"select",{record:o,records:a,userAction:l}),"select"===t.defaultAction&&t.trigger("action",{value:u,record:o,records:a,userAction:l}))}cacheCurrentValue(e){return this._value=e}onValueCollectionNoChange({toAdd:e}){!this.inlinePicker&&!this.multiSelect&&e.length&&this.pickerVisible&&(this.picker.hide(),this.syncInputFieldValue())}showPicker(...e){const t=this,{picker:n}=t;if(!t.readOnly&&!t.inlinePicker){var i;if(n.multiSelect=t.multiSelect,super.showPicker(...e),t.overlayAnchor&&!n.align.offset&&(n.align.offset=-n.anchorSize[1],n.realign()),n.restoreActiveItem)if(t.multiSelect)n.restoreActiveItem((null===(i=n.navigator)||void 0===i?void 0:i.previousActiveItem)||t.selected||0,!0);else n.restoreActiveItem(t.selected||0,!0);t.input.focus()}}changePicker(e,t){if(e){var n;const i=this,r=i.pickerWidth||(null===(n=e)||void 0===n?void 0:n.width),s=vm.mergeConfigs({owner:i,store:i.store,selected:i.valueCollection,multiSelect:i.multiSelect,cls:i.listCls,displayField:i.displayField,forElement:i.pickerAlignElement,emptyText:i.emptyText,align:{matchSize:null==r&&"min",anchor:i.overlayAnchor,target:i.pickerAlignElement,minHeight:i.inlinePicker?null:40*Math.min(3,i.store.count)},[i.listItemTpl?"itemTpl":void 0]:i.listItemTpl,width:r,navigator:{keyEventTarget:i.input,activateOnMouseover:!i.inlinePicker}},e);i.inlinePicker&&Object.assign(s,{floating:!1,align:null,maxHeight:null,appendTo:i.element}),(e=vm.reconfigure(t,e?s:null,i)).element.classList.add("b-combo-picker"),e.ion({navigate:"onPickerNavigate",thisObj:i}),Mn.on({element:e.element,pointerdown:e=>i.onPickerNavigate({event:e}),thisObj:i})}else null==t||t.destroy();return e}onPickerNavigate({event:e}){e.target.matches("[data-add-new-value]")&&this.addNewRecord(this.primaryFilter.value)}onPickerHide(){const e=this;super.onPickerHide(),e.multiSelect&&e.clearTextOnPickerHide&&!e.errors&&(e.input.value="")}async internalOnKeyEvent(e){const t=this,n=t.input[t.inputValueAttr],i=n.length,{key:r,type:s}=e,{primaryFilter:o,store:a,multiSelect:l,minChars:c,_picker:d,_chipView:u}=t;let h;if("keydown"===s&&null!=d&&d.isVisible&&d.navigator){const{activeItem:i}=d.navigator;if(i&&l&&r===t.multiValueSeparator)return t.input.value="",d.onItemClick(i,e),o.setConfig({value:"",disabled:!0}),a.filter(),d.hide(),void e.preventDefault();if(!i&&t.createOnUnmatched&&(l&&r===t.multiValueSeparator||"Enter"===r))return e.preventDefault(),void await t.addNewRecord(n)}var g;t.editable?!u||u.selected.count||"keydown"!==s||"Backspace"!==r||i||(u.navigator.activeItem=t.valueCollection.count-1,e.stopImmediatePropagation()):"keydown"===s&&"Backspace"===r&&null!==(g=t.nonEditableFilterValue)&&void 0!==g&&g.length?(t.nonEditableFilterValue=t.nonEditableFilterValue.substring(0,t.nonEditableFilterValue.length-1),t.doFilter(t.nonEditableFilterValue),t.lastFilterKeypressTime=e.timeStamp):"keypress"===s&&1===r.length&&r.match(Rm)&&((!t.lastFilterKeypressTime||e.timeStamp-t.lastFilterKeypressTime>t.nonEditableFilterTimeout)&&(t.nonEditableFilterValue=""),t.nonEditableFilterValue=(t.nonEditableFilterValue||"")+r,t.doFilter(t.nonEditableFilterValue),t.lastFilterKeypressTime=e.timeStamp);t.pickerVisible&&"Enter"===r&&t.primaryFilter.value===t.input.value&&(h=!0),super.internalOnKeyEvent(...arguments),"keydown"===e.type&&"Enter"===r&&!h&&t.remoteFilter&&(i>=c?(e.stopPropagation(),t.filterOnInput.now(e)):i>0&&(e.stopPropagation(),t.setError(`L{Field.tooShort} (${c})`,!1,!0)))}async addNewRecord(e){const t=this,{store:n,_picker:i,valueCollection:r,multiSelect:s,primaryFilter:o}=t,a=n.remoteFilter&&n.autoCommit;t.filterPromise&&await t.filterPromise,a||(o.setConfig({value:"",disabled:!0}),n.filter()),t._isUserAction=!0;const[l]=n.add(t.callback(t.createOnUnmatched,t,[e,t]));if(n.isCommitting){let e;try{await n.autoCommitTimeoutPromise,await n.commitPromise}catch(t){var c;e=null===(c=t.response)||void 0===c||null===(c=c.parsedJson)||void 0===c?void 0:c.error}l.isPhantom&&(t.clearError(),t.setError(e||"L{recordNotCommitted}",!1,!0),n.remove(l),n.removed.remove(l))}a&&(o.setConfig({value:"",disabled:!0}),n.filter()),t.input.value="",n.includes(l)&&r.splice(s?r.count:0,s?0:r.count,l),null==i||i.hide(),t._isUserAction=!1}changeCreateOnUnmatched(e){return!0===e&&(e=this.defaultRecordCreator),e}defaultRecordCreator(e){return this.store.createRecord({[this.displayField]:e})}updateLocalizeDisplayFields(e){e?this.localizableProperties.push("store"):rt.remove(this.localizableProperties,"store")}localizeProperty(e){return"store"===e?this.localizeStore():super.localizeProperty(e)}localizeStore(){const e=this,{displayField:t}=e;let{localizedDisplayFieldsMap:n}=e;n||(e.localizedDisplayFieldsMap=n=new Map),!e.store&&e.buildItems&&(e.items=e.buildItems());for(const r of e.items)if(r.id){var i;let s=n.get(r.id);!s&&null!==(i=r[t])&&void 0!==i&&i.startsWith("L{")&&(s=r[t],n.set(r.id,s)),s&&(r[t]=(r.localeClass||e).L(s))}e.sortItemsOnLocaleChange&&e.store.sort(),e.syncInputFieldValue()}createOverflowTwin(e){return super.createOverflowTwin({store:this.store,...e})}}class Mm extends Dm{static $name="ComboChipView";static type="combochipview";static configurable={closeHandler:"up.onChipClose",itemsFocusable:!1,multiSelect:!0,itemTpl(e){return V.encodeHtml(e.getValue(this.owner.displayField))},scrollable:{overflowY:"auto"}}}Tm.initClass(),Mm.initClass(),class extends eg{static $name="ComboChipNavigator";static type="combochipnavigator";static get configurable(){return{allowShiftKey:!0}}onTargetClick(e){const t=this,n=e.target.closest(t.itemSelector);n&&!e.target.classList.contains("b-close-icon")&&(e.shiftKey||n.contains(e.target.closest("[data-noselect]"))||t.ownerCmp.selected.clear(),t.inClickHandler=!0,t.activeItem=n,t.inClickHandler=!1)}onKeyDown(e){"Enter"===e.key||e.target.selectionStart||e.target.selectionEnd||super.onKeyDown(e)}updateActiveItem(e,t){const n=this.ownerCmp;super.updateActiveItem(e,t),e&&!this.inClickHandler&&n.selected.add(n.getRecordFromElement(e))}navigatePrevious(e){const t=this.ownerCmp;t.navigator.activeItem&&!e.shiftKey&&t.selected.clear(),this.previous?super.navigatePrevious(e):this.activeItem=null}navigateNext(e){const t=this.ownerCmp;t.navigator.activeItem&&!e.shiftKey&&t.selected.clear(),this.next?super.navigateNext(e):this.activeItem=null}}.initClass(),Tm._$name="Combo";class Im extends Tm{static $name="BooleanCombo";static type="booleancombo";static get configurable(){return{positiveValue:!0,positiveText:null,negativeValue:!1,negativeText:null,store:{value:[],$config:"lazy"},value:!1}}changeStore(e,t){const n=this;return super.changeStore(new Ol({data:[{id:n.positiveValue,text:n.positiveText||n.L("L{Object.Yes}")},{id:n.negativeValue,text:n.negativeText||n.L("L{Object.No}")}]}),t)}}Im.initClass(),Im._$name="BooleanCombo";const km=({$toggleOrder:e},{$toggleOrder:t})=>(t||0)-(e||0),Fm={click:"resetValueCache",beforeToggle:"onItemBeforeToggle",toggle:"onItemToggle"};class Am extends(Id.mixin(Ud,lm)){static $name="ButtonGroup";static type="buttongroup";static configurable={defaultType:"button",cls:null,items:null,color:null,useGap:!1,toggleGroup:null,valueSeparator:",",columns:null,hideWhenEmpty:!0,defaultBindProperty:"value",errorTooltipCachePath:"buttonGroupErrorTooltip",errorTooltipConfig:{forSelector:".b-buttongroup.b-invalid"},overflowable:!0,toggleable:null,value:null};afterConstruct(){super.afterConstruct(),this.ion({change:"internalOnChange"})}get inputWrap(){return this.element}get isValid(){let e=super.isValid;const t=this,{toggleable:n}=t;return t.clearError("L{Field.fieldRequired}",!0),e&&!t.disabled&&(t.required&&!t.value||n&&t.pressed.length<n[0])&&(e=!1,t.setError("L{Field.fieldRequired}",!0)),t.checkValidity&&!1===t.callback(t.checkValidity,t,[t])&&(e=!1),e&&t.errors&&Object.keys(t.errors).length&&(e=!1),e}get pressed(){return this.items.filter((e=>e.pressed)).sort(km)}internalOnChange(){this.syncInvalid()}onChildAdd(e){super.onChildAdd(e),e.ion({thisObj:this,...Fm,prio:1e4})}onChildRemove(e){e.un({thisObj:this,...Fm}),super.onChildRemove(e)}onItemBeforeToggle({pressed:e}){const{toggleable:t}=this;return e||!t||this.pressed.length>t[0]}onItemToggle(e){const t=this,n=(t.toggleCount||0)+1,{toggleable:i}=t;t.resetValueCache(),t.isSettingValue||t.toggleGroup&&!e.pressed||(i&&(e.source.$toggleOrder=n,t.toggleCount=n,t.isSettingValue=!0,t.pressed.slice(i[1]).forEach((e=>e.pressed=!1)),t.isSettingValue=!1),t.triggerFieldChange({value:t.value,userAction:!0,event:e}))}resetValueCache(){this._value=null}createWidget(e){const t=this;return t.constructor.resolveType(e.type||"button").isButton&&(t.color&&!e.color&&(e.color=t.color),!e.toggleGroup&&t.toggleGroup&&(e.toggleGroup=t.toggleGroup),t.toggleable&&(e.toggleable=!0)),t.columns&&(e.width=100/t.columns+"%"),e=super.createWidget(e),t.relayEvents(e,["click","action","toggle"]),e}changeToggleable(e){return!0===e?e=[0,1/0]:"number"==typeof e&&(e=[1,e]),e||null}updateToggleable(e){e&&!this.isConstructing&&this.pressed.slice(e[1]).forEach((e=>e.pressed=!1))}changeToggleGroup(e,t){return!0===e?t||Am.generateId("toggleGroup"):e}updateRotate(e){this.eachWidget((t=>{!1!==t.rotate&&(t.rotate=e)}))}get valueAsArray(){return this.items.flatMap((e=>e.pressed&&void 0!==e.value?e.value:[]))}get value(){const e=this;return e._value||(e._value=e.valueAsArray.join(e.valueSeparator)),e._value}changeValue(e,t){const n=this;return null==e?e=[]:"string"==typeof e?e=e.split(n.valueSeparator):Array.isArray(e)||(e=[e]),n.isSettingValue=!0,n.items.forEach((t=>{void 0!==t.value&&(t.pressed=e.includes(t.value))})),n.isSettingValue=!1,n.valueAsArray.join(n.valueSeparator)}updateValue(e){this.isConfiguring||this.triggerFieldChange({value:e,userAction:Boolean(this._isUserAction)})}get validity(){return{}}onDisabled(e){this.syncInvalid(),this.items.forEach((t=>t.disabled=e||!t.ignoreParentReadOnly&&this.readOnly))}updateReadOnly(e){super.updateReadOnly(e),this.updateDisabled(this.disabled)}addToOverflowMenu(e,t,n){const{toggleable:i,toggleGroup:r}=this;(r||1===(null==i?void 0:i[0])&&1===i[1])&&(t={...t,radio:!0}),this.items.forEach((i=>i.addToOverflowMenu(e,t,n)))}get widgetClassList(){const e=super.widgetClassList;return this.columns&&e.push("b-columned"),e}updateUseGap(e){e||this.element.classList.add("b-no-gap")}}Am.initClass(),Am._$name="ButtonGroup";const Pm={0:1,6:1};class Lm extends nh{static $name="CalendarPanel";static type="calendarpanel";static get configurable(){return{layout:"vbox",textContent:!1,date:{$config:"date"},month:{},year:null,weekStartDay:null,sixWeeks:!0,showWeekColumn:null,disabledDates:null,headerRenderer:null,weekRenderer:null,cellRenderer:null,disableWeekends:null,disableNonWorkingDays:null,hideNonWorkingDays:null,hideNonWorkingDaysCls:"b-hide-nonworking-days",nonWorkingDays:null,tip:null,dayCellCls:"b-calendar-cell",dayHeaderCls:"b-calendar-day-header",disabledCls:"b-disabled-date",otherMonthCls:"b-other-month",weekendCls:"b-weekend",todayCls:"b-today",nonWorkingDayCls:"b-nonworking-day",dayNameFormat:"ddd",minRowHeight:{$config:["lazy"],value:null},minColumnWidth:{$config:["lazy"],value:null},disableOtherMonthCells:null,disableOtherMonthCellsCls:"b-disable-othermonth-cells",hideOtherMonthCells:null,hideOtherMonthCellsCls:"b-hide-othermonth-cells",animateTimeShift:!0}}construct(e){super.construct(e),this.refreshCount||this.refresh()}onInternalPaint({firstPaint:e}){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...arguments),e&&(this.refreshCount||this.refresh(),this.getConfig("minColumnWidth"),this.getConfig("minRowHeight"))}get overflowElement(){return this.weeksElement}doDestroy(){var e;null===(e=this.tip)||void 0===e||e.destroy(),super.doDestroy()}updateMinRowHeight(e){this.element.style.setProperty("--min-row-height",ki.setLength(e)),this.scrollable={overflowY:!!e&&"auto"}}updateMinColumnWidth(e){this.element.style.setProperty("--min-column-width",ki.setLength(e)),this.scrollable={overflowX:!!e&&"auto"},this.overflowElement.classList[e?"add":"remove"]("b-min-columnwidth")}getDateFromDomEvent(e){const t=(e.nodeType===Element.ELEMENT_NODE?e:e.target).closest(`#${this.id} [data-date]`);if(t)return us.parseKey(t.dataset.date)}changeTip(e,t){const n=this;return sm.reconfigure(t,e,{owner:n,defaults:{type:"tooltip",owner:n,id:`${n.id}-cell-tip`,forElement:n.bodyElement,forSelector:`.${n.dayCellCls}`}})}updateTip(e){this.detachListeners("tip"),null==e||e.ion({pointerOver:"onTipOverCell",name:"tip",thisObj:this})}updateElement(e,t){const n=this;super.updateElement(e,t),n.updateHideNonWorkingDays(n.hideNonWorkingDays),n.weekdayCells=Array.from(e.querySelectorAll(".b-calendar-day-header")),n.weekElements=Array.from(e.querySelectorAll(".b-calendar-week")),n.weekDayElements=Array.from(e.querySelectorAll(".b-calendar-days")),n.cellElements=[];for(let e=0,{length:t}=n.weekDayElements;e<t;e++)n.cellElements.push(n.weekDayElements[e].previousSibling,...n.weekDayElements[e].children)}changeDate(e){if(e="string"==typeof e?us.parse(e):new Date(e),isNaN(e))throw new Error("CalendarPanel date ingestion must be passed a Date, or a YYYY-MM-DD date string");return us.clearTime(e)}updateDate(e){this.month.date=e,this.element.dataset.month=us.format(e,"YYYY-MM")}updateDayNameFormat(){const e=new Date("2000-06-04T12:00:00");this.shortDayNames=[];for(let t=4;t<11;t++)e.setDate(t),this.shortDayNames.push(us.format(e,this.dayNameFormat))}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:us.weekStartDay}updateWeekStartDay(e){const t=this;if(t._month){t.month.weekStartDay=e,t.dayNames=[];for(let e=0;e<7;e++)t.dayNames[e]=t.shortDayNames[t.canonicalDayNumbers[e]];t.refreshCount&&t.refresh()}}updateHideNonWorkingDays(e){var t;this.contentElement.classList.toggle(this.hideNonWorkingDaysCls,Boolean(e)),null===(t=this.scrollable)||void 0===t||t.syncOverflowState(),this._month&&(this.month.hideNonWorkingDays=e),this.isConfiguring||this.refresh()}updateHideOtherMonthCells(e){var t;this.element.classList.toggle(this.hideOtherMonthCellsCls,Boolean(e)),null===(t=this.scrollable)||void 0===t||t.syncOverflowState()}updateDisableOtherMonthCells(e){var t;this.element.classList.toggle(this.disableOtherMonthCellsCls,Boolean(e)),null===(t=this.scrollable)||void 0===t||t.syncOverflowState()}get nonWorkingDays(){return this._nonWorkingDays||this._localeNonWorkingDays||(this._localeNonWorkingDays=us.nonWorkingDays)}get weekends(){return this._localeWeekends||(this._localeWeekends=us.weekends)}changeNonWorkingDays(e){return U.assign({},e)}updateNonWorkingDays(e){var t;this._month&&(this.month.nonWorkingDays=e,this.refresh(),null===(t=this.scrollable)||void 0===t||t.syncOverflowState())}get visibleDayColumnIndex(){return this.month.visibleDayColumnIndex}get dayColumnIndex(){return this.month.dayColumnIndex}get canonicalDayNumbers(){return this.month.canonicalDayNumbers}get visibleColumnCount(){return this.month.visibleColumnCount}get weekLength(){return this.month.weekLength}get startDate(){return this.month.startDate}get duration(){return us.diff(this.month.startDate,this.month.endDate,"day")+1}get endDate(){const{endDate:e}=this.month;if(e)return us.add(e,1,"day")}changeMonth(e,t){const n=this;if(!(e instanceof Pg)){if("number"==typeof e){if(t)return void(t.month=e);const i=n.date||us.clearTime(new Date);i.setMonth(e),e={date:i}}e=Pg.new({weekStartDay:n.weekStartDay,nonWorkingDays:n.nonWorkingDays,hideNonWorkingDays:n.hideNonWorkingDays,sixWeeks:n.sixWeeks},e)}return e.ion({dateChange:"onMonthDateChange",thisObj:n}),e}onMonthDateChange({source:e,newDate:t,oldDate:n,changes:i}){const r=this;if(r.year=e.year,!r.isConfiguring){if(!r.getCell(t)||i.m||i.y){const{isVisible:e}=r;r.refresh(),r.animateTimeShift&&e&&ki.slideIn(r.contentElement,t>n?1:-1)}r.trigger("dateChange",{changes:i,value:t,oldValue:n})}}updateYear(e){this.month.year=e}updateShowWeekNumber(e){this.updateShowWeekColumn(e)}updateShowWeekColumn(e){const t=this;t.element.classList[e?"add":"remove"]("b-show-week-column"),t.floating&&(t.isAligning||t.realign())}updateSixWeeks(e){this.month&&(this.month.sixWeeks=e,this.refresh())}refresh(){this.month&&this.element.style.setProperty("--week-length",this.month.weekLength),this.doRefresh()}doRefresh(){var e;this.getConfig("element");const t=this,n=null!=t.timeZone?t.timeZone:null===(e=t.project)||void 0===e?void 0:e.timeZone,i=null!=n?Mh.toTimeZone(new Date,n):new Date,{weekElements:r,weekDayElements:s,date:o,month:a,dayCellCls:l,dayHeaderCls:c,disabledCls:d,otherMonthCls:u,weekendCls:h,todayCls:g,nonWorkingDayCls:m,nonWorkingDays:p,canonicalDayNumbers:f,sixWeeks:v}=t;if(i.setHours(0,0,0,0),!o)return void(t.date=i);t.element.style.setProperty("--visible-week-count",a.weekCount),t.trigger("beforeRefresh"),t.getConfig("dayNameFormat");for(let e=0;e<7;e++){const n=t.weekdayCells[e],i=t.canonicalDayNumbers[e],r={[c]:1,[h]:Pm[i],[m]:p[i]};if(t.headerRenderer){n.innerHTML="";const r=t.callback(t.headerRenderer,t,[n,e,i]);r&&("string"==typeof r?ki.setInnerText(n,r):ki.createElement({...r,parent:n}))}else ki.setInnerText(n,t.shortDayNames[i]);ki.syncClassList(n,r),n.dataset.columnIndex=e,n.dataset.cellDay=i}let y=0,b=0,C=6;for(let e=6;e>=0;e--)if(!p[f[e]]){C=e;break}r[4].classList.toggle("b-hide-display",a.weekCount<5&&!v),r[5].classList.toggle("b-hide-display",a.weekCount<6&&!v),a.eachWeek(((e,n)=>{const i=s[y],o=[i.previousSibling,...i.children],c=o[0],{firstChild:f}=c;if(r[y].dataset.week=`${e[0]},${e[1]}`,r[y].setAttribute("aria-label",`${t.L("L{Week}")} ${e[1]}, ${e[0]}`),""===c.innerHTML?c.innerText=e[1]:f.nodeType===Node.TEXT_NODE&&(f.nodeValue=e[1]),t.weekRenderer){const n=t.callback(t.weekRenderer,t,[c,e]);n&&("string"==typeof n?ki.setInnerText(c,n):(c.innerHTML="",ki.createElement({...n,parent:c})))}for(let i=0;i<7;i++){const s=n[i],c=s.getDay(),f=us.makeKey(s),v=p[c],S=o[i+1],w=us.isToday(s,t.timeZone),D={[l]:1,[d]:t.isDisabledDate(s),[u]:s.getMonth()!==a.month,[h]:Pm[c],[g]:w,[m]:v,"b-last-working-day":i===C,"b-first-visible-cell":!(s-(t.firstVisibleDate||-1)),"b-last-visible-cell":!(s-(t.lastVisibleDate||-1)),[`b-day-of-week-${c}`]:1};if(ki.syncClassList(S,D),S.role="gridcell",S.dataset.date=f,S.dataset.cellIndex=b,S.dataset.columnIndex=i,S.lastDomConfig&&(delete S.lastDomConfig.class,delete S.lastDomConfig.className),t.cellRenderer){if(t.callback(t.cellRenderer,t,[{cell:S,date:s,day:c,rowIndex:y,cellIndex:b,columnIndex:i,key:f,week:e,row:r[y],source:t,visibleColumnIndex:t.visibleDayColumnIndex[c]}]),w){const e=S.getAttribute("aria-label"),n=t.L("L{Object.today}, ");e&&!e.startsWith(n)&&S.setAttribute("aria-label",`${n}${e}`)}}else S.innerHTML=s.getDate();b++}y++})),t.visibleWeekCount=y,t.floating&&(t.isAligning||t.realign()),t.refreshCount=(t.refreshCount||0)+1,t.trigger("refresh")}isDisabledDate(e){const t=this,n=e.getDay(),{disabledDates:i}=t;return!(!t.disableWeekends||!Pm[n])||(!(!t.disableNonWorkingDays||!t.nonWorkingDays[n])||(i?Array.isArray(i)?(e=us.clearTime(e,!0),i.some((t=>(t="string"==typeof t?us.parse(t):t,!(us.clearTime(t,!0)-e))))):t.callback(i,t,[e]):void 0))}get bodyConfig(){const e=super.bodyConfig,t=[];e.children=[{tag:"div",className:"b-calendar-row b-calendar-weekdays","aria-hidden":!0,reference:"weekdaysHeader",children:[{class:"b-week-number-cell"},...rt.fill(7,{class:this.dayHeaderCls}),ki.scrollBarPadElement]},{className:"b-weeks-container notranslate",reference:"weeksElement",children:t,role:"grid"}];for(let e=0;e<6;e++){const n={role:"row",className:"b-calendar-row b-calendar-week",dataset:{rowIndex:e},children:[{className:"b-week-number-cell",role:"rowheader"},{className:"b-calendar-days",children:[{},{},{},{},{},{},{}],syncOptions:{ignoreRefs:!0,strict:!1}}]};t.push(n)}return e}get firstVisibleDate(){if(this.hideOtherMonthCells){const{year:e,month:t}=this.month;return new Date(e,t,1)}for(const e=this,t=e.month.startDate;;t.setDate(t.getDate()+1))if(!e.hideNonWorkingDays||!e.nonWorkingDays[t.getDay()])return t}get lastVisibleDate(){const e=us.add(this.endDate,-1,"d");if(this.hideOtherMonthCells)return e;for(const t=this,n=e;;n.setDate(n.getDate()-1))if(!t.hideNonWorkingDays||!t.nonWorkingDays[n.getDay()])return n}getCell(e,t){"string"!=typeof e&&(e=us.makeKey(e));const n=this.weeksElement.querySelector(`[data-date="${e}"]`);if(n&&(!t||!n.classList.contains(this.otherMonthCls)))return n}onTipOverCell({source:e,target:t}){e.date=us.parseKey(t.dataset.date)}updateLocalization(){this._localeNonWorkingDays=this._localeWeekends=null,this.updateDayNameFormat(),this.updateWeekStartDay(this.weekStartDay),super.updateLocalization()}}Lm.initClass(),Lm._$name="CalendarPanel";const{abs:Om,ceil:$m,floor:_m,max:jm,min:Bm}=Math,Vm="b-carousel-item",Hm=[0,0],zm=Symbol("carouselIndex"),Nm=Symbol("carouselSyncGen"),Wm="b-carousel-reserve",Um=`${Wm}-before`,Gm=`${Wm}-after`,qm=(e,t)=>e[zm]-t[zm],Ym="b-carousel-visible",Km=["x","y"],Xm=["y","x"],Zm={h:{minSize:"minWidth",offsetPos:"offsetLeft",offsetSize:"offsetWidth",size:"width",vxy:["vx","vy"],xy:Km},v:{minSize:"minHeight",offsetSize:"offsetHeight",size:"height",vxy:["vy","vx"],xy:Xm}};Zm.h.other=Zm.v,Zm.v.other=Zm.h;class Jm extends(nh.mixin(zh,Qh)){static $name="Carousel";static type="carousel";static configurable={atMax:null,atMin:null,configureSlot:(e,t,n)=>({}),disableReserveSlots:null,empty:null,emptyHtml:null,emptyText:"No items to display",firstVisibleSlot:null,lastVisibleSlot:null,range:[null,null],reserveSlots:1,scrollOnTab:null,shrinkWrap:"auto",slots:null,snap:!0,vertical:null};static delayable={triggerSlotVisibility:"raf"};static fenced={resync:!0};compose(){const{carouselClasses:e}=this;return{class:{...e}}}afterFloatReparent(){this.syncSoon()}get allSlots(){return this.ensureItems().values.filter((e=>e.innerItem)).sort(qm)}get bodyConfig(){const{carouselClasses:e,emptyHtml:t,emptyText:n}=this,i=super.bodyConfig;return U.merge(i,{className:{"b-vbox":1,...e},children:{innerCt:{class:{"b-carousel-inner-ct":1,"b-box-center":1}},emptyElement:{class:{"b-carousel-empty-text":1,"b-box-center":1},html:t||V.xss`${n}`}}})}get carouselClasses(){const{empty:e,vertical:t}=this;return{"b-carousel-empty":e,"b-carousel-vertical":t}}get contentElement(){return this.innerCt}get currentIndex(){return this.indexFromPos(this.scrollPos)}set currentIndex(e){this.goto(e)}get focusedSlot(){const{innerCt:e}=this;let t,n,i=null;for(t=ki.getActiveElement();t;t=n)if(n=t.parentElement,n===e){i=hd.fromElement(t);break}return i}get infinityScrollerDefaults(){const e=this,[t,n]=e.vertical?Xm:Km;return U.merge(super.infinityScrollerDefaults,{snap:e.snap&&t,[t]:{overflow:"hidden-scroll",range:e.scrollRange,pos:0},[n]:{overflow:"hidden"}})}get propNames(){return Zm[this.vertical?"v":"h"]}get scrollAxis(){return this.infinityScroller[this.vertical?"y":"x"]}get scrolling(){return this.infinityScroller.scrolling}get scrollPos(){return this.scrollAxis.pos}set scrollPos(e){this.scrollAxis.pos=e}get scrollRange(){const{range:e,slotSize:t}=this;return t?[e[0]*t,e[1]*t]:[0,1/0]}get shrinkWrap(){const e=this._shrinkWrap;return"auto"===e?"absolute"===ki.getStyleValue(this.element,"position"):e}get lastVisibleIndex(){var e;return null===(e=this.lastVisibleSlot)||void 0===e?void 0:e[zm]}get visibleSlots(){return this.allSlots.filter((e=>e.element.classList.contains(Ym)))}updateAtMax(e){this.element.classList.toggle("b-carousel-at-max",e)}updateAtMin(e){this.element.classList.toggle("b-carousel-at-min",e)}changeConfigureSlot(e){if("string"==typeof e){const t=`_${e}Fn`;return this[t]||(this[t]=(...t)=>this[e](...t))}return e}triggerSlotVisibility(){const{firstVisibleSlot:e,lastVisibleSlot:t}=this;this.trigger("slotVisibility",{firstVisibleSlot:e,lastVisibleSlot:t})}updateFirstVisibleSlot(e){this.triggerSlotVisibility()}updateLastVisibleSlot(){this.triggerSlotVisibility()}changeRange(e){if((e=e?[e[0]??-1/0,e[1]??1/0]:[0,0])[0]!==e[1]){let t;if(e[1]<e[0]&&(t="denormalized"),t)throw new Error(`Invalid carousel range [${e[0]}, ${e[1]}): ${t}`)}return e}updateRange(e){this.empty=!(e[0]<e[1]),this.syncSoon()}updateShrinkWrap(){this.isPainted&&this.syncSoon()}updateVertical(){this.isPainted&&this.syncSoon()}convertIndexPos(e,t){const n=this,{allSlots:i,propNames:r}=n,[s,o]=n.range,a=Math.floor((s+o)/2),l=i.length,c=i[l-1],d=r.vxy[0],u=s<=0&&0<o;if(!(t||s<=e&&e<o))return null;let h,g,m,p,f,v,y,b,C=n.slotSize||100;if(l){for(b of(C=0,i)){if(m=b[zm],h=b[d],C=C||b.$vxy[r.size],b===i[0]&&(p=m,y=h,e<(t?h:m)))break;if(t){if(e===h)return m;if(e<h)return m-1}else if(e===m)return h;if(b===c){if(g=h+b.$vxy[r.size],t&&e<g)return m;f=m+1,v=g}}C=C||n.slotSize||100}else{if(t&&0<=e&&e<C)return u?0:a;y=0,v=C,p=u?0:a,f=p+1}return t?e<y?jm(p-$m((y-e)/C),s):Bm(f+_m((e-v)/C),o):e<p?y-(p-e)*C:v+(e-f)*C}ensurePlan(e){return e}ensureVisible(e){const t=this;if(null==t.lastScrollPos)t._afterSync=()=>t.ensureVisible({...e,animate:!1});else{if(!t.scrolling||!t.hasPainted){const{index:n,animate:i}=t.ensurePlan(e),{currentIndex:r,lastVisibleIndex:s}=t;let o;return n<r?o=n-r:s<n&&(o=n-s),o&&t.go(o,i)}t._afterScroll=()=>t.ensureVisible(e)}}getSlotIndex(e){return null==e?void 0:e[zm]}indexFromPos(e){return this.convertIndexPos(e,!0)}posFromIndex(e){return this.convertIndexPos(e,!1)}slotFromIndex(e){for(const t of this.allSlots)if(t[zm]===e)return t;return null}backward(e){return this.go(-1,e)}forward(e){return this.go(1,e)}go(e,t){return this.goto(this.currentIndex+e,t)}goto(e,t){const n=this;if(null==n.lastScrollPos)n._afterSync=()=>{const{scrollPos:t}=n;n.goto(e,!1),n.hasPainted||t===n.scrollPos||n.sync()};else{if(!n.scrolling||!n.hasPainted){const{range:i,slots:r}=n,s=i[1]-("number"==typeof r?r-1:0),o=Bm(s-1,jm(i[0],e)),a=Om(n.currentIndex-o),l=n.posFromIndex(o);return a>=n.allSlots.length&&(t=!1),n.scrollTo({animate:t,[n.scrollAxis.name]:l})}n._afterScroll=()=>n.goto(e,t)}}onChildAdd(e){return e.innerItem&&e.element.classList.add(Vm),super.onChildAdd(e)}onChildRemove(e){return e.innerItem&&e.element.classList.remove(Vm),super.onChildRemove(e)}onInfiniteScrollEnd(e){super.onInfiniteScrollEnd(e);const{_afterScroll:t}=this;this._afterScroll=null,null==t||t()}onSlotFocusTrap({source:e,top:t}){const n=this,i=t?-1:1,r=e[zm],s=n.slotFromIndex(r+i);return s.element.classList.contains(Wm)?n.scrollOnTab&&n.go(i).then((e=>{var t;e&&(null===(t=s.element)||void 0===t||t.focus())})):s.element.focus(),!1}resync(){this.sync()}sync(){if(this.syncCount=(this.syncCount||0)+1,!this.empty){var e;const t=this,{allSlots:n,disableReserveSlots:i,innerCt:r,scrollAxis:s,propNames:o,reserveSlots:a,scrolling:l,slots:c}=t,[d,u]=t.range,h=s.pos,g=hd.resolveType((null===(e=t.defaults)||void 0===e?void 0:e.type)||t.defaultType),m=t.indexFromPos(h),p=t.posFromIndex(m),f=h-p,v=[a,a],y=t.syncGen=(t.syncGen||0)+1;l&&h>(t.lastScrollPos||0)&&f&&(--v[0],++v[1]),t.lastScrollPos=h,r.style.setProperty("--carousel-item-offset",`${Math.abs(f)}px`),t.shrinkWrapped||(r.style[o.minSize]="");let b,C,S,w,D=r[o.offsetSize],E=!1,x=!1,R=null,T=null;t.unanimated((()=>{const{_afterSync:e}=t,a=c&&"auto"!==c?t.syncFixed(m,o,n,g,v,c,d,u):t.syncDynamic(m,o,n,g,v,c,D,d,u),p=[],f=n.filter((e=>e[Nm]!==y));for(w of(f.length&&(f.forEach((e=>t.detachListeners(`${e.id}-listeners`))),t.remove(f)),r.style[o.other.minSize]=`${a[o.other.size]}px`,D=r[o.offsetSize],n))if(!f.includes(w)){const e=s.getItemSpan(w),t=h+D,n=e[1]<=h,i=t<=e[0],r=!n&&!i,o=r&&e[0]<=h,a=r&&e[1]>=t;r&&(w[zm]===d&&(x=!0),w[zm]===u-1&&(E=!0)),o&&(R=w),a&&(T=w),p.push([w,w.element.classList,{[Wm]:n||i,[Um]:n,"b-carousel-first":o,[Ym]:r,"b-carousel-last":a,[Gm]:i}])}for([w,b,S]of p)for(C in i&&(w.disabled=!S[Ym]&&i),S)b.toggle(C,S[C]);t.atMax=E,t.atMin=x,t.firstVisibleSlot=R,t.lastVisibleSlot=T,s.other.range=Hm,t.syncDomOrder(f.length?t.allSlots:n),!l&&t.scrollable.fixPositionSync(),s.sync({range:t.scrollRange}),s.pos!==h?t.resync():e&&(t._afterSync=null,e())}))}}syncDomOrder(e){var t;const n=ki.getActiveElement();let i,r,s;for(s=e.length;s-- >1;)r=e[s].element,i||r.classList.add("b-last-visible-child"),i=e[s-1].element,i.classList.remove("b-last-visible-child"),r.classList.remove("b-first-visible-child"),i.nextSibling!==r&&i.parentElement.insertBefore(i,r);null===(t=i)||void 0===t||t.classList.add("b-first-visible-child"),this.element.contains(n)&&n!==ki.getActiveElement()&&n.focus()}syncDynamic(e,t,n,i,r,s,o,a,l){const c=this,{offsetSize:d}=t,u="auto"===s,h=u?"":null;let g,m,p,[f,v]=r,y=1,b=0;for(p=e;a<=p&&p<l;p+=y){if(m=c.syncSlot(n,i,p,h),g=g||m,b<o){if(b+=m.element[d],u)return c.syncFixed(e,t,n,i,r,$m(o/b));if(y>0){if(p+1<l&&(b<o||v))continue;f+=v,v=0}}if(--v<1){if(y<0||!f)break;y=-1,p=e,v=f}}return g}syncFixed(e,t,n,i,r,s,o,a){const l=this,{shrinkWrap:c,shrinkWrapped:d}=l,u=100/s+"%",h=e+s;let g,m,p,f,v,y=e-r[0],b=h+r[1],C=0;for(;b>a;)--y,--b;for(;y<o;)++y,++b;for(v=y;v<b;++v)m=l.syncSlot(n,i,v,c&&!d?"":u),v===e&&(g=m),c?(p||(p=[])).push(m):m[t.size]=u;if(c){for(f=Bm(h,b-r[1]),v=f-s;v<f;++v)C+=p[v-y][t.size];for(m of p)m[t.size]=u;C&&(l.innerCt.style[t.minSize]=`${C}px`,l.shrinkWrapped=!0)}return g}syncSlot(e,t,n,i){const r=this,{propNames:s,syncGen:o}=r,a=null!==i;let l,c,d,u,h,g=null;for(u of e)if(u[Nm]!==o){if(c=u[zm],c===n){d=u,a&&(d[s.size]=i);break}(!g||c>g[zm])&&(g=u)}return d||(l=r.configureSlot(n,r,g),g?(d=g,a&&(d[s.size]=i),delete l.type,d.setConfig(l)):(h=l.type?hd.resolveType(l.type):t,l=h.mergeConfigs(r.defaults,l),a&&(l[s.size]=i),d=r.add(l),e.push(d),d.ion({thisObj:r,name:`${d.id}-listeners`,focusTrap:"onSlotFocusTrap"})),d[zm]=n,r.slotSize||(r.slotSize=d[s.size]),d[s.vxy[0]]=n*r.slotSize),d[Nm]=o,d}}Jm.initClass(),Jm._$name="Carousel";const Qm=e=>!e.value;class ep extends mm{static $name="Checkbox";static type="checkbox";static alias="check";static get configurable(){return{inputType:"checkbox",autoCollapse:null,toggleGroupRootElement:null,containerDefaults:{syncableConfigs:{disabled:e=>e.disabled||!e.value},syncConfigTriggers:{autoCollapse:1,value:1}},text:"",checkedValue:!0,uncheckedValue:!1,color:null,value:!1,toggleGroup:null,localizableProperties:["label","text"],twinSyncConfigs:{value:"checked"}}}construct(e){"checked"in e&&((e=U.assign({},e)).value=e.checked,delete e.checked),super.construct(e),this.syncHasText()}updateClearable(){}updateEditable(){}get textLabelCls(){return"b-checkbox-label"}get innerElements(){return[this.inputElement,{tag:"label",class:this.textLabelCls,for:`${this.id}-input`,reference:"textLabel",html:this.text||"","aria-hidden":!this.text}]}get inputElement(){const e=super.inputElement;return this.toggleGroup&&(e.dataset={group:this.toggleGroup}),e.listeners={click:"internalOnClick",change:"internalOnChange",input:"internalOnInput"},e}get checked(){return this.value}set checked(e){this.value=e}syncHasText(){var e;this.element.classList[this.text?"add":"remove"]("b-text"),null===(e=this.textLabel)||void 0===e||e.setAttribute("aria-hidden",!this.text)}updateText(e){this.textLabel&&(this.syncHasText(),this.textLabel.innerHTML=e)}afterSyncChildConfigs(e){super.afterSyncChildConfigs(e);let{autoCollapse:t}=this;t&&(t=!0===t?Qm:t,e.collapsed=t(this))}assignFieldValue(e,t,n){this.value=n===this.checkedValue||n!==this.uncheckedValue&&null}fetchInputValue(){this.readOnly||(this.value=this.input.checked)}gatherValue(e){var t;const n=this,i=n.value?n.checkedValue:n.uncheckedValue,r=void 0!==i,{valueName:s}=n;r&&(e[s]=i),n.gatherValues(e,r),!0===i&&(null===(t=e[s])||void 0===t?void 0:t.value)===i&&delete e[s].value}changeValue(e){return"false"!==e&&Boolean(e)}updateValue(e){var t;const n=this,i=n.input.checked!==e;n.input.checked=e,null===(t=n.container)||void 0===t||t.syncChildConfigs(),!i||n.inputting||n.isConfiguring||(n.uncheckToggleGroupMembers(),n.triggerChange(!1,null))}get inputValueAttr(){return"checked"}updateColor(e,t){const n=this.element.classList;t&&n.remove(t),e&&n.add(e)}getToggleGroupRootElement(){const e=this.toggleGroupRootElement;let t;return e&&"string"==typeof e&&this.element&&(t=this.element.closest(e)),t||this.rootElement}getToggleGroupMembers(){const e=this,{toggleGroup:t,input:n,type:i}=e,r=[];return t&&ki.forEachSelector(e.getToggleGroupRootElement(),`input[type=${i}][data-group=${t}]`,(e=>{if(e!==n){const t=hd.fromElement(e);t&&r.push(t)}})),r}uncheckToggleGroupMembers(e){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach((e=>{e._propagatingUserActionFrom=this,e.checked=!1,e._propagatingUserActionFrom=null}))}check(){this.checked=!0}uncheck(){this.checked=!1}toggle(){this.checked=!this.checked}internalOnClick(e){return this.readOnly?(e.preventDefault(),!1):this.trigger("click",{event:e})}internalOnChange(e){const t=this;t.readOnly&&t.value!==t.input.checked?t.input.checked=t.value:(t.value=t.input.checked,t.inputting||(t.inputting=!0,t.triggerChange(!0,e),t.inputting=!1))}updateInputReadOnly(e){}triggerChange(e,t){const n=this,{checked:i}=n.input,r={checked:i,value:i,oldValue:!i,userAction:e,valid:!0,event:t};n._propagatingUserActionFrom&&(r.propagatingUserActionFrom=n._propagatingUserActionFrom);if(!(!i&&e&&n.toggleGroup&&n.getToggleGroupMembers().filter((e=>e.isVisible&&!e.disabled)).length||!1===n.trigger("beforeChange",r)))return n.triggerFieldChange(r,!1),e&&n.uncheckToggleGroupMembers(e),n.trigger("action",r),n.trigger("change",r),!0;n.input.checked=n._value=!i}configureOverflowTwin(e){const t=this,n=super.configureOverflowTwin(e);return n.type=hd.resolveType("menuitem"),n.text||(n.text=t.label||t.text||t.tooltipText),n}}ep.initClass(),ep._$name="Checkbox";class tp extends(nh.mixin(am)){static $name="FieldSet";static type="fieldset";static configurable={bodyTag:"fieldset",focusable:!1,localizableProperties:["label"],inline:null,inlineInternal:null,layout:{type:"box",horizontal:!1}};static get prototypeProperties(){return{flexRowCls:"b-hbox",flexColCls:"b-vbox"}}get bodyConfig(){const e=super.bodyConfig,{className:t}=e,{inlineInternal:n,hasLabel:i,title:r}=this;return delete e.html,t["b-inline"]=n,t["b-fieldset-has-label"]=i,r&&(e.children={legendElement:{tag:"legend",text:r,class:{"b-fieldset-legend":1}}}),e}compose(){const{inlineInternal:e,label:t,labelCls:n,labelWidth:i}=this;return{class:{"b-field":t,"b-vbox":!e},children:{"labelElement > headerElement":t?{tag:"label",html:t,class:{"b-label":1,"b-align-start":1,[n]:n},style:{width:ki.unitize("width",i)[1]}}:null}}}syncInlineInternal(){this.inlineInternal=this.inline??(null!=this.label&&"before"===this.labelPosition)}updateDisabled(e,t){super.updateDisabled(e,t),this.eachWidget((t=>{t.disabled=e}),!1)}updateInline(){this.syncInlineInternal()}updateInlineInternal(e){this.layout.horizontal=e}updateLabel(){this.syncInlineInternal()}updateLabelPosition(){this.syncInlineInternal()}}tp.initClass(),tp._$name="FieldSet";class np extends ep{static $name="Radio";static type="radio";static alias="radiobutton";static get configurable(){return{inputType:"radio",clearable:null,uncheckedValue:void 0}}get textLabelCls(){return super.textLabelCls+" b-radio-label"}internalOnClick(e){!1!==super.internalOnClick(e)&&this.checked&&this.clearable&&(this.checked=!1)}updateName(e){this.toggleGroup=e}updateClearable(){}}np.initClass(),np._$name="Radio";class ip extends tp{static $name="RadioGroup";static type="radiogroup";static configurable={defaultType:"radio",clearable:null,name:null,options:{value:null,$config:{merge:"items"}},defaultBindProperty:"value"};afterConstruct(){super.afterConstruct(),this.name||(this.name=this.ref||this.id)}triggerPaint(...e){const t=this,n=!t.isPainted,i=t.__value;super.triggerPaint(...e),d.isFirefox&&t.isVisible&&n&&void 0!==i&&i!==t.value&&(t.value=void 0,t.value=i)}get existingOptions(){const{name:e}=this;return this.ensureItems().filter((t=>t.name===e))}get refPrefix(){return`${this.name||this.ref||this.id}_`}get selected(){return this.existingOptions.filter((e=>e.input.checked))[0]||null}get value(){const{selected:e}=this;return e?e.checkedValue:null}set value(e){this.existingOptions.forEach((t=>{t.isConfiguring=this.isConfiguring,t.checked=t.checkedValue===e,t.isConfiguring=!1})),d.isFirefox&&!this.isConnected&&(this.__value=e)}ensureItems(){return this.getConfig("options"),super.ensureItems()}changeOptions(e,t){if(!(e&&t&&U.isDeeplyEqual(t,e)))return e}convertOption(e,t,n){const i=this,{name:r}=i,s={name:r,type:i.defaultType,value:i.peekConfig("value"),ref:`${i.refPrefix}${e}`,disabled:i.disabled,checkedValue:e};return"string"==typeof t?s.text=t:U.assign(s,t),n?hd.reconfigure(n,s):s}isOurRadio(e){return(e.isRadio||e.isCheckbox)&&e.name===this.name}isolateFieldChange(e){return this.isOurRadio(e)}onChildAdd(e){super.onChildAdd(e),this.isOurRadio(e)&&e.ion({name:e.id,beforeChange:"onItemBeforeChange",change:"onItemChange",click:"onItemClick",thisObj:this})}onChildRemove(e){this.isOurRadio(e)&&this.detachListeners(e.id),super.onChildRemove(e)}onItemClick(e){const{source:t}=e;t.checked&&this.clearable&&null==t.clearable&&(t.checked=!1)}onItemBeforeChange(e){if(e.checked){const t=this,{lastValue:n}=t;if(!t.reverting&&!1===t.trigger("beforeChange",t.wrapRadioEvent(e))&&null!=n&&n!==t.value)return t.reverting=!0,e.source.uncheckToggleGroupMembers(),t.value=n,t.lastValue=n,t.reverting=!1,!1}}onItemChange(e){const t=this;e.checked&&!t.reverting&&(t.triggerFieldChange(t.wrapRadioEvent(e)),t.lastValue=t.value)}wrapRadioEvent(e){return{from:e,item:e.source,userAction:e.userAction,lastValue:this.lastValue,value:this.value}}updateName(){const{name:e}=this;this.ensureItems().forEach((t=>{(t.isRadio||t.isCheckbox)&&(t.name=e)}))}updateOptions(){const e=this,{options:t,refPrefix:n}=e,i=e.existingOptions.reduce(((e,t)=>(e[t.ref.substring(n.length)]=t,e)),{});let r,s,o=0;if(t)for(r in t)s=e.convertOption(r,t[r],i[r]),delete i[r],e.insert(s,o++);const a=Object.values(i);null!=a&&a.length&&(e.remove(a),a.forEach((e=>e.destroy())))}}ip.initClass(),ip._$name="RadioGroup";class rp extends(ip.mixin(lm)){static $name="CheckboxGroup";static type="checkboxgroup";static configurable={defaultType:"checkbox",defaults:{color:"b-blue"},separator:",",requiredSelectedOptions:null,minSelectedOptions:null,maxSelectedOptions:null,errorTooltipCachePath:"checkboxGroupErrorTooltip",errorTooltipConfig:{forSelector:".b-checkboxgroup.b-invalid .b-checkbox-label",align:"t-b"}};onItemBeforeChange(e){const t=this,{lastValue:n}=t;if(!t.reverting&&!1===t.trigger("beforeChange",t.wrapRadioEvent(e))&&null!=n&&n!==t.value)return t.reverting=!0,e.source.uncheckToggleGroupMembers(),t.value=n,t.lastValue=n,t.reverting=!1,!1}onItemChange(e){const t=this;t.reverting||(t.triggerFieldChange(t.wrapRadioEvent(e)),t.lastValue=t.value),t.syncInvalid()}get selected(){return this.existingOptions.filter((e=>e.input.checked))||null}get value(){const{selected:e}=this;return e.map((e=>e.checkedValue))}set value(e){"string"==typeof(e=e||[])&&(e=e.split(this.separator)),this.existingOptions.forEach((t=>{t.isConfiguring=this.isConfiguring,t.checked=e.includes(t.checkedValue),t.isConfiguring=!1})),d.isFirefox&&!this.isConnected&&(this.__value=e)}internalOnChange(){this.syncInvalid()}get inputWrap(){return this.element}get isValid(){let e=!0;const t=this,{selected:n,requiredSelectedOptions:i,minSelectedOptions:r,maxSelectedOptions:s}=t;if(t.clearError(void 0,!0),!t.disabled){const o=isNaN(t.minSelectedOptions)||n.length>=r,a=isNaN(t.maxSelectedOptions)||n.length<=s;i&&n.length!==i?(e=!1,t.setError(t.L("L{wrongNbrOfOptionsSelected}",i),!0)):o?a||(e=!1,t.setError(t.L("L{tooManyOptionsSelected}",s),!0)):(e=!1,t.setError(t.L("L{tooFewOptionsSelected}",r),!0))}return e&&t.errors&&Object.keys(t.errors).length&&(e=!1),e}updateMinSelectedOptions(){this.isConfiguring||this.syncInvalid()}updateMaxSelectedOptions(){this.isConfiguring||this.syncInvalid()}updateRequiredSelectedOptions(){this.isConfiguring||this.syncInvalid()}}let sp;rp.initClass(),rp._$name="CheckboxGroup";class op extends nh{static $name="CodeEditor";static type="codeeditor";static configurable={textContent:!1,scrollable:null,codePath:null,editor:{$config:["lazy","nullify"],value:{automaticLayout:!0,scrollBeyondLastLine:!1}},header:{cls:"demo-header"},bbar:{overflow:null,items:{readOnly:{hidden:!0,type:"widget",cls:"b-icon b-icon-locked"},status:{type:"widget",html:" "},cursorPos:{type:"widget",html:" ",setPosition({lineNumber:e,column:t}){this.element.innerHTML=`Ln ${e}, Col ${t}`}}}},readOnly:null,text:{$config:["lazy","nullify"],value:null},language:null,theme:null,status:null};construct(e={}){const t=this;t.editorReady=new Promise(((e,n)=>{t.resolveEditorReady=e,t.rejectEditorReady=n})),super.construct(...arguments),t.editorReady.then((()=>{Hi.ion({theme:({theme:e})=>t.editor.updateOptions({theme:e.toLowerCase().includes("dark")?"vs-dark":"vs-light"}),thisObj:t}),t.element.style.setProperty("--vscode-menu-background",getComputedStyle(t.element.querySelector(".monaco-editor")).getPropertyValue("--vscode-menu-background"))}))}get monacoInstance(){return globalThis.monaco}focus(){this.editor.focus()}static set monacoLoadPromise(e){sp=e}static get monacoLoadPromise(){return sp}async updateCodePath(e,t){const n=this;var i;t&&(null===(i=n.loaderScript)||void 0===i||i.remove());sp||(sp=new Promise((t=>{const i=()=>{const o=globalThis.require;o.config({paths:{vs:`${e}/min/vs`}}),o(["vs/editor/editor.main"],(function(){n.isDestroyed||t(globalThis.monaco)})),s.removeEventListener("error",r),s.removeEventListener("load",i)},r=()=>{const t=`Code editor path to Monaco editor ${e} is incorrect`;s.removeEventListener("error",r),s.removeEventListener("load",i),Ih.show(t),n.rejectEditorReady(t)},s=n.loaderScript=ki.createElement({tag:"script",parent:document.head,src:`${e}/min/vs/loader.js`});s.addEventListener("error",r),s.addEventListener("load",i)}))),globalThis.monaco=await sp,n.getConfig("editor"),n.getConfig("text")}updateReadOnly(e){const{readOnly:t}=this.widgetMap;t&&(t.hidden=!e),this.editor.updateOptions({readOnly:e})}updateStatus(e){const{status:t}=this.widgetMap;t&&(t.html=e)}changeEditor(e,t){var n;const i=this;var r;(null==t||null===(n=t.dispose)||void 0===n||n.call(t),e)&&(e=i.monacoInstance.editor.create(i.contentElement,ke.merge({theme:i.theme||null!==(r=ki.themeInfo)&&void 0!==r&&r.name.toLowerCase().includes("dark")?"vs-dark":"vs-light",padding:{top:14}},e)),i.monacoInstance.languages.typescript.javascriptDefaults.setDiagnosticsOptions({noSuggestionDiagnostics:!0}),e.onDidChangeCursorPosition(i.onCursorMove.bind(i)),e.onDidChangeConfiguration(i.onEditorConfigChange.bind(i)),e.onDidDispose(i.onEditorDestroy.bind(i)),i.resolveEditorReady(e));return e}get text(){var e;return(null===(e=this.codeModel)||void 0===e?void 0:e.getValue())||this._text}changeText(e){var t;return this._text=null===(t=this.codeModel)||void 0===t?void 0:t.getValue(),e}updateText(e){const{codeModel:t}=this;var n,i;null!=e?t?t.setValue(e):this.loadText(e):null===(n=this.codeModel)||void 0===n||null===(i=n.dispose)||void 0===i||i.call(n)}async loadText(e=this.text,t=this.language){var n;const i=this;i._text=e,i._language=t,null===(n=i.codeModel)||void 0===n||n.dispose(),await i.editorReady;const r=i.codeModel=i.monacoInstance.editor.createModel(e,t);return i.editor.setModel(r),i.trigger("load",{model:r,text:e}),r}onEditorDestroy(){var e,t;null===(e=this.codeModel)||void 0===e||null===(t=e.dispose)||void 0===t||t.call(e),this.codeModel=null}onEditorConfigChange(){const e=this;e.editor&&(e.readOnly=e.editor.getOptions().get(e.monacoInstance.editor.EditorOptions.readOnly.id))}onCursorMove({position:e}){var t;null===(t=this.widgetMap.cursorPos)||void 0===t||t.setPosition(e)}}op.initClass(),op._$name="CodeEditor";class ap extends vm{static $name="ColorPicker";static type="colorpicker";static configurable={itemsFocusable:!1,navigator:{focusCls:"b-color-active"},itemWrapperTpl(e,t){const{selected:n}=this,{color:i,text:r}=e,s=this.getColorClassName(i);return yh.tpl`
                    <li
                        class="${this.getItemClasses(e,t)} ${s}"
                        role="option"
                        aria-selected="${n.includes(e)}"
                        data-index="${t}"
                        data-id="${V.encodeHtml(i)}"
                        data-btip="${r}"
                        ${this.itemsFocusable?'tabindex="-1"':""}
                        style="${s?"":"background-color: "+i}"
                    ></li>`},colorClasses:null,colorClassPrefix:null,colors:["#45171D","#F03861","#FF847C","#FECEA8","#A5F2E7","#AA83F3","#8983F3","#A10054","#073059","#2866AB","#5FBDC5","#D8D95C","#FFDEDE","#F7F3CE","#C5ECBE","#3E3E3E","#405559","#68868C","#EDEDED","#D3D6DB","#3A4750","#303841","#BE3144"],addNoColorItem:!0,columns:6,colorSelected:null,store:{useRawData:!1}};configure(e){super.configure(e),this.setItems(),this.ion({item:"onColorSelect"})}setItems(){const e=this,{colors:t,colorClasses:n}=e;let i=t||n;e.addNoColorItem&&(e.store.modelClass.allowNullId=!0,i=[...i,null]),e.items=i.map((t=>t&&"string"!=typeof t?t:{color:t,text:(n?V.capitalize(t):t)||e.L("L{noColor}")}))}afterConfigure(...e){super.afterConfigure(...e),(this.addNoColorItem||this.value)&&this.select(this.value??null)}updateColors(){this.isConfiguring||this.setItems()}updateAddNoColorItem(){this.isConfiguring||this.setItems()}onColorSelect({record:e}){var t;this.refresh();const n={color:e.color,record:e,bubbles:!0};null===(t=this.colorSelected)||void 0===t||t.call(this,n),this.trigger("colorSelected",n)}select(e){e&&"string"!=typeof e||(e=this.store.findRecord("color",e??null)),e&&super.select(e)}updateColumns(e){this.style=`grid-template-columns:repeat(${e}, 1fr);`}getColorClassName(e){var t,n;return null!==(t=this.colorClasses)&&void 0!==t&&t.includes(e)||null!==(n=this.colorClasses)&&void 0!==n&&n.find((t=>t&&t.color===e))?this.colorClassPrefix+e:e?"":"b-no-color"}}ap.initClass(),ap._$name="ColorPicker";class lp extends Tm{static $name="ColorField";static type="colorfield";static configurable={displayField:"text",valueField:"color",editable:!1,picker:{type:"colorpicker",align:{align:"t100-b100",matchSize:!1}},showBoxForNoColor:!0,colors:null,addNoColorItem:!0};configure(e){const t=e.picker??{};e.colors&&(t.colors=e.colors),"addNoColorItem"in e&&(t.addNoColorItem=e.addNoColorItem),e.picker=t,super.configure(e)}updatePicker(e,t){super.updatePicker(e,t),e&&(this.items=e.store.records)}updateColors(e){this.isConfiguring||(this.picker.colors=e)}updateAddNoColorItem(e){this.isConfiguring||(this.picker.addNoColorItem=e)}set value(e){this.store||(this.items=[],this.store=this.picker.store),e||(e=this.store.findRecord("color",null)),super.value=e}showPicker(...e){this.picker.refresh(),super.showPicker(...e)}get value(){return super.value}syncInputFieldValue(...e){var t;const n=this,{value:i}=n;let r=null===(t=n.picker)||void 0===t?void 0:t.getColorClassName(i);r||(n.colorBox.style.color=i),r="b-colorbox "+r,n.colorBox.className=r,n.showBoxForNoColor||n.element.classList.toggle("b-colorless",!i),super.syncInputFieldValue(...e)}get innerElements(){return[{reference:"colorBox",className:"b-colorbox"},...super.innerElements]}}lp.initClass(),lp._$name="ColorField";const cp=["ok","cancel","yes","no"].reduce(((e,t,n,i)=>(e[t]=Object.freeze({...Object.fromEntries(i.map((e=>[e,!1]))),name:t,approve:"ok,yes".includes(t),[t]:!0}),e)),Object.create(null)),dp=["b-raised","b-blue"],up=["b-gray"],hp=d.isWindows,gp=/(?:\s+,?|,)\s*/,mp=/^(icon|menu|text)$/;class pp extends Wu{static $name="ConfirmationBar";static type="confirmationbar";static configurable={defaultButton:"ok",defaultType:"button",items:"ok,cancel",keyMap:{Enter:"doDefault",NumpadEnter:"doDefault",Escape:"doCancel"},namedItems:{yes:{cls:"b-yes-button",text:"L{Object.Yes}",onClick:"up.onButtonClick",weight:hp?100:130},no:{cls:"b-no-button",text:"L{Object.No}",onClick:"up.onButtonClick",weight:hp?110:120},ok:{cls:"b-ok-button",text:"L{Object.Ok}",onClick:"up.onButtonClick",weight:hp?120:110},cancel:{cls:"b-cancel-button",text:"L{Object.Cancel}",onClick:"up.onButtonClick",weight:hp?130:100}},syncWidthButtons:null};static delayable={syncButtons:{type:"raf",suspended:!0}};get buttons(){return this.items.filter((e=>e.isButton))}get cancelButton(){return this.widgetMap.cancel||null}get noButton(){return this.widgetMap.no||null}get okButton(){return this.widgetMap.ok||null}get yesButton(){return this.widgetMap.yes||null}changeItems(e,t){return"string"==typeof e&&(e=Object.fromEntries(e.split(gp).map((e=>[e,!0])))),super.changeItems(e,t)}clickButton(e,t){var n;const{widgetMap:i,defaultButton:r}=this;let s,o,a=t?i.cancel||i.no:i[r];if(!a)for([o,s]of Object.entries(i))if(o!==r){a=s;break}null===(n=a)||void 0===n||n.onInternalClick(e)}doCancel(e){this.clickButton(e,!0)}doDefault(e){this.clickButton(e)}onButtonClick(e){this.trigger("choice",{...e,choice:cp[e.source.ref],source:this,userAction:!0})}onChildAdd(e){super.onChildAdd(e),te.before(e,"onConfigChange","onChildConfigChange",this),this.syncButtons()}onChildConfigChange({name:e}){mp.test(e)&&this.syncButtons()}onChildRemove(e){super.onChildRemove(e),this.syncButtons()}onInternalPaint(e){super.onInternalPaint(e),e.firstPaint&&this.syncButtons.resume(),this.syncButtons.now()}syncButtons(){const e=this,t=e.isDestroying?[]:e.buttons,{defaultButton:n}=e;let i,r;!1!==e.syncWidthButtons&&t.forEach((e=>{(r=e.text)&&(i=Math.max(i||0,r.length+Boolean(e.icon)+Boolean(e.menu)))})),t.forEach((e=>{const{classList:t}=e.element,r=e.ref===n;t.add(...r?dp:up),t.remove(...r?up:dp),t.toggle("b-default-button",r),e.minWidth=i&&e.text?`${i}em`:null}))}updateAutoWidthButtons(){this.syncButtons()}updateDefaultButton(){this.syncButtons()}}pp.initClass(),pp._$name="ConfirmationBar";class fp extends nh{static $name="MonthPicker";static type="monthpicker";static configurable={textContent:!1,tbar:{overflow:null,items:{title:{type:"button",cls:"b-monthpicker-title",onAction:"up.handleTitleClick"}}},itemCls:"b-month-container",month:null};construct(e){super.construct({month:(new Date).getMonth(),...e}),Mn.on({element:this.contentElement,click:"onMonthClick",delegate:".b-monthpicker-month",thisObj:this})}get focusElement(){return this.getMonthButton(this.month)}getMonthButton(e){return this.contentElement.querySelector(`.b-monthpicker-month[data-month="${e}"]`)}onMonthClick({target:e}){const t=parseInt(e.getAttribute("data-month"));this.month===t?this.trigger("select",{oldValue:t,value:t}):this.month=t}handleTitleClick(e){this.trigger("titleClick",e)}changeMonth(e){if(!isNaN(e))return U.isDate(e)?e.getMonth():e>=0&&e<=11?e:void 0}updateMonth(e,t){this.isConfiguring||this.trigger("select",{oldValue:t,value:e})}composeBody(){this.getConfig("month");const e=super.composeBody(),t=e.children[this.tbar?1:0].children=[];this.widgetMap.title.text=us.getMonthName(this.month);for(let e=0;e<=11;e++)t.push({tag:"button",dataset:{month:e},class:{"b-monthpicker-month":1,"b-selected":e===this.month},text:us.getMonthShortName(e)});return e}async updateLocalization(){this.isConfiguring||await this.recompose(),super.updateLocalization()}}fp.initClass(),fp._$name="MonthPicker";class vp extends nh{static $name="YearPicker";static type="yearpicker";static configurable={textContent:!1,tbar:{overflow:null,items:{previous:{type:"tool",cls:"b-icon b-icon-previous",onAction:"up.previous",weight:100},title:{type:"button",cls:"b-yearpicker-title",weight:200,onAction:"up.handleTitleClick"},next:{type:"tool",cls:"b-icon b-icon-next",onAction:"up.next",weight:300}}},itemCls:"b-year-container",yearButtonCount:12,year:null,minYear:null,maxYear:null,startYear:null};construct(e){super.construct({year:(new Date).getFullYear(),...e}),Mn.on({element:this.contentElement,click:"onYearClick",delegate:".b-yearpicker-year",thisObj:this})}get focusElement(){return this.getYearButton(this.year)||this.getYearButton(this.startYear)}getYearButton(e){return this.contentElement.querySelector(`.b-yearpicker-year[data-year="${e}"]`)}get value(){return this.year}set value(e){this.year=e}onYearClick({target:e}){const t=Math.min(Math.max(parseInt(e.innerText),this.minYear||1),this.maxYear||9999);this.year===t?this.trigger("select",{oldValue:t,value:t}):this.year=t}handleTitleClick(e){this.trigger("titleClick",e)}previous(){this.startYear=this.startYear-this.yearButtonCount}next(){this.startYear=this.endYear+1}ingestYear(e){if(!isNaN(e))return U.isDate(e)?e.getFullYear():e}changeYear(e){if(e=this.ingestYear(e))return Math.min(Math.max(e,this.minYear||1),this.maxYear||9999)}updateYear(e,t){const n=this;!n.startYear||e>n.endYear?n.startYear=e:e<n.startYear&&(n.startYear=e-(n.yearButtonCount-1)),n.isConfiguring||n.trigger("select",{oldValue:t,value:e})}get endYear(){return this.startYear+this.yearButtonCount-1}changeStartYear(e){if(e=this.ingestYear(e))return e=this.minYear?Math.max(e,this.minYear):e,this.maxYear?Math.min(e,this.maxYear-(this.yearButtonCount-1)):e}async updateStartYear(e,t){this.isVisible&&ki.slideIn(this.contentElement,Math.sign(e-t))}composeBody(){this.getConfig("year");const{startYear:e}=this,t=super.composeBody(),n=t.children[this.tbar?1:0].children=[];this.widgetMap.title.text=`${`000${e}`.slice(-4)} - ${`000${this.endYear}`.slice(-4)}`;for(let t=0,i=e;t<this.yearButtonCount;t++,i++)n.push({tag:"button",dataset:{year:i},class:{"b-yearpicker-year":1,"b-selected":i===this.year},text:`000${i}`.slice(-4)});return t}}vp.initClass(),vp._$name="YearPicker";class yp extends Sm{static $name="DisplayField";static type="displayfield";static alias="display";static get configurable(){return{readOnly:!0,editable:!1,cls:"b-display-field",template:null,ariaElement:"displayElement"}}get focusElement(){}changeReadOnly(){return!0}changeEditable(){return!1}get inputElement(){return{tag:"span",id:`${this.id}-input`,reference:"displayElement",html:this.template?this.template(this.value):V.encodeHtml(this.value)}}}yp.initClass(),yp._$name="DisplayField";const bp=(e,t)=>e.valueOf()-t.valueOf(),{DateSet:Cp}=us,Sp=Object.freeze([]),wp=e=>e.every(((t,n)=>!(n&&us.add(e[n-1],1,"d")-t))),Dp={magnitude:1,unit:"week"};class Ep extends Lm{static $name="DatePicker";static type="datepicker";static get delayable(){return{refresh:"raf"}}static get configurable(){return{activeDate:{$config:"date",value:"today"},focusable:!0,textContent:!1,tbar:{overflow:null,items:{prevYear:{cls:"b-icon b-icon-first b-datepicker-nav-button",onAction:"up.gotoPrevYear",tooltip:"L{DatePicker.gotoPrevYear}",weight:100},prevMonth:{cls:"b-icon b-icon-previous b-datepicker-nav-button",onAction:"up.gotoPrevMonth",tooltip:"L{DatePicker.gotoPrevMonth}",weight:200},fields:{type:"container",cls:"b-datepicker-title",items:{monthButton:{type:"button",cls:"b-datepicker-monthbutton",internalListeners:{click:"up.onMonthPickerRequested"}},yearButton:{type:"button",cls:"b-datepicker-yearbutton",internalListeners:{click:"up.onYearPickerRequested"}}},weight:300},nextMonth:{cls:"b-icon b-icon-next b-datepicker-nav-button",onAction:"up.gotoNextMonth",tooltip:"L{DatePicker.gotoNextMonth}",weight:400},nextYear:{cls:"b-icon b-icon-last b-datepicker-nav-button",onAction:"up.gotoNextYear",tooltip:"L{DatePicker.gotoNextYear}",weight:500}}},monthPicker:{value:{type:"MonthPicker",trapFocus:!0,positioned:!0,hidden:!0,internalListeners:{titleClick:"up.onMonthPickerTitleClick",select:"up.onMonthPicked",Escape:"up.onMonthPickerTitleClick"}},$config:"lazy"},yearPicker:{value:{type:"YearPicker",yearButtonCount:16,trapFocus:!0,positioned:!0,hidden:!0,internalListeners:{titleClick:"up.onYearPickerTitleClick",select:"up.onYearPicked"}},$config:"lazy"},date:null,minDate:{$config:"date",value:null},maxDate:{$config:"date",value:null},focusDisabledDates:null,multiSelect:null,selection:{$config:{equal:(e,t)=>e&&e.equals(t)},value:null},editMonth:{$config:"lazy",value:null},includeYear:{$config:"lazy",value:null},dayNameFormat:"dd",trapFocus:!0,ariaElement:"weeksElement",focusDescendant:!0,alwaysRefreshOnMonthChange:null,highlightSelectedWeek:null}}static get prototypeProperties(){return{outOfRangeCls:"b-out-of-range",activeCls:"b-active-date",selectedCls:"b-selected-date"}}static _monthNames=us.getMonthNames();construct(e){const t=this;super.construct(e);const{widgetMap:n}=t;t.externalCellRenderer=t.cellRenderer,t.cellRenderer=t.internalCellRenderer,t.element.removeAttribute("tabindex"),t.ariaElement.setAttribute("aria-activedescendant",`${t.id}-active-day`),n.fields&&!t.ariaLabel&&t.element.setAttribute("aria-labelledby",n.fields.id),Mn.on({element:t.weeksElement,click:{handler:"onCellClick",delegate:`.${t.dayCellCls}:not(.${t.disabledCls}):not(.${t.outOfRangeCls})`},mousedown:{handler:"onCellMousedown",delegate:`.${t.dayCellCls}`},thisObj:t}),t.getConfig("editMonth"),t.getConfig("includeYear"),t.refresh.flush()}get labelledElement(){return this.element}afterHide(...e){var t,n;null===(t=this._monthPicker)||void 0===t||t.hide(),null===(n=this._yearPicker)||void 0===n||n.hide(),super.afterHide(...e)}doDestroy(){var e,t;null===(e=this.yearButton)||void 0===e||e.destroy(),null===(t=this.monthButton)||void 0===t||t.destroy(),super.doDestroy()}get activeDayCell(){return this.weeksElement.querySelector(`#${this.id}-active-day`)}get focusElement(){return!this.disabled&&this.activeDayCell||this.element}onMonthDateChange(e){const t=super.onMonthDateChange(e);return this.ariaElement.setAttribute("aria-label",us.format(this.date,"MMMM YYYY")),this.refresh.flush(),t}updateEditMonth(e){const{monthButton:t,yearButton:n}=this.widgetMap,i=!1===e;t&&(t.readOnly=i),n&&(n.disabled=i)}updateIncludeYear(e){const{yearButton:t}=this.widgetMap;t&&(t.hidden=!1===e)}updateReadOnly(e){e?this.element.setAttribute("inert",!0):this.element.removeAttribute("inert")}doRefresh(...e){const t=this,{date:n,widgetMap:i}=t,r=t.activeDayCell,s=us.betweenLesser(t.activeDate,t.month.startDate,t.month.endDate)?t.activeDate:t._activeDate=n;t.getConfig("tbar"),super.doRefresh(...e),i.monthButton&&(i.monthButton.text=t.constructor._monthNames[n.getMonth()]),i.yearButton&&(i.yearButton.text=n.getFullYear());const o=us.parseKey(null==r?void 0:r.dataset.date);s-o&&t.syncActiveDate(s,o)}internalCellRenderer({cell:e,date:t}){const n=this,{externalCellRenderer:i}=n,r=n.isSelectedDate(t),s=n.getCellClassList(...arguments);if(r&&n.multiSelect){const e=!n.isSelectedDate(us.add(t,-1,"d")),i=!n.isSelectedDate(us.add(t,1,"d"));s["b-range-start"]=e,s["b-range-end"]=i,s["b-in-range"]=!e&&!i}ki.updateClassList(e,s),e.innerHTML=`<div class="b-datepicker-cell-inner">${t.getDate()}</div>`,e.setAttribute("role","gridcell"),e.setAttribute("aria-label",us.format(t,"dddd MMMM Do, YYYY")),ki.toggleAttribute(e,"aria-selected",r),n.isActiveDate(t)?e.id=`${n.id}-active-day`:e.removeAttribute("id"),i&&(arguments[0].cell=e.firstChild,n.callback(i,this,arguments))}getCellClassList({date:e}){const t=this,{activeCls:n,selectedCls:i}=t;return{[n]:n&&t.isActiveDate(e),[i]:t.isSelectedDate(e),[t.outOfRangeCls]:t.minDate&&e<t.minDate||t.maxDate&&e>t.maxDate}}onCellMousedown(e){const t=e.target.closest("[data-date]");this.focusable?(t.focus(),ki.getActiveElement(t)===t&&e.preventDefault()):e.preventDefault(),this.activeDate=us.parseKey(t.dataset.date)}onCellClick(e){const t=e.target.closest("[data-date]");this.onUIDateSelect(us.parseKey(t.dataset.date),e)}onUIDateSelect(e,t){const n=this,{lastClickedDate:i,multiSelect:r}=n;n.isDisabledDate(e)||!1!==n.trigger("beforeDateSelect",{date:e,event:t})&&(n.lastClickedDate=e,n.activatingEvent=t,r?n.handleMultiSelect(i,e,t):(n.date=n.selection=e,n.floating&&n.hide()),n.activatingEvent=null)}handleMultiSelect(e,t,n){const i=this,{multiSelect:r}=i,s=i._selection||(i._selection=new Cp),o=s.dates,a="range"===r||"simple"===r,l="simple"===r||ki.isTouchEvent,{size:c,generation:d}=s,u=c&&{[us.makeKey(us.add(o[0],-1,"d"))]:1,[us.makeKey(o[0])]:1,[us.makeKey(o[o.length-1])]:1,[us.makeKey(us.add(o[o.length-1],1,"d"))]:1},h=s.has(t)?"delete":"add",g=a&&(null==u?void 0:u[us.makeKey(t)]);if(l&&c>1)s.clear(),s.add(t);else if(n.ctrlKey)!0!==r&&c&&!g||(s[h](t),a&&!s.has(i.rangeStartDate)&&i.rangeStartDate.setDate(i.rangeStartDate.getDate()+(t<o[1]?1:-1)));else if((l||n.shiftKey)&&c){const[n,r]=[new Date(a?i.rangeStartDate||(i.rangeStartDate=o[0]):e),t].sort(bp);a&&s.clear();for(const e=n;e<=r;e.setDate(e.getDate()+1))s.add(e)}else s.has(t)&&1===s.size||(s.clear(),s.add(t));const m=s.size;1===m?i.rangeStartDate=t:m||(i.rangeStartDate=null),s.generation!==d&&i.updateSelection(s)}updateHighlightSelectedWeek(e){this.element.classList.toggle("b-highlight-selected-week",Boolean(e))}updateMultiSelect(e){this.element.classList.toggle("b-multiselect",Boolean(e)),e||(this.selection=[...this.selection][0])}get selection(){const{_selection:e}=this,t=e?e.dates:Sp;return"range"===this.multiSelect&&t.length?[t[0],t[t.length-1]]:t}getRange(e){if(this.multiSelect){const{selection:t}=this,n=t[0],i=t[t.length-1],r=us.add(i,1,"d");if(t.length>1&&r.getDate()===n.getDate())return{unit:"month",magnitude:us.diff(n,r,"month"),wholeMonth:1===n.getDate()&&i.getDate()===us.getLastDateOfMonth(i).getDate()&&wp(t),startDate:n,endDate:i};if(n.getDay()==us.weekStartDay&&i.getDay()===(us.weekStartDay+6)%7)return{unit:"week",magnitude:us.diff(n,r,"week"),startDate:n,endDate:i};if(e){const e=us.floor(n,Dp),t=us.ceil(r,Dp),i=Math.max(Math.ceil(us.diff(e,t,"w")),1);return t.setDate(t.getDate()-1),{unit:"week",magnitude:i,startDate:e,endDate:t}}return{unit:"day",magnitude:us.diff(n,i,"d")+1,startDate:n,endDate:i}}}get snappedRange(){}changeSelection(e,t){const n=this;let i,r;if(e)if(e.isDateSet){if(t===e||null!=t&&t.equals(e))return t;r=U.first(e),i=e}else if(e.forEach||(e=[e]),e.forEach(((t,i)=>e[i]=n.changeDate(t))),r=e[0],e.sort(bp),"range"===n.multiSelect&&2===e.length){i=new Cp;for(const t=new Date(e[0]);t<=e[1];t.setDate(t.getDate()+1))i.add(t)}else r=e[0],i=new Cp(e);else i=new Cp;return r&&(n.rangeStartDate=us.clearTime(r)),i}updateSelection(e,t){const n=this,{multiSelect:i}=n,{dates:r}=e,s="range"===i?[r[0],r[r.length-1]]:r;if(!n.isConfiguring){i||!r.length||n.peekConfig("date")||r[0].getMonth()!==n.month.month||(n.date=r[0]),n.refresh.now();const e={selection:s,userAction:Boolean(n.activatingEvent)};if(t){const{dates:n}=t;e.oldSelection="range"===i?[n[0],n[n.length-1]]:n}n.trigger("selectionChange",e)}}isSelected(e){return this.selection.some((t=>us.isSameDate(t,e)))}onInternalKeyDown(e){const t=this,n=e.key.trim()||e.code,i=t.activeDate;let r=new Date(i);if("Escape"===n){if(t.monthPicker.isVisible)return t.monthPicker.hide();if(t.yearPicker.isVisible)return t.yearPicker.hide();if(t.floating)return t.hide()}if(i&&t.weeksElement.contains(e.target)){do{switch(n){case"ArrowLeft":e.preventDefault(),e.ctrlKey?r=t.gotoPrevMonth():r.setDate(r.getDate()-1);break;case"ArrowUp":e.preventDefault(),r.setDate(r.getDate()-7);break;case"ArrowRight":e.preventDefault(),e.ctrlKey?r=t.gotoNextMonth():r.setDate(r.getDate()+1);break;case"ArrowDown":e.preventDefault(),r.setDate(r.getDate()+7);break;case"Enter":return t.onUIDateSelect(i,e)}}while(t.isDisabledDate(r)&&!t.focusDisabledDates);if(t.minDate&&r<t.minDate)return;if(t.maxDate&&r>t.maxDate)return;t.activeDate=r}}changeMinDate(e){return e&&Lm.prototype.changeDate.apply(this,arguments)}updateMinDate(e){this._yearPicker&&(this._yearPicker.minYear=null==e?void 0:e.getFullYear()),this.refresh()}changeMaxDate(e){return e&&Lm.prototype.changeDate.apply(this,arguments)}updateMaxDate(e){this._yearPicker&&(this._yearPicker.maxYear=null==e?void 0:e.getFullYear()),this.refresh()}changeDate(e){return us.clamp(super.changeDate(e),this.minDate,this.maxDate)}updateDate(e,t){const n=this,{month:i}=n;if(n.isConfiguring&&!n.initializingActiveDate&&("selection"in n.initialConfig||(n.selection=e),"activeDate"in n.initialConfig||(n.activeDate=e)),!i.date||e.getMonth()===i.month||!n.getCell(e)||n.alwaysRefreshOnMonthChange||n.isNavigating)super.updateDate(e);else{const r=i.getOtherMonth(e),s=n.eventListeners&&(t?e.getDate()!==t.getDate()|(r.getWeekId(e)!==i.getWeekId(t))<<1|(e.getMonth()!==(null==t?void 0:t.getMonth()))<<2|(e.getFullYear()!==(null==t?void 0:t.getFullYear()))<<3:15);n.trigger("dateChange",{changes:{d:!0,w:Boolean(2&s),m:Boolean(12&s),y:Boolean(8&s),r:r.weekCount!==i.weekCount},value:e,oldValue:t})}}changeActiveDate(e,t){const n=this;if("today"===e&&(e=new Date),!1!==n.trigger("beforeActiveDateChange",{activeDate:e,oldActiveDate:t})){if(e=e?n.changeDate(e):n.date||(n.date=us.clearTime(new Date)),isNaN(e))throw new Error("DatePicker activeDate must be passed a Date, or a YYYY-MM-DD date string");return us.clamp(e,n.minDate,n.maxDate)}}updateActiveDate(e,t){const n=this,{isConfiguring:i}=n;!i&&n.getCell(e)||(n.initializingActiveDate=i,n.date=e,n.initializingActiveDate=!1),i||n.refresh.isPending||n.syncActiveDate(e,t)}syncActiveDate(e,t){const n=this,{activeCls:i}=n,r=n.getCell(e),s=t&&n.getCell(t),o=ki.getActiveElement(n.element);r&&(n.focusable&&r.setAttribute("tabIndex","0"),i&&r.classList.add(i),r.id=`${n.id}-active-day`,n.weeksElement.contains(o)&&r.focus()),s&&s!==r&&(n.focusable&&s.removeAttribute("tabIndex"),i&&s.classList.remove(i),s.removeAttribute("id"))}set value(e){const t=this,{selection:n,duration:i}=t;if(t.isNavigating=!0,e){if(e=t.changeDate(e,t.value),"range"===t.multiSelect&&2===(null==n?void 0:n.length))return us.betweenLesserEqual(e,...n)||(e<n[0]?t.selection=[e,us.add(e,i-1,"d")]:t.selection=[us.add(e,-(i-1),"d"),e]),void(t.date=t.activeDate=e);void 0!==e&&(t.selection=e,t.date=t.activeDate=e)}else t.date=t.activeDate=new Date,t.selection=null;t.isNavigating=!1}get value(){const{selection:e}=this,t=(null==e?void 0:e.length)||null;return t&&e[t-1]}get duration(){return"range"===this.multiSelect?us.diff(...this.selection,"d")+1:1}gotoPrevYear(){return this.goto(-1,"year")}gotoPrevMonth(){return this.goto(-1,"month")}gotoNextMonth(){return this.goto(1,"month")}gotoNextYear(){return this.goto(1,"year")}goto(e,t){const n=this,{activeDate:i}=n,r=i&&n.getCell(i);let s;return s="month"===t&&r&&(null==i?void 0:i.getMonth())===n.month.month+e?i:us.add(r?i:n.date,e,t),n.gotoDate(s,e,r)}gotoDate(e,t,n=this.activeDate&&this.getCell(this.activeDate)){const i=this,r=new Date(e);r.setDate(1);const s=us.add(us.add(r,1,"month"),-1,"day");if(i.minDate&&t<0&&s<i.minDate||i.maxDate&&t>0&&r>i.maxDate)return;i.isNavigating=!0;const o=i.date=e;return i.widgetMap.monthButton.text=i.constructor._monthNames[e.getMonth()],n&&(i.activeDate=e),i.isNavigating=!1,o}isActiveDate(e){return!(e-this.activeDate)}isSelectedDate(e){var t;return null===(t=this._selection)||void 0===t?void 0:t.has(e)}onFocusIn(e){var t;(super.onFocusIn(e),e.toWidget!==this||e._target!==this.element||this.disabled)||(null===(t=this.focusElement)||void 0===t||t.focus())}onMonthPickerRequested(){const{monthPicker:e}=this;e.isVisible?e.hide():(e.month=this.activeDate.getMonth(),e.show(),e.focus())}onYearPickerRequested(){const{yearPicker:e}=this;e.isVisible?e.hide():(e.year=e.startYear=this.activeDate.getFullYear(),e.show(),e.focus())}onMonthPickerTitleClick(){this.monthPicker.hide()}onYearPickerTitleClick(){this.yearPicker.hide()}onMonthPicked({value:e,source:t}){var n;const i=this;i.gotoDate(us.add(i.activeDate,e-i.activeDate.getMonth(),"month")),i.widgetMap.monthButton.text=i.constructor._monthNames[i.activeDate.getMonth()],null===(n=i.focusElement)||void 0===n||n.focus({preventScroll:!0}),t.hide()}onYearPicked({value:e,source:t}){var n;const i=new Date(this.activeDate);i.setFullYear(e),this.activeDate=i,null===(n=this.focusElement)||void 0===n||n.focus({preventScroll:!0}),t.hide()}changeMonthPicker(e,t){return fp.reconfigure(t,e?fp.mergeConfigs({owner:this,appendTo:this.element},e):null,this)}changeYearPicker(e,t){var n,i;return vp.reconfigure(t,e?vp.mergeConfigs({owner:this,appendTo:this.element,minYear:null===(n=this.minDate)||void 0===n?void 0:n.getFullYear(),maxYear:null===(i=this.maxDate)||void 0===i?void 0:i.getFullYear()},e):null,this)}get childItems(){const{_yearPicker:e,_monthPicker:t}=this,n=super.childItems;return e&&n.push(e),t&&n.push(t),n}updateLocalization(){const e=this,{monthButton:t}=e.widgetMap,n=e.constructor._monthNames=us.getMonthNames();t&&!e.isConfiguring&&(t.text=n[e.monthPicker.month??e.date.getMonth()]),super.updateLocalization()}changeMultiSelect(e){return"range"===e&&d.isTouchDevice&&(e="simple"),e}}Ep.initClass(),Ep._$name="DatePicker";const xp=new Date;class Rp extends wm{static $name="DateField";static type="datefield";static alias="date";static configurable={format:"L",strictParsing:!1,fallbackFormat:"YYYY-MM-DD",timeFormat:"HH:mm:ss:SSS",keepTime:!1,pickerFormat:null,validateDateOnly:null,triggers:{expand:{cls:"b-icon-calendar",handler:"onTriggerClick",weight:200},back:{cls:"b-icon b-icon-angle-left b-step-trigger b-step-trigger-back",key:"Shift+ArrowDown",handler:"onBackClick",align:"start",weight:100},forward:{cls:"b-icon b-icon-angle-right b-step-trigger b-step-trigger-forward",key:"Shift+ArrowUp",handler:"onForwardClick",align:"end",weight:100}},calendarContainerCls:"",min:null,max:null,step:!1,stepTriggers:{$config:null,default:!0},weekStartDay:null,picker:{type:"datepicker",floating:!0,scrollAction:"realign",align:{align:"t0-b0",axisLock:!0}},value:null,role:"combobox"};changePicker(e,t){var n;if(null!=e&&e.isDatePicker)return e;const i=this,r=Ep.mergeConfigs({owner:i,forElement:i.pickerAlignElement,minDate:i.min,maxDate:i.max,weekStartDay:i._weekStartDay,align:{anchor:i.overlayAnchor,target:i.pickerAlignElement},internalListeners:{selectionChange:"onPickerSelectionChange",thisObj:i}},e);i.calendarContainerCls&&(r.cls=i.calendarContainerCls),i.value?r[i.isValid?"value":"activeDate"]=i.value:r.activeDate||(r.activeDate=new Date);const s=Ep.reconfigure(t,e?r:null,i);return null==s||null===(n=s.refresh)||void 0===n||n.flush(),s}onPickerSelectionChange({selection:e,source:t}){if(t.isVisible){const n=this,i=e.length?n.value?us.copyTimeValues(new Date(e[0]),n.value):new Date(e[0]):null;n._isUserAction=n._isPickerInput=!0,n.value=i,n._isPickerInput=n._isUserAction=!1,t.hide()}}getStepDate(e){const{step:t}=this;return us.add(this.value,(e||1)*t.magnitude,t.unit)}stepDate(e,t=!0){const n=this;if(!n.readOnly&&n.value){const i=n.getStepDate(e);n.checkMinMax(i)||(t?(n._isUserAction=!0,n.value=i,n.autoSelect&&n.select(),n._isUserAction=!1):n.value=i)}}onBackClick(){this.stepDate(-1)}onForwardClick(){this.stepDate(1)}showPicker(e){if(this.readOnly)return;const t=this,{_picker:n}=t;if(n){const e={minDate:t.min,maxDate:t.max};t.value?e[t.isValid?"value":"activeDate"]=t.value:n.activeDate||(e.activeDate=new Date),n.setConfig(e)}super.showPicker(e)}focusPicker(){var e;null===(e=this.picker)||void 0===e||e.focus()}checkMinMax(e){const{min:t,max:n}=this;return t&&e<t?-1:n&&e>n?1:0}get isValid(){const e=this;e.clearError("L{Field.minimumValueViolation}",!0),e.clearError("L{Field.maximumValueViolation}",!0);let{value:t}=e;if(t){let{min:n,max:i,validateDateOnly:r}=e;if(r&&(t=us.clearTime(t,!1),n&&(n=us.clearTime(n,!1)),i&&(i=us.clearTime(i,!1))),n&&t<n)return e.setError("L{Field.minimumValueViolation}",!0),!1;if(i&&t>i)return e.setError("L{Field.maximumValueViolation}",!0),!1}return super.isValid}transformDateValue(e,t=!0){const n=this;return null!=e&&(us.isDate(e)||(e="string"==typeof e?us.parse(e,n.format,n.strictParsing)||us.parse(e,n.fallbackFormat,n.strictParsing):new Date(e)),us.isValidDate(e))?t&&(!n.min||e-n.min>-us.MS_PER_DAY)&&(!n.max||e<=n.max)?n.transformTimeValue(e):e:null}isTimeValue(e){return e&&!0!==e&&"entered"!==e}transformTimeValue(e){const t=this,{keepTime:n}=t;if(e=us.clone(e),n)if(t.isTimeValue(n)){const i=us.parse(n,t.timeFormat);us.copyTimeValues(e,i)}else!0===n&&(t._isPickerInput||t.inputting)&&us.isValidDate(t.value)&&us.copyTimeValues(e,t.value);else us.clearTime(e,!1);return e}changeMin(e){return this.transformDateValue(e,!1)}updateMin(e){const{input:t,_picker:n}=this;t&&(null==e?t.removeAttribute("min"):t.min=e),n&&(n.minDate=e),this.syncInvalid()}changeMax(e){return this.transformDateValue(e,!1)}updateMax(e){const{input:t,_picker:n}=this;t&&(null==e?t.removeAttribute("max"):t.max=e),n&&(n.maxDate=e),this.syncInvalid()}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:us.weekStartDay}updateWeekStartDay(e){this._picker&&(this._picker.weekStartDay=e)}changeValue(e,t){const n=this,i=n.transformDateValue(e),r=n.L("L{invalidDate}")(us.format(xp,n.format));if(!e||i){if(n.clearError(r),n.hasChanged(t,i))return super.changeValue(i,t);n.inputting||n.syncInputFieldValue()}else n.inputting&&!n.validateOnInput||n.setError(r)}updateValue(e,t){const n=this._picker;n&&(n.value=e,this.inputting||(n.activeDate=e)),super.updateValue(e,t)}changeStep(e,t){const n=typeof e;return e?("number"===n?e={magnitude:Math.abs(e),unit:t?t.unit:"day"}:"string"===n&&(e=us.parseDuration(e)),e&&e.unit&&e.magnitude?(e.magnitude<0&&(e={magnitude:-e.magnitude,unit:e.unit}),e):void 0):null}updateStep(e){this.element.classList[e?"remove":"add"]("b-no-steppers"),this.syncInvalid()}hasChanged(e,t){return null!=e&&e.getTime&&null!=t&&t.getTime&&(!this.keepTime||this.isTimeValue(this.keepTime))?!us.isEqual(us.clearTime(e),us.clearTime(t)):super.hasChanged(e&&e.getTime(),t&&t.getTime())}get inputValue(){const e=this.value;return e?us.format(e,this.format):""}updateFormat(){this.isConfiguring||this.syncInputFieldValue(!0)}updateLocalization(){super.updateLocalization(),this.syncInputFieldValue(!0)}internalOnKeyEvent(e){var t;if(super.internalOnKeyEvent(e),"keydown"===e.type){const n=this;let i;switch(e.virtualKey){case"Enter":n.isValid&&(null===(t=n.picker)||void 0===t||t.hide());break;case"ArrowLeft":(n.caretAtStart||n.selectedAll)&&(i=-1);break;case"ArrowRight":(n.caretAtEnd||n.selectedAll)&&(i=1);break;case"NumpadAdd":i=1;break;case"NumpadSubtract":i=-1}i&&n.step&&(n.stepDate(i),n.selectAll(),e.preventDefault())}}}Rp.initClass(),Rp._$name="DateField";const Tp=Array.from(Array(24)).map(((e,t)=>({id:t,text:String(t+100).slice(1)}))),Mp=Array.from(Array(60)).map(((e,t)=>({id:t,text:String(t+100).slice(1)})));class Ip extends nh{static $name="TimePicker";static type="timepicker";static configurable={floating:!0,layout:"hbox",defaults:{type:"list",displayField:"id",itemTpl(e){const t=e.id,n="hour"!==this.ref||this.owner.is24Hour||t?t:12;return String(n+100).slice(1)},itemCls:"b-timepicker-item",itemsFocusable:!1,scrollable:{overflowY:"hidden-scroll"},onSelectionChange:"up.onSelectionChange",navigator:{activateOnMouseover:!0}},items:{hour:{items:Tp},minute:{items:[]},second:{hidden:!0,items:Mp}},step:{magnitude:5,unit:"m"},autoShow:!1,trapFocus:!0,value:{$config:{equal:"date"},value:null},format:null,max:null,min:null,is24Hour:{$config:"lazy",value:null},initialValue:null};alignTo(...e){const{widgetMap:t}=this,{minute:n,second:i}=this.owner.input;return this.getConfig("is24Hour"),this.minimizeHeight&&(t.hour.maxHeight=t.second.maxHeight=t.minute.height),t.minute[n?"show":"hide"](),t.second[i?"show":"hide"](),super.alignTo(...e)}updateIs24Hour(e){this.widgetMap.hour.store.filter((t=>!!e||t.id<12))}updateStep(e){e=us.as("m",e.magnitude,e.unit);const t=[];for(let n=0;n<60;n+=e)t.push({id:n,text:String(100+n).slice(1)});this.widgetMap.minute.store.data=t}onSelectionChange({source:e,selected:[t]}){const n=this;n._isUserAction=e._isUserAction,e.navigator.activeItem=t,n.updatingValue||n.owner.input.setSubFieldValue(e.ref,t.id),n._isUserAction=!1}triggerTimeChange(e){this.trigger("timeChange",{time:e})}updateInitialValue(e){this.value=e}changeValue(e){return e&&(e="string"==typeof e?us.parse(e,this.format):e),e??us.getTime(0)}updateValue(e){const t=this,{hour:n,minute:i,second:r}=t.widgetMap,s=e.getHours(),o=t.is24Hour?s:s%12,a=e.getMinutes(),l=e.getSeconds();t.updatingValue=!0,n.navigator.activeItem=new Number(o),n.select(o,!0),i.navigator.activeItem=new Number(a),i.select(a,!0),r.navigator.activeItem=new Number(l),r.select(l,!0),t.updatingValue=!1,i.store.filter(),r.store.filter(),t.isVisible&&t.triggerTimeChange(e)}changeMin(e){return"string"==typeof e?us.parse(e,this.format):e}updateMin(e){const{hour:t,minute:n,second:i}=this.widgetMap,{owner:r,is24Hour:s}=this;if(e){const o=e.getHours(),a=e.getMinutes(),l=e.getSeconds();t.store.filter({id:"min-filter",filterBy:({id:e})=>(!s&&r.value.getHours()>=12&&(e+=12),e>=o)}),n.store.filter({id:"min-filter",filterBy:({id:e})=>r.value.getHours()!==o||e>=a}),i.store.filter({id:"min-filter",filterBy:({id:e})=>{const{value:t}=r;return 60*t.getHours()+t.getMinutes()>60*o+a||e>=l}})}else t.store.removeFilter("min-filter"),n.store.removeFilter("min-filter"),i.store.removeFilter("min-filter")}changeMax(e){return"string"==typeof e?us.parse(e,this.format):e}updateMax(e){const{hour:t,minute:n,second:i}=this.widgetMap;if(e){const r=e.getHours(),s=e.getMinutes(),o=e.getSeconds();t.store.filter({id:"max-filter",filterBy:({id:e})=>e<=r}),n.store.filter({id:"max-filter",filterBy:({id:e})=>e<=s}),i.store.filter({id:"max-filter",filterBy:({id:e})=>e<=o})}else t.store.removeFilter("max-filter"),n.store.removeFilter("max-filter"),i.store.removeFilter("max-filter")}}Ip.initClass(),Ip._$name="TimePicker";const kp=/\d+/,Fp=/\d+(\D)\d+/,Ap=["hour","minute","second"],Pp=[3600,60,1],Lp=["getHours","getMinutes","getSeconds"];class Op extends HTMLElement{static formAssociated=!0;static observedAttributes=["min","max","disabled","tabindex"];constructor(){var e;super();const t=this,n=t._root=t.attachShadow({mode:"open",delegatesFocus:!0});t.internals_=null===(e=t.attachInternals)||void 0===e?void 0:e.call(t),t.byRef=Object.create(null),n.addEventListener("keydown",t.onKeyDown.bind(t)),n.addEventListener("focusin",t.onFocusIn.bind(t)),n.addEventListener("click",t.onClick.bind(t)),n.addEventListener("input",t.onInput.bind(t)),n.addEventListener("focusout",t.onFocusOut.bind(t))}connectedCallback(){var e;const t=this;t.silentChangeValue=!0,t.owner=null===(e=t.elementData)||void 0===e?void 0:e.owner,t.createStructure(t.owner.format),t.updateValue(t._value),t.silentChangeValue=!1}ingestDate(e){let t=new Date(e);return isNaN(t)&&(t=us.parse(e,this.owner.format)),t}get is24Hour(){return this.owner.is24Hour}attributeChangedCallback(e,t,n){var i;const r=this;switch(e){case"min":r.updateMin(n);break;case"max":r.updateMax(n);break;case"label":r._label=n,null===(i=r.inputs)||void 0===i||i.forEach((e=>e.setAttribute("aria-label",n)));break;case"disabled":r.disabled=n;break;case"tabindex":r.tabIndex=Number(n)}}updateMin(e){const t=null==e?null:us.getTime(this.ingestDate(e));this.minValue=t,this.minHour=(null==t?void 0:t.getHours())||0}updateMax(e){const t=null==e?null:us.getTime(this.ingestDate(e));this.maxValue=t,this.maxHour=(null==t?void 0:t.getHours())||(this.is24Hour?23:11)}onFocusIn(e){const t=this,{target:n}=e,i=t.getAriaLabel();var r;"INPUT"===n.tagName&&(n.value=`00${n.value}`.slice(-2),null===(r=n.setSelectionRange)||void 0===r||r.call(n,0,2));t.setAttribute("aria-label",i),t._root.activeElement.setAttribute("aria-label",i),t._root.contains(e.relatedTarget)||Hi.isMouseDown()||t.focusField(0),e.stopImmediatePropagation()}onClick(e){const{target:t}=e,{owner:n}=this;t===this.ampmButton&&(n.readOnly||(t.innerText=t.innerText===us.amIndicator?us.pmIndicator:us.amIndicator,this.onValueMutated(),e.stopPropagation()))}onFocusOut({target:e}){this.onValueMutated(),this.isCleared||e===this.ampmButton||(e.value=`0${parseInt(e.value)}`.slice(-2))}onKeyDown(e){var t,n,i,r;const s=this,{subfieldIndex:o}=s,{editable:a,readOnly:l}=s.owner,{amIndicator:c,pmIndicator:d}=us,{target:u,key:h}=e;if(!(e.ctrlKey||e.cmdKey||e.metaKey||e.shiftKey&&"Tab"!==h&&1!==h.length))switch(h){case"Tab":s.inputs[e.shiftKey?0:s.inputs.length-1].focus();break;case" ":(u===s.ampmButton||l)&&e.stopImmediatePropagation();break;case"ArrowLeft":e.preventDefault(),e.stopPropagation(),o>0&&!e.altKe&&s.focusField(o-1);break;case":":if(u===s.ampmButton){e.preventDefault();break}case"ArrowRight":e.preventDefault(),e.stopPropagation(),o<s.inputs.length-1&&s.focusField(o+1);break;case"ArrowUp":e.preventDefault(),e.stopPropagation(),l||s[s.owner.pickerVisible?"decrementSubfield":"incrementSubfield"](u);break;case"ArrowDown":e.preventDefault(),e.stopPropagation(),l||s[s.owner.pickerVisible?"incrementSubfield":"decrementSubfield"](u);break;case"0":case"1":case"2":case"3":case"4":case"5":case"6":case"7":case"8":case"9":case"Backspace":case"Delete":a&&!l||e.preventDefault();break;case"Escape":break;case null==c||null===(t=c[0])||void 0===t?void 0:t.toLocaleLowerCase():case null==c||null===(n=c[0])||void 0===n?void 0:n.toLocaleUpperCase():if(!l&&!s.is24Hour){e.preventDefault(),s.ampmButton.innerText=c,s.onValueMutated();break}case null==d||null===(i=d[0])||void 0===i?void 0:i.toLocaleLowerCase():case null==d||null===(r=d[0])||void 0===r?void 0:r.toLocaleUpperCase():if(e.preventDefault(),!l&&!s.is24Hour){e.preventDefault(),s.ampmButton.innerText=d,s.onValueMutated();break}default:e.preventDefault()}}onInput({target:e,data:t}){const n=this;let{value:i}=e;if((null==t?void 0:t.length)>1&&!isFinite(i)){var r;i=e.value=(null===(r=n.value)||void 0===r?void 0:r.getHours())||"00"}else{if(1===i.length||2===i.length&&1===e.selectionStart&&1===e.selectionEnd)return void e.setSelectionRange(1,2);if(i){if(2===e.selectionEnd){const{subfieldIndex:e}=n;e<n.inputs.length-1&&n.focusField(e+1)}}else i=e.value="00",e.setSelectionRange(0,2)}e!==n.hour||"00"!==i||n.is24Hour||(n.ampmButton.innerText=us.amIndicator),n.activeElement=e,n.onValueMutated(),n.activeElement=null}decrementSubfield(e){var t;const{subfieldIndex:n,step:i,isPM:r}=this;if(e===this.ampmButton)e.innerText=r?us.amIndicator:us.pmIndicator;else{const t=this.getSubFieldValue(n),r=i<Pp[n-1]&&i>Pp[n+1]?i/Pp[n]:1,s=Math.floor(t/r)*r-r;0!==n||this.is24Hour||12!==t||(this.ampmButton.innerText=us.amIndicator),e.value=s}this.onValueMutated(),null===(t=e.setSelectionRange)||void 0===t||t.call(e,0,2)}incrementSubfield(e){var t;const{subfieldIndex:n,step:i,is24Hour:r,isPM:s}=this;if(e===this.ampmButton)e.innerText=s?us.amIndicator:us.pmIndicator;else{const e=this.inputs[n],t=this.getSubFieldValue(n),o=i<Pp[n-1]&&i>Pp[n+1]?i/Pp[n]:1,a=Math.floor(t/o)*o+o;if(0!==n||this.is24Hour||11!==t||(this.ampmButton.innerText=us.pmIndicator),0===n){if((s&&!r?t+12:t)===(this.maxHour||23))return}e.value=a}this.onValueMutated(),null===(t=e.setSelectionRange)||void 0===t||t.call(e,0,2)}createStructure(e=this.owner.format){var t;const n=this,{_root:i,tabIndex:r,is24Hour:s,silentChangeValue:o}=n,{amIndicator:a}=us,l=new Date(1970,0,1,1,2,3),c=us.format(l,e).trim(),d=n.delimiter=null===(t=c.match(Fp))||void 0===t?void 0:t[1],u=[...c.matchAll(new RegExp(`\\d+${d?`|\\${d}`:""}|${a}|[^\\${d}\\d]+`,"g"))].map((e=>e[0])),h=[];n.names=[],n.labelElId=`${n.owner.id}-label-element`,n.silentChangeValue=!0,null!=r&&n.setAttribute("tabIndex",r);let g,m=0;for(let e=0,t=0,{length:i}=u;e<i;e++){const i=u[e],r=e?59:s?23:11;i.trim()===a?(g=!0,n.names.push(`${us.amIndicator}/${us.pmIndicator}`),h.push({tag:"button","aria-label":n.getAriaLabel(m),reference:"ampmButton",id:"am-pm",type:"button",text:a,dataset:{subfieldIndex:m++}})):i.match(kp)?(n.names.push(us.getLocalizedNameOfUnit(Ap[t])),h.push({tag:"input","aria-label":n.getAriaLabel(m),id:Ap[t],reference:Ap[t++],size:2,maxlength:2,minlength:2,dataset:{subfieldIndex:m++,max:r}})):i===d?h.push({tag:"span",text:d,reference:"delimiter"}):h.push({reference:"junk",tag:"span",text:i.replaceAll(" "," ")})}"delimiter"===h[h.length-1].reference&&h.length--,s||g||(n.names.push(`${us.amIndicator}/${us.pmIndicator}`),h.push({tag:"button",reference:"ampmButton",id:"am-pm",type:"button",text:a,dataset:{subfieldIndex:m++}})),n.silentChangeValue=o,h.push({tag:"style",text:"\n        :host {\n            display:flex\n        }\n        * {\n            font-size:inherit;\n            font-family:inherit;\n            color:inherit;\n            background-color:inherit\n        }\n        input,button {\n            padding:0;\n            margin:0;\n            border:0 none;\n            outline:0 none;\n            background-color:var(--timefield-input-background-color);\n            text-align:center\n        }\n        input {\n            width:2ch;\n        }\n        #am-pm {\n            margin-inline:5px\n        }\n        #am-pm:focus-visible {\n            outline:none;\n            background-color:var(--timefield-button-background-color)\n        }"}),yc.sync({targetElement:i,refOwner:n,domConfig:{onlyChildren:!0,children:h}}),n.inputs=[...i.querySelectorAll("input")],n.minute||(n.owner.step="1 h"),s?n.ampmButton=null:n.inputs.push(n.ampmButton)}attachRef(e,t){this.byRef[e]=this[e]=t}detachRef(e){this[e]=null,delete this.byRef[e]}getAriaLabel(e=this.subfieldIndex){const{owner:t}=this;return`${t.ariaLabel||t.label||""} ${this.innerText}${null!=e?` - ${this.names[e]}`:""}.`}getSubFieldValue(e){const{date:t}=this;return t?t[Lp[e]]():0}setSubFieldValue(e,t,n){(e="number"==typeof e?this.inputs[e]:"string"==typeof e?this[e]:e)&&(t<10&&(e!==this.activeElement||2===e.value.length)&&(t=`0${t}`),e.value!=t&&(e.value=t,n||this.onValueMutated()))}set value(e){const{_value:t}=this;e=this._value=e?this.ingestDate(e):null,this.isConnected&&e-t&&this.updateValue(e,t)}updateValue(e,t=null){if(Number(e)!=Number(t)){var n;const i=this,{ampmButton:r}=i,s=i.getAriaLabel();if(e){const{hour:t,minute:n,second:s}=i,o=e.getHours();i.is24Hour?i.setSubFieldValue(t,o,!0):(r.innerText=o>11?us.pmIndicator:us.amIndicator,i.setSubFieldValue(t,o>12?o%12:o,!0)),n&&i.setSubFieldValue(n,e.getMinutes(),!0),s&&i.setSubFieldValue(s,e.getSeconds(),!0)}else i._value=us.clearTime(t),i.inputs.forEach((e=>e.value="")),r&&(r.innerText=us.amIndicator);i.setAttribute("value",us.format(e,i.owner.format)),null===(n=i._root.activeElement)||void 0===n||n.setAttribute("aria-label",s),i.setAttribute("aria-label",s),i.silentChangeValue||i.owner.sycingInputFieldValue||i.dispatchEvent(new InputEvent("change"))}}onValueMutated(){const e=this,{date:t,minValue:n,maxValue:i}=e,r=t?new Date(t):null;t&&(n&&us.getTime(r)<us.getTime(n)?(r.setHours(n.getHours(),n.getMinutes(),n.getSeconds()),e._value=null):i&&us.getTime(r)>us.getTime(i)&&(r.setHours(i.getHours(),i.getMinutes(),i.getSeconds()),e._value=null)),e.value=r}set disabled(e){e=Boolean(e),this._disabled!==e&&(this._disabled=e,e?this.setAttribute("disabled",!0):this.removeAttribute("disabled"))}set tabIndex(e){this._tabIndex=e}get tabIndex(){return this._tabIndex}get subfieldIndex(){const{activeElement:e}=this.shadowRoot;return e&&parseInt(e.dataset.subfieldIndex)}get isPM(){var e;return this.is24Hour?parseInt(this.hour.value||0)>11:(null===(e=this.ampmButton.firstChild)||void 0===e?void 0:e.data)===us.pmIndicator}get value(){return this.date}get innerText(){return us.format(this.silentChangeValue?this._value:this.date,this.owner.format)||""}get date(){var e,t,n;const i=this,{_value:r}=i;if(!i.isConnected)return r||null;if(i.isCleared)return null;const s=null==i._value?[]:[i._value],o=new Date(...s),a=parseInt((null===(e=i.hour)||void 0===e?void 0:e.value)||0),l=parseInt((null===(t=i.minute)||void 0===t?void 0:t.value)||0),c=parseInt((null===(n=i.second)||void 0===n?void 0:n.value)||0);let d=a;if(!i.is24Hour){var u;const e=(null===(u=i.ampmButton.firstChild)||void 0===u?void 0:u.data)===us.pmIndicator;12!==a||i.isPM?a<12&&e&&(d+=12):d=0}return o.setHours(d,l,c,0),o}get rawDate(){var e,t,n;const i=new Date(this._value);return i.setHours(parseInt((null===(e=this.hour)||void 0===e?void 0:e.value)||0),parseInt((null===(t=this.minute)||void 0===t?void 0:t.value)||0),parseInt((null===(n=this.second)||void 0===n?void 0:n.value)||0)),i}get isCleared(){var e;return Boolean(!(null!==(e=this.inputs)&&void 0!==e&&e.map((e=>e.value.trim())).join("")))}focusField(e){const t=this.inputs[e];var n;t&&(t.focus(),null===(n=t.setSelectionRange)||void 0===n||n.call(t,0,2))}}"undefined"==typeof customElements||customElements.get("bry-time")||customElements.define("bry-time",Op);class $p extends wm{static $name="TimeField";static type="timefield";static alias="time";static configurable={inputElementTag:"bry-time",picker:{type:"timepicker",scrollAction:"realign",align:{align:"t0-b0",minHeight:200,axisLock:!0,matchSize:"min"}},role:"textbox",format:"LT",triggers:{expand:{align:"end",handler:"onTriggerClick",key:" ",compose:()=>({children:[{class:{"b-icon-clock-live":1}}]})},back:{align:"start",cls:"b-icon b-icon-angle-left b-step-trigger",key:"Shift+ArrowDown",handler:"onBackClick"},forward:{align:"end",cls:"b-icon b-icon-angle-right b-step-trigger",key:"Shift+ArrowUp",handler:"onForwardClick"}},min:null,max:null,step:"5m",stepTriggers:{$config:null,default:!0},value:{$config:{equal:"date"},value:null},keepDate:!0};static delayable={syncInvalid:{type:"buffer",delay:300}};get inputElement(){const e=super.inputElement;return e.tag="bry-time",e.label=this.label,e.elementData={owner:this},e}changePicker(e,t){const n=this,i=n.pickerWidth||(null==e?void 0:e.width);return Ip.reconfigure(t,e,{owner:n,defaults:{step:n.step,value:n.value,forElement:n.pickerAlignElement,owner:n,is24Hour:n.is24Hour,align:{matchSize:null==i,anchor:n.overlayAnchor,target:n[n.pickerAlignElement]},width:i,onTimeChange({source:e,time:t}){n._isUserAction=!0,e._isUserAction&&e.hide(),n.value=t,n.min&&!n.is24Hour&&n._picker.widgetMap.hour.store.filter(),n._isUserAction=!1}}})}selectAll(){}syncInputFieldValue(...e){const t=this;t.sycingInputFieldValue=!0,super.syncInputFieldValue(...e),t.sycingInputFieldValue=!1,t.syncInvalid(),t.pickerVisible&&(t.picker.value=t.value)}get inputValue(){return this._value}get needsInputSync(){return String(this.input[this.inputValueAttr])!==String(this.inputValue??"")}syncInputReadOnly(){this.getConfig("readOnly"),this.inputReadOnly=this._readOnly}onBackClick(){const e=this,{min:t}=e;if(!e.readOnly&&e.value){const n=us.add(e.value,-1*e.step.magnitude,e.step.unit);(!t||t.getTime()<=n)&&(e.value=n)}}onForwardClick(){const e=this,{max:t}=e;if(!e.readOnly&&e.value){const n=us.add(e.value,e.step.magnitude,e.step.unit);(!t||t.getTime()>=n)&&(e.value=n)}}get isValid(){const e=this;e.clearError("L{minimumValueViolation}",!0),e.clearError("L{maximumValueViolation}",!0);let t=e.input.date;if(t){if(t=us.getTime(t),e._min&&us.getTime(e._min)>t)return e.setError("L{minimumValueViolation}",!0),!1;if(e._max&&us.getTime(e._max)<t)return e.setError("L{maximumValueViolation}",!0),!1}return super.isValid}internalOnChange(e,...t){const n=this,i=n.input.date;i&&isNaN(i)||(n.clearError("L{invalidTime}"),n.inputting=!0,n._value=i,n.pickerVisible&&(n.picker.value=i),super.internalOnChange(e,...t),n.inputting=!1)}internalOnKeyEvent(e){if(this.pickerVisible&&("Escape"===e.key&&(this.value=this.pickerValueOnShow),"Enter"===e.key))return this.hidePicker(),void e.preventDefault();super.internalOnKeyEvent(e)}hasChanged(e,t){return null!=e&&e.getTime&&null!=t&&t.getTime?this.keepDate?e-t!=0:!us.isSameTime(e,t):super.hasChanged(e,t)}showPicker(){const e=this,{picker:t,value:n}=e;e.readOnly||(t.value=null,t.format=e.format,super.showPicker(),t.value=e.pickerValueOnShow=n,t.max=e.max,t.min=e.min,n||(e.value=t.value))}transformTimeValue(e){null!=e&&("string"==typeof e?(e=us.parse(e,this.format),this.keepDate&&e&&this.value&&(e=us.copyTimeValues(new Date(this.value),e))):e=new Date(e),us.isValidDate(e)?this.keepDate||(e=us.getTime(e)):e=null);const t={value:e};return this.trigger("transformTimeValue",t),e=t.value}changeMin(e){return this.transformTimeValue(e)}updateMin(e){const{input:t}=this;t&&(null==e?t.removeAttribute("min"):t.setAttribute("min",e)),this.syncInvalid()}changeMax(e){return this.transformTimeValue(e)}updateMax(e){const{input:t}=this;t&&(null==e?t.removeAttribute("max"):t.setAttribute("max",e)),this.syncInvalid()}changeValue(e,t){const n=this,i=n.transformTimeValue(e);if(e&&!i||n.isRequired&&""===e)n.setError("L{invalidTime}");else{if(n.clearError("L{invalidTime}"),n.hasChanged(t,i))return super.changeValue(i,t);n.inputting||n.syncInputFieldValue(!0)}}updateValue(e,t){const{expand:n}=this.triggers;this.syncInputFieldValue(!0),n&&e&&(n.element.firstElementChild.style.animationDelay=-(60*e.getHours()+e.getMinutes())/10+"s"),super.updateValue(e,t)}changeStep(e,t){var n,i;const r=typeof e;return e?("number"===r?e={magnitude:Math.abs(e),unit:t?t.unit:"hour"}:"string"===r&&(e=us.parseDuration(e)),null!==(n=e)&&void 0!==n&&n.unit&&null!==(i=e)&&void 0!==i&&i.magnitude?(e.magnitude<0&&(e={magnitude:-e.magnitude,unit:e.unit}),e):void 0):{magnitude:5,unit:"minute"}}updateStep(e){const{_picker:t}=this;this.input.step=e&&us.as("s",e.magnitude,e.unit),t&&us.as("m",e)<30&&(t.step=e),this.syncInvalid()}get is24Hour(){return us.is24HourFormat(this.format)}updateFormat(e,t){const n=this;if(!n.isConfiguring){n._format=t;const{input:i}=n,{value:r}=i;n._format=e,n.sycingInputFieldValue=!0,i.createStructure(e),i.updateValue(r,NaN),n.syncInputFieldValue(!0),n.sycingInputFieldValue=!1}}updateLocalization(){super.updateLocalization(),this.input.isConnected&&this.input.createStructure(),this.syncInputFieldValue(!0)}}$p.initClass(),$p._$name="TimeField";var _p=e=>class extends(e.mixin(zh)){static configurable={altFormats:["YYYY-MM-DD"],dateFieldDefaults:{type:"datefield",autoSelect:!0,picker:null,step:"1d",internalListeners:{change:"up.onDateFieldChange"},triggers:{expand:null,back:{align:"end",weight:101}}},fieldEndDate:{ref:"fieldEndDate",cls:"b-end-date",weight:40},fieldStartDate:{ref:"fieldStartDate",cls:"b-start-date",weight:30,internalListeners:{focusIn:"up.onStartDateFocusIn",focusOut:"up.onStartDateFocusOut"}},dateStepTriggers:null,format:"ddd, MMM D",keyMap:{ArrowDown:"stepDown",ArrowUp:"stepUp","Ctrl+ArrowDown":"stepDownLarge","Ctrl+ArrowUp":"stepUpLarge"},pickingStartDate:null,stepLarge:"1 month",stepSmall:"7 days",validateDateOnly:!0,value:{$config:{type:"date[]",formats:["format","altFormats"]}}};static fenced={syncValue:!0};static prototypeProperties={_lastValue:null};get dateFieldDefaults(){return U.merge({format:this.format},this._dateFieldDefaults)}configureDateField(e,t,n){const i=this,{dateStepTriggers:r}=i;return Rp.reconfigure(t,e,{owner:i,defaults:U.assign({stepTriggers:!0===r||"both"===r||r===n},i.dateFieldDefaults)})}changeFieldEndDate(e,t){return this.configureDateField(e,t,"end")}updateFieldEndDate(e){var t;e&&(null===(t=this.dateFieldContainer)||void 0===t||t.add(e))}changeFieldStartDate(e,t){return this.configureDateField(e,t,"start")}updateFieldStartDate(e){var t;e&&(null===(t=this.dateFieldContainer)||void 0===t||t.add(e))}updateFormat(e){this.isConstructing||(this.fieldEndDate.format=e,this.fieldStartDate.format=e)}updatePickingStartDate(e){this.element.classList.toggle("b-picking-start-date",Boolean(e))}updateValue(e,t){var n;null===(n=super.updateValue)||void 0===n||n.call(this,e,t),this.syncValue("value",e)}stepDown(e){this.adjustByKey(e,this.stepSmall)}stepUp(e){this.adjustByKey(e,"-"+this.stepSmall)}stepDownLarge(e){this.adjustByKey(e,this.stepLarge)}stepUpLarge(e){this.adjustByKey(e,"-"+this.stepLarge)}adjustByKey(e,t){const n=this,{_isUserAction:i}=n,{target:r}=e,s=[n.fieldStartDate,n.fieldEndDate],o=((r===s[0].input?1:r===s[1].input&&2)||0)-1,a=s[o],l=[s[0].value,s[1].value],c=null==l[0]||null==l[1];l[o]=us.add(l[o]??n.defaultDate(o,l),t),l[1-o]=l[1-o]??l[o],l[1]<l[0]&&(l[1-o]=l[o]),n.checkValid(l)&&(n._isUserAction=!0,c?n.value=l:(s[0].value=l[0],s[1].value=l[1]),n._isUserAction=i),a.selectAll(),e.preventDefault()}checkMinMax(e=this.value){const{maxDate:t,minDate:n,validateDateOnly:i}=this;let r,s,o=0;if(e&&(n||t))for(r of(s=Array.isArray(e)?e:[e],s))if(r=i?us.clearTime(r):r,o=n&&r<n?-1:t&&r>t?1:0,o)break;return o}checkValid(e=this.value){return!this.checkMinMax(e)}defaultDate(e,t){const{minDate:n,maxDate:i}=this,r=us.clearTime(new Date);return r<n||r>i?n:r}hasChanged(e,t){return!U.isEqual(e,t)}onDateFieldChange({source:e,userAction:t}){const n=this,{fieldEndDate:i,fieldStartDate:r,_isUserAction:s}=n;n._isUserAction=t||s,n.syncValue(e.ref,[r.value,i.value]),n._isUserAction=s}onStartDateFocusIn(){this.pickingStartDate=!0}onStartDateFocusOut(e){this.pickingStartDate=!1}syncValue(e,t=this.value){const n=this;"fieldEndDate"!==e&&(n.fieldEndDate.value=t&&t[1]),"fieldStartDate"!==e&&(n.fieldStartDate.value=t&&t[0]),"value"!==e&&(n.value=t),!n.isConstructing&&n.hasChanged(n._lastValue,t)&&n.checkValid(t)&&n.triggerChange(),n._lastValue=t}get widgetClass(){}};const{isArray:jp}=Array,Bp=e=>12*e.getFullYear()+e.getMonth(),Vp=/material/i;class Hp extends(Jm.mixin(zh)){static $name="MultiDatePicker";static type="multidatepicker";static configurable={configureSlot:"configureDatePicker",disableReserveSlots:"inert",slots:2,baseDate:{$config:"day",value:"today"},cellRenderer:null,headerRenderer:null,weekRenderer:null,weekStartDay:null,date:{$config:"day",value:"today"},minDate:{$config:"day"},maxDate:{$config:"day"},datePickerDefaults:{type:"datepicker",activeDate:null,animateTimeShift:!1,dayNameFormat:"d1",multiSelect:"range",trapFocus:!1,internalListeners:{selectionChange:"up.onDatePickerSelectionChange"},tbar:{items:{prevMonth:{onAction:"up.onPrevMonthClick"},nextMonth:{onAction:"up.onNextMonthClick"},fields:{items:{monthField:{disabled:!0},yearButton:{disabled:!0}}}}},yearPicker:{internalListeners:{select:"up.onYearPickedMulti"}}},includeYear:e=>!e.getMonth(),items:{prevButton:{type:"button",positionable:"before",cls:"b-multidatepicker-nav-button b-multidatepicker-prev-button b-icon b-icon-previous",onAction:"up.onPrevMonthClick",hideMode:"opacity"},nextButton:{type:"button",positionable:"after",cls:"b-multidatepicker-nav-button b-multidatepicker-next-button b-icon b-icon-next",onAction:"up.onNextMonthClick",hideMode:"opacity"}},multiSelect:null,navButtons:!0,selection:{$config:"day[]"}};static fenced={syncSelection:!0};get datePickers(){return this.items.filter((e=>e.isDatePicker))}compose(){var e;const{navButtons:t}=this;return{class:{"b-multidatepicker-nav-buttons":t,[`b-multidatepicker-nav-${!0===t?Vp.test((null===(e=ki.getThemeInfo())||void 0===e?void 0:e.name)||"")?"floating":"inline":t}`]:t}}}onInternalPaint(e){if(e.firstPaint){const e=this,{date:t}=e;t&&e.unanimated((()=>{e.scrollPos=e.posFromIndex(e.indexFromDate(t))}))}super.onInternalPaint(e)}applyDate(e,t,n){var i;const r=this,s=null==t?void 0:t.containsFocus,{_isUserAction:o}=r;let{selection:a}=r,l=s?n:t;!a||s&&e>=a[1]?(l=n,a=[e,e]):s?a=[e,a[1]||e]:e<a[0]?(l=n,a=[e,a[1]||e]):a=[a[0]||e,e],null===(i=l)||void 0===i||i.focus(),r._isUserAction=!0,r.selection=a,r._isUserAction=o}changeIncludeYear(e){return"number"==typeof e&&(e=[e]),jp(e)?t=>e.includes(t.getMonth()+1):e}configureDatePicker(e,t,n){const{includeYear:i}=t,r=us.add(t.baseDate,e,"month");let s={date:r,activeDate:null,includeYear:i(r),multiSelect:t.multiSelect,selection:t.selection,weekStartDay:t.weekStartDay};return n||(s=Ep.mergeConfigs(t.datePickerDefaults,s,{cellRenderer:t.cellRenderer,headerRenderer:t.headerRenderer,weekRenderer:t.weekRenderer})),s}ensurePlan(e){return us.isDate(e)&&(e={date:e}),e.date&&delete(e={...e,index:this.indexFromDate(e.date)}).date,e}getCell(e){return"string"!=typeof e&&(e=us.makeKey(e)),this.element.querySelector(`[data-date="${e}"]:not(.b-other-month)`)}indexFromDate(e){return e?Bp(e)-Bp(this.baseDate):e}onDatePickerSelectionChange({selection:e,userAction:t}){if(t){const t=this,{_isUserAction:n}=t;t._isUserAction=!0,t.syncSelection("picker",e),t._isUserAction=n}}onNextMonthClick(){this.forward()}onPrevMonthClick(){this.backward()}onYearPickedMulti({source:e,value:t}){const n=e.up("datepicker"),{focusableElement:i}=n;null==i||i.focus({preventScroll:!0}),e.hide(),t-=n.activeDate.getFullYear(),this.go(12*t)}updateAtMax(e,t){const{nextButton:n,prevButton:i}=this.widgetMap;super.updateAtMax(e,t),n&&(n.containsFocus&&(null==i||i.focus()),n.isTabbable=!e,n.hidden=e)}updateAtMin(e,t){const{nextButton:n,prevButton:i}=this.widgetMap;super.updateAtMin(e,t),i&&(i.containsFocus&&(null==n||n.focus()),i.isTabbable=!e,i.hidden=e)}changeDate(e){return e&&us.clamp(e,this.minDate,this.maxDate)}updateDate(e){null!=e&&(this.currentIndex=this.indexFromDate(e))}updateMaxDate(){this.syncDateRange()}updateMinDate(){this.syncDateRange()}syncDateRange(){this.range=[this.minDate,this.maxDate]}updateNavButtons(e){this.detachListeners("navButtons"),!0===e&&Hi.ion({theme:()=>this.recompose(),name:"navButtons",thisObj:this})}changeRange(e,t){if(jp(e)){let t,[n,i]=e;us.isDate(n)&&(n=this.indexFromDate(n),t=!0),us.isDate(i)&&(i=this.indexFromDate(i),t=!0),t&&(e=[n,i])}return super.changeRange(e,t)}changeSelection(e,t){return e&&U.isEqual(e,t)&&(e=t),e}updateSelection(e){const t=this;t.syncSelection("selection",e),t.isConfiguring?e&&(t.date=e[0]):t.trigger("selectionChange",{selection:e,userAction:t._isUserAction})}syncSelection(e,t=this.selection){const{datePickers:n}=this;"selection"!==e&&(this.selection=t),"picker"!==e&&n.forEach((e=>e.selection=t))}}Hp.initClass(),Hp._$name="MultiDatePicker";class zp extends(Hp.mixin(_p)){static $name="DateRangePicker";static type="daterangepicker";static configurable={confirmable:null,datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}},keyMap:{delegate:"confirmable"},multiSelect:"range",selection:["today","today"],stripDefaults:{bbar:{type:"confirmationbar"}},tbar:{items:{spacer:{type:"widget",flex:1,weight:0}}}};get dateFieldContainer(){return this.tbar}changeConfirmable(e){return this.bbar=e,this.bbar}updateConfirmable(e){this.detachListeners("confirmable"),null==e||e.ion({name:"confirmable",thisObj:this,choice:"doConfirm"})}get isValid(){return this.checkValid()}configureDatePicker(e,t,n){const i=super.configureDatePicker(e,t,n);return i.selection=this.selection,i}onDatePickerBeforeDateSelect({date:e}){return this.applyDate(e,this.fieldStartDate,this.fieldEndDate),!1}doConfirm({choice:e,event:t,userAction:n}){this.trigger("confirm",{choice:e,event:t,userAction:n})}internalOnKeyDown(e){const{confirmable:t}=this;let n=null==t?void 0:t.hotKeys[e.virtualKey];n?("default"===n&&(n=t.defaultButton),n&&this.doConfirm({event:e,choice:{[n]:!0,name:n}})):super.internalOnKeyDown(e)}syncSelection(e,t=this.selection){super.syncSelection(e,t),"value"!==e&&this.syncValue("selection",t)}syncValue(e,t=this.value){var n,i;const r=this,s=(null===(n=t)||void 0===n?void 0:n[1])<(null===(i=t)||void 0===i?void 0:i[0]);let o;"fieldEndDate"===e?(o=2,s&&(t=[t[1],t[1]])):"fieldStartDate"===e&&(o=1,s&&(t=[t[0],t[0]])),o&&t&&!r.isConstructing&&r.ensureVisible(t[o-1]),"selection"!==e&&r.syncSelection("value",t),super.syncValue(e,t)}triggerChange(e,t=Boolean(this._isUserAction)){const{value:n,_lastValue:i,isValid:r}=this;this.triggerFieldChange({value:n,oldValue:i,event:e,userAction:t,valid:r})}}zp.initClass(),zp._$name="DateRangePicker";const Np=new Date;class Wp extends(wm.mixin(_p)){static $name="DateRangeField";static type="daterangefield";static alias="daterange";static configurable={inline:!0,confirmable:null,container:{},confirmableDefaults:{type:"daterangepicker",navButtons:"floating",trapFocus:!0,align:{align:"t100-t100",offset:'[data-ref="fieldEndDate"]',overlap:!0},fieldStartDate:{triggers:{expand:{align:"start",disabled:!0}}}},fieldEndDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:null}},fieldEndTime:null,fieldEndTimeDefaults:{ref:"fieldEndTime",cls:"b-end-time",weight:20},fieldStartDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:{handler:"up.onExpandPicker",align:"start"}}},fieldStartTime:null,fieldStartTimeDefaults:{ref:"fieldStartTime",cls:"b-start-time",weight:10},keepTime:null,keyMap:{ArrowDown:"onTriggerKeyDown",ArrowUp:"onKeyArrowUp",Enter:"onKeyEnter",Escape:"onKeyEscape","Shift+Backspace":"onKeyClear"},max:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},min:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},nonConfirmableDefaults:{type:"multidatepicker",align:{align:"t100-r100"},datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}}},picker:{cls:"b-daterangefield-picker",floating:!0,hideMode:"clip",multiSelect:"range",scrollAction:"realign",align:{axisLock:!0}},pickerAlignElement:"container.element",pickerCls:null,pickTime:null,stepSmall:"7 days",timeFormat:"HH:mm:ss:SSS",triggers:{expand:null},weekStartDay:null,timeFieldDefaults:{type:"timefield",autoSelect:!0,picker:{align:{align:"b0-t0"}},triggers:{expand:null}}};get dateFieldContainer(){return this.container}get innerElements(){return[]}get maxDate(){return this.max}get minDate(){return this.min}compose(){const{pickTime:e}=this;return{class:{"b-pick-time":Boolean(e)}}}updateClearable(e){const{fieldEndDate:t}=this;t.clearable=e,e&&(t.triggers.clear.handler=()=>this.clear())}updateConfirmable(){this.isConstructing||(this.picker=this._pickerConfig)}changeEndTimeField(e,t){return $p.reconfigure(t,e,{owner:this,defaults:$p.mergeConfigs(this.timeFieldDefaults,this.fieldEndTimeDefaults)})}updateEndTimeField(e){e&&this.container.add(e)}changeStartTimeField(e,t){return $p.reconfigure(t,e,{owner:this,defaults:$p.mergeConfigs(this.timeFieldDefaults,this.fieldStartTimeDefaults)})}updateStartTimeField(e){e&&this.container.add(e)}updateKeepTime(e){e=!this.pickTime&&e,this.fieldEndDate.keepTime=e,this.fieldStartDate.keepTime=e}updateMax(e){const{fieldEndDate:t,fieldStartDate:n,_picker:i}=this;t.max=e,n.max=e,i&&(i.maxDate=e),this.syncInvalid()}updateMin(e){const{fieldEndDate:t,fieldStartDate:n,_picker:i}=this;t.min=e,n.min=e,i&&(i.minDate=e),this.syncInvalid()}changePicker(e,t){const n=this,{confirmable:i,pickerAlignElement:r}=n,s=i?n.confirmableDefaults:n.nonConfirmableDefaults,o=hd.resolveType(s.type),a=o.mergeConfigs({owner:n,forElement:r,minDate:n.min,maxDate:n.max,selection:n.value,weekStartDay:n._weekStartDay,align:{anchor:n.overlayAnchor,target:r}},s,i&&{confirmable:i});return n._pickerConfig=e,U.isObject(e)&&(e=U.merge({type:a.type},e)),o.reconfigure(t,e,{owner:n,defaults:a})}updatePicker(e,t){super.updatePicker(e,t),this.detachListeners("dateRangeField.picker"),null==e||e.ion({name:"dateRangeField.picker",thisObj:this,selectionChange:"onPickerSelectionChange",confirm:"onPickerConfirm",focusIn:"onPickerFocusIn"})}updatePickerCls(e,t){var n;const i=null===(n=this.picker)||void 0===n||null===(n=n.element)||void 0===n?void 0:n.classList;t&&(null==i||i.remove(t)),e&&(null==i||i.add(e))}updatePickTime(e){let t=null,n=null;!0===e?t=n={}:e&&(e.fieldStartTime||e.fieldEndTime?(n=e.fieldStartTime,t=e.fieldEndTime):n=t=e),this.fieldEndTime=t,this.fieldStartTime=n}changeValue(e){const t=this,n=t.L("L{DateField.invalidDate}")(us.format(Np,t.format));if(!e||us.isDate(e[0])&&us.isDate(e[1]))return t.clearError(n),e;t.setError(n)}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:us.weekStartDay}updateWeekStartDay(e){this._picker&&(this._picker.weekStartDay=e)}maybeHidePicker(){if(!this.picker.isVisible||this.confirmable)return!1;this.hidePicker()}onDatePickerBeforeDateSelect({date:e}){return this.picker.applyDate(e,this.fieldStartDate,this.fieldEndDate),!1}onDateFieldChange({source:e}){const t=this,{ref:n}=e,i="fieldStartDate"===n?0:1,{pickTime:r}=t;let s,o,a,l,c;t.isConstructing||(s=e.value,o=1-i,l=t.value,s&&(r?(a=i?t.fieldStartTime:t.fieldEndTime,s=us.combineDateAndTime(s,a.value)):s=us.clearTime(s),c=[s,s],l&&(c[o]=l[o],c[1]<c[0]&&(c[o]=us.combineDateAndTime(s,c[o]),c[1]<c[0]&&(c[o]=s))),t.syncValue(n,c)))}onKeyArrowUp(e){const t=this,{picker:n}=t;if(n.isVisible)return!t.confirmable&&t.stepUp(e);t.showPicker()}onKeyClear(){this.clearable&&this.clear()}onKeyEnter(){this.maybeHidePicker()}onKeyEscape(){this.maybeHidePicker()}onExpandPicker(){this.confirmable?this.showPicker():this.togglePicker()}onPickerSelectionChange({selection:e,userAction:t}){if(!this.confirmable){const n=this,{_isUserAction:i}=n;n._isUserAction=t||i,n.syncValue("picker",e),n._isUserAction=i}}onPickerConfirm({choice:e,source:t,userAction:n}){const i=this,{_isUserAction:r}=i,s=t.containsFocus&&(t.pickingStartDate?i.fieldStartDate:i.fieldEndDate);e.ok&&(i._isUserAction=n||r,i.syncValue("picker",t.value),i._isUserAction=r),i.hidePicker(),null==s||s.focus()}onPickerFocusIn({relatedTarget:e}){const{fieldEndDate:t,fieldStartDate:n}=this.container.widgetMap,i=e===n?n:t;!this.confirmable&&i.focus()}onTriggerKeyDown(e){return this.picker.isVisible&&!this.confirmable?this.stepDown(e):super.onTriggerKeyDown(e)}focusPicker(){const{picker:e}=this,{fieldEndDate:t,fieldStartDate:n}=this.container.widgetMap,{tbar:i}=e,{fieldEndDate:r,fieldStartDate:s}=(null==i?void 0:i.widgetMap)||{},o=i?t.containsFocus&&r||s:t.containsFocus&&t||n;o.focus(),o!==e&&(e.ensureVisible({animate:!1,date:o.value}),o.selectAll())}showPicker(e){const t=this,{_picker:n}=t;t.readOnly||(n&&n.setConfig({range:[t.min,t.max],selection:t.value}),e=e||Boolean(t.confirmable),super.showPicker(e))}get isValid(){const e=this,t=e.checkMinMax();return e.clearError("L{Field.minimumValueViolation}",!0),e.clearError("L{Field.maximumValueViolation}",!0),t?(e.setError(t<0?"L{Field.minimumValueViolation}":"L{Field.maximumValueViolation}",!0),!1):super.isValid}setupLabel(e){return super.setupLabel(U.assign({for:this.fieldStartDate.input.id},e))}syncInputFieldValue(){}syncValue(e,t=this.value){var n,i;const r=this,{_picker:s}=r,o=(null===(n=t)||void 0===n?void 0:n[1])<(null===(i=t)||void 0===i?void 0:i[0]);if(null!=s&&s.isVisible&&!r.confirmable){let n;"fieldEndDate"===e?(n=2,o&&(t=[t[1],t[1]])):"fieldStartDate"===e&&(n=1,o&&(t=[t[0],t[0]])),n&&t&&!r.isConstructing&&s.ensureVisible(t[n-1])}"picker"!==e&&s&&(s.selection=t),super.syncValue(e,t)}}Wp.initClass(),Wp._$name="DateRangeField";const Up=new Date(2e3,0,1);class Gp extends mm{static $name="DateTimeField";static type="datetimefield";static alias="datetime";static configurable={timeField:{type:"timefield"},dateField:{type:"datefield",keepTime:!0,step:"1 d"},weekStartDay:null,inputTemplate:()=>"",ariaElement:"element"};doDestroy(){this.dateField.destroy(),this.timeField.destroy(),super.doDestroy()}get childItems(){return[this.dateField,this.timeField]}get fieldDefaults(){const{revertOnEscape:e,tabIndex:t}=this;return null==t?{revertOnEscape:e}:{revertOnEscape:e,tabIndex:t}}get focusElement(){return this.dateField.input}get innerElements(){return[this.dateField.element,this.timeField.element]}internalOnKeyEvent(){}updateRevertOnEscape(e){this.timeField.revertOnEscape=e,this.dateField.revertOnEscape=e}changeTimeField(e,t){return $p.reconfigure(t,e,{owner:this,defaults:this.fieldDefaults})}updateTimeField(e){const t=this;Mn.on({element:e.element,keydown:"onTimeFieldKeyDown",thisObj:t}),te.after(e,"syncInvalid",(()=>{t.timeField&&!t.updatingInvalid&&t.syncInvalid()})),e.ion({thisObj:t,change({userAction:e,value:n}){if(e&&!t.$settingValue){const e=t.dateField.value;t._isUserAction=!0,t.value=e?us.copyTimeValues(new Date(e),n||Up):null,t._isUserAction=!1}}}),t.readOnly&&(e.readOnly=!0)}changeDateField(e,t){return Rp.reconfigure(t,e,{owner:this,defaults:this.fieldDefaults})}updateDateField(e){const t=this;Mn.on({element:e.element,keydown:"onDateFieldKeyDown",thisObj:t}),te.after(e,"syncInvalid",(()=>{t.dateField&&!t.updatingInvalid&&t.syncInvalid()})),e.ion({thisObj:t,change({userAction:e,value:n}){e&&!t.$isInternalChange&&(t._isUserAction=!0,t.timeField.value=n,t.value=n,t._isUserAction=!1)},keydown({event:e}){var n;"Tab"===e.key&&!e.shiftKey&&null!==(n=t.timeField)&&void 0!==n&&n.isVisible&&e.stopPropagation()}}),t.readOnly&&(e.readOnly=!0)}updateWeekStartDay(e){this.dateField&&(this.dateField.weekStartDay=e)}changeWeekStartDay(e){var t;return"number"==typeof e?e:(null===(t=this.dateField)||void 0===t?void 0:t.weekStartDay)??us.weekStartDay}syncInputFieldValue(e=this.isConfiguring){super.syncInputFieldValue(!0);const t=this,{dateField:n,timeField:i}=t,r=n.highlightExternalChange,s=i.highlightExternalChange;e||t.highlightExternalChange||(e=!0),t.$isInternalChange=!0,n.highlightExternalChange=!1,n.highlightExternalChange=r,e&&(i.highlightExternalChange=n.highlightExternalChange=!1),i.value=n.value=t.inputValue,n.highlightExternalChange=r,i.highlightExternalChange=s,t.$isInternalChange=!1,t.syncInvalid()}onTimeFieldKeyDown(e){const t=this;if(!t.readOnly&&("Enter"===e.key||"Tab"===e.key)){const e=t.dateField.value;t._isUserAction=!0,t.value=e?us.copyTimeValues(new Date(e),t.timeField.value||Up):null,t._isUserAction=!1}}onDateFieldKeyDown(e){const t=this;"Tab"!==e.key||e.shiftKey?t.readOnly||"Enter"!==e.key||(t.value=t.dateField.value):(e.stopPropagation(),e.preventDefault(),t.timeField.focus())}updateRequired(e){super.updateRequired(e),this.timeField.required=this.dateField.required=e}updateReadOnly(e,t){super.updateReadOnly(e,t),this.isConfiguring||(this.timeField.readOnly=this.dateField.readOnly=e)}onDisabled(e){this.timeField.disabled=this.dateField.disabled=e}focus(){this.dateField.focus()}hasChanged(e,t){var n,i;return null!=e&&e.getTime&&null!=t&&t.getTime?!us.isEqual(e,t):super.hasChanged(null==e||null===(n=e.getTime)||void 0===n?void 0:n.call(e),null==t||null===(i=t.getTime)||void 0===i?void 0:i.call(t))}get isValid(){return this.timeField.isValid&&this.dateField.isValid}setError(e,t){[this.dateField,this.timeField].forEach((n=>n.setError(e,t)))}getErrors(){const e=[...this.dateField.getErrors()||[],...this.timeField.getErrors()||[]];return e.length?e:null}clearError(e,t){[this.dateField,this.timeField].forEach((n=>n.clearError(e,t)))}updateInvalid(){this.updatingInvalid=!0,this.dateField.updateInvalid(),this.timeField.updateInvalid(),this.updatingInvalid=!1}}Gp.initClass(),Gp._$name="DateTimeField";const{dockIsHorz:qp}=gu.maps,Yp={top:0,down:0,left:1,bottom:2,up:2,right:3},Kp={up:{from:"translate(0,0)",to:"translate(0,-100%)"},down:{from:"translate(0,0)",to:"translate(0,100%)"},left:{from:"translate(0,0)",to:"translate(-100%,0)"},right:{from:"translate(0,0)",to:"translate(100%,0)"}};class Xp extends(gu.mixin(nn)){static $name="PanelCollapserOverlay";static type="overlay";static get configurable(){return{autoCloseDelay:1e3,autoClose:!0,revealing:{value:null,$config:null,default:!1},recollapseTool:{type:"collapsetool",cls:"b-recollapse",collapsify:"overlay",handler(){var e;null===(e=this.collapsible)||void 0===e||e.toggleReveal()}}}}static get delayable(){return{doAutoClose:0}}doAutoClose(){this.toggleReveal(!1)}updateAutoCloseDelay(e){const{doAutoClose:t}=this;(t.suspended=null==e||e<0)||(t.delay=e,t.immediate=!e)}changeRecollapseTool(e){const t=this,{panel:n}=t;if(t.isConfiguring||t.isDestroying||!n||n.isDestroying)return e;n.tools={recollapse:e}}beforeCollapse(e){if(!1===super.beforeCollapse(e))return!1;this.panel.revealed&&(e.animation=null)}applyHeaderDock(e,t=!0){var n;null===(n=this.panel)||void 0===n||n.recompose(),super.applyHeaderDock(e,t)}collapseBegin(e){const t=this,{collapseDir:n,innerElement:i}=t,{animation:r}=e,{collapseTool:s,panel:o}=t;t.configuredWidth=o._lastWidth,t.configuredHeight=o._lastHeight,t.applyHeaderDock(!0),t.lockInnerSize(),null==s||s.element.classList.add("b-collapsed"),r&&(o.element.classList.add("b-collapsing"),r.element=i,r.transform=Kp[n],e.animation=Vd.run(r))}onComplete(e){var t,n;super.onComplete(e);const i=this,{panel:r}=i,{element:s}=r;i.autoCloseLeaveDetacher=null===(t=i.autoCloseLeaveDetacher)||void 0===t?void 0:t.call(i),i.autoCloseClickDetacher=null===(n=i.autoCloseClickDetacher)||void 0===n?void 0:n.call(i),i.doAutoClose.cancel(),"reveal"===e&&i.autoClose&&(r.containsFocus&&(i.autoCloseLeaveDetacher=Mn.on({element:s,mouseenter:e=>{i.doAutoClose.cancel()},mouseleave:e=>{i.doAutoClose()}})),i.autoCloseClickDetacher=Mn.on({element:document.body,thisObj:r,mousedown:e=>{var t;r.owns(e)||null!==(t=i.revealer)&&void 0!==t&&t.contains(e.target)||null==i.autoCloseDelay||i.doAutoClose.now()}})),i.hasPainted||"collapse"!==e||i.innerElement.offsetHeight}expandBegin(e){const t=this,{animation:n}=e,{collapseDir:i,collapseTool:r,innerElement:s,panel:o}=t,{element:a}=o;a.classList.remove("b-collapsed","b-collapsing"),t.restoreConfiguredSize(),t.lockInnerSize(!1),t.lockInnerSize(),null==r||r.element.classList.remove("b-collapsed"),n&&(a.classList.add("b-collapsed","b-expanding"),n.element=s,n.transform={from:Kp[i].to,to:Kp[i].from},e.animation=Vd.run(n))}expandEnd(e){super.expandEnd(e);const{panel:t}=this;e.completed&&(t.revealed=!1),t.element.classList.remove("b-expanding")}expandRevert(e){super.expandRevert(e),this.panel.element.classList.add("b-expanding")}get innerElement(){return this.panel.overlayElement}get innerSizeElement(){return this.panel.element}get toolsConfig(){const{direction:e}=this,t=super.toolsConfig,n=this.recollapseTool;return n?{...t,recollapse:n&&U.assign({direction:e.toLowerCase()},n)}:t}lockInnerSize(e=!0){const t=this,{panel:n}=t,i=e&&n.rectangle(),r=e?[0,0,0,0]:"",s=super.lockInnerSize(e);return e&&(r[Yp[t.collapseDir]]=`-${i[t.collapseDim]+10}px`),n.element.style.clipPath=e?`inset(${r.join(" ")})`:"",s}onOverlayTransitionDone(e){const t=this,{panel:n}=t;e.srcElement===n.overlayElement&&t.revealing&&(t.revealing=!1,t.onComplete(n.revealed?"reveal":"unreveal"))}onRevealerClick(){this.toggleReveal()}toggleReveal(e){const{panel:t}=this,{element:n}=t;t.collapsed&&(this.revealer=ki.getActiveElement(n),null==e&&(e=!t.revealed),t.revealed!==e&&!1!==t.trigger("beforeToggleReveal",{reveal:e})&&(!e&&n.matches(":focus-within")&&t.revertFocus(!0),this.revealing=!0,t.revealed=e,n.getBoundingClientRect()))}updateRevealing(e){const t=this,{panel:n}=t,i=/left|right/i.test(t.collapseDir)?"height":"width";n&&(t.innerElement.style[i]="0px",t.innerElement.style[`min-${i}`]="100%",n.element.classList[e?"add":"remove"]("b-panel-overlay-revealing"))}wrapCollapser(e,t){var n;const i=this,{collapseDir:r,panel:s}=i,{expandedHeaderDock:o,header:a,uiClassList:l}=s,c=null===(n=s.tools)||void 0===n?void 0:n.recollapse,[d,u]=i.splitHeaderItems({as:"element",dock:i.collapseDock}),h=qp[o],g=s.hasHeader?s.title||(null==a?void 0:a.title)||" ":null;return c&&(c.direction=r),["overlayElement",{class:{...l,[`b-panel-overlay-header-${o}`]:1,[`b-panel-overlay-${r}`]:1,[`b-${h?"h":"v"}box`]:1,"b-panel-overlay":1,"b-box-center":1},listeners:{transitionend:e=>i.onOverlayTransitionDone(e),transitioncancel:e=>i.onOverlayTransitionDone(e)},children:{overlayHeaderElement:g&&{tag:"header",class:new Ht({...l,[`b-dock-${o}`]:1,"b-panel-header":1,"b-panel-overlay-header":1},null==a?void 0:a.cls),children:[...d,{reference:"overlayTitleElement",html:g,class:{...l,[`b-align-${(null==a?void 0:a.titleAlign)||"start"}`]:1,"b-header-title":1}},...u]},[e]:t}}]}}Xp.initClass(),Xp._$name="PanelCollapserOverlay";const Zp={lineNumber:0,column:0},Jp={lineNumber:Number.MAX_SAFE_INTEGER,column:Number.MAX_SAFE_INTEGER},Qp=d.isBryntumOnline(["online"]),{pathname:ef}=globalThis.location,tf=ef.endsWith("umd.html"),nf=document.querySelector("script[type=module]"),rf=ef.endsWith("module.html")||(null==nf?void 0:nf.src.includes("app.module.js"))||(!ef.includes(".html")||ef.includes("index.html"))&&Qp;class sf extends op{static $name="DemoCodeEditor";static type="democodeeditor";static configurable={mode:"vanilla",appFolder:"",collapsible:{type:Xp.type,direction:"right",autoClose:!1},collapsed:!0,preferredSources:null,monitorResize:!1,editor:{lineNumbers:"off",foldingImportsByDefault:!0,minimap:{enabled:!1},ariaLabel:"Live code editor"},tbar:{overflow:null,items:{filesCombo:{type:Tm.type,flex:"1 1 100%",monitorResize:!1,editable:!1,fields:[{name:"text"}],listItemTpl:({text:e})=>{let t="b-fa-file";switch(e.split(".").pop()){case"js":case"mjs":case"jsx":case"ts":case"mts":case"tsx":case"vue":t="b-fa-file-lines";break;case"css":case"scss":t="b-fa-palette";break;case"htm":case"html":case"json":t="b-fa-file-code"}const n=e.lastIndexOf("/")+1;return`<span class="b-editor-file-type b-fw-icon ${t}" ></span> <span class="b-editor-folder">${e.substring(0,n)}</span>${e.substring(n)}`},picker:{maxHeight:"calc(100vh * 3 / 4)"}}}},codeCache:{}};construct(e={}){super.construct(...arguments);const t=this,{rtl:n}=t;n&&(t.collapsible.direction="left"),new ph({targetSelector:".b-codeeditor",rightHandle:Boolean(n),leftHandle:!n,skipTranslate:!0,minWidth:190})}static get isModule(){return rf}get isVanilla(){return"vanilla"===this.mode}get isFramework(){return"framework"===this.mode}updateMode(){this.title='<span class="title-container"><span class="title">'+(this.isVanilla?"L{CodeEditor.editor}":"L{CodeEditor.viewer}")+"</span></span>"}static loadMonacoEditor=async e=>{if(!op.monacoLoadPromise){const t=ki.createElement({tag:"script",parent:document.head,src:`${e}monaco-editor/min/vs/loader.js`});await new Promise((e=>t.addEventListener("load",e))),await(op.monacoLoadPromise=new Promise((t=>{const n=globalThis.require;n.config({paths:{vs:`${e}monaco-editor/min/vs`}}),n(["vs/editor/editor.main"],(function(){t(globalThis.monaco)}))})))}};onCloseClick(){this.collapse()}async onFilesComboChange({value:e}){await this.loadCode(e)}async collapseBoilerplate(e){const{monacoInstance:t,editor:n}=this,{Selection:i}=t,r=[],s=e.findMatches("^import .*$",!0,!0);let o,a=!0;["baselines","children","segments","intervals","events","tasks","resources","assignments","dependencies","timeRanges","resourceTimeRanges","rows"].forEach((t=>{const n=`${t}\\s*(?:=|:)\\s*\\[`;for(o=e.findForwards(n,Zp,!0);o&&a;o=e.findForwards(n,a.range.getEndPosition(),!0))if(a=e.findForwards("\\](?:;|,)?\\s*$",o.range.getEndPosition(),!0),a){for(;a&&r.some((e=>e.containsRange(a.range)));)a=e.findForwards("\\](?:;|,)?\\s*$",a.range.getEndPosition(),!0);a&&r.push(new i(o.range.startLineNumber,1,a.range.endLineNumber+1,1))}}));let l,c=Zp;for(;l=e.findForwards("^\\s*//\\s*hide",c,!0);){const t=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?hide",{lineNumber:l.range.endLineNumber,column:0},!0);t&&r.push(new i(l.range.startLineNumber,1,t.range.endLineNumber+1,1)),c=(null==t?void 0:t.range.getEndPosition())||Jp}for(c=Zp;l=e.findForwards("^\\s*//\\s*region",c,!0);){const t=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?region",{lineNumber:l.range.endLineNumber,column:0},!0);t&&r.push(new i(l.range.startLineNumber,1,t.range.endLineNumber+1,1)),c=(null==t?void 0:t.range.getEndPosition())||Jp}s.length&&r.push(new i(1,1,s[s.length-1].range.startLineNumber+1,1));for(const e of r)n.setSelections([...n.getSelections(),e]),await n.getAction("editor.createFoldingRangeFromSelection").run()}set status(e){this.widgetMap.status.html=e}get isReadOnly(){const e=this;return e.isFramework||["html","scss","json"].includes(e.fileExt)||"js"===e.fileExt&&(e.hasImports||tf)}toggleReadOnly(){const e=this,{contentElement:t,isReadOnly:n}=e;t.classList.toggle("readonly",n),e.status=n?"Read only"+(d.isCSP?" (Restricted by Content Security Policy)":d.isChrome||d.isFirefox?"":" (try it on Chrome or Firefox)"):"Idle",e.editor.updateOptions({readOnly:n})}async loadCode(e){e=`${this.appFolder}${e}`;const t=this,{isVanilla:n}=t;let i=t.codeCache[e],r=null;if(t.filename=e,!i)try{const n=Math.floor((new Date).getTime()/36e5),r=await er.get(`${location.href.replace(/[^/]*$/,"")}${e}?${n}`);i=t.codeCache[e]=await r.text()}catch(e){i="",r=e}t.loadedCode=i,t.fileExt=e.split(".").pop();let s="plaintext";switch(t.fileExt){case"js":case"mjs":case"jsx":s="javascript";break;case"ts":case"mts":case"tsx":case"vue":s="typescript";break;case"css":s="css";break;case"scss":s="scss";break;case"htm":case"html":s="html";break;case"json":s="json"}t.language=s;const o=t.model=await t.loadText(i,s);o.findForwards=function(e,t){const n=o.findNextMatch(...arguments);if(n&&!n.range.getStartPosition().isBefore(t))return n},n&&"js"===t.fileExt&&await t.collapseBoilerplate(o),t.status=`${r?r.message:"Idle"}`,t.toggleReadOnly()}sortFileNamesWithHierarchy(e){const t=e=>{const n={};return Object.keys(e).sort(((t,n)=>{const i=null!==e[t],r=null!==e[n];return i&&!r?-1:!i&&r?1:t.localeCompare(n)})).forEach((i=>{n[i]=null!==e[i]?t(e[i]):e[i]})),n},n=(e,t="")=>{let i=[];return Object.keys(e).forEach((r=>{const s=`${t}${""!==t?"/":""}${r}`;null===e[r]?i.push(s):i=i.concat(n(e[r],s))})),i};return n(t((e=>{const t={};return e.forEach((e=>{const n=e.split("/");let i=t;n.forEach(((e,t)=>{i[e]||(i[e]=t===n.length-1?null:{}),i=i[e]}))})),t})(e)))}async initialLoadCode(){const e=this,{widgetMap:t,preferredSources:n}=e,{filesCombo:i}=t,r=i.store,s=`${e.appFolder}app.config.json`,o=(await er.get(s,{parseJson:!0})).parsedJson,a=[],l=d.isBryntumOnline("online"),c=o.source||[];if(e.isVanilla){var u;const t=null===(u=o.index)||void 0===u?void 0:u.bundles,n=t&&!(null!=t&&t.includes("module"));a.push(...c.flatMap((e=>"index.html"===e?!rf||l||n?tf?"index.umd.html":"index.html":"index.module.html":"app.js"===e?!rf&&!l||n?tf?"app.umd.js":"app.js":"app.module.js":e.endsWith(".scss")?[e,e.replace(/\.scss$/,".css")]:(rf||l)&&e.startsWith("lib/")?void 0:e)).filter(Boolean)),rf||tf||(e.hasImports=a.some((e=>["lib/","locales/"].some((t=>e.startsWith(t))))))}else c.length?a.push(...o.source):console.warn(`No source files loaded from ${s}`);i.items=e.sortFileNamesWithHierarchy(a).map((e=>({text:e,value:e})));const h=(n||[]).map((e=>r.find((t=>e.test(t.value))))).find(Boolean)||r.first;i.value=h.value,await e.loadCode(h.value),i.onChange="up.onFilesComboChange",e.toggleReadOnly(),i.readOnly=1===r.count}static get monacoCodePath(){const e=/(.*?\/)examples/.exec(document.location.href);return e?`${e[1]}examples/_shared/browser/lib/monaco-editor`:void 0}static async toggleCodeEditor(e,t,n){return!e&&(e=new sf({mode:"framework",appendTo:document.body,codePath:sf.monacoCodePath,appFolder:"../",...n}),hd.disableThrow=!0,t.icon="b-icon-spinner",await e.initialLoadCode(),t.icon="b-icon-code"),e.collapsed?(await e.expandPanel(),e.focus()):await e.collapsePanel(),e}}var of;sf.initClass(),sf._$name="DemoCodeEditor";class af extends Id{static $name="DemoHeader";static type="demoheader";static#e=zt(this,"configurable",{insertFirst:"container",appFolder:"../",cls:"demo-header",items:[{type:"container",id:"title-container",items:[{type:"container",tag:"a",id:"title",elementAttributes:{href:this.titleLink},items:[{html:(document.title??"Demo").split("-").pop().trim(),tag:"h1",tooltip:(null===(of=document.querySelector('meta[name="description"]'))||void 0===of?void 0:of.content)??""}]}]},{type:Wu.type,id:"tools",style:{border:"none",height:"2.8em"},defaults:{style:{margin:0},cls:"b-raised b-blue"},items:["->",{ref:"trialButton",type:"button",text:"Download Trial",cls:"b-green b-raised",href:"#",hidden:!0},{ref:"codeButton",type:"button",tooltip:"Click to show the code viewer",icon:"b-icon-code",onClick:"up.toggleCodeEditor",hidden:!0},{ref:"downloadButton",type:"button",tooltip:"Download this demo zip archive",icon:"b-icon-download",href:"#",hidden:!0},{ref:"fullscreenButton",type:"button",tooltip:"Full screen",icon:"b-icon-fullscreen",onClick(){bc.enabled&&(bc.isFullscreen?bc.exit():bc.request(document.body))}}]}]});construct(...e){super.construct(...e),this.setupToolbar()}static get titleLink(){const e=/(.*?\/)(examples.*?\/frameworks\/.*?)\/(build|out|dist)/.exec(document.location.href);return e?`${e[1]}examples/#example-${e[2].replace(/\//gm,"-").replace("examples-frameworks","frameworks")}`:"#"}async toggleCodeEditor(){this.codeEditor=await sf.toggleCodeEditor(this.codeEditor,this.widgetMap.tools.widgetMap.codeButton,{appFolder:this.appFolder,preferredSources:[/App\.[jt]sx?/,/\w+Config\.[jt]sx?/,/index\.[jt]sx?/]})}async setupToolbar(){const{location:e}=document,t=e.search.includes("test");if(e.href.match(/examples\/frameworks/)||t){var n,i;const r=(null===(n=e.href.match(/\/(\w+)(-trial)?\/[-\w]*examples\//))||void 0===n?void 0:n[1].toLowerCase())||"grid",{widgetMap:s}=this.widgetMap.tools,{downloadButton:o,trialButton:a}=s;Object.values(s).forEach((e=>e.hidden=!1)),a.href=`https://bryntum.com/download/?product=${r}`;const l=null===(i=await er.get(`${this.appFolder}/app.config.json`,{parseJson:!0}).catch((()=>{})))||void 0===i?void 0:i.parsedJson;null!=l&&l.zip||t?o.href=`${this.appFolder}${l.zip}`:o.hidden=!0,Gl.insertRule("body { flex-direction : row !important }"),Gl.insertRule("#container { flex: 1 !important; overflow : hidden !important }")}}}af._$name="DemoHeader";class lf extends Sm{static $name="DurationField";static type="durationfield";static alias="duration";static configurable={value:null,defaultUnit:"day",useAbbreviation:!1,allowNegative:!1,decimalPrecision:null,triggers:{spin:{type:"spintrigger"}},nullValue:null,min:null,max:null,allowedUnits:null,step:1,unit:null,magnitude:null};changeMin(e){return"string"==typeof e?new Co(e):e}changeMax(e){return"string"==typeof e?new Co(e):e}changeAllowedUnits(e){return"string"==typeof e&&(e=e.split(",")),e.length>0&&!e.includes(this.defaultUnit)&&(this.defaultUnit=e[0]),e}updateAllowedUnits(e){this.allowedUnitsRe=new RegExp(`^(${e.join("|")})$`,"i")}get inputValue(){return null==this.value?"":this.calcValue(!0).toString(this.useAbbreviation,this.decimalPrecision)}updateUnit(){this.clearError("L{invalidUnit}"),super.value=this.calcValue()}updateMagnitude(){this.clearError("L{invalidUnit}"),super.value=this.calcValue()}get unitWithDefault(){return this.unit||this.defaultUnit}roundMagnitude(e){return e&&null!=this.decimalPrecision?U.round(e,this.decimalPrecision):e}get allowDecimals(){return 0!==this.decimalPrecision}get isValid(){const e=this,t=e.input.value,n=us.parseDuration(t,e.allowDecimals,t.match(/[\p{Letter}\p{Mark}]+/giu)?void 0:e.unitWithDefault),i=!t||n&&null==n.magnitude;return e.skipValidation||super.isValid&&(i&&!e.required||!i&&(e.allowNegative||(null==n?void 0:n.magnitude)>=0))}internalOnChange(e){const t=this,n=t.value,i=t._lastValue;t.hasChanged(i,n)&&(t._lastValue=n,t.triggerFieldChange({value:n,event:e,userAction:!0,valid:t.isValid}))}onFocusOut(e){var t;return this.syncInputFieldValue(!0),null===(t=this.triggers)||void 0===t||null===(t=t.spin)||void 0===t||null===(t=t.clickRepeater)||void 0===t||t.cancel(),super.onFocusOut(e)}set value(e){const t=this;let n,i;if(t.getConfig("allowedUnits"),t.clearError("L{invalidUnit}"),"number"==typeof e||"string"==typeof e&&e.length>0&&!isNaN(e))n=Number(e),i=t.unitWithDefault;else if("string"==typeof e)if(/^\s*$/.test(e))n=null;else{const r=us.parseDuration(e,t.allowDecimals,t.unitWithDefault);r&&(!t.allowedUnitsRe||t.allowedUnitsRe.test(r.unit)?(i=r.unit,n=r.magnitude):t.setError("L{invalidUnit}"))}else e&&"unit"in e&&"magnitude"in e?(i=e.unit,n=e.magnitude):(i=null,n=null);t.magnitude===n&&t.unit==i||(t._magnitude=n,i&&(t.unit=i),super.value=t.calcValue())}okMax(e){return"number"==typeof e&&(e=new Co({unit:this.unitWithDefault,magnitude:e})),null==this.max||e<=this.max}okMin(e){return"number"==typeof e&&(e=new Co({unit:this.unitWithDefault,magnitude:e})),null==this.min||e>=this.min}get validity(){const e=this.value,t={};return null!=e&&(t.rangeUnderflow=!this.okMin(e),t.rangeOverflow=!this.okMax(e)),t.valid=!t.rangeUnderflow&&!t.rangeOverflow,t}get value(){return super.value}calcValue(e=!1){const t=this,{magnitude:n}=t;return t.unit&&null!=n||!t.clearable?new Co(e?t.roundMagnitude(n):n,t.unitWithDefault):null}hasChanged(e,t){return t&&!e||!t&&e||t&&e&&!(e.unit===t.unit&&e.isEqual(t))}get milliseconds(){return this.value?this.value.milliseconds:0}onInternalKeyDown(e){const t=this,{_isUserAction:n}=t;t._isUserAction=!0,"ArrowUp"===e.key?t.doSpinUp():"ArrowDown"===e.key&&t.doSpinDown(),t._isUserAction=n}doSpinUp(){const e=this;let{value:t}=e;if(e.readOnly)return;U.isEmpty(t)&&(t=new Co({magnitude:0,unit:this.defaultUnit}));let n=t.add(this._step);e.okMin(n)||(n=e.min),e.okMax(n)&&(e.value=n)}doSpinDown(){const e=this;let{value:t}=e;if(e.readOnly)return;U.isEmpty(t)&&(t=new Co({magnitude:0,unit:this.defaultUnit}));let n=t.add({magnitude:-this._step.magnitude,unit:this._step.unit});e.okMax(n)||(n=e.max),e.okMin(n)&&(e.allowNegative||(e.magnitude||0)>0)&&(e.value=n)}changeStep(e,t){const n=typeof e;return e?("number"===n?e={magnitude:Math.abs(e),unit:void 0}:"string"===n&&(e=us.parseDuration(e)),e&&e.unit&&e.magnitude&&e.magnitude<0&&(e={magnitude:-e.magnitude,unit:e.unit}),e):null}updateStep(e){this.element.classList.toggle("b-no-steppers",Boolean(e)),this.syncInvalid()}}lf.initClass(),lf._$name="DurationField";class cf extends Id{static $name="Editor";static type="editor";static configurable={positioned:!0,hidden:!0,layout:"fit",align:{align:"t0-t0",offset:[0,0]},hideTarget:!1,appendToTargetParent:!1,matchSize:!0,matchFont:!0,fitTargetContent:!1,inputField:"textfield",blurAction:"complete",completeKey:"Enter",cancelKey:"Escape",invalidAction:"block",completeOnChange:null,isolateFields:!0,instantUpdate:!1,floating:!1};afterConfigure(){const e=this;super.afterConfigure(),e.onTargetSizeChange=e.onTargetSizeChange.bind(e),Mn.on({element:e.element,keydown:"onEditorKeyDown",contextmenu:"stopMouseEvents",mousedown:"stopMouseEvents",mouseover:"stopMouseEvents",mouseout:"stopMouseEvents",mouseup:"stopMouseEvents",click:"stopMouseEvents",dblclick:"stopMouseEvents",thisObj:e}),e.ion({beforeHide:"beforeEditorHide",hide:"afterEditorHide"}),ir.ion({locale:"onLocaleChange",thisObj:e})}onLocaleChange(){const{inputField:e}=this;e&&!e.isDestroyed&&e.syncInputFieldValue&&e.syncInputFieldValue(!0)}render(e){const t=this.element.parentNode,[n]=this.getRenderContext(this,e);n.classList.add("b-editing"),super.render(...arguments),null!=t&&t.classList&&n!==t&&t.classList.remove("b-editing")}async startEdit(e){const t=this;if(e=U.assignIf(e,{align:t.align,hideTarget:t.hideTarget,matchSize:t.matchSize,matchFont:t.matchFont,fitTargetContent:t.fitTargetContent,focus:!0}),t.isVisible&&await t.completeEdit(),!1!==t.trigger("beforeStart",e)){var n,i,r;const{target:s,hideTarget:o,matchSize:a,matchFont:l,fitTargetContent:c,record:d,field:u=t.inputField.name,focus:h}=e,{inputField:g,appendToTargetParent:m}=t,{input:p}=g,f=ki.getStyleValue(s,"font-size"),v=ki.getStyleValue(s,"font-family");let{value:y,align:b}=e;if(d&&u&&(t.record=d,t.dataField=u,g.assignFieldValue!==hd.prototype.assignFieldValue?y=g.value:void 0===y&&(y=d.getValue(u))),m&&s.nodeType===Node.ELEMENT_NODE&&s.parentElement.appendChild(t.element),a&&(s instanceof HTMLElement&&t.updateSize(s,a),s instanceof HTMLElement&&Dc.addResizeListener(s,t.onTargetSizeChange)),p&&(l?(p.style.fontSize=f,p.style.fontFamily=v):p.style.fontSize=p.style.fontFamily=""),t.assigningValues=!0,null===(n=g.clearError)||void 0===n||n.call(g),"setValue"in g?await g.setValue(y):g.value=y,t.assigningValues=!1,"string"==typeof b&&(b={align:b}),await t.showBy({target:s,allowTargetOut:!0,...b}),c){const e=p.scrollWidth-p.clientWidth;e>0&&(t.width+=e+ki.scrollBarWidth)}h&&(null===(i=g.focus)||void 0===i||i.call(g)),s.nodeType===Element.ELEMENT_NODE&&o&&s.classList.add("b-hide-visibility"),t.editing=!0;const C=g.value;return t.trigger("start",{value:C}),Array.isArray(C)&&g.editingRecords&&null!==(r=C[0])&&void 0!==r&&r.isModel?t.oldValue=C.map((e=>e.copy(e.id))):(t.oldValue=C,Array.isArray(t.oldValue)&&(t.oldValue=t.oldValue.slice())),g.initialValue=t.oldValue,!0}return!1}async refreshEdit(){if(this.isVisible){const{record:e,dataField:t,inputField:n,owner:i}=this;if(e&&(((null==i?void 0:i.readOnly)||e.readOnly)&&this.cancelEdit(),t)){const i=e.getValue(t);U.isEqual(n.value,i)||await n.setValue(i)}}}finishEdit(){const{target:e,aligningToElement:t}=this.lastAlignSpec;t&&(e.classList.remove("b-editing"),e.classList.remove("b-hide-visibility")),this.editing=!1,this.trigger("afterEdit",{record:this.record})}onEditorKeyDown(e){var t;const n=this;switch(e.key){case n.completeKey:e.preventDefault(),e.stopImmediatePropagation(),n.completeEdit(null,e);break;case n.cancelKey:n.cancelEdit(e),e.stopImmediatePropagation()}null===(t=n.trigger)||void 0===t||t.call(n,"keyDown",{event:e})}stopMouseEvents(e){this.allowMouseEvents||e.stopPropagation()}onFocusOut(e){super.onFocusOut(e);const t=this;if(!t.isFinishing&&t.editing)switch(t.blurAction){case"cancel":t.cancelEdit(e);break;case"complete":t.completeEdit(null,e)}}async completeEdit(e,t){const n=this,{inputField:i,oldValue:r,record:s}=n,o=i.invalidAction||(!1===i.allowInvalid?"block":n.invalidAction),{value:a}=i;if(n.isVisible){if(i.isValid||"allow"===o){if(U.isEqual(a,r))return!1!==n.cancelEdit(t);{(null==t?void 0:t.key)&&t.stopPropagation();const u={inputField:i,record:s,value:a,oldValue:r};if(!(n.isFinishing=n.hasListener("beforeComplete"))||!1!==await n.trigger("beforeComplete",u)){var l;if(n.isFinishing=!1,!e)e=u.finalize||(null===(l=u.editorContext)||void 0===l?void 0:l.finalize);if(e){let t=await e(u);if(!0===t)n.onEditComplete();else{if(i.setError){const e=t||i.invalidValueError,n=()=>{r(),i.clearError(e)},r=i.ion({change:n,input:n});i.setError(e)}var c;if("block"===o)null===(c=i.focus)||void 0===c||c.call(i);else"revert"===o&&(await i.setValue(r),t=!0);t=!1}return t}return n.onEditComplete(),!0}var d;n.isFinishing=!1,null===(d=i.focus)||void 0===d||d.call(i)}}else{var u;if((null==t?void 0:t.key)&&t.preventDefault(),"block"===o)return null===(u=i.focus)||void 0===u||u.call(i),!1;if("revert"===o)return!1!==n.cancelEdit(t)}return!1}}cancelEdit(e){const t=this,{inputField:n,oldValue:i}=t,{value:r}=n;if(!t.editing||t.isFinishing||!1===t.trigger("beforeCancel",{value:r,oldValue:i,event:e}))return null==e||e.preventDefault(),!1;var s;null===(s=n.clearError)||void 0===s||s.call(n),t.isFinishing=!0,t.hide(),"Escape"===(null==e?void 0:e.key)&&e.stopImmediatePropagation(),t.trigger("cancel",{value:r,oldValue:i,event:e}),t.finishEdit(),t.isFinishing=!1}onEditComplete(){const e=this,{record:t,dataField:n,inputField:i,oldValue:r}=e;let{value:s}=i;if(!e.isFinishing){if(e.isFinishing=!0,e.hide(),t&&(!e.instantUpdate||i._outstandingUpdate)){const e=`set${V.capitalize(n)}`;!t.isFieldModified(n)||null!=t.getUnmodified(n)||null!=s&&""!==s||(s=t.meta.modified[n]),t[e]?t[e](s):t.setValue(n,s)}e.trigger("complete",{value:s,oldValue:r}),e.finishEdit(),e.isFinishing=!1}}doDestroy(){this.createdInputField&&this.inputField.destroy(),super.doDestroy()}set owner(e){this._owner=e}get owner(){return this._owner||hd.fromElement(this.element.parentNode)}changeInputField(e,t){const n=this;return t&&t.destroy(),"string"==typeof e&&(e={type:e}),e instanceof hd||(e.type||(e.type="textfield"),e=hd.create(e),n.createdInputField=!0),n.completeOnChange&&e.ion({change:"onInputFieldChange",thisObj:n}),e.parent=n,e}updateInputField(e){this.removeAll(),this.add(e)}get inputField(){return this.items[0]}onInputFieldChange(){this.containsFocus&&this.completeEdit()}onTargetSizeChange(e,t,n){t&&n&&this.updateSize(e)}updateSize(e,t=this.lastMatchSize){const n=this,i=_t.inner(e);n.width=!1===t.width?"auto":i.width-n.align.offset[0],n.height=!1===t.height?"auto":i.height,n.lastMatchSize=t}beforeEditorHide(){if(this.editing&&!this.isFinishing)return this.cancelEdit(),!1}afterEditorHide(){var e;this.positioned&&this.element.remove(),Dc.removeResizeListener(null===(e=this.lastAlignSpec)||void 0===e?void 0:e.target,this.onTargetSizeChange)}owns(...e){var t;return null!==(t=this.inputField)&&void 0!==t&&t.owns?this.inputField.owns(...e):super.owns(...e)}}cf.initClass(),cf._$name="Editor";class df{static $name="NumberHelper";static getLocalizedFormatter(e){return"currency"!==(null==e?void 0:e.style)||e.currency||(e.currency=ir.locale.NumberFormat.currency),"string"==typeof e?bo.get({locale:ir.localeCode,template:e}):null!=(null==e?void 0:e.locale)?bo.get(e):bo.get(Object.assign({},e,{locale:ir.localeCode}))}}df._$name="NumberHelper";const uf=e=>e.ctrlKey&&e.preventDefault();class hf extends mm{static $name="NumberField";static type="numberfield";static alias="number";static get configurable(){return{wrapAround:null,min:null,max:null,step:1,largeStep:0,value:null,format:"",triggers:{spin:{type:"spintrigger"}},changeOnSpin:!0,inputType:null}}construct(e){super.construct(e);const t=this;t.input.addEventListener("dblclick",(()=>{t.select()})),"number"==typeof t.changeOnSpin&&(t.bufferedSpinChange=t.buffer(t.triggerChange,t.changeOnSpin))}acceptValue(e,t){let n=!isNaN(e);if(n&&!this.hasTextSelection){n=!1;const e=this.input.value,i=parseFloat(e);e!==t&&(n=!this.acceptValue(i,e))}return n}okMax(e){return isNaN(this.max)||e<=this.max}okMin(e){return isNaN(this.min)||e>=this.min}internalOnKeyEvent(e){if("keydown"===e.type){const t=this,n=e.key;let i;if("ArrowUp"===n)t.doSpinUp(e.shiftKey),i=!0;else if("ArrowDown"===n)t.doSpinDown(e.shiftKey),i=!0;else if(!e.altKey&&!e.ctrlKey&&n&&1===n.length){const e=t.getAfterValue(n),r=t.formatter.parseStrict(e);i=!(r===t.value||"-"===e&&(isNaN(t.min)||t.min<0))&&!t.acceptValue(r,e)}"Enter"===n&&t._changedBySilentSpin&&(t.triggerChange(e,!0),t._changedBySilentSpin=!1),i&&e.preventDefault()}super.internalOnKeyEvent(e)}doSpinUp(e=!1){const t=this,n=t.formatter.is.percent?100:1,i=(e?t.largeStep:t.step)/n;if(t.readOnly)return;let r=(t.value||0)+i;t.okMin(r)||(r=t.min),t.okMax(r)?t.applySpinChange(r):t.wrapAround&&(r=t.min,t.applySpinChange(r))}doSpinDown(e=!1){const t=this,n=t.formatter.is.percent?100:1,i=(e?t.largeStep:t.step)/n;if(t.readOnly)return;let r=(t.value||0)-i;t.okMax(r)||(r=t.max),t.okMin(r)?t.applySpinChange(r):t.wrapAround&&(r=t.max-t.max%i,t.applySpinChange(r))}applySpinChange(e){const t=this;t._isUserAction=!0,!0!==t.changeOnSpin&&(t._changedBySilentSpin=!0,t.silenceChange=!0,t.bufferedSpinChange&&t.bufferedSpinChange(null,!0)),t.value=e,t._isUserAction=!1,t.silenceChange=!1}triggerChange(...e){this.silenceChange||super.triggerChange(...e)}onFocusOut(e,...t){var n;super.onFocusOut(e,...t);const i=this,{input:r}=i,s=r.value,o=i.formatter.truncate(s),a=isNaN(o)?s:i.formatValue(o);null===(n=i.triggers)||void 0===n||null===(n=n.spin)||void 0===n||null===(n=n.clickRepeater)||void 0===n||n.cancel(),i.lastTouchmove=null,s!==a&&(r.value=a),i._changedBySilentSpin&&(i.triggerChange(e,!0),i._changedBySilentSpin=!1)}internalOnInput({data:e}){const t=this,{formatter:n,input:i}=t,{parser:r,maximumFractionDigits:s}=n,o=i.value;if((null==e?void 0:e.length)>1&&!isFinite(r.parse(o))&&"-"!==o){const e=t._lastValue||t.valueOnFocus;t.queueMicrotask((()=>{t._value=NaN,t.value=e}))}else{const e=r.decimalPlaces(o);if(n.truncator&&e>s){let a,l=o;const c=n.truncate(o);if(!isNaN(c)&&(l=t.formatValue(c),a=r.decimalPlaces(l),a<s&&(l+="0".repeat(s-a),a=s),a<e)){const e=o.length-t.caretPos;i.value=l,t.caretPos=l.length-e+1}}super.internalOnInput(...arguments)}}formatValue(e){return this.formatter.format(e)}get formatter(){return this._formatter??(this._formatter=df.getLocalizedFormatter(this.format))}updateStep(e){const t=this;var n;(t.element.classList.toggle("b-hide-spinner",!e),t._step=e,e&&d.isMobile)?t.touchMoveListener||(t.touchMoveListener=Mn.on({element:t.input,touchmove:"onInputSwipe",thisObj:t,throttled:{buffer:150,alt:uf}})):null===(n=t.touchMoveListener)||void 0===n||n.call(t)}onInputSwipe(e){const{lastTouchmove:t}=this;if(t){const n=e.screenX-t.screenX,i=t.screenY-e.screenY;this["doSpin"+((Math.abs(n)>Math.abs(i)?n:i)>0?"Up":"Down")]()}e.preventDefault(),this.lastTouchmove=e}changeLargeStep(e){return e||10*this.step}get validity(){const e=this.value,t={};return null!=e&&(t.rangeUnderflow=!this.okMin(e),t.rangeOverflow=!this.okMax(e)),t.valid=!t.rangeUnderflow&&!t.rangeOverflow,t}changeValue(e,t){const n=this;if(e||0===e){let t;"number"!=typeof e&&(e="string"==typeof e?n.formatter.parse(e):Number(e),t=isNaN(e),t&&(e="")),!t&&n.format&&(e=n.formatter.round(e))}else e=void 0;return super.changeValue(e,t)}get inputValue(){return null!=this.value?this.formatValue(this.value):""}updateLocalization(){super.updateLocalization(),this._formatter=void 0,this.syncInputFieldValue()}}hf.initClass(),hf._$name="NumberField";const gf={number:!0,boolean:!0,string:!0,date:!0,duration:!0,time:!0,auto:!0},mf={number:!0,boolean:!0,string:!0},pf=e=>{var t;return"duration"===(null==e||null===(t=e.column)||void 0===t?void 0:t.type)},ff="b-fieldfilterpicker",vf={between:!0,notBetween:!0,isIncludedIn:!0,isNotIncludedIn:!0},yf={startsWith:!0,endsWith:!0,includes:!0,doesNotInclude:!0},bf={textfield:!0,datefield:!0,numberfield:!0,durationfield:!0,combo:!0,timefield:!0},Cf={value:"empty",text:"L{isEmpty}",argCount:0},Sf={value:"notEmpty",text:"L{isNotEmpty}",argCount:0},wf={value:"=",text:"L{equals}"},Df={value:"!=",text:"L{doesNotEqual}"},Ef={value:">",text:"L{isGreaterThan}"},xf={value:"<",text:"L{isLessThan}"},Rf={value:">=",text:"L{isGreaterThanOrEqualTo}"},Tf={value:"<=",text:"L{isLessThanOrEqualTo}"},Mf={value:"between",text:"L{isBetween}",argCount:2},If={value:"notBetween",text:"L{isNotBetween}",argCount:2},kf={value:"isIncludedIn",text:"L{isOneOf}",isArrayValued:!0},Ff={value:"isNotIncludedIn",text:"L{isNotOneOf}",isArrayValued:!0},Af=e=>{const{value:t}=e;return e.isTimeField&&t?us.getTime(t):t};class Pf extends Id{static $name="FieldFilterPicker";static type="fieldfilterpicker";static defaultOperators={string:[Cf,Sf,wf,Df,{value:"includes",text:"L{contains}"},{value:"doesNotInclude",text:"L{doesNotContain}"},{value:"startsWith",text:"L{startsWith}"},{value:"endsWith",text:"L{endsWith}"},kf,Ff],number:[Cf,Sf,wf,Df,Ef,xf,Rf,Tf,Mf,If,kf,Ff],date:[Cf,Sf,{value:"sameDay",text:"L{equals}"},{value:"notSameDay",text:"L{doesNotEqual}"},{value:"sameTime",text:"L{timeEquals}"},{value:"notSameTime",text:"L{timeDoesNotEqual}"},{value:"<",text:"L{isBefore}"},{value:">",text:"L{isAfter}"},Mf,{value:"isToday",text:"L{isToday}",argCount:0},{value:"isTomorrow",text:"L{isTomorrow}",argCount:0},{value:"isYesterday",text:"L{isYesterday}",argCount:0},{value:"isThisWeek",text:"L{isThisWeek}",argCount:0},{value:"isNextWeek",text:"L{isNextWeek}",argCount:0},{value:"isLastWeek",text:"L{isLastWeek}",argCount:0},{value:"isThisMonth",text:"L{isThisMonth}",argCount:0},{value:"isNextMonth",text:"L{isNextMonth}",argCount:0},{value:"isLastMonth",text:"L{isLastMonth}",argCount:0},{value:"isThisYear",text:"L{isThisYear}",argCount:0},{value:"isNextYear",text:"L{isNextYear}",argCount:0},{value:"isLastYear",text:"L{isLastYear}",argCount:0},{value:"isYearToDate",text:"L{isYearToDate}",argCount:0},kf,Ff],boolean:[{value:"isTrue",text:"L{isTrue}",argCount:0},{value:"isFalse",text:"L{isFalse}",argCount:0}],duration:[Cf,Sf,wf,Df,Ef,xf,Rf,Tf,Mf,If,kf,Ff],time:[Cf,Sf,wf,Df,Ef,xf,Rf,Tf,Mf,If,kf,Ff],relation:[Cf,Sf,wf,Df,kf,Ff],auto:[{value:"*",text:"L{contains}"}]};static get defaultValueFieldPlaceholders(){return{string:"L{enterAValue}",number:"L{enterANumber}",date:"L{selectADate}",relation:"L{selectValue}",list:"L{selectOneOrMoreValues}",duration:"L{enterAValue}",time:"L{selectATime}",auto:"L{enterAValue}"}}static#e=(()=>{zt(this,"configurable",{fields:null,disabled:!1,readOnly:!1,layout:"vbox",propertyLocked:!1,operatorLocked:!1,valueLocked:!1,filter:null,propertyFieldConfig:null,operatorFieldConfig:null,valueFieldCls:null,triggerChangeOnInput:!0,items:{inputs:{type:"container",layout:"hbox",cls:`${ff}-inputs`,items:{propertyPicker:{type:"combo",items:{},cls:`${ff}-property`,placeholder:"L{FieldFilterPicker.selectAProperty}",highlightExternalChange:!1},operatorPicker:{type:"combo",items:{},cls:`${ff}-operator`,placeholder:"L{FieldFilterPicker.selectAnOperator}",highlightExternalChange:!1},valueFields:{type:"container",cls:`${ff}-values`,items:{}}}},caseSensitive:{type:"checkbox",text:"L{FieldFilterPicker.caseSensitive}",cls:`${ff}-case-sensitive`}},operators:Pf.defaultOperators,dateFormat:"L{FieldFilterPicker.dateFormat}",store:null,valueFieldPlaceholders:null,getValueFieldConfig:null}),zt(this,"buildOperatorArgCountLookup",(e=>rt.keyBy(Object.entries(e),(([e])=>e),(([,e])=>rt.keyBy(e,(({value:e})=>e),(({argCount:e})=>void 0===e?1:e))))))})();afterConstruct(){const e=this;if(!e._fields)throw new Error(`${Pf.name} requires 'fields' to be configured.`);if(!e._filter)throw new Error(`${Pf.name} requires 'filter' to be configured.`);super.afterConstruct();const{widgetMap:{propertyPicker:t,operatorPicker:n,caseSensitive:i}}=e;t.ion({select:"onPropertySelect",thisObj:e}),n.ion({select:"onOperatorSelect",thisObj:e}),i.ion({change:"onCaseSensitiveChange",thisObj:e}),e.propertyFieldConfig&&t.setConfig(e.propertyFieldConfig),e.operatorFieldConfig&&n.setConfig(e.operatorFieldConfig),t.cls=e.allPropertyPickerClasses,n.cls=e.allOperatorPickerClasses,e.populateUIFromFilter()}changeDateFormat(e){return this.L(e)}get allChildInputs(){const{propertyPicker:e,operatorPicker:t,caseSensitive:n}=this.widgetMap;return[e,t,...this.valueFields,n]}updateDisabled(e,t){super.updateDisabled(e,t),this.allChildInputs.forEach((t=>t.disabled=e))}updateReadOnly(e){const{propertyPicker:t,operatorPicker:n}=this.widgetMap;this.allChildInputs.forEach((t=>t.readOnly=e)),t.readOnly=t.readOnly||e,n.readOnly=n.readOnly||e}updatePropertyLocked(e){this.widgetMap.propertyPicker.readOnly=e||this.readOnly,this.widgetMap.propertyPicker.cls=this.allPropertyPickerClasses}updateOperatorLocked(e){this.widgetMap.operatorPicker.readOnly=e||this.readOnly,this.widgetMap.operatorPicker.cls=this.allOperatorPickerClasses}updateValueLocked(e){this.valueFields.forEach((t=>t.readOnly=e||this.readOnly))}changeOperators(e){const t=e??Pf.defaultOperators;return Object.keys(t).reduce(((e,n)=>({...e,[n]:t[n].map((e=>({...e,text:this.L(e.text)})))})),{})}get isMultiSelectValueField(){var e;return["isIncludedIn","isNotIncludedIn"].includes(null===(e=this._filter)||void 0===e?void 0:e.operator)}get allPropertyPickerClasses(){var e;return new Ht(`${ff}-property`,null===(e=this.propertyFieldConfig)||void 0===e?void 0:e.cls,{[`${ff}-combo-locked`]:this.propertyLocked})}get allOperatorPickerClasses(){var e;return new Ht(`${ff}-operator`,null===(e=this.operatorFieldConfig)||void 0===e?void 0:e.cls,{[`${ff}-combo-locked`]:this.operatorLocked})}getValueFieldConfigs(){var e;const t=this,{valueFieldCls:n,fieldType:i,_filter:{operator:r},onValueChange:s,filterValues:o,isMultiSelectValueField:a,operatorArgCount:l,getValueFieldConfig:c,fieldIsRelation:d,triggerChangeOnInput:u}=t,h=U.merge({},Pf.defaultValueFieldPlaceholders,t.valueFieldPlaceholders);if(!i||!r||0===l)return[];let g={type:"textfield",internalListeners:{change:s,input:u?s:null,thisObj:t},bubbleEvents:{keydown:!0},cls:n,dataset:{type:i},placeholder:t.L(h[a?"list":d?"relation":i]),highlightExternalChange:!1};var m;if(a||d?g={...g,type:"combo",multiSelect:a,createOnUnmatched:!0,items:t.getUniqueDataValues(o),value:o??[]}:"sameTime"===r||"notSameTime"===r?g.type="timefield":["number","date","boolean","duration","time"].includes(i)&&(g.type=`${i}field`),"date"===i&&"timefield"!==g.type)g.format=(null===(m=t.selectedField)||void 0===m?void 0:m.format)??t.dateFormat;else if("number"===i&&null!==(e=t.selectedField)&&void 0!==e&&e.format){var p;g.format=null===(p=t.selectedField)||void 0===p?void 0:p.format}return c&&(g=t.callback(c,t,[t.filter,g])),a?[g]:rt.populate(l,(e=>[{type:"widget",tag:"div",cls:`${ff}-value-separator`,content:t.L("L{FieldFilterPicker.and}")},{...g,value:o[e]}])).flat().slice(1)}getUniqueDataValues(e=[]){var t,n;const i=this,{fieldType:r}=i,s=null===(t=i.selectedField)||void 0===t?void 0:t.format;if(!i.store||null===(n=i._filter)||void 0===n||!n.property)return[];const{relatedDisplayField:o}=i.selectedField;let a,l;if(i.fieldIsRelation){const{foreignStore:e}=i.currentPropertyRelationConfig;o?(a=e.allRecords.reduce(((e,t)=>(null!=t.id&&e.push({text:t.getValue(o),value:t.id}),e)),[]),l=a.sort(((e,t)=>i.sortStrings(e.text,t.text)))):a=e.allRecords.map((e=>e.id))}else a=i.store.allRecords.map((e=>e.getValue(i._filter.property)));if(!l){a.push(...e);const t=rt.unique(a.reduce(((e,t)=>(null!=t&&""!==String(t).trim()&&("date"===r?e.push(t.valueOf()):"duration"===r?e.push(t.toString()):e.push(t)),e)),[]));if(l="string"===r?t.sort(i.sortStrings):"duration"===r?t.map((e=>new Co(e))).filter((e=>e.isValid)).sort(i.sortDurations):t.sort(i.sortNumerics),"date"===r)l=l.map((e=>{const t=new Date(e);return{text:us.format(t,s??i.dateFormat),value:e}}));else if("number"===r&&s){const e=df.getLocalizedFormatter(s);l=l.map((t=>({text:e.format(t),value:t})))}else"duration"===r&&(l=l.map((e=>e.toString())))}return l}sortStrings(e,t){return(e??"").localeCompare(t??"")}sortNumerics(e,t){return e-t}sortDurations(e,t){return e.valueOf()-t.valueOf()}get fieldType(){var e;return null===(e=this.selectedField)||void 0===e?void 0:e.type}get selectedField(){var e,t;return null===(e=this.fields)||void 0===e?void 0:e[null===(t=this._filter)||void 0===t?void 0:t.property]}get propertyOptions(){return Object.entries(this.fields??{}).filter((([,e])=>gf[e.type]||pf(e))).map((([e,{title:t}])=>({value:e,text:t??e}))).sort(((e,t)=>e.text.localeCompare(t.text)))}get operatorOptions(){return this.operators[this.fieldIsRelation?"relation":this.fieldType]}get fieldIsRelation(){return Boolean(this.currentPropertyRelationConfig)}get currentPropertyRelationConfig(){var e;return null===(e=this.store)||void 0===e||null===(e=e.modelRelations)||void 0===e?void 0:e.find((({foreignKey:e})=>{var t;return e===(null===(t=this._filter)||void 0===t?void 0:t.property)}))}updateOperators(){delete this._operatorArgCountLookup}get operatorArgCountLookup(){return this._operatorArgCountLookup||(this._operatorArgCountLookup=Pf.buildOperatorArgCountLookup(this.operators))}updateFilter(){this._filter&&this.onFilterChange()}updateStore(e){var t;null===(t=this._store)||void 0===t||t.un(this),null==e||e.ion({refresh:"onStoreRefresh",thisObj:this}),this.inferFieldTypes()}onStoreRefresh({action:e}){this.isMultiSelectValueField&&["dataset","create","update","delete"].includes(e)&&(this.valueFields[0].items=this.getUniqueDataValues(this.filterValues))}refreshValueFields(){const e=this,{valueFields:t}=e.widgetMap,{valueFields:n,fieldType:i,operatorArgCount:r,_filter:{property:s,operator:o}}=e,a=vf[o],l="sameTime"===o||"notSameTime"===o?"time":i;t.element.className=new Ht({[`${ff}-values`]:!0,[`${ff}-values-multiple`]:a,[`${ff}-values-${l}`]:void 0!==i,"b-hidden":null==s||null==o||0===r});const c=e.getValueFieldConfigs();if(c.length!==n.length||c.some((({type:e},t)=>n[t].type!==e)))t.removeAll(),t.add(c);else{let e=0;for(const t of c)delete t.type,U.assign(n[e++],t)}delete e._valueFields,e.refreshCaseSensitive()}refreshCaseSensitive(){var e,t;const n=this,{fieldType:i,operatorArgCount:r,isMultiSelectValueField:s}=n,o=null===(e=n._filter)||void 0===e?void 0:e.operator,{caseSensitive:a}=n.widgetMap;a.hidden="string"!==i||!o||s||0===r,a.checked=!1!==(null===(t=n._filter)||void 0===t?void 0:t.caseSensitive)}onPropertySelect(e){var t;const n=this,{_filter:i}=n;i.property=(null===(t=e.record)||void 0===t?void 0:t.data.value)||null,n.fieldType!==n._fieldType&&(i.operator=null,i.value=null),n._fieldType=i.type=n.fieldType,n.refreshOperatorPicker(),n.refreshValueFields(),n.triggerChange()}onCaseSensitiveChange({checked:e}){this._filter.caseSensitive=e,this.triggerChange()}onOperatorSelect(e){var t;const n=this,i=n.isMultiSelectValueField,r=this.operatorArgCount;n._filter.operator=(null===(t=e.record)||void 0===t?void 0:t.data.value)||null,n.operatorArgCount!==r&&(n._filter.value=null),n.isMultiSelectValueField&&!i&&(n._filter.value=[]),n.refreshValueFields(),n.triggerChange()}triggerChange(){const{filter:e,isValid:t}=this;this.trigger("change",{filter:e,isValid:t})}onValueChange(){const{isMultiSelectValueField:e,fieldType:t,_filter:n}=this,i=this.valueFields.map(Af);e&&"date"===t?n.value=i[0].map((e=>new Date(e))):e&&"duration"===t?n.value=i[0].map((e=>new Co(e))):("date"===t&&"between"===n.operator&&us.isValidDate(i[1])&&i[1].setHours(23,59,59,999),n.value=1===i.length?i[0]:i),this.triggerChange()}refreshOperatorPicker(){const{operatorPicker:e}=this.widgetMap,{_filter:{operator:t,property:n},operatorOptions:i}=this;e.items=i,e.value=t,e.hidden=null===n}populateUIFromFilter(e=!1){const t=this,{filterValues:n,widgetMap:{propertyPicker:i,operatorPicker:r},_filter:{property:s,operator:o,disabled:a},propertyOptions:l,operatorOptions:c,isMultiSelectValueField:d}=t;i.items=l,r.items=c,r.hidden=null===s;let u=e;i.value!==s&&(i.value=s,t.refreshOperatorPicker(),u=!0),"date"===t.fieldType&&("="===o?t._filter.operator="sameDay":"!="===o&&(t._filter.operator="notSameDay")),r.value!==o&&(null!==o&&r.items.find((({value:e})=>e===o))?r.value=o:r.clear(),u=!0),o||1!==r.items.length||(r.value=t._filter.operator=r.items[0].value),u&&t.refreshValueFields(),t.refreshCaseSensitive(),t.valueFields.forEach(((e,i)=>{d&&(e.value.length>0||n.length>0)?"date"===t.fieldType?e.value=n.map((e=>null==e?void 0:e.valueOf())):"duration"===t.fieldType?e.value=n.map((e=>null==e?void 0:e.toString())):e.value=n:i>=n.length?e.clear():e.value=n[i]})),t.allChildInputs.forEach((e=>e.disabled=t.disabled||a))}get valueFields(){return this._valueFields||(this._valueFields=this.widgetMap.valueFields.queryAll((e=>e.owner===this.widgetMap.valueFields&&bf[e.type])))}get filterValues(){var e;return null==(null===(e=this._filter)||void 0===e?void 0:e.value)?[]:rt.asArray(this._filter.value)}onFilterChange(){const e=this,t=e.fieldType,n=t!==e._fieldType;e._fieldType=e._filter.type=t,e.populateUIFromFilter(n)}get operatorArgCount(){const{fieldType:e,filter:{operator:t},operatorArgCountLookup:n}=this;return e&&t?n[e][t]:1}get isValid(){const{filter:e,fieldType:t,filterValues:n,isMultiSelectValueField:i,operatorArgCount:r}=this,{operator:s,value:o}=e;return Boolean(t&&s&&!(r>0&&null==o)&&(!yf[s]||Boolean(o))&&(i&&n.length>0||n.length===r)&&n.every((e=>null!=e&&("duration"!==t||e.isValid))))}get focusElement(){var e;return(null===(e=this.valueFields.find((e=>e.isEmptyInput))??this.operatorPicker??this.propertyPicker)||void 0===e?void 0:e.input)??super.focusElement}inferFieldTypes(){var e;if((null===(e=this.store)||void 0===e?void 0:e.totalCount)>0&&this.fields)for(const[e,t]of Object.entries(this.fields))"auto"===t.type&&(t.type=Pf.inferFieldType(this.store,e))}static inferFieldType(e,t){var n;const i=null===(n=e.find((e=>null!=e.getValue(t)),!0))||void 0===n?void 0:n.getValue(t);if(void 0!==i){const e=typeof i;if("object"===e&&i instanceof Date)return"date";if(mf[e])return e}return"auto"}static localizeOperator(e,t){const{defaultOperators:n}=Pf,i=Object.keys(n).sort(((e,n)=>e===t?-1:n===t?1:0));for(const t of i)for(const i of n[t])if(i.value===e)return Pf.L(i.text);return e}}Pf.initClass(),Pf._$name="FieldFilterPicker";class Lf extends hd{static $name="Label";static type="label";static configurable={text:null,localizableProperties:["text"]};compose(){const{text:e,html:t}=this;return{tag:"label",text:e,html:t}}}Lf.initClass(),Lf._$name="Label";class Of extends Id{static $name="FieldFilterPickerGroup";static type="fieldfilterpickergroup";static addFilterButtonDefaultText="L{FieldFilterPickerGroup.addFilter}";static#e=(()=>{zt(this,"configurable",{filters:[],fields:null,disabled:!1,readOnly:!1,layout:"vbox",store:null,limitToProperty:null,valueFieldCls:null,showAddFilterButton:!0,canDeleteFilter:null,getFieldFilterPickerConfig:null,canManageFilter:null,addFilterButtonText:null,triggerChangeOnInput:!0,allowedFieldNames:null,items:{pickers:{type:"container",layout:"vbox",scrollable:!0,items:{}},addFilterButton:{type:"button",text:Of.addFilterButtonDefaultText,cls:`b-${Of.type}-add-button`,hidden:!0}},operators:null,dateFormat:"L{FieldFilterPicker.dateFormat}"}),zt(this,"childPickerType","fieldfilterpicker")})();afterConstruct(){const e=this;e.validateConfig();const{addFilterButton:t}=e.widgetMap;t.ion({click:"addFilter",thisObj:e}),t.text=e.L(t.text),e.store&&e.updateStore(e.store),super.afterConstruct()}changeDateFormat(e){return this.L(e)}validateConfig(){if(!this.fields&&!this.store)throw new Error("FieldFilterPickerGroup requires either a 'fields' or 'store' config property.")}updateFields(e){this.widgetMap.pickers.childItems.forEach((t=>t.fields=e))}updateFilters(e,t){const n=this;t&&t.filter((t=>!e.find((e=>e.id===t.id)))).forEach((e=>{var t;return null===(t=n.store)||void 0===t?void 0:t.removeFilter(e.id)})),e.forEach((e=>e.id=e.id||n.nextFilterId)),n.widgetMap.pickers.items=(null==e?void 0:e.map((e=>n.getPickerRowConfig(e))))||[]}changeFilters(e){const{canManageFilter:t,limitToProperty:n}=this;let i=e;return t&&(i=i.filter((e=>this.callback(t,this,[e])))),n&&(i=i.filter((e=>null==e.property||e.property===n))),i}updateStore(e){const t=this;if(t.detachListeners("store"),e){let n=!1;t.widgetMap.pickers.childItems.forEach((({widgetMap:{filterPicker:{filter:t,isValid:i}}})=>{i&&!e.filters.includes(t)&&(e.removeFilter(t.id,!0),e.addFilter(t,!0),n=!0)})),n&&e.filter(),t.appendFiltersFromStore(),e.ion({name:"store",filter:"onStoreFilter",thisObj:t})}t.widgetMap.pickers.childItems.forEach((t=>t.store=e))}updateShowAddFilterButton(e){this.widgetMap.addFilterButton.hidden=!e}updateAddFilterButtonText(e){this.widgetMap.addFilterButton.text=e??Of.addFilterButtonDefaultText}appendFiltersFromStore(){const e=this;e.store.filters.forEach((t=>{var n;const i=e.canManage(t),{property:r,operator:s,id:o}=t;i&&r&&s&&(null===(n=e.filters)||void 0===n||!n.find((e=>e.id===o)))&&e.appendFilter(t)}))}canManage(e){const t=this;return(!t.allowedFieldNames||t.allowedFieldNames.includes(e.property))&&(!t.canManageFilter||!0===t.callback(t.canManageFilter,t,[e]))}getFilterPickerConfig(e){const t=this,{fields:n,store:i,disabled:r,readOnly:s,valueFieldCls:o,operators:a,limitToProperty:l,dateFormat:c,getFieldFilterPickerConfig:d,triggerChangeOnInput:u,allowedFieldNames:h}=t;return{type:t.constructor.childPickerType,fields:n??t.getFieldsFromStore(i),filter:e,store:i,disabled:r,readOnly:s,propertyLocked:Boolean(l),valueFieldCls:o,operators:a,dateFormat:c,internalListeners:{change:"onFilterPickerChange",thisObj:t},flex:1,triggerChangeOnInput:u,allowedFieldNames:h,...d?t.callback(d,t,[e]):void 0}}getFieldsFromStore(e){var t;return Object.fromEntries((null===(t=e.modelClass)||void 0===t?void 0:t.fields.map((({name:e,type:t})=>[e,{type:t}])))??[])}getPickerRowConfig(e){const t=this,{disabled:n,readOnly:i,canDeleteFilter:r}=t,s=!(r&&!1===t.callback(r,t,[e])),o=!Boolean(e.disabled);return{type:"container",layout:"box",cls:{[`b-${Of.type}-row`]:!0,[`b-${Of.type}-row-removable`]:s},dataset:{separatorText:t.L