/*!
 *
 * Bryntum Scheduler Pro 6.3.1
 *
 * Copyright(c) 2025 Bryntum AB
 * https://bryntum.com/contact
 * https://bryntum.com/license
 *
 * Bryntum incorporates third-party code licensed under the MIT and Apache-2.0 licenses.
 * See the licenses below or visit https://bryntum.com/products/schedulerpro/docs/guide/SchedulerPro/licenses
 *
 * # Third Party Notices
 * 
 * Bryntum uses the following third party libraries:
 * 
 * * [Font Awesome 6 Free](https://fontawesome.com/license/free) (MIT/SIL OFL 1.1)
 * * [Roboto font (for Material theme only)](https://github.com/google/roboto) (Apache-2.0)
 * * [Styling Cross-Browser Compatible Range Inputs with Sass](https://github.com/darlanrod/input-range-sass) (MIT)
 * * [Tree Walker polyfill (only applies to Salesforce)](https://github.com/Krinkle/dom-TreeWalker-polyfill) (MIT)
 * * [chronograph](https://github.com/bryntum/chronograph) (MIT)
 * * [later.js](https://github.com/bunkat/later) (MIT)
 * * [Monaco editor (only used in our demos)](https://microsoft.github.io/monaco-editor) (MIT)
 * * Map/Set polyfill to fix performance issues for Salesforce LWS (MIT)
 * * [Chart.js (when using Chart package)](https://github.com/chartjs/Chart.js) (MIT)
 * 
 * Note: the **chronograph** and **later.js** libraries are used in Bryntum Scheduler Pro and Bryntum Gantt, but they are
 * listed for all Bryntum products since the distribution contains trial versions of the thin bundles for all other
 * products. TreeWalker is only used in the LWC bundle for Salesforce. Roboto font is only used in the material theme.
 * 
 * ## Font Awesome 6 Free
 * 
 * [Font Awesome Free 6 by @fontawesome](https://fontawesome.com/)
 * 
 * Font Awesome Free is free, open source, and GPL friendly. You can use it for commercial projects, open source projects,
 * or really almost whatever you want.
 * 
 * [Full Font Awesome Free license](https://fontawesome.com/license/free)
 * 
 * ## Roboto font
 * 
 * [Apache License Version 2.0, January 2004](https://www.apache.org/licenses/LICENSE-2.0)
 * 
 * TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 * 
 * 1. Definitions.
 * 
 * "License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9
 * of this document.
 * 
 * "Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.
 * 
 * "Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are
 * under common control with that entity. For the purposes of this definition,
 * "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by
 * contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial
 * ownership of such entity.
 * 
 * "You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.
 * 
 * "Source" form shall mean the preferred form for making modifications, including but not limited to software source code,
 * documentation source, and configuration files.
 * 
 * "Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including
 * but not limited to compiled object code, generated documentation, and conversions to other media types.
 * 
 * "Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as
 * indicated by a copyright notice that is included in or attached to the work
 * (an example is provided in the Appendix below).
 * 
 * "Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work
 * and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an
 * original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain
 * separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.
 * 
 * "Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or
 * additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the
 * Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner.
 * For the purposes of this definition, "submitted"
 * means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including
 * but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems
 * that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding
 * communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a
 * Contribution."
 * 
 * "Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received
 * by Licensor and subsequently incorporated within the Work.
 * 
 * 2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to
 *    You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce,
 *    prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such
 *    Derivative Works in Source or Object form.
 * 
 * 3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a
 *    perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *    (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise
 *    transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are
 *    necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s)
 *    with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (
 *    including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within
 *    the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this
 *    License for that Work shall terminate as of the date such litigation is filed.
 * 
 * 4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with
 *    or without modifications, and in Source or Object form, provided that You meet the following conditions:
 * 
 * (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and
 * 
 * (b) You must cause any modified files to carry prominent notices stating that You changed the files; and
 * 
 * (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark,
 * and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the
 * Derivative Works; and
 * 
 * (d) If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute
 * must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that
 * do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file
 * distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the
 * Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices
 * normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You
 * may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the
 * NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the
 * License.
 * 
 * You may add Your own copyright statement to Your modifications and may provide additional or different license terms and
 * conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole,
 * provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this
 * License.
 * 
 * 5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for
 *    inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any
 *    additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any
 *    separate license agreement you may have executed with Licensor regarding such Contributions.
 * 
 * 6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product
 *    names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and
 *    reproducing the content of the NOTICE file.
 * 
 * 7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and
 *    each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 *    either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT,
 *    MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness
 *    of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this
 *    License.
 * 
 * 8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or
 *    otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing,
 *    shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or
 *    consequential damages of any character arising as a result of this License or out of the use or inability to use the
 *    Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or
 *    any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such
 *    damages.
 * 
 * 9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose
 *    to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or
 *    rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and
 *    on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and
 *    hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason
 *    of your accepting any such warranty or additional liability.
 * 
 * END OF TERMS AND CONDITIONS
 * 
 * APPENDIX: How to apply the Apache License to your work.
 * 
 * To apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by
 * brackets "[]"
 * replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the
 * appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose
 * be included on the same "printed page" as the copyright notice for easier identification within third-party archives.
 * 
 * Copyright [yyyy] [name of copyright owner]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 * [APACHE LICENSE, VERSION 2.0](http://www.apache.org/licenses/LICENSE-2.0)
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "
 * AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * ## Styling Cross-Browser Compatible Range Inputs with Sass
 * 
 * Github: [input-range-sass](https://github.com/darlanrod/input-range-sass)
 * 
 * Author: [Darlan Rod](https://github.com/darlanrod)
 * 
 * Version 1.4.1
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 Darlan Rod
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Tree Walker polyfill
 * 
 * The MIT License (MIT)
 * 
 * [Copyright 2013–2017 Timo Tijhof](https://github.com/Krinkle/dom-TreeWalker-polyfill)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## chronograph
 * 
 * GitHub: [chronograph](https://github.com/bryntum/chronograph)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2023 Bryntum
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## later.js
 * 
 * GitHub: [later.js](https://github.com/bunkat/later)
 * 
 * The MIT License (MIT)
 * 
 * Copyright © 2013 BunKat
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Monaco editor
 * 
 * GitHub: [Monaco editor](https://microsoft.github.io/monaco-editor) (MIT)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 - present Microsoft Corporation
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Map/Set polyfill to fix performance issues for Salesforce LWS
 * 
 * Copyright © 2024 Certinia Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 * ## Chart.js
 * 
 * GitHub: [Chart.js](https://github.com/chartjs/Chart.js)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014-2022 Chart.js Contributors
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */
var iA=Object.defineProperty,rA=(i,e,t)=>e in i?iA(i,e,{enumerable:!0,configurable:!0,writable:!0,value:t}):i[e]=t,p=(i,e,t)=>(rA(i,typeof e!="symbol"?e+"":e,t),t),HD=(i,e,t)=>{if(!e.has(i))throw TypeError("Cannot "+t)},VD=(i,e,t)=>(HD(i,e,"read from private field"),t?t.call(i):e.get(i)),jD=(i,e,t)=>{if(e.has(i))throw TypeError("Cannot add the same private member more than once");e instanceof WeakSet?e.add(i):e.set(i,t)},wo=(i,e,t,r)=>(HD(i,e,"write to private field"),r?r.call(i,t):e.set(i,t),t),ru=Object.create(null),Yv=["Array","Browser",["Css","CSSHelper"],"Date","Dom","Event","Function","Object","String","TimeZone","Version"].map(i=>Array.isArray(i)?i:[i,`${i}Helper`]),zD=i=>Object.assign(Object.create(null),Object.fromEntries(i)),ND=zD(Yv),nA=zD(Yv.map(([i,e])=>[e,i])),Kv=i=>(e,t)=>{throw new Error(`Cannot ${i} "Helpers.${t}": object is readonly`)},WD=new Proxy(ru,{defineProperty:Kv("define property"),deleteProperty:Kv("delete"),set:Kv("assign"),get(i,e){const t=ru[e];if(!t)throw new Error(`Property not defined "Helpers.${e}": ${e in ND?`import ${ND[e]} before using it`:"invalid helper name"}`);return t}});Object.defineProperty(ru,"register",{value(i){const e=i.$name,t=nA[e];ru[t]=i}}),Yv.forEach(i=>ru[i[0]]=null);var ye=WD;(globalThis.bryntum||(globalThis.bryntum={})).Helpers=WD;var UD,Y=class{static cacheFlags(i=navigator.platform,e=navigator.userAgent){const t=this;t._isLinux=!!i.match(/Linux/),t._isMac=!!i.match(/Mac/),t._isWindows=!!i.match(/Win32/),t._isMobile=!!(e.match(/Mobile|Opera Mini|Opera Mobi|Puffin/)||typeof globalThis.orientation=="number"),t._isWebkit=!!(e.match(/WebKit/)&&!e.match(/Edg/)),t._firefoxVersion=t.getVersion(e,/Firefox\/(\d+)\./),t._isFirefox=t._firefoxVersion>0,t._chromeVersion=t.getVersion(e,/Chrom(?:e|ium)\/(\d+)\./),t._isChrome=t._chromeVersion>0,t._isSafari=!!e.match(/Safari/)&&!t._isChrome,t._isMobileSafari=t._isSafari&&t.isMobile,t._safariVersion=t.getVersion(e,/Version\/(.*).Safari/),t._isAndroid=!!e.match(/Android/g)}static get supportsOverflowClip(){if(this._supportsOverflowClip==null){const i=document.createElement("div");i.style.overflow="clip",i.style.display="none",document.documentElement.appendChild(i),this._supportsOverflowClip=i.ownerDocument.defaultView.getComputedStyle(i).getPropertyValue("overflow")==="clip",i.remove()}return this._supportsOverflowClip}static get supportsSticky(){return!0}static getVersion(i,e){const t=i.match(e);return t?parseFloat(t[1]):0}static get isTouchDevice(){return this._isTouchDevice===void 0&&(this._isTouchDevice=globalThis.matchMedia("(any-pointer:coarse)").matches),this._isTouchDevice}static get isHoverableDevice(){return this._isHoverableDevice===void 0&&(this._isHoverableDevice=globalThis.matchMedia("(any-hover: hover)").matches),this._isHoverableDevice}static get isBrowserEnv(){return typeof window!="undefined"}static get isMac(){return this._isMac}static get isWindows(){return this._isWindows}static get isLinux(){return this._isLinux}static get isAndroid(){return this._isAndroid}static get isWebkit(){return this._isWebkit}static get isChrome(){return this._isChrome}static get chromeVersion(){return this._chromeVersion}static get isFirefox(){return this._isFirefox}static get firefoxVersion(){return this._firefoxVersion}static get isSafari(){return this._isSafari}static get safariVersion(){return this._safariVersion}static get isMobileSafari(){return this._isMobileSafari}static get isMobile(){return this._isMobile}static get platform(){const i=this;return i._isLinux?"linux":i._isMac?"mac":i._isWindows?"windows":i._isAndroid?"android":i._isMobileSafari?"ios":null}static get supportsRandomUUID(){var i,e;if(this._supportsRandomUUID===void 0)try{this._supportsRandomUUID=((e=(i=globalThis.crypto).randomUUID)==null?void 0:e.call(i).length)>0}catch(t){this._supportsRandomUUID=!1}return this._supportsRandomUUID}static get storageAvailable(){let i,e;try{return i=localStorage,e="__storage_test__",i.setItem(e,e),i.removeItem(e),!0}catch(t){return t instanceof DOMException&&(t.code===22||t.code===1014||t.name==="QuotaExceededError"||t.name==="NS_ERROR_DOM_QUOTA_REACHED")&&i.length!==0}}static setLocalStorageItem(i,e){this.storageAvailable&&localStorage.setItem(i,e)}static getLocalStorageItem(i){return this.storageAvailable&&localStorage.getItem(i)}static removeLocalStorageItem(i){this.storageAvailable&&localStorage.removeItem(i)}static get ctrlKey(){return this.isMac?"metaKey":"ctrlKey"}static get metaKey(){return this.isMac?"ctrlKey":"metaKey"}static searchParam(i,e=null,t=document.location.search){const r=new RegExp(`[?&]${i}=?([^&]*)`),n=t.match(r);return n&&n[1]||e}static getCookie(i){const e=encodeURIComponent(i)+"=",t=document.cookie.split(";");for(let r=0;r<t.length;r++){let n=t[r];for(;n.charAt(0)===" ";)n=n.substring(1,n.length);if(n.indexOf(e)===0)return decodeURIComponent(n.substring(e.length,n.length))}return""}static download(i,e){const t=document.createElement("a");t.download=i,t.href=e||i,t.style.cssText="display:none",document.body.appendChild(t),t.click(),document.body.removeChild(t)}static downloadBlob(i,e){const t=globalThis.URL.createObjectURL(i);this.download(e,t),globalThis.URL.revokeObjectURL(t)}static get queryString(){var i;const e=new URL(globalThis.location.href).searchParams;return(i=Object.fromEntries)==null?void 0:i.call(Object,e.entries())}static copyToClipboard(i){let e=!0;const t=document.createElement("textarea");t.value=i,t.style.height=t.style.width=0,document.body.appendChild(t),t.select();try{document.execCommand("copy")}catch(r){e=!1}return t.remove(),e}static isBryntumOnline(i){return i=Array.isArray(i)?i:[i],!!(/^(www\.)?bryntum\.com$/.test(globalThis.location.host)||i!=null&&i.some(e=>this.queryString[e]!=null))}static get isCSP(){const{bryntum:i,document:e}=globalThis;return i.CSP==null&&(i.CSP=!!e.querySelector('meta[http-equiv="Content-Security-Policy"]')),i.CSP}};p(Y,"$name","BrowserHelper"),p(Y,"supportsPointerEvents",!!(globalThis.PointerEvent||globalThis.MSPointerEvent)),p(Y,"supportsPointerEventConstructor",typeof PointerEvent!="undefined"),p(Y,"PointerEventConstructor",globalThis.PointerEvent||globalThis.CustomEvent),p(Y,"isPhone",(UD=globalThis.matchMedia)==null?void 0:UD.call(globalThis,"(max-height:414px) or (max-width:414px)").matches),ye.register(Y),Y.isBrowserEnv&&Y.cacheFlags(),Y._$name="BrowserHelper";var{hasOwnProperty:sA,propertyIsEnumerable:aA,toString:oA}=Object.prototype,{isFrozen:GD}=Object,lA=/\s*<\s*/,dA=/\s*>\s*/,qD={},YD={},KD=Object.freeze({}),X=class Mt{static assign(e,...t){for(let r,n,s=0;s<t.length;s++)if(r=t[s],r)for(n in r)n!=="__proto__"&&n!=="constructor"&&(e[n]=r[n]);return e}static assignIf(e,...t){for(let r,n,s=0;s<t.length;s++)if(r=t[s],r)for(n in r)n!=="__proto__"&&n!=="constructor"&&(!(n in e)||e[n]===void 0)&&(e[n]=r[n]);return e}static blend(e,t,r){r=r||qD,e=e||{};const{clone:n=Mt.clone,merge:s=Mt.blend}=r;if(Array.isArray(t)){if(t.length>1)return t.forEach(a=>{e=Mt.blend(e,a,r)}),e;t=t[0]}if(t){let a,o,l;for(o in t)o!=="__proto__"&&o!=="constructor"&&(l=t[o],l&&Mt.isObject(l)&&(a=e[o],r.key=o,a&&Mt.isObject(a)?(GD(a)&&(e[o]=a=n(a,r)),l=s(a,l,r)):l=GD(l)?l:n(l,r)),e[o]=l)}return e}static clone(e,t){let r=e,n;if(e&&typeof e=="object"&&!(e instanceof Event))if(t&&typeof t=="object"&&t&&(t=null),Mt.isObject(e))if(e.skipClone)r=e;else{r={};for(n in e)n!=="__proto__"&&n!=="constructor"&&(r[n]=Mt.clone(e[n]))}else if(Array.isArray(e))for(r=[],n=e.length;n-- >0;)r[n]=Mt.clone(e[n]);else Mt.isDate(e)?r=new Date(e.getTime()):t&&(r=t(e));return r}static mergeUniformObjects(e,...t){for(const r of t)for(const n in r)if(n!=="__proto__"&&n!=="constructor"){const s=r[n];s&&(this.isObject(s)?this.mergeUniformObjects(e[n]||(e[n]={}),s):Array.isArray(s)?(n in e||(e[n]=[]),this.mergeArrayOfIdentityObjects(e[n],s)):e[n]=this.clone(s))}return e}static mergeArrayOfIdentityObjects(e,t){for(const r of t)if(this.isObject(r)){const n=e.find(s=>s.id===r.id);n?this.mergeUniformObjects(n,r):e.push(this.clone(r))}else e.push(r)}static createTruthyKeys(e){const t=k.split(e),r=t&&{};if(t)for(const n of t)n&&(r[n]=!0);return r}static getPath(e,t){return t.split(".").reduce((r,n)=>(r||KD)[n],e)}static getPathDefault(e,t,r){const n=Array.isArray(t)?t:typeof t=="string"?t.split("."):[t],s=n.length-1;return n.reduce((a,o,l)=>(r&&!(o in a)&&(a[o]=l===s?r:{}),(a||KD)[o]),e)}static getPropertyDescriptor(e,t){let r=null;for(let n=e;n&&!r&&!Mt.hasOwn(n,"isBase");n=Object.getPrototypeOf(n))r=Object.getOwnPropertyDescriptor(n,t);return r}static hasPath(e,t){return t.split(".").every(r=>e&&r in e?(e=e[r],!0):!1)}static getTruthyKeys(e){let t;if(typeof e=="string")t=[e];else if(Array.isArray(e))t=e.slice();else if(t=[],e)for(const r in e)e[r]&&t.push(r);return t}static getTruthyValues(e){const t=[];if(e)for(const r in e)e[r]&&t.push(e[r]);return t}static isClass(e){var t;return typeof e=="function"&&((t=e.prototype)==null?void 0:t.constructor)===e}static isDate(e){return!!(e!=null&&e.getUTCDate)&&Mt.typeOf(e)==="date"}static isPromise(e){if(Promise!=null&&Promise.resolve)return Promise.resolve(e)===e||typeof(e==null?void 0:e.then)=="function";throw new Error("Promise not supported in your environment")}static isEmpty(e){if(e&&typeof e=="object")for(const t in e)return!1;return!0}static isObject(e){const t=e==null?void 0:e.constructor;return!!(t&&typeof t=="function"&&!Mt.hasOwn(e,"constructor")&&!aA.call(e,"constructor")?(t===Object||t.getPrototypeOf&&t.prototype&&!Object.getPrototypeOf(t.prototype))&&e!==globalThis:e&&typeof e=="object")}static isInstantiated(e){return e?typeof e=="object"&&!Mt.isObject(e):!1}static merge(e,...t){return Mt.blend(e,t)}static mergeItems(e,t,r){r=r||qD;let n,s,a,o,l,d,c;const{merge:u=Mt.blend}=r;if(e=e||{},Array.isArray(t))t.forEach(h=>{e=Mt.mergeItems(e,h,r)});else if(t){for(l in t)if(l!=="__proto__"&&l!=="constructor")if(c=t[l],n=null,l.includes(">")?([l,n]=l.split(dA),s=0):l.includes("<")&&([n,l]=l.split(lA),s=1),l in e)c&&e[l]&&u&&(r.key=l,c=u(e[l],c,r)),e[l]=c;else if(!n)e[l]=c,o==null||o.set(l,o.size);else{if(!o){o=new Map,a=0;for(const h in e)o.set(h,a++)}if(a=o.get(n),e[l]=c,a==null&&s)a=o.size;else{d=d||[],a=(a||0)+s;for(const h of o){const[f,g]=h;a<=g&&(d&&(d[o.size-g-1]=f),o.set(f,g+1))}if(d)for(;d.length;){const h=d.pop(),f=e[h];delete e[h],e[h]=f}}o.set(l,a)}}return e}static setPath(e,t,r){return t.split(".").reduce((n,s,a,o)=>a===o.length-1?n[s]=r:(n[s]instanceof Object||(n[s]={}),n[s]),e),e}static typeOf(e){let t,r;return e===null?r="null":e!==e?r="nan":(r=typeof e,r==="object"?e.isBase?r="instance":Array.isArray(e)?r="array":(r=YD[t=oA.call(e)])||(YD[t]=r=t.slice(8,-1).toLowerCase()):r==="function"&&e.isBase&&(r="class")),r}};Object.defineProperty(X,"hasOwn",{value:Object.hasOwn||((i,e)=>sA.call(i,e))}),X._$name="Objects";var XD,ZD,QD,JD,eE=/([a-z])([A-Z])/g,cA=/[\n\r]/g,uA=/[.*+?^${}()|[\]\\]/g,hA=/[&<]/,fA=/(^[^a-z]+[^\w]+)/gi,gA=/\s+/,mA=/^[^a-z]+|[^\w:.-]+/gi,pA=(i,e)=>ZD[e.toLowerCase()]||String.fromCharCode(parseInt(e.substr(2),10)),vA=(i,e)=>XD[e],yA=(i,e,t)=>`${e}-${t.toLowerCase()}`,bA=(i,e,t)=>`${e} ${t.toLowerCase()}`,CA=i=>i?`_x${[...i].map(e=>e.charCodeAt(0).toString(16)).join("")}`:"__blank__",tE={},iE={},Os=[],Xv=class Fs{static circularReplacer(e,t){if(t!=null&&t.isBase)return t.id;if(t&&typeof t=="object"){for(;Os.length&&Os[Os.length-1]!==this;)Os.pop();if(Os.includes(t))return"[Circular]";Os.push(t)}return t}static capitalize(e){return e&&e[0].toUpperCase()+e.substr(1)}static uncapitalize(e){return e&&e[0].toLowerCase()+e.substr(1)}static hyphenate(e){const t=tE[e];return t||(tE[e]=e.replace(eE,yA))}static hyphenateAttributeName(e){return/^(data|aria)[A-Z]/.test(e)?e.replace(/^(data|aria)([A-Z])/,(t,r,n)=>`${r}-${n}`).replace(/([a-z0-9])([A-Z])/g,"$1-$2").toLowerCase():e}static separate(e){const t=iE[e];return t||(iE[e]=this.capitalize(e.replace(eE,bA)))}static createId(e){return String(e).replace(fA,CA)}static makeValidDomId(e,t=""){return e==null?null:String(e).replace(mA,t)}static escapeRegExp(e,t){let r=e.replace(uA,"\\$&");return t!==void 0&&(r=new RegExp(r,t)),r}static decodeHtml(e){return e&&String(e).replace(JD,pA)}static encodeHtml(e=""){return e&&String(e).replace(QD,vA)}static encodeHtmlBR(e){var t;return(t=Fs.encodeHtml(e))==null?void 0:t.replace(cA,"<br>")}static isHtml(e){return typeof e=="string"&&hA.test(e||"")}static initHtmlEntities(e){e=e||{"&":"&amp;",">":"&gt;","<":"&lt;",'"':"&quot;","'":"&#39;"};const t=Object.keys(e);XD=e,ZD=t.reduce((r,n)=>(r[e[n]]=n,r),{}),QD=new RegExp(`([${t.map(r=>"[-]".includes(r)?"\\"+r:r).join("")}])`,"g"),JD=new RegExp(`(${Object.values(e).join("|")}|&#[0-9]+;)`,"ig")}static safeJsonParse(e){let t=null;try{t=JSON.parse(e)}catch(r){}return t}static safeJsonStringify(e,t=null,r=null){let n=null;try{t==="circular"&&(Os.length=0,t=this.circularReplacer),n=JSON.stringify(e,t,r)}catch(s){}return n}static joinPaths(e,t="/"){return e.join(t).replace(new RegExp("\\"+t+"+","g"),t)}static split(e,t=gA){let r=e;return typeof r=="string"&&(r=e.trim(),r=r?r.split(t):[]),r}static xss(e,...t){const r=[];let n=t.length;for(r[n]=e[n];n-- >0;)r[n]=e[n]+Fs.encodeHtml(t[n]);return r.join("")}static xssBR(e,...t){const r=[];let n=t.length;for(r[n]=e[n];n-- >0;)r[n]=e[n]+Fs.encodeHtmlBR(t[n]);return r.join("")}static toJavaScriptValue(e,t){const r=X.typeOf(e);if(r==="boolean"||r==="string"||r==="number"||e===null)return Fs.safeJsonStringify(e);if(e===globalThis)return"window";if(r==="date")return`new Date(${e.getFullYear()}, ${e.getMonth()}, ${e.getDate()}, ${e.getHours()}, ${e.getMinutes()}, ${e.getSeconds()}, ${e.getMilliseconds()})`;if(r==="array")return`[${e.map(n=>Fs.toJavaScriptValue(n,t))}]`;if(r==="object"||r==="instance")return this.toJavaScriptString(e,t);if(r==="function"){let n=e.toString();return n.match(/^async (\w+?)\(/)?n=n.replace(/^async (\w+?)\(/,"async function("):!n.startsWith("async(")&&n.match(/^(\w+?)\(/)&&(n=n.replace(/^(\w+?)\(/,"function(")),n}if(r==="class")return e.toJavaScriptValue?e.toJavaScriptValue(t):Object.prototype.hasOwnProperty.call(e,"$name")?e.$name:e.name}static toJavaScriptString(e,t={}){var r;const n=(r=t.level)!=null?r:0,s=2;return`{
`+Object.keys(e).map(a=>" ".repeat((n+1)*s)+(a.match(/[- *]/)?`"${a}"`:a)+`: ${Fs.toJavaScriptValue(e[a],{...t,level:n+1})}`).join(`,
`)+`
`+" ".repeat(n*s)+"}"}static encodeAttributeSelector(e,t){return`[${e}="${String(t).replace(/["\\]/g,"\\$&")}"]`}static generateUUID(){var e;return Y.supportsRandomUUID?globalThis.crypto.randomUUID():(e=globalThis.crypto)!=null&&e.getRandomValues?("10000000-1000-4000-8000"+-1e11).replace(/[018]/g,t=>(t^globalThis.crypto.getRandomValues(new Uint8Array(1))[0]&15>>t/4).toString(16)):`${Date.now()}-${++Fs.fakeNodeUUIDIndex}`}};p(Xv,"$name","StringHelper"),p(Xv,"fakeNodeUUIDIndex",0);var k=Xv;k.initHtmlEntities(),ye.register(k),k._$name="StringHelper";var SA=Object.freeze([]),{hasOwn:rE}=X,wA=async(i,e)=>{let t=e;for await(t of i)break;return t},nE=1.005.toFixed(2)==="1.01"?null:(i,e)=>{const t=i.toString().split("."),r=+(t[1]?t.join(".")+"1":t[0]);return i.toFixed.call(r,e)},Zv=(i,e,t,r=[])=>{if(!i||!(X.isObject(i)||Array.isArray(i)))return i;if(t.has(i))return t.get(i);const n=new Proxy(i,{get(s,a,o){return Zv(Reflect.get(s,a,o),e,t,r.concat(a))},set(s,a,o,l){const d=s[a],c=Reflect.set(s,a,Zv(o,e,t,r.concat(a)),l);return c&&d!==o&&e({oldValue:d,path:r.concat(a),newValue:o}),c},deleteProperty(s,a){const o=s[a],l=Reflect.deleteProperty(s,a);return l&&e({oldValue:o,path:r.concat(a),deleted:!0}),l}});return t.set(i,n),n},sE=class Dg extends X{static observeObject(e,t){return Zv(e,t,new WeakMap)}static filter(e,t){let r=null,n,s,a,o;if(e){r=Object.getPrototypeOf(e)?{}:Object.create(null),a=Array.isArray(e)?e:[e];for(s of a)for(n in s)t(o=s[n],n,s)&&(r[n]=o)}return r}static forEach(e,t){let r;if(e)if(Array.isArray(e))e.forEach(t);else for(r in e)t(e[r],r)}static transformArrayToNamedObject(e,t="ref"){const r={};return e.forEach((n,s)=>{const a=n[t]!=null&&n[t].toString().length?n[t]:s;r[a]=n}),r}static transformNamedObjectToArray(e,t="ref"){return Object.keys(e).filter(r=>e[r]).map(r=>{const n=e[r];return n[t]=r,n})}static isEqual(e,t,r=!1,n=!1){if(e===t)return!0;if(e==null||t==null)return n&&e==t;if(e.isModel&&t.isModel)return e.equals(t);if(e.isBase||t.isBase)return!1;const s=Array.isArray(e)+Array.isArray(t);if(s)return s===2&&e.length===t.length&&e.every((l,d)=>ii.isEqual(l,t[d],r));if(e instanceof Date&&t instanceof Date)return e.getTime()===t.getTime();const a=typeof e;return a===typeof t&&a==="object"&&e.constructor.prototype===t.constructor.prototype?r?ii.isDeeplyEqual(e,t,r):ye.String.safeJsonStringify(e,"circular")===ye.String.safeJsonStringify(t,"circular"):String(e)===String(t)}static isDeeplyEqual(e,t,r={}){if(e===t)return!0;if(!e||!t)return!1;const n=ii.keys(e,r.ignore),s=ii.keys(t,r.ignore);if(n.length!==s.length)return!1;for(let a=0;a<n.length;a++){const o=n[a],l=s[a];if(o!==l)return!1;const d=e[o],c=t[l];if(!(r.shouldEvaluate&&r.shouldEvaluate(o,{value:d,object:e},{value:c,object:t})===!1)){if(r.evaluate){const u=r.evaluate(o,{value:d,object:e},{value:c,object:t});if(u===!1)return!1;if(u===!0)continue}if(!ii.isEqual(d,c,r))return!1}}return!0}static isPartial(e,t){return e=String(e).toLowerCase(),t=String(t).toLowerCase(),e.indexOf(t)!==-1}static isLessThan(e,t){return e instanceof Date&&t instanceof Date?ye.Date.isBefore(e,t):e<t}static isMoreThan(e,t){return e instanceof Date&&t instanceof Date?ye.Date.isAfter(e,t):e>t}static first(e,t){let r=t,n;if(e){if(e[Symbol.iterator])for(r of e)break;else if(e[Symbol.asyncIterator])r=wA(e,t);else if(Dg.isObject(e)){r===void 0&&(r=SA);for(n in e){r=[n,e[n]];break}}}return r}static fork(e){let t,r,n;if(e&&e.constructor===Object){t=Object.create(e);for(r in e)n=e[r],n&&(n.constructor===Object?t[r]=ii.fork(n):n instanceof Array&&(t[r]=n.slice()))}else t=e;return t}static copyProperties(e,t,r){let n,s;for(s=0;s<r.length;s++)n=r[s],n in t&&(e[n]=t[n]);return e}static copyPropertiesIf(e,t,r){if(t)for(const n of r)!(n in e)&&n in t&&(e[n]=t[n]);return e}static copyPropertiesExcept(e,t,r){if(t)for(const n in t)r!=null&&r[n]||(e[n]=t[n]);return e}static entries(e,t){const r=[],n=typeof t=="function";if(e)for(const s in e)(n?!t(s,e[s]):!(t!=null&&t[s]))&&r.push([s,e[s]]);return r}static fromEntries(e,t){if(t=t||{},e)for(let r=0;r<e.length;++r)t[e[r][0]]=e[r][1];return t}static keys(e,t,r){const n=[],s=typeof t=="function";if(e){let a=0;for(const o in e)(s?!t(o,e[o]):!(t!=null&&t[o]))&&(n.push(r?r(o,a):o),++a)}return n}static values(e,t,r){const n=[],s=typeof t=="function";if(e){let a=0;for(const o in e)(s?!t(o,e[o]):!(t!=null&&t[o]))&&(n.push(r?r(e[o],a):e[o]),++a)}return n}static pathExists(e,t){return t.split(".").every(n=>!e||!(n in e)?!1:(e=e[n],!0))}static pathifyKeys(e,t){const r={};for(const n in e)if(rE(e,n)){const s=t==null?void 0:t[n],a=(s==null?void 0:s.type)==="object"||(s==null?void 0:s.complexMapping)||!t;if(a&&Array.isArray(e[n]))r[n]=e[n].slice();else if(a&&e[n]instanceof Object){const o=this.pathifyKeys(e[n]);for(const l in o)r[`${n}.${l}`]=o[l]}else r[n]=e[n]}return r}static deletePath(e,t){t.split(".").reduce((r,n,s,a)=>{if(r==null)return null;if(rE(r,n))if(s===a.length-1)delete r[n];else return r[n]},e)}static coerce(e,t){const r=X.typeOf(e),n=X.typeOf(t),s=typeof e=="string";if(r!==n)switch(n){case"string":return String(e);case"number":return Number(e);case"boolean":return s&&(!e||e==="false"||e==="0")?!1:!!e;case"null":return s&&(!e||e==="null")?null:!1;case"undefined":return s&&(!e||e==="undefined")?void 0:!1;case"date":return s&&isNaN(e)?ye.Date.parse(e):Date(Number(e))}return e}static wrapProperty(e,t,r,n,s=!0){const a={};let o=Object.getPrototypeOf(e),l=Object.getOwnPropertyDescriptor(o,t);for(;!l&&o&&s;)o=Object.getPrototypeOf(o),o&&(l=Object.getOwnPropertyDescriptor(o,t));l?(l.set?a.set=d=>{l.set.call(e,d),n&&n.call(e,l.get.call(e))}:a.set=n,l.get?a.get=()=>{let d=l.get.call(e);return r&&(d=r.call(e,d)),d}:a.get=r):(a.set=d=>{e[`_${t}`]=d,n&&n.call(e,d)},a.get=()=>{let d=e[`_${t}`];return r&&(d=r.call(e,d)),d}),Object.defineProperty(e,t,a)}static hookProperty(e,t,r){const n=Dg.getPropertyDescriptor(r.prototype,"value"),s=Dg.getPropertyDescriptor(e,t),a=`_${t}`,o=class{get value(){return s?s.get.call(this):this[a]}set value(d){s?s.set.call(this,d):this[a]=d}},l=Dg.getPropertyDescriptor(o.prototype,"value");return Object.setPrototypeOf(r.prototype,o.prototype),Object.defineProperty(e,t,{configurable:!0,get:n.get||l.get,set:n.set||l.set}),()=>delete e[t]}static cleanupProperties(e,t=!1){return Object.entries(e).forEach(([r,n])=>{t?n===void 0&&delete e[r]:n==null&&delete e[r]}),e}static removeAllProperties(e){return Object.keys(e).forEach(t=>delete e[t]),e}static assertType(e,t,r){const n=X.typeOf(e);if(e!=null&&n!==t)throw new Error(`Incorrect type "${n}" for ${r}, expected "${t}"`)}static assertObject(e,t){ii.assertType(e,"object",t)}static assertInstance(e,t){ii.assertType(e,"instance",t)}static assertClass(e,t){ii.assertType(e,"class",t)}static assertFunction(e,t){if(typeof e!="function"||e.isBase||e.$$name)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a function)`)}static assertNumber(e,t,r){const n=Number(e);if(typeof e!="number"||isNaN(n)||r&&e<0)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a ${r?"positive ":""}Number)`)}static assertBoolean(e,t){ii.assertType(e,"boolean",t)}static assertString(e,t){ii.assertType(e,"string",t)}static assertArray(e,t){ii.assertType(e,"array",t)}static toFixed(e,t){return nE?nE(e,t):e.toFixed(t)}static roundTo(e,t=1){return Math.round(e/t)*t}static round(e,t){if(t==null)return e;const r=10**t;return Math.round(e*r)/r}static getMapPath(e,t,r){const n=Array.isArray(t)?t:typeof t=="string"?t.split("."):[t],s=n.length===1,a=n[0],o=e.has(a)?e.get(a):e.set(a,s?r:{}).get(a);return s?o:ii.getPathDefault(o,n.slice(1),r)}};p(sE,"$name","ObjectHelper");var T=sE;ye.register(T);var ii=T;T._$name="ObjectHelper";var aE=class Vv{static setVersion(e,t){e=e.toLowerCase(),Ci[e]={version:t,isNewerThan(s){return Vv.semanticCompareVersion(s,t,"<")},isOlderThan(s){return Vv.semanticCompareVersion(s,t,">")}};let r="";typeof productName!="undefined"&&(r=`${productName}.`);const n=`${r}${e}${t.replace(/\./g,"-")}`;if(Y.isBrowserEnv&&!globalThis.bryntum.silenceBundleException)if(globalThis.bryntum[n]===!0)if(this.isTestEnv)globalThis.BUNDLE_EXCEPTION=!0;else{let s=r||e;s==="core"&&(s="grid");let a=k.capitalize(s);throw s==="schedulerpro"&&(a="SchedulerPro"),new Error(`The Bryntum ${a} bundle was loaded multiple times by the application.

Common reasons you are getting this error includes:

* Imports point to different types of the bundle (e.g. *.module.js and *.umd.js)
* Imports point to both sources and bundle
* Imports do not use the shortest relative path, JS treats them as different files
* Cache busters differ between imports, JS treats ${s}.module.js?1 and ${s}.module.js?2 as different files
* Imports missing file type, verify they all end in .js

See https://bryntum.com/products/${s}/docs/guide/${a}/gettingstarted/es6bundle#troubleshooting for more information

`)}else globalThis.bryntum[n]=!0}static getVersion(e){if(e=e.toLowerCase(),!Ci[e])throw new Error([`No version specified for the "${e}" product!`,"Please check that you import VersionHelper correctly into the class from where you call `deprecate` function."].join(`
`));return Ci[e].version}static semanticCompareVersion(e,t,r="="){e=e||"",t=t||"";const n=e.split(/[-.]/),s=t.split(/[-.]/),a=r.includes("<"),o=(d,c)=>{const u=["rc","beta","alpha"],h=d.map(f=>{if(u.includes(f))return-u.indexOf(f)-2;const g=Number.parseInt(f);return Number.isNaN(g)?-u.length:g});for(;h.length<c;)h.push(-1);return h},l=()=>{const d=Math.max(n.length,s.length),c=o(n,d),u=o(s,d);for(let h=0;h<d;h++)if(c[h]!==u[h])return a?c[h]<u[h]:c[h]>u[h];return!0};switch(r){case"=":return e===t;case"<=":case">=":return e===t||l();case"<":case">":return e!==t&&l()}return!1}static checkVersion(e,t,r){return Vv.semanticCompareVersion(Ci.getVersion(e),t,r)}static deprecate(e,t,r){if(Ci.checkVersion(e,t,"<"))console.warn(`Deprecation warning: You are using a deprecated API which will change in v${t}. ${r}`);else throw new Error(`Deprecated API use. ${r}`)}static get isTestEnv(){var e,t,r;const n=!!((e=globalThis.bryntum)!=null&&e.isTestEnv);try{return n||!!((r=(t=globalThis.parent)==null?void 0:t.bryntum)!=null&&r.isTestEnv)}catch(s){return n}}static get isDebug(){return!1}};p(aE,"$name","VersionHelper");var te=aE,Ci=te;Y.isBrowserEnv&&(Ci.isTestEnv&&(Y._isHoverableDevice=!0),globalThis.bryntum=Object.assign(globalThis.bryntum||{},{getVersion:Ci.getVersion.bind(Ci),checkVersion:Ci.checkVersion.bind(Ci),deprecate:Ci.deprecate.bind(Ci),license:"9c07f388-a9e9-11ec-9e5c-d094663d5c88"})),ye.register(te),te._$name="VersionHelper";var oE=/,\s*/,Qv=Symbol("decompiled"),DA=/^\s*(async\s+)?([a-z_]\w*)\s*=>([\s\S]+)$/i,EA=/^\s*(async\s*)?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)\s+=>([\s\S]+)$/i,xA=/^(\s*async)?(?:\s*function)?(?:\s*([a-z_]\w*))?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)([\s\S]+)$/i,{hasOwnProperty:RA}=Object.prototype,lE=class TD{static after(e,t,r,n,s){const a=typeof r=="string",o=(s==null?void 0:s.return)!==!1,l=(...d)=>{const c=l.$nextHook.call(e,...d),u=n!=null&&n.isDestroyed?void 0:o?a?n[r](c,...d):r.call(n,c,...d):a?n[r](...d):r.call(n,...d);return u===void 0?c:u};return TD.hookMethod(e,t,l)}static before(e,t,r,n){const s=typeof r=="string",a=(...o)=>{const l=n!=null&&n.isDestroyed?0:s?n[r](...o):r.call(n,...o);return l===!1?l:a.$nextHook.call(e,...o)};return TD.hookMethod(e,t,a)}static curry(e){return function t(...r){return r.length>=e.length?e.apply(this,r):function(...n){return t.apply(this,r.concat(n))}}}static bindAll(e){for(const t in e)typeof e[t]=="function"&&(e[t]=e[t].bind(e))}static createInterceptor(e,t,r){return function(...n){const s=r||this;return t.call(s,...n)!==!1?e.call(s,...n):!1}}static createSequence(e,t,r,n){return function(...s){const a=e.call(r=r||this,...s),o=t.call(n||r,...s);return o===void 0?a:o}}static createThrottled(e,t,r,n,s){let a=-Number.MAX_VALUE,o,l;const d=()=>{l=0,a=performance.now(),o.push.apply(o,n),e.apply(r,o)},c=function(...u){const h=performance.now()-a;o=u,h>=t?(clearTimeout(l),d()):(l||(l=setTimeout(d,t-h)),s&&(o.push.apply(o,n),s.apply(r,o)))};return c.cancel=()=>clearTimeout(l),c}static createBuffered(e,t,r,n){let s,a;const o=()=>{a=0,l.isPending=!1,s.push.apply(s,n),e.apply(r,s)},l=function(...d){s=d,a&&clearTimeout(a),l.isPending=!0,a=setTimeout(o,t)};return l.cancel=()=>{l.isPending=!1,clearTimeout(a)},l}static decompile(e){if(!(Qv in e)){const t=e.toString();let r=DA.exec(t),n,s,a,o,l;r?(n=[r[2]],s=r[3]):(r=EA.exec(t))?(l=r[2].trim(),n=l?l.split(oE):[],s=r[3]):(r=xA.exec(t))&&(a=r[2],l=r[3].trim(),n=l?l.split(oE):[],s=r[4]),s=s==null?void 0:s.trim(),e[Qv]=o=r&&{args:n,async:!!r[1],body:s!=null&&s.startsWith("{")?s.substring(1,s.length-1).trim():s},a&&(o.name=a)}return e[Qv]}static hookMethod(e,t,r){return r.$nextHook=e[t],e[t]=r,()=>{var n;if(RA.call(e,t)){let s=e[t],a;if(s===r)((n=Object.getPrototypeOf(e))==null?void 0:n[t])===r.$nextHook?delete e[t]:e[t]=r.$nextHook;else for(;a=s==null?void 0:s.$nextHook;s=a)if(a===r){s.$nextHook=r.$nextHook;break}}}}static noThrow(e,t,r){const n=e[t];e[t]=(...s)=>{try{return n.apply(e,s)}catch(a){return r==null?void 0:r(a)}}}static returnTrue(){return!0}static animate(e,t,r,n="linear"){let s=!1;const a=new Promise(o=>{const l=performance.now(),d=()=>{const c=Math.min((performance.now()-l)/e,1),u=r!=null&&r.setTimeout?r:globalThis;s||t.call(r,this.easingFunctions[n](c))===!1&&o(),s||c===1?u.requestAnimationFrame(()=>o()):u.requestAnimationFrame(d)};d()});return a.cancel=()=>(s=!0,a.cancelled=!0,!1),a}static getAbortController(){return typeof AbortController=="undefined"?{abort:()=>{}}:AbortController}static abortablePromise(e,t){t=t||new(this.getAbortController());const r=t.signal;return{promise:new Promise((s,a)=>{if(r.aborted){a(r.reason);return}function o(){a(r.reason)}r.addEventListener("abort",o),e((...l)=>{r.removeEventListener("abort",o),s(...l)},(...l)=>{r.removeEventListener("abort",o),a(...l)},r)}),controller:t}}};p(lE,"$name","FunctionHelper");var we=lE;ye.register(we);var Ve=.5,vn=1.70158,Si=7.5625,Mg=1.525,Jv=2/2.75,ey=2.25/2.75,ty=1/2.75,iy=1.5/2.75,ry=2.5/2.75,ny=2.625/2.75,sy=.75,ay=.9375,oy=.984375,TA=1.70158,MA=1.70158;we.easingFunctions={linear:i=>i,easeInQuad:i=>Math.pow(i,2),easeOutQuad:i=>-(Math.pow(i-1,2)-1),easeInOutQuad:i=>(i/=Ve)<1?Ve*Math.pow(i,2):-Ve*((i-=2)*i-2),easeInCubic:i=>Math.pow(i,3),easeOutCubic:i=>Math.pow(i-1,3)+1,easeInOutCubic:i=>(i/=Ve)<1?Ve*Math.pow(i,3):Ve*(Math.pow(i-2,3)+2),easeInQuart:i=>Math.pow(i,4),easeOutQuart:i=>-(Math.pow(i-1,4)-1),easeInOutQuart:i=>(i/=Ve)<1?Ve*Math.pow(i,4):-Ve*((i-=2)*Math.pow(i,3)-2),easeInQuint:i=>Math.pow(i,5),easeOutQuint:i=>Math.pow(i-1,5)+1,easeInOutQuint:i=>(i/=Ve)<1?Ve*Math.pow(i,5):Ve*(Math.pow(i-2,5)+2),easeInSine:i=>-Math.cos(i*(Math.PI/2))+1,easeOutSine:i=>Math.sin(i*(Math.PI/2)),easeInOutSine:i=>-Ve*(Math.cos(Math.PI*i)-1),easeInExpo:i=>i===0?0:Math.pow(2,10*(i-1)),easeOutExpo:i=>i===1?1:-Math.pow(2,-10*i)+1,easeInOutExpo:i=>i===0?0:i===1?1:(i/=Ve)<1?Ve*Math.pow(2,10*(i-1)):Ve*(-Math.pow(2,-10*--i)+2),easeInCirc:i=>-(Math.sqrt(1-i*i)-1),easeOutCirc:i=>Math.sqrt(1-Math.pow(i-1,2)),easeInOutCirc:i=>(i/=Ve)<1?-Ve*(Math.sqrt(1-i*i)-1):Ve*(Math.sqrt(1-(i-=2)*i)+1),easeOutBounce:i=>i<ty?Si*i*i:i<Jv?Si*(i-=iy)*i+sy:i<ry?Si*(i-=ey)*i+ay:Si*(i-=ny)*i+oy,easeInBack:i=>i*i*((vn+1)*i-vn),easeOutBack:i=>(i=i-1)*i*((vn+1)*i+vn)+1,easeInOutBack:i=>{let e=TA;return(i/=Ve)<1?Ve*(i*i*(((e*=Mg)+1)*i-e)):Ve*((i-=2)*i*(((e*=Mg)+1)*i+e)+2)},elastic:i=>-1*Math.pow(4,-8*i)*Math.sin((i*6-1)*(2*Math.PI)/2)+1,swingFromTo:i=>{let e=MA;return(i/=Ve)<1?Ve*(i*i*(((e*=Mg)+1)*i-e)):Ve*((i-=2)*i*(((e*=Mg)+1)*i+e)+2)},swingFrom:i=>i*i*((vn+1)*i-vn),swingTo:i=>(i-=1)*i*((vn+1)*i+vn)+1,bounce:i=>i<ty?Si*i*i:i<Jv?Si*(i-=iy)*i+sy:i<ry?Si*(i-=ey)*i+ay:Si*(i-=ny)*i+oy,bouncePast:i=>i<ty?Si*i*i:i<Jv?2-(Si*(i-=iy)*i+sy):i<ry?2-(Si*(i-=ey)*i+ay):2-(Si*(i-=ny)*i+oy),easeFromTo:i=>(i/=Ve)<1?Ve*Math.pow(i,4):-Ve*((i-=2)*Math.pow(i,3)-2),easeFrom:i=>Math.pow(i,4),easeTo:i=>Math.pow(i,.25)},we._$name="FunctionHelper";var{defineProperty:Ig,getOwnPropertyDescriptor:dE}=Reflect,{hasOwnProperty:IA,toString:ly}=Object.prototype,dy=Symbol("instanceProperties"),cE=Symbol("configuring"),Do=Symbol("lazyConfigValues"),uE=ly.call(new Date),_A=/\s+/,hE=Object.hasOwn||((i,e)=>IA.call(i,e)),fE=(i,e)=>i===e?!0:i&&e&&ly.call(i)===uE&&ly.call(e)===uE?i.getTime()===e.getTime():!1,cy=(i,e)=>(i.setHours(0,0,0,0),e&&i.setDate(i.getDate()+e),i),gE={now:()=>new Date,today:()=>cy(new Date),tomorrow:()=>cy(new Date,1),yesterday:()=>cy(new Date,-1)},FA=(i,e)=>(i[e]=1,i),AA=(i,e)=>function(){var t;return(t=this.configObserver)==null||t.get(i,this),e.call(this)},$e=class Co{static get(e,t){const{cache:r}=this,n=r[e]||(r[e]=new Co(e));let s=n,a;return t&&(a=Co.makeCacheKey(e,t),(s=a&&r[a])||(s=n.extend(t),a&&(r[a]=s))),s}constructor(e){const t=this,r=e[0].toUpperCase()+e.substr(1);t.base=t,t.name=e,t.field="_"+e,t.capName=r,t.changer="change"+r,t.initializing="initializing"+r,t.updater="update"+r,t.updaterResult=`${e}Updated`}get descriptor(){let e=this._descriptor;return(!e||!hE(this,"_descriptor"))&&(this._descriptor=e=this.makeDescriptor()),e}get initDescriptor(){let e=this._initDescriptor;return(!e||!hE(this,"_initDescriptor"))&&(this._initDescriptor=e=this.makeInitter()),e}convert(e,t){return e}equal(e,t){return e===t}extend(e){const t=Object.assign(Object.create(this),e),{convert:r,equal:n,merge:s}=e,{convertMethods:a,equalityMethods:o}=Co;return typeof r=="string"&&!(t.convert=a[r])&&r.endsWith("[]")&&(t.convert=a[r]=Co.makeArrayConvert(a[r.slice(0,-2)])),typeof n=="string"&&!(t.equal=o[n])&&n.endsWith("[]")&&(t.equal=o[n]=Co.makeArrayEquals(o[n.slice(0,-2)])),typeof s=="string"&&(t.merge=Co.mergeMethods[s]),t}define(e){const{name:t}=this,r=dE(e,t);let n=this.descriptor;r!=null&&r.get&&(n=Object.assign({},n),n.get=AA(t,r.get)),Ig(e,t,n)}defineInitter(e,t){const r=this,{name:n}=r,s=e[dy];let a,o;!s[n]&&(o=dE(e,n))&&!("value"in o)&&(s[n]=o),Ig(e,n,r.initDescriptor),r.lazy&&(a=e[Do]||(e[Do]=new Map),a.set(n,t))}static makeArrayConvert(e){return function(t,r){return t!=null&&(Array.isArray(t)?t=t.map((n,s)=>e.call(this,n,r)):t=[e.call(this,t,r)]),t}}static makeArrayEquals(e){return(t,r)=>{let n,s=t&&r&&t.length===(n=r.length);if(s&&Array.isArray(t)&&Array.isArray(r))if(e)for(;s&&n-- >0;)s=e(t[n],r[n]);else for(;s&&n-- >0;)s=t[n]===r[n];else s=e?e(t,r):t===r;return s}}static makeCacheKey(e,t){const r=Object.keys(t).sort();for(let n,s,a,o=r.length;o-- >0;)if(a=t[n=r[o]],a==null&&a===!1)r.splice(o,1);else{if(s=typeof a,s==="function")return null;s==="string"?r[o]=`${n}:"${a}"`:s==="number"&&(r[o]=`${n}:${a}`)}return r.length?`${e}>${r.join("|")}`:e}makeDescriptor(){const{base:e,field:t,changer:r,updater:n,name:s,updaterResult:a}=this;return e!==this?e.descriptor:{get(){var o;return(o=this.configObserver)==null||o.get(s,this),this[t]},set(o){var l,d;const c=this,u=o,h=c.$meta.configs[s];let f=c[t],g,m;if(typeof o=="string"){let v=o;o.startsWith("up.")?v=(l=c.owner)==null?void 0:l.resolveProperty(o.slice(3)):o.startsWith("this.")&&(v=c.resolveProperty(o.slice(5))),v!==void 0&&typeof v!="function"&&(o=v)}h.convert!==mE&&(o=h.convert(o,c)),c[r]&&(g=(m=c[r](o,f))===void 0&&1,g||(o=m,f=c[t])),!g&&!(h.equal===pE?f===o:h.equal(f,o))&&(c[t]=o,g=2,c[a]=(d=c[n])==null?void 0:d.call(c,o,f)),g&&!c.isDestroyed&&!c.onConfigChange.$nullFn&&c.onConfigChange({name:s,value:o,was:f,config:h,applied:g,origPassedValue:u})}}}makeInitter(){const e=this;return e!==e.base?e.lazy?e.makeLazyInitter():e.base.initDescriptor:e.makeBasicInitter()}makeBasicInitter(){const e=this,{initializing:t,name:r}=e;return{configurable:!0,get(){const n=this;return e.removeInitter(n),n[t]=!0,n[r]=n[cE][r],n[t]=!1,n.configDone[r]=!0,n[r]},set(n){e.removeInitter(this),this.configDone[r]=!0,this[r]=n}}}makeLazyInitter(){const e=this,{initializing:t,name:r}=e;return{configurable:!0,get(){const n=this,s=n[Do].get(r);return e.removeInitter(n),n.isDestroying||(n[t]=!0,n[r]=s,n[t]=!1),n[r]},set(n){e.removeInitter(this),this[r]=n}}}removeInitter(e){const{name:t}=this,r=e[dy][t],n=e[Do];r?Ig(e,t,r):delete e[t],n!=null&&n.delete(t)&&!n.size&&delete e[Do]}setDefault(e,t){Ig(e.prototype,this.field,{configurable:!0,writable:!0,value:t})}merge(e,t){if(t&&e&&X.isObject(e)){if(t.isBase)return t.setConfig(e);X.isObject(t)&&(e=X.merge(X.clone(t),e))}return e}},{prototype:nu}=$e,{convert:mE,equal:pE}=nu;$e.symbols={configuring:cE,instanceProperties:dy,lazyConfigs:Do},$e.cache=Object.create(null),$e.convertMethods={array:$e.makeArrayConvert(mE),date(i,e){let t=i,r,n,s;if(gE[i])t=gE[i]();else if(i!=null){if(typeof i!="string")r=new Date(i);else{if(s=this.formats,s){s=s.flatMap(a=>a in e?e[a]:a);for(n of s)if(r=n&&ye.Date.parse(i,n),r)break}r||(r=ye.Date.parse(i))}if(isNaN(r)){if(this.strict)throw new Error(`Invalid date: ${i}`)}else t=r}return t},day(i,e){return i=$e.convertMethods.date.call(this,i,e),i==null||i.setMinutes(0,0,0),i}},$e.equalityMethods={array:$e.makeArrayEquals(),date:fE,day:fE,strict:$e.equal=pE},$e.mergeMethods={distinct(i,e){let t=e?e.slice():[];if(i!=null)if(X.isObject(i))if(e===void 0)t=i;else{let r,n;for(r in i)n=t.indexOf(r),i[r]?n<0&&t.push(r):n>-1&&t.splice(n,1)}else Array.isArray(i)?i.forEach(r=>!t.includes(r)&&t.push(r)):t.includes(i)||t.push(i);return t},merge:$e.merge=nu.merge,classList(i,e){if(typeof i=="string"){if(!i.length)return e;i=i.split(_A)}return Array.isArray(i)&&(i=i.reduce(FA,{})),$e.merge(i,e)},objects(i,e){return i===!0?e||{}:$e.merge(i,e)},replace(i){return i},items(i,e,t,r){return r?X.mergeItems(e,i,{merge:(n,s)=>nu.merge(s,n)}):nu.merge(i,e)}},Object.assign(nu,{_descriptor:null,_initDescriptor:null,date:!1,lazy:!1,nullify:!1,render:!1}),$e._$name="Config";var PA=class{constructor(i,e,t,r){const n=this;let s,a;n.destroyed=!1,n.mapFwd={},n.mapRev={},n.source=i,n.syncing=!1,n.target=e,n.sourceHook=ye.Function.after(i,"onConfigChange",o=>n.onConfigChange(o,!0),n,CE),n.targetHook=r!=null&&r.oneway?null:ye.Function.after(e,"onConfigChange",o=>n.onConfigChange(o,!1),n,CE);for(s in t)a=t[s],a&&(typeof a!="string"&&(a=s),n.mapFwd[s]=a,n.mapRev[a]=s);n.unbind=n.destroy.bind(n),n.unbind.binding=n}destroy(){var i,e;this.destroyed||(this.destroyed=!0,(i=this.sourceHook)==null||i.call(this),(e=this.targetHook)==null||e.call(this))}onConfigChange(i,e){const t=this;(e?t.mapFwd:t.mapRev)[i.name]&&t.sync(e)}sync(i){i=i!==!1;const e=this,[t,r,n]=i?[e.source,e.target,e.mapFwd]:[e.target,e.source,e.mapRev];if(!e.syncing&&!t.isDestroying&&!r.isDestroying){let s=0,a,o,l,d,c,u;e.syncing=!0;for(o in n)d=n[o],l=t[o],l!==r[d]&&(++s,(a||(a={}))[c=d]=u=l);s>1?r.setConfig(a):s&&(r[c]=u),e.syncing=!1}}},vE=class{constructor(i){i&&Object.assign(this,i)}getInherited(i,e=!0){var t;let r=this[i];return i in this||(r=(t=this.super)==null?void 0:t.getInherited(i,e),(r||e)&&(this[i]=r=Object.create(r||null),uy(r,"$meta",{value:this}))),r}},{getPrototypeOf:yE}=Object,{defineProperty:uy}=Reflect,er=(i=>(e,t)=>i.call(e,t))(Object.prototype.hasOwnProperty),_g=Symbol("classMetaData"),bE=Symbol("mixinTag"),hy=Symbol("originalConfig"),Nj=Symbol("createdAt"),tr=$e.symbols.configuring,kA=$e.symbols.instanceProperties,$s=$e.symbols.lazyConfigs,LA={merge:"replace",simple:!0},fy=i=>ye.Object.clone(i),gy=()=>{},OA=i=>new vE(i),su=i=>ye.Object.isObject(i),CE={return:!1},SE={},$A=Object.freeze({}),wE=Object.freeze([]),BA=/^(date|day)(\[])?$/,DE=i=>i&&(i.destroy?i.destroy():Array.isArray(i)&&i.forEach(DE)),O=class Ar{static get isBase(){return!0}get isBase(){return!0}static get declarable(){return["declarable","configurable","defaultConfig","properties","prototypeProperties"]}constructor(...e){const t=this,r=t.constructor;t.$meta.class!==r&&(r.$meta.initialized=!0),t.construct(...e),t.afterConstruct(),t.isConstructing=!1}static new(...e){return e=e.filter(t=>t),e=e.length>1?this.mergeConfigs(...e):e[0],new this(e)}construct(...e){e[0]!==null&&this.configure(...e),this.afterConfigure()}static destroy(...e){DE(e)}destroy(){const e=this,{id:t}=e;e.isDestroying=!0,e.destroy=gy,e.doDestroy(),Object.setPrototypeOf(e,null);for(const r in e)r!=="destroy"&&r!=="isDestroying"&&delete e[r];delete e[hy],e.isDestroyed=!0,e.id=t}destroyMember(e){Ar.destroy(this[e]),this[e]=null}_thisIsAUsedExpression(e){}static get $$name(){return er(this,"$name")&&this.$name||er(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}startConfigure(e){}finishConfigure(e){}afterConfigure(){}afterConstruct(){}animateProperty(e,t,r=1e3,n){const s=t==null,a=this[e]||0,o=(t||0)-a,l=we.animate(r,d=>this[e]=a+o*d,null,n);return s&&l.then(()=>this[e]=null),l}callback(e,t,r=wE){const{handler:n,thisObj:s}=this.resolveCallback(e,t==="this"?this:t)||$A;return n==null?void 0:n.apply(s,r)}resolveProperty(e){let t=this;for(;t;){if(Ar.hasConfigPath(t,e,!0))return ye.Object.getPath(t,e);t=t.owner}}resolveCallback(e,t=this,r=!0){if(e!=null&&e.substring){if(e.endsWith("?")&&(r=!1,e=e.substring(0,e.length-1)),e.startsWith("up.")){for(e=e.substring(3),t=this.owner;t&&!t[e];t=t.owner);if(!t)return}else e.startsWith("this.")&&(e=e.substring(5),t=this);if(!t||!(t instanceof Object))return;e=t[e]}if(typeof e=="function")return{handler:e,thisObj:t};if(r)throw new Error(`No method named ${e} on ${t.$$name||"thisObj object"}`)}bindCallback(e,t=this){if(e){const{handler:r,thisObj:n}=this.resolveCallback(e,t);if(r)return r.bind(n)}}delay(e,t,r=e.name||e){return e=this.setTimeout?e:e.bind(this),(this.setTimeout?this:globalThis)[typeof t=="number"?"setTimeout":"requestAnimationFrame"](e,t,r)}doDestroy(){const e=this,{nullify:t}=e.$meta;if(t)for(let r=0;r<t.length;++r)e[t[r].field]!=null&&(e[t[r].name]=null)}destroyProperties(...e){var t,r;const n=this;let s;for(s of e)s in n&&(!n[tr]||!n[tr][s])&&((r=(t=n[s])==null?void 0:t.destroy)==null||r.call(t),delete n[s])}configure(e={}){const t=this,r=t.$meta,{beforeConfigure:n}=t.initialConfig=e,{configs:s}=r,a=t.getDefaultConfiguration();let o,l,d;t.isConfiguring=!0,Object.assign(t,t.getProperties());for(l in e)d=e[l],o=s[l],a[l]=o?o.merge(d,a[l],null,r):d;n&&(delete a.beforeConfigure,n(t,a)),t.setConfig(t[hy]=a,!0),t.isConfiguring=!1}bindConfigs(e,t,r){const n=new PA(this,e,t,r);return(r==null?void 0:r.sync)!==!1&&n.sync(),n.unbind}getConfig(e,...t){const r=this[e];return t.length?[r,...t.map(n=>this[n])]:r}updateConfiguration(e){var t;const r=this,{configDone:n}=r,{configs:s}=r.$meta,a=r[tr],o=r[$s];r.recompose.suspend();for(const l in e)n[l]?r[l]=e[l]:(t=s[l])!=null&&t.lazy?o.set(l,e[l]):a[l]=e[l];r.recompose.resume(),r.recompose.flush()}setConfig(e,t=!1){var r;const n=this,s=n[tr],a=s?n.configDone:n.configDone={},o=n.$meta.configs,l=n[$s];let d,c;n[kA]={},n[tr]=s?Object.assign(Object.create(s),e):e;for(c in e)d=o[c]||$e.get(c),e[c]!==null||er(e,c)||d.default===null?(l!=null&&l.has(c)||d.defineInitter(n,e[c]),t||(a[c]=!1)):a[c]=!0;t&&n.startConfigure(e);for(c in e)!a[c]&&!(t&&((r=o[c])!=null&&r.lazy))&&(n[c]=e[c]);return s?n[tr]=s:delete n[tr],t&&n.finishConfigure(e),n}hasConfig(e){var t;const r=this,n=r[tr];return!!(r["_"+e]!=null||((t=r[$s])==null?void 0:t.get(e))!=null||!r.configDone[e]&&n&&(n[e]!=null||er(n,e)))}static hasConfigPath(e,t){return t.split(".").every(r=>{var n,s,a;const o=(s=(n=e==null?void 0:e.$meta)==null?void 0:n.configs)==null?void 0:s[r];return(o&&o.descriptor.get===((a=ye.Object.getPropertyDescriptor(e,r))==null?void 0:a.get)?e.hasConfig(r):r in e)?(e=e[r],Object!==void 0):!1})}peekConfig(e){const t=this,r=t[$s],n=t[tr];if(r!=null&&r.has(e))return r.get(e);if(n&&e in n){if(t.configDone[e])return t[e];if(n[e]!=null||er(n,e))return n[e]}}triggerConfig(e){const t=this,{configDone:r}=t,n=t[$s],s=t[tr],a=n!=null&&n.has(e)||s&&(s[e]!=null||er(s,e))?!r[e]:null;return a&&t.getConfig(e),a}triggerConfigs(e){const t=this,r=t.$meta.configs,n=t[$s],s=n?[...n.keys()].filter(a=>r[a].lazy===e):wE;for(const a of s)t.triggerConfig(a);return s.length?s:null}onConfigChange(){}get config(){const e={},t=this[hy];for(const r in t)e[r]=t[r];return e}static processConfigValue(e,t){if(e===globalThis)return globalThis;if(Array.isArray(e))return e.map(r=>Ar.processConfigValue(r,t));if(e instanceof Ar)return t.visited.has(e)?void 0:e.getCurrentConfig(t);if(e instanceof HTMLElement||e instanceof DocumentFragment)return null;if(su(e)){const r={};for(const n in e)n!=="owner"&&(r[n]=Ar.processConfigValue(e[n],t));return r}return e}getConfigValue(e,t){var r;const n=this,s=n[$s];if(!((r=n.$meta.configs[e])!=null&&r.lazy))return Ar.processConfigValue(n[e],t);if(s!=null&&s.has(e))return Ar.processConfigValue(s.get(e),t)}preProcessCurrentConfigs(){}getCurrentConfig(e={}){const t=this,r=e.configs==="all"?t.config:fy(t.initialConfig),n=e.skip||{},s=e.visited||(e.visited=new Set),a=e.depth||(e.depth=0),o={};if(!s.has(t)){s.add(t),this.preProcessCurrentConfigs(r);for(const l in r){if(n[l])continue;const d=t.getConfigValue(l,{...e,depth:a+1});d!==void 0&&(o[l]=d)}return o}}getConfigString(e={}){return ye.String.toJavaScriptString(this.getCurrentConfig(e))}getTestCase(e={}){const t=this.isGantt?"Gantt":this.isSchedulerPro?"SchedulerPro":this.isCalendar?"Calendar":this.isScheduler?"Scheduler":this.isGrid?"Grid":this.isTaskBoard?"TaskBoard":null;if(t){const r=t.toLowerCase(),n=`../../build/${r}.module.js`;let s,a;e.import==="static"?(s=`import * as module from "${n}";Object.assign(window, module);`,a=""):(s=`import("${n}").then(module => { Object.assign(window, module);
`,a="});");const o=te.getVersion(r);return o&&(s+=`
console.log('${t} ${o}');
`),`${s}      
const ${r} = new ${t}(${this.getConfigString(e)});
${a}`}}downloadTestCase(e={}){e.output="return";const t=this.getTestCase(e);ye.Browser.download("app.js","data:application/javascript;charset=utf-8,"+escape(t))}static initClass(){return this.$meta.class}static get $meta(){if(!er(this,_g)){const e=this[_g]=new vE;return e.class=this,this.setupClass(e),e}return this[_g]}static onClassMixedIn(){}static mergeConfigs(e,...t){const r=this.$meta.configs,n=fy(e)||{};let s,a,o,l;for(a=0;a<t.length;++a)if(s=t[a],s)for(o in s)l=s[o],r[o]?l=r[o].merge(l,n[o]):n[o]&&l&&(l=$e.merge(l,n[o])),n[o]=l;return n}static mixin(...e){let t=this,r;for(r=0;r<e.length;++r){const n=e[r],s=n[bE]||(n[bE]=Symbol("mixinTag"));t[s]||(t=n(t),t[s]=!0,er(t,"onClassMixedIn")&&t.onClassMixedIn())}return t}static setupClass(e){var t;const r=e.class,n=yE(r).$meta,s=r.$$name,a=n.names,o=r.prototype;if(uy(o,"$meta",{value:e}),Object.assign(e,{super:n,config:Object.create(n.config),configs:Object.create(n.configs),declarables:n.declarables,forkConfigs:n.forkConfigs,hierarchy:Object.freeze([...n.hierarchy,r]),names:a.includes(s)?a:Object.freeze([...a,s]),properties:n.properties,nullify:(t=n.nullify)==null?void 0:t.slice()}),a!==e.names){const l=`is${s}`,d=c=>{er(c,l)||uy(c,l,{get(){return!0}})};d(o),d(r)}for(let l,d,c=0;c<e.declarables.length;++c)l=e.declarables[c],er(r,l)&&(d=SE[l]||(SE[l]=`setup${ye.String.capitalize(l)}`),r[d](r,e))}static setupConfigs(e,t,r){const n=e.config,s=e.configs,a=e.class,o=e.super;let{nullify:l}=e,d,c,u,h,f,g;for(const m in t)f=t[m],r?(d=s[m])?f=d.merge(f,n[m],e,o):d=$e.get(m,LA):(c=u=h=void 0,f&&typeof f=="object"&&"$config"in f&&(u=f.$config,BA.test(String(u))&&(u={type:u}),u&&(su(u)?u.type&&(u={convert:u.type,equal:u.type,...u},delete u.type):u=ye.Object.createTruthyKeys(u)),h="default"in f,c=h?f.default:c,f="value"in f?f.value:null),(d=s[m])?(g=d.nullify,u&&(d=d.extend(u)),f=d.merge(f,n[m],e,o)):(d=$e.get(m,u),d.define(a.prototype),h=!(d.field in a.prototype),g=!1),h&&d.setDefault(a,c),d.nullify&&!g&&(l||(l=e.nullify||(e.nullify=[]))).push(d)),f&&(su(f)||Array.isArray(f))&&!Object.isFrozen(f)&&(e.forkConfigs=!0),s[m]=d,n[m]=f}static setupConfigurable(e,t){e.setupConfigs(t,e.configurable,!1)}static setupDefaultConfig(e,t){e.setupConfigs(t,e.defaultConfig,!0)}static setupDeclarable(e,t){const r=e.declarable;let n=t.declarables,s,a;for(a=0;a<r.length;++a)n.includes(r[a])||(s||(t.declarables=s=n=n.slice()),n.push(r[a]))}static setupProperties(e,t){t.properties=t.super.properties.slice(),t.properties.push(e),Object.freeze(t.properties)}static setupPrototypeProperties(e){Object.assign(e.prototype,e.prototypeProperties)}static fork(e){let t=e,r,n;if(e&&su(e)&&!Object.isFrozen(e)){t=Object.create(e);for(r in e)n=e[r],n&&(su(n)?t[r]=Ar.fork(n):Array.isArray(n)&&(t[r]=n.slice()))}return t}static getDefaultConfiguration(){return this.$meta.class.prototype.getDefaultConfiguration()}getDefaultConfiguration(){const e=this.$meta,t=e.forkConfigs?Ar.fork(e.config):Object.create(e.config);if(te.isTestEnv&&ye.Browser.isBrowserEnv&&t.testConfig&&globalThis.__applyTestConfigs)for(const r in t.testConfig)t[r]=t.testConfig[r];return t}getProperties(){const e=this.$meta.properties,t={};for(let r=0;r<e.length;r++){const n=Object.getOwnPropertyDescriptor(e[r],"properties");Object.assign(t,n.get!==void 0?e[r].properties:fy(n.value))}return t}static applyDefaults(e){for(const t in e)this.$meta.config[t]=e[t]}static get superclass(){return yE(this)}classHierarchy(e){const t=this.$meta.hierarchy,r=e?t.indexOf(e):0;return r>0?t.slice(r):t}static isOfTypeName(e){return this.$meta.names.includes(e)}detachListeners(...e){const{$detachers:t}=this;if(t){for(let r=0,{length:n}=e,s;r<n;r++)if(s=t[e[r]])for(;s.length;)s.pop()()}}trackDetacher(e,t){const r=this.$detachers||(this.$detachers={});(r[e]||(r[e]=[])).push(t)}untrackDetachers(e){const t=this.$detachers;if(t)for(const r in t){const n=t[r];for(let s=n.length;s-- >0;)n[s].eventer===e&&n.splice(s,1)}}},my=O.prototype;my.onConfigChange.$nullFn=gy.$nullFn=!0,O[_g]=my.$meta=OA({class:O,config:Object.freeze({}),configs:Object.create(null),declarables:O.declarable,forkConfigs:!1,hierarchy:Object.freeze([O]),names:Object.freeze(["Base"]),nullify:null,properties:Object.freeze([]),super:null}),Object.assign(my,{$detachers:null,configObserver:null,isConstructing:!0,isDestroyed:!1,isDestroying:!1}),O.emptyFn=gy,te.setVersion("core","6.3.1"),O._$name="Base";var EE=class RF{static clean(e){return e.reduce((t,r)=>(r!=null&&!(Array.isArray(r)&&r.length===0)&&r!==""&&t.push(r),t),[])}static from(e,t,r){const n=[];if(e)for(const s of e)(!t||t(s))&&n.push(r?r(s):s);return n}static remove(e,...t){let r,n,s=!1;t=t[0]instanceof Set?[...t[0]]:t;for(let a=0;a<t.length;a++)n=t[a],(r=e.indexOf(n))!==-1&&(e.splice(r,1),s=!0);return s}static findInsertionIndex(e,t,r=this.lexicalCompare,n){const s=t.length;let a,o;return n<s&&(a=n>0?r(t[n-1],e):0,o=n<s-1?r(e,t[n]):0,a<1&&o<1)?n:this.binarySearch(t,e,r)}static findLast(e,t,r){for(let{length:n}=e,s=n-1;s>=0;s--)if(t.call(r,e[s],s,e))return e[s]}static binarySearch(e,t,r=0,n=e.length,s=this.lexicalCompare){const a=e.length;let o,l;for(r instanceof Function?(s=r,r=0):n instanceof Function&&(s=n,n=a),--n;r<=n;)o=r+n>>1,l=s(t,e[o]),l>=0?r=o+1:l<0&&(n=o-1);return r}magnitudeCompare(e,t){return e<t?-1:e>t?1:0}lexicalCompare(e,t){return e=String(e),t=String(t),e<t?-1:e>t?1:0}static fill(e,t={},r=null){const n=[],s=Array.isArray(t)?t:[t];for(let a=0;a<e;a++)for(const o of s){const l=Object.assign({},o);r&&r(l,a),n.push(l)}return n}static populate(e,t,r=!1){const n=[];for(let s=0;s<e;s++)n.push(t(s+(r?1:0)));return n}static include(e,...t){for(const r of t)e.includes(r)||e.push(r)}static unique(e){return[...new Set(e)]}static countUnique(e){const t=new Map;for(const r of e){const n=t.get(r);t.set(r,n===void 0?1:n+1)}return[...t.entries()].map(([r,n])=>({value:r,count:n}))}static allowNegative(e){return new Proxy(e,{get(t,r,n){if(typeof r!="string")return Reflect.get(t,r,n);const s=Number(r);return Number.isNaN(s)?Reflect.get(t,r,n):t[s<0?t.length+s:s]},set(t,r,n,s){if(typeof r!="string")return Reflect.set(t,r,n,s);const a=Number(r);return Number.isNaN(a)?Reflect.set(t,r,n,s):(t[a<0?t.length+a:a]=n,!0)}})}static delta(e,t,r=!1){if(!t)return r?{toAdd:e,toRemove:[],toKeep:[]}:{onlyInA:e,onlyInB:[],inBoth:[]};const n=[],s=[],a=new Set,o=new Set(t);for(let l=0;l<e.length;l++){const d=e[l];o.has(d)?a.add(d):n.push(d)}for(let l=0;l<t.length;l++){const d=t[l];a.has(d)||s.push(d)}return r?{toAdd:n,toRemove:s,toKeep:a}:{onlyInA:n,onlyInB:s,inBoth:[...a]}}static asArray(e){return e==null?e:e instanceof Set?Array.from(e):Array.isArray(e)?e:[e]}static identity(e){return e}static keyBy(e,t,r=RF.identity){const n=typeof t=="string"?a=>a==null?void 0:a[t]:t,s=typeof r=="string"?a=>a==null?void 0:a[r]:r;return e.reduce((a,o)=>(a[n(o)]=s(o),a),{})}static aggregate(e,t,r,n,s={}){const a=e.length,o=[];if(!a)return o;const l=e[0].length;s.targetArray=o,s.arrays=e;for(let d=0;d<l;d++)s.entryIndex=d,o.push(n(d,s));for(let d=0;d<a;d++){const c=e[d];s.rowIndex=d;for(let u=0;u<l;u++){s.entryIndex=u;const h=t(c[u],s);o[u]=r(o[u],h,d,u,s)}}return o}static groupBy(e,t){const r=typeof t=="string"?n=>n==null?void 0:n[t]:t;return e.reduce((n,s)=>{const a=r(s);return(n[a]=n[a]||[]).push(s),n},{})}static groupByIndexed(e,t){return e.reduce((r,n)=>{const s=t(n);let a=r.get(s);return a===void 0&&(a=new Set,r.set(s,a)),a.add(n),r},new Map)}static chunkedInsert(e,t,r,n=5e4){const s=r.length/n;for(let a=0;a<s;a++){const o=a*n,l=(a+1)*n;e.splice(t+o,0,...r.slice(o,l))}}static chunkedPush(e,t){for(const r of t)e.push(r)}};p(EE,"$name","ArrayHelper");var L=EE;ye.register(L),L._$name="ArrayHelper";var{isArray:xE}=Array,{hasOwnProperty:HA}=Object.prototype,RE={thisObj:1,detachable:1,once:1,detacher:1,prio:1,args:1,expires:1,buffer:1,throttle:1,name:1,$internal:1},TE=(i,e)=>e.prio-i.prio,ME=(i,e)=>{if(i!==null){if(!i)return e;e&&(i=i?[i]:[],i.push[xE(e)?"apply":"call"](i,e))}return i},Ie=i=>{var e;return e=class extends(i||O){constructor(){super(...arguments),p(this,"eventsSuspended",null)}static get declarable(){return["deprecatedEvents"]}static setupDeprecatedEvents(t,r){const n=r.getInherited("deprecatedEvents"),s=t.deprecatedEvents;for(const a in s)n[a.toLowerCase()]=n[a]=s[a]}static get configurable(){return{listeners:{value:null,$config:{merge:ME}},internalListeners:{value:null,$config:{merge:ME}},bubbleEvents:null}}destroy(){this.trigger("beforeDestroy"),super.destroy()}construct(t,...r){(this.configuredListeners=t==null?void 0:t.listeners)&&(t=X.assign({},t),delete t.listeners),super.construct(t,...r),this.processConfiguredListeners()}processConfiguredListeners(){if(this.configuredListeners){const t=this,{isConfiguring:r}=t;t.isConfiguring=!1,t.listeners=t.configuredListeners,t.configuredListeners=null,t.isConfiguring=r}}doDestroy(){this.trigger("destroy"),this.removeAllListeners(!1),super.doDestroy()}static setupClass(t){super.setupClass(t),e.prototype.onListen.$nullFn=!0,e.prototype.onUnlisten.$nullFn=!0}addListener(t,r,n){var s;if(xE(t)){for(let l=0,{length:d}=t;l<d;l++)this.addListener(t[l],r);return}const a=this,o=a.$meta.getInherited("deprecatedEvents");if(typeof t=="string")return a.addListener({[t]:r,detachable:r.detachable!==!1,thisObj:n});{r=t.thisObj=t.thisObj!==void 0?t.thisObj:r;for(const u in t)if(!RE[u]&&t[u]!=null){const h=u.toLowerCase(),f=o==null?void 0:o[h],g=a.eventListeners||(a.eventListeners={}),m=L.asArray(t[u]);if(f){const{product:v,invalidAsOfVersion:y,message:b}=f;te.deprecate(v,y,b)}for(const v of m){const y=v.expires||t.expires,b={fn:typeof v=="object"?v.fn:v,thisObj:v.thisObj!==void 0?v.thisObj:r,args:v.args||t.args,prio:v.prio!==void 0?v.prio:t.prio!==void 0?t.prio:0,once:v.once!==void 0?v.once:t.once!==void 0?t.once:!1,buffer:v.buffer||t.buffer,throttle:v.throttle||t.throttle,$internal:t.$internal,catchAll:u==="catchAll"};if(y){const{alt:D}=y,w=D?y.delay:y,x=t.name||u,R=()=>{a.un(h,b),D&&!b.called&&a.callback(D,r)};a.isDelayable?a.setTimeout({fn:R,name:x,cancelOutstanding:!0,delay:w}):globalThis.setTimeout(R,w)}let C=g[h]||(g[h]=[]);C.$firing&&(g[h]=C=C.slice()),C.splice(L.findInsertionIndex(b,C,TE,C.length),0,b),!a.onListen.$nullFn&&C.length<2&&a.onListen(h),(s=a.afterAddListener)==null||s.call(a,h,b)}}t.relayAll&&a.relayAll(t.relayAll),r&&r!==a&&a.attachAutoDetacher(t,r);const l=t.detachable!==!1,d=t.name,c=t.expires||l||d?()=>{a.isDestroyed||a.removeListener(t,r)}:null;if(c&&(c.eventer=a,c.listenerName=d,d&&(r!=null&&r.trackDetacher)&&r.trackDetacher(d,c),t.expires&&a.delay(c,isNaN(t.expires)?t.expires.delay:t.expires,d),l))return c}}on(t,r,n){return this.addListener(t,r,n)}ion(t){return t.$internal=!0,this.on(t)}un(...t){return this.removeListener(...t)}updateInternalListeners(t,r){r==null||r.detach(),t&&(t.detach=this.ion(t))}get listeners(){return this.eventListeners}changeListeners(t){if(this.isConfiguring)this.getConfig("internalListeners"),t&&this.on(t,this);else{if(Array.isArray(t))for(let r=0,n=t[0],{length:s}=t;r<s;n=t[++r])"thisObj"in n||(t[r]=X.assign({thisObj:this},n));else t&&!("thisObj"in t)&&(t=X.assign({thisObj:this},t));return t}}updateListeners(t,r){r&&this.un(r),t&&this.on(t)}removeListener(t,r=t.thisObj,n){var s;const a=this;if(typeof t=="string")return a.removeListener({[t]:r},n);let o=!1;for(let l in t){const d=t[l];if(!RE[l]&&d!=null){l=l.toLowerCase();const{eventListeners:c}=a,u=a.findListener(l,d,r);if(u>=0){let h=c[l];(s=a.afterRemoveListener)==null||s.call(a,l,h[u]),o=!0,h.length>1?(h.$firing&&(c[l]=h=h.slice()),h.splice(u,1)):(delete c[l],a.onUnlisten.$nullFn||a.onUnlisten(l))}}}return t.thisObj&&!t.thisObj.isDestroyed&&a.detachAutoDetacher(t),o}findListener(t,r,n){var s;const a=(s=this.eventListeners)==null?void 0:s[t],o=r.fn||r,l=r.thisObj||n;if(a){for(let d,c=0,{length:u}=a;c<u;c++)if(d=a[c],d.fn===o&&d.thisObj===l)return c}return-1}hasListener(t){const{eventListeners:r}=this;return t?!!(r!=null&&r[t.toLowerCase()]):!X.isEmpty(r)}numListeners(t){const{eventListeners:r}=this;return(t?[t.toLowerCase()]:Object.keys(r)).reduce((s,a)=>s+r[a].length,0)}relayAll(t,r,n=!0){this.relayAllTargets||(this.relayAllTargets=[]);const{relayAllTargets:s}=this;t.ion({beforeDestroy:({source:a})=>{a===t&&s.filter(l=>l.through===t).forEach(l=>L.remove(s,l))}}),s.push({through:t,prefix:r,transformCase:n})}removeAllListeners(t=!0){var r;const n=this.eventListeners;let s,a;for(const o in n){const l=n[o];for(s=l.length;s-- >0;){const d=l[s];(!d.$internal||!t)&&(this.removeListener(o,d),a=d.thisObj,(r=a==null?void 0:a.untrackDetachers)==null||r.call(a,this))}}}relayEvents(t,r,n="",s){const a={detachable:!0,thisObj:this};return r.forEach(o=>{n&&(o=k.capitalize(o)),a[o]=(l,...d)=>(s&&(l=Object.assign({},l,{source:this})),this.trigger(n+o,l,...d))}),t.on(a)}onListen(){}onUnlisten(){}destructorInterceptor(){const{autoDetachers:t,target:r,oldDestructor:n}=this;for(let s=0;s<t.length;s++){const{dispatcher:a,config:o}=t[s];a.isDestroyed||a.removeListener(o,r)}n.call(r)}attachAutoDetacher(t,r){const n=t.thisObj||r,s="doDestroy"in n?"doDestroy":"destroy";if(s in n){let{$autoDetachers:a}=n;a||(n.$autoDetachers=a=[]),n.$oldDestructor||(n.$oldDestructor=n[s],n[s]=this.destructorInterceptor.bind({autoDetachers:a,oldDestructor:n.$oldDestructor,target:n})),a.push({config:t,dispatcher:this})}else n[s]=()=>{this.removeListener(t)}}detachAutoDetacher(t){const r=t.thisObj;r.$oldDestructor&&!r.isDestroying&&(L.remove(r.$autoDetachers,r.$autoDetachers.find(n=>n.config===t&&n.dispatcher===this)),r.$autoDetachers.length||(r["doDestroy"in r?"doDestroy":"destroy"]=r.$oldDestructor,r.$oldDestructor=null))}once(t,r){return this.ion({[t]:n=>this.callback(r,this,[n]),once:!0})}await(t,r={checkLog:!0,resetLog:!0,args:null,expires:null}){const n=this;r===!1&&(r={checkLog:!1});const{args:s}=r;return new Promise(a=>{var o;if(r.checkLog&&((o=n._triggered)!=null&&o[t])&&(a(),r.resetLog&&n.clearLog(t)),s){const l=n.on({[t]:(...d)=>{(typeof s=="function"?s(...d):Object.keys(s).every(u=>u in d[0]&&d[0][u]===s[u]))&&(a(...d),r.resetLog&&n.clearLog(t),l())},expires:r.expires,prio:-1e4})}else n.on({[t]:(...l)=>{a(...l),r.resetLog&&n.clearLog(t)},expires:r.expires,prio:-1e4,once:!0})})}clearLog(t){this._triggered&&(t?delete this._triggered[t]:this._triggered={})}trigger(t,r){var n,s,a,o;const l=this,d=t.toLowerCase(),{eventsSuspended:c,relayAllTargets:u,callOnFunctions:h}=l;let f=(n=l.eventListeners)==null?void 0:n[d],g;if(l._triggered||(l._triggered={}),l._triggered[t]=!0,c)return c.shouldQueue&&c.queue.push(arguments),!0;if((s=l.eventListeners)!=null&&s.catchall&&((f=f?f.slice():[]).push(...l.eventListeners.catchall),f.sort(TE)),!f&&!u&&!h)return!0;if(r?"source"in r||(Object.isExtensible(r)?r.source=l:(r=Object.create(r),Object.assign(r,{source:l}))):r={source:l},r.type!==d&&(r.constructor!==Object?Reflect.defineProperty(r,"type",{get:()=>d}):r.type=d),r.eventName=t,!("bubbles"in r)&&((a=l.bubbleEvents)!=null&&a[t])&&(r.bubbles=l.bubbleEvents[t]),h){const v="on"+k.capitalize(t);if(v in l){const y=l[v]?l.callback(l[v],l,[r]):!0;let b;if(X.isPromise(y)?(g||(g=[])).push(y):b=y===!1||b,!l.isDestroyed&&HA.call(l,v)&&!((o=l.pluginFunctionChain)!=null&&o[v])){const C=Object.getPrototypeOf(l);if(v in C){const D=C[v].call(l,r);if(X.isPromise(D)?(g||(g=[])).push(D):b=D===!1||b,l.isDestroyed)return}}if(b)return!1}}let m;if(f){let v=0,y=!1;for(f.$firing=!0,v;v<f.length&&!l.isDestroyed&&!y;v++){const b=f[v];if(m===!1&&!b.$internal)continue;let C,D=b.thisObj;if(!D||!D.isDestroyed){if(b.called=!0,b.once&&l.removeListener(d,b),typeof b.fn=="string"){if(D&&(C=D[b.fn]),!C){const x=l.resolveCallback(b.fn);C=x.handler,D=x.thisObj}}else C=b.fn;if(b.buffer){if(!b.bufferFn){const x=Number(b.buffer);if(typeof x!="number"||isNaN(x))throw new Error(`Incorrect type for buffer, got "${x}" (expected a Number)`);b.bufferFn=we.createBuffered(C,x,D,b.args)}C=b.bufferFn}if(b.throttle){const x=Number(b.throttle);if(typeof x!="number"||isNaN(x))throw new Error(`Incorrect type for throttle, got "${x}" (expected a Number)`);b.throttledFn||(b.throttledFn=we.createThrottled(C,x,D,b.args)),C=b.throttledFn}const w=C.call(D||l,...b.args||[],r);m!==!1&&(m=w),b.$internal&&w===!1&&(y=!0),X.isPromise(w)&&(w.$internal=b.$internal,(g||(g=[])).push(w))}}if(f.$firing=!1,y)return!1}return u==null||u.forEach(v=>{let y=t;if(v.transformCase&&(y=k.capitalize(y)),v.prefix&&(y=v.prefix+y),v.through.trigger(y,r)===!1)return!1}),r.bubbles&&l.owner&&!l.owner.isDestroyed?l.owner.trigger(t,r):(g=g==null?void 0:g.filter(v=>m!==!1||v.$internal),g!=null&&g.length?new Promise(v=>{Promise.allSettled(g).then(y=>{const b=!y.some(C=>C.status==="fulfilled"&&C.value===!1);v(b)})}):m!==!1)}suspendEvents(t=!1){const r=this.eventsSuspended||(this.eventsSuspended={shouldQueue:t,queue:[],count:0});r.count++}resumeEvents(){const t=this.eventsSuspended;if(t&&--t.count===0&&(this.eventsSuspended=null,t.shouldQueue))for(const r of t.queue)this.trigger(...r);return!this.eventsSuspended}},p(e,"$name","Events"),e},yt=class{static animationFrame(){return new Promise(i=>{requestAnimationFrame(i)})}static sleep(i){return new Promise(e=>{setTimeout(()=>{e()},i)})}static waitFor(i,e=6e4,t=100){let r;const n=new Promise((s,a)=>{r=s;let o;const l=()=>{const d=i();if(d)return clearInterval(o),s(d),!0};l()||(o=setInterval(l,t),e&&setTimeout(()=>{clearInterval(o),e>0?a():s()},Math.abs(e)))});return n.resolve=r,n}static yield(){return Promise.resolve()}static async waitForAnimations(i,e=!0){const t=i.getAnimations({subtree:e}),r=t.flatMap(n=>n.effect.getTiming().iterations!==1/0?n.finished:[]);r.length&&await Promise.all(r)}};yt._$name="AsyncHelper";var py,IE=["border-top-width","border-right-width","border-bottom-width","border-left-width"],VA=["margin-top","margin-right","margin-bottom","margin-left"],jA=["padding-top","padding-right","padding-bottom","padding-left"],yn={t:"border-top-width",r:"border-right-width",b:"border-bottom-width",l:"border-left-width"},Fg={t:"padding-top",r:"padding-right",b:"padding-bottom",l:"padding-left"},_E=/^([trblc])(\d*)-([trblc])(\d*)$/i,zA=/^([trblc])(\d*)$/i,Ag=["top","right","bottom","left"],au={t:0,r:1,b:2,l:3},vy=["b-t","l-r","t-b","r-l"],NA={bt:1,tb:1,lr:2,rl:2},FE=Object.freeze([0,0]),WA=["width","height"],yy=(i,e=i,t=i,r=e)=>Array.isArray(i)?yy.apply(null,i):[i,e,t,r],AE=(i,e,t,r)=>Array.isArray(i)?yy.apply(null,i):typeof i.top=="number"?[i.top,i.right,i.bottom,i.left]:[i,e,t,r],PE=(i,e)=>{const t=_E.exec(i),r=t[1],n=t[3],s=parseInt(t[2]||50),a=parseInt(t[4]||50),o=e&&!(au[r]&1)?100-s:s,l=e&&!(au[n]&1)?100-a:a,d=NA[r+n];return{myAlignmentPoint:r+o,myEdge:r,myOffset:o,targetAlignmentPoint:n+l,targetEdge:n,targetOffset:l,startZone:au[n],edgeAligned:d}},UA=i=>`${Ag[(au[i.myEdge]+2)%4][0]}${i.myOffset}-${Ag[(au[i.targetEdge]+2)%4][0]}${i.targetOffset}`,GA=i=>i==null?FE:typeof i=="number"?[i,i]:i,kE={hidden:1,clip:1},$=class ti{constructor(e,t,r,n,s=!0){p(this,"isRectangle",!0),s&&(T.assertNumber(e,"Rectangle.x"),T.assertNumber(t,"Rectangle.y"),T.assertNumber(r,"Rectangle.width",!0),T.assertNumber(n,"Rectangle.height",!0));const a=this;r<0&&(e+=r,r=-r),n<0&&(t+=n,n=-n),a._x=e,a._y=t,a._width=r,a._height=n}static from(e,t,r){if(typeof e=="string"?e=document.querySelector(e):(e==null?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE&&(e=e.host||e.ownerDocument),typeof t=="string"&&(t=document.querySelector(t)),e==null||e.isRectangle)return e;if(e=e.element||e,r===void 0&&typeof t=="boolean"&&(r=t,t=null),!(t!=null&&t.isRectangle))if(t){let{scrollLeft:d,scrollTop:c}=t;Y.isSafari&&t===document.body&&(d=c=0),t=ti.from(t).translate(-d,-c)}else py||(py=new ti(0,0,0,0)),t=py;const n=e===document||e===globalThis,s=e===document.body&&document.body.offsetHeight===0,a=s&&e.getBoundingClientRect(),o=s?new ti(a.left,a.top,a.width,document.body.parentElement.scrollHeight):n?new ti(0,0,globalThis.innerWidth,globalThis.innerHeight):e.getBoundingClientRect(),l=r||n?[0,0]:[globalThis.pageXOffset,globalThis.pageYOffset];return new ti(o.left+l[0]-t.x,o.top+l[1]-t.y,o.width,o.height)}static fromScreen(e,t){return ti.from(e,t,!0)}static inner(e,t,r=!1){const n=this.from(e,t,r);if(document.body.contains(e)){const s=E.getStyleValue(e,IE);n.x+=parseFloat(s[yn.l]),n.y+=parseFloat(s[yn.t]),n.right-=parseFloat(s[yn.r]),n.bottom-=parseFloat(s[yn.b])}return n}static content(e,t,r=!1){const n=this.from(e,t,r);if(document.body.contains(e)){const s=E.getStyleValue(e,IE),a=E.getStyleValue(e,jA);n.x+=parseFloat(s[yn.l])+parseFloat(a[Fg.l]),n.y+=parseFloat(s[yn.t])+parseFloat(a[Fg.t]),n.right-=parseFloat(s[yn.r])+parseFloat(a[Fg.r]),n.bottom-=parseFloat(s[yn.b])+parseFloat(a[Fg.b])}return n}static client(e,t,r=!1,n,s,a=!0){const o=this[a?"content":"inner"](e,t,r),l=E.scrollBarWidth;let d;return l&&!e.classList.contains("b-hide-scroll")&&(e.scrollHeight>e.clientHeight&&!kE[E.getStyleValue(e,"overflow-y")]&&(d=a?parseFloat(E.getStyleValue(e,"padding-inline-end")):0,E.getStyleValue(e,"direction")==="rtl"?o.x+=d+Math.max(d,l):o.right+=d-Math.max(d,l)),e.scrollWidth>e.clientWidth&&!kE[E.getStyleValue(e,"overflow-x")]&&(d=a?parseFloat(E.getStyleValue(e,"padding-bottom")):0,o.bottom+=d-Math.max(d,l))),n&&this.clipStickies(o,e,t,r=!1,s),o}static clipStickies(e,t,r,n=!1,s){let a=[...t.children].filter(o=>E.getStyleValue(o,"position")==="sticky");if(s){const o=s&&ti.from(s,r,n);a=a.filter(l=>!l.contains(s)&&o.intersect(ti.from(l)))}for(let o=0,{length:l}=a;o<l;o++){const d=a[o],c=this.fromScreen(d);parseFloat(E.getStyleValue(d,"left"))===0?e.x+=c.width:parseFloat(E.getStyleValue(d,"right"))===0?e.right-=c.width:parseFloat(E.getStyleValue(d,"top"))===0?e.y+=c.height:parseFloat(E.getStyleValue(d,"bottom"))===0&&(e.bottom-=c.height)}return e}static outer(e,t,r=!1){const n=this.from(e,t,r);if(document.body.contains(e)){const s=E.getStyleValue(e,VA);n.x-=parseFloat(s["margin-left"]),n.y-=parseFloat(s["margin-top"]),n.right+=parseFloat(s["margin-right"]),n.bottom+=parseFloat(s["margin-bottom"])}return n}static union(...e){let{x:t,y:r,right:n,bottom:s}=e[0],a;if(e.length>1)for(let o=1;o<e.length;o++)a=e[o],a.x<t&&(t=a.x),a.y<r&&(r=a.y),a.right>n&&(n=a.right),a.bottom>s&&(s=a.bottom);return new ti(t,r,n-t,s-r)}roundPx(e=globalThis.devicePixelRatio||1){const t=this;return t._x=E.roundPx(t._x,e),t._y=E.roundPx(t._y,e),t._width=E.roundPx(t._width,e),t._height=E.roundPx(t._height,e),t}static get $$name(){return hasOwnProperty.call(this,"$name")&&this.$name||hasOwnProperty.call(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}clone(){const e=this,t=new ti(e.x,e.y,e.width,e.height,!1);return t.isAlignRectangle=e.isAlignRectangle,t.minHeight=e.minHeight,t.minWidth=e.minWidth,t}contains(e){const t=this;return e.isRectangle?e._x>=t._x&&e._y>=t._y&&e.right<=t.right&&e.bottom<=t.bottom:!1}exclude(...e){var t,r;const n=this;let s,a=n.clone();for(s of Array.from(e).flat()){let o,l,d=[0,0,0,0];((o=s.x<=n.x)||s.right>=n.right)&&((t=l=s.intersect(n))==null?void 0:t.height)>=n.height?d[o?3:1]=-l.width:((o=s.y<=n.y)||s.bottom>=n.bottom)&&((r=l=s.intersect(n))==null?void 0:r.width)>=n.width&&(d[o?0:2]=-l.height),a=a.inflate(...d)}return a}intersect(e,t=!1,r=!1){const n=this,s=Math.max(n.y,e.y),a=Math.min(n.right,e.right),o=Math.min(n.bottom,e.bottom),l=Math.max(n.x,e.x);return(r?o>=s&&a>=l:o>s&&a>l)?t?!0:new ti(l,s,a-l,o-s):!1}equals(e,t=!1){const r=t?n=>Math.round(n):n=>n;return e.isRectangle&&r(e.x)===r(this.x)&&r(e.y)===r(this.y)&&r(e.width)===r(this.width)&&r(e.height)===r(this.height)}translate(e,t){return this._x+=e||0,this._y+=t||0,this}moveTo(e,t){return e!=null&&(this._x=e),t!=null&&(this._y=t),this}getDelta(e){return[e.x-this.x,e.y-this.y]}get center(){const e=new Li(this.x+this.width/2,this.y+this.height/2,0,0);return e.target=this.target,e}set x(e){const t=e-this._x;this._x=e,this._width-=t}get x(){return this._x}get start(){return this.left}set left(e){this.x=e}get left(){return this.x}set top(e){this.y=e}get top(){return this.y}set y(e){const t=e-this._y;this._y=e,this._height-=t}get y(){return this._y}set width(e){T.assertNumber(e,"Rectangle.width",!this._allowNegative),this._width=e}get width(){return this._width}set height(e){T.assertNumber(e,"Rectangle.height",!this._allowNegative),this._height=e}get height(){return this._height}set right(e){this._width=e-this._x}get right(){return this._x+this._width}get end(){return this.right}set bottom(e){this._height=e-this._y}get bottom(){return this._y+this._height}getStart(e,t=!0){return t?e?this.right:this.left:this.top}getEnd(e,t=!0){return t?e?this.left:this.right:this.bottom}get area(){return this.width*this.height}set minWidth(e){const t=this;isNaN(e)?t._minWidth=null:(t._minWidth=Number(e),t.isAlignRectangle||(t.width=Math.max(t.width,t._minWidth)))}get minWidth(){return this._minWidth}set minHeight(e){const t=this;isNaN(e)?t._minHeight=null:(t._minHeight=Number(e),t.isAlignRectangle||(t.height=Math.max(t.height,t._minHeight)))}get minHeight(){return this._minHeight}adjust(e,t,r,n,s){const a=this;return a._allowNegative=s,a.x+=e,a.y+=t,a.width+=r,a.height+=n,a}inflate(e,t=e,r=e,n=t){return[e,t,r,n]=AE(e,t,r,n),this.adjust(-n,-e,t,r)}deflate(e,t=e,r=e,n=t){return[e,t,r,n]=AE(e,t,r,n),this.adjust(n,e,-t,-r)}constrainTo(e,t){const r=this,n=r.height,s=r.y,a=r.minWidth||r.width,o=r.minHeight||r.height;if(r.height>=e.height){if(t&&o>e.height)return!1;r._y=e.y,r.height=e.height}if(r.width>=e.width){if(t&&a>e.width)return r.y=s,r.height=n,!1;r._x=e.x,r.width=e.width}return r.translate.apply(r,r.constrainVector=[Math.min(e.right-r.right,0),Math.min(e.bottom-r.bottom,0)]),r.translate(Math.max(e.x-r.x,0),Math.max(e.y-r.y,0)),r}alignTo(e){let t=this.clone(),{target:r,constrainTo:n,constrainPadding:s,inflate:a}=e,o,l,d,c;if(r&&(r=r.isRectangle?r.clone():ti.from(r.element?r.element:r),a&&r.inflate.apply(r,Array.isArray(a)?a:[a])),n){if(!n.isRectangle){c=n===globalThis||n===document;const F="ignorePageScroll"in e?e.ignorePageScroll:!c;n=ti.from(n.element?n.element:n,null,F)}s&&(s=yy(s),s[0]=Math.min(s[0],r.top),s[1]=Math.min(s[1],n.right-r.right),s[2]=Math.min(s[2],n.bottom-r.bottom),s[3]=Math.min(s[3],r.left),n=n.deflate.apply(n.clone(),s))}const u=this,h=GA(e.offset),{align:f,axisLock:g,anchorSize:m,anchorPosition:v,matchSize:y,position:b,rtl:C}=e,D=r&&r.width<2&&r.height<2,w=PE(f,C),x=n&&n.clone(),R=[],M=[{zone:l=w.startZone,align:f}],I=y&&WA[w.startZone&1],_=u[I];if(I&&g?t[I]=y==="min"?Math.max(t.width,r[I]):r[I]:!w.edgeAligned&&y&&(t.width=r.width,t.height=r.height),n&&t.constrainTo(n),n&&w.startZone!=null)if(g)M.push({zone:l=(l+2)%4,align:UA(w)}),g==="flexible"&&(M.push({zone:l=(w.startZone+1)%4,align:vy[l]}),M.push({zone:l=(l+2)%4,align:vy[l]}));else for(let F=1;F<4;F++)M.push({zone:l=(l+1)%4,align:vy[l]});if(v){const F=w.startZone&1?"y":"x";o={[F]:v[F],edge:Ag[(w.startZone+2)%4]}}if(x&&r&&(x.adjust(-r.width,-r.height,r.width,r.height),r.constrainTo(x)),t.minWidth=u.minWidth,t.minHeight=u.minHeight,b)t.moveTo(b.x,b.y),t.translate.apply(t,h),n&&t.constrainTo(n);else{const F=w.myEdge==="c"||w.targetEdge==="c",A=m&&!F?[m[1]+h[0],m[1]+h[1]]:h,P=r.getAlignmentPoint(w.targetAlignmentPoint),V=r.getAlignmentPoint(w.targetAlignmentPoint,A);let B=t.getAlignmentPoint(w.myAlignmentPoint),W=!D&&t.clone().translate(P[0]-B[0],P[1]-B[1]).intersect(r,!0);if(t.translate(V[0]-B[0],V[1]-B[1]),W)t.translate(-(V[0]-B[0]),-(V[1]-B[1])),B=t.getAlignmentPoint(w.myAlignmentPoint),t.translate(P[0]-B[0],P[1]-B[1]),t.translate(...A),n&&t.constrainTo(n),d=w.startZone;else if(n&&!n.contains(t)){const q=t.clone(),G=[];let Z,ne;o=null,R[0]=Z=n.clone(),Z.bottom=r.y-A[1],R[1]=Z=n.clone(),Z.x=r.right+A[0],R[2]=Z=n.clone(),Z.y=r.bottom+A[1],R[3]=Z=n.clone(),Z.right=r.x-A[0];for(let J=0;J<M.length;J++){if(I&&J===2&&(t[I]=_),Z=R[d=M[J].zone],t=t.alignTo({target:r,offsets:A,align:M[J].align}),t.constrainTo(Z,!0)&&(G.push({result:t,zone:d}),!ne||t.width<u.width||t.height<u.height)){t.align=M[J].align;break}if(!ne||Z.area>ne.area){const ee=t.clone();switch(d){case 0:ee.moveTo(null,Z.bottom-ee.height);break;case 1:ee.moveTo(Z.left);break;case 2:ee.moveTo(null,Z.top);break;case 3:ee.moveTo(Z.right-ee.width);break}ne={area:Z.area,result:ee,zone:d}}}G.length?(G.length>1&&!g&&G.sort((J,ee)=>{const Q=Math.sqrt((q.x-J.result.x)**2+(q.y-J.result.y)**2),ae=Math.sqrt((q.x-ee.result.x)**2+(q.y-ee.result.y)**2);return Q-ae}),t=G[0].result,d=G[0].zone):(t=ne.result,d=ne.zone,c&&t.constrainTo(n))}else d=w.startZone;if(D?t.overlap=W=!1:t.overlap=W=t.intersect(r,!0),t.zone=d,m&&!W){if(!o){const q=d&1,G=q?"y":"x",Z=q?"bottom":"right",ne=Math.max(r[G],t[G]),J=Math.min(r[Z],t[Z]);let ee=ne+(J-ne)/2-m[0]/2;const Q=ee+m[0];Q>t[Z]&&(ee-=Q-t[Z]),ee<t[G]&&(ee+=t[G]-ee),o={[G]:ee-t[G],edge:Ag[(d+2)%4]}}t.anchor=o}}return t}getAlignmentPoint(e,t=FE){e=String(e);const r=this,n=zA.exec(e)||_E.exec(e),s=n&&n[1].toLowerCase(),a=n&&Math.min(Math.max(parseInt(n[2]||50),0),100)/100;switch(s){case"t":return[r.x+r.width*a,r.y-t[1]];case"r":return[r.right+t[0],r.y+r.height*a];case"b":return[r.x+r.width*a,r.bottom+t[1]];case"l":return[r.x-t[0],r.y+r.height*a];case"c":return[r.x+r.width/2,r.y+r.height/2]}}highlight(){const e=this,t=E.createElement({parent:document.body,style:`position:absolute;z-index:9999999;pointer-events:none;
                            left:${e.x}px;top:${e.y}px;width:${e.width}px;height:${e.height}px`});return E.highlight(t).then(()=>t.remove())}visualize(e,t=!1,r=!1){const n=this,s=T.merge({style:{width:`${n.width}px`,height:`${n.height}px`,pointerEvents:"none",...e.class?{}:{position:"absolute","z-index":9999999},...r?{insetInlineStart:n.x,top:n.y}:{left:0,top:0,transform:`translate(${n.x}px, ${n.y}px)`}}},e);return t?s:E.createElement(s)}toString(e=","){return[`${this.top}px`,`${this.right}px`,`${this.bottom}px`,`${this.left}px`].join(e)}},Li=class extends ${static from(i,e=!0){const t=e?"client":"screen";i.changedTouches&&(i=i.changedTouches[0]);const r=i[`${t}X`],n=i[`${t}Y`];return new this(r,n)}constructor(i,e){super(i,e,0,0)}constrain(i){return this.x=Math.min(Math.max(this.x,i.x),i.right-1),this.y=Math.min(Math.max(this.y,i.y),i.bottom-1),this}toArray(){return[this.x,this.y]}};$._$name="Rectangle";var Bs=Symbol("value"),LE=Symbol("length"),le=class Qi{static change(e,t,r,n="string"){r=Qi.normalize(r,"object");const s=Qi.normalize(e,"array").filter(a=>!r[a]);if(t){t=Qi.normalize(t,"array");for(let a=0;a<t.length;++a)s.includes(t[a])||s.push(t[a])}return Qi.normalize(s,n)}static from(e,t){return e&&(e.isDomClassList?t=t!=null?t:!0:(t=t!=null?t:X.isObject(e)&&!X.isEmpty(e),e=new Qi(e)),!e.value&&!t&&(e=null)),e||(t?new Qi:null)}static normalize(e,t="string"){e=e||"";const r=typeof e,n=t==="array",s=t==="object",a=!n&&!s;let o=r==="string",l,d,c;for(r==="object"&&(e.nodeType===Element.ELEMENT_NODE&&typeof e.getAttribute=="function"?(e=e.getAttribute("class")||"",o=!0):e!=null&&e.isDomClassList?e=e.values:e instanceof DOMTokenList?e=Array.from(e):e instanceof Map?e=Array.from(e.keys()).filter(u=>e.get(u)):e instanceof Set?e=Array.from(e):Array.isArray(e)||(e=X.getTruthyKeys(e))),o&&(e=k.split(e)),d=e.length;d-- >0;)l=e[d],l.length?l.includes(" ")&&e.splice(d,1,...k.split(l)):e.splice(d,1);if(e=[...new Set(e)],n)c=e;else if(a)c=e.join(" ");else for(c=Object.create(null),d=0;d<e.length;++d)c[e[d]]=!0;return c}constructor(...e){this.process(1,e)}clear(){for(const e in this)this[e]=!1;return this}set(...e){return this.clear().process(1,e)}get isDomClassList(){return!0}clone(){return new Qi(this)}contains(e){return typeof e=="string"&&e?!!this[e]:!1}toString(){return this.length?`${this.value} `:""}toJSON(){return this.toString()}trim(){return this.value}isEqual(e){const t=Qi.normalize(e,"array"),r=t.length;if(this.length===r){for(let n=0;n<r;n++)if(!this[t[n]])return!1;return!0}return!1}get value(){let e=this[Bs],t;return e==null&&(t=X.getTruthyKeys(this),this[LE]=t.length,this[Bs]=e=t.join(" ")),e}set value(e){const t=this,r=Object.keys(t),n=r.length;for(let s=0;s<n;s++)delete t[r[s]];e?t.process(1,[e]):delete t[Bs]}get values(){return X.getTruthyKeys(this)}get length(){return this.value?this[LE]:0}process(e,t){for(let r,n,s=0;s<t.length;s++)if(t[s])if(r=t[s],r.isDomClassList||X.isObject(r))for(n in r)this[n]=e?r[n]:!r[n];else for(r=Qi.normalize(t[s],"array"),n=0;n<r.length;++n)this[r[n]]=e;return delete this[Bs],this}assign(e){for(const t in e)!this[t]!=!e[t]&&(this[t]=e[t],delete this[Bs]);return this}assignTo(e){const t=e.nodeType===Element.ELEMENT_NODE?e.classList:e,r=Qi.from(t);r.add(this),t.value=r.value}add(...e){return this.process(1,e)}remove(...e){return this.process(0,e)}toggle(e,t=!this[e]){if(t=!!t,!!this[e]!==t)return this[e]=t,delete this[Bs],!0}split(){return X.getTruthyKeys(this)}forEach(e){return X.getTruthyKeys(this).forEach(e)}};le.prototype[Bs]=null,le._$name="DomClassList";var OE=()=>performance.now(),qA=class TF{constructor(e){const t=this;t.id=e.pointerId,t.downEvent=t.event=e,t.t0=OE(),t.xy=t.xy0=[e.pageX,e.pageY]}get distance(){const[e,t]=this.dxy;return Math.sqrt(e*e+t*t)}get dt(){return OE()-this.t0}get dxy(){const{xy:e,xy0:t}=this,r=e[0]-t[0],n=e[1]-t[1];return[r,n,Math.abs(r),Math.abs(n),...e]}clone(){const e=this,t=new TF(e.downEvent);return t.t0=e.t0,t.xy=e.xy.slice(),t.xy0=e.xy0.slice(),t}track(e){this.event=e,this.xy=[e.pageX,e.pageY]}},$E=class MF extends O{construct(...e){this.active=[],this.current=null,super.construct(...e)}get empty(){return!this.length}get length(){return this.active.length}get primary(){var e;return(e=this.active[0])!=null?e:null}get secondary(){var e;return(e=this.active[1])!=null?e:null}get single(){return this.length===1}clone(){const e=new MF,{current:t,currentEvent:r}=this;let n,s;for(s of this.active)e.active.push(n=s.clone()),s===t&&(e.current=n);return e.current||(e.current=t==null?void 0:t.clone()),e._currentEvent=r,e}get(e){let t=null,r;for(r of this.active)if(r.id===e){t=r;break}return t}track(e){return this.currentEvent=e,this}updateCurrentEvent(e){const t=this,r=e.type.slice(7);let n=t.get(e.pointerId);r!=="move"&&(t.active=t.active.filter(s=>s!==n)),r==="down"?t.active.push(n=new qA(e)):n==null||n.track(e),t.current=n}};p($E,"configurable",{currentEvent:null});var Pg=$E;Pg.initClass(),Pg._$name="Pointers";var{defineProperty:by}=Reflect,kg;Y.isBrowserEnv?kg=globalThis.performance:kg={now(){return new Date().getTime()}};var Ee=null;if(te.isTestEnv){const i=globalThis.bryntum||(globalThis.bryntum={});Ee=i.globalDelays={timeouts:new Map,intervals:new Map,animationFrames:new Map,idleCallbacks:new Map,isEmpty(e=!1){return Ee.timeouts.size+Ee.animationFrames.size+Ee.idleCallbacks.size+(e?Ee.intervals.size:0)===0},getFiltered({ignoreTimeouts:e=[],maxDelay:t=5e3,includeIntervals:r=!1}){const n=[],s=["timeouts","animationFrames","idleCallbacks"];r&&s.push("intervals");for(const a of s){const o=Ee[a];for(const[,l]of o.entries())!e.includes(l.name)&&(!Number.isInteger(l.delay)||l.delay<t)&&n.push(l)}return n}}}var YA=Promise.resolve(),BE=Object.freeze([]),KA=()=>{},XA=Object.freeze({}),HE=globalThis.queueMicrotask,Eo=(i,e,t,r)=>{const n=typeof e=="string",s=(r==null?void 0:r.appendArgs)||BE,a=()=>{t.timerId=null,t.lastCallTime=kg.now();const o=t.args;t.args=null,n?i[e](...o,...s):e.call(i,...o,...s),t.called=!0,++t.calls};return i=(r==null?void 0:r.thisObj)||i,t.lastCallTime=-9e9,t.calls=0,t.suspended=r==null?void 0:r.suspended,t.invoker=a,a.wrapFn=t,a.fn=e,a.this=i,a},ou=(i,e,t="clearTimeout")=>(e.cancel=()=>{e.isPending&&(i[t](e.timerId),e.args=e.timerId=null)},e.flush=()=>{e.isPending&&(i[t](e.timerId),e.timerId=null,e.invoker())},e.now=(...r)=>{e.cancel(),e.args=r,e.invoker()},e.resume=r=>{const n=e.suspended;e.suspended=r||n<1?0:n-1},e.suspend=()=>{++e.suspended},e.immediate=!1,e.suspended=e.suspended?1:0,e.timerId=null,by(e,"isPending",{get(){return e.timerId!==null}}),e),be=i=>{var e;return e=class extends(i||O){static get declarable(){return["delayable"]}doDestroy(){super.doDestroy(),this.clearDelayables()}clearDelayables(){const t=this,[r,n,s,a,o,l]=[t.idleCallbackIds,t.animationFrameIds,t.intervalIds,t.timeoutMap,t.timeoutIds,t.microtasksPending];t.idleCallbackIds=t.animationFrameIds=t.intervalIds=t.timeoutMap=t.timeoutIds=t.microtasksPending=null,o==null||o.forEach((d,c)=>{typeof d=="function"&&d(),clearTimeout(c),Ee==null||Ee.timeouts.delete(c)}),a==null||a.forEach((d,c)=>clearTimeout(c)),s==null||s.forEach(d=>{clearInterval(d),Ee==null||Ee.intervals.delete(d)}),n==null||n.forEach(d=>{cancelAnimationFrame(d),Ee==null||Ee.animationFrames.delete(d)}),r==null||r.forEach(d=>{cancelIdleCallback(d),Ee==null||Ee.idleCallbacks.delete(d)}),l==null||l.forEach(d=>d.cancel())}hasTimeout(t){var r;return!!((r=this.timeoutMap)!=null&&r.has(t))}asap(t,r){const n=this,s=(...o)=>{s.suspended||(s.called=!1,s.args=o,s.immediate?a():s.isPending||(s.timerId=n.queueMicrotask(a)))},a=Eo(n,t,s,r);return ou(n,s,"cancelMicrotask")}queueMicrotask(t,r,n){let s,a;!n&&r&&!Array.isArray(r)&&(n=r,r=null),n=n||XA,r=r||n.args||BE;const o=this,l=typeof t=="string",d=l?t:t.name,c=o.microtasksPending||(o.microtasksPending=new Map),u=()=>c.delete(s),h=()=>{a===c.get(s)&&(c.delete(s),l?!o.isDestroyed&&o[t](...r):t.apply(o,r))};return o.isDestroying&&!n.runOnDestroy?KA:(s=n.cancelOutstanding?d||t:u,a={key:s,name:d,fn:t,args:r,options:n,cancel:u,wrapFn:h},u.taskDef=a,HE?HE(h):YA.then(h),c.set(s,a),u)}cancelMicrotask(t){t==null||t()}setTimeout({fn:t,delay:r,name:n,runOnDestroy:s,cancelOutstanding:a,args:o}){(arguments.length>1||typeof arguments[0]=="function")&&([t,r,n,s,a]=arguments),typeof t=="string"?n=t:n||(n=t.name||t),a&&this.clearTimeout(n);const l=this,d=l.timeoutIds||(l.timeoutIds=new Map),c=l.timeoutMap||(l.timeoutMap=new Map),u=setTimeout(()=>{typeof t=="string"&&(t=l[n]),d==null||d.delete(u),c==null||c.delete(n),Ee==null||Ee.timeouts.delete(u),t.apply(l,o)},r);return d.set(u,s?t:!0),Ee==null||Ee.timeouts.set(u,{fn:t,delay:r,name:n}),n&&c.set(n,u),u}clearTimeout(t){var r;let n=t;if(typeof n=="string")if(this.timeoutMap)n=this.timeoutMap.get(t),this.timeoutMap.delete(t);else return;clearTimeout(n),(r=this.timeoutIds)==null||r.delete(n),Ee==null||Ee.timeouts.delete(n)}clearInterval(t){var r;clearInterval(t),(r=this.intervalIds)==null||r.delete(t),Ee==null||Ee.intervals.delete(t)}setInterval(t,r,n){const s=setInterval(t,r);return(this.intervalIds||(this.intervalIds=new Set)).add(s),Ee==null||Ee.intervals.set(s,{fn:t,delay:r,name:n}),s}requestAnimationFrame(t,r=[],n=this){const s=this.animationFrameIds||(this.animationFrameIds=new Set),a=requestAnimationFrame(()=>{Ee==null||Ee.animationFrames.delete(a),s.delete(a)&&t.apply(n,r)});return s.add(a),Ee==null||Ee.animationFrames.set(a,{fn:t,extraArgs:r,thisObj:n}),a}requestIdleCallback(t,r=[],n=this){const s=this.idleCallbackIds||(this.idleCallbackIds=new Set),a=requestIdleCallback(()=>{Ee==null||Ee.idleCallbacks.delete(a),s.delete(a)&&t.apply(n,r)});return s.add(a),Ee==null||Ee.idleCallbacks.set(a,{fn:t,extraArgs:r,thisObj:n}),a}createOnFrame(t,r=[],n=this,s){let a;const o=(...l)=>{a!=null&&s&&(this.cancelAnimationFrame(a),a=null),a==null&&(a=this.requestAnimationFrame(()=>{typeof t=="string"&&(t=n[t]),a=null,l.push(...r),t.apply(n,l)}))};return o.cancel=()=>this.cancelAnimationFrame(a),o}cancelAnimationFrame(t){var r;cancelAnimationFrame(t),(r=this.animationFrameIds)==null||r.delete(t),Ee==null||Ee.animationFrames.delete(t)}cancelIdleCallback(t){var r;cancelIdleCallback(t),(r=this.idleCallbackIds)==null||r.delete(t),Ee==null||Ee.idleCallbacks.delete(t)}async nextAnimationFrame(){return new Promise(t=>this.requestAnimationFrame(t))}buffer(t,r){let n=r;r&&typeof r!="number"?n=r.delay:r=null;const s=(...o)=>{if(s.suspended)return;const{delay:l}=s;s.cancel(),s.called=!1,s.args=o,s.immediate||!l?a():s.timerId=this.setTimeout(a,l)},a=Eo(this,t,s,r);return s.delay=n,ou(this,s)}raf(t,r){let n=r;r&&typeof r!="boolean"?n=r.cancelOutstanding:r=null;const s=(...o)=>{s.suspended||((s.cancelOutstanding||s.immediate)&&s.cancel(),s.called=!1,s.args=o,s.immediate?a():s.isPending||(s.timerId=this.requestAnimationFrame(a)))},a=Eo(this,t,s,r);return s.cancelOutstanding=n,s.raf=!0,ou(this,s,"cancelAnimationFrame")}idle(t,r){let n=r;r&&typeof r!="boolean"?n=r.cancelOutstanding:r=null;const s=(...o)=>{s.suspended||((s.cancelOutstanding||s.immediate)&&s.cancel(),s.called=!1,s.args=o,s.immediate?a():s.isPending||(s.timerId=this.requestIdleCallback(a)))},a=Eo(this,t,s,r);return s.cancelOutstanding=n,this.setTimeout(()=>this.idleCallbackIds.delete(s.timerId)&&s.now(),100),ou(this,s,"cancelIdleCallback")}throttle(t,r){let n=r,s;r&&typeof r!="number"?(n=r.delay,s=r.throttled):r=null;const a=this,o=(...d)=>{if(o.suspended)return;const{delay:c}=o,u=kg.now()-o.lastCallTime;o.args=d,o.immediate||u>=c?(a.clearTimeout(o.timerId),l()):(o.isPending||(o.timerId=a.setTimeout(l,c-u),o.called=!1),s&&(s.wrapFn.args=d,s()))},l=Eo(a,t,o,r);return o.delay=n,s&&(s=Eo(a,s,()=>{},r)),ou(a,o)}static setupDelayable(t){t.setupDelayableMethods(t.delayable)}static setupDelayableMethods(t,r=null){const n=this,s=t.static,a=r||n.prototype;s&&delete t.static;for(const o in t){let l=t[o];const d=o+"Now",c=typeof l;a[d]||(a[d]=a[o]),c==="number"?l={type:"buffer",delay:l}:c==="string"&&(l={type:l}),by(a,o,{get(){const u=this;if(u.isDestroyed)return;const h=(...g)=>u[d](...g),f=u[l.type](h,l);return by(u,o,{value:f,configurable:!0,writable:!0}),h.methodName=o,f}})}}get widgetClass(){}},p(e,"$name","Delayable"),e},VE=T.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null)),ZA={string:1,number:1},bn=i=>{var e;return e=class extends(i||O){static get declarable(){return["identifiable"]}static get configurable(){return{id:""}}static setupIdentifiable(t,r){const{identifiable:n}=t;n.idMap=Object.create(null),Reflect.defineProperty(t,"identifiable",{get(){return n}})}doDestroy(){this.constructor.unregisterInstance(this),super.doDestroy()}changeId(t){return(this.hasGeneratedId=!t)?this.generateAutoId():t}updateId(t,r){const n=this,s=n.constructor;r&&s.unregisterInstance(n,r),(!n.hasGeneratedId||s.identifiable.registerGeneratedId!==!1)&&s.registerInstance(n,t)}generateAutoId(){return this.constructor.generateId(`b-${this.$$name.toLowerCase()}-`)}static get all(){return Object.values(this.identifiable.idMap)}static generateId(t="generatedId"){return t+(VE[t]=(VE[t]||0)+1)}static registerInstance(t,r=t.id){const{idMap:n}=this.identifiable;if(r in n&&!this.disableThrow)throw new Error("Id "+r+" already in use");n[r]=t}static unregisterInstance(t,r=t.id){const{idMap:n}=this.identifiable;ZA[typeof t]?delete n[t]:n[r]===t&&delete n[r]}static getById(t){const r=this.identifiable.idMap;if(r)return r[t]}static get registeredInstances(){const t=this.identifiable.idMap;return t?Object.values(t):[]}},p(e,"$name","Identifiable"),e},Lg=i=>i.pointerType==="touch",Cy=()=>performance.now(),Sy=class extends O.mixin(Ie){isEqual(i,e){return this.gestureClass===i&&ye.Object.isEqual(this.options,e)}start(i){const e=this,t=ye.Object.clone(e.options)||{};t.element=i.element,t.handler=e,t.recognition=i;const r=new e.gestureClass(t);return r.onBegin(),r}};p(Sy,"configurable",{gestureClass:null,options:null}),Sy.initClass();var lu,du,wi=class jv extends O.mixin(be,bn){static begin(e){const{touchPoints:t}=this;return!t||t===e.length}static setupFires(e){e.fires.forEach(t=>jv.registry[t.toLowerCase()]=jv.registry[t]=e)}static getRecognizer(e,t,r=!0){const{registry:n}=this;return[jv.Recognizer.from(e,r),n[t]||n[t.toLowerCase()]]}static is(e){const{registry:t}=this;return e in t||e.toLowerCase()in t}static on(e,t,r,n){const[s,a]=this.getRecognizer(e,t);s.on(a,t,r,n)}static un(e,t,r){const[n,s]=this.getRecognizer(e,t,!1);n!=null&&n.un(s,t,r)&&!n.handlers.length&&n.destroy()}get elapsedTime(){return Cy()-this.startTime}get gestureName(){return this.constructor.gestureName}get recognized(){return!!this.state}set recognized(e){const t=this,{recognition:r}=t,{gestures:n}=r;e?t.state||t.beforeStart()!==!1&&(r.recognized=t,t.state="active"):n.includes(t)&&(r.gestures=n.filter(s=>s!==t),t.state==="active"?t.cancel():t.destroy())}get pointers(){return this.recognition.recognizer.pointers}beforeStart(){return this.trigger("before"+this.gestureName)}cancel(){this.state==="active"&&(this.state="cancel")}end(){this.state==="active"&&(this.state="done")}getDetails(e){var t;const{pointers:r}=this;return{...e,event:(t=r.current)==null?void 0:t.event,gesture:this,pointers:r.clone()}}move(e){this.unrecognize(e)&&this.cancel(e)}onBegin(){this.startTime=this.lastTime=Cy()}onCancel(){this.trigger(this.gestureName+"Cancel")}onEnd(){this.trigger(this.gestureName)}onStart(){this.trigger(this.gestureName+"Start")}recognize(e){var t;const r=this,{durationLimit:n,elapsedTime:s,idleLimit:a,lastTime:o}=r,l=Cy();if((t=e.currentEvent)!=null&&t.defaultPrevented||n&&s>n||a&&l>o+a)return!1;r.lastTime=l}reset(){var e,t;(t=(e=this.recognition)==null?void 0:e.recognizer)==null||t.reset()}toString(){return this.constructor.$$name}trigger(e,t){const r=this,{registry:n}=r.constructor;if(e in n||e.toLowerCase()in n)return r.handler.trigger(e,r.getDetails(t))}unrecognize(e){return this.recognize(e)===!1}updateElement(e){var t;const r=this,{targetEvents:n}=r;(t=r.unlisten)==null||t.call(r),r.unlisten=e&&n&&ye.Event.on(ye.Object.assign({thisObj:r,element:e},n))}updateState(e){const t=this;e==="active"?t.onStart():e==="cancel"?(t.onCancel(),t.reset()):e==="done"&&(t.onEnd(),t.reset())}};p(wi,"$name","Gesture"),p(wi,"configurable",{durationLimit:null,element:{value:null,$config:"nullify"},handler:null,idleLimit:null,recognition:null,state:null,targetEvents:null}),p(wi,"declarable",["fires"]),p(wi,"identifiable",{}),p(wi,"gestureName","none"),p(wi,"registry",Object.create(null)),p(wi,"touchPoints",0),p(wi,"Recognizer",(lu=class extends O.mixin(bn){static from(i,e=!0){let t=ye.Dom.getExpando(i,"gestures");return!t&&e&&ye.Dom.setExpando(i,"gestures",t=new wi.Recognizer({element:i})),t}get pointers(){return this._pointers||(this._pointers=new Pg)}changeHandlers(i){return(i==null?void 0:i.slice())||[]}filterHandlers(i){const{pointers:e}=this;return e.currentEvent=i,this.handlers.filter(t=>t.gestureClass.begin(e))}on(i,e,t,r){const n=this,{handlers:s}=n;let a=s.find(o=>o.isEqual(i,r));a||(a=new Sy({gestureClass:i,options:r}),n.handlers=[...s,a]),a.on({[e]:t})}un(i,e,t){const r=this,{handlers:n}=r,s={[e]:t};for(const a of n)if(a.gestureClass===i&&a.un(s))return a.hasListener()||(r.handlers=n.filter(o=>o!==a),a.destroy()),!0}onPointerCancel(i){var e;if(Lg(i)){const t=this,{pointers:r}=t;r.currentEvent=i,(e=t.recognition)==null||e.cancel(r),t.reset()}}onPointerDown(i){var e;if(Lg(i)){const t=this,r=t.pointers.track(i),n=t.handlers.filter(s=>s.gestureClass.begin(r));(e=t.recognition)==null||e.destroy(),t.recognition=n.length&&new wi.Recognition({element:t.element,recognizer:t,currentEvent:i,startEvent:i,gestures:n})||null}}onPointerUp(i){var e;if(Lg(i)){const t=this,{pointers:r}=t;r.currentEvent=i,(e=t.recognition)==null||e.onPointerUp(r),t.reset()}}updateElement(i,e){var t;const r=this;r.reset(),(t=r.unlisten)==null||t.call(r),r.unlisten=i&&ye.Event.on({thisObj:r,passive:!1,pointercancel:"onPointerCancel",pointerdown:"onPointerDown",pointerup:"onPointerUp",element:i}),i&&(i.style.touchAction="none"),ye.Dom.removeExpando(e,"gestures",r),ye.Dom.setExpando(i,"gestures",r)}reset(){this.destroyMember("recognition")}},p(lu,"$name","Recognizer"),p(lu,"configurable",{element:{value:null,$config:"nullify"},handlers:[],recognition:null}),p(lu,"identifiable",{}),lu)),p(wi,"Recognition",(du=class extends O.mixin(bn){get pointers(){var i;return(i=this.recognizer)==null?void 0:i.pointers}cancel(i){var e;(e=this.recognized)==null||e.cancel(i)}changeGestures(i){return i==null?void 0:i.map(e=>e.isGesture?e:e.start(this))}doDestroy(){this.destroyMember("gestures"),this.element=null,super.doDestroy()}onPointerUp(i){var e;return(e=this.recognized)==null?void 0:e.end(i)}onPointerMove(i){if(Lg(i)){const e=this,{gestures:t,pointers:r}=e;let{recognized:n}=e,s,a;if(r.currentEvent=i,!n){for(s of t)if(a=s.recognize(r),(a===!1||a===!0)&&(s.recognized=a),n=e.recognized,n)break}return n==null?void 0:n.move(r)}}updateElement(i){var e;(e=this.unlisten)==null||e.call(this),this.unlisten=i&&ye.Event.on({thisObj:this,passive:!1,pointermove:"onPointerMove",element:i})}updateGestures(i){var e;!(i!=null&&i.length)&&((e=this.recognizer)==null||e.reset())}updateRecognized(i){const e=this,{gestures:t}=e,r=t.filter(n=>n!==i);if(t.length===r.length)throw new Error(`Gesture is not active for element ${e.element.id}: ${i}`);O.destroy(r),e.gestures=[i]}},p(du,"$name","Recognition"),p(du,"configurable",{element:null,gestures:null,recognized:null,recognizer:null,startEvent:null}),p(du,"identifiable",{}),du));var Di=wi;Di.initClass(),Di.Recognition.initClass(),Di.Recognizer.initClass(),Di._$name="Gesture";var Cn=class extends Di{detect(){this.recognized=!0,this.end()}onContextMenu(i){i.pointerType==="touch"&&(i.preventDefault(),this.native!==!1&&this.detect())}recognize(i){let e=super.recognize(i);if(e!==!1){const[,,t,r]=i.current.dxy;Math.max(t,r)>this.tolerance&&(e=!1)}return e}updateDuration(i){i&&this.setTimeout(()=>this.detect(),i)}};p(Cn,"$name","LongPress"),p(Cn,"gestureName","longPress"),p(Cn,"configurable",{duration:700,native:null,targetEvents:{contextmenu:"onContextMenu"},tolerance:5}),p(Cn,"fires",["beforeLongPress","longPress"]),p(Cn,"touchPoints",1),Cn.initClass(),Cn._$name="LongPress";var jE=(i,e,t)=>Math.abs(e)<t?"":`${e<0?"-":"+"}${i}`,Sn=class extends Di{getDetails(i){const e=this,t=e.pointers.current;if(t){const[r,n,s,a,o,l]=t.dxy;i={...i,swipe:e.axis,dx:r,dy:n,adx:s,ady:a,x:o,y:l}}else i={...i,swipe:e.axis};return super.getDetails(i)}onContextMenu(i){i.pointerType==="touch"&&(this.recognized=!1)}onTargetScroll(){this.recognized=!1}recognize(i){let e=super.recognize(i);if(e!==!1){const t=this,{axis:r,threshold:n,tolerance:s}=t,[a,o,l,d]=i.current.dxy,c=jE("x",a,n)+jE("y",o,n);!a&&!o||l>s&&d>s||r&&r!==c?e=!1:c&&(t.axis=c,e=!0)}return e}};p(Sn,"$name","Swipe"),p(Sn,"gestureName","swipe"),p(Sn,"configurable",{axis:null,durationLimit:700,idleLimit:250,targetEvents:{contextmenu:"onContextMenu",scroll:{capture:!0,handler:"onTargetScroll"}},threshold:80,tolerance:100}),p(Sn,"fires",["beforeSwipe","swipe","swipeStart","swipeCancel"]),p(Sn,"touchPoints",1),Sn.initClass(),Sn._$name="Swipe";var QA=["clientX","clientY","pageX","pageY","screenX","screenY"],JA={element:1,expires:1,handler:1},eP={element:1,thisObj:1,once:1,delegate:1,delay:1,capture:1,passive:1,throttled:1,autoDetach:1,expires:1,block:1,raw:1,fromGlobal:1},tP={Spacebar:"Space",Del:"Delete",Esc:"Escape",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown"},iP={Control:"ctrl",Alt:"alt",Shift:"shift",Meta:"meta"},rP=/^(ctrl|shift|alt|meta)$/,nP=["altKey","bubbles","button","buttons","cancelable","clientX","clientY","ctrlKey","layerX","layerY","metaKey","pageX","pageY","returnValue","screenX","screenY","shiftKey"],sP=(...i)=>i.reduce((e,t)=>{for(let r=0,n=e.length;r<n;++r)e.push(r?`${e[r]}+${t}`:t);return e},[""]),aP=Object.fromEntries("abcdefghijklmnopqrstuvwxyz".split("").map(i=>[i,i.toUpperCase()])),oP=sP("Ctrl","Alt","Meta","Shift"),zE=i=>oP[(i.ctrlKey&&1)|(i.altKey&&2)|(i.metaKey&&4)|(i.shiftKey&&8)],lP=i=>{const e=[zE(i)],{code:t,key:r}=i;return e[e[0]?1:0]=t!=null&&t.includes("Numpad")?t:aP[r]||r,e.join("+")},{isSafari:NE,isMobileSafari:dP}=Y,wy=new WeakMap,Og=i=>(i==null?void 0:i.nodeType)===Element.TEXT_NODE?i.parentElement:i,Dy=class IF{static normalizeEvent(e){return T.copyPropertiesIf(e,e.changedTouches[0]||e.touches[0],QA)}static copyEvent(e,t){return T.copyProperties(e,t,nP)}static getXY(e){return e.touches&&(e=e.touches[0]),[e.clientX,e.clientY]}static getDistanceBetween(e,t,r){const n=gt.getXY(e),s=gt.getXY(t),a=n[0]-s[0],o=n[1]-s[1];return r!=null&&r.x?a:r!=null&&r.y?o:Math.sqrt(Math.pow(a,2)+Math.pow(o,2))}static getPagePoint(e){return new Li(e.pageX,e.pageY)}static getClientPoint(e){return new Li(e.clientX,e.clientY)}static addListener(e,t,r,n){return e.nodeType?typeof t=="string"?n=Object.assign({element:e,[t]:r},n):n=Object.assign({element:e},t):n=e,gt.on(n)}static on(e){const t=e.element,r=e.thisObj,n=[];for(const a in e)if(!eP[a]){let o=e[a];typeof o!="object"&&(o={handler:o});const l=o.element||t;n.push(gt.addElementListener(l,a,o,e))}const s=()=>{for(let a,o=0;o<n.length;o++)a=n[o],gt.removeEventListener(a[0],a[1],a[2]);n.length=0};return r&&e.autoDetach!==!1&&(r.doDestroy=we.createInterceptor(r.doDestroy,s,r)),s}static addElementListener(e,t,r,n){const s=gt.createHandler(e,t,r,n),{spec:a}=s,o=r.expires||n.expires,l=a.capture!=null||a.passive!=null?{capture:a.capture,passive:a.passive}:void 0;if(Di.is(t)?Di.on(e,t,s,ye.Object.filter(r,(d,c)=>!JA[c])):e.addEventListener(t,s,l),o){const d=r.thisObj||n.thisObj,c=d!=null&&d.isDelayable?d:globalThis,{alt:u}=o,h=u?o.delay:o,{spec:f}=s;f.expires=o,f.timerId=c[typeof h=="number"?"setTimeout":"requestAnimationFrame"](()=>{f.timerId=null,gt.removeEventListener(e,t,s),u&&!s.called&&(typeof u=="string"?d[u]:u).call(d)},h,`listener-timer-${performance.now()}`)}return[e,t,s,l]}static getComposedPathTarget(e){var t;return e.composedPath()[0]||((t=e.path)==null?void 0:t[0])}static fixEvent(e,t){var r,n;if(e.isBryntumEvent)return e;if(wy.has(e))return wy.get(e);const{ctrlKey:s,metaKey:a,type:o,target:l}=e,d=this.getComposedPathTarget(e),c=((n=(r=d==null?void 0:d.getRootNode)==null?void 0:r.call(d))==null?void 0:n.mode)==="open",u={set(f,g,m){var v;return g in f&&((v=Object.getOwnPropertyDescriptor(Object.getPrototypeOf(f),"type"))!=null&&v.set)?Reflect.set(f,g,m):(u[g]=m,!0)},get(f,g){if(T.hasOwn(u,g))return u[g];switch(g){case"fixed":case"isBryntumEvent":return!0;case"key":return tP[f.key]||f.key;case"code":return f.key===" "&&!f.code?"Space":f.code;case"ctrlKey":return Y.isMac&&a!==s?a:s;case"metaKey":return Y.isMac&&a!==s?s:a;case"virtualKey":return lP(h);case"virtualModKeys":return zE(h);case"borderOffsetX":return isNaN(f.offsetX)?void 0:f.offsetX+(NE?0:parseInt(l.ownerDocument.defaultView.getComputedStyle(Og(l)).getPropertyValue("border-left-width")));case"borderOffsetY":return isNaN(f.offsetY)?void 0:f.offsetY+(NE?0:parseInt(l.ownerDocument.defaultView.getComputedStyle(Og(l)).getPropertyValue("border-top-width")));case"target":return c?d:Og(f.target);case"relatedTarget":return Og(f.relatedTarget);case"originalTarget":return l;case"deepTarget":return d;case"currentTarget":return u.delegatedTarget||f.currentTarget;case"browserEvent":return f;case"timeStamp":dP&&(u.timeStamp||(u.timeStamp=Date.now()));default:if(g in u)return u[g];{const m=Reflect.get(f,g);return typeof m=="function"?m.bind(f):m}}},has(f,g){return g in f||g in u}},h=new Proxy(e,u);if(wy.set(e,h),o.startsWith("touch")&&this.normalizeEvent(h),!t)switch(o){case"keydown":ce.currentKeyDown=h;break;case"mousedown":ce.currentMouseDown=h;break;case"pointerdown":ce.currentPointerDown=h;break;case"touchstart":ce.currentTouch=h}return h}static createHandler(e,t,r,n){const s=Di.is(t),a=r.delay||n.delay,o=r.throttled||n.throttled,l=r.block||n.block,d="once"in r?r.once:n.once,c="capture"in r?r.capture:n.capture,u="passive"in r?r.passive:n.passive,h="delegate"in r?r.delegate:n.delegate,f="fromGlobal"in r?r.fromGlobal:n.fromGlobal,g=r.handler,m=r.expires,v=r.thisObj||n.thisObj;let y=(...b)=>{const C=b[0];gt.playingDemo&&C.isTrusted||v!=null&&v.isDestroyed||(y.called=!0,s||(b[0]=gt.fixEvent(C,f)),typeof g=="string"?v[g](...b):g.apply(v,b))};if(l){const b=y;let C,D;y=(w,...x)=>{const R=performance.now();(!C||w.target!==D||R-C>l)&&(D=w.target,C=R,b(w,...x))}}if(a!=null){const b=y,C=v!=null&&v.setTimeout?v:globalThis;y=(...D)=>{C.setTimeout(()=>{b(...D)},a)}}if(o!=null){let b,C=o;o.buffer&&(b=D=>o.alt.call(gt,gt.fixEvent(D,f)),C=o.buffer),v!=null&&v.isDelayable?y=v.throttle(y,{delay:C,throttled:b}):y=we.createThrottled(y,C,v,null,b)}if(d){const b=y;y=(...C)=>{gt.removeEventListener(e,t,y),b(...C)}}if(h){const b=y;y=(C,...D)=>{var w,x;C=gt.fixEvent(C,f);const R=(x=(w=C.target).closest)==null?void 0:x.call(w,h);R&&(C.delegatedTarget=R,b(C,...D))}}return r.thisObj&&r.autoDetach!==!1&&(v.doDestroy=we.createInterceptor(v.doDestroy,()=>gt.removeEventListener(e,t,y),v)),y.spec={delay:a,throttled:o,block:l,once:d,thisObj:v,capture:c,expires:m,passive:u,delegate:h},y}static removeEventListener(e,t,r){const{expires:n,timerId:s,thisObj:a,capture:o}=r.spec;n!=null&&n.alt&&s&&(a!=null&&a.isDelayable?a:globalThis)[typeof n.delay=="number"?"clearTimeout":"cancelAnimationFrame"](s),Di.is(t)?Di.un(e,t,r):e.removeEventListener(t,r,o)}static onTransitionEnd({element:e,animationName:t,property:r,handler:n,mode:s=t?"animation":"transition",duration:a=E[`get${s==="transition"?"Property":""}${k.capitalize(s)}Duration`](e,r),timeout:o,thisObj:l=globalThis,args:d=[],timerSource:c,runOnDestroy:u}){let h,f;c=c||(l.isDelayable?l:globalThis);const{isDelayable:g}=c,m=performance.now(),v=`transitionTimer${m}`,y=`timeoutTimer${m}`,b=[e,r,...d],C=()=>{var w;D(),l.isDestroyed||((w=l.$meta)!=null&&w.class.isBase?l.callback(n,l,b):n.apply(l,b))},D=gt.on({element:e,[`${s}end`]({animationName:w,propertyName:x,target:R}){var M,I;R===e&&(x===r||w!=null&&w.match(t))&&(h&&(f&&((M=c.clearTimeout)==null||M.call(c,g?y:f)),(I=c.clearTimeout)==null||I.call(c,g?v:h),h=null),C())}});return o&&(f=c.setTimeout(C,Math.max(o,(a||0)+100),y)),a!=null&&(h=c.setTimeout(C,a+50,v,u)),D}static async waitForTransitionEnd(e){return new Promise(t=>{e.handler=t,IF.onTransitionEnd(e)})}static createDblClickWrapper(e,t,r){let n,s,a;return()=>{s||(s=gt.on({element:e,touchstart:o=>{n=o.changedTouches[0].identifier,o.preventDefault()},touchend:o=>{if(o.changedTouches[0].identifier===n){o.preventDefault(),clearTimeout(a),n=s=null;const l=$.from(o.changedTouches[0].target,null,!0),d=o.changedTouches[0].pageX-l.x,c=o.changedTouches[0].pageY-l.y,u=Object.assign({browserEvent:o},o),h=new MouseEvent("dblclick",u);Object.defineProperties(h,{target:{value:o.target},offsetX:{value:d},offsetY:{value:c}}),typeof t=="string"&&(t=r[t]),t.call(r,h)}},once:!0}),a=setTimeout(()=>{s(),n=s=null},gt.dblClickTime))}}static toSpecialKey(e,t="ctrlKey"){let r=!1;return e===!0?r=t:typeof e=="string"&&(e=e.toLowerCase(),e.match(rP)&&(r=`${e}Key`)),r}static specialKeyFromEventKey(e){return iP[e]||"no-special-key"}};p(Dy,"$name","EventHelper"),p(Dy,"eventNameMap",{mousedown:"MouseDown",mouseup:"MouseUp",click:"Click",dblclick:"DblClick",contextmenu:"ContextMenu",mouseenter:"MouseEnter",mouseleave:"MouseLeave",mousemove:"MouseMove",mouseover:"MouseOver",mouseout:"MouseOut",keyup:"KeyUp",keydown:"KeyDown",keypress:"KeyPress"});var j=Dy;ye.register(j);var gt=j;gt.longPressTime=700,gt.dblClickTime=300,Y.isTouchDevice&&gt.on({element:document,touchmove:i=>{i.target.closest(".b-dragging")&&i.preventDefault()},passive:!1,capture:!0}),j._$name="EventHelper";var cP=14,uP={align:"t0-t0"},{DOCUMENT_NODE:WE,ELEMENT_NODE:ir,TEXT_NODE:cu,DOCUMENT_FRAGMENT_NODE:$g}=Node,UE={text:1,password:1,date:1,search:1,email:1,number:1,time:1,"datetime-local":1,tel:1,url:1,month:1,week:1},{isObject:hP}=T,GE=/[+-]?\d*\.?\d+[eE]?-?\d*/g,rr=GE.source,fP=new RegExp(`matrix\\((?:${rr}),\\s?(?:${rr}),\\s?(?:${rr}),\\s?(?:${rr}),\\s?(${rr}),\\s?(${rr})`),gP=new RegExp("matrix3d\\((?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(-?\\d*),\\s?(-?\\d*)"),Bg=new RegExp(`(?:${fP.source})|(?:${gP.source})`),mP=new RegExp(`translate(3d|X)?\\((${rr})px(?:,\\s?(${rr})px)?`),pP=new RegExp(`translate(3d|Y)?\\((${rr})px(?:,\\s?(${rr})px)?`),vP=/\s+/,yP=/\s*;\s*/,bP=/\s*:\s*/,CP=/^-?((\d+(\.\d*)?)|(\.?\d+))$/,SP=/^[\w-]+$/i,qE="$bryntum",YE={},wP={elementData:"",for:"htmlFor",retainElement:""},DP={tag:1,html:1,text:1,children:1,tooltip:1,style:1,dataset:1,parent:1,nextSibling:1,ns:1,reference:1,class:1,className:1,unmatched:1,onlyChildren:1,listeners:1,compareHtml:1,syncOptions:1,keepChildren:1},EP=[["f","focusable"],["n","natural"],["p","programmatic"],["t","tabbable"]],xP=i=>Object.freeze(Object.fromEntries(EP.map(([e,t])=>[t,i.includes(e)]))),KE=(i,e)=>e.reduce((t,r)=>t[r]||(t[r]=Object.create(null)),i),XE=(...i)=>[qE,...i.flatMap(e=>Array.isArray(e)?e:e.split("."))],Ey=(i,e)=>{const t=XE(e),r=t.pop();return[i&&KE(i,t),r]},ZE={length:1,parentRule:1,style:1},QE={INPUT:1,TEXTAREA:1},RP={BUTTON:1,IFRAME:1,EMBED:1,INPUT:1,OBJECT:1,SELECT:1,TEXTAREA:1,BODY:1},xy=globalThis,lt=document,TP=Object.freeze({}),Ry=Array.prototype.slice,MP=Promise.resolve(),IP=["font-size","font-size-adjust","font-style","font-weight","font-family","font-kerning","font-stretch","line-height","text-transform","text-decoration","letter-spacing","word-break"],_P=i=>i._hidden,FP=i=>i instanceof le||T.isObject(i),AP=(i,e,t)=>t.key==="children"?T.mergeItems(i,e,t):T.blend(i,e,t),Ty=(i,e)=>{if(i.isConnected){const t=i.ownerDocument.defaultView.getComputedStyle(i);return t.getPropertyValue("display")!=="none"&&(e||t.getPropertyValue("visibility")!=="hidden")}},wn=i=>i&&i.isConnected&&(i===lt.body||!!i.offsetParent||(i.ownerDocument.defaultView&&"offsetParent"in i&&E.getStyleValue(i,"position")!=="fixed"?i.offsetParent:wn(i.parentNode))),JE=i=>i instanceof Node?i:typeof i=="string"?U.createElementFromTemplate(i):U.createElement(i),uu=Object.create(null),e0=(i,e)=>{const t=uu[i]||[k.hyphenate(i),e];return uu[i]||(uu[t[0]]=uu[i]=t),t},PP=/b-slide-in-from-\w+/,hu=(i,e)=>{var t;if(i){i=((t=i.target)==null?void 0:t.nodeType)===1?i.target:i;const r=(i.ownerSVGElement||i)[e&&E.getStyleValue(i,"position")!=="static"?"offsetParent":"parentNode"];return(r==null?void 0:r.nodeType)===$g?r.host:r}},Hg=i=>(i==null?void 0:i.nodeType)===ir,t0=(i=lt)=>{var e;return((e=i.getAnimations())==null?void 0:e.reduce((t,{effect:r,playState:n})=>(n==="running"&&r.getTiming().iterations!==1/0&&t.push(r.target),t),[]))||[]};["top","right","bottom","left","width","height","maxWidth","maxHeight","minWidth","minHeight","borderSpacing","borderWidth","borderTopWidth","borderRightWidth","borderBottomWidth","borderLeftWidth","insetBlockEnd","insetBlockStart","insetInlineEnd","insetInlineStart","marginTop","marginRight","marginBottom","marginLeft","marginInlineStart","marginInlineEnd","paddingTop","paddingRight","paddingBottom","paddingLeft","fontSize","letterSpacing","lineHeight","outlineWidth","textIndent","wordSpacing","insetInlineStart","insetBlockStart","insetInlineEnd","insetBlockEnd"].forEach(i=>e0(i,!0));var xo=null,kP=0,Hs=null,My,i0,r0,Vg=class vi{static get devicePixelRatio(){let e=globalThis.devicePixelRatio;if(e==null){const s=a=>`(-webkit-min-device-pixel-ratio: ${a}),
                (min--moz-device-pixel-ratio: ${a}),
                (min-resolution: ${a}dppx)`;for(let a=5*100;a>=.5*100;a-=.05*100)if(globalThis.matchMedia(s(a/100)).matches){e=a/100;break}}return e}static get usingKeyboard(){return U._usingKeyboard}static set usingKeyboard(e){return U._usingKeyboard=e}static setUsingKeyboard(e,t){U.setFocusRendition(e,t),U._usingKeyboard=t}static setFocusRendition(e,t){var r;U.enableKeyboardCssModifiers&&(e.nodeType===$g?t?Array.from(e.children).forEach(n=>{var s;return((s=n.matches)==null?void 0:s.call(n,".b-outer"))&&n.classList.add("b-using-keyboard")}):U.removeClsGlobally(e,"b-using-keyboard"):(r=e.classList)==null||r.toggle("b-using-keyboard",t))}static findParent(e,t,r){return this.closest(e==null?void 0:e.parentNode,t,r)}static closest(e,t,r){if(e&&e!==r)return t(e)?e:this.closest(e.parentNode,t,r)}static async slideIn(e,t=1){const r=`b-slide-in-${t>0?"next":"previous"}`,{classList:n,parentNode:{classList:s}}=e;s.add("b-sliding-child-element"),n.add(r),await j.waitForTransitionEnd({element:e,animationName:PP}),n.remove(r),s.remove("b-sliding-child-element")}static getExpando(e,t,r){const[n,s]=Ey(e,t);return n&&s in n?n[s]:r}static getExpandos(e,t){return KE(e,XE(t))}static removeExpando(e,t,r){const[n,s]=Ey(e,t);n&&(!r||n[s]===r)&&delete n[s]}static setExpando(e,t,r){const[n,s]=Ey(e,t);return n&&(n[s]=r),e}static getFocusability(e){let t="";if(e&&!e.hasAttribute("inert")){const{nodeName:r}=e,n=e.getAttribute("tabIndex");t=RP[r]||(r==="A"||r==="LINK")&&e.href||e.contentEditable==="true"?"n":"",n==="-1"?t+="fp":(t||n!=null)&&(t+="ft")}return YE[t]||(YE[t]=xP(t))}static isFocusable(e,t){return(e==null?void 0:e.nodeType)!==ir||e&&!t&&(!U.isVisible(e)||U.Widget.fromElement(e,_P))?!1:U.getFocusability(e).focusable}static isEditable(e,t){return!!((e.isContentEditable||QE[e.nodeName])&&(!t||e.nodeName!=="INPUT"||UE[e.type.toLowerCase()])&&!(e.readOnly||e.disabled||e.closest("[inert]")))}static isTextualInput(e){return QE[e.nodeName]&&(e.nodeName!=="INPUT"||UE[e.type.toLowerCase()])}static isInView(e,t=!1,r){if(!e||!wn(Hg(e.target)?e.target:e))return!1;const n=(r==null?void 0:r.positioned)&&vi.getStyleValue(r.element,"position")!=="fixed",s=$.from(globalThis),a=t?"contains":"intersect",o=n&&r.element.offsetParent,l=n&&$.from(o);if(s.height=lt.scrollingElement.scrollHeight,e===lt.body)return s;const d=this.getViewportIntersection(e,s,a);return d&&n&&d.translate(lt.scrollingElement.scrollLeft,lt.scrollingElement.scrollTop),n&&d?d.translate(-l.x+o.scrollLeft,-l.y+o.scrollTop):d}static getViewportIntersection(e,t,r){var n;const s=Hg(e.target)?e.target:null,a=s||e,o=vi.getVisibleViewport(hu(a,1),t,a),l=$.from(a,null,!0);return s&&(l.translate(e.offsetX+1,e.offsetY+1),l.height=l.width=0),(n=o==null?void 0:o[r])==null?void 0:n.call(o,l,!1,!0)}static getVisibleViewport(e,t,r){const{fullscreenElement:n}=lt;let s=t,a,o,l,d,c;for(c=e;!o&&c&&c!==lt.body;c=hu(c,1))if((a=o=c===n)||(d=c.ownerDocument.defaultView.getComputedStyle(c),a=(d.overflowX!=="visible"||d.overflowY!=="visible")&&d.display!=="contents"),a){const u=$.client(c,null,!0,!1,r,!1);if(!u.height||!u.width)return!1;s=(s==null?void 0:s.intersect(u))||u,l=c}return l&&(s=$.clipStickies(s,l,null,!0,r)),s}static isVisible(e){var t;let r=!1;for(;e;e=hu(e)){if(e.nodeType===WE)return!0;if(e.nodeType===ir){const n=(t=e.ownerDocument)==null?void 0:t.defaultView.getComputedStyle(e);if(r=r||n.getPropertyValue("visibility")==="visible",Hg(e)&&!Ty(e,r))return!1}}return!1}static isDOMEvent(e){return e instanceof Event}static merge(e,...t){return T.blend(e,t,{isObject:FP,merge:AP})}static normalizeChildren(e,t,r){var n;let s=e==null?void 0:e.children,a,o,l,d,c;if((n=e==null?void 0:e.syncOptions)!=null&&n.ignoreRefs&&(r=!0),s&&!(e instanceof Node))if(Array.isArray(s))for(o=0;o<s.length;++o)U.normalizeChildren(s[o],t,r);else{d=s,e.children=s=[];for(l in d)a=d[l],a!=null&&a.isWidget&&(a=a.element),c=!l.startsWith("$")&&!U.isElement(a),c&&(t==null||t(l,!r)),a&&(a instanceof Node||(a.reference===!1?delete a.reference:c&&typeof a!="string"&&(a.reference=l),U.normalizeChildren(a,t,r)),s.push(a))}return e}static roundPx(e,t=globalThis.devicePixelRatio||1){const r=1/t;return Math.round(e/r)*r}static floorPx(e,t=globalThis.devicePixelRatio||1){const r=1/t;return Math.floor(e*r)/r}static isCustomElement(e){return!!(e!=null&&e.shadowRoot)}static elementFromPoint(e,t){let r=document.elementFromPoint(e,t);return U.isCustomElement(r)&&(r=r.shadowRoot.elementFromPoint(e,t)||r),r}static childFromPoint(e,t,r,n=e){const s=r==null?t:new $(t,r,0,0);let a=null;return Array.from(e.children).reverse().some(o=>{if($.from(o,n).contains(s))return a=o.children.length&&U.childFromPoint(o,s,null,n)||o,!0}),a}static unitize(e,t,r="px"){const[n,s]=e0(e);return t!=null&&(t=String(t),t=s&&CP.test(t)?t+r:t),[n,t]}static get activeElement(){let e=document.activeElement;for(;e.shadowRoot;)e=e.shadowRoot.activeElement;return e}static getActiveElement(e){e!=null&&e.isWidget&&(e=e.element);let t=((e==null?void 0:e.getRootNode())||document).activeElement;for(;t!=null&&t.shadowRoot;)t=t.shadowRoot.activeElement;return t}static getRootElement(e){var t;const r=(t=e.getRootNode)==null?void 0:t.call(e),{nodeType:n}=r;return n===WE?r.body:n===$g?r:e.ownerDocument.contains(e)?e.ownerDocument.body:null}static getOutermostElement(e){var t;const r=(t=e.getRootNode)==null?void 0:t.call(e);if(r!=null&&r.body)return r==null?void 0:r.body;for(;e.parentNode!==r&&e.parentNode;)e=e.parentNode;return e}static isValidFloatRootParent(e){var t;return((t=e.tagName)==null?void 0:t.toUpperCase())==="BODY"||e.getRootNode().nodeType===$g}static getId(e){return e.id||(e.id="b-element-"+ ++kP)}static getCommonAncestor(e,t){var r,n;if(e===t)return e;for(;e&&!((r=e[e.isWidget?"owns":"contains"])!=null&&r.call(e,t)||e===t);)e=Hg(e)?hu(e):(n=e.owner)!=null&&n.isWidget&&e.owner!==e?e.owner:null;return e}static waitForSelector(e,t=5e3,r=100){var n;if(e!=null){const s=(n=e.endsWith)==null?void 0:n.call(e,"?"),a=e.nodeType?e:document.querySelector(s?e.substring(0,e.length-1):e);if(s){if(!a)return;t>0&&(t=-t)}return!a||!vi.isVisible(a)||t0().some(o=>o.contains(a))||!vi.isInView(a,!1)?yt.waitFor(()=>{const o=a||document.querySelector(e);if(o&&vi.isVisible(o)&&!t0().some(l=>l.contains(o))&&vi.isInView(o,!1))return o},t,r):a}}static getElement(e){return typeof e=="string"?lt.querySelector(e):e}static setAttributes(e,t){const r=U.getElement(e);if(r&&t)for(const n in t)t[n]==null?r.removeAttribute(n):r.setAttribute(n,t[n])}static toggleAttribute(e,t,r){const n=U.getElement(e);n&&(n.toggleAttribute?n.toggleAttribute(t,r):r!=null?n[r?"setAttribute":"removeAttribute"](t,""):n.hasAttribute(t)?n.removeAttribute(t):n.setAttribute(t,""))}static addAttributeValue(e,t,r){var n;const s=U.getElement(e);s&&r&&s.setAttribute(t,[...new Set((n=s.getAttribute(t))==null?void 0:n.split(" ")).add(r)].join(" "))}static removeAttributeValue(e,t,r){var n;const s=U.getElement(e);if(s&&r){const a=new Set((n=s.getAttribute(t))==null?void 0:n.split(" "));a.delete(r),a.size?s.setAttribute(t,[...a].join(" ")):s.removeAttribute(t)}}static setLength(e,t,r){return arguments.length===1?r=typeof e=="number"?`${e}px`:e!=null?e:"":(e=U.getElement(e),r=e.style[t]=typeof r=="number"?`${r}px`:r!=null?r:""),r}static percentify(e,t=2){const r=Math.pow(10,t);return e==null||e===""||isNaN(e)?"":`${Math.round(e*r)/r}%`}static getChild(e,t){return e.querySelector(":scope>"+t)}static hasChild(e,t){return U.getChild(e,t)!=null}static children(e,t){return(t[0]===">"||t.startsWith("# "))&&(t[0]==="#"&&(t=t.substr(2)),t=":scope "+t),Array.from(e.querySelectorAll(t))}static getChildElementCount(e){return e.childElementCount}static down(e,t){var r;return e?(r=e.matches)!=null&&r.call(e,t)?e:(t=":scope "+t,e.querySelector(t)):null}static isDescendant(e,t){const r=e.contains(t);if(!r&&t){const n=U.getRootElement(e),s=U.getRootElement(t);if(s&&n!==s&&s.host)return U.isDescendant(n,s.host)}return r}static getEventElement(e,t="target"){return!e||U.isElement(e)?e:e[t]}static isElement(e){return(e==null?void 0:e.nodeType)===ir&&U.isNode(e)}static isReactElement(e){var t,r;return!!((r=(t=globalThis.bryntum)==null?void 0:t.react)!=null&&r.isReactElement(e))}static handleReactElement(e,t){var r,n;return!!((n=(r=globalThis.bryntum)==null?void 0:r.react)!=null&&n.handleReactElement(e,t))}static handleReactHeaderElement(e,t,r){var n,s;return!!((s=(n=globalThis.bryntum)==null?void 0:n.react)!=null&&s.handleReactHeaderElement(e,t,r))}static isVueConfig(e){var t,r;return!!((r=(t=globalThis.bryntum)==null?void 0:t.vue)!=null&&r.isVueConfig(e))}static handleVueContent(e,t){var r,n;(n=(r=globalThis.bryntum)==null?void 0:r.vue)==null||n.handleVueContent(e,t)}static isNode(e){return!!e&&typeof e.nodeType=="number"&&!hP(e)}static forEachSelector(e,t,r){if(typeof e=="string")throw new Error("DomHelper.forEachSelector must provide a root element context (for shadow root scenario)");U.children(e,t).forEach(r)}static forEachChild(e,t){Array.from(e.children).forEach(t)}static removeEachSelector(e,t){U.forEachSelector(e,t,r=>r.remove())}static removeClsGlobally(e,...t){t.forEach(r=>U.forEachSelector(e,"."+r,n=>n.classList.remove(r)))}static getAncestor(e,t,r=null){let n=!1,s,a=e;for(t=L.asArray(t);a=a.parentElement;){if(t.includes(a)){n=!0;break}if(r&&a===r)break;s=a}return n?s||e:null}static getParents(e){const t=[];for(;e.parentElement;)t.push(e.parentElement),e=e.parentElement;return t}static makeValidId(e,t=""){return k.makeValidDomId(e,t)}static createElement(e={},t){var r,n;let s=t,a,o,l,d,c,u,h,f,g,m,v;if(typeof s=="boolean")throw new Error("Clean up");t&&(c=t.ignoreRefs,g=t.refOwner,m=t.refs,s=t.returnAll,v=t.syncIdField,c&&(l=!0,c=c!=="children")),typeof e.parent=="string"&&(e.parent=document.getElementById(e.parent));const y=e.parent||e.nextSibling&&e.nextSibling.parentNode,{dataset:b,html:C,reference:D,syncOptions:w,text:x}=e;if(w&&(v=w.syncIdField||v,d=w.ignoreRefs,d&&(l=!0,c=d!=="children",t={...t,ignoreRefs:!0})),c&&(g=null),e.ns?a=lt.createElementNS(e.ns,e.tag||"svg"):a=e.tag==="#fragment"?lt.createDocumentFragment():lt.createElement(e.tag||"div"),x!=null?U.setInnerText(a,x):C!=null&&(C instanceof DocumentFragment?a.appendChild(C):a.innerHTML=C),e.tooltip&&U.Widget.attachTooltip(a,e.tooltip),e.style&&U.applyStyle(a,e.style),b)for(h in b)f=b[h],f!=null&&(a.dataset[h]=f);y&&this.addChild(y,a,e.nextSibling),g&&(a.$refOwnerId=g.id),D&&!c&&(g?(a.$reference=D,g.attachRef(D,a,e)):(m||(t=Object.assign({},t),t.refs=m={}),m[D]=a,a.setAttribute("data-reference",D)));const R=e.className||e.class,M=Object.keys(e);for(R&&a.setAttribute("class",le.normalize(R)),o=0;o<M.length;++o)h=M[o],f=e[h],(u=wP[h])!=null?a[u||h]=f:!DP[h]&&h&&f!=null&&a.setAttribute(h,f);a.nodeType===ir&&!e["aria-hidden"]&&!("role"in e)&&!e.tabIndex&&!e.alt&&!vi.isFocusable(a,!0)&&!a.htmlFor&&a.setAttribute("role","presentation"),(n=t==null?void 0:t.callback)==null||n.call(t,{action:"newElement",domConfig:e,targetElement:a,syncId:g?D:t.syncIdField&&((r=e.dataset)==null?void 0:r[t.syncIdField])}),s===!0?t.returnAll=s=[a]:Array.isArray(s)&&s.push(a),e.children&&(v&&(a.syncIdMap={}),L.asArray(e.children).forEach(_=>{var F,A,P,V;if(_)if(typeof _=="string"){const B=document.createTextNode(_);g&&(B.$refOwnerId=g.id),a.appendChild(B)}else if(this.isReactElement(_))(F=t==null?void 0:t.reactCallback)==null||F.call(t,{jsx:_,domConfig:e,targetElement:a});else if(isNaN(_.nodeType)){_.parent=a,!_.ns&&e.ns&&(_.ns=e.ns);const B=U.createElement(_,{...t,ignoreRefs:(P=(A=e.syncOptions)==null?void 0:A.ignoreRef)!=null?P:l}),W=(V=_.dataset)==null?void 0:V[v];W!=null&&(a.syncIdMap[W]=B),delete _.parent}else a.appendChild(_)})),a.lastDomConfig=e;const I=m||s||a;return e.replaceElement&&e.replaceElement.replaceWith(I),I}static createElementFromTemplate(e,t=TP){const{array:r,raw:n,fragment:s}=t;let a;if(U.supportsTemplate){if((My||(My=lt.createElement("template"))).innerHTML=e,a=My.content,s)return a.cloneNode(!0)}else if(a=(i0||(i0=new DOMParser)).parseFromString(e,"text/html").body,s){const o=a.childNodes;for(a=document.createDocumentFragment();o.length;)a.appendChild(o[0]);return a}return n?a=a.childNodes:a=a.children,a.length===1&&!r?a[0]:Ry.call(a)}static triggerMouseEvent(e,t="contextmenu",r={}){const n=this.isInView(e),s=n==null?void 0:n.center;if(n){const a=new MouseEvent(t,{clientX:s.x,clientY:s.y,offsetX:n.width/2,offsetY:n.height/2,bubbles:!0,...r});return e.dispatchEvent(a),a}}static insertFirst(e,t){return t&&t.nodeType!==ir&&t.tag&&(t=U.createElement(t)),e.insertBefore(t,e.firstElementChild)}static insertBefore(e,t,r){return t&&t.nodeType!==ir&&t.tag&&(t=U.createElement(t)),r?e.insertBefore(t,r):U.insertFirst(e,t)}static insertAt(e,t,r){const n=Array.from(e.children);if(r>=n.length)return U.append(e,t);const s=n[r];return U.insertBefore(e,t,s)}static append(e,t){if(t.forEach){if(Array.isArray(t)&&(t=t.map(r=>JE(r))),e.append)e.append(...t);else{const r=document.createDocumentFragment();t.forEach(function(n){r.appendChild(n)}),e.appendChild(r)}return t}else return e.appendChild(JE(t))}static getTranslateX(e){const t=e.style.transform;let r=mP.exec(t);return r?parseFloat(r[2]):(r=Bg.exec(t)||Bg.exec(U.getStyleValue(e,"transform")),r?parseFloat(r[1]||r[3]):0)}static getTranslateY(e){const t=e.style.transform;let r=pP.exec(t);if(r){const n=parseFloat(r[r[1]==="Y"?2:3]);return isNaN(n)?0:n}else return r=Bg.exec(t)||Bg.exec(U.getStyleValue(e,"transform")),r?parseFloat(r[2]||r[4]):0}static getTranslateXY(e){return[U.getTranslateX(e),U.getTranslateY(e)]}static getOffsetX(e,t=null){return t?e.getBoundingClientRect().left-t.getBoundingClientRect().left:e.offsetLeft}static getOffsetY(e,t=null){return t?e.getBoundingClientRect().top-t.getBoundingClientRect().top:e.offsetTop}static getOffsetXY(e,t=null){return[U.getOffsetX(e,t),U.getOffsetY(e,t)]}static getPageX(e){return e.getBoundingClientRect().left+xy.pageXOffset}static getPageY(e){return e.getBoundingClientRect().top+xy.pageYOffset}static getExtremalSizePX(e,t){const r=k.hyphenate(t),n=r.split("-")[1];let s=U.getStyleValue(e,r);return/%/.test(s)?e.parentElement?s=parseInt(U.getStyleValue(e.parentElement,n),10):s=NaN:s=parseInt(s,10),s}static setScale(e,t,r=t){const n=U.getStyleValue(e,"transform").split(/,\s*/);n.length>1?(n[0].startsWith("matrix3d")?(n[0]=`matrix3d(${t}`,n[5]=r):(n[0]=`matrix(${t}`,n[3]=r),e.style.transform=n.join(",")):e.style.transform=`scale(${t}, ${r})`}static setTranslateX(e,t){const r=U.getStyleValue(e,"transform").split(/,\s*/);t=U.roundPx(t),r.length>1?(r[r[0].startsWith("matrix3d")?12:4]=t,e.style.transform=r.join(",")):e.style.transform=`translateX(${t}px)`}static setTranslateY(e,t){const r=U.getStyleValue(e,"transform").split(/,\s*/);t=U.roundPx(t),r.length>1?(r[r[0].startsWith("matrix3d")?13:5]=t,e.style.transform=r.join(",")+")"):e.style.transform=`translateY(${t}px)`}static setTop(e,t){U.setLength(e,"top",t)}static setLeft(e,t){U.setLength(e,"left",t)}static setTopLeft(e,t,r){U.setLength(e,"top",t),U.setLength(e,"left",r)}static setTopInsetInlineStart(e,t,r){U.setLength(e,"top",t),U.setLength(e,"inset-inline-start",r)}static setRect(e,{x:t,y:r,width:n,height:s}){U.setTopInsetInlineStart(e,r,t),U.setLength(e,"width",n),U.setLength(e,"height",s)}static setTranslateXY(e,t,r){if(t==null)return U.setTranslateY(e,r);if(r==null)return U.setTranslateX(e,t);t=U.roundPx(t),r=U.roundPx(r);const n=U.getStyleValue(e,"transform").split(/,\s*/),s=n[0].startsWith("matrix3d");n.length>1?(n[s?12:4]=t,n[s?13:5]=r,e.style.transform=n.join(",")+")"):e.style.transform=`translate(${t}px, ${r}px)`}static addTranslateX(e,t){U.setTranslateX(e,U.getTranslateX(e)+t)}static addTranslateY(e,t){U.setTranslateY(e,U.getTranslateY(e)+t)}static addLeft(e,t){U.setLeft(e,U.getOffsetX(e)+t)}static addTop(e,t){U.setTop(e,U.getOffsetY(e)+t)}static alignTo(e,t,r=uP,n,s="translate"){t=t instanceof $?t:$.from(t,!0);const a=$.from(e,!0);n&&(a.roundPx(),t.roundPx());const o=a.alignTo(Object.assign(r,{target:t}));if(s==="topInset"){const l=[parseInt(e.style.insetInlineStart||0,10),parseInt(e.style.top||0,10)];U.setTopInsetInlineStart(e,l[1]+o.y-a.y,l[0]+o.x-a.x)}else if(s==="topLeft"){const l=[parseInt(e.style.left||0,10),parseInt(e.style.top||0,10)];U.setTopLeft(e,l[1]+o.y-a.y,l[0]+o.x-a.x)}else{const l=U.getTranslateXY(e);U.setTranslateXY(e,l[0]+o.x-a.x,l[1]+o.y-a.y)}}static getStyleValue(e,t,r,n){const s=r?e.style:e.ownerDocument.defaultView.getComputedStyle(e,n);if(Array.isArray(t)){const a={};for(const o of t)a[o]=s.getPropertyValue(k.hyphenate(o));return a}return s.getPropertyValue(k.hyphenate(t))}static getEdgeSize(e,t,r){const n=t==="border"?"-width":"",s={raw:{}};for(const a of["top","right","bottom","left"])(!r||r.includes(a[0]))&&(s[a]=parseFloat(s.raw[a]=U.getStyleValue(e,`${t}-${a}${n}`)));return s.width=(s.left||0)+(s.right||0),s.height=(s.top||0)+(s.bottom||0),s}static parseStyle(e){if(typeof e=="string"){const t=e.split(yP);e={};for(let r=0,{length:n}=t;r<n;r++){const s=t[r].split(bP);e[s[0]]=s[1]}}return e||{}}static applyStyle(e,t,r=!1){if(typeof t=="string")r?(t.length||e.style.cssText.length)&&(e.style.cssText=t):e.style.cssText+=t;else if(t){r&&(e.style.cssText=""),t.style&&typeof t.style!="string"&&(t=T.assign({},t,t.style));let n,s;for(n in t)ZE[n]||([n,s]=U.unitize(n,t[n]),s==null?e.style.removeProperty(n):e.style.setProperty(n,s));typeof t.style=="string"&&(e.style.cssText+=t.style)}}static getCSSText(e){if(typeof e=="string")return e;let t="";for(const r in e)ZE[r]||(t+=`${k.hyphenate(r)}:${e[r]};`);return t}static assignClasses(e,t){T.forEach(t,(r,n)=>e.classList.toggle(n,!!r))}static toggleClasses(e,t,r=null){t=L.asArray(t),r===!0?e.classList.add(...t):r===!1?e.classList.remove(...t):t.forEach(n=>e.classList.toggle(n))}static addTemporaryClass(e,t,r,n=globalThis,s=t){r>0&&(e.classList.add(t),n===globalThis?n.setTimeout(()=>e==null?void 0:e.classList.remove(t),r):n.setTimeout({fn:a=>e.classList.remove(a),delay:r,name:s,args:[t],cancelOutstanding:!0}))}static getPropertyTransitionDuration(e,t){const r=globalThis.getComputedStyle(e),n=r.transitionProperty.split(", "),s=r.transitionDuration.split(", "),a=n.indexOf(k.hyphenate(t));let o;return a!==-1&&(o=parseFloat(s[a])*1e3),o}static getAnimationDuration(e){return parseFloat(U.getStyleValue(e,"animation-duration"))*1e3}static highlight(e,t=globalThis){return e instanceof $?e.highlight():new Promise(r=>{t.setTimeout(()=>{e.classList.add("b-fx-highlight"),t.setTimeout(()=>{e.classList.remove("b-fx-highlight"),r()},2e3)},0)})}static get scrollBarWidth(){if(xo===null){const e=r0||(r0=U.createElement({parent:lt.documentElement,className:"b-scrollbar-measure-element",style:"position:absolute;top:-9999em;height:100px;overflow-y:scroll"}));e.parentNode!==lt.documentElement&&lt.documentElement.appendChild(e),xo=e.offsetWidth,lt.documentElement.style.setProperty("--b-scrollbar-width",`${xo}px`)}return xo}static get scrollBarPadElement(){return{className:"b-yscroll-pad",children:[{className:"b-yscroll-pad-sizer"}]}}static get scrollLimit(){const e=vi.createElement({parent:document.body,style:"position:absolute; left:-999px; top:0; width:5px; height:5px",children:[{style:"position:absolute; width:1px; height:1px"}]}),t=e.firstElementChild;let r=0,n=2e7;for(;n>1e6&&(t.style.transform=`translateY(${n}px)`,e.style.lineHeight=`${r=1-r}`,!(e.scrollHeight>=n));)n-=1e6;return Object.defineProperty(vi,"scrollLimit",{value:n}),e.remove(),n}static resetScrollBarWidth(){xo=null}static measureText(e,t,r=!1,n=void 0){const s=U.getMeasureElement(t,n);s[r?"innerHTML":"innerText"]=e;const a=s.clientWidth;return s.className="",a}static measureSize(e,t,r=!0){var n;if(!e)return 0;if(typeof e=="number")return e;if(!e.length)return 0;if(/^\d+(px)?$/.test(e))return parseInt(e);if(t){const s=(n=e.includes)==null?void 0:n.call(e,"%"),a=U.getMeasureElement(t,s?t.parentNode:void 0),{parentElement:o}=a;a.innerHTML="",s&&(o.style.display="contents"),a.style.minWidth=a.style.maxWidth=U.setLength(e);const l=r?a.offsetWidth:a.getBoundingClientRect().width;return o.style.display="",a.style.minWidth=a.style.maxWidth=a.className="",l}return/^\d+em$/.test(e)?parseInt(e)*cP:isNaN(e)?0:parseInt(e)}static getMeasureElement(e,t){t=t||lt.body;const r=xy.getComputedStyle(e),n=t.offScreenDiv=t.offScreenDiv||U.createElement({parent:t,style:"position:fixed;top:-10000px;left:-10000px;visibility:hidden;contain:strict",className:"b-measure-element",children:[{style:"white-space:nowrap;display:inline-block;will-change:contents;width:auto;contain:none"}]},{returnAll:!0})[1];return IP.forEach(s=>{n.style[s]!==r[s]&&(n.style[s]=r[s])}),n.className=e.className,n.parentElement.parentElement!==t&&t.appendChild(n.parentElement),n}static stripTags(e){return(U.$domParser||(U.$domParser=new DOMParser)).parseFromString(e,"text/html").body.textContent}static sync(e,t){if(typeof e=="string")if(e===""){t.innerHTML="";return}else e=U.createElementFromTemplate(e);return U.performSync(e,t),t}static performSync(e,t){return e.outerHTML!==t.outerHTML?(U.syncAttributes(e,t),U.syncContent(e,t),U.syncChildren(e,t),!0):!1}static getSyncAttributes(e){const t={},r=[];for(let n=0;n<e.attributes.length;n++){const s=e.attributes[n];if(s.specified){const a=s.name.toLowerCase();t[a]=s.value,r.push(a)}}return{attributes:t,names:r}}static syncAttributes(e,t){const{attributes:r,names:n}=U.getSyncAttributes(e),{attributes:s,names:a}=U.getSyncAttributes(t),o=n.includes("dataset"),l=n.filter(u=>!a.includes(u)),d=a.filter(u=>!n.includes(u)&&(!o||!u.startsWith("data-"))),c=n.filter(u=>a.includes(u));if(l.length>0)for(let u=0;u<l.length;u++){const h=l[u];h==="style"?U.applyStyle(t,r.style,!0):h==="dataset"?Object.assign(t.dataset,r.dataset):t.setAttribute(h,r[h])}if(d.length>0)for(let u=0;u<d.length;u++)t.removeAttribute(d[u]);if(c.length>0)for(let u=0;u<c.length;u++){const h=c[u];if(h==="style")U.applyStyle(t,r.style,!0);else if(h==="dataset")Object.assign(t.dataset,r.dataset);else if(h==="class"&&(r.class.isDomClassList||typeof r.class=="object")){let f;r.class.isDomClassList?f=r.class:f=new le(r.class),f.isEqual(s.class)||t.setAttribute("class",f)}else s[h]!==r[h]&&t.setAttribute(h,r[h])}}static syncContent(e,t){U.getChildElementCount(e)===0&&(t.innerText=e.innerText)}static setInnerText(e,t){const{firstChild:r}=e;(r==null?void 0:r.nodeType)===cu?r.data=t:e.textContent=t}static syncChildren(e,t){const r=this,n=Ry.call(e.childNodes),s=Ry.call(t.childNodes);for(;n.length;){const a=n.shift(),o=s.shift();if(a&&a.nodeType!==cu&&a.nodeType!==ir)throw new Error(`Source node type ${a.nodeType} not supported by DomHelper.sync()`);if(o&&o.nodeType!==cu&&o.nodeType!==ir)throw new Error(`Target node type ${o.nodeType} not supported by DomHelper.sync()`);if(!o)t.appendChild(a);else if(a.nodeType===o.nodeType)a.nodeType===cu?o.data=a.data:a.tagName===o.tagName?r.performSync(a,o):(t.insertBefore(a,o),o.remove());else if(a.nodeType===cu&&o.nodeType===ir)t.innerText=a.data.trim();else{const l=a.parentElement||a;throw new Error(`Currently no support for transforming nodeType.
${l.outerHTML}`)}}s.forEach(a=>{a.remove()})}static syncClassList(e,t){const{classList:r}=e,n=typeof t=="string",s=n?t.split(vP):le.normalize(t,"array"),a=s.length;let o=r.length!==a,l;for(l=0;!o&&l<a;l++)o=!r.contains(s[l]);return o&&(e.className=n?t:s.join(" ")),o}static updateClassList(e,t){const{classList:r}=e;let n,s,a=!1;for(n in t)s=!!t[n],r.contains(n)!==s&&(r[s?"add":"remove"](n),a=!0);return a}static setTheme(e,t){e=e.toLowerCase();const{head:r}=document,n=U.getThemeInfo(t).name.toLowerCase();let s=r.querySelectorAll("[data-bryntum-theme]:not([data-loading])"),a=0;if(n===e)return MP;U.removeEachSelector(r,"#bryntum-theme[data-loading],link[data-bryntum-theme][data-loading]");const o={theme:e,prev:n};function l(d,c,u){const h=vi.createElement({tag:"link",rel:"stylesheet",dataset:{loading:!0,bryntumTheme:!0},href:d.href.replace(n,e),nextSibling:d});h.addEventListener("load",()=>{delete h.dataset.loading,Hs=null,++a===s.length&&(U._isDarkTheme=null,s.forEach(f=>f.remove()),ce.trigger("theme",o),c(o))}),h.addEventListener("error",f=>{delete h.dataset.loading,u(f)})}if(s.length)return new Promise((d,c)=>{s.forEach((u,h)=>{l(u,d,c,h===s.length-1)})});{const d=r.querySelector("#bryntum-theme:not([data-loading])")||r.querySelector(`[href*="${n}.css"]:not([data-loading])`);if(!(d!=null&&d.href.includes(`${n}.css`)))throw new Error(`Theme link for ${n} not found`);return s=[d],new Promise((c,u)=>l(d,c,u))}}static get themeInfo(){return vi.getThemeInfo()}static getThemeInfo(e){if(!Hs){const t=U.createElement({parent:document.body,className:"b-theme-info"}),r=U.getStyleValue(t,"content",!1,":before");if(r)try{Hs=JSON.parse(r.replace(/^["']|["']$|\\/g,""))}catch(n){Hs=null}Hs=Hs||(e?{name:e}:null),t.remove()}return Hs}static get isDarkTheme(){if(U._isDarkTheme==null){const e=vi.createElement({className:"b-widget",parent:document.body});U._isDarkTheme=U.getStyleValue(e,"color-scheme")==="dark",e.remove()}return U._isDarkTheme}static async transition({element:e,selector:t="[data-dom-transition]",duration:r,action:n,thisObj:s=this,addTransition:a={},removeTransition:o={}}){const l=new Set,d=!e.style.height,c=Array.from(e.querySelectorAll(t)),u=new Map(c.map(m=>{let v=0,y=m.parentElement;for(;y&&y!==e;)v++,y=y.parentElement;m.$depth=v,m.scrollHeight>m.offsetHeight&&getComputedStyle(m).overflow==="auto"&&(m.$scrollTop=m.scrollTop,l.add(m));const{parentElement:b}=m,C=$.from(m,e),D=$.from(m,b),w=getComputedStyle(b),x=parseFloat(w.borderLeftWidth);return x&&(C.left-=x,D.left-=x),[m.id,{element:m,globalBounds:C,localBounds:D,depth:v,parentElement:b}]}));d&&(e.style.height=e.offsetHeight+"px"),n.call(s);const h=Array.from(e.querySelectorAll(t)),f=new Map(h.map(m=>{const v=$.from(m,e),y=$.from(m,m.parentElement),b=globalThis.getComputedStyle(m.parentElement),C=parseFloat(b.borderLeftWidth);return C&&(v.left-=C,y.left-=C),[m.id,{element:m,globalBounds:v,localBounds:y}]})),g=["position","top","left","width","height","padding","margin","zIndex","minWidth","minHeight","opacity","overflow"];e.classList.add("b-dom-transition-snapshot");for(const[m,v]of u){const y=f.get(m);if(y){const{element:b}=y,{style:C,parentElement:D}=b,w=parseInt(U.getStyleValue(b,"zIndex")),{globalBounds:x,localBounds:R,depth:M,parentElement:I}=v,_=I!==D;T.copyProperties(b.$initial={parentElement:D},C,g);let F;_?(y.bounds=y.globalBounds,F=x,e.appendChild(b)):(y.bounds=y.localBounds,F=R,I.appendChild(b));let A="hidden";l.has(b)&&(b.$scrollPlaceholder=U.createElement({parent:b,style:{height:b.scrollHeight}}),A="auto");const P={position:"absolute",top:`${F.top}px`,left:`${F.left}px`,width:`${F.width}px`,height:`${F.height}px`,minWidth:0,minHeight:0,margin:0,zIndex:M+(w||0),overflow:A};b.dataset.domTransition!=="preserve-padding"&&(P.padding=0),Object.assign(C,P),y.processed=!0}else{const{element:b,localBounds:C,depth:D,parentElement:w}=v;b.$initial={removed:!0},Object.assign(b.style,{position:"absolute",top:`${C.top}px`,left:`${C.left}px`,width:`${C.width}px`,height:`${C.height}px`,minWidth:0,minHeight:0,padding:0,margin:0,zIndex:D,overflow:"hidden"}),w.appendChild(b),f.set(m,{element:b,bounds:C,removed:!0,processed:!0}),h.push(b)}}for(const[,m]of f)if(!m.processed){const{element:v}=m,{style:y,parentElement:b}=v,C=m.bounds=m.localBounds;v.classList.add("b-dom-transition-adding"),T.copyProperties(v.$initial={parentElement:b},y,g),Object.assign(y,{position:"absolute",top:a.top?0:`${C.top}px`,left:a.left?0:`${C.left}px`,width:a.width?0:`${C.width}px`,height:a.height?0:`${C.height}px`,opacity:a.opacity?0:null,zIndex:b.$depth+1,overflow:"hidden"})}for(const m of l)m.scrollTop=m.$scrollTop;e.classList.add("b-dom-transition"),e.firstElementChild.offsetWidth;for(const[,{element:m,bounds:v,removed:y}]of f)y?Object.assign(m.style,{top:o.top?0:`${v.top}px`,left:o.left?0:`${v.left}px`,width:o.width?0:`${v.width}px`,height:o.height?0:`${v.height}px`,opacity:o.opacity?0:m.$initial.opacity}):Object.assign(m.style,{top:`${v.top}px`,left:`${v.left}px`,width:`${v.width}px`,height:`${v.height}px`,opacity:m.$initial.opacity});await yt.sleep(r),e.classList.remove("b-dom-transition","b-dom-transition-snapshot");for(const m of h)m.$initial&&(m.$initial.removed?m.remove():(T.copyProperties(m.style,m.$initial,g),m.$scrollPlaceholder&&(m.$scrollPlaceholder.remove(),delete m.$scrollPlaceholder),m.classList.remove("b-dom-transition-adding"),m.$initial.parentElement.appendChild(m)));d&&(e.style.height="");for(const m of l)m.scrollTop=m.$scrollTop,delete m.$scrollTop}static async loadScript(e){return new Promise((t,r)=>{const n=document.createElement("script");n.src=e,n.onload=t,n.onerror=r,document.head.appendChild(n)})}static isNamedColor(e){return e&&SP.test(e)}static createColorStyle(e){return e!=null&&e.length?this.isNamedColor(e)?`var(--cal-color-${e})`:e:""}static get NodeFilter(){return NodeFilter}static addChild(e,t,r){e.insertBefore(t,r)}static cloneStylesIntoShadowRoot(e,t){return new Promise((r,n)=>{t&&e.querySelectorAll('style, link[rel="stylesheet"]').forEach(o=>o.remove());const s=document.querySelectorAll('link[rel="stylesheet"]');let a=0;s.forEach(o=>{const l=o.cloneNode();l.addEventListener("load",()=>{a+=1,a===s.length&&r()}),l.addEventListener("error",d=>{n(l.href)}),e.appendChild(l)}),document.querySelectorAll("style").forEach(o=>{const l=o.cloneNode();l.innerHTML=o.innerHTML,e.appendChild(l)}),s.length||r()})}};p(Vg,"$name","DomHelper"),p(Vg,"_usingKeyboard",!1),p(Vg,"enableKeyboardCssModifiers",!0);var E=Vg;ye.register(E);var U=E,n0,LP=()=>U.isTouchEvent=!1,s0=()=>{U.isTouchEvent=!0,clearTimeout(n0),n0=setTimeout(LP,400)};lt.addEventListener("touchstart",s0,!0),lt.addEventListener("touchend",s0,!0),U.canonicalStyles=uu,U.supportsTemplate="content"in lt.createElement("template"),U.elementExpandoKey=qE,U.numberRe=GE,Node.prototype.closest=function(i){var e;return(e=this.parentNode)==null?void 0:e.closest(i)},globalThis.addEventListener("resize",()=>xo=null),E._$name="DomHelper";var fu=new Map,OP=5,$P=i=>i.floating,BP={touchend:1,pointerup:1},HP={Meta:1,Control:1,Alt:1,Shift:1},a0=i=>{(Ro==null?void 0:Ro.pointerId)===i.pointerId&&(Ro=null)},Iy=i=>{const{touches:e}=i;if(fu.clear(),e)for(let t=0;t<e.length;t++){const r=e.item(t);fu.set(r.identifier,[r,i])}},ri=new class extends O.mixin(Ie){suspendFocusEvents(){jg=!0}resumeFocusEvents(){jg=!1}setupFocusListenersOnce(e,t){e&&!ri.observedElements.has(e)&&(ri.setupFocusListeners(e,t),ri.observedElements.add(e))}detachFocusListeners(e){e.$globalEventsDetacher&&(e.$globalEventsDetacher(),e.$globalEventsDetacher=null,ri.observedElements.delete(e))}setupFocusListeners(e=document,t,r=!1){let n,s,a;const o={element:e,fromGlobal:!0,touchstart(l){const{touches:d}=l;if(Iy(l),d.length===2&&d[0].target.closest(".b-widget")&&d[1].target.closest(".b-widget")){n=[d[0],d[1]],s=[(n[0].clientX+n[1].clientX)/2,(n[0].clientY+n[1].clientY)/2],a=E.elementFromPoint(s[0],s[1]);return}if(!ni&&l.changedTouches.length===1){if(ni=l.changedTouches[0],!Y.isAndroid){const c=({clientX:f,clientY:g,type:m})=>{(BP[m]||!ni||Math.max(Math.abs(f-ni.clientX),Math.abs(g-ni.clientY))>OP)&&(_y=null,u(),clearTimeout(h))},u=t.on({element:document,touchmove:c,touchend:c,pointermove:c,pointerup:c,capture:!0}),h=setTimeout(()=>{_y=ni.identifier,u(),l.target.dispatchEvent(new MouseEvent("contextmenu",t.copyEvent({},l)))},t.longPressTime)}}else ni=null},touchmove:{passive:!1,handler:l=>{const{touches:d}=l;if(d.length===2&&n){const c=[d[0],d[1]],u=t.getDistanceBetween(n[0],n[1])-t.getDistanceBetween(c[0],c[1]),h=Math.abs(n[0].clientX-n[1].clientX)-Math.abs(c[0].clientX-c[1].clientX),f=Math.abs(n[0].clientY-n[1].clientY)-Math.abs(c[0].clientY-c[1].clientY);if(Math.abs(u)>2){const g={clientX:s[0],clientY:s[1],bubbles:!0};if(ri.Widget.convertPinchToMousewheel){l.preventDefault(),l.stopImmediatePropagation();const v=new MouseEvent("wheel",{...g,ctrlKey:!0});v.deltaY=f,v.deltaX=h,a.dispatchEvent(v)}const m=new MouseEvent("bryntum-pinch",g);m.deltaY=f,m.deltaX=h,m.touchMove=l,a.dispatchEvent(m)}n=c}}},touchend:{passive:!1,handler:l=>{Iy(l),l.touches.length!==2&&(n=null),ni&&(l.changedTouches[0].identifier===_y?(l.stopImmediatePropagation(),l.cancelable!==!1&&l.preventDefault()):l.changedTouches.length===1&&l.changedTouches[0].identifier===ni.identifier&&ri.trigger("globaltap",{event:l}),ni=null)}},touchcancel:{passive:!1,handler:Iy},mousedown:{handler:l=>{zg="mouse",ni||ri.trigger("globaltap",{event:l}),Dn=l;const d=l.ctrlKey||l.altKey||l.shiftKey||l.metaKey;!nt&&d?nt=new KeyboardEvent("keydown",{key:l.ctrlKey?"Control":l.shiftKey?"Shift":l.altKey?"Alt":"Meta",ctrlKey:l.ctrlKey,altKey:l.altKey,shiftKey:l.shiftKey,metaKey:l.metaKey}):nt&&!d&&(nt=null)},passive:!1},mouseup:{handler:l=>{ri.trigger("mouseup",{event:l}),Dn=null},passive:!1},pointerdown:{passive:!1,handler:l=>{Ro=l,E.setUsingKeyboard(e,!1)}},pointerup:{passive:!1,handler:a0},pointercancel:{passive:!1,handler:a0},keydown(l){const{key:d,target:c}=l;if(zg="key",nt=l,Fy=c,!HP[d]){if(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE)for(const u of e.children)u.matches(".b-outer")&&E.setUsingKeyboard(u,!0);else E.setUsingKeyboard(e,!0);d==="Escape"&&ri.Widget.queryAll(u=>u.isTooltip&&u.isVisible).forEach(u=>u.hide())}},mouseenter(l){Fy=l.target},keypress(){zg="key"},keyup(){nt=null},focusin(l){var d;const{Widget:c}=ri,{target:u}=l;if(u!=null&&u.shadowRoot||u!=null&&u._shadowRoot)return;if(Y.supportsPointerEvents&&(u!=null&&u.matches(":focus-visible"))&&!bryntum.fromElement(u,x=>x.isDestroying||x.isDestroyed)){const x=u.matches("[class*=event-wrap],[class*=task-wrap]")?u.firstElementChild:u,R=$.from(x),M=R.center;x.dispatchEvent(new PointerEvent("pointerover",{bubbles:!0,clientX:M.x,clientY:M.y,pointerType:"focus"}))}if(jg||u&&!u.isConnected)return;const h=l.relatedTarget?l.relatedTarget instanceof HTMLElement?l.relatedTarget:document.body:null,f=u||document.body,g=c.fromElement(h),m=c.fromElement(f),v=E.getCommonAncestor(g,m||f),y=!!(h&&f.compareDocumentPosition(h)&4),b=c.query(VP);let C=null;if(f&&f!==document.body?C=E.getActiveElement(f):C=E.getActiveElement(document),b&&!b._isRevertingFocus&&(!m||!b.owns(m)&&!(b.element.compareDocumentPosition(m.element)&4&&m.up($P))))return b.focus();let D=Py("focusout",h,u,g,m,y);for(let x=g,R;x&&x!==v;x=R)if(R=x.owner,!x.isDestroying&&x.onFocusOut&&(x.onFocusOut(D),u&&C!==E.getActiveElement(u)))return;if(v&&u===v.element)!v.isDestroying&&E.getActiveElement(v)===f&&v.focusElement&&v.focusElement!==v.element&&(!v.element.contains(C)||v.focusDescendant)&&v.setTimeout(()=>{var x;return(x=v.focus)==null?void 0:x.call(v)},0);else{D=Py("focusin",f,h,g,m,y);for(let x=m;x&&x!==v;x=x.owner)x.isDestroying||(d=x.onFocusIn)==null||d.call(x,D)}const w=E.getCommonAncestor((h==null?void 0:h.nodeType)===Element.ELEMENT_NODE?h:null,f)||f.parentNode;w&&(D=Py("focusmove",f,h,g,m,y,{bubbles:!0}),w.dispatchEvent(D))},focusout(l){if(!jg&&!(l.target.classList.contains("tox-tinymce-aux")&&!l.isTrusted)&&(!l.relatedTarget||!ri.Widget.fromElement(l.relatedTarget))){const d=l.relatedTarget&&l.relatedTarget instanceof HTMLElement?l.relatedTarget:null;o.focusin({target:d,relatedTarget:l.target}),nt=Dn=null}},blur:{element:globalThis,handler(l){l.target===globalThis&&(nt=null,Dn=null)}},capture:!0,passive:!0};r&&(Ay==null||Ay()),Ay=this.detachEvents=e.$globalEventsDetacher=t.on(o)}get activeTouchCount(){return fu.size}get activeTouches(){return Array.from(fu.values())}get hasActiveTouches(){return fu.size>0}get lastInteractionType(){return zg}get shiftKeyDown(){return!!(nt!=null&&nt.shiftKey)}get ctrlKeyDown(){return!!(nt!=null&&nt.ctrlKey||nt!=null&&nt.metaKey)}get altKeyDown(){return!!(nt!=null&&nt.altKey)}get currentOverElement(){return Fy}isKeyDown(e){return e?(nt==null?void 0:nt.key)===e||nt[(e==null?void 0:e.toLowerCase())+"Key"]===!0:!!nt}isMouseDown(e=0){return(Dn==null?void 0:Dn.button)===e}get currentMouseDown(){return Dn}set currentMouseDown(e){Dn=e}get currentPointerDown(){return Ro}set currentPointerDown(e){Ro=e}get currentTouch(){return ni}set currentTouch(e){ni=e}get currentKeyDown(){return nt}set currentKeyDown(e){nt=e}},VP=i=>i.isTopModal;ri.observedElements=new Set;var ni,_y,jg=!1,zg,nt,Dn,Ro,Fy,Ay;function Py(i,e,t,r,n,s,a){const o=new CustomEvent(i,a);return Object.defineProperty(o,"_target",{get(){return e}}),Object.defineProperty(o,"relatedTarget",{get(){return t}}),o.fromWidget=r,o.toWidget=n,o.backwards=s,o}var ce=ri,jP=/^(\w+)=(.*)$/,zP=function(i){const e={},t=i.split("&");for(const r of t){const[n,s,a]=jP.exec(r),o=decodeURIComponent(s),l=decodeURIComponent(a);if(n){let d=e[o];d?(Array.isArray(d)||(d=e[o]=[d]),d.push(l)):e[o]=l}}return e},o0=class So{static get(e,t){return this.fetch(e,t)}static post(e,t,r={}){return r=X.assign({},r),!(t instanceof FormData)&&typeof t!="string"&&(t=JSON.stringify(t),r.headers=r.headers||{},r.headers["Content-Type"]=r.headers["Content-Type"]||"application/json"),this.fetch(e,Object.assign({method:"POST",body:t},r))}static fetch(e,t){let r;if(t=X.merge({},So.DEFAULT_FETCH_OPTIONS,t),typeof AbortController!="undefined"&&(t.abortController?r=t.abortController:r=t.abortController=new AbortController,t.signal=r.signal),t.queryParams){const s=Object.entries(t.queryParams);if(s.length){let a=!1;if(t.headers&&t.addQueryParamsToBody===!0){const o=new Headers(t.headers).get("Content-Type");let l;switch(o){case"application/x-www-form-urlencoded":l=URLSearchParams;break;case"multipart/form-data":l=FormData;break}if(l){const d=t.body||(t.body=new l);d instanceof l&&(s.forEach(([c,u])=>d.set(c,u)),a=!0)}}a||(e+=(e.includes("?")?"&":"?")+s.map(([o,l])=>`${o}=${encodeURIComponent(l)}`).join("&"))}}const n=new Promise((s,a)=>{fetch(e,t).then(o=>{t.parseJson?o.json().then(l=>{o.parsedJson=l,s(o)}).catch(l=>{o.parsedJson=null,o.error=l,a(o)}):s(o)}).catch(o=>{o.stack=n.stack,a(o)})});return n.stack=new Error().stack,n.abort=function(){r==null||r.abort(new DOMException("User aborted request","AbortError")),this.aborted=!0},n}static mockUrl(e,t){const r=this;(r.mockAjaxMap||(r.mockAjaxMap={}))[e]=t,So.originalFetch||(So.originalFetch=So.fetch,So.fetch=r.mockAjaxFetch.bind(r))}static async mockAjaxFetch(e,t){const r=e.split("?");let n=this.mockAjaxMap[r[0]],s=null;if(n){typeof n=="function"&&(n=await n(r[0],r[1]&&zP(r[1]),t));try{s=(t==null?void 0:t.parseJson)&&JSON.parse(n.responseText)}catch(a){s=null,n.error=a}return n=Object.assign({status:200,ok:!0,headers:new Headers,statusText:"OK",url:e,parsedJson:s,text:()=>new Promise(a=>{a(n.responseText)}),json:()=>new Promise(a=>{a(s)})},n),new Promise(function(a,o){n.synchronous?a(n):setTimeout(function(){a(n)},"delay"in n?n.delay:100)})}else return So.originalFetch(e,t)}};p(o0,"DEFAULT_FETCH_OPTIONS",{});var Wt=o0;Wt._$name="AjaxHelper";var l0=class Pr{static mergeLocales(...e){const t={};return e.forEach(r=>{Object.keys(r).forEach(n=>{typeof r[n]=="object"?t[n]={...t[n],...r[n]}:t[n]=r[n]})}),t}static trimLocale(e,t){const r=(n,s)=>{e[n]&&(s?e[n][s]&&delete e[n][s]:delete e[n])};Object.keys(t).forEach(n=>{Object.keys(t[n]).length>0?Object.keys(t[n]).forEach(s=>r(n,s)):r(n)})}static normalizeLocale(e,t){if(!e)throw new Error('"nameOrConfig" parameter can not be empty');if(typeof e=="string"){if(!t)throw new Error('"config" parameter can not be empty');t.locale?t.name=e||t.name:t.localeName=e}else t=e;let r={};if(t.name||t.locale)r=Object.assign({localeName:t.name},t.locale),t.desc&&(r.localeDesc=t.desc),t.code&&(r.localeCode=t.code),t.path&&(r.localePath=t.path);else{if(!t.localeName)throw new Error(`"config" parameter doesn't have "localeName" property`);r=Object.assign({},t)}for(const n of["name","desc","code","path"])r[n]&&delete r[n];if(!r.localeName)throw new Error("Locale name can not be empty");return r}static get locales(){return Pr.global.bryntum.locales||{}}static set locales(e){Pr.global.bryntum.locales=e}static get localeName(){return Pr.global.bryntum.locale||"En"}static set localeName(e){Pr.global.bryntum.locale=e||Pr.localeName}static get locale(){return Pr.localeName&&this.locales[Pr.localeName]||this.locales.En||Object.values(this.locales)[0]||{localeName:"",localeDesc:"",localeCoode:""}}static publishLocale(e,t){const{locales:r}=Pr.global.bryntum,n=Pr.normalizeLocale(e,t),{localeName:s}=n;return!r[s]||t===!0?r[s]=n:r[s]=this.mergeLocales(r[s]||{},n||{}),r[s]}static get global(){return globalThis}};p(l0,"skipLocaleIntegrityCheck",!1);var St=l0;St.global.bryntum=St.global.bryntum||{},St.global.bryntum.locales=St.global.bryntum.locales||{},St._$name="LocaleHelper";var d0=class extends Ie(O){construct(...i){var e;const t=this;if(super.construct(...i),Y.isBrowserEnv){const r=document.querySelector("script[data-default-locale]");r?t.applyLocale(r.dataset.defaultLocale):(e=t.locale)!=null&&e.localeName&&t.applyLocale(t.locale.localeName)}}get locales(){return St.locales}set locales(i){St.locales=i}set locale(i){this.applyLocale(i)}get locale(){return St.locale}get localeCode(){var i,e;return(e=(i=this.locale)==null?void 0:i.localeCode)!=null?e:"en-US"}applyLocale(i,e,t=!1){const r=this;let n;if(typeof i=="string")if(typeof e!="object"){if(n=r.locales[i],!n){if(t)return!0;throw new Error(`Locale "${i}" is not published. Publish with LocaleHelper.publishLocale() before applying.`)}}else n=St.publishLocale(i,e);else n=St.publishLocale(i);if(r.locale.localeName&&r.locale.localeName===n.localeName&&e!==!0)return r.locale;n.oldLocaleName=r.locale.localeName,n.oldLocaleCode=r.locale.localeCode,St.localeName=n.localeName;const s=()=>{r.trigger("locale",n)};return n.localePath?new Promise((a,o)=>{r.loadLocale(n.localePath).then(l=>{l.text().then(d=>{new Function(d)(),Y.isBrowserEnv&&(n=r.locales[n.localeName],n&&delete n.localePath),s(),a(n)})}).catch(l=>o(l))}):(s(),n)}loadLocale(i){return Wt.get(i)}};p(d0,"configurable",{throwOnMissingLocale:te.isTestEnv});var NP=new d0,ke=NP,WP=Object.getPrototypeOf(Object),c0=/L{.*?}/g,u0=/L{(.*?)}/g,h0=/((.*?)\.)?(.+)/g,UP=i=>i.replace(/{(\d+)}/gm,"[[$1]]"),f0=i=>i.replace(/\[\[(\d+)]]/gm,"{$1}"),g0=Object.freeze(Object.create(null)),je=i=>{var e;return e=class extends(i||O){static get configurable(){return{localeClass:null,localizable:null,localizableProperties:{value:[],$config:{merge:"distinct"}}}}static clsName(t){var r,n;return typeof t=="string"?t:t===WP?"Object":t.$$name||t.name||((r=t.prototype)==null?void 0:r.$$name)||((n=t.prototype)==null?void 0:n.name)}static parseLocaleString(t){const r=[];let n;if(t!=null&&t.includes("L{"))for(t=UP(t),u0.lastIndex=0;(n=u0.exec(t))!=null;){h0.lastIndex=0;const s=h0.exec(n[1]);r.push({match:f0(n[0]),localeKey:f0(s[3]),localeClass:s[2]})}return r.length>0?r:[{match:t,localeKey:t,localeClass:void 0}]}construct(t={},...r){super.construct(t,...r),ke.ion({locale:"updateLocalization",thisObj:this}),this.updateLocalization()}get localeClass(){return this._localeClass||null}localizeProperty(t){var r,n,s;const a=this,o=X.getPath(a,t),l=((r=a.$meta.configs[t])==null?void 0:r.localeKey)||((s=(n=a.fieldMap)==null?void 0:n[t])==null?void 0:s.defaultValue);let d;if(l)if(d=e.localize(l,a,a.localeClass||a),d&&!(t in(a.initialConfig||g0))&&!(t in(a.originalData||g0)))X.setPath(a.isColumn?a.data:a,t,d);else return o;else typeof o=="string"&&(a.originalLocales=a.originalLocales||{},d=X.getPath(a.originalLocales,t),d===void 0&&(X.setPath(a.originalLocales,t,o),d=o),d&&X.setPath(a,t,d=a.optionalL(d,a)));return d||o}updateLocalization(){var t,r;this.localizable!==!1&&((t=this.localizableProperties)==null||t.forEach(this.localizeProperty,this),(r=this.trigger)==null||r.call(this,"localized"))}static getTranslation(t,r,n){const s=ke.locale;let a=null,o,l;if(s)for(const{match:d,localeKey:c,localeClass:u}of this.parseLocaleString(t)){const h=g=>{var m;const v=(m=s[g])==null?void 0:m[c];return v&&(typeof v=="function"?a=r!=null?v(r):v:typeof v=="object"||t===d?a=v:a=(a||t).replace(d,v),typeof v=="string"&&v.includes("L{")&&(a=this.getTranslation(v,r,n))),v};let f=!1;for(l=n;l&&(o=e.clsName(l))&&!(f=h(o));l=Object.getPrototypeOf(l))if(typeof l=="string")break;!f&&u&&h(u)}return a}static localize(t,r=void 0,...n){(n==null?void 0:n.length)===0&&(n=[this]);let s=null;return n.some(a=>(s=e.getTranslation(t,r,a),s!=null)),s}static L(t,r=void 0,...n){(n==null?void 0:n.length)===0&&(n=[this]);const s=this.localize(t,r,...n);if(s==null&&ke.throwOnMissingLocale&&t.includes("L{"))throw new Error(`Localization is not found for '${t}' in '${n.map(a=>e.clsName(a)).join(", ")}'. ${ke.locale.localeName?`Locale : ${ke.locale.localeName}`:""}`);return s!=null?s:t}L(t,r,n=this.localeClass){const{constructor:s}=this;return n&&e.clsName(n)!==e.clsName(s)?e.L(t,r,n,s):e.L(t,r,s)}static optionalL(t,r=void 0,...n){const s=ke.throwOnMissingLocale;ke.throwOnMissingLocale=s&&c0.test(t),(n==null?void 0:n.length)===0&&(n=[this]);const a=e.L(t,r,...n);return ke.throwOnMissingLocale=s,a}optionalL(t,r=this,n=!1){const s=ke.throwOnMissingLocale;ke.throwOnMissingLocale=s&&c0.test(t)&&!n;const a=this.L(t,r);return ke.throwOnMissingLocale=s,a}get localeManager(){return ke}get localeHelper(){return St}},p(e,"$name","Localizable"),e};function GP(i,e){const t=T.getPropertyDescriptor(i,e);return t&&(t.get||t.set)?t:null}var ie=class extends O.mixin(Ie,je){onConfigChange(...i){var e,t;super.onConfigChange(...i),this.isConfiguring||(t=(e=this.client)==null?void 0:e.afterPluginConfigChange)==null||t.call(e,{plugin:this,...i[0]})}updateClient(i){this.owner||(this.owner=i)}updateKeyMap(i){const{client:e}=this;e.keyMap=e.mergeKeyMaps(e.keyMap,i,k.uncapitalize(this.constructor.$name))}static initPlugins(i,...e){for(const t of e)this.initPlugin(i,t)}static initPlugin(i,e,t){const r=i.plugins||(i.plugins={}),n=[i];return t&&n.push(t),r[e.$$name]=new e(...n)}get enabled(){return!this.disabled}getFocusRevertTarget(){var i;return(i=this.client)==null?void 0:i.getFocusRevertTarget()}construct(...i){const e=this;let[t,r]=i,n;i.length===1?T.isObject(t)&&(r=t,t=r.client):(r=T.assign({},r),delete r.client),e.client=t,super.construct(r),e.applyPluginConfig(t),n=e.clientListeners,n&&(n=T.assign({},n),n.thisObj=e,t.ion(n))}applyPluginConfig(i){const e=this,t=e.pluginConfig||e.constructor.pluginConfig;if(t){const{assign:r,chain:n,after:s,before:a,override:o}=t;r&&e.applyAssign(i,r),(n||s)&&e.applyChain(i,n||s),a&&e.applyChain(i,a,!1),o&&e.applyOverride(i,o)}}applyAssign(i,e){e.forEach(t=>this.assign(i,t))}applyChain(i,e,t=!0){if(Array.isArray(e))for(const r of e)this.chain(i,r,r,t);else for(const r in e)this.chain(i,r,e[r],t)}applyOverride(i,e){const t=this;t.overridden||(t.overridden={}),e.forEach(r=>{if(!t[r])throw new Error(`Trying to chain fn ${i.$$name}#${r}, but plugin fn ${t.$$name}#${r} does not exist`);typeof i[r]=="function"&&(t.overridden[r]=i[r].bind(i)),i[r]=t[r].bind(t)})}assign(i,e){const t=this,r=GP(t,e);r?Object.defineProperty(i,e,{configurable:!0,enumerable:!0,get:r.get&&r.get.bind(t),set:r.set&&r.set.bind(t)}):i[e]=t[e].bind(t)}chain(i,e,t,r=!0){let n=0;typeof e=="object"&&(e=e.fn),typeof t=="object"&&(n=t.prio||0,t=t.fn);const s=this,a=i.pluginFunctionChain||(i.pluginFunctionChain={}),o=s[t]&&s[t].bind(s),l=s.functionChainRunner;if(!o)throw new Error(`Trying to chain fn ${i.$$name}#${t}, but plugin fn ${s.$$name}#${t} does not exist`);if(!a[e]){let d=i[e];d&&(d=d.bind(i),d.$this=i,d.$prio=0),a[e]=d?[d]:[],i[e]=(...c)=>l(a[e],c)}o.$this=s,o.$prio=n,a[e][r?"push":"unshift"](o),a[e].$sorted=!1}functionChainRunner(i,e){let t,r,n;for(i.$sorted||(i.sort((s,a)=>a.$prio-s.$prio),i.$sorted=!0),r=0;r<i.length&&(t=i[r],!(!t.$this.isDestroyed&&(n=t(...e),n===!1)));r++);return n}doDisable(i){var e,t,r,n;const s=this,{constructor:a}=s,o="featureClass"in a?a.featureClass:`b-${a.$$name.toLowerCase()}`,l=k.uncapitalize(a.$$name);o&&((t=(e=s.client)==null?void 0:e._element)==null||t.classList[i?"remove":"add"](o)),s.isConfiguring||(i?s.trigger("disable"):s.trigger("enable"),(n=(r=s.client).syncSplits)==null||n.call(r,d=>{const c=d.features[l];c&&(c.disabled=i)}))}updateDisabled(i){this.doDisable(i)}throwOverrideIsMissing(i){throw new Error(`Trying to override fn ${i.plugIntoName}#${i.fnName}, but plugin fn ${i.pluginName}#${i.fnName} does not exist`)}get rootElement(){return this.client.rootElement}get state(){var i;return(i=this.constructor.stateProperties)==null?void 0:i.reduce((e,t)=>(e[t]=this[t],e),{})}};p(ie,"$name","InstancePlugin"),p(ie,"configurable",{disabled:!1,client:null,keyMap:null}),p(ie,"properties",{clientListeners:null}),ie._$name="InstancePlugin";var ky=i=>{var e;return e=class extends(i||O){get plugins(){return this._plugins||(this._plugins={}),this._plugins}set plugins(t){t&&(Array.isArray(t)||(t=[t]),ie.initPlugins(this,...t)),this.initPlugins()}initPlugins(){}addPlugins(...t){ie.initPlugins(this,...t)}addPlugin(t,r){return ie.initPlugin(this,t,r)}hasPlugin(t){return this.getPlugin(t)!=null}getPlugin(t){var r;return typeof t=="function"&&(t=t.$$name),(r=this.plugins)==null?void 0:r[t]}get widgetClass(){}},p(e,"$name","Pluggable"),e},qP={localeName:"En",localeDesc:"English (US)",localeCode:"en-US",localeRtl:!1,Object:{Yes:"Yes",No:"No",Cancel:"Cancel",Ok:"OK",Week:"Week",None:"None",previous:"Previous",next:"Next",to:"to",at:"At",on:"On",editing:i=>`Editing ${i}`,settings:"Settings",close:"Close",go:"Go",save:"Save",cancel:"Cancel",revert:"Revert",collapse:"Collapse",expand:"Expand",today:"Today"},CheckboxGroup:{wrongNbrOfOptionsSelected:i=>`Select exactly ${i}`,tooFewOptionsSelected:i=>`Select at least ${i}`,tooManyOptionsSelected:i=>`Select no more than ${i}`},CodeEditor:{apply:"Apply",autoApply:"Auto apply",downloadCode:"Download code",editor:"Code editor",viewer:"Code viewer"},ColorPicker:{noColor:"No color"},Combo:{noResults:"No results",recordNotCommitted:"Record could not be added",addNewValue:i=>`Add ${i}`},FilePicker:{file:"File"},Field:{badInput:"Invalid field value",patternMismatch:"Value should match a specific pattern",rangeOverflow:i=>`Value must be less than or equal to ${i.max}`,rangeUnderflow:i=>`Value must be greater than or equal to ${i.min}`,stepMismatch:"Value should fit the step",tooLong:"Value should be shorter",tooShort:"Value should be longer",typeMismatch:"Value is required to be in a special format",valueMissing:"This field is required",invalidValue:"Invalid field value",minimumValueViolation:"Minimum value violation",maximumValueViolation:"Maximum value violation",fieldRequired:"This field is required",validateFilter:"Value must be selected from the list"},DateField:{invalidDate:i=>"Invalid date input, expected format is "+i},DatePicker:{gotoPrevYear:"Go to previous year",gotoPrevMonth:"Go to previous month",gotoNextMonth:"Go to next month",gotoNextYear:"Go to next year"},Hint:{dontShowAgain:"Don't show again"},NumberFormat:{locale:"en-US",currency:"USD"},DurationField:{invalidUnit:"Invalid unit"},TimeField:{invalidTime:"Invalid time input"},TimePicker:{hour:"Hour",minute:"Minute",second:"Second"},List:{loading:"Loading...",selectAll:"Select All"},GridBase:{loadMask:"Loading...",syncMask:"Saving changes, please wait..."},PagingToolbar:{firstPage:"Go to first page",prevPage:"Go to previous page",page:"Page",nextPage:"Go to next page",lastPage:"Go to last page",reload:"Reload current page",noRecords:"No records to display",pageCountTemplate:i=>`of ${i.lastPage}`,summaryTemplate:i=>`Displaying records ${i.start} - ${i.end} of ${i.allCount}`},Popup:{close:"Close",maximize:"Maximize"},TabPanel:{containsInvalidFields:"Tab contains invalid fields"},Toolbar:{showOverflowingItems:"Show overflowing items",scrollForMore:"Scroll for more"},UndoRedo:{Undo:"Undo",Redo:"Redo",UndoLastAction:"Undo last action",RedoLastAction:"Redo last undone action",NoActions:"No items in the undo queue"},FieldFilterPicker:{equals:"equals",doesNotEqual:"does not equal",isEmpty:"empty",isNotEmpty:"not empty",contains:"contains",doesNotContain:"does not contain",startsWith:"starts with",endsWith:"ends with",isOneOf:"one of",isNotOneOf:"not one of",isGreaterThan:"greater than",isLessThan:"less than",isGreaterThanOrEqualTo:"greater or equals",isLessThanOrEqualTo:"less or equals",isBetween:"between",isNotBetween:"not between",isBefore:"before",isAfter:"after",timeEquals:"time equals",timeDoesNotEqual:"time does not equal",isToday:"today",isTomorrow:"tomorrow",isYesterday:"yesterday",isThisWeek:"this week",isNextWeek:"next week",isLastWeek:"last week",isThisMonth:"this month",isNextMonth:"next month",isLastMonth:"last month",isThisYear:"this year",isNextYear:"next year",isLastYear:"last year",isYearToDate:"year to date",isTrue:"true",isFalse:"false",selectAProperty:"Select property",selectAnOperator:"Select operator",caseSensitive:"Case-sensitive",and:"and",dateFormat:"D/M/YY",selectValue:"Select value",selectOneOrMoreValues:"Select value(s)",enterAValue:"Enter value",enterANumber:"Enter number",selectADate:"Select date",selectATime:"Select time"},FieldFilterPickerGroup:{addFilter:"Add filter",applyCond:i=>i?"Skip filter (currently applied)":"Apply filter (currently skipped)"},DateHelper:{locale:"en-US",weekStartDay:0,nonWorkingDays:{0:!0,6:!0},weekends:{0:!0,6:!0},unitNames:[{single:"millisecond",plural:"ms",abbrev:"ms"},{single:"emillisecond",plural:"ems",abbrev:"ems"},{single:"second",plural:"seconds",abbrev:"s"},{single:"esecond",plural:"eseconds",abbrev:"es"},{single:"minute",plural:"minutes",abbrev:"min"},{single:"eminute",plural:"eminutes",abbrev:"emin"},{single:"hour",plural:"hours",abbrev:"h"},{single:"ehour",plural:"ehours",abbrev:"eh"},{single:"day",plural:"days",abbrev:"d"},{single:"eday",plural:"edays",abbrev:"ed"},{single:"week",plural:"weeks",abbrev:"w"},{single:"eweek",plural:"eweeks",abbrev:"ew"},{single:"month",plural:"months",abbrev:"mon"},{single:"emonth",plural:"emonths",abbrev:"emon"},{single:"quarter",plural:"quarters",abbrev:"q"},{single:"equarter",plural:"equarters",abbrev:"eq"},{single:"year",plural:"years",abbrev:"yr"},{single:"eyear",plural:"eyears",abbrev:"eyr"},{single:"decade",plural:"decades",abbrev:"dec"},{single:"edecade",plural:"edecades",abbrev:"edec"}],unitAbbreviations:[["mil"],["emil"],["s","sec"],["es","esec"],["m","min"],["em","emin"],["h","hr"],["eh","ehr"],["d"],["ed"],["w","wk"],["ew","ewk"],["mo","mon","mnt","M"],["emo","emon","emnt"],["q","quar","qrt"],["eq","equar","eqrt"],["y","yr"],["ey","eyr"],["dec"],["edec"]],parsers:{L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A"},ordinalSuffix:i=>{const e=["11","12","13"].find(r=>i.endsWith(r));let t="th";if(!e){const r=i[i.length-1];t={1:"st",2:"nd",3:"rd"}[r]||"th"}return i+t},decade:i=>{const e=typeof i=="number"?i:i.getFullYear();return`${e-e%10}s`}}},Uj=St.publishLocale(qP),{toString:m0}=Object.prototype,YP=m0.call(new Date),Ng=new Date,p0=1e3*60*60,To=(i,e)=>isNaN(i)||i==null?e:i,KP=/([ES]){([^}]+)}/g,v0=i=>{const e=["11","12","13"].find(r=>i.endsWith(r));let t="th";if(!e){const r=i[i.length-1];t={1:"st",2:"nd",3:"rd"}[r]||"th"}return i+t},nr=(i,e,t,r=Ot)=>(r[i]=r[i]||{[i]:1},r[e]=r[e]||{[e]:1},r[i][e]=t,r[e][i]=1/t,r),Et=(i,e,t)=>(sr[i]||(sr[i]=new Intl.DateTimeFormat($r,e))).format(t),gu=(i,e,t,r=!1)=>{let n=Et(i,e,t);return/am|pm/i.test(n)&&(n=n.replace(/^0/,""),r&&(n=n.replace(/:00/,""))),n},XP=(i,e)=>Math.floor((i.getTime()-e.getTime()-(i.getTimezoneOffset()-e.getTimezoneOffset())*Ot.minute.millisecond)/Ot.day.millisecond)+1,y0=i=>i>=0?i:i+7,ZP=/([^\w])(S+)/gm,QP=(i,e)=>e+"SSS",b0=/[:.\-/\s]/,C0=/^(?:יום |ال)/,JP=/(Z{1,2})$/,ek=/(?:Z|[+-]\d{2}:\d{2})$/,$r="en-US",Br=v0,Wg={},mu={},sr={},Ly={},Oy={},Ug="AM",Gg="PM",$y=p0,Mo,Io,S0=i=>{const e=jy[i];if(!e)throw new Error("Only international formats should be used here");if(mu[i]!==void 0)return mu[i];const t=new Intl.DateTimeFormat($r,e),r=t.formatToParts(new Date(2001,1,2,3,4,5,6)).map(n=>{const s=n.type,a=e[s];if(s==="literal")return n.value.replace(/,/g,"");if(s==="day")return a==="numeric"?"D":"DD";if(s==="month")return a==="short"?"MMM":a==="long"?"MMMM":a==="numeric"?"M":"MM";if(s==="year")return a==="numeric"?"YYYY":"YY"}).join("");return mu[i]=r},By=2020,Hy=0,Vy=1,jy={l:{year:"numeric",month:"numeric",day:"numeric"},ll:{year:"numeric",month:"short",day:"numeric"}},bt={M:i=>i.getMonth()+1,Mo:i=>Br(bt.M(i).toString()),MM:i=>(i.getMonth()+1).toString().padStart(2,"0"),MMM:i=>Et("MMM",{month:"short"},i),MMMM:i=>Et("MMMM",{month:"long"},i),DC:i=>S.localize("L{decade}",i),Q:i=>Math.ceil((i.getMonth()+1)/3),Qo:i=>Br(bt.Q(i).toString()),D:i=>i.getDate(),Do:i=>Br(bt.D(i).toString()),DD:i=>i.getDate().toString().padStart(2,"0"),DDD:i=>Math.ceil((new Date(i.getFullYear(),i.getMonth(),i.getDate(),12,0,0)-new Date(i.getFullYear(),0,0,12,0,0))/Ot.day.millisecond),DDDo:i=>Br(bt.DDD(i).toString()),DDDD:i=>bt.DDD(i).toString().padStart(3,"0"),d:i=>i.getDay(),do:i=>Br(i.getDay().toString()),d1:i=>Et("d1",{weekday:"narrow"},i).substr(0,1),dd:i=>bt.ddd(i).substring(0,2),ddd:i=>{var e;return Mo=Et("ddd",{weekday:"short"},i),Io=(e=Mo.match(C0))==null?void 0:e[0],Mo.substring(Io?Io.length:0)},dddd:i=>{var e;return Mo=Et("dddd",{weekday:"long"},i),Io=(e=Mo.match(C0))==null?void 0:e[0],Mo.substring(Io?Io.length:0)},u:i=>{const e=sr.u||(sr.u=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",year:"numeric",month:"2-digit",day:"2-digit"})),t=e.formatToParts(i);return`${t[4].value}${t[2].value}${t[0].value}Z`},uu:i=>{const e=sr.uu||(sr.uu=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",hour12:!1,year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit"})),t=e.formatToParts(i);return`${t[4].value}${t[2].value}${t[0].value}T${t[6].value}${t[8].value}${t[10].value}Z`},e:i=>i.getDay(),E:i=>i.getDay()+1,W:i=>S.getWeekNumber(i)[1],Wo:i=>Br(bt.W(i).toString()),WW:i=>bt.W(i).toString().padStart(2,"0"),Wp:i=>`${S.localize("L{Week}")} ${bt.W(i)}`,WWp:i=>`${S.localize("L{Week}")} ${bt.WW(i)}`,Wp0:i=>`${S.localize("L{Week}")[0]}${bt.W(i)}`,WWp0:i=>`${S.localize("L{Week}")[0]}${bt.WW(i)}`,Y:i=>i.getFullYear(),YY:i=>(i.getFullYear()%100).toString().padStart(2,"0"),YYYY:i=>i.getFullYear(),A:i=>(i.getHours()<12?Ug:Gg).toLocaleUpperCase(),a:i=>(i.getHours()<12?Ug:Gg).toLocaleLowerCase(),H:i=>i.getHours(),HH:i=>i.getHours().toString().padStart(2,"0"),h:i=>i.getHours()%12||12,hh:i=>bt.h(i).toString().padStart(2,"0"),k:i=>i.getHours()||24,kk:i=>bt.k(i).toString().padStart(2,"0"),K:i=>gu("K",{hour:"numeric"},i),KK:i=>gu("KK",{hour:"2-digit"},i),m:i=>i.getMinutes(),mm:i=>bt.m(i).toString().padStart(2,"0"),s:i=>i.getSeconds(),ss:i=>bt.s(i).toString().padStart(2,"0"),S:i=>Math.floor(i.getMilliseconds()/100).toString(),SS:i=>Math.floor(i.getMilliseconds()/10).toString().padStart(2,"0"),SSS:i=>i.getMilliseconds().toString().padStart(3,"0"),z:i=>Et("z",{timeZoneName:"short"},i),zz:i=>Et("zz",{timeZoneName:"long"},i),Z:i=>H.getGMTOffset(i),LT:i=>gu("LT",{hour:"2-digit",minute:"2-digit"},i),LST:i=>gu("LST",{hour:"numeric",minute:"2-digit"},i,!0),LTS:i=>gu("LTS",{hour:"2-digit",minute:"2-digit",second:"2-digit"},i),L:i=>Et("L",{year:"numeric",month:"2-digit",day:"2-digit"},i),l:i=>Et("l",jy.l,i),LL:i=>Et("LL",{year:"numeric",month:"long",day:"numeric"},i),ll:i=>Et("ll",jy.ll,i),LLL:i=>Et("LLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit"},i),lll:i=>Et("lll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit"},i),LLLL:i=>Et("LLLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"long"},i),llll:i=>Et("llll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"short"},i)},tk=Object.keys(bt).sort((i,e)=>e.length-i.length),ik=`^(?:${tk.join("|")})`,_t=()=>({}),rk=i=>ck.test(i),zy=i=>rk(i)&&{milliseconds:parseInt(i.padEnd(3,"0").substring(0,3))},w0={YYYY:i=>{const e=parseInt(i);return{year:e>=1e3&&e<=9999?e:NaN}},Y:i=>({year:parseInt(i)}),YY:i=>{const e=parseInt(i);return{year:e+(e>1968?1900:2e3)}},M:i=>({month:parseInt(i)-1}),MM:i=>({month:parseInt(i)-1}),Mo:i=>({month:parseInt(i)-1}),MMM:i=>{const e=(i||"").toLowerCase();for(const[t,r]of Object.entries(S._monthShortNamesIndex))if(e.startsWith(t))return{month:r.value}},MMMM:i=>{const e=(i||"").toLowerCase();for(const[t,r]of Object.entries(S._monthNamesIndex))if(e.startsWith(t))return{month:r.value}},DD:i=>({date:parseInt(i)}),D:i=>({date:parseInt(i)}),Do:i=>({date:parseInt(i)}),DDD:_t,DDDo:_t,DDDD:_t,d:_t,do:_t,d1:_t,dd:_t,ddd:_t,dddd:_t,Q:_t,Qo:_t,W:_t,Wo:_t,WW:_t,e:_t,E:_t,HH:i=>({hours:parseInt(i)}),hh:i=>({hours:parseInt(i)}),mm:i=>({minutes:parseInt(i)}),H:i=>({hours:parseInt(i)}),m:i=>({minutes:parseInt(i)}),ss:i=>({seconds:parseInt(i)}),s:i=>({seconds:parseInt(i)}),S:zy,SS:zy,SSS:zy,A:i=>({amPm:i.toLowerCase()}),a:i=>({amPm:i.toLowerCase()}),L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A",l:{type:"dynamic",parser:()=>S0("l")},ll:{type:"dynamic",parser:()=>S0("ll")},Z:i=>{if(!i||!R0.test(i)&&i!=="Z")return null;let e=0;if(i!=="Z"){const t=R0.exec(i);if(t){const r=t[1]==="+"?1:-1,n=parseInt(t[2])||0,s=parseInt(t[3])||0;e=r*(n*60+s)}else e=-1*new Date().getTimezoneOffset()}return{timeZone:e}}},nk=Object.keys(w0).sort((i,e)=>e.length-i.length),D0=new RegExp(`(${nk.join("|")})`),sk=new RegExp("^(LL|LLL|lll|LLLL|llll)$"),Ot={decade:{decade:1,year:10,quarter:40,month:120,week:520,day:3652,hour:24*3652,minute:1440*3652,second:86400*3652,millisecond:864e5*3652},year:{decade:.1,year:1,quarter:4,month:12,week:52,day:365,hour:24*365,minute:1440*365,second:86400*365,millisecond:864e5*365},quarter:{decade:1/40,year:1/4,quarter:1,month:3,week:4,day:91,hour:24*91,minute:1440*91,second:86400*91,millisecond:864e5*91},month:{decade:1/120,year:1/12,quarter:1/3,month:1,week:4,day:-30,hour:-24*30,minute:-1440*30,second:-86400*30,millisecond:-864e5*30},week:{decade:-1/520,year:-1/52,quarter:-1/13,month:-1/4,day:7,hour:168,minute:10080,second:604800,millisecond:6048e5},day:{decade:-1/3652,year:-1/365,quarter:-1/91,month:-1/30,week:1/7,hour:24,minute:1440,second:86400,millisecond:864e5},hour:{decade:-1/(3652*24),year:-1/(365*24),quarter:-1/(91*24),month:-1/(30*24),week:1/168,day:1/24,minute:60,second:3600,millisecond:36e5},minute:{decade:-1/(3652*1440),year:-1/(365*1440),quarter:-1/(91*1440),month:-1/(30*1440),week:1/10080,day:1/1440,hour:1/60,second:60,millisecond:6e4},second:{decade:-1/(3652*86400),year:-1/(365*86400),quarter:-1/(91*86400),month:-1/(30*86400),week:1/604800,day:1/86400,hour:1/3600,minute:1/60,millisecond:1e3},millisecond:{decade:-1/(3652*864e5),year:-1/(365*864e5),quarter:-1/(91*864e5),month:-1/(30*864e5),week:1/6048e5,day:1/864e5,hour:1/36e5,minute:1/6e4,second:1/1e3}},E0={ms:"millisecond",milliseconds:"millisecond",ems:"emillisecond",emilliseconds:"emillisecond",s:"second",seconds:"second",es:"esecond",eseconds:"esecond",m:"minute",mi:"minute",min:"minute",minutes:"minute",em:"eminute",emi:"eminute",emin:"eminute",eminutes:"eminute",h:"hour",hours:"hour",eh:"ehour",ehours:"ehour",d:"day",days:"day",ed:"eday",edays:"eday",w:"week",weeks:"week",ew:"eweek",eweeks:"eweek",M:"month",mo:"month",mon:"month",months:"month",EM:"emonth",eM:"emonth",emo:"emonth",emon:"emonth",emonths:"emonth",q:"quarter",quarters:"quarter",eq:"equarter",equarters:"equarter",y:"year",years:"year",ey:"eyear",eyears:"eyear",dec:"decade",decades:"decade",edec:"edecade",edecades:"edecade"},ak=/^\s*([-+]?\d+(?:[.,]\d*)?|[-+]?(?:[.,]\d+))\s*([^\s]+)?/i,ok=/^\s*([-+]?\d+)(?![.,])\s*([^\s]+)?/i,_o=["millisecond","emillisecond","second","esecond","minute","eminute","hour","ehour","day","eday","week","eweek","month","emonth","quarter","equarter","year","eyear","decade","edecade"],lk=[["ms","mil"],["ems","emil"],["s","sec"],["es","esec"],["m","min"],["em","emin"],["h","hr"],["eh","ehr"],["d"],["ed"],["w","wk"],["ew","ewk"],["mo","mon","mnt","M"],["emo","emon","emnt"],["q","quar","qrt"],["eq","equar","eqrt"],["y","yr"],["ey","eyr"],["dec"],["edec"]],Ny=["decade","year","month","week","day","hour","minute","second","millisecond"],x0=["milliseconds","seconds","minutes","hours","date","month","year"],dk=i=>{const e=parseFloat(i);return isNaN(e)?null:e},ck=/^[0-9]+$/,R0=/([+-])(\d\d):*(\d\d)*$/,ar={millisecond:{magnitude:0,smaller:void 0,greater:"second"},second:{magnitude:2,smaller:"millisecond",greater:"minute"},minute:{magnitude:4,smaller:"second",greater:"hour"},hour:{magnitude:6,smaller:"minute",greater:"day"},day:{magnitude:8,smaller:"hour",greater:"week"},week:{magnitude:10,smaller:"day",greater:"month"},month:{magnitude:12,smaller:"week",greater:"quarter"},quarter:{magnitude:14,smaller:"month",greater:"year"},year:{magnitude:16,smaller:"quarter",greater:"decade"},decade:{magnitude:18,smaller:"year"},emillisecond:{magnitude:1,smaller:void 0,greater:"esecond"},esecond:{magnitude:3,smaller:"emillisecond",greater:"eminute"},eminute:{magnitude:5,smaller:"esecond",greater:"ehour"},ehour:{magnitude:7,smaller:"eminute",greater:"eday"},eday:{magnitude:9,smaller:"ehour",greater:"eweek"},eweek:{magnitude:11,smaller:"eday",greater:"emonth"},emonth:{magnitude:12,smaller:"eweek",greater:"equarter"},equarter:{magnitude:14,smaller:"emonth",greater:"eyear"},eyear:{magnitude:16,smaller:"equarter",greater:"edecade"},edecade:{magnitude:18,smaller:"eyear"}},uk={round(i,e=1){return Math.round(i/e)*e},floor(i,e=1){return Math.floor(i/e)*e},ceil(i,e=1){return Math.ceil(i/e)*e}};nr("edecade","millisecond",3600*864e5),nr("eyear","millisecond",360*864e5),nr("equarter","millisecond",90*864e5),nr("emonth","millisecond",30*864e5),nr("eweek","millisecond",7*864e5),nr("eday","millisecond",864e5),nr("ehour","millisecond",36e5),nr("eminute","millisecond",6e4),nr("esecond","millisecond",1e3),nr("emillisecond","millisecond",1e3);var Wy=class Nt extends je(){static set defaultFormat(e){H._defaultFormat=e}static get defaultFormat(){return H._defaultFormat||"YYYY-MM-DDTHH:mm:ssZ"}static set defaultParseFormat(e){this._defaultParseFormat=e}static get defaultParseFormat(){return this._defaultParseFormat||this._defaultFormat||"YYYY-MM-DDTHH:mm:ss.SSSZ"}static get today(){return Nt.clearTime(new Date,!1)}static get tomorrow(){return Nt.add(Nt.today,1,"day")}static get yesterday(){return Nt.add(Nt.today,-1,"day")}static buildParser(e){const t=e.split(D0),r=[];return t.length===1||sk.test(e)?[]:(t.reduce((n,s,a,o)=>{if(a!==0||s!=="")if(D0.test(s)){const l=this.localize("L{parsers}")||{},d=l[s]||w0[s];if(s==="Z"&&a<o.length-2)throw new Error(`Invalid format ${e} TimeZone (Z) must be last token`);const c=typeof d=="function"||typeof d=="string"?d:d.parser();if(typeof c=="string"){const u=H.buildParser(c),h=u.pop();delete h.last,r.push(...u),n=h}else n.pattern=s,n.fn=c}else n.splitter=s,n.escapedSplitter=k.escapeRegExp(s),n.canUseUnstrictSplitter=b0.test(s),r.push(n),n={};else Object.prototype.hasOwnProperty.call(n,"pattern")&&r.push(n);return n},{}),r[r.length-1].last=!0,r.parseTimeZone=JP.test(e),r)}static makeKey(e){if(e.length===10)return e;e.getTime&&(e=e.getTime());const t=Oy[Math.trunc(e/$y)];if(t)return t;Ng.setTime(e);const r=Ng.getMonth()+1,n=Ng.getDate();return Oy[Math.trunc(e/$y)]=`${Ng.getFullYear()}-${r<10?"0"+r:r}-${n<10?"0"+n:n}`}static parseKey(e){const t=(e==null?void 0:e[0])==="-",r=H.parse(t?e.slice(1):e,"YYYY-MM-DD");return t&&r.setFullYear(-r.getFullYear()),r}static parse(e,t=H.defaultParseFormat,r=!1){if(e instanceof Date)return e;if(typeof e!="string"||!e)return null;const n={year:null,month:null,date:null,hours:null,minutes:null,seconds:null,milliseconds:null};t=t.replace(ZP,QP);let s=Ly[t],a=null,o=null;if(s||(s=Ly[t]=H.buildParser(t)),e.includes("\u202F")&&(e=e.replace(/\s/g," ")),s.parseTimeZone){const d=e.match(ek);d&&(o=d[0],e=e.slice(0,d.index))}if(s.reduce((d,c)=>{var u;if(c.last)d=o||d,X.assign(n,c.fn(d));else{let h;if(c.splitter==="T"&&d.indexOf("T")===-1)h=d.indexOf(" ");else{let m;!r&&c.canUseUnstrictSplitter?m=b0:m=c.escapedSplitter,h=m!==""?d.search(m):((u=c.pattern)==null?void 0:u.length)||-1}let f,g;if(h===-1||c.pattern==="SSS"&&d.match(/^\d+Z$/)){const m=d.split(/([Z\-+])/);m.length===1?(f=d,g=""):(f=m[0],g=`${m[1]}${m[2]}`)}else f=d.substring(0,h)||d,g=d.substring(h+c.splitter.length);if(c.fn){const m=c.fn(f);m?X.assign(n,m):g=f+g}return g}},e),n.year&&!n.date&&(n.date=1),n.date>31||n.month>12)return null;const l=H.create(n,r,!1);return l?a=l:!r&&e.length>3&&(a=new Date(e),a.getFullYear()<1900&&(a=null)),a}static create(e,t=!1,r=!0){const n=r?{...e}:e;let s=isNaN(n.year)||t&&(isNaN(n.month)||isNaN(n.date)),a=!1;if(!s){let o=!0;for(let l=0;l<x0.length;l++){const d=x0[l];!(d in n)||isNaN(n[d])?n[d]=0:o&&(o=n[d]===null)}s=o}return s||(n.amPm==="am"?n.hours=n.hours%12:n.amPm==="pm"&&(n.hours=n.hours%12+12),"timeZone"in n&&(a=!0,n.minutes-=n.timeZone),t&&(n.year==null||n.month==null||n.date==null))?null:a?new Date(Date.UTC(To(n.year,By),To(n.month,Hy),To(n.date,Vy),n.hours,n.minutes,n.seconds,n.milliseconds)):new Date(To(n.year,By),To(n.month,Hy),To(n.date,Vy),n.hours,n.minutes,n.seconds,n.milliseconds)}static toUTC(e){return new Date(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds()))}static format(e,t=H.defaultFormat){if(!e||isNaN(e))return null;if(typeof t=="function")return t(e);let r=Wg[t],n="";if(!r){r=Wg[t]=[];for(let s=0;s<t.length;s++){const a=t.slice(s).match(ik),o=a==null?void 0:a[0];if(o){const l=this.localize("L{formats}")||{},d=l[o]||bt[o];r.push(d),s+=o.length-1}else if(t[s]==="{"){const l=t.indexOf("}",s+1);l===-1?(r.push(t.substr(s+1)),s=t.length):(r.push(t.substring(s+1,l)),s=l)}else r.push(t[s])}}return r.forEach(s=>{typeof s=="string"?n+=s:n+=s(e)}),n}static formatRange(e,t){return t.replace(KP,(r,n,s)=>Nt.format(e[n==="S"?0:1],s))}static asMilliseconds(e,t=null){return typeof e=="string"&&(t=e,e=1),H.as("millisecond",e,t)}static asMonths(e){const t=H.as("ms",H.daysInMonth(e),"day"),r=(e.valueOf()-H.startOf(e,"month").valueOf())/t;return e.getYear()*12+e.getMonth()+r}static monthsToDate(e){const t=Math.floor(e),r=e-t,n=new Date(0,t),s=H.as("ms",H.daysInMonth(n),"days");return n.setTime(n.getTime()+r*s),n}static formatDelta(e,t){let r,n,s=", ";typeof t=="boolean"?r=t:t&&(r=t.abbrev,s=t.unitSeparator||s);const a=this.getDelta(e,t),o=[],l=(t==null?void 0:t.separator)||(r?"":" ");for(n in a)o.push(`${a[n]}${l}${n}`);return(t==null?void 0:t.asString)===!1?o:o.join(s)}static getDelta(e,t){let r,n,s,a,o,l,d;typeof t=="boolean"?r=t:t&&(r=t.abbrev,a=H.normalizeUnit(t.precision),l=t.maxUnit,d=!r&&t.ignoreLocale);const c={},u=r?H.getShortNameOfUnit:H.getLocalizedNameOfUnit,h=l?Ny.slice(Ny.indexOf(l)):Ny;for(o of h)if(n=H.as(o,e),s=a===o,n=Math[s?"round":"floor"](n),(n||s&&!c.length)&&(c[d?o:u.call(H,o,n!==1)]=n,e-=H.as("ms",n,o)),s||!e)break;return c}static as(e,t,r="ms"){return typeof t=="string"&&(t=H.parseDuration(t)),typeof t=="object"&&(r=t.unit,t=t.magnitude),e===r||!r||!e||(e=H.normalizeUnit(e),r=H.normalizeUnit(r),e===r)?t:ar[r].magnitude>ar[e].magnitude?t*Math.abs(Ot[r][e]):t/Math.abs(Ot[e][r])}static formatContainsHourInfo(e){const t=/(\\.)/g;return/([HhKkmSsAa]|LT|L{3,}|l{3,})/.test(e.replace(t,""))}static is24HourFormat(e){return H.format(H.getTime(13,0,0),e).includes("13")}static add(e,t,r="ms",n=!0){let s;if(typeof e=="string"?s=H.parse(e):n?s=new Date(e.getTime()):s=e,typeof t=="string"){const a=Nt.parseDuration(t);t=a.magnitude,r=a.unit}else t&&typeof t=="object"&&(r=t.unit,t=t.magnitude);if(!r||t===0)return s;switch(r=H.normalizeUnit(r),r){case"millisecond":s.setTime(s.getTime()+t);break;case"second":s.setTime(s.getTime()+t*1e3);break;case"minute":s.setTime(s.getTime()+t*6e4);break;case"hour":s.setTime(s.getTime()+t*36e5);break;case"day":t%1===0?(s.setDate(s.getDate()+t),s.getHours()===23&&e.getHours()===0&&s.setHours(s.getHours()+1)):s.setTime(s.getTime()+t*864e5);break;case"week":s.setDate(s.getDate()+t*7);break;case"month":{let a=s.getDate();a>28&&(a=Math.min(a,H.getLastDateOfMonth(H.add(H.getFirstDateOfMonth(s),t,"month")).getDate())),s.setDate(a),s.setMonth(s.getMonth()+t);break}case"quarter":H.add(s,t*3,"month",!1);break;case"year":H.add(s,t*12,"month",!1);break;case"decade":s.setFullYear(s.getFullYear()+t*10);break}return s}static diff(e,t,r="ms",n=!0){if(r=H.normalizeUnit(r),!e||!t)return 0;let s;switch(r){case"year":s=H.diff(e,t,"month")/12;break;case"quarter":s=H.diff(e,t,"month")/3;break;case"month":s=(t.getFullYear()-e.getFullYear())*12+(t.getMonth()-e.getMonth()),s===0&&n&&(s=H.diff(e,t,"day",n)/H.daysInMonth(e));break;case"week":s=H.diff(e,t,"day")/7;break;case"day":{const a=e.getTimezoneOffset()-t.getTimezoneOffset();s=(t-e+a*60*1e3)/864e5;break}case"hour":s=(t-e)/36e5;break;case"minute":s=(t-e)/6e4;break;case"second":s=(t-e)/1e3;break;case"millisecond":s=t-e;break}return n?s:Math.round(s)}static startOf(e,t="day",r=!0,n=H.weekStartDay){if(!e)return null;switch(t=H.normalizeUnit(t),r&&(e=H.clone(e)),t){case"year":return e.setMonth(0,1),e.setHours(0,0,0,0),e;case"quarter":return e.setMonth((H.get(e,"quarter")-1)*3,1),e.setHours(0,0,0,0),e;case"month":return e.setDate(1),e.setHours(0,0,0,0),e;case"week":{let a=e.getDay()-n;return a<0&&(a+=7),e.setDate(e.getDate()-a),e.setHours(0,0,0,0),e}case"day":return e.setHours(0,0,0,0),e;case"hour":e.getMinutes()>0&&e.setMinutes(0);case"minute":e.getSeconds()>0&&e.setSeconds(0);case"second":e.getMilliseconds()>0&&e.setMilliseconds(0);case"millisecond":return e}}static endOf(e){return new Date(e.getFullYear(),e.getMonth(),e.getDate()+1)}static clone(e){return new Date(e.getTime())}static clearTime(e,t=!0){return e?(t&&(e=new Date(e.getTime())),e.setHours(0,0,0,0),e):null}static midnight(e,t){let r=H.clearTime(e);return t&&r<e&&(r=H.add(r,1,"d")),r}static isMidnight(e){return H.midnight(e).getTime()===e.getTime()}static getTimeOfDay(e,t="ms"){const r=e.getHours()*Ot.hour.millisecond+e.getMinutes()*Ot.minute.millisecond+e.getSeconds()*Ot.second.millisecond+e.getMilliseconds();return t==="ms"?r:H.as(t,r,"ms")}static set(e,t,r){if(!t)return e;if(typeof t=="string")switch(H.normalizeUnit(t)){case"millisecond":(r!==0||e.getMilliseconds()>0)&&e.setMilliseconds(r);break;case"second":(r!==0||e.getSeconds()>0)&&e.setSeconds(r);break;case"minute":(r!==0||e.getMinutes()>0)&&e.setMinutes(r);break;case"hour":e.setHours(r);break;case"day":case"date":e.setDate(r);break;case"week":throw new Error("week not implemented");case"month":e.setMonth(r);break;case"quarter":e.setDate(1),e.setMonth((r-1)*3);break;case"year":e.setFullYear(r);break}else Object.entries(t).sort((n,s)=>{const a=n[0],o=s[0],l=ar[a==="date"?"day":a],d=ar[o==="date"?"day":o];return l.magnitude-d.magnitude}).forEach(([n,s])=>{H.set(e,n,s)});return e}static setDateToMidday(e,t=!0){return H.set(H.clearTime(e,t),"hour",12)}static constrain(e,t,r){return t!=null&&(e=H.max(e,t)),r==null?e:H.min(e,r)}static getTime(e,t=0,r=0,n=0){return e instanceof Date&&(n=e.getMilliseconds(),r=e.getSeconds(),t=e.getMinutes(),e=e.getHours()),new Date(By,Hy,Vy,e,t,r,n)}static copyTimeValues(e,t){return e.setHours(t.getHours()),e.setMinutes(t.getMinutes()),e.setSeconds(t.getSeconds()),e.setMilliseconds(t.getMilliseconds()),e}static combineDateAndTime(e,t){return Nt.copyTimeValues(new Date(e),t)}static get isDSTEnabled(){const e=new Date().getFullYear(),t=new Date(e,0,1),r=new Date(e,6,1);return t.getTimezoneOffset()!==r.getTimezoneOffset()}static isDST(e){const t=e.getFullYear(),r=new Date(t,0,1),n=new Date(t,6,1);return e.getTimezoneOffset()<Math.max(r.getTimezoneOffset(),n.getTimezoneOffset())}static isToday(e,t){return H.isEqual(H.clearTime(e),t?H.clearTime(ye.TimeZone.toTimeZone(H.today,t)):H.today)}static isBefore(e,t){return e<t}static isAfter(e,t){return e>t}static isEqual(e,t,r=null){return r===null?e&&t&&e.getTime()===t.getTime():H.startOf(e,r)-H.startOf(t,r)===0}static compare(e,t,r=null){return r&&(e=H.startOf(e,r),t=H.startOf(t,r)),e<t?-1:e>t?1:0}static clamp(e,t,r){if(!isNaN(e))return t!=null&&(e=Math.max(e,t)),r!=null&&(e=Math.min(e,r)),new Date(e)}static isSameDate(e,t){return H.compare(e,t,"d")===0}static isSameTime(e,t){return e.getHours()===t.getHours()&&e.getMinutes()===t.getMinutes()&&e.getSeconds()===t.getSeconds()&&e.getMilliseconds()===t.getMilliseconds()}static isStartOf(e,t){return H.isEqual(e,H.startOf(e,t))}static betweenLesser(e,t,r){return t.getTime()<=e.getTime()&&e.getTime()<r.getTime()}static betweenLesserEqual(e,t,r){return t.getTime()<=e.getTime()&&e.getTime()<=r.getTime()}static intersectSpans(e,t,r,n){return H.betweenLesser(e,r,n)||H.betweenLesser(r,e,t)}static compareUnits(e,t){const r=ar[H.normalizeUnit(e)],n=ar[H.normalizeUnit(t)];return Math.sign(((r==null?void 0:r.magnitude)||0)-((n==null?void 0:n.magnitude)||0))}static timeSpanContains(e,t,r,n){return r-e>=0&&t-n>=0}static get amIndicator(){return Ug}static get pmIndicator(){return Gg}static get weekStartDay(){return H._weekStartDay==null&&(H._weekStartDay=this.localize("L{weekStartDay}")||0),H._weekStartDay}static get nonWorkingDays(){return{...this.localize("L{nonWorkingDays}")}}static get nonWorkingDaysAsArray(){return Object.keys(this.nonWorkingDays).map(Number)}static get weekends(){return{...this.localize("L{weekends}")}}static get(e,t){switch(H.normalizeUnit(t)){case"millisecond":return e.getMilliseconds();case"second":return e.getSeconds();case"minute":return e.getMinutes();case"hour":return e.getHours();case"date":case"day":return e.getDate();case"week":return bt.W(e);case"month":return e.getMonth();case"quarter":return Math.floor(e.getMonth()/3)+1;case"year":return e.getFullYear()}return null}static daysInYear(e){const t=e.getFullYear(),r=new Date(t+1,0,1)-new Date(t,0,1);return this.as("day",r)}static daysInMonth(e){return 32-new Date(e.getFullYear(),e.getMonth(),32).getDate()}static hoursInDay(e){const t=e.getFullYear(),r=e.getMonth(),n=e.getDate(),s=new Date(t,r,n+1)-new Date(t,r,n);return this.as("hour",s)}static getNormalizedUnitDuration(e,t){let r;switch(t){case"month":r=H.asMilliseconds(H.daysInMonth(e),"day");break;case"year":r=H.asMilliseconds(H.daysInYear(e),"day");break;case"day":r=H.asMilliseconds(H.hoursInDay(e),"hour");break;default:r=H.asMilliseconds(t)}return r}static getFirstDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth(),1)}static getLastDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth()+1,0)}static min(e,t){return e.getTime()<t.getTime()?e:t}static max(e,t){return e.getTime()>t.getTime()?e:t}static getNext(e,t,r=1,n=H.weekStartDay){if(t==="week"){const s=H.clone(e),a=s.getDay();return H.startOf(s,"day",!1),H.add(s,n-a+7*(r-(n<=a?0:1)),"day",!1),s.getDay()!==n&&H.add(s,1,"hour"),s}return H.startOf(H.add(e,r,t),t,!1)}static isValidDate(e){return H.isDate(e)&&!isNaN(e)}static isDate(e){return e&&m0.call(e)===YP}static getStartOfNextDay(e,t=!1,r=!1){let n=H.add(r?e:H.clearTime(e,t),1,"day");if(n.getDate()===e.getDate()){const s=H.add(H.clearTime(e,t),2,"day").getTimezoneOffset(),a=e.getTimezoneOffset();n=H.add(n,a-s,"minute")}return n}static getEndOfPreviousDay(e,t=!1){const r=t?e:H.clearTime(e,!0);return r-e?r:H.add(r,-1,"day")}static getWeekDescription(e,t=e){const r=e.getMonth()===t.getMonth()?Nt.format(e,"MMMM"):`${Nt.format(e,"MMM")} - ${Nt.format(t,"MMM")}`,n=Nt.getWeekNumber(e);return`${n[1]}, ${r} ${n[0]}`}static getWeekNumber(e,t=Nt.weekStartDay){const r=new Date(e.getFullYear(),0,1),n=new Date(e.getFullYear(),11,31),s=y0(r.getDay()-t),a=y0(n.getDay()-t),o=XP(e,r);let l;if(s<4?l=Math.floor((o+s-1)/7)+1:l=Math.floor((o+s-1)/7),l){let c=e.getFullYear();return l===53&&a<3&&(c++,l=1),[c,l]}const d=Nt.getWeekNumber(new Date(e.getFullYear()-1,11,31))[1];return[e.getFullYear()-1,d]}static getDateFromISOWeek(e,t,r=1){const n=new Date(e,0,1+(t-1)*7),s=n.getDay(),a=s===0?7:s,o=r-a;return n.setDate(n.getDate()+o),n}static formatCount(e,t){return t=H.normalizeUnit(t),e!==1&&(t+="s"),e+" "+t}static getUnitToBaseUnitRatio(e,t,r=!1){return e=H.normalizeUnit(e),t=H.normalizeUnit(t),e===t?1:Ot[e]&&Ot[e][t]&&(r||Ot[e][t]>0)?1/H.as(t,1,e):Ot[t]&&Ot[t][e]&&(r||Ot[t][e]>0)?H.as(e,1,t):-1}static getShortNameOfUnit(e){return e=H.parseTimeUnit(e),H.unitLookup[e].abbrev}static getLocalizedNameOfUnit(e,t=!1){const r=e.charAt(0)===e.charAt(0).toUpperCase();return e=H.normalizeUnit(e),e=H.parseTimeUnit(e),e=H.unitLookup[e][t?"plural":"single"],r&&(e=k.capitalize(e)),e}static normalizeUnit(e){if(!e)return null;const t=e.toLowerCase();return t==="date"||_o.includes(t)?t:E0[e]||E0[t]}static getUnitByName(e){return H.normalizeUnit(e)||H.normalizeUnit(H.parseTimeUnit(e))}static getDurationInUnit(e,t,r,n){return H.diff(e,t,r,n)}static doesUnitsAlign(e,t){return!(e!==t&&t==="week")}static getSmallerUnit(e){var t,r;e=H.normalizeUnit(e);const n=(t=ar[e])==null?void 0:t.smaller;return _o[(r=ar[n])==null?void 0:r.magnitude]||null}static getLargerUnit(e){var t,r;e=H.normalizeUnit(e);const n=(t=ar[e])==null?void 0:t.greater;return _o[(r=ar[n])==null?void 0:r.magnitude]||null}static round(e,t,r,n){return H.snap("round",e,t,r,n)}static floor(e,t,r,n){return H.snap("floor",e,t,r,n)}static ceil(e,t,r,n){return H.snap("ceil",e,t,r,n)}static snap(e,t,r,n,s=H.weekStartDay){const a=uk[e];if(typeof r=="string"&&(r=H.parseDuration(r)),X.isObject(r)){const l=r.magnitude||r.increment;switch(r.unit){case"week":{if(!n){const d=t.getDay();n=H.add(H.clearTime(t),d>=s?s-d:-(d-s+7),"day")}return H[e](t,`${l*7} days`,n)}case"month":{t=H.asMonths(t);let d;return n?(n=H.asMonths(n),d=n+a(t-n,l)):d=a(t,l),H.monthsToDate(d)}case"quarter":return H[e](t,`${l*3} months`,n);case"year":return H[e](t,`${l*12} months`,n);case"decade":return H[e](t,`${l*10} years`,n)}r=H.as("ms",l,r.unit)}const o=t.getTimezoneOffset()*1e3*60;if(n){const l=n.getTimezoneOffset()*1e3*60,d=t-n+l-o,c=new Date(n.getTime()+a(d,r)),u=l-c.getTimezoneOffset()*1e3*60;return u&&H.add(c,-u,"ms",!1),new Date(c)}else return new Date(a(t.valueOf()-o,r)+o)}static parseDuration(e,t=!0,r){var n;const s=t?ak:ok,a=s.exec(e);if(e==null||!a)return null;const o=dk((n=a[1])==null?void 0:n.replace(",",".")),l=H.parseTimeUnit(a[2])||r;return l?{magnitude:o,unit:l}:null}static parseTimeUnit(e){const t=e==null?null:H.durationRegEx.exec(e)||H.durationRegEx.exec(e.toLowerCase());if(!t)return null;for(let r=0;r<_o.length;r++)if(t[r+1])return _o[r]}static getGMTOffset(e=new Date){if(!e)return;const t=e.getTimezoneOffset();return t?(t>0?"-":"+")+Math.abs(Math.trunc(t/60)).toString().padStart(2,"0")+":"+Math.abs(t%60).toString().padStart(2,"0"):"Z"}static fillDayNames(){const e=new Date("2000-01-01T12:00:00"),t=H._dayNames||[],r=H._dayShortNames||[];t.length=0,r.length=0;for(let n=2;n<9;n++)e.setDate(n),t.push(H.format(e,"dddd")),r.push(H.format(e,"ddd"));H._dayNames=t,H._dayShortNames=r}static getDayNames(){return H._dayNames}static getDayName(e){return H._dayNames[e]}static getDayShortNames(){return H._dayShortNames}static getDayShortName(e){return H._dayShortNames[e]}static fillMonthNames(){const e=new Date("2000-01-15T12:00:00"),t=H._monthNames||[],r=H._monthShortNames||[],n={},s={};t.length=0,r.length=0;for(let a=0;a<12;a++){e.setMonth(a);const o=H.format(e,"MMMM");t.push(o);const l=H.format(e,"MMM");r.push(l),n[o.toLowerCase()]={name:o,value:a},s[l.toLowerCase()]={name:l,value:a}}H._monthNames=t,H._monthShortNames=r,H._monthNamesIndex=n,H._monthShortNamesIndex=s}static getMonthShortNames(){return H._monthShortNames}static getMonthShortName(e){return H._monthShortNames[e]}static getMonthNames(){return H._monthNames}static getMonthName(e){return H._monthNames[e]}static set locale(e){$r=e,sr={},Wg={},mu={}}static get locale(){return $r}static setupDurationRegEx(e=[],t=[]){const r=this,n={};let s="";for(let a=0;a<t.length;a++){const o=t[a],l=e[a];l.canonicalUnitName=_o[a],n[l.single]=n[l.single.toUpperCase()]=n[l.canonicalUnitName]=n[l.canonicalUnitName.toUpperCase()]=l,s+=`${a?"|":""}(`;for(let d=0;d<o.length;d++)s+=`${o[d]}|`;if($r=r.localize("L{locale}")||"en-US",$r!=="en-US"){const d=lk[a];for(let c=0;c<d.length;c++)s+=`${d[c]}|`}s+=`${l.single}|${l.plural}|${l.canonicalUnitName}|${l.canonicalUnitName}s)`}r.unitLookup=n,r.durationRegEx=new RegExp(`^(?:${s})$`)}static applyLocale(){const e=this,t=e.localize("L{unitAbbreviations}")||[],r=e.unitNames=e.localize("L{unitNames}"),n=new Date(2020,6,15,6),s=Math.abs(n.getTimezoneOffset()%60);if(r==="unitNames")return;$r=e.localize("L{locale}")||"en-US";const a=sr.a||(sr.a=new Intl.DateTimeFormat($r,{hour:"numeric",hourCycle:"h12"}));Ug=a.formatToParts(n)[2].value,Gg=a.formatToParts(new Date(2020,6,15,18))[2].value,$r==="en-US"?Br=v0:Br=e.localize("L{ordinalSuffix}")||Br,Wg={},mu={},Ly={},sr={},Oy={},$y=(!s||s>30?60-s:s)*6e4,H._weekStartDay=null,H.setupDurationRegEx(r,t),H.fillDayNames(),H.fillMonthNames()}};p(Wy,"MS_PER_DAY",p0*24),p(Wy,"$name","DateHelper");var S=Wy;ye.register(S);var H=S;H.useIntlFormat=Et,ke.ion({locale:"applyLocale",prio:1e3,thisObj:H}),ke.locale&&H.applyLocale();var hk=class _F extends Set{get isDateSet(){return!0}add(e){return e=S.makeKey(e),this.has(e)||(this.generation=(this.generation||0)+1),super.add(e)}delete(e){return e=S.makeKey(e),this.has(e)&&this.generation++,super.delete(e)}has(e){return super.has(S.makeKey(e))}clear(){return this.size&&this.generation++,super.clear()}equals(e){return Array.isArray(e)&&(e=new _F(e)),e.size===this.size&&[...this].every(t=>e.has(t))}get dates(){return[...this].sort().map(e=>S.parseKey(e))}};S.DateSet=hk,S._$name="DateHelper";var Fo=class{get data(){return Object.create(null)}get keys(){return[]}clear(){}getItem(i){return null}removeItem(i){}setItem(i,e){}};Fo._$name="StateStorage";var fk=class extends Fo{constructor(i){super(),this.prefix=i.prefix||""}get isLocal(){return!0}get data(){const i=T0(),e=this.keys;for(const t of e)i[t]=this.getItem(t);return i}get keys(){return M0(this.prefix,this.prefix.length)}clear(){const i=M0(this.prefix);for(const e of i)localStorage.removeItem(e)}getItem(i){const e=localStorage.getItem(this.prefix+i);return e===null?e:JSON.parse(e)}removeItem(i){return localStorage.removeItem(this.prefix+i)}setItem(i,e){return localStorage.setItem(this.prefix+i,JSON.stringify(e))}},gk=class extends Fo{constructor(){super(),this.clear()}get isMemory(){return!0}get data(){return T.clone(this._data)}get keys(){return Object.keys(this._data)}clear(){this._data=T0()}getItem(i){return i in this._data?this._data[i]:null}removeItem(i){delete this._data[i]}setItem(i,e){this._data[i]=e}},T0=()=>Object.create(null),M0=(i,e=0)=>{const t=[],r=localStorage.length;for(let n,s=0;s<r;++s)n=localStorage.key(s),n.startsWith(i)&&t.push(n.slice(e));return t},I0=new Fo,Uy={local:fk,memory:gk},_0=class FF extends O.mixin(be,Ie){static get configurable(){return{prefix:"bryntum-state:",storage:"local"}}static get delayable(){return{writeStatefuls:50}}static get instance(){return this._instance}static set instance(e){e==null?e=F0:((typeof e=="string"||T.isClass(e)||e instanceof Fo)&&(e={storage:e}),T.isObject(e)&&(e=new FF(e))),this._instance=e}static setup(e){return this.instance=e,this.instance}doDestroy(){self.writeStatefuls.flush(),super.doDestroy()}get data(){return this.storage.data}set data(e){if(!e)this.clear();else for(const t in e)this.setValue(t,e[t])}clear(){return this.storage.clear(),this}changeStorage(e){if(e==null)e=I0;else{if(typeof e=="string"){if(!Uy[e])throw new Error(`Invalid storage type "${e}" (expected one of: "${Object.keys(Uy).join('", "')}")`);e=Uy[e]}T.isClass(e)&&(e=new e(this))}return e}saveStateful(e,t){(this.pendingSaves||(this.pendingSaves=[])).push([e,t]),this.writeStatefuls()}writeStatefuls(){const e=this,{pendingSaves:t}=e,r=t==null?void 0:t.length,n=[],s=[];if(e.pendingSaves=null,r){for(let a,o,l,d=0;d<r;++d)[o,a]=t[d],!o.isDestroying&&o.isSaveStatePending&&(l=o.saveState({...a,immediate:!0}),l&&(n.push(l),s.push(o)));n.length&&e.trigger("save",{stateIds:n,saved:s})}}getValue(e){return this.writeStatefuls.flush(),this.storage.getItem(e)}setValue(e,t){const r=this,{storage:n}=r,s=r.getValue(e);return t!=null?(n.setItem(e,t),r.trigger("set",{key:e,value:t,was:s})):s!==null&&(n.removeItem(e),r.trigger("remove",{key:e,was:s})),r}};p(_0,"$name","StateProvider");var pu=_0,F0=new pu({storage:I0});pu._instance=F0,pu._$name="StateProvider";var mk=/boolean|number|string/,qg=i=>{var e;return e=class extends(i||O).mixin(Ie){afterConstruct(){super.afterConstruct(),this.stateProvider&&this.loadState()}finalizeInit(){this.stateProvider&&this.loadState(),super.finalizeInit()}get isStateful(){return!0}get isStatefulActive(){return!this.statefulSuspended&&!this.isResponsivePending&&!this.isResponsiveUpdating}get state(){return this._state=this.getState()}set state(t){this._state=t,t&&this.trigger("beforeStateApply",{state:t})!==!1&&this.applyState(t)}updateStatefulEvents(t){var r;const n=this,s={name:"statefulEvents",thisObj:n};if(n.detachListeners(s.name),t&&(typeof t=="string"?t=k.split(t):Array.isArray(t)||(t=T.getTruthyKeys(t)),t.length)){for(const a of t)s[a]="onStatefulEvent";(r=n.ion)==null||r.call(n,s)}}get statefulId(){const t=this,{responsiveState:r}=t;let n=t.stateId;return n==null&&t.hasGeneratedId===!1&&t.stateful!==!1&&(n=t.id),n&&r&&(n=`${n}[${r}]`),n}get statefulness(){const{stateful:t}=this;return Array.isArray(t)?T.createTruthyKeys(t):t}get stateProvider(){var t;return(t=this._stateProvider)!=null?t:this._stateId&&pu.instance}applyState(t){t=this.pruneState(t),t&&this.setConfig(t)}getState(){const t=this,{initialConfig:r,statefulness:n,isConstructing:s}=t,{configs:a}=t.$meta,o=s?Object.assign(Object.create(t.$meta.config),r):t;let l=null,d,c;if(n){l={};for(d in n)if(n[d]){if(c=o[d],c!=null&&c.isStateful)c=c.state;else if(!s&&(T.isDate(c)&&(c=S.format(c,"YYYY-MM-DDTHH:mm:ssZ")),a[d].equal(c,r==null?void 0:r[d])||!mk.test(typeof c)))continue;l[d]=c}}return l}loadState(t,r){typeof t=="boolean"&&(r=t,t=null);const n=this,{statefulLoaded:s}=n;if(n.isStatefulActive&&(r||!s)){const a=n.loadStatefulData(t||(t=n.statefulId));!s&&t&&(n.defaultState=n.state,n.statefulLoaded=!0),a&&(n.state=a)}}loadStatefulData(t){var r;return t=this.isStatefulActive?t||this.statefulId:null,t&&((r=this.stateProvider)==null?void 0:r.getValue(t))}resetDefaultState(){this.defaultState&&(this.state=this.defaultState)}resumeStateful(t=!1){this.statefulSuspended=t?0:Math.max(this.statefulSuspended-1,0)}saveState(t){typeof t=="string"?t={id:t}:t=t||{};const r=this,{stateProvider:n}=r,s=t.id||r.isStatefulActive&&r.statefulId;if(s&&n){if(t.immediate){r.isSaveStatePending=!1;const{state:a}=r;r.trigger("beforeStateSave",{state:a})!==!1&&n.setValue(s,a)}else r.isSaveStatePending||(r.isSaveStatePending=!0,n.saveStateful(r,t));return s}}suspendStateful(){++this.statefulSuspended}onConfigChange({name:t,value:r,was:n,config:s}){if(super.onConfigChange({name:t,value:r,was:n,config:s}),!this.isConstructing&&this.isStatefulActive&&this.statefulId){const{stateful:a}=this;(Array.isArray(a)?a.includes(t):a!=null&&a[t])&&this.saveState()}}onStatefulEvent(){this.isConstructing||this.saveState()}pruneState(t){const{statefulness:r}=this;if(r){const n={};for(const s in t)r[s]&&(n[s]=t[s]);t=n}return t}get widgetClass(){}},p(e,"$name","State"),p(e,"configurable",{stateful:{value:null,$config:{merge:"classList"}},statefulEvents:{$config:{merge:"classList"},value:["stateChange"]},stateId:null,stateProvider:null}),p(e,"prototypeProperties",{statefulLoaded:!1,statefulSuspended:0}),e},A0={parentIndex:1,orderedParentIndex:1},P0=i=>{var e;return e=class extends(i||O){joinStore(t){this.stm||(this.stm=t.stm)}unjoinStore(t,r=!1){var n;this.stm===t.stm&&(this.stm=null),(n=super.unjoinStore)==null||n.call(this,t,r)}beforeChronoFieldSet(t,r){var n;const s=this;return!s.inSetting&&((n=s.stm)!=null&&n.enabled)&&!A0[t]&&!s.constructor.nonPersistableFields[t]&&s.getFieldDefinition(t)?{[t]:{value:r,oldValue:s.graph.activeTransaction.readCurrentOrProposedOrPrevious(s.$[t])}}:null}afterChronoFieldSet(t,r,n){n&&this.afterSet(t,r,!1,!1,n,!0)}shouldRecordFieldChange(t,r,n){const s=this.firstStore;return!(this.constructor.nonPersistableFields[t]||r==null&&n==null||r===n||r instanceof Date&&n instanceof Date&&r.getTime()===n.getTime()||t==="id"||t==="$PhantomId"||t==="parentId"&&s&&s.oldIdMap[r]===s.getById(n))}afterSet(t,r,n,s,a,o){const{stm:l}=this,d=this.constructor.nonPersistableFields;if(l!=null&&l.isBase&&l.shouldRecordAction&&!A0[t]&&!d[t]&&a){let c;const[u,h]=Object.keys(a).reduce((f,g)=>{const{value:m,oldValue:v}=a[g];return this.shouldRecordFieldChange(g,v,m)&&(c=!0,f[0][g]=m,f[1][g]=v),f},[{},{}]);c&&l.onModelUpdate(this,u,h,o)}}beforeInsertChild(t){var r;const n=((r=super.beforeInsertChild)==null?void 0:r.call(this,t))||[],{stm:s}=this;return s!=null&&s.enabled&&n.push(t.reduce((a,o)=>(o.root===this.root&&a.set(o,{parent:o.parent,index:o.parent?o.parentIndex:void 0}),a),new Map)),n}afterInsertChild(t,r,n,s,a){var o;const{stm:l}=this;if(l!=null&&l.shouldRecordAction){const d=n.pop();s&&l.onModelInsertChild(this,t,s,d,a)}(o=super.afterInsertChild)==null||o.call(this,t,r,n,s)}beforeRemoveChild(t,r){const n=super.beforeRemoveChild?super.beforeRemoveChild(t,r):[],{stm:s}=this;return s!=null&&s.shouldRecordAction&&!r&&n.push(t.reduce((a,o)=>(a.set(o,{parentIndex:o.parentIndex,orderedParentIndex:o.orderedParentIndex}),a),new Map)),n}afterRemoveChild(t,r,n){var s;const{stm:a}=this;if(a!=null&&a.shouldRecordAction&&!n){const o=r.pop();t&&t.length&&a.onModelRemoveChild(this,t,o)}(s=super.afterRemoveChild)==null||s.call(this,t,r,n)}},p(e,"$name","ModelStm"),p(e,"configurable",{stm:null}),e},pk={includeFilteredOutRecords:!1},Gy=i=>(i=i||!1,typeof i=="boolean"&&(i={includeFilteredOutRecords:i}),i||pk),k0=i=>{var e;return e=class extends(i||O){static set convertEmptyParentToLeaf(t){t===!0?t={onLoad:!0,onRemove:!0}:t===!1&&(t={onLoad:!1,onRemove:!1}),this._convertEmptyParentToLeaf=t}constructor(...t){super(...t),this.children&&(this.orderedChildren=this.orderedChildren||[])}static get convertEmptyParentToLeaf(){return this._convertEmptyParentToLeaf||{onLoad:!1,onRemove:!1}}ingestChildren(t,r=this.stores){var n,s,a;const{inProcessChildren:o,constructor:l}=this,d=r==null?void 0:r[0];if(t===!0)return o?!0:[];if(t){let c=L.asArray(t);if(!c.length)return[];const u=c.length,h=[];c=(n=d==null?void 0:d.cloneImmutable(c))!=null?n:c;for(let f=0,g;f<u;f++)g=c[f],g=g.isModel?g:(s=d==null?void 0:d.createRecord(g,!1,!0))!=null?s:new l(g,null,null,!0),g=(a=d==null?void 0:d.processRecord(g))!=null?a:g,h.push(g);if(this.children===!0&&d){const f=d.createSorterFn(d.sorters);h.sort(f)}return h}}processChildren(t=this.stores){const r=this,{meta:n}=r;r.inProcessChildren=!0;const s=r.ingestChildren(r.data[r.constructor.childrenField],t);if(s){const{convertEmptyParentToLeaf:a}=r.constructor;if(a===!0||a.onLoad?s.length:Array.isArray(s)){if(n.isLeaf=!1,r.children===!0)r.children=[];else if(s.length===0){r.children=s;return}r.insertChild(s)}else s===!0?(n.isLeaf=!1,r.children=!0):r.isRoot||(n.isLeaf=r.constructor.convertEmptyParentToLeaf.onLoad)}r.inProcessChildren=!1}ancestorsExpanded(t=this.firstStore){const{parent:r}=this;return t!=null&&t.isTree?!r||r.isExpanded(t)&&r.ancestorsExpanded(t):!0}isExpanded(t=this.firstStore){const r=this.instanceMeta(t.id);return Object.prototype.hasOwnProperty.call(r,"collapsed")||(r.collapsed=!this.expanded),!r.collapsed}get expanded(){return this.data.expanded}get childLevel(){let t=this,r=-1;for(;t&&!t.isRoot;)++r,t=t.parent;return r}get isLeaf(){return this.meta.isLeaf!==!1&&!this.isRoot}get isParent(){return!this.isLeaf}get isLoaded(){return this.isParent&&Array.isArray(this.children)}get hierarchyModificationDataToWrite(){const{parentIdField:t}=this.constructor,r=[t,"parentIndex","orderedParentIndex"].reduce((n,s)=>{var a;if(s in this.meta.modified){const o=this.constructor.getFieldDefinition(s);s===t?n[(a=o==null?void 0:o.dataSource)!=null?a:t]=this.getFieldPersistentValue(s):o.persist&&(n[o.dataSource]=this.getFieldPersistentValue(s))}return n},{});return Object.keys(r).length>0?r:null}get descendantCount(){return this.getDescendantCount()}get visibleDescendantCount(){return this.getDescendantCount(!0)}getDescendantCount(t=!1,r=this.firstStore,n=!1){let{children:s}=this;return n&&this.unfilteredChildren&&(s=this.unfilteredChildren),!s||!Array.isArray(s)||t&&!this.isExpanded(r)?0:s.reduce((a,o)=>a+o.getDescendantCount(t,r,n),s.length)}get allChildren(){return this.getAllChildren(!1)}get allUnfilteredChildren(){return this.getAllChildren(!0)}getAllChildren(t=!1){const r=t?this.unfilteredChildren||this.children:this.children;return!r||r===!0?[]:r.reduce((n,s)=>(n.push(s),n.push.apply(n,t?s.allUnfilteredChildren:s.allChildren),n),[])}get firstChild(){const{children:t}=this;return(t==null?void 0:t.length)&&t[0]||null}get lastChild(){const{children:t}=this;return(t==null?void 0:t.length)&&t[t.length-1]||null}get previousSiblingsTotalCount(){let t=this.previousSibling,r=this.parentIndex;for(;t;)r+=t.descendantCount,t=t.previousSibling;return r}get previousOrderedSibling(){var t,r;return(r=(t=this.parent)==null?void 0:t.orderedChildren[this.orderedParentIndex-1])!=null?r:null}get nextOrderedSibling(){var t,r;return(r=(t=this.parent)==null?void 0:t.orderedChildren[this.orderedParentIndex+1])!=null?r:null}get root(){var t;return((t=this.parent)==null?void 0:t.root)||this}get parentId(){return this.parent&&!this.parent.isAutoRoot?this.parent.id:null}set parentId(t){this.setParentId(t)}setParentId(t){const r=this,{firstStore:n}=r;if(n){const{parent:s}=r,a=t===null?n.rootNode:n.getById(t);a===s||!s&&!a||(r.isBatchUpdating?r.meta.batchChanges.parentId=t:a?a.appendChild(r):s.removeChild(r))}else r.setData(r.constructor.parentIdField,t)}static set parentIdField(t){this._parentIdField=t,Object.defineProperty(this.prototype,t,{set:function(r){this.parentId=r},get:function(){return this.parentId}})}static get parentIdField(){return this._parentIdField||"parentId"}getChildren(t){let r;return t.includeFilteredOutRecords?r=this.unfilteredChildren||this.children:t.useOrderedTree?r=this.orderedChildren:r=this.children,r}traverse(t,r,n){n=Gy(n);const s=this,a=s.getChildren(n);r||t.call(s,s);for(let o=0,l=a==null?void 0:a.length;o<l;o++)a[o].traverse(t,!1,n)}traverseBefore(t,r,n){n=Gy(n);const s=this,a=s.getChildren(n);for(let o=0,l=a==null?void 0:a.length;o<l;o++)a[o].traverse(t,!1,n);r||t.call(s,s)}traverseWhile(t,r,n){n=Gy(n);const s=this;let a=r||t.call(s,s)!==!1;if(a){const o=s.getChildren(n);o!=null&&o.length&&(a=o.every(l=>l.traverseWhile(t,!1,n)))}return a}bubble(t,r=!1){let n=this;for(r||t.call(n,n);n.parent;)n=n.parent,t.call(n,n)}bubbleWhile(t,r=!1){let n=this,s=!0;for(r||(s=t.call(n,n));s&&n.parent;)n=n.parent,s=t.call(n,n);return s}contains(t,r=!1,n=void 0){return t&&typeof t=="object"&&(t=t.id),!this.traverseWhile(s=>s.id!=t,r,n)}getTopParent(t){let r;return t?(r=[],this.bubbleWhile(n=>(r.push(n),n.parent&&!n.parent.isRoot))):(r=null,this.bubbleWhile(n=>(r=n,n.parent&&!n.parent.isRoot))),r}appendChild(t,r=!1,n={}){return this.insertChild(t,null,r,n)}insertChild(t,r=null,n=!1,s={}){var a,o,l,d,c,u,h,f,g;const m=this,v=Array.isArray(t);if(typeof r=="number"&&(r=(o=(a=m.children)==null?void 0:a[r])!=null?o:null),m.isLinked&&!m.meta.isFillingFromMaster){let D=t;return m.firstStore.isChainedTree&&(Array.isArray(t)?D=t.map(w=>{var x;return(x=w.$original)!=null?x:w}):D=(l=t.$original)!=null?l:t),m.$original.insertChild(D,r==null?void 0:r.$original,n,s)}if(t=L.asArray(t),!n&&!m.isLoading&&((d=m.stores)==null?void 0:d.every(D=>D.trigger("beforeAdd",{records:t,parent:m})!==!1))===!1)return null;t=m.ingestChildren(t);const y=(h=(u=r==null?void 0:r.parentIndex)!=null?u:(c=m.children)==null?void 0:c.length)!=null?h:0,b=(f=m.beforeInsertChild)==null?void 0:f.call(m,t),C=m.internalAppendInsert(t,r,n,s);return C.length&&m.convertToParent(n),(g=m.afterInsertChild)==null||g.call(m,y,t,b,C,s.orderedBeforeNode),v||!C?C:C[0]}convertToParent(t=!1){const r=this,n=r.isLeaf;r.meta.isLeaf=!1,r.children||(r.children=[]),n&&!r.root.isLoading&&!t&&r.signalNodeChanged({isLeaf:{value:!1,oldValue:!0}})}signalNodeChanged(t,r=this.stores){r==null||r.forEach(n=>{n.trigger("update",{record:this,records:[this],changes:t}),n.trigger("change",{action:"update",record:this,records:[this],changes:t})})}tryInsertChild(...t){return this.insertChild(...t)}internalAppendInsert(t,r,n,s){const a=this,{stores:o,root:l,children:d}=a,{firstStore:c}=l,{parentIdField:u}=a.constructor,h=a.id;let f,g,m,v,y,b={};if(!l.isLoading&&c)for(y=[],m=0;m<t.length;m++){const C=t[m];b[C.id]=C.root===l,y[m]=C.parentIndex}if(r&&r.parent!==a&&(r=null),d){const C=r?r.parentIndex:d.length;if(d[g=C]===t[0]||d[g=C-1]===t[0])for(f=!0,m=0;f&&m<t.length;m++)t[m]!==d[g+m]&&(f=!1)}if(f)return t;for(m=0;m<t.length;m++){const C=t[m],D=C.parent;c&&!l.isLoading&&C.traverse(R=>{R.root===l&&(b[R.id]=!0)});const w=!!b[C.id],x=D===a&&w;if((D==null?void 0:D.removeChild(C,w,n,{isInserting:!0,skipIndexUpdate:x,...s}))===!1)v||(t=t.slice(),v=!0),t.splice(m--,1);else{C.parent=a,C.setData("parentId",h);const{meta:R}=C;R.modified[u]===h&&!D&&(R.oldParentId=h),D&&(R.oldParentId=D.id)}}if(t.length){Array.isArray(d)||(a.children=[]),Array.isArray(a.orderedChildren)||(a.orderedChildren=[]);const C=a.addToChildren(r,t,s);o==null||o.forEach(D=>{(!D.isChained||D.isChainedTree)&&(t.forEach(w=>w.joinStore(D)),D.onNodeAddChild(a,t,C,b,n),t.forEach((w,x)=>{if(w.meta.oldParentId!=null&&(!(a.inProcessChildren||a.isLoading)||b[w.id])){const R={[u]:h,[a.getDataSource("parentIndex")]:w.parentIndex},M={},{modified:I,oldParentId:_}=w.meta,F=y[x];if(delete w.meta.oldParentId,a.id!==_&&(M[u]={value:h,oldValue:_}),w.parentIndex!==F&&(M.parentIndex={value:w.parentIndex,oldValue:F}),I[u]===a.id?Reflect.deleteProperty(I,u):u in I||(I[u]=_),b[w.id]){const A=D.getById(_);A.isLeaf&&!n&&A.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}},[D])}w.afterChange(R,M)}w.traverse(R=>{!R.ignoreBag&&!R.isLinked&&D.updateModifiedBagForRecord(R)})}))})}return t}removeChild(t,r=!1,n=!1,s={}){var a,o,l;const d=this,c=[],u=d.isLeaf,{children:h,stores:f}=d;if(t=L.asArray(t),t=t.filter(m=>m.parent===d),(a=d.firstStore)!=null&&a.isChainedTree)return d.$original.removeChild(t.map(m=>m.$original),r,n,s);if(!n&&f){for(const m of f)if(!m.isChained&&m.trigger("beforeRemove",{parent:d,records:t,isMove:r})===!1)return!1}const g=(o=d.beforeRemoveChild)==null?void 0:o.call(d,t,r);for(const m of t){const{parentIdField:v}=m.constructor,{modified:y}=m.meta,b=m.parent?m.parent.id:null;!(v in y)&&!m.isLinked&&(y[v]=b);const C=d.removeFromChildren(m,s);f==null||f.forEach(D=>{if(!D.isChained){const{isRemoving:w}=D;D.isRemoving=!0;const x=D.onNodeRemoveChild(d,[m],C,{isMove:r,silent:n,...s});L.chunkedPush(c,x),D.isRemoving=w}}),r||(m.parent=m.parentIndex=m.unfilteredIndex=m.nextSibling=m.previousSibling=null,m.data[v]=null)}return(d.unfilteredChildren||h).length===0&&d.constructor.convertEmptyParentToLeaf.onRemove&&!d.isRoot&&(d.meta.isLeaf=!0),d.isLeaf!==u&&!n&&!r&&d.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}}),(l=d.afterRemoveChild)==null||l.call(d,t,g,r),c}clearParentId(){const t=this,{parentIdField:r}=t.constructor;Reflect.deleteProperty(t.data,r),Reflect.deleteProperty(t.originalData,r),t.meta.modified&&Reflect.deleteProperty(t.meta.modified,r)}replaceChildren(t){return this.clearChildren(),this.data[this.constructor.childrenField]=t,this.processChildren(),this.children}clearChildren(t=!1){const r=this,{stores:n}=r,s=r.unfilteredChildren||r.children;r.children=[],r.orderedChildren=[],s&&s!==!0&&n&&n.forEach(o=>{o.isChained||o.onNodeRemoveChild(r,s,0,{unfiltered:!0,silent:t})}),r.unfilteredChildren&&(r.unfilteredChildren=[]);const{convertEmptyParentToLeaf:a}=r.constructor;(a===!0||a.onRemove)&&(r.meta.isLeaf=!0)}clear(){var t;const r=this,{stores:n}=r,s=(t=r.unfilteredChildren||r.children)==null?void 0:t.slice();if(!(!r.isRoot||!s)){for(const a of n)if(!a.isChained&&a.trigger("beforeRemove",{parent:r,records:s,isMove:!1,removingAll:!0})===!1)return!1;r.children.length=r.orderedChildren.length=0,r.unfilteredChildren&&(r.unfilteredChildren.length=0),n.forEach(a=>{s.forEach(o=>{o.stores.includes(a)&&o.unjoinStore(a),o.parent=o.parentIndex=o.nextSibling=o.previousSibling=null}),a.storage.suspendEvents(),a.storage.clear(),a.storage.resumeEvents(),a.added.clear(),a.modified.clear(),a.trigger("removeAll"),a.trigger("change",{action:"removeall"})})}}updateChildrenIndices(t,r,n=!1){var s,a;let o=null;for(let l=0;l<t.length;l++){const d=t[l],c=d[r];r==="parentIndex"||r==="orderedParentIndex"?c===void 0||n?d.setData(r,l):c!==l&&((s=d.stores)==null||s.forEach(u=>{u.suspendSortOnUpdate(),u.suspendFilterOnUpdate()}),d.set(r,l,!0),(a=d.stores)==null||a.forEach(u=>{u.resumeSortOnUpdate(!1),u.resumeFilterOnUpdate(!1)})):d[r]=l,r==="parentIndex"&&(d.previousSibling=o,o&&(o.nextSibling=d),l===t.length-1&&(d.nextSibling=null),o=d)}}addToChildren(t,r,n={}){var s,a;const o=this,l=[[o.children,"parentIndex",t],[o.unfilteredChildren,"unfilteredIndex",t],[o.orderedChildren,"orderedParentIndex",(n==null?void 0:n.orderedBeforeNode)===void 0?(n==null?void 0:n.orderedParentIndex)!==void 0?o.orderedChildren[(s=n.orderedParentIndex.index)!=null?s:n.orderedParentIndex]:t:n==null?void 0:n.orderedBeforeNode]];for(const d of l){const[c,u,h]=d;if(c){let f;h?(f=c.indexOf(h),f===-1&&(f=c.length)):f=c.length,d.push(f),L.chunkedInsert(c,f,r),n!=null&&n.skipIndexUpdate||(a=n==null?void 0:n[u])!=null&&a.skip||o.updateChildrenIndices(c,u)}}return l[0][3]}removeFromChildren(t,r){var n;const s=[[this.children,"parentIndex"],[this.unfilteredChildren,"unfilteredIndex"],[this.orderedChildren,"orderedParentIndex"]];for(const a of s){const[o,l]=a;if(o){const d=o.indexOf(t);a.push(d),d>-1&&(o.splice(d,1),r!=null&&r.skipIndexUpdate||(n=r==null?void 0:r[l])!=null&&n.skip||this.updateChildrenIndices(o,l))}}return s[0][2]}sortOrderedChildren(t=!0,r=!1){const n=this,s=[];return n.isLeaf||(n.orderedChildren.sort((a,o)=>{var l,d;if(r){const c=(l=a.meta.modified.orderedParentIndex)!=null?l:a.orderedParentIndex,u=(d=o.meta.modified.orderedParentIndex)!=null?d:o.orderedParentIndex,h=c-u;return h!==0&&(s.push(a),s.push(o)),h}else return a.orderedParentIndex-o.orderedParentIndex}),t&&n.orderedChildren.forEach(a=>{const o=a.sortOrderedChildren(t,r);L.chunkedPush(s,o)}),n.updateChildrenIndices(n.orderedChildren,"orderedParentIndex",!0)),new Set(s)}sortVisibleChildren(t=!0,r){const n=this;n.isLeaf||(n.children.sort(r),t&&n.orderedChildren.forEach(s=>s.sortVisibleChildren(t,r)),n.updateChildrenIndices(n.children,"parentIndex",!0))}sortUnfilteredChildren(t=!0,r){const n=this;!n.isLeaf&&n.unfilteredChildren&&(n.unfilteredChildren.sort(r),t&&n.orderedChildren.forEach(s=>s.sortUnfilteredChildren(t,r)),n.updateChildrenIndices(n.unfilteredChildren,"unfilteredIndex",!0))}unjoinStore(t,r=!1){var n;const s=this;s.unfilteredChildren&&(s.children=s.unfilteredChildren.slice(),s.unfilteredChildren=null),(n=super.unjoinStore)==null||n.call(this,t,r)}},p(e,"$name","TreeNode"),e},L0={id:1,internalId:1,stores:1,unjoinedStores:1,parentIndex:1,parent:1,unfilteredChildren:1,children:1,orderedChildren:1,parentId:1,previousSibling:1,nextSibling:1,unfilteredIndex:1},vk={get(i,e){switch(e){case"proxyMeta":return this.proxyMeta;case"constructor":return i.constructor;case"setData":return this.setDataOverride;case"set":return this.setOverride;case"instanceMeta":return this.instanceMetaOverride}return L0[e]?this.proxyMeta.data[e]:Reflect.get(i,e,this.proxyRecord)},set(i,e,t,r){return e==="parentId"?r.setParentId(t):L0[e]?this.proxyMeta.data[e]=t:i[e]=t,!0},instanceMetaOverride(i){const{proxyMeta:e}=this,t=i.id||i,r=e.map||(e.map=T.clone(e.originalRecord.instanceMeta(t)));return r[t]||(r[t]={})},setDataOverride(i,e){i==="parentIndex"?this.proxyMeta.data.parentIndex=e:i==="parentId"?this.proxyMeta.data.parentId=e:this.proxyMeta.originalRecord.setData(i,e)},setOverride(i,e,...t){i==="parentIndex"?this.proxyMeta.data.parentIndex=e:this.proxyMeta.originalRecord.set(i,e,...t)}},O0=i=>{var e;return e=class extends(i||O){link(){if(this.isLinked)return this.$original.link();const t=this,r={...vk,proxyMeta:{originalRecord:t,data:{id:`${t.id}_link_${t.constructor._internalIdCounter}`,internalId:t.constructor._internalIdCounter++,stores:[],unjoinedStores:[],...t.children?{unfilteredChildren:[],children:[],orderedChildren:[]}:{}}}},n=new Proxy(t,r);return r.proxyRecord=n,(t.meta.linkedRecords||(t.meta.linkedRecords=[])).push(n),n}get isLinked(){var t;return!!((t=this.proxyMeta)!=null&&t.originalRecord)}get hasLinks(){return!!(!this.proxyMeta&&this.$links.length)}get recordLinks(){return this.$links}get originalRecord(){return this.$original}getStoreLink(t){if(t.includes(this))return this;for(const r of this.$links)if(t.includes(r))return r;return null}removeLink(t,r=null,n=!1){if(t.hasLinks)for(const s of t.$links.slice())r?L.include(r,s):s.remove(n);else t.isLinked&&L.remove(t.$original.$links,t)}beforeRemove(t){this.removeLink(this,t)}removeChild(t,r,n,s){if(!(s!=null&&s.isInserting)){t=L.asArray(t);for(const a of t)this.removeLink(a,null,n)}return super.removeChild(t,r,n,s)}get $originalId(){return this.$original.id}get $links(){var t;return(t=this.meta.linkedRecords)!=null?t:[]}},p(e,"$name","ModelLink"),p(e,"isModel",!0),e},{defineProperty:$0}=Reflect,qy=Symbol("owner"),yk=/[\s,]+/,En=i=>{var e;return e=class extends(i||O){static get declarable(){return["factoryable","alias","type"]}static register(t,r,n=globalThis.__BRYNTUM_EXAMPLE||(s=>(s=globalThis.DocsBrowser)==null?void 0:s.isDocsBrowser)()){const{factoryable:s}=this.initClass(),{caseless:a,registry:o}=s,l=k.split(t,yk);for(let d,c,u=0;u<l.length;++u){if(c=l[u],d=a?c.toLowerCase():c,!n&&d in o)throw new Error(`Type "${c}" already registered with ${s.class.name} factory`);o[c]=o[d]=r.initClass()}}static isA(t,r){return this.isType(t,r,!0)}static isType(t,r,n){const{factoryable:s}=this,{caseless:a,registry:o}=s,l=o[a?r.toLowerCase():r];return l?n?t instanceof l:t.constructor===l:!1}static setupAlias(t){t.register(t.alias,t)}static setupFactoryable(t,r){const n=r.super.class;let{factoryable:s}=t;s={caseless:!0,defaultType:null,extends:n.factoryable?[n]:null,typeKey:"type",...s},s.class=t,s.registry=Object.create(null),s.extends&&!Array.isArray(s.extends)&&(s.extends=[s.extends]),$0(t,"factoryable",{get(){return s}})}static setupType(t,r){const{type:n}=t;t.register(n,t,r.replaceType),$0(t.prototype,"type",{get:()=>n,set:s=>{if(s!==n)throw new Error("Can not mutate `type` config to different value")}})}static create(t,r){return this.reconfigure(null,t,r)}static reconfigure(t,r,n){const s=this,{factoryable:a}=s,{typeKey:o}=a;let l=n,d,c,u,h,f,g,m,v,y;if(n&&!T.isClass(n)&&(l=null,m=typeof n,m==="function"?g=n:m==="string"?l=n:T.isObject(n)?(d=n.cleanup,c=n.defaults,h=n.owner,g=n.setup,l=n.type,v=n.transform):h=n),v&&(r=typeof v=="string"?h[v](r):v(r)),y=r,typeof y=="string")r={};else if(r){if(r===!0&&(r={}),!T.isObject(r))return h&&r!==t&&(t==null?void 0:t[qy])===h&&(typeof d=="string"?h[d](t):d==null||d(t),t.destroy()),r;y=r[o]}if(y=y&&s.resolveType(y),t){if(r&&(!y||t.constructor===y))return o in r&&(r=T.assign({},r),delete r[o]),t.setConfig(r),t;h&&t[qy]===h&&(typeof d=="string"?h[d](t):d==null||d(t),t.destroy())}if(r){if(c){if(!(u=y)){if(!(u=c[o]||l||a.defaultType))throw new Error(`No default mergeType defined for ${a.class.name} factory`);u=s.resolveType(u)}u&&(r=u.mergeConfigs(c,r))}if(g){if(f=typeof g=="string"?h[g](r,y,c):g(r,y,c),f===null)return f;r=f||r}if(!y){if(!(y=r[o]||l||a.defaultType))throw new Error(`No default type defined for ${a.class.name} factory`);y=s.resolveType(y)}c&&!u&&(r=y.mergeConfigs(c,r)),o in r&&(r=T.assign({},r),delete r[o]),r=new y(r),h&&(r[qy]=h)}return r||null}static resolveType(t,r){if(typeof t!="string")return t;const{factoryable:n}=this,s=n.extends;let a=n.registry[n.caseless?t.toLowerCase():t],o;for(o=0;!a&&s&&o<s.length;++o)a=s[o].resolveType(t,!0);if(!a&&!r)throw new Error(`Invalid type name "${t}" passed to ${n.class.name} factory`);return a}},p(e,"$name","Factoryable"),e},bk=/^([A-Z]+)(?:F|f)ormula/,Ck=/^(.*)$/,B0={this:1,data:1},H0=i=>{var e;return(e=i.fields)==null?void 0:e.reduce((t,r)=>(r.persist&&i.get(r.name)&&(t[r.name]=String(i.get(r.name))),t),{})},vu=class AF extends O.mixin(En,Ie){constructor(){super(...arguments),p(this,"fieldMatchRE",/\$([a-zA-Z\-_]+)/g),p(this,"fieldDelimiterRE",/[^a-zA-Z\-$_]/)}changeHeaders(e){return T.clone(e)}updateInputField(e,t){var r;return(r=this.inputListenerRemover)==null||r.call(this),e&&(this.inputListenerRemover=e.ion({thisObj:this,input:"onFieldInput",change:"onFieldChange"})),this.owner=e}onFieldInput(){var e,t,r,n;const s=this,{inputField:a}=s,o=((e=s.store)==null?void 0:e.modelClass)||(s.record||a.record).constructor,l=s.fieldNames||(s.fieldNames=Object.keys(B0).concat(Object.keys(o.fieldMap)));if(a.formulaProvider===s){const d=(t=a.getCurrentToken(s.fieldDelimiterRE))==null?void 0:t.token,c=d!=null&&d.startsWith("$")?d.substring(1):null,u=(n=(r=a.value.matchAll(s.fieldMatchRE))==null?void 0:r.reduce)==null?void 0:n.call(r,(f,[,g])=>(g===c?l.some(m=>m.startsWith(g))||f.push(g):!B0[g]&&!o.fieldMap[g]&&f.push(g),f),[]);u!=null&&u.length?a.setError(`Undefined data field(s) ${u.join(",")}`,!1,!0):a.clearError();const h=s.resolveCallback(s.handleFormulaInput,s,!1);h==null||h.handler.call(h.thisObj,a,this)}}onFieldChange(){var e;const t=this,{inputField:r}=t,{value:n}=r,s=t.formulaRE?(e=n.trim().match(t.formulaRE||t.constructor.formulaRE||Ck))==null?void 0:e[1]:n,a=t.resolveCallback(t.handleFormulaChange,t,!1);if(s&&a){const o=t.createFormula(s,t.record||r.record,t.store);a==null||a.handler.call(a.thisObj,t,o,r)}}async calculate(e){return this.callback(this.generateContent,this,[e])}updatePrefix(e){this.formulaRE=new RegExp(`^=${e}\\((.+)\\)$`)}updateUrl(e){this.generateContent=e?this.getRemoteContent:null}async getRemoteContent(e){let t;try{const r=this,{method:n,headers:s}=r,a={...r.body};T.setPath(a,r.paramName,e);const o=await Wt.fetch(r.url,T.assign({credentials:void 0,method:n,headers:s,body:JSON.stringify(a)},r.fetchOptions));if(!o.ok)return r.trigger("formulaNetworkError",{response:o,bubbles:!0}),"";t=await o.json()}catch(r){console.error("Error:",r)}return T.getPath(t,this.responseField)}createFormula(e,t,r){const n={formula:e.replaceAll(this.fieldMatchRE,(s,a)=>{var o;switch(a){case"this":return JSON.stringify(H0(t));case"data":return JSON.stringify(r.allRecords.map(l=>H0(l)));default:return(o=t.get(a))!=null?o:""}})};return this.trigger("formulaChange",n),n.formula}get store(){var e;return this._store||((e=this.record)==null?void 0:e.firstStore)}static get(e,t){var r;let n=(r=this.map)==null?void 0:r.get(e);return n&&t&&(n=new n(t)),n}static initClass(){var e,t;const r=AF,n=this,s=n===r?"FORMULA":((t=(e=n.$name)==null?void 0:e.match(bk))==null?void 0:t[1])||n.formulaPrefix;if(s){n.formulaPrefix||(n.formulaPrefix=s),n.inputPrefixRE=new RegExp(`^=${s}\\(.*`),n.formulaRE=new RegExp(`^=${s}\\((.+)\\)`),(r.map||(r.map=new Map)).set(s,n);const a=[...r.map.keys()].map(o=>o).join("|");r.inputPrefixRE=new RegExp(`^=(${a})\\(.*`)}return super.initClass()}};p(vu,"$name","FormulaProvider"),p(vu,"type","formula"),p(vu,"configurable",{callOnFunctions:!0,record:null,store:null,inputField:{$config:"nullify",value:null},handleFormulaInput:null,handleFormulaChange:null,url:null,method:"POST",fetchOptions:null,paramName:"prompt",responseField:"content",headers:{Accept:"application/json","Content-Type":"application/json"},generateContent:null,prefix:null}),p(vu,"factoryable",{defaultType:"formula"});var yu=vu;yu.initClass(),yu._$name="FormulaProvider";var{getOwnPropertyDescriptor:Sk}=Reflect,xt=class extends O.mixin(En){construct(i){const e=this;i&&(e.name=i.name,Object.assign(e,i)),e.compare&&(e.compareItems=(t,r)=>e.compare(t==null?void 0:t[e.name],r==null?void 0:r[e.name]))}changeFormulaProviders(i){const e=this;return new Proxy({...i},{set(t,r,n){const s=Reflect.set(t,r,n);return e.updateFormulaProviders(t),s}})}updateFormulaProviders(i){this.inputPrefixRE=i?new RegExp(`^=(${Object.keys(i).join("|")})\\(.*`):null}getFormulaProvider(i){const e=this.formulaProviders[i];if(e){if(e.isFormulaProvider)return e;let{instance:t}=e;if(!t){const r={...e,prefix:i};t=e.instance=yu.get(i,r)||yu.create(r)}return t}}get label(){return this._label||k.separate(this.name)}set label(i){this._label=i}defineAccessor(i,e){const{name:t,dataSource:r}=this;!e&&t in i&&i.$meta.hierarchy.some(n=>{var s;return((s=Sk(n.prototype,t))==null?void 0:s.enumerable)===!1})||(this.formulaProviders&&i.$meta.class.addField(`#${t}`),Reflect.defineProperty(i,t,{configurable:!0,enumerable:!0,get:this.complexMapping?function(){return this.complexGet(t,r)}:function(){return this.batching&&t in this.meta.batchChanges?this.meta.batchChanges[t]:this.data[r]},set(n){const s=this.$meta.fields.map[t];s&&s.readOnly||this.set(t,n)}}))}isEqual(i,e){return T.isEqual(i,e)}print(i){return i==null?this.nullText:this.printValue(i)}printValue(i){return String(i)}getCurrentConfig(){const i={};for(const e in this.constructor.prototypeProperties)i[e]=this[e];return delete i.isConstructing,i}get calculated(){return!!(this.calculate||this._calculated)}set calculated(i){this._calculated=i}get calculate(){return this._calculate}set calculate(i){typeof i=="function"&&(i={fn:i}),this._calculate=i}};p(xt,"$name","DataField"),p(xt,"type","auto"),p(xt,"factoryable",{defaultType:"auto"}),p(xt,"prototypeProperties",{compare:null,compareItems:null,dataSource:null,alwaysWrite:!1,nullable:!0,nullText:null,nullValue:void 0,persist:!0,readOnly:!1,internal:!1,calculated:!1,calculate:null,useProp:null,bypassEqualityOnSyncDataset:!1,complexMapping:null}),p(xt,"configurable",{formulaProviders:null}),xt._$name="DataField";var Ao=class extends xt{isEqual(i,e){return i===e}getAt(i,e){return i.get(this.name)[e]}};p(Ao,"$name","ArrayDataField"),p(Ao,"type","array"),p(Ao,"dataConstructor",Array),Ao.initClass(),Ao._$name="ArrayDataField";var Vs=class extends xt{static get prototypeProperties(){return{nullValue:!1}}isEqual(i,e){return i==null&&e==null?!0:super.isEqual(i,e)}convert(i){var e;return i==null?this.nullable?i:this.nullValue:((e=i.toLowerCase)==null?void 0:e.call(i))==="false"?!1:!!i}};p(Vs,"$name","BooleanDataField"),p(Vs,"type","boolean"),p(Vs,"dataConstructor",Boolean),p(Vs,"alias","bool"),Vs.initClass(),Vs._$name="BooleanDataField";var js=class extends xt{static get prototypeProperties(){return{format:null}}convert(i){if(i==null)this.nullable||(i=this.nullValue);else if(i==="now")i=new Date;else if(!(i instanceof Date)){const e=i;i=S.parse(i,this.format||S.defaultParseFormat),(!i||isNaN(i))&&(i=void 0,e!==""&&console.warn(`Date parsing failed for "${this.name}" field, input: ${JSON.stringify(e)}. ${this.format?`Expected format: ${this.format}.`:'You should configure your Model field with a "format" to specify how dates should be parsed. See docs for DateDataField here: https://bryntum.com/products/scheduler/docs/api/Core/data/field/DateDataField, and see https://bryntum.com/products/scheduler/docs/api/Core/helper/DateHelper for the different formats.'}"`))}return i}serialize(i){return i instanceof Date&&(i=S.format(i,this.format||S.defaultFormat)),i}printValue(i){return S.format(i,this.format||S.defaultFormat)}};p(js,"$name","DateDataField"),p(js,"type","date"),p(js,"dataConstructor",Date),js.initClass(),js._$name="DateDataField";var zs=class extends xt{static get prototypeProperties(){return{nullValue:""}}convert(i){return i==null?this.nullable?i:this.nullValue:String(i)}};p(zs,"$name","StringDataField"),p(zs,"type","string"),p(zs,"dataConstructor",String),zs.initClass(),zs._$name="StringDataField";var bu=class extends zs{isEqual(i,e){return S.compareUnits(i,e)===0}};p(bu,"$name","DurationUnitDataField"),p(bu,"type","durationunit"),bu.initClass(),bu._$name="DurationUnitDataField";var Ns=class extends xt{static get prototypeProperties(){return{nullValue:0,rounding:"round"}}convert(i){return i==null?this.nullable?i:this.nullValue:Math[this.rounding](Number(i))}};p(Ns,"$name","IntegerDataField"),p(Ns,"type","integer"),p(Ns,"alias","int"),p(Ns,"dataConstructor",Number),Ns.initClass(),Ns._$name="IntegerDataField";var Po=class extends xt{static get prototypeProperties(){return{complexMapping:!0}}isEqual(i,e){return i&&e&&e instanceof i.constructor&&e.id==i.id}};p(Po,"$name","ModelDataField"),p(Po,"type","model"),p(Po,"configurable",{modelClass:null}),Po.initClass(),Po._$name="ModelDataField";var xn=class extends xt{static get prototypeProperties(){return{nullValue:0,precision:null}}isEqual(i,e){return isNaN(Number(i))&&isNaN(Number(e))||super.isEqual(i,e)}convert(i){if(i==null)return this.nullable?i:this.nullValue;if(i=Number(i),isNaN(i))return;let e=this.precision;return e?(e=10**e,i=Math.round(i*e)/e):e===0&&(i=Math.round(i)),i}};p(xn,"$name","NumberDataField"),p(xn,"type","number"),p(xn,"alias","float"),p(xn,"dataConstructor",Number),xn.initClass(),xn._$name="NumberDataField";var ko=class extends xt{static get prototypeProperties(){return{complexMapping:!0}}};p(ko,"$name","ObjectDataField"),p(ko,"type","object"),p(ko,"dataConstructor",Object),ko.initClass(),ko._$name="ObjectDataField";var wk=i=>typeof i=="string"&&i.startsWith("_generated"),Cu=class extends xt{init(i,e,t){var r;const n=this,s=`${n.name}Store`,a={skipStack:!0,syncDataOnLoad:!0,useRawData:!1};if(n.store&&T.assign(a,n.store),n.modelClass&&(a.modelClass=n.modelClass),(r=e[`init${k.capitalize(s)}`])==null||r.call(e,a),!a.storeClass&&!n.storeClass)throw new Error(`Field '${n.name}' with type 'store' must have a storeClass configured`);const o=e.meta[s]=new(a.storeClass||n.storeClass)(a);n.complexMapping?T.setPath(i,n.dataSource,o):i[n.dataSource]=o,o.verifyNoGeneratedIds=!1,o.usesId=n.usesId||!o.count||!o.every(l=>l.hasGeneratedId),o.$currentValue=n.getValue(o,e),o.ion({change:({action:l})=>{const d=n.getValue(o,e);if(!o.$isSettingStoreFieldData){const c=o.$preserveCurrentDataset;o.$preserveCurrentDataset=n.subStore&&(l==="update"||l==="remove"||l==="add"),n.$isUpdatingRecord=!0,e.set(n.name,d),n.$isUpdatingRecord=!1,o.$preserveCurrentDataset=c}o.$currentValue=d}}),n.$chrono&&t(n,o)}set(i,e,t){var r,n;const s=this,a=`${s.name}Store`,{[a]:o}=t.meta;if(i!=null&&i.isStore&&(i=i.$currentValue),!o)return t.meta.initableValues.set(s,i),!1;o.$isSettingStoreFieldData||(o.$isSettingStoreFieldData=!0,i=(n=(r=t[`process${k.capitalize(a)}Data`])==null?void 0:r.call(t,i,t))!=null?n:i,o.$preserveCurrentDataset||(o.data=i),o.$isSettingStoreFieldData=!1,o.usesId=s.usesId||!o.count||!o.every(l=>l.hasGeneratedId))}serialize(i,e){const t=e.meta[`${this.name}Store`];return this.$isUpdatingRecord?this.getValue(t,e):t.$currentValue}getValue(i,e){const t=`get${k.capitalize(this.name)}StoreValue`;return e[t]?e[t](i):i.allRecords.map(r=>{const n=r.persistableData;return i.usesId||delete n.id,n})}isEqual(i,e){if(i==null&&e==null)return!0;if(i==null&&e!=null||i!=null&&e==null)return!1;if(i.isStore&&e.isStore)return T.isDeeplyEqual(i.$currentValue,e.$currentValue);if(i.isStore&&e.isStore||!i.isStore&&!e.isStore)return T.isEqual(i,e,!0);{const t=i.isStore?i:e,r=t.modelClass,n=r.$meta.fields.defs,s=i.isStore?i.$currentValue:e.$currentValue,a=i.isStore?e:i;if(s.length!==a.length)return!1;for(let o=0;o<n.length;o++){const l=n[o];if(l.persist)for(let d=0;d<s.length;d++){const c=s[d][l.dataSource],u=a[d][l.dataSource];if(!(c!==void 0&&u===void 0&&(l.dataSource===r.idField&&wk(c)||l.defaultValue!==void 0&&T.isEqual(l.defaultValue,c,!0)))&&!T.isEqual(c,u,!0))return!1}}return!0}}getOldValue(i){const e=i.meta[`${this.name}Store`];return e?T.clone(e.$currentValue):null}getAt(i,e){const t=i.meta[`${this.name}Store`];return t==null?void 0:t.getAt(e)}};p(Cu,"$name","StoreDataField"),p(Cu,"type","store"),Cu.initClass(),Cu._$name="StoreDataField";var V0=/^(.*?)\.(.*)/,Yy=/(.*)\[(.*)]\.?(.*)/,{defineProperty:Dk}=Reflect,{hasOwn:Su}=T,Ws=void 0,Ek={children:1,data:1,meta:1},xk=["name","title","text","label","description"],Rk={boolean:1,number:1,date:1,object:1},j0={parentId:1,$PhantomId:2,id:3},Ky=class Eg extends O.mixin(P0,k0,O0){static get declarable(){return["fields"]}static get fields(){return[{name:"parentIndex",type:"number",persist:!1,internal:!0},{name:"orderedParentIndex",type:"number",persist:!1,internal:!0},{name:"readOnly",type:"boolean"},{name:"expanded",internal:!0}]}static set idField(e){this._assignedIdField=!0,this._idField=e}static get idField(){return this._idField}get id(){var e;return(e=this._id)!=null?e:this.getData("id")}set id(e){this.set("id",e)}static set childrenField(e){this._childrenField=e}static get childrenField(){if(!this._childrenField){const e=this.fieldMap.children;this._childrenField=(e==null?void 0:e.dataSource)||"children"}return this._childrenField}get indexPath(){const e=[];let t=this,r=t.childLevel;for(t=this;t&&!t.isRoot;t=t.parent)e[r--]=t.parentIndex+1;return e}construct(e={},t=null,r=null,n=!1,s=!1,a=!1){var o,l;const d=this,{constructor:c,fieldMap:u}=d;if(d.meta={modified:{},...c.metaConfig,...r},c.applyConfigs){const f={};(!d.useRawData||!d.useRawData.enabled)&&(e={...e});const g=d.getDefaultConfiguration();if(c.autoExposeFields)for(const m in g)m in e&&(e[m]!==void 0&&(f[m]=e[m]),delete e[m]);else for(const m in e)m in c.fieldMap||(e[m]===void 0?f[m]=g[m]:f[m]=e[m],delete e[m]);super.construct(f)}if(n||c.exposeProperties(e,a),!Su(c,"idFieldProcessed")){let f=d.meta.idField;f||c._assignedIdField&&(f=c.idField),f&&f!==u.id.dataSource&&c.addField({name:"id",dataSource:f,internal:!0}),c._idField=u.id.dataSource,c.idFieldProcessed=!0}d._internalId=Eg._internalIdCounter++,d.originalData||(d.originalData=e);const h=c.processData(e,!1,t,d,s);d._id=u.id.complexMapping?T.getPath(h,c._idField):h[c._idField],(o=d.meta.initableValues)!=null&&o.size&&d.assignInitables(),d._id==null&&!(c.allowNullId&&d._id===null)&&d.setData("id",d.generateId(t)),h[c.childrenField]&&d.processChildren((l=L.asArray(t))!=null?l:[]),d.generation=0}set isCreating(e){var t;const r=this;!!r.meta.isCreating!==e&&(r.meta.isCreating=e,(t=r.stores)==null||t.forEach(n=>n.onIsCreatingToggle(r,e)))}get isCreating(){return!!this.meta.isCreating}equals(e){if(e instanceof this.constructor){for(let t=this.$meta.fields.defs,r=0,{length:n}=t;r<n;r++){const s=t[r],{name:a}=s;if(a!=="id"&&!s.isEqual(this.getValue(a),e.getValue(a)))return!1}return!0}return!1}static processData(e,t=!1,r,n,s){const a=this,{map:o,defaults:l,chronoProps:d}=a.$meta.fields,{useRawData:c={enabled:!1}}=r||{},u=s||c.enabled?e:T.clone(e),h=!!n.$entity;n.isConstructing&&(n.data=u);let f,g;if(h&&!t){g={};for(const v of d)g[v.name]=n.createFieldIdentifier(v);Object.defineProperty(n,"$",{value:g,enumerable:!0,configurable:!0})}const m=t||c.disableDefaultValue||s;if(!m||!c.disableTypeConversion&&!s||h)for(f in o){const v=o[f],{name:y,dataSource:b}=v,C=b!==y,D=v.complexMapping,w=D?T.getPath(u,b):u[b],x=w===void 0?D?T.getPath(u,y):u[y]:void 0,R=w!==void 0,M=x!==void 0,I=!R&&M,_=R||M,F=!c.disableTypeConversion&&v.convert;let A=I?x:w;if(!m&&b in l&&!_&&!v.fromData){let P=l[b];Array.isArray(P)?P=P.slice():P instanceof Date?P=new Date(P):P&&typeof P=="object"&&(P=T.clone(P)),D?T.setPath(u,b,P):u[b]=P,A=P}if((I||F)&&(!m||_)&&!s&&!v.calculate){let P=F?v.convert(A,e,n):A;a.processFieldData&&(P=a.processFieldData(v,P,A,e,n)),P===void 0&&A===void 0&&!R||(D?T.setPath(u,b,P):u[b]=P,C&&delete u[y],A=P)}if(!t&&v.$chrono){const P=g[y]=n.createFieldIdentifier(v.$chrono);P.DATA=A}}return a.$meta.fields.calculated.forEach(v=>{const{calculate:y}=v;if(!v._cachedDependencies&&!y.dependsOn){v._cachedDependencies=!0;const b=new Set,C=new Proxy(u,{get(w,x){return b.add(x),u[x]}});let D;try{y.fn(C,n),y.dependsOn=Array.from(b),a.setupDependentCalcFields(v),D=b.size===0}catch(w){D=!0}D&&console.warn(`Failed to auto-detect dependent fields for "${v.name}" field. Add "dependsOn" in your calculate config.`)}u[v.name]=n.refreshCalculatedField(v)}),a.$meta.fields.initable.length&&a.initInitables(n,u,(v,y)=>{const b=g[v.name]=n.createFieldIdentifier(v.$chrono);b.DATA=y}),u}static setupClass(e){super.setupClass(e),e.fields||this.setupFields(this,e)}static setupFields(e,t){var r,n,s,a,o;const l=Su(e,"fields")&&e.fields,d=t.super.fields,c=t.fields={defs:(r=d==null?void 0:d.defs.slice())!=null?r:[],calculated:(n=d==null?void 0:d.calculated.slice())!=null?n:[],exposedData:!1,defaults:d?{...d.defaults}:{},exposed:Object.create((s=d==null?void 0:d.exposed)!=null?s:null),ordinals:Object.create((a=d==null?void 0:d.ordinals)!=null?a:null),map:d?{...d.map}:{},sources:d?{...d.sources}:{},chronoProps:[],subModels:[]};if(e!==Eg){let u=t;do u=u.super,u.fields.subModels.push(e);while(u.class!==Eg)}if(Su(e,"defaults")&&Object.assign(c.defaults,e.defaults),Su(e,"idField")&&(e.addField({name:"id",dataSource:e.idField,internal:!0}),c.exposed[e.idField]=!0),l!=null&&l.length&&l.map(e.addField,e),c.initable=c.defs.filter(u=>u.init),(o=e.$entity)!=null&&o.allFields.size)for(const u of e.$entity.allFields.values())c.map[u.name]||c.chronoProps.push(u);e.exposeRelations()}static get defaultValues(){return this.$meta.fields.defaults}static get allFields(){return this.$meta.fields.defs}get allFields(){return this.$meta.fields.defs}static get fieldMap(){return this.$meta.fields.map}get fieldMap(){return this.$meta.fields.map}static get fieldDataSourceMap(){return this.$meta.fields.sources}static exposeProperties(e,t=!0){const r=this,n=r.$meta.fields,s=t?"exposed":"map";if(e&&r.autoExposeFields&&!n.exposedData){let a,o,l;for(a in e)!n[s][a]&&a!==r.childrenField&&(l=T.typeOf(e[a]),o={name:a,dataSource:a,fromData:!0},Rk[l]&&(o.type=l),r.addField(o));n.exposedData=!0}r.exposeRelations()}static addField(e){var t;if(e==null)return;typeof e=="string"&&(e={name:e});const r=this.initClass(),n=r.$meta.fields,{ordinals:s,calculated:a,subModels:o}=n,l=n.exposed,{name:d}=e,c=n.map[d],u=e.dataSource||(e.dataSource=d);let h,f;if(!c||e.type&&e.type!==c.type)e.model=r,h=xt.create(e),e.model=null,h.definedBy=c?c.definedBy:r,h.ordinal=c?c.ordinal:s[d]=n.defs.length,(t=h.calculate)!=null&&t.dependsOn&&r.setupDependentCalcFields(h);else{h=Object.create(c);for(f in e)f!=="type"&&(h[f]=e[f])}h.owner=r,n.defs[h.ordinal]=h,n.map[d]=h,n.sources[u]=h;for(const g of o)g.$meta.fields.map[d]=h;return h.complexMapping!==!1&&u.includes(".")&&(h.complexMapping=!0),h.complexMapping?l[u.split(".")[0]]=!0:l[u]=!0,"defaultValue"in h&&(n.defaults[u]=h.defaultValue),Ek[d]||h.defineAccessor(r.prototype),h.calculate&&a.push(h),r._nonPersistableFields=null,r._alwaysWriteFields=null,h}static setupDependentCalcFields(e){const t=this.$meta.fields;e.calculate.dependsOn.forEach(r=>{if(!t.map[r])throw new Error(`No "${r}" field defined in ${this.$name} class`);t.map[r].dependentFields=t.map[r].dependentFields||[],t.map[r].dependentFields.push(e.name)})}static removeField(e){const t=this.initClass(),r=t.$meta.fields,n=r.map[e],{ordinals:s}=r,a=s[e];if(n){r.defs.splice(a,1),delete s[e],delete r.defaults[e],delete r.exposed[e],delete r.map[e],delete r.sources[n.dataSource];for(const o in s)s[o]>a&&--s[o];delete t.prototype[e]}}static exposeRelations(){const e=this;if(!Su(e,"exposedRelations")&&e.relations){e.exposedRelations=[];for(const t in e.relations){const r=e.relations[t];r.relationName=t,e.exposedRelations.push(r),Reflect.ownKeys(e.prototype).includes(t)||Dk(e.prototype,t,{enumerable:!0,get:function(){return this.getForeign(t)},set:function(n){this.setForeign(t,n,r)}})}}}static initInitables(e,t,r){const n=e.meta.initableValues=new Map;for(const s of this.$meta.fields.initable){const a=T.getPath(t,s.dataSource);a!==void 0&&n.set(s,a),!s.lazy&&s.init(t,e,r)}}assignInitables(){const{initableValues:e}=this.meta;for(const[t,r]of e)t.set(r,this.data,this)!==!1&&e.delete(t)}static get autoExposeFields(){return!0}static fieldSorter(e,t){return(j0[e]||100)-(j0[t]||100)}get fields(){return this.$meta.fields.defs}getFieldDefinition(e){return this.constructor.getFieldDefinition(e)}getFieldDefinitionFromDataSource(e){return this.$meta.fields.sources[e]}get fieldNames(){return Object.keys(this.data)}static getFieldDefinition(e){var t;const r=this.fieldMap[e];if(!r){if(e.includes("[")){const[,n,,s]=e.match(Yy),a=n.includes(".")?this.getFieldDefinition(n):this.fieldMap[n];if(a!=null&&a.isStoreDataField)return(t=a.modelClass)==null?void 0:t.getFieldDefinition(s)}else if(e.includes(".")){const[n,s]=e.split(".",2),a=this.fieldMap[n];if(a!=null&&a.isModelDataField&&a.modelClass)return a.modelClass.getFieldDefinition(s)}}return r}static getFieldDataSource(e){var t;return((t=this.getFieldDefinition(e))==null?void 0:t.dataSource)||e}getDataSource(e){const t=this.constructor.getFieldDefinition(e);return(t==null?void 0:t.dataSource)||(t==null?void 0:t.name)}static processField(e,t,r){const n=this.fieldMap[e];return n!=null&&n.convert?n.convert(t,this.data,r):t}initRelations(){const e=this;e.constructor.exposedRelations&&e.stores.forEach(r=>{var n;r.modelRelations||r.initRelations();const s=[];(n=r.modelRelations)==null||n.forEach(a=>{s.push({related:e.initRelation(a),config:a})}),r.updateRecordRelationCache(e,s)})}initRelation(e){const t=this,r=t.get(e.foreignKey),n=r!==Ws&&typeof e.foreignStore!="string"&&e.foreignStore.getById(r),s=t.meta.relationCache||(t.meta.relationCache={});return s[e.relationName]=n||(r!=null?{id:r,placeHolder:!0}:null),n}removeRelation(e){const{relationName:t,foreignKey:r,nullFieldOnRemove:n}=e;this.meta.relationCache[t]&&(delete this.meta.relationCache[t],n&&this.setData(r,null))}getForeign(e){var t;return(t=this.meta.relationCache)==null?void 0:t[e]}setForeign(e,t,r){const n=Eg.asId(t);return this.set(r.foreignKey,n)}getRelationConfig(e){var t,r;return(r=(t=this.firstStore)==null?void 0:t.modelRelations)==null?void 0:r.find(n=>n.foreignKey===e)}flatGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:this.data[t]}complexGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:T.getPath(this.data,t)}get(e){if(!e)return;const t=this,{fieldMap:r}=t,n=r[e];if(!n){if(e.includes("[")){const[,s,a,o]=e.match(Yy),l=r[s];if(l!=null&&l.getAt){t._thisIsAUsedExpression(t[s]);const d=l.getAt(t,a);return d&&o?d.isModel?d.getValue(o):d[o]:d}return null}if(e.includes(".")){const[s,a]=e.split(".",2),o=r[s];if(o!=null&&o.isStoreDataField){const l=t[s],d=l.modelClass;return a in d.fieldMap||!(a in l)?l==null?void 0:l.getDistinctValues(a):l[a]}else if(!T.hasPath(t.data,e))return T.getPath(t,e);return t.complexGet(e,e)}}return n!=null&&n.complexMapping?t.complexGet(e,n.dataSource):t.flatGet(e,(n==null?void 0:n.dataSource)||e)}getValue(e){if(e)return e in this&&!e.includes(".")?this[e]:this.get(e)}setValue(e,t){e in this?this[e]=t:this.set(e,t)}setData(e,t){var r,n;const{data:s,fieldMap:a}=this;if(typeof e=="string"){const o=a[e],l=(r=o==null?void 0:o.dataSource)!=null?r:e;o!=null&&o.set?o.set(t,this.data,this):o!=null&&o.complexMapping?T.setPath(s,l,t):s[l]=t,o==="id"?this._id=t:e==="parentId"&&(s[this.constructor.parentIdField]=t)}else{const o=Object.keys(e);for(let l=0;l<o.length;l++){const d=o[l],c=a[d],u=(n=c==null?void 0:c.dataSource)!=null?n:d;c!=null&&c.set?c.set(t,this.data,this):u&&(c!=null&&c.complexMapping?T.setPath(s,u,e[d]):s[u]=e[d],d==="id"?this._id=t:d==="parentId"&&(s[this.constructor.parentIdField]=t))}}}getData(e){var t;const r=this.fieldMap[e],n=(t=r==null?void 0:r.dataSource)!=null?t:e;if(n)return r!=null&&r.complexMapping?T.getPath(this.data,n):this.data[n]}syncId(e){const t=this.id;if(t!==e){this._id=e,this.setData("id",e);const r={id:{value:e,oldValue:t}};this.afterChange(r,r)}}set(e,t,r=!1,n=!1,s=!1,a=!1,o=!0){var l;const d=this;if(d.isBatchUpdating)d.inBatchSet(e,t,r||d.$silenceBatch);else{const c=d.inSet(e,t,r,n,s,a,o);return(l=d.afterSet)==null||l.call(d,e,t,r,n,c),c}}updateDependentFieldValues(e){if(typeof e=="object")Object.keys(e).forEach(t=>this.updateDependentFieldValues(t));else{e.startsWith("#")&&(e=e.substring(0));for(const[t,r]of Object.entries(this.constructor.dependentFields||{}))e in r&&this.set(t,this.get(`#${t}`))}}fieldToKeys(e,t){return typeof e!="string"?T.assign({},e):{[e]:t}}inBatchSet(e,t,r){var n;const s=this,{meta:a,constructor:o,fieldMap:l}=s,d={};let c,u=!1;if(typeof e!="string"?Object.keys(s.fieldToKeys(e,t)).forEach(h=>{c=l[h]||T,t=o.processField(h,e[h],s),c.isEqual(a.batchChanges[h],t)||(d[h]={value:t,oldValue:s.get(h)},a.batchChanges[h]=t,u=!0)}):(c=l[e]||T,c.isEqual(a.batchChanges[e],t)||(d[e]={value:t,oldValue:s.get(e)},a.batchChanges[e]=t,u=!0)),u&&(s.generation++,!r)){const h={action:"update",record:s,records:[s],changes:d};(n=s.stores)==null||n.forEach(f=>f.trigger("batchedUpdate",{...h})),s.forEachLinked((f,g)=>f.trigger("batchedUpdate",{...h,record:g,records:[g]}))}}inSet(e,t,r,n,s=!1,a=!1,o=!0){var l,d,c,u,h,f,g,m,v,y,b,C,D,w,x,R;const M=this,{data:I,meta:_,fieldMap:F,constructor:A}=M,{prototype:P,childrenField:V,relations:B}=A,W={},q=M.fieldToKeys(e,t),G=Object.keys(q).sort(A.fieldSorter),Z=(l=M.stores)==null?void 0:l.some(Ce=>Ce.isSyncingDataOnLoad),ne=(d=M.stores)==null?void 0:d.some(Ce=>Ce.modificationsTracking>0);if(!r&&o&&!M.triggerBeforeUpdate(q))return null;let J=!1,ee,Q,ae;if(typeof e=="object"&&Object.keys(e).length===1&&(t=Object.values(e)[0],e=Object.keys(e)[0]),typeof e=="string"&&(ee=M.getFieldDefinition(e))&&ee.formulaProviders){const Ce=(c=t==null?void 0:t.match(ee.inputPrefixRE))==null?void 0:c[1];ae=`#${e}`,Q=(u=ee.formulaProviders[Ce])==null?void 0:u.instance,Q||(Q=(h=ee.getFormulaProvider)==null?void 0:h.call(ee,Ce)),G.push(ae),q[ae]=t}if(Q){const{formulaRE:Ce}=Q,oe=Ce?(m=(g=(f=t.trim()).match)==null?void 0:g.call(f,Ce))==null?void 0:m[1]:t;if(oe){const yi=M.constructor,He=yi.dependentFields||(yi.dependentFields={}),Or=Q.createFormula(oe,M,M.firstStore),We=Q.calculate(Or);(y=(v=oe==null?void 0:oe.matchAll(Q.fieldMatchRE))==null?void 0:v.forEach)==null||y.call(v,([,Dt])=>{Dt!==e&&((He[e]||(He[e]={}))[Dt]=1)}),q[e]=We,_.pendingFormulae=(_.pendingFormulae||0)+1;try{(b=We.then)==null||b.call(We,Dt=>{_.pendingFormulae=Math.max(0,_.pendingFormulae-1),M.set({[e]:Dt,[ae]:t})})}catch(Dt){_.pendingFormulae=Math.max(0,_.pendingFormulae-1),M.firstStore.trigger("formulaError",{record:M,field:e,error:Dt,formula:t}),M.set(e,"")}}}M.inSetting=!0;for(let Ce=0;Ce<G.length;Ce++){const oe=G[Ce];if(oe===V)continue;if(oe.includes("[")){const[,pn,Ls,BD]=oe.match(Yy),iu=M.fieldMap[pn];if(iu!=null&&iu.getAt){const Tg=(D=iu.getAt(M,Ls))!=null?D:(C=iu.onSubRecordMissingInSet)==null?void 0:C.call(iu,M,Ls);if(Tg==null)throw new Error(`The store field '${pn}' does not contain a record at index ${Ls} - can not set the data`);Tg.isModel?Tg.set(BD,q[oe]):T.setPath(Tg,BD,q[oe]);continue}}const yi=oe.includes(".");if(B&&yi){const[,pn,Ls]=oe.match(V0);if(B[pn]){Ls.includes(".")?M[pn].set(Ls,q[oe]):M[pn][Ls]=q[oe];continue}}const He=F[oe],Or=He||T,We=He==null?void 0:He.readOnly,Dt=(w=He==null?void 0:He.dataSource)!=null?w:oe,tu=!s&&!He&&oe in P||(He==null?void 0:He.useProp),bi=tu?M[Dt]:He!=null&&He.complexMapping||yi?T.getPath(I,Dt):I[Dt],Ue=A.processField(oe,q[oe],M),ks=q[oe]={value:Ue},tA=T.isPromise(Ue),qv=M.getRelationConfig(oe);!We&&(Z&&(He!=null&&He.bypassEqualityOnSyncDataset)||!Or.isEqual(bi,Ue))&&(!a||Ue!==void 0)&&(M.generation++,ks.oldValue=(R=(x=He==null?void 0:He.getOldValue)==null?void 0:x.call(He,M))!=null?R:bi,J=!0,oe in _.modified&&Or.isEqual(_.modified[oe],Ue,!1,!0)?(Reflect.deleteProperty(_.modified,oe),M.isReverting&&(M.data[Dt]=Ue)):!M.ignoreBag&&!ne?(!(oe in _.modified)&&!(bi==null&&Ue==null)&&!tA&&M.storeFieldChange(oe,bi),ks.oldValue===Ws&&Reflect.deleteProperty(ks,"oldValue")):ne&&Reflect.deleteProperty(_.modified,oe),W[oe]=ks,M.applyValue(tu,Dt,Ue,s,He),qv&&!n&&(M.initRelation(qv),M.stores.forEach(pn=>pn.cacheRelatedRecord(M,Ue,qv.relationName,ks.oldValue))))}return J&&M.afterChange(q,W,r,n,s),M.updateDependentFieldValues(e),M.inSetting=!1,J?W:null}applyValue(e,t,r,n,s){var a,o;const l=this;if(((s==null?void 0:s.dataSource)||t)===l.constructor.idField&&(l.$isPhantom=!1,l._id=r),((s==null?void 0:s.dataSource)||t)===l.constructor.parentIdField)(a=l.firstStore)!=null&&a.tree&&!((o=l.parent)!=null&&o.isRoot&&(r==null||!l.firstStore.getById(r)))&&(l.firstStore.getById(r)||l.firstStore.rootNode).insertChild(l,null,!1,{orderedParentIndex:{skip:!0}});else if(e)l[(s==null?void 0:s.name)||t]=r;else if(s!=null&&s.set)s.set(r,l.data,l);else{let d=s==null?void 0:s.complexMapping;if(!s&&t.includes(".")){const c=t.split(".")[0];s=l.constructor.fieldMap[c],d=(s==null?void 0:s.complexMapping)||(s==null?void 0:s.type)==="object"}d?T.setPath(l.data,t,r):l.data[t]=r}}afterChange(e,t,r,n,s){const a=this.updateDependentFields(Object.keys(t));if(a&&Object.assign(t,a),this.stores)for(const o of this.stores)o.onModelChange(this,e,t,r,n,s);this.forEachLinked((o,l)=>o.onModelChange(l,e,t,r,n,s))}updateDependentFields(e){const t={};return e.forEach(r=>{var n,s;(s=(n=this.getFieldDefinition(r))==null?void 0:n.dependentFields)==null||s.forEach(a=>{const o=this.fieldMap[a],l=this.refreshCalculatedField(o);t[a]=l})}),Object.keys(t).length>0?this.set(t,void 0,!0):t}refreshCalculatedField(e){var t;const r=this;typeof e=="string"&&(e=r.getFieldDefinition(e));const n=(t=e.calculate)==null?void 0:t.fn.call(e,r);return T.isPromise(n)&&(r.isConstructing?r.data[e.name]=n:r[e.name]=n,n.then(s=>r[e.name]=s)),n}forEachLinked(e){for(const t of this.$links)for(const r of t.stores)e(r,t)}get isPersistable(){return!this.isBatchUpdating&&!this.isCreating}get isModified(){return!!(this.meta.modified&&Object.keys(this.meta.modified).length>0)}get hasPersistableChanges(){return this.isPersistable&&!T.isEmpty(this.rawModificationData)}isFieldModified(e){return this.isModified&&e in this.meta.modified}getUnmodified(e){return this.isModified?this.meta.modified[e]:this.get(e)}getFieldPersistentValue(e){const t=typeof e=="string"?this.getFieldDefinition(e):e,r=(t==null?void 0:t.name)||e;let n;return(!t||t.persist)&&(n=this.getValue(r),t!=null&&t.serialize&&(n=t.serialize(n,this))),n}get modifications(){const e=this.rawModifications;return e&&Object.keys(e).length&&(e[this.constructor.idField]=this.id),e}get rawModifications(){const e=this,t={};if(!e.isModified)return null;let r=!1;return Object.keys(e.meta.modified).forEach(n=>{const s=e.getFieldPersistentValue(n);s!==Ws&&(t[n]=s,r=!0)}),r?t:null}get modificationData(){const e=this.rawModificationData;return e&&Object.keys(e).length&&T.setPath(e,this.constructor.idField,this.id),e}get rawModificationData(){const e=this,{fieldMap:t}=e.constructor,r={};if(!e.isModified)return null;let n=!1;return Object.keys(e.meta.modified).forEach(s=>{let a=t[s],o=a==null?void 0:a.dataSource;if(s.includes(".")){const l=s.match(V0)[1];a=t[l],o=s}if(a!=null&&a.persist){const l=e.getFieldPersistentValue(s);l!==Ws&&(T.setPath(r,o,l),n=!0)}}),n?r:null}get modificationDataToWrite(){const e=this,{modificationData:t,constructor:r}=e,n=t!=null?t:{},s=r.alwaysWriteFields;let a=!!t;return s.forEach(o=>{T.setPath(n,o.dataSource,e.getFieldPersistentValue(o)),a=!0}),a&&!t&&T.setPath(n,r.idField,e.id),a?n:null}get persistableData(){const e=this,t={};return e.fields.forEach(r=>{const n=e.getFieldPersistentValue(r);n!==Ws&&(r!=null&&r.complexMapping?T.setPath(t,r.dataSource,n):t[r.dataSource]=n)}),t}get dataByFieldName(){const{data:e}=this;return this.fields.reduce((t,r)=>(T.hasPath(e,r.dataSource)&&(t[r.name]=e[r.dataSource]),t),{})}get isCommitting(){return!!this.meta.committing}clearChanges(e){var t;this.internalClearChanges(e),(t=this.stores)==null||t.forEach(r=>r.trigger("clearChanges",{record:this}))}internalClearChanges(e=!0,t=!0,r=null,n=!1){var s,a,o;const l=this,{meta:d}=l;if(r){const{modified:u}=d;for(const h in r)delete u[h];for(const h in u)((s=u[h])!=null&&s.isStore&&!u[h].changes||n&&!((a=l.getFieldDefinition(h))!=null&&a.persist))&&delete u[h]}else d.modified=Object.assign({},d.modifiedMaterialized),d.modifiedMaterialized=null;const c=T.isEmpty(d.modified);d.committing=!1,t&&((o=l.stores)==null||o.forEach(u=>{if(c&&u.modified.remove(l),u.added.remove(l),e){const h=u.collectDescendants(l).all;u.added.remove(h),c&&u.modified.remove(h)}}))}storeFieldChange(e,t){var r;const{meta:n}=this;n.modified[e]=t,this.isBeingMaterialized&&(n.modifiedMaterialized=(r=n.modifiedMaterialized)!=null?r:{},n.modifiedMaterialized[e]=t)}revertChanges(e=!1){this.isReverting=!0,this.set(this.meta.modified,Ws,e),this.isReverting=!1}setByDataSource(e){var t;const r=this,{fieldDataSourceMap:n}=r.constructor,s=T.pathifyKeys(e,n),a={};for(const o in s){const l=n[o],d=(t=l==null?void 0:l.name)!=null?t:o;a[d]=s[o]}return r.set(a)}applyChangeset(e,t="$PhantomId",r=!0){var n;const s=this,a=s.constructor,{idField:o,fieldDataSourceMap:l}=a,d=T.pathifyKeys(e,l),c=T.pathifyKeys(s.modificationData),u={};!(t in e&&!(o in e))&&t in d&&delete d[t];for(const g in d){const m=l[g],v=(n=m==null?void 0:m.name)!=null?n:g;(r||c[g]===d[g])&&(u[v]=d[g])}const f=s.set(u);return s.internalClearChanges(!1,!0,u),f?Object.entries(f).reduce((g,[m,v])=>(g[m]=v.value,g),{}):{}}get internalId(){return this._internalId}get isPhantom(){return this.id===""||this.id==null||this.hasGeneratedId||!!this.$isPhantom}get isModel(){return!0}get hasGeneratedId(){return typeof this.id=="string"&&this.id.startsWith("_generated")}static generateId(e=this.$$name){return`_generated${e}_${k.generateUUID()}`}generateId(){return this.constructor.generateId()}static asId(e){return e!=null&&e.isModel?e.id:T.isObject(e)?e[this.fieldMap.id.dataSource]:e}get json(){return k.safeJsonStringify(this)}toJSON(){const{children:e,unfilteredChildren:t}=this,r=this.persistableData;return(t||e)&&(r[this.constructor.childrenField]=(t||e).map(n=>n.toJSON())),r}toString(){const e=this,t=xk.find(n=>n in e.constructor.fieldMap),r=t?{[e.constructor.idField]:e.id,[t]:e[t]}:e.data;return k.safeJsonStringify(r)}get isBatchUpdating(){return!!this.batching}hasBatchedChange(e){var t,r;return(r=(t=this.meta)==null?void 0:t.batchChanges)==null?void 0:r[e]}beginBatch(e=!1){const t=this;t.batching||(t.batching=0,t.meta.batchChanges={}),e&&(t.$silenceBatch=(t.$silenceBatch||0)+1),t.batching++}endBatch(e=!1,t=!1,r=!0){const n=this,{parentIdField:s}=n.constructor;if(n.batching&&(n.batching--,n.$silenceBatch&&n.$silenceBatch--,!(n.batching>0)&&!T.isEmpty(n.meta.batchChanges))){let{batchChanges:a}=n.meta;n.meta.batchChanges=null,a[s]&&(a={...a},n.parentId=a[s],delete a[s]),n.set(a,Ws,e,!1,t,void 0,r)}}cancelBatch(){var e;if(this.batching){const t=this,{batchChanges:r}=t.meta,n={};if(t.batching=null,t.meta.batchChanges=null,t.generation++,!t.$silenceBatch){Object.entries(r).forEach(([a,o])=>{n[a]={oldValue:o,value:t[a]}});const s={action:"update",record:t,records:[t],changes:n};(e=t.stores)==null||e.forEach(a=>a.trigger("batchedUpdate",{...s})),t.forEachLinked((a,o)=>a.trigger("batchedUpdate",{...s,record:o,records:[o]}))}t.$silenceBatch&&t.$silenceBatch--}}triggerBeforeUpdate(e){var t;return!((t=this.stores)!=null&&t.some(r=>r.trigger("beforeUpdate",{record:this,changes:e})===!1))}copy(e=null,t){const r=this,n=T.clone(r.data),s=r.constructor.idField,a=T.isObject(t)?t.deep:t;let o;if(e&&typeof e=="object"?(o=e[s],Object.assign(n,e)):o=e,a&&r.children?n.children=r.children.map(d=>d.copy(e===!1?!1:void 0,t)):(delete n.children,delete n.expanded),r.$meta.fields.initable.length>0){const d=r.toJSON();for(const c of r.$meta.fields.initable)n[c.name]=d[c.name]}e!==!1&&(n[s]=o||r.generateId(r.firstStore));const l=new r.constructor(n,null,null,!1,!0);return l.originalInternalId=r.internalId,l.copyOf=r,l}copyData(e,t,r){const n={},s=this.skipCopyFields||{};e.allFields.forEach(({name:a})=>{a!==e.constructor.idField&&!(a in s)&&(n[a]=t?e.get(a):e.getValue(a))}),this.set(n,null,r)}remove(e=!1){const t=this,{parent:r,stores:n}=t;r?r.removeChild(t,!1,e,{unfiltered:!0}):n!=null&&n.length&&!t.isSpecialRow&&n.slice().forEach(a=>a.remove(t,e,!1,!0))}beforeRemove(e,t){return super.beforeRemove(e,t)}get isValid(){return!0}get firstStore(){var e;return(e=this.stores)==null?void 0:e[0]}joinStore(e){var t,r;const n=this;(!n.stores||!n.stores.includes(e))&&(super.joinStore(e),e.register(n),n.stores?n.stores.push(e):n.stores=[e],n.unjoinedStores&&n.unjoinedStores.includes(e)&&n.unjoinedStores.splice(n.unjoinedStores.indexOf(e),1),(t=n.children)!=null&&t.length&&n.children.forEach(s=>s.joinStore(e)),n.constructor.exposedRelations&&n.initRelations(),e.tree&&!n.isRoot&&!((r=e.stm)!=null&&r.isRestoring)&&(n.instanceMeta(e.id).collapsed=!n.expanded))}unjoinStore(e,t=!1){var r,n,s;const a=this,{stores:o}=a;o!=null&&o.includes(e)&&(e.isDestroying||(e.unregister(a),a.unjoinedStores?a.unjoinedStores.push(e):a.unjoinedStores=[e]),(n=(r=a.unfilteredChildren||a.children)==null?void 0:r.forEach)==null||n.call(r,l=>l.unjoinStore(e,t)),o.splice(o.indexOf(e),1),(s=super.unjoinStore)==null||s.call(this,e,t),e.uncacheRelatedRecord(a),a.meta.map&&!e.stm&&delete a.meta.map[e.id])}isPartOfStore(e){var t;return e?e.includes(this):((t=this.stores)==null?void 0:t.length)>0}get isRemoved(){return!this.isPartOfStore()}isEditable(e){const t=this.getFieldDefinition(e);return t!=null&&t.calculated?!1:this.readOnly?e==="readOnly":t?!0:void 0}instanceMeta(e){var t;const{meta:r}=this,n=e.id||e;return((t=r.map)==null?void 0:t[n])||this.setInstanceMeta(n,{})}setInstanceMeta(e,t){const{meta:r}=this,n=e.id||e;return r.map||(r.map={}),r.map[n]=t}get isGroupHeader(){return"groupRowFor"in this.meta}get isGroupFooter(){return"groupFooterFor"in this.meta}get isSpecialRow(){var e;return!!((e=this.meta)!=null&&e.specialRow)}get $original(){return this.isLinked?this.proxyMeta.originalRecord:this}static get nonPersistableFields(){const e=this;return e._nonPersistableFields||(e._nonPersistableFields={},e.allFields.forEach(t=>{(!t.persist||t.calculated)&&(e._nonPersistableFields[t.name]=1)})),e._nonPersistableFields}static get alwaysWriteFields(){const e=this;return e._alwaysWriteFields||(e._alwaysWriteFields=e.allFields.filter(t=>t.alwaysWrite)),e._alwaysWriteFields}get domId(){return typeof this.id=="string"?this.id.replace(/[ .]/g,"-"):this.id}static toJavaScriptValue(e){const{names:t}=this.$meta,r=t[t.length-2],n=t[t.length-3];return`class ${r} extends ${n} { static fields = ${k.toJavaScriptValue(this.fields,e)}; }`}getCurrentConfig(e){const{data:t,children:r}=this,{defaultValues:n,applyConfigs:s}=this.constructor,a=s?super.getCurrentConfig(e):{};if(a){for(const o of this.fields)if(o.persist){const l=T.getPath(t,o.dataSource);l!=null&&!o.isEqual(l,n[o.name])&&T.setPath(a,o.dataSource,O.processConfigValue(l,e))}if(r)if(Array.isArray(r)){a.children=[];for(const o of r)a.children.push(o.getCurrentConfig(e))}else a.children=r;this.hasGeneratedId&&delete a.id,delete a.parentId,delete a.parentIndex}return a}};p(Ky,"$name","Model"),p(Ky,"relations",null);var me=Ky;me._idField="id",me._internalIdCounter=1,me._assignedIdField=!1,me.exposeProperties(),me._$name="Model";var or=class{static preWalk(i,e,t){const r=[i];let n,s;for(;r.length;)n=r.pop(),t(n),s=e(n),s&&r.push.apply(r,s.slice().reverse())}static walkWhile(i,e,t){const r=Array.isArray(i)?i.slice():[i];let n,s;for(;r.length;){if(n=r.pop(),!t(n))return!1;if(s=e(n),Array.isArray(s))for(let a=0;a<s.length;a++)r.push(s[a])}return!0}static preWalkWithParent(i,e,t){const r=[{node:i,parent:null}];for(;r.length;){const{parent:n,node:s}=r.pop();t(n,s);const a=e(s);if(Array.isArray(a))for(let o=a.length-1;o>=0;o--)r.push({node:a[o],parent:s})}}static preWalkUnordered(i,e,t){const r=[i];let n,s;for(;r.length;)n=r.pop(),t(n),s=e(n),s&&r.push.apply(r,s)}static postWalk(i,e,t){const r=new Map,n=[i];let s,a;for(;n.length;)if(s=n[n.length-1],r.has(s))t(s),n.pop();else{if(a=e(s),a)for(let o=a.length-1;o>=0;o--)n.push(a[o]);r.set(s,s)}}static prePostWalk(i,e,t,r){const n=new Map,s=[i];let a,o;for(;s.length;)if(a=s[s.length-1],n.has(a))r(a),s.pop();else{if(t(a),o=e(a),o)for(let l=o.length-1;l>=0;l--)s.push(o[l]);n.set(a,a)}}};or._$name="WalkHelper";var z0=Object.hasOwn||((i,e)=>Object.prototype.hasOwnProperty.call(i,e)),Xy=null;function Tk(i,e){return Object.defineProperty(i,"parser",{value:e}),e}var Mk=class{constructor(i){this.formatter=i}format(i){return this.formatter.defaultFormat(i)}parse(i,e){return this.formatter.defaultParse(i,e)}resolvedOptions(){return null}},wu=class{static get(i){if(i==null)return this.NULL;if(i instanceof this)return i;const e=typeof i=="string"?i:JSON.stringify(i),t=this.cache;let r=t.get(e);return r||(Xy=e,r=new this(i),t.set(e,r)),r}static get cache(){return z0(this,"_cache")&&this._cache||(this._cache=new Map)}static get NULL(){return z0(this,"_null")?this._null:this._null=new this(null)}constructor(i){const e=this,{standardOptions:t}=e.constructor;if(e.cacheKey=Xy,Xy=null,e.initialize(),i===null)e.formatter=new Mk(e);else{e.configure(i);for(const[r,n]of Object.entries(e.resolvedOptions()))n!=null&&t.includes(r)&&(e[r]=n)}}get parser(){return Tk(this,new this.constructor.Parser(this))}defaultFormat(i){return i==null?i:String(i)}defaultParse(i){return i}format(i){return i==null?i:this.formatter.format(i)}parse(i,e){return i==null?i:this.parser.parse(i,e)}parseStrict(i){return this.parse(i,!0)}resolvedOptions(){return this.formatter.resolvedOptions()}};p(wu,"standardOptions",Object.freeze([])),wu._$name="Formatter";var Yg=k.escapeRegExp,N0=/[\d+-]/g,Kg=(i,e)=>new Intl.NumberFormat(i||void 0,e),Ik=/^(?:([$])\s*)?(?:(\d+)>)?\d+(,\d+)?(?:\.((\d*)(?:#*)|[*]))?(?:\s*([%])?)?$/,_k="\u2212",Fk=class{constructor(i){const e=this,t=i.locale,r=Kg(t,{maximumFractionDigits:3}),n=i.is.currency?e._decodeStyle(t,{style:"currency",currency:i.currency,currencyDisplay:i.currencyDisplay}):null,s=i.is.percent?e._decodeStyle(t,{style:"percent"}):null,a=r.format(1.2).replace(N0,"")[0],o=r.format(1e9).replace(N0,"")[0]||"";Object.assign(e,{currency:n,decimal:a,formatter:i,grouper:o,percent:s}),e.decimal=a,e.decimalRe=Yg(a,"g"),e.grouper=o,e.stripRe=new RegExp(`(?:\\s+|${Yg(o)})`+(n?`|(?:${Yg(n.text)})`:"")+(s?`|(?:${Yg(s.text)})`:""),"g")}decimalPlaces(i){i=i.replace(this.stripRe,"");const e=i.indexOf(this.decimal)+1;return e&&i.length-e}parse(i,e){return typeof i=="string"&&(i=i.replace(this.stripRe,"").replace(this.decimalRe,".").replace(_k,"-"),i=e?Number(i):parseFloat(i),this.formatter.is.percent&&(i/=100)),i}_decodeStyle(i,e){const t=Kg(i,e),r=Kg(i,Object.assign(t.resolvedOptions(),{style:"decimal"})),n=t.format(0),s=r.format(0);return{suffix:n.startsWith(s),text:n.replace(s,"").trim()}}},Du=class MD extends wu{constructor(){super(...arguments),p(this,"decimalSeparator"),p(this,"groupSeparator")}initialize(){this._as={},this.is={decimal:!1,currency:!1,percent:!1,null:!0,from:null}}get truncator(){const e=this.maximumFractionDigits+(this.is.percent?2:1),t=Math.min(20,e);return this.as({style:"decimal",maximumFractionDigits:t,minimumFractionDigits:t},"truncator")}configure(e){var t,r;const{decimalSeparator:n,groupSeparator:s}=MD;Object.assign(this,{...n?{decimalSeparator:n}:{},...s?{groupSeparator:s}:{}}),typeof e!="string"?Object.assign(this,e):this.template=e;const a=this,o={},l=a.locale?ke.locales[a.locale]||Object.values(ke.locales).find(h=>h.localeCode===a.locale):ke.locale,d=l==null?void 0:l.NumberFormat,{template:c}=a,{standardOptions:u}=a.constructor;if(d)for(const h in d)a[h]==null&&typeof d[h]!="function"&&(a[h]=d[h]);if(c){const h=Ik.exec(c),f=h[2],g=h[4];a.useGrouping=!!h[3],a.style=h[1]?"currency":h[6]?"percent":"decimal",f&&(a.integer=+f),g==="*"?a.fraction=[0,20]:g!=null&&(a.fraction=[h[5].length,g.length])}a._minMax("fraction",!0,!0),a._minMax("integer",!0,!1),a._minMax("significant",!1,!0);for(const h of u)a[h]!=null&&(o[h]=a[h]);if(a.is.from=a.from&&a.from.is,a.is[a.style]=!(a.is.null=!1),a.formatter=Kg(a.locale,o),a.decimalSeparator||a.groupSeparator){const{groupSeparator:h,decimalSeparator:f}=a.getLocaleSeparators();a.separatorRegex=new RegExp(`[${h}${f}]`,"g"),a.separatorReplace={[h]:(t=a.groupSeparator)!=null?t:h,[f]:(r=a.decimalSeparator)!=null?r:f}}}as(e,t=null){const r=this.resolvedOptions()||{template:"9.*"},n=this._as;let s=t&&n[t];return s||(typeof e=="string"?r.style=e:Object.assign(r,e),r.from=this,s=new MD(r)),t&&(n[t]=s),s}defaultParse(e,t){return e==null?e:t?Number(e):parseFloat(e)}getLocaleSeparators(){const e=this.formatter.formatToParts(123456789e-2);let t=".",r=",";for(const n of e)n.type==="decimal"&&(t=n.value),n.type==="group"&&(r=n.value);return{decimalSeparator:t,groupSeparator:r}}format(e){const t=this,{separatorRegex:r,separatorReplace:n}=t;if(typeof e=="string"){const s=Number(e);e=isNaN(s)?t.parse(e):s}return e=super.format(e),r&&(e=String(e).replace(r,s=>n[s])),e}round(e){return this.parse(this.format(e))}truncate(e){const t=this,r=t.maximumFractionDigits+(t.is.percent?2:0),{truncator:n}=t;let s=t.parse(e),a;return n&&(s=n.format(s),a=s.indexOf(n.parser.decimal),a>-1&&s.length-a-1>r&&(s=s.slice(0,a+r+1)),s=n.parse(s)),s}resolvedOptions(){const e=super.resolvedOptions();for(const t in e)e[t]===void 0&&(e[t]=this[t]);return e}_minMax(e,t,r){const n=this,s=n[e];if(s!=null){const a=k.capitalize(e),o=`maximum${a}Digits`,l=`minimum${a}Digits`;typeof s=="number"?(t&&(n[l]=s),r&&(n[o]=s)):(n[l]=s[0],n[o]=s[1])}}};p(Du,"$name","NumberFormat"),p(Du,"decimalSeparator"),p(Du,"groupSeparator"),p(Du,"standardOptions",["currency","currencyDisplay","locale","maximumFractionDigits","minimumFractionDigits","minimumIntegerDigits","maximumSignificantDigits","minimumSignificantDigits","style","useGrouping"]);var Oi=Du;Oi.Parser=Fk,Object.assign(Oi.prototype,{currency:null,currencyDisplay:"symbol",fraction:null,from:null,integer:null,locale:null,maximumFractionDigits:null,minimumFractionDigits:null,minimumIntegerDigits:null,maximumSignificantDigits:null,minimumSignificantDigits:null,significant:null,style:"decimal",template:null,useGrouping:!0}),wu.number=(i,e)=>Oi.get(i).format(e),ke.ion({locale:()=>Oi.cache.clear()}),Oi._$name="NumberFormat";var Le=class Zc{constructor(e,t){typeof e=="number"||e===null?(this._magnitude=e,this._unit=t):(typeof e=="string"&&Object.assign(this,S.parseDuration(e)),typeof e=="object"&&(this.magnitude=e.magnitude,this.unit=e.unit))}static from(e){return e==null?null:e.isDuration?e:new Zc(e)}negate(){return new Zc(-this.magnitude,this.unit)}get magnitude(){return this._magnitude}set magnitude(e){this._magnitude=typeof e=="number"&&e}get unit(){return this._unit}set unit(e){this._unit=S.parseTimeUnit(e)}get isValid(){return this._magnitude!=null&&!!S.normalizeUnit(this._unit)}get milliseconds(){return this.isValid?Math.round(S.asMilliseconds(this._magnitude,this._unit)):0}isEqual(e){return!!e&&this._magnitude!=null&&e._magnitude!=null&&this.milliseconds===e.milliseconds}toString(e,t=10){const r=this,n=e?"getShortNameOfUnit":"getLocalizedNameOfUnit",s=e?"":" ";return r.isValid?`${Oi.get("9."+"#".repeat(t)).format(r._magnitude)}${s}${S[n](r._unit,Math.abs(r._magnitude)!==1)}`:""}toJSON(){return this.toString()}valueOf(){return this.milliseconds}add(e){return new Zc({unit:this.unit,magnitude:S.as(this.unit,this.milliseconds+new Zc({magnitude:e.magnitude,unit:e.unit||this.unit}).milliseconds)})}diff(e){return new Zc({unit:this.unit,magnitude:S.as(this.unit,this.milliseconds-e.milliseconds)})}};Le._$name="Duration";var Ak=(i,e)=>i==null?void 0:i[e],Pk=/^is(this|next|last)(week|month|year)$/i,kk=["isToday","isTomorrow","isYesterday","isThisWeek","isNextWeek","isLastWeek","isThisMonth","isNextMonth","isLastMonth","isThisYear","isNextYear","isLastYear","isYearToDate"],Zy=class xg extends O.mixin(bn){construct(e){typeof e=="function"&&(e={filterBy:e}),e.type?e.type==="date"&&e.value!=null?Array.isArray(e.value)?e.value=e.value.map(t=>t instanceof Date?t:new Date(t)):e.value=new Date(e.value):e.type==="duration"&&e.value!=null&&(Array.isArray(e.value)?e.value=e.value.map(t=>t.isDuration?t:new Le(t)):e.value=new Le(e.value)):S.isDate(e.value)||Array.isArray(e.value)&&e.value.every(S.isDate)?e.type="date":e.value instanceof Le&&(e.type="duration"),super.construct(e)}changeChildren(e){if(e){const{operator:t}=this;if(!(t==="and"||t==="or"))throw new Error(`CollectionFilter children can only be used with 'and' or 'or' operators, not '${t}'`);e=e.map(r=>r.isCollectionFilter?r:new xg(r))}return e}get id(){return this._id||(this.internal?this._id=xg.generateId(`b-internal-${this.property}-filter-`):this._id=this.property&&`${this.property}-${this.operator}`||xg.generateId("b-filter-")),this._id}set id(e){this._id=e}onChange(e){var t;const r=this;!r.isConfiguring&&((t=r.owner)!=null&&t.onFilterChanged)&&!r.owner.isConfiguring&&r.owner.onFilterChanged(r,e)}get filterBy(){return this._filterBy||this.defaultFilterBy}defaultFilterBy(e){var t;const r=this;let n;return r.children?r[r.operator](e):(e.isModel?n=e.getValue(r.property):((t=r._propertyItems)==null?void 0:t.length)>1?n=r._propertyItems.reduce(Ak,e):n=e[r.property],r[r.operator](r.convert(n)))}updateProperty(e){this._propertyItems=e.split("."),this.onChange("property")}updateValue(e){const t=this;Array.isArray(e)&&({date:1,duration:1}[t.type]||e.length>0&&typeof e[0]=="string")?t._filterValue=e.map(r=>t.convert(r)):!t.caseSensitive&&Array.isArray(e)&&e.length>0&&typeof e[0]=="string"?t._filterValue=e.map(r=>r==null?void 0:r.toLowerCase()):!t.caseSensitive&&typeof e=="string"?t._filterValue=e.toLowerCase():t._filterValue=t.convert(e),t.updateInternalFilterValue(),t.onChange("value")}get filterValue(){return this._filterValue}updateInternalFilterValue(){const e=this,{value:t}=e;Array.isArray(t)&&({date:1,duration:1}[e.type]||t.length>0&&typeof t[0]=="string")?e._filterValue=t.map(r=>e.convert(r)):!e._caseSensitive&&Array.isArray(t)&&t.length>0&&typeof t[0]=="string"?e._filterValue=t.map(r=>r==null?void 0:r.toLowerCase()):!e._caseSensitive&&typeof t=="string"?e._filterValue=t.toLowerCase():e._filterValue=e.convert(t)}updateOperator(){this.onChange("operator")}get operator(){const e=this;return e._operator?e._operator:Array.isArray(e.filterValue)?"isIncludedIn":typeof e.filterValue=="string"?"*":"="}updateCaseSensitive(){this.updateInternalFilterValue()}convert(e){var t;const r=this;return r.operator!=="sameTime"&&r.operator!=="notSameTime"&&!(typeof r.filterValue=="string"&&e instanceof Date)&&((r.operator==="sameDay"||r.operator==="notSameDay")&&(e=S.clearTime(e)),e=(t=e==null?void 0:e.valueOf())!=null?t:e),e=!r.caseSensitive&&typeof e=="string"?e.toLowerCase():e,e}filter(e){return this.filterBy(e)}startsWith(e){return String(e).startsWith(this.filterValue)}endsWith(e){return String(e).endsWith(this.filterValue)}isIncludedIn(e){return this.filterValue.length===0||this.filterValue.includes(e)}isNotIncludedIn(e){return!this.isIncludedIn(e)}includes(e){return this.filterValue.length===0||String(e).includes(this.filterValue)}doesNotInclude(e){return!this.includes(e)}sameTime(e){return e!=null&&S.isSameTime(e,this.filterValue)}notSameTime(e){return!this.sameTime(e)}sameDay(e){return e===this.filterValue}notSameDay(e){return e!==this.filterValue}"="(e){return T.isEqual(e,this.filterValue)}"!="(e){return!T.isEqual(e,this.filterValue)}">"(e){return T.isMoreThan(e,this.filterValue)}">="(e){return T.isMoreThan(e,this.filterValue)||T.isEqual(e,this.filterValue)}"<"(e){return T.isLessThan(e,this.filterValue)}"<="(e){return T.isLessThan(e,this.filterValue)||T.isEqual(e,this.filterValue)}"*"(e){return T.isPartial(e,this.filterValue)}between(e){const[t,r]=this._filterValue;return(T.isMoreThan(e,t)||T.isEqual(e,t))&&(T.isLessThan(e,r)||T.isEqual(e,r))}notBetween(e){return!this.between(e)}betweenLesser(e){const[t,r]=this._filterValue;return e>=t&&e<r}empty(e){return e==null||String(e).length===0}notEmpty(e){return!this.empty(e)}isToday(e){return this.betweenLesser(e)}isTomorrow(e){return this.betweenLesser(e)}isYesterday(e){return this.betweenLesser(e)}isThisWeek(e){return this.betweenLesser(e)}isNextWeek(e){return this.betweenLesser(e)}isLastWeek(e){return this.betweenLesser(e)}isThisMonth(e){return this.betweenLesser(e)}isNextMonth(e){return this.betweenLesser(e)}isLastMonth(e){return this.betweenLesser(e)}isThisYear(e){return this.betweenLesser(e)}isNextYear(e){return this.betweenLesser(e)}isLastYear(e){return this.betweenLesser(e)}isYearToDate(e){return this.between(e)}isTrue(e){return e===!0}isFalse(e){return e===!1}or(e){return this.children.some(t=>t.filter(e))}and(e){return this.children.every(t=>t.filter(e))}getState(){const{caseSensitive:e,disabled:t,id:r,internal:n,operator:s,property:a,type:o,value:l,columnOwned:d,filterBy:c,children:u}=this,h={caseSensitive:e,disabled:t,id:r,internal:n,operator:s,property:a,type:o,value:l,columnOwned:d,filterBy:c,children:u!=null&&u.length?u.map(f=>f.getState()):void 0};return T.cleanupProperties(h,!0),h.filterBy===this.defaultFilterBy&&delete h.filterBy,h}toJSON(){if(!this._filterBy){const{operator:e,children:t,value:r,caseSensitive:n}=this;return this.children?{operator:e,children:t}:{field:this.property,operator:e,value:r,caseSensitive:n}}}setRelativeDateValues(){this._filterValue=xg.getRelativeDateRange(this._operator).map(e=>e.valueOf())}get isNoOp(){var e;return(this.operator==="includes"||this.operator==="isIncludedIn")&&((e=this.filterValue)==null?void 0:e.length)===0}static getRelativeDateRange(e,t=new Date){let r,n,s,a,o,l,d;switch(e){case"isYearToDate":return[S.floor(t,"1 year"),t];case"isToday":return r=S.floor(t,"1 day"),[r,S.add(r,1,"day")];case"isYesterday":return r=S.floor(t,"1 day"),[S.add(r,-1,"day"),r];case"isTomorrow":return n=S.getStartOfNextDay(t),[n,S.add(n,1,"day")];case"isThisWeek":case"isNextWeek":case"isLastWeek":case"isThisMonth":case"isNextMonth":case"isLastMonth":case"isThisYear":case"isNextYear":case"isLastYear":if(s=e.toLowerCase().match(Pk),!s)throw new Error(`Unrecognized relative date expression: ${e}`);return[,l,d]=s,a=`1 ${d}`,o=S.floor(t,a),l==="next"?o=S.add(o,1,d):l==="last"&&(o=S.add(o,-1,d)),[o,S.add(o,1,d)]}}static generateFiltersFunction(e){if(!e||!e.length&&!e.count)return we.returnTrue;for(const t of e)t.type==="date"&&kk.includes(t._operator)&&t.setRelativeDateValues();return function(t){let r=!0;for(const n of e)if(n.disabled||(r=n.filter(t)),!r)break;return r}}};p(Zy,"$name","CollectionFilter"),p(Zy,"configurable",{value:null,operator:null,filterBy:null,caseSensitive:!0,id:null,type:null,internal:null,disabled:!1,property:null,children:null});var dt=Zy;dt._$name="CollectionFilter";var Qy=T.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null)),$i=class{static generateId(i="generatedId"){return i+(Qy[i]=(Qy[i]||0)+1)}static reset(i){Qy[i]=0}};$i._$name="IdHelper";var Lo=class extends O{construct(i){typeof i=="function"&&(i={sortFn:i}),super.construct(i)}get id(){return this._id||(this._id=this.property||$i.generateId("b-sorter"))}get sortFn(){return this._sortFn||this.defaultSortFn}defaultSortFn(i,e){const t=this,{convert:r,property:n,useLocaleSort:s,caseSensitive:a}=t,o=t.direction.toLowerCase()==="desc"?-1:1;if(i=i[n],e=e[n],r&&(i=r(i),e=r(e)),a||(typeof i=="string"&&(i=i.toLowerCase()),typeof e=="string"&&(e=e.toLowerCase())),s&&i!=null&&e!=null&&typeof i=="string"){if(s===!0)return i.localeCompare(e);if(typeof s=="string")return i.localeCompare(e,s);if(typeof s=="object")return i.localeCompare(e,s.locale,s)}return(i>e?1:i<e?-1:0)*o}static generateSortFunction(i,e){const t=i.isCollection?i.values:i,r=t.length;return(n,s)=>{let a,o,l;for(o=0;o<r;++o)if(l=t[o],a=l.sortFn(n,s,l.direction),a)return a;return e?e(n,s):0}}};p(Lo,"configurable",{property:null,caseSensitive:!0,direction:"ASC",sortFn:null,convert:null,id:null,useLocaleSort:null}),Lo._$name="CollectionSorter";var Lk=()=>0,Ok=(i,e)=>e-i,Jy=Symbol("filteredIndicesProperty"),Oo=Object.freeze([]),$k=Object.freeze({action:"sort",added:Oo,removed:Oo,replaced:Oo}),Bk=Object.freeze({action:"filter",added:Oo,removed:Oo,replaced:Oo}),Us={string:1,number:1};function W0(i,e,t,r){if(e.unique!==!1)e.set(t,i),r&&e.count++;else{let n=e.get(t);n||(n=new Set,e.set(t,n)),n.add(i)}}function Hk(i,e,t){e.unique!==!1?e.delete(t):e.has(t)&&(e.get(t).delete(i),e.get(t).size||e.delete(t))}function U0(i,e,t,r,n=!1){for(let s=0;s<i.length;s++){const a=i[s];if(a)for(let o=0;o<r;o++){const l=t[o],d=a[l],c=e[l];d!==void 0&&W0(a,c,d,!n&&c.onDuplicate)}}}var Bi=class ID extends O.mixin(Ie){constructor(){super(...arguments),p(this,"_sortFunction",null),p(this,"_addedValues",null)}static get configurable(){return{idProperty:"id",extraKeys:null,autoFilter:!0,sorters:{$config:["lazy"],value:[]}}}get isCollection(){return!0}construct(e){this.generation=0,this._values=[],super.construct(e)}doDestroy(){var e;super.doDestroy();const t=this;t._values.length=0,t.isFiltered&&(t._filteredValues.length=0,t.filters.destroy()),(e=t._sorters)==null||e.destroy()}clear(){const e=this,t=e._values.filter(r=>r);e.totalCount&&(e._values.length=0,e._filteredValues&&(e._filteredValues.length=0),e._indicesInvalid=!0,e.generation++,e.trigger("change",{action:"clear",removed:t}))}equals(e,t){if(e.isCollection&&(e=e.values),e.length===this.count){let{values:r}=this;return t&&(e=e.map(t),r=r.map(t)),L.delta(e,r).inBoth.length===this.count}return!1}replaceValues({values:e,filteredValues:t,silent:r=!1,isNewDataset:n=!1}){const s=this;let a,o;s.isFiltered&&!n?(!!t?e&&(a=s._values,s._values=e.slice()):(t=e.slice(),e=null),o=s._filteredValues,s._filteredValues=t.slice()):(a=s._values,s._values=e.slice(),t=null,s.isFiltered&&n&&s.autoFilter?(s._filterFunction=null,s._filteredValues=s._values.filter(s.filterFunction)):s._filteredValues&&(s._filteredValues.length=0)),s._indicesInvalid=!0,s._addedValues=void 0,s.generation++,r||s.trigger("change",{action:"replaceValues",replacedValues:a,replacedFilteredValues:o,values:e,filteredValues:t})}set values(e){this.invalidateIndices(),this.splice(0,this._values.length,e)}get values(){return this.isFiltered?this._filteredValues:this._values}get filteredValues(){return this._filteredValues}[Symbol.iterator](){return this.values[Symbol.iterator]()}forEach(e,t=!1){(this.isFiltered&&!t?this._filteredValues:this._values).forEach(e)}map(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).map(e)}reduce(e,t=!1,r=[]){return(this.isFiltered&&!t?this._filteredValues:this._values).reduce(e,r)}find(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).find(e)}get first(){return this.values[0]}get last(){return this.values[this.count-1]}get allValues(){return this._values}get addedValues(){return this._addedValues}match(e,t=!0){const r=this,{_values:n}=r,s=[];return r.forEach(a=>{const o=e.get(a.id,!0);if(o){const l=r.indexOf(a,!0),d=n[l];n[l]=o,r.removeFromIndices(d),r.addToIndices(o)}else t&&s.push(a)}),s.length&&r.remove(s),r.isFiltered&&(r._filteredValues=r._values.filter(r.filterFunction)),s}add(...e){e.length===1?this.splice(this._values.length,null,...e):this.splice(this._values.length,null,e)}remove(...e){e.length===1?this.splice(0,...e):this.splice(0,e)}move(e,t){for(e=L.asArray(e);e.length&&e[0]===t;)e.shift();if(!e.length)return;const r=this,{_values:n}=r,s=r.indexOf(e[0],!0);if(e.length===1&&n[s+1]===t)return;r.suspendEvents(),r.remove(e),r.resumeEvents();const a=t?r.indexOf(t,!0):n.length;if(a===-1)throw new Error("Collection move beforeItem parameter must be present in Collection");return n.splice(a,0,...e),r._indicesInvalid=1,r.trigger("change",{action:"move",items:e,from:s,to:a}),a}splice(e=0,t,...r){const n=this,s=n.idProperty,a=n._values,o={},l=[],d=n.totalCount;let c,u=[],h;if((r==null?void 0:r.length)===1&&Array.isArray(r[0])&&(r=r[0]),n.trigger("beforeSplice",{index:e,toRemove:t,toAdd:r})!==!1){if(r)if(d&&r.length){const f=n.indices[s];c=[];for(let g=0;g<r.length;g++){const m=r[g],v=m[s],y=f.get(v),b=y?a.indexOf(y):-1;o[v]=!0,b!==-1?a[b]!==m&&(l.push([a[b],m]),a[b]=m):c.push(m)}}else c=r;if(t){if(typeof t=="number")if(t=Math.min(t,a.length-e),!(r!=null&&r.length))u=a.slice(e,e+t),a.splice(e,t),h=!0;else for(let f=e;t;--t){const g=a[f][s];o[g]?(e++,f++):(u.push(a[f]),a.splice(f,1),h=!0)}else{let f=c.length===0,g;t=L.asArray(t);const m=t.reduce((v,y)=>{const b=typeof y=="number",C=b?y:n.indexOf(y,!0);return f&&(g!=null&&C!==g+1||b)&&(f=!1),C>=0&&C<d&&v.push(C),g=C,v},[]).sort(Ok);if(f)m.length&&(u.push.apply(u,t),a.splice(m[m.length-1],m.length),h=!0);else for(let v=0;v<m.length;v++){const y=m[v];if(y!==-1){const b=a[y][s];o[b]||(u.unshift(a[y]),a.splice(y,1),h=!0)}}}u.length&&!n._indicesInvalid&&u.forEach(n.removeFromIndices,n)}if(c.length){L.chunkedInsert(a,Math.min(e,a.length),c),h=!0,n._indicesInvalid||c.forEach(n.addToIndices,n),n._addedValues||(n._addedValues=new Set);for(const f of c)n._addedValues.add(f)}if(u.length&&n._addedValues)for(const f of u)n._addedValues.delete(f);l.length&&!n._indicesInvalid&&l.forEach(f=>{n.removeFromIndices(f[0]),n.addToIndices(f[1])}),h||l.length?(n.isSorted?n.onSortersChanged():n.isFiltered&&(n.autoFilter?n.onFiltersChanged({action:"splice",oldCount:1}):n._filteredValues.splice(Math.min(e,n._filteredValues.length),0,...c)),n.generation++,n.trigger("change",{action:"splice",removed:u,added:c,replaced:l,oldCount:d})):n.trigger("noChange",{index:e,toRemove:t,toAdd:r})}}changeId(e,t){const r=this,{idProperty:n}=r,s=Us[typeof e]?e:e[n],a=r.get(s);if(a){const o=r.get(t);if(o&&a!==o)throw new Error(`Attempt to set item ${s} to already existing member's id ${t}`);r.removeIndexEntry(e,n,s),r.addIndexEntry(e,n,t),a[n]=t}}get(e,t=!1){return this.getBy(this.idProperty,e,t)}getAt(e,t=!1){return this.isFiltered&&!t?this._filteredValues[e]:this._values[e]}getBy(e,t,r=!1){return this.findItem(e,t,this.isFiltered&&r)}get count(){return this.values.length}get totalCount(){return this._values.length}updateIdProperty(e){this.addIndex({property:e,unique:!0})}changeSorters(e){return new ID({values:L.asArray(e),internalListeners:{change:"onSortersChanged",thisObj:this}})}addSorter(e){const t=e instanceof Lo?e:new Lo(e);return this.sorters.add(t),t}get isSorted(){var e;return!!((e=this._sorters)!=null&&e.count)}onSortersChanged(){const e=this;e._sortFunction=null,e._addedValues=null,e._values.sort(e.sortFunction),e.trigger("change",$k)}get sortFunction(){return this._sortFunction||(this.isSorted?this._sortFunction=Lo.generateSortFunction(this.sorters.values):this._sortFunction=Lk),this._sortFunction}get filters(){return this._filters||(this._filters=new ID({internalListeners:{change:"onFiltersChanged",thisObj:this}})),this._filters}addFilter(e){const t=e instanceof dt?e:new dt(e);return this.filters.add(t),t}removeFilter(e){const{filters:t}=this;e.isCollectionFilter||(e=t.get(e)),t.remove(e)}clearFilters(){this.filters.clear()}get isFiltered(){return!!(this._filters&&this._filters.count)}onFiltersChanged({action:e,removed:t,oldCount:r}){const n=this,s=r||e==="clear"&&t.length?n._filteredValues:n._values;n._filterFunction=null,n._filteredValues=n._values.filter(n.filterFunction),n._indicesInvalid=!0;const{toAdd:a,toRemove:o}=L.delta(n._filteredValues,s,!0);n.trigger("change",{...Bk,added:a,removed:o})}get filterFunction(){return this._filterFunction||(this.isFiltered?this._filterFunction=dt.generateFiltersFunction(this.filters.values):this._filterFunction=we.returnTrue),this._filterFunction}changeExtraKeys(e){return L.asArray(e).map(r=>typeof r=="string"?{property:r,unique:!0}:r)}updateExtraKeys(e){for(let t=0;t<e.length;t++)this.addIndex(e[t])}addIndex(e){const t=this;e&&((t._indices||(t._indices={}))[e.property]=new Map,Object.assign(t._indices[e.property],e),t.invalidateIndices(),e.dependentOn&&(t.hasCompositeIndex=!0))}findIndex(e,t,r=!1){const n=this.findItem(e,t,r);return n?(this.isFiltered&&!r?this._filteredValues:this._values).indexOf(n):-1}findItem(e,t,r=!1){var n;const s=this,{isFiltered:a}=s,o=a&&!r?s.indices[Jy][e]:s.indices[e];if(o){const l=(n=o.get(t))!=null?n:typeof t=="string"&&t.length&&!isNaN(t)&&o.get(Number(t))||null;if(l!=null)return l}else{const l=a&&!r?s._filteredValues:s._values,d=l.length;for(let c=0;c<d;c++){const u=l[c];if(u[e]==t)return u}}return null}removeIndex(e){delete this._indices[e],this.hasCompositeIndex=Object.values(this.indices).some(t=>t.dependentOn)}indexOf(e,t=!1){return this.findIndex(this.idProperty,Us[typeof e]?e:e[this.idProperty],t)}includes(e,t=!1){return Array.isArray(e)?e.some(r=>this.includes(r)):!!this.findItem(this.idProperty,Us[typeof e]?e:e[this.idProperty],t)}get indices(){return this._indicesInvalid&&this.rebuildIndices(),this._indices}invalidateIndices(){this._indicesInvalid=!0}rebuildIndices(){const e=this,t=e.isFiltered,r=e._indices||(e._indices={}),n=Object.keys(r),s=n.length,a=e._values;let o=!1,l;t&&(l=r[Jy]={});for(let d=0;d<s;d++){const c=r[n[d]];if(c.clear(),c.onDuplicate&&(c.count=0,o=!0),t){let u=l[n[d]];u?u.clear():(u=l[n[d]]=new Map,u.unique=c.unique)}}if(U0(a,r,n,s),o)for(let d=0;d<s;d++){const c=r[n[d]];if(c.onDuplicate&&c.count>c.size){const u=new Set;for(let h=0;h<a.length;h++){const f=a[h],g=f[n[d]];u.has(g)&&c.onDuplicate(f,g,c),u.add(g)}}}t&&U0(e._filteredValues,l,n,s,!0),e._indicesInvalid=!1}getIndices(e){const t=[this.indices[e]];return this.isFiltered&&t.push(this.indices[Jy][e]),t}addToIndices(e){Object.keys(this.indices).forEach(t=>{this.addIndexEntry(e,t,e[t])})}removeFromIndices(e){Object.keys(this.indices).forEach(t=>{this.removeIndexEntry(e,t,e[t])})}removeIndexEntry(e,t,r){this.getIndices(t).forEach(n=>Hk(e,n,r))}addIndexEntry(e,t,r){this.getIndices(t).forEach(n=>W0(e,n,r))}onItemMutation(e,t){const r=this;!r._indicesInvalid&&Object.keys(r.indices).length>1&&Object.keys(t).forEach(n=>{var s;if(r.indices[n]){const{value:o,oldValue:l}=t[n];r.removeIndexEntry(e,n,l),r.addIndexEntry(e,n,o)}if(r.hasCompositeIndex){const o=Object.values(r.indices).find(l=>{var d;return(d=l.dependentOn)==null?void 0:d[n]});if(o){const l={};for(const c in o.dependentOn)l[c]=((s=t[c])==null?void 0:s.oldValue)||e[c];const d=e.buildIndexKey(l);r.removeIndexEntry(e,o.property,d),r.addIndexEntry(e,o.property,e[o.property])}}})}};Bi._$name="Collection";var G0=new WeakMap,Eu=i=>{if(i&&typeof i=="object"){let e=G0.get(i);e===void 0&&(e=Symbol("bscik"),G0.set(i,e)),i=e}return i},xu=class{constructor(i){const e=this;e.generation=0,e.items=new Set,e.idMap={},e.idProperty="id",i&&(i.idProperty&&(e.idProperty=i.idProperty),i.values&&(e.values=i.values))}get(i){return this.idMap[Eu(i)]}get count(){return this.items.size}add(...i){i.length===1&&Array.isArray(i[0])&&(i=i[0]);const e=this,{items:t,idMap:r,idProperty:n}=e,s=i.length;for(let a=0;a<s;a++){const o=i[a],l=Us[typeof o]?o:Eu(o[n]),d=r[l];d==null?(r[l]=o,t.add(o),e.generation++):d!==o&&(r[l]=o,t.delete(d),t.add(o))}}at(i){let e,t;i<0&&(i+=this.count);for(e of this.items)if(!i--){t=e;break}return t}remove(i){i=L.asArray(i);const{items:e,idMap:t,idProperty:r}=this,n=i.length;for(let s=0;s<n;s++){const a=i[s],o=Us[typeof a]?a:Eu(a[r]),l=t[o];l!=null&&(e.delete(l),delete t[o],this.generation++)}}clear(){this.items.clear(),this.idMap={},this.generation++}countOf(i){let e=0,t;for(t of this.items)i(t)&&++e;return e}changeId(i,e){const t=this,{idMap:r,idProperty:n}=t,s=Us[typeof i]?i:Eu(i[n]),a=t.get(s);if(a){const o=t.get(e);if(o&&a!==o)throw new Error(`Attempt to set item ${s} to already existing member's id ${e}`);a[n]=e,delete r[s],r[e]=a}}filter(i,e){const{items:t}=this,r=[];let n=0;return t.forEach(s=>{i.call(e,s,n++,t)&&r.push(s)}),r}includes(i){const e=Us[typeof i]?i:Eu(i[this.idProperty]);return!!this.idMap[e]}map(i,e){const{items:t}=this,r=new Array(t.size);let n=0;return t.forEach(s=>{r[n]=i.call(e,s,n++,t)}),r}forEach(i,e){return this.items.forEach(i,e)}find(i,e=0){let t,r;e<0&&(e+=this.countOf(i));for(t of this.items)if(i(t)&&!e--){r=t;break}return r}[Symbol.iterator](){return this.items[Symbol.iterator]()}indexOf(i,e){let t=-1,r;for(r of this.items)if((!e||e(r))&&(++t,r===i))return t;return-1}get values(){return[...this.items]}set values(i){i=L.asArray(i),this.clear(),this.add.apply(this,i),this.generation++}get first(){for(const i of this.items)return i;return null}get last(){let i=null;for(const e of this.items)i=e;return i}sort(i){this.values=this.values.sort(i)}some(i,e){return this.values.some(i,e)}};xu._$name="Bag";var Xg=class extends xu{add(...i){return i.length===1&&Array.isArray(i[0])&&(i=i[0]),super.add(...i.filter(e=>e.isPersistable))}};Xg._$name="StoreBag";var Vk=(i,e)=>{const t=i.meta.modified,r=e.meta.modified;return"parentId"in t&&"parentId"in r&&t.parentId===r.parentId?t.parentIndex-r.parentIndex:0},q0=i=>{var e;return e=class extends(i||O){static get properties(){return{isRemoving:!1,suspendCount:0}}remove(t,r=!1){const n=this,{storage:s}=n;if(t=L.asArray(t).reduce((a,o)=>(o=n.getById(o),o&&a.push(o),a),[]),t.length===0)return t;if(!n.tree&&!r&&n.trigger("beforeRemove",{records:t})===!1)return[];if(n.isRemoving=!0,n.isGrouped){const a=s.count,o=[],l=new Set;for(const d of t){const{groupParent:c}=d.instanceMeta(n);c.meta.collapsed&&o.push(d),L.remove(c.groupChildren,d),L.remove(c.unfilteredGroupChildren,d),c.meta.childCount--,l.add(c)}for(const d of l)d.groupChildren.length>0&&n.onModelChange(d,{},{});o.length&&s.trigger("change",{action:"splice",removed:o,added:[],replaced:[],oldCount:a})}else if(n.tree){const a=[],o=new Set,l=t.length>1,d=t[0],c=l?void 0:s.indexOf(d),u=t.reduce((f,g)=>{const{parent:m}=g;return m&&(f[m.id]||(f[m.id]=[m,[]]),f[m.id][1].push(g)),f},{}),h=Array.from(Object.values(u));if(!r&&n.trigger("beforeRemove",{records:t,isMove:!1,parent:l?void 0:d.parent})===!1)return n.isRemoving=!1,[];n.suspendAutoCommit(),h.sort((f,g)=>g[0].childLevel-f[0].childLevel);for(const[f,g]of h){const m=f.removeChild(g,!1,!0,{skipIndexUpdate:!0});L.chunkedPush(a,m),o.add(f)}for(const f of o)a.includes(f)||(f.updateChildrenIndices(f.children,"parentIndex"),f.unfilteredChildren&&f.updateChildrenIndices(f.unfilteredChildren,"unfilteredIndex"),f.orderedChildren&&f.updateChildrenIndices(f.orderedChildren,"orderedParentIndex"));return r||(n.trigger("remove",{parent:l?void 0:d.parent,index:c,isChild:!0,allRecords:a,isMove:!1,records:t}),n.trigger("change",{action:"remove",records:t})),n.resumeAutoCommit(),n.isRemoving=!1,t}if(t.length===0)return n.isRemoving=!1,t;for(const a of t)a.beforeRemove(t);return r&&n.suspendEvents(),s.remove(t),r&&n.resumeEvents(),n.autoCommit&&n.doAutoCommit(),n.isRemoving=!1,t}clear(t=!1){var r,n;const s=this,{storage:a}=s;if(s.storage.totalCount||(n=(r=s.rootNode)==null?void 0:r.unfilteredChildren)!=null&&n.length){if(!t&&s.trigger("beforeRemove",{records:a.allValues,removingAll:!0})===!1)return null;if(s.rootNode)if(s.isChained&&!s.isChainedTree){const o=s.getAllDataRecords();for(let l=o.length-1,d;l>=0;l--)d=o[l],d&&!d.isDestroyed&&d.unjoinStore(s)}else s.rootNode.clearChildren(t);else if(t){const o=s.registeredRecords;for(let l=o.length-1,d;l>=0;l--)d=o[l],d&&!d.isDestroyed&&d.unjoinStore(s)}t&&(s.removed.clear(),a.suspendEvents()),a.clear(),t&&a.resumeEvents(),s.added.clear(),s.modified.clear()}}removeAll(t=!1){const r=this,n=r.storage;let s;if(r.isRemoving=!0,t){n.suspendEvents();const a=r.registeredRecords;for(let o=a.length-1,l;o>=0;o--)l=a[o],l&&!l.isDestroyed&&!l.isRoot&&l.unjoinStore(r)}return r.tree?s=r.rootNode.clear()!==!1:s=r.clear()!==null,t&&n.resumeEvents(),r.isRemoving=!1,s}add(t,r=!1,n={}){const s=this,{storage:a}=s;if(t=L.asArray(t),!(t!=null&&t.length))return;if(s.tree=s.tree||!!(s.autoTree&&t[0].children),s.tree){const l=new Map,d=s.modelClass.getFieldDataSource("parentIndex"),c=s.modelClass.getFieldDataSource("orderedParentIndex"),{parentIdField:u}=s.modelClass,h=[];let f;return t.forEach(g=>{f=f||(!(d in g)&&c in g?c:d);const m=g[u];l.has(m)||l.set(m,{append:[],insert:[]});const v=l.get(m);!g.isModel&&f in g?v.insert.push(g):v.append.push(g)}),l.forEach(({append:g,insert:m},v)=>{const y=v==null?s.rootNode:s.getById(v);if(!y)throw new Error(`Parent node with id ${v} not found, cannot add children.`);if(g.length){const b=y.appendChild(g,r,n);L.chunkedPush(h,b)}if(m.length)for(const b of m)"orderedParentIndex"in b&&("orderedParentIndex"in n&&T.isObject(n.orderedParentIndex)?n.orderedParentIndex.index=b.orderedParentIndex:n.orderedParentIndex=b.orderedParentIndex),h.push(y.insertChild(b,b[f],r,n))}),s.isFiltered&&s.reapplyFilterOnAdd&&s.filter({silent:!0}),s.reapplySortersOnAdd&&!s.isSyncingDataOnLoad&&s.sort(),h}if(!r&&s.trigger("beforeAdd",{records:t})===!1)return null;if(s.tree=s.tree||!!(s.autoTree&&t[0].children),s.tree)return s.rootNode.appendChild(t);const o=s.processRecords(t);return r&&s.suspendEvents(),s.addingClean=n.clean,a.add(o),s.addingClean=!1,r&&s.resumeEvents(),s.autoCommit&&s.doAutoCommit(),o}cloneImmutable(t){return this.useRawData.enabled&&!t[0].isModel&&!Object.isExtensible(t[0])&&(t=T.clone(t)),t}processRecords(t,r){return this.cloneImmutable(t).map(n=>{const s=this.processRecord(n.isModel?n:this.createRecord(n));return r==null||r.call(this,s),s})}insert(t,r,n=!1){var s;const a=this,o=a.storage,l=o.getAt(t),d=o.values,c=[];if(r=L.asArray(r),a.tree){const m=a.rootNode;return m.insertChild(r,(s=m.children)==null?void 0:s[t],n)}if(!n&&a.trigger("beforeAdd",{records:r})===!1)return null;let u,h,f;if(d[h=t]===r[0]||d[h=t-1]===r[0])for(u=!0,f=0;u&&f<r.length;f++)r[f]!==d[h+f]&&(u=!1);if(u)return null;const g=a.processRecords(r,m=>{const v=o.indexOf(m);m.children&&m.children.length&&a.autoTree&&(a.tree=!0),v>-1&&(v<t&&l&&t--,c.push(v)),m.meta.previousIndex=v});return a.suspendEvents(),a.storage.remove(c),a.resumeEvents(),n&&a.suspendEvents(),o.splice(t,0,g),n&&a.resumeEvents(),a.autoCommit&&a.doAutoCommit(),g}move(t,r){const n=this;n.isTree?r.parent.insertChild(t,r):(n.storage.move(t,r),n.isChained&&n.syncOrder&&n.$master.storage.move(t,r))}acceptChanges(){const t=this;t.added.forEach(r=>r.internalClearChanges(!0,!1)),t.modified.forEach(r=>r.internalClearChanges(!0,!1)),t.added.clear(),t.modified.clear(),t.removed.clear()}commit(t=!1){const{changes:r}=this;return!t&&this.trigger("beforeCommit",{changes:r})===!1?!1:(this.acceptChanges(),t||this.trigger("commit",{changes:r}),r)}revertChanges(){const t=this,{changes:r}=t;if(r){const n={action:"clearchanges",changes:r},s=t.modified.values;t.add(t.removed.values,!0),t.remove(t.added.values,!0),s.sort(Vk),s.forEach(a=>a.revertChanges(!0)),t.added.clear(),t.modified.clear(),t.removed.clear(),t.trigger("change",n),t.trigger("refresh",n)}}get changes(){const t=this,r=t.modified.values.filter(n=>n.rawModifications);return t.added.count||r.length||t.removed.count?{added:t.added.values.slice(),modified:r,removed:t.removed.values.slice()}:null}get hasChanges(){return!!(this.added.count||this.removed.count||this.modified.values.some(t=>t.rawModifications))}updateAutoCommit(t){t&&this.hasChanges&&this.commit()}suspendAutoCommit(){this.suspendCount++}resumeAutoCommit(t=!0){this.suspendCount--,this.autoCommit&&t&&this.doAutoCommit()}doAutoCommit(){this.suspendCount<=0&&this.commit()}},p(e,"$name","StoreCRUD"),p(e,"configurable",{autoCommit:!1}),e},Y0=i=>{var e;return e=class extends(i||O){static get configurable(){return{applyChangesetFilterSortTarget:"changes"}}applyChangesFromStore(t){const r=this,{changes:n}=t;n&&(n.added&&r.add(n.added),n.removed&&r.remove(n.removed.map(s=>s.id)),n.modified&&n.modified.forEach(s=>{const a=r.getById(s.id);a==null||a.set(s.modifications)}))}applyChangeset(t,r=null,n="$PhantomId",s=!0,a=!1){var o,l,d,c,u,h;const f=this,g=(o=r==null?void 0:r(t,f))!=null?o:t,m=g.$input||g,{added:v,updated:y,modified:b,removed:C}=m,D=(l=y!=null?y:b)!=null?l:[],w=f.modelClass.getFieldDataSource("id"),x=f.modelClass.getFieldDataSource("parentId"),R=a?new Map:null,M=f.tree,I=[],_=[],F=new Set;let A=!1,P=[];if(f.trigger("startApplyChangeset"),f._groupVisibleRecordIds=[],f.isGrouped&&f.forEach(V=>{f._groupVisibleRecordIds.push(V.id)}),(v==null?void 0:v.length)>0){const V=[],B=[];for(const G of v){const Z=f.getById(G[n])||f.getById(T.getPath(G,w));Z?(V.push(G),M&&F.add(Z.parent)):f.removed.get(G[n])||f.removed.get(T.getPath(G,w))||B.push(G)}D.unshift.apply(D,V);const W=f.reapplySortersOnAdd;f.reapplySortersOnAdd=!1;const q=(d=f.add(B,!1,{orderedParentIndex:{skip:!0},clean:s}))!=null?d:[];if(L.chunkedPush(I,q),f.reapplySortersOnAdd=W,M)for(const G of q){const{parent:Z}=G;if(Z.isRoot){A=!0,P=[Z];break}!Z.isRoot&&P.every(ne=>!ne.contains(Z))&&P.push(Z),"orderedParentIndex"in G.originalData&&F.add(Z)}for(const G of q)R==null||R.set(G.id,G.data),G.internalClearChanges();M&&F.forEach(G=>{G.updateChildrenIndices(G.orderedChildren,"orderedParentIndex",!0)})}if((D==null?void 0:D.length)>0)for(const V of D){const B=V[n],W=T.getPath(V,w),q=T.getPath(V,x),G=(c=f.removed.get(B))!=null?c:f.removed.get(W),Z=(u=G!=null?G:f.getById(B))!=null?u:f.getById(W);if(Z){const ne=q!=null?(h=f.getById(q))==null?void 0:h.isLeaf:!1;this.filterTreeHierarchyChanges(F,Z,V);const J=Z.applyChangeset(V,n);G&&w in J&&B&&f.onRecordIdChange({record:Z,oldValue:B,value:W}),ne&&f.toggleCollapse(Z.parent,!1),M&&Z.parent&&!A&&P.every(ee=>!ee.contains(Z))&&(Z.parent.isRoot?(A=!0,P=[Z.parent]):P.push(Z.parent)),R==null||R.set(W,J),_.push(Z)}}if((C==null?void 0:C.length)>0&&f.applyRemovals(C),f.applyChangesetFilterSortTarget==="changes"&&!f.remoteFilter){const V=f.filterChangeset(I,_);P.push(...V)}if(f.afterChangesetApplied(P),M&&f.isSorted&&f.reapplySortersOnAdd&&(v!=null&&v.length||D!=null&&D.length)){const V=new Set;P.forEach(B=>{V.has(B)||(V.add(B),B.sortVisibleChildren(!1,f.sorterFn),B.sortUnfilteredChildren(!1,f.sorterFn))}),f.storage.replaceValues({values:f.collectDescendants(f.rootNode).visible,silent:!0}),f.afterPerformSort(!1)}return f._groupVisibleRecordIds=null,f.trigger("endApplyChangeset"),R}afterChangesetApplied(t){const r=new Set;t.forEach(n=>{r.has(n)||n.traverse(s=>{r.has(s)||(r.add(s),s.sortOrderedChildren(!1,!1),s.children&&s.updateChildrenIndices(s.children,"parentIndex",!0),s.unfilteredChildren&&s.updateChildrenIndices(s.unfilteredChildren,"unfilteredIndex",!0))})})}applyRemovals(t){const r=this,{removed:n}=r,s=r.modelClass.idField,a=[];for(const o of t){const l=T.getPath(o,s);if(n.includes(l)){const d=n.get(l);d.internalClearChanges(!1,!0,null),d.$isPhantom=!0,n.remove(l)}else a.push(l)}r.tree&&a.reduce((l,d)=>{var c;return r.getById(d)&&l.add((c=r.getById(d).parentNode)!=null?c:r.rootNode),l},new Set).forEach(l=>l.sortOrderedChildren(!1,!1)),r.remove(a);for(const o of a)n.remove(o)}filterChangeset(t,r){const n=this,{isFiltered:s,tree:a,isGrouped:o,filtersFunction:l}=n,d=n.isSorted?n.createSorterFn(n.sorters):void 0,{allValues:c,addedValues:u,isSorted:h}=n.storage,f=d!=null||h?d!=null?d:n.storage.sortFunction:null,g=new Set;if(!s)return[];let m=!1,v;if(o&&(v=n.groupers,n.clearGroupers(!0)),a){const b=new Set(r.filter(l));for(const D of t.filter(l))b.add(D);b.forEach(D=>D.bubble(w=>b.add(w))),b.delete(n.rootNode);const C=L.groupByIndexed(Array.from(b).filter(D=>{var w,x;return!((x=(w=D.parent)==null?void 0:w.children)!=null&&x.includes(D))}),D=>D.parent);for(const[D,w]of C)D.unfilteredChildren&&(D.children.push(...w),g.add(D),n.traverseFilter(D,!1,w))}else if(f&&!o){const{filteredValues:b}=n.storage,C=u?b.findLastIndex(x=>!u.has(x))+1:b.length,D=b.slice(0,C),w=new Set(r.filter(l));for(const x of b)w.has(x)&&w.delete(x);for(const x of w)D.push(x);D.sort(f),b.splice(0,C,...D),m=!0}else{const b=r.filter(C=>l(C)&&!n.storage.includes(C));b.length>0&&(n.includeInSubset(c,n.storage.filteredValues,b),m=!0)}const y=new Set(t.filter(b=>!l(b)));if(y.size>0){if(a)for(const b of y)L.remove(b.parent.children,b),g.add(b.parent);else L.remove(n.storage.filteredValues,y);m=!0}return v&&(n.group(v[0],null,!1,!0,!0),m=!1,n._idMap=null),a&&g.size>0?n.storage.replaceValues({values:n.collectDescendants(n.rootNode).visible,silent:!0}):m&&(n._idMap=null,n.trigger("refresh")),Array.from(g)}filterTreeHierarchyChanges(t,r,n){this.tree&&t.has(r.parent)&&(delete n.orderedParentIndex,delete n.parentIndex)}includeInSubset(t,r,n){const s=new Set(n);let a=0,o=0,l=s.size===0;for(;o<t.length&&!l;){const d=r[a];let c=t[o];for(;d!==c;)s.has(c)&&(r.splice(a,0,c),a++,s.delete(c),l=s.size===0),c=t[++o];s.has(d)&&s.delete(d),a<r.length&&a++}return r}},p(e,"$name","StoreChanges"),e},K0=i=>{var e;return e=class extends(i||O){updateFilterParamName(t){this.remoteFilter=t!=null}updateReapplyFilterOnAdd(t){this.storage.autoFilter=t}get reapplyFilterOnAdd(){return this.storage.autoFilter}changeFilters(t,r){const n=this;if(r?r.clear():r=new Bi({extraKeys:["property"]}),n._filtersFunction=null,t){if(t.constructor.name==="Object")for(const s of Object.entries(t))s[0]==="filterBy"&&typeof s[1]=="function"?r.add(new dt({filterBy:s[1]})):r.add(new dt(s[1].constructor.name==="Object"?Object.assign({property:s[0]},s[1]):{property:s[0],value:s[1]}));else Array.isArray(t)?r.add(...t.map(s=>s instanceof dt?s:new dt(s))):t.isCollection?r.add(...t.values):r.add(new dt({filterBy:t}));r.forEach(s=>s.owner=n)}return r}set filtersFunction(t){this._filtersFunction=t}get filtersFunction(){const t=this,{filters:r,isGrouped:n}=t;if(!t._filtersFunction)if(r.count){const s=dt.generateFiltersFunction(r);t._filtersFunction=a=>n&&a.isSpecialRow?a.groupChildren.some(s):a.isCreating?!0:s(a)}else t._filtersFunction=we.returnTrue;return t._filtersFunction}get isFiltered(){return!this._filters&&(!this.isConfiguring||!this.initialConfig.filters)?!1:this.filters.values.some(t=>!t.disabled)}isFilteredOut(t){return this.isFiltered&&!this.filtersFunction(t)}traverseFilter(t,r=!0,n=void 0){const s=this,{filtersFunction:a}=s,o=!t.isRoot&&a(t),l=t.unfilteredChildren||t.children;return!l||!l.length?o:(t.unfilteredChildren||(t.unfilteredChildren=t.children.slice()),t.children=t.unfilteredChildren.filter(d=>r?s.traverseFilter(d,r):a(d)||(n==null?void 0:n.has(d))),s.isSorted&&t.children.sort(s.sorterFn),t.updateChildrenIndices(t.unfilteredChildren,"unfilteredIndex",!0),t.updateChildrenIndices(t.children,"parentIndex",!0),o||!!t.children.length)}traverseClearFilter(t){const r=this;t.unfilteredChildren&&(t.children=t.orderedChildren.slice(),t.unfilteredChildren=null),t.children&&(r.isSorted&&t.children.sort(r.sorterFn),t.children.forEach(n=>r.traverseClearFilter(n)),t.updateChildrenIndices(t.children,"parentIndex",!0))}get latestFilterField(){return this.filters.last?this.filters.last.property:null}addFilter(t,r=!1){const n=this;if(t=t instanceof dt?t:new dt(t),t.owner=n,n.filters.add(t),!r){if(n.remoteFilter)return n.filter().then(()=>t);n.filter()}return t}filter(t){const r=this;let n=!1,s;if(t){let o=typeof t;if(o==="object"&&("silent"in t||"replace"in t||t.filters)&&(n=t.silent,t.replace&&r.clearFilters(t.silent||t.filters.length!==0),s=t.internal,t=t.filters,o=typeof t),t){const l=r.isFiltered;if(r.isConfiguring=!0,Array.isArray(t))t.forEach(d=>r.addFilter(d,!0),r);else if(o==="function"){const d=new dt(t);d.internal=s,r.addFilter(d,!0)}else o==="string"?r.addFilter({property:t,value:arguments[1]},!0):r.addFilter(t,!0);if(r.isConfiguring=!1,!r.isFiltered&&!l)return null}}r.filtersFunction=null;const a=r.remoteFilter?r.performRemoteFilter(n):r.performFilter(n);return r._idMap=null,a}suspendFilterOnUpdate(){this.filterBatching++}resumeFilterOnUpdate(t){if(this.filterBatching--,this.filterBatching<0)throw new Error("No matching `startFilterBatching` call");this.filterBatching===0&&this.needsFiltering&&(this.needsFiltering=!1,this.performFilter(t))}performFilter(t){const r=this;if(r.filterBatching>0){r.needsFiltering=!0;return}const{storage:n,filters:s,rootNode:a}=r,o=r.count;t||r.trigger("beforeFilter",{filters:s});let l,d;if(r.tree){const c=n.values;r.isFiltered?r.traverseFilter(a):r.traverseClearFilter(a);const u=r.collectDescendants(a).visible;n.replaceValues({values:u,silent:!0});const h=L.delta(u,c,!0);l=h.toAdd,d=h.toRemove}else n.ion({change({removed:c,added:u}){d=c,l=u},once:!0}),r.isFiltered?(r.isGrouped&&r.includeCollapsed(),n.addFilter({id:"primary-filter",filterBy:r.filtersFunction}),r.isGrouped&&r.excludeCollapsed()):n.filters.clear();r.afterPerformFilter(t||r.isRemoteDataLoading?null:{action:"filter",filters:s,oldCount:o,added:l,removed:d,records:r.storage.values})}async performRemoteFilter(t){var r;const n=this,{filters:s,count:a}=n;if(await((r=n.beforePerformFilter)==null?void 0:r.call(n,{filters:s,oldCount:a}))===!1||(n.currentPage=1,await n.performDataRequest(t)===!1))return;const o=t?null:{action:"filter",filters:s,oldCount:a,records:n.storage.values};n.afterPerformFilter(o),n.trigger("refresh",o)}buildRemoteParams(t={},r=!1){var n,s;(n=super.buildRemoteParams)==null||n.call(this,t,r);const a=this,{filters:o}=a;return a.isFiltered&&(t[(s=a.filterParamName)!=null?s:"filters"]=r?a.encodeFilterParams(o):a.getFilterParams(o)),t}afterPerformFilter(t){this.resetRelationCache(),t&&this.triggerFilterEvent(t)}getFilterParams(t){return t.values.filter(r=>!r.disabled&&!r._filterBy).map(r=>r.toJSON())}triggerFilterEvent(t){this.trigger("filter",t),this.remoteFilter||(this.trigger("refresh",t),this.trigger("change",t))}filterBy(t){return this.filter(t)}removeFilter(t,r=!1){var n,s;const a=this,o=t instanceof dt?t:(n=a.filters.get(t))!=null?n:a.filters.getBy("property",t);if(o){if((s=a._filters)==null||s.remove(o),a._filtersFunction=null,!r){if(a.remoteFilter)return a.filter().then(()=>o);a.filter()}return o}}clearFilters(t=!1){if(this.filters.remove(this.filters.values.filter(r=>!r.internal)),!t)return this.filter()}convertFilterToString(t){const r=this.filters.getBy("property",t);return r&&!r.filterBy?String(r):""}doDestroy(){var t;(t=this._filters)==null||t.destroy(),super.doDestroy()}},p(e,"$name","StoreFilter"),p(e,"configurable",{remoteFilter:!1,filterParamName:null,filters:void 0,reapplyFilterOnAdd:!1,reapplyFilterOnUpdate:!1}),p(e,"properties",{filterBatching:0,needsFiltering:!1}),e},jk={add:1,replace:1},X0="!!novalue!!",zk=({_groupValue:i},{_groupValue:e})=>i<e?-1:i>e?1:0,Nk=(i,e)=>i[e<0?i.length+e:e],Z0=i=>{var e;return e=class extends(i||O){static get properties(){return{collapsedGroups:new Set}}construct(t){super.construct(t),this.ion({change:"onDataChanged",thisObj:this})}get GroupRow(){var t;return this._GroupRowClass||(this._GroupRowClass=(t=class extends this.modelClass{get isCollapsed(){return this.meta.collapsed}},p(t,"isSpecialRow",!0),p(t,"fields",[{name:"_groupValue"}]),t))}updateGroupers(t){this.setGroupers(t)}setGroupers(t,r=null){const n=this,{storage:s}=n;let a;return n._idMap=null,t!=null&&t.length?n._groupers=t.map(o=>n.createGrouper(o)):n.groupers&&(delete n._groupers,n.includeCollapsed(),s.replaceValues({values:n.removeHeadersAndFooters(s._values),filteredValues:s.isFiltered?n.removeHeadersAndFooters(s._filteredValues):null,silent:!0}),a=n.group(null,null,null,!1,r==null?void 0:r.silent)),a}createGrouper(t,r){if(!t||t.isGrouper)return t;typeof t=="string"&&(t={field:t,[typeof r=="boolean"?"ascending":void 0]:r});const{field:n}=t,s=n==null?void 0:n.indexOf("."),a=s>0,o=n==null?void 0:n.split("."),l=a?o[0]:n,d=a?Nk(o,-1):n,c=a?n.slice(s+1):n;return{isGrouper:!0,...t,complexMapping:a,rootFieldName:l,leafFieldName:d,fieldPath:c}}get unfilteredGroupRecords(){var t;const r=this;if(r.isGrouped){const{generation:n}=r.storage;((t=r._unfilteredGroupRecords)==null?void 0:t.generation)!==n&&(r._unfilteredGroupRecords=r.storage.allValues.filter(s=>s.isSpecialRow),r._unfilteredGroupRecords.generation=n)}return r._unfilteredGroupRecords||[]}getGroupHeaderForRecord(t,r=!1){if(this.isGrouped)return t?"groupRowFor"in t.meta?t:t.instanceMeta(this).groupParent:this.groupRecords.last}includeCollapsed(){for(const t of this.collapsedGroups)this.expand(this.getById(t),!1)}excludeCollapsed(){for(const t of this.collapsedGroups)this.collapse(this.getById(t))}onDataChange({source:t,action:r,removed:n}){var s;const a=this,{groupers:o}=a;o&&(o.length?(r==="splice"||r==="move")&&t.replaceValues({...a.prepareGroupRecords(),silent:!0}):t.replaceValues({values:a.removeHeadersAndFooters(t._values),filteredValues:t.isFiltered?a.removeHeadersAndFooters(t._filteredValues):null,silent:!0})),(s=super.onDataChange)==null||s.call(this,...arguments)}move(t,r){const n=this;let s;if(n.isGrouped&&!n.tree){let a=r;if(r!=null&&r.isSpecialRow&&(a=n.getPrev(r,!1,!1),!a))return;const o=n.getGroupHeaderForRecord(a),l=n.groupers[0].field,{reapplyFilterOnUpdate:d}=n,c=n.modelClass.getFieldDefinition(l).type==="array";let u=o.meta.groupRowFor;if(n.reapplyFilterOnUpdate=!1,n.beginBatch(),t.forEach(h=>{if(c){const f=h.get(l)||[];if(f.includes(u))return;{const g=h.instanceMeta(this).groupParent,m=o._groupValue;L.remove(f,g),u=f.slice(),m===X0?u=void 0:Array.isArray(m)&&m.length===0?u=[]:u.push(m),s=!0}}h.setValue(l,u)}),n.endBatch(),c&&!s)return;if(n.reapplyFilterOnUpdate=d,n.isFiltered&&(r!=null&&r.isSpecialRow)){const{unfilteredGroupRecords:h}=n,f=h.indexOf(o);r=h[f+1]}}super.move(t,r),s&&n.group(n.groupers[0])}collapse(t){let r=!1;return t&&(t=L.asArray(t),t.forEach(n=>{n&&!n.meta.collapsed&&(this.excludeGroupRecords(n),n.meta.collapsed=!0,this.collapsedGroups.add(n.id),this.trigger("toggleGroup",{groupRecord:n,collapse:!0}),r=!0)})),r}expand(t,r=!0){let n=!1;return t&&(t=L.asArray(t),t.forEach(s=>{s!=null&&s.meta.collapsed&&(this.includeGroupRecords(s),s.meta.collapsed=!1,r&&this.collapsedGroups.delete(s.id),r&&this.trigger("toggleGroup",{groupRecord:s,collapse:!1}),n=!0)})),n}removeHeadersAndFooters(t){return t.filter(r=>(r!=null&&r.unfilteredGroupChildren&&(r.groupChildren.length=r.unfilteredGroupChildren.length=r.meta.childCount=0),r!=null&&r.isSpecialRow||r!=null&&r.isLinked&&r.instanceMeta(this).groupParent?(this.unregister(r),!1):!0))}prepareGroupRecords(){var t;const r=this,{GroupRow:n,isFiltered:s,reapplyFilterOnUpdate:a,groupRecords:o}=r,l=r.groupers[0],d=l.ascending!==!1?1:-1,{field:c,fn:u=zk,leafFieldName:h}=l,f=typeof c=="function",g=c===r.modelClass.idField,m=new Bi,v=r._groupVisibleRecordIds||[],y=w=>{const x=!s||r.filtersFunction(w);return a?x:x||v.includes(w.id)},b=!!(r.startGroupsCollapsed&&!(o!=null&&o.count));o==null||o.forEach(w=>{w.isCollapsed&&r.includeGroupRecords(w)});const C=r.removeHeadersAndFooters(r.storage._values);if(r.sorters.length&&C.sort(r.sorterFn),s&&(r.filtersFunction=null),C.forEach(w=>{const x=w,R=f?c(w):w.getValue(c),M=L.asArray(R==null?X0:R),I=Array.isArray(M),_=I&&!M.length,F=_?1:M.length;for(let A=0;A<F;A++){const P=_?[]:M[A],V=`group-header-${typeof P=="number"?P:k.createId(P)}`;let B=m.get(V);if(B||(B=(o==null?void 0:o.get(V))||new n({[r.modelClass.idField]:V,[g?"":h]:P,_groupValue:P},r,{collapsed:b,specialRow:!0,groupRowFor:P,groupField:h,emptyArray:_}),m.add(B),B.meta.childCount=0,B.groupChildren=[],B.unfilteredGroupChildren=[],B.stores=[r]),r.register(B),A>0){const W=x.groupLinks||(x.groupLinks={});w=W[P]||(W[P]=x.link()),w.stores=[r],r.register(w)}w.instanceMeta(r).groupParent=B,y(w)&&(B.groupChildren.push(w),B.meta.childCount++),B.unfilteredGroupChildren.push(w)}}),m._values.sort((w,x)=>u(w,x)*d),r.useGroupFooters)for(let w=0,x=m.count;w<x;w++){const R=m.values[w],M=R.meta.groupRowFor,I=`group-footer-${typeof M=="number"?M:k.createId(M)}`,_=r.getById(I)||new n({[r.modelClass.idField]:I,[g?"":h]:M,_groupValue:M},r,{specialRow:!0,groupFooterFor:M,groupRecord:R});_.stores=[r],r.register(_),_.groupChildren=R.groupChildren,m.splice(++w,0,_),x++,R.groupChildren.push(_),R.unfilteredGroupChildren.push(_),R.meta.childCount++}r._idMap=null;const D={values:m.reduce((w,x)=>(x.isGroupFooter||(w.push(x),x.meta.collapsed||w.push(...x.unfilteredGroupChildren)),w),!1,[])};return s&&(D.filteredValues=D.values.filter(y)),(t=r.groupRecords)==null||t.forEach(w=>{m.includes(w)||w.destroy()}),r.groupRecords=m,D}get isGrouped(){var t;return!!((t=this.groupers)!=null&&t.length)}group(t,r,n=!1,s=!0,a=!1){var o,l;const d=this,{sorters:c=[]}=d,u=d.createGrouper(t,r);let h,f=!1;if(n?d.groupers.push(u):t?(r==null&&!("ascending"in u)&&(u.ascending=u.fn&&((o=d.groupInfo)==null?void 0:o.field)===u.field&&((l=d.groupInfo)==null?void 0:l.fn)===u.fn?!d.groupInfo.ascending:!0),d.groupInfo=h=u,d.groupers=[d.groupInfo],c.some(g=>g.field===t)&&(d.sorters=c.filter(g=>g.field!==t),f=!0)):t===null&&r===null?(s=!0,f=!0):!f&&c.length&&s&&(f=!0),h){const{prototype:g}=d.modelClass;h.complexMapping&&!Object.prototype.hasOwnProperty.call(g,t)&&Object.defineProperty(g,t,{get(){return T.getPath(this,t)}})}if(s!==!1){if(d.remoteSort&&!d.isRemoteDataLoading)return d.sort(null,null,!1,!f).then(()=>d.onAfterGrouping(a,!f));d.sort(null,null,!1,!f)}d.onAfterGrouping(a,!f)}onAfterGrouping(t,r=!0){if(t)return;const n=this,s=n.groupers||[];n.trigger("group",{isGrouped:n.isGrouped,groupers:s,records:n.storage.values}),r&&n.trigger("refresh",{action:"group",isGrouped:n.isGrouped,groupers:s,records:n.storage.values})}addGrouper(t,r=!0){return this.group(t,r,!0)}removeGrouper(t){const r=this,{groupers:n}=r;if(!n)return;const s=n.findIndex(a=>a.field===t);if(s>-1)return n.splice(s,1),n.length?r.group():r.clearGroupers()}clearGroupers(t=!1){return this.setGroupers(null,{silent:t})}isRecordInGroup(t,r){var n;if(!this.isGrouped)return!1;const s=(n=this.groupers[0])==null?void 0:n.field;return t.getValue(s)===r&&!t.isSpecialRow}isInCollapsedGroup(t){const{groupParent:r}=t.instanceMeta(this);return r==null?void 0:r.meta.collapsed}getGroupRecords(t){return this.isGrouped?this.storage.values.filter(r=>this.isRecordInGroup(r,t)):null}getGroupTitles(){return this.isGrouped?this.getDistinctValues(this.groupers[0].field):null}get groupHeaderRecords(){return this.useGroupFooters?this.groupRecords.values.filter(t=>t.isGroupHeader):this.groupRecords.values}onDataChanged({changes:t,action:r}){this.isGrouped&&(!t&&jk[r]||t&&this.groupers.some(n=>n.rootFieldName in t))&&this.sort()}internalIncludeExcludeGroupRecords(t,r){const n=this,s=n.indexOf(t),a=n.allIndexOf(t),{id:o,storage:l}=n,{_filteredValues:d,_values:c}=l,{meta:u,groupChildren:h,unfilteredGroupChildren:f}=t;a===-1||u.collapsed&&!r||!u.collapsed&&r||(f.forEach(g=>g.instanceMeta(o).hiddenByCollapse=!r),r?(d&&d.splice(s+1,0,...h.filter(g=>!n.isAvailable(g.id))),l._values.splice(a+1,0,...f.filter(g=>!n.isAvailable(g.id)))):(d&&d.splice(s+1,h.length),c.splice(a+1,f.length)),l._indicesInvalid=!0,n._idMap=null)}excludeGroupRecords(t){this.internalIncludeExcludeGroupRecords(t,!1)}includeGroupRecords(t){this.internalIncludeExcludeGroupRecords(t,!0)}collectGroupRecords(t,r=!0){return(t?this.storage.allValues:this.storage.values).reduce((s,a)=>(a.isSpecialRow&&(r&&!a.isGroupFooter&&s.push(a),a.isGroupHeader&&s.push.apply(s,t?a.unfilteredGroupChildren:a.groupChildren)),s),[])}},p(e,"$name","StoreGroup"),p(e,"configurable",{groupers:null,useGroupFooters:!1,startGroupsCollapsed:null}),e},Q0=Promise.resolve(),J0=i=>{var e;return e=class extends(i||O){get currentPage(){var t;return(t=this._currentPage)!=null?t:1}set currentPage(t){this.totalCount&&(t=Math.min(t,this.lastPage)),this._currentPage=t}updatePageParamName(t){if(this.pageStartParamName)throw new Error("Configs pageStartParamName and pageParamName are mutually exclusive");this.remotePaging=t!=null}updatePageStartParamName(t){if(this.pageParamName)throw new Error("Configs pageParamName and pageStartParamName are mutually exclusive");this.remotePaging=t!=null}get defaultPageParamName(){var t,r;return(r=(t=this.pageParamName)!=null?t:this.pageStartParamName)!=null?r:"page"}updateRemotePaging(t){if(t&&this.tree)throw new Error("Paging cannot be supported for tree stores")}updatePageSize(t){const r=this;!r.isConfiguring&&t&&(r.currentPage=r.currentPage?Math.min(r.currentPage,Math.floor((r.totalCount+t-1)/t)):1,r.loadPage(r.currentPage))}get isPaged(){return this.remotePaging}set pagedTotal(t){this.remoteTotal=t}get lastPage(){if(this.isPaged)return Math.floor((this.totalCount+this.pageSize-1)/this.pageSize)}async loadPage(t,r={}){var n;if(r=this.getPagingParams({...r,page:t}),await this.trigger("beforeLoadPage",{params:r})===!1)return!1;await this.performDataRequest(!1,r,()=>{this.currentPage=t})!==!1&&((n=this.trigger)==null||n.call(this,"loadPage",r))}async nextPage(t){const r=this;return r.isPaged&&r.currentPage!==r.lastPage?r.loadPage(r.currentPage+1,t):Q0}async previousPage(t){return this.isPaged&&this.currentPage!==1?this.loadPage(this.currentPage-1,t):Q0}buildRemoteParams(t={},r=!1){var n,s;return this.getPagingParams((s=(n=super.buildRemoteParams)==null?void 0:n.call(this,t,r))!=null?s:t)}getPagingParams(t){var r;const n=this;if(n.isPaged){let s=(r=t[n.defaultPageParamName])!=null?r:n.currentPage;this.pageStartParamName&&(s=Math.max(0,s-1)*this.pageSize),t[n.defaultPageParamName]=s,t[n.pageSizeParamName]=n.pageSize}return t}},p(e,"$name","StorePaging"),p(e,"configurable",{pageSize:50,pageSizeParamName:"pageSize",pageParamName:null,pageStartParamName:null,remotePaging:!1}),e},ex=i=>class extends(i||O){static get configurable(){return{objectify:null}}initProxy(){if(!globalThis.Proxy)throw new Error("Proxy not supported");return new Proxy(this,{get(r,n){if(n in r)return r[n];if(n==="$store")return r;let s=r.getById(n);return!s&&!isNaN(parseInt(n))&&(s=r.getAt(parseInt(n))),s},set(r,n,s){return n in r||r.isDestroying||n.startsWith("_")?r[n]=s:r.add({[r.modelClass.idField]:n,...s}),!0},deleteProperty(r,n){return r.isDestroying?(delete r[n],!0):!!r.remove(n).length},has(r,n){if(n in r)return!0;if(n.startsWith("{")&&n.endsWith("}")){const s=k.safeJsonParse(n);n=s==null?void 0:s.id}return r.includes(n)}})}},tx=i=>{var e;return e=class extends(i||O){initRelations(t){const r=this,n=r.modelClass.exposedRelations;t&&r.modelRelations&&r.modelRelations.forEach(s=>{var a;return(a=s.storeDetacher)==null?void 0:a.call(s)}),(!r.modelRelations||r.modelRelations.length===0||t)&&!r.isChained&&(r.modelRelations=[],n==null||n.forEach(s=>{const a={...s},{foreignStore:o,relationName:l,relatedCollectionName:d}=a,c=typeof o=="string"?r[o]:o;if(a.dependentStore=r,r.modelRelations.push(a),c){a.foreignStoreProperty=a.foreignStore,a.foreignStore=c;const u=c.dependentStoreConfigs;if(u.has(r)){const h=u.get(r);if(t){const f=h.find(g=>g.relationName===l);f&&L.remove(h,f)}h.push(a)}else u.set(r,[a]);d&&c.initRelationCollection(a,r),c.count>0&&c.updateDependentStores("dataset",c.records)}}))}initRelationCollection(t,r){const n=this,s=t.relatedCollectionName,a=n.collectionStores||(n.collectionStores={});a[s]={store:r,config:t},n[s+"Store"]||(n[s+"Store"]=r),n.allRecords.length&&n.initModelRelationCollection(s,n.allRecords)}initModelRelationCollection(t,r){const n=this;r.forEach(s=>{s.traverse(a=>{const o=t in a?`$related${k.capitalize(t)}`:t;Object.defineProperty(a,o,{enumerable:!0,configurable:!0,get:function(){return n.getCollection(this,t)},set:function(l){return n.setCollection(this,t,l)}})})})}resetRelationCache(){this.relationCache={},this.forEach(t=>t.initRelations())}updateRecordRelationCache(t,r){r==null||r.forEach(n=>{const{config:s}=n,a=n.related?n.related.id:t.getValue(s.foreignKey);a!==void 0&&this.cacheRelatedRecord(t,a,s.relationName,a)})}getRelationCollection(t,r){var n;const s=me.asId(r);return((n=this.relationCache[t])==null?void 0:n[s])||[]}getCollection(t,r){var n;const{config:s,store:a}=this.collectionStores[r];return((n=a.relationCache[s.relationName])==null?void 0:n[t.id])||[]}setCollection(t,r,n){const{config:s,store:a}=this.collectionStores[r],o=a.relationCache[s.relationName]||(a.relationCache[s.relationName]={}),l=(o[t.id]||[]).slice(),d=[],c=[];a.suspendEvents(),l.forEach(u=>{n.includes(u)||(u[s.foreignKey]=null,a.remove(u),c.push(u))}),n.forEach(u=>{u.isModel instanceof me?u.stores.includes(a)||(a.add(u),d.push(u)):([u]=a.add(u),d.push(u)),u[s.foreignKey]=t.id}),a.resumeEvents(),c.length&&(a.trigger("remove",{records:c}),a.trigger("change",{action:"remove",records:c})),d.length&&(a.trigger("add",{records:d}),a.trigger("change",{action:"add",records:d}))}cacheRelatedRecord(t,r,n,s=null){const a=this,o=a.relationCache[n]||(a.relationCache[n]={});s!==null&&a.uncacheRelatedRecord(t,n,s),r!=null&&L.include(o[r]||(o[r]=[]),t)}uncacheRelatedRecord(t,r=null,n=null){const s=this;function a(o,l){const d=s.relationCache[o],c=d==null?void 0:d[l];if(c){const u=c.indexOf(t);u>=0&&c.splice(u,1),c.length===0&&delete d[l]}}n!=null?a(r,n):t.meta.relationCache&&Object.entries(t.meta.relationCache).forEach(([o,l])=>a(o,l==null?void 0:l.id))}updateDependentStores(t,r,n){var s;const a=this,o=t==="dataset";a.dependentStoreConfigs.forEach(l=>{l.forEach(d=>{const{dependentStore:c,relatedCollectionName:u,relationName:h,foreignKey:f,propagateRecordChanges:g}=d,m=c.relationCache[h];if(o)u&&a.initModelRelationCollection(u,r),c.forEach(v=>{const y=v.initRelation(d);y&&c.cacheRelatedRecord(v,y.id,h,y.id)}),g&&c.totalCount&&c.trigger("refresh",{action:"relatedstoredataset",records:c.records});else if(t==="removeall"){c.forEach(v=>v.removeRelation(d)),delete c.relationCache[h];return}else t==="replace"&&(r=r.map(v=>v[1]));(t==="add"||t==="replace")&&u&&a.initModelRelationCollection(u,r),o||r.forEach(v=>{const y=m==null?void 0:m[v.id];switch(t){case"remove":y&&y.forEach(b=>b.removeRelation(d));break;case"add":case"replace":c.forEach(b=>{b.getValue(f)==v.id&&(b.initRelation(d),c.cacheRelatedRecord(b,v.id,h))});break}!n&&(y!=null&&y.length)&&g&&y.forEach(b=>b.stores.forEach(C=>a.notifyRelatedStore(C,b,d.relationName,v)))})})}),r!=null&&r.length&&((s=a.modelRelations)==null||s.forEach(l=>{l.propagateRecordChanges&&(o?l.foreignStore.totalCount&&l.foreignStore.trigger("refresh",{action:"relatedstoredataset",records:l.foreignStore.records}):r.forEach(d=>{var c;const u=d[l.relationName];(c=u==null?void 0:u.stores)==null||c.forEach(h=>{a.notifyRelatedStore(h,u,l.relatedCollectionName,d)})}))}))}notifyRelatedStore(t,r,n,{meta:s}){if(this.isChained||t.isChained)return;let{_ignoreRelationUpdate:a}=s,o=!1;a!=null&&a.size||(s._ignoreRelationUpdate=a=new Set,o=!0),a.has(t)||(a.add(this).add(t),r.meta._ignoreRelationUpdate=a,t.onModelChange(r,{[n]:r[n]},{[n]:r[n]},!1,!0),o&&a.clear())}updateDependentRecordIds(t,r){var n;(n=this.dependentStoreConfigs)==null||n.forEach(s=>{s.forEach(a=>{var o;const{dependentStore:l,relationName:d,foreignKey:c}=a,u=l.relationCache[d],h=(o=u==null?void 0:u[t])==null?void 0:o.slice();h==null||h.forEach(f=>{l.cacheRelatedRecord(f,r,d,t),f.meta._ignoreRelatedIdUpdate=!0,f.set(c,r,!1,!0),delete f.meta._ignoreRelatedIdUpdate})})})}},p(e,"$name","StoreRelation"),e},ix=i=>{var e;return e=class extends(i||O){sum(t,r=this.storage.values){return r?r.reduce((n,s)=>{if(s.isSpecialRow)return n;const a=Number(s.getValue(t));return isNaN(a)?n:n+a},0):0}min(t,r=this.storage.values){return r!=null&&r.length?r.reduce((n,s)=>{const a=s.getValue(t);return typeof(a==null?void 0:a.valueOf())==="number"&&(a<n||n==null)&&(n=a),n},r[0].getValue(t)):0}max(t,r=this.storage.values){return r!=null&&r.length?r.reduce((n,s)=>{const a=s.getValue(t);return typeof(a==null?void 0:a.valueOf())==="number"&&(a>n||n==null)&&(n=a),n},r[0].getValue(t)):0}average(t,r=this.storage.values){if(!(r!=null&&r.length))return 0;let n=0;const s=r.reduce((a,o)=>{if(o.isSpecialRow)return a;const l=parseFloat(o.getValue(t));return isNaN(l)?a:(n++,a+l)},0);return n>0?s/n:0}groupSum(t,r){return this.sum(r,this.getGroupRecords(t))}},p(e,"$name","StoreSum"),e},rx=(i,e)=>String(i).toLowerCase().includes(e),nx={string:rx,number:(i,e)=>i===Number(e),boolean:rx,date:(i,e)=>i instanceof Date&&e instanceof Date?i-e===0:String(i.getMonth()+1).includes(e)||String(i.getDate()).includes(e)||String(i.getFullYear()).includes(e),object:(i,e)=>i===e,undefined:(i,e)=>i===e},sx=i=>{var e;return e=class extends(i||O){search(t,r=null,n,s){const a=this.isTree&&!s?this.rootNode.allChildren:this.getAllDataRecords(s),o=a.length,l=[];if(t==null)return[];typeof t=="string"&&(t=t.toLowerCase()),r||(r=this.modelClass.allFields.map(m=>m.name));let d,c,u,h,f,g;for(d=0;d<o;d++){u=a[d],c=0;for(const m of r){h=u.getValue(m),f=h instanceof Date?"date":typeof h;const v=n==null?void 0:n[c];v&&(h=v(h),f="string"),g=nx[f],h&&(g!=null&&g(h,t))&&l.push({index:d,data:u,field:m,id:u.id}),c++}}return l}findByField(t,r,n=!1,s=!1){const a=this.getAllDataRecords(s),o=a.length,l=new Set,d=[];let c,u,h;for(r!=null&&(r=String(r).toLowerCase()),c=0;c<o;c++)if(u=a[c],h=u.getValue(t),!n||!l.has(h)){const f=h instanceof Date?"date":typeof h,g=nx[f];(r==null&&h===r||r===""&&h===""||r&&g(h,r))&&(d.push({id:u.id,index:c,data:u}),n&&l.add(h))}return d}find(t,r=!1){return this.getAllDataRecords(r).find(t)}findRecord(t,r,n=!1){const s=a=>T.isEqual(a[t],r);return this.isTree?this.query(s,n)[0]:this.getAllDataRecords(n).find(s)}query(t,r=!1){return this.getAllDataRecords(r).filter(t)}some(t,r=!1){return this.getAllDataRecords(r).some(t)}},p(e,"$name","StoreSearch"),e},ax=i=>{var e;return e=class extends(i||O){get isSorted(){return!!this.sorters.length||this.isGrouped}changeSorters(t){return t.map(r=>this.normalizeSorterConfig(r,!0))}updateSortParamName(t){this.remoteSort=t!=null}sort(t,r,n=!1,s=!1){const a=this,o=a.allRecords,l=a.sorters?a.sorters.slice():[];let d=null,c;if(t)if(Array.isArray(t))a.sorters=t.map(u=>a.normalizeSorterConfig(u,typeof u=="string"?!0:r));else{const u=a.normalizeSorterConfig(t,r);n?(c=a.getCurrentSorterByField(u.field),c?(d=c.ascending,c.ascending=u.ascending):a.sorters.push(u)):a.sorters=[u]}return!s&&a.trigger("beforeSort",{sorters:a.sorters,records:o,currentSorters:l})===!1?(a.sorters=l,d!==null&&(c.ascending=d),null):a.remoteSort?a.performRemoteSort(s):a.performSort(s)}normalizeSorterConfig(t,r){var n,s,a;const o=this,l={ascending:r};if(typeof t=="object"?(T.assign(l,t),t.fn&&(delete l.fn,l.sortFn=t.fn),l.ascending=(n=t.ascending)!=null?n:r):typeof t=="function"?l.sortFn=t:l.field=t,l.ascending==null){const d=o.getCurrentSorterByField(l.field);l.ascending=d?!d.ascending:!0}if(l.sortFn==null){const d=(a=(s=o.modelClass)==null?void 0:s.$meta.fields.map[l.field])==null?void 0:a.compareItems;d&&(l.sortFn=d)}return l}getCurrentSorterByField(t){return typeof t=="string"&&this.sorters.find(r=>r.field===t)||null}addSorter(t,r=!0){return this.sort(t,r,!0)}removeSorter(t){const r=this.sorters.findIndex(n=>n.field===t||n.sortFn===t);if(r>-1)return this.sorters.splice(r,1),this.sort()}clearSorters(t=!1){if(this.sorters.length)return this.sorters.length=0,this.sort(void 0,void 0,void 0,t)}suspendSortOnUpdate(){"_reapplySortersSuspended"in this||(this._reapplySortersSuspended=0),this._reapplySortersSuspended++}resumeSortOnUpdate(t=!0){const r=this;r._reapplySortersSuspended&&(r._reapplySortersSuspended--,!r._reapplySortersSuspended&&r._shouldReapplySorters&&(t&&r.sort(),r._shouldReapplySorters=!1))}createSorterFn(t){const r=this.useLocaleSort;return(n,s)=>{for(let a=0;a<t.length;a++){const o=t[a],{field:l,ascending:d=!0,useLocaleSort:c=r,caseSensitive:u=!0}=o,h=o.fn||o.sortFn,f=d?1:-1;if(h){const v=h.call(o,n,s);if(v===0)continue;if(v!==null)return v*f}let g=n.isModel?n.getValue(l):n[l],m=s.isModel?s.getValue(l):s[l];if(u||(typeof g=="string"&&(g=g.toLowerCase()),typeof m=="string"&&(m=m.toLowerCase())),g!==m){if(g==null)return-f;if(m==null)return f;if(c&&typeof g=="string"){if(c===!0)return String(g).localeCompare(m)*f;if(typeof c=="string")return String(g).localeCompare(m,c)*f;if(typeof c=="object")return String(g).localeCompare(m,c.locale,c)*f}if(g>m)return f;if(g<m)return-f}}return 0}}get sorterFn(){return this.createSorterFn(this.remoteSort?[{field:"_remoteSortIndex"}]:this.sorters)}performSort(t){const r=this,{rootNode:n,storage:s,sorterFn:a}=r;r.tree?((!r.isChained||r.isChainedTree)&&n.traverse(o=>{o.isLoaded&&o.isParent&&(o.children.sort(a),o.updateChildrenIndices(o.children,"parentIndex",!0))}),s.replaceValues({values:r.collectDescendants(n).visible,silent:!0})):r.isGrouped?s.replaceValues({...r.prepareGroupRecords(),silent:!0}):s.replaceValues({values:s.values.sort(a),silent:!0}),r.afterPerformSort(t||r.isRemoteDataLoading)}async performRemoteSort(t){var r;await((r=this.beforePerformSort)==null?void 0:r.call(this))!==!1&&await this.performDataRequest(t)!==!1&&this.afterPerformSort(t)}buildRemoteParams(t={},r=!1){var n;let{sorters:s,groupers:a,sortParamName:o="sorters"}=this;return(n=super.buildRemoteParams)==null||n.call(this,t,r),a&&(s=a.concat(s)),s.length&&(t[o]=r?this.encodeSorterParams(s):this.getSorterParams(s)),t}getSorterParams(t){return t.filter(r=>!r.sortFn).map(({field:r,ascending:n})=>({field:r,ascending:n}))}afterPerformSort(t){if(t)return;const r=this;r._idMap=null;const n={action:"sort",sorters:r.sorters,records:r.allRecords};r.trigger("sort",n),r.trigger("refresh",n)}},p(e,"$name","StoreSort"),p(e,"configurable",{useLocaleSort:null,sorters:[],reapplySortersOnAdd:!1,reapplySortersOnUpdate:!1,remoteSort:!1,sortParamName:null}),e},eb=()=>!0,ox=i=>{var e;return e=class extends(i||O){static get properties(){return{chainedStores:null,isChainedTree:null}}construct(t){super.construct(t);const r=this,{masterStore:n}=r;n&&(r.methodNamesToRelay.forEach(s=>r[s]=(...a)=>r.relayToMaster(s,a)),r.removeAll=(...s)=>{n.remove(r.getRange(),...s)},n.ion({name:"masterStoreListeners",changePreCommit:r.onMasterDataChangedPreCommit,change:r.onMasterDataChanged,prio:1,thisObj:r}),r.syncSort&&n.ion({sort:()=>r.sort(n.sorters),thisObj:r}),n.chainedStores||(n.chainedStores=[]),n.chainedStores.push(r),r.fillFromMaster())}get $master(){return this.masterStore||this}get isChained(){return!!this.masterStore}changeChainedFilterFn(t){return this.thisObj?t.bind(this.thisObj):t}get chainedFilterFn(){return this._chainedFilterFn||eb}get methodNamesToRelay(){const t=Array.isArray(this.doRelayToMaster),r=Array.isArray(this.dontRelayToMaster);return t&&this.doRelayToMaster.filter(n=>!r||!this.dontRelayToMaster.includes(n))||[]}updateChainedStores(){var t;(t=this.chainedStores)==null||t.forEach(r=>r.fillFromMaster())}fillFromMaster(){const t=this,{masterStore:r,isTree:n}=t,{isFiltered:s}=r;if(!t.isChained)throw new Error("fillFromMaster only allowed on chained store");if(t.isChainSuspended)return;let a,o=null;if(t.chainFilters&&s){const l=r.filters.values.filter(d=>!d.ignoreForChain);l.length&&(o=dt.generateFiltersFunction(l))}if(t.isChainedTree)return t.fillTreeFromMaster(o);if(a=r.allRecords.filter(l=>{if(!l.isSpecialRow&&(!t.ignoreLinkRecords||!l.isLinked)&&t.chainedFilterFn(l)&&(!o||o(l)))return!(t.excludeCollapsedRecords&&!l.ancestorsExpanded(r))}),t.masterStore.sorterFn&&s&&r.isSorted&&!r.remoteSort&&a.sort(r.sorterFn),n)if(t.idRegister={},t.internalIdRegister={},a.forEach(l=>{l.stores.includes(t)?t.register(l):l.joinStore(t)}),t.excludeCollapsedRecords){const l=t.getChildren(t.rootNode);a=t.doIncludeExclude(l,!0)}else a.forEach(l=>l.instanceMeta(t).collapsed=!1);t.isFillingFromMaster=!0,t.data=a,t.isFillingFromMaster=!1}fillTreeFromMaster(t){const r=this,{chainedFilterFn:n}=r,s=r.masterStore.rootNode,a=[],o=r.treeLinkMap||{},l=r.idRegister={},d=r.internalIdRegister={};r.treeLinkMap={},or.postWalk({children:s.unfilteredChildren||s.children},c=>!c.isLeaf&&(c.unfilteredChildren||c.children),c=>{var u,h,f;if(c.isLeaf&&(!t||t(c))&&n(c)||!c.isLeaf&&((h=(u=c.meta)==null?void 0:u.tempChildren)!=null&&h.length)){const g=(f=c.parent)==null?void 0:f.meta,m=o[c.id],v=c.isLeaf&&m,y=v||c.link(),b=y.proxyMeta.data;r.treeLinkMap[c.id]=y,v?(b.parent=b.parentIndex=b.unfilteredIndex=b.parentId=b.children=b.orderedChildren=b.unfilteredChildren=null,l[y.id]=m,d[y.internalId]=m):m&&y.removeLink(m),g.tempChildren||(g.tempChildren=[]),g.tempChildren.push(y),c.isParent&&a.unshift(y)}}),r.rootNode.meta.isFillingFromMaster=r.isFillingFromMaster=!0;for(let c=a.length-1;c>=0;c--){const u=a[c],{meta:h}=u.$original;h.tempChildren&&(u.meta.isFillingFromMaster=!0,u.appendChild(h.tempChildren,!0),u.meta.isFillingFromMaster=!1,h.tempChildren=null)}r.data=s.meta.tempChildren||[],r.rootNode.meta.isFillingFromMaster=r.isFillingFromMaster=!1,s.meta.tempChildren=null}commitToMaster(){const t=this,r=t.masterStore;if(!t.isChained)throw new Error("commitToMaster only allowed on chained store");return r.beginBatch(),r.remove(t.removed.values),r.add(t.added.values),r.endBatch(),t.commit()}relayToMaster(t,r){return this.masterStore[t](...r)}onMasterDataChangedPreCommit(t){this.onMasterDataChanged(t),this.$masterEventhandled=!0}onMasterDataChanged({action:t,changes:r,isMove:n}){var s;const a=this;if(a.$masterEventhandled){a.$masterEventhandled=!1;return}n&&t==="remove"||(t!=="update"||a.chainedFields==="*"||(s=a.chainedFields)!=null&&s.some(o=>o in r)||"isLeaf"in r||"parentId"in r)&&a.fillFromMaster()}makeChained(t=eb,r,n){return te.deprecate("core","7.0.0","makeChained() deprecated in favor of chain() and chainTree()"),this.chain(t,r,n)}chain(t=eb,r,n){if(this.isChained){const s=t;t=a=>s(a)&&this.chainedFilterFn(a)}return new((n==null?void 0:n.storeClass)||this.constructor)({id:`${this.id}-chained-${k.generateUUID()}`,tree:!1,autoTree:!1,...n||{},masterStore:this.$master,modelClass:this.modelClass,syncDataOnLoad:!1,chainedFilterFn:t,chainedFields:r})}chainTree(t,r,n){if(!this.tree)throw new Error("chainTree only allowed on tree stores");return this.chain(t,r,{tree:!0,isChainedTree:!0,rootNode:this.rootNode.link(),...n})}doDestroy(){var t;this.detachListeners("masterStoreListeners"),(t=this.chainedStores)==null||t.forEach(r=>r.destroy()),super.doDestroy()}suspendChain(){this.chainSuspended++}resumeChain(t=!1){this.chainSuspended&&!--this.chainSuspended&&t&&this.fillFromMaster()}get isChainSuspended(){return this.chainSuspended>0}},p(e,"$name","StoreChained"),p(e,"configurable",{chainedFilterFn:null,chainedFields:null,masterStore:null,doRelayToMaster:["add","remove","insert"],dontRelayToMaster:[],excludeCollapsedRecords:!0,syncSort:!0,syncOrder:null,ignoreLinkRecords:null,chainFilters:null,chainSuspended:0}),e},lx=i=>{var e;return e=class extends(i||O){getState(){const{sorters:t,groupers:r,filters:n}=this,s={};return t!=null&&t.length&&(s.sorters=t.map(a=>{const o=T.cleanupProperties(T.clone(a));return delete o.fn,delete o.sortFn,o})),r!=null&&r.length&&(s.groupers=r.map(a=>{const o=T.cleanupProperties(T.clone(a));return delete o.fn,o}),s.collapsedGroups=[...this.collapsedGroups]),n!=null&&n.values.length&&(s.filters=n.allValues.map(a=>a.getState())),s}applyState(t){var r;const n=this,{sorters:s=[],groupers:a=[],filters:o=[]}=t,{sortParamName:l,filterParamName:d}=n;(n.isSorted||s.length!==0||a.length!==0)&&(n.sorters=s.filter(c=>c.field||c.sortFn&&!l),n.groupers=a.slice(),a.length?n.group():n.sort()),(r=t.collapsedGroups)==null||r.forEach(c=>{const u=n.getById(c);u&&n.collapse(u,!0)}),(n.isFiltered||o.length!==0)&&(n.filters=o.filter(c=>c.property||c.filterBy&&!d),n.filter())}},p(e,"$name","StoreState"),e},Wk=i=>String(i).padStart(6,"0"),Zg=class kr{constructor(e){this.value=e,this._padded=null}set value(e){this._value=String(e!=null?e:"")}get value(){return this._value}static from(e){return e==null||e instanceof kr?e:new kr(e)}static pad(e){return e instanceof kr?e.valueOf():kr.split(e).map(Wk).join(".")}static split(e){let t,r;if(e||e===0)switch(typeof e){case"object":e=String(e);case"string":for(r=e.split("."),t=r.length;t-- >0;)r[t]=parseInt(r[t],10);break;case"number":r=[e];break}return r||[]}static compare(e,t){return e===t?0:!e||!t?e?1:t?-1:0:(e=kr.pad(e),t=kr.pad(t),e<t?-1:t<e?1:0)}append(e){const t=this.value;return kr.from(t?`${t}.${e}`:e)}isEqual(e){return!kr.compare(this,e)}match(e){let t=!1;if(e){const r=this.value,n=e[0]==="*",s=e.endsWith("*"),a=e.length;n===s?t=r.indexOf(n?e.substr(1,a-2):e)>-1:n?t=r.endsWith(e.substr(1)):t=r.startsWith(e.substr(0,a-1))}return t}toString(){return this.value}toJSON(){return this.toString()}valueOf(){var e;return(e=this._padded)!=null?e:this._padded=kr.pad(this.value)}};Zg._$name="Wbs";var Uk=Object.freeze([]),Ru=Symbol("StopBranch"),tb=k.generateUUID(),Gk=(i,e,t)=>{if(i.isLeaf===e.isLeaf)if(i.isLeaf){let r;for(let n=0;!r&&n<t.length;n++){const s=t[n](i),a=t[n](e);if(s===Ru||a===Ru)return i.isLeaf<e.isLeaf?-1:i.isLeaf>e.isLeaf?1:0;r=s<a?-1:a<s?1:0}return r}else return typeof i.key=="string"&&typeof e.key=="string"?i.key.localeCompare(e.key,void 0,{numeric:!0}):i.key<e.key?-1:i.key>e.key?1:0;else return i.isLeaf<e.isLeaf?-1:i.isLeaf>e.isLeaf?1:0},dx=i=>{var e;return e=class extends(i||O){get StopBranch(){return Ru}get isTree(){var t,r;return(r=this.tree)!=null?r:(t=this.masterStore)==null?void 0:t.tree}get leaves(){const t=[];return this.isTree?this.traverse(r=>{r.isLeaf&&t.push(r)}):this.allRecords.forEach(r=>{r.isLeaf&&t.push(r),r.traverse(n=>{n.isLeaf&&t.push(n)},!0)}),t}async loadChildren(t){}onNodeAddChild(t,r,n,s,a=!1){var o;const l=this,d=t===l.rootNode&&t.isLoading,{storage:c}=l,{previousSibling:u}=r[0];let h;const{visible:f,all:g}=l.collectDescendants(r,void 0,void 0,{inCollapsedBranch:!(t.isExpanded(l)&&t.ancestorsExpanded(l)),applyFilter:l.isFiltered&&l.reapplyFilterOnAdd});if(!d&&g.length)for(const m of g)!l.modified.includes(m)&&!s[m.id]&&(l.removed.includes(m)?l.removed.remove(m):m.isLinked||l.added.add(m));if(d&&l.rootVisible&&(f.unshift(t),g.unshift(t)),f.length?(n===0||!u?h=c.indexOf(t):h=c.indexOf(u)+u.getDescendantCount(!0,l),c.suspendEvents(),l.storage.splice(++h,0,f),c.resumeEvents(),l._idMap=null):l._allRecords=null,l.updateDependentStores("add",r),d&&f.length){if(l.sorters.length&&l.sort(null,null,!1,!0),(o=l.afterLoadData)==null||o.call(l),!a){const m={action:"dataset",data:l._data,records:f};l.trigger("refresh",m),l.trigger("change",m)}}else if(!a){const m={action:"add",parent:t,isChild:!0,isMove:s,records:r,allRecords:g,index:h};if(l.trigger("add",m),l.trigger("change",m),s&&Object.values(s).some(v=>v)){const v={newParent:t,records:r.filter(y=>s[y.id]),oldParents:r.map(y=>l.getById(y.meta.oldParentId))};l.trigger("move",v)}}}onNodeRemoveChild(t,r,n,s={isMove:!1,silent:!1,unfiltered:!1}){const a=this,{storage:o}=a,l=[],d=[],{isMove:c,silent:u,unfiltered:h}=s,f=h&&a.isFiltered;if(a.collectDescendants(r,l,d,{inCollapsedBranch:!(t.isExpanded(a)&&t.ancestorsExpanded(a)),unfiltered:f}),!c){for(const g of r)g.unjoinStore(a);for(const g of d)g.stores.includes(a)&&g.unjoinStore(a),a.added.includes(g)?a.added.remove(g):g.isLinked||a.removed.add(g);a.modified.remove(d)}if(l.length?(n=o.indexOf(l[0]),n>-1&&(o.suspendEvents(),o.splice(n,l.length),o.resumeEvents(),a._idMap=null)):(n=-1,a._allRecords=null),!u&&(a.fireRemoveEventForMoveAction||!c)){const g={action:"remove",parent:t,isChild:!0,isMove:c,records:r,allRecords:d,index:n};a.trigger("remove",g),a.trigger("change",g)}return d}collectDescendants(t,r=[],n=[],s={}){var a;const o=this,{inCollapsedBranch:l=!1,unfiltered:d=!1,applyFilter:c=!1}=s,u=Array.isArray(t)?t:(a=o.getChildren(t,d))!=null?a:[];if(c)return{visible:!l&&u.flatMap(h=>o.collectVisibleNodeDescendantsFiltered(h)),all:u.concat(u.flatMap(h=>h.allChildren))};for(let h=0,f=u.length,g;h<f;h++)g=u[h],l||r.push(g),n.push(g),o.collectDescendants(g,r,n,{inCollapsedBranch:l||!g.isExpanded(o),unfiltered:d});return{visible:r,all:n}}collectVisibleNodeDescendantsFiltered(t){const r=t.unfilteredChildren||t.children;if(!r||r.length===0||!t.isLeaf&&!t.isExpanded(this))return this.filtersFunction(t)?[t]:[];const n=r.flatMap(s=>this.collectVisibleNodeDescendantsFiltered(s));return n.length||this.filtersFunction(t)?[t].concat(n):[]}getChildren(t,r=!1){const n=this,s=n.isChained&&!n.isChainedTree,a=(r||s)&&t.unfilteredChildren||t.children;return a!=null&&a.length?s?a.filter(n.chainedFilterFn).sort(n.sorterFn):a:Uk}internalToggleTreeSubRecords(t,r){const n=this,{storage:s}=n,a=s.indexOf(t),o=n.doIncludeExclude(n.getChildren(t),r);if(n.isFiltered&&r&&t.unfilteredChildren&&n.updateChildrenHiddenState(t),o.length&&a!==!1){if(s.suspendEvents(),r){s.splice(a+1,0,o);const l={action:"add",isExpand:!0,parent:t,records:o,index:a+1};n.trigger("add",l),n.trigger("change",l)}else{s.splice(a+1,o.length);const l={action:"remove",isCollapse:!0,parent:t,records:o,index:a+1};n.trigger("remove",l),n.trigger("change",l)}s.resumeEvents(),n._idMap=null}}updateChildrenHiddenState(t){var r;(r=t.unfilteredChildren)==null||r.forEach(n=>{n.instanceMeta(this.id).hidden=!1,n.isLeaf||this.updateChildrenHiddenState(n)})}doIncludeExclude(t,r,n=[]){const s=this,a=(t==null?void 0:t.length)||0;for(let o=0;o<a;o++){const l=t[o];if(!s.isChained||s.chainedFilterFn(l)){const d=l.instanceMeta(s.id);(r||!d.hidden)&&n.push(l),d.hidden=!r,l.isExpanded(s)&&s.doIncludeExclude(s.getChildren(l),r,n)}}return n}async toggleCollapse(t,r){const n=this,s=n.getById(t),a=s.instanceMeta(n);if(r===void 0&&(r=!a.collapsed),!a.isLoadingChildren&&!s.isLeaf&&s.isExpanded(n)===r){if(n.trigger("beforeToggleNode",{record:s,collapse:r}),a.collapsed=r,a.collapsed)return n.onNodeCollapse(s),!0;{n.onNodeExpand(s);let o=!0;if(!s.isLoaded){a.isLoadingChildren=!0;try{await n.loadChildren(s)}catch(l){a.collapsed=!0,o=!1,n.trigger("loadChildrenException",{record:s,exception:l})}finally{a.isLoadingChildren=!1}}return o}}}onNodeCollapse(t){if(t.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(t,!1)}onNodeExpand(t){if(t.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(t,!0)}transformToTree(t){var r;const{parentIdField:n,idField:s,childrenField:a}=this.modelClass,o=((r=this.modelClass.fieldMap[n])==null?void 0:r.dataSource)||"parentId",l=new Map,d=new Set,c=[];for(const h of t){const f=h==null?void 0:h[s];f!=null&&l.set(f,h)}const u=h=>{const f=Object.assign({},h);return f[a]=[],l.set(f[s],f),d.add(h[s]),f};for(let h of t)if(h){const f=h[s];d.has(f)?h=l.get(f):h=u(h);const g=h[o];if(g!=null){let m=l.get(g);m&&(m[a]||(m=u(m)),m[a].push(h))}else h[a]?c.push(h):h[s]!=null?c.push(u(h)):c.push(h)}return l.forEach(h=>{var f,g;(g=(f=h[a]).sort)==null||g.call(f,(m,v)=>m.parentIndex-v.parentIndex)}),c}treeifyData(t,r,n,s=!1,a,o=null){const{length:l}=r,d=[],c=[],u={};let h,f;for(h=0;h<l;h++){let v=r[h];v=v.field||v,r[h].call||(r[h]=y=>y[v],r[h].fieldName=v),d[h]=new Map}or.preWalkWithParent({isRoot:!0,id:this.rootNode.id,children:t},v=>v.children,(v,y)=>{if(f=[],y.isLeaf){for(h=0;h<l;h++){const b=r[h],C=a?a(b(y),b.fieldName):b(y),D=d[h],w=C===""?tb:C,x=L.asArray(w)||[tb],R=[];if(x[0]===Ru)break;(f.length>0?f:[null]).forEach(I=>{var _;for(let F=0,{length:A}=x;F<A;F++){const P=x[F],V=`${((_=I==null?void 0:I.path)!=null?_:"")+(P!=null&&P.isModel?P.id:P)}/`,B=k.makeValidDomId(`generated_${V}`,"_"),W=D.get(B)||D.set(B,{id:B,key:x[F]===tb?"":P,path:V,readOnly:!0,children:[],generatedParent:!0,field:b.fieldName,firstGroupChild:y}).get(B);R.push(W),I&&!I.children.includes(W)&&I.children.push(W)}}),f=R}f.length?f.forEach((b,C)=>b.children.push(C?y.link():y)):c.push(y)}},!0),(n||s)&&d.forEach(v=>v.forEach((y,b,C)=>{n==null||n(y),s&&(y=this.createRecord(y),C.set(b,y))})),u.children=[...d[0].values(),...c];const g=(v,y)=>Gk(v,y,r),m=v=>{if(v.children){const y=o&&v.children.length&&!v.children[0].isLeaf;v.children.sort(y?o:g),v.children.forEach(m)}};return m(u),u}treeify(t,r,n=!1,s){return this.treeifyData(this.rootNode.children,t,r,n=!1,s)}treeifyFlatData(t){var r;const{childrenField:n,parentIdField:s}=this.modelClass,a=((r=this.modelClass.fieldMap[s])==null?void 0:r.dataSource)||"parentId";let o=!1,l=!0;for(const d of t){if(d!=null&&d.isModel||Array.isArray(d==null?void 0:d[n])){l=!1;break}(d==null?void 0:d[a])!=null&&(o=!0)}return l&&o&&(t=this.transformToTree(t)),t}async indent(t){const r=this;if(t=Array.isArray(t)?t:[t],t=t.filter(n=>{let s=!!n.previousSibling;for(;s&&!n.isRoot;)s=!t.includes(n.parent),n=n.parent;return s}),t.length&&r.trigger("beforeIndent",{records:t})!==!1){t.sort((n,s)=>Zg.compare(n.wbsCode,s.wbsCode)),r.beginBatch();for(const n of t){const s=n.previousSibling;s.appendChild(n),r.toggleCollapse(s,!1)}r.endBatch(),r.trigger("indent",{records:t}),r.trigger("change",{action:"indent",records:t})}}async outdent(t){const r=this;if(t=Array.isArray(t)?t:[t],t=t.filter(n=>{const{parent:s}=n;let a=s&&!s.isRoot;for(;a&&!n.isRoot;)a=!t.includes(s),n=n.parent;return a}),t.length&&r.trigger("beforeOutdent",{records:t})!==!1){t.sort((n,s)=>Zg.compare(n.wbsCode,s.wbsCode)),r.beginBatch();for(const n of t){const{parent:s}=n,a=s.children.slice(s.children.indexOf(n)+1);s.parent.insertChild(n,s.nextSibling),n.appendChild(a),r.toggleCollapse(n,!1)}r.endBatch(),r.trigger("outdent",{records:t}),r.trigger("change",{action:"outdent",records:t})}}},p(e,"$name","StoreTree"),p(e,"StopBranch",Ru),p(e,"configurable",{transformFlatData:null,fireRemoveEventForMoveAction:!1,keepExpandedOnLoad:!1}),e},cx=i=>{var e;return e=class extends(i||O){static get configurable(){return{syncDataOnLoad:null,shouldSyncDataset:null,shouldSyncRecord:null,reorderOnSync:!0}}syncDataset(t){var r,n,s,a,o;const l=this,{storage:d}=l,c=(a=(r=l.shouldSyncDataset)==null?void 0:r.call(l,{data:t,store:l,records:l.records}))!=null?a:(s=(n=l.project)==null?void 0:n.shouldSyncDataset)==null?void 0:s.call(n,{data:t,store:l,records:l.records});if(c===!1)return;l.trigger("startApplyChangeset"),l.isSyncingDataOnLoad=!0;const{toAdd:u,toRemove:h,toMove:f,updated:g,ids:m}=l.tree?l.syncTreeDataset(t,c):l.syncFlatDataset(t,c);let v=(o=l.syncDataOnLoad)==null?void 0:o.threshold,y=!1;if(v&&(typeof v=="string"&&(v=parseInt(v,10)/100*l.count),y=u.length+h.length+f.length+g.length>v),l.tree){if(u.length&&l.add(u,y).forEach(D=>D.clearParentId()),f.length)for(const{parent:C,node:D,index:w}of f)l.getById(C.id).insertChild(D,w);l.remove(h,y)}else y&&l.suspendEvents(),l.remove(h),l.add(u),y&&l.resumeEvents();v&&!y&&g.forEach(({record:C,toSet:D,wasSet:w})=>l.onModelChange(C,D,w)),l.$isSettingStoreFieldData||l.acceptChanges();const b={added:u,removed:h,updated:g,thresholdSurpassed:y};if(l.isFiltered&&!l.remoteFilter&&l.filter({silent:l.isRemoteDataLoading}),l.isGrouped)l.group(null,null,!1,!0,l.isRemoteDataLoading);else if(l.isSorted)l.remoteSort?d.replaceValues({values:d.values.sort(l.createSorterFn(l.sorters)),silent:!0}):l.sort();else if(l.reorderOnSync)if(!l.tree)d.values.some((C,D)=>m[C.id]!==D)&&(d.replaceValues({values:d.values.sort((C,D)=>m[C.id]-m[D.id]),silent:!0}),!y&&l.afterPerformSort());else{let C=!1,D=0;or.preWalk(l.rootNode,w=>Array.isArray(w.children)&&!C?w.children:null,w=>{w.id!==m[D++]&&(C=!0)}),C&&(l.sort((w,x)=>m[w.id]-m[x.id],void 0,void 0,!0),l.clearSorters(!0),!y&&l.afterPerformSort())}y&&l.trigger("refresh",{action:"batch",data:t,records:d.values,syncInfo:b}),l.isSyncingDataOnLoad=!1,l.trigger("endApplyChangeset"),l.trigger("loadSync",b)}syncFlatDataset(t,r){if(!t)return{toRemove:this.records};const n=this,{idField:s,allFields:a}=n.modelClass,o=[],l=[],d=[],c={},u={},h=r instanceof Set,{threshold:f,keepMissingValues:g}=n.syncDataOnLoad;let m=0;if(t.forEach((v,y)=>{var b,C;v=v.isModel?v.data:v;const D=v[s],w=n.getById(D);if(!h||r.has(D))if(w){if(n.shouldSyncRecord?n.shouldSyncRecord({record:w,data:v,store:n})!==!1:v!==w.data){if((b=n.beforeSyncRecord)==null||b.call(n,{record:w,data:v}),g===!1)for(const R of a)!(R.dataSource in v)&&R.dataSource in w.data&&(v[R.dataSource]=R.defaultValue);const x=w.set(v,null,!!f);x&&d.push({record:w,wasSet:x,toSet:v}),(C=n.afterSyncRecord)==null||C.call(n,{record:w,data:v})}}else l.push(n.processRecord(n.createRecord(v)));w&&m++,c[D]=1,u[D]=y}),m<n.allRecords.filter(v=>!v.isSpecialRow).length)if(r)for(const v of r)c[v]||o.push(n.getById(v));else n.forEach(v=>{c[v.id]||o.push(v)},n,{includeFilteredOutRecords:!0,includeCollapsedGroupRecords:!0});return{toAdd:l,toRemove:o,toMove:[],updated:d,ids:u}}syncTreeDataset(t){var r;if(!t)return{toRemove:this.records};const n=this,{idField:s,parentIdField:a,childrenField:o,allFields:l}=n.modelClass,{keepMissingValues:d,threshold:c}=(r=n.syncDataOnLoad)!=null?r:{},u=[],h=[],f=[],g=[],m=new Set,v={};let y=0;return n.transformFlatData&&(t=n.treeifyFlatData(t)),or.preWalkWithParent({isRoot:!0,id:n.rootNode.id,children:t},b=>b.children,(b,C)=>{if(b){const{id:D,node:w}=n.resolveSyncNode(C);if(w){if(n.shouldSyncRecord?n.shouldSyncRecord({record:w,data:C,store:n})!==!1:C!==w.data){let x;const R=w.children;w.parent.id!==b[s]&&f.push({node:w,parent:b,index:b[o].indexOf(C)});let M;if(w!==C){if(R!==!0&&C[o]===!0&&(w.clearChildren(),w.data[o]=w.children=!0,delete C[o],n.toggleCollapse(w,!0),x=!0),d===!1)for(const I of l)I.name!=="parentId"&&!(I.dataSource in C)&&I.dataSource in w.data&&(C[I.dataSource]=I.defaultValue);typeof C.expanded=="boolean"&&this.toggleCollapse(w,!C.expanded),M=w.set(C,null,!!c)}M?g.push({record:w,wasSet:M,toSet:C}):x&&w.signalNodeChanged({[o]:{value:!0,oldValue:R}})}m.add(w)}else C[a]=b[s],C.isModel?h.push(C):h.push({...C,...Array.isArray(C[o])?{children:[]}:void 0});v[D]=y++}}),n.totalCount!==m.size&&n.traverse(b=>{m.has(b)||u.push(b)}),{toAdd:h,toRemove:u,toMove:f,updated:g,ids:v}}resolveSyncNode(t){const r=t[this.modelClass.idField],n=this.getById(r);return{id:r,node:n}}},p(e,"$name","StoreSync"),e},Tu=class extends Error{constructor(...i){super(...i),this.name="RevisionException"}};Tu._$name="RevisionException";var ze=()=>{throw new Error("Abstract method call!")},se=()=>{throw new Error("Method cannot be called at this state!")},Rn=class extends O{canUndo(i){ze()}canRedo(i){ze()}canCheckoutTo(i){ze()}onUndo(i){ze()}onRedo(i){ze()}onCheckoutTo(i){ze()}onCheckoutToHead(i){ze()}onStartRevision(i,e){ze()}onStartTemporaryRevision(i,e,t){ze()}onStopRevision(i){ze()}onStartTransaction(i){ze()}onStopTransaction(i){ze()}onStopTransactionDelayed(i){ze()}onRejectTransaction(i){ze()}onEnable(i){ze()}onDisable(i){ze()}onAutoRecordOn(i){ze()}onAutoRecordOff(i){ze()}onResetQueue(i){ze()}onModelUpdate(i){ze()}onStoreModelAdd(i){ze()}onStoreModelInsert(i){ze()}onStoreModelRemove(i){ze()}onStoreModelRemoveAll(i){ze()}onModelInsertChild(i){ze()}onModelRemoveChild(i){ze()}};Rn._$name="StateBase";var _e=Symbol("STATE_PROP"),Tn=Symbol("STORES_PROP"),Ut=Symbol("QUEUE_PROP"),Hi=Symbol("POS_PROP"),Ze=Symbol("ACTION_QUEUE_PROP"),Qe=Symbol("REVISION_NAMES_PROP"),mt=Symbol("REVISION_QUEUE_PROP"),Gt=Symbol("REVISION_INDEX_PROP"),qk=Symbol("CURRENT_REV_ID_PROP"),Oe=Symbol("TRANSACTION_PROP"),Ei=Symbol("TRANSACTION_TIMER_PROP"),Vi=Symbol("AUTO_RECORD_PROP"),Mu=Symbol("IS_APPLYING_STASH"),qj=Object.freeze([_e,Tn,Ut,Hi,Ze,Qe,mt,Gt,qk,Oe,Ei,Vi,Mu]),ux=new Map,Yk=(i,e)=>{ux.set(i,e)},Kk=i=>(typeof i=="string"&&(i=ux.get(i)),i),si={registerStmState:Yk,resolveStmState:Kk},Qg=(i,e)=>{const{undo:t,redo:r,revision:n}=e;let s;return t&&!r?s={[Ut]:i[Ut].slice(i.position),[Hi]:0}:r&&!t?s={[Ut]:i[Ut].slice(0,i.position)}:s={[Ut]:[],[Hi]:0},n&&(s=Object.assign(s!=null?s:{},{[Qe]:["base"],[Gt]:0,[mt]:[]})),[s,()=>{i.notifyStoresAboutQueueReset(e)}]},Xk=class extends Rn{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){se()}onRedo(){se()}onEnable(i){return i.autoRecord?"autoreadystate":"readystate"}onDisable(){se()}onAutoRecordOn(){return{[Vi]:!0}}onAutoRecordOff(){return{[Vi]:!1}}onStartTransaction(){se()}onStopTransaction(){se()}onStopTransactionDelayed(){se()}onRejectTransaction(){se()}onResetQueue(i,e){return Qg(i,e)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}},hx=new Xk,Zk=hx;si.registerStmState("disabledstate",hx);var lr=class extends O{get type(){return this.constructor.name}undo(){ze()}redo(){ze()}invert(){const i=new this.constructor({...this.initialConfig,isUserInput:this.isUserInput,inversed:!0}),{undo:e,redo:t}=i;return i.undo=t,i.redo=e,i}};p(lr,"configurable",{inversed:!1});var Ft={ADD:"AddAction",INSERT:"InsertAction",INSERT_CHILD:"InsertChildAction",REMOVE:"RemoveAction",REMOVE_ALL:"RemoveAllAction",REMOVE_CHILD:"RemoveChildAction",UPDATE:"UpdateAction",EVENT_UPDATE:"EventUpdateAction"};lr._$name="ActionBase";var Gs=class extends lr{get type(){return Ft.UPDATE}changeModel(i){return i}changeNewData(i){return{...i}}changeOldData(i){return{...i}}undo(){const{model:i,oldData:e}=this;i.$&&Object.assign(i,e),i.set(e,null,null,null,!!i.$)}redo(){const{model:i,newData:e}=this;i.$&&Object.assign(i,e),i.set(e,null,null,null,!!i.$)}};p(Gs,"$name","UpdateAction"),p(Gs,"configurable",{model:void 0,newData:void 0,oldData:void 0,isInitialUserAction:!1}),Gs._$name="UpdateAction";var Iu=class extends lr{get type(){return Ft.INSERT_CHILD}changeParentModel(i){return i}changeChildModels(i){return i.slice(0)}changeInsertIndex(i){return i}changeContext(i){return i}changeStores(i){return i}undo(){const{parentModel:i,context:e,childModels:t}=this,r=new Map,n=new Set;for(const s of t){const a=e.get(s);if(!a)n.add(s);else{let o=r.get(a.parent);o||(o={moveRight:[],moveLeft:[],moveFromAnotherParent:[]},r.set(a.parent,o)),a.parent===i?a.index>s.parentIndex?o.moveRight.push({parent:a.parent,model:s,index:a.index+1}):o.moveLeft.push({parent:a.parent,model:s,index:a.index}):o.moveFromAnotherParent.push({parent:a.parent,model:s,index:a.index})}}n.forEach(s=>{var a;return(a=s.parent)==null?void 0:a.removeChild(s)});for(const s of r.values()){const{moveRight:a,moveLeft:o,moveFromAnotherParent:l}=s;l.forEach(d=>{d.parent.insertChild(d.model,d.index)}),o.sort((d,c)=>d.index-c.index),a.sort((d,c)=>c.index-d.index)}for(const s of r.values()){const{moveRight:a,moveLeft:o}=s;o.forEach(l=>{l.parent.insertChild(l.model,l.index)}),a.forEach(l=>{l.parent.insertChild(l.model,l.index)})}}redo(){var i,e;const{parentModel:t,insertIndex:r,childModels:n,orderedBeforeNode:s}=this,a=(i=t.children)==null?void 0:i[r];t.insertChild(n,a,!1,{orderedBeforeNode:s!=null?s:(e=a==null?void 0:a.previousSibling)==null?void 0:e.nextOrderedSibling})}};p(Iu,"$name","InsertChildAction"),p(Iu,"configurable",{parentModel:void 0,childModels:void 0,insertIndex:void 0,orderedBeforeNode:void 0,context:void 0,stores:void 0}),Iu._$name="InsertChildAction";var _u=class extends lr{get type(){return Ft.REMOVE_CHILD}changeParentModel(i){return i}changeChildModels(i){return i.slice(0)}changeContext(i){return i}changeStores(i){return i}undo(){const{parentModel:i,context:e,childModels:t}=this;t.sort((r,n)=>{const s=e.get(r).parentIndex,a=e.get(n).parentIndex;return s-a}),t.forEach(r=>{const n=e.get(r);i.insertChild(r,n.parentIndex,void 0,{orderedParentIndex:n.orderedParentIndex})})}redo(){this.parentModel.removeChild(this.childModels)}};p(_u,"$name","RemoveChildAction"),p(_u,"configurable",{parentModel:void 0,childModels:void 0,context:void 0,stores:void 0}),_u._$name="RemoveChildAction";var Fu=class extends lr{get type(){return Ft.ADD}changeStore(i){return i}changeModelList(i){return i.slice(0)}undo(){this.store.remove(this.modelList,this.silent)}redo(){this.store.add(this.modelList,this.silent)}};p(Fu,"$name","AddAction"),p(Fu,"configurable",{store:void 0,modelList:void 0,silent:!1}),Fu._$name="AddAction";var Au=class extends lr{get type(){return Ft.INSERT}changeStore(i){return i}changeModelList(i){return i.slice(0)}changeInsertIndex(i){return i}changeContext(i){return i}undo(){const{store:i,modelList:e,context:t,silent:r,reportUndoneRemoval:n}=this;e.sort((s,a)=>{const o=t.get(s),l=t.get(a);return o!==void 0&&l!==void 0?o-l:0}),e.forEach(s=>{const a=t.get(s);s._undoingInsertion=n,a!==void 0?i.insert(a,s,r):i.remove(s,r),s._undoingInsertion=!1})}redo(){const i=this;i.store.insert(i.insertIndex,i.modelList,i.silent)}};p(Au,"$name","InsertAction"),p(Au,"configurable",{store:void 0,modelList:void 0,insertIndex:void 0,context:void 0,silent:!1,reportUndoneRemoval:!0}),Au._$name="InsertAction";var Pu=class extends lr{get type(){return Ft.REMOVE}changeStore(i){return i}changeModelList(i){return i.slice(0)}changeContext(i){return i}undo(){const{store:i,context:e,modelList:t,silent:r}=this;t.sort((n,s)=>{const a=e.get(n),o=e.get(s);return a-o}),t.forEach(n=>{const s=e.get(n);i.insert(s,n,r)})}redo(){this.store.remove(this.modelList,this.silent)}};p(Pu,"$name","RemoveAction"),p(Pu,"configurable",{store:void 0,modelList:void 0,context:void 0,silent:!1}),Pu._$name="RemoveAction";var ku=class extends lr{get type(){return Ft.REMOVE_ALL}changeStore(i){return i}changeAllRecords(i){return i.slice(0)}undo(){const{store:i,allRecords:e,silent:t}=this;i.add(e,t)}redo(){this.store.removeAll(this.silent)}};p(ku,"$name","RemoveAllAction"),p(ku,"configurable",{store:void 0,allRecords:void 0,silent:!1}),ku._$name="RemoveAllAction";var Qk=(i,e,t,r)=>new Gs({model:i,newData:e,oldData:t,isInitialUserAction:r}),Jk=(i,e,t,r,n,s)=>new Iu({parentModel:i,childModels:t,insertIndex:e,orderedBeforeNode:n,context:r,stores:s}),eL=(i,e,t,r)=>new _u({parentModel:i,childModels:e,context:t,stores:r}),tL=(i,e,t)=>new Fu({store:i,modelList:e,silent:t}),iL=(i,e,t,r,n)=>new Au({store:i,insertIndex:e,modelList:t,context:r,silent:n}),rL=(i,e,t,r)=>new Pu({store:i,modelList:e,context:t,silent:r}),nL=(i,e,t)=>new ku({store:i,allRecords:e,silent:t}),sL=i=>i.invert(),Hr={DATA_CORRECTION:"DATA_CORRECTION",TEMPORARY:"TEMPORARY",CONFLICT_RESOLUTION:"CONFLICT_RESOLUTION"},ai=class extends O{static get configurable(){return{title:null,committed:!1,inputGeneration:0}}static from(i,e={}){const t=new this({...this.initialConfig,...e,inputGeneration:i.reduce((r,n)=>{var s;return Math.max(r,(s=n.inputGeneration)!=null?s:0)},0),committed:!1});return t[Ze]=i.flatMap(r=>r[Ze].filter(n=>r.inputGeneration>0?e.conflictResolutionFor?n.isUserInput===r.inputGeneration:n.isUserInput:n)),t}static createTransactionWithOriginalInput(i){const e=new this({...this.initialConfig,title:i.title,committed:!1});return e[Ze]=i[Ze].filter(t=>t.isUserInput?t.isUserInput===1:!t.isUserInput),e}construct(...i){this[Ze]=[],super.construct(...i)}get queue(){return this[Ze].slice(0)}get length(){return this[Ze].length}get filterUserInput(){return this.inputGeneration>0}addAction(i){Array.isArray(i)||(i=[i]),this[Ze].push(...i)}undo(){const i=this[Ze];for(let e=i.length-1;e>=0;--e)i[e].undo()}redo(){const i=this[Ze];for(let e=0,t=i.length;e<t;++e)i[e].redo()}mergeUpdateModelActions(){var i,e,t;const r=this[Ze],n=new Map,s=[];for(const a of r)if(a.isUpdateAction&&((i=a.model)!=null&&i.isModel)){const o=(e=a.isUserInput)!=null?e:0;let l=n.get(a.model);l||(l=[],n.set(a.model,l));const d=l[o];if(!d)l[o]=a,s.push(a);else for(const c in a.oldData)a.newData.hasOwnProperty(c)&&(d.oldData.hasOwnProperty(c)||(d.oldData[c]=a.oldData[c]),d.newData[c]=a.newData[c])}else if(s.push(a),a.isRemoveAction&&((t=a.modelList)!=null&&t.length))for(const o of a.modelList)n.delete(o);this[Ze]=s,this.inputGeneration=Math.max(...s.map(a=>{var o;return(o=a.isUserInput)!=null?o:0}),0)}mergeAddUpdateModelActions(){const i=this[Ze],e=new Set,t=[];for(const r of i)r.isAddAction||r.isInsertAction?r.modelList.forEach(n=>e.add(n)):r.isInsertChildAction&&r.childModels.forEach(n=>e.add(n)),(r.isUpdateAction||r.isEventUpdateAction)&&e.has(r.model)||t.push(r);this[Ze]=t,this.inputGeneration=Math.max(...t.map(r=>{var n;return(n=r.isUserInput)!=null?n:0}),0)}invert(){const i=new this.constructor({...this.initialConfig,title:this.title});return i[Ze]=this[Ze].map(e=>sL(e)).reverse(),i}groupUserInput(){return this[Ze].reduce((i,e)=>{var t;const r=(t=e.isUserInput)!=null?t:"default";return i.has(r)||i.set(r,[]),i.get(r).push(e),i},new Map)}getUserInput(i){const e=new Map,t={},r=this.groupUserInput().get(i!=null?i:this.inputGeneration||"default"),n=(s,a)=>(a in t?s in t[a]||(t[a][s]=[]):t[a]={[s]:[]},t[a][s]);for(const s of r)switch(s.type){case Ft.ADD:case Ft.INSERT:{s.inversed?n("removed",s.store.id).push(...s.modelList):n("added",s.store.id).push(...s.modelList);break}case Ft.REMOVE:case Ft.REMOVE_ALL:{s.inversed?n("added",s.store.id).push(...s.modelList||s.allRecords):n("removed",s.store.id).push(...s.modelList||s.allRecords);break}case Ft.INSERT_CHILD:{const a=(o,l)=>{var d;l.added.includes(o)?n("added",l.id).push(o):l.removed.includes(o)&&n("removed",l.id).push(o),(d=o.children)==null||d.forEach(c=>a(c,l))};for(const o of s.stores)s.childModels.forEach(l=>a(l,o)),o.modified.forEach(l=>{const d=l.hierarchyModificationDataToWrite;d&&(e.has(l)?e.set(l,{...e.get(l),...d}):e.set(l,d))});break}case Ft.REMOVE_CHILD:{let a=function(o,l){o.forEach(d=>{l.push(d),d.children&&a(d.children,l)})};for(const o of s.stores)if(s.inversed){const l=n("added",o.id);a(s.childModels,l)}else{const l=n("removed",o.id);a(s.childModels,l)}break}case Ft.UPDATE:case Ft.EVENT_UPDATE:{e.has(s.model)?e.set(s.model,{...e.get(s.model),...s[s.inversed?"oldData":"newData"]}):e.set(s.model,{...s[s.inversed?"oldData":"newData"]});break}default:break}if(e.size>0&&(t.updated=e),Object.keys(t).length>0)return t}markCurrentTransactionContentUserInput(){const i=this.inputGeneration+1,e=this[Ze];let t=!1;e.forEach(r=>{r.isUserInput===void 0&&!r.isCalculated&&(r.isUserInput=i,t=!0)}),t&&(this.inputGeneration=i)}markCurrentTransactionContentCalculated(){const i=this.inputGeneration;this[Ze].forEach(t=>{t.isCalculated===void 0&&!t.isUserInput&&(t.isCalculated=i)})}normalizeUserInputGeneration(){this[Ze].forEach(i=>i.isUserInput=this.inputGeneration)}};ai._$name="Transaction";var ib=class extends Rn{canUndo(i){return 0<i.position&&i.position<=i.length}canRedo(i){return 0<=i.position&&i.position<i.length}canCheckoutTo(i,e){return i.revisionsEnabled?i[Qe].includes(e)?!0:(console.warn("Revision is not found"),!1):(console.warn("Revisions are disabled"),!1)}onUndo(i,e){let t=i.position;const r=i[Ut],n=Math.max(0,t-e),s=()=>{i.notifyStoresAboutStateRestoringStart();const a=[];for(;t!==n;){const o=r[--t];o.undo(),a.push(o)}return[i.autoRecord?"autoreadystate":"readystate",()=>{i.notifyStoresAboutStateRestoringStop({cause:"undo",transactions:a})}]};return[{[_e]:"restoringstate",[Hi]:n},s]}onRedo(i,e){let t=i.position;const r=i[Ut],n=Math.min(r.length,t+e),s=()=>{i.notifyStoresAboutStateRestoringStart();const a=[];do{const o=r[t++];o.redo(),a.push(o)}while(t!==n);return[i.autoRecord?"autoreadystate":"readystate",()=>{i.notifyStoresAboutStateRestoringStop({cause:"redo",transactions:a})}]};return[{[_e]:"restoringstate",[Hi]:n},s]}onCheckoutTo(i,e){const t=i[Qe].indexOf(e),r=Math.min(t,i[Gt]),n=Math.max(t,i[Gt]),s=t<i[Gt];let a=i[mt].slice(r,n);return s&&(a=a.filter(l=>!l.conflictResolutionFor||l.type===Hr.TEMPORARY).reverse(),i[mt].filter((l,d)=>d>=r&&l.dummy).forEach(l=>{i[mt].splice(i[mt].indexOf(l),1),i[Qe].splice(i[Qe].indexOf(l.title),1)})),[{[_e]:"checkoutstate",[Gt]:t},()=>{i.notifyStoresAboutCheckoutStart();for(const o of a)o[s?"undo":"redo"]()}]}onCheckoutToHead(i){se()}onEnable(){se()}onDisable(){return"disabledstate"}onAutoRecordOn(){return{[_e]:"autoreadystate",[Vi]:!0}}onAutoRecordOff(){se()}onStartTransaction(i,e){const t=new ai({title:e});return[{[_e]:"recordingstate",[Oe]:t},()=>{i.notifyStoresAboutStateRecordingStart(t)}]}onStopTransaction(){se()}onStopTransactionDelayed(){se()}onRejectTransaction(){se()}onResetQueue(i,e){return Qg(i,e)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}},fx=new ib,Jg=fx;si.registerStmState("readystate",fx);var em=class extends Rn{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onEnable(){}onDisable(i){const e=i[Oe];return i.notifyStoresAboutStateRecordingStop(e,{disabled:!0}),{[_e]:"disabledstate",[Oe]:null}}onAutoRecordOn(i){return[{[_e]:"autorecordingstate",[Vi]:!0},()=>{i.stopTransactionDelayed()}]}onAutoRecordOff(){se()}onStartTransaction(){se()}onStopTransaction(i,e){const t=i[Oe],r=i[Ut];let n=i[Hi];return t.length&&(!t.title&&!e&&i.getTransactionTitle?t.title=i.getTransactionTitle(t):e&&(t.title=e),r[n]=t,r.length=++n),[{[_e]:"readystate",[Hi]:n,[Oe]:null},()=>{i.notifyStoresAboutStateRecordingStop(t,{stop:!0})}]}onRejectTransaction(i){const e=i[Oe];return[{[_e]:"restoringstate",[Oe]:null},()=>(e.length&&e.undo(),["readystate",()=>{i.notifyStoresAboutStateRecordingStop(e,{rejected:!0})}])]}onStopTransactionDelayed(){se()}onResetQueue(i,e){return Qg(i,e)}onModelUpdate(i,e,t,r,n){i[Oe].addAction(i.makeModelUpdateAction(e,t,r,n))}onModelInsertChild(i,e,t,r,n,s){const a=i[Oe],o=e.stores.filter(l=>i.stores.includes(l));a.addAction(i.makeModelInsertChildAction(e,t,r,n,s,o))}onModelRemoveChild(i,e,t,r){const n=i[Oe],s=e.stores.filter(a=>i.stores.includes(a));n.addAction(i.makeModelRemoveChildAction(e,t,r,s))}onStoreModelAdd(i,e,t,r){i[Oe].addAction(i.makeStoreModelAddAction(e,t,r))}onStoreModelInsert(i,e,t,r,n,s){const a=i[Oe],o=i.makeStoreModelInsertAction(e,t,r,n,s);o.reportUndoneRemoval=!i.revisionsEnabled,a.addAction(o)}onStoreModelRemove(i,e,t,r,n){i[Oe].addAction(i.makeStoreModelRemoveAction(e,t,r,n))}onStoreRemoveAll(i,e,t,r){i[Oe].addAction(i.makeStoreRemoveAllAction(e,t,r))}},gx=new em,aL=gx;si.registerStmState("recordingstate",gx);var mx=class extends Rn{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){se()}onRedo(){se()}onEnable(){se()}onDisable(){se()}onAutoRecordOn(){return{[Vi]:!0}}onAutoRecordOff(){return{[Vi]:!1}}onStartTransaction(){se()}onStopTransaction(){se()}onStopTransactionDelayed(){se()}onRejectTransaction(){se()}onQueueReset(){se()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};p(mx,"$name","RestoringStateClass");var px=new mx,vx=px;si.registerStmState("restoringstate",px);var oL=class extends ib{onAutoRecordOn(){se()}onAutoRecordOff(){return{[_e]:"readystate",[Vi]:!1}}onStartTransaction(i,e){const t=new ai({title:e});return[{[_e]:"autorecordingstate",[Oe]:t},()=>{i.notifyStoresAboutStateRecordingStart(t),i.stopTransactionDelayed()}]}onModelUpdate(i,e,t,r){i.startTransaction(),i.onModelUpdate(e,t,r)}onModelInsertChild(i,e,t,r,n){i.startTransaction(),i.onModelInsertChild(e,t,r,n)}onModelRemoveChild(i,e,t,r){i.startTransaction(),i.onModelRemoveChild(e,t,r)}onStoreModelAdd(i,e,t,r){i.startTransaction(),i.onStoreModelAdd(e,t,r)}onStoreModelInsert(i,e,t,r,n,s){i.startTransaction(),i.onStoreModelInsert(e,t,r,n,s)}onStoreModelRemove(i,e,t,r,n){i.startTransaction(),i.onStoreModelRemove(e,t,r,n)}onStoreRemoveAll(i,e,t,r){i.startTransaction(),i.onStoreRemoveAll(e,t,r)}},yx=new oL,rb=yx;si.registerStmState("autoreadystate",yx);var lL=class extends em.mixin(be){onDisable(i){const e=i[Oe],t=i[Ei];return t&&this.clearTimeout(t),i.notifyStoresAboutStateRecordingStop(e,{disabled:!0}),{[_e]:"disabledstate",[Oe]:null,[Ei]:null}}onAutoRecordOn(i){se()}onAutoRecordOff(i){const e=i[Ei];return e&&this.clearTimeout(e),{[_e]:"recordingstate",[Vi]:!1,[Ei]:null}}onStopTransaction(i,e){const t=i[Oe],r=i[Ei],n=i[Ut];let s=i[Hi];return r&&this.clearTimeout(r),t.length&&(!t.title&&!e&&i.getTransactionTitle?t.title=i.getTransactionTitle(t):e&&(t.title=e),n[s]=t,n.length=++s),[{[_e]:"autoreadystate",[Hi]:s,[Oe]:null,[Ei]:null},()=>{i.notifyStoresAboutStateRecordingStop(t,{stop:!0})}]}onStopTransactionDelayed(i){let e=i[Ei];return e&&this.clearTimeout(e),e=this.setTimeout(()=>{i.stopTransaction()},i.autoRecordTransactionStopTimeout),{[_e]:nb,[Ei]:e}}onResetQueue(i,e){return Qg(i,e)}onRejectTransaction(i){const e=i[Oe],t=i[Ei];return t&&this.clearTimeout(t),[{[_e]:"restoringstate",[Oe]:null,[Ei]:null},()=>(e.length&&e.undo(),["autoreadystate",()=>{i.notifyStoresAboutStateRecordingStop(e,{rejected:!0})}])]}onModelUpdate(i,...e){super.onModelUpdate(i,...e),i.stopTransactionDelayed()}onModelInsertChild(i,...e){super.onModelInsertChild(i,...e),i.stopTransactionDelayed()}onModelRemoveChild(i,...e){super.onModelRemoveChild(i,...e),i.stopTransactionDelayed()}onStoreModelAdd(i,...e){super.onStoreModelAdd(i,...e),i.stopTransactionDelayed()}onStoreModelInsert(i,...e){super.onStoreModelInsert(i,...e),i.stopTransactionDelayed()}onStoreModelRemove(i,...e){super.onStoreModelRemove(i,...e),i.stopTransactionDelayed()}onStoreRemoveAll(i,...e){super.onStoreRemoveAll(i,...e),i.stopTransactionDelayed()}},nb=new lL,dL=nb;si.registerStmState("autorecordingstate",nb);var cL=class extends ib{canUndo(i){return!1}canRedo(i){return!1}onUndo(i){se()}onRedo(i){se()}onStartRevision(i,e){const t=new ai({title:e});return[{[_e]:"revisionrecordingstate",[Oe]:t},()=>{i.notifyStoresAboutRevRecordingStart()}]}onStartTemporaryRevision(i,e,t){const r=new ai({title:e});return t&&(r[Ze]=t[Ze].slice()),[{[_e]:"temporaryrevisionrecordingstate",[Oe]:r},()=>{i.notifyStoresAboutTempRevRecordingStart()}]}onCheckoutToHead(i){return i.notifyStoresAboutCheckoutToHead({revision:i[Qe][i[Qe].length-1]}),i.autoRecord?"autoreadystate":"readystate"}onStartTransaction(i){se()}onStopTransaction(i){se()}onStopTransactionDelayed(i){se()}onRejectTransaction(i){se()}onEnable(i){se()}onDisable(i){se()}onAutoRecordOn(i){se()}onAutoRecordOff(i){se()}onResetQueue(i){se()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}},bx=new cL,sb=bx;si.registerStmState("checkoutstate",bx);var uL=class extends em{canUndo(i){return!1}canRedo(i){return!1}canCheckoutTo(){return!1}onUndo(i){se()}onRedo(i){se()}onCheckoutToHead(i){se()}onStopRevision(i,e){const t=i[Oe],r=i[mt],n=i[Qe],s=i[Gt]+1,a=ai.createTransactionWithOriginalInput(t);return n.splice(s,0,a.title),r.splice(s-1,0,a),i.commitRevision(a.title),[{[_e]:"checkoutstate",[Gt]:s,[Oe]:null},()=>{i.notifyStoresAboutRevRecordingStop(a)}]}onStartTransaction(i){se()}onStopTransaction(i){se()}onStopTransactionDelayed(i){se()}onRejectTransaction(i){se()}onEnable(i){se()}onDisable(i){se()}onAutoRecordOn(i){se()}onAutoRecordOff(i){se()}onResetQueue(i){se()}},Cx=new uL,Sx=Cx;si.registerStmState("revisionrecordingstate",Cx);var hL=class extends em{canUndo(i){return!1}canRedo(i){return!1}canCheckoutTo(){return!1}onUndo(i){se()}onRedo(i){se()}onCheckoutToHead(i){se()}onStopRevision(i,e){const t=i[Oe];return[{[_e]:"checkoutstate",[Oe]:null},()=>{i.notifyStoresAboutTempRevRecordingStop(t)}]}onStartTransaction(i){se()}onStopTransaction(i){se()}onStopTransactionDelayed(i){se()}onRejectTransaction(i){se()}onEnable(i){se()}onDisable(i){se()}onAutoRecordOn(i){se()}onAutoRecordOff(i){se()}onResetQueue(i){se()}},wx=new hL,Dx=wx;si.registerStmState("temporaryrevisionrecordingstate",wx);var Je=(i,e,...t)=>{const r=i.state,n=e.call(i[_e],i,...t);if(typeof n=="string")i[_e]=si.resolveStmState(n);else if(n instanceof Rn)i[_e]=n;else if(Array.isArray(n)){const[s,a]=n;typeof s=="string"?i[_e]=si.resolveStmState(s):s instanceof Rn?i[_e]=s:s&&typeof s=="object"&&(i=Object.assign(i,s),i[_e]=si.resolveStmState(i[_e])),typeof a=="function"&&Je(i,a,...t)}else n&&typeof n=="object"&&(i=Object.assign(i,n),i[_e]=si.resolveStmState(i[_e]));r!==Jg&&r!==rb&&n!==Jg&&n!==rb&&i.trigger("ready")},Vr=class extends Ie(O){construct(...i){Object.assign(this,{[_e]:Jg,[Tn]:[],[Ut]:[],[Hi]:0,[Oe]:null,[Ei]:null,[Vi]:!1,[Mu]:!1,stashedTransactions:{}}),super.construct(...i)}get state(){return this[_e]}get position(){return this[Hi]}get length(){return this[Ut].length}get stores(){return Array.from(this[Tn])}hasStore(i){return this[Tn].includes(i)}addStore(i){this.hasStore(i)||(this[Tn].push(i),i.stm=this,i.forEach(e=>e.stm=this),i.isTree&&(i.rootNode.stm=this))}removeStore(i){this.hasStore(i)&&(this[Tn]=this[Tn].filter(e=>e!==i),i.stm=null,i.forEach(e=>e.stm=null))}forEachStore(i){this[Tn].forEach(e=>i(e,e.id))}get disabled(){return this.state===Zk}changeDisabled(i){if(this.disabled!==i)return i}updateDisabled(i){const e=this;i?Je(e,e.state.onDisable,e):Je(e,e.state.onEnable,e),e.trigger("stmDisabled",{disabled:i}),e.trigger("disabled",{disabled:i})}get enabled(){return!this.disabled}enable(){this.disabled=!1}disable(){this.disabled=!0}get isReady(){return this.state===Jg||this.state===rb}waitForReadiness(){return this.await("ready",!1)}get isRecording(){return this.state===aL||this.state===dL}get isApplyingStash(){return this[Mu]}get shouldRecordAction(){return this.enabled&&(!this.isRestoringState||this.isApplyingStash)&&!this.isCheckingOut}get autoRecord(){return this[Vi]}changeAutoRecord(i){if(this.autoRecord!==i)return i}updateAutoRecord(i){const e=this;i?Je(e,e.state.onAutoRecordOn,e):Je(e,e.state.onAutoRecordOff,e)}startTransaction(i=null){Je(this,this.state.onStartTransaction,i)}stopTransaction(i=null){const e=this;e.autoRecord&&e.autoRecordMergeUpdateActions&&e.mergeTransactionUpdateActions(),e.mergeAddUpdateActions&&e.mergeTransactionAddUpdateActions(),Je(e,e.state.onStopTransaction,i)}stopTransactionDelayed(){Je(this,this.state.onStopTransactionDelayed)}rejectTransaction(){Je(this,this.state.onRejectTransaction)}get transaction(){return this[Oe]}get queue(){return this[Ut].map(i=>i.title)}get rawQueue(){return this[Ut]}get isRestoringState(){return this.state===vx}get isRestoring(){return this.state===vx||this.isApplyingStash||this.isNavigatingRevisions}get canUndo(){return this.state.canUndo(this)}get canRedo(){return this.state.canRedo(this)}async undo(i=1){this.isReady||await this.waitForReadiness(),Je(this,this.state.onUndo,i)}async undoAll(){this.isReady||await this.waitForReadiness(),this.undo(this.length)}async redo(i=1){this.isReady||await this.waitForReadiness(),Je(this,this.state.onRedo,i)}async redoAll(){this.isReady||await this.waitForReadiness(),this.redo(this.length)}resetQueue(i={undo:!0,redo:!0,revision:!0}){Je(this,this.state.onResetQueue,i)}resetUndoQueue(){this.resetQueue({undo:!0})}resetRedoQueue(){this.resetQueue({redo:!0})}resetRevisionQueue(){this.resetQueue({revision:!0})}notifyStoresAboutStateRecordingStart(i){this.forEachStore(e=>{var t;return(t=e.onStmRecordingStart)==null?void 0:t.call(e,this,i)}),this.trigger("recordingStart",{stm:this,transaction:i})}notifyStoresAboutStateRecordingStop(i,e){const t=this;t.forEachStore(r=>{var n;return(n=r.onStmRecordingStop)==null?void 0:n.call(r,t,i,e)}),t.trigger("recordingStop",{stm:t,transaction:i,reason:e}),t.revisionsEnabled&&e.stop&&t.increaseRevision(ai.from([i]))}notifyStoresAboutStateRestoringStart(){this.forEachStore(i=>{var e;return(e=i.onStmRestoringStart)==null?void 0:e.call(i,this)}),this.trigger("restoringStart",{stm:this})}notifyStoresAboutStateRestoringStop({cause:i,transactions:e}){const t=this;if(t.forEachStore(r=>{var n;return(n=r.onStmRestoringStop)==null?void 0:n.call(r,t)}),t.trigger("restoringStop",{stm:t,cause:i,transactions:e}),t.revisionsEnabled)if(t.asyncUndoRedo){const r=()=>{const n=ai.from(e);t.increaseRevision(i==="undo"?n.invert():n)};t.trigger("increaseRevisionAsync",{callback:r})}else{const r=ai.from(e);t.increaseRevision(i==="undo"?r.invert():r)}}notifyStoresAboutQueueReset(i){this.forEachStore(e=>{var t;return(t=e.onStmQueueReset)==null?void 0:t.call(e,this,i)}),this.trigger("queueReset",{stm:this,options:i})}notifyStoresAboutCheckoutStart(){this.trigger("checkoutStart",{stm:this})}notifyStoresAboutRevRecordingStart(){this.trigger("revisionRecordingStart",{stm:this})}notifyStoresAboutTempRevRecordingStart(){this.trigger("temporaryRevisionRecordingStart",{stm:this})}notifyStoresAboutRevRecordingStop(i){this.trigger("revisionRecordingStop",{stm:this,revision:i.title})}notifyStoresAboutTempRevRecordingStop(i){this.trigger("temporaryRevisionRecordingStop",{stm:this,revision:i.title})}notifyStoresAboutCheckoutToHead({revision:i}){this.trigger("checkoutToHead",{stm:this,revision:i})}onModelUpdate(i,e,t,r){Je(this,this.state.onModelUpdate,i,e,t,r)}onModelInsertChild(i,e,t,r,n){Je(this,this.state.onModelInsertChild,i,e,t,r,n)}onModelRemoveChild(i,e,t){Je(this,this.state.onModelRemoveChild,i,e,t)}onStoreModelAdd(i,e,t){Je(this,this.state.onStoreModelAdd,i,e,t)}onStoreModelInsert(i,e,t,r,n){Je(this,this.state.onStoreModelInsert,i,e,t,r,n)}onStoreModelRemove(i,e,t,r){Je(this,this.state.onStoreModelRemove,i,e,t,r)}onStoreRemoveAll(i,e,t){Je(this,this.state.onStoreRemoveAll,i,e,t)}onUndoKeyPress(i){const e=this;e.enabled&&(i.shiftKey?e.canRedo&&(i.preventDefault(),e.redo()):e.canUndo&&(i.preventDefault(),e.undo()))}stash(){const i=this;if(i.transaction){const e=$i.generateId("_stashedTransactionGeneratedId_");return i.stashedTransactions[e]=i.transaction,i.rejectTransaction(),e}}applyStash(i){const e=this,t=e.stashedTransactions[i];e[Mu]=!0,t&&(e.startTransaction(t.title),t.redo(),delete e.stashedTransactions[i]),e[Mu]=!1}mergeTransactionUpdateActions(i=this.transaction){i.mergeUpdateModelActions()}mergeTransactionAddUpdateActions(i=this.transaction){i.mergeAddUpdateModelActions()}canCheckoutTo(i){return(this.isReady||this.state===sb)&&this.state.canCheckoutTo(this,i)}get currentRevision(){if(this.revisionsEnabled)return this[Qe][this[Gt]]}get lastRevision(){if(this.revisionsEnabled)return this[Qe][this[Qe].length-1]}get currentRevisionTransaction(){if(this.revisionsEnabled)return this[mt][this[Gt]-1]}get lastCommittedRevision(){const i=this[mt];let e;for(let t=i.length-1;t>=0;t--)if(i[t].committed){e=i[t];break}return e}get lastCommittedRevisionId(){var i,e;return(e=(i=this.lastCommittedRevision)==null?void 0:i.title)!=null?e:this[Qe][0]}get localRevisions(){return this[mt].slice(this[mt].findIndex(i=>!i.committed))}get isCheckingOut(){return this.state===sb}get isRecordingRevision(){return this.state===Sx}get isRecordingTemporaryRevision(){return this.state===Dx}get isNavigatingRevisions(){return this.state===sb||this.state===Sx||this.state===Dx}initRevision(i,e=!0){const t=this;t.revisionsEnabled&&(t.autoRecord=e,t[Qe]=[i],t[mt]=[],t[Gt]=0)}increaseRevision(i,e){const t=this;let r;if(!(Qe in t))throw new Error("Revisions should be initialized first with `project.initRevisions(<client id>)` call");if(!t.revisionsEnabled)return;if(t.isNavigatingRevisions&&!i.type)throw new Tu("Cannot add new revision when in the checkout state");if(!i[Ze].length&&!i.type)return;const n=$i.generateId(t.revisionLocalPrefix);i.title=n;const s=i.type===Hr.CONFLICT_RESOLUTION;if(t.trigger("beforeRevisionAdd",{localRevisionId:n,isConflictResolution:s})===!1)return;const a=i.conflictResolutionFor&&t[mt].find(l=>l.type===Hr.TEMPORARY&&l.conflictResolutionFor===i.conflictResolutionFor);if(a?(t[Qe].splice(t[Qe].indexOf(a.title),1,n),t[mt].splice(t[mt].indexOf(a),1,i)):(t[Qe].push(n),t[mt].push(i)),i.conflictResolutionFor||(t[Gt]=t[Qe].length-1),i.type===Hr.TEMPORARY)return;i.filterUserInput&&(i.conflictResolutionFor||i.normalizeUserInputGeneration(),r=i.getUserInput()),!e&&t[mt].length>t.revisionQueueMaxLength&&!i.type&&t.cleanUpRevisions();const o={localRevisionId:n,userInput:r};i.conflictResolutionFor&&(o.conflictResolutionFor=i.conflictResolutionFor,o.revisionChanges=e),t.trigger("revisionAdd",o)}createDataCorrectionTransaction(){const i=new ai({type:Hr.DATA_CORRECTION});this.increaseRevision(i)}createConflictResolutionRevision(i,e,t){const{transaction:r}=this;if(t=T.clone(t),e){const n=this[mt].find(s=>s.conflictResolutionFor===e);n&&(n.conflictResolutionFor=i)}this.increaseRevision(ai.from([r],{conflictResolutionFor:i!=null?i:r.title,type:Hr.CONFLICT_RESOLUTION}),t)}createTemporaryConflictResolutionRevision(i,e){const{transaction:t}=this;this.increaseRevision(ai.from([t],{conflictResolutionFor:i!=null?i:t.title,type:Hr.TEMPORARY}),e)}checkoutTo(i){if(!this.canCheckoutTo(i))return!1;Je(this,this.state.onCheckoutTo,i)}checkoutToLastCommittedRevision(){this.checkoutTo(this.lastCommittedRevisionId)}checkoutToHead(){this.checkoutTo(this[Qe][this[Qe].length-1]),Je(this,this.state.onCheckoutToHead)}checkoutToNext(){return this[Gt]+1<this[Qe].length?this.checkoutTo(this[Qe][this[Gt]+1]):!1}startRevision(i){Je(this,this.state.onStartRevision,i)}stopRevision(){Je(this,this.state.onStopRevision)}startTemporaryRevision(i,e){Je(this,this.state.onStartTemporaryRevision,i,e)}stopTemporaryRevision(){Je(this,this.state.onStopRevision)}commitRevision(i,e){const t=this[Qe],r=this[mt],n=r.find(s=>s.title===i);for(let s=r.indexOf(n)-1;s>=0;s--)if(r[s].committed===!1&&r[s].type!==Hr.TEMPORARY&&!r[s].conflictResolutionFor)throw new Tu(`Cannot commit revision because it is preceded by an uncommitted rev id ${r[s].title}`,r);if(e){if(t.includes(e))throw new Tu(`Proposed revision id (${e}) already exists`);n.title=t[t.indexOf(n.title)]=e,r.forEach(s=>{s.type===Hr.TEMPORARY&&s.conflictResolutionFor===i&&(s.conflictResolutionFor=e)})}n.committed=!0}cleanUpRevisions(i=this.revisionQueueCommittedMinLength){const e=this[Qe],t=this[mt],r=[];for(let n=0;n<t.length;n++){const s=t[n];if(s.committed)r.push(s);else break}r.splice(Math.max(0,r.length-1-i),Math.min(r.length,i)),t.splice(0,r.length),e.splice(1,r.length)}markCurrentTransactionContentUserInput(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentUserInput()}markCurrentTransactionContentCalculated(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentCalculated()}};p(Vr,"$name","StateTrackingManager"),p(Vr,"configurable",{disabled:!0,autoRecord:!1,autoRecordTransactionStopTimeout:100,autoRecordMergeUpdateActions:!0,mergeAddUpdateActions:!1,makeModelUpdateAction:Qk,makeModelInsertChildAction:Jk,makeModelRemoveChildAction:eL,makeStoreModelAddAction:tL,makeStoreModelInsertAction:iL,makeStoreModelRemoveAction:rL,makeStoreRemoveAllAction:nL,getTransactionTitle:null,revisionsEnabled:!1,asyncUndoRedo:!1,revisionLocalPrefix:"local-",revisionQueueMaxLength:20,revisionQueueCommittedMinLength:1}),Vr._$name="StateTrackingManager";var Ex=i=>{var e;return e=class extends(i||O){changeStm(t,r){var n;return(n=r==null?void 0:r.hasStore)!=null&&n.call(r,this)&&r.removeStore(this),t&&(t.isStateTrackingManager||(t=new Vr(t)),t.hasStore(this)||t.addStore(this)),t}add(t,r=!1,n={}){let s;const{stm:a}=this;return!this.tree&&(a!=null&&a.shouldRecordAction)?(s=super.add(t,r,n),s!=null&&s.length&&a.onStoreModelAdd(this,s,r)):s=super.add(t,r,n),s}insert(t,r,n=!1){let s;const{stm:a}=this;if(!this.tree&&(a!=null&&a.shouldRecordAction)){const o=(Array.isArray(r)?r:[r]).reduce((l,d)=>{const c=d instanceof me?this.indexOf(d):void 0;return c!==void 0&&c!==-1&&l.set(d,c),l},new Map);s=super.insert(t,r),s!=null&&s.length&&(t=this.indexOf(s[0]),a.onStoreModelInsert(this,t,s,o,n))}else s=super.insert(t,r,n);return s}remove(t,r=!1,n){let s;const{stm:a}=this;if(!this.tree&&(a!=null&&a.shouldRecordAction)){const l=(Array.isArray(t)?t:[t]).map(d=>this.getById(d)).filter(d=>!!d).reduce((d,c)=>{const u=this.indexOf(c);return u!==void 0&&u!==-1&&d.set(c,u),d},new Map);s=super.remove(t,r,n),s!=null&&s.length&&a.onStoreModelRemove(this,s,l,r)}else s=super.remove(t,r,n);return s}removeAll(t){const{stm:r}=this;let n;if(r!=null&&r.shouldRecordAction){const{tree:s,rootNode:a,allRecords:o}=this,l=o.length,d=s?a.children.slice():o.slice();n=super.removeAll(t),l&&this.count===0&&r.onStoreRemoveAll(this,d,t)}else n=super.removeAll(t);return n}beforeApplyChangeset(){const{stm:t,crudManager:r}=this;let n=!1,s=null;return!(r!=null&&r.applyingChangeset)&&(t!=null&&t.enabled)&&!t.isNavigatingRevisions&&(n=!0,t.isRecording&&(s=t.stash()),this.ignoreRemoteChangesInSTM?t.disable():t.startTransaction()),{shouldResume:n,transactionId:s}}applyChangeset(t,...r){const{shouldResume:n,transactionId:s}=this.beforeApplyChangeset(),a=super.applyChangeset(t,...r);return this.afterApplyChangeset(n,s),a}afterApplyChangeset(t,r){if(t){const{stm:n}=this;this.ignoreRemoteChangesInSTM?n.enable():n.stopTransaction(),n.applyStash(r)}}},p(e,"$name","StoreStm"),p(e,"configurable",{stm:null,ignoreRemoteChangesInSTM:!1}),e},qs=class{static new(i){return new this(i)}constructor(i){this.promise=new Promise((e,t)=>{this.resolve=e,this.reject=t}),i&&i(this)}catch(i){return this.promise=this.promise.catch(i),this}finally(i){return this.promise=this.promise.finally(i),this}then(...i){return this.promise=this.promise.then(...i),this}};qs._$name="Promissory";var $o=class extends ie.mixin(be){static get pluginConfig(){return{override:["updateAutoLoad","performDataRequest"],assign:["load","isLoading","lazyGetAt","unload"],after:["afterLoadData"],before:["setStoreData","destroy"]}}static get properties(){return{loadQueue:{}}}get isLoading(){return this.client._isLoading||Object.values(this.loadQueue).some(i=>T.isPromise(i))}get storage(){return this.client.storage}set totalCount(i){this._totalCount=i}get totalCount(){return this._totalCount}setEstimatedTotalCount(i){this.totalCount=i}afterConstruct(){const i=this,{client:e}=i;e.syncDataOnLoad&&(e.syncDataOnLoad=!1),i.storeListenersDetacher=e.ion({beforeAdd:"internalOnBeforeAdd",beforeRemove:"internalOnBeforeAdd",change:"internalOnChange",commit:"internalOnCommit",endApplyChangeset:"internalOnCommit",appliedCrudChangesToStore:"internalOnCommit",thisObj:i}),e.requestData||(e.requestData=i.requestData),e.autoLoad&&!e.readUrl&&this.requestAnimationFrame(this.doAutoLoad)}updateAutoLoad(i){i&&!this.client.readUrl&&this.doAutoLoad()}internalOnBeforeAdd(){if(this.isLoading)throw new Error("Removing or adding is not allowed when a lazy loaded Store is loading")}internalOnChange(){!this.$loadLock&&(this.client.added.count||this.client.removed.count)&&(this.$loadLock=new qs)}internalOnCommit(){!this.client.changes&&this.$loadLock&&(this.$loadLock.resolve(),this.$loadLock=null)}performDataRequest(){return this.load()}afterLoadData(){this.totalCount&&(this.storage.values.length=this.totalCount)}setStoreData(i){!(i!=null&&i.length)&&this.client.records.some(Boolean)&&this.clear()}clear(){this.totalCount=null,this.loadQueue={}}async requestData({startIndex:i,count:e}){}lazyGetAt(i){return this.getAt(i)}async getAt(i){var e;const t=this,{loadQueue:r,totalCount:n}=t;if(i<0||n!=null&&i>n)return null;const s=t.getFromStorage(i);if(s)return s;if(await((e=t.$loadLock)==null?void 0:e.promise),!t.isDestroyed)return r[i]?await r[i]:await t.doLazyLoad(t.calculateRange(i)),t.getFromStorage(i)}getFromStorage(i){return this.storage.getAt(i)}calculateRange(i){const{totalCount:e,loadQueue:t,chunkSize:r}=this,n=Math.max(0,i-r),s=(e?Math.min(i+r,e):i+r)-1;let a=i,o=i;for(;a>n&&!t[a-1]&&!this.getFromStorage(a-1);)a-=1;for(;o<s&&!t[o+1]&&!this.getFromStorage(o+1);)o+=1;return{startIndex:a,count:o-a+1}}async doLazyLoad({isReload:i,...e}){const t=this;t.triggerLazyLoadStart(arguments[0]),i&&(t.clear(),t.$isCrudManager&&(e.isReload=!0));const{loadQueue:r,client:n}=t,{startIndex:s,count:a}=e,o=s+a-1,l=n.requestData(n.readUrl?e:n.buildRemoteParams(e));for(let h=s;h<=o;h++)r[h]=l;const d=await l;if(!d)return;const{[t.totalCountProperty]:c,[t.dataProperty]:u}=d;for(let h=s;h<=o;h++)r[h]=null;c!=null?t.totalCount=c:t.totalCount==null&&a>u.length&&t.setEstimatedTotalCount(s+u.length),t.addData(u,s,i),t.totalCount!=null&&(t.storage.values.length=t.totalCount),i&&(t._isReloading=!1),t.triggerLazyLoadEnd(arguments[0],u)}addData(i,e,t){var r;const{client:n,storage:s}=this;if(!(i!=null&&i.length)&&!t)return;if(this.pauseStm(),(!n.count||t)&&!e){n.data=i;return}for(let l=i.length-1;l>=0;l--){const d=i[l],c=n.idRegister[d.id];c&&(c.setByDataSource(d,!0),c.internalClearChanges(!1,!0,d),i.splice(l,1))}if(!i.length)return;const{values:a}=s,o=i.map(l=>n.processRecord(n.createRecord(l),!0));a.length<e&&(a.length=e),e==null&&(e=a.length),a.splice(e,o.length,...o),n.joinRecordsToStore(o),(r=this.processAddedRecords)==null||r.call(this,o),n.updateDependentStores("add",o);for(const l of o)n.idMap[l.id]={index:e,visibleIndex:e,record:l},e+=1,s.addToIndices(l);n.trigger("change",{action:"lazyload",records:o}),this.resumeStm()}checkDuplicates(i){const{storage:e}=this;for(const t of i){const r=e.indexOf(t.id);r>=0&&e.values.splice(r,1)}}triggerLazyLoadStart(i){const e=this;e.isLoading||(e.isConfiguring?e.delay(()=>e.trigger("lazyLoadStarted",{...i}),0):e.client.trigger("lazyLoadStarted",{...i})),e.client.trigger("beforeLazyLoad",{...i})}triggerLazyLoadEnd(i,e){this.isLoading||this.client.trigger("lazyLoadEnded"),this.client.trigger("afterLazyLoad",{...i,data:e})}load(i){const e=this,t=!T.isEmpty(e.loadQueue);return e._loadedOnce=!0,e._isReloading=t,e.doLazyLoad({isReload:t,startIndex:0,count:e.chunkSize,...i})}unload({records:i,...e}){if(this.$isCrudManager){console.warn("It is not supported to unload records from the Store when using a lazy loaded CrudManager");return}const{client:t}=this;for(let r of L.asArray(i))r.isModel||(r=t.getById(r)),this.internalUnloadRecord({record:r,...e});t.trigger("refresh",{action:"lazyload"})}internalUnloadRecord({record:i}){const{loadQueue:e,client:t}=this,{id:r}=i,n=t.indexOf(r);e[r]&&(e[r]=void 0),n>=0&&(t.records[n]=void 0,i.unjoinStore(t))}pauseStm(){const{stm:i}=this.client;i!=null&&i.enabled&&i.autoRecord&&(this.$stmIsPaused=!0,i.disable())}async resumeStm(i){const{stm:e}=this.client;this.$stmIsPaused&&(this.$stmIsPaused=!1,await i,e.disabled&&e.enable())}doAutoLoad(){this._loadedOnce||this.load()}destroy(){var i;(i=this.storeListenersDetacher)==null||i.call(this),this.clear(),super.destroy()}};p($o,"$name","StoreLazyLoadPlugin"),p($o,"configurable",{totalCountProperty:"total",dataProperty:"data",chunkSize:100}),$o._$name="StoreLazyLoadPlugin";var xx=i=>{var e,t;return(t=(e=i.children)==null?void 0:e.reduce((r,n)=>{var s;return r+((s=n.remoteChildCount)!=null?s:0)+1},0))!=null?t:0},ab=i=>xx(i)>=i.remoteChildCount,fL=i=>{var e;return e=class extends i{static get pluginConfig(){var t,r;const n={};for(const a in super.pluginConfig)n[a]=[...super.pluginConfig[a]];n.override=(t=n.override)!=null?t:[],n.override.push("loadChildren","getAt");const s=(r=n.assign)==null?void 0:r.indexOf("lazyGetAt");return s>=0&&n.assign.splice(s,1),n}constructor(...t){super(...t),this.totalCount=0}async load(t){const r=this,n=r._loadedOnce;return r.client.autoLoad&&!n&&await new Promise(s=>r.requestAnimationFrame(s)),r._loadedOnce=!0,r._isReloading=n,r.doLazyLoad({parent:r.client.rootNode,isReload:n,startIndex:0,...t})}changeRemoteChildCount(t,r,n){var s;if(t!=null&&t.length){const a=t.map(o=>{var l,d,c;return(c=o.parent)!=null?c:this.client.getById((d=o.parentId)!=null?d:(l=o.originalData)==null?void 0:l.parentId)});for(;a.length;){const o=a.shift();o&&(o.isRoot||a.push(o.parent),o.set("remoteChildCount",(s=o.remoteChildCount?o.remoteChildCount+r:o.children.length)!=null?s:0,!0),n==null||n.add(o))}}}internalOnCommit({changes:t}){const r=this,{$loadLock:n,client:s}=r;if(n!=null&&n.size&&[...n.keys()].forEach(a=>{!s.added.some(o=>o.parent===a)&&!s.removed.some(o=>o.parent===a)&&(n.get(a).resolve(),n.delete(a))}),r.$legacyCountMode){const a=new Set;r.changeRemoteChildCount(t.added,1,a),r.changeRemoteChildCount(t.removed,-1,a),a.forEach(o=>{o.isFullyLoaded=ab(o)})}}internalOnChange(){const{$loadLock:t=this.$loadLock=new Map}=this,{added:r,removed:n}=this.client;(r.count||n.count)&&[...new Set(r.map(a=>a.parent).concat(n.map(a=>a.parent)))].forEach(a=>!t.get(a)&&t.set(a,new qs))}async loadChildren(t){return this.doLazyLoad({parent:t,startIndex:0})}getAt(t){const r=this.client.records[t];return r&&!this._isReloading&&this.loadMoreChildren(r),r}async loadMoreChildren(t){var r,n,s,a;const o=this,{parent:l}=t;if(t.expanded&&!((r=t.children)!=null&&r.length)&&!t.isFullyLoaded&&!o.loadQueue[t.id]&&o.doLazyLoad({parent:t,startIndex:0}),t===l.lastChild&&!l.isFullyLoaded&&!o.loadQueue[l.id]){const d=(n=o.$loadLock)==null?void 0:n.get(l);if(d){const c=l.instanceMeta(o.client);if(c.isLoadingChildren=!0,await d.promise,o.isDestroyed)return;if(l.isFullyLoaded){c.isLoadingChildren=!1,(a=(s=o.client).trigger)==null||a.call(s,"refresh",{action:"lazyload"});return}}o.doLazyLoad({startIndex:t.parentIndex+1,parent:l})}}async doLazyLoad({parent:t,isReload:r,...n}){var s,a;r&&this.clear();const o=this,{client:l}=o,{id:d}=t;if(o.isDestroyed)return;t.instanceMeta(l).isLoadingChildren=!0,o.triggerLazyLoadStart(arguments[0]);const c=o.loadQueue[d]=l.requestData({...l.readUrl?n:l.buildRemoteParams(n),parentId:t.isRoot?"root":d,count:o.chunkSize,...o.$isCrudManager&&{isReload:r}}),{[o.totalCountProperty]:u,[o.dataProperty]:h,...f}=await c;o.isDestroyed||o.loadQueue[d]!==c||(delete o.loadQueue[d],t.isRoot&&h.length&&o.$legacyCountMode===void 0&&(o.$legacyCountMode=h[0].remoteChildCount>=0)&&!te.isTestEnv&&te.deprecate("core","7.0.0","remoteChildCount is deprecated in favor of autodetection and the isFullyLoaded field"),t.isRoot&&u>=0&&o.$legacyCountMode&&t.set("remoteChildCount",u,!0),o.addData(h,t,r),t.set("isFullyLoaded",(s=f.isFullyLoaded)!=null?s:o.$legacyCountMode?ab(t):h.length<o.chunkSize,!0),o.totalCount=l.count,r&&(o._isReloading=!1),o.isLoading||(a=l.trigger)==null||a.call(l,"refresh",{action:"lazyload"}),o.triggerLazyLoadEnd(arguments[0],h),t.instanceMeta(l).isLoadingChildren=!1)}addData(t,r,n){const{client:s,$legacyCountMode:a}=this,o=[];if(s.modelClass.fieldMap.isFullyLoaded||s.modelClass.addField({name:"isFullyLoaded",persist:!1}),a&&(s.modelClass.fieldMap.remoteChildCount||s.modelClass.addField("remoteChildCount"),!t.length)){const l=xx(r),d=r.remoteChildCount-l;d!==0&&(r.set("remoteChildCount",l,!0),this.changeRemoteChildCount([r],d))}or.preWalk({children:t,$fake:!0},({children:l})=>l!=null&&l.length?l:null,l=>{var d,c,u;const{expanded:h}=l;l.$fake||o.push(l),(h!=null&&!a||l.children||l.remoteChildCount>0)&&((d=this.$removedDescendants)==null||d.forEach(f=>{var g,m;f.parentId===l.id&&!((m=(g=l.children)==null?void 0:g.some)!=null&&m.call(g,v=>v.id===f.id))&&(l.children.push(f),o.push(f),f.meta.parentWasFullyLoaded&&(l.isFullyLoaded=!0))}),h===!1&&!((c=l.children)!=null&&c.length)?l.children=!0:a&&((u=l.children)!=null&&u.length)&&!l.isFullyLoaded&&ab(l)?l.isFullyLoaded=!0:l.children||(l.children=[]))}),n?s.data=t:(r.appendChild(t,!0),s.added.remove(o))}unload(){super.unload(...arguments),this.client.trigger("refresh",{action:"lazyload"})}internalUnloadRecord({record:t,includeDescendants:r,cacheDescendants:n}){var s;if(!t.isParent)return;const a=this,{loadQueue:o,client:l,$removedDescendants:d=a.$removedDescendants=[]}=a;if((s=t.children)!=null&&s.length){t.traverse(u=>a.internalUnloadRecord({record:u,includeDescendants:r,cacheDescendants:!r}),!0);const c=[...t.children];t.clearChildren(!0),l.removed.remove(c),n&&(d.push(...c),c[0].meta.parentWasFullyLoaded=t.isFullyLoaded)}t.isFullyLoaded=!1,o[t.id]=void 0}},p(e,"$name","TreeStoreLazyLoadPlugin"),p(e,"configurable",{chunkSize:50}),e},gL={splice:1,clear:1},mL={includeFilteredOutRecords:!1,includeCollapsedGroupRecords:!1},ob=(i,e)=>(e=e||!1,typeof e=="boolean"&&(e={includeFilteredOutRecords:e,includeCollapsedGroupRecords:!1}),e||mL),tm=Symbol("useRawDataUnset"),pL={enabled:!0,disableDuplicateIdCheck:!0,disableDefaultValue:!1,disableTypeConversion:!1},vL={enabled:!0,disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1},lb=class hn extends O.mixin(be,bn,Ie,ky,qg,K0,Y0,q0,tx,ix,sx,ax,Z0,ox,lx,dx,Ex,cx,J0,ex){constructor(...e){if(super(...e),p(this,"crudManager"),this.objectify)return this.initProxy()}static get properties(){return{relationCache:{},dependentStoreConfigs:new Map,addingClean:!1}}static get identifiable(){return{registerGeneratedId:!1}}updateAutoLoad(e){e&&!this.readUrl&&!this.lazyLoad&&this.requestAnimationFrame(this.performDataRequest)}construct(e={}){const t=this;Object.assign(t,{added:new Xg,removed:new Xg,modified:new Xg,idRegister:{},internalIdRegister:{},oldIdMap:{}}),super.construct(e),t.initRelations()}static from(e,t={},r=null){return e&&!e.isStore&&(typeof e=="string"?e=hn.getStore(e):(Array.isArray(e)?(r&&(e=e.map(n=>n.isModel?n:r(n))),e=T.assign({},t,{data:e})):e=T.assign({},t,e),e=new hn(e))),e}equals(e){return e.isStore&&e.$master===this.$master}doDestroy(){var e,t,r,n;const s=this,a=s.registeredRecords;(t=(e=s.stm)==null?void 0:e.removeStore)==null||t.call(e,s);for(let o=a.length-1,l;o>=0;o--)l=a[o],l!=null&&l.isDestroyed||l.unjoinStore(s);(r=s._storage)==null||r.destroy(),s.isChained?s.masterStore.isDestroying||L.remove(s.masterStore.chainedStores,s):(n=s.rootNode)==null||n.destroy(),super.doDestroy()}beginBatch(){this.suspendEvents()}endBatch(){if(this.resumeEvents()){const{values:e}=this.storage;this.trigger("refresh",{action:"batch",data:e,records:e})}}changeStorage(e){return e!=null&&e.isCollection?e:new Bi(e)}updateStorage(e){e.autoFilter=this.reapplyFilterOnAdd;for(const t of e)t.joinStore(this);e.ion({change:"onDataChange",thisObj:this})}get allRecords(){var e;const t=this;if(((e=t._allRecords)==null?void 0:e.generation)!==t.storage.generation){if(t.isTree){const r=t.collectDescendants(t.rootNode,void 0,void 0,{unfiltered:!0}).all;t.rootVisible&&r.unshift(t.rootNode),t._allRecords=r}else t._allRecords=t.isGrouped?t.collectGroupRecords(!0,!0):t.storage.allValues;t._allRecords.generation=t.storage.generation}return t._allRecords}getAllDataRecords(e){const t=this;return t.tree?e?t.allRecords:t.rootNode.allChildren:t.isGrouped?t.collectGroupRecords(e,!1):(e?t.storage.allValues:t.storage.values).filter(r=>r)}onIsCreatingToggle(e,t){const r=this,n=e.isPersistable&&!t;r.added[n?"add":"remove"](e),n&&(r.trigger("addConfirmed",{record:e}),r.autoCommit&&r.doAutoCommit())}joinRecordsToStore(e){const{totalCount:t}=this;for(let r=0;r<e.length;r++){const n=e[r];n.setData("parentIndex",t+r-e.length),n.joinStore(this)}}onDataChange({source:e,action:t,added:r,removed:n,replaced:s,oldCount:a,items:o,from:l,to:d}){const c=this,u=gL[t],h=u&&(r==null?void 0:r.length),f=u&&(n==null?void 0:n.length),{generation:g}=e,m=c.isFiltered&&!c.remoteFilter;let v,y;if(c._idMap=null,h&&c.joinRecordsToStore(r),s==null||s.forEach(([b,C])=>{b.unjoinStore(c,!0),C.joinStore(c)}),super.onDataChange(...arguments),h&&e.generation!==g&&!m&&c.trigger("refresh",arguments[0]),!c.isTree){if(h){for(const b of r)c.removed.includes(b)?c.removed.remove(b):!c.addingClean&&!b.isLinked&&c.added.add(b);v=!c.remoteFilter&&c.isFiltered&&c.reapplyFilterOnAdd,v&&c.filter({silent:!0}),y=!c.remoteSort&&c.isSorted&&c.reapplySortersOnAdd,y&&c.sort(null,null,!1,!0)}if(f){for(const b of n)b.cancelBatch(),b.unjoinStore(c),c.added.includes(b)?(c.added.remove(b),b.isBeingMaterialized&&c.removed.add(b)):!b._undoingInsertion&&!b.isCreating&&!b.isLinked&&c.removed.add(b);c.modified.remove(n),v=m,v&&c.filter({silent:!0})}}switch(t){case"clear":c.relationCache={},c.updateDependentStores("removeall"),c.trigger("removeAll"),c.trigger("change",{action:"removeall"});break;case"splice":if(h){c.updateDependentStores("add",r);const b=r.reduce((w,x)=>{const{previousIndex:R}=x.meta;return R>-1&&R<w&&(w=R),w},r[0].meta.previousIndex),C=e.indexOf(r[0],!e.autoFilter),D={records:r,index:C};b>-1&&(D.oldIndex=b),c.trigger("add",D),c.trigger("change",Object.assign({action:"add"},D)),v&&c.triggerFilterEvent({action:"filter",filters:c.filters,oldCount:a,records:c.storage.allValues}),y&&c.trigger("sort",{action:"sort",sorters:c.sorters,records:c.storage.allValues})}n.length&&(c.updateDependentStores("remove",n),c.trigger("remove",{records:n}),c.trigger("change",{action:"remove",records:n})),s.length&&(c.updateDependentStores("replace",s),c.trigger("replace",{records:s,all:c.records.length===s.length}),c.trigger("change",{action:"replace",replaced:s,all:c.records.length===s.length}));break;case"filter":(c.isGrouped||c.isSorted)&&c.performSort(!0);break;case"move":{const b=Math.min(l,d),C=Math.min(c.storage.allValues.length-1,Math.max(l,d));for(let D=c.storage.allValues,w=b;w<=C;w++)D[w].setData("parentIndex",w);c.trigger("move",{records:o,from:l,to:d}),c.isFiltered&&c.performFilter(),c.trigger("change",{action:t,record:o[0],records:o,from:l,to:d});break}}}onDataReplaced(e,t){var r,n;const s=this,{storage:a}=s,o=a.allValues,l=s.sorters.length>0;for(let c=0;c<o.length;c++)(r=o[c])==null||r.joinStore(s);if(!s.remoteFilter&&s.isFiltered&&s.filter({silent:!0}),s.remoteSort?s.isGrouped&&a.replaceValues({...s.prepareGroupRecords(),silent:!0}):(s.isGrouped&&s.group(null,null,!1,!l,!0),l&&s.sort(null,null,!1,!0)),!s.useRawData.disableDuplicateIdCheck){const{idMap:c}=s;if(Object.keys(c).length<a.values.length){const u=[];throw a.values.forEach(h=>c[h.id]?delete c[h.id]:u.push(h)),new Error(`Id collision on ${u.map(h=>h.id)}`)}}const d={action:e,data:t,records:a.values};s.updateDependentStores(e,d.records),(n=s.afterLoadData)==null||n.call(s),s.isRemoteDataLoading||s.trigger("refresh",d),s.trigger("change",d)}onModelChange(e,t,r,n,s){var a;const o=this,l={record:e,records:[e],changes:r,batch:e.batching!=null,fromRelationUpdate:s};if(o.storage.onItemMutation(e,r),"id"in r){const{oldValue:c,value:u}=t.id;o.updateDependentRecordIds(c,u),o.onRecordIdChange({record:e,oldValue:c,value:u})}else e.meta._ignoreRelatedIdUpdate||o.updateDependentStores("update",[e],n);const d=(e.ignoreBag||e.isLinked?!1:o.updateModifiedBagForRecord(e))&&!((a=e.meta)!=null&&a.pendingFormulae);if(o.onUpdateRecord(e,r),!n){if("id"in r){const{oldValue:c,value:u}=t.id;o.trigger("idChange",{store:o,record:e,oldValue:c,value:u})}o.trigger("update",l),o.trigger("change",Object.assign({action:"update"},l))}o.autoCommit&&d&&o.doAutoCommit()}updateModifiedBagForRecord(e){var t;const r=this,{modified:n,added:s}=r;return e.isModified&&!e.isRoot&&r.idRegister[e.id]?(!n.includes(e)&&!s.includes(e)&&(e.isPhantom?s.add(e):n.add(e)),e.isBeingMaterialized&&(r.modifiedMaterialized=(t=r.modifiedMaterialized)!=null?t:new Set,r.modifiedMaterialized.add(e)),!0):(n.remove(e),!1)}get idMap(){const e=this,t=!e._idMap,r=e._idMap||(e._idMap={});if(t){const n=e.storage.values;for(let s,a=0,o=0;a<n.length;a++)s=n[a],s&&(r[s.id]={index:a,visibleIndex:o,record:s}),s!=null&&s.isSpecialRow||o++;if(e.isFiltered)for(let s=0,a=e.storage._values.length;s<a;s++){const o=e.storage._values[s];o&&(o.id in r?r[o.id].unfilteredIndex=s:r[o.id]={index:-1,unfilteredIndex:s,record:o})}}return r}changeModelClass(e){const{fields:t}=this;this.originalModelClass=e;let r=e;if(t!=null&&t.length){class n extends e{static get fields(){return t}}r=n}else if(!this.preventSubClassingModel){class n extends e{}r=n}return r.initClass(),r}get $lazyLoadPluginClass(){return $o}changeLazyLoad(e){const t=this;let r=t.$lazyLoadPluginClass;t.isTree&&!r.isOfTypeName("DateStoreLazyLoadPlugin")&&(t.treeLazyLoadClass||(t.treeLazyLoadClass=class extends fL(r){}),r=t.treeLazyLoadClass);let n=t.getPlugin(r);if(e){const s=T.isObject(e);return n?s&&T.assign(n,e):n=t.addPlugin(r,s?e:null),n}else return n==null||n.destroy(),!1}changeId(e,t){return super.changeId(e!==!0&&e,t)}updateId(e,t){const r=hn.getById(e);r&&hn.unregisterInstance(r),super.updateId(e,t)}generateAutoId(){return hn.generateId("store-")}updateTree(e){e&&!this.rootNode&&(this.rootNode=this.buildRootNode(),this.rootNode.isAutoRoot=!0)}get autoTree(){return this.tree!==!1&&this._autoTree}buildRootNode(){return{}}static getStore(e,t){if(e instanceof hn)return e;if(this.getById(e))return this.getById(e);if(Array.isArray(e)){let r;const n=e.map(s=>(s instanceof me?r=s.constructor:typeof s=="string"&&(s={text:s}),s));if(!r){class s extends me{}r=s}e={autoCreated:!0,data:n,modelClass:r,allowNoId:!0},t||(t=hn)}if(t)return new t(e)}static get stores(){return hn.registeredInstances}get rootNode(){return!this.isChainedTree&&this.masterStore?this.masterStore.rootNode:this._rootNode}set rootNode(e){var t;const r=this,n=r._rootNode;e!==n&&(n&&(r.clear(!0),r.removed.clear()),e instanceof me?(e.instanceMeta(r).collapsed=!1,r._rootNode=e):r._rootNode=e=new r.modelClass({expanded:!0,[r.modelClass.idField]:`${r.id}-rootNode`,...e},r,{isRoot:!0},!0),r._tree=!0,e.isRoot=!0,e.joinStore(r),((t=e.children)!=null&&t.length||r.rootVisible)&&(e.isLoading=!0,r.onNodeAddChild(e,e.children||[],0),e.isLoading=!1),r.trigger("rootChange",{oldRoot:n,rootNode:e}))}set data(e){this.setStoreData(e)}get data(){return this.getAllDataRecords(!0).map(e=>e.data)}setStoreData(e){const t=this,{idField:r,childrenField:n}=t.modelClass;e&&!Array.isArray(e)&&(e=T.transformNamedObjectToArray(e,r));const s=or.walkWhile(e!=null?e:[],a=>a[n],Object.isExtensible);if(e!=null&&e.length&&!s&&(t.transformFlatData||t.useRawData.enabled)&&(t.transformFlatData&&(t.useRawData=t.useRawData||{disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1}),e=T.clone(e)),t.getConfig("plugins"),t.processConfiguredListeners(),t.isChained&&!t.isChainedTree||t.autoTree&&(e!=null&&e.some(a=>a[n]))&&(t.tree=!0),e&&(t.remoteSort||t.remoteFilter))for(let a=0;a<e.length;a++)e[a]._remoteSortIndex=a;!t.syncDataOnLoad||!t._data?(t._data=e,t.tree?t.loadTreeData(e):t.loadData(e),t.added.clear(),t.removed.clear(),t.modified.clear()):t.syncDataset(e)}loadTreeData(e){const t=this,r=t.rootNode,n=new Map;if(t.transformFlatData&&(e=t.treeifyFlatData(e)),r.isLoading=!0,t.records.length&&t.keepExpandedOnLoad&&t.traverse(s=>{s.isLeaf||n.set(s.id,s.instanceMeta(t).collapsed)}),e.sort((s,a)=>s.parentIndex-a.parentIndex),t.clear(!0),t.suspendEvents(!0),r.appendChild(e),n.forEach((s,a)=>{const o=t.getById(a);o&&t.toggleCollapse(o,s)}),t.resumeEvents(),t.updateDependentStores("dataset",[r]),r.isLoading=!1,e.length===0){const s={action:"dataset",data:[],records:[]};t.trigger("refresh",s),t.trigger("change",s)}else t.isFiltered&&!t.remoteFilter&&t.filter()}loadData(e,t="dataset"){var r;const n=this,{storage:s,allowNoId:a}=n,o=n.modelClass.fieldMap.id.dataSource,l=n.find(c=>c.isCreating);l&&s.values.splice(n.records.indexOf(l),1);let d=n.verifyNoGeneratedIds;if(n.removeHeadersAndFooters(n.storage.values),n._idMap=null,n.oldIdMap={},e){const c=!(e[0]instanceof me),u=e.length,h=new Array(u);c&&n.modelClass.exposeProperties(e[0]);for(let f=0;f<u;f++){let g=e[f];if(c){const m=g[o];if(!a&&m==null)throw new Error(`Id required but not found on row ${f}`);d&&((r=m==null?void 0:m.startsWith)!=null&&r.call(m,"_generated"))&&(console.warn(`Generated id found in data: ${m}. Generated ids are temporary and should be replaced with real ids by the backend`),d=!1),g=n.createRecord(g,!0)}n.isFillingFromMaster||(g=n.processRecord(g,!0),g.setData("parentIndex",f)),h[f]=g}n.clear(!0),s.replaceValues({values:h,isNewDataset:!0,silent:!0}),l&&!s.values.includes(l)&&s.values.push(l),n._data=e,n.onDataReplaced(t,e)}else n.clear(!0),n._data=null;n.isSyncingDataOnLoad=!1}getRange(e,t,r=!0){return(r?this.storage.allValues:this.storage.values).slice(e,t)}createRecord(e,t=!1,r=!1){return new this._modelClass(e,this,null,t,!1,r)}processRecord(e,t=!1){return e}refreshData(){this.filter(),this.sort()}onRecordIdChange({record:e,oldValue:t,value:r}){const n=this,s=n._idMap,{idRegister:a,oldIdMap:o}=n;if(n.storage._indicesInvalid=!0,o[t]=e,s&&!s[r]){const l=s[t];delete s[t],s[r]=l}n.added.changeId(t,r),n.removed.changeId(t,r),n.modified.changeId(t,r),delete a[t],a[r]=e,e.index=n.storage.indexOf(e)}onUpdateRecord(e,t){var r,n;const s=this,{internalId:a}=t,{internalIdRegister:o,reapplyFilterOnUpdate:l,reapplySortersOnUpdate:d}=s;a&&(this.storage._indicesInvalid=!0,delete o[a.oldValue],o[a.value]=e),(l===!0||(r=l.fields)!=null&&r.some(c=>c in t))&&s.isFiltered&&(s.filterBatching||s.filter()),(d===!0||(n=d.fields)!=null&&n.some(c=>c in t))&&s.isSorted&&(s._reapplySortersSuspended?s._shouldReapplySorters=!0:s.sort())}get useRawData(){var e;return this._useRawData===tm?this.readUrl||(e=this.crudManager)!=null&&e.loadUrl?vL:{enabled:!1}:this._useRawData}changeUseRawData(e){return e===tm?tm:e===!0?pL:e?Object.assign(e,{enabled:!0}):{enabled:!1}}async performDataRequest(e,t,r){var n,s;const a=this,o=a.buildRemoteParams(t);let l,d;if(!e&&(await a.trigger("beforeRequest",{action:"read",params:o})===!1||await((n=a.trigger)==null?void 0:n.call(a,"requestData",o))===!1))return!1;if(!a.isDestroyed){if(a.requestData){if({data:l,total:d}=await a.requestData(o),a.isDestroyed)return;r==null||r(),a.data=l,d!=null&&(a.remoteTotal=d)}else r==null||r();await((s=a.trigger)==null?void 0:s.call(a,"afterRequest",{response:{data:l,total:d},params:o,action:"read"}))}}getCount(e=!0){var t,r,n;const s=this,{storage:a,groupRecords:o,isFiltered:l,isGrouped:d,isTree:c,rootNode:u}=s;if(typeof e=="boolean")return te.deprecate("core","7.0.0","getCount(true/false) deprecated in favor of getCount(options)"),e?s.count:a.totalCount-((o==null?void 0:o.count)||0);if(e.all)return this.allRecords.length;"visibleData"in e||(e.visibleData=!0);let h=0;const{visibleData:f,headersFooters:g,filteredOut:m,collapsed:v}=e,y=l?(t=o==null?void 0:o.values.reduce((C,D)=>C+(s.includes(D)?1:0),0))!=null?t:0:(r=o==null?void 0:o.count)!=null?r:0,b=a.count-y;if(f&&(h+=b),g&&d&&(l&&m?h+=(n=o.count)!=null?n:0:h+=y),m&&l&&(c?h+=u.getDescendantCount(!1,s,!0)-u.getDescendantCount(!1,s,!1):h+=a.allValues.length-a.values.length),v)if(d)for(const C of o)h+=C.meta.collapsed?C.groupChildren.length:0;else c&&(h+=u.descendantCount-b);return h}get count(){return this.storage.count}get originalCount(){var e;return te.deprecate("core","7.0.0","originalCount was deprecated in favor of getCount()"),this.storage.totalCount-(((e=this.groupRecords)==null?void 0:e.count)||0)}get allCount(){return te.deprecate("core","7.0.0","allCount was deprecated in favor of totalCount"),this.isTree?this.rootNode.descendantCount:this.storage.totalCount}get totalCount(){return this.isPaged&&"remoteTotal"in this?this.remoteTotal:this.getCount({all:!0})}set totalCount(e){this.isPaged&&(this.remoteTotal=e)}get records(){return this.storage.values}get first(){return this.storage.values[0]}get last(){return this.storage.values[this.storage.values.length-1]}getAt(e,t=!1){return this.storage.getAt(e,t)}register(e){const t=this;if(!t.useRawData.disableDuplicateIdCheck){const r=t.isTree&&t.idRegister[e.id];if(r&&r!==e)throw new Error(`Id collision on ${e.id}`)}t.idRegister[e.id]=e,t.internalIdRegister[e.internalId]=e}unregister(e){delete this.idRegister[e.id],delete this.internalIdRegister[e.internalId]}get registeredRecords(){return Object.values(this.idRegister)}getById(e){const t=this;let r;e!=null&&e.isModel&&(r=e,e=r.id);const n=t.idRegister[e];if(r){if(r!=null&&r.hasLinks&&!n){const{allValues:s}=t.storage;return r.$links.find(a=>s.includes(a))}return r}return n}isAvailable(e){const t=this.getById(e);return t&&this.storage.includes(t)||!1}getByInternalId(e){return this.internalIdRegister[e]}includes(e){return this.isTree?this.idRegister[me.asId(e)]!=null:this.indexOf(e)>-1}indexOf(e,t=!1,r=!1){var n;if(e!=null&&e.isModel&&!((n=e.stores)!=null&&n.includes(this.$store||this))){const o=e.$links.find(l=>this.storage.allValues.includes(l));return o?this.indexOf(o,t):-1}if(this.isTree)return(r?this.rootNode.allChildren:this.storage.values).indexOf(this.getById(e));const s=me.asId(e);if(s==null)return-1;const a=this.idMap[s];return a?a[t?"visibleIndex":"index"]:-1}allIndexOf(e){return this.isTree?this.allRecords.indexOf(this.getById(e)):this.storage.indexOf(e,!0)}getDistinctValues(e,t=!1,r=!1){const n=this,s=[],a={};let o;return n.forEach(l=>{if(!l.isSpecialRow&&!l.isRoot){o=l.getValue(e);const d=o instanceof Date?o.getTime():o;a[d]===void 0?(s.push(o),a[d]={value:o,count:1}):a[d].count++}},n,{includeCollapsedGroupRecords:!0,includeFilteredOutRecords:t}),r?Object.values(a):s}getValueCount(e,t){let r=0;return this.forEach(n=>{T.isEqual(n.getValue(e),t)&&r++}),r}set json(e){typeof e=="string"&&(e=k.safeJsonParse(e)),this.data=e}get json(){return k.safeJsonStringify(this)}get formattedJSON(){return k.safeJsonStringify(this,null,4)}toJSON(){const e=this,{persistable:t,dataSource:r}=e.modelClass.getFieldDefinition("expanded");return(e.isTree?e.rootNode.unfilteredChildren||e.rootNode.children||[]:e.allRecords).map(n=>{const s=n.toJSON();return e.tree&&n.isParent&&t&&(s[r]=n.isExpanded(e)),s})}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.project}getInlineData(e){var t;const r=[];return this.tree?(t=this.rootNode.children)==null||t.forEach(n=>r.push(n.getCurrentConfig(e))):this.forEach(n=>r.push(n.getCurrentConfig(e))),r}getCurrentConfig(e){const t=super.getCurrentConfig(e),{state:r}=this;return t&&(t.data&&(t.data=this.getInlineData(e)),delete t.project,delete t.stm,delete t.asyncEvents,delete t.modelClass,this.tree||delete t.tree,r&&Object.assign(t,r)),t}forEach(e,t=this,r){const n=this,s=(a,o)=>{if(a&&!a.isRoot&&!a.isSpecialRow)return e.call(t,a,o)};if(r=ob(n,r),n.isTree)n.isChained&&(r={...r,sorterFn:n.sorterFn}),n.rootNode.traverseWhile(s,!1,r);else{const a=r.includeFilteredOutRecords?n.storage.allValues:n.storage.values;if(n.isGrouped&&r.includeCollapsedGroupRecords)for(let o=0;o<a.length;o++){const l=a[o],d=r.includeFilteredOutRecords?l.unfilteredGroupChildren:l.groupChildren;if(d&&l.meta.collapsed===!0)for(let c=0;c<d.length;c++){const u=d[c];if(s(u,c)===!1)return}else if(s(l,o)===!1)return}else for(let o=0;o<a.length;o++)if(s(a[o],o)===!1)return}}map(e,t=this){return this.storage.values.map(e,t)}flatMap(e,t=this){return this.storage.values.flatMap(e,t)}every(e,t=this,r){return this.storage[r?"allValues":"values"].every(e,t)}reduce(e,t=[],r=this){return r!==this&&(e=e.bind(r)),this.storage.values.reduce(e,t,r)}[Symbol.iterator](){return this.storage.values[Symbol.iterator]()}traverse(e,t=this.rootNode,r=t===this.rootNode,n){const s=this;if(n=ob(s,n),s.isTree){if(typeof t=="boolean"&&(r=t,t=s.rootNode),s.isChained){const a=e;e=o=>{s.chainedFilterFn(o)&&a(o)}}t.traverse(e,r,n)}else s.forEach(a=>a.traverse(e,!1,n),s,n)}traverseWhile(e,t=this.rootNode,r=t===this.rootNode,n){const s=this;if(n=ob(s,n),s.isTree){if(typeof t=="boolean"&&(r=t,t=s.rootNode),s.isChained){const a=e;e=o=>{s.chainedFilterFn(o)&&a(o)}}t.traverseWhile(e,r,n)}else for(const a of s.storage)if(a.traverse(e,!1,n)===!1)break}getNext(e,t=!1,r=!1){const n=this,s=n.storage.values;let a=n.indexOf(e);if(a>=s.length-1)if(t)a=-1;else return null;const o=s[a+1];return r&&o&&(o.isSpecialRow||typeof r=="function"&&r(o))?n.getNext(s[a+1],t,r):o}getPrev(e,t=!1,r=!1){const n=this,s=n.storage.values;let a=n.indexOf(e);if(a===0)if(t)a=s.length;else return null;const o=s[a-1];return a>0&&r&&o&&(o.isSpecialRow||typeof r=="function"&&r(o))?n.getPrev(s[a-1],t,r):o}getAdjacent(e,t=!0,r=!1,n=!1){return t?this.getNext(e,r,n):this.getPrev(e,r,n)}getNextLeaf(e,t=!1){const r=this,n=r.leaves,s=r.getById(e);let a=n.indexOf(s);if(a>=n.length-1)if(t)a=-1;else return null;return n[a+1]}getPrevLeaf(e,t=!1){const r=this,n=r.leaves,s=r.getById(e);let a=n.indexOf(s);if(a===0)if(t)a=n.length;else return null;return n[a-1]}getAdjacentLeaf(e,t=!0,r=!1){return t?this.getNextLeaf(e,r):this.getPrevLeaf(e,r)}};p(lb,"$name","Store"),p(lb,"configurable",{id:!0,modelClass:me,verifyNoGeneratedIds:!0,lazyLoad:null,autoLoad:null,requestData:null,useRawData:tm,fields:null,autoTree:!0,tree:null,callOnFunctions:!0,storage:{},allowNoId:!0,preventSubClassingModel:null,storeClass:null});var ue=lb;ue.initClass(),ue._$name="Store";var Bo=class extends $o{static get pluginConfig(){const i={};for(const e in super.pluginConfig)i[e]=[...super.pluginConfig[e]];return i.assign.push("updateResponseTotalProperty","updateResponseDataProperty"),i}updateResponseTotalProperty(i){this.totalCountProperty=i}updateResponseDataProperty(i){this.dataProperty=i}async requestData(i){const{totalCountProperty:e,dataProperty:t}=this.lazyLoad,r=await this.internalLoad(i,"",void 0,!1);return{[e]:r.json[e],[t]:r.data}}async load(i){const{client:e}=this,t=e.params;i&&(e.params={...i,...t}),e.autoLoad&&e.isConstructing&&await new Promise(r=>this.requestAnimationFrame(r)),await super.load(),i&&(e.params=t)}};p(Bo,"$name","AjaxStoreLazyLoadPlugin"),Bo._$name="AjaxStoreLazyLoad";var yL=(i,e)=>(Array.isArray(e[1])?e[1].forEach(t=>i.push(encodeURIComponent(e[0])+"="+encodeURIComponent(t))):i.push(encodeURIComponent(e[0])+"="+encodeURIComponent(e[1])),i),db=Promise.resolve(),Lu=i=>String(i).padStart(2,"0"),bL=i=>`${i.getFullYear()}-${Lu(i.getMonth()+1)}-${Lu(i.getDate())}T${Lu(i.getHours())}:${Lu(i.getMinutes())}:${Lu(i.getSeconds())}.${i.getMilliseconds()}`,CL=i=>i.persistableData,SL=i=>!T.isEmpty(i),pt=class extends ue{constructor(){super(...arguments),p(this,"modificationsTracking",0)}suspendModificationsTracking(){this.modificationsTracking++}resumeModificationsTracking(){this.modificationsTracking--}afterConstruct(i){super.afterConstruct(i),this.autoLoad&&this.readUrl&&this.load().catch(()=>{})}get $lazyLoadPluginClass(){return Bo}get isLoading(){return super.isLoading||this._isLoading?2:this.loadTriggerPromise?1:!1}get isCommitting(){var i;return!!((i=this.commitPromise)!=null?i:this.autoCommitTimeoutPromise)}updateFilterParamName(i){super.updateFilterParamName(i),this.remoteFilter=this.remoteFilter||this.restfulFilter}updateRestfulFilter(i,e){this.remoteFilter=i||!!this.filterParamName||this.remoteFilter&&!e}buildQueryString(i,...e){const t=i.includes("?"),r=Object.entries(Object.assign({},...e)).reduce(yL,[]).join("&");return r?(t?"&":"?")+r:""}async performRemoteSort(i){var e;const t=this;if(t.readUrl&&!t.isRemoteDataLoading){if(t.isRemoteDataLoading=!0,await((e=t.beforePerformSort)==null?void 0:e.call(t))===!1)return;const r=await t.load();return t.afterPerformSort(i),t.isRemoteDataLoading=!1,r}else super.performSort(i)}async performRemoteFilter(i){var e,t;const r=this;if(r.filterBatching>0){r.needsFiltering=!0;return}if(r.readUrl){(e=r.loadingPromise)==null||e.abort(),r.isRemoteDataLoading=!0;const n=r.count,{filters:s}=r;if(await((t=r.beforePerformFilter)==null?void 0:t.call(r,{filters:s,oldCount:n}))===!1)return;const a=await r.load(),o=i?null:{action:"filter",filters:s,oldCount:n,records:r.storage.values};return r.afterPerformFilter(o),r.trigger("refresh",o),r.isRemoteDataLoading=!1,a}else super.performRemoteFilter(i)}encodeFilterParams(i){const e=this.getFilterParams(i);return JSON.stringify(e,function(t,r){return t===""?r:this[t]instanceof Date?bL(this[t]):r})}encodeSorterParams(i){return JSON.stringify(this.getSorterParams(i))}buildReadUrl(){const{readUrl:i}=this;return this.restfulFilter&&this.filters.count?(i.endsWith("/")?i:i+"/")+this.filters.first.value:i}internalLoad(i,e,t,r=0){i=T.assign({},this.params,i);const n=this,s={action:"read"+e,params:i,url:n.buildReadUrl()};if(n.buildRemoteParams(i,!0),n.trigger("beforeLoad"+e,s)===!1)throw!1;return n.loadArgs=[s,i,e,t],r===!1?new Promise((a,o)=>n.sendLoadRequest(a,o)):n.loadTriggerPromise||(n.loadTriggerPromise=new Promise((a,o)=>{n.setTimeout({delay:r,fn:"sendLoadRequest",args:[a,o],cancelOutstanding:!0})}))}async sendLoadRequest(i,e){var t,r,n;const s=this,[a,o,l,d]=s.loadArgs;if(s.loadTriggerPromise=null,a.url){s._isLoading=!0,s.trigger(`load${l}Start`,a),await s.trigger("beforeRequest",a)===!1&&(s._isLoading=!1,i(a));const c={parseJson:!0};s.headers&&(c.headers=T.clone(s.headers)),s.useRestfulMethods&&(c.method=s.httpMethods.read,a.body&&(c.body=JSON.stringify(a.body)));try{const u=s.paramsInBody&&(((t=c.method)==null?void 0:t.toUpperCase())==="POST"||((r=c.method)==null?void 0:r.toUpperCase())==="PUT")&&c.body==null,h=a.url+(u?"":s.buildQueryString(a.url,o)),f=s.loadingPromise=Wt.get(h,T.assign(c,s.fetchOptions,u?{body:JSON.stringify(o)}:null)),g=await f;if(s.isDestroyed)return;const m=s.transformLoadedData?s.transformLoadedData(g.parsedJson):g.parsedJson,v=Array.isArray(m),y=v||m&&T.getPath(m,s.responseSuccessProperty)!==!1,b=v?null:T.getPath(m,s.responseTotalProperty);if(s.loadingPromise=null,s._isLoading=!1,a.response=g,a.json=m,y){if(b!=null&&(s.remoteTotal=parseInt(b,10)),s.isPaged&&!s.lazyLoad)if(s.remoteTotal>=0)s.currentPage=s.pageStartParamName?o[s.pageStartParamName]/s.pageSize+1:o[s.defaultPageParamName];else throw new Error("A paged store must receive its responseTotalProperty in each data packet");a.data=v?m:T.getPath(m,s.responseDataProperty),s.suspendModificationsTracking(),await(d==null?void 0:d(a)),s.resumeModificationsTracking(),s.isPartOfProjectRaw&&(s.ignoreLoadPropagationChanges&&s.suspendModificationsTracking(),await((n=s.getProject())==null?void 0:n.commitAsync()),s.ignoreLoadPropagationChanges&&s.resumeModificationsTracking()),!s.isDestroyed&&s.trigger("load"+l,a),i(a)}else Object.assign(a,{exception:!0,exceptionType:"server",error:m==null?void 0:m.error}),!s.isDestroyed&&s.trigger("exception",a),e(a)}catch(u){s._isLoading=!1,a.exception=!0,u instanceof Response?(a.exceptionType=u.ok?"server":"network",a.response=u,a.error=u.error):(a.exceptionType="server",a.error=u),!s.isDestroyed&&s.trigger("exception",a),e(a)}finally{!s.isDestroyed&&s.trigger("afterRequest",a)}}}async load(i){const e=this;return e.isPaged?e.loadPage(e.currentPage||1,i):e.internalLoad(i,"",t=>{e.data=t.data})}async loadChildren(i){return this.readUrl?this.internalLoad({[this.parentIdParamName]:i.id},"Children",e=>{e.parentRecord=i,i.children.length&&i.clearChildren(!0),i.data[i.constructor.childrenField]=e.data,i.processChildren(i.stores)},!1):this.immediatePromise}async loadPage(i,e={}){return this.readUrl?(e[this.defaultPageParamName]=i!=null?i:1,this.internalLoad(e,"Page",t=>{this.loadData(t.data,"pageLoad")})):super.loadPage(i)}async commit(){return this.clearTimeout("autoCommit"),this.autoCommitTimeoutPromise=null,this.queueCommit()}queueCommit(){const i=this;let e;return i.commitPromise?e=i.commitPromise.then(()=>i.performCommit()):(i._commitPromiseQueueLength=0,e=i.performCommit()),i._commitPromiseQueueLength+=1,i.commitPromise=e==null?void 0:e.finally(()=>{i._commitPromiseQueueLength-=1,i._commitPromiseQueueLength===0&&(i.commitPromise=null)})}performCommit(){const i=this,{changes:e}=i,t=[];if(!e)return i.modified.count&&(i.modified.forEach(r=>r.internalClearChanges(!0,!1)),i.modified.clear()),db;if(i.trigger("beforeCommit",{changes:e})!==!1){[...e.added,...e.modified,...e.removed].forEach(s=>s.meta.committing=!0),i.trigger("commitStart",{changes:e});const r={action:"commit",exception:!1,changes:e};let n=i.commitRemoved(r);return n&&t.push(n),n=i.commitAdded(r),n&&t.push(n),n=i.commitModified(r),n&&t.push(n),t.length?(n=t.length===1?t[0]:Promise.all(t),new Promise((s,a)=>{n.then(()=>{r.exception?(i.trigger("exception",r),a(r)):(i.trigger("commit",{changes:e}),s(r))}).catch(()=>{a(r)})})):(i.modified.forEach(s=>s.internalClearChanges(!0,!1)),i.modified.clear(),i.added.forEach(s=>s.internalClearChanges(!0,!1)),i.added.clear(),i.removed.clear(),i.trigger("commit",{changes:e}),db)}else return db}doAutoCommit(){const i=this;i.suspendCount<=0&&!i.hasTimeout("autoCommit")&&(i.autoCommitTimeoutPromise=new Promise(e=>{i.setTimeout({name:"autoCommit",fn:()=>{i.autoCommitTimeoutPromise=null,i.commit().then().catch(t=>{const{response:r}=t;if(!(r&&(r.ok&&r.parsedJson||[500,404].includes(r.status))))throw t}),e()},delay:i.autoCommitTimeout})}))}buildCommitUrl(i){return i+this.buildQueryString(i,this.params)}commitAdded(i){return this.added.count&&this.createUrl?this.commitAddedAsync(i):null}async commitAddedAsync(i){const e=this,t=Array.from(e.added),r=t.map(CL),n={action:"create",params:e.params,url:e.buildCommitUrl(e.createUrl)};if(i.create=n,n.body={data:r},await e.trigger("beforeRequest",n)===!1)return t.forEach(o=>o.meta.committing=!1),i;let s=e.transformCreationData?e.transformCreationData(n.body):n.body;if(e.sendAsFormData){const o=new FormData;o.append("data",JSON.stringify(s.data)),s=o}const a={parseJson:!0};e.headers&&(a.headers=T.clone(e.headers)),e.useRestfulMethods&&(a.method=e.httpMethods.create);try{const o=await Wt.post(n.url,s,T.assign(a,e.fetchOptions));if(e.isDestroyed)return;const l=o.parsedJson,d=Array.isArray(l)||l&&l.success!==!1;if(i.response=o,n.json=l,n.response=o,d){const c=e.processReturnedData(l,t,r);e.added.remove(c),e.modified.add(c.filter(u=>u.meta.modified&&!T.isEmpty(u.meta.modified))),e.trigger("commitAdded"),e.trigger("refresh",n)}else t.forEach(c=>c.meta.committing=!1),i.exception=n.exception=!0,i.exceptionType=n.exceptionType="server",e.trigger("exception",n)}catch(o){t.forEach(l=>l.meta.committing=!1),i.exception=n.exception=!0,o instanceof Response?(i.response=o,n.exceptionType=o.ok?"server":"network",n.response=o,n.error=o.error):(n.exceptionType="server",n.error=o),!e.isDestroyed&&e.trigger("exception",n)}finally{!e.isDestroyed&&e.trigger("afterRequest",n)}return i}commitModified(i){return this.modified.count&&this.updateUrl?this.commitModifiedAsync(i):null}async commitModifiedAsync(i){const e=this,t=Array.from(e.changes.modified),r={action:"update",params:e.params,url:e.buildCommitUrl(e.updateUrl)},n=t.map(o=>e.writeAllFields?o.persistableData:o.modificationDataToWrite).filter(SL);if(n.length===0){e.modified.clear(),t.forEach(o=>o.meta.committing=!1);return}if(i.update=r,r.body={data:n},await e.trigger("beforeRequest",r)===!1)return i;let s=e.transformModificationData?e.transformModificationData(r.body):r.body;if(e.sendAsFormData){const o=new FormData;o.append("data",JSON.stringify(s.data)),s=o}const a={parseJson:!0};e.headers&&(a.headers=T.clone(e.headers)),e.useRestfulMethods&&(a.method=e.httpMethods.update);try{const o=await Wt.post(r.url,s,T.assign(a,e.fetchOptions));if(e.isDestroyed)return;const l=o.parsedJson,d=Array.isArray(l)||l&&l.success!==!1;i.response=o,r.json=l,r.response=o,d?(e.processReturnedData(l,t,n,!0,!0),e.trigger("commitModified"),e.trigger("refresh",r)):(t.forEach(c=>c.meta.committing=!1),i.exception=r.exception=!0,r.exceptionType="server",e.trigger("exception",r))}catch(o){t.forEach(l=>l.meta.committing=!1),i.exception=r.exception=!0,o instanceof Response?(i.response=o,r.exceptionType=o.ok?"server":"network",r.response=o,r.error=o.error):(r.exceptionType="server",r.error=o),!e.isDestroyed&&e.trigger("exception",r)}finally{!e.isDestroyed&&e.trigger("afterRequest",r)}return!t.length&&e.modified.count&&e.modified.clear(),i}processReturnedData(i,e,t,r=!1){Array.isArray(i)||(i=T.getPath(i,this.responseDataProperty));const{idField:n}=e[0].constructor,s=!i||i.length===e.length,a=[];return e.forEach((o,l)=>{const d=r?i==null?void 0:i.find(c=>c[n]===o.id):i==null?void 0:i[l];if(s||d){const c=o.modificationDataToWrite,u=r?t.find(f=>f[n]===o.id):t[l],h={};if(o.meta.committing=!1,d&&(o.syncId(d[n]),Object.assign(o.data,this.modelClass.processData(d,r,this,o))),c){for(const f in u)if(c[f]===u[f]){const g=o.getFieldDefinitionFromDataSource(f);g!=null&&g.persist&&(h[g.name]=1)}}o.internalClearChanges(!0,!0,h,!0),a.push(o)}}),a}commitRemoved(i){return this.removed.count&&this.deleteUrl?this.commitRemovedAsync(i):null}async commitRemovedAsync(i){var e,t;const r=this,{removed:n,includeChildrenInRemoveRequest:s}=r;let a;if(s)a=n.values;else{a=[];for(const c of n.values){const u=(t=c.parentId)!=null?t:(e=c.meta.modified)==null?void 0:e.parentId;u!=null&&(u===r.rootNode.id||!n.includes(u))&&a.push(c)}}const o={action:"delete",params:r.params,url:r.buildCommitUrl(r.deleteUrl),body:{ids:a.map(c=>c.id)}};if(i.delete=o,await r.trigger("beforeRequest",o)===!1)return i;let l=r.transformRemovalData?r.transformRemovalData(o.body):o.body;if(r.sendAsFormData){const c=new FormData;c.append("id",JSON.stringify(l.ids)),l=c}const d={parseJson:!0};r.headers&&(d.headers=T.clone(r.headers)),r.useRestfulMethods&&(d.method=r.httpMethods.delete);try{const c=await Wt.post(o.url,l,T.assign(d,r.fetchOptions)),u=c.parsedJson,h=Array.isArray(u),f=h||u&&u.success!==!1;i.response=c,o.json=u,o.response=c,f?(n.forEach(g=>g.meta.committing=!1),n.clear(),r.trigger("commitRemoved"),r.trigger("refresh",o)):(n.forEach(g=>g.meta.committing=!1),i.exception=o.exception=!0,o.exceptionType="server",r.trigger("exception",o))}catch(c){n.forEach(u=>u.meta.committing=!1),i.exception=o.exception=!0,c instanceof Response?(i.response=c,o.exceptionType=c.ok?"server":"network",o.response=c,o.error=c.error):(o.exceptionType="server",o.error=c),!r.isDestroyed&&r.trigger("exception",o)}finally{!r.isDestroyed&&r.trigger("afterRequest",o)}return i}};p(pt,"$name","AjaxStore"),p(pt,"configurable",{responseSuccessProperty:"success",responseDataProperty:"data",responseTotalProperty:"total",params:null,autoCommitTimeout:10,includeChildrenInRemoveRequest:!0,transformLoadedData:null,transformCreationData:null,transformModificationData:null,transformRemovalData:null,ignoreLoadPropagationChanges:!1,restfulFilter:!1,headers:null,fetchOptions:null,sendAsFormData:null,writeAllFields:null,parentIdParamName:"id",useRestfulMethods:null,httpMethods:{create:"POST",read:"GET",update:"PUT",delete:"DELETE"},paramsInBody:te.checkVersion("core","6.0",">=")}),pt._$name="AjaxStore";var im=class extends me{};p(im,"$name","ComboModel"),p(im,"fields",[{name:"value"},{name:"text"}]),im._$name="ComboModel";var rm={},Ge=class{static get(i,e=rm){const t=i._domData||(i._domData={});return e===rm?t:t[e]}static remove(i,e){const{_domData:t}=i,r=t==null?void 0:t[e];return t==null||delete t[e],r}static set(i,e,t=rm){return t===rm?i._domData=t=e:(i._domData||(i._domData={}))[e]=t,t}static assign(i,e){Object.assign(i._domData||(i._domData={}),e)}};Ge._$name="DomDataStore";var Ys=class{static insertRule(i,e=document.head){const t=this.getStyleSheet(e),{cssRules:r}=t,n=r.length,s=typeof i=="string";if((s?[i]:i).forEach((a,o)=>t.insertRule(a,o)),r.length>n)return s?r[0]:Array.from(r).slice(0,i.length)}static findRule(i){let e;const t=typeof i=="function";return Array.prototype.find.call(document.head.querySelectorAll("link[rel=stylesheet],style[type*=css]"),r=>{if(e=Array.prototype.find.call(r.sheet.rules||r.sheet.cssRules,n=>t?i(n):n.selectorText===i),e)return!0}),e}static getStyleSheet(i=document.head){return i.$bryntumStylesheet||(i.$bryntumStylesheet=E.createElement({tag:"style",type:"text/css",parent:i}).sheet),i.$bryntumStylesheet}static getCSSVersion(){return getComputedStyle(document.documentElement).getPropertyValue("--bryntum-version").replace(/[" ]/gm,"")}};p(Ys,"$name","CSSHelper"),ye.register(Ys),Ys._$name="CSSHelper";var wL=i=>{var e;return e=class extends(i||O){initContainerDrag(){const t=this;if(t.mode||(t.mode="container"),t.mode==="container"&&!t.containers)throw new Error("Container drag mode must specify containers")}grabContainerDrag(t){const r=this;if(!r.ignoreSelector||!t.target.closest(r.ignoreSelector)){const n=E.getAncestor(t.target,r.containers,r.outerElement);if(n){const s=n.getBoundingClientRect();r.context={element:n,position:E.getStyleValue(n,"position"),valid:!0,action:"container",offsetX:t.pageX-s.left,offsetY:t.pageY-s.top,originalPosition:{parent:n.parentElement,prev:n.previousElementSibling,next:n.nextElementSibling}}}return!0}return!1}startContainerDrag(t){const r=this,{context:n,floatRootOwner:s}=r,{element:a}=n,o=a.cloneNode(!0),l=s==null?void 0:s.element.closest(".b-outer");o.classList.add(r.dragProxyCls,r.draggingCls),((s==null?void 0:s.floatRoot)||E.getRootElement(a)).appendChild(o),n.dragProxy=o,n.dragging=a,a.classList.add(r.dropPlaceholderCls),s&&s.element.classList.add("b-dragging-child"),l&&(o.style.zIndex=s.floatRootMaxZIndex+1)}onContainerDragStarted(t){const r=this,{context:n}=r,{element:s,dragProxy:a}=n,o=s.getBoundingClientRect();if(r.autoSizeClonedTarget)a.style.width=o.width+"px",a.style.height=o.height+"px",E.setTranslateXY(n.dragProxy,o.left,o.top);else if(r.useCenteredCursor){const l=a.getBoundingClientRect();Object.assign(n,{offsetX:l.width/2,offsetY:l.height/2}),E.setTranslateXY(a,t.clientX,t.clientY)}}updateContainerDrag(t){var r;const n=this,{context:s}=n,{targetElement:a}=s;if(!s.started||!a)return;let o=E.getAncestor(a,n.containers);const l=(r=s.dragging)==null?void 0:r.contains(E.getActiveElement(s.dragging));o&&E.isDescendant(s.element,o)||(l&&ce.suspendFocusEvents(),s.valid&&(o||n.containers.some(d=>d.contains(a)))?(o||(o=n.containers.find(d=>d.contains(a)).lastElementChild),n.moveNextTo(o,t)):n.revertPosition(),l&&ce.resumeFocusEvents(),t.preventDefault())}finishContainerDrag(t){const r=this,{context:n}=r,{dragging:s,dragProxy:a,valid:o,draggedTo:l,insertBefore:d,originalPosition:c}=n;s&&(n.valid=!!(o&&(l||r.externalDropTargetSelector&&t.target.closest(r.externalDropTargetSelector))&&(s!==d||c.parent!==l)),n.finalize=(u=n.valid)=>{!u&&r.context&&r.revertPosition(),s.classList.remove(r.dropPlaceholderCls),a.remove(),r.reset()},n.async=!1,r.trigger("drop",{context:n,event:t}),n.async||n.finalize())}abortContainerDrag(t=!1,r=null,n=!1){const s=this,{context:a}=s;a.dragging&&(a.dragging.classList.remove(s.dropPlaceholderCls),a.dragProxy.remove(),s.revertPosition()),n||s.trigger(t?"drop":"abort",{context:a,event:r}),s.reset()}updateContainerProxy(t){var r,n;const s=this,{context:a}=s,o=a.dragProxy;let l=t.pageX-a.offsetX,d=t.pageY-a.offsetY;typeof s.minX=="number"&&(l=Math.max(s.minX,l)),typeof s.maxX=="number"&&(l=Math.min(s.maxX-o.offsetWidth,l)),typeof s.minY=="number"&&(d=Math.max(s.minY,d)),typeof s.maxY=="number"&&(d=Math.min(s.maxY-o.offsetHeight,d)),s.lockX?E.setTranslateY(o,d):s.lockY?E.setTranslateX(o,l):E.setTranslateXY(o,l,d);let c;if(t.type==="touchmove"){const u=t.changedTouches[0];c=E.elementFromPoint(u.clientX,u.clientY)}else c=t.target;a.targetElement=((r=s.resolveTargetElement)==null?void 0:r.call(s,c))||c,(n=a.targetElement.nextElementSibling)!=null&&n.matches(`.${s.dropPlaceholderCls}`)||(a.insertBefore=a.targetElement.nextElementSibling)}moveNextTo(t,r){const{context:n}=this,s=n.dragging,a=t.parentElement;if(t!==s){const o=$.from(t).center.x;if(this.isRTL&&r.pageX>o||!this.isRTL&&r.pageX<o){const l=t.previousElementSibling;a.insertBefore(s,t),n.insertBefore=t,l!==s&&this.trigger("itemMove",{context:n,event:r})}else t.nextElementSibling?t.nextElementSibling!==s?(n.insertBefore=t.nextElementSibling,a.insertBefore(s,t.nextElementSibling),this.trigger("itemMove",{context:n,event:r})):!n.insertBefore&&s.parentElement.lastElementChild!==s&&(n.insertBefore=t.nextElementSibling):(a.appendChild(s),this.trigger("itemMove",{context:n,event:r}),n.insertBefore=null);n.draggedTo=a}}revertPosition(){const{context:t}=this,{dragging:r,originalPosition:n}=t,{parent:s,next:a}=n;n.parent===r.parent&&n.prev===r.previousElementSibling&&n.next===r.nextElementSibling||(a?s.insertBefore(r,a):s.appendChild(r),this.trigger("itemMove",{context:t})),t.draggedTo=null}},p(e,"$name","DragHelperContainer"),e},DL={pageXOffset:0,pageYOffset:0},EL=i=>{var e;return e=class extends be(i||O){static get configurable(){return{positioning:null,skipUpdatingElement:null}}initTranslateDrag(){const t=this;!t.isElementDraggable&&t.targetSelector&&(t.isElementDraggable=r=>r.closest(t.targetSelector))}grabTranslateDrag(t){const r=this.getTarget(t);return r?(this.context={valid:!0,element:r,position:E.getStyleValue(r,"position"),startPageX:t.pageX,startPageY:t.pageY,startClientX:t.clientX,startClientY:t.clientY},!0):!1}getTarget(t){const{targetSelector:r,target:n}=this;if(r)return t.target.closest(r);const s=n.isWidget?n.element:n;return s.contains(t.target)?s:null}getX(t){return this.positioning==="absolute"?parseFloat(t.style.left,10):this.positioning==="inset"?parseFloat(getComputedStyle(t).insetInlineStart,10):E.getTranslateX(t)}getY(t){return this.positioning==="absolute"?parseFloat(t.style.top,10):this.positioning==="inset"?parseFloat(getComputedStyle(t).top,10):E.getTranslateY(t)}getXY(t){if(this.positioning==="absolute")return[t.offsetLeft,t.offsetTop];if(this.positioning==="inset"){const r=getComputedStyle(t);return[parseFloat(r.insetInlineStart,10),parseFloat(r.top,10)]}return E.getTranslateXY(t)}setXY(t,r,n){this.skipUpdatingElement||(this.positioning==="absolute"?(t.style.left=r+"px",t.style.top=n+"px"):this.positioning==="inset"?(t.style.insetInlineStart=r+"px",t.style.top=n+"px"):E.setTranslateXY(t,r,n))}startTranslateDrag(t){const r=this,{context:n,outerElement:s,proxySelector:a}=r,o=r.dragWithin=r.dragWithin||r.cloneTarget&&document.body;let l=n.dragProxy||n.element;const d=l,c=l.parentElement;if(r.cloneTarget){const f=a?l.querySelector(a):l;let{width:g,height:m,x:v,y}=$.from(f,$.outer(o));r.isRTL&&l.style.insetInlineStart&&(v=$.outer(o).right-$.from(l).right),l=r.createProxy(l);let b=v,C=y;if(r.autoSizeClonedTarget&&(l.style.width=`${g}px`,l.style.height=`${m}px`),l.classList.add(r.dragProxyCls,r.draggingCls),l.classList.remove("b-hover","b-selected","b-focused"),o.appendChild(l),!r.autoSizeClonedTarget||a){const D=l.getBoundingClientRect(),{x:w,y:x}=o.getBoundingClientRect(),R=t.clientX-w,M=t.clientY-x+(o!==document.body?document.body.getBoundingClientRect().y:0);b=R-D.width/2,C=M-D.height/2,n.startPageX=t.pageX,n.startPageY=t.pageY}r.setXY(l,b,C),d.classList.add("b-drag-original"),r.hideOriginalElement&&d.classList.add("b-hidden")}l.classList.add(r.draggingCls);const u=r.getX(l),h=r.getY(l);Object.assign(n,{element:l,grabbed:d,grabbedParent:c,grabbedNextSibling:l.nextElementSibling,elementStartX:u,elementStartY:h,elementX:r.positioning==="inset"?u:E.getOffsetX(l,o||s),elementY:r.positioning==="inset"?h:E.getOffsetY(l,o||s),scrollX:0,scrollY:0,scrollManagerElementContainsDragProxy:!r.cloneTarget||o===s}),o&&(n.parentElement=l.parentElement,o!==l.parentElement&&o.appendChild(l),r.updateTranslateProxy(t))}onTranslateDragStarted(){const t=this,{context:r}=t;let{relatedElements:n}=r;if(t.unifiedProxy&&r.element.classList.add("b-drag-main","b-drag-unified-proxy"),(n==null?void 0:n.length)>0){r.relatedElStartPos=[],r.relatedElDragFromPos=[];const{proxySelector:s}=t;let[a,o]=[r.elementStartX,r.elementStartY];r.originalRelatedElements=n,n=r.relatedElements=n.map((l,d)=>{const c=s?l.querySelector(s):l,{x:u,y:h,width:f,height:g}=$.from(c,t.dragWithin),m=t.cloneTarget?t.createProxy(l):l;return m.classList.add(t.draggingCls),m.classList.remove("b-hover","b-selected","b-focused"),t.cloneTarget&&(t.setXY(m,u,h),t.dragWithin.appendChild(m),m.classList.add(t.dragProxyCls),t.autoSizeClonedTarget&&(m.style.width=`${f}px`,m.style.height=`${g}px`),t.hideOriginalElement&&l.classList.add("b-hidden"),l.classList.add("b-drag-original")),r.relatedElStartPos[d]=r.relatedElDragFromPos[d]=t.getXY(m),t.unifiedProxy&&(m.classList.add("b-drag-unified-animation","b-drag-unified-proxy"),a+=t.unifiedOffset,o+=t.unifiedOffset,t.setXY(m,a,o),r.relatedElDragFromPos[d]=[a,o],m.style.zIndex=100-d),m}),t.unifiedProxy&&n&&n.length>0&&j.onTransitionEnd({element:n[0],property:"transform",handler(){n.forEach(l=>l.classList.remove("b-drag-unified-animation"))},thisObj:t,once:!0})}}applyConstraints(t,r,n){const s=this,{constrain:a,dragWithin:o}=s,{pageXOffset:l,pageYOffset:d}=o===document.body?globalThis:DL;if(o&&a){const c=new $(r,n,t.offsetWidth,t.offsetHeight),u=$.from(o);s.context.position!=="fixed"&&(u.height=o.scrollHeight,u.width=o.scrollWidth,u.moveTo(0,0)),{x:r,y:n}=c.constrainTo(u)}return typeof s.minX=="number"&&(r=Math.max(s.minX+l,r)),typeof s.maxX=="number"&&(r=Math.min(s.maxX+l,r)),typeof s.minY=="number"&&(n=Math.max(s.minY+d,n)),typeof s.maxY=="number"&&(n=Math.min(s.maxY+d,n)),{constrainedX:r,constrainedY:n}}updateTranslateProxy(t,r){const n=this,{lockX:s,lockY:a,context:o}=n,l=o.dragProxy||o.element,{relatedElements:d,relatedElDragFromPos:c}=o,u=n.isRTL&&n.positioning==="inset"?-1:1;o.scrollManagerElementContainsDragProxy&&r&&(o.scrollX=r.getRelativeLeftScroll(l),o.scrollY=r.getRelativeTopScroll(l)),o.pageX=t.pageX,o.pageY=t.pageY,o.clientX=t.clientX,o.clientY=t.clientY;let h=o.elementStartX+(t.pageX-o.startPageX+o.scrollX)*u,f=o.elementStartY+t.pageY-o.startPageY+o.scrollY;if(n.snapCoordinates){const v=n.snapCoordinates({element:l,newX:h,newY:f});h=v.x,f=v.y}const{constrainedX:g,constrainedY:m}=n.applyConstraints(l,h,f);if((o.started||g!==h||m!==f)&&n.setXY(l,s?void 0:g,a?void 0:m),d){const v=s?0:g-o.elementStartX,y=a?0:m-o.elementStartY;d.forEach((b,C)=>{const[D,w]=c[C];n.setXY(b,D+v,w+y)})}o.newX=g,o.newY=m}async finishTranslateDrag(t){const r=this,n=r.context,{target:s}=t,a=!r.lockX&&Math.round(n.newX)!==Math.round(n.elementStartX),o=!r.lockY&&Math.round(n.newY)!==Math.round(n.elementStartY),l=n.dragProxy||n.element,{relatedElements:d}=n;if(!r.ignoreSamePositionDrop||a||o)if(n.valid===!1)await r.abortTranslateDrag(!0,t);else{const c=!r.allowDropOutside&&$.from(r.dragWithin||r.outerElement);c&&(typeof r.minX!="number"&&r.minX!==!0&&t.pageX<c.left||typeof r.maxX!="number"&&r.maxX!==!0&&t.pageX>c.right||typeof r.minY!="number"&&r.minY!==!0&&t.pageY<c.top||typeof r.maxY!="number"&&r.maxY!==!0&&t.pageY>c.bottom)?await r.abortTranslateDrag(!0,t):(n.finalize=async(u=n.valid)=>{if(n.finalized){console.warn("DragHelper: Finalizing already finalized drag");return}n.finalized=!0,!u&&r.context&&await r.abortTranslateDrag(!0,null,!0),r.isDestroyed||(r.trigger("dropFinalized",{context:n,event:t,target:s}),r.reset()),!r.cloneTarget&&l.parentElement!==n.grabbedParent&&[l,...d||[]].forEach(h=>h.style.transform="")},n.async=!1,await r.trigger("drop",{context:n,event:t,target:s}),n.async||await n.finalize())}else r.abortTranslateDrag(!1,t)}async abortTranslateDrag(t=!1,r=null,n=!1){var s,a,o;const l=this,{cloneTarget:d,context:c,proxySelector:u,dragWithin:h,draggingCls:f}=l,{relatedElements:g,relatedElStartPos:m,grabbed:v}=c,y=c.dragProxy||c.element;if(c.valid=!1,(s=l.scrollManager)==null||s.stopMonitoring(),c.aborted){console.warn("DragHelper: Aborting already aborted drag");return}let{elementStartX:b,elementStartY:C}=c;const D=b!==l.getX(y)||C!==l.getY(y);if(y&&c.started){if(!d&&h&&h!==c.grabbedParent&&c.grabbedParent.insertBefore(y,c.grabbedNextSibling),d&&u){const w=v.querySelector(u)||v,{x,y:R}=$.from(w);b=x,C=R}if(y.classList.add("b-aborting"),l.setXY(y,b,C),g==null||g.forEach((w,x)=>{w.classList.remove(f),w.classList.add("b-aborting"),l.setXY(w,m[x][0],m[x][1])}),n||l.trigger(t?"drop":"abort",{context:c,event:r}),y.isConnected&&!l.isDestroying&&D){const w=l.positioning==="inset"?"inset":"transform";(a=y.getAnimations)!=null&&a.call(y).length&&await j.waitForTransitionEnd({element:y,property:E.getPropertyTransitionDuration(y,w)?w:"all",thisObj:l,once:!0,timeout:300,runOnDestroy:!0})}l.isDestroyed||l.trigger("abortFinalized",{context:c,event:r})}(o=l.context)!=null&&o.started&&l.reset()}cleanUp(){const t=this,{context:r,cloneTarget:n,draggingCls:s,dragProxyCls:a}=t,o=r.dragProxy||r.element,{relatedElements:l,originalRelatedElements:d,grabbed:c}=r,u=n&&(t.removeProxyAfterDrop||!r.valid),h=[s,"b-aborting",a,"b-drag-main","b-drag-unified-proxy"];o.classList.remove(...h),u&&o.remove(),l==null||l.forEach(f=>{u?f.remove():f.classList.remove(...h)}),c.classList.remove("b-drag-original","b-hidden"),d==null||d.forEach(f=>f.classList.remove("b-hidden","b-drag-original"))}},p(e,"$name","DragHelperTranslate"),e},Rx=Symbol("body"),Ks={move:"onMouseMove",up:"onMouseUp",docclick:"onDocumentClick",touchstart:"onTouchStart",touchmove:"onTouchMove",touchend:"onTouchEnd",keydown:"onKeyDown",keyup:"onKeyDownUp"},Tx=class _D extends O.mixin(Ie,wL,EL){construct(e){const t=this;super.construct(e),t.initListeners(),t.isContainerDrag?t.initContainerDrag():t.initTranslateDrag(),t.onScrollManagerScrollCallback=t.onScrollManagerScrollCallback.bind(t)}doDestroy(){this.reset(!0),super.doDestroy()}changeOuterElement(e){return e===Rx?document.body:e}initListeners(){const e=this,{outerElement:t}=e,r={element:t,pointerdown:"onPointerDown",thisObj:e};e.mouseMoveListenerElement=e.getMouseMoveListenerTarget(t),j.on(r)}getMouseMoveListenerTarget(e){const t=e.getRootNode();let r=this.mouseMoveListenerElement;return t.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&t.mode==="closed"&&(r=e.closest(".b-outer")||r),r}get isRTL(){var e;return!!((e=this.rtlSource)!=null&&e.rtl)}onPointerDown(e){const t=this;if(e.button!==0||t.context||t.disabled||t.isElementDraggable&&!t.isElementDraggable(e.target,e))return;if(t.startEvent=e,t.isContainerDrag?t.grabContainerDrag(e):t.grabTranslateDrag(e)){const n=globalThis;t.blurDetacher=j.on({element:n,blur:t.onWindowBlur,thisObj:t});const s={element:t.mouseMoveListenerElement,thisObj:t,capture:!0,keydown:Ks.keydown,keyup:Ks.keyup};if(e.pointerType==="touch"?(t.touchStartTimer=t.setTimeout(()=>t.touchStartTimer=null,t.touchStartDelay,"touchStartDelay"),s.touchmove={handler:Ks.touchmove,passive:!1},s.touchend=s.pointerup=Ks.touchend):(s.pointermove=Ks.move,s.pointerup=Ks.up),t.dragListenersDetacher=j.on(s),t.dragWithin&&t.dragWithin!==t.outerElement&&t.outerElement.contains(t.dragWithin)){const a=$.from(t.dragWithin,t.outerElement);t.minY=a.top,t.maxY=a.bottom,t.minX=a.left,t.maxX=a.right}}}async internalMove(e){var t,r,n,s;if(e.scrollInitiated)return;const a=this,{context:o}=a,l=j.getDistanceBetween(a.startEvent,e);if(a.touchStartTimer&&l>a.dragThreshold){a.abort(!0);return}if(!a.touchStartTimer&&(o!=null&&o.element)&&(o.started||l>=a.dragThreshold)&&((t=e.target)==null?void 0:t.nodeType)===Node.ELEMENT_NODE){if(!o.started){const c=j.getXY(a.startEvent),u=j.getXY(e),h=Math.abs(c[0]-u[0])>=Math.abs(c[1]-u[1])?"horizontal":"vertical";if(!o.beforeDragStartFired&&a.trigger("beforeDragStart",{context:o,event:e,initialDirection:h})===!1)return a.abort();if(o.beforeDragStartFired=!0,Math.abs(j.getDistanceBetween(a.startEvent,e,{x:a.lockY,y:a.lockX}))<a.dragThreshold)return;a.isContainerDrag?a.startContainerDrag(e):a.startTranslateDrag(e),(n=(r=o.dragProxy)==null?void 0:r.closest)!=null&&n.call(r,".b-float-root")&&(o.dragProxy.style.fontSize=E.getStyleValue(o.element,"fontSize")),o.started=_D.dragging=!0,(s=a.scrollManager)==null||s.startMonitoring(T.merge({scrollables:[{element:a.dragWithin||a.outerElement}],callback:a.onScrollManagerScrollCallback},a.monitoringConfig)),o.outermostEl=E.getOutermostElement(e.target),o.outermostEl.classList.add("b-draghelper-active"),a.dropTargetSelector&&a.dropTargetCls&&E.getRootElement(a.outerElement).querySelectorAll(a.dropTargetSelector).forEach(g=>g.classList.add(a.dropTargetCls));const f=a.trigger("dragStart",{context:o,event:e,initialDirection:h});T.isPromise(f)&&await f,a.onKeyDownUp(e),o.moveUnblocked=!0,a.isContainerDrag?a.onContainerDragStarted(e):a.onTranslateDragStarted(e),a.trigger("afterDragStart",{context:o,event:e,initialDirection:h})}o.moveUnblocked?a._cachedMouseEvent?(a.update(e),a.update(a._cachedMouseEvent),delete a._cachedMouseEvent):a.update(e):a._cachedMouseEvent=e}}onScrollManagerScrollCallback(e){var t;const{lastMouseMoveEvent:r}=this;(t=this.context)!=null&&t.element&&r&&(r.isScroll=!0,this.update(r,e))}onTouchMove(e){var t;((t=e.changedTouches)==null?void 0:t.length)===1&&(this.context&&!this.touchStartTimer&&e.preventDefault(),this.internalMove(e))}onMouseMove(e){this.internalMove(e)}update(e,t){const r=this,n=document.scrollingElement||document.body,{context:s}=r;let a=r.getMouseMoveEventTarget(e);if(e.type==="touchmove"){const l=e.changedTouches[0];a=E.getRootElement(e.target).getRootNode().elementFromPoint(l.clientX+n.scrollLeft,l.clientY+n.scrollTop)}s.target=a;let o=r.allowDropOutside||!r.dragWithin||r.dragWithin.contains(e.target);o&&r.dropTargetSelector&&(o=o&&!!(a!=null&&a.closest(r.dropTargetSelector))),r.isContainerDrag?r.updateContainerProxy(e,t):r.updateTranslateProxy(e,t),s.valid=o,r.trigger("drag",{context:s,event:e}),r.isContainerDrag&&r.updateContainerDrag(e,t),s.valid=s.valid&&o;for(const l of r.draggedElements)l.classList.toggle(r.invalidCls,!s.valid);e&&(r.lastMouseMoveEvent=e)}get draggedElements(){var e;const{context:t}=this;return[t.dragProxy||t.element,...(e=t.relatedElements)!=null?e:[]]}async abort(e=!1){var t,r;const n=this,{context:s}=n;(r=(t=n.scrollManager)==null?void 0:t.stopMonitoring)==null||r.call(t),n.removeListeners(),s!=null&&s.started&&!s.aborted?(s.element.getBoundingClientRect(),s.valid=!1,n.isContainerDrag?n.abortContainerDrag(void 0,void 0,e):n.abortTranslateDrag(void 0,void 0,e),s.aborted=!0):n.reset(!0)}removeListeners(){var e,t;(e=this.dragListenersDetacher)==null||e.call(this),(t=this.blurDetacher)==null||t.call(this)}reset(e){var t;const r=this,{context:n}=r;if(n!=null&&n.started){for(const s of r.draggedElements)s.classList.remove(r.invalidCls);n.outermostEl.classList.remove("b-draghelper-active"),r.isContainerDrag?(n.dragProxy.remove(),(t=r.floatRootOwner)==null||t.element.classList.remove("b-dragging-child")):r.cleanUp(),r.dropTargetSelector&&r.dropTargetCls&&E.getRootElement(r.outerElement).querySelectorAll(r.dropTargetSelector).forEach(s=>s.classList.remove(r.dropTargetCls))}r.removeListeners(),e||r.trigger("reset"),r.context=r.lastMouseMoveEvent=null,_D.dragging=!1}onTouchEnd(e){E.getOutermostElement(e.target).classList.remove("b-no-touch-scroll"),this.onMouseUp(e)}onDocumentClick(e){e.stopPropagation()}onMouseUp(e){var t;const r=this,{context:n}=r;r.removeListeners(),n&&((t=r.scrollManager)==null||t.stopMonitoring(),n.started?n.moveUnblocked?(e.stopPropagation(),n.finalizing=!0,r.isContainerDrag?r.finishContainerDrag(e):r.finishTranslateDrag(e),j.on({element:document,thisObj:r,click:Ks.docclick,capture:!0,expires:r.clickSwallowDuration,once:!0})):r.ion({drag(){r.onMouseUp(e)},once:!0}):r.reset(!0))}onKeyDown(e){var t;(t=this.context)!=null&&t.started&&e.key==="Escape"&&(e.stopImmediatePropagation(),this.abort()),this.onKeyDownUp(e)}onKeyDownUp(e){var t;(t=this.context)==null||t.element.classList.toggle("b-drag-copy",e[Y.ctrlKey]||e[Y.metaKey])}onWindowBlur(){this.context&&!this.context.finalizing&&this.abort()}createProxy(e){this.proxySelector&&(e=e.querySelector(this.proxySelector)||e);const t=e.cloneNode(!0);return t.removeAttribute("id"),t}get isContainerDrag(){return this.mode==="container"}async animateProxyTo(e,t={align:"c-c"}){const{context:r,draggedElements:n}=this,{element:s}=r,a=e.isRectangle?e:$.from(e);n.forEach(o=>{o.classList.add("b-drag-final-transition"),E.alignTo(o,a,t,void 0,void 0,this.positioning==="inset"?"topInset":"translate")}),await j.waitForTransitionEnd({element:s,property:"all",thisObj:this,once:!0}),n.forEach(o=>o.classList.remove("b-drag-final-transition"))}get isDragging(){var e;return!!((e=this.context)!=null&&e.started)}getMouseMoveEventTarget(e){return e.isScroll?E.elementFromPoint(e.clientX,e.clientY):e.target}};p(Tx,"configurable",{dragProxyCls:"b-drag-proxy",invalidCls:"b-drag-invalid",draggingCls:"b-dragging",dropPlaceholderCls:"b-drop-placeholder",dragThreshold:5,outerElement:Rx,dragWithin:null,unifiedProxy:null,monitoringConfig:null,constrain:!0,minX:null,maxX:null,minY:null,maxY:null,mode:"translateXY",isElementDraggable:null,targetSelector:null,target:null,dropTargetSelector:null,dropTargetCls:null,proxySelector:null,cloneTarget:!1,autoSizeClonedTarget:!0,hideOriginalElement:!1,containers:null,ignoreSelector:null,startEvent:null,lockX:!1,lockY:!1,touchStartDelay:200,scrollManager:null,snapCoordinates:null,unifiedOffset:5,removeProxyAfterDrop:!0,clickSwallowDuration:50,ignoreSamePositionDrop:!0,allowDropOutside:null,floatRootOwner:null,mouseMoveListenerElement:document,externalDropTargetSelector:null,testConfig:{clickSwallowDuration:50,touchStartDelay:100},rtlSource:null,resolveTargetElement:null,disabled:!1});var xi=Tx;xi._$name="DragHelper";var xL=Array.prototype.slice,Mx=Object.freeze([]),RL=Object.freeze({}),Ix=/[&<]/,{getPrototypeOf:_x}=Object,{toString:TL}=Object.prototype,{isEqual:Fx,isObject:ML}=T,IL={parent:1,elementData:1,ns:1,syncOptions:1},Ax=()=>({ignore:IL,refsFound:new Set}),cb={class:1,className:1,classname:1},_L={bigint:1,boolean:1,function:1,number:1,string:1,symbol:1},FL={tag:1,html:1,text:1,children:1,tooltip:1,parent:1,nextSibling:1,ns:1,reference:1,elementData:1,retainElement:1,compareHtml:1,syncOptions:1,listeners:1,isReleased:1,null:1,"":1,keepChildren:1,retainChildren:1},AL=(i,e)=>{const t="className"in e?"className":"class",r=e[t];if(r)if(typeof r=="string"){const n=r.split(" ");n.includes(i)||(n.push(i),e[t]=n.join(" "))}else Array.isArray(r)?r.includes(i)||r.push(i):r.isDomClassList?r.add(i):T.isObject(r)&&(r[i]=1)},PL=(i,e)=>{const t="className"in e?"className":"class",r=e[t];if(r)if(typeof r=="string"){const n=r.split(" ");n.includes(i)&&(n.splice(n.indexOf(i),1),e[t]=n.join(" "))}else Array.isArray(r)?r.includes(i)&&r.splice(r.indexOf(i),1):r.isDomClassList?r.remove(i):T.isObject(r)&&delete r[i]},he=class tt{static checkEquality(e,t,r,n){var s;if(e===t)return!0;if(e==null)return t==null;if(!e||!t)return!1;const a=typeof e;if(a!==typeof t||_L[a])return!1;let l=r.equalityCache||(r.equalityCache=new Map),d=!!n,c,u,h,f,g,m,v;if(l=l.get(e)||l.set(e,new Map).get(e),c=l.get(t),c===void 0){if(c=!0,_x(e)!==_x(t)||e instanceof Node)c=!1;else if(Array.isArray(e)){if(u=e.length,u!==t.length)c=!1;else for(;u-- >0;)if(!tt.checkEquality(e[u],t[u],r,d)){c=!1;break}}else{m=e.syncOptions,f=m==null?void 0:m.ignoreRefs,f&&(d=!0,n=f!=="children"),h=r.ignore||RL;for(g in t)if(!h[g]&&!(g in e)&&!(n&&g==="reference")){c=!1;break}if(c){if(TL.call(t)==="[object Date]")c=e.getTime()===t.getTime();else if(E.isReactElement(e)||E.isReactElement(t)||E.isVueConfig(e)||E.isVueConfig(t))c=!1;else for(g in e)if(!h[g]&&!(n&&g==="reference")){if(!(g in t)){c=!1;break}if(v=e[g],!tt.checkEquality(v,t[g],r,d)){c=!1;break}}}}!n&&ML(e)&&e.reference&&((s=r.refsFound)==null||s.add(e.reference)),l.set(t,c)}return c}static sync(e){var t;const r=e,{refOwner:n}=e,s=n==null?void 0:n.byRef,a=Ax();let o=e.affected,l,d,c,u;if(typeof o=="string"&&(o=[o]),e={...e,checkEqualityOptions:a},n){if(n.byRef={},o)for(d in s)o.includes(d)||(n.byRef[d]=s[d]);e.refsWas=s}if(r.changed=tt.performSync(e,e.targetElement),n&&s&&(o=o||Object.keys(s)))for(l=0;l<o.length;++l)d=o[l],c=s[d],a.refsFound.has(d)||c.retainElement?n.byRef[d]=c:(u=c.lastDomConfig,(t=c.blur)==null||t.call(c),c.remove(),n.detachRef(d,c,u));return e.targetElement}static performSync(e,t){const{domConfig:r,callback:n}=e,{lastDomConfig:s}=t;if((e.configEquality||tt.checkEquality)(r,s,e.checkEqualityOptions,e.ignoreRefs))n==null||n({action:"none",domConfig:r,targetElement:t});else return r?(r.onlyChildren||(tt.syncAttributes(r,t,e),tt.syncContent(r,t)),r.keepChildren||tt.syncChildren(e,t)):(t.innerHTML=null,t.syncIdMap=null),t.lastDomConfig=r!=null&&r.onlyChildren&&s?{...s,children:r.children}:r,!0;return!1}static syncDataset(e,t){const{lastDomConfig:r}=t,n=e===r,s=Object.keys(e.dataset),a=r&&r.dataset&&Object.keys(r.dataset),o=L.delta(s,a);let l,d,c,u;for(d=0;d<o.onlyInA.length;d++)l=o.onlyInA[d],u=e.dataset[l],u!=null&&t.setAttribute(`data-${k.hyphenate(l)}`,u);for(d=0;d<o.inBoth.length;d++)l=o.inBoth[d],u=e.dataset[l],(n||u!=r.dataset[l])&&(c=`data-${k.hyphenate(l)}`,u==null?t.removeAttribute(c):t.setAttribute(c,u));for(d=0;d<o.onlyInB.length;d++)t.removeAttribute(`data-${k.hyphenate(o.onlyInB[d])}`)}static addCls(e,t){const{lastDomConfig:r}=t;e=le.normalize(e,"array"),e.forEach(n=>{t.classList.add(n),AL(n,r)})}static removeCls(e,t){const{lastDomConfig:r}=t;e=le.normalize(e,"array"),e.forEach(n=>{t.classList.remove(n),PL(n,r)})}static syncClassList(e,t,r){let n=e.className||e.class,s=!1,a,o,l,d,c,u;if(r){for(o=le.normalize(t,"array"),n=le.normalize(n,"object"),u=le.normalize(r.className||r.class,"object"),c=[],l=0,d=o.length;l<d;++l)a=o[l],n[a]||!(a in u)?(u[a]=1,c.push(a)):s=!0;for(a in n)u[a]||(c.push(a),s=!0);if(!s)return;n=c.join(" ")}else n=le.normalize(n);t.setAttribute("class",n)}static getSyncAttributes(e){const t={},r=[];return e&&Object.keys(e).forEach(n=>{if(!FL[n]){const s=n.toLowerCase();t[s]=e[n],r.push(s)}}),{attributes:t,names:r}}static syncAttributes(e,t,r){const{lastDomConfig:n}=t,s=e===n,a=tt.getSyncAttributes(e),{attributes:o,names:l}=a,{attributes:d,names:c}=s?a:tt.getSyncAttributes(n),{onlyInA:u,onlyInB:h,inBoth:f}=s?{onlyInA:Mx,onlyInB:Mx,inBoth:l}:L.delta(l,c);let g,m,v=!1;for(m=0;m<u.length;m++){g=u[m];const y=o[g];g==="style"&&y!=null?E.applyStyle(t,y,!0):g==="dataset"?tt.syncDataset(e,t):cb[g]?(tt.syncClassList(e,t),v=!0):y!=null&&t.setAttribute(g,y)}for(m=0;m<f.length;m++){g=f[m];const y=o[g],b=d[g];y==null?t.removeAttribute(g):g==="style"?r.strict?s?tt.syncStyles(t,y):Fx(y,b,!0)||tt.syncStyles(t,y,b):(s||!Fx(y,b,!0))&&E.applyStyle(t,y,!0):g==="dataset"?tt.syncDataset(e,t):cb[g]?(tt.syncClassList(e,t,r.strict&&t.lastDomConfig),v=!0):(s||y!==b)&&t.setAttribute(g,y)}for(m=0;m<h.length;m++)g=h[m],(!cb[g]||!v)&&t.removeAttribute(g)}static syncStyles(e,t,r){let n,s,a;if(!r)n=t;else{if(n={},t=E.parseStyle(t),r=E.parseStyle(r),t)for(s in t)a=t[s],r[s]!==a&&(n[s]=a);for(s in r)s in t||(n[s]="")}E.applyStyle(e,n)}static syncContent(e,t){var r;const{html:n,text:s}=e,a=s!=null?s:n;if(t.didSetTextContent=!1,e.elementData&&(t.elementData=e.elementData),a instanceof DocumentFragment)t.childNodes.length===1&&E.getChildElementCount(t)===0&&a.childNodes.length===1&&E.getChildElementCount(a)===0?E.setInnerText(t,a.firstChild.data):(t.innerHTML="",t.appendChild(a));else if(n!=null&&Ix.test(n))t.innerHTML=String(n);else if(a!=null){const{lastDomConfig:o}=t;((r=o==null?void 0:o.children)!=null&&r.length||o!=null&&o.html&&Ix.test(t.lastDomConfig.html))&&(t.innerHTML=""),E.setInnerText(t,String(a)),t.didSetTextContent=!0}}static insertTextNode(e,t,r,n,s,a=null){const o=document.createTextNode(e);t.insertBefore(o,a),n&&(o.$refOwnerId=n.id),s&&(o.$domSyncOwner=s),r==null||r({action:"newNode",domConfig:e,targetElement:o})}static insertElement(e,t,r,n,s,a,o,l){var d;const c=l.ns?document.createElementNS(l.ns,e.tag||"svg"):document.createElement(e.tag||"div");e.elementData&&(c.elementData=e.elementData),o&&(c.$domSyncOwner=o),t.insertBefore(c,r),tt.performSync(l,c),a!=null&&(s[a]=c),!("role"in e)&&!e.tabIndex&&!e["aria-hidden"]&&!e.alt&&!E.isFocusable(c,!0)&&!c.htmlFor&&c.setAttribute("role","presentation"),n&&(c.$refOwnerId=n.id,a&&(c.$reference=a,n.attachRef(a,c,e))),(d=l.callback)==null||d.call(l,{action:"newElement",domConfig:e,targetElement:c,syncId:a})}static syncChildren(e,t){var r,n,s,a;let{domConfig:o,syncIdField:l,callback:d,releaseThreshold:c,configEquality:u,ns:h,refOwner:f,refsWas:g,strict:m,syncOwner:v,checkEqualityOptions:y,ignoreRefs:b}=e,C=null,D,w,x,R,M;const I=o.syncOptions||{};if((r=o.html)!=null?r:o.text)return;b=!!((n=I.ignoreRefs)!=null?n:b),b&&(f=g=null),"strict"in I&&(m=I.strict);const _=f?f.byRef:{},F=xL.call(o.children||[]),A=[],P=g||t.syncIdMap||{},V=t.releasedIdMap||{},B=q=>{for(;A.length&&A[0].parentNode!==t;)A.shift();return(q?A.shift():A[0])||null};for(D of t.childNodes)w=D.$domSyncOwner,(v?v===w:!w)&&A.push(D);l=I.syncIdField||l,m=I.strict||m,d=I.callback||d,u=I.configEquality||u,c="releaseThreshold"in I?I.releaseThreshold:c,l&&(t.syncIdMap=_);const W={checkEqualityOptions:y||Ax(),ignoreRefs:b,refOwner:f,refsWas:g,strict:m,syncIdField:l,releaseThreshold:c,syncOwner:v,callback:d,configEquality:u};for(;F.length;){const q=F.shift();if(M=null,!q)continue;if(E.isReactElement(q)||E.isVueConfig(q)){d({jsx:q,targetElement:t,domConfig:o});continue}if(Array.isArray(q)){this.syncChildren({...e,domConfig:{...e.domConfig,children:q}},t);continue}if(q instanceof Node){R=B(),q!==R&&t.insertBefore(q,R),x=A.indexOf(q),x>-1&&A.splice(x,1);continue}const G=typeof q=="string";if(W.domConfig=q,W.ns=q.ns||h,!G){if(f?M=q.reference:l&&q.dataset&&(M=q.dataset[l]),M!=null&&!q.unmatched){const ee=P[M]||V[M];if(ee){const{lastDomConfig:Q}=ee;ee.retainElement&&ee.retainElement!=="prevent-release"||tt.performSync(W,ee)&&(d==null||d({action:"reuseOwnElement",domConfig:q,targetElement:ee,lastDomConfig:Q,syncId:M})),q.retainElement&&(ee.retainElement=!0),_[M]=ee,L.remove(A,ee),delete V[M],ee.isReleased=!1,R=B(),(ee.parentNode!==t||m&&ee.nextSibling!==R)&&t.insertBefore(ee,R)}else m?tt.insertElement(q,t,B(),f,_,M,v,W):(F.push(q),q.unmatched=!0);continue}q.unmatched&&delete q.unmatched}let Z=null,ne=null,J;for(;!ne&&(J=B(!0));){if(f){if(J.$refOwnerId!==f.id)continue;if(J.$reference){if(!m)continue;Z=J;break}ne=J}else J.retainElement||(ne=J);ne||(C||(C=[])).push(J)}if(Z||!ne)G?tt.insertTextNode(q,t,d,f,v,Z):tt.insertElement(q,t,Z,f,_,M,v,W);else if(!G&&ne.nodeType===Node.ELEMENT_NODE&&(q.tag||"div").toLowerCase()===ne.tagName.toLowerCase()){const{lastDomConfig:ee}=ne,Q=tt.performSync(W,ne);if(l&&((s=ee==null?void 0:ee.dataset)==null?void 0:s[l])!=null){const ae=ee.dataset[l];delete V[ae],delete P[ae]}M!=null&&(_[M]=ne),ne.isReleased=!1,Q&&(d==null||d({action:"reuseElement",domConfig:q,targetElement:ne,lastDomConfig:ee,syncId:M}))}else G&&ne.nodeType===Node.TEXT_NODE?ne.data=q:(G?tt.insertTextNode(q,t,d,f,v,ne):tt.insertElement(q,t,ne,f,_,M,v,W),(a=ne.blur)==null||a.call(ne),ne.remove())}if(!(t.didSetTextContent&&A.length===1&&A[0].nodeType===Node.TEXT_NODE)&&!o.retainChildren){for(;R=B(!0);)(!f||R.$refOwnerId===f.id&&!R.$reference)&&(C||(C=[])).push(R);C&&tt.syncChildrenCleanup(t,C,_,d,f,c,l)}}static syncChildrenCleanup(e,t,r,n,s,a,o){var l;let d=0,c;for(const u of t){const{lastDomConfig:h}=u;if(u.nodeType===Element.TEXT_NODE){u.remove();continue}u.retainElement?o&&h&&(r[u.dataset[o]]=u):!s&&o&&(a==null||d<a)?(u.isReleased||(u.className="b-released",u.isReleased=!0,h!=null&&h.dataset&&(e.releasedIdMap||(e.releasedIdMap={}),e.releasedIdMap[h.dataset[o]]=u),n==null||n({action:"releaseElement",domConfig:h,lastDomConfig:h,targetElement:u}),h&&(h.isReleased=!0,h.className&&(h.className="b-released"),h.class&&(h.class="b-released"),h.style&&(h.style=null))),d++):((l=u.blur)==null||l.call(u),u.remove(),s&&(c=u.$reference,c&&s.detachRef(c,u,h)),e.releasedIdMap&&o&&(h!=null&&h.dataset)&&delete e.releasedIdMap[h.dataset[o]],n==null||n({action:"removeElement",domConfig:u.lastDomConfig,lastDomConfig:u.lastDomConfig,targetElement:u}))}}static removeChild(e,t){if(e.contains(t)){const r=e.syncIdMap;if(r){const n=Object.values(r).indexOf(t);n>-1&&delete r[Object.keys(r)[n]]}e.removeChild(t)}}static addChild(e,t,r){e.appendChild(t),e.syncIdMap||(e.syncIdMap={}),e.syncIdMap[r]=t}static getChild(e,t){var r;const n=String(t).split(".");for(const s of n)if(e=(r=e==null?void 0:e.syncIdMap)==null?void 0:r[s],!e)return null;return e}};he._$name="DomSync";var qt=class zv{static init(){const e=["fullscreenEnabled","requestFullscreen","exitFullscreen","fullscreenElement"],t=a=>e.map(o=>{let l=a+k.capitalize(o);return a==="moz"&&(l=l.replace("screen","Screen"),"mozCancelFullScreen"in document&&o==="exitFullscreen"&&(l="mozCancelFullScreen")),l});this.functions="fullscreenEnabled"in document&&e||"webkitFullscreenEnabled"in document&&t("webkit")||"mozFullScreenEnabled"in document&&t("moz")||"msFullscreenEnabled"in document&&t("ms")||[];const r=["fullscreenchange","fullscreenerror"],n=["MSFullscreenChange","MSFullscreenError"],s=a=>r.map(o=>a+k.capitalize(o));this.events="fullscreenEnabled"in document&&r||"webkitFullscreenEnabled"in document&&s("webkit")||"mozFullscreenEnabled"in document&&s("moz")||"msFullscreenEnabled"in document&&n||[],this.onFullscreenChange(this.onInternalFullscreenChange.bind(this))}static get enabled(){return!!(this.functions[0]&&document[this.functions[0]])}static async request(e){return this.functions[1]&&(e==null?void 0:e[this.functions[1]]())}static async exit(){return this.functions[2]&&document[this.functions[2]]()}static get isFullscreen(){return!!this.element}static get element(){return this.functions[3]&&document[this.functions[3]]}static onFullscreenChange(e){this.events[0]&&document.addEventListener(this.events[0],e)}static unFullscreenChange(e){this.events[0]&&document.removeEventListener(this.events[0],e)}static onInternalFullscreenChange(e){const t=globalThis.bryntum,{element:r}=zv;if(zv.isFullscreen&&t._floatRoot||!zv.isFullscreen&&!t._floatRoot)return;let n,s;if(r?r.closest(".b-floatroot")||(n=E.getRootElement(r).floatRoot,n&&(t._floatRoot=n,t._oldParent=n.parentElement,s=r)):(n=t._floatRoot,s=n&&t._oldParent,t._oldParent=t._floatRoot=null),s){const a=Array.from(n.querySelectorAll(".b-widget")).map(o=>z.fromElement(o));a.forEach(o=>{var l;return(l=o.beforeFloatReparent)==null?void 0:l.call(o)}),s.appendChild(n),a.forEach(o=>{var l;return(l=o.afterFloatReparent)==null?void 0:l.call(o)})}ce.trigger("fullScreenChange",{event:e})}};qt.init(),qt._$name="Fullscreen";var ub=null,hb=[],kL=i=>{var e;return i.nodeType===i.ELEMENT_NODE&&((e=i.ownerDocument.defaultView)==null?void 0:e.getComputedStyle(i).getPropertyValue("position"))==="absolute"},it=class PF{static addResizeListener(e,t){const r=this;if((e===document||e===globalThis)&&(e=document.body),e.nodeType===e.DOCUMENT_FRAGMENT_NODE&&(e=e.host),e.classList.contains("b-resize-monitored")||(e.classList.add("b-resize-monitored"),e._bResizemonitor={handlers:[]}),e===document.body)r.hasWindowResizeListener||(globalThis.addEventListener("resize",r.onWindowResize),r.hasWindowResizeListener=!0);else if(globalThis.ResizeObserver)r.resizeObserver||(r.resizeObserver=new ResizeObserver(r.onElementResize)),r.resizeObserver.observe(e);else{e.classList.add("b-no-resizeobserver");const[n,s,a]=E.createElement({parent:e,className:"b-resize-monitors",children:[{className:"b-resize-monitor-expand"},{className:"b-resize-monitor-shrink"}]},{returnAll:!0});s.scrollLeft=s.scrollTop=a.scrollLeft=a.scrollTop=1e6,s.addEventListener("scroll",r.onSizeMonitorScroll,!0),a.addEventListener("scroll",r.onSizeMonitorScroll,!0),(t.targetMutationMonitor=new MutationObserver(o=>{const l=[],d=[];for(const u of o)u.type==="childList"&&(l.push.apply(l,u.addedNodes),d.push.apply(d,u.removedNodes));const c=[...l.filter(u=>!d.includes(u)),...d.filter(u=>!l.includes(u))];c.length!==0&&(c.length>0&&c.every(kL)||s.dispatchEvent(new CustomEvent("scroll",{bubbles:!1})))})).observe(e,{childList:!0,subtree:!0}),t.monitorElement=n}e._bResizemonitor.handlers.push(t)}static removeResizeListener(e,t){if(e){(e===document||e===globalThis)&&(e=document.body);const r=e._bResizemonitor;let n=0;r&&r.handlers&&(L.remove(r.handlers,t),n=r.handlers.length),n||(e.classList.remove("b-resize-monitored"),this.resizeObserver?this.resizeObserver.unobserve(e):(t.monitorElement&&(t.monitorElement.remove(),t.monitorElement=null),t.targetMutationMonitor&&t.targetMutationMonitor.disconnect()))}}static onElementResize(e){for(const t of e){const r=t.target,n=r._bResizemonitor,s=t.contentRect||r.getBoundingClientRect();if(wn(r)&&(!n.rectangle||s.width!==n.rectangle.width||s.height!==n.rectangle.height)){const a=n.rectangle;n.rectangle=s;for(const o of n.handlers)o(r,a,s)}}}static onSizeMonitorScroll(e){var t;if(e.target.isConnected||(t=document.body)!=null&&t.contains(e.target)){e.stopImmediatePropagation();const r=e.target.parentNode,n=r.parentNode,s=n._bResizemonitor,a=n.getBoundingClientRect();(!s.rectangle||a.width!==s.rectangle.width||a.height!==s.rectangle.height)&&(hb.push([n,s.rectangle,a]),s.rectangle=a,ub||(ub=requestAnimationFrame(PF.fireResizeEvents))),r.firstChild.scrollLeft=r.firstChild.scrollTop=r.childNodes[1].scrollTop=r.childNodes[1].scrollLeft=1e6}}static onWindowResize(e){const t=document.body,r=t._bResizemonitor,n=r.rectangle;r.rectangle=document.documentElement.getBoundingClientRect();for(const s of r.handlers)s(t,n,r.rectangle)}static fireResizeEvents(){for(const e of hb)for(const t of e[0]._bResizemonitor.handlers)e[0].offsetParent&&t.apply(this,e);ub=null,hb.length=0}static removeGlobalListeners(){globalThis.removeEventListener("resize",this.onWindowResize)}};it._$name="ResizeMonitor";var Px={auto:"auto",true:"auto",false:"hidden","hidden-scroll":"auto",clip:Y.supportsOverflowClip?"clip":"hidden"},kx="b-widget-scroller",fb={block:"nearest"},LL=Promise.resolve(),Lx=i=>new Promise(e=>j.on({element:i===document.documentElement?globalThis:i,scroll:e,once:!0})),OL={x:1},Ho={auto:1,scroll:1},$L={true:1,auto:1},BL={overflowX:"auto",overflowY:"auto"},HL=i=>{var e,t,r,n;let s,a,o,l;return i?typeof i=="number"?s=a=o=l=i:(s=(e=i.top)!=null?e:0,a=(t=i.bottom)!=null?t:0,o=(r=i.start)!=null?r:0,l=(n=i.end)!=null?n:0):s=a=o=l=0,{block:{start:s,end:a},inline:{start:o,end:l}}},Xs=class Rg extends be(Ie(O)){static get configurable(){return{widget:null,element:{$config:{nullify:!0},value:null},contentElement:{$config:{nullify:!0},value:null},overflowX:null,overflowY:null,translate:null,behavior:null,x:0,y:0,rtlSource:null,propagateSync:null,stickies:null}}static get delayable(){return{onScrollEnd:{type:"buffer",delay:100}}}get isRTL(){var e;return!!((e=this.rtlSource)!=null&&e.rtl)}syncOverflowState(){const e=this,{hasOverflowX:t,hasOverflowY:r,element:n}=e,s=e.hasOverflowX=n.scrollWidth>n.clientWidth,a=e.hasOverflowY=n.scrollHeight>n.clientHeight;if(t!==s||r!==a){const o=new le(n.classList,{"b-horizontal-overflow":s,"b-vertical-overflow":a});E.syncClassList(n,o),e.isConfiguring||e.trigger("overflowChange",{x:s,y:a})}}hasOverflow(e="y"){const t=this,r=t[`overflow${e.toUpperCase()}`],n=t[`overflow${e==="y"?"x":"y"}`];if(!E.scrollBarWidth||!$L[r]||n==="hidden-scroll"){const s=e==="y"?"Height":"Width";return t[`scroll${s}`]>t[`client${s}`]}return t[`hasOverflow${e.toUpperCase()}`]}hasScrollbar(e="y"){const{element:t}=this;if(t&&E.scrollBarWidth){const r=e==="y",n=r?"Width":"Height",s=t[`client${n}`],a=parseInt(E.getStyleValue(t,`border${r?"Left":"Top"}Width`))+parseInt(E.getStyleValue(t,`border${r?"Right":"Bottom"}Width`)),o=t[`offset${n}`]-a-s;return Math.abs(o-E.scrollBarWidth)<2}}addPartner(e,t=OL){const r=this;typeof t=="string"&&(t={[t]:1}),r.partners||(r.partners={}),r.partners[e.id]={scroller:e,axes:t},t.x&&(e.x=r.x),t.y&&(e.y=r.y),e.isPartneredWith(r)||e.addPartner(r,t)}eachPartner(e){const{partners:t}=this;t&&Object.values(t).forEach(e)}removePartner(e){e&&this.isPartneredWith(e)&&(delete this.partners[e.id],e.removePartner(this))}isPartneredWith(e){var t;return!!((t=this.partners)!=null&&t[e.id])}clearPartners(){this.partners&&Object.values(this.partners).forEach(e=>e.scroller.removePartner(this))}async scrollIntoView(e,t=fb){const r=this,{isRectangle:n}=e,s=n?e:$.from(e),{xDelta:a,yDelta:o}=r.getDeltaTo(e,t),l=r.scrollBy(a,o,t);return(t.highlight||t.focus)&&l.then(()=>{var d,c;if(e=n?s.translate(-a,-o):(c=(d=t.elementAfterScroll)==null?void 0:d.call(t))!=null?c:e,t.highlight)if(isNaN(t.highlight)){const u=r.widget||r;u.callback(t.highlight,u,[e])}else E.highlight(e,r);t.focus&&e.focus({preventScroll:!0})}),l}static async scrollIntoView(e,t=fb,r=!1){const n=$.from(e),s=typeof t=="object"?t.animate:t,a=Rg._globalScroller||(Rg._globalScroller=new Rg),o=[];a.rtlSource={rtl:r};let l=0,d=0,c;t.maxWidth&&(n.width=Math.min(n.width,t.maxWidth),t.maxWidth=null),t.maxHeight&&(n.height=Math.min(n.height,t.maxHeight),t.maxHeight=null);for(let u=e.parentNode;u.nodeType===Node.ELEMENT_NODE;u=u.parentNode){if(u===document.body&&u!==document.scrollingElement)continue;const h=u===document.scrollingElement?BL:u.ownerDocument.defaultView.getComputedStyle(u),f=Ge.get(u,"scroller");if(t.y!==!1&&(f!=null&&f.hasOverflowY||Ho[h.overflowY]&&u.scrollHeight>u.clientHeight)||t.x!==!1&&(f!=null&&f.hasOverflowX||Ho[h.overflowX]&&u.scrollWidth>u.clientWidth)){let g=a;f?g=f:(a.element=u,a.positionDirty=!0);const{xDelta:m,yDelta:v}=g.getDeltaTo(n,t);(m||v)&&(o.push({element:u,x:u.scrollLeft,y:u.scrollTop,xDelta:m,yDelta:v}),n.translate(-m,-v),l+=m,d+=v)}}if(o.length){const u=Math.abs(l),h=Math.abs(d);let f=s&&(typeof s=="number"?s:typeof s.duration=="number"?s.duration:300);if(f&&(u>10||h>10))Math.max(u,h)<50&&(f=Math.min(f,500)),c=a.scrollAnimation=we.animate(f,g=>{const m=g===1;for(const{element:v,x:y,y:b,xDelta:C,yDelta:D}of o)a.element=v,C&&(a.x=Math[r?"min":"max"](y+(m?C:Math.round(C*g)),0)),D&&(a.y=Math.max(b+(m?D:Math.round(D*g)),0))},null,s.easing),c.then(()=>{a.scrollAnimation=null});else if(u>=1||h>=1){for(const{element:g,xDelta:m,yDelta:v}of o)g.scrollTop+=v,g.scrollLeft+=m;c=Lx(o[o.length-1].element)}}return(t.highlight||t.focus)&&(await c,t.highlight&&(isNaN(t.highlight)?a.callback(t.highlight,null,[e]):E.highlight(e,a)),t.focus&&e.focus({preventScroll:!0})),c}scrollBy(e=0,t=0,r=fb){const n=this,s=typeof r=="object"?r.animate:r,a=Math.abs(e),o=Math.abs(t);n.scrollAnimation&&(n.scrollAnimation.cancel(),n.scrollAnimation=null),(e||t)&&(n.silent=r.silent);let l=s&&(typeof s=="number"?s:typeof s.duration=="number"?s.duration:300);if(l&&(a>10||o>10)){const{x:d,y:c}=n;let u=d,h=c;return Math.max(a,o)<50&&(l=Math.min(l,500)),n.scrollAnimation=we.animate(l,f=>{var g,m;const v=f===1;if(e){if(Math.abs(n.x-u)>1&&!r.force)return(g=n.scrollAnimation)==null?void 0:g.cancel();n.x=Math.max(d+(v?e:Math.round(e*f)),0)}if(t){if(Math.abs(n.y-h)>1&&!r.force)return(m=n.scrollAnimation)==null?void 0:m.cancel();n.y=Math.max(c+(v?t:Math.round(t*f)),0)}u=n.x,h=n.y},n,s.easing),n.element.classList.add("b-scrolling"),n.scrollAnimation.then(()=>{n.isDestroyed||(n.element.classList.remove("b-scrolling"),n.scrollAnimation=null)}),n.scrollAnimation}else{if(e||t){const d=n.x,c=n.y;if(Math.round(a)>=1&&(n.x+=e),Math.round(o)>=1&&(n.y+=t),n.x!==d||n.y!==c)return Lx(n.element)}return LL}}async scrollTo(e,t,r){const{x:n,y:s}=this,a=e==null?0:e-n,o=t==null?0:t-s;return this.scrollingToCenter=r==null?void 0:r.scrollingToCenter,this.scrollBy(a,o,r)}doDestroy(){var e,t;const r=this;r._element&&(r._element.removeEventListener("scroll",r.scrollHandler),(e=r.wheelListenerRemover)==null||e.call(r),r._contentElement&&it.removeResizeListener(r.contentElement,r.resizeHandler),it.removeResizeListener(r._element,r.resizeHandler)),(t=r.scrollAnimation)==null||t.cancel(),Object.values(r.partners||{}).forEach(({scroller:n})=>n.removePartner(r)),super.doDestroy()}onElMutation(e){const t=this,[r,n]=E.getTranslateXY(t.element);if(t._x!==-r||t.y!==-n){const s=new CustomEvent("scroll",{bubbles:!0});Object.defineProperty(s,"target",{get:()=>t.element}),t.onScroll(s)}}onElResize(){const e=this,{widget:t}=e;t!=null&&t.isAnimating?t.findListener("animationend","onElResize",e)===-1&&t.ion({animationEnd:"onElResize",thisObj:e,once:!0}):e.syncOverflowState()}onScroll(e){var t;const r=this,{element:n}=r;(t=r.widget)!=null&&t.isDestroyed||(r.positionDirty=!0,n.classList.contains("b-scrolling")||n.classList.add("b-scrolling"),e.widget=r.widget,e.scrollingToCenter=r.scrollingToCenter,r.silent||r.trigger("scroll",e),r.syncPartners(),r.controllingPartner=null,r.onScrollEnd(e))}syncPartners(e,t=this.propagateSync){const r=this;r.partners&&Object.values(r.partners).forEach(({axes:n,scroller:s})=>{(s!==r.controllingPartner||e)&&s.sync(r,n)&&t&&s.syncPartners(e,t)})}onScrollEnd(e){const t=this;t.silent&&(t.silent=!1),t.trigger("scrollEnd",e),t.scrollingToCenter=!1,t.controllingPartner=null,t.element.classList.remove("b-scrolling")}getDeltaTo(e,t){const r=this,{x:n,y:s}=r,{precise:a}=t,o=t.viewport||r.viewport;if(!o)return{xDelta:0,yDelta:0};const l=HL(t.edgeOffset),d=e instanceof $?e:$.from(e);let c=t.x===!1?0:r.getDelta({viewport:o,targetRect:d,edgeOffset:l.inline,flow:"inline",targetEdge:t.inline||t.block||"nearest",maxSize:t.maxWidth,precise:a})*(r.isRTL?-1:1),u=t.y===!1?0:r.getDelta({viewport:o,targetRect:d,edgeOffset:l.block,flow:"block",targetEdge:t.block||"nearest",maxSize:t.maxHeight,precise:a});return t.constrainToScrollable!==!1&&(c=Math.max(Math.min(c,Math.max(r.maxX-n,0)),-n),u=Math.max(Math.min(u,Math.max(r.maxY-s,0)),-s)),{xDelta:c,yDelta:u}}getDelta({viewport:e,targetRect:t,edgeOffset:r={start:0,end:0},flow:n,targetEdge:s="nearest",maxSize:a,precise:o}){const l=n==="block",d=!l&&this.isRTL,c=l?"y":"x",u=l?"bottom":"right",h=l?"y":d?"right":"x",f=l?"bottom":d?"x":"right",g=l?"height":"width";let m=0;if(s==="center")m=t.center[c]-e.center[c];else if(s==="start"||s==="end"){const v=s==="start",y=v?h:f,b=r[s],C=e[g]>b?(v?-1:1)*(l||!d?1:-1):0;m=t[y]+b*C-e[y]}else{const v=Math.max(t[c],e[c]),y=Math.min(t[u],e[u]),b=y>v?y-v:0,C=t[g];b<=Math.min(a||Number.MAX_SAFE_INTEGER,C)&&C>b&&(t=t.clone(),t[g]>a&&(t[c]<e[c]?t[c]=Math.max(t[c],t[u]-a):t[g]=Math.min(C,a),r=void 0),Math.min(t[g],a||Number.MAX_SAFE_INTEGER)>e[g]?s="start":s=Math.abs(t[h]-e[h])<Math.abs(t[f]-e[f])?"start":"end",m=this.getDelta({viewport:e,targetRect:t,edgeOffset:r,flow:n,targetEdge:s,maxSize:a,precise:o}))}return o?m:Math.round(m)}get viewport(){const e=this.stickies?L.asArray(this.stickies).flatMap(r=>typeof r=="string"?Array.from(this.element.querySelectorAll(r)):r):null,t=$.client(this.element);return e?t.exclude(e.map(r=>$.from(r))):t}updateWidget(e){this.rtlSource=this.owner=e}updateElement(e,t){var r;const n=this;if(n===Rg._globalScroller){n._element=e,n.positionDirty=!0;return}const s=n.scrollHandler||(n.scrollHandler=n.onScroll.bind(n)),a=n.resizeHandler||(n.resizeHandler=n.onElResize.bind(n));if(t&&(Ge.remove(t,"scroller"),n.translate?(r=n.mutationObserver)==null||r.disconnect():(t.removeEventListener("scroll",s),t.classList.remove(kx),t.style.overflowX=t.style.overflowY=""),it.removeResizeListener(t,a)),e){if(Ge.set(e,"scroller",n),n.translate){if(n.mutationObserver||(n.mutationObserver=new MutationObserver(n.mutationHandler||(n.mutationHandler=n.onElMutation.bind(n)))),n._x=n._y=0,document.contains(e)){const[o,l]=E.getTranslateXY(e);n._x=-o,n._y=-l}n.mutationObserver.observe(e,{attributes:!0})}else e.addEventListener("scroll",s),e.classList.add(kx);it.addResizeListener(e,a),n.widget||(n.rtlSource={get rtl(){return E.getStyleValue(e,"direction")==="rtl"}}),n.isRTL&&e.classList.add("b-rtl"),n.positionDirty&&(n.updateOverflowX(n.overflowX),n.updateOverflowY(n.overflowY)),n.syncOverflowState(),n.isConfiguring&&(n._x&&n.updateX(n._x),n._y&&n.updateY(n._y))}n.positionDirty=!0}get unsynced(){const e=this,[t,r]=e.xy;return e._x!==t||e._y!==r}get xy(){const{element:e}=this;let t,r;return e&&(this.translate?([t,r]=E.getTranslateXY(e),t=-t,r=-r):(t=Math.abs(e.scrollLeft),r=e.scrollTop)),[t,r]}refreshPosition(){const e=this,[t,r]=e.xy;e._x=t,e._y=r,e.positionDirty=!1}fixPositionSync(){const e=this,{element:t,xy:r,_x:n,_y:s}=e;!e.positionDirty&&!(n===r[0]&&s===r[1])&&(e.translate?(E.setTranslateX(t,-n),E.setTranslateY(t,-s)):t.scrollTo({behavior:"instant",left:e.isRTL?-n:n,top:s}))}get x(){return this.positionDirty&&this.refreshPosition(),this._x}get scrollLeft(){return this.x*(this.isRTL?-1:1)}changeX(e){if(e=Math.max(e,0),!this.isConfiguring||e)return e;this._x=e}updateContentElement(e){e&&(e=typeof e=="string"?this.element.querySelector(e):e,it.addResizeListener(e,this.resizeHandler))}updateX(e){var t;const r=this,{behavior:n,element:s}=r;s&&!((t=r.widget)!=null&&t.isConfiguring)&&(e=Math.round(e),r.trigger("scrollStart",{x:e}),r.translate?E.setTranslateX(s,-e):n?s.scrollTo({behavior:n,left:r.isRTL?-e:e}):s.scrollLeft=r.isRTL?-e:e),r.positionDirty=!0}sync(e,t){const r=this,{x:n,y:s}=t;let a=!1;return n&&r.x!==e.x&&(r.controllingPartner=e,r.x=e.x,a=!0),s&&r.y!==e.y&&(r.controllingPartner=e,r.y=e.y,a=!0),a}get y(){return this.positionDirty&&this.refreshPosition(),this._y}changeY(e){if(!this.isConfiguring||e)return e;this._y=e}updateY(e){const t=this,{behavior:r,element:n,widget:s}=t;n&&!(s!=null&&s.isConfiguring)&&(t.trigger("scrollStart",{y:e}),t.translate?E.setTranslateY(n,-e):r?n.scrollTo({behavior:r,top:e}):n.scrollTop=e),t.positionDirty=!0}get maxX(){return this.scrollWidth-this.clientWidth}get maxY(){return this.scrollHeight-this.clientHeight}get lastScrollLeft(){return(this.scrollWidth-this.clientWidth)*(this.isRTL?-1:1)}updateOverflowX(e,t){const r=this,{element:n,translate:s}=r,{style:a,classList:o}=n;t==="hidden-scroll"&&o.remove("b-hide-scroll"),e==="hidden-scroll"&&!s&&(Ho[r.overflowY]?(e="hidden",r.enableWheel()):o.add("b-hide-scroll")),s||(a.overflowX=Px[e]||e),r.isConfiguring||(r.positionDirty=!0,r.syncOverflowState())}updateOverflowY(e,t){const r=this,{element:n,translate:s}=r,{style:a,classList:o}=n;t==="hidden-scroll"&&o.remove("b-hide-scroll"),e==="hidden-scroll"&&!s&&(Ho[r.overflowX]?(e="hidden",r.enableWheel()):o.add("b-hide-scroll")),s||(a.overflowY=Px[e]||e),r.isConfiguring||(r.positionDirty=!0,r.syncOverflowState())}enableWheel(){this.wheelListenerRemover||(this.wheelListenerRemover=j.on({element:this.element,wheel:"onWheel",thisObj:this}))}onWheel(e){const t=this,{overflowX:r,overflowY:n}=t,s=e.deltaX,a=e.deltaY,o=Math.abs(s)-Math.abs(a);r==="hidden-scroll"&&Ho[n]&&o>0?t.x+=s:n==="hidden-scroll"&&Ho[r]&&o<0&&(t.y+=a)}get scrollWidth(){var e,t;return(t=(e=this.element)==null?void 0:e.scrollWidth)!=null?t:0}set scrollWidth(e){const t=this,{element:r,isRTL:n}=t;let s=t.widthStretcher;s&&e==null?(s.remove(),t.widthStretcher=null):e&&(e=Math.abs(e),s||(s=t.widthStretcher=E.createElement({className:"b-scroller-stretcher b-horizontal-stretcher",role:null,retainElement:!0})),s.style.transform=`translateX(${(e-1)*(n?-1:1)}px)`,r&&!r.contains(s)&&r.insertBefore(s,r.firstElementChild)),r.style.setProperty("--scroll-width",E.setLength(e)),t.propagate!==!1&&t.eachPartner(({scroller:a})=>{a.propagate=!1,a.scrollWidth=e,delete a.propagate}),t.positionDirty=!0,t.syncOverflowState()}get scrollHeight(){var e,t;return(t=(e=this.element)==null?void 0:e.scrollHeight)!=null?t:0}set scrollHeight(e){const t=this,r=t.stretcher||(t.stretcher=E.createElement({className:"b-scroller-stretcher",role:null}));r.style.transform=`translateY(${e-1}px)`,t.element&&t.element.lastChild!==r&&t.element.appendChild(r),t.positionDirty=!0,t.syncOverflowState()}get clientWidth(){var e;return((e=this.element)==null?void 0:e.clientWidth)||0}get clientHeight(){var e;return((e=this.element)==null?void 0:e.clientHeight)||0}get id(){return this._id||(this._id=$i.generateId(this.widget?`${this.widget.id}-`:"scroller-")),this._id}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(),delete e.widget,delete e.element}};Xs._$name="Scroller";var VL=/\/[^/]+\//,Ox={},$x=i=>{var e;return e=class extends(i||O){get widgetClass(){}get keyMapElement(){return this.element}get keyMapSubComponents(){return this.features}addKeyBinding(t,r){const n=this.keyMap,s=this.mergeKeyMaps({[t]:n==null?void 0:n[t]},{[t]:r})[t];n?n[t]=s:this.keyMap={[t]:s}}removeKeyBinding(t,r){var n;const s=(n=this.keyMap)==null?void 0:n[t];if(s){let a=0;Array.isArray(s)?(a=s.findIndex(o=>o===r||o.handler===r),a>-1&&s.splice(a,1)):(s===r||s.handler===r)&&delete this.keyMap[t]}}matchKeyMapEntry(t,r=this.keyMap){const{input:n}=this,{altKey:s,ctrlKey:a,metaKey:o,shiftKey:l,target:d}=t;if(t.key.length===1&&!(s||a||o||l)&&!(n&&t.composedPath().includes(n))&&E.isEditable(d,!0))return!0;if(r&&!t.handled&&t.key!==void 0)return T.keys(r).find(c=>{const u=c==="+"?[]:c.toLowerCase().split("+"),h=c.endsWith("+")?"+":u.pop(),f=h==="space"?" ":h,g=u.includes("alt"),m=u.includes("ctrl"),v=u.includes("meta"),y=u.includes("shift"),b=VL.test(f)&&(Ox[f]||(Ox[f]=new RegExp(f.substring(1,f.length-1))));return(b?b.test(t.key.toLowerCase()):f===t.key.toLowerCase())&&(g?s:!s)&&(m?a:!a)&&(v?o:!o)&&(y?l:!l)})}async performKeyMapAction(t){var r,n,s;const a=this,{keyMap:o}=a;let l=!1,d,c,u,h;if(o&&!t.handled&&t.key!==void 0){const f=a.matchKeyMapEntry(t);if(o[f]){const g=L.asArray(o[f]);t.fromKeyMap=!0,t.widget=this;for(d of g){if(h=!0,T.isObject(d)){if(!d.handler)continue;d.preventDefault===!1&&(h=!1),d=d.handler}if(typeof d=="string"){const{thisObj:m,handler:v}=a.resolveKeyMapAction(d);if(((r=m.isActionAvailable)==null?void 0:r.call(m,{key:f,action:d,event:t,actionName:d.split(".").pop()}))!==!1){let y=v.call(m,t);if(T.isPromise(y)&&(y=await y),y!==!1){l=!0;break}}}else if(d.call(a,t)!==!1){l=!0;break}}l&&(h&&t.preventDefault(),t.handled=!0)}if(!l){if(u=T.getTruthyKeys(o.delegate)){for(c of u)if(c=T.getPath(a,c),l=(n=c==null?void 0:c.performKeyMapAction)==null?void 0:n.call(c,t),T.isPromise(l)&&(l=await l),l)break}l||(s=a.defaultKeyHandler)==null||s.call(a,t)}}return l}resolveKeyMapAction(t){const r=this,{keyMapSubComponents:n}=r;if(t.startsWith("up.")||t.startsWith("this."))return r.resolveCallback(t);if(n&&t.includes(".")){const[s,a]=t.split(".");if(s&&a)return{thisObj:n[s],handler:n[s][a]}}return{thisObj:r,handler:r[t]}}updateKeyMap(t){var r;const n=this,s=T.keys(t);(r=n.keyMapDetacher)==null||r.call(n),n.keyMapDetacher=(s.length||null)&&j.on({element:n.keyMapElement,keydown:"keyMapOnKeyDown",thisObj:n})}keyMapOnKeyDown(t){this.performKeyMapAction(t)}mergeKeyMaps(t,r,n=null){const s={};t&&T.assign(s,t);for(const a in r){if(!r[a])continue;const o=L.asArray(t==null?void 0:t[a]),l=[];if(o!=null&&o.length&&l.push(...o),!(o!=null&&o.some(d=>{const c=d.handler?d.handler:d;return typeof c=="string"&&c.startsWith(n+".")}))){for(const d of L.asArray(r[a]))T.isObject(d)&&d.handler?l.push(T.assignIf({handler:(n?n+".":"")+d.handler},d)):typeof d=="function"?l.push(d):l.push((n?n+".":"")+d);l.sort((d,c)=>{const u=(d.weight||0)-(c.weight||0);return u===0&&(o!=null&&o.length)?o.indexOf(d)-o.indexOf(c):u})}s[a]=l}return s}},p(e,"$name","KeyMap"),p(e,"configurable",{keyMap:{value:null,$config:{merge:"objects",nullify:!0}}}),e},Bx=i=>{var e;return e=class extends(i||O){get widgetClass(){}get isRTL(){return this.rtl}updateRtl(t){const{element:r}=this;r&&(r.classList.toggle("b-rtl",t===!0),r.classList.toggle("b-ltr",t===!1))}startConfigure(t){var r,n;if((r=super.startConfigure)==null||r.call(this,arguments),!t.floating&&t.rtl==null){const s=this,a=t.rootElement||t.forElement||((n=s.parent)==null?void 0:n.contentElement)||(s.floating?s.floatRoot:s.changeElementRef(s.getRenderContext(t)[0]||t.adopt));if(a)t.rtl=a.nodeType===1&&getComputedStyle(a).getPropertyValue("direction")==="rtl";else{const o=t.owner||t.parent;o?t.rtl=o[o.isConfiguring?"peekConfig":"getConfig"]("rtl"):t.rtl=getComputedStyle(document.body).getPropertyValue("direction")==="rtl"}t.rtl&&(s.configDone.rtl=!1)}}render(...t){var r,n,s;(r=super.render)==null||r.call(this,...t),(Y.isChrome&&Y.chromeVersion<87||Y.isFirefox&&Y.firefoxVersion<66||Y.isSafari&&Y.safariVersion<14.1)&&this.element.classList.add("b-legacy-inset"),(getComputedStyle(this.element).direction==="rtl"||(n=this.owner)!=null&&n.rtl)&&(this.rtl=!0,(s=this.childItems)==null||s.forEach(a=>a.rtl=!0))}},p(e,"$name","RTL"),p(e,"configurable",{rtl:null}),e},Hx=Object.freeze({highlight:!1,onlyName:!1}),Vx=Object.freeze([]),jL=Object.freeze({sync:!1}),nm=[],zL=["clip","display","opacity"],gb="highlightExternalChange",mb=/transparent|rgba\(0,\s*0,\s*0,\s*0\)/,sm=Symbol("renderConfigObserver"),NL=/<div|<button|<input|<p|<br|<li/,jx=(i,e,t,r)=>{let n=(t==null?void 0:t.listeners)||(t==null?void 0:t.internalListeners);if(n=(n==null?void 0:n.on)||n,n){const s=j.on(T.assign({element:e,thisObj:i},n));r?(i._refListeners||(i._refListeners=Object.create(null)))[r]=s:t.listeners={on:n,un:s}}},zx=(i,e)=>i&&e&&e[T.keys(i)[0]]?$e.merge(i,e):i,WL=i=>{i.isVisible&&i.triggerPaint()},UL=/^:not\((.+)\)$/,GL=/absolute|fixed/i,qL=i=>i.scale!=null,{hasOwn:Zs}=T,{defineProperty:Nx}=Reflect,Wx=i=>parseFloat(i)*(i.endsWith("ms")?1:1e3),Ux=["b-aligned-above","b-aligned-right","b-aligned-below","b-aligned-left"],YL={configurable:!0,value:!1},KL=/(?:L\{([ \w.]+?)\})/,Gx=/^([trblc])(\d*)-([trblc])(\d*)$/i,XL=(i,e)=>(Gx.test(i)&&(i={align:i}),Gx.test(e)&&(e={align:e}),$e.merge(i,e)),ZL=/^[\w.]+$/,qx={1:"maxHeight",2:"height",4:"maxWidth",8:"width"},QL=i=>!i.isRipple&&!i.closest(e=>e.isMessageDialog||e.isSharedTooltip),pb=i=>E.getStyleValue(i,"display")==="contents"?pb(i.parentNode):i,JL=i=>{if(i!=null&&i.target){const{ownerSVGElement:e}=i.target,t=e==null?void 0:e.getBoundingClientRect(),r=pb(i.target),n=E.getStyleValue(i.target,"display");if(e)return{target:i.target.ownerSVGElement,offsetX:i.clientX-t.x,offsetY:i.clientY-t.y};let{offsetX:s,offsetY:a}=i;if(n==="inline"){const o=r.getBoundingClientRect();s=i.clientX-o.left,a=i.clientY-o.top}else if(n==="contents"){const o=r.getBoundingClientRect(r);s-=o.x,a-=o.y}return{target:pb(i.target),offsetX:s,offsetY:a}}},eO=(i,e)=>(i.push((e.text||e.html||"").trim()),i),am=class ve extends O.mixin(je,Ie,be,bn,En,$x,Bx){static mergeCls(e,t){return t&&e?e=new le(t).assign(typeof e=="string"?new le(e):e):e&&!e.isDomClassList&&(e=new le(e)),e}static get configurable(){return{element:!0,callOnFunctions:!0,hideMode:{$config:null,default:"display"},id:null,html:{$config:"lazy",value:null},content:{$config:"lazy",value:null},cls:{$config:{merge:"classList"},value:null},ui:{$config:{merge:"classList"},value:null},collapsify:null,contentElementCls:{$config:{merge:"classList"},value:null},defaultCls:{$config:{merge:"classList"},value:null},dock:null,parent:null,tab:null,elementAttributes:null,htmlCls:{$config:{merge:"classList"},value:{"b-html":1}},style:null,disabled:null,readOnly:{value:null,default:!1,$config:null},ignoreParentReadOnly:null,adopt:null,appendTo:null,insertBefore:null,insertFirst:null,dataset:null,tooltip:{$config:["lazy","nullify"],value:null},showTooltipWhenDisabled:!0,preventTooltipOnTouch:null,monitorResize:{$config:["lazy","nullify"],value:null},masked:{$config:"nullify",value:null},maskDefaults:{target:"element"},floating:null,positionable:null,positioned:null,draggable:{$config:["lazy","nullify"],value:null},align:{$config:{merge:XL},value:"t-b"},centered:null,constrainTo:void 0,anchor:null,owner:{$config:["lazy","nullify"],value:null},scrollAction:null,hideAnimation:{$config:{merge:zx},value:null},showAnimation:{$config:{merge:zx},value:null},top:null,right:null,bottom:null,left:null,x:null,y:null,scrollable:{$config:["lazy","nullify"],value:null},scrollerClass:Xs,defaultBindProperty:"html",defaultAction:null,overflowable:{value:null,default:!0,$config:null},width:null,height:null,maxHeight:null,maxWidth:null,minWidth:null,minHeight:null,scaleToFitWidth:null,allowGrowWidth:!0,margin:null,flex:null,weight:null,alignSelf:null,ripple:null,title:null,localizableProperties:["title","ariaLabel","ariaDescription","dataset.text"],requireSize:!1,ref:null,hidden:null,textAlign:null,ignoreScrollDuration:500,tag:"div",recomposeAsync:null,rootElement:null,htmlMutationObserver:{$config:["lazy","nullify"],value:{childList:!0,subtree:!0}},role:{$config:{lazy:!0,default:null},value:"presentation"},ariaLabel:{$config:"lazy",value:null},ariaDescription:{$config:"lazy",value:null},ariaLive:{$config:"lazy",value:null},ariaElement:"element",ariaHasPopup:null,realignTimeout:300,testConfig:{ignoreScrollDuration:100,realignTimeout:50},maximizeOnMobile:null,twinForwardEvents:{$config:{merge:"classList"},value:null},twinSyncConfigs:{$config:{merge:"classList"},value:["disabled"]}}}static get prototypeProperties(){return{hasGeneratedId:!1,hasPainted:!1,innerItem:!0}}static get declarable(){return["renderConfigs"]}static get delayable(){return{recompose:"raf",doHideOrRealign:"raf",onAlignConstraintChange:"raf"}}static get factoryable(){return{defaultType:"widget"}}static get identifiable(){return{}}static get all(){return super.all}static get recomposeAsync(){return ve._recomposeAsync}static set recomposeAsync(e){if(ve._recomposeAsync=e,e!=null){const{all:t}=ve;for(let r=0;r<t.length;++r)t[r].isComposable&&(t[r].recomposeAsync=e)}}updateWeight(){var e,t;this.isPainted&&((t=(e=this.parent)==null?void 0:e.onChildWeightChange)==null||t.call(e,this))}isA(e){return this.isType(e,!0)}isType(e,t){return ve.isType(this,e,t)}static setupRenderConfigs(e,t){const r=t.getInherited("renderConfigs"),{renderConfigs:n}=e;if(n){if(Array.isArray(n))for(const s of n)r[s]=!0;else T.assign(r,n);r[sm]=null}}static weightSortFn({weight:e},{weight:t}){return typeof e=="string"||typeof t=="string"?String(e).localeCompare(String(t)):(e!=null?e:Number.MAX_SAFE_INTEGER)-(t!=null?t:Number.MAX_SAFE_INTEGER)}construct(e={},...t){const r=this,{domSyncCallback:n}=r,{recomposeAsync:s}=ve;if(s!=null&&r.recomposeAsync==null&&(r.recomposeAsync=s),!globalThis.bryntum.cssVersion){const a=globalThis.bryntum.cssVersion=Ys.getCSSVersion(),o=te.getVersion("core");a&&a!==o&&console.warn(`CSS version ${a} doesn't match bundle version ${o}!
Make sure you have imported css from the appropriate product version.`)}r.configureAriaDescription=e.ariaDescription,r._isAnimatingCounter=0,r.alignmentChanges=0,r.byRef=Object.create(null),r.onTargetResize=r.onTargetResize.bind(r),r.onFullscreenChange=r.onFullscreenChange.bind(r),r.domSyncCallback=n.$nullFn?null:n.bind(r),r._isUserAction=!1,super.construct(e,...t),r.finalizeInit()}startConfigure(e){super.startConfigure(e),this.getConfig("element")}finalizeInit(){var e;const t=this,{adopt:r}=t,n=t.insertBefore||t.appendTo||t.insertFirst||r,{classList:s}=t.element;t.getConfig("html","content"),n&&(r&&(s.remove("b-hidden"),t._hidden=!1),t.owner||(e=n.nodeType?n:document.getElementById(n))!=null&&e.isConnected?t.render():(t.onFirstResizeAfterConnect=t.onFirstResizeAfterConnect.bind(t),it.addResizeListener(n,t.onFirstResizeAfterConnect))),s.remove("b-initializing")}onFirstResizeAfterConnect(e){it.removeResizeListener(e,this.onFirstResizeAfterConnect),!this.isDestroyed&&!this.rendered&&this.render()}doDestroy(){var e,t,r;const n=this,{preExistingElements:s,element:a,adopt:o,_refListeners:l,_rootElement:d,eventRoot:c,ownedWidgets:u,parent:h}=n;if(n.updateOwner(null,n.owner),qt.element===a&&qt.exit(),l&&(Object.values(l,f=>f()),n._refListeners=null),a){const f=!n._tooltip&&d&&((e=ve.Tooltip)==null?void 0:e.getSharedTooltip(d,c,!0));if((f==null?void 0:f.owner)===n&&(f.owner=null,f.hide()),n.onExitFullscreen(),n.clearTimeout("scrollListenerTimeout"),n.clearTimeout("resizeListenerTimeout"),n.removeTransientListeners(),n.floating||n.positioned||n.positionable?n.isPainted&&n.hide(!1):n.revertFocus(),it.removeResizeListener(a.parentElement,n.onParentElementResize),it.removeResizeListener(a,n.onElementResize),o){for(let g=Array.from(a.childNodes),m=0,{length:v}=g;m<v;m++){const y=g[m];!s.includes(y)&&y!==n.floatRoot&&y.remove()}a.className=n.adoptedElementClassName,a.style.cssText=n.adoptedElementCssText}}(t=n.connectedObserver)==null||t.disconnect(),h!=null&&h.isContainer&&!h.isDestroying&&((r=h._items)!=null&&r.includes(n))&&h.remove(n),super.doDestroy(),u&&Object.values(u).forEach(f=>{var g;return(g=f.destroy)==null?void 0:g.call(f)}),c&&Promise.resolve().then(()=>{var f,g;Object.values(ve.identifiable.idMap).some(QL)||((g=(f=ve.Ripple)==null?void 0:f.cleanUpRippleListeners)==null||g.call(f),ce.detachFocusListeners(c))}),o||a.remove()}get assignValueDefaults(){return Hx}get valueName(){return this.name||this.ref||this.id}getValueName(e){return e=e&&typeof e=="object"?e.onlyName:e,e?this.name:this.valueName}assignFieldValue(e,t,r){const n=this,s=n.defaultBindProperty;s in n&&(n[s]=r)}assignValue(e,t=Hx){const r=this,n=r[gb],s=r.getValueName(t);s&&(!e||s in e)&&(t.highlight===!1&&(r[gb]=!1),r.assignFieldValue(e,s,e?e[s]:null),r[gb]=n)}gatherValue(e){const t=this,r=t.defaultBindProperty;t.constructor!==ve&&r in t&&(e[t.name||t.ref||t.id]=t[r])}gatherValues(e){this.eachWidget(t=>t.gatherValue(e),!1)}addToOverflowMenu(e,t,r){const n=this.ensureOverflowTwin(t,r);return e.items.push(n),n}get twinForwardEventPairs(){const e=this._twinForwardEvents;return e?T.entries(e):Vx}configureOverflowTwin(e){const t=this,{twinSyncConfigs:r}=t;let n=T.clone(t.initialConfig),s,a;if(delete n.id,delete n.listeners,delete n.internalListeners,delete n.parent,n.hidden=!1,n.type=t.type,n._overflowTwinOrigin=t,n.owner=t.owner,t.twinForwardEventPairs.forEach(([o])=>{delete n[`on${k.capitalize(o)}`]}),r)for(s in r)a=r[s],a&&(delete n[s],n[typeof a=="string"?a:s]=t[s]);return e&&(n=typeof e=="function"?e(n)||n:T.assign(n,e)),n}createOverflowTwin(e){const t=this,r=t.configureOverflowTwin(e),n=ve.create(r),{twinSyncConfigs:s}=t;return s&&t.bindConfigs(n,s,jL),t.twinForwardEventPairs.forEach(([a,o])=>{n.ion({[a]:l=>{t.overflowTwin===l.source&&(l=T.assign({},l),delete l.source,t.trigger(typeof o=="string"?o:l.eventName,l))}})}),n}ensureOverflowTwin(e,t){let{overflowTwin:r}=this;return r||(this.overflowTwin=r=this.createOverflowTwin(e),t==null||t(r)),r}get isComposable(){return!this.compose.$nullFn}adoptElement(e){const t=this,r=typeof e=="string"?document.getElementById(e):e,n=ve.fromElement(r);return n&&n.adopt&&n!==t&&(typeof n.adopt=="string"?document.getElementById(n.adopt):n.adopt)===r&&n.destroy(),t.preExistingElements=Array.from(r.childNodes),t.adoptedElementClassName=r.className,t.adoptedElementCssText=r.style.cssText,r.lastDomConfig=null,r.$refOwnerId=t.id,r.className=r.style.cssText="",r}addRefAccessor(e,t){const{prototype:r}=this.constructor;Nx(r,t,{writable:!0,value:null}),Nx(r,e,{get(){return this.recompose.flush(),this[t]},set(n){this[t]=n}})}attachRef(e,t,r){const n=this,s="_"+e;t.dataset&&(t.dataset.ownerCmp=n.id),n.isComposable&&(s in n||n.addRefAccessor(e,s),jx(n,t,r,e)),n.byRef[e]=t,n[e]=t}detachRef(e,t,r){const n=this,s=n._refListeners;s!=null&&s[e]&&(s[e](),delete s[e]),n[e]=null,delete n.byRef[e]}afterRecompose(){}compose(){const{widgetClassList:e}=this;return{class:{...le.normalize(e,"object")}}}doCompose(){const e=this,{$meta:t}=e,r=t.hierarchy,n=t.renderConfigs||t.getInherited("renderConfigs");let{composers:s}=t,a=null,o,l,d,c;if(e.recompose.suspend(),!s){for(t.composers=s=[],d=r.indexOf(ve);d<r.length;++d)c=r[d].prototype,Zs(c,"compose")&&s.push(c);Zs(n,sm)||(n[sm]={get(u){u!=="element"&&(n[u]=!0)}})}for(e.configObserver=n[sm],d=0;d<s.length;++d)o=s[d].compose.call(e,a),a=a?E.merge(a,o):o;return Zs(e,"compose")&&E.merge(a,e.compose(a)),e.configObserver=null,E.normalizeChildren(a,(u,h)=>{h&&(l="_"+u,l in e||e.addRefAccessor(u,l))})}get element(){return this.isComposable&&!this.isDestroying&&this.recompose.flush(),this._element}domSyncCallback(e){}changeElement(e){const t=this,r=t.isComposable,{adopt:n}=t;return t.id=t.id||(n==null?void 0:n.id)||null,n?e=t.adoptElement(n):r&&(e=t.doCompose()),typeof e=="string"?e=E.createElementFromTemplate(e):T.isObject(e)?(e=E.createElement(e,{refOwner:t,callback:t.domSyncCallback}),t.recompose.resume()):E.isReactElement(t.peekConfig("html"))||E.isVueConfig(t.peekConfig("html"))?e=document.createElement("div"):e.nodeType!==1&&(e=E.createElementFromTemplate(t.template(t))),!e.id&&(e.id=t.id),t.elementAttributes&&E.setAttributes(e,t.elementAttributes),e}updateElement(e){const t=this,r=t.isComposable;t.adopt&&(t._hidden=!0,r&&t.recomposeNow()),r&&jx(t,e,e.lastDomConfig);const{className:n}=e,{contentElement:s,contentElementCls:a,isComposable:o}=t,l=s!==e,d=!o&&e.querySelectorAll("[data-reference]"),c=o?[]:t.widgetClassList;let u=(l||!o)&&t.uiClasses;if(n&&c.unshift(n),t._hidden&&c.push("b-hidden",`b-hide-mode-${t.hideMode}`),t._readOnly&&c.push("b-readonly"),c.push("b-initializing"),we.noThrow(e,"remove"),u?(a!=null&&a.value&&(u=u.slice(),u.push(a.value)),u=u.join(" ")):u=a==null?void 0:a.value,u&&(l?s.className+=" "+u:c.push(u)),!t.parent){const{defaultCls:h}=t,{outerCls:f}=ve;c.push(...h?f.filter(g=>!(g in h)||h[g]):f)}if(e.className=c.join(" "),d)for(let h,f=0;f<d.length;++f)h=d[f],t.attachRef(h.getAttribute("data-reference"),h),h.removeAttribute("data-reference");t.scaleToFitWidth||t.getConfig("monitorResize"),t.getConfig("role","ariaLabel","ariaDescription"),t._html&&t.getConfig("htmlMutationObserver"),t.owner&&!t._owner&&t.updateOwner(t.owner),E.isVueConfig(t._html)&&E.handleVueContent(t,t.html),t.trigger("elementCreated",{element:e})}localizeText(e){return e.match(KL)?this.L(e,this):e}updateAriaDescription(e){const t=this,{ariaElement:r}=t,n=`${t.id}-aria-desc-el`;if(e){const s=t._ariaDescEl||(t._ariaDescEl=E.createElement({className:"b-aria-desc-element",id:n,parent:r}));s.innerText=t.localizeText(e),E.addAttributeValue(r,"aria-describedBy",n)}else E.removeAttributeValue(r,"aria-describedBy",n)}updateAriaLabel(e=""){const t=this.labelledElement||this.ariaElement;t&&E.setAttributes(t,{"aria-label":e?this.localizeText(e):null})}updateAriaHasPopup(e){var t,r;e?(t=this.ariaElement)==null||t.setAttribute("aria-haspopup",e):(r=this.ariaElement)==null||r.removeAttribute("aria-haspopup")}updateAriaLive(e){E.setAttributes(this.ariaElement,{"aria-live":e})}updateRole(e){var t,r;e?(t=this.ariaElement)==null||t.setAttribute("role",e):(r=this.ariaElement)==null||r.removeAttribute("role")}get ownersRole(){var e;let{role:t}=this;return t==="presentation"&&(t=(e=this.query(r=>r.role!=="presentation"))==null?void 0:e.role),t}get ariaElement(){this.getConfig("element");const{_ariaElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:T.getPath(this,e)}isCollapsified({collapsed:e,alt:t}){const{collapsify:r}=this,n=r==="hide",s=r===!1,a=r==null;return t?r==="overlay"||a&&e:s||n||a&&!e}async recompose(){return this.recomposeInternal()}async recomposeInternal(){const e=this,t={targetElement:e.element,domConfig:e.doCompose(),refOwner:e,callback:e.domSyncCallback,strict:!0};if(e.transitionRecompose){if(e.isTransitioningDom=!0,await E.transition(T.assign({element:e.element,action(){he.sync(t)}},e.transitionRecompose)),e.isDestroyed)return;e.isTransitioningDom=!1,e.trigger("transitionedRecompose")}else he.sync(t);t.changed&&(e.afterRecompose(),e.trigger("recompose")),e.resumeRecompose()}resumeRecompose(){this.recompose.resume()}changeElementRef(e){if(typeof e=="string"){const t=e;if(!(e=document.getElementById(t)))throw new Error(`No element found with id '${t}'`)}return e}changeAppendTo(e){return this.changeElementRef(e)}updateAppendTo(e){!this.isConfiguring&&e&&this.render()}changeInsertBefore(e){return this.changeElementRef(e)}updateInsertBefore(e){!this.isConfiguring&&e&&this.render()}changeInsertFirst(e){return this.changeElementRef(e)}updateInsertFirst(e){!this.isConfiguring&&e&&this.render()}getRenderContext(e=this,t){let r=t||e.appendTo,{insertFirst:n,insertBefore:s}=e;return n&&(r=n,s=r.firstChild),s&&(r=s.parentElement),[r,s||void 0]}render(e,t=!0){var r;const n=this,{element:s}=n,[a,o]=n.getRenderContext(n,e);n.emptyCache(),n.syncElement&&n.currentElement?E.sync(s,n.currentElement):(a==null||a.insertBefore(s,o),n.currentElement=s),(r=s.parentElement)!=null&&r.closest(".b-widget")&&s.classList.remove(...ve.outerCls),super.render(a,t),n.rendered=!0,n.getConfig("role"),t&&(n.getConfig("contentRange"),n.triggerPaint()),n.setupFocusListeners()}template({tag:e,html:t,htmlCls:r,name:n}){const s=this;typeof t=="string"&&ZL.test(t)&&s.resolveCallback(t,s,!1)&&(t=s.callback(t,s,[s]));const a=t!=null&&t.call?t.call(s,s):t;return`<${e} class="${a?r:""}" ${n?`data-name="${n}"`:""}>${a||""}</${e}>`}updateRecomposeAsync(e){this.recompose.immediate=!e}onConfigChange({name:e}){var t;this._element&&!this.isDestroying&&((t=this.$meta.renderConfigs)!=null&&t[e])&&this.recompose()}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.parent}getConfigValue(e,t){return e==="style"?this._style:super.getConfigValue(e,t)}getCurrentConfig(e){const t=super.getCurrentConfig(e);return(e==null?void 0:e.depth)>0&&(t.type=this.type),t}get dataset(){var e;return((e=this.element)==null?void 0:e.dataset)||Vx}changeDataset(e){T.assign(this.dataset,e)}updateParent(e){const{_element:t}=this;t&&t.classList[e?"remove":"add"](...ve.outerCls)}get constrainTo(){let e=this._constrainTo;if(e=e===void 0?globalThis:(e==null?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE?e.host||e.ownerDocument:e,this.positioned){const{offsetParent:t}=this.element;if(t&&E.getStyleValue(t,"overflow")==="hidden")e=$.from(t).moveTo(0,0);else if(e&&!e.isRectangle){const r=e===document||e===globalThis;e=$.from(e,t),r&&e.translate(globalThis.pageXOffset,globalThis.pageYOffset)}}return e}updateCentered(e){const t=this,{element:r,_anchorElement:n}=t;if(e&&!t.floating&&!t.positioned)throw new Error("`centered` is only relevant when a Widget is `floating` or `positioned`");e?(r.classList.add("b-centered"),r.style.transform=r.style.left=r.style.insetInlineStart=r.style.right=r.style.top="",n==null||n.classList.add("b-hide-display"),r.classList.remove("b-anchored")):r.classList.remove("b-centered")}get contentElement(){return this.element}get contentRange(){const e=this,t=e._contentRange||(e._contentRange=new Range);return t.collapsed&&(e.initializingHtml&&e.adopt?t.setStart(e.contentElement,0):t.selectNodeContents(e.contentElement)),t}fixRefOwnerId(e,t,r){if(e.$refOwnerId===r){e.$refOwnerId=t;for(let{childNodes:n}=e,s=n.length;s-- >0;)this.fixRefOwnerId(n[s],t,r)}}get placement(){var e;const t=this,{element:r}=t;let n,s,a;if(r!=null&&r.offsetParent&&!GL.test(E.getStyleValue(r,"position"))){const o=r.nextElementSibling,l=r.previousElementSibling,d=!o&&l;s=E.getStyleValue(r.parentElement,"flex-direction"),s?s=s.startsWith("row")?"h":"v":(n=(e=o||l)==null?void 0:e.getBoundingClientRect(),a=n&&r.getBoundingClientRect(),s=n&&Math.abs(n.top-a.top)<Math.abs(n.left-a.left)?"h":"v"),s+=s==="h"?d?"r":"l":d?"b":"t"}return s}updateId(e,t){if(super.updateId(e,t),t){const{byRef:r,element:n}=this;for(const s in r)r[s].dataset&&(r[s].dataset.ownerCmp=e);n.id=e,this.fixRefOwnerId(n,e,t)}}get style(){const{element:e}=this;return(e==null?void 0:e.ownerDocument.defaultView.getComputedStyle(e))||this._style}updateStyle(e){this.element&&E.applyStyle(this.element,e)}updateTitle(e){this.titleElement&&(this.titleElement.innerHTML=e)}beforeAlignTo(e){}alignTo(e){var t,r;const n=this,{lastAlignSpec:s,element:a}=n,{offsetParent:o,style:l,classList:d}=a;if(s&&(s.monitorIntersection&&n.intersectionObserver.unobserve(s.target),isFinite(s.zone)&&a.classList.remove(Ux[s.zone])),!e){n.removeTransientListeners(),n.anchor=n.lastAlignSpec=null;return}n.beforeAlignTo(e),(e.nodeType===Element.ELEMENT_NODE||e.isWidget||e.$$name==="Point")&&(e={target:e}),n.releaseSizeConstraints();const{scrollable:c,constrainTo:u}=n,h=E.measureSize(E.getStyleValue(a,"minHeight"),a),f=E.measureSize(E.getStyleValue(a,"minWidth"),a),g=n.positioned&&E.getStyleValue(a,"position")!=="fixed",m=n.scale||1,v=e.target,y=e.realignEvent||JL(e.domEvent||e.event||(((t=v==null?void 0:v.target)==null?void 0:t.nodeType)===Node.ELEMENT_NODE?v:null)),b=((r=y==null?void 0:y.target)==null?void 0:r.nodeType)===Element.ELEMENT_NODE,C=b?y.target:v!=null&&v.isRectangle?v:(v==null?void 0:v.element)||v,D=(C==null?void 0:C.nodeType)===Element.ELEMENT_NODE;e=e.realignTarget?T.clone(e):T.merge({aligningToEvent:b,aligningToElement:D,constrainTo:u,align:"b-t",axisLock:n.axisLock,anchor:n.anchor},n.align,e),b&&(e.domEvent=y);const w=e.minWidth||f,x=e.minHeight||h;if(n.lastAlignSpec=e,D&&(e.target=e.anchoredTo=C,wn(C instanceof SVGElement?C.closest("svg"):C))){if(e=Object.create(e),e.target=n.lastAlignSpec.targetRect=e.realignTarget||(e.allowTargetOut?$.from(C,g?o:null,!g):E.isInView(b?y:C,!1,n)),!e.target){const G=n.hide();return n.isDestroyed||(n.lastAlignSpec.targetOutOfView=!0),G}e.target.height=Math.max(e.target.height,1),e.target.width=Math.max(e.target.width,1)}if(e.anchor&&(e.anchorSize=n.anchorSize,a.contains(n.anchorPathElement)||a.appendChild(n.anchorElement)),typeof e.offset=="string"){const G=a.querySelector(e.offset),Z=$.from(G),ne=Z.getAlignmentPoint(e.align),J=$.from(a),ee=J.getAlignmentPoint(e.align);e.offset=[ee[0]-ne[0],ee[1]-ne[1]]}n.isAligning=!0,n.trigger("beforeAlign",e);const R=$.from(a,g?o:null,!0),{width:M,height:I}=R;R.isAlignRectangle=!0,w&&(R.minWidth=w*m),x&&(R.minHeight=x*m),n.isAligning=!1,e.rtl=n.rtl,(e.align.includes("s")||e.align.includes("e"))&&(n.rtl?e.align=e.align.replace(/s/g,"r").replace(/e/g,"l"):e.align=e.align.replace(/s/g,"l").replace(/e/g,"r"));const _=n.lastAlignSpec.result=R.alignTo(e);let{align:F,anchor:A,x:P,y:V,width:B,height:W,overlap:q}=_;if(n.lastAlignSpec.zone=_.zone,W!=I){const G=W<I;n.alignmentChanges=n.alignmentChanges|(G?1:2),l[n.alignedHeightStyle=qx[n.alignmentChanges&3]]=`${W/m}px`,G&&!n._minHeight&&h&&(l.minHeight=`${Math.min(W,h)/m}px`),c&&(c.overflowY=G)}if(B!=M){const G=B<M;n.alignmentChanges=n.alignmentChanges|(G?4:8),l[n.alignedWidthStyle=qx[n.alignmentChanges&12]]=`${B/m}px`,G&&!n._minWidth&&f&&(l.minWidth=`${Math.min(B,f)/m}px`),c&&(c.overflowX=G)}if(F&&n.alignmentChanges){const G=$.from(a,g?o:null,!0);e.align=F;const Z=n.lastAlignSpec.result=G.alignTo(e);A=Z.anchor,P=Z.x,V=Z.y,B=Z.width,W=Z.height}if(n.centered||n.setXY(P,V),!_.overlap&&isFinite(_.zone)&&d.add(Ux[_.zone]),A!=null&&A.edge){let{edge:G}=A;const{anchorElement:Z,masked:ne}=n,{style:J}=Z,{style:ee}=Z.firstChild,Q=$.from(a),ae=[];G==="top"||G==="bottom"?(ae[0]=A.x,ae[1]=G==="top"?1:Q.height-1):(ae[0]=G==="left"?1:Q.width-1,ae[1]=A.y),J.display="none",ne&&(ne.element.style.display="none");let Ce=E.childFromPoint(a,...ae);if((Ce!=null&&Ce.matches(":focus")||Ce===ce.currentOverElement)&&a.compareDocumentPosition(Ce)&Node.DOCUMENT_POSITION_CONTAINED_BY&&(Ce=Ce.parentNode),Ce&&Ce!==document){let oe=E.getStyleValue(Ce,"background-color");for(;oe.match(mb)&&E.getStyleValue(Ce,"position")!=="absolute"&&(Ce=Ce.parentNode,Ce!==document);)oe=E.getStyleValue(Ce,"background-color");oe.match(mb)?n.anchorPathElement.setAttribute("fill",n.defaultAnchorBackgroundColor):n.anchorPathElement.setAttribute("fill",oe)}J.transform=J.display="",ne&&(ne.element.style.display=""),(G==="left"||G==="right")&&(G=G==="left"?n.rtl?"end":"start":n.rtl?"start":"end"),Z.className=`b-anchor b-anchor-${G}`,A.x&&(A.x/=m),A.y&&(A.y/=m),ee.left=`${A.x||0}px`,ee.translate=`0 ${A.y||0}px`,d.add("b-anchored")}else n._anchorElement&&(n.anchorElement.classList.add("b-hide-display"),d.remove("b-anchored"));if(!D){l.pointerEvents="none";const G=E.elementFromPoint(P,V);n.owns(G)||(n.lastAlignSpec.anchoredTo=G),l.pointerEvents=""}if((n.scrollAction==="realign"&&D||n.scrollAction==="hide")&&!n.documentScrollListener&&(n.clearTimeout("scrollListenerTimeout"),e.monitorTargetMutation&&!n.targetObserver&&(n.targetObserver||(n.targetObserver=new MutationObserver(n.onTargetParentMutation.bind(n)))).observe(E.getRootElement(C),{childList:!0,attributes:!0,subtree:!0}),n.setTimeout(()=>{const G=D?C:n.lastAlignSpec.anchoredTo,Z=G?E.getRootElement(G):null;n.documentScrollListener=j.addListener({element:document,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:n}),Z!=null&&Z.mode&&(n.targetRootScrollListener=j.addListener({element:Z,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:n}))},n.scrollAction==="hide"?n.ignoreScrollDuration:0,"scrollListenerTimeout")),D&&(e.monitorResize&&!n.observedTargetEl&&(it.addResizeListener(C,n.onTargetResize),n.observedTargetEl=C),e.monitorIntersection&&!(q||C.contains(a)||C.ownerSVGElement)&&n.intersectionObserver.observe(C)),!Y.isAndroid&&!n.observedConstrainEl){const G=u!=null&&u.isRectangle?globalThis:u;n.clearTimeout("resizeListenerTimeout"),n.setTimeout(()=>{n.observedConstrainEl=G||globalThis,it.addResizeListener(n.observedConstrainEl,n.onAlignConstraintChange)},n.ignoreScrollDuration,"resizeListenerTimeout")}}onTargetParentMutation(e){var t;const{element:r,lastAlignSpec:n}=this;n!=null&&n.aligningToElement&&((t=n.target)!=null&&t.isConnected?e.some(({target:s})=>s.contains(n.target)&&!r.contains(s))&&this.realign():this.hide())}get intersectionObserver(){return this._intersectionObserver||(this._intersectionObserver=new IntersectionObserver(this.onTargetIntersectionChange.bind(this),{root:Y.isSafari?this.rootElement:this.rootElement.ownerDocument}))}onTargetIntersectionChange(e){if(!this.isDestroyed){const t=e[e.length-1];t.isIntersecting||this.onAlignTargetOutOfView(t.target)}}onTargetResize(...e){const{lastAlignSpec:t}=this;if(t){const{width:r,height:n}=t.targetRect,{width:s,height:a}=t.target.getBoundingClientRect();(s!==r||a!==n)&&this.onAlignConstraintChange(...e)}}onAlignTargetOutOfView(e){this.hide(),this.lastAlignSpec&&(this.lastAlignSpec.targetOutOfView=!0)}onAlignConstraintChange(e,t,{height:r}){const{style:n}=this.contentElement,{overflowY:s}=n;this.setTimeout(this.realign,50),t&&r>t.height&&(n.overflowY="hidden",this.requestAnimationFrame(()=>n.overflowY=s))}realign(){const e=this,{lastAlignSpec:t}=e;if((e.floating||e.positioned)&&t&&e.isVisible){if(t.aligningToElement){const r=t.target.contains(this.element),n=E.isInView(t.target,!1,e);if(!t.allowTargetOut&&(!wn(t.target)||!n)){e.hide(),e.isDestroyed||(e.lastAlignSpec.targetOutOfView=!0);return}t.realignEvent=t.domEvent,t.realignTarget=r||t.aligningToEvent?null:n}E.addTemporaryClass(e.element,"b-realigning",e.realignTimeout,e),e.alignTo(t)}}rectangle(e,t,r){return this.rectangleOf("element",e,t,r)}rectangleOf(e,t,r,n){return typeof t!="string"?(n=r,r=t,t=""):t==="border"&&(t=""),typeof r=="boolean"&&(n=r,r=void 0),e!=="element"&&r===void 0&&(r=this.element),r=r!=null&&r.isWidget?r.element:r,typeof e=="string"&&(e=this[e]),$[t||"from"](e,r,n)}releaseSizeConstraints(){const e=this,{scrollable:t,element:r,alignmentChanges:n}=e,{style:s}=r;e.centered||E.setTopInsetInlineStart(r,0,0),n&12&&(E.setLength(r,e.alignedWidthStyle,e[`_last${k.capitalize(e.alignedWidthStyle)}`]||""),s.minWidth=e._minWidth||"",t&&(t.overflowY=t.config.overflowY)),n&3&&(E.setLength(r,e.alignedHeightStyle,e[`_last${k.capitalize(e.alignedHeightStyle)}`]||""),s.minHeight=e._minHeight||"",t&&(t.overflowX=t.config.overflowX)),e.alignmentChanges=0}toFront(){var e;const{element:t}=this,r=this.floating?this.floatRoot:this.positioned?t==null?void 0:t.parentNode:null,n=document.createDocumentFragment();if(this.containsFocus){for(let s=t.nextSibling,a;s;s=a)a=s.nextSibling,r.contains(s)&&((e=s.matches)!=null&&e.call(s,".b-floating,.b-positioned"))&&!this.owns(s)&&n.appendChild(s);n.childElementCount&&r.insertBefore(n,t)}else t.nextElementSibling&&r.appendChild(t)}updateRef(e){this.element.dataset.ref=e}get overflowElement(){return this.contentElement}get maxHeightElement(){return this.element}changeAlign(e){return typeof e=="string"?{align:e}:e}changeScrollable(e,t){return typeof e=="boolean"&&(e={overflowX:e,overflowY:e}),e?(e.element=this.overflowElement,e.widget=this,e.isScroller||(e=t?t.setConfig(e):new this.scrollerClass(e)),e.syncOverflowState()):t==null||t.destroy(),e}get html(){return this.isConfiguring?this.content||this._html:this.contentElement.innerHTML}changeHtml(e){return e&&typeof e=="object"&&!E.isVueConfig(e)&&!E.isReactElement(e)&&!Array.isArray(e)&&(e=[e]),e}updateHtml(e){const t=this;t.noChildElements=typeof e=="string"&&!NL.test(e),t.initializingElement||t.insertContent(e,!(t.initializingHtml&&t.adopt))}changeHtmlMutationObserver(e,t){const r=this,{contentElement:n}=r;if(t==null||t.disconnect(),e){const s=new MutationObserver(()=>{r.updatingHtml?r.updatingHtml=!1:r._html=n.innerHTML});return s.observe(n,e),s}}updateContent(e){this.initializingElement||this.insertContent(e)}insertContent(e,t=!1){const r=this,{element:n,contentElement:s,htmlCls:a,contentRange:o,autoClose:l}=r,d=t&&s===n&&r._anchorElement;if(E.isVueConfig(e))return E.handleVueContent(r,e);if(E.handleReactElement(r,e),!E.isReactElement(e)){if(r.updatingHtml=!0,r.getConfig("htmlMutationObserver"),d&&n.removeChild(d),a&&a.values.forEach(c=>n.classList[e?"add":"remove"](c)),r.autoClose=!1,e){let c,u;typeof e=="object"?(u=document.createDocumentFragment(),Array.isArray(e)?he.sync({domConfig:{children:e,onlyChildren:!0},targetElement:u}):he.sync({domConfig:{...e,onlyChildren:!0},targetElement:u})):t?(s.innerHTML=e,c=!0):(o.deleteContents(),o.insertNode(o.createContextualFragment(e)),c=!0),c||(t?(s.innerHTML="",s.appendChild(u)):n.isConnected?o.insertNode(u):s.insertBefore(u,s.firstChild))}else t||!n.isConnected?s.innerHTML="":o.deleteContents();r.autoClose=l,d&&n.appendChild(d),r.contentRangeStartOffset=o.startOffset,r.contentRangeEndOffset=o.endOffset,s.classList.toggle("b-no-child-elements",r.noChildElements),r.isComposable&&r.recompose(),(r.floating||r.positioned)&&!r.isAligning&&r.realign()}}onThemeChange(){var e;this._anchorSize=null,(e=this.anchorElement)!=null&&e.offsetParent&&this.realign()}get anchorSize(){const e=this;let t=this._anchorSize;if(!t){const r=parseFloat(E.getStyleValue(e.element,"border-top-width")),n=E.getStyleValue(e.element,"border-top-color"),s=e.anchorElement,{className:a}=s,o=s.firstElementChild,l=e.anchorPathElement=o.lastElementChild,d=e._hidden;s.className="b-anchor b-anchor-top";let c=E.getStyleValue(e.contentElement,"background-color");c.match(mb)&&(c=E.getStyleValue(e.element,"background-color")),e.defaultAnchorBackgroundColor=c,t=o.getBoundingClientRect();const[u,h]=t=e._anchorSize=[t.width,t.height];s.className=a,o.setAttribute("height",h+r),o.setAttribute("width",u),l.setAttribute("d",`M0,${h}L${u/2},0.5L${u},${h}`),r&&(l.setAttribute("stroke-width",r),l.setAttribute("stroke",n)),t[1]-=r,d&&e.syncHiddenCls(),e.themeChangeListener||(e.themeChangeListener=ce.ion({theme:"onThemeChange",thisObj:e})),e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}return t}get anchorElement(){const e=this;if(!e._anchorElement){const t=e.floating||e.positioned,r=`${e.id}-shadow-filter`;e._anchorElement=E.createElement({parent:e.element,className:"b-anchor b-anchor-top",children:[{tag:"svg",ns:"http://www.w3.org/2000/svg",version:"1.1",class:"b-pointer-el",children:[t?{tag:"defs",children:[{tag:"filter",id:r,children:[{tag:"feDropShadow",dx:0,dy:-1,stdDeviation:1,"flood-opacity":.2}]}]}:null,{tag:"path",[t?"filter":""]:`url(#${r})`}]}]})}return e._anchorElement}updateAnchor(e){var t;(t=this._anchorElement)==null||t.classList.toggle("b-hide-display",!e)}changeDraggable(e,t){var r;const n=this;if((r=t==null?void 0:t.destroy)==null||r.call(t),e){const s=typeof e=="object"?e:{};n.draggableHandleSelector=s.handleSelector,delete s.handleSelector,e=new xi(T.merge({name:"widget",target:n,floatRootOwner:n,rtlSource:n,positioning:n.floating?"inset":"",dragWithin:n.floating?void 0:n.element.parentNode,internalListeners:{beforeDragStart:n.onBeforeDragStart,dragStart:n.onWidgetDragStart,thisObj:n}},s))}return e}onBeforeDragStart(){const e=this;if(e.validateDragStartEvent(e.draggable.startEvent)){const{x:t,y:r,element:n}=e;return n.classList.remove("b-centered"),e.alignTo(),e.centered&&E.setTopInsetInlineStart(n,r,t),!0}return!1}validateDragStartEvent(e){var t;const r=this,n=E.elementFromPoint(e.clientX,e.clientY),{draggableHandleSelector:s,draggableBlacklistSelector:a}=r;if(a&&n.closest(a))return!1;if(s){const o=(t=UL.exec(s))==null?void 0:t[1];if(o&&n.closest(o))return!1;if(!n.closest(`${s}`))return!1}return!0}setStyle(e,t){return E.applyStyle(this.element,T.isObject(e)?e:{[e]:t}),this}changeFloating(e){return!!e}changePositioned(e){return!!e}updatePositionable(e){this.element.classList.toggle("b-positionable",!!e),e&&(this.innerItem=!1)}updatePositioned(e){const{element:t}=this;t.classList.toggle("b-positioned",!!e),e&&(this.innerItem=!1),t[e?"setAttribute":"removeAttribute"]("tabindex",e?"-1":void 0)}getXY(){const{element:e}=this;return[E.getPageX(e),E.getPageY(e)]}setXY(e,t){const r=this,{element:n}=r;if(r.floating||r.positioned){if(e!=null?r._x=e:e=r._x,t!=null?r._y=t:t=r._y,E.getStyleValue(n,"position")==="fixed"){const s=n.getBoundingClientRect(),[a,o]=E.getTranslateXY(n),l=e-s.x,d=t-s.y;E.setTranslateXY(n,a+l,o+d)}else r.rtl?E.setTopInsetInlineStart(n,t,n.offsetParent.offsetWidth-n.offsetWidth-e-1):E.setTopInsetInlineStart(n,t,e);r.isConstructing?r.centered=!1:n.classList.remove("b-centered")}}setPos(e,t){const r=this,{positionable:n}=r;[e,t]=E.unitize(e,t!=null?t:""),r.element.style[e]=t,r.top==null&&r.right==null&&r.bottom==null&&r.left==null?(n==="after"||n==="before")&&(r.positionable=null):n||(r.positionable="before")}updateBottom(e){this.setPos("bottom",e)}updateLeft(e){this.setPos("inset-inline-start",e)}updateRight(e){this.setPos("inset-inline-end",e)}updateTop(e){this.setPos("top",e)}get x(){return this.getXY()[0]}changeX(e){this.setXY(e)}get y(){return this.getXY()[1]}changeY(e){this.setXY(null,e)}get width(){const e=this,t=e.element;return e.monitorResize?(e._width==null&&(e._width=t.offsetWidth),e._width):t.offsetWidth}changeWidth(e){const t=this;if(E.setLength(t.element,"width",e),t._lastWidth=e,t._flex=null,t.element.style.flex="",t.monitorResize)t._oldWidth=t._width,t._width=null;else return e}clearWidthCache(){this._width=null}get maxWidth(){return E.measureSize(this.element.style.maxWidth,this.element)}updateMaxWidth(e){this._lastMaxWidth=e,E.setLength(this.element,"maxWidth",e)}get minWidth(){return E.measureSize(this.element.style.minWidth,this.element)}updateMinWidth(e){E.setLength(this.element,"minWidth",e)}updateFlex(e){this.getConfig("width"),(typeof e=="number"||!isNaN(e))&&(e=`${e} ${e}`),this.element.style.flex=e,this.element.style.width=""}updateAlignSelf(e){this.element.style.alignSelf=e}updateMargin(e){this.element.style.margin=this.parseTRBL(e).join(" ")}updateTextAlign(e,t){t&&this.element.classList.remove(`b-text-align-${t}`),this.element.classList.add(`b-text-align-${e}`)}get height(){const e=this,t=e.element;return e.monitorResize?(e._height==null&&(e._height=t.offsetHeight),e._height):t.offsetHeight}changeHeight(e){E.setLength(this.element,"height",e),this._lastHeight=e,this._height=null}get maxHeight(){return E.measureSize(this.maxHeightElement.style.maxHeight,this.element)}updateMaxHeight(e){this._lastMaxHeight=e,E.setLength(this.maxHeightElement,"maxHeight",e)}get minHeight(){return E.measureSize(this.element.style.minHeight,this.element)}updateMinHeight(e){E.setLength(this.element,"minHeight",e)}updateDisabled(e=!1,t){const r=this,{element:n,focusElement:s,ariaElement:a}=r;r.trigger("beforeUpdateDisabled",{disabled:e}),!(e&&(r.revertFocus(),!r._disabled!=!e))&&(n&&(n.classList[e?"add":"remove"]("b-disabled"),e==="inert"?n.inert=!0:t==="inert"&&(n.inert=!1),s&&(s.disabled=e),a&&a.setAttribute("aria-disabled",!!e)),r.onDisabled(e))}onDisabled(e){}disable(){this.disabled=!0}enable(){this.disabled=!1}requestFullscreen(){const e=this,t=qt.request(e.floating?e.floatRoot:e.element);return qt.onFullscreenChange(e.onFullscreenChange),e.element.classList.add("b-fullscreen"),t}exitFullscreen(){return qt.exit()}onFullscreenChange(){qt.isFullscreen||this.onExitFullscreen()}onExitFullscreen(){qt.unFullscreenChange(this.onFullscreenChange),this.element.classList.remove("b-fullscreen")}get tooltip(){var e;const t=this;if(t._tooltip)return t._tooltip;{const r=(e=ve.Tooltip)==null?void 0:e.getSharedTooltip(t.rootElement,t.eventRoot);if(r&&r.activeTarget===t._element&&r.isVisible)return r}}changeTooltip(e,t){const r=this,{element:n}=r;let s;if(e){if(!(r.preventTooltipOnTouch&&Y.isTouchDevice)){const a=(t==null?void 0:t.isTooltip)||e.newInstance||e.items||e.bbar||e.tbar;!e.isTooltip&&e.constructor.name!=="Object"&&(e={html:typeof e=="string"?e:r.placeholder,textContent:!0}),a?(e.type="tooltip",e.forElement||(e.forElement=n),!("showOnHover"in e)&&!e.forSelector&&(e.showOnHover=!0),"autoClose"in e||(e.autoClose=!0),s=e=ve.reconfigure(t,e,r),r.detachListeners("tooltipValueListener"),r.configureAriaDescription||e.ion({name:"tooltipValueListener",innerHtmlUpdate:"onTooltipValueChange",thisObj:r})):(n.dataset.btip=!0,r.tipConfig=e)}}else if(t)if(e==null&&t.isTooltip)t.destroy();else{t.html=null;return}else delete n.dataset.btip;return e&&!r.ariaLabel&&r.tooltipText&&n.setAttribute("aria-label",r.localizeText(r.tooltipText)),s}onTooltipValueChange({value:e,source:t}){this.ariaDescription=typeof e=="string"?e:t.contentElement.innerText}get tooltipText(){const e=this._tooltip;if(e)return e.isTooltip?e.contentElement.innerText:typeof e=="string"?e:e.html;if(this.tipConfig)return this.tipConfig.html}get isVisible(){const e=this;let t;return!!(!e._hidden&&(t=this.element)&&!e.isDestroying&&t.isConnected&&(!e.requireSize||wn(t))&&(!e.parent||e.parent.isVisible))}get isVisibleForValidation(){const e=this,{element:t}=e;let r;return!!(t&&(!e._hidden||e.tab&&!e.tab.hidden)&&!e.isDestroying&&t.isConnected&&(!(r=e.containingWidget)||r.isVisibleForValidation))}whenVisible(e,t=this,r,n=e.toString()){var s;const a=this;a.isVisible&&a.isPainted?((s=a.toCallWhenVisible)==null||s.delete(n),a.callback(e,t,r)):(a.toCallWhenVisible||(a.toCallWhenVisible=new Map)).set(n,{callback:e,thisObj:t,args:r})}focus(){var e;(e=this.focusableElement)==null||e.focus({preventScroll:!0})}get focusability(){return E.getFocusability(this.focusElement)}get focusableElement(){const e=this,t=!e.isDestroying&&e.isVisible&&!e.disabled&&e.focusElement;return(t===document.body||(t==null?void 0:t.offsetParent))&&t}get focusElement(){}get isFocusable(){return!!this.focusableElement}get isTabbable(){return this.focusability.tabbable}set isTabbable(e){const{focusability:t,focusElement:r}=this,[n,s]=t.natural?[!e&&"-1",e]:[e&&"0",!e];r&&!e!=!t.tabbable&&(s&&r.removeAttribute("tabIndex"),n&&r.setAttribute("tabIndex",n))}async show({align:e,animate:t=!0}={}){var r;const n=this,{element:s,floating:a}=n,{style:o}=s,l=t&&n.showAnimation;let d,c,u=!n.isVisible;return u&&(u=n.trigger("beforeShow"),T.isPromise(u)&&(u=await u)),u!==!1&&((r=n.internalBeforeShow)==null?void 0:r.call(n))!==!1?new Promise(h=>{if(n.cancelHideShowAnimation(),n.updateCentered(n._centered),a){const f=n.floatRoot;f.contains(s)||(n.rendered?f.appendChild(n.element):n.render(f,!1)),o.transform.includes("scale")&&(n.scale=null,o.transform=o.transformOrigin="");const g=n.closest(qL);if(g){const{scale:m}=g;n.scale=m,o.transform=`scale(${m})`,o.transformOrigin="0 0"}}if(n._hidden=!1,n.syncHiddenCls(),a&&!Ty(s))return n.hide(!1),h();if(n.onConfigChange({name:"hidden",value:!1,was:!0,config:n.$meta.configs.hidden}),n.afterShow(e,l?null:h),l){d=Object.keys(l)[0],c=l[d];const f=n.currentAnimation={showing:!0,styleProp:d,resolve:h};n.isAnimating=!0,o.transition="none",o[d]=c.from,E.getStyleValue(s,d),n.currentAnimation.detacher=j.onTransitionEnd({element:s,property:d,duration:Wx(c.duration)+20,handler:()=>n.afterHideShowAnimate(f),thisObj:n}),o.transition=`${d} ${c.duration} ease ${c.delay}`,o[d]=c.to}}):Promise.resolve()}async showBy(e,t,r){const n=this,s=Array.isArray(e);if(s||typeof e=="number"){const a=s?e:[e,t];e=Object.assign({target:new Li(a[0]+1,a[1]+1),matchSize:!1,align:"t0-b0"},s?t:r)}if(n.requireSize=!0,n.isVisible)E.addTemporaryClass(n.element,"b-realigning",300,n),n.alignTo(e);else return n.show({align:e})}afterShow(e,t){var r,n;const s=this;s.trigger("show"),s._configuredAnchorState=s.anchor,(n=(r=s.owner)==null?void 0:r.onChildShow)==null||n.call(r,s),s.triggerPaint(),(s.floating||s.positioned)&&(e?s.alignTo(e):s.centered?s.alignTo({target:s.constrainTo,align:"c-c"}):s.forElement&&s.alignTo(s.forElement)),t==null||t()}onChildHide(e){const{ariaElement:t}=this,{ownersRole:r}=e;if(e.floating&&t)if(r==="tooltip"){const{titleElement:n}=e,s=n&&E.getId(n),a=E.getId(e.contentElement);s&&E.removeAttributeValue(t,"aria-describedby",s),E.removeAttributeValue(t,"aria-describedby",a)}else this.ariaHasPopup=null,E.removeAttributeValue(t,"aria-controls",E.getId(e.ariaElement||e.element))}onChildShow(e){const{ariaElement:t}=this,{ownersRole:r}=e;if(e.floating&&t)if(r==="tooltip"){const{titleElement:n}=e,s=n&&E.getId(n),a=E.getId(e.contentElement);s&&E.addAttributeValue(t,"aria-describedby",s),E.addAttributeValue(t,"aria-describedby",a)}else this.ariaHasPopup=r,E.addAttributeValue(t,"aria-controls",E.getId(e.ariaElement||e.element))}triggerPaint(){var e;const t=this,{element:r,toCallWhenVisible:n}=t,s=!t.isPainted;if(t.isVisible){if(s&&(t.getConfig("scrollable",t.floating||t.positioned?"draggable":null),t.scaleToFitWidth&&!t.monitorResize&&(t.onParentElementResize=t.onParentElementResize.bind(t),it.addResizeListener(r.parentElement,t.onParentElementResize),t.updateScale()),!t.hideBryntumDomMessage&&(t.isTaskBoardBase||t.isGridBase||t.isCalendar)&&r.insertBefore(new Comment("POWERED BY BRYNTUM (https://bryntum.com)"),r.firstChild),t.onConnectedCallback&&globalThis.ResizeObserver&&(t.connectedObserver=new ResizeObserver(()=>{t.isElementConnected&&!r.isConnected?(t.onConnectedCallback(!1),t.isElementConnected=!1):!t.isElementConnected&&r.isConnected&&(t.onConnectedCallback(!0,t.isElementConnected==null),t.isElementConnected=!0)}),t.connectedObserver.observe(r))),t.eachWidget(WL,!1),s&&(t.getConfig("tooltip"),!ve.Ripple&&ve.RippleClass&&(ve.Ripple=new ve.RippleClass({rootElement:t.rootElement})),globalThis.DocsBrowser&&t.floating&&t.closest(a=>{var o;return(o=a.element)==null?void 0:o.closest(".fiddlePanelResult,.b-owned-by-fiddle")})&&r.classList.add("b-owned-by-fiddle")),t.isPainted=!0,s&&t.triggerConfigs("paint"),t.onInternalPaint({firstPaint:s}),t.trigger("paint",{firstPaint:s}),(e=t.afterInternalPaint)==null||e.call(t,{firstPaint:s}),n!=null&&n.size){for(const{callback:a,thisObj:o,args:l}of n.values())t.callback(a,o,l);n.clear()}s&&t.monitorResize&&!t.scaleToFitWidth&&it.onElementResize([{target:r}]),t.hasPainted=!0}}onInternalPaint(){}cancelHideShowAnimation(){const e=this,{currentAnimation:t,element:r}=e;t&&(e.isAnimating=!1,r.classList.contains("b-hiding")&&(r.classList.remove("b-hiding"),e._hidden=!1),t.detacher(),t.resolve(),r.style.transition=r.style[t.styleProp]="",e.currentAnimation=null,e.trigger(`${t.showing?"show":"hide"}AnimationEnd`))}afterHideShowAnimate(e){const t=this;e===t.currentAnimation&&(t.element.classList.remove("b-hiding"),t.cancelHideShowAnimation(),t._hidden&&t.afterHideAnimation())}suspendVisibility(){this._visibilitySuspended=(this._visibilitySuspended||0)+1,Object.defineProperty(this,"isVisible",YL)}resumeVisibility(e=!0){--this._visibilitySuspended||(delete this.isVisible,e&&this.triggerPaint())}hide(e=!0){return new Promise(t=>{const r=this;if(!r._hidden&&r.trigger("beforeHide",{animate:e})!==!1){const{element:n,lastAlignSpec:s}=r,{style:a}=n,o=e&&r.hideAnimation;if(r.clearTimeout("scrollListenerTimeout"),r.clearTimeout("resizeListenerTimeout"),r._hidden=!0,s&&(s.targetOutOfView=null,s.monitorIntersection&&(r.intersectionObserver.takeRecords(),r.intersectionObserver.unobserve(s.target))),r.onConfigChange({name:"hidden",value:!0,was:!1,config:r.$meta.configs.hidden}),!n){t();return}if(n.matches(":focus-within")&&r.revertFocus(!0),r.isDestroyed){t();return}if(r.cancelHideShowAnimation(),o){const l=Object.keys(o)[0],d=o[l];if(Number(getComputedStyle(r.element)[l])!==d.to){const c=r.currentAnimation={hiding:!0,styleProp:l,resolve:t};n.classList.add("b-hiding"),r.isAnimating=!0,c.detacher=j.onTransitionEnd({element:n,property:l,duration:Wx(d.duration)+20,handler:()=>{c===r.currentAnimation?r.afterHideShowAnimate(c):r.isAnimating=!1},thisObj:r}),a[l]=d.from,E.getStyleValue(n,l),a.transition=`${l} ${d.duration} ease ${d.delay}`,a[l]=d.to}else r.syncHiddenCls()}else r.syncHiddenCls();r.ownedWidgets&&Object.values(r.ownedWidgets).forEach(l=>{var d;return l.floating&&((d=l.hide)==null?void 0:d.call(l,e))}),r.afterHide(!o&&t,o)}else t(!1)})}realignOnTransitionEnd(e){this.doHideOrRealign(e)}doHideOrRealign({target:e,type:t,isTrusted:r}){const n=this,{lastAlignSpec:s,element:a}=n,o=s==null?void 0:s.anchoredTo,l=s==null?void 0:s.target,d=s==null?void 0:s.position,c=E.getActiveElement(n);if(!r||!wn(a)||e&&(t==="scroll"&&!E.isVisible(e)||a.contains(e)||e.nodeType===Element.ELEMENT_NODE&&n.owns(e)||e.nodeType===Element.DOCUMENT_NODE&&a.contains(c)&&E.isTextualInput(c)&&globalThis.innerHeight<document.body.offsetHeight))return;if(s.aligningToElement){const h=E.isInView(l,!1,n);if(h&&h.equals(s.targetRect))return}const u=n.scrollAction==="hide"&&n.getXY();if(n.scrollRealigning=t==="scroll",n.realign(),n.scrollRealigning=!1,!n.isDestroyed&&Ty(a)&&n.scrollAction==="hide"){const[h,f]=n.getXY(),g=h!==u[0]||f!==u[1];(s!=null&&s.aligningToEvent||(g||(l==null?void 0:l.$$name)==="Point"||d)&&(!o||!wn(o)||e&&E.isDescendant(e,o)))&&n.hide()}}afterHide(e=null,t=this.hideAnimation){var r,n;const s=this;s._anchor=s._configuredAnchorState,s.removeTransientListeners(),t||s.afterHideAnimation(),s.trigger("hide"),(n=(r=s.owner)==null?void 0:r.onChildHide)==null||n.call(r,s),e&&e()}removeTransientListeners(){var e,t;const r=this,{targetObserver:n}=r;r.clearTimeout("resizeListenerTimeout"),r.clearTimeout("scrollListenerTimeout"),n&&(n.disconnect(),delete r.targetObserver),r.documentScrollListener=(e=r.documentScrollListener)==null?void 0:e.call(r),r.targetRootScrollListener=(t=r.targetRootScrollListener)==null?void 0:t.call(r),r.observedTargetEl&&(it.removeResizeListener(r.observedTargetEl,r.onTargetResize),r.observedTargetEl=!1),r.observedConstrainEl&&(it.removeResizeListener(r.observedConstrainEl,r.onAlignConstraintChange),r.observedConstrainEl=!1)}afterHideAnimation(){const e=this,{element:t}=e;!e.hasOwnProperty("_hideMode")&&e.floating&&e.floatRoot.contains(t)?t.remove():e.syncHiddenCls(),e.defaultAnchorBackgroundColor&&e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}changeHidden(e){const t=this;let r;return t.isConfiguring?(r=!!e,t.syncHiddenCls(r)):(t.trigger("beforeChangeHidden",{hidden:e}),e?t.hide():t.show()),r}syncHiddenCls(e=this._hidden){const{element:t,hideMode:r}=this,n={"b-hidden":e};for(const s of zL)n[`b-hide-mode-${s}`]=s===r&&(e||s!=="display");E.assignClasses(t,n)}get assignedId(){return this.hasGeneratedId?null:this.id}get owner(){return this.parent||this._owner||this.containingWidget}changeOwner(e){if(!this.parent)return e}updateOwner(e,t){const r=this,{id:n}=r;t&&t.ownedWidgets&&delete t.ownedWidgets[n],e&&e!==r.parent&&((e.ownedWidgets||(e.ownedWidgets={}))[n]=r)}get containingWidget(){var e,t;let r=this.parent;if(!r){const n=((e=this.forElement)==null?void 0:e.nodeType)===Element.ELEMENT_NODE?this.forElement:(t=this.element)==null?void 0:t.parentNode;r=(n==null?void 0:n.closest(".b-widget"))&&ve.fromElement(n)}return r}get previousSibling(){return this.getSibling(-1)}get nextSibling(){return this.getSibling(1)}getSibling(e){var t,r;const n=this,{parent:s}=n,a=s?s.childItems:Array.from((r=(t=n.element.parentElement)==null?void 0:t.querySelectorAll(".b-widget"))!=null?r:[]);return s?a[a.indexOf(n)+e]:ve.fromElement(a[a.indexOf(n.element)+e])}up(e,t,r){var n;const{owner:s}=this;return e?(n=s==null?void 0:s.closest)==null?void 0:n.call(s,e,t,r):s}closest(e,t,r){const n=typeof r,s=n==="number",a=n==="string";for(let o=this,l=1;o;o=o.owner,l++){if(ve.widgetMatches(o,e,t))return o;if(s&&l>=r)return;if(a&&ve.widgetMatches(o,r,t))return;if(o===r)return}}owns(e,t){if(e){if("eventPhase"in e&&(e=e.target),e.nodeType===Element.ELEMENT_NODE){if(this.element.contains(e))return!0;e=e.getAttribute("owned-by")?ve.getById(e.getAttribute("owned-by")):ve.fromElement(e)}for(;e;){if(e.isHint||e===this||t&&this.ownedWidgets&&Object.values(this.ownedWidgets).some(r=>r.owns(e,!0)))return!0;e=e.owner}}return!1}eachAncestor(e){let t=this.owner;for(;t;){if(e(t)===!1)return!1;t=t.owner}return!0}changeMaximizeOnMobile(e){const t=this;if(t.floating&&Y.isMobile){const{initialConfig:r}=t;e?(t.centered=t.modal=!1,t.maximized=!0):(t.centered=r.centered,t.modal=r.modal,t.maximized=r.maximized)}}changeMonitorResize(e,t){const r=this.scaleToFitWidth?!1:!!e;if(r!==!!t)return r}updateMonitorResize(e){const t=this;Zs(t,"onElementResize")||(t.onElementResize=t.onElementResize.bind(t)),it[e?"addResizeListener":"removeResizeListener"](t.element,t.onElementResize)}changeReadOnly(e){if(e=!!e,!!this._readOnly!==e)return e}updateReadOnly(e){var t;(t=this.element)==null||t.classList[e?"add":"remove"]("b-readonly"),this.isConfiguring||(this.eachWidget(r=>{r.ignoreParentReadOnly||("_originalReadOnly"in r||(r._originalReadOnly=r.config.readOnly||!1),r.readOnly=e||r._originalReadOnly)},!1),this.trigger("readOnly",{readOnly:e}))}eachWidget(e,t=!0,r){const n=r?this.childItemsOrderedByRelevance:this.childItems,s=(n==null?void 0:n.length)||0,a={};for(let o=0;o<s;o++){const l=n[o];if(a.down=t,e(l,a)===!1||a.down&&l.eachWidget&&l.eachWidget(e,t,r)===!1)return!1}return!0}queryAll(e){const t=[];return this.eachWidget(r=>{e(r)&&t.push(r)}),t}query(e,t){let r=null;return this.eachWidget(n=>{if(e(n))return r=n,!1},!0,t),r}getWidgetByRef(e){var t,r;return e instanceof ve?e:((t=this==null?void 0:this.widgetMap)==null?void 0:t[e])||((r=this==null?void 0:this.owner)==null?void 0:r.getWidgetByRef(e))}onFocusIn(e){const t=this,{element:r}=t;t.containsFocus=!0,t.focusInEvent=e,(t.floating||t.positioned)&&t.toFront(),r.classList.add("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),r.contains(e._target)&&t.onInternalKeyDown&&!t.keyDownListenerRemover&&(t.keyDownListenerRemover=j.on({element:r,keydown:"onInternalKeyDown",thisObj:t})),t.trigger("focusin",e)}onFocusOut(e){const t=this;t.keyDownListenerRemover&&(t.keyDownListenerRemover(),t.keyDownListenerRemover=null),t.isDestroyed||(e.relatedTarget||t.revertFocus(!t.isVisible),t.containsFocus=!1,t.element.classList.remove("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),t.trigger("focusout",e))}captureFocus(){const e=this,t=E.getActiveElement(e),r=e.contains(t)&&e.captureFocusItem(t);return(n,s)=>{r&&!e.isDestroying&&(E.getActiveElement(e)!==t||s)&&r(n)}}captureFocusItem(e){return(t=!0)=>{this.contains(e)&&(t?e.focus():e.focus({preventScroll:!0}))}}contains(e,t){const{element:r}=this;if(e&&r)return e.isWidget&&(e=e.element),r.contains(e)&&(!t||r!==e)}revertFocus(e){var t;const r=this,n=E.getActiveElement(r);let s=(t=r.focusInEvent)==null?void 0:t.relatedTarget;(e||r.containsFocus&&(s==null?void 0:s.nodeType)===Element.ELEMENT_NODE&&r.element.contains(n))&&((!s||!E.isFocusable(s))&&(s=r.getFocusRevertTarget()),r._isRevertingFocus=!0,s&&E.isFocusable(s)?(s._isRevertingFocus=!0,s.focus({preventScroll:!0}),s._isRevertingFocus=!1):n==null||n.blur(),r._isRevertingFocus=!1)}getFocusRevertTarget(){var e;const t=this,{owner:r,focusInEvent:n}=t,s=n&&n.backwards?1:-1;let a=n&&n.relatedTarget;const o=a&&ve.fromElement(a);if(r&&!r.isDestroyed&&(!a||!E.isFocusable(a)||o&&!o.isFocusable)){if(a=null,r.eachWidget){const l=[];if(r.eachWidget(d=>{(d===t||d.isFocusable)&&l.push(d)},!1),l.length>1){const d=l.indexOf(t);a=l[d+s]||l[d-s]}}!a&&r.isFocusable&&(a=r),a=a?a.focusElement:(e=r.getFocusRevertTarget)==null?void 0:e.call(r)}return a}getStaticWidgetClasses(e,t){const r=new le,n=this.$meta.hierarchy;let s,a,o,l,d;for(a=n.indexOf(e);a<n.length;++a)s=n[a],d=Reflect.getOwnPropertyDescriptor(s.prototype,"widgetClass"),d!=null&&d.get?l=d.get.call(this):(o=Zs(s,"$$name")||Zs(s,"$name")||Zs(s,"_$name")?s.$$name:s.name,(o.length<3||o.includes("$"))&&console.warn(`Class "${o}" extending "${s.$name}" should have "$name" static getter with no less than 3 chars.`),l=`b-${o.toLowerCase()}`),l&&r.add(t?l+t:l);return r}get rootUiClass(){return ve}get staticClassList(){const{$meta:e}=this;let t=e.staticClassList;return t||(e.staticClassList=t=this.getStaticWidgetClasses(ve),Y.isTouchDevice&&t.add("b-touch")),t}get uiClasses(){return this.getConfig("ui"),this._uiClasses}get uiClassList(){return this.getConfig("ui"),this._uiClassList}get widgetClassList(){const e=this,{cls:t,defaultCls:r,uiClasses:n}=e;let{staticClassList:s}=e;(r||t)&&(s=s.clone(),r&&s.assign(r),t&&s.assign(t));const a=s.values;return n&&a.push(...n),e.floating&&a.push("b-floating"),e.collapsify==="hide"&&a.push("b-collapsify-hide"),a}changeCls(e){return le.from(e)}updateCls(e,t){if(!this.isConfiguring&&!this.isComposable){const{element:r}=this;t&&T.getTruthyKeys(t).forEach(n=>r.classList.remove(n)),e.assignTo(r)}}changeContentElementCls(e){return le.from(e)}changeHtmlCls(e){return le.from(e)}changeDefaultCls(e){return le.from(e,!0)}updateHideMode(){this.hasPainted&&this.syncHiddenCls()}changeUi(e){return le.from(e)}updateUi(e){let t=null,r,n;if(e){const s=this.getStaticWidgetClasses(this.rootUiClass);for(n in e)if(e[n])for(r in s)s[r]&&((t||(t=new le))[`${r}-ui-${n}`]=1)}this._uiClasses=t==null?void 0:t.values,this._uiClassList=t}fromCache(e,t=!1,r=this.element){var n;if(!r)return null;const s=this;return(n=s.cache)!=null&&n[e]?s.cache[e]:(s.cache||(s.cache={}),s.cache[e]=t?E.children(r,e):r.querySelector(e))}emptyCache(){this.cache&&(this.cache={})}changeMasked(e,t){var r;if(((r=this.masked)==null?void 0:r.type)!=="trial"){if((e===!0||e==="")&&(e="\xA0"),t&&!t.isDestroyed)typeof e=="string"?(t.text=e,e=t):e?(t.setConfig(e),e=t):t.destroy();else if(e){const n=ve.resolveType("mask");e=n.mergeConfigs(this.maskDefaults,e),e.owner=this,e=n.mask(e)}return e||null}}onMaskAutoClose(e){e.isDestroyed&&e===this.masked&&(this.masked=null)}mask(e){return this.masked=e,this.masked}unmask(){this.masked=null}onInternalResize(e,t,r,n,s){this._width=e.offsetWidth,this._height=e.offsetHeight}onElementResize(e,t,...r){var n;const s=this,{element:a}=s,o=(n=s._width)!=null?n:s._oldWidth,l=s._height,d=a.offsetWidth,c=a.offsetHeight;s.floating&&t&&s.onFloatingWidgetResize(e,t,...r),!s.suspendResizeMonitor&&(o!==d||l!==c)&&(s.onInternalResize(a,d,c,o,l),s.trigger("resize",{width:d,height:c,oldWidth:o,oldHeight:l}))}onFloatingWidgetResize(e,t,r){const n=this,{lastAlignSpec:s,constrainTo:a}=n;if(n.isVisible&&s&&s.target){const o=!t||r.height!==t.height,l=!t||r.width!==t.width,d=a&&!$.from(a).contains($.from(n.element,null,!0));(o&&s.zone!==2||l&&s.zone!==1||d)&&n.requestAnimationFrame(()=>n.realign())}}updateScale(){const e=this,t=e.element,r=t.parentElement;e.configuredWidth||(e.configuredWidth=e.width),t.style.display="none";const n=$.client(r),s=n.width/e.configuredWidth,a=e.scale=e.allowGrowWidth?Math.min(s,1):s;t.style.transform=`scale(${a})`,t.style.transformOrigin="top left",t.style.display="",e.allowGrowWidth&&s>1&&(e.width=e.configuredWidth*s)}onParentElementResize(e){this.updateScale()}parseTRBL(e,t="px"){if(e=e||0,typeof e=="number")return[`${e}${t}`,`${e}${t}`,`${e}${t}`,`${e}${t}`];const r=e.split(" "),n=r.length;return n===1?r[1]=r[2]=r[3]=r[0]:n===2?(r[2]=r[0],r[3]=r[1]):n===3&&(r[3]=r[1]),[isFinite(r[0])?`${r[0]}${t}`:r[0],isFinite(r[1])?`${r[1]}${t}`:r[2],isFinite(r[2])?`${r[2]}${t}`:r[3],isFinite(r[3])?`${r[3]}${t}`:r[4]]}get documentRoot(){var e;return((e=this.owner)==null?void 0:e.documentRoot)||this.element.getRootNode()}get eventRoot(){var e,t;return(e=this.element)!=null&&e.isConnected?E.getRootElement(this.element):((t=this.owner)==null?void 0:t.eventRoot)||this._rootElement}get rootElement(){var e,t;const r=this;if(!r._rootElement){let n=((e=r.owner)==null?void 0:e.rootElement)||E.getRootElement(r.forElement||((t=r.element)!=null&&t.isConnected?r.element:r.getRenderContext()[0]||r.element));n||(n=document.body),r._rootElement=n}return r._rootElement}get floatRoot(){var e;const t=this,{rootElement:r}=t;let{floatRoot:n}=r;if(n)r.contains(n)||r.appendChild(n);else{const{outerCls:s}=ve,a=(e=E.getThemeInfo(null,r))==null?void 0:e.name;if(!E.isValidFloatRootParent(r))throw new Error("Attaching float root to wrong root");a&&s.push(`b-theme-${a.toLowerCase()}`),n=r.floatRoot=E.createElement({className:`b-float-root ${s.join(" ")}`,parent:r}),nm.push(n),Y.isAndroid&&(n.style.height="100dvh",j.on({element:globalThis,orientationchange:()=>n.style.height=`${screen.height}px`,thisObj:this})),ce.ion({theme:({theme:o,prev:l})=>{n.classList.add(`b-theme-${o.toLowerCase()}`),n.classList.remove(`b-theme-${l.toLowerCase()}`)}})}return n.classList.toggle("b-rtl",!!t.rtl),n}get floatRootMaxZIndex(){let e=1;return Array.from(this.floatRoot.children).forEach(t=>{const r=parseInt(getComputedStyle(t).zIndex||0,10);r>e&&(e=r)}),e}get focusVisible(){return E.getActiveElement(this.element).matches(":focus-visible")}static get focusVisible(){return E.getActiveElement().matches(":focus-visible")}static get floatRoots(){return nm}static removeFloatRoot(e){nm.splice(nm.indexOf(e),1)}static get outerCls(){const e=["b-outer"],{platform:t}=Y;return t&&e.push(`b-${t}`),Y.isTouchDevice&&e.push("b-touch-events"),Y.isMobile&&e.push("b-mobile"),E.scrollBarWidth?e.push("b-visible-scrollbar"):e.push("b-overlay-scrollbar"),Y.isChrome?e.push("b-chrome"):Y.isSafari?e.push("b-safari"):Y.isFirefox&&e.push("b-firefox"),Y.isPhone&&e.push("b-phone"),globalThis.ResizeObserver||e.push("b-no-resizeobserver"),e}get isAnimating(){return this._isAnimatingCounter>0}set isAnimating(e){const t=this,{_isAnimatingCounter:r}=t;t._isAnimatingCounter=Math.max(0,r+(e?1:-1)),r===0&&e?(t.element.classList.add("b-animating"),t.trigger("animationStart")):r===1&&!e&&(t.element.classList.remove("b-animating"),t.trigger("animationEnd"))}async waitForAnimations(){this.isAnimating&&await this.await("animationEnd",{checkLog:!1})}async executeAndAwaitAnimations(e,t,r){const n=e.getAnimations({subtree:!0});await t();const s=e.getAnimations({subtree:!0}),a=L.delta(n,s).onlyInB,o=a.filter(l=>l.effect.getTiming().iterations!==1/0);o.length&&await Promise.allSettled(o.map(l=>l.finished)),this.isDestroyed||r==null||r()}static query(e,t=!1){const{idMap:r}=ve.identifiable;for(const n in r)if(ve.widgetMatches(r[n],e,t))return r[n];return null}static queryAll(e,t=!1){const{idMap:r}=ve.identifiable,n=[];for(const s in r)ve.widgetMatches(r[s],e,t)&&n.push(r[s]);return n}static fromElement(e,t,r){const n=typeof t;typeof e=="string"&&(e=document.querySelector(e)),e&&!e.nodeType&&(e=e.target),(n==="number"||t&&t.nodeType===Element.ELEMENT_NODE)&&(r=t,t=null);let s=e,a=0,o,l,d;for(typeof r!="number"&&(o=r,r=Number.MAX_VALUE),n==="string"&&(t=t.toLowerCase());s&&s.nodeType===Element.ELEMENT_NODE&&a<r&&s!==o;){if(l=s.dataset&&s.dataset.ownerCmp||s.id,l){if(d=ve.getById(l),d)if(t){if(n==="function"){if(t(d))return d}else if(ve.widgetMatches(d,t,!0))return d}else return d;a++}s=hu(s)}return null}static fromSelector(e){const t=document.querySelector(e);return t?ve.fromElement(t):null}triggerFieldChange(e,t=!0){var r;t?this.trigger("change",e):e.source=this,(r=this.eachAncestor)==null||r.call(this,n=>{var s,a;if((s=n.onFieldChange)==null||s.call(n,e),(a=n.isolateFieldChange)!=null&&a.call(n,this))return!1})}isolateFieldChange(e){return this.isolateFields}setupFocusListeners(){var e,t;ce.setupFocusListenersOnce(this.eventRoot,j),(t=(e=ve.Ripple)==null?void 0:e.setupRippleListenerOnce)==null||t.call(e)}static widgetMatches(e,t,r){return t==="*"?!0:typeof t=="function"?t(e):ve.isType(e,t,r)}static attachTooltip(e,t){return typeof t=="string"&&(t={html:t}),ve.create(Object.assign({forElement:e},t),"tooltip"),e}static append(e,t={}){return(t instanceof HTMLElement||typeof t=="string")&&(t={appendTo:t}),L.asArray(e).map(r=>ve.create(T.assign({},t,r)))}changeDock(e){return e==="start"?"left":e==="end"?"right":e}updateRtl(e){super.updateRtl(e),this.eachWidget(t=>{"rtl"in t.initialConfig||(t.rtl=e)}),this.ownedWidgets&&Object.values(this.ownedWidgets).forEach(t=>{"rtl"in t.initialConfig||(t.rtl=e)})}get scrollAction(){let{_scrollAction:e}=this;return!e&&this.anchor&&(e="realign"),e}announceAriaLive(e="",t="polite"){var r;const n=this.ariaLiveEl||(this.ariaLiveEl=E.createElement({parent:this.element,className:"b-arialive-el","aria-live":t,"aria-atomic":!0}));if((r=this.element)!=null&&r.isConnected){const s=e.children?e.children.reduce(eO,[]).join(" "):e.text||e;n.textContent=s}}};p(am,"$name","Widget"),p(am,"type","widget"),p(am,"convertPinchToMousewheel",!0);var z=am,tO=z.prototype;["compose","domSyncCallback"].forEach(i=>tO[i].$nullFn=!0),z.initClass(),E.Widget=z,ce.Widget=z,Object.assign(globalThis.bryntum||(globalThis.bryntum={}),{Widget:z,get:(i=globalThis.$0)=>i.nodeType?z.fromElement(i):z.getById(i),query:z.query,queryAll:z.queryAll,fromElement:z.fromElement,fromSelector:z.fromSelector}),z._$name="Widget";var dr=class extends O.mixin(Ie,En){get contentElement(){var i;return(i=this.owner)==null?void 0:i.contentElement}onChildAdd(i){}onChildRemove(i){}renderChildren(){const i=this,{owner:e,itemCls:t}=i,{contentElement:r,items:n}=e,s=e.itemCls,a=n==null?void 0:n.length;if(a){e.textContent=!1;for(let o,l,d=0;d<a;d++){const c=n[d],{element:u,positionable:h}=c,{classList:f}=u;u.dataset.itemIndex=d,f.contains("b-outer")&&f.remove(...z.outerCls),t&&f.add(t),s&&f.add(s),l=r,h&&(o=e.getPositionableLocation(h),(l=o[0])||(l=o[1].parentElement,c.insertBefore=o[1])),c.render(l,!!e.isPainted)}}i.syncPendingConfigs(),i.syncChildCount()}removeChild(i){const e=this,{element:t}=i,{owner:r,itemCls:n}=e,{contentElement:s}=r,a=r.itemCls;s.contains(t)&&t.remove(),delete t.dataset.itemIndex,n&&t.classList.remove(n),a&&t.classList.remove(a),e.fixChildIndices(),e.syncChildCount()}appendChild(i){const{element:e}=i,{owner:t,itemCls:r}=this,{contentElement:n}=t,s=t.itemCls;e.dataset.itemIndex=t.indexOfChild(i),t.textContent=!1,r&&e.classList.add(r),s&&e.classList.add(s),i.render(n,!!t.isPainted),this.syncChildCount()}insertChild(i,e){const t=this,{element:r}=i,{owner:n,itemCls:s}=t,{contentElement:a}=n,o=E.getChild(a,`[data-item-index="${e}"]`),l=n.itemCls;n.textContent=!1,s&&r.classList.add(s),l&&r.classList.add(l);const d=a.contains(r);a.insertBefore(r,o),d||i.render(null,!!n.isPainted),t.fixChildIndices(),t.syncChildCount()}fixChildIndices(){this.owner.items.forEach((i,e)=>{i.element.dataset.itemIndex=e})}syncChildCount(){var i;const{owner:e}=this,{length:t}=e.items;(i=e.contentElement)==null||i.classList[t===1?"add":"remove"]("b-single-child")}syncConfigLater(i){const e=this.pendingConfigs||(this.pendingConfigs=[]);e.includes(i)||e.push(i)}syncConfigStyle({name:i,style:e,classes:t,map:r}){const n=this,s=`b-box-${i}-`,{contentElement:a}=n,o=n[i];let l=(r==null?void 0:r[o])||o;if(a){if(t){const{classList:d}=a;t.forEach(c=>{c!==l&&d.remove(s+c)}),t.includes(l)&&(d.add(s+l),l="")}a.style[e]=l}else n.syncConfigLater(i)}syncPendingConfigs(){const i=this,{pendingConfigs:e}=i;let t;if(e)for(i.pendingConfigs=null;t=e.pop();)i[i.$meta.configs[t].updater](i[t])}};p(dr,"type","default"),p(dr,"configurable",{owner:null,containerCls:"b-auto-container",itemCls:null}),p(dr,"factoryable",{defaultType:"default"}),dr.initClass(),dr._$name="Layout";var Yx=0,iO=i=>i.ripple,Vo=class extends z{afterConstruct(){super.afterConstruct(),this.setupRippleListenerOnce()}setupRippleListenerOnce(){this.rippleControlEventDetacher||(this.rippleControlEventDetacher=j.on({element:this.rootElement,mousedown:"onRippleControllingEvent",thisObj:this,capture:!0,once:!0}))}cleanUpRippleListeners(){var i,e;(i=this.rippleControlEventDetacher)==null||i.call(this),(e=this.listenerDetacher)==null||e.call(this),this.rippleControlEventDetacher=null,this.listenerDetacher=null}onRippleControllingEvent(i){var e;const t=this;t.show();const r=E.getStyleValue(t.circleElement,"animationName");t.hide(),(e=t.listenerDetacher)==null||e.call(t),r&&r!=="none"&&(t.listenerDetacher=j.on({mousedown:{element:t.rootElement,capture:!0,handler:"onMousedown"},touchstart:{element:t.rootElement,capture:!0,handler:"onTouchStart"},animationend:{element:t.circleElement,handler:"onAnimationEnd"},thisObj:t}),i.type==="mousedown"&&(t.onMousedown(i),t.listenerDetacher=we.createSequence(t.listenerDetacher,ce.ion({theme:"onRippleControllingEvent",thisObj:t}),t,t)))}onTouchStart(i){Yx=performance.now(),this.handleTriggerEvent(i)}onMousedown(i){performance.now()-Yx>200&&this.handleTriggerEvent(i)}handleTriggerEvent(i){const e=z.fromElement(i.target,iO);if(e){const t=e.ripple,r=t.delegate?i.target.closest(t.delegate):e.focusElement||e.element;if(r){const n=T.assign({event:i,target:r,radius:this.radius},t);if(typeof n.clip=="string"&&(n.clip=e[n.clip]||i.target.closest(n.clip),!n.clip))return;this.ripple(n)}}}ripple({event:i,point:e=j.getClientPoint(i),target:t=i.target,clip:r=t,radius:n=this.radius,color:s=this.color}){this.clip=r,r=$.from(r,null,!0);const a=this,o=r.getDelta(e),l=a.rippleElement.style,d=a.circleElement,c=E.getStyleValue(t,"border-radius");a.hide(),l.transform=`translateX(${o[0]}px) translateY(${o[1]}px)`,l.height=l.width=`${n}px`,a.element.style.borderRadius=c,d.setAttribute("r",n),d.setAttribute("fill",s),a.showBy({target:r,align:"c-c",matchSize:!0})}onAnimationEnd(i){i.animationName==="b-ripple-expand"&&this.hide()}};p(Vo,"$name","Ripple"),p(Vo,"type","ripple"),p(Vo,"configurable",{old_element:{children:[{className:"b-ripple-inner",reference:"rippleElement"}]},element:{children:[{tag:"svg",class:"b-ripple-inner",reference:"rippleElement",ns:"http://www.w3.org/2000/svg",version:"1.1",viewBox:"0 0 100 100",children:[{reference:"circleElement",tag:"circle",cx:"0",cy:"0",r:10}]}]},floating:!0,hideAnimation:!1,showAnimation:!1,color:"rgba(0,0,0,.3)",startRadius:10,radius:100}),z.RippleClass=Vo,Vo._$name="Ripple";var vb=i=>i.element.classList.contains("b-visible"),rO=i=>!vb(i)&&i.isVisible,jo=class It extends z{static get(e){return Ge.get(e,"masks")||Ge.set(e,"masks",[])}static getActive(e){return It.get(e).find(vb)||null}static getPending(e){return It.get(e).filter(rO).sort(z.weightSortFn)}static mask(e,t=document.body){return It.new({target:t},e)}static mergeConfigs(...e){return e=e.map(t=>typeof t=="string"?{text:t}:t),super.mergeConfigs(...e)}static sync(e){const t=It.getActive(e),r=!t&&It.getPending(e)[0]||null,n=t||r,s=(n==null?void 0:n.mode)||"",a=s.endsWith("blur")?`b-masked-${s}`:"";let o,l,d;r&&(l=r.element.classList,r.showDelay&&!e.classList.contains("b-masked")&&(l.add("b-delayed-show"),r.delayedShow()),l.add("b-visible")),e.classList.toggle("b-masked",!!n);for(o of e.children)l=o.classList,l.contains("b-mask")||(d=Array.from(l).filter(c=>c.startsWith("b-masked-")&&a!==c),d.length&&l.remove(...d),a&&l.add(a))}static unmask(e=document.body){var t;const r=It.get(e),n=r.length;return n?(t=r[n-1])==null?void 0:t.close():null}static unmaskAll(e=document.body){return It.get(e).filter(t=>!vb(t)).forEach(t=>t.destroy()),It.unmask(e)}destroy(){this.type!=="trial"&&super.destroy()}compose(){const{icon:e,maxProgress:t,mode:r,progress:n,showDelay:s,text:a,html:o,useTransition:l}=this;return{class:{"b-mask":1,"b-delayed-show":s,"b-progress":t,"b-prevent-transitions":!l,[`b-mask-${r}`]:1},children:{maskContent:{class:"b-mask-content",children:{progressElement:t?{class:"b-mask-progress-bar",style:{width:`${Math.max(0,Math.min(100,Math.round(n/t*100)))}%`}}:null,maskText:{class:"b-mask-text",html:`${e?`${`<i class="b-mask-icon ${e}"></i>`}`:""}${a||o||""}`}}}},listeners:{mousedown:"onMaskMouseDown",capture:!0}}}onMaskMouseDown(e){e.preventDefault()}generateAutoId(){const{type:e}=this;return`mask${typeof e=="string"?e.trim():""}-${It.counter++}`}updateAutoClose(e){this.deferredClose.cancel(),e&&(this.deferredClose.delay=e,this.deferredClose())}updateCover(){this.syncCover()}syncCover(){var e,t;(t=(e=this.owner)==null?void 0:e.syncMaskCover)==null||t.call(e,this)}set error(e){this.setConfig({...this.errorDefaults,text:e})}onOwnerResize(){this.syncCover()}updateOwner(e){this.detachListeners("cover"),e==null||e.ion({name:"cover",recompose:"onOwnerResize",resize:"onOwnerResize",thisObj:this})}updateShowDelay(e){const{delayedShow:t}=this;t.delay=e,e||t.flush()}changeTarget(e){return e===void 0?e=document.body:typeof e=="string"&&(e=this.owner[e]),e}updateTarget(e,t){const r=this,{id:n,element:s}=r,a=t&&It.get(t);t&&(t[n]===r&&delete t[n],L.remove(a,r),It.sync(t)),e?(e[n]||(e[n]=r),s.parentNode!==e&&e.appendChild(s),L.include(It.get(e),r),It.sync(e)):s.remove()}deferredClose(){var e;const t=this,{owner:r}=t;t.close().then(()=>{var n;return(n=r==null?void 0:r.onMaskAutoClose)==null?void 0:n.call(r,t)}),(e=r==null?void 0:r.onMaskAutoClosing)==null||e.call(r,t)}delayedShow(){this.element.classList.remove("b-delayed-show")}updateHidden(e,t){var r;(r=super.updateHidden)==null||r.call(this,e,t),e&&this.element.classList.remove("b-visible"),It.sync(this.target)}afterShow(...e){var t;(t=super.afterShow)==null||t.call(this,...e),It.sync(this.target)}afterHide(...e){var t;(t=super.afterHide)==null||t.call(this,...e),this.element.classList.remove("b-visible"),It.sync(this.target)}async close(){await this.hide(),this.destroy()}};p(jo,"$name","Mask"),p(jo,"type","mask"),p(jo,"configurable",{autoClose:null,cover:null,icon:"b-icon b-icon-spinner",errorDefaults:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},maxProgress:null,mode:"dark",progress:null,target:{$config:"nullify",value:void 0},text:null,type:null,showDelay:null,useTransition:!1}),p(jo,"delayable",{deferredClose:0,delayedShow:0,syncCover:{type:"throttle",delay:100}}),p(jo,"counter",0);var Qs=jo;Qs.initClass(),Qs._$name="Mask";var nO=Object.freeze({}),{isArray:zo}=Array,sO=i=>i.weight,Kx=i=>i&&!i.hidden,aO=i=>i.isFocusable,oO=["display","flex-direction"],lO={default:1,box:1},dO=Symbol("options"),ct=class extends z{static get configurable(){return{items:null,lazyItems:{$config:["lazy"],value:null},tabBarItems:null,defaults:null,defaultType:"widget",layoutStyle:null,itemCls:null,layout:{type:"default"},namedItems:{$config:"lazy",value:null},overflowable:{value:null,default:!1,$config:null},textContent:!0,record:null,strictRecordMapping:null,autoUpdateRecord:null,autoUpdateUserChangesOnly:!0,autoUpdateFields:null,hideWhenEmpty:null,contentElMutationObserver:{$config:["lazy","nullify"],value:!0},isolateFields:!1,focusDescendant:!1,defaultBindProperty:null,defaultFocus:null}}static get prototypeProperties(){return{flexRowCls:"b-flex-row",flexColCls:"b-flex-column",initialItems:!0}}startConfigure(i){const e=i.items||i.lazyItems;(this.hasItems=!!(e&&(zo(e)?e:Object.keys(e)).length))||(this.initialItems=!1),super.startConfigure(i)}get firstItem(){return this.getAt(0)}get lastItem(){return this.getAt(-1)}getPositionableItems(i,e){var t;const r=((t=this._items)==null?void 0:t.filter(n=>i?n.positionable===i:n.positionable))||[];return e?Object.fromEntries(r.map((n,s)=>[`$${n.positionable}${s}`,n.element])):r}getPositionableLocation(i){return[this.contentElement]}getAt(i){return this.ensureItems().at(i)}remove(...i){let e=!0;i.length===1&&(zo(i[0])?i=i[0]:e=!1);const t=this,{_items:r}=t,n=[];for(let s=0;s<i.length;s++){const a=i[s];r.includes(a)&&(r.remove(a),t.layout.removeChild(a),n.push(a),t.onChildRemove(a))}return e?n:n[0]}removeAll(){return this.remove(this.items)}add(...i){const e=this,t=e.ensureItems(),r=[];let n=!0,s,a,o;for(i.length===1&&(zo(i[0])?i=i[0]:n=!1),a=0;a<i.length;a++)s=i[a],s.isWidget?s.parent=e:s=e.createWidget(s),(s==null?void 0:s.weight)!=null?(o=L.findInsertionIndex(s,t.values,z.weightSortFn),r.push(e.insert(s,o))):s&&(t.includes(s)||(t.add(s),e.onChildAdd(s),e.layout.appendChild(s),r.push(s)));return n?r:r[0]}ensureItems(){const i=this;return i.getConfig("items"),i.getConfig("lazyItems"),i._items||(i.items=[]),i._items}insert(i,e){var t;const r=this,n=r.ensureItems();i instanceof z?i.parent=r:i=r.createWidget(i),n.includes(e)&&(e=r.indexOfChild(e)-1),e=Math.min(e,n.count);const s=n.values;if(s.includes(i)){const a=s.indexOf(i);s.splice(a,1),s.splice(e,0,i),n.values=s,r.syncChildCount(),(t=r.onChildMove)==null||t.call(r,i),r.layout.insertChild(i,e<a?e:e+1)}else s.splice(e,0,i),n.values=s,r.onChildAdd(i),r.layout.insertChild(i,e);return i}indexOfChild(i){return this.items.indexOf(i)}changeLazyItems(i){this.items=i,this.layout.renderChildren()}onChildWeightChange(i){var e;if(this.items.length>1){const{lastItem:t}=this;this._items.sort(z.weightSortFn);const{items:r}=this;this.contentElement.insertBefore(i.element,((e=r[r.indexOf(i)+1])==null?void 0:e.element)||t.element.nextSibling)}}changeItems(i,e){const t=this,r=[],n=new xu;return zo(i)?t.processItemsArray(i,r):i&&t.processItemsObject(i,t.namedItems,r),r.some(sO)&&r.sort(z.weightSortFn),n.add(r),e&&e.forEach(s=>{t.remove(s),!n.includes(s)&&s._createdBy===t&&s.destroy()}),n}afterConstruct(){const{rtl:i}=this,{classList:e}=this.contentElement;e.toggle("b-rtl",i===!0),e.toggle("b-ltr",i===!1)}updateRtl(i){super.updateRtl(i);const{contentElement:e}=this;e&&(e.classList.toggle("b-rtl",i===!0),e.classList.toggle("b-ltr",i===!1))}updateItems(i,e){let t=0;i.forEach(r=>{this.onChildAdd(r),e&&!e.temporary&&this.layout.insertChild(r,t),++t}),this.initialItems=!1}updateHideWhenEmpty(){this.syncChildCount(this.rendered)}get items(){const i=this;if(i.getConfig("lazyItems"),!i._items){if(i.initializingItems)return[];i._items=new xu,i._items.temporary=!0}return i._items.values}processItemsArray(i,e){const t=i.length;let r,n;for(r=0;r<t;r++)n=i[r],n instanceof z?(n.parent=this,n.element.classList.remove(...z.outerCls)):n=this.createWidget(n),n&&((n.ref||n.id)&&this.addDescendant(n),e.push(n))}processItemsObject(i,e,t=[]){let r,n;for(n in i)r=i[n],r&&(e&&n in e&&(r=typeof r=="object"?T.merge(T.clone(e[n]),r):e[n]),r&&(r instanceof z?r.parent=this:(r instanceof Object&&(r.ref=n),r=this.createWidget(r)),r&&(r.ref=n,this.addDescendant(r),t.push(r))));return t}onChildAdd(i){const e=this;if(i.innerItem&&e.readOnly&&!i.ignoreParentReadOnly&&(i.readOnly=!0),e.onChildAddLayout(i),i.ref||i.id)for(let t=e;t;t=t.parent)t.addDescendant(i);e.syncChildCount(!0),!e.onConfigChange.$nullFn&&e.onConfigChange({name:"items",config:e.$meta.configs.items})}onChildAddLayout(i){i.innerItem&&this.layout.onChildAdd(i)}onChildHide(i){var e;super.onChildHide(i),(e=this._items)!=null&&e.includes(i)&&this.syncChildCount(!0)}onChildShow(i){var e;super.onChildShow(i),(e=this._items)!=null&&e.includes(i)&&this.syncChildCount(!0)}syncChildCount(i){if(!this.isConfiguring&&!this.isDestroying){const e=this,{items:t,hasItems:r}=e,n=t.filter(Kx),{length:s}=n;if(e.visibleChildCount=s,e.hideWhenEmpty&&i){const a=!s;!!e._hidden!==a&&(e.hidden=a)}t.forEach(a=>a.element.classList.remove("b-last-visible-child","b-first-visible-child")),s&&(n[0].element.classList.add("b-first-visible-child"),n[s-1].element.classList.add("b-last-visible-child")),e.hasItems=!!e.childItems.length,e.contentElement.classList[s?"remove":"add"]("b-no-visible-children"),e.isComposable?r!==e.hasItems&&e.recompose():e.updateTextContent(e._textContent)}}syncFlexDirection(){const i=this,{contentElement:e,flexColCls:t,flexRowCls:r}=i,n=new le(e.className),s=E.getStyleValue(e,oO);n[r]=n[t]=0,s.display==="flex"&&(n[s["flex-direction"]==="row"?r:t]=1),E.syncClassList(e,n)}addDescendant(i){const e=i.ref||i.id,t=this._widgetMap||(this._widgetMap={});t[e]||(t[e]=i)}cleanupWidgetMap(i){const e=this,t=new Map,r=i.ref||i.id;r&&t.set(r,i),i.eachWidget(n=>{const s=n.ref||n.id;s&&t.set(s,n)});for(let n=e;n;n=n.parent)for(const[s,a]of t)n.widgetMap[s]===a&&delete n.widgetMap[s]}onChildRemove(i){const e=this;e.cleanupWidgetMap(i),e.layout.onChildRemove(i),e.syncChildCount(!0),!e.onConfigChange.$nullFn&&e.onConfigChange({name:"items",config:e.$meta.configs.items})}get widgetMap(){return this._widgetMap||(this._widgetMap={}),this.initializingItems||this.getConfig("items"),this._widgetMap}changeRecord(i){return this._record=i==null?nO:null,i}updateRecord(i){var e;const t=this;(e=t.recordUpdateDetacher)==null||e.call(t),t._hasChanges=!1,t.changeSet={},t.clearError(),t.trigger("beforeSetRecord",{record:i}),t.setValues(i,{onlyName:t.strictRecordMapping,highlight:!!t.$highlight}),t.autoUpdateFields&&(i!=null&&i.firstStore)&&(t.recordUpdateDetacher=i.firstStore.ion({update:t.onRecordUpdated,thisObj:t}))}setRecord(i,e){this.$highlight=e,this.record=i,this.$highlight=!1}onRecordUpdated({record:i}){i===this.record&&this.setValues(this.record,!0,!0)}shouldUpdateRecordOnAction(i,e){return i&&(e.userAction||!this.autoUpdateUserChangesOnly)}onFieldChange(i){const e=this,{source:t}=i,{hasChanges:r,isConfiguring:n,isSettingValues:s,initialValues:a}=e;if(!s&&!n){const{record:o}=e;let l=!1;if(e.autoUpdateRecord&&e.shouldUpdateRecordOnAction(o,i)){const{strictRecordMapping:d}=e,{name:c,ref:u,isValid:h=!0,defaultBindProperty:f}=t,g=t[f||"value"],m=d?c:c||u;o&&m&&h&&(o.isModel?o.setValue(m,g):o[m]=g,l=!0)}if(o&&a){const d=t.getValueName(a[dO]);if(d&&(!o.isModel||o.getFieldDefinition(d))){const{changeSet:c}=e;(!e.autoUpdateRecord||!l)&&!T.isEqual(t.value,a[d])?(c||(e.changeSet={}))[d]=!0:c&&delete c[d],e._hasChanges=void 0}}e.hasChanges!==r&&e.trigger("dirtyStateChange",{dirty:e.hasChanges})}}get hasChanges(){let{_hasChanges:i}=this;if(i===void 0){const{changeSet:e}=this;i=this._hasChanges=!!(e&&Object.values(e).some(t=>t))}return!!i}getValues(i){const e={};return this.eachWidget((t,r)=>{t.isolateFields?r.down=!1:"name"in t&&(!i||i(t))&&(e[t.name]=t.value)},!0),e}get values(){const i={};return this.gatherValue(i),i}set values(i){this.assignValue(i)}get isSettingValues(){return!!this.assigningValues}get assigningValues(){var i;return this._assigningValues||((i=this.parent)==null?void 0:i.assigningValues)}set assigningValues(i){this._assigningValues=i}assignValue(i,e){super.assignValue(i,e),this.isolateFields||this.setValues(i,e)}gatherValue(i){super.gatherValue(i),this.isolateFields||this.gatherValues(i)}setValues(i,e=this.assignValueDefaults){const t=this;t.assigningValues=e,t.initialValues={optionsProp:e},t.eachWidget(r=>{const n=r.getValueName(e);n&&(!i||n in i)&&(t.initialValues[n]=(i==null?void 0:i[n])||null),r.assignValue(i,e)},!1),t.assigningValues=!1}get hasNoChildren(){const i=this,{items:e,lazyItems:t}=i.initialConfig,r=e&&(zo(e)?e:T.values(e)),n=t&&(zo(t)?t:T.values(t)),s=i.isConfiguring?n||r:i.items;return!(s!=null&&s.filter(Kx).length)}afterRecompose(){super.afterRecompose(),this.realign()}updateTextContent(i){const e=this;if(!e.isComposable){const t=!!(i&&e.hasNoChildren),{classList:r}=e.contentElement;t!==r.contains("b-text-content")&&(r[t?"add":"remove"]("b-text-content"),e.rendered&&e.realign())}}updateLayoutStyle(i){E.applyStyle(this.contentElement,i)}updateElement(i,e){if(super.updateElement(i,e),i){const{classList:t}=this.contentElement,{containerCls:r}=this.layout;t.add("b-content-element"),r&&t.add(r)}}onInternalPaint(...i){var e;(e=super.onInternalPaint)==null||e.call(this,...i),this.getConfig("contentElMutationObserver")}changeContentElMutationObserver(i,e){if(e&&(e.takeRecords(),e.disconnect()),i){const t=this,{element:r,contentElement:n}=t;i=new MutationObserver(s=>t.onContentElMutation(s)),i.observe(n,{attributes:!0}),n!==r&&i.observe(r,{attributes:!0}),t.syncFlexDirection()}return i}onContentElMutation(i){lO[this.layout.type]&&!this.textContent&&this.isVisible&&i.some(e=>this.contentElement.contains(e.target))&&this.syncFlexDirection()}changeLayout(i,e){return dr.reconfigure(e,i,{owner:this,defaults:{owner:this}})}get childItems(){return this.items}get childItemsOrderedByRelevance(){return this.items}getWidgetById(i){return this.widgetMap[i]}processWidgetConfig(i){}setupWidgetConfig(i,e){const t=this;typeof i=="string"?i={html:i}:i.nodeType===Element.ELEMENT_NODE&&(i={element:i,id:i.id}),(typeof e=="string"||!e&&(e=i.type))&&(e==="checkbox"&&Y.isMobile&&z.resolveType("slidetoggle",!0)&&(e=i.type="slidetoggle"),e=z.resolveType(e,!0)),i=(e||z).mergeConfigs(t.defaults,i,{parent:t});for(let r=i.parent;r;r=r.parent)if(r.processWidgetConfig(i)===!1)return null;return t.trigger("beforeWidgetCreate",{widgetConfig:i})===!1?null:i}createWidget(i){const e=z.create(this.setupWidgetConfig(i),this.defaultType);return e&&(e._createdBy=this),e}updateDefaults(i,e){if(!this.isConfiguring&&i){const t=Object.entries(i);this.eachWidget(r=>{t.forEach(([n,s])=>{(!e||r[n]===e[n])&&(r[n]=s)})},!1)}}render(...i){this.getConfig("lazyItems"),this.layout.renderChildren(),this.syncChildCount(),super.render(...i)}get focusElement(){const{defaultFocus:i}=this;if(typeof i=="string")return this.element.querySelector(i);let e=i&&this.query(i);return(!i||!e)&&(e=this.query(aO,!0)),e?e.focusElement:super.focusElement}doDestroy(){var i;(i=this._items)==null||i.forEach(e=>{var t;return(t=e.destroy)==null?void 0:t.call(e)}),this.layout.destroy(),super.doDestroy()}get isValid(){let i=!0;return this.eachWidget(e=>{"isValid"in e&&e.isVisibleForValidation&&!e.isValid&&(i=!1)},!0),i}clearError(){this.eachWidget(i=>{var e;return(e=i.clearError)==null?void 0:e.call(i)})}};p(ct,"$name","Container"),p(ct,"type","container"),ct.initClass(),ct._$name="Container";var{assign:Ou}=T,Xx=()=>performance.now(),cO={start:!1},uO=/^[.\d]+([^\d].*)?$/,Zx=i=>E.getExpandos(i,"transitions"),Qx=(i,e)=>{var t;return typeof i=="string"&&(e=(t=uO.exec(i))==null?void 0:t[1],i=parseFloat(i)),i&&i*(e==="s"||!e&&i<10?1e3:1)},yb=i=>{const e=T.values(Zx(i)).filter(t=>t.completed==null).map(t=>t.toString());i.style.transition=e.join(", ")},Jx=i=>class extends i{static get prototypeProperties(){return{_delay:null,_duration:null,_retain:null,_timing:null,_unit:null,owner:null,reverting:null}}constructor(...t){super(...t),this.id=++hO}start(){this.startTime=Xx()}get delay(){var t,r,n;return Qx((n=(r=this._delay)!=null?r:(t=this.owner)==null?void 0:t.delay)!=null?n:0,this.unit)}set delay(t){this._delay=t}get duration(){var t;const{owner:r,unit:n}=this;return Qx((t=this._duration)!=null?t:r?r.duration:$t.defaultDuration,n)}set duration(t){this._duration=t}get elapsed(){return Xx()-this.startTime}get remaining(){return this.duration-this.elapsed}get retain(){var t,r;return(r=this._retain)!=null?r:(t=this.owner)==null?void 0:t.retain}set retain(t){this._retain=t}get timing(){var t,r;return(r=this._timing)!=null?r:(t=this.owner)==null?void 0:t.timing}set timing(t){this._timing=t}get unit(){var t,r;return(r=this._unit)!=null?r:(t=this.owner)==null?void 0:t.unit}set unit(t){this._unit=t}},hO=0,eR=class kF extends O.mixin(Jx){static get prototypeProperties(){return{element:null,property:null,from:null,to:null,completed:null,promissory:null,reverting:null}}afterConstruct(){super.afterConstruct();const e=this,{element:t,transitions:r}=e;let{property:n}=e;[n,e.to]=E.unitize(n,e.to),e.from=E.unitize(n,e.from)[1],e.promissory=new qs,e.property=n;const s=r[n];r[n]=e;let{from:a}=e;s&&(e.from=s.to,a=null,s.destroy()),a===null&&(a=e.getCurrentStyleValue(),s||(e.from=a)),t.style[n]=a,e.getCurrentStyleValue()}doDestroy(){const e=this;e.finish(!1),e.completed&&!e.retain&&e.clearStyle(),super.doDestroy()}get promise(){var e;return(e=this.promissory)==null?void 0:e.promise}get transitions(){return Zx(this.element)}clearStyle(){this.setStyle("")}finish(e){const t=this,{transitions:r,promissory:n,property:s}=t;n&&(t.completed=e,t.promissory=null,n.resolve(e),r[s]===t?(delete r[s],e||(yb(t.element),t.clearStyle())):t.completed=!1)}getCurrentStyleValue(){return E.getStyleValue(this.element,this.property)}revert(){const{duration:e,elapsed:t,element:r,from:n,property:s,_retain:a,_timing:o}=this;return new kF({element:r,property:s,retain:a,timing:o,duration:Math.round(Math.min(e,t)),reverting:this,to:n,unit:"ms"})}setStyle(e){this.element.style[this.property]=e}start(){const e=this,{delay:t,duration:r,element:n,property:s}=e;j.onTransitionEnd({element:n,property:s,duration:t+r+20,thisObj:e.owner,handler:()=>{var a;return(a=e.finish)==null?void 0:a.call(e,!0)}}),super.start(),e.setStyle(e.to)}toString(){const{delay:e,duration:t,property:r,timing:n}=this;return`${r} ${t}ms ${n||"ease-in-out"}${e?` ${e}ms`:""}`}};p(eR,"$name","AnimatorTransition");var bb=eR;bb.initClass();var tR=class Ji extends O.mixin(Jx){static get prototypeProperties(){return{element:null,finalize:null,prefinalize:null,completed:null,items:null}}static register(e,t){if(T.isObject(e)){T.entries(e).forEach(r=>Ji.register(...r));return}Ji.fx[e]=t,Ji[e]=r=>(E.isElement(r)?r={element:r,[e]:{}}:(r={element:r.element,[e]:r},delete r[e].element),Ji.run(r))}static run(e){return new Ji(e).start()}constructor(e){var t;super(null);const r=this,n=[],s={};let a,o,l,d;if(Array.isArray(e))r.items=e;else for(l in e)(Ji.specialPropsRe.test(l)?r:s)[l]=e[l];T.keys(s).forEach(c=>{d=s[c],d!=null&&d!==!1&&d===d&&((o=Ji.fx[c])?(d=Ou(r.defaults,o(d,r,c)),d.owner=r,a=new Ji(d)):(d=Ou(r.defaults,typeof d=="object"?d:{to:d}),d.owner=r,d.property=c,a=new bb(d)),n.push(a))}),(t=r.items)==null||t.forEach(c=>{T.isInstantiated(c)?c.owner=r:(c=Ou(r.defaults,c),c.owner=r,c=new Ji(c)),n.push(c)}),r.items=n,r.promise=(n.length===1?n[0].promise:Promise.all(n.map(c=>c.promise))).then(c=>{var u;return(u=r.finish)==null||u.call(r,c),r.completed||!1})}doDestroy(){this.items.forEach(e=>e.destroy()),super.doDestroy()}get defaults(){return{element:this.element}}get retain(){const{_retain:e,finalize:t,owner:r}=this;return e!=null?e:t?!1:r?r.retain:!0}set retain(e){super.retain=e}done(){return this.promise}finish(e){var t,r;const n=this,{items:s}=n;for(yb(n.element),n.completed=typeof e=="boolean"?e:!e.some(a=>!a),(t=n.prefinalize)==null||t.call(n,n.completed,n);s.length;)s.pop().destroy();(r=n.finalize)==null||r.call(n,n.completed,n)}revert(e){var t;const r=this,{reverting:n}=r,s=!e||((t=e.start)!=null?t:!0);let a=r.defaults;return n&&(n.finalize&&(a.finalize=n.finalize),n.prefinalize&&(a.prefinalize=n.prefinalize),a.retain=n._retain),a=Ou(a,e,{items:r.items.map(o=>o.revert(cO)),reverting:r}),a=new Ji(a),s&&a.start(),a}start(){const{element:e,items:t}=this;return super.start(),t.length&&(yb(e),t.forEach(r=>r.start())),this}};p(tR,"$name","Animator");var $t=tR;$t.initClass().Transition=bb,$t.specialPropsRe=new RegExp(`^(?:${Object.keys($t.prototypeProperties).concat(Object.keys($t.superclass.prototypeProperties)).map(i=>i[0]==="_"?i.substr(1):i).join("|")})$`),$t.defaultDuration=200,$t.fx={},$t.register({puff(i){return i===!0?i={}:typeof i!="object"?i={transform:`scale(${i})`}:i.scale&&(i=T.clone(i),i.transform=`scale(${i.scale})`,delete i.scale),Ou({opacity:0,transform:"scale(8)"},i)}}),$t._$name="Animator";var om=class extends O.mixin(be){static get configurable(){return{element:null,delegate:null,delay:500,startRate:2,endRate:20,accelerateDuration:4e3,pressedCls:"b-pressed"}}doDestroy(){var i;(i=this.mousedownRemover)==null||i.call(this),this.cancel(),super.doDestroy()}cancel(){var i,e,t;const r=this;(i=r.activeElement)==null||i.classList.remove(r.pressedCls),r.activeElement=null,(e=r.acceleration)==null||e.cancel(),r.activeListenerRemover=(t=r.activeListenerRemover)==null?void 0:t.call(r),r.clearTimeout(r.autoRepeatTimer),r.clearTimeout(r.repeatTimer)}updateElement(i){var e;(e=this.mousedownRemover)==null||e.call(this),this.mousedownRemover=j.on({element:i,mousedown:"onMouseDown",thisObj:this})}onMouseDown(i){const e=this,t=e.delegate?i.target.closest(e.delegate):e.element;e.cancel(),t&&(e.activeElement=t,e.triggerEvent=i,t.classList.add(e.pressedCls),e.activeListenerRemover=j.on({mouseup:{element:document,capture:!0,handler:"onMouseUp"},mousemove:{element:t,handler:"onTargetMouseMove"},mouseleave:{element:t,handler:"onTargetMouseLeave"},mouseenter:{element:t,handler:"onTargetMouseEnter"},thisObj:e}),e.autoRepeatTimer=e.setTimeout("startAutoRepeat",e.delay))}onMouseUp(){this.cancel()}onTargetMouseLeave(){this.activeElement.classList.remove(this.pressedCls),this.clearTimeout(this.repeatTimer)}onTargetMouseEnter(i){const e=this;i.buttons?(e.activeElement.classList.add(e.pressedCls),e.triggerEvent=i,e.fireClick()):e.cancel()}onTargetMouseMove(i){this.triggerEvent=i}startAutoRepeat(){const i=this;i.interval=i.startInterval=1e3/i.startRate,i.accelerationDelta=i.startInterval-1e3/i.endRate,i.fireClick(),i.acceleration=we.animate(i.accelerateDuration,i.nextTick,i,"easeOutQuad")}nextTick(i){this.interval=this.startInterval-this.accelerationDelta*i}fireClick(){const i=this,e=new MouseEvent("click",i.triggerEvent);i.triggerEvent.target.dispatchEvent(e),i.repeatTimer=i.setTimeout(i.fireClick,i.interval)}};om._$name="ClickRepeater";var fO=/^(?:undefined|null|LEFT|RIGHT)$/,gO={TOP:"BOTTOM",RIGHT:"LEFT",BOTTOM:"TOP",LEFT:"RIGHT"},iR=i=>{const e=i==null?void 0:i.toUpperCase();return[e,e==="LEFT"||e==="RIGHT"]},lm=i=>{var e;return e=class extends(i||O){static get configurable(){return{rotate:null,invertRotate:null}}compose(){const{rotate:t}=this;return{class:{[`b-rotate-${(t||"").toLowerCase()}`]:t,"b-rotate-vertical":t}}}syncRotationToDock(t){if(fO.test(String(this.rotate))){const[r,n]=iR(t);this.rotate=n?this.invertRotate?gO[r]:r:null}}get widgetClass(){return null}},p(e,"$name","Rotatable"),e},Js=class extends z.mixin(lm){compose(){const{align:i,href:e}=this,t={tag:e!=null?"a":"button",class:{[`b-align-${i||"end"}`]:1,"b-icon":1},listeners:{click:"onInternalClick"}};return e||(t.type="button"),t}get focusElement(){return this.element}get panel(){var i,e;if((i=this.parent)!=null&&i.isPanel&&((e=this.element)!=null&&e.parentNode.matches(".b-panel-header")))return this.parent}changeAlign(i){return i}onInternalClick(i){const e=this,{handler:t,panel:r}=e,n={domEvent:i,tool:e};e.disabled||(e.trigger("click",n),e.isDestroyed||(e.trigger("action",n),!e.isDestroyed&&(r==null?void 0:r.trigger("toolClick",n))!==!1&&t&&e.callback(t,r,[i,r,e])))}onInternalKeyDown(i){(i.key.trim()||i.code)==="Enter"&&i.stopPropagation()}updateDisabled(i,e){var t;super.updateDisabled(i,e),i&&((t=this.repeat)==null||t.cancel())}changeRepeat(i,e){return e==null||e.destroy(),i&&om.new({element:this.element},i)}changeTooltip(i,e){const t=this,r=(i==null?void 0:i.html)||i;return!t.ariaLabel&&!t.text&&typeof r=="string"&&(t.ariaLabel=t.optionalL(r,t)),super.changeTooltip(i,e)}};p(Js,"$name","Tool"),p(Js,"type","tool"),p(Js,"configurable",{align:{value:null,$config:{merge:"replace"}},href:null,repeat:null,defaultBindProperty:null,role:""}),Js.initClass(),Js._$name="Tool";var mO=/right/i,pO=i=>(i.collapsed||i.collapsing)&&i.owner.expandedHeaderDock==="top"&&i.owner.collapsible.direction.match(mO)?"start":"end",$u=class extends Js.mixin(je){static get configurable(){return{autoAlign:!0,collapsed:null,collapsing:null,collapsify:!1,direction:"up",defaultBindProperty:null}}compose(){const{collapsed:i,direction:e}=this;return{"aria-label":this.L(`L{Object.${i?"expand":"collapse"}}`),class:{[`b-icon-collapse-${e}`]:1,"b-collapsed":i}}}changeAutoAlign(i){return i===!0?pO:i}syncAutoAlign(){const{autoAlign:i}=this;i&&(this.align=i(this))}updateAutoAlign(){this.syncAutoAlign()}updateCollapsed(){this.syncAutoAlign()}updateCollapsing(){this.syncAutoAlign()}updateDirection(){this.syncAutoAlign()}};p($u,"$name","CollapseTool"),p($u,"type","collapsetool"),$u.initClass(),$u._$name="CollapseTool";var rR=/^(?:UP|DOWN|LEFT|RIGHT)$/,vO=/^(left|top)$/i,yO={},nR=/^b-dock-(top|left|right|bottom)$/,Cb="b-panel-collapse-revealer",bO=/^(?:left|right)$/i,dm="b-collapse-unflex",{round:Mn}=Math,sR=["up","down","left","right"].reduce((i,e)=>(i[e.toUpperCase()]=i[e]=e,i),{}),Sb={top:["top","bottom"],right:["right","left"],bottom:["bottom","top"],left:["left","right"]},CO={hl:"LEFT",hr:"RIGHT",vb:"DOWN",vt:"UP"},SO={h:"w",w:"h"},aR={up:"top",right:"right",down:"bottom",left:"left"},cm={top:!1,right:!0,bottom:!1,left:!0},wO={top:"UP",right:"RIGHT",bottom:"DOWN",left:"LEFT"},oR={top:i=>`translate(0, -${Mn(i.height||0)}px)`,bottom:i=>`translate(0, ${Mn(i.height||0)}px)`,right:i=>`translate(${Mn(i.width||0)}px, 0)`,left:i=>`translate(-${Mn(i.width||0)}px, 0)`},DO=0,jr=class extends O.mixin(En,je){static get configurable(){return{animation:{duration:200},collapsed:{value:null,$config:null,default:!1},direction:null,collapseTooltip:"L{Object.collapse}",expandTooltip:"L{Object.expand}",panel:{value:null,$config:"nullify"},supportAxis:null,tool:{type:"collapsetool",handler(i){var e;(e=this.collapsible)==null||e.onCollapseClick(i)}}}}static get factoryable(){return{defaultType:"inline"}}get collapsing(){return this.collapsingExpanding==="collapsing"}get collapsingExpanding(){var i;const e=(i=this.currentOperation)==null?void 0:i.collapsing;return e==null?null:e?"collapsing":"expanding"}get currentDock(){var i,e,t,r;return(r=(t=(e=(i=this.panel)==null?void 0:i.header)==null?void 0:e.dock)==null?void 0:t.toLowerCase())!=null?r:"top"}get expanding(){return this.collapsingExpanding==="expanding"}get collapseTool(){var i,e;return(e=(i=this.panel)==null?void 0:i.tools)==null?void 0:e.collapse}get collapseDim(){return bO.test(this.collapseDir)?"width":"height"}getCollapseDir(i){var e;let{direction:t,panel:r}=this;if(!t||rR.test(t)){const n=r==null?void 0:r.placement;n?t=CO[n]:t=wO[((e=r==null?void 0:r.header)==null?void 0:e.dock)||"top"]}return i?sR[t]:t}get collapseDir(){return this.getCollapseDir(!0)}get collapseDock(){return this.collapseInfo[0]}get collapseInfo(){const{panel:i}=this,e=i.hasHeader&&i.expandedHeaderDock;let t=aR[this.collapseDir],r=!1;return e&&((r=cm[t]!==cm[e])||(t=e)),[t,r]}get toolsConfig(){const{direction:i,tool:e}=this;return e&&{collapse:T.assign({direction:i.toLowerCase(),tooltip:this.L(this[this.collapsed?"expandTooltip":"collapseTooltip"])},e)}}beforeCollapse(i){const{panel:e}=this,{element:t}=e;t.matches(":focus-within")&&e.revertFocus(!0)}changeTool(i){const e=this,{panel:t}=e;if(e.isConfiguring||e.isDestroying||!t||t.isDestroying)return i;t.tools={collapse:i}}collapse(i){var e,t;const r=this,{panel:n}=r,s={id:++DO,completed:!1,panel:n};let{currentOperation:a}=r;return i=i!=null?i:!0,T.isObject(i)&&(s.collapsed=!0,T.assign(s,i),i=s.collapsed,delete s.collapsed),s.collapsing=i,s.previous=a!=null?a:null,i!==r.collapsed?a?a.collapsing!==i&&(s.animation=a.animation.revert({finalize(){var o;(o=r.collapseFinalize)==null||o.call(r,s,!0)}}),s.collapsing=i,a=s):(s.animation=T.clone(("animation"in s?s:r).animation),r.beforeCollapse(s)!==!1&&(s.animation&&(s.animation.finalize=o=>{var l;return(l=r.collapseFinalize)==null?void 0:l.call(r,s,o)}),n.changingCollapse=!0,r[i?"collapseBegin":"expandBegin"](s),s.animation?a=s:(s.completed=!0,r[i?"collapseEnd":"expandEnd"](s)),n.changingCollapse=!1,s.animation||r.onComplete(i?"collapse":"expand"))):a&&a.collapsing!==i&&(r[i?"expandRevert":"collapseRevert"](s),s.animation=a.animation.revert({finalize(){var o;(o=r.collapseFinalize)==null||o.call(r,s,!1)}}),a=s),r.currentOperation=a,(t=(e=a==null?void 0:a.animation)==null?void 0:e.done())!=null?t:Promise.resolve(i===r.collapsed)}collapseFinalize(i,e){const t=this,{currentOperation:r,panel:n}=t,s=n.collapsed?"expand":"collapse";r===i&&(t.currentOperation=null,i.completed=e,n.changingCollapse=!0,t[s+"End"](i),n.changingCollapse=!1,e&&t.onComplete(s))}applyHeaderDock(i,e=!0){const t=this,{currentDock:r,panel:n}=t,{header:s}=n,a=i?t.collapseDock:n.expandedHeaderDock;a!==r&&n.hasHeader&&(n.header=s?typeof s=="string"?{title:s}:T.clone(n.header):{},n.header.dock=a,e&&n.recompose.flush())}composeHeader(i){const{panel:e}=this,{class:t}=i,r=e.expandedHeaderDock||Object.keys(t).filter(n=>t[n]&&nR.test(n)).map(n=>nR.exec(n)[1][0]);return t[Cb]=1,t[`b-collapsible-${r[0]}${this.collapseDir[0]}`]=1,i}composeTitle(i){return i.class[Cb]=1,i}collapseBegin(i){var e;const t=this,{animation:r}=i,{collapseDim:n,collapseTool:s,panel:a}=t,{element:o,placement:l}=a,[d,c]=t.collapseInfo,u=s==null?void 0:s.element.classList,h=!l||l[0]==="h"&&n==="width"||l[0]==="v"&&n==="height";t.configuredWidth=a._lastWidth,t.configuredHeight=a._lastHeight,t.transverseCollapse=c,t.applyHeaderDock(!0);const f=a.rectangle(),g=t.lockInnerSize().moveTo(0,0),m=g.clone(),v=Sb[d],y=(e=a.headerElement)==null?void 0:e.getBoundingClientRect(),b=Mn((y==null?void 0:y[n])||0);o.classList.toggle(dm,h),r?(m[v[0]]=m[v[1]],o.classList.add("b-collapsing"),u==null||u.add("b-collapsed","b-collapsing"),s&&(s.collapsing=!0,s.tooltip=void 0),u&&(u.remove("b-collapsed"),a.rectangle(),u.remove("b-collapsing"),u.add("b-collapsed")),r.element=o,r.retain=!0,r[n]={from:Mn(f[n]),to:b},r.items=[{element:t.innerElement,retain:!1,clip:{from:`rect(${g})`,to:`rect(${m})`}}],c&&r.items.push({element:a.headerElement,duration:r.duration,retain:!1,transform:{from:oR[d](y),to:"translate(0, 0)"}}),i.animation=$t.run(r)):(o.style[n]=`${b}px`,s&&(u.add("b-collapsing","b-collapsed"),s.rectangle(),u.remove("b-collapsing")))}collapseEnd(i){const e=this,{collapseTool:t,expandTooltip:r}=e;e.panel.isDestroyed||(e.panel.element.classList.remove("b-collapsing"),t&&(t.collapsing=!1,t.tooltip=this.L(r)),i.completed?e.collapsed=!0:(e.applyHeaderDock(!1),e.restoreConfiguredSize(),e.lockInnerSize(!1)))}collapseRevert(i){var e;(e=this.collapseTool)==null||e.element.classList.remove("b-collapsed")}expandBegin(i){const e=this,{animation:t}=i,{collapseDim:r,collapseTool:n,panel:s}=e,[a,o]=e.collapseInfo,{element:l}=s,d=l.classList,c=d.contains(dm),u=s.rectangle();d.remove("b-collapsed","b-collapsing"),n&&(n.tooltip=void 0),s.element.style[r]="",e.restoreConfiguredSize(),e.lockInnerSize(!1);const h=s.rectangle(),f=e.lockInnerSize().moveTo(0,0),g=f.clone(),m=Sb[e.collapseDock];n==null||n.element.classList.remove("b-collapsed"),t&&(g[m[0]]=g[m[1]],d.add("b-collapsed","b-expanding"),c&&d.add(dm),t.element=l,t[r]={from:Mn(u[r]),to:Mn(h[r])},t.items=[{element:e.innerElement,retain:!1,clip:{from:`rect(${g})`,to:`rect(${f})`}}],o&&t.items.push({element:s.headerElement,duration:t.duration,retain:!1,transform:{from:"translate(0, 0)",to:oR[a](u)}}),i.animation=$t.run(t))}expandEnd(i){const e=this,{collapseTool:t,collapseTooltip:r}=e;e.panel.element.classList.remove("b-expanding"),i.completed&&(e.collapsed=!1,t&&(t.tooltip=e.L(r)),e.applyHeaderDock(!1),e.restoreConfiguredSize(),e.lockInnerSize(!1))}expandRevert(i){var e;(e=this.collapseTool)==null||e.element.classList.add("b-collapsed")}get innerElement(){return this.panel.collapseWrapElement||this.panel.bodyWrapElement}get innerSizeElement(){return this.transverseCollapse?this.panel.element:this.innerElement}get supportAxis(){let{_supportAxis:i}=this;const e=i===!0;return(e||i==null)&&(i=this.collapseDim[0],(e||E.getStyleValue(this.panel.element,"position")==="absolute")&&(i+=SO[i])),i||""}lockInnerSize(i=!0){const e=this,{innerElement:t,panel:r}=e,n=i?e.supportAxis:"",s=r.element,a=r.headerElement,o=i&&a&&$.from(a,s),l=i&&$.from(e.innerSizeElement,s),d=t.style;return a&&(a.style.minWidth=n.includes("w")?`${o.width}px`:"",a.style.minHeight=n.includes("h")?`${o.height}px`:""),d.width=i?`${l.width}px`:"",d.height=i?`${l.height}px`:"",t.classList[i?"add":"remove"]("b-panel-collapse-size-locker"),l}onCollapseClick(i){let e=this.collapsing?!1:this.expanding?!0:!this.collapsed;i.altKey&&(e={animation:null,collapsed:e}),this.collapse(e)}onComplete(i){var e,t;(t=(e=this.panel)==null?void 0:e.trigger)==null||t.call(e,i)}onPanelHeaderClick({event:i}){i.button===0&&this.panel.collapsed&&i.target.classList.contains(Cb)&&this.onRevealerClick()}onPanelConfigChange({name:i,value:e}){const t=this,{panel:r}=t;i==="collapsed"?r.isPainted&&(t.collapsed=e):i==="header"&&!r.changingCollapse&&t.syncDirection()}onPanelPaint(){this.syncDirection(),this.panel.collapsed&&!this.collapsed&&this.collapse({animation:null,collapsed:!0})}onRevealerClick(){this.panel._collapse({collapsed:!1})}restoreConfiguredSize(i){const{configuredHeight:e,configuredWidth:t,panel:r}=this;i=i!=null?i:"wh",r.element.classList.remove(dm),t!=null&&i.includes("w")&&(r.width=t),e!=null&&i.includes("h")&&(r.height=e)}splitHeaderItems({as:i,dock:e}=yO){var t;return(t=this.panel)==null?void 0:t.splitHeaderItems({as:i,dock:e,alt:!0})}syncDirection(){const i=this,{direction:e}=i;(!e||rR.test(e))&&(i.direction=i.getCollapseDir())}changeCollapsed(i){return!!i}updateCollapsed(i){const{collapseTool:e,panel:t}=this;t&&(t.collapsed=i,t.element.classList[i?"add":"remove"]("b-collapsed")),e&&(e.collapsed=i)}updateDirection(i){const{collapseTool:e,panel:t}=this;e&&(e.direction=sR[i]),t!=null&&t.rendered&&t.recompose()}updatePanel(i){var e;const t=this;t.syncDirection(),(e=t.panelChangeDetacher)==null||e.call(t),t.panelChangeDetacher=i&&we.after(i,"onConfigChange","onPanelConfigChange",t,{return:!1})}wrapCollapser(i,e){var t;const r=this,[n,s]=r.collapseInfo;if(!s)return[i,e];const{collapseDir:a,panel:o}=r,{expandedHeaderDock:l,header:d,uiClassList:c}=o,u=(t=o.tools)==null?void 0:t.recollapse,[h,f]=r.splitHeaderItems({as:"element",dock:n}),g=o.hasHeader?o.title||(d==null?void 0:d.title)||"\xA0":null,m=g&&{tag:"header",class:new le({...c,[`b-dock-${l}`]:1,"b-panel-header":1,"b-panel-collapser-header":1},d==null?void 0:d.cls),style:d==null?void 0:d.style,children:[...h,{reference:"collapserTitleElement",html:g,class:{...c,[`b-align-${(d==null?void 0:d.titleAlign)||"start"}`]:1,"b-header-title":1}},...f]};return u&&(u.direction=a),["collapseWrapElement",{class:{...c,[`b-panel-collapser-header-${l}`]:1,[`b-panel-collapser-${a}`]:1,[`b-${cm[l]?"h":"v"}box`]:1,"b-panel-collapser":1,"b-box-center":1},children:vO.test(l)?{collapserHeaderElement:m,[i]:e}:{[i]:e,collapserHeaderElement:m}}]}};p(jr,"$name","PanelCollapser"),p(jr,"type","inline"),jr.maps={clipByDock:Sb,dockByDirection:aR,dockIsHorz:cm},jr.initClass(),jr._$name="PanelCollapser";var Bu=Symbol("pendingCreate"),ea=class extends O{static get prototypeProperties(){return{cleanup:null,configName:null,created:null,factory:null,inferType:"name",owner:null,ownerName:null,proxyable:typeof Proxy!="undefined",setup:null,transform:null}}static get properties(){return{defaults:{},instances:{},object:Object.create({})}}get proxy(){const i=this;let e=null;return i.proxyable&&(e=new Proxy(i.instances,{get(t,r){return i.get(r)},set(t,r,n){return i.set(r,n),!0},deleteProperty(t,r){return i.set(r,null),!0}})),Reflect.defineProperty(i,"proxy",{configurable:!0,value:e}),e}get target(){return this.proxy||this.object}define(i,e){const t=this,{transform:r}=t,n=r?r(e,i):e,s=T.isInstantiated(n);t.instances[i]=Bu,s||t.setDefaults(i,n),t.defineProp(i,!0),s&&t.set(i,n)}defineProp(i,e){const t=this,{object:r}=t;t.proxy||Reflect.defineProperty(e?Object.getPrototypeOf(r):r,i,{configurable:!e,enumerable:!0,get(){return t.get(i)},set(n){return t.set(i,n)}})}flush(){var i;const e=this;try{e.updating=!0;for(const t in e.defaults)e.get(t);e.afterConfigureOwner=(i=e.afterConfigureOwner)==null?void 0:i.call(e)}finally{e.updating=!1}}get(i){const{defaults:e,instances:t}=this;return t[i]===Bu&&this.set(i,Bu),t[i]||e[i]&&null}set(i,e){var t;const r=this,{cleanup:n,configName:s,defaults:a,factory:o,instances:l,owner:d,setup:c,transform:u,updating:h}=r,f=d&&s&&!h,g=l[i]===Bu?null:l[i],m=o.reconfigure(g,e===Bu?{}:e||null,{cleanup:n&&(v=>n(v,i)),defaults:a[i]||r.setDefaults(i,{}),owner:r.owner,setup:c&&((v,y,b)=>c(v,i,y,b)),transform:u&&(v=>u(v,i))});if(m!==g){const v=f&&{...l};l[i]=m,m?(r.defineProp(i),(t=r.created)==null||t.call(r,m,i)):(delete r.object[i],delete l[i]),f&&d.onConfigChange({name:s,config:d.$meta.configs[s],value:r.target,was:v})}}setDefaults(i,e){const{defaults:t,factory:r,inferType:n,instances:s,owner:a,ownerName:o}=this,{typeKey:l}=r.factoryable;return e=e===!0?{}:T.assign({},e),(n==="name"||n===!0&&!e[l])&&(e[l]=i),o&&(e[o]=a),e.beforeConfigure=d=>{s[i]=d},t[i]=e}update(i){const e=this,{owner:t}=e;let r,n;try{if(e.updating=!0,i)for(r in i)n=i[r],e.defaults[r]?e.set(r,n):n&&e.define(r,n);else for(r in e.instances)e.set(r,null)}finally{e.updating=!1}t&&(t.isConfiguring?e.afterConfigureOwner||(e.afterConfigureOwner=we.before(t,"afterConfigure","flush",e)):e.flush())}};ea.initClass(),ea._$name="DynamicObject";var EO=[],wb={},xO={align:1,weight:1},Db=i=>{var e;return e=class extends(i||z){static get configurable(){return{tools:{value:null,$config:{nullify:!0}},toolDefaults:{"*":{type:"tool",align:"end"}}}}byWeightSortFn(t,r){return(t.weight||0)-(r.weight||0)}byWeightReverseSortFn(t,r){return(r.weight||0)-(t.weight||0)}gatherTools({align:t,alt:r,refs:n}=wb){var s,a,o;const{collapsed:l,tools:d}=this,c={collapsed:l,alt:r};let u=[],h,f,g,m,v;for(f in d)v=d[f],h=(o=(a=(s=v==null?void 0:v.align)==null?void 0:s.align)!=null?a:v==null?void 0:v.align)!=null?o:"end",h===t&&v.isCollapsified(c)&&u.push(v);if(u.sort(this[t==="end"?"byWeightReverseSortFn":"byWeightSortFn"]),n){const y=n==="widget",b={};for(g=0;g<u.length;++g)m=u[g],b[m.ref]=y?m:m.element;u=b}return u}getEndTools({alt:t,refs:r}=wb){return this.gatherTools({align:"end",alt:t,refs:r})}getStartTools({alt:t,refs:r}=wb){return this.gatherTools({align:"start",alt:t,refs:r})}get childItems(){return[...this.getStartTools(),...this._items||EO,...this.getEndTools()]}changeTools(t,r){const n=this,s=n.$tools||(n.$tools=new ea({configName:"tools",factory:z,inferType:!1,owner:n,created(a){var o,l;a.innerItem=!1,(l=a.syncRotationToDock)==null||l.call(a,(o=n.header)==null?void 0:o.dock),we.after(a,"onConfigChange",(d,{name:c})=>{xO[c]&&n.onConfigChange({name:"tools",value:s.target})}),n.onChildAdd(a)},setup(a,o){return a=T.merge({},n.toolDefaults["*"],n.toolDefaults[o],a),a.parent=n,a.ref=o,a}}));if(s.update(t),!r)return s.target}get widgetClass(){}},p(e,"$name","Toolable"),e},lR=["b-hbox","b-vbox"],RO={name:"align",style:"alignItems"},TO={name:"contentAlign",style:"alignContent"},MO={name:"direction",style:"flexDirection"},IO={name:"justify",style:"justifyContent",classes:["stretch"]},_O={name:"wrap",style:"flexWrap",map:{false:"nowrap",true:"wrap",reverse:"wrap-reverse"}},In=class extends dr{get vertical(){return this.horizontal===!1}set vertical(i){return this.horizontal=!i}updateAlign(){this.syncConfigStyle(RO)}updateContentAlign(){this.syncConfigStyle(TO)}updateDirection(){this.syncConfigStyle(MO)}updateHorizontal(){var i;const e=this,t=(i=e.contentElement)==null?void 0:i.classList,r=Number(e.vertical);t?(t.remove(lR[1-r]),t.add(lR[r])):e.syncConfigLater("horizontal"),e.syncDirection()}updateJustify(){this.syncConfigStyle(IO)}updateReverse(){this.syncDirection()}updateWrap(){this.syncConfigStyle(_O)}syncDirection(){const i=this,{reverse:e}=i;i.direction=e?`${i.vertical?"column":"row"}${e?"-reverse":""}`:null}changeGap(i){return typeof i=="number"&&(i=`${i}px`),i}updateGap(i){this.syncConfigStyle({name:"gap",style:"gap"})}};p(In,"$name","Box"),p(In,"type","box"),p(In,"alias","hbox"),p(In,"configurable",{containerCls:"b-box-container",itemCls:"b-box-item",align:null,contentAlign:null,direction:null,horizontal:!0,justify:null,reverse:null,wrap:null,gap:null}),In.initClass(),In._$name="Box";var No=class extends In{};p(No,"$name","VBox"),p(No,"type","vbox"),p(No,"configurable",{horizontal:!1}),No.initClass(),No._$name="VBox";var Eb=i=>{var e;return e=class extends(i||O){static get configurable(){return{badge:null}}compose(){const{badge:t}=this;return{dataset:{badge:t},class:{"b-badge":t!=null&&t!==""}}}},p(e,"$name","Badge"),e},dR=/(?:^|\s)b-icon-/,cR=/(?:^|\s)b-fa-/,FO=["items","type","widgets","html","listeners"],uR=Symbol("defaultListener"),Ri=class extends z.mixin(Eb,lm){static get configurable(){return{icon:null,menuIcon:"b-icon-picker",pressedIcon:null,pressedCls:null,iconAlign:"start",behaviorType:"button",text:{value:null,$config:null,default:""},color:null,toggleable:void 0,pressed:!1,toggleGroup:null,supportsPressedClick:!1,supportsUnpressing:!1,ripple:{radius:75},twinForwardEvents:{item:"action"},twinSyncConfigs:null,localizableProperties:["text"],menu:{$config:["lazy","nullify"],value:null},menuDefaults:{type:"menu",autoShow:!1,autoClose:!0,floating:!0,scrollAction:"realign",align:"t0-b0"},href:null,target:null,tabIndex:null,defaultBindProperty:null,split:null,keyMap:{ArrowDown:"onArrowDown"},role:""}}construct(...i){super.construct(...i),this.ion({hide:"onInternalHide"})}get twinSyncConfigs(){const i={onAction:"onItem",onClick:"onItem"};return this.toggleable&&!this.hasConfig("menu")&&(i.pressed="checked"),i}updateElement(i,e){var t,r,n;const s=this,{constructor:a}=s,o=super.updateElement(i,e),l=s.peekConfig("menu"),d=l?l.isWidget?l.role:((r=(t=a.resolveType(l.type))==null?void 0:t.configurable)==null?void 0:r.role)||((n=a.configurable.menuDefaults)==null?void 0:n.type)||"menu":!1;return s.ariaHasPopup=d,o}compose(){const{color:i,href:e,icon:t,iconAlign:r,pressed:n,pressedIcon:s,target:a,text:o,toggleable:l,toggleGroup:d,menuIcon:c,behaviorType:u,tabIndex:h,pressedCls:f,split:g}=this,m=this.hasConfig("menu"),v=n&&s?s:t,y=typeof o=="object";return{tag:e?"a":"button",href:e,target:a,tabIndex:h,type:u,class:{[`b-icon-align-${r}`]:t,[i]:!!i,"b-pressed":n&&l,"b-text":!!o,"b-has-menu":m,"b-splitbutton":g,...n&&f?Object.fromEntries(f.split(" ").map(b=>[b,1])):{}},[l&&!m?"aria-pressed":""]:n,dataset:{group:d},listeners:{click:"onInternalClick",mousedown:"onInternalMousedown"},children:{iconElement:t!=null&&t.includes("/")?{"aria-hidden":!0,src:t,tag:"img",class:{"b-button-icon":1,"b-button-image":1}}:(t||s)&&{"aria-hidden":!0,tag:"i",class:{...le.normalize(v,"object"),"b-button-icon":1,"b-icon":dR.test(v),"b-fa":cR.test(v)}},label:o&&this.ariaLabel!==o&&{tag:"label",for:this.id,[y?"children":"text"]:y?L.asArray(o):o,class:{"b-button-custom-content":y}},menuIconElement:m&&c&&{tag:"i",class:{"b-icon":dR.test(c),"b-fa":cR.test(c),"b-button-menu-icon":1,[c]:1}}}}}onInternalHide(){var i;(i=this._menu)==null||i.hide()}get childItems(){return this._menu&&[this.menu]}onFocusOut(i){var e;super.onFocusOut(i),(e=this.menu)==null||e.hide()}get focusElement(){return this.element}changeText(i){return i==null?"":i}changeToggleable(i){return i===void 0&&(i=!!(this.toggleGroup||this.config.menu)),i}changeMenu(i,e){const t=this,{element:r}=t;return i?(i.isWidget?(i.forElement=r,i.owner=t,i.constrainTo=t.rootElement):(typeof i=="object"&&!FO.some(n=>n in i)&&(i={lazyItems:i}),i=z.reconfigure(e,i?T.merge({owner:t,constrainTo:t.rootElement,forElement:r},t.menuDefaults,i):null,t)),i.align.constrainPadding=10,t.detachListeners(uR),i.ion({name:uR,beforeShow:"onMenuBeforeShow",hide:"onMenuHide",show:"onMenuShow",thisObj:this})):e==null||e.destroy(),i}onMenuBeforeShow({source:i}){return this.trigger("beforeShowMenu",{menu:i})}onMenuShow(){this.ariaElement.setAttribute("aria-expanded",!0)}onMenuHide(){this.ariaElement.setAttribute("aria-expanded",!1),this.toggle(!1)}updateMenu(i){this.toggleable=!!i}updatePressed(i){const e=this;!e.toggleable||e.isConfiguring||(i&&E.forEachSelector(e.rootElement,`button[data-group=${e.toggleGroup}]`,t=>{t!==e.element&&(z.getById(t.id).pressed=!1)}),e.toggleMenu(e.split?!1:i),e.trigger("toggle",{pressed:i,userAction:!!e.triggeredByEvent}))}configureOverflowTwin(i){const e=this,t=super.configureOverflowTwin(i),{menu:r}=e;return t.type=z.resolveType("menuitem"),r?t.menu=e.constructor.mergeConfigs(t.menu,{type:"menu",items:r.items.map(n=>n.ensureOverflowTwin())}):e.toggleable&&(t.checked=e.pressed),t.text||(t.text=e.text||e.tooltipText),t}onInternalMousedown(i){var e;(Y.isSafari||(e=this._menu)!=null&&e.containsFocus&&this.pressed)&&i.preventDefault()}changeTooltip(i,e){const t=this,r=(i==null?void 0:i.html)||i;return!t.ariaLabel&&!t.text&&typeof r=="string"&&(t.ariaLabel=t.optionalL(r,t)),super.changeTooltip(i,e)}onArrowDown(){if(this.menu)this.toggleMenu(!0);else return!1}onInternalClick(i){var e;const t=this,r={event:i};if(!t.disabled){if(t.split&&i.target.closest(".b-button-menu-icon")){t.toggleMenu(!((e=t._menu)!=null&&e.isVisible));return}if(t.triggeredByEvent=i,t.toggleable){const n=t.toggleGroup&&t.pressed&&!t.supportsUnpressing;if(n&&!t.supportsPressedClick||(n||t.toggle(!t.pressed),t.isDestroyed))return}t.trigger("click",r),t.isDestroyed||t.trigger("action",r),t.href||(i.preventDefault(),i.stopPropagation()),t.triggeredByEvent=null}}toggle(i=!this.pressed){this.trigger("beforeToggle",{pressed:i,userAction:!!this.triggeredByEvent})!==!1&&(this.pressed=i)}toggleMenu(i){var e,t,r;if(i){const{menu:n}=this;n&&(n.owner=this,n.forElement=this.element,n.initialConfig.minWidth||(n.minWidth=this.width),n.align.minHeight=(e=n._minHeight)!=null?e:100,n.align.minWidth=(t=n._minWidth)!=null?t:100,n.show())}else(r=this._menu)==null||r.hide()}};p(Ri,"$name","Button"),p(Ri,"type","button"),Ri.initClass(),Ri._$name="Button";var hR={refs:"element"},AO=i=>i.element.style.margin="",PO=i=>i.isToolbar,fR=i=>i[0]+(i[1].minifiable?0:9e9),gR={hidden:!1,width:""},kO={...gR,flex:""},LO={flex:1,hidden:1,maxWidth:1,minWidth:1,width:1,disabled:1},OO=[{box:"hbox",clientSizeProp:"clientWidth",edgeProp:"right",flexDir:"row",horizontal:!0,max:"maxX",overflow:"overflowX",pos:"x",scrollSize:"scrollWidth",sizeProp:"width"},{box:"vbox",clientSizeProp:"clientHeight",edgeProp:"bottom",flexDir:"column",horizontal:!1,max:"maxY",overflow:"overflowY",pos:"y",scrollSize:"scrollHeight",sizeProp:"height"}],$O={delay:0,startRate:40,endRate:200,accelerateDuration:500},BO={menu:1,pressed:1},Wo=class LF extends ct.mixin(Db){static getEvictionList(e){const t=e.filter(r=>r.overflowable!=="none");return t.forEach((r,n)=>t[n]=[n,r]),t.sort((r,n)=>fR(n)-fR(r)),t}updateEnableReordering(e){var t;const r=this;e?r.dragHelper=new xi({name:"itemReorder",mode:"container",lockY:!0,dragThreshold:10,targetSelector:".b-widget",floatRootOwner:r,rtlSource:r,outerElement:r.contentElement,containers:[r.contentElement],internalListeners:{beforeDragStart:r.onBeforeDragStart,dragstart:r.onDragStart,itemMove:r.onItemMove,drop:r.onDrop,thisObj:r}}):(t=r.dragHelper)==null||t.destroy()}compose(){const e=this,{axisProps:t,dock:r}=e,n=e.getEndTools(hR),s=e.getStartTools(hR);return{class:{[`b-dock-${r}`]:1,[`b-${r}-toolbar`]:1,[`b-${t.box}`]:1},children:{...s,toolbarContent:{class:{"b-box-center":1,"b-toolbar-content":1}},...n}}}get axisProps(){return OO[this.layout.horizontal?0:1]}get contentElement(){return this.toolbarContent}get overflowMenuButton(){var e;return(e=this.tools)==null?void 0:e.overflowMenuButton}get overflowType(){const{overflow:e}=this;return typeof e=="string"?e:e==null?void 0:e.type}onChildAdd(e){var t;super.onChildAdd(e),this.processAddedLeafItem(e),(t=e.syncRotationToDock)==null||t.call(e,this.dock)}onChildRemove(e){super.onChildRemove(e),this.syncOverflowVisibility()}processAddedLeafItem(e){we.after(e,"onConfigChange",this.onLeafItemConfigChange,e),e.isContainer&&e.eachWidget(t=>this.processAddedLeafItem(t))}onInternalPaint({firstPaint:e}){var t;(t=super.onInternalPaint)==null||t.call(this,...arguments),e&&this.getConfig("overflow")}updateDock(e){var t;const r=this,{layout:n}=r,{vertical:s}=n;if(n.vertical=iR(e)[1],!r.initialItems){s!==n.vertical&&r.updateOverflow(r.overflow);for(const a of r.childItems)(t=a.syncRotationToDock)==null||t.call(a,e)}}updateOverflow(e,t){var r,n;const s=this,{axisProps:a,contentElement:o,overflowType:l}=s,{flexDir:d}=a,c=(r=s.overflowMenuButton)==null?void 0:r._menu,u={};if(c&&(e?c==null||c.removeAll():c.eachWidget(h=>{h._overflowTwinOrigin.overflowTwin=null})),t==="menu"?u.overflowMenuButton=null:t==="scroll"&&(u.overflowScrollStart=u.overflowScrollEnd=null),l==="menu")(n=s.scrollable)==null||n.destroy(),o.style.overflow=o.style.overflowX=o.style.overflowY="",u.overflowMenuButton={cls:{[`b-${d}-menu`]:1}};else if(l==="scroll"){const h=typeof e=="object"&&(e==null?void 0:e.repeat)||$O;s.scrollable={[a.overflow]:"hidden-scroll",element:o,internalListeners:{scroll:"onContentScroll",thisObj:s}},u.overflowScrollStart={repeat:h,invertRotate:!0,cls:{[`b-${d}-start-scroller`]:1}},u.overflowScrollEnd={repeat:h,invertRotate:!0,cls:{[`b-${d}-end-scroller`]:1}}}s.tools=u,l?(o.classList.add("b-overflow"),s.monitorResize=!0,s.syncOverflowVisibility()):(o.classList.remove("b-overflow"),s.monitorResize=!1)}onContentScroll(){this.syncScrollerState()}onStartScrollClick(){this.scrollable[this.axisProps.pos]-=2}onEndScrollClick(){this.scrollable[this.axisProps.pos]+=2}onInternalResize(...e){super.onInternalResize(...e),this.isPainted&&this.syncOverflowVisibility()}syncOverflowVisibility(){const e=this,{overflowType:t,contentElement:r,isVisible:n}=e,{clientSizeProp:s,edgeProp:a,sizeProp:o}=e.axisProps,{overflowMenuButton:l,overflowScrollStart:d,overflowScrollEnd:c}=e.tools,u=e.rtl&&e.layout.horizontal,h=t==="menu",f=()=>Math.ceil(r[s]+(!d||d.hidden?0:d.rectangle("outer")[o])+(!c||c.hidden?0:c.rectangle("outer")[o])),g=()=>{if(_.length===0)return 0;const F=_[_.length-1].rectangle(r);return Math.floor(u?r[s]-F.left:F[a])};let m,v,y,b,C,D,w,x,R,M,I,_;if(!(!n||!t||e.items.length===0)){if(e.inSyncOverflowVisibility=!0,l==null||l.hide(),e.eachWidget((F,A)=>{w=F.minifiable,M=F.overflowable,M=w?M||w:M,F.floating?A.down=!1:(A.down=!M,F.innerItem&&(F._toolbarOverflow&&(F.hidden=F._toolbarOverflow=!1),F._toolbarMinified&&(F.minified=F._toolbarMinified=!1),F.isVisible&&(w&&(x||(x=[])).push(F),M&&(_||(_=[])).push(F))))}),_&&(m=f(),v=g()),_&&v>m)if(h){for(;v>m&&(C=x==null?void 0:x.pop());)D=v,C._toolbarMinified=!0,C.minified=!0,v=g(),D-=v,(R||(R=[])).push([C,D]);if(v>m){l.show(),m=f(),b=LF.getEvictionList(_);for(y of b)v>m&&(C=y[1],C._toolbarOverflowWidth=C.width,C._toolbarOverflow=!0,C.hidden=!0,_.splice(_.indexOf(C),1),(I||(I=[])).push(y),v=g());if(I){for(I.sort((F,A)=>F[0]-A[0]).forEach((F,A)=>I[A]=F[1]);R!=null&&R.length;)[C,D]=R.pop(),v+D<=m&&!C._toolbarOverflow&&(v+=D,C.minified=C._toolbarMinified=!1);e.syncOverflowMenuButton(I)}else l.hide()}}else c.show(),d.show(),e.syncScrollerState();else h||(c==null||c.hide(),d==null||d.hide());e.inSyncOverflowVisibility=!1}}syncOverflowMenuButton(e){var t;const r=this,{axisProps:n,overflowMenuButton:s}=r,a={cls:"b-toolbar-overflow-menu",minWidth:280,items:[],align:{align:n.horizontal?"t100-b100":"r100-l100",axisLock:"flexible"}};for(const o of e)r.overflowItemFilter(o)&&o.addToOverflowMenu(a,r.horizontal?kO:gR,AO);if(a.items.forEach(o=>{let l=o._overflowTwinOrigin,d=l.parent.indexOfChild(l);l.parent!==r&&(d=r.indexOfChild(l.parent)+d/1e5),o.weight=d}),(t=s._menu)!=null&&t.isMenu){const o=s.menu,{toAdd:l,toRemove:d}=L.delta(a.items,o.items,!0);o.remove(d),o.add(l)}else s.menu=a}syncScrollerState(){const e=this,{axisProps:t,scrollable:r}=e,{overflowScrollStart:n,overflowScrollEnd:s}=e.tools,a=r[t.pos],o=r[t.max];n.disabled=!a,s.disabled=Math.abs(Math.ceil(a))>=Math.abs(o)}overflowItemFilter(e){const{filter:t}=this.overflow;return!!(t?t.call(this,e):E.getChildElementCount(e.element))}onLeafItemConfigChange(e,{name:t,value:r}){const n=this,s=n.up(PO),a=s.hasConfig("overflow"),{overflowTwin:o}=n;!a||s!=null&&s.inSyncOverflowVisibility||t==="hidden"&&r===n._toolbarOverflow||!LO[t]&&(n._width!=null&&!n.monitorResize||n._flex&&!String(n._flex).endsWith("auto"))||(o&&!BO[t]&&(o[t]=r),s!=null&&s.isPainted&&n.ref!=="overflowMenuButton"&&((n.isTextField||n.isSlider||n.isCheckbox)&&t==="value"&&(n.containsFocus||o!=null&&o.containsFocus)||s.syncOverflowVisibility()))}createWidget(e){e==="->"?e={type:"widget",cls:"b-toolbar-fill"}:e==="|"?e={type:"widget",cls:"b-toolbar-separator"}:typeof e=="string"&&(e={type:"widget",cls:"b-toolbar-text",html:e});const t=super.createWidget(e);return this.widgetCls&&t.element.classList.add(this.widgetCls),t}onBeforeDragStart({context:e,event:t}){const r=e.item=this.items[e.element.dataset.itemIndex];return e.oldIndex=Number.parseInt(r.element.dataset.itemIndex,10),this.trigger("beforeItemDragStart",{item:r,domEvent:t})}onDragStart({context:e,event:t}){const{item:r}=e;e.dragProxy.style.backgroundColor=globalThis.getComputedStyle(this.element).backgroundColor,this.trigger("itemDragStart",{item:r,domEvent:t})}onItemMove({context:e,event:t}){const{item:r}=e,n=Array.from(r.element.parentElement.children).indexOf(r.element);this.insert(r,n),this.trigger("itemDragMove",{item:r,domEvent:t})}onDrop({context:e,event:t}){const r=this,{item:n,valid:s}=e;r.trigger("itemDrop",{item:n,domEvent:t,valid:s})}doDestroy(){var e;(e=this.dragHelper)==null||e.destroy(),super.doDestroy()}};p(Wo,"$name","Toolbar"),p(Wo,"type","toolbar"),p(Wo,"delayable",{syncOverflowVisibility:{type:"raf",cancelOutstanding:!0}}),p(Wo,"configurable",{role:"toolbar",defaultType:"button",dock:"top",layout:{type:"box"},enableReordering:null,overflow:{$config:["lazy","nullify"],value:{type:"menu"}},toolDefaults:{overflowMenuButton:{type:"button",hidden:!0,icon:"b-icon-menu",menuIcon:null,ariaLabel:"L{Toolbar.showOverflowingItems}",defaultCls:{"b-overflow-button":1}},overflowScrollEnd:{handler:"up.onEndScrollClick",hidden:!0,ariaLabel:"L{Toolbar.scrollForMore}",defaultCls:{"b-icon-angle-right":1,"b-overflow-button":1,"b-icon":1}},overflowScrollStart:{align:"start",handler:"up.onStartScrollClick",hidden:!0,ariaLabel:"L{Toolbar.scrollForMore}",defaultCls:{"b-icon-angle-left":1,"b-overflow-button":1,"b-icon":1}}},widgetCls:null,ignoreParentReadOnly:!0}),p(Wo,"prototypeProperties",{flexRowCls:"b-hbox",flexColCls:"b-vbox"});var ta=Wo;ta.initClass(),ta._$name="Toolbar";var HO=i=>!i.classList.contains("b-focus-trap")&&!i.classList.contains("b-hidden")&&E.getFocusability(i).focusable?E.NodeFilter.FILTER_ACCEPT:E.NodeFilter.FILTER_SKIP,mR=[],VO={},xb=[mR,mR],pR=(i,e,t)=>{const{vertical:r}=i;return delete i.vertical,{...i,class:{...e,[`b-${r?"v":"h"}box`]:1,"b-box-center":1,"b-panel-bar-wrap":!t}}},Rb=(i,e,t=!1)=>{const r={vertical:t,children:i?[i]:[]};return e&&(r.tag=e),r},um=(i,e)=>{i!=null&&i.classList?i==null||i.classList.add(e):i!=null&&i.class&&(typeof i.class=="string"&&(i.class={[i.class]:1}),i.class[e]=1)},jO={dock:1,hidden:1,weight:1},cr={top:[!0,!0],bottom:[!0,!1],left:[!1,!0],right:[!1,!1]},vR={header:1,"pre-header":1},zO={top:"up",right:"right",bottom:"down",left:"left"},Tb=class Nv extends ct.mixin(qg,Db){static get configurable(){return{localizableProperties:["title"],collapsed:{value:null,$config:null,default:!1},collapsible:{value:null,$config:"nullify"},bodyCls:{$config:{merge:"classList"},value:null},bodyTag:null,bodyWrapTag:null,trapFocus:null,title:null,header:null,stateful:["collapsed"],stripDefaults:{"*":{type:"toolbar",dock:"top"},bbar:{dock:"bottom",weight:-1e3},tbar:{weight:-1e3}},strips:{value:null,$config:"nullify"},toolDefaults:{close:{weight:-1e3},collapse:{weight:-990}},footer:null,revealed:null,tbar:null,bbar:null,role:null,drawer:{$config:"lazy",value:null}}}get bodyWrapRootElement(){return this[this._bodyWrapRootName]}changeFooter(e){return e&&(e.dock==="start"?e.dock="left":e.dock==="end"&&(e.dock="right")),e}compose(){var e,t;const r=this,{collapsible:n,focusable:s,revealed:a,tools:o,role:l,floating:d}=r,c=r.composeHeader(),u=r.getPositionableItems("after",!0),h=r.getPositionableItems("before",!0),f=(c==null?void 0:c.class["b-dock-left"])||(c==null?void 0:c.class["b-dock-right"]),g=(t=(e=c==null?void 0:c.children)==null?void 0:e[0])==null?void 0:t.id;let m=r.composeBody(),v="bodyWrapElement";n&&([v,m]=n.wrapCollapser(v,m)),r._bodyWrapRootName=v;const y={role:l&&r._ariaElement==="element"?l:d?"dialog":"region",tabIndex:(d||r.peekConfig("positioned"))&&s!==!1?-1:s?0:null,class:{[`b-panel-collapsible-${n==null?void 0:n.type}`]:n,[`b-panel-collapse-${n==null?void 0:n.collapseDir}`]:n,[`b-${f?"h":"v"}box`]:1,"b-panel-collapsible":n,"b-panel-has-header":c,"b-panel-has-tools":o?1:0,"b-panel-overlay-revealed":a},children:{topFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-top-focus-trap":1}},...h,headerElement:c,[v]:m,...u,bottomFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-end-focus-trap":1}}}};return g&&(y["aria-labelledby"]=g),y}updateElement(...e){this.getConfig("drawer"),super.updateElement(...e)}updateDrawer(e){var t;let{side:r="end",inline:n}=e;const s=this,{element:a,rtl:o}=s,l=s.getRenderContext()[0]||(n?document.body:null),d=s.parent||l&&!n?"positioned":"floating";r=r==="start"?o?"right":"left":r==="end"?o?"left":"right":r,s.updateConfiguration({forElement:null,closable:!1,align:null,autoShow:!1,monitorResize:!1,centered:!1,anchor:!1,hidden:!1,draggable:!1,appendTo:l||((t=s.owner)==null?void 0:t.floatRoot)||s.floatRoot,hideMode:"collapse",trapFocus:!0,[d]:!n,collapsed:typeof e=="object"&&"collapsed"in e?e.collapsed:!0,collapsible:{...e,type:n?"inline":"overlay",direction:zO[r||"end"]}}),a.classList.add("b-drawer-panel"),a.classList.remove("b-popup"),a.style.setProperty("--b-drawer-size",E.setLength(e==null?void 0:e.size)),s.ion({thisObj:s,reveal:()=>s.trigger("show"),unreveal:()=>s.trigger("hide")})}get isVisible(){return this.drawer?!this.collapsible.collapsed||this.revealed:super.isVisible}hide(...e){const t=this;if(t.drawer){if(t.trigger("beforeHide")!==!1){const r=t.collapsible.type==="inline"?t.collapse():t.collapsible.toggleReveal(!1);return t.trigger("hide"),r}}else return super.hide(...e)}show(...e){const t=this;if(t.drawer){if(t.trigger("beforeShow")!==!1){const r=t.collapsible.type==="inline"?t.expand():t.collapsible.toggleReveal(!0);return t.afterShow(),t.focus(),r}}else return super.show(...e)}showBy(...e){return this.drawer?this.show():super.showBy(...e)}composeBody(){var e,t;const r=this,{bodyCls:n,bodyConfig:s,bodyWrapTag:a,footer:o,uiClassList:l}=r,d=T.values(r.strips,(C,D)=>!cr[D==null?void 0:D.dock]).sort(r.byWeightSortFn),c={top:null,right:null,bottom:null,left:null};let u,h,f,g,m,v,y;for(o&&(f=o.dock||"bottom",d.unshift({dock:f,element:{tag:"footer",reference:"footerElement",html:typeof o=="string"?o:o.html,class:{...l,[`b-dock-${f}`]:1,[`${o.cls||""}`]:1}}})),n&&(s[m="className"]||(m="class"),s[m]=new le(s[m]).assign(n)),g=d.length;g-- >0;)u=d[g],[v,h]=cr[u.dock],y?y.vertical!==v&&(y=Rb(pR(y,l),"",v)):y=Rb(s,a,v),y.children[h?"unshift":"push"](u.element),c[u.dock]=u;um(c.top,"b-innermost"),um(c.right,"b-innermost"),um(c.bottom,"b-innermost"),um(c.left,"b-innermost");const b=pR(y||Rb(s,a),l,!0);return b.class[`${(e=r.layout)==null?void 0:e.containerCls}-panel`]=!!((t=r.layout)!=null&&t.containerCls),b.class["b-panel-body-wrap"]=1,b.class[`b-${r.$$name.toLowerCase()}-body-wrap`]=1,b}get hasHeader(){if(this.header===!1)return!1;const{header:e,title:t,tools:r,parent:n}=this,s=this.maximizable||Object.values(r||{}).some(a=>!a.hidden);return e||!(n!=null&&n.suppressChildHeaders)&&(t||s)}get rootUiClass(){return Nv}changeHeader(e){return typeof e=="string"?{title:e}:e}composeHeader(e){var t;const r=this;if(!r.hasHeader&&!e)return;const n=r.header||{},s=n.dock||"top",[a,o]=r.splitHeaderItems({as:"element",dock:s}),l=r.$meta.hierarchy,d=r.composeTitle(n),c=new le({[`b-dock-${s}`]:1,...r.uiClassList},n.cls);let u,h;for(u=l.indexOf(Nv);u<l.length;++u)h=l[u].$$name,h!=="Grid"&&(c[`b-${h.toLowerCase()}-header`]=1);const f={...n,tag:"header",class:c,children:[...a,d,...o]};return((t=r.collapsible)==null?void 0:t.composeHeader(f))||f}composeTitle(e){var t;const r=this.title||e.title,n={reference:"titleElement",id:`${this.id}-panel-title`,"aria-live":"polite",class:{[`b-align-${e.titleAlign||"start"}`]:1,"b-header-title":1,...this.uiClassList}};if(r)if(T.isObject(r))T.merge(n,r);else{const{iconCls:s}=e;s?n.children=[{tag:"i",class:"b-panel-title-icon "+s},r]:n.html=r}return((t=this.collapsible)==null?void 0:t.composeTitle(n))||n}updateTitle(){}afterRecompose(){var e;super.afterRecompose();const t=this,{headerElement:r}=t;(e=t._headerClickDetacher)==null||e.call(t),t._headerClickDetacher=r&&j.on({element:r,click:n=>{var s;return(s=t.trigger)==null?void 0:s.call(t,"panelHeaderClick",{event:n})}})}onPanelHeaderClick(e){var t;(t=this.collapsible)==null||t.onPanelHeaderClick(e)}onInternalPaint(...e){var t;super.onInternalPaint(...e),(t=this.collapsible)==null||t.onPanelPaint(this)}splitHeaderItems({as:e,dock:t,alt:r}=VO){var n,s,a,o;const l=this,d=e==="element",{collapsed:c}=l,u=l.getEndTools({alt:r}),h=l.getStartTools({alt:r}),f=T.values(l.strips,(b,C)=>!vR[C==null?void 0:C.dock]&&C.isCollapsified({collapsed:c,alt:r}));let g=xb,m,v,y;if(f.length+u.length+h.length){for(g=[v=[...h,...f.filter(b=>b.dock==="pre-header").sort(l.byWeightSortFn)],m=[...f.filter(b=>b.dock==="header").sort(l.byWeightReverseSortFn),...u]],y=0;y<v.length;++y)t&&((s=(n=v[y]).syncRotationToDock)==null||s.call(n,t)),d&&(v[y]=v[y].element);for(y=0;y<m.length;++y)t&&((o=(a=m[y]).syncRotationToDock)==null||o.call(a,t)),d&&(m[y]=m[y].element)}return g}set bodyConfig(e){this._bodyConfig=e}get bodyConfig(){const e=this,{bodyTag:t}=e,r=T.merge({reference:"bodyElement",className:{...e.getStaticWidgetClasses(Nv,"-content"),"b-box-center":1,"b-text-content":e.textContent&&e.hasNoChildren}},e._bodyConfig);return t&&(r.tag=t),r}changeBodyCls(e){return le.from(e)}changeTbar(e){return this.getConfig("strips"),this.strips={tbar:e},this.strips.tbar}changeBbar(e){return this.getConfig("strips"),this.strips={bbar:e},this.strips.bbar}get childItems(){var e;const t=this,r=T.values(t.strips,(l,d)=>!cr[d==null?void 0:d.dock]).sort(t.byWeightSortFn),[n,s]=t.splitHeaderItems(),[a,o]=((e=t.collapsible)==null?void 0:e.splitHeaderItems())||xb;return[...n,...a,...s,...o,...r.filter(l=>cr[l.dock][1]),...t.items,...r.filter(l=>!cr[l.dock][1]).reverse()]}get childItemsOrderedByRelevance(){var e;const t=this,r=T.values(t.strips,(l,d)=>!cr[d==null?void 0:d.dock]).sort(t.byWeightSortFn),[n,s]=t.splitHeaderItems(),[a,o]=((e=t.collapsible)==null?void 0:e.splitHeaderItems())||xb;return[...t.items,...r.filter(l=>!cr[l.dock][1]).reverse(),...n,...a,...s,...o,...r.filter(l=>cr[l.dock][1])]}changeStrips(e,t){const r=this,n=r.$strips||(r.$strips=new ea({configName:"strips",factory:z,inferType:!1,owner:r,created(s){var a;const{dock:o}=s;if(!vR[o]&&!cr[o])throw new Error(`Invalid dock value "${o}"; must be: top, left, right, bottom, header, or pre-header`);we.after(s,"onConfigChange",(l,{name:d})=>{jO[d]&&r.onConfigChange({name:"strips",value:n.target})}),s.innerItem=!1,r.onChildAdd(s),s.parent=r,(a=s.layout)==null||a.renderChildren(),s.hasItems&&(r.hasItems=!0)},setup(s,a){return s=T.merge(T.clone(r.stripDefaults["*"]),r.stripDefaults[a],s),s.parent=r,s.ref=a,s},transform(s){return Array.isArray(s)&&(s={items:s}),s||null}}));if(n.update(e),!t)return n.target}get collapsing(){var e;return(e=this.collapsible)==null?void 0:e.collapsing}get collapsingExpanding(){var e;return(e=this.collapsible)==null?void 0:e.collapsingExpanding}get expanding(){var e;return(e=this.collapsible)==null?void 0:e.expanding}changeCollapsed(e){const t=this,{collapsible:r}=t;if(t.recompose.flush(),e=!!e,!r||t.changingCollapse||!t.isPainted)return e;r==null||r.collapse({animation:null,collapsed:e})}changeCollapsible(e,t){const r=this;return r.getConfig("tools"),e&&(e===!0?e={}:typeof e=="string"&&(e={[cr[e]?"direction":"type"]:e})),jr.reconfigure(t,e,{owner:r,defaults:{panel:r},cleanup(){r.collapsed&&!e&&(t.collapse({animation:null,collapsed:!1}),r._collapsed=1)}})}updateCollapsible(e){const t=this,r=e==null?void 0:e.toolsConfig;t.tools={collapse:(r==null?void 0:r.collapse)||null,recollapse:(r==null?void 0:r.recollapse)||null},e&&t.isPainted&&t.collapsed&&(t._collapsed=1),t.collapsed===1&&(t.collapsed=!0)}_collapse(e,t){var r;return t!==!0&&t!==void 0&&(t===!1?e.collapsed=!e.collapsed:typeof t=="number"?e.animation={duration:t}:t===null?e.animation=t:t===!0||("animation"in t?T.merge(e,t):e.animation=t)),(r=this.collapsible)==null?void 0:r.collapse(e)}collapse(e){return this.collapsePanel(e)}expand(e){return this.expandPanel(e)}collapsePanel(e){return this._collapse({collapsed:!0},e)}expandPanel(e){return this._collapse({collapsed:!1},e)}toggleCollapsed(e,t){return typeof e=="boolean"?e?this.collapse(t):this.expand(t):this.collapsed?this.expand(t):this.collapse(t)}get expandedHeaderDock(){var e,t,r;return(r=(t=this._expandedHeaderDock)!=null?t:(e=this.initialConfig.header)==null?void 0:e.dock)!=null?r:"top"}set expandedHeaderDock(e){this._expandedHeaderDock=e==null?void 0:e.toLowerCase()}updateHeader(e){this.changingCollapse||(this.expandedHeaderDock=e==null?void 0:e.dock)}updateTrapFocus(e){var t;const r=this,{element:n}=r,{classList:s}=n,a=e==="before",o=e==="after";s.toggle("b-focus-trapped",e&&!a&&!o),s.toggle("b-focus-trapped-before",a),s.toggle("b-focus-trapped-after",o),r.focusTrapListener=(t=r.focusTrapListener)==null?void 0:t.call(r),r[e?"addKeyBinding":"removeKeyBinding"]("shift+Tab","trapTabOut"),e&&(r.focusTrapListener=j.on({element:n,focusin:"onFocusTrapped",delegate:".b-focus-trap",thisObj:r}),r.treeWalker||(r.treeWalker=r.setupTreeWalker(n,E.NodeFilter.SHOW_ELEMENT,HO)))}setupTreeWalker(e,t,r){return document.createTreeWalker(e,t,r)}trapTabOut(e){if(e.target===this.element)e.preventDefault(),this.bottomFocusTrap.focus();else return!1}onFocusTrapped(e){const t=this,{target:r}=e,n=t.treeWalker,s=r===t.bottomFocusTrap,a=r===t.topFocusTrap;t.trigger("focusTrap",{target:r,bottom:s,top:a})!==!1&&(a||s)&&(s||e.relatedTarget===t.element&&e.shiftKey?(n.currentNode=t.topFocusTrap,n.nextNode()):(n.currentNode=t.bottomFocusTrap,n.previousNode()),t.requestAnimationFrame(()=>n.currentNode.focus()))}get focusElement(){return this.hasItems&&(super.focusElement||this.element)}get contentElement(){return this.element&&this.bodyElement}getPositionableLocation(e){let t,r;return e==="before"?r=this.headerElement||this.bodyWrapRootElement:e==="after"?r=this.bottomFocusTrap:t=this.contentElement,[t,r]}get widgetClassList(){var e;const t=this,r=super.widgetClassList;return t.hasHeader&&r.push("b-panel-has-header",`b-header-dock-${((e=t.header)==null?void 0:e.dock)||"top"}`),t.tbar&&r.push("b-panel-has-top-toolbar"),t.bbar&&r.push("b-panel-has-bottom-toolbar"),r}};p(Tb,"$name","Panel"),p(Tb,"type","panel");var Rt=Tb;Rt.initClass(),Rt._$name="Panel";var NO={topStart:"top-start",topEnd:"top-end",bottomEnd:"bottom-end",bottomStart:"bottom-start",top:"top",end:"end",bottom:"bottom",start:"start"},hm=class extends O.mixin(Ie){construct(i){if(super.construct(i),!this.element)throw new Error("ElementResizeHelper: `element` is required.")}updateElement(i){var e;globalThis.getComputedStyle(i).position==="static"&&console.warn("ElementResizeHelper: `element` must be positioned (absolute or relative) for resizing to work."),(e=this.pointerDownListeners)==null||e.call(this),this.pointerDownListeners=j.on({element:i,pointerdown:"onResizePointerDown",delegate:".b-resize-grip",thisObj:this})}updateHandles(i){const{element:e}=this;E.removeEachSelector(e,".b-resize-grip");for(const t in i)if(i[t]!==!1){const r=document.createElement("div");r.className=`b-resize-grip b-resize-grip-${NO[t]}`,e.appendChild(r)}}onResizePointerDown(i){var e;const t=this,{element:r}=t;if(t.handleType=i.target.className.replace("b-resize-grip b-resize-grip-","").trim(),i.button!==0||t.trigger("beforeResizeStart",{element:r,handle:t.handleType})===!1)return;i.preventDefault();const n=globalThis.getComputedStyle(r),s=r.getBoundingClientRect(),a=parseFloat(n.top)||0,o=parseFloat(n.insetInlineStart)||0;t.initialX=i.clientX,t.initialY=i.clientY,t.initialTop=a,t.initialStart=o,t.initialWidth=s.width,t.initialHeight=s.height,t.trigger("resizeStart",{element:r,handle:t.handleType}),(e=t.removeMoveListeners)==null||e.call(t),t.removeMoveListeners=j.on({element:document.body,pointermove:"onResizePointerMove",thisObj:t}),t.removeDocUpListeners=j.on({element:document,pointerup:"onResizePointerUp",capture:!0,thisObj:t,once:!0})}onResizePointerMove(i){const e=this,{element:t,handleType:r,rtl:n,minHeight:s,minWidth:a,initialStart:o,initialTop:l,initialWidth:d,initialHeight:c,initialX:u,initialY:h,maxWidth:f,maxHeight:g}=e,m=i.clientX-u,v=i.clientY-h,y=d-(a||1),b=n?-1:1,{shiftKey:C}=i;let D=o,w=l,x=d,R=c;if(r.includes("start")?(D=o+Math.min(m,y)*b,x=d-m*b):r.includes("end")&&(x=d+m*b),r.includes("top")?(w=l+Math.min(v,c-(s||1)),R=c-v):r.includes("bottom")&&(R=c+v),C){const M=d/c;Math.abs(m)>Math.abs(v)?R=x/M:x=R*M}a!==null&&(x=Math.max(x,a)),f!==null&&(x=Math.min(x,f||document.body.offsetWidth)),s!==null&&(R=Math.max(R,s)),g!==null&&(R=Math.min(R,g||document.body.offsetWidth)),(!n||!r.includes("start")||x>a)&&(t.style.insetInlineStart=Math.max(D,0)+"px"),t.style.top=w+"px",t.style.width=x+"px",t.style.height=R+"px"}onResizePointerUp(i){var e,t;(e=this.removeDocUpListeners)==null||e.call(this),(t=this.removeMoveListeners)==null||t.call(this),this.removeMoveListeners=null,this.removeDocUpListeners=null}get isResizing(){return!!this.removeMoveListeners}doDestroy(){this.onResizePointerUp(),this.pointerDownListeners(),E.removeEachSelector(this.element,".b-resize-grip"),super.doDestroy()}};p(hm,"configurable",{element:null,minWidth:50,maxWidth:null,minHeight:50,maxHeight:null,rtl:null,handles:{topStart:!0,top:!0,topEnd:!0,end:!0,bottomEnd:!0,bottom:!0,bottomStart:!0,start:!0}}),hm._$name="ElementResizeHelper";var yR=i=>{var e;return e=class extends(i||O){updateResizable(t){var r;const n=this;if(t){const s=typeof t=="object"?t:{};n.resizeHelper=new hm(T.assign({element:n.element,internalListeners:{resizeStart:n.onResizeStart,thisObj:n}},s))}else(r=n.resizeHelper)==null||r.destroy()}onResizeStart(){this.alignTo(null)}doDestroy(){var t;(t=this.resizeHelper)==null||t.destroy(),super.doDestroy()}updateRtl(t){super.updateRtl(t),this.resizeHelper&&(this.resizeHelper.rtl=t)}},p(e,"$name","Resizable"),p(e,"configurable",{resizable:null}),e},fm=class As extends Rt.mixin(yR){finalizeInit(){const e=this,{forElement:t}=e;e.anchoredTo=t,e.initialAnchor=e.anchor,t&&e.showOnClick!==!1&&(e.initialConfig.autoShow||(e.autoShow=!1),j.on({element:t,[e.showOnClick===2?"contextmenu":"click"]:"onElementUserAction",thisObj:e,capture:!0})),super.finalizeInit(),e.autoShow&&(!t||E.isVisible(t))&&(e.autoShow===!0?e.show():e.setTimeout(()=>e.show(),e.autoShow))}onInternalPaint({firstPaint:e}){var t;(t=super.onInternalPaint)==null||t.call(this,...arguments);const r=this;e&&r.headerElement&&j.on({element:r.headerElement,dblclick:r.onHeaderDblClick,thisObj:r})}doDestroy(){this.syncModalMask(),super.doDestroy()}compose(){const{hasNoChildren:e,textContent:t}=this;return{class:{"b-text-popup":!!(t&&e)}}}close(){if(!this._hidden){const e=this.trigger("beforeClose");if(T.isPromise(e))return e.then(t=>{t!==!1&&this.doClose()}),e;if(e===!1)return e}this.doClose()}doClose(){var e,t;const r=this,{closeAction:n}=r;if(!r._hidden||n==="destroy"){r.modal&&n==="destroy"&&r.revertFocus(),r.unmask();const s=r.items.length&&((e=r.items.find(a=>a.errorTip))==null?void 0:e.errorTip);return s&&((t=s.pointerOverOutDetacher)==null||t.call(s),s.hide()),r[n]()}}toggleMaximized(){this.maximized=!this.maximized}updateMaximized(e){e=!!e,this.element.classList.toggle("b-maximized",!!e),this.draggable&&(this.draggable.disabled=e)}onInternalKeyDown(e){const t=this;e.key==="Escape"&&t.closeOnEscape&&(e.stopImmediatePropagation(),t.floating||t.positioned?t.close(!0):t.collapsible&&(t.revealed?t.collapsible.toggleReveal():t.collapse()))}onDocumentMouseDown({event:e}){const t=this,{owner:r}=t,{target:n}=e;if(t.isVisible){if(e.type!=="touchend"&&(r!=null&&r.isButton)&&r._menu===t&&r.element.contains(n))return e.preventDefault(),!1;if(t.modal&&n===As.modalMask)e.preventDefault(),t.modal.closeOnMaskTap?t.close():t.containsFocus||t.focus();else if(!t.owns(n,!0)&&t.autoClose&&e.type==="mousedown")if(t.containsFocus){const s=E.getActiveElement(t.element),a=s&&As.fromElement(s,"widget");if(a!=null&&a.owns(n,!0))return;j.on({element:document,once:!0,expires:100,[e.type]:o=>{o.defaultPrevented&&E.getActiveElement(t.element)===s&&t.close()}})}else t.close()}}get isTopModal(){return!this._isRevertingFocus&&E.isVisible(As.modalMask)&&this.element.previousElementSibling===As.modalMask}onFocusIn(e){const t=E.getActiveElement(this);super.onFocusIn(e),E.getActiveElement(this)===t&&e.target===this.element&&this.focus()}onFocusOut(e){!(globalThis.visualViewport&&globalThis.visualViewport.height<document.documentElement.clientHeight-1)&&!this.modal&&this.autoClose&&this.close(),super.onFocusOut(e)}afterShow(...e){const t=this;(t.autoClose||t.modal)&&t.addDocumentMouseDownListener(),super.afterShow(...e),t.toFront()}toFront(){this.floating&&(super.toFront(),this.syncModalMask()),this.focusOnToFront&&!this.containsFocus&&this.focus()}addDocumentMouseDownListener(){this.mouseDownRemover||(this.mouseDownRemover=ce.ion({globaltap:"onDocumentMouseDown",thisObj:this}))}updateModal(e){const t=this;e?(t.element.setAttribute("aria-modal",!0),t.floating=!0,typeof t._x!="number"&&typeof t._y!="number"&&!t.hasConfig("centered")&&(t.centered=!0,t.anchor=!1)):t.element.removeAttribute("aria-modal")}syncModalMask(){const e=this,{modal:t,element:r}=e;if(t&&e.isVisible)e.modalMask.classList.remove("b-hide-display"),e.modalMask.classList.toggle("b-modal-transparent",!!t.transparent),r.classList.add("b-modal"),e.modalMask.setAttribute("owned-by",e.id);else if(e.isPainted){r.classList.remove("b-modal");const n=e.floatRoot.querySelectorAll(".b-modal"),s=n.length?As.fromElement(n[n.length-1],"popup"):null;s?s.syncModalMask():As.modalMask.classList.add("b-hide-display")}}afterHide(...e){var t;const r=this;super.afterHide(...e),(t=r.mouseDownRemover)==null||t.call(r),r.mouseDownRemover=null,r.syncModalMask()}onElementUserAction(e){const{showOnClick:t}=this;(typeof t!="number"||t===e.button)&&(e.button===2&&e.preventDefault(),this.show())}onHeaderDblClick(){this.maximizable&&this.toggleMaximized()}updateClosable(e){this.tools.close.hidden=!e}updateMaximizable(e){this.tools.maximize.hidden=!e}get modalMask(){const{modalMask:e}=As;return e.nextElementSibling!==this.element&&this.floatRoot.insertBefore(e,this.element),e}static get modalMask(){return this._modalMask||(this._modalMask=E.createElement({className:"b-modal-mask b-hide-display"}),j.on({element:this._modalMask,wheel:e=>e.preventDefault()})),this._modalMask}};p(fm,"$name","Popup"),p(fm,"type","popup"),p(fm,"configurable",{autoShow:!0,autoClose:!0,showOnClick:!1,forElement:null,monitorResize:!0,floating:!0,hidden:!0,axisLock:!0,draggable:!0,draggableBlacklistSelector:"button,.b-field-inner,.b-gridbase,.b-calendarmixin,.b-resize-grip,input",hideAnimation:{opacity:{from:1,to:0,duration:".3s",delay:"0s"}},showAnimation:{opacity:{from:0,to:1,duration:".4s",delay:"0s"}},stripDefaults:{bbar:{layout:{justify:"flex-end"}}},testConfig:{hideAnimation:null,showAnimation:null},closeAction:"hide",trapFocus:!0,focusOnToFront:!0,closable:null,maximizable:null,modal:null,maximized:null,tools:{close:{cls:"b-popup-close",handler:"close",weight:-1e3,ariaLabel:"L{Popup.close}",hidden:!0},maximize:{cls:"b-popup-expand",handler:"toggleMaximized",weight:-999,ariaLabel:"L{Popup.maximize}",hidden:!0}},highlightReturnedFocus:!0,role:"dialog",closeOnEscape:!0});var Tt=fm;Tt.initClass(),Tt._$name="Popup";var WO=/^b-icon-/,UO=/^b-fa-/,ia=class extends z{static get configurable(){return{checked:null,separator:null,toggleGroup:null,menu:{value:null,$config:["lazy","nullify"]},menuDefaults:{type:"menu",align:"s0-e0",anchor:!0,autoClose:!0,floating:!0,autoShow:!1,cls:{"b-sub-menu":1}},icon:null,text:null,closeParent:null,href:null,radio:null,target:null,localizableProperties:["text"],role:"menuitem",openMenuDelay:120}}updateElement(i,e){const t=this,r=super.updateElement(i,e);return typeof t.checked=="boolean"?t.role="menuitemcheckbox":t.href&&(t.role=null),t.ariaHasPopup=t.hasMenu?"menu":!1,r}compose(){var i;const e=this,{checked:t,href:r,hasMenu:n,radio:s,separator:a,target:o,text:l}=e,d=typeof t=="boolean",c=e.icon||(d?"b-fw-icon":""),u=`b-icon-${s?"radio-":""}`,h=typeof l=="object";return{tag:r?"a":"div",tabIndex:-1,href:r,target:o,class:{"b-has-submenu":n,"b-checked":t,"b-separator":a||((i=e.cls)==null?void 0:i["b-separator"])},dataset:{group:e.toggleGroup},[d?"aria-checked":""]:t,[n?"aria-expanded":""]:!1,children:{iconElement:c&&{"aria-hidden":!0,tag:"i",class:{"b-fa":UO.test(c),"b-icon":WO.test(c),"b-menuitem-icon":1,[`${u}checked`]:t===!0,[`${u}unchecked`]:t===!1,...le.normalize(c,"object")}},textElement:{tag:"span",[h?void 0:"text"]:h?void 0:l,class:{"b-menu-text":1,"b-menu-custom-content":h},children:h?L.asArray(l):null},subMenuIcon:n&&{"aria-hidden":!0,tag:"i",class:{"b-fw-icon":1,"b-icon-sub-menu":1}}}}}doAction(i){const e=this,t=this.parent,r={menu:t,item:e,element:e.element,bubbles:!0,domEvent:i};if(typeof e.checked=="boolean"){const n=!e.checked;(!e.toggleGroup||n)&&(e.checked=!e.checked)}else e.href&&i.key&&e.element.click();e.trigger("beforeItem",r),e.trigger("item",r),e.closeParent&&t&&(t.rootMenu.close(),i&&!e.href&&i.preventDefault())}get focusElement(){return this.element}get contentElement(){return this.textElement}get isFocusable(){const{focusElement:i}=this;return i&&this.isVisible&&(i===document.body||i.offsetParent)}get hasMenu(){return this.hasConfig("menu")}get childItems(){const{_menu:i}=this;return i?[i]:[]}get radio(){var i;return!!((i=this._radio)!=null?i:this.toggleGroup)}onFocusIn(i){const{menu:e}=this;super.onFocusIn(i),!this.disabled&&e&&(e.clearTimeout(e.closeTimer),this.delay("openMenu",e.closeTimer?0:this.openMenuDelay),e.closeTimer=null)}onFocusOut(i){var e;const t=this;t.clearTimeout("openMenu"),super.onFocusOut(i);const r=t._menu;r&&!((e=t.owner)!=null&&e.ignoreFocusOut)&&(E.usingKeyboard?t.closeMenu():(r.clearTimeout(r.closeTimer),r.closeTimer=r.setTimeout(()=>t.closeMenu(),r.closeMenuDelay),r.once("hide",()=>r.clearTimeout(r.closeTimer))))}openMenu(i){const{menu:e,parent:t}=this;!this.disabled&&e&&(e.focusOnToFront=i,t.isMenu?t.openSubMenu(this.element,this):e.show())}onChildShow(i){super.onChildShow(i),this.ariaElement.setAttribute("aria-expanded",!0)}closeMenu(){this._menu.isWidget&&this.menu.close(),this.menu.closeTimer=null}onChildHide(i){super.onChildHide(i),this.ariaElement.setAttribute("aria-expanded",!1)}changeToggleGroup(i){return i&&typeof this.checked!="boolean"&&(this.checked=!1),i}changeChecked(i,e){if(this.isConfiguring||typeof e=="boolean")return!!i}updateChecked(i){const e=this;e.isConfiguring||(e.toggleGroup&&e.uncheckToggleGroupMembers(),e.element.setAttribute("aria-checked",i),e.trigger("toggle",{menu:e.owner,item:e,element:e.element,bubbles:!0,checked:i}))}getToggleGroupMembers(){const i=this,{checked:e,toggleGroup:t,element:r}=i,n=[];return e&&t&&E.forEachSelector(i.rootElement,`[data-group=${t}]`,s=>{if(s!==r){const a=z.fromElement(s);a&&n.push(a)}}),n}uncheckToggleGroupMembers(){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach(i=>i.checked=!1)}get closeParent(){return(typeof this.checked=="boolean"?this._closeParent:this._closeParent!==!1)&&!this.hasMenu}changeMenu(i,e){const t=this,{constrainTo:r,scrollAction:n,focusOnHover:s}=t.owner;return i&&typeof i=="object"&&(!("type"in i)||i.type==="menu")&&!("items"in i)&&!("widgets"in i)&&!("html"in i)&&(i={lazyItems:i}),ur.reconfigure(e,i?ur.mergeConfigs(t.menuDefaults,{owner:t,forElement:t.element,ariaLabel:t.text,[e?"positioned":"_"]:!1,focusOnHover:s,constrainTo:r,scrollAction:n},i):null,t)}};p(ia,"$name","MenuItem"),p(ia,"type","menuitem"),ia.initClass(),ia._$name="MenuItem";var GO={ArrowUp:1,ArrowDown:1,ArrowRight:1,ArrowLeft:1,Enter:1,Escape:1},ur=class extends Tt{construct(i){Array.isArray(i)&&(i={lazyItems:i}),super.construct(i),j.on({element:this.element,click:"onMouseClick",mouseover:"onMouseOver",mouseenter:"onMouseEnter",mouseleave:"onMouseLeave",thisObj:this})}afterShow(...i){const{items:e,element:t}=this;e.some(s=>s.hasConfig("menu"))&&t.classList.add("b-menu-with-submenu"),e.some(s=>s.icon)&&t.classList.add("b-menu-with-icon"),super.afterShow(...i)}createWidget(i){return typeof i=="string"&&(i={text:i}),super.createWidget(i)}get focusElement(){var i;const e=this,t=(i=e.parentMenu)==null?void 0:i.element.contains(E.getActiveElement(e.parentMenu)),r=e.items[0];return t||E.usingKeyboard||!(r instanceof ia)?super.focusElement:e.element}onDocumentMouseDown({event:i}){if(!this.parentMenu||!this.parentMenu.owns(i.target))return super.onDocumentMouseDown(...arguments)}hide(i){var e,t;const r=this,n=super.hide(i);return r.isVisible||((t=(e=r.currentSubMenu)==null?void 0:e.hide)==null||t.call(e,i),r.parentMenu&&(r.parentMenu.currentSubMenu=null)),n}show(...i){const e=super.show(...i),{parentMenu:t}=this;return this.isVisible&&t&&(t.currentSubMenu=this),e}onMouseClick(i){const e=i.target.closest(".b-menuitem");e&&this.triggerElement(e,i)}onMouseOver(i){var e;if(this.focusOnHover!==!1){const t=(e=i.relatedTarget)==null?void 0:e.closest(".b-widget"),r=i.target.closest(".b-widget"),n=z.fromElement(r);!E.isTouchEvent&&r&&r!==t&&n.parent===this&&this.setTimeout({fn:"handleMouseOver",delay:30,args:[n],cancelOutstanding:!0})}}handleMouseOver(i){i.focus()}onMouseEnter(){this.clearTimeout(this.closeTimer);const{parentMenu:i}=this;i&&(i.ignoreFocusOut=!0,i.setTimeout(()=>i.ignoreFocusOut=!1,500),i.clearTimeout(i.hideSubMenuTimer))}onMouseLeave(i){const e=this,{relatedTarget:t}=i,r=t&&e.owns(t);let n=t instanceof HTMLElement&&z.fromElement(t),s=!r&&e.focusOnHover!==!1;if(n){for(;n.ownerCmp;)n=n.ownerCmp;s&=!E.getAncestor(n.element,[i.target])}!r&&s&&(e.currentSubMenu&&(e.hideSubMenuTimer=e.setTimeout(()=>{var a;return(a=e.currentSubMenu)==null?void 0:a.hide()},e.closeMenuDelay)),e.element.contains(E.getActiveElement(e))&&E.getActiveElement(e).matches(".b-menuitem")&&e.focusElement.focus())}onInternalKeyDown(i){const e=z.fromElement(i),t=e&&e!==this&&!(e instanceof ia);if(i.key==="Escape"){(t?this:this.rootMenu).close();return}if(super.onInternalKeyDown(i),t)return;GO[i.key]&&i.preventDefault();const r=this.element,n=E.getActiveElement(r);this.navigateFrom(n!==r&&r.contains(n)?n:null,i.key,i)}navigateFrom(i,e,t){var r,n;const s=this,{treeWalker:a}=s,o=i&&s.getItem(i),l=s.rtl?"ArrowLeft":"ArrowRight",d=s.rtl?"ArrowRight":"ArrowLeft";let c;switch(e){case"ArrowUp":a.currentNode=i||(i=s.bottomFocusTrap),a.previousNode(),c=a.currentNode,(r=o==null?void 0:o.menu)==null||r.hide(!1);break;case"ArrowDown":a.currentNode=i||(i=s.topFocusTrap),a.nextNode(),c=a.currentNode,(n=o==null?void 0:o.menu)==null||n.hide(!1);break;case" ":i&&!i.classList.contains("b-disabled")&&(o!=null&&o.menu?s.openSubMenu(i,o):s.triggerElement(i,t));break;case l:if(i&&(o!=null&&o.menu)&&!i.classList.contains("b-disabled")){const u=s.openSubMenu(i,o);u==null||u.focus()}else a.currentNode=i||(i=s.topFocusTrap),a.nextNode(),c=a.currentNode;break;case d:s.isSubMenu?s.hide():i||(a.currentNode=i||(i=s.topFocusTrap),a.nextNode(),c=a.currentNode);break;case"Enter":i&&!i.classList.contains("b-disabled")&&s.triggerElement(i,t);break}c&&(c===s.element?s.navigateFrom(s.bottomFocusTrap,"ArrowUp",t):c===i?s.navigateFrom(s.topFocusTrap,"ArrowDown",t):c.focus())}getItem(i){if(i!=null)return typeof i=="number"?this.items[i]:i.nodeType===Element.ELEMENT_NODE?z.fromElement(i,"menuitem",this.contentElement):this.items.find(e=>e.id==i)}triggerElement(i,e){const t=this.getItem(i);t&&!t.disabled&&t.doAction(e)}get isSubMenu(){var i;return this===((i=this.owner)==null?void 0:i.menu)}openSubMenu(i,e){var t;const r=this,n=e.menu;if(n){if(!n.isVisible){const s={item:e,element:i};if(r.trigger("beforeSubMenu",s)===!1||((t=e.onBeforeSubMenu)==null?void 0:t.call(e,s))===!1)return;n.show(),n.isVisible&&!n.isMenu&&(r.currentSubMenu=n)}return n}}set selectedElement(i){const e=this,t=e._selectedElement;if(t){const r=e.getItem(t),n=r==null?void 0:r.menu;n==null||n.hide(),t.classList.remove("b-active")}if(e._selectedElement=i,i){const r=E.isFocusable(i);i.classList.add("b-active"),e.scrollable.scrollIntoView(i,{animate:!r,focus:r})}}get selectedElement(){return this._selectedElement}selectFirst(){const i=this.treeWalker;i.currentNode=this.topFocusTrap,i.nextNode(),this.requestAnimationFrame(()=>i.currentNode.focus())}get parentMenu(){var i;const e=this.owner;return e&&(e.isMenu?e:(i=e.up)==null?void 0:i.call(e,"menu"))}get rootMenu(){let i=this;for(;i.parentMenu instanceof this.constructor;)i=i.parentMenu;return i}};p(ur,"$name","Menu"),p(ur,"type","menu"),p(ur,"configurable",{layout:"vbox",focusable:!0,draggable:!1,showAnimation:null,hideAnimation:{opacity:{from:1,to:0,duration:".15s",delay:"0s"}},align:{align:"t-b"},scrollAction:"hide",focusOnHover:null,scrollable:!1,defaultType:"menuitem",tools:{close:!1},role:"menu",closeMenuDelay:200,testConfig:{hideAnimation:null,closeMenuDelay:1}}),ur.initClass(),ur._$name="Menu";var gm,_n=class extends ie{static get configurable(){return{type:null,menu:{$config:["lazy","nullify"],value:{type:"menu",autoShow:!1,closeAction:"hide",constrainTo:globalThis,scrollAction:null}},items:{},triggerEvent:null,clickTriggerSelector:null,preventNativeMenu:null,keyMap:{" ":{handler:"showContextMenuByKey",weight:100},"Ctrl+Space":"showContextMenuByKey"}}}static get pluginConfig(){return{assign:["showContextMenu"],chain:["onElementContextMenu","onElementClick","onElementDblClick"]}}construct(...i){var e;if(super.construct(...i),!((e=this.type)!=null&&e.length))throw new Error("Config 'type' is required to be specified for context menu")}onElementContextMenu(i){this.onElementEvent(i)}onElementClick(i){this.onElementEvent(i)}onElementDblClick(i){this.onElementEvent(i)}onElementEvent(i){if(!i.handled&&this.triggerEvent===i.type){if(i.ctrlKey===!0&&!Y.isMac){i.preventDefault();return}const e=i;if(gm){const{target:t}=gm;i=j.fixEvent(new MouseEvent(i.type,i)),Object.defineProperties(i,{target:{value:t},offsetX:{value:e.offsetX},offsetY:{value:e.offsetY}}),i.preventDefault=function(){e.preventDefault(),e.handled=!0}}this.internalShowContextMenu(i)}else i.type==="click"&&this.clickTriggerSelector&&i.target.matches(this.clickTriggerSelector)&&this.internalShowContextMenu(i,{align:"l-r",target:i.target})}showContextMenuByKey(i){if(!E.isEditable(i.target)){const{target:e}=i;if(e)return gm=i,E.triggerMouseEvent(e,this.triggerEvent),i.handled=!0,i.preventDefault(),i.stopImmediatePropagation(),gm=null,!0}return!1}internalShowContextMenu(i,e){const t=this;let r;t.disabled||!i.handled&&!i.defaultPrevented&&(r=t.getDataFromEvent(i))&&t.shouldShowMenu(r)&&(i.type==="contextmenu"&&Y.isSafari&&!i.ctrlKey&&i.metaKey&&j.on({element:i.target,capture:!0,once:!0,thisObj:this,click(n){n.preventDefault(),n.stopImmediatePropagation()}}),r.domEvent=i,t.showContextMenu(r,e))}getDataFromEvent(i){return{feature:this,event:i,targetElement:this.getTargetElementFromEvent(i)}}getTargetElementFromEvent(i){return i.target}async showContextMenu(i,e){var t,r,n;const s=this,a=E.isDOMEvent(i),o=a?s.getDataFromEvent(i):i,l=a?i:o.domEvent,d=(t=E.isInView(o.targetElement))==null?void 0:t.center;if((r=s._menu)==null||r.hide(),s.disabled||!d)return;s.menuContext=o;const{type:c,client:u,processItems:h}=s;if(X.assign(o,{point:l!=null&&l.clientX?[l.clientX+1,l.clientY+1]:[d.x,d.y],menu:s,items:{},selection:u.selectedRecords}),s.callChainablePopulateMenuMethod(o),X.merge(o.items,s.baseItems),s.preventNativeMenu&&s.preventDefaultEvent(o),(!h||await s.callback(h,u,[o])!==!1)&&s.hasActiveMenuItems(o)&&(s.populateItemsWithData(o),s.beforeContextMenuShow(o)!==!1)){const{menu:f}=s,{featureItems:g}=f,{items:m}=o;s.preventDefaultEvent(o);let v=u.trigger(`${c}MenuBeforeShow`,o);if(T.isPromise(v)&&(l.handled=!0,v=await v),!Object.values(m).some(y=>y))return;v!==!1&&(g&&(f.remove(g),L.asArray(g).forEach(y=>y.destroy())),f.featureItems=f.add(...Array.isArray(m)?m:f.processItemsObject(m)),f.showBy(e||{target:o.domEvent,align:"s0-e100"}),(n=s.touchMoveDetacher)==null||n.call(s),s.touchMoveDetacher=j.on({element:u.element,touchmove:()=>f.hide(),thisObj:f,once:!0}),l&&(l.preventDefault(),l.handled=!0))}}get baseItems(){if(!this._baseItems){const i=this,{namedItems:e}=i,t=i._baseItems=X.assign({},i.items);for(const r in t){const n=t[r];n&&(e&&r in e?t[r]=typeof n=="object"?X.merge(X.clone(e[r]),n):e[r]:n===!0&&delete t[r])}}return this._baseItems}hideContextMenu(i){var e;(e=this.menu)==null||e.hide(i)}callChainablePopulateMenuMethod(i){var e,t;(t=(e=this.client)[`populate${k.capitalize(this.type)}Menu`])==null||t.call(e,i)}hasActiveMenuItems(i){return Object.values(i.items).some(e=>e&&!e.hidden)}shouldShowMenu(){return!0}beforeContextMenuShow(i){}populateItemsWithData(i){}preventDefaultEvent(i){var e;(e=i.event)==null||e.preventDefault()}get triggerEvent(){return this._triggerEvent||this.client.contextMenuTriggerEvent}changeMenu(i,e){const t=this,{client:r,type:n}=t;if(i)return ur.reconfigure(e,i?ur.mergeConfigs({owner:r,rootElement:r.rootElement,onItem(s){r.trigger(`${n}MenuItem`,s)},onToggle(s){r.trigger(`${n}MenuToggleItem`,s)},onDestroy(){t.menu=null},onBeforeItem(s){Object.assign(s,t.menuContext)},onShow({source:s}){t.menuContext.menu=s,r.trigger(`${n}MenuShow`,t.menuContext)}},i):null,t);e!=null&&e.isWidget&&e.destroy()}};p(_n,"$name","ContextMenuBase"),_n._$name="ContextMenuBase";var zr={down:"onMouseDown",move:"onMouseMove",up:"onMouseUp",docclick:"onDocumentClick",touchstart:{handler:"onTouchStart",passive:!1},touchmove:"onTouchMove",touchend:"onTouchEnd",keydown:"onKeyDown"},ra=class extends Ie(O){construct(i){const e=this;super.construct(i),!e.handleSelector&&!Y.isHoverableDevice&&(e.handleSize=e.touchHandleSize),e.handleVisibilityThreshold=e.handleVisibilityThreshold||2*e.handleSize,e.initListeners(),e.initResize()}doDestroy(){this.abort(!0),super.doDestroy()}changeOuterElement(i){return i===!0?document.body:i}updateSkipUpdatingElement(i){i&&(this.skipTranslate=!0)}getX(i){return this.positioning==="inset"?parseFloat(getComputedStyle(i).insetInlineStart,10):E.getTranslateX(i)}getY(i){return this.positioning==="inset"?parseFloat(getComputedStyle(i).insetBlockStart,10):E.getTranslateY(i)}setX(i,e){this.positioning==="inset"?i.style.insetInlineStart=e+"px":E.setTranslateX(i,e)}setY(i,e){this.positioning==="inset"?i.style.insetBlockStart=e+"px":E.setTranslateY(i,e)}initResize(){const i=this;if(!i.isElementResizable&&i.targetSelector&&(i.isElementResizable=e=>e.closest(i.targetSelector)),i.grab){const{edge:e,element:t,event:r}=i.grab;i.startEvent=r;const n=i.getX(t)||t.offsetLeft,s=i.getY(t)||t.offsetTop;i.context={element:t,edge:e,valid:!0,async:!1,elementStartX:n,elementStartY:s,newX:n,newY:s,elementWidth:t.offsetWidth,elementHeight:t.offsetHeight,startX:r.clientX+i.scrollLeft,startY:r.clientY+i.scrollTop,finalize:()=>{var a;return(a=i.reset)==null?void 0:a.call(i)}},t.classList.add(i.resizingCls),i.internalStartResize(i.isTouch)}}initListeners(){const i=this,e={element:i.outerElement,mousedown:zr.down,touchstart:zr.touchstart,thisObj:i};!i.handleSelector&&Y.isHoverableDevice&&(e.mousemove={handler:zr.move,delegate:i.targetSelector},e.mouseleave={handler:"onMouseLeaveTarget",delegate:i.targetSelector,capture:!0}),j.on(e)}get isRTL(){var i;return!!((i=this.rtlSource)!=null&&i.rtl)}get scrollLeft(){return this.scroller?this.scroller.x:this.outerElement.scrollLeft}get scrollTop(){return this.scroller?this.scroller.y:this.outerElement.scrollTop}internalStartResize(i){var e;const t={element:document,keydown:zr.keydown,thisObj:this};i?(t.touchmove=zr.touchmove,t.touchend=t.pointerup=zr.touchend):(t.mousemove=zr.move,t.mouseup=zr.up),this.removeDragListeners=j.on(t),(e=this.onResizeHandlePointerDown)==null||e.call(this,this.startEvent)}removeDragListeners(){}reset(){var i;(i=this.removeDragListeners)==null||i.call(this),this.context=null,this.trigger("reset")}canResize(i,e){return!this.isElementResizable||this.isElementResizable(i,e)}onPointerDown(i,e){const t=this;t.startEvent=e,t.canResize(e.target,e)&&t.grabResizeHandle(i,e)&&(e.stopImmediatePropagation(),e.type==="touchstart"&&e.preventDefault(),t.internalStartResize(i))}onTouchStart(i){i.touches.length>1||this.onPointerDown(!0,i)}onMouseDown(i){i.button===0&&this.onPointerDown(!1,i)}internalMove(i,e){var t;const r=this,{context:n,direction:s}=r;n!=null&&n.element&&(n.started||j.getDistanceBetween(r.startEvent,e)>=r.dragThreshold)?(n.started||((t=r.scrollManager)==null||t.startMonitoring(T.merge({scrollables:[{element:r.dragWithin||r.outerElement,direction:s}],callback:a=>{var o;return((o=r.context)==null?void 0:o.element)&&r.lastMouseMoveEvent&&r.update(r.lastMouseMoveEvent,a)}},r.monitoringConfig)),r.trigger("resizeStart",{context:n,event:e}),n.started=!0),r.update(e)):!i&&!r.handleSelector&&r.checkResizeHandles(e)}onTouchMove(i){this.internalMove(!0,i)}onMouseMove(i){this.internalMove(!1,i)}onPointerUp(i,e){var t,r,n;const s=this,a=s.context;(t=s.removeDragListeners)==null||t.call(s),a?((r=s.scrollManager)==null||r.stopMonitoring(),a.started&&j.on({element:E.getRootElement(e.target),thisObj:s,click:zr.docclick,expires:s.clickSwallowDuration,capture:!0,once:!0}),s.finishResize(e)):(n=s.reset)==null||n.call(s)}onTouchEnd(i){this.onPointerUp(!0,i)}onMouseUp(i){this.onPointerUp(!1,i)}onDocumentClick(i){i.stopPropagation()}onKeyDown(i){i.key==="Escape"&&this.abort()}update(i){const e=this,{context:t,constrainToParent:r}=e,{element:n}=t;if(r){const s=$.from(e.outerElement);t.currentX=Math.max(Math.min(i.clientX,s.right),s.x)+e.scrollLeft,t.currentY=Math.max(Math.min(i.clientY,s.bottom),s.y)+e.scrollTop}else t.currentX=i.clientX+e.scrollLeft,t.currentY=i.clientY+e.scrollTop;n.classList.add(e.resizingCls),e.updateResize(i)&&(e.trigger("resizing",{context:t,event:i}),n.classList.toggle(e.invalidCls,t.valid===!1)),e.lastMouseMoveEvent=i}abort(i=!1){var e,t;const r=this;(t=(e=r.scrollManager)==null?void 0:e.stopMonitoring)==null||t.call(e),r.context?r.abortResize(null,i):r.isDestroyed||r.reset()}grabResizeHandle(i,e){var t;const r=this;if(r.allowResize&&!r.allowResize(e.target,e))return!1;const n=r.handleSelector,s=e.type==="touchstart"?e.changedTouches[0]:e,a=s.clientX,o=s.clientY;let l=r.targetSelector?e.target.closest(r.targetSelector):e.target;if(l){let d;if(n)if(e.target.matches(n))r.direction==="horizontal"?e.pageX<E.getPageX(l)+l.offsetWidth/2?d=r.isRTL?"right":"left":d=r.isRTL?"left":"right":e.pageY<E.getPageY(l)+l.offsetHeight/2?d="top":d="bottom";else return!1;else if(r.direction==="horizontal"?r.overLeftHandle(e,l)?d=r.isRTL?"right":"left":r.overRightHandle(e,l)&&(d=r.isRTL?"left":"right"):r.overTopHandle(e,l)?d="top":r.overBottomHandle(e,l)&&(d="bottom"),!d)return r.context=null,!1;e.type==="touchstart"&&e.preventDefault();const c=(t=r.internalBeforeStart)==null?void 0:t.call(r,{element:l,edge:d});if(c&&(l=c.element,d=c.edge),r.trigger("beforeResizeStart",{element:l,event:e})!==!1){const u=r.getX(l)||l.offsetLeft,h=r.getY(l)||l.offsetTop;return r.context={element:l,edge:d,isTouch:i,valid:!0,async:!1,direction:r.direction,elementStartX:u,elementStartY:h,newX:u,newY:h,elementWidth:l.offsetWidth,elementHeight:l.offsetHeight,startX:a+r.scrollLeft,startY:o+r.scrollTop,finalize:()=>{var f;return(f=r.reset)==null?void 0:f.call(r)}},l.classList.add(r.resizingCls),!0}}return!1}checkResizeHandles(i){const e=this,t=e.targetSelector?i.target.closest(e.targetSelector):i.target;let r=!1;return t&&(!e.allowResize||e.allowResize(i.target,i))?(e.currentElement=e.handleContainerSelector?i.target.closest(e.handleContainerSelector):i.target,e.currentElement&&(e.direction==="horizontal"?r=e.overLeftHandle(i,t)||e.overRightHandle(i,t):r=e.overTopHandle(i,t)||e.overBottomHandle(i,t),r?e.highlightHandle():e.unHighlightHandle())):e.currentElement&&e.unHighlightHandle(),r}onMouseLeaveTarget(i){const e=this;e.currentElement=e.handleContainerSelector?i.target.closest(e.handleContainerSelector):i.target,e.currentElement&&e.unHighlightHandle()}updateResize(i){const e=this,{context:t,allowEdgeSwitch:r,skipTranslate:n,skipUpdatingElement:s}=e;let a;r&&(e.direction==="horizontal"?t.edge=t.currentX>t.startX?"right":"left":t.edge=t.currentY>t.startY?"bottom":"top");const{element:o,elementStartX:l,elementStartY:d,elementWidth:c,elementHeight:u,edge:h}=t,{style:f}=o,g=(t.currentX-t.startX)*(e.positioning==="inset"&&e.isRTL?-1:1),m=t.currentY-t.startY,v=E.getExtremalSizePX(o,"minWidth")||e.minWidth,y=E.getExtremalSizePX(o,"maxWidth")||e.maxWidth,b=E.getExtremalSizePX(o,"minHeight")||e.minHeight,C=E.getExtremalSizePX(o,"maxHeight")||e.maxHeight,D=h==="right"&&(!e.isRTL||e.positioning==="inset")||h==="bottom"?1:-1,w=c+g*D,x=u+m*D;let R=Math.max(v,w),M=Math.max(b,x);if(y>0&&(R=Math.min(R,y)),C>0&&(M=Math.min(M,C)),e.direction==="horizontal"&&c!==R){if(s||(f.flex="",f.width=Math.abs(R)+"px"),t.newWidth=R,h==="left"||R<0){const I=Math.max(Math.min(l+c-e.minWidth,l+g),0);n||e.setX(o,Math.round(I)),t.newX=I}else h==="right"&&r&&!n&&e.setX(o,l);a=!0}else e.direction==="vertical"&&u!==x&&(s||(f.flex="",f.height=Math.abs(M)+"px"),t.newHeight=M,h==="top"||M<0?(t.newY=Math.max(Math.min(d+u-e.minHeight,d+m),0),n||e.setY(o,t.newY)):h==="bottom"&&r&&!n&&e.setY(o,d),a=!0);return a}finishResize(i){var e;const t=this,r=t.context,n={context:r,event:i};if(r.element.classList.remove(t.resizingCls),r.started){let s=!1;t.direction==="horizontal"?s=r.newWidth&&r.newWidth!==r.elementWidth:s=r.newHeight&&r.newHeight!==r.elementHeight,t.trigger(s?"resize":"cancel",n),r.async||r.finalize()}else(e=t.reset)==null||e.call(t)}abortResize(i=null,e=!1){const t=this,r=t.context;r.element.classList.remove(t.resizingCls),t.direction==="horizontal"?((r.edge==="left"||r.allowEdgeSwitch&&!r.skipTranslate)&&t.setX(r.element,r.elementStartX),r.element.style.width=r.elementWidth+"px"):(t.setY(r.element,r.elementStartY),r.element.style.height=r.elementHeight+"px"),!e&&t.trigger("cancel",{context:r,event:i}),t.isDestroyed||t.reset()}highlightHandle(){const i=this,e=i.targetSelector?i.currentElement.closest(i.targetSelector):i.currentElement;i.currentElement.classList.add("b-resize-handle"),e.classList.add("b-over-resize-handle")}unHighlightHandle(){const i=this,e=i.targetSelector?i.currentElement.closest(i.targetSelector):i.currentElement;e&&e.classList.remove("b-over-resize-handle"),i.currentElement.classList.remove("b-resize-handle"),i.currentElement=null}overAnyHandle(i,e){return this.overStartHandle(i,e)||this.overEndHandle(i,e)}overStartHandle(i,e){return this.direction==="horizontal"?this.overLeftHandle(i,e):this.overTopHandle(i,e)}overEndHandle(i,e){return this.direction==="horizontal"?this.overRightHandle(i,e):this.overBottomHandle(i,e)}getDynamicHandleSize(i,e){const t=i?2:1,{handleSize:r}=this;return this.dynamicHandleSize&&r*t>e-this.reservedSpace?Math.max(Math.floor((e-this.reservedSpace)/t),0):r}overLeftHandle(i,e){const t=this,{offsetWidth:r}=e;if(t.leftHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=$.from(e);return n.width=t.getDynamicHandleSize(t.rightHandle,r),n.width>0&&n.contains(j.getPagePoint(i))}return!1}overRightHandle(i,e){const t=this,{offsetWidth:r}=e;if(t.rightHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=$.from(e);return n.x=n.right-t.getDynamicHandleSize(t.leftHandle,r),n.width>0&&n.contains(j.getPagePoint(i))}return!1}overTopHandle(i,e){const t=this,{offsetHeight:r}=e;if(t.topHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=$.from(e);return n.height=t.getDynamicHandleSize(t.bottomHandle,r),n.height>0&&n.contains(j.getPagePoint(i))}return!1}overBottomHandle(i,e){const t=this,{offsetHeight:r}=e;if(t.bottomHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=$.from(e);return n.y=n.bottom-t.getDynamicHandleSize(t.bottomHandle,r),n.height>0&&n.contains(j.getPagePoint(i))}return!1}};p(ra,"configurable",{resizingCls:"b-resizing",dragThreshold:5,handleSize:10,dynamicHandleSize:null,reservedSpace:10,touchHandleSize:30,minWidth:1,maxWidth:0,minHeight:1,maxHeight:0,outerElement:!0,scroller:null,allowResize:null,dragWithin:null,isElementResizable:null,targetSelector:null,leftHandle:!0,rightHandle:!0,topHandle:!0,bottomHandle:!0,handleSelector:null,handleContainerSelector:null,startEvent:null,grab:null,invalidCls:"b-resize-invalid",handleVisibilityThreshold:null,skipTranslate:!1,direction:"horizontal",clickSwallowDuration:50,constrainToParent:!0,rtlSource:null,skipUpdatingElement:null}),ra._$name="ResizeHelper";var bR=/>[ \t\r\n]+</g,qO=/\s\s+/g,Ti=class OF{static tpl(e,...t){let r=0,n=t.map((s,a)=>{let o=e[a];return Array.isArray(s)?o+=s.reduce((l,d)=>l+=(typeof d=="string"?d.trim():d)+`
`,""):(s===void 0&&(s=""),o+=typeof s=="string"?s.trim():s),r++,o}).join("");return r<=e.length&&(n+=e[e.length-1]),n.replace(bR,"><").replace(qO," ").trim()}static docsTpl(e,...t){let r=0,n=t.map((s,a)=>{let o=e[a];return Array.isArray(s)?o+=s.reduce((l,d)=>l+=(typeof d=="string"?d.trim():d)+`
`,""):(s===void 0&&(s=""),o+=typeof s=="string"?s.trim():s),r++,o}).join("");return r<=e.length&&(n+=e[e.length-1]),n.replace(bR,"><").trim()}static repeat(e){return function(...t){return OF.tpl(...t).repeat(e)}}static loop(e){}};Ti._$name="TemplateHelper";var YO=class extends Array{constructor(i,e){super(),this.timeZone=i,this.year=e}},KO=class{constructor(i,e){this.asString=i,this.timeZone=e,this.asArray=ZO(i)}get asLocalDate(){return this._asLocalDate||(this._asLocalDate=new Date(...this.asArray)),this._asLocalDate}get asTicksUtc(){return this._asTicksUtc||(this._asTicksUtc=new Date(Date.UTC(...this.asArray)).getTime()),this._asTicksUtc}},CR=(i,e)=>{const t=i.toLocaleString("sv-SE",{timeZone:e});return new KO(t,e)},XO=(i,e)=>{const{asTicksUtc:t,asString:r}=CR(new Date(i),e);return{offset:(i-t)/6e4,tzTicksUtc:t,tzString:r}},ZO=i=>{const e=i.split(/[\s-:]/).map(t=>t*1);return e[1]-=1,e},QO=-6e4,JO=36e5,SR=-864e5,Hu=2592e6,wR=(i,e)=>{const t=DR.get(i,e);if(t)return t;const r=new YO(i,e),n=new Date(Date.UTC(e,0,1)).getTime();let s=n,a=Hu,o=0,l=[],d=null,c,u,h,f;for(;!f;)({offset:h,tzTicksUtc:c,tzString:u}=XO(s,i)),d==null?(d=h,r.push({offset:h})):a>0&&h!==d?a=a===Hu?SR:QO:a<0&&h===d&&(a===SR?a=JO:(r.length===1?(r.push(l),d=l.offset):(r[0].startTicks=l.startTicks,r[0].startDateString=l.startDateString,f=!0),a=Hu)),l={offset:h,startDateString:u,startTicks:c},a===Hu&&(s=n,s+=o*Hu,o+=1),s+=a,o>11&&(f=!0);return DR.set(r),r},DR={_cache:{},get(i,e){var t;return(t=this._cache[i])==null?void 0:t[e]},set(i){const{timeZone:e}=i,{_cache:t}=this;t[e]||(t[e]={}),t[e][i.year]=i}},qe=class{static toTimeZone(i,e){if(typeof e=="number")return this.toUtcOffset(i,e);const t=CR(i,e);return t.asArray[3]!==t.asLocalDate.getHours()&&console.warn("Incorrect time zone conversion due to local DST-switch detected"),t.asLocalDate}static fromTimeZone(i,e){if(typeof e=="number")return this.fromUtcOffset(i,e);const t=this.dateAsArray(i),r=wR(e,i.getUTCFullYear());let n=r[0].offset;if(r.length===2){const s=Date.UTC(...t);s>=r[1].startTicks&&s<r[0].startTicks&&(n=r[1].offset)}return t[4]+=n,new Date(Date.UTC(...t))}static toUtcOffset(i,e){const t=i.getTimezoneOffset()+e;return new Date(i.getTime()+t*60*1e3)}static fromUtcOffset(i,e){const t=-i.getTimezoneOffset()-e;return new Date(i.getTime()+t*60*1e3)}static dateAsArray(i){return[i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds()]}};p(qe,"$name","TimeZoneHelper"),qe.findOffsetDates=wR,ye.register(qe),qe._$name="TimeZoneHelper";var mm=class Qc extends z{static get configurable(){return{testConfig:{destroyTimeout:1,timeout:400},floating:!0,timeout:2500,autoDestroy:null,destroyTimeout:200,showProgress:!0,color:null,sideMargin:20,side:"bottom",role:"alert"}}changeSide(e){return e=="top"||e=="bottom"?e+="-end":(e==="start"||e=="end")&&(e="bottom-"+e),e}compose(){const{appendTo:e,color:t,html:r,showProgress:n,style:s,timeout:a,side:o}=this;return{parent:e||this.floatRoot,class:{...le.normalize(t,"object"),[`b-side-${o}`]:1,"b-toast-hide":1},"aria-atomic":!1,html:r,style:{...E.parseStyle(s),"--side":o.split("-")[0]},children:{progressElement:n&&{style:`animation-duration:${a}ms;`,class:{"b-toast-progress":1}}},listeners:{click:"hide"}}}doDestroy(){this.untoast(),super.doDestroy()}getNextInset(e){const{sideMargin:t,element:r}=this;return parseInt(r.style[e],10)+r.offsetHeight+t}async show(...e){var t,r,n;await super.show(...e);const s=this,{element:a,side:o}=s,l=Qc.toasts[o],d=o.split("-")[0],c=s.timeout*((t=E.getActiveElement())!=null&&t.matches(":focus-visible")?3:1);l.includes(s)||(a.style[d]=((n=(r=l[0])==null?void 0:r.getNextInset(d))!=null?n:s.sideMargin)+"px",l.unshift(s),a.getBoundingClientRect(),a.classList.remove("b-toast-hide"),c>0&&(s.hideTimeout=s.setTimeout("hide",c)))}async hide(){const e=this;e.untoast(),e.element.classList.add("b-toast-hide"),e.autoDestroy&&!e.destroyTimer&&(e.destroyTimer=e.setTimeout("destroy",e.destroyTimeout))}untoast(){const e=Qc.toasts[this.side];e.includes(this)&&e.splice(e.indexOf(this),1),E.removeAttributeValue(document.body,"aria-describedby",this.id)}static hideAll(){Object.keys(Qc.toasts).forEach(e=>Qc.toasts[e].slice().reverse().forEach(t=>t.hide()))}static show(e){var t;const r=Qc.new({autoDestroy:!0,rootElement:document.body,autoShow:!1},typeof e=="string"?{html:e}:e);return(t=E.getActiveElement())!=null&&t.matches(":focus-visible")&&Object.values(this.toasts).flat().length?yt.waitFor(()=>!Object.values(this.toasts).flat().length).then(()=>setTimeout(()=>r.show(),250)):r.show(),r}};p(mm,"$name","Toast"),p(mm,"type","toast"),p(mm,"toasts",{"top-start":[],"top-end":[],"bottom-start":[],"bottom-end":[]});var hr=mm;hr.initClass(),hr._$name="Toast";var ER=class{static getById(i){return te.deprecate("core","7.0.0","Use Widget.getById instead"),z.getById(i)}static fromElement(i,e,t){return te.deprecate("core","7.0.0","Use Widget.fromElement instead"),z.fromElement(i,e,t)}static createWidget(i={}){return te.deprecate("core","7.0.0","Use Widget.create instead"),i.isWidget?i:z.create(i)}static append(i,e){if(te.deprecate("core","7.0.0","Use a Container instead"),i=Array.isArray(i)&&i||[i],(e instanceof HTMLElement||typeof e=="string")&&(e={appendTo:e}),e.insertFirst){const t=typeof e.insertFirst=="string"?document.getElementById(e.insertFirst):e.insertFirst;t.firstChild?e.insertBefore=t.firstChild:e.appendTo=t}return i.map(t=>z.create(T.assign({},e||{},t)))}static openPopup(i,e){return te.deprecate("core","7.0.0","Use Popup directly instead"),z.create(T.assign({forElement:i},typeof e=="string"?{html:e}:e),"popup")}static showContextMenu(i,e){te.deprecate("core","7.0.0","Use Menu directly instead");const t=this;return t.currentContextMenu&&t.currentContextMenu.destroy(),i instanceof HTMLElement?e.forElement=i:(e.forElement=document.body,Array.isArray(i)&&(i=new Li(...i)),i instanceof Li&&(e.align={position:i})),e.internalListeners={destroy:t.currentContextMenu=null},t.currentContextMenu=z.create(e,"menu")}static attachTooltip(i,e){return te.deprecate("core","7.0.0","Use Tooltip directly instead"),z.attachTooltip(i,e)}static hasTooltipAttached(i){return te.deprecate("core","7.0.0","Will be removed"),z.resolveType("tooltip").hasTooltipAttached(i)}static destroyTooltipAttached(i){return te.deprecate("core","7.0.0","Will be removed"),z.resolveType("tooltip").destroyTooltipAttached(i)}static mask(i,e="Loading"){if(te.deprecate("core","7.0.0","Use Mask directly instead"),i)return i instanceof HTMLElement&&(i={target:i,text:e}),Qs.mask(i,i.target)}static unmask(i,e=!0){te.deprecate("core","7.0.0","Use Mask directly instead"),i.mask&&(e?i.mask.close():i.mask.hide())}static toast(i){return te.deprecate("core","7.0.0","Use Toast directly instead"),hr.show(i)}};ER._$name="WidgetHelper";var xR=class{static convertFromObject(i,e={}){X.assignIf(e,{rootName:"root",elementName:"element",includeHeader:!0,rootElementForArray:!0});const{rootName:t,elementName:r,includeHeader:n,rootElementForArray:s}=e;let{xmlns:a}=e;a=a?` xmlns="${a}"`:"";const o=n?'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>':"",l=d=>{const c=[];for(const u in d){const h=d[u];if(Array.isArray(h)){s&&c.push(`<${u}>`);for(const f of h)r.length?c.push(`<${r}>`):c.push(`<${u}>`),c.push(l(f)),r.length?c.push(`</${r}>`):c.push(`</${u}>`);s&&c.push(`</${u}>`)}else X.isObject(h)?c.push(`<${u}>${l(h)}</${u}>`):h==null?c.push(`<${u}/>`):c.push(`<${u}>${k.encodeHtml(h)}</${u}>`)}return c.join("")};return`${o}<${t}${a}>${l(i)}</${t}>`}};xR._$name="XMLHelper";var Uo=class{constructor(){this.random100=[46,2,36,46,54,59,18,20,71,55,88,98,13,61,61,40,2,15,3,32,51,45,64,25,81,85,54,13,57,49,64,22,81,94,0,62,17,7,11,2,33,99,85,26,83,83,96,26,20,89,91,38,26,13,11,79,32,30,5,51,70,7,5,56,58,77,37,89,40,80,78,59,26,36,8,51,60,23,86,5,11,96,64,94,87,64,4,78,17,85,35,0,90,86,23,55,53,9,35,59,29,2,64,42,8,49,43,73,6,53,38,9,39,31,32,40,49,13,78,68,20,99,24,78,35,91,73,46,67,76,89,69,30,69,25,3,4,55,1,65,66,76,83,19,67,1,95,24,54,45,56,40,67,92,72,4,69,8,47,50,27,2,38,9,14,83,12,14,62,95,22,47,35,18,38,14,86,64,68,61,52,69,39,93,20,73,32,52,74,6,56,68,99,29,24,92,40,67,6,72,31,41,91,53,80,55,33,97,97,99,18,20,5,27,82,84,61,78,27,67,7,42,75,95,91,25,63,21,70,36,46,0,1,45,84,6,86,15,10,62,96,94,10,23,93,83,94,47,5,29,29,52,51,37,77,96,43,72,43,14,54,14,72,52,4,39,15,26,68,28,25,76,60,50,22,40,72,74,68,58,8,48,40,62,52,24,9,26,47,44,49,96,7,77,90,45,76,47,5,86,1,36,18,42,19,90,34,23,70,32,69,79,0,99,57,80,72,21,19,72,85,68,4,40,86,62,0,63,4,11,69,31,78,31,21,78,29,84,13,53,57,10,26,50,24,30,90,42,51,96,93,21,99,23,81,0,89,43,86,63,93,19,54,71,92,36,4,95,37,99,60,29,23,50,68,95,57,95,77,53,99,78,75,12,92,47,23,14,0,41,98,11,34,64,26,90,50,23,38,31,74,76,16,76,66,23,22,72,48,50,20,36,37,58,5,43,49,64,81,30,8,21,98,75,60,17,50,42,27,38,90,74,45,68,67,27,31,15,58,76,41,99,23,98,53,98,56,19,79,2,4,38,96,24,65,51,43,42,41,60,46,7,90,65,3,27,63,99,51,44,86,1,54,40,15,74,3,81,51,63,87,79,84,72,22,38,96,95,33,41,21,99,21,69,7,49,40,52,41,6,91,19,76,40,54,17,33,11,11,0,1,32,94,33,13,18,45,7,85,61,42,54,45,72,78,96,17,9,80,87,41,96,66,0,8,59,18,21,2,28,64,75,97,32,80,86,97,97,55,2,73,75,11,89,67,58,70,76,12,46,64,17,22,97,25,35,93,57,82,46,57,61,31,74,27,4,32,85,53,86,53,53,42,5,28,50,65,63,70,61,73,37,13,80,7,34,22,3,26,6,62,78,12,56,87,41,58,64,31,27,45,35,18,66,62,43,89,69,94,93,33,74,2,43,85,37,82,41,74,9,15,44,33,42,65,19,1,49,78,12,29,9,78,7,55,12,45,40,33,16,86,14,52,16,73,76,0,98,75,91,78,46,99,95,90,69,78,45,62,55,37,88,49,77,27,83,38,73,39,1,75,40,65,83,54,95,7,73,4,30,26,36,89,21,5,95,11,14,87,45,36,21,77,55,5,66,51,98,48,62,74,58,23,82,30,28,19,53,89,76,98,8,34,70,28,54,16,52,35,93,54,54,72,49,18,93,72,90,71,73,15,60,38,80,76,53,70,39,69,25,5,31,61,46,6,54,34,31,52,33,36,79,76,44,29,28,38,1,66,2,90,91,1,76,78,31,55,37,71,2,3,38,85,0,95,42,2,39,57,87,61,77,98,2,24,80,48,27,47,71,15,7,49,60,86,3,2,29,38,54,36,59,83,27,47,9,36,42,8,73,85,9,16,73,60,39,12,43,25,23,29,28,47,40,77,20,89,22,30,41,59,96,19,56,20,76,73,39,46,72,40,47,37,52,29,79,37,39,50,41,87,66,17,75,31,45,26,88,70,11,90,40,74,9,32,65,72,61,6,93,54,15,84,22,99,47,10,96,4,84,19,85,73,45,25,16,8,94,99,39,28,26,68,87,48,1,65,86,46,86,7,60,82,45,75,38,56,41,35,30,86,91,97,85,45,5,14,69,85,96,37,18,26,16,38,16,1,44,94,85,58,60,20,5,47,52,41,50,71,43,42,67,64,38,65,83,99,78,96,33,20,98,24,6,2,25,16,16,44,63,24,68,56,49,91,15,59,99,27,43,34,28,36,45,1,10,19,54,26,75,17,88,96,63,24,71,93,72,97,66,87,18,86],this.randomCache={},this.rndIndex=0}nextRandom(i){const{randomCache:e}=this;let t;return e[i]?t=e[i]:(t=this.random100.filter(r=>r<i),e[i]=t),t[this.rndIndex++%t.length]}reset(){this.rndIndex=0}fromArray(i){return i[this.nextRandom(i.length)]}randomArray(i,e){const t=[],r=this.nextRandom(e+1),n={};for(let s=0,a=this.nextRandom(i.length);s<r;s++){for(;n[a];)a=this.nextRandom(i.length);n[a]=!0,t.push(i[a])}return t}};Uo._$name="RandomGenerator";var e$=["Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.","Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.","Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.","Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui atione voluptatem sequi nesciunt.","Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.","Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?","Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"],Vu=class Wv{static reset(){this.rnd.reset(),this.rndTime.reset(),this.rndRating.reset()}static get cities(){return["Stockholm","Barcelona","Paris","Dubai","New York","San Francisco","Washington","Montreal"]}static get namesWithAvatars(){return["Adam","Amit","Angelo","Arcady","Arnold","Barbara","Celia","Chang","Dan","Daniel","Dave","David","Don","Doug","Emilia","George","Gloria","Henrik","Hitomi","James","Jane","Jenny","John","Jong","Karen","Kate","Lee","Linda","Lisa","Lola","Macy","Madison","Malik","Mark","Mary","Maxim","Melissa","Mike","Rob","Steve","Team","Theo"]}static get firstNames(){return["Mike","Linda","Don","Karen","Doug","Jenny","Daniel","Melissa","John","Jane","Theo","Lisa","Adam","Mary","Barbara","James","David"]}static get surNames(){return["McGregor","Ewans","Scott","Smith","Johnson","Adams","Williams","Brown","Jones","Miller","Davis","More","Wilson","Taylor","Anderson","Thomas","Jackson"]}static get teams(){return["Lions","Eagles","Tigers","Horses","Dogs","Cats","Panthers","Rats","Ducks","Cougars","Hens","Roosters"]}static get foods(){return["Pancake","Burger","Fish n chips","Carbonara","Taco","Salad","Bolognese","Mac n cheese","Waffles"]}static get colors(){return["Blue","Green","Red","Yellow","Pink","Purple","Orange","Teal","Black"]}static get skills(){return["JavaScript","CSS","TypeScript","React","Vue","Angular","Java","PHP","Python","C#","C++","BASIC","COBOL","FORTRAN","PASCAL","SQL"]}static get tasks(){return["Meetings","Documentation","Email communication","Project management","Budgeting","Marketing and advertising","Customer service","Research and analysis","Data entry","IT support","Employee management","Sales and business development","Event planning","Graphic design","Writing and editing","Presentation","Travel arrangements and expense management","Training and development","Quality assurance","Customer support","Technical writing","Social media management","Translation","Legal research","Data analysis and visualization","Video editing and production","Network admin","Content creation","Market research","Public relations","Teaching and training","Recruiting","Product development"]}static generateName(){const{namesWithAvatars:e,surNames:t}=this,r=e[Math.round(Math.random()*(e.length-1))],n=t[Math.round(Math.random()*(t.length-1))];return`${r} ${n}`}static*generate(e,t=!1,r=1){var n;let s,a;typeof e=="object"&&(t=e.randomHeight,r=(n=e.initialId)!=null?n:1,s=e.addSkills,a=e.rowCallback,e=e.count);const o=this,{rnd:l,rndTime:d,rndRating:c,rndText:u,firstNames:h,surNames:f,teams:g,foods:m,colors:v,cities:y,skills:b}=o;for(let C=0;C<e;C++){const D=l.fromArray(h),w=l.fromArray(f),x=`${D} ${String.fromCharCode(65+C%25)} ${w}`,R=l.nextRandom(60)+1,M=new Date(2019,0,R),I=new Date(2019,0,R+l.nextRandom(30)+2),_={id:r>-1?C+r:void 0,title:"Row "+C,name:x,firstName:D,surName:w,city:l.fromArray(y),team:l.fromArray(y)+" "+l.fromArray(g),age:10+l.nextRandom(80),food:l.fromArray(m),color:l.fromArray(v),score:l.nextRandom(100)*10,rank:l.nextRandom(100)+1,start:M,finish:I,time:S.getTime(d.nextRandom(24),d.nextRandom(12)*5),percent:l.nextRandom(100),done:l.nextRandom(100)<50,rating:c.nextRandom(5),active:R>30,relatedTo:Math.min(e-1,C+r+l.nextRandom(10)),notes:e$[u.nextRandom(7)+1]};s&&(_.skills=l.randomArray(b,typeof s=="number"?s:7));const F=a==null?void 0:a(_);F&&Object.assign(_,F),t&&(_.rowHeight=l.nextRandom(t===!0?20:t)*5+20),yield _}}static generateData(e,t=!1,r=1,n=!0){let s=e;typeof e!="object"&&(s={count:e,randomHeight:t,initialId:r,reset:n}),s.reset!==!1&&this.reset(),Wv.overrideRowCount&&(s.count=Wv.overrideRowCount);const a=[],o=this.generate(s);for(let l=0;l<s.count;l++)a.push(o.next().value);return a}static generateEvents({viewStartDate:e,viewEndDate:t,nbrResources:r=50,nbrEvents:n=5,dependencies:s,tickUnit:a="days",minDuration:o=2,maxDuration:l=10,gap:d=1,eventCallback:c}){const u=this.generateData(r),h=[];let f,g;s=[];for(let m=0;m<=r;m++)for(let v=0;v<=n;v++){const y=Math.round(Math.random()*(l-1-o))+o,b=h.length+1;f=v===0?S.add(e,Math.round(Math.random()*3)*d,a):S.add(g,d,a),g=S.add(f,y,a),h.push({id:b,name:this.tasks[(m+v)%(this.tasks.length-1)],startDate:f,duration:y,endDate:g,resourceId:m}),c==null||c(h[h.length-1]),s&&m>0&&s.push({id:s.length+1,from:b-1,to:b})}return{resources:u,events:h,dependencies:s}}static generateOneEventPerTickAndResource({startDate:e,endDate:t,nbrResources:r=50,tickUnit:n="days"}){const s=this.generateData(r),a=[],o=S.getDurationInUnit(e,t,n);for(let l=0;l<=r;l++)for(let d=0;d<o;d++)a.push({id:a.length+1,resourceId:l,name:this.tasks[(l+d)%(this.tasks.length-1)],startDate:S.add(e,d,n),duration:1,durationUnit:n});return{resources:s,events:a}}static generateRow(){return Wv.generateData(1,!1,-1,!1)[0]}};p(Vu,"rnd",new Uo),p(Vu,"rndTime",new Uo),p(Vu,"rndRating",new Uo),p(Vu,"rndText",new Uo);var RR=Vu;RR._$name="DataGenerator";var t$=["action","target","to","deltaX","deltaY","x","y","text"],Mb=class extends Ie(be()){construct(i){super.construct(i);const e=this;e.widget&&(e.outerElement=e.widget.element,e.widget.playingDemo=!0),j.playingDemo=!0,Object.assign(e,{prevTarget:null,currentStep:0,mouse:E.createElement({parent:e.outerElement,tag:"div",className:"simulated-mouse"}),timeoutId:null,innerIntervalId:null,mouseOutElements:[]}),e.intervalId=e.setInterval(e.nextStep.bind(e),1e3),e.outerElement.classList.add("b-playing-demo"),e.outerElement.addEventListener("click",t=>{t.isTrusted&&e.abort()})}doDestroy(){this.abort()}changeOuterElement(i){return i===!0?document.body:i}abort(i=!1){const e=this;e.mouse.style.top="-100px",e.clearInterval(e.intervalId),e.timeoutId&&e.clearTimeout(e.timeoutId),e.innerIntervalId&&e.clearInterval(e.innerIntervalId),e.outerElement.classList.remove("b-playing-demo"),e.widget&&(e.widget.playingDemo=!1),j.playingDemo=!1,e.trigger(i?"done":"abort")}triggerEvent(i,e,t){if(!i)return null;let r;if(e.startsWith("mouse")){const n=this.mouse.getBoundingClientRect();r=new MouseEvent(e,Object.assign({view:globalThis,bubbles:!0,cancelable:!0,clientX:n.left,clientY:n.top},t||{}))}else r=document.createEvent("Event"),r.initEvent(e,!0,!1);return i.dispatchEvent(r),r}handleMouseMove(i,e){const t=this,r=t.mouse;r.classList.add("quick"),t.mouseDown&&r.classList.add("drag");const n=$.from(r,t.outerElement),s=n.x,a=n.y;let o=0,l=0;if(i.to)if(typeof i.to=="string"){const c=t.outerElement.querySelector(i.to);if(c){const u=$.from(c,t.outerElement),h=u.x+u.width/2,f=u.y+u.height/2;o=(h-s)/10,l=(f-a)/10}}else i.to.x?o=(i.to.x-s)/10:(o=i.to[0]/10,l=i.to[1]/10);else i.deltaX?o=i.deltaX/10:i.x&&(o=(i.x-s)/10);i.deltaY&&(l=i.deltaY/10);let d=0;t.innerIntervalId=t.setInterval(()=>{if(t.shouldPause)return;d++===9&&(clearInterval(t.innerIntervalId),i.then&&i.then());const c=s+o*d,u=a+l*d;r.style.left=c+"px",r.style.top=u+"px";const h=r.getBoundingClientRect(),f=h.left,g=h.top,m=E.elementFromPoint(f,g);m!==t.prevTarget&&(t.prevTarget&&(t.mouseOutElements.push(t.prevTarget),E.isDescendant(t.mouseOutElements[0],m)||(t.mouseOutElements.forEach(v=>t.triggerEvent(v,"mouseout")),t.mouseOutElements.length=0)),t.prevTarget=m,t.triggerEvent(m,"mouseover")),t.triggerEvent(m,i.action,{clientX:f,clientY:g})},50)}getTarget(i){const e=this,t=i.target;return t?typeof t=="function"?t(i):document.querySelector(t):e.prevTarget||e.outerElement}normalizeStep(i){if(i.action)return typeof i.action=="function"?i.action(i):i;if(typeof i=="function")return i(),i;for(const e in i)Object.hasOwnProperty.call(i,e)&&!t$.includes(e)&&(i.action=e.toLowerCase(),i.to=i[e]);return!i.target&&(typeof i.to=="string"||typeof i.to=="function")&&(i.target=i.to),i}get isScrolling(){const i=this,e=i.outerElement.getBoundingClientRect(),t=i.lastTop&&e.top!==i.lastTop;return i.lastTop=e.top,t}get isInView(){const i=this.outerElement.getBoundingClientRect();return i.top<globalThis.innerHeight&&i.bottom>0}get shouldPause(){return!this.isInView||this.isScrolling||document.hidden||!document.hasFocus()}nextStep(){const i=this;if(i.shouldPause)return;if(i.currentStep===i.steps.length)if(i.repeat)i.currentStep=0;else return i.abort(!0);i.currentStep===0&&i.trigger("initialize");const e=i.mouse,t=i.normalizeStep(i.steps[i.currentStep++]),r=i.getTarget(t),n=t.action;if(r&&n)if(e.className="simulated-mouse",n==="mousemove")i.handleMouseMove(t,r);else{if(r!==i.prevTarget){const s=$.from(r,i.outerElement);e.style.left=s.x+s.width/2+"px",e.style.top=s.y+s.height/2+"px"}n==="mousedown"&&(i.mouseDown=!0),n==="mouseup"&&(i.mouseDown=!1),i.timeoutId=i.setTimeout(()=>{if(i.prevTarget=r,e.classList.add(n),n==="type"){const s=z.fromElement(r),a=t.text.split("|");s.value=a[a.length===1||s.value!=a[0]?0:1]}else i.triggerEvent(r,n)},n==="type"?100:550)}}};p(Mb,"configurable",{repeat:!0,outerElement:!0,callOnFunctions:!0}),Mb._$name="DemoBot";var{defineProperty:i$}=Object,r$=Symbol("fencible"),n$=[],TR=i=>Array.from(new Set(i)),Ib=i=>i?TR(k.split(i)):n$,Go=i=>{var e;return e=class extends(i||O){static setupFenced(t,r){const{fenced:n}=t,s=r.getInherited("fenced");let a,o,l,d,c;for(d in n)c=n[d],c===!0&&(c=d),T.isObject(c)||(c={all:c}),a=Ib(c.all),o=Ib(c.any),l=c.lock?Ib(c.lock):TR(a.concat(o)),o=o.length?o:null,s[d]={any:o,all:a,lock:l}}construct(...t){const r=this,n=Object.getPrototypeOf(r),s=r.$meta.getInherited("fenced"),a=r[r$]={},o=l=>!a[l];return T.forEach(s,({any:l,all:d,lock:c},u)=>{i$(r,u,{configurable:!0,value(...h){if(d.every(o)&&(!l||l.some(o))){let f;try{for(f of c)a[f]=(a[f]||0)+1;return n[u].apply(r,h)}finally{for(f of c)--a[f]}}}})}),super.construct(...t)}get widgetClass(){}},p(e,"$name","Fencible"),p(e,"declarable",["fenced"]),e},{floor:MR,max:_b,min:IR}=Math,pm=(i,e,t)=>IR(_b(i,e),t),fr=class extends O.mixin(Go){get direction(){const{name:i}=this,{events:e,scrollStarted:t}=this.owner;let r=0,n,s,a;for(n=e.length;n-- >0&&(a=e[n][i],!(s!=null&&(r=s-a,r)));)s=a;return!r&&s!=null&&(r=s-t[i]),r}get drift(){return this._drift||0}get driftRange(){const{range:i}=this;return[i[0],_b(i[0],i[1]-this.scrollSize)]}get items(){var i;return(i=this.owner)==null?void 0:i.items}get safeZone(){const{drift:i,scrollSize:e}=this,t=MR(this.owner.safetyMargin*e);return[i+t,i+e-t]}get scroller(){var i,e;return(e=(i=this.owner)==null?void 0:i.client)==null?void 0:e.scrollable}get scrollLimit(){var i;return(i=this.owner)==null?void 0:i.scrollLimit}get vast(){const{range:i}=this;return i?i[1]-i[0]>this.scrollSize:!1}changePos(i){const{range:e}=this;return pm(i||0,e[0],e[1])}updatePos(i){this.sync({pos:i})}updateDrift(i){const e=this,{pos:t,range:r}=e,n=t-i;if(e.scrollPos===n){const s=new CustomEvent("scroll",{detail:"driftChange"});e.owner.scroller.element.dispatchEvent(s)}else r[0]<=t&&t<r[1]&&(e.scrollPos=n)}changeRange(i,e){const[t,r]=Array.isArray(i)?i:[0,i],n=[t||0,r==null?1/0:r];if(!e||n[0]!==e[0]||n[1]!==e[1])return n}updateRange(i){this.scrollSize=i[1]-i[0],this.sync({range:i})}changeScrollSize(i){return IR(i,this.scrollLimit)}snap(){const i=this,{direction:e,items:t,owner:r,pos:n,range:s}=i;let a,o,l,d,c;for(a of t)if([o,l]=i.getItemSpan(a),o<=n&&n<l){o<n?(c=r.snapThreshold,c<1&&(c=c*(l-o)),c=_b(1,c),e<0?d=l-n>c?o:l:d=n-o>c?l:o,d=pm(d,s[0],s[1]),i.pos=d,r.watchForEnd()):r.scrolling=!1;break}}sync(i){const e=Object.assign(this,i),{_drift:t,range:r,vast:n}=e;if(r&&r[0]!==r[1]){let{pos:s}=e,a;const o=s<r[0]||s>=r[1];if((s==null||o)&&(s=r[1]<0?r[0]:pm(0,r[0],r[1])),!n)a=r[0];else{const{driftRange:l,safeZone:d,scrollSize:c}=e;t==null||s<d[0]||s>d[1]?a=pm(MR(s-c/2),l[0],l[1]):a=t}e.scroller.positionDirty=!0,e.overflow="hidden-scroll",e.drift=a,a!==t?o?(e.positionDirty=!1,e._pos=null,e.pos=s):e.positionDirty=!0:(i==null?void 0:i.pos)!=null?(e.scrollPos=s-a,e.positionDirty=!0):(e.positionDirty&&(e.positionDirty=!1,e._pos=null),e.pos=e.scrollPos+a),(i!=null&&i.range||a!==t)&&e.owner.syncItems()}else e.overflow="hidden"}toLogical(i){return i+this.drift}toPhysical(i){const e=i-this.drift;return e>=0&&e<this.scrollLimit?e:NaN}};p(fr,"configurable",{owner:null,drift:null,overflow:null,pos:{value:null,default:0,$config:"lazy"},range:{value:null,$config:"lazy"},scrollSize:null}),p(fr,"fenced",{sync:!0});var s$=class extends fr{get name(){return"x"}get other(){var i;return(i=this.owner)==null?void 0:i.y}get scrollPos(){return Math.round(this.scroller.x)}set scrollPos(i){this.scroller.x=i}get scrollSize(){return this.scroller.scrollWidth}set scrollSize(i){super.scrollSize=i}getItemSpan(i){const e=i.$vxy,{x:t}=e;return[t,t+e.width]}updateScrollSize(i){this.scroller.scrollWidth=i}updateOverflow(i){this.scroller.overflowX=i}},a$=class extends fr{get name(){return"y"}get other(){var i;return(i=this.owner)==null?void 0:i.x}get scrollPos(){return Math.round(this.scroller.y)}set scrollPos(i){this.scroller.y=i}get scrollSize(){return this.scroller.scrollHeight}set scrollSize(i){super.scrollSize=i}getItemSpan(i){const e=i.$vxy,{y:t}=e;return[t,t+e.height]}updateScrollSize(i){this.scroller.scrollHeight=i}updateOverflow(i){this.scroller.overflowY=i}};fr.X=s$,fr.Y=a$,fr._$name="Axis";var _R="b-infinity-scroller",o$=Object.freeze({width:0,height:0}),Fb=(i,e)=>{const t="v"+e;t in i||Object.defineProperty(i,t,{configurable:!0,get(){var r;return(r=this.$vxy)==null?void 0:r[e]},set(r){this.$vxy&&(this.$vxy[e]=r)}})},Ab=class extends O{get height(){return this.getDim("height")}get width(){return this.getDim("width")}get x(){return this._x}set x(i){this.moveTo(i)}get xy(){return[this._x,this._y]}set xy(i){this.moveTo(...i)}get y(){return this._y}set y(i){this.moveTo(null,i)}getDim(i){const e=this,{widget:t}=e,r="_"+i;return t?t.monitorResize?t[i]:e[r]||(e[r]=t[i]):0}moveTo(i,e){i!=null&&(this._x=i),e!=null&&(this._y=e),this.sync()}sync(){const i=this,{owner:e,widget:t}=i,{element:r}=t,n=e.x.toPhysical(i.x),s=e.y.toPhysical(i.y),a=isNaN(n+s);i.hidden=a,a?i.size=o$:r.style.transform=`translate(${n}px, ${s}px)`}updateHidden(i){var e,t;(t=(e=this.widget)==null?void 0:e.element)==null||t.classList.toggle("b-scroll-hidden",i)}updateWidget(i,e){e==null||e.element.classList.remove("b-infinity-scroller-item"),i&&(i.element.classList.add("b-infinity-scroller-item"),Fb(i,"x"),Fb(i,"y"),Fb(i,"xy"))}};p(Ab,"configurable",{hidden:null,owner:null,widget:null}),p(Ab,"prototypeProperties",{_height:0,_width:0,_x:0,_y:0});var vm=class extends O.mixin(Ie){get element(){var i;return(i=this.scroller)==null?void 0:i.element}get events(){return this._events||(this._events=[])}get items(){var i;return(((i=this.client)==null?void 0:i.items)||[]).filter(e=>e.$vxy)}get lastEvent(){var i;return(i=this._events)==null?void 0:i[this._events.length-1]}get pos(){return[this.x.pos,this.y.pos]}changeScrollLimit(i){return i||E.scrollLimit}updateAnimate(i,e){var t;const r=(t=this.element)==null?void 0:t.classList;e&&(r==null||r.remove(`b-infinity-scroller-${e}`)),i&&(r==null||r.add(`b-infinity-scroller-${i}`))}updateClient(i){this.scroller=(i==null?void 0:i.scrollable)||null}updateScroller(i,e){var t;this.detachListeners("scroller"),(t=e==null?void 0:e.element)==null||t.classList.remove(_R),i&&(i.element.classList.add(_R),i.ion({thisObj:this,name:"scroller",scroll:"onInternalScroll"}))}changeX(i){return fr.X.new(i,{owner:this})}changeY(i){return fr.Y.new(i,{owner:this})}onInternalScroll(i){const e=this,{lastPos:t,scrolling:r}=e;r||(e.scrolling="maybe"),e.sync();const n=[e.x.pos,e.y.pos];t&&t[0]===n[0]&&t[1]===n[1]?e.scrolling=r:(e.lastPos=n,e.pushEvent(i),r||(e.scrolling=!0),e.triggerScroll("scroll",i))}onInternalScrollEnd(){const i=this,{scrolling:e}=i;e&&(e==="snap"?i.updateScrolling(e):i.scrolling=i.snap?"snap":!1)}pushEvent(i){const e=this,{events:t}=e,r={event:i,x:e.x.pos,y:e.y.pos},n=t[t.length-1];if(i.type===(n==null?void 0:n.event.type)&&n.x===r.x&&n.y===r.y)n.event=i;else for(n||(e.scrollStarted=r),t.push(r);t.length>3;)t.shift()}scrollTo(i){var e,t;const r=this,{scrollingTo:n}=r,s=r.x.pos,a=r.y.pos,o=(e=i==null?void 0:i.x)!=null?e:s+(i==null?void 0:i.dx)||0,l=(t=i==null?void 0:i.y)!=null?t:a+(i==null?void 0:i.dy)||0,d=o-s,c=l-a,u=d||c,h=(i==null?void 0:i.animate)!==!1&&(i==null?void 0:i.animate)!==null;if(n){if(n.scroll.x===o&&n.scroll.y===l&&n.scroll.animate===h)return n.promise;n.finish()}const f=r.scrollingTo=qs.new();return f.scroll={x:o,y:l,animate:h},u&&r.unanimated(!h,()=>{d&&(r.x.pos=o),c&&(r.y.pos=l)}),u&&h?(f.cancel=r.ion({once:!0,scrollEnd(){f.resolve(r.x.pos===o&&r.y.pos===l)}}),f.finish=()=>{f.cancel&&(f.cancel(),f.cancel=null,f.resolve(!1),r.scrollStarted=null)}):f.resolve(!0),f.finally(()=>{r.scrollingTo===f&&(r.scrollingTo=null)}),f.promise}suppressAnim(i){const e=this,t=e._suppressAnim||0,r=e._suppressAnim=Math.max(0,t+(i?1:-1));e.scroller.behavior=r?"instant":null}sync(){this.unanimated(()=>{this.x.sync(),this.y.sync()})}syncItems(){for(const i of this.items)i.$vxy.sync()}triggerScroll(i,e,t=this.x.pos,r=this.y.pos){this.trigger(i,{widget:this.client,relatedEvent:e,x:t,y:r})}updateScrolling(i,e){const t=this,r=e==="maybe",{lastEvent:n}=t;i?r?(t.watchForEnd(),t.scrollEnded=null,t.triggerScroll("scrollStart",n.event,n.x,n.y),t.element.classList.add("b-scrolling")):i==="snap"&&t[t.snap].snap():e&&((n==null?void 0:n.event.detail)==="driftChange"||!r)&&(t.scrollEnded=n,t.events.length=0,t.triggerScroll("scrollEnd",n.event,n.x,n.y),t.element.classList.remove("b-scrolling"))}unanimated(i,e){if(typeof i=="function"&&(e=i,i=!0),!i)e();else{this.suppressAnim(!0);try{e()}finally{this.suppressAnim(!1)}}}virtualize(i){typeof i=="string"&&(i=this.client.widgetMap[i]);let e=i.$vxy;return(!e||e.owner!==this)&&(e==null||e.destroy(),i.$vxy=e=new Ab({owner:this,widget:i})),e}watchForEnd(){const i=this,{client:e,scrollIdle:t,scrollStarted:r}=i;let n=0,s,a;(function o(){if(!i.isDestroyed&&!e.isDestroyed&&r===i.scrollStarted){if(a=i.pos,!s||s[0]!==a[0]||s[1]!==a[1])s=a,n=0;else if(++n>=t&&!ce.hasActiveTouches){i.onInternalScrollEnd();return}e.requestAnimationFrame(o)}})()}};p(vm,"configurable",{animate:"smooth",client:null,safetyMargin:.01,scroller:null,scrollIdle:8,scrolling:null,scrollLimit:{value:0,$config:"lazy"},snap:null,snapThreshold:.1,x:{},y:{}}),vm._$name="InfinityScroller";var FR=i=>{var e;return e=class extends i{get infinityScrollerDefaults(){return{animate:this.animate}}compose(){return{}}changeInfinityScroller(t,r){return r?r.setConfig(t):r=vm.new({client:this},this.infinityScrollerDefaults,t),r}onChildAdd(t){var r;return t.innerItem&&((r=this._infinityScroller)==null||r.virtualize(t)),super.onChildAdd(t)}onInfiniteScroll(){this.syncSoon()}onInfiniteScrollEnd(){this.syncSoon.now()}onInfiniteScrollStart(){}onInternalResize(t,r,n,s,a){super.onInternalResize(t,r,n,s,a),this.hasPainted&&this.syncSoon()}onInternalPaint(t){var r;(r=super.onInternalPaint)==null||r.call(this,t),t.firstPaint&&(this.syncSoon.now(),this.infinityScroller.ion({thisObj:this,scroll:"onInfiniteScroll",scrollStart:"onInfiniteScrollStart",scrollEnd:"onInfiniteScrollEnd"}))}get scrollingTo(){return this.infinityScroller.scrollingTo}scrollTo(t){return this.infinityScroller.scrollTo(t)}sync(){this.infinityScroller.sync()}syncSoon(){const t=this;t.isPainted&&(t.recompose.flush(),t.infinityScroller.animate=t.animate,t.sync())}unanimated(t,r){return this.infinityScroller.unanimated(t,r)}updateAnimation(){this._infinityScroller&&this.syncSoon()}get widgetClass(){}},p(e,"configurable",{animate:"smooth",infinityScroller:{value:{},$config:"lazy"},monitorResize:!0,scrollable:{}}),p(e,"delayable",{syncSoon:"raf"}),e},Nr=class extends O.mixin(Ie,En){static get configurable(){return{ownerCmp:null,itemsTabbable:null,target:null,keyEventTarget:null,processEvent:null,itemSelector:null,activeItem:null,focusCls:"b-active",keys:null,allowCtrlKey:null,allowShiftKey:null,activateOnMouseover:null,scrollDuration:50,disabled:null,datasetIdProperty:"id",columnCount:null,testConfig:{scrollDuration:1}}}static get factoryable(){return{defaultType:"navigator"}}get activeItem(){const{_activeItem:i}=this;if(this.target.contains(i))return i;this._activeItem=null}updateOwnerCmp(i){this.itemSelector||(this.itemSelector=`.${i.itemCls}:not([data-noselect])`),i.itemsFocusable||E.setAttributes(this.keyEventTarget,{"aria-activedescendant":`${this.owner.id}-active-descendant`})}set navigationEvent(i){const{owner:e}=this;this._navigationEvent=e.navigationEvent=i,i&&Promise.resolve(1).then(()=>this.navigationEvent=null)}get navigationEvent(){return this._navigationEvent}static getComposedKeyName(i){const e=(i.key||"").trim()||i.code;return`${i.ctrlKey?"CTRL+":""}${i.shiftKey?"SHIFT+":""}${i.altKey?"ALT+":""}${e}`}onKeyDown(i){var e;const t=this,{ownerCmp:r,itemSelector:n,activeItem:s,itemsTabbable:a}=t,{target:o}=i,l=t.firstItem,d=(i.key||"").trim()||i.code,c=t.constructor.getComposedKeyName(i),u=o.matches(n)||o===t.keyEventTarget;if(!t.disabled&&t.processEvent&&(i=t.callback(t.processEvent,t.thisObj||r,[i])),i&&!t.disabled&&l&&t.target.offsetParent&&u){if(!a){if(t.inlineFlow==null){const h=t.itemContainer=l.parentNode,f=E.getStyleValue(h,"display"),g=E.getStyleValue(l,"position"),m=E.getStyleValue(l,"display"),v=E.getStyleValue(l,"float");t.columnCount||(t.columnCount=E.getStyleValue(h,"grid-template-columns").split(" ").length),t.inlineFlow=g==="absolute"||m==="inline"||m==="inline-block"||v==="left"||v==="right"||f==="flex"&&E.getStyleValue(h,"flex-direction")==="row"||f==="grid"&&t.columnCount>1,t.columnCount>1&&(t.prevRowKey="ArrowUp",t.nextRowKey="ArrowDown")}t.prevKey||(t.inlineFlow?(t.prevKey="ArrowLeft",t.nextKey="ArrowRight"):(t.prevKey="ArrowUp",t.nextKey="ArrowDown"))}if(t.navigationEvent=i,s&&!t.disabled)switch(d){case t.prevKey:if(i.ctrlKey&&!t.allowCtrlKey||i.shiftKey&&!t.allowShiftKey)return;i.preventDefault(),i.handled=!0,t.navigatePrevious(i);break;case t.nextKey:if(i.ctrlKey&&!t.allowCtrlKey||i.shiftKey&&!t.allowShiftKey)return;i.preventDefault(),i.handled=!0,t.navigateNext(i);break;case t.prevRowKey:{if(i.ctrlKey&&!t.allowCtrlKey||i.shiftKey&&!t.allowShiftKey)return;i.preventDefault();const h=Array.from(t.itemContainer.querySelectorAll(t.itemSelector));t.activeItem=h[Math.max(h.indexOf(s)-t.columnCount,0)],i.handled=!0}break;case t.nextRowKey:{if(i.ctrlKey&&!t.allowCtrlKey||i.shiftKey&&!t.allowShiftKey)return;i.preventDefault();const h=Array.from(t.itemContainer.querySelectorAll(t.itemSelector));t.activeItem=h[Math.min(h.indexOf(s)+t.columnCount,h.length-1)],i.handled=!0}break;default:{const h=(e=t.keys)==null?void 0:e[c];if(h&&!t.disabled){if(t.callback(h,t.thisObj||r,[i,t,s])===!1)return}else r.onInternalKeyDown&&r.onInternalKeyDown(i);if(E.getActiveElement(o)!==o&&i.preventDefault(),a)return}}else{if(a)return;(d===t.nextKey||d===t.prevKey)&&(t.activeItem=t.getDefaultNavigationItem(i))}t.activeItem!==s&&t.triggerNavigate(i)}}getDefaultNavigationItem(i){const{target:e,itemSelector:t,prevKey:r,nextKey:n}=this;if(e.compareDocumentPosition(i.target)&4&&i.key===r)return e.querySelector(`${t}:last-of-type`);if(e.compareDocumentPosition(i.target)&2&&i.key===n)return e.querySelector(`${t}`)}navigatePrevious(i){const e=this,t=e.previous;i.preventDefault(),t&&e.ownerCmp.scrollable.scrollIntoView(t,{animate:e.scrollDuration}).then(()=>{e.activeItem=t,e.triggerNavigate(i)})}navigateNext(i){const e=this,t=e.next;i.preventDefault(),t&&e.ownerCmp.scrollable.scrollIntoView(t,{animate:e.scrollDuration}).then(()=>{e.activeItem=t,e.triggerNavigate(i)})}get owner(){return this.ownerCmp}get firstItem(){return this.target.querySelector(this.itemSelector)}get previous(){return this.getAdjacent(-1)}get next(){return this.getAdjacent(1)}getAdjacent(i=1,e=this.activeItem){const t=this.treeWalker;if(t.currentNode=e,t[i<0?"previousNode":"nextNode"](),t.currentNode!==this.activeItem)return t.currentNode}shouldIgnoreFocusIn(i){return this.ignoreEvent===i?(this.ignoreEvent=null,!0):i.target.matches(".b-focus-trap")}onTargetFocusIn(i){var e;const t=this,{target:r,relatedTarget:n}=i,{owner:s,itemsTabbable:a,skipScrollIntoView:o,previousActiveItem:l}=t;t.shouldIgnoreFocusIn(i)||(r.matches(t.itemSelector)?(t.skipScrollIntoView=!0,t.activeItem=r,t.skipScrollIntoView=o,t.activeItem&&a&&t.triggerNavigate(i)):r===t.target&&((n?r.compareDocumentPosition(n):0)&Node.DOCUMENT_POSITION_CONTAINED_BY?(e=s.previousSibling)==null||e.focus():(t.skipScrollIntoView=!0,t.activeItem=l&&t.target.contains(l)?l:0,t.skipScrollIntoView=o)))}onTargetFocusOut(i){const e=this,{relatedTarget:t}=i;t!=null&&t.matches(".b-focus-trap")||(!t||!e.target.contains(t)||!t.matches(e.itemSelector))&&e.activeItem&&(e.activeItem=null,e.itemsTabbable&&e.triggerNavigate(i))}onTargetMouseDown(i){const e=this,t=i.target.closest(e.itemSelector);e.navigationEvent=i,e.itemsTabbable?t===e.activeItem&&e.triggerNavigate(i):e.ownerCmp.itemsFocusable===!1?e.onFocusGesture(i):t&&(i.preventDefault(),t.focus({preventScroll:!0}))}onTargetMouseover({target:i}){this.activeItem=i}onTargetClick(i){var e;const t=this,{skipScrollIntoView:r}=t;if(t.skipNextClick||(e=t.navigationEvent)!=null&&e.ignoreNavigation){t.skipNextClick=!1;return}t.disabled||(t.skipScrollIntoView=t.activateOnMouseover,t.processEvent&&(i=t.callback(t.processEvent,t.thisObj||t.ownerCmp,[i])),i&&(t.activeItem=i.target.closest(t.itemSelector),t.triggerNavigate(i)),t.skipScrollIntoView=r)}onFocusGesture(i){(i.target===this.ownerCmp.contentElement||i.target.closest(this.itemSelector)&&this.ownerCmp.itemsFocusable===!1)&&i.preventDefault()}acceptNode(i){return i.offsetParent&&i.matches&&i.matches(this.itemSelector)?E.NodeFilter.FILTER_ACCEPT:E.NodeFilter.FILTER_SKIP}changeActiveItem(i){return i!=null&&(this.ownerCmp.getItem?i=this.ownerCmp.getItem(i):typeof i=="number"&&(i=this.target.querySelector(this.itemSelector+`:nth-child(${i+1})`))),i!=null&&i.matches(this.itemSelector)?i:null}updateActiveItem(i,e){var t;const r=this,{ownerCmp:n}=r,s=e&&r.target.contains(e),a=i&&E.isFocusable(i)&&i!==E.getActiveElement(i),o=i===e&&s;if(o||(s&&(r.previousActiveItem=e),e&&(e.classList.remove(r.focusCls),e.removeAttribute("id"))),i!=null){if(r.skipScrollIntoView?a&&i.focus({preventScroll:!0}):(t=n.scrollable)==null||t.scrollIntoView(i,{block:"nearest",focus:a,silent:r.scrollSilently}),o)return;i.classList.contains(r.focusCls)||i.classList.add(r.focusCls),i.id=`${r.owner.id}-active-descendant`,r._activeItem=i}else r._activeItem=null,e===E.getActiveElement(e)&&n.revertFocus()}updateTarget(i,e){const t=this,r={element:i,thisObj:t,focusin:"onTargetFocusIn",focusout:"onTargetFocusOut",mousedown:{handler:"onTargetMouseDown",delegate:t.itemSelector}};!t.itemsTabbable&&!t.itemsFocusable&&(r.click="onTargetClick"),t.activateOnMouseover&&(r.mouseover={handler:"onTargetMouseover",delegate:t.itemSelector,delay:30}),Object.prototype.hasOwnProperty.call(t,"acceptNode")||(t.acceptNode=t.acceptNode.bind(t)),j.on(r),t.treeWalker=t.setupTreeWalker(i,E.NodeFilter.SHOW_ELEMENT,t.acceptNode),t.keyEventTarget||(t.keyEventTarget=i),(t.targetMutationMonitor=new MutationObserver(t.onTargetChildListChange.bind(t))).observe(i,{childList:!0,subtree:!0})}setupTreeWalker(i,e,t){return document.createTreeWalker(i,e,t)}onTargetChildListChange(){var i;const e=this,{activeItem:t,datasetIdProperty:r}=e;t&&(e.target.contains(t)?t.classList.contains(e.focusCls)||t.classList.add(e.focusCls):e.activeItem=e.target.querySelector(`${e.itemSelector}.${e.focusCls}[data-${k.hyphenate(r)}="${t.dataset[r]}"]`)||((i=e.target.querySelector(`${e.itemSelector}.${e.focusCls}`))==null?void 0:i[t.dataset.index])||null)}updateKeyEventTarget(i){var e;(e=this.keyListenerRemover)==null||e.call(this),this.keyListenerRemover=j.on({element:i,keydown:"onKeyDown",thisObj:this})}triggerNavigate(i,e=this.activeItem){var t;const r={event:i,item:e,oldItem:this.previousActiveItem};this.trigger("navigate",r),(t=this.ownerCmp)==null||t.trigger("navigate",r)}};p(Nr,"$name","Navigator"),p(Nr,"type","navigator"),Nr._$name="Navigator";var l$=class extends O.mixin(Ie){constructor(){super(...arguments),p(this,"hasNativeAccess",!0),p(this,"_content",null)}async writeText(i,e){const t=this,{_content:r}=t;if(e&&t.hasNativeAccess)try{await navigator.clipboard.writeText(i)}catch(n){t.hasNativeAccess=!1}r!==i&&(t._content=i,t.triggerContentChange(r,!1,!0))}writeData(i,e){this._dataContent=i,this._contentSource=e}async readText(i){const e=this,{_content:t}=e;if(i&&e.hasNativeAccess)try{const r=await navigator.clipboard.readText();return t!==r&&(e._content=r,e._dataContent=e._contentSource=null,e.triggerContentChange(t,!0)),r}catch(r){e.hasNativeAccess=!1}return t}readData(i){if(!(i&&!L.asArray(i).includes(this._contentSource)))return this._dataContent}triggerPaste(i){this.trigger("paste",{source:i,text:this._content})}triggerContentChange(i,e=!1,t=!1){this.trigger("contentChange",{fromRead:e,fromWrite:t,oldText:i,newText:this._content})}async clear(i){await this.writeText("",i),this.writeData(null)}},AR=i=>{var e;return e=class extends(i||O){construct(...t){super.construct(...t),globalThis.bryntum.clipboard||(globalThis.bryntum.clipboard=new l$),globalThis.bryntum.clipboard.ion({paste:"onClipboardPaste",contentChange:"onClipboardContentChange",thisObj:this})}get clipboard(){return globalThis.bryntum.clipboard}onClipboardPaste({text:t,source:r}){var n;const s=this,{clipboardText:a,isCut:o}=s,l=s.compareClipboardText(a,t);l&&o?((n=s.handleCutData)==null||n.call(s,{text:t,source:r}),s.isCut=!1,s.cutData=null):l||s.clearClipboard(!1)}onClipboardContentChange({newText:t}){this.compareClipboardText(this.clipboardText,t)||this.clearClipboard(!1)}set cutData(t){var r,n;const s=this;(r=s._cutData)==null||r.forEach(a=>s.setIsCut(a,!1)),s._cutData=L.asArray(t),(n=s._cutData)==null||n.forEach(a=>s.setIsCut(a,!0))}get cutData(){return this._cutData}async writeToClipboard(t,r,n={}){if(await this.beforeCopy({data:t,isCut:r,...n})===!1)return;const s=this,a=typeof t=="string",o=a?t:s.stringConverter?s.stringConverter(t):k.safeJsonStringify(t),l=a?o:s.cloneData?s.cloneData({data:t,stringData:o,isPaste:!1}):T.clone(t);return s.clipboardText=o,s.clipboard.writeData(l,s.$$name),await s.clipboard.writeText(o,s.useNativeClipboard),s.clipboardData=l,s.originalData=t,s.isCut=r,s.cutData=r&&!a?t:null,{data:r?t:l,clonedData:l,originalData:t,stringData:o}}async readFromClipboard(t={},r=!1){var n;const s=this,{clipboard:a}=s,o=await a.readText(s.useNativeClipboard),l=s.compareClipboardText(s.clipboardText,o),d=l?s.originalData:[];let c=a.readData(s.allowedDataSources);l||s.clearClipboard(!1);const{isCut:u}=s;if((u||!c||c===o)&&(c=s.transformClipboardText(o)),c&&!u&&typeof c!="string"&&s.cloneData&&(c=s.cloneData({data:c,isPaste:!0})),!(c==null||Array.isArray(c)&&c.length===0||await((n=s.beforePaste)==null?void 0:n.call(s,{data:c,text:o,originalData:d,...t,isCut:u,isOwn:l}))===!1))return r||a.triggerPaste(s),{data:c,text:o,isOwn:l,isCut:u,originalData:d}}async clearClipboard(t=!0){const r=this;r.clipboardData=r.originalData=r.clipboardText=r.cutData=null,r.isCut=!1,t&&await r.clipboard.clear(r.useNativeClipboard)}compareClipboardText(t,r){const n=/\r\n|(?!\r\n)[\n-\r\x85\u2028\u2029]/g;return(t==null?void 0:t.replace(n,`
`))===(r==null?void 0:r.replace(n,`
`))}transformClipboardText(t){const r=this;return r.compareClipboardText(r.clipboardText,t)?r.isCut?r.originalData:r.clipboardData:r.stringParser&&t?r.stringParser(t):t}hasClipboardData(){const{clipboard:t}=this,{_content:r}=t;if(!(this.useNativeClipboard&&t.hasNativeAccess))return!!(r&&this.transformClipboardText(r))}},p(e,"$name","Clipboardable"),p(e,"configurable",{useNativeClipboard:!1,allowedDataSources:null}),e},PR=i=>{var e;return e=class extends(i||O){construct(...t){super.construct(...t),this.finalizer=null,this.finalizing=null,this.isFinalized=!1,this.isFinalizing=!1}doFinalize(){this.destroy()}finalize(){const t=this;let r=t.finalizing;return!r&&!t.isFinalized&&(t.isFinalizing=!0,t.finalizing=r=t._awaitFinalizer()),r}async _awaitFinalizer(){const t=this;try{await t.finalizer}finally{t.finalizing=null,t.isFinalized=!0,t.doFinalize()}}},p(e,"$name","Finalizable"),e},Pb=Symbol("dragAbort"),ym=Symbol("dragInit"),kR=Symbol("dragDrag"),kb=Symbol("dragDrop"),d$={x:"horizontal",y:"vertical"},qo=class extends O.mixin(PR,be,bn){static get configurable(){return{itemElement:null,scrollManager:null,monitoringConfig:null,source:null,target:null,targetElement:null,threshold:5,touchStartDelay:300,event:null}}static get identifiable(){return{}}construct(...i){super.construct(...i);const e=this,{event:t}=e;Object.assign(e,{altKey:null,cleaners:[],ctrlKey:null,data:new Map,element:t.target,endEvent:null,lastMoveEvent:null,metaKey:null,previousTarget:null,scrollerAction:null,shiftKey:null,state:ym,startEvent:t,touchStartTimer:null,_valid:!0}),"touches"in t&&e.touchStartDelay&&(e.touchStartTimer=e.setTimeout(()=>e.touchStartTimer=null,e.touchStartDelay,"touchStartDelay"));const r=globalThis;j.on({element:r,blur:"onWindowBlur",thisObj:e,autoDetach:!0})}doDestroy(){const i=this,{source:e,target:t}=i;i.cleanup(),(t==null?void 0:t.dropping)===i&&(t.dropping=null),(e==null?void 0:e.dragging)===i&&(e.dragging=null),super.doDestroy()}onWindowBlur(){this.started&&!this.completed&&this.abort()}get aborted(){return this.state===Pb}get completed(){return this.isDestroying||this.aborted||this.endEvent!==null}get pending(){return this.state===ym}get started(){return this.state!==ym&&!this.aborted}get valid(){return this.started&&this.targetElement!=null&&this._valid}set valid(i){this._valid=i}async get(i){if(this.aborted)throw new Error("Data is not available on aborted drag");if(!this.completed)throw new Error("Data is not available until drag completion");if(Array.isArray(i))return Promise.all(i.map(t=>this.get(t)));let e=this.data.get(i);return typeof e=="function"&&(e=await e(),this.data.set(i,e)),e}has(i){return this.data.has(i)}peek(i){if(this.aborted)throw new Error("Data is not available on aborted drag");if(Array.isArray(i))return i.map(t=>this.peek(t));let e=this.data.get(i);return typeof e=="function"&&(e=!0),e}set(i,e){this.data.set(i,e)}changeTarget(i,e){if(i!==e){const t=this;t._target=i,t.previousTarget=e,e&&(e.dropping=null),i&&(i.dropping=t,i.dropping!==t&&(i=null,t.valid=!1)),t._target=e}return i}updateTarget(i,e){const t=this;e&&t.source.dragLeaveTarget(t,e),i&&(t.valid=!0,i.dragMove(t),t.source.dragEnterTarget(t))}updateTargetElement(i){let e,t,r,n,s;for(s=i;s;s=s.parentElement)if(t=Ge.get(s,"droppables"),t){for(n=0;n<t.length;++n)if(e=t[n],e.dropRootElement.contains(i)&&(r=e.droppableSelector,(!r||i.closest(`#${E.getId(e.dropRootElement)} ${r}`))&&(this.target=e,this.target===e)))return}}abort(){const i=this,{element:e,source:t}=i;e==null||e.getBoundingClientRect(),i.state!==kb&&(i.state=Pb,i.cleanup()),t==null||t.endDrag(i)}begin(){const i=this,{source:e}=i,t=e.beforeDrag(i);return t!==!1&&(e.dragging=i),t}cleanup(){let i;for(;i=this.cleaners.pop();)i()}end(i){const e=this,{lastMoveEvent:t,target:r}=e,{dragSwallowClickTime:n}=e.source;if(e.event=e.domEvent=e.endEvent=i,e.syncFlags(),e.started){if(((t==null?void 0:t.clientX)!==i.clientX||(t==null?void 0:t.clientY)!==i.clientY||(t==null?void 0:t.target)!==i.target)&&e.track(),n){const s=globalThis;j.on({element:s,capture:!0,expires:n,once:!0,click(a){a.stopPropagation()}})}e.state=kb,r!==e.source&&(r==null||r.dragDrop(e))}}fakeKey(i,e){const t=this,{lastMoveEvent:r}=t;if(r&&t.element){let n;r.isKey=!0,i.key==="Alt"?t.altKey!==e&&(t.altKey=e,n=!0):i.key==="Control"&&t.ctrlKey!==e&&(t.ctrlKey=e,n=!0),n&&(t.event=t.domEvent=r,t.track())}}keyDown(i){this.completed||(i.key==="Escape"?this.abort():this.isDragToggleKey(i.key)&&this.fakeKey(i,!0))}keyUp(i){!this.completed&&this.isDragToggleKey(i.key)&&this.fakeKey(i,!1)}getDistance(i){return j.getDistanceBetween(this.startEvent,i)}isDragToggleKey(i){return i==="Control"||i==="Alt"}move(i){const e=this,{target:t}=i,r=e.getDistance(i),n=r>=e.threshold;if(e.syncFlags(),e.touchStartTimer){n&&e.abort();return}if(t&&t.nodeType===Node.ELEMENT_NODE&&t.isConnected){if(n&&!e.started&&(e.event=e.domEvent=i,e.start()===!1)){e.abort();return}i.touches&&(e.startEvent.preventDefault(),i.preventDefault(),i.stopPropagation()),e.started&&!e.completed&&(e.lastMoveEvent=e.event=e.domEvent=i,i.type==="touchmove"&&(i.preventDefault(),i.stopImmediatePropagation()),e.track())}}start(){const i=this,{scrollManager:e,monitoringConfig:t,source:r}=i,{draggingBodyCls:n,dragLock:s}=r,a=r.dragRootElement;if(i.state=kR,e){const l=e.startMonitoring(X.merge({scrollables:[{element:a}],direction:d$[s]||s||"both",callback(d){const{lastMoveEvent:c}=i;c&&i.element&&(c.isScroll=!0,i.event=i.domEvent=c,i.scrollerAction=d,i.track(),i.scrollerAction=null)}},t));i.cleaners.push(l)}const o=r.dragRootElement.closest(".b-outer")||document.body;if(o.classList.add(n),i.cleaners.push(()=>o.classList.remove(n)),r.startDrag(i)===!1)return i.cleanup(),!1}syncFlags(){const i=this,{event:e}=i;i.altKey=e.altKey,i.ctrlKey=e.ctrlKey||e.metaKey,i.metaKey=e.metaKey,i.shiftKey=e.shiftKey}track(){const i=this,{event:e,source:t,target:r}=i;let n=e.target,s;e.type==="touchmove"&&(s=e.changedTouches[0],n=E.elementFromPoint(s.clientX,s.clientY)),i.targetElement=n,r===i.target&&(r==null||r.dragMove(i)),t.trackDrag(i)}};p(qo,"$name","DragContext"),qo.prototype.STATE=qo.STATE=Object.freeze({ABORTED:Pb,INIT:ym,DRAGGING:kR,DROPPED:kb}),qo._$name="DragContext";var LR=class $F extends O.mixin(En){static get configurable(){return{dragging:null}}static get factoryable(){return{defaultType:$F}}updateDragging(e,t){t&&this.close(t),e&&this.open(e)}close(e){}open(e){}dragStart(e){this.dragging=e}dragMove(e){}dragEnd(e){this.dragging=null}};p(LR,"type","default");var ju=LR;ju.initClass(),ju._$name="DragProxy";var Lb=i=>{var e;return e=class extends(i||O){beforeDrag(t){const{dragRootElement:r,dragSelector:n,ignoreSelector:s}=this,a=n&&t.element.closest(n);return!n||!!(a&&a===r||r.contains(a)&&(!s||!t.element.matches(s)))}dragStart(t){}dragOver(t){}dragEnterTarget(t){}dragLeaveTarget(t,r){}async dragDrop(t){}dragEnd(t){}get activeDrag(){const{dragging:t}=this;return t!=null&&t.started&&!t.completed?t:null}get dragEventer(){return this.trigger?this:null}get draggingClassElement(){const{draggingClsSelector:t,dragRootElement:r}=this;return t?r==null?void 0:r.closest(t):r}beginDrag(t){const{draggingCls:r,draggingClassElement:n}=this;r&&n&&(n.classList.add(r),t.cleaners.push(()=>n.classList.remove(r)))}async endDrag(t){const r=this,{dragEventer:n,dragProxy:s}=r;t.valid&&await r.dragDrop(t),!r.isDestroyed&&(t.pending?t.destroy():(r.dragEnd(t),s==null||s.dragEnd(t),n==null||n.trigger(t.valid?"drop":"dragCancel",{drag:t,event:t.event}),r.finalizeDrag(t)))}async finalizeDrag(t){var r;await((r=t.finalize)==null?void 0:r.call(t))}moveDrag(t){if(this.dragOver(t)!==!1){const{dragEventer:r,dragProxy:n}=this;n==null||n.dragMove(t),r==null||r.trigger("drag",{drag:t,event:t.event})}}setupDragContext(t){const r=this,{dragItemSelector:n,id:s}=r,{target:a}=t;return{event:t,id:s?`${s}-drag-${r._nextDragId=(r._nextDragId||0)+1}`:null,itemElement:n?a.closest(n):a,touchStartDelay:r.dragTouchStartDelay,source:r,threshold:r.dragThreshold}}startDrag(t){const{draggingStartedCls:r,draggingClassElement:n,draggingItemCls:s,dragEventer:a,dragProxy:o}=this,{itemElement:l}=t;if((a==null?void 0:a.trigger("beforeDragStart",{drag:t,event:t.event}))===!1)return!1;r&&n&&(n.classList.add(r),t.cleaners.push(()=>n.classList.remove(r))),s&&l&&(l.classList.add(s),t.cleaners.push(()=>l.classList.remove(s))),o==null||o.dragStart(t);const d=this.dragStart(t);return d!==!1&&(a==null||a.trigger("dragStart",{drag:t,event:t.event})),d}trackDrag(t){var r;const{dropTargetSelector:n}=this;t.valid=!(n&&!((r=t.targetElement)!=null&&r.closest(n))),this.moveDrag(t)}configureListeners(t){const r=this,n=T.assign({thisObj:r},r.dragDocumentListeners);return"touches"in t.startEvent?(delete n.mousemove,delete n.mouseup):(delete n.contextmenu,delete n.touchmove,delete n.touchend,delete n.pointerup),n.element=E.getRootElement(r.dragRootElement),n}updateDragging(t,r){const n=this;if(t){const s=n.configureListeners(t);t.cleaners.push(j.on(s)),n.beginDrag(t)}else r&&r.destroy()}changeDragProxy(t,r){return ju.reconfigure(r,t,{owner:this,defaults:{owner:this}})}updateDragRootElement(t,r){var n;const s=this,{draggableCls:a,dragItemSelector:o,onDragItemMouseMove:l}=s;if(r==null||r.classList.remove(a),(n=s._dragRootDetacher)==null||n.call(s),t){const d={thisObj:s,element:t,mousedown:"onDragMouseDown",touchstart:"onDragTouchStart",pointerdown:c=>{var u,h;return c.pointerId&&((h=(u=c.target).releasePointerCapture)==null?void 0:h.call(u,c.pointerId))}};l&&(d.mousemove={delegate:o,handler:"onDragItemMouseMove"}),(s.dragItemOverCls||l||s.onDragItemMouseEnter||s.onDragItemMouseLeave)&&Object.assign(d,{mouseover:{delegate:o,handler:"onDragItemMouseOver"},mouseout:{delegate:o,handler:"onDragItemMouseOut"}}),t.classList.add(a),s._dragRootDetacher=j.on(d)}}onDragItemMouseOver(t){this.overItem=t}onDragItemMouseOut(t){this.dragging||(this.overItem=t)}changeOverItem(t){var r;return this.enterLeaveEvent=t,t.type==="mouseout"?((r=t.relatedTarget)==null?void 0:r.closest(this.dragItemSelector))||null:t.target.closest(this.dragItemSelector)}updateOverItem(t,r){var n,s;const a=this,{dragItemOverCls:o}=a;r&&(o&&r.classList.remove(o),(n=a.onDragItemMouseLeave)==null||n.call(a,a.enterLeaveEvent,r)),t&&(o&&t.classList.add(o),(s=a.onDragItemMouseEnter)==null||s.call(a,a.enterLeaveEvent,t))}onDragContextMenu(t){t.preventDefault()}onDragKeyDown(t){this.dragging.keyDown(t)}onDragKeyUp(t){this.dragging.keyUp(t)}onDragMouseDown(t){t.button===0&&this.onDragPointerDown(t)}onDragPointerDown(t){let{dragging:r}=this;r?r.isFinalizing||r.abort():(r=this.setupDragContext(t),r&&(r=new qo(r),r.begin()===!1&&r.destroy()))}changeDragging(t,r){return r==null||r.destroy(),t}onDragPointerMove(t){const{changedTouches:r}=t,{dragging:n}=this;n&&!n.completed&&(!r||r.length===1)&&(n==null||n.move(t))}onDragPointerUp(t){const{dragging:r}=this;r&&!r.completed&&(r.end(t),this.endDrag(r))}onDragTouchStart(t){t.touches.length===1&&this.onDragPointerDown(t)}},p(e,"$name","Draggable"),p(e,"configurable",{dragging:{$config:"nullify",value:null},draggingClsSelector:null,dragDocumentListeners:{element:document,keydown:"onDragKeyDown",keyup:"onDragKeyUp",contextmenu:"onDragContextMenu",mousemove:"onDragPointerMove",mouseup:"onDragPointerUp",pointerup:"onDragPointerUp",touchend:"onDragPointerUp",touchmove:{handler:"onDragPointerMove",passive:!1}},dragItemSelector:null,dragItemOverCls:null,dragLock:null,dragMinDistance:1,dragProxy:{$config:["lazy","nullify"],value:null},dragRootElement:{$config:"nullify",value:null},dragSameTargetDrop:!1,dragSelector:null,ignoreSelector:null,dragSwallowClickTime:50,dragThreshold:5,dragTouchStartDelay:300,dropTargetSelector:null,overItem:null,testConfig:{dragSwallowClickTime:50}}),p(e,"properties",{draggingCls:"b-draggable-active",draggingBodyCls:"b-draghelper-active",draggingItemCls:"b-dragging-item",draggingStartedCls:"b-draggable-started",draggableCls:"b-draggable"}),e},OR=i=>{var e;return e=class extends(i||O){static get configurable(){return{droppableSelector:null,dropping:null,dropRootElement:{$config:"nullify",value:null}}}get dropEventer(){return this.trigger?this:null}get droppableCls(){return"b-droppable"}dragEnter(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("dragEnter",{drag:t,event:t.event})}dragMove(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("dragMove",{drag:t,event:t.event})}dragDrop(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("drop",{drag:t,event:t.event})}dragLeave(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("dragLeave",{drag:t,event:t.event})}changeDropping(t,r){if(t!==r){const n=this;r&&(r.aborted||!r.completed)&&n.dragLeave(r),t&&(n._dropping=t,n.dragEnter(t)===!1&&(t=null),n._dropping=r)}return t}updateDropRootElement(t,r){const n=this,{droppableCls:s}=n;let a,o,l;r&&(a=Ge.get(r,"droppables"),l=!0,Array.isArray(a)&&(o=a.indexOf(n))>-1&&(a.length<2?Ge.remove(r,"droppables"):(a.splice(o,1),a.forEach(d=>{s===d.droppableCls&&(l=!1)}))),l&&r.classList.remove(s)),t&&(a=Ge.get(t,"droppables"),a?a.push(n):Ge.set(t,"droppables",[n]),t.classList.add(s))}},p(e,"$name","Droppable"),e},c$=i=>{var e;return e=class extends(i||O){static get configurable(){return{features:null}}static get declarable(){return["featureable"]}static setupFeatureable(t){const r={ownerName:"client",...t.featureable};r.factory.initClass(),Reflect.defineProperty(t,"featureable",{get(){return r}})}doDestroy(){var t;const r=this.features;super.doDestroy();for(const n in r){const s=r[n];(t=s.destroy)==null||t.call(s)}}hasFeature(t){var r;return!!((r=this.features)!=null&&r[t])}changeFeatures(t,r){if(super.changeFeatures)return super.changeFeatures(t,r);if(this.isDestroying)return;const n=this,{featureable:s}=n.constructor,a=n.$features||(n.$features=new ea({configName:"features",factory:s.factory,owner:n,ownerName:s.ownerName}));if(a.update(t),!r)return a.target}get widgetClass(){}getCurrentConfig(t){const r=super.getCurrentConfig(t),{features:n}=r;if(n)for(const s in n)Object.keys(n[s]).length===0&&(n[s]=!0);return r}},p(e,"$name","Featureable"),e},et={e:"b-hover-edge",t:"b-hover-top",r:"b-hover-right",b:"b-hover-bottom",l:"b-hover-left"},u$={[et.e]:1,[et.t]:1,[et.r]:1,[et.b]:1,[et.l]:1},h$={t:[et.e,et.t],r:[et.e,et.r],b:[et.e,et.b],l:[et.e,et.l],tr:[et.e,et.t,et.r],bl:[et.e,et.b,et.l],tl:[et.e,et.t,et.l],br:[et.e,et.b,et.r]},f$=i=>{var e;return e=class extends i.mixin(be){static get configurable(){return{hoverCls:null,hoverAnimationCls:null,hoverRootCls:null,hoverRootActiveCls:null,hoverDelay:null,hoverElement:null,hoverIgnoreElement:null,hoverEdges:null,hoverEdgeSize:10,hoverRootElement:{$config:"nullify",value:null},hoverSelector:null,hoverTarget:{$config:"nullify",value:null},hoverTrack:null,hoverZone:null}}static get delayable(){return{setHoverTarget:0}}hoverEnter(t){}hoverIgnore(t){var r;return(r=this.hoverIgnoreElement)==null?void 0:r.contains(t)}hoverLeave(t){}hoverMove(t){}onHoverMouseMove(t){const r=this,{hoverEdges:n,hoverEdgeSize:s,hoverTarget:a}=r;if(a){if(n){const{top:o,left:l,width:d,height:c,right:u,bottom:h}=a.getBoundingClientRect(),{clientX:f,clientY:g}=t,m=l+d/2,v=o+c/2,y=g<(s?o+s:v),b=f>=(s?u-s:m),C=g>=(s?h-s:v),D=f<(s?l+s:m),w=y||C?y?"t":"b":"",x=b||D?b?"r":"l":"";r.hoverZone=(n.includes(w)?w:"")+(n.includes(x)?x:"")}r.hoverEvent=t,r.hoverTrack&&r.hoverMove(t)}}onHoverMouseOver(t){this.hoverEvent=t,this.hoverElement=t.target}onHoverMouseOut(t){this.hoverEvent=t,this.hoverElement=t.relatedTarget}updateHoverDelay(t){this.setHoverTarget.delay=t}changeHoverEdges(t){return t===!0?"trbl":(t||"").replace("v","tb").replace("h","lr")}updateHoverEdges(){this.syncHoverListeners()}changeHoverElement(t){if(!this.hoverIgnore(t))return t}updateHoverElement(t){const{hoverSelector:r}=this;r&&(t=t==null?void 0:t.closest(r)),this.setHoverTarget(t)}updateHoverRootElement(t,r){const{hoverRootCls:n}=this;n&&(r==null||r.classList.remove(n),t==null||t.classList.add(n)),this.syncHoverListeners()}changeHoverTarget(t,r){return r&&(this.hoverZone=null),t}updateHoverTarget(t,r){const n=this,{hoverCls:s,hoverAnimationCls:a,hoverRootActiveCls:o,hoverRootElement:l}=n;o&&(l==null||l.classList[t?"add":"remove"](o)),r&&(s&&r.classList.remove(s),a&&r.classList.remove(a),n.hoverLeave(r)),t&&(s&&t.classList.add(s),n.hoverEnter(r),n.hoverTrack&&n.hoverMove(n.hoverEvent),a&&(t.getBoundingClientRect(),t.classList.add(a)))}updateHoverTrack(){this.syncHoverListeners()}updateHoverZone(t){const{hoverAnimationCls:r,hoverTarget:n}=this;if(n){const{className:s}=n,a=le.change(s,t?h$[t]:null,u$);s!==a&&(n.className=a,t&&r&&(n.classList.remove(r),n.getBoundingClientRect(),n.classList.add(r)))}}setHoverTarget(t){this.hoverTarget=t}syncHoverListeners(){var t;const r=this,n=r.hoverRootElement,s={element:n,thisObj:r,mouseover:"onHoverMouseOver",mouseout:"onHoverMouseOut"};(r.hoverTrack||r.hoverEdges)&&(s.mousemove="onHoverMouseMove"),(t=r._hoverRootDetacher)==null||t.call(r),r._hoverRootDetacher=n&&j.on(s)}},p(e,"$name","Hoverable"),e},Ob=i=>{var e;return e=class extends i{static get configurable(){return{loadMaskDefaults:{useTransition:!0,showDelay:1e3},loadMaskError:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},loadMask:{text:"L{GridBase.loadMask}"},syncMask:{text:"L{GridBase.syncMask}"},localizableProperties:["loadMask.text","syncMask.text"],testConfig:{loadMaskError:{icon:"b-icon b-icon-warning",autoClose:500,showDelay:0}}}}applyLoadMask(){const t=this,{loadMask:r}=t;return r&&(t.masked=Qs.mergeConfigs(t.loadMaskDefaults,r)),t.masked}applyMaskError(t){const{loadMaskError:r,masked:n}=this;return r===!1?n.hide():n&&(T.assign(n.errorDefaults,r),n.error=t),n}get widgetClass(){}},p(e,"$name","LoadMaskable"),e},g$={constructor:1,prototype:1,name:1,length:1,arguments:1,caller:1,callee:1,__proto__:1},$R=class{static apply(i){if(!i.target)throw new Error("Override must specify what it overrides, using static getter target");if(!i.target.class)throw new Error("Override must specify which class it overrides, using target.class");if(!this.shouldApplyOverride(i))return!1;const e=Object.getOwnPropertyNames(i),t=Object.getOwnPropertyNames(i.prototype);return e.splice(e.indexOf("target"),1),this.internalOverrideAll(i.target.class,e,i),this.internalOverrideAll(i.target.class.prototype,t,i.prototype),!0}static internalOverrideAll(i,e,t){Reflect.ownKeys(t).forEach(r=>{if(e.includes(r)&&!g$[r]){const n=Object.getOwnPropertyDescriptor(t,r);let s=i,a=null;for(;!a&&s;)a=Object.getOwnPropertyDescriptor(s,r),a||(s=Object.getPrototypeOf(s));a&&this.internalOverride(s,r,n,a)}})}static internalOverride(i,e,t,r){const n=i._overridden=i._overridden||{};n[e]=i[e],r.get?Object.defineProperty(i,e,{enumerable:!1,configurable:!0,get:t.get}):i[e]=t.value}static shouldApplyOverride(i){const e=i.target;if(!e.maxVersion&&!e.minVersion)return!0;if(!e.product)throw new Error("Override must specify product when using versioning");return!(e.maxVersion&&te[e.product].isNewerThan(e.maxVersion)||e.minVersion&&te[e.product].isOlderThan(e.minVersion))}};$R._$name="Override";var bm=60*1e3,na=60*bm,Wr=24*na,m$=/(\d+)?:?(\d*)/,ji=class fn{static format(e){const t=Math.floor(e/na),r=Math.floor(e/bm)%60;return`${t}:${r<10?"0":""}${r}`}static parse(e){const t=typeof e;if(t==="string"){const r=m$.exec(e);e=Number(r[1]||0)*na+Number(r[2]||0)*bm}else t!=="number"?e=S.getTimeOfDay(e):e<=24&&(e*=na);return Math.min(Math.max(Math.floor(e),0),Wr)}constructor(e){let t=0,r,n;e!=null&&e.isDayView?(t=e.dayStartShift,r=e.dayStartTime,n=e.dayEndTime):typeof e=="number"?t=r=n=e:e&&(t=e.startShift,r=e.timeStart,n=e.timeEnd),this.startShift=t=fn.parse(t||0),this.timeEnd=(n==null?(t+Wr)%Wr:fn.parse(n))||Wr,this.timeStart=r==null?t:fn.parse(r)}get startHour(){return Math.floor(this.timeStart/na)}get endHour(){return Math.floor(this.timeEnd/na)}get startTimeOffsetMs(){const{startShift:e,timeStart:t}=this;return t<e?Wr-e+t:t-e}get today(){return this.startOfDay(new Date)}ceil(e){const t=this.startOfDay(e);return t<e&&t.setDate(t.getDate()+1),t}contains(e){return!this.outside(e)}dateKey(e){return e=this.shiftDate(e,-1),S.makeKey(e)}dayOfDate(e){return this.shiftDate(S.clearTime(e))}dayOfWeek(e){return e=this.shiftDate(e,-1),e.getDay()}delta(e,t="ms"){const{timeStart:r}=this,n=fn.parse(e),s=(this.startShift&&n<r?n+Wr:n)-r;return t==="ms"?s:S.as(t,s,"ms")}duration(e="ms"){const{timeStart:t,timeEnd:r}=this,n=t<r?r-t:Wr-t+r;return e==="ms"?n:S.as(e,n,"ms")}equals(e){return this.startShift===(e==null?void 0:e.startShift)&&this.timeStart===e.timeStart&&this.timeEnd===e.timeEnd}intersects(e,t){const r=this,{timeStart:n,timeEnd:s}=r,[a,o]=r._dateRangeArgs(e,t),[l,d]=r.timeRange(a,o);return n<s?l<d?l<s&&n<d:l<s||n<d:!(l<d)||l<s||n<d}isIntraDay(e,t){const r=this,[n,s]=r._dateRangeArgs(e,t),a=r.startOfDay(n),o=Wr-S.diff(a,s,"ms");return o<0?!1:o>0||a<n}isInterDay(e){return e.allDay||!this.isIntraDay(...arguments)}outside(e){const{startShift:t,timeStart:r,timeEnd:n}=this,s=fn.parse(e);return r<n?s<r?s<t?1:-1:s<n?0:s<t?-1:1:s<n||s>=r?0:s<t?1:-1}parseKey(e){return this.dayOfDate(S.parseKey(e))}shiftDate(e,t=1){const{startShift:r}=this,n=typeof e;return e=n==="number"?new Date(e):n==="string"?S.parse(e):new Date(e.getTime()),t&&r&&e.setMilliseconds(t>0?r:-r),e}sortEvents(e,t){const r=this.startOfDay(e);return t==null?void 0:t.sort((n,s)=>{n=n.eventRecord||n,s=s.eventRecord||s;let{startDate:a}=n,{startDate:o}=s;return a?o?(a=a<r?r:a,o=o<r?r:o,a-o||s.endDate-o-(n.endDate-a)):1:-1})}startOfDay(e){return e=this.shiftDate(e,-1),e=S.clearTime(e),e=this.shiftDate(e),e}timeRange(e,t){const[r,n]=this._dateRangeArgs(e,t);return[S.getTimeOfDay(r),S.getTimeOfDay(n)]}toString(){const{startShift:e,timeEnd:t,timeStart:r}=this,n=e?`@${fn.format(e)}`:"",s=fn.format(r);return r===t?e?n:s:`${s}-${fn.format(t)}${n}`}_dateRangeArgs(e,t){return e.isModel?[e.startDate,e.endingDate]:[e,t]}};ji.MIDNIGHT=new ji({startShift:0,timeStart:0,timeEnd:24}),ji.MILLIS_PER_MINUTE=bm,ji.MILLIS_PER_HOUR=na,ji.MILLIS_PER_DAY=Wr,ji._$name="DayTime";var Cm=class BF extends O{static getVisitor(e,t){const{elementVisitorMap:r}=this,n=r.get(e)||r.set(e,new Map).get(e),s=typeof t=="string"?t:t.toString();return n.get(s)||n.set(s,new BF({element:e,selector:t})).get(s)}updateSelector(e){this.treeWalker=document.createTreeWalker(this.element,NodeFilter.SHOW_ELEMENT,typeof e=="string"?t=>{var r;return(r=t.matches)!=null&&r.call(t,e)?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_SKIP}:e)}first(){return this.treeWalker.currentNode=this.element,this.treeWalker.firstChild()}previous(e){return e&&(this.treeWalker.currentNode=e),this.treeWalker.previousNode()}next(e){return e&&(this.treeWalker.currentNode=e),this.treeWalker.nextNode()}last(){return this.treeWalker.currentNode=this.element,this.treeWalker.lastChild()}};p(Cm,"$name","ElementVisitor"),p(Cm,"configurable",{element:null,selector:null}),p(Cm,"elementVisitorMap",new WeakMap);var BR=Cm;BR._$name="ElementVisitor";var gr=class extends Tt{afterShow(...i){super.afterShow(...i),this.addDocumentMouseDownListener()}realign(...i){super.realign(...i),this.syncTargetHighlighting()}get isTopModal(){return!1}owns(...i){return this.masked?!0:super.owns(...i)}onDocumentMouseDown({event:i}){i.isTrusted&&(this.owns(i.target)?super.onDocumentMouseDown(...arguments):this.hintFlow.stop())}changeTarget(i){if(i&&(typeof i=="string"&&(this._target=this._forElement=null),i=this.hintFlow.normalizeTarget(i),T.isPromise(i))){i.then(e=>!this.isDestroyed&&(this.target=e)),this.setTimeout("hide",this.maxWait);return}return i}updateButtons(i){this.bbar={items:i}}updateHighlightTarget(i,e){const t=i==null?void 0:i.inflate;t?(this.initialInflate=this.align.inflate,this.align.inflate=t):this.align.inflate=this.initialInflate}updateTarget(i){i instanceof Element&&(this.forElement=i)}changeHighlighter(i,e){if(i)return z.reconfigure(e,z.mergeConfigs({owner:this},i),this);e==null||e.destroy()}async updateForElement(i){const e=this,{autoNext:t,owner:r,index:n}=e;if(e.syncTargetHighlighting(),e.clearTimeout("hide"),e.hidden=!1,e.showBy({target:e.align.target||e.forElement}),!e.element.matches(":focus-within")&&e.focus(),t)switch(typeof t){case"number":e.setTimeout(()=>r.navigate(1),t);break;case"string":if(await yt.sleep(500),e.index===n){const s=await(e.autoNextPromise=r.normalizeTarget(t,!1));e.autoNextPromise=null,s&&r.navigate(1,!1)}break;case"function":await yt.waitFor(t,1e4),r.navigate(1,!1)}}syncTargetHighlighting(){if(!this.isVisible)return;const i=this,{highlightTarget:e,highlighter:t,forElement:r}=i,{classList:n}=i.element,s={"--b-hint-highlight-color":""},a=t==null?void 0:t.element,o=a==null?void 0:a.classList,l=e==null?void 0:e.inflate;if(o==null||o.remove("b-hint-highlighter-ping","b-hint-highlighter-center"),n[i.scrollRealigning?"add":"remove"]("b-scroll-realigning"),r){const{style:d}=i.floatRoot,c=r.ownerDocument.defaultView.getComputedStyle(r),u=E.isInView(r,!1,this),h=e!=null&&e.center?u.center.inflate(10):u;if(l&&h.inflate.apply(h,Array.isArray(l)?l:[l]),e&&!(e!=null&&e.center))for(const f of["top","bottom"])for(const g of["left","right"]){const m=c.getPropertyValue(`border-${f}-${g}-radius`);s[`border-${f}-${g}-radius`]=parseInt(m)?m:""}typeof(e==null?void 0:e.center)=="string"&&(s["--b-hint-highlight-color"]=e.center),d.setProperty("--b-highlight-top",`${h.top}px`),d.setProperty("--b-highlight-left",`${h.x}px`),d.setProperty("--b-highlight-width",`${h.width}px`),d.setProperty("--b-highlight-height",`${h.height}px`)}e&&(o[i.scrollRealigning?"add":"remove"]("b-realigning"),E.applyStyle(a,s),t.show(),e.ping&&j.onTransitionEnd({element:a,property:"inset-inline-start",once:!0,thisObj:i,timeout:500,handler:()=>{o.add("b-hint-highlighter-ping")}}),e.center&&o.add("b-hint-highlighter-center")),i.requestAnimationFrame(()=>{n.remove("b-scroll-realigning"),o.remove("b-realigning")})}next(){this.index<this.owner.hints.length-1&&this.owner.navigate(1)}previous(){this.index&&this.owner.navigate(-1)}stop(){this.owner.stop()}};p(gr,"$name","Hint"),p(gr,"type","hint"),p(gr,"configurable",{ui:"plain",defaultFocus:i=>!i.hidden&&(i.ref==="next"||i.ref==="stop"),align:{align:"t-b",allowTargetOut:!0},anchor:!0,autoShow:!1,autoClose:!1,centered:!1,allowOver:!0,closable:!0,minWidth:"max-content",closeAction:"stop",previousAction:null,nextAction:null,keyMap:{P:"previous",N:"next",S:"stop"},buttons:null,maxWait:1e4,highlightTarget:null,highlighter:{$config:["lazy","nullify"],value:{floating:!0,cls:"b-hint-highlighter"}},autoNext:null,target:null}),gr.initClass(),gr._$name="Hint";var HR=(i,e)=>({previous:{weight:100,text:"L{Object.previous}",cls:"b-raised b-previous",hidden:!i,onClick:"up.onHintButtonClick"},next:{weight:100,text:"L{Object.next}",cls:"b-raised b-blue b-next",hidden:i===e-1,onClick:"up.onHintButtonClick"},stop:{weight:300,text:"L{Object.close}",cls:"b-raised b-red b-stop",hidden:i!==e-1,onClick:"up.onHintButtonClick"}}),VR=/\[(?:([\w+]+)\+)?(\w+)\]|./g,$b=class extends O.mixin(je,Ie,be){constructor(){super(...arguments),p(this,"waitInterval",100),p(this,"maxWait",1e4),p(this,"keyStrokeIntervalRandomness",100)}onHintButtonClick({source:i}){const e=this;switch(i.ref){case"next":e.navigate(1);break;case"previous":e.navigate(-1);break;case"stop":e.stop();break;case"completed":e.trigger("completed"),e.stop();break}}async fakeType(i){var e;let{target:t,text:r,initialDelay:n=0,focus:s}=i;typeof i=="string"&&(t=document.activeElement,r=i),s!==!1&&this.activeHint.revertFocus(),t?(t=await this.normalizeTarget(t),s!==!1&&t.focus()):t=E.getActiveElement(this.activeHint.element),i.clear&&(t.value=""),await yt.sleep(n);for(let a=VR.exec(r);a;a=VR.exec(r)){if(a[2]){const o=(((e=a[1])==null?void 0:e.split("+"))||[]).reduce((d,c)=>(d[`${c.toLowerCase()}Key`]=!0,d),{}),l={key:a[2],bubbles:!0,...o};t.dispatchEvent(new KeyboardEvent("keydown",l)),t.dispatchEvent(new KeyboardEvent("keyup",l))}else t.value+=a[0],t.dispatchEvent(new Event("input",{data:a[0]}));await yt.sleep(Math.random()*this.keyStrokeIntervalRandomness+30)}t.dispatchEvent(new Event("change"))}normalizeTarget(i,e=this.maxWait){return E.waitForSelector(i,e,this.waitInterval)}navigate(i,e=!0){this.navigationOngoing||(this.navigationOngoing=new Promise(async t=>{const r=this,{activeHint:n}=r,s=r.activeIndex+i,a=ce.ion({mouseup:({event:l})=>r.squashDocumentEvents(l)}),o=j.on({element:document,mousedown:"squashDocumentEvents",keydown:"squashDocumentEvents",thisObj:r,capture:!0});try{if(n.masked=!0,r.allowInteraction=!1,e){const l=r.processActions(r.activeHint[i===1?"nextAction":"previousAction"]);if(await yt.animationFrame(),r.normalizeTarget(n.target,-1).nodeType!==1){const d=r.normalizeTarget(r.hints[s].target,-1);(d==null?void 0:d.nodeType)===1?n.target=d:E.applyStyle(n.floatRoot,{"--b-highlight-width":"0px","--b-highlight-height":"0px"})}await l}r.activeIndex=s,await r.activeIndexUpdated,r.navigationOngoing=null,n.masked=!1}finally{a==null||a(),o==null||o(),r.navigationOngoing&&(r.navigationOngoing=null,n.element.classList.remove("b-no-title"),n.hide(!1),gr.reconfigure(n,{hidden:!1,masked:!1,centered:!0,title:"Navigation timed out",content:"Navigation could not be completed.",nextAction:null,bbar:{items:HR(0,1)}})),t()}}))}squashDocumentEvents(i){i.isTrusted&&(this.activeHint.element.contains(i.target)||!this.allowInteraction)&&(i.preventDefault(),i.stopImmediatePropagation())}async processActions(i){var e;const t=this;if(i)if(Array.isArray(i))for(const r of i)await t.processActions(r);else for(const[r,n]of Object.entries(i))switch(r){case"type":await t.fakeType(n);break;case"dblclick":case"click":case"contextmenu":{const s=typeof n=="string",a=await t.normalizeTarget(s?n:n.target),o=!s&&n.focus;if(o){const l=E.getActiveElement(a);!E.triggerMouseEvent(a,"mousedown").defaultPrevented&&E.getActiveElement(a)===l&&((e=E.closest(a,E.isFocusable))==null||e.focus())}E.triggerMouseEvent(a,r),o&&E.triggerMouseEvent(a,"mouseup")}break;case"fn":await t.activeHint.callback(n,t.activeHint);break;case"drag":await t.drag(n);break;case"waitFor":isNaN(n)?await t.normalizeTarget(n):await yt.sleep(n);break;case"allowInteraction":t.allowInteraction=n;break}}async drag({target:i=this.activeHint.target,by:[e,t],duration:r=500}){const n=await this.normalizeTarget(i),{ownerDocument:s}=n,{activeHint:a}=this,{modalMask:o}=a,{x:l,y:d}=$.from(n).center.roundPx(1),c=E.createElement({parent:s.body,className:"b-mouse-pointer b-icon b-fa-mouse-pointer",style:{left:`${l}px`,top:`${d}px`}}),u={clientX:l,clientY:d,bubbles:!0},{style:h}=a.floatRoot;o&&(o.style.pointerEvents="none",h.setProperty("--b-highlight-width","0px"),h.setProperty("--b-highlight-height","0px"));let f,g;n.dispatchEvent(new PointerEvent("pointerover",u)),n.dispatchEvent(new MouseEvent("mouseover",u)),n.dispatchEvent(new PointerEvent("pointerdown",u)),n.dispatchEvent(new MouseEvent("mousedown",u)),await yt.animationFrame(),await we.animate(r,async m=>{u.clientX=l+e*m,u.clientY=d+t*m,o.style.pointerEvents="none",f=s.elementFromPoint(u.clientX,u.clientY),c.style.cssText=`left:${u.clientX}px;top:${u.clientY}px`,f.dispatchEvent(new PointerEvent("pointermove",u)),f.dispatchEvent(new MouseEvent("mousemove",u)),f!==g&&(f.dispatchEvent(new PointerEvent("pointerenter",u)),f.dispatchEvent(new MouseEvent("mouseenter",u)),f.dispatchEvent(new PointerEvent("pointerover",u)),f.dispatchEvent(new MouseEvent("mouseover",u)),g=f),o.style.pointerEvents=""}),h.setProperty("--b-highlight-top",`${u.clientY}px`),h.setProperty("--b-highlight-left",`${u.clientX}px`),f.dispatchEvent(new PointerEvent("pointerup",u)),f.dispatchEvent(new MouseEvent("mouseup",u)),c.remove()}async updateActiveIndex(i,e){var t,r;const n=this,{hints:s,activeHint:a}=n,o=s.length,l=s[i];if((t=a==null?void 0:a.autoNextPromise)==null||t.resolve(),l){const d=await n.normalizeTarget(l.target);let{align:c}=l;if(typeof(c==null?void 0:c.target)=="string"&&(c={...c,target:await n.normalizeTarget(c.target)}),d===!1){n.activeIndex=++i;return}a?(typeof l.target=="string"&&(a._target=a._forElement=null),a.bbar.element.matches(":focus-within")&&a.element.focus()):n.returnFocusTo=E.getActiveElement();const u={steps:{type:"widget",content:`${i+1}/${o}`,weight:-1e3},completed:{text:n.L("L{Hint.dontShowAgain}"),cls:"b-transparent",weight:10,onClick:"up.onHintButtonClick"},...T.merge(HR(i,o),Array.isArray(l.buttons)?T.transformArrayToNamedObject(l.buttons):l.buttons)},h=n.activeHint=gr.reconfigure(a,gr.mergeConfigs(n.defaults,{index:i,hintFlow:n,owner:n,maxWait:n.maxWait,rootElement:document.body},l,{target:d,buttons:u,[typeof(c==null?void 0:c.target)=="string"?"align":"_"]:c}));n.owner=gr.fromElement(d),h.element.classList.toggle("b-no-title",!l.title),await Promise.all([h.highlighter.element.isConnected&&E.waitForSelector(h.highlighter.element,-1e3),E.waitForSelector(h.element,-1e3)]),h.isVisible&&((r=h.bbar.widgetMap[i===o-1?"stop":i&&i<e?"previous":"next"])==null||r.focus())}else n.stop()}async stop(){var i;const e=this;e.activeIndex===e.hints.length-1&&await e.processActions(e.activeHint.nextAction),e.activeHint.owner=null,bryntum.queryAll("hint").forEach(t=>t.hintFlow===e&&t.destroy()),e.activeHint=null,(i=e.returnFocusTo)==null||i.focus()}};p($b,"configurable",{activeIndex:0,hints:null,defaults:{type:"hint",align:{allowTargetOut:!0},closable:!0,draggable:!1,buttons:{},autoNext:null,nextAction:null,previousAction:null,minWidth:null,trapFocus:!0,title:new String("")}}),$b._$name="HintFlow";var jR=class HF extends Ie(O){static get configurable(){return{date:{$config:{equal:"date"},value:S.clearTime(new Date)},month:null,year:null,weekStartDay:null,hideNonWorkingDays:null,nonWorkingDays:null,sixWeeks:null}}configure(e){super.configure(e),this.updateDayNumbers(),e.date&&(this.date=e.date),this.generation=0}changeDate(e){if(!this.isConfiguring){if(e=typeof e=="string"?S.parse(e,"YYYY-MM-DD"):new Date(e),isNaN(e))throw new Error("Month date ingestion must be passed a Date, or a valid YYYY-MM-DD date string");return e}}updateDate(e,t){const r=this,{dayColumnIndex:n,weekCount:s}=r,a=S.getFirstDateOfMonth(e),o=S.getLastDateOfMonth(a),l=n[a.getDay()],d=n[o.getDay()],c=!t||e.getFullYear()!==t.getFullYear(),u=!t||e.getMonth()!==t.getMonth(),h=r.eventListeners&&(t?e.getDate()!==t.getDate()|(r.getWeekId(e)!==r.getWeekId(t))<<1|u<<2|c<<3:15);if(r._year=e.getFullYear(),r._month=e.getMonth(),r.startDayOfMonth=1-l,r.endDayOfMonth=o.getDate()+(6-d),r.sixWeeks&&(r.endDayOfMonth+=(6-r.weekCount)*7),(!r.weekBase||c)&&r.calculateWeekBase(),(u||c)&&r.generation++,h){const f={newDate:e,oldDate:t,changes:{d:!0,w:!!(h&2),m:!!(h&12),y:!!(h&8),r:r.weekCount!==s}};r.trigger("dateChange",f),h&2&&r.trigger("weekChange",f),h&12&&r.trigger("monthChange",f),h&8&&r.trigger("yearChange",f)}}calculateWeekBase(){const e=this,{dayColumnIndex:t}=e,r=new Date(e.year,0,1),n=new Date(e.year,11,31),s=e.month?e.getOtherMonth(r):e;e.dayColumnIndex[r.getDay()]>3?e.weekBase=s.startDate:e.weekBase=new Date(e.year,0,s.startDayOfMonth-7);const a=Math.floor(S.diff(e.weekBase,n,"day")/7);e.has53weeks=a===53&&t[n.getDay()]>2}getWeekStart(e){if(typeof e=="number")return S.add(this.weekBase,Math.max(e,1)*7,"day");const t=this,[r,n]=e;return r===t.year?t.getWeekStart(n):t.getOtherMonth(new Date(r,0,1)).getWeekStart(n)}getOtherMonth(e){const t=this,r=t===zR?new HF(null):zR;return r.configure({weekBase:null,weekStartDay:t.weekStartDay,nonWorkingDays:t.nonWorkingDays,hideNonWorkingDays:t.hideNonWorkingDays,sixWeeks:t.sixWeeks,date:new Date(e.getFullYear(),0,1)}),r.date=e,r.updateDate(r.date,r.date),r}changeYear(e){const t=new Date(this.date);t.setFullYear(e),this.date=t}changeMonth(e){const t=new Date(this.date);t.setMonth(e),this.date=t}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:S.weekStartDay}updateWeekStartDay(){const e=this;e.updateDayNumbers(),!e.isConfiguring&&e.date&&(e.weekBase=null,e.updateDate(e.date,e.date))}get nonWorkingDays(){return this._nonWorkingDays||S.nonWorkingDays}changeNonWorkingDays(e){return T.assign({},e)}updateNonWorkingDays(){this.updateDayNumbers()}updateHideNonWorkingDays(){this.updateDayNumbers()}updateSixWeeks(){this.isConfiguring||this.updateDate(this.date,this.date)}get dayCount(){return this.endDayOfMonth+1-this.startDayOfMonth}get weekCount(){return this.dayCount/7}get startDate(){const e=this;if(e.year!=null&&e.month!=null&&e.startDayOfMonth!=null)return new Date(e.year,e.month,e.startDayOfMonth)}get endDate(){const e=this;if(e.year!=null&&e.month!=null&&e.startDayOfMonth!=null)return new Date(e.year,e.month,e.endDayOfMonth)}get firstDate(){const e=this;if(e.year!=null&&e.month!=null&&e.startDayOfMonth!=null)return new Date(e.year,e.month,1)}get lastDate(){const e=this;if(e.year!=null&&e.month!=null&&e.startDayOfMonth!=null)return new Date(e.year,e.month+1,0)}eachDay(e){for(let t=this.startDayOfMonth;t<=this.endDayOfMonth;t++)e(new Date(this.year,this.month,t))}eachWeek(e){const t=this,{weekCount:r}=t;for(let n=t.startDayOfMonth,s=0;s<r;s++){const a=[],o=t.getWeekNumber(new Date(t.year,t.month,n));for(let l=0;l<7;l++,n++)a.push(new Date(t.year,t.month,n));e(o,a,s,s===r-1)}}getWeekNumber(e){const t=this;if(e=S.clearTime(e),e.getFullYear()!==t.year)return t.getOtherMonth(new Date(e.getFullYear(),0,1)).getWeekNumber(e);let r=Math.floor(S.diff(t.weekBase,e,"day")/7),n=e.getFullYear();if(r)r===53&&!t.has53weeks?(r=1,n++):r>53&&(r=r%52);else return t.getOtherMonth(new Date(t.year-1,0,1)).getWeekNumber(new Date(t.year,0,0));return[n,r]}getWeekId(e){const t=this.getWeekNumber(e);return t[0]*100+t[1]}getCellData(e,t,r=ji.MIDNIGHT){const n=this,s=e.getDay(),a=n.visibleDayColumnIndex[s],o=n.nonWorkingDays[s],l=n.hideNonWorkingDays&&o;return(e<n.startDate||e>n.endDate)&&(n.month=e.getMonth()),{day:s,dayTime:r,visibleColumnIndex:a,isNonWorking:o,week:n.getOtherMonth(e).getWeekNumber(e),key:S.format(e,"YYYY-MM-DD"),columnIndex:n.dayColumnIndex[s],date:new Date(e),dayEnd:r.duration("s"),tomorrow:r.dayOfDate(S.add(e,1,"day")),isOtherMonth:Math.sign(e.getMonth()+e.getFullYear()*12-(t.month+t.year*12)),visible:!l&&e>=t.startDate&&e<S.add(t.endDate,1,"day"),isRowStart:a===0,isRowEnd:a===n.visibleColumnCount-1}}updateDayNumbers(){const e=this,{weekStartDay:t,nonWorkingDays:r,hideNonWorkingDays:n}=e,s=e.dayColumnIndex=[],a=e.canonicalDayNumbers=[],o=e.visibleDayColumnIndex=[];let l=0;for(let d=0;d<7;d++){const c=(t+d)%7;a[d]=c,s[c]=d,(!n||!r[c])&&(o[c]=l++)}e.visibleColumnCount=l,e.weekLength=n?7-T.keys(r).length:7}};p(jR,"$name","Month");var Yo=jR,zR=new Yo(null);Yo._$name="Month";var p$=0,NR=new WeakMap,v$=(...i)=>i.map(e=>{let t;return e&&typeof e=="object"||typeof e=="function"?(t=NR.get(e),t===void 0&&(t=++p$,NR.set(e,t))):t=String(e),t}).join("-"),Fn=i=>{const e=new Map;return(...t)=>{const r=v$(t);let n=e.get(r);return n===void 0&&(n=i(...t),e.set(r,n)),n}},zu=i=>{const e=new Map,t=c=>c[0],r=c=>c[1],n=(c,u)=>t(c).push(u),s=(c,u)=>r(c).push(u),a=(c,u)=>r(c).some(h=>T.isEqual(h,u)),o=()=>[[],[]],l=c=>!r(c).length&&!t(c).length,d=c=>{let u=e.get(c);return u===void 0&&(u=o(),e.set(c,u)),u};return(c,u)=>{const h=d(c);l(h)?(n(h,u),i(c,f=>{a(h,f)||(s(h,f),t(h).forEach(g=>g(f)))})):(n(h,u),r(h).forEach(f=>u(f)))}},WR=Symbol("success"),y$=Symbol("failure"),Sm=(i,e)=>[WR,i,e],Bb=i=>[y$,i],Hb=i=>i.length&&i[0]===WR,Nu=i=>typeof i=="function"&&!i.length?i():i,wm=Fn(i=>zu((e,t)=>t(Sm(i,e)))),b$=Fn(i=>zu((e,t)=>{const r=Math.min(i.length,e.length),n=e.substr(0,r),s=e.substr(r);t(n===i?Sm(n,s):Bb(s))})),Dm=(i,e)=>(t,r)=>Nu(i)(t,n=>{if(Hb(n)){const[,s,a]=n;e(s)(a,r)}else r(n)}),C$=Fn((...i)=>{const e=Fn((t,r)=>zu(Dm(t,n=>Dm(r,s=>wm([].concat(n,s))))));return i.reduce(e,wm([]))}),S$=Fn((...i)=>zu((e,t)=>i.forEach(r=>Nu(r)(e,t)))),w$=Fn(i=>(e,t)=>{const r=new RegExp(`^${i}`),n=r.exec(e);if(n){const s=n[0],a=e.substr(s.length);t(Sm(s,a))}else t(Bb(e))}),D$=Fn((i,e)=>Dm(i,(...t)=>wm(e(...[].concat.apply([],t))))),UR=(i,e)=>{const t=[];return i(e,r=>{if(Hb(r)){const[,,n]=r;n===""&&t.push(r)}}),t},E$=i=>(e,t)=>t?Nu(i)(e,t):UR(Nu(i),e),x$={memo:Fn,memoCps:zu,success:Sm,failure:Bb,isSuccess:Hb,resolveParser:Nu,succeed:wm,string:b$,bind:Dm,seq:C$,alt:S$,regexp:w$,red:D$,runParser:UR,defineParser:E$},Em=class extends O.mixin(be,Ie){static get configurable(){return{element:null,zoneWidth:50,scrollSpeed:5,direction:"both",startScrollDelay:500,stopScrollWhenPointerOut:!1,testConfig:{scrollSpeed:2,startScrollDelay:100},activeScroll:{$config:["lazy"],value:{}},monitoring:{$config:["lazy","nullify"],value:!0},owner:null}}changeMonitoring(i,e){return e==null||e.clear(),new Map}doDestroy(){this.stopMonitoring(),super.doDestroy()}get isScrolling(){return Object.keys(this.activeScroll).length!==0}get rtl(){var i;return(i=this.owner)==null?void 0:i.rtl}startMonitoring(i={}){const e=this,{element:t,direction:r}=e,{scrollables:n=[],direction:s=r,callback:a}=i,o=[];return n.length||n.push({element:t}),n.forEach(l=>{const d=l.element;typeof d=="string"?E.forEachSelector(t,d,c=>{e.createMonitor(c,l.direction||s,l.callback||a),o.push(c)}):(e.createMonitor(d,l.direction||s,l.callback||a),o.push(d))}),function(){var d;(d=e.stopMonitoring)==null||d.call(e,o)}}createMonitor(i,e,t){const{monitoring:r}=this;r.has(i)||r.set(i,new R$({scrollManager:this,element:i,direction:e,callback:t}))}stopMonitoring(i){const e=this,{monitoring:t}=e;if(i=L.asArray(i),t){if(!i){t.forEach(r=>e.stopMonitoring(r.element));return}i.forEach(r=>{const n=t.get(r);r.classList.remove("b-scrolling"),n&&(n.destroy(),t.delete(r))})}}requestScroll(i,e){const{activeScroll:t}=this;return i in t&&t[i]!==e?!1:(t[i]=e,!0)}releaseScroll(i){const{activeScroll:e={}}=this;Object.keys(e).forEach(t=>{e[t]===i&&delete e[t]})}getRelativeScroll(i,e="left"){let t=0;return this.monitoring.forEach((r,n)=>{E.isDescendant(n,i)&&(t+=e==="left"?r.scrollRelativeLeft:r.scrollRelativeTop)}),t}},R$=class extends O{construct(i){const e=this,{element:t}=i,r=t.scrollLeft,n=t.scrollTop;Object.assign(i,{startScrollLeft:r,startScrollTop:n}),super.construct(i),j.on({element:t,scroll:"onElementScroll",pointermove:"onMouseMove",capture:!0,thisObj:e}),j.on({element:t,pointerleave:"onPointerLeave",thisObj:e})}doDestroy(){this.stopScroll(!0),super.doDestroy()}startScroll(){const i=this;i.pendingScrollFinalize&&(i.scrollManager.releaseScroll(i),i.pendingScrollFinalize=!1),i.scrolling=!0,i.performScroll()}stopScroll(i=null){const e=this,t=()=>{e.pendingScrollFinalize=!1,e.isDestroyed||(e.scrollManager.releaseScroll(e),e.scrolling=!1)};e.scrollRequested&&(e.scrollManager.cancelAnimationFrame(e.frameId),e.scrollRequested=!1),e.scrollManager.clearTimeout(e.scrollTimeout),e.scrollTimeout=null,!i&&(e.ongoingScrollTop||e.ongoingScrollLeft)?(e.pendingScrollFinalize=!0,Promise.all([e.ongoingScrollTop,e.ongoingScrollLeft].filter(Boolean)).then(()=>e.pendingScrollFinalize&&t())):(e.ongoingScrollTop=e.ongoingScrollLeft=null,t())}onPointerLeave(){this.scrollManager.stopScrollWhenPointerOut&&this.stopScroll()}onMouseMove(i){const e=this,{scrollManager:t}=e,r=e.element.getBoundingClientRect(),n=t.zoneWidth,s=t.scrollSpeed;if(e.scrollDeltaX=e.scrollDeltaY=0,e.direction!=="vertical"){const{scrollLeft:a,scrollWidth:o,clientWidth:l}=e.element;t.rtl?i.clientX<r.left+n&&o+a-l>=1?e.scrollDeltaX=-Math.round((n+(r.left-i.clientX))/s)-1:i.clientX>r.right-n&&a<0&&(e.scrollDeltaX=Math.round((n-(r.right-i.clientX))/s)+1):i.clientX>r.right-n&&o-a-l>=1?e.scrollDeltaX=Math.round((n-(r.right-i.clientX))/s)+1:i.clientX<r.left+n&&a>0&&(e.scrollDeltaX=-Math.round((n+(r.left-i.clientX))/s)-1)}if(e.direction!=="horizontal"){const{scrollTop:a,scrollHeight:o,clientHeight:l}=e.element;i.clientY>r.bottom-n&&o-a-l>=1?e.scrollDeltaY=Math.round((n-(r.bottom-i.clientY))/s)+1:i.clientY<r.top+n&&a>0&&(e.scrollDeltaY=-Math.round((n+(r.top-i.clientY))/s)-1)}e.scrollDeltaX!==0&&!t.requestScroll("horizontal",e)&&(e.scrollDeltaX=0),e.scrollDeltaY!==0&&!t.requestScroll("vertical",e)&&(e.scrollDeltaY=0),e.scrollDeltaX===0&&e.scrollDeltaY===0?e.scrolling&&e.stopScroll():e.scrollTimeout||(e.scrollTimeout=t.setTimeout(()=>e.startScroll(),t.startScrollDelay))}performScroll(){const i=this,{element:e,scrollManager:t}=i;if(i.scrolling&&!i.scrollRequested){if(i.scrollDeltaX!==0){const r=e.scrollLeft,n=Math.min(r+i.scrollDeltaX,e.scrollWidth-e.clientWidth);e.scrollLeft=n,e.scrollLeft!==r?i.ongoingScrollLeft=new Promise(s=>e.addEventListener("scroll",a=>{var o;(o=t.trigger)==null||o.call(t,"scroll",{event:a,deltaY:i.scrollDeltaY,deltaX:i.scrollDeltaX}),s()},{once:!0})):(i.ongoingScrollLeft=null,i.scrollDeltaX=0)}if(i.scrollDeltaY!==0){const r=e.scrollTop,n=Math.min(r+i.scrollDeltaY,e.scrollHeight-e.clientHeight);e.scrollTop=n,e.scrollTop!==r?i.ongoingScrollTop=new Promise(s=>e.addEventListener("scroll",a=>{var o;(o=t.trigger)==null||o.call(t,"scroll",{event:a,deltaY:i.scrollDeltaY,deltaX:i.scrollDeltaX}),s()},{once:!0})):(i.ongoingScrollTop=null,i.scrollDeltaY=0)}i.scrollDeltaX!==0||i.scrollDeltaY!==0?(i.scrollRequested=!0,i.frameId=i.scrollManager.requestAnimationFrame(()=>{i.scrollRequested=!1,i.performScroll(i)})):i.stopScroll()}}onElementScroll(){var i,e;(e=(i=this.config)==null?void 0:i.callback)==null||e.call(this.thisObj||this.scrollManager,this)}get scrollLeft(){return this.element.scrollLeft}get scrollTop(){return this.verticalElement?this.verticalElement.scrollTop:this.element.scrollTop}get scrollRelativeLeft(){return this.scrollLeft-this.startScrollLeft}get scrollRelativeTop(){return this.scrollTop-this.startScrollTop}getRelativeLeftScroll(i){return this.scrollManager.getRelativeScroll(i,"left")}getRelativeTopScroll(i){return this.scrollManager.getRelativeScroll(i,"top")}};Em._$name="ScrollManager";var T$={left:!0,right:!0,top:!0,bottom:!0,transform:!0},M$={true:1,false:1},I$=Promise.resolve(),Vb=class gn extends Tt{static get configurable(){return{autoHide:!0,mouseOffsetX:15,mouseOffsetY:15,html:{$config:{equals:()=>!1}},getHtml:null,forElement:null,trackMouse:null,updateContentOnMouseMove:!1,forSelector:null,hideOnDelegateChange:null,anchorToTarget:!0,showOnHover:null,hoverDelay:500,autoShow:!1,dismissDelay:0,hideDelay:500,loadingMsg:"Loading...",allowOver:null,anchor:!0,draggable:!1,align:{align:"b-t",minHeight:300},axisLock:!0,activeTarget:{$config:{equal:(e,t)=>e==null&&t==null||e===t},value:null},testConfig:{hideDelay:100,hoverDelay:100,showAnimation:null,hideAnimation:null},role:"tooltip",describedElement:null}}afterConfigure(){const e=this,{forSelector:t}=e;t&&(e.showOnHover=e.showOnHover!==!1,e.forElement||(e.anchorToTarget||(e.trackMouse=!0),e.forElement=e.rootElement.host||e.rootElement)),super.afterConfigure(),e.forElement&&e.showOnHover&&(e.pointerOverOutDetacher=j.on({element:e.forElement,pointerover:"internalOnPointerOver",pointerout:"internalOnPointerOut",thisObj:e}))}doDestroy(){var e;(e=this.pointerOverOutDetacher)==null||e.call(this),super.doDestroy()}set focusOnToFront(e){super.focusOnToFront=e}get focusOnToFront(){var e;return((e=this.triggeredByEvent)==null?void 0:e.pointerType)==="focus"?!1:super.focusOnToFront&&E.usingKeyboard}get focusElement(){const e=super.focusElement;if(e!==this.element)return e}get anchorToTarget(){return this._anchorToTarget&&!this.trackMouse}get anchor(){return super.anchor&&!this.trackMouse}set anchor(e){super.anchor=e}onDocumentMouseDown({event:e}){var t;const r=this,{triggeredByEvent:n}=r;n&&E.isTouchEvent&&e.pageX===n.pageX&&e.pageY===n.pageY&&(t=r.activeTarget)!=null&&t.contains(e.target)&&performance.now()-n.timeStamp<500||(r.abortDelayedShow(),super.onDocumentMouseDown({event:e}))}internalOnPointerOver(e){const t=this,{target:r,relatedTarget:n}=e,{forElement:s,forSelector:a,activeTarget:o}=t;let l;if(!(t.disabled||t.owner&&!t.owner.showTooltipWhenDisabled&&t.owner.disabled)&&!(t.allowOver&&t.element.contains(r))){if(a){const d=e.target.closest("[data-btip]");if(d&&!d.matches(a)){o&&t.handleForElementOut();return}if(l=t.filterTarget(e),!t.hasTimeout("hide")&&(o!=null&&o.contains(r))&&o.contains(n)&&l===o||l&&(n==null?void 0:n.closest(a))===l&&!n.dataset.btip)return}else if(!s.contains(n))l=s;else return;l?t.handleForElementOver(e,l):o&&t.handleForElementOut()}}filterTarget({target:e}){return e.closest(this.forSelector)}realignOnTransitionEnd(e){var t;const r=this,{currentOverElement:n}=gn;if(T$[e.propertyName]){if(r.allowOver&&r.element.contains(n))return;(t=r.activeTarget)!=null&&t.contains(n)&&!r.trackMouse&&r.realign()}}async handleForElementOver(e,t){const r=this,{activeTarget:n,hideOnDelegateChange:s,anchorToTarget:a}=r,o=t!==n,l=o&&s;if(r.trigger("pointerOver",{event:e,target:t})===!1)r.internalOnPointerOut(e);else{if(r.triggeredByEvent=e,r.hasTimeout("hide")&&(r.abortDelayedHide(),!o))return;if(!s&&r.element.classList.contains("b-hiding")&&r.cancelHideShowAnimation(),!r._hidden&&l&&r.hide(!1),r.activeTarget&&r.hasTimeout("show")&&r.clearTimeout("show"),r.activeTarget=t,r.activeTarget!==t){r.internalOnPointerOut(e);return}if(r.isVisible){r.lastAlignSpec=null;const d=r.updateContent();if(X.isPromise(d)&&!r.loadingMsg&&await d,r.trigger("beforeShow")===!1)return r.hide();r.alignTo({[a?"target":"position"]:a?t:"mouse",overlap:!(a&&r.anchor)}),r.trigger("show"),r.afterShowByTarget()}else r.activeTarget=t,r.delayShow(t)}}async delayShow(e){var t;const r=this;if((t=r.currentAnimation)!=null&&t.showing&&r.cancelHideShowAnimation(),!r.isVisible&&!r.hasTimeout("show"))if(!r.hoverDelay||r.forSelector&&Date.now()-r.lastHidden<r.quickShowInterval){const n=r.updateContent();X.isPromise(n)&&!r.loadingMsg&&await n,r.showByTarget(e)}else r.addDocumentMouseDownListener(),!r.listeningForMouseMove&&!r.anchorToTarget&&(r.mouseMoveRemover=j.on({element:r.rootElement,mousemove:"onMouseMove",thisObj:r})),r.setTimeout(async()=>{if(r.activeTarget===e&&e.isConnected){const n=r.updateContent();X.isPromise(n)&&!r.loadingMsg&&await n,r.showByTarget(e)}},!r.triggeredByEvent||r.triggeredByEvent.type==="pointerover"?r.hoverDelay:0,"show");else r.isVisible&&r.showByTarget(e)}changeAllowOver(e){return this.inAfterShow||(this.configuredAllowOver=e),e}updateAllowOver(e){var t;const r=this,{element:n}=r;n.classList.toggle("b-allow-over",!!e),e?r.allowOverlisteners=j.on({element:n,mouseenter:"onOwnElementMouseEnter",mouseleave:"internalOnPointerOut",thisObj:r}):(t=r.allowOverlisteners)==null||t.call(r)}updateContent(){const e=this;if(e.getHtml){const t=e.callback(e.getHtml,e,[{tip:e,element:e.element,activeTarget:e.activeTarget,event:e.triggeredByEvent}]);return e.html=t,t}}get hasContent(){return!!(E.isVueConfig(this._html)||E.isReactElement(this._html)||this._html!==""&&typeof this.html=="string"&&this.html.length||this.items.length)}internalBeforeShow(){const e=this;return e.isSharedTooltip&&xi.dragging?!1:(e.updateContentOnMouseMove||e.hasContent)&&!e.disabled}showAsyncMessage(e=this.optionalL(this.loadingMsg)){e&&(this.html=`
                <div class="b-tooltip-loading">
                    <i class="b-icon b-icon-spinner"></i>
                    ${k.encodeHtml(e)}
                </div>
            `)}showByTarget(e){var t;const r=this,{anchorToTarget:n}=r;r.mouseMoveRemover=(t=r.mouseMoveRemover)==null?void 0:t.call(r),r.showBy({[n?"target":"position"]:n?e:"mouse",overlap:!(n&&r.anchor)})}afterShowByTarget(){const e=this,{dismissDelay:t,activeTarget:r}=e,n=E.getActiveElement(e.activeTarget);e.abortDelayedShow(),t&&e.setTimeout("hide",t),e.element.parentNode&&e.toFront(),!e.mouseMoveRemover&&(e.trackMouse||e.updateContentOnMouseMove)&&(e.mouseMoveRemover=j.on({element:e.rootElement,pointermove:"onMouseMove",thisObj:e})),e.describedElement=r!=null&&r.contains(n)?n:null,e.inAfterShow=!0,e.allowOver=e.allowOver||e.configuredAllowOver!=!1&&e.childItems.some(s=>s.isVisible&&!s.disabled&&s.focusElement),e.inAfterShow=!1}changeActiveTarget(e,t){const r=this;if(e){if(!r.isConfiguring&&r.trigger("overTarget",{newTarget:e,lastTarget:t})===!1)return}else r.trigger("targetOut",{lastTarget:t});return e}updateDescribedElement(e,t){const{titleElement:r}=this,n=r&&E.getId(r),s=E.getId(this.contentElement);e&&e.getAttribute("aria-label")!==this.html&&(n&&E.addAttributeValue(e,"aria-describedby",n),E.addAttributeValue(e,"aria-describedby",s)),t&&(n&&E.removeAttributeValue(t,"aria-describedby",n),E.removeAttributeValue(t,"aria-describedby",s))}internalOnPointerOut(e){var t;const r=this,n=e.type==="pointerover"?e.target:e.relatedTarget;r.allowOver&&(r.element.contains(n)||r.owns(n,!0))||r.element.contains(n)&&((t=r.activeTarget)!=null&&t.contains(n))||r.activeTarget&&!r.activeTarget.contains(n)&&r.handleForElementOut()}handleForElementOut(){const e=this,{hideDelay:t}=e;if(e.trigger("pointerOut")===!1)return e.activeTarget=null,!0;e.abortDelayedShow(),e.isVisible&&t!==!1&&(e.abortDelayedHide(),t>0?e.setTimeout("hide",t):e.hide())}show(e,...t){const r=this;!e&&r.forElement&&r.anchorToTarget&&!r.forSelector?r.showByTarget(r.forElement):super.show(e,...t),r.isVisible?r.afterShowByTarget():r.activeTarget=null}get hoverDelay(){var e;return((e=this.triggeredByEvent)==null?void 0:e.pointerType)==="focus"?0:this._hoverDelay}get hideDelay(){var e;return((e=this.triggeredByEvent)==null?void 0:e.pointerType)==="focus"?0:this.autoHide?this._hideDelay:!1}hide(...e){var t,r;const n=this;if(n.abortDelayedShow(),n._hidden)return I$;{n.abortDelayedHide();const s=super.hide(...e);return n.lastHidden=Date.now(),n.activeTarget=null,(t=n.mouseMoveRemover)==null||t.call(n),n.mouseMoveRemover=null,(r=n.transitionEndDetacher)==null||r.call(n),n.transitionEndDetacher=null,n.describedElement=null,s}}abortDelayedShow(){var e,t,r;const n=this;n.hasTimeout("show")&&((e=n.mouseDownRemover)==null||e.call(n),n.mouseDownRemover=null,n.clearTimeout("show"),(t=n.mouseMoveRemover)==null||t.call(n),n.mouseMoveRemover=null,(r=n.transitionEndDetacher)==null||r.call(n),n.transitionEndDetacher=null)}abortDelayedHide(){this.clearTimeout("hide")}realign(){const e=this,t=e.lastAlignSpec;!e.isConfiguring&&!e.isVisible&&(t!=null&&t.targetOutOfView)&&(t.allowTargetOut||E.isInView(t.target,!1,e))&&(e.show(),t.targetOutOfView=!1),super.realign()}alignTo(e){const t=this,r=(t.mouseOffsetX||1)*(t.rtl?-1:1),n=t.mouseOffsetY||1,s=Math.max(Math.min(r,5),0),a=Math.max(Math.min(n,5),0);if(!t.isVisible)return;let o;!t.anchorToTarget&&e.position==="mouse"&&(o=new Li(t.triggeredByEvent.pageX-globalThis.scrollX,t.triggeredByEvent.pageY-globalThis.scrollY),e.position=new Li(o.x+(r||1)-(r<0?t.width:0),o.y+(n||1)-(n<0?t.height:0))),e&&!(t.triggeredByEvent&&t.element.contains(t.triggeredByEvent.target))&&e.nodeType===Node.ELEMENT_NODE&&(e={target:e}),super.alignTo(e),o&&t.lastAlignSpec.result.inflate(a,s).contains(o)&&(t.lastAlignSpec.position="mouse",t.mouseOffsetY=-n,t.mouseOffsetX=-r,t.realign(),t.mouseOffsetY=n,t.mouseOffsetX=r)}set html(e){super.html=e,this.isVisible&&this.realign()}get html(){return super.html}changeHtml(e){const t=this;if(X.isPromise(e)){t.showAsyncMessage(),e.target=t.activeTarget,e.then(r=>{e.target===t.activeTarget&&(t.html=r)});return}return typeof e!="object"&&(e=e!=null?t.optionalL(String(e)):""),e}updateHtml(e,t){const r=this;let n=e==="";(!n||E.isVueConfig(e))&&(super.updateHtml(e,t),r.hasContent?X.isPromise(e)||r.trigger("innerHtmlUpdate",{value:e}):n=!0),n&&r.hide()}onMouseMove(e){const t=this,{forElement:r,activeTarget:n}=t,s=t.hasTimeout("hide"),a=e.target;if(t.triggeredByEvent=e,!t._hidden){let o;const l=n==null?void 0:n.contains(a),d=!l&&t.forSelector&&n&&!s&&a.nodeType===Node.ELEMENT_NODE&&!a.matches(t.forSelector)&&!(t.allowOver&&t.element.contains(a)),c=r!=null&&r.document?r.document.documentElement:r,u=c&&(c.contains?c.contains(a):c.compareDocumentPosition(a)&16);if(d&&(o=t.handleForElementOut()),o||!s||u){if(t.dismissDelay&&!s&&t.setTimeout("hide",t.dismissDelay),t.updateContentOnMouseMove&&t.getHtml&&(t.html=t.callback(t.getHtml,t,[{tip:t,element:t.element,forElement:n,activeTarget:n,event:e}]),!t.html)){t.hide();return}t.trackMouse&&t.alignTo({position:"mouse",ignorePageScroll:!0})}}}onElementUserAction(e){const{showOnClick:t}=this;(typeof t!="number"||t===e.button)&&(e.button===2&&e.preventDefault(),this.internalOnPointerOver(e))}onOwnElementMouseEnter(e){this.abortDelayedHide()}static getSharedTooltip(e,t,r){var n,s,a;let o=(s=(n=t.bryntum)==null?void 0:n.tooltip)==null?void 0:s.get(gn);if(!o&&!r){(a=t.bryntum)!=null&&a.tooltip||T.setPath(t,"bryntum.tooltip",new Map);const l=t.bryntum.tooltip;l.set(gn,!0),o=new gn({forElement:t,rootElement:e,forSelector:"[data-btip]",resetCfg:{},isSharedTooltip:!0,cls:"b-tooltip-shared",internalListeners:{pointerOver({target:d}){if(o.isOverflowDetail)return;for(const h in o.resetCfg)h==="listeners"?o.un(o.resetCfg[h].set):h!=="html"&&(o[h]=o.resetCfg[h].was);o.resetCfg={};const c=z.getById(d.id),u=(c==null?void 0:c.tipConfig)||o.gatherDataConfigs(d);if(c&&c.element!==d||!c&&d.matches(".b-widget")||c!=null&&c.disabled&&!c.showTooltipWhenDisabled)return!1;o._owner=c,o.element.classList.toggle("b-target-disabled",!!(c!=null&&c.disabled));for(const h in u)o.resetCfg[h]={set:u[h],was:o[h]},h==="listeners"?o.ion(u[h]):o[h]=u[h]},hide({source:d}){d.owner=null}},gatherDataConfigs(d){const{dataset:c}=d,u={};for(const h in c)if(h.startsWith("btip"))if(h.length>4){const f=k.uncapitalize(h.substr(4));if(f in o.getDefaultConfiguration()){const g=c[h];u[f]=M$[g]?g==="true":isNaN(g)?g:parseInt(g,10)}}else u.html=c[h];return d.hasAttribute("aria-label")&&!u.html?u.html=k.encodeHtml(o.optionalL(d.getAttribute("aria-label"))):d.hasAttribute("aria-labelledby")&&(u.html=k.encodeHtml(o.optionalL(document.getElementById(d.getAttribute("aria-labelledby").textContent)))),u},filterTarget({target:d}){o.isOverflowDetail=!1;const c=d.closest(o.forSelector);if(c)return c;if(gn.showOverflow&&d.closest(".b-widget"))for(;(d==null?void 0:d.nodeType)===Element.ELEMENT_NODE;){if(E.getStyleValue(d,"text-overflow")==="ellipsis"&&d.clientWidth<d.scrollWidth)return o.html=k.encodeHtml(d.textContent),o.isOverflowDetail=!0,d;d=d.parentNode}}}),j.on({element:t,mouseenter:d=>gn.currentOverElement=d.target,keydown:d=>gn.currentOverElement=d.target,capture:!0,thisObj:o}),l.set(gn,o)}return o}static encodeConfig(e){const t={};if(typeof e=="string")t.btip=e;else for(const r in e)t[`btip${r==="html"?"":k.capitalize(r)}`]=e[r];return t}};p(Vb,"$name","Tooltip"),p(Vb,"type","tooltip");var Fe=Vb;Fe.initClass(),Object.defineProperty(z,"tooltip",{get(){return Fe.getSharedTooltip(document.body,document.body)}}),z.Tooltip=Fe,Fe._$name="Tooltip";var xm=class extends ju{static get configurable(){return{align:"t10-b50",offset:20,tooltip:{$config:["lazy","nullify"],value:{type:"tooltip"}}}}open(){this.getConfig("tooltip")}close(){var i;(i=this.tooltip)==null||i.hide()}dragMove(i){const{offset:e,tooltip:t}=this,{event:r}=i;t&&(t.isVisible||t.show(),t.alignTo({align:this.align,target:new $(r.clientX-e,r.clientY-e,e*2,e*2)}))}changeTooltip(i,e){return z.reconfigure(e,i,this)}};p(xm,"type","tip"),xm.initClass(),xm._$name="DragTipProxy";var jb=i=>{var e;return e=class extends(i||O){get hasLabel(){return!!this.label}compose(){const{hasLabel:t,labelPosition:r}=this;return{class:{[`b-label-${r}`]:t,"b-has-label":t}}}changeLabel(t){return t||""}setupLabel(t){return T.assign({tag:"label",for:`${this.id}-input`,class:`b-label b-align-${t.align||"start"}`},t)}updateLabelWidth(t){this.labelElement&&(this.labelElement.style.flex=`0 0 ${E.setLength(t)}`,this.inputWrap&&(this.inputWrap.style.flexBasis=t==null?"":"auto"))}get widgetClass(){}},p(e,"$name","Labelable"),p(e,"configurable",{label:null,labelPosition:"before",labelCls:null,labelWidth:{value:null,$config:{localeKey:"L{labelWidth}"}}}),e},Ko=(i=O)=>{var e;return e=class extends i.mixin(je){get widgetClass(){}doDestroy(){const t=this,r=t._rootElement&&t.constructor.getSharedErrorTooltip(t._rootElement,{doNotCreate:!0,cachePath:t.errorTooltipCachePath});super.doDestroy(),(r==null?void 0:r.field)===t&&r.hide()}get errorTip(){return this.constructor.getSharedErrorTooltip(this.rootElement,{cachePath:this.errorTooltipCachePath,tooltipConfig:this.errorTooltipConfig})}static get errorTip(){return this.getSharedErrorTooltip(document.body)}static getSharedErrorTooltip(t,r={}){var n;const{doNotCreate:s,cachePath:a="errorTooltip",tooltipConfig:o}=r;let l=(n=t.bryntum)==null?void 0:n[a];return!l&&!s&&(t.bryntum=t.bryntum||{},l=Fe.new({cls:"b-field-error-tip",forSelector:".b-field.b-invalid .b-field-inner",align:{align:"l-r",monitorTargetMutation:!0},axisLock:"flexible",scrollAction:"realign",trapFocus:!1,rootElement:t,onBeforeShow(){const d=this,c=z.fromElement(d.activeTarget);if(c){const u=c.getErrors();if(u)return d.html=u.join("<br>"),d.field=c,!0}return!1}},o),t.bryntum[a]=l),l}setError(t,r,n){const s=this,a=Object.keys(s.errors||{}).length;(s.errors||(s.errors={}))[t]=s.optionalL(t);const o=Object.keys(s.errors).length;if(o!==a&&s.trigger("validityChange",{valid:o===0,bubbles:!0}),r||s.syncInvalid(),n){const l=()=>{s.clearError(t),d()},d=s.ion({keydown:l,focusOut:l})}}clearError(t,r){const n=this;n.errors&&Object.keys(n.errors).length>0&&(t?delete n.errors[t]:n.errors={},n.trigger("validityChange",{valid:Object.keys(n.errors).length===0,bubbles:!0})),r||n.syncInvalid()}getErrors(){var t,r;const n=this;if(!n.isValid){const s=n.validity,a=T.keys(s).find(c=>c!=="valid"&&c!=="customError"&&s[c]),o=n.errors&&Object.values(n.errors),l=(r=(t=n.formatter)==null?void 0:t.is.percent)!=null?r:!1;let d;if(o!=null&&o.length?d=o:s.customError?d=[n.input.validationMessage]:a?d=[n.L(a,{min:l?`${n.min*100}%`:n.min,max:l?`${n.max*100}%`:n.max})]:d=[n.L(n.invalidValueError)],(d==null?void 0:d.length)>0)return d}}syncInvalid(){const t=this,{isPainted:r}=t;if(t.updatingInvalid=!0,r){const{isValid:n,element:s,inputWrap:a}=t;if(s.classList[n?"remove":"add"]("b-invalid"),n){const o=t.constructor.getSharedErrorTooltip(t.rootElement,{doNotCreate:!0,cachePath:this.errorTooltipCachePath});o!=null&&o.isVisible&&o.field===t&&o.hide()}else if(a){const o=t.errorTip;o&&(t.containsFocus||t.isVisible&&E.isDescendant(a,Fe.currentOverElement))&&(o.activeTarget===a&&o.isVisible?o.onBeforeShow():(o.activeTarget=a,o.showBy(a)))}}t.updatingInvalid=!1}},p(e,"$name","Validatable"),e},Wu=class extends ct{static get configurable(){return{animation:{duration:300},collapsed:null,collapser:{value:null,$config:"nullify"},syncableConfigs:null,syncConfigTriggers:{$config:{merge:"classList"},value:null},testConfig:{animation:{duration:10}}}}static get delayable(){return{syncChildConfigs:"raf"}}get inline(){var i;return(i=this.owner.inline)!=null?i:this.ensureItems().count===1}changeCollapsed(i){if(this.togglingCollapse)return this.togglingCollapse=!1,i;this.toggleCollapse(!!i)}updateCollapsed(i){var e;this.collapser=(e=this.collapser)==null?void 0:e.destroy(),this.setCollapsedCls(i)}updateCollapser(i,e){e&&e.completed==null&&(!e.reverting||!i)&&e.destroy(),this.setOwnerCls("b-collapsing",i)}get collapsing(){const{collapser:i}=this;return i!=null&&i.collapsed}get collapsingExpanding(){return this.collapser!=null}get expanding(){const{collapser:i}=this;return i!=null&&!i.collapsed}collapse(i){this.toggleCollapse(!0,i)}expand(i){this.toggleCollapse(!1,i)}setCollapsedCls(i){this.setOwnerCls("b-collapsed",i)}setOwnerCls(i,e){var t,r;(r=(t=this.owner)==null?void 0:t.element)==null||r.classList[e?"add":"remove"](i)}syncChildConfigs(){const i=this,{owner:e,syncableConfigs:t}=i;if(t){let r,n;for(r in t)n=t[r](e),i.eachWidget(s=>{s[r]=n},!1)}e.afterSyncChildConfigs(i)}syncContainer(){const{inline:i,layout:e}=this;this.autoLayout&&(e.horizontal=i,e.justify=i?"center":"stretch")}toggleCollapse(i,e){const t=this,{animation:r,collapser:n,inline:s}=t,{containerWrapElement:a}=t.owner,o=l=>{l&&(t.element.style.height="",t.togglingCollapse=!0,t.collapsed=i,t.collapser=null)};if(i==null&&(i=!t.collapsed),e!==!1&&e!==null&&(!a||!t.isVisible?e=null:(e===!0?e={}:typeof e=="number"&&(e={duration:e}),e=r||e?T.merge({},r,e):null)),!e)t.togglingCollapse=!0,t.collapsed=i;else if(n&&i!==n.collapsed)t.collapser=n.revert({finalize:o}),t.collapser.collapsed=i;else if(!n&&i!==t.collapsed){!i&&t.setCollapsedCls(!1);const{element:l}=t,{height:d}=l.getBoundingClientRect(),c=s?1:d;!i&&t.setCollapsedCls(!0),l.style.height=`${d}px`,t.collapser=$t.run(T.merge({finalize:o,element:a,[s?"opacity":"height"]:{from:i?c:0,to:i?0:c}},e)),t.collapser.collapsed=i}}};p(Wu,"$name","FieldContainer"),p(Wu,"type","fieldcontainer"),Wu.initClass(),Wu._$name="FieldContainer";var _$=(i,e)=>(i.weight||0)-(e.weight||0),F$=(i,e)=>(e.weight||0)-(i.weight||0),zb=[],A$={align:!0,weight:!0},Rm=class FD extends z.mixin(Eb,jb,Ko){static get delayable(){return{highlightChanged:"raf"}}doDestroy(){var e,t,r;const n=this,{triggers:s}=n;if((e=n.inputListenerRemover)==null||e.call(n),(t=n.keyListenerRemover)==null||t.call(n),(r=n.container)==null||r.destroy(),super.doDestroy(),s)for(const a of Object.values(s))a.destroy()}get childItems(){const{container:e,triggers:t}=this,r=t?Object.values(t):[];return e?[...r,...e.childItems]:r}get invalidValueError(){return"L{invalidValue}"}construct(e={}){super.construct(e);const t=this;t.keyStrokeChangeDelay&&(t.changeOnKeyStroke=t.buffer(t.internalOnChange,t.keyStrokeChangeDelay)),!t.ariaLabel&&t.placeholder&&t.updateAriaLabel(t.placeholder)}changeKeyMap(e){var t;const r=this;let n={};e&&(r._fieldKeyMap?T.assign(n,r._fieldKeyMap):(r._fieldKeyMap=e,T.assign(n,e)));for(const s in r.triggers)(t=r.triggers[s])!=null&&t.keyMap&&(n=r.mergeKeyMaps(n,r.triggers[s].keyMap,s));return n}get keyMapSubComponents(){return this.triggers}onFocusIn(e){const t=this;t.valueOnFocus=T.clone(t.value),t.validOnFocus=!(t.errors&&Object.keys(t.errors).length),super.onFocusIn(e),t.focusing=!0,t.syncInvalid(),t.focusing=!1}onFocusOut(e){super.onFocusOut(e),this.syncRequired(),this.onEditComplete()}onEditComplete(){}get rootUiClass(){return FD}compose(){this.getConfig("clearable");const e=this,{container:t,innerElements:r,label:n,labels:s,labelCls:a,readOnly:o,stepTriggers:l,triggers:d,required:c,showRequiredIndicator:u}=e,h=T.values(d,(y,b)=>!b),f=h.filter(y=>y.align==="start").sort(_$),g=h.filter(y=>y.align!=="start").sort(F$),m=e.setupLabel.bind(e),v=[...f.map(y=>y.element),...r,...g.map(y=>y.element)];return{class:{"b-has-step-triggers":l,"b-has-start-trigger":f.length,"b-no-input":!r.length,"b-readonly":o,"b-field-container":!!t,"b-field-container-inline":t==null?void 0:t.inline,"b-required":!!(c&&u)},children:[...(s||zb).filter(y=>y&&y.align!=="end").map(m),(n||null)&&m({reference:"labelElement",class:`b-label b-align-start ${a||""}`,html:n}),v.length?{class:"b-field-inner",reference:"inputWrap",children:v}:null,...(s||zb).filter(y=>(y==null?void 0:y.align)==="end").map(m),...t?[{reference:"containerWrapElement",children:[t.element],class:{"b-field-container-wrap":1}}]:zb]}}updateElement(e,t){var r;const n=this,s=n.initialConfig.value,{input:a}=n;super.updateElement(e,t),s!=null&&(n.value=s),n.syncEmpty(),n.updateInputReadOnly(n.inputReadOnly),n.syncInvalid();const o=a||n.focusElement;(r=n.keyListenerRemover)==null||r.call(n),n.keyListenerRemover=o&&j.on({element:o,thisObj:n,keydown:"internalOnKeyEvent",keypress:"internalOnKeyEvent",keyup:"internalOnKeyEvent"})}get innerElements(){return[this.inputElement]}get inputElement(){const{attributes:e,inputAttributes:t,id:r,inputCls:n,inputType:s,name:a,inputTag:o}=this,l=T.merge({reference:"input",tag:o,type:s,name:a||r,id:`${r}-input`,retainElement:"prevent-release",dataset:this.isPasswordField?null:{opIgnore:!0}},t);n&&(l.class=n);for(let d,c,u=e.length;u-- >0;)d=e[u],c=this[d],c!=null&&(l[k.hyphenateAttributeName(d)]=c);return l}get caretPos(){return this.textSelection[0]}set caretPos(e){this.textSelection=e}get focusElement(){return this.input}get textSelection(){var e;const t=this.input;let r;try{r=[t.selectionStart,t.selectionEnd,t.selectionDirection]}catch(n){r=((e=t.value)==null?void 0:e.length)||0,r=[r,r]}return r}set textSelection(e){typeof e=="number"?this.select(e,e):this.select(...e)}get hasTextSelection(){const[e,t]=this.textSelection;return e&&t-e>0}getAfterValue(e){const[t,r]=this.textSelection,n=this.input.value;return`${n.substr(0,t)}${e}${n.substr(r||t)}`}select(e,t){const r=this.focusElement;if(r.value.length){if(arguments.length===0){this.selectAll();return}if(!this.supportsTextSelection)return;r.setSelectionRange(e,t)}}moveCaretToEnd(){const e=this.input;if(e.createTextRange){const t=e.createTextRange();t.collapse(!1),t.select()}else this.supportsTextSelection&&this.select(e.value.length,e.value.length)}selectAll(){var e,t;(t=(e=this.focusElement).select)==null||t.call(e)}get caretAtEnd(){return this.textSelection[1]===this.input.value.length}get caretAtStart(){return!this.textSelection[1]}get selectedAll(){const{textSelection:e}=this;return!e[0]&&e[1]===this.input.value.length}syncEmpty(){var e;const{isEmptyInput:t,isEmpty:r,element:n}=this,s=(e=this.triggers)==null?void 0:e.clear,a=t&&r;n&&(s&&s[a?"hide":"show"](),n.classList.toggle("b-empty",a))}updateHint(){this.syncHint()}updateHintHtml(){this.syncHint()}syncHint(){const e=this,{input:t,hint:r,hintHtml:n}=e,s=t==null?void 0:t.parentElement;if(t){let a=n||r;const o=e.hintElement||a&&(e.hintElement=E.createElement({parent:s,className:"b-field-hint",nextSibling:t.nextSibling,children:[{className:"b-field-hint-content"}]}));o&&(typeof a=="function"&&(a=a({source:e,value:e.value})),o.firstChild[n?"innerHTML":"textContent"]=a||""),e.element.classList[a?"remove":"add"]("b-field-no-hint")}}updateInputTag(e){e&&e!==this.getDefaultConfiguration().inputTag&&(this.dontCache=!0)}updateEditable(){this.syncInputReadOnly()}syncInputReadOnly(){this.getConfig("readOnly"),this.inputReadOnly=this._readOnly||this.editable===!1}updateInputReadOnly(e){const t=this,{input:r,inputListenerRemover:n}=t;r&&(r.readOnly=e?"readOnly":null,e?t.inputListenerRemover=n==null?void 0:n():n||(t.inputListenerRemover=j.on({element:r,thisObj:t,focus:"internalOnInputFocus",change:"internalOnChange",input:"internalOnInput"})))}changeReadOnly(e){return!!e}updateReadOnly(e){this.syncInputReadOnly()}updateRequired(e){this.syncRequired()}updateClearable(e){const t=this;t.getConfig("triggers"),t.triggers={clear:e&&T.assign({cls:"b-icon-remove",weight:1e3,handler:t.clear},e)||null}}changeTriggers(e,t){const r=this,n=r.$triggers||(r.$triggers=new ea({configName:"triggers",factory:FD.Trigger,inferType:!1,owner:r,created(s){we.after(s,"onConfigChange",(a,{name:o})=>{A$[o]&&r.onConfigChange({name:"triggers",value:n.target})})},setup(s,a){s.reference=s.ref=a,s.parent=r}}));if(e&&!r.stepTriggers&&(e.back||e.forward)&&(e=T.assign({},e),delete e.back,delete e.forward),n.update(e),r.element&&(r.keyMap=r.keyMap),!t)return n.target}updateInputWidth(e){this.input.style.width=E.setLength(e),this.element.classList.add("b-has-width")}updateInputAlign(e){this.input.style.textAlign=e}get isValid(){const e=this;if(!e.disabled&&!e.skipValidation){if(e.syncRequired(),e.checkValidity&&e.callback(e.checkValidity,e,[e]),e.errors&&Object.keys(e.errors).length)return!1;const t=e.validity;if(t)return t.valid}return!0}get isClear(){return this.isEmpty&&this.isEmptyInput}get isEmpty(){const{value:e}=this;return e==null||e===""||e===this.nullValue}get isEmptyInput(){return!this.input||this.input.value==null||this.input.value===""}get validity(){const e=this.input;return e==null?void 0:e.validity}async setValue(e){this.value=e}changeValue(e,t){return e==null&&(e=this.nullValue),this.hasChanged(t,e)?e:(e===""&&this.syncRequired(),t)}updateValue(e,t){const r=this;r.isConfiguring||(r.syncRequired(),r.inputting||r.triggerChange()),r.inputting||(r._lastValue=e),r.syncInputFieldValue()}hasChanged(e,t){return t!==e}syncInputFieldValue(e=!1){const t=this,{input:r,parent:n,inputValueAttr:s,inputValue:a}=t;if(r&&!t.inputting&&r[s]!==a&&(r[s]=a,!t.isConfiguring&&!t.containsFocus&&t.highlightExternalChange)){if(r.classList.remove("b-field-updated"),t.clearTimeout("removeUpdatedCls"),n){const{assigningValues:o}=n;(o===!0||(o==null?void 0:o.highlight)===!1)&&(e=!0)}e||t.highlightChanged()}t.syncEmpty(),t.syncInvalid()}setValueSilently(e){this.inputting=!0,this._value=e,this.syncInputFieldValue(),this.inputting=!1}highlightChanged(){this.input.classList.add("b-field-updated"),this.setTimeout("removeUpdatedCls",this.updatedClsDuration)}removeUpdatedCls(){this.input.classList.remove("b-field-updated")}get inputValue(){return this.value==null?"":this.value}get inputValueAttr(){return"value"}get supportsTextSelection(){const e=this.focusElement;return e&&E.isTextualInput(e)}updatePlaceholder(e){this.ariaLabel||this.updateAriaLabel(e),this.input&&(e==null?this.input.removeAttribute("placeholder"):this.input.placeholder=e)}internalOnInputFocus(){this.autoSelect&&this.selectAll()}internalOnChange(e){const t=this;t.hasChanged(t._lastValue,t.value)&&t.isValid&&(t.triggerChange(e,!0),t._lastValue=t.value)}triggerChange(e,t=!!this._isUserAction){const r=this,{value:n,_lastValue:s,isValid:a}=r;r.syncHint(),r.triggerFieldChange({value:n,oldValue:s,event:e,userAction:t,valid:a}),r.defaultAction==="change"&&r.trigger("action",{value:n,oldValue:s,event:e,userAction:t,valid:a})}fetchInputValue(){this.value=this.input[this.inputValueAttr]}internalOnInput(e){var t;const r=this;r.validateOnInput||r.errorTip.hide(),r.inputting=!0,r.fetchInputValue(),r.inputting=!1,r.trigger("input",{value:r.value,event:e}),(t=r.changeOnKeyStroke)==null||t.call(r,e)}get needsInputSync(){var e;return this.input[this.inputValueAttr]!==String((e=this.inputValue)!=null?e:"")}internalOnKeyEvent(e){const t=this,{value:r}=t;let n=!1;if(t._isUserAction=!0,e.type==="keydown"&&e.key==="Escape"&&!(t.readOnly||t.disabled)){const s=t.isValid,a="initialValue"in t?t.initialValue:t.valueOnFocus,o=t.hasChanged(a,r),{needsInputSync:l}=t;t.revertOnEscape&&(!s||o||l)?((o||!s)&&(t.value=a),l&&t.syncInputFieldValue(!0),t.clearError(),n=(o||l)&&t.isValid||s!==t.validOnFocus):!t.isEmpty&&t.clearable&&t.revertOnEscape&&!s&&(t.clear(),e.stopPropagation())}t.isDestroyed||(n&&e.stopImmediatePropagation(),t.trigger(e.type,{event:e})),t._isUserAction=!1}clear(e){const t=this;t.isClear||(t.value=t.nullValue,t.clearError(),t.syncInvalid(),t.input&&E.isTextualInput(t.input)&&(t.input.value=""),t.trigger("clear",{event:e}),e==null||e.stopImmediatePropagation())}onDisabled(){this.syncInvalid()}syncRequired(){var e;const t=this;!t.isConfiguring&&(!t.focusing||t.focusVisible)&&t.required&&t.isEmpty&&!((e=t.parent)!=null&&e.isSettingValues)?t.setError("L{fieldRequired}",t.updatingInvalid):t.clearError("L{fieldRequired}",t.updatingInvalid)}get containerCollapsed(){var e;return(e=this.container)==null?void 0:e.collapsed}set containerCollapsed(e){const{container:t}=this;t&&(t.collapsed=e)}afterSyncChildConfigs(e){}changeContainer(e,t){e&&(Array.isArray(e)||!("type"in e||"items"in e))&&(e={items:e});const r=this,n=e&&T.merge({owner:r,layout:"box"},r.containerDefaults),s=z.reconfigure(t,e,{owner:r,defaults:n});if(s&&(s.autoLayout=(n==null?void 0:n.layout)==="box",s===t)){s.syncContainer();return}return s}onConfigChange(e){var t,r;super.onConfigChange(e),(r=(t=this.container)==null?void 0:t.syncConfigTriggers)!=null&&r[e.name]&&this.container.syncChildConfigs()}assignValue(e,t){const r=this,{container:n,containValues:s}=r,a=r.getValueName(t),o=e&&a in e;r.assigningValue=!0,n&&s!==!1?e&&s==="nested"?o&&(e=T.clone(e[a]),super.assignValue({[a]:e&&!("value"in e)||e.value},t),e&&delete e.value,n.assignValue(e,t)):(super.assignValue(e,t),n.assignValue(e,t)):super.assignValue(e,t),r.assigningValue=!1}gatherValue(e){super.gatherValue(e),this.gatherValues(e)}gatherValues(e,t){const r=this,{container:n,containValues:s,valueName:a}=r,o=typeof s;t=t!=null?t:a in e,n&&s!==!1&&(s==="nested"?t&&(e[a]={value:e[a],...n.values}):(s===!0||s==null&&t||o==="string"&&r[s]||o==="function"&&s(r))&&n.gatherValues(e))}updateContainer(e,t){t&&this.detachListeners(t.id),e&&(e.rendered||e.render(),e.syncContainer(),e.syncChildConfigs())}};p(Rm,"$name","Field"),p(Rm,"type","field"),p(Rm,"configurable",{role:null,defaultBindProperty:"value",skipValidation:null,placeholder:null,value:"",name:null,labels:null,required:null,showRequiredIndicator:null,clearable:null,revertOnEscape:null,hint:null,hintHtml:null,inputWidth:null,keyStrokeChangeDelay:0,readOnly:null,editable:!0,defaultAction:"change",stepTriggers:null,triggers:null,highlightExternalChange:!1,localizableProperties:["label","title","placeholder","labelWidth","hint"],autoSelect:!1,autoComplete:"off",spellCheck:null,validateOnInput:!0,inputAttributes:null,inputType:"text",inputAlign:null,attributes:{value:["placeholder","ariaLabel","autoComplete","spellCheck","minLength","maxLength","pattern","tabIndex","min","max"],$config:{merge:"distinct"}},nullValue:{$config:null,value:null,default:null},updatedClsDuration:500,inputReadOnly:!1,ariaElement:"input",container:{$config:"nullify",value:null},containerDefaults:{type:"fieldcontainer",syncableConfigs:{disabled:i=>i.disabled},syncConfigTriggers:{disabled:1}},containValues:null,inline:null,testConfig:{updatedClsDuration:10},keyMap:{},twinSyncConfigs:["value"],inputTag:{$config:null,value:"input",default:"input"}});var ut=Rm,Uu;ut.Trigger=(Uu=class extends z{static get factoryable(){return{defaultType:ut.Trigger,extends:null}}get field(){return this.parent}construct(...i){super.construct(...i),this.key&&(this.keyMap={[this.key]:"onClick"})}compose(){return{"aria-hidden":!0,class:{[`b-align-${this.align||"end"}`]:1,"b-icon":1},listeners:{click:"onClick",mousedown:"onMousedown"}}}changeAlign(i){return i}onClick(i){const e=this,{field:t}=e;t.disabled||t.readOnly||(i.key&&i.preventDefault(),t.trigger("trigger",{trigger:e})!==!1&&e.handler&&(t._isUserAction=!0,t.callback(e.handler,t,[i,e]),t._isUserAction=!1))}onMousedown(i){const e=this.field;!("key"in i)&&E.isTouchEvent&&e.editable&&(e.editable=!1,e.setTimeout(()=>e.editable=!0,500)),i.preventDefault(),E.getActiveElement(e.input)!==e.input&&e.focus()}},p(Uu,"$name","FieldTrigger"),p(Uu,"type","trigger"),p(Uu,"configurable",{align:null,weight:null,role:null}),Uu);var Gu;ut.SpinTrigger=(Gu=class extends ut.Trigger{compose(){return{children:{upButton:{class:{"b-icon":1,"b-spin-up":1}},downButton:{class:{"b-icon":1,"b-spin-down":1}}}}}updateRepeat(i){var e;(e=this.clickRepeater)==null||e.destroy(),this.clickRepeater=i?om.new({element:this.element},i):null}onClick(i){const e=this,{field:t}=e;t._isUserAction=!0,t.disabled||t.readOnly||(i.target===e.upButton?t.doSpinUp(i.shiftKey):i.target===e.downButton&&t.doSpinDown(i.shiftKey)),t._isUserAction=!1}get isFocusable(){return!this.disabled&&super.isFocusable}},p(Gu,"$name","SpinTrigger"),p(Gu,"type","spintrigger"),p(Gu,"configurable",{repeat:{$config:["nullify"],value:!0}}),Gu),ut.Trigger.initClass(),ut.SpinTrigger.initClass(),z.register(ut.Trigger,"trigger"),z.register(ut.SpinTrigger,"spintrigger"),ut._$name="Field";var Xo=class extends dr{};p(Xo,"$name","Fit"),p(Xo,"type","fit"),p(Xo,"configurable",{containerCls:"b-fit-container",itemCls:"b-fit-item"}),Xo.initClass(),Xo._$name="Fit";var An=document.createRange(),Mi=class extends z{construct(i,...e){var t;const r=this;Array.isArray(i)&&(i={items:i}),super.construct(i,...e);const{element:n}=r,{classList:s}=n;r.multiSelect&&s.add("b-multiselect"),(t=r.store)!=null&&t.count?r.refresh():s.add("b-empty"),j.on({element:n,click:"onClick",thisObj:r})}doDestroy(){var i;this.detachListeners("store"),(i=this.navigator)==null||i.destroy(),super.doDestroy()}changeScrollable(i){return i=super.changeScrollable(i),i&&this.title&&(i.stickies=".b-list-title"),i}onFocusIn(i){var e;this.restoreActiveItem((e=i._target)==null?void 0:e.closest(this.itemSelector)),super.onFocusIn(i)}get isVirtualized(){return typeof this.virtualize=="number"?this.store.count>this.virtualize:!!this.virtualize}outOfViewTpl(i,e){return`<li class="b-list-item b-out-of-view" data-index="${e}" aria-posinset="${e+1}" aria-setsize="${this.store.count}" data-id="${k.encodeHtml(i.id)}"></li>`}onItemIntersection(i,e){if(e){const t=this,r=parseInt(i.dataset.index),n=t.store.getAt(r);n&&E.sync(t.callback(t.itemWrapperTpl,t,[n,r,t]),i),t.itemIntersectionObserver.unobserve(i)}}contentTpl(){const i=this,e=Math.ceil(i.height/i.listItemHeight),t=i.store.records.map((r,n)=>!i.isVirtualized||n<e?i.callback(i.itemWrapperTpl,i,[r,n,i]):i.outOfViewTpl(r,n));if(i.multiSelect&&i.selectAllItem!==!1&&t.unshift(i.selectAllItemTpl()),i.title){const r=`${i.id}-title`;t.unshift(`<li id="${r}" class="b-list-item b-list-title" data-noselect>${k.encodeHtml(i.title)}</li>`),i.element.setAttribute("aria-labelledby",r)}else i.element.removeAttribute("aria-labelledby");return i.emptyText&&i.store.count===0&&t.push(`<li class="b-list-item b-empty-text">${i.L(i.emptyText)}</li>`),Ti.tpl`${t}`}itemWrapperTpl(i,e,t){const{selected:r,getItemStyle:n,store:s,tooltipTemplate:a}=t,o=(a==null?void 0:a(i))||"",l=[...s.excludeCollapsedRecords?[`--tree-level:${i.childLevel||0}`]:[],...n?[t.callback(n,t,[i])]:[]].join(";"),d=l.length?`style="${l}"`:"",c=t.callback(t.isSelectable,t,[i]);return s.isGrouped&&!i.isGroupHeader&&i.instanceMeta(s).groupParent.meta.collapsed||!i.ancestorsExpanded(s)?"":Ti.tpl`<li ${d} aria-posinset="${e+1}" aria-setsize="${this.store.count}" class="${t.getItemClasses(i,e)}" role="option" ${o?`data-btip="${k.encodeHtml(o)}"`:""} aria-selected="${r.includes(i)}" data-index="${e}" ${c?"":"data-noselect"} data-id="${k.encodeHtml(i.id)}" ${t.itemsFocusable?'tabindex="-1"':""}>${t.itemContentTpl(i,e)}</li>`}itemContentTpl(i,e){const t=this;if(i.isGroupHeader||i.isParent&&t.store.excludeCollapsedRecords!==!1){let r=t.groupHeaderTpl(i,i.isParent?t.callback(t.itemTpl,t,[i]):k.capitalize(i.meta.groupRowFor));if(t.collapsibleGroups||i.isParent){const n=i.isParent?i.instanceMeta(t.store).collapsed:i.meta.collapsed,s=n?"right":"down";r+=`<button aria-label="${t.L("L{Object."+(n?"expand":"collapse")+"}")}" class="b-button b-tool b-icon b-icon-collapse-${s} b-list-expander-icon" data-noselect></button>`}return r}return`${t.itemIconTpl(i,e)}${t.callback(t.itemTpl,t,[i])}`}itemIconTpl(i,e){return this.multiSelect&&this.callback(this.isSelectable,this,[i])?`<i aria-hidden="true" role="presentation" class="b-selected-icon b-icon ${this.selectIconCls}"></i>`:""}selectAllItemTpl(){const i=this.allSelected?"b-selected":"";return`<li class="${this.itemCls} b-select-all-item ${i}" data-select-all data-id="select-all" ${this.itemsFocusable?'tabindex="-1"':""}>${this.itemIconTpl({})}<div>${this.L("L{selectAll}")}</div></li>`}getItemClasses(i){var e,t;const r=this,{getItemCls:n,store:s}=r,a=(e=r._navigator)==null?void 0:e.activeItem,o=(a==null?void 0:a.dataset.id)==i.id,l="groupRowFor"in i.meta?"b-list-item-group-header":s.excludeCollapsedRecords&&i.isParent?"b-list-item-tree-parent":"",d=r.selected.includes(i)||((t=i.groupChildren)==null?void 0:t.every(u=>r.selected.includes(u))),c=n?this.callback(n,this,[i]):"";return`${r.itemCls} ${i.cls||""} ${c} ${d?r.selectedCls:""} ${o?r.navigator.focusCls:""} ${l}`}onBeforeStoreLoad(){this.mask(this.L("L{loading}"))}onAfterStoreRequest(){this.unmask()}onStoreChange({source:i,action:e,records:t,record:r,changes:n,isCollapse:s}){const a=this,{selected:o}=a;switch(e){case"dataset":{o.match(i.storage,!a._externallyOwnedSelection);break}case"remove":s||o.remove(t);break;case"clear":a.deselectAll();break;case"update":{const{id:l}=n;l&&E.setAttributes(a.contentElement.querySelector(k.encodeAttributeSelector("data-id",l.oldValue)),{"data-id":l.value}),a.refreshItem(r);return}}a.refresh()}onStoreRefresh(){this._selected?this.refresh():this.getConfig("selected")}refresh(){var i,e;const t=this;if(t.isVisible&&t.store){const r=(i=t.navigator)==null?void 0:i.activeItem;t.itemIntersectionObserver&&(t.itemIntersectionObserver.disconnect(),t.itemIntersectionObserver=null),t.paintListener=null;const n=E.createElementFromTemplate(t.contentTpl(),{fragment:!0});if(t.clearItems().insertNode(n),t.element.classList.toggle("b-virtualized",t.isVirtualized),t.isVirtualized){t.itemIntersectionObserver=new IntersectionObserver(s=>{for(const a of s)t.onItemIntersection(a.target,a.isIntersecting,a)});for(const s of t.element.querySelectorAll(t.itemSelector))t.itemIntersectionObserver.observe(s);t.listItemHeight=(e=t.element.children[0])==null?void 0:e.clientHeight}r&&t.restoreActiveItem(r),t.refreshCount=(t.refreshCount||0)+1,t.element.classList.toggle("b-empty",t.store.count===0),t.updateSelectAllState()}else t.paintListener||(t.paintListener=t.once("paint","refresh"))}clearItems(){const i=this,{contentElement:e}=i,t=e.querySelector(i.itemSelector),r=e.lastChild;if(t){const n=e.querySelectorAll(`${i.itemSelector}:not(.b-mask)`);An.setStartBefore(t),An.setEndAfter(n[n.length-1]),An.deleteContents()}else r?(An.setStartAfter(r),An.setEndAfter(r)):(An.setStart(e,0),An.setEnd(e,0));return An}refreshItem(...i){for(const e of i){const t=this,r=t.getItem(e);if(r){const n=t.store.indexOf(e),s=E.createElementFromTemplate(t.callback(t.itemWrapperTpl,t,[e,n,t]));E.sync(s,r)}}}getItem(i){if(i!=null)return typeof i=="number"?this.contentElement.querySelector(`[data-index="${i<0?this.store.count+i:i}"]`):(i.nodeType===Element.ELEMENT_NODE&&(i=i.dataset.id),(i==null?void 0:i.id)!=null&&(i=i.id),this.contentElement.querySelector(k.encodeAttributeSelector("data-id",i)))}getRecordFromElement(i){return i.target&&(i=i.target),i=i.closest(this.itemSelector),this.store.getAt(parseInt(i.dataset.index))}updateItems(i){this.store.data=L.asArray(i!=null?i:[]).map(e=>typeof e=="string"?{[this.displayField]:e}:e)}updateDisabled(i,e){super.updateDisabled(i,e),this.navigator&&(this.navigator.disabled=i)}updateLocalization(){super.updateLocalization(),this.refresh()}updateTitle(){this.refresh()}changeSelected(i,e){const t=this,r={change:"onInternalSelectionChange",thisObj:t};if(i){if(i.isCollection)t._externallyOwnedSelection=!0,i.ion(r);else if(t._externallyOwnedSelection=!1,i=L.asArray(i).reduce((n,s)=>(s=s.isModel?s:t.store.getById(s),s&&t.callback(t.isSelectable,t,[s])&&n.push(s),n),[]),e)e.splice(0,e.count,i),i=e,t.refresh();else{const n=i;i=t._selected=new Bi({internalListeners:r}),i.add(n)}i!==e&&(e==null||e.un(r))}else e==null||e.destroy();return i}updateSelected(i){i&&this.refresh()}get itemSelector(){return`.${this.itemCls}`}get selected(){return this._selected}updateMultiSelect(i,e){const{_selected:t}=this;!i&&e&&(t==null?void 0:t.count)>1&&(t.suspendEvents(),this.deselect(t.allValues.slice(1)),t.resumeEvents()),this.isConfiguring||this.refresh()}get store(){return this.getConfig("items"),this._store}changeStore(i){const e=this;if(i instanceof ue||(Array.isArray(i)&&(i={data:i}),i=new ue(i)),e.detachListeners("store"),i){const t={name:"store",change:"onStoreChange",refresh:"onStoreRefresh",thisObj:e};i.readUrl&&(t.beforeLoad="onBeforeStoreLoad",t.afterRequest="onAfterStoreRequest"),i.isGrouped&&(e.element.classList.add("b-grouped"),t.groupchange="onStoreRefresh"),i.ion(t),i.tree&&i.traverse(r=>{r.isParent&&!r.expanded&&i.onNodeExpand(r)})}return i}updateStore(i){i!=null&&i.records.length&&this.getConfig("selected"),this.refresh()}changeNavigator(i,e){const t=this,{element:r}=t;return r&&(i=Nr.reconfigure(e,i?Nr.mergeConfigs({ownerCmp:t,disabled:t.disabled,target:r,keyEventTarget:r,activateOnMouseover:t.activateOnMouseover},i):null,t),(i==null?void 0:i.keyEventTarget)===r&&!t.itemsTabbable&&(r.tabIndex=0)),i}get minAlignHeight(){const i=this.element.lastElementChild,e=this.minHeight;if(e!=null)return i?Math.min(i.offsetTop+i.offsetHeight,e):0}alignTo(...i){super.minHeight=this.minAlignHeight,super.alignTo(...i)}hide(...i){return this.navigator&&(this.navigator.activeItem=null),super.hide(...i)}show(...i){const e=this,{refreshCount:t,navigator:r}=e,{previousActiveItem:n}=r;super.minHeight=e._minHeight;const s=super.show(...i);return e.refreshCount===t&&e.containsFocus&&e.restoreActiveItem(n,!0),s}restoreActiveItem(i=this.navigator.previousActiveItem,e="nearest"){const t=this,{navigator:r,lastAlignSpec:n}=t;if(i!=null){if(typeof e!="string"){const s=n?n.zone:1;e=s&1?"nearest":s?"start":"end"}i=t.getItem(i),i&&!t.disabled&&(t.scrollable.scrollIntoView(i,{block:e}),r.activeItem=i)}}onClick(i){const e=i.target.closest(this.itemSelector);e?this.onItemClick(e,i):this.clearSelectionOnEmptySpaceClick&&this.deselectAll()}onSpaceKey(i){const e=i.target.nodeName.toUpperCase();(e!=="INPUT"&&e!=="TEXTAREA"||i.target.readOnly)&&this.onEnterKey(i)}onEnterKey(i){const e=this.navigator.activeItem;e&&!this.disabled&&(i.target=e,this.onItemClick(e,i),i.stopImmediatePropagation(),i.preventDefault())}onInternalKeyDown(i){const e=this;switch(i.key){case"ArrowLeft":e.collapseItem();break;case"ArrowRight":e.expandItem();break;case" ":e.onSpaceKey(i);break;case"Enter":e.onEnterKey(i);break}}collapseItem(){const{activeItem:i}=this.navigator;i&&this.toggleCollapse(this.getRecordFromElement(i),!0)}expandItem(){const{activeItem:i}=this.navigator;i&&this.toggleCollapse(this.getRecordFromElement(i),!1)}onItemClick(i,e){const t=this,{allowGroupSelect:r}=t,n=parseInt(i.dataset.index),s=t.store.getAt(n),a=s==null?void 0:s.isSpecialRow,o=i.contains(e.target.closest("[data-noselect]"));if(!(t.disabled||t.trigger("beforeItem",{item:i,record:s,index:n,event:e,userAction:!0})===!1)){if(t._isUserAction=!0,i.contains(e.target.closest("[data-select-all]")))t.onSelectAllClick(i,e);else if(e.target.matches(".b-list-expander-icon")){t.toggleCollapse(s);return}else if(s&&!o&&(!a||r)){const{selected:l}=t,{groupParent:d}=s.instanceMeta(t.store);if(t.multiSelect){let c=l.includes(s),u=s;t.toggleAllIfCtrlPressed&&e.ctrlKey?u=t.store.records:r&&a&&(c=!s.groupChildren.some(h=>!l.includes(h)),i.classList.toggle("b-selected",!c),u=s.groupChildren),l[c?"remove":"add"](u),!a&&d&&r&&t.getItem(d).classList.toggle("b-selected",d.groupChildren.every(f=>l.includes(f)))}else l.splice(0,l.count,s)}t.isDestroyed||(t.lastClicked=s,t.trigger("item",{item:i,record:s,index:n,event:e,userAction:!0}),t._isUserAction=!1)}}onInternalSelectionChange({action:i,removed:e,added:t,replaced:r}){const n=this,{selectedCls:s,unselectedCls:a}=n;let o,l;if(i==="clear")for(l of n.element.querySelectorAll(`.${s}`))l.classList.remove(s),l.setAttribute("aria-selected",!1),a&&l.classList.remove(a);else if(i!=="replaceValues"){for(o of e)l=n.getItem(o),l&&(l.classList.remove(s),l.setAttribute("aria-selected",!1));for(o of t)l=n.getItem(o),l&&(l.classList.add(s),l.setAttribute("aria-selected",!0))}n.selectAllItem&&n.updateSelectAllState(),n.trigger("selectionChange",{selected:n.selected.values})}onSelectAllClick(i){i.classList.contains(this.selectedCls)?this.deselectAll():this.selectAll()}updateSelectAllState(){var i;(i=this.element.querySelector(".b-select-all-item"))==null||i.classList.toggle(this.selectedCls,this.allSelected)}updateAllowGroupSelect(){this.refresh()}get allSelected(){const{selected:i,store:e}=this;return i.count&&(e.isFiltered?e.records.every(t=>i.includes(t)):e.count===i.count)}selectAll(i){const e=this;(e.multiSelect||!i)&&(e.selected.add(e.store.records),i&&!e.navigator.activeItem&&(e.navigator.activeItem=e.getItem(-1)))}deselectAll(){this.selected.clear()}select(i,e=!1){const{store:t,selected:r}=this,{modelClass:n}=t;i=L.asArray(i).reduce((s,a)=>(a=t.getById(n.asId(a)),a&&s.push(a),s),[]),e&&r.count?r.splice(0,r.count,i):r.add(i)}deselect(i){const{modelClass:e}=this.store;i=L.asArray(i).reduce((t,r)=>(r=this.selected.get(e.asId(r)),r&&t.push(r),t),[]),this.selected.remove(i)}toggleCollapse(i,e){const{store:t}=this;i.isGroupHeader?(e=e===void 0?!i.meta.collapsed:e,t[e?"collapse":"expand"](i),this.refresh(),this.trigger("toggleGroup",{groupRecord:i,collapse:e})):i.isParent&&(e=e===void 0?!i.instanceMeta(t).collapsed:e,i.instanceMeta(t).collapsed=e,this.refresh(),this.trigger("toggleNode",{record:i,collapse:e}))}updateCollapsibleGroups(i,e){if(e&&!i){const{store:t}=this;t.groupRecords.forEach(r=>t.expand(r))}this.refresh()}};p(Mi,"$name","List"),p(Mi,"type","list"),p(Mi,"configurable",{itemCls:"b-list-item",selectedCls:"b-selected",selectIconCls:"b-icon-check",tag:"ul",items:null,displayField:"text",store:{value:{},$config:"lazy"},navigator:!0,scrollable:{overflowX:!1,overflowY:!0},itemsFocusable:!0,multiSelect:!1,toggleAllIfCtrlPressed:!1,collapsibleGroups:!1,selectAllItem:!1,itemTpl(i){let e=k.encodeHtml(i.getValue(this.displayField));return(e==null||e==="")&&(e="&nbsp;"),e},tooltipTemplate:null,getItemStyle:null,getItemCls:null,groupHeaderTpl(i,e){let t=k.encodeHtml(e);return(t==null||t==="")&&(t="&nbsp;"),`${(this.allowGroupSelect||i.isParent)&&this.isSelectable(i)?this.itemIconTpl(i):""}${t}`},allowGroupSelect:!0,clearSelectionOnEmptySpaceClick:!1,selected:{$config:["nullify","lazy"],value:[]},activateOnMouseover:null,role:"listbox",keyMap:{"Ctrl+a":"selectAll"},title:null,virtualize:null,listItemHeight:10,isSelectable:()=>!0,emptyText:null}),Mi.initClass(),Mi.prototype.navigatorClass=Nr,Mi._$name="List";var P$=()=>!0,k$=(i,e)=>i.text.localeCompare(e.text),GR=i=>{var e;return e=class extends i{onFocusIn(...t){var r;super.onFocusIn(...t),this.formulaProvider&&((r=this.fieldsList)==null||r.show())}onFocusOut(...t){var r;(r=this.fieldsList)==null||r.hide(),super.onFocusOut(...t)}internalOnKeyEvent(t,...r){const n=this,{key:s}=t,{fieldsList:a}=n;if(t.type==="keydown")if(t.key!=="Enter"&&(n.lastKey=t.key),s==="Escape"&&(a!=null&&a.isVisible)){t.stopImmediatePropagation(),a.hide();return}else n.formulaPrefix&&s==="ArrowDown"&&(t.preventDefault(),a!=null&&a.isVisible||n.showFieldsList());super.internalOnKeyEvent(t,...r)}internalOnInput(...t){super.internalOnInput(...t),this.checkForFormula()}updateValue(...t){super.updateValue(...t),this.checkForFormula()}checkForFormula(){var t,r;this.formulaPrefix=(t=this.dataField)!=null&&t.inputPrefixRE?(r=this.value.match(this.dataField.inputPrefixRE))==null?void 0:r[1]:null}updateFormulaPrefix(t,r){var n,s,a;const o=this;o.formulaProvider=t&&((s=(n=o.dataField)==null?void 0:n.getFormulaProvider)==null?void 0:s.call(n,t)),r&&o.input.classList.toggle(`b-${r.toLowerCase()}-input`,!1),o.formulaProvider?(o.input.classList.toggle(`b-${t.toLowerCase()}-input`,!0),o.formulaProvider.setConfig({inputField:o,store:o.formulaStore}),o.whenVisible("showFieldsList")):(a=o.fieldsList)==null||a.hide()}get formula(){const{formulaProvider:t,value:r}=this;if(t){const{formulaRE:n}=t;return n?r.match(n):r}return""}showFieldsList(){var t,r;const n=this,{input:s}=n,a=(t=n.name)==null?void 0:t.replace(/^#/,""),o=n.up("gridbase",!0);let l=n.fieldsList;if(l)l.owner=n,l.widgetMap.fields.navigator.keyEventTarget=s;else{n.fieldFilter=a&&new dt(({id:c})=>c!==a);const{fieldNames:d}=n;l=n.fieldsList=new Rt({title:"Fields",cls:"b-formula-fieldlist",floating:!0,forElement:n.inputWrap,scrollAction:"realign",owner:n,autoShow:!1,align:{matchSize:"min",align:"t0-b0",axisLock:!0,minHeight:Math.min(3,d.length)*40},layoutStyle:{padding:0},layout:"fit",items:{fields:{type:"list",items:d,itemsFocusable:!1,scrollable:{overflowY:!0},navigator:{keyEventTarget:s,activateOnMouseover:!0},getItemCls(c){if(c.id==="this"||c.id==="data")return"b-special-field"},onItem({event:c,record:u}){c.type==="click"&&(n.lastKey=null),!c.key||c.key==="Enter"&&(n.lastKey==="ArrowDown"||n.lastKey==="ArrowUp")?n.selectField(u.id):c.stopImmediatePropagation=()=>delete c.stopImmediatePropagation}}}}),(r=n.owner)!=null&&r.cellEditorContext?(o.ion({cellMousedown:"onCellMousedown",cellClick:"onCellClick",thisObj:n,prio:99999}),n.record=n.owner.cellEditorContext.record):n.record||(n.record=n.formulaProvider.record)}l.show(),l.activeItem=null}onCellMousedown({event:t}){this.fieldsList.isVisible&&(t.preventDefault(),t.stopImmediatePropagation())}onCellClick({event:t,column:{field:r}}){if(this.fieldsList.isVisible)return t.stopImmediatePropagation(),this.selectField(r),!1}selectField(t){var r,n,s;const a=this,{input:o}=a,l=o.value.trim(),{selectionStart:d}=o,c=d>=l.length,u=l.endsWith(")")?l.length:l.length+2,h=((r=a.formulaProvider.prefix)==null?void 0:r.length)||0;if(d>h+1&&d<u){const f=`${c||(n=l[d-1])!=null&&n.match(/\s|\(/)?"":" "}$${t}${c||(s=l[d])!=null&&s.match(/\s|\)$/)?"":" "}`;o.setRangeText(f,d,d),o.selectionStart=d+f.length,a.inputting=!0,a.fetchInputValue(),a.inputting=!1}}get fieldNames(){var t;const r=this;if(!r._fields){const n=((t=r.formulaStore)==null?void 0:t.modelClass)||r.record.constructor,{fieldMap:s}=n,{fieldFilter:a}=r;(r._fields=n.fields.map(l=>{const d=typeof l=="string"?l:l.name;return{id:d,text:s[d].label}}).filter(a?dt.generateFiltersFunction([a]):P$).sort(k$)).push({text:"Record",id:"this"},{text:"Store",id:"data"})}return r._fields}},p(e,"$name","FormulaField"),p(e,"configurable",{dataField:null,formulaPrefix:null}),e},zi=class extends ut.mixin(GR){construct(i,...e){(i==null?void 0:i.inputType)==="hidden"&&(i.hidden=!0),super.construct(i,...e)}getCurrentToken(i=/\s/){const{value:e,selectionStart:t}=this.input;let r=t,n=t+1;if(!e.length||t==null)return null;for(;r>0&&!e[r-1].match(i);)r--;for(;n<e.length&&!e[n].match(i);)n++;return{token:e.substring(r,n),cursor:t,start:r,end:n}}};p(zi,"$name","TextField"),p(zi,"type","textfield"),p(zi,"alias","text"),p(zi,"configurable",{nullValue:""}),zi.initClass(),zi._$name="TextField";var Nb=class VF extends zi{static get configurable(){return{editable:!0,pickerAlignElement:"inputWrap",value:null,triggers:{expand:{cls:"bars"}},autoExpand:null,picker:{value:{floating:!0},$config:["lazy","nullify"]},inputType:"text",monitorResize:!0,nullValue:null}}doDestroy(){var e;(e=this.globalTapListener)==null||e.call(this),super.doDestroy()}changeEditable(e){return Y.isMobile&&this.initialConfig.editable!==!0&&(e=!1),e}updateEditable(e,...t){var r,n;const s=this,{element:a,ariaElement:o,nonEditableClickTarget:l}=s,{expand:d}=s.triggers,c=globalThis.matchMedia("(max-width: 410px)").matches;super.updateEditable(e,...t),a.classList.toggle("b-not-editable",!e),(r=s.globalTapListener)==null||r.call(s),(n=s.nonEditableClickTargetListener)==null||n.call(s),e===!1?(Y.isMobile&&c&&(d==null||d.hide()),o==null||o.removeAttribute("aria-autocomplete"),l&&(s.nonEditableClickTargetListener=j.on({element:l,click:u=>{const h=l.getRootNode().elementFromPoint(u.clientX,u.clientY);u.originalTarget===l&&h===l&&s.onTriggerClick(u)},thisObj:s}))):(d==null||d.show(),o==null||o.setAttribute("aria-autocomplete","list"),s.globalTapListener=ce.ion({globaltap:"showKeyboard",thisObj:s}))}get nonEditableClickTarget(){return this.input}get pickerAlignElement(){const{_pickerAlignElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:T.getPath(this,e)}changePicker(e,t){const r=this;return VF.reconfigure(t,e?X.merge({id:r.id+"-picker",owner:r,forElement:r.pickerAlignElement,align:{matchSize:e.width==null,anchor:r.overlayAnchor,target:r.pickerAlignElement}},e):null,r)}updatePicker(e){const t=this;t.detachListeners("pickerField.picker"),e&&(e.ion({name:"pickerField.picker",thisObj:t,show:"onPickerShow",hide:"onPickerHide"}),E.setAttributes(t.ariaElement,{role:t.role,"aria-haspopup":e.ownersRole,"aria-controls":e.id,"aria-expanded":e.isVisible}))}updateRole(e){(!this.isConfiguring||e==="textbox")&&this.ariaElement.setAttribute("role",e)}get childItems(){const e=super.childItems;return this._picker&&e.push(this.picker),e}onEditComplete(){super.onEditComplete(),this.hidePicker()}onElementResize(e){const t=this;t.pickerVisible&&t.picker.requestAnimationFrame(t.picker.realign,null,t.picker),super.onElementResize(e)}internalOnKeyEvent(e){var t,r;const n=this;let s=!0;if(e.type==="keydown"&&!n.disabled&&!e.shiftKey&&!e.ctrlKey)if(n.pickerVisible){const{picker:a}=n;e.key==="Escape"?(e.preventDefault(),e.stopImmediatePropagation(),n.hidePicker(),s=!1):a.onInternalKeyDown?a.onInternalKeyDown(e):e.key==="ArrowDown"&&a.focusable&&a.focus()}else e.key==="ArrowDown"&&n.picker&&!((r=(t=n.triggers)==null?void 0:t.expand)!=null&&r.keyMap)&&n.onTriggerKeyDown(e);s&&super.internalOnKeyEvent(e)}onFocusIn(e){var t;const r=this,n=(t=ce.currentPointerDown)==null?void 0:t.target;super.onFocusIn(e),r.autoExpand&&!(n!=null&&n.matches(".b-fieldtrigger"))&&(r.minChars=0,r.onTriggerClick(e))}onTriggerClick(e){this.disabled||this.togglePicker("key"in e)}onTriggerKeyDown(e){this.trigger("triggerKey",{event:e})!==!1&&(e.stopImmediatePropagation(),e.preventDefault(),this.onTriggerClick(e))}showKeyboard({event:e}){const t=this.input;E.isTouchEvent&&E.getActiveElement(t)===t&&e.target===t&&(ce.suspendFocusEvents(),t.blur(),t.focus(),ce.resumeFocusEvents())}togglePicker(e){this.pickerVisible?this.hidePicker():this.showPicker(e)}showPicker(e){var t;const r=this,{picker:n}=r;n&&(n.show(),(t=r.ariaElement)==null||t.setAttribute("aria-expanded",!0),n.isVisible&&e&&r.focusPicker())}onPickerShow(){const e=this;e.pickerActiveDescendant&&e.ariaElement.setAttribute("aria-activedescendant",e.pickerActiveDescendant),e.pickerVisible=!0,e.element.classList.add("b-open"),e.trigger("togglePicker",{show:!0}),e.pickerTapOutRemover=ce.ion({globaltap:"onPickerTapOut",thisObj:e}),e.pickerKeyDownRemover=j.on({element:e.picker.element,keydown:"onPickerKeyDown",thisObj:e})}onPickerHide(){var e,t;const r=this,{ariaElement:n}=r;r.pickerActiveDescendant=n==null?void 0:n.getAttribute("aria-activedescendant"),n==null||n.removeAttribute("aria-activedescendant"),n==null||n.setAttribute("aria-expanded",!1),r.pickerVisible=!1,r.element.classList.remove("b-open"),r.trigger("togglePicker",{show:!1}),(e=r.pickerTapOutRemover)==null||e.call(r),(t=r.pickerKeyDownRemover)==null||t.call(r)}onPickerTapOut({event:e}){!this.containsFocus&&!this.owns(e.target)&&this.hidePicker()}onPickerKeyDown(e){if(e.key==="Tab"&&!this.picker.trapFocus){const t=E.getActiveElement(this.input),r=new KeyboardEvent("keydown",e);this.input.dispatchEvent(r),r.defaultPrevented&&e.preventDefault(),E.getActiveElement(this.input)===t?this.input.focus():e.preventDefault(),this.isDestroyed||this.hidePicker()}}hidePicker(){this.pickerVisible&&this.picker.hide()}focusPicker(){}focus(){const e=this.input;E.isTouchEvent&&this.editable&&(e.readOnly=!0,this.setTimeout(()=>e.readOnly=!1,500)),super.focus()}};p(Nb,"$name","PickerField"),p(Nb,"type","pickerfield");var sa=Nb;sa._$name="PickerField";var Pn=class extends Mi{itemContentTpl(i,e){const t=this;return Ti.tpl`${t.iconTpl?this.iconTpl(i):""}
            ${t.itemTpl(i,e)}
            ${t.closable?'<div class="b-icon b-close-icon b-icon-clear" data-noselect></div>':""}`}onInternalKeyDown(i){const e=this,{selected:t}=e,{generation:r}=t;e.closable&&t.count&&(i.key==="Delete"||i.key==="Backspace")?(e.closeHandler?e.callback(e.closeHandler,e.owner,[t.values,{isKeyEvent:!0}]):e.store.remove(t.values),t.generation!==r&&i.stopImmediatePropagation()):super.onInternalKeyDown(i)}updateClosable(i){this.element.classList[i?"add":"remove"]("b-chips-closable"),this.isConfiguring||this.refresh()}onClick(i){const e=this,t=i.target.closest(`.${e.itemCls}`);if(e.closable&&i.target.classList.contains("b-close-icon")){const r=e.store.getAt(parseInt(t.dataset.index));e.closeHandler?e.callback(e.closeHandler,e.owner,[[r]]):e.store.remove(r)}else super.onClick(i)}};p(Pn,"$name","ChipView"),p(Pn,"type","chipview"),p(Pn,"configurable",{itemCls:"b-chip",multiSelect:!1,closable:!0,iconTpl:null,closeHandler:null}),Pn.initClass(),Pn._$name="ChipView";var Wb="L{fieldRequired}",Zo="L{validateFilter}",L$="L{Field.tooShort}",O$="L{recordNotCommitted}",$$=/[\w\s]/,Ye=class extends sa{static get configurable(){return{primaryFilter:{},picker:{type:"list",floating:!0,scrollAction:"realign",itemsFocusable:!1,align:{align:"t0-b0",axisLock:!0},maxHeight:324,scrollable:{overflowY:!0},autoShow:!1,focusOnHover:!1},multiSelect:null,items:null,store:null,valueField:void 0,displayField:"text",clearWhenInputEmpty:null,pickerWidth:null,minChars:null,selected:null,listItemTpl:null,displayValueRenderer:null,listCls:null,triggers:{expand:{cls:"b-icon-picker",handler:"onTriggerClick"}},filterParamName:null,encodeFilterParams:i=>i.map(e=>e.value),filterOnEnter:!1,hideTrigger:null,overlayAnchor:null,keyStrokeFilterDelay:null,defaultAction:"select",triggerAction:"all",filterOperator:"startsWith",caseSensitive:!1,hidePickerOnSelect:null,chipView:{$config:["lazy","nullify"],value:{type:"combochipview"}},chipStore:{$config:["lazy","nullify"],value:{}},filterSelected:null,emptyText:"L{Combo.noResults}",value:null,valueCollection:{$config:["nullify","lazy"],value:{}},validateFilter:!0,clearTextOnPickerHide:!0,clearTextOnSelection:!0,destroyStore:!1,multiValueSeparator:",",createOnUnmatched:null,role:"combobox",inlinePicker:null,testConfig:{keyStrokeFilterDelay:0,nonEditableFilterTimeout:200},localizeDisplayFields:!1,buildItems:null,sortItemsOnLocaleChange:!1,nonEditableFilterTimeout:2e3}}static get queryLast(){return"last"}construct(i){super.construct(...arguments),this.store||(this.items=[]),this.filterOnEnter&&(this.hideTrigger=!0)}startConfigure(i){this.usingRecordAsValue=i.valueField===null,super.startConfigure(...arguments)}afterConfigure(){super.afterConfigure();const i=this;T.hasOwn(i,"_value")||(i._value=i.nullValue,i._lastValue=i._lastValue||i._value)}get childItems(){const{_chipView:i}=this,e=super.childItems;return i&&e.push(i),e}get innerElements(){var i;const e=(i=this._chipView)==null?void 0:i.element,{input:t,inputElement:r}=this;return e&&he.sync({targetElement:t,domConfig:r}),[e||r]}updateInlinePicker(i){i&&(this.element.classList.add("b-inline-picker"),this.getConfig("picker"),this.triggers.expand=null,this.pickerVisible=!0)}hidePicker(...i){if(!this.inlinePicker)return super.hidePicker(...i)}changeChipStore(i){return i&&!(i instanceof ue)&&(i=new ue(ue.mergeConfigs({storage:this.valueCollection},i))),i}updateChipStore(i,e){e==null||e.destroy()}changeChipView(i,e){const t=this;if(t.element.classList[i?"add":"remove"]("b-uses-chipview"),i){const{input:r}=t;return t.chipStore||(t.chipStore={}),qu.reconfigure(e,i,{defaults:{parent:t,insertBefore:r,store:t.chipStore,closable:!t.readOnly,label:t.label,ariaLabel:t.ariaLabel,navigator:{type:"combochipnavigator",disabled:t.readOnly,keyEventTarget:r}}})}e==null||e.destroy()}updateChipView(i){var e;const t=this;t._chipViewEventDetacher=(e=t._chipViewEventDetacher)==null?void 0:e.call(t),t.chipStore=i==null?void 0:i.store,i&&(i.element.appendChild(t.input),t._chipViewEventDetacher=j.on({element:i.element,mousedown:"onChipViewMousedown",thisObj:t}))}updateMultiSelect(i,e){const t=this,{input:r,element:n}=t,s=!t.isConfiguring;let{value:a}=t;if(n.classList[i?"add":"remove"]("b-multiselect"),i){const{chipView:o}=t,{parentNode:l}=r,d=o==null?void 0:o.element;d&&d!==l&&(l.insertBefore(d,r),d.appendChild(r),t.chipView.refresh(),n.classList.add("b-uses-chipview")),r.value="",s&&(a=L.asArray(a))}else{const o=t._chipView,{parentNode:l}=r,d=o==null?void 0:o.element;d===l&&(d.parentNode.insertBefore(r,d),d.remove(),n.classList.remove("b-uses-chipview")),s&&typeof a!="string"&&(a=a!=null&&a.length?a[0]:null)}s&&(t.value=a),t.isConfiguring||t.updateEditable(t.editable,null)}onChipViewMousedown(i){i.preventDefault(),this.containsFocus||this.focus()}onChipClose(i,e={}){(e.isKeyEvent&&this.input.value===""||!e.isKeyEvent)&&(this._isUserAction=!0,this.valueCollection.remove(i),this._isUserAction=!1)}updateFilterParamName(i){this.hideTrigger!==!1&&(this.hideTrigger=!!i)}updateHideTrigger(i){this.element.classList[i?"add":"remove"]("b-hide-trigger")}updateKeyStrokeFilterDelay(i){this.filterOnInput.delay=i}updateReadOnly(i){super.updateReadOnly(...arguments),this._chipView&&(this._chipView.closable=!i)}updateDisabled(i,e){super.updateDisabled(i,e),this._chipView&&(this._chipView.closable=!i)}updateFilterOperator(i){this.primaryFilter&&(this.primaryFilter.operator=i)}get minChars(){var i;return(i=this._minChars)!=null?i:this.remoteFilter?4:1}get validateFilter(){return this._validateFilter&&!this.createOnUnmatched}get items(){return this.store.allRecords}updateBuildItems(i){i&&(this.items=i.call(this))}changeItems(i){const e=this;if(i==null){if(e.store&&!e.store.isItemStore)return;i=[]}if(e.buildItems&&!(i!=null&&i.length)&&(i=e.buildItems()),i instanceof ue){e.store=i;return}const t=!("valueField"in e.initialConfig),r=e.displayField;let n,s=e.valueField,a;Array.isArray(i)?a=i.map(l=>{let d=l;return l instanceof me?(n=l.constructor,t&&!s&&(e.valueField=s=n.idField)):typeof l=="string"||typeof l=="number"?(t&&!s&&(e.valueField=s=e.displayField),d={[s]:l,[r]:l}):(t&&!s&&(e.valueField=s="value"),Array.isArray(l)&&(d={[s]:l[0],[r]:l[1]})),l.selected&&(e.value=d),d}):(t&&!s&&(e.valueField=s="value"),a=[],Object.entries(i).forEach(([l,d])=>{a.push({[s]:l,[r]:d})}));const o=s===r?{name:"value",dataSource:r}:s;if(!n){class l extends me{static get idField(){return e.valueField}static set idField(c){super.idField=c}static get fields(){const c=[o,r];return e.localizeDisplayFields&&c.push("localeClass"),c}}n=l}e.store?e.store.setConfig({modelClass:n,data:a}):e.store=new ue({isItemStore:!0,data:a,idField:s,verifyNoGeneratedIds:!1,modelClass:n,useRawData:!1})}get value(){const i=this,{valueCollection:e,valueField:t}=i;if(t==null)return i.multiSelect?e.values.slice():e.first;let r;return i.multiSelect?r=e.count?e.map(n=>n[t]):i._unmatchedValue||[]:r=e.count?e.first[t]:i._unmatchedValue||i.nullValue,r}set value(i){super.value=i}get needsInputSync(){return this.usesChipView?!1:!this.editable}changeValue(i,e){var t,r;const n=this,{multiSelect:s}=n;if(n._unmatchedValue=null,i===e){n.syncInputFieldValue(!0);return}if(!s&&Array.isArray(i)&&i.length>1)throw new Error("Multiple values cannot be set to a non-multiSelect Combo");n.triggerConfig("items"),n.inputting||(t=n._chipView)==null||t.selected.clear(),n.store||(n.items=[]);const{valueField:a,displayField:o,nullValue:l,store:d,valueCollection:c,_picker:u}=n,{storage:h}=d,f=(r=n.hidePickerOnSelect)!=null?r:!s,g=n._isUserAction||(u==null?void 0:u._isUserAction)||f&&n.pickerVisible||!1;if(i==l||i==null)if(c.count)c.clear();else{const m=n._value;n._value=null,n.syncInputFieldValue(),n.syncEmpty(),n.isConfiguring||n.triggerFieldChange({value:i,oldValue:m,userAction:g,valid:n.isValid})}else{let m;if(!n.remoteFilter&&d.isAjaxStore&&!d.count){d.ion({load:()=>n.value=i,once:!0,thisObj:n}),n._unmatchedValue=i;return}const v=Array.isArray(i),y=v?i.slice():[i];if(n.remoteFilter){if(T.isObject(i)||i.isModel)d.getById(i.id)?n.valueCollection.splice(0,n.valueCollection.count,d.getById(i.id)):(d.data=[i],n.valueCollection.splice(0,n.valueCollection.count,d.first));else{const D=n.isConfiguring;n.primaryFilter.setConfig({value:i,disabled:!1}),d.performRemoteFilter(!0).then(()=>{if(n.isDestroyed)return;const{isConfiguring:w}=n;n.isConfiguring=D,c.splice(0,c.count,d.allRecords),n.isConfiguring=w})}return}else d.isFiltered?(d.isChained&&d.fillFromMaster(),n.primaryFilter.disabled=!0,d.filter()):d.isChained&&d.fillFromMaster();for(let D=0,w=y.length;D<w;D++){let x=y[D];if(x instanceof me)h.includes(x,!0)||d.add(x);else{const R=T.isObject(x);R&&a&&(x=x[d.modelClass.fieldMap[a].dataSource]),m=h.getBy(o,x)||h.getBy(a,x)||c.getBy(o,x)||c.getBy(a,x),m instanceof Set&&(m=[...m][0]),m?(R&&m.set(y[D]),y[D]=m):(y.splice(D,1),w--,D--)}}const b=!y.length,C=c.generation;c.splice(0,c.count,y),b&&(n._value=v&&i.length===0?null:i,n._unmatchedValue=n._value),(b||c.generation===C)&&n.syncInputFieldValue(),n.syncEmpty(),b&&!n.isConfiguring&&n.triggerFieldChange({value:i,oldValue:e,userAction:g,valid:n.isValid})}n.remoteFilter||(n._lastValue=n._value)}hasChanged(i,e){return this.multiSelect?!T.isEqual(i,e):super.hasChanged(...arguments)}onComboStoreChange({action:i}){i!=="filter"&&this.syncInputFieldValue(!0)}syncInputFieldValue(i){var e;this.usesChipView?(e=this.chipView)==null||e.refresh():super.syncInputFieldValue(i)}get usesChipView(){return!!(this.multiSelect&&this._chipView)}get isEmpty(){return this.valueCollection.count===0&&!this._unmatchedValue}get inputValue(){const i=this;let e=i.selected?i.selected[i.displayField]:i.value;return i.displayValueRenderer&&(e=i.callback(i.displayValueRenderer,i,[i.selected,i])),e==null?"":e}get nonEditableClickTarget(){var i;return this.multiSelect&&((i=this.chipView)==null?void 0:i.element)||super.nonEditableClickTarget}changeValueCollection(i,e){if(e==null||e.destroy(),i)return i.isCollection||(i=new Bi({internalListeners:{noChange:"onValueCollectionNoChange",change:"onValueCollectionChange",prio:-1e3,thisObj:this}})),i}changePrimaryFilter(i){return i.isCollectionFilter?i.setConfig({disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive}):(typeof i=="function"&&(i={filterBy:i}),i=new dt({id:"primary",disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive,...i})),i}changeStore(i){const e=this,t=[],{valueCollection:r,keyStrokeFilterDelay:n,filterParamName:s}=e;if(Array.isArray(i)){e.items=i;return}let a;if(i){if(i.isStore){const o=i.filters.get("primary");e.remoteFilter&&(i.filterParamName=s),a=i.remoteFilter,o?e.primaryFilter=o:t.push(e.primaryFilter)}else typeof i=="string"?i=ue.getStore(i):(i=new(i.readUrl?pt:ue)(i),e.destroyStore=!0),a=e.remoteFilter||i.restfulFilter,a&&s&&(i.filterParamName=s,e.encodeFilterParams&&(i.encodeFilterParams=e.encodeFilterParams)),t.push(e.primaryFilter);if(!e.valueField&&!e.usingRecordAsValue&&(e.valueField=i.modelClass.idField),e.filterSelected){const o=l=>!e.containsFocus||!r.includes(l);a?(i.storage.autoFilter=!0,i.storage.addFilter({id:`${e.id}-selected-filter`,filterBy:o})):(t.push(o),i.reapplyFilterOnAdd=!0)}r.addIndex({property:e.displayField,unique:!1}),r.addIndex({property:e.valueField,unique:!0}),t.forEach(o=>i.addFilter(o,!0)),a?e.keyStrokeFilterDelay=Math.max(300,n||0):e.keyStrokeFilterDelay=n!=null?n:10}return e.valueField===e.displayField&&!e.peekConfig("multiSelect")&&(e.nullValue=""),i}updateStore(i,e){const t=this,{_picker:r}=t;let n;t.destroyStore&&e&&e.destroy(),r&&(r.store=i),i.storage.addIndex({property:t.displayField,unique:!1}),i.storage.addIndex({property:t.valueField,unique:!0}),n={filter:"onStoreFilter"},t.displayValueRenderer&&((n||(n={})).change="onComboStoreChange"),t.detachListeners("store"),i!=null&&i.storage&&t.valueCollection.match(i.storage),t.syncInputFieldValue(),n&&(n.name="store",n.thisObj=t,i.ion(n))}get remoteFilter(){var i;return!!(this.filterParamName||(i=this._store)!=null&&i.restfulFilter)}get record(){return this.selected}get records(){return this.valueCollection.values.slice()}get selected(){const{store:i}=this;return this.multiSelect?this.valueCollection.values.slice().sort((e,t)=>i.indexOf(e)-i.indexOf(t))[0]:this.valueCollection.first}onEditComplete(){const i=this,e=i.valueCollection.count;super.onEditComplete(),e&&(i.clearError(Zo),i.syncInputFieldValue()),i.required&&!e&&i.setError(Wb)}onTriggerClick(i){var e;const t=this,r="key"in i;if(!(t.remoteFilter&&t.filterOnEnter)){if(t.pickerVisible)t.hidePicker();else if(!t.readOnly&&!t.disabled)switch((e=t.triggerAction)==null?void 0:e.toLowerCase()){case"all":t.doFilter(null,r);break;case"last":t.doFilter(t.lastQuery,r);break;default:t.doFilter(t.input.value,r)}}}internalOnInput(i){const e=this;e.clearWhenInputEmpty&&e.input.value===""&&(e._isUserAction=!0,e.clear(),e._isUserAction=!1),e.syncEmpty(),e.syncInputWidth(),e.filterOnInput(i),e.trigger("input",{value:e.input.value,event:i})}filterOnInput(i){const e=this,{value:t}=i.type==="input"?i.target:e.input,r=t.length;e.inputting=!0,e.inlinePicker||r>=e.minChars&&(!e.filterOnEnter||i.key==="Enter")?e.doFilter(t):(e.validateFilter&&!e.remoteFilter&&e[r?"setError":"clearError"](Zo),e.hidePicker()),e.inputting=!1}syncInputWidth(){const i=this;if(i.usesChipView){const e=i.input,t=i._inputPadding||(i._inputPadding=E.getEdgeSize(e,"padding","lr")),r=e.value||"",n=E.measureText(r+"W",e,!1,i.element)+t.width;e.style.flex=`1 1 ${Math.ceil(n)}px`}}doFilter(i,e){var t;const r=this,{store:n,picker:s}=r,a=i==null||i==="";r.lastQuery=i,r.primaryFilter.setConfig({value:i,disabled:a}),r.remoteFilter&&n.clear(!0);const o=()=>{const{navigator:l,isVisible:d}=s;n.count?!a&&l&&(l.activeItem=0):!r.remoteFilter&&!a&&(l&&(l.activeItem=null),r.editable&&r.validateFilter&&r.setError(Zo)),d&&s.realign()};(t=r.filterPromise=n.filter())==null||t.then(()=>{r.filterPromise=null,o()}),r.inlinePicker||(s!=null&&s.isVisible?s.lastAlignSpec.zone===0&&s.realign():r.showPicker(e)),r.filterPromise||o()}onStoreFilter({source:i}){const e=this,t=e._picker,r=t==null?void 0:t.element.dataset,{count:n}=i;e.remoteFilter&&(n?t&&(t.navigator.activeItem=0):e.validateFilter&&e.setError(Zo),e.filterSelected&&e.valueCollection.count&&(i.storage.onFiltersChanged({action:"splice",oldCount:1}),t&&t.refresh())),r&&(e.createOnUnmatched&&!n&&e.primaryFilter.value!=null?r.addNewValue=e.L("L{addNewValue}")(e.primaryFilter.value):r==null||delete r.addNewValue)}onValueCollectionChange({source:i}){var e,t,r,n;const s=this,{multiSelect:a,_picker:o,nullValue:l}=s,d=(e=s.hidePickerOnSelect)!=null?e:!a,c=a?i.values.slice():i.first,u=i.values.slice(),h=s._isUserAction||(o==null?void 0:o._isUserAction)||d&&s.pickerVisible||!1,f=s._value;if(d&&s.hidePicker(),a&&s.clearTextOnSelection&&(s.input.value=""),!i.count&&s.required?s.setError(Wb):(s.clearError(Wb),s.clearError(Zo)),s.validateFilter&&c&&s.clearError(Zo),s.filterSelected){const m=o==null?void 0:o.navigator,v=Number((r=(t=m==null?void 0:m.activeItem)==null?void 0:t.dataset)==null?void 0:r.index);s.remoteFilter?(s.store.storage.onFiltersChanged({action:"splice",oldCount:1}),s._picker&&s._picker.refresh()):s.store.filter(),isNaN(v)||(m.activeItem=Math.min(o.store.count,v))}s._value=l;const g=s._lastValue=s.cacheCurrentValue(s.value);s.syncInputFieldValue(),s.syncEmpty(),s.isConfiguring||(g!==f&&!s.onConfigChange.$nullFn&&s.onConfigChange({name:"value",value:g,was:f,config:s.$meta.configs.value}),s.triggerFieldChange({value:g,oldValue:f,userAction:h,valid:s.isValid}),(n=s.trigger)==null||n.call(s,"select",{record:c,records:u,userAction:h}),s.defaultAction==="select"&&s.trigger("action",{value:g,record:c,records:u,userAction:h}))}cacheCurrentValue(i){return this._value=i}onValueCollectionNoChange({toAdd:i}){!this.inlinePicker&&!this.multiSelect&&i.length&&this.pickerVisible&&(this.picker.hide(),this.syncInputFieldValue())}showPicker(...i){var e;const t=this,{picker:r}=t;t.readOnly||t.inlinePicker||(r.multiSelect=t.multiSelect,super.showPicker(...i),t.overlayAnchor&&!r.align.offset&&(r.align.offset=-r.anchorSize[1],r.realign()),r.restoreActiveItem&&(t.multiSelect?r.restoreActiveItem(((e=r.navigator)==null?void 0:e.previousActiveItem)||t.selected||0,!0):r.restoreActiveItem(t.selected||0,!0)),t.input.focus())}changePicker(i,e){if(i){const t=this,r=t.pickerWidth||(i==null?void 0:i.width),n=Mi.mergeConfigs({owner:t,store:t.store,selected:t.valueCollection,multiSelect:t.multiSelect,cls:t.listCls,displayField:t.displayField,forElement:t.pickerAlignElement,emptyText:t.emptyText,align:{matchSize:r==null?"min":!1,anchor:t.overlayAnchor,target:t.pickerAlignElement,minHeight:t.inlinePicker?null:Math.min(3,t.store.count)*40},[t.listItemTpl?"itemTpl":void 0]:t.listItemTpl,width:r,navigator:{keyEventTarget:t.input,activateOnMouseover:!t.inlinePicker}},i);t.inlinePicker&&Object.assign(n,{floating:!1,align:null,maxHeight:null,appendTo:t.element}),i=Mi.reconfigure(e,i?n:null,t),i.element.classList.add("b-combo-picker"),i.ion({navigate:"onPickerNavigate",thisObj:t}),j.on({element:i.element,pointerdown:s=>t.onPickerNavigate({event:s}),thisObj:t})}else e==null||e.destroy();return i}onPickerNavigate({event:i}){i.target.matches("[data-add-new-value]")&&this.addNewRecord(this.primaryFilter.value)}onPickerHide(){const i=this;super.onPickerHide(),i.multiSelect&&i.clearTextOnPickerHide&&!i.errors&&(i.input.value="")}async internalOnKeyEvent(i){var e;const t=this,r=t.input[t.inputValueAttr],n=r.length,{key:s,type:a}=i,{primaryFilter:o,store:l,multiSelect:d,minChars:c,_picker:u,_chipView:h}=t;let f;if(a==="keydown"&&(u!=null&&u.isVisible)&&u.navigator){const{activeItem:g}=u.navigator;if(g&&d&&s===t.multiValueSeparator){t.input.value="",u.onItemClick(g,i),o.setConfig({value:"",disabled:!0}),l.filter(),u.hide(),i.preventDefault();return}if(!g&&t.createOnUnmatched&&(d&&s===t.multiValueSeparator||s==="Enter")){i.preventDefault(),await t.addNewRecord(r);return}}t.editable?h&&!h.selected.count&&a==="keydown"&&s==="Backspace"&&!n&&(h.navigator.activeItem=t.valueCollection.count-1,i.stopImmediatePropagation()):a==="keydown"&&s==="Backspace"&&((e=t.nonEditableFilterValue)!=null&&e.length)?(t.nonEditableFilterValue=t.nonEditableFilterValue.substring(0,t.nonEditableFilterValue.length-1),t.doFilter(t.nonEditableFilterValue),t.lastFilterKeypressTime=i.timeStamp):a==="keypress"&&s.length===1&&s.match($$)&&((!t.lastFilterKeypressTime||i.timeStamp-t.lastFilterKeypressTime>t.nonEditableFilterTimeout)&&(t.nonEditableFilterValue=""),t.nonEditableFilterValue=(t.nonEditableFilterValue||"")+s,t.doFilter(t.nonEditableFilterValue),t.lastFilterKeypressTime=i.timeStamp),t.pickerVisible&&s==="Enter"&&t.primaryFilter.value===t.input.value&&(f=!0),super.internalOnKeyEvent(...arguments),i.type==="keydown"&&s==="Enter"&&!f&&t.remoteFilter&&(n>=c?(i.stopPropagation(),t.filterOnInput.now(i)):n>0&&(i.stopPropagation(),t.setError(L$+` (${c})`,!1,!0)))}async addNewRecord(i){var e,t;const r=this,{store:n,_picker:s,valueCollection:a,multiSelect:o,primaryFilter:l}=r,d=n.remoteFilter&&n.autoCommit;r.filterPromise&&await r.filterPromise,d||(l.setConfig({value:"",disabled:!0}),n.filter()),r._isUserAction=!0;const[c]=n.add(r.callback(r.createOnUnmatched,r,[i,r]));if(n.isCommitting){let u;try{await n.autoCommitTimeoutPromise,await n.commitPromise}catch(h){u=(t=(e=h.response)==null?void 0:e.parsedJson)==null?void 0:t.error}c.isPhantom&&(r.clearError(),r.setError(u||O$,!1,!0),n.remove(c),n.removed.remove(c))}d&&(l.setConfig({value:"",disabled:!0}),n.filter()),r.input.value="",n.includes(c)&&a.splice(o?a.count:0,o?0:a.count,c),s==null||s.hide(),r._isUserAction=!1}changeCreateOnUnmatched(i){return i===!0&&(i=this.defaultRecordCreator),i}defaultRecordCreator(i){return this.store.createRecord({[this.displayField]:i})}updateLocalizeDisplayFields(i){i?this.localizableProperties.push("store"):L.remove(this.localizableProperties,"store")}localizeProperty(i){return i==="store"?this.localizeStore():super.localizeProperty(i)}localizeStore(){var i;const e=this,{displayField:t}=e;let{localizedDisplayFieldsMap:r}=e;r||(e.localizedDisplayFieldsMap=r=new Map),!e.store&&e.buildItems&&(e.items=e.buildItems());for(const n of e.items)if(n.id){let s=r.get(n.id);!s&&((i=n[t])!=null&&i.startsWith("L{"))&&(s=n[t],r.set(n.id,s)),s&&(n[t]=(n.localeClass||e).L(s))}e.sortItemsOnLocaleChange&&e.store.sort(),e.syncInputFieldValue()}createOverflowTwin(i){return super.createOverflowTwin({store:this.store,...i})}};p(Ye,"$name","Combo"),p(Ye,"type","combo"),p(Ye,"alias","combobox,dropdown"),p(Ye,"delayable",{filterOnInput:0});var qu=class extends Pn{};p(qu,"$name","ComboChipView"),p(qu,"type","combochipview"),p(qu,"configurable",{closeHandler:"up.onChipClose",itemsFocusable:!1,multiSelect:!0,itemTpl(i){return k.encodeHtml(i.getValue(this.owner.displayField))},scrollable:{overflowY:"auto"}});var Ub=class extends Nr{static get configurable(){return{allowShiftKey:!0}}onTargetClick(i){const e=this,t=i.target.closest(e.itemSelector);t&&!i.target.classList.contains("b-close-icon")&&(!i.shiftKey&&!t.contains(i.target.closest("[data-noselect]"))&&e.ownerCmp.selected.clear(),e.inClickHandler=!0,e.activeItem=t,e.inClickHandler=!1)}onKeyDown(i){i.key!=="Enter"&&!i.target.selectionStart&&!i.target.selectionEnd&&super.onKeyDown(i)}updateActiveItem(i,e){const t=this.ownerCmp;super.updateActiveItem(i,e),i&&!this.inClickHandler&&t.selected.add(t.getRecordFromElement(i))}navigatePrevious(i){const e=this.ownerCmp;e.navigator.activeItem&&!i.shiftKey&&e.selected.clear(),this.previous?super.navigatePrevious(i):this.activeItem=null}navigateNext(i){const e=this.ownerCmp;e.navigator.activeItem&&!i.shiftKey&&e.selected.clear(),this.next?super.navigateNext(i):this.activeItem=null}};p(Ub,"$name","ComboChipNavigator"),p(Ub,"type","combochipnavigator"),Ye.initClass(),qu.initClass(),Ub.initClass(),Ye._$name="Combo";var Yu=class extends Ye{static get configurable(){return{positiveValue:!0,positiveText:null,negativeValue:!1,negativeText:null,store:{value:[],$config:"lazy"},value:!1}}changeStore(i,e){const t=this;return super.changeStore(new ue({data:[{id:t.positiveValue,text:t.positiveText||t.L("L{Object.Yes}")},{id:t.negativeValue,text:t.negativeText||t.L("L{Object.No}")}]}),e)}};p(Yu,"$name","BooleanCombo"),p(Yu,"type","booleancombo"),Yu.initClass(),Yu._$name="BooleanCombo";var B$=({$toggleOrder:i},{$toggleOrder:e})=>(e||0)-(i||0),qR={click:"resetValueCache",beforeToggle:"onItemBeforeToggle",toggle:"onItemToggle"},Tm=class jF extends ct.mixin(lm,Ko){afterConstruct(){super.afterConstruct(),this.ion({change:"internalOnChange"})}get inputWrap(){return this.element}get isValid(){let e=super.isValid;const t=this,{toggleable:r}=t;return t.clearError("L{Field.fieldRequired}",!0),e&&!t.disabled&&(t.required&&!t.value||r&&t.pressed.length<r[0])&&(e=!1,t.setError("L{Field.fieldRequired}",!0)),t.checkValidity&&t.callback(t.checkValidity,t,[t])===!1&&(e=!1),e&&t.errors&&Object.keys(t.errors).length&&(e=!1),e}get pressed(){return this.items.filter(e=>e.pressed).sort(B$)}internalOnChange(){this.syncInvalid()}onChildAdd(e){super.onChildAdd(e),e.ion({thisObj:this,...qR,prio:1e4})}onChildRemove(e){e.un({thisObj:this,...qR}),super.onChildRemove(e)}onItemBeforeToggle({pressed:e}){const{toggleable:t}=this;return e||!t||this.pressed.length>t[0]}onItemToggle(e){const t=this,r=(t.toggleCount||0)+1,{toggleable:n}=t;t.resetValueCache(),!t.isSettingValue&&(!t.toggleGroup||e.pressed)&&(n&&(e.source.$toggleOrder=r,t.toggleCount=r,t.isSettingValue=!0,t.pressed.slice(n[1]).forEach(s=>s.pressed=!1),t.isSettingValue=!1),t.triggerFieldChange({value:t.value,userAction:!0,event:e}))}resetValueCache(){this._value=null}createWidget(e){const t=this;return t.constructor.resolveType(e.type||"button").isButton&&(t.color&&!e.color&&(e.color=t.color),!e.toggleGroup&&t.toggleGroup&&(e.toggleGroup=t.toggleGroup),t.toggleable&&(e.toggleable=!0)),t.columns&&(e.width=`${100/t.columns}%`),e=super.createWidget(e),t.relayEvents(e,["click","action","toggle"]),e}changeToggleable(e){return e===!0?e=[0,1/0]:typeof e=="number"&&(e=[1,e]),e||null}updateToggleable(e){e&&!this.isConstructing&&this.pressed.slice(e[1]).forEach(t=>t.pressed=!1)}changeToggleGroup(e,t){return e===!0?t||jF.generateId("toggleGroup"):e}updateRotate(e){this.eachWidget(t=>{t.rotate!==!1&&(t.rotate=e)})}get valueAsArray(){return this.items.flatMap(e=>e.pressed&&e.value!==void 0?e.value:[])}get value(){const e=this;return e._value||(e._value=e.valueAsArray.join(e.valueSeparator)),e._value}changeValue(e,t){const r=this;return e==null?e=[]:typeof e=="string"?e=e.split(r.valueSeparator):Array.isArray(e)||(e=[e]),r.isSettingValue=!0,r.items.forEach(n=>{n.value!==void 0&&(n.pressed=e.includes(n.value))}),r.isSettingValue=!1,r.valueAsArray.join(r.valueSeparator)}updateValue(e){this.isConfiguring||this.triggerFieldChange({value:e,userAction:!!this._isUserAction})}get validity(){return{}}onDisabled(e){this.syncInvalid(),this.items.forEach(t=>t.disabled=e||!t.ignoreParentReadOnly&&this.readOnly)}updateReadOnly(e){super.updateReadOnly(e),this.updateDisabled(this.disabled)}addToOverflowMenu(e,t,r){const{toggleable:n,toggleGroup:s}=this;(s||(n==null?void 0:n[0])===1&&n[1]===1)&&(t={...t,radio:!0}),this.items.forEach(a=>a.addToOverflowMenu(e,t,r))}get widgetClassList(){const e=super.widgetClassList;return this.columns&&e.push("b-columned"),e}updateUseGap(e){e||this.element.classList.add("b-no-gap")}};p(Tm,"$name","ButtonGroup"),p(Tm,"type","buttongroup"),p(Tm,"configurable",{defaultType:"button",cls:null,items:null,color:null,useGap:!1,toggleGroup:null,valueSeparator:",",columns:null,hideWhenEmpty:!0,defaultBindProperty:"value",errorTooltipCachePath:"buttonGroupErrorTooltip",errorTooltipConfig:{forSelector:".b-buttongroup.b-invalid"},overflowable:!0,toggleable:null,value:null});var Qo=Tm;Qo.initClass(),Qo._$name="ButtonGroup";var Gb={0:1,6:1},kn=class extends Rt{static get configurable(){return{layout:"vbox",textContent:!1,date:{$config:"date"},month:{},year:null,weekStartDay:null,sixWeeks:!0,showWeekColumn:null,disabledDates:null,headerRenderer:null,weekRenderer:null,cellRenderer:null,disableWeekends:null,disableNonWorkingDays:null,hideNonWorkingDays:null,hideNonWorkingDaysCls:"b-hide-nonworking-days",nonWorkingDays:null,tip:null,dayCellCls:"b-calendar-cell",dayHeaderCls:"b-calendar-day-header",disabledCls:"b-disabled-date",otherMonthCls:"b-other-month",weekendCls:"b-weekend",todayCls:"b-today",nonWorkingDayCls:"b-nonworking-day",dayNameFormat:"ddd",minRowHeight:{$config:["lazy"],value:null},minColumnWidth:{$config:["lazy"],value:null},disableOtherMonthCells:null,disableOtherMonthCellsCls:"b-disable-othermonth-cells",hideOtherMonthCells:null,hideOtherMonthCellsCls:"b-hide-othermonth-cells",animateTimeShift:!0}}construct(i){super.construct(i),this.refreshCount||this.refresh()}onInternalPaint({firstPaint:i}){var e;(e=super.onInternalPaint)==null||e.call(this,...arguments),i&&(this.refreshCount||this.refresh(),this.getConfig("minColumnWidth"),this.getConfig("minRowHeight"))}get overflowElement(){return this.weeksElement}doDestroy(){var i;(i=this.tip)==null||i.destroy(),super.doDestroy()}updateMinRowHeight(i){this.element.style.setProperty("--min-row-height",E.setLength(i)),this.scrollable={overflowY:i?"auto":!1}}updateMinColumnWidth(i){this.element.style.setProperty("--min-column-width",E.setLength(i)),this.scrollable={overflowX:i?"auto":!1},this.overflowElement.classList[i?"add":"remove"]("b-min-columnwidth")}getDateFromDomEvent(i){const e=(i.nodeType===Element.ELEMENT_NODE?i:i.target).closest(`#${this.id} [data-date]`);if(e)return S.parseKey(e.dataset.date)}changeTip(i,e){const t=this;return Fe.reconfigure(e,i,{owner:t,defaults:{type:"tooltip",owner:t,id:`${t.id}-cell-tip`,forElement:t.bodyElement,forSelector:`.${t.dayCellCls}`}})}updateTip(i){this.detachListeners("tip"),i==null||i.ion({pointerOver:"onTipOverCell",name:"tip",thisObj:this})}updateElement(i,e){const t=this;super.updateElement(i,e),t.updateHideNonWorkingDays(t.hideNonWorkingDays),t.weekdayCells=Array.from(i.querySelectorAll(".b-calendar-day-header")),t.weekElements=Array.from(i.querySelectorAll(".b-calendar-week")),t.weekDayElements=Array.from(i.querySelectorAll(".b-calendar-days")),t.cellElements=[];for(let r=0,{length:n}=t.weekDayElements;r<n;r++)t.cellElements.push(t.weekDayElements[r].previousSibling,...t.weekDayElements[r].children)}changeDate(i){if(i=typeof i=="string"?S.parse(i):new Date(i),isNaN(i))throw new Error("CalendarPanel date ingestion must be passed a Date, or a YYYY-MM-DD date string");return S.clearTime(i)}updateDate(i){this.month.date=i,this.element.dataset.month=S.format(i,"YYYY-MM")}updateDayNameFormat(){const i=new Date("2000-06-04T12:00:00");this.shortDayNames=[];for(let e=4;e<11;e++)i.setDate(e),this.shortDayNames.push(S.format(i,this.dayNameFormat))}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:S.weekStartDay}updateWeekStartDay(i){const e=this;if(e._month){e.month.weekStartDay=i,e.dayNames=[];for(let t=0;t<7;t++)e.dayNames[t]=e.shortDayNames[e.canonicalDayNumbers[t]];e.refreshCount&&e.refresh()}}updateHideNonWorkingDays(i){var e;this.contentElement.classList.toggle(this.hideNonWorkingDaysCls,!!i),(e=this.scrollable)==null||e.syncOverflowState(),this._month&&(this.month.hideNonWorkingDays=i),this.isConfiguring||this.refresh()}updateHideOtherMonthCells(i){var e;this.element.classList.toggle(this.hideOtherMonthCellsCls,!!i),(e=this.scrollable)==null||e.syncOverflowState()}updateDisableOtherMonthCells(i){var e;this.element.classList.toggle(this.disableOtherMonthCellsCls,!!i),(e=this.scrollable)==null||e.syncOverflowState()}get nonWorkingDays(){return this._nonWorkingDays||this._localeNonWorkingDays||(this._localeNonWorkingDays=S.nonWorkingDays)}get weekends(){return this._localeWeekends||(this._localeWeekends=S.weekends)}changeNonWorkingDays(i){return T.assign({},i)}updateNonWorkingDays(i){var e;this._month&&(this.month.nonWorkingDays=i,this.refresh(),(e=this.scrollable)==null||e.syncOverflowState())}get visibleDayColumnIndex(){return this.month.visibleDayColumnIndex}get dayColumnIndex(){return this.month.dayColumnIndex}get canonicalDayNumbers(){return this.month.canonicalDayNumbers}get visibleColumnCount(){return this.month.visibleColumnCount}get weekLength(){return this.month.weekLength}get startDate(){return this.month.startDate}get duration(){return S.diff(this.month.startDate,this.month.endDate,"day")+1}get endDate(){const{endDate:i}=this.month;if(i)return S.add(i,1,"day")}changeMonth(i,e){const t=this;if(!(i instanceof Yo)){if(typeof i=="number"){if(e){e.month=i;return}const r=t.date||S.clearTime(new Date);r.setMonth(i),i={date:r}}i=Yo.new({weekStartDay:t.weekStartDay,nonWorkingDays:t.nonWorkingDays,hideNonWorkingDays:t.hideNonWorkingDays,sixWeeks:t.sixWeeks},i)}return i.ion({dateChange:"onMonthDateChange",thisObj:t}),i}onMonthDateChange({source:i,newDate:e,oldDate:t,changes:r}){const n=this;if(n.year=i.year,!n.isConfiguring){if(!n.getCell(e)||r.m||r.y){const{isVisible:s}=n;n.refresh(),n.animateTimeShift&&s&&E.slideIn(n.contentElement,e>t?1:-1)}n.trigger("dateChange",{changes:r,value:e,oldValue:t})}}updateYear(i){this.month.year=i}updateShowWeekNumber(i){this.updateShowWeekColumn(i)}updateShowWeekColumn(i){const e=this;e.element.classList[i?"add":"remove"]("b-show-week-column"),e.floating&&(e.isAligning||e.realign())}updateSixWeeks(i){this.month&&(this.month.sixWeeks=i,this.refresh())}refresh(){this.month&&this.element.style.setProperty("--week-length",this.month.weekLength),this.doRefresh()}doRefresh(){var i;this.getConfig("element");const e=this,t=e.timeZone!=null?e.timeZone:(i=e.project)==null?void 0:i.timeZone,r=t!=null?qe.toTimeZone(new Date,t):new Date,{weekElements:n,weekDayElements:s,date:a,month:o,dayCellCls:l,dayHeaderCls:d,disabledCls:c,otherMonthCls:u,weekendCls:h,todayCls:f,nonWorkingDayCls:g,nonWorkingDays:m,canonicalDayNumbers:v,sixWeeks:y}=e;if(r.setHours(0,0,0,0),!a){e.date=r;return}e.element.style.setProperty("--visible-week-count",o.weekCount),e.trigger("beforeRefresh"),e.getConfig("dayNameFormat");for(let w=0;w<7;w++){const x=e.weekdayCells[w],R=e.canonicalDayNumbers[w],M={[d]:1,[h]:Gb[R],[g]:m[R]};if(e.headerRenderer){x.innerHTML="";const I=e.callback(e.headerRenderer,e,[x,w,R]);I&&(typeof I=="string"?E.setInnerText(x,I):E.createElement({...I,parent:x}))}else E.setInnerText(x,e.shortDayNames[R]);E.syncClassList(x,M),x.dataset.columnIndex=w,x.dataset.cellDay=R}let b=0,C=0,D=6;for(let w=6;w>=0;w--)if(!m[v[w]]){D=w;break}n[4].classList.toggle("b-hide-display",o.weekCount<5&&!y),n[5].classList.toggle("b-hide-display",o.weekCount<6&&!y),o.eachWeek((w,x)=>{const R=s[b],M=[R.previousSibling,...R.children],I=M[0],{firstChild:_}=I;if(n[b].dataset.week=`${w[0]},${w[1]}`,n[b].setAttribute("aria-label",`${e.L("L{Week}")} ${w[1]}, ${w[0]}`),I.innerHTML===""?I.innerText=w[1]:_.nodeType===Node.TEXT_NODE&&(_.nodeValue=w[1]),e.weekRenderer){const F=e.callback(e.weekRenderer,e,[I,w]);F&&(typeof F=="string"?E.setInnerText(I,F):(I.innerHTML="",E.createElement({...F,parent:I})))}for(let F=0;F<7;F++){const A=x[F],P=A.getDay(),V=S.makeKey(A),B=m[P],W=M[F+1],q=S.isToday(A,e.timeZone),G={[l]:1,[c]:e.isDisabledDate(A),[u]:A.getMonth()!==o.month,[h]:Gb[P],[f]:q,[g]:B,"b-last-working-day":F===D,"b-first-visible-cell":!(A-(e.firstVisibleDate||-1)),"b-last-visible-cell":!(A-(e.lastVisibleDate||-1)),[`b-day-of-week-${P}`]:1};if(E.syncClassList(W,G),W.role="gridcell",W.dataset.date=V,W.dataset.cellIndex=C,W.dataset.columnIndex=F,W.lastDomConfig&&(delete W.lastDomConfig.class,delete W.lastDomConfig.className),e.cellRenderer){if(e.callback(e.cellRenderer,e,[{cell:W,date:A,day:P,rowIndex:b,cellIndex:C,columnIndex:F,key:V,week:w,row:n[b],source:e,visibleColumnIndex:e.visibleDayColumnIndex[P]}]),q){const Z=W.getAttribute("aria-label"),ne=e.L("L{Object.today}, ");Z&&!Z.startsWith(ne)&&W.setAttribute("aria-label",`${ne}${Z}`)}}else W.innerHTML=A.getDate();C++}b++}),e.visibleWeekCount=b,e.floating&&(e.isAligning||e.realign()),e.refreshCount=(e.refreshCount||0)+1,e.trigger("refresh")}isDisabledDate(i){const e=this,t=i.getDay(),{disabledDates:r}=e;if(e.disableWeekends&&Gb[t]||e.disableNonWorkingDays&&e.nonWorkingDays[t])return!0;if(r)return Array.isArray(r)?(i=S.clearTime(i,!0),r.some(n=>(n=typeof n=="string"?S.parse(n):n,!(S.clearTime(n,!0)-i)))):e.callback(r,e,[i])}get bodyConfig(){const i=super.bodyConfig,e=[];i.children=[{tag:"div",className:"b-calendar-row b-calendar-weekdays","aria-hidden":!0,reference:"weekdaysHeader",children:[{class:"b-week-number-cell"},...L.fill(7,{class:this.dayHeaderCls}),E.scrollBarPadElement]},{className:"b-weeks-container notranslate",reference:"weeksElement",children:e,role:"grid"}];for(let t=0;t<6;t++){const r={role:"row",className:"b-calendar-row b-calendar-week",dataset:{rowIndex:t},children:[{className:"b-week-number-cell",role:"rowheader"},{className:"b-calendar-days",children:[{},{},{},{},{},{},{}],syncOptions:{ignoreRefs:!0,strict:!1}}]};e.push(r)}return i}get firstVisibleDate(){if(this.hideOtherMonthCells){const{year:i,month:e}=this.month;return new Date(i,e,1)}for(const i=this,e=i.month.startDate;;e.setDate(e.getDate()+1))if(!i.hideNonWorkingDays||!i.nonWorkingDays[e.getDay()])return e}get lastVisibleDate(){const i=S.add(this.endDate,-1,"d");if(this.hideOtherMonthCells)return i;for(const e=this,t=i;;t.setDate(t.getDate()-1))if(!e.hideNonWorkingDays||!e.nonWorkingDays[t.getDay()])return t}getCell(i,e){typeof i!="string"&&(i=S.makeKey(i));const t=this.weeksElement.querySelector(`[data-date="${i}"]`);if(t&&(!e||!t.classList.contains(this.otherMonthCls)))return t}onTipOverCell({source:i,target:e}){i.date=S.parseKey(e.dataset.date)}updateLocalization(){this._localeNonWorkingDays=this._localeWeekends=null,this.updateDayNameFormat(),this.updateWeekStartDay(this.weekStartDay),super.updateLocalization()}};p(kn,"$name","CalendarPanel"),p(kn,"type","calendarpanel"),kn.initClass(),kn._$name="CalendarPanel";var{abs:H$,ceil:YR,floor:V$,max:KR,min:qb}=Math,XR="b-carousel-item",j$=[0,0],Ii=Symbol("carouselIndex"),Yb=Symbol("carouselSyncGen"),Mm="b-carousel-reserve",z$=`${Mm}-before`,N$=`${Mm}-after`,W$=(i,e)=>i[Ii]-e[Ii],U$="b-carousel-first",G$="b-carousel-last",Kb="b-carousel-visible",ZR=["x","y"],QR=["y","x"],Ku={h:{minSize:"minWidth",offsetPos:"offsetLeft",offsetSize:"offsetWidth",size:"width",vxy:["vx","vy"],xy:ZR},v:{minSize:"minHeight",offsetSize:"offsetHeight",size:"height",vxy:["vy","vx"],xy:QR}};Ku.h.other=Ku.v,Ku.v.other=Ku.h;var Ur=class extends Rt.mixin(Go,FR){compose(){const{carouselClasses:i}=this;return{class:{...i}}}afterFloatReparent(){this.syncSoon()}get allSlots(){return this.ensureItems().values.filter(i=>i.innerItem).sort(W$)}get bodyConfig(){const{carouselClasses:i,emptyHtml:e,emptyText:t}=this,r=super.bodyConfig;return T.merge(r,{className:{"b-vbox":1,...i},children:{innerCt:{class:{"b-carousel-inner-ct":1,"b-box-center":1}},emptyElement:{class:{"b-carousel-empty-text":1,"b-box-center":1},html:e||k.xss`${t}`}}})}get carouselClasses(){const{empty:i,vertical:e}=this;return{"b-carousel-empty":i,"b-carousel-vertical":e}}get contentElement(){return this.innerCt}get currentIndex(){return this.indexFromPos(this.scrollPos)}set currentIndex(i){this.goto(i)}get focusedSlot(){const{innerCt:i}=this;let e=null,t,r;for(t=E.getActiveElement();t;t=r)if(r=t.parentElement,r===i){e=z.fromElement(t);break}return e}get infinityScrollerDefaults(){const i=this,[e,t]=i.vertical?QR:ZR;return T.merge(super.infinityScrollerDefaults,{snap:i.snap&&e,[e]:{overflow:"hidden-scroll",range:i.scrollRange,pos:0},[t]:{overflow:"hidden"}})}get propNames(){return Ku[this.vertical?"v":"h"]}get scrollAxis(){return this.infinityScroller[this.vertical?"y":"x"]}get scrolling(){return this.infinityScroller.scrolling}get scrollPos(){return this.scrollAxis.pos}set scrollPos(i){this.scrollAxis.pos=i}get scrollRange(){const{range:i,slotSize:e}=this;return e?[i[0]*e,i[1]*e]:[0,1/0]}get shrinkWrap(){const i=this._shrinkWrap;return i==="auto"?E.getStyleValue(this.element,"position")==="absolute":i}get lastVisibleIndex(){var i;return(i=this.lastVisibleSlot)==null?void 0:i[Ii]}get visibleSlots(){return this.allSlots.filter(i=>i.element.classList.contains(Kb))}updateAtMax(i){this.element.classList.toggle("b-carousel-at-max",i)}updateAtMin(i){this.element.classList.toggle("b-carousel-at-min",i)}changeConfigureSlot(i){if(typeof i=="string"){const e=`_${i}Fn`;return this[e]||(this[e]=(...t)=>this[i](...t))}return i}triggerSlotVisibility(){const{firstVisibleSlot:i,lastVisibleSlot:e}=this;this.trigger("slotVisibility",{firstVisibleSlot:i,lastVisibleSlot:e})}updateFirstVisibleSlot(i){this.triggerSlotVisibility()}updateLastVisibleSlot(){this.triggerSlotVisibility()}changeRange(i){var e,t;if(i=i?[(e=i[0])!=null?e:-1/0,(t=i[1])!=null?t:1/0]:[0,0],i[0]!==i[1]){let r;if(i[1]<i[0]&&(r="denormalized"),r)throw new Error(`Invalid carousel range [${i[0]}, ${i[1]}): ${r}`)}return i}updateRange(i){this.empty=!(i[0]<i[1]),this.syncSoon()}updateShrinkWrap(){this.isPainted&&this.syncSoon()}updateVertical(){this.isPainted&&this.syncSoon()}convertIndexPos(i,e){const t=this,{allSlots:r,propNames:n}=t,[s,a]=t.range,o=Math.floor((s+a)/2),l=r.length,d=r[l-1],c=n.vxy[0],u=s<=0&&0<a;if(!e&&!(s<=i&&i<a))return null;let h=t.slotSize||100,f,g,m,v,y,b,C,D;if(l){h=0;for(D of r){if(m=D[Ii],f=D[c],h=h||D.$vxy[n.size],D===r[0]&&(v=m,C=f,i<(e?f:m)))break;if(e){if(i===f)return m;if(i<f)return m-1}else if(i===m)return f;if(D===d){if(g=f+D.$vxy[n.size],e&&i<g)return m;y=m+1,b=g}}h=h||t.slotSize||100}else{if(e&&0<=i&&i<h)return u?0:o;C=0,b=h,v=u?0:o,y=v+1}return e?i<C?KR(v-YR((C-i)/h),s):qb(y+V$((i-b)/h),a):i<v?C-(v-i)*h:b+(i-y)*h}ensurePlan(i){return i}ensureVisible(i){const e=this;if(e.lastScrollPos==null)e._afterSync=()=>e.ensureVisible({...i,animate:!1});else if(e.scrolling&&e.hasPainted)e._afterScroll=()=>e.ensureVisible(i);else{const{index:t,animate:r}=e.ensurePlan(i),{currentIndex:n,lastVisibleIndex:s}=e;let a;return t<n?a=t-n:s<t&&(a=t-s),a&&e.go(a,r)}}getSlotIndex(i){return i==null?void 0:i[Ii]}indexFromPos(i){return this.convertIndexPos(i,!0)}posFromIndex(i){return this.convertIndexPos(i,!1)}slotFromIndex(i){for(const e of this.allSlots)if(e[Ii]===i)return e;return null}backward(i){return this.go(-1,i)}forward(i){return this.go(1,i)}go(i,e){return this.goto(this.currentIndex+i,e)}goto(i,e){const t=this;if(t.lastScrollPos==null)t._afterSync=()=>{const{scrollPos:r}=t;t.goto(i,!1),!t.hasPainted&&r!==t.scrollPos&&t.sync()};else if(t.scrolling&&t.hasPainted)t._afterScroll=()=>t.goto(i,e);else{const{range:r,slots:n}=t,s=r[1]-(typeof n=="number"?n-1:0),a=qb(s-1,KR(r[0],i)),o=H$(t.currentIndex-a),l=t.posFromIndex(a);return o>=t.allSlots.length&&(e=!1),t.scrollTo({animate:e,[t.scrollAxis.name]:l})}}onChildAdd(i){return i.innerItem&&i.element.classList.add(XR),super.onChildAdd(i)}onChildRemove(i){return i.innerItem&&i.element.classList.remove(XR),super.onChildRemove(i)}onInfiniteScrollEnd(i){super.onInfiniteScrollEnd(i);const{_afterScroll:e}=this;this._afterScroll=null,e==null||e()}onSlotFocusTrap({source:i,top:e}){const t=this,r=e?-1:1,n=i[Ii],s=t.slotFromIndex(n+r);return s.element.classList.contains(Mm)?t.scrollOnTab&&t.go(r).then(a=>{var o;a&&((o=s.element)==null||o.focus())}):s.element.focus(),!1}resync(){this.sync()}sync(){var i;if(this.syncCount=(this.syncCount||0)+1,!this.empty){const e=this,{allSlots:t,disableReserveSlots:r,innerCt:n,scrollAxis:s,propNames:a,reserveSlots:o,scrolling:l,slots:d}=e,[c,u]=e.range,h=s.pos,f=z.resolveType(((i=e.defaults)==null?void 0:i.type)||e.defaultType),g=e.indexFromPos(h),m=e.posFromIndex(g),v=h-m,y=[o,o],b=e.syncGen=(e.syncGen||0)+1;l&&h>(e.lastScrollPos||0)&&v&&(--y[0],++y[1]),e.lastScrollPos=h,n.style.setProperty("--carousel-item-offset",`${Math.abs(v)}px`),e.shrinkWrapped||(n.style[a.minSize]="");let C=n[a.offsetSize],D=!1,w=!1,x=null,R=null,M,I,_,F;e.unanimated(()=>{const{_afterSync:A}=e,P=d&&d!=="auto"?e.syncFixed(g,a,t,f,y,d,c,u):e.syncDynamic(g,a,t,f,y,d,C,c,u),V=[],B=t.filter(W=>W[Yb]!==b);B.length&&(B.forEach(W=>e.detachListeners(`${W.id}-listeners`)),e.remove(B)),n.style[a.other.minSize]=`${P[a.other.size]}px`,C=n[a.offsetSize];for(F of t)if(!B.includes(F)){const W=s.getItemSpan(F),q=h+C,G=W[1]<=h,Z=q<=W[0],ne=!G&&!Z,J=ne&&W[0]<=h,ee=ne&&W[1]>=q;ne&&(F[Ii]===c&&(w=!0),F[Ii]===u-1&&(D=!0)),J&&(x=F),ee&&(R=F),V.push([F,F.element.classList,{[Mm]:G||Z,[z$]:G,[U$]:J,[Kb]:ne,[G$]:ee,[N$]:Z}])}for([F,M,_]of V){r&&(F.disabled=_[Kb]?!1:r);for(I in _)M.toggle(I,_[I])}e.atMax=D,e.atMin=w,e.firstVisibleSlot=x,e.lastVisibleSlot=R,s.other.range=j$,e.syncDomOrder(B.length?e.allSlots:t),!l&&e.scrollable.fixPositionSync(),s.sync({range:e.scrollRange}),s.pos!==h?e.resync():A&&(e._afterSync=null,A())})}}syncDomOrder(i){const e=E.getActiveElement();let t,r,n;for(n=i.length;n-- >1;)r=i[n].element,t||r.classList.add("b-last-visible-child"),t=i[n-1].element,t.classList.remove("b-last-visible-child"),r.classList.remove("b-first-visible-child"),t.nextSibling!==r&&t.parentElement.insertBefore(t,r);t==null||t.classList.add("b-first-visible-child"),this.element.contains(e)&&e!==E.getActiveElement()&&e.focus()}syncDynamic(i,e,t,r,n,s,a,o,l){const d=this,{offsetSize:c}=e,u=s==="auto",h=u?"":null;let[f,g]=n,m=1,v=0,y,b,C;for(C=i;o<=C&&C<l;C+=m){if(b=d.syncSlot(t,r,C,h),y=y||b,v<a){if(v+=b.element[c],u)return d.syncFixed(i,e,t,r,n,YR(a/v));if(m>0){if(C+1<l&&(v<a||g))continue;f+=g,g=0}}if(--g<1){if(m<0||!f)break;m=-1,C=i,g=f}}return y}syncFixed(i,e,t,r,n,s,a,o){const l=this,{shrinkWrap:d,shrinkWrapped:c}=l,u=`${100/s}%`,h=i+s;let f=i-n[0],g=h+n[1],m=0,v,y,b,C,D;for(;g>o;)--f,--g;for(;f<a;)++f,++g;for(D=f;D<g;++D)y=l.syncSlot(t,r,D,d&&!c?"":u),D===i&&(v=y),d?(b||(b=[])).push(y):y[e.size]=u;if(d){for(C=qb(h,g-n[1]),D=C-s;D<C;++D)m+=b[D-f][e.size];for(y of b)y[e.size]=u;m&&(l.innerCt.style[e.minSize]=`${m}px`,l.shrinkWrapped=!0)}return v}syncSlot(i,e,t,r){const n=this,{propNames:s,syncGen:a}=n,o=r!==null;let l=null,d,c,u,h,f;for(h of i)if(h[Yb]!==a){if(c=h[Ii],c===t){u=h,o&&(u[s.size]=r);break}(!l||c>l[Ii])&&(l=h)}return u||(d=n.configureSlot(t,n,l),l?(u=l,o&&(u[s.size]=r),delete d.type,u.setConfig(d)):(f=d.type?z.resolveType(d.type):e,d=f.mergeConfigs(n.defaults,d),o&&(d[s.size]=r),u=n.add(d),i.push(u),u.ion({thisObj:n,name:`${u.id}-listeners`,focusTrap:"onSlotFocusTrap"})),u[Ii]=t,n.slotSize||(n.slotSize=u[s.size]),u[s.vxy[0]]=t*n.slotSize),u[Yb]=a,u}};p(Ur,"$name","Carousel"),p(Ur,"type","carousel"),p(Ur,"configurable",{atMax:null,atMin:null,configureSlot:(i,e,t)=>({}),disableReserveSlots:null,empty:null,emptyHtml:null,emptyText:"No items to display",firstVisibleSlot:null,lastVisibleSlot:null,range:[null,null],reserveSlots:1,scrollOnTab:null,shrinkWrap:"auto",slots:null,snap:!0,vertical:null}),p(Ur,"delayable",{triggerSlotVisibility:"raf"}),p(Ur,"fenced",{resync:!0}),Ur.initClass(),Ur._$name="Carousel";var q$=i=>!i.value,Gr=class extends ut{static get configurable(){return{inputType:"checkbox",autoCollapse:null,toggleGroupRootElement:null,containerDefaults:{syncableConfigs:{disabled:i=>i.disabled||!i.value},syncConfigTriggers:{autoCollapse:1,value:1}},text:"",checkedValue:!0,uncheckedValue:!1,color:null,value:!1,toggleGroup:null,localizableProperties:["label","text"],twinSyncConfigs:{value:"checked"}}}construct(i){"checked"in i&&(i=T.assign({},i),i.value=i.checked,delete i.checked),super.construct(i),this.syncHasText()}updateClearable(){}updateEditable(){}get textLabelCls(){return"b-checkbox-label"}get innerElements(){return[this.inputElement,{tag:"label",class:this.textLabelCls,for:`${this.id}-input`,reference:"textLabel",html:this.text||"","aria-hidden":!this.text}]}get inputElement(){const i=super.inputElement;return this.toggleGroup&&(i.dataset={group:this.toggleGroup}),i.listeners={click:"internalOnClick",change:"internalOnChange",input:"internalOnInput"},i}get checked(){return this.value}set checked(i){this.value=i}syncHasText(){var i;this.element.classList[this.text?"add":"remove"]("b-text"),(i=this.textLabel)==null||i.setAttribute("aria-hidden",!this.text)}updateText(i){this.textLabel&&(this.syncHasText(),this.textLabel.innerHTML=i)}afterSyncChildConfigs(i){super.afterSyncChildConfigs(i);let{autoCollapse:e}=this;e&&(e=e===!0?q$:e,i.collapsed=e(this))}assignFieldValue(i,e,t){this.value=t===this.checkedValue||(t===this.uncheckedValue?!1:null)}fetchInputValue(){this.readOnly||(this.value=this.input.checked)}gatherValue(i){var e;const t=this,r=t.value?t.checkedValue:t.uncheckedValue,n=r!==void 0,{valueName:s}=t;n&&(i[s]=r),t.gatherValues(i,n),r===!0&&((e=i[s])==null?void 0:e.value)===r&&delete i[s].value}changeValue(i){return i==="false"?!1:!!i}updateValue(i){var e;const t=this,r=t.input.checked!==i;t.input.checked=i,(e=t.container)==null||e.syncChildConfigs(),r&&!t.inputting&&!t.isConfiguring&&(t.uncheckToggleGroupMembers(),t.triggerChange(!1,null))}get inputValueAttr(){return"checked"}updateColor(i,e){const t=this.element.classList;e&&t.remove(e),i&&t.add(i)}getToggleGroupRootElement(){const i=this.toggleGroupRootElement;let e;return i&&typeof i=="string"&&this.element&&(e=this.element.closest(i)),e||this.rootElement}getToggleGroupMembers(){const i=this,{toggleGroup:e,input:t,type:r}=i,n=[];return e&&E.forEachSelector(i.getToggleGroupRootElement(),`input[type=${r}][data-group=${e}]`,s=>{if(s!==t){const a=z.fromElement(s);a&&n.push(a)}}),n}uncheckToggleGroupMembers(i){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach(e=>{e._propagatingUserActionFrom=this,e.checked=!1,e._propagatingUserActionFrom=null})}check(){this.checked=!0}uncheck(){this.checked=!1}toggle(){this.checked=!this.checked}internalOnClick(i){return this.readOnly?(i.preventDefault(),!1):this.trigger("click",{event:i})}internalOnChange(i){const e=this;if(e.readOnly&&e.value!==e.input.checked){e.input.checked=e.value;return}e.value=e.input.checked,e.inputting||(e.inputting=!0,e.triggerChange(!0,i),e.inputting=!1)}updateInputReadOnly(i){}triggerChange(i,e){const t=this,{checked:r}=t.input,n={checked:r,value:r,oldValue:!r,userAction:i,valid:!0,event:e};if(t._propagatingUserActionFrom&&(n.propagatingUserActionFrom=t._propagatingUserActionFrom),!r&&i&&t.toggleGroup&&t.getToggleGroupMembers().filter(a=>a.isVisible&&!a.disabled).length||t.trigger("beforeChange",n)===!1)t.input.checked=t._value=!r;else return t.triggerFieldChange(n,!1),i&&t.uncheckToggleGroupMembers(i),t.trigger("action",n),t.trigger("change",n),!0}configureOverflowTwin(i){const e=this,t=super.configureOverflowTwin(i);return t.type=z.resolveType("menuitem"),t.text||(t.text=e.label||e.text||e.tooltipText),t}};p(Gr,"$name","Checkbox"),p(Gr,"type","checkbox"),p(Gr,"alias","check"),Gr.initClass(),Gr._$name="Checkbox";var aa=class extends Rt.mixin(jb){static get prototypeProperties(){return{flexRowCls:"b-hbox",flexColCls:"b-vbox"}}get bodyConfig(){const i=super.bodyConfig,{className:e}=i,{inlineInternal:t,hasLabel:r,title:n}=this;return delete i.html,e["b-inline"]=t,e["b-fieldset-has-label"]=r,n&&(i.children={legendElement:{tag:"legend",text:n,class:{"b-fieldset-legend":1}}}),i}compose(){const{inlineInternal:i,label:e,labelCls:t,labelWidth:r}=this;return{class:{"b-field":e,"b-vbox":!i},children:{"labelElement > headerElement":(e||null)&&{tag:"label",html:e,class:{"b-label":1,"b-align-start":1,[t]:t},style:{width:E.unitize("width",r)[1]}}}}}syncInlineInternal(){var i;this.inlineInternal=(i=this.inline)!=null?i:this.label!=null&&this.labelPosition==="before"}updateDisabled(i,e){super.updateDisabled(i,e),this.eachWidget(t=>{t.disabled=i},!1)}updateInline(){this.syncInlineInternal()}updateInlineInternal(i){this.layout.horizontal=i}updateLabel(){this.syncInlineInternal()}updateLabelPosition(){this.syncInlineInternal()}};p(aa,"$name","FieldSet"),p(aa,"type","fieldset"),p(aa,"configurable",{bodyTag:"fieldset",focusable:!1,localizableProperties:["label"],inline:null,inlineInternal:null,layout:{type:"box",horizontal:!1}}),aa.initClass(),aa._$name="FieldSet";var Jo=class extends Gr{static get configurable(){return{inputType:"radio",clearable:null,uncheckedValue:void 0}}get textLabelCls(){return super.textLabelCls+" b-radio-label"}internalOnClick(i){super.internalOnClick(i)!==!1&&this.checked&&this.clearable&&(this.checked=!1)}updateName(i){this.toggleGroup=i}updateClearable(){}};p(Jo,"$name","Radio"),p(Jo,"type","radio"),p(Jo,"alias","radiobutton"),Jo.initClass(),Jo._$name="Radio";var qr=class extends aa{afterConstruct(){super.afterConstruct(),this.name||(this.name=this.ref||this.id)}triggerPaint(...i){const e=this,t=!e.isPainted,r=e.__value;super.triggerPaint(...i),Y.isFirefox&&e.isVisible&&t&&r!==void 0&&r!==e.value&&(e.value=void 0,e.value=r)}get existingOptions(){const{name:i}=this;return this.ensureItems().filter(e=>e.name===i)}get refPrefix(){return`${this.name||this.ref||this.id}_`}get selected(){return this.existingOptions.filter(i=>i.input.checked)[0]||null}get value(){const{selected:i}=this;return i?i.checkedValue:null}set value(i){this.existingOptions.forEach(e=>{e.isConfiguring=this.isConfiguring,e.checked=e.checkedValue===i,e.isConfiguring=!1}),Y.isFirefox&&!this.isConnected&&(this.__value=i)}ensureItems(){return this.getConfig("options"),super.ensureItems()}changeOptions(i,e){if(!(i&&e&&T.isDeeplyEqual(e,i)))return i}convertOption(i,e,t){const r=this,{name:n}=r,s={name:n,type:r.defaultType,value:r.peekConfig("value"),ref:`${r.refPrefix}${i}`,disabled:r.disabled,checkedValue:i};return typeof e=="string"?s.text=e:T.assign(s,e),t?z.reconfigure(t,s):s}isOurRadio(i){return(i.isRadio||i.isCheckbox)&&i.name===this.name}isolateFieldChange(i){return this.isOurRadio(i)}onChildAdd(i){super.onChildAdd(i),this.isOurRadio(i)&&i.ion({name:i.id,beforeChange:"onItemBeforeChange",change:"onItemChange",click:"onItemClick",thisObj:this})}onChildRemove(i){this.isOurRadio(i)&&this.detachListeners(i.id),super.onChildRemove(i)}onItemClick(i){const{source:e}=i;e.checked&&this.clearable&&e.clearable==null&&(e.checked=!1)}onItemBeforeChange(i){if(i.checked){const e=this,{lastValue:t}=e;if(!e.reverting&&e.trigger("beforeChange",e.wrapRadioEvent(i))===!1&&t!=null&&t!==e.value)return e.reverting=!0,i.source.uncheckToggleGroupMembers(),e.value=t,e.lastValue=t,e.reverting=!1,!1}}onItemChange(i){const e=this;i.checked&&!e.reverting&&(e.triggerFieldChange(e.wrapRadioEvent(i)),e.lastValue=e.value)}wrapRadioEvent(i){return{from:i,item:i.source,userAction:i.userAction,lastValue:this.lastValue,value:this.value}}updateName(){const{name:i}=this;this.ensureItems().forEach(e=>{(e.isRadio||e.isCheckbox)&&(e.name=i)})}updateOptions(){const i=this,{options:e,refPrefix:t}=i,r=i.existingOptions.reduce((l,d)=>(l[d.ref.substring(t.length)]=d,l),{});let n=0,s,a;if(e)for(s in e)a=i.convertOption(s,e[s],r[s]),delete r[s],i.insert(a,n++);const o=Object.values(r);o!=null&&o.length&&(i.remove(o),o.forEach(l=>l.destroy()))}};p(qr,"$name","RadioGroup"),p(qr,"type","radiogroup"),p(qr,"configurable",{defaultType:"radio",clearable:null,name:null,options:{value:null,$config:{merge:"items"}},defaultBindProperty:"value"}),qr.initClass(),qr._$name="RadioGroup";var el=class extends qr.mixin(Ko){onItemBeforeChange(i){const e=this,{lastValue:t}=e;if(!e.reverting&&e.trigger("beforeChange",e.wrapRadioEvent(i))===!1&&t!=null&&t!==e.value)return e.reverting=!0,i.source.uncheckToggleGroupMembers(),e.value=t,e.lastValue=t,e.reverting=!1,!1}onItemChange(i){const e=this;e.reverting||(e.triggerFieldChange(e.wrapRadioEvent(i)),e.lastValue=e.value),e.syncInvalid()}get selected(){return this.existingOptions.filter(i=>i.input.checked)||null}get value(){const{selected:i}=this;return i.map(e=>e.checkedValue)}set value(i){i=i||[],typeof i=="string"&&(i=i.split(this.separator)),this.existingOptions.forEach(e=>{e.isConfiguring=this.isConfiguring,e.checked=i.includes(e.checkedValue),e.isConfiguring=!1}),Y.isFirefox&&!this.isConnected&&(this.__value=i)}internalOnChange(){this.syncInvalid()}get inputWrap(){return this.element}get isValid(){let i=!0;const e=this,{selected:t,requiredSelectedOptions:r,minSelectedOptions:n,maxSelectedOptions:s}=e;if(e.clearError(void 0,!0),!e.disabled){const a=isNaN(e.minSelectedOptions)||t.length>=n,o=isNaN(e.maxSelectedOptions)||t.length<=s;r&&t.length!==r?(i=!1,e.setError(e.L("L{wrongNbrOfOptionsSelected}",r),!0)):a?o||(i=!1,e.setError(e.L("L{tooManyOptionsSelected}",s),!0)):(i=!1,e.setError(e.L("L{tooFewOptionsSelected}",n),!0))}return i&&e.errors&&Object.keys(e.errors).length&&(i=!1),i}updateMinSelectedOptions(){this.isConfiguring||this.syncInvalid()}updateMaxSelectedOptions(){this.isConfiguring||this.syncInvalid()}updateRequiredSelectedOptions(){this.isConfiguring||this.syncInvalid()}};p(el,"$name","CheckboxGroup"),p(el,"type","checkboxgroup"),p(el,"configurable",{defaultType:"checkbox",defaults:{color:"b-blue"},separator:",",requiredSelectedOptions:null,minSelectedOptions:null,maxSelectedOptions:null,errorTooltipCachePath:"checkboxGroupErrorTooltip",errorTooltipConfig:{forSelector:".b-checkboxgroup.b-invalid .b-checkbox-label",align:"t-b"}}),el.initClass(),el._$name="CheckboxGroup";var Xu,Yr=class extends Rt{construct(i={}){const e=this;e.editorReady=new Promise((t,r)=>{e.resolveEditorReady=t,e.rejectEditorReady=r}),super.construct(...arguments),e.editorReady.then(()=>{ce.ion({theme:({theme:t})=>e.editor.updateOptions({theme:t.toLowerCase().includes("dark")?"vs-dark":"vs-light"}),thisObj:e}),e.element.style.setProperty("--vscode-menu-background",getComputedStyle(e.element.querySelector(".monaco-editor")).getPropertyValue("--vscode-menu-background"))})}get monacoInstance(){return globalThis.monaco}focus(){this.editor.focus()}static set monacoLoadPromise(i){Xu=i}static get monacoLoadPromise(){return Xu}async updateCodePath(i,e){var t;const r=this;e&&((t=r.loaderScript)==null||t.remove()),Xu||(Xu=new Promise(n=>{const s=()=>{const l=globalThis.require;l.config({paths:{vs:`${i}/min/vs`}}),l(["vs/editor/editor.main"],function(){r.isDestroyed||n(globalThis.monaco)}),o.removeEventListener("error",a),o.removeEventListener("load",s)},a=()=>{const l=`Code editor path to Monaco editor ${i} is incorrect`;o.removeEventListener("error",a),o.removeEventListener("load",s),hr.show(l),r.rejectEditorReady(l)},o=r.loaderScript=E.createElement({tag:"script",parent:document.head,src:`${i}/min/vs/loader.js`});o.addEventListener("error",a),o.addEventListener("load",s)})),globalThis.monaco=await Xu,r.getConfig("editor"),r.getConfig("text")}updateReadOnly(i){const{readOnly:e}=this.widgetMap;e&&(e.hidden=!i),this.editor.updateOptions({readOnly:i})}updateStatus(i){const{status:e}=this.widgetMap;e&&(e.html=i)}changeEditor(i,e){var t,r;const n=this;return(t=e==null?void 0:e.dispose)==null||t.call(e),i&&(i=n.monacoInstance.editor.create(n.contentElement,$e.merge({theme:n.theme||(r=E.themeInfo)!=null&&r.name.toLowerCase().includes("dark")?"vs-dark":"vs-light",padding:{top:14}},i)),n.monacoInstance.languages.typescript.javascriptDefaults.setDiagnosticsOptions({noSuggestionDiagnostics:!0}),i.onDidChangeCursorPosition(n.onCursorMove.bind(n)),i.onDidChangeConfiguration(n.onEditorConfigChange.bind(n)),i.onDidDispose(n.onEditorDestroy.bind(n)),n.resolveEditorReady(i)),i}get text(){var i;return((i=this.codeModel)==null?void 0:i.getValue())||this._text}changeText(i){var e;return this._text=(e=this.codeModel)==null?void 0:e.getValue(),i}updateText(i){var e,t;const{codeModel:r}=this;i!=null?r?r.setValue(i):this.loadText(i):(t=(e=this.codeModel)==null?void 0:e.dispose)==null||t.call(e)}async loadText(i=this.text,e=this.language){var t;const r=this;r._text=i,r._language=e,(t=r.codeModel)==null||t.dispose(),await r.editorReady;const n=r.codeModel=r.monacoInstance.editor.createModel(i,e);return r.editor.setModel(n),r.trigger("load",{model:n,text:i}),n}onEditorDestroy(){var i,e;(e=(i=this.codeModel)==null?void 0:i.dispose)==null||e.call(i),this.codeModel=null}onEditorConfigChange(){const i=this;i.editor&&(i.readOnly=i.editor.getOptions().get(i.monacoInstance.editor.EditorOptions.readOnly.id))}onCursorMove({position:i}){var e;(e=this.widgetMap.cursorPos)==null||e.setPosition(i)}};p(Yr,"$name","CodeEditor"),p(Yr,"type","codeeditor"),p(Yr,"configurable",{textContent:!1,scrollable:null,codePath:null,editor:{$config:["lazy","nullify"],value:{automaticLayout:!0,scrollBeyondLastLine:!1}},header:{cls:"demo-header"},bbar:{overflow:null,items:{readOnly:{hidden:!0,type:"widget",cls:"b-icon b-icon-locked"},status:{type:"widget",html:"\xA0"},cursorPos:{type:"widget",html:"\xA0",setPosition({lineNumber:i,column:e}){this.element.innerHTML=`Ln ${i}, Col ${e}`}}}},readOnly:null,text:{$config:["lazy","nullify"],value:null},language:null,theme:null,status:null}),Yr.initClass(),Yr._$name="CodeEditor";var oa=class extends Mi{configure(i){super.configure(i),this.setItems(),this.ion({item:"onColorSelect"})}setItems(){const i=this,{colors:e,colorClasses:t}=i;let r=e||t;i.addNoColorItem&&(i.store.modelClass.allowNullId=!0,r=[...r,null]),i.items=r.map(n=>!n||typeof n=="string"?{color:n,text:(t?k.capitalize(n):n)||i.L("L{noColor}")}:n)}afterConfigure(...i){var e;super.afterConfigure(...i),(this.addNoColorItem||this.value)&&this.select((e=this.value)!=null?e:null)}updateColors(){this.isConfiguring||this.setItems()}updateAddNoColorItem(){this.isConfiguring||this.setItems()}onColorSelect({record:i}){var e;this.refresh();const t={color:i.color,record:i,bubbles:!0};(e=this.colorSelected)==null||e.call(this,t),this.trigger("colorSelected",t)}select(i){(!i||typeof i=="string")&&(i=this.store.findRecord("color",i!=null?i:null)),i&&super.select(i)}updateColumns(i){this.style=`grid-template-columns:repeat(${i}, 1fr);`}getColorClassName(i){var e,t;return(e=this.colorClasses)!=null&&e.includes(i)||(t=this.colorClasses)!=null&&t.find(r=>r&&r.color===i)?this.colorClassPrefix+i:i?"":"b-no-color"}};p(oa,"$name","ColorPicker"),p(oa,"type","colorpicker"),p(oa,"configurable",{itemsFocusable:!1,navigator:{focusCls:"b-color-active"},itemWrapperTpl(i,e){const{selected:t}=this,{color:r,text:n}=i,s=this.getColorClassName(r);return Ti.tpl`
                    <li
                        class="${this.getItemClasses(i,e)} ${s}"
                        role="option"
                        aria-selected="${t.includes(i)}"
                        data-index="${e}"
                        data-id="${k.encodeHtml(r)}"
                        data-btip="${n}"
                        ${this.itemsFocusable?'tabindex="-1"':""}
                        style="${s?"":"background-color: "+r}"
                    ></li>`},colorClasses:null,colorClassPrefix:null,colors:["#45171D","#F03861","#FF847C","#FECEA8","#A5F2E7","#AA83F3","#8983F3","#A10054","#073059","#2866AB","#5FBDC5","#D8D95C","#FFDEDE","#F7F3CE","#C5ECBE","#3E3E3E","#405559","#68868C","#EDEDED","#D3D6DB","#3A4750","#303841","#BE3144"],addNoColorItem:!0,columns:6,colorSelected:null,store:{useRawData:!1}}),oa.initClass(),oa._$name="ColorPicker";var Kr=class extends Ye{configure(i){var e;const t=(e=i.picker)!=null?e:{};i.colors&&(t.colors=i.colors),"addNoColorItem"in i&&(t.addNoColorItem=i.addNoColorItem),i.picker=t,super.configure(i)}updatePicker(i,e){super.updatePicker(i,e),i&&(this.items=i.store.records)}updateColors(i){this.isConfiguring||(this.picker.colors=i)}updateAddNoColorItem(i){this.isConfiguring||(this.picker.addNoColorItem=i)}set value(i){this.store||(this.items=[],this.store=this.picker.store),i||(i=this.store.findRecord("color",null)),super.value=i}showPicker(...i){this.picker.refresh(),super.showPicker(...i)}get value(){return super.value}syncInputFieldValue(...i){var e;const t=this,{value:r}=t;let n=(e=t.picker)==null?void 0:e.getColorClassName(r);n||(t.colorBox.style.color=r),n="b-colorbox "+n,t.colorBox.className=n,t.showBoxForNoColor||t.element.classList.toggle("b-colorless",!r),super.syncInputFieldValue(...i)}get innerElements(){return[{reference:"colorBox",className:"b-colorbox"},...super.innerElements]}};p(Kr,"$name","ColorField"),p(Kr,"type","colorfield"),p(Kr,"configurable",{displayField:"text",valueField:"color",editable:!1,picker:{type:"colorpicker",align:{align:"t100-b100",matchSize:!1}},showBoxForNoColor:!0,colors:null,addNoColorItem:!0}),Kr.initClass(),Kr._$name="ColorField";var Y$=["ok","cancel","yes","no"].reduce((i,e,t,r)=>(i[e]=Object.freeze({...Object.fromEntries(r.map(n=>[n,!1])),name:e,approve:"ok,yes".includes(e),[e]:!0}),i),Object.create(null)),JR=["b-raised","b-blue"],eT=["b-gray"],Im=Y.isWindows,K$=/(?:\s+,?|,)\s*/,X$=/^(icon|menu|text)$/,la=class extends ta{get buttons(){return this.items.filter(i=>i.isButton)}get cancelButton(){return this.widgetMap.cancel||null}get noButton(){return this.widgetMap.no||null}get okButton(){return this.widgetMap.ok||null}get yesButton(){return this.widgetMap.yes||null}changeItems(i,e){return typeof i=="string"&&(i=Object.fromEntries(i.split(K$).map(t=>[t,!0]))),super.changeItems(i,e)}clickButton(i,e){const t=this,{widgetMap:r,defaultButton:n}=t;let s=e?r.cancel||r.no:r[n],a,o;if(!s){for([o,a]of Object.entries(r))if(o!==n){s=a;break}}s==null||s.onInternalClick(i)}doCancel(i){this.clickButton(i,!0)}doDefault(i){this.clickButton(i)}onButtonClick(i){this.trigger("choice",{...i,choice:Y$[i.source.ref],source:this,userAction:!0})}onChildAdd(i){super.onChildAdd(i),we.before(i,"onConfigChange","onChildConfigChange",this),this.syncButtons()}onChildConfigChange({name:i}){X$.test(i)&&this.syncButtons()}onChildRemove(i){super.onChildRemove(i),this.syncButtons()}onInternalPaint(i){super.onInternalPaint(i),i.firstPaint&&this.syncButtons.resume(),this.syncButtons.now()}syncButtons(){const i=this,e=i.isDestroying?[]:i.buttons,{defaultButton:t}=i;let r,n;i.syncWidthButtons!==!1&&e.forEach(s=>{(n=s.text)&&(r=Math.max(r||0,n.length+!!s.icon+!!s.menu))}),e.forEach(s=>{const{classList:a}=s.element,o=s.ref===t;a.add(...o?JR:eT),a.remove(...o?eT:JR),a.toggle("b-default-button",o),s.minWidth=r&&s.text?`${r}em`:null})}updateAutoWidthButtons(){this.syncButtons()}updateDefaultButton(){this.syncButtons()}};p(la,"$name","ConfirmationBar"),p(la,"type","confirmationbar"),p(la,"configurable",{defaultButton:"ok",defaultType:"button",items:"ok,cancel",keyMap:{Enter:"doDefault",NumpadEnter:"doDefault",Escape:"doCancel"},namedItems:{yes:{cls:"b-yes-button",text:"L{Object.Yes}",onClick:"up.onButtonClick",weight:Im?100:130},no:{cls:"b-no-button",text:"L{Object.No}",onClick:"up.onButtonClick",weight:Im?110:120},ok:{cls:"b-ok-button",text:"L{Object.Ok}",onClick:"up.onButtonClick",weight:Im?120:110},cancel:{cls:"b-cancel-button",text:"L{Object.Cancel}",onClick:"up.onButtonClick",weight:Im?130:100}},syncWidthButtons:null}),p(la,"delayable",{syncButtons:{type:"raf",suspended:!0}}),la.initClass(),la._$name="ConfirmationBar";var Ln=class extends Rt{construct(i){super.construct({month:new Date().getMonth(),...i}),j.on({element:this.contentElement,click:"onMonthClick",delegate:".b-monthpicker-month",thisObj:this})}get focusElement(){return this.getMonthButton(this.month)}getMonthButton(i){return this.contentElement.querySelector(`.b-monthpicker-month[data-month="${i}"]`)}onMonthClick({target:i}){const e=parseInt(i.getAttribute("data-month"));this.month===e?this.trigger("select",{oldValue:e,value:e}):this.month=e}handleTitleClick(i){this.trigger("titleClick",i)}changeMonth(i){if(!isNaN(i))return T.isDate(i)?i.getMonth():i>=0&&i<=11?i:void 0}updateMonth(i,e){this.isConfiguring||this.trigger("select",{oldValue:e,value:i})}composeBody(){this.getConfig("month");const i=super.composeBody(),e=i.children[this.tbar?1:0].children=[];this.widgetMap.title.text=S.getMonthName(this.month);for(let t=0;t<=11;t++)e.push({tag:"button",dataset:{month:t},class:{"b-monthpicker-month":1,"b-selected":t===this.month},text:S.getMonthShortName(t)});return i}async updateLocalization(){this.isConfiguring||await this.recompose(),super.updateLocalization()}};p(Ln,"$name","MonthPicker"),p(Ln,"type","monthpicker"),p(Ln,"configurable",{textContent:!1,tbar:{overflow:null,items:{title:{type:"button",cls:"b-monthpicker-title",onAction:"up.handleTitleClick"}}},itemCls:"b-month-container",month:null}),Ln.initClass(),Ln._$name="MonthPicker";var On=class extends Rt{construct(i){super.construct({year:new Date().getFullYear(),...i}),j.on({element:this.contentElement,click:"onYearClick",delegate:".b-yearpicker-year",thisObj:this})}get focusElement(){return this.getYearButton(this.year)||this.getYearButton(this.startYear)}getYearButton(i){return this.contentElement.querySelector(`.b-yearpicker-year[data-year="${i}"]`)}get value(){return this.year}set value(i){this.year=i}onYearClick({target:i}){const e=Math.min(Math.max(parseInt(i.innerText),this.minYear||1),this.maxYear||9999);this.year===e?this.trigger("select",{oldValue:e,value:e}):this.year=e}handleTitleClick(i){this.trigger("titleClick",i)}previous(){this.startYear=this.startYear-this.yearButtonCount}next(){this.startYear=this.endYear+1}ingestYear(i){if(!isNaN(i))return T.isDate(i)?i.getFullYear():i}changeYear(i){if(i=this.ingestYear(i))return Math.min(Math.max(i,this.minYear||1),this.maxYear||9999)}updateYear(i,e){const t=this;!t.startYear||i>t.endYear?t.startYear=i:i<t.startYear&&(t.startYear=i-(t.yearButtonCount-1)),t.isConfiguring||t.trigger("select",{oldValue:e,value:i})}get endYear(){return this.startYear+this.yearButtonCount-1}changeStartYear(i){if(i=this.ingestYear(i))return i=this.minYear?Math.max(i,this.minYear):i,this.maxYear?Math.min(i,this.maxYear-(this.yearButtonCount-1)):i}async updateStartYear(i,e){this.isVisible&&E.slideIn(this.contentElement,Math.sign(i-e))}composeBody(){this.getConfig("year");const{startYear:i}=this,e=super.composeBody(),t=e.children[this.tbar?1:0].children=[];this.widgetMap.title.text=`${`000${i}`.slice(-4)} - ${`000${this.endYear}`.slice(-4)}`;for(let r=0,n=i;r<this.yearButtonCount;r++,n++)t.push({tag:"button",dataset:{year:n},class:{"b-yearpicker-year":1,"b-selected":n===this.year},text:`000${n}`.slice(-4)});return e}};p(On,"$name","YearPicker"),p(On,"type","yearpicker"),p(On,"configurable",{textContent:!1,tbar:{overflow:null,items:{previous:{type:"tool",cls:"b-icon b-icon-previous",onAction:"up.previous",weight:100},title:{type:"button",cls:"b-yearpicker-title",weight:200,onAction:"up.handleTitleClick"},next:{type:"tool",cls:"b-icon b-icon-next",onAction:"up.next",weight:300}}},itemCls:"b-year-container",yearButtonCount:12,year:null,minYear:null,maxYear:null,startYear:null}),On.initClass(),On._$name="YearPicker";var tl=class extends zi{static get configurable(){return{readOnly:!0,editable:!1,cls:"b-display-field",template:null,ariaElement:"displayElement"}}get focusElement(){}changeReadOnly(){return!0}changeEditable(){return!1}get inputElement(){return{tag:"span",id:`${this.id}-input`,reference:"displayElement",html:this.template?this.template(this.value):k.encodeHtml(this.value)}}};p(tl,"$name","DisplayField"),p(tl,"type","displayfield"),p(tl,"alias","display"),tl.initClass(),tl._$name="DisplayField";var tT=(i,e)=>i.valueOf()-e.valueOf(),{DateSet:_m}=S,Z$=Object.freeze([]),Q$=i=>i.every((e,t)=>!t||!(S.add(i[t-1],1,"d")-e)),iT={magnitude:1,unit:"week"},Ni=class extends kn{static get delayable(){return{refresh:"raf"}}static get configurable(){return{activeDate:{$config:"date",value:"today"},focusable:!0,textContent:!1,tbar:{overflow:null,items:{prevYear:{cls:"b-icon b-icon-first b-datepicker-nav-button",onAction:"up.gotoPrevYear",tooltip:"L{DatePicker.gotoPrevYear}",weight:100},prevMonth:{cls:"b-icon b-icon-previous b-datepicker-nav-button",onAction:"up.gotoPrevMonth",tooltip:"L{DatePicker.gotoPrevMonth}",weight:200},fields:{type:"container",cls:"b-datepicker-title",items:{monthButton:{type:"button",cls:"b-datepicker-monthbutton",internalListeners:{click:"up.onMonthPickerRequested"}},yearButton:{type:"button",cls:"b-datepicker-yearbutton",internalListeners:{click:"up.onYearPickerRequested"}}},weight:300},nextMonth:{cls:"b-icon b-icon-next b-datepicker-nav-button",onAction:"up.gotoNextMonth",tooltip:"L{DatePicker.gotoNextMonth}",weight:400},nextYear:{cls:"b-icon b-icon-last b-datepicker-nav-button",onAction:"up.gotoNextYear",tooltip:"L{DatePicker.gotoNextYear}",weight:500}}},monthPicker:{value:{type:"MonthPicker",trapFocus:!0,positioned:!0,hidden:!0,internalListeners:{titleClick:"up.onMonthPickerTitleClick",select:"up.onMonthPicked",Escape:"up.onMonthPickerTitleClick"}},$config:"lazy"},yearPicker:{value:{type:"YearPicker",yearButtonCount:16,trapFocus:!0,positioned:!0,hidden:!0,internalListeners:{titleClick:"up.onYearPickerTitleClick",select:"up.onYearPicked"}},$config:"lazy"},date:null,minDate:{$config:"date",value:null},maxDate:{$config:"date",value:null},focusDisabledDates:null,multiSelect:null,selection:{$config:{equal:(i,e)=>i&&i.equals(e)},value:null},editMonth:{$config:"lazy",value:null},includeYear:{$config:"lazy",value:null},dayNameFormat:"dd",trapFocus:!0,ariaElement:"weeksElement",focusDescendant:!0,alwaysRefreshOnMonthChange:null,highlightSelectedWeek:null}}static get prototypeProperties(){return{outOfRangeCls:"b-out-of-range",activeCls:"b-active-date",selectedCls:"b-selected-date"}}construct(i){const e=this;super.construct(i);const{widgetMap:t}=e;e.externalCellRenderer=e.cellRenderer,e.cellRenderer=e.internalCellRenderer,e.element.removeAttribute("tabindex"),e.ariaElement.setAttribute("aria-activedescendant",`${e.id}-active-day`),t.fields&&!e.ariaLabel&&e.element.setAttribute("aria-labelledby",t.fields.id),j.on({element:e.weeksElement,click:{handler:"onCellClick",delegate:`.${e.dayCellCls}:not(.${e.disabledCls}):not(.${e.outOfRangeCls})`},mousedown:{handler:"onCellMousedown",delegate:`.${e.dayCellCls}`},thisObj:e}),e.getConfig("editMonth"),e.getConfig("includeYear"),e.refresh.flush()}get labelledElement(){return this.element}afterHide(...i){var e,t;(e=this._monthPicker)==null||e.hide(),(t=this._yearPicker)==null||t.hide(),super.afterHide(...i)}doDestroy(){var i,e;(i=this.yearButton)==null||i.destroy(),(e=this.monthButton)==null||e.destroy(),super.doDestroy()}get activeDayCell(){return this.weeksElement.querySelector(`#${this.id}-active-day`)}get focusElement(){return!this.disabled&&this.activeDayCell||this.element}onMonthDateChange(i){const e=super.onMonthDateChange(i);return this.ariaElement.setAttribute("aria-label",S.format(this.date,"MMMM YYYY")),this.refresh.flush(),e}updateEditMonth(i){const{monthButton:e,yearButton:t}=this.widgetMap,r=i===!1;e&&(e.readOnly=r),t&&(t.disabled=r)}updateIncludeYear(i){const{yearButton:e}=this.widgetMap;e&&(e.hidden=i===!1)}updateReadOnly(i){i?this.element.setAttribute("inert",!0):this.element.removeAttribute("inert")}doRefresh(...i){const e=this,{date:t,widgetMap:r}=e,n=e.activeDayCell,s=S.betweenLesser(e.activeDate,e.month.startDate,e.month.endDate)?e.activeDate:e._activeDate=t;e.getConfig("tbar"),super.doRefresh(...i),r.monthButton&&(r.monthButton.text=e.constructor._monthNames[t.getMonth()]),r.yearButton&&(r.yearButton.text=t.getFullYear());const a=S.parseKey(n==null?void 0:n.dataset.date);s-a&&e.syncActiveDate(s,a)}internalCellRenderer({cell:i,date:e}){const t=this,{externalCellRenderer:r}=t,n=t.isSelectedDate(e),s=t.getCellClassList(...arguments);if(n&&t.multiSelect){const a=!t.isSelectedDate(S.add(e,-1,"d")),o=!t.isSelectedDate(S.add(e,1,"d"));s["b-range-start"]=a,s["b-range-end"]=o,s["b-in-range"]=!a&&!o}E.updateClassList(i,s),i.innerHTML=`<div class="b-datepicker-cell-inner">${e.getDate()}</div>`,i.setAttribute("role","gridcell"),i.setAttribute("aria-label",S.format(e,"dddd MMMM Do, YYYY")),E.toggleAttribute(i,"aria-selected",n),t.isActiveDate(e)?i.id=`${t.id}-active-day`:i.removeAttribute("id"),r&&(arguments[0].cell=i.firstChild,t.callback(r,this,arguments))}getCellClassList({date:i}){const e=this,{activeCls:t,selectedCls:r}=e;return{[t]:t&&e.isActiveDate(i),[r]:e.isSelectedDate(i),[e.outOfRangeCls]:e.minDate&&i<e.minDate||e.maxDate&&i>e.maxDate}}onCellMousedown(i){const e=i.target.closest("[data-date]");this.focusable?(e.focus(),E.getActiveElement(e)===e&&i.preventDefault()):i.preventDefault(),this.activeDate=S.parseKey(e.dataset.date)}onCellClick(i){const e=i.target.closest("[data-date]");this.onUIDateSelect(S.parseKey(e.dataset.date),i)}onUIDateSelect(i,e){const t=this,{lastClickedDate:r,multiSelect:n}=t;t.isDisabledDate(i)||t.trigger("beforeDateSelect",{date:i,event:e})!==!1&&(t.lastClickedDate=i,t.activatingEvent=e,n?t.handleMultiSelect(r,i,e):(t.date=t.selection=i,t.floating&&t.hide()),t.activatingEvent=null)}handleMultiSelect(i,e,t){const r=this,{multiSelect:n}=r,s=r._selection||(r._selection=new _m),a=s.dates,o=n==="range"||n==="simple",l=n==="simple"||E.isTouchEvent,{size:d,generation:c}=s,u=d&&{[S.makeKey(S.add(a[0],-1,"d"))]:1,[S.makeKey(a[0])]:1,[S.makeKey(a[a.length-1])]:1,[S.makeKey(S.add(a[a.length-1],1,"d"))]:1},h=s.has(e),f=h?"delete":"add",g=o&&(u==null?void 0:u[S.makeKey(e)]);if(l&&d>1)s.clear(),s.add(e);else if(t.ctrlKey)(n===!0||!d||g)&&(s[f](e),o&&!s.has(r.rangeStartDate)&&r.rangeStartDate.setDate(r.rangeStartDate.getDate()+(e<a[1]?1:-1)));else if((l||t.shiftKey)&&d){const[v,y]=[new Date(o?r.rangeStartDate||(r.rangeStartDate=a[0]):i),e].sort(tT);o&&s.clear();for(const b=v;b<=y;b.setDate(b.getDate()+1))s.add(b)}else s.has(e)&&s.size===1||(s.clear(),s.add(e));const m=s.size;m===1?r.rangeStartDate=e:m||(r.rangeStartDate=null),s.generation!==c&&r.updateSelection(s)}updateHighlightSelectedWeek(i){this.element.classList.toggle("b-highlight-selected-week",!!i)}updateMultiSelect(i){this.element.classList.toggle("b-multiselect",!!i),i||(this.selection=[...this.selection][0])}get selection(){const{_selection:i}=this,e=i?i.dates:Z$;return this.multiSelect==="range"&&e.length?[e[0],e[e.length-1]]:e}getRange(i){if(this.multiSelect){const{selection:e}=this,t=e[0],r=e[e.length-1],n=S.add(r,1,"d");if(e.length>1&&n.getDate()===t.getDate())return{unit:"month",magnitude:S.diff(t,n,"month"),wholeMonth:t.getDate()===1&&r.getDate()===S.getLastDateOfMonth(r).getDate()&&Q$(e),startDate:t,endDate:r};if(t.getDay()==S.weekStartDay&&r.getDay()===(S.weekStartDay+6)%7)return{unit:"week",magnitude:S.diff(t,n,"week"),startDate:t,endDate:r};if(i){const s=S.floor(t,iT),a=S.ceil(n,iT),o=Math.max(Math.ceil(S.diff(s,a,"w")),1);return a.setDate(a.getDate()-1),{unit:"week",magnitude:o,startDate:s,endDate:a}}return{unit:"day",magnitude:S.diff(t,r,"d")+1,startDate:t,endDate:r}}}get snappedRange(){}changeSelection(i,e){const t=this;let r,n;if(!i)r=new _m;else if(i.isDateSet){if(e===i||e!=null&&e.equals(i))return e;n=T.first(i),r=i}else if(i.forEach||(i=[i]),i.forEach((s,a)=>i[a]=t.changeDate(s)),n=i[0],i.sort(tT),t.multiSelect==="range"&&i.length===2){r=new _m;for(const s=new Date(i[0]);s<=i[1];s.setDate(s.getDate()+1))r.add(s)}else n=i[0],r=new _m(i);return n&&(t.rangeStartDate=S.clearTime(n)),r}updateSelection(i,e){const t=this,{multiSelect:r}=t,{dates:n}=i,s=r==="range"?[n[0],n[n.length-1]]:n;if(!t.isConfiguring){!r&&n.length&&!t.peekConfig("date")&&n[0].getMonth()===t.month.month&&(t.date=n[0]),t.refresh.now();const a={selection:s,userAction:!!t.activatingEvent};if(e){const{dates:o}=e;a.oldSelection=r==="range"?[o[0],o[o.length-1]]:o}t.trigger("selectionChange",a)}}isSelected(i){return this.selection.some(e=>S.isSameDate(e,i))}onInternalKeyDown(i){const e=this,t=i.key.trim()||i.code,r=e.activeDate;let n=new Date(r);if(t==="Escape"){if(e.monthPicker.isVisible)return e.monthPicker.hide();if(e.yearPicker.isVisible)return e.yearPicker.hide();if(e.floating)return e.hide()}if(r&&e.weeksElement.contains(i.target)){do switch(t){case"ArrowLeft":i.preventDefault(),i.ctrlKey?n=e.gotoPrevMonth():n.setDate(n.getDate()-1);break;case"ArrowUp":i.preventDefault(),n.setDate(n.getDate()-7);break;case"ArrowRight":i.preventDefault(),i.ctrlKey?n=e.gotoNextMonth():n.setDate(n.getDate()+1);break;case"ArrowDown":i.preventDefault(),n.setDate(n.getDate()+7);break;case"Enter":return e.onUIDateSelect(r,i)}while(e.isDisabledDate(n)&&!e.focusDisabledDates);if(e.minDate&&n<e.minDate||e.maxDate&&n>e.maxDate)return;e.activeDate=n}}changeMinDate(i){return i&&kn.prototype.changeDate.apply(this,arguments)}updateMinDate(i){this._yearPicker&&(this._yearPicker.minYear=i==null?void 0:i.getFullYear()),this.refresh()}changeMaxDate(i){return i&&kn.prototype.changeDate.apply(this,arguments)}updateMaxDate(i){this._yearPicker&&(this._yearPicker.maxYear=i==null?void 0:i.getFullYear()),this.refresh()}changeDate(i){return S.clamp(super.changeDate(i),this.minDate,this.maxDate)}updateDate(i,e){const t=this,{month:r}=t;if(t.isConfiguring&&!t.initializingActiveDate&&("selection"in t.initialConfig||(t.selection=i),"activeDate"in t.initialConfig||(t.activeDate=i)),!r.date||i.getMonth()===r.month||!t.getCell(i)||t.alwaysRefreshOnMonthChange||t.isNavigating)super.updateDate(i);else{const n=r.getOtherMonth(i),s=t.eventListeners&&(e?i.getDate()!==e.getDate()|(n.getWeekId(i)!==r.getWeekId(e))<<1|(i.getMonth()!==(e==null?void 0:e.getMonth()))<<2|(i.getFullYear()!==(e==null?void 0:e.getFullYear()))<<3:15);t.trigger("dateChange",{changes:{d:!0,w:!!(s&2),m:!!(s&12),y:!!(s&8),r:n.weekCount!==r.weekCount},value:i,oldValue:e})}}changeActiveDate(i,e){const t=this;if(i==="today"&&(i=new Date),t.trigger("beforeActiveDateChange",{activeDate:i,oldActiveDate:e})!==!1){if(i=i?t.changeDate(i):t.date||(t.date=S.clearTime(new Date)),isNaN(i))throw new Error("DatePicker activeDate must be passed a Date, or a YYYY-MM-DD date string");return S.clamp(i,t.minDate,t.maxDate)}}updateActiveDate(i,e){const t=this,{isConfiguring:r}=t;(r||!t.getCell(i))&&(t.initializingActiveDate=r,t.date=i,t.initializingActiveDate=!1),!r&&!t.refresh.isPending&&t.syncActiveDate(i,e)}syncActiveDate(i,e){const t=this,{activeCls:r}=t,n=t.getCell(i),s=e&&t.getCell(e),a=E.getActiveElement(t.element);n&&(t.focusable&&n.setAttribute("tabIndex","0"),r&&n.classList.add(r),n.id=`${t.id}-active-day`,t.weeksElement.contains(a)&&n.focus()),s&&s!==n&&(t.focusable&&s.removeAttribute("tabIndex"),r&&s.classList.remove(r),s.removeAttribute("id"))}set value(i){const e=this,{selection:t,duration:r}=e;if(e.isNavigating=!0,i){if(i=e.changeDate(i,e.value),e.multiSelect==="range"&&(t==null?void 0:t.length)===2){S.betweenLesserEqual(i,...t)||(i<t[0]?e.selection=[i,S.add(i,r-1,"d")]:e.selection=[S.add(i,-(r-1),"d"),i]),e.date=e.activeDate=i;return}i!==void 0&&(e.selection=i,e.date=e.activeDate=i)}else e.date=e.activeDate=new Date,e.selection=null;e.isNavigating=!1}get value(){const{selection:i}=this,e=(i==null?void 0:i.length)||null;return e&&i[e-1]}get duration(){return this.multiSelect==="range"?S.diff(...this.selection,"d")+1:1}gotoPrevYear(){return this.goto(-1,"year")}gotoPrevMonth(){return this.goto(-1,"month")}gotoNextMonth(){return this.goto(1,"month")}gotoNextYear(){return this.goto(1,"year")}goto(i,e){const t=this,{activeDate:r}=t,n=r&&t.getCell(r);let s;return e==="month"&&n&&(r==null?void 0:r.getMonth())===t.month.month+i?s=r:s=S.add(n?r:t.date,i,e),t.gotoDate(s,i,n)}gotoDate(i,e,t=this.activeDate&&this.getCell(this.activeDate)){const r=this,n=new Date(i);n.setDate(1);const s=S.add(S.add(n,1,"month"),-1,"day");if(r.minDate&&e<0&&s<r.minDate||r.maxDate&&e>0&&n>r.maxDate)return;r.isNavigating=!0;const a=r.date=i;return r.widgetMap.monthButton.text=r.constructor._monthNames[i.getMonth()],t&&(r.activeDate=i),r.isNavigating=!1,a}isActiveDate(i){return!(i-this.activeDate)}isSelectedDate(i){var e;return(e=this._selection)==null?void 0:e.has(i)}onFocusIn(i){var e;super.onFocusIn(i),i.toWidget===this&&i._target===this.element&&!this.disabled&&((e=this.focusElement)==null||e.focus())}onMonthPickerRequested(){const{monthPicker:i}=this;i.isVisible?i.hide():(i.month=this.activeDate.getMonth(),i.show(),i.focus())}onYearPickerRequested(){const{yearPicker:i}=this;i.isVisible?i.hide():(i.year=i.startYear=this.activeDate.getFullYear(),i.show(),i.focus())}onMonthPickerTitleClick(){this.monthPicker.hide()}onYearPickerTitleClick(){this.yearPicker.hide()}onMonthPicked({value:i,source:e}){var t;const r=this;r.gotoDate(S.add(r.activeDate,i-r.activeDate.getMonth(),"month")),r.widgetMap.monthButton.text=r.constructor._monthNames[r.activeDate.getMonth()],(t=r.focusElement)==null||t.focus({preventScroll:!0}),e.hide()}onYearPicked({value:i,source:e}){var t;const r=new Date(this.activeDate);r.setFullYear(i),this.activeDate=r,(t=this.focusElement)==null||t.focus({preventScroll:!0}),e.hide()}changeMonthPicker(i,e){return Ln.reconfigure(e,i?Ln.mergeConfigs({owner:this,appendTo:this.element},i):null,this)}changeYearPicker(i,e){var t,r;return On.reconfigure(e,i?On.mergeConfigs({owner:this,appendTo:this.element,minYear:(t=this.minDate)==null?void 0:t.getFullYear(),maxYear:(r=this.maxDate)==null?void 0:r.getFullYear()},i):null,this)}get childItems(){const{_yearPicker:i,_monthPicker:e}=this,t=super.childItems;return i&&t.push(i),e&&t.push(e),t}updateLocalization(){var i;const e=this,{monthButton:t}=e.widgetMap,r=e.constructor._monthNames=S.getMonthNames();t&&!e.isConfiguring&&(t.text=r[(i=e.monthPicker.month)!=null?i:e.date.getMonth()]),super.updateLocalization()}changeMultiSelect(i){return i==="range"&&Y.isTouchDevice&&(i="simple"),i}};p(Ni,"$name","DatePicker"),p(Ni,"type","datepicker"),p(Ni,"_monthNames",S.getMonthNames()),Ni.initClass(),Ni._$name="DatePicker";var J$=new Date,At=class extends sa{changePicker(i,e){var t;if(i!=null&&i.isDatePicker)return i;const r=this,n=Ni.mergeConfigs({owner:r,forElement:r.pickerAlignElement,minDate:r.min,maxDate:r.max,weekStartDay:r._weekStartDay,align:{anchor:r.overlayAnchor,target:r.pickerAlignElement},internalListeners:{selectionChange:"onPickerSelectionChange",thisObj:r}},i);r.calendarContainerCls&&(n.cls=r.calendarContainerCls),r.value?n[r.isValid?"value":"activeDate"]=r.value:n.activeDate||(n.activeDate=new Date);const s=Ni.reconfigure(e,i?n:null,r);return(t=s==null?void 0:s.refresh)==null||t.flush(),s}onPickerSelectionChange({selection:i,source:e}){if(e.isVisible){const t=this,r=i.length?t.value?S.copyTimeValues(new Date(i[0]),t.value):new Date(i[0]):null;t._isUserAction=t._isPickerInput=!0,t.value=r,t._isPickerInput=t._isUserAction=!1,e.hide()}}getStepDate(i){const{step:e}=this;return S.add(this.value,(i||1)*e.magnitude,e.unit)}stepDate(i,e=!0){const t=this;if(!t.readOnly&&t.value){const r=t.getStepDate(i);t.checkMinMax(r)||(e?(t._isUserAction=!0,t.value=r,t.autoSelect&&t.select(),t._isUserAction=!1):t.value=r)}}onBackClick(){this.stepDate(-1)}onForwardClick(){this.stepDate(1)}showPicker(i){if(this.readOnly)return;const e=this,{_picker:t}=e;if(t){const r={minDate:e.min,maxDate:e.max};e.value?r[e.isValid?"value":"activeDate"]=e.value:t.activeDate||(r.activeDate=new Date),t.setConfig(r)}super.showPicker(i)}focusPicker(){var i;(i=this.picker)==null||i.focus()}checkMinMax(i){const{min:e,max:t}=this;return e&&i<e?-1:t&&i>t?1:0}get isValid(){const i=this;i.clearError("L{Field.minimumValueViolation}",!0),i.clearError("L{Field.maximumValueViolation}",!0);let{value:e}=i;if(e){let{min:t,max:r,validateDateOnly:n}=i;if(n&&(e=S.clearTime(e,!1),t&&(t=S.clearTime(t,!1)),r&&(r=S.clearTime(r,!1))),t&&e<t)return i.setError("L{Field.minimumValueViolation}",!0),!1;if(r&&e>r)return i.setError("L{Field.maximumValueViolation}",!0),!1}return super.isValid}transformDateValue(i,e=!0){const t=this;return i!=null&&(S.isDate(i)||(typeof i=="string"?i=S.parse(i,t.format,t.strictParsing)||S.parse(i,t.fallbackFormat,t.strictParsing):i=new Date(i)),S.isValidDate(i))?e&&(!t.min||i-t.min>-S.MS_PER_DAY)&&(!t.max||i<=t.max)?t.transformTimeValue(i):i:null}isTimeValue(i){return i&&i!==!0&&i!=="entered"}transformTimeValue(i){const e=this,{keepTime:t}=e;if(i=S.clone(i),!t)S.clearTime(i,!1);else if(e.isTimeValue(t)){const r=S.parse(t,e.timeFormat);S.copyTimeValues(i,r)}else t===!0&&(e._isPickerInput||e.inputting)&&S.isValidDate(e.value)&&S.copyTimeValues(i,e.value);return i}changeMin(i){return this.transformDateValue(i,!1)}updateMin(i){const{input:e,_picker:t}=this;e&&(i==null?e.removeAttribute("min"):e.min=i),t&&(t.minDate=i),this.syncInvalid()}changeMax(i){return this.transformDateValue(i,!1)}updateMax(i){const{input:e,_picker:t}=this;e&&(i==null?e.removeAttribute("max"):e.max=i),t&&(t.maxDate=i),this.syncInvalid()}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:S.weekStartDay}updateWeekStartDay(i){this._picker&&(this._picker.weekStartDay=i)}changeValue(i,e){const t=this,r=t.transformDateValue(i),n=t.L("L{invalidDate}")(S.format(J$,t.format));if(i&&!r){(!t.inputting||t.validateOnInput)&&t.setError(n);return}if(t.clearError(n),t.hasChanged(e,r))return super.changeValue(r,e);t.inputting||t.syncInputFieldValue()}updateValue(i,e){const t=this._picker;t&&(t.value=i,this.inputting||(t.activeDate=i)),super.updateValue(i,e)}changeStep(i,e){const t=typeof i;if(!i)return null;if(t==="number"?i={magnitude:Math.abs(i),unit:e?e.unit:"day"}:t==="string"&&(i=S.parseDuration(i)),i&&i.unit&&i.magnitude)return i.magnitude<0&&(i={magnitude:-i.magnitude,unit:i.unit}),i}updateStep(i){this.element.classList[i?"remove":"add"]("b-no-steppers"),this.syncInvalid()}hasChanged(i,e){return i!=null&&i.getTime&&(e!=null&&e.getTime)&&(!this.keepTime||this.isTimeValue(this.keepTime))?!S.isEqual(S.clearTime(i),S.clearTime(e)):super.hasChanged(i&&i.getTime(),e&&e.getTime())}get inputValue(){const i=this.value;return i?S.format(i,this.format):""}updateFormat(){this.isConfiguring||this.syncInputFieldValue(!0)}updateLocalization(){super.updateLocalization(),this.syncInputFieldValue(!0)}internalOnKeyEvent(i){var e;if(super.internalOnKeyEvent(i),i.type==="keydown"){const t=this;let r;switch(i.virtualKey){case"Enter":t.isValid&&((e=t.picker)==null||e.hide());break;case"ArrowLeft":(t.caretAtStart||t.selectedAll)&&(r=-1);break;case"ArrowRight":(t.caretAtEnd||t.selectedAll)&&(r=1);break;case"NumpadAdd":r=1;break;case"NumpadSubtract":r=-1;break}r&&t.step&&(t.stepDate(r),t.selectAll(),i.preventDefault())}}};p(At,"$name","DateField"),p(At,"type","datefield"),p(At,"alias","date"),p(At,"configurable",{format:"L",strictParsing:!1,fallbackFormat:"YYYY-MM-DD",timeFormat:"HH:mm:ss:SSS",keepTime:!1,pickerFormat:null,validateDateOnly:null,triggers:{expand:{cls:"b-icon-calendar",handler:"onTriggerClick",weight:200},back:{cls:"b-icon b-icon-angle-left b-step-trigger b-step-trigger-back",key:"Shift+ArrowDown",handler:"onBackClick",align:"start",weight:100},forward:{cls:"b-icon b-icon-angle-right b-step-trigger b-step-trigger-forward",key:"Shift+ArrowUp",handler:"onForwardClick",align:"end",weight:100}},calendarContainerCls:"",min:null,max:null,step:!1,stepTriggers:{$config:null,default:!0},weekStartDay:null,picker:{type:"datepicker",floating:!0,scrollAction:"realign",align:{align:"t0-b0",axisLock:!0}},value:null,role:"combobox"}),At.initClass(),At._$name="DateField";var e1=Array.from(Array(24)).map((i,e)=>({id:e,text:String(e+100).slice(1)})),t1=Array.from(Array(60)).map((i,e)=>({id:e,text:String(e+100).slice(1)})),da=class extends Rt{alignTo(...i){const{widgetMap:e}=this,{minute:t,second:r}=this.owner.input;return this.getConfig("is24Hour"),this.minimizeHeight&&(e.hour.maxHeight=e.second.maxHeight=e.minute.height),e.minute[t?"show":"hide"](),e.second[r?"show":"hide"](),super.alignTo(...i)}updateIs24Hour(i){this.widgetMap.hour.store.filter(e=>i?!0:e.id<12)}updateStep(i){i=S.as("m",i.magnitude,i.unit);const e=[];for(let t=0;t<60;t+=i)e.push({id:t,text:String(100+t).slice(1)});this.widgetMap.minute.store.data=e}onSelectionChange({source:i,selected:[e]}){const t=this;t._isUserAction=i._isUserAction,i.navigator.activeItem=e,t.updatingValue||t.owner.input.setSubFieldValue(i.ref,e.id),t._isUserAction=!1}triggerTimeChange(i){this.trigger("timeChange",{time:i})}updateInitialValue(i){this.value=i}changeValue(i){return i&&(i=typeof i=="string"?S.parse(i,this.format):i),i!=null?i:S.getTime(0)}updateValue(i){const e=this,{hour:t,minute:r,second:n}=e.widgetMap,s=i.getHours(),a=e.is24Hour?s:s%12,o=i.getMinutes(),l=i.getSeconds();e.updatingValue=!0,t.navigator.activeItem=new Number(a),t.select(a,!0),r.navigator.activeItem=new Number(o),r.select(o,!0),n.navigator.activeItem=new Number(l),n.select(l,!0),e.updatingValue=!1,r.store.filter(),n.store.filter(),e.isVisible&&e.triggerTimeChange(i)}changeMin(i){return typeof i=="string"?S.parse(i,this.format):i}updateMin(i){const{hour:e,minute:t,second:r}=this.widgetMap,{owner:n,is24Hour:s}=this;if(i){const a=i.getHours(),o=i.getMinutes(),l=i.getSeconds();e.store.filter({id:"min-filter",filterBy:({id:d})=>(!s&&n.value.getHours()>=12&&(d+=12),d>=a)}),t.store.filter({id:"min-filter",filterBy:({id:d})=>n.value.getHours()!==a||d>=o}),r.store.filter({id:"min-filter",filterBy:({id:d})=>{const{value:c}=n;return c.getHours()*60+c.getMinutes()>a*60+o||d>=l}})}else e.store.removeFilter("min-filter"),t.store.removeFilter("min-filter"),r.store.removeFilter("min-filter")}changeMax(i){return typeof i=="string"?S.parse(i,this.format):i}updateMax(i){const{hour:e,minute:t,second:r}=this.widgetMap;if(i){const n=i.getHours(),s=i.getMinutes(),a=i.getSeconds();e.store.filter({id:"max-filter",filterBy:({id:o})=>o<=n}),t.store.filter({id:"max-filter",filterBy:({id:o})=>o<=s}),r.store.filter({id:"max-filter",filterBy:({id:o})=>o<=a})}else e.store.removeFilter("max-filter"),t.store.removeFilter("max-filter"),r.store.removeFilter("max-filter")}};p(da,"$name","TimePicker"),p(da,"type","timepicker"),p(da,"configurable",{floating:!0,layout:"hbox",defaults:{type:"list",displayField:"id",itemTpl(i){const e=i.id,t=this.ref!=="hour"||this.owner.is24Hour||e?e:12;return String(t+100).slice(1)},itemCls:"b-timepicker-item",itemsFocusable:!1,scrollable:{overflowY:"hidden-scroll"},onSelectionChange:"up.onSelectionChange",navigator:{activateOnMouseover:!0}},items:{hour:{items:e1},minute:{items:[]},second:{hidden:!0,items:t1}},step:{magnitude:5,unit:"m"},autoShow:!1,trapFocus:!0,value:{$config:{equal:"date"},value:null},format:null,max:null,min:null,is24Hour:{$config:"lazy",value:null},initialValue:null}),da.initClass(),da._$name="TimePicker";var i1=/\d+/,r1=/\d+(\D)\d+/,Xb=["hour","minute","second"],il=[3600,60,1],n1=["getHours","getMinutes","getSeconds"],s1=`
        :host {
            display:flex
        }
        * {
            font-size:inherit;
            font-family:inherit;
            color:inherit;
            background-color:inherit
        }
        input,button {
            padding:0;
            margin:0;
            border:0 none;
            outline:0 none;
            background-color:var(--timefield-input-background-color);
            text-align:center
        }
        input {
            width:2ch;
        }
        #am-pm {
            margin-inline:5px
        }
        #am-pm:focus-visible {
            outline:none;
            background-color:var(--timefield-button-background-color)
        }`,Zb=class extends HTMLElement{constructor(){var i;super();const e=this,t=e._root=e.attachShadow({mode:"open",delegatesFocus:!0});e.internals_=(i=e.attachInternals)==null?void 0:i.call(e),e.byRef=Object.create(null),t.addEventListener("keydown",e.onKeyDown.bind(e)),t.addEventListener("focusin",e.onFocusIn.bind(e)),t.addEventListener("click",e.onClick.bind(e)),t.addEventListener("input",e.onInput.bind(e)),t.addEventListener("focusout",e.onFocusOut.bind(e))}connectedCallback(){var i;const e=this;e.silentChangeValue=!0,e.owner=(i=e.elementData)==null?void 0:i.owner,e.createStructure(e.owner.format),e.updateValue(e._value),e.silentChangeValue=!1}ingestDate(i){let e=new Date(i);return isNaN(e)&&(e=S.parse(i,this.owner.format)),e}get is24Hour(){return this.owner.is24Hour}attributeChangedCallback(i,e,t){var r;const n=this;switch(i){case"min":n.updateMin(t);break;case"max":n.updateMax(t);break;case"label":n._label=t,(r=n.inputs)==null||r.forEach(s=>s.setAttribute("aria-label",t));break;case"disabled":n.disabled=t;break;case"tabindex":n.tabIndex=Number(t);break}}updateMin(i){const e=i==null?null:S.getTime(this.ingestDate(i));this.minValue=e,this.minHour=(e==null?void 0:e.getHours())||0}updateMax(i){const e=i==null?null:S.getTime(this.ingestDate(i));this.maxValue=e,this.maxHour=(e==null?void 0:e.getHours())||(this.is24Hour?23:11)}onFocusIn(i){var e;const t=this,{target:r}=i,n=t.getAriaLabel();r.tagName==="INPUT"&&(r.value=`00${r.value}`.slice(-2),(e=r.setSelectionRange)==null||e.call(r,0,2)),t.setAttribute("aria-label",n),t._root.activeElement.setAttribute("aria-label",n),t._root.contains(i.relatedTarget)||ce.isMouseDown()||t.focusField(0),i.stopImmediatePropagation()}onClick(i){const{target:e}=i,{owner:t}=this;e===this.ampmButton&&(t.readOnly||(e.innerText=e.innerText===S.amIndicator?S.pmIndicator:S.amIndicator,this.onValueMutated(),i.stopPropagation()))}onFocusOut({target:i}){this.onValueMutated(),!this.isCleared&&i!==this.ampmButton&&(i.value=`0${parseInt(i.value)}`.slice(-2))}onKeyDown(i){var e,t,r,n;const s=this,{subfieldIndex:a}=s,{editable:o,readOnly:l}=s.owner,{amIndicator:d,pmIndicator:c}=S,{target:u,key:h}=i;if(!(i.ctrlKey||i.cmdKey||i.metaKey||i.shiftKey&&h!=="Tab"&&h.length!==1))switch(h){case"Tab":s.inputs[i.shiftKey?0:s.inputs.length-1].focus();break;case" ":(u===s.ampmButton||l)&&i.stopImmediatePropagation();break;case"ArrowLeft":i.preventDefault(),i.stopPropagation(),a>0&&!i.altKe&&s.focusField(a-1);break;case":":if(u===s.ampmButton){i.preventDefault();break}case"ArrowRight":i.preventDefault(),i.stopPropagation(),a<s.inputs.length-1&&s.focusField(a+1);break;case"ArrowUp":i.preventDefault(),i.stopPropagation(),l||s[s.owner.pickerVisible?"decrementSubfield":"incrementSubfield"](u);break;case"ArrowDown":i.preventDefault(),i.stopPropagation(),l||s[s.owner.pickerVisible?"incrementSubfield":"decrementSubfield"](u);break;case"0":case"1":case"2":case"3":case"4":case"5":case"6":case"7":case"8":case"9":(!o||l)&&i.preventDefault();break;case"Backspace":case"Delete":(!o||l)&&i.preventDefault();break;case"Escape":break;case((e=d==null?void 0:d[0])==null?void 0:e.toLocaleLowerCase()):case((t=d==null?void 0:d[0])==null?void 0:t.toLocaleUpperCase()):if(!l&&!s.is24Hour){i.preventDefault(),s.ampmButton.innerText=d,s.onValueMutated();break}case((r=c==null?void 0:c[0])==null?void 0:r.toLocaleLowerCase()):case((n=c==null?void 0:c[0])==null?void 0:n.toLocaleUpperCase()):if(i.preventDefault(),!l&&!s.is24Hour){i.preventDefault(),s.ampmButton.innerText=c,s.onValueMutated();break}default:i.preventDefault()}}onInput({target:i,data:e}){var t;const r=this;let{value:n}=i;if((e==null?void 0:e.length)>1&&!isFinite(n))n=i.value=((t=r.value)==null?void 0:t.getHours())||"00";else if(n.length===1||n.length===2&&i.selectionStart===1&&i.selectionEnd===1){i.setSelectionRange(1,2);return}else if(!n)n=i.value="00",i.setSelectionRange(0,2);else if(i.selectionEnd===2){const{subfieldIndex:s}=r;s<r.inputs.length-1&&r.focusField(s+1)}i===r.hour&&n==="00"&&!r.is24Hour&&(r.ampmButton.innerText=S.amIndicator),r.activeElement=i,r.onValueMutated(),r.activeElement=null}decrementSubfield(i){var e;const{subfieldIndex:t,step:r,isPM:n}=this;if(i===this.ampmButton)i.innerText=n?S.amIndicator:S.pmIndicator;else{const s=this.getSubFieldValue(t),a=r<il[t-1]&&r>il[t+1]?r/il[t]:1,o=Math.floor(s/a)*a-a;t===0&&!this.is24Hour&&s===12&&(this.ampmButton.innerText=S.amIndicator),i.value=o}this.onValueMutated(),(e=i.setSelectionRange)==null||e.call(i,0,2)}incrementSubfield(i){var e;const{subfieldIndex:t,step:r,is24Hour:n,isPM:s}=this;if(i===this.ampmButton)i.innerText=s?S.amIndicator:S.pmIndicator;else{const a=this.inputs[t],o=this.getSubFieldValue(t),l=r<il[t-1]&&r>il[t+1]?r/il[t]:1,d=Math.floor(o/l)*l+l;if(t===0&&!this.is24Hour&&o===11&&(this.ampmButton.innerText=S.pmIndicator),t===0&&(s&&!n?o+12:o)===(this.maxHour||23))return;a.value=d}this.onValueMutated(),(e=i.setSelectionRange)==null||e.call(i,0,2)}createStructure(i=this.owner.format){var e;const t=this,{_root:r,tabIndex:n,is24Hour:s,silentChangeValue:a}=t,{amIndicator:o}=S,l=new Date(1970,0,1,1,2,3),d=S.format(l,i).trim(),c=t.delimiter=(e=d.match(r1))==null?void 0:e[1],u=[...d.matchAll(new RegExp(`\\d+${c?`|\\${c}`:""}|${o}|[^\\${c}\\d]+`,"g"))].map(m=>m[0]),h=[];t.names=[],t.labelElId=`${t.owner.id}-label-element`,t.silentChangeValue=!0,n!=null&&t.setAttribute("tabIndex",n);let f=0,g;for(let m=0,v=0,{length:y}=u;m<y;m++){const b=u[m],C=m?59:s?23:11;b.trim()===o?(g=!0,t.names.push(`${S.amIndicator}/${S.pmIndicator}`),h.push({tag:"button","aria-label":t.getAriaLabel(f),reference:"ampmButton",id:"am-pm",type:"button",text:o,dataset:{subfieldIndex:f++}})):b.match(i1)?(t.names.push(S.getLocalizedNameOfUnit(Xb[v])),h.push({tag:"input","aria-label":t.getAriaLabel(f),id:Xb[v],reference:Xb[v++],size:2,maxlength:2,minlength:2,dataset:{subfieldIndex:f++,max:C}})):b===c?h.push({tag:"span",text:c,reference:"delimiter"}):h.push({reference:"junk",tag:"span",text:b.replaceAll(" ","\xA0")})}h[h.length-1].reference==="delimiter"&&h.length--,!s&&!g&&(t.names.push(`${S.amIndicator}/${S.pmIndicator}`),h.push({tag:"button",reference:"ampmButton",id:"am-pm",type:"button",text:o,dataset:{subfieldIndex:f++}})),t.silentChangeValue=a,h.push({tag:"style",text:s1}),he.sync({targetElement:r,refOwner:t,domConfig:{onlyChildren:!0,children:h}}),t.inputs=[...r.querySelectorAll("input")],t.minute||(t.owner.step="1 h"),s?t.ampmButton=null:t.inputs.push(t.ampmButton)}attachRef(i,e){this.byRef[i]=this[i]=e}detachRef(i){this[i]=null,delete this.byRef[i]}getAriaLabel(i=this.subfieldIndex){const{owner:e}=this;return`${e.ariaLabel||e.label||""} ${this.innerText}${i!=null?` - ${this.names[i]}`:""}.`}getSubFieldValue(i){const{date:e}=this;return e?e[n1[i]]():0}setSubFieldValue(i,e,t){i=typeof i=="number"?this.inputs[i]:typeof i=="string"?this[i]:i,i&&(e<10&&(i!==this.activeElement||i.value.length===2)&&(e=`0${e}`),i.value!=e&&(i.value=e,t||this.onValueMutated()))}set value(i){const{_value:e}=this;i=this._value=i?this.ingestDate(i):null,this.isConnected&&i-e&&this.updateValue(i,e)}updateValue(i,e=null){var t;if(Number(i)!=Number(e)){const r=this,{ampmButton:n}=r,s=r.getAriaLabel();if(i){const{hour:a,minute:o,second:l}=r,d=i.getHours();r.is24Hour?r.setSubFieldValue(a,d,!0):(n.innerText=d>11?S.pmIndicator:S.amIndicator,r.setSubFieldValue(a,d>12?d%12:d,!0)),o&&r.setSubFieldValue(o,i.getMinutes(),!0),l&&r.setSubFieldValue(l,i.getSeconds(),!0)}else r._value=S.clearTime(e),r.inputs.forEach(a=>a.value=""),n&&(n.innerText=S.amIndicator);r.setAttribute("value",S.format(i,r.owner.format)),(t=r._root.activeElement)==null||t.setAttribute("aria-label",s),r.setAttribute("aria-label",s),!r.silentChangeValue&&!r.owner.sycingInputFieldValue&&r.dispatchEvent(new InputEvent("change"))}}onValueMutated(){const i=this,{date:e,minValue:t,maxValue:r}=i,n=e?new Date(e):null;e&&(t&&S.getTime(n)<S.getTime(t)?(n.setHours(t.getHours(),t.getMinutes(),t.getSeconds()),i._value=null):r&&S.getTime(n)>S.getTime(r)&&(n.setHours(r.getHours(),r.getMinutes(),r.getSeconds()),i._value=null)),i.value=n}set disabled(i){i=!!i,this._disabled!==i&&(this._disabled=i,i?this.setAttribute("disabled",!0):this.removeAttribute("disabled"))}set tabIndex(i){this._tabIndex=i}get tabIndex(){return this._tabIndex}get subfieldIndex(){const{activeElement:i}=this.shadowRoot;return i&&parseInt(i.dataset.subfieldIndex)}get isPM(){var i;return this.is24Hour?parseInt(this.hour.value||0)>11:((i=this.ampmButton.firstChild)==null?void 0:i.data)===S.pmIndicator}get value(){return this.date}get innerText(){return S.format(this.silentChangeValue?this._value:this.date,this.owner.format)||""}get date(){var i,e,t,r;const n=this,{_value:s}=n;if(!n.isConnected)return s||null;if(n.isCleared)return null;const a=n._value==null?[]:[n._value],o=new Date(...a),l=parseInt(((i=n.hour)==null?void 0:i.value)||0),d=parseInt(((e=n.minute)==null?void 0:e.value)||0),c=parseInt(((t=n.second)==null?void 0:t.value)||0);let u=l;if(!n.is24Hour){const h=((r=n.ampmButton.firstChild)==null?void 0:r.data)===S.pmIndicator;l===12&&!n.isPM?u=0:l<12&&h&&(u+=12)}return o.setHours(u,d,c,0),o}get rawDate(){var i,e,t;const r=new Date(this._value);return r.setHours(parseInt(((i=this.hour)==null?void 0:i.value)||0),parseInt(((e=this.minute)==null?void 0:e.value)||0),parseInt(((t=this.second)==null?void 0:t.value)||0)),r}get isCleared(){var i;return!((i=this.inputs)!=null&&i.map(e=>e.value.trim()).join(""))}focusField(i){var e;const t=this.inputs[i];t&&(t.focus(),(e=t.setSelectionRange)==null||e.call(t,0,2))}};p(Zb,"formAssociated",!0),p(Zb,"observedAttributes",["min","max","disabled","tabindex"]),typeof customElements!="undefined"&&!customElements.get("bry-time")&&customElements.define("bry-time",Zb);var oi=class extends sa{get inputElement(){const i=super.inputElement;return i.tag="bry-time",i.label=this.label,i.elementData={owner:this},i}changePicker(i,e){const t=this,r=t.pickerWidth||(i==null?void 0:i.width);return da.reconfigure(e,i,{owner:t,defaults:{step:t.step,value:t.value,forElement:t.pickerAlignElement,owner:t,is24Hour:t.is24Hour,align:{matchSize:r==null,anchor:t.overlayAnchor,target:t[t.pickerAlignElement]},width:r,onTimeChange({source:n,time:s}){t._isUserAction=!0,n._isUserAction&&n.hide(),t.value=s,t.min&&!t.is24Hour&&t._picker.widgetMap.hour.store.filter(),t._isUserAction=!1}}})}selectAll(){}syncInputFieldValue(...i){const e=this;e.sycingInputFieldValue=!0,super.syncInputFieldValue(...i),e.sycingInputFieldValue=!1,e.syncInvalid(),e.pickerVisible&&(e.picker.value=e.value)}get inputValue(){return this._value}get needsInputSync(){var i;return String(this.input[this.inputValueAttr])!==String((i=this.inputValue)!=null?i:"")}syncInputReadOnly(){this.getConfig("readOnly"),this.inputReadOnly=this._readOnly}onBackClick(){const i=this,{min:e}=i;if(!i.readOnly&&i.value){const t=S.add(i.value,-1*i.step.magnitude,i.step.unit);(!e||e.getTime()<=t)&&(i.value=t)}}onForwardClick(){const i=this,{max:e}=i;if(!i.readOnly&&i.value){const t=S.add(i.value,i.step.magnitude,i.step.unit);(!e||e.getTime()>=t)&&(i.value=t)}}get isValid(){const i=this;i.clearError("L{minimumValueViolation}",!0),i.clearError("L{maximumValueViolation}",!0);let e=i.input.date;if(e){if(e=S.getTime(e),i._min&&S.getTime(i._min)>e)return i.setError("L{minimumValueViolation}",!0),!1;if(i._max&&S.getTime(i._max)<e)return i.setError("L{maximumValueViolation}",!0),!1}return super.isValid}internalOnChange(i,...e){const t=this,r=t.input.date;(!r||!isNaN(r))&&(t.clearError("L{invalidTime}"),t.inputting=!0,t._value=r,t.pickerVisible&&(t.picker.value=r),super.internalOnChange(i,...e),t.inputting=!1)}internalOnKeyEvent(i){if(this.pickerVisible&&(i.key==="Escape"&&(this.value=this.pickerValueOnShow),i.key==="Enter")){this.hidePicker(),i.preventDefault();return}super.internalOnKeyEvent(i)}hasChanged(i,e){return i!=null&&i.getTime&&(e!=null&&e.getTime)?this.keepDate?i-e!==0:!S.isSameTime(i,e):super.hasChanged(i,e)}showPicker(){const i=this,{picker:e,value:t}=i;i.readOnly||(e.value=null,e.format=i.format,super.showPicker(),e.value=i.pickerValueOnShow=t,e.max=i.max,e.min=i.min,t||(i.value=e.value))}transformTimeValue(i){i!=null&&(typeof i=="string"?(i=S.parse(i,this.format),this.keepDate&&i&&this.value&&(i=S.copyTimeValues(new Date(this.value),i))):i=new Date(i),S.isValidDate(i)?this.keepDate||(i=S.getTime(i)):i=null);const e={value:i};return this.trigger("transformTimeValue",e),i=e.value,i}changeMin(i){return this.transformTimeValue(i)}updateMin(i){const{input:e}=this;e&&(i==null?e.removeAttribute("min"):e.setAttribute("min",i)),this.syncInvalid()}changeMax(i){return this.transformTimeValue(i)}updateMax(i){const{input:e}=this;e&&(i==null?e.removeAttribute("max"):e.setAttribute("max",i)),this.syncInvalid()}changeValue(i,e){const t=this,r=t.transformTimeValue(i);if(i&&!r||t.isRequired&&i===""){t.setError("L{invalidTime}");return}if(t.clearError("L{invalidTime}"),t.hasChanged(e,r))return super.changeValue(r,e);t.inputting||t.syncInputFieldValue(!0)}updateValue(i,e){const{expand:t}=this.triggers;this.syncInputFieldValue(!0),t&&i&&(t.element.firstElementChild.style.animationDelay=-((i.getHours()*60+i.getMinutes())/10)+"s"),super.updateValue(i,e)}changeStep(i,e){const t=typeof i;if(!i)return{magnitude:5,unit:"minute"};if(t==="number"?i={magnitude:Math.abs(i),unit:e?e.unit:"hour"}:t==="string"&&(i=S.parseDuration(i)),i!=null&&i.unit&&(i!=null&&i.magnitude))return i.magnitude<0&&(i={magnitude:-i.magnitude,unit:i.unit}),i}updateStep(i){const{_picker:e}=this;this.input.step=i&&S.as("s",i.magnitude,i.unit),e&&S.as("m",i)<30&&(e.step=i),this.syncInvalid()}get is24Hour(){return S.is24HourFormat(this.format)}updateFormat(i,e){const t=this;if(!t.isConfiguring){t._format=e;const{input:r}=t,{value:n}=r;t._format=i,t.sycingInputFieldValue=!0,r.createStructure(i),r.updateValue(n,NaN),t.syncInputFieldValue(!0),t.sycingInputFieldValue=!1}}updateLocalization(){super.updateLocalization(),this.input.isConnected&&this.input.createStructure(),this.syncInputFieldValue(!0)}};p(oi,"$name","TimeField"),p(oi,"type","timefield"),p(oi,"alias","time"),p(oi,"configurable",{inputElementTag:"bry-time",picker:{type:"timepicker",scrollAction:"realign",align:{align:"t0-b0",minHeight:200,axisLock:!0,matchSize:"min"}},role:"textbox",format:"LT",triggers:{expand:{align:"end",handler:"onTriggerClick",key:" ",compose:()=>({children:[{class:{"b-icon-clock-live":1}}]})},back:{align:"start",cls:"b-icon b-icon-angle-left b-step-trigger",key:"Shift+ArrowDown",handler:"onBackClick"},forward:{align:"end",cls:"b-icon b-icon-angle-right b-step-trigger",key:"Shift+ArrowUp",handler:"onForwardClick"}},min:null,max:null,step:"5m",stepTriggers:{$config:null,default:!0},value:{$config:{equal:"date"},value:null},keepDate:!0}),p(oi,"delayable",{syncInvalid:{type:"buffer",delay:300}}),oi.initClass(),oi._$name="TimeField";var Qb=i=>{var e;return e=class extends i.mixin(Go){get dateFieldDefaults(){return T.merge({format:this.format},this._dateFieldDefaults)}configureDateField(t,r,n){const s=this,{dateStepTriggers:a}=s;return At.reconfigure(r,t,{owner:s,defaults:T.assign({stepTriggers:a===!0||a==="both"||a===n},s.dateFieldDefaults)})}changeFieldEndDate(t,r){return this.configureDateField(t,r,"end")}updateFieldEndDate(t){var r;t&&((r=this.dateFieldContainer)==null||r.add(t))}changeFieldStartDate(t,r){return this.configureDateField(t,r,"start")}updateFieldStartDate(t){var r;t&&((r=this.dateFieldContainer)==null||r.add(t))}updateFormat(t){this.isConstructing||(this.fieldEndDate.format=t,this.fieldStartDate.format=t)}updatePickingStartDate(t){this.element.classList.toggle("b-picking-start-date",!!t)}updateValue(t,r){var n;(n=super.updateValue)==null||n.call(this,t,r),this.syncValue("value",t)}stepDown(t){this.adjustByKey(t,this.stepSmall)}stepUp(t){this.adjustByKey(t,"-"+this.stepSmall)}stepDownLarge(t){this.adjustByKey(t,this.stepLarge)}stepUpLarge(t){this.adjustByKey(t,"-"+this.stepLarge)}adjustByKey(t,r){var n,s;const a=this,{_isUserAction:o}=a,{target:l}=t,d=[a.fieldStartDate,a.fieldEndDate],c=(l===d[0].input&&1||l===d[1].input&&2||0)-1,u=d[c],h=[d[0].value,d[1].value],f=h[0]==null||h[1]==null;h[c]=S.add((n=h[c])!=null?n:a.defaultDate(c,h),r),h[1-c]=(s=h[1-c])!=null?s:h[c],h[1]<h[0]&&(h[1-c]=h[c]),a.checkValid(h)&&(a._isUserAction=!0,f?a.value=h:(d[0].value=h[0],d[1].value=h[1]),a._isUserAction=o),u.selectAll(),t.preventDefault()}checkMinMax(t=this.value){const{maxDate:r,minDate:n,validateDateOnly:s}=this;let a=0,o,l;if(t&&(n||r)){l=Array.isArray(t)?t:[t];for(o of l)if(o=s?S.clearTime(o):o,a=n&&o<n?-1:r&&o>r?1:0,a)break}return a}checkValid(t=this.value){return!this.checkMinMax(t)}defaultDate(t,r){const{minDate:n,maxDate:s}=this,a=S.clearTime(new Date);return a<n||a>s?n:a}hasChanged(t,r){return!T.isEqual(t,r)}onDateFieldChange({source:t,userAction:r}){const n=this,{fieldEndDate:s,fieldStartDate:a,_isUserAction:o}=n;n._isUserAction=r||o,n.syncValue(t.ref,[a.value,s.value]),n._isUserAction=o}onStartDateFocusIn(){this.pickingStartDate=!0}onStartDateFocusOut(t){this.pickingStartDate=!1}syncValue(t,r=this.value){const n=this;t!=="fieldEndDate"&&(n.fieldEndDate.value=r&&r[1]),t!=="fieldStartDate"&&(n.fieldStartDate.value=r&&r[0]),t!=="value"&&(n.value=r),!n.isConstructing&&n.hasChanged(n._lastValue,r)&&n.checkValid(r)&&n.triggerChange(),n._lastValue=r}get widgetClass(){}},p(e,"configurable",{altFormats:["YYYY-MM-DD"],dateFieldDefaults:{type:"datefield",autoSelect:!0,picker:null,step:"1d",internalListeners:{change:"up.onDateFieldChange"},triggers:{expand:null,back:{align:"end",weight:101}}},fieldEndDate:{ref:"fieldEndDate",cls:"b-end-date",weight:40},fieldStartDate:{ref:"fieldStartDate",cls:"b-start-date",weight:30,internalListeners:{focusIn:"up.onStartDateFocusIn",focusOut:"up.onStartDateFocusOut"}},dateStepTriggers:null,format:"ddd, MMM D",keyMap:{ArrowDown:"stepDown",ArrowUp:"stepUp","Ctrl+ArrowDown":"stepDownLarge","Ctrl+ArrowUp":"stepUpLarge"},pickingStartDate:null,stepLarge:"1 month",stepSmall:"7 days",validateDateOnly:!0,value:{$config:{type:"date[]",formats:["format","altFormats"]}}}),p(e,"fenced",{syncValue:!0}),p(e,"prototypeProperties",{_lastValue:null}),e},{isArray:rT}=Array,nT=i=>i.getFullYear()*12+i.getMonth(),a1=/material/i,$n=class extends Ur.mixin(Go){get datePickers(){return this.items.filter(i=>i.isDatePicker)}compose(){var i;const{navButtons:e}=this,t=e===!0?a1.test(((i=E.getThemeInfo())==null?void 0:i.name)||"")?"floating":"inline":e;return{class:{"b-multidatepicker-nav-buttons":e,[`b-multidatepicker-nav-${t}`]:e}}}onInternalPaint(i){if(i.firstPaint){const e=this,{date:t}=e;t&&e.unanimated(()=>{e.scrollPos=e.posFromIndex(e.indexFromDate(t))})}super.onInternalPaint(i)}applyDate(i,e,t){const r=this,n=e==null?void 0:e.containsFocus,{_isUserAction:s}=r;let{selection:a}=r,o=n?t:e;!a||n&&i>=a[1]?(o=t,a=[i,i]):n?a=[i,a[1]||i]:i<a[0]?(o=t,a=[i,a[1]||i]):a=[a[0]||i,i],o==null||o.focus(),r._isUserAction=!0,r.selection=a,r._isUserAction=s}changeIncludeYear(i){return typeof i=="number"&&(i=[i]),rT(i)?e=>i.includes(e.getMonth()+1):i}configureDatePicker(i,e,t){const{includeYear:r}=e,n=S.add(e.baseDate,i,"month");let s={date:n,activeDate:null,includeYear:r(n),multiSelect:e.multiSelect,selection:e.selection,weekStartDay:e.weekStartDay};return t||(s=Ni.mergeConfigs(e.datePickerDefaults,s,{cellRenderer:e.cellRenderer,headerRenderer:e.headerRenderer,weekRenderer:e.weekRenderer})),s}ensurePlan(i){return S.isDate(i)&&(i={date:i}),i.date&&(i={...i,index:this.indexFromDate(i.date)},delete i.date),i}getCell(i){return typeof i!="string"&&(i=S.makeKey(i)),this.element.querySelector(`[data-date="${i}"]:not(.b-other-month)`)}indexFromDate(i){return i&&nT(i)-nT(this.baseDate)}onDatePickerSelectionChange({selection:i,userAction:e}){if(e){const t=this,{_isUserAction:r}=t;t._isUserAction=!0,t.syncSelection("picker",i),t._isUserAction=r}}onNextMonthClick(){this.forward()}onPrevMonthClick(){this.backward()}onYearPickedMulti({source:i,value:e}){const t=this,r=i.up("datepicker"),{focusableElement:n}=r;n==null||n.focus({preventScroll:!0}),i.hide(),e-=r.activeDate.getFullYear(),t.go(e*12)}updateAtMax(i,e){const{nextButton:t,prevButton:r}=this.widgetMap;super.updateAtMax(i,e),t&&(t.containsFocus&&(r==null||r.focus()),t.isTabbable=!i,t.hidden=i)}updateAtMin(i,e){const{nextButton:t,prevButton:r}=this.widgetMap;super.updateAtMin(i,e),r&&(r.containsFocus&&(t==null||t.focus()),r.isTabbable=!i,r.hidden=i)}changeDate(i){return i&&S.clamp(i,this.minDate,this.maxDate)}updateDate(i){i!=null&&(this.currentIndex=this.indexFromDate(i))}updateMaxDate(){this.syncDateRange()}updateMinDate(){this.syncDateRange()}syncDateRange(){this.range=[this.minDate,this.maxDate]}updateNavButtons(i){this.detachListeners("navButtons"),i===!0&&ce.ion({theme:()=>this.recompose(),name:"navButtons",thisObj:this})}changeRange(i,e){if(rT(i)){let[t,r]=i,n;S.isDate(t)&&(t=this.indexFromDate(t),n=!0),S.isDate(r)&&(r=this.indexFromDate(r),n=!0),n&&(i=[t,r])}return super.changeRange(i,e)}changeSelection(i,e){return i&&T.isEqual(i,e)&&(i=e),i}updateSelection(i){const e=this;e.syncSelection("selection",i),e.isConfiguring?i&&(e.date=i[0]):e.trigger("selectionChange",{selection:i,userAction:e._isUserAction})}syncSelection(i,e=this.selection){const{datePickers:t}=this;i!=="selection"&&(this.selection=e),i!=="picker"&&t.forEach(r=>r.selection=e)}};p($n,"$name","MultiDatePicker"),p($n,"type","multidatepicker"),p($n,"configurable",{configureSlot:"configureDatePicker",disableReserveSlots:"inert",slots:2,baseDate:{$config:"day",value:"today"},cellRenderer:null,headerRenderer:null,weekRenderer:null,weekStartDay:null,date:{$config:"day",value:"today"},minDate:{$config:"day"},maxDate:{$config:"day"},datePickerDefaults:{type:"datepicker",activeDate:null,animateTimeShift:!1,dayNameFormat:"d1",multiSelect:"range",trapFocus:!1,internalListeners:{selectionChange:"up.onDatePickerSelectionChange"},tbar:{items:{prevMonth:{onAction:"up.onPrevMonthClick"},nextMonth:{onAction:"up.onNextMonthClick"},fields:{items:{monthField:{disabled:!0},yearButton:{disabled:!0}}}}},yearPicker:{internalListeners:{select:"up.onYearPickedMulti"}}},includeYear:i=>!i.getMonth(),items:{prevButton:{type:"button",positionable:"before",cls:"b-multidatepicker-nav-button b-multidatepicker-prev-button b-icon b-icon-previous",onAction:"up.onPrevMonthClick",hideMode:"opacity"},nextButton:{type:"button",positionable:"after",cls:"b-multidatepicker-nav-button b-multidatepicker-next-button b-icon b-icon-next",onAction:"up.onNextMonthClick",hideMode:"opacity"}},multiSelect:null,navButtons:!0,selection:{$config:"day[]"}}),p($n,"fenced",{syncSelection:!0}),$n.initClass(),$n._$name="MultiDatePicker";var rl=class extends $n.mixin(Qb){get dateFieldContainer(){return this.tbar}changeConfirmable(i){return this.bbar=i,this.bbar}updateConfirmable(i){this.detachListeners("confirmable"),i==null||i.ion({name:"confirmable",thisObj:this,choice:"doConfirm"})}get isValid(){return this.checkValid()}configureDatePicker(i,e,t){const r=super.configureDatePicker(i,e,t);return r.selection=this.selection,r}onDatePickerBeforeDateSelect({date:i}){return this.applyDate(i,this.fieldStartDate,this.fieldEndDate),!1}doConfirm({choice:i,event:e,userAction:t}){this.trigger("confirm",{choice:i,event:e,userAction:t})}internalOnKeyDown(i){const{confirmable:e}=this;let t=e==null?void 0:e.hotKeys[i.virtualKey];t?(t==="default"&&(t=e.defaultButton),t&&this.doConfirm({event:i,choice:{[t]:!0,name:t}})):super.internalOnKeyDown(i)}syncSelection(i,e=this.selection){super.syncSelection(i,e),i!=="value"&&this.syncValue("selection",e)}syncValue(i,e=this.value){const t=this,r=(e==null?void 0:e[1])<(e==null?void 0:e[0]);let n;i==="fieldEndDate"?(n=2,r&&(e=[e[1],e[1]])):i==="fieldStartDate"&&(n=1,r&&(e=[e[0],e[0]])),n&&e&&!t.isConstructing&&t.ensureVisible(e[n-1]),i!=="selection"&&t.syncSelection("value",e),super.syncValue(i,e)}triggerChange(i,e=!!this._isUserAction){const{value:t,_lastValue:r,isValid:n}=this;this.triggerFieldChange({value:t,oldValue:r,event:i,userAction:e,valid:n})}};p(rl,"$name","DateRangePicker"),p(rl,"type","daterangepicker"),p(rl,"configurable",{confirmable:null,datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}},keyMap:{delegate:"confirmable"},multiSelect:"range",selection:["today","today"],stripDefaults:{bbar:{type:"confirmationbar"}},tbar:{items:{spacer:{type:"widget",flex:1,weight:0}}}}),rl.initClass(),rl._$name="DateRangePicker";var o1=new Date,ca=class extends sa.mixin(Qb){get dateFieldContainer(){return this.container}get innerElements(){return[]}get maxDate(){return this.max}get minDate(){return this.min}compose(){const{pickTime:i}=this;return{class:{"b-pick-time":!!i}}}updateClearable(i){const{fieldEndDate:e}=this;e.clearable=i,i&&(e.triggers.clear.handler=()=>this.clear())}updateConfirmable(){this.isConstructing||(this.picker=this._pickerConfig)}changeEndTimeField(i,e){return oi.reconfigure(e,i,{owner:this,defaults:oi.mergeConfigs(this.timeFieldDefaults,this.fieldEndTimeDefaults)})}updateEndTimeField(i){i&&this.container.add(i)}changeStartTimeField(i,e){return oi.reconfigure(e,i,{owner:this,defaults:oi.mergeConfigs(this.timeFieldDefaults,this.fieldStartTimeDefaults)})}updateStartTimeField(i){i&&this.container.add(i)}updateKeepTime(i){i=!this.pickTime&&i,this.fieldEndDate.keepTime=i,this.fieldStartDate.keepTime=i}updateMax(i){const{fieldEndDate:e,fieldStartDate:t,_picker:r}=this;e.max=i,t.max=i,r&&(r.maxDate=i),this.syncInvalid()}updateMin(i){const{fieldEndDate:e,fieldStartDate:t,_picker:r}=this;e.min=i,t.min=i,r&&(r.minDate=i),this.syncInvalid()}changePicker(i,e){const t=this,{confirmable:r,pickerAlignElement:n}=t,s=r?t.confirmableDefaults:t.nonConfirmableDefaults,a=z.resolveType(s.type),o=a.mergeConfigs({owner:t,forElement:n,minDate:t.min,maxDate:t.max,selection:t.value,weekStartDay:t._weekStartDay,align:{anchor:t.overlayAnchor,target:n}},s,r&&{confirmable:r});return t._pickerConfig=i,T.isObject(i)&&(i=T.merge({type:o.type},i)),a.reconfigure(e,i,{owner:t,defaults:o})}updatePicker(i,e){super.updatePicker(i,e),this.detachListeners("dateRangeField.picker"),i==null||i.ion({name:"dateRangeField.picker",thisObj:this,selectionChange:"onPickerSelectionChange",confirm:"onPickerConfirm",focusIn:"onPickerFocusIn"})}updatePickerCls(i,e){var t,r;const n=(r=(t=this.picker)==null?void 0:t.element)==null?void 0:r.classList;e&&(n==null||n.remove(e)),i&&(n==null||n.add(i))}updatePickTime(i){let e=null,t=null;i===!0?e=t={}:i&&(i.fieldStartTime||i.fieldEndTime?(t=i.fieldStartTime,e=i.fieldEndTime):t=e=i),this.fieldEndTime=e,this.fieldStartTime=t}changeValue(i){const e=this,t=e.L("L{DateField.invalidDate}")(S.format(o1,e.format));if(i&&!(S.isDate(i[0])&&S.isDate(i[1]))){e.setError(t);return}return e.clearError(t),i}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:S.weekStartDay}updateWeekStartDay(i){this._picker&&(this._picker.weekStartDay=i)}maybeHidePicker(){if(!this.picker.isVisible||this.confirmable)return!1;this.hidePicker()}onDatePickerBeforeDateSelect({date:i}){return this.picker.applyDate(i,this.fieldStartDate,this.fieldEndDate),!1}onDateFieldChange({source:i}){const e=this,{ref:t}=i,r=t==="fieldStartDate"?0:1,{pickTime:n}=e;let s,a,o,l,d;e.isConstructing||(s=i.value,a=1-r,l=e.value,s&&(n?(o=r?e.fieldStartTime:e.fieldEndTime,s=S.combineDateAndTime(s,o.value)):s=S.clearTime(s),d=[s,s],l&&(d[a]=l[a],d[1]<d[0]&&(d[a]=S.combineDateAndTime(s,d[a]),d[1]<d[0]&&(d[a]=s))),e.syncValue(t,d)))}onKeyArrowUp(i){const e=this,{picker:t}=e;if(t.isVisible)return e.confirmable?!1:e.stepUp(i);e.showPicker()}onKeyClear(){this.clearable&&this.clear()}onKeyEnter(){this.maybeHidePicker()}onKeyEscape(){this.maybeHidePicker()}onExpandPicker(){this.confirmable?this.showPicker():this.togglePicker()}onPickerSelectionChange({selection:i,userAction:e}){if(!this.confirmable){const t=this,{_isUserAction:r}=t;t._isUserAction=e||r,t.syncValue("picker",i),t._isUserAction=r}}onPickerConfirm({choice:i,source:e,userAction:t}){const r=this,{_isUserAction:n}=r,s=e.containsFocus&&(e.pickingStartDate?r.fieldStartDate:r.fieldEndDate);i.ok&&(r._isUserAction=t||n,r.syncValue("picker",e.value),r._isUserAction=n),r.hidePicker(),s==null||s.focus()}onPickerFocusIn({relatedTarget:i}){const{fieldEndDate:e,fieldStartDate:t}=this.container.widgetMap,r=i===t?t:e;!this.confirmable&&r.focus()}onTriggerKeyDown(i){return this.picker.isVisible&&!this.confirmable?this.stepDown(i):super.onTriggerKeyDown(i)}focusPicker(){const{picker:i}=this,{fieldEndDate:e,fieldStartDate:t}=this.container.widgetMap,{tbar:r}=i,{fieldEndDate:n,fieldStartDate:s}=(r==null?void 0:r.widgetMap)||{},a=r?e.containsFocus&&n||s:e.containsFocus&&e||t;a.focus(),a!==i&&(i.ensureVisible({animate:!1,date:a.value}),a.selectAll())}showPicker(i){const e=this,{_picker:t}=e;e.readOnly||(t&&t.setConfig({range:[e.min,e.max],selection:e.value}),i=i||!!e.confirmable,super.showPicker(i))}get isValid(){const i=this,e=i.checkMinMax();return i.clearError("L{Field.minimumValueViolation}",!0),i.clearError("L{Field.maximumValueViolation}",!0),e?(i.setError(e<0?"L{Field.minimumValueViolation}":"L{Field.maximumValueViolation}",!0),!1):super.isValid}setupLabel(i){return super.setupLabel(T.assign({for:this.fieldStartDate.input.id},i))}syncInputFieldValue(){}syncValue(i,e=this.value){const t=this,{_picker:r}=t,n=(e==null?void 0:e[1])<(e==null?void 0:e[0]);if(r!=null&&r.isVisible&&!t.confirmable){let s;i==="fieldEndDate"?(s=2,n&&(e=[e[1],e[1]])):i==="fieldStartDate"&&(s=1,n&&(e=[e[0],e[0]])),s&&e&&!t.isConstructing&&r.ensureVisible(e[s-1])}i!=="picker"&&r&&(r.selection=e),super.syncValue(i,e)}};p(ca,"$name","DateRangeField"),p(ca,"type","daterangefield"),p(ca,"alias","daterange"),p(ca,"configurable",{inline:!0,confirmable:null,container:{},confirmableDefaults:{type:"daterangepicker",navButtons:"floating",trapFocus:!0,align:{align:"t100-t100",offset:'[data-ref="fieldEndDate"]',overlap:!0},fieldStartDate:{triggers:{expand:{align:"start",disabled:!0}}}},fieldEndDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:null}},fieldEndTime:null,fieldEndTimeDefaults:{ref:"fieldEndTime",cls:"b-end-time",weight:20},fieldStartDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:{handler:"up.onExpandPicker",align:"start"}}},fieldStartTime:null,fieldStartTimeDefaults:{ref:"fieldStartTime",cls:"b-start-time",weight:10},keepTime:null,keyMap:{ArrowDown:"onTriggerKeyDown",ArrowUp:"onKeyArrowUp",Enter:"onKeyEnter",Escape:"onKeyEscape","Shift+Backspace":"onKeyClear"},max:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},min:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},nonConfirmableDefaults:{type:"multidatepicker",align:{align:"t100-r100"},datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}}},picker:{cls:"b-daterangefield-picker",floating:!0,hideMode:"clip",multiSelect:"range",scrollAction:"realign",align:{axisLock:!0}},pickerAlignElement:"container.element",pickerCls:null,pickTime:null,stepSmall:"7 days",timeFormat:"HH:mm:ss:SSS",triggers:{expand:null},weekStartDay:null,timeFieldDefaults:{type:"timefield",autoSelect:!0,picker:{align:{align:"b0-t0"}},triggers:{expand:null}}}),ca.initClass(),ca._$name="DateRangeField";var sT=new Date(2e3,0,1),ua=class extends ut{doDestroy(){this.dateField.destroy(),this.timeField.destroy(),super.doDestroy()}get childItems(){return[this.dateField,this.timeField]}get fieldDefaults(){const{revertOnEscape:i,tabIndex:e}=this;return e==null?{revertOnEscape:i}:{revertOnEscape:i,tabIndex:e}}get focusElement(){return this.dateField.input}get innerElements(){return[this.dateField.element,this.timeField.element]}internalOnKeyEvent(){}updateRevertOnEscape(i){this.timeField.revertOnEscape=i,this.dateField.revertOnEscape=i}changeTimeField(i,e){return oi.reconfigure(e,i,{owner:this,defaults:this.fieldDefaults})}updateTimeField(i){const e=this;j.on({element:i.element,keydown:"onTimeFieldKeyDown",thisObj:e}),we.after(i,"syncInvalid",()=>{e.timeField&&!e.updatingInvalid&&e.syncInvalid()}),i.ion({thisObj:e,change({userAction:t,value:r}){if(t&&!e.$settingValue){const n=e.dateField.value;e._isUserAction=!0,e.value=n?S.copyTimeValues(new Date(n),r||sT):null,e._isUserAction=!1}}}),e.readOnly&&(i.readOnly=!0)}changeDateField(i,e){return At.reconfigure(e,i,{owner:this,defaults:this.fieldDefaults})}updateDateField(i){const e=this;j.on({element:i.element,keydown:"onDateFieldKeyDown",thisObj:e}),we.after(i,"syncInvalid",()=>{e.dateField&&!e.updatingInvalid&&e.syncInvalid()}),i.ion({thisObj:e,change({userAction:t,value:r}){t&&!e.$isInternalChange&&(e._isUserAction=!0,e.timeField.value=r,e.value=r,e._isUserAction=!1)},keydown({event:t}){var r;t.key==="Tab"&&!t.shiftKey&&((r=e.timeField)!=null&&r.isVisible)&&t.stopPropagation()}}),e.readOnly&&(i.readOnly=!0)}updateWeekStartDay(i){this.dateField&&(this.dateField.weekStartDay=i)}changeWeekStartDay(i){var e,t;return typeof i=="number"?i:(t=(e=this.dateField)==null?void 0:e.weekStartDay)!=null?t:S.weekStartDay}syncInputFieldValue(i=this.isConfiguring){super.syncInputFieldValue(!0);const e=this,{dateField:t,timeField:r}=e,n=t.highlightExternalChange,s=r.highlightExternalChange;!i&&!e.highlightExternalChange&&(i=!0),e.$isInternalChange=!0,t.highlightExternalChange=!1,t.highlightExternalChange=n,i&&(r.highlightExternalChange=t.highlightExternalChange=!1),r.value=t.value=e.inputValue,t.highlightExternalChange=n,r.highlightExternalChange=s,e.$isInternalChange=!1,e.syncInvalid()}onTimeFieldKeyDown(i){const e=this;if(!e.readOnly&&(i.key==="Enter"||i.key==="Tab")){const t=e.dateField.value;e._isUserAction=!0,e.value=t?S.copyTimeValues(new Date(t),e.timeField.value||sT):null,e._isUserAction=!1}}onDateFieldKeyDown(i){const e=this;i.key==="Tab"&&!i.shiftKey?(i.stopPropagation(),i.preventDefault(),e.timeField.focus()):!e.readOnly&&i.key==="Enter"&&(e.value=e.dateField.value)}updateRequired(i){super.updateRequired(i),this.timeField.required=this.dateField.required=i}updateReadOnly(i,e){super.updateReadOnly(i,e),this.isConfiguring||(this.timeField.readOnly=this.dateField.readOnly=i)}onDisabled(i){this.timeField.disabled=this.dateField.disabled=i}focus(){this.dateField.focus()}hasChanged(i,e){var t,r;return i!=null&&i.getTime&&(e!=null&&e.getTime)?!S.isEqual(i,e):super.hasChanged((t=i==null?void 0:i.getTime)==null?void 0:t.call(i),(r=e==null?void 0:e.getTime)==null?void 0:r.call(e))}get isValid(){return this.timeField.isValid&&this.dateField.isValid}setError(i,e){[this.dateField,this.timeField].forEach(t=>t.setError(i,e))}getErrors(){const i=[...this.dateField.getErrors()||[],...this.timeField.getErrors()||[]];return i.length?i:null}clearError(i,e){[this.dateField,this.timeField].forEach(t=>t.clearError(i,e))}updateInvalid(){this.updatingInvalid=!0,this.dateField.updateInvalid(),this.timeField.updateInvalid(),this.updatingInvalid=!1}};p(ua,"$name","DateTimeField"),p(ua,"type","datetimefield"),p(ua,"alias","datetime"),p(ua,"configurable",{timeField:{type:"timefield"},dateField:{type:"datefield",keepTime:!0,step:"1 d"},weekStartDay:null,inputTemplate:()=>"",ariaElement:"element"}),ua.initClass(),ua._$name="DateTimeField";var{dockIsHorz:l1}=jr.maps,d1={top:0,down:0,left:1,bottom:2,up:2,right:3},Jb={up:{from:"translate(0,0)",to:"translate(0,-100%)"},down:{from:"translate(0,0)",to:"translate(0,100%)"},left:{from:"translate(0,0)",to:"translate(-100%,0)"},right:{from:"translate(0,0)",to:"translate(100%,0)"}},nl=class extends jr.mixin(be){static get configurable(){return{autoCloseDelay:1e3,autoClose:!0,revealing:{value:null,$config:null,default:!1},recollapseTool:{type:"collapsetool",cls:"b-recollapse",collapsify:"overlay",handler(){var i;(i=this.collapsible)==null||i.toggleReveal()}}}}static get delayable(){return{doAutoClose:0}}doAutoClose(){this.toggleReveal(!1)}updateAutoCloseDelay(i){const{doAutoClose:e}=this;(e.suspended=i==null||i<0)||(e.delay=i,e.immediate=!i)}changeRecollapseTool(i){const e=this,{panel:t}=e;if(e.isConfiguring||e.isDestroying||!t||t.isDestroying)return i;t.tools={recollapse:i}}beforeCollapse(i){if(super.beforeCollapse(i)===!1)return!1;this.panel.revealed&&(i.animation=null)}applyHeaderDock(i,e=!0){var t;(t=this.panel)==null||t.recompose(),super.applyHeaderDock(i,e)}collapseBegin(i){const e=this,{collapseDir:t,innerElement:r}=e,{animation:n}=i,{collapseTool:s,panel:a}=e;e.configuredWidth=a._lastWidth,e.configuredHeight=a._lastHeight,e.applyHeaderDock(!0),e.lockInnerSize(),s==null||s.element.classList.add("b-collapsed"),n&&(a.element.classList.add("b-collapsing"),n.element=r,n.transform=Jb[t],i.animation=$t.run(n))}onComplete(i){var e,t;super.onComplete(i);const r=this,{panel:n}=r,{element:s}=n;r.autoCloseLeaveDetacher=(e=r.autoCloseLeaveDetacher)==null?void 0:e.call(r),r.autoCloseClickDetacher=(t=r.autoCloseClickDetacher)==null?void 0:t.call(r),r.doAutoClose.cancel(),i==="reveal"&&r.autoClose&&(n.containsFocus&&(r.autoCloseLeaveDetacher=j.on({element:s,mouseenter:a=>{r.doAutoClose.cancel()},mouseleave:a=>{r.doAutoClose()}})),r.autoCloseClickDetacher=j.on({element:document.body,thisObj:n,mousedown:a=>{var o;!n.owns(a)&&!((o=r.revealer)!=null&&o.contains(a.target))&&r.autoCloseDelay!=null&&r.doAutoClose.now()}})),!r.hasPainted&&i==="collapse"&&r.innerElement.offsetHeight}expandBegin(i){const e=this,{animation:t}=i,{collapseDir:r,collapseTool:n,innerElement:s,panel:a}=e,{element:o}=a;o.classList.remove("b-collapsed","b-collapsing"),e.restoreConfiguredSize(),e.lockInnerSize(!1),e.lockInnerSize(),n==null||n.element.classList.remove("b-collapsed"),t&&(o.classList.add("b-collapsed","b-expanding"),t.element=s,t.transform={from:Jb[r].to,to:Jb[r].from},i.animation=$t.run(t))}expandEnd(i){super.expandEnd(i);const{panel:e}=this;i.completed&&(e.revealed=!1),e.element.classList.remove("b-expanding")}expandRevert(i){super.expandRevert(i),this.panel.element.classList.add("b-expanding")}get innerElement(){return this.panel.overlayElement}get innerSizeElement(){return this.panel.element}get toolsConfig(){const i=this,{direction:e}=i,t=super.toolsConfig,r=i.recollapseTool;return r?{...t,recollapse:r&&T.assign({direction:e.toLowerCase()},r)}:t}lockInnerSize(i=!0){const e=this,{panel:t}=e,r=i&&t.rectangle(),n=i?[0,0,0,0]:"",s=super.lockInnerSize(i);return i&&(n[d1[e.collapseDir]]=`-${r[e.collapseDim]+10}px`),t.element.style.clipPath=i?`inset(${n.join(" ")})`:"",s}onOverlayTransitionDone(i){const e=this,{panel:t}=e;i.srcElement===t.overlayElement&&e.revealing&&(e.revealing=!1,e.onComplete(t.revealed?"reveal":"unreveal"))}onRevealerClick(){this.toggleReveal()}toggleReveal(i){const{panel:e}=this,{element:t}=e;e.collapsed&&(this.revealer=E.getActiveElement(t),i==null&&(i=!e.revealed),e.revealed!==i&&e.trigger("beforeToggleReveal",{reveal:i})!==!1&&(!i&&t.matches(":focus-within")&&e.revertFocus(!0),this.revealing=!0,e.revealed=i,t.getBoundingClientRect()))}updateRevealing(i){const e=this,t=/left|right/i,{panel:r}=e,n=t.test(e.collapseDir)?"height":"width";r&&(e.innerElement.style[n]="0px",e.innerElement.style[`min-${n}`]="100%",r.element.classList[i?"add":"remove"]("b-panel-overlay-revealing"))}wrapCollapser(i,e){var t;const r=this,{collapseDir:n,panel:s}=r,{expandedHeaderDock:a,header:o,uiClassList:l}=s,d=(t=s.tools)==null?void 0:t.recollapse,[c,u]=r.splitHeaderItems({as:"element",dock:r.collapseDock}),h=l1[a],f=s.hasHeader?s.title||(o==null?void 0:o.title)||"\xA0":null;return d&&(d.direction=n),["overlayElement",{class:{...l,[`b-panel-overlay-header-${a}`]:1,[`b-panel-overlay-${n}`]:1,[`b-${h?"h":"v"}box`]:1,"b-panel-overlay":1,"b-box-center":1},listeners:{transitionend:g=>r.onOverlayTransitionDone(g),transitioncancel:g=>r.onOverlayTransitionDone(g)},children:{overlayHeaderElement:f&&{tag:"header",class:new le({...l,[`b-dock-${a}`]:1,"b-panel-header":1,"b-panel-overlay-header":1},o==null?void 0:o.cls),children:[...c,{reference:"overlayTitleElement",html:f,class:{...l,[`b-align-${(o==null?void 0:o.titleAlign)||"start"}`]:1,"b-header-title":1}},...u]},[i]:e}}]}};p(nl,"$name","PanelCollapserOverlay"),p(nl,"type","overlay"),nl.initClass(),nl._$name="PanelCollapserOverlay";var eC={lineNumber:0,column:0},aT={lineNumber:Number.MAX_SAFE_INTEGER,column:Number.MAX_SAFE_INTEGER},c1=Y.isBryntumOnline(["online"]),{pathname:Fm}=globalThis.location,Am=Fm.endsWith("umd.html"),oT=document.querySelector("script[type=module]"),Zu=Fm.endsWith("module.html")||(oT==null?void 0:oT.src.includes("app.module.js"))||(!Fm.includes(".html")||Fm.includes("index.html"))&&c1,Qu=class AD extends Yr{construct(e={}){super.construct(...arguments);const t=this,{rtl:r}=t;r&&(t.collapsible.direction="left"),new ra({targetSelector:".b-codeeditor",rightHandle:!!r,leftHandle:!r,skipTranslate:!0,minWidth:190})}static get isModule(){return Zu}get isVanilla(){return this.mode==="vanilla"}get isFramework(){return this.mode==="framework"}updateMode(){this.title='<span class="title-container"><span class="title">'+(this.isVanilla?"L{CodeEditor.editor}":"L{CodeEditor.viewer}")+"</span></span>"}onCloseClick(){this.collapse()}async onFilesComboChange({value:e}){await this.loadCode(e)}async collapseBoilerplate(e){const{monacoInstance:t,editor:r}=this,{Selection:n}=t,s=[],a=e.findMatches("^import .*$",!0,!0);let o,l=!0;["baselines","children","segments","intervals","events","tasks","resources","assignments","dependencies","timeRanges","resourceTimeRanges","rows"].forEach(u=>{const h=`${u}\\s*(?:=|:)\\s*\\[`;for(o=e.findForwards(h,eC,!0);o&&l;o=e.findForwards(h,l.range.getEndPosition(),!0))if(l=e.findForwards("\\](?:;|,)?\\s*$",o.range.getEndPosition(),!0),l){for(;l&&s.some(f=>f.containsRange(l.range));)l=e.findForwards("\\](?:;|,)?\\s*$",l.range.getEndPosition(),!0);l&&s.push(new n(o.range.startLineNumber,1,l.range.endLineNumber+1,1))}});let d,c=eC;for(;d=e.findForwards("^\\s*//\\s*hide",c,!0);){const u=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?hide",{lineNumber:d.range.endLineNumber,column:0},!0);u&&s.push(new n(d.range.startLineNumber,1,u.range.endLineNumber+1,1)),c=(u==null?void 0:u.range.getEndPosition())||aT}for(c=eC;d=e.findForwards("^\\s*//\\s*region",c,!0);){const u=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?region",{lineNumber:d.range.endLineNumber,column:0},!0);u&&s.push(new n(d.range.startLineNumber,1,u.range.endLineNumber+1,1)),c=(u==null?void 0:u.range.getEndPosition())||aT}a.length&&s.push(new n(1,1,a[a.length-1].range.startLineNumber+1,1));for(const u of s)r.setSelections([...r.getSelections(),u]),await r.getAction("editor.createFoldingRangeFromSelection").run()}set status(e){this.widgetMap.status.html=e}get isReadOnly(){const e=this;return e.isFramework||["html","scss","json"].includes(e.fileExt)||e.fileExt==="js"&&(e.hasImports||Am)}toggleReadOnly(){const e=this,{contentElement:t,isReadOnly:r}=e;t.classList.toggle("readonly",r),r?e.status="Read only"+(Y.isCSP?" (Restricted by Content Security Policy)":!Y.isChrome&&!Y.isFirefox?" (try it on Chrome or Firefox)":""):e.status="Idle",e.editor.updateOptions({readOnly:r})}async loadCode(e){e=`${this.appFolder}${e}`;const t=this,{isVanilla:r}=t;let n=t.codeCache[e],s=null;if(t.filename=e,!n)try{const l=Math.floor(new Date().getTime()/36e5),d=await Wt.get(`${location.href.replace(/[^/]*$/,"")}${e}?${l}`);n=t.codeCache[e]=await d.text()}catch(l){n="",s=l}t.loadedCode=n,t.fileExt=e.split(".").pop();let a="plaintext";switch(t.fileExt){case"js":case"mjs":case"jsx":a="javascript";break;case"ts":case"mts":case"tsx":case"vue":a="typescript";break;case"css":a="css";break;case"scss":a="scss";break;case"htm":case"html":a="html";break;case"json":a="json";break}t.language=a;const o=t.model=await t.loadText(n,a);o.findForwards=function(l,d){const c=o.findNextMatch(...arguments);if(c&&!c.range.getStartPosition().isBefore(d))return c},r&&t.fileExt==="js"&&await t.collapseBoilerplate(o),t.status=`${s?s.message:"Idle"}`,t.toggleReadOnly()}sortFileNamesWithHierarchy(e){const t=s=>{const a={};return s.forEach(o=>{const l=o.split("/");let d=a;l.forEach((c,u)=>{d[c]||(d[c]=u===l.length-1?null:{}),d=d[c]})}),a},r=s=>{const a={};return Object.keys(s).sort((l,d)=>{const c=s[l]!==null,u=s[d]!==null;return c&&!u?-1:!c&&u?1:l.localeCompare(d)}).forEach(l=>{a[l]=s[l]!==null?r(s[l]):s[l]}),a},n=(s,a="")=>{let o=[];return Object.keys(s).forEach(l=>{const d=`${a}${a!==""?"/":""}${l}`;s[l]===null?o.push(d):o=o.concat(n(s[l],d))}),o};return n(r(t(e)))}async initialLoadCode(){var e;const t=this,{widgetMap:r,preferredSources:n}=t,{filesCombo:s}=r,a=s.store,o=`${t.appFolder}app.config.json`,l=(await Wt.get(o,{parseJson:!0})).parsedJson,d=[],c=Y.isBryntumOnline("online"),u=l.source||[];if(t.isVanilla){const f=(e=l.index)==null?void 0:e.bundles,g=f&&!(f!=null&&f.includes("module"));d.push(...u.flatMap(m=>{if(m==="index.html")return Zu&&!c&&!g?"index.module.html":Am?"index.umd.html":"index.html";if(m==="app.js")return(Zu||c)&&!g?"app.module.js":Am?"app.umd.js":"app.js";if(m.endsWith(".scss"))return[m,m.replace(/\.scss$/,".css")];if(!((Zu||c)&&m.startsWith("lib/")))return m}).filter(Boolean)),!Zu&&!Am&&(t.hasImports=d.some(m=>["lib/","locales/"].some(v=>m.startsWith(v))))}else u.length?d.push(...l.source):console.warn(`No source files loaded from ${o}`);s.items=t.sortFileNamesWithHierarchy(d).map(f=>({text:f,value:f}));const h=(n||[]).map(f=>a.find(g=>f.test(g.value))).find(Boolean)||a.first;s.value=h.value,await t.loadCode(h.value),s.onChange="up.onFilesComboChange",t.toggleReadOnly(),s.readOnly=a.count===1}static get monacoCodePath(){const e=/(.*?\/)examples/.exec(document.location.href);return e?`${e[1]}examples/_shared/browser/lib/monaco-editor`:void 0}static async toggleCodeEditor(e,t,r){return!e&&(e=new AD({mode:"framework",appendTo:document.body,codePath:AD.monacoCodePath,appFolder:"../",...r}),z.disableThrow=!0,t.icon="b-icon-spinner",await e.initialLoadCode(),t.icon="b-icon-code"),e.collapsed?(await e.expandPanel(),e.focus()):await e.collapsePanel(),e}};p(Qu,"$name","DemoCodeEditor"),p(Qu,"type","democodeeditor"),p(Qu,"configurable",{mode:"vanilla",appFolder:"",collapsible:{type:nl.type,direction:"right",autoClose:!1},collapsed:!0,preferredSources:null,monitorResize:!1,editor:{lineNumbers:"off",foldingImportsByDefault:!0,minimap:{enabled:!1},ariaLabel:"Live code editor"},tbar:{overflow:null,items:{filesCombo:{type:Ye.type,flex:"1 1 100%",monitorResize:!1,editable:!1,fields:[{name:"text"}],listItemTpl:({text:i})=>{const e=i.split(".").pop();let t="b-fa-file";switch(e){case"js":case"mjs":case"jsx":case"ts":case"mts":case"tsx":case"vue":t="b-fa-file-lines";break;case"css":case"scss":t="b-fa-palette";break;case"htm":case"html":case"json":t="b-fa-file-code";break}const r=i.lastIndexOf("/")+1,n=i.substring(0,r),s=i.substring(r);return`<span class="b-editor-file-type b-fw-icon ${t}" ></span> <span class="b-editor-folder">${n}</span>${s}`},picker:{maxHeight:"calc(100vh * 3 / 4)"}}}},codeCache:{}}),p(Qu,"loadMonacoEditor",async i=>{if(!Yr.monacoLoadPromise){const e=E.createElement({tag:"script",parent:document.head,src:`${i}monaco-editor/min/vs/loader.js`});await new Promise(t=>e.addEventListener("load",t)),await(Yr.monacoLoadPromise=new Promise(t=>{const r=globalThis.require;r.config({paths:{vs:`${i}monaco-editor/min/vs`}}),r(["vs/editor/editor.main"],function(){t(globalThis.monaco)})}))}});var Pm=Qu;Pm.initClass(),Pm._$name="DemoCodeEditor";var lT,dT,cT,Ju=class extends ct{construct(...e){super.construct(...e),this.setupToolbar()}static get titleLink(){const e=/(.*?\/)(examples.*?\/frameworks\/.*?)\/(build|out|dist)/.exec(document.location.href);return e?`${e[1]}examples/#example-${e[2].replace(/\//gm,"-").replace("examples-frameworks","frameworks")}`:"#"}async toggleCodeEditor(){this.codeEditor=await Pm.toggleCodeEditor(this.codeEditor,this.widgetMap.tools.widgetMap.codeButton,{appFolder:this.appFolder,preferredSources:[/App\.[jt]sx?/,/\w+Config\.[jt]sx?/,/index\.[jt]sx?/]})}async setupToolbar(){var e,t;const{location:r}=document,n=r.search.includes("test");if(r.href.match(/examples\/frameworks/)||n){const a=((e=r.href.match(/\/(\w+)(-trial)?\/[-\w]*examples\//))==null?void 0:e[1].toLowerCase())||"grid",{widgetMap:o}=this.widgetMap.tools,{downloadButton:l,trialButton:d}=o;Object.values(o).forEach(u=>u.hidden=!1),d.href=`https://bryntum.com/download/?product=${a}`;const c=(t=await Wt.get(`${this.appFolder}/app.config.json`,{parseJson:!0}).catch(()=>{}))==null?void 0:t.parsedJson;c!=null&&c.zip||n?l.href=`${this.appFolder}${c.zip}`:l.hidden=!0,Ys.insertRule("body { flex-direction : row !important }"),Ys.insertRule("#container { flex: 1 !important; overflow : hidden !important }")}}};p(Ju,"$name","DemoHeader"),p(Ju,"type","demoheader"),p(Ju,"configurable",{insertFirst:"container",appFolder:"../",cls:"demo-header",items:[{type:"container",id:"title-container",items:[{type:"container",tag:"a",id:"title",elementAttributes:{href:Ju.titleLink},items:[{html:((lT=document.title)!=null?lT:"Demo").split("-").pop().trim(),tag:"h1",tooltip:(cT=(dT=document.querySelector('meta[name="description"]'))==null?void 0:dT.content)!=null?cT:""}]}]},{type:ta.type,id:"tools",style:{border:"none",height:"2.8em"},defaults:{style:{margin:0},cls:"b-raised b-blue"},items:["->",{ref:"trialButton",type:"button",text:"Download Trial",cls:"b-green b-raised",href:"#",hidden:!0},{ref:"codeButton",type:"button",tooltip:"Click to show the code viewer",icon:"b-icon-code",onClick:"up.toggleCodeEditor",hidden:!0},{ref:"downloadButton",type:"button",tooltip:"Download this demo zip archive",icon:"b-icon-download",href:"#",hidden:!0},{ref:"fullscreenButton",type:"button",tooltip:"Full screen",icon:"b-icon-fullscreen",onClick(){qt.enabled&&(qt.isFullscreen?qt.exit():qt.request(document.body))}}]}]});var uT=Ju;uT._$name="DemoHeader";var Bn=class extends zi{changeMin(i){return typeof i=="string"?new Le(i):i}changeMax(i){return typeof i=="string"?new Le(i):i}changeAllowedUnits(i){return typeof i=="string"&&(i=i.split(",")),i.length>0&&!i.includes(this.defaultUnit)&&(this.defaultUnit=i[0]),i}updateAllowedUnits(i){this.allowedUnitsRe=new RegExp(`^(${i.join("|")})$`,"i")}get inputValue(){return this.value==null?"":this.calcValue(!0).toString(this.useAbbreviation,this.decimalPrecision)}updateUnit(){this.clearError("L{invalidUnit}"),super.value=this.calcValue()}updateMagnitude(){this.clearError("L{invalidUnit}"),super.value=this.calcValue()}get unitWithDefault(){return this.unit||this.defaultUnit}roundMagnitude(i){return i&&this.decimalPrecision!=null?T.round(i,this.decimalPrecision):i}get allowDecimals(){return this.decimalPrecision!==0}get isValid(){const i=this,e=i.input.value,t=S.parseDuration(e,i.allowDecimals,e.match(/[\p{Letter}\p{Mark}]+/gui)?void 0:i.unitWithDefault),r=!e||t&&t.magnitude==null;return i.skipValidation||super.isValid&&(r&&!i.required||!r&&(i.allowNegative||(t==null?void 0:t.magnitude)>=0))}internalOnChange(i){const e=this,t=e.value,r=e._lastValue;e.hasChanged(r,t)&&(e._lastValue=t,e.triggerFieldChange({value:t,event:i,userAction:!0,valid:e.isValid}))}onFocusOut(i){var e,t,r;return this.syncInputFieldValue(!0),(r=(t=(e=this.triggers)==null?void 0:e.spin)==null?void 0:t.clickRepeater)==null||r.cancel(),super.onFocusOut(i)}set value(i){const e=this;let t,r;if(e.getConfig("allowedUnits"),e.clearError("L{invalidUnit}"),typeof i=="number"||typeof i=="string"&&i.length>0&&!isNaN(i))t=Number(i),r=e.unitWithDefault;else if(typeof i=="string")if(/^\s*$/.test(i))t=null;else{const n=S.parseDuration(i,e.allowDecimals,e.unitWithDefault);n&&(!e.allowedUnitsRe||e.allowedUnitsRe.test(n.unit)?(r=n.unit,t=n.magnitude):e.setError("L{invalidUnit}"))}else i&&"unit"in i&&"magnitude"in i?(r=i.unit,t=i.magnitude):(r=null,t=null);(e.magnitude!==t||e.unit!=r)&&(e._magnitude=t,r&&(e.unit=r),super.value=e.calcValue())}okMax(i){return typeof i=="number"&&(i=new Le({unit:this.unitWithDefault,magnitude:i})),this.max==null||i<=this.max}okMin(i){return typeof i=="number"&&(i=new Le({unit:this.unitWithDefault,magnitude:i})),this.min==null||i>=this.min}get validity(){const i=this.value,e={};return i!=null&&(e.rangeUnderflow=!this.okMin(i),e.rangeOverflow=!this.okMax(i)),e.valid=!e.rangeUnderflow&&!e.rangeOverflow,e}get value(){return super.value}calcValue(i=!1){const e=this,{magnitude:t}=e;return(!e.unit||t==null)&&e.clearable?null:new Le(i?e.roundMagnitude(t):t,e.unitWithDefault)}hasChanged(i,e){return e&&!i||!e&&i||e&&i&&!(i.unit===e.unit&&i.isEqual(e))}get milliseconds(){return this.value?this.value.milliseconds:0}onInternalKeyDown(i){const e=this,{_isUserAction:t}=e;e._isUserAction=!0,i.key==="ArrowUp"?e.doSpinUp():i.key==="ArrowDown"&&e.doSpinDown(),e._isUserAction=t}doSpinUp(){const i=this;let{value:e}=i;if(i.readOnly)return;T.isEmpty(e)&&(e=new Le({magnitude:0,unit:this.defaultUnit}));let t=e.add(this._step);i.okMin(t)||(t=i.min),i.okMax(t)&&(i.value=t)}doSpinDown(){const i=this;let{value:e}=i;if(i.readOnly)return;T.isEmpty(e)&&(e=new Le({magnitude:0,unit:this.defaultUnit}));let t=e.add({magnitude:-this._step.magnitude,unit:this._step.unit});i.okMax(t)||(t=i.max),i.okMin(t)&&(i.allowNegative||(i.magnitude||0)>0)&&(i.value=t)}changeStep(i,e){const t=typeof i;return i?(t==="number"?i={magnitude:Math.abs(i),unit:void 0}:t==="string"&&(i=S.parseDuration(i)),i&&i.unit&&i.magnitude&&i.magnitude<0&&(i={magnitude:-i.magnitude,unit:i.unit}),i):null}updateStep(i){this.element.classList.toggle("b-no-steppers",!!i),this.syncInvalid()}};p(Bn,"$name","DurationField"),p(Bn,"type","durationfield"),p(Bn,"alias","duration"),p(Bn,"configurable",{value:null,defaultUnit:"day",useAbbreviation:!1,allowNegative:!1,decimalPrecision:null,triggers:{spin:{type:"spintrigger"}},nullValue:null,min:null,max:null,allowedUnits:null,step:1,unit:null,magnitude:null}),Bn.initClass(),Bn._$name="DurationField";var li=class extends ct{afterConfigure(){const i=this;super.afterConfigure(),i.onTargetSizeChange=i.onTargetSizeChange.bind(i),j.on({element:i.element,keydown:"onEditorKeyDown",contextmenu:"stopMouseEvents",mousedown:"stopMouseEvents",mouseover:"stopMouseEvents",mouseout:"stopMouseEvents",mouseup:"stopMouseEvents",click:"stopMouseEvents",dblclick:"stopMouseEvents",thisObj:i}),i.ion({beforeHide:"beforeEditorHide",hide:"afterEditorHide"}),ke.ion({locale:"onLocaleChange",thisObj:i})}onLocaleChange(){const{inputField:i}=this;i&&!i.isDestroyed&&(i.syncInputFieldValue?i.syncInputFieldValue(!0):i instanceof ut)}render(i){const e=this.element.parentNode,[t]=this.getRenderContext(this,i);t.classList.add("b-editing"),super.render(...arguments),e!=null&&e.classList&&t!==e&&e.classList.remove("b-editing")}async startEdit(i){var e,t,r;const n=this;if(i=T.assignIf(i,{align:n.align,hideTarget:n.hideTarget,matchSize:n.matchSize,matchFont:n.matchFont,fitTargetContent:n.fitTargetContent,focus:!0}),n.isVisible&&await n.completeEdit(),n.trigger("beforeStart",i)!==!1){const{target:s,hideTarget:a,matchSize:o,matchFont:l,fitTargetContent:d,record:c,field:u=n.inputField.name,focus:h}=i,{inputField:f,appendToTargetParent:g}=n,{input:m}=f,v=E.getStyleValue(s,"font-size"),y=E.getStyleValue(s,"font-family");let{value:b,align:C}=i;if(c&&u&&(n.record=c,n.dataField=u,f.assignFieldValue!==z.prototype.assignFieldValue?b=f.value:b===void 0&&(b=c.getValue(u))),g&&s.nodeType===Node.ELEMENT_NODE&&s.parentElement.appendChild(n.element),o&&(s instanceof HTMLElement&&n.updateSize(s,o),s instanceof HTMLElement&&it.addResizeListener(s,n.onTargetSizeChange)),m&&(l?(m.style.fontSize=v,m.style.fontFamily=y):m.style.fontSize=m.style.fontFamily=""),n.assigningValues=!0,(e=f.clearError)==null||e.call(f),"setValue"in f?await f.setValue(b):f.value=b,n.assigningValues=!1,typeof C=="string"&&(C={align:C}),await n.showBy({target:s,allowTargetOut:!0,...C}),d){const w=m.scrollWidth-m.clientWidth;w>0&&(n.width+=w+E.scrollBarWidth)}h&&((t=f.focus)==null||t.call(f)),s.nodeType===Element.ELEMENT_NODE&&a&&s.classList.add("b-hide-visibility"),n.editing=!0;const D=f.value;return n.trigger("start",{value:D}),Array.isArray(D)&&f.editingRecords&&((r=D[0])!=null&&r.isModel)?n.oldValue=D.map(w=>w.copy(w.id)):(n.oldValue=D,Array.isArray(n.oldValue)&&(n.oldValue=n.oldValue.slice())),f.initialValue=n.oldValue,!0}return!1}async refreshEdit(){if(this.isVisible){const{record:i,dataField:e,inputField:t,owner:r}=this;if(i&&((r!=null&&r.readOnly||i.readOnly)&&this.cancelEdit(),e)){const n=i.getValue(e);T.isEqual(t.value,n)||await t.setValue(n)}}}finishEdit(){const{target:i,aligningToElement:e}=this.lastAlignSpec;e&&(i.classList.remove("b-editing"),i.classList.remove("b-hide-visibility")),this.editing=!1,this.trigger("afterEdit",{record:this.record})}onEditorKeyDown(i){var e;const t=this;switch(i.key){case t.completeKey:{i.preventDefault(),i.stopImmediatePropagation(),t.completeEdit(null,i);break}case t.cancelKey:t.cancelEdit(i),i.stopImmediatePropagation();break}(e=t.trigger)==null||e.call(t,"keyDown",{event:i})}stopMouseEvents(i){this.allowMouseEvents||i.stopPropagation()}onFocusOut(i){super.onFocusOut(i);const e=this;if(!e.isFinishing&&e.editing)switch(e.blurAction){case"cancel":e.cancelEdit(i);break;case"complete":e.completeEdit(null,i)}}async completeEdit(i,e){var t,r,n,s;const a=this,{inputField:o,oldValue:l,record:d}=a,c=o.invalidAction||(o.allowInvalid===!1?"block":a.invalidAction),{value:u}=o;if(a.isVisible){if(!o.isValid&&c!=="allow"){if(e!=null&&e.key&&e.preventDefault(),c==="block")return(t=o.focus)==null||t.call(o),!1;if(c==="revert")return a.cancelEdit(e)!==!1}else{if(T.isEqual(u,l))return a.cancelEdit(e)!==!1;{e!=null&&e.key&&e.stopPropagation();const h={inputField:o,record:d,value:u,oldValue:l};if((a.isFinishing=a.hasListener("beforeComplete"))&&await a.trigger("beforeComplete",h)===!1)a.isFinishing=!1,(r=o.focus)==null||r.call(o);else if(a.isFinishing=!1,i||(i=h.finalize||((n=h.editorContext)==null?void 0:n.finalize)),i){let f=await i(h);if(f===!0)a.onEditComplete();else{if(o.setError){const g=f||o.invalidValueError,m=()=>{v(),o.clearError(g)},v=o.ion({change:m,input:m});o.setError(g)}c==="block"?(s=o.focus)==null||s.call(o):c==="revert"&&(await o.setValue(l),f=!0),f=!1}return f}else return a.onEditComplete(),!0}}return!1}}cancelEdit(i){var e;const t=this,{inputField:r,oldValue:n}=t,{value:s}=r;if(t.editing&&!t.isFinishing&&t.trigger("beforeCancel",{value:s,oldValue:n,event:i})!==!1)(e=r.clearError)==null||e.call(r),t.isFinishing=!0,t.hide(),(i==null?void 0:i.key)==="Escape"&&i.stopImmediatePropagation(),t.trigger("cancel",{value:s,oldValue:n,event:i}),t.finishEdit(),t.isFinishing=!1;else return i==null||i.preventDefault(),!1}onEditComplete(){const i=this,{record:e,dataField:t,inputField:r,oldValue:n}=i;let{value:s}=r;if(!i.isFinishing){if(i.isFinishing=!0,i.hide(),e&&(!i.instantUpdate||r._outstandingUpdate)){const a=`set${k.capitalize(t)}`;e.isFieldModified(t)&&e.getUnmodified(t)==null&&(s==null||s==="")&&(s=e.meta.modified[t]),e[a]?e[a](s):e.setValue(t,s)}i.trigger("complete",{value:s,oldValue:n}),i.finishEdit(),i.isFinishing=!1}}doDestroy(){this.createdInputField&&this.inputField.destroy(),super.doDestroy()}set owner(i){this._owner=i}get owner(){return this._owner||z.fromElement(this.element.parentNode)}changeInputField(i,e){const t=this;return e&&e.destroy(),typeof i=="string"&&(i={type:i}),i instanceof z||(i.type||(i.type="textfield"),i=z.create(i),t.createdInputField=!0),t.completeOnChange&&i.ion({change:"onInputFieldChange",thisObj:t}),i.parent=t,i}updateInputField(i){this.removeAll(),this.add(i)}get inputField(){return this.items[0]}onInputFieldChange(){this.containsFocus&&this.completeEdit()}onTargetSizeChange(i,e,t){e&&t&&this.updateSize(i)}updateSize(i,e=this.lastMatchSize){const t=this,r=$.inner(i);t.width=e.width===!1?"auto":r.width-t.align.offset[0],t.height=e.height===!1?"auto":r.height,t.lastMatchSize=e}beforeEditorHide(){if(this.editing&&!this.isFinishing)return this.cancelEdit(),!1}afterEditorHide(){var i;this.positioned&&this.element.remove(),it.removeResizeListener((i=this.lastAlignSpec)==null?void 0:i.target,this.onTargetSizeChange)}owns(...i){var e;return(e=this.inputField)!=null&&e.owns?this.inputField.owns(...i):super.owns(...i)}};p(li,"$name","Editor"),p(li,"type","editor"),p(li,"configurable",{positioned:!0,hidden:!0,layout:"fit",align:{align:"t0-t0",offset:[0,0]},hideTarget:!1,appendToTargetParent:!1,matchSize:!0,matchFont:!0,fitTargetContent:!1,inputField:"textfield",blurAction:"complete",completeKey:"Enter",cancelKey:"Escape",invalidAction:"block",completeOnChange:null,isolateFields:!0,instantUpdate:!1,floating:!1}),li.initClass(),li._$name="Editor";var sl=class{static getLocalizedFormatter(i){return(i==null?void 0:i.style)==="currency"&&!i.currency&&(i.currency=ke.locale.NumberFormat.currency),typeof i=="string"?Oi.get({locale:ke.localeCode,template:i}):(i==null?void 0:i.locale)!=null?Oi.get(i):Oi.get(Object.assign({},i,{locale:ke.localeCode}))}};p(sl,"$name","NumberHelper"),sl._$name="NumberHelper";var u1=i=>i.ctrlKey&&i.preventDefault(),al=class extends ut{static get configurable(){return{wrapAround:null,min:null,max:null,step:1,largeStep:0,value:null,format:"",triggers:{spin:{type:"spintrigger"}},changeOnSpin:!0,inputType:null}}construct(i){super.construct(i);const e=this;e.input.addEventListener("dblclick",()=>{e.select()}),typeof e.changeOnSpin=="number"&&(e.bufferedSpinChange=e.buffer(e.triggerChange,e.changeOnSpin))}acceptValue(i,e){let t=!isNaN(i);if(t&&!this.hasTextSelection){t=!1;const r=this.input.value,n=parseFloat(r);r!==e&&(t=!this.acceptValue(n,r))}return t}okMax(i){return isNaN(this.max)||i<=this.max}okMin(i){return isNaN(this.min)||i>=this.min}internalOnKeyEvent(i){if(i.type==="keydown"){const e=this,t=i.key;let r;if(t==="ArrowUp")e.doSpinUp(i.shiftKey),r=!0;else if(t==="ArrowDown")e.doSpinDown(i.shiftKey),r=!0;else if(!i.altKey&&!i.ctrlKey&&t&&t.length===1){const n=e.getAfterValue(t),s=e.formatter.parseStrict(n);r=!(s===e.value||n==="-"&&(isNaN(e.min)||e.min<0))&&!e.acceptValue(s,n)}t==="Enter"&&e._changedBySilentSpin&&(e.triggerChange(i,!0),e._changedBySilentSpin=!1),r&&i.preventDefault()}super.internalOnKeyEvent(i)}doSpinUp(i=!1){const e=this,t=e.formatter.is.percent?100:1,r=(i?e.largeStep:e.step)/t;if(e.readOnly)return;let n=(e.value||0)+r;e.okMin(n)||(n=e.min),e.okMax(n)?e.applySpinChange(n):e.wrapAround&&(n=e.min,e.applySpinChange(n))}doSpinDown(i=!1){const e=this,t=e.formatter.is.percent?100:1,r=(i?e.largeStep:e.step)/t;if(e.readOnly)return;let n=(e.value||0)-r;e.okMax(n)||(n=e.max),e.okMin(n)?e.applySpinChange(n):e.wrapAround&&(n=e.max-e.max%r,e.applySpinChange(n))}applySpinChange(i){const e=this;e._isUserAction=!0,e.changeOnSpin!==!0&&(e._changedBySilentSpin=!0,e.silenceChange=!0,e.bufferedSpinChange&&e.bufferedSpinChange(null,!0)),e.value=i,e._isUserAction=!1,e.silenceChange=!1}triggerChange(...i){this.silenceChange||super.triggerChange(...i)}onFocusOut(i,...e){var t,r,n;super.onFocusOut(i,...e);const s=this,{input:a}=s,o=a.value,l=s.formatter.truncate(o),d=isNaN(l)?o:s.formatValue(l);(n=(r=(t=s.triggers)==null?void 0:t.spin)==null?void 0:r.clickRepeater)==null||n.cancel(),s.lastTouchmove=null,o!==d&&(a.value=d),s._changedBySilentSpin&&(s.triggerChange(i,!0),s._changedBySilentSpin=!1)}internalOnInput({data:i}){const e=this,{formatter:t,input:r}=e,{parser:n,maximumFractionDigits:s}=t,a=r.value;if((i==null?void 0:i.length)>1&&!(isFinite(n.parse(a))||a==="-")){const o=e._lastValue||e.valueOnFocus;e.queueMicrotask(()=>{e._value=NaN,e.value=o})}else{const o=n.decimalPlaces(a);if(t.truncator&&o>s){let l=a,d;const c=t.truncate(a);if(!isNaN(c)&&(l=e.formatValue(c),d=n.decimalPlaces(l),d<s&&(l+="0".repeat(s-d),d=s),d<o)){const u=a.length-e.caretPos;r.value=l,e.caretPos=l.length-u+1}}super.internalOnInput(...arguments)}}formatValue(i){return this.formatter.format(i)}get formatter(){var i;return(i=this._formatter)!=null?i:this._formatter=sl.getLocalizedFormatter(this.format)}updateStep(i){var e;const t=this;t.element.classList.toggle("b-hide-spinner",!i),t._step=i,i&&Y.isMobile?t.touchMoveListener||(t.touchMoveListener=j.on({element:t.input,touchmove:"onInputSwipe",thisObj:t,throttled:{buffer:150,alt:u1}})):(e=t.touchMoveListener)==null||e.call(t)}onInputSwipe(i){const{lastTouchmove:e}=this;if(e){const t=i.screenX-e.screenX,r=e.screenY-i.screenY,n=Math.abs(t)>Math.abs(r)?t:r;this[`doSpin${n>0?"Up":"Down"}`]()}i.preventDefault(),this.lastTouchmove=i}changeLargeStep(i){return i||this.step*10}get validity(){const i=this.value,e={};return i!=null&&(e.rangeUnderflow=!this.okMin(i),e.rangeOverflow=!this.okMax(i)),e.valid=!e.rangeUnderflow&&!e.rangeOverflow,e}changeValue(i,e){const t=this;if(i||i===0){let r;typeof i!="number"&&(i=typeof i=="string"?t.formatter.parse(i):Number(i),r=isNaN(i),r&&(i="")),!r&&t.format&&(i=t.formatter.round(i))}else i=void 0;return super.changeValue(i,e)}get inputValue(){return this.value!=null?this.formatValue(this.value):""}updateLocalization(){super.updateLocalization(),this._formatter=void 0,this.syncInputFieldValue()}};p(al,"$name","NumberField"),p(al,"type","numberfield"),p(al,"alias","number"),al.initClass(),al._$name="NumberField";var tC={number:!0,boolean:!0,string:!0,date:!0,duration:!0,time:!0,auto:!0},h1={number:!0,boolean:!0,string:!0},iC=i=>{var e;return((e=i==null?void 0:i.column)==null?void 0:e.type)==="duration"},f1=i=>tC[i==null?void 0:i.type]||iC(i),hT="",di="b-fieldfilterpicker",g1={between:!0,notBetween:!0,isIncludedIn:!0,isNotIncludedIn:!0},m1={startsWith:!0,endsWith:!0,includes:!0,doesNotInclude:!0},p1={textfield:!0,datefield:!0,numberfield:!0,durationfield:!0,combo:!0,timefield:!0},fe={empty:{value:"empty",text:"L{isEmpty}",argCount:0},notEmpty:{value:"notEmpty",text:"L{isNotEmpty}",argCount:0},"=":{value:"=",text:"L{equals}"},"!=":{value:"!=",text:"L{doesNotEqual}"},">":{value:">",text:"L{isGreaterThan}"},"<":{value:"<",text:"L{isLessThan}"},">=":{value:">=",text:"L{isGreaterThanOrEqualTo}"},"<=":{value:"<=",text:"L{isLessThanOrEqualTo}"},between:{value:"between",text:"L{isBetween}",argCount:2},notBetween:{value:"notBetween",text:"L{isNotBetween}",argCount:2},isIncludedIn:{value:"isIncludedIn",text:"L{isOneOf}",isArrayValued:!0},isNotIncludedIn:{value:"isNotIncludedIn",text:"L{isNotOneOf}",isArrayValued:!0}},v1=i=>{const{value:e}=i;return i.isTimeField&&e?S.getTime(e):e},ha=class mn extends ct{static get defaultValueFieldPlaceholders(){return{string:"L{enterAValue}",number:"L{enterANumber}",date:"L{selectADate}",relation:"L{selectValue}",list:"L{selectOneOrMoreValues}",duration:"L{enterAValue}",time:"L{selectATime}",auto:"L{enterAValue}"}}afterConstruct(){const e=this;if(!e._fields)throw new Error(`${mn.name} requires 'fields' to be configured.`);if(!e._filter)throw new Error(`${mn.name} requires 'filter' to be configured.`);super.afterConstruct();const{widgetMap:{propertyPicker:t,operatorPicker:r,caseSensitive:n}}=e;t.ion({select:"onPropertySelect",thisObj:e}),r.ion({select:"onOperatorSelect",thisObj:e}),n.ion({change:"onCaseSensitiveChange",thisObj:e}),e.propertyFieldConfig&&t.setConfig(e.propertyFieldConfig),e.operatorFieldConfig&&r.setConfig(e.operatorFieldConfig),t.cls=e.allPropertyPickerClasses,r.cls=e.allOperatorPickerClasses,e.populateUIFromFilter()}changeDateFormat(e){return this.L(e)}get allChildInputs(){const{propertyPicker:e,operatorPicker:t,caseSensitive:r}=this.widgetMap;return[e,t,...this.valueFields,r]}updateDisabled(e,t){super.updateDisabled(e,t),this.allChildInputs.forEach(r=>r.disabled=e)}updateReadOnly(e){const{propertyPicker:t,operatorPicker:r}=this.widgetMap;this.allChildInputs.forEach(n=>n.readOnly=e),t.readOnly=t.readOnly||e,r.readOnly=r.readOnly||e}updatePropertyLocked(e){this.widgetMap.propertyPicker.readOnly=e||this.readOnly,this.widgetMap.propertyPicker.cls=this.allPropertyPickerClasses}updateOperatorLocked(e){this.widgetMap.operatorPicker.readOnly=e||this.readOnly,this.widgetMap.operatorPicker.cls=this.allOperatorPickerClasses}updateValueLocked(e){this.valueFields.forEach(t=>t.readOnly=e||this.readOnly)}changeOperators(e){const t=e!=null?e:mn.defaultOperators;return Object.keys(t).reduce((r,n)=>({...r,[n]:t[n].map(s=>({...s,text:this.L(s.text)}))}),{})}get isMultiSelectValueField(){var e;return["isIncludedIn","isNotIncludedIn"].includes((e=this._filter)==null?void 0:e.operator)}get allPropertyPickerClasses(){var e;return new le(`${di}-property`,(e=this.propertyFieldConfig)==null?void 0:e.cls,{[`${di}-combo-locked`]:this.propertyLocked})}get allOperatorPickerClasses(){var e;return new le(`${di}-operator`,(e=this.operatorFieldConfig)==null?void 0:e.cls,{[`${di}-combo-locked`]:this.operatorLocked})}getValueFieldConfigs(){var e,t,r,n;const s=this,{valueFieldCls:a,fieldType:o,_filter:{operator:l},onValueChange:d,filterValues:c,isMultiSelectValueField:u,operatorArgCount:h,getValueFieldConfig:f,fieldIsRelation:g,triggerChangeOnInput:m}=s,v=T.merge({},mn.defaultValueFieldPlaceholders,s.valueFieldPlaceholders);if(!o||!l||h===0)return[];let y={type:"textfield",internalListeners:{change:d,input:m?d:null,thisObj:s},bubbleEvents:{keydown:!0},cls:a,dataset:{type:o},placeholder:s.L(v[u?"list":g?"relation":o]),highlightExternalChange:!1};return u||g?y={...y,type:"combo",multiSelect:u,createOnUnmatched:!0,items:s.getUniqueDataValues(c),value:c!=null?c:[]}:l==="sameTime"||l==="notSameTime"?y.type="timefield":["number","date","boolean","duration","time"].includes(o)&&(y.type=`${o}field`),o==="date"&&y.type!=="timefield"?y.format=(t=(e=s.selectedField)==null?void 0:e.format)!=null?t:s.dateFormat:o==="number"&&((r=s.selectedField)!=null&&r.format)&&(y.format=(n=s.selectedField)==null?void 0:n.format),f&&(y=s.callback(f,s,[s.filter,y])),u?[y]:L.populate(h,b=>[{type:"widget",tag:"div",cls:`${di}-value-separator`,content:s.L("L{FieldFilterPicker.and}")},{...y,value:c[b]}]).flat().slice(1)}getUniqueDataValues(e=[]){var t,r;const n=this,{fieldType:s}=n,a=(t=n.selectedField)==null?void 0:t.format;if(!n.store||!((r=n._filter)!=null&&r.property))return[];const{relatedDisplayField:o}=n.selectedField;let l,d;if(n.fieldIsRelation){const{foreignStore:c}=n.currentPropertyRelationConfig;o?(l=c.allRecords.reduce((u,h)=>(h.id!=null&&u.push({text:h.getValue(o),value:h.id}),u),[]),d=l.sort((u,h)=>n.sortStrings(u.text,h.text))):l=c.allRecords.map(u=>u.id)}else l=n.store.allRecords.map(c=>c.getValue(n._filter.property));if(!d){l.push(...e);const c=L.unique(l.reduce((u,h)=>(h!=null&&String(h).trim()!==""&&(s==="date"?u.push(h.valueOf()):s==="duration"?u.push(h.toString()):u.push(h)),u),[]));if(s==="string"?d=c.sort(n.sortStrings):s==="duration"?d=c.map(u=>new Le(u)).filter(u=>u.isValid).sort(n.sortDurations):d=c.sort(n.sortNumerics),s==="date")d=d.map(u=>{const h=new Date(u);return{text:S.format(h,a!=null?a:n.dateFormat),value:u}});else if(s==="number"&&a){const u=sl.getLocalizedFormatter(a);d=d.map(h=>({text:u.format(h),value:h}))}else s==="duration"&&(d=d.map(u=>u.toString()))}return d}sortStrings(e,t){return(e!=null?e:hT).localeCompare(t!=null?t:hT)}sortNumerics(e,t){return e-t}sortDurations(e,t){return e.valueOf()-t.valueOf()}get fieldType(){var e;return(e=this.selectedField)==null?void 0:e.type}get selectedField(){var e,t;return(t=this.fields)==null?void 0:t[(e=this._filter)==null?void 0:e.property]}get propertyOptions(){var e;return Object.entries((e=this.fields)!=null?e:{}).filter(([,t])=>tC[t.type]||iC(t)).map(([t,{title:r}])=>({value:t,text:r!=null?r:t})).sort((t,r)=>t.text.localeCompare(r.text))}get operatorOptions(){return this.operators[this.fieldIsRelation?"relation":this.fieldType]}get fieldIsRelation(){return!!this.currentPropertyRelationConfig}get currentPropertyRelationConfig(){var e,t;return(t=(e=this.store)==null?void 0:e.modelRelations)==null?void 0:t.find(({foreignKey:r})=>{var n;return r===((n=this._filter)==null?void 0:n.property)})}updateOperators(){delete this._operatorArgCountLookup}get operatorArgCountLookup(){return this._operatorArgCountLookup||(this._operatorArgCountLookup=mn.buildOperatorArgCountLookup(this.operators))}updateFilter(){this._filter&&this.onFilterChange()}updateStore(e){var t;(t=this._store)==null||t.un(this),e==null||e.ion({refresh:"onStoreRefresh",thisObj:this}),this.inferFieldTypes()}onStoreRefresh({action:e}){this.isMultiSelectValueField&&["dataset","create","update","delete"].includes(e)&&(this.valueFields[0].items=this.getUniqueDataValues(this.filterValues))}refreshValueFields(){const e=this,{valueFields:t}=e.widgetMap,{valueFields:r,fieldType:n,operatorArgCount:s,_filter:{property:a,operator:o}}=e,l=g1[o],d=o==="sameTime"||o==="notSameTime"?"time":n;t.element.className=new le({[`${di}-values`]:!0,[`${di}-values-multiple`]:l,[`${di}-values-${d}`]:n!==void 0,"b-hidden":a==null||o==null||s===0});const c=e.getValueFieldConfigs();if(c.length!==r.length||c.some(({type:u},h)=>r[h].type!==u))t.removeAll(),t.add(c);else{let u=0;for(const h of c)delete h.type,T.assign(r[u++],h)}delete e._valueFields,e.refreshCaseSensitive()}refreshCaseSensitive(){var e,t;const r=this,{fieldType:n,operatorArgCount:s,isMultiSelectValueField:a}=r,o=(e=r._filter)==null?void 0:e.operator,{caseSensitive:l}=r.widgetMap;l.hidden=n!=="string"||!o||a||s===0,l.checked=((t=r._filter)==null?void 0:t.caseSensitive)!==!1}onPropertySelect(e){var t;const r=this,{_filter:n}=r;n.property=((t=e.record)==null?void 0:t.data.value)||null,r.fieldType!==r._fieldType&&(n.operator=null,n.value=null),r._fieldType=n.type=r.fieldType,r.refreshOperatorPicker(),r.refreshValueFields(),r.triggerChange()}onCaseSensitiveChange({checked:e}){this._filter.caseSensitive=e,this.triggerChange()}onOperatorSelect(e){var t;const r=this,n=r.isMultiSelectValueField,s=this.operatorArgCount;r._filter.operator=((t=e.record)==null?void 0:t.data.value)||null,r.operatorArgCount!==s&&(r._filter.value=null),r.isMultiSelectValueField&&!n&&(r._filter.value=[]),r.refreshValueFields(),r.triggerChange()}triggerChange(){const{filter:e,isValid:t}=this;this.trigger("change",{filter:e,isValid:t})}onValueChange(){const e=this,{isMultiSelectValueField:t,fieldType:r,_filter:n}=e,s=this.valueFields.map(v1);t&&r==="date"?n.value=s[0].map(a=>new Date(a)):t&&r==="duration"?n.value=s[0].map(a=>new Le(a)):(r==="date"&&n.operator==="between"&&S.isValidDate(s[1])&&s[1].setHours(23,59,59,999),n.value=s.length===1?s[0]:s),e.triggerChange()}refreshOperatorPicker(){const{operatorPicker:e}=this.widgetMap,{_filter:{operator:t,property:r},operatorOptions:n}=this;e.items=n,e.value=t,e.hidden=r===null}populateUIFromFilter(e=!1){const t=this,{filterValues:r,widgetMap:{propertyPicker:n,operatorPicker:s},_filter:{property:a,operator:o,disabled:l},propertyOptions:d,operatorOptions:c,isMultiSelectValueField:u}=t;n.items=d,s.items=c,s.hidden=a===null;let h=e;n.value!==a&&(n.value=a,t.refreshOperatorPicker(),h=!0),t.fieldType==="date"&&(o==="="?t._filter.operator="sameDay":o==="!="&&(t._filter.operator="notSameDay")),s.value!==o&&(o===null||!s.items.find(({value:f})=>f===o)?s.clear():s.value=o,h=!0),!o&&s.items.length===1&&(s.value=t._filter.operator=s.items[0].value),h&&t.refreshValueFields(),t.refreshCaseSensitive(),t.valueFields.forEach((f,g)=>{u&&(f.value.length>0||r.length>0)?t.fieldType==="date"?f.value=r.map(m=>m==null?void 0:m.valueOf()):t.fieldType==="duration"?f.value=r.map(m=>m==null?void 0:m.toString()):f.value=r:g>=r.length?f.clear():f.value=r[g]}),t.allChildInputs.forEach(f=>f.disabled=t.disabled||l)}get valueFields(){return this._valueFields||(this._valueFields=this.widgetMap.valueFields.queryAll(e=>e.owner===this.widgetMap.valueFields&&p1[e.type]))}get filterValues(){var e;return((e=this._filter)==null?void 0:e.value)==null?[]:L.asArray(this._filter.value)}onFilterChange(){const e=this,t=e.fieldType,r=t!==e._fieldType;e._fieldType=e._filter.type=t,e.populateUIFromFilter(r)}get operatorArgCount(){const{fieldType:e,filter:{operator:t},operatorArgCountLookup:r}=this;return e&&t?r[e][t]:1}get isValid(){const e=this,{filter:t,fieldType:r,filterValues:n,isMultiSelectValueField:s,operatorArgCount:a}=e,{operator:o,value:l}=t,d=a>0&&l==null;return!!(r&&o&&!d&&(!m1[o]||l)&&(s&&n.length>0||n.length===a)&&n.every(c=>c!=null&&(r!=="duration"||c.isValid)))}get focusElement(){var e,t,r,n;return(n=(r=(t=(e=this.valueFields.find(s=>s.isEmptyInput))!=null?e:this.operatorPicker)!=null?t:this.propertyPicker)==null?void 0:r.input)!=null?n:super.focusElement}inferFieldTypes(){var e;if(((e=this.store)==null?void 0:e.totalCount)>0&&this.fields)for(const[t,r]of Object.entries(this.fields))r.type==="auto"&&(r.type=mn.inferFieldType(this.store,t))}static inferFieldType(e,t){var r;const n=(r=e.find(s=>s.getValue(t)!=null,!0))==null?void 0:r.getValue(t);if(n!==void 0){const s=typeof n;if(s==="object"&&n instanceof Date)return"date";if(h1[s])return s}return"auto"}static localizeOperator(e,t){const{defaultOperators:r}=mn,n=Object.keys(r).sort((s,a)=>s===t?-1:a===t?1:0);for(const s of n)for(const a of r[s])if(a.value===e)return mn.L(a.text);return e}};p(ha,"$name","FieldFilterPicker"),p(ha,"type","fieldfilterpicker"),p(ha,"defaultOperators",{string:[fe.empty,fe.notEmpty,fe["="],fe["!="],{value:"includes",text:"L{contains}"},{value:"doesNotInclude",text:"L{doesNotContain}"},{value:"startsWith",text:"L{startsWith}"},{value:"endsWith",text:"L{endsWith}"},fe.isIncludedIn,fe.isNotIncludedIn],number:[fe.empty,fe.notEmpty,fe["="],fe["!="],fe[">"],fe["<"],fe[">="],fe["<="],fe.between,fe.notBetween,fe.isIncludedIn,fe.isNotIncludedIn],date:[fe.empty,fe.notEmpty,{value:"sameDay",text:"L{equals}"},{value:"notSameDay",text:"L{doesNotEqual}"},{value:"sameTime",text:"L{timeEquals}"},{value:"notSameTime",text:"L{timeDoesNotEqual}"},{value:"<",text:"L{isBefore}"},{value:">",text:"L{isAfter}"},fe.between,{value:"isToday",text:"L{isToday}",argCount:0},{value:"isTomorrow",text:"L{isTomorrow}",argCount:0},{value:"isYesterday",text:"L{isYesterday}",argCount:0},{value:"isThisWeek",text:"L{isThisWeek}",argCount:0},{value:"isNextWeek",text:"L{isNextWeek}",argCount:0},{value:"isLastWeek",text:"L{isLastWeek}",argCount:0},{value:"isThisMonth",text:"L{isThisMonth}",argCount:0},{value:"isNextMonth",text:"L{isNextMonth}",argCount:0},{value:"isLastMonth",text:"L{isLastMonth}",argCount:0},{value:"isThisYear",text:"L{isThisYear}",argCount:0},{value:"isNextYear",text:"L{isNextYear}",argCount:0},{value:"isLastYear",text:"L{isLastYear}",argCount:0},{value:"isYearToDate",text:"L{isYearToDate}",argCount:0},fe.isIncludedIn,fe.isNotIncludedIn],boolean:[{value:"isTrue",text:"L{isTrue}",argCount:0},{value:"isFalse",text:"L{isFalse}",argCount:0}],duration:[fe.empty,fe.notEmpty,fe["="],fe["!="],fe[">"],fe["<"],fe[">="],fe["<="],fe.between,fe.notBetween,fe.isIncludedIn,fe.isNotIncludedIn],time:[fe.empty,fe.notEmpty,fe["="],fe["!="],fe[">"],fe["<"],fe[">="],fe["<="],fe.between,fe.notBetween,fe.isIncludedIn,fe.isNotIncludedIn],relation:[fe.empty,fe.notEmpty,fe["="],fe["!="],fe.isIncludedIn,fe.isNotIncludedIn],auto:[{value:"*",text:"L{contains}"}]}),p(ha,"configurable",{fields:null,disabled:!1,readOnly:!1,layout:"vbox",propertyLocked:!1,operatorLocked:!1,valueLocked:!1,filter:null,propertyFieldConfig:null,operatorFieldConfig:null,valueFieldCls:null,triggerChangeOnInput:!0,items:{inputs:{type:"container",layout:"hbox",cls:`${di}-inputs`,items:{propertyPicker:{type:"combo",items:{},cls:`${di}-property`,placeholder:"L{FieldFilterPicker.selectAProperty}",highlightExternalChange:!1},operatorPicker:{type:"combo",items:{},cls:`${di}-operator`,placeholder:"L{FieldFilterPicker.selectAnOperator}",highlightExternalChange:!1},valueFields:{type:"container",cls:`${di}-values`,items:{}}}},caseSensitive:{type:"checkbox",text:"L{FieldFilterPicker.caseSensitive}",cls:`${di}-case-sensitive`}},operators:ha.defaultOperators,dateFormat:"L{FieldFilterPicker.dateFormat}",store:null,valueFieldPlaceholders:null,getValueFieldConfig:null}),p(ha,"buildOperatorArgCountLookup",i=>L.keyBy(Object.entries(i),([e])=>e,([,e])=>L.keyBy(e,({value:t})=>t,({argCount:t})=>t===void 0?1:t)));var mr=ha;mr.initClass(),mr._$name="FieldFilterPicker";var ol=class extends z{compose(){const{text:i,html:e}=this;return{tag:"label",text:i,html:e}}};p(ol,"$name","Label"),p(ol,"type","label"),p(ol,"configurable",{text:null,localizableProperties:["text"]}),ol.initClass(),ol._$name="Label";var Hn=class Jc extends ct{afterConstruct(){const e=this;e.validateConfig();const{addFilterButton:t}=e.widgetMap;t.ion({click:"addFilter",thisObj:e}),t.text=e.L(t.text),e.store&&e.updateStore(e.store),super.afterConstruct()}changeDateFormat(e){return this.L(e)}validateConfig(){if(!this.fields&&!this.store)throw new Error("FieldFilterPickerGroup requires either a 'fields' or 'store' config property.")}updateFields(e){this.widgetMap.pickers.childItems.forEach(t=>t.fields=e)}updateFilters(e,t){const r=this;t&&t.filter(n=>!e.find(s=>s.id===n.id)).forEach(n=>{var s;return(s=r.store)==null?void 0:s.removeFilter(n.id)}),e.forEach(n=>n.id=n.id||r.nextFilterId),r.widgetMap.pickers.items=(e==null?void 0:e.map(n=>r.getPickerRowConfig(n)))||[]}changeFilters(e){const{canManageFilter:t,limitToProperty:r}=this;let n=e;return t&&(n=n.filter(s=>this.callback(t,this,[s]))),r&&(n=n.filter(s=>s.property==null||s.property===r)),n}updateStore(e){const t=this;if(t.detachListeners("store"),e){let r=!1;t.widgetMap.pickers.childItems.forEach(({widgetMap:{filterPicker:{filter:n,isValid:s}}})=>{s&&!e.filters.includes(n)&&(e.removeFilter(n.id,!0),e.addFilter(n,!0),r=!0)}),r&&e.filter(),t.appendFiltersFromStore(),e.ion({name:"store",filter:"onStoreFilter",thisObj:t})}t.widgetMap.pickers.childItems.forEach(r=>r.store=e)}updateShowAddFilterButton(e){this.widgetMap.addFilterButton.hidden=!e}updateAddFilterButtonText(e){this.widgetMap.addFilterButton.text=e!=null?e:Jc.addFilterButtonDefaultText}appendFiltersFromStore(){const e=this;e.store.filters.forEach(t=>{var r;const n=e.canManage(t),{property:s,operator:a,id:o}=t;n&&s&&a&&!((r=e.filters)!=null&&r.find(l=>l.id===o))&&e.appendFilter(t)})}canManage(e){const t=this;return(!t.allowedFieldNames||t.allowedFieldNames.includes(e.property))&&(!t.canManageFilter||t.callback(t.canManageFilter,t,[e])===!0)}getFilterPickerConfig(e){const t=this,{fields:r,store:n,disabled:s,readOnly:a,valueFieldCls:o,operators:l,limitToProperty:d,dateFormat:c,getFieldFilterPickerConfig:u,triggerChangeOnInput:h,allowedFieldNames:f}=t;return{type:t.constructor.childPickerType,fields:r!=null?r:t.getFieldsFromStore(n),filter:e,store:n,disabled:s,readOnly:a,propertyLocked:!!d,valueFieldCls:o,operators:l,dateFormat:c,internalListeners:{change:"onFilterPickerChange",thisObj:t},flex:1,triggerChangeOnInput:h,allowedFieldNames:f,...u?t.callback(u,t,[e]):void 0}}getFieldsFromStore(e){var t,r;return Object.fromEntries((r=(t=e.modelClass)==null?void 0:t.fields.map(({name:n,type:s})=>[n,{type:s}]))!=null?r:[])}getPickerRowConfig(e){const t=this,{disabled:r,readOnly:n,canDeleteFilter:s}=t,a=!(s&&t.callback(s,t,[e])===!1),o=!e.disabled;return{type:"container",layout:"box",cls:{[`b-${Jc.type}-row`]:!0,[`b-${Jc.type}-row-removable`]:a},dataset:{separatorText:t.L("L{FieldFilterPicker.and}")},items:{activeCheckbox:{type:"checkbox",disabled:r,readOnly:n,checked:o,ariaLabel:t.L("L{FieldFilterPickerGroup.applyCond}",o),internalListeners:{change:"onFilterActiveChange",thisObj:t},cls:`b-${Jc.type}-filter-active`},filterPicker:t.getFilterPickerConfig(e),removeButton:{type:"button",ref:"removeButton",disabled:r,readOnly:n,hidden:!a,cls:`b-transparent b-${Jc.type}-remove`,icon:"b-fa-trash",internalListeners:{click:"removeFilter",thisObj:t}}}}}get allInputs(){const e=[this.constructor.childPickerType,"button","checkbox"];return this.queryAll(t=>e.includes(t.type))}updateDisabled(e,t){super.updateDisabled(e,t),this.allInputs.forEach(r=>r.disabled=e)}updateReadOnly(e){this.allInputs.forEach(t=>t.readOnly=e)}onFilterActiveChange({source:e,checked:t}){const r=this,n=r.getFilterIndex(e),s=r.filters[n],a=r.getFilterPicker(n);e.input.setAttribute("aria-label",r.L("L{FieldFilterPickerGroup.applyCond}",t)),s.disabled=!t,a.onFilterChange(),r.store&&a.isValid&&(r.store.addFilter(s,!0),r.updateStoreFilter()),r.triggerChange()}onFilterPickerChange({source:e,filter:t,isValid:r}){const n=this,{store:s}=n,a=n.getFilterIndex(e);s&&(s.removeFilter(t.id,!0),r&&s.addFilter(t,!0),n.updateStoreFilter()),Object.assign(n.filters[a],t),n.triggerChange()}getFilterIndex(e){return parseInt(e.parent.element.dataset.itemIndex)}getPickerRow(e){return this.widgetMap.pickers.childItems[e]}getFilterPicker(e){return this.getPickerRow(e).widgetMap.filterPicker}get nextFilterId(){return this._nextId=(this._nextId||0)+1,`${this.id}-filter-${this._nextId}`}removeFilter({source:e}){const t=this,r=t.getFilterIndex(e),n=t.filters[r],s=t.getPickerRow(r),a=t.query(o=>o.isFocusable&&o.type!=="container"&&!s.contains(o));a&&a.focus(),t.removeFilterAt(r),t.store&&(t.store.removeFilter(n.id,!0),t.updateStoreFilter()),t.trigger("remove",{filter:n}),t.triggerChange()}addFilter({property:e=null,operator:t=null,value:r=null}={}){var n;const s=this,{filters:a}=s,o={property:s.limitToProperty||e,operator:t,value:r,disabled:!1,id:s.nextFilterId,caseSensitive:!1};s.trigger("beforeAddFilter",{filter:o})&&(s.appendFilter(o),s.getFilterPicker(a.length-1).isValid&&((n=s.store)==null||n.addFilter(o,!0),s.store&&s.updateStoreFilter()),s.trigger("add",{filter:o}),s.triggerChange())}appendFilter(e){const t=this;(!t.limitToProperty||e.property===t.limitToProperty)&&(t.filters.push(e),t.widgetMap.pickers.add(t.getPickerRowConfig(e,t.filters.length-1)))}onStoreFilter(e){const t=this;if(t._isUpdatingStore)return;const{filters:r}=e,n=r.values.reduce((s,a)=>({...s,[a.id]:a}),{});for(let s=t.filters.length-1;s>=0;s--){const a=t.filters[s],o=n[a.id],l=t.getPickerRow(s);if(l){const{filterPicker:d,activeCheckbox:c}=l.widgetMap;if(!o&&d.isValid)t.removeFilterAt(s);else if(o!==void 0){const{operator:u,value:h,property:f,disabled:g,caseSensitive:m}=o;a!==o&&Object.assign(a,{operator:u,value:h,property:f,disabled:g,caseSensitive:m}),d.filter=a,d.onFilterChange(),c.checked=!g}}}t.appendFiltersFromStore(),t.triggerChange()}removeFilterAt(e){const{widgetMap:{pickers:t},filters:r}=this;t.remove(t.childItems[e]),r.splice(e,1),this.triggerChange()}updateStoreFilter(){var e;this._isUpdatingStore=!0,(e=this.store)==null||e.filter(),this._isUpdatingStore=!1}get value(){return this.filters}triggerChange(){const{filters:e}=this,t=e.filter((r,n)=>this.getPickerRow(n).widgetMap.filterPicker.isValid);this.trigger("change",{filters:e,validFilters:t})}activateAll(){this.setAllActiveStatus(!0)}deactivateAll(){this.setAllActiveStatus(!1)}setAllActiveStatus(e){const t=this,{_filters:r,store:n}=t;r.forEach((s,a)=>{if(e===s.disabled){const{filterPicker:o,activeCheckbox:l}=t.getPickerRow(a).widgetMap;s.disabled=!e,o.onFilterChange(),l.checked=e,e&&n&&o.isValid&&n.addFilter(s,!0)}}),t.updateStoreFilter()}get focusElement(){var e,t;return(t=(e=this.getPickerRow(this._filters.length-1))==null?void 0:e.widgetMap.filterPicker.focusElement)!=null?t:super.focusElement}};p(Hn,"$name","FieldFilterPickerGroup"),p(Hn,"type","fieldfilterpickergroup"),p(Hn,"addFilterButtonDefaultText","L{FieldFilterPickerGroup.addFilter}"),p(Hn,"configurable",{filters:[],fields:null,disabled:!1,readOnly:!1,layout:"vbox",store:null,limitToProperty:null,valueFieldCls:null,showAddFilterButton:!0,canDeleteFilter:null,getFieldFilterPickerConfig:null,canManageFilter:null,addFilterButtonText:null,triggerChangeOnInput:!0,allowedFieldNames:null,items:{pickers:{type:"container",layout:"vbox",scrollable:!0,items:{}},addFilterButton:{type:"button",text:Hn.addFilterButtonDefaultText,cls:`b-${Hn.type}-add-button`,hidden:!0}},operators:null,dateFormat:"L{FieldFilterPicker.dateFormat}"}),p(Hn,"childPickerType","fieldfilterpicker");var km=Hn;km.initClass(),km._$name="FieldFilterPickerGroup";var eh=class extends ut{static get configurable(){return{multiple:null,accept:null,inputType:"file",attributes:["multiple","accept"]}}get files(){return this.input.files}pickFile(){this.input.click()}get multiple(){return this._multiple?"":null}clear(){this.input.value=null}triggerChange(i){this.triggerFieldChange({event:i,value:this.input.value,oldValue:this._lastValue,userAction:!0,valid:!0})}};p(eh,"$name","FileField"),p(eh,"type","filefield"),eh.initClass(),eh._$name="FileField";var ll=class extends ct{construct(i={}){const e=this;i.items=[Object.assign({type:"button",ref:"fileButton",text:"L{FilePicker.file}",localeClass:this},i.buttonConfig),Object.assign({type:"filefield",ref:"fileField",style:"display: none"},i.fileFieldConfig)].concat(i.items||[]),super.construct(i),e.button.ion({click:e.onButtonClick,thisObj:e}),e.fileField.ion({change:e.onFileFieldChange,thisObj:e}),e._thisIsAUsedExpression(e.fileTip)}get button(){return this.widgetMap.fileButton}get fileField(){return this.widgetMap.fileField}get files(){return this.fileField.files}get fileTip(){const i=this;return i._fileTip||(i._fileTip=new Fe({cls:"b-file-tip",forElement:i.button.element,showOnHover:!0,align:"b-t",scrollAction:"realign",internalListeners:{beforeshow(){const e=this,t=i.files;return t&&t.length?(e.html=`${Array.from(t).map(r=>k.encodeHtml(r.name)).join("<br>")}`,!0):!1}}}))}clear(){const i=this;i.fileField.clear(),i.updateBadge(),i.trigger("clear")}onButtonClick({event:i}){this.fileField.pickFile(),i.preventDefault()}onFileFieldChange({valid:i}){const e=this;e.updateBadge(),e.triggerFieldChange({files:e.files,valid:i})}updateShowBadge(){this.isConfiguring||this.updateBadge()}updateBadge(){this.button.badge=this.showBadge&&this.files.length||""}};p(ll,"$name","FilePicker"),p(ll,"type","filepicker"),p(ll,"configurable",{defaultBindProperty:"value",buttonConfig:null,fileFieldConfig:null,showBadge:!0}),ll.initClass(),ll._$name="FilePicker";var dl=class extends zi{updateValue(i,e){super.updateValue(i,e),i&&this.isConfiguring&&this.onInternalChange({value:i})}onInternalChange({value:i}){const{store:e,field:t,filterFunction:r,internalFilter:n,filterId:s}=this;if(e){const a=s!=null?s:`${t||this.id}-Filter`;if(i.length===0)e.removeFilter(a);else{let o;r?o=l=>r(l,i):(i=k.escapeRegExp(i),o=l=>{var d;return(d=l.getValue(t))==null?void 0:d.match(new RegExp(i,"i"))}),e.filter({id:a,filterBy:o,...n?{internal:!0}:{}})}}}};p(dl,"$name","FilterField"),p(dl,"type","filterfield"),p(dl,"configurable",{field:null,store:null,filterFunction:null,filterId:null,internalFilter:null,clearable:!0,revertOnEscape:!0,ignoreParentReadOnly:!0,keyStrokeChangeDelay:100,internalListeners:{change:"onInternalChange"}}),dl.initClass(),dl._$name="FilterField";var fT=[{ref:"cancelButton",cls:"b-messagedialog-cancelbutton b-gray",text:"L{Object.Cancel}"