/*!
 *
 * Bryntum Scheduler Pro 6.0.5
 *
 * Copyright(c) 2024 Bryntum AB
 * https://bryntum.com/contact
 * https://bryntum.com/license
 *
 * Bryntum incorporates third-party code licensed under the MIT and Apache-2.0 licenses.
 * See the licenses below or visit https://bryntum.com/products/schedulerpro/docs/guide/SchedulerPro/licenses
 *
 * # Third Party Notices
 * 
 * Bryntum uses the following third party libraries:
 * 
 * * [Font Awesome 6 Free](https://fontawesome.com/license/free) (MIT/SIL OFL 1.1)
 * * [Roboto font](https://github.com/google/roboto) (Apache-2.0)
 * * [Styling Cross-Browser Compatible Range Inputs with Sass](https://github.com/darlanrod/input-range-sass) (MIT)
 * * [Tree Walker polyfill](https://github.com/Krinkle/dom-TreeWalker-polyfill) (MIT)
 * * [chronograph](https://github.com/bryntum/chronograph) (MIT)
 * * [later.js](https://github.com/bunkat/later) (MIT)
 * * [Monaco editor](https://microsoft.github.io/monaco-editor) (MIT)
 * * Map/Set polyfill to fix performance issues for Salesforce LWS (MIT)
 * 
 * Note: the **chronograph** and **later.js** libraries are used in Bryntum Scheduler Pro and Bryntum Gantt, but they are
 * listed for all Bryntum products since the distribution contains trial versions of the thin bundles for all other
 * products. TreeWalker is only used in the LWC bundle for Salesforce. Roboto font is only used in the material theme.
 * 
 * ## Font Awesome 6 Free
 * 
 * [Font Awesome Free 6 by @fontawesome](https://fontawesome.com/)
 * 
 * Font Awesome Free is free, open source, and GPL friendly. You can use it for commercial projects, open source projects,
 * or really almost whatever you want.
 * 
 * [Full Font Awesome Free license](https://fontawesome.com/license/free)
 * 
 * ## Roboto font
 * 
 * [Apache License Version 2.0, January 2004](https://www.apache.org/licenses/LICENSE-2.0)
 * 
 * TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 * 
 * 1. Definitions.
 * 
 * "License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9
 * of this document.
 * 
 * "Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.
 * 
 * "Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are
 * under common control with that entity. For the purposes of this definition,
 * "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by
 * contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial
 * ownership of such entity.
 * 
 * "You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.
 * 
 * "Source" form shall mean the preferred form for making modifications, including but not limited to software source code,
 * documentation source, and configuration files.
 * 
 * "Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including
 * but not limited to compiled object code, generated documentation, and conversions to other media types.
 * 
 * "Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as
 * indicated by a copyright notice that is included in or attached to the work
 * (an example is provided in the Appendix below).
 * 
 * "Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work
 * and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an
 * original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain
 * separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.
 * 
 * "Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or
 * additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the
 * Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner.
 * For the purposes of this definition, "submitted"
 * means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including
 * but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems
 * that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding
 * communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a
 * Contribution."
 * 
 * "Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received
 * by Licensor and subsequently incorporated within the Work.
 * 
 * 2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to
 *    You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce,
 *    prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such
 *    Derivative Works in Source or Object form.
 * 
 * 3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a
 *    perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *    (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise
 *    transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are
 *    necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s)
 *    with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (
 *    including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within
 *    the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this
 *    License for that Work shall terminate as of the date such litigation is filed.
 * 
 * 4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with
 *    or without modifications, and in Source or Object form, provided that You meet the following conditions:
 * 
 * (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and
 * 
 * (b) You must cause any modified files to carry prominent notices stating that You changed the files; and
 * 
 * (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark,
 * and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the
 * Derivative Works; and
 * 
 * (d) If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute
 * must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that
 * do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file
 * distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the
 * Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices
 * normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You
 * may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the
 * NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the
 * License.
 * 
 * You may add Your own copyright statement to Your modifications and may provide additional or different license terms and
 * conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole,
 * provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this
 * License.
 * 
 * 5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for
 *    inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any
 *    additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any
 *    separate license agreement you may have executed with Licensor regarding such Contributions.
 * 
 * 6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product
 *    names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and
 *    reproducing the content of the NOTICE file.
 * 
 * 7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and
 *    each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 *    either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT,
 *    MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness
 *    of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this
 *    License.
 * 
 * 8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or
 *    otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing,
 *    shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or
 *    consequential damages of any character arising as a result of this License or out of the use or inability to use the
 *    Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or
 *    any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such
 *    damages.
 * 
 * 9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose
 *    to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or
 *    rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and
 *    on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and
 *    hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason
 *    of your accepting any such warranty or additional liability.
 * 
 * END OF TERMS AND CONDITIONS
 * 
 * APPENDIX: How to apply the Apache License to your work.
 * 
 * To apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by
 * brackets "[]"
 * replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the
 * appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose
 * be included on the same "printed page" as the copyright notice for easier identification within third-party archives.
 * 
 * Copyright [yyyy] [name of copyright owner]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 * [APACHE LICENSE, VERSION 2.0](http://www.apache.org/licenses/LICENSE-2.0)
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "
 * AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * ## Styling Cross-Browser Compatible Range Inputs with Sass
 * 
 * Github: [input-range-sass](https://github.com/darlanrod/input-range-sass)
 * 
 * Author: [Darlan Rod](https://github.com/darlanrod)
 * 
 * Version 1.4.1
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 Darlan Rod
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Tree Walker polyfill
 * 
 * The MIT License (MIT)
 * 
 * [Copyright 2013–2017 Timo Tijhof](https://github.com/Krinkle/dom-TreeWalker-polyfill)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## chronograph
 * 
 * GitHub: [chronograph](https://github.com/bryntum/chronograph)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2023 Bryntum
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## later.js
 * 
 * GitHub: [later.js](https://github.com/bunkat/later)
 * 
 * The MIT License (MIT)
 * 
 * Copyright © 2013 BunKat
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Monaco editor
 * 
 * GitHub: [Monaco editor](https://microsoft.github.io/monaco-editor) (MIT)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 - present Microsoft Corporation
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Map/Set polyfill to fix performance issues for Salesforce LWS
 * 
 * Copyright © 2024 Certinia Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t(((e="undefined"!=typeof globalThis?globalThis:e||self).bryntum=e.bryntum||{},e.bryntum.schedulerpro={}))}(this,(function(e){"use strict";const t="schedulerpro",n=Object.create(null),i=["Array","Browser",["Css","CSSHelper"],"Date","Dom","Event","Function","Object","String","TimeZone","Version"].map((e=>Array.isArray(e)?e:[e,`${e}Helper`])),r=e=>Object.assign(Object.create(null),Object.fromEntries(e)),s=r(i),o=r(i.map((([e,t])=>[t,e]))),a=e=>(t,n)=>{throw new Error(`Cannot ${e} "Helpers.${n}": object is readonly`)},l=new Proxy(n,{defineProperty:a("define property"),deleteProperty:a("delete"),set:a("assign"),get(e,t){const i=n[t];if(!i)throw new Error(`Property not defined "Helpers.${t}": ${t in s?`import ${s[t]} before using it`:"invalid helper name"}`);return i}});var c;Object.defineProperty(n,"register",{value(e){const t=e.$name,i=o[t];n[i]=e}}),i.forEach((e=>n[e[0]]=null));class d{static $name="BrowserHelper";static supportsPointerEvents=Boolean(globalThis.PointerEvent||globalThis.MSPointerEvent);static supportsPointerEventConstructor="undefined"!=typeof PointerEvent;static PointerEventConstructor=globalThis.PointerEvent||globalThis.CustomEvent;static isPhone=null===(c=globalThis.matchMedia)||void 0===c?void 0:c.call(globalThis,"(max-height:414px) or (max-width:414px)").matches;static cacheFlags(e=navigator.platform,t=navigator.userAgent){const n=this;n._isLinux=Boolean(e.match(/Linux/)),n._isMac=Boolean(e.match(/Mac/)),n._isWindows=Boolean(e.match(/Win32/)),n._isMobile=Boolean(t.match(/Mobile|Opera Mini|Opera Mobi|Puffin/)||"number"==typeof globalThis.orientation),n._isWebkit=Boolean(t.match(/WebKit/)&&!t.match(/Edg/)),n._firefoxVersion=n.getVersion(t,/Firefox\/(\d+)\./),n._isFirefox=n._firefoxVersion>0,n._chromeVersion=n.getVersion(t,/Chrom(?:e|ium)\/(\d+)\./),n._isChrome=n._chromeVersion>0,n._isSafari=Boolean(t.match(/Safari/))&&!n._isChrome,n._isMobileSafari=Boolean(t.match(/Mobile.*Safari/)),n._safariVersion=n.getVersion(t,/Version\/(.*).Safari/),n._isAndroid=Boolean(t.match(/Android/g))}static get supportsOverflowClip(){if(null==this._supportsOverflowClip){const e=document.createElement("div");e.style.overflow="clip",e.style.display="none",document.documentElement.appendChild(e),this._supportsOverflowClip="clip"===e.ownerDocument.defaultView.getComputedStyle(e).getPropertyValue("overflow"),e.remove()}return this._supportsOverflowClip}static get supportsSticky(){return!0}static getVersion(e,t){const n=e.match(t);return n?parseFloat(n[1]):0}static get isTouchDevice(){return void 0===this._isTouchDevice&&(this._isTouchDevice=globalThis.matchMedia("(any-pointer:coarse)").matches),this._isTouchDevice}static get isHoverableDevice(){return void 0===this._isHoverableDevice&&(this._isHoverableDevice=globalThis.matchMedia("(any-hover: hover)").matches),this._isHoverableDevice}static get isBrowserEnv(){return"undefined"!=typeof window}static get isMac(){return this._isMac}static get isWindows(){return this._isWindows}static get isLinux(){return this._isLinux}static get isAndroid(){return this._isAndroid}static get isWebkit(){return this._isWebkit}static get isChrome(){return this._isChrome}static get chromeVersion(){return this._chromeVersion}static get isFirefox(){return this._isFirefox}static get firefoxVersion(){return this._firefoxVersion}static get isSafari(){return this._isSafari}static get safariVersion(){return this._safariVersion}static get isMobileSafari(){return this._isMobileSafari}static get isMobile(){return this._isMobile}static get platform(){const e=this;return e._isLinux?"linux":e._isMac?"mac":e._isWindows?"windows":e._isAndroid?"android":e._isMobileSafari?"ios":null}static get supportsRandomUUID(){if(void 0===this._supportsRandomUUID)try{var e,t;this._supportsRandomUUID=Boolean((null===(e=(t=globalThis.crypto).randomUUID)||void 0===e?void 0:e.call(t).length)>0)}catch(e){this._supportsRandomUUID=!1}return this._supportsRandomUUID}static get storageAvailable(){let e,t;try{return e=localStorage,t="__storage_test__",e.setItem(t,t),e.removeItem(t),!0}catch(t){return t instanceof DOMException&&(22===t.code||1014===t.code||"QuotaExceededError"===t.name||"NS_ERROR_DOM_QUOTA_REACHED"===t.name)&&0!==e.length}}static setLocalStorageItem(e,t){this.storageAvailable&&localStorage.setItem(e,t)}static getLocalStorageItem(e){return this.storageAvailable&&localStorage.getItem(e)}static removeLocalStorageItem(e){this.storageAvailable&&localStorage.removeItem(e)}static get ctrlKey(){return this.isMac?"metaKey":"ctrlKey"}static get metaKey(){return this.isMac?"ctrlKey":"metaKey"}static searchParam(e,t=null,n=document.location.search){const i=new RegExp(`[?&]${e}=?([^&]*)`),r=n.match(i);return r&&r[1]||t}static getCookie(e){const t=encodeURIComponent(e)+"=",n=document.cookie.split(";");for(let e=0;e<n.length;e++){let i=n[e];for(;" "===i.charAt(0);)i=i.substring(1,i.length);if(0===i.indexOf(t))return decodeURIComponent(i.substring(t.length,i.length))}return""}static download(e,t){const n=document.createElement("a");n.download=e,n.href=t||e,n.style.cssText="display:none",document.body.appendChild(n),n.click(),document.body.removeChild(n)}static downloadBlob(e,t){const n=globalThis.URL.createObjectURL(e);this.download(t,n),globalThis.URL.revokeObjectURL(n)}static get queryString(){var e;const t=new URL(globalThis.location.href).searchParams;return null===(e=Object.fromEntries)||void 0===e?void 0:e.call(Object,t.entries())}static copyToClipboard(e){let t=!0;const n=document.createElement("textarea");n.value=e,n.style.height=n.style.width=0,document.body.appendChild(n),n.select();try{document.execCommand("copy")}catch(e){t=!1}return n.remove(),t}static isBryntumOnline(e){var t;return e=Array.isArray(e)?e:[e],Boolean(/^(www\.)?bryntum\.com/.test(globalThis.location.host)||(null===(t=e)||void 0===t?void 0:t.some((e=>null!=this.queryString[e]))))}static get isCSP(){const{bryntum:e,document:t}=globalThis;return null==e.CSP&&(e.CSP=Boolean(t.querySelector('meta[http-equiv="Content-Security-Policy"]'))),e.CSP}}l.register(d),d.isBrowserEnv&&d.cacheFlags(),d._$name="BrowserHelper";const{hasOwnProperty:u,toString:h}=Object.prototype,{isFrozen:g}=Object,m=/\s*<\s*/,p=/\s*>\s*/,f={},v={},y=Object.freeze({});class b{static assign(e,...t){for(let n,i,r=0;r<t.length;r++)if(n=t[r],n)for(i in n)e[i]=n[i];return e}static assignIf(e,...t){for(let n,i,r=0;r<t.length;r++)if(n=t[r],n)for(i in n)i in e&&void 0!==e[i]||(e[i]=n[i]);return e}static blend(e,t,n){n=n||f,e=e||{};const{clone:i=b.clone,merge:r=b.blend}=n;if(Array.isArray(t)){if(t.length>1)return t.forEach((t=>{e=b.blend(e,t,n)})),e;t=t[0]}if(t){let s,o,a;for(o in t)a=t[o],a&&b.isObject(a)&&(s=e[o],n.key=o,s&&b.isObject(s)?(g(s)&&(e[o]=s=i(s,n)),a=r(s,a,n)):a=g(a)?a:i(a,n)),e[o]=a}return e}static clone(e,t){let n,i=e;if(e&&"object"==typeof e){if(t&&"object"==typeof t&&t&&(t=null),b.isObject(e))if(e.skipClone)i=e;else for(n in i={},e)i[n]=b.clone(e[n]);else if(Array.isArray(e))for(i=[],n=e.length;n-- >0;)i[n]=b.clone(e[n]);else b.isDate(e)?i=new Date(e.getTime()):t&&(i=t(e))}return i}static mergeUniformObjects(e,...t){for(const n of t)for(const t in n){const i=n[t];i&&(this.isObject(i)?this.mergeUniformObjects(e[t]||(e[t]={}),i):Array.isArray(i)?(t in e||(e[t]=[]),this.mergeArrayOfIdentityObjects(e[t],i)):e[t]=this.clone(i))}return e}static mergeArrayOfIdentityObjects(e,t){for(const n of t)if(this.isObject(n)){const t=e.find((e=>e.id===n.id));t?this.mergeUniformObjects(t,n):e.push(this.clone(n))}else e.push(n)}static createTruthyKeys(e){const t=H.split(e),n=t&&{};if(t)for(const e of t)e&&(n[e]=!0);return n}static getPath(e,t){return t.split(".").reduce(((e,t)=>(e||y)[t]),e)}static getPathDefault(e,t,n){const i=Array.isArray(t)?t:"string"==typeof t?t.split("."):[t],r=i.length-1;return i.reduce(((e,t,i)=>(n&&!(t in e)&&(e[t]=i===r?n:{}),(e||y)[t])),e)}static getPropertyDescriptor(e,t){let n=null;for(let i=e;i&&!n&&!b.hasOwn(i,"isBase");i=Object.getPrototypeOf(i))n=Object.getOwnPropertyDescriptor(i,t);return n}static hasPath(e,t){return t.split(".").every((t=>!(!e||!(t in e))&&(e=e[t],!0)))}static getTruthyKeys(e){let t;if("string"==typeof e)t=[e];else if(Array.isArray(e))t=e.slice();else if(t=[],e)for(const n in e)e[n]&&t.push(n);return t}static getTruthyValues(e){const t=[];if(e)for(const n in e)e[n]&&t.push(e[n]);return t}static isClass(e){var t;return"function"==typeof e&&(null===(t=e.prototype)||void 0===t?void 0:t.constructor)===e}static isDate(e){return Boolean(null==e?void 0:e.getUTCDate)&&"date"===b.typeOf(e)}static isPromise(e){if(Promise&&Promise.resolve)return Promise.resolve(e)===e||"function"==typeof(null==e?void 0:e.then);throw new Error("Promise not supported in your environment")}static isEmpty(e){if(e&&"object"==typeof e)for(const t in e)return!1;return!0}static isObject(e){const t=null==e?void 0:e.constructor;return Boolean(t?t===Object||t.getPrototypeOf&&t.prototype&&!Object.getPrototypeOf(t.prototype):e&&"object"==typeof e)}static isInstantiated(e){return!!e&&("object"==typeof e&&!b.isObject(e))}static merge(e,...t){return b.blend(e,t)}static mergeItems(e,t,n){let i,r,s,o,a,l,c;n=n||f;const{merge:d=b.blend}=n;if(e=e||{},Array.isArray(t))t.forEach((t=>{e=b.mergeItems(e,t,n)}));else if(t)for(a in t)if(c=t[a],i=null,a.includes(">")?([a,i]=a.split(p),r=0):a.includes("<")&&([i,a]=a.split(m),r=1),a in e)c&&e[a]&&d&&(n.key=a,c=d(e[a],c,n)),e[a]=c;else if(i){if(!o){o=new Map,s=0;for(const t in e)o.set(t,s++)}if(s=o.get(i),e[a]=c,null==s&&r)s=o.size;else{l=l||[],s=(s||0)+r;for(const e of o){const[t,n]=e;s<=n&&(l&&(l[o.size-n-1]=t),o.set(t,n+1))}if(l)for(;l.length;){const t=l.pop(),n=e[t];delete e[t],e[t]=n}}o.set(a,s)}else{var u;e[a]=c,null===(u=o)||void 0===u||u.set(a,o.size)}return e}static setPath(e,t,n){return t.split(".").reduce(((e,t,i,r)=>i===r.length-1?e[t]=n:(e[t]instanceof Object||(e[t]={}),e[t])),e),e}static typeOf(e){let t,n;return null===e?n="null":e!=e?n="nan":(n=typeof e,"object"===n?e.isBase?n="instance":Array.isArray(e)?n="array":(n=v[t=h.call(e)])||(v[t]=n=t.slice(8,-1).toLowerCase()):"function"===n&&e.isBase&&(n="class")),n}}let C,S,D,w;Object.defineProperty(b,"hasOwn",{value:Object.hasOwn||((e,t)=>u.call(e,t))}),b._$name="Objects";const E=/([a-z])([A-Z])/g,R=/[\n\r]/g,x=/[.*+?^${}()|[\]\\]/g,T=/[&<]/,M=/(^[^a-z]+[^\w]+)/gi,I=/\s+/,A=/^[^a-z]+|[^\w:.-]+/gi,k=(e,t)=>S[t.toLowerCase()]||String.fromCharCode(parseInt(t.substr(2),10)),F=(e,t)=>C[t],P=(e,t,n)=>`${t}-${n.toLowerCase()}`,O=(e,t,n)=>`${t} ${n.toLowerCase()}`,L=e=>e?`_x${[...e].map((e=>e.charCodeAt(0).toString(16))).join("")}`:"__blank__",$={},_={},j=[],B=function(e,t){if(t&&"object"==typeof t){for(;j.length&&j[j.length-1]!==this;)j.pop();if(j.includes(t))return"[Circular]";j.push(t)}return t};class H{static $name="StringHelper";static capitalize(e){return e&&e[0].toUpperCase()+e.substr(1)}static uncapitalize(e){return e&&e[0].toLowerCase()+e.substr(1)}static hyphenate(e){const t=$[e];return t||($[e]=e.replace(E,P))}static separate(e){const t=_[e];return t||(_[e]=this.capitalize(e.replace(E,O)))}static createId(e){return String(e).replace(M,L)}static makeValidDomId(e,t=""){return null==e?null:String(e).replace(A,t)}static escapeRegExp(e,t){let n=e.replace(x,"\\$&");return void 0!==t&&(n=new RegExp(n,t)),n}static decodeHtml(e){return e&&String(e).replace(w,k)}static encodeHtml(e=""){return e&&String(e).replace(D,F)}static encodeHtmlBR(e){var t;return null===(t=H.encodeHtml(e))||void 0===t?void 0:t.replace(R,"<br>")}static isHtml(e){return"string"==typeof e&&T.test(e||"")}static initHtmlEntities(e){e=e||{"&":"&amp;",">":"&gt;","<":"&lt;",'"':"&quot;","'":"&#39;"};const t=Object.keys(e);C=e,S=t.reduce(((t,n)=>(t[e[n]]=n,t)),{}),D=new RegExp(`([${t.map((e=>"[-]".includes(e)?"\\"+e:e)).join("")}])`,"g"),w=new RegExp(`(${Object.values(e).join("|")}|&#[0-9]+;)`,"ig")}static safeJsonParse(e){let t=null;try{t=JSON.parse(e)}catch(e){}return t}static safeJsonStringify(e,t=null,n=null){let i=null;try{"circular"===t&&(j.length=0,t=B),i=JSON.stringify(e,t,n)}catch{}return i}static joinPaths(e,t="/"){return e.join(t).replace(new RegExp("\\"+t+"+","g"),t)}static split(e,t=I){let n=e;return"string"==typeof n&&(n=e.trim(),n=n?n.split(t):[]),n}static xss(e,...t){const n=[];let i=t.length;for(n[i]=e[i];i-- >0;)n[i]=e[i]+H.encodeHtml(t[i]);return n.join("")}static xssBR(e,...t){const n=[];let i=t.length;for(n[i]=e[i];i-- >0;)n[i]=e[i]+H.encodeHtmlBR(t[i]);return n.join("")}static toJavaScriptValue(e,t){const n=b.typeOf(e);if("boolean"===n||"string"===n||"number"===n||null===e)return H.safeJsonStringify(e);if(e===globalThis)return"window";if("date"===n)return`new Date(${e.getFullYear()}, ${e.getMonth()}, ${e.getDate()}, ${e.getHours()}, ${e.getMinutes()}, ${e.getSeconds()}, ${e.getMilliseconds()})`;if("array"===n)return`[${e.map((e=>H.toJavaScriptValue(e,t)))}]`;if("object"===n||"instance"===n)return this.toJavaScriptString(e,t);if("function"===n){let t=e.toString();return t.match(/^async (\w+?)\(/)?t=t.replace(/^async (\w+?)\(/,"async function("):!t.startsWith("async(")&&t.match(/^(\w+?)\(/)&&(t=t.replace(/^(\w+?)\(/,"function(")),t}return"class"===n?e.toJavaScriptValue?e.toJavaScriptValue(t):Object.prototype.hasOwnProperty.call(e,"$name")?e.$name:e.name:void 0}static toJavaScriptString(e,t={}){const n=t.level??0;return"{\n"+Object.keys(e).map((i=>" ".repeat(2*(n+1))+(i.match(/[- *]/)?`"${i}"`:i)+`: ${H.toJavaScriptValue(e[i],{...t,level:n+1})}`)).join(",\n")+"\n"+" ".repeat(2*n)+"}"}static encodeAttributeSelector(e,t){return`[${e}="${String(t).replace(/["\\]/g,"\\$&")}"]`}static fakeNodeUUIDIndex=0;static generateUUID(){var e;return d.supportsRandomUUID?globalThis.crypto.randomUUID():null!==(e=globalThis.crypto)&&void 0!==e&&e.getRandomValues?([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g,(e=>(e^globalThis.crypto.getRandomValues(new Uint8Array(1))[0]&15>>e/4).toString(16))):`${Date.now()}-${++H.fakeNodeUUIDIndex}`}}H.initHtmlEntities(),l.register(H),H._$name="StringHelper";const V=Object.freeze([]),{hasOwn:z}=b,N="1.01"===1.005.toFixed(2)?null:(e,t)=>{const n=e.toString().split("."),i=+(n[1]?n.join(".")+"1":n[0]);return e.toFixed.call(i,t)};class W extends b{static $name="ObjectHelper";static forEach(e,t){let n;if(e)if(Array.isArray(e))e.forEach(t);else for(n in e)t(e[n],n)}static transformArrayToNamedObject(e,t="ref"){const n={};return e.forEach(((e,i)=>{const r=null!=e[t]&&e[t].toString().length?e[t]:i;n[r]=e})),n}static transformNamedObjectToArray(e,t="ref"){return Object.keys(e).filter((t=>e[t])).map((n=>{const i=e[n];return i[t]=n,i}))}static isEqual(e,t,n=!1,i=!1){if(!i&&(null===e&&null!==t||void 0===e&&void 0!==t||null===t&&null!==e||void 0===t&&void 0!==e))return!1;if(null==e||null==t)return null==e&&null==t;if(e===t)return!0;const r=typeof e;if(r===typeof t){switch(r){case"number":case"string":case"boolean":return e===t}switch(!0){case e instanceof Date&&t instanceof Date:return e.getTime()===t.getTime();case Array.isArray(e)&&Array.isArray(t):return e.length===t.length&&e.every(((e,i)=>U.isEqual(e,t[i],n)));case"object"===r&&e.constructor.prototype===t.constructor.prototype:return n?U.isDeeplyEqual(e,t,n):l.String.safeJsonStringify(e,"circular")===l.String.safeJsonStringify(t,"circular")}}return String(e)===String(t)}static isDeeplyEqual(e,t,n={}){if(e===t)return!0;if(!e||!t)return!1;const i=U.keys(e,n.ignore),r=U.keys(t,n.ignore);if(i.length!==r.length)return!1;for(let s=0;s<i.length;s++){const o=i[s],a=r[s];if(o!==a)return!1;const l=e[o],c=t[a];if(!n.shouldEvaluate||!1!==n.shouldEvaluate(o,{value:l,object:e},{value:c,object:t})){if(n.evaluate){const i=n.evaluate(o,{value:l,object:e},{value:c,object:t});if(!1===i)return!1;if(!0===i)continue}if(!U.isEqual(l,c,n))return!1}}return!0}static isPartial(e,t){return e=String(e).toLowerCase(),t=String(t).toLowerCase(),-1!==e.indexOf(t)}static isLessThan(e,t){return e instanceof Date&&t instanceof Date?l.Date.isBefore(e,t):e<t}static isMoreThan(e,t){return e instanceof Date&&t instanceof Date?l.Date.isAfter(e,t):e>t}static first(e,t){let n,i=t;if(e)if(e[Symbol.iterator])for(i of e)break;else if(e[Symbol.asyncIterator])i=(async(e,t)=>{let n=t;for await(n of e)break;return n})(e,t);else if(W.isObject(e))for(n in void 0===i&&(i=V),e){i=[n,e[n]];break}return i}static fork(e){let t,n,i;if(e&&e.constructor===Object)for(n in t=Object.setPrototypeOf({},e),e)i=e[n],i&&(i.constructor===Object?t[n]=U.fork(i):i instanceof Array&&(t[n]=i.slice()));else t=e;return t}static copyProperties(e,t,n){let i,r;for(r=0;r<n.length;r++)i=n[r],i in t&&(e[i]=t[i]);return e}static copyPropertiesIf(e,t,n){if(t)for(const i of n)!(i in e)&&i in t&&(e[i]=t[i]);return e}static entries(e,t){const n=[],i="function"==typeof t;if(e)for(const r in e)(i?t(r,e[r]):null!=t&&t[r])||n.push([r,e[r]]);return n}static fromEntries(e,t){if(t=t||{},e)for(let n=0;n<e.length;++n)t[e[n][0]]=e[n][1];return t}static keys(e,t,n){const i=[],r="function"==typeof t;if(e){let s=0;for(const o in e)(r?t(o,e[o]):null!=t&&t[o])||(i.push(n?n(o,s):o),++s)}return i}static values(e,t,n){const i=[],r="function"==typeof t;if(e){let s=0;for(const o in e)(r?t(o,e[o]):null!=t&&t[o])||(i.push(n?n(e[o],s):e[o]),++s)}return i}static pathExists(e,t){return t.split(".").every((t=>!(!e||!(t in e))&&(e=e[t],!0)))}static pathifyKeys(e,t){const n={};for(const i in e)if(z(e,i)){const r=null==t?void 0:t[i],s="object"===(null==r?void 0:r.type)||(null==r?void 0:r.complexMapping)||!Boolean(t);if(s&&Array.isArray(e[i]))n[i]=e[i].slice();else if(s&&e[i]instanceof Object){const t=this.pathifyKeys(e[i]);for(const e in t)n[`${i}.${e}`]=t[e]}else n[i]=e[i]}return n}static deletePath(e,t){t.split(".").reduce(((e,t,n,i)=>{if(null==e)return null;if(z(e,t)){if(n!==i.length-1)return e[t];delete e[t]}}),e)}static coerce(e,t){const n=b.typeOf(e),i=b.typeOf(t),r="string"==typeof e;if(n!==i)switch(i){case"string":return String(e);case"number":return Number(e);case"boolean":return!(r&&(!e||"false"===e||"0"===e))&&Boolean(e);case"null":return!(!r||e&&"null"!==e)&&null;case"undefined":return!(!r||e&&"undefined"!==e)&&void 0;case"date":return r&&isNaN(e)?l.Date.parse(e):Date(Number(e))}return e}static wrapProperty(e,t,n,i,r=!0){const s={};let o=Object.getPrototypeOf(e),a=Object.getOwnPropertyDescriptor(o,t);for(;!a&&o&&r;)o=Object.getPrototypeOf(o),o&&(a=Object.getOwnPropertyDescriptor(o,t));a?(a.set?s.set=t=>{a.set.call(e,t),i&&i.call(e,a.get.call(e))}:s.set=i,a.get?s.get=()=>{let t=a.get.call(e);return n&&(t=n.call(e,t)),t}:s.get=n):(s.set=n=>{e[`_${t}`]=n,i&&i.call(e,n)},s.get=()=>{let i=e[`_${t}`];return n&&(i=n.call(e,i)),i}),Object.defineProperty(e,t,s)}static hookProperty(e,t,n){const i=W.getPropertyDescriptor(n.prototype,"value"),r=W.getPropertyDescriptor(e,t),s=`_${t}`,o=class{get value(){return r?r.get.call(this):this[s]}set value(e){r?r.set.call(this,e):this[s]=e}},a=W.getPropertyDescriptor(o.prototype,"value");return Object.setPrototypeOf(n.prototype,o.prototype),Object.defineProperty(e,t,{configurable:!0,get:i.get||a.get,set:i.set||a.set}),()=>delete e[t]}static cleanupProperties(e,t=!1){return Object.entries(e).forEach((([n,i])=>{t?void 0===i&&delete e[n]:null==i&&delete e[n]})),e}static removeAllProperties(e){return Object.keys(e).forEach((t=>delete e[t])),e}static assertType(e,t,n){const i=b.typeOf(e);if(null!=e&&i!==t)throw new Error(`Incorrect type "${i}" for ${n}, expected "${t}"`)}static assertObject(e,t){U.assertType(e,"object",t)}static assertInstance(e,t){U.assertType(e,"instance",t)}static assertClass(e,t){U.assertType(e,"class",t)}static assertFunction(e,t){if("function"!=typeof e||e.isBase||e.$$name)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a function)`)}static assertNumber(e,t,n){const i=Number(e);if("number"!=typeof e||isNaN(i)||n&&e<0)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a ${n?"positive ":""}Number)`)}static assertBoolean(e,t){U.assertType(e,"boolean",t)}static assertString(e,t){U.assertType(e,"string",t)}static assertArray(e,t){U.assertType(e,"array",t)}static toFixed(e,t){return N?N(e,t):e.toFixed(t)}static roundTo(e,t=1){return Math.round(e/t)*t}static round(e,t){if(null==t)return e;const n=10**t;return Math.round(e*n)/n}static getMapPath(e,t,n){const i=Array.isArray(t)?t:"string"==typeof t?t.split("."):[t],r=1===i.length,s=i[0],o=e.has(s)?e.get(s):e.set(s,r?n:{}).get(s);return r?o:U.getPathDefault(o,i.slice(1),n)}}l.register(W);const U=W;W._$name="ObjectHelper";class G{static $name="VersionHelper";static setVersion(e,n){e=e.toLowerCase(),Y[e]={version:n,isNewerThan:e=>G.semanticCompareVersion(e,n,"<"),isOlderThan:e=>G.semanticCompareVersion(e,n,">")};let i="";i=`${t}.`;const r=`${i}${e}${n.replace(/\./g,"-")}`;if(d.isBrowserEnv&&!globalThis.bryntum.silenceBundleException)if(!0===globalThis.bryntum[r]){if(!this.isTestEnv){let t=i||e;"core"===t&&(t="grid");let n=H.capitalize(t);throw"schedulerpro"===t&&(n="SchedulerPro"),new Error(`The Bryntum ${n} bundle was loaded multiple times by the application.\n\nCommon reasons you are getting this error includes:\n\n* Imports point to different types of the bundle (e.g. *.module.js and *.umd.js)\n* Imports point to both sources and bundle\n* Imports do not use the shortest relative path, JS treats them as different files\n* Cache busters differ between imports, JS treats ${t}.module.js?1 and ${t}.module.js?2 as different files\n* Imports missing file type, verify they all end in .js\n\nSee https://bryntum.com/products/${t}/docs/guide/${n}/gettingstarted/es6bundle#troubleshooting for more information\n\n`)}globalThis.BUNDLE_EXCEPTION=!0}else globalThis.bryntum[r]=!0}static getVersion(e){if(e=e.toLowerCase(),!Y[e])throw new Error("No version specified! Please check that you import VersionHelper correctly into the class from where you call `deprecate` function.");return Y[e].version}static semanticCompareVersion(e,t,n="="){t=t||"";const i=(e=e||"").split(/[-.]/),r=t.split(/[-.]/),s=n.includes("<"),o=(e,t)=>{const n=["rc","beta","alpha"],i=e.map((e=>{if(n.includes(e))return-n.indexOf(e)-2;const t=Number.parseInt(e);return Number.isNaN(t)?-n.length:t}));for(;i.length<t;)i.push(-1);return i},a=()=>{const e=Math.max(i.length,r.length),t=o(i,e),n=o(r,e);for(let i=0;i<e;i++)if(t[i]!==n[i])return s?t[i]<n[i]:t[i]>n[i];return!0};switch(n){case"=":return e===t;case"<=":case">=":return e===t||a();case"<":case">":return e!==t&&a()}return!1}static checkVersion(e,t,n){return G.semanticCompareVersion(Y.getVersion(e),t,n)}static deprecate(e,t,n){if(!Y.checkVersion(e,t,"<"))throw new Error(`Deprecated API use. ${n}`);console.warn(`Deprecation warning: You are using a deprecated API which will change in v${t}. ${n}`)}static get isTestEnv(){var e;const t=Boolean(null===(e=globalThis.bryntum)||void 0===e?void 0:e.isTestEnv);try{var n;return t||Boolean(null===(n=globalThis.parent)||void 0===n||null===(n=n.bryntum)||void 0===n?void 0:n.isTestEnv)}catch(e){return t}}static get isDebug(){return!1}}const Y=G;d.isBrowserEnv&&(Y.isTestEnv&&(d._isHoverableDevice=!0),globalThis.bryntum=Object.assign(globalThis.bryntum||{},{getVersion:Y.getVersion.bind(Y),checkVersion:Y.checkVersion.bind(Y),deprecate:Y.deprecate.bind(Y),license:"9c07f388-a9e9-11ec-9e5c-d094663d5c88"})),l.register(G),G._$name="VersionHelper";const{defineProperty:q,getOwnPropertyDescriptor:K}=Reflect,{hasOwnProperty:X,toString:Z}=Object.prototype,J=Symbol("instanceProperties"),Q=Symbol("configuring"),ee=Symbol("lazyConfigValues"),te=Z.call(new Date),ne=/\s+/,ie=Object.hasOwn||((e,t)=>X.call(e,t)),re=(e,t)=>e===t||!(!e||!t||Z.call(e)!==te||Z.call(t)!==te)&&e.getTime()===t.getTime(),se=(e,t)=>(e.setHours(0,0,0,0),t&&e.setDate(e.getDate()+t),e),oe={now:()=>new Date,today:()=>se(new Date),tomorrow:()=>se(new Date,1),yesterday:()=>se(new Date,-1)},ae=(e,t)=>(e[t]=1,e),le=(e,t)=>function(){var n;return null===(n=this.configObserver)||void 0===n||n.get(e,this),t.call(this)};class ce{static get(e,t){const{cache:n}=this,i=n[e]||(n[e]=new ce(e));let r,s=i;return t&&(r=ce.makeCacheKey(e,t),(s=r&&n[r])||(s=i.extend(t),r&&(n[r]=s))),s}constructor(e){const t=this,n=e[0].toUpperCase()+e.substr(1);t.base=t,t.name=e,t.field="_"+e,t.capName=n,t.changer="change"+n,t.initializing="initializing"+n,t.updater="update"+n}get descriptor(){let e=this._descriptor;return e&&ie(this,"_descriptor")||(this._descriptor=e=this.makeDescriptor()),e}get initDescriptor(){let e=this._initDescriptor;return e&&ie(this,"_initDescriptor")||(this._initDescriptor=e=this.makeInitter()),e}convert(e,t){return e}equal(e,t){return e===t}extend(e){const t=Object.assign(Object.create(this),e),{convert:n,equal:i,merge:r}=e,{convertMethods:s,equalityMethods:o}=ce;return"string"==typeof n&&!(t.convert=s[n])&&n.endsWith("[]")&&(t.convert=s[n]=ce.makeArrayConvert(s[n.slice(0,-2)])),"string"==typeof i&&!(t.equal=o[i])&&i.endsWith("[]")&&(t.equal=o[i]=ce.makeArrayEquals(o[i.slice(0,-2)])),"string"==typeof r&&(t.merge=ce.mergeMethods[r]),t}define(e){const{name:t}=this,n=K(e,t);let i=this.descriptor;null!=n&&n.get&&(i=Object.assign({},i),i.get=le(t,n.get)),q(e,t,i)}defineInitter(e,t){const n=this,{name:i}=n,r=e[J];let s,o;r[i]||!(o=K(e,i))||"value"in o||(r[i]=o),q(e,i,n.initDescriptor),n.lazy&&(s=e[ee]||(e[ee]=new Map),s.set(i,t))}static makeArrayConvert(e){return function(t,n){return null!=t&&(t=Array.isArray(t)?t.map(((t,i)=>e.call(this,t,n))):[e.call(this,t,n)]),t}}static makeArrayEquals(e){return(t,n)=>{let i,r=t&&n&&t.length===(i=n.length);if(r&&Array.isArray(t)&&Array.isArray(n))if(e)for(;r&&i-- >0;)r=e(t[i],n[i]);else for(;r&&i-- >0;)r=t[i]===n[i];else r=e?e(t,n):t===n;return r}}static makeCacheKey(e,t){const n=Object.keys(t).sort();for(let e,i,r,s=n.length;s-- >0;)if(r=t[e=n[s]],null==r&&!1===r)n.splice(s,1);else{if(i=typeof r,"function"===i)return null;"string"===i?n[s]=`${e}:"${r}"`:"number"===i&&(n[s]=`${e}:${r}`)}return n.length?`${e}>${n.join("|")}`:e}makeDescriptor(){const{base:e,field:t,changer:n,updater:i,name:r}=this;return e!==this?e.descriptor:{get(){var e;return null===(e=this.configObserver)||void 0===e||e.get(r,this),this[t]},set(e){const s=this,o=s.$meta.configs[r];let a,l,c=s[t];if("string"==typeof e){let t=e;var d;if(e.startsWith("up."))t=null===(d=s.owner)||void 0===d?void 0:d.resolveProperty(e.slice(3));else e.startsWith("this.")&&(t=s.resolveProperty(e.slice(5)));void 0!==t&&"function"!=typeof t&&(e=t)}var u;(o.convert!==ue&&(e=o.convert(e,s)),s[n]&&(a=void 0===(l=s[n](e,c))&&1,a||(e=l,c=s[t])),a||(o.equal===he?c===e:o.equal(c,e)))||(s[t]=e,a=2,null===(u=s[i])||void 0===u||u.call(s,e,c));!a||s.isDestroyed||s.onConfigChange.$nullFn||s.onConfigChange({name:r,value:e,was:c,config:o,applied:a})}}}makeInitter(){const e=this;return e!==e.base?e.lazy?e.makeLazyInitter():e.base.initDescriptor:e.makeBasicInitter()}makeBasicInitter(){const e=this,{initializing:t,name:n}=e;return{configurable:!0,get(){const i=this;return e.removeInitter(i),i[t]=!0,i[n]=i[Q][n],i[t]=!1,i.configDone[n]=!0,i[n]},set(t){e.removeInitter(this),this.configDone[n]=!0,this[n]=t}}}makeLazyInitter(){const e=this,{initializing:t,name:n}=e;return{configurable:!0,get(){const i=this,r=i[ee].get(n);return e.removeInitter(i),i.isDestroying||(i[t]=!0,i[n]=r,i[t]=!1),i[n]},set(t){e.removeInitter(this),this[n]=t}}}removeInitter(e){const{name:t}=this,n=e[J][t],i=e[ee];n?q(e,t,n):delete e[t],null!=i&&i.delete(t)&&!i.size&&delete e[ee]}setDefault(e,t){q(e.prototype,this.field,{configurable:!0,writable:!0,value:t})}merge(e,t){if(t&&e&&b.isObject(e)){if(t.isBase)return t.setConfig(e);b.isObject(t)&&(e=b.merge(b.clone(t),e))}return e}}const{prototype:de}=ce,{convert:ue,equal:he}=de;ce.symbols={configuring:Q,instanceProperties:J,lazyConfigs:ee},ce.cache=Object.create(null),ce.convertMethods={array:ce.makeArrayConvert(ue),date(e,t){let n,i,r,s=e;if(oe[e])s=oe[e]();else if(null!=e){if("string"!=typeof e)n=new Date(e);else{if(r=this.formats,r)for(i of(r=r.flatMap((e=>e in t?t[e]:e)),r))if(n=i&&l.Date.parse(e,i),n)break;n||(n=l.Date.parse(e))}if(isNaN(n)){if(this.strict)throw new Error(`Invalid date: ${e}`)}else s=n}return s},day(e,t){var n;return null===(n=e=ce.convertMethods.date.call(this,e,t))||void 0===n||n.setMinutes(0,0,0),e}},ce.equalityMethods={array:ce.makeArrayEquals(),date:re,day:re,strict:ce.equal=he},ce.mergeMethods={distinct(e,t){let n=t?t.slice():[];if(null!=e)if(b.isObject(e))if(void 0===t)n=e;else{let t,i;for(t in e)i=n.indexOf(t),e[t]?i<0&&n.push(t):i>-1&&n.splice(i,1)}else Array.isArray(e)?e.forEach((e=>!n.includes(e)&&n.push(e))):n.includes(e)||n.push(e);return n},merge:ce.merge=de.merge,classList(e,t){if("string"==typeof e){if(!e.length)return t;e=e.split(ne)}return Array.isArray(e)&&(e=e.reduce(ae,{})),ce.merge(e,t)},objects:(e,t)=>!0===e?t||{}:ce.merge(e,t),replace:e=>e,items:(e,t,n,i)=>i?b.mergeItems(t,e,{merge:(e,t)=>de.merge(t,e)}):de.merge(e,t)},Object.assign(de,{_descriptor:null,_initDescriptor:null,date:!1,lazy:!1,nullify:!1,render:!1}),ce._$name="Config";class ge{constructor(e,t,n,i){const r=this;let s,o;for(s in r.destroyed=!1,r.mapFwd={},r.mapRev={},r.source=e,r.syncing=!1,r.target=t,r.sourceHook=l.Function.after(e,"onConfigChange",(e=>r.onConfigChange(e,!0)),r,Me),r.targetHook=null!=i&&i.oneway?null:l.Function.after(t,"onConfigChange",(e=>r.onConfigChange(e,!1)),r,Me),n)o=n[s],o&&("string"!=typeof o&&(o=s),r.mapFwd[s]=o,r.mapRev[o]=s);r.unbind=r.destroy.bind(r),r.unbind.binding=r}destroy(){var e,t;this.destroyed||(this.destroyed=!0,null===(e=this.sourceHook)||void 0===e||e.call(this),null===(t=this.targetHook)||void 0===t||t.call(this))}onConfigChange(e,t){const n=this;(t?n.mapFwd:n.mapRev)[e.name]&&n.sync(t)}sync(e){e=!1!==e;const t=this,[n,i,r]=e?[t.source,t.target,t.mapFwd]:[t.target,t.source,t.mapRev];if(!t.syncing&&!n.isDestroying&&!i.isDestroying){let e,s,o,a,l,c,d=0;for(s in t.syncing=!0,r)a=r[s],o=n[s],o!==i[a]&&(++d,(e||(e={}))[l=a]=c=o);d>1?i.setConfig(e):d&&(i[l]=c),t.syncing=!1}}}class me{constructor(e){e&&Object.assign(this,e)}getInherited(e,t=!0){let n=this[e];var i;e in this||(n=null===(i=this.super)||void 0===i?void 0:i.getInherited(e,t),(n||t)&&(this[e]=n=Object.create(n||null),fe(n,"$meta",{value:this})));return n}}const{getPrototypeOf:pe}=Object,{defineProperty:fe}=Reflect,ve=(e=>(t,n)=>e.call(t,n))(Object.prototype.hasOwnProperty),ye=Symbol("classMetaData"),be=Symbol("mixinTag"),Ce=Symbol("originalConfig"),Se=ce.symbols.configuring,De=ce.symbols.instanceProperties,we=ce.symbols.lazyConfigs,Ee={merge:"replace",simple:!0},Re=e=>l.Object.clone(e),xe=()=>{},Te=e=>l.Object.isObject(e),Me={return:!1},Ie={},Ae=Object.freeze({}),ke=Object.freeze([]),Fe=/^(date|day)(\[])?$/;class Pe{static get isBase(){return!0}get isBase(){return!0}static get declarable(){return["declarable","configurable","defaultConfig","properties","prototypeProperties"]}constructor(...e){const t=this,n=t.constructor;t.$meta.class!==n&&(n.$meta.initialized=!0),t.construct(...e),t.afterConstruct(),t.isConstructing=!1}static new(...e){return new this(e=(e=e.filter((e=>e))).length>1?this.mergeConfigs(...e):e[0])}construct(...e){null!==e[0]&&this.configure(...e),this.afterConfigure()}static destroy(...e){const t=e=>{null!=e&&e.destroy?e.destroy():Array.isArray(e)&&e.forEach(t)};t(e)}destroy(){const e=this,{id:t}=e;e.isDestroying=!0,e.destroy=xe,e.doDestroy(),Object.setPrototypeOf(e,null);for(const t in e)"destroy"!==t&&"isDestroying"!==t&&delete e[t];delete e[Ce],e.isDestroyed=!0,e.id=t}_thisIsAUsedExpression(e){}static get $$name(){return ve(this,"$name")&&this.$name||ve(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}startConfigure(e){}finishConfigure(e){}afterConfigure(){}afterConstruct(){}callback(e,t,n=ke){const{handler:i,thisObj:r}=this.resolveCallback(e,"this"===t?this:t)||Ae;return null==i?void 0:i.apply(r,n)}resolveProperty(e){let t=this;for(;t;){if(Pe.hasConfigPath(t,e,!0))return l.Object.getPath(t,e);t=t.owner}}resolveCallback(e,t=this,n=!0){var i;if(null!==(i=e)&&void 0!==i&&i.substring){if(e.endsWith("?")&&(n=!1,e=e.substring(0,e.length-1)),e.startsWith("up.")){for(e=e.substring(3),t=this.owner;t&&!t[e];t=t.owner);if(!t)return}else e.startsWith("this.")&&(e=e.substring(5),t=this);if(!(t&&t instanceof Object))return;e=t[e]}if("function"==typeof e)return{handler:e,thisObj:t};if(n)throw new Error(`No method named ${e} on ${t.$$name||"thisObj object"}`)}bindCallback(e,t=this){if(e){const{handler:n,thisObj:i}=this.resolveCallback(e,t);if(n)return n.bind(i)}}delay(e,t,n=e.name||e){e=this.setTimeout?e:e.bind(this);return(this.setTimeout?this:globalThis)["number"==typeof t?"setTimeout":"requestAnimationFrame"](e,t,n)}doDestroy(){const e=this,{nullify:t}=e.$meta;if(t)for(let n=0;n<t.length;++n)null!=e[t[n].field]&&(e[t[n].name]=null)}destroyProperties(...e){const t=this;let n;for(n of e){var i,r,s;if(n in t&&(!t[Se]||!t[Se][n]))null===(i=t[n])||void 0===i||null===(r=(s=i).destroy)||void 0===r||r.call(s),delete t[n]}}configure(e={}){const t=this,n=t.$meta,{beforeConfigure:i}=t.initialConfig=e,{configs:r}=n,s=t.getDefaultConfiguration();let o,a,l;for(a in t.isConfiguring=!0,Object.assign(t,t.getProperties()),e)l=e[a],o=r[a],s[a]=o?o.merge(l,s[a],null,n):l;i&&(delete s.beforeConfigure,i(t,s)),t.setConfig(t[Ce]=s,!0),t.isConfiguring=!1}bindConfigs(e,t,n){const i=new ge(this,e,t,n);return!1!==(null==n?void 0:n.sync)&&i.sync(),i.unbind}getConfig(e,...t){const n=this[e];return t.length?[n,...t.map((e=>this[e]))]:n}setConfig(e,t=!1){const n=this,i=n[Se],r=i?n.configDone:n.configDone={},s=n.$meta.configs,o=n[we];let a,l;for(l in n[De]={},n[Se]=i?Object.setPrototypeOf(Object.assign({},e),i):e,e)null!==e[l]||ve(e,l)?(a=s[l]||ce.get(l),null!=o&&o.has(l)||a.defineInitter(n,e[l]),t||(r[l]=!1)):r[l]=!0;for(l in t&&n.startConfigure(e),e){var c;r[l]||t&&null!==(c=s[l])&&void 0!==c&&c.lazy||(n[l]=e[l])}return i?n[Se]=i:delete n[Se],t&&n.finishConfigure(e),n}hasConfig(e){var t;const n=this,i=n[Se];return Boolean(null!=n["_"+e]||null!=(null===(t=n[we])||void 0===t?void 0:t.get(e))||!n.configDone[e]&&i&&(null!=i[e]||ve(i,e)))}static hasConfigPath(e,t){return t.split(".").every((t=>{var n,i;const r=null===(n=e)||void 0===n||null===(n=n.$meta)||void 0===n||null===(n=n.configs)||void 0===n?void 0:n[t];return!!(r&&r.descriptor.get===(null===(i=l.Object.getPropertyDescriptor(e,t))||void 0===i?void 0:i.get)?e.hasConfig(t):t in e)&&(e=e[t],void 0!==Object)}))}peekConfig(e){const t=this,n=t[we],i=t[Se];if(null!=n&&n.has(e))return n.get(e);if(i&&e in i){if(t.configDone[e])return t[e];if(null!=i[e]||ve(i,e))return i[e]}}triggerConfig(e){const t=this,{configDone:n}=t,i=t[we],r=t[Se],s=null!=i&&i.has(e)||r&&(null!=r[e]||ve(r,e))?!n[e]:null;return s&&t.getConfig(e),s}triggerConfigs(e){const t=this,n=t.$meta.configs,i=t[we],r=i?[...i.keys()].filter((t=>n[t].lazy===e)):ke;for(const e of r)t.triggerConfig(e);return r.length?r:null}onConfigChange(){}get config(){const e={},t=this[Ce];for(const n in t)e[n]=t[n];return e}static processConfigValue(e,t){if(e===globalThis)return globalThis;if(Array.isArray(e))return e.map((e=>Pe.processConfigValue(e,t)));if(e instanceof Pe){if(t.visited.has(e))return;return e.getCurrentConfig(t)}if(e instanceof HTMLElement||e instanceof DocumentFragment)return null;if(Te(e)){const n={};for(const i in e)"owner"!==i&&(n[i]=Pe.processConfigValue(e[i],t));return n}return e}getConfigValue(e,t){var n;const i=this,r=i[we];return null!==(n=i.$meta.configs[e])&&void 0!==n&&n.lazy?null!=r&&r.has(e)?Pe.processConfigValue(r.get(e),t):void 0:Pe.processConfigValue(i[e],t)}preProcessCurrentConfigs(){}getCurrentConfig(e={}){const t=this,n="all"===e.configs?t.config:Re(t.initialConfig),i=e.skip||{},r=e.visited||(e.visited=new Set),s=e.depth||(e.depth=0),o={};if(!r.has(t)){r.add(t),this.preProcessCurrentConfigs(n);for(const r in n){if(i[r])continue;const n=t.getConfigValue(r,{...e,depth:s+1});void 0!==n&&(o[r]=n)}return o}}getConfigString(e={}){return l.String.toJavaScriptString(this.getCurrentConfig(e))}getTestCase(e={}){const t=this.isGantt?"Gantt":this.isSchedulerPro?"SchedulerPro":this.isCalendar?"Calendar":this.isScheduler?"Scheduler":this.isGrid?"Grid":this.isTaskBoard?"TaskBoard":null;if(t){const n=t.toLowerCase(),i=`../../build/${n}.module.js`;let r,s;"static"===e.import?(r=`import * as module from "${i}";Object.assign(window, module);`,s=""):(r=`import("${i}").then(module => { Object.assign(window, module);\n`,s="});");const o=G.getVersion(n);return o&&(r+=`\nconsole.log('${t} ${o}');\n`),`${r}      \nconst ${n} = new ${t}(${this.getConfigString(e)});\n${s}`}}downloadTestCase(e={}){e.output="return";const t=this.getTestCase(e);l.Browser.download("app.js","data:application/javascript;charset=utf-8,"+escape(t))}static initClass(){return this.$meta.class}static get $meta(){if(!ve(this,ye)){const e=this[ye]=new me;return e.class=this,this.setupClass(e),e}return this[ye]}static onClassMixedIn(){}static mergeConfigs(e,...t){const n=this.$meta.configs,i=Re(e)||{};let r,s,o,a;for(s=0;s<t.length;++s)if(r=t[s],r)for(o in r)a=r[o],n[o]?a=n[o].merge(a,i[o]):i[o]&&a&&(a=ce.merge(a,i[o])),i[o]=a;return i}static mixin(...e){let t,n=this;for(t=0;t<e.length;++t){const i=e[t],r=i[be]||(i[be]=Symbol("mixinTag"));n[r]||(n=i(n),n[r]=!0,ve(n,"onClassMixedIn")&&n.onClassMixedIn())}return n}static setupClass(e){var t;const n=e.class,i=pe(n).$meta,r=n.$$name,s=i.names,o=n.prototype;if(fe(o,"$meta",{value:e}),Object.assign(e,{super:i,config:Object.create(i.config),configs:Object.create(i.configs),declarables:i.declarables,forkConfigs:i.forkConfigs,hierarchy:Object.freeze([...i.hierarchy,n]),names:s.includes(r)?s:Object.freeze([...s,r]),properties:i.properties,nullify:null===(t=i.nullify)||void 0===t?void 0:t.slice()}),s!==e.names){const e=`is${r}`,t=t=>{ve(t,e)||fe(t,e,{get:()=>!0})};t(o),t(n)}for(let t,i,r=0;r<e.declarables.length;++r)t=e.declarables[r],ve(n,t)&&(i=Ie[t]||(Ie[t]=`setup${l.String.capitalize(t)}`),n[i](n,e))}static setupConfigs(e,t,n){const i=e.config,r=e.configs,s=e.class,o=e.super;let a,c,d,u,h,g,{nullify:m}=e;for(const p in t)h=t[p],n?(a=r[p])?h=a.merge(h,i[p],e,o):a=ce.get(p,Ee):(c=d=u=void 0,h&&"object"==typeof h&&"$config"in h&&(d=h.$config,Fe.test(String(d))&&(d={type:d}),d&&(Te(d)?d.type&&(d={convert:d.type,equal:d.type,...d},delete d.type):d=l.Object.createTruthyKeys(d)),u="default"in h,c=u?h.default:c,h="value"in h?h.value:null),(a=r[p])?(g=a.nullify,d&&(a=a.extend(d)),h=a.merge(h,i[p],e,o)):(a=ce.get(p,d),a.define(s.prototype),u=!(a.field in s.prototype),g=!1),u&&a.setDefault(s,c),a.nullify&&!g&&(m||(m=e.nullify||(e.nullify=[]))).push(a)),h&&(Te(h)||Array.isArray(h))&&!Object.isFrozen(h)&&(e.forkConfigs=!0),r[p]=a,i[p]=h}static setupConfigurable(e,t){e.setupConfigs(t,e.configurable,!1)}static setupDefaultConfig(e,t){e.setupConfigs(t,e.defaultConfig,!0)}static setupDeclarable(e,t){const n=e.declarable;let i,r,s=t.declarables;for(r=0;r<n.length;++r)s.includes(n[r])||(i||(t.declarables=i=s=s.slice()),s.push(n[r]))}static setupProperties(e,t){t.properties=t.super.properties.slice(),t.properties.push(e),Object.freeze(t.properties)}static setupPrototypeProperties(e){Object.assign(e.prototype,e.prototypeProperties)}static fork(e){let t,n,i=e;if(e&&Te(e)&&!Object.isFrozen(e))for(t in i=Object.create(e),e)n=e[t],n&&(Te(n)?i[t]=Pe.fork(n):Array.isArray(n)&&(i[t]=n.slice()));return i}static getDefaultConfiguration(){return this.$meta.class.prototype.getDefaultConfiguration()}getDefaultConfiguration(){const e=this.$meta,t=e.forkConfigs?Pe.fork(e.config):Object.create(e.config);if(G.isTestEnv&&l.Browser.isBrowserEnv&&t.testConfig&&globalThis.__applyTestConfigs)for(const e in t.testConfig)t[e]=t.testConfig[e];return t}getProperties(){const e=this.$meta.properties,t={};for(let n=0;n<e.length;n++){const i=Object.getOwnPropertyDescriptor(e[n],"properties");Object.assign(t,void 0!==i.get?e[n].properties:Re(i.value))}return t}static get superclass(){return pe(this)}classHierarchy(e){const t=this.$meta.hierarchy,n=e?t.indexOf(e):0;return n>0?t.slice(n):t}static isOfTypeName(e){return this.$meta.names.includes(e)}detachListeners(e){var t;let n=this.$detachers;if(n=null===(t=n)||void 0===t?void 0:t[e],n)for(;n.length;)n.pop()()}trackDetacher(e,t){const n=this.$detachers||(this.$detachers={});(n[e]||(n[e]=[])).push(t)}untrackDetachers(e){const t=this.$detachers;if(t)for(const n in t){const i=t[n];for(let t=i.length;t-- >0;)i[t].eventer===e&&i.splice(t,1)}}}const Oe=Pe.prototype;var Le;Oe.onConfigChange.$nullFn=xe.$nullFn=!0,Pe[ye]=Oe.$meta=(Le={class:Pe,config:Object.freeze({}),configs:Object.create(null),declarables:Pe.declarable,forkConfigs:!1,hierarchy:Object.freeze([Pe]),names:Object.freeze(["Base"]),nullify:null,properties:Object.freeze([]),super:null},new me(Le)),Object.assign(Oe,{$detachers:null,configObserver:null,isConstructing:!0,isDestroyed:!1,isDestroying:!1}),Pe.emptyFn=xe,G.setVersion("core","6.0.5"),Pe._$name="Base";class $e{static $name="ArrayHelper";static clean(e){return e.reduce(((e,t)=>(null==t||Array.isArray(t)&&0===t.length||""===t||e.push(t),e)),[])}static from(e,t,n){const i=[];if(e)for(const r of e)t&&!t(r)||i.push(n?n(r):r);return i}static remove(e,...t){let n,i,r=!1;t=t[0]instanceof Set?[...t[0]]:t;for(let s=0;s<t.length;s++)i=t[s],-1!==(n=e.indexOf(i))&&(e.splice(n,1),r=!0);return r}static findInsertionIndex(e,t,n=this.lexicalCompare,i){const r=t.length;let s,o;return i<r&&(s=i>0?n(t[i-1],e):0,o=i<r-1?n(e,t[i]):0,s<1&&o<1)?i:this.binarySearch(t,e,n)}static findLast(e,t,n){for(let{length:i}=e,r=i-1;r>=0;r--)if(t.call(n,e[r],r,e))return e[r]}static binarySearch(e,t,n=0,i=e.length,r=this.lexicalCompare){const s=e.length;let o,a;for(n instanceof Function?(r=n,n=0):i instanceof Function&&(r=i,i=s),--i;n<=i;)o=n+i>>1,a=r(t,e[o]),a>=0?n=o+1:a<0&&(i=o-1);return n}magnitudeCompare(e,t){return e<t?-1:e>t?1:0}lexicalCompare(e,t){return(e=String(e))<(t=String(t))?-1:e>t?1:0}static fill(e,t={},n=null){const i=[],r=Array.isArray(t)?t:[t];for(let t=0;t<e;t++)for(const e of r){const r=Object.assign({},e);n&&n(r,t),i.push(r)}return i}static populate(e,t,n=!1){const i=[];for(let r=0;r<e;r++)i.push(t(r+(n?1:0)));return i}static include(e,...t){for(const n of t)e.includes(n)||e.push(n)}static unique(e){return[...new Set(e)]}static allowNegative(e){return new Proxy(e,{get(e,t,n){if("string"!=typeof t)return Reflect.get(e,t,n);const i=Number(t);return Number.isNaN(i)?Reflect.get(e,t,n):e[i<0?e.length+i:i]},set(e,t,n,i){if("string"!=typeof t)return Reflect.set(e,t,n,i);const r=Number(t);return Number.isNaN(r)?Reflect.set(e,t,n,i):(e[r<0?e.length+r:r]=n,!0)}})}static delta(e,t,n=!1){if(!t)return n?{toAdd:e,toRemove:[],toKeep:[]}:{onlyInA:e,onlyInB:[],inBoth:[]};const i=[],r=[],s=new Set,o=new Set(t);for(let t=0;t<e.length;t++){const n=e[t];o.has(n)?s.add(n):i.push(n)}for(let e=0;e<t.length;e++){const n=t[e];s.has(n)||r.push(n)}return n?{toAdd:i,toRemove:r,toKeep:s}:{onlyInA:i,onlyInB:r,inBoth:[...s]}}static asArray(e){return null==e?e:e instanceof Set?Array.from(e):Array.isArray(e)?e:[e]}static identity(e){return e}static keyBy(e,t,n=$e.identity){const i="string"==typeof t?e=>null==e?void 0:e[t]:t,r="string"==typeof n?e=>null==e?void 0:e[n]:n;return e.reduce(((e,t)=>(e[i(t)]=r(t),e)),{})}static aggregate(e,t,n,i,r={}){const s=e.length,o=e[0].length,a=[];r.targetArray=a,r.arrays=e;for(let e=0;e<o;e++)r.entryIndex=e,a.push(i(e,r));for(let i=0;i<s;i++){const s=e[i];r.rowIndex=i;for(let e=0;e<o;e++){r.entryIndex=e;const o=t(s[e],r);a[e]=n(a[e],o,i,e,r)}}return a}static groupBy(e,t){const n="string"==typeof t?e=>null==e?void 0:e[t]:t;return e.reduce(((e,t)=>{const i=n(t);return(e[i]=e[i]||[]).push(t),e}),{})}static groupByIndexed(e,t){return e.reduce(((e,n)=>{const i=t(n);let r=e.get(i);return void 0===r&&(r=new Set,e.set(i,r)),r.add(n),e}),new Map)}}l.register($e),$e._$name="ArrayHelper";const _e=/,\s*/,je=Symbol("decompiled"),Be=/^\s*(async\s+)?([a-z_]\w*)\s*=>([\s\S]+)$/i,He=/^\s*(async\s*)?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)\s+=>([\s\S]+)$/i,Ve=/^(\s*async)?(?:\s*function)?(?:\s*([a-z_]\w*))?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)([\s\S]+)$/i,{hasOwnProperty:ze}=Object.prototype;class Ne{static $name="FunctionHelper";static after(e,t,n,i,r){const s="string"==typeof n,o=!1!==(null==r?void 0:r.return),a=(...t)=>{const r=a.$nextHook.call(e,...t),l=null!=i&&i.isDestroyed?void 0:o?s?i[n](r,...t):n.call(i,r,...t):s?i[n](...t):n.call(i,...t);return void 0===l?r:l};return Ne.hookMethod(e,t,a)}static before(e,t,n,i){const r="string"==typeof n,s=(...t)=>{const o=null!=i&&i.isDestroyed?0:r?i[n](...t):n.call(i,...t);return!1===o?o:s.$nextHook.call(e,...t)};return Ne.hookMethod(e,t,s)}static curry(e){return function t(...n){return n.length>=e.length?e.apply(this,n):function(...e){return t.apply(this,n.concat(e))}}}static bindAll(e){for(const t in e)"function"==typeof e[t]&&(e[t]=e[t].bind(e))}static createInterceptor(e,t,n){return function(...i){const r=n||this;return!1!==t.call(r,...i)&&e.call(r,...i)}}static createSequence(e,t,n){return(...i)=>{const r=e.call(n,...i),s=t.call(n,...i);return void 0===s?r:s}}static createThrottled(e,t,n,i,r){let s,o,a=-Number.MAX_VALUE;const l=()=>{o=0,a=performance.now(),s.push.apply(s,i),e.apply(n,s)},c=function(...e){const c=performance.now()-a;s=e,c>=t?(clearTimeout(o),l()):(o||(o=setTimeout(l,t-c)),r&&(s.push.apply(s,i),r.apply(n,s)))};return c.cancel=()=>clearTimeout(o),c}static createBuffered(e,t,n,i){let r,s;const o=()=>{s=0,a.isPending=!1,r.push.apply(r,i),e.apply(n,r)},a=function(...e){r=e,s&&clearTimeout(s),a.isPending=!0,s=setTimeout(o,t)};return a.cancel=()=>{a.isPending=!1,clearTimeout(s)},a}static decompile(e){if(!(je in e)){var t,n;const i=e.toString();let r,s,o,a,l,c=Be.exec(i);c?(r=[c[2]],s=c[3]):(c=He.exec(i))?(l=c[2].trim(),r=l?l.split(_e):[],s=c[3]):(c=Ve.exec(i))&&(o=c[2],l=c[3].trim(),r=l?l.split(_e):[],s=c[4]),s=null===(t=s)||void 0===t?void 0:t.trim(),e[je]=a=c&&{args:r,async:Boolean(c[1]),body:null!==(n=s)&&void 0!==n&&n.startsWith("{")?s.substring(1,s.length-1).trim():s},o&&(a.name=o)}return e[je]}static hookMethod(e,t,n){return n.$nextHook=e[t],e[t]=n,()=>{if(ze.call(e,t)){let s,o=e[t];var i;if(o===n)(null===(i=Object.getPrototypeOf(e))||void 0===i?void 0:i[t])===n.$nextHook?delete e[t]:e[t]=n.$nextHook;else for(;s=null===(r=o)||void 0===r?void 0:r.$nextHook;o=s){var r;if(s===n){o.$nextHook=n.$nextHook;break}}}}}static noThrow(e,t,n){const i=e[t];e[t]=(...t)=>{try{return i.apply(e,t)}catch(e){return null==n?void 0:n(e)}}}static returnTrue(){return!0}static animate(e,t,n,i="linear"){let r=!1;const s=new Promise((s=>{const o=performance.now(),a=()=>{const l=Math.min((performance.now()-o)/e,1),c=n&&n.setTimeout?n:globalThis;r||!1===t.call(n,this.easingFunctions[i](l))&&s(),r||1===l?c.requestAnimationFrame((()=>s())):c.requestAnimationFrame(a)};a()}));return s.cancel=()=>(r=!0,s.cancelled=!0,!1),s}}l.register(Ne);const We=.5,Ue=1.70158,Ge=7.5625,Ye=1.525,qe=2/2.75,Ke=2.25/2.75,Xe=1/2.75,Ze=1.5/2.75,Je=2.5/2.75,Qe=2.625/2.75,et=.75,tt=.9375,nt=.984375;Ne.easingFunctions={linear:e=>e,easeInQuad:e=>Math.pow(e,2),easeOutQuad:e=>-(Math.pow(e-1,2)-1),easeInOutQuad:e=>(e/=We)<1?We*Math.pow(e,2):-.5*((e-=2)*e-2),easeInCubic:e=>Math.pow(e,3),easeOutCubic:e=>Math.pow(e-1,3)+1,easeInOutCubic:e=>(e/=We)<1?We*Math.pow(e,3):We*(Math.pow(e-2,3)+2),easeInQuart:e=>Math.pow(e,4),easeOutQuart:e=>-(Math.pow(e-1,4)-1),easeInOutQuart:e=>(e/=We)<1?We*Math.pow(e,4):-.5*((e-=2)*Math.pow(e,3)-2),easeInQuint:e=>Math.pow(e,5),easeOutQuint:e=>Math.pow(e-1,5)+1,easeInOutQuint:e=>(e/=We)<1?We*Math.pow(e,5):We*(Math.pow(e-2,5)+2),easeInSine:e=>1-Math.cos(e*(Math.PI/2)),easeOutSine:e=>Math.sin(e*(Math.PI/2)),easeInOutSine:e=>-.5*(Math.cos(Math.PI*e)-1),easeInExpo:e=>0===e?0:Math.pow(2,10*(e-1)),easeOutExpo:e=>1===e?1:1-Math.pow(2,-10*e),easeInOutExpo:e=>0===e?0:1===e?1:(e/=We)<1?We*Math.pow(2,10*(e-1)):We*(2-Math.pow(2,-10*--e)),easeInCirc:e=>-(Math.sqrt(1-e*e)-1),easeOutCirc:e=>Math.sqrt(1-Math.pow(e-1,2)),easeInOutCirc:e=>(e/=We)<1?-.5*(Math.sqrt(1-e*e)-1):We*(Math.sqrt(1-(e-=2)*e)+1),easeOutBounce:e=>e<Xe?Ge*e*e:e<qe?Ge*(e-=Ze)*e+et:e<Je?Ge*(e-=Ke)*e+tt:Ge*(e-=Qe)*e+nt,easeInBack:e=>e*e*((Ue+1)*e-Ue),easeOutBack:e=>(e-=1)*e*((Ue+1)*e+Ue)+1,easeInOutBack:e=>{let t=1.70158;return(e/=We)<1?We*(e*e*((1+(t*=Ye))*e-t)):We*((e-=2)*e*((1+(t*=Ye))*e+t)+2)},elastic:e=>-1*Math.pow(4,-8*e)*Math.sin((6*e-1)*(2*Math.PI)/2)+1,swingFromTo:e=>{let t=1.70158;return(e/=We)<1?We*(e*e*((1+(t*=Ye))*e-t)):We*((e-=2)*e*((1+(t*=Ye))*e+t)+2)},swingFrom:e=>e*e*((Ue+1)*e-Ue),swingTo:e=>(e-=1)*e*((Ue+1)*e+Ue)+1,bounce:e=>e<Xe?Ge*e*e:e<qe?Ge*(e-=Ze)*e+et:e<Je?Ge*(e-=Ke)*e+tt:Ge*(e-=Qe)*e+nt,bouncePast:e=>e<Xe?Ge*e*e:e<qe?2-(Ge*(e-=Ze)*e+et):e<Je?2-(Ge*(e-=Ke)*e+tt):2-(Ge*(e-=Qe)*e+nt),easeFromTo:e=>(e/=We)<1?We*Math.pow(e,4):-.5*((e-=2)*Math.pow(e,3)-2),easeFrom:e=>Math.pow(e,4),easeTo:e=>Math.pow(e,.25)},Ne._$name="FunctionHelper";const{isArray:it}=Array,{hasOwnProperty:rt}=Object.prototype,st={thisObj:1,detachable:1,once:1,detacher:1,prio:1,args:1,expires:1,buffer:1,throttle:1,name:1,$internal:1},ot=(e,t)=>t.prio-e.prio;var at=e=>class t extends(e||Pe){eventsSuspended=null;static $name="Events";static get declarable(){return["deprecatedEvents"]}static setupDeprecatedEvents(e,t){const n=t.getInherited("deprecatedEvents"),i=e.deprecatedEvents;for(const e in i)n[e.toLowerCase()]=n[e]=i[e]}static get configurable(){return{listeners:{value:null,$config:{merge(e,t){if(null!==e){if(!e)return t;t&&(e=e?[e]:[]).push[it(t)?"apply":"call"](e,t)}return e}}},internalListeners:null,bubbleEvents:null}}destroy(){this.trigger("beforeDestroy"),super.destroy()}construct(e,...t){var n;(this.configuredListeners=null===(n=e)||void 0===n?void 0:n.listeners)&&delete(e=b.assign({},e)).listeners,super.construct(e,...t),this.processConfiguredListeners()}processConfiguredListeners(){if(this.configuredListeners){const e=this,{isConfiguring:t}=e;e.isConfiguring=!1,e.listeners=e.configuredListeners,e.configuredListeners=null,e.isConfiguring=t}}doDestroy(){this.trigger("destroy"),this.removeAllListeners(!1),super.doDestroy()}static setupClass(e){super.setupClass(e),t.prototype.onListen.$nullFn=!0,t.prototype.onUnlisten.$nullFn=!0}addListener(e,t,n){if(it(e)){for(let n=0,{length:i}=e;n<i;n++)this.addListener(e[n],t);return}const i=this,r=i.$meta.getInherited("deprecatedEvents");if("string"==typeof e)return i.addListener({[e]:t,detachable:!1!==t.detachable,thisObj:n});{t=e.thisObj=void 0!==e.thisObj?e.thisObj:t;for(const n in e)if(!st[n]&&null!=e[n]){const o=n.toLowerCase(),a=null==r?void 0:r[o],l=i.eventListeners||(i.eventListeners={}),c=$e.asArray(e[n]);if(a){const{product:e,invalidAsOfVersion:t,message:n}=a;G.deprecate(e,t,n)}for(const r of c){var s;const a=r.expires||e.expires,c={fn:"object"==typeof r?r.fn:r,thisObj:void 0!==r.thisObj?r.thisObj:t,args:r.args||e.args,prio:void 0!==r.prio?r.prio:void 0!==e.prio?e.prio:0,once:void 0!==r.once?r.once:void 0!==e.once&&e.once,buffer:r.buffer||e.buffer,throttle:r.throttle||e.throttle,$internal:e.$internal,catchAll:"catchAll"===n};if(a){const{alt:r}=a,s=r?a.delay:a,l=e.name||n,d=()=>{i.un(o,c),r&&!c.called&&i.callback(r,t)};i.isDelayable?i.setTimeout({fn:d,name:l,cancelOutstanding:!0,delay:s}):globalThis.setTimeout(d,s)}let d=l[o]||(l[o]=[]);d.$firing&&(l[o]=d=d.slice()),d.splice($e.findInsertionIndex(c,d,ot,d.length),0,c),!i.onListen.$nullFn&&d.length<2&&i.onListen(o),null===(s=i.afterAddListener)||void 0===s||s.call(i,o,c)}}e.relayAll&&i.relayAll(e.relayAll),t&&t!==i&&i.attachAutoDetacher(e,t);const n=!1!==e.detachable,a=e.name,l=e.expires||n||a?()=>{i.isDestroyed||i.removeListener(e,t)}:null;var o;if(l)if(l.eventer=i,l.listenerName=a,a&&null!==(o=t)&&void 0!==o&&o.trackDetacher&&t.trackDetacher(a,l),e.expires&&i.delay(l,isNaN(e.expires)?e.expires.delay:e.expires,a),n)return l}}on(e,t,n){return this.addListener(e,t,n)}ion(e){return e.$internal=!0,this.on(e)}un(...e){this.removeListener(...e)}updateInternalListeners(e,t){null==t||t.detach(),e&&(e.detach=this.ion(e))}get listeners(){return this.eventListeners}changeListeners(e){if(!this.isConfiguring){if(Array.isArray(e))for(let t=0,n=e[0],{length:i}=e;t<i;n=e[++t])"thisObj"in n||(e[t]=b.assign({thisObj:this},n));else e&&!("thisObj"in e)&&(e=b.assign({thisObj:this},e));return e}this.getConfig("internalListeners"),e&&this.on(e,this)}updateListeners(e,t){t&&this.un(t),e&&this.on(e)}removeListener(e,t=e.thisObj,n){const i=this;if("string"==typeof e)return i.removeListener({[e]:t},n);Object.entries(e).forEach((([e,n])=>{if(!st[e]&&null!=n){e=e.toLowerCase();const{eventListeners:s}=i,o=i.findListener(e,n,t);if(o>=0){var r;let t=s[e];null===(r=i.afterRemoveListener)||void 0===r||r.call(i,e,t[o]),t.length>1?(t.$firing&&(s[e]=t=t.slice()),t.splice(o,1)):(delete s[e],i.onUnlisten.$nullFn||i.onUnlisten(e))}}})),e.thisObj&&!e.thisObj.isDestroyed&&i.detachAutoDetacher(e)}findListener(e,t,n){var i;const r=null===(i=this.eventListeners)||void 0===i?void 0:i[e],s=t.fn||t,o=t.thisObj||n;if(r)for(let e,t=0,{length:n}=r;t<n;t++)if(e=r[t],e.fn===s&&e.thisObj===o)return t;return-1}hasListener(e){var t;return Boolean(null===(t=this.eventListeners)||void 0===t?void 0:t[null==e?void 0:e.toLowerCase()])}relayAll(e,t,n=!0){this.relayAllTargets||(this.relayAllTargets=[]);const{relayAllTargets:i}=this;e.ion({beforeDestroy:({source:t})=>{if(t===e){i.filter((t=>t.through===e)).forEach((e=>$e.remove(i,e)))}}}),i.push({through:e,prefix:t,transformCase:n})}removeAllListeners(e=!0){const t=this.eventListeners;let n,i;for(const a in t){const l=t[a];for(n=l.length;n-- >0;){const t=l[n];var r,s,o;if(!t.$internal||!e)this.removeListener(a,t),i=t.thisObj,null===(r=i)||void 0===r||null===(s=(o=r).untrackDetachers)||void 0===s||s.call(o,this)}}}relayEvents(e,t,n="",i){const r={detachable:!0,thisObj:this};return t.forEach((e=>{n&&(e=H.capitalize(e)),r[e]=(t,...r)=>(i&&(t=Object.assign({},t,{source:this})),this.trigger(n+e,t,...r))})),e.on(r)}onListen(){}onUnlisten(){}destructorInterceptor(){const{autoDetachers:e,target:t,oldDestructor:n}=this;for(let n=0;n<e.length;n++){const{dispatcher:i,config:r}=e[n];i.isDestroyed||i.removeListener(r,t)}n.call(t)}attachAutoDetacher(e,t){const n=e.thisObj||t,i="doDestroy"in n?"doDestroy":"destroy";if(i in n){let{$autoDetachers:t}=n;t||(n.$autoDetachers=t=[]),n.$oldDestructor||(n.$oldDestructor=n[i],n[i]=this.destructorInterceptor.bind({autoDetachers:t,oldDestructor:n.$oldDestructor,target:n})),t.push({config:e,dispatcher:this})}else n[i]=()=>{this.removeListener(e)}}detachAutoDetacher(e){const t=e.thisObj;t.$oldDestructor&&!t.isDestroying&&($e.remove(t.$autoDetachers,t.$autoDetachers.find((t=>t.config===e&&t.dispatcher===this))),t.$autoDetachers.length||(t["doDestroy"in t?"doDestroy":"destroy"]=t.$oldDestructor,t.$oldDestructor=null))}once(e,t){return this.ion({[e]:()=>this.callback(t),once:!0})}await(e,t={checkLog:!0,resetLog:!0,args:null}){const n=this;!1===t&&(t={checkLog:!1});const{args:i}=t;return new Promise((r=>{var s;if(t.checkLog&&null!==(s=n._triggered)&&void 0!==s&&s[e]&&(r(),t.resetLog&&n.clearLog(e)),i){const s=n.on({[e]:(...o)=>{("function"==typeof i?i(...o):Object.keys(i).every((e=>e in o[0]&&o[0][e]===i[e])))&&(r(...o),t.resetLog&&n.clearLog(e),s())},prio:-1e4})}else n.on({[e]:(...i)=>{r(...i),t.resetLog&&n.clearLog(e)},prio:-1e4,once:!0})}))}clearLog(e){this._triggered&&(e?delete this._triggered[e]:this._triggered={})}trigger(e,t){var n,i,r,s,o;const a=this,l=e.toLowerCase(),{eventsSuspended:c,relayAllTargets:d,callOnFunctions:u}=a;let h,g,m=null===(n=a.eventListeners)||void 0===n?void 0:n[l];if(a._triggered||(a._triggered={}),a._triggered[e]=!0,c)return c.shouldQueue&&c.queue.push(arguments),!0;if(null!==(i=a.eventListeners)&&void 0!==i&&i.catchall&&((m=m?m.slice():[]).push(...a.eventListeners.catchall),m.sort(ot)),!m&&!d&&!u)return!0;if(t?"source"in t||(Object.isExtensible(t)?t.source=a:t=Object.setPrototypeOf({source:a},t)):t={source:a},t.type!==l&&(t.constructor!==Object?Reflect.defineProperty(t,"type",{get:()=>l}):t.type=l),t.eventName=e,!("bubbles"in t)&&null!==(r=a.bubbleEvents)&&void 0!==r&&r[e]&&(t.bubbles=a.bubbleEvents[e]),u){const n="on"+H.capitalize(e);if(n in a){var p;const e=!a[n]||a.callback(a[n],a,[t]);let i;if(b.isPromise(e)?(h||(h=[])).push(e):i=!1===e||i,!a.isDestroyed&&rt.call(a,n)&&(null===(p=a.pluginFunctionChain)||void 0===p||!p[n])){const e=Object.getPrototypeOf(a);if(n in e){const r=e[n].call(a,t);if(b.isPromise(r)?(h||(h=[])).push(r):i=!1===r||i,a.isDestroyed)return}}if(i)return!1}}if(m){let e=0,n=!1;for(m.$firing=!0;e<m.length&&!a.isDestroyed&&!n;e++){const i=m[e];if(!1===g&&!i.$internal)continue;let r,s=i.thisObj;if(!s||!s.isDestroyed){if(i.called=!0,i.once&&a.removeListener(l,i),"string"==typeof i.fn){if(s&&(r=s[i.fn]),!r){const e=a.resolveCallback(i.fn);r=e.handler,s=e.thisObj}}else r=i.fn;if(i.buffer){if(!i.bufferFn){const e=Number(i.buffer);if("number"!=typeof e||isNaN(e))throw new Error(`Incorrect type for buffer, got "${e}" (expected a Number)`);i.bufferFn=Ne.createBuffered(r,e,s,i.args)}r=i.bufferFn}if(i.throttle){const e=Number(i.throttle);if("number"!=typeof e||isNaN(e))throw new Error(`Incorrect type for throttle, got "${e}" (expected a Number)`);i.throttledFn||(i.throttledFn=Ne.createThrottled(r,e,s,i.args)),r=i.throttledFn}const e=r.call(s||a,...i.args||[],t);!1!==g&&(g=e),i.$internal&&!1===e&&(n=!0),b.isPromise(e)&&(e.$internal=i.$internal,(h||(h=[])).push(e))}}if(m.$firing=!1,n)return!1}return null==d||d.forEach((n=>{let i=e;if(n.transformCase&&(i=H.capitalize(i)),n.prefix&&(i=n.prefix+i),!1===n.through.trigger(i,t))return!1})),t.bubbles&&a.owner&&!a.owner.isDestroyed?a.owner.trigger(e,t):(h=null===(s=h)||void 0===s?void 0:s.filter((e=>!1!==g||e.$internal)),null!==(o=h)&&void 0!==o&&o.length?new Promise((e=>{Promise.all(h).then((t=>{const n=!t.some((e=>!1===e));e(n)}))})):!1!==g)}suspendEvents(e=!1){(this.eventsSuspended||(this.eventsSuspended={shouldQueue:e,queue:[],count:0})).count++}resumeEvents(){const e=this.eventsSuspended;if(e&&0==--e.count&&(this.eventsSuspended=null,e.shouldQueue))for(const t of e.queue)this.trigger(...t);return!Boolean(this.eventsSuspended)}};class lt{static animationFrame(){return new Promise((e=>{requestAnimationFrame(e)}))}static sleep(e){return new Promise((t=>{setTimeout((()=>{t()}),e)}))}static yield(){return Promise.resolve()}}let ct;lt._$name="AsyncHelper";const dt=["border-top-width","border-right-width","border-bottom-width","border-left-width"],ut=["margin-top","margin-right","margin-bottom","margin-left"],ht=["padding-top","padding-right","padding-bottom","padding-left"],gt="border-top-width",mt="border-right-width",pt="border-bottom-width",ft="border-left-width",vt="padding-top",yt="padding-right",bt="padding-bottom",Ct="padding-left",St=/^([trblc])(\d*)-([trblc])(\d*)$/i,Dt=/^([trblc])(\d*)$/i,wt=["top","right","bottom","left"],Et={t:0,r:1,b:2,l:3},Rt=["b-t","l-r","t-b","r-l"],xt={bt:1,tb:1,lr:2,rl:2},Tt=Object.freeze([0,0]),Mt=["width","height"],It=(e,t=e,n=e,i=t)=>Array.isArray(e)?It.apply(null,e):[e,t,n,i],At=(e,t,n,i)=>Array.isArray(e)?It.apply(null,e):"number"==typeof e.top?[e.top,e.right,e.bottom,e.left]:[e,t,n,i],kt=(e,t)=>{const n=St.exec(e),i=n[1],r=n[3],s=parseInt(n[2]||50),o=parseInt(n[4]||50),a=!t||1&Et[i]?s:100-s,l=!t||1&Et[r]?o:100-o;return{myAlignmentPoint:i+a,myEdge:i,myOffset:a,targetAlignmentPoint:r+l,targetEdge:r,targetOffset:l,startZone:Et[r],edgeAligned:xt[i+r]}},Ft=e=>`${wt[(Et[e.myEdge]+2)%4][0]}${e.myOffset}-${wt[(Et[e.targetEdge]+2)%4][0]}${e.targetOffset}`;class Pt{isRectangle=!0;static from(e,t,n){var i,r;if("string"==typeof e?e=document.querySelector(e):(null===(i=e)||void 0===i?void 0:i.nodeType)===Node.DOCUMENT_FRAGMENT_NODE&&(e=e.host||e.ownerDocument),"string"==typeof t&&(t=document.querySelector(t)),null==e||e.isRectangle)return e;if(e=e.element||e,void 0===n&&"boolean"==typeof t&&(n=t,t=null),null===(r=t)||void 0===r||!r.isRectangle)if(t){let{scrollLeft:e,scrollTop:n}=t;d.isSafari&&t===document.body&&(e=n=0),t=Pt.from(t).translate(-e,-n)}else ct||(ct=new Pt(0,0,0,0)),t=ct;const s=e===document||e===globalThis,o=e===document.body&&0===document.body.offsetHeight,a=o&&e.getBoundingClientRect(),l=o?new Pt(a.left,a.top,a.width,document.body.parentElement.scrollHeight):s?new Pt(0,0,globalThis.innerWidth,globalThis.innerHeight):e.getBoundingClientRect(),c=n||s?[0,0]:[globalThis.pageXOffset,globalThis.pageYOffset];return new Pt(l.left+c[0]-t.x,l.top+c[1]-t.y,l.width,l.height)}static fromScreen(e,t){return Pt.from(e,t,!0)}static inner(e,t,n=!1){const i=this.from(e,t,n);if(document.body.contains(e)){const t=Wn.getStyleValue(e,dt);i.x+=parseFloat(t[ft]),i.y+=parseFloat(t[gt]),i.right-=parseFloat(t[mt]),i.bottom-=parseFloat(t[pt])}return i}static content(e,t,n=!1){const i=this.from(e,t,n);if(document.body.contains(e)){const t=Wn.getStyleValue(e,dt),n=Wn.getStyleValue(e,ht);i.x+=parseFloat(t[ft])+parseFloat(n[Ct]),i.y+=parseFloat(t[gt])+parseFloat(n[vt]),i.right-=parseFloat(t[mt])+parseFloat(n[yt]),i.bottom-=parseFloat(t[pt])+parseFloat(n[bt])}return i}static client(e,t,n=!1,i,r){const s=this.content(e,t,n),o=Wn.scrollBarWidth;let a;return o&&!e.classList.contains("b-hide-scroll")&&(e.scrollHeight>e.clientHeight&&"hidden"!==Wn.getStyleValue(e,"overflow-y")&&(a=parseFloat(Wn.getStyleValue(e,"padding-right")),s.right+=a-Math.max(a,o)),e.scrollWidth>e.clientWidth&&"hidden"!==Wn.getStyleValue(e,"overflow-x")&&(a=parseFloat(Wn.getStyleValue(e,"padding-bottom")),s.bottom+=a-Math.max(a,o))),i&&this.clipStickies(s,e,t,n=!1,r),s}static clipStickies(e,t,n,i=!1,r){let s=[...t.children].filter((e=>"sticky"===Wn.getStyleValue(e,"position")));if(r){const e=r&&Pt.from(r,n,i);s=s.filter((t=>!t.contains(r)&&e.intersect(Pt.from(t))))}for(let t=0,{length:n}=s;t<n;t++){const n=s[t],i=this.fromScreen(n);0===parseFloat(Wn.getStyleValue(n,"left"))?e.x+=i.width:0===parseFloat(Wn.getStyleValue(n,"right"))?e.right-=i.width:0===parseFloat(Wn.getStyleValue(n,"top"))?e.y+=i.height:0===parseFloat(Wn.getStyleValue(n,"bottom"))&&(e.bottom-=i.height)}return e}static outer(e,t,n=!1){const i=this.from(e,t,n);if(document.body.contains(e)){const t=Wn.getStyleValue(e,ut);i.x-=parseFloat(t["margin-left"]),i.y-=parseFloat(t["margin-top"]),i.right+=parseFloat(t["margin-right"]),i.bottom+=parseFloat(t["margin-bottom"])}return i}static union(...e){let t,{x:n,y:i,right:r,bottom:s}=e[0];if(e.length>1)for(let o=1;o<e.length;o++)t=e[o],t.x<n&&(n=t.x),t.y<i&&(i=t.y),t.right>r&&(r=t.right),t.bottom>s&&(s=t.bottom);return new Pt(n,i,r-n,s-i)}roundPx(e=globalThis.devicePixelRatio||1){const t=this;return t._x=Wn.roundPx(t._x,e),t._y=Wn.roundPx(t._y,e),t._width=Wn.roundPx(t._width,e),t._height=Wn.roundPx(t._height,e),t}static get $$name(){return hasOwnProperty.call(this,"$name")&&this.$name||hasOwnProperty.call(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}constructor(e,t,n,i,r=!0){r&&(W.assertNumber(e,"Rectangle.x"),W.assertNumber(t,"Rectangle.y"),W.assertNumber(n,"Rectangle.width",!0),W.assertNumber(i,"Rectangle.height",!0));const s=this;n<0&&(e+=n,n=-n),i<0&&(t+=i,i=-i),s._x=e,s._y=t,s._width=n,s._height=i}clone(){const e=this,t=new Pt(e.x,e.y,e.width,e.height,!1);return t.isAlignRectangle=e.isAlignRectangle,t.minHeight=e.minHeight,t.minWidth=e.minWidth,t}contains(e){const t=this;return!!e.isRectangle&&(e._x>=t._x&&e._y>=t._y&&e.right<=t.right&&e.bottom<=t.bottom)}intersect(e,t=!1,n=!1){const i=this,r=Math.max(i.y,e.y),s=Math.min(i.right,e.right),o=Math.min(i.bottom,e.bottom),a=Math.max(i.x,e.x);return!!(n?o>=r&&s>=a:o>r&&s>a)&&(!!t||new Pt(a,r,s-a,o-r))}equals(e,t=!1){const n=t?e=>Math.round(e):e=>e;return e.isRectangle&&n(e.x)===n(this.x)&&n(e.y)===n(this.y)&&n(e.width)===n(this.width)&&n(e.height)===n(this.height)}translate(e,t){return this._x+=e||0,this._y+=t||0,this}moveTo(e,t){return null!=e&&(this._x=e),null!=t&&(this._y=t),this}getDelta(e){return[e.x-this.x,e.y-this.y]}get center(){const e=new Ot(this.x+this.width/2,this.y+this.height/2,0,0);return e.target=this.target,e}set x(e){const t=e-this._x;this._x=e,this._width-=t}get x(){return this._x}get start(){return this.left}set left(e){this.x=e}get left(){return this.x}set top(e){this.y=e}get top(){return this.y}set y(e){const t=e-this._y;this._y=e,this._height-=t}get y(){return this._y}set width(e){W.assertNumber(e,"Rectangle.width",!this._allowNegative),this._width=e}get width(){return this._width}set height(e){W.assertNumber(e,"Rectangle.height",!this._allowNegative),this._height=e}get height(){return this._height}set right(e){this._width=e-this._x}get right(){return this._x+this._width}get end(){return this.right}set bottom(e){this._height=e-this._y}get bottom(){return this._y+this._height}getStart(e,t=!0){return t?e?this.right:this.left:this.top}getEnd(e,t=!0){return t?e?this.left:this.right:this.bottom}get area(){return this.width*this.height}set minWidth(e){const t=this;isNaN(e)?t._minWidth=null:(t._minWidth=Number(e),t.isAlignRectangle||(t.width=Math.max(t.width,t._minWidth)))}get minWidth(){return this._minWidth}set minHeight(e){const t=this;isNaN(e)?t._minHeight=null:(t._minHeight=Number(e),t.isAlignRectangle||(t.height=Math.max(t.height,t._minHeight)))}get minHeight(){return this._minHeight}adjust(e,t,n,i,r){const s=this;return s._allowNegative=r,s.x+=e,s.y+=t,s.width+=n,s.height+=i,s}inflate(e,t=e,n=e,i=t){return[e,t,n,i]=At(e,t,n,i),this.adjust(-i,-e,t,n)}deflate(e,t=e,n=e,i=t){return[e,t,n,i]=At(e,t,n,i),this.adjust(i,e,-t,-n)}constrainTo(e,t){const n=this,i=n.height,r=n.y,s=n.minWidth||n.width,o=n.minHeight||n.height;if(n.height>=e.height){if(t&&o>e.height)return!1;n._y=e.y,n.height=e.height}if(n.width>=e.width){if(t&&s>e.width)return n.y=r,n.height=i,!1;n._x=e.x,n.width=e.width}return n.translate.apply(n,n.constrainVector=[Math.min(e.right-n.right,0),Math.min(e.bottom-n.bottom,0)]),n.translate(Math.max(e.x-n.x,0),Math.max(e.y-n.y,0)),n}alignTo(e){let t,n,i,r,s=this.clone(),{target:o,constrainTo:a,constrainPadding:l}=e;if(o&&!o.isRectangle&&(o=Pt.from(o.element?o.element:o)),a){if(!a.isRectangle){r=a===globalThis||a===document;const t="ignorePageScroll"in e?e.ignorePageScroll:!r;a=Pt.from(a.element?a.element:a,null,t)}l&&(l=It(l),l[0]=Math.min(l[0],o.top),l[1]=Math.min(l[1],a.right-o.right),l[2]=Math.min(l[2],a.bottom-o.bottom),l[3]=Math.min(l[3],o.left),a=a.deflate.apply(a.clone(),l))}const c=this,d=null==(R=e.offset)?Tt:"number"==typeof R?[R,R]:R,{align:u,axisLock:h,anchorSize:g,anchorPosition:m,matchSize:p,position:f,rtl:v}=e,y=o&&o.width<2&&o.height<2,b=kt(u,v),C=a&&a.clone(),S=[],D=[{zone:n=b.startZone,align:u}],w=p&&Mt[1&b.startZone],E=c[w];var R;if(w&&h?s[w]="min"===p?Math.max(s.width,o[w]):o[w]:!b.edgeAligned&&p&&(s.width=o.width,s.height=o.height),a&&s.constrainTo(a),a&&null!=b.startZone)if(h)D.push({zone:n=(n+2)%4,align:Ft(b)}),"flexible"===h&&(D.push({zone:n=(b.startZone+1)%4,align:Rt[n]}),D.push({zone:n=(n+2)%4,align:Rt[n]}));else for(let e=1;e<4;e++)D.push({zone:n=(n+1)%4,align:Rt[n]});if(m){const e=1&b.startZone?"y":"x";t={[e]:m[e],edge:wt[(b.startZone+2)%4]}}if(C&&o&&(C.adjust(-o.width,-o.height,o.width,o.height),o.constrainTo(C)),s.minWidth=c.minWidth,s.minHeight=c.minHeight,f)s.moveTo(f.x,f.y),s.translate.apply(s,d),a&&s.constrainTo(a);else{const e="c"===b.myEdge||"c"===b.targetEdge,n=g&&!e?[g[1]+d[0],g[1]+d[1]]:d,l=o.getAlignmentPoint(b.targetAlignmentPoint),u=o.getAlignmentPoint(b.targetAlignmentPoint,n);let m=s.getAlignmentPoint(b.myAlignmentPoint),p=!y&&s.clone().translate(l[0]-m[0],l[1]-m[1]).intersect(o,!0);if(s.translate(u[0]-m[0],u[1]-m[1]),p)s.translate(-(u[0]-m[0]),-(u[1]-m[1])),m=s.getAlignmentPoint(b.myAlignmentPoint),s.translate(l[0]-m[0],l[1]-m[1]),s.translate(...n),a&&s.constrainTo(a),i=b.startZone;else if(a&&!a.contains(s)){const e=s.clone(),l=[];let d,u;t=null,S[0]=d=a.clone(),d.bottom=o.y-n[1],S[1]=d=a.clone(),d.x=o.right+n[0],S[2]=d=a.clone(),d.y=o.bottom+n[1],S[3]=d=a.clone(),d.right=o.x-n[0];for(let e=0;e<D.length;e++){if(w&&2===e&&(s[w]=E),d=S[i=D[e].zone],s=s.alignTo({target:o,offsets:n,align:D[e].align}),s.constrainTo(d,!0)&&(l.push({result:s,zone:i}),!u||s.width<c.width||s.height<c.height)){s.align=D[e].align;break}if(!u||d.area>u.area){const e=s.clone();switch(i){case 0:e.moveTo(null,d.bottom-e.height);break;case 1:e.moveTo(d.left);break;case 2:e.moveTo(null,d.top);break;case 3:e.moveTo(d.right-e.width)}u={area:d.area,result:e,zone:i}}}l.length?(l.length>1&&!h&&l.sort(((t,n)=>Math.sqrt((e.x-t.result.x)**2+(e.y-t.result.y)**2)-Math.sqrt((e.x-n.result.x)**2+(e.y-n.result.y)**2))),s=l[0].result,i=l[0].zone):(s=u.result,i=u.zone,r&&s.constrainTo(a))}else i=b.startZone;if(s.overlap=p=!y&&s.intersect(o,!0),s.zone=i,g&&!p){if(!t){const e=1&i,n=e?"y":"x",r=e?"bottom":"right",a=Math.max(o[n],s[n]);let l=a+(Math.min(o[r],s[r])-a)/2-g[0]/2;const c=l+g[0];c>s[r]&&(l-=c-s[r]),l<s[n]&&(l+=s[n]-l),t={[n]:l-s[n],edge:wt[(i+2)%4]}}s.anchor=t}}return s}getAlignmentPoint(e,t=Tt){e=String(e);const n=this,i=Dt.exec(e)||St.exec(e),r=i&&i[1].toLowerCase(),s=i&&Math.min(Math.max(parseInt(i[2]||50),0),100)/100;switch(r){case"t":return[n.x+n.width*s,n.y-t[1]];case"r":return[n.right+t[0],n.y+n.height*s];case"b":return[n.x+n.width*s,n.bottom+t[1]];case"l":return[n.x-t[0],n.y+n.height*s];case"c":return[n.x+n.width/2,n.y+n.height/2]}}highlight(){const e=this,t=Wn.createElement({parent:document.body,style:`position:absolute;z-index:9999999;pointer-events:none;\n                            left:${e.x}px;top:${e.y}px;width:${e.width}px;height:${e.height}px`});return Wn.highlight(t).then((()=>t.remove()))}visualize(e,t){const n=this,i=W.merge({style:{"inset-inline-start":`${n.x}px`,top:`${n.y}px`,width:`${n.width}px`,height:`${n.height}px`,pointerEvents:"none",...e.class?{}:{position:"absolute","z-index":9999999}}},e);return t?i:Wn.createElement(i)}toString(e=","){return[`${this.top}px`,`${this.right}px`,`${this.bottom}px`,`${this.left}px`].join(e)}}class Ot extends Pt{static from(e,t=!0){const n=t?"client":"screen";e.changedTouches&&(e=e.changedTouches[0]);return new this(e[`${n}X`],e[`${n}Y`])}constructor(e,t){super(e,t,0,0)}constrain(e){return this.x=Math.min(Math.max(this.x,e.x),e.right-1),this.y=Math.min(Math.max(this.y,e.y),e.bottom-1),this}toArray(){return[this.x,this.y]}}Pt._$name="Rectangle";const Lt=Symbol("value"),$t=Symbol("length");class _t{static change(e,t,n,i="string"){n=_t.normalize(n,"object");const r=_t.normalize(e,"array").filter((e=>!n[e]));if(t){t=_t.normalize(t,"array");for(let e=0;e<t.length;++e)r.includes(t[e])||r.push(t[e])}return _t.normalize(r,i)}static from(e,t){return e&&(e.isDomClassList?t=t??!0:(t=t??(b.isObject(e)&&!b.isEmpty(e)),e=new _t(e)),e.value||t||(e=null)),e||(t?new _t:null)}static normalize(e,t="string"){const n=typeof(e=e||""),i="array"===t,r=!i&&!("object"===t);let s,o,a,l="string"===n;var c;"object"===n&&(e.nodeType===Element.ELEMENT_NODE&&"function"==typeof e.getAttribute?(e=e.getAttribute("class")||"",l=!0):null!==(c=e)&&void 0!==c&&c.isDomClassList?e=e.values:e instanceof DOMTokenList?e=Array.from(e):e instanceof Map?e=Array.from(e.keys()).filter((t=>e.get(t))):e instanceof Set?e=Array.from(e):Array.isArray(e)||(e=b.getTruthyKeys(e)));for(l&&(e=[...new Set(H.split(e))]),o=e.length;o-- >0;)s=e[o],s.length?s.includes(" ")&&e.splice(o,1,...H.split(s)):e.splice(o,1);if(i)a=e;else if(r)a=e.join(" ");else for(a=Object.create(null),o=0;o<e.length;++o)a[e[o]]=!0;return a}constructor(...e){this.process(1,e)}clear(){for(const e in this)this[e]=!1;return this}set(...e){return this.clear().process(1,e)}get isDomClassList(){return!0}clone(){return new _t(this)}contains(e){return!("string"!=typeof e||!e)&&Boolean(this[e])}toString(){return this.length?`${this.value} `:""}toJSON(){return this.toString()}trim(){return this.value}isEqual(e){const t=_t.normalize(e,"array"),n=t.length;if(this.length===n){for(let e=0;e<n;e++)if(!this[t[e]])return!1;return!0}return!1}get value(){let e,t=this[Lt];return null==t&&(e=b.getTruthyKeys(this),this[$t]=e.length,this[Lt]=t=e.join(" ")),t}set value(e){const t=this,n=Object.keys(t),i=n.length;for(let e=0;e<i;e++)delete t[n[e]];e?t.process(1,[e]):delete t[Lt]}get values(){return b.getTruthyKeys(this)}get length(){return this.value?this[$t]:0}process(e,t){for(let n,i,r=0;r<t.length;r++)if(t[r])if(n=t[r],n.isDomClassList||b.isObject(n))for(i in n)this[i]=e?n[i]:!n[i];else for(n=_t.normalize(t[r],"array"),i=0;i<n.length;++i)this[n[i]]=e;return delete this[Lt],this}assign(e){for(const t in e)!this[t]!=!e[t]&&(this[t]=e[t],delete this[Lt]);return this}assignTo(e){const t=e.nodeType===Element.ELEMENT_NODE?e.classList:e,n=_t.from(t);n.add(this),t.value=n.value}add(...e){return this.process(1,e)}remove(...e){return this.process(0,e)}toggle(e,t=Boolean(!this[e])){if(t=Boolean(t),Boolean(this[e])!==t)return this[e]=t,delete this[Lt],!0}split(){return b.getTruthyKeys(this)}forEach(e){return b.getTruthyKeys(this).forEach(e)}}_t.prototype[Lt]=null,_t._$name="DomClassList";const jt=["clientX","clientY","pageX","pageY","screenX","screenY"],Bt={element:1,thisObj:1,once:1,delegate:1,delay:1,capture:1,passive:1,throttled:1,autoDetach:1,expires:1,block:1,raw:1,fromGlobal:1},Ht={Spacebar:"Space",Del:"Delete",Esc:"Escape",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown"},Vt={Control:"ctrl",Alt:"alt",Shift:"shift",Meta:"meta"},zt=/^(ctrl|shift|alt|meta)$/,Nt=["altKey","bubbles","button","buttons","cancelable","clientX","clientY","ctrlKey","layerX","layerY","metaKey","pageX","pageY","returnValue","screenX","screenY","shiftKey"],Wt=Object.fromEntries("abcdefghijklmnopqrstuvwxyz".split("").map((e=>[e,e.toUpperCase()]))),Ut=((...e)=>e.reduce(((e,t)=>{for(let n=0,i=e.length;n<i;++n)e.push(n?`${e[n]}+${t}`:t);return e}),[""]))("Ctrl","Alt","Meta","Shift"),Gt=e=>Ut[(e.ctrlKey&&1)|(e.altKey&&2)|(e.metaKey&&4)|(e.shiftKey&&8)],{isSafari:Yt}=d,qt=new WeakMap,Kt=e=>(null==e?void 0:e.nodeType)===Element.TEXT_NODE?e.parentElement:e;class Xt{static $name="EventHelper";static eventNameMap={mousedown:"MouseDown",mouseup:"MouseUp",click:"Click",dblclick:"DblClick",contextmenu:"ContextMenu",mouseenter:"MouseEnter",mouseleave:"MouseLeave",mousemove:"MouseMove",mouseover:"MouseOver",mouseout:"MouseOut",keyup:"KeyUp",keydown:"KeyDown",keypress:"KeyPress"};static normalizeEvent(e){return W.copyPropertiesIf(e,e.changedTouches[0]||e.touches[0],jt)}static copyEvent(e,t){return W.copyProperties(e,t,Nt)}static getXY(e){return e.touches&&(e=e.touches[0]),[e.clientX,e.clientY]}static getDistanceBetween(e,t,n){const i=Zt.getXY(e),r=Zt.getXY(t),s=i[0]-r[0],o=i[1]-r[1];return null!=n&&n.x?s:null!=n&&n.y?o:Math.sqrt(Math.pow(s,2)+Math.pow(o,2))}static getPagePoint(e){return new Ot(e.pageX,e.pageY)}static getClientPoint(e){return new Ot(e.clientX,e.clientY)}static addListener(e,t,n,i){return i=e.nodeType?"string"==typeof t?Object.assign({element:e,[t]:n},i):Object.assign({element:e},t):e,Zt.on(i)}static on(e){const t=e.element,n=e.thisObj,i=[];for(const n in e)if(!Bt[n]){let r=e[n];"object"!=typeof r&&(r={handler:r});const s=r.element||t;i.push(Zt.addElementListener(s,n,r,e))}const r=()=>{for(let e,t=0;t<i.length;t++)e=i[t],Zt.removeEventListener(e[0],e[1],e[2]);i.length=0};return n&&!1!==e.autoDetach&&(n.doDestroy=Ne.createInterceptor(n.doDestroy,r,n)),r}static addElementListener(e,t,n,i){const r=Zt.createHandler(e,t,n,i),{spec:s}=r,o=n.expires||i.expires,a=null!=s.capture||null!=s.passive?{capture:s.capture,passive:s.passive}:void 0;if(e.addEventListener(t,r,a),o){const s=n.thisObj||i.thisObj,a=null!=s&&s.isDelayable?s:globalThis,{alt:l}=o,c=l?o.delay:o,{spec:d}=r;d.expires=o,d.timerId=a["number"==typeof c?"setTimeout":"requestAnimationFrame"]((()=>{d.timerId=null,Zt.removeEventListener(e,t,r),l&&!r.called&&("string"==typeof l?s[l]:l).call(s)}),c,`listener-timer-${performance.now()}`)}return[e,t,r,a]}static getComposedPathTarget(e){var t;return e.composedPath()[0]||(null===(t=e.path)||void 0===t?void 0:t[0])}static fixEvent(e,t){var n;if(e.isBryntumEvent)return e;if(qt.has(e))return qt.get(e);const{ctrlKey:i,metaKey:r,type:s,target:o}=e,a=this.getComposedPathTarget(e),l="open"===(null==a||null===(n=a.getRootNode)||void 0===n||null===(n=n.call(a))||void 0===n?void 0:n.mode),c={set:(e,t,n)=>t in e?Reflect.set(e,t,n):(c[t]=n,!0),get(e,t){switch(t){case"fixed":case"isBryntumEvent":return!0;case"key":return Ht[e.key]||e.key;case"code":return" "!==e.key||e.code?e.code:"Space";case"ctrlKey":return d.isMac&&r!==i?r:i;case"metaKey":return d.isMac&&r!==i?i:r;case"virtualKey":return(e=>{const t=[Gt(e)],{code:n,key:i}=e;return t[t[0]?1:0]=null!=n&&n.includes("Numpad")?n:Wt[i]||i,t.join("+")})(u);case"virtualModKeys":return Gt(u);case"borderOffsetX":return isNaN(e.offsetX)?void 0:e.offsetX+(Yt?0:parseInt(o.ownerDocument.defaultView.getComputedStyle(Kt(o)).getPropertyValue("border-left-width")));case"borderOffsetY":return isNaN(e.offsetY)?void 0:e.offsetY+(Yt?0:parseInt(o.ownerDocument.defaultView.getComputedStyle(Kt(o)).getPropertyValue("border-top-width")));case"target":return l?a:Kt(e.target);case"relatedTarget":return Kt(e.relatedTarget);case"originalTarget":return o;case"deepTarget":return a;case"currentTarget":return c.delegatedTarget||e.currentTarget;case"browserEvent":return e;default:if(t in e){const n=Reflect.get(e,t);return"function"==typeof n?n.bind(e):n}return c[t]}},has:(e,t)=>t in e||t in c},u=new Proxy(e,c);if(qt.set(e,u),s.startsWith("touch")&&this.normalizeEvent(u),!t)switch(s){case"keydown":ti.currentKeyDown=u;break;case"mousedown":ti.currentMouseDown=u;break;case"pointerdown":ti.currentPointerDown=u;break;case"touchstart":ti.currentTouch=u}return u}static createHandler(e,t,n,i){const r=n.delay||i.delay,s=n.throttled||i.throttled,o=n.block||i.block,a="once"in n?n.once:i.once,l="capture"in n?n.capture:i.capture,c="passive"in n?n.passive:i.passive,d="delegate"in n?n.delegate:i.delegate,u="fromGlobal"in n?n.fromGlobal:i.fromGlobal,h=n.handler,g=n.expires,m=n.thisObj||i.thisObj;let p=(e,...t)=>{Zt.playingDemo&&e.isTrusted||null!=m&&m.isDestroyed||(p.called=!0,("string"==typeof h?m[h]:h).call(m,Zt.fixEvent(e,u),...t))};if(o){const e=p;let t,n;p=(i,...r)=>{const s=performance.now();(!t||i.target!==n||s-t>o)&&(n=i.target,t=s,e(i,...r))}}if(null!=r){const e=p,t=null!=m&&m.setTimeout?m:globalThis;p=(...n)=>{t.setTimeout((()=>{e(...n)}),r)}}if(null!=s){let e,t=s;s.buffer&&(e=e=>s.alt.call(Zt,Zt.fixEvent(e,u)),t=s.buffer),p=null!=m&&m.isDelayable?m.throttle(p,{delay:t,throttled:e}):Ne.createThrottled(p,t,m,null,e)}if(a){const n=p;p=(...i)=>{Zt.removeEventListener(e,t,p),n(...i)}}if(d){const e=p;p=(t,...n)=>{var i,r;const s=null===(i=(r=(t=Zt.fixEvent(t,u)).target).closest)||void 0===i?void 0:i.call(r,d);s&&(t.delegatedTarget=s,e(t,...n))}}return n.thisObj&&!1!==n.autoDetach&&(m.doDestroy=Ne.createInterceptor(m.doDestroy,(()=>Zt.removeEventListener(e,t,p)),m)),p.spec={delay:r,throttled:s,block:o,once:a,thisObj:m,capture:l,expires:g,passive:c,delegate:d},p}static removeEventListener(e,t,n){const{expires:i,timerId:r,thisObj:s,capture:o}=n.spec;if(null!=i&&i.alt&&r){(null!=s&&s.isDelayable?s:globalThis)["number"==typeof i.delay?"clearTimeout":"cancelAnimationFrame"](r)}e.removeEventListener(t,n,o)}static onTransitionEnd({element:e,animationName:t,property:n,handler:i,mode:r=(t?"animation":"transition"),duration:s=Wn[`get${"transition"===r?"Property":""}${H.capitalize(r)}Duration`](e,n),timeout:o,thisObj:a=globalThis,args:l=[],timerSource:c,runOnDestroy:d}){let u,h;c=c||(a.isDelayable?a:globalThis);const{isDelayable:g}=c,m=performance.now(),p=`transitionTimer${m}`,f=`timeoutTimer${m}`,v=[e,n,...l],y=()=>{var e;(b(),a.isDestroyed)||(null!==(e=a.$meta)&&void 0!==e&&e.class.isBase?a.callback(i,a,v):i.apply(a,v))},b=Zt.on({element:e,[`${r}end`]({animationName:i,propertyName:r,target:s}){if(s===e&&(r===n||null!=i&&i.match(t))){if(u){var o,a,l,d;if(h)null===(l=(d=c).clearTimeout)||void 0===l||l.call(d,g?f:h);null===(o=(a=c).clearTimeout)||void 0===o||o.call(a,g?p:u),u=null}y()}}});return o&&(h=c.setTimeout(y,Math.max(o,(s||0)+100),f)),null!=s&&(u=c.setTimeout(y,s+50,p,d)),b}static async waitForTransitionEnd(e){return new Promise((t=>{e.handler=t,Xt.onTransitionEnd(e)}))}static createDblClickWrapper(e,t,n){let i,r,s;return()=>{r||(r=Zt.on({element:e,touchstart:e=>{i=e.changedTouches[0].identifier,e.preventDefault()},touchend:e=>{if(e.changedTouches[0].identifier===i){e.preventDefault(),clearTimeout(s),i=r=null;const o=Pt.from(e.changedTouches[0].target,null,!0),a=e.changedTouches[0].pageX-o.x,l=e.changedTouches[0].pageY-o.y,c=Object.assign({browserEvent:e},e),d=new MouseEvent("dblclick",c);Object.defineProperties(d,{target:{value:e.target},offsetX:{value:a},offsetY:{value:l}}),"string"==typeof t&&(t=n[t]),t.call(n,d)}},once:!0}),s=setTimeout((()=>{r(),i=r=null}),Zt.dblClickTime))}}static toSpecialKey(e,t="ctrlKey"){let n=!1;return!0===e?n=t:"string"==typeof e&&(e=e.toLowerCase()).match(zt)&&(n=`${e}Key`),n}static specialKeyFromEventKey(e){return Vt[e]||"no-special-key"}}l.register(Xt);const Zt=Xt;Zt.longPressTime=700,Zt.dblClickTime=300,d.isTouchDevice&&Zt.on({element:document,touchmove:e=>{e.target.closest(".b-dragging")&&e.preventDefault()},passive:!1,capture:!0}),Xt._$name="EventHelper";const Jt={align:"t0-t0"},Qt=Node.ELEMENT_NODE,en=Node.TEXT_NODE,{isObject:tn}=W,nn=/[+-]?\d*\.?\d+[eE]?-?\d*/g,rn=nn.source,sn=new RegExp(`matrix\\((?:${rn}),\\s?(?:${rn}),\\s?(?:${rn}),\\s?(?:${rn}),\\s?(${rn}),\\s?(${rn})`),on=new RegExp("matrix3d\\((?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(-?\\d*),\\s?(-?\\d*)"),an=new RegExp(`(?:${sn.source})|(?:${on.source})`),ln=new RegExp(`translate(3d|X)?\\((${rn})px(?:,\\s?(${rn})px)?`),cn=new RegExp(`translate(3d|Y)?\\((${rn})px(?:,\\s?(${rn})px)?`),dn=/\s+/,un=/\s*;\s*/,hn=/\s*:\s*/,gn=/^-?((\d+(\.\d*)?)|(\.?\d+))$/,mn={},pn={elementData:"",for:"htmlFor",retainElement:""},fn={tag:1,html:1,text:1,children:1,tooltip:1,style:1,dataset:1,parent:1,nextSibling:1,ns:1,reference:1,class:1,className:1,unmatched:1,onlyChildren:1,listeners:1,compareHtml:1,syncOptions:1,keepChildren:1},vn=[["f","focusable"],["n","natural"],["p","programmatic"],["t","tabbable"]],yn={length:1,parentRule:1,style:1},bn={INPUT:1,TEXTAREA:1},Cn={BUTTON:1,IFRAME:1,EMBED:1,INPUT:1,OBJECT:1,SELECT:1,TEXTAREA:1,BODY:1},Sn=globalThis,Dn=document,wn=Object.freeze({}),En=Array.prototype.slice,Rn=Promise.resolve(),xn=["font-size","font-size-adjust","font-style","font-weight","font-family","font-kerning","font-stretch","line-height","text-transform","text-decoration","letter-spacing","word-break"],Tn=e=>e._hidden,Mn=(e,t,n)=>"children"===n.key?W.mergeItems(e,t,n):W.blend(e,t,n),In=(e,t)=>{if(e.isConnected){const n=e.ownerDocument.defaultView.getComputedStyle(e);return"none"!==n.getPropertyValue("display")&&(t||"hidden"!==n.getPropertyValue("visibility"))}},An=e=>e&&e.isConnected&&(e===Dn.body||Boolean(e.offsetParent)||(e.ownerDocument.defaultView&&"offsetParent"in e&&"fixed"!==Wn.getStyleValue(e,"position")?e.offsetParent:An(e.parentNode))),kn=e=>e instanceof Node?e:"string"==typeof e?Un.createElementFromTemplate(e):Un.createElement(e),Fn=Object.create(null),Pn=(e,t)=>{const n=Fn[e]||[H.hyphenate(e),t];return Fn[e]||(Fn[n[0]]=Fn[e]=n),n},On=/b-slide-in-from-\w+/,Ln={auto:1,scroll:1},$n=e=>{const t=e.ownerSVGElement?e.ownerSVGElement.parentNode:e.parentNode||e.target;return(null==t?void 0:t.nodeType)===Node.DOCUMENT_FRAGMENT_NODE?t.host:t},_n=e=>(null==e?void 0:e.nodeType)===Node.ELEMENT_NODE;["top","right","bottom","left","width","height","maxWidth","maxHeight","minWidth","minHeight","borderSpacing","borderWidth","borderTopWidth","borderRightWidth","borderBottomWidth","borderLeftWidth","insetBlockEnd","insetBlockStart","insetInlineEnd","insetInlineStart","marginTop","marginRight","marginBottom","marginLeft","marginInlineStart","marginInlineEnd","paddingTop","paddingRight","paddingBottom","paddingLeft","fontSize","letterSpacing","lineHeight","outlineWidth","textIndent","wordSpacing","insetInlineStart","insetBlockStart","insetInlineEnd","insetBlockEnd"].forEach((e=>Pn(e,!0)));let jn,Bn,Hn,Vn=null,zn=0,Nn=null;class Wn{static _usingKeyboard=!1;static enableKeyboardCssModifiers=!0;static get devicePixelRatio(){let e=globalThis.devicePixelRatio;if(null==e){const t=.05,n=.5,i=e=>`(-webkit-min-device-pixel-ratio: ${e}),\n                (min--moz-device-pixel-ratio: ${e}),\n                (min-resolution: ${e}dppx)`;for(let r=100*5;r>=100*n;r-=100*t)if(globalThis.matchMedia(i(r/100)).matches){e=r/100;break}}return e}static get usingKeyboard(){return Un._usingKeyboard}static set usingKeyboard(e){return Un._usingKeyboard=e}static setUsingKeyboard(e,t){Un.setFocusRendition(e,t),Un._usingKeyboard=t}static setFocusRendition(e,t){var n;Un.enableKeyboardCssModifiers&&(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE?t?Array.from(e.children).forEach((e=>{var t;return(null===(t=e.matches)||void 0===t?void 0:t.call(e,".b-outer"))&&e.classList.add("b-using-keyboard")})):Un.removeClsGlobally(e,"b-using-keyboard"):null===(n=e.classList)||void 0===n||n.toggle("b-using-keyboard",t))}static $name="DomHelper";static async slideIn(e,t=1){const n="b-slide-in-"+(t>0?"next":"previous"),{classList:i,parentNode:{classList:r}}=e;r.add(".b-sliding-child-element"),i.add(n),await Xt.waitForTransitionEnd({element:e,animationName:On}),i.remove(n),r.remove(".b-sliding-child-element")}static getFocusability(e){let t="";if(e){const{nodeName:n}=e,i=e.getAttribute("tabIndex");t=Cn[n]||("A"===n||"LINK"===n)&&e.href||"true"===e.contentEditable?"n":"","-1"===i?t+="fp":(t||null!=i)&&(t+="ft")}return mn[t]||(mn[t]=(n=t,Object.freeze(Object.fromEntries(vn.map((([e,t])=>[t,n.includes(e)]))))));var n}static isFocusable(e,t){return!(e&&!t&&(!Un.isVisible(e)||Un.Widget.fromElement(e,Tn)))&&Un.getFocusability(e).focusable}static isEditable(e){return Boolean((e.isContentEditable||bn[e.nodeName])&&!(e.readOnly||e.disabled||e.closest("[inert]")))}static isInView(e,t=!1,n){if(!An(_n(e.target)?e.target:e))return!1;const i=(null==n?void 0:n.positioned)&&"fixed"!==Wn.getStyleValue(n.element,"position"),r=Pt.from(globalThis),s=t?"contains":"intersect",o=i&&n.element.offsetParent,a=i&&Pt.from(o);if(r.height=Dn.scrollingElement.scrollHeight,e===Dn.body)return r;const l=this.getViewportIntersection(e,r,s);return l&&i&&l.translate(Dn.scrollingElement.scrollLeft,Dn.scrollingElement.scrollTop),i&&l?l.translate(-a.x+o.scrollLeft,-a.y+o.scrollTop):l}static getViewportIntersection(e,t,n){var i;const r=_n(e.target)?e.target:null,s=Wn.getVisibleViewport($n(e),t,r||e),o=Pt.from(r||e,null,!0);return r&&(o.translate(e.offsetX+1,e.offsetY+1),o.height=o.width=0),null==s||null===(i=s[n])||void 0===i?void 0:i.call(s,o,!1,!0)}static getVisibleViewport(e,t,n){const i=[];let r,s=t;for(let t=e;t&&t!==Dn.body;t=$n(t)){const e=t.ownerDocument.defaultView.getComputedStyle(t);(Ln[e.overflowX]||Ln[e.overflowY])&&"contents"!==e.display&&(i.unshift(Pt.client(t,null,!0,!1,n)),r=t)}for(let e=0,{length:t}=i;s&&e<t;e++)s=s.intersect(i[e]);return r&&(s=Pt.clipStickies(s,r,null,!0,n)),s}static isVisible(e){const t=e.ownerDocument;let n=!1;for(;e;e=$n(e)){var i;const r=null===(i=e.ownerDocument)||void 0===i?void 0:i.defaultView.getComputedStyle(e);if(n=n||"visible"===r.getPropertyValue("visibility"),e===t)return!0;if(_n(e)&&!In(e,n))return!1}return!1}static isDOMEvent(e){return e instanceof Event}static merge(e,...t){return W.blend(e,t,{merge:Mn})}static normalizeChildren(e,t,n){var i;let r,s,o,a,l,c=null==e?void 0:e.children;if(null!=e&&null!==(i=e.syncOptions)&&void 0!==i&&i.ignoreRefs&&(n=!0),c&&!(e instanceof Node))if(Array.isArray(c))for(s=0;s<c.length;++s)Un.normalizeChildren(c[s],t,n);else for(o in a=c,e.children=c=[],a){var d;r=a[o],null!==(d=r)&&void 0!==d&&d.isWidget&&(r=r.element),l=!o.startsWith("$")&&!Un.isElement(r),l&&(null==t||t(o,!n)),r&&(r instanceof Node||(!1===r.reference?delete r.reference:l&&"string"!=typeof r&&(r.reference=o),Un.normalizeChildren(r,t,n)),c.push(r))}return e}static roundPx(e,t=globalThis.devicePixelRatio||1){const n=1/t;return Math.round(e/n)*n}static floorPx(e,t=globalThis.devicePixelRatio||1){const n=1/t;return Math.floor(e*n)/n}static isCustomElement(e){return Boolean(null==e?void 0:e.shadowRoot)}static elementFromPoint(e,t){let n=document.elementFromPoint(e,t);return Un.isCustomElement(n)&&(n=n.shadowRoot.elementFromPoint(e,t)||n),n}static childFromPoint(e,t,n,i=e){const r=null==n?t:new Pt(t,n,0,0);let s=null;return Array.from(e.children).reverse().some((e=>{if(Pt.from(e,i).contains(r))return s=e.children.length&&Un.childFromPoint(e,r,null,i)||e,!0})),s}static unitize(e,t,n="px"){const[i,r]=Pn(e);return null!=t&&(t=String(t),t=r&&gn.test(t)?t+n:t),[i,t]}static get activeElement(){let e=document.activeElement;for(;e.shadowRoot;)e=e.shadowRoot.activeElement;return e}static getActiveElement(e){var t,n;null!==(t=e)&&void 0!==t&&t.isWidget&&(e=e.element);let i=((null===(n=e)||void 0===n?void 0:n.getRootNode())||document).activeElement;for(;null!==(r=i)&&void 0!==r&&r.shadowRoot;){var r;i=i.shadowRoot.activeElement}return i}static getRootElement(e){var t;const n=null===(t=e.getRootNode)||void 0===t?void 0:t.call(e),{nodeType:i}=n;return i===Node.DOCUMENT_NODE?n.body:i===Node.DOCUMENT_FRAGMENT_NODE?n:e.ownerDocument.contains(e)?e.ownerDocument.body:null}static getOutermostElement(e){var t,n;const i=null===(t=(n=e).getRootNode)||void 0===t?void 0:t.call(n);if(null!=i&&i.body)return null==i?void 0:i.body;for(;e.parentNode!==i&&e.parentNode;)e=e.parentNode;return e}static isValidFloatRootParent(e){var t;return"BODY"===(null===(t=e.tagName)||void 0===t?void 0:t.toUpperCase())||e.getRootNode().nodeType===Node.DOCUMENT_FRAGMENT_NODE}static getId(e){return e.id||(e.id="b-element-"+ ++zn)}static getCommonAncestor(e,t){if(e===t)return e;for(;e&&!(null!==(n=(i=e)[e.isWidget?"owns":"contains"])&&void 0!==n&&n.call(i,t)||e===t);){var n,i,r;e=null!==(r=e.owner)&&void 0!==r&&r.isWidget&&e.owner!==e?e.owner:e.parentNode}return e}static getElement(e){return"string"==typeof e?Dn.querySelector(e):e}static setAttributes(e,t){const n=Un.getElement(e);if(n&&t)for(const e in t)null==t[e]?n.removeAttribute(e):n.setAttribute(e,t[e])}static addAttributeValue(e,t,n){const i=Un.getElement(e);var r;i&&n&&i.setAttribute(t,[...new Set(null===(r=i.getAttribute(t))||void 0===r?void 0:r.split(" ")).add(n)].join(" "))}static removeAttributeValue(e,t,n){const i=Un.getElement(e);if(i&&n){var r;const e=new Set(null===(r=i.getAttribute(t))||void 0===r?void 0:r.split(" "));e.delete(n),e.size?i.setAttribute(t,[...e].join(" ")):i.removeAttribute(t)}}static setLength(e,t,n){return n=1===arguments.length?"number"==typeof e?`${e}px`:e??"":(e=Un.getElement(e)).style[t]="number"==typeof n?`${n}px`:n??""}static percentify(e,t=2){const n=Math.pow(10,t);return null==e||""===e||isNaN(e)?"":Math.round(e*n)/n+"%"}static getChild(e,t){return e.querySelector(":scope>"+t)}static hasChild(e,t){return null!=Un.getChild(e,t)}static children(e,t){return(">"===t[0]||t.startsWith("# "))&&("#"===t[0]&&(t=t.substr(2)),t=":scope "+t),Array.from(e.querySelectorAll(t))}static getChildElementCount(e){return e.childElementCount}static down(e,t){var n;return e?null!==(n=e.matches)&&void 0!==n&&n.call(e,t)?e:(t=":scope "+t,e.querySelector(t)):null}static isDescendant(e,t){const n=Un.getRootElement(e),i=Un.getRootElement(t);return i&&n!==i&&i.host?Un.isDescendant(n,i.host):e.contains(t)}static getEventElement(e,t="target"){return!e||Un.isElement(e)?e:e[t]}static isElement(e){return(null==e?void 0:e.nodeType)===document.ELEMENT_NODE&&Un.isNode(e)}static isReactElement(e){return(null==e?void 0:e.$$typeof)===Symbol.for("react.element")}static isNode(e){return Boolean(e)&&"number"==typeof e.nodeType&&!tn(e)}static forEachSelector(e,t,n){if("string"==typeof e)throw new Error("DomHelper.forEachSelector must provide a root element context (for shadow root scenario)");Un.children(e,t).forEach(n)}static forEachChild(e,t){Array.from(e.children).forEach(t)}static removeEachSelector(e,t){Un.forEachSelector(e,t,(e=>e.remove()))}static removeClsGlobally(e,...t){t.forEach((t=>Un.forEachSelector(e,"."+t,(e=>e.classList.remove(t)))))}static getAncestor(e,t,n=null){let i,r=!1,s=e;for(t=$e.asArray(t);s=s.parentElement;){if(t.includes(s)){r=!0;break}if(n&&s===n)break;i=s}return r?i||e:null}static getParents(e){const t=[];for(;e.parentElement;)t.push(e.parentElement),e=e.parentElement;return t}static makeValidId(e,t=""){return H.makeValidDomId(e,t)}static createElement(e={},t){var n,i,r;let s,o,a,l,c,d,u,h,g,m,p,f=t;if("boolean"==typeof f)throw new Error("Clean up");t&&(c=t.ignoreRefs,g=t.refOwner,m=t.refs,f=t.returnAll,p=t.syncIdField,c&&(a=!0,c="children"!==c)),"string"==typeof e.parent&&(e.parent=document.getElementById(e.parent));const v=e.parent||e.nextSibling&&e.nextSibling.parentNode,{dataset:y,html:b,reference:C,syncOptions:S,text:D}=e;if(S&&(p=S.syncIdField||p,l=S.ignoreRefs,l&&(a=!0,c="children"!==l,t={...t,ignoreRefs:!0})),c&&(g=null),s=e.ns?Dn.createElementNS(e.ns,e.tag||"svg"):Dn.createElement(e.tag||"div"),null!=D?Un.setInnerText(s,D):null!=b&&(b instanceof DocumentFragment?s.appendChild(b):s.innerHTML=b),e.tooltip&&Un.Widget.attachTooltip(s,e.tooltip),e.style&&Un.applyStyle(s,e.style),y)for(u in y)h=y[u],null!=h&&(s.dataset[u]=h);v&&this.addChild(v,s,e.nextSibling),g&&(s.$refOwnerId=g.id),C&&!c&&(g?(s.$reference=C,g.attachRef(C,s,e)):(m||((t=Object.assign({},t)).refs=m={}),m[C]=s,s.setAttribute("data-reference",C)));const w=e.className||e.class,E=Object.keys(e);for(w&&s.setAttribute("class",_t.normalize(w)),o=0;o<E.length;++o)u=E[o],h=e[u],null!=(d=pn[u])?s[d||u]=h:!fn[u]&&u&&null!=h&&s.setAttribute(u,h);e["aria-hidden"]||e.role||e.tabIndex||Wn.isFocusable(s,!0)||s.htmlFor||s.setAttribute("role","presentation"),null===(n=t)||void 0===n||null===(i=n.callback)||void 0===i||i.call(n,{action:"newElement",domConfig:e,targetElement:s,syncId:g?C:t.syncIdField&&(null===(r=e.dataset)||void 0===r?void 0:r[t.syncIdField])}),!0===f?t.returnAll=f=[s]:Array.isArray(f)&&f.push(s),e.children&&(p&&(s.syncIdMap={}),$e.asArray(e.children).forEach((n=>{if(n)if("string"==typeof n){const e=document.createTextNode(n);g&&(e.$refOwnerId=g.id),s.appendChild(e)}else if(this.isReactElement(n)){var i,r;null===(i=t)||void 0===i||null===(r=i.reactCallback)||void 0===r||r.call(i,{jsx:n,domConfig:e,targetElement:s})}else if(isNaN(n.nodeType)){var o,l;n.parent=s,!n.ns&&e.ns&&(n.ns=e.ns);const i=Un.createElement(n,{...t,ignoreRefs:(null===(o=e.syncOptions)||void 0===o?void 0:o.ignoreRef)??a}),r=null===(l=n.dataset)||void 0===l?void 0:l[p];null!=r&&(s.syncIdMap[r]=i),delete n.parent}else s.appendChild(n)}))),s.lastDomConfig=e;const R=m||f||s;return e.replaceElement&&e.replaceElement.replaceWith(R),R}static createElementFromTemplate(e,t=wn){const{array:n,raw:i,fragment:r}=t;let s;if(Un.supportsTemplate){if((jn||(jn=Dn.createElement("template"))).innerHTML=e,s=jn.content,r)return s.cloneNode(!0)}else if(s=(Bn||(Bn=new DOMParser)).parseFromString(e,"text/html").body,r){const e=s.childNodes;for(s=document.createDocumentFragment();e.length;)s.appendChild(e[0]);return s}return s=i?s.childNodes:s.children,1!==s.length||n?En.call(s):s[0]}static triggerMouseEvent(e,t="contextmenu"){const n=this.isInView(e),i=(n||Pt.from(e)).center,r=new MouseEvent(t,{clientX:i.x,clientY:i.y,offsetX:n.width/2,offsetY:n.height/2,bubbles:!0});e.dispatchEvent(r)}static insertFirst(e,t){return t&&t.nodeType!==Qt&&t.tag&&(t=Un.createElement(t)),e.insertBefore(t,e.firstElementChild)}static insertBefore(e,t,n){return t&&t.nodeType!==Qt&&t.tag&&(t=Un.createElement(t)),n?e.insertBefore(t,n):Un.insertFirst(e,t)}static insertAt(e,t,n){const i=Array.from(e.children);if(n>=i.length)return Un.append(e,t);const r=i[n];return Un.insertBefore(e,t,r)}static append(e,t){if(t.forEach){if(Array.isArray(t)&&(t=t.map((e=>kn(e)))),e.append)e.append(...t);else{const n=document.createDocumentFragment();t.forEach((function(e){n.appendChild(e)})),e.appendChild(n)}return t}return e.appendChild(kn(t))}static getTranslateX(e){const t=e.style.transform;let n=ln.exec(t);return n?parseFloat(n[2]):(n=an.exec(t)||an.exec(Un.getStyleValue(e,"transform")),n?parseFloat(n[1]||n[3]):0)}static getTranslateY(e){const t=e.style.transform;let n=cn.exec(t);if(n){const e=parseFloat(n["Y"===n[1]?2:3]);return isNaN(e)?0:e}return n=an.exec(t)||an.exec(Un.getStyleValue(e,"transform")),n?parseFloat(n[2]||n[4]):0}static getTranslateXY(e){return[Un.getTranslateX(e),Un.getTranslateY(e)]}static getOffsetX(e,t=null){return t?e.getBoundingClientRect().left-t.getBoundingClientRect().left:e.offsetLeft}static getOffsetY(e,t=null){return t?e.getBoundingClientRect().top-t.getBoundingClientRect().top:e.offsetTop}static getOffsetXY(e,t=null){return[Un.getOffsetX(e,t),Un.getOffsetY(e,t)]}static getPageX(e){return e.getBoundingClientRect().left+Sn.pageXOffset}static getPageY(e){return e.getBoundingClientRect().top+Sn.pageYOffset}static getExtremalSizePX(e,t){const n=H.hyphenate(t),i=n.split("-")[1];let r=Un.getStyleValue(e,n);return r=/%/.test(r)?e.parentElement?parseInt(Un.getStyleValue(e.parentElement,i),10):NaN:parseInt(r,10),r}static setScale(e,t,n=t){const i=Un.getStyleValue(e,"transform").split(/,\s*/);i.length>1?(i[0].startsWith("matrix3d")?(i[0]=`matrix3d(${t}`,i[5]=n):(i[0]=`matrix(${t}`,i[3]=n),e.style.transform=i.join(",")):e.style.transform=`scale(${t}, ${n})`}static setTranslateX(e,t){const n=Un.getStyleValue(e,"transform").split(/,\s*/);t=Un.roundPx(t),n.length>1?(n[n[0].startsWith("matrix3d")?12:4]=t,e.style.transform=n.join(",")):e.style.transform=`translateX(${t}px)`}static setTranslateY(e,t){const n=Un.getStyleValue(e,"transform").split(/,\s*/);t=Un.roundPx(t),n.length>1?(n[n[0].startsWith("matrix3d")?13:5]=t,e.style.transform=n.join(",")+")"):e.style.transform=`translateY(${t}px)`}static setTop(e,t){Un.setLength(e,"top",t)}static setLeft(e,t){Un.setLength(e,"left",t)}static setTopLeft(e,t,n){Un.setLength(e,"top",t),Un.setLength(e,"left",n)}static setTopInsetInlineStart(e,t,n){Un.setLength(e,"top",t),Un.setLength(e,"inset-inline-start",n)}static setRect(e,{x:t,y:n,width:i,height:r}){Un.setTopInsetInlineStart(e,n,t),Un.setLength(e,"width",i),Un.setLength(e,"height",r)}static setTranslateXY(e,t,n){if(null==t)return Un.setTranslateY(e,n);if(null==n)return Un.setTranslateX(e,t);t=Un.roundPx(t),n=Un.roundPx(n);const i=Un.getStyleValue(e,"transform").split(/,\s*/),r=i[0].startsWith("matrix3d");i.length>1?(i[r?12:4]=t,i[r?13:5]=n,e.style.transform=i.join(",")+")"):e.style.transform=`translate(${t}px, ${n}px)`}static addTranslateX(e,t){Un.setTranslateX(e,Un.getTranslateX(e)+t)}static addTranslateY(e,t){Un.setTranslateY(e,Un.getTranslateY(e)+t)}static addLeft(e,t){Un.setLeft(e,Un.getOffsetX(e)+t)}static addTop(e,t){Un.setTop(e,Un.getOffsetY(e)+t)}static alignTo(e,t,n=Jt,i,r="translate"){t=t instanceof Pt?t:Pt.from(t,!0);const s=Pt.from(e,!0);i&&(s.roundPx(),t.roundPx());const o=s.alignTo(Object.assign(n,{target:t}));if("topInset"===r){const t=[parseInt(e.style.insetInlineStart||0,10),parseInt(e.style.top||0,10)];Un.setTopInsetInlineStart(e,t[1]+o.y-s.y,t[0]+o.x-s.x)}else if("topLeft"===r){const t=[parseInt(e.style.left||0,10),parseInt(e.style.top||0,10)];Un.setTopLeft(e,t[1]+o.y-s.y,t[0]+o.x-s.x)}else{const t=Un.getTranslateXY(e);Un.setTranslateXY(e,t[0]+o.x-s.x,t[1]+o.y-s.y)}}static getStyleValue(e,t,n,i){const r=n?e.style:e.ownerDocument.defaultView.getComputedStyle(e,i);if(Array.isArray(t)){const e={};for(const n of t)e[n]=r.getPropertyValue(H.hyphenate(n));return e}return r.getPropertyValue(H.hyphenate(t))}static getEdgeSize(e,t,n){const i="border"===t?"-width":"",r={raw:{}};for(const s of["top","right","bottom","left"])n&&!n.includes(s[0])||(r[s]=parseFloat(r.raw[s]=Un.getStyleValue(e,`${t}-${s}${i}`)));return r.width=(r.left||0)+(r.right||0),r.height=(r.top||0)+(r.bottom||0),r}static parseStyle(e){if("string"==typeof e){const t=e.split(un);e={};for(let n=0,{length:i}=t;n<i;n++){const i=t[n].split(hn);e[i[0]]=i[1]}}return e||{}}static applyStyle(e,t,n=!1){if("string"==typeof t)n?(t.length||e.style.cssText.length)&&(e.style.cssText=t):e.style.cssText+=t;else if(t){let i,r;for(i in n&&(e.style.cssText=""),t.style&&"string"!=typeof t.style&&(t=W.assign({},t,t.style)),t)yn[i]||([i,r]=Un.unitize(i,t[i]),null==r?e.style.removeProperty(i):e.style.setProperty(i,r));"string"==typeof t.style&&(e.style.cssText+=t.style)}}static getCSSText(e){if("string"==typeof e)return e;let t="";for(const n in e)yn[n]||(t+=`${H.hyphenate(n)}:${e[n]};`);return t}static assignClasses(e,t){W.forEach(t,((t,n)=>e.classList.toggle(n,Boolean(t))))}static toggleClasses(e,t,n=null){t=$e.asArray(t),!0===n?e.classList.add(...t):!1===n?e.classList.remove(...t):t.forEach((t=>e.classList.toggle(t)))}static addTemporaryClass(e,t,n,i=globalThis,r=t){n>0&&(e.classList.add(t),i.setTimeout({fn:t=>e.classList.remove(t),delay:n,name:r,args:[t],cancelOutstanding:!0}))}static getPropertyTransitionDuration(e,t){const n=globalThis.getComputedStyle(e),i=n.transitionProperty.split(", "),r=n.transitionDuration.split(", "),s=i.indexOf(H.hyphenate(t));let o;return-1!==s&&(o=1e3*parseFloat(r[s])),o}static getAnimationDuration(e){return 1e3*parseFloat(Un.getStyleValue(e,"animation-duration"))}static highlight(e,t=globalThis){return e instanceof Pt?e.highlight():new Promise((n=>{t.setTimeout((()=>{e.classList.add("b-fx-highlight"),t.setTimeout((()=>{e.classList.remove("b-fx-highlight"),n()}),1e3)}),0)}))}static get scrollBarWidth(){if(null===Vn){const e=Hn||(Hn=Un.createElement({parent:Dn.documentElement,className:"b-scrollbar-measure-element",style:"position:absolute;top:-9999em;height:100px;overflow-y:scroll"}));e.parentNode!==Dn.documentElement&&Dn.documentElement.appendChild(e),Vn=e.offsetWidth}return Vn}static get scrollBarPadElement(){return{className:"b-yscroll-pad",children:[{className:"b-yscroll-pad-sizer"}]}}static get scrollLimit(){const e=Wn.createElement({parent:document.body,style:"position:absolute; left:-999px; top:0; width:5px; height:5px",children:[{style:"position:absolute; width:1px; height:1px"}]}),t=e.firstElementChild;let n=0,i=2e7;for(;i>1e6&&(t.style.transform=`translateY(${i}px)`,e.style.lineHeight=""+(n=1-n),!(e.scrollHeight>=i));)i-=1e6;return Object.defineProperty(Wn,"scrollLimit",{value:i}),e.remove(),i}static resetScrollBarWidth(){Vn=null}static measureText(e,t,n=!1,i=void 0){const r=Un.getMeasureElement(t,i);r[n?"innerHTML":"innerText"]=e;const s=r.clientWidth;return r.className="",s}static measureSize(e,t,n=!0){if(!e)return 0;if("number"==typeof e)return e;if(!e.length)return 0;if(/^\d+(px)?$/.test(e))return parseInt(e);if(t){var i;const r=null===(i=e.includes)||void 0===i?void 0:i.call(e,"%"),s=Un.getMeasureElement(t,r?t.parentNode:void 0),{parentElement:o}=s;s.innerHTML="",r&&(o.style.display="contents"),s.style.minWidth=s.style.maxWidth=Un.setLength(e);const a=n?s.offsetWidth:s.getBoundingClientRect().width;return o.style.display="",s.style.minWidth=s.style.maxWidth=s.className="",a}return/^\d+em$/.test(e)?14*parseInt(e):isNaN(e)?0:parseInt(e)}static getMeasureElement(e,t){t=t||Dn.body;const n=Sn.getComputedStyle(e),i=t.offScreenDiv=t.offScreenDiv||Un.createElement({parent:t,style:"position:fixed;top:-10000px;left:-10000px;visibility:hidden;contain:strict",className:"b-measure-element",children:[{style:"white-space:nowrap;display:inline-block;will-change:contents;width:auto;contain:none"}]},{returnAll:!0})[1];return xn.forEach((e=>{i.style[e]!==n[e]&&(i.style[e]=n[e])})),i.className=e.className,i.parentElement.parentElement!==t&&t.appendChild(i.parentElement),i}static stripTags(e){return(Un.$domParser||(Un.$domParser=new DOMParser)).parseFromString(e,"text/html").body.textContent}static sync(e,t){if("string"==typeof e){if(""===e)return void(t.innerHTML="");e=Un.createElementFromTemplate(e)}return Un.performSync(e,t),t}static performSync(e,t){return e.outerHTML!==t.outerHTML&&(Un.syncAttributes(e,t),Un.syncContent(e,t),Un.syncChildren(e,t),!0)}static getSyncAttributes(e){const t={},n=[];for(let i=0;i<e.attributes.length;i++){const r=e.attributes[i];if(r.specified){const e=r.name.toLowerCase();t[e]=r.value,n.push(e)}}return{attributes:t,names:n}}static syncAttributes(e,t){const{attributes:n,names:i}=Un.getSyncAttributes(e),{attributes:r,names:s}=Un.getSyncAttributes(t),o=i.includes("dataset"),a=i.filter((e=>!s.includes(e))),l=s.filter((e=>!(i.includes(e)||o&&e.startsWith("data-")))),c=i.filter((e=>s.includes(e)));if(a.length>0)for(let e=0;e<a.length;e++){const i=a[e];"style"===i?Un.applyStyle(t,n.style,!0):"dataset"===i?Object.assign(t.dataset,n.dataset):t.setAttribute(i,n[i])}if(l.length>0)for(let e=0;e<l.length;e++)t.removeAttribute(l[e]);if(c.length>0)for(let e=0;e<c.length;e++){const i=c[e];if("style"===i)Un.applyStyle(t,n.style,!0);else if("dataset"===i)Object.assign(t.dataset,n.dataset);else if("class"!==i||!n.class.isDomClassList&&"object"!=typeof n.class)r[i]!==n[i]&&t.setAttribute(i,n[i]);else{let e;e=n.class.isDomClassList?n.class:new _t(n.class),e.isEqual(r.class)||t.setAttribute("class",e)}}}static syncContent(e,t){0===Un.getChildElementCount(e)&&(t.innerText=e.innerText)}static setInnerText(e,t){const{firstChild:n}=e;(null==n?void 0:n.nodeType)===Element.TEXT_NODE?n.data=t:e.textContent=t}static syncChildren(e,t){const n=this,i=En.call(e.childNodes),r=En.call(t.childNodes);for(;i.length;){const e=i.shift(),s=r.shift();if(e&&e.nodeType!==en&&e.nodeType!==Qt)throw new Error(`Source node type ${e.nodeType} not supported by DomHelper.sync()`);if(s&&s.nodeType!==en&&s.nodeType!==Qt)throw new Error(`Target node type ${s.nodeType} not supported by DomHelper.sync()`);if(s)if(e.nodeType===s.nodeType)e.nodeType===en?s.data=e.data:e.tagName===s.tagName?n.performSync(e,s):(t.insertBefore(e,s),s.remove());else{if(e.nodeType!==en||s.nodeType!==Qt){const t=e.parentElement||e;throw new Error(`Currently no support for transforming nodeType.\n${t.outerHTML}`)}t.innerText=e.data.trim()}else t.appendChild(e)}r.forEach((e=>{e.remove()}))}static syncClassList(e,t){const{classList:n}=e,i="string"==typeof t,r=i?t.split(dn):_t.normalize(t,"array"),s=r.length;let o,a=n.length!==s;for(o=0;!a&&o<s;o++)a=!n.contains(r[o]);return a&&(e.className=i?t:r.join(" ")),a}static updateClassList(e,t){const{classList:n}=e;let i,r,s=!1;for(i in t)r=Boolean(t[i]),n.contains(i)!==r&&(n[r?"add":"remove"](i),s=!0);return s}static setTheme(e,t){e=e.toLowerCase();const{head:n}=document,i=Un.getThemeInfo(t).name.toLowerCase();let r=n.querySelectorAll("[data-bryntum-theme]:not([data-loading])"),s=0;if(i===e)return Rn;Un.removeEachSelector(n,"#bryntum-theme[data-loading],link[data-bryntum-theme][data-loading]");const o={theme:e,prev:i};function a(t,n,a){const l=Wn.createElement({tag:"link",rel:"stylesheet",dataset:{loading:!0,bryntumTheme:!0},href:t.href.replace(i,e),nextSibling:t});l.addEventListener("load",(()=>{delete l.dataset.loading,Nn=null,++s===r.length&&(r.forEach((e=>e.remove())),ti.trigger("theme",o),n(o))})),l.addEventListener("error",(e=>{delete l.dataset.loading,a(e)}))}if(r.length)return new Promise(((e,t)=>{r.forEach(((n,i)=>{a(n,e,t,r.length)}))}));{const e=n.querySelector("#bryntum-theme:not([data-loading])")||n.querySelector(`[href*="${i}.css"]:not([data-loading])`);if(null==e||!e.href.includes(`${i}.css`))throw new Error(`Theme link for ${i} not found`);return r=[e],new Promise(((t,n)=>a(e,t,n)))}}static get themeInfo(){return Wn.getThemeInfo()}static getThemeInfo(e){if(!Nn){const t=Un.createElement({parent:document.body,className:"b-theme-info"}),n=Un.getStyleValue(t,"content",!1,":before");if(n)try{Nn=JSON.parse(n.replace(/^["']|["']$|\\/g,""))}catch(e){Nn=null}Nn=Nn||(e?{name:e}:null),t.remove()}return Nn}static async transition({element:e,selector:t="[data-dom-transition]",duration:n,action:i,thisObj:r=this,addTransition:s={},removeTransition:o={}}){const a=new Set,l=Array.from(e.querySelectorAll(t)),c=new Map(l.map((t=>{let n=0,i=t.parentElement;for(;i&&i!==e;)n++,i=i.parentElement;t.$depth=n,t.scrollHeight>t.offsetHeight&&"auto"===getComputedStyle(t).overflow&&(t.$scrollTop=t.scrollTop,a.add(t));const{parentElement:r}=t,s=Pt.from(t,e),o=Pt.from(t,r),l=getComputedStyle(r),c=parseFloat(l.borderLeftWidth);return c&&(s.left-=c,o.left-=c),[t.id,{element:t,globalBounds:s,localBounds:o,depth:n,parentElement:r}]})));i.call(r);const d=Array.from(e.querySelectorAll(t)),u=new Map(d.map((t=>{const n=Pt.from(t,e),i=Pt.from(t,t.parentElement),r=globalThis.getComputedStyle(t.parentElement),s=parseFloat(r.borderLeftWidth);return s&&(n.left-=s,i.left-=s),[t.id,{element:t,globalBounds:n,localBounds:i}]}))),h=["position","top","left","width","height","padding","margin","zIndex","minWidth","minHeight","opacity","overflow"];for(const[t,n]of c){const i=u.get(t);if(i){const{element:t}=i,{style:r,parentElement:s}=t,o=parseInt(Un.getStyleValue(t,"zIndex")),{globalBounds:l,localBounds:c,depth:d,parentElement:u}=n,g=u!==s;let m;W.copyProperties(t.$initial={parentElement:s},r,h),g?(i.bounds=i.globalBounds,m=l,e.appendChild(t)):(i.bounds=i.localBounds,m=c,u.appendChild(t));let p="hidden";a.has(t)&&(t.$scrollPlaceholder=Un.createElement({parent:t,style:{height:t.scrollHeight}}),p="auto");const f={position:"absolute",top:`${m.top}px`,left:`${m.left}px`,width:`${m.width}px`,height:`${m.height}px`,minWidth:0,minHeight:0,margin:0,zIndex:d+(o||0),overflow:p};"preserve-padding"!==t.dataset.domTransition&&(f.padding=0),Object.assign(r,f),i.processed=!0}else{const{element:e,localBounds:i,depth:r,parentElement:s}=n;e.$initial={removed:!0},Object.assign(e.style,{position:"absolute",top:`${i.top}px`,left:`${i.left}px`,width:`${i.width}px`,height:`${i.height}px`,minWidth:0,minHeight:0,padding:0,margin:0,zIndex:r,overflow:"hidden"}),s.appendChild(e),u.set(t,{element:e,bounds:i,removed:!0,processed:!0}),d.push(e)}}for(const[,e]of u)if(!e.processed){const{element:t}=e,{style:n,parentElement:i}=t,r=e.bounds=e.localBounds;t.classList.add("b-dom-transition-adding"),W.copyProperties(t.$initial={parentElement:i},n,h),Object.assign(n,{position:"absolute",top:s.top?0:`${r.top}px`,left:s.left?0:`${r.left}px`,width:s.width?0:`${r.width}px`,height:s.height?0:`${r.height}px`,opacity:s.opacity?0:null,zIndex:i.$depth+1,overflow:"hidden"})}for(const e of a)e.scrollTop=e.$scrollTop;e.classList.add("b-dom-transition"),e.firstElementChild.offsetWidth;for(const[,{element:e,bounds:t,removed:n}]of u)n?Object.assign(e.style,{top:o.top?0:`${t.top}px`,left:o.left?0:`${t.left}px`,width:o.width?0:`${t.width}px`,height:o.height?0:`${t.height}px`,opacity:o.opacity?0:e.$initial.opacity}):Object.assign(e.style,{top:`${t.top}px`,left:`${t.left}px`,width:`${t.width}px`,height:`${t.height}px`,opacity:e.$initial.opacity});await lt.sleep(n),e.classList.remove("b-dom-transition");for(const e of d)e.$initial&&(e.$initial.removed?e.remove():(W.copyProperties(e.style,e.$initial,h),e.$scrollPlaceholder&&(e.$scrollPlaceholder.remove(),delete e.$scrollPlaceholder),e.classList.remove("b-dom-transition-adding"),e.$initial.parentElement.appendChild(e)));for(const e of a)e.scrollTop=e.$scrollTop,delete e.$scrollTop}static async loadScript(e){return new Promise(((t,n)=>{const i=document.createElement("script");i.src=e,i.onload=t,i.onerror=n,document.head.appendChild(i)}))}static isNamedColor(e){return e&&!/^(#|hsl|rgb|hwb|lab|lch|oklab|oklch)/.test(e)}static createColorStyle(e){return null!=e&&e.length?this.isNamedColor(e)?`var(--cal-color-${e})`:e:""}static get NodeFilter(){return NodeFilter}static addChild(e,t,n){e.insertBefore(t,n)}static cloneStylesIntoShadowRoot(e,t){return new Promise(((n,i)=>{t&&e.querySelectorAll('style, link[rel="stylesheet"]').forEach((e=>e.remove()));const r=document.querySelectorAll('link[rel="stylesheet"]');let s=0;r.forEach((t=>{const o=t.cloneNode();o.addEventListener("load",(()=>{s+=1,s===r.length&&n()})),o.addEventListener("error",(e=>{i(o.href)})),e.appendChild(o)})),document.querySelectorAll("style").forEach((t=>{const n=t.cloneNode();n.innerText=t.innerText,e.appendChild(n)})),r.length||n()}))}}l.register(Wn);const Un=Wn;let Gn;const Yn=()=>Un.isTouchEvent=!1,qn=()=>{Un.isTouchEvent=!0,clearTimeout(Gn),Gn=setTimeout(Yn,400)};if(Dn.addEventListener("touchstart",qn,!0),Dn.addEventListener("touchend",qn,!0),Un.canonicalStyles=Fn,Un.supportsTemplate="content"in Dn.createElement("template"),Un.elementPropKey="$bryntum",Un.numberRe=nn,!("children"in Node.prototype)){const e=_n;Object.defineProperty(Node.prototype,"children",{get:function(){return Array.prototype.filter.call(this.childNodes,e)}})}Element.prototype.matches||(Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(e){const t=(this.document||this.ownerDocument).querySelectorAll(e);let n=t.length;for(;--n>=0&&t.item(n)!==this;);return n>-1}),Sn.Element&&!Element.prototype.closest?Node.prototype.closest=Element.prototype.closest=function(e){let t=this;if(!Dn.documentElement.contains(t))return null;do{if(t.matches(e))return t;t=t.parentElement||t.parentNode}while(null!==t&&t.nodeType===t.ELEMENT_NODE);return null}:Node.prototype.closest=function(e){var t;return null===(t=this.parentNode)||void 0===t?void 0:t.closest(e)},[Element.prototype,CharacterData.prototype,DocumentType.prototype].forEach((function(e){Object.prototype.hasOwnProperty.call(e,"remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})})),globalThis.addEventListener("resize",(()=>Vn=null)),Wn._$name="DomHelper";const Kn=new Map,Xn=e=>e.floating,Zn={touchend:1,pointerup:1},Jn={Meta:1,Control:1,Alt:1},Qn=e=>{var t;(null===(t=li)||void 0===t?void 0:t.pointerId)===e.pointerId&&(li=null)},ei=e=>{const{touches:t}=e;if(Kn.clear(),t)for(let n=0;n<t.length;n++){const i=t.item(n);Kn.set(i.identifier,[i,e])}},ti=new class extends(Pe.mixin(at)){suspendFocusEvents(){ui=!0}resumeFocusEvents(){ui=!1}setupFocusListenersOnce(e,t){e&&!ti.observedElements.has(e)&&(ti.setupFocusListeners(e,t),ti.observedElements.add(e))}detachFocusListeners(e){e.$globalEventsDetacher&&(e.$globalEventsDetacher(),e.$globalEventsDetacher=null,ti.observedElements.delete(e))}setupFocusListeners(e=document,t,n=!1){var i;let r,s,o;const a={element:e,fromGlobal:!0,touchstart(e){const{touches:n}=e;if(ei(e),2===n.length&&n[0].target.closest(".b-widget")&&n[1].target.closest(".b-widget"))return r=[n[0],n[1]],s=[(r[0].clientX+r[1].clientX)/2,(r[0].clientY+r[1].clientY)/2],void(o=Wn.elementFromPoint(s[0],s[1]));if(ii||1!==e.changedTouches.length)ii=null;else if(ii=e.changedTouches[0],!d.isAndroid){const n=({clientX:e,clientY:t,type:n})=>{(Zn[n]||!ii||Math.max(Math.abs(e-ii.clientX),Math.abs(t-ii.clientY))>5)&&(ri=null,i(),clearTimeout(r))},i=t.on({element:document,touchmove:n,touchend:n,pointermove:n,pointerup:n,capture:!0}),r=setTimeout((()=>{ri=ii.identifier,i(),e.target.dispatchEvent(new MouseEvent("contextmenu",t.copyEvent({},e)))}),t.longPressTime)}},touchmove:{passive:!1,handler:e=>{const{touches:n}=e;if(2===n.length&&r){const i=[n[0],n[1]],a=t.getDistanceBetween(r[0],r[1])-t.getDistanceBetween(i[0],i[1]),l=Math.abs(r[0].clientX-r[1].clientX)-Math.abs(i[0].clientX-i[1].clientX),c=Math.abs(r[0].clientY-r[1].clientY)-Math.abs(i[0].clientY-i[1].clientY);if(Math.abs(a)>2){const t={clientX:s[0],clientY:s[1],bubbles:!0};if(ti.Widget.convertPinchToMousewheel){e.preventDefault(),e.stopImmediatePropagation();const n=new MouseEvent("wheel",{...t,ctrlKey:!0});n.deltaY=c,n.deltaX=l,o.dispatchEvent(n)}const n=new MouseEvent("bryntum-pinch",t);n.deltaY=c,n.deltaX=l,n.touchMove=e,o.dispatchEvent(n)}r=i}}},touchend:{passive:!1,handler:e=>{ei(e),2!==e.touches.length&&(r=null),ii&&(e.changedTouches[0].identifier===ri?(e.stopImmediatePropagation(),!1!==e.cancelable&&e.preventDefault()):1===e.changedTouches.length&&e.changedTouches[0].identifier===ii.identifier&&ti.trigger("globaltap",{event:e}),ii=null)}},touchcancel:{passive:!1,handler:ei},mousedown:{handler:e=>{si="mouse",ii||ti.trigger("globaltap",{event:e}),ai=e;const t=e.ctrlKey||e.altKey||e.shiftKey||e.metaKey;!oi&&t?oi=new KeyboardEvent("keydown",{key:e.ctrlKey?"Control":e.shiftKey?"Shift":e.altKey?"Alt":"Meta",ctrlKey:e.ctrlKey,altKey:e.altKey,shiftKey:e.shiftKey,metaKey:e.metaKey}):oi&&!t&&(oi=null)},passive:!1},mouseup(){ai=null},pointerdown:{passive:!1,handler:t=>{li=t,Wn.setUsingKeyboard(e,!1)}},pointerup:{passive:!1,handler:Qn},pointercancel:{passive:!1,handler:Qn},keydown(t){const{key:n,target:i}=t;if(si="key",oi=t,ci=i,!Jn[n]){if(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE)for(const t of e.children)t.matches(".b-outer")&&Wn.setUsingKeyboard(t,!0);else Wn.setUsingKeyboard(e,!0);"Escape"===n&&ti.Widget.queryAll((e=>e.isTooltip&&e.isVisible)).forEach((e=>e.hide()))}},mouseenter(e){ci=e.target},keypress(){si="key"},keyup(){oi=null},focusin(e){const{Widget:t}=ti,{target:n}=e;if(null!=n&&n.shadowRoot||null!=n&&n._shadowRoot)return;if(n&&t.accessibility){const e=n.firstElementChild||n,t=Pt.from(n),i=t.center;(Wn.childFromPoint(e,t.width/2,t.height/2)||e).dispatchEvent(new PointerEvent("pointerover",{bubbles:!0,clientX:i.x,clientY:i.y,pointerType:"focus"}))}if(ui||n&&!n.isConnected)return;const i=e.relatedTarget?e.relatedTarget instanceof HTMLElement?e.relatedTarget:document.body:null,r=n||document.body,s=t.fromElement(i),o=t.fromElement(r),a=Wn.getCommonAncestor(s,o),l=!!(i&&4&r.compareDocumentPosition(i)),c=t.query(ni);let d=null;if(d=r&&r!==document.body?Wn.getActiveElement(r):Wn.getActiveElement(document),c&&!c._isRevertingFocus&&(!o||!c.owns(o)&&!(4&c.element.compareDocumentPosition(o.element)&&o.up(Xn))))return c.focus();let u=hi("focusout",i,n,s,o,l);for(let e,t=s;t&&t!==a;t=e)if(e=t.owner,!t.isDestroying&&t.onFocusOut&&(t.onFocusOut(u),n&&d!==Wn.getActiveElement(n)))return;if(a&&n===a.element)!a.isDestroying&&Wn.getActiveElement(a)===r&&a.focusElement&&a.focusElement!==a.element&&(a.element.contains(d)&&!a.focusDescendant||a.setTimeout((()=>{var e;return null===(e=a.focus)||void 0===e?void 0:e.call(a)}),0));else{u=hi("focusin",r,i,s,o,l);for(let e=o;e&&e!==a;e=e.owner){var h,g;if(!e.isDestroying)null===(h=(g=e).onFocusIn)||void 0===h||h.call(g,u)}}const m=Wn.getCommonAncestor((null==i?void 0:i.nodeType)===Element.ELEMENT_NODE?i:null,r)||r.parentNode;m&&(u=hi("focusmove",r,i,s,o,l,{bubbles:!0}),m.dispatchEvent(u))},focusout(e){if(!(ui||e.relatedTarget&&ti.Widget.fromElement(e.relatedTarget))){const t=e.relatedTarget&&e.relatedTarget instanceof HTMLElement?e.relatedTarget:null;a.focusin({target:t,relatedTarget:e.target}),oi=ai=null}},blur:{element:globalThis,handler(e){e.target===globalThis&&(oi=null,ai=null)}},capture:!0,passive:!0};n&&(null===(i=di)||void 0===i||i()),di=this.detachEvents=e.$globalEventsDetacher=t.on(a)}get activeTouches(){return Array.from(Kn.values())}get hasActiveTouches(){return Kn.size>0}get lastInteractionType(){return si}get shiftKeyDown(){var e;return Boolean(null===(e=oi)||void 0===e?void 0:e.shiftKey)}get ctrlKeyDown(){var e,t;return Boolean((null===(e=oi)||void 0===e?void 0:e.ctrlKey)||(null===(t=oi)||void 0===t?void 0:t.metaKey))}get altKeyDown(){var e;return Boolean(null===(e=oi)||void 0===e?void 0:e.altKey)}get currentOverElement(){return ci}isKeyDown(e){var t;return e?(null===(t=oi)||void 0===t?void 0:t.key)===e||!0===oi[(null==e?void 0:e.toLowerCase())+"Key"]:Boolean(oi)}isMouseDown(e=0){var t;return(null===(t=ai)||void 0===t?void 0:t.button)===e}get currentMouseDown(){return ai}set currentMouseDown(e){ai=e}get currentPointerDown(){return li}set currentPointerDown(e){li=e}get currentTouch(){return ii}set currentTouch(e){ii=e}get currentKeyDown(){return oi}set currentKeyDown(e){oi=e}},ni=e=>e.isTopModal;ti.observedElements=new Set;let ii,ri,si,oi,ai,li,ci,di,ui=!1;function hi(e,t,n,i,r,s,o){const a=new CustomEvent(e,o);return Object.defineProperty(a,"_target",{get:()=>t}),Object.defineProperty(a,"relatedTarget",{get:()=>n}),a.fromWidget=i,a.toWidget=r,a.backwards=s,a}const gi=/^(\w+)=(.*)$/;class mi{static DEFAULT_FETCH_OPTIONS={};static get(e,t){return this.fetch(e,t)}static post(e,t,n={}){return t instanceof FormData||"string"==typeof t||(t=JSON.stringify(t),n.headers=n.headers||{},n.headers["Content-Type"]=n.headers["Content-Type"]||"application/json"),this.fetch(e,Object.assign({method:"POST",body:t},n))}static fetch(e,t){let n;if(t=b.merge({},mi.DEFAULT_FETCH_OPTIONS,t),"undefined"!=typeof AbortController&&(n=t.abortController=new AbortController,t.signal=n.signal),"credentials"in t||(t.credentials="include"),t.queryParams){const n=Object.entries(t.queryParams);if(n.length){let i=!1;if(t.headers&&!0===t.addQueryParamsToBody){let e;switch(new Headers(t.headers).get("Content-Type")){case"application/x-www-form-urlencoded":e=URLSearchParams;break;case"multipart/form-data":e=FormData}if(e){const r=t.body||(t.body=new e);r instanceof e&&(n.forEach((([e,t])=>r.set(e,t))),i=!0)}}i||(e+=(e.includes("?")?"&":"?")+n.map((([e,t])=>`${e}=${encodeURIComponent(t)}`)).join("&"))}}const i=new Promise(((n,r)=>{fetch(e,t).then((e=>{t.parseJson?e.json().then((t=>{e.parsedJson=t,n(e)})).catch((t=>{e.parsedJson=null,e.error=t,r(e)})):n(e)})).catch((e=>{e.stack=i.stack,r(e)}))}));return i.stack=(new Error).stack,i.abort=function(){var e;null===(e=n)||void 0===e||e.abort()},i}static mockUrl(e,t){const n=this;(n.mockAjaxMap||(n.mockAjaxMap={}))[e]=t,mi.originalFetch||(mi.originalFetch=mi.fetch,mi.fetch=n.mockAjaxFetch.bind(n))}static async mockAjaxFetch(e,t){const n=e.split("?");let i=this.mockAjaxMap[n[0]],r=null;if(i){"function"==typeof i&&(i=await i(n[0],n[1]&&function(e){const t={},n=e.split("&");for(const e of n){const[n,i,r]=gi.exec(e),s=decodeURIComponent(i),o=decodeURIComponent(r);if(n){let e=t[s];e?(Array.isArray(e)||(e=t[s]=[e]),e.push(o)):t[s]=o}}return t}(n[1]),t));try{r=(null==t?void 0:t.parseJson)&&JSON.parse(i.responseText)}catch(e){r=null,i.error=e}return i=Object.assign({status:200,ok:!0,headers:new Headers,statusText:"OK",url:e,parsedJson:r,text:()=>new Promise((e=>{e(i.responseText)})),json:()=>new Promise((e=>{e(r)}))},i),new Promise((function(e,t){i.synchronous?e(i):setTimeout((function(){e(i)}),"delay"in i?i.delay:100)}))}return mi.originalFetch(e,t)}}mi._$name="AjaxHelper";const pi="undefined"!=typeof self?self:"undefined"!=typeof globalThis?globalThis:null;class fi{static skipLocaleIntegrityCheck=!1;static mergeLocales(...e){const t={};return e.forEach((e=>{Object.keys(e).forEach((n=>{"object"==typeof e[n]?t[n]={...t[n],...e[n]}:t[n]=e[n]}))})),t}static trimLocale(e,t){const n=(t,n)=>{e[t]&&(n?e[t][n]&&delete e[t][n]:delete e[t])};Object.keys(t).forEach((e=>{Object.keys(t[e]).length>0?Object.keys(t[e]).forEach((t=>n(e,t))):n(e)}))}static normalizeLocale(e,t){if(!e)throw new Error('"nameOrConfig" parameter can not be empty');if("string"==typeof e){if(!t)throw new Error('"config" parameter can not be empty');t.locale?t.name=e||t.name:t.localeName=e}else t=e;let n={};if(t.name||t.locale)n=Object.assign({localeName:t.name},t.locale),t.desc&&(n.localeDesc=t.desc),t.code&&(n.localeCode=t.code),t.path&&(n.localePath=t.path);else{if(!t.localeName)throw new Error('"config" parameter doesn\'t have "localeName" property');n=Object.assign({},t)}for(const e of["name","desc","code","path"])n[e]&&delete n[e];if(!n.localeName)throw new Error("Locale name can not be empty");return n}static get locales(){return pi.bryntum.locales||{}}static set locales(e){pi.bryntum.locales=e}static get localeName(){return pi.bryntum.locale||"En"}static set localeName(e){pi.bryntum.locale=e||fi.localeName}static get locale(){return fi.localeName&&this.locales[fi.localeName]||this.locales.En||Object.values(this.locales)[0]||{localeName:"",localeDesc:"",localeCoode:""}}static publishLocale(e,t){const{locales:n}=pi.bryntum,i=fi.normalizeLocale(e,t),{localeName:r}=i;return n[r]&&!0!==t?n[r]=this.mergeLocales(n[r]||{},i||{}):n[r]=i,n[r]}}pi.bryntum=pi.bryntum||{},pi.bryntum.locales=pi.bryntum.locales||{},fi._$name="LocaleHelper";class vi extends(at(Pe)){static get defaultConfig(){return{throwOnMissingLocale:G.isTestEnv}}construct(...e){const t=this;if(super.construct(...e),d.isBrowserEnv){var n;const e=document.querySelector("script[data-default-locale]");e?t.applyLocale(e.dataset.defaultLocale):null!==(n=t.locale)&&void 0!==n&&n.localeName&&t.applyLocale(t.locale.localeName)}}get locales(){return fi.locales}set locales(e){fi.locales=e}set locale(e){this.applyLocale(e)}get locale(){return fi.locale}get localeCode(){var e;return(null===(e=this.locale)||void 0===e?void 0:e.localeCode)??"en-US"}applyLocale(e,t,n=!1){const i=this;let r;if("string"==typeof e)if("object"!=typeof t){if(r=i.locales[e],!r){if(n)return!0;throw new Error(`Locale "${e}" is not published. Publish with LocaleHelper.publishLocale() before applying.`)}}else r=fi.publishLocale(e,t);else r=fi.publishLocale(e);if(i.locale.localeName&&i.locale.localeName===r.localeName&&!0!==t)return i.locale;fi.localeName=r.localeName;const s=()=>{i.trigger("locale",r)};return r.localePath?new Promise(((e,t)=>{i.loadLocale(r.localePath).then((t=>{t.text().then((t=>{new Function(t)(),d.isBrowserEnv&&(r=i.locales[r.localeName],r&&delete r.localePath),s(),e(r)}))})).catch((e=>t(e)))})):(s(),r)}loadLocale(e){return mi.get(e)}set throwOnMissingLocale(e){this._throwOnMissingLocale=e}get throwOnMissingLocale(){return this._throwOnMissingLocale}}const yi=new vi,bi=Object.getPrototypeOf(Object),Ci=/L{.*?}/g,Si=/L{(.*?)}/g,Di=/((.*?)\.)?(.+)/g,wi=e=>e.replace(/\[\[(\d+)]]/gm,"{$1}"),Ei=Object.freeze(Object.create(null));var Ri=e=>class t extends(e||Pe){static $name="Localizable";static get configurable(){return{localeClass:null,localizable:null,localizableProperties:{value:[],$config:{merge:"distinct"}}}}static clsName(e){var t,n;return"string"==typeof e?e:e===bi?"Object":e.$$name||e.name||(null===(t=e.prototype)||void 0===t?void 0:t.$$name)||(null===(n=e.prototype)||void 0===n?void 0:n.name)}static parseLocaleString(e){var t;const n=[];let i;if(null!==(t=e)&&void 0!==t&&t.includes("L{"))for(e=e.replace(/{(\d+)}/gm,"[[$1]]"),Si.lastIndex=0;null!=(i=Si.exec(e));){Di.lastIndex=0;const e=Di.exec(i[1]);n.push({match:wi(i[0]),localeKey:wi(e[3]),localeClass:e[2]})}return n.length>0?n:[{match:e,localeKey:e,localeClass:void 0}]}construct(e={},...t){super.construct(e,...t),yi.ion({locale:"updateLocalization",thisObj:this}),this.updateLocalization()}get localeClass(){return this._localeClass||null}localizeProperty(e){var n,i;const r=this,s=b.getPath(r,e),o=(null===(n=r.$meta.configs[e])||void 0===n?void 0:n.localeKey)||(null===(i=r.fieldMap)||void 0===i||null===(i=i[e])||void 0===i?void 0:i.defaultValue);let a;if(o){if(a=t.localize(o,r,r.localeClass||r),!a||e in(r.initialConfig||Ei)||e in(r.originalData||Ei))return s;b.setPath(r.isColumn?r.data:r,e,a)}else"string"==typeof s&&(r.originalLocales=r.originalLocales||{},a=b.getPath(r.originalLocales,e),void 0===a&&(b.setPath(r.originalLocales,e,s),a=s),a&&b.setPath(r,e,a=r.optionalL(a,r)));return a||s}updateLocalization(){var e,t;!1!==this.localizable&&(null===(e=this.localizableProperties)||void 0===e||e.forEach(this.localizeProperty,this),null===(t=this.trigger)||void 0===t||t.call(this,"localized"))}static getTranslation(e,n,i){const r=yi.locale;let s,o,a=null;if(r)for(const{match:l,localeKey:c,localeClass:d}of this.parseLocaleString(e)){const u=t=>{var s;const o=null===(s=r[t])||void 0===s?void 0:s[c];return o&&(a="function"==typeof o?null!=n?o(n):o:"object"==typeof o||e===l?o:(a||e).replace(l,o),"string"==typeof o&&o.includes("L{")&&(a=this.getTranslation(o,n,i))),o};let h=!1;for(o=i;o&&(s=t.clsName(o))&&!(h=u(s))&&"string"!=typeof o;o=Object.getPrototypeOf(o));!h&&d&&u(d)}return a}static localize(e,n=void 0,...i){var r;0===(null===(r=i)||void 0===r?void 0:r.length)&&(i=[this]);let s=null;return i.some((i=>(s=t.getTranslation(e,n,i),null!=s))),s}static L(e,n=void 0,...i){var r;0===(null===(r=i)||void 0===r?void 0:r.length)&&(i=[this]);const s=this.localize(e,n,...i);if(null==s&&yi.throwOnMissingLocale&&e.includes("L{"))throw new Error(`Localization is not found for '${e}' in '${i.map((e=>t.clsName(e))).join(", ")}'. ${yi.locale.localeName?`Locale : ${yi.locale.localeName}`:""}`);return s??e}L(e,n,i=this.localeClass){const{constructor:r}=this;return i&&t.clsName(i)!==t.clsName(r)?t.L(e,n,i,r):t.L(e,n,r)}static optionalL(e,n=void 0,...i){var r;const s=yi.throwOnMissingLocale;yi.throwOnMissingLocale=s&&Ci.test(e),0===(null===(r=i)||void 0===r?void 0:r.length)&&(i=[this]);const o=t.L(e,n,...i);return yi.throwOnMissingLocale=s,o}optionalL(e,t=this,n=!1){const i=yi.throwOnMissingLocale;yi.throwOnMissingLocale=i&&Ci.test(e)&&!n;const r=this.L(e,t);return yi.throwOnMissingLocale=i,r}get localeManager(){return yi}get localeHelper(){return fi}};class xi extends(Pe.mixin(at,Ri)){static $name="InstancePlugin";static get configurable(){return{clientListeners:null,disabled:!1,client:null,keyMap:null}}updateClient(e){this.owner||(this.owner=e)}updateKeyMap(e){const{client:t}=this;t.keyMap=t.mergeKeyMaps(t.keyMap,e,H.uncapitalize(this.constructor.$name))}static initPlugins(e,...t){for(const n of t)this.initPlugin(e,n)}static initPlugin(e,t,n){const i=e.plugins||(e.plugins={}),r=[e];return n&&r.push(n),i[t.$$name]=new t(...r)}get enabled(){return!this.disabled}getFocusRevertTarget(){var e;return null===(e=this.client)||void 0===e?void 0:e.getFocusRevertTarget()}construct(...e){const t=this;let n,[i,r]=e;1===e.length?W.isObject(i)&&(r=i,i=r.client):(r=W.assign({},r),delete r.client),t.client=i,super.construct(r),t.applyPluginConfig(i),n=t.clientListeners,n&&(n=W.assign({},n),n.thisObj=t,i.ion(n))}applyPluginConfig(e){const t=this,n=t.pluginConfig||t.constructor.pluginConfig;if(n){const{assign:i,chain:r,after:s,before:o,override:a}=n;i&&t.applyAssign(e,i),(r||s)&&t.applyChain(e,r||s),o&&t.applyChain(e,o,!1),a&&t.applyOverride(e,a)}}applyAssign(e,t){t.forEach((t=>this.assign(e,t)))}applyChain(e,t,n=!0){if(Array.isArray(t))for(const i of t)this.chain(e,i,i,n);else for(const i in t)this.chain(e,i,t[i],n)}applyOverride(e,t){const n=this;n.overridden||(n.overridden={}),t.forEach((t=>{if(!n[t])throw new Error(`Trying to chain fn ${e.$$name}#${t}, but plugin fn ${n.$$name}#${t} does not exist`);"function"==typeof e[t]&&(n.overridden[t]=e[t].bind(e)),e[t]=n[t].bind(n)}))}assign(e,t){const n=this,i=function(e,t){const n=W.getPropertyDescriptor(e,t);return n&&(n.get||n.set)?n:null}(n,t);i?Object.defineProperty(e,t,{configurable:!0,enumerable:!0,get:i.get&&i.get.bind(n),set:i.set&&i.set.bind(n)}):e[t]=n[t].bind(n)}chain(e,t,n,i=!0){let r=0;"object"==typeof t&&(t=t.fn),"object"==typeof n&&(r=n.prio||0,n=n.fn);const s=this,o=e.pluginFunctionChain||(e.pluginFunctionChain={}),a=s[n]&&s[n].bind(s),l=s.functionChainRunner;if(!a)throw new Error(`Trying to chain fn ${e.$$name}#${n}, but plugin fn ${s.$$name}#${n} does not exist`);if(!o[t]){let n=e[t];n&&(n=n.bind(e),n.$this=e,n.$prio=0),o[t]=n?[n]:[],e[t]=(...e)=>l(o[t],e)}a.$this=s,a.$prio=r,o[t][i?"push":"unshift"](a),o[t].$sorted=!1}functionChainRunner(e,t){let n,i,r;for(e.$sorted||(e.sort(((e,t)=>t.$prio-e.$prio)),e.$sorted=!0),i=0;i<e.length&&(n=e[i],n.$this.isDestroyed||(r=n(...t),!1!==r));i++);return r}doDisable(e){const t=this,{constructor:n}=t,i="featureClass"in n?n.featureClass:`b-${n.$$name.toLowerCase()}`,r=H.uncapitalize(n.$$name);var s,o,a;i&&(null===(s=t.client)||void 0===s||null===(s=s._element)||void 0===s||s.classList[e?"remove":"add"](i));t.isConfiguring||(e?t.trigger("disable"):t.trigger("enable"),null===(o=(a=t.client).syncSplits)||void 0===o||o.call(a,(t=>{const n=t.features[r];n&&(n.disabled=e)})))}updateDisabled(e){this.doDisable(e)}throwOverrideIsMissing(e){throw new Error(`Trying to override fn ${e.plugIntoName}#${e.fnName}, but plugin fn ${e.pluginName}#${e.fnName} does not exist`)}get rootElement(){return this.client.rootElement}get state(){var e;return null===(e=this.constructor.stateProperties)||void 0===e?void 0:e.reduce(((e,t)=>(e[t]=this[t],e)),{})}}xi._$name="InstancePlugin";var Ti=e=>class extends(e||Pe){static $name="Pluggable";get plugins(){return this._plugins||(this._plugins={}),this._plugins}set plugins(e){e&&(Array.isArray(e)||(e=[e]),xi.initPlugins(this,...e)),this.initPlugins()}initPlugins(){}addPlugins(...e){xi.initPlugins(this,...e)}addPlugin(e,t){return xi.initPlugin(this,e,t)}hasPlugin(e){return null!=this.getPlugin(e)}getPlugin(e){var t;return"function"==typeof e&&(e=e.$$name),null===(t=this.plugins)||void 0===t?void 0:t[e]}get widgetClass(){}};fi.publishLocale({localeName:"En",localeDesc:"English (US)",localeCode:"en-US",Object:{Yes:"Yes",No:"No",Cancel:"Cancel",Ok:"OK",Week:"Week",None:"None"},CodeEditor:{apply:"Apply",autoApply:"Auto apply",downloadCode:"Download code",editor:"Code editor",viewer:"Code viewer"},ColorPicker:{noColor:"No color"},Combo:{noResults:"No results",recordNotCommitted:"Record could not be added",addNewValue:e=>`Add ${e}`},FilePicker:{file:"File"},Field:{badInput:"Invalid field value",patternMismatch:"Value should match a specific pattern",rangeOverflow:e=>`Value must be less than or equal to ${e.max}`,rangeUnderflow:e=>`Value must be greater than or equal to ${e.min}`,stepMismatch:"Value should fit the step",tooLong:"Value should be shorter",tooShort:"Value should be longer",typeMismatch:"Value is required to be in a special format",valueMissing:"This field is required",invalidValue:"Invalid field value",minimumValueViolation:"Minimum value violation",maximumValueViolation:"Maximum value violation",fieldRequired:"This field is required",validateFilter:"Value must be selected from the list"},DateField:{invalidDate:"Invalid date input"},DatePicker:{gotoPrevYear:"Go to previous year",gotoPrevMonth:"Go to previous month",gotoNextMonth:"Go to next month",gotoNextYear:"Go to next year"},NumberFormat:{locale:"en-US",currency:"USD"},DurationField:{invalidUnit:"Invalid unit"},TimeField:{invalidTime:"Invalid time input"},TimePicker:{hour:"Hour",minute:"Minute",second:"Second"},List:{loading:"Loading...",selectAll:"Select All"},GridBase:{loadMask:"Loading...",syncMask:"Saving changes, please wait..."},PagingToolbar:{firstPage:"Go to first page",prevPage:"Go to previous page",page:"Page",nextPage:"Go to next page",lastPage:"Go to last page",reload:"Reload current page",noRecords:"No records to display",pageCountTemplate:e=>`of ${e.lastPage}`,summaryTemplate:e=>`Displaying records ${e.start} - ${e.end} of ${e.allCount}`},PanelCollapser:{Collapse:"Collapse",Expand:"Expand"},Popup:{close:"Close"},UndoRedo:{Undo:"Undo",Redo:"Redo",UndoLastAction:"Undo last action",RedoLastAction:"Redo last undone action",NoActions:"No items in the undo queue"},FieldFilterPicker:{equals:"equals",doesNotEqual:"does not equal",isEmpty:"empty",isNotEmpty:"not empty",contains:"contains",doesNotContain:"does not contain",startsWith:"starts with",endsWith:"ends with",isOneOf:"one of",isNotOneOf:"not one of",isGreaterThan:"greater than",isLessThan:"less than",isGreaterThanOrEqualTo:"greater or equals",isLessThanOrEqualTo:"less or equals",isBetween:"between",isNotBetween:"not between",isBefore:"before",isAfter:"after",isToday:"today",isTomorrow:"tomorrow",isYesterday:"yesterday",isThisWeek:"this week",isNextWeek:"next week",isLastWeek:"last week",isThisMonth:"this month",isNextMonth:"next month",isLastMonth:"last month",isThisYear:"this year",isNextYear:"next year",isLastYear:"last year",isYearToDate:"year to date",isTrue:"true",isFalse:"false",selectAProperty:"Select property",selectAnOperator:"Select operator",caseSensitive:"Case-sensitive",and:"and",dateFormat:"D/M/YY",selectValue:"Select value",selectOneOrMoreValues:"Select value(s)",enterAValue:"Enter value",enterANumber:"Enter number",selectADate:"Select date",selectATime:"Select time"},FieldFilterPickerGroup:{addFilter:"Add filter"},DateHelper:{locale:"en-US",weekStartDay:0,nonWorkingDays:{0:!0,6:!0},weekends:{0:!0,6:!0},unitNames:[{single:"millisecond",plural:"ms",abbrev:"ms"},{single:"second",plural:"seconds",abbrev:"s"},{single:"minute",plural:"minutes",abbrev:"min"},{single:"hour",plural:"hours",abbrev:"h"},{single:"day",plural:"days",abbrev:"d"},{single:"week",plural:"weeks",abbrev:"w"},{single:"month",plural:"months",abbrev:"mon"},{single:"quarter",plural:"quarters",abbrev:"q"},{single:"year",plural:"years",abbrev:"yr"},{single:"decade",plural:"decades",abbrev:"dec"}],unitAbbreviations:[["mil"],["s","sec"],["m","min"],["h","hr"],["d"],["w","wk"],["mo","mon","mnt"],["q","quar","qrt"],["y","yr"],["dec"]],parsers:{L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A"},ordinalSuffix:e=>{let t="th";if(!["11","12","13"].find((t=>e.endsWith(t)))){t={1:"st",2:"nd",3:"rd"}[e[e.length-1]]||"th"}return e+t}}});const{toString:Mi}=Object.prototype,Ii=Mi.call(new Date),Ai=new Date,ki=36e5,Fi=(e,t)=>isNaN(e)||null==e?t:e,Pi=/([ES]){([^}]+)}/g,Oi=e=>{let t="th";if(!["11","12","13"].find((t=>e.endsWith(t)))){t={1:"st",2:"nd",3:"rd"}[e[e.length-1]]||"th"}return e+t},Li=(e,t,n)=>(Ui[e]||(Ui[e]=new Intl.DateTimeFormat(Vi,t))).format(n),$i=(e,t,n,i=!1)=>{let r=Li(e,t,n);return/am|pm/i.test(r)&&(r=r.replace(/^0/,""),i&&(r=r.replace(/:00/,""))),r},_i=e=>e>=0?e:e+7,ji=/([^\w])(S+)/gm,Bi=(e,t)=>t+"SSS",Hi=/[:.\-/\s]/;let Vi="en-US",zi=Oi,Ni={},Wi={},Ui={},Gi={};const Yi=e=>{const t=qi[e];if(!t)throw new Error("Only international formats should be used here");if(void 0!==Wi[e])return Wi[e];const n=new Intl.DateTimeFormat(Vi,t).formatToParts(new Date(2001,1,2,3,4,5,6)).map((e=>{const n=e.type,i=t[n];return"literal"===n?e.value.replace(/,/g,""):"day"===n?"numeric"===i?"D":"DD":"month"===n?"short"===i?"MMM":"long"===i?"MMMM":"numeric"===i?"M":"MM":"year"===n?"numeric"===i?"YYYY":"YY":void 0})).join("");return Wi[e]=n},qi={l:{year:"numeric",month:"numeric",day:"numeric"},ll:{year:"numeric",month:"short",day:"numeric"}},Ki={M:e=>e.getMonth()+1,Mo:e=>zi(Ki.M(e).toString()),MM:e=>(e.getMonth()+1).toString().padStart(2,"0"),MMM:e=>Li("MMM",{month:"short"},e),MMMM:e=>Li("MMMM",{month:"long"},e),Q:e=>Math.ceil((e.getMonth()+1)/3),Qo:e=>zi(Ki.Q(e).toString()),D:e=>e.getDate(),Do:e=>zi(Ki.D(e).toString()),DD:e=>e.getDate().toString().padStart(2,"0"),DDD:e=>Math.ceil((new Date(e.getFullYear(),e.getMonth(),e.getDate(),12,0,0)-new Date(e.getFullYear(),0,0,12,0,0))/ir.day.millisecond),DDDo:e=>zi(Ki.DDD(e).toString()),DDDD:e=>Ki.DDD(e).toString().padStart(3,"0"),d:e=>e.getDay(),do:e=>zi(e.getDay().toString()),d1:e=>Li("d1",{weekday:"narrow"},e).substr(0,1),dd:e=>Ki.ddd(e).substring(0,2),ddd:e=>Li("ddd",{weekday:"short"},e),dddd:e=>Li("dddd",{weekday:"long"},e),u:e=>{const t=(Ui.u||(Ui.u=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",year:"numeric",month:"2-digit",day:"2-digit"}))).formatToParts(e);return`${t[4].value}${t[2].value}${t[0].value}Z`},uu:e=>{const t=(Ui.uu||(Ui.uu=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",hour12:!1,year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit"}))).formatToParts(e);return`${t[4].value}${t[2].value}${t[0].value}T${t[6].value}${t[8].value}${t[10].value}Z`},e:e=>e.getDay(),E:e=>e.getDay()+1,W:e=>fr.getWeekNumber(e)[1],Wo:e=>zi(Ki.W(e).toString()),WW:e=>Ki.W(e).toString().padStart(2,"0"),Wp:e=>`${fr.localize("L{Week}")} ${Ki.W(e)}`,WWp:e=>`${fr.localize("L{Week}")} ${Ki.WW(e)}`,Wp0:e=>`${fr.localize("L{Week}")[0]}${Ki.W(e)}`,WWp0:e=>`${fr.localize("L{Week}")[0]}${Ki.WW(e)}`,Y:e=>e.getFullYear(),YY:e=>(e.getFullYear()%100).toString().padStart(2,"0"),YYYY:e=>e.getFullYear(),A:e=>e.getHours()<12?"AM":"PM",a:e=>e.getHours()<12?"am":"pm",H:e=>e.getHours(),HH:e=>e.getHours().toString().padStart(2,"0"),h:e=>e.getHours()%12||12,hh:e=>Ki.h(e).toString().padStart(2,"0"),k:e=>e.getHours()||24,kk:e=>Ki.k(e).toString().padStart(2,"0"),K:e=>$i("K",{hour:"numeric"},e),KK:e=>$i("KK",{hour:"2-digit"},e),m:e=>e.getMinutes(),mm:e=>Ki.m(e).toString().padStart(2,"0"),s:e=>e.getSeconds(),ss:e=>Ki.s(e).toString().padStart(2,"0"),S:e=>Math.floor(e.getMilliseconds()/100).toString(),SS:e=>Math.floor(e.getMilliseconds()/10).toString().padStart(2,"0"),SSS:e=>e.getMilliseconds().toString().padStart(3,"0"),z:e=>Li("z",{timeZoneName:"short"},e),zz:e=>Li("zz",{timeZoneName:"long"},e),Z:e=>vr.getGMTOffset(e),LT:e=>$i("LT",{hour:"2-digit",minute:"2-digit"},e),LST:e=>$i("LST",{hour:"numeric",minute:"2-digit"},e,!0),LTS:e=>$i("LTS",{hour:"2-digit",minute:"2-digit",second:"2-digit"},e),L:e=>Li("L",{year:"numeric",month:"2-digit",day:"2-digit"},e),l:e=>Li("l",qi.l,e),LL:e=>Li("LL",{year:"numeric",month:"long",day:"numeric"},e),ll:e=>Li("ll",qi.ll,e),LLL:e=>Li("LLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit"},e),lll:e=>Li("lll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit"},e),LLLL:e=>Li("LLLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"long"},e),llll:e=>Li("llll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"short"},e)},Xi=`^(?:${Object.keys(Ki).sort(((e,t)=>t.length-e.length)).join("|")})`,Zi=()=>({}),Ji=e=>(e=>ur.test(e))(e)&&{milliseconds:parseInt(e.padEnd(3,"0").substring(0,3))},Qi={YYYY:e=>{const t=parseInt(e);return{year:t>=1e3&&t<=9999?t:NaN}},Y:e=>({year:parseInt(e)}),YY:e=>{const t=parseInt(e);return{year:t+(t>1968?1900:2e3)}},M:e=>({month:parseInt(e)-1}),MM:e=>({month:parseInt(e)-1}),Mo:e=>({month:parseInt(e)-1}),MMM:e=>{const t=(e||"").toLowerCase();for(const[e,n]of Object.entries(fr._monthShortNamesIndex))if(t.startsWith(e))return{month:n.value}},MMMM:e=>{const t=(e||"").toLowerCase();for(const[e,n]of Object.entries(fr._monthNamesIndex))if(t.startsWith(e))return{month:n.value}},DD:e=>({date:parseInt(e)}),D:e=>({date:parseInt(e)}),Do:e=>({date:parseInt(e)}),DDD:Zi,DDDo:Zi,DDDD:Zi,d:Zi,do:Zi,d1:Zi,dd:Zi,ddd:Zi,dddd:Zi,Q:Zi,Qo:Zi,W:Zi,Wo:Zi,WW:Zi,e:Zi,E:Zi,HH:e=>({hours:parseInt(e)}),hh:e=>({hours:parseInt(e)}),mm:e=>({minutes:parseInt(e)}),H:e=>({hours:parseInt(e)}),m:e=>({minutes:parseInt(e)}),ss:e=>({seconds:parseInt(e)}),s:e=>({seconds:parseInt(e)}),S:Ji,SS:Ji,SSS:Ji,A:e=>({amPm:e.toLowerCase()}),a:e=>({amPm:e.toLowerCase()}),L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A",l:{type:"dynamic",parser:()=>Yi("l")},ll:{type:"dynamic",parser:()=>Yi("ll")},Z:e=>{if(!e||!hr.test(e)&&"Z"!==e)return null;let t=0;if("Z"!==e){const n=hr.exec(e);if(n){t=("+"===n[1]?1:-1)*(60*(parseInt(n[2])||0)+(parseInt(n[3])||0))}else t=-1*(new Date).getTimezoneOffset()}return{timeZone:t}}},er=Object.keys(Qi).sort(((e,t)=>t.length-e.length)),tr=new RegExp(`(${er.join("|")})`),nr=new RegExp("^(LL|LLL|lll|LLLL|llll)$"),ir={decade:{decade:1,year:10,quarter:40,month:120,week:520,day:3652,hour:87648,minute:5258880,second:315532800,millisecond:3155328e5},year:{decade:.1,year:1,quarter:4,month:12,week:52,day:365,hour:8760,minute:525600,second:31536e3,millisecond:31536e6},quarter:{decade:1/40,year:1/4,quarter:1,month:3,week:4,day:91,hour:2184,minute:131040,second:7862400,millisecond:78624e5},month:{decade:1/120,year:1/12,quarter:1/3,month:1,week:4,day:-30,hour:-720,minute:-43200,second:-2592e3,millisecond:-2592e6},week:{decade:-1/520,year:-1/52,quarter:-1/13,month:-1/4,day:7,hour:168,minute:10080,second:604800,millisecond:6048e5},day:{decade:-1/3652,year:-1/365,quarter:-1/91,month:-1/30,week:1/7,hour:24,minute:1440,second:86400,millisecond:864e5},hour:{decade:-1/87648,year:-1/8760,quarter:-1/2184,month:-1/720,week:1/168,day:1/24,minute:60,second:3600,millisecond:36e5},minute:{decade:-1/5258880,year:-1/525600,quarter:-1/131040,month:-1/43200,week:1/10080,day:1/1440,hour:1/60,second:60,millisecond:6e4},second:{decade:-1/315532800,year:-1/31536e3,quarter:-1/7862400,month:-1/2592e3,week:1/604800,day:1/86400,hour:1/3600,minute:1/60,millisecond:1e3},millisecond:{decade:-1/3155328e5,year:-1/31536e6,quarter:-1/78624e5,month:-1/2592e6,week:1/6048e5,day:1/864e5,hour:1/36e5,minute:1/6e4,second:.001}},rr={ms:"millisecond",milliseconds:"millisecond",s:"second",seconds:"second",m:"minute",mi:"minute",min:"minute",minutes:"minute",h:"hour",hours:"hour",d:"day",days:"day",w:"week",weeks:"week",M:"month",mo:"month",mon:"month",months:"month",q:"quarter",quarters:"quarter",y:"year",years:"year",dec:"decade",decades:"decade"},sr=/^\s*([-+]?\d+(?:[.,]\d*)?|[-+]?(?:[.,]\d+))\s*([^\s]+)?/i,or=/^\s*([-+]?\d+)(?![.,])\s*([^\s]+)?/i,ar=["millisecond","second","minute","hour","day","week","month","quarter","year","decade"],lr=[["mil"],["s","sec"],["m","min"],["h","hr"],["d"],["w","wk"],["mo","mon","mnt"],["q","quar","qrt"],["y","yr"],["dec"]],cr=["decade","year","month","week","day","hour","minute","second","millisecond"],dr=["milliseconds","seconds","minutes","hours","date","month","year"],ur=/^[0-9]+$/,hr=/([+-])(\d\d):*(\d\d)*$/,gr={millisecond:0,second:1,minute:2,hour:3,day:4,week:5,month:6,quarter:7,year:8,decade:9},mr={round:(e,t=1)=>Math.round(e/t)*t,floor:(e,t=1)=>Math.floor(e/t)*t,ceil:(e,t=1)=>Math.ceil(e/t)*t},pr={};class fr extends(Ri()){static MS_PER_DAY=864e5;static $name="DateHelper";static set defaultFormat(e){vr._defaultFormat=e}static get defaultFormat(){return vr._defaultFormat||"YYYY-MM-DDTHH:mm:ssZ"}static set defaultParseFormat(e){this._defaultParseFormat=e}static get defaultParseFormat(){return this._defaultParseFormat||this._defaultFormat||"YYYY-MM-DDTHH:mm:ss.SSSZ"}static get today(){return fr.clearTime(new Date,!1)}static get tomorrow(){return fr.add(fr.today,1,"day")}static get yesterday(){return fr.add(fr.today,-1,"day")}static buildParser(e){const t=e.split(tr),n=[];return 1===t.length||nr.test(e)?[]:(t.reduce(((t,i,r,s)=>{if(0!==r||""!==i)if(tr.test(i)){const o=(this.localize("L{parsers}")||{})[i]||Qi[i];if("Z"===i&&r<s.length-2)throw new Error(`Invalid format ${e} TimeZone (Z) must be last token`);const a="function"==typeof o||"string"==typeof o?o:o.parser();if("string"==typeof a){const e=vr.buildParser(a),i=e.pop();delete i.last,n.push(...e),t=i}else t.pattern=i,t.fn=a}else t.splitter=i,n.push(t),t={};else Object.prototype.hasOwnProperty.call(t,"pattern")&&n.push(t);return t}),{}),n[n.length-1].last=!0,n)}static makeKey(e){if(10===e.length)return e;e.getTime&&(e=e.getTime());const t=pr[Math.trunc(e/ki)];if(t)return t;Ai.setTime(e);const n=Ai.getMonth()+1,i=Ai.getDate();return pr[Math.trunc(e/ki)]=`${Ai.getFullYear()}-${n<10?"0"+n:n}-${i<10?"0"+i:i}`}static parseKey(e){return vr.parse(e,"YYYY-MM-DD")}static parse(e,t=vr.defaultParseFormat,n=!1){if(e instanceof Date)return e;if("string"!=typeof e||!e)return null;const i={year:null,month:null,date:null,hours:null,minutes:null,seconds:null,milliseconds:null};t=t.replace(ji,Bi);let r,s=Gi[t];if(s||(s=Gi[t]=vr.buildParser(t)),e.includes(" ")&&(e=e.replace(/\s/g," ")),s.reduce(((e,t)=>{if(!t.last){let s,o,a;if("T"===t.splitter&&-1===e.indexOf("T"))s=e.indexOf(" ");else{var r;const i=e.indexOf("+");let{splitter:o}=t;!n&&Hi.test(o)&&(o=Hi),s=""!==t.splitter?e.search("string"==typeof o?H.escapeRegExp(o):o):(null===(r=t.pattern)||void 0===r?void 0:r.length)||-1,i>-1&&s>i&&(s=-1)}if(-1===s||"SSS"===t.pattern&&e.match(/^\d+Z$/)){const t=e.split(/([Z\-+])/);1===t.length?(o=e,a=""):(o=t[0],a=`${t[1]}${t[2]}`)}else o=e.substring(0,s)||e,a=e.substring(s+t.splitter.length);if(t.fn){const e=t.fn(o);e?Object.assign(i,e):a=o+a}return a}Object.assign(i,t.fn(e))}),e),i.year&&!i.date&&(i.date=1),i.date>31||i.month>12)return null;const o=vr.create(i,n);return o?r=o:n||(r=new Date(e)),r}static create(e,t=!1){const n={...e};let i=isNaN(n.year)||t&&(isNaN(n.month)||isNaN(n.date)),r=!1;if(!i){let e=!0;dr.forEach((t=>{t in n&&!isNaN(n[t])||(n[t]=0),e=e&&null===n[t]})),i=e}if(i)return null;if("am"===n.amPm?n.hours=n.hours%12:"pm"===n.amPm&&(n.hours=n.hours%12+12),"timeZone"in n&&(r=!0,n.minutes-=n.timeZone),t&&(null==n.year||null==n.month||null==n.date))return null;const s=[Fi(n.year,2020),Fi(n.month,0),Fi(n.date,1),n.hours,n.minutes,n.seconds,n.milliseconds];return r?new Date(Date.UTC(...s)):new Date(...s)}static toUTC(e){return new Date(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds()))}static format(e,t=vr.defaultFormat){if(!e||isNaN(e))return null;let n=Ni[t],i="";if(!n){n=Ni[t]=[];for(let e=0;e<t.length;e++){const i=t.slice(e).match(Xi),r=null==i?void 0:i[0];if(r){const t=(this.localize("L{formats}")||{})[r]||Ki[r];n.push(t),e+=r.length-1}else if("{"===t[e]){const i=t.indexOf("}",e+1);-1===i?(n.push(t.substr(e+1)),e=t.length):(n.push(t.substring(e+1,i)),e=i)}else n.push(t[e])}}return n.forEach((t=>{i+="string"==typeof t?t:t(e)})),i}static formatRange(e,t){return t.replace(Pi,((t,n,i)=>fr.format(e["S"===n?0:1],i)))}static asMilliseconds(e,t=null){return"string"==typeof e&&(t=e,e=1),vr.as("millisecond",e,t)}static asMonths(e){const t=vr.as("ms",vr.daysInMonth(e),"day"),n=(e.valueOf()-vr.startOf(e,"month").valueOf())/t;return 12*e.getYear()+e.getMonth()+n}static monthsToDate(e){const t=Math.floor(e),n=e-t,i=new Date(0,t),r=vr.as("ms",vr.daysInMonth(i),"days");return i.setTime(i.getTime()+n*r),i}static formatDelta(e,t){let n,i,r=", ";"boolean"==typeof t?n=t:t&&(n=t.abbrev,r=t.unitSeparator||r);const s=this.getDelta(e,t),o=[],a=(null==t?void 0:t.separator)||(n?"":" ");for(i in s)o.push(`${s[i]}${a}${i}`);return!1===(null==t?void 0:t.asString)?o:o.join(r)}static getDelta(e,t){let n,i,r,s,o,a,l;"boolean"==typeof t?n=t:t&&(n=t.abbrev,s=vr.normalizeUnit(t.precision),a=t.maxUnit,l=!n&&t.ignoreLocale);const c={},d=n?vr.getShortNameOfUnit:vr.getLocalizedNameOfUnit,u=a?cr.slice(cr.indexOf(a)):cr;for(o of u)if(i=vr.as(o,e),r=s===o,i=Math[r?"round":"floor"](i),(i||r&&!c.length)&&(c[l?o:d.call(vr,o,1!==i)]=i,e-=vr.as("ms",i,o)),r||!e)break;return c}static as(e,t,n="ms"){return"string"==typeof t&&(t=vr.parseDuration(t)),"object"==typeof t&&(n=t.unit,t=t.magnitude),e===n||(e=vr.normalizeUnit(e))===(n=vr.normalizeUnit(n))?t:gr[n]>gr[e]?t*Math.abs(ir[n][e]):t/Math.abs(ir[e][n])}static formatContainsHourInfo(e){return/([HhKkmSsAa]|LT|L{3,}|l{3,})/.test(e.replace(/(\\.)/g,""))}static is24HourFormat(e){return vr.format(vr.getTime(13,0,0),e).includes("13")}static add(e,t,n="ms",i=!0){let r;if(r="string"==typeof e?vr.parse(e):i?new Date(e.getTime()):e,"string"==typeof t){const e=fr.parseDuration(t);t=e.magnitude,n=e.unit}else t&&"object"==typeof t&&(n=t.unit,t=t.magnitude);if(!n||0===t)return r;switch(n=vr.normalizeUnit(n)){case"millisecond":r.setTime(r.getTime()+t);break;case"second":r.setTime(r.getTime()+1e3*t);break;case"minute":r.setTime(r.getTime()+6e4*t);break;case"hour":r.setTime(r.getTime()+36e5*t);break;case"day":t%1==0?(r.setDate(r.getDate()+t),23===r.getHours()&&0===e.getHours()&&r.setHours(r.getHours()+1)):r.setTime(r.getTime()+864e5*t);break;case"week":r.setDate(r.getDate()+7*t);break;case"month":{let e=r.getDate();e>28&&(e=Math.min(e,vr.getLastDateOfMonth(vr.add(vr.getFirstDateOfMonth(r),t,"month")).getDate())),r.setDate(e),r.setMonth(r.getMonth()+t);break}case"quarter":vr.add(r,3*t,"month",!1);break;case"year":r.setFullYear(r.getFullYear()+t);break;case"decade":r.setFullYear(r.getFullYear()+10*t)}return r}static diff(e,t,n="ms",i=!0){if(n=vr.normalizeUnit(n),!e||!t)return 0;let r;switch(n){case"year":r=vr.diff(e,t,"month")/12;break;case"quarter":r=vr.diff(e,t,"month")/3;break;case"month":r=12*(t.getFullYear()-e.getFullYear())+(t.getMonth()-e.getMonth()),0===r&&i&&(r=vr.diff(e,t,"day",i)/vr.daysInMonth(e));break;case"week":r=vr.diff(e,t,"day")/7;break;case"day":{const n=e.getTimezoneOffset()-t.getTimezoneOffset();r=(t-e+60*n*1e3)/864e5;break}case"hour":r=(t-e)/36e5;break;case"minute":r=(t-e)/6e4;break;case"second":r=(t-e)/1e3;break;case"millisecond":r=t-e}return i?r:Math.round(r)}static startOf(e,t="day",n=!0,i=vr.weekStartDay){if(!e)return null;switch(t=vr.normalizeUnit(t),n&&(e=vr.clone(e)),t){case"year":return e.setMonth(0,1),e.setHours(0,0,0,0),e;case"quarter":return e.setMonth(3*(vr.get(e,"quarter")-1),1),e.setHours(0,0,0,0),e;case"month":return e.setDate(1),e.setHours(0,0,0,0),e;case"week":{let t=e.getDay()-i;return t<0&&(t+=7),e.setDate(e.getDate()-t),e.setHours(0,0,0,0),e}case"day":return e.setHours(0,0,0,0),e;case"hour":e.getMinutes()>0&&e.setMinutes(0);case"minute":e.getSeconds()>0&&e.setSeconds(0);case"second":e.getMilliseconds()>0&&e.setMilliseconds(0);case"millisecond":return e}}static endOf(e){return new Date(e.getFullYear(),e.getMonth(),e.getDate()+1)}static clone(e){return new Date(e.getTime())}static clearTime(e,t=!0){return e?(t&&(e=new Date(e.getTime())),e.setHours(0,0,0,0),e):null}static midnight(e,t){let n=vr.clearTime(e);return t&&n<e&&(n=vr.add(n,1,"d")),n}static isMidnight(e){return vr.midnight(e).getTime()===e.getTime()}static getTimeOfDay(e,t="ms"){const n=e.getHours()*ir.hour.millisecond+e.getMinutes()*ir.minute.millisecond+e.getSeconds()*ir.second.millisecond+e.getMilliseconds();return"ms"===t?n:vr.as(t,n,"ms")}static set(e,t,n){if(!t)return e;if("string"==typeof t)switch(vr.normalizeUnit(t)){case"millisecond":(0!==n||e.getMilliseconds()>0)&&e.setMilliseconds(n);break;case"second":(0!==n||e.getSeconds()>0)&&e.setSeconds(n);break;case"minute":(0!==n||e.getMinutes()>0)&&e.setMinutes(n);break;case"hour":e.setHours(n);break;case"day":case"date":e.setDate(n);break;case"week":throw new Error("week not implemented");case"month":e.setMonth(n);break;case"quarter":e.setDate(1),e.setMonth(3*(n-1));break;case"year":e.setFullYear(n)}else Object.entries(t).sort(((e,t)=>gr[e[0]]-gr[t[0]])).forEach((([t,n])=>{vr.set(e,t,n)}));return e}static setDateToMidday(e,t=!0){return vr.set(vr.clearTime(e,t),"hour",12)}static constrain(e,t,n){return null!=t&&(e=vr.max(e,t)),null==n?e:vr.min(e,n)}static getTime(e,t=0,n=0,i=0){return e instanceof Date&&(i=e.getMilliseconds(),n=e.getSeconds(),t=e.getMinutes(),e=e.getHours()),new Date(2020,0,1,e,t,n,i)}static copyTimeValues(e,t){return e.setHours(t.getHours()),e.setMinutes(t.getMinutes()),e.setSeconds(t.getSeconds()),e.setMilliseconds(t.getMilliseconds()),e}static combineDateAndTime(e,t){return fr.copyTimeValues(new Date(e),t)}static get isDSTEnabled(){const e=(new Date).getFullYear(),t=new Date(e,0,1),n=new Date(e,6,1);return t.getTimezoneOffset()!==n.getTimezoneOffset()}static isDST(e){const t=e.getFullYear(),n=new Date(t,0,1),i=new Date(t,6,1);return e.getTimezoneOffset()<Math.max(n.getTimezoneOffset(),i.getTimezoneOffset())}static isBefore(e,t){return e<t}static isAfter(e,t){return e>t}static isEqual(e,t,n=null){return null===n?e&&t&&e.getTime()===t.getTime():vr.startOf(e,n)-vr.startOf(t,n)==0}static compare(e,t,n=null){return n&&(e=vr.startOf(e,n),t=vr.startOf(t,n)),e<t?-1:e>t?1:0}static clamp(e,t,n){if(!isNaN(e))return null!=t&&(e=Math.max(e,t)),null!=n&&(e=Math.min(e,n)),new Date(e)}static isSameDate(e,t){return 0===vr.compare(e,t,"d")}static isSameTime(e,t){return e.getHours()===t.getHours()&&e.getMinutes()===t.getMinutes()&&e.getSeconds()===t.getSeconds()&&e.getMilliseconds()===t.getMilliseconds()}static isStartOf(e,t){return vr.isEqual(e,vr.startOf(e,t))}static betweenLesser(e,t,n){return t.getTime()<=e.getTime()&&e.getTime()<n.getTime()}static betweenLesserEqual(e,t,n){return t.getTime()<=e.getTime()&&e.getTime()<=n.getTime()}static intersectSpans(e,t,n,i){return vr.betweenLesser(e,n,i)||vr.betweenLesser(n,e,t)}static compareUnits(e,t){return Math.sign(gr[vr.normalizeUnit(e)]-gr[vr.normalizeUnit(t)])}static timeSpanContains(e,t,n,i){return n-e>=0&&t-i>=0}static get weekStartDay(){return null==vr._weekStartDay&&(vr._weekStartDay=this.localize("L{weekStartDay}")||0),vr._weekStartDay}static get nonWorkingDays(){return{...this.localize("L{nonWorkingDays}")}}static get nonWorkingDaysAsArray(){return Object.keys(this.nonWorkingDays).map(Number)}static get weekends(){return{...this.localize("L{weekends}")}}static get(e,t){switch(vr.normalizeUnit(t)){case"millisecond":return e.getMilliseconds();case"second":return e.getSeconds();case"minute":return e.getMinutes();case"hour":return e.getHours();case"date":case"day":return e.getDate();case"week":return Ki.W(e);case"month":return e.getMonth();case"quarter":return Math.floor(e.getMonth()/3)+1;case"year":return e.getFullYear()}return null}static daysInYear(e){const t=e.getFullYear(),n=new Date(t+1,0,1)-new Date(t,0,1);return this.as("day",n)}static daysInMonth(e){return 32-new Date(e.getFullYear(),e.getMonth(),32).getDate()}static hoursInDay(e){const t=e.getFullYear(),n=e.getMonth(),i=e.getDate(),r=new Date(t,n,i+1)-new Date(t,n,i);return this.as("hour",r)}static getNormalizedUnitDuration(e,t){let n;switch(t){case"month":n=vr.asMilliseconds(vr.daysInMonth(e),"day");break;case"year":n=vr.asMilliseconds(vr.daysInYear(e),"day");break;case"day":n=vr.asMilliseconds(vr.hoursInDay(e),"hour");break;default:n=vr.asMilliseconds(t)}return n}static getFirstDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth(),1)}static getLastDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth()+1,0)}static min(e,t){return e.getTime()<t.getTime()?e:t}static max(e,t){return e.getTime()>t.getTime()?e:t}static getNext(e,t,n=1,i=vr.weekStartDay){if("week"===t){const t=vr.clone(e),r=t.getDay();return vr.startOf(t,"day",!1),vr.add(t,i-r+7*(n-(i<=r?0:1)),"day",!1),t.getDay()!==i&&vr.add(t,1,"hour"),t}return vr.startOf(vr.add(e,n,t),t,!1)}static isValidDate(e){return vr.isDate(e)&&!isNaN(e)}static isDate(e){return e&&Mi.call(e)===Ii}static getStartOfNextDay(e,t=!1,n=!1){let i=vr.add(n?e:vr.clearTime(e,t),1,"day");if(i.getDate()===e.getDate()){const n=vr.add(vr.clearTime(e,t),2,"day").getTimezoneOffset(),r=e.getTimezoneOffset();i=vr.add(i,r-n,"minute")}return i}static getEndOfPreviousDay(e,t=!1){const n=t?e:vr.clearTime(e,!0);return n-e?n:vr.add(n,-1,"day")}static getWeekDescription(e,t=e){const n=e.getMonth()===t.getMonth()?fr.format(e,"MMMM"):`${fr.format(e,"MMM")} - ${fr.format(t,"MMM")}`,i=fr.getWeekNumber(e);return`${i[1]}, ${n} ${i[0]}`}static getWeekNumber(e,t=fr.weekStartDay){const n=new Date(e.getFullYear(),0,1),i=new Date(e.getFullYear(),11,31),r=_i(n.getDay()-t),s=_i(i.getDay()-t),o=(a=e,l=n,Math.floor((a.getTime()-l.getTime()-(a.getTimezoneOffset()-l.getTimezoneOffset())*ir.minute.millisecond)/ir.day.millisecond)+1);var a,l;let c;if(c=r<4?Math.floor((o+r-1)/7)+1:Math.floor((o+r-1)/7),c){let t=e.getFullYear();return 53===c&&s<3&&(t++,c=1),[t,c]}const d=fr.getWeekNumber(new Date(e.getFullYear()-1,11,31))[1];return[e.getFullYear()-1,d]}static formatCount(e,t){return t=vr.normalizeUnit(t),1!==e&&(t+="s"),e+" "+t}static getUnitToBaseUnitRatio(e,t,n=!1){return(e=vr.normalizeUnit(e))===(t=vr.normalizeUnit(t))?1:ir[e]&&ir[e][t]&&(n||ir[e][t]>0)?1/vr.as(t,1,e):ir[t]&&ir[t][e]&&(n||ir[t][e]>0)?vr.as(e,1,t):-1}static getShortNameOfUnit(e){return e=vr.parseTimeUnit(e),vr.unitLookup[e].abbrev}static getLocalizedNameOfUnit(e,t=!1){const n=e.charAt(0)===e.charAt(0).toUpperCase();return e=vr.normalizeUnit(e),e=vr.parseTimeUnit(e),e=vr.unitLookup[e][t?"plural":"single"],n&&(e=H.capitalize(e)),e}static normalizeUnit(e){if(!e)return null;const t=e.toLowerCase();return"date"===t||ar.includes(t)?t:rr[e]||rr[t]}static getUnitByName(e){return vr.normalizeUnit(e)||vr.normalizeUnit(vr.parseTimeUnit(e))}static getDurationInUnit(e,t,n,i){return vr.diff(e,t,n,i)}static doesUnitsAlign(e,t){return!(e!==t&&"week"===t)}static getSmallerUnit(e){return ar[gr[vr.normalizeUnit(e)]-1]||null}static getLargerUnit(e){return ar[gr[vr.normalizeUnit(e)]+1]||null}static round(e,t,n,i){return vr.snap("round",e,t,n,i)}static floor(e,t,n,i){return vr.snap("floor",e,t,n,i)}static ceil(e,t,n,i){return vr.snap("ceil",e,t,n,i)}static snap(e,t,n,i,r=vr.weekStartDay){const s=mr[e];if("string"==typeof n&&(n=vr.parseDuration(n)),b.isObject(n)){const o=n.magnitude||n.increment;switch(n.unit){case"week":if(!i){const e=t.getDay();i=vr.add(vr.clearTime(t),e>=r?r-e:-(e-r+7),"day")}return vr[e](t,7*o+" days",i);case"month":{let e;return t=vr.asMonths(t),e=i?(i=vr.asMonths(i))+s(t-i,o):s(t,o),vr.monthsToDate(e)}case"quarter":return vr[e](t,3*o+" months",i);case"year":return vr[e](t,12*o+" months",i);case"decade":return vr[e](t,10*o+" years",i)}n=vr.as("ms",o,n.unit)}const o=1e3*t.getTimezoneOffset()*60;if(i){const e=1e3*i.getTimezoneOffset()*60,r=t-i+e-o,a=new Date(i.getTime()+s(r,n)),l=e-1e3*a.getTimezoneOffset()*60;return l&&vr.add(a,-l,"ms",!1),new Date(a)}return new Date(s(t.valueOf()-o,n)+o)}static parseDuration(e,t=!0,n){var i;const r=(t?sr:or).exec(e);if(null==e||!r)return null;const s=(e=>{const t=parseFloat(e);return isNaN(t)?null:t})(null===(i=r[1])||void 0===i?void 0:i.replace(",",".")),o=vr.parseTimeUnit(r[2])||n;return o?{magnitude:s,unit:o}:null}static parseTimeUnit(e){const t=null==e?null:vr.durationRegEx.exec(e.toLowerCase());if(!t)return null;for(let e=0;e<ar.length;e++)if(t[e+1])return ar[e]}static getGMTOffset(e=new Date){if(!e)return;const t=e.getTimezoneOffset();return t?(t>0?"-":"+")+Math.abs(Math.trunc(t/60)).toString().padStart(2,"0")+":"+Math.abs(t%60).toString().padStart(2,"0"):"Z"}static fillDayNames(){const e=new Date("2000-01-01T12:00:00"),t=vr._dayNames||[],n=vr._dayShortNames||[];t.length=0,n.length=0;for(let i=2;i<9;i++)e.setDate(i),t.push(vr.format(e,"dddd")),n.push(vr.format(e,"ddd"));vr._dayNames=t,vr._dayShortNames=n}static getDayNames(){return vr._dayNames}static getDayName(e){return vr._dayNames[e]}static getDayShortNames(){return vr._dayShortNames}static getDayShortName(e){return vr._dayShortNames[e]}static fillMonthNames(){const e=new Date("2000-01-15T12:00:00"),t=vr._monthNames||[],n=vr._monthShortNames||[],i={},r={};t.length=0,n.length=0;for(let s=0;s<12;s++){e.setMonth(s);const o=vr.format(e,"MMMM");t.push(o);const a=vr.format(e,"MMM");n.push(a),i[o.toLowerCase()]={name:o,value:s},r[a.toLowerCase()]={name:a,value:s}}vr._monthNames=t,vr._monthShortNames=n,vr._monthNamesIndex=i,vr._monthShortNamesIndex=r}static getMonthShortNames(){return vr._monthShortNames}static getMonthShortName(e){return vr._monthShortNames[e]}static getMonthNames(){return vr._monthNames}static getMonthName(e){return vr._monthNames[e]}static set locale(e){Vi=e,Ui={},Ni={},Wi={}}static get locale(){return Vi}static setupDurationRegEx(e=[],t=[]){const n=this,i={};let r="";for(let s=0;s<t.length;s++){const o=t[s],a=e[s];a.canonicalUnitName=ar[s],i[a.single]=i[a.single.toUpperCase()]=i[a.canonicalUnitName]=i[a.canonicalUnitName.toUpperCase()]=a,r+=(s?"|":"")+"(";for(let e=0;e<o.length;e++)r+=`${o[e].toLowerCase()}|`;if(Vi=n.localize("L{locale}")||"en-US","en-US"!==Vi){const e=lr[s];for(let t=0;t<e.length;t++)r+=`${e[t]}|`}r+=`${a.single.toLowerCase()}|${a.plural.toLowerCase()}|${a.canonicalUnitName}|${a.canonicalUnitName}s)`}n.unitLookup=i,n.durationRegEx=new RegExp(`^(?:${r})$`)}static applyLocale(){const e=this,t=e.localize("L{unitAbbreviations}")||[],n=e.unitNames=e.localize("L{unitNames}");"unitNames"!==n&&(Vi=e.localize("L{locale}")||"en-US",zi="en-US"===Vi?Oi:e.localize("L{ordinalSuffix}")||zi,Ni={},Wi={},Gi={},Ui={},vr._weekStartDay=null,vr.setupDurationRegEx(n,t),vr.fillDayNames(),vr.fillMonthNames())}}l.register(fr);const vr=fr;vr.useIntlFormat=Li,yi.ion({locale:"applyLocale",prio:1e3,thisObj:vr}),yi.locale&&vr.applyLocale();class yr extends Set{get isDateSet(){return!0}add(e){return e=fr.makeKey(e),this.has(e)||(this.generation=(this.generation||0)+1),super.add(e)}delete(e){return e=fr.makeKey(e),this.has(e)&&this.generation++,super.delete(e)}has(e){return super.has(fr.makeKey(e))}clear(){return this.size&&this.generation++,super.clear()}equals(e){return Array.isArray(e)&&(e=new yr(e)),e.size===this.size&&[...this].every((t=>e.has(t)))}get dates(){return[...this].sort().map((e=>fr.parseKey(e)))}}fr.DateSet=yr,fr._$name="DateHelper";const{defineProperty:br}=Reflect;let Cr;Cr=d.isBrowserEnv?globalThis.performance:{now:()=>(new Date).getTime()};let Sr=null;if(G.isTestEnv){const e=globalThis.bryntum||(globalThis.bryntum={});Sr=e.globalDelays={timeouts:new Map,intervals:new Map,animationFrames:new Map,idleCallbacks:new Map,isEmpty:(e=!1)=>Sr.timeouts.size+Sr.animationFrames.size+Sr.idleCallbacks.size+(e?Sr.intervals.size:0)===0,getFiltered({ignoreTimeouts:e=[],maxDelay:t=5e3,includeIntervals:n=!1}){const i=[],r=["timeouts","animationFrames","idleCallbacks"];n&&r.push("intervals");for(const n of r){const r=Sr[n];for(const[,n]of r.entries())e.includes(n.name)||Number.isInteger(n.delay)&&!(n.delay<t)||i.push(n)}return i}}}const Dr=Promise.resolve(),wr=Object.freeze([]),Er=()=>{},Rr=Object.freeze({}),xr=globalThis.queueMicrotask,Tr=(e,t,n,i)=>{const r="string"==typeof t,s=(null==i?void 0:i.appendArgs)||wr,o=()=>{n.timerId=null,n.lastCallTime=Cr.now();const i=n.args;n.args=null,r?e[t](...i,...s):t.call(e,...i,...s),n.called=!0,++n.calls};return e=(null==i?void 0:i.thisObj)||e,n.lastCallTime=-9e9,n.calls=0,n.suspended=null==i?void 0:i.suspended,n.invoker=o,o.wrapFn=n,o},Mr=(e,t,n="clearTimeout")=>(t.cancel=()=>{t.isPending&&(e[n](t.timerId),t.args=t.timerId=null)},t.flush=()=>{t.isPending&&(e[n](t.timerId),t.timerId=null,t.invoker())},t.now=(...e)=>{t.cancel(),t.args=e,t.invoker()},t.resume=e=>{const n=t.suspended;t.suspended=e||n<1?0:n-1},t.suspend=()=>{++t.suspended},t.immediate=!1,t.suspended=t.suspended?1:0,t.timerId=null,br(t,"isPending",{get:()=>null!==t.timerId}),t);var Ir=e=>class extends(e||Pe){static $name="Delayable";static get declarable(){return["delayable"]}doDestroy(){super.doDestroy(),this.clearDelayables()}clearDelayables(){const e=this,[t,n,i,r,s,o]=[e.idleCallbackIds,e.animationFrameIds,e.intervalIds,e.timeoutMap,e.timeoutIds,e.microtasksPending];e.idleCallbackIds=e.animationFrameIds=e.intervalIds=e.timeoutMap=e.timeoutIds=e.microtasksPending=null,null==s||s.forEach(((e,t)=>{var n;"function"==typeof e&&e(),clearTimeout(t),null===(n=Sr)||void 0===n||n.timeouts.delete(t)})),null==r||r.forEach(((e,t)=>clearTimeout(t))),null==i||i.forEach((e=>{var t;clearInterval(e),null===(t=Sr)||void 0===t||t.intervals.delete(e)})),null==n||n.forEach((e=>{var t;cancelAnimationFrame(e),null===(t=Sr)||void 0===t||t.animationFrames.delete(e)})),null==t||t.forEach((e=>{var t;cancelIdleCallback(e),null===(t=Sr)||void 0===t||t.idleCallbacks.delete(e)})),null==o||o.forEach((e=>e.cancel()))}hasTimeout(e){var t;return Boolean(null===(t=this.timeoutMap)||void 0===t?void 0:t.has(e))}asap(e,t){const n=this,i=(...e)=>{i.suspended||(i.called=!1,i.args=e,i.immediate?r():i.isPending||(i.timerId=n.queueMicrotask(r)))},r=Tr(n,e,i,t);return Mr(n,i,"cancelMicrotask")}queueMicrotask(e,t,n){let i,r;n||!t||Array.isArray(t)||(n=t,t=null),n=n||Rr,t=t||n.args||wr;const s=this,o="string"==typeof e,a=o?e:e.name,l=s.microtasksPending||(s.microtasksPending=new Map),c=()=>l.delete(i),d=()=>{r===l.get(i)&&(l.delete(i),o?!s.isDestroyed&&s[e](...t):e.apply(s,t))};return s.isDestroying&&!n.runOnDestroy?Er:(i=n.cancelOutstanding?a||e:c,r={key:i,name:a,fn:e,args:t,options:n,cancel:c,wrapFn:d},c.taskDef=r,xr?xr(d):Dr.then(d),l.set(i,r),c)}cancelMicrotask(e){null==e||e()}setTimeout({fn:e,delay:t,name:n,runOnDestroy:i,cancelOutstanding:r,args:s}){var o;(arguments.length>1||"function"==typeof arguments[0])&&([e,t,n,i,r]=arguments),"string"==typeof e?n=e:n||(n=e.name||e),r&&this.clearTimeout(n);const a=this,l=a.timeoutIds||(a.timeoutIds=new Map),c=a.timeoutMap||(a.timeoutMap=new Map),d=setTimeout((()=>{var t;"string"==typeof e&&(e=a[n]),null==l||l.delete(d),null==c||c.delete(n),null===(t=Sr)||void 0===t||t.timeouts.delete(d),e.apply(a,s)}),t);return l.set(d,!i||e),null===(o=Sr)||void 0===o||o.timeouts.set(d,{fn:e,delay:t,name:n}),n&&c.set(n,d),d}clearTimeout(e){var t,n;let i=e;if("string"==typeof i){if(!this.timeoutMap)return;i=this.timeoutMap.get(e),this.timeoutMap.delete(e)}clearTimeout(i),null===(t=this.timeoutIds)||void 0===t||t.delete(i),null===(n=Sr)||void 0===n||n.timeouts.delete(i)}clearInterval(e){var t,n;clearInterval(e),null===(t=this.intervalIds)||void 0===t||t.delete(e),null===(n=Sr)||void 0===n||n.intervals.delete(e)}setInterval(e,t,n){var i;const r=setInterval(e,t);return(this.intervalIds||(this.intervalIds=new Set)).add(r),null===(i=Sr)||void 0===i||i.intervals.set(r,{fn:e,delay:t,name:n}),r}requestAnimationFrame(e,t=[],n=this){var i;const r=this.animationFrameIds||(this.animationFrameIds=new Set),s=requestAnimationFrame((()=>{var i;null===(i=Sr)||void 0===i||i.animationFrames.delete(s),r.delete(s)&&e.apply(n,t)}));return r.add(s),null===(i=Sr)||void 0===i||i.animationFrames.set(s,{fn:e,extraArgs:t,thisObj:n}),s}requestIdleCallback(e,t=[],n=this){var i;const r=this.idleCallbackIds||(this.idleCallbackIds=new Set),s=requestIdleCallback((()=>{var i;null===(i=Sr)||void 0===i||i.idleCallbacks.delete(s),r.delete(s)&&e.apply(n,t)}));return r.add(s),null===(i=Sr)||void 0===i||i.idleCallbacks.set(s,{fn:e,extraArgs:t,thisObj:n}),s}createOnFrame(e,t=[],n=this,i){let r;const s=(...s)=>{null!=r&&i&&(this.cancelAnimationFrame(r),r=null),null==r&&(r=this.requestAnimationFrame((()=>{"string"==typeof e&&(e=n[e]),r=null,s.push(...t),e.apply(n,s)})))};return s.cancel=()=>this.cancelAnimationFrame(r),s}cancelAnimationFrame(e){var t,n;cancelAnimationFrame(e),null===(t=this.animationFrameIds)||void 0===t||t.delete(e),null===(n=Sr)||void 0===n||n.animationFrames.delete(e)}cancelIdleCallback(e){var t,n;cancelIdleCallback(e),null===(t=this.idleCallbackIds)||void 0===t||t.delete(e),null===(n=Sr)||void 0===n||n.idleCallbacks.delete(e)}async nextAnimationFrame(){return new Promise((e=>this.requestAnimationFrame(e)))}buffer(e,t){let n=t;t&&"number"!=typeof t?n=t.delay:t=null;const i=(...e)=>{if(i.suspended)return;const{delay:t}=i;i.cancel(),i.called=!1,i.args=e,i.immediate||!t?r():i.timerId=this.setTimeout(r,t)},r=Tr(this,e,i,t);return i.delay=n,Mr(this,i)}raf(e,t){let n=t;t&&"boolean"!=typeof t?n=t.cancelOutstanding:t=null;const i=(...e)=>{i.suspended||((i.cancelOutstanding||i.immediate)&&i.cancel(),i.called=!1,i.args=e,i.immediate?r():i.isPending||(i.timerId=this.requestAnimationFrame(r)))},r=Tr(this,e,i,t);return i.cancelOutstanding=n,i.raf=!0,Mr(this,i,"cancelAnimationFrame")}idle(e,t){let n=t;t&&"boolean"!=typeof t?n=t.cancelOutstanding:t=null;const i=(...e)=>{i.suspended||((i.cancelOutstanding||i.immediate)&&i.cancel(),i.called=!1,i.args=e,i.immediate?r():i.isPending||(i.timerId=this.requestIdleCallback(r)))},r=Tr(this,e,i,t);return i.cancelOutstanding=n,this.setTimeout((()=>this.idleCallbackIds.delete(i.timerId)&&i.now()),100),Mr(this,i,"cancelIdleCallback")}throttle(e,t){let n,i=t;t&&"number"!=typeof t?(i=t.delay,n=t.throttled):t=null;const r=this,s=(...e)=>{if(s.suspended)return;const{delay:t}=s,i=Cr.now()-s.lastCallTime;s.args=e,s.immediate||i>=t?(r.clearTimeout(s.timerId),o()):(s.isPending||(s.timerId=r.setTimeout(o,t-i),s.called=!1),n&&(n.wrapFn.args=e,n()))},o=Tr(r,e,s,t);return s.delay=i,n&&(n=Tr(r,n,(()=>{}),t)),Mr(r,s)}static setupDelayable(e){e.setupDelayableMethods(e.delayable)}static setupDelayableMethods(e,t=null){const n=e.static,i=t||this.prototype;n&&delete e.static;for(const t in e){let n=e[t];const r=t+"Now",s=typeof n;i[r]||(i[r]=i[t]),"number"===s?n={type:"buffer",delay:n}:"string"===s&&(n={type:n}),br(i,t,{get(){const e=this,i=e[n.type](((...t)=>e[r](...t)),n);return br(e,t,{value:i}),i}})}}get widgetClass(){}};class Ar{get data(){return Object.create(null)}get keys(){return[]}clear(){}getItem(e){return null}removeItem(e){}setItem(e,t){}}Ar._$name="StateStorage";const kr=()=>Object.create(null),Fr=(e,t=0)=>{const n=[],i=localStorage.length;for(let r,s=0;s<i;++s)r=localStorage.key(s),r.startsWith(e)&&n.push(r.slice(t));return n},Pr=new Ar,Or={local:class extends Ar{constructor(e){super(),this.prefix=e.prefix||""}get isLocal(){return!0}get data(){const e=kr(),t=this.keys;for(const n of t)e[n]=this.getItem(n);return e}get keys(){return Fr(this.prefix,this.prefix.length)}clear(){const e=Fr(this.prefix);for(const t of e)localStorage.removeItem(t)}getItem(e){const t=localStorage.getItem(this.prefix+e);return null===t?t:JSON.parse(t)}removeItem(e){return localStorage.removeItem(this.prefix+e)}setItem(e,t){return localStorage.setItem(this.prefix+e,JSON.stringify(t))}},memory:class extends Ar{constructor(){super(),this.clear()}get isMemory(){return!0}get data(){return W.clone(this._data)}get keys(){return Object.keys(this._data)}clear(){this._data=kr()}getItem(e){return e in this._data?this._data[e]:null}removeItem(e){delete this._data[e]}setItem(e,t){this._data[e]=t}}};class Lr extends(Pe.mixin(Ir,at)){static $name="StateProvider";static get configurable(){return{prefix:"bryntum-state:",storage:"local"}}static get delayable(){return{writeStatefuls:50}}static get instance(){return this._instance}static set instance(e){null==e?e=$r:(("string"==typeof e||W.isClass(e)||e instanceof Ar)&&(e={storage:e}),W.isObject(e)&&(e=new Lr(e))),this._instance=e}static setup(e){return this.instance=e,this.instance}doDestroy(){self.writeStatefuls.flush(),super.doDestroy()}get data(){return this.storage.data}set data(e){if(e)for(const t in e)this.setValue(t,e[t]);else this.clear()}clear(){return this.storage.clear(),this}changeStorage(e){if(null==e)e=Pr;else{if("string"==typeof e){if(!Or[e])throw new Error(`Invalid storage type "${e}" (expected one of: "${Object.keys(Or).join('", "')}")`);e=Or[e]}W.isClass(e)&&(e=new e(this))}return e}saveStateful(e,t){(this.pendingSaves||(this.pendingSaves=[])).push([e,t]),this.writeStatefuls()}writeStatefuls(){const e=this,{pendingSaves:t}=e,n=null==t?void 0:t.length,i=[],r=[];if(e.pendingSaves=null,n){for(let e,s,o,a=0;a<n;++a)[s,e]=t[a],!s.isDestroying&&s.isSaveStatePending&&(o=s.saveState({...e,immediate:!0}),o&&(i.push(o),r.push(s)));i.length&&e.trigger("save",{stateIds:i,saved:r})}}getValue(e){return this.writeStatefuls.flush(),this.storage.getItem(e)}setValue(e,t){const n=this,{storage:i}=n,r=n.getValue(e);return null!=t?(i.setItem(e,t),n.trigger("set",{key:e,value:t,was:r})):null!==r&&(i.removeItem(e),n.trigger("remove",{key:e,was:r})),n}}const $r=new Lr({storage:Pr});Lr._instance=$r,Lr._$name="StateProvider";const _r=/boolean|number|string/;var jr=e=>class extends(e||Pe){static $name="State";static configurable={stateful:{value:null,$config:{merge:"classList"}},statefulEvents:{$config:{merge:"classList"},value:["stateChange"]},stateId:null,stateProvider:null};static prototypeProperties={statefulLoaded:!1,statefulSuspended:0};afterConstruct(){super.afterConstruct(),this.stateProvider&&this.loadState()}finalizeInit(){this.stateProvider&&this.loadState(),super.finalizeInit()}get isStateful(){return!0}get isStatefulActive(){return!this.statefulSuspended&&!this.isResponsivePending&&!this.isResponsiveUpdating}get state(){return this._state=this.getState()}set state(e){this._state=e,e&&this.applyState(e)}updateStatefulEvents(e){const t=this,n={name:"statefulEvents",thisObj:t};if(t.detachListeners(n.name),e&&("string"==typeof e?e=H.split(e):Array.isArray(e)||(e=W.getTruthyKeys(e)),e.length)){var i;for(const t of e)n[t]="onStatefulEvent";null===(i=t.ion)||void 0===i||i.call(t,n)}}get statefulId(){const e=this,{responsiveState:t}=e;let n=e.stateId;return null==n&&!1===e.hasGeneratedId&&!1!==e.stateful&&(n=e.id),n&&t&&(n=`${n}[${t}]`),n}get statefulness(){const{stateful:e}=this;return Array.isArray(e)?W.createTruthyKeys(e):e}get stateProvider(){return this._stateProvider??(this._stateId&&Lr.instance)}applyState(e){(e=this.pruneState(e))&&this.setConfig(e)}getState(){const e=this,{initialConfig:t,statefulness:n,isConstructing:i}=e,{configs:r}=e.$meta,s=i?Object.setPrototypeOf(t,e.$meta.config):e;let o,a,l=null;if(n)for(o in l={},n)if(n[o]){var c;if(a=s[o],null!==(c=a)&&void 0!==c&&c.isStateful)a=a.state;else if(!i&&(W.isDate(a)&&(a=fr.format(a,"YYYY-MM-DDTHH:mm:ssZ")),r[o].equal(a,null==t?void 0:t[o])||!_r.test(typeof a)))continue;l[o]=a}return l}loadState(e,t){"boolean"==typeof e&&(t=e,e=null);const n=this,{statefulLoaded:i}=n;if(n.isStatefulActive&&(t||!i)){const t=n.loadStatefulData(e||(e=n.statefulId));!i&&e&&(n.defaultState=n.state,n.statefulLoaded=!0),t&&(n.state=t)}}loadStatefulData(e){var t;return(e=this.isStatefulActive?e||this.statefulId:null)&&(null===(t=this.stateProvider)||void 0===t?void 0:t.getValue(e))}resetDefaultState(){this.defaultState&&(this.state=this.defaultState)}resumeStateful(e=!1){this.statefulSuspended=e?0:Math.max(this.statefulSuspended-1,0)}saveState(e){e="string"==typeof e?{id:e}:e||{};const t=this,{stateProvider:n}=t,i=e.id||t.isStatefulActive&&t.statefulId;if(i&&n)return e.immediate?(t.isSaveStatePending=!1,n.setValue(i,t.state)):t.isSaveStatePending||(t.isSaveStatePending=!0,n.saveStateful(t,e)),i}suspendStateful(){++this.statefulSuspended}onConfigChange({name:e,value:t,was:n,config:i}){if(super.onConfigChange({name:e,value:t,was:n,config:i}),!this.isConstructing&&this.isStatefulActive&&this.statefulId){const{stateful:t}=this;(Array.isArray(t)?t.includes(e):null==t?void 0:t[e])&&this.saveState()}}onStatefulEvent(){this.isConstructing||this.saveState()}pruneState(e){const{statefulness:t}=this;if(t){const n={};for(const i in e)t[i]&&(n[i]=e[i]);e=n}return e}get widgetClass(){}};const Br=W.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null)),Hr={string:1,number:1};var Vr=e=>class extends(e||Pe){static $name="Identifiable";static get declarable(){return["identifiable"]}static get configurable(){return{id:""}}static setupIdentifiable(e,t){const{identifiable:n}=e;n.idMap=Object.create(null),Reflect.defineProperty(e,"identifiable",{get:()=>n})}doDestroy(){this.constructor.unregisterInstance(this),super.doDestroy()}changeId(e){return(this.hasGeneratedId=!e)?this.generateAutoId():e}updateId(e,t){const n=this,i=n.constructor;t&&i.unregisterInstance(n,t),n.hasGeneratedId&&!1===i.identifiable.registerGeneratedId||i.registerInstance(n,e)}generateAutoId(){return this.constructor.generateId(`b-${this.$$name.toLowerCase()}-`)}static get all(){return Object.values(this.identifiable.idMap)}static generateId(e="generatedId"){return e+(Br[e]=(Br[e]||0)+1)}static registerInstance(e,t=e.id){const{idMap:n}=this.identifiable;if(t in n&&!this.disableThrow)throw new Error("Id "+t+" already in use");n[t]=e}static unregisterInstance(e,t=e.id){const{idMap:n}=this.identifiable;Hr[typeof e]?delete n[e]:n[t]===e&&delete n[t]}static getById(e){const t=this.identifiable.idMap;if(t)return t[e]}static get registeredInstances(){const e=this.identifiable.idMap;return e?Object.values(e):[]}};const zr=Symbol("STM_PROP"),Nr={parentIndex:1,orderedParentIndex:1};var Wr=e=>class extends(e||Pe){static $name="ModelStm";static get defaultConfig(){return{stm:null}}joinStore(e){this.stm||(this.stm=e.stm)}unjoinStore(e,t=!1){var n;this.stm===e.stm&&(this.stm=null),null===(n=super.unjoinStore)||void 0===n||n.call(this,e,t)}get stm(){return this[zr]}set stm(e){this[zr]=e}beforeChronoFieldSet(e,t){var n;const i=this;return i.inSetting||null===(n=i.stm)||void 0===n||!n.enabled||Nr[e]||i.constructor.nonPersistableFields[e]||!i.getFieldDefinition(e)?null:{[e]:{value:t,oldValue:i.graph.activeTransaction.readCurrentOrProposedOrPrevious(i.$[e])}}}afterChronoFieldSet(e,t,n){n&&this.afterSet(e,t,!1,!1,n,!0)}shouldRecordFieldChange(e,t,n){const i=this.firstStore;return!(this.constructor.nonPersistableFields[e]||null==t&&null==n||t===n||t instanceof Date&&n instanceof Date&&t.getTime()===n.getTime()||"id"===e||"$PhantomId"===e||"parentId"===e&&i&&i.oldIdMap[t]===i.getById(n))}afterSet(e,t,n,i,r,s){const{stm:o}=this,a=this.constructor.nonPersistableFields;if(null!=o&&o.isBase&&o.shouldRecordAction&&!Nr[e]&&!a[e]&&r){let e;const[t,n]=Object.keys(r).reduce(((t,n)=>{const{value:i,oldValue:s}=r[n];return this.shouldRecordFieldChange(n,s,i)&&(e=!0,t[0][n]=i,t[1][n]=s),t}),[{},{}]);e&&o.onModelUpdate(this,t,n,s)}}beforeInsertChild(e){var t;const n=(null===(t=super.beforeInsertChild)||void 0===t?void 0:t.call(this,e))||[],{stm:i}=this;return null!=i&&i.enabled&&n.push(e.reduce(((e,t)=>(t.root===this.root&&e.set(t,{parent:t.parent,index:t.parent?t.parentIndex:void 0}),e)),new Map)),n}afterInsertChild(e,t,n,i,r){var s;const{stm:o}=this;if(null!=o&&o.shouldRecordAction){const t=n.pop();i&&o.onModelInsertChild(this,e,i,t,r)}null===(s=super.afterInsertChild)||void 0===s||s.call(this,e,t,n,i)}beforeRemoveChild(e,t){const n=super.beforeRemoveChild?super.beforeRemoveChild(e,t):[],{stm:i}=this;return null!=i&&i.shouldRecordAction&&!t&&n.push(e.reduce(((e,t)=>(e.set(t,{parentIndex:t.parentIndex,orderedParentIndex:t.orderedParentIndex}),e)),new Map)),n}afterRemoveChild(e,t,n){var i;const{stm:r}=this;if(null!=r&&r.shouldRecordAction&&!n){const n=t.pop();e&&e.length&&r.onModelRemoveChild(this,e,n)}null===(i=super.afterRemoveChild)||void 0===i||i.call(this,e,t,n)}};const Ur={includeFilteredOutRecords:!1},Gr=e=>("boolean"==typeof(e=e||!1)&&(e={includeFilteredOutRecords:e}),e||Ur);var Yr=e=>class extends(e||Pe){static $name="TreeNode";static set convertEmptyParentToLeaf(e){!0===e?e={onLoad:!0,onRemove:!0}:!1===e&&(e={onLoad:!1,onRemove:!1}),this._convertEmptyParentToLeaf=e}constructor(...e){super(...e),this.children&&(this.orderedChildren=this.orderedChildren||[])}static get convertEmptyParentToLeaf(){return this._convertEmptyParentToLeaf||{onLoad:!1,onRemove:!1}}ingestChildren(e,t=this.stores){const{inProcessChildren:n,constructor:i}=this,r=null==t?void 0:t[0];if(!0===e)return!!n||[];if(e){let t=$e.asArray(e);if(!t.length)return[];const n=t.length,s=[];t=(null==r?void 0:r.cloneImmutable(t))??t;for(let e,o=0;o<n;o++)e=t[o],e=e.isModel?e:(null==r?void 0:r.createRecord(e,!1,!0))??new i(e,null,null,!0),e=(null==r?void 0:r.processRecord(e))??e,s.push(e);if(!0===this.children&&r){const e=r.createSorterFn(r.sorters);s.sort(e)}return s}}processChildren(e=this.stores){const t=this,{meta:n}=t;t.inProcessChildren=!0;const i=t.ingestChildren(t.data[t.constructor.childrenField],e);if(i){const{convertEmptyParentToLeaf:e}=t.constructor;if(!0===e||e.onLoad?i.length:Array.isArray(i)){if(n.isLeaf=!1,!0===t.children)t.children=[];else if(0===i.length)return void(t.children=i);t.insertChild(i)}else!0===i?(n.isLeaf=!1,t.children=!0):t.remoteChildCount>0?n.isLeaf=!1:t.isRoot||(n.isLeaf=t.constructor.convertEmptyParentToLeaf.onLoad)}t.inProcessChildren=!1}ancestorsExpanded(e=this.firstStore){const{parent:t}=this;return!t||t.isExpanded(e)&&t.ancestorsExpanded(e)}isExpanded(e=this.firstStore){const t=this.instanceMeta(e.id);return Object.prototype.hasOwnProperty.call(t,"collapsed")||(t.collapsed=!this.expanded),!t.collapsed}get expanded(){return this.data.expanded}get childLevel(){let e=this,t=-1;for(;e&&!e.isRoot;)++t,e=e.parent;return t}get isLeaf(){return!1!==this.meta.isLeaf&&!this.isRoot}get isParent(){return!this.isLeaf}get isLoaded(){return this.isParent&&Array.isArray(this.children)}get hierarchyModificationDataToWrite(){const{parentIdField:e}=this.constructor,t=[e,"parentIndex","orderedParentIndex"].reduce(((t,n)=>{if(n in this.meta.modified){const i=this.constructor.getFieldDefinition(n);n===e?t[(null==i?void 0:i.dataSource)??e]=this.getFieldPersistentValue(n):i.persist&&(t[i.dataSource]=this.getFieldPersistentValue(n))}return t}),{});return Object.keys(t).length>0?t:null}get descendantCount(){return this.getDescendantCount()}get visibleDescendantCount(){return this.getDescendantCount(!0)}getDescendantCount(e=!1,t=this.firstStore,n=!1){let{children:i}=this;return n&&this.unfilteredChildren&&(i=this.unfilteredChildren),!i||!Array.isArray(i)||e&&!this.isExpanded(t)?0:i.reduce(((i,r)=>i+r.getDescendantCount(e,t,n)),i.length)}get allChildren(){return this.getAllChildren(!1)}get allUnfilteredChildren(){return this.getAllChildren(!0)}getAllChildren(e=!1){const{[e?"unfilteredChildren":"children"]:t}=this;return t&&!0!==t?t.reduce(((t,n)=>(t.push(n),t.push.apply(t,e?n.allUnfilteredChildren:n.allChildren),t)),[]):[]}get firstChild(){const{children:e}=this;return(null==e?void 0:e.length)&&e[0]||null}get lastChild(){const{children:e}=this;return(null==e?void 0:e.length)&&e[e.length-1]||null}get previousSiblingsTotalCount(){let e=this.previousSibling,t=this.parentIndex;for(;e;)t+=e.descendantCount,e=e.previousSibling;return t}get previousOrderedSibling(){var e;return(null===(e=this.parent)||void 0===e?void 0:e.orderedChildren[this.orderedParentIndex-1])??null}get nextOrderedSibling(){var e;return(null===(e=this.parent)||void 0===e?void 0:e.orderedChildren[this.orderedParentIndex+1])??null}get root(){var e;return(null===(e=this.parent)||void 0===e?void 0:e.root)||this}get parentId(){return this.parent&&!this.parent.isAutoRoot?this.parent.id:null}set parentId(e){this.setParentId(e)}setParentId(e){var t,n;const i=this,{parent:r}=i,s=null===e?null===(t=i.firstStore)||void 0===t?void 0:t.rootNode:null===(n=i.firstStore)||void 0===n?void 0:n.getById(e);s!==r&&(r||s)&&(i.isBatchUpdating?i.meta.batchChanges.parentId=e:s?s.appendChild(i):i.parent.removeChild(i))}static set parentIdField(e){this._parentIdField=e,Object.defineProperty(this.prototype,e,{set:function(e){this.parentId=e},get:function(){return this.parentId}})}static get parentIdField(){return this._parentIdField||"parentId"}getChildren(e){let t;return t=e.includeFilteredOutRecords?this.unfilteredChildren||this.children:e.useOrderedTree?this.orderedChildren:this.children,t}traverse(e,t,n){n=Gr(n);const i=this,r=i.getChildren(n);t||e.call(i,i);for(let t=0,i=null==r?void 0:r.length;t<i;t++)r[t].traverse(e,!1,n)}traverseBefore(e,t,n){n=Gr(n);const i=this,r=i.getChildren(n);for(let t=0,i=null==r?void 0:r.length;t<i;t++)r[t].traverse(e,!1,n);t||e.call(i,i)}traverseWhile(e,t,n){n=Gr(n);const i=this;let r=t||!1!==e.call(i,i);if(r){const t=i.getChildren(n);null!=t&&t.length&&(r=t.every((t=>t.traverseWhile(e,!1,n))))}return r}bubble(e,t=!1){let n=this;for(t||e.call(n,n);n.parent;)n=n.parent,e.call(n,n)}bubbleWhile(e,t=!1){let n=this,i=!0;for(t||(i=e.call(n,n));i&&n.parent;)n=n.parent,i=e.call(n,n);return i}contains(e,t=!1,n=void 0){return e&&"object"==typeof e&&(e=e.id),!this.traverseWhile((t=>t.id!=e),t,n)}getTopParent(e){let t;return e?(t=[],this.bubbleWhile((e=>(t.push(e),e.parent&&!e.parent.isRoot)))):(t=null,this.bubbleWhile((e=>(t=e,e.parent&&!e.parent.isRoot)))),t}appendChild(e,t=!1,n={}){return this.insertChild(e,null,t,n)}insertChild(e,t=null,n=!1,i={}){var r,s,o,a,l;const c=this,d=Array.isArray(e);var u;(e=$e.asArray(e),"number"==typeof t)&&(t=(null===(u=c.children)||void 0===u?void 0:u[t])??null);if(!n&&!1===(null===(r=c.stores)||void 0===r?void 0:r.every((t=>!1!==t.trigger("beforeAdd",{records:e,parent:c})))))return null;e=c.ingestChildren(e);const h=(null===(s=t)||void 0===s?void 0:s.parentIndex)??(null===(o=c.children)||void 0===o?void 0:o.length)??0,g=null===(a=c.beforeInsertChild)||void 0===a?void 0:a.call(c,e),m=c.internalAppendInsert(e,t,n,i);return m.length&&c.convertToParent(n),null===(l=c.afterInsertChild)||void 0===l||l.call(c,h,e,g,m,i.orderedBeforeNode),d||!m?m:m[0]}convertToParent(e=!1){const t=this,n=t.isLeaf;t.meta.isLeaf=!1,t.children||(t.children=[]),!n||t.root.isLoading||e||t.signalNodeChanged({isLeaf:{value:!1,oldValue:!0}})}signalNodeChanged(e,t=this.stores){null==t||t.forEach((t=>{t.trigger("update",{record:this,records:[this],changes:e}),t.trigger("change",{action:"update",record:this,records:[this],changes:e})}))}tryInsertChild(){return this.insertChild(...arguments)}internalAppendInsert(e,t,n,i){const r=this,{stores:s,root:o,children:a}=r,{firstStore:l}=o,{parentIdField:c}=r.constructor,d=r.id;let u,h,g,m,p,f={};if(!o.isLoading&&l)for(p=[],g=0;g<e.length;g++){const t=e[g];f[t.id]=t.root===o,p[g]=t.parentIndex}if(t&&t.parent!==r&&(t=null),a){const n=t?t.parentIndex:a.length;if(a[h=n]===e[0]||a[h=n-1]===e[0])for(u=!0,g=0;u&&g<e.length;g++)e[g]!==a[h+g]&&(u=!1)}if(u)return e;for(g=0;g<e.length;g++){const t=e[g],s=t.parent;l&&!o.isLoading&&t.traverse((e=>{e.root===o&&(f[e.id]=!0)}));const a=Boolean(f[t.id]),u=s===r&&a;if(!1===(null==s?void 0:s.removeChild(t,a,n,{isInserting:!0,skipIndexUpdate:u,...i})))m||(e=e.slice(),m=!0),e.splice(g--,1);else{t.parent=r,t.setData("parentId",d);const{meta:e}=t;e.modified[c]!==d||s||(e.oldParentId=d),s&&(e.oldParentId=s.id)}}if(e.length){Array.isArray(a)||(r.children=[]),Array.isArray(r.orderedChildren)||(r.orderedChildren=[]);const o=r.addToChildren(t,e,i);null==s||s.forEach((t=>{t.isChained||(e.forEach((e=>e.joinStore(t))),t.onNodeAddChild(r,e,o,f,n),e.forEach(((e,i)=>{if(null!=e.meta.oldParentId&&(!r.inProcessChildren&&!r.isLoading||f[e.id])){const s={[c]:d,[r.getDataSource("parentIndex")]:e.parentIndex},o={},{modified:a,oldParentId:l}=e.meta,u=p[i];if(delete e.meta.oldParentId,r.id!==l&&(o[c]={value:d,oldValue:l}),e.parentIndex!==u&&(o.parentIndex={value:e.parentIndex,oldValue:u}),a[c]===r.id?Reflect.deleteProperty(a,c):c in a||(a[c]=l),f[e.id]){const e=t.getById(l);e.isLeaf&&!n&&e.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}},[t])}e.afterChange(s,o)}e.traverse((e=>{e.ignoreBag||e.isLinked||t.updateModifiedBagForRecord(e)}))})))}))}return e}removeChild(e,t=!1,n=!1,i={}){var r,s;const o=this,a=[],l=o.isLeaf,{children:c,stores:d}=o;if(e=(e=$e.asArray(e)).filter((e=>e.parent===o)),!n&&d)for(const n of d)if(!n.isChained&&!1===n.trigger("beforeRemove",{parent:o,records:e,isMove:t}))return!1;const u=null===(r=o.beforeRemoveChild)||void 0===r?void 0:r.call(o,e,t);for(const r of e){const{parentIdField:e}=r.constructor,{modified:s}=r.meta,l=r.parent?r.parent.id:null;e in s||r.isLinked||(s[e]=l);const c=o.removeFromChildren(r,i);null==d||d.forEach((e=>{if(!e.isChained){const{isRemoving:i}=e;e.isRemoving=!0,a.push(...e.onNodeRemoveChild(o,[r],c,{isMove:t,silent:n})),e.isRemoving=i}})),t||(r.parent=r.parentIndex=r.unfilteredIndex=r.nextSibling=r.previousSibling=null,r.data[e]=null)}return 0===(o.unfilteredChildren||c).length&&o.constructor.convertEmptyParentToLeaf.onRemove&&!o.isRoot&&(o.meta.isLeaf=!0),o.isLeaf===l||n||t||o.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}}),null===(s=o.afterRemoveChild)||void 0===s||s.call(o,e,u,t),a}clearParentId(){const e=this;Reflect.deleteProperty(e.data,e.parentIdField),Reflect.deleteProperty(e.originalData,e.parentIdField),e.meta.modified&&Reflect.deleteProperty(e.meta.modified,e.parentIdField)}replaceChildren(e){return this.clearChildren(),this.data[this.constructor.childrenField]=e,this.processChildren(),this.children}clearChildren(e=!1){const t=this,{stores:n}=t,i=t.unfilteredChildren||t.children;t.children=[],t.orderedChildren=[],i&&!0!==i&&(n.forEach((n=>{n.isChained||n.onNodeRemoveChild(t,i,0,{unfiltered:!0,silent:e})})),t.unfilteredChildren&&(t.unfilteredChildren=[]));const{convertEmptyParentToLeaf:r}=t.constructor;(!0===r||r.onRemove)&&(t.meta.isLeaf=!0)}clear(){var e;const t=this,{stores:n}=t,i=null===(e=t.unfilteredChildren||t.children)||void 0===e?void 0:e.slice();if(t.isRoot&&i){for(const e of n)if(!e.isChained&&!1===e.trigger("beforeRemove",{parent:t,records:i,isMove:!1,removingAll:!0}))return!1;t.children.length=t.orderedChildren.length=0,t.unfilteredChildren&&(t.unfilteredChildren.length=0),n.forEach((e=>{i.forEach((t=>{t.stores.includes(e)&&t.unjoinStore(e),t.parent=t.parentIndex=t.nextSibling=t.previousSibling=null})),e.storage.suspendEvents(),e.storage.clear(),e.storage.resumeEvents(),e.added.clear(),e.modified.clear(),e.trigger("removeAll"),e.trigger("change",{action:"removeall"})}))}}updateChildrenIndices(e,t,n=!1){let i=null;for(let r=0;r<e.length;r++){const s=e[r],o=s[t];"parentIndex"===t||"orderedParentIndex"===t?void 0===o||n?s.setData(t,r):o!==r&&s.set(t,r,!0):s[t]=r,"parentIndex"===t&&(s.previousSibling=i,i&&(i.nextSibling=s),r===e.length-1&&(s.nextSibling=null),i=s)}}addToChildren(e,t,n={}){const i=this,r=[[i.children,"parentIndex",e],[i.unfilteredChildren,"unfilteredIndex",e],[i.orderedChildren,"orderedParentIndex",void 0===(null==n?void 0:n.orderedBeforeNode)?void 0!==(null==n?void 0:n.orderedParentIndex)?i.orderedChildren[n.orderedParentIndex.index??n.orderedParentIndex]:e:null==n?void 0:n.orderedBeforeNode]];for(const e of r){const[r,o,a]=e;if(r){var s;let l;a?(l=r.indexOf(a),-1===l&&(l=r.length)):l=r.length,e.push(l),r.splice(l,0,...t),null!=n&&n.skipIndexUpdate||null!=n&&null!==(s=n[o])&&void 0!==s&&s.skip||i.updateChildrenIndices(r,o)}}return r[0][3]}removeFromChildren(e,t){const n=[[this.children,"parentIndex"],[this.unfilteredChildren,"unfilteredIndex"],[this.orderedChildren,"orderedParentIndex"]];for(const r of n){const[n,s]=r;if(n){const o=n.indexOf(e);var i;if(r.push(o),o>-1)n.splice(o,1),null!=t&&t.skipIndexUpdate||null!=t&&null!==(i=t[s])&&void 0!==i&&i.skip||this.updateChildrenIndices(n,s)}}return n[0][2]}sortOrderedChildren(e=!0,t=!1){const n=[];return this.isLeaf||(this.orderedChildren.sort(((e,i)=>{if(t){const t=(e.meta.modified.orderedParentIndex??e.orderedParentIndex)-(i.meta.modified.orderedParentIndex??i.orderedParentIndex);return 0!==t&&(n.push(e),n.push(i)),t}return e.orderedParentIndex-i.orderedParentIndex})),e&&this.orderedChildren.forEach((i=>{n.push(...i.sortOrderedChildren(e,t))})),this.updateChildrenIndices(this.orderedChildren,"orderedParentIndex",!0)),new Set(n)}sortVisibleChildren(e=!0,t){const n=this;n.isLeaf||(n.children.sort(t),e&&n.orderedChildren.forEach((n=>n.sortVisibleChildren(e,t))),n.updateChildrenIndices(n.children,"parentIndex",!0))}sortUnfilteredChildren(e=!0,t){const n=this;!n.isLeaf&&n.unfilteredChildren&&(n.unfilteredChildren.sort(t),e&&n.orderedChildren.forEach((n=>n.sortUnfilteredChildren(e,t))),n.updateChildrenIndices(n.unfilteredChildren,"unfilteredIndex",!0))}unjoinStore(e,t=!1){var n;const i=this;i.unfilteredChildren&&(i.children=i.unfilteredChildren.slice(),i.unfilteredChildren=null),null===(n=super.unjoinStore)||void 0===n||n.call(this,e,t)}};const qr={id:1,stores:1,parentIndex:1,parent:1,parentId:1,previousSibling:1,nextSibling:1,unfilteredIndex:1},Kr={get(e,t){switch(t){case"proxyMeta":return this.proxyMeta;case"constructor":return e.constructor;case"setData":return this.setDataOverride;case"set":return this.setOverride;case"instanceMeta":return this.instanceMetaOverride;default:if(qr[t])return this.proxyMeta.data[t]}return Reflect.get(e,t,this.proxyRecord)},set(e,t,n,i){return"parentId"===t?i.setParentId(n):qr[t]?this.proxyMeta.data[t]=n:e[t]=n,!0},instanceMetaOverride(e){const{proxyMeta:t}=this,n=e.id||e,i=t.map||(t.map=W.clone(t.originalRecord.instanceMeta(n)));return i[n]||(i[n]={})},setDataOverride(e,t){"parentIndex"===e?this.proxyMeta.data.parentIndex=t:"parentId"===e?this.proxyMeta.data.parentId=t:this.proxyMeta.originalRecord.setData(e,t)},setOverride(e,t,...n){"parentIndex"===e?this.proxyMeta.data.parentIndex=t:this.proxyMeta.originalRecord.set(e,t,...n)}};var Xr=e=>class extends(e||Pe){static $name="ModelLink";static isModel=!0;link(){if(this.isLinked)return this.$original.link();const e=this,t={...Kr,proxyMeta:{originalRecord:e,data:{id:`${e.id}_link_${H.generateUUID()}`,stores:[]}}},n=new Proxy(e,t);return t.proxyRecord=n,(e.meta.linkedRecords||(e.meta.linkedRecords=[])).push(n),n}get isLinked(){var e;return Boolean(null===(e=this.proxyMeta)||void 0===e?void 0:e.originalRecord)}get hasLinks(){return Boolean(!this.proxyMeta&&this.$links.length)}removeLink(e,t=null,n=!1){if(e.hasLinks)for(const i of e.$links.slice())t?$e.include(t,i):i.remove(n);else e.isLinked&&$e.remove(e.$original.$links,e)}beforeRemove(e){this.removeLink(this,e)}removeChild(e,t,n,i){if(null==i||!i.isInserting){e=$e.asArray(e);for(const t of e)this.removeLink(t,null,n)}return super.removeChild(e,t,n,i)}get $originalId(){return this.$original.id}get $links(){return this.meta.linkedRecords??[]}};const{defineProperty:Zr}=Reflect,Jr=Symbol("owner"),Qr=/[\s,]+/;var es=e=>class extends(e||Pe){static $name="Factoryable";static get declarable(){return["factoryable","alias","type"]}static register(e,t,n=globalThis.__BRYNTUM_EXAMPLE){const{factoryable:i}=this.initClass(),{caseless:r,registry:s}=i,o=H.split(e,Qr);for(let e,a,l=0;l<o.length;++l){if(a=o[l],e=r?a.toLowerCase():a,!n&&e in s)throw new Error(`Type "${a}" already registered with ${i.class.name} factory`);s[a]=s[e]=t.initClass()}}static isA(e,t){return this.isType(e,t,!0)}static isType(e,t,n){const{factoryable:i}=this,{caseless:r,registry:s}=i,o=s[r?t.toLowerCase():t];return!!o&&(n?e instanceof o:e.constructor===o)}static setupAlias(e){e.register(e.alias,e)}static setupFactoryable(e,t){const n=t.super.class;let{factoryable:i}=e;i={caseless:!0,defaultType:null,extends:n.factoryable?[n]:null,typeKey:"type",...i},i.class=e,i.registry=Object.create(null),i.extends&&!Array.isArray(i.extends)&&(i.extends=[i.extends]),Zr(e,"factoryable",{get:()=>i})}static setupType(e,t){const{type:n}=e;e.register(n,e,t.replaceType),Zr(e.prototype,"type",{get:()=>n,set:e=>{if(e!==n)throw new Error("Can not mutate `type` config to different value")}})}static create(e,t){return this.reconfigure(null,e,t)}static reconfigure(e,t,n){const i=this,{factoryable:r}=i,{typeKey:s}=r;let o,a,l,c,d,u,h,g,m,p=n;if(n&&!W.isClass(n)&&(p=null,h=typeof n,"function"===h?u=n:"string"===h?p=n:W.isObject(n)?(o=n.cleanup,a=n.defaults,c=n.owner,u=n.setup,p=n.type,g=n.transform):c=n),g&&(t="string"==typeof g?c[g](t):g(t)),m=t,"string"==typeof m)t={};else if(t){if(!0===t&&(t={}),!W.isObject(t)){var f;if(c&&t!==e&&(null==e?void 0:e[Jr])===c)"string"==typeof o?c[o](e):null===(f=o)||void 0===f||f(e),e.destroy();return t}m=t[s]}if(m=m&&i.resolveType(m),e){if(t&&(!m||e.constructor===m))return s in t&&delete(t=W.assign({},t))[s],e.setConfig(t),e;var v;if(c&&e[Jr]===c)"string"==typeof o?c[o](e):null===(v=o)||void 0===v||v(e),e.destroy()}if(t){if(a){if(!(l=m)){if(!(l=a[s]||p||r.defaultType))throw new Error(`No default mergeType defined for ${r.class.name} factory`);l=i.resolveType(l)}l&&(t=l.mergeConfigs(a,t))}if(u){if(d="string"==typeof u?c[u](t,m,a):u(t,m,a),null===d)return d;t=d||t}if(!m){if(!(m=t[s]||p||r.defaultType))throw new Error(`No default type defined for ${r.class.name} factory`);m=i.resolveType(m)}a&&!l&&(t=m.mergeConfigs(a,t)),s in t&&delete(t=W.assign({},t))[s],t=new m(t),c&&(t[Jr]=c)}return t||null}static resolveType(e,t){if("string"!=typeof e)return e;const{factoryable:n}=this,i=n.extends;let r,s=n.registry[n.caseless?e.toLowerCase():e];for(r=0;!s&&i&&r<i.length;++r)s=i[r].resolveType(e,!0);if(!s&&!t)throw new Error(`Invalid type name "${e}" passed to ${n.class.name} factory`);return s}};const{getOwnPropertyDescriptor:ts}=Reflect;class ns extends(Pe.mixin(es)){static $name="DataField";static type="auto";static get factoryable(){return{defaultType:"auto"}}static get prototypeProperties(){return{compare:null,compareItems:null,dataSource:null,alwaysWrite:!1,nullable:!0,nullText:null,nullValue:void 0,persist:!0,readOnly:!1,internal:!1,calculated:!1,useProp:null,bypassEqualityOnSyncDataset:!1}}construct(e){const t=this;e&&(t.name=e.name,Object.assign(t,e)),t.compare&&(t.compareItems=(e,n)=>t.compare(null==e?void 0:e[t.name],null==n?void 0:n[t.name]))}defineAccessor(e,t){const{name:n,dataSource:i}=this;!t&&n in e&&e.$meta.hierarchy.some((e=>{var t;return!1===(null===(t=ts(e.prototype,n))||void 0===t?void 0:t.enumerable)}))||Reflect.defineProperty(e,n,{configurable:!0,enumerable:!0,get:this.complexMapping?function(){return this.complexGet(n,i)}:function(){return this.batching&&n in this.meta.batchChanges?this.meta.batchChanges[n]:this.data[i]},set(e){const t=this.$meta.fields.map[n];t&&t.readOnly||this.set(n,e)}})}isEqual(e,t){return W.isEqual(e,t)}print(e){return null==e?this.nullText:this.printValue(e)}printValue(e){return String(e)}getCurrentConfig(){const e={};for(const t in this.constructor.prototypeProperties)e[t]=this[t];return delete e.isConstructing,e}}ns._$name="DataField";class is extends ns{static $name="ArrayDataField";static type="array";isEqual(e,t){return e===t}getAt(e,t){return e.get(this.name)[t]}}is.initClass(),is._$name="ArrayDataField";class rs extends ns{static $name="BooleanDataField";static type="boolean";static alias="bool";static get prototypeProperties(){return{nullValue:!1}}isEqual(e,t){return null==e&&null==t||super.isEqual(e,t)}convert(e){var t;return null==e?this.nullable?e:this.nullValue:"false"!==(null===(t=e.toLowerCase)||void 0===t?void 0:t.call(e))&&Boolean(e)}}rs.initClass(),rs._$name="BooleanDataField";class ss extends ns{static $name="DateDataField";static type="date";static get prototypeProperties(){return{format:null}}convert(e){if(null==e)this.nullable||(e=this.nullValue);else if("now"===e)e=new Date;else if(!(e instanceof Date)){const t=e;(e=fr.parse(e,this.format||fr.defaultParseFormat))&&!isNaN(e)||(e=void 0,""!==t&&console.warn(`Date parsing failed for "${this.name}" field, input: ${JSON.stringify(t)}. ${this.format?`Expected format: ${this.format}.`:'You should configure your Model field with a "format" to specify how dates should be parsed. See docs for DateDataField here: https://bryntum.com/products/scheduler/docs/api/Core/data/field/DateDataField, and see https://bryntum.com/products/scheduler/docs/api/Core/helper/DateHelper for the different formats.'}"`))}return e}serialize(e){return e instanceof Date&&(e=fr.format(e,this.format||fr.defaultFormat)),e}printValue(e){return fr.format(e,this.format||fr.defaultFormat)}}ss.initClass(),ss._$name="DateDataField";class os extends ns{static $name="StringDataField";static type="string";static get prototypeProperties(){return{nullValue:""}}convert(e){return null==e?this.nullable?e:this.nullValue:String(e)}}os.initClass(),os._$name="StringDataField";class as extends os{static $name="DurationUnitDataField";static type="durationunit";isEqual(e,t){return 0===fr.compareUnits(e,t)}}as.initClass(),as._$name="DurationUnitDataField";class ls extends ns{static $name="IntegerDataField";static type="integer";static alias="int";static get prototypeProperties(){return{nullValue:0,rounding:"round"}}convert(e){return null==e?this.nullable?e:this.nullValue:Math[this.rounding](Number(e))}}ls.initClass(),ls._$name="IntegerDataField";class cs extends ns{static $name="ModelDataField";static type="model";static configurable={modelClass:null};static get prototypeProperties(){return{complexMapping:!0}}isEqual(e,t){return e&&t&&t instanceof e.constructor&&t.id==e.id}}cs.initClass(),cs._$name="ModelDataField";class ds extends ns{static $name="NumberDataField";static type="number";static alias="float";static get prototypeProperties(){return{nullValue:0,precision:null}}isEqual(e,t){return isNaN(Number(e))&&isNaN(Number(t))||super.isEqual(e,t)}convert(e){if(null==e)return this.nullable?e:this.nullValue;if(e=Number(e),isNaN(e))return;let t=this.precision;return t?(t=10**t,e=Math.round(e*t)/t):0===t&&(e=Math.round(e)),e}}ds.initClass(),ds._$name="NumberDataField";class us extends ns{static $name="ObjectDataField";static type="object";static get prototypeProperties(){return{complexMapping:!0}}}us.initClass(),us._$name="ObjectDataField";const hs=e=>"string"==typeof e&&e.startsWith("_generated");class gs extends ns{static $name="StoreDataField";static type="store";init(e,t){var n;const i=this,r=`${i.name}Store`,s={skipStack:!0,syncDataOnLoad:!0,useRawData:!1};if(i.store&&W.assign(s,i.store),i.modelClass&&(s.modelClass=i.modelClass),null===(n=t[`init${H.capitalize(r)}`])||void 0===n||n.call(t,s),!s.storeClass&&!i.storeClass)throw new Error(`Field '${i.name}' with type 'store' must have a storeClass configured`);const o=t.meta[r]=new(s.storeClass||i.storeClass)(s);i.complexMapping?W.setPath(e,i.dataSource,o):e[i.dataSource]=o,o.verifyNoGeneratedIds=!1,o.usesId=i.usesId||!o.count||!o.every((e=>e.hasGeneratedId)),o.$currentValue=i.getValue(o,t),o.ion({change:({action:e})=>{const n=i.getValue(o,t);if(!o.$isSettingStoreFieldData){const r=o.$preserveCurrentDataset;o.$preserveCurrentDataset=i.subStore&&("update"===e||"remove"===e||"add"===e),i.$isUpdatingRecord=!0,t.set(i.name,n),i.$isUpdatingRecord=!1,o.$preserveCurrentDataset=r}o.$currentValue=n}})}set(e,t,n){var i,r;const s=this,o=`${s.name}Store`,{[o]:a}=n.meta;if(null!==(i=e)&&void 0!==i&&i.isStore&&(e=e.$currentValue),!a)return n.meta.initableValues.set(s,e),!1;a.$isSettingStoreFieldData||(a.$isSettingStoreFieldData=!0,e=(null===(r=n[`process${H.capitalize(o)}Data`])||void 0===r?void 0:r.call(n,e,n))??e,a.$preserveCurrentDataset||(a.data=e),a.$isSettingStoreFieldData=!1,a.usesId=s.usesId||!a.count||!a.every((e=>e.hasGeneratedId)))}serialize(e,t){const n=t.meta[`${this.name}Store`];return this.$isUpdatingRecord?this.getValue(n,t):n.$currentValue}getValue(e,t){const n=`get${H.capitalize(this.name)}StoreValue`;return t[n]?t[n](e):e.allRecords.map((t=>{const n=t.persistableData;return e.usesId||delete n.id,n}))}isEqual(e,t){if(null==e&&null==t)return!0;if(null==e&&null!=t||null!=e&&null==t)return!1;if(e.isStore&&t.isStore)return W.isDeeplyEqual(e.$currentValue,t.$currentValue);if(e.isStore&&t.isStore||!e.isStore&&!t.isStore)return W.isEqual(e,t,!0);{const n=(e.isStore?e:t).modelClass,i=n.$meta.fields.defs,r=e.isStore?e.$currentValue:t.$currentValue,s=e.isStore?t:e;if(r.length!==s.length)return!1;for(let e=0;e<i.length;e++){const t=i[e];if(t.persist)for(let e=0;e<r.length;e++){const i=r[e][t.dataSource],o=s[e][t.dataSource];if(void 0!==i&&void 0===o){if(t.dataSource===n.idField&&hs(i))continue;if(void 0!==t.defaultValue&&W.isEqual(t.defaultValue,i,!0))continue}if(!W.isEqual(i,o,!0))return!1}}return!0}}getOldValue(e){const t=e.meta[`${this.name}Store`];return t?W.clone(t.$currentValue):null}getAt(e,t){const n=e.meta[`${this.name}Store`];return null==n?void 0:n.getAt(t)}}gs.initClass(),gs._$name="StoreDataField";const ms=new RegExp(/^(.*?)\.(.*)/),ps=/(.*)\[(.*)]\.?(.*)/,{defineProperty:fs}=Reflect,{hasOwn:vs}=W,ys=void 0,bs={children:1,data:1,meta:1},Cs=["name","title","text","label","description"],Ss={boolean:1,number:1,date:1,object:1},Ds={parentId:1,$PhantomId:2,id:3};class ws extends(Pe.mixin(Wr,Yr,Xr)){static $name="Model";static get declarable(){return["fields"]}static get fields(){return[{name:"parentIndex",type:"number",persist:!1,internal:!0},{name:"orderedParentIndex",type:"number",persist:!1,internal:!0},{name:"readOnly",type:"boolean"},{name:"expanded",internal:!0}]}static relations=null;static set idField(e){this._assignedIdField=!0,this._idField=e}static get idField(){return this._idField}get id(){return this._id??this.getData("id")}set id(e){this.set("id",e)}static set childrenField(e){this._childrenField=e}static get childrenField(){if(!this._childrenField){const e=this.fieldMap.children;this._childrenField=(null==e?void 0:e.dataSource)||"children"}return this._childrenField}get indexPath(){const e=[];let t=this,n=t.childLevel;for(t=this;t&&!t.isRoot;t=t.parent)e[n--]=t.parentIndex+1;return e}construct(e={},t=null,n=null,i=!1,r=!1,s=!1){var o;const a=this,{constructor:l,fieldMap:c}=a;if(a.meta={modified:{},...l.metaConfig,...n},l.applyConfigs){const t={};a.useRawData&&a.useRawData.enabled||(e={...e});const n=a.getDefaultConfiguration();if(l.autoExposeFields)for(const i in n)i in e&&(void 0!==e[i]&&(t[i]=e[i]),delete e[i]);else for(const i in e)i in l.fieldMap||(void 0===e[i]?t[i]=n[i]:t[i]=e[i],delete e[i]);super.construct(t)}else super.construct(null);if(i||l.exposeProperties(e,s),!vs(l,"idFieldProcessed")){let e=a.meta.idField;e||l._assignedIdField&&(e=l.idField),e&&e!==c.id.dataSource&&l.addField({name:"id",dataSource:e,internal:!0}),l._idField=c.id.dataSource,l.idFieldProcessed=!0}a._internalId=ws._internalIdCounter++,a.originalData||(a.originalData=e),a.data=l.processData(e,!1,t,a,r),a._id=c.id.complexMapping?W.getPath(a.data,l._idField):a.data[l._idField],(null===(o=a.meta.initableValues)||void 0===o?void 0:o.size)&&a.assignInitables(),null!=a._id||l.allowNullId&&null===a._id||a.setData("id",a.generateId(t)),a.data[l.childrenField]&&a.processChildren($e.asArray(t)??[]),a.generation=0}set isCreating(e){const t=this;var n;Boolean(t.meta.isCreating)!==e&&(t.meta.isCreating=e,null===(n=t.stores)||void 0===n||n.forEach((n=>n.onIsCreatingToggle(t,e))))}get isCreating(){return Boolean(this.meta.isCreating)}equals(e){if(e instanceof this.constructor){for(let t=this.$meta.fields.defs,n=0,{length:i}=t;n<i;n++){const i=t[n],{name:r}=i;if("id"!==r&&!i.isEqual(this.getValue(r),e.getValue(r)))return!1}return!0}return!1}get subclass(){return new this.constructor(Object.setPrototypeOf({id:ys},this.data),this.stores[0],null,!0)}static processData(e,t=!1,n,i,r){const{fieldMap:s,defaultValues:o}=this,{useRawData:a={enabled:!1}}=n||{},l=r||a.enabled?e:W.clone(e);let c;if(!(t=t||a.disableDefaultValue||r)||!a.disableTypeConversion&&!r)for(c in s){const n=s[c],{name:r,dataSource:d}=n,u=d!==r,h=n.complexMapping,g=h?W.getPath(l,d):l[d],m=void 0===g?h?W.getPath(l,r):l[r]:void 0,p=void 0!==g,f=void 0!==m,v=!p&&f,y=p||f,b=!a.disableTypeConversion&&n.convert;let C=v?m:g;if(!t&&d in o&&!y&&!n.fromData){let e=o[d];Array.isArray(e)?e=e.slice():e instanceof Date?e=new Date(e):e&&"object"==typeof e&&(e=W.clone(e)),h?W.setPath(l,d,e):l[d]=e,C=e}if((v||b)&&(!t||y)){const t=b?n.convert(C,e,i):C;if(void 0===t&&C===ys&&!p)continue;h?W.setPath(l,d,t):l[d]=t,u&&delete l[r]}}return this.$meta.fields.initable.length&&this.initInitables(i,l),l}static setupClass(e){super.setupClass(e),e.fields||this.setupFields(this,e)}static setupFields(e,t){const n=vs(e,"fields")&&e.fields,i=t.super.fields,r=t.fields={defs:(null==i?void 0:i.defs.slice())??[],exposedData:!1,defaults:i?{...i.defaults}:{},exposed:Object.create((null==i?void 0:i.exposed)??null),ordinals:Object.create((null==i?void 0:i.ordinals)??null),map:Object.create((null==i?void 0:i.map)??null),sources:Object.create((null==i?void 0:i.sources)??null)};vs(e,"defaults")&&Object.assign(r.defaults,e.defaults),vs(e,"idField")&&(e.addField({name:"id",dataSource:e.idField,internal:!0}),r.exposed[e.idField]=!0),null!=n&&n.length&&n.map(e.addField,e),r.initable=r.defs.filter((e=>e.init)),e.exposeRelations()}static get defaultValues(){return this.$meta.fields.defaults}static get allFields(){return this.$meta.fields.defs}get allFields(){return this.$meta.fields.defs}static get fieldMap(){return this.$meta.fields.map}get fieldMap(){return this.$meta.fields.map}static get fieldDataSourceMap(){return this.$meta.fields.sources}static exposeProperties(e,t=!0){const n=this,i=n.$meta.fields,r=t?"exposed":"map";if(e&&n.autoExposeFields&&!i.exposedData){let t,s,o;for(t in e)i[r][t]||t===n.childrenField||(o=W.typeOf(e[t]),s={name:t,dataSource:t,fromData:!0},Ss[o]&&(s.type=o),n.addField(s));i.exposedData=!0}n.exposeRelations()}static addField(e){if(null==e)return;"string"==typeof e&&(e={name:e});const t=this.initClass(),n=t.$meta.fields,{ordinals:i}=n,r=n.exposed,{name:s}=e,o=n.map[s],a=e.dataSource||(e.dataSource=s);let l,c;if(!o||e.type&&e.type!==o.type)l=ns.create(e),l.definedBy=o?o.definedBy:t,l.ordinal=o?o.ordinal:i[s]=n.defs.length;else for(c in l=Object.create(o),e)"type"!==c&&(l[c]=e[c]);return l.owner=t,n.defs[l.ordinal]=l,n.map[s]=l,n.sources[a]=l,a.includes(".")&&(l.complexMapping=!0),l.complexMapping?r[a.split(".")[0]]=!0:r[a]=!0,"defaultValue"in l&&(n.defaults[a]=l.defaultValue),bs[s]||l.defineAccessor(t.prototype),t._nonPersistableFields=null,t._alwaysWriteFields=null,l}static removeField(e){const t=this.initClass(),n=t.$meta.fields,i=n.map[e],{ordinals:r}=n,s=r[e];if(i){n.defs.splice(s,1),delete r[e],delete n.defaults[e],delete n.exposed[e],delete n.map[e],delete n.sources[i.dataSource];for(const e in r)r[e]>s&&--r[e];delete t.prototype[e]}}static exposeRelations(){const e=this;if(!vs(e,"exposedRelations")&&e.relations){e.exposedRelations=[];for(const t in e.relations){const n=e.relations[t];n.relationName=t,e.exposedRelations.push(n),Reflect.ownKeys(e.prototype).includes(t)||fs(e.prototype,t,{enumerable:!0,get:function(){return this.getForeign(t)},set:function(e){this.setForeign(t,e,n)}})}}}static initInitables(e,t){const n=e.meta.initableValues=new Map;for(const i of this.$meta.fields.initable){const r=W.getPath(t,i.dataSource);void 0!==r&&n.set(i,r),!i.lazy&&i.init(t,e)}}assignInitables(){const{initableValues:e}=this.meta;for(const[t,n]of e)!1!==t.set(n,this.data,this)&&e.delete(t)}static get autoExposeFields(){return!0}static fieldSorter(e,t){return(Ds[e]||100)-(Ds[t]||100)}get fields(){return this.$meta.fields.defs}getFieldDefinition(e){return this.constructor.getFieldDefinition(e)}getFieldDefinitionFromDataSource(e){return this.$meta.fields.sources[e]}get fieldNames(){return Object.keys(this.data)}static getFieldDefinition(e){const t=this.fieldMap[e];if(!t)if(e.includes("[")){const[,t,,i]=e.match(ps),r=t.includes(".")?this.getFieldDefinition(t):this.fieldMap[t];var n;if(null!=r&&r.isStoreDataField)return null===(n=r.modelClass)||void 0===n?void 0:n.getFieldDefinition(i)}else if(e.includes(".")){const[t,n]=e.split(".",2),i=this.fieldMap[t];if(null!=i&&i.isModelDataField&&i.modelClass)return i.modelClass.getFieldDefinition(n)}return t}static getFieldDataSource(e){var t;return(null===(t=this.getFieldDefinition(e))||void 0===t?void 0:t.dataSource)||e}getDataSource(e){const t=this.constructor.getFieldDefinition(e);return(null==t?void 0:t.dataSource)||(null==t?void 0:t.name)}static processField(e,t,n){const i=this.fieldMap[e];return null!=i&&i.convert?i.convert(t,this.data,n):t}initRelations(){const e=this;e.constructor.exposedRelations&&e.stores.forEach((t=>{var n;t.modelRelations||t.initRelations();const i=[];null===(n=t.modelRelations)||void 0===n||n.forEach((t=>{i.push({related:e.initRelation(t),config:t})})),t.updateRecordRelationCache(e,i)}))}initRelation(e){const t=this,n=t.get(e.foreignKey),i=n!==ys&&"string"!=typeof e.foreignStore&&e.foreignStore.getById(n);return(t.meta.relationCache||(t.meta.relationCache={}))[e.relationName]=i||(null!=n?{id:n,placeHolder:!0}:null),i}removeRelation(e){const{relationName:t,foreignKey:n,nullFieldOnRemove:i}=e;this.meta.relationCache[t]&&(delete this.meta.relationCache[t],i&&this.setData(n,null))}getForeign(e){var t;return null===(t=this.meta.relationCache)||void 0===t?void 0:t[e]}setForeign(e,t,n){const i=ws.asId(t);return this.set(n.foreignKey,i)}getRelationConfig(e){var t;return null===(t=this.firstStore)||void 0===t||null===(t=t.modelRelations)||void 0===t?void 0:t.find((t=>t.foreignKey===e))}flatGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:this.data[t]}complexGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:W.getPath(this.data,t)}get(e){if(!e)return;const t=this,{fieldMap:n}=t,i=n[e];if(!i){if(e.includes("[")){const[,i,r,s]=e.match(ps),o=n[i];if(null!=o&&o.getAt){t._thisIsAUsedExpression(t[i]);const e=o.getAt(t,r);return e&&s?e.isModel?e.getValue(s):e[s]:e}return null}if(e.includes(".")){const[i,r]=e.split(".",2),s=n[i];if(null!=s&&s.isStoreDataField){const e=t[i];return r in e.modelClass.fieldMap||!(r in e)?null==e?void 0:e.getDistinctValues(r):e[r]}return W.hasPath(t.data,e)?t.complexGet(e,e):W.getPath(t,e)}}return null!=i&&i.complexMapping?t.complexGet(e,i.dataSource):t.flatGet(e,(null==i?void 0:i.dataSource)||e)}getValue(e){if(e)return e in this&&!e.includes(".")?this[e]:this.get(e)}setValue(e,t){e in this?this[e]=t:this.set(e,t)}setData(e,t){const{data:n,fieldMap:i}=this;if("string"==typeof e){const r=i[e],s=(null==r?void 0:r.dataSource)??e;null!=r&&r.set?r.set(t,this.data,this):null!=r&&r.complexMapping?W.setPath(n,s,t):n[s]=t,"id"===r?this._id=t:"parentId"===e&&(n[this.constructor.parentIdField]=t)}else{const r=Object.keys(e);for(let s=0;s<r.length;s++){const o=r[s],a=i[o],l=(null==a?void 0:a.dataSource)??o;null!=a&&a.set?a.set(t,this.data,this):l&&(null!=a&&a.complexMapping?W.setPath(n,l,e[o]):n[l]=e[o],"id"===o?this._id=t:"parentId"===o&&(n[this.constructor.parentIdField]=t))}}}getData(e){const t=this.fieldMap[e],n=(null==t?void 0:t.dataSource)??e;if(n)return null!=t&&t.complexMapping?W.getPath(this.data,n):this.data[n]}syncId(e){const t=this.id;if(t!==e){this._id=e,this.setData("id",e);const n={id:{value:e,oldValue:t}};this.afterChange(n,n)}}set(e,t,n=!1,i=!1,r=!1,s=!1,o=!0){const a=this;if(a.isBatchUpdating)return a.inBatchSet(e,t,n||a.$silenceBatch),null;{var l;const c=a.inSet(e,t,n,i,r,s,o);return null===(l=a.afterSet)||void 0===l||l.call(a,e,t,n,i,c),c}}fieldToKeys(e,t){return"string"!=typeof e?W.assign({},e):{[e]:t}}inBatchSet(e,t,n){const i=this,{meta:r,constructor:s,fieldMap:o}=i,a={};let l,c=!1;if("string"!=typeof e?Object.keys(i.fieldToKeys(e,t)).forEach((n=>{l=o[n]||W,t=s.processField(n,e[n],i),l.isEqual(r.batchChanges[n],t)||(a[n]={value:t,oldValue:i.get(n)},r.batchChanges[n]=t,c=!0)})):(l=o[e]||W,l.isEqual(r.batchChanges[e],t)||(a[e]={value:t,oldValue:i.get(e)},r.batchChanges[e]=t,c=!0)),c&&(i.generation++,!n)){var d;const e={action:"update",record:i,records:[i],changes:a};null===(d=i.stores)||void 0===d||d.forEach((t=>t.trigger("batchedUpdate",{...e}))),i.forEachLinked(((t,n)=>t.trigger("batchedUpdate",{...e,record:n,records:[n]})))}}inSet(e,t,n,i,r=!1,s=!1,o=!0){var a,l;const c=this,{data:d,meta:u,fieldMap:h,constructor:g}=c,{prototype:m,childrenField:p,relations:f}=g,v={},y=c.fieldToKeys(e,t),b=Object.keys(y).sort(g.fieldSorter),C=null===(a=c.stores)||void 0===a?void 0:a.some((e=>e.isSyncingDataOnLoad)),S=null===(l=c.stores)||void 0===l?void 0:l.some((e=>e.modificationsTracking>0));let D=!1;if(!n&&o&&!c.triggerBeforeUpdate(y))return null;c.inSetting=!0;for(let e=0;e<b.length;e++){const t=b[e];if(t===p)continue;if(t.includes("[")){const[,e,n,i]=t.match(ps),r=c.fieldMap[e];if(null!=r&&r.getAt){var w;const s=r.getAt(c,n)??(null===(w=r.onSubRecordMissingInSet)||void 0===w?void 0:w.call(r,c,n));if(null==s)throw new Error(`The store field '${e}' does not contain a record at index ${n} - can not set the data`);s.isModel?s.set(i,y[t]):W.setPath(s,i,y[t]);continue}}const n=t.includes(".");if(f&&n){const[,e,n]=t.match(ms);if(f[e]){n.includes(".")?c[e].set(n,y[t]):c[e][n]=y[t];continue}}const o=h[t],a=o||W,l=null==o?void 0:o.readOnly,R=(null==o?void 0:o.dataSource)??t,x=!r&&!o&&t in m||(null==o?void 0:o.useProp),T=x?c[R]:null!=o&&o.complexMapping||n?W.getPath(d,R):d[R],M=g.processField(t,y[t],c),I=y[t]={value:M},A=c.getRelationConfig(t);var E;if(!l&&(C&&null!=o&&o.bypassEqualityOnSyncDataset||!a.isEqual(T,M))&&(!s||void 0!==M))c.generation++,I.oldValue=(null==o||null===(E=o.getOldValue)||void 0===E?void 0:E.call(o,c))??T,D=!0,t in u.modified&&a.isEqual(u.modified[t],M,!1,!0)?(Reflect.deleteProperty(u.modified,t),c.isReverting&&(c.data[R]=M)):c.ignoreBag||S?S&&Reflect.deleteProperty(u.modified,t):(t in u.modified||null==T&&null==M||c.storeFieldChange(t,T),I.oldValue===ys&&Reflect.deleteProperty(I,"oldValue")),v[t]=I,c.applyValue(x,R,M,r,o),A&&!i&&(c.initRelation(A),c.stores.forEach((e=>e.cacheRelatedRecord(c,M,A.relationName,I.oldValue))))}return D&&c.afterChange(y,v,n,i,r),c.inSetting=!1,D?v:null}applyValue(e,t,n,i,r){var s,o,a;const l=this;var c,d;if(((null===(s=r)||void 0===s?void 0:s.dataSource)||t)===l.constructor.idField&&(l.$isPhantom=!1,l._id=n),((null===(o=r)||void 0===o?void 0:o.dataSource)||t)===l.constructor.parentIdField)null!==(c=l.firstStore)&&void 0!==c&&c.tree&&(null===(d=l.parent)||void 0===d||!d.isRoot||null!=n&&l.firstStore.getById(n))&&(l.firstStore.getById(n)||l.firstStore.rootNode).insertChild(l,null,!1,{orderedParentIndex:{skip:!0}});else if(e){var u;l[(null===(u=r)||void 0===u?void 0:u.name)||t]=n}else if(null!==(a=r)&&void 0!==a&&a.set)r.set(n,l.data,l);else{var h;let e=null===(h=r)||void 0===h?void 0:h.complexMapping;if(!r&&t.includes(".")){var g,m;const n=t.split(".")[0];e=(null===(g=r=l.constructor.fieldMap[n])||void 0===g?void 0:g.complexMapping)||"object"===(null===(m=r)||void 0===m?void 0:m.type)}e?W.setPath(l.data,t,n):l.data[t]=n}}afterChange(e,t,n,i,r){if(this.stores)for(const s of this.stores)s.onModelChange(this,e,t,n,i,r);this.forEachLinked(((s,o)=>s.onModelChange(o,e,t,n,i,r)))}forEachLinked(e){for(const t of this.$links)for(const n of t.stores)e(n,t)}get isPersistable(){return!this.isBatchUpdating&&!this.isCreating}get isModified(){return Boolean(this.meta.modified&&Object.keys(this.meta.modified).length>0)}get hasPersistableChanges(){return this.isPersistable&&!W.isEmpty(this.rawModificationData)}isFieldModified(e){return this.isModified&&e in this.meta.modified}getUnmodified(e){return this.isModified?this.meta.modified[e]:this.get(e)}getFieldPersistentValue(e){const t="string"==typeof e?this.getFieldDefinition(e):e,n=(null==t?void 0:t.name)||e;let i;return t&&!t.persist||(i=this.getValue(n),null!=t&&t.serialize&&(i=t.serialize(i,this))),i}get modifications(){const e=this.rawModifications;return e&&Object.keys(e).length&&(e[this.constructor.idField]=this.id),e}get rawModifications(){const e=this,t={};if(!e.isModified)return null;let n=!1;return Object.keys(e.meta.modified).forEach((i=>{const r=e.getFieldPersistentValue(i);r!==ys&&(t[i]=r,n=!0)})),n?t:null}get modificationData(){const e=this.rawModificationData;return e&&Object.keys(e).length&&W.setPath(e,this.constructor.idField,this.id),e}get rawModificationData(){const e=this,{fieldMap:t}=e.constructor,n={};if(!e.isModified)return null;let i=!1;return Object.keys(e.meta.modified).forEach((r=>{var s,o;let a=t[r],l=null===(s=a)||void 0===s?void 0:s.dataSource;if(r.includes(".")){const e=r.match(ms)[1];a=t[e],l=r}if(null!==(o=a)&&void 0!==o&&o.persist){const t=e.getFieldPersistentValue(r);t!==ys&&(W.setPath(n,l,t),i=!0)}})),i?n:null}get modificationDataToWrite(){const e=this.constructor.alwaysWriteFields,t=this.modificationData;return e.forEach((e=>{t[this.getFieldDefinition(e).dataSource]=this.getFieldPersistentValue(e)})),t}get persistableData(){const e=this,t={};return e.fields.forEach((n=>{const i=e.getFieldPersistentValue(n);i!==ys&&(null!=n&&n.complexMapping?W.setPath(t,n.dataSource,i):t[n.dataSource]=i)})),t}get dataByFieldName(){const{data:e}=this;return this.fields.reduce(((t,n)=>(W.hasPath(e,n.dataSource)&&(t[n.name]=e[n.dataSource]),t)),{})}get isCommitting(){return Boolean(this.meta.committing)}internalClearChanges(e=!0,t=!0,n=null,i=!1){const r=this,{meta:s}=r;if(n){for(const e in n)delete s.modified[e];if(i)for(const e in s.modified){var o;null!==(o=r.getFieldDefinition(e))&&void 0!==o&&o.persist||delete s.modified[e]}}else s.modified=Object.assign({},s.modifiedMaterialized),s.modifiedMaterialized=null;const a=W.isEmpty(s.modified);var l;(s.committing=!1,t)&&(null===(l=r.stores)||void 0===l||l.forEach((t=>{if(a&&t.modified.remove(r),t.added.remove(r),e){const e=t.collectDescendants(r).all;t.added.remove(e),a&&t.modified.remove(e)}})))}clearChanges(e){var t;this.internalClearChanges(e),null===(t=this.stores)||void 0===t||t.forEach((e=>e.trigger("clearChanges",{record:this})))}storeFieldChange(e,t){const{meta:n}=this;n.modified[e]=t,this.isBeingMaterialized&&(n.modifiedMaterialized=n.modifiedMaterialized??{},n.modifiedMaterialized[e]=t)}revertChanges(e=!1){this.isReverting=!0,this.set(this.meta.modified,ys,e),this.isReverting=!1}setByDataSource(e){const{fieldDataSourceMap:t}=this.constructor,n=W.pathifyKeys(e,t),i={};for(const e in n){const r=t[e];i[(null==r?void 0:r.name)??e]=n[e]}return this.set(i)}applyChangeset(e,t="$PhantomId",n=!0){const i=this,r=i.constructor,{idField:s,fieldDataSourceMap:o}=r,a=W.pathifyKeys(e,o),l=W.pathifyKeys(i.modificationData),c={},d=t in e&&!(s in e);!d&&t in a&&delete a[t];for(const e in a){const t=o[e],i=(null==t?void 0:t.name)??e;(n||((null==t?void 0:t.name)===s?d:a[e]===l[e]))&&(c[i]=a[e])}const u=i.set(c);return i.internalClearChanges(!1,!0,n?null:c),u?Object.entries(u).reduce(((e,[t,n])=>(e[t]=n.value,e)),{}):{}}get internalId(){return this._internalId}get isPhantom(){return""===this.id||null==this.id||this.hasGeneratedId||Boolean(this.$isPhantom)}get isModel(){return!0}get hasGeneratedId(){return"string"==typeof this.id&&this.id.startsWith("_generated")}static generateId(e=this.$$name){return`_generated${e}_${H.generateUUID()}`}generateId(){return this.constructor.generateId()}static asId(e){return null!=e&&e.isModel?e.id:W.isObject(e)?e[this.fieldMap.id.dataSource]:e}get json(){return H.safeJsonStringify(this)}toJSON(){const{children:e,unfilteredChildren:t}=this,n=this.persistableData;return(t||e)&&(n[this.constructor.childrenField]=(t||e).map((e=>e.toJSON()))),n}toString(){const e=this,t=Cs.find((t=>t in e.constructor.fieldMap)),n=t?{[e.constructor.idField]:e.id,[t]:e[t]}:e.data;return H.safeJsonStringify(n)}get isBatchUpdating(){return Boolean(this.batching)}hasBatchedChange(e){var t;return null===(t=this.meta)||void 0===t||null===(t=t.batchChanges)||void 0===t?void 0:t[e]}beginBatch(e=!1){const t=this;t.batching||(t.batching=0,t.meta.batchChanges={}),e&&(t.$silenceBatch=(t.$silenceBatch||0)+1),t.batching++}endBatch(e=!1,t=!1,n=!0){const i=this,{parentIdField:r}=i.constructor;if(i.batching&&(i.batching--,i.$silenceBatch&&i.$silenceBatch--,!(i.batching>0||W.isEmpty(i.meta.batchChanges)))){let{batchChanges:s}=i.meta;i.meta.batchChanges=null,s[r]&&(s={...s},i.parentId=s[r],delete s[r]),i.set(s,ys,e,!1,t,void 0,n)}}cancelBatch(){if(this.batching){const t=this,{batchChanges:n}=t.meta,i={};if(t.batching=null,t.meta.batchChanges=null,t.generation++,!t.$silenceBatch){var e;Object.entries(n).forEach((([e,n])=>{i[e]={oldValue:n,value:t[e]}}));const r={action:"update",record:t,records:[t],changes:i};null===(e=t.stores)||void 0===e||e.forEach((e=>e.trigger("batchedUpdate",{...r}))),t.forEachLinked(((e,t)=>e.trigger("batchedUpdate",{...r,record:t,records:[t]})))}t.$silenceBatch&&t.$silenceBatch--}}triggerBeforeUpdate(e){var t;return!(null!==(t=this.stores)&&void 0!==t&&t.some((t=>!1===t.trigger("beforeUpdate",{record:this,changes:e}))))}copy(e=null,t){const n=this,i=W.clone(n.data),r=n.constructor.idField,s=W.isObject(t)?t.deep:t;let o;if(e&&"object"==typeof e?(o=e[r],Object.assign(i,e)):o=e,s&&n.children?i.children=n.children.map((n=>n.copy(!1!==e&&void 0,t))):(delete i.children,delete i.expanded),n.$meta.fields.initable.length>0){const e=n.toJSON();for(const t of n.$meta.fields.initable)i[t.name]=e[t.name]}!1!==e&&(i[r]=o||n.generateId(n.firstStore));const a=new n.constructor(i,null,null,!1,!0);return a.originalInternalId=n.internalId,a}copyData(e,t,n){const i={},r=this.skipCopyFields||{};e.allFields.forEach((({name:n})=>{n===e.constructor.idField||n in r||(i[n]=t?e.get(n):e.getValue(n))})),this.set(i,null,n)}remove(e=!1){const t=this,{parent:n,stores:i}=t;if(n)n.removeChild(t);else if(null!=i&&i.length&&!t.isSpecialRow){i.slice().forEach((n=>n.remove(t,e,!1,!0)))}}beforeRemove(e,t){return super.beforeRemove(e,t)}get isValid(){return!0}get firstStore(){var e;return null===(e=this.stores)||void 0===e?void 0:e[0]}joinStore(e){const t=this;var n,i;t.stores&&t.stores.includes(e)||(super.joinStore(e),e.register(t),t.stores?t.stores.push(e):t.stores=[e],t.unjoinedStores&&t.unjoinedStores.includes(e)&&t.unjoinedStores.splice(t.unjoinedStores.indexOf(e),1),(null===(n=t.children)||void 0===n?void 0:n.length)&&t.children.forEach((t=>t.joinStore(e))),t.constructor.exposedRelations&&t.initRelations(),!e.tree||t.isRoot||null!==(i=e.stm)&&void 0!==i&&i.isRestoring||(t.instanceMeta(e.id).collapsed=!t.expanded))}unjoinStore(e,t=!1){const n=this,{stores:i}=n;var r,s,o;null!=i&&i.includes(e)&&(e.isDestroying||(e.unregister(n),n.unjoinedStores?n.unjoinedStores.push(e):n.unjoinedStores=[e]),null===(r=n.unfilteredChildren||n.children)||void 0===r||null===(s=r.forEach)||void 0===s||s.call(r,(n=>n.unjoinStore(e,t))),i.splice(i.indexOf(e),1),null===(o=super.unjoinStore)||void 0===o||o.call(this,e,t),e.uncacheRelatedRecord(n),n.meta.map&&!e.stm&&delete n.meta.map[e.id])}isPartOfStore(e){var t;return e?e.includes(this):(null===(t=this.stores)||void 0===t?void 0:t.length)>0}get isRemoved(){return!this.isPartOfStore()}instanceMeta(e){var t;const{meta:n}=this,i=e.id||e;return(null===(t=n.map)||void 0===t?void 0:t[i])||this.setInstanceMeta(i,{})}setInstanceMeta(e,t){const{meta:n}=this,i=e.id||e;return n.map||(n.map={}),n.map[i]=t}get isGroupHeader(){return"groupRowFor"in this.meta}get isGroupFooter(){return"groupFooterFor"in this.meta}get isSpecialRow(){var e;return Boolean(null===(e=this.meta)||void 0===e?void 0:e.specialRow)}get $original(){return this.isLinked?this.proxyMeta.originalRecord:this}static get nonPersistableFields(){const e=this;return e._nonPersistableFields||(e._nonPersistableFields={},e.allFields.forEach((t=>{t.persist&&!t.calculated||(e._nonPersistableFields[t.name]=1)}))),e._nonPersistableFields}static get alwaysWriteFields(){const e=this;return e._alwaysWriteFields||(e._alwaysWriteFields=[],e.allFields.forEach((t=>{t.alwaysWrite&&e._alwaysWriteFields.push(t.name)}))),e._alwaysWriteFields}get domId(){return"string"==typeof this.id?this.id.replace(/[ .]/g,"-"):this.id}static toJavaScriptValue(e){const{names:t}=this.$meta;return`class ${t[t.length-2]} extends ${t[t.length-3]} { static fields = ${H.toJavaScriptValue(this.fields,e)}; }`}getCurrentConfig(e){const{data:t,children:n}=this,{defaultValues:i,applyConfigs:r}=this.constructor,s=r?super.getCurrentConfig(e):{};if(s){for(const n of this.fields)if(n.persist){const r=W.getPath(t,n.dataSource);null==r||n.isEqual(r,i[n.name])||W.setPath(s,n.dataSource,Pe.processConfigValue(r,e))}if(n)if(Array.isArray(n)){s.children=[];for(const t of n)s.children.push(t.getCurrentConfig(e))}else s.children=n;this.hasGeneratedId&&delete s.id,delete s.parentId,delete s.parentIndex}return s}}ws._idField="id",ws._internalIdCounter=1,ws._assignedIdField=!1,ws.exposeProperties(),ws._$name="Model";const Es=Object.hasOwn||((e,t)=>Object.prototype.hasOwnProperty.call(e,t));let Rs=null;class xs{constructor(e){this.formatter=e}format(e){return this.formatter.defaultFormat(e)}parse(e,t){return this.formatter.defaultParse(e,t)}resolvedOptions(){return null}}class Ts{static standardOptions=Object.freeze([]);static get(e){if(null==e)return this.NULL;if(e instanceof this)return e;const t="string"==typeof e?e:JSON.stringify(e),n=this.cache;let i=n.get(t);return i||(Rs=t,i=new this(e),n.set(t,i)),i}static get cache(){return Es(this,"_cache")&&this._cache||(this._cache=new Map)}static get NULL(){return Es(this,"_null")?this._null:this._null=new this(null)}constructor(e){const t=this,{standardOptions:n}=t.constructor;if(t.cacheKey=Rs,Rs=null,t.initialize(),null===e)t.formatter=new xs(t);else{t.configure(e);for(const[e,i]of Object.entries(t.resolvedOptions()))null!=i&&n.includes(e)&&(t[e]=i)}}get parser(){return e=this,t=new this.constructor.Parser(this),Object.defineProperty(e,"parser",{value:t}),t;var e,t}defaultFormat(e){return null==e?e:String(e)}defaultParse(e){return e}format(e){return null==e?e:this.formatter.format(e)}parse(e,t){return null==e?e:this.parser.parse(e,t)}parseStrict(e){return this.parse(e,!0)}resolvedOptions(){return this.formatter.resolvedOptions()}}Ts._$name="Formatter";const Ms=H.escapeRegExp,Is=/[\d+-]/g,As=(e,t)=>new Intl.NumberFormat(e||void 0,t),ks=/^(?:([$])\s*)?(?:(\d+)>)?\d+(,\d+)?(?:\.((\d*)(?:#*)|[*]))?(?:\s*([%])?)?$/;class Fs extends Ts{static $name="NumberFormat";static standardOptions=["currency","currencyDisplay","locale","maximumFractionDigits","minimumFractionDigits","minimumIntegerDigits","maximumSignificantDigits","minimumSignificantDigits","style","useGrouping"];initialize(){this._as={},this.is={decimal:!1,currency:!1,percent:!1,null:!0,from:null}}get truncator(){const e=this.maximumFractionDigits,t=Math.min(20,e+1);return null==e?null:this.as({style:"decimal",maximumFractionDigits:t,minimumFractionDigits:t},"truncator")}configure(e){"string"!=typeof e?Object.assign(this,e):this.template=e;const t=this,n={},i=t.locale?yi.locales[t.locale]:yi.locale,r=null==i?void 0:i.NumberFormat,{template:s}=t,{standardOptions:o}=t.constructor;if(r)for(const e in r)null==t[e]&&"function"!=typeof r[e]&&(t[e]=r[e]);if(s){const e=ks.exec(s),n=e[2],i=e[4];t.useGrouping=!!e[3],t.style=e[1]?"currency":e[6]?"percent":"decimal",n&&(t.integer=+n),"*"===i?t.fraction=[0,20]:null!=i&&(t.fraction=[e[5].length,i.length])}t._minMax("fraction",!0,!0),t._minMax("integer",!0,!1),t._minMax("significant",!1,!0);for(const e of o)null!=t[e]&&(n[e]=t[e]);t.is.from=t.from&&t.from.is,t.is[t.style]=!(t.is.null=!1),t.formatter=As(t.locale,n)}as(e,t=null){const n=this.resolvedOptions()||{template:"9.*"},i=this._as;let r=t&&i[t];return r||("string"==typeof e?n.style=e:Object.assign(n,e),n.from=this,r=new Fs(n)),t&&(i[t]=r),r}defaultParse(e,t){return null==e?e:t?Number(e):parseFloat(e)}format(e){if("string"==typeof e){const t=Number(e);e=isNaN(t)?this.parse(e):t}return super.format(e)}round(e){return this.parse(this.format(e))}truncate(e){const t=this,n=t.maximumFractionDigits,{truncator:i}=t;let r,s=t.parse(e);return i&&(s=i.format(s),r=s.indexOf(i.parser.decimal),r>-1&&s.length-r-1>n&&(s=s.slice(0,r+n+1)),s=i.parse(s)),s}resolvedOptions(){const e=super.resolvedOptions();for(const t in e)void 0===e[t]&&(e[t]=this[t]);return e}_minMax(e,t,n){const i=this,r=i[e];if(null!=r){const s=H.capitalize(e),o=`maximum${s}Digits`,a=`minimum${s}Digits`;"number"==typeof r?(t&&(i[a]=r),n&&(i[o]=r)):(i[a]=r[0],i[o]=r[1])}}}Fs.Parser=class{constructor(e){const t=this,n=e.locale,i=As(n,{maximumFractionDigits:3}),r=e.is.currency?t._decodeStyle(n,{style:"currency",currency:e.currency,currencyDisplay:e.currencyDisplay}):null,s=e.is.percent?t._decodeStyle(n,{style:"percent"}):null,o=i.format(1.2).replace(Is,"")[0],a=i.format(1e9).replace(Is,"")[0]||"";Object.assign(t,{currency:r,decimal:o,formatter:e,grouper:a,percent:s}),t.decimal=o,t.decimalRe=Ms(o,"g"),t.grouper=a,t.stripRe=new RegExp(`(?:\\s+|${Ms(a)})`+(r?`|(?:${Ms(r.text)})`:"")+(s?`|(?:${Ms(s.text)})`:""),"g")}decimalPlaces(e){const t=(e=e.replace(this.stripRe,"")).indexOf(this.decimal)+1;return t&&e.length-t}parse(e,t){return"string"==typeof e&&(e=e.replace(this.stripRe,"").replace(this.decimalRe,".").replace("−","-"),e=t?Number(e):parseFloat(e),this.formatter.is.percent&&(e/=100)),e}_decodeStyle(e,t){const n=As(e,t),i=As(e,Object.assign(n.resolvedOptions(),{style:"decimal"})),r=n.format(0),s=i.format(0);return{suffix:r.startsWith(s),text:r.replace(s,"").trim()}}},Object.assign(Fs.prototype,{currency:null,currencyDisplay:"symbol",fraction:null,from:null,integer:null,locale:null,maximumFractionDigits:null,minimumFractionDigits:null,minimumIntegerDigits:null,maximumSignificantDigits:null,minimumSignificantDigits:null,significant:null,style:"decimal",template:null,useGrouping:!0}),Ts.number=(e,t)=>Fs.get(e).format(t),yi.ion({locale:()=>Fs.cache.clear()}),Fs._$name="NumberFormat";class Ps{constructor(e,t){"number"==typeof e||null===e?(this._magnitude=e,this._unit=t):("string"==typeof e&&Object.assign(this,fr.parseDuration(e)),"object"==typeof e&&Object.assign(this,e))}get magnitude(){return this._magnitude}set magnitude(e){this._magnitude="number"==typeof e&&e}get unit(){return this._unit}set unit(e){this._unit=fr.parseTimeUnit(e)}get isValid(){return null!=this._magnitude&&Boolean(fr.normalizeUnit(this._unit))}get milliseconds(){return this.isValid?Math.round(fr.asMilliseconds(this._magnitude,this._unit)):0}isEqual(e){return Boolean(e)&&null!=this._magnitude&&null!=e._magnitude&&this.milliseconds===e.milliseconds}toString(e,t=1){const n=this,i=e?"getShortNameOfUnit":"getLocalizedNameOfUnit",r=e?"":" ";return n.isValid?`${Fs.get("9."+"#".repeat(t)).format(n._magnitude)}${r}${fr[i](n._unit,1!==Math.abs(n._magnitude))}`:""}toJSON(){return this.toString()}valueOf(){return this.milliseconds}add(e){return new Ps({unit:this.unit,magnitude:fr.as(this.unit,this.milliseconds+new Ps({magnitude:e.magnitude,unit:e.unit||this.unit}).milliseconds)})}diff(e){return new Ps({unit:this.unit,magnitude:fr.as(this.unit,this.milliseconds-e.milliseconds)})}}Ps._$name="Duration";const Os=(e,t)=>null==e?void 0:e[t],Ls=/^is(this|next|last)(week|month|year)$/i,$s=["isToday","isTomorrow","isYesterday","isThisWeek","isNextWeek","isLastWeek","isThisMonth","isNextMonth","isLastMonth","isThisYear","isNextYear","isLastYear","isYearToDate"];class _s extends(Pe.mixin(Vr)){static $name="CollectionFilter";static get defaultConfig(){return{value:null,operator:null,filterBy:null,convert:null,caseSensitive:!0,id:null,type:null,internal:null,disabled:!1}}static get configurable(){return{property:null}}construct(e){"function"==typeof e&&(e={filterBy:e}),e.type?"date"!==e.type||null==e.value||Array.isArray(e.value)?"duration"!==e.type||null==e.value||Array.isArray(e.value)||(e.value=new Ps(e.value)):e.value=new Date(e.value):fr.isDate(e.value)||Array.isArray(e.value)&&e.value.every(fr.isDate)?e.type="date":e.value instanceof Ps&&(e.type="duration"),super.construct(e)}get id(){return this._id||(this.internal?this._id=_s.generateId(`b-internal-${this.property}-filter-`):this._id=this.property&&`${this.property}-${this.operator}`||_s.generateId("b-filter-")),this._id}set id(e){this._id=e}onChange(e){var t;const n=this;n.isConfiguring||null===(t=n.owner)||void 0===t||!t.onFilterChanged||n.owner.isConfiguring||n.owner.onFilterChanged(n,e)}get filterBy(){return this._filterBy||this.defaultFilterBy}set filterBy(e){this._filterBy=e}defaultFilterBy(e){const t=this;let n;return n=e.isModel?e.getValue(t.property):t._propertyItems.length>1?t._propertyItems.reduce(Os,e):e[t.property],t[t.operator](t.convert(n))}updateProperty(e){this._propertyItems=e.split("."),this.onChange("property")}set value(e){const t=this;t._value=e,Array.isArray(e)&&({date:1,duration:1}[t.type]||e.length>0&&"string"==typeof e[0])?t._filterValue=e.map((e=>t.convert(e))):!t.caseSensitive&&Array.isArray(e)&&e.length>0&&"string"==typeof e[0]?t._filterValue=e.map((e=>null==e?void 0:e.toLowerCase())):t.caseSensitive||"string"!=typeof e?t._filterValue=t.convert(e):t._filterValue=e.toLowerCase(),t.onChange("value")}get value(){return this._value}get filterValue(){return this._filterValue}set operator(e){this._operator=e,this.onChange("operator")}get operator(){const e=this;return e._operator?e._operator:Array.isArray(e.filterValue)?"isIncludedIn":"string"==typeof e.filterValue?"*":"="}convert(e){var t;"sameTime"===this.operator||"string"==typeof this.filterValue&&e instanceof Date||("sameDay"===this.operator&&(e=fr.clearTime(e)),e=(null===(t=e)||void 0===t?void 0:t.valueOf())??e);return e=this.caseSensitive||"string"!=typeof e?e:e.toLowerCase()}filter(e){return this.filterBy(e)}startsWith(e){return String(e).startsWith(this.filterValue)}endsWith(e){return String(e).endsWith(this.filterValue)}isIncludedIn(e){return 0===this.filterValue.length||this.filterValue.includes(e)}isNotIncludedIn(e){return!this.isIncludedIn(e)}includes(e){return 0===this.filterValue.length||String(e).includes(this.filterValue)}doesNotInclude(e){return!this.includes(e)}sameTime(e){return fr.isSameTime(e,this.filterValue)}sameDay(e){return e===this.filterValue}"="(e){return W.isEqual(e,this.filterValue)}"!="(e){return!W.isEqual(e,this.filterValue)}">"(e){return W.isMoreThan(e,this.filterValue)}">="(e){return W.isMoreThan(e,this.filterValue)||W.isEqual(e,this.filterValue)}"<"(e){return W.isLessThan(e,this.filterValue)}"<="(e){return W.isLessThan(e,this.filterValue)||W.isEqual(e,this.filterValue)}"*"(e){return W.isPartial(e,this.filterValue)}between(e){const[t,n]=this._filterValue;return(W.isMoreThan(e,t)||W.isEqual(e,t))&&(W.isLessThan(e,n)||W.isEqual(e,n))}notBetween(e){return!this.between(e)}empty(e){return null==e||0===String(e).length}notEmpty(e){return!this.empty(e)}isToday(e){return this.between(e)}isTomorrow(e){return this.between(e)}isYesterday(e){return this.between(e)}isThisWeek(e){return this.between(e)}isNextWeek(e){return this.between(e)}isLastWeek(e){return this.between(e)}isThisMonth(e){return this.between(e)}isNextMonth(e){return this.between(e)}isLastMonth(e){return this.between(e)}isThisYear(e){return this.between(e)}isNextYear(e){return this.between(e)}isLastYear(e){return this.between(e)}isYearToDate(e){return this.between(e)}isTrue(e){return!0===e}isFalse(e){return!1===e}setRelativeDateValues(){this._filterValue=_s.getRelativeDateRange(this._operator).map((e=>e.valueOf()))}get isNoOp(){var e;return("includes"===this.operator||"isIncludedIn"===this.operator)&&0===(null===(e=this.filterValue)||void 0===e?void 0:e.length)}static getRelativeDateRange(e,t=new Date){let n,i,r,s,o,a,l;switch(e){case"isYearToDate":return[fr.floor(t,"1 year"),t];case"isToday":return n=fr.floor(t,"1 day"),[n,fr.add(n,1,"day")];case"isYesterday":return n=fr.floor(t,"1 day"),[fr.add(n,-1,"day"),n];case"isTomorrow":return i=fr.getStartOfNextDay(t),[i,fr.add(i,1,"day")];case"isThisWeek":case"isNextWeek":case"isLastWeek":case"isThisMonth":case"isNextMonth":case"isLastMonth":case"isThisYear":case"isNextYear":case"isLastYear":if(r=e.toLowerCase().match(Ls),!r)throw new Error(`Unrecognized relative date expression: ${e}`);return[,a,l]=r,s=`1 ${l}`,o=fr.floor(t,s),"next"===a?o=fr.add(o,1,l):"last"===a&&(o=fr.add(o,-1,l)),[o,fr.add(o,1,l)]}}static generateFiltersFunction(e){if(!e||!e.length&&!e.count)return Ne.returnTrue;for(const t of e)"date"===t.type&&$s.includes(t._operator)&&t.setRelativeDateValues();return function(t){let n=!0;for(const i of e)if(i.disabled||(n=i.filter(t)),!n)break;return n}}}_s._$name="CollectionFilter";const js=W.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null));class Bs{static generateId(e="generatedId"){return e+(js[e]=(js[e]||0)+1)}static reset(e){js[e]=0}}Bs._$name="IdHelper";class Hs extends Pe{static get defaultConfig(){return{property:null,direction:"ASC",sortFn:null,convert:null,id:null,useLocaleSort:null}}construct(e){"function"==typeof e&&(e={sortFn:e}),super.construct(e)}get id(){return this._id||(this._id=this.property||Bs.generateId("b-sorter"))}set id(e){this._id=e}set sortFn(e){this._sortFn=e}get sortFn(){return this._sortFn?this._sortFn:this.defaultSortFn}defaultSortFn(e,t){const{convert:n,property:i,useLocaleSort:r}=this,s="desc"===this.direction.toLowerCase()?-1:1;if(e=e[i],t=t[i],n&&(e=n(e),t=n(t)),r&&null!=e&&null!=t&&"string"==typeof e){if(!0===r)return String(e).localeCompare(t);if("string"==typeof r)return String(e).localeCompare(t,r);if("object"==typeof r)return String(e).localeCompare(t,r.locale,r)}return(e>t?1:e<t?-1:0)*s}static generateSortFunction(e,t){const n=e.isCollection?e.values:e,i=n.length;return(e,r)=>{let s,o;for(o=0;o<i;++o)if(s=n[o].sortFn(e,r),s)return s;return t?t(e,r):0}}}Hs._$name="CollectionSorter";const Vs=()=>0,zs=(e,t)=>t-e,Ns=Symbol("filteredIndicesProperty"),Ws=Object.freeze([]),Us=Object.freeze({action:"sort",added:Ws,removed:Ws,replaced:Ws}),Gs=Object.freeze({action:"filter",added:Ws,removed:Ws,replaced:Ws}),Ys={string:1,number:1};function qs(e,t,n,i){if(!1!==t.unique)t.set(n,e),i&&t.count++;else{let i=t.get(n);i||(i=new Set,t.set(n,i)),i.add(e)}}function Ks(e,t,n,i,r=!1){for(let s=0;s<e.length;s++){const o=e[s];if(o)for(let e=0;e<i;e++){const i=n[e],s=o[i],a=t[i];void 0!==s&&qs(o,a,s,!r&&a.onDuplicate)}}}class Xs extends(Pe.mixin(at)){_sortFunction=null;_addedValues=null;static get configurable(){return{idProperty:"id",extraKeys:null,autoFilter:!0,autoSort:!0,sorters:{$config:["lazy"],value:[]}}}get isCollection(){return!0}construct(e){this.generation=0,this._values=[],super.construct(e)}doDestroy(){var e;super.doDestroy();const t=this;t._values.length=0,t.isFiltered&&(t._filteredValues.length=0,t.filters.destroy()),null===(e=t._sorters)||void 0===e||e.destroy()}clear(){const e=this,t=e._values.slice();e.totalCount&&(e._values.length=0,e._filteredValues&&(e._filteredValues.length=0),e._indicesInvalid=!0,e.generation++,e.trigger("change",{action:"clear",removed:t}))}equals(e,t){if(e.isCollection&&(e=e.values),e.length===this.count){let{values:n}=this;return t&&(e=e.map(t),n=n.map(t)),$e.delta(e,n).inBoth.length===this.count}return!1}replaceValues({values:e,filteredValues:t,silent:n=!1,isNewDataset:i=!1}){const r=this;let s,o;if(r.isFiltered&&!i){Boolean(t)?e&&(s=r._values,r._values=e.slice()):(t=e.slice(),e=null),o=r._filteredValues,r._filteredValues=t.slice()}else s=r._values,r._values=e.slice(),t=null,r.isFiltered&&i&&r.autoFilter?(r._filterFunction=null,r._filteredValues=r._values.filter(r.filterFunction)):r._filteredValues&&(r._filteredValues.length=0);r._indicesInvalid=!0,r._addedValues=void 0,r.generation++,n||r.trigger("change",{action:"replaceValues",replacedValues:s,replacedFilteredValues:o,values:e,filteredValues:t})}set values(e){this.invalidateIndices(),this.splice(0,this._values.length,e)}get values(){return this.isFiltered?this._filteredValues:this._values}get filteredValues(){return this._filteredValues}[Symbol.iterator](){return this.values[Symbol.iterator]()}forEach(e,t=!1){(this.isFiltered&&!t?this._filteredValues:this._values).forEach(e)}map(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).map(e)}reduce(e,t=!1,n=[]){return(this.isFiltered&&!t?this._filteredValues:this._values).reduce(e,n)}find(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).find(e)}get first(){return this.values[0]}get last(){return this.values[this.count-1]}get allValues(){return this._values}get addedValues(){return this._addedValues}match(e,t=!0){const n=this,{_values:i}=n,r=[];return n.forEach((s=>{const o=e.get(s.id,!0);if(o){const e=n.indexOf(s,!0),t=i[e];i[e]=o,n.removeFromIndices(t),n.addToIndices(o)}else t&&r.push(s)})),r.length&&n.remove(r),n.isFiltered&&(n._filteredValues=n._values.filter(n.filterFunction)),r}add(...e){1===e.length?this.splice(this._values.length,null,...e):this.splice(this._values.length,null,e)}remove(...e){1===e.length?this.splice(0,...e):this.splice(0,e)}move(e,t){for(e=$e.asArray(e);e.length&&e[0]===t;)e.shift();if(!e.length)return;const n=this,{_values:i}=n,r=n.indexOf(e[0],!0);if(1===e.length&&i[r+1]===t)return;n.suspendEvents(),n.remove(e),n.resumeEvents();const s=t?n.indexOf(t,!0):i.length;if(-1===s)throw new Error("Collection move beforeItem parameter must be present in Collection");return i.splice(s,0,...e),n._indicesInvalid=1,n.trigger("change",{action:"move",items:e,from:r,to:s}),s}splice(e=0,t,...n){var i;const r=this,s=r.idProperty,o=r._values,a={},l=[],c=[],d=r.totalCount;let u,h;if(1===(null===(i=n)||void 0===i?void 0:i.length)&&Array.isArray(n[0])&&(n=n[0]),!1!==r.trigger("beforeSplice",{index:e,toRemove:t,toAdd:n})){if(n)if(d&&n.length){const e=r.indices[s];u=[];for(let t=0;t<n.length;t++){const i=n[t],r=i[s],l=e.get(r),d=l?o.indexOf(l):-1;a[r]=!0,-1!==d?o[d]!==i&&(c.push([o[d],i]),o[d]=i):u.push(i)}}else u=n;if(t){if("number"==typeof t){t=Math.min(t,o.length-e);for(let n=e;t;--t){a[o[n][s]]?(e++,n++):(l.push(o[n]),o.splice(n,1),h=!0)}}else{let e,n=0===u.length;const i=(t=$e.asArray(t)).reduce(((t,i)=>{const s="number"==typeof i,o=s?i:r.indexOf(i,!0);return n&&(null!=e&&o!==e+1||s)&&(n=!1),o>=0&&o<d&&t.push(o),e=o,t}),[]).sort(zs);if(n)i.length&&(l.push.apply(l,t),o.splice(i[i.length-1],i.length),h=!0);else for(let e=0;e<i.length;e++){const t=i[e];if(-1!==t){a[o[t][s]]||(l.unshift(o[t]),o.splice(t,1),h=!0)}}}l.length&&!r._indicesInvalid&&l.forEach(r.removeFromIndices,r)}if(u.length){o.splice(Math.min(e,o.length),0,...u),h=!0,r._indicesInvalid||u.forEach(r.addToIndices,r),r._addedValues||(r._addedValues=new Set);for(const e of u)r._addedValues.add(e)}if(l.length&&r._addedValues)for(const e of l)r._addedValues.delete(e);c.length&&!r._indicesInvalid&&c.forEach((e=>{r.removeFromIndices(e[0]),r.addToIndices(e[1])})),h||c.length?(r.isSorted?r.onSortersChanged():r.isFiltered&&(r.autoFilter?r.onFiltersChanged({action:"splice",oldCount:1}):r._filteredValues.splice(Math.min(e,r._filteredValues.length),0,...u)),r.generation++,r.trigger("change",{action:"splice",removed:l,added:u,replaced:c,oldCount:d})):r.trigger("noChange",{index:e,toRemove:t,toAdd:n})}}changeId(e,t){const n=this,{idProperty:i}=n,r=Ys[typeof e]?e:e[i],s=n.get(r);if(s){const o=n.get(t);if(o&&s!==o)throw new Error(`Attempt to set item ${r} to already existing member's id ${t}`);n.removeIndexEntry(e,i,r),n.addIndexEntry(e,i,t),s[i]=t}}get(e,t=!1){return this.getBy(this.idProperty,e,t)}getAt(e,t=!1){return this.isFiltered&&!t?this._filteredValues[e]:this._values[e]}getBy(e,t,n=!1){return this.findItem(e,t,this.isFiltered&&n)}get count(){return this.values.length}get totalCount(){return this._values.length}updateIdProperty(e){this.addIndex({property:e,unique:!0})}changeSorters(e){return new Xs({values:$e.asArray(e),internalListeners:{change:"onSortersChanged",thisObj:this}})}addSorter(e){const t=e instanceof Hs?e:new Hs(e);return this.sorters.add(t),t}get isSorted(){var e;return Boolean(null===(e=this._sorters)||void 0===e?void 0:e.count)}onSortersChanged(){const e=this;e._sortFunction=null,e._addedValues=null,e._values.sort(e.sortFunction),e.trigger("change",Us)}get sortFunction(){return this._sortFunction||(this.isSorted?this._sortFunction=Hs.generateSortFunction(this.sorters.values):this._sortFunction=Vs),this._sortFunction}get filters(){return this._filters||(this._filters=new Xs({internalListeners:{change:"onFiltersChanged",thisObj:this}})),this._filters}addFilter(e){const t=e instanceof _s?e:new _s(e);return this.filters.add(t),t}removeFilter(e){const{filters:t}=this;e.isCollectionFilter||(e=t.get(e)),t.remove(e)}clearFilters(){this.filters.clear()}get isFiltered(){return Boolean(this._filters&&this._filters.count)}onFiltersChanged({action:e,removed:t,oldCount:n}){const i=this,r=n||"clear"===e&&t.length?i._filteredValues:i._values;i._filterFunction=null,i._filteredValues=i._values.filter(i.filterFunction),i._indicesInvalid=!0;const{toAdd:s,toRemove:o}=$e.delta(i._filteredValues,r,!0);i.trigger("change",{...Gs,added:s,removed:o})}get filterFunction(){return this._filterFunction||(this.isFiltered?this._filterFunction=_s.generateFiltersFunction(this.filters.values):this._filterFunction=Ne.returnTrue),this._filterFunction}changeExtraKeys(e){return $e.asArray(e).map((e=>"string"==typeof e?{property:e,unique:!0}:e))}updateExtraKeys(e){for(let t=0;t<e.length;t++)this.addIndex(e[t])}addIndex(e){const t=this;e&&((t._indices||(t._indices={}))[e.property]=new Map,Object.assign(t._indices[e.property],e),t.invalidateIndices(),e.dependentOn&&(t.hasCompositeIndex=!0))}findIndex(e,t,n=!1){const i=this.findItem(e,t,n);if(!i)return-1;return(this.isFiltered&&!n?this._filteredValues:this._values).indexOf(i)}findItem(e,t,n=!1){const i=this,{isFiltered:r}=i,s=r&&!n?i.indices[Ns][e]:i.indices[e];if(s){const e=s.get(t)??("string"==typeof t&&t.length&&!isNaN(t)&&s.get(Number(t))||null);if(null!=e)return e}else{const s=r&&!n?i._filteredValues:i._values,o=s.length;for(let n=0;n<o;n++){const i=s[n];if(i[e]==t)return i}}return null}removeIndex(e){delete this._indices[e],this.hasCompositeIndex=Object.values(this.indices).some((e=>e.dependentOn))}indexOf(e,t=!1){return this.findIndex(this.idProperty,Ys[typeof e]?e:e[this.idProperty],t)}includes(e,t=!1){return Array.isArray(e)?e.some((e=>this.includes(e))):Boolean(this.findItem(this.idProperty,Ys[typeof e]?e:e[this.idProperty],t))}get indices(){return this._indicesInvalid&&this.rebuildIndices(),this._indices}invalidateIndices(){this._indicesInvalid=!0}rebuildIndices(){const e=this,t=e.isFiltered,n=e._indices||(e._indices={}),i=Object.keys(n),r=i.length,s=e._values;let o,a=!1;t&&(o=n[Ns]={});for(let e=0;e<r;e++){const r=n[i[e]];if(r.clear(),r.onDuplicate&&(r.count=0,a=!0),t){let t=o[i[e]];t?t.clear():(t=o[i[e]]=new Map,t.unique=r.unique)}}if(Ks(s,n,i,r),a)for(let e=0;e<r;e++){const t=n[i[e]];if(t.onDuplicate&&t.count>t.size){const n=new Set;for(let r=0;r<s.length;r++){const o=s[r],a=o[i[e]];n.has(a)&&t.onDuplicate(o,a,t),n.add(a)}}}t&&Ks(e._filteredValues,o,i,r,!0),e._indicesInvalid=!1}getIndices(e){const t=[this.indices[e]];return this.isFiltered&&t.push(this.indices[Ns][e]),t}addToIndices(e){Object.keys(this.indices).forEach((t=>{this.addIndexEntry(e,t,e[t])}))}removeFromIndices(e){Object.keys(this.indices).forEach((t=>{this.removeIndexEntry(e,t,e[t])}))}removeIndexEntry(e,t,n){this.getIndices(t).forEach((t=>function(e,t,n){!1!==t.unique?t.delete(n):t.has(n)&&(t.get(n).delete(e),t.get(n).size||t.delete(n))}(e,t,n)))}addIndexEntry(e,t,n){this.getIndices(t).forEach((t=>qs(e,t,n)))}onItemMutation(e,t){const n=this;!n._indicesInvalid&&Object.keys(n.indices).length>1&&Object.keys(t).forEach((i=>{if(n.indices[i]){const{value:r,oldValue:s}=t[i];n.removeIndexEntry(e,i,s),n.addIndexEntry(e,i,r)}if(n.hasCompositeIndex){const s=Object.values(n.indices).find((e=>{var t;return null===(t=e.dependentOn)||void 0===t?void 0:t[i]}));if(s){const i={};for(const n in s.dependentOn){var r;i[n]=(null===(r=t[n])||void 0===r?void 0:r.oldValue)||e[n]}const o=e.buildIndexKey(i);n.removeIndexEntry(e,s.property,o),n.addIndexEntry(e,s.property,e[s.property])}}}))}}Xs._$name="Collection";const Zs=new WeakMap,Js=e=>{if(e&&"object"==typeof e){let t=Zs.get(e);void 0===t&&(t=Symbol("bscik"),Zs.set(e,t)),e=t}return e};class Qs{constructor(e){const t=this;t.generation=0,t.items=new Set,t.idMap={},t.idProperty="id",e&&(e.idProperty&&(t.idProperty=e.idProperty),e.values&&(t.values=e.values))}get(e){return this.idMap[Js(e)]}get count(){return this.items.size}add(...e){1===e.length&&Array.isArray(e[0])&&(e=e[0]);const t=this,{items:n,idMap:i,idProperty:r}=t,s=e.length;for(let o=0;o<s;o++){const s=e[o],a=Ys[typeof s]?s:Js(s[r]),l=i[a];null==l?(i[a]=s,n.add(s),t.generation++):l!==s&&(i[a]=s,n.delete(l),n.add(s))}}at(e){let t,n;for(t of(e<0&&(e+=this.count),this.items))if(!e--){n=t;break}return n}remove(e){e=$e.asArray(e);const{items:t,idMap:n,idProperty:i}=this,r=e.length;for(let s=0;s<r;s++){const r=e[s],o=Ys[typeof r]?r:Js(r[i]),a=n[o];null!=a&&(t.delete(a),delete n[o],this.generation++)}}clear(){this.items.clear(),this.idMap={},this.generation++}countOf(e){let t,n=0;for(t of this.items)e(t)&&++n;return n}changeId(e,t){const n=this,{idMap:i,idProperty:r}=n,s=Ys[typeof e]?e:Js(e[r]),o=n.get(s);if(o){const e=n.get(t);if(e&&o!==e)throw new Error(`Attempt to set item ${s} to already existing member's id ${t}`);o[r]=t,delete i[s],i[t]=o}}filter(e,t){const{items:n}=this,i=[];let r=0;return n.forEach((s=>{e.call(t,s,r++,n)&&i.push(s)})),i}includes(e){const t=Ys[typeof e]?e:Js(e[this.idProperty]);return Boolean(this.idMap[t])}map(e,t){const{items:n}=this,i=new Array(n.size);let r=0;return n.forEach((s=>{i[r]=e.call(t,s,r++,n)})),i}forEach(e,t){return this.items.forEach(e,t)}find(e,t=0){let n,i;for(n of(t<0&&(t+=this.countOf(e)),this.items))if(e(n)&&!t--){i=n;break}return i}[Symbol.iterator](){return this.items[Symbol.iterator]()}indexOf(e,t){let n,i=-1;for(n of this.items)if((!t||t(n))&&(++i,n===e))return i;return-1}get values(){return[...this.items]}set values(e){e=$e.asArray(e),this.clear(),this.add.apply(this,e),this.generation++}get first(){for(const e of this.items)return e;return null}get last(){let e=null;for(const t of this.items)e=t;return e}sort(e){this.values=this.values.sort(e)}some(e,t){return this.values.some(e,t)}}Qs._$name="Bag";class eo extends Qs{add(...e){return 1===e.length&&Array.isArray(e[0])&&(e=e[0]),super.add(...e.filter((e=>e.isPersistable)))}}eo._$name="StoreBag";var to=e=>class extends(e||Pe){static $name="StoreCRUD";static get defaultConfig(){return{autoCommit:!1}}static get properties(){return{isRemoving:!1,suspendCount:0}}remove(e,t=!1){const n=this,{storage:i}=n;if(0===(e=$e.asArray(e).reduce(((e,t)=>((t=n.getById(t))&&e.push(t),e)),[])).length)return e;if(!n.tree&&!t&&!1===n.trigger("beforeRemove",{records:e}))return[];if(n.isRemoving=!0,n.isGrouped){const t=i.count,r=[],s=new Set;for(const t of e){const{groupParent:e}=t.instanceMeta(n);e.meta.collapsed&&r.push(t),$e.remove(e.groupChildren,t),$e.remove(e.unfilteredGroupChildren,t),e.meta.childCount--,s.add(e)}for(const e of s)e.groupChildren.length>0&&n.onModelChange(e,{},{});r.length&&i.trigger("change",{action:"splice",removed:r,added:[],replaced:[],oldCount:t})}else if(n.tree){const r=[],s=e.length>1,o=e[0],a=s?void 0:i.indexOf(o),l=e.reduce(((e,t)=>{const{parent:n}=t;return n&&(e[n.id]||(e[n.id]=[n,[]]),e[n.id][1].push(t)),e}),{}),c=Array.from(Object.values(l));if(!t&&!1===n.trigger("beforeRemove",{records:e,isMove:!1,parent:s?void 0:o.parent}))return n.isRemoving=!1,[];n.suspendAutoCommit(),c.sort(((e,t)=>t[0].childLevel-e[0].childLevel));for(const[e,t]of c)r.push(...e.removeChild(t,!1,!0));return t||(n.trigger("remove",{parent:s?void 0:o.parent,index:a,isChild:!0,allRecords:r,isMove:!1,records:e}),n.trigger("change",{action:"remove",records:e})),n.resumeAutoCommit(),n.isRemoving=!1,e}if(0===e.length)return n.isRemoving=!1,e;for(const t of e)t.beforeRemove(e);return t&&n.suspendEvents(),i.remove(e),t&&n.resumeEvents(),n.autoCommit&&n.doAutoCommit(),n.isRemoving=!1,e}clear(e=!1){var t;const n=this,{storage:i}=n;if(n.storage.totalCount||null!==(t=n.rootNode)&&void 0!==t&&null!==(t=t.unfilteredChildren)&&void 0!==t&&t.length){if(!e&&!1===n.trigger("beforeRemove",{records:i.allValues,removingAll:!0}))return null;if(n.rootNode)if(n.isChained){const e=n.getAllDataRecords();for(let t,i=e.length-1;i>=0;i--)t=e[i],t&&!t.isDestroyed&&t.unjoinStore(n)}else n.rootNode.clearChildren(e);else if(e){const e=n.registeredRecords;for(let t,i=e.length-1;i>=0;i--)t=e[i],t&&!t.isDestroyed&&t.unjoinStore(n)}e&&(n.removed.clear(),i.suspendEvents()),i.clear(),e&&i.resumeEvents(),n.added.clear(),n.modified.clear()}}removeAll(e=!1){const t=this,n=t.storage;let i;if(t.isRemoving=!0,e){n.suspendEvents();const e=t.registeredRecords;for(let n,i=e.length-1;i>=0;i--)n=e[i],!n||n.isDestroyed||n.isRoot||n.unjoinStore(t)}return i=t.tree?!1!==t.rootNode.clear():null!==t.clear(),e&&n.resumeEvents(),t.isRemoving=!1,i}add(e,t=!1,n={}){var i;const r=this,{storage:s}=r;if(null===(i=e=$e.asArray(e))||void 0===i||!i.length)return;if(r.tree=r.tree||Boolean(r.autoTree&&e[0].children),r.tree){const i=new Map,s=r.modelClass.getFieldDataSource("parentIndex"),{parentIdField:o}=r.modelClass,a=[];return e.forEach((e=>{const t=e[o];i.has(t)||i.set(t,{append:[],insert:[]});const n=i.get(t);!e.isModel&&s in e?n.insert.push(e):n.append.push(e)})),i.forEach((({append:e,insert:i},o)=>{const l=null==o?r.rootNode:r.getById(o);if(!l)throw new Error(`Parent node with id ${o} not found, cannot add children.`);if(e.length&&a.push(...l.appendChild(e,t,n)),i.length)for(const e of i)"orderedParentIndex"in e&&("orderedParentIndex"in n&&W.isObject(n.orderedParentIndex)?n.orderedParentIndex.index=e.orderedParentIndex:n.orderedParentIndex=e.orderedParentIndex),a.push(l.insertChild(e,e[s],t,n))})),r.isFiltered&&r.reapplyFilterOnAdd&&r.filter({silent:!0}),r.reapplySortersOnAdd&&!r.isSyncingDataOnLoad&&r.sort(),a}if(!t&&!1===r.trigger("beforeAdd",{records:e}))return null;if(r.tree=r.tree||Boolean(r.autoTree&&e[0].children),r.tree)return r.rootNode.appendChild(e);const o=r.processRecords(e);return t&&r.suspendEvents(),r.addingClean=n.clean,s.add(o),r.addingClean=!1,t&&r.resumeEvents(),r.autoCommit&&r.doAutoCommit(),o}cloneImmutable(e){return!this.useRawData.enabled||e[0].isModel||Object.isExtensible(e[0])||(e=W.clone(e)),e}processRecords(e,t){return this.cloneImmutable(e).map((e=>{const n=this.processRecord(e.isModel?e:this.createRecord(e));return null==t||t.call(this,n),n}))}insert(e,t,n=!1){const i=this,r=i.storage,s=r.getAt(e),o=r.values,a=[];if(t=$e.asArray(t),i.tree){var l;const r=i.rootNode;return r.insertChild(t,null===(l=r.children)||void 0===l?void 0:l[e],n)}if(!n&&!1===i.trigger("beforeAdd",{records:t}))return null;let c,d,u;if(o[d=e]===t[0]||o[d=e-1]===t[0])for(c=!0,u=0;c&&u<t.length;u++)t[u]!==o[d+u]&&(c=!1);if(c)return null;const h=i.processRecords(t,(t=>{const n=r.indexOf(t);t.children&&t.children.length&&i.autoTree&&(i.tree=!0),n>-1&&(n<e&&s&&e--,a.push(n)),t.meta.previousIndex=n}));return i.suspendEvents(),i.storage.remove(a),i.resumeEvents(),n&&i.suspendEvents(),r.splice(e,0,...h),n&&i.resumeEvents(),i.autoCommit&&i.doAutoCommit(),h}move(e,t){this.isTree?t.parent.insertChild(e,t):this.storage.move(e,t)}acceptChanges(){const e=this;e.added.forEach((e=>e.internalClearChanges(!0,!1))),e.modified.forEach((e=>e.internalClearChanges(!0,!1))),e.added.clear(),e.modified.clear(),e.removed.clear()}commit(e=!1){const{changes:t}=this;return!(!e&&!1===this.trigger("beforeCommit",{changes:t}))&&(this.acceptChanges(),e||this.trigger("commit",{changes:t}),t)}revertChanges(){const e=this,{changes:t}=e;if(t){const n={action:"clearchanges",changes:t};e.add(e.removed.values,!0),e.remove(e.added.values,!0),e.modified.forEach((e=>e.revertChanges(!0))),e.added.clear(),e.modified.clear(),e.removed.clear(),e.trigger("change",n),e.trigger("refresh",n)}}get changes(){const e=this,t=e.modified.values.filter((e=>e.rawModifications));return e.added.count||t.length||e.removed.count?{added:e.added.values.slice(),modified:t,removed:e.removed.values.slice()}:null}get hasChanges(){return Boolean(this.added.count||this.removed.count||this.modified.values.some((e=>e.rawModifications)))}get autoCommit(){return this._autoCommit}set autoCommit(e){this._autoCommit=e,e&&this.hasChanges&&this.commit()}suspendAutoCommit(){this.suspendCount++}resumeAutoCommit(e=!0){this.suspendCount--,this.autoCommit&&e&&this.doAutoCommit()}doAutoCommit(){this.suspendCount<=0&&this.commit()}},no=e=>class extends(e||Pe){static $name="StoreChanges";static get configurable(){return{applyChangesetFilterSortTarget:"changes"}}applyChangesFromStore(e){const t=this,{changes:n}=e;n&&(n.added&&t.add(n.added),n.removed&&t.remove(n.removed.map((e=>e.id))),n.modified&&n.modified.forEach((e=>{const n=t.getById(e.id);null==n||n.set(e.modifications)})))}applyChangeset(e,t=null,n="$PhantomId",i=!0,r=!1){const s=this,o=(null==t?void 0:t(e,s))??e,a=o.$input||o,{added:l,updated:c,modified:d,removed:u}=a,h=c??d??[],g=s.modelClass.getFieldDataSource("id"),m=s.modelClass.getFieldDataSource("parentId"),p=r?new Map:null,f=s.tree,v=[],y=[],b=new Set;let C=!1,S=[];if(s.trigger("startApplyChangeset"),s._groupVisibleRecordIds=[],s.isGrouped&&s.forEach((e=>{s._groupVisibleRecordIds.push(e.id)})),(null==l?void 0:l.length)>0){const e=[],t=[];for(const i of l){const r=s.getById(i[n])||s.getById(W.getPath(i,g));if(r)e.push(i),f&&b.add(r.parent);else{s.removed.get(i[n])||s.removed.get(W.getPath(i,g))||t.push(i)}}h.unshift.apply(h,e);const r=s.reapplySortersOnAdd;s.reapplySortersOnAdd=!1;const o=s.add(t,!1,{orderedParentIndex:{skip:!0},clean:i})??[];if(v.push(...o),s.reapplySortersOnAdd=r,f)for(const e of o){const{parent:t}=e;if(t.isRoot){C=!0,S=[t];break}!t.isRoot&&S.every((e=>!e.contains(t)))&&S.push(t),"orderedParentIndex"in e.originalData&&b.add(t)}for(const e of o)null==p||p.set(e.id,e.data),e.internalClearChanges();f&&b.forEach((e=>{e.updateChildrenIndices(e.orderedChildren,"orderedParentIndex",!0)}))}if((null==h?void 0:h.length)>0)for(const e of h){const t=e[n],r=W.getPath(e,g),o=W.getPath(e,m),a=s.getById(t)??s.getById(r);if(a){var D;const t=null!=o&&(null===(D=s.getById(o))||void 0===D?void 0:D.isLeaf);this.filterTreeHierarchyChanges(b,a,e);const l=a.applyChangeset(e,n,i);t&&s.toggleCollapse(a.parent,!1),f&&!C&&S.every((e=>!e.contains(a)))&&(a.parent.isRoot?(C=!0,S=[a.parent]):S.push(a.parent)),null==p||p.set(r,l),y.push(a)}}if((null==u?void 0:u.length)>0&&s.applyRemovals(u),"changes"===s.applyChangesetFilterSortTarget){const e=s.filterChangeset(v,y);S.push(...e)}if(s.afterChangesetApplied(S),f&&s.isSorted&&s.reapplySortersOnAdd&&(null!=l&&l.length||null!=h&&h.length)){const e=new Set;S.forEach((t=>{e.has(t)||(e.add(t),t.sortVisibleChildren(!1,s.sorterFn),t.sortUnfilteredChildren(!1,s.sorterFn))})),s.storage.replaceValues({values:s.collectDescendants(s.rootNode).visible,silent:!0}),s.afterPerformSort(!1)}return s._groupVisibleRecordIds=null,s.trigger("endApplyChangeset"),p}afterChangesetApplied(e){const t=new Set;e.forEach((e=>{t.has(e)||e.traverse((e=>{t.has(e)||(t.add(e),e.sortOrderedChildren(!1,!1),e.children&&e.updateChildrenIndices(e.children,"parentIndex",!0),e.unfilteredChildren&&e.updateChildrenIndices(e.unfilteredChildren,"unfilteredIndex",!0))}))}))}applyRemovals(e){const t=this,{removed:n}=t,i=t.modelClass.idField,r=[];for(const t of e){const e=W.getPath(t,i);if(n.includes(e)){const t=n.get(e);t.internalClearChanges(!1,!0,null),t.$isPhantom=!0,n.remove(e)}else r.push(e)}if(t.tree){const e=r.reduce(((e,n)=>(t.getById(n)&&e.add(t.getById(n).parentNode??t.rootNode),e)),new Set);e.forEach((e=>e.sortOrderedChildren(!1,!1)))}t.remove(r);for(const e of r)n.remove(e)}filterChangeset(e,t){const n=this,{isFiltered:i,tree:r,isGrouped:s,filtersFunction:o}=n,a=n.isSorted?n.createSorterFn(n.sorters):void 0,{allValues:l,addedValues:c,isSorted:d}=n.storage,u=null!=a||d?a??n.storage.sortFunction:null,h=new Set;if(!i)return[];let g,m=!1;if(s&&(g=n.groupers,n.clearGroupers(!0)),r){const i=new Set(t.filter(o));for(const t of e.filter(o))i.add(t);i.forEach((e=>e.bubble((e=>i.add(e))))),i.delete(n.rootNode);const r=$e.groupByIndexed(Array.from(i).filter((e=>{var t;return!(null!==(t=e.parent)&&void 0!==t&&null!==(t=t.children)&&void 0!==t&&t.includes(e))})),(e=>e.parent));for(const[e,t]of r)e.unfilteredChildren&&(e.children.push(...t),h.add(e),n.traverseFilter(e,!1,t))}else if(u&&!s){const{filteredValues:e}=n.storage,i=c?e.findLastIndex((e=>!c.has(e)))+1:e.length,r=e.slice(0,i),s=new Set(t.filter(o));for(const t of e)s.has(t)&&s.delete(t);for(const e of s)r.push(e);r.sort(u),e.splice(0,i,...r),m=!0}else{const e=t.filter((e=>o(e)&&!n.storage.includes(e)));e.length>0&&(n.includeInSubset(l,n.storage.filteredValues,e),m=!0)}const p=new Set(e.filter((e=>!o(e))));if(p.size>0){if(r)for(const e of p)$e.remove(e.parent.children,e),h.add(e.parent);else $e.remove(n.storage.filteredValues,p);m=!0}return g&&(n.group(g[0],null,!1,!0,!0),m=!0),r&&h.size>0?n.storage.replaceValues({values:n.collectDescendants(n.rootNode).visible,silent:!0}):m&&(n._idMap=null,n.trigger("refresh")),[...h]}filterTreeHierarchyChanges(e,t,n){this.tree&&e.has(t.parent)&&(delete n.orderedParentIndex,delete n.parentIndex)}includeInSubset(e,t,n){const i=new Set(n);let r=0,s=0,o=0===i.size;for(;s<e.length&&!o;){const n=t[r];let a=e[s];for(;n!==a;)i.has(a)&&(t.splice(r,0,a),r++,i.delete(a),o=0===i.size),a=e[++s];i.has(n)&&i.delete(n),r<t.length&&r++}return t}},io=e=>class extends(e||Pe){static $name="StoreFilter";static get defaultConfig(){return{filters:null,reapplyFilterOnAdd:!1,reapplyFilterOnUpdate:!1}}static properties={filterBatching:0,needsFiltering:!1};set reapplyFilterOnAdd(e){this.storage.autoFilter=e}get reapplyFilterOnAdd(){return this.storage.autoFilter}set filters(e){const t=this,n=t.filters;if(n.clear(),t._filtersFunction=null,e){if("Object"===e.constructor.name)for(const t of Object.entries(e))"filterBy"===t[0]&&"function"==typeof t[1]?n.add(new _s({filterBy:t[1]})):n.add(new _s("Object"===t[1].constructor.name?Object.assign({property:t[0]},t[1]):{property:t[0],value:t[1]}));else Array.isArray(e)?n.add(...e.map((e=>e instanceof _s?e:new _s(e)))):e.isCollection?n.add(...e.values):n.add(new _s({filterBy:e}));n.forEach((e=>e.owner=t))}}get filters(){return this._filters||(this._filters=new Xs({extraKeys:["property"]}))}set filtersFunction(e){this._filtersFunction=e}get filtersFunction(){const e=this,{filters:t,isGrouped:n}=e;if(!e._filtersFunction)if(t.count){const i=_s.generateFiltersFunction(t);e._filtersFunction=e=>n&&e.isSpecialRow?e.groupChildren.some(i):i(e)}else e._filtersFunction=Ne.returnTrue;return e._filtersFunction}get isFiltered(){return this.filters.values.some((e=>!e.disabled))}isFilteredOut(e){return this.isFiltered&&!this.filtersFunction(e)}traverseFilter(e,t=!0,n=void 0){const i=this,{filtersFunction:r}=i,s=!e.isRoot&&r(e),o=e.unfilteredChildren||e.children;return o&&o.length?(e.unfilteredChildren||(e.unfilteredChildren=e.children.slice()),e.children=e.unfilteredChildren.filter((e=>t?i.traverseFilter(e,t):r(e)||(null==n?void 0:n.has(e)))),i.isSorted&&e.children.sort(i.sorterFn),e.updateChildrenIndices(e.unfilteredChildren,"unfilteredIndex",!0),e.updateChildrenIndices(e.children,"parentIndex",!0),s||Boolean(e.children.length)):s}traverseClearFilter(e){const t=this;e.unfilteredChildren&&(e.children=e.orderedChildren.slice(),e.unfilteredChildren=null),e.children&&(t.isSorted&&e.children.sort(t.sorterFn),e.children.forEach((e=>t.traverseClearFilter(e))),e.updateChildrenIndices(e.children,"parentIndex",!0))}get latestFilterField(){return this.filters.last?this.filters.last.property:null}addFilter(e,t=!1){const n=this;if((e=e instanceof _s?e:new _s(e)).owner=n,n.filters.add(e),!t){if(n.remoteFilter)return n.filter().then((()=>e));n.filter()}return e}filter(e){const t=this;let n,i=!1;if(e){let r=typeof e;if("object"===r&&("silent"in e||"replace"in e||e.filters)&&(i=e.silent,e.replace&&t.clearFilters(e.silent||0!==e.filters.length),n=e.internal,r=typeof(e=e.filters)),e){const i=t.isFiltered;if(t.isConfiguring=!0,Array.isArray(e))e.forEach((e=>t.addFilter(e,!0)),t);else if("function"===r){const i=new _s(e);i.internal=n,t.addFilter(i,!0)}else"string"===r?t.addFilter({property:e,value:arguments[1]},!0):t.addFilter(e,!0);if(t.isConfiguring=!1,!t.isFiltered&&!i)return null}}t.filtersFunction=null;const r=t.performFilter(i);return t._idMap=null,r}suspendFilterOnUpdate(){this.filterBatching++}resumeFilterOnUpdate(e){if(this.filterBatching--,this.filterBatching<0)throw new Error("No matching `startFilterBatching` call");0===this.filterBatching&&this.needsFiltering&&(this.needsFiltering=!1,this.performFilter(e))}performFilter(e){const t=this;if(t.filterBatching>0)return void(t.needsFiltering=!0);const{storage:n,filters:i,rootNode:r}=t,s=t.count;let o,a;if(e||t.trigger("beforeFilter",{filters:i}),t.tree){const e=n.values;t.isFiltered?t.traverseFilter(r):t.traverseClearFilter(r);const i=t.collectDescendants(r).visible;n.replaceValues({values:i,silent:!0});const s=$e.delta(i,e,!0);o=s.toAdd,a=s.toRemove}else n.ion({change({removed:e,added:t}){a=e,o=t},once:!0}),t.isFiltered?(t.isGrouped&&t.includeCollapsed(),n.addFilter({id:"primary-filter",filterBy:t.filtersFunction}),t.isGrouped&&t.excludeCollapsed()):n.filters.clear();t.afterPerformFilter(e||t.isRemoteDataLoading?null:{action:"filter",filters:i,oldCount:s,added:o,removed:a,records:t.storage.values})}afterPerformFilter(e){this.resetRelationCache(),e&&this.triggerFilterEvent(e)}triggerFilterEvent(e){this.trigger("filter",e),this.remoteFilter||(this.trigger("refresh",e),this.trigger("change",e))}filterBy(e){return this.filter(e)}removeFilter(e,t=!1){const n=this,i=e instanceof _s?e:n.filters.get(e)??n.filters.getBy("property",e);if(i){var r;if(null===(r=n._filters)||void 0===r||r.remove(i),n._filtersFunction=null,!t){if(n.remoteFilter)return n.filter().then((()=>i));n.filter()}return i}}clearFilters(e=!1){if(this.filters.remove(this.filters.values.filter((e=>!e.internal))),!e)return this.filter()}convertFilterToString(e){const t=this.filters.getBy("property",e);return t&&!t.filterBy?String(t):""}doDestroy(){var e;null===(e=this._filters)||void 0===e||e.destroy(),super.doDestroy()}};const ro={add:1,replace:1},so=({_groupValue:e},{_groupValue:t})=>e<t?-1:e>t?1:0;var oo=e=>class extends(e||Pe){static $name="StoreGroup";static configurable={groupers:null,useGroupFooters:!1,startGroupsCollapsed:null};static get properties(){return{collapsedGroups:new Set}}construct(e){super.construct(e),this.ion({change:"onDataChanged",thisObj:this})}get GroupRow(){return this._GroupRowClass||(this._GroupRowClass=class extends this.modelClass{static isSpecialRow=!0;static fields=[{name:"_groupValue"}];get isCollapsed(){return this.meta.collapsed}})}updateGroupers(e){this.setGroupers(e)}setGroupers(e,t=null){const n=this,{storage:i}=n;let r;return n._idMap=null,null!=e&&e.length?n._groupers=e.map((e=>n.createGrouper(e))):n.groupers&&(delete n._groupers,n.includeCollapsed(),i.replaceValues({values:n.removeHeadersAndFooters(i._values),filteredValues:i.isFiltered?n.removeHeadersAndFooters(i._filteredValues):null,silent:!0}),r=n.group(null,null,null,!1,null==t?void 0:t.silent)),r}createGrouper(e){if(!e||e.isGrouper)return e;"string"==typeof e&&(e={field:e});const{field:t}=e,n=null==t?void 0:t.indexOf("."),i=n>0,r=null==t?void 0:t.split("."),s=i?r[0]:t,o=i?(l=r)[(c=-1)<0?l.length+c:c]:t,a=i?t.slice(n+1):t;var l,c;return{isGrouper:!0,...e,complexMapping:i,rootFieldName:s,leafFieldName:o,fieldPath:a}}get unfilteredGroupRecords(){const e=this;if(e.isGrouped){var t;const{generation:n}=e.storage;(null===(t=e._unfilteredGroupRecords)||void 0===t?void 0:t.generation)!==n&&(e._unfilteredGroupRecords=e.storage.allValues.filter((e=>e.isSpecialRow)),e._unfilteredGroupRecords.generation=n)}return e._unfilteredGroupRecords||[]}getGroupHeaderForRecord(e,t=!1){if(this.isGrouped)return e?e.meta.groupRowFor?e:e.instanceMeta(this).groupParent:this.groupRecords.last}includeCollapsed(){for(const e of this.collapsedGroups)this.expand(this.getById(e),!1)}excludeCollapsed(){for(const e of this.collapsedGroups)this.collapse(this.getById(e))}onDataChange({source:e,action:t,removed:n}){var i;const r=this,{groupers:s}=r;s&&(s.length?("splice"===t&&null!=n&&n.length||"move"===t)&&e.replaceValues({...r.prepareGroupRecords(),silent:!0}):e.replaceValues({values:r.removeHeadersAndFooters(e._values),filteredValues:e.isFiltered?r.removeHeadersAndFooters(e._filteredValues):null,silent:!0})),null===(i=super.onDataChange)||void 0===i||i.call(this,...arguments)}move(e,t){const n=this;let i;if(n.isGrouped&&!n.tree){var r,s;let o=t;if(null!==(r=t)&&void 0!==r&&r.isSpecialRow&&(o=n.getPrev(t,!1,!1),!o))return;const a=n.getGroupHeaderForRecord(o),l=n.groupers[0].field,{reapplyFilterOnUpdate:c}=n,d="array"===n.modelClass.getFieldDefinition(l).type;let u=a.meta.groupRowFor;if(n.reapplyFilterOnUpdate=!1,n.beginBatch(),e.forEach((e=>{if(d){const n=e.get(l);if(n.includes(u))return;{const r=e.instanceMeta(this).groupParent,s=t.isGroupHeader?t:t.instanceMeta(this).groupParent;$e.remove(n,r),u=n.slice(),u.push(s._groupValue),i=!0}}e.setValue(l,u)})),n.endBatch(),d&&!i)return;if(n.reapplyFilterOnUpdate=c,n.isFiltered&&null!==(s=t)&&void 0!==s&&s.isSpecialRow){const{unfilteredGroupRecords:e}=n,i=e.indexOf(a);t=e[i+1]}}super.move(e,t),i&&n.group(n.groupers[0])}collapse(e){return!(!e||e.meta.collapsed)&&(this.excludeGroupRecords(e),e.meta.collapsed=!0,this.collapsedGroups.add(e.id),this.trigger("toggleGroup",{groupRecord:e,collapse:!0}),!0)}expand(e,t=!0){return!(null==e||!e.meta.collapsed)&&(this.includeGroupRecords(e),e.meta.collapsed=!1,t&&this.collapsedGroups.delete(e.id),t&&this.trigger("toggleGroup",{groupRecord:e,collapse:!1}),!0)}removeHeadersAndFooters(e){return e.filter((e=>(null!=e&&e.unfilteredGroupChildren&&(e.groupChildren.length=e.unfilteredGroupChildren.length=e.meta.childCount=0),!(null!=e&&e.isSpecialRow||null!=e&&e.isLinked&&e.instanceMeta(this).groupParent)||(this.unregister(e),!1))))}prepareGroupRecords(){var e;const t=this,{GroupRow:n,isFiltered:i,reapplyFilterOnUpdate:r,groupRecords:s}=t,o=t.groupers[0],a=!1!==o.ascending?1:-1,{field:l,fn:c=so,leafFieldName:d}=o,u="function"==typeof l,h=l===t.modelClass.idField,g=new Xs,m=t._groupVisibleRecordIds||[],p=e=>{const n=!i||t.filtersFunction(e);return r?n:n||m.includes(e.id)},f=Boolean(t.startGroupsCollapsed&&!(null!=s&&s.count));null==s||s.forEach((e=>{e.isCollapsed&&t.includeGroupRecords(e)}));const v=t.removeHeadersAndFooters(t.storage._values);if(t.sorters.length&&v.sort(t.sorterFn),i&&(t.filtersFunction=null),v.forEach((e=>{const i=e,r=u?l(e):e.getValue(l),o=$e.asArray(null==r?"!!novalue!!":r),a=Array.isArray(o)&&!o.length,c=a?1:o.length;for(let r=0;r<c;r++){const l=a?[]:o[r],c=`group-header-${"number"==typeof l?l:H.createId(l)}`;let u=g.get(c);if(u||(u=(null==s?void 0:s.get(c))||new n({[t.modelClass.idField]:c,[h?"":d]:l,_groupValue:l},t,{collapsed:f,specialRow:!0,groupRowFor:l,groupField:d,emptyArray:a}),g.add(u),u.meta.childCount=0,u.groupChildren=[],u.unfilteredGroupChildren=[],u.stores=[t]),t.register(u),r>0){const n=i.groupLinks||(i.groupLinks={});(e=n[l]||(n[l]=i.link())).stores=[t],t.register(e)}e.instanceMeta(t).groupParent=u,p(e)&&(u.groupChildren.push(e),u.meta.childCount++),u.unfilteredGroupChildren.push(e)}})),g._values.sort(((e,t)=>c(e,t)*a)),t.useGroupFooters)for(let e=0,i=g.count;e<i;e++){const r=g.values[e],s=r.meta.groupRowFor,o=`group-footer-${"number"==typeof s?s:H.createId(s)}`,a=t.getById(o)||new n({[t.modelClass.idField]:o,[h?"":d]:s,_groupValue:s},t,{specialRow:!0,groupFooterFor:s,groupRecord:r});a.stores=[t],t.register(a),a.groupChildren=r.groupChildren,g.splice(++e,0,a),i++,r.groupChildren.push(a),r.unfilteredGroupChildren.push(a),r.meta.childCount++}t._idMap=null;const y={values:g.reduce(((e,t)=>(t.isGroupFooter||(e.push(t),t.meta.collapsed||e.push(...t.unfilteredGroupChildren)),e)),!1,[])};return i&&(y.filteredValues=y.values.filter(p)),null===(e=t.groupRecords)||void 0===e||e.forEach((e=>{g.includes(e)||e.destroy()})),t.groupRecords=g,y}get isGrouped(){var e;return Boolean(null===(e=this.groupers)||void 0===e?void 0:e.length)}group(e,t,n=!1,i=!0,r=!1){const s=this,o=s.createGrouper(e);let a;if(n)s.groupers.push(o);else if(e){var l,c;if(null==t&&!("ascending"in o))o.ascending=!o.fn||(null===(l=s.groupInfo)||void 0===l?void 0:l.field)!==o.field||(null===(c=s.groupInfo)||void 0===c?void 0:c.fn)!==o.fn||!s.groupInfo.ascending;s.groupInfo=a=o,s.groupers=[s.groupInfo]}if(a){const{prototype:t}=s.modelClass;a.complexMapping&&!Object.prototype.hasOwnProperty.call(t,e)&&Object.defineProperty(t,e,{get(){return W.getPath(this,e)}})}if(!1!==i){if(s.remoteSort&&!s.isRemoteDataLoading)return s.sort(null,null,!1,!0).then((()=>s.onAfterGrouping(r)));s.sort(null,null,!1,!0)}s.onAfterGrouping(r)}onAfterGrouping(e){if(e)return;const t=this,n=t.groupers||[];t.trigger("group",{isGrouped:t.isGrouped,groupers:n,records:t.storage.values}),t.trigger("refresh",{action:"group",isGrouped:t.isGrouped,groupers:n,records:t.storage.values})}addGrouper(e,t=!0){return this.group(e,t,!0)}removeGrouper(e){const t=this,{groupers:n}=t;if(!n)return;const i=n.findIndex((t=>t.field===e));return i>-1?(n.splice(i,1),n.length?t.group():t.clearGroupers()):void 0}clearGroupers(e=!1){return this.setGroupers(null,{silent:e})}isRecordInGroup(e,t){var n;if(!this.isGrouped)return null;const i=null===(n=this.groupers[0])||void 0===n?void 0:n.field;return e.getValue(i)===t&&!e.isSpecialRow}isInCollapsedGroup(e){const{groupParent:t}=e.instanceMeta(this);return null==t?void 0:t.meta.collapsed}getGroupRecords(e){return this.isGrouped?this.storage.values.filter((t=>this.isRecordInGroup(t,e))):null}getGroupTitles(){return this.isGrouped?this.getDistinctValues(this.groupers[0].field):null}onDataChanged({changes:e,action:t}){this.isGrouped&&(!e&&ro[t]||e&&this.groupers.some((t=>t.rootFieldName in e)))&&this.sort()}internalIncludeExcludeGroupRecords(e,t){const n=this,i=n.indexOf(e),r=n.allIndexOf(e),{id:s,storage:o}=n,{_filteredValues:a,_values:l}=o,{meta:c,groupChildren:d,unfilteredGroupChildren:u}=e;-1===r||c.collapsed&&!t||!c.collapsed&&t||(u.forEach((e=>e.instanceMeta(s).hiddenByCollapse=!t)),t?(a&&a.splice(i+1,0,...d.filter((e=>!n.isAvailable(e.id)))),o._values.splice(r+1,0,...u.filter((e=>!n.isAvailable(e.id))))):(a&&a.splice(i+1,d.length),l.splice(r+1,u.length)),o._indicesInvalid=!0,n._idMap=null)}excludeGroupRecords(e){this.internalIncludeExcludeGroupRecords(e,!1)}includeGroupRecords(e){this.internalIncludeExcludeGroupRecords(e,!0)}collectGroupRecords(e,t=!0){return(e?this.storage.allValues:this.storage.values).reduce(((n,i)=>(i.isSpecialRow&&(t&&!i.isGroupFooter&&n.push(i),i.isGroupHeader&&n.push.apply(n,e?i.unfilteredGroupChildren:i.groupChildren)),n)),[])}},ao=e=>class extends(e||Pe){static get configurable(){return{objectify:null}}initProxy(){if(!globalThis.Proxy)throw new Error("Proxy not supported");return new Proxy(this,{get(e,t){if(t in e)return e[t];if("$store"===t)return e;let n=e.getById(t);return n||isNaN(parseInt(t))||(n=e.getAt(parseInt(t))),n},set:(e,t,n)=>(t in e||e.isDestroying||"_triggered"===t?e[t]=n:e.add({[e.modelClass.idField]:t,...n}),!0),deleteProperty:(e,t)=>e.isDestroying?(delete e[t],!0):Boolean(e.remove(t).length),has(e,t){if(t in e)return!0;if(t.startsWith("{")&&t.endsWith("}")){const e=H.safeJsonParse(t);t=null==e?void 0:e.id}return e.includes(t)}})}},lo=e=>class extends(e||Pe){static $name="StoreRelation";initRelations(e){const t=this,n=t.modelClass.exposedRelations;e&&t.modelRelations&&t.modelRelations.forEach((e=>{var t;return null===(t=e.storeDetacher)||void 0===t?void 0:t.call(e)})),t.modelRelations&&0!==t.modelRelations.length&&!e||t.isChained||(t.modelRelations=[],null==n||n.forEach((n=>{const i={...n},{foreignStore:r,relationName:s,relatedCollectionName:o}=i,a="string"==typeof r?t[r]:r;if(i.dependentStore=t,t.modelRelations.push(i),a){i.foreignStoreProperty=i.foreignStore,i.foreignStore=a;const n=a.dependentStoreConfigs;if(n.has(t)){const r=n.get(t);if(e){const e=r.find((e=>e.relationName===s));e&&$e.remove(r,e)}r.push(i)}else n.set(t,[i]);o&&a.initRelationCollection(i,t),a.count>0&&a.updateDependentStores("dataset",a.records)}})))}initRelationCollection(e,t){const n=this,i=e.relatedCollectionName;(n.collectionStores||(n.collectionStores={}))[i]={store:t,config:e},n[i+"Store"]||(n[i+"Store"]=t),n.allRecords.length&&n.initModelRelationCollection(i,n.allRecords)}initModelRelationCollection(e,t){const n=this;t.forEach((t=>{t.traverse((t=>{const i=e in t?`$related${H.capitalize(e)}`:e;Object.defineProperty(t,i,{enumerable:!0,configurable:!0,get:function(){return n.getCollection(this,e)},set:function(t){return n.setCollection(this,e,t)}})}))}))}resetRelationCache(){this.relationCache={},this.forEach((e=>e.initRelations()))}updateRecordRelationCache(e,t){null==t||t.forEach((t=>{const{config:n}=t,i=t.related?t.related.id:e.getValue(n.foreignKey);void 0!==i&&this.cacheRelatedRecord(e,i,n.relationName,i)}))}getRelationCollection(e,t){var n;const i=ws.asId(t);return(null===(n=this.relationCache[e])||void 0===n?void 0:n[i])||[]}getCollection(e,t){var n;const{config:i,store:r}=this.collectionStores[t];return(null===(n=r.relationCache[i.relationName])||void 0===n?void 0:n[e.id])||[]}setCollection(e,t,n){const{config:i,store:r}=this.collectionStores[t],s=((r.relationCache[i.relationName]||(r.relationCache[i.relationName]={}))[e.id]||[]).slice(),o=[],a=[];r.suspendEvents(),s.forEach((e=>{n.includes(e)||(e[i.foreignKey]=null,r.remove(e),a.push(e))})),n.forEach((t=>{t.isModel instanceof ws?t.stores.includes(r)||(r.add(t),o.push(t)):([t]=r.add(t),o.push(t)),t[i.foreignKey]=e.id})),r.resumeEvents(),a.length&&(r.trigger("remove",{records:a}),r.trigger("change",{action:"remove",records:a})),o.length&&(r.trigger("add",{records:o}),r.trigger("change",{action:"add",records:o}))}cacheRelatedRecord(e,t,n,i=null){const r=this,s=r.relationCache[n]||(r.relationCache[n]={});null!==i&&r.uncacheRelatedRecord(e,n,i),null!=t&&$e.include(s[t]||(s[t]=[]),e)}uncacheRelatedRecord(e,t=null,n=null){const i=this;function r(t,n){const r=i.relationCache[t],s=null==r?void 0:r[n];if(s){const t=s.indexOf(e);t>=0&&s.splice(t,1),0===s.length&&delete r[n]}}null!=n?r(t,n):e.meta.relationCache&&Object.entries(e.meta.relationCache).forEach((([e,t])=>r(e,null==t?void 0:t.id)))}updateDependentStores(e,t,n){var i;const r=this;var s;(r.dependentStoreConfigs.forEach((i=>{i.forEach((i=>{const{dependentStore:s,relatedCollectionName:o,relationName:a,foreignKey:l}=i,c=s.relationCache[a];if("dataset"===e)o&&this.initModelRelationCollection(o,t),s.forEach((e=>{const t=e.initRelation(i);t&&s.cacheRelatedRecord(e,t.id,a,t.id)}));else{if("removeall"===e)return s.forEach((e=>e.removeRelation(i))),void delete s.relationCache[a];"replace"===e&&(t=t.map((e=>e[1])))}"add"!==e&&"replace"!==e||o&&this.initModelRelationCollection(o,t),"dataset"!==e&&t.forEach((t=>{const o=null==c?void 0:c[t.id];switch(e){case"remove":o&&o.forEach((e=>e.removeRelation(i)));break;case"add":case"replace":s.forEach((e=>{e.getValue(l)==t.id&&(e.initRelation(i),s.cacheRelatedRecord(e,t.id,a))}))}!n&&null!=o&&o.length&&i.propagateRecordChanges&&o.forEach((e=>e.stores.forEach((n=>r.notifyRelatedStore(n,e,i.relationName,t)))))}))}))})),"dataset"!==e&&null!==(i=t)&&void 0!==i&&i.length)&&(null===(s=r.modelRelations)||void 0===s||s.forEach((e=>{e.propagateRecordChanges&&t.forEach((t=>{var n;const i=t[e.relationName];null==i||null===(n=i.stores)||void 0===n||n.forEach((n=>{r.notifyRelatedStore(n,i,e.relatedCollectionName,t)}))}))})))}notifyRelatedStore(e,t,n,{meta:i}){var r;if(this.isChained||e.isChained)return;let{_ignoreRelationUpdate:s}=i,o=!1;null!==(r=s)&&void 0!==r&&r.size||(i._ignoreRelationUpdate=s=new Set,o=!0),s.has(e)||(s.add(this).add(e),t.meta._ignoreRelationUpdate=s,e.onModelChange(t,{[n]:t[n]},{[n]:t[n]},!1,!0),o&&s.clear())}updateDependentRecordIds(e,t){var n;null===(n=this.dependentStoreConfigs)||void 0===n||n.forEach((n=>{n.forEach((n=>{var i;const{dependentStore:r,relationName:s,foreignKey:o}=n,a=r.relationCache[s],l=null==a||null===(i=a[e])||void 0===i?void 0:i.slice();null==l||l.forEach((n=>{r.cacheRelatedRecord(n,t,s,e),n.meta._ignoreRelatedIdUpdate=!0,n.set(o,t,!1,!0),delete n.meta._ignoreRelatedIdUpdate}))}))}))}},co=e=>class extends(e||Pe){static $name="StoreSum";sum(e,t=this.storage.values){return t?t.reduce(((t,n)=>{if(n.isSpecialRow)return t;const i=Number(n.getValue(e));return isNaN(i)?t:t+i}),0):0}min(e,t=this.storage.values){return null!=t&&t.length?t.reduce(((t,n)=>{const i=n.getValue(e);return"number"===typeof(null==i?void 0:i.valueOf())&&(i<t||null==t)&&(t=i),t}),t[0].getValue(e)):0}max(e,t=this.storage.values){return null!=t&&t.length?t.reduce(((t,n)=>{const i=n.getValue(e);return"number"===typeof(null==i?void 0:i.valueOf())&&(i>t||null==t)&&(t=i),t}),t[0].getValue(e)):0}average(e,t=this.storage.values){if(null==t||!t.length)return 0;let n=0;const i=t.reduce(((t,i)=>{if(i.isSpecialRow)return t;const r=parseFloat(i.getValue(e));return isNaN(r)?t:(n++,t+r)}),0);return n>0?i/n:0}groupSum(e,t){return this.sum(t,this.getGroupRecords(e))}};const uo=(e,t)=>String(e).toLowerCase().includes(t),ho={string:uo,number:(e,t)=>e===Number(t),boolean:uo,date:(e,t)=>e instanceof Date&&t instanceof Date?e-t==0:String(e.getMonth()+1).includes(t)||String(e.getDate()).includes(t)||String(e.getFullYear()).includes(t),object:(e,t)=>e===t,undefined:(e,t)=>e===t};var go=e=>class extends(e||Pe){static $name="StoreSearch";search(e,t=null,n,i){const r=this.isTree&&!i?this.rootNode.allChildren:this.getAllDataRecords(i),s=r.length,o=[];if(null==e)return[];let a,l,c,d,u,h;for("string"==typeof e&&(e=e.toLowerCase()),a=0;a<s;a++){c=r[a],l=0;for(const i of t||c.fieldNames){var g;d=c.getValue(i),u=d instanceof Date?"date":typeof d;const t=null==n?void 0:n[l];t&&(d=t(d),u="string"),h=ho[u],d&&null!==(g=h)&&void 0!==g&&g(d,e)&&o.push({index:a,data:c,field:i,id:c.id}),l++}}return o}findByField(e,t,n=!1,i=!1){const r=this.getAllDataRecords(i),s=r.length,o=new Set,a=[];let l,c,d;for(null!=t&&(t=String(t).toLowerCase()),l=0;l<s;l++)if(c=r[l],d=c.getValue(e),!n||!o.has(d)){const e=d instanceof Date?"date":typeof d;(null==t&&d===t||""===t&&""===d||t&&(0,ho[e])(d,t))&&(a.push({id:c.id,index:l,data:c}),n&&o.add(d))}return a}find(e,t=!1){return this.getAllDataRecords(t).find(e)}findRecord(e,t,n=!1){const i=n=>W.isEqual(n[e],t);return this.isTree?this.query(i,n)[0]:this.getAllDataRecords(n).find(i)}query(e,t=!1){return this.getAllDataRecords(t).filter(e)}some(e,t=!1){return this.getAllDataRecords(t).some(e)}},mo=e=>class extends(e||Pe){static $name="StoreSort";static get defaultConfig(){return{useLocaleSort:null}}static get configurable(){return{sorters:[],reapplySortersOnAdd:!1}}get isSorted(){return Boolean(this.sorters.length)||this.isGrouped}changeSorters(e){return e.map((e=>this.normalizeSorterConfig(e,!0)))}updateReapplySortersOnAdd(e){this.storage.autoSort=e}sort(e,t,n=!1,i=!1){const r=this,s=r.allRecords,o=r.sorters?r.sorters.slice():[];let a,l=null;if(e)if(Array.isArray(e))r.sorters=e.map((e=>r.normalizeSorterConfig(e,"string"==typeof e||t)));else{const i=r.normalizeSorterConfig(e,t);n?(a=r.getCurrentSorterByField(i.field),a?(l=a.ascending,a.ascending=i.ascending):r.sorters.push(i)):r.sorters=[i]}return i||!1!==r.trigger("beforeSort",{sorters:r.sorters,records:s,currentSorters:o})?r.performSort(i):(r.sorters=o,null!==l&&(a.ascending=l),null)}normalizeSorterConfig(e,t){const n=this,i={ascending:t};if("object"==typeof e?(W.assign(i,e),e.fn&&(delete i.fn,i.sortFn=e.fn),i.ascending=e.ascending??t):"function"==typeof e?i.sortFn=e:i.field=e,null==i.ascending){const e=n.getCurrentSorterByField(i.field);i.ascending=!e||!e.ascending}if(null==i.sortFn){var r;const e=null===(r=n.modelClass)||void 0===r||null===(r=r.$meta.fields.map[i.field])||void 0===r?void 0:r.compareItems;e&&(i.sortFn=e)}return i}getCurrentSorterByField(e){return"string"==typeof e&&this.sorters.find((t=>t.field===e))||null}addSorter(e,t=!0){return this.sort(e,t,!0)}removeSorter(e){const t=this.sorters.findIndex((t=>t.field===e||t.sortFn===e));if(t>-1)return this.sorters.splice(t,1),this.sort()}clearSorters(e=!1){if(this.sorters.length)return this.sorters.length=0,this.sort(void 0,void 0,void 0,e)}createSorterFn(e){const t=this.useLocaleSort;return(n,i)=>{for(let r=0;r<e.length;r++){const s=e[r],{field:o,ascending:a=!0,useLocaleSort:l=t}=s,c=s.fn||s.sortFn,d=a?1:-1;if(c){const e=c.call(s,n,i);if(0===e)continue;if(null!==e)return e*d}const u=n.isModel?n.getValue(o):n[o],h=i.isModel?i.getValue(o):i[o];if(u!==h){if(null==u)return-d;if(null==h)return d;if(l&&"string"==typeof u){if(!0===l)return String(u).localeCompare(h)*d;if("string"==typeof l)return String(u).localeCompare(h,l)*d;if("object"==typeof l)return String(u).localeCompare(h,l.locale,l)*d}if(u>h)return d;if(u<h)return-d}}return 0}}get sorterFn(){return this.createSorterFn(this.remoteSort?[{field:"_remoteSortIndex"}]:this.sorters)}performSort(e){const t=this,{rootNode:n,storage:i,sorterFn:r}=t;t.tree?(!t.isChained&&n.traverse((e=>{e.isLoaded&&e.isParent&&(e.children.sort(r),e.updateChildrenIndices(e.children,"parentIndex",!0))})),i.replaceValues({values:t.collectDescendants(n).visible,silent:!0})):t.isGrouped?i.replaceValues({...t.prepareGroupRecords(),silent:!0}):i.replaceValues({values:i.values.sort(r),silent:!0}),t.afterPerformSort(e||t.isRemoteDataLoading)}afterPerformSort(e){if(e)return;const t=this;t._idMap=null;const n={action:"sort",sorters:t.sorters,records:t.allRecords};t.trigger("sort",n),t.trigger("refresh",n)}};const po=()=>!0;var fo=e=>class extends(e||Pe){static $name="StoreChained";static get defaultConfig(){return{chainedFilterFn:null,chainedFields:null,masterStore:null,doRelayToMaster:["add","remove","insert"],dontRelayToMaster:[],excludeCollapsedRecords:!0,syncSort:!0,chainFilters:null,chainSuspended:0}}static get properties(){return{chainedStores:null}}construct(e){super.construct(e);const t=this,{masterStore:n}=t;n&&(t.methodNamesToRelay.forEach((e=>t[e]=(...n)=>t.relayToMaster(e,n))),t.removeAll=(...e)=>{n.remove(t.getRange(),...e)},n.ion({changePreCommit:t.onMasterDataChangedPreCommit,change:t.onMasterDataChanged,prio:1,thisObj:t}),t.syncSort&&n.ion({sort:()=>t.sort(n.sorters),thisObj:t}),n.chainedStores||(n.chainedStores=[]),n.chainedStores.push(t),t.fillFromMaster())}get $master(){return this.masterStore||this}get isChained(){return Boolean(this.masterStore)}set chainedFilterFn(e){this._chainedFilterFn=this.thisObj?e.bind(this.thisObj):e}get chainedFilterFn(){return this._chainedFilterFn||po}get methodNamesToRelay(){const e=Array.isArray(this.doRelayToMaster),t=Array.isArray(this.dontRelayToMaster);return e&&this.doRelayToMaster.filter((e=>!t||!this.dontRelayToMaster.includes(e)))||[]}updateChainedStores(){var e;null===(e=this.chainedStores)||void 0===e||e.forEach((e=>e.fillFromMaster()))}fillFromMaster(){const e=this,{masterStore:t,isTree:n}=e,{isFiltered:i}=t;let r=[];if(!e.isChained)throw new Error("fillFromMaster only allowed on chained store");if(e.isChainSuspended)return;let s=null;if(e.chainFilters&&i){const e=t.filters.values.filter((e=>!e.ignoreForChain));e.length&&(s=_s.generateFiltersFunction(e))}if(r=t.allRecords.filter((t=>!t.isSpecialRow&&e.chainedFilterFn(t)&&(!s||s(t)))),e.masterStore.sorterFn&&i&&t.isSorted&&!t.remoteSort&&r.sort(t.sorterFn),n)if(e.idRegister={},e.internalIdRegister={},r.forEach((t=>{t.stores.includes(e)?e.register(t):t.joinStore(e)})),e.excludeCollapsedRecords){const t=e.getChildren(e.rootNode);r=e.doIncludeExclude(t,!0)}else r.forEach((t=>t.instanceMeta(e).collapsed=!1));e.isFillingFromMaster=!0,e.data=r,e.isFillingFromMaster=!1}commitToMaster(){const e=this,t=e.masterStore;if(!e.isChained)throw new Error("commitToMaster only allowed on chained store");return t.beginBatch(),t.remove(e.removed.values),t.add(e.added.values),t.endBatch(),e.commit()}relayToMaster(e,t){return this.masterStore[e](...t)}onMasterDataChangedPreCommit(e){this.onMasterDataChanged(e),this.$masterEventhandled=!0}onMasterDataChanged({action:e,changes:t,isMove:n}){var i;const r=this;r.$masterEventhandled?r.$masterEventhandled=!1:n&&"remove"===e||("update"!==e||"*"===r.chainedFields||null!==(i=r.chainedFields)&&void 0!==i&&i.some((e=>e in t)))&&r.fillFromMaster()}makeChained(e=po,t,n){if(this.isChained){const t=e;e=e=>t(e)&&this.chainedFilterFn(e)}return new((null==n?void 0:n.storeClass)||this.constructor)({id:`${this.id}-chained-${H.generateUUID()}`,tree:!1,autoTree:!1,...n||{},masterStore:this.$master,modelClass:this.modelClass,syncDataOnLoad:!1,chainedFilterFn:e,chainedFields:t})}chain(){return this.makeChained(...arguments)}doDestroy(){var e;null===(e=this.chainedStores)||void 0===e||e.forEach((e=>e.destroy())),super.doDestroy()}suspendChain(){this.chainSuspended++}resumeChain(e=!1){this.chainSuspended&&! --this.chainSuspended&&e&&this.fillFromMaster()}get isChainSuspended(){return this.chainSuspended>0}},vo=e=>class extends(e||Pe){static $name="StoreState";getState(){const{sorters:e,groupers:t,filters:n}=this,i={};return null!=e&&e.length&&(i.sorters=e.map((e=>{const t=W.cleanupProperties(W.clone(e));return delete t.fn,delete t.sortFn,t}))),null!=t&&t.length&&(i.groupers=t.map((e=>{const t=W.cleanupProperties(W.clone(e));return delete t.fn,t})),i.collapsedGroups=[...this.collapsedGroups]),null!=n&&n.values.length&&(i.filters=n.values.map((e=>{const t=W.cleanupProperties(W.clone(e.config));return t.value=e.value,t.caseSensitive&&delete t.caseSensitive,t}))),i}applyState(e){var t;const n=this,{sorters:i=[],groupers:r=[],filters:s=[]}=e,{sortParamName:o,filterParamName:a}=n;(n.isSorted||0!==i.length||0!==r.length)&&(n.sorters=i.filter((e=>e.field||e.sortFn&&!o)),n.groupers=r.slice(),n.sort()),null===(t=e.collapsedGroups)||void 0===t||t.forEach((e=>{const t=n.getById(e);t&&n.collapse(t,!0)})),(n.isFiltered||0!==s.length)&&(n.filters=s.filter((e=>e.property||e.filterBy&&!a)),n.filter())}};class yo{static preWalk(e,t,n){const i=[e];let r,s;for(;i.length;)r=i.pop(),n(r),s=t(r),s&&i.push.apply(i,s.slice().reverse())}static preWalkWithParent(e,t,n){const i=[{node:e,parent:null}];for(;i.length;){const{parent:e,node:r}=i.pop();n(e,r);const s=t(r);Array.isArray(s)&&i.push(...s.slice().reverse().map((e=>({node:e,parent:r}))))}}static preWalkUnordered(e,t,n){const i=[e];let r,s;for(;i.length;)r=i.pop(),n(r),s=t(r),s&&i.push.apply(i,s)}static postWalk(e,t,n){const i=new Map,r=[e];let s,o;for(;r.length;)s=r[r.length-1],i.has(s)?(n(s),r.pop()):(o=t(s),o&&r.push(...o.slice().reverse()),i.set(s,s))}static prePostWalk(e,t,n,i){const r=new Map,s=[e];let o,a;for(;s.length;)o=s[s.length-1],r.has(o)?(i(o),s.pop()):(n(o),a=t(o),a&&s.push(...a.slice().reverse()),r.set(o,o))}}yo._$name="WalkHelper";const bo=e=>String(e).padStart(6,"0");class Co{constructor(e){this.value=e,this._padded=null}set value(e){this._value=String(e??"")}get value(){return this._value}static from(e){return null==e||e instanceof Co?e:new Co(e)}static pad(e){return e instanceof Co?e.valueOf():Co.split(e).map(bo).join(".")}static split(e){let t,n;if(e||0===e)switch(typeof e){case"object":e=String(e);case"string":for(n=e.split("."),t=n.length;t-- >0;)n[t]=parseInt(n[t],10);break;case"number":n=[e]}return n||[]}static compare(e,t){return e===t?0:e&&t?(e=Co.pad(e))<(t=Co.pad(t))?-1:t<e?1:0:e?1:t?-1:0}append(e){const t=this.value;return Co.from(t?`${t}.${e}`:e)}isEqual(e){return!Co.compare(this,e)}match(e){let t=!1;if(e){const n=this.value,i="*"===e[0],r=e.endsWith("*"),s=e.length;t=i===r?n.indexOf(i?e.substr(1,s-2):e)>-1:i?n.endsWith(e.substr(1)):n.startsWith(e.substr(0,s-1))}return t}toString(){return this.value}toJSON(){return this.toString()}valueOf(){return this._padded??(this._padded=Co.pad(this.value))}}Co._$name="Wbs";const So=Object.freeze([]),Do=Symbol("StopBranch"),wo=H.generateUUID();var Eo=e=>class extends(e||Pe){static $name="StoreTree";static StopBranch=Do;get StopBranch(){return Do}static configurable={transformFlatData:null,fireRemoveEventForMoveAction:!1};get isTree(){return this.tree||this.masterStore&&this.masterStore.tree}get leaves(){const e=this,t=[];return e.isTree?(e.traverse((e=>{e.isLeaf&&t.push(e)})),t):(e.allRecords.forEach((e=>{e.isLeaf&&t.push(e),e.traverse((e=>{e.isLeaf&&t.push(e)}),!0)})),t)}async loadChildren(e){}onNodeAddChild(e,t,n,i,r=!1){const s=this,o=e===s.rootNode&&e.isLoading,{storage:a}=s,{previousSibling:l}=t[0];let c;const{visible:d,all:u}=s.collectDescendants(t,void 0,void 0,{inCollapsedBranch:!(e.isExpanded(s)&&e.ancestorsExpanded(s)),applyFilter:s.isFiltered&&s.reapplyFilterOnAdd});if(!o&&u.length)for(const e of u)s.modified.includes(e)||i[e.id]||(s.removed.includes(e)?s.removed.remove(e):e.isLinked||s.added.add(e));var h;if(o&&s.rootVisible&&(d.unshift(e),u.unshift(e)),d.length?(c=0!==n&&l?a.indexOf(l)+l.getDescendantCount(!0,s):a.indexOf(e),a.suspendEvents(),s.storage.splice(++c,0,d),a.resumeEvents(),s._idMap=null):s._allRecords=null,s.updateDependentStores("add",t),o&&d.length){if(s.sorters.length&&s.sort(null,null,!1,!0),null===(h=s.afterLoadData)||void 0===h||h.call(s),!r){const e={action:"dataset",data:s._data,records:d};s.trigger("refresh",e),s.trigger("change",e)}}else if(!r){const n={action:"add",parent:e,isChild:!0,isMove:i,records:t,allRecords:u,index:c};if(s.trigger("add",n),s.trigger("change",n),i&&Object.values(i).some((e=>e))){const n={newParent:e,records:t.filter((e=>i[e.id])),oldParents:t.map((e=>s.getById(e.meta.oldParentId)))};s.trigger("move",n)}}}onNodeRemoveChild(e,t,n,i={isMove:!1,silent:!1,unfiltered:!1}){const r=this,{storage:s}=r,o=[],a=[],{isMove:l,silent:c,unfiltered:d}=i,u=d&&r.isFiltered,h=u&&e.unfilteredChildren?e.unfilteredChildren:t;if(r.collectDescendants(h,o,a,{inCollapsedBranch:!(e.isExpanded(r)&&e.ancestorsExpanded(r)),unfiltered:u}),!l){for(const e of t)e.unjoinStore(r);for(const e of a)e.stores.includes(r)&&e.unjoinStore(r),r.added.includes(e)?r.added.remove(e):e.isLinked||r.removed.add(e);r.modified.remove(a)}if(o.length?(n=s.indexOf(o[0]))>-1&&(s.suspendEvents(),s.splice(n,o.length),s.resumeEvents(),r._idMap=null):(n=-1,r._allRecords=null),!c&&(r.fireRemoveEventForMoveAction||!l)){const i={action:"remove",parent:e,isChild:!0,isMove:l,records:t,allRecords:a,index:n};r.trigger("remove",i),r.trigger("change",i)}return a}collectDescendants(e,t=[],n=[],i={}){const r=this,{inCollapsedBranch:s=!1,unfiltered:o=!1,applyFilter:a=!1}=i,l=Array.isArray(e)?e:r.getChildren(e,o)??[];if(a)return{visible:!s&&l.flatMap((e=>r.collectVisibleNodeDescendantsFiltered(e))),all:l.flatMap((e=>e.allChildren))};for(let e,i=0,a=l.length;i<a;i++)e=l[i],s||t.push(e),n.push(e),r.collectDescendants(e,t,n,{inCollapsedBranch:s||!e.isExpanded(r),unfiltered:o});return{visible:t,all:n}}collectVisibleNodeDescendantsFiltered(e){const t=e.unfilteredChildren||e.children;if(!t||0===t.length||!e.isLeaf&&!e.isExpanded(this))return this.filtersFunction(e)?[e]:[];const n=t.flatMap((e=>this.collectVisibleNodeDescendantsFiltered(e)));return n.length||this.filtersFunction(e)?[e,...n]:[]}getChildren(e,t=!1){const n=this,i=(t||n.isChained)&&e.unfilteredChildren||e.children;return null!=i&&i.length?n.isChained?i.filter(n.chainedFilterFn).sort(n.sorterFn):i:So}internalToggleTreeSubRecords(e,t){const n=this,{storage:i}=n,r=i.indexOf(e),s=n.doIncludeExclude(n.getChildren(e),t);if(n.isFiltered&&t&&e.unfilteredChildren&&n.updateChildrenHiddenState(e),s.length&&!1!==r){if(i.suspendEvents(),t){i.splice(r+1,0,...s);const t={action:"add",isExpand:!0,parent:e,records:s,index:r+1};n.trigger("add",t),n.trigger("change",t)}else{i.splice(r+1,s.length);const t={action:"remove",isCollapse:!0,parent:e,records:s,index:r+1};n.trigger("remove",t),n.trigger("change",t)}i.resumeEvents(),n._idMap=null}}updateChildrenHiddenState(e){var t;null===(t=e.unfilteredChildren)||void 0===t||t.forEach((e=>{e.instanceMeta(this.id).hidden=!1,e.isLeaf||this.updateChildrenHiddenState(e)}))}doIncludeExclude(e,t,n=[]){const i=this,r=(null==e?void 0:e.length)||0;for(let s=0;s<r;s++){const r=e[s];if(!i.isChained||i.chainedFilterFn(r)){const e=r.instanceMeta(i.id);!t&&e.hidden||n.push(r),e.hidden=!t,r.isExpanded(i)&&i.doIncludeExclude(i.getChildren(r),t,n)}}return n}async toggleCollapse(e,t){const n=this,i=n.getById(e),r=i.instanceMeta(n);if(void 0===t&&(t=!r.collapsed),!r.isLoadingChildren&&!i.isLeaf&&i.isExpanded(n)===t){if(n.trigger("beforeToggleNode",{record:i,collapse:t}),r.collapsed=t,r.collapsed)return n.onNodeCollapse(i),!0;{n.onNodeExpand(i);let e=!0;if(!i.isLoaded){r.isLoadingChildren=!0;try{await n.loadChildren(i)}catch(t){r.collapsed=!0,e=!1,n.trigger("loadChildrenException",{record:i,exception:t})}finally{r.isLoadingChildren=!1}}return e}}}onNodeCollapse(e){if(e.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(e,!1)}onNodeExpand(e){if(e.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(e,!0)}transformToTree(e){const{parentIdField:t,idField:n,childrenField:i}=this.modelClass,r=new Map,s=new Set,o=[];for(const t of e){const e=null==t?void 0:t[n];null!=e&&r.set(e,t)}const a=e=>{const t=Object.assign({},e);return t[i]=[],r.set(t[n],t),s.add(e[n]),t};for(let l of e)if(l){const e=l[n];l=s.has(e)?r.get(e):a(l);const c=l[t];if(null!=c){let e=r.get(c);e&&(e[i]||(e=a(e)),e[i].push(l))}else l[i]?o.push(l):null!=l[n]?o.push(a(l)):o.push(l)}return r.forEach((e=>{var t,n;null===(t=(n=e[i]).sort)||void 0===t||t.call(n,((e,t)=>e.parentIndex-t.parentIndex))})),o}treeifyData(e,t,n,i=!1,r){const{length:s}=t,o=[],a=[],l={};let c,d;for(c=0;c<s;c++){let e=t[c];e=e.field||e,t[c].call||(t[c]=t=>t[e],t[c].fieldName=e),o[c]=new Map}yo.preWalkWithParent({isRoot:!0,id:this.rootNode.id,children:e},(e=>e.children),((e,n)=>{if(d=[],n.isLeaf){for(c=0;c<s;c++){const e=t[c],i=r?r(e(n),e.fieldName):e(n),s=o[c],a=""===i?wo:i,l=$e.asArray(a)||[wo],u=[];if(l[0]===Do)break;(d.length>0?d:[null]).forEach((t=>{for(let i=0,{length:r}=l;i<r;i++){const r=l[i],o=`${((null==t?void 0:t.path)??"")+(null!=r&&r.isModel?r.id:r)}/`,a=H.makeValidDomId(`generated_${o}`,"_"),c=s.get(a)||s.set(a,{id:a,key:l[i]===wo?"":r,path:o,readOnly:!0,children:[],generatedParent:!0,field:e.fieldName,firstGroupChild:n}).get(a);u.push(c),t&&!t.children.includes(c)&&t.children.push(c)}})),d=u}d.length?d.forEach(((e,t)=>e.children.push(t?n.link():n))):a.push(n)}}),!0),(n||i)&&o.forEach((e=>e.forEach(((e,t,r)=>{null==n||n(e),i&&(e=this.createRecord(e),r.set(t,e))})))),l.children=[...o[0].values(),...a];const u=e=>{e.children&&(e.children.sort(((e,n)=>{if(e.isLeaf===n.isLeaf){if(e.isLeaf){let i;for(let r=0;!i&&r<s;r++){const s=t[r](e),o=t[r](n);if(s===Do||o===Do)return e.isLeaf<n.isLeaf?-1:e.isLeaf>n.isLeaf?1:0;i=s<o?-1:o<s?1:0}return i}return"string"==typeof e.key&&"string"==typeof n.key?e.key.localeCompare(n.key,void 0,{numeric:!0}):e.key<n.key?-1:e.key>n.key?1:0}return e.isLeaf<n.isLeaf?-1:e.isLeaf>n.isLeaf?1:0})),e.children.forEach(u))};return u(l),l}treeify(e,t,n=!1,i){return this.treeifyData(this.rootNode.children,e,t,!1,i)}treeifyFlatData(e){const{childrenField:t,parentIdField:n}=this.modelClass;let i=!1,r=!0;for(const s of e){if(null!=s&&s.isModel||Array.isArray(null==s?void 0:s[t])){r=!1;break}null!=(null==s?void 0:s[n])&&(i=!0)}return r&&i&&(e=this.transformToTree(e)),e}async indent(e){const t=this;if((e=(e=Array.isArray(e)?e:[e]).filter((t=>{let n=Boolean(t.previousSibling);for(;n&&!t.isRoot;)n=!e.includes(t.parent),t=t.parent;return n}))).length&&!1!==t.trigger("beforeIndent",{records:e})){e.sort(((e,t)=>Co.compare(e.wbsCode,t.wbsCode))),t.beginBatch();for(const n of e){const e=n.previousSibling;e.appendChild(n),t.toggleCollapse(e,!1)}t.endBatch(),t.trigger("indent",{records:e}),t.trigger("change",{action:"indent",records:e})}}async outdent(e){const t=this;if((e=(e=Array.isArray(e)?e:[e]).filter((t=>{const{parent:n}=t;let i=n&&!n.isRoot;for(;i&&!t.isRoot;)i=!e.includes(n),t=t.parent;return i}))).length&&!1!==t.trigger("beforeOutdent",{records:e})){e.sort(((e,t)=>Co.compare(e.wbsCode,t.wbsCode))),t.beginBatch();for(const n of e){const{parent:e}=n,i=e.children.slice(e.children.indexOf(n)+1);e.parent.insertChild(n,e.nextSibling),n.appendChild(i),t.toggleCollapse(n,!1)}t.endBatch(),t.trigger("outdent",{records:e}),t.trigger("change",{action:"outdent",records:e})}}},Ro=e=>class extends(e||Pe){static $name="StoreSync";static get configurable(){return{syncDataOnLoad:null,shouldSyncDataset:null,shouldSyncRecord:null,reorderOnSync:!0}}syncDataset(e){var t,n,i,r;const s=this,{storage:o}=s,a=(null===(t=s.shouldSyncDataset)||void 0===t?void 0:t.call(s,{data:e,store:s,records:s.records}))??(null===(n=s.project)||void 0===n||null===(i=n.shouldSyncDataset)||void 0===i?void 0:i.call(n,{data:e,store:s,records:s.records}));if(!1===a)return;s.trigger("startApplyChangeset"),s.isSyncingDataOnLoad=!0;const{toAdd:l,toRemove:c,toMove:d,updated:u,ids:h}=s.tree?s.syncTreeDataset(e,a):s.syncFlatDataset(e,a);let g=null===(r=s.syncDataOnLoad)||void 0===r?void 0:r.threshold,m=!1;if(g&&("string"==typeof g&&(g=parseInt(g,10)/100*s.count),m=l.length+c.length+d.length+u.length>g),s.tree){if(l.length){s.add(l,m).forEach((e=>e.clearParentId()))}if(d.length)for(const{parent:e,node:t,index:n}of d){s.getById(e.id).insertChild(t,n)}s.remove(c,m)}else m&&s.suspendEvents(),s.remove(c),s.add(l),m&&s.resumeEvents();g&&!m&&u.forEach((({record:e,toSet:t,wasSet:n})=>s.onModelChange(e,t,n))),s.acceptChanges();const p={added:l,removed:c,updated:u,thresholdSurpassed:m};if(s.isFiltered&&!s.remoteFilter&&s.filter({silent:s.isRemoteDataLoading}),s.isGrouped)s.group(null,null,!1,!0,s.isRemoteDataLoading);else if(s.isSorted)s.remoteSort?o.replaceValues({values:o.values.sort(s.createSorterFn(s.sorters)),silent:!0}):s.sort();else if(s.reorderOnSync)if(s.tree){let e=!1,t=0;yo.preWalk(s.rootNode,(t=>Array.isArray(t.children)&&!e?t.children:null),(n=>{n.id!==h[t++]&&(e=!0)})),e&&(s.sort(((e,t)=>h[e.id]-h[t.id]),void 0,void 0,!0),s.clearSorters(!0),!m&&s.afterPerformSort())}else o.values.some(((e,t)=>h[e.id]!==t))&&(o.replaceValues({values:o.values.sort(((e,t)=>h[e.id]-h[t.id])),silent:!0}),!m&&s.afterPerformSort());m&&s.trigger("refresh",{action:"batch",data:e,records:o.values,syncInfo:p}),s.isSyncingDataOnLoad=!1,s.trigger("endApplyChangeset"),s.trigger("loadSync",p)}syncFlatDataset(e,t){if(!e)return{toRemove:this.records};const n=this,{idField:i,allFields:r}=n.modelClass,s=[],o=[],a=[],l={},c={},d=t instanceof Set,{threshold:u,keepMissingValues:h}=n.syncDataOnLoad;let g=0;if(e.forEach(((e,s)=>{const m=(e=e.isModel?e.data:e)[i],p=n.getById(m);if(!d||t.has(m))if(p){if(n.shouldSyncRecord?!1!==n.shouldSyncRecord({record:p,data:e,store:n}):e!==p.data){var f,v;if(null===(f=n.beforeSyncRecord)||void 0===f||f.call(n,{record:p,data:e}),!1===h)for(const t of r)!(t.dataSource in e)&&t.dataSource in p.data&&(e[t.dataSource]=t.defaultValue);const t=p.set(e,null,Boolean(u));t&&a.push({record:p,wasSet:t,toSet:e}),null===(v=n.afterSyncRecord)||void 0===v||v.call(n,{record:p,data:e})}}else o.push(n.processRecord(n.createRecord(e)));p&&g++,l[m]=1,c[m]=s})),g<n.allRecords.filter((e=>!e.isSpecialRow)).length)if(t)for(const e of t)l[e]||s.push(n.getById(e));else n.forEach((e=>{l[e.id]||s.push(e)}),n,{includeFilteredOutRecords:!0,includeCollapsedGroupRecords:!0});return{toAdd:o,toRemove:s,toMove:[],updated:a,ids:c}}syncTreeDataset(e){if(!e)return{toRemove:this.records};const t=this,{idField:n,parentIdField:i,childrenField:r,allFields:s}=t.modelClass,{keepMissingValues:o,threshold:a}=t.syncDataOnLoad??{},l=[],c=[],d=[],u=[],h=new Set,g={};let m=0;return t.transformFlatData&&(e=t.treeifyFlatData(e)),yo.preWalkWithParent({isRoot:!0,id:t.rootNode.id,children:e},(e=>e.children),((e,l)=>{if(e){const{id:p,node:f}=t.resolveSyncNode(l);if(f){if(t.shouldSyncRecord?!1!==t.shouldSyncRecord({record:f,data:l,store:t}):l!==f.data){let i;const c=f.children;let h;if(f.parent.id!==e[n]&&d.push({node:f,parent:e,index:e[r].indexOf(l)}),f!==l){if(!0!==c&&!0===l[r]&&(f.clearChildren(),f.data[r]=f.children=!0,delete l[r],t.toggleCollapse(f,!0),i=!0),!1===o)for(const e of s)"parentId"!==e.name&&!(e.dataSource in l)&&e.dataSource in f.data&&(l[e.dataSource]=e.defaultValue);"boolean"==typeof l.expanded&&this.toggleCollapse(f,!l.expanded),h=f.set(l,null,Boolean(a))}h?u.push({record:f,wasSet:h,toSet:l}):i&&f.signalNodeChanged({[r]:{value:!0,oldValue:c}})}h.add(f)}else l[i]=e[n],l.isModel?c.push(l):c.push({...l,...Array.isArray(l[r])?{children:[]}:void 0});g[p]=m++}})),t.totalCount!==h.size&&t.traverse((e=>{h.has(e)||l.push(e)})),{toAdd:c,toRemove:l,toMove:d,updated:u,ids:g}}resolveSyncNode(e){const t=e[this.modelClass.idField];return{id:t,node:this.getById(t)}}};class xo extends Error{constructor(...e){super(...e),this.name="RevisionException"}}xo._$name="RevisionException";const To=()=>{throw new Error("Abstract method call!")},Mo=()=>{throw new Error("Method cannot be called at this state!")};class Io extends Pe{canUndo(e){To()}canRedo(e){To()}canCheckoutTo(e){To()}onUndo(e){To()}onRedo(e){To()}onCheckoutTo(e){To()}onCheckoutToHead(e){To()}onStartRevision(e,t){To()}onStopRevision(e){To()}onStartTransaction(e){To()}onStopTransaction(e){To()}onStopTransactionDelayed(e){To()}onRejectTransaction(e){To()}onEnable(e){To()}onDisable(e){To()}onAutoRecordOn(e){To()}onAutoRecordOff(e){To()}onResetQueue(e){To()}onModelUpdate(e){To()}onStoreModelAdd(e){To()}onStoreModelInsert(e){To()}onStoreModelRemove(e){To()}onStoreModelRemoveAll(e){To()}onModelInsertChild(e){To()}onModelRemoveChild(e){To()}}Io._$name="StateBase";const Ao=Symbol("STATE_PROP"),ko=Symbol("STORES_PROP"),Fo=Symbol("QUEUE_PROP"),Po=Symbol("POS_PROP"),Oo=Symbol("ACTION_QUEUE_PROP"),Lo=Symbol("REVISION_NAMES_PROP"),$o=Symbol("REVISION_QUEUE_PROP"),_o=Symbol("REVISION_INDEX_PROP"),jo=Symbol("CURRENT_REV_ID_PROP"),Bo=Symbol("TRANSACTION_PROP"),Ho=Symbol("TRANSACTION_TIMER_PROP"),Vo=Symbol("AUTO_RECORD_PROP"),zo=Symbol("IS_APPLYING_STASH");Object.freeze([Ao,ko,Fo,Po,Oo,Lo,$o,_o,jo,Bo,Ho,Vo,zo]);const No=new Map;var Wo=(e,t)=>{No.set(e,t)},Uo=e=>("string"==typeof e&&(e=No.get(e)),e);const Go=(e,t)=>{const{undo:n,redo:i,revision:r}=t;let s;return s=n&&!i?{[Fo]:e[Fo].slice(e.position),[Po]:0}:i&&!n?{[Fo]:e[Fo].slice(0,e.position)}:{[Fo]:[],[Po]:0},r&&(s=Object.assign(s??{},{[Lo]:[],[_o]:-1,[$o]:[]})),[s,()=>{e.notifyStoresAboutQueueReset(t)}]};const Yo=new class extends Io{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){Mo()}onRedo(){Mo()}onEnable(e){return e.autoRecord?"autoreadystate":"readystate"}onDisable(){Mo()}onAutoRecordOn(){return{[Vo]:!0}}onAutoRecordOff(){return{[Vo]:!1}}onStartTransaction(){Mo()}onStopTransaction(){Mo()}onStopTransactionDelayed(){Mo()}onRejectTransaction(){Mo()}onResetQueue(e,t){return Go(e,t)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};Wo("disabledstate",Yo);class qo extends Pe{static get defaultConfig(){return{inversed:!1}}get type(){return this.constructor.name}undo(){To()}redo(){To()}invert(){const e=new this.constructor({...this.initialConfig,isUserInput:this.isUserInput,inversed:!0}),{undo:t,redo:n}=e;return e.undo=n,e.redo=t,e}}const Ko="AddAction",Xo="InsertAction",Zo="InsertChildAction",Jo="RemoveAction",Qo="RemoveAllAction",ea="RemoveChildAction",ta="UpdateAction",na="EventUpdateAction";qo._$name="ActionBase";const ia=Symbol("MODEL_PROP"),ra=Symbol("NEW_DATA_PROP"),sa=Symbol("OLD_DATA_PROP");class oa extends qo{static $name="UpdateAction";static get defaultConfig(){return{model:void 0,newData:void 0,oldData:void 0,isInitialUserAction:!1}}get type(){return ta}get model(){return this[ia]}set model(e){this[ia]=e}get newData(){return this[ra]}set newData(e){this[ra]={...e}}get oldData(){return this[sa]}set oldData(e){this[sa]={...e}}undo(){const{model:e,oldData:t}=this;e.$&&Object.assign(e,t),e.set(t,null,null,null,Boolean(e.$))}redo(){const{model:e,newData:t}=this;e.$&&Object.assign(e,t),e.set(t,null,null,null,Boolean(e.$))}}oa._$name="UpdateAction";const aa=Symbol("PARENT_MODEL_PROP"),la=Symbol("CHILD_MODELS_PROP"),ca=Symbol("INSERT_INDEX_PROP"),da=Symbol("ORDERED_PROP"),ua=Symbol("CONTEXT_PROP");class ha extends qo{static $name="InsertChildAction";static get defaultConfig(){return{parentModel:void 0,childModels:void 0,insertIndex:void 0,orderedBeforeNode:void 0,context:void 0,stores:void 0}}get type(){return Zo}get parentModel(){return this[aa]}set parentModel(e){this[aa]=e}get childModels(){return this[la]}set childModels(e){this[la]=e.slice(0)}get insertIndex(){return this[ca]}set insertIndex(e){this[ca]=e}get orderedBeforeNode(){return this[da]}set orderedBeforeNode(e){this[da]=e}get context(){return this[ua]}set context(e){this[ua]=e}get stores(){return this[ko]}set stores(e){this[ko]=e}undo(){const{parentModel:e,context:t,childModels:n}=this,i=new Map,r=new Set;for(const s of n){const n=t.get(s);if(n){let t=i.get(n.parent);t||(t={moveRight:[],moveLeft:[],moveFromAnotherParent:[]},i.set(n.parent,t)),n.parent===e?n.index>s.parentIndex?t.moveRight.push({parent:n.parent,model:s,index:n.index+1}):t.moveLeft.push({parent:n.parent,model:s,index:n.index}):t.moveFromAnotherParent.push({parent:n.parent,model:s,index:n.index})}else r.add(s)}r.forEach((e=>e.parent.removeChild(e)));for(const e of i.values()){const{moveRight:t,moveLeft:n,moveFromAnotherParent:i}=e;i.forEach((e=>{e.parent.insertChild(e.model,e.index)})),n.sort(((e,t)=>e.index-t.index)),t.sort(((e,t)=>t.index-e.index))}for(const e of i.values()){const{moveRight:t,moveLeft:n}=e;n.forEach((e=>{e.parent.insertChild(e.model,e.index)})),t.forEach((e=>{e.parent.insertChild(e.model,e.index)}))}}redo(){var e,t;const{parentModel:n,insertIndex:i,childModels:r,orderedBeforeNode:s}=this,o=null===(e=n.children)||void 0===e?void 0:e[i];n.insertChild(r,o,!1,{orderedBeforeNode:s??(null==o||null===(t=o.previousSibling)||void 0===t?void 0:t.nextOrderedSibling)})}}ha._$name="InsertChildAction";const ga=Symbol("PARENT_MODEL_PROP"),ma=Symbol("CHILD_MODELS_PROP"),pa=Symbol("CONTEXT_PROP");class fa extends qo{static $name="RemoveChildAction";static get defaultConfig(){return{parentModel:void 0,childModels:void 0,context:void 0,stores:void 0}}get type(){return ea}get parentModel(){return this[ga]}set parentModel(e){this[ga]=e}get childModels(){return this[ma]}set childModels(e){this[ma]=e.slice(0)}get context(){return this[pa]}set context(e){this[pa]=e}get stores(){return this[ko]}set stores(e){this[ko]=e}undo(){const{parentModel:e,context:t,childModels:n}=this;n.sort(((e,n)=>t.get(e).parentIndex-t.get(n).parentIndex)),n.forEach((n=>{const i=t.get(n);e.insertChild(n,i.parentIndex,void 0,{orderedParentIndex:i.orderedParentIndex})}))}redo(){this.parentModel.removeChild(this.childModels)}}fa._$name="RemoveChildAction";const va=Symbol("STORE_PROP"),ya=Symbol("MODEL_LIST_PROP");class ba extends qo{static $name="AddAction";static get defaultConfig(){return{store:void 0,modelList:void 0,silent:!1}}get type(){return Ko}get store(){return this[va]}set store(e){this[va]=e}get modelList(){return this[ya]}set modelList(e){this[ya]=e.slice(0)}undo(){this.store.remove(this.modelList,this.silent)}redo(){this.store.add(this.modelList,this.silent)}}ba._$name="AddAction";const Ca=Symbol("STORE_PROP"),Sa=Symbol("MODEL_LIST_PROP"),Da=Symbol("INSERT_INDEX_PROP"),wa=Symbol("CONTEXT_PROP");class Ea extends qo{static $name="InsertAction";static get defaultConfig(){return{store:void 0,modelList:void 0,insertIndex:void 0,context:void 0,silent:!1,reportUndoneRemoval:!0}}get type(){return Xo}get store(){return this[Ca]}set store(e){this[Ca]=e}get modelList(){return this[Sa]}set modelList(e){this[Sa]=e.slice(0)}get insertIndex(){return this[Da]}set insertIndex(e){this[Da]=e}get context(){return this[wa]}set context(e){this[wa]=e}undo(){const{store:e,modelList:t,context:n,silent:i,reportUndoneRemoval:r}=this;t.sort(((e,t)=>{const i=n.get(e),r=n.get(t);return void 0!==i&&void 0!==r?i-r:0})),t.forEach((t=>{const s=n.get(t);t._undoingInsertion=r,void 0!==s?e.insert(s,t,i):e.remove(t,i),t._undoingInsertion=!1}))}redo(){const e=this;e.store.insert(e.insertIndex,e.modelList,e.silent)}}Ea._$name="InsertAction";const Ra=Symbol("STORE_PROP"),xa=Symbol("MODEL_LIST_PROP"),Ta=Symbol("CONTEXT_PROP");class Ma extends qo{static $name="RemoveAction";static get defaultConfig(){return{store:void 0,modelList:void 0,context:void 0,silent:!1}}get type(){return Jo}get store(){return this[Ra]}set store(e){this[Ra]=e}get modelList(){return this[xa]}set modelList(e){this[xa]=e.slice(0)}get context(){return this[Ta]}set context(e){this[Ta]=e}undo(){const{store:e,context:t,modelList:n,silent:i}=this;n.sort(((e,n)=>t.get(e)-t.get(n))),n.forEach((n=>{const r=t.get(n);e.insert(r,n,i)}))}redo(){this.store.remove(this.modelList,this.silent)}}Ma._$name="RemoveAction";const Ia=Symbol("STORE_PROP"),Aa=Symbol("ALL_RECORDS_PROP");class ka extends qo{static $name="RemoveAllAction";static get defaultConfig(){return{store:void 0,allRecords:void 0,silent:!1}}get type(){return Qo}get store(){return this[Ia]}set store(e){this[Ia]=e}get allRecords(){return this[Aa]}set allRecords(e){this[Aa]=e.slice(0)}undo(){const{store:e,allRecords:t,silent:n}=this;e.add(t,n)}redo(){this.store.removeAll(this.silent)}}ka._$name="RemoveAllAction";const Fa=(e,t,n,i)=>new oa({model:e,newData:t,oldData:n,isInitialUserAction:i}),Pa=(e,t,n,i,r,s)=>new ha({parentModel:e,childModels:n,insertIndex:t,orderedBeforeNode:r,context:i,stores:s}),Oa=(e,t,n,i)=>new fa({parentModel:e,childModels:t,context:n,stores:i}),La=(e,t,n)=>new ba({store:e,modelList:t,silent:n}),$a=(e,t,n,i,r)=>new Ea({store:e,insertIndex:t,modelList:n,context:i,silent:r}),_a=(e,t,n,i)=>new Ma({store:e,modelList:t,context:n,silent:i}),ja=(e,t,n)=>new ka({store:e,allRecords:t,silent:n}),Ba="DATA_CORRECTION",Ha="TEMPORARY",Va="CONFLICT_RESOLUTION";class za extends Pe{static get configurable(){return{title:null,committed:!1,inputGeneration:0}}static from(e,t={}){const n=new this({...this.initialConfig,...t,inputGeneration:e.reduce(((e,t)=>Math.max(e,t.inputGeneration??0)),0),committed:!1});return n[Oo]=e.flatMap((e=>e[Oo].filter((n=>e.inputGeneration>0?t.conflictResolutionFor?n.isUserInput===e.inputGeneration:n.isUserInput:n)))),n}static createTransactionWithOriginalInput(e){const t=new this({...this.initialConfig,title:e.title,committed:!1});return t[Oo]=e[Oo].filter((e=>e.isUserInput?1===e.isUserInput:!e.isUserInput)),t}construct(...e){this[Oo]=[],super.construct(...e)}get queue(){return this[Oo].slice(0)}get length(){return this[Oo].length}get filterUserInput(){return this.inputGeneration>0}addAction(e){this[Oo].push(e)}undo(){const e=this[Oo];for(let t=e.length-1;t>=0;--t)e[t].undo()}redo(){const e=this[Oo];for(let t=0,n=e.length;t<n;++t)e[t].redo()}mergeUpdateModelActions(){const e=this[Oo],t=new Map,n=[];for(const s of e){var i;if(s.isUpdateAction&&null!==(i=s.model)&&void 0!==i&&i.isModel){const e=s.isUserInput??0;let i=t.get(s.model);i||(i=[],t.set(s.model,i));const r=i[e];if(r)for(const e in s.oldData)s.newData.hasOwnProperty(e)&&(r.oldData.hasOwnProperty(e)||(r.oldData[e]=s.oldData[e]),r.newData[e]=s.newData[e]);else i[e]=s,n.push(s)}else{var r;if(n.push(s),s.isRemoveAction&&null!==(r=s.modelList)&&void 0!==r&&r.length)for(const e of s.modelList)t.delete(e)}}this[Oo]=n,this.inputGeneration=Math.max(...n.map((e=>e.isUserInput??0)),0)}mergeAddUpdateModelActions(){const e=this[Oo],t=new Set,n=[];for(const i of e)i.isAddAction||i.isInsertAction?i.modelList.forEach((e=>t.add(e))):i.isInsertChildAction&&i.childModels.forEach((e=>t.add(e))),(i.isUpdateAction||i.isEventUpdateAction)&&t.has(i.model)||n.push(i);this[Oo]=n,this.inputGeneration=Math.max(...n.map((e=>e.isUserInput??0)),0)}invert(){const e=new this.constructor({...this.initialConfig,title:this.title});return e[Oo]=this[Oo].map((e=>(e=>e.invert())(e))),e}groupUserInput(){return this[Oo].reduce(((e,t)=>{const n=t.isUserInput??"default";return e.has(n)||e.set(n,[]),e.get(n).push(t),e}),new Map)}getUserInput(e){const t=new Map,n={},i=this.groupUserInput().get(e??(this.inputGeneration||"default")),r=(e,t)=>(t in n?e in n[t]||(n[t][e]=[]):n[t]={[e]:[]},n[t][e]);for(const e of i)switch(e.type){case Ko:case Xo:if(e.inversed){r("removed",e.store.id).push(...e.modelList)}else{r("added",e.store.id).push(...e.modelList)}break;case Jo:case Qo:if(e.inversed){r("added",e.store.id).push(...e.modelList||e.allRecords)}else{r("removed",e.store.id).push(...e.modelList||e.allRecords)}break;case Zo:for(const n of e.stores)e.childModels.forEach((e=>{if(n.added.includes(e))r("added",n.id).push(e);else if(n.removed.includes(e))r("removed",n.id).push(e);else{const n=e.hierarchyModificationDataToWrite;n&&(t.has(e)?t.set(e,{...t.get(e),...n}):t.set(e,n))}}));break;case ea:for(const t of e.stores)if(e.inversed){r("added",t.id).push(...e.childModels)}else{r("removed",t.id).push(...e.childModels)}break;case ta:case na:t.has(e.model)?t.set(e.model,{...t.get(e.model),...e.newData}):t.set(e.model,{...e.newData})}if(t.size>0&&(n.updated=t),Object.keys(n).length>0)return n}markCurrentTransactionContentUserInput(){const e=this.inputGeneration+1,t=this[Oo];let n=!1;t.forEach((t=>{void 0!==t.isUserInput||t.isCalculated||(t.isUserInput=e,n=!0)})),n&&(this.inputGeneration=e)}markCurrentTransactionContentCalculated(){const e=this.inputGeneration;this[Oo].forEach((t=>{void 0!==t.isCalculated||t.isUserInput||(t.isCalculated=e)}))}normalizeUserInputGeneration(){this[Oo].forEach((e=>e.isUserInput=this.inputGeneration))}}za._$name="Transaction";class Na extends Io{canUndo(e){return 0<e.position&&e.position<=e.length}canRedo(e){return 0<=e.position&&e.position<e.length}canCheckoutTo(e,t){return e.revisionsEnabled?!!e[Lo].includes(t)||(console.warn("Revision is not found"),!1):(console.warn("Revisions are disabled"),!1)}onUndo(e,t){let n=e.position;const i=e[Fo],r=Math.max(0,n-t);return[{[Ao]:"restoringstate",[Po]:r},()=>{e.notifyStoresAboutStateRestoringStart();const t=[];for(;n!==r;){const e=i[--n];e.undo(),t.push(e)}return[e.autoRecord?"autoreadystate":"readystate",()=>{e.notifyStoresAboutStateRestoringStop({cause:"undo",transactions:t})}]}]}onRedo(e,t){let n=e.position;const i=e[Fo],r=Math.min(i.length,n+t);return[{[Ao]:"restoringstate",[Po]:r},()=>{e.notifyStoresAboutStateRestoringStart();const t=[];do{const e=i[n++];e.redo(),t.push(e)}while(n!==r);return[e.autoRecord?"autoreadystate":"readystate",()=>{e.notifyStoresAboutStateRestoringStop({cause:"redo",transactions:t})}]}]}onCheckoutTo(e,t){const n=e[Lo].indexOf(t),i=Math.min(n,e[_o]),r=Math.max(n,e[_o]),s=n<e[_o];let o=e[$o].slice(i,r);if(s){o=o.filter((e=>!e.conflictResolutionFor||e.type===Ha)).reverse();e[$o].filter(((e,t)=>t>=i&&e.dummy)).forEach((t=>{e[$o].splice(e[$o].indexOf(t),1),e[Lo].splice(e[Lo].indexOf(t.title),1)}))}return[{[Ao]:"checkoutstate",[_o]:n},()=>{e.notifyStoresAboutCheckoutStart();for(const e of o)e[s?"undo":"redo"]()}]}onCheckoutToHead(e){Mo()}onEnable(){Mo()}onDisable(){return"disabledstate"}onAutoRecordOn(){return{[Ao]:"autoreadystate",[Vo]:!0}}onAutoRecordOff(){Mo()}onStartTransaction(e,t){const n=new za({title:t});return[{[Ao]:"recordingstate",[Bo]:n},()=>{e.notifyStoresAboutStateRecordingStart(n)}]}onStopTransaction(){Mo()}onStopTransactionDelayed(){Mo()}onRejectTransaction(){Mo()}onResetQueue(e,t){return Go(e,t)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}}const Wa=new Na;Wo("readystate",Wa);class Ua extends Io{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onEnable(){}onDisable(e){const t=e[Bo];return e.notifyStoresAboutStateRecordingStop(t,{disabled:!0}),{[Ao]:"disabledstate",[Bo]:null}}onAutoRecordOn(e){return[{[Ao]:"autorecordingstate",[Vo]:!0},()=>{e.stopTransactionDelayed()}]}onAutoRecordOff(){Mo()}onStartTransaction(){Mo()}onStopTransaction(e,t){const n=e[Bo],i=e[Fo];let r=e[Po];return n.length&&(n.title||t||!e.getTransactionTitle?t&&(n.title=t):n.title=e.getTransactionTitle(n),i[r]=n,i.length=++r),[{[Ao]:"readystate",[Po]:r,[Bo]:null},()=>{e.notifyStoresAboutStateRecordingStop(n,{stop:!0})}]}onRejectTransaction(e){const t=e[Bo];return[{[Ao]:"restoringstate",[Bo]:null},()=>(t.length&&t.undo(),["readystate",()=>{e.notifyStoresAboutStateRecordingStop(t,{rejected:!0})}])]}onStopTransactionDelayed(){Mo()}onResetQueue(e,t){return Go(e,t)}onModelUpdate(e,t,n,i,r){e[Bo].addAction(e.makeModelUpdateAction(t,n,i,r))}onModelInsertChild(e,t,n,i,r,s){const o=e[Bo],a=t.stores.filter((t=>e.stores.includes(t)));o.addAction(e.makeModelInsertChildAction(t,n,i,r,s,a))}onModelRemoveChild(e,t,n,i){const r=e[Bo],s=t.stores.filter((t=>e.stores.includes(t)));r.addAction(e.makeModelRemoveChildAction(t,n,i,s))}onStoreModelAdd(e,t,n,i){e[Bo].addAction(e.makeStoreModelAddAction(t,n,i))}onStoreModelInsert(e,t,n,i,r,s){const o=e[Bo],a=e.makeStoreModelInsertAction(t,n,i,r,s);a.reportUndoneRemoval=!e.revisionsEnabled,o.addAction(a)}onStoreModelRemove(e,t,n,i,r){e[Bo].addAction(e.makeStoreModelRemoveAction(t,n,i,r))}onStoreRemoveAll(e,t,n,i){e[Bo].addAction(e.makeStoreRemoveAllAction(t,n,i))}}const Ga=new Ua;Wo("recordingstate",Ga);const Ya=new class extends Io{static $name="RestoringStateClass";canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){Mo()}onRedo(){Mo()}onEnable(){Mo()}onDisable(){Mo()}onAutoRecordOn(){return{[Vo]:!0}}onAutoRecordOff(){return{[Vo]:!1}}onStartTransaction(){Mo()}onStopTransaction(){Mo()}onStopTransactionDelayed(){Mo()}onRejectTransaction(){Mo()}onQueueReset(){Mo()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};Wo("restoringstate",Ya);const qa=new class extends Na{onAutoRecordOn(){Mo()}onAutoRecordOff(){return{[Ao]:"readystate",[Vo]:!1}}onStartTransaction(e,t){const n=new za({title:t});return[{[Ao]:"autorecordingstate",[Bo]:n},()=>{e.notifyStoresAboutStateRecordingStart(n),e.stopTransactionDelayed()}]}onModelUpdate(e,t,n,i){e.startTransaction(),e.onModelUpdate(t,n,i)}onModelInsertChild(e,t,n,i,r){e.startTransaction(),e.onModelInsertChild(t,n,i,r)}onModelRemoveChild(e,t,n,i){e.startTransaction(),e.onModelRemoveChild(t,n,i)}onStoreModelAdd(e,t,n,i){e.startTransaction(),e.onStoreModelAdd(t,n,i)}onStoreModelInsert(e,t,n,i,r,s){e.startTransaction(),e.onStoreModelInsert(t,n,i,r,s)}onStoreModelRemove(e,t,n,i,r){e.startTransaction(),e.onStoreModelRemove(t,n,i,r)}onStoreRemoveAll(e,t,n,i){e.startTransaction(),e.onStoreRemoveAll(t,n,i)}};Wo("autoreadystate",qa);class Ka extends(Ua.mixin(Ir)){onDisable(e){const t=e[Bo],n=e[Ho];return n&&this.clearTimeout(n),e.notifyStoresAboutStateRecordingStop(t,{disabled:!0}),{[Ao]:"disabledstate",[Bo]:null,[Ho]:null}}onAutoRecordOn(e){Mo()}onAutoRecordOff(e){const t=e[Ho];return t&&this.clearTimeout(t),{[Ao]:"recordingstate",[Vo]:!1,[Ho]:null}}onStopTransaction(e,t){const n=e[Bo],i=e[Ho],r=e[Fo];let s=e[Po];return i&&this.clearTimeout(i),n.length&&(n.title||t||!e.getTransactionTitle?t&&(n.title=t):n.title=e.getTransactionTitle(n),r[s]=n,r.length=++s),[{[Ao]:"autoreadystate",[Po]:s,[Bo]:null,[Ho]:null},()=>{e.notifyStoresAboutStateRecordingStop(n,{stop:!0})}]}onStopTransactionDelayed(e){let t=e[Ho];return t&&this.clearTimeout(t),t=this.setTimeout((()=>{e.stopTransaction()}),e.autoRecordTransactionStopTimeout),{[Ao]:Xa,[Ho]:t}}onResetQueue(e,t){return Go(e,t)}onRejectTransaction(e){const t=e[Bo],n=e[Ho];return n&&this.clearTimeout(n),[{[Ao]:"restoringstate",[Bo]:null,[Ho]:null},()=>(t.length&&t.undo(),["autoreadystate",()=>{e.notifyStoresAboutStateRecordingStop(t,{rejected:!0})}])]}onModelUpdate(e,...t){super.onModelUpdate(e,...t),e.stopTransactionDelayed()}onModelInsertChild(e,...t){super.onModelInsertChild(e,...t),e.stopTransactionDelayed()}onModelRemoveChild(e,...t){super.onModelRemoveChild(e,...t),e.stopTransactionDelayed()}onStoreModelAdd(e,...t){super.onStoreModelAdd(e,...t),e.stopTransactionDelayed()}onStoreModelInsert(e,...t){super.onStoreModelInsert(e,...t),e.stopTransactionDelayed()}onStoreModelRemove(e,...t){super.onStoreModelRemove(e,...t),e.stopTransactionDelayed()}onStoreRemoveAll(e,...t){super.onStoreRemoveAll(e,...t),e.stopTransactionDelayed()}}const Xa=new Ka;Wo("autorecordingstate",Xa);const Za=new class extends Na{canUndo(e){return!1}canRedo(e){return!1}onUndo(e){Mo()}onRedo(e){Mo()}onStartRevision(e,t){const n=new za({title:t});return[{[Ao]:"revisionrecordingstate",[Bo]:n},()=>{e.notifyStoresAboutRevRecordingStart()}]}onStartTemporaryRevision(e,t,n){const i=new za({title:t});return n&&(i[Oo]=n[Oo].slice()),[{[Ao]:"temporaryrevisionrecordingstate",[Bo]:i},()=>{e.notifyStoresAboutTempRevRecordingStart()}]}onCheckoutToHead(e){return e.notifyStoresAboutCheckoutToHead({revision:e[Lo][e[Lo].length-1]}),e.autoRecord?"autoreadystate":"readystate"}onStartTransaction(e){Mo()}onStopTransaction(e){Mo()}onStopTransactionDelayed(e){Mo()}onRejectTransaction(e){Mo()}onEnable(e){Mo()}onDisable(e){Mo()}onAutoRecordOn(e){Mo()}onAutoRecordOff(e){Mo()}onResetQueue(e){Mo()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};Wo("checkoutstate",Za);const Ja=new class extends Ua{canUndo(e){return!1}canRedo(e){return!1}canCheckoutTo(){return!1}onUndo(e){Mo()}onRedo(e){Mo()}onCheckoutToHead(e){Mo()}onStopRevision(e,t){const n=e[Bo],i=e[$o],r=e[Lo],s=e[_o]+1,o=za.createTransactionWithOriginalInput(n);return r.splice(s,0,o.title),i.splice(s-1,0,o),e.commitRevision(o.title),[{[Ao]:"checkoutstate",[_o]:s,[Bo]:null},()=>{e.notifyStoresAboutRevRecordingStop(o)}]}onStartTransaction(e){Mo()}onStopTransaction(e){Mo()}onStopTransactionDelayed(e){Mo()}onRejectTransaction(e){Mo()}onEnable(e){Mo()}onDisable(e){Mo()}onAutoRecordOn(e){Mo()}onAutoRecordOff(e){Mo()}onResetQueue(e){Mo()}};Wo("revisionrecordingstate",Ja);const Qa=new class extends Ua{canUndo(e){return!1}canRedo(e){return!1}canCheckoutTo(){return!1}onUndo(e){Mo()}onRedo(e){Mo()}onCheckoutToHead(e){Mo()}onStopRevision(e,t){const n=e[Bo];return[{[Ao]:"checkoutstate",[Bo]:null},()=>{e.notifyStoresAboutTempRevRecordingStop(n)}]}onStartTransaction(e){Mo()}onStopTransaction(e){Mo()}onStopTransactionDelayed(e){Mo()}onRejectTransaction(e){Mo()}onEnable(e){Mo()}onDisable(e){Mo()}onAutoRecordOn(e){Mo()}onAutoRecordOff(e){Mo()}onResetQueue(e){Mo()}};Wo("temporaryrevisionrecordingstate",Qa);const el=(e,t,...n)=>{const i=e.state,r=t.call(e[Ao],e,...n);if("string"==typeof r)e[Ao]=Uo(r);else if(r instanceof Io)e[Ao]=r;else if(Array.isArray(r)){const[t,i]=r;"string"==typeof t?e[Ao]=Uo(t):t instanceof Io?e[Ao]=t:t&&"object"==typeof t&&((e=Object.assign(e,t))[Ao]=Uo(e[Ao])),"function"==typeof i&&el(e,i,...n)}else r&&"object"==typeof r&&((e=Object.assign(e,r))[Ao]=Uo(e[Ao]));i!==Wa&&i!==qa&&r!==Wa&&r!==qa&&e.trigger("ready")};class tl extends(at(Pe)){static $name="StateTrackingManager";static get defaultConfig(){return{disabled:!0,autoRecord:!1,autoRecordTransactionStopTimeout:100,autoRecordMergeUpdateActions:!0,mergeAddUpdateActions:!1,makeModelUpdateAction:Fa,makeModelInsertChildAction:Pa,makeModelRemoveChildAction:Oa,makeStoreModelAddAction:La,makeStoreModelInsertAction:$a,makeStoreModelRemoveAction:_a,makeStoreRemoveAllAction:ja,getTransactionTitle:null,revisionsEnabled:!1,asyncUndoRedo:!1,revisionLocalPrefix:"local-",revisionQueueMaxLength:20,revisionQueueCommittedMinLength:1}}construct(...e){Object.assign(this,{[Ao]:Wa,[ko]:[],[Fo]:[],[Po]:0,[Bo]:null,[Ho]:null,[Vo]:!1,[zo]:!1,stashedTransactions:{}}),super.construct(...e)}get state(){return this[Ao]}get position(){return this[Po]}get length(){return this[Fo].length}get stores(){return Array.from(this[ko])}hasStore(e){return this[ko].includes(e)}addStore(e){this.hasStore(e)||(this[ko].push(e),e.stm=this,e.forEach((e=>e.stm=this)),e.isTree&&(e.rootNode.stm=this))}removeStore(e){this.hasStore(e)&&(this[ko]=this[ko].filter((t=>t!==e)),e.stm=null,e.forEach((e=>e.stm=null)))}forEachStore(e){this[ko].forEach((t=>e(t,t.id)))}get disabled(){return this.state===Yo}set disabled(e){const t=this;t.disabled!==e&&(el(t,e?t.state.onDisable:t.state.onEnable,t),t.trigger("stmDisabled",{disabled:e}),t.trigger("disabled",{disabled:e}))}get enabled(){return!this.disabled}enable(){this.disabled=!1}disable(){this.disabled=!0}get isReady(){return this.state===Wa||this.state===qa}waitForReadiness(){return this.await("ready",!1)}get isRecording(){return this.state===Ga||this.state===Xa}get isApplyingStash(){return this[zo]}get shouldRecordAction(){return this.enabled&&(!this.isRestoringState||this.isApplyingStash)&&!this.isCheckingOut}get autoRecord(){return this[Vo]}set autoRecord(e){const t=this;t.autoRecord!=e&&el(t,e?t.state.onAutoRecordOn:t.state.onAutoRecordOff,t)}startTransaction(e=null){el(this,this.state.onStartTransaction,e)}stopTransaction(e=null){const t=this;t.autoRecord&&t.autoRecordMergeUpdateActions&&t.mergeTransactionUpdateActions(),t.mergeAddUpdateActions&&t.mergeTransactionAddUpdateActions(),el(t,t.state.onStopTransaction,e)}stopTransactionDelayed(){el(this,this.state.onStopTransactionDelayed)}rejectTransaction(){el(this,this.state.onRejectTransaction)}get transaction(){return this[Bo]}get queue(){return this[Fo].map((e=>e.title))}get rawQueue(){return this[Fo]}get isRestoringState(){return this.state===Ya}get isRestoring(){return this.state===Ya||this.isApplyingStash||this.isNavigatingRevisions}get canUndo(){return this.state.canUndo(this)}get canRedo(){return this.state.canRedo(this)}async undo(e=1){this.isReady||await this.waitForReadiness(),el(this,this.state.onUndo,e)}async undoAll(){this.isReady||await this.waitForReadiness(),this.undo(this.length)}async redo(e=1){this.isReady||await this.waitForReadiness(),el(this,this.state.onRedo,e)}async redoAll(){this.isReady||await this.waitForReadiness(),this.redo(this.length)}resetQueue(e={undo:!0,redo:!0,revision:!0}){el(this,this.state.onResetQueue,e)}resetUndoQueue(){this.resetQueue({undo:!0})}resetRedoQueue(){this.resetQueue({redo:!0})}resetRevisionQueue(){this.resetQueue({revision:!0})}notifyStoresAboutStateRecordingStart(e){this.forEachStore((t=>{var n;return null===(n=t.onStmRecordingStart)||void 0===n?void 0:n.call(t,this,e)})),this.trigger("recordingStart",{stm:this,transaction:e})}notifyStoresAboutStateRecordingStop(e,t){const n=this;n.forEachStore((i=>{var r;return null===(r=i.onStmRecordingStop)||void 0===r?void 0:r.call(i,n,e,t)})),n.trigger("recordingStop",{stm:n,transaction:e,reason:t}),n.revisionsEnabled&&t.stop&&n.increaseRevision(za.from([e]))}notifyStoresAboutStateRestoringStart(){this.forEachStore((e=>{var t;return null===(t=e.onStmRestoringStart)||void 0===t?void 0:t.call(e,this)})),this.trigger("restoringStart",{stm:this})}notifyStoresAboutStateRestoringStop({cause:e,transactions:t}){const n=this;if(n.forEachStore((e=>{var t;return null===(t=e.onStmRestoringStop)||void 0===t?void 0:t.call(e,n)})),n.trigger("restoringStop",{stm:n,cause:e,transactions:t}),n.revisionsEnabled)if(n.asyncUndoRedo){const i=()=>{const i=za.from(t);n.increaseRevision("undo"===e?i.invert():i)};n.trigger("increaseRevisionAsync",{callback:i})}else{const i=za.from(t);n.increaseRevision("undo"===e?i.invert():i)}}notifyStoresAboutQueueReset(e){this.forEachStore((t=>{var n;return null===(n=t.onStmQueueReset)||void 0===n?void 0:n.call(t,this,e)})),this.trigger("queueReset",{stm:this,options:e})}notifyStoresAboutCheckoutStart(){this.trigger("checkoutStart",{stm:this})}notifyStoresAboutRevRecordingStart(){this.trigger("revisionRecordingStart",{stm:this})}notifyStoresAboutTempRevRecordingStart(){this.trigger("temporaryRevisionRecordingStart",{stm:this})}notifyStoresAboutRevRecordingStop(e){this.trigger("revisionRecordingStop",{stm:this,revision:e.title})}notifyStoresAboutTempRevRecordingStop(e){this.trigger("temporaryRevisionRecordingStop",{stm:this,revision:e.title})}notifyStoresAboutCheckoutToHead({revision:e}){this.trigger("checkoutToHead",{stm:this,revision:e})}onModelUpdate(e,t,n,i){el(this,this.state.onModelUpdate,e,t,n,i)}onModelInsertChild(e,t,n,i,r){el(this,this.state.onModelInsertChild,e,t,n,i,r)}onModelRemoveChild(e,t,n){el(this,this.state.onModelRemoveChild,e,t,n)}onStoreModelAdd(e,t,n){el(this,this.state.onStoreModelAdd,e,t,n)}onStoreModelInsert(e,t,n,i,r){el(this,this.state.onStoreModelInsert,e,t,n,i,r)}onStoreModelRemove(e,t,n,i){el(this,this.state.onStoreModelRemove,e,t,n,i)}onStoreRemoveAll(e,t,n){el(this,this.state.onStoreRemoveAll,e,t,n)}onUndoKeyPress(e){const t=this;t.enabled&&(e.shiftKey?t.canRedo&&(e.preventDefault(),t.redo()):t.canUndo&&(e.preventDefault(),t.undo()))}stash(){const e=this;if(e.transaction){const t=Bs.generateId("_stashedTransactionGeneratedId_");return e.stashedTransactions[t]=e.transaction,e.rejectTransaction(),t}}applyStash(e){const t=this,n=t.stashedTransactions[e];t[zo]=!0,n&&(t.startTransaction(n.title),n.redo(),delete t.stashedTransactions[e]),t[zo]=!1}mergeTransactionUpdateActions(e=this.transaction){e.mergeUpdateModelActions()}mergeTransactionAddUpdateActions(e=this.transaction){e.mergeAddUpdateModelActions()}canCheckoutTo(e){return(this.isReady||this.state===Za)&&this.state.canCheckoutTo(this,e)}get currentRevision(){if(this.revisionsEnabled)return this[Lo][this[_o]]}get lastRevision(){if(this.revisionsEnabled)return this[Lo][this[Lo].length-1]}get currentRevisionTransaction(){if(this.revisionsEnabled)return this[$o][this[_o]-1]}get lastCommittedRevision(){const e=this[$o];let t;for(let n=e.length-1;n>=0;n--)if(e[n].committed){t=e[n];break}return t}get lastCommittedRevisionId(){var e;return(null===(e=this.lastCommittedRevision)||void 0===e?void 0:e.title)??this[Lo][0]}get localRevisions(){return this[$o].slice(this[$o].findIndex((e=>!e.committed)))}get isCheckingOut(){return this.state===Za}get isRecordingRevision(){return this.state===Ja}get isRecordingTemporaryRevision(){return this.state===Qa}get isNavigatingRevisions(){return this.state===Za||this.state===Ja||this.state===Qa}initRevision(e,t=!0){const n=this;n.revisionsEnabled&&(n.autoRecord=t,n[Lo]=[e],n[$o]=[],n[_o]=0)}increaseRevision(e,t){const n=this;let i;if(!n.revisionsEnabled)return;if(n.isNavigatingRevisions&&!e.type)throw new xo("Cannot add new revision when in the checkout state");if(!e[Oo].length&&!e.type)return;const r=Bs.generateId(n.revisionLocalPrefix);if(e.title=r,!1===n.trigger("beforeRevisionAdd",{localRevisionId:r}))return;const s=e.conflictResolutionFor&&n[$o].find((t=>t.type===Ha&&t.conflictResolutionFor===e.conflictResolutionFor));if(s?(n[Lo].splice(n[Lo].indexOf(s.title),1,r),n[$o].splice(n[$o].indexOf(s),1,e)):(n[Lo].push(r),n[$o].push(e)),e.conflictResolutionFor||(n[_o]=n[Lo].length-1),e.type===Ha)return;e.filterUserInput&&(e.conflictResolutionFor||e.normalizeUserInputGeneration(),i=e.getUserInput()),!t&&n[$o].length>n.revisionQueueMaxLength&&!e.type&&n.cleanUpRevisions();const o={localRevisionId:r,userInput:i};e.conflictResolutionFor&&(o.conflictResolutionFor=e.conflictResolutionFor,o.revisionChanges=t),n.trigger("revisionAdd",o)}createDataCorrectionTransaction(){const e=new za({type:Ba});this.increaseRevision(e)}createConflictResolutionRevision(e,t,n){const{transaction:i}=this;if(n=W.clone(n),t){const n=this[$o].find((e=>e.conflictResolutionFor===t));n&&(n.conflictResolutionFor=e)}this.increaseRevision(za.from([i],{conflictResolutionFor:e??i.title,type:Va}),n)}createTemporaryConflictResolutionRevision(e,t){const{transaction:n}=this;this.increaseRevision(za.from([n],{conflictResolutionFor:e??n.title,type:Ha}),t)}checkoutTo(e){if(!this.canCheckoutTo(e))return!1;el(this,this.state.onCheckoutTo,e)}checkoutToLastCommittedRevision(){this.checkoutTo(this.lastCommittedRevisionId)}checkoutToHead(){this.checkoutTo(this[Lo][this[Lo].length-1]),el(this,this.state.onCheckoutToHead)}checkoutToNext(){return this[_o]+1<this[Lo].length&&this.checkoutTo(this[Lo][this[_o]+1])}startRevision(e){el(this,this.state.onStartRevision,e)}stopRevision(){el(this,this.state.onStopRevision)}startTemporaryRevision(e,t){el(this,this.state.onStartTemporaryRevision,e,t)}stopTemporaryRevision(){el(this,this.state.onStopRevision)}commitRevision(e,t){const n=this[Lo],i=this[$o],r=i.find((t=>t.title===e));for(let e=i.indexOf(r)-1;e>=0;e--)if(!1===i[e].committed&&i[e].type!==Ha&&!i[e].conflictResolutionFor)throw new xo(`Cannot commit revision because it is preceded by an uncommitted rev id ${i[e].title}`,i);if(t){if(n.includes(t))throw new xo(`Proposed revision id (${t}) already exists`);r.title=n[n.indexOf(r.title)]=t,i.forEach((n=>{n.type===Ha&&n.conflictResolutionFor===e&&(n.conflictResolutionFor=t)}))}r.committed=!0}cleanUpRevisions(e=this.revisionQueueCommittedMinLength){const t=this[Lo],n=this[$o],i=[];for(let e=0;e<n.length;e++){const t=n[e];if(!t.committed)break;i.push(t)}i.splice(Math.max(0,i.length-1-e),Math.min(i.length,e)),n.splice(0,i.length),t.splice(1,i.length)}markCurrentTransactionContentUserInput(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentUserInput()}markCurrentTransactionContentCalculated(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentCalculated()}}tl._$name="StateTrackingManager";var nl=e=>class extends(e||Pe){static $name="StoreStm";static configurable={stm:null,ignoreRemoteChangesInSTM:!1};changeStm(e,t){var n;return null!=t&&null!==(n=t.hasStore)&&void 0!==n&&n.call(t,this)&&t.removeStore(this),e&&(e.isStateTrackingManager||(e=new tl(e)),e.hasStore(this)||e.addStore(this)),e}add(e,t=!1,n={}){let i;const{stm:r}=this;var s;!this.tree&&null!=r&&r.shouldRecordAction?(i=super.add(e,t,n),null!==(s=i)&&void 0!==s&&s.length&&r.onStoreModelAdd(this,i,t)):i=super.add(e,t,n);return i}insert(e,t,n=!1){let i;const{stm:r}=this;if(!this.tree&&null!=r&&r.shouldRecordAction){var s;const o=(Array.isArray(t)?t:[t]).reduce(((e,t)=>{const n=t instanceof ws?this.indexOf(t):void 0;return void 0!==n&&-1!==n&&e.set(t,n),e}),new Map);i=super.insert(e,t),null!==(s=i)&&void 0!==s&&s.length&&(e=this.indexOf(i[0]),r.onStoreModelInsert(this,e,i,o,n))}else i=super.insert(e,t,n);return i}remove(e,t=!1,n){let i;const{stm:r}=this;if(!this.tree&&null!=r&&r.shouldRecordAction){var s;const o=(Array.isArray(e)?e:[e]).map((e=>this.getById(e))).filter((e=>!!e)).reduce(((e,t)=>{const n=this.indexOf(t);return void 0!==n&&-1!==n&&e.set(t,n),e}),new Map);i=super.remove(e,t,n),null!==(s=i)&&void 0!==s&&s.length&&r.onStoreModelRemove(this,i,o,t)}else i=super.remove(e,t,n);return i}removeAll(e){const{stm:t}=this;let n;if(null!=t&&t.shouldRecordAction){const{tree:i,rootNode:r,allRecords:s}=this,o=s.length,a=i?r.children.slice():s.slice();n=super.removeAll(e),o&&0===this.count&&t.onStoreRemoveAll(this,a,e)}else n=super.removeAll(e);return n}beforeApplyChangeset(){const{stm:e,crudManager:t}=this;let n=!1,i=null;return null!=t&&t.applyingChangeset||null==e||!e.enabled||e.isNavigatingRevisions||(n=!0,e.isRecording&&(i=e.stash()),this.ignoreRemoteChangesInSTM?e.disable():e.startTransaction()),{shouldResume:n,transactionId:i}}applyChangeset(e,t,n,i,r){const{shouldResume:s,transactionId:o}=this.beforeApplyChangeset(),a=super.applyChangeset(e,t,n,i,r);return this.afterApplyChangeset(s,o),a}afterApplyChangeset(e,t){if(e){const{stm:e}=this;this.ignoreRemoteChangesInSTM?e.enable():e.stopTransaction(),e.applyStash(t)}}};class il{static new(e){return new this(e)}constructor(e){this.promise=new Promise(((e,t)=>{this.resolve=e,this.reject=t})),e&&e(this)}catch(e){return this.promise=this.promise.catch(e),this}finally(e){return this.promise=this.promise.finally(e),this}then(...e){return this.promise=this.promise.then(...e),this}}il._$name="Promissory";class rl extends(xi.mixin(Ir)){static $name="StoreLazyLoadPlugin";static get pluginConfig(){return{override:["updateAutoLoad"],assign:["load","isLoading","lazyGetAt"],after:["afterLoadData"],before:["setStoreData"]}}static configurable={totalCountProperty:"total",dataProperty:"data",chunkSize:100};static get properties(){return{loadQueue:{}}}get isLoading(){return this.client._isLoading||Object.values(this.loadQueue).some((e=>W.isPromise(e)))}get storage(){return this.client.storage}set totalCount(e){this._totalCount=e}get totalCount(){return this._totalCount}setEstimatedTotalCount(e){this.totalCount=e}afterConstruct(){const e=this,{client:t}=e;t.syncDataOnLoad&&(t.syncDataOnLoad=!1),e.storeListenersDetacher=t.ion({beforeAdd:"internalOnBeforeAdd",beforeRemove:"internalOnBeforeAdd",change:"internalOnChange",commit:"internalOnCommit",endApplyChangeset:"internalOnCommit",thisObj:e}),t.requestData||(t.requestData=e.requestData),t.autoLoad&&this.requestAnimationFrame(this.load)}updateAutoLoad(e){e&&!this.client.isAjaxStore&&this.load()}internalOnBeforeAdd(){if(this.isLoading)throw new Error("Removing or adding is not allowed when a lazy loaded Store is loading")}internalOnChange(){this.$loadLock||!this.client.added.count&&!this.client.removed.count||(this.$loadLock=new il)}internalOnCommit(){!this.client.changes&&this.$loadLock&&(this.$loadLock.resolve(),this.$loadLock=null)}afterLoadData(){this.totalCount&&(this.storage.values.length=this.totalCount)}setStoreData(e){!this.client.records.filter((e=>e)).length||null!=e&&e.length||(this.totalCount=null,this.loadQueue={})}clearLoaded(){const{client:e}=this;e.suspendEvents(),this.totalCount=null,e.clear(!0),this.loadQueue={},e.resumeEvents()}async requestData({startIndex:e,count:t}){}lazyGetAt(e){return this.getAt(e)}async getAt(e){var t;const n=this,{loadQueue:i,totalCount:r}=n;if(e<0||null!=r&&e>r)return null;const s=n.getFromStorage(e);return s||(await(null===(t=n.$loadLock)||void 0===t?void 0:t.promise),i[e]?await i[e]:await n.doLazyLoad(n.calculateRange(e)),n.getFromStorage(e))}getFromStorage(e){return this.storage.getAt(e)}calculateRange(e){const{totalCount:t,loadQueue:n,chunkSize:i}=this,r=Math.max(0,e-i),s=(t?Math.min(e+i,t):e+i)-1;let o=e,a=e;for(;o>r&&!n[o-1]&&!this.getFromStorage(o-1);)o-=1;for(;a<s&&!n[a+1]&&!this.getFromStorage(a+1);)a+=1;return{startIndex:o,count:a-o+1}}async doLazyLoad({startIndex:e,count:t}){this.triggerLazyLoadStart(arguments[0]);const n=this,{loadQueue:i}=n,r=e+t-1,s=n.client.requestData(arguments[0]);for(let t=e;t<=r;t++)i[t]=s;const o=await s;if(!o)return;const{[n.totalCountProperty]:a,[n.dataProperty]:l}=o;for(let t=e;t<=r;t++)i[t]=null;null!=a?n.totalCount=a:null==n.totalCount&&t>l.length&&n.setEstimatedTotalCount(e+l.length),n.addData(l,e),null!=n.totalCount&&(n.storage.values.length=n.totalCount),n.triggerLazyLoadEnd(arguments[0],l)}addData(e,t){const{client:n,storage:i}=this;if(null==e||!e.length)return;if(!n.count&&!t)return void(n.data=e);for(let t=e.length-1;t>=0;t--){const i=e[t],r=n.idRegister[i.id];r&&(r.setByDataSource(i,!0),r.internalClearChanges(!1,!0,i),e.splice(t,1))}if(!e.length)return;const{values:r}=i,s=n.processRecords(e,void 0,!0);r.length<t&&(r.length=t),null==t&&(t=r.length),r.splice(t,s.length,...s),n.joinRecordsToStore(s),n.updateDependentStores("add",s);for(const e of s)n.idMap[e.id]={index:t,visibleIndex:t,record:e},t+=1,i.addToIndices(e);n.trigger("change",{action:"lazyload",records:s})}checkDuplicates(e){const{storage:t}=this;for(const n of e){const e=t.indexOf(n.id);e>=0&&t.values.splice(e,1)}}triggerLazyLoadStart(e){const t=this;t.isLoading||(t.isConfiguring?t.delay((()=>t.trigger("lazyLoadStarted")),0):t.client.trigger("lazyLoadStarted")),t.client.trigger("beforeLazyLoad",{...e})}triggerLazyLoadEnd(e,t){this.isLoading||this.client.trigger("lazyLoadEnded"),this.client.trigger("afterLazyLoad",{...e,data:t})}load(e){return this.client.count>0&&this.clearLoaded(),this.getAt(0)}doDestroy(){var e;null===(e=this.storeListenersDetacher)||void 0===e||e.call(this),this.loadQueue={},super.doDestroy()}}rl._$name="StoreLazyLoadPlugin";const sl=e=>(e=>{var t;return(null===(t=e.children)||void 0===t?void 0:t.reduce(((e,t)=>e+(t.remoteChildCount??0)+1),0))??0})(e)>=e.remoteChildCount;var ol=e=>class extends e{static $name="TreeStoreLazyLoadPlugin";static get pluginConfig(){var e;const t={};for(const e in super.pluginConfig)t[e]=[...super.pluginConfig[e]];t.override=t.override??[],t.override.push("loadChildren","getAt");const n=null===(e=t.assign)||void 0===e?void 0:e.indexOf("lazyGetAt");return n>=0&&t.assign.splice(n,1),t}static configurable={chunkSize:50};constructor(){super(...arguments),this.totalCount=0}load(){const e=this,{rootNode:t}=e.client,n=e.loadQueue[t.id];return n?!0===n?(e.clearLoaded(),e.load()):n:e.doLazyLoad({parent:t,startIndex:0})}changeRemoteChildCount(e,t,n){if(null!=e&&e.length){const i=e.map((e=>{var t;return e.parent??this.client.getById(e.parentId??(null===(t=e.originalData)||void 0===t?void 0:t.parentId))}));for(;i.length;){const e=i.shift();e&&(e.isRoot||i.push(e.parent),e.remoteChildCount=(e.remoteChildCount?e.remoteChildCount+t:e.children.length)??0,n.add(e))}}}internalOnCommit({changes:e}){super.internalOnCommit();const t=new Set;this.changeRemoteChildCount(e.added,1,t),this.changeRemoteChildCount(e.removed,-1,t),t.forEach((e=>{this.loadQueue[e.id]=sl(e)}))}loadChildren(e){return this.doLazyLoad({parent:e,startIndex:0})}getAt(e){const t=this,{loadQueue:n,client:i}=t,r=i.records[e];if(r){var s;const{parent:e}=r;!(r.expanded&&r.remoteChildCount>0)||null!==(s=r.children)&&void 0!==s&&s.length||n[r.id]||t.doLazyLoad({parent:r,startIndex:0}),r!==e.lastChild||n[e.id]||t.doLazyLoad({startIndex:r.parentIndex+1,parent:e})}return r}async doLazyLoad({parent:e,...t}){const n=this,{loadQueue:i,client:r}=n,{id:s}=e;e.instanceMeta(r).isLoadingChildren=!0,n.triggerLazyLoadStart(arguments[0]),i[s]=r.requestData({...t,parentId:e.isRoot?"root":s,count:n.chunkSize});const{[n.totalCountProperty]:o,[n.dataProperty]:a}=await i[s];var l;(e.isRoot&&o>=0&&(e.remoteChildCount=o),n.addData(a,e),n.totalCount=r.count,i[s]=sl(e),n.isLoading)||(null===(l=r.trigger)||void 0===l||l.call(r,"refresh",{action:"lazyload"}));n.triggerLazyLoadEnd(arguments[0],a),e.instanceMeta(r).isLoadingChildren=!1}addData(e,t){const{client:n,loadQueue:i}=this;yo.preWalk({children:e},(({children:e})=>null!=e&&e.length?e:null),(e=>{const{id:t,children:n}=e;t&&e.remoteChildCount>0&&(!1!==e.expanded||null!=n&&n.length?null!=n&&n.length&&!i[t]&&sl(e)?i[t]=!0:n||(e.children=[]):e.children=!0)})),n.modelClass.fieldMap.remoteChildCount||n.modelClass.addField("remoteChildCount"),t.appendChild(e,!0),n.added.clear()}};const al={splice:1,clear:1},ll={includeFilteredOutRecords:!1,includeCollapsedGroupRecords:!1},cl=(e,t)=>("boolean"==typeof(t=t||!1)&&(t={includeFilteredOutRecords:t,includeCollapsedGroupRecords:!1}),t||ll),dl=Symbol("useRawDataUnset"),ul={enabled:!0,disableDuplicateIdCheck:!0,disableDefaultValue:!1,disableTypeConversion:!1},hl={enabled:!0,disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1};class gl extends(Pe.mixin(Ir,Vr,at,Ti,jr,io,no,to,lo,co,go,mo,oo,fo,vo,Eo,nl,Ro,ao)){static $name="Store";static get properties(){return{relationCache:{},dependentStoreConfigs:new Map,addingClean:!1}}static configurable={id:!0,modelClass:ws,verifyNoGeneratedIds:!0,lazyLoad:null,autoLoad:null,useRawData:dl};static get defaultConfig(){return{fields:null,autoTree:!0,data:null,tree:!1,callOnFunctions:!0,storage:null,allowNoId:!0,preventSubClassingModel:null,storeClass:null}}static get identifiable(){return{registerGeneratedId:!1}}static $lazyLoadPluginClass=rl;constructor(...e){if(super(...e),this.objectify)return this.initProxy()}construct(e={}){Object.assign(this,{added:new eo,removed:new eo,modified:new eo,idRegister:{},internalIdRegister:{},oldIdMap:{}}),super.construct(e),this.initRelations()}static from(e,t={},n=null){return e&&!e.isStore&&("string"==typeof e?e=gl.getStore(e):(Array.isArray(e)?(n&&(e=e.map((e=>e.isModel?e:n(e)))),e=W.assign({},t,{data:e})):e=W.assign({},t,e),e=new gl(e))),e}equals(e){return e.isStore&&e.$master===this.$master}doDestroy(){var e,t,n;const i=this,r=i.registeredRecords;null===(e=i.stm)||void 0===e||null===(t=e.removeStore)||void 0===t||t.call(e,i);for(let e,t=r.length-1;t>=0;t--){var s;e=r[t],null!==(s=e)&&void 0!==s&&s.isDestroyed||e.unjoinStore(i)}var o;(null===(n=i._storage)||void 0===n||n.destroy(),i.isChained)?i.masterStore.isDestroying||$e.remove(i.masterStore.chainedStores,i):null===(o=i.rootNode)||void 0===o||o.destroy();super.doDestroy()}beginBatch(){this.suspendEvents()}endBatch(){if(this.resumeEvents()){const{values:e}=this.storage;this.trigger("refresh",{action:"batch",data:e,records:e})}}set storage(e){const t=this;null!=e&&e.isCollection?t._storage=e:t._storage=new Xs(e),t._storage.autoFilter=t.reapplyFilterOnAdd,t._storage.autoSort=t.reapplySortersOnAdd;for(const e of t._storage)e.joinStore(t);t._storage.ion({change:"onDataChange",thisObj:t})}get storage(){return this._storage||(this.storage={}),this._storage}get allRecords(){var e;const t=this;if((null===(e=t._allRecords)||void 0===e?void 0:e.generation)!==t.storage.generation){if(t.isTree){const e=t.collectDescendants(t.rootNode,void 0,void 0,{unfiltered:!0}).all;t.rootVisible&&e.unshift(t.rootNode),t._allRecords=e}else t._allRecords=t.isGrouped?t.collectGroupRecords(!0,!0):t.storage.allValues;t._allRecords.generation=t.storage.generation}return t._allRecords}getAllDataRecords(e){const t=this;return t.tree?e?t.allRecords:t.rootNode.allChildren:t.isGrouped?t.collectGroupRecords(e,!1):(e?t.storage.allValues:t.storage.values).filter((e=>e))}onIsCreatingToggle(e,t){const n=this,i=e.isPersistable&&!t;n.added[i?"add":"remove"](e),i&&(n.trigger("addConfirmed",{record:e}),n.autoCommit&&n.doAutoCommit())}joinRecordsToStore(e){const{totalCount:t}=this;for(let n=0;n<e.length;n++){const i=e[n];i.setData("parentIndex",t+n-e.length),i.joinStore(this)}}onDataChange({source:e,action:t,added:n,removed:i,replaced:r,oldCount:s,items:o,from:a,to:l}){const c=this,d=al[t],u=d&&(null==n?void 0:n.length),h=d&&(null==i?void 0:i.length);let g,m;if(c._idMap=null,u&&c.joinRecordsToStore(n),null==r||r.forEach((([e,t])=>{e.unjoinStore(c,!0),t.joinStore(c)})),super.onDataChange(...arguments),!c.isTree){if(u){for(const e of n)c.removed.includes(e)?c.removed.remove(e):c.addingClean||e.isLinked||c.added.add(e);g=!c.remoteFilter&&c.isFiltered&&c.reapplyFilterOnAdd,g&&c.filter({silent:!0}),m=!c.remoteSort&&c.isSorted&&c.reapplySortersOnAdd,m&&c.sort(null,null,!1,!0)}if(h){for(const e of i)e.cancelBatch(),e.unjoinStore(c),c.added.includes(e)?(c.added.remove(e),e.isBeingMaterialized&&c.removed.add(e)):e._undoingInsertion||e.isCreating||e.isLinked||c.removed.add(e);c.modified.remove(i),g=!c.remoteFilter&&c.isFiltered,g&&c.filter({silent:!0})}}switch(t){case"clear":c.relationCache={},c.updateDependentStores("removeall"),c.trigger("removeAll"),c.trigger("change",{action:"removeall"});break;case"splice":if(u){c.updateDependentStores("add",n);const t=n.reduce(((e,t)=>{const{previousIndex:n}=t.meta;return n>-1&&n<e&&(e=n),e}),n[0].meta.previousIndex),i={records:n,index:e.indexOf(n[0],!e.autoFilter)};t>-1&&(i.oldIndex=t),c.trigger("add",i),c.trigger("change",Object.assign({action:"add"},i)),g&&c.triggerFilterEvent({action:"filter",filters:c.filters,oldCount:s,records:c.storage.allValues}),m&&c.trigger("sort",{action:"sort",sorters:c.sorters,records:c.storage.allValues})}i.length&&(c.updateDependentStores("remove",i),c.trigger("remove",{records:i}),c.trigger("change",{action:"remove",records:i})),r.length&&(c.updateDependentStores("replace",r),c.trigger("replace",{records:r,all:c.records.length===r.length}),c.trigger("change",{action:"replace",replaced:r,all:c.records.length===r.length}));break;case"filter":(c.isGrouped||c.isSorted)&&c.performSort(!0);break;case"move":{const e=Math.min(a,l),n=Math.min(c.storage.allValues.length-1,Math.max(a,l));for(let t=c.storage.allValues,i=e;i<=n;i++)t[i].setData("parentIndex",i);c.trigger("move",{records:o,from:a,to:l}),c.isFiltered&&c.performFilter(),c.trigger("change",{action:t,record:o[0],records:o,from:a,to:l});break}}}onDataReplaced(e,t){var n;const i=this,{storage:r}=i,s=r.allValues,o=Boolean(i.sorters.length>0);for(let e=0;e<s.length;e++){var a;null===(a=s[e])||void 0===a||a.joinStore(i)}if(!i.remoteFilter&&i.isFiltered&&i.filter({silent:!0}),i.remoteSort?i.isGrouped&&r.replaceValues({...i.prepareGroupRecords(),silent:!0}):(i.isGrouped&&i.group(null,null,!1,!o,!0),o&&i.sort(null,null,!1,!0)),!i.useRawData.disableDuplicateIdCheck){const{idMap:e}=i;if(Object.keys(e).length<r.values.length){const t=[];throw r.values.forEach((n=>e[n.id]?delete e[n.id]:t.push(n))),new Error(`Id collision on ${t.map((e=>e.id))}`)}}const l={action:e,data:t,records:r.values};i.updateDependentStores(e,l.records),null===(n=i.afterLoadData)||void 0===n||n.call(i),i.isRemoteDataLoading||i.trigger("refresh",l),i.trigger("change",l)}onModelChange(e,t,n,i,r){const s=this,o={record:e,records:[e],changes:n,batch:null!=e.batching,fromRelationUpdate:r};if(s.storage.onItemMutation(e,n),"id"in n){const{oldValue:n,value:i}=t.id;s.updateDependentRecordIds(n,i),s.onRecordIdChange({record:e,oldValue:n,value:i})}else e.meta._ignoreRelatedIdUpdate||s.updateDependentStores("update",[e],i);const a=!e.ignoreBag&&!e.isLinked&&s.updateModifiedBagForRecord(e);if(s.onUpdateRecord(e,n),!i){if("id"in n){const{oldValue:n,value:i}=t.id;s.trigger("idChange",{store:s,record:e,oldValue:n,value:i})}s.trigger("update",o),s.trigger("change",Object.assign({action:"update"},o))}s.autoCommit&&a&&s.doAutoCommit()}updateModifiedBagForRecord(e){const t=this,{modified:n,added:i}=t;return e.isModified&&!e.isRoot&&e.isPartOfStore(t)?(n.includes(e)||i.includes(e)||(e.isPhantom?i.add(e):n.add(e)),e.isBeingMaterialized&&(t.modifiedMaterialized=t.modifiedMaterialized??new Set,t.modifiedMaterialized.add(e)),!0):(n.remove(e),!1)}get idMap(){const e=this,t=!e._idMap,n=e._idMap||(e._idMap={});if(t){const t=e.storage.values;for(let e,r=0,s=0;r<t.length;r++){var i;e=t[r],e&&(n[e.id]={index:r,visibleIndex:s,record:e}),null!==(i=e)&&void 0!==i&&i.isSpecialRow||s++}if(e.isFiltered)for(let t=0,i=e.storage._values.length;t<i;t++){const i=e.storage._values[t];i.id in n?n[i.id].unfilteredIndex=t:n[i.id]={index:-1,unfilteredIndex:t,record:i}}}return n}changeModelClass(e){const{fields:t}=this;this.originalModelClass=e;let n=e;if(null!=t&&t.length){class i extends e{static get fields(){return t}}n=i}else if(!this.preventSubClassingModel){class t extends e{}n=t}return n.initClass(),n}changeLazyLoad(e){const t=this;let n=t.constructor.$lazyLoadPluginClass;t.isTree&&(t.treeLazyLoadClass||(t.treeLazyLoadClass=class extends(ol(n)){}),n=t.treeLazyLoadClass);let i=t.getPlugin(n);if(e){const r=W.isObject(e);return i?r&&W.assign(i,e):i=t.addPlugin(n,r?e:null),i}var r;return null===(r=i)||void 0===r||r.destroy(),!1}changeId(e,t){return super.changeId(!0!==e&&e,t)}updateId(e,t){const n=gl.getById(e);n&&gl.unregisterInstance(n),super.updateId(e,t)}generateAutoId(){return gl.generateId("store-")}get tree(){return this._tree}set tree(e){this._tree=e,e&&!this.rootNode&&(this.rootNode=this.buildRootNode(),this.rootNode.isAutoRoot=!0)}buildRootNode(){return{}}static getStore(e,t){if(e instanceof gl)return e;if(this.getById(e))return this.getById(e);if(Array.isArray(e)){let n;const i=e.map((e=>(e instanceof ws?n=e.constructor:"string"==typeof e&&(e={text:e}),e)));if(!n){class e extends ws{}n=e}e={autoCreated:!0,data:i,modelClass:n,allowNoId:!0},t||(t=gl)}return t?new t(e):void 0}static get stores(){return gl.registeredInstances}get rootNode(){return this.masterStore?this.masterStore.rootNode:this._rootNode}set rootNode(e){var t;const n=this,i=n._rootNode;e!==i&&(i&&(n.clear(!0),n.removed.clear()),e instanceof ws?(e.instanceMeta(n).collapsed=!1,n._rootNode=e):n._rootNode=e=new n.modelClass({expanded:!0,[n.modelClass.idField]:`${n.id}-rootNode`,...e},n,{isRoot:!0},!0),n._tree=!0,e.isRoot=!0,e.joinStore(n),(null!==(t=e.children)&&void 0!==t&&t.length||n.rootVisible)&&(e.isLoading=!0,n.onNodeAddChild(e,e.children||[],0),e.isLoading=!1),n.trigger("rootChange",{oldRoot:i,rootNode:e}))}set data(e){this.setStoreData(e)}get data(){return this.getAllDataRecords(!0).map((e=>e.data))}setStoreData(e){var t,n;const i=this,{idField:r,childrenField:s}=i.modelClass;if(null!==(t=e)&&void 0!==t&&t.length&&!Object.isExtensible(e[0])&&(i.transformFlatData||i.useRawData.enabled)&&(i.transformFlatData&&(i.useRawData=i.useRawData||{disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1}),e=W.clone(e)),i.getConfig("plugins"),i.processConfiguredListeners(),e&&!Array.isArray(e)&&(e=W.transformNamedObjectToArray(e,r)),i.tree=!i.isChained&&(i.tree||Boolean(i.autoTree&&(null===(n=e)||void 0===n?void 0:n.some((e=>e[s]))))),e&&(i.remoteSort||i.remoteFilter))for(let t=0;t<e.length;t++)e[t]._remoteSortIndex=t;i.syncDataOnLoad&&i._data?i.syncDataset(e):(i._data=e,i.tree?i.loadTreeData(e):i.loadData(e),i.added.clear(),i.removed.clear(),i.modified.clear())}loadTreeData(e){const t=this,n=t.rootNode;if(t.transformFlatData&&(e=t.treeifyFlatData(e)),n.isLoading=!0,t.clear(!0),n.appendChild(e),t.updateDependentStores("dataset",[n]),n.isLoading=!1,0===e.length){const e={action:"dataset",data:[],records:[]};t.trigger("refresh",e),t.trigger("change",e)}else t.isFiltered&&t.filter()}loadData(e,t="dataset"){const n=this,{storage:i,allowNoId:r}=n,s=n.modelClass.fieldMap.id.dataSource,o=n.find((e=>e.isCreating));o&&i.values.splice(n.records.indexOf(o),1);let a=n.verifyNoGeneratedIds;if(n.removeHeadersAndFooters(n.storage.values),n._idMap=null,n.oldIdMap={},e){const c=!(e[0]instanceof ws),d=e.length,u=new Array(d);c&&n.modelClass.exposeProperties(e[0]);for(let t=0;t<d;t++){let i=e[t];if(c){var l;const e=i[s];if(!r&&null==e)throw new Error(`Id required but not found on row ${t}`);a&&null!=e&&null!==(l=e.startsWith)&&void 0!==l&&l.call(e,"_generated")&&(console.warn(`Generated id found in data: ${e}. Generated ids are temporary and should be replaced with real ids by the backend`),a=!1),i=n.createRecord(i,!0)}n.isFillingFromMaster||(i=n.processRecord(i,!0),i.setData("parentIndex",t)),u[t]=i}n.clear(!0),i.replaceValues({values:u,isNewDataset:!0,silent:!0}),o&&!i.values.includes(o)&&i.values.push(o),n._data=e,n.onDataReplaced(t,e)}else n.clear(!0),n._data=null;n.isSyncingDataOnLoad=!1}getRange(e,t,n=!0){return(n?this.storage.allValues:this.storage.values).slice(e,t)}createRecord(e,t=!1,n=!1){return new this._modelClass(e,this,null,t,!1,n)}processRecord(e,t=!1){return e}refreshData(){this.filter(),this.sort()}onRecordIdChange({record:e,oldValue:t,value:n}){const i=this,r=i._idMap,{idRegister:s,oldIdMap:o}=i;if(i.storage._indicesInvalid=!0,o[t]=e,r&&!r[n]){const e=r[t];delete r[t],r[n]=e}i.added.changeId(t,n),i.removed.changeId(t,n),i.modified.changeId(t,n),delete s[t],s[n]=e,e.index=i.storage.indexOf(e)}onUpdateRecord(e,t){var n;const i=this,{internalId:r}=t,{internalIdRegister:s,reapplyFilterOnUpdate:o}=i;r&&(this.storage._indicesInvalid=!0,delete s[r.oldValue],s[r.value]=e),(!0===o||null!==(n=o.fields)&&void 0!==n&&n.some((e=>e in t)))&&i.isFiltered&&i.filter()}get useRawData(){var e;return this._useRawData===dl?this.readUrl||null!==(e=this.crudManager)&&void 0!==e&&e.loadUrl?hl:{enabled:!1}:this._useRawData}changeUseRawData(e){return e===dl?dl:!0===e?ul:e?Object.assign(e,{enabled:!0}):{enabled:!1}}getCount(e=!0){const t=this,{storage:n,groupRecords:i,isFiltered:r,isGrouped:s,isTree:o,rootNode:a}=t;if("boolean"==typeof e)return G.deprecate("core","7.0.0","getCount(true/false) deprecated in favor of getCount(options)"),e?t.count:n.totalCount-((null==i?void 0:i.count)||0);if(e.all)return this.allRecords.length;"visibleData"in e||(e.visibleData=!0);let l=0;const{visibleData:c,headersFooters:d,filteredOut:u,collapsed:h}=e,g=r?(null==i?void 0:i.values.reduce(((e,n)=>e+(t.includes(n)?1:0)),0))??0:(null==i?void 0:i.count)??0,m=n.count-g;if(c&&(l+=m),d&&s&&(l+=r&&u?i.count??0:g),u&&r&&(l+=o?a.getDescendantCount(!1,t,!0)-a.getDescendantCount(!1,t,!1):n.allValues.length-n.values.length),h)if(s){let e=0;for(const n of t.collapsedGroups)e+=i.get(n).groupChildren.length;l+=e}else o&&(l+=a.descendantCount-m);return l}get count(){return this.storage.count}get originalCount(){var e;return G.deprecate("core","7.0.0","originalCount was deprecated in favor of getCount()"),this.storage.totalCount-((null===(e=this.groupRecords)||void 0===e?void 0:e.count)||0)}get allCount(){return G.deprecate("core","7.0.0","allCount was deprecated in favor of totalCount"),this.isTree?this.rootNode.descendantCount:this.storage.totalCount}get totalCount(){return this.getCount({all:!0})}get records(){return this.storage.values}get first(){return this.storage.values[0]}get last(){return this.storage.values[this.storage.values.length-1]}getAt(e,t=!1){return this.storage.getAt(e,t)}register(e){const t=this;if(!t.useRawData.disableDuplicateIdCheck){const n=t.isTree&&t.idRegister[e.id];if(n&&n!==e)throw new Error(`Id collision on ${e.id}`)}t.idRegister[e.id]=e,t.internalIdRegister[e.internalId]=e}unregister(e){delete this.idRegister[e.id],delete this.internalIdRegister[e.internalId]}get registeredRecords(){return Object.values(this.idRegister)}getById(e){var t;const n=this;let i;null!==(t=e)&&void 0!==t&&t.isModel&&(i=e,e=i.id);const r=n.idRegister[e];if(i){var s;if(null!==(s=i)&&void 0!==s&&s.hasLinks&&!r){const{allValues:e}=n.storage;return i.$links.find((t=>e.includes(t)))}return i}return r}isAvailable(e){const t=this.getById(e);return t&&this.storage.includes(t)||!1}getByInternalId(e){return this.internalIdRegister[e]}includes(e){return this.isTree?null!=this.idRegister[ws.asId(e)]:this.indexOf(e)>-1}indexOf(e,t=!1,n=!1){var i;if(null!=e&&e.isModel&&(null===(i=e.stores)||void 0===i||!i.includes(this.$store||this))){const n=e.$links.find((e=>this.storage.allValues.includes(e)));return n?this.indexOf(n,t):-1}if(this.isTree)return(n?this.rootNode.allChildren:this.storage.values).indexOf(this.getById(e));const r=ws.asId(e);if(null==r)return-1;const s=this.idMap[r];return s?s[t?"visibleIndex":"index"]:-1}allIndexOf(e){return this.isTree?this.allRecords.indexOf(this.getById(e)):this.storage.indexOf(e,!0)}getDistinctValues(e,t=!1){const n=[],i={};let r;return this.forEach((t=>{if(!t.isSpecialRow&&!t.isRoot){r=t.getValue(e);const s=r instanceof Date?r.getTime():r;i[s]||(n.push(r),i[s]=1)}}),this,{includeCollapsedGroupRecords:!0,includeFilteredOutRecords:t}),n}getValueCount(e,t){let n=0;return this.forEach((i=>{W.isEqual(i.getValue(e),t)&&n++})),n}set json(e){"string"==typeof e&&(e=H.safeJsonParse(e)),this.data=e}get json(){return H.safeJsonStringify(this)}get formattedJSON(){return H.safeJsonStringify(this,null,4)}toJSON(){const e=this,{persistable:t,dataSource:n}=e.modelClass.getFieldDefinition("expanded");return(e.isTree?e.rootNode.unfilteredChildren||e.rootNode.children||[]:e.allRecords).map((i=>{const r=i.toJSON();return e.tree&&i.isParent&&t&&(r[n]=i.isExpanded(e)),r}))}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.project}getInlineData(e){const t=[];var n;this.tree?null===(n=this.rootNode.children)||void 0===n||n.forEach((n=>t.push(n.getCurrentConfig(e)))):this.forEach((n=>t.push(n.getCurrentConfig(e))));return t}getCurrentConfig(e){const t=super.getCurrentConfig(e),{state:n}=this;var i;t&&(t.data&&(t.data=this.getInlineData(e)),delete t.project,delete t.stm,delete t.asyncEvents,(null===(i=t.modelClass)||void 0===i?void 0:i.$meta.hierarchy[t.modelClass.$meta.hierarchy.length-2])===this.constructor.defaultConfig.modelClass&&delete t.modelClass,this.tree||delete t.tree,n&&Object.assign(t,n));return t}forEach(e,t=this,n){const i=this,r=(n,i)=>{if(n&&!n.isRoot&&!n.isSpecialRow)return e.call(t,n,i)};if(n=cl(0,n),i.isTree)i.isChained&&(n={...n,sorterFn:i.sorterFn}),i.rootNode.traverseWhile(r,!1,n);else{const e=n.includeFilteredOutRecords?i.storage.allValues:i.storage.values;if(i.isGrouped&&n.includeCollapsedGroupRecords)for(let t=0;t<e.length;t++){const i=e[t],s=n.includeFilteredOutRecords?i.unfilteredGroupChildren:i.groupChildren;if(s&&!0===i.meta.collapsed)for(let e=0;e<s.length;e++){if(!1===r(s[e],e))return}else if(!1===r(i,t))return}else for(let t=0;t<e.length;t++)if(!1===r(e[t],t))return}}map(e,t=this){return this.storage.values.map(e,t)}flatMap(e,t=this){return this.storage.values.flatMap(e,t)}every(e,t=this,n){return this.storage[n?"allValues":"values"].every(e,t)}reduce(e,t=[],n=this){return n!==this&&(e=e.bind(n)),this.storage.values.reduce(e,t,n)}[Symbol.iterator](){return this.storage.values[Symbol.iterator]()}traverse(e,t=this.rootNode,n=t===this.rootNode,i){const r=this;if(i=cl(0,i),r.isTree){if("boolean"==typeof t&&(n=t,t=r.rootNode),r.isChained){const t=e;e=e=>{r.chainedFilterFn(e)&&t(e)}}t.traverse(e,n,i)}else r.forEach((t=>t.traverse(e,!1,i)),r,i)}traverseWhile(e,t=this.rootNode,n=t===this.rootNode,i){const r=this;if(i=cl(0,i),r.isTree){if("boolean"==typeof t&&(n=t,t=r.rootNode),r.isChained){const t=e;e=e=>{r.chainedFilterFn(e)&&t(e)}}t.traverseWhile(e,n,i)}else for(const t of r.storage)if(!1===t.traverse(e,!1,i))break}getNext(e,t=!1,n=!1){const i=this,r=i.storage.values;let s=i.indexOf(e);if(s>=r.length-1){if(!t)return null;s=-1}const o=r[s+1];return n&&o&&(o.isSpecialRow||"function"==typeof n&&n(o))?i.getNext(r[s+1],t,n):o}getPrev(e,t=!1,n=!1){const i=this,r=i.storage.values;let s=i.indexOf(e);if(0===s){if(!t)return null;s=r.length}const o=r[s-1];return s>0&&n&&o&&(o.isSpecialRow||"function"==typeof n&&n(o))?i.getPrev(r[s-1],t,n):o}getAdjacent(e,t=!0,n=!1,i=!1){return t?this.getNext(e,n,i):this.getPrev(e,n,i)}getNextLeaf(e,t=!1){const n=this.leaves,i=this.getById(e);let r=n.indexOf(i);if(r>=n.length-1){if(!t)return null;r=-1}return n[r+1]}getPrevLeaf(e,t=!1){const n=this.leaves,i=this.getById(e);let r=n.indexOf(i);if(0===r){if(!t)return null;r=n.length}return n[r-1]}getAdjacentLeaf(e,t=!0,n=!1){return t?this.getNextLeaf(e,n):this.getPrevLeaf(e,n)}}gl.initClass(),gl._$name="Store";class ml extends rl{static $name="AjaxStoreLazyLoadPlugin";static get pluginConfig(){const e={};for(const t in super.pluginConfig)e[t]=[...super.pluginConfig[t]];return e.assign.push("updateResponseTotalProperty","updateResponseDataProperty","beforePerformSort","beforePerformFilter"),e}updateResponseTotalProperty(e){this.totalCountProperty=e}updateResponseDataProperty(e){this.dataProperty=e}async beforePerformSort(){this.clearLoaded()}async beforePerformFilter(){this.clearLoaded()}async requestData(e){const{totalCountProperty:t,dataProperty:n}=this.lazyLoad,i=await this.internalLoad(e,"Chunk",void 0,!1);return{[t]:i.json[t],[n]:i.data}}async load(e){const{client:t}=this,n=t.params;e&&(t.params={...e,...n}),await super.load(),e&&(t.params=n)}}ml._$name="AjaxStoreLazyLoad";const pl=(e,t)=>(Array.isArray(t[1])?t[1].forEach((n=>e.push(encodeURIComponent(t[0])+"="+encodeURIComponent(n)))):e.push(encodeURIComponent(t[0])+"="+encodeURIComponent(t[1])),e),fl=Promise.resolve(),vl=e=>String(e).padStart(2,"0");class yl extends gl{static $name="AjaxStore";static configurable={responseSuccessProperty:"success",responseDataProperty:"data",responseTotalProperty:"total",params:null,pageSize:50,autoCommitTimeout:10,includeChildrenInRemoveRequest:!0,ignoreLoadPropagationChanges:!1};static get defaultConfig(){return{headers:null,fetchOptions:null,sendAsFormData:null,writeAllFields:null,parentIdParamName:"id",filterParamName:null,restfulFilter:!1,sortParamName:null,pageParamName:null,pageStartParamName:null,pageSizeParamName:"pageSize",useRestfulMethods:null,httpMethods:{create:"POST",read:"GET",update:"PUT",delete:"DELETE"},paramsInBody:G.checkVersion("core","6.0",">=")}}static $lazyLoadPluginClass=ml;modificationsTracking=0;suspendModificationsTracking(){this.modificationsTracking++}resumeModificationsTracking(){this.modificationsTracking--}afterConstruct(e){super.afterConstruct(e),this.autoLoad&&this.load().catch((()=>{}))}get isLoading(){return super.isLoading||this._isLoading?2:!!this.loadTriggerPromise&&1}get isCommitting(){return Boolean(this.commitPromise??this.autoCommitTimeoutPromise)}updatePageSize(e){const t=this;if(!this.isConfiguring){const n=t.currentPage=t.currentPage?Math.min(t.currentPage,Math.floor((t.totalCount+e-1)/e)):1;e&&t.loadPage(n)}}set pageParamName(e){if(this.tree)throw new Error("Paging cannot be supported for tree stores");if(this.pageStartParamName)throw new Error("Configs pageStartParamName and pageParamName are mutually exclusive");this._pageParamName=e}get pageParamName(){return this._pageParamName}set pageStartParamName(e){if(this.tree)throw new Error("Paging cannot be supported for tree stores");if(this.pageParamName)throw new Error("Configs pageParamName and pageStartParamName are mutually exclusive");this._pageStartParamName=e}get pageStartParamName(){return this._pageStartParamName}get isPaged(){return Boolean(this.pageParamName||this.pageStartParamName)}get allCount(){return G.deprecate("core","7.0.0","Deprecated in favor of totalCount"),"remoteTotal"in this?this.remoteTotal:super.allCount}get totalCount(){return"remoteTotal"in this?this.remoteTotal:super.totalCount}get lastPage(){if(this.isPaged)return Math.floor((this.totalCount+this.pageSize-1)/this.pageSize)}buildQueryString(e,...t){const n=e.includes("?"),i=Object.entries(Object.assign({},...t)).reduce(pl,[]).join("&");return i?(n?"&":"?")+i:""}async performSort(e){const t=this;if(t.remoteSort&&!t.isRemoteDataLoading){var n;if(t.isRemoteDataLoading=!0,!1===await(null===(n=t.beforePerformSort)||void 0===n?void 0:n.call(t)))return;const i=await t.load();return t.afterPerformSort(e),t.isRemoteDataLoading=!1,i}super.performSort(e)}async performFilter(e){const t=this;if(t.filterBatching>0)t.needsFiltering=!0;else{if(t.remoteFilter){var n,i;null===(n=t.loadingPromise)||void 0===n||n.abort(),t.isRemoteDataLoading=!0;const r=t.count,{filters:s}=t;if(!1===await(null===(i=t.beforePerformFilter)||void 0===i?void 0:i.call(t,{filters:s,oldCount:r})))return;t.currentPage=1;const o=await t.load(),a=e?null:{action:"filter",filters:s,oldCount:r,records:t.storage.values};return t.afterPerformFilter(a),t.trigger("refresh",a),t.isRemoteDataLoading=!1,o}super.performFilter(e)}}encodeFilterParams(e){const t=[];for(const{property:n,operator:i,value:r,caseSensitive:s}of e)t.push({field:n,operator:i,value:r,caseSensitive:s});return JSON.stringify(t,(function(e,t){return""===e?t:this[e]instanceof Date?`${(n=this[e]).getFullYear()}-${vl(n.getMonth()+1)}-${vl(n.getDate())}T${vl(n.getHours())}:${vl(n.getMinutes())}:${vl(n.getSeconds())}.${n.getMilliseconds()}`:t;var n}))}encodeSorterParams(e){return JSON.stringify(e.filter((e=>!e.sortFn)).map((e=>e)))}buildReadUrl(){const{readUrl:e}=this;if(this.restfulFilter&&this.filters.count){return(e.endsWith("/")?e:e+"/")+this.filters.first.value}return e}internalLoad(e,t,n,i=0){e=W.assign({},this.params,e);const r=this,s={action:"read"+t,params:e,url:r.buildReadUrl()};if(!1===r.trigger("beforeLoad"+t,s))throw!1;return r.loadArgs=[s,e,t,n],!1===i?new Promise(((e,t)=>r.sendLoadRequest(e,t))):r.loadTriggerPromise||(r.loadTriggerPromise=new Promise(((e,t)=>{r.setTimeout({delay:i,fn:"sendLoadRequest",args:[e,t],cancelOutstanding:!0})})))}async sendLoadRequest(e,t){const n=this,[i,r,s,o]=n.loadArgs;if(n.loadTriggerPromise=null,i.url){if(n._isLoading=!0,n.trigger(`load${s}Start`,i),n.trigger("beforeRequest",i),n.filterParamName&&n.isFiltered&&(r[n.filterParamName]=n.encodeFilterParams(n.filters.values)),n.remoteSort&&n.isSorted&&(r[n.sortParamName]=n.encodeSorterParams(n.groupers?n.groupers.concat(n.sorters):n.sorters)),n.isPaged){if(!(n.pageParamName in r)&&!(n.pageStartParamName in r)){const e=Math.min(n.currentPage||1,n.totalCount?n.lastPage:1/0);n.pageParamName?r[n.pageParamName]=e:r[n.pageStartParamName]=(e-1)*n.pageSize}r[n.pageSizeParamName]=n.pageSize}const d={headers:n.headers,parseJson:!0};n.useRestfulMethods&&(d.method=n.httpMethods.read,i.body&&(d.body=JSON.stringify(i.body)));try{var a,l;const u=n.paramsInBody&&("POST"===(null===(a=d.method)||void 0===a?void 0:a.toUpperCase())||"PUT"===(null===(l=d.method)||void 0===l?void 0:l.toUpperCase()))&&null==d.body,h=i.url+(u?"":n.buildQueryString(i.url,r)),g=n.loadingPromise=mi.get(h,W.assign(d,n.fetchOptions,u?{body:JSON.stringify(r)}:null)),m=await g;if(n.isDestroyed)return;const p=m.parsedJson,f=Array.isArray(p),v=f||p&&!1!==W.getPath(p,n.responseSuccessProperty),y=f?null:W.getPath(p,n.responseTotalProperty);if(n.loadingPromise=null,n._isLoading=!1,i.response=m,i.json=p,v){if(null!=y&&(n.remoteTotal=parseInt(y,10)),n.isPaged){if(!(n.remoteTotal>=0))throw new Error("A paged store must receive its responseTotalProperty in each data packet");{const e=n.pageParamName?r[n.pageParamName]:r[n.pageStartParamName]/n.pageSize+1;n.currentPage=Math.min(e,n.lastPage)}}var c;if(i.data=f?p:W.getPath(p,n.responseDataProperty),n.suspendModificationsTracking(),await(null==o?void 0:o(i)),n.resumeModificationsTracking(),n.isPartOfProjectRaw)n.ignoreLoadPropagationChanges&&n.suspendModificationsTracking(),await(null===(c=n.getProject())||void 0===c?void 0:c.commitAsync()),n.ignoreLoadPropagationChanges&&n.resumeModificationsTracking();!n.isDestroyed&&n.trigger("load"+s,i),e(i)}else Object.assign(i,{exception:!0,exceptionType:"server",error:null==p?void 0:p.error}),!n.isDestroyed&&n.trigger("exception",i),t(i);!n.isDestroyed&&n.trigger("afterRequest",i)}catch(e){n._isLoading=!1,i.exception=!0,e instanceof Response?(i.exceptionType=e.ok?"server":"network",i.response=e,i.error=e.error):(i.exceptionType="server",i.error=e),!n.isDestroyed&&n.trigger("exception",i),t(i),!n.isDestroyed&&n.trigger("afterRequest",i)}}}async load(e){const t=this;return t.isPaged?t.loadPage(t.currentPage||1,e):t.internalLoad(e,"",(e=>{t.data=e.data}))}async loadChildren(e){return this.readUrl?this.internalLoad({[this.parentIdParamName]:e.id},"Children",(t=>{t.parentRecord=e,e.children.length&&e.clearChildren(!0),e.data[e.constructor.childrenField]=t.data,e.processChildren(e.stores)}),!1):this.immediatePromise}async loadPage(e,t){this.totalCount&&(e=Math.min(e,this.lastPage));const n=this,i=n.pageParamName?{[n.pageParamName]:e}:{[n.pageStartParamName]:(e-1)*n.pageSize};return i[n.pageSizeParamName]=n.pageSize,n.internalLoad(W.assign(i,t),"Page",(e=>{n.loadData(e.data,"pageLoad")}))}async nextPage(e){const t=this;return t.isPaged&&t.currentPage!==t.lastPage?t.loadPage(t.currentPage+1,e):fl}async previousPage(e){return this.isPaged&&1!==this.currentPage?this.loadPage(this.currentPage-1,e):fl}async commit(){return this.clearTimeout("autoCommit"),this.autoCommitTimeoutPromise=null,this.queueCommit()}queueCommit(){var e;const t=this;let n;return t.commitPromise?n=t.commitPromise.then((()=>t.performCommit())):(t._commitPromiseQueueLength=0,n=t.performCommit()),t._commitPromiseQueueLength+=1,t.commitPromise=null===(e=n)||void 0===e?void 0:e.finally((()=>{t._commitPromiseQueueLength-=1,0===t._commitPromiseQueueLength&&(t.commitPromise=null)}))}performCommit(){const e=this,{changes:t}=e,n=[];if(!t)return e.modified.count&&(e.modified.forEach((e=>e.internalClearChanges(!0,!1))),e.modified.clear()),fl;if(!1!==e.trigger("beforeCommit",{changes:t})){[...t.added,...t.modified,...t.removed].forEach((e=>e.meta.committing=!0)),e.trigger("commitStart",{changes:t});const i={action:"commit",exception:!1,changes:t};let r=e.commitRemoved(i);return r&&n.push(r),r=e.commitAdded(i),r&&n.push(r),r=e.commitModified(i),r&&n.push(r),n.length?(r=1===n.length?n[0]:Promise.all(n),new Promise(((n,s)=>{r.then((()=>{i.exception?(e.trigger("exception",i),s(i)):(e.trigger("commit",{changes:t}),n(i))})).catch((()=>{s(i)}))}))):(e.modified.forEach((e=>e.internalClearChanges(!0,!1))),e.modified.clear(),e.added.forEach((e=>e.internalClearChanges(!0,!1))),e.added.clear(),e.removed.clear(),e.trigger("commit",{changes:t}),fl)}return fl}doAutoCommit(){const e=this;e.suspendCount<=0&&!e.hasTimeout("autoCommit")&&(e.autoCommitTimeoutPromise=new Promise((t=>{e.setTimeout({name:"autoCommit",fn:()=>{e.autoCommitTimeoutPromise=null,e.commit().then().catch((e=>{const{response:t}=e;if(!t||!(t.ok&&t.parsedJson||[500,404].includes(t.status)))throw e})),t()},delay:e.autoCommitTimeout})})))}buildCommitUrl(e){return e+this.buildQueryString(e,this.params)}commitAdded(e){const t=this,n=[...t.added];return n.length&&t.createUrl?new Promise((i=>{const r=n.map((e=>e.persistableData)),s={action:"create",params:t.params,url:t.buildCommitUrl(t.createUrl)};e.create=s,s.body={data:r},t.trigger("beforeRequest",s);let o=s.body;if(t.sendAsFormData){const e=new FormData;e.append("data",JSON.stringify(r)),o=e}const a={headers:t.headers,parseJson:!0};t.useRestfulMethods&&(a.method=t.httpMethods.create),mi.post(s.url,o,W.assign(a,t.fetchOptions)).then((o=>{const a=o.parsedJson,l=Array.isArray(a)||a&&!1!==a.success;if(e.response=o,s.json=a,s.response=o,l){const o=t.processReturnedData(a,n,r);t.added.remove(o),t.modified.add(o.filter((e=>e.meta.modified&&!W.isEmpty(e.meta.modified)))),t.trigger("commitAdded"),t.trigger("refresh",s),i(e)}else n.forEach((e=>e.meta.committing=!1)),e.exception=s.exception=!0,e.exceptionType=s.exceptionType="server",t.trigger("exception",s),i(e);t.trigger("afterRequest",s)})).catch((r=>{n.forEach((e=>e.meta.committing=!1)),e.exception=s.exception=!0,r instanceof Response?(e.response=r,s.exceptionType=r.ok?"server":"network",s.response=r,s.error=r.error):(s.exceptionType="server",s.error=r),!t.isDestroyed&&t.trigger("exception",s),i(e),!t.isDestroyed&&t.trigger("afterRequest",s)}))})):null}commitModified(e){const t=this,n=[...t.changes.modified],i=n.length&&t.updateUrl?new Promise((i=>{const r={action:"update",params:t.params,url:t.buildCommitUrl(t.updateUrl)},s=n.map((e=>t.writeAllFields?e.persistableData:e.modificationDataToWrite)).filter((e=>!W.isEmpty(e)));if(0===s.length)return t.modified.clear(),n.forEach((e=>e.meta.committing=!1)),void i();e.update=r,r.body={data:s},t.trigger("beforeRequest",r);let o=r.body;if(t.sendAsFormData){const e=new FormData;e.append("data",JSON.stringify(s)),o=e}const a={headers:t.headers,parseJson:!0};t.useRestfulMethods&&(a.method=t.httpMethods.update),mi.post(r.url,o,W.assign(a,t.fetchOptions)).then((o=>{const a=o.parsedJson,l=Array.isArray(a)||a&&!1!==a.success;e.response=o,r.json=a,r.response=o,l?(t.processReturnedData(a,n,s,!0,!0),t.trigger("commitModified"),t.trigger("refresh",r),i(e)):(n.forEach((e=>e.meta.committing=!1)),e.exception=r.exception=!0,r.exceptionType="server",t.trigger("exception",r),i(e)),t.trigger("afterRequest",r)})).catch((s=>{n.forEach((e=>e.meta.committing=!1)),e.exception=r.exception=!0,s instanceof Response?(e.response=s,r.exceptionType=s.ok?"server":"network",r.response=s,r.error=s.error):(r.exceptionType="server",r.error=s),!t.isDestroyed&&t.trigger("exception",r),i(e),!t.isDestroyed&&t.trigger("afterRequest",r)}))})):null;return!n.length&&t.modified.count&&t.modified.clear(),i}processReturnedData(e,t,n,i=!1){Array.isArray(e)||(e=W.getPath(e,this.responseDataProperty));const{idField:r}=t[0].constructor,s=!e||e.length===t.length,o=[];return t.forEach(((t,a)=>{var l,c;const d=i?null===(l=e)||void 0===l?void 0:l.find((e=>e[r]===t.id)):null===(c=e)||void 0===c?void 0:c[a];if(s||d){const e=t.modificationDataToWrite,s=i?n.find((e=>e.id===t.id)):n[a],l={};if(t.meta.committing=!1,d&&(t.syncId(d[r]),Object.assign(t.data,this.modelClass.processData(d,i,this,t))),e)for(const n in s)if(e[n]===s[n]){const e=t.getFieldDefinitionFromDataSource(n);null!=e&&e.persist&&(l[e.name]=1)}t.internalClearChanges(!0,!0,l,!0),o.push(t)}})),o}commitRemoved(e){const t=this,{removed:n,includeChildrenInRemoveRequest:i}=t;return n.count&&t.deleteUrl?new Promise((r=>{let s;if(i)s=n.values;else{s=[];for(const e of n.values){var o;const i=e.parentId??(null===(o=e.meta.modified)||void 0===o?void 0:o.parentId);null==i||i!==t.rootNode.id&&n.includes(i)||s.push(e)}}const a={action:"delete",params:t.params,url:t.buildCommitUrl(t.deleteUrl),body:{ids:s.map((e=>e.id))}};e.delete=a,t.trigger("beforeRequest",a);let l=a.body;if(t.sendAsFormData){const e=new FormData;e.append("id",JSON.stringify(l.ids)),l=e}const c={headers:t.headers,parseJson:!0};t.useRestfulMethods&&(c.method=t.httpMethods.delete),mi.post(a.url,l,W.assign(c,t.fetchOptions)).then((i=>{const s=i.parsedJson,o=Array.isArray(s)||s&&!1!==s.success;e.response=i,a.json=s,a.response=i,o?(n.forEach((e=>e.meta.committing=!1)),n.clear(),t.trigger("commitRemoved"),t.trigger("refresh",a),r(e)):(n.forEach((e=>e.meta.committing=!1)),e.exception=a.exception=!0,a.exceptionType="server",t.trigger("exception",a),r(e)),t.trigger("afterRequest",a)})).catch((i=>{n.forEach((e=>e.meta.committing=!1)),e.exception=a.exception=!0,i instanceof Response?(e.response=i,a.exceptionType=i.ok?"server":"network",a.response=i,a.error=i.error):(a.exceptionType="server",a.error=i),!t.isDestroyed&&t.trigger("exception",a),r(e),!t.isDestroyed&&t.trigger("afterRequest",a)}))})):null}get remoteFilter(){return Boolean(this.filterParamName||this.restfulFilter)}get remoteSort(){return Boolean(this.sortParamName)}}yl._$name="AjaxStore";const bl={};class Cl{static get(e,t=bl){const n=e._domData||(e._domData={});return t===bl?n:n[t]}static remove(e,t){const{_domData:n}=e,i=null==n?void 0:n[t];return null==n||delete n[t],i}static set(e,t,n=bl){return n===bl?e._domData=n=t:(e._domData||(e._domData={}))[t]=n,n}static assign(e,t){Object.assign(e._domData||(e._domData={}),t)}}Cl._$name="DomDataStore";class Sl{static $name="CSSHelper";static insertRule(e,t=document.head){const n=this.getStyleSheet(t),{cssRules:i}=n,r=i.length,s="string"==typeof e;if((s?[e]:e).forEach(((e,t)=>n.insertRule(e,t))),i.length>r)return s?i[0]:Array.from(i).slice(0,e.length)}static findRule(e){let t;const n="function"==typeof e;return Array.prototype.find.call(document.head.querySelectorAll("link[rel=stylesheet],style[type*=css]"),(i=>{if(t=Array.prototype.find.call(i.sheet.rules||i.sheet.cssRules,(t=>n?e(t):t.selectorText===e)),t)return!0})),t}static getStyleSheet(e=document.head){return e.$bryntumStylesheet||(e.$bryntumStylesheet=Wn.createElement({tag:"style",type:"text/css",parent:e}).sheet),e.$bryntumStylesheet}static getCSSVersion(){return getComputedStyle(document.documentElement).getPropertyValue("--bryntum-version").replace(/[" ]/gm,"")}}l.register(Sl),Sl._$name="CSSHelper";const Dl=Array.prototype.slice,wl=Object.freeze([]),El=Object.freeze({}),Rl=/[&<]/,{getPrototypeOf:xl}=Object,{toString:Tl}=Object.prototype,{isEqual:Ml,isObject:Il}=W,Al={parent:1,elementData:1,ns:1,syncOptions:1},kl=()=>({ignore:Al,refsFound:new Set}),Fl={class:1,className:1,classname:1},Pl={bigint:1,boolean:1,function:1,number:1,string:1,symbol:1},Ol={tag:1,html:1,text:1,children:1,tooltip:1,parent:1,nextSibling:1,ns:1,reference:1,elementData:1,retainElement:1,compareHtml:1,syncOptions:1,listeners:1,isReleased:1,null:1,"":1,keepChildren:1,retainChildren:1};class Ll{static checkEquality(e,t,n,i){if(e===t)return!0;if(null==e)return null==t;if(!e||!t)return!1;const r=typeof e;if(r!==typeof t||Pl[r])return!1;let s,o,a,l,c,d,u,h=n.equalityCache||(n.equalityCache=new Map),g=Boolean(i);if(h=h.get(e)||h.set(e,new Map).get(e),s=h.get(t),void 0===s){if(s=!0,xl(e)!==xl(t)||e instanceof Node)s=!1;else if(Array.isArray(e)){if(o=e.length,o!==t.length)s=!1;else for(;o-- >0;)if(!Ll.checkEquality(e[o],t[o],n,g)){s=!1;break}}else{var m;for(c in d=e.syncOptions,l=null===(m=d)||void 0===m?void 0:m.ignoreRefs,l&&(g=!0,i="children"!==l),a=n.ignore||El,t)if(!(a[c]||c in e||i&&"reference"===c)){s=!1;break}if(s)if("[object Date]"===Tl.call(t))s=e.getTime()===t.getTime();else if(Wn.isReactElement(e)||Wn.isReactElement(t))s=!1;else for(c in e)if(!(a[c]||i&&"reference"===c)){if(!(c in t)){s=!1;break}if(u=e[c],!Ll.checkEquality(u,t[c],n,g)){s=!1;break}}}var p;if(!i&&Il(e)&&e.reference)null===(p=n.refsFound)||void 0===p||p.add(e.reference);h.set(t,s)}return s}static sync(e){const t=e,{refOwner:n}=e,i=null==n?void 0:n.byRef,r=kl();let s,o,a,l,c=e.affected;if("string"==typeof c&&(c=[c]),e={...e,checkEqualityOptions:r},n){if(n.byRef={},c)for(o in i)c.includes(o)||(n.byRef[o]=i[o]);e.refsWas=i}if(t.changed=Ll.performSync(e,e.targetElement),n)for(c||(c=Object.keys(i)),s=0;s<c.length;++s){var d,u;if(o=c[s],a=i[o],r.refsFound.has(o)||a.retainElement)n.byRef[o]=a;else l=a.lastDomConfig,null===(d=(u=a).blur)||void 0===d||d.call(u),a.remove(),n.detachRef(o,a,l)}return e.targetElement}static performSync(e,t){const{domConfig:n,callback:i}=e,{lastDomConfig:r}=t;return(e.configEquality||Ll.checkEquality)(n,r,e.checkEqualityOptions,e.ignoreRefs)?(null==i||i({action:"none",domConfig:n,targetElement:t}),!1):(n?(n.onlyChildren||(Ll.syncAttributes(n,t,e),Ll.syncContent(n,t)),n.keepChildren||Ll.syncChildren(e,t)):(t.innerHTML=null,t.syncIdMap=null),t.lastDomConfig=null!=n&&n.onlyChildren&&r?{...r,children:n.children}:n,!0)}static syncDataset(e,t){const{lastDomConfig:n}=t,i=e===n,r=Object.keys(e.dataset),s=n&&n.dataset&&Object.keys(n.dataset),o=$e.delta(r,s);let a,l,c,d;for(l=0;l<o.onlyInA.length;l++)a=o.onlyInA[l],d=e.dataset[a],null!=d&&t.setAttribute(`data-${H.hyphenate(a)}`,d);for(l=0;l<o.inBoth.length;l++)a=o.inBoth[l],d=e.dataset[a],(i||d!=n.dataset[a])&&(c=`data-${H.hyphenate(a)}`,null==d?t.removeAttribute(c):t.setAttribute(c,d));for(l=0;l<o.onlyInB.length;l++)t.removeAttribute(`data-${H.hyphenate(o.onlyInB[l])}`)}static addCls(e,t){const{lastDomConfig:n}=t;(e=_t.normalize(e,"array")).forEach((e=>{t.classList.add(e),((e,t)=>{const n="className"in t?"className":"class",i=t[n];if(i)if("string"==typeof i){const r=i.split(" ");r.includes(e)||(r.push(e),t[n]=r.join(" "))}else Array.isArray(i)?i.includes(e)||i.push(e):i.isDomClassList?i.add(e):W.isObject(i)&&(i[e]=1)})(e,n)}))}static removeCls(e,t){const{lastDomConfig:n}=t;(e=_t.normalize(e,"array")).forEach((e=>{t.classList.remove(e),((e,t)=>{const n="className"in t?"className":"class",i=t[n];if(i)if("string"==typeof i){const r=i.split(" ");r.includes(e)&&(r.splice(r.indexOf(e),1),t[n]=r.join(" "))}else Array.isArray(i)?i.includes(e)&&i.splice(i.indexOf(e),1):i.isDomClassList?i.remove(e):W.isObject(i)&&delete i[e]})(e,n)}))}static syncClassList(e,t,n){let i,r,s,o,a,l,c=e.className||e.class,d=!1;if(n){for(r=_t.normalize(t,"array"),c=_t.normalize(c,"object"),l=_t.normalize(n.className||n.class,"object"),a=[],s=0,o=r.length;s<o;++s)i=r[s],c[i]||!(i in l)?(l[i]=1,a.push(i)):d=!0;for(i in c)l[i]||(a.push(i),d=!0);if(!d)return;c=a.join(" ")}else c=_t.normalize(c);t.setAttribute("class",c)}static getSyncAttributes(e){const t={},n=[];return e&&Object.keys(e).forEach((i=>{if(!Ol[i]){const r=i.toLowerCase();t[r]=e[i],n.push(r)}})),{attributes:t,names:n}}static syncAttributes(e,t,n){const{lastDomConfig:i}=t,r=e===i,s=Ll.getSyncAttributes(e),{attributes:o,names:a}=s,{attributes:l,names:c}=r?s:Ll.getSyncAttributes(i),{onlyInA:d,onlyInB:u,inBoth:h}=r?{onlyInA:wl,onlyInB:wl,inBoth:a}:$e.delta(a,c);let g,m,p=!1;for(m=0;m<d.length;m++){g=d[m];const n=o[g];"style"===g&&null!=n?Wn.applyStyle(t,n,!0):"dataset"===g?Ll.syncDataset(e,t):Fl[g]?(Ll.syncClassList(e,t),p=!0):null!=n&&t.setAttribute(g,n)}for(m=0;m<h.length;m++){g=h[m];const i=o[g],s=l[g];null==i?t.removeAttribute(g):"style"===g?n.strict?r?Ll.syncStyles(t,i):Ml(i,s,!0)||Ll.syncStyles(t,i,s):!r&&Ml(i,s,!0)||Wn.applyStyle(t,i,!0):"dataset"===g?Ll.syncDataset(e,t):Fl[g]?(Ll.syncClassList(e,t,n.strict&&t.lastDomConfig),p=!0):(r||i!==s)&&t.setAttribute(g,i)}for(m=0;m<u.length;m++)g=u[m],Fl[g]&&p||t.removeAttribute(g)}static syncStyles(e,t,n){let i,r,s;if(n){if(i={},t=Wn.parseStyle(t),n=Wn.parseStyle(n),t)for(r in t)s=t[r],n[r]!==s&&(i[r]=s);for(r in n)r in t||(i[r]="")}else i=t;Wn.applyStyle(e,i)}static syncContent(e,t){const{html:n,text:i}=e,r=i??n;if(t.didSetTextContent=!1,e.elementData&&(t.elementData=e.elementData),r instanceof DocumentFragment)1===t.childNodes.length&&0===Wn.getChildElementCount(t)&&1===r.childNodes.length&&0===Wn.getChildElementCount(r)?Wn.setInnerText(t,r.firstChild.data):(t.innerHTML="",t.appendChild(r));else if(null!=n&&Rl.test(n))t.innerHTML=String(n);else if(null!=r){var s;const{lastDomConfig:e}=t;(null!=e&&null!==(s=e.children)&&void 0!==s&&s.length||null!=e&&e.html&&Rl.test(t.lastDomConfig.html))&&(t.innerHTML=""),Wn.setInnerText(t,String(r)),t.didSetTextContent=!0}}static insertTextNode(e,t,n,i,r=null){const s=document.createTextNode(e);t.insertBefore(s,r),i&&(s.$refOwnerId=i.id),null==n||n({action:"newNode",domConfig:e,targetElement:s})}static insertElement(e,t,n,i,r,s,o){var a;const l=o.ns?document.createElementNS(o.ns,e.tag||"svg"):document.createElement(e.tag||"div");t.insertBefore(l,n),Ll.performSync(o,l),null!=s&&(r[s]=l),e.role||e.tabIndex||e["aria-hidden"]||Wn.isFocusable(l,!0)||l.htmlFor||l.setAttribute("role","presentation"),i&&(l.$refOwnerId=i.id,s&&(l.$reference=s,i.attachRef(s,l,e))),null===(a=o.callback)||void 0===a||a.call(o,{action:"newElement",domConfig:e,targetElement:l,syncId:s})}static syncChildren(e,t){let n,i,r,{domConfig:s,syncIdField:o,callback:a,releaseThreshold:l,configEquality:c,ns:d,refOwner:u,refsWas:h,strict:g,checkEqualityOptions:m,ignoreRefs:p}=e,f=null;const v=s.syncOptions||{};if(s.html??s.text)return;p=Boolean(v.ignoreRefs??p),p&&(u=h=null),"strict"in v&&(g=v.strict);const y=u?u.byRef:{},b=Dl.call(s.children||[]),C=Dl.call(t.childNodes),S=h||t.syncIdMap||{},D=t.releasedIdMap||{},w=e=>{for(;C.length&&C[0].parentNode!==t;)C.shift();return(e?C.shift():C[0])||null};o=v.syncIdField||o,g=v.strict||g,a=v.callback||a,c=v.configEquality||c,l="releaseThreshold"in v?v.releaseThreshold:l,o&&(t.syncIdMap=y);const E={checkEqualityOptions:m||kl(),ignoreRefs:p,refOwner:u,refsWas:h,strict:g,syncIdField:o,releaseThreshold:l,callback:a,configEquality:c};for(;b.length;){const l=b.shift();if(r=null,!l)continue;if(Wn.isReactElement(l)){a({jsx:l,targetElement:t,domConfig:s});continue}if(Array.isArray(l)){this.syncChildren({...e,domConfig:{...e.domConfig,children:l}},t);continue}if(l instanceof Node){i=w(),l!==i&&t.insertBefore(l,i),n=C.indexOf(l),n>-1&&C.splice(n,1);continue}const c="string"==typeof l;if(E.domConfig=l,E.ns=l.ns||d,!c){if(u?r=l.reference:o&&l.dataset&&(r=l.dataset[o]),null!=r&&!l.unmatched){const e=S[r]||D[r];if(e){const{lastDomConfig:n}=e;if(e.retainElement);else if(Ll.performSync(E,e)){var R;null===(R=a)||void 0===R||R({action:"reuseOwnElement",domConfig:l,targetElement:e,lastDomConfig:n,syncId:r})}l.retainElement&&(e.retainElement=!0),y[r]=e,$e.remove(C,e),delete D[r],e.isReleased=!1,i=w(),(e.parentNode!==t||g&&e.nextSibling!==i)&&t.insertBefore(e,i)}else g?Ll.insertElement(l,t,w(),u,y,r,E):(b.push(l),l.unmatched=!0);continue}l.unmatched&&delete l.unmatched}let h,m=null,p=null;for(;!p&&(h=w(!0));){if(u){if(h.$refOwnerId!==u.id)continue;if(h.$reference){if(!g)continue;m=h;break}p=h}else h.retainElement||(p=h);p||(f||(f=[])).push(h)}if(m||!p)c?Ll.insertTextNode(l,t,a,u,m):Ll.insertElement(l,t,m,u,y,r,E);else if(c||p.nodeType!==Node.ELEMENT_NODE||(l.tag||"div").toLowerCase()!==p.tagName.toLowerCase())if(c&&p.nodeType===Node.TEXT_NODE)p.data=l;else{var x,T;c?Ll.insertTextNode(l,t,a,u,p):Ll.insertElement(l,t,p,u,y,r,E),null===(x=(T=p).blur)||void 0===x||x.call(T),p.remove()}else{var M,I;const{lastDomConfig:e}=p,t=Ll.performSync(E,p);if(o&&null!=(null==e||null===(M=e.dataset)||void 0===M?void 0:M[o])){const t=e.dataset[o];delete D[t],delete S[t]}null!=r&&(y[r]=p),p.isReleased=!1,t&&(null===(I=a)||void 0===I||I({action:"reuseElement",domConfig:l,targetElement:p,lastDomConfig:e,syncId:r}))}}if(!(t.didSetTextContent&&1===C.length&&C[0].nodeType===Node.TEXT_NODE||s.retainChildren)){for(;i=w(!0);)u&&(i.$refOwnerId!==u.id||i.$reference)||(f||(f=[])).push(i);f&&Ll.syncChildrenCleanup(t,f,y,a,u,l,o)}}static syncChildrenCleanup(e,t,n,i,r,s,o){let a,l=0;for(const d of t){const{lastDomConfig:t}=d;var c;if(d.nodeType!==Element.TEXT_NODE)if(d.retainElement)o&&t&&(n[d.dataset[o]]=d);else if(!r&&o&&(null==s||l<s))d.isReleased||(d.className="b-released",d.isReleased=!0,null!=t&&t.dataset&&(e.releasedIdMap||(e.releasedIdMap={}),e.releasedIdMap[t.dataset[o]]=d),null==i||i({action:"releaseElement",domConfig:t,lastDomConfig:t,targetElement:d}),t&&(t.isReleased=!0,t.className&&(t.className="b-released"),t.class&&(t.class="b-released"),t.style&&(t.style=null))),l++;else null===(c=d.blur)||void 0===c||c.call(d),d.remove(),r&&(a=d.$reference,a&&r.detachRef(a,d,t)),e.releasedIdMap&&o&&null!=t&&t.dataset&&delete e.releasedIdMap[t.dataset[o]],null==i||i({action:"removeElement",domConfig:d.lastDomConfig,lastDomConfig:d.lastDomConfig,targetElement:d});else d.remove()}}static removeChild(e,t){if(e.contains(t)){const n=e.syncIdMap;if(n){const e=Object.values(n).indexOf(t);e>-1&&delete n[Object.keys(n)[e]]}e.removeChild(t)}}static addChild(e,t,n){e.appendChild(t),e.syncIdMap||(e.syncIdMap={}),e.syncIdMap[n]=t}static getChild(e,t){const n=String(t).split(".");for(const t of n){var i;if(!(e=null===(i=e)||void 0===i||null===(i=i.syncIdMap)||void 0===i?void 0:i[t]))return null}return e}}Ll._$name="DomSync";class $l{static init(){const e=["fullscreenEnabled","requestFullscreen","exitFullscreen","fullscreenElement"],t=t=>e.map((e=>{let n=t+H.capitalize(e);return"moz"===t&&(n=n.replace("screen","Screen"),"mozCancelFullScreen"in document&&"exitFullscreen"===e&&(n="mozCancelFullScreen")),n}));this.functions="fullscreenEnabled"in document&&e||"webkitFullscreenEnabled"in document&&t("webkit")||"mozFullScreenEnabled"in document&&t("moz")||"msFullscreenEnabled"in document&&t("ms")||[];const n=["fullscreenchange","fullscreenerror"],i=e=>n.map((t=>e+H.capitalize(t)));this.events="fullscreenEnabled"in document&&n||"webkitFullscreenEnabled"in document&&i("webkit")||"mozFullscreenEnabled"in document&&i("moz")||"msFullscreenEnabled"in document&&["MSFullscreenChange","MSFullscreenError"]||[],this.onFullscreenChange(this.onInternalFullscreenChange.bind(this))}static get enabled(){return Boolean(this.functions[0]&&document[this.functions[0]])}static async request(e){return this.functions[1]&&(null==e?void 0:e[this.functions[1]]())}static async exit(){return this.functions[2]&&document[this.functions[2]]()}static get isFullscreen(){return!!this.element}static get element(){return this.functions[3]&&document[this.functions[3]]}static onFullscreenChange(e){this.events[0]&&document.addEventListener(this.events[0],e)}static unFullscreenChange(e){this.events[0]&&document.removeEventListener(this.events[0],e)}static onInternalFullscreenChange(){const e=globalThis.bryntum,{element:t}=$l;if(!($l.isFullscreen&&e._floatRoot||!$l.isFullscreen&&!e._floatRoot))if(t){if(!t.closest(".b-floatroot")){const n=Wn.getRootElement(t),{floatRoot:i}=n;i&&(e._floatRoot=i,e._oldParent=i.parentElement,t.appendChild(i))}}else e._floatRoot&&e._oldParent.appendChild(e._floatRoot),e._oldParent=null,e._floatRoot=null}}$l.init(),$l._$name="Fullscreen";let _l=null;const jl=[],Bl=e=>{var t;return e.nodeType===e.ELEMENT_NODE&&"absolute"===(null===(t=e.ownerDocument.defaultView)||void 0===t?void 0:t.getComputedStyle(e).getPropertyValue("position"))};class Hl{static addResizeListener(e,t){const n=this;if(e!==document&&e!==globalThis||(e=document.body),e.nodeType===e.DOCUMENT_FRAGMENT_NODE&&(e=e.host),e.classList.contains("b-resize-monitored")||(e.classList.add("b-resize-monitored"),e._bResizemonitor={handlers:[]}),e===document.body)n.hasWindowResizeListener||(globalThis.addEventListener("resize",n.onWindowResize),n.hasWindowResizeListener=!0);else if(globalThis.ResizeObserver)n.resizeObserver||(n.resizeObserver=new ResizeObserver(n.onElementResize)),n.resizeObserver.observe(e);else{e.classList.add("b-no-resizeobserver");const[i,r,s]=Wn.createElement({parent:e,className:"b-resize-monitors",children:[{className:"b-resize-monitor-expand"},{className:"b-resize-monitor-shrink"}]},{returnAll:!0});r.scrollLeft=r.scrollTop=s.scrollLeft=s.scrollTop=1e6,r.addEventListener("scroll",n.onSizeMonitorScroll,!0),s.addEventListener("scroll",n.onSizeMonitorScroll,!0),(t.targetMutationMonitor=new MutationObserver((e=>{const t=[],n=[];for(const i of e)"childList"===i.type&&(t.push.apply(t,i.addedNodes),n.push.apply(n,i.removedNodes));const i=[...t.filter((e=>!n.includes(e))),...n.filter((e=>!t.includes(e)))];0!==i.length&&(i.length>0&&i.every(Bl)||r.dispatchEvent(new CustomEvent("scroll",{bubbles:!1})))}))).observe(e,{childList:!0,subtree:!0}),t.monitorElement=i}e._bResizemonitor.handlers.push(t)}static removeResizeListener(e,t){if(e){e!==document&&e!==globalThis||(e=document.body);const n=e._bResizemonitor;let i=0;n&&n.handlers&&($e.remove(n.handlers,t),i=n.handlers.length),i||(e.classList.remove("b-resize-monitored"),this.resizeObserver?this.resizeObserver.unobserve(e):(t.monitorElement&&(t.monitorElement.remove(),t.monitorElement=null),t.targetMutationMonitor&&t.targetMutationMonitor.disconnect()))}}static onElementResize(e){for(const t of e){const e=t.target,n=e._bResizemonitor,i=t.contentRect||e.getBoundingClientRect();if(An(e)&&(!n.rectangle||i.width!==n.rectangle.width||i.height!==n.rectangle.height)){const t=n.rectangle;n.rectangle=i;for(const r of n.handlers)r(e,t,i)}}}static onSizeMonitorScroll(e){var t;if(e.target.isConnected||null!==(t=document.body)&&void 0!==t&&t.contains(e.target)){e.stopImmediatePropagation();const t=e.target.parentNode,n=t.parentNode,i=n._bResizemonitor,r=n.getBoundingClientRect();i.rectangle&&r.width===i.rectangle.width&&r.height===i.rectangle.height||(jl.push([n,i.rectangle,r]),i.rectangle=r,_l||(_l=requestAnimationFrame(Hl.fireResizeEvents))),t.firstChild.scrollLeft=t.firstChild.scrollTop=t.childNodes[1].scrollTop=t.childNodes[1].scrollLeft=1e6}}static onWindowResize(e){const t=document.body,n=t._bResizemonitor,i=n.rectangle;n.rectangle=document.documentElement.getBoundingClientRect();for(const e of n.handlers)e(t,i,n.rectangle)}static fireResizeEvents(){for(const e of jl)for(const t of e[0]._bResizemonitor.handlers)e[0].offsetParent&&t.apply(this,e);_l=null,jl.length=0}static removeGlobalListeners(){globalThis.removeEventListener("resize",this.onWindowResize)}}Hl._$name="ResizeMonitor";const Vl={auto:"auto",true:"auto",false:"hidden","hidden-scroll":"auto",clip:d.supportsOverflowClip?"clip":"hidden"},zl="b-widget-scroller",Nl={block:"nearest"},Wl=Promise.resolve(),Ul=e=>new Promise((t=>Xt.on({element:e===document.documentElement?globalThis:e,scroll:t,once:!0}))),Gl={x:1},Yl={auto:1,scroll:1},ql={true:1,auto:1},Kl={overflowX:"auto",overflowY:"auto"};class Xl extends(Ir(at(Pe))){static get configurable(){return{widget:null,element:{$config:{nullify:!0},value:null},contentElement:{$config:{nullify:!0},value:null},overflowX:null,overflowY:null,translate:null,behavior:null,x:0,y:0,rtlSource:null,propagateSync:null}}static get delayable(){return{onScrollEnd:{type:"buffer",delay:100}}}get isRTL(){var e;return Boolean(null===(e=this.rtlSource)||void 0===e?void 0:e.rtl)}syncOverflowState(){const e=this,{hasOverflowX:t,hasOverflowY:n,element:i}=e,r=e.hasOverflowX=i.scrollWidth>i.clientWidth,s=e.hasOverflowY=i.scrollHeight>i.clientHeight;if(t!==r||n!==s){const t=new _t(i.classList,{"b-horizontal-overflow":r,"b-vertical-overflow":s});Wn.syncClassList(i,t),e.isConfiguring||e.trigger("overflowChange",{x:r,y:s})}}hasOverflow(e="y"){const t=this,n=t[`overflow${e.toUpperCase()}`],i=t["overflow"+("y"===e?"x":"y")];if(!Wn.scrollBarWidth||!ql[n]||"hidden-scroll"===i){const n="y"===e?"Height":"Width";return t[`scroll${n}`]>t[`client${n}`]}return t[`hasOverflow${e.toUpperCase()}`]}hasScrollbar(e="y"){const{element:t}=this;if(t&&Wn.scrollBarWidth){const n="y"===e,i=n?"Width":"Height",r=t[`client${i}`],s=parseInt(Wn.getStyleValue(t,`border${n?"Left":"Top"}Width`))+parseInt(Wn.getStyleValue(t,`border${n?"Right":"Bottom"}Width`)),o=t[`offset${i}`]-s-r;return Math.abs(o-Wn.scrollBarWidth)<2}}addPartner(e,t=Gl){const n=this;"string"==typeof t&&(t={[t]:1}),n.partners||(n.partners={}),n.partners[e.id]={scroller:e,axes:t},t.x&&(e.x=n.x),t.y&&(e.y=n.y),e.isPartneredWith(n)||e.addPartner(n,t)}eachPartner(e){const{partners:t}=this;t&&Object.values(t).forEach(e)}removePartner(e){e&&this.isPartneredWith(e)&&(delete this.partners[e.id],e.removePartner(this))}isPartneredWith(e){var t;return Boolean(null===(t=this.partners)||void 0===t?void 0:t[e.id])}clearPartners(){this.partners&&Object.values(this.partners).forEach((e=>e.scroller.removePartner(this)))}async scrollIntoView(e,t=Nl){const n=this,{isRectangle:i}=e,r=i?e:Pt.from(e),{xDelta:s,yDelta:o}=n.getDeltaTo(e,t),a=n.scrollBy(s,o,t);return(t.highlight||t.focus)&&a.then((()=>{var a;e=i?r.translate(-s,-o):(null===(a=t.elementAfterScroll)||void 0===a?void 0:a.call(t))??e,t.highlight&&(isNaN(t.highlight)?(n.widget||n).callback(t.highlight,null,[e]):Wn.highlight(e,n)),t.focus&&e.focus({preventScroll:!0})})),a}static async scrollIntoView(e,t=Nl,n=!1){const i=Pt.from(e),r="object"==typeof t?t.animate:t,s=Xl._globalScroller||(Xl._globalScroller=new Xl),o=[];s.rtlSource={rtl:n};let a,l=0,c=0;t.maxWidth&&(i.width=Math.min(i.width,t.maxWidth),t.maxWidth=null),t.maxHeight&&(i.height=Math.min(i.height,t.maxHeight),t.maxHeight=null);for(let n=e.parentNode;n.nodeType===Node.ELEMENT_NODE;n=n.parentNode){if(n===document.body&&n!==document.scrollingElement)continue;const e=n===document.scrollingElement?Kl:n.ownerDocument.defaultView.getComputedStyle(n),r=Cl.get(n,"scroller");if(!1!==t.y&&(null!=r&&r.hasOverflowY||Yl[e.overflowY]&&n.scrollHeight>n.clientHeight)||!1!==t.x&&(null!=r&&r.hasOverflowX||Yl[e.overflowX]&&n.scrollWidth>n.clientWidth)){let e=s;r?e=r:(s.element=n,s.positionDirty=!0);const{xDelta:a,yDelta:d}=e.getDeltaTo(i,t);(a||d)&&(o.push({element:n,x:n.scrollLeft,y:n.scrollTop,xDelta:a,yDelta:d}),i.translate(-a,-d),l+=a,c+=d)}}if(o.length){const e=Math.abs(l),t=Math.abs(c);let i=r&&("number"==typeof r?r:"number"==typeof r.duration?r.duration:300);if(i&&(e>10||t>10))Math.max(e,t)<50&&(i=Math.min(i,500)),a=s.scrollAnimation=Ne.animate(i,(e=>{const t=1===e;for(const{element:i,x:r,y:a,xDelta:l,yDelta:c}of o)s.element=i,l&&(s.x=Math[n?"min":"max"](r+(t?l:Math.round(l*e)),0)),c&&(s.y=Math.max(a+(t?c:Math.round(c*e)),0))}),null,r.easing),a.then((()=>{s.scrollAnimation=null}));else if(e>=1||t>=1){for(const{element:e,xDelta:t,yDelta:n}of o)e.scrollTop+=n,e.scrollLeft+=t;return Ul(o[o.length-1].element)}}else a=Wl;return(t.highlight||t.focus)&&a.then((()=>{t.highlight&&(isNaN(t.highlight)?s.callback(t.highlight,null,[e]):Wn.highlight(e,s)),t.focus&&e.focus({preventScroll:!0})})),a}scrollBy(e=0,t=0,n=Nl){const i=this,r="object"==typeof n?n.animate:n,s=Math.abs(e),o=Math.abs(t);i.scrollAnimation&&(i.scrollAnimation.cancel(),i.scrollAnimation=null),(e||t)&&(i.silent=n.silent);let a=r&&("number"==typeof r?r:"number"==typeof r.duration?r.duration:300);if(a&&(s>10||o>10)){const{x:l,y:c}=i;let d=l,u=c;return Math.max(s,o)<50&&(a=Math.min(a,500)),i.scrollAnimation=Ne.animate(a,(r=>{const s=1===r;if(e){var o;if(Math.abs(i.x-d)>1&&!n.force)return null===(o=i.scrollAnimation)||void 0===o?void 0:o.cancel();i.x=Math.max(l+(s?e:Math.round(e*r)),0)}if(t){var a;if(Math.abs(i.y-u)>1&&!n.force)return null===(a=i.scrollAnimation)||void 0===a?void 0:a.cancel();i.y=Math.max(c+(s?t:Math.round(t*r)),0)}d=i.x,u=i.y}),i,r.easing),i.element.classList.add("b-scrolling"),i.scrollAnimation.then((()=>{i.isDestroyed||(i.element.classList.remove("b-scrolling"),i.scrollAnimation=null)})),i.scrollAnimation}if(e||t){const n=i.x,r=i.y;if(Math.round(s)>=1&&(i.x+=e),Math.round(o)>=1&&(i.y+=t),i.x!==n||i.y!==r)return Ul(i.element)}return Wl}async scrollTo(e,t,n){const{x:i,y:r}=this,s=null==e?0:e-i,o=null==t?0:t-r;return this.scrollingToCenter=null==n?void 0:n.scrollingToCenter,this.scrollBy(s,o,n)}doDestroy(){var e;const t=this;var n;t._element&&(t._element.removeEventListener("scroll",t.scrollHandler),null===(n=t.wheelListenerRemover)||void 0===n||n.call(t));null===(e=t.scrollAnimation)||void 0===e||e.cancel(),Object.values(t.partners||{}).forEach((({scroller:e})=>e.removePartner(t))),super.doDestroy()}onElMutation(e){const t=this,[n,i]=Wn.getTranslateXY(t.element);if(t._x!==-n||t.y!==-i){const e=new CustomEvent("scroll",{bubbles:!0});Object.defineProperty(e,"target",{get:()=>t.element}),t.onScroll(e)}}onElResize(){const e=this,{widget:t}=e;null!=t&&t.isAnimating?-1===t.findListener("animationend","onElResize",e)&&t.ion({animationEnd:"onElResize",thisObj:e,once:!0}):e.syncOverflowState()}onScroll(e){const t=this,{_x:n,_y:i,element:r}=t;let s=0;"clip"===t.overflowX&&r.scrollLeft!==n&&(r.scrollLeft=n,++s),"clip"===t.overflowY&&r.scrollTop!==i&&(r.scrollTop=i,++s),2!==s&&(t.widget&&t.widget.isDestroyed||(t.positionDirty=!0,r.classList.contains("b-scrolling")||r.classList.add("b-scrolling"),e.widget=t.widget,e.scrollingToCenter=t.scrollingToCenter,t.silent||t.trigger("scroll",e),t.syncPartners(),t.controllingPartner=null,t.onScrollEnd(e)))}syncPartners(e,t=this.propagateSync){const n=this;n.partners&&Object.values(n.partners).forEach((({axes:i,scroller:r})=>{(r!==n.controllingPartner||e)&&r.sync(n,i)&&t&&r.syncPartners(e,t)}))}onScrollEnd(e){const t=this;t.silent&&(t.silent=!1),t.trigger("scrollEnd",e),t.scrollingToCenter=!1,t.controllingPartner=null,t.element.classList.remove("b-scrolling")}getDeltaTo(e,t){const n=this;if(!n.viewport)return{xDelta:0,yDelta:0};const{x:i,y:r,scrollWidth:s,scrollHeight:o,isRTL:a}=n,l=e instanceof Pt?e:Pt.from(e),c=t.block||"nearest",d=n.viewport,u=(e=>{let t,n,i,r;return e?"number"==typeof e?t=n=i=r=e:(t=e.top??0,n=e.bottom??0,i=e.start??0,r=e.end??0):t=n=i=r=0,{top:t,bottom:n,start:i,end:r}})(t.edgeOffset);t.maxWidth&&(l.x<d.x?(l.x=l.right-t.maxWidth,u.start=0):(l.width=Math.min(l.width,t.maxWidth),u.end=0)),t.maxHeight&&(l.y<d.y?(l.y=l.bottom-t.maxHeight,u.top=0):(l.height=Math.min(l.height,t.maxHeight),u.bottom=0));const h=!1!==t.x&&d.width>=l.width+(u.start+u.end)?u:{start:0,end:0},g=!1!==t.y&&d.height>=l.height+(u.top+u.bottom)?u:{top:0,bottom:0},m=new Pt(a?d.right+i-s:d.x-i,d.y-r,s,o),p=l.clone().adjust(-h.start,-g.top,h.end,g.bottom,!0).constrainTo(m),f=p.clone(),v=n.isRTL?-1:1;let y=0,b=0;if("start"===c)f.moveTo(d.x+(n.isRTL?d.width-f.width:0),d.y),y=p.x-f.x,b=p.y-f.y;else if("end"===c)f.moveTo(d.x+(n.isRTL?0:d.width-f.width),d.bottom-f.height),y=p.x-f.x,b=p.y-f.y;else if("center"===c){const e=d.center;f.moveTo(e.x-f.width/2,e.y-f.height/2),y=y||p.x-f.x,b=b||p.y-f.y}else f.width>d.width?y=f.x-d.x:f.right>d.right?y=f.right-d.right:f.x<d.x&&(y=f.x-d.x),f.height>d.height?b=f.y-d.y:f.bottom>d.bottom?b=f.bottom-d.bottom:f.y<d.y&&(b=f.y-d.y);return y=v*Math.round(y),b=Math.round(b),!1!==t.constrainToScrollable&&(y=Math.max(Math.min(y,n.maxX-i),-i),b=Math.max(Math.min(b,n.maxY-r),-r)),{xDelta:!1===t.x?0:y,yDelta:!1===t.y?0:b}}get viewport(){return Pt.client(this.element)}updateWidget(e){this.rtlSource=this.owner=e}updateElement(e,t){const n=this;if(n===Xl._globalScroller)return n._element=e,void(n.positionDirty=!0);const i=n.scrollHandler||(n.scrollHandler=n.onScroll.bind(n)),r=n.resizeHandler||(n.resizeHandler=n.onElResize.bind(n));if(t){var s;if(Cl.remove(t,"scroller"),n.translate)null===(s=n.mutationObserver)||void 0===s||s.disconnect();else t.removeEventListener("scroll",i),t.classList.remove(zl),t.style.overflowX=t.style.overflowY="";Hl.removeResizeListener(t,r)}if(e){if(Cl.set(e,"scroller",n),n.translate){if(n.mutationObserver||(n.mutationObserver=new MutationObserver(n.mutationHandler||(n.mutationHandler=n.onElMutation.bind(n)))),n._x=n._y=0,document.contains(e)){const[t,i]=Wn.getTranslateXY(e);n._x=-t,n._y=-i}n.mutationObserver.observe(e,{attributes:!0})}else e.addEventListener("scroll",i),e.classList.add(zl);Hl.addResizeListener(e,r),n.widget||(n.rtlSource={get rtl(){return"rtl"===Wn.getStyleValue(e,"direction")}}),n.isRTL&&e.classList.add("b-rtl"),n.positionDirty&&(n.updateOverflowX(n.overflowX),n.updateOverflowY(n.overflowY)),n.syncOverflowState(),n.isConfiguring&&(n._x&&n.updateX(n._x),n._y&&n.updateY(n._y))}n.positionDirty=!0}get x(){const e=this,{element:t}=e;if(t&&e.positionDirty){if(e.translate){const[n,i]=Wn.getTranslateXY(t);e._x=-n,e._y=-i}else e._x=Math.abs(t.scrollLeft),e._y=t.scrollTop;e.positionDirty=!1}return e._x}get scrollLeft(){return this.x*(this.isRTL?-1:1)}changeX(e){if(e=Math.max(e,0),!this.isConfiguring||e)return e;this._x=e}updateContentElement(e){e&&(e="string"==typeof e?this.element.querySelector(e):e,Hl.addResizeListener(e,this.resizeHandler))}updateX(e){var t;const n=this,{behavior:i,element:r}=n;!r||null!==(t=n.widget)&&void 0!==t&&t.isConfiguring||(e=Math.round(e),n.trigger("scrollStart",{x:e}),n.translate?Wn.setTranslateX(r,-e):i?r.scrollTo({behavior:i,left:n.isRTL?-e:e}):r.scrollLeft=n.isRTL?-e:e),n.positionDirty=!0}sync(e,t){const n=this,{x:i,y:r}=t;let s=!1;return i&&n.x!==e.x&&(n.controllingPartner=e,n.x=e.x,s=!0),r&&n.y!==e.y&&(n.controllingPartner=e,n.y=e.y,s=!0),s}get y(){const e=this,{element:t}=e;if(t&&e.positionDirty){if(e.translate){const[n,i]=Wn.getTranslateXY(t);e._x=-n,e._y=-i}else e._x=t.scrollLeft,e._y=t.scrollTop;e.positionDirty=!1}return e._y}changeY(e){if(!this.isConfiguring||e)return e;this._y=e}updateY(e){const t=this,{behavior:n,element:i,widget:r}=t;!i||null!=r&&r.isConfiguring||(t.trigger("scrollStart",{y:e}),t.translate?Wn.setTranslateY(i,-e):n?i.scrollTo({behavior:n,top:e}):i.scrollTop=e),t.positionDirty=!0}get maxX(){return this.scrollWidth-this.clientWidth}get maxY(){return this.scrollHeight-this.clientHeight}get lastScrollLeft(){return(this.scrollWidth-this.clientWidth)*(this.isRTL?-1:1)}updateOverflowX(e,t){const n=this,{element:i,translate:r}=n,{style:s,classList:o}=i;if("hidden-scroll"===t&&o.remove("b-hide-scroll"),"hidden-scroll"===e&&!r){Yl[n.overflowY]?(e="hidden",n.enableWheel()):o.add("b-hide-scroll")}r||(s.overflowX=Vl[e]||e),n.isConfiguring||(n.positionDirty=!0,n.syncOverflowState())}updateOverflowY(e,t){const n=this,{element:i,translate:r}=n,{style:s,classList:o}=i;if("hidden-scroll"===t&&o.remove("b-hide-scroll"),"hidden-scroll"===e&&!r){Yl[n.overflowX]?(e="hidden",n.enableWheel()):o.add("b-hide-scroll")}r||(s.overflowY=Vl[e]||e),n.isConfiguring||(n.positionDirty=!0,n.syncOverflowState())}enableWheel(){this.wheelListenerRemover||(this.wheelListenerRemover=Xt.on({element:this.element,wheel:"onWheel",thisObj:this}))}onWheel(e){const t=this,{overflowX:n,overflowY:i}=t,r=e.deltaX,s=e.deltaY,o=Math.abs(r)-Math.abs(s);"hidden-scroll"===n&&Yl[i]&&o>0?t.x+=r:"hidden-scroll"===i&&Yl[n]&&o<0&&(t.y+=s)}get scrollWidth(){var e;return(null===(e=this.element)||void 0===e?void 0:e.scrollWidth)??0}set scrollWidth(e){const t=this,{element:n,isRTL:i}=t;let r=t.widthStretcher;r&&null==e?(r.remove(),t.widthStretcher=null):e&&(e=Math.abs(e),r||(r=t.widthStretcher=Wn.createElement({className:"b-scroller-stretcher b-horizontal-stretcher",retainElement:!0})),r.style.transform=`translateX(${(e-1)*(i?-1:1)}px)`,n&&!n.contains(r)&&n.insertBefore(r,n.firstElementChild)),!1!==t.propagate&&t.eachPartner((({scroller:t})=>{t.propagate=!1,t.scrollWidth=e,delete t.propagate})),t.positionDirty=!0,t.syncOverflowState()}get scrollHeight(){var e;return(null===(e=this.element)||void 0===e?void 0:e.scrollHeight)??0}set scrollHeight(e){const t=this,n=t.stretcher||(t.stretcher=Wn.createElement({className:"b-scroller-stretcher"}));n.style.transform=`translateY(${e-1}px)`,t.element&&t.element.lastChild!==n&&t.element.appendChild(n),t.positionDirty=!0,t.syncOverflowState()}get clientWidth(){var e;return(null===(e=this.element)||void 0===e?void 0:e.clientWidth)||0}get clientHeight(){var e;return(null===(e=this.element)||void 0===e?void 0:e.clientHeight)||0}get id(){return this._id||(this.widget?this._id=`${this.widget.id}-scroller`:this._id=Bs.generateId("scroller-")),this._id}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(),delete e.widget,delete e.element}}Xl._$name="Scroller";var Zl=e=>class extends(e||Pe){static $name="KeyMap";static configurable={keyMap:{value:null,$config:{merge:"objects",nullify:!0}}};get widgetClass(){}get keyMapElement(){return this.element}get keyMapSubComponents(){return this.features}matchKeyMapEntry(e,t=this.keyMap){if(t&&!e.handled&&void 0!==e.key)return W.keys(t).find((t=>{const{altKey:n,ctrlKey:i,metaKey:r,shiftKey:s}=e,o=t.toLowerCase().split("+"),a=t.endsWith("+")?"+":o.pop(),l="space"===a?" ":a,c=o.includes("alt"),d=o.includes("ctrl"),u=o.includes("meta"),h=o.includes("shift");return l===e.key.toLowerCase()&&(c?n:!n)&&(d?i:!i)&&(u?r:!r)&&(h?s:!s)}))}performKeyMapAction(e){const t=this,{keyMap:n}=t;let i,r,s,o,a=!1;if(n&&!e.handled&&void 0!==e.key){const h=t.matchKeyMapEntry(e);if(n[h]){const r=$e.asArray(n[h]);for(i of(e.fromKeyMap=!0,e.widget=this,r)){if(o=!0,W.isObject(i)){if(!i.handler)continue;!1===i.preventDefault&&(o=!1),i=i.handler}if("string"==typeof i){var l;const{thisObj:n,handler:r}=t.resolveKeyMapAction(i);if(!1!==(null===(l=n.isActionAvailable)||void 0===l?void 0:l.call(n,{key:h,action:i,event:e,actionName:i.split(".").pop()}))&&!1!==r.call(n,e)){a=!0;break}}else if(!1!==i.call(t,e)){a=!0;break}}a&&(o&&e.preventDefault(),e.handled=!0)}if(!a&&(s=W.getTruthyKeys(n.delegate)))for(r of s){var c,d,u;if(r=W.getPath(t,r),a=null===(c=r)||void 0===c||null===(d=(u=c).performKeyMapAction)||void 0===d?void 0:d.call(u,e),a)break}}return a}resolveKeyMapAction(e){const t=this,{keyMapSubComponents:n}=t;if(e.startsWith("up.")||e.startsWith("this."))return t.resolveCallback(e);if(n&&e.includes(".")){const[t,i]=e.split(".");if(t&&i)return{thisObj:n[t],handler:n[t][i]}}return{thisObj:t,handler:t[e]}}updateKeyMap(e){var t;const n=this,i=W.keys(e);null===(t=n.keyMapDetacher)||void 0===t||t.call(n),n.keyMapDetacher=i.length?Xt.on({element:n.keyMapElement,keydown:"keyMapOnKeyDown",thisObj:n}):null}keyMapOnKeyDown(e){this.performKeyMapAction(e)}mergeKeyMaps(e,t,n=null){const i={};e&&W.assign(i,e);for(const r in t){if(!t[r])continue;const s=$e.asArray(null==e?void 0:e[r]),o=[];if(null!=s&&s.length&&o.push(...s),null==s||!s.some((e=>{const t=e.handler?e.handler:e;return"string"==typeof t&&t.startsWith(n+".")}))){for(const e of $e.asArray(t[r]))W.isObject(e)&&e.handler?o.push(W.assignIf({handler:(n?n+".":"")+e.handler},e)):"function"==typeof e?o.push(e):o.push((n?n+".":"")+e);o.sort(((e,t)=>{const n=(e.weight||0)-(t.weight||0);return 0===n&&null!=s&&s.length?s.indexOf(e)-s.indexOf(t):n}))}i[r]=o}return i}},Jl=e=>class extends(e||Pe){static $name="RTL";get widgetClass(){}static configurable={rtl:null};get isRTL(){return this.rtl}updateRtl(e){const{element:t}=this;t&&(t.classList.toggle("b-rtl",!0===e),t.classList.toggle("b-ltr",!1===e))}startConfigure(e){var t;if(null===(t=super.startConfigure)||void 0===t||t.call(this,arguments),!e.floating&&null==e.rtl){var n;const t=this,i=e.rootElement||e.forElement||(null===(n=t.parent)||void 0===n?void 0:n.contentElement)||(t.floating?t.floatRoot:t.changeElementRef(t.getRenderContext(e)[0]||e.adopt));if(i)e.rtl=1===i.nodeType&&"rtl"===getComputedStyle(i).getPropertyValue("direction");else{const t=e.owner||e.parent;e.rtl=t?t[t.isConfiguring?"peekConfig":"getConfig"]("rtl"):"rtl"===getComputedStyle(document.body).getPropertyValue("direction")}e.rtl&&(t.configDone.rtl=!1)}}render(...e){var t,n,i;(null===(t=super.render)||void 0===t||t.call(this,...e),(d.isChrome&&d.chromeVersion<87||d.isFirefox&&d.firefoxVersion<66||d.isSafari&&d.safariVersion<14.1)&&this.element.classList.add("b-legacy-inset"),"rtl"===getComputedStyle(this.element).direction||null!==(n=this.owner)&&void 0!==n&&n.rtl)&&(this.rtl=!0,null===(i=this.childItems)||void 0===i||i.forEach((e=>e.rtl=!0)))}};const Ql=Object.freeze({highlight:!1,onlyName:!1}),ec=Object.freeze([]),tc=Object.freeze({sync:!1}),nc=[],ic=["clip","display","opacity"],rc="highlightExternalChange",sc=/transparent|rgba\(0,\s*0,\s*0,\s*0\)/,oc=Symbol("renderConfigObserver"),ac=/<div|<button|<input|<p|<br|<li/,lc={INPUT:1,TEXTAREA:1},cc=(e,t,n,i)=>{var r;let s=(null==n?void 0:n.listeners)||(null==n?void 0:n.internalListeners);if(s=(null===(r=s)||void 0===r?void 0:r.on)||s,s){const r=Xt.on(W.assign({element:t,thisObj:e},s));i?(e._refListeners||(e._refListeners=Object.create(null)))[i]=r:n.listeners={on:s,un:r}}},dc=(e,t)=>e&&t&&t[W.keys(e)[0]]?ce.merge(e,t):e,uc=e=>{e.isVisible&&e.triggerPaint()},hc=/^:not\((.+)\)$/,gc=/absolute|fixed/i,mc=e=>null!=e.scale,{hasOwn:pc}=W,{defineProperty:fc}=Reflect,vc=e=>parseFloat(e)*(e.endsWith("ms")?1:1e3),yc=["b-aligned-above","b-aligned-right","b-aligned-below","b-aligned-left"],bc={configurable:!0,value:!1},Cc=/(?:L\{([^}.]+)\})/,Sc=/^([trblc])(\d*)-([trblc])(\d*)$/i,Dc=(e,t)=>(Sc.test(e)&&(e={align:e}),Sc.test(t)&&(t={align:t}),ce.merge(e,t)),wc=/^[\w.]+$/,Ec={1:"maxHeight",2:"height",4:"maxWidth",8:"width"},Rc=e=>!e.isRipple&&!e.closest((e=>e.isMessageDialog||e.isSharedTooltip)),xc=e=>"contents"===Wn.getStyleValue(e,"display")?xc(e.parentNode):e;class Tc extends(Pe.mixin(Ri,at,Ir,Vr,es,Zl,Jl)){static mergeCls(e,t){return t&&e?e=new _t(t).assign("string"==typeof e?new _t(e):e):e&&!e.isDomClassList&&(e=new _t(e)),e}static $name="Widget";static type="widget";static convertPinchToMousewheel=!0;static get configurable(){return{element:!0,callOnFunctions:!0,hideMode:{$config:null,default:"display"},id:null,html:{$config:"lazy",value:null},content:{$config:"lazy",value:null},cls:{$config:{merge:"classList"},value:null},ui:{$config:{merge:"classList"},value:null},collapsify:null,contentElementCls:{$config:{merge:"classList"},value:null},defaultCls:{$config:{merge:"classList"},value:null},dock:null,parent:null,tab:null,elementAttributes:null,htmlCls:{$config:{merge:"classList"},value:{"b-html":1}},style:null,disabled:null,readOnly:{value:null,default:!1,$config:null},ignoreParentReadOnly:null,adopt:null,appendTo:null,insertBefore:null,insertFirst:null,dataset:null,tooltip:{$config:["lazy","nullify"],value:null},showTooltipWhenDisabled:!0,preventTooltipOnTouch:null,monitorResize:{$config:["lazy","nullify"],value:null},masked:{$config:"nullify",value:null},maskDefaults:{target:"element"},floating:null,positionable:null,positioned:null,draggable:null,align:{$config:{merge:Dc},value:"t-b"},centered:null,constrainTo:void 0,anchor:null,owner:{$config:["lazy","nullify"],value:null},scrollAction:null,hideAnimation:{$config:{merge:dc},value:null},showAnimation:{$config:{merge:dc},value:null},top:null,right:null,bottom:null,left:null,x:null,y:null,scrollable:{$config:["lazy","nullify"],value:null},scrollerClass:Xl,defaultBindProperty:"html",defaultAction:null,overflowable:{value:null,default:!0,$config:null},width:null,height:null,maxHeight:null,maxWidth:null,minWidth:null,minHeight:null,scaleToFitWidth:null,allowGrowWidth:!0,margin:null,flex:null,weight:null,alignSelf:null,ripple:null,title:null,localizableProperties:["title","ariaLabel","ariaDescription"],requireSize:!1,ref:null,hidden:null,textAlign:null,ignoreScrollDuration:500,tag:"div",recomposeAsync:null,rootElement:null,htmlMutationObserver:{$config:["lazy","nullify"],value:{childList:!0,subtree:!0}},role:{$config:"lazy",value:"presentation"},ariaLabel:{$config:"lazy",value:null},ariaDescription:{$config:"lazy",value:null},ariaLive:{$config:"lazy",value:null},ariaElement:"element",ariaHasPopup:null,realignTimeout:300,testConfig:{ignoreScrollDuration:100,realignTimeout:50},maximizeOnMobile:null,twinForwardEvents:{$config:{merge:"classList"},value:null},twinSyncConfigs:{$config:{merge:"classList"},value:["disabled"]}}}static get prototypeProperties(){return{hasGeneratedId:!1,hasPainted:!1,innerItem:!0}}static get declarable(){return["renderConfigs"]}static get delayable(){return{recompose:"raf",doHideOrRealign:"raf",onAlignConstraintChange:"raf"}}static get factoryable(){return{defaultType:"widget"}}static get identifiable(){return{}}static get all(){return super.all}static get recomposeAsync(){return Tc._recomposeAsync}static set recomposeAsync(e){if(Tc._recomposeAsync=e,null!=e){const{all:t}=Tc;for(let n=0;n<t.length;++n)t[n].isComposable&&(t[n].recomposeAsync=e)}}updateWeight(){var e,t;this.isPainted&&(null===(e=this.parent)||void 0===e||null===(t=e.onChildWeightChange)||void 0===t||t.call(e,this))}isA(e){return this.isType(e,!0)}isType(e,t){return Tc.isType(this,e,t)}static setupRenderConfigs(e,t){const n=t.getInherited("renderConfigs"),{renderConfigs:i}=e;if(i){if(Array.isArray(i))for(const e of i)n[e]=!0;else W.assign(n,i);n[oc]=null}}static weightSortFn({weight:e},{weight:t}){return"string"==typeof e||"string"==typeof t?String(e).localeCompare(String(t)):(e??Number.MAX_SAFE_INTEGER)-(t??Number.MAX_SAFE_INTEGER)}construct(e={},...t){const n=this,{domSyncCallback:i}=n,{recomposeAsync:r}=Tc;if(null!=r&&null==n.recomposeAsync&&(n.recomposeAsync=r),!globalThis.bryntum.cssVersion){const e=globalThis.bryntum.cssVersion=Sl.getCSSVersion(),t=G.getVersion("core");e&&e!==t&&console.warn(`CSS version ${e} doesn't match bundle version ${t}!\nMake sure you have imported css from the appropriate product version.`)}n.configureAriaDescription=e.ariaDescription,n._isAnimatingCounter=0,n.alignmentChanges=0,n.byRef=Object.create(null),n.onTargetResize=n.onTargetResize.bind(n),n.onFullscreenChange=n.onFullscreenChange.bind(n),n.domSyncCallback=i.$nullFn?null:i.bind(n),n._isUserAction=!1,super.construct(e,...t),n.finalizeInit()}startConfigure(e){super.startConfigure(e),this.getConfig("element")}finalizeInit(){const e=this,{adopt:t}=e,n=e.insertBefore||e.appendTo||e.insertFirst||t;var i;(e.getConfig("html"),e.getConfig("content"),n)&&(t&&(e.element.classList.remove("b-hidden"),e._hidden=!1),e.owner||null!==(i=n.nodeType?n:document.getElementById(n))&&void 0!==i&&i.isConnected?e.render():(e.onFirstResizeAfterConnect=e.onFirstResizeAfterConnect.bind(e),Hl.addResizeListener(n,e.onFirstResizeAfterConnect)))}onFirstResizeAfterConnect(e){Hl.removeResizeListener(e,this.onFirstResizeAfterConnect),this.isDestroyed||this.rendered||this.render()}doDestroy(){var e;const t=this,{preExistingElements:n,element:i,adopt:r,_refListeners:s,_rootElement:o,eventRoot:a,ownedWidgets:l}=t;if($l.element===i&&$l.exit(),s&&(Object.values(s,(e=>e())),t._refListeners=null),i){var c,d,u;const e=!t._tooltip&&o&&(null===(c=Tc.Tooltip)||void 0===c?void 0:c.getSharedTooltip(o,a,!0));if((null==e?void 0:e.owner)===t&&(e.owner=null,e.hide()),t.onExitFullscreen(),t.clearTimeout("scrollListenerTimeout"),t.clearTimeout("resizeListenerTimeout"),t.removeTransientListeners(),t.floating||t.positioned||t.positionable?t.isPainted&&t.hide(!1):t.revertFocus(),Hl.removeResizeListener(i.parentElement,t.onParentElementResize),Hl.removeResizeListener(i,t.onElementResize),r){for(let e=Array.from(i.childNodes),r=0,{length:s}=e;r<s;r++){const i=e[r];n.includes(i)||i===t.floatRoot||i.remove()}i.className=t.adoptedElementClassName,i.style.cssText=t.adoptedElementCssText}null===(d=t.dragEventDetacher)||void 0===d||d.call(t),null===(u=t.dragOverEventDetacher)||void 0===u||u.call(t),t.dragGhost.remove()}null===(e=t.connectedObserver)||void 0===e||e.disconnect(),super.doDestroy(),l&&Object.values(l).forEach((e=>{var t;return null===(t=e.destroy)||void 0===t?void 0:t.call(e)})),a&&Promise.resolve().then((()=>{Object.values(Tc.identifiable.idMap).some(Rc)||ti.detachFocusListeners(a)})),r||i.remove()}get assignValueDefaults(){return Ql}get valueName(){return this.name||this.ref||this.id}getValueName(e){return(e=e&&"object"==typeof e?e.onlyName:e)?this.name:this.valueName}assignFieldValue(e,t,n){const i=this,r=i.defaultBindProperty;r in i&&(i[r]=n)}assignValue(e,t=Ql){const n=this,i=n[rc],r=n.getValueName(t);!r||e&&!(r in e)||(!1===t.highlight&&(n[rc]=!1),n.assignFieldValue(e,r,e?e[r]:null),n[rc]=i)}gatherValue(e){const t=this,n=t.defaultBindProperty;t.constructor!==Tc&&n in t&&(e[t.name||t.ref||t.id]=t[n])}gatherValues(e){this.eachWidget((t=>t.gatherValue(e)),!1)}addToOverflowMenu(e,t,n){const i=this.ensureOverflowTwin(t,n);e.items.push(i)}get twinForwardEventPairs(){const e=this._twinForwardEvents;return e?W.entries(e):ec}configureOverflowTwin(e){const t=this,{twinSyncConfigs:n}=t;let i,r,s=W.clone(t.initialConfig);if(delete s.id,delete s.listeners,delete s.internalListeners,delete s.parent,s.hidden=!1,s.type=t.type,s._overflowTwinOrigin=t,s.owner=t.owner,t.twinForwardEventPairs.forEach((([e])=>{delete s[`on${H.capitalize(e)}`]})),n)for(i in n)r=n[i],r&&(delete s[i],s["string"==typeof r?r:i]=t[i]);return e&&(s="function"==typeof e?e(s)||s:W.assign(s,e)),s}createOverflowTwin(e){const t=this,n=t.configureOverflowTwin(e),i=Tc.create(n),{twinSyncConfigs:r}=t;return r&&t.bindConfigs(i,r,tc),t.twinForwardEventPairs.forEach((([e,n])=>{i.ion({[e]:e=>{t.overflowTwin===e.source&&(delete(e=W.assign({},e)).source,t.trigger("string"==typeof n?n:e.eventName,e))}})})),i}ensureOverflowTwin(e,t){let{overflowTwin:n}=this;return n||(this.overflowTwin=n=this.createOverflowTwin(e),null==t||t(n)),n}get isComposable(){return!this.compose.$nullFn}adoptElement(e){const t=this,n="string"==typeof e?document.getElementById(e):e,i=Tc.fromElement(n);if(i&&i.adopt&&i!==t){("string"==typeof i.adopt?document.getElementById(i.adopt):i.adopt)===n&&i.destroy()}return t.preExistingElements=Array.from(n.childNodes),t.adoptedElementClassName=n.className,t.adoptedElementCssText=n.style.cssText,n.lastDomConfig=null,n.$refOwnerId=t.id,n.className=n.style.cssText="",n}addRefAccessor(e,t){const{prototype:n}=this.constructor;fc(n,t,{writable:!0,value:null}),fc(n,e,{get(){return this.recompose.flush(),this[t]},set(e){this[t]=e}})}attachRef(e,t,n){const i=this,r="_"+e;t.dataset&&(t.dataset.ownerCmp=i.id),i.isComposable&&(r in i||i.addRefAccessor(e,r),cc(i,t,n,e)),i.byRef[e]=t,i[e]=t}detachRef(e,t,n){const i=this,r=i._refListeners;null!=r&&r[e]&&(r[e](),delete r[e]),i[e]=null,delete i.byRef[e]}afterRecompose(){}compose(){const{widgetClassList:e}=this;return{class:{..._t.normalize(e,"object")}}}doCompose(){const e=this,{$meta:t}=e,n=t.hierarchy,i=t.renderConfigs||t.getInherited("renderConfigs");let r,s,o,a,{composers:l}=t,c=null;if(e.recompose.suspend(),!l){for(t.composers=l=[],o=n.indexOf(Tc);o<n.length;++o)a=n[o].prototype,pc(a,"compose")&&l.push(a);pc(i,oc)||(i[oc]={get(e){"element"!==e&&(i[e]=!0)}})}for(e.configObserver=i[oc],o=0;o<l.length;++o)r=l[o].compose.call(e,c),c=c?Wn.merge(c,r):r;return pc(e,"compose")&&(r=e.compose)&&(r=r.call(e,c),Wn.merge(c,r)),e.configObserver=null,Wn.normalizeChildren(c,((t,n)=>{n&&(s="_"+t,s in e||e.addRefAccessor(t,s))}))}get element(){return this.isComposable&&!this.isDestroying&&this.recompose.flush(),this._element}domSyncCallback(e){}changeElement(e){const t=this,n=t.isComposable,{adopt:i}=t;return t.id=t.id||(null==i?void 0:i.id)||null,i?e=t.adoptElement(i):n&&(e=t.doCompose()),"string"==typeof e?e=Wn.createElementFromTemplate(e):W.isObject(e)?(e=Wn.createElement(e,{refOwner:t,callback:t.domSyncCallback}),t.recompose.resume()):Wn.isReactElement(t.peekConfig("html"))?e=document.createElement("div"):1!==e.nodeType&&(e=Wn.createElementFromTemplate(t.template(t))),!e.id&&(e.id=t.id),t.elementAttributes&&Wn.setAttributes(e,t.elementAttributes),e}updateElement(e){const t=this,n=t.isComposable;t.adopt&&(t._hidden=!0,n&&t.recomposeNow()),n&&cc(t,e,e.lastDomConfig);const{className:i}=e,{contentElement:r,contentElementCls:s,isComposable:o}=t,a=r!==e,l=!o&&e.querySelectorAll("[data-reference]"),c=o?[]:t.widgetClassList;let d=(a||!o)&&t.uiClasses;if(i&&c.unshift(i),t._hidden&&c.push("b-hidden",`b-hide-mode-${t.hideMode}`),t._readOnly&&c.push("b-readonly"),Ne.noThrow(e,"remove"),d?(null!=s&&s.value&&(d=d.slice(),d.push(s.value)),d=d.join(" ")):d=null==s?void 0:s.value,d&&(a?r.className+=" "+d:c.push(d)),!t.parent){const{defaultCls:e}=t,{outerCls:n}=Tc;c.push(...e?n.filter((t=>!(t in e)||e[t])):n)}if(e.className=c.join(" "),l)for(let e,n=0;n<l.length;++n)e=l[n],t.attachRef(e.getAttribute("data-reference"),e),e.removeAttribute("data-reference");t.scaleToFitWidth||t.getConfig("monitorResize"),t.getConfig("role"),t.getConfig("ariaLabel"),t.getConfig("ariaDescription"),t._html&&t.getConfig("htmlMutationObserver"),t.trigger("elementCreated",{element:e})}updateAriaDescription(e){const{ariaElement:t}=this,n=`${this.id}-aria-desc-el`;if(e){(this._ariaDescEl||(this._ariaDescEl=Wn.createElement({className:"b-aria-desc-element",id:n,parent:t}))).innerText=e.match(Cc)?this.L(e,this):e,Wn.addAttributeValue(t,"aria-describedBy",n)}else Wn.removeAttributeValue(t,"aria-describedBy",n)}updateAriaLabel(e){Wn.setAttributes(this.ariaElement,{"aria-label":null!=e&&e.match(Cc)?this.L(e,this):e})}updateAriaHasPopup(e){Wn.setAttributes(this.ariaElement,{"aria-haspopup":e})}updateAriaLive(e){Wn.setAttributes(this.ariaElement,{"aria-live":e})}updateRole(e){var t,n;e?null===(t=this.ariaElement)||void 0===t||t.setAttribute("role",e):null===(n=this.ariaElement)||void 0===n||n.removeAttribute("role")}get ariaElement(){this.getConfig("element");const{_ariaElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:W.getPath(this,e)}isCollapsified({collapsed:e,alt:t}){const{collapsify:n}=this,i=null==n;return t?"overlay"===n||i&&e:!1===n||"hide"===n||i&&!e}async recompose(){return this.recomposeInternal()}async recomposeInternal(){const e=this,t={targetElement:e.element,domConfig:e.doCompose(),refOwner:e,callback:e.domSyncCallback,strict:!0};if(e.transitionRecompose){if(e.isTransitioningDom=!0,await Wn.transition(W.assign({element:e.element,action(){Ll.sync(t)}},e.transitionRecompose)),e.isDestroyed)return;e.isTransitioningDom=!1,e.trigger("transitionedRecompose")}else Ll.sync(t);t.changed&&(e.afterRecompose(),e.trigger("recompose")),e.resumeRecompose()}resumeRecompose(){this.recompose.resume()}changeElementRef(e){if("string"==typeof e){const t=e;if(!(e=document.getElementById(t)))throw new Error(`No element found with id '${t}'`)}return e}changeAppendTo(e){return this.changeElementRef(e)}updateAppendTo(e){!this.isConfiguring&&e&&this.render()}changeInsertBefore(e){return this.changeElementRef(e)}updateInsertBefore(e){!this.isConfiguring&&e&&this.render()}changeInsertFirst(e){return this.changeElementRef(e)}updateInsertFirst(e){!this.isConfiguring&&e&&this.render()}getRenderContext(e=this,t){let n=t||e.appendTo,{insertFirst:i,insertBefore:r}=e;return i&&(n=i,r=n.firstChild),r&&(n=r.parentElement),[n,r||void 0]}render(e,t=!0){var n;const i=this,{element:r}=i,[s,o]=i.getRenderContext(i,e);i.emptyCache(),i.syncElement&&i.currentElement?Wn.sync(r,i.currentElement):(null==s||s.insertBefore(r,o),i.currentElement=r),null!==(n=r.parentElement)&&void 0!==n&&n.closest(".b-widget")&&r.classList.remove(...Tc.outerCls),super.render(s,t),i.rendered=!0,i.getConfig("role"),t&&(i.getConfig("contentRange"),i.triggerPaint()),i.setupFocusListeners()}template({tag:e,html:t,htmlCls:n,name:i}){var r;const s=this;"string"==typeof t&&wc.test(t)&&s.resolveCallback(t,s,!1)&&(t=s.callback(t,s,[s]));const o=null!==(r=t)&&void 0!==r&&r.call?t.call(s,s):t;return`<${e} class="${o?n:""}" ${i?`data-name="${i}"`:""}>${o||""}</${e}>`}updateRecomposeAsync(e){this.recompose.immediate=!e}onConfigChange({name:e}){var t;this._element&&!this.isDestroying&&null!==(t=this.$meta.renderConfigs)&&void 0!==t&&t[e]&&this.recompose()}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.parent}getConfigValue(e,t){return"style"===e?this._style:super.getConfigValue(e,t)}getCurrentConfig(e){const t=super.getCurrentConfig(e);return(null==e?void 0:e.depth)>0&&(t.type=this.type),t}get dataset(){return this.element.dataset}changeDataset(e){W.assign(this.dataset,e)}get dragGhost(){return this.constructor._dragGhost||(this.constructor._dragGhost=Wn.createElement({html:" ",style:"position:absolute;top:-10000em;left:-10000em"}))}updateParent(e){const{_element:t}=this;t&&t.classList[e?"remove":"add"](...Tc.outerCls)}get constrainTo(){var e;let t=this._constrainTo;if(t=void 0===t?globalThis:(null===(e=t)||void 0===e?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE?t.host||t.ownerDocument:t,this.positioned){const{offsetParent:e}=this.element;if(e&&"hidden"===Wn.getStyleValue(e,"overflow"))t=Pt.from(e).moveTo(0,0);else if(t&&!t.isRectangle){const n=t===document||t===globalThis;t=Pt.from(t,e),n&&t.translate(globalThis.pageXOffset,globalThis.pageYOffset)}}return t}updateCentered(e){const t=this,{element:n,_anchorElement:i}=t;if(e&&!t.floating&&!t.positioned)throw new Error("`centered` is only relevant when a Widget is `floating` or `positioned`");e?(n.classList.add("b-centered"),n.style.transform=n.style.left=n.style.insetInlineStart=n.style.right=n.style.top="",null==i||i.classList.add("b-hide-display"),n.classList.remove("b-anchored")):n.classList.remove("b-centered")}get contentElement(){return this.element}get contentRange(){const e=this,t=e._contentRange||(e._contentRange=new Range);return t.collapsed&&(e.initializingHtml&&e.adopt?t.setStart(e.contentElement,0):t.selectNodeContents(e.contentElement)),t}fixRefOwnerId(e,t,n){if(e.$refOwnerId===n){e.$refOwnerId=t;for(let{childNodes:i}=e,r=i.length;r-- >0;)this.fixRefOwnerId(i[r],t,n)}}get placement(){const{element:e}=this;let t,n,i;if(null!=e&&e.offsetParent&&!gc.test(Wn.getStyleValue(e,"position"))){const s=e.nextElementSibling,o=e.previousElementSibling,a=!s&&o;var r;if(n=Wn.getStyleValue(e.parentElement,"flex-direction"),n)n=n.startsWith("row")?"h":"v";else t=null===(r=s||o)||void 0===r?void 0:r.getBoundingClientRect(),i=t&&e.getBoundingClientRect(),n=t&&Math.abs(t.top-i.top)<Math.abs(t.left-i.left)?"h":"v";n+="h"===n?a?"r":"l":a?"b":"t"}return n}updateId(e,t){if(super.updateId(e,t),t){const{byRef:n,element:i}=this;for(const t in n)n[t].dataset&&(n[t].dataset.ownerCmp=e);i.id=e,this.fixRefOwnerId(i,e,t)}}get style(){const{element:e}=this;return(null==e?void 0:e.ownerDocument.defaultView.getComputedStyle(e))||this._style}updateStyle(e){this.element&&Wn.applyStyle(this.element,e)}updateTitle(e){this.titleElement&&(this.titleElement.innerHTML=e)}beforeAlignTo(e){}alignTo(e){var t,n,i;const r=this,{lastAlignSpec:s,element:o}=r,{offsetParent:a,style:l,classList:c}=o;if(s&&(s.monitorIntersection&&r.intersectionObserver.unobserve(s.target),isFinite(s.zone)&&o.classList.remove(yc[s.zone])),!e)return r.removeTransientListeners(),void(r.anchor=r.lastAlignSpec=null);r.beforeAlignTo(e),(e.nodeType===Element.ELEMENT_NODE||e.isWidget||"Point"===e.$$name)&&(e={target:e}),r.releaseSizeConstraints();const{scrollable:u,constrainTo:h}=r,g=Wn.measureSize(Wn.getStyleValue(o,"minHeight"),o),m=Wn.measureSize(Wn.getStyleValue(o,"minWidth"),o),p=r.positioned&&"fixed"!==Wn.getStyleValue(o,"position"),f=r.scale||1,v=e.target,y=e.realignEvent||(e=>{if(null!=e&&e.target){const{ownerSVGElement:t}=e.target,n=null==t?void 0:t.getBoundingClientRect();if(t)return{target:e.target.ownerSVGElement,offsetX:e.clientX-n.x,offsetY:e.clientY-n.y};let{offsetX:i,offsetY:r}=e,s=xc(e.target);if("contents"===Wn.getStyleValue(e.target,"display")){const e=s.getBoundingClientRect(s);i-=e.x,r-=e.y}return{target:xc(e.target),offsetX:i,offsetY:r}}})(e.domEvent||e.event||((null==v||null===(t=v.target)||void 0===t?void 0:t.nodeType)===Node.ELEMENT_NODE?v:null)),b=(null==y||null===(n=y.target)||void 0===n?void 0:n.nodeType)===Element.ELEMENT_NODE,C=b?y.target:null!=v&&v.isRectangle?v:(null==v?void 0:v.element)||v,S=(null==C?void 0:C.nodeType)===Element.ELEMENT_NODE;e=e.realignTarget?W.clone(e):W.merge({aligningToEvent:b,aligningToElement:S,constrainTo:h,align:"b-t",axisLock:r.axisLock,anchor:r.anchor},r.align,e),b&&(e.domEvent=y);const D=e.minWidth||m,w=e.minHeight||g;if(r.lastAlignSpec=e,S&&(e.target=e.anchoredTo=C,An(C instanceof SVGElement?C.closest("svg"):C))){if((e=Object.setPrototypeOf({},e)).target=r.lastAlignSpec.targetRect=e.realignTarget||(e.allowTargetOut?Pt.from(C,p?a:null,!p):Wn.isInView(b?y:C,!1,r)),!e.target){const e=r.hide();return r.isDestroyed||(r.lastAlignSpec.targetOutOfView=!0),e}e.target.height=Math.max(e.target.height,1),e.target.width=Math.max(e.target.width,1)}if(e.anchor&&(e.anchorSize=r.anchorSize,o.contains(r.anchorPathElement)||o.appendChild(r.anchorElement)),"string"==typeof e.offset){const t=o.querySelector(e.offset),n=Pt.from(t).getAlignmentPoint(e.align),i=Pt.from(o).getAlignmentPoint(e.align);e.offset=[i[0]-n[0],i[1]-n[1]]}r.isAligning=!0,r.trigger("beforeAlign",e);const E=Pt.from(o,p?a:null,!0),{width:R,height:x}=E;E.isAlignRectangle=!0,D&&(E.minWidth=D*f),w&&(E.minHeight=w*f),r.isAligning=!1,e.rtl=r.rtl,(e.align.includes("s")||e.align.includes("e"))&&(r.rtl?e.align=e.align.replace(/s/g,"r").replace(/e/g,"l"):e.align=e.align.replace(/s/g,"l").replace(/e/g,"r"));const T=r.lastAlignSpec.result=E.alignTo(e);let{align:M,anchor:I,x:A,y:k,width:F,height:P,overlap:O}=T;if(r.lastAlignSpec.zone=T.zone,P!=x){const e=P<x;r.alignmentChanges=r.alignmentChanges|(e?1:2),l[r.alignedHeightStyle=Ec[3&r.alignmentChanges]]=P/f+"px",e&&!r._minHeight&&g&&(l.minHeight=Math.min(P,g)/f+"px"),u&&(u.overflowY=e)}if(F!=R){const e=F<R;r.alignmentChanges=r.alignmentChanges|(e?4:8),l[r.alignedWidthStyle=Ec[12&r.alignmentChanges]]=F/f+"px",e&&!r._minWidth&&m&&(l.minWidth=Math.min(F,m)/f+"px"),u&&(u.overflowX=e)}if(M&&r.alignmentChanges){const t=Pt.from(o,p?a:null,!0);e.align=M;const n=r.lastAlignSpec.result=t.alignTo(e);I=n.anchor,A=n.x,k=n.y,F=n.width,P=n.height}if(r.centered||r.setXY(A,k),!T.overlap&&isFinite(T.zone)&&c.add(yc[T.zone]),null!==(i=I)&&void 0!==i&&i.edge){var L;let{edge:e}=I;const{anchorElement:t}=r,{style:n}=t,{style:i}=t.firstChild,s=Pt.from(o),a=[];"top"===e||"bottom"===e?(a[0]=I.x,a[1]="top"===e?1:s.height-1):(a[0]="left"===e?1:s.width-1,a[1]=I.y),n.display="none";let l=Wn.childFromPoint(o,...a);if((null!==(L=l)&&void 0!==L&&L.matches(":focus")||l===ti.currentOverElement)&&o.compareDocumentPosition(l)&Node.DOCUMENT_POSITION_CONTAINED_BY&&(l=l.parentNode),l&&l!==document){let e=Wn.getStyleValue(l,"background-color");for(;e.match(sc)&&"absolute"!==Wn.getStyleValue(l,"position")&&(l=l.parentNode,l!==document);)e=Wn.getStyleValue(l,"background-color");e.match(sc)?r.anchorPathElement.setAttribute("fill",r.defaultAnchorBackgroundColor):r.anchorPathElement.setAttribute("fill",e)}n.transform=n.display="","left"!==e&&"right"!==e||(e="left"===e?r.rtl?"end":"start":r.rtl?"start":"end"),t.className=`b-anchor b-anchor-${e}`,I.x&&(I.x/=f),I.y&&(I.y/=f),i.left=`${I.x||0}px`,i.translate=`0 ${I.y||0}px`,c.add("b-anchored")}else r._anchorElement&&(r.anchorElement.classList.add("b-hide-display"),c.remove("b-anchored"));if(!S){l.pointerEvents="none";const e=Wn.elementFromPoint(A,k);r.owns(e)||(r.lastAlignSpec.anchoredTo=e),l.pointerEvents=""}if(("realign"===r.scrollAction&&S||"hide"===r.scrollAction)&&!r.documentScrollListener){if(r.clearTimeout("scrollListenerTimeout"),e.monitorTargetMutation&&!r.targetObserver){(r.targetObserver||(r.targetObserver=new MutationObserver(r.onTargetParentMutation.bind(r)))).observe(Wn.getRootElement(C),{childList:!0,attributes:!0,subtree:!0})}r.setTimeout((()=>{const e=S?C:r.lastAlignSpec.anchoredTo,t=e?Wn.getRootElement(e):null;r.documentScrollListener=Xt.addListener({element:document,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:r}),null!=t&&t.mode&&(r.targetRootScrollListener=Xt.addListener({element:t,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:r}))}),"hide"===r.scrollAction?r.ignoreScrollDuration:0,"scrollListenerTimeout")}if(S&&(e.monitorResize&&!r.observedTargetEl&&(Hl.addResizeListener(C,r.onTargetResize),r.observedTargetEl=C),e.monitorIntersection&&!(O||C.contains(o)||C.ownerSVGElement)&&r.intersectionObserver.observe(C)),!d.isAndroid&&!r.observedConstrainEl){const e=null!=h&&h.isRectangle?globalThis:h;r.clearTimeout("resizeListenerTimeout"),r.setTimeout((()=>{r.observedConstrainEl=e||globalThis,Hl.addResizeListener(r.observedConstrainEl,r.onAlignConstraintChange)}),r.ignoreScrollDuration,"resizeListenerTimeout")}}onTargetParentMutation(e){const{element:t,lastAlignSpec:n}=this;var i;null!=n&&n.aligningToElement&&(null!==(i=n.target)&&void 0!==i&&i.isConnected?e.some((({target:e})=>e.contains(n.target)&&!t.contains(e)))&&this.realign():this.hide())}get intersectionObserver(){return this._intersectionObserver||(this._intersectionObserver=new IntersectionObserver(this.onTargetIntersectionchange.bind(this),{root:d.isSafari?this.rootElement:this.rootElement.ownerDocument}))}onTargetIntersectionchange(e){if(!this.isDestroyed){const t=e[e.length-1];t.isIntersecting||this.onAlignTargetOutOfView(t.target)}}onTargetResize(){const{lastAlignSpec:e}=this;if(e){const{width:t,height:n}=e.targetRect,{width:i,height:r}=e.target.getBoundingClientRect();i===t&&r===n||this.onAlignConstraintChange(...arguments)}}onAlignTargetOutOfView(e){this.hide(),this.lastAlignSpec&&(this.lastAlignSpec.targetOutOfView=!0)}onAlignConstraintChange(e,t,{height:n}){const{style:i}=this.contentElement,{overflowY:r}=i;this.setTimeout(this.realign,50),t&&n>t.height&&(i.overflowY="hidden",this.requestAnimationFrame((()=>i.overflowY=r)))}realign(){const e=this,{lastAlignSpec:t}=e;if((e.floating||e.positioned)&&t&&e.isVisible){if(t.aligningToElement){const n=t.target.contains(this.element),i=Wn.isInView(t.target,!1,e);if(!(t.allowTargetOut||An(t.target)&&i))return e.hide(),void(e.isDestroyed||(e.lastAlignSpec.targetOutOfView=!0));t.realignEvent=t.domEvent,t.realignTarget=n||t.aligningToEvent?null:i}Wn.addTemporaryClass(e.element,"b-realigning",e.realignTimeout,e),e.alignTo(t)}}rectangle(e,t,n){return this.rectangleOf("element",e,t,n)}rectangleOf(e,t,n,i){var r;return"string"!=typeof t?(i=n,n=t,t=""):"border"===t&&(t=""),"boolean"==typeof n&&(i=n,n=void 0),"element"!==e&&void 0===n&&(n=this.element),n=null!==(r=n)&&void 0!==r&&r.isWidget?n.element:n,"string"==typeof e&&(e=this[e]),Pt[t||"from"](e,n,i)}releaseSizeConstraints(){const e=this,{scrollable:t,element:n,alignmentChanges:i}=e,{style:r}=n;12&i&&(Wn.setLength(n,e.alignedWidthStyle,e[`_last${H.capitalize(e.alignedWidthStyle)}`]||""),r.minWidth=e._minWidth||"",t&&(t.overflowY=t.config.overflowY)),3&i&&(Wn.setLength(n,e.alignedHeightStyle,e[`_last${H.capitalize(e.alignedHeightStyle)}`]||""),r.minHeight=e._minHeight||"",t&&(t.overflowX=t.config.overflowX)),e.alignmentChanges=0}toFront(){const{element:e}=this,t=this.floating?this.floatRoot:this.positioned?null==e?void 0:e.parentNode:null,n=document.createDocumentFragment();if(this.containsFocus){for(let i,r=e.nextSibling;r;r=i)i=r.nextSibling,t.contains(r)&&!this.owns(r)&&n.appendChild(r);t.insertBefore(n,e)}else t.appendChild(e)}updateRef(e){this.element.dataset.ref=e}get overflowElement(){return this.contentElement}get maxHeightElement(){return this.element}changeAlign(e){return"string"==typeof e?{align:e}:e}changeScrollable(e,t){return"boolean"==typeof e&&(e={overflowX:e,overflowY:e}),e?(e.element=this.overflowElement,e.widget=this,e.isScroller||(e=t?t.setConfig(e):new this.scrollerClass(e)),e.syncOverflowState()):null==t||t.destroy(),e}handleReactElement(e){var t;const n=this.closest((e=>e.reactComponent)),i=(null==n?void 0:n.reactComponent)||(null===(t=bryntum)||void 0===t||null===(t=t.query((e=>{var t;return!(null===(t=e.reactComponent)||void 0===t||!t.state)})))||void 0===t?void 0:t.reactComponent);null==i||i.processWidgetContent({reactElement:e,widget:this,reactComponent:i})}get html(){return this.isConfiguring?this.content||this._html:this.contentElement.innerHTML}changeHtml(e){return!e||"object"!=typeof e||Wn.isReactElement(e)||Array.isArray(e)||(e=[e]),e}updateHtml(e){const t=this;t.noChildElements="string"==typeof e&&!ac.test(e),t.initializingElement||t.insertContent(e,!(t.initializingHtml&&t.adopt))}changeHtmlMutationObserver(e,t){const n=this,{contentElement:i}=n;if(null==t||t.disconnect(),e){const t=new MutationObserver((()=>{n.updatingHtml?n.updatingHtml=!1:n._html=i.innerHTML}));return t.observe(i,e),t}}updateContent(e){this.initializingElement||this.insertContent(e)}insertContent(e,t=!1){const n=this,{element:i,contentElement:r,htmlCls:s,contentRange:o,autoClose:a}=n,l=t&&r===i&&n._anchorElement;if(Wn.isReactElement(e))return n.handleReactElement(e);if(n.updatingHtml=!0,n.getConfig("htmlMutationObserver"),l&&i.removeChild(l),s&&s.values.forEach((t=>i.classList[e?"add":"remove"](t))),n.autoClose=!1,e){let n,s;"object"==typeof e?(s=document.createDocumentFragment(),Array.isArray(e)?Ll.sync({domConfig:{children:e,onlyChildren:!0},targetElement:s}):Ll.sync({domConfig:{...e,onlyChildren:!0},targetElement:s})):t?(r.innerHTML=e,n=!0):(t||o.deleteContents(),s=Wn.createElementFromTemplate(e,{fragment:!0})),n||(t?(r.innerHTML="",r.appendChild(s)):i.isConnected?o.insertNode(s):r.insertBefore(s,r.firstChild))}else t||!i.isConnected?r.innerHTML="":o.deleteContents();n.autoClose=a,l&&i.appendChild(l),n.contentRangeStartOffset=o.startOffset,n.contentRangeEndOffset=o.endOffset,r.classList.toggle("b-no-child-elements",n.noChildElements),n.isComposable&&n.recompose(),!n.floating&&!n.positioned||n.isAligning||n.realign()}onThemeChange(){var e;this._anchorSize=null,null!==(e=this.anchorElement)&&void 0!==e&&e.offsetParent&&this.realign()}get anchorSize(){const e=this;let t=this._anchorSize;if(!t){const n=parseFloat(Wn.getStyleValue(e.element,"border-top-width")),i=Wn.getStyleValue(e.element,"border-top-color"),r=e.anchorElement,{className:s}=r,o=r.firstElementChild,a=e.anchorPathElement=o.lastElementChild,l=e._hidden;r.className="b-anchor b-anchor-top";let c=Wn.getStyleValue(e.contentElement,"background-color");c.match(sc)&&(c=Wn.getStyleValue(e.element,"background-color")),e.defaultAnchorBackgroundColor=c,t=o.getBoundingClientRect();const[d,u]=t=e._anchorSize=[t.width,t.height];r.className=s,o.setAttribute("height",u+n),o.setAttribute("width",d),a.setAttribute("d",`M0,${u}L${d/2},0.5L${d},${u}`),n&&(a.setAttribute("stroke-width",n),a.setAttribute("stroke",i)),t[1]-=n,l&&e.syncHiddenCls(),e.themeChangeListener||(e.themeChangeListener=ti.ion({theme:"onThemeChange",thisObj:e})),e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}return t}get anchorElement(){const e=this;if(!e._anchorElement){const t=e.floating||e.positioned,n=`${e.id}-shadow-filter`;e._anchorElement=Wn.createElement({parent:e.element,className:"b-anchor b-anchor-top",children:[{tag:"svg",ns:"http://www.w3.org/2000/svg",version:"1.1",class:"b-pointer-el",children:[t?{tag:"defs",children:[{tag:"filter",id:n,children:[{tag:"feDropShadow",dx:0,dy:-1,stdDeviation:1,"flood-opacity":.2}]}]}:null,{tag:"path",[t?"filter":""]:`url(#${n})`}]}]})}return e._anchorElement}updateAnchor(e){this._anchorElement&&this._anchorElement.classList[e?"remove":"add"]("b-hide-display")}updateDraggable(e){const t=this,{element:n}=t;var i,r,s;e?(t.dragEventDetacher=Xt.addListener({element:n,dragstart:"onWidgetDragStart",dragend:"onWidgetDragEnd",thisObj:t}),t.dragDetacher=Xt.on({element:n,mousedown(e){const{target:t}=e,i=Tc.fromElement(t);(!e.target.closest(".b-field-inner")&&i===this||this.strips&&Object.values(this.strips).includes(i))&&n.setAttribute("draggable","true")},thisObj:t})):(null===(i=t.dragEventDetacher)||void 0===i||i.call(t),null===(r=t.dragOverEventDetacher)||void 0===r||r.call(t),null===(s=t.dragDetacher)||void 0===s||s.call(t))}onWidgetDragStart(e){var t;const n=this;if(!n.validateDragStartEvent(e))return;const{element:i,align:r,constrainTo:s}=n,o=n.positioned&&"fixed"!==Wn.getStyleValue(i,"position"),a=o?i.parentElement:n.rootElement,l=Pt.from(i,o?a:null),c=e.clientX,u=e.clientY,h=document.scrollingElement||document.body,[g,m]=o?Wn.getOffsetXY(i,a):n.getXY(),p=null===(t=o?Pt.content(a).moveTo(0,0):s&&(null!=s&&s.isRectangle?s:Pt.from(s)))||void 0===t?void 0:t.deflate(r.constrainPadding||0),f={element:a,dragover:e=>{i.classList.remove("b-centered"),l.moveTo(g+e.clientX-c-(o?0:h.scrollLeft),m+e.clientY-u-(o?0:h.scrollTop)),p&&l.constrainTo(p),Wn.setTopInsetInlineStart(i,l.y,l.x)}};d.isTouchDevice&&(f.touchmove=e=>e.preventDefault()),n.floatRoot.appendChild(n.dragGhost),n.setDragImage(e),e.dataTransfer.effectAllowed="none",n.dragOverEventDetacher=Xt.addListener(f),n.alignTo()}validateDragStartEvent(e){const{element:t}=this,n=Wn.elementFromPoint(e.clientX,e.clientY),{handleSelector:i}=this.draggable;if(i){var r;const s=null===(r=hc.exec(i))||void 0===r?void 0:r[1];if(s){if(n.closest(`#${t.id} ${s}`))return e.preventDefault(),!1}else if(!n.closest(`#${t.id} ${i}`))return e.preventDefault(),!1}return!0}setDragImage(e){e.dataTransfer.setDragImage&&(e.dataTransfer.setData("application/node type",""),e.dataTransfer.setDragImage(this.dragGhost,-9999,-9999))}setStyle(e,t){return Wn.applyStyle(this.element,W.isObject(e)?e:{[e]:t}),this}onWidgetDragEnd(){this.dragGhost.remove(),this.dragOverEventDetacher(),this.element.removeAttribute("draggable")}changeFloating(e){return Boolean(e)}changePositioned(e){return Boolean(e)}updatePositionable(e){this.element.classList.toggle("b-positionable",Boolean(e)),e&&(this.innerItem=!1)}updatePositioned(e){this.element.classList.toggle("b-positioned",Boolean(e)),e&&(this.innerItem=!1)}getXY(){const{element:e}=this;return[Wn.getPageX(e),Wn.getPageY(e)]}setXY(e,t){const n=this,{element:i}=n;if(n.floating||n.positioned){if(null!=e?n._x=e:e=n._x,null!=t?n._y=t:t=n._y,"fixed"===Wn.getStyleValue(i,"position")){const n=i.getBoundingClientRect(),[r,s]=Wn.getTranslateXY(i),o=e-n.x,a=t-n.y;Wn.setTranslateXY(i,r+o,s+a)}else n.rtl?Wn.setTopInsetInlineStart(i,t,i.offsetParent.offsetWidth-i.offsetWidth-e):Wn.setTopInsetInlineStart(i,t,e);n.isConstructing?n.centered=!1:i.classList.remove("b-centered")}}setPos(e,t){const n=this,{positionable:i}=n;[e,t]=Wn.unitize(e,t??""),n.element.style[e]=t,null==n.top&&null==n.right&&null==n.bottom&&null==n.left?"after"!==i&&"before"!==i||(n.positionable=null):i||(n.positionable="before")}updateBottom(e){this.setPos("bottom",e)}updateLeft(e){this.setPos("inset-inline-start",e)}updateRight(e){this.setPos("inset-inline-end",e)}updateTop(e){this.setPos("top",e)}get x(){return this.getXY()[0]}changeX(e){this.setXY(e)}get y(){return this.getXY()[1]}changeY(e){this.setXY(null,e)}get width(){const e=this,t=e.element;return e.monitorResize?(null==e._width&&(e._width=t.offsetWidth),e._width):t.offsetWidth}changeWidth(e){const t=this;if(Wn.setLength(t.element,"width",e),t._lastWidth=e,t._flex=null,t.element.style.flex="",!t.monitorResize)return e;t._oldWidth=t._width,t._width=null}clearWidthCache(){this._width=null}get maxWidth(){return Wn.measureSize(this.element.style.maxWidth,this.element)}updateMaxWidth(e){this._lastMaxWidth=e,Wn.setLength(this.element,"maxWidth",e)}get minWidth(){return Wn.measureSize(this.element.style.minWidth,this.element)}updateMinWidth(e){Wn.setLength(this.element,"minWidth",e)}updateFlex(e){this.getConfig("width"),"number"!=typeof e&&isNaN(e)||(e=`${e} ${e}`),this.element.style.flex=e,this.element.style.width=""}updateAlignSelf(e){this.element.style.alignSelf=e}updateMargin(e){this.element.style.margin=this.parseTRBL(e).join(" ")}updateTextAlign(e,t){t&&this.element.classList.remove(`b-text-align-${t}`),this.element.classList.add(`b-text-align-${e}`)}updatePlaceholder(e){this.input&&(null==e?this.input.removeAttribute("placeholder"):this.input.placeholder=e)}get height(){const e=this,t=e.element;return e.monitorResize?(null==e._height&&(e._height=t.offsetHeight),e._height):t.offsetHeight}changeHeight(e){Wn.setLength(this.element,"height",e),this._lastHeight=e,this._height=null}get maxHeight(){return Wn.measureSize(this.maxHeightElement.style.maxHeight,this.element)}updateMaxHeight(e){this._lastMaxHeight=e,Wn.setLength(this.maxHeightElement,"maxHeight",e)}get minHeight(){return Wn.measureSize(this.element.style.minHeight,this.element)}updateMinHeight(e){Wn.setLength(this.element,"minHeight",e)}updateDisabled(e=!1,t){const n=this,{element:i,focusElement:r,ariaElement:s}=n;n.trigger("beforeUpdateDisabled",{disabled:e}),e&&(n.revertFocus(),!n._disabled!=!e)||(i&&(i.classList[e?"add":"remove"]("b-disabled"),"inert"===e?i.inert=!0:"inert"===t&&(i.inert=!1),r&&(r.disabled=e),s&&s.setAttribute("aria-disabled",Boolean(e))),n.onDisabled(e))}onDisabled(e){}disable(){this.disabled=!0}enable(){this.disabled=!1}requestFullscreen(){const e=this,t=$l.request(e.floating?e.floatRoot:e.element);return $l.onFullscreenChange(e.onFullscreenChange),e.element.classList.add("b-fullscreen"),t}exitFullscreen(){return $l.exit()}onFullscreenChange(){$l.isFullscreen||this.onExitFullscreen()}onExitFullscreen(){$l.unFullscreenChange(this.onFullscreenChange),this.element.classList.remove("b-fullscreen")}get tooltip(){const e=this;if(e._tooltip)return e._tooltip;{var t;const n=null===(t=Tc.Tooltip)||void 0===t?void 0:t.getSharedTooltip(e.rootElement,e.eventRoot);if(n&&n.activeTarget===e._element&&n.isVisible)return n}}changeTooltip(e,t){const n=this,{element:i}=n;if(e){if(!n.preventTooltipOnTouch||!d.isTouchDevice){if(e.isTooltip||"Object"===e.constructor.name||(e={html:"string"==typeof e?e:n.placeholder,textContent:!0}),!(null!=t&&t.isTooltip||e.newInstance))return i.dataset.btip=!0,void(n.tipConfig=e);e.type="tooltip",e.forElement||(e.forElement=i),"showOnHover"in e||e.forSelector||(e.showOnHover=!0),"autoClose"in e||(e.autoClose=!0),e=Tc.reconfigure(t,e,n),n.detachListeners("tooltipValueListener"),n.configureAriaDescription||e.ion({name:"tooltipValueListener",innerHtmlUpdate:"onTooltipValueChange",thisObj:n})}}else if(t){if(null!=e||!t.isTooltip)return void(t.html=null);t.destroy()}else delete i.dataset.btip;return e}onTooltipValueChange({value:e,source:t}){this.ariaDescription="string"==typeof e?e:t.contentElement.innerText}get tooltipText(){const e=this._tooltip;return e?e.isTooltip?e.contentElement.innerText:"string"==typeof e?e:e.html:this.tipConfig?this.tipConfig.html:void 0}get isVisible(){const e=this,{element:t}=e;let n;return Boolean(t&&!e._hidden&&!e.isDestroying&&t.isConnected&&(!e.requireSize||An(t))&&(!(n=e.parent)||n.isVisible))}get isVisibleForValidation(){const e=this,{element:t}=e;let n;return Boolean(t&&(!e._hidden||e.tab&&!e.tab.hidden)&&!e.isDestroying&&t.isConnected&&(!(n=e.containingWidget)||n.isVisibleForValidation))}whenVisible(e,t=this,n,i=e.toString()){const r=this;var s;r.isVisible&&r.isPainted?(null===(s=r.toCallWhenVisible)||void 0===s||s.delete(i),r.callback(e,t,n)):(r.toCallWhenVisible||(r.toCallWhenVisible=new Map)).set(i,{callback:e,thisObj:t,args:n})}focus(){var e;null===(e=this.focusableElement)||void 0===e||e.focus({preventScroll:!0})}get focusability(){return Wn.getFocusability(this.focusElement)}get focusableElement(){const e=this,t=!e.isDestroying&&e.isVisible&&!e.disabled&&e.focusElement;return(t===document.body||(null==t?void 0:t.offsetParent))&&t}get focusElement(){}get isFocusable(){return Boolean(this.focusableElement)}get isTabbable(){return this.focusability.tabbable}set isTabbable(e){const{focusability:t,focusElement:n}=this,[i,r]=t.natural?[!e&&"-1",e]:[e&&"0",!e];n&&!e!=!t.tabbable&&(r&&n.removeAttribute("tabIndex"),i&&n.setAttribute("tabIndex",i))}async show({align:e,animate:t=!0}={}){var n;const i=this,{element:r,floating:s}=i,{style:o}=r,a=t&&i.showAnimation;let l,c,d=!i.isVisible;return d&&(d=i.trigger("beforeShow"),W.isPromise(d)&&(d=await d)),!1!==d&&!1!==(null===(n=i.internalBeforeShow)||void 0===n?void 0:n.call(i))?new Promise((t=>{if(i.cancelHideShowAnimation(),i.updateCentered(i._centered),s){const e=i.floatRoot;e.contains(r)||(i.rendered?e.appendChild(i.element):i.render(e,!1)),o.transform.includes("scale")&&(i.scale=null,o.transform=o.transformOrigin="");const t=i.closest(mc);if(t){const{scale:e}=t;i.scale=e,o.transform=`scale(${e})`,o.transformOrigin="0 0"}}if(i._hidden=!1,i.syncHiddenCls(),s&&!In(r))return i.hide(!1),t();if(i.onConfigChange({name:"hidden",value:!1,was:!0,config:i.$meta.configs.hidden}),a){l=Object.keys(a)[0],c=a[l];const e=i.currentAnimation={showing:!0,styleProp:l,resolve:t};i.isAnimating=!0,o.transition="none",o[l]=c.from,Wn.getStyleValue(r,l),i.currentAnimation.detacher=Xt.onTransitionEnd({element:r,property:l,duration:vc(c.duration)+20,handler:()=>i.afterHideShowAnimate(e),thisObj:i}),o.transition=`${l} ${c.duration} ease ${c.delay}`,o[l]=c.to}i.afterShow(e,a?null:t)})):Promise.resolve()}async showBy(e,t,n){const i=this,r=Array.isArray(e);if(r||"number"==typeof e){const i=r?e:[e,t];e=Object.assign({target:new Ot(i[0]+1,i[1]+1),matchSize:!1,align:"t0-b0"},r?t:n)}if(i.requireSize=!0,!i.isVisible)return i.show({align:e});Wn.addTemporaryClass(i.element,"b-realigning",300,i),i.alignTo(e)}afterShow(e,t){var n,i;const r=this;r.trigger("show"),r._configuredAnchorState=r.anchor,null===(n=r.owner)||void 0===n||null===(i=n.onChildShow)||void 0===i||i.call(n,r),r.triggerPaint(),(r.floating||r.positioned)&&(e?r.alignTo(e):r.centered?r.alignTo({target:r.constrainTo,align:"c-c"}):r.forElement&&r.alignTo(r.forElement)),null==t||t()}onChildHide(e){var t;e.floating&&(null===(t=this.ariaElement)||void 0===t||t.removeAttribute("aria-owns"))}onChildShow(e){var t;e.floating&&null!==(t=this.childItems)&&void 0!==t&&t.includes[e]&&(this.ariaHasPopup=e.role,this.ariaElement.setAttribute("aria-owns",e.id))}triggerPaint(){const e=this,{element:t,toCallWhenVisible:n}=e,i=!e.isPainted;if(e.isVisible){var r;if(i&&(e.getConfig("scrollable"),e.scaleToFitWidth&&!e.monitorResize&&(e.onParentElementResize=e.onParentElementResize.bind(e),Hl.addResizeListener(t.parentElement,e.onParentElementResize),e.updateScale()),!e.hideBryntumDomMessage&&(e.isTaskBoardBase||e.isGridBase||e.isCalendar)&&t.insertBefore(new Comment("POWERED BY BRYNTUM (https://bryntum.com)"),t.firstChild),e.onConnectedCallback&&globalThis.ResizeObserver&&(e.connectedObserver=new ResizeObserver((()=>{e.isElementConnected&&!t.isConnected?(e.onConnectedCallback(!1),e.isElementConnected=!1):!e.isElementConnected&&t.isConnected&&(e.onConnectedCallback(!0,null==e.isElementConnected),e.isElementConnected=!0)})),e.connectedObserver.observe(t))),e.eachWidget(uc,!1),i&&(e.getConfig("tooltip"),!Tc.Ripple&&Tc.RippleClass&&(Tc.Ripple=new Tc.RippleClass({rootElement:e.rootElement})),globalThis.DocsBrowser&&e.floating&&e.closest((e=>{var t;return null===(t=e.element)||void 0===t?void 0:t.closest(".fiddlePanelResult,.b-owned-by-fiddle")}))&&t.classList.add("b-owned-by-fiddle")),e.isPainted=!0,i&&e.triggerConfigs("paint"),e.onInternalPaint({firstPaint:i}),e.trigger("paint",{firstPaint:i}),null===(r=e.afterInternalPaint)||void 0===r||r.call(e,{firstPaint:i}),null!=n&&n.size){for(const{callback:t,thisObj:i,args:r}of n.values())e.callback(t,i,r);n.clear()}i&&e.monitorResize&&!e.scaleToFitWidth&&Hl.onElementResize([{target:t}]),e.hasPainted=!0}}onInternalPaint(){}cancelHideShowAnimation(){const e=this,{currentAnimation:t,element:n}=e;t&&(e.isAnimating=!1,n.classList.contains("b-hiding")&&(n.classList.remove("b-hiding"),e._hidden=!1),t.detacher(),t.resolve(),n.style.transition=n.style[t.styleProp]="",e.currentAnimation=null,e.trigger((t.showing?"show":"hide")+"AnimationEnd"))}afterHideShowAnimate(e){const t=this;e===t.currentAnimation&&(t.element.classList.remove("b-hiding"),t.cancelHideShowAnimation(),t._hidden&&t.afterHideAnimation())}suspendVisibility(){this._visibilitySuspended=(this._visibilitySuspended||0)+1,Object.defineProperty(this,"isVisible",bc)}resumeVisibility(e=!0){--this._visibilitySuspended||(delete this.isVisible,e&&this.triggerPaint())}hide(e=!0){return new Promise((t=>{const n=this;if(n._hidden||!1===n.trigger("beforeHide",{animate:e}))t(!1);else{const{element:i,lastAlignSpec:r}=n,{style:s}=i,o=e&&n.hideAnimation;if(n.clearTimeout("scrollListenerTimeout"),n.clearTimeout("resizeListenerTimeout"),n._hidden=!0,r&&(r.targetOutOfView=null,r.monitorIntersection&&(n.intersectionObserver.takeRecords(),n.intersectionObserver.unobserve(r.target))),n.onConfigChange({name:"hidden",value:!0,was:!1,config:n.$meta.configs.hidden}),!i)return void t();if(i.contains(Wn.getActiveElement(i))&&n.revertFocus(!0),n.isDestroyed)return void t();if(n.cancelHideShowAnimation(),o){const e=Object.keys(o)[0],r=o[e];if(Number(getComputedStyle(n.element)[e])!==r.to){const o=n.currentAnimation={hiding:!0,styleProp:e,resolve:t};i.classList.add("b-hiding"),n.isAnimating=!0,n.currentAnimation.detacher=Xt.onTransitionEnd({element:i,property:e,duration:vc(r.duration)+20,handler:()=>n.afterHideShowAnimate(o),thisObj:n}),s[e]=r.from,Wn.getStyleValue(i,e),s.transition=`${e} ${r.duration} ease ${r.delay}`,s[e]=r.to}else n.syncHiddenCls()}else n.syncHiddenCls();n.ownedWidgets&&Object.values(n.ownedWidgets).forEach((t=>{var n;return t.floating&&(null===(n=t.hide)||void 0===n?void 0:n.call(t,e))})),n.afterHide(!o&&t,o)}}))}realignOnTransitionEnd(e){this.doHideOrRealign(e)}doHideOrRealign({target:e,isTrusted:t}){const n=this,{lastAlignSpec:i,element:r}=n,s=null==i?void 0:i.anchoredTo,o=null==i?void 0:i.target,a=null==i?void 0:i.position,l=Wn.getActiveElement(n);if(!t||!An(r)||e&&(r.contains(e)||e.nodeType===Element.ELEMENT_NODE&&n.owns(e)||e.nodeType===Element.DOCUMENT_NODE&&r.contains(l)&&lc[l]&&globalThis.innerHeight<document.body.offsetHeight))return;if(i.aligningToElement){const e=Wn.isInView(o,!1,n);if(e&&e.equals(i.targetRect))return}const c="hide"===n.scrollAction&&n.getXY();if(n.realign(),!n.isDestroyed&&In(r)&&"hide"===n.scrollAction){const[t,r]=n.getXY(),l=t!==c[0]||r!==c[1];(null!=i&&i.aligningToEvent||(l||"Point"===(null==o?void 0:o.$$name)||a)&&(!s||!An(s)||e&&Wn.isDescendant(e,s)))&&n.hide()}}afterHide(e=null,t=this.hideAnimation){var n,i;const r=this;r._anchor=r._configuredAnchorState,r.removeTransientListeners(),t||r.afterHideAnimation(),r.trigger("hide"),null===(n=r.owner)||void 0===n||null===(i=n.onChildHide)||void 0===i||i.call(n,r),e&&e()}removeTransientListeners(){var e,t;const n=this,{targetObserver:i}=n;n.clearTimeout("resizeListenerTimeout"),n.clearTimeout("scrollListenerTimeout"),i&&(i.disconnect(),delete n.targetObserver),n.documentScrollListener=null===(e=n.documentScrollListener)||void 0===e?void 0:e.call(n),n.targetRootScrollListener=null===(t=n.targetRootScrollListener)||void 0===t?void 0:t.call(n),n.observedTargetEl&&(Hl.removeResizeListener(n.observedTargetEl,n.onTargetResize),n.observedTargetEl=!1),n.observedConstrainEl&&(Hl.removeResizeListener(n.observedConstrainEl,n.onAlignConstraintChange),n.observedConstrainEl=!1)}afterHideAnimation(){const e=this,{element:t}=e;!e.hasOwnProperty("_hideMode")&&e.floating&&e.floatRoot.contains(t)?t.remove():e.syncHiddenCls(),e.defaultAnchorBackgroundColor&&e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}changeHidden(e){const t=this;let n;return t.isConfiguring?(n=Boolean(e),t.syncHiddenCls(n)):(t.trigger("beforeChangeHidden",{hidden:e}),e?t.hide():t.show()),n}syncHiddenCls(e=this._hidden){const{element:t,hideMode:n}=this,i={"b-hidden":e};for(const t of ic)i[`b-hide-mode-${t}`]=t===n&&(e||"display"!==t);Wn.assignClasses(t,i)}get assignedId(){return this.hasGeneratedId?null:this.id}get owner(){return this.parent||this._owner||this.containingWidget}changeOwner(e){if(!this.parent)return e}updateOwner(e,t){const{id:n}=this;t&&(t.ownedWidgets&&delete t.ownedWidgets[n],Wn.removeAttributeValue(t.ariaElement,"aria-owns",n)),e&&((e.ownedWidgets||(e.ownedWidgets={}))[n]=this,Wn.addAttributeValue(e.ariaElement,"aria-owns",n))}get containingWidget(){let e=this.parent;if(!e){var t,n;const i=(null===(t=this.forElement)||void 0===t?void 0:t.nodeType)===Element.ELEMENT_NODE?this.forElement:null===(n=this.element)||void 0===n?void 0:n.parentNode;e=(null==i?void 0:i.closest(".b-widget"))&&Tc.fromElement(i)}return e}get previousSibling(){return this.getSibling(-1)}get nextSibling(){return this.getSibling(1)}getSibling(e){const t=this,{parent:n}=t,i=n?n.childItems:Array.from(t.element.parentElement.querySelectorAll(".b-widget"));return n?i[i.indexOf(t)+e]:Tc.fromElement(i[i.indexOf(t.element)+e])}up(e,t,n){var i;const{owner:r}=this;return e?null==r||null===(i=r.closest)||void 0===i?void 0:i.call(r,e,t,n):r}closest(e,t,n){const i=typeof n,r="number"===i,s="string"===i;for(let i=this,o=1;i;i=i.owner,o++){if(Tc.widgetMatches(i,e,t))return i;if(r&&o>=n)return;if(s&&Tc.widgetMatches(i,n,t))return;if(i===n)return}}owns(e,t){if(e){if("eventPhase"in e&&(e=e.target),e.nodeType===Element.ELEMENT_NODE){if(this.element.contains(e))return!0;e=e.getAttribute("owned-by")?Tc.getById(e.getAttribute("owned-by")):Tc.fromElement(e)}for(;e;){if(e===this||t&&this.ownedWidgets&&Object.values(this.ownedWidgets).some((t=>t.owns(e,!0))))return!0;e=e.owner}}return!1}eachAncestor(e){let t=this.owner;for(;t;){if(!1===e(t))return!1;t=t.owner}return!0}changeMaximizeOnMobile(e){const t=this;if(t.floating&&d.isMobile){const{initialConfig:n}=t;e?(t.centered=t.modal=!1,t.maximized=!0):(t.centered=n.centered,t.modal=n.modal,t.maximized=n.maximized)}}changeMonitorResize(e,t){const n=!this.scaleToFitWidth&&Boolean(e);if(n!==Boolean(t))return n}updateMonitorResize(e){const t=this;pc(t,"onElementResize")||(t.onElementResize=t.onElementResize.bind(t)),Hl[e?"addResizeListener":"removeResizeListener"](t.element,t.onElementResize)}changeReadOnly(e){if(e=Boolean(e),Boolean(this._readOnly)!==e)return e}updateReadOnly(e){var t;null===(t=this.element)||void 0===t||t.classList[e?"add":"remove"]("b-readonly"),this.isConfiguring||(this.eachWidget((t=>{t.ignoreParentReadOnly||("_originalReadOnly"in t||(t._originalReadOnly=t.config.readOnly||!1),t.readOnly=e||t._originalReadOnly)}),!1),this.trigger("readOnly",{readOnly:e}))}eachWidget(e,t=!0,n){const i=n?this.childItemsOrderedByRelevance:this.childItems,r=(null==i?void 0:i.length)||0,s={};for(let o=0;o<r;o++){const r=i[o];if(s.down=t,!1===e(r,s))return!1;if(s.down&&r.eachWidget&&!1===r.eachWidget(e,t,n))return!1}return!0}queryAll(e){const t=[];return this.eachWidget((n=>{e(n)&&t.push(n)})),t}query(e,t){let n=null;return this.eachWidget((t=>{if(e(t))return n=t,!1}),!0,t),n}getWidgetByRef(e){var t,n;return e instanceof Tc?e:(null==this||null===(t=this.widgetMap)||void 0===t?void 0:t[e])||(null==this||null===(n=this.owner)||void 0===n?void 0:n.getWidgetByRef(e))}onFocusIn(e){const t=this,{element:n}=t;t.containsFocus=!0,t.focusInEvent=e,(t.floating||t.positioned)&&t.toFront(),n.classList.add("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),n.contains(e._target)&&t.onInternalKeyDown&&!t.keyDownListenerRemover&&(t.keyDownListenerRemover=Xt.on({element:n,keydown:"onInternalKeyDown",thisObj:t})),t.trigger("focusin",e)}onFocusOut(e){const t=this;t.keyDownListenerRemover&&(t.keyDownListenerRemover(),t.keyDownListenerRemover=null),t.isDestroyed||(e.relatedTarget||t.revertFocus(!t.isVisible),t.containsFocus=!1,t.element.classList.remove("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),t.trigger("focusout",e))}captureFocus(){const e=this,t=Wn.getActiveElement(e),n=e.contains(t)&&e.captureFocusItem(t);return(i,r)=>{if(n&&!e.isDestroying){(Wn.getActiveElement(e)!==t||r)&&n(i)}}}captureFocusItem(e){return(t=!0)=>{this.contains(e)&&(t?e.focus():e.focus({preventScroll:!0}))}}contains(e,t){const{element:n}=this;if(e&&n)return e.isWidget&&(e=e.element),n.contains(e)&&(!t||n!==e)}revertFocus(e){var t,n;const i=this,r=Wn.getActiveElement(i);let s=null===(t=i.focusInEvent)||void 0===t?void 0:t.relatedTarget;(e||i.containsFocus&&(null===(n=s)||void 0===n?void 0:n.nodeType)===Element.ELEMENT_NODE&&i.element.contains(r))&&(s&&Wn.isFocusable(s)||(s=i.getFocusRevertTarget()),i._isRevertingFocus=!0,s&&Wn.isFocusable(s)?(s._isRevertingFocus=!0,s.focus({preventScroll:!0}),s._isRevertingFocus=!1):null==r||r.blur(),i._isRevertingFocus=!1)}getFocusRevertTarget(){const e=this,{owner:t,focusInEvent:n}=e,i=n&&n.backwards?1:-1;let r=n&&n.relatedTarget;const s=r&&Tc.fromElement(r);if(t&&!t.isDestroyed&&(!r||!Wn.isFocusable(r)||s&&!s.isFocusable)){var o;if(r=null,t.eachWidget){const n=[];if(t.eachWidget((t=>{(t===e||t.isFocusable)&&n.push(t)}),!1),n.length>1){const t=n.indexOf(e);r=n[t+i]||n[t-i]}}!r&&t.isFocusable&&(r=t),r=r?r.focusElement:null===(o=t.getFocusRevertTarget)||void 0===o?void 0:o.call(t)}return r}getStaticWidgetClasses(e,t){const n=new _t,i=this.$meta.hierarchy;let r,s,o,a,l;for(s=i.indexOf(e);s<i.length;++s){var c;r=i[s],l=Reflect.getOwnPropertyDescriptor(r.prototype,"widgetClass"),null!==(c=l)&&void 0!==c&&c.get?a=l.get.call(this):(o=pc(r,"$$name")||pc(r,"$name")||pc(r,"_$name")?r.$$name:r.name,(o.length<3||o.includes("$"))&&console.warn(`Class "${o}" extending "${r.$name}" should have "$name" static getter with no less than 3 chars.`),a=`b-${o.toLowerCase()}`),a&&n.add(t?a+t:a)}return n}get rootUiClass(){return Tc}get staticClassList(){const{$meta:e}=this;let t=e.staticClassList;return t||(e.staticClassList=t=this.getStaticWidgetClasses(Tc),d.isTouchDevice&&t.add("b-touch")),t}get uiClasses(){return this.getConfig("ui"),this._uiClasses}get uiClassList(){return this.getConfig("ui"),this._uiClassList}get widgetClassList(){const e=this,{cls:t,defaultCls:n,uiClasses:i}=e;let{staticClassList:r}=e;(n||t)&&(r=r.clone(),n&&r.assign(n),t&&r.assign(t));const s=r.values;return i&&s.push(...i),e.floating&&s.push("b-floating"),"hide"===e.collapsify&&s.push("b-collapsify-hide"),s}changeCls(e){return _t.from(e)}updateCls(e,t){if(!this.isConfiguring&&!this.isComposable){const{element:n}=this;t&&W.getTruthyKeys(t).forEach((e=>n.classList.remove(e))),e.assignTo(n)}}changeContentElementCls(e){return _t.from(e)}changeHtmlCls(e){return _t.from(e)}changeDefaultCls(e){return _t.from(e,!0)}updateHideMode(){this.hasPainted&&this.syncHiddenCls()}changeUi(e){return _t.from(e)}updateUi(e){var t;let n,i,r=null;if(e){const t=this.getStaticWidgetClasses(this.rootUiClass);for(i in e)if(e[i])for(n in t)t[n]&&((r||(r=new _t))[`${n}-ui-${i}`]=1)}this._uiClasses=null===(t=r)||void 0===t?void 0:t.values,this._uiClassList=r}fromCache(e,t=!1,n=this.element){var i;if(!n)return null;const r=this;return null!==(i=r.cache)&&void 0!==i&&i[e]?r.cache[e]:(r.cache||(r.cache={}),r.cache[e]=t?Wn.children(n,e):n.querySelector(e))}emptyCache(){this.cache&&(this.cache={})}changeMasked(e,t){var n;if("trial"!==(null===(n=this.masked)||void 0===n?void 0:n.type)){if(!0!==e&&""!==e||(e=" "),t&&!t.isDestroyed)"string"==typeof e?(t.text=e,e=t):e?(t.setConfig(e),e=t):t.destroy();else if(e){const t=Tc.resolveType("mask");(e=t.mergeConfigs(this.maskDefaults,e)).owner=this,e=t.mask(e)}return e||null}}onMaskAutoClose(e){e.isDestroyed&&e===this.masked&&(this.masked=null)}mask(e){return this.masked=e,this.masked}unmask(){this.masked=null}onInternalResize(e,t,n,i,r){this._width=e.offsetWidth,this._height=e.offsetHeight}onElementResize(e,t){const n=this,{element:i}=n,r=n._width??n._oldWidth,s=n._height,o=i.offsetWidth,a=i.offsetHeight;n.floating&&t&&n.onFloatingWidgetResize(...arguments),n.suspendResizeMonitor||r===o&&s===a||(n.onInternalResize(i,o,a,r,s),n.trigger("resize",{width:o,height:a,oldWidth:r,oldHeight:s}))}onFloatingWidgetResize(e,t,n){const i=this,{lastAlignSpec:r,constrainTo:s}=i;if(i.isVisible&&r&&r.target){const e=!t||n.height!==t.height,o=!t||n.width!==t.width,a=s&&!Pt.from(s).contains(Pt.from(i.element,null,!0));(e&&2!==r.zone||o&&1!==r.zone||a)&&i.requestAnimationFrame((()=>i.realign()))}}updateScale(){const e=this,t=e.element,n=t.parentElement;e.configuredWidth||(e.configuredWidth=e.width),t.style.display="none";const i=Pt.client(n).width/e.configuredWidth,r=e.scale=e.allowGrowWidth?Math.min(i,1):i;t.style.transform=`scale(${r})`,t.style.transformOrigin="top left",t.style.display="",e.allowGrowWidth&&i>1&&(e.width=e.configuredWidth*i)}onParentElementResize(e){this.updateScale()}parseTRBL(e,t="px"){if("number"==typeof(e=e||0))return[`${e}${t}`,`${e}${t}`,`${e}${t}`,`${e}${t}`];const n=e.split(" "),i=n.length;return 1===i?n[1]=n[2]=n[3]=n[0]:2===i?(n[2]=n[0],n[3]=n[1]):3===i&&(n[3]=n[1]),[isFinite(n[0])?`${n[0]}${t}`:n[0],isFinite(n[1])?`${n[1]}${t}`:n[2],isFinite(n[2])?`${n[2]}${t}`:n[3],isFinite(n[3])?`${n[3]}${t}`:n[4]]}get documentRoot(){var e;return(null===(e=this.owner)||void 0===e?void 0:e.documentRoot)||this.element.getRootNode()}get eventRoot(){var e,t;return null!==(e=this.element)&&void 0!==e&&e.isConnected?Wn.getRootElement(this.element):(null===(t=this.owner)||void 0===t?void 0:t.eventRoot)||this._rootElement}get rootElement(){const e=this;if(!e._rootElement){var t,n;let i=(null===(t=e.owner)||void 0===t?void 0:t.rootElement)||Wn.getRootElement(e.forElement||(null!==(n=e.element)&&void 0!==n&&n.isConnected?e.element:e.getRenderContext()[0]||e.element));i||(i=document.body),e._rootElement=i}return e._rootElement}get floatRoot(){const{rootElement:e}=this;let{floatRoot:t}=e;if(t)e.contains(t)||e.appendChild(t);else{var n;const{outerCls:i}=Tc,r=null===(n=Wn.getThemeInfo(null,e))||void 0===n?void 0:n.name;if(!Wn.isValidFloatRootParent(e))throw new Error("Attaching float root to wrong root");r&&i.push(`b-theme-${r.toLowerCase()}`),t=e.floatRoot=Wn.createElement({className:`b-float-root ${i.join(" ")}`,parent:e}),nc.push(t),d.isAndroid&&(t.style.height=`${screen.height}px`,Xt.on({element:globalThis,orientationchange:()=>t.style.height=`${screen.height}px`,thisObj:this})),ti.ion({theme:({theme:e,prev:n})=>{t.classList.add(`b-theme-${e.toLowerCase()}`),t.classList.remove(`b-theme-${n.toLowerCase()}`)}})}return t.classList.toggle("b-rtl",Boolean(this.rtl)),t}get floatRootMaxZIndex(){let e=1;return Array.from(this.floatRoot.children).forEach((t=>{const n=parseInt(getComputedStyle(t).zIndex||0,10);n>e&&(e=n)})),e}get accessibility(){return this.constructor.accessibility}static get accessibility(){return document.body.classList.contains("b-accessibility")}set accessibility(e){this.constructor.accessibility=e}static set accessibility(e){document.body.classList.toggle("b-accessibility",Boolean(e))}static get floatRoots(){return nc}static removeFloatRoot(e){nc.splice(nc.indexOf(e),1)}static get outerCls(){const e=["b-outer"],{platform:t}=d;return t&&e.push(`b-${t}`),d.isTouchDevice&&e.push("b-touch-events"),d.isMobile&&e.push("b-mobile"),Wn.scrollBarWidth?e.push("b-visible-scrollbar"):e.push("b-overlay-scrollbar"),d.isChrome?e.push("b-chrome"):d.isSafari?e.push("b-safari"):d.isFirefox&&e.push("b-firefox"),d.isPhone&&e.push("b-phone"),globalThis.ResizeObserver||e.push("b-no-resizeobserver"),e}get isAnimating(){return this._isAnimatingCounter>0}set isAnimating(e){const t=this,{_isAnimatingCounter:n}=t;t._isAnimatingCounter=Math.max(0,n+(e?1:-1)),0===n&&e?(t.element.classList.add("b-animating"),t.trigger("animationStart")):1!==n||e||(t.element.classList.remove("b-animating"),t.trigger("animationEnd"))}async waitForAnimations(){this.isAnimating&&await this.await("animationEnd",{checkLog:!1})}async executeAndAwaitAnimations(e,t){const n=e.getAnimations({subtree:!0});await t();const i=e.getAnimations({subtree:!0}),r=$e.delta(n,i).onlyInB.filter((e=>e.effect.getTiming().iterations!==1/0));r.length&&await Promise.allSettled(r.map((e=>e.finished)))}static query(e,t=!1){const{idMap:n}=Tc.identifiable;for(const i in n)if(Tc.widgetMatches(n[i],e,t))return n[i];return null}static queryAll(e,t=!1){const{idMap:n}=Tc.identifiable,i=[];for(const r in n)Tc.widgetMatches(n[r],e,t)&&i.push(n[r]);return i}static fromElement(e,t,n){const i=typeof t;e&&!e.nodeType&&(e=e.target),("number"===i||t&&t.nodeType===Element.ELEMENT_NODE)&&(n=t,t=null);let r,s,o,a=e,l=0;for("number"!=typeof n&&(r=n,n=Number.MAX_VALUE),"string"===i&&(t=t.toLowerCase());a&&a.nodeType===Element.ELEMENT_NODE&&l<n&&a!==r;){if(s=a.dataset&&a.dataset.ownerCmp||a.id,s){if(o=Tc.getById(s),o){if(!t)return o;if("function"===i){if(t(o))return o}else if(Tc.widgetMatches(o,t,!0))return o}l++}a=$n(a)}return null}static fromSelector(e){const t=document.querySelector(e);return t?Tc.fromElement(t):null}triggerFieldChange(e,t=!0){var n;t?this.trigger("change",e):e.source=this,null===(n=this.eachAncestor)||void 0===n||n.call(this,(t=>{var n,i;if(null===(n=t.onFieldChange)||void 0===n||n.call(t,e),null!==(i=t.isolateFieldChange)&&void 0!==i&&i.call(t,this))return!1}))}isolateFieldChange(e){return this.isolateFields}setupFocusListeners(){ti.setupFocusListenersOnce(this.eventRoot,Xt)}static widgetMatches(e,t,n){return"*"===t||("function"==typeof t?t(e):Tc.isType(e,t,n))}static attachTooltip(e,t){return"string"==typeof t&&(t={html:t}),Tc.create(Object.assign({forElement:e},t),"tooltip"),e}static append(e,t={}){return(t instanceof HTMLElement||"string"==typeof t)&&(t={appendTo:t}),$e.asArray(e).map((e=>Tc.create(W.assign({},t,e))))}changeDock(e){return"start"===e?"left":"end"===e?"right":e}updateRtl(e){super.updateRtl(e),this.eachWidget((t=>{"rtl"in t.initialConfig||(t.rtl=e)}))}}const Mc=Tc.prototype;["compose","domSyncCallback"].forEach((e=>Mc[e].$nullFn=!0)),Tc.initClass(),Wn.Widget=Tc,ti.Widget=Tc,Object.assign(globalThis.bryntum||(globalThis.bryntum={}),{Widget:Tc,get:(e=globalThis.$0)=>e.nodeType?Tc.fromElement(e):Tc.getById(e),query:Tc.query,queryAll:Tc.queryAll,fromElement:Tc.fromElement,fromSelector:Tc.fromSelector}),Tc._$name="Widget";class Ic extends(Pe.mixin(at,es)){static type="default";static configurable={owner:null,containerCls:"b-auto-container",itemCls:null};static factoryable={defaultType:"default"};get contentElement(){var e;return null===(e=this.owner)||void 0===e?void 0:e.contentElement}onChildAdd(e){}onChildRemove(e){}renderChildren(){const e=this,{owner:t,itemCls:n}=e,{contentElement:i,items:r}=t,s=t.itemCls,o=null==r?void 0:r.length;if(o){t.textContent=!1;for(let e,a,l=0;l<o;l++){const o=r[l],{element:c,positionable:d}=o,{classList:u}=c;c.dataset.itemIndex=l,u.contains("b-outer")&&u.remove(...Tc.outerCls),n&&u.add(n),s&&u.add(s),a=i,d&&(e=t.getPositionableLocation(d),(a=e[0])||(a=e[1].parentElement,o.insertBefore=e[1])),o.render(a,Boolean(t.isPainted))}}e.syncPendingConfigs(),e.syncChildCount()}removeChild(e){const t=this,{element:n}=e,{owner:i,itemCls:r}=t,{contentElement:s}=i,o=i.itemCls;s.contains(n)&&n.remove(),delete n.dataset.itemIndex,r&&n.classList.remove(r),o&&n.classList.remove(o),t.fixChildIndices(),t.syncChildCount()}appendChild(e){const{element:t}=e,{owner:n,itemCls:i}=this,{contentElement:r}=n,s=n.itemCls;t.dataset.itemIndex=n.indexOfChild(e),n.textContent=!1,i&&t.classList.add(i),s&&t.classList.add(s),e.render(r,Boolean(n.isPainted)),this.syncChildCount()}insertChild(e,t){const n=this,{element:i}=e,{owner:r,itemCls:s}=n,{contentElement:o}=r,a=Wn.getChild(o,`[data-item-index="${t}"]`),l=r.itemCls;r.textContent=!1,s&&i.classList.add(s),l&&i.classList.add(l),o.insertBefore(i,a),e.render(null,Boolean(r.isPainted)),n.fixChildIndices(),n.syncChildCount()}fixChildIndices(){this.owner.items.forEach(((e,t)=>{e.element.dataset.itemIndex=t}))}syncChildCount(){var e;const{owner:t}=this,{length:n}=t.items;null===(e=t.contentElement)||void 0===e||e.classList[1===n?"add":"remove"]("b-single-child")}syncConfigLater(e){const t=this.pendingConfigs||(this.pendingConfigs=[]);t.includes(e)||t.push(e)}syncConfigStyle({name:e,style:t,classes:n,map:i}){const r=this,s=`b-box-${e}-`,{contentElement:o}=r,a=r[e];let l=(null==i?void 0:i[a])||a;if(o){if(n){const{classList:e}=o;n.forEach((t=>{t!==l&&e.remove(s+t)})),n.includes(l)&&(e.add(s+l),l="")}o.style[t]=l}else r.syncConfigLater(e)}syncPendingConfigs(){const e=this,{pendingConfigs:t}=e;let n;if(t)for(e.pendingConfigs=null;n=t.pop();)e[e.$meta.configs[n].updater](e[n])}}Ic.initClass(),Ic._$name="Layout";let Ac=0;const kc=e=>e.ripple;class Fc extends Tc{static $name="Ripple";static type="ripple";static get defaultConfig(){return{old_element:{children:[{className:"b-ripple-inner",reference:"rippleElement"}]},element:{children:[{tag:"svg",class:"b-ripple-inner",reference:"rippleElement",ns:"http://www.w3.org/2000/svg",version:"1.1",viewBox:"0 0 100 100",children:[{reference:"circleElement",tag:"circle",cx:"0",cy:"0",r:10}]}]},floating:!0,hideAnimation:!1,showAnimation:!1,scrollAction:"realign",color:"rgba(0,0,0,.3)",startRadius:10,radius:100}}afterConstruct(){super.afterConstruct(),Xt.on({element:this.rootElement,mousedown:"onRippleControllingEvent",thisObj:this,capture:!0,once:!0})}onRippleControllingEvent(e){var t;const n=this;n.show();const i=Wn.getStyleValue(n.circleElement,"animationName");n.hide(),null===(t=n.listenerDetacher)||void 0===t||t.call(n),i&&"none"!==i&&(n.listenerDetacher=Xt.on({mousedown:{element:n.rootElement,capture:!0,handler:"onMousedown"},touchstart:{element:n.rootElement,capture:!0,handler:"onTouchStart"},animationend:{element:n.circleElement,handler:"onAnimationEnd"},thisObj:n}),"mousedown"===e.type&&(n.onMousedown(e),ti.ion({theme:"onRippleControllingEvent",thisObj:this})))}onTouchStart(e){Ac=performance.now(),this.handleTriggerEvent(e)}onMousedown(e){performance.now()-Ac>200&&this.handleTriggerEvent(e)}handleTriggerEvent(e){const t=Tc.fromElement(e.target,kc);if(t){const n=t.ripple,i=n.delegate?e.target.closest(n.delegate):t.focusElement||t.element;if(i){const r=W.assign({event:e,target:i,radius:this.radius},n);if("string"==typeof r.clip&&(r.clip=t[r.clip]||e.target.closest(r.clip),!r.clip))return;this.ripple(r)}}}ripple({event:e,point:t=Xt.getClientPoint(e),target:n=e.target,clip:i=n,radius:r=this.radius,color:s=this.color}){this.clip=i;const o=this,a=(i=Pt.from(i,null,!0)).getDelta(t),l=o.rippleElement.style,c=o.circleElement,d=Wn.getStyleValue(n,"border-radius");o.hide(),l.transform=`translateX(${a[0]}px) translateY(${a[1]}px)`,l.height=l.width=`${r}px`,o.element.style.borderRadius=d,c.setAttribute("r",r),c.setAttribute("fill",s),o.showBy({target:i,align:"c-c",matchSize:!0})}onAnimationEnd(e){"b-ripple-expand"===e.animationName&&this.hide()}}Tc.RippleClass=Fc,Fc._$name="Ripple";const Pc=e=>e.element.classList.contains("b-visible"),Oc=e=>!Pc(e)&&e.isVisible;class Lc extends Tc{static $name="Mask";static type="mask";static configurable={autoClose:null,cover:null,icon:"b-icon b-icon-spinner",errorDefaults:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},maxProgress:null,mode:"dark",progress:null,target:{$config:"nullify",value:void 0},text:null,type:null,showDelay:null,useTransition:!1};static delayable={deferredClose:0,delayedShow:0,syncCover:{type:"throttle",delay:100}};static counter=0;static get(e){return Cl.get(e,"masks")||Cl.set(e,"masks",[])}static getActive(e){return Lc.get(e).find(Pc)||null}static getPending(e){return Lc.get(e).filter(Oc).sort(Tc.weightSortFn)}static mask(e,t=document.body){return Lc.new({target:t},e)}static mergeConfigs(...e){return e=e.map((e=>"string"==typeof e?{text:e}:e)),super.mergeConfigs(...e)}static sync(e){const t=Lc.getActive(e),n=!t&&Lc.getPending(e)[0]||null,i=t||n,r=(null==i?void 0:i.mode)||"",s=r.endsWith("blur")?`b-masked-${r}`:"";let o,a,l;for(o of(n&&(a=n.element.classList,n.showDelay&&!e.classList.contains("b-masked")&&(a.add("b-delayed-show"),n.delayedShow()),a.add("b-visible")),e.classList.toggle("b-masked",Boolean(i)),e.children))a=o.classList,a.contains("b-mask")||(l=Array.from(a).filter((e=>e.startsWith("b-masked-")&&s!==e)),l.length&&a.remove(...l),s&&a.add(s))}static unmask(e=document.body){var t;const n=Lc.get(e),i=n.length;return i?null===(t=n[i-1])||void 0===t?void 0:t.close():null}static unmaskAll(e=document.body){return Lc.get(e).filter((e=>!Pc(e))).forEach((e=>e.destroy())),Lc.unmask(e)}destroy(){"trial"!==this.type&&super.destroy()}compose(){const{icon:e,maxProgress:t,mode:n,progress:i,showDelay:r,text:s,useTransition:o}=this;return{class:{"b-mask":1,"b-delayed-show":r,"b-progress":t,"b-prevent-transitions":!o,[`b-mask-${n}`]:1},children:{maskContent:{class:"b-mask-content",children:{progressElement:t?{class:"b-mask-progress-bar",style:{width:`${Math.max(0,Math.min(100,Math.round(i/t*100)))}%`}}:null,maskText:{class:"b-mask-text",html:(e?`<i class="b-mask-icon ${e}"></i>`:"")+s}}}}}}generateAutoId(){const{type:e}=this;return`mask${"string"==typeof e?e.trim():""}-${Lc.counter++}`}updateAutoClose(e){this.deferredClose.cancel(),e&&(this.deferredClose.delay=e,this.deferredClose())}updateCover(){this.syncCover()}syncCover(){var e,t;null===(e=this.owner)||void 0===e||null===(t=e.syncMaskCover)||void 0===t||t.call(e,this)}set error(e){this.setConfig({...this.errorDefaults,text:e})}onOwnerResize(){this.syncCover()}updateOwner(e){this.detachListeners("cover"),null==e||e.ion({name:"cover",recompose:"onOwnerResize",resize:"onOwnerResize",thisObj:this})}updateShowDelay(e){const{delayedShow:t}=this;t.delay=e,e||t.flush()}changeTarget(e){return void 0===e?e=document.body:"string"==typeof e&&(e=this.owner[e]),e}updateTarget(e,t){const n=this,{id:i,element:r}=n,s=t&&Lc.get(t);t&&(t[i]===n&&delete t[i],$e.remove(s,n),Lc.sync(t)),e?(e[i]||(e[i]=n),r.parentNode!==e&&e.appendChild(r),$e.include(Lc.get(e),n),Lc.sync(e)):r.remove()}deferredClose(){var e;const t=this,{owner:n}=t;t.close().then((()=>{var e;return null==n||null===(e=n.onMaskAutoClose)||void 0===e?void 0:e.call(n,t)})),null==n||null===(e=n.onMaskAutoClosing)||void 0===e||e.call(n,t)}delayedShow(){this.element.classList.remove("b-delayed-show")}updateHidden(e,t){var n;null===(n=super.updateHidden)||void 0===n||n.call(this,e,t),e&&this.element.classList.remove("b-visible"),Lc.sync(this.target)}afterShow(...e){var t;null===(t=super.afterShow)||void 0===t||t.call(this,...e),Lc.sync(this.target)}afterHide(...e){var t;null===(t=super.afterHide)||void 0===t||t.call(this,...e),this.element.classList.remove("b-visible"),Lc.sync(this.target)}async close(){await this.hide(),this.destroy()}}Lc.initClass(),Lc._$name="Mask";const $c=Object.freeze({}),{isArray:_c}=Array,jc=e=>e.weight,Bc=e=>e&&!e.hidden,Hc=["display","flex-direction"],Vc={default:1,box:1},zc=Symbol("options");class Nc extends Tc{static $name="Container";static type="container";static get configurable(){return{items:null,lazyItems:{$config:["lazy"],value:null},defaults:null,defaultType:"widget",layoutStyle:null,itemCls:null,layout:{type:"default"},namedItems:{$config:"lazy",value:null},overflowable:{value:null,default:!1,$config:null},textContent:!0,record:null,strictRecordMapping:null,autoUpdateRecord:null,autoUpdateFields:null,hideWhenEmpty:null,contentElMutationObserver:{$config:["lazy","nullify"],value:!0},isolateFields:!1,focusDescendant:!1,defaultBindProperty:null,defaultFocus:null}}static get prototypeProperties(){return{flexRowCls:"b-flex-row",flexColCls:"b-flex-column",initialItems:!0}}startConfigure(e){const t=e.items||e.lazyItems;(this.hasItems=Boolean(t&&(_c(t)?t:Object.keys(t)).length))||(this.initialItems=!1),super.startConfigure(e)}get firstItem(){return this.getAt(0)}get lastItem(){return this.getAt(-1)}getPositionableItems(e,t){var n;const i=(null===(n=this._items)||void 0===n?void 0:n.filter((t=>e?t.positionable===e:t.positionable)))||[];return t?Object.fromEntries(i.map(((e,t)=>[`$${e.positionable}${t}`,e.element]))):i}getPositionableLocation(e){return[this.contentElement]}getAt(e){return this.ensureItems().at(e)}remove(...e){let t=!0;1===e.length&&(_c(e[0])?e=e[0]:t=!1);const n=this,{_items:i}=n,r=[];for(let t=0;t<e.length;t++){const s=e[t];i.includes(s)&&(i.remove(s),n.layout.removeChild(s),r.push(s),n.onChildRemove(s))}return t?r:r[0]}removeAll(){return this.remove(this.items)}add(...e){const t=this,n=t.ensureItems(),i=[];let r,s,o,a=!0;for(1===e.length&&(_c(e[0])?e=e[0]:a=!1),s=0;s<e.length;s++){var l;r=e[s],r.isWidget?r.parent=t:r=t.createWidget(r),null!=(null===(l=r)||void 0===l?void 0:l.weight)?(o=$e.findInsertionIndex(r,n.values,Tc.weightSortFn),i.push(t.insert(r,o))):r&&(n.includes(r)||(n.add(r),t.onChildAdd(r),t.layout.appendChild(r),i.push(r)))}return a?i:i[0]}ensureItems(){const e=this;return e.getConfig("items"),e.getConfig("lazyItems"),e._items||(e.items=[]),e._items}insert(e,t){const n=this,i=n.ensureItems();e instanceof Tc?e.parent=n:e=n.createWidget(e),i.includes(t)&&(t=n.indexOfChild(t)),t=Math.min(t,i.count);const r=i.values;return r.splice(t,0,e),i.values=r,n.onChildAdd(e),n.layout.insertChild(e,t),e}indexOfChild(e){return this.items.indexOf(e)}changeLazyItems(e){this.items=e,this.layout.renderChildren()}onChildWeightChange(e){if(this.items.length>1){var t;const{lastItem:n}=this;this._items.sort(Tc.weightSortFn);const{items:i}=this;this.contentElement.insertBefore(e.element,(null===(t=i[i.indexOf(e)+1])||void 0===t?void 0:t.element)||n.element.nextSibling)}}changeItems(e,t){const n=this,i=[],r=new Qs;return _c(e)?n.processItemsArray(e,i):e&&n.processItemsObject(e,n.namedItems,i),i.some(jc)&&i.sort(Tc.weightSortFn),r.add(i),t&&t.forEach((e=>{n.remove(e),r.includes(e)||e._createdBy!==n||e.destroy()})),r}afterConstruct(){const{rtl:e}=this,{classList:t}=this.contentElement;t.toggle("b-rtl",!0===e),t.toggle("b-ltr",!1===e)}updateRtl(e){super.updateRtl(e);const{contentElement:t}=this;t&&(t.classList.toggle("b-rtl",!0===e),t.classList.toggle("b-ltr",!1===e))}updateItems(e,t){let n=0;e.forEach((e=>{this.onChildAdd(e),t&&!t.temporary&&this.layout.insertChild(e,n),++n})),this.initialItems=!1}updateHideWhenEmpty(){this.syncChildCount(this.rendered)}get items(){const e=this;if(e.getConfig("lazyItems"),!e._items){if(e.initializingItems)return[];e._items=new Qs,e._items.temporary=!0}return e._items.values}processItemsArray(e,t){const n=e.length;let i,r;for(i=0;i<n;i++)r=e[i],r instanceof Tc?(r.parent=this,r.element.classList.remove(...Tc.outerCls)):r=this.createWidget(r),r&&((r.ref||r.id)&&this.addDescendant(r),t.push(r))}processItemsObject(e,t,n=[]){let i,r;for(r in e)i=e[r],i&&(t&&r in t&&(i="object"==typeof i?W.merge(W.clone(t[r]),i):t[r]),i&&(i instanceof Tc?i.parent=this:(i instanceof Object&&(i.ref=r),i=this.createWidget(i)),i&&(i.ref=r,this.addDescendant(i),n.push(i))));return n}onChildAdd(e){const t=this;if(e.innerItem&&t.readOnly&&!e.ignoreParentReadOnly&&(e.readOnly=!0),t.onChildAddLayout(e),e.ref||e.id)for(let n=t;n;n=n.parent)n.addDescendant(e);t.syncChildCount(!0),!t.onConfigChange.$nullFn&&t.onConfigChange({name:"items",config:t.$meta.configs.items})}onChildAddLayout(e){e.innerItem&&this.layout.onChildAdd(e)}onChildHide(e){var t;super.onChildHide(e),null!==(t=this._items)&&void 0!==t&&t.includes(e)&&this.syncChildCount(!0)}onChildShow(e){var t;super.onChildShow(e),null!==(t=this._items)&&void 0!==t&&t.includes(e)&&this.syncChildCount(!0)}syncChildCount(e){if(!this.isConfiguring&&!this.isDestroying){const t=this,{items:n,hasItems:i}=t,r=n.filter(Bc),{length:s}=r;if(t.visibleChildCount=s,t.hideWhenEmpty&&e){const e=Boolean(!s);Boolean(t._hidden)!==e&&(t.hidden=e)}n.forEach((e=>e.element.classList.remove("b-last-visible-child","b-first-visible-child"))),s&&(r[0].element.classList.add("b-first-visible-child"),r[s-1].element.classList.add("b-last-visible-child")),t.hasItems=Boolean(t.childItems.length),t.contentElement.classList[s?"remove":"add"]("b-no-visible-children"),t.isComposable?i!==t.hasItems&&t.recompose():t.updateTextContent(t._textContent)}}syncFlexDirection(){const{contentElement:e,flexColCls:t,flexRowCls:n}=this,i=new _t(e.className),r=Wn.getStyleValue(e,Hc);i[n]=i[t]=0,"flex"===r.display&&(i["row"===r["flex-direction"]?n:t]=1),Wn.syncClassList(e,i)}addDescendant(e){const t=e.ref||e.id,n=this._widgetMap||(this._widgetMap={});n[t]||(n[t]=e)}cleanupWidgetMap(e){const t=this,n=new Map,i=e.ref||e.id;i&&n.set(i,e),e.eachWidget((e=>{const t=e.ref||e.id;t&&n.set(t,e)}));for(let e=t;e;e=e.parent)for(const[t,i]of n)e.widgetMap[t]===i&&delete e.widgetMap[t]}onChildRemove(e){const t=this;t.cleanupWidgetMap(e),t.layout.onChildRemove(e),t.syncChildCount(!0),!t.onConfigChange.$nullFn&&t.onConfigChange({name:"items",config:t.$meta.configs.items})}get widgetMap(){return this._widgetMap||(this._widgetMap={}),this.initializingItems||this.getConfig("items"),this._widgetMap}changeRecord(e){return this._record=null==e?$c:null,e}updateRecord(e){var t;const n=this;null===(t=n.recordUpdateDetacher)||void 0===t||t.call(n),n.trigger("beforeSetRecord",{record:e}),n.clearError(),n._hasChanges=!1,n.setValues(e,{onlyName:n.strictRecordMapping,highlight:Boolean(n.$highlight)}),n.autoUpdateFields&&null!=e&&e.firstStore&&(n.recordUpdateDetacher=e.firstStore.ion({update:n.onRecordUpdated,thisObj:n}))}setRecord(e,t){this.$highlight=t,this.record=e,this.$highlight=!1}onRecordUpdated({record:e}){e===this.record&&this.setValues(this.record,!0,!0)}onFieldChange({source:e,userAction:t}){const n=this,{hasChanges:i}=n;if(n.autoUpdateRecord&&t){const{record:t,strictRecordMapping:i}=n,{name:r,ref:s,isValid:o=!0,defaultBindProperty:a}=e,l=e[a||"value"],c=i?r:r||s;t&&c&&o&&(t.isModel?t.setValue(c,l):t[c]=l)}if(!n.isSettingValues){const{initialValues:t}=n;if(t){const i=e.getValueName(t[zc]);i&&((n.changeSet||(n.changeSet={}))[i]=!W.isEqual(e.value,t[i]),n._hasChanges=Boolean(n.changeSet&&Object.values(n.changeSet).some((e=>e))))}n.hasChanges!==i&&n.trigger("dirtyStateChange",{dirty:n.hasChanges})}}get hasChanges(){return Boolean(this._hasChanges)}getValues(e){const t={};return this.eachWidget(((n,i)=>{n.isolateFields?i.down=!1:!("name"in n)||e&&!e(n)||(t[n.name]=n.value)}),!0),t}get values(){const e={};return this.gatherValue(e),e}set values(e){this.assignValue(e)}get isSettingValues(){return Boolean(this.assigningValues)}get assigningValues(){var e;return this._assigningValues||(null===(e=this.parent)||void 0===e?void 0:e.assigningValues)}set assigningValues(e){this._assigningValues=e}assignValue(e,t){super.assignValue(e,t),this.isolateFields||this.setValues(e,t)}gatherValue(e){super.gatherValue(e),this.isolateFields||this.gatherValues(e)}setValues(e,t=this.assignValueDefaults){const n=this;n.assigningValues=t,n.initialValues={optionsProp:t},n.eachWidget((i=>{const r=i.getValueName(t);!r||e&&!(r in e)||(n.initialValues[r]=(null==e?void 0:e[r])||null),i.assignValue(e,t)}),!1),n.assigningValues=!1}get hasNoChildren(){const e=this,{items:t,lazyItems:n}=e.initialConfig,i=t&&(_c(t)?t:W.values(t)),r=n&&(_c(n)?n:W.values(n)),s=e.isConfiguring?r||i:e.items;return!(null!=s&&s.filter(Bc).length)}afterRecompose(){super.afterRecompose(),this.realign()}updateTextContent(e){const t=this;if(!t.isComposable){const n=Boolean(e&&t.hasNoChildren),{classList:i}=t.contentElement;n!==i.contains("b-text-content")&&(i[n?"add":"remove"]("b-text-content"),t.rendered&&t.realign())}}updateLayoutStyle(e){Wn.applyStyle(this.contentElement,e)}updateElement(e){if(super.updateElement(...arguments),e){const{classList:e}=this.contentElement,{containerCls:t}=this.layout;e.add("b-content-element"),t&&e.add(t)}}onInternalPaint(){var e;null===(e=super.onInternalPaint)||void 0===e||e.call(this,...arguments),this.getConfig("contentElMutationObserver")}changeContentElMutationObserver(e,t){if(t&&(t.takeRecords(),t.disconnect()),e){const t=this,{element:n,contentElement:i}=t;(e=new MutationObserver((e=>t.onContentElMutation(e)))).observe(i,{attributes:!0}),i!==n&&e.observe(n,{attributes:!0}),t.syncFlexDirection()}return e}onContentElMutation(e){Vc[this.layout.type]&&this.isVisible&&e.some((e=>this.contentElement.contains(e.target)))&&this.syncFlexDirection()}changeLayout(e,t){return Ic.reconfigure(t,e,{owner:this,defaults:{owner:this}})}get childItems(){return this.items}get childItemsOrderedByRelevance(){return this.items}getWidgetById(e){return this.widgetMap[e]}processWidgetConfig(e){}setupWidgetConfig(e,t){const n=this;"string"==typeof e?e={html:e}:e.nodeType===Element.ELEMENT_NODE&&(e={element:e,id:e.id}),("string"==typeof t||!t&&(t=e.type))&&("checkbox"===t&&d.isMobile&&Tc.resolveType("slidetoggle",!0)&&(t=e.type="slidetoggle"),t=Tc.resolveType(t,!0));for(let i=(e=(t||Tc).mergeConfigs(n.defaults,e,{parent:n})).parent;i;i=i.parent)if(!1===i.processWidgetConfig(e))return null;return!1===n.trigger("beforeWidgetCreate",{widgetConfig:e})?null:e}createWidget(e){const t=Tc.create(this.setupWidgetConfig(e),this.defaultType);return t&&(t._createdBy=this),t}updateDefaults(e,t){if(!this.isConfiguring&&e){const n=Object.entries(e);this.eachWidget((e=>{n.forEach((([n,i])=>{t&&e[n]!==t[n]||(e[n]=i)}))}),!1)}}render(){this.getConfig("lazyItems"),this.layout.renderChildren(),this.syncChildCount(),super.render(...arguments)}get focusElement(){let e=this.defaultFocus&&this.query(this.defaultFocus);return this.defaultFocus&&e||(e=this.query((e=>e.isFocusable),!0)),e?e.focusElement:super.focusElement}doDestroy(){var e;null===(e=this._items)||void 0===e||e.forEach((e=>{var t;return null===(t=e.destroy)||void 0===t?void 0:t.call(e)})),this.layout.destroy(),super.doDestroy()}get isValid(){let e=!0;return this.eachWidget((t=>{"isValid"in t&&t.isVisibleForValidation&&!t.isValid&&(e=!1)}),!0),e}clearError(){this.eachWidget((e=>{var t;return null===(t=e.clearError)||void 0===t?void 0:t.call(e)}))}}Nc.initClass(),Nc._$name="Container";const{assign:Wc}=W,Uc=()=>performance.now(),Gc={start:!1},Yc=/^[.\d]+([^\d].*)?$/,qc=e=>{const t=e.$bryntum||(e.$bryntum={});return t.transitions||(t.transitions=Object.create(null))},Kc=(e,t)=>{var n;"string"==typeof e&&(t=null===(n=Yc.exec(e))||void 0===n?void 0:n[1],e=parseFloat(e));return e&&e*("s"===t||!t&&e<10?1e3:1)},Xc=e=>{const t=W.values(qc(e)).filter((e=>null==e.completed)).map((e=>e.toString()));e.style.transition=t.join(", ")},Zc=e=>class extends e{static get prototypeProperties(){return{_delay:null,_duration:null,_retain:null,_timing:null,_unit:null,owner:null,reverting:null}}constructor(...e){super(...e),this.id=++Jc}start(){this.startTime=Uc()}get delay(){var e;return Kc(this._delay??(null===(e=this.owner)||void 0===e?void 0:e.delay)??0,this.unit)}set delay(e){this._delay=e}get duration(){const{owner:e,unit:t}=this;return Kc(this._duration??(e?e.duration:ed.defaultDuration),t)}set duration(e){this._duration=e}get elapsed(){return Uc()-this.startTime}get remaining(){return this.duration-this.elapsed}get retain(){var e;return this._retain??(null===(e=this.owner)||void 0===e?void 0:e.retain)}set retain(e){this._retain=e}get timing(){var e;return this._timing??(null===(e=this.owner)||void 0===e?void 0:e.timing)}set timing(e){this._timing=e}get unit(){var e;return this._unit??(null===(e=this.owner)||void 0===e?void 0:e.unit)}set unit(e){this._unit=e}};let Jc=0;class Qc extends(Pe.mixin(Zc)){static $name="AnimatorTransition";static get prototypeProperties(){return{element:null,property:null,from:null,to:null,completed:null,promissory:null,reverting:null}}afterConstruct(){super.afterConstruct();const e=this,{element:t,transitions:n}=e;let{property:i}=e;[i,e.to]=Wn.unitize(i,e.to),e.from=Wn.unitize(i,e.from)[1],e.promissory=new il,e.property=i;const r=n[i];n[i]=e;let{from:s}=e;r&&(e.from=r.to,s=null,r.destroy()),null===s&&(s=e.getCurrentStyleValue(),r||(e.from=s)),t.style[i]=s,e.getCurrentStyleValue()}doDestroy(){const e=this;e.finish(!1),e.completed&&!e.retain&&e.clearStyle(),super.doDestroy()}get promise(){var e;return null===(e=this.promissory)||void 0===e?void 0:e.promise}get transitions(){return qc(this.element)}clearStyle(){this.setStyle("")}finish(e){const t=this,{transitions:n,promissory:i,property:r}=t;i&&(t.completed=e,t.promissory=null,i.resolve(e),n[r]===t?(delete n[r],e||(Xc(t.element),t.clearStyle())):t.completed=!1)}getCurrentStyleValue(){return Wn.getStyleValue(this.element,this.property)}revert(){const{duration:e,elapsed:t,element:n,from:i,property:r,_retain:s,_timing:o}=this;return new Qc({element:n,property:r,retain:s,timing:o,duration:Math.round(Math.min(e,t)),reverting:this,to:i,unit:"ms"})}setStyle(e){this.element.style[this.property]=e}start(){const e=this,{delay:t,duration:n,element:i,property:r}=e;Xt.onTransitionEnd({element:i,property:r,duration:t+n+20,thisObj:e.owner,handler:()=>{var t;return null===(t=e.finish)||void 0===t?void 0:t.call(e,!0)}}),super.start(),e.setStyle(e.to)}toString(){const{delay:e,duration:t,property:n,timing:i}=this;return`${n} ${t}ms ${i||"ease-in-out"}${e?` ${e}ms`:""}`}}Qc.initClass();class ed extends(Pe.mixin(Zc)){static $name="Animator";static get prototypeProperties(){return{element:null,finalize:null,prefinalize:null,completed:null,items:null}}static register(e,t){W.isObject(e)?W.entries(e).forEach((e=>ed.register(...e))):(ed.fx[e]=t,ed[e]=t=>(Wn.isElement(t)?t={element:t,[e]:{}}:delete(t={element:t.element,[e]:t})[e].element,ed.run(t)))}static run(e){return new ed(e).start()}constructor(e){var t;super(null);const n=this,i=[],r={};let s,o,a,l;if(Array.isArray(e))n.items=e;else for(a in e)(ed.specialPropsRe.test(a)?n:r)[a]=e[a];W.keys(r).forEach((e=>{l=r[e],null!=l&&!1!==l&&l==l&&((o=ed.fx[e])?(l=Wc(n.defaults,o(l,n,e)),l.owner=n,s=new ed(l)):(l=Wc(n.defaults,"object"==typeof l?l:{to:l}),l.owner=n,l.property=e,s=new Qc(l)),i.push(s))})),null===(t=n.items)||void 0===t||t.forEach((e=>{W.isInstantiated(e)?e.owner=n:((e=Wc(n.defaults,e)).owner=n,e=new ed(e)),i.push(e)})),n.items=i,n.promise=(1===i.length?i[0].promise:Promise.all(i.map((e=>e.promise)))).then((e=>{var t;return null===(t=n.finish)||void 0===t||t.call(n,e),n.completed||!1}))}doDestroy(){this.items.forEach((e=>e.destroy())),super.doDestroy()}get defaults(){return{element:this.element}}get retain(){const{_retain:e,finalize:t,owner:n}=this;return e??(!t&&(!n||n.retain))}set retain(e){super.retain=e}done(){return this.promise}finish(e){var t,n;const i=this,{items:r}=i;for(Xc(i.element),i.completed="boolean"==typeof e?e:!e.some((e=>!e)),null===(t=i.prefinalize)||void 0===t||t.call(i,i.completed,i);r.length;)r.pop().destroy();null===(n=i.finalize)||void 0===n||n.call(i,i.completed,i)}revert(e){const t=this,{reverting:n}=t,i=!e||(e.start??!0);let r=t.defaults;return n&&(n.finalize&&(r.finalize=n.finalize),n.prefinalize&&(r.prefinalize=n.prefinalize),r.retain=n._retain),r=Wc(r,e,{items:t.items.map((e=>e.revert(Gc))),reverting:t}),r=new ed(r),i&&r.start(),r}start(){const{element:e,items:t}=this;return super.start(),t.length&&(Xc(e),t.forEach((e=>e.start()))),this}}ed.initClass().Transition=Qc,ed.specialPropsRe=new RegExp(`^(?:${Object.keys(ed.prototypeProperties).concat(Object.keys(ed.superclass.prototypeProperties)).map((e=>"_"===e[0]?e.substr(1):e)).join("|")})$`),ed.defaultDuration=200,ed.fx={},ed.register({puff:e=>(!0===e?e={}:"object"!=typeof e?e={transform:`scale(${e})`}:e.scale&&((e=W.clone(e)).transform=`scale(${e.scale})`,delete e.scale),Wc({opacity:0,transform:"scale(8)"},e))}),ed._$name="Animator";class td extends(Pe.mixin(Ir)){static get configurable(){return{element:null,delegate:null,delay:500,startRate:2,endRate:20,accelerateDuration:4e3,pressedCls:"b-pressed"}}doDestroy(){var e;null===(e=this.mousedownRemover)||void 0===e||e.call(this),this.cancel(),super.doDestroy()}cancel(){var e,t,n;const i=this;null===(e=i.activeElement)||void 0===e||e.classList.remove(i.pressedCls),i.activeElement=null,null===(t=i.acceleration)||void 0===t||t.cancel(),i.activeListenerRemover=null===(n=i.activeListenerRemover)||void 0===n?void 0:n.call(i),i.clearTimeout(i.autoRepeatTimer),i.clearTimeout(i.repeatTimer)}updateElement(e){var t;null===(t=this.mousedownRemover)||void 0===t||t.call(this),this.mousedownRemover=Xt.on({element:e,mousedown:"onMouseDown",thisObj:this})}onMouseDown(e){const t=this,n=t.delegate?e.target.closest(t.delegate):t.element;t.cancel(),n&&(t.activeElement=n,t.triggerEvent=e,n.classList.add(t.pressedCls),t.activeListenerRemover=Xt.on({mouseup:{element:document,capture:!0,handler:"onMouseUp"},mousemove:{element:n,handler:"onTargetMouseMove"},mouseleave:{element:n,handler:"onTargetMouseLeave"},mouseenter:{element:n,handler:"onTargetMouseEnter"},thisObj:t}),t.autoRepeatTimer=t.setTimeout("startAutoRepeat",t.delay))}onMouseUp(){this.cancel()}onTargetMouseLeave(){this.activeElement.classList.remove(this.pressedCls),this.clearTimeout(this.repeatTimer)}onTargetMouseEnter(e){const t=this;e.buttons?(t.activeElement.classList.add(t.pressedCls),t.triggerEvent=e,t.fireClick()):t.cancel()}onTargetMouseMove(e){this.triggerEvent=e}startAutoRepeat(){const e=this;e.interval=e.startInterval=1e3/e.startRate,e.accelerationDelta=e.startInterval-1e3/e.endRate,e.fireClick(),e.acceleration=Ne.animate(e.accelerateDuration,e.nextTick,e,"easeOutQuad")}nextTick(e){this.interval=this.startInterval-this.accelerationDelta*e}fireClick(){const e=this,t=new MouseEvent("click",e.triggerEvent);e.triggerEvent.target.dispatchEvent(t),e.repeatTimer=e.setTimeout(e.fireClick,e.interval)}}td._$name="ClickRepeater";const nd=/^(?:undefined|null|LEFT|RIGHT)$/,id={TOP:"BOTTOM",RIGHT:"LEFT",BOTTOM:"TOP",LEFT:"RIGHT"},rd=e=>{const t=null==e?void 0:e.toUpperCase();return[t,"LEFT"===t||"RIGHT"===t]};var sd=e=>class extends(e||Pe){static $name="Rotatable";static get configurable(){return{rotate:null,invertRotate:null}}compose(){const{rotate:e}=this;return{class:{[`b-rotate-${(e||"").toLowerCase()}`]:e,"b-rotate-vertical":e}}}syncRotationToDock(e){if(nd.test(String(this.rotate))){const[t,n]=rd(e);this.rotate=n?this.invertRotate?id[t]:t:null}}get widgetClass(){return null}};class od extends(Tc.mixin(sd)){static $name="Tool";static type="tool";static configurable={align:{value:null,$config:{merge:"replace"}},href:null,repeat:null,defaultBindProperty:null};compose(){const{align:e,href:t}=this;return{tag:null!=t?"a":"button",class:{[`b-align-${e||"end"}`]:1,"b-icon":1},listeners:{click:"onInternalClick"}}}get focusElement(){return this.element}get panel(){var e,t;if(null!==(e=this.parent)&&void 0!==e&&e.isPanel&&null!==(t=this.element)&&void 0!==t&&t.parentNode.matches(".b-panel-header"))return this.parent}changeAlign(e){return e}onInternalClick(e){const t=this,{handler:n,panel:i}=t,r={domEvent:e,tool:t};t.disabled||(t.trigger("click",r),t.isDestroyed||(t.trigger("action",r),t.isDestroyed||!1===(null==i?void 0:i.trigger("toolClick",r))||n&&t.callback(n,i,[e,i,t])))}onInternalKeyDown(e){"Enter"===(e.key.trim()||e.code)&&e.stopPropagation()}updateDisabled(e,t){var n;super.updateDisabled(e,t),e&&(null===(n=this.repeat)||void 0===n||n.cancel())}changeRepeat(e,t){return null==t||t.destroy(),e&&td.new({element:this.element},e)}}od.initClass(),od._$name="Tool";const ad=/right/i,ld=e=>(e.collapsed||e.collapsing)&&"top"===e.owner.expandedHeaderDock&&e.owner.collapsible.direction.match(ad)?"start":"end";class cd extends od{static $name="CollapseTool";static type="collapsetool";static get configurable(){return{autoAlign:!0,collapsed:null,collapsing:null,collapsify:!1,direction:"up",defaultBindProperty:null}}compose(){const{collapsed:e,direction:t}=this;return{class:{[`b-icon-collapse-${t}`]:1,"b-collapsed":e}}}changeAutoAlign(e){return!0===e?ld:e}syncAutoAlign(){const{autoAlign:e}=this;e&&(this.align=e(this))}updateAutoAlign(){this.syncAutoAlign()}updateCollapsed(){this.syncAutoAlign()}updateCollapsing(){this.syncAutoAlign()}updateDirection(){this.syncAutoAlign()}}cd.initClass(),cd._$name="CollapseTool";const dd=/^(?:UP|DOWN|LEFT|RIGHT)$/,ud=/^(left|top)$/i,hd={},gd=/^b-dock-(top|left|right|bottom)$/,md="b-panel-collapse-revealer",pd=/^(?:left|right)$/i,fd="b-collapse-unflex",{round:vd}=Math,yd=["up","down","left","right"].reduce(((e,t)=>(e[t.toUpperCase()]=e[t]=t,e)),{}),bd={top:["top","bottom"],right:["right","left"],bottom:["bottom","top"],left:["left","right"]},Cd={hl:"LEFT",hr:"RIGHT",vb:"DOWN",vt:"UP"},Sd={h:"w",w:"h"},Dd={up:"top",right:"right",down:"bottom",left:"left"},wd={top:!1,right:!0,bottom:!1,left:!0},Ed={top:"UP",right:"RIGHT",bottom:"DOWN",left:"LEFT"},Rd={top:e=>`translate(0, -${vd(e.height||0)}px)`,bottom:e=>`translate(0, ${vd(e.height||0)}px)`,right:e=>`translate(${vd(e.width||0)}px, 0)`,left:e=>`translate(-${vd(e.width||0)}px, 0)`};let xd=0;class Td extends(Pe.mixin(es)){static $name="PanelCollapser";static type="inline";static get configurable(){return{animation:{duration:200},collapsed:{value:null,$config:null,default:!1},direction:null,collapseTooltip:"L{Collapse}",expandTooltip:"L{Expand}",panel:{value:null,$config:"nullify"},supportAxis:null,tool:{type:"collapsetool",handler(e){var t;null===(t=this.collapsible)||void 0===t||t.onCollapseClick(e)}}}}static get factoryable(){return{defaultType:"inline"}}get collapsing(){return"collapsing"===this.collapsingExpanding}get collapsingExpanding(){var e;const t=null===(e=this.currentOperation)||void 0===e?void 0:e.collapsing;return null==t?null:t?"collapsing":"expanding"}get currentDock(){var e;return(null===(e=this.panel)||void 0===e||null===(e=e.header)||void 0===e||null===(e=e.dock)||void 0===e?void 0:e.toLowerCase())??"top"}get expanding(){return"expanding"===this.collapsingExpanding}get collapseTool(){var e;return null===(e=this.panel)||void 0===e||null===(e=e.tools)||void 0===e?void 0:e.collapse}get collapseDim(){return pd.test(this.collapseDir)?"width":"height"}getCollapseDir(e){let{direction:t,panel:n}=this;if(!t||dd.test(t)){const e=null==n?void 0:n.placement;var i;if(e)t=Cd[e];else t=Ed[(null==n||null===(i=n.header)||void 0===i?void 0:i.dock)||"top"]}return e?yd[t]:t}get collapseDir(){return this.getCollapseDir(!0)}get collapseDock(){return this.collapseInfo[0]}get collapseInfo(){const{panel:e}=this,t=e.hasHeader&&e.expandedHeaderDock;let n=Dd[this.collapseDir],i=!1;return t&&((i=wd[n]!==wd[t])||(n=t)),[n,i]}get toolsConfig(){const{direction:e,tool:t}=this;return t&&{collapse:W.assign({direction:e.toLowerCase()},t)}}beforeCollapse(e){const{panel:t}=this,{element:n}=t;n.contains(Wn.getActiveElement(n))&&t.revertFocus(!0)}changeTool(e){const t=this,{panel:n}=t;if(t.isConfiguring||t.isDestroying||!n||n.isDestroying)return e;n.tools={collapse:e}}collapse(e){var t;const n=this,{panel:i}=n,r={id:++xd,completed:!1,panel:i};let{currentOperation:s}=n;return e=e??!0,W.isObject(e)&&(r.collapsed=!0,W.assign(r,e),e=r.collapsed,delete r.collapsed),r.collapsing=e,r.previous=s??null,e!==n.collapsed?s?s.collapsing!==e&&(r.animation=s.animation.revert({finalize(){var e;null===(e=n.collapseFinalize)||void 0===e||e.call(n,r,!0)}}),r.collapsing=e,s=r):(r.animation=W.clone(("animation"in r?r:n).animation),!1!==n.beforeCollapse(r)&&(r.animation&&(r.animation.finalize=e=>{var t;return null===(t=n.collapseFinalize)||void 0===t?void 0:t.call(n,r,e)}),i.changingCollapse=!0,n[e?"collapseBegin":"expandBegin"](r),r.animation?s=r:(r.completed=!0,n[e?"collapseEnd":"expandEnd"](r)),i.changingCollapse=!1,r.animation||n.onComplete(e?"collapse":"expand"))):s&&s.collapsing!==e&&(n[e?"expandRevert":"collapseRevert"](r),r.animation=s.animation.revert({finalize(){var e;null===(e=n.collapseFinalize)||void 0===e||e.call(n,r,!1)}}),s=r),n.currentOperation=s,(null===(t=s)||void 0===t||null===(t=t.animation)||void 0===t?void 0:t.done())??Promise.resolve(e===n.collapsed)}collapseFinalize(e,t){const n=this,{currentOperation:i,panel:r}=n,s=r.collapsed?"expand":"collapse";i===e&&(n.currentOperation=null,e.completed=t,r.changingCollapse=!0,n[s+"End"](e),r.changingCollapse=!1,t&&n.onComplete(s))}applyHeaderDock(e,t=!0){const{currentDock:n,panel:i}=this,{header:r}=i,s=e?this.collapseDock:i.expandedHeaderDock;s!==n&&i.hasHeader&&(i.header=r?"string"==typeof r?{title:r}:W.clone(i.header):{},i.header.dock=s,t&&i.recompose.flush())}composeHeader(e){const{panel:t}=this,{class:n}=e,i=t.expandedHeaderDock||Object.keys(n).filter((e=>n[e]&&gd.test(e))).map((e=>gd.exec(e)[1][0]));return n[md]=1,n[`b-collapsible-${i[0]}${this.collapseDir[0]}`]=1,e}composeTitle(e){return e.class[md]=1,e}collapseBegin(e){var t;const n=this,{animation:i}=e,{collapseDim:r,collapseTool:s,panel:o}=n,{element:a,placement:l}=o,[c,d]=n.collapseInfo,u=null==s?void 0:s.element.classList,h=!l||"h"===l[0]&&"width"===r||"v"===l[0]&&"height"===r;n.configuredWidth=o._lastWidth,n.configuredHeight=o._lastHeight,n.transverseCollapse=d,n.applyHeaderDock(!0);const g=o.rectangle(),m=n.lockInnerSize().moveTo(0,0),p=m.clone(),f=bd[c],v=null===(t=o.headerElement)||void 0===t?void 0:t.getBoundingClientRect(),y=vd((null==v?void 0:v[r])||0);a.classList.toggle(fd,h),i?(p[f[0]]=p[f[1]],a.classList.add("b-collapsing"),null==u||u.add("b-collapsed","b-collapsing"),s&&(s.collapsing=!0),u&&(u.remove("b-collapsed"),o.rectangle(),u.remove("b-collapsing"),u.add("b-collapsed")),i.element=a,i.retain=!0,i[r]={from:vd(g[r]),to:y},i.items=[{element:n.innerElement,retain:!1,clip:{from:`rect(${m})`,to:`rect(${p})`}}],d&&i.items.push({element:o.headerElement,duration:i.duration,retain:!1,transform:{from:Rd[c](v),to:"translate(0, 0)"}}),e.animation=ed.run(i)):(a.style[r]=`${y}px`,s&&(u.add("b-collapsing","b-collapsed"),s.rectangle(),u.remove("b-collapsing")))}collapseEnd(e){const t=this,{collapseTool:n}=t;t.panel.element.classList.remove("b-collapsing"),n&&(n.collapsing=!1),e.completed?t.collapsed=!0:(t.applyHeaderDock(!1),t.restoreConfiguredSize(),t.lockInnerSize(!1))}collapseRevert(e){var t;null===(t=this.collapseTool)||void 0===t||t.element.classList.remove("b-collapsed")}expandBegin(e){const t=this,{animation:n}=e,{collapseDim:i,collapseTool:r,panel:s}=t,[o,a]=t.collapseInfo,{element:l}=s,c=l.classList,d=c.contains(fd),u=s.rectangle();c.remove("b-collapsed","b-collapsing"),s.element.style[i]="",t.restoreConfiguredSize(),t.lockInnerSize(!1);const h=s.rectangle(),g=t.lockInnerSize().moveTo(0,0),m=g.clone(),p=bd[t.collapseDock];null==r||r.element.classList.remove("b-collapsed"),n&&(m[p[0]]=m[p[1]],c.add("b-collapsed","b-expanding"),d&&c.add(fd),n.element=l,n[i]={from:vd(u[i]),to:vd(h[i])},n.items=[{element:t.innerElement,retain:!1,clip:{from:`rect(${m})`,to:`rect(${g})`}}],a&&n.items.push({element:s.headerElement,duration:n.duration,retain:!1,transform:{from:"translate(0, 0)",to:Rd[o](u)}}),e.animation=ed.run(n))}expandEnd(e){const t=this;t.panel.element.classList.remove("b-expanding"),e.completed&&(t.collapsed=!1,t.applyHeaderDock(!1),t.restoreConfiguredSize(),t.lockInnerSize(!1))}expandRevert(e){var t;null===(t=this.collapseTool)||void 0===t||t.element.classList.add("b-collapsed")}get innerElement(){return this.panel.collapseWrapElement||this.panel.bodyWrapElement}get innerSizeElement(){return this.transverseCollapse?this.panel.element:this.innerElement}get supportAxis(){let{_supportAxis:e}=this;const t=!0===e;return(t||null==e)&&(e=this.collapseDim[0],(t||"absolute"===Wn.getStyleValue(this.panel.element,"position"))&&(e+=Sd[e])),e||""}lockInnerSize(e=!0){const t=this,{innerElement:n,panel:i}=t,r=e?t.supportAxis:"",s=i.element,o=i.headerElement,a=e&&o&&Pt.from(o,s),l=e&&Pt.from(t.innerSizeElement,s),c=n.style;return o&&(o.style.minWidth=r.includes("w")?`${a.width}px`:"",o.style.minHeight=r.includes("h")?`${a.height}px`:""),c.width=e?`${l.width}px`:"",c.height=e?`${l.height}px`:"",n.classList[e?"add":"remove"]("b-panel-collapse-size-locker"),l}onCollapseClick(e){let t=!this.collapsing&&(!!this.expanding||!this.collapsed);e.altKey&&(t={animation:null,collapsed:t}),this.collapse(t)}onComplete(e){var t;null===(t=this.panel)||void 0===t||t.trigger(e)}onPanelHeaderClick({event:e}){0===e.button&&this.panel.collapsed&&e.target.classList.contains(md)&&this.onRevealerClick()}onPanelConfigChange({name:e,value:t}){const n=this,{panel:i}=n;"collapsed"===e?i.isPainted&&(n.collapsed=t):"header"!==e||i.changingCollapse||n.syncDirection()}onPanelPaint(){this.syncDirection(),this.panel.collapsed&&!this.collapsed&&this.collapse({animation:null,collapsed:!0})}onRevealerClick(){this.panel._collapse({collapsed:!1})}restoreConfiguredSize(e){const{configuredHeight:t,configuredWidth:n,panel:i}=this;e=e??"wh",i.element.classList.remove(fd),null!=n&&e.includes("w")&&(i.width=n),null!=t&&e.includes("h")&&(i.height=t)}splitHeaderItems({as:e,dock:t}=hd){var n;return null===(n=this.panel)||void 0===n?void 0:n.splitHeaderItems({as:e,dock:t,alt:!0})}syncDirection(){const e=this,{direction:t}=e;t&&!dd.test(t)||(e.direction=e.getCollapseDir())}changeCollapsed(e){return Boolean(e)}updateCollapsed(e){const{collapseTool:t,panel:n}=this;n&&(n.collapsed=e,n.element.classList[e?"add":"remove"]("b-collapsed")),t&&(t.collapsed=e)}updateDirection(e){const{collapseTool:t,panel:n}=this;t&&(t.direction=yd[e]),null!=n&&n.rendered&&n.recompose()}updatePanel(e){var t;const n=this;n.syncDirection(),null===(t=n.panelChangeDetacher)||void 0===t||t.call(n),n.panelChangeDetacher=e&&Ne.after(e,"onConfigChange","onPanelConfigChange",n,{return:!1})}wrapCollapser(e,t){var n;const i=this,[r,s]=i.collapseInfo;if(!s)return[e,t];const{collapseDir:o,panel:a}=i,{expandedHeaderDock:l,header:c,uiClassList:d}=a,u=null===(n=a.tools)||void 0===n?void 0:n.recollapse,[h,g]=i.splitHeaderItems({as:"element",dock:r}),m=a.hasHeader?a.title||(null==c?void 0:c.title)||" ":null,p=m&&{tag:"header",class:new _t({...d,[`b-dock-${l}`]:1,"b-panel-header":1,"b-panel-collapser-header":1},null==c?void 0:c.cls),children:[...h,{reference:"collapserTitleElement",html:m,class:{...d,[`b-align-${(null==c?void 0:c.titleAlign)||"start"}`]:1,"b-header-title":1}},...g]};return u&&(u.direction=o),["collapseWrapElement",{class:{...d,[`b-panel-collapser-header-${l}`]:1,[`b-panel-collapser-${o}`]:1,[`b-${wd[l]?"h":"v"}box`]:1,"b-panel-collapser":1,"b-box-center":1},children:ud.test(l)?{collapserHeaderElement:p,[e]:t}:{[e]:t,collapserHeaderElement:p}}]}}Td.maps={clipByDock:bd,dockByDirection:Dd,dockIsHorz:wd},Td.initClass(),Td._$name="PanelCollapser";const Md=Symbol("pendingCreate");class Id extends Pe{static get prototypeProperties(){return{cleanup:null,configName:null,created:null,factory:null,inferType:"name",owner:null,ownerName:null,proxyable:"undefined"!=typeof Proxy,setup:null,transform:null}}static get properties(){return{defaults:{},instances:{},object:Object.create({})}}get proxy(){const e=this;let t=null;return e.proxyable&&(t=new Proxy(e.instances,{get:(t,n)=>e.get(n),set:(t,n,i)=>(e.set(n,i),!0),deleteProperty:(t,n)=>(e.set(n,null),!0)})),Reflect.defineProperty(e,"proxy",{configurable:!0,value:t}),t}get target(){return this.proxy||this.object}define(e,t){const n=this,{transform:i}=n,r=i?i(t,e):t,s=W.isInstantiated(r);n.instances[e]=Md,s||n.setDefaults(e,r),n.defineProp(e,!0),s&&n.set(e,r)}defineProp(e,t){const n=this,{object:i}=n;n.proxy||Reflect.defineProperty(t?Object.getPrototypeOf(i):i,e,{configurable:!t,enumerable:!0,get:()=>n.get(e),set:t=>n.set(e,t)})}flush(){const e=this;try{var t;e.updating=!0;for(const t in e.defaults)e.get(t);e.afterConfigureOwner=null===(t=e.afterConfigureOwner)||void 0===t?void 0:t.call(e)}finally{e.updating=!1}}get(e){const{defaults:t,instances:n}=this;return n[e]===Md&&this.set(e,Md),n[e]||t[e]&&null}set(e,t){const n=this,{cleanup:i,configName:r,defaults:s,factory:o,instances:a,owner:l,setup:c,transform:d,updating:u}=n,h=l&&r&&!u,g=a[e]===Md?null:a[e],m=o.reconfigure(g,t===Md?{}:t||null,{cleanup:i&&(t=>i(t,e)),defaults:s[e]||n.setDefaults(e,{}),owner:n.owner,setup:c&&((t,n,i)=>c(t,e,n,i)),transform:d&&(t=>d(t,e))});if(m!==g){const t=h&&{...a};var p;if(a[e]=m,m)n.defineProp(e),null===(p=n.created)||void 0===p||p.call(n,m,e);else delete n.object[e],delete a[e];h&&l.onConfigChange({name:r,config:l.$meta.configs[r],value:n.target,was:t})}}setDefaults(e,t){const{defaults:n,factory:i,inferType:r,instances:s,owner:o,ownerName:a}=this,{typeKey:l}=i.factoryable;return t=!0===t?{}:W.assign({},t),("name"===r||!0===r&&!t[l])&&(t[l]=e),a&&(t[a]=o),t.beforeConfigure=t=>{s[e]=t},n[e]=t}update(e){const t=this,{owner:n}=t;let i,r;try{if(t.updating=!0,e)for(i in e)r=e[i],t.defaults[i]?t.set(i,r):r&&t.define(i,r);else for(i in t.instances)t.set(i,null)}finally{t.updating=!1}n&&(n.isConfiguring?t.afterConfigureOwner||(t.afterConfigureOwner=Ne.before(n,"afterConfigure","flush",t)):t.flush())}}Id.initClass(),Id._$name="DynamicObject";const Ad=[],kd={},Fd={align:1,weight:1};var Pd=e=>class extends(e||Tc){static $name="Toolable";static get configurable(){return{tools:{value:null,$config:{nullify:!0}},toolDefaults:{"*":{type:"tool",align:"end"}}}}byWeightSortFn(e,t){return(e.weight||0)-(t.weight||0)}byWeightReverseSortFn(e,t){return(t.weight||0)-(e.weight||0)}gatherTools({align:e,alt:t,refs:n}=kd){const{collapsed:i,tools:r}=this,s={collapsed:i,alt:t};let o,a,l,c,d,u=[];for(a in r){var h,g;d=r[a],o=(null===(h=d)||void 0===h||null===(h=h.align)||void 0===h?void 0:h.align)??(null===(g=d)||void 0===g?void 0:g.align)??"end",o===e&&d.isCollapsified(s)&&u.push(d)}if(u.sort(this["end"===e?"byWeightReverseSortFn":"byWeightSortFn"]),n){const e="widget"===n,t={};for(l=0;l<u.length;++l)c=u[l],t[c.ref]=e?c:c.element;u=t}return u}getEndTools({alt:e,refs:t}=kd){return this.gatherTools({align:"end",alt:e,refs:t})}getStartTools({alt:e,refs:t}=kd){return this.gatherTools({align:"start",alt:e,refs:t})}get childItems(){return[...this.getStartTools(),...this._items||Ad,...this.getEndTools()]}changeTools(e,t){const n=this,i=n.$tools||(n.$tools=new Id({configName:"tools",factory:Tc,inferType:!1,owner:n,created(e){var t,r;e.innerItem=!1,null===(t=e.syncRotationToDock)||void 0===t||t.call(e,null===(r=n.header)||void 0===r?void 0:r.dock),Ne.after(e,"onConfigChange",((e,{name:t})=>{Fd[t]&&n.onConfigChange({name:"tools",value:i.target})})),n.onChildAdd(e)},setup:(e,t)=>((e=W.merge({},n.toolDefaults["*"],n.toolDefaults[t],e)).parent=n,e.ref=t,e)}));if(i.update(e),!t)return i.target}get widgetClass(){}};const Od=["b-hbox","b-vbox"],Ld={name:"align",style:"alignItems"},$d={name:"contentAlign",style:"alignContent"},_d={name:"direction",style:"flexDirection"},jd={name:"justify",style:"justifyContent",classes:["stretch"]},Bd={name:"wrap",style:"flexWrap",map:{false:"nowrap",true:"wrap",reverse:"wrap-reverse"}};class Hd extends Ic{static $name="Box";static type="box";static alias="hbox";static configurable={containerCls:"b-box-container",itemCls:"b-box-item",align:null,contentAlign:null,direction:null,horizontal:!0,justify:null,reverse:null,wrap:null};get vertical(){return!1===this.horizontal}set vertical(e){return this.horizontal=!e}updateAlign(){this.syncConfigStyle(Ld)}updateContentAlign(){this.syncConfigStyle($d)}updateDirection(){this.syncConfigStyle(_d)}updateHorizontal(){var e;const t=this,n=null===(e=t.contentElement)||void 0===e?void 0:e.classList,i=Number(t.vertical);n?(n.remove(Od[1-i]),n.add(Od[i])):t.syncConfigLater("horizontal"),t.syncDirection()}updateJustify(){this.syncConfigStyle(jd)}updateReverse(){this.syncDirection()}updateWrap(){this.syncConfigStyle(Bd)}syncDirection(){const e=this,{reverse:t}=e;e.direction=t?`${e.vertical?"column":"row"}${t?"-reverse":""}`:null}}Hd.initClass(),Hd._$name="Box";class Vd extends Hd{static $name="VBox";static type="vbox";static configurable={horizontal:!1}}Vd.initClass(),Vd._$name="VBox";var zd=e=>class extends(e||Pe){static $name="Badge";static get configurable(){return{badge:null}}compose(){const{badge:e}=this;return{dataset:{badge:e},class:{"b-badge":null!=e&&""!==e}}}};const Nd=/(?:^|\s)b-icon-/,Wd=/(?:^|\s)b-fa-/,Ud=["items","type","widgets","html","listeners"],Gd=Symbol("defaultListener");class Yd extends(Tc.mixin(zd,sd)){static $name="Button";static type="button";static get configurable(){return{icon:null,menuIcon:"b-icon-picker",pressedIcon:null,pressedCls:null,iconAlign:"start",behaviorType:"button",text:{value:null,$config:null,default:""},color:null,toggleable:void 0,pressed:!1,toggleGroup:null,supportsPressedClick:!1,supportsUnpressing:!1,ripple:{radius:75},twinForwardEvents:{item:"action"},twinSyncConfigs:null,localizableProperties:["text"],menu:{$config:["lazy","nullify"],value:null},menuDefaults:{type:"menu",autoShow:!1,autoClose:!0,floating:!0,scrollAction:"realign",align:"t0-b0"},href:null,target:null,tabIndex:null,defaultBindProperty:null}}construct(...e){super.construct(...e),this.ion({hide:"onInternalHide"})}get twinSyncConfigs(){if(this.toggleable)return{pressed:"checked"}}updateElement(e,t){var n,i;const r=this,{constructor:s}=r,o=super.updateElement(e,t),a=r.peekConfig("menu"),l=!!a&&(a.isWidget?a.role:(null===(n=s.resolveType(a.type))||void 0===n||null===(n=n.configurable)||void 0===n?void 0:n.role)||(null===(i=s.configurable.menuDefaults)||void 0===i?void 0:i.type)||"menu");return r.ariaHasPopup=l,o}compose(){const{color:e,href:t,icon:n,iconAlign:i,pressed:r,pressedIcon:s,target:o,text:a,toggleable:l,toggleGroup:c,menuIcon:d,behaviorType:u,tabIndex:h,pressedCls:g}=this,m=this.hasConfig("menu"),p=r&&s?s:n;return{tag:t?"a":"button",href:t,target:o,tabIndex:h,type:u,class:{[`b-icon-align-${i}`]:n,[e]:Boolean(e),"b-pressed":r&&l,"b-text":Boolean(a),"b-has-menu":m,...r&&g?Object.fromEntries(g.split(" ").map((e=>[e,1]))):{}},[l&&!m?"aria-pressed":""]:r,dataset:{group:c},listeners:{click:"onInternalClick",mousedown:"onInternalMousedown"},children:{iconElement:(n||s)&&{"aria-hidden":!0,tag:"i",class:{..._t.normalize(p,"object"),"b-button-icon":1,"b-icon":Nd.test(p),"b-fa":Wd.test(p)}},label:a&&{tag:"label",for:this.id,text:a},menuIconElement:m&&d&&{tag:"i",class:{"b-icon":Nd.test(d),"b-fa":Wd.test(d),"b-button-menu-icon":1,[d]:1}}}}}onInternalHide(){var e;null===(e=this._menu)||void 0===e||e.hide()}get childItems(){return this._menu&&[this.menu]}onFocusOut(e){var t;super.onFocusOut(e),null===(t=this.menu)||void 0===t||t.hide()}get focusElement(){return this.element}changeText(e){return null==e?"":e}changeToggleable(e){return void 0===e&&(e=Boolean(this.toggleGroup||this.config.menu)),e}changeMenu(e,t){const n=this,{element:i}=n;return e?(e.isWidget?(e.forElement=i,e.owner=n,e.constrainTo=n.rootElement):("object"!=typeof e||Ud.some((t=>t in e))||(e={lazyItems:e}),e=Tc.reconfigure(t,e?W.merge({owner:n,constrainTo:n.rootElement,forElement:i},n.menuDefaults,e):null,n)),e.align.constrainPadding=10,n.detachListeners(Gd),e.ion({name:Gd,beforeShow:"onMenuBeforeShow",hide:"onMenuHide",show:"onMenuShow",thisObj:this})):null==t||t.destroy(),e}onMenuBeforeShow({source:e}){return this.trigger("beforeShowMenu",{menu:e})}onMenuShow(){this.ariaElement.setAttribute("aria-expanded",!0)}onMenuHide(){this.ariaElement.setAttribute("aria-expanded",!1),this.toggle(!1)}updateMenu(e){this.toggleable=Boolean(e)}updatePressed(e){const t=this;if(!t.toggleable||t.isConfiguring)return;const{menu:n}=t;e&&Wn.forEachSelector(t.rootElement,`button[data-group=${t.toggleGroup}]`,(e=>{e!==t.element&&(Tc.getById(e.id).pressed=!1)})),n&&(n.owner=t,n.forElement=t.element,n.initialConfig.minWidth||(n.minWidth=t.width),n.align.minHeight=n._minHeight??100,n.align.minWidth=n._minWidth??100,n[e?"show":"hide"]()),t.trigger("toggle",{pressed:e,userAction:t._isUserAction})}configureOverflowTwin(e){const t=this,n=super.configureOverflowTwin(e),{menu:i}=t;return n.type=Tc.resolveType("menuitem"),i?n.menu=t.constructor.mergeConfigs(n.menu,{type:"menu",items:i.items.map((e=>e.ensureOverflowTwin()))}):t.toggleable&&(n.checked=t.pressed),n.text||(n.text=t.text||t.tooltipText),n}onInternalMousedown(e){var t;null!==(t=this._menu)&&void 0!==t&&t.containsFocus&&this.pressed&&e.preventDefault()}changeTooltip(e,t){const n=this,i=(null==e?void 0:e.html)||e;return n.ariaLabel||n.text||"string"!=typeof i||(n.ariaLabel=n.optionalL(i,n)),super.changeTooltip(e,t)}onInternalClick(e){const t=this,n={event:e};if(!t.disabled){if(t._isUserAction=!0,t.toggleable){const e=t.toggleGroup&&t.pressed&&!t.supportsUnpressing;if(e&&!t.supportsPressedClick)return;if(e||t.toggle(!t.pressed),t.isDestroyed)return}t.trigger("click",n),t.isDestroyed||t.trigger("action",n),t.href||(e.preventDefault(),e.stopPropagation()),t._isUserAction=!1}}toggle(e=!this.pressed){!1!==this.trigger("beforeToggle",{pressed:e,userAction:this._isUserAction})&&(this.pressed=e)}}Yd.initClass(),Yd._$name="Button";const qd={refs:"element"},Kd=e=>e.element.style.margin="",Xd=e=>e.isToolbar,Zd=e=>e[0]+(e[1].minifiable?0:9e9),Jd={hidden:!1,width:""},Qd={...Jd,flex:""},eu={flex:1,hidden:1,maxWidth:1,minWidth:1,width:1,disabled:1},tu=[{box:"hbox",clientSizeProp:"clientWidth",edgeProp:"right",flexDir:"row",horizontal:!0,max:"maxX",overflow:"overflowX",pos:"x",scrollSize:"scrollWidth",sizeProp:"width"},{box:"vbox",clientSizeProp:"clientHeight",edgeProp:"bottom",flexDir:"column",horizontal:!1,max:"maxY",overflow:"overflowY",pos:"y",scrollSize:"scrollHeight",sizeProp:"height"}],nu={delay:0,startRate:40,endRate:200,accelerateDuration:500},iu={menu:1,pressed:1};class ru extends(Nc.mixin(Pd)){static $name="Toolbar";static type="toolbar";static delayable={syncOverflowVisibility:{type:"raf",cancelOutstanding:!0}};static configurable={defaultType:"button",dock:"top",layout:{type:"box"},overflow:{$config:["lazy","nullify"],value:{type:"menu"}},toolDefaults:{overflowMenuButton:{type:"button",hidden:!0,icon:"b-icon-menu",menuIcon:null,ariaLabel:"Show overflowing items",defaultCls:{"b-overflow-button":1}},overflowScrollEnd:{handler:"up.onEndScrollClick",hidden:!0,defaultCls:{"b-icon-angle-right":1,"b-overflow-button":1,"b-icon":1}},overflowScrollStart:{align:"start",handler:"up.onStartScrollClick",hidden:!0,defaultCls:{"b-icon-angle-left":1,"b-overflow-button":1,"b-icon":1}}},widgetCls:null,ignoreParentReadOnly:!0};static prototypeProperties={flexRowCls:"b-hbox",flexColCls:"b-vbox"};static getEvictionList(e){const t=e.filter((e=>"none"!==e.overflowable));return t.forEach(((e,n)=>t[n]=[n,e])),t.sort(((e,t)=>Zd(t)-Zd(e))),t}compose(){const e=this,{axisProps:t,dock:n}=e,i=e.getEndTools(qd),r=e.getStartTools(qd);return{class:{[`b-dock-${n}`]:1,[`b-${n}-toolbar`]:1,[`b-${t.box}`]:1},children:{...r,toolbarContent:{class:{"b-box-center":1,"b-toolbar-content":1}},...i}}}get axisProps(){return tu[this.layout.horizontal?0:1]}get contentElement(){return this.toolbarContent}get overflowMenuButton(){var e;return null===(e=this.tools)||void 0===e?void 0:e.overflowMenuButton}get overflowType(){const{overflow:e}=this;return"string"==typeof e?e:null==e?void 0:e.type}onChildAdd(e){var t;super.onChildAdd(e),this.processAddedLeafItem(e),null===(t=e.syncRotationToDock)||void 0===t||t.call(e,this.dock)}onChildRemove(e){super.onChildRemove(e),this.syncOverflowVisibility()}processAddedLeafItem(e){Ne.after(e,"onConfigChange",this.onLeafItemConfigChange,e),e.isContainer&&e.eachWidget((e=>this.processAddedLeafItem(e)))}onInternalPaint({firstPaint:e}){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...arguments),e&&this.getConfig("overflow")}updateDock(e){const t=this,{layout:n}=t,{vertical:i}=n;if(n.vertical=rd(e)[1],!t.initialItems){i!==n.vertical&&t.updateOverflow(t.overflow);for(const n of t.childItems){var r;null===(r=n.syncRotationToDock)||void 0===r||r.call(n,e)}}}updateOverflow(e,t){var n;const i=this,{axisProps:r,contentElement:s,overflowType:o}=i,{flexDir:a}=r,l=null===(n=i.overflowMenuButton)||void 0===n?void 0:n._menu,c={};var d;if(l&&(e?null==l||l.removeAll():l.eachWidget((e=>{e._overflowTwinOrigin.overflowTwin=null}))),"menu"===t?c.overflowMenuButton=null:"scroll"===t&&(c.overflowScrollStart=c.overflowScrollEnd=null),"menu"===o)null===(d=i.scrollable)||void 0===d||d.destroy(),s.style.overflow=s.style.overflowX=s.style.overflowY="",c.overflowMenuButton={cls:{[`b-${a}-menu`]:1}};else if("scroll"===o){const t="object"==typeof e&&(null==e?void 0:e.repeat)||nu;i.scrollable={[r.overflow]:"hidden-scroll",element:s,internalListeners:{scroll:"onContentScroll",thisObj:i}},c.overflowScrollStart={repeat:t,invertRotate:!0,cls:{[`b-${a}-start-scroller`]:1}},c.overflowScrollEnd={repeat:t,invertRotate:!0,cls:{[`b-${a}-end-scroller`]:1}}}i.tools=c,o?(s.classList.add("b-overflow"),i.monitorResize=!0,i.syncOverflowVisibility()):(s.classList.remove("b-overflow"),i.monitorResize=!1)}onContentScroll(){this.syncScrollerState()}onStartScrollClick(){this.scrollable[this.axisProps.pos]-=2}onEndScrollClick(){this.scrollable[this.axisProps.pos]+=2}onInternalResize(){super.onInternalResize(...arguments),this.isPainted&&this.syncOverflowVisibility()}syncOverflowVisibility(){const e=this,{overflowType:t,contentElement:n,isVisible:i}=e,{clientSizeProp:r,edgeProp:s,sizeProp:o}=e.axisProps,{overflowMenuButton:a,overflowScrollStart:l,overflowScrollEnd:c}=e.tools,d=e.rtl&&e.layout.horizontal,u="menu"===t,h=()=>Math.ceil(n[r]+(!l||l.hidden?0:l.rectangle("outer")[o])+(!c||c.hidden?0:c.rectangle("outer")[o])),g=()=>{if(0===R.length)return 0;const e=R[R.length-1].rectangle(n);return Math.floor(d?n[r]-e.left:e[s])};let m,p,f,v,y,b,C,S,D,w,E,R;if(i&&t&&0!==e.items.length){if(e.inSyncOverflowVisibility=!0,null==a||a.hide(),e.eachWidget(((e,t)=>{C=e.minifiable,w=e.overflowable,w=C?w||C:w,e.floating?t.down=!1:(t.down=!w,e.innerItem&&(e._toolbarOverflow&&(e.hidden=e._toolbarOverflow=!1),e._toolbarMinified&&(e.minified=e._toolbarMinified=!1),e.isVisible&&(C&&(S||(S=[])).push(e),w&&(R||(R=[])).push(e))))})),R&&(m=h(),p=g()),R&&p>m)if(u){for(;p>m&&(y=null===(x=S)||void 0===x?void 0:x.pop());){var x;b=p,y._toolbarMinified=!0,y.minified=!0,p=g(),b-=p,(D||(D=[])).push([y,b])}if(p>m){for(f of(a.show(),m=h(),v=ru.getEvictionList(R),v))p>m&&(y=f[1],y._toolbarOverflowWidth=y.width,y._toolbarOverflow=!0,y.hidden=!0,R.splice(R.indexOf(y),1),(E||(E=[])).push(f),p=g());if(E){for(E.sort(((e,t)=>e[0]-t[0])).forEach(((e,t)=>E[t]=e[1]));null!==(T=D)&&void 0!==T&&T.length;){var T;[y,b]=D.pop(),p+b<=m&&!y._toolbarOverflow&&(p+=b,y.minified=y._toolbarMinified=!1)}e.syncOverflowMenuButton(E)}else a.hide()}}else c.show(),l.show(),e.syncScrollerState();else u||(null==c||c.hide(),null==l||l.hide());e.inSyncOverflowVisibility=!1}}syncOverflowMenuButton(e){var t;const n=this,{axisProps:i,overflowMenuButton:r}=n,s={cls:"b-toolbar-overflow-menu",minWidth:280,items:[],align:{align:i.horizontal?"t100-b100":"r100-l100",axisLock:"flexible"}};for(const t of e)n.overflowItemFilter(t)&&t.addToOverflowMenu(s,n.horizontal?Qd:Jd,Kd);if(s.items.forEach((e=>{let t=e._overflowTwinOrigin,i=t.parent.indexOfChild(t);t.parent!==n&&(i=n.indexOfChild(t.parent)+i/1e5),e.weight=i})),null!==(t=r._menu)&&void 0!==t&&t.isMenu){const e=r.menu,{toAdd:t,toRemove:n}=$e.delta(s.items,e.items,!0);e.remove(n),e.add(t)}else r.menu=s}syncScrollerState(){const{axisProps:e,scrollable:t}=this,{overflowScrollStart:n,overflowScrollEnd:i}=this.tools,r=t[e.pos],s=t[e.max];n.disabled=!r,i.disabled=Math.abs(Math.ceil(r))>=Math.abs(s)}overflowItemFilter(e){const{filter:t}=this.overflow;return Boolean(t?t.call(this,e):Wn.getChildElementCount(e.element))}onLeafItemConfigChange(e,{name:t,value:n}){const i=this,r=i.up(Xd),s=r.hasConfig("overflow"),{overflowTwin:o}=i;!s||null!=r&&r.inSyncOverflowVisibility||"hidden"===t&&n===i._toolbarOverflow||!eu[t]&&(null!=i._width&&!i.monitorResize||i._flex&&!String(i._flex).endsWith("auto"))||(o&&!iu[t]&&(o[t]=n),null!=r&&r.isPainted&&"overflowMenuButton"!==i.ref&&((i.isTextField||i.isSlider||i.isCheckbox)&&"value"===t&&(i.containsFocus||null!=o&&o.containsFocus)||r.syncOverflowVisibility()))}createWidget(e){"->"===e?e={type:"widget",cls:"b-toolbar-fill"}:"|"===e?e={type:"widget",cls:"b-toolbar-separator"}:"string"==typeof e&&(e={type:"widget",cls:"b-toolbar-text",html:e});const t=super.createWidget(e);return this.widgetCls&&t.element.classList.add(this.widgetCls),t}}ru.initClass(),ru._$name="Toolbar";const su=e=>e.classList.contains("b-focus-trap")||e.classList.contains("b-hidden")||!Wn.getFocusability(e).focusable?Wn.NodeFilter.FILTER_SKIP:Wn.NodeFilter.FILTER_ACCEPT,ou=[],au={},lu=[ou,ou],cu=(e,t,n)=>{const{vertical:i}=e;return delete e.vertical,{...e,class:{...t,[`b-${i?"v":"h"}box`]:1,"b-box-center":1,"b-panel-bar-wrap":!n}}},du=(e,t,n=!1)=>{const i={vertical:n,children:e?[e]:[]};return t&&(i.tag=t),i},uu=(e,t)=>{null!=e&&e.classList?null==e||e.classList.add(t):null!=e&&e.class&&("string"==typeof e.class&&(e.class={[e.class]:1}),e.class[t]=1)},hu={dock:1,hidden:1,weight:1},gu={top:[!0,!0],bottom:[!0,!1],left:[!1,!0],right:[!1,!1]},mu={header:1,"pre-header":1};class pu extends(Nc.mixin(jr,Pd)){static $name="Panel";static type="panel";static get configurable(){return{localizableProperties:["title"],collapsed:{value:null,$config:null,default:!1},collapsible:{value:null,$config:"nullify"},bodyCls:{$config:{merge:"classList"},value:null},bodyTag:null,bodyWrapTag:null,trapFocus:null,title:null,header:null,stateful:["collapsed"],stripDefaults:{"*":{type:"toolbar",dock:"top"},bbar:{dock:"bottom",weight:-1e3},tbar:{weight:-1e3}},strips:{value:null,$config:"nullify"},toolDefaults:{close:{weight:-1e3},collapse:{weight:-990}},footer:null,revealed:null,tbar:null,bbar:null,role:"region"}}updateElement(e,t){const n=super.updateElement(e,t);return this.titleElement&&Wn.setAttributes(this.ariaElement,{"aria-describedby":this.titleElement.id}),n}get bodyWrapRootElement(){return this[this._bodyWrapRootName]}changeFooter(e){return e&&("start"===e.dock?e.dock="left":"end"===e.dock&&(e.dock="right")),e}compose(){const e=this,{collapsible:t,focusable:n,hasItems:i,revealed:r,tools:s}=e,o=e.composeHeader(),a=e.getPositionableItems("after",!0),l=e.getPositionableItems("before",!0),c=(null==o?void 0:o.class["b-dock-left"])||(null==o?void 0:o.class["b-dock-right"]);let d=e.composeBody(),u="bodyWrapElement";return t&&([u,d]=t.wrapCollapser(u,d)),e._bodyWrapRootName=u,{tabIndex:i&&!1!==n||n?0:null,class:{[`b-panel-collapsible-${null==t?void 0:t.type}`]:t,[`b-panel-collapse-${null==t?void 0:t.collapseDir}`]:t,[`b-${c?"h":"v"}box`]:1,"b-panel-collapsible":t,"b-panel-has-header":o,"b-panel-has-tools":s?1:0,"b-panel-overlay-revealed":r},children:{topFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-top-focus-trap":1}},...l,headerElement:o,[u]:d,...a,bottomFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-end-focus-trap":1}}}}}composeBody(){var e,t;const n=this,{bodyCls:i,bodyConfig:r,bodyWrapTag:s,footer:o,uiClassList:a}=n,l=W.values(n.strips,((e,t)=>!gu[null==t?void 0:t.dock])).sort(n.byWeightSortFn),c={top:null,right:null,bottom:null,left:null};let d,u,h,g,m,p,f;for(o&&(h=o.dock||"bottom",l.unshift({dock:h,element:{tag:"footer",reference:"footerElement",html:"string"==typeof o?o:o.html,class:{...a,[`b-dock-${h}`]:1,[`${o.cls||""}`]:1}}})),i&&(r[m="className"]||(m="class"),r[m]=new _t(r[m]).assign(i)),g=l.length;g-- >0;)d=l[g],[p,u]=gu[d.dock],f?f.vertical!==p&&(f=du(cu(f,a),"",p)):f=du(r,s,p),f.children[u?"unshift":"push"](d.element),c[d.dock]=d;uu(c.top,"b-innermost"),uu(c.right,"b-innermost"),uu(c.bottom,"b-innermost"),uu(c.left,"b-innermost");const v=cu(f||du(r,s),a,!0);return v.class[`${null===(e=n.layout)||void 0===e?void 0:e.containerCls}-panel`]=Boolean(null===(t=n.layout)||void 0===t?void 0:t.containerCls),v.class["b-panel-body-wrap"]=1,v.class[`b-${n.$$name.toLowerCase()}-body-wrap`]=1,v}get hasHeader(){if(!1===this.header)return!1;const{header:e,title:t,tools:n,parent:i}=this,r=this.maximizable||Object.values(n||{}).some((e=>!e.hidden));return e||!(null!=i&&i.suppressChildHeaders)&&(t||r)}get rootUiClass(){return pu}composeHeader(e){var t;const n=this;if(!n.hasHeader&&!e)return;const i=n.header||{},r=i.dock||"top",[s,o]=n.splitHeaderItems({as:"element",dock:r}),a=n.$meta.hierarchy,l=n.composeTitle(i),c=new _t({[`b-dock-${r}`]:1,...n.uiClassList},i.cls);let d,u;for(d=a.indexOf(pu);d<a.length;++d)u=a[d].$$name,"Grid"!==u&&(c[`b-${u.toLowerCase()}-header`]=1);const h={tag:"header",class:c,children:[...s,l,...o]};return(null===(t=n.collapsible)||void 0===t?void 0:t.composeHeader(h))||h}composeTitle(e){var t;const n="string"==typeof e?e:this.title||e.title,i={reference:"titleElement",id:`${this.id}-panel-title`,html:n??" ",class:{[`b-align-${e.titleAlign||"start"}`]:1,"b-header-title":1,...this.uiClassList}};return W.isObject(n)&&(delete i.html,W.merge(i,n)),(null===(t=this.collapsible)||void 0===t?void 0:t.composeTitle(i))||i}updateTitle(){}afterRecompose(){var e;super.afterRecompose();const t=this,{headerElement:n}=t;null===(e=t._headerClickDetacher)||void 0===e||e.call(t),t._headerClickDetacher=n&&Xt.on({element:n,click:e=>{var n;return null===(n=t.trigger)||void 0===n?void 0:n.call(t,"panelHeaderClick",{event:e})}})}onPanelHeaderClick(e){var t;null===(t=this.collapsible)||void 0===t||t.onPanelHeaderClick(e)}onInternalPaint(){var e;super.onInternalPaint(...arguments),null===(e=this.collapsible)||void 0===e||e.onPanelPaint(this)}splitHeaderItems({as:e,dock:t,alt:n}=au){const i=this,r="element"===e,{collapsed:s}=i,o=i.getEndTools({alt:n}),a=i.getStartTools({alt:n}),l=W.values(i.strips,((e,t)=>!mu[null==t?void 0:t.dock]&&t.isCollapsified({collapsed:s,alt:n})));let c,d,u,h=lu;if(l.length+o.length+a.length){for(h=[d=[...a,...l.filter((e=>"pre-header"===e.dock)).sort(i.byWeightSortFn)],c=[...l.filter((e=>"header"===e.dock)).sort(i.byWeightReverseSortFn),...o]],u=0;u<d.length;++u){var g,m;t&&(null===(g=(m=d[u]).syncRotationToDock)||void 0===g||g.call(m,t)),r&&(d[u]=d[u].element)}for(u=0;u<c.length;++u){var p,f;t&&(null===(p=(f=c[u]).syncRotationToDock)||void 0===p||p.call(f,t)),r&&(c[u]=c[u].element)}}return h}set bodyConfig(e){this._bodyConfig=e}get bodyConfig(){const e=this,{bodyTag:t}=e,n=W.merge({reference:"bodyElement",className:{...e.getStaticWidgetClasses(pu,"-content"),"b-box-center":1,"b-text-content":e.textContent&&e.hasNoChildren}},e._bodyConfig);return t&&(n.tag=t),n}changeBodyCls(e){return _t.from(e)}changeTbar(e){return this.getConfig("strips"),this.strips={tbar:e},this.strips.tbar}changeBbar(e){return this.getConfig("strips"),this.strips={bbar:e},this.strips.bbar}get childItems(){var e;const t=this,n=W.values(t.strips,((e,t)=>!gu[null==t?void 0:t.dock])).sort(t.byWeightSortFn),[i,r]=t.splitHeaderItems(),[s,o]=(null===(e=t.collapsible)||void 0===e?void 0:e.splitHeaderItems())||lu;return[...i,...s,...r,...o,...n.filter((e=>gu[e.dock][1])),...t.items,...n.filter((e=>!gu[e.dock][1])).reverse()]}get childItemsOrderedByRelevance(){var e;const t=this,n=W.values(t.strips,((e,t)=>!gu[null==t?void 0:t.dock])).sort(t.byWeightSortFn),[i,r]=t.splitHeaderItems(),[s,o]=(null===(e=t.collapsible)||void 0===e?void 0:e.splitHeaderItems())||lu;return[...t.items,...n.filter((e=>!gu[e.dock][1])).reverse(),...i,...s,...r,...o,...n.filter((e=>gu[e.dock][1]))]}changeStrips(e,t){const n=this,i=n.$strips||(n.$strips=new Id({configName:"strips",factory:Tc,inferType:!1,owner:n,created(e){var t;const{dock:r}=e;if(!mu[r]&&!gu[r])throw new Error(`Invalid dock value "${r}"; must be: top, left, right, bottom, header, or pre-header`);Ne.after(e,"onConfigChange",((e,{name:t})=>{hu[t]&&n.onConfigChange({name:"strips",value:i.target})})),e.innerItem=!1,n.onChildAdd(e),e.parent=n,null===(t=e.layout)||void 0===t||t.renderChildren(),e.hasItems&&(n.hasItems=!0)},setup:(e,t)=>((e=W.merge(W.clone(n.stripDefaults["*"]),n.stripDefaults[t],e)).parent=n,e.ref=t,e),transform:e=>(Array.isArray(e)&&(e={items:e}),e||null)}));if(i.update(e),!t)return i.target}get collapsing(){var e;return null===(e=this.collapsible)||void 0===e?void 0:e.collapsing}get collapsingExpanding(){var e;return null===(e=this.collapsible)||void 0===e?void 0:e.collapsingExpanding}get expanding(){var e;return null===(e=this.collapsible)||void 0===e?void 0:e.expanding}changeCollapsed(e){const t=this,{collapsible:n}=t;if(t.recompose.flush(),e=Boolean(e),!n||t.changingCollapse||!t.isPainted)return e;null==n||n.collapse({animation:null,collapsed:e})}changeCollapsible(e,t){const n=this;return n.getConfig("tools"),e&&(!0===e?e={}:"string"==typeof e&&(e={[gu[e]?"direction":"type"]:e})),Td.reconfigure(t,e,{owner:n,defaults:{panel:n},cleanup(){n.collapsed&&(t.collapse({animation:null,collapsed:!1}),n._collapsed=1)}})}updateCollapsible(e){const t=this,n=null==e?void 0:e.toolsConfig;t.tools={collapse:(null==n?void 0:n.collapse)||null,recollapse:(null==n?void 0:n.recollapse)||null},e&&t.isPainted&&t.collapsed&&(t._collapsed=1),1===t.collapsed&&(t.collapsed=!0)}_collapse(e,t){var n;return!0!==t&&void 0!==t&&(!1===t?e.collapsed=!e.collapsed:"number"==typeof t?e.animation={duration:t}:null===t?e.animation=t:!0===t||("animation"in t?W.merge(e,t):e.animation=t)),null===(n=this.collapsible)||void 0===n?void 0:n.collapse(e)}collapse(e){return this.collapsePanel(e)}expand(e){return this.expandPanel(e)}collapsePanel(e){return this._collapse({collapsed:!0},e)}expandPanel(e){return this._collapse({collapsed:!1},e)}toggleCollapsed(e){return this.collapsed?this.expand(e):this.collapse(e)}get expandedHeaderDock(){var e;return this._expandedHeaderDock??(null===(e=this.initialConfig.header)||void 0===e?void 0:e.dock)??"top"}set expandedHeaderDock(e){this._expandedHeaderDock=null==e?void 0:e.toLowerCase()}updateHeader(e){this.changingCollapse||(this.expandedHeaderDock=null==e?void 0:e.dock)}updateTrapFocus(e){var t;const n=this,{element:i}=n,{classList:r}=i,s="before"===e,o="after"===e;r.toggle("b-focus-trapped",e&&!s&&!o),r.toggle("b-focus-trapped-before",s),r.toggle("b-focus-trapped-after",o),n.focusTrapListener=null===(t=n.focusTrapListener)||void 0===t?void 0:t.call(n),e&&(n.focusTrapListener=Xt.on({element:i,focusin:"onFocusTrapped",delegate:".b-focus-trap",thisObj:n}),n.treeWalker||(n.treeWalker=n.setupTreeWalker(i,Wn.NodeFilter.SHOW_ELEMENT,su)))}setupTreeWalker(e,t,n){return document.createTreeWalker(e,t,n)}onFocusTrapped(e){const t=this,n=t.treeWalker,i=e.target===t.bottomFocusTrap,r=e.target===t.topFocusTrap;(r||i)&&!1!==t.trigger("focusTrap",{bottom:i,top:r})&&(i?(n.currentNode=t.topFocusTrap,n.nextNode()):(n.currentNode=t.bottomFocusTrap,n.previousNode()),t.requestAnimationFrame((()=>n.currentNode.focus())))}get focusElement(){return this.hasItems&&(super.focusElement||this.element)}get contentElement(){return this.element&&this.bodyElement}getPositionableLocation(e){let t,n;return"before"===e?n=this.headerElement||this.bodyWrapRootElement:"after"===e?n=this.bottomFocusTrap:t=this.contentElement,[t,n]}get widgetClassList(){const e=this,t=super.widgetClassList;var n;e.hasHeader&&t.push("b-panel-has-header",`b-header-dock-${(null===(n=e.header)||void 0===n?void 0:n.dock)||"top"}`);return e.tbar&&t.push("b-panel-has-top-toolbar"),e.bbar&&t.push("b-panel-has-bottom-toolbar"),t}}pu.initClass(),pu._$name="Panel";class fu extends pu{static $name="Popup";static type="popup";static get configurable(){return{autoShow:!0,autoClose:!0,showOnClick:!1,forElement:null,monitorResize:!0,floating:!0,hidden:!0,axisLock:!0,hideAnimation:{opacity:{from:1,to:0,duration:".3s",delay:"0s"}},showAnimation:{opacity:{from:0,to:1,duration:".4s",delay:"0s"}},stripDefaults:{bbar:{layout:{justify:"flex-end"}}},testConfig:{hideAnimation:null,showAnimation:null},closeAction:"hide",trapFocus:!0,focusOnToFront:!0,closable:null,maximizable:null,modal:null,maximized:null,tools:{close:{cls:"b-popup-close",handler:"close",weight:-1e3,ariaLabel:"L{Popup.close}",hidden:!0},maximize:{cls:"b-popup-expand",handler:"toggleMaximized",weight:-999,hidden:!0}},highlightReturnedFocus:!0,role:"dialog"}}finalizeInit(){const e=this,{forElement:t}=e;e.anchoredTo=t,e.initialAnchor=e.anchor,t&&!1!==e.showOnClick&&(e.initialConfig.autoShow||(e.autoShow=!1),Xt.on({element:t,[2===e.showOnClick?"contextmenu":"click"]:"onElementUserAction",thisObj:e,capture:!0})),super.finalizeInit(),!e.autoShow||t&&!Wn.isVisible(t)||(!0===e.autoShow?e.show():e.setTimeout((()=>e.show()),e.autoShow))}onInternalPaint({firstPaint:e}){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...arguments);const n=this;e&&n.headerElement&&Xt.on({element:n.headerElement,dblclick:n.onHeaderDblClick,thisObj:n})}doDestroy(){this.syncModalMask(),super.doDestroy()}compose(){const{hasNoChildren:e,textContent:t}=this;return{class:{"b-text-popup":Boolean(t&&e)}}}close(){if(!this._hidden){const e=this.trigger("beforeClose");if(W.isPromise(e))return e.then((e=>{!1!==e&&this.doClose()})),e;if(!1===e)return e}this.doClose()}doClose(){const e=this,{closeAction:t}=e;if(!e._hidden||"destroy"===t){var n;e.containsFocus&&e.highlightReturnedFocus&&e.setTimeout((()=>Wn.setFocusRendition(e.rootElement,!0)),0),e.modal&&"destroy"===t&&e.revertFocus(),e.unmask();const r=e.items.length&&(null===(n=e.items.find((e=>e.errorTip)))||void 0===n?void 0:n.errorTip);var i;if(r)null===(i=r.pointerOverOutDetacher)||void 0===i||i.call(r),r.hide();return e[t]()}}toggleMaximized(){this.maximized=!this.maximized}updateMaximized(e){Wn.toggleClasses(this.element,["b-maximized"],e)}onInternalKeyDown(e){const t=this;"Escape"===e.key&&(e.stopImmediatePropagation(),t.floating||t.positioned?t.close(!0):t.collapsible&&(t.revealed?t.collapsible.toggleReveal():t.collapse()))}onDocumentMouseDown({event:e}){const t=this,{owner:n}=t,{target:i}=e;if(t.isVisible){if("touchend"!==e.type&&null!=n&&n.isButton&&n._menu===t&&n.element.contains(i))return e.preventDefault(),!1;if(t.modal&&i===fu.modalMask)e.preventDefault(),t.modal.closeOnMaskTap?t.close():t.containsFocus||t.focus();else if(!t.owns(i,!0)&&t.autoClose)if(t.containsFocus){const n=Wn.getActiveElement(t.element);Xt.on({element:document,once:!0,expires:100,[e.type]:e=>{e.defaultPrevented&&Wn.getActiveElement(t.element)===n&&t.close()}})}else t.close()}}get isTopModal(){return!this._isRevertingFocus&&Wn.isVisible(fu.modalMask)&&this.element.previousElementSibling===fu.modalMask}onFocusIn(e){const t=Wn.getActiveElement(this);super.onFocusIn(e),Wn.getActiveElement(this)===t&&e.target===this.element&&this.focus()}onFocusOut(e){globalThis.visualViewport&&globalThis.visualViewport.height<document.documentElement.clientHeight-1||this.modal||!this.autoClose||this.close(),super.onFocusOut(e)}afterShow(){const e=this;(e.autoClose||e.modal)&&e.addDocumentMouseDownListener(),super.afterShow(...arguments),e.toFront()}toFront(){this.floating&&(super.toFront(),this.syncModalMask()),this.focusOnToFront&&this.focus()}addDocumentMouseDownListener(){this.mouseDownRemover||(this.mouseDownRemover=ti.ion({globaltap:"onDocumentMouseDown",thisObj:this}))}updateModal(e){if(e){const e=this;e.floating=!0,"number"!=typeof e._x&&"number"!=typeof e._y&&(e.centered=!0,e.anchor=!1)}}syncModalMask(){const e=this,{modal:t,element:n}=e;if(n.setAttribute("aria-modal",Boolean(t)),t&&e.isVisible)e.modalMask.classList.remove("b-hide-display"),e.modalMask.classList.toggle("b-modal-transparent",Boolean(t.transparent)),n.classList.add("b-modal"),e.modalMask.setAttribute("owned-by",e.id);else if(e.isPainted){n.classList.remove("b-modal");const t=e.floatRoot.querySelectorAll(".b-modal"),i=t.length?fu.fromElement(t[t.length-1],"popup"):null;i?i.syncModalMask():fu.modalMask.classList.add("b-hide-display")}}afterHide(){var e;const t=this;super.afterHide(...arguments),null===(e=t.mouseDownRemover)||void 0===e||e.call(t),t.mouseDownRemover=null,t.syncModalMask()}onElementUserAction(e){const{showOnClick:t}=this;"number"==typeof t&&t!==e.button||(2===e.button&&e.preventDefault(),this.show())}onHeaderDblClick(){this.maximizable&&this.toggleMaximized()}updateClosable(e){this.tools.close.hidden=!e}updateMaximizable(e){this.tools.maximize.hidden=!e}get modalMask(){const{modalMask:e}=fu;return e.nextElementSibling!==this.element&&this.floatRoot.insertBefore(e,this.element),e}static get modalMask(){return this._modalMask||(this._modalMask=Wn.createElement({className:"b-modal-mask b-hide-display"}),Xt.on({element:this._modalMask,wheel:e=>e.preventDefault()})),this._modalMask}}fu.initClass(),fu._$name="Popup";const vu=/^b-icon-/,yu=/^b-fa-/;class bu extends Tc{static $name="MenuItem";static type="menuitem";static get configurable(){return{checked:null,separator:null,toggleGroup:null,menu:{value:null,$config:["lazy","nullify"]},icon:null,text:null,closeParent:null,href:null,radio:null,target:null,localizableProperties:["text"],role:"menuitem",openMenuDelay:120}}updateElement(e,t){const n=super.updateElement(e,t);return"boolean"==typeof this.checked&&(this.role="menuitemcheckbox"),this.ariaHasPopup=!!this.hasMenu&&"menu",n}compose(){var e;const t=this,{checked:n,href:i,hasMenu:r,radio:s,separator:o,target:a,text:l}=t,c="boolean"==typeof n,d=t.icon||(c?"b-fw-icon":""),u="b-icon-"+(s?"radio-":""),h="object"==typeof l;return{tag:i?"a":"div",tabIndex:-1,href:i,target:a,class:{"b-has-submenu":r,"b-checked":n,"b-separator":o||(null===(e=t.cls)||void 0===e?void 0:e["b-separator"])},dataset:{group:t.toggleGroup},[c?"aria-checked":""]:n,[r?"aria-expanded":""]:!1,children:{iconElement:d&&{"aria-hidden":!0,tag:"i",class:{"b-fa":yu.test(d),"b-icon":vu.test(d),"b-menuitem-icon":1,[`${u}checked`]:!0===n,[`${u}unchecked`]:!1===n,..._t.normalize(d,"object")}},textElement:{tag:"span",[h?void 0:"text"]:h?void 0:l,class:{"b-menu-text":1,"b-menu-custom-content":h},children:h?[l]:null},subMenuIcon:r&&{"aria-hidden":!0,tag:"i",class:{"b-fw-icon":1,"b-icon-sub-menu":1}}}}}doAction(e){const t=this,n=this.parent,i={menu:n,item:t,element:t.element,bubbles:!0,domEvent:e};if("boolean"==typeof t.checked){const e=!t.checked;t.toggleGroup&&!e||(t.checked=!t.checked)}else t.href&&e.key&&t.element.click();t.trigger("beforeItem",i),t.trigger("item",i),t.closeParent&&n&&(n.rootMenu.close(),e&&!t.href&&e.preventDefault())}get focusElement(){return this.element}get contentElement(){return this.textElement}get isFocusable(){const{focusElement:e}=this;return e&&this.isVisible&&(e===document.body||e.offsetParent)}get hasMenu(){return this.hasConfig("menu")}get childItems(){const{_menu:e}=this;return e?[e]:[]}get radio(){return Boolean(this._radio??this.toggleGroup)}onFocusIn(e){const{menu:t}=this;super.onFocusIn(e),!this.disabled&&t&&(t.clearTimeout(t.closeTimer),this.delay("openMenu",t.closeTimer?0:this.openMenuDelay),t.closeTimer=null)}onFocusOut(e){var t;const n=this;n.clearTimeout("openMenu"),super.onFocusOut(e);const i=n._menu;!i||null!==(t=n.owner)&&void 0!==t&&t.ignoreFocusOut||(Wn.usingKeyboard?n.closeMenu():(i.clearTimeout(i.closeTimer),i.closeTimer=i.setTimeout((()=>n.closeMenu()),i.closeMenuDelay)))}openMenu(e){const{menu:t,parent:n}=this;!this.disabled&&t&&(t.focusOnToFront=e,n.isMenu?n.openSubMenu(this.element,this):t.show())}onChildShow(e){super.onChildShow(e),this.ariaElement.setAttribute("aria-expanded",!0)}closeMenu(){this._menu.isWidget&&this.menu.close(),this.menu.closeTimer=null}onChildHide(e){super.onChildHide(e),this.ariaElement.setAttribute("aria-expanded",!1)}changeToggleGroup(e){return e&&"boolean"!=typeof this.checked&&(this.checked=!1),e}changeChecked(e,t){if(this.isConfiguring||"boolean"==typeof t)return Boolean(e)}updateChecked(e){const t=this;t.isConfiguring||(t.toggleGroup&&t.uncheckToggleGroupMembers(),t.element.setAttribute("aria-checked",e),t.trigger("toggle",{menu:t.owner,item:t,element:t.element,bubbles:!0,checked:e}))}getToggleGroupMembers(){const e=this,{checked:t,toggleGroup:n,element:i}=e,r=[];return t&&n&&Wn.forEachSelector(e.rootElement,`[data-group=${n}]`,(e=>{if(e!==i){const t=Tc.fromElement(e);t&&r.push(t)}})),r}uncheckToggleGroupMembers(){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach((e=>e.checked=!1))}get closeParent(){return("boolean"==typeof this.checked?this._closeParent:!1!==this._closeParent)&&!this.hasMenu}changeMenu(e,t){const n=this,{constrainTo:i,scrollAction:r,focusOnHover:s}=n.owner;return!e||"object"!=typeof e||"items"in e||"widgets"in e||"html"in e||(e={lazyItems:e}),Su.reconfigure(t,e,{owner:n,defaults:{type:"menu",align:"s0-e0",anchor:!0,autoClose:!0,autoShow:!1,cls:{"b-sub-menu":1},forElement:n.element,owner:n,ariaLabel:n.text,focusOnHover:s,constrainTo:i,scrollAction:r}})}}bu.initClass(),bu._$name="MenuItem";const Cu={ArrowUp:1,ArrowDown:1,ArrowRight:1,ArrowLeft:1,Enter:1,Escape:1};class Su extends fu{static $name="Menu";static type="menu";static configurable={layout:"vbox",focusable:!0,showAnimation:null,hideAnimation:{opacity:{from:1,to:0,duration:".15s",delay:"0s"}},align:{align:"t-b"},scrollAction:"hide",focusOnHover:null,scrollable:!1,defaultType:"menuitem",tools:{close:!1},role:"menu",ariaElement:"bodyElement",closeMenuDelay:200};construct(e){Array.isArray(e)&&(e={lazyItems:e}),super.construct(e),Xt.on({element:this.element,click:"onMouseClick",mouseover:"onMouseOver",mouseenter:"onMouseEnter",mouseleave:"onMouseLeave",thisObj:this})}afterShow(){const{items:e,element:t}=this;e.some((e=>e.hasConfig("menu")))&&t.classList.add("b-menu-with-submenu");e.some((e=>e.icon))&&t.classList.add("b-menu-with-icon"),super.afterShow(...arguments)}createWidget(e){return"string"==typeof e&&(e={text:e}),super.createWidget(e)}get focusElement(){var e;const t=this,n=null===(e=t.parentMenu)||void 0===e?void 0:e.element.contains(Wn.getActiveElement(t.parentMenu)),i=t.items[0];return!n&&!Wn.usingKeyboard&&i instanceof bu?t.element:super.focusElement}onDocumentMouseDown({event:e}){if(!this.parentMenu||!this.parentMenu.owns(e.target))return super.onDocumentMouseDown(...arguments)}hide(e){const t=this;var n,i;(super.hide(e),t.isVisible)||(null===(n=t.currentSubMenu)||void 0===n||null===(i=n.hide)||void 0===i||i.call(n,e),t.parentMenu&&(t.parentMenu.currentSubMenu=null))}show(){const e=super.show(...arguments),{parentMenu:t}=this;return this.isVisible&&t&&(t.currentSubMenu=this),e}onMouseClick(e){const t=e.target.closest(".b-menuitem");t&&this.triggerElement(t,e)}onMouseOver(e){if(!1!==this.focusOnHover){var t;const n=null===(t=e.relatedTarget)||void 0===t?void 0:t.closest(".b-widget"),i=e.target.closest(".b-widget"),r=Tc.fromElement(i);!Wn.isTouchEvent&&i&&i!==n&&r.parent===this&&this.setTimeout({fn:"handleMouseOver",delay:30,args:[r],cancelOutstanding:!0})}}handleMouseOver(e){e.focus()}onMouseEnter(){this.clearTimeout(this.closeTimer);const{parentMenu:e}=this;e&&(e.ignoreFocusOut=!0,e.setTimeout((()=>e.ignoreFocusOut=!1),500),e.clearTimeout(e.hideSubMenuTimer))}onMouseLeave(e){const t=this,{relatedTarget:n}=e,i=n&&t.owns(n);let r=n instanceof HTMLElement&&Tc.fromElement(n),s=!i;if(r){for(;r.ownerCmp;)r=r.ownerCmp;s&=!Wn.getAncestor(r.element,[e.target])}!i&&s&&(t.currentSubMenu&&(t.hideSubMenuTimer=t.setTimeout((()=>{var e;return null===(e=t.currentSubMenu)||void 0===e?void 0:e.hide()}),t.closeMenuDelay)),t.element.contains(Wn.getActiveElement(t))&&Wn.getActiveElement(t).matches(".b-menuitem")&&t.focusElement.focus())}onInternalKeyDown(e){const t=Tc.fromElement(e),n=t&&t!==this&&!(t instanceof bu);if("Escape"===e.key)return void(n?this:this.rootMenu).close();if(super.onInternalKeyDown(e),n)return;Cu[e.key]&&e.preventDefault();const i=this.element,r=Wn.getActiveElement(i);this.navigateFrom(r!==i&&i.contains(r)?r:null,e.key,e)}navigateFrom(e,t,n){var i,r;const s=this,{treeWalker:o}=s,a=e&&s.getItem(e),l=s.rtl?"ArrowLeft":"ArrowRight",c=s.rtl?"ArrowRight":"ArrowLeft";let d;switch(t){case"ArrowUp":o.currentNode=e||(e=s.bottomFocusTrap),o.previousNode(),d=o.currentNode,null==a||null===(i=a.menu)||void 0===i||i.hide(!1);break;case"ArrowDown":o.currentNode=e||(e=s.topFocusTrap),o.nextNode(),d=o.currentNode,null==a||null===(r=a.menu)||void 0===r||r.hide(!1);break;case" ":e&&!e.classList.contains("b-disabled")&&(null!=a&&a.menu?s.openSubMenu(e,a):s.triggerElement(e,n));break;case l:if(e&&null!=a&&a.menu&&!e.classList.contains("b-disabled")){const t=s.openSubMenu(e,a);null==t||t.focus()}else o.currentNode=e||(e=s.topFocusTrap),o.nextNode(),d=o.currentNode;break;case c:s.isSubMenu?s.hide():e||(o.currentNode=e||(e=s.topFocusTrap),o.nextNode(),d=o.currentNode);break;case"Enter":e&&!e.classList.contains("b-disabled")&&s.triggerElement(e,n)}d&&(d===s.element?s.navigateFrom(s.bottomFocusTrap,"ArrowUp",n):d===e?s.navigateFrom(s.topFocusTrap,"ArrowDown",n):d.focus())}getItem(e){if(null!=e)return"number"==typeof e?this.items[e]:e.nodeType===Element.ELEMENT_NODE?Tc.fromElement(e,"menuitem",this.contentElement):this.items.find((t=>t.id==e))}triggerElement(e,t){const n=this.getItem(e);n&&!n.disabled&&n.doAction(t)}get isSubMenu(){var e;return this===(null===(e=this.owner)||void 0===e?void 0:e.menu)}openSubMenu(e,t){const n=this,i=t.menu;if(i){if(!i.isVisible){var r;const s={item:t,element:e};if(!1===n.trigger("beforeSubMenu",s))return;if(!1===(null===(r=t.onBeforeSubMenu)||void 0===r?void 0:r.call(t,s)))return;i.show(),i.isVisible&&!i.isMenu&&(n.currentSubMenu=i)}return i}}set selectedElement(e){const t=this,n=t._selectedElement;if(n){const e=t.getItem(n),i=null==e?void 0:e.menu;null==i||i.hide(),n.classList.remove("b-active")}if(t._selectedElement=e,e){const n=Wn.isFocusable(e);e.classList.add("b-active"),t.scrollable.scrollIntoView(e,{animate:!n,focus:n})}}get selectedElement(){return this._selectedElement}selectFirst(){const e=this.treeWalker;e.currentNode=this.topFocusTrap,e.nextNode(),this.requestAnimationFrame((()=>e.currentNode.focus()))}get parentMenu(){var e;const t=this.owner;return t&&(t.isMenu?t:null===(e=t.up)||void 0===e?void 0:e.call(t,"menu"))}get rootMenu(){let e=this;for(;e.parentMenu instanceof this.constructor;)e=e.parentMenu;return e}}let Du;Su.initClass(),Su._$name="Menu";class wu extends xi{static $name="ContextMenuBase";static get configurable(){return{type:null,menu:{$config:["lazy","nullify"],value:{type:"menu",autoShow:!1,closeAction:"hide",constrainTo:globalThis,scrollAction:null}},items:{},triggerEvent:null,clickTriggerSelector:null,preventNativeMenu:null,keyMap:{" ":{handler:"showContextMenuByKey",weight:100},"Ctrl+Space":"showContextMenuByKey"}}}static get pluginConfig(){return{assign:["showContextMenu"],chain:["onElementContextMenu","onElementClick","onElementDblClick"]}}construct(...e){var t;if(super.construct(...e),null===(t=this.type)||void 0===t||!t.length)throw new Error("Config 'type' is required to be specified for context menu")}onElementContextMenu(e){this.onElementEvent(e)}onElementClick(e){this.onElementEvent(e)}onElementDblClick(e){this.onElementEvent(e)}onElementEvent(e){if(e.handled||this.triggerEvent!==e.type)"click"===e.type&&this.clickTriggerSelector&&e.target.matches(this.clickTriggerSelector)&&this.internalShowContextMenu(e,{align:"l-r",target:e.target});else{if(!0===e.ctrlKey&&!d.isMac)return void e.preventDefault();const t=e;if(Du){const{target:n}=Du;e=new MouseEvent(e.type,e),Object.defineProperties(e,{target:{value:n},offsetX:{value:t.offsetX},offsetY:{value:t.offsetY}}),e.preventDefault=function(){t.preventDefault(),t.handled=!0},e=Xt.fixEvent(e)}this.internalShowContextMenu(e)}}showContextMenuByKey(e){if(!Wn.isEditable(e.target)){const{target:t}=e;if(t)return Du=e,Wn.triggerMouseEvent(t,this.triggerEvent),e.handled=!0,e.preventDefault(),e.stopImmediatePropagation(),Du=null,!0}return!1}internalShowContextMenu(e,t){const n=this;let i;n.disabled||!e.handled&&!e.defaultPrevented&&(i=n.getDataFromEvent(e))&&n.shouldShowMenu(i)&&("contextmenu"===e.type&&d.isSafari&&!e.ctrlKey&&e.metaKey&&Xt.on({element:e.target,capture:!0,once:!0,thisObj:this,click(e){e.preventDefault(),e.stopImmediatePropagation()}}),i.domEvent=e,n.showContextMenu(i,t))}getDataFromEvent(e){return{feature:this,event:e,targetElement:this.getTargetElementFromEvent(e)}}getTargetElementFromEvent(e){return e.target}async showContextMenu(e,t){var n;const i=this,r=Wn.isDOMEvent(e),s=r?i.getDataFromEvent(e):e,o=r?e:s.domEvent;if(null===(n=i._menu)||void 0===n||n.hide(),i.disabled)return;i.menuContext=s;const{type:a,client:l,processItems:c}=i,d=Wn.isInView(s.targetElement).center;if(b.assign(s,{point:null!=o&&o.clientX?[o.clientX+1,o.clientY+1]:[d.x,d.y],menu:i,items:{},selection:l.selectedRecords}),i.callChainablePopulateMenuMethod(s),b.merge(s.items,i.baseItems),i.preventNativeMenu&&i.preventDefaultEvent(s),(!c||!1!==await i.callback(c,l,[s]))&&i.hasActiveMenuItems(s)&&(i.populateItemsWithData(s),!1!==i.beforeContextMenuShow(s))){const{menu:e}=i,{featureItems:n}=e,{items:r}=s;i.preventDefaultEvent(s);let c=l.trigger(`${a}MenuBeforeShow`,s);if(W.isPromise(c)&&(o.handled=!0,c=await c),!Object.values(r).some((e=>e)))return;var u;if(!1!==c)n&&(e.remove(n),$e.asArray(n).forEach((e=>e.destroy()))),e.featureItems=e.add(...Array.isArray(r)?r:e.processItemsObject(r)),e.showBy(t||{target:s.domEvent,align:"s0-e100"}),null===(u=i.touchMoveDetacher)||void 0===u||u.call(i),i.touchMoveDetacher=Xt.on({element:l.element,touchmove:()=>e.hide(),thisObj:e,once:!0}),o&&(o.preventDefault(),o.handled=!0)}}get baseItems(){if(!this._baseItems){const e=this,{namedItems:t}=e,n=e._baseItems=b.assign({},e.items);for(const e in n){const i=n[e];i&&(t&&e in t?n[e]="object"==typeof i?b.merge(b.clone(t[e]),i):t[e]:!0===i&&delete n[e])}}return this._baseItems}hideContextMenu(e){var t;null===(t=this.menu)||void 0===t||t.hide(e)}callChainablePopulateMenuMethod(e){var t,n;null===(t=(n=this.client)[`populate${H.capitalize(this.type)}Menu`])||void 0===t||t.call(n,e)}hasActiveMenuItems(e){return Object.values(e.items).some((e=>e&&!e.hidden))}shouldShowMenu(){return!0}beforeContextMenuShow(e){}populateItemsWithData(e){}preventDefaultEvent(e){var t;null===(t=e.event)||void 0===t||t.preventDefault()}get triggerEvent(){return this._triggerEvent||this.client.contextMenuTriggerEvent}changeMenu(e,t){const n=this,{client:i,type:r}=n;if(e)return Su.reconfigure(t,e?Su.mergeConfigs({owner:i,rootElement:i.rootElement,onItem(e){i.trigger(`${r}MenuItem`,e)},onToggle(e){i.trigger(`${r}MenuToggleItem`,e)},onDestroy(){n.menu=null},onBeforeItem(e){Object.assign(e,n.menuContext)},onShow({source:e}){n.menuContext.menu=e,i.trigger(`${r}MenuShow`,n.menuContext)}},e):null,n);null!=t&&t.isWidget&&t.destroy()}}wu._$name="ContextMenuBase";var Eu=e=>class extends(e||Pe){static $name="DragHelperContainer";initContainerDrag(){const e=this;if(e.mode||(e.mode="container"),"container"===e.mode&&!e.containers)throw new Error("Container drag mode must specify containers")}grabContainerDrag(e){const t=this;if(!t.ignoreSelector||!e.target.closest(t.ignoreSelector)){const n=Wn.getAncestor(e.target,t.containers,t.outerElement);if(n){const i=n.getBoundingClientRect();t.context={element:n,valid:!0,action:"container",offsetX:e.pageX-i.left,offsetY:e.pageY-i.top,originalPosition:{parent:n.parentElement,prev:n.previousElementSibling,next:n.nextElementSibling}}}return!0}return!1}startContainerDrag(e){var t;const n=this,{context:i,floatRootOwner:r}=n,{element:s}=i,o=s.cloneNode(!0),a=null==r?void 0:r.element.closest(".b-outer");o.classList.add(n.dragProxyCls,n.draggingCls),((null==r?void 0:r.floatRoot)||Wn.getRootElement(s)).appendChild(o),i.dragProxy=o,i.dragging=s,s.classList.add(n.dropPlaceholderCls),null!=a&&null!==(t=a.parentElement)&&void 0!==t&&t.matches(".b-float-root")&&(o.style.zIndex=r.floatRootMaxZIndex+1)}onContainerDragStarted(e){const t=this,{context:n}=t,{element:i,dragProxy:r}=n,s=i.getBoundingClientRect();if(t.autoSizeClonedTarget)r.style.width=s.width+"px",r.style.height=s.height+"px",Wn.setTranslateXY(n.dragProxy,s.left,s.top);else if(t.useCenteredCursor){const t=r.getBoundingClientRect();Object.assign(n,{offsetX:t.width/2,offsetY:t.height/2}),Wn.setTranslateXY(r,e.clientX,e.clientY)}}updateContainerDrag(e){var t;const n=this,{context:i}=n;if(!i.started||!i.targetElement)return;const r=Wn.getAncestor(i.targetElement,n.containers,"b-gridbase"),s=null===(t=i.dragging)||void 0===t?void 0:t.contains(Wn.getActiveElement(i.dragging));r&&Wn.isDescendant(i.element,r)||(s&&ti.suspendFocusEvents(),r&&i.valid?n.moveNextTo(r,e):n.revertPosition(),s&&ti.resumeFocusEvents(),e.preventDefault())}finishContainerDrag(e){const t=this,{context:n}=t,{dragging:i,dragProxy:r,valid:s,draggedTo:o,insertBefore:a,originalPosition:l}=n;i&&(n.valid=Boolean(s&&(o||t.externalDropTargetSelector&&e.target.closest(t.externalDropTargetSelector))&&(i!==a||l.parent!==o)),n.finalize=(e=n.valid)=>{!e&&t.context&&t.revertPosition(),i.classList.remove(t.dropPlaceholderCls),r.remove(),t.reset()},n.async=!1,t.trigger("drop",{context:n,event:e}),n.async||n.finalize())}abortContainerDrag(e=!1,t=null,n=!1){const i=this,{context:r}=i;r.dragging&&(r.dragging.classList.remove(i.dropPlaceholderCls),r.dragProxy.remove(),i.revertPosition()),n||i.trigger(e?"drop":"abort",{context:r,event:t}),i.reset()}updateContainerProxy(e){var t;const n=this,{context:i}=n,r=i.dragProxy;let s,o=e.pageX-i.offsetX,a=e.pageY-i.offsetY;if("number"==typeof n.minX&&(o=Math.max(n.minX,o)),"number"==typeof n.maxX&&(o=Math.min(n.maxX-r.offsetWidth,o)),"number"==typeof n.minY&&(a=Math.max(n.minY,a)),"number"==typeof n.maxY&&(a=Math.min(n.maxY-r.offsetHeight,a)),n.lockX?Wn.setTranslateY(r,a):n.lockY?Wn.setTranslateX(r,o):Wn.setTranslateXY(r,o,a),"touchmove"===e.type){const t=e.changedTouches[0];s=Wn.elementFromPoint(t.clientX,t.clientY)}else s=e.target;i.targetElement=(null===(t=this.resolveTargetElement)||void 0===t?void 0:t.call(this,s))||s}moveNextTo(e,t){const{context:n}=this,i=n.dragging,r=e.parentElement;if(e!==i){const s=Pt.from(e).center.x;this.isRTL&&t.pageX>s||!this.isRTL&&t.pageX<s?(r.insertBefore(i,e),n.insertBefore=e):e.nextElementSibling?e.nextElementSibling!==i?(n.insertBefore=e.nextElementSibling,r.insertBefore(i,e.nextElementSibling)):n.insertBefore||i.parentElement.lastElementChild===i||(n.insertBefore=e.nextElementSibling):(r.appendChild(i),n.insertBefore=null),n.draggedTo=r}}revertPosition(){const{context:e}=this,{dragging:t}=e,{parent:n,next:i}=e.originalPosition;if(i){i.previousSibling===t||!i&&t===n.lastChild||n.insertBefore(t,i)}else n.appendChild(t);e.draggedTo=null}};const Ru={pageXOffset:0,pageYOffset:0};var xu=e=>class extends(Ir(e||Pe)){static $name="DragHelperTranslate";static get configurable(){return{positioning:null,skipUpdatingElement:null}}initTranslateDrag(){const e=this;!e.isElementDraggable&&e.targetSelector&&(e.isElementDraggable=t=>t.closest(e.targetSelector))}grabTranslateDrag(e){const t=this.getTarget(e);return!!t&&(this.context={valid:!0,element:t,startPageX:e.pageX,startPageY:e.pageY,startClientX:e.clientX,startClientY:e.clientY},!0)}getTarget(e){return e.target.closest(this.targetSelector)}getX(e){return"absolute"===this.positioning?parseFloat(e.style.left,10):"inset"===this.positioning?parseFloat(getComputedStyle(e).insetInlineStart,10):Wn.getTranslateX(e)}getY(e){return"absolute"===this.positioning?parseFloat(e.style.top,10):"inset"===this.positioning?parseFloat(getComputedStyle(e).insetBlockStart,10):Wn.getTranslateY(e)}getXY(e){if("absolute"===this.positioning)return[e.offsetLeft,e.offsetTop];if("inset"===this.positioning){const t=getComputedStyle(e);return[parseFloat(t.insetInlineStart,10),parseFloat(t.insetBlockStart,10)]}return Wn.getTranslateXY(e)}setXY(e,t,n){this.skipUpdatingElement||("absolute"===this.positioning?(e.style.left=t+"px",e.style.top=n+"px"):"inset"===this.positioning?(e.style.insetInlineStart=t+"px",e.style.insetBlockStart=n+"px"):Wn.setTranslateXY(e,t,n))}startTranslateDrag(e){const t=this,{context:n,outerElement:i,proxySelector:r}=t,s=t.dragWithin=t.dragWithin||t.cloneTarget&&document.body;let o=n.dragProxy||n.element;const a=o,l=o.parentElement;if(t.cloneTarget){const i=r?o.querySelector(r):o;let{width:l,height:c,x:d,y:u}=Pt.from(i,Pt.outer(s));t.isRTL&&o.style.insetInlineStart&&(d=Pt.outer(s).right-Pt.from(o).right),o=t.createProxy(o);let h=d,g=u;if(t.autoSizeClonedTarget&&(o.style.width=`${l}px`,o.style.height=`${c}px`),o.classList.add(t.dragProxyCls,t.draggingCls),o.classList.remove("b-hover","b-selected","b-focused"),s.appendChild(o),!t.autoSizeClonedTarget||r){const t=o.getBoundingClientRect(),{x:i,y:r}=s.getBoundingClientRect(),a=e.clientX-i,l=e.clientY-r+(s!==document.body?document.body.getBoundingClientRect().y:0);h=a-t.width/2,g=l-t.height/2,n.startPageX=e.pageX,n.startPageY=e.pageY}t.setXY(o,h,g),a.classList.add("b-drag-original"),t.hideOriginalElement&&a.classList.add("b-hidden")}o.classList.add(t.draggingCls);const c=t.getX(o),d=t.getY(o);Object.assign(n,{element:o,grabbed:a,grabbedParent:l,grabbedNextSibling:o.nextElementSibling,elementStartX:c,elementStartY:d,elementX:"inset"===t.positioning?c:Wn.getOffsetX(o,s||i),elementY:"inset"===t.positioning?d:Wn.getOffsetY(o,s||i),scrollX:0,scrollY:0,scrollManagerElementContainsDragProxy:!t.cloneTarget||s===i}),s&&(n.parentElement=o.parentElement,s!==o.parentElement&&s.appendChild(o),t.updateTranslateProxy(e))}onTranslateDragStarted(){var e;const t=this,{context:n}=t;let{relatedElements:i}=n;if(t.unifiedProxy&&n.element.classList.add("b-drag-main","b-drag-unified-proxy"),(null===(e=i)||void 0===e?void 0:e.length)>0){n.relatedElStartPos=[],n.relatedElDragFromPos=[];const{proxySelector:e}=t;let[r,s]=[n.elementStartX,n.elementStartY];n.originalRelatedElements=i,i=n.relatedElements=i.map(((i,o)=>{const a=e?i.querySelector(e):i,{x:l,y:c,width:d,height:u}=Pt.from(a,t.dragWithin),h=t.cloneTarget?t.createProxy(i):i;return h.classList.add(t.draggingCls),h.classList.remove("b-hover","b-selected","b-focused"),t.cloneTarget&&(t.setXY(h,l,c),t.dragWithin.appendChild(h),h.classList.add(t.dragProxyCls),t.autoSizeClonedTarget&&(h.style.width=`${d}px`,h.style.height=`${u}px`),t.hideOriginalElement&&i.classList.add("b-hidden"),i.classList.add("b-drag-original")),n.relatedElStartPos[o]=n.relatedElDragFromPos[o]=t.getXY(h),t.unifiedProxy&&(h.classList.add("b-drag-unified-animation","b-drag-unified-proxy"),r+=t.unifiedOffset,s+=t.unifiedOffset,t.setXY(h,r,s),n.relatedElDragFromPos[o]=[r,s],h.style.zIndex=100-o),h})),t.unifiedProxy&&i&&i.length>0&&Xt.onTransitionEnd({element:i[0],property:"transform",handler(){i.forEach((e=>e.classList.remove("b-drag-unified-animation")))},thisObj:t,once:!0})}}applyConstraints(e,t,n){const i=this,{constrain:r,dragWithin:s}=i,{pageXOffset:o,pageYOffset:a}=s===document.body?globalThis:Ru;return s&&r&&(t<0&&(t=0),t+e.offsetWidth>s.scrollWidth&&(t=s.scrollWidth-e.offsetWidth),n<0&&(n=0),n+e.offsetHeight>s.scrollHeight&&(n=s.scrollHeight-e.offsetHeight)),"number"==typeof i.minX&&(t=Math.max(i.minX+o,t)),"number"==typeof i.maxX&&(t=Math.min(i.maxX+o,t)),"number"==typeof i.minY&&(n=Math.max(i.minY+a,n)),"number"==typeof i.maxY&&(n=Math.min(i.maxY+a,n)),{constrainedX:t,constrainedY:n}}updateTranslateProxy(e,t){const n=this,{lockX:i,lockY:r,context:s}=n,o=s.dragProxy||s.element,{relatedElements:a,relatedElDragFromPos:l}=s,c=n.isRTL&&"inset"===n.positioning?-1:1;s.scrollManagerElementContainsDragProxy&&t&&(s.scrollX=t.getRelativeLeftScroll(o),s.scrollY=t.getRelativeTopScroll(o)),s.pageX=e.pageX,s.pageY=e.pageY,s.clientX=e.clientX,s.clientY=e.clientY;let d=s.elementStartX+(e.pageX-s.startPageX+s.scrollX)*c,u=s.elementStartY+e.pageY-s.startPageY+s.scrollY;if(n.snapCoordinates){const e=n.snapCoordinates({element:o,newX:d,newY:u});d=e.x,u=e.y}const{constrainedX:h,constrainedY:g}=n.applyConstraints(o,d,u);if((s.started||h!==d||g!==u)&&n.setXY(o,i?void 0:h,r?void 0:g),a){const e=i?0:h-s.elementStartX,t=r?0:g-s.elementStartY;a.forEach(((i,r)=>{const[s,o]=l[r];n.setXY(i,s+e,o+t)}))}s.newX=h,s.newY=g}async finishTranslateDrag(e){const t=this,n=t.context,{target:i}=e,r=!t.lockX&&Math.round(n.newX)!==Math.round(n.elementStartX),s=!t.lockY&&Math.round(n.newY)!==Math.round(n.elementStartY),o=n.dragProxy||n.element,{relatedElements:a}=n;if(!t.ignoreSamePositionDrop||r||s)if(!1===n.valid)await t.abortTranslateDrag(!0,e);else{const r=!t.allowDropOutside&&Pt.from(t.dragWithin||t.outerElement);r&&("number"!=typeof t.minX&&!0!==t.minX&&e.pageX<r.left||"number"!=typeof t.maxX&&!0!==t.maxX&&e.pageX>r.right||"number"!=typeof t.minY&&!0!==t.minY&&e.pageY<r.top||"number"!=typeof t.maxY&&!0!==t.maxY&&e.pageY>r.bottom)?await t.abortTranslateDrag(!0,e):(n.finalize=async(r=n.valid)=>{n.finalized?console.warn("DragHelper: Finalizing already finalized drag"):(n.finalized=!0,!r&&t.context&&await t.abortTranslateDrag(!0,null,!0),t.isDestroyed||(t.trigger("dropFinalized",{context:n,event:e,target:i}),t.reset()),t.cloneTarget||o.parentElement===n.grabbedParent||[o,...a||[]].forEach((e=>e.style.transform="")))},n.async=!1,await t.trigger("drop",{context:n,event:e,target:i}),n.async||await n.finalize())}else t.abortTranslateDrag(!1,e)}async abortTranslateDrag(e=!1,t=null,n=!1){var i,r;const s=this,{cloneTarget:o,context:a,proxySelector:l,dragWithin:c,draggingCls:d}=s,{relatedElements:u,relatedElStartPos:h,grabbed:g}=a,m=a.dragProxy||a.element;if(a.valid=!1,null===(i=s.scrollManager)||void 0===i||i.stopMonitoring(),a.aborted)return void console.warn("DragHelper: Aborting already aborted drag");let{elementStartX:p,elementStartY:f}=a;const v=p!==s.getX(m)||f!==s.getY(m);if(m&&a.started){if(!o&&c&&c!==a.grabbedParent&&a.grabbedParent.insertBefore(m,a.grabbedNextSibling),o&&l){const e=g.querySelector(l)||g,{x:t,y:n}=Pt.from(e);p=t,f=n}if(m.classList.add("b-aborting"),s.setXY(m,p,f),null==u||u.forEach(((e,t)=>{e.classList.remove(d),e.classList.add("b-aborting"),s.setXY(e,h[t][0],h[t][1])})),n||s.trigger(e?"drop":"abort",{context:a,event:t}),m.isConnected&&!s.isDestroying&&v){const e="inset"===s.positioning?"inset":"transform";await Xt.waitForTransitionEnd({element:m,property:Wn.getPropertyTransitionDuration(m,e)?e:"all",thisObj:s,once:!0,timeout:300,runOnDestroy:!0})}s.isDestroyed||s.trigger("abortFinalized",{context:a,event:t})}null!==(r=s.context)&&void 0!==r&&r.started&&s.reset()}cleanUp(){const{context:e,cloneTarget:t,draggingCls:n,dragProxyCls:i}=this,r=e.dragProxy||e.element,{relatedElements:s,originalRelatedElements:o,grabbed:a}=e,l=t&&(this.removeProxyAfterDrop||!e.valid),c=[n,"b-aborting",i,"b-drag-main","b-drag-unified-proxy"];r.classList.remove(...c),l&&r.remove(),null==s||s.forEach((e=>{l?e.remove():e.classList.remove(...c)})),a.classList.remove("b-drag-original","b-hidden"),null==o||o.forEach((e=>e.classList.remove("b-hidden","b-drag-original")))}};const Tu="onMouseMove",Mu="onMouseUp",Iu="onDocumentClick",Au="onTouchMove",ku="onTouchEnd",Fu="onKeyDown",Pu="onKeyDownUp";class Ou extends(Pe.mixin(at,Eu,xu)){static get defaultConfig(){return{dragProxyCls:"b-drag-proxy",invalidCls:"b-drag-invalid",draggingCls:"b-dragging",dropPlaceholderCls:"b-drop-placeholder",dragThreshold:5,outerElement:document.body,dragWithin:null,unifiedProxy:null,monitoringConfig:null,constrain:!0,minX:null,maxX:null,minY:null,maxY:null,mode:"translateXY",isElementDraggable:null,targetSelector:null,dropTargetSelector:null,dropTargetCls:null,proxySelector:null,cloneTarget:!1,autoSizeClonedTarget:!0,hideOriginalElement:!1,containers:null,ignoreSelector:null,startEvent:null,lockX:!1,lockY:!1,touchStartDelay:200,scrollManager:null,snapCoordinates:null,unifiedOffset:5,removeProxyAfterDrop:!0,clickSwallowDuration:50,ignoreSamePositionDrop:!0,allowDropOutside:null,floatRootOwner:null,mouseMoveListenerElement:document,externalDropTargetSelector:null,testConfig:{clickSwallowDuration:50,touchStartDelay:100},rtlSource:null,createProxy:null,resolveTargetElement:null,disabled:!1}}construct(e){const t=this;super.construct(e),t.initListeners(),t.isContainerDrag?t.initContainerDrag():t.initTranslateDrag(),t.onScrollManagerScrollCallback=t.onScrollManagerScrollCallback.bind(t)}doDestroy(){this.reset(!0),super.doDestroy()}initListeners(){const e=this,{outerElement:t}=e,n={element:t,pointerdown:"onPointerDown",thisObj:e};e.mouseMoveListenerElement=e.getMouseMoveListenerTarget(t),Xt.on(n)}getMouseMoveListenerTarget(e){const t=e.getRootNode();let n=this.mouseMoveListenerElement;return t.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&"closed"===t.mode&&(n=e.closest(".b-outer")||n),n}get isRTL(){var e;return Boolean(null===(e=this.rtlSource)||void 0===e?void 0:e.rtl)}onPointerDown(e){const t=this;if(0!==e.button||t.context||t.disabled||t.isElementDraggable&&!t.isElementDraggable(e.target,e))return;t.startEvent=e;if(t.isContainerDrag?t.grabContainerDrag(e):t.grabTranslateDrag(e)){const n=globalThis;t.blurDetacher=Xt.on({element:n,blur:t.onWindowBlur,thisObj:t});const i={element:t.mouseMoveListenerElement,thisObj:t,capture:!0,keydown:Fu,keyup:Pu};if("touch"===e.pointerType?(t.touchStartTimer=t.setTimeout((()=>t.touchStartTimer=null),t.touchStartDelay,"touchStartDelay"),i.touchmove={handler:Au,passive:!1},i.touchend=i.pointerup=ku):(i.pointermove=Tu,i.pointerup=Mu),t.dragListenersDetacher=Xt.on(i),t.dragWithin&&t.dragWithin!==t.outerElement&&t.outerElement.contains(t.dragWithin)){const e=Pt.from(t.dragWithin,t.outerElement);t.minY=e.top,t.maxY=e.bottom,t.minX=e.left,t.maxX=e.right}}}async internalMove(e){var t;if(e.scrollInitiated)return;const n=this,{context:i}=n,r=Xt.getDistanceBetween(n.startEvent,e);if(n.touchStartTimer&&r>n.dragThreshold)n.abort(!0);else if(!n.touchStartTimer&&null!=i&&i.element&&(i.started||r>=n.dragThreshold)&&(null===(t=e.target)||void 0===t?void 0:t.nodeType)===Node.ELEMENT_NODE){if(!i.started){var s;const t=Xt.getXY(n.startEvent),r=Xt.getXY(e),o=Math.abs(t[0]-r[0])>=Math.abs(t[1]-r[1])?"horizontal":"vertical";if(!i.beforeDragStartFired&&!1===n.trigger("beforeDragStart",{context:i,event:e,initialDirection:o}))return n.abort();if(i.beforeDragStartFired=!0,Math.abs(Xt.getDistanceBetween(n.startEvent,e,{x:n.lockY,y:n.lockX}))<n.dragThreshold)return;n.isContainerDrag?n.startContainerDrag(e):n.startTranslateDrag(e),i.started=!0,null===(s=n.scrollManager)||void 0===s||s.startMonitoring(W.merge({scrollables:[{element:n.dragWithin||n.outerElement}],callback:n.onScrollManagerScrollCallback},n.monitoringConfig)),i.outermostEl=Wn.getOutermostElement(e.target),i.outermostEl.classList.add("b-draghelper-active"),n.dropTargetSelector&&n.dropTargetCls&&Wn.getRootElement(n.outerElement).querySelectorAll(n.dropTargetSelector).forEach((e=>e.classList.add(n.dropTargetCls)));const a=n.trigger("dragStart",{context:i,event:e,initialDirection:o});W.isPromise(a)&&await a,n.onKeyDownUp(e),i.moveUnblocked=!0,n.isContainerDrag?n.onContainerDragStarted(e):n.onTranslateDragStarted(e),n.trigger("afterDragStart",{context:i,event:e,initialDirection:o})}i.moveUnblocked?n._cachedMouseEvent?(n.update(e),n.update(n._cachedMouseEvent),delete n._cachedMouseEvent):n.update(e):n._cachedMouseEvent=e}}onScrollManagerScrollCallback(e){var t;const{lastMouseMoveEvent:n}=this;null!==(t=this.context)&&void 0!==t&&t.element&&n&&(n.isScroll=!0,this.update(n,e))}onTouchMove(e){var t;1===(null===(t=e.changedTouches)||void 0===t?void 0:t.length)&&(this.context&&!this.touchStartTimer&&e.preventDefault(),this.internalMove(e))}onMouseMove(e){this.internalMove(e)}update(e,t){const n=this,{context:i}=n;let r=n.getMouseMoveEventTarget(e);"touchmove"===e.type&&(r=Xt.getComposedPathTarget(e)),i.target=r;let s=n.allowDropOutside||!n.dragWithin||n.dragWithin.contains(e.target);var o;s&&n.dropTargetSelector&&(s=s&&Boolean(null===(o=r)||void 0===o?void 0:o.closest(n.dropTargetSelector)));n.isContainerDrag?n.updateContainerProxy(e,t):n.updateTranslateProxy(e,t),i.valid=s,n.trigger("drag",{context:i,event:e}),n.isContainerDrag&&n.updateContainerDrag(e,t),i.valid=i.valid&&s;for(const e of n.draggedElements)e.classList.toggle(n.invalidCls,!i.valid);e&&(n.lastMouseMoveEvent=e)}get draggedElements(){const{context:e}=this;return[e.dragProxy||e.element,...e.relatedElements??[]]}async abort(e=!1){var t,n;const i=this,{context:r}=i;null===(t=i.scrollManager)||void 0===t||null===(n=t.stopMonitoring)||void 0===n||n.call(t),i.removeListeners(),null!=r&&r.started&&!r.aborted?(r.element.getBoundingClientRect(),r.valid=!1,i.isContainerDrag?i.abortContainerDrag(void 0,void 0,e):i.abortTranslateDrag(void 0,void 0,e),r.aborted=!0):i.reset(!0)}removeListeners(){var e,t;null===(e=this.dragListenersDetacher)||void 0===e||e.call(this),null===(t=this.blurDetacher)||void 0===t||t.call(this)}reset(e){const t=this,{context:n}=t;if(null!=n&&n.started){for(const e of t.draggedElements)e.classList.remove(t.invalidCls);n.outermostEl.classList.remove("b-draghelper-active"),t.isContainerDrag?n.dragProxy.remove():t.cleanUp(),t.dropTargetSelector&&t.dropTargetCls&&Wn.getRootElement(t.outerElement).querySelectorAll(t.dropTargetSelector).forEach((e=>e.classList.remove(t.dropTargetCls)))}t.removeListeners(),e||t.trigger("reset"),t.context=t.lastMouseMoveEvent=null}onTouchEnd(e){Wn.getOutermostElement(e.target).classList.remove("b-no-touch-scroll"),this.onMouseUp(e)}onDocumentClick(e){e.stopPropagation()}onMouseUp(e){const t=this,{context:n}=t;var i;(t.removeListeners(),n)&&(null===(i=t.scrollManager)||void 0===i||i.stopMonitoring(),n.started?n.moveUnblocked?(e.stopPropagation(),n.finalizing=!0,t.isContainerDrag?t.finishContainerDrag(e):t.finishTranslateDrag(e),Xt.on({element:document,thisObj:t,click:Iu,capture:!0,expires:t.clickSwallowDuration,once:!0})):t.ion({drag(){t.onMouseUp(e)},once:!0}):t.reset(!0))}onKeyDown(e){var t;null!==(t=this.context)&&void 0!==t&&t.started&&"Escape"===e.key&&(e.stopImmediatePropagation(),this.abort()),this.onKeyDownUp(e)}onKeyDownUp(e){var t;null===(t=this.context)||void 0===t||t.element.classList.toggle("b-drag-copy",e[d.ctrlKey]||e[d.metaKey])}onWindowBlur(){this.context&&!this.context.finalizing&&this.abort()}createProxy(e){this.proxySelector&&(e=e.querySelector(this.proxySelector)||e);const t=e.cloneNode(!0);return t.removeAttribute("id"),t}get isContainerDrag(){return"container"===this.mode}async animateProxyTo(e,t={align:"c-c"}){const{context:n,draggedElements:i}=this,{element:r}=n,s=e.isRectangle?e:Pt.from(e);i.forEach((e=>{e.classList.add("b-drag-final-transition"),Wn.alignTo(e,s,t,void 0,void 0,"inset"===this.positioning?"topInset":"translate")})),await Xt.waitForTransitionEnd({element:r,property:"all",thisObj:this,once:!0}),i.forEach((e=>e.classList.remove("b-drag-final-transition")))}get isDragging(){var e;return Boolean(null===(e=this.context)||void 0===e?void 0:e.started)}getMouseMoveEventTarget(e){return e.isScroll?Wn.elementFromPoint(e.clientX,e.clientY):e.target}}Ou._$name="DragHelper";const Lu={down:"onMouseDown",move:"onMouseMove",up:"onMouseUp",docclick:"onDocumentClick",touchstart:{handler:"onTouchStart",passive:!1},touchmove:"onTouchMove",touchend:"onTouchEnd",keydown:"onKeyDown"};class $u extends(at(Pe)){static get defaultConfig(){return{resizingCls:"b-resizing",dragThreshold:5,handleSize:10,dynamicHandleSize:null,reservedSpace:10,touchHandleSize:30,minWidth:1,maxWidth:0,minHeight:1,maxHeight:0,outerElement:document.body,scroller:null,allowResize:null,dragWithin:null,isElementResizable:null,targetSelector:null,leftHandle:!0,rightHandle:!0,topHandle:!0,bottomHandle:!0,handleSelector:null,handleContainerSelector:null,startEvent:null,grab:null,invalidCls:"b-resize-invalid",handleVisibilityThreshold:null,skipTranslate:!1,direction:"horizontal",clickSwallowDuration:50,constrainToParent:!0,rtlSource:null}}static configurable={skipUpdatingElement:null};construct(e){const t=this;super.construct(e),t.handleSelector||d.isHoverableDevice||(t.handleSize=t.touchHandleSize),t.handleVisibilityThreshold=t.handleVisibilityThreshold||2*t.handleSize,t.initListeners(),t.initResize()}doDestroy(){this.abort(!0),super.doDestroy()}updateSkipUpdatingElement(e){e&&(this.skipTranslate=!0)}getX(e){return"inset"===this.positioning?parseFloat(getComputedStyle(e).insetInlineStart,10):Wn.getTranslateX(e)}getY(e){return"inset"===this.positioning?parseFloat(getComputedStyle(e).insetBlockStart,10):Wn.getTranslateY(e)}setX(e,t){"inset"===this.positioning?e.style.insetInlineStart=t+"px":Wn.setTranslateX(e,t)}setY(e,t){"inset"===this.positioning?e.style.insetBlockStart=t+"px":Wn.setTranslateY(e,t)}initResize(){const e=this;if(!e.isElementResizable&&e.targetSelector&&(e.isElementResizable=t=>t.closest(e.targetSelector)),e.grab){const{edge:t,element:n,event:i}=e.grab;e.startEvent=i;const r=e.getX(n)||n.offsetLeft,s=e.getY(n)||n.offsetTop;e.context={element:n,edge:t,valid:!0,async:!1,elementStartX:r,elementStartY:s,newX:r,newY:s,elementWidth:n.offsetWidth,elementHeight:n.offsetHeight,startX:i.clientX+e.scrollLeft,startY:i.clientY+e.scrollTop,finalize:()=>{var t;return null===(t=e.reset)||void 0===t?void 0:t.call(e)}},n.classList.add(e.resizingCls),e.internalStartResize(e.isTouch)}}initListeners(){const e=this,t={element:e.outerElement,mousedown:Lu.down,touchstart:Lu.touchstart,thisObj:e};!e.handleSelector&&d.isHoverableDevice&&(t.mousemove={handler:Lu.move,delegate:e.targetSelector},t.mouseleave={handler:"onMouseLeaveTarget",delegate:e.targetSelector,capture:!0}),Xt.on(t)}get isRTL(){var e;return Boolean(null===(e=this.rtlSource)||void 0===e?void 0:e.rtl)}get scrollLeft(){return this.scroller?this.scroller.x:this.outerElement.scrollLeft}get scrollTop(){return this.scroller?this.scroller.y:this.outerElement.scrollTop}internalStartResize(e){var t;const n={element:document,keydown:Lu.keydown,thisObj:this};e?(n.touchmove=Lu.touchmove,n.touchend=n.pointerup=Lu.touchend):(n.mousemove=Lu.move,n.mouseup=Lu.up),this.removeDragListeners=Xt.on(n),null===(t=this.onResizeHandlePointerDown)||void 0===t||t.call(this,this.startEvent)}removeDragListeners(){}reset(){var e;null===(e=this.removeDragListeners)||void 0===e||e.call(this),this.context=null,this.trigger("reset")}canResize(e,t){return!this.isElementResizable||this.isElementResizable(e,t)}onPointerDown(e,t){const n=this;n.startEvent=t,n.canResize(t.target,t)&&n.grabResizeHandle(e,t)&&(t.stopImmediatePropagation(),"touchstart"===t.type&&t.preventDefault(),n.internalStartResize(e))}onTouchStart(e){e.touches.length>1||this.onPointerDown(!0,e)}onMouseDown(e){0===e.button&&this.onPointerDown(!1,e)}internalMove(e,t){const n=this,{context:i,direction:r}=n;if(null!=i&&i.element&&(i.started||Xt.getDistanceBetween(n.startEvent,t)>=n.dragThreshold)){var s;if(!i.started)null===(s=n.scrollManager)||void 0===s||s.startMonitoring(W.merge({scrollables:[{element:n.dragWithin||n.outerElement,direction:r}],callback:e=>{var t;return(null===(t=n.context)||void 0===t?void 0:t.element)&&n.lastMouseMoveEvent&&n.update(n.lastMouseMoveEvent,e)}},n.monitoringConfig)),n.trigger("resizeStart",{context:i,event:t}),i.started=!0;n.update(t)}else e||n.handleSelector||n.checkResizeHandles(t)}onTouchMove(e){this.internalMove(!0,e)}onMouseMove(e){this.internalMove(!1,e)}onPointerUp(e,t){var n;const i=this,r=i.context;var s,o;(null===(n=i.removeDragListeners)||void 0===n||n.call(i),r)?(null===(s=i.scrollManager)||void 0===s||s.stopMonitoring(),r.started&&Xt.on({element:Wn.getRootElement(t.target),thisObj:i,click:Lu.docclick,expires:i.clickSwallowDuration,capture:!0,once:!0}),i.finishResize(t)):null===(o=i.reset)||void 0===o||o.call(i)}onTouchEnd(e){this.onPointerUp(!0,e)}onMouseUp(e){this.onPointerUp(!1,e)}onDocumentClick(e){e.stopPropagation()}onKeyDown(e){"Escape"===e.key&&this.abort()}update(e){const t=this,{context:n,constrainToParent:i}=t,{element:r}=n;if(i){const i=Pt.from(t.outerElement);n.currentX=Math.max(Math.min(e.clientX,i.right),i.x)+t.scrollLeft,n.currentY=Math.max(Math.min(e.clientY,i.bottom),i.y)+t.scrollTop}else n.currentX=e.clientX+t.scrollLeft,n.currentY=e.clientY+t.scrollTop;r.classList.add(t.resizingCls),t.updateResize(e)&&(t.trigger("resizing",{context:n,event:e}),r.classList.toggle(t.invalidCls,!1===n.valid)),t.lastMouseMoveEvent=e}abort(e=!1){var t,n;const i=this;null===(t=i.scrollManager)||void 0===t||null===(n=t.stopMonitoring)||void 0===n||n.call(t),i.context?i.abortResize(null,e):i.isDestroyed||i.reset()}grabResizeHandle(e,t){const n=this;if(n.allowResize&&!n.allowResize(t.target,t))return!1;const i=n.handleSelector,r="touchstart"===t.type?t.changedTouches[0]:t,s=r.clientX,o=r.clientY;let a=n.targetSelector?t.target.closest(n.targetSelector):t.target;if(a){var l;let r;if(i){if(!t.target.matches(i))return!1;r="horizontal"===n.direction?t.pageX<Wn.getPageX(a)+a.offsetWidth/2?n.isRTL?"right":"left":n.isRTL?"left":"right":t.pageY<Wn.getPageY(a)+a.offsetHeight/2?"top":"bottom"}else if("horizontal"===n.direction?n.overLeftHandle(t,a)?r=n.isRTL?"right":"left":n.overRightHandle(t,a)&&(r=n.isRTL?"left":"right"):n.overTopHandle(t,a)?r="top":n.overBottomHandle(t,a)&&(r="bottom"),!r)return n.context=null,!1;"touchstart"===t.type&&t.preventDefault();const c=null===(l=n.internalBeforeStart)||void 0===l?void 0:l.call(n,{element:a,edge:r});if(c&&(a=c.element,r=c.edge),!1!==n.trigger("beforeResizeStart",{element:a,event:t})){const t=n.getX(a)||a.offsetLeft,i=n.getY(a)||a.offsetTop;return n.context={element:a,edge:r,isTouch:e,valid:!0,async:!1,direction:n.direction,elementStartX:t,elementStartY:i,newX:t,newY:i,elementWidth:a.offsetWidth,elementHeight:a.offsetHeight,startX:s+n.scrollLeft,startY:o+n.scrollTop,finalize:()=>{var e;return null===(e=n.reset)||void 0===e?void 0:e.call(n)}},a.classList.add(n.resizingCls),!0}}return!1}checkResizeHandles(e){const t=this,n=t.targetSelector?e.target.closest(t.targetSelector):e.target;let i=!1;return!n||t.allowResize&&!t.allowResize(e.target,e)?t.currentElement&&t.unHighlightHandle():(t.currentElement=t.handleContainerSelector?e.target.closest(t.handleContainerSelector):e.target,t.currentElement&&(i="horizontal"===t.direction?t.overLeftHandle(e,n)||t.overRightHandle(e,n):t.overTopHandle(e,n)||t.overBottomHandle(e,n),i?t.highlightHandle():t.unHighlightHandle())),i}onMouseLeaveTarget(e){const t=this;t.currentElement=t.handleContainerSelector?e.target.closest(t.handleContainerSelector):e.target,t.currentElement&&t.unHighlightHandle()}updateResize(e){const t=this,{context:n,allowEdgeSwitch:i,skipTranslate:r,skipUpdatingElement:s}=t;let o;i&&("horizontal"===t.direction?n.edge=n.currentX>n.startX?"right":"left":n.edge=n.currentY>n.startY?"bottom":"top");const{element:a,elementStartX:l,elementStartY:c,elementWidth:d,elementHeight:u,edge:h}=n,{style:g}=a,m=(n.currentX-n.startX)*("inset"===t.positioning&&t.isRTL?-1:1),p=n.currentY-n.startY,f=Wn.getExtremalSizePX(a,"minWidth")||t.minWidth,v=Wn.getExtremalSizePX(a,"maxWidth")||t.maxWidth,y=Wn.getExtremalSizePX(a,"minHeight")||t.minHeight,b=Wn.getExtremalSizePX(a,"maxHeight")||t.maxHeight,C=("right"!==h||t.isRTL&&"inset"!==t.positioning)&&"bottom"!==h?-1:1,S=d+m*C,D=u+p*C;let w=Math.max(f,S),E=Math.max(y,D);if(v>0&&(w=Math.min(w,v)),b>0&&(E=Math.min(E,b)),"horizontal"===t.direction&&d!==w){if(s||(g.flex="",g.width=Math.abs(w)+"px"),n.newWidth=w,"left"===h||w<0){const e=Math.max(Math.min(l+d-t.minWidth,l+m),0);r||t.setX(a,Math.round(e)),n.newX=e}else"right"===h&&i&&!r&&t.setX(a,l);o=!0}else"vertical"===t.direction&&u!==D&&(s||(g.flex="",g.height=Math.abs(E)+"px"),n.newHeight=E,"top"===h||E<0?(n.newY=Math.max(Math.min(c+u-t.minHeight,c+p),0),r||t.setY(a,n.newY)):"bottom"===h&&i&&!r&&t.setY(a,c),o=!0);return o}finishResize(e){const t=this,n=t.context,i={context:n,event:e};if(n.element.classList.remove(t.resizingCls),n.started){let e=!1;e="horizontal"===t.direction?n.newWidth&&n.newWidth!==n.elementWidth:n.newHeight&&n.newHeight!==n.elementHeight,t.trigger(e?"resize":"cancel",i),n.async||n.finalize()}else{var r;null===(r=t.reset)||void 0===r||r.call(t)}}abortResize(e=null,t=!1){const n=this,i=n.context;i.element.classList.remove(n.resizingCls),"horizontal"===n.direction?(("left"===i.edge||i.allowEdgeSwitch&&!i.skipTranslate)&&n.setX(i.element,i.elementStartX),i.element.style.width=i.elementWidth+"px"):(n.setY(i.element,i.elementStartY),i.element.style.height=i.elementHeight+"px"),!t&&n.trigger("cancel",{context:i,event:e}),n.isDestroyed||n.reset()}highlightHandle(){const e=this,t=e.targetSelector?e.currentElement.closest(e.targetSelector):e.currentElement;e.currentElement.classList.add("b-resize-handle"),t.classList.add("b-over-resize-handle")}unHighlightHandle(){const e=this,t=e.targetSelector?e.currentElement.closest(e.targetSelector):e.currentElement;t&&t.classList.remove("b-over-resize-handle"),e.currentElement.classList.remove("b-resize-handle"),e.currentElement=null}overAnyHandle(e,t){return this.overStartHandle(e,t)||this.overEndHandle(e,t)}overStartHandle(e,t){return"horizontal"===this.direction?this.overLeftHandle(e,t):this.overTopHandle(e,t)}overEndHandle(e,t){return"horizontal"===this.direction?this.overRightHandle(e,t):this.overBottomHandle(e,t)}getDynamicHandleSize(e,t){const n=e?2:1,{handleSize:i}=this;return this.dynamicHandleSize&&i*n>t-this.reservedSpace?Math.max(Math.floor((t-this.reservedSpace)/n),0):i}overLeftHandle(e,t){const n=this,{offsetWidth:i}=t;if(n.leftHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=Pt.from(t);return r.width=n.getDynamicHandleSize(n.rightHandle,i),r.width>0&&r.contains(Xt.getPagePoint(e))}return!1}overRightHandle(e,t){const n=this,{offsetWidth:i}=t;if(n.rightHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=Pt.from(t);return r.x=r.right-n.getDynamicHandleSize(n.leftHandle,i),r.width>0&&r.contains(Xt.getPagePoint(e))}return!1}overTopHandle(e,t){const n=this,{offsetHeight:i}=t;if(n.topHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=Pt.from(t);return r.height=n.getDynamicHandleSize(n.bottomHandle,i),r.height>0&&r.contains(Xt.getPagePoint(e))}return!1}overBottomHandle(e,t){const n=this,{offsetHeight:i}=t;if(n.bottomHandle&&n.canResize(t,e)&&(i>=n.handleVisibilityThreshold||n.dynamicHandleSize)){const r=Pt.from(t);return r.y=r.bottom-n.getDynamicHandleSize(n.bottomHandle,i),r.height>0&&r.contains(Xt.getPagePoint(e))}return!1}}$u._$name="ResizeHelper";const _u=/>[ \t\r\n]+</g,ju=/\s\s+/g;class Bu{static tpl(e,...t){let n=0,i=t.map(((t,i)=>{let r=e[i];return Array.isArray(t)?r+=t.reduce(((e,t)=>e+(("string"==typeof t?t.trim():t)+"\n")),""):(void 0===t&&(t=""),r+="string"==typeof t?t.trim():t),n++,r})).join("");return n<=e.length&&(i+=e[e.length-1]),i.replace(_u,"><").replace(ju," ").trim()}static docsTpl(e,...t){let n=0,i=t.map(((t,i)=>{let r=e[i];return Array.isArray(t)?r+=t.reduce(((e,t)=>e+(("string"==typeof t?t.trim():t)+"\n")),""):(void 0===t&&(t=""),r+="string"==typeof t?t.trim():t),n++,r})).join("");return n<=e.length&&(i+=e[e.length-1]),i.replace(_u,"><").trim()}static repeat(e){return function(...t){return Bu.tpl(...t).repeat(e)}}static loop(e){}}Bu._$name="TemplateHelper";class Hu extends Array{constructor(e,t){super(),this.timeZone=e,this.year=t}}class Vu{constructor(e,t){this.asString=e,this.timeZone=t,this.asArray=Wu(e)}get asLocalDate(){return this._asLocalDate||(this._asLocalDate=new Date(...this.asArray)),this._asLocalDate}get asTicksUtc(){return this._asTicksUtc||(this._asTicksUtc=new Date(Date.UTC(...this.asArray)).getTime()),this._asTicksUtc}}const zu=(e,t)=>{const n=e.toLocaleString("sv-SE",{timeZone:t});return new Vu(n,t)},Nu=(e,t)=>{const{asTicksUtc:n,asString:i}=zu(new Date(e),t);return{offset:(e-n)/6e4,tzTicksUtc:n,tzString:i}},Wu=e=>{const t=e.split(/[\s-:]/).map((e=>1*e));return t[1]-=1,t},Uu=-864e5,Gu=2592e6,Yu=(e,t)=>{const n=qu.get(e,t);if(n)return n;const i=new Hu(e,t),r=new Date(Date.UTC(t,0,1)).getTime();let s,o,a,l,c=r,d=Gu,u=0,h=[],g=null;for(;!l;)({offset:a,tzTicksUtc:s,tzString:o}=Nu(c,e)),null==g?(g=a,i.push({offset:a})):d>0&&a!==g?d=d===Gu?Uu:-6e4:d<0&&a===g&&(d===Uu?d=36e5:(1===i.length?(i.push(h),g=h.offset):(i[0].startTicks=h.startTicks,i[0].startDateString=h.startDateString,l=!0),d=Gu)),h={offset:a,startDateString:o,startTicks:s},d===Gu&&(c=r,c+=u*Gu,u+=1),c+=d,u>11&&(l=!0);return qu.set(i),i},qu={_cache:{},get(e,t){var n;return null===(n=this._cache[e])||void 0===n?void 0:n[t]},set(e){const{timeZone:t}=e,{_cache:n}=this;n[t]||(n[t]={}),n[t][e.year]=e}};class Ku{static $name="TimeZoneHelper";static toTimeZone(e,t){if("number"==typeof t)return this.toUtcOffset(e,t);const n=zu(e,t);return n.asArray[3]!==n.asLocalDate.getHours()&&console.warn("Incorrect time zone conversion due to local DST-switch detected"),n.asLocalDate}static fromTimeZone(e,t){if("number"==typeof t)return this.fromUtcOffset(e,t);const n=this.dateAsArray(e),i=Yu(t,e.getUTCFullYear());let r=i[0].offset;if(2===i.length){const e=Date.UTC(...n);e>=i[1].startTicks&&e<i[0].startTicks&&(r=i[1].offset)}return n[4]+=r,new Date(Date.UTC(...n))}static toUtcOffset(e,t){const n=e.getTimezoneOffset()+t;return new Date(e.getTime()+60*n*1e3)}static fromUtcOffset(e,t){const n=-e.getTimezoneOffset()-t;return new Date(e.getTime()+60*n*1e3)}static dateAsArray(e){return[e.getFullYear(),e.getMonth(),e.getDate(),e.getHours(),e.getMinutes(),e.getSeconds(),e.getMilliseconds()]}}Ku.findOffsetDates=Yu,l.register(Ku),Ku._$name="TimeZoneHelper";class Xu extends Tc{static $name="Toast";static type="toast";static get configurable(){return{testConfig:{destroyTimeout:1,timeout:1e3},floating:!0,timeout:2500,autoDestroy:null,destroyTimeout:200,showProgress:!0,color:null,sideMargin:20,side:"bottom",role:"alert"}}static toasts={"top-start":[],"top-end":[],"bottom-start":[],"bottom-end":[]};changeSide(e){return"top"==e||"bottom"==e?e+="-end":"start"!==e&&"end"!=e||(e="bottom-"+e),e}compose(){const{appendTo:e,color:t,html:n,showProgress:i,style:r,timeout:s,side:o}=this;return{parent:e||this.floatRoot,class:{..._t.normalize(t,"object"),[`b-side-${o}`]:1,"b-toast-hide":1},html:n,style:{...Wn.parseStyle(r),"--side":o.split("-")[0]},children:{progressElement:i&&{style:`animation-duration:${s/1e3}s;`,class:{"b-toast-progress":1}}},listeners:{click:"hide"}}}doDestroy(){this.untoast(),super.doDestroy()}getNextInset(e){const{sideMargin:t,element:n}=this;return parseInt(n.style[e],10)+n.offsetHeight+t}async show(){await super.show(...arguments);const e=this,{element:t,side:n}=e,i=Xu.toasts[n],r=n.split("-")[0];var s;i.includes(e)||(t.style[r]=((null===(s=i[0])||void 0===s?void 0:s.getNextInset(r))??e.sideMargin)+"px",i.unshift(e),t.getBoundingClientRect(),t.classList.remove("b-toast-hide"),e.timeout>0&&(e.hideTimeout=e.setTimeout("hide",e.timeout)),Wn.addAttributeValue(document.body,"aria-describedby",e.id))}async hide(){const e=this;e.untoast(),e.element.classList.add("b-toast-hide"),e.autoDestroy&&!e.destroyTimer&&(e.destroyTimer=e.setTimeout("destroy",e.destroyTimeout))}untoast(){const e=Xu.toasts[this.side];e.includes(this)&&e.splice(e.indexOf(this),1),Wn.removeAttributeValue(document.body,"aria-describedby",this.id)}static hideAll(){Object.keys(Xu.toasts).forEach((e=>Xu.toasts[e].slice().reverse().forEach((e=>e.hide()))))}static show(e){const t=Xu.new({autoDestroy:!0,rootElement:document.body},"string"==typeof e?{html:e}:e);return t.show(),t}}Xu.initClass(),Xu._$name="Toast";class Zu{static getById(e){return G.deprecate("core","7.0.0","Use Widget.getById instead"),Tc.getById(e)}static fromElement(e,t,n){return G.deprecate("core","7.0.0","Use Widget.fromElement instead"),Tc.fromElement(e,t,n)}static createWidget(e={}){return G.deprecate("core","7.0.0","Use Widget.create instead"),e.isWidget?e:Tc.create(e)}static append(e,t){if(G.deprecate("core","7.0.0","Use a Container instead"),e=Array.isArray(e)&&e||[e],(t instanceof HTMLElement||"string"==typeof t)&&(t={appendTo:t}),t.insertFirst){const e="string"==typeof t.insertFirst?document.getElementById(t.insertFirst):t.insertFirst;e.firstChild?t.insertBefore=e.firstChild:t.appendTo=e}return e.map((e=>Tc.create(W.assign({},t||{},e))))}static openPopup(e,t){return G.deprecate("core","7.0.0","Use Popup directly instead"),Tc.create(W.assign({forElement:e},"string"==typeof t?{html:t}:t),"popup")}static showContextMenu(e,t){G.deprecate("core","7.0.0","Use Menu directly instead");const n=this;return n.currentContextMenu&&n.currentContextMenu.destroy(),e instanceof HTMLElement?t.forElement=e:(t.forElement=document.body,Array.isArray(e)&&(e=new Ot(...e)),e instanceof Ot&&(t.align={position:e})),t.internalListeners={destroy:n.currentContextMenu=null},n.currentContextMenu=Tc.create(t,"menu")}static attachTooltip(e,t){return G.deprecate("core","7.0.0","Use Tooltip directly instead"),Tc.attachTooltip(e,t)}static hasTooltipAttached(e){return G.deprecate("core","7.0.0","Will be removed"),Tc.resolveType("tooltip").hasTooltipAttached(e)}static destroyTooltipAttached(e){return G.deprecate("core","7.0.0","Will be removed"),Tc.resolveType("tooltip").destroyTooltipAttached(e)}static mask(e,t="Loading"){if(G.deprecate("core","7.0.0","Use Mask directly instead"),e)return e instanceof HTMLElement&&(e={target:e,text:t}),Lc.mask(e,e.target)}static unmask(e,t=!0){G.deprecate("core","7.0.0","Use Mask directly instead"),e.mask&&(t?e.mask.close():e.mask.hide())}static toast(e){return G.deprecate("core","7.0.0","Use Toast directly instead"),Xu.show(e)}}Zu._$name="WidgetHelper";class Ju{static convertFromObject(e,t={}){b.assignIf(t,{rootName:"root",elementName:"element",includeHeader:!0,rootElementForArray:!0});const{rootName:n,elementName:i,includeHeader:r,rootElementForArray:s}=t;let{xmlns:o}=t;o=o?` xmlns="${o}"`:"";const a=e=>{const t=[];for(const n in e){const r=e[n];if(Array.isArray(r)){s&&t.push(`<${n}>`);for(const e of r)i.length?t.push(`<${i}>`):t.push(`<${n}>`),t.push(a(e)),i.length?t.push(`</${i}>`):t.push(`</${n}>`);s&&t.push(`</${n}>`)}else b.isObject(r)?t.push(`<${n}>${a(r)}</${n}>`):null==r?t.push(`<${n}/>`):t.push(`<${n}>${H.encodeHtml(r)}</${n}>`)}return t.join("")};return`${r?'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>':""}<${n}${o}>${a(e)}</${n}>`}}Ju._$name="XMLHelper";class Qu{constructor(){this.random100=[46,2,36,46,54,59,18,20,71,55,88,98,13,61,61,40,2,15,3,32,51,45,64,25,81,85,54,13,57,49,64,22,81,94,0,62,17,7,11,2,33,99,85,26,83,83,96,26,20,89,91,38,26,13,11,79,32,30,5,51,70,7,5,56,58,77,37,89,40,80,78,59,26,36,8,51,60,23,86,5,11,96,64,94,87,64,4,78,17,85,35,0,90,86,23,55,53,9,35,59,29,2,64,42,8,49,43,73,6,53,38,9,39,31,32,40,49,13,78,68,20,99,24,78,35,91,73,46,67,76,89,69,30,69,25,3,4,55,1,65,66,76,83,19,67,1,95,24,54,45,56,40,67,92,72,4,69,8,47,50,27,2,38,9,14,83,12,14,62,95,22,47,35,18,38,14,86,64,68,61,52,69,39,93,20,73,32,52,74,6,56,68,99,29,24,92,40,67,6,72,31,41,91,53,80,55,33,97,97,99,18,20,5,27,82,84,61,78,27,67,7,42,75,95,91,25,63,21,70,36,46,0,1,45,84,6,86,15,10,62,96,94,10,23,93,83,94,47,5,29,29,52,51,37,77,96,43,72,43,14,54,14,72,52,4,39,15,26,68,28,25,76,60,50,22,40,72,74,68,58,8,48,40,62,52,24,9,26,47,44,49,96,7,77,90,45,76,47,5,86,1,36,18,42,19,90,34,23,70,32,69,79,0,99,57,80,72,21,19,72,85,68,4,40,86,62,0,63,4,11,69,31,78,31,21,78,29,84,13,53,57,10,26,50,24,30,90,42,51,96,93,21,99,23,81,0,89,43,86,63,93,19,54,71,92,36,4,95,37,99,60,29,23,50,68,95,57,95,77,53,99,78,75,12,92,47,23,14,0,41,98,11,34,64,26,90,50,23,38,31,74,76,16,76,66,23,22,72,48,50,20,36,37,58,5,43,49,64,81,30,8,21,98,75,60,17,50,42,27,38,90,74,45,68,67,27,31,15,58,76,41,99,23,98,53,98,56,19,79,2,4,38,96,24,65,51,43,42,41,60,46,7,90,65,3,27,63,99,51,44,86,1,54,40,15,74,3,81,51,63,87,79,84,72,22,38,96,95,33,41,21,99,21,69,7,49,40,52,41,6,91,19,76,40,54,17,33,11,11,0,1,32,94,33,13,18,45,7,85,61,42,54,45,72,78,96,17,9,80,87,41,96,66,0,8,59,18,21,2,28,64,75,97,32,80,86,97,97,55,2,73,75,11,89,67,58,70,76,12,46,64,17,22,97,25,35,93,57,82,46,57,61,31,74,27,4,32,85,53,86,53,53,42,5,28,50,65,63,70,61,73,37,13,80,7,34,22,3,26,6,62,78,12,56,87,41,58,64,31,27,45,35,18,66,62,43,89,69,94,93,33,74,2,43,85,37,82,41,74,9,15,44,33,42,65,19,1,49,78,12,29,9,78,7,55,12,45,40,33,16,86,14,52,16,73,76,0,98,75,91,78,46,99,95,90,69,78,45,62,55,37,88,49,77,27,83,38,73,39,1,75,40,65,83,54,95,7,73,4,30,26,36,89,21,5,95,11,14,87,45,36,21,77,55,5,66,51,98,48,62,74,58,23,82,30,28,19,53,89,76,98,8,34,70,28,54,16,52,35,93,54,54,72,49,18,93,72,90,71,73,15,60,38,80,76,53,70,39,69,25,5,31,61,46,6,54,34,31,52,33,36,79,76,44,29,28,38,1,66,2,90,91,1,76,78,31,55,37,71,2,3,38,85,0,95,42,2,39,57,87,61,77,98,2,24,80,48,27,47,71,15,7,49,60,86,3,2,29,38,54,36,59,83,27,47,9,36,42,8,73,85,9,16,73,60,39,12,43,25,23,29,28,47,40,77,20,89,22,30,41,59,96,19,56,20,76,73,39,46,72,40,47,37,52,29,79,37,39,50,41,87,66,17,75,31,45,26,88,70,11,90,40,74,9,32,65,72,61,6,93,54,15,84,22,99,47,10,96,4,84,19,85,73,45,25,16,8,94,99,39,28,26,68,87,48,1,65,86,46,86,7,60,82,45,75,38,56,41,35,30,86,91,97,85,45,5,14,69,85,96,37,18,26,16,38,16,1,44,94,85,58,60,20,5,47,52,41,50,71,43,42,67,64,38,65,83,99,78,96,33,20,98,24,6,2,25,16,16,44,63,24,68,56,49,91,15,59,99,27,43,34,28,36,45,1,10,19,54,26,75,17,88,96,63,24,71,93,72,97,66,87,18,86],this.randomCache={},this.rndIndex=0}nextRandom(e){const{randomCache:t}=this;let n;return t[e]?n=t[e]:(n=this.random100.filter((t=>t<e)),t[e]=n),n[this.rndIndex++%n.length]}reset(){this.rndIndex=0}fromArray(e){return e[this.nextRandom(e.length)]}randomArray(e,t){const n=[],i=this.nextRandom(t+1),r={};for(let t=0,s=this.nextRandom(e.length);t<i;t++){for(;r[s];)s=this.nextRandom(e.length);r[s]=!0,n.push(e[s])}return n}}Qu._$name="RandomGenerator";const eh=["Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.","Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.","Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.","Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui atione voluptatem sequi nesciunt.","Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.","Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?","Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"];class th{static reset(){this.rnd.reset(),this.rndTime.reset(),this.rndRating.reset()}static rnd=new Qu;static rndTime=new Qu;static rndRating=new Qu;static rndText=new Qu;static get cities(){return["Stockholm","Barcelona","Paris","Dubai","New York","San Francisco","Washington","Montreal"]}static get namesWithAvatars(){return["Adam","Amit","Angelo","Arcady","Arnold","Barbara","Celia","Chang","Dan","Daniel","Dave","david","Don","Doug","Emilia","George","Gloria","Henrik","Hitomi","James","Jane","Jenny","John","Jong","Karen","Kate","Lee","Linda","Lisa","Lola","Macy","Madison","Malik","Mark","Mary","Maxim","Melissa","Mike","Rob","Steve","Team","Theo"]}static get firstNames(){return["Mike","Linda","Don","Karen","Doug","Jenny","Daniel","Melissa","John","Jane","Theo","Lisa","Adam","Mary","Barbara","James","David"]}static get surNames(){return["McGregor","Ewans","Scott","Smith","Johnson","Adams","Williams","Brown","Jones","Miller","Davis","More","Wilson","Taylor","Anderson","Thomas","Jackson"]}static get teams(){return["Lions","Eagles","Tigers","Horses","Dogs","Cats","Panthers","Rats","Ducks","Cougars","Hens","Roosters"]}static get foods(){return["Pancake","Burger","Fish n chips","Carbonara","Taco","Salad","Bolognese","Mac n cheese","Waffles"]}static get colors(){return["Blue","Green","Red","Yellow","Pink","Purple","Orange","Teal","Black"]}static get skills(){return["JavaScript","CSS","TypeScript","React","Vue","Angular","Java","PHP","Python","C#","C++","BASIC","COBOL","FORTRAN","PASCAL","SQL"]}static get tasks(){return["Meetings","Documentation","Email communication","Project management","Budgeting","Marketing and advertising","Customer service","Research and analysis","Data entry","IT support","Employee management","Sales and business development","Event planning","Graphic design","Writing and editing","Presentation","Travel arrangements and expense management","Training and development","Quality assurance","Customer support","Technical writing","Social media management","Translation","Legal research","Data analysis and visualization","Video editing and production","Network admin","Content creation","Market research","Public relations","Teaching and training","Recruiting","Product development"]}static generateName(){const{rnd:e,namesWithAvatars:t,surNames:n}=this;return`${e.fromArray(t)} ${e.fromArray(n)}`}static*generate(e,t=!1,n=1){let i,r;"object"==typeof e&&(t=e.randomHeight,n=e.initialId??1,i=e.addSkills,r=e.rowCallback,e=e.count);const{rnd:s,rndTime:o,rndRating:a,rndText:l,firstNames:c,surNames:d,teams:u,foods:h,colors:g,cities:m,skills:p}=this;for(let v=0;v<e;v++){var f;const y=s.fromArray(c),b=s.fromArray(d),C=`${y} ${String.fromCharCode(65+v%25)} ${b}`,S=s.nextRandom(60)+1,D=new Date(2019,0,S),w=new Date(2019,0,S+s.nextRandom(30)+2),E={id:n>-1?v+n:void 0,title:"Row "+v,name:C,firstName:y,surName:b,city:s.fromArray(m),team:s.fromArray(m)+" "+s.fromArray(u),age:10+s.nextRandom(80),food:s.fromArray(h),color:s.fromArray(g),score:10*s.nextRandom(100),rank:s.nextRandom(100)+1,start:D,finish:w,time:fr.getTime(o.nextRandom(24),5*o.nextRandom(12)),percent:s.nextRandom(100),done:s.nextRandom(100)<50,rating:a.nextRandom(5),active:S>30,relatedTo:Math.min(e-1,v+n+s.nextRandom(10)),notes:eh[l.nextRandom(7)+1]};i&&(E.skills=s.randomArray(p,"number"==typeof i?i:7));const R=null===(f=r)||void 0===f?void 0:f(E);R&&Object.assign(E,R),t&&(E.rowHeight=5*s.nextRandom(!0===t?20:t)+20),yield E}}static generateData(e,t=!1,n=1,i=!0){let r=e;"object"!=typeof e&&(r={count:e,randomHeight:t,initialId:n,reset:i}),!1!==r.reset&&this.reset(),th.overrideRowCount&&(r.count=th.overrideRowCount);const s=[],o=this.generate(r);for(let e=0;e<r.count;e++)s.push(o.next().value);return s}static generateEvents({viewStartDate:e,viewEndDate:t,nbrResources:n=50,nbrEvents:i=5,dependencies:r,tickUnit:s="days",minDuration:o=2,maxDuration:a=10,gap:l=1,eventCallback:c}){const d=this.generateData(n),u=[];let h,g;r=[];for(let t=0;t<=n;t++)for(let n=0;n<=i;n++){const i=Math.round(Math.random()*(a-1-o))+o,d=u.length+1;h=0===n?fr.add(e,Math.round(3*Math.random())*l,s):fr.add(g,l,s),g=fr.add(h,i,s),u.push({id:d,name:this.tasks[(t+n)%(this.tasks.length-1)],startDate:h,duration:i,endDate:g,resourceId:t}),null==c||c(u[u.length-1]),r&&t>0&&r.push({id:r.length+1,from:d-1,to:d})}return{resources:d,events:u,dependencies:r}}static generateOneEventPerTickAndResource({startDate:e,endDate:t,nbrResources:n=50,tickUnit:i="days"}){const r=this.generateData(n),s=[],o=fr.getDurationInUnit(e,t,i);for(let t=0;t<=n;t++)for(let n=0;n<o;n++)s.push({id:s.length+1,resourceId:t,name:this.tasks[(t+n)%(this.tasks.length-1)],startDate:fr.add(e,n,i),duration:1,durationUnit:i});return{resources:r,events:s}}static generateRow(){return th.generateData(1,!1,-1,!1)[0]}}th._$name="DataGenerator";const nh=["action","target","to","deltaX","deltaY","x","y","text"];class ih extends(at(Ir())){static get defaultConfig(){return{repeat:!0,outerElement:document.body,callOnFunctions:!0}}construct(e){super.construct(e);const t=this;t.widget&&(t.outerElement=t.widget.element,t.widget.playingDemo=!0),Xt.playingDemo=!0,Object.assign(t,{prevTarget:null,currentStep:0,mouse:Wn.createElement({parent:t.outerElement,tag:"div",className:"simulated-mouse"}),timeoutId:null,innerIntervalId:null,mouseOutElements:[]}),t.intervalId=t.setInterval(t.nextStep.bind(t),1e3),t.outerElement.classList.add("b-playing-demo"),t.outerElement.addEventListener("click",(e=>{e.isTrusted&&t.abort()}))}doDestroy(){this.abort()}abort(e=!1){const t=this;t.mouse.style.top="-100px",t.clearInterval(t.intervalId),t.timeoutId&&t.clearTimeout(t.timeoutId),t.innerIntervalId&&t.clearInterval(t.innerIntervalId),t.outerElement.classList.remove("b-playing-demo"),t.widget&&(t.widget.playingDemo=!1),Xt.playingDemo=!1,t.trigger(e?"done":"abort")}triggerEvent(e,t,n){if(!e)return null;let i;if(t.startsWith("mouse")){const e=this.mouse.getBoundingClientRect();i=new MouseEvent(t,Object.assign({view:globalThis,bubbles:!0,cancelable:!0,clientX:e.left,clientY:e.top},n||{}))}else i=document.createEvent("Event"),i.initEvent(t,!0,!1);return e.dispatchEvent(i),i}handleMouseMove(e,t){const n=this,i=n.mouse;i.classList.add("quick"),n.mouseDown&&i.classList.add("drag");const r=Pt.from(i,n.outerElement),s=r.x,o=r.y;let a=0,l=0;if(e.to)if("string"==typeof e.to){const t=n.outerElement.querySelector(e.to);if(t){const e=Pt.from(t,n.outerElement),i=e.x+e.width/2,r=e.y+e.height/2;a=(i-s)/10,l=(r-o)/10}}else e.to.x?a=(e.to.x-s)/10:(a=e.to[0]/10,l=e.to[1]/10);else e.deltaX?a=e.deltaX/10:e.x&&(a=(e.x-s)/10);e.deltaY&&(l=e.deltaY/10);let c=0;n.innerIntervalId=n.setInterval((()=>{if(n.shouldPause)return;9==c++&&(clearInterval(n.innerIntervalId),e.then&&e.then());const t=s+a*c,r=o+l*c;i.style.left=t+"px",i.style.top=r+"px";const d=i.getBoundingClientRect(),u=d.left,h=d.top,g=Wn.elementFromPoint(u,h);g!==n.prevTarget&&(n.prevTarget&&(n.mouseOutElements.push(n.prevTarget),Wn.isDescendant(n.mouseOutElements[0],g)||(n.mouseOutElements.forEach((e=>n.triggerEvent(e,"mouseout"))),n.mouseOutElements.length=0)),n.prevTarget=g,n.triggerEvent(g,"mouseover")),n.triggerEvent(g,e.action,{clientX:u,clientY:h})}),50)}getTarget(e){const t=this,n=e.target;return n?"function"==typeof n?n(e):document.querySelector(n):t.prevTarget||t.outerElement}normalizeStep(e){if(e.action)return"function"==typeof e.action?e.action(e):e;if("function"==typeof e)return e(),e;for(const t in e)Object.hasOwnProperty.call(e,t)&&!nh.includes(t)&&(e.action=t.toLowerCase(),e.to=e[t]);return e.target||"string"!=typeof e.to&&"function"!=typeof e.to||(e.target=e.to),e}get isScrolling(){const e=this,t=e.outerElement.getBoundingClientRect(),n=e.lastTop&&t.top!==e.lastTop;return e.lastTop=t.top,n}get isInView(){const e=this.outerElement.getBoundingClientRect();return e.top<globalThis.innerHeight&&e.bottom>0}get shouldPause(){return!this.isInView||this.isScrolling||document.hidden||!document.hasFocus()}nextStep(){const e=this;if(e.shouldPause)return;if(e.currentStep===e.steps.length){if(!e.repeat)return e.abort(!0);e.currentStep=0}0===e.currentStep&&e.trigger("initialize");const t=e.mouse,n=e.normalizeStep(e.steps[e.currentStep++]),i=e.getTarget(n),r=n.action;if(i&&r)if(t.className="simulated-mouse","mousemove"===r)e.handleMouseMove(n,i);else{if(i!==e.prevTarget){const n=Pt.from(i,e.outerElement);t.style.left=n.x+n.width/2+"px",t.style.top=n.y+n.height/2+"px"}"mousedown"===r&&(e.mouseDown=!0),"mouseup"===r&&(e.mouseDown=!1),e.timeoutId=e.setTimeout((()=>{if(e.prevTarget=i,t.classList.add(r),"type"===r){const e=Tc.fromElement(i),t=n.text.split("|");e.value=t[1===t.length||e.value!=t[0]?0:1]}else e.triggerEvent(i,r)}),"type"===r?100:550)}}}ih._$name="DemoBot";const{defineProperty:rh}=Object,sh=Symbol("fencible"),oh=[],ah=e=>Array.from(new Set(e)),lh=e=>e?ah(H.split(e)):oh;var ch=e=>class extends(e||Pe){static $name="Fencible";static declarable=["fenced"];static setupFenced(e,t){const{fenced:n}=e,i=t.getInherited("fenced");let r,s,o,a,l;for(a in n)l=n[a],!0===l&&(l=a),W.isObject(l)||(l={all:l}),r=lh(l.all),s=lh(l.any),o=l.lock?lh(l.lock):ah(r.concat(s)),s=s.length?s:null,i[a]={any:s,all:r,lock:o}}construct(...e){const t=this,n=Object.getPrototypeOf(t),i=t.$meta.getInherited("fenced"),r=t[sh]={},s=e=>!r[e];return W.forEach(i,(({any:e,all:i,lock:o},a)=>{rh(t,a,{configurable:!0,value(...l){if(i.every(s)&&(!e||e.some(s))){let e;try{for(e of o)r[e]=(r[e]||0)+1;return n[a].apply(t,l)}finally{for(e of o)--r[e]}}}})})),super.construct(...e)}get widgetClass(){}};const{floor:dh,max:uh,min:hh}=Math;class gh extends(Pe.mixin(ch)){static configurable={owner:null,drift:null,overflow:null,pos:{value:null,default:0,$config:"lazy"},range:{value:null,$config:"lazy"},scrollSize:null};static fenced={sync:!0};get direction(){const{name:e}=this,{events:t,scrollStarted:n}=this.owner;let i,r,s,o=0;for(i=t.length;i-- >0&&(s=t[i][e],null==r||(o=r-s,!o));)r=s;return o||null==r||(o=r-n[e]),o}get drift(){return this._drift||0}get driftRange(){const{range:e}=this;return[e[0],uh(e[0],e[1]-this.scrollSize)]}get items(){var e;return null===(e=this.owner)||void 0===e?void 0:e.items}get safeZone(){const{drift:e,scrollSize:t}=this,n=dh(this.owner.safetyMargin*t);return[e+n,e+t-n]}get scroller(){var e;return null===(e=this.owner)||void 0===e||null===(e=e.client)||void 0===e?void 0:e.scrollable}get scrollLimit(){var e;return null===(e=this.owner)||void 0===e?void 0:e.scrollLimit}get vast(){const{range:e}=this;return!!e&&e[1]-e[0]>this.scrollSize}changePos(e){const{range:t}=this;return hh(uh(e||0,t[0]),t[1])}updatePos(e){this.sync({pos:e})}updateDrift(e){const t=this,{pos:n,range:i}=t,r=n-e;if(t.scrollPos===r){const e=new CustomEvent("scroll",{detail:"driftChange"});t.owner.scroller.element.dispatchEvent(e)}else i[0]<=n&&n<i[1]&&(t.scrollPos=r)}changeRange(e,t){const[n,i]=Array.isArray(e)?e:[0,e],r=[n||0,null==i?1/0:i];if(!t||r[0]!==t[0]||r[1]!==t[1])return r}updateRange(e){this.scrollSize=e[1]-e[0],this.sync({range:e})}changeScrollSize(e){return hh(e,this.scrollLimit)}snap(){const e=this,{direction:t,items:n,owner:i,pos:r,range:s}=e;let o,a,l,c;for(o of n)if([a,l]=e.getItemSpan(o),a<=r&&r<l){a<r?(c=t<0&&a>=s[0]?a:l,e.pos=c,i.watchForEnd()):i.scrolling=!1;break}}sync(e){const t=Object.assign(this,e),{_drift:n,range:i,vast:r}=t;if(i&&i[0]!==i[1]){let s,{pos:o}=t;const a=o<i[0]||o>=i[1];if((null==o||a)&&(o=i[1]<0?i[0]:hh(uh(0,i[0]),i[1])),r){const{driftRange:e,safeZone:i,scrollSize:r}=t;s=null==n||o<i[0]||o>i[1]?hh(uh(e[0],dh(o-r/2)),e[1]):n}else s=i[0];t.scroller.positionDirty=!0,t.overflow="hidden-scroll",t.drift=s,s!==n?a?(t.positionDirty=!1,t._pos=null,t.pos=o):t.positionDirty=!0:null!=(null==e?void 0:e.pos)?(t.scrollPos=o-s,t.positionDirty=!0):(t.positionDirty&&(t.positionDirty=!1,t._pos=null),t.pos=t.scrollPos+s),(null!=e&&e.range||s!==n)&&t.owner.syncItems()}else t.overflow="hidden"}toLogical(e){return e+this.drift}toPhysical(e){const t=e-this.drift;return t>=0&&t<this.scrollLimit?t:NaN}}gh.X=class extends gh{get name(){return"x"}get other(){var e;return null===(e=this.owner)||void 0===e?void 0:e.y}get scrollPos(){return this.scroller.x}set scrollPos(e){this.scroller.x=e}get scrollSize(){return this.scroller.scrollWidth}set scrollSize(e){super.scrollSize=e}getItemSpan(e){const t=e.$vxy,{x:n}=t;return[n,n+t.width]}updateScrollSize(e){this.scroller.scrollWidth=e}updateOverflow(e){this.scroller.overflowX=e}},gh.Y=class extends gh{get name(){return"y"}get other(){var e;return null===(e=this.owner)||void 0===e?void 0:e.x}get scrollPos(){return this.scroller.y}set scrollPos(e){this.scroller.y=e}get scrollSize(){return this.scroller.scrollHeight}set scrollSize(e){super.scrollSize=e}getItemSpan(e){const t=e.$vxy,{y:n}=t;return[n,n+t.height]}updateScrollSize(e){this.scroller.scrollHeight=e}updateOverflow(e){this.scroller.overflowY=e}},gh._$name="Axis";const mh="b-infinity-scroller",ph=Object.freeze({width:0,height:0}),fh=(e,t)=>{const n="v"+t;n in e||Object.defineProperty(e,n,{configurable:!0,get(){var e;return null===(e=this.$vxy)||void 0===e?void 0:e[t]},set(e){this.$vxy&&(this.$vxy[t]=e)}})};class vh extends Pe{static configurable={hidden:null,owner:null,widget:null};static prototypeProperties={_height:0,_width:0,_x:0,_y:0};get height(){return this.getDim("height")}get width(){return this.getDim("width")}get x(){return this._x}set x(e){this.moveTo(e)}get xy(){return[this._x,this._y]}set xy(e){this.moveTo(...e)}get y(){return this._y}set y(e){this.moveTo(null,e)}getDim(e){const t=this,{widget:n}=t,i="_"+e;return n?n.monitorResize?n[e]:t[i]||(t[i]=n[e]):0}moveTo(e,t){null!=e&&(this._x=e),null!=t&&(this._y=t),this.sync()}sync(){const e=this,{owner:t,widget:n}=e,{element:i}=n,r=t.x.toPhysical(e.x),s=t.y.toPhysical(e.y),o=isNaN(r+s);e.hidden=o,o?e.size=ph:i.style.transform=`translate(${r}px, ${s}px)`}updateHidden(e){var t;null===(t=this.widget)||void 0===t||null===(t=t.element)||void 0===t||t.classList.toggle("b-scroll-hidden",e)}updateWidget(e,t){null==t||t.element.classList.remove("b-infinity-scroller-item"),e&&(e.element.classList.add("b-infinity-scroller-item"),fh(e,"x"),fh(e,"y"),fh(e,"xy"))}}class yh extends(Pe.mixin(at)){static configurable={animate:"smooth",client:null,safetyMargin:.01,scroller:null,scrollIdle:8,scrolling:null,scrollLimit:{value:0,$config:"lazy"},snap:null,x:{},y:{}};get element(){var e;return null===(e=this.scroller)||void 0===e?void 0:e.element}get events(){return this._events||(this._events=[])}get items(){var e;return((null===(e=this.client)||void 0===e?void 0:e.items)||[]).filter((e=>e.$vxy))}get lastEvent(){var e;return null===(e=this._events)||void 0===e?void 0:e[this._events.length-1]}get pos(){return[this.x.pos,this.y.pos]}changeScrollLimit(e){return e||Wn.scrollLimit}updateAnimate(e,t){var n;const i=null===(n=this.element)||void 0===n?void 0:n.classList;t&&(null==i||i.remove(`b-infinity-scroller-${t}`)),e&&(null==i||i.add(`b-infinity-scroller-${e}`))}updateClient(e){this.scroller=(null==e?void 0:e.scrollable)||null}updateScroller(e,t){var n;this.detachListeners("scroller"),null==t||null===(n=t.element)||void 0===n||n.classList.remove(mh),e&&(e.element.classList.add(mh),e.ion({thisObj:this,name:"scroller",scroll:"onInternalScroll"}))}changeX(e){return gh.X.new(e,{owner:this})}changeY(e){return gh.Y.new(e,{owner:this})}onInternalScroll(e){const t=this,{lastPos:n,scrolling:i}=t;i||(t.scrolling="maybe"),t.sync();const r=[t.x.pos,t.y.pos];n&&n[0]===r[0]&&n[1]===r[1]?t.scrolling=i:(t.lastPos=r,t.pushEvent(e),i||(t.scrolling=!0),t.triggerScroll("scroll",e))}onInternalScrollEnd(){const e=this,{scrolling:t}=e;t&&("snap"===t?e.updateScrolling(t):e.scrolling=!!e.snap&&"snap")}pushEvent(e){const t=this,{events:n}=t,i={event:e,x:t.x.pos,y:t.y.pos},r=n[n.length-1];if(e.type===(null==r?void 0:r.event.type)&&r.x===i.x&&r.y===i.y)r.event=e;else for(r||(t.scrollStarted=i),n.push(i);n.length>3;)n.shift()}scrollTo(e){const t=this,{scrollingTo:n}=t,i=t.x.pos,r=t.y.pos,s=(null==e?void 0:e.x)??(i+(null==e?void 0:e.dx)||0),o=(null==e?void 0:e.y)??(r+(null==e?void 0:e.dy)||0),a=s-i,l=o-r,c=a||l,d=!1!==(null==e?void 0:e.animate)&&null!==(null==e?void 0:e.animate);if(n){if(n.scroll.x===s&&n.scroll.y===o&&n.scroll.animate===d)return n.promise;n.finish()}const u=t.scrollingTo=il.new();return u.scroll={x:s,y:o,animate:d},c&&t.unanimated(!d,(()=>{a&&(t.x.pos=s),l&&(t.y.pos=o)})),c&&d?(u.cancel=t.ion({once:!0,scrollEnd(){u.resolve(t.x.pos===s&&t.y.pos===o)}}),u.finish=()=>{u.cancel&&(u.cancel(),u.cancel=null,u.resolve(!1),t.scrollStarted=null)}):u.resolve(!0),u.finally((()=>{t.scrollingTo===u&&(t.scrollingTo=null)})),u.promise}suppressAnim(e){const t=this,n=t._suppressAnim||0,i=t._suppressAnim=Math.max(0,n+(e?1:-1));t.scroller.behavior=i?"instant":null}sync(){this.unanimated((()=>{this.x.sync(),this.y.sync()}))}syncItems(){for(const e of this.items)e.$vxy.sync()}triggerScroll(e,t,n=this.x.pos,i=this.y.pos){this.trigger(e,{widget:this.client,relatedEvent:t,x:n,y:i})}updateScrolling(e,t){const n=this,i="maybe"===t,{lastEvent:r}=n;e?i?(n.watchForEnd(),n.scrollEnded=null,n.triggerScroll("scrollStart",r.event,r.x,r.y),n.element.classList.add("b-scrolling")):"snap"===e&&n[n.snap].snap():!t||"driftChange"!==(null==r?void 0:r.event.detail)&&i||(n.scrollEnded=r,n.events.length=0,n.triggerScroll("scrollEnd",r.event,r.x,r.y),n.element.classList.remove("b-scrolling"))}unanimated(e,t){if("function"==typeof e&&(t=e,e=!0),e){this.suppressAnim(!0);try{t()}finally{this.suppressAnim(!1)}}else t()}virtualize(e){"string"==typeof e&&(e=this.client.widgetMap[e]);let t=e.$vxy;var n;t&&t.owner===this||(null===(n=t)||void 0===n||n.destroy(),e.$vxy=t=new vh({owner:this,widget:e}));return t}watchForEnd(){const e=this,{client:t,scrollIdle:n,scrollStarted:i}=e;let r,s,o=0;!function a(){if(!e.isDestroyed&&!t.isDestroyed&&i===e.scrollStarted){if(s=e.pos,r&&r[0]===s[0]&&r[1]===s[1]){if(++o>=n&&!ti.hasActiveTouches)return void e.onInternalScrollEnd()}else r=s,o=0;t.requestAnimationFrame(a)}}()}}yh._$name="InfinityScroller";var bh=e=>class extends e{static configurable={animate:"smooth",infinityScroller:{value:{},$config:"lazy"},monitorResize:!0,scrollable:{}};static delayable={syncSoon:"raf"};get infinityScrollerDefaults(){return{animate:this.animate}}compose(){return{}}changeInfinityScroller(e,t){return t?t.setConfig(e):t=yh.new({client:this},this.infinityScrollerDefaults,e),t}onChildAdd(e){var t;return e.innerItem&&(null===(t=this._infinityScroller)||void 0===t||t.virtualize(e)),super.onChildAdd(e)}onInfiniteScroll(){this.syncSoon()}onInfiniteScrollEnd(){this.syncSoon.now()}onInfiniteScrollStart(){}onInternalResize(e,t,n,i,r){super.onInternalResize(e,t,n,i,r),this.hasPainted&&this.syncSoon()}onInternalPaint(e){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,e),e.firstPaint&&(this.syncSoon.now(),this.infinityScroller.ion({thisObj:this,scroll:"onInfiniteScroll",scrollStart:"onInfiniteScrollStart",scrollEnd:"onInfiniteScrollEnd"}))}get scrollingTo(){return this.infinityScroller.scrollingTo}scrollTo(e){return this.infinityScroller.scrollTo(e)}sync(){this.infinityScroller.sync()}syncSoon(){const e=this;e.isPainted&&(e.recompose.flush(),e.infinityScroller.animate=e.animate,e.sync())}unanimated(e,t){return this.infinityScroller.unanimated(e,t)}updateAnimation(){this._infinityScroller&&this.syncSoon()}get widgetClass(){}};class Ch extends(Pe.mixin(at,es)){static $name="Navigator";static type="navigator";static get configurable(){return{ownerCmp:null,itemsTabbable:null,target:null,keyEventTarget:null,processEvent:null,itemSelector:null,activeItem:null,focusCls:"b-active",keys:null,allowCtrlKey:null,allowShiftKey:null,scrollDuration:50,disabled:null,datasetIdProperty:"id",testConfig:{scrollDuration:1}}}static get factoryable(){return{defaultType:"navigator"}}get activeItem(){const{_activeItem:e}=this;if(this.target.contains(e))return e;this._activeItem=null}updateOwnerCmp(e){this.itemSelector||(this.itemSelector=`.${this.ownerCmp.itemCls}`),Wn.setAttributes(this.keyEventTarget,{"aria-activedescendant":`${this.owner.id}-active-descendant`})}set navigationEvent(e){const{owner:t}=this;this._navigationEvent=t.navigationEvent=e,e&&Promise.resolve(1).then((()=>this.navigationEvent=null))}get navigationEvent(){return this._navigationEvent}static getComposedKeyName(e){const t=(e.key||"").trim()||e.code;return`${e.ctrlKey?"CTRL+":""}${e.shiftKey?"SHIFT+":""}${e.altKey?"ALT+":""}${t}`}onKeyDown(e){const t=this,{ownerCmp:n,itemSelector:i,activeItem:r,itemsTabbable:s}=t,{target:o}=e,a=t.firstItem,l=(e.key||"").trim()||e.code,c=t.constructor.getComposedKeyName(e),d=o.matches(i)||o===t.keyEventTarget;if(!t.disabled&&t.processEvent&&(e=t.processEvent.call(n,e)),e&&!t.disabled&&a&&t.target.offsetParent&&d){if(!s){if(null==t.inlineFlow){const e=a.parentNode,n=Wn.getStyleValue(a,"position"),i=Wn.getStyleValue(a,"display"),r=Wn.getStyleValue(a,"float");t.inlineFlow="absolute"===n||"inline"===i||"inline-block"===i||"left"===r||"right"===r||"flex"===Wn.getStyleValue(e,"display")&&"row"===Wn.getStyleValue(e,"flex-direction")}t.prevKey||(t.inlineFlow?(t.prevKey="ArrowLeft",t.nextKey="ArrowRight"):(t.prevKey="ArrowUp",t.nextKey="ArrowDown"))}if(t.navigationEvent=e,r)switch(l){case t.prevKey:if(t.disabled||e.ctrlKey&&!t.allowCtrlKey)return;if(e.shiftKey&&!t.allowShiftKey)return;e.preventDefault(),e.handled=!0,t.navigatePrevious(e);break;case t.nextKey:if(t.disabled||e.ctrlKey&&!t.allowCtrlKey)return;if(e.shiftKey&&!t.allowShiftKey)return;e.preventDefault(),e.handled=!0,t.navigateNext(e);break;default:{var u;const i=null===(u=t.keys)||void 0===u?void 0:u[c];if(i&&!t.disabled){if(!1===t.callback(i,t.thisObj||n,[e]))return}else n.onInternalKeyDown&&n.onInternalKeyDown(e);if(Wn.getActiveElement(o)!==o&&e.preventDefault(),s)return}}else{if(s)return;l!==t.nextKey&&l!==t.prevKey||(t.activeItem=t.getDefaultNavigationItem(e))}t.activeItem!==r&&t.triggerNavigate(e)}}getDefaultNavigationItem(e){const{target:t,itemSelector:n,prevKey:i,nextKey:r}=this;return 4&t.compareDocumentPosition(e.target)&&e.key===i?t.querySelector(`${n}:last-of-type`):2&t.compareDocumentPosition(e.target)&&e.key===r?t.querySelector(`${n}`):void 0}navigatePrevious(e){const t=this,n=t.previous;e.preventDefault(),n&&t.ownerCmp.scrollable.scrollIntoView(n,{animate:t.scrollDuration}).then((()=>{t.activeItem=n,t.triggerNavigate(e)}))}navigateNext(e){const t=this,n=t.next;e.preventDefault(),n&&t.ownerCmp.scrollable.scrollIntoView(n,{animate:t.scrollDuration}).then((()=>{t.activeItem=n,t.triggerNavigate(e)}))}get owner(){return this.ownerCmp}get firstItem(){return this.target.querySelector(this.itemSelector)}get previous(){return this.getAdjacent(-1)}get next(){return this.getAdjacent(1)}getAdjacent(e=1,t=this.activeItem){const n=this.treeWalker;if(n.currentNode=t,n[e<0?"previousNode":"nextNode"](),n.currentNode!==this.activeItem)return n.currentNode}onTargetFocusIn(e){const t=this,{target:n,relatedTarget:i}=e,{owner:r,itemsTabbable:s,skipScrollIntoView:o,previousActiveItem:a}=t;if(!n.matches(".b-focus-trap"))if(n.matches(t.itemSelector))t.skipScrollIntoView=!0,t.activeItem=n,t.skipScrollIntoView=o,t.activeItem&&s&&t.triggerNavigate(e);else if(n===t.target){var l;if((i?n.compareDocumentPosition(i):0)&Node.DOCUMENT_POSITION_CONTAINED_BY)null===(l=r.previousSibling)||void 0===l||l.focus();else t.activeItem=a&&t.target.contains(a)?a:0}}onTargetFocusOut(e){const t=this,{relatedTarget:n}=e;null!=n&&n.matches(".b-focus-trap")||n&&t.target.contains(n)&&n.matches(t.itemSelector)||t.activeItem&&(t.activeItem=null,t.itemsTabbable&&t.triggerNavigate(e))}onTargetMouseDown(e){const t=this,n=e.target.closest(t.itemSelector);t.navigationEvent=e,t.itemsTabbable?n===t.activeItem&&t.triggerNavigate(e):!1===t.ownerCmp.itemsFocusable?t.onFocusGesture(e):n&&(e.preventDefault(),n.focus({preventScroll:!0}))}onTargetClick(e){var t;const n=this,{skipScrollIntoView:i}=n;n.skipNextClick||null!==(t=n.navigationEvent)&&void 0!==t&&t.ignoreNavigation?n.skipNextClick=!1:n.disabled||(n.skipScrollIntoView=!0,n.processEvent&&(e=n.processEvent.call(n.ownerCmp,e)),e&&(n.activeItem=e.target.closest(n.itemSelector),n.triggerNavigate(e)),n.skipScrollIntoView=i)}onFocusGesture(e){(e.target===this.ownerCmp.contentElement||e.target.closest(this.itemSelector)&&!1===this.ownerCmp.itemsFocusable)&&e.preventDefault()}acceptNode(e){return e.offsetParent&&e.matches&&e.matches(this.itemSelector)?Wn.NodeFilter.FILTER_ACCEPT:Wn.NodeFilter.FILTER_SKIP}changeActiveItem(e){return null!=e&&(this.ownerCmp.getItem?e=this.ownerCmp.getItem(e):"number"==typeof e&&(e=this.target.querySelector(this.itemSelector+`:nth-child(${e+1})`))),e}updateActiveItem(e,t){const n=this,{ownerCmp:i}=n,r=t&&n.target.contains(t),s=e&&Wn.isFocusable(e)&&e!==Wn.getActiveElement(e);if(r&&(n.previousActiveItem=t),t&&(t.classList.remove(n.focusCls),t.removeAttribute("id")),null!=e){var o;if(n.skipScrollIntoView)s&&e.focus({preventScroll:!0});else null===(o=i.scrollable)||void 0===o||o.scrollIntoView(e,{block:"nearest",focus:s,silent:n.scrollSilently});if(e===t&&r)return;e.classList.add(n.focusCls),e.id=`${n.owner.id}-active-descendant`,n._activeItem=e}else n._activeItem=null,t===Wn.getActiveElement(t)&&i.revertFocus()}updateTarget(e,t){const n=this,i={element:e,thisObj:n,focusin:"onTargetFocusIn",focusout:"onTargetFocusOut",mousedown:{handler:"onTargetMouseDown",delegate:n.itemSelector}};n.itemsTabbable||n.itemsFocusable||(i.click="onTargetClick"),Object.prototype.hasOwnProperty.call(n,"acceptNode")||(n.acceptNode=n.acceptNode.bind(n),n.acceptNode.acceptNode=n.acceptNode),Xt.on(i),n.treeWalker=n.setupTreeWalker(e,Wn.NodeFilter.SHOW_ELEMENT,n.acceptNode),n.keyEventTarget||(n.keyEventTarget=e),(n.targetMutationMonitor=new MutationObserver(n.onTargetChildListChange.bind(n))).observe(e,{childList:!0,subtree:!0})}setupTreeWalker(e,t,n){return document.createTreeWalker(e,t,n)}onTargetChildListChange(){const e=this,{activeItem:t,datasetIdProperty:n}=e;var i;t&&(e.target.contains(t)?t.classList.contains(e.focusCls)||t.classList.add(e.focusCls):e.activeItem=e.target.querySelector(`${e.itemSelector}.${e.focusCls}[data-${H.hyphenate(n)}="${t.dataset[n]}"]`)||(null===(i=e.target.querySelector(`${e.itemSelector}.${e.focusCls}`))||void 0===i?void 0:i[t.dataset.index])||null)}changeKeyEventTarget(e){this._keyEventTarget=e,Xt.on({element:e,keydown:"onKeyDown",thisObj:this})}triggerNavigate(e,t=this.activeItem){var n;const i={event:e,item:t,oldItem:this.previousActiveItem};this.trigger("navigate",i),null===(n=this.ownerCmp)||void 0===n||n.trigger("navigate",i)}}Ch._$name="Navigator";class Sh extends(Pe.mixin(at)){hasNativeAccess=!0;_content=null;async writeText(e,t){const n=this,{_content:i}=n;if(t&&n.hasNativeAccess)try{await navigator.clipboard.writeText(e)}catch(e){n.hasNativeAccess=!1}i!==e&&(n._content=e,n.triggerContentChange(i,!1,!0))}writeData(e,t){this._dataContent=e,this._contentSource=t}async readText(e){const t=this,{_content:n}=t;if(e&&t.hasNativeAccess)try{const e=await navigator.clipboard.readText();return n!==e&&(t._content=e,t._dataContent=t._contentSource=null,t.triggerContentChange(n,!0)),e}catch(e){t.hasNativeAccess=!1}return n}readData(e){if(!e||$e.asArray(e).includes(this._contentSource))return this._dataContent}triggerPaste(e){this.trigger("paste",{source:e,text:this._content})}triggerContentChange(e,t=!1,n=!1){this.trigger("contentChange",{fromRead:t,fromWrite:n,oldText:e,newText:this._content})}async clear(e){await this.writeText("",e),this.writeData(null)}}var Dh=e=>class extends(e||Pe){static $name="Clipboardable";static configurable={useNativeClipboard:!1,allowedDataSources:null};construct(...e){super.construct(...e),globalThis.bryntum.clipboard||(globalThis.bryntum.clipboard=new Sh),globalThis.bryntum.clipboard.ion({paste:"onClipboardPaste",contentChange:"onClipboardContentChange",thisObj:this})}get clipboard(){return globalThis.bryntum.clipboard}onClipboardPaste({text:e,source:t}){const n=this,{clipboardText:i,isCut:r}=n,s=n.compareClipboardText(i,e);var o;s&&r?(null===(o=n.handleCutData)||void 0===o||o.call(n,{text:e,source:t}),n.isCut=!1,n.cutData=null):s||n.clearClipboard(!1)}onClipboardContentChange({newText:e}){this.compareClipboardText(this.clipboardText,e)||this.clearClipboard(!1)}set cutData(e){var t,n;const i=this;null===(t=i._cutData)||void 0===t||t.forEach((e=>i.setIsCut(e,!1))),i._cutData=$e.asArray(e),null===(n=i._cutData)||void 0===n||n.forEach((e=>i.setIsCut(e,!0)))}get cutData(){return this._cutData}async writeToClipboard(e,t,n={}){if(!1===await this.beforeCopy({data:e,isCut:t,...n}))return;const i=this,r="string"==typeof e,s=r?e:i.stringConverter?i.stringConverter(e):H.safeJsonStringify(e),o=r?s:i.cloneData?i.cloneData({data:e,stringData:s,isPaste:!1}):W.clone(e);return i.clipboardText=s,i.clipboard.writeData(o,i.$$name),await i.clipboard.writeText(s,i.useNativeClipboard),i.clipboardData=o,i.originalData=e,i.isCut=t,i.cutData=t&&!r?e:null,{data:t?e:o,clonedData:o,originalData:e,stringData:s}}async readFromClipboard(e={},t=!1){var n;const i=this,{clipboard:r}=i,s=await r.readText(i.useNativeClipboard),o=i.compareClipboardText(i.clipboardText,s),a=o?i.originalData:[];let l=r.readData(i.allowedDataSources);o||i.clearClipboard(!1);const{isCut:c}=i;if(!c&&l&&l!==s||(l=i.transformClipboardText(s)),l&&!c&&"string"!=typeof l&&i.cloneData&&(l=i.cloneData({data:l,isPaste:!0})),!(null==l||Array.isArray(l)&&0===l.length||!1===await(null===(n=i.beforePaste)||void 0===n?void 0:n.call(i,{data:l,text:s,originalData:a,...e,isCut:c,isOwn:o}))))return t||r.triggerPaste(i),{data:l,text:s,isOwn:o,isCut:c,originalData:a}}async clearClipboard(e=!0){const t=this;t.clipboardData=t.originalData=t.clipboardText=t.cutData=null,t.isCut=!1,e&&await t.clipboard.clear(t.useNativeClipboard)}compareClipboardText(e,t){const n=/\r\n|(?!\r\n)[\n-\r\x85\u2028\u2029]/g;return(null==e?void 0:e.replace(n,"\n"))===(null==t?void 0:t.replace(n,"\n"))}transformClipboardText(e){const t=this;return t.compareClipboardText(t.clipboardText,e)?t.isCut?t.originalData:t.clipboardData:t.stringParser&&e?t.stringParser(e):e}hasClipboardData(){const{clipboard:e}=this,{_content:t}=e;if(!this.useNativeClipboard||!e.hasNativeAccess)return Boolean(t&&this.transformClipboardText(t))}},wh=e=>class extends(e||Pe){static $name="Finalizable";construct(...e){super.construct(...e),this.finalizer=null,this.finalizing=null,this.isFinalized=!1,this.isFinalizing=!1}doFinalize(){this.destroy()}finalize(){const e=this;let t=e.finalizing;return t||e.isFinalized||(e.isFinalizing=!0,e.finalizing=t=e._awaitFinalizer()),t}async _awaitFinalizer(){const e=this;try{await e.finalizer}finally{e.finalizing=null,e.isFinalized=!0,e.doFinalize()}}};const Eh=Symbol("dragAbort"),Rh=Symbol("dragInit"),xh=Symbol("dragDrag"),Th=Symbol("dragDrop"),Mh={x:"horizontal",y:"vertical"};class Ih extends(Pe.mixin(wh,Ir,Vr)){static $name="DragContext";static get configurable(){return{itemElement:null,scrollManager:null,monitoringConfig:null,source:null,target:null,targetElement:null,threshold:5,touchStartDelay:300,event:null}}static get identifiable(){return{}}construct(...e){super.construct(...e);const t=this,{event:n}=t;Object.assign(t,{altKey:null,cleaners:[],ctrlKey:null,data:new Map,element:n.target,endEvent:null,lastMoveEvent:null,metaKey:null,previousTarget:null,scrollerAction:null,shiftKey:null,state:Rh,startEvent:n,touchStartTimer:null,_valid:!0}),"touches"in n&&t.touchStartDelay&&(t.touchStartTimer=t.setTimeout((()=>t.touchStartTimer=null),t.touchStartDelay,"touchStartDelay"));const i=globalThis;Xt.on({element:i,blur:"onWindowBlur",thisObj:t,autoDetach:!0})}doDestroy(){const e=this,{source:t,target:n}=e;e.cleanup(),(null==n?void 0:n.dropping)===e&&(n.dropping=null),(null==t?void 0:t.dragging)===e&&(t.dragging=null),super.doDestroy()}onWindowBlur(){this.started&&!this.completed&&this.abort()}get aborted(){return this.state===Eh}get completed(){return this.isDestroying||this.aborted||null!==this.endEvent}get pending(){return this.state===Rh}get started(){return this.state!==Rh&&!this.aborted}get valid(){return this.started&&null!=this.targetElement&&this._valid}set valid(e){this._valid=e}async get(e){if(this.aborted)throw new Error("Data is not available on aborted drag");if(!this.completed)throw new Error("Data is not available until drag completion");if(Array.isArray(e))return Promise.all(e.map((e=>this.get(e))));let t=this.data.get(e);return"function"==typeof t&&(t=await t(),this.data.set(e,t)),t}has(e){return this.data.has(e)}peek(e){if(this.aborted)throw new Error("Data is not available on aborted drag");if(Array.isArray(e))return e.map((e=>this.peek(e)));let t=this.data.get(e);return"function"==typeof t&&(t=!0),t}set(e,t){this.data.set(e,t)}changeTarget(e,t){if(e!==t){const n=this;n._target=e,n.previousTarget=t,t&&(t.dropping=null),e&&(e.dropping=n,e.dropping!==n&&(e=null,n.valid=!1)),n._target=t}return e}updateTarget(e,t){const n=this;t&&n.source.dragLeaveTarget(n,t),e&&(n.valid=!0,e.dragMove(n),n.source.dragEnterTarget(n))}updateTargetElement(e){let t,n,i,r,s;for(s=e;s;s=s.parentElement)if(n=Cl.get(s,"droppables"),n)for(r=0;r<n.length;++r)if(t=n[r],t.dropRootElement.contains(e)&&(i=t.droppableSelector,(!i||e.closest(`#${Wn.getId(t.dropRootElement)} ${i}`))&&(this.target=t,this.target===t)))return}abort(){const e=this,{element:t,source:n}=e;null==t||t.getBoundingClientRect(),e.state!==Th&&(e.state=Eh,e.cleanup()),null==n||n.endDrag(e)}begin(){const e=this,{source:t}=e,n=t.beforeDrag(e);return!1!==n&&(t.dragging=e),n}cleanup(){let e;for(;e=this.cleaners.pop();)e()}end(e){const t=this,{lastMoveEvent:n,target:i}=t,{dragSwallowClickTime:r}=t.source;if(t.event=t.domEvent=t.endEvent=e,t.syncFlags(),t.started){if((null==n?void 0:n.clientX)===e.clientX&&(null==n?void 0:n.clientY)===e.clientY&&(null==n?void 0:n.target)===e.target||t.track(),r){const e=globalThis;Xt.on({element:e,capture:!0,expires:r,once:!0,click(e){e.stopPropagation()}})}t.state=Th,i!==t.source&&(null==i||i.dragDrop(t))}}fakeKey(e,t){const n=this,{lastMoveEvent:i}=n;if(i&&n.element){let r;i.isKey=!0,"Alt"===e.key?n.altKey!==t&&(n.altKey=t,r=!0):"Control"===e.key&&n.ctrlKey!==t&&(n.ctrlKey=t,r=!0),r&&(n.event=n.domEvent=i,n.track())}}keyDown(e){this.completed||("Escape"===e.key?this.abort():this.isDragToggleKey(e.key)&&this.fakeKey(e,!0))}keyUp(e){!this.completed&&this.isDragToggleKey(e.key)&&this.fakeKey(e,!1)}getDistance(e){return Xt.getDistanceBetween(this.startEvent,e)}isDragToggleKey(e){return"Control"===e||"Alt"===e}move(e){const t=this,{target:n}=e,i=t.getDistance(e)>=t.threshold;if(t.syncFlags(),t.touchStartTimer)i&&t.abort();else if(n&&n.nodeType===Node.ELEMENT_NODE&&n.isConnected){if(i&&!t.started&&(t.event=t.domEvent=e,!1===t.start()))return void t.abort();e.touches&&(t.startEvent.preventDefault(),e.preventDefault(),e.stopPropagation()),t.started&&!t.completed&&(t.lastMoveEvent=t.event=t.domEvent=e,"touchmove"===e.type&&(e.preventDefault(),e.stopImmediatePropagation()),t.track())}}start(){const e=this,{scrollManager:t,monitoringConfig:n,source:i}=e,{draggingBodyCls:r,dragLock:s}=i,o=i.dragRootElement;if(e.state=xh,t){const i=t.startMonitoring(b.merge({scrollables:[{element:o}],direction:Mh[s]||s||"both",callback(t){const{lastMoveEvent:n}=e;n&&e.element&&(n.isScroll=!0,e.event=e.domEvent=n,e.scrollerAction=t,e.track(),e.scrollerAction=null)}},n));e.cleaners.push(i)}const a=i.dragRootElement.closest(".b-outer")||document.body;if(a.classList.add(r),e.cleaners.push((()=>a.classList.remove(r))),!1===i.startDrag(e))return e.cleanup(),!1}syncFlags(){const e=this,{event:t}=e;e.altKey=t.altKey,e.ctrlKey=t.ctrlKey||t.metaKey,e.metaKey=t.metaKey,e.shiftKey=t.shiftKey}track(){const e=this,{event:t,source:n,target:i}=e;let r,s=t.target;"touchmove"===t.type&&(r=t.changedTouches[0],s=Wn.elementFromPoint(r.clientX,r.clientY)),e.targetElement=s,i===e.target&&(null==i||i.dragMove(e)),n.trackDrag(e)}}Ih.prototype.STATE=Ih.STATE=Object.freeze({ABORTED:Eh,INIT:Rh,DRAGGING:xh,DROPPED:Th}),Ih._$name="DragContext";class Ah extends(Pe.mixin(es)){static type="default";static get configurable(){return{dragging:null}}static get factoryable(){return{defaultType:Ah}}updateDragging(e,t){t&&this.close(t),e&&this.open(e)}close(e){}open(e){}dragStart(e){this.dragging=e}dragMove(e){}dragEnd(e){this.dragging=null}}Ah.initClass(),Ah._$name="DragProxy";var kh=e=>class extends(e||Pe){static $name="Draggable";static get configurable(){return{dragging:{$config:"nullify",value:null},draggingClsSelector:null,dragDocumentListeners:{element:document,keydown:"onDragKeyDown",keyup:"onDragKeyUp",contextmenu:"onDragContextMenu",mousemove:"onDragPointerMove",mouseup:"onDragPointerUp",pointerup:"onDragPointerUp",touchend:"onDragPointerUp",touchmove:{handler:"onDragPointerMove",passive:!1}},dragItemSelector:null,dragItemOverCls:null,dragLock:null,dragMinDistance:1,dragProxy:{$config:["lazy","nullify"],value:null},dragRootElement:{$config:"nullify",value:null},dragSameTargetDrop:!1,dragSelector:null,ignoreSelector:null,dragSwallowClickTime:50,dragThreshold:5,dragTouchStartDelay:300,dropTargetSelector:null,overItem:null,testConfig:{dragSwallowClickTime:50}}}static get properties(){return{draggingCls:"b-draggable-active",draggingBodyCls:"b-draghelper-active",draggingItemCls:"b-dragging-item",draggingStartedCls:"b-draggable-started",draggableCls:"b-draggable"}}beforeDrag(e){const{dragRootElement:t,dragSelector:n,ignoreSelector:i}=this,r=n&&e.element.closest(n);return!n||Boolean(r&&r===t||t.contains(r)&&(!i||!e.element.matches(i)))}dragStart(e){}dragOver(e){}dragEnterTarget(e){}dragLeaveTarget(e,t){}dragDrop(e){}dragEnd(e){}get activeDrag(){const{dragging:e}=this;return null!=e&&e.started&&!e.completed?e:null}get dragEventer(){return this.trigger?this:null}get draggingClassElement(){const{draggingClsSelector:e,dragRootElement:t}=this;return e?null==t?void 0:t.closest(e):t}beginDrag(e){const{draggingCls:t,draggingClassElement:n}=this;t&&n&&(n.classList.add(t),e.cleaners.push((()=>n.classList.remove(t))))}async endDrag(e){const t=this,{dragEventer:n,dragProxy:i}=t;e.valid&&await t.dragDrop(e),t.isDestroyed||(e.pending?e.destroy():(t.dragEnd(e),null==i||i.dragEnd(e),null==n||n.trigger(e.valid?"drop":"dragCancel",{drag:e,event:e.event}),t.finalizeDrag(e)))}async finalizeDrag(e){var t;await(null===(t=e.finalize)||void 0===t?void 0:t.call(e))}moveDrag(e){if(!1!==this.dragOver(e)){const{dragEventer:t,dragProxy:n}=this;null==n||n.dragMove(e),null==t||t.trigger("drag",{drag:e,event:e.event})}}setupDragContext(e){const t=this,{dragItemSelector:n,id:i}=t,{target:r}=e;return{event:e,id:i?`${i}-drag-${t._nextDragId=(t._nextDragId||0)+1}`:null,itemElement:n?r.closest(n):r,touchStartDelay:t.dragTouchStartDelay,source:t,threshold:t.dragThreshold}}startDrag(e){const{draggingStartedCls:t,draggingClassElement:n,draggingItemCls:i,dragEventer:r,dragProxy:s}=this,{itemElement:o}=e;if(!1===(null==r?void 0:r.trigger("beforeDragStart",{drag:e,event:e.event})))return!1;t&&n&&(n.classList.add(t),e.cleaners.push((()=>n.classList.remove(t)))),i&&o&&(o.classList.add(i),e.cleaners.push((()=>o.classList.remove(i)))),null==s||s.dragStart(e);const a=this.dragStart(e);return!1!==a&&(null==r||r.trigger("dragStart",{drag:e,event:e.event})),a}trackDrag(e){var t;const{dropTargetSelector:n}=this;e.valid=!(n&&(null===(t=e.targetElement)||void 0===t||!t.closest(n))),this.moveDrag(e)}configureListeners(e){const t=this,n=W.assign({thisObj:t},t.dragDocumentListeners);return"touches"in e.startEvent?(delete n.mousemove,delete n.mouseup):(delete n.contextmenu,delete n.touchmove,delete n.touchend,delete n.pointerup),n.element=Wn.getRootElement(t.dragRootElement),n}updateDragging(e,t){const n=this;if(e){const t=n.configureListeners(e);e.cleaners.push(Xt.on(t)),n.beginDrag(e)}else t&&t.destroy()}changeDragProxy(e,t){return Ah.reconfigure(t,e,{owner:this,defaults:{owner:this}})}updateDragRootElement(e,t){var n;const i=this,{draggableCls:r,dragItemSelector:s,onDragItemMouseMove:o}=i;if(null==t||t.classList.remove(r),null===(n=i._dragRootDetacher)||void 0===n||n.call(i),e){const t={thisObj:i,element:e,mousedown:"onDragMouseDown",touchstart:"onDragTouchStart",pointerdown:e=>{var t,n;return e.pointerId&&(null===(t=(n=e.target).releasePointerCapture)||void 0===t?void 0:t.call(n,e.pointerId))}};o&&(t.mousemove={delegate:s,handler:"onDragItemMouseMove"}),(i.dragItemOverCls||o||i.onDragItemMouseEnter||i.onDragItemMouseLeave)&&Object.assign(t,{mouseover:{delegate:s,handler:"onDragItemMouseOver"},mouseout:{delegate:s,handler:"onDragItemMouseOut"}}),e.classList.add(r),i._dragRootDetacher=Xt.on(t)}}onDragItemMouseOver(e){this.overItem=e}onDragItemMouseOut(e){this.dragging||(this.overItem=e)}changeOverItem(e){var t;return this.enterLeaveEvent=e,"mouseout"===e.type?(null===(t=e.relatedTarget)||void 0===t?void 0:t.closest(this.dragItemSelector))||null:e.target.closest(this.dragItemSelector)}updateOverItem(e,t){const n=this,{dragItemOverCls:i}=n;var r,s;t&&(i&&t.classList.remove(i),null===(r=n.onDragItemMouseLeave)||void 0===r||r.call(n,n.enterLeaveEvent,t));e&&(i&&e.classList.add(i),null===(s=n.onDragItemMouseEnter)||void 0===s||s.call(n,n.enterLeaveEvent,e))}onDragContextMenu(e){e.preventDefault()}onDragKeyDown(e){this.dragging.keyDown(e)}onDragKeyUp(e){this.dragging.keyUp(e)}onDragMouseDown(e){0===e.button&&this.onDragPointerDown(e)}onDragPointerDown(e){let{dragging:t}=this;t?t.isFinalizing||t.abort():(t=this.setupDragContext(e),t&&(t=new Ih(t),!1===t.begin()&&t.destroy()))}changeDragging(e,t){return null==t||t.destroy(),e}onDragPointerMove(e){const{changedTouches:t}=e,{dragging:n}=this;!n||n.completed||t&&1!==t.length||null==n||n.move(e)}onDragPointerUp(e){const{dragging:t}=this;t&&!t.completed&&(t.end(e),this.endDrag(t))}onDragTouchStart(e){1===e.touches.length&&this.onDragPointerDown(e)}},Fh=e=>class extends(e||Pe){static $name="Droppable";static get configurable(){return{droppableSelector:null,dropping:null,dropRootElement:{$config:"nullify",value:null}}}get dropEventer(){return this.trigger?this:null}get droppableCls(){return"b-droppable"}dragEnter(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("dragEnter",{drag:e,event:e.event})}dragMove(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("dragMove",{drag:e,event:e.event})}dragDrop(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("drop",{drag:e,event:e.event})}dragLeave(e){var t;return null===(t=this.dropEventer)||void 0===t?void 0:t.trigger("dragLeave",{drag:e,event:e.event})}changeDropping(e,t){if(e!==t){const n=this;t&&(!t.aborted&&t.completed||n.dragLeave(t)),e&&(n._dropping=e,!1===n.dragEnter(e)&&(e=null),n._dropping=t)}return e}updateDropRootElement(e,t){const n=this,{droppableCls:i}=n;let r,s,o;t&&(r=Cl.get(t,"droppables"),o=!0,Array.isArray(r)&&(s=r.indexOf(n))>-1&&(r.length<2?Cl.remove(t,"droppables"):(r.splice(s,1),r.forEach((e=>{i===e.droppableCls&&(o=!1)})))),o&&t.classList.remove(i)),e&&(r=Cl.get(e,"droppables"),r?r.push(n):Cl.set(e,"droppables",[n]),e.classList.add(i))}};const Ph="b-hover-edge",Oh="b-hover-top",Lh="b-hover-right",$h="b-hover-bottom",_h="b-hover-left",jh={[Ph]:1,[Oh]:1,[Lh]:1,[$h]:1,[_h]:1},Bh={t:[Ph,Oh],r:[Ph,Lh],b:[Ph,$h],l:[Ph,_h],tr:[Ph,Oh,Lh],bl:[Ph,$h,_h],tl:[Ph,Oh,_h],br:[Ph,$h,Lh]};var Hh=e=>class extends e{static $name="LoadMaskable";static get configurable(){return{loadMaskDefaults:{useTransition:!0,showDelay:1e3},loadMaskError:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},loadMask:{text:"L{GridBase.loadMask}"},syncMask:{text:"L{GridBase.syncMask}"},localizableProperties:["loadMask.text","syncMask.text"],testConfig:{loadMaskError:{icon:"b-icon b-icon-warning",autoClose:500,showDelay:0}}}}applyLoadMask(){const e=this,{loadMask:t}=e;return t&&(e.masked=Lc.mergeConfigs(e.loadMaskDefaults,t)),e.masked}applyMaskError(e){const{loadMaskError:t,masked:n}=this;return!1===t?n.hide():n&&(W.assign(n.errorDefaults,t),n.error=e),n}get widgetClass(){}};const Vh={constructor:1,prototype:1,name:1,length:1,arguments:1,caller:1,callee:1,__proto__:1};class zh{static apply(e){if(!e.target)throw new Error("Override must specify what it overrides, using static getter target");if(!e.target.class)throw new Error("Override must specify which class it overrides, using target.class");if(!this.shouldApplyOverride(e))return!1;const t=Object.getOwnPropertyNames(e),n=Object.getOwnPropertyNames(e.prototype);return t.splice(t.indexOf("target"),1),this.internalOverrideAll(e.target.class,t,e),this.internalOverrideAll(e.target.class.prototype,n,e.prototype),!0}static internalOverrideAll(e,t,n){Reflect.ownKeys(n).forEach((i=>{if(t.includes(i)&&!Vh[i]){const t=Object.getOwnPropertyDescriptor(n,i);let r=e,s=null;for(;!s&&r;)s=Object.getOwnPropertyDescriptor(r,i),s||(r=Object.getPrototypeOf(r));s&&this.internalOverride(r,i,t,s)}}))}static internalOverride(e,t,n,i){(e._overridden=e._overridden||{})[t]=e[t],i.get?Object.defineProperty(e,t,{enumerable:!1,configurable:!0,get:n.get}):e[t]=n.value}static shouldApplyOverride(e){const t=e.target;if(!t.maxVersion&&!t.minVersion)return!0;if(!t.product)throw new Error("Override must specify product when using versioning");return(!t.maxVersion||!G[t.product].isNewerThan(t.maxVersion))&&(!t.minVersion||!G[t.product].isOlderThan(t.minVersion))}}zh._$name="Override";const Nh=6e4,Wh=36e5,Uh=864e5,Gh=/(\d+)?:?(\d*)/;class Yh{static format(e){const t=Math.floor(e/Wh),n=Math.floor(e/Nh)%60;return`${t}:${n<10?"0":""}${n}`}static parse(e){const t=typeof e;if("string"===t){const t=Gh.exec(e);e=Number(t[1]||0)*Wh+Number(t[2]||0)*Nh}else"number"!==t?e=fr.getTimeOfDay(e):e<=24&&(e*=Wh);return Math.min(Math.max(Math.floor(e),0),Uh)}constructor(e){let t,n,i=0;null!=e&&e.isDayView?(i=e.dayStartShift,t=e.dayStartTime,n=e.dayEndTime):"number"==typeof e?i=t=n=e:e&&(i=e.startShift,t=e.timeStart,n=e.timeEnd),this.startShift=i=Yh.parse(i||0),this.timeEnd=(null==n?(i+Uh)%Uh:Yh.parse(n))||Uh,this.timeStart=null==t?i:Yh.parse(t)}get startHour(){return Math.floor(this.timeStart/Wh)}get endHour(){return Math.floor(this.timeEnd/Wh)}get startTimeOffsetMs(){const{startShift:e,timeStart:t}=this;return t<e?Uh-e+t:t-e}get today(){return this.startOfDay(new Date)}ceil(e){const t=this.startOfDay(e);return t<e&&t.setDate(t.getDate()+1),t}contains(e){return!this.outside(e)}dateKey(e){return e=this.shiftDate(e,-1),fr.makeKey(e)}dayOfDate(e){return this.shiftDate(fr.clearTime(e))}dayOfWeek(e){return(e=this.shiftDate(e,-1)).getDay()}delta(e,t="ms"){const{timeStart:n}=this,i=Yh.parse(e),r=(this.startShift&&i<n?i+Uh:i)-n;return"ms"===t?r:fr.as(t,r,"ms")}duration(e="ms"){const{timeStart:t,timeEnd:n}=this,i=t<n?n-t:Uh-t+n;return"ms"===e?i:fr.as(e,i,"ms")}equals(e){return this.startShift===(null==e?void 0:e.startShift)&&this.timeStart===e.timeStart&&this.timeEnd===e.timeEnd}intersects(e,t){const n=this,{timeStart:i,timeEnd:r}=n,[s,o]=n._dateRangeArgs(e,t),[a,l]=n.timeRange(s,o);return i<r?a<l?a<r&&i<=l:a<r||i<=l:!(a<l)||a<r||i<=l}isIntraDay(e,t){const[n,i]=this._dateRangeArgs(e,t),r=this.startOfDay(n),s=Uh-fr.diff(r,i,"ms");return!(s<0)&&(s>0||r<n)}isInterDay(e){return e.allDay||!this.isIntraDay(...arguments)}outside(e){const{startShift:t,timeStart:n,timeEnd:i}=this,r=Yh.parse(e);return n<i?r<n?r<t?1:-1:r<i?0:r<t?-1:1:r<i||r>=n?0:r<t?1:-1}parseKey(e){return this.dayOfDate(fr.parseKey(e))}shiftDate(e,t=1){const{startShift:n}=this,i=typeof e;return e="number"===i?new Date(e):"string"===i?fr.parse(e):new Date(e.getTime()),t&&n&&e.setMilliseconds(t>0?n:-n),e}sortEvents(e,t){const n=this.startOfDay(e);return null==t?void 0:t.sort(((e,t)=>{e=e.eventRecord||e,t=t.eventRecord||t;let{startDate:i}=e,{startDate:r}=t;return i?r?(i=i<n?n:i,r=r<n?n:r,i-r||t.endDate-r-(e.endDate-i)):1:-1}))}startOfDay(e){return e=this.shiftDate(e,-1),e=fr.clearTime(e),e=this.shiftDate(e)}timeRange(e,t){const[n,i]=this._dateRangeArgs(e,t);return[fr.getTimeOfDay(n),fr.getTimeOfDay(i)]}toString(){const{startShift:e,timeEnd:t,timeStart:n}=this,i=e?`@${Yh.format(e)}`:"",r=Yh.format(n);return n===t?e?i:r:`${r}-${Yh.format(t)}${i}`}_dateRangeArgs(e,t){return e.isModel?[e.startDate,e.endingDate]:[e,t]}}Yh.MIDNIGHT=new Yh({startShift:0,timeStart:0,timeEnd:24}),Yh.MILLIS_PER_MINUTE=Nh,Yh.MILLIS_PER_HOUR=Wh,Yh.MILLIS_PER_DAY=Uh,Yh._$name="DayTime";class qh extends(at(Pe)){static $name="Month";static get configurable(){return{date:{$config:{equal:"date"},value:fr.clearTime(new Date)},month:null,year:null,weekStartDay:null,hideNonWorkingDays:null,nonWorkingDays:null,sixWeeks:null}}configure(e){super.configure(e),this.updateDayNumbers(),e.date&&(this.date=e.date),this.generation=0}changeDate(e){if(!this.isConfiguring){if(e="string"==typeof e?fr.parse(e,"YYYY-MM-DD"):new Date(e),isNaN(e))throw new Error("Month date ingestion must be passed a Date, or a valid YYYY-MM-DD date string");return e}}updateDate(e,t){const n=this,{dayColumnIndex:i,weekCount:r}=n,s=fr.getFirstDateOfMonth(e),o=fr.getLastDateOfMonth(s),a=i[s.getDay()],l=i[o.getDay()],c=!t||e.getFullYear()!==t.getFullYear(),d=!t||e.getMonth()!==t.getMonth(),u=n.eventListeners&&(t?e.getDate()!==t.getDate()|(n.getWeekId(e)!==n.getWeekId(t))<<1|d<<2|c<<3:15);if(n._year=e.getFullYear(),n._month=e.getMonth(),n.startDayOfMonth=1-a,n.endDayOfMonth=o.getDate()+(6-l),n.sixWeeks&&(n.endDayOfMonth+=7*(6-n.weekCount)),n.weekBase&&!c||n.calculateWeekBase(),(d||c)&&n.generation++,u){const i={newDate:e,oldDate:t,changes:{d:!0,w:Boolean(2&u),m:Boolean(12&u),y:Boolean(8&u),r:n.weekCount!==r}};n.trigger("dateChange",i),2&u&&n.trigger("weekChange",i),12&u&&n.trigger("monthChange",i),8&u&&n.trigger("yearChange",i)}}calculateWeekBase(){const e=this,{dayColumnIndex:t}=e,n=new Date(e.year,0,1),i=new Date(e.year,11,31),r=e.month?e.getOtherMonth(n):e;e.dayColumnIndex[n.getDay()]>3?e.weekBase=r.startDate:e.weekBase=new Date(e.year,0,r.startDayOfMonth-7);const s=Math.floor(fr.diff(e.weekBase,i,"day")/7);e.has53weeks=53===s&&t[i.getDay()]>2}getWeekStart(e){if("number"==typeof e)return fr.add(this.weekBase,7*Math.max(e,1),"day");const t=this,[n,i]=e;return n===t.year?t.getWeekStart(i):t.getOtherMonth(new Date(n,0,1)).getWeekStart(i)}getOtherMonth(e){const t=this,n=t===Kh?new qh(null):Kh;return n.configure({weekBase:null,weekStartDay:t.weekStartDay,nonWorkingDays:t.nonWorkingDays,hideNonWorkingDays:t.hideNonWorkingDays,sixWeeks:t.sixWeeks,date:new Date(e.getFullYear(),0,1)}),n.date=e,n.updateDate(n.date,n.date),n}changeYear(e){const t=new Date(this.date);t.setFullYear(e),this.date=t}changeMonth(e){const t=new Date(this.date);t.setMonth(e),this.date=t}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:fr.weekStartDay}updateWeekStartDay(){const e=this;e.updateDayNumbers(),!e.isConfiguring&&e.date&&(e.weekBase=null,e.updateDate(e.date,e.date))}get nonWorkingDays(){return this._nonWorkingDays||fr.nonWorkingDays}changeNonWorkingDays(e){return W.assign({},e)}updateNonWorkingDays(){this.updateDayNumbers()}updateHideNonWorkingDays(){this.updateDayNumbers()}updateSixWeeks(){this.isConfiguring||this.updateDate(this.date,this.date)}get dayCount(){return this.endDayOfMonth+1-this.startDayOfMonth}get weekCount(){return this.dayCount/7}get startDate(){const e=this;if(null!=e.year&&null!=e.month&&null!=e.startDayOfMonth)return new Date(e.year,e.month,e.startDayOfMonth)}get endDate(){const e=this;if(null!=e.year&&null!=e.month&&null!=e.startDayOfMonth)return new Date(e.year,e.month,e.endDayOfMonth)}eachDay(e){for(let t=this.startDayOfMonth;t<=this.endDayOfMonth;t++)e(new Date(this.year,this.month,t))}eachWeek(e){const t=this,{weekCount:n}=t;for(let i=t.startDayOfMonth,r=0;r<n;r++){const n=[],r=t.getWeekNumber(new Date(t.year,t.month,i));for(let e=0;e<7;e++,i++)n.push(new Date(t.year,t.month,i));e(r,n)}}getWeekNumber(e){const t=this;if((e=fr.clearTime(e)).getFullYear()!==t.year)return t.getOtherMonth(new Date(e.getFullYear(),0,1)).getWeekNumber(e);let n=Math.floor(fr.diff(t.weekBase,e,"day")/7),i=e.getFullYear();return n?(53!==n||t.has53weeks?n>53&&(n%=52):(n=1,i++),[i,n]):t.getOtherMonth(new Date(t.year-1,0,1)).getWeekNumber(new Date(t.year,0,0))}getWeekId(e){const t=this.getWeekNumber(e);return 100*t[0]+t[1]}getCellData(e,t,n=Yh.MIDNIGHT){const i=this,r=e.getDay(),s=i.visibleDayColumnIndex[r],o=i.nonWorkingDays[r],a=i.hideNonWorkingDays&&o;return(e<i.startDate||e>i.endDate)&&(i.month=e.getMonth()),{day:r,dayTime:n,visibleColumnIndex:s,isNonWorking:o,week:i.getOtherMonth(e).getWeekNumber(e),key:fr.format(e,"YYYY-MM-DD"),columnIndex:i.dayColumnIndex[r],date:new Date(e),dayEnd:n.duration("s"),tomorrow:n.dayOfDate(fr.add(e,1,"day")),isOtherMonth:Math.sign(e.getMonth()+12*e.getFullYear()-(t.month+12*t.year)),visible:!a&&e>=t.startDate&&e<fr.add(t.endDate,1,"day"),isRowStart:0===s,isRowEnd:s===i.visibleColumnCount-1}}updateDayNumbers(){const e=this,{weekStartDay:t,nonWorkingDays:n,hideNonWorkingDays:i}=e,r=e.dayColumnIndex=[],s=e.canonicalDayNumbers=[],o=e.visibleDayColumnIndex=[];let a=0;for(let e=0;e<7;e++){const l=(t+e)%7;s[e]=l,r[l]=e,i&&n[l]||(o[l]=a++)}e.visibleColumnCount=a,e.weekLength=i?7-W.keys(n).length:7}}const Kh=new qh(null);qh._$name="Month";let Xh=0;const Zh=new WeakMap,Jh=e=>{const t=new Map;return(...n)=>{const i=((...e)=>e.map((e=>{let t;return e&&"object"==typeof e||"function"==typeof e?(t=Zh.get(e),void 0===t&&(t=++Xh,Zh.set(e,t))):t=String(e),t})).join("-"))(n);let r=t.get(i);return void 0===r&&(r=e(...n),t.set(i,r)),r}},Qh=e=>{const t=new Map,n=e=>e[0],i=e=>e[1],r=(e,t)=>n(e).push(t);return(s,o)=>{const a=(e=>{let n=t.get(e);return void 0===n&&(n=[[],[]],t.set(e,n)),n})(s);(e=>!i(e).length&&!n(e).length)(a)?(r(a,o),e(s,(e=>{((e,t)=>i(e).some((e=>W.isEqual(e,t))))(a,e)||(((e,t)=>{i(e).push(t)})(a,e),n(a).forEach((t=>t(e))))}))):(r(a,o),i(a).forEach((e=>o(e))))}},eg=Symbol("success"),tg=Symbol("failure"),ng=(e,t)=>[eg,e,t],ig=e=>[tg,e],rg=e=>e.length&&e[0]===eg,sg=e=>"function"!=typeof e||e.length?e:e(),og=Jh((e=>Qh(((t,n)=>n(ng(e,t)))))),ag=Jh((e=>Qh(((t,n)=>{const i=Math.min(e.length,t.length),r=t.substr(0,i),s=t.substr(i);n(r===e?ng(r,s):ig(s))})))),lg=(e,t)=>(n,i)=>sg(e)(n,(e=>{if(rg(e)){const[,n,r]=e;t(n)(r,i)}else i(e)})),cg=Jh(((...e)=>{const t=Jh(((e,t)=>Qh(lg(e,(e=>lg(t,(t=>og([].concat(e,t)))))))));return e.reduce(t,og([]))})),dg=Jh(((...e)=>Qh(((t,n)=>e.forEach((e=>sg(e)(t,n))))))),ug=Jh((e=>(t,n)=>{const i=new RegExp(`^${e}`).exec(t);if(i){const e=i[0],r=t.substr(e.length);n(ng(e,r))}else n(ig(t))})),hg=Jh(((e,t)=>lg(e,((...e)=>og(t(...[].concat.apply([],e))))))),gg=(e,t)=>{const n=[];return e(t,(e=>{if(rg(e)){const[,,t]=e;""===t&&n.push(e)}})),n};var mg={memo:Jh,memoCps:Qh,success:ng,failure:ig,isSuccess:rg,resolveParser:sg,succeed:og,string:ag,bind:lg,seq:cg,alt:dg,regexp:ug,red:hg,runParser:gg,defineParser:e=>(t,n)=>n?sg(e)(t,n):gg(sg(e),t)};class pg extends(Pe.mixin(Ir,at)){static get configurable(){return{element:null,zoneWidth:50,scrollSpeed:5,direction:"both",startScrollDelay:500,stopScrollWhenPointerOut:!1,testConfig:{scrollSpeed:2,startScrollDelay:100},activeScroll:{$config:["lazy"],value:{}},monitoring:{$config:["lazy","nullify"],value:!0},owner:null}}changeMonitoring(e,t){return null==t||t.clear(),new Map}doDestroy(){this.stopMonitoring(),super.doDestroy()}get isScrolling(){return 0!==Object.keys(this.activeScroll).length}get rtl(){var e;return null===(e=this.owner)||void 0===e?void 0:e.rtl}startMonitoring(e={}){const t=this,{element:n,direction:i}=t,{scrollables:r=[],direction:s=i,callback:o}=e,a=[];return r.length||r.push({element:n}),r.forEach((e=>{const i=e.element;"string"==typeof i?Wn.forEachSelector(n,i,(n=>{t.createMonitor(n,e.direction||s,e.callback||o),a.push(n)})):(t.createMonitor(i,e.direction||s,e.callback||o),a.push(i))})),function(){var e;null===(e=t.stopMonitoring)||void 0===e||e.call(t,a)}}createMonitor(e,t,n){const{monitoring:i}=this;i.has(e)||i.set(e,new fg({scrollManager:this,element:e,direction:t,callback:n}))}stopMonitoring(e){const t=this,{monitoring:n}=t;if(e=$e.asArray(e),n){if(!e)return void n.forEach((e=>t.stopMonitoring(e.element)));e.forEach((e=>{const t=n.get(e);e.classList.remove("b-scrolling"),t&&(t.destroy(),n.delete(e))}))}}requestScroll(e,t){const{activeScroll:n}=this;return(!(e in n)||n[e]===t)&&(n[e]=t,!0)}releaseScroll(e){const{activeScroll:t={}}=this;Object.keys(t).forEach((n=>{t[n]===e&&delete t[n]}))}getRelativeScroll(e,t="left"){let n=0;return this.monitoring.forEach(((i,r)=>{Wn.isDescendant(r,e)&&(n+="left"===t?i.scrollRelativeLeft:i.scrollRelativeTop)})),n}}class fg extends Pe{construct(e){const{element:t}=e,n=t.scrollLeft,i=t.scrollTop;Object.assign(e,{startScrollLeft:n,startScrollTop:i}),super.construct(e),Xt.on({element:t,scroll:"onElementScroll",pointermove:"onMouseMove",capture:!0,thisObj:this}),Xt.on({element:t,pointerleave:"onPointerLeave",thisObj:this})}doDestroy(){this.stopScroll(!0),super.doDestroy()}startScroll(){const e=this;e.pendingScrollFinalize&&(e.scrollManager.releaseScroll(e),e.pendingScrollFinalize=!1),e.scrolling=!0,e.performScroll()}stopScroll(e=null){const t=this,n=()=>{t.pendingScrollFinalize=!1,t.isDestroyed||(t.scrollManager.releaseScroll(t),t.scrolling=!1)};t.scrollRequested&&(t.scrollManager.cancelAnimationFrame(t.frameId),t.scrollRequested=!1),t.scrollManager.clearTimeout(t.scrollTimeout),t.scrollTimeout=null,e||!t.ongoingScrollTop&&!t.ongoingScrollLeft?(t.ongoingScrollTop=t.ongoingScrollLeft=null,n()):(t.pendingScrollFinalize=!0,Promise.all([t.ongoingScrollTop,t.ongoingScrollLeft].filter(Boolean)).then((()=>t.pendingScrollFinalize&&n())))}onPointerLeave(){this.scrollManager.stopScrollWhenPointerOut&&this.stopScroll()}onMouseMove(e){const t=this,{scrollManager:n}=t,i=t.element.getBoundingClientRect(),r=n.zoneWidth,s=n.scrollSpeed;if(t.scrollDeltaX=t.scrollDeltaY=0,"vertical"!==t.direction){const{scrollLeft:o,scrollWidth:a,clientWidth:l}=t.element;n.rtl?e.clientX<i.left+r&&a+o-l>=1?t.scrollDeltaX=-Math.round((r+(i.left-e.clientX))/s)-1:e.clientX>i.right-r&&o<0&&(t.scrollDeltaX=Math.round((r-(i.right-e.clientX))/s)+1):e.clientX>i.right-r&&a-o-l>=1?t.scrollDeltaX=Math.round((r-(i.right-e.clientX))/s)+1:e.clientX<i.left+r&&o>0&&(t.scrollDeltaX=-Math.round((r+(i.left-e.clientX))/s)-1)}if("horizontal"!==t.direction){const{scrollTop:n,scrollHeight:o,clientHeight:a}=t.element;e.clientY>i.bottom-r&&o-n-a>=1?t.scrollDeltaY=Math.round((r-(i.bottom-e.clientY))/s)+1:e.clientY<i.top+r&&n>0&&(t.scrollDeltaY=-Math.round((r+(i.top-e.clientY))/s)-1)}0===t.scrollDeltaX||n.requestScroll("horizontal",t)||(t.scrollDeltaX=0),0===t.scrollDeltaY||n.requestScroll("vertical",t)||(t.scrollDeltaY=0),0===t.scrollDeltaX&&0===t.scrollDeltaY?t.scrolling&&t.stopScroll():t.scrollTimeout||(t.scrollTimeout=n.setTimeout((()=>t.startScroll()),n.startScrollDelay))}performScroll(){const e=this,{element:t,scrollManager:n}=e;if(e.scrolling&&!e.scrollRequested){if(0!==e.scrollDeltaX){const i=t.scrollLeft,r=Math.min(i+e.scrollDeltaX,t.scrollWidth-t.clientWidth);t.scrollLeft=r,t.scrollLeft!==i?e.ongoingScrollLeft=new Promise((i=>t.addEventListener("scroll",(t=>{var r;null===(r=n.trigger)||void 0===r||r.call(n,"scroll",{event:t,deltaY:e.scrollDeltaY,deltaX:e.scrollDeltaX}),i()}),{once:!0}))):(e.ongoingScrollLeft=null,e.scrollDeltaX=0)}if(0!==e.scrollDeltaY){const i=t.scrollTop,r=Math.min(i+e.scrollDeltaY,t.scrollHeight-t.clientHeight);t.scrollTop=r,t.scrollTop!==i?e.ongoingScrollTop=new Promise((i=>t.addEventListener("scroll",(t=>{var r;null===(r=n.trigger)||void 0===r||r.call(n,"scroll",{event:t,deltaY:e.scrollDeltaY,deltaX:e.scrollDeltaX}),i()}),{once:!0}))):(e.ongoingScrollTop=null,e.scrollDeltaY=0)}0!==e.scrollDeltaX||0!==e.scrollDeltaY?(e.scrollRequested=!0,e.frameId=e.scrollManager.requestAnimationFrame((()=>{e.scrollRequested=!1,e.performScroll(e)}))):e.stopScroll()}}onElementScroll(){var e;null===(e=this.config)||void 0===e||null===(e=e.callback)||void 0===e||e.call(this.thisObj||this.scrollManager,this)}get scrollLeft(){return this.element.scrollLeft}get scrollTop(){return this.verticalElement?this.verticalElement.scrollTop:this.element.scrollTop}get scrollRelativeLeft(){return this.scrollLeft-this.startScrollLeft}get scrollRelativeTop(){return this.scrollTop-this.startScrollTop}getRelativeLeftScroll(e){return this.scrollManager.getRelativeScroll(e,"left")}getRelativeTopScroll(e){return this.scrollManager.getRelativeScroll(e,"top")}}pg._$name="ScrollManager";const vg={left:!0,right:!0,top:!0,bottom:!0,transform:!0},yg={true:1,false:1},bg=Promise.resolve();class Cg extends fu{static $name="Tooltip";static type="tooltip";static get configurable(){return{autoHide:!0,mouseOffsetX:15,mouseOffsetY:15,html:{$config:{equals:()=>!1}},getHtml:null,forElement:null,trackMouse:null,updateContentOnMouseMove:!1,forSelector:null,hideOnDelegateChange:null,anchorToTarget:!0,showOnHover:null,hoverDelay:500,autoShow:!1,dismissDelay:0,hideDelay:500,loadingMsg:"Loading...",allowOver:null,anchor:!0,align:{align:"b-t",minHeight:300},axisLock:!0,activeTarget:{$config:{equal:(e,t)=>null==e&&null==t||e===t},value:null},testConfig:{hideDelay:100,hoverDelay:100,showAnimation:null,hideAnimation:null},role:"tooltip",describedElement:null}}afterConfigure(){const e=this,{forSelector:t}=e;t&&(e.showOnHover=!1!==e.showOnHover,e.forElement||(e.anchorToTarget||(e.trackMouse=!0),e.forElement=e.rootElement.host||e.rootElement)),super.afterConfigure(),e.forElement&&e.showOnHover&&(e.pointerOverOutDetacher=Xt.on({element:e.forElement,pointerover:"internalOnPointerOver",pointerout:"internalOnPointerOut",thisObj:e}))}doDestroy(){var e;null===(e=this.pointerOverOutDetacher)||void 0===e||e.call(this),super.doDestroy()}set focusOnToFront(e){super.focusOnToFront=e}get focusOnToFront(){var e;return"focus"!==(null===(e=this.triggeredByEvent)||void 0===e?void 0:e.pointerType)&&(super.focusOnToFront&&Wn.usingKeyboard)}get focusElement(){const e=super.focusElement;if(e!==this.element)return e}get anchorToTarget(){return this._anchorToTarget&&!this.trackMouse}get anchor(){return super.anchor&&!this.trackMouse}set anchor(e){super.anchor=e}onDocumentMouseDown({event:e}){const t=this,{triggeredByEvent:n}=t;var i;if(n&&Wn.isTouchEvent&&(e.pageX===n.pageX&&e.pageY===n.pageY&&null!==(i=t.activeTarget)&&void 0!==i&&i.contains(e.target)&&performance.now()-n.timeStamp<500))return;t.abortDelayedShow(),super.onDocumentMouseDown({event:e})}internalOnPointerOver(e){const t=this,{target:n,relatedTarget:i}=e,{forElement:r,forSelector:s,activeTarget:o}=t;let a;if(!(t.disabled||t.owner&&!t.owner.showTooltipWhenDisabled&&t.owner.disabled||t.allowOver&&t.element.contains(n))){if(s){const r=e.target.closest("[data-btip]");if(r&&!r.matches(s))return void(o&&t.handleForElementOut());if(a=t.filterTarget(n),null!=o&&o.contains(n)&&o.contains(i)&&a===o)return;if(a&&(null==i?void 0:i.closest(s))===a&&!i.dataset.btip)return}else{if(r.contains(i))return;a=r}a?t.handleForElementOver(e,a):o&&t.handleForElementOut()}}filterTarget(e){return e.closest(this.forSelector)}realignOnTransitionEnd(e){const t=this,{currentOverElement:n}=Cg;if(vg[e.propertyName]){var i;if(t.allowOver&&t.element.contains(n))return;null!==(i=t.activeTarget)&&void 0!==i&&i.contains(n)&&!t.trackMouse&&t.realign()}}async handleForElementOver(e,t){const n=this,{activeTarget:i,hideOnDelegateChange:r,anchorToTarget:s}=n,o=t!==i,a=o&&r;if(!1===n.trigger("pointerOver",{event:e,target:t}))n.internalOnPointerOut(e);else{if(n.triggeredByEvent=e,n.hasTimeout("hide")&&(n.abortDelayedHide(),!o))return;if(!r&&n.element.classList.contains("b-hiding")&&n.cancelHideShowAnimation(),!n._hidden&&a&&n.hide(!1),n.activeTarget&&n.hasTimeout("show")&&n.clearTimeout("show"),n.activeTarget=t,n.isVisible){n.lastAlignSpec=null;const e=n.updateContent();if(b.isPromise(e)&&!n.loadingMsg&&await e,!1===n.trigger("beforeShow"))return n.hide();n.alignTo({[s?"target":"position"]:s?t:"mouse",overlap:!(s&&n.anchor)}),n.trigger("show"),n.afterShowByTarget()}else n.activeTarget=t,n.delayShow(t)}}async delayShow(e){var t;const n=this;if(null!==(t=n.currentAnimation)&&void 0!==t&&t.showing&&n.cancelHideShowAnimation(),n.isVisible||n.hasTimeout("show"))n.isVisible&&n.showByTarget(e);else if(!n.hoverDelay||n.forSelector&&Date.now()-n.lastHidden<n.quickShowInterval){const t=n.updateContent();b.isPromise(t)&&!n.loadingMsg&&await t,n.showByTarget(e)}else n.addDocumentMouseDownListener(),n.listeningForMouseMove||n.anchorToTarget||(n.mouseMoveRemover=Xt.on({element:n.rootElement,mousemove:"onMouseMove",thisObj:n})),n.setTimeout((async()=>{if(n.activeTarget===e&&e.isConnected){const t=n.updateContent();b.isPromise(t)&&!n.loadingMsg&&await t,n.showByTarget(e)}}),n.triggeredByEvent&&"pointerover"!==n.triggeredByEvent.type?0:n.hoverDelay,"show",!0)}changeAllowOver(e){return this.inAfterShow||(this.configuredAllowOver=e),e}updateAllowOver(e){const t=this,{element:n}=t;var i;(n.classList.toggle("b-allow-over",Boolean(e)),e)?t.allowOverlisteners=Xt.on({element:n,mouseenter:"onOwnElementMouseEnter",mouseleave:"internalOnPointerOut",thisObj:t}):null===(i=t.allowOverlisteners)||void 0===i||i.call(t)}updateContent(){const e=this;if(e.getHtml){const t=e.callback(e.getHtml,e,[{tip:e,element:e.element,activeTarget:e.activeTarget,event:e.triggeredByEvent}]);return e.html=t,t}}get hasContent(){return Boolean(Wn.isReactElement(this._html)||""!==this._html&&"string"==typeof this.html&&this.html.length||this.items.length)}internalBeforeShow(){return(this.updateContentOnMouseMove||this.hasContent)&&!this.disabled}showAsyncMessage(e=this.optionalL(this.loadingMsg)){e&&(this.html=`\n                <div class="b-tooltip-loading">\n                    <i class="b-icon b-icon-spinner"></i>\n                    ${H.encodeHtml(e)}\n                </div>\n            `)}showByTarget(e){var t;const n=this,{anchorToTarget:i}=n;n.mouseMoveRemover=null===(t=n.mouseMoveRemover)||void 0===t?void 0:t.call(n),n.showBy({[i?"target":"position"]:i?e:"mouse",overlap:!(i&&n.anchor)})}afterShowByTarget(){const e=this,{dismissDelay:t}=e;e.abortDelayedShow(),t&&e.setTimeout("hide",t),e.element.parentNode&&e.toFront(),e.mouseMoveRemover||!e.trackMouse&&!e.updateContentOnMouseMove||(e.mouseMoveRemover=Xt.on({element:e.rootElement,pointermove:"onMouseMove",thisObj:e})),e.inAfterShow=!0,e.allowOver=e.allowOver||0!=e.configuredAllowOver&&e.childItems.some((e=>e.isVisible&&!e.disabled&&e.focusElement)),e.inAfterShow=!1}updateActiveTarget(e,t){const n=this,i=Wn.getActiveElement(e);e?(n.isConfiguring||n.trigger("overTarget",{newTarget:e,lastTarget:t}),n.describedElement=e.contains(i)?i:null):(n.trigger("targetOut",{lastTarget:t}),n.describedElement=null)}updateDescribedElement(e,t){e&&Wn.addAttributeValue(e,"aria-describedby",this.id),t&&Wn.removeAttributeValue(t,"aria-describedby",this.id)}internalOnPointerOut(e){var t;const n=this,i="pointerover"===e.type?e.target:e.relatedTarget;n.allowOver&&(n.element.contains(i)||n.owns(i,!0))||n.element.contains(i)&&null!==(t=n.activeTarget)&&void 0!==t&&t.contains(i)||n.activeTarget&&!n.activeTarget.contains(i)&&n.handleForElementOut()}handleForElementOut(){const e=this,{hideDelay:t}=e;if(!1===e.trigger("pointerOut"))return e.activeTarget=null,!0;e.abortDelayedShow(),e.isVisible&&!1!==t&&(e.abortDelayedHide(),t>0?e.setTimeout("hide",t):e.hide())}show(e){const t=this;!e&&t.forElement&&t.anchorToTarget&&!t.forSelector?t.showByTarget(t.forElement):super.show(...arguments),t.isVisible?t.afterShowByTarget():t.activeTarget=null}get hoverDelay(){var e;return"focus"===(null===(e=this.triggeredByEvent)||void 0===e?void 0:e.pointerType)?0:this._hoverDelay}get hideDelay(){var e;return"focus"===(null===(e=this.triggeredByEvent)||void 0===e?void 0:e.pointerType)?0:!!this.autoHide&&this._hideDelay}hide(){const e=this;if(e.abortDelayedShow(),e._hidden)return bg;{var t,n;e.abortDelayedHide();const i=super.hide(...arguments);return e.lastHidden=Date.now(),e.activeTarget=null,null===(t=e.mouseMoveRemover)||void 0===t||t.call(e),e.mouseMoveRemover=null,null===(n=e.transitionEndDetacher)||void 0===n||n.call(e),e.transitionEndDetacher=null,i}}abortDelayedShow(){const e=this;var t,n,i;e.hasTimeout("show")&&(null===(t=e.mouseDownRemover)||void 0===t||t.call(e),e.mouseDownRemover=null,e.clearTimeout("show"),null===(n=e.mouseMoveRemover)||void 0===n||n.call(e),e.mouseMoveRemover=null,null===(i=e.transitionEndDetacher)||void 0===i||i.call(e),e.transitionEndDetacher=null)}abortDelayedHide(){this.clearTimeout("hide")}realign(){const e=this,t=e.lastAlignSpec;e.isConfiguring||e.isVisible||null==t||!t.targetOutOfView||(t.allowTargetOut||Wn.isInView(t.target,!1,e))&&(e.show(),t.targetOutOfView=!1),super.realign()}alignTo(e){const t=this,n=(t.mouseOffsetX||1)*(t.rtl?-1:1),i=t.mouseOffsetY||1,r=Math.max(Math.min(n,5),0),s=Math.max(Math.min(i,5),0);if(!t.isVisible)return;let o;t.anchorToTarget||"mouse"!==e.position||(o=new Ot(t.triggeredByEvent.pageX-globalThis.scrollX,t.triggeredByEvent.pageY-globalThis.scrollY),e.position=new Ot(o.x+(n||1)-(n<0?t.width:0),o.y+(i||1)-(i<0?t.height:0))),!e||t.triggeredByEvent&&t.element.contains(t.triggeredByEvent.target)||e.nodeType===Node.ELEMENT_NODE&&(e={target:e}),super.alignTo(e),o&&t.lastAlignSpec.result.inflate(s,r).contains(o)&&(t.lastAlignSpec.position="mouse",t.mouseOffsetY=-i,t.mouseOffsetX=-n,t.realign(),t.mouseOffsetY=i,t.mouseOffsetX=n)}set html(e){super.html=e,this.isVisible&&this.realign()}get html(){return super.html}changeHtml(e){const t=this;return b.isPromise(e)?(t.showAsyncMessage(),e.target=t.activeTarget,void e.then((n=>{e.target===t.activeTarget&&(t.html=n)}))):("object"!=typeof e&&(e=null!=e?t.optionalL(String(e)):""),e)}updateHtml(e,t){const n=this;let i=""===e;i||(super.updateHtml(e,t),n.hasContent?b.isPromise(e)||n.trigger("innerHtmlUpdate",{value:e}):i=!0),i&&n.hide()}onMouseMove(e){const t=this,{forElement:n,activeTarget:i}=t,r=t.hasTimeout("hide"),s=e.target;if(t.triggeredByEvent=e,!t._hidden){let o;const a=!(null==i?void 0:i.contains(s))&&t.forSelector&&i&&!r&&s.nodeType===Node.ELEMENT_NODE&&!s.matches(t.forSelector)&&!(t.allowOver&&t.element.contains(s)),l=null!=n&&n.document?n.document.documentElement:n,c=l&&(l.contains?l.contains(s):16&l.compareDocumentPosition(s));if(a&&(o=t.handleForElementOut()),o||!r||c){if(t.dismissDelay&&!r&&t.setTimeout("hide",t.dismissDelay),t.updateContentOnMouseMove&&t.getHtml&&(t.html=t.callback(t.getHtml,t,[{tip:t,element:t.element,forElement:i,event:e}]),!t.html))return void t.hide();t.trackMouse&&t.alignTo({position:"mouse",ignorePageScroll:!0})}}}onElementUserAction(e){const{showOnClick:t}=this;"number"==typeof t&&t!==e.button||(2===e.button&&e.preventDefault(),this.internalOnPointerOver(e))}onOwnElementMouseEnter(e){this.abortDelayedHide()}static getSharedTooltip(e,t,n){var i;let r=null===(i=t.bryntum)||void 0===i||null===(i=i.tooltip)||void 0===i?void 0:i.get(Cg);if(!r&&!n){var s;null!==(s=t.bryntum)&&void 0!==s&&s.tooltip||W.setPath(t,"bryntum.tooltip",new Map);const n=t.bryntum.tooltip;n.set(Cg,!0),r=new Cg({forElement:t,rootElement:e,forSelector:"[data-btip]",resetCfg:{},isSharedTooltip:!0,cls:"b-tooltip-shared",internalListeners:{pointerOver({source:e,target:t}){for(const t in e.resetCfg)"listeners"===t?e.un(e.resetCfg[t].set):"html"!==t&&(e[t]=e.resetCfg[t].was);e.resetCfg={};const n=Tc.getById(t.id),i=(null==n?void 0:n.tipConfig)||e.gatherDataConfigs(t.dataset);if(n&&n.element!==t||!n&&t.matches(".b-widget")||null!=n&&n.disabled&&!n.showTooltipWhenDisabled)return!1;e._owner=n,e.element.classList.toggle("b-target-disabled",Boolean(null==n?void 0:n.disabled));for(const t in i)e.resetCfg[t]={set:i[t],was:e[t]},"listeners"===t?e.ion(i[t]):e[t]=i[t]},hide({source:e}){e.owner=null}},gatherDataConfigs(e){const t=this,n={};for(const i in e)if(i.startsWith("btip"))if(i.length>4){const r=H.uncapitalize(i.substr(4));if(r in t.getDefaultConfiguration()){const t=e[i];n[r]=yg[t]?"true"===t:isNaN(t)?t:parseInt(t,10)}}else n.html=e[i];return n},filterTarget(e){const t=e.closest(this.forSelector);if(t)return t;if(Cg.showOverflow&&e.closest(".b-widget"))for(;(null===(n=e)||void 0===n?void 0:n.nodeType)===Element.ELEMENT_NODE;){var n;if("ellipsis"===Wn.getStyleValue(e,"text-overflow")&&e.clientWidth<e.scrollWidth)return this.html=H.encodeHtml(e.textContent),e;e=e.parentNode}}}),Xt.on({element:t,mouseenter:e=>Cg.currentOverElement=e.target,keydown:e=>Cg.currentOverElement=e.target,capture:!0,thisObj:r}),n.set(Cg,r)}return r}static encodeConfig(e){const t={};if("string"==typeof e)t.btip=e;else for(const n in e)t[`btip${"html"===n?"":H.capitalize(n)}`]=e[n];return t}}Cg.initClass(),Object.defineProperty(Tc,"tooltip",{get:()=>Cg.getSharedTooltip(document.body,document.body)}),Tc.Tooltip=Cg,Cg._$name="Tooltip";class Sg extends Ah{static type="tip";static get configurable(){return{align:"t10-b50",offset:20,tooltip:{$config:["lazy","nullify"],value:{type:"tooltip"}}}}open(){this.getConfig("tooltip")}close(){var e;null===(e=this.tooltip)||void 0===e||e.hide()}dragMove(e){const{offset:t,tooltip:n}=this,{event:i}=e;n&&(n.isVisible||n.show(),n.alignTo({align:this.align,target:new Pt(i.clientX-t,i.clientY-t,2*t,2*t)}))}changeTooltip(e,t){return Tc.reconfigure(t,e,this)}}Sg.initClass(),Sg._$name="DragTipProxy";var Dg=e=>class extends(e||Pe){static $name="Labelable";static configurable={label:null,labelPosition:"before",labelCls:null,labelWidth:{value:null,$config:{localeKey:"L{labelWidth}"}}};get hasLabel(){return Boolean(this.label)}compose(){const{hasLabel:e,labelPosition:t}=this;return{class:{[`b-label-${t}`]:e,"b-has-label":e}}}changeLabel(e){return e||""}setupLabel(e){return W.assign({tag:"label",for:`${this.id}-input`,class:`b-label b-align-${e.align||"start"}`},e)}updateLabelWidth(e){this.labelElement&&(this.labelElement.style.flex=`0 0 ${Wn.setLength(e)}`,this.inputWrap.style.flexBasis=null==e?"":"auto")}get widgetClass(){}},wg=(e=Pe)=>class extends(e.mixin(Ri)){static $name="Validatable";get widgetClass(){}doDestroy(){const e=this,t=e._rootElement&&e.constructor.getSharedErrorTooltip(e._rootElement,{doNotCreate:!0,cachePath:e.errorTooltipCachePath});super.doDestroy(),(null==t?void 0:t.field)===e&&t.hide()}get errorTip(){return this.constructor.getSharedErrorTooltip(this.rootElement,{cachePath:this.errorTooltipCachePath,tooltipConfig:this.errorTooltipConfig})}static get errorTip(){return this.getSharedErrorTooltip(document.body)}static getSharedErrorTooltip(e,t={}){var n;const{doNotCreate:i,cachePath:r="errorTooltip",tooltipConfig:s}=t;let o=null===(n=e.bryntum)||void 0===n?void 0:n[r];return o||i||(e.bryntum=e.bryntum||{},o=Cg.new({cls:"b-field-error-tip",forSelector:".b-field.b-invalid .b-field-inner",align:{align:"l-r",monitorTargetMutation:!0},axisLock:"flexible",scrollAction:"realign",trapFocus:!1,rootElement:e,onBeforeShow(){const e=this,t=Tc.fromElement(e.activeTarget);if(t){const n=t.getErrors();if(n)return e.html=n.join("<br>"),e.field=t,!0}return!1}},s),e.bryntum[r]=o),o}setError(e,t,n){const i=this;if((i.errors||(i.errors={}))[e]=i.optionalL(e),t||i.syncInvalid(),n){const t=()=>{i.clearError(e),n()},n=i.ion({keydown:t,focusOut:t})}}clearError(e,t){const n=this;n.errors&&(e?delete n.errors[e]:n.errors={}),t||n.syncInvalid()}getErrors(){const e=this;if(!e.isValid){var t;const n=e.validity,i=W.keys(n).find((e=>"valid"!==e&&"customError"!==e&&n[e])),r=e.errors&&Object.values(e.errors);let s;if(s=null!=r&&r.length?r:n.customError?[e.input.validationMessage]:i?[e.L(i,{min:e.min,max:e.max})]:[e.L(e.invalidValueError)],(null===(t=s)||void 0===t?void 0:t.length)>0)return s}}syncInvalid(){const e=this,{isPainted:t}=e;if(e.updatingInvalid=!0,t){const{isValid:t,element:n,inputWrap:i}=e;if(n.classList[t?"remove":"add"]("b-invalid"),t){const t=e.constructor.getSharedErrorTooltip(e.rootElement,{doNotCreate:!0,cachePath:this.errorTooltipCachePath});null!=t&&t.isVisible&&t.field===e&&t.hide()}else if(i){const t=e.errorTip;t&&(e.containsFocus||e.isVisible&&i.contains(Cg.currentOverElement))&&(t.activeTarget===i&&t.isVisible?t.onBeforeShow():(t.activeTarget=i,t.showBy(i)))}}e.updatingInvalid=!1}};class Eg extends Nc{static $name="FieldContainer";static type="fieldcontainer";static get configurable(){return{animation:{duration:300},collapsed:null,collapser:{value:null,$config:"nullify"},syncableConfigs:null,syncConfigTriggers:{$config:{merge:"classList"},value:null},testConfig:{animation:{duration:10}}}}static get delayable(){return{syncChildConfigs:"raf"}}get inline(){return this.owner.inline??1===this.ensureItems().count}changeCollapsed(e){if(this.togglingCollapse)return this.togglingCollapse=!1,e;this.toggleCollapse(Boolean(e))}updateCollapsed(e){var t;this.collapser=null===(t=this.collapser)||void 0===t?void 0:t.destroy(),this.setCollapsedCls(e)}updateCollapser(e,t){t&&null==t.completed&&(t.reverting&&e||t.destroy()),this.setOwnerCls("b-collapsing",e)}get collapsing(){const{collapser:e}=this;return null!=e&&e.collapsed}get collapsingExpanding(){return null!=this.collapser}get expanding(){const{collapser:e}=this;return null!=e&&!e.collapsed}collapse(e){this.toggleCollapse(!0,e)}expand(e){this.toggleCollapse(!1,e)}setCollapsedCls(e){this.setOwnerCls("b-collapsed",e)}setOwnerCls(e,t){var n;null===(n=this.owner)||void 0===n||null===(n=n.element)||void 0===n||n.classList[t?"add":"remove"](e)}syncChildConfigs(){const e=this,{owner:t,syncableConfigs:n}=e;if(n){let i,r;for(i in n)r=n[i](t),e.eachWidget((e=>{e[i]=r}),!1)}t.afterSyncChildConfigs(e)}syncContainer(){const{inline:e,layout:t}=this;this.autoLayout&&(t.horizontal=e,t.justify=e?"center":"stretch")}toggleCollapse(e,t){const n=this,{animation:i,collapser:r,inline:s}=n,{containerWrapElement:o}=n.owner,a=t=>{t&&(n.element.style.height="",n.togglingCollapse=!0,n.collapsed=e,n.collapser=null)};if(null==e&&(e=!n.collapsed),!1!==t&&null!==t&&(o&&n.isVisible?(!0===t?t={}:"number"==typeof t&&(t={duration:t}),t=i||t?W.merge({},i,t):null):t=null),t){if(r&&e!==r.collapsed)n.collapser=r.revert({finalize:a}),n.collapser.collapsed=e;else if(!r&&e!==n.collapsed){!e&&n.setCollapsedCls(!1);const{element:i}=n,{height:r}=i.getBoundingClientRect(),l=s?1:r;!e&&n.setCollapsedCls(!0),i.style.height=`${r}px`,n.collapser=ed.run(W.merge({finalize:a,element:o,[s?"opacity":"height"]:{from:e?l:0,to:e?0:l}},t)),n.collapser.collapsed=e}}else n.togglingCollapse=!0,n.collapsed=e}}Eg.initClass(),Eg._$name="FieldContainer";const Rg=(e,t)=>(e.weight||0)-(t.weight||0),xg=(e,t)=>(t.weight||0)-(e.weight||0),Tg=[],Mg={align:!0,weight:!0};class Ig extends(Tc.mixin(zd,Dg,wg)){static $name="Field";static type="field";static get configurable(){return{defaultBindProperty:"value",skipValidation:null,placeholder:null,value:"",name:null,labels:null,required:null,clearable:null,revertOnEscape:null,hint:null,hintHtml:null,inputWidth:null,keyStrokeChangeDelay:0,readOnly:null,editable:!0,defaultAction:"change",stepTriggers:null,triggers:null,highlightExternalChange:!1,localizableProperties:["label","title","placeholder","labelWidth"],autoSelect:!1,autoComplete:"off",spellCheck:null,validateOnInput:!0,inputAttributes:null,inputType:"text",inputAlign:null,attributes:{value:["placeholder","autoComplete","spellCheck","minLength","maxLength","pattern","tabIndex","min","max"],$config:{merge:"distinct"}},nullValue:{$config:null,value:null,default:null},updatedClsDuration:500,inputReadOnly:!1,ariaElement:"input",container:{$config:"nullify",value:null},containerDefaults:{type:"fieldcontainer",syncableConfigs:{disabled:e=>e.disabled},syncConfigTriggers:{disabled:1}},containValues:null,inline:null,testConfig:{updatedClsDuration:10},keyMap:{},twinSyncConfigs:["value"]}}static get delayable(){return{highlightChanged:"raf"}}doDestroy(){var e,t,n;const i=this,{triggers:r}=i;if(null===(e=i.inputListenerRemover)||void 0===e||e.call(i),null===(t=i.keyListenerRemover)||void 0===t||t.call(i),null===(n=i.container)||void 0===n||n.destroy(),super.doDestroy(),r)for(const e of Object.values(r))e.destroy()}get childItems(){const{container:e,triggers:t}=this,n=t?Object.values(t):[];return e?[...n,...e.childItems]:n}get invalidValueError(){return"L{invalidValue}"}construct(e){super.construct(e);const t=this;t.keyStrokeChangeDelay&&(t.changeOnKeyStroke=t.buffer(t.internalOnChange,t.keyStrokeChangeDelay))}changeKeyMap(e){const t=this;let n={};e&&(t._fieldKeyMap?W.assign(n,t._fieldKeyMap):(t._fieldKeyMap=e,W.assign(n,e)));for(const e in t.triggers){var i;null!==(i=t.triggers[e])&&void 0!==i&&i.keyMap&&(n=t.mergeKeyMaps(n,t.triggers[e].keyMap,e))}return n}get keyMapSubComponents(){return this.triggers}onFocusIn(e){const t=this;t.valueOnFocus=W.clone(t.value),t.validOnFocus=!(t.errors&&Object.keys(t.errors).length),super.onFocusIn(e),t.focusing=!0,t.syncInvalid(),t.focusing=!1}onFocusOut(e){super.onFocusOut(e),this.syncRequired(),this.onEditComplete()}onEditComplete(){}get rootUiClass(){return Ig}compose(){this.getConfig("clearable");const e=this,{container:t,innerElements:n,label:i,labels:r,labelCls:s,readOnly:o,stepTriggers:a,triggers:l}=e,c=W.values(l,((e,t)=>!t)),d=c.filter((e=>"start"===e.align)).sort(Rg),u=c.filter((e=>"start"!==e.align)).sort(xg),h=e.setupLabel.bind(e),g=[...d.map((e=>e.element)),...n,...u.map((e=>e.element))];return{class:{"b-has-step-triggers":a,"b-has-start-trigger":d.length,"b-no-input":!n.length,"b-readonly":o,"b-field-container":Boolean(t),"b-field-container-inline":null==t?void 0:t.inline},children:[...(r||Tg).filter((e=>e&&"end"!==e.align)).map(h),i?h({reference:"labelElement",class:`b-label b-align-start ${s||""}`,html:i}):null,g.length?{class:"b-field-inner",reference:"inputWrap",children:g}:null,...(r||Tg).filter((e=>"end"===(null==e?void 0:e.align))).map(h),...t?[{reference:"containerWrapElement",children:[t.element],class:{"b-field-container-wrap":1}}]:Tg]}}updateElement(e,t){var n;const i=this,r=i.initialConfig.value,{input:s}=i;super.updateElement(e,t),null!=r&&(i.value=r),i.syncEmpty(),i.updateInputReadOnly(i.inputReadOnly),i.syncInvalid();const o=s||i.focusElement;null===(n=i.keyListenerRemover)||void 0===n||n.call(i),i.keyListenerRemover=o&&Xt.on({element:o,thisObj:i,keydown:"internalOnKeyEvent",keypress:"internalOnKeyEvent",keyup:"internalOnKeyEvent"})}get innerElements(){return[this.inputElement]}get inputElement(){const{attributes:e,inputAttributes:t,id:n,inputCls:i,inputType:r,name:s}=this,o=W.assign({reference:"input",tag:"input",type:r,name:s||n,id:`${n}-input`,retainElement:!0},t);i&&(o.class=i);for(let t,n,i=e.length;i-- >0;)t=e[i],n=this[t],null!=n&&(o[t]=n);return o}get caretPos(){return this.textSelection[0]}set caretPos(e){this.textSelection=e}get focusElement(){return this.input}get textSelection(){const e=this.input;let t;try{t=[e.selectionStart,e.selectionEnd,e.selectionDirection]}catch(i){var n;t=(null===(n=e.value)||void 0===n?void 0:n.length)||0,t=[t,t]}return t}set textSelection(e){"number"==typeof e?this.select(e,e):this.select(...e)}get hasTextSelection(){const[e,t]=this.textSelection;return e&&t-e>0}getAfterValue(e){const[t,n]=this.textSelection,i=this.input.value;return`${i.substr(0,t)}${e}${i.substr(n||t)}`}select(e,t){const n=this.focusElement;if(n.value.length){if(0===arguments.length)return void this.selectAll();if(!this.supportsTextSelection)return;n.setSelectionRange(e,t)}}moveCaretToEnd(){const e=this.input;if(e.createTextRange){const t=e.createTextRange();t.collapse(!1),t.select()}else this.supportsTextSelection&&this.select(e.value.length,e.value.length)}selectAll(){this.focusElement.select()}get caretAtEnd(){return this.textSelection[1]===this.input.value.length}get caretAtStart(){return!this.textSelection[1]}get selectedAll(){const{textSelection:e}=this;return!e[0]&&e[1]===this.input.value.length}syncEmpty(){var e;const{isEmptyInput:t,isEmpty:n,element:i}=this,r=null===(e=this.triggers)||void 0===e?void 0:e.clear,s=t&&n;i&&(r&&r[s?"hide":"show"](),i.classList.toggle("b-empty",s))}updateHint(){this.syncHint()}updateHintHtml(){this.syncHint()}syncHint(){const e=this,{input:t,hint:n,hintHtml:i}=e,r=null==t?void 0:t.parentElement;if(t){let s=i||n;const o=e.hintElement||s&&(e.hintElement=Wn.createElement({parent:r,className:"b-field-hint",nextSibling:t.nextSibling,children:[{className:"b-field-hint-content"}]}));o&&("function"==typeof s&&(s=s({source:e,value:e.value})),o.firstChild[i?"innerHTML":"textContent"]=s||""),e.element.classList[s?"remove":"add"]("b-field-no-hint")}}updateEditable(){this.syncInputReadOnly()}syncInputReadOnly(){this.getConfig("readOnly"),this.inputReadOnly=this._readOnly||!1===this.editable}updateInputReadOnly(e){const t=this,{input:n,inputListenerRemover:i}=t;n&&(n.readOnly=e?"readOnly":null,e?t.inputListenerRemover=null==i?void 0:i():i||(t.inputListenerRemover=Xt.on({element:n,thisObj:t,focus:"internalOnInputFocus",change:"internalOnChange",input:"internalOnInput"})))}changeReadOnly(e){return Boolean(e)}updateReadOnly(e){this.syncInputReadOnly()}updateClearable(e){const t=this;t.getConfig("triggers"),t.triggers={clear:e&&W.assign({cls:"b-icon-remove",weight:1e3,key:"Shift+backspace",handler(){t.clear(...arguments)}},e)||null}}changeTriggers(e,t){const n=this,i=n.$triggers||(n.$triggers=new Id({configName:"triggers",factory:Ig.Trigger,inferType:!1,owner:n,created(e){Ne.after(e,"onConfigChange",((e,{name:t})=>{Mg[t]&&n.onConfigChange({name:"triggers",value:i.target})}))},setup(e,t){e.reference=e.ref=t,e.parent=n}}));if(e&&!n.stepTriggers&&(e.back||e.forward)&&(delete(e=W.assign({},e)).back,delete e.forward),i.update(e),n.element&&(n.keyMap=n.keyMap),!t)return i.target}updateInputWidth(e){this.input.style.width=Wn.setLength(e),this.element.classList.add("b-has-width")}updateInputAlign(e){this.input.style.textAlign=e}get isValid(){const e=this;if(!e.disabled&&!e.skipValidation){if(e.syncRequired(),e.checkValidity&&e.callback(e.checkValidity,e,[e]),e.errors&&Object.keys(e.errors).length)return!1;const t=e.validity;if(t)return t.valid}return!0}get isEmpty(){return null==this.value||""===this.value}get isEmptyInput(){return!this.input||null==this.input.value||""===this.input.value}get validity(){const e=this.input;return null==e?void 0:e.validity}async setValue(e){this.value=e}changeValue(e,t){return null==e&&(e=this.nullValue),this.hasChanged(t,e)?e:(""===e&&this.syncRequired(),t)}updateValue(e,t){const n=this;n.isConfiguring||(n.syncRequired(),n.inputting||n.triggerChange()),n.inputting||(n._lastValue=e),n.syncInputFieldValue()}hasChanged(e,t){return t!==e}syncInputFieldValue(e=!1){const t=this,{input:n,parent:i,inputValueAttr:r,inputValue:s}=t;if(n&&!t.inputting&&n[r]!==s&&(n[r]=s,!t.isConfiguring&&!t.containsFocus&&t.highlightExternalChange)){if(n.classList.remove("b-field-updated"),t.clearTimeout("removeUpdatedCls"),i){const{assigningValues:t}=i;!0!==t&&!1!==(null==t?void 0:t.highlight)||(e=!0)}e||t.highlightChanged()}t.syncEmpty(),t.syncInvalid()}highlightChanged(){this.input.classList.add("b-field-updated"),this.setTimeout("removeUpdatedCls",this.updatedClsDuration)}removeUpdatedCls(){this.input.classList.remove("b-field-updated")}get inputValue(){return null==this.value?"":this.value}get inputValueAttr(){return"value"}get supportsTextSelection(){const e=this.focusElement;return e&&("textarea"===e.tagName.toLowerCase()||e.type&&/text|search|password|tel|url/.test(e.type))}internalOnInputFocus(){this.autoSelect&&this.selectAll()}internalOnChange(e){const t=this;t.hasChanged(t._lastValue,t.value)&&t.isValid&&(t.triggerChange(e,!0),t._lastValue=t.value)}triggerChange(e,t=Boolean(this._isUserAction)){const n=this,{value:i,_lastValue:r,isValid:s}=n;n.syncHint(),n.triggerFieldChange({value:i,oldValue:r,event:e,userAction:t,valid:s}),"change"===n.defaultAction&&n.trigger("action",{value:i,oldValue:r,event:e,userAction:t,valid:s})}fetchInputValue(){this.value=this.input[this.inputValueAttr]}internalOnInput(e){var t;const n=this;n.validateOnInput||n.errorTip.hide(),n.inputting=!0,n.fetchInputValue(),n.inputting=!1,n.trigger("input",{value:n.value,event:e}),null===(t=n.changeOnKeyStroke)||void 0===t||t.call(n,e)}get needsInputSync(){return this.input[this.inputValueAttr]!==String(this.inputValue??"")}internalOnKeyEvent(e){const t=this,{value:n}=t;let i=!1;if("keydown"===e.type&&"Escape"===e.key&&!t.readOnly&&!t.disabled){const r=t.isValid,s="initialValue"in t?t.initialValue:t.valueOnFocus,o=t.hasChanged(s,n),{needsInputSync:a}=t;t.revertOnEscape&&(!r||o||a)?(o&&(t.value=s),a&&t.syncInputFieldValue(!0),t.clearError(),i=(o||a)&&t.isValid||r!==t.validOnFocus):!t.isEmpty&&t.clearable&&t.revertOnEscape&&(t.clear(),e.stopPropagation())}t.isDestroyed||(i&&e.stopImmediatePropagation(),t.trigger(e.type,{event:e}))}clear(e){const t=this,{value:n}=t;(n!==t.nullValue||t.input.value.length>0)&&(t.value=t.nullValue,t.clearError(),t.syncInvalid(),t.trigger("clear",{event:e}))}onDisabled(){this.syncInvalid()}syncRequired(){var e;const t=this;t.isConfiguring||t.focusing&&!t.accessibility||!t.required||!t.isEmpty||null!==(e=t.parent)&&void 0!==e&&e.isSettingValues?t.clearError("L{fieldRequired}",t.updatingInvalid):t.setError("L{fieldRequired}",t.updatingInvalid)}get containerCollapsed(){var e;return null===(e=this.container)||void 0===e?void 0:e.collapsed}set containerCollapsed(e){const{container:t}=this;t&&(t.collapsed=e)}afterSyncChildConfigs(e){}changeContainer(e,t){e&&(Array.isArray(e)||!("type"in e)&&!("items"in e))&&(e={items:e});const n=this,i=e&&W.merge({owner:n,layout:"box"},n.containerDefaults),r=Tc.reconfigure(t,e,{owner:n,defaults:i});if(!r||(r.autoLayout="box"===(null==i?void 0:i.layout),r!==t))return r;r.syncContainer()}onConfigChange(e){var t;super.onConfigChange(e),null!==(t=this.container)&&void 0!==t&&null!==(t=t.syncConfigTriggers)&&void 0!==t&&t[e.name]&&this.container.syncChildConfigs()}assignValue(e,t){const{container:n,containValues:i}=this,r=this.getValueName(t);n&&!1!==i?e&&"nested"===i?e&&r in e&&(e=W.clone(e[r]),super.assignValue({[r]:e&&!("value"in e)||e.value},t),e&&delete e.value,n.assignValue(e,t)):(super.assignValue(e,t),n.assignValue(e,t)):super.assignValue(e,t)}gatherValue(e){super.gatherValue(e),this.gatherValues(e)}gatherValues(e,t){const n=this,{container:i,containValues:r,valueName:s}=n,o=typeof r;t=t??s in e,i&&!1!==r&&("nested"===r?t&&(e[s]={value:e[s],...i.values}):(!0===r||null==r&&t||"string"===o&&n[r]||"function"===o&&r(n))&&i.gatherValues(e))}updateContainer(e,t){t&&this.detachListeners(t.id),e&&(e.rendered||e.render(),e.syncContainer(),e.syncChildConfigs())}}Ig.Trigger=class extends Tc{static $name="FieldTrigger";static get factoryable(){return{defaultType:Ig.Trigger,extends:null}}static type="trigger";static configurable={align:null,weight:null,role:null};get field(){return this.parent}construct(){super.construct(...arguments),this.key&&(this.keyMap={[this.key]:"onClick"})}compose(){return{"aria-hidden":!0,class:{[`b-align-${this.align||"end"}`]:1,"b-icon":1},listeners:{click:"onClick",mousedown:"onMousedown"}}}changeAlign(e){return e}onClick(e){const t=this,{field:n}=t;n.disabled||n.readOnly||(e.key&&e.preventDefault(),!1!==n.trigger("trigger",{trigger:t})&&t.handler&&(n._isUserAction=!0,n.callback(t.handler,n,[e,t]),n._isUserAction=!1))}onMousedown(e){const t=this.field;!("key"in e)&&Wn.isTouchEvent&&t.editable&&(t.editable=!1,t.setTimeout((()=>t.editable=!0),500)),e.preventDefault(),Wn.getActiveElement(t.input)!==t.input&&t.focus()}},Ig.SpinTrigger=class extends Ig.Trigger{static $name="SpinTrigger";static type="spintrigger";static configurable={repeat:{$config:["nullify"],value:!0}};compose(){return{children:{upButton:{class:{"b-icon":1,"b-spin-up":1}},downButton:{class:{"b-icon":1,"b-spin-down":1}}}}}updateRepeat(e){var t;null===(t=this.clickRepeater)||void 0===t||t.destroy(),this.clickRepeater=e?td.new({element:this.element},e):null}onClick(e){const t=this,{field:n}=t;n._isUserAction=!0,n.disabled||n.readOnly||(e.target===t.upButton?n.doSpinUp(e.shiftKey):e.target===t.downButton&&n.doSpinDown(e.shiftKey)),n._isUserAction=!1}get isFocusable(){return!this.disabled&&super.isFocusable}},Ig.Trigger.initClass(),Ig.SpinTrigger.initClass(),Tc.register(Ig.Trigger,"trigger"),Tc.register(Ig.SpinTrigger,"spintrigger"),Ig._$name="Field";class Ag extends Ig{static $name="TextField";static type="textfield";static alias="text";static configurable={nullValue:""};construct(e){"hidden"===(null==e?void 0:e.inputType)&&(e.hidden=!0),super.construct(...arguments)}}Ag.initClass(),Ag._$name="TextField";class kg extends Ag{static $name="PickerField";static type="pickerfield";static get configurable(){return{editable:!0,pickerAlignElement:"inputWrap",value:null,triggers:{expand:{cls:"bars"}},autoExpand:null,picker:{value:{floating:!0},$config:["lazy","nullify"]},inputType:"text",monitorResize:!0,nullValue:null}}doDestroy(){var e;null===(e=this.globalTapListener)||void 0===e||e.call(this),super.doDestroy()}changeEditable(e){return d.isMobile&&!0!==this.initialConfig.editable&&(e=!1),e}updateEditable(e){const t=this,{element:n,ariaElement:i,nonEditableClickTarget:r}=t,{expand:s}=t.triggers,o=globalThis.matchMedia("(max-width: 410px)").matches;var a;(super.updateEditable(...arguments),n.classList.toggle("b-not-editable",!e),!1===e)?(d.isMobile&&o&&(null==s||s.hide()),null==i||i.removeAttribute("aria-autocomplete"),null===(a=t.globalTapListener)||void 0===a||a.call(t),r&&Xt.on({element:r,click:e=>{const n=r.getRootNode().elementFromPoint(e.clientX,e.clientY);e.target===r&&n===r&&t.onTriggerClick(e)},thisObj:t})):(null==s||s.show(),null==i||i.setAttribute("aria-autocomplete","list"),t.globalTapListener=ti.ion({globaltap:"showKeyboard",thisObj:t}))}get nonEditableClickTarget(){return this.input}updateElement(e,t){var n;const i=super.updateElement(e,t),r=this.peekConfig("picker"),s=!!r&&(r.isWidget?r.role:null===(n=this.constructor.resolveType(r.type))||void 0===n?void 0:n.$meta.config.role);return Wn.setAttributes(this.ariaElement,{"aria-expanded":!1}),this.ariaHasPopup=s,i}get pickerAlignElement(){const{_pickerAlignElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:W.getPath(this,e)}changePicker(e,t){throw new Error("changePicker() must be implemented in PickerField subclass implementations")}updatePicker(e){this.detachListeners("pickerField.picker"),null==e||e.ion({name:"pickerField.picker",thisObj:this,show:"onPickerShow",hide:"onPickerHide"})}get childItems(){const e=super.childItems;return this._picker&&e.push(this.picker),e}onEditComplete(){super.onEditComplete(),this.hidePicker()}onElementResize(e){const t=this;t.pickerVisible&&t.picker.requestAnimationFrame(t.picker.realign,null,t.picker),super.onElementResize(e)}internalOnKeyEvent(e){const t=this;let n=!0;if("keydown"===e.type&&!t.disabled&&!e.shiftKey&&!e.ctrlKey)if(t.pickerVisible){const{picker:i}=t;"Escape"===e.key?(e.preventDefault(),e.stopImmediatePropagation(),t.hidePicker(),n=!1):i.onInternalKeyDown?i.onInternalKeyDown(e):"ArrowDown"===e.key&&i.focusable&&i.focus()}else"ArrowDown"===e.key&&t.picker&&t.onTriggerKeyDown(e);n&&super.internalOnKeyEvent(e)}onFocusIn(e){var t;const n=this,i=null===(t=ti.currentPointerDown)||void 0===t?void 0:t.target;super.onFocusIn(e),!n.autoExpand||null!=i&&i.matches(".b-fieldtrigger")||(n.minChars=0,n.onTriggerClick(e))}onTriggerClick(e){this.disabled||this.togglePicker("key"in e)}onTriggerKeyDown(e){!1!==this.trigger("triggerKey",{event:e})&&(e.stopImmediatePropagation(),e.preventDefault(),this.onTriggerClick(e))}showKeyboard({event:e}){const t=this.input;Wn.isTouchEvent&&Wn.getActiveElement(t)===t&&e.target===t&&(ti.suspendFocusEvents(),t.blur(),t.focus(),ti.resumeFocusEvents())}togglePicker(e){this.pickerVisible?this.hidePicker():this.showPicker(e)}showPicker(e){const t=this,{picker:n}=t;n&&(Wn.setAttributes(t.ariaElement,{"aria-controls":n.id,"aria-expanded":!0}),n.show(),n.isVisible&&e&&t.focusPicker())}onPickerShow(){const e=this;e.pickerVisible=!0,e.element.classList.add("b-open"),e.trigger("togglePicker",{show:!0}),e.pickerTapOutRemover=ti.ion({globaltap:"onPickerTapOut",thisObj:e}),e.pickerKeyDownRemover=Xt.on({element:e.picker.element,keydown:"onPickerKeyDown",thisObj:e})}onPickerHide(){var e,t,n;const i=this;null===(e=i.ariaElement)||void 0===e||e.setAttribute("aria-expanded",!1),i.pickerVisible=!1,i.element.classList.remove("b-open"),i.trigger("togglePicker",{show:!1}),null===(t=i.pickerTapOutRemover)||void 0===t||t.call(i),null===(n=i.pickerKeyDownRemover)||void 0===n||n.call(i)}onPickerTapOut({event:e}){this.containsFocus||this.owns(e.target)||this.hidePicker()}onPickerKeyDown(e){if("Tab"===e.key&&!this.picker.trapFocus){const t=Wn.getActiveElement(this.input),n=new KeyboardEvent("keydown",e);this.input.dispatchEvent(n),n.defaultPrevented&&e.preventDefault(),Wn.getActiveElement(this.input)===t?this.input.focus():e.preventDefault(),this.isDestroyed||this.hidePicker()}}hidePicker(){this.pickerVisible&&this.picker.hide()}focusPicker(){}focus(){const e=this.input;Wn.isTouchEvent&&this.editable&&(e.readOnly=!0,this.setTimeout((()=>e.readOnly=!1),500)),super.focus()}}kg._$name="PickerField";const Fg=document.createRange();class Pg extends Tc{static $name="List";static type="list";static configurable={itemCls:"b-list-item",selectedCls:"b-selected",selectIconCls:"b-icon-check",tag:"ul",items:null,displayField:"text",store:{value:{},$config:"lazy"},navigator:!0,scrollable:{overflowX:!1,overflowY:!0},itemsFocusable:!0,multiSelect:!1,toggleAllIfCtrlPressed:!1,collapsibleGroups:!1,selectAllItem:!1,itemTpl(e){let t=H.encodeHtml(e.getValue(this.displayField));return null!=t&&""!==t||(t="&nbsp;"),t},tooltipTemplate:null,getItemStyle:null,getItemCls:null,groupHeaderTpl(e,t){let n=H.encodeHtml(t);return null!=n&&""!==n||(n="&nbsp;"),`${(this.allowGroupSelect||e.isParent)&&this.isSelectable(e)?this.itemIconTpl(e):""}${n}`},allowGroupSelect:!0,clearSelectionOnEmptySpaceClick:!1,selected:{$config:["nullify","lazy"],value:[]},activateOnMouseover:null,role:"listbox",keyMap:{"Ctrl+a":"selectAll"},title:null,virtualize:null,listItemHeight:10,isSelectable:()=>!0};construct(e,...t){var n;const i=this;Array.isArray(e)&&(e={items:e}),super.construct(e,...t);const{element:r}=i,{classList:s}=r;i.multiSelect&&s.add("b-multiselect"),null!==(n=i.store)&&void 0!==n&&n.count?i.refresh():s.add("b-empty"),Xt.on({element:r,delegate:i.itemSelector,mouseover:"onMouseOver",thisObj:i}),Xt.on({element:r,click:"onClick",thisObj:i})}doDestroy(){var e;this.detachListeners("store"),null===(e=this.navigator)||void 0===e||e.destroy(),super.doDestroy()}onFocusIn(e){var t;this.restoreActiveItem(null===(t=e._target)||void 0===t?void 0:t.closest(this.itemSelector)),super.onFocusIn(e)}get isVirtualized(){return"number"==typeof this.virtualize?this.store.count>this.virtualize:Boolean(this.virtualize)}outOfViewTpl(e,t){return`<li class="b-list-item b-out-of-view" data-index="${t}" data-id="${H.encodeHtml(e.id)}"></li>`}onItemIntersection(e,t){if(t){const t=parseInt(e.dataset.index),n=this.store.getAt(t);Wn.sync(this.itemWrapperTpl(n,t),e),this.itemIntersectionObserver.unobserve(e)}}contentTpl(){const e=this,t=Math.ceil(e.height/e.listItemHeight),n=e.store.records.map(((n,i)=>!e.isVirtualized||i<t?e.itemWrapperTpl(n,i):e.outOfViewTpl(n,i)));return e.multiSelect&&!1!==e.selectAllItem&&n.unshift(e.selectAllItemTpl()),e.title&&n.unshift(`<li class="b-list-item b-list-title">${e.title}</li>`),Bu.tpl`${n}`}itemWrapperTpl(e,t){const n=this,{selected:i,getItemStyle:r,store:s,tooltipTemplate:o}=n,a=(null==o?void 0:o(e))||"",l=`style="${r?n.callback(r,n,[e]):""};--tree-level:${e.childLevel||0}"`,c=n.callback(n.isSelectable,n,[e]);return s.isGrouped&&!e.isGroupHeader&&e.instanceMeta(s).groupParent.meta.collapsed?"":e.ancestorsExpanded(s)?Bu.tpl`<li ${l} class="${n.getItemClasses(e,t)}" role="option" ${a?`data-btip="${H.encodeHtml(a)}"`:""} aria-selected="${i.includes(e)}" data-index="${t}" ${c?"":"data-noselect"} data-id="${H.encodeHtml(e.id)}" ${n.itemsFocusable?'tabindex="-1"':""}>${n.itemContentTpl(e,t)}</li>`:""}itemContentTpl(e,t){if(e.isGroupHeader||e.isParent&&!1!==this.store.excludeCollapsedRecords){let n=this.groupHeaderTpl(e,e.isParent?this.itemTpl(e,t):H.capitalize(e.meta.groupRowFor));if(this.collapsibleGroups||e.isParent){n+=`<button class="b-button b-tool b-icon b-icon-collapse-${(e.isParent?e.instanceMeta(this.store).collapsed:e.meta.collapsed)?"right":"down"} b-list-expander-icon" data-noselect></button>`}return n}return`${this.itemIconTpl(e,t)}${this.itemTpl(e,t)}`}itemIconTpl(e,t){return this.multiSelect&&this.callback(this.isSelectable,this,[e])?`<i class="b-selected-icon b-icon ${this.selectIconCls}"></i>`:""}selectAllItemTpl(){const e=this.allSelected?"b-selected":"";return`<li class="${this.itemCls} b-select-all-item ${e}" data-noselect data-select-all data-id="select-all" ${this.itemsFocusable?'tabindex="-1"':""}>${this.itemIconTpl({})}<div>${this.L("selectAll")}</div></li>`}getItemClasses(e){var t,n;const i=this,{getItemCls:r}=i,s=null===(t=i._navigator)||void 0===t?void 0:t.activeItem,o=(null==s?void 0:s.dataset.id)==e.id,a="groupRowFor"in e.meta?"b-list-item-group-header":e.isParent?"b-list-item-tree-parent":"",l=i.selected.includes(e)||(null===(n=e.groupChildren)||void 0===n?void 0:n.every((e=>i.selected.includes(e)))),c=r?this.callback(r,this,[e]):"";return`${i.itemCls} ${e.cls||""} ${c} ${l?i.selectedCls:""} ${o?i.navigator.focusCls:""} ${a}`}onBeforeStoreLoad(){this.mask(this.L("L{loading}"))}onAfterStoreRequest(){this.unmask()}onStoreChange({source:e,action:t,records:n,record:i,changes:r,isCollapse:s}){const o=this,{selected:a}=o;switch(t){case"dataset":a.match(e.storage,!o._externallyOwnedSelection);break;case"remove":s||a.remove(n);break;case"clear":o.deselectAll();break;case"update":{const{id:e}=r;return e&&Wn.setAttributes(o.contentElement.querySelector(H.encodeAttributeSelector("data-id",e.oldValue)),{"data-id":e.value}),void o.refreshItem(i)}}o.refresh()}onStoreRefresh(){this._selected?this.refresh():this.getConfig("selected")}refresh(){const e=this;if(e.isVisible&&e.store){var t;const n=null===(t=e.navigator)||void 0===t?void 0:t.activeItem;e.itemIntersectionObserver&&(e.itemIntersectionObserver.disconnect(),e.itemIntersectionObserver=null),e.paintListener=null;const i=Wn.createElementFromTemplate(e.contentTpl(),{fragment:!0});if(e.clearItems().insertNode(i),e.element.classList.toggle("b-virtualized",e.isVirtualized),e.isVirtualized){e.itemIntersectionObserver=new IntersectionObserver((t=>{for(const n of t)e.onItemIntersection(n.target,n.isIntersecting,n)}));for(const t of e.element.querySelectorAll(e.itemSelector))e.itemIntersectionObserver.observe(t);e.listItemHeight=e.element.children[0].clientHeight}n&&e.restoreActiveItem(n),e.refreshCount=(e.refreshCount||0)+1,e.element.classList.toggle("b-empty",0===e.store.count),e.updateSelectAllState()}else e.paintListener||(e.paintListener=e.once("paint","refresh"))}clearItems(){const e=this,{contentElement:t}=e,n=t.querySelector(e.itemSelector),i=t.lastChild;if(n){const i=t.querySelectorAll(`${e.itemSelector}:not(.b-mask)`);Fg.setStartBefore(n),Fg.setEndAfter(i[i.length-1]),Fg.deleteContents()}else i?(Fg.setStartAfter(i),Fg.setEndAfter(i)):(Fg.setStart(t,0),Fg.setEnd(t,0));return Fg}refreshItem(...e){for(const t of e){const e=this.getItem(t);if(e){const n=this.store.indexOf(t),i=Wn.createElementFromTemplate(this.itemWrapperTpl(t,n));Wn.sync(i,e)}}}getItem(e){var t;if(null!=e)return"number"==typeof e?this.contentElement.querySelector(`[data-index="${e<0?this.store.count+e:e}"]`):(e.nodeType===Element.ELEMENT_NODE&&(e=e.dataset.id),null!=(null===(t=e)||void 0===t?void 0:t.id)&&(e=e.id),this.contentElement.querySelector(H.encodeAttributeSelector("data-id",e)))}getRecordFromElement(e){return e.target&&(e=e.target),e=e.closest(this.itemSelector),this.store.getAt(parseInt(e.dataset.index))}updateItems(e){this.store.data=$e.asArray(e??[]).map((e=>"string"==typeof e?{[this.displayField]:e}:e))}updateDisabled(e,t){super.updateDisabled(e,t),this.navigator&&(this.navigator.disabled=e)}updateLocalization(){super.updateLocalization(),this.refresh()}updateTitle(){this.refresh()}changeSelected(e,t){const n=this,i={change:"onInternalSelectionChange",thisObj:n};if(e){if(e.isCollection)n._externallyOwnedSelection=!0,e.ion(i);else if(n._externallyOwnedSelection=!1,e=$e.asArray(e).reduce(((e,t)=>((t=t.isModel?t:n.store.getById(t))&&n.callback(n.isSelectable,n,[t])&&e.push(t),e)),[]),t)t.splice(0,t.count,e),e=t,n.refresh();else{const t=e;(e=n._selected=new Xs({internalListeners:i})).add(t)}e!==t&&(null==t||t.un(i))}else null==t||t.destroy();return e}updateSelected(e){e&&this.refresh()}get itemSelector(){return`.${this.itemCls}`}get selected(){return this._selected}updateMultiSelect(e,t){!e&&t&&this.selected.count>1&&this.deselect(this.selected.allValues.slice(1))}get store(){return this.getConfig("items"),this._store}changeStore(e){const t=this;if(e instanceof gl||(Array.isArray(e)&&(e={data:e}),e=new gl(e)),t.detachListeners("store"),e){const n={name:"store",change:"onStoreChange",refresh:"onStoreRefresh",thisObj:t};e.readUrl&&(n.beforeLoad="onBeforeStoreLoad",n.afterRequest="onAfterStoreRequest"),e.isGrouped&&(t.element.classList.add("b-grouped"),n.groupchange="onStoreRefresh"),e.ion(n),e.tree&&e.traverse((t=>{t.isParent&&!t.expanded&&e.onNodeExpand(t)}))}return e}updateStore(e){null!=e&&e.records.length&&this.getConfig("selected"),this.refresh()}changeNavigator(e,t){const n=this,{element:i}=n;var r;i&&((null===(r=e=Ch.reconfigure(t,e?Ch.mergeConfigs({ownerCmp:n,disabled:n.disabled,target:i,keyEventTarget:i},e):null,n))||void 0===r?void 0:r.keyEventTarget)!==i||n.itemsTabbable||(i.tabIndex=0));return e}get minAlignHeight(){const e=this.element.lastElementChild,t=this.minHeight;if(null!=t)return e?Math.min(e.offsetTop+e.offsetHeight,t):0}alignTo(...e){super.minHeight=this.minAlignHeight,super.alignTo(...e)}hide(...e){return this.navigator&&(this.navigator.activeItem=null),super.hide(...e)}show(){const{refreshCount:e}=this,{previousActiveItem:t}=this.navigator;super.minHeight=this._minHeight;const n=super.show(...arguments);return this.refreshCount===e&&this.restoreActiveItem(t,!0),n}restoreActiveItem(e=this.navigator.previousActiveItem,t="nearest"){const n=this,{navigator:i,lastAlignSpec:r}=n;if(null!=e){if("string"!=typeof t){const e=r?r.zone:1;t=1&e?"nearest":e?"start":"end"}(e=n.getItem(e))&&!n.disabled&&(n.scrollable.scrollIntoView(e,{block:t}),i.activeItem=e)}}onMouseOver(e){const t=this,n=e.currentTarget;!Wn.isTouchEvent&&n&&t.navigator&&t.activateOnMouseover&&t.setTimeout({fn:"handleMouseOver",delay:30,args:[n],cancelOutstanding:!0})}handleMouseOver(e){this.navigator.activeItem=e}onClick(e){const t=e.target.closest(this.itemSelector);t?this.onItemClick(t,e):this.clearSelectionOnEmptySpaceClick&&this.deselectAll()}onSpaceKey(e){("INPUT"!==e.target.nodeName.toUpperCase()||e.target.readOnly)&&this.onEnterKey(e)}onEnterKey(e){const t=this.navigator.activeItem;t&&!this.disabled&&(this.onItemClick(t,e),e.stopImmediatePropagation(),e.preventDefault())}onInternalKeyDown(e){const t=this;switch(e.key){case"ArrowLeft":t.collapseItem();break;case"ArrowRight":t.expandItem();break;case" ":t.onSpaceKey(e);break;case"Enter":t.onEnterKey(e)}}collapseItem(){const{activeItem:e}=this.navigator;e&&this.toggleCollapse(this.getRecordFromElement(e),!0)}expandItem(){const{activeItem:e}=this.navigator;e&&this.toggleCollapse(this.getRecordFromElement(e),!1)}onItemClick(e,t){const n=this,{allowGroupSelect:i}=n,r=parseInt(e.dataset.index),s=n.store.getAt(r),o=null==s?void 0:s.isSpecialRow,a=e.contains(t.target.closest("[data-noselect]"));if(!n.disabled&&!1!==n.trigger("beforeItem",{item:e,record:s,index:r,event:t,userAction:!0})){if(n._isUserAction=!0,e.contains(t.target.closest("[data-select-all]")))n.onSelectAllClick(e,t);else{if(t.target.matches(".b-list-expander-icon"))return void n.toggleCollapse(s);if(s&&!a&&(!o||i)){const{selected:r}=n,{groupParent:a}=s.instanceMeta(n.store);if(n.multiSelect){let l=r.includes(s),c=s;if(n.toggleAllIfCtrlPressed&&t.ctrlKey?c=n.store.records:i&&o&&(l=!s.groupChildren.some((e=>!r.includes(e))),e.classList.toggle("b-selected",!l),c=s.groupChildren),r[l?"remove":"add"](c),!o&&a&&i){n.getItem(a).classList.toggle("b-selected",a.groupChildren.every((e=>r.includes(e))))}}else r.splice(0,r.count,s)}}n.isDestroyed||(n.lastClicked=s,n.trigger("item",{item:e,record:s,index:r,event:t,userAction:!0}),n._isUserAction=!1)}}onInternalSelectionChange({action:e,removed:t,added:n,replaced:i}){const r=this,{selectedCls:s,unselectedCls:o}=r;let a,l;if("clear"===e)for(l of r.element.querySelectorAll(`.${s}`))l.classList.remove(s),l.setAttribute("aria-selected",!1),o&&l.classList.remove(o);else if("replaceValues"!==e){for(a of t)l=r.getItem(a),l&&(l.classList.remove(s),l.setAttribute("aria-selected",!1));for(a of n)l=r.getItem(a),l&&(l.classList.add(s),l.setAttribute("aria-selected",!0))}r.selectAllItem&&r.updateSelectAllState(),r.trigger("selectionChange",{selected:r.selected.values})}onSelectAllClick(e){e.classList.contains(this.selectedCls)?this.deselectAll():this.selectAll()}updateSelectAllState(){var e;null===(e=this.element.querySelector(".b-select-all-item"))||void 0===e||e.classList.toggle(this.selectedCls,this.allSelected)}updateAllowGroupSelect(){this.refresh()}get allSelected(){const{selected:e,store:t}=this;return e.count&&(t.isFiltered?t.records.every((t=>e.includes(t))):t.count===e.count)}selectAll(e){const t=this;!t.multiSelect&&e||(t.selected.add(t.store.records),e&&!t.navigator.activeItem&&(t.navigator.activeItem=t.getItem(-1)))}deselectAll(){this.selected.clear()}select(e){const{store:t}=this,{modelClass:n}=t;e=$e.asArray(e).reduce(((e,i)=>((i=t.getById(n.asId(i)))&&e.push(i),e)),[]),this.selected.add(e)}deselect(e){const{modelClass:t}=this.store;e=$e.asArray(e).reduce(((e,n)=>((n=this.selected.get(t.asId(n)))&&e.push(n),e)),[]),this.selected.remove(e)}toggleCollapse(e,t){const{store:n}=this;e.isGroupHeader?(n[(t=void 0===t?!e.meta.collapsed:t)?"collapse":"expand"](e),this.refresh(),this.trigger("toggleGroup",{groupRecord:e,collapse:t})):e.isParent&&(t=void 0===t?!e.instanceMeta(n).collapsed:t,e.instanceMeta(n).collapsed=t,this.refresh(),this.trigger("toggleNode",{record:e,collapse:t}))}updateCollapsibleGroups(e,t){if(t&&!e){const{store:e}=this;e.groupRecords.forEach((t=>e.expand(t)))}this.refresh()}}Pg.initClass(),Pg.prototype.navigatorClass=Ch,Pg._$name="List";class Og extends Pg{static $name="ChipView";static type="chipview";static configurable={itemCls:"b-chip",multiSelect:!1,closable:!0,iconTpl:null,closeHandler:null};itemContentTpl(e,t){const n=this;return Bu.tpl`${n.iconTpl?this.iconTpl(e):""}
            ${n.itemTpl(e,t)}
            ${n.closable?'<div class="b-icon b-close-icon b-icon-clear" data-noselect></div>':""}`}onInternalKeyDown(e){const t=this,{selected:n}=t,{generation:i}=n;t.closable&&n.count&&("Delete"===e.key||"Backspace"===e.key)?(t.closeHandler?t.callback(t.closeHandler,t.owner,[n.values,{isKeyEvent:!0}]):t.store.remove(n.values),n.generation!==i&&e.stopImmediatePropagation()):super.onInternalKeyDown(e)}updateClosable(e){this.element.classList[e?"add":"remove"]("b-chips-closable"),this.navigator&&(this.navigator.disabled=!e),this.isConfiguring||this.refresh()}onClick(e){const t=this,n=e.target.closest(`.${t.itemCls}`);if(t.closable&&e.target.classList.contains("b-close-icon")){const e=t.store.getAt(parseInt(n.dataset.index));t.closeHandler?t.callback(t.closeHandler,t.owner,[[e]]):t.store.remove(e)}else super.onClick(e)}}Og.initClass(),Og._$name="ChipView";const Lg="L{fieldRequired}",$g="L{validateFilter}",_g=/[\w\s]/;class jg extends kg{static $name="Combo";static type="combo";static alias="combobox,dropdown";static delayable={filterOnInput:0};static get configurable(){return{primaryFilter:{},picker:{type:"list",floating:!0,scrollAction:"realign",itemsFocusable:!1,activateOnMouseover:!0,align:{align:"t0-b0",axisLock:!0},maxHeight:324,scrollable:{overflowY:!0},autoShow:!1,focusOnHover:!1},multiSelect:null,items:null,store:null,valueField:void 0,displayField:"text",clearWhenInputEmpty:null,pickerWidth:null,minChars:null,selected:null,listItemTpl:null,displayValueRenderer:null,listCls:null,triggers:{expand:{cls:"b-icon-picker",handler:"onTriggerClick"}},filterParamName:null,encodeFilterParams:e=>e.map((e=>e.value)),filterOnEnter:!1,hideTrigger:null,overlayAnchor:null,keyStrokeFilterDelay:null,defaultAction:"select",triggerAction:"all",filterOperator:"startsWith",caseSensitive:!1,hidePickerOnSelect:null,chipView:{$config:["lazy","nullify"],value:{type:"combochipview"}},chipStore:{$config:["lazy","nullify"],value:{}},filterSelected:null,emptyText:null,value:null,valueCollection:{$config:["nullify","lazy"],value:{}},validateFilter:!0,clearTextOnPickerHide:!0,clearTextOnSelection:!0,destroyStore:!1,multiValueSeparator:",",createOnUnmatched:null,role:"combobox",inlinePicker:null,testConfig:{keyStrokeFilterDelay:0},localizeDisplayFields:!1,buildItems:null,sortItemsOnLocaleChange:!1}}static get queryLast(){return"last"}construct(e){super.construct(...arguments),this.store||(this.items=[]),this.filterOnEnter&&(this.hideTrigger=!0)}startConfigure(e){this.usingRecordAsValue=null===e.valueField,super.startConfigure(...arguments)}afterConfigure(){super.afterConfigure();const e=this;W.hasOwn(e,"_value")||(e._value=e.valueField===e.displayField?"":null,e._lastValue=e._lastValue||e._value)}get childItems(){const{_chipView:e}=this,t=super.childItems;return e&&t.push(e),t}get innerElements(){var e;const t=null===(e=this._chipView)||void 0===e?void 0:e.element,{input:n,inputElement:i}=this;return t&&Ll.sync({targetElement:n,domConfig:i}),[t||i]}updateInlinePicker(e){e&&(this.element.classList.add("b-inline-picker"),this.getConfig("picker"),this.triggers.expand=null,this.pickerVisible=!0)}hidePicker(){if(!this.inlinePicker)return super.hidePicker(...arguments)}changeChipStore(e){return!e||e instanceof gl||(e=new gl(gl.mergeConfigs({storage:this.valueCollection},e))),e}updateChipStore(e,t){null==t||t.destroy()}changeChipView(e,t){const n=this;if(n.element.classList[e?"add":"remove"]("b-uses-chipview"),e){const{input:i}=n;return n.chipStore||(n.chipStore={}),Bg.reconfigure(t,e,{defaults:{parent:n,insertBefore:i,store:n.chipStore,closable:!n.readOnly,navigator:{type:"combochipnavigator",keyEventTarget:i}}})}null==t||t.destroy()}updateChipView(e){var t;const n=this;n._chipViewEventDetacher=null===(t=n._chipViewEventDetacher)||void 0===t?void 0:t.call(n),n.chipStore=null==e?void 0:e.store,e&&(e.element.appendChild(n.input),n._chipViewEventDetacher=Xt.on({element:e.element,mousedown:"onChipViewMousedown",thisObj:n}))}updateMultiSelect(e,t){const n=this,{input:i,element:r}=n,s=!n.isConfiguring;let{value:o}=n;if(r.classList[e?"add":"remove"]("b-multiselect"),e){const{chipView:e}=n,{parentNode:t}=i,r=null==e?void 0:e.element;r&&r!==t&&(t.insertBefore(r,i),r.appendChild(i),n.chipView.refresh()),i.value="",s&&(o=$e.asArray(o))}else{const e=n._chipView,{parentNode:t}=i,l=null==e?void 0:e.element;var a;if(l===t&&(l.parentNode.insertBefore(i,l),l.remove(),r.classList.remove("b-uses-chipview")),s&&"string"!=typeof o)o=null!==(a=o)&&void 0!==a&&a.length?o[0]:null}s&&(n.value=o)}onChipViewMousedown(e){e.preventDefault(),this.containsFocus||this.focus()}onChipClose(e,t={}){(t.isKeyEvent&&""===this.input.value||!t.isKeyEvent)&&(this._isUserAction=!0,this.valueCollection.remove(e),this._isUserAction=!1)}updateFilterParamName(e){!1!==this.hideTrigger&&(this.hideTrigger=Boolean(e))}updateHideTrigger(e){this.element.classList[e?"add":"remove"]("b-hide-trigger")}updateKeyStrokeFilterDelay(e){this.filterOnInput.delay=e}updateReadOnly(e){super.updateReadOnly(...arguments),this._chipView&&(this._chipView.closable=!e)}updateDisabled(e,t){super.updateDisabled(e,t),this._chipView&&(this._chipView.closable=!e)}updateFilterOperator(e){this.primaryFilter&&(this.primaryFilter.operator=e)}get minChars(){return this._minChars??(this.remoteFilter?4:1)}get validateFilter(){return this._validateFilter&&!this.createOnUnmatched}get items(){return this.store.allRecords}updateBuildItems(e){e&&(this.items=e.call(this))}changeItems(e){var t;const n=this;if(null==e){if(n.store&&!n.store.isItemStore)return;e=[]}if(!n.buildItems||null!==(t=e)&&void 0!==t&&t.length||(e=n.buildItems()),e instanceof gl)return void(n.store=e);const i=n.displayField;let r,s,o=n.valueField;if(Array.isArray(e)?s=e.map((e=>{let t=e;return e instanceof ws?(r=e.constructor,o||(n.valueField=o=r.idField)):"string"==typeof e||"number"==typeof e?(o||(n.valueField=o=n.displayField),t={[o]:e,[i]:e}):(o||(n.valueField=o="value"),Array.isArray(e)&&(t={[o]:e[0],[i]:e[1]})),e.selected&&(n.value=t),t})):(o||(n.valueField=o="value"),s=[],Object.entries(e).forEach((([e,t])=>{s.push({[o]:e,[i]:t})}))),n.store)n.store.data=s;else{const e=o===i?{name:"value",dataSource:i}:o;if(!r){class t extends ws{static get idField(){return n.valueField}static set idField(e){super.idField=e}static get fields(){const t=[e,i];return n.localizeDisplayFields&&t.push("localeClass"),t}}r=t}n.store=new gl({isItemStore:!0,data:s,idField:o,verifyNoGeneratedIds:!1,modelClass:r,useRawData:!1})}}get value(){const e=this,{valueCollection:t,valueField:n}=e;if(null==n)return e.multiSelect?t.values.slice():t.first;let i;return i=e.multiSelect?t.count?t.map((e=>e[n])):e._lastValue||[]:t.count?t.first[n]:e._lastValue,i}set value(e){super.value=e}get needsInputSync(){return!this.usesChipView&&!this.editable}changeValue(e,t){const n=this;if(e===t)return void n.syncInputFieldValue(!0);if(!n.multiSelect&&Array.isArray(e)&&e.length>1)throw new Error("Multiple values cannot be set to a non-multiSelect Combo");var i;(n.triggerConfig("items"),n.inputting)||(null===(i=n._chipView)||void 0===i||i.selected.clear());n.store||(n.items=[]);const{valueField:r,displayField:s,store:o,valueCollection:a,_picker:l}=n,{storage:c}=o,d=n.hidePickerOnSelect??!n.multiSelect,u=n._isUserAction||(null==l?void 0:l._isUserAction)||d&&n.pickerVisible||!1;if(!n.remoteFilter&&o.isAjaxStore&&!o.count)return o.ion({load:()=>n.value=e,once:!0,thisObj:n}),void(n._lastValue=e);let h;if(null!=e){const i=Array.isArray(e),l=i?e.slice():[e];if(n.remoteFilter){if(null!=e){if(W.isObject(e)||e.isModel)o.getById(e.id)?n.valueCollection.splice(0,n.valueCollection.count,o.getById(e.id)):(o.data=[e],n.valueCollection.splice(0,n.valueCollection.count,o.first));else{const t=n.isConfiguring;n.primaryFilter.setConfig({value:e,disabled:!1}),o.performFilter(!0).then((()=>{if(n.isDestroyed)return;const{isConfiguring:e}=n;n.isConfiguring=t,a.splice(0,a.count,o.allRecords),n.isConfiguring=e}))}return}}else o.isFiltered?(o.isChained&&o.fillFromMaster(),n.primaryFilter.disabled=!0,o.filter()):o.isChained&&o.fillFromMaster();for(let e=0,t=l.length;e<t;e++){let n=l[e];if(n instanceof ws)c.includes(n,!0)||o.add(n);else{const i=W.isObject(n);i&&r&&(n=n[o.modelClass.fieldMap[r].dataSource]),h=c.getBy(s,n)||c.getBy(r,n)||a.getBy(s,n)||a.getBy(r,n),h instanceof Set&&(h=[...h][0]),h?(i&&h.set(l[e]),l[e]=h):(l.splice(e,1),t--,e--)}}const d=!l.length,g=a.generation;a.splice(0,a.count,l),d&&(n._value=i&&0===e.length?null:e,n._lastValue=n._value),(d||a.generation===g)&&n.syncInputFieldValue(),n.syncEmpty(),d&&!n.isConfiguring&&n.triggerFieldChange({value:e,oldValue:t,userAction:u,valid:n.isValid})}else if(a.count)a.clear();else{const t=n._value;n._value=null,n.syncInputFieldValue(),n.syncEmpty(),n.isConfiguring||n.triggerFieldChange({value:e,oldValue:t,userAction:u,valid:n.isValid})}n._lastValue=n._value}hasChanged(e,t){return this.multiSelect?!W.isEqual(e,t):super.hasChanged(...arguments)}onComboStoreChange({action:e}){"filter"!==e&&this.syncInputFieldValue(!0)}syncInputFieldValue(e){var t;this.usesChipView?null===(t=this.chipView)||void 0===t||t.refresh():super.syncInputFieldValue(e)}get usesChipView(){return Boolean(this.multiSelect&&this._chipView)}get isEmpty(){return 0===this.valueCollection.count}get inputValue(){const e=this;let t=e.selected?e.selected[e.displayField]:e.value;return e.displayValueRenderer&&(t=e.callback(e.displayValueRenderer,e,[e.selected,e])),null==t?"":t}get nonEditableClickTarget(){var e;return this.multiSelect&&(null===(e=this.chipView)||void 0===e?void 0:e.element)||super.nonEditableClickTarget}changeValueCollection(e,t){if(null==t||t.destroy(),e)return e.isCollection||(e=new Xs({internalListeners:{noChange:"onValueCollectionNoChange",change:"onValueCollectionChange",prio:-1e3,thisObj:this}})),e}changePrimaryFilter(e){return e.isCollectionFilter?e.setConfig({disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive}):("function"==typeof e&&(e={filterBy:e}),e=new _s({id:"primary",disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive,...e})),e}changeStore(e){const t=this,n=[],{valueCollection:i,keyStrokeFilterDelay:r,filterParamName:s}=t;if(Array.isArray(e))return void(t.items=e);let o;if(e){if(e.isStore){const i=e.filters.get("primary");t.remoteFilter&&(e.filterParamName=s),o=e.remoteFilter,i?t.primaryFilter=i:n.push(t.primaryFilter)}else"string"==typeof e?e=gl.getStore(e):(e=new(e.readUrl?yl:gl)(e),t.destroyStore=!0),o=t.remoteFilter||e.restfulFilter,o&&s&&(e.filterParamName=s,t.encodeFilterParams&&(e.encodeFilterParams=t.encodeFilterParams)),n.push(t.primaryFilter);if(t.valueField||t.usingRecordAsValue||(t.valueField=e.modelClass.idField),t.filterSelected){const r=e=>!t.containsFocus||!i.includes(e);o?(e.storage.autoFilter=!0,e.storage.addFilter({id:`${t.id}-selected-filter`,filterBy:r})):(n.push(r),e.reapplyFilterOnAdd=!0)}i.addIndex({property:t.displayField,unique:!1}),i.addIndex({property:t.valueField,unique:!0}),n.forEach((t=>e.addFilter(t,!0))),t.keyStrokeFilterDelay=o?Math.max(300,r||0):r??10}return e}updateStore(e,t){const n=this,{_picker:i}=n;let r;n.destroyStore&&t&&t.destroy(),i&&(i.store=e),e.storage.addIndex({property:n.displayField,unique:!1}),e.storage.addIndex({property:n.valueField,unique:!0}),r={filter:"onStoreFilter"},n.displayValueRenderer&&((r||(r={})).change="onComboStoreChange"),n.detachListeners("store"),(null==e?void 0:e.storage)&&n.valueCollection.match(e.storage),n.syncInputFieldValue(),r&&(r.name="store",r.thisObj=n,e.ion(r))}get remoteFilter(){var e;return Boolean(this.filterParamName||(null===(e=this._store)||void 0===e?void 0:e.restfulFilter))}get record(){return this.selected}get records(){return this.valueCollection.values.slice()}get selected(){const{store:e}=this;return this.multiSelect?this.valueCollection.values.slice().sort(((t,n)=>e.indexOf(t)-e.indexOf(n)))[0]:this.valueCollection.first}onEditComplete(){const e=this,t=e.valueCollection.count;super.onEditComplete(),t&&(e.clearError($g),e.syncInputFieldValue()),e.required&&!t&&e.setError(Lg)}onTriggerClick(e){const t=this,n="key"in e;if(!t.remoteFilter||!t.filterOnEnter)if(t.pickerVisible)t.hidePicker();else if(!t.readOnly&&!t.disabled){var i;switch(null===(i=t.triggerAction)||void 0===i?void 0:i.toLowerCase()){case"all":t.doFilter(null,n);break;case"last":t.doFilter(t.lastQuery,n);break;default:t.doFilter(t.input.value,n)}}}internalOnInput(e){const t=this;t.clearWhenInputEmpty&&""===t.input.value&&t.clear(),t.syncEmpty(),t.syncInputWidth(),t.filterOnInput(e),t.trigger("input",{value:t.input.value,event:e})}filterOnInput(e){const t=this,{value:n}="input"===e.type?e.target:t.input,i=n.length;t.inputting=!0,t.inlinePicker||i>=t.minChars&&(!t.filterOnEnter||"Enter"===e.key)?t.doFilter(n):(t.validateFilter&&!t.remoteFilter&&t[i?"setError":"clearError"]($g),t.hidePicker()),t.inputting=!1}syncInputWidth(){const e=this;if(e.usesChipView){const t=e.input,n=e._inputPadding||(e._inputPadding=Wn.getEdgeSize(t,"padding","lr")),i=t.value||"",r=Wn.measureText(i+"W",t,!1,e.element)+n.width;t.style.flex=`1 1 ${Math.ceil(r)}px`}}doFilter(e,t){var n;const i=this,{store:r,picker:s}=i,o=null==e||""===e;i.lastQuery=e,i.primaryFilter.setConfig({value:e,disabled:o}),i.remoteFilter&&r.clear(!0);const a=()=>{const{navigator:e,isVisible:t}=s;r.count?!o&&e&&(e.activeItem=0):i.remoteFilter||o||(e&&(e.activeItem=null),i.validateFilter&&i.setError($g)),t&&s.realign()};null===(n=i.filterPromise=r.filter())||void 0===n||n.then((()=>{i.filterPromise=null,a()})),i.inlinePicker||(null!=s&&s.isVisible?0===s.lastAlignSpec.zone&&s.realign():i.showPicker(t)),i.filterPromise||a()}onStoreFilter({source:e}){const t=this,n=t._picker,i=null==n?void 0:n.element.dataset,{count:r}=e;t.remoteFilter&&(r?n&&(n.navigator.activeItem=0):t.validateFilter&&t.setError($g),t.filterSelected&&t.valueCollection.count&&(e.storage.onFiltersChanged({action:"splice",oldCount:1}),n&&n.refresh())),i&&(t.createOnUnmatched&&!r&&null!=t.primaryFilter.value?i.addNewValue=t.L("L{addNewValue}")(t.primaryFilter.value):null==i||delete i.addNewValue)}onValueCollectionChange({source:e}){const t=this,{multiSelect:n,_picker:i}=t,r=t.hidePickerOnSelect??!n,s=n?e.values.slice():e.first,o=e.values.slice(),a=t._isUserAction||(null==i?void 0:i._isUserAction)||r&&t.pickerVisible||!1,l=t._value;if(r&&t.hidePicker(),n&&t.clearTextOnSelection&&(t.input.value=""),!e.count&&t.required?t.setError(Lg):(t.clearError(Lg),t.clearError($g)),t.validateFilter&&s&&t.clearError($g),t.filterSelected){var c;const e=null==i?void 0:i.navigator,n=Number(null==e||null===(c=e.activeItem)||void 0===c||null===(c=c.dataset)||void 0===c?void 0:c.index);t.remoteFilter?(t.store.storage.onFiltersChanged({action:"splice",oldCount:1}),t._picker&&t._picker.refresh()):t.store.filter(),isNaN(n)||(e.activeItem=Math.min(i.store.count,n))}t._value=null,t._lastValue=null;const d=t.cacheCurrentValue(t.value);var u;(t.syncInputFieldValue(),t.syncEmpty(),t.isConfiguring)||(d===l||t.onConfigChange.$nullFn||t.onConfigChange({name:"value",value:d,was:l,config:t.$meta.configs.value}),t.triggerFieldChange({value:d,oldValue:l,userAction:a,valid:t.isValid}),null===(u=t.trigger)||void 0===u||u.call(t,"select",{record:s,records:o,userAction:a}),"select"===t.defaultAction&&t.trigger("action",{value:d,record:s,records:o,userAction:a}))}cacheCurrentValue(e){return this._value=e}onValueCollectionNoChange({toAdd:e}){!this.inlinePicker&&!this.multiSelect&&e.length&&this.pickerVisible&&(this.picker.hide(),this.syncInputFieldValue())}showPicker(){const e=this,{picker:t}=e;if(!e.readOnly&&!e.inlinePicker){var n;if(t.multiSelect=e.multiSelect,super.showPicker(...arguments),e.overlayAnchor&&!t.align.offset&&(t.align.offset=-t.anchorSize[1],t.realign()),t.restoreActiveItem)if(e.multiSelect)t.restoreActiveItem((null===(n=t.navigator)||void 0===n?void 0:n.previousActiveItem)||e.selected||0,!0);else t.restoreActiveItem(e.selected||0,!0);e.input.focus()}}changePicker(e,t){if(e){var n;const i=this,r=i.pickerWidth||(null===(n=e)||void 0===n?void 0:n.width),s=Pg.mergeConfigs({owner:i,store:i.store,selected:i.valueCollection,multiSelect:i.multiSelect,cls:i.listCls,displayField:i.displayField,forElement:i.pickerAlignElement,align:{matchSize:null==r&&"min",anchor:i.overlayAnchor,target:i.pickerAlignElement,minHeight:i.inlinePicker?null:40*Math.min(3,i.store.count)},[i.listItemTpl?"itemTpl":void 0]:i.listItemTpl,width:r,navigator:{keyEventTarget:i.input}},e);i.inlinePicker&&Object.assign(s,{floating:!1,align:null,activateOnMouseover:!1,maxHeight:null,appendTo:i.element}),(e=Pg.reconfigure(t,e?s:null,i)).element.classList.add("b-combo-picker"),e.element.dataset.emptyText=i.emptyText?i.L(i.emptyText):i.L("L{noResults}"),e.ion({navigate:"onPickerNavigate",thisObj:i}),Xt.on({element:e.element,pointerdown:e=>i.onPickerNavigate({event:e}),thisObj:i})}else null==t||t.destroy();return e}onPickerNavigate({event:e}){e.target.matches("[data-add-new-value]")&&this.addNewRecord(this.primaryFilter.value)}onPickerHide(){const e=this;super.onPickerHide(),e.multiSelect&&e.clearTextOnPickerHide&&!e.errors&&(e.input.value="")}async internalOnKeyEvent(e){const t=this,n=t.input[t.inputValueAttr],i=n.length,{key:r}=e,{primaryFilter:s,store:o,multiSelect:a,minChars:l,_picker:c,_chipView:d}=t;let u;if("keydown"===e.type&&null!=c&&c.isVisible&&c.navigator){const{activeItem:i}=c.navigator;if(i&&a&&r===t.multiValueSeparator)return t.input.value="",c.onItemClick(i,e),s.setConfig({value:"",disabled:!0}),o.filter(),c.hide(),void e.preventDefault();if(!i&&t.createOnUnmatched&&(a&&r===t.multiValueSeparator||"Enter"===r))return e.preventDefault(),void await t.addNewRecord(n)}if(t.editable)!d||d.selected.count||"keydown"!==e.type||"Backspace"!==r||i||(d.navigator.activeItem=t.valueCollection.count-1,e.stopImmediatePropagation());else if(t.pickerVisible){var h;"Backspace"===r&&null!==(h=s.value)&&void 0!==h&&h.length?(s.value=s.value.substring(0,s.value.length-1),t.store.filter(),c.restoreActiveItem(0)):"keypress"===e.type&&r.match(_g)&&((!t.lastFilterKeypressTime||e.timeStamp-t.lastFilterKeypressTime>2e3)&&(s.value=""),s.setConfig({value:(s.value||"")+r,disabled:!1}),t.store.filter(),c.restoreActiveItem(0)),t.lastFilterKeypressTime=e.timeStamp}t.pickerVisible&&"Enter"===r&&t.primaryFilter.value===t.input.value&&(u=!0),super.internalOnKeyEvent(...arguments),"keydown"===e.type&&"Enter"===r&&!u&&t.remoteFilter&&(i>=l?(e.stopPropagation(),t.filterOnInput.now(e)):i>0&&(e.stopPropagation(),t.setError(`L{Field.tooShort} (${l})`,!1,!0)))}async addNewRecord(e){const t=this,{store:n,_picker:i,valueCollection:r,multiSelect:s,primaryFilter:o}=t,a=n.remoteFilter&&n.autoCommit;t.filterPromise&&await t.filterPromise,a||(o.setConfig({value:"",disabled:!0}),n.filter()),t._isUserAction=!0;const[l]=n.add(t.callback(t.createOnUnmatched,t,[e,t]));if(n.isCommitting){let e;try{await n.autoCommitTimeoutPromise,await n.commitPromise}catch(t){var c;e=null===(c=t.response)||void 0===c||null===(c=c.parsedJson)||void 0===c?void 0:c.error}l.isPhantom&&(t.clearError(),t.setError(e||"L{recordNotCommitted}",!1,!0),n.remove(l),n.removed.remove(l))}a&&(o.setConfig({value:"",disabled:!0}),n.filter()),t.input.value="",n.includes(l)&&r.splice(s?r.count:0,s?0:r.count,l),null==i||i.hide(),t._isUserAction=!1}changeCreateOnUnmatched(e){return!0===e&&(e=this.defaultRecordCreator),e}defaultRecordCreator(e){return this.store.createRecord({[this.displayField]:e})}updateLocalizeDisplayFields(e){e?this.localizableProperties.push("store"):$e.remove(this.localizableProperties,"store")}localizeProperty(e){return"store"===e?this.localizeStore():super.localizeProperty(e)}localizeStore(){const e=this,{displayField:t}=e;let{localizedDisplayFieldsMap:n}=e;n||(e.localizedDisplayFieldsMap=n=new Map),!e.store&&e.buildItems&&(e.items=e.buildItems());for(const r of e.items)if(r.id){var i;let s=n.get(r.id);!s&&null!==(i=r[t])&&void 0!==i&&i.startsWith("L{")&&(s=r[t],n.set(r.id,s)),s&&(r[t]=(r.localeClass||e).L(s))}e.sortItemsOnLocaleChange&&e.store.sort(),e.syncInputFieldValue()}createOverflowTwin(e){return super.createOverflowTwin({store:this.store,...e})}}class Bg extends Og{static $name="ComboChipView";static type="combochipview";static get defaultConfig(){return{closeHandler:"up.onChipClose",itemsFocusable:!1,multiSelect:!0,itemTpl(e){return H.encodeHtml(e.getValue(this.owner.displayField))},scrollable:{overflowY:"auto"}}}}jg.initClass(),Bg.initClass(),class extends Ch{static $name="ComboChipNavigator";static type="combochipnavigator";static get configurable(){return{allowShiftKey:!0}}onTargetClick(e){const t=this,n=e.target.closest(t.itemSelector);n&&!e.target.classList.contains("b-close-icon")&&(e.shiftKey||n.contains(e.target.closest("[data-noselect]"))||t.ownerCmp.selected.clear(),t.inClickHandler=!0,t.activeItem=n,t.inClickHandler=!1)}onKeyDown(e){"Enter"===e.key||e.target.selectionStart||e.target.selectionEnd||super.onKeyDown(e)}updateActiveItem(e,t){const n=this.ownerCmp;super.updateActiveItem(e,t),e&&!this.inClickHandler&&n.selected.add(n.getRecordFromElement(e))}navigatePrevious(e){const t=this.ownerCmp;t.navigator.activeItem&&!e.shiftKey&&t.selected.clear(),this.previous?super.navigatePrevious(e):this.activeItem=null}navigateNext(e){const t=this.ownerCmp;t.navigator.activeItem&&!e.shiftKey&&t.selected.clear(),this.next?super.navigateNext(e):this.activeItem=null}}.initClass(),jg._$name="Combo";class Hg extends jg{static $name="BooleanCombo";static type="booleancombo";static get configurable(){return{positiveValue:!0,positiveText:null,negativeValue:!1,negativeText:null,store:{value:[],$config:"lazy"},value:!1}}changeStore(e,t){const n=this;return super.changeStore(new gl({data:[{id:n.positiveValue,text:n.positiveText||n.L("L{Object.Yes}")},{id:n.negativeValue,text:n.negativeText||n.L("L{Object.No}")}]}),t)}}Hg.initClass(),Hg._$name="BooleanCombo";const Vg=({$toggleOrder:e},{$toggleOrder:t})=>(t||0)-(e||0),zg={click:"resetValueCache",beforeToggle:"onItemBeforeToggle",toggle:"onItemToggle"};class Ng extends(Nc.mixin(sd,wg)){static $name="ButtonGroup";static type="buttongroup";static configurable={defaultType:"button",cls:null,items:null,color:null,useGap:!1,toggleGroup:null,valueSeparator:",",columns:null,hideWhenEmpty:!0,defaultBindProperty:"value",errorTooltipCachePath:"buttonGroupErrorTooltip",errorTooltipConfig:{forSelector:".b-buttongroup.b-invalid"},overflowable:!0,toggleable:null};afterConstruct(){super.afterConstruct(),this.ion({change:"internalOnChange"})}get inputWrap(){return this.element}get isValid(){let e=super.isValid;const t=this,{toggleable:n}=t;return t.clearError("L{Field.fieldRequired}",!0),e&&!t.disabled&&(t.required&&!t.value||n&&t.pressed.length<n[0])&&(e=!1,t.setError("L{Field.fieldRequired}",!0)),t.checkValidity&&!1===t.callback(t.checkValidity,t,[t])&&(e=!1),e&&t.errors&&Object.keys(t.errors).length&&(e=!1),e}get pressed(){return this.items.filter((e=>e.pressed)).sort(Vg)}internalOnChange(){this.syncInvalid()}onChildAdd(e){super.onChildAdd(e),e.ion({thisObj:this,...zg,prio:1e4})}onChildRemove(e){e.un({thisObj:this,...zg}),super.onChildRemove(e)}onItemBeforeToggle({pressed:e}){const{toggleable:t}=this;return e||!t||this.pressed.length>t[0]}onItemToggle(e){const t=this,n=(t.toggleCount||0)+1,{toggleable:i}=t;t.resetValueCache(),t.isSettingValue||t.toggleGroup&&!e.pressed||(i&&(e.source.$toggleOrder=n,t.toggleCount=n,t.isSettingValue=!0,t.pressed.slice(i[1]).forEach((e=>e.pressed=!1)),t.isSettingValue=!1),t.triggerFieldChange({value:t.value,userAction:!0,event:e}))}resetValueCache(){this._value=null}createWidget(e){const t=this;return t.constructor.resolveType(e.type||"button").isButton&&(t.color&&!e.color&&(e.color=t.color),!e.toggleGroup&&t.toggleGroup&&(e.toggleGroup=t.toggleGroup),t.toggleable&&(e.toggleable=!0)),t.columns&&(e.width=100/t.columns+"%"),e=super.createWidget(e),t.relayEvents(e,["click","action","toggle"]),e}changeToggleable(e){return!0===e?e=[0,1/0]:"number"==typeof e&&(e=[1,e]),e||null}updateToggleable(e){e&&!this.isConstructing&&this.pressed.slice(e[1]).forEach((e=>e.pressed=!1))}changeToggleGroup(e,t){return!0===e?t||Ng.generateId("toggleGroup"):e}updateRotate(e){this.eachWidget((t=>{!1!==t.rotate&&(t.rotate=e)}))}get valueAsArray(){const e=[];return this.items.forEach((t=>{t.pressed&&void 0!==t.value&&e.push(t.value)})),e}get value(){const e=this;return e._value||(e._value=e.valueAsArray.join(e.valueSeparator)),e._value}set value(e){const t=this,n=t.value;null==e?e=[]:"string"==typeof e?e=e.split(t.valueSeparator):Array.isArray(e)||(e=[e]),t._value=e.join(t.valueSeparator),t.isSettingValue=!0,t.items.forEach((t=>{void 0!==t.value&&(t.pressed=e.includes(t.value))})),t.isSettingValue=!1,t.isConfiguring||n===t.value||t.triggerFieldChange({value:t.value,userAction:Boolean(t._isUserAction)})}get validity(){return{}}onDisabled(e){this.syncInvalid(),this.items.forEach((t=>t.disabled=e||!t.ignoreParentReadOnly&&this.readOnly))}updateReadOnly(e){super.updateReadOnly(e),this.updateDisabled(this.disabled)}addToOverflowMenu(e,t,n){const{toggleable:i,toggleGroup:r}=this;(r||1===(null==i?void 0:i[0])&&1===i[1])&&(t={...t,radio:!0}),this.items.forEach((i=>i.addToOverflowMenu(e,t,n)))}get widgetClassList(){const e=super.widgetClassList;return this.columns&&e.push("b-columned"),e}updateUseGap(e){e||this.element.classList.add("b-no-gap")}}Ng.initClass(),Ng._$name="ButtonGroup";const Wg={0:1,6:1};class Ug extends pu{static $name="CalendarPanel";static type="calendarpanel";static get configurable(){return{layout:"vbox",textContent:!1,date:{$config:"date"},month:{},year:null,weekStartDay:null,sixWeeks:!0,showWeekColumn:null,disabledDates:null,headerRenderer:null,weekRenderer:null,cellRenderer:null,disableWeekends:null,disableNonWorkingDays:null,hideNonWorkingDays:null,hideNonWorkingDaysCls:"b-hide-nonworking-days",nonWorkingDays:null,tip:null,dayCellCls:"b-calendar-cell",dayHeaderCls:"b-calendar-day-header",disabledCls:"b-disabled-date",otherMonthCls:"b-other-month",weekendCls:"b-weekend",todayCls:"b-today",nonWorkingDayCls:"b-nonworking-day",dayNameFormat:"ddd",minRowHeight:{$config:["lazy"],value:null},minColumnWidth:{$config:["lazy"],value:null},disableOtherMonthCells:null,disableOtherMonthCellsCls:"b-disable-othermonth-cells",hideOtherMonthCells:null,hideOtherMonthCellsCls:"b-hide-othermonth-cells",animateTimeShift:!0}}construct(e){super.construct(e),this.refreshCount||this.refresh()}onInternalPaint({firstPaint:e}){var t;null===(t=super.onInternalPaint)||void 0===t||t.call(this,...arguments),e&&(this.refreshCount||this.refresh(),this.getConfig("minColumnWidth"),this.getConfig("minRowHeight"))}get overflowElement(){return this.weeksElement}doDestroy(){var e;null===(e=this.tip)||void 0===e||e.destroy(),super.doDestroy()}updateMinRowHeight(e){this.element.style.setProperty("--min-row-height",Wn.setLength(e)),this.scrollable={overflowY:!!e&&"auto"}}updateMinColumnWidth(e){const t=this;t.element.style.setProperty("--min-column-width",Wn.setLength(e)),t.scrollable={overflowX:!!e&&"auto"},t.overflowElement.classList[e?"add":"remove"]("b-min-columnwidth")}getDateFromDomEvent(e){const t=(e.nodeType===Element.ELEMENT_NODE?e:e.target).closest(`#${this.id} [data-date]`);if(t)return fr.parseKey(t.dataset.date)}changeTip(e,t){const n=this;return Cg.reconfigure(t,e,{owner:n,defaults:{type:"tooltip",owner:n,id:`${n.id}-cell-tip`,forElement:n.bodyElement,forSelector:`.${n.dayCellCls}`}})}updateTip(e){this.detachListeners("tip"),null==e||e.ion({pointerOver:"onTipOverCell",name:"tip",thisObj:this})}updateElement(e,t){const n=this;super.updateElement(e,t),n.updateHideNonWorkingDays(n.hideNonWorkingDays),n.weekdayCells=Array.from(e.querySelectorAll(".b-calendar-day-header")),n.weekElements=Array.from(e.querySelectorAll(".b-calendar-week")),n.weekDayElements=Array.from(e.querySelectorAll(".b-calendar-days")),n.cellElements=[];for(let e=0,{length:t}=n.weekDayElements;e<t;e++)n.cellElements.push(n.weekDayElements[e].previousSibling,...n.weekDayElements[e].children)}changeDate(e){if(e="string"==typeof e?fr.parse(e):new Date(e),isNaN(e))throw new Error("CalendarPanel date ingestion must be passed a Date, or a YYYY-MM-DD date string");return fr.clearTime(e)}updateDate(e){this.month.date=e,this.element.dataset.month=fr.format(e,"YYYY-MM")}updateDayNameFormat(){const e=new Date("2000-06-04T12:00:00");this.shortDayNames=[];for(let t=4;t<11;t++)e.setDate(t),this.shortDayNames.push(fr.format(e,this.dayNameFormat))}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:fr.weekStartDay}updateWeekStartDay(e){const t=this;if(t._month){t.month.weekStartDay=e,t.dayNames=[];for(let e=0;e<7;e++)t.dayNames[e]=t.shortDayNames[t.canonicalDayNumbers[e]];t.refreshCount&&t.refresh()}}updateHideNonWorkingDays(e){var t;this.contentElement.classList.toggle(this.hideNonWorkingDaysCls,Boolean(e)),null===(t=this.scrollable)||void 0===t||t.syncOverflowState(),this._month&&(this.month.hideNonWorkingDays=e),this.isConfiguring||this.refresh()}updateHideOtherMonthCells(e){var t;this.element.classList.toggle(this.hideOtherMonthCellsCls,Boolean(e)),null===(t=this.scrollable)||void 0===t||t.syncOverflowState()}updateDisableOtherMonthCells(e){var t;this.element.classList.toggle(this.disableOtherMonthCellsCls,Boolean(e)),null===(t=this.scrollable)||void 0===t||t.syncOverflowState()}get nonWorkingDays(){return this._nonWorkingDays||this._localeNonWorkingDays||(this._localeNonWorkingDays=fr.nonWorkingDays)}get weekends(){return this._localeWeekends||(this._localeWeekends=fr.weekends)}changeNonWorkingDays(e){return W.assign({},e)}updateNonWorkingDays(e){var t;this._month&&(this.month.nonWorkingDays=e,this.refresh(),null===(t=this.scrollable)||void 0===t||t.syncOverflowState())}get visibleDayColumnIndex(){return this.month.visibleDayColumnIndex}get dayColumnIndex(){return this.month.dayColumnIndex}get canonicalDayNumbers(){return this.month.canonicalDayNumbers}get visibleColumnCount(){return this.month.visibleColumnCount}get weekLength(){return this.month.weekLength}get startDate(){return this.month.startDate}get duration(){return fr.diff(this.month.startDate,this.month.endDate,"day")+1}get endDate(){const{endDate:e}=this.month;if(e)return fr.add(e,1,"day")}changeMonth(e,t){const n=this;if(!(e instanceof qh)){if("number"==typeof e){if(t)return void(t.month=e);const i=n.date||fr.clearTime(new Date);i.setMonth(e),e={date:i}}e=qh.new({weekStartDay:n.weekStartDay,nonWorkingDays:n.nonWorkingDays,hideNonWorkingDays:n.hideNonWorkingDays,sixWeeks:n.sixWeeks},e)}return e.ion({dateChange:"onMonthDateChange",thisObj:n}),e}onMonthDateChange({source:e,newDate:t,oldDate:n,changes:i}){const r=this;if(r.year=e.year,!r.isConfiguring){if(!r.getCell(t)||i.m||i.y){const{isVisible:e}=r;r.refresh(),r.animateTimeShift&&e&&Wn.slideIn(r.contentElement,t>n?1:-1)}r.trigger("dateChange",{changes:i,value:t,oldValue:n})}}updateYear(e){this.month.year=e}updateShowWeekNumber(e){this.updateShowWeekColumn(e)}updateShowWeekColumn(e){const t=this;t.element.classList[e?"add":"remove"]("b-show-week-column"),t.floating&&(t.isAligning||t.realign())}updateSixWeeks(e){this.month&&(this.month.sixWeeks=e,this.refresh())}refresh(){this.doRefresh()}doRefresh(){var e;this.getConfig("element");const t=this,n=null!=t.timeZone?t.timeZone:null===(e=t.project)||void 0===e?void 0:e.timeZone,i=null!=n?Ku.toTimeZone(new Date,n):new Date,{weekElements:r,weekDayElements:s,date:o,month:a,dayCellCls:l,dayHeaderCls:c,disabledCls:d,otherMonthCls:u,weekendCls:h,todayCls:g,nonWorkingDayCls:m,nonWorkingDays:p,canonicalDayNumbers:f,sixWeeks:v}=t;if(i.setHours(0,0,0,0),!o)return void(t.date=i);t.element.style.setProperty("--visible-week-count",a.weekCount),t.trigger("beforeRefresh"),t.getConfig("dayNameFormat");for(let e=0;e<7;e++){const n=t.weekdayCells[e],i=t.canonicalDayNumbers[e],r={[c]:1,[h]:Wg[i],[m]:p[i]};t.headerRenderer?(n.innerHTML="",t.callback(t.headerRenderer,t,[n,e,i])):Wn.setInnerText(n,t.shortDayNames[i]),Wn.syncClassList(n,r),n.dataset.columnIndex=e,n.dataset.cellDay=i}let y=0,b=0,C=6;for(let e=6;e>=0;e--)if(!p[f[e]]){C=e;break}r[4].classList.toggle("b-hide-display",a.weekCount<5&&!v),r[5].classList.toggle("b-hide-display",a.weekCount<6&&!v),a.eachWeek(((e,n)=>{const o=s[y],c=[o.previousSibling,...o.children];r[y].dataset.week=`${e[0]},${e[1]}`,t.weekRenderer?t.callback(t.weekRenderer,t,[c[0],e]):c[0].innerText=e[1];for(let s=0;s<7;s++){const o=n[s],f=o.getDay(),v=fr.makeKey(o),S=p[f],D=c[s+1],w={[l]:1,[d]:t.isDisabledDate(o),[u]:o.getMonth()!==a.month,[h]:Wg[f],[g]:o.getTime()===i.getTime(),[m]:S,"b-last-working-day":s===C,"b-first-visible-cell":!(o-(t.firstVisibleDate||-1)),"b-last-visible-cell":!(o-(t.lastVisibleDate||-1)),[`b-day-of-week-${f}`]:1};Wn.syncClassList(D,w),D.dataset.date=v,D.dataset.cellIndex=b,D.dataset.columnIndex=s,D.lastDomConfig&&(delete D.lastDomConfig.class,delete D.lastDomConfig.className),t.cellRenderer?t.callback(t.cellRenderer,t,[{cell:D,date:o,day:f,rowIndex:y,cellIndex:b,columnIndex:s,key:v,week:e,row:r[y],source:t,visibleColumnIndex:t.visibleDayColumnIndex[f]}]):D.innerHTML=o.getDate(),b++}y++})),t.visibleWeekCount=y,t.floating&&(t.isAligning||t.realign()),t.refreshCount=(t.refreshCount||0)+1,t.trigger("refresh")}isDisabledDate(e){const t=this,n=e.getDay(),{disabledDates:i}=t;return!(!t.disableWeekends||!Wg[n])||(!(!t.disableNonWorkingDays||!t.nonWorkingDays[n])||(i?Array.isArray(i)?(e=fr.clearTime(e,!0),i.some((t=>!(fr.clearTime(t,!0)-e)))):t.callback(i,t,[e]):void 0))}get bodyConfig(){const e=super.bodyConfig,t=[];e.children=[{tag:"div",className:"b-calendar-row b-calendar-weekdays",reference:"weekdaysHeader",children:[{class:"b-week-number-cell"},...$e.fill(7,{class:this.dayHeaderCls}),Wn.scrollBarPadElement]},{className:"b-weeks-container notranslate",reference:"weeksElement",tabIndex:-1,children:t}];for(let e=0;e<6;e++){const n={className:"b-calendar-row b-calendar-week",dataset:{rowIndex:e},children:[{className:"b-week-number-cell"},{className:"b-calendar-days",children:[{},{},{},{},{},{},{}],syncOptions:{ignoreRefs:!0,strict:!1}}]};t.push(n)}return e}get firstVisibleDate(){if(this.hideOtherMonthCells){const{year:e,month:t}=this.month;return new Date(e,t,1)}for(const e=this,t=e.month.startDate;;t.setDate(t.getDate()+1))if(!e.hideNonWorkingDays||!e.nonWorkingDays[t.getDay()])return t}get lastVisibleDate(){const e=fr.add(this.endDate,-1,"d");if(this.hideOtherMonthCells)return e;for(const t=this,n=e;;n.setDate(n.getDate()-1))if(!t.hideNonWorkingDays||!t.nonWorkingDays[n.getDay()])return n}getCell(e,t){"string"!=typeof e&&(e=fr.makeKey(e));const n=this.weeksElement.querySelector(`[data-date="${e}"]`);if(n&&(!t||!n.classList.contains(this.otherMonthCls)))return n}onTipOverCell({source:e,target:t}){e.date=fr.parseKey(t.dataset.date)}updateLocalization(){this._localeNonWorkingDays=this._localeWeekends=null,this.updateDayNameFormat(),this.updateWeekStartDay(this.weekStartDay),super.updateLocalization()}}Ug.initClass(),Ug._$name="CalendarPanel";const{abs:Gg,ceil:Yg,floor:qg,max:Kg,min:Xg}=Math,Zg="b-carousel-item",Jg=[0,0],Qg=Symbol("carouselIndex"),em=Symbol("carouselSyncGen"),tm="b-carousel-reserve",nm=`${tm}-before`,im=`${tm}-after`,rm=(e,t)=>e[Qg]-t[Qg],sm="b-carousel-visible",om=["x","y"],am=["y","x"],lm={h:{minSize:"minWidth",offsetPos:"offsetLeft",offsetSize:"offsetWidth",size:"width",vxy:["vx","vy"],xy:om},v:{minSize:"minHeight",offsetSize:"offsetHeight",size:"height",vxy:["vy","vx"],xy:am}};lm.h.other=lm.v,lm.v.other=lm.h;class cm extends(pu.mixin(ch,bh)){static $name="Carousel";static type="carousel";static configurable={atMax:null,atMin:null,configureSlot:(e,t,n)=>({}),disableReserveSlots:null,empty:null,emptyHtml:null,emptyText:"No items to display",firstVisibleSlot:null,lastVisibleSlot:null,range:[null,null],reserveSlots:1,scrollOnTab:null,shrinkWrap:"auto",slots:null,snap:!0,vertical:null};static delayable={triggerSlotVisibility:"raf"};static fenced={resync:!0};compose(){const{carouselClasses:e}=this;return{class:{...e}}}get allSlots(){return this.ensureItems().values.filter((e=>e.innerItem)).sort(rm)}get bodyConfig(){const{carouselClasses:e,emptyHtml:t,emptyText:n}=this,i=super.bodyConfig;return W.merge(i,{className:{"b-vbox":1,...e},children:{innerCt:{class:{"b-carousel-inner-ct":1,"b-box-center":1}},emptyElement:{class:{"b-carousel-empty-text":1,"b-box-center":1},html:t||H.xss`${n}`}}})}get carouselClasses(){const{empty:e,vertical:t}=this;return{"b-carousel-empty":e,"b-carousel-vertical":t}}get contentElement(){return this.innerCt}get currentIndex(){return this.indexFromPos(this.scrollPos)}set currentIndex(e){this.goto(e)}get focusedSlot(){const{innerCt:e}=this;let t,n,i=null;for(t=Wn.getActiveElement();t;t=n)if(n=t.parentElement,n===e){i=Tc.fromElement(t);break}return i}get infinityScrollerDefaults(){const e=this,[t,n]=e.vertical?am:om;return W.merge(super.infinityScrollerDefaults,{snap:e.snap&&t,[t]:{overflow:"hidden-scroll",range:e.scrollRange,pos:0},[n]:{overflow:"hidden"}})}get propNames(){return lm[this.vertical?"v":"h"]}get scrollAxis(){return this.infinityScroller[this.vertical?"y":"x"]}get scrolling(){return this.infinityScroller.scrolling}get scrollPos(){return this.scrollAxis.pos}set scrollPos(e){this.scrollAxis.pos=e}get scrollRange(){const{range:e,slotSize:t}=this;return t?[e[0]*t,e[1]*t]:[0,1/0]}get shrinkWrap(){const e=this._shrinkWrap;return"auto"===e?"absolute"===Wn.getStyleValue(this.element,"position"):e}get lastVisibleIndex(){var e;return null===(e=this.lastVisibleSlot)||void 0===e?void 0:e[Qg]}get visibleSlots(){return this.allSlots.filter((e=>e.element.classList.contains(sm)))}updateAtMax(e){this.element.classList.toggle("b-carousel-at-max",e)}updateAtMin(e){this.element.classList.toggle("b-carousel-at-min",e)}changeConfigureSlot(e){if("string"==typeof e){const t=`_${e}Fn`;return this[t]||(this[t]=(...t)=>this[e](...t))}return e}triggerSlotVisibility(){const{firstVisibleSlot:e,lastVisibleSlot:t}=this;this.trigger("slotVisibility",{firstVisibleSlot:e,lastVisibleSlot:t})}updateFirstVisibleSlot(e){this.triggerSlotVisibility()}updateLastVisibleSlot(){this.triggerSlotVisibility()}changeRange(e){if((e=e?[e[0]??-1/0,e[1]??1/0]:[0,0])[0]!==e[1]){let t;if(e[1]<e[0]&&(t="denormalized"),t)throw new Error(`Invalid carousel range [${e[0]}, ${e[1]}): ${t}`)}return e}updateRange(e){this.empty=!(e[0]<e[1]),this.syncSoon()}updateShrinkWrap(){this.isPainted&&this.syncSoon()}updateVertical(){this.isPainted&&this.syncSoon()}convertIndexPos(e,t){const n=this,{allSlots:i,propNames:r}=n,[s,o]=n.range,a=Math.floor((s+o)/2),l=i.length,c=i[l-1],d=r.vxy[0],u=s<=0&&0<o;if(!(t||s<=e&&e<o))return null;let h,g,m,p,f,v,y,b,C=n.slotSize||100;if(l){for(b of(C=0,i)){if(m=b[Qg],h=b[d],C=C||b.$vxy[r.size],b===i[0]&&(p=m,y=h,e<(t?h:m)))break;if(t){if(e===h)return m;if(e<h)return m-1}else if(e===m)return h;if(b===c){if(g=h+b.$vxy[r.size],t&&e<g)return m;f=m+1,v=g}}C=C||n.slotSize||100}else{if(t&&0<=e&&e<C)return u?0:a;y=0,v=C,p=u?0:a,f=p+1}return t?e<y?Kg(p-Yg((y-e)/C),s):Xg(f+qg((e-v)/C),o):e<p?y-(p-e)*C:v+(e-f)*C}ensurePlan(e){return e}ensureVisible(e){const t=this;if(null==t.lastScrollPos)t._afterSync=()=>t.ensureVisible({...e,animate:!1});else{if(!t.scrolling||!t.hasPainted){const{index:n,animate:i}=t.ensurePlan(e),{currentIndex:r,lastVisibleIndex:s}=t;let o;return n<r?o=n-r:s<n&&(o=n-s),o&&t.go(o,i)}t._afterScroll=()=>t.ensureVisible(e)}}getSlotIndex(e){return null==e?void 0:e[Qg]}indexFromPos(e){return this.convertIndexPos(e,!0)}posFromIndex(e){return this.convertIndexPos(e,!1)}slotFromIndex(e){for(const t of this.allSlots)if(t[Qg]===e)return t;return null}backward(e){return this.go(-1,e)}forward(e){return this.go(1,e)}go(e,t){return this.goto(this.currentIndex+e,t)}goto(e,t){const n=this;if(null==n.lastScrollPos)n._afterSync=()=>{const{scrollPos:t}=n;n.goto(e,!1),n.hasPainted||t===n.scrollPos||n.sync()};else{if(!n.scrolling||!n.hasPainted){const{range:i,slots:r}=n,s=i[1]-("number"==typeof r?r-1:0),o=Xg(s-1,Kg(i[0],e)),a=Gg(n.currentIndex-o),l=n.posFromIndex(o);return a>=n.allSlots.length&&(t=!1),n.scrollTo({animate:t,[n.scrollAxis.name]:l})}n._afterScroll=()=>n.goto(e,t)}}onChildAdd(e){return e.innerItem&&e.element.classList.add(Zg),super.onChildAdd(e)}onChildRemove(e){return e.innerItem&&e.element.classList.remove(Zg),super.onChildRemove(e)}onInfiniteScrollEnd(e){super.onInfiniteScrollEnd(e);const{_afterScroll:t}=this;this._afterScroll=null,null==t||t()}onSlotFocusTrap({source:e,top:t}){const n=this,i=t?-1:1,r=e[Qg],s=n.slotFromIndex(r+i);return s.element.classList.contains(tm)?n.scrollOnTab&&n.go(i).then((e=>{var t;e&&(null===(t=s.element)||void 0===t||t.focus())})):s.element.focus(),!1}resync(){this.sync()}sync(){if(this.syncCount=(this.syncCount||0)+1,!this.empty){var e;const t=this,{allSlots:n,disableReserveSlots:i,innerCt:r,scrollAxis:s,propNames:o,reserveSlots:a,slots:l}=t,[c,d]=t.range,u=s.pos,h=Tc.resolveType((null===(e=t.defaults)||void 0===e?void 0:e.type)||t.defaultType),g=t.indexFromPos(u),m=t.posFromIndex(g),p=u-m,f=[a,a],v=t.syncGen=(t.syncGen||0)+1;t.scrolling&&u>(t.lastScrollPos||0)&&p&&(--f[0],++f[1]),t.lastScrollPos=u,r.style.setProperty("--carousel-item-offset",`${Math.abs(p)}px`),t.shrinkWrapped||(r.style[o.minSize]="");let y,b,C,S,D=r[o.offsetSize],w=!1,E=!1,R=null,x=null;t.unanimated((()=>{const{_afterSync:e}=t,a=l&&"auto"!==l?t.syncFixed(g,o,n,h,f,l,c,d):t.syncDynamic(g,o,n,h,f,l,D,c,d),m=[],p=n.filter((e=>e[em]!==v));for(S of(p.length&&(p.forEach((e=>t.detachListeners(`${e.id}-listeners`))),t.remove(p)),r.style[o.other.minSize]=`${a[o.other.size]}px`,D=r[o.offsetSize],n))if(!p.includes(S)){const e=s.getItemSpan(S),t=u+D,n=e[1]<=u,i=t<=e[0],r=!n&&!i,o=r&&e[0]<=u,a=r&&e[1]>=t;r&&(S[Qg]===c&&(E=!0),S[Qg]===d-1&&(w=!0)),o&&(R=S),a&&(x=S),m.push([S,S.element.classList,{[tm]:n||i,[nm]:n,"b-carousel-first":o,[sm]:r,"b-carousel-last":a,[im]:i}])}for([S,y,C]of m)for(b in i&&(S.disabled=!C[sm]&&i),C)y.toggle(b,C[b]);t.atMax=w,t.atMin=E,t.firstVisibleSlot=R,t.lastVisibleSlot=x,s.other.range=Jg,t.syncDomOrder(p.length?t.allSlots:n),s.sync({range:t.scrollRange}),s.pos!==u?t.resync():e&&(t._afterSync=null,e())}))}}syncDomOrder(e){var t;const n=Wn.getActiveElement();let i,r,s;for(s=e.length;s-- >1;)r=e[s].element,i||r.classList.add("b-last-visible-child"),i=e[s-1].element,i.classList.remove("b-last-visible-child"),r.classList.remove("b-first-visible-child"),i.nextSibling!==r&&i.parentElement.insertBefore(i,r);null===(t=i)||void 0===t||t.classList.add("b-first-visible-child"),this.element.contains(n)&&n!==Wn.getActiveElement()&&n.focus()}syncDynamic(e,t,n,i,r,s,o,a,l){const c=this,{offsetSize:d}=t,u="auto"===s,h=u?"":null;let g,m,p,[f,v]=r,y=1,b=0;for(p=e;a<=p&&p<l;p+=y){if(m=c.syncSlot(n,i,p,h),g=g||m,b<o){if(b+=m.element[d],u)return c.syncFixed(e,t,n,i,r,Yg(o/b));if(y>0){if(p+1<l&&(b<o||v))continue;f+=v,v=0}}if(--v<1){if(y<0||!f)break;y=-1,p=e,v=f}}return g}syncFixed(e,t,n,i,r,s,o,a){const l=this,{shrinkWrap:c,shrinkWrapped:d}=l,u=100/s+"%",h=e+s;let g,m,p,f,v,y=e-r[0],b=h+r[1],C=0;for(;b>a;)--y,--b;for(;y<o;)++y,++b;for(v=y;v<b;++v)m=l.syncSlot(n,i,v,c&&!d?"":u),v===e&&(g=m),c?(p||(p=[])).push(m):m[t.size]=u;if(c){for(f=Xg(h,b-r[1]),v=f-s;v<f;++v)C+=p[v-y][t.size];for(m of p)m[t.size]=u;C&&(l.innerCt.style[t.minSize]=`${C}px`,l.shrinkWrapped=!0)}return g}syncSlot(e,t,n,i){const r=this,{propNames:s,syncGen:o}=r,a=null!==i;let l,c,d,u,h,g=null;for(u of e)if(u[em]!==o){if(c=u[Qg],c===n){d=u,a&&(d[s.size]=i);break}(!g||c>g[Qg])&&(g=u)}return d||(l=r.configureSlot(n,r,g),g?(d=g,a&&(d[s.size]=i),delete l.type,d.setConfig(l)):(h=l.type?Tc.resolveType(l.type):t,l=h.mergeConfigs(r.defaults,l),a&&(l[s.size]=i),d=r.add(l),e.push(d),d.ion({thisObj:r,name:`${d.id}-listeners`,focusTrap:"onSlotFocusTrap"})),d[Qg]=n,r.slotSize||(r.slotSize=d[s.size]),d[s.vxy[0]]=n*r.slotSize),d[em]=o,d}}cm.initClass(),cm._$name="Carousel";const dm=e=>!e.value;class um extends Ig{static $name="Checkbox";static type="checkbox";static alias="check";static get configurable(){return{inputType:"checkbox",autoCollapse:null,toggleGroupRootElement:null,containerDefaults:{syncableConfigs:{disabled:e=>e.disabled||!e.value},syncConfigTriggers:{autoCollapse:1,value:1}},text:"",checkedValue:!0,uncheckedValue:!1,color:null,value:"",toggleGroup:null,localizableProperties:["label","text"],twinSyncConfigs:{value:"checked"}}}construct(e){"checked"in e&&((e=W.assign({},e)).value=e.checked,delete e.checked),super.construct(e),this.syncHasText()}get textLabelCls(){return"b-checkbox-label"}get innerElements(){return[this.inputElement,{tag:"label",class:this.textLabelCls,for:`${this.id}-input`,reference:"textLabel",html:this.text||""}]}get inputElement(){const e=super.inputElement;return this.toggleGroup&&(e.dataset={group:this.toggleGroup}),e.listeners={click:"internalOnClick",change:"internalOnChange",input:"internalOnInput"},e}get checked(){return this.value}set checked(e){this.value=e}syncHasText(){this.element.classList[this.text?"add":"remove"]("b-text")}updateText(e){this.textLabel&&(this.syncHasText(),this.textLabel.innerHTML=e)}afterSyncChildConfigs(e){super.afterSyncChildConfigs(e);let{autoCollapse:t}=this;t&&(t=!0===t?dm:t,e.collapsed=t(this))}assignFieldValue(e,t,n){this.value=n===this.checkedValue||n!==this.uncheckedValue&&null}fetchInputValue(){this.readOnly||(this.value=this.input.checked)}gatherValue(e){var t;const n=this,i=n.value?n.checkedValue:n.uncheckedValue,r=void 0!==i,{valueName:s}=n;r&&(e[s]=i),n.gatherValues(e,r),!0===i&&(null===(t=e[s])||void 0===t?void 0:t.value)===i&&delete e[s].value}changeValue(e){return"false"!==e&&Boolean(e)}updateValue(e){var t;const n=this,i=n.input.checked!==e;n.input.checked=e,null===(t=n.container)||void 0===t||t.syncChildConfigs(),!i||n.inputting||n.isConfiguring||(n.uncheckToggleGroupMembers(),n.triggerChange(!1,null))}get inputValueAttr(){return"checked"}updateColor(e,t){const n=this.element.classList;t&&n.remove(t),e&&n.add(e)}getToggleGroupRootElement(){const e=this.toggleGroupRootElement;let t;return e&&"string"==typeof e&&this.element&&(t=this.element.closest(e)),t||this.rootElement}getToggleGroupMembers(){const e=this,{toggleGroup:t,input:n,type:i}=e,r=[];return t&&Wn.forEachSelector(e.getToggleGroupRootElement(),`input[type=${i}][data-group=${t}]`,(e=>{if(e!==n){const t=Tc.fromElement(e);t&&r.push(t)}})),r}uncheckToggleGroupMembers(e){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach((e=>{e._propagatingUserActionFrom=this,e.checked=!1,e._propagatingUserActionFrom=null}))}check(){this.checked=!0}uncheck(){this.checked=!1}toggle(){this.checked=!this.checked}internalOnClick(e){return this.readOnly?(e.preventDefault(),!1):this.trigger("click",{event:e})}internalOnChange(e){const t=this;t.readOnly&&t.value!==t.input.checked?t.input.checked=t.value:(t.value=t.input.checked,t.inputting||(t.inputting=!0,t.triggerChange(!0,e),t.inputting=!1))}updateInputReadOnly(e){}triggerChange(e,t){const n=this,{checked:i}=n.input,r={checked:i,value:i,oldValue:!i,userAction:e,valid:!0,event:t};n._propagatingUserActionFrom&&(r.propagatingUserActionFrom=n._propagatingUserActionFrom);if(!(!i&&e&&n.toggleGroup&&n.getToggleGroupMembers().filter((e=>e.isVisible&&!e.disabled)).length||!1===n.trigger("beforeChange",r)))return n.triggerFieldChange(r,!1),e&&n.uncheckToggleGroupMembers(e),n.trigger("action",r),n.trigger("change",r),!0;n.input.checked=n._value=!i}configureOverflowTwin(e){const t=this,n=super.configureOverflowTwin(e);return n.type=Tc.resolveType("menuitem"),n.text||(n.text=t.label||t.text||t.tooltipText),n}}let hm;um.initClass(),um._$name="Checkbox";class gm extends pu{static $name="CodeEditor";static type="codeeditor";static configurable={textContent:!1,scrollable:null,codePath:null,editor:{$config:["lazy","nullify"],value:{automaticLayout:!0,scrollBeyondLastLine:!1}},header:{cls:"demo-header"},bbar:{overflow:null,items:{readOnly:{hidden:!0,type:"widget",cls:"b-icon b-icon-locked"},status:{type:"widget",html:" "},cursorPos:{type:"widget",html:" ",setPosition({lineNumber:e,column:t}){this.element.innerHTML=`Ln ${e}, Col ${t}`}}}},readOnly:null,text:{$config:["lazy","nullify"],value:null},language:null,theme:null,status:null};construct(e={}){const t=this;t.editorReady=new Promise(((e,n)=>{t.resolveEditorReady=e,t.rejectEditorReady=n})),super.construct(...arguments),t.editorReady.then((()=>{ti.ion({theme:({theme:e})=>t.editor.updateOptions({theme:e.toLowerCase().includes("dark")?"vs-dark":"vs-light"}),thisObj:t}),t.element.style.setProperty("--vscode-menu-background",getComputedStyle(t.element.querySelector(".monaco-editor")).getPropertyValue("--vscode-menu-background"))}))}get monacoInstance(){return globalThis.monaco}focus(){this.editor.focus()}static set monacoLoadPromise(e){hm=e}static get monacoLoadPromise(){return hm}async updateCodePath(e,t){const n=this;var i;t&&(null===(i=n.loaderScript)||void 0===i||i.remove());hm||(hm=new Promise((t=>{const i=()=>{const o=globalThis.require;o.config({paths:{vs:`${e}/min/vs`}}),o(["vs/editor/editor.main"],(function(){n.isDestroyed||t(globalThis.monaco)})),s.removeEventListener("error",r),s.removeEventListener("load",i)},r=()=>{const t=`Code editor path to Monaco editor ${e} is incorrect`;s.removeEventListener("error",r),s.removeEventListener("load",i),Xu.show(t),n.rejectEditorReady(t)},s=n.loaderScript=Wn.createElement({tag:"script",parent:document.head,src:`${e}/min/vs/loader.js`});s.addEventListener("error",r),s.addEventListener("load",i)}))),globalThis.monaco=await hm,n.getConfig("editor"),n.getConfig("text")}updateReadOnly(e){const{readOnly:t}=this.widgetMap;t&&(t.hidden=!e),this.editor.updateOptions({readOnly:e})}updateStatus(e){const{status:t}=this.widgetMap;t&&(t.html=e)}changeEditor(e,t){var n;const i=this;var r;(null==t||null===(n=t.dispose)||void 0===n||n.call(t),e)&&(e=i.monacoInstance.editor.create(i.contentElement,ce.merge({theme:i.theme||null!==(r=Wn.themeInfo)&&void 0!==r&&r.name.toLowerCase().includes("dark")?"vs-dark":"vs-light",padding:{top:14}},e)),i.monacoInstance.languages.typescript.javascriptDefaults.setDiagnosticsOptions({noSuggestionDiagnostics:!0}),e.onDidChangeCursorPosition(i.onCursorMove.bind(i)),e.onDidChangeConfiguration(i.onEditorConfigChange.bind(i)),e.onDidDispose(i.onEditorDestroy.bind(i)),i.resolveEditorReady(e));return e}get text(){var e;return(null===(e=this.codeModel)||void 0===e?void 0:e.getValue())||this._text}changeText(e){var t;return this._text=null===(t=this.codeModel)||void 0===t?void 0:t.getValue(),e}updateText(e){const{codeModel:t}=this;var n,i;null!=e?t?t.setValue(e):this.loadText(e):null===(n=this.codeModel)||void 0===n||null===(i=n.dispose)||void 0===i||i.call(n)}async loadText(e=this.text,t=this.language){var n;const i=this;i._text=e,i._language=t,null===(n=i.codeModel)||void 0===n||n.dispose(),await i.editorReady;const r=i.codeModel=i.monacoInstance.editor.createModel(e,t);return i.editor.setModel(r),i.trigger("load",{model:r,text:e}),r}onEditorDestroy(){var e,t;null===(e=this.codeModel)||void 0===e||null===(t=e.dispose)||void 0===t||t.call(e),this.codeModel=null}onEditorConfigChange(){const e=this;e.editor&&(e.readOnly=e.editor.getOptions().get(e.monacoInstance.editor.EditorOptions.readOnly.id))}onCursorMove({position:e}){var t;null===(t=this.widgetMap.cursorPos)||void 0===t||t.setPosition(e)}}gm.initClass(),gm._$name="CodeEditor";class mm extends Pg{static $name="ColorPicker";static type="colorpicker";static configurable={itemsFocusable:!1,navigator:{focusCls:"b-color-active"},itemWrapperTpl(e,t){const{selected:n}=this,{color:i,text:r}=e,s=this.getColorClassName(i);return Bu.tpl`
                    <li
                        class="${this.getItemClasses(e,t)} ${s}"
                        role="option"
                        aria-selected="${n.includes(e)}"
                        data-index="${t}"
                        data-id="${H.encodeHtml(i)}"
                        data-btip="${r}"
                        ${this.itemsFocusable?'tabindex="-1"':""}
                        style="${s?"":"background-color: "+i}"
                    ></li>`},colorClasses:null,colorClassPrefix:null,colors:["#45171D","#F03861","#FF847C","#FECEA8","#A5F2E7","#AA83F3","#8983F3","#A10054","#073059","#2866AB","#5FBDC5","#D8D95C","#FFDEDE","#F7F3CE","#C5ECBE","#3E3E3E","#405559","#68868C","#EDEDED","#D3D6DB","#3A4750","#303841","#BE3144"],addNoColorItem:!0,columns:6,colorSelected:null,store:{useRawData:!1}};configure(e){super.configure(e),this.setItems(),this.ion({item:"onColorSelect"})}setItems(){const e=this,{colors:t,colorClasses:n}=e;let i=n||t;e.addNoColorItem&&(e.store.modelClass.allowNullId=!0,i=[...i,null]),e.items=i.map((t=>t&&"string"!=typeof t?t:{color:t,text:(n?H.capitalize(t):t)||e.L("L{noColor}")}))}afterConfigure(){super.afterConfigure(...arguments),(this.addNoColorItem||this.value)&&this.select(this.value??null)}updateColors(){this.isConfiguring||this.setItems()}updateAddNoColorItem(){this.isConfiguring||this.setItems()}onColorSelect({record:e}){var t;this.refresh();const n={color:e.color,record:e,bubbles:!0};null===(t=this.colorSelected)||void 0===t||t.call(this,n),this.trigger("colorSelected",n)}select(e){e&&"string"!=typeof e||(e=this.store.findRecord("color",e??null)),e&&super.select(e)}updateColumns(e){this.style=`grid-template-columns:repeat(${e}, 1fr);`}getColorClassName(e){var t,n;return null!==(t=this.colorClasses)&&void 0!==t&&t.includes(e)||null!==(n=this.colorClasses)&&void 0!==n&&n.find((t=>t&&t.color===e))?this.colorClassPrefix+e:e?"":"b-no-color"}}mm.initClass(),mm._$name="ColorPicker";class pm extends jg{static $name="ColorField";static type="colorfield";static configurable={displayField:"text",valueField:"color",editable:!1,picker:{type:"colorpicker",align:{align:"t100-b100",matchSize:!1}},showBoxForNoColor:!0,colors:null,addNoColorItem:!0};configure(e){const t=e.picker??{};e.colors&&(t.colors=e.colors),"addNoColorItem"in e&&(t.addNoColorItem=e.addNoColorItem),e.picker=t,super.configure(e)}updatePicker(e,t){super.updatePicker(e,t),e&&(this.items=e.store.records)}updateColors(e){this.isConfiguring||(this.picker.colors=e)}updateAddNoColorItem(e){this.isConfiguring||(this.picker.addNoColorItem=e)}set value(e){this.store||(this.items=[],this.store=this.picker.store),e||(e=this.store.findRecord("color",null)),super.value=e}showPicker(){this.picker.refresh(),super.showPicker(...arguments)}get value(){return super.value}syncInputFieldValue(...e){var t;const n=this,{value:i}=n;let r=null===(t=n.picker)||void 0===t?void 0:t.getColorClassName(i);r||(n.colorBox.style.color=i),r="b-colorbox "+r,n.colorBox.className=r,n.showBoxForNoColor||n.element.classList.toggle("b-colorless",!i),super.syncInputFieldValue(...e)}get innerElements(){return[{reference:"colorBox",className:"b-colorbox"},...super.innerElements]}}pm.initClass(),pm._$name="ColorField";const fm=["ok","cancel","yes","no"].reduce(((e,t,n,i)=>(e[t]=Object.freeze({...Object.fromEntries(i.map((e=>[e,!1]))),name:t,approve:"ok,yes".includes(t),[t]:!0}),e)),Object.create(null)),vm=["b-raised","b-blue"],ym=["b-gray"],bm=d.isWindows,Cm=/(?:\s+,?|,)\s*/,Sm=/^(icon|menu|text)$/;class Dm extends ru{static $name="ConfirmationBar";static type="confirmationbar";static configurable={defaultButton:"ok",defaultType:"button",items:"ok,cancel",keyMap:{Enter:"doDefault",NumpadEnter:"doDefault",Escape:"doCancel"},namedItems:{yes:{cls:"b-yes-button",text:"L{Object.Yes}",onClick:"up.onButtonClick",weight:bm?100:130},no:{cls:"b-no-button",text:"L{Object.No}",onClick:"up.onButtonClick",weight:bm?110:120},ok:{cls:"b-ok-button",text:"L{Object.Ok}",onClick:"up.onButtonClick",weight:bm?120:110},cancel:{cls:"b-cancel-button",text:"L{Object.Cancel}",onClick:"up.onButtonClick",weight:bm?130:100}},syncWidthButtons:null};static delayable={syncButtons:{type:"raf",suspended:!0}};get buttons(){return this.items.filter((e=>e.isButton))}get cancelButton(){return this.widgetMap.cancel||null}get noButton(){return this.widgetMap.no||null}get okButton(){return this.widgetMap.ok||null}get yesButton(){return this.widgetMap.yes||null}changeItems(e,t){return"string"==typeof e&&(e=Object.fromEntries(e.split(Cm).map((e=>[e,!0])))),super.changeItems(e,t)}clickButton(e,t){var n;const{widgetMap:i,defaultButton:r}=this;let s,o,a=t?i.cancel||i.no:i[r];if(!a)for([o,s]of Object.entries(i))if(o!==r){a=s;break}null===(n=a)||void 0===n||n.onInternalClick(e)}doCancel(e){this.clickButton(e,!0)}doDefault(e){this.clickButton(e)}onButtonClick(e){this.trigger("choice",{...e,choice:fm[e.source.ref],source:this,userAction:!0})}onChildAdd(e){super.onChildAdd(e),Ne.before(e,"onConfigChange","onChildConfigChange",this),this.syncButtons()}onChildConfigChange({name:e}){Sm.test(e)&&this.syncButtons()}onChildRemove(e){super.onChildRemove(e),this.syncButtons()}onInternalPaint(e){super.onInternalPaint(e),e.firstPaint&&this.syncButtons.resume(),this.syncButtons.now()}syncButtons(){const e=this,t=e.isDestroying?[]:e.buttons,{defaultButton:n}=e;let i,r;!1!==e.syncWidthButtons&&t.forEach((e=>{(r=e.text)&&(i=Math.max(i||0,r.length+Boolean(e.icon)+Boolean(e.menu)))})),t.forEach((e=>{const{classList:t}=e.element,r=e.ref===n;t.add(...r?vm:ym),t.remove(...r?ym:vm),t.toggle("b-default-button",r),e.minWidth=i&&e.text?`${i}em`:null}))}updateAutoWidthButtons(){this.syncButtons()}updateDefaultButton(){this.syncButtons()}}Dm.initClass(),Dm._$name="ConfirmationBar";class wm extends pu{static $name="YearPicker";static type="yearpicker";static configurable={textContent:!1,tbar:{overflow:null,items:{previous:{type:"tool",cls:"b-icon b-icon-previous",onAction:"up.previous",weight:100},title:{type:"button",cls:"b-yearpicker-title",weight:200,onAction:"up.handleTitleClick"},next:{type:"tool",cls:"b-icon b-icon-next",onAction:"up.next",weight:300}}},itemCls:"b-year-container",yearButtonCount:12,year:null,minYear:null,maxYear:null,startYear:null};construct(e){super.construct({year:(new Date).getFullYear(),...e}),Xt.on({element:this.contentElement,click:"onYearClick",delegate:".b-yearpicker-year",thisObj:this})}get focusElement(){return this.getYearButton(this.year)||this.getYearButton(this.startYear)}getYearButton(e){return this.contentElement.querySelector(`.b-yearpicker-year[data-year="${e}"]`)}get value(){return this.year}set value(e){this.year=e}onYearClick({target:e}){const t=Math.min(Math.max(parseInt(e.innerText),this.minYear||1),this.maxYear||9999);this.year===t?this.trigger("select",{oldValue:t,value:t}):this.year=t}handleTitleClick(e){this.trigger("titleClick",e)}previous(){this.startYear=this.startYear-this.yearButtonCount}next(){this.startYear=this.endYear+1}ingestYear(e){if(!isNaN(e))return W.isDate(e)?e.getFullYear():e}changeYear(e){if(e=this.ingestYear(e))return Math.min(Math.max(e,this.minYear||1),this.maxYear||9999)}updateYear(e,t){const n=this;!n.startYear||e>n.endYear?n.startYear=e:e<n.startYear&&(n.startYear=e-(n.yearButtonCount-1)),n.isConfiguring||n.trigger("select",{oldValue:t,value:e})}get endYear(){return this.startYear+this.yearButtonCount-1}changeStartYear(e){if(e=this.ingestYear(e))return e=this.minYear?Math.max(e,this.minYear):e,this.maxYear?Math.min(e,this.maxYear-(this.yearButtonCount-1)):e}async updateStartYear(e,t){this.isVisible&&Wn.slideIn(this.contentElement,Math.sign(e-t))}composeBody(){this.getConfig("year");const{startYear:e}=this,t=super.composeBody(),n=t.children[this.tbar?1:0].children=[];this.widgetMap.title.text=`${`000${e}`.slice(-4)} - ${`000${this.endYear}`.slice(-4)}`;for(let t=0,i=e;t<this.yearButtonCount;t++,i++)n.push({tag:"button",dataset:{year:i},class:{"b-yearpicker-year":1,"b-selected":i===this.year},text:`000${i}`.slice(-4)});return t}}wm.initClass(),wm._$name="YearPicker";class Em extends Ag{static $name="DisplayField";static type="displayfield";static alias="display";static get configurable(){return{readOnly:!0,editable:!1,cls:"b-display-field",template:null,ariaElement:"displayElement"}}get focusElement(){}changeReadOnly(){return!0}changeEditable(){return!1}get inputElement(){return{tag:"span",id:`${this.id}-input`,reference:"displayElement",html:this.template?this.template(this.value):H.encodeHtml(this.value)}}}Em.initClass(),Em._$name="DisplayField";const Rm=()=>fr.getMonthNames().map(((e,t)=>[t,e])),xm=(e,t)=>e.valueOf()-t.valueOf(),{DateSet:Tm}=fr,Mm=Object.freeze([]);(class extends jg{static $name="ReadOnlyCombo";static type="readonlycombo";static get configurable(){return{editable:!1,inputAttributes:{tag:"div",tabIndex:-1},inputValueAttr:"innerHTML",highlightExternalChange:!1,monitorResize:!1,triggers:{expand:!1},picker:{align:{align:"t-b",axisLock:!0,matchSize:!1},cls:"b-readonly-combo-list",scrollable:{overflowX:!1}}}}}).initClass();class Im extends Ug{static $name="DatePicker";static type="datepicker";static get delayable(){return{refresh:"raf"}}static get configurable(){return{activeDate:{$config:"date",value:"today"},focusable:!0,textContent:!1,tbar:{overflow:null,items:{prevYear:{cls:"b-icon b-icon-first b-datepicker-nav-button",onAction:"up.gotoPrevYear",tooltip:"L{DatePicker.gotoPrevYear}"},prevMonth:{cls:"b-icon b-icon-previous b-datepicker-nav-button",onAction:"up.gotoPrevMonth",tooltip:"L{DatePicker.gotoPrevMonth}"},fields:{type:"container",cls:"b-datepicker-title",items:{monthField:{type:"readonlycombo",cls:"b-datepicker-monthfield",items:Rm(),internalListeners:{select:"up.onMonthPicked"}},yearButton:{type:"button",cls:"b-datepicker-yearbutton",internalListeners:{click:"up.onYearPickerRequested"}}}},nextMonth:{cls:"b-icon b-icon-next b-datepicker-nav-button",onAction:"up.gotoNextMonth",tooltip:"L{DatePicker.gotoNextMonth}"},nextYear:{cls:"b-icon b-icon-last b-datepicker-nav-button",onAction:"up.gotoNextYear",tooltip:"L{DatePicker.gotoNextYear}"}}},yearPicker:{value:{type:"YearPicker",yearButtonCount:16,trapFocus:!0,positioned:!0,hidden:!0,internalListeners:{titleClick:"up.onYearPickerTitleClick",select:"up.onYearPicked"}},$config:"lazy"},date:null,minDate:{$config:"date",value:null},maxDate:{$config:"date",value:null},focusDisabledDates:null,multiSelect:null,selection:{$config:{equal:(e,t)=>e&&e.equals(t)},value:null},editMonth:{$config:"lazy",value:null},includeYear:{$config:"lazy",value:null},dayNameFormat:"dd",trapFocus:!0,role:"grid",focusDescendant:!0,alwaysRefreshOnMonthChange:null,highlightSelectedWeek:null}}static get prototypeProperties(){return{outOfRangeCls:"b-out-of-range",activeCls:"b-active-date",selectedCls:"b-selected-date"}}construct(e){const t=this;super.construct(e),t.externalCellRenderer=t.cellRenderer,t.cellRenderer=t.internalCellRenderer,t.element.setAttribute("aria-activedescendant",`${t.id}-active-day`),t.weeksElement.setAttribute("role","grid"),t.weekElements.forEach((e=>e.setAttribute("role","row"))),t.element.setAttribute("ariaLabelledBy",t.widgetMap.fields.id),Xt.on({element:t.weeksElement,click:{handler:"onCellClick",delegate:`.${t.dayCellCls}:not(.${t.disabledCls}):not(.${t.outOfRangeCls})`},mousedown:{handler:"onCellMousedown",delegate:`.${t.dayCellCls}`},thisObj:t}),t.getConfig("editMonth"),t.getConfig("includeYear"),t.refresh.flush()}afterHide(){var e;null===(e=this._yearPicker)||void 0===e||e.hide(),super.afterHide(...arguments)}doDestroy(){var e,t;null===(e=this.yearButton)||void 0===e||e.destroy(),null===(t=this.monthField)||void 0===t||t.destroy(),super.doDestroy()}get activeDayCell(){return this.weeksElement.querySelector(`#${this.id}-active-day`)}get focusElement(){return!this.disabled&&this.activeDayCell||this.element}onMonthDateChange(e){const t=super.onMonthDateChange(e);return this.refresh.flush(),t}updateEditMonth(e){const{monthField:t,yearButton:n}=this.widgetMap,i=!1===e;t.readOnly=i,n.disabled=i}updateIncludeYear(e){const{yearButton:t}=this.widgetMap;t.hidden=!1===e}doRefresh(...e){const t=this,{date:n}=t,i=t.activeDayCell,r=fr.betweenLesser(t.activeDate,t.month.startDate,t.month.endDate)?t.activeDate:t._activeDate=n;t.getConfig("tbar"),super.doRefresh(...e),t.widgetMap.monthField.value=n.getMonth(),t.widgetMap.yearButton.text=n.getFullYear();const s=fr.parseKey(null==i?void 0:i.dataset.date);r-s&&t.syncActiveDate(r,s)}internalCellRenderer({cell:e,date:t}){const n=this,{activeCls:i,selectedCls:r,externalCellRenderer:s}=n,o=n.isSelectedDate(t),a={[i]:i&&n.isActiveDate(t),[r]:o,[n.outOfRangeCls]:n.minDate&&t<n.minDate||n.maxDate&&t>n.maxDate};if(o&&n.multiSelect){const e=!n.isSelectedDate(fr.add(t,-1,"d")),i=!n.isSelectedDate(fr.add(t,1,"d"));a["b-range-start"]=e,a["b-range-end"]=i,a["b-in-range"]=!e&&!i}Wn.updateClassList(e,a),e.innerHTML=`<div class="b-datepicker-cell-inner">${t.getDate()}</div>`,e.setAttribute("role","gridcell"),e.setAttribute("aria-label",fr.format(t,"MMMM D, YYYY")),n.isActiveDate(t)?e.id=`${n.id}-active-day`:e.removeAttribute("id"),s&&(arguments[0].cell=e.firstChild,n.callback(s,this,arguments))}onCellMousedown(e){const t=e.target.closest("[data-date]");this.focusable?(t.focus(),Wn.getActiveElement(t)===t&&e.preventDefault()):e.preventDefault(),this.activeDate=fr.parseKey(t.dataset.date)}onCellClick(e){const t=e.target.closest("[data-date]");this.onUIDateSelect(fr.parseKey(t.dataset.date),e)}onUIDateSelect(e,t){const n=this,{lastClickedDate:i,multiSelect:r}=n;n.isDisabledDate(e)||!1!==n.trigger("beforeDateSelect",{date:e,event:t})&&(n.lastClickedDate=e,n.activatingEvent=t,r?n.handleMultiSelect(i,e,t):(n.date=n.selection=e,n.floating&&n.hide()),n.activatingEvent=null)}handleMultiSelect(e,t,n){const i=this,{multiSelect:r}=i,s=i._selection||(i._selection=new Tm),o=s.dates,a="range"===r||"simple"===r,l="simple"===r||Wn.isTouchEvent,{size:c,generation:d}=s,u=c&&{[fr.makeKey(fr.add(o[0],-1,"d"))]:1,[fr.makeKey(o[0])]:1,[fr.makeKey(o[o.length-1])]:1,[fr.makeKey(fr.add(o[o.length-1],1,"d"))]:1},h=s.has(t)?"delete":"add",g=a&&(null==u?void 0:u[fr.makeKey(t)]);if(l&&c>1)s.clear(),s.add(t);else if(n.ctrlKey)!0!==r&&c&&!g||(s[h](t),a&&!s.has(i.rangeStartDate)&&i.rangeStartDate.setDate(i.rangeStartDate.getDate()+(t<o[1]?1:-1)));else if((l||n.shiftKey)&&c){const[n,r]=[new Date(a?i.rangeStartDate||(i.rangeStartDate=o[0]):e),t].sort(xm);a&&s.clear();for(const e=n;e<=r;e.setDate(e.getDate()+1))s.add(e)}else s.has(t)&&1===s.size||(s.clear(),s.add(t));const m=s.size;1===m?i.rangeStartDate=t:m||(i.rangeStartDate=null),s.generation!==d&&i.updateSelection(s)}updateHighlightSelectedWeek(e){this.element.classList.toggle("b-highlight-selected-week",Boolean(e))}updateMultiSelect(e){this.element.classList.toggle("b-multiselect",Boolean(e)),e||(this.selection=[...this.selection][0])}get selection(){const{_selection:e}=this,t=e?e.dates:Mm;return"range"===this.multiSelect&&t.length?[t[0],t[t.length-1]]:t}changeSelection(e,t){const n=this;let i,r;if(e)if(e.isDateSet){if(t===e||null!=t&&t.equals(e))return t;r=W.first(e),i=e}else if(e.forEach||(e=[e]),e.forEach(((t,i)=>e[i]=n.changeDate(t))),r=e[0],e.sort(xm),"range"===n.multiSelect&&2===e.length){i=new Tm;for(const t=new Date(e[0]);t<=e[1];t.setDate(t.getDate()+1))i.add(t)}else r=e[0],i=new Tm(e);else i=new Tm;return r&&(n.rangeStartDate=fr.clearTime(r)),i}updateSelection(e){const t=this,{dates:n}=e,i="range"===t.multiSelect?[n[0],n[n.length-1]]:n;t.isConfiguring||(t.refresh.now(),t.trigger("selectionChange",{selection:i,userAction:Boolean(t.activatingEvent)}))}onInternalKeyDown(e){const t=this,n=e.key.trim()||e.code,i=t.activeDate;let r=new Date(i);if("Escape"===n&&t.floating)return t.hide();if(i&&t.weeksElement.contains(e.target)){do{switch(n){case"ArrowLeft":e.preventDefault(),e.ctrlKey?r=t.gotoPrevMonth():r.setDate(r.getDate()-1);break;case"ArrowUp":e.preventDefault(),r.setDate(r.getDate()-7);break;case"ArrowRight":e.preventDefault(),e.ctrlKey?r=t.gotoNextMonth():r.setDate(r.getDate()+1);break;case"ArrowDown":e.preventDefault(),r.setDate(r.getDate()+7);break;case"Enter":return t.onUIDateSelect(i,e)}}while(t.isDisabledDate(r)&&!t.focusDisabledDates);if(t.minDate&&r<t.minDate)return;if(t.maxDate&&r>t.maxDate)return;t.activeDate=r}}changeMinDate(e){return e&&Ug.prototype.changeDate.apply(this,arguments)}updateMinDate(e){this._yearpicker&&(this._yearpicker.minYear=null==e?void 0:e.getFullYear()),this.refresh()}changeMaxDate(e){return e&&Ug.prototype.changeDate.apply(this,arguments)}updateMaxDate(e){this._yearpicker&&(this._yearpicker.maxYear=null==e?void 0:e.getFullYear()),this.refresh()}changeDate(e){return fr.clamp(super.changeDate(e),this.minDate,this.maxDate)}updateDate(e,t){const n=this,{month:i}=n;if(n.isConfiguring&&!n.initializingActiveDate&&("selection"in n.initialConfig||(n.selection=e),"activeDate"in n.initialConfig||(n.activeDate=e)),!i.date||e.getMonth()===i.month||!n.getCell(e)||n.alwaysRefreshOnMonthChange||n.isNavigating)super.updateDate(e);else{const r=i.getOtherMonth(e),s=n.eventListeners&&(t?e.getDate()!==t.getDate()|(r.getWeekId(e)!==i.getWeekId(t))<<1|(e.getMonth()!==(null==t?void 0:t.getMonth()))<<2|(e.getFullYear()!==(null==t?void 0:t.getFullYear()))<<3:15);n.trigger("dateChange",{changes:{d:!0,w:Boolean(2&s),m:Boolean(12&s),y:Boolean(8&s),r:r.weekCount!==i.weekCount},value:e,oldValue:t})}}changeActiveDate(e,t){const n=this;if("today"===e&&(e=new Date),!1!==n.trigger("beforeActiveDateChange",{activeDate:e,oldActiveDate:t})){if(e=e?n.changeDate(e):n.date||(n.date=fr.clearTime(new Date)),isNaN(e))throw new Error("DatePicker activeDate must be passed a Date, or a YYYY-MM-DD date string");return fr.clamp(e,n.minDate,n.maxDate)}}updateActiveDate(e,t){const n=this,{isConfiguring:i}=n;!i&&n.getCell(e)||(n.initializingActiveDate=i,n.date=e,n.initializingActiveDate=!1),i||n.refresh.isPending||n.syncActiveDate(e,t)}syncActiveDate(e,t){const n=this,{activeCls:i}=n,r=n.getCell(e),s=t&&n.getCell(t),o=Wn.getActiveElement(n.element);r&&(n.focusable&&r.setAttribute("tabIndex","0"),i&&r.classList.add(i),r.id=`${n.id}-active-day`,n.weeksElement.contains(o)&&r.focus()),s&&s!==r&&(n.focusable&&s.removeAttribute("tabIndex"),i&&s.classList.remove(i),s.removeAttribute("id"))}set value(e){const t=this,{selection:n,duration:i}=t;if(t.isNavigating=!0,e){if(e=t.changeDate(e,t.value),"range"===t.multiSelect&&2===(null==n?void 0:n.length))return fr.betweenLesserEqual(e,...n)||(e<n[0]?t.selection=[e,fr.add(e,i-1,"d")]:t.selection=[fr.add(e,-(i-1),"d"),e]),void(t.date=t.activeDate=e);void 0!==e&&(t.selection=e,t.date=t.activeDate=e)}else t.date=t.activeDate=new Date,t.selection=null;t.isNavigating=!1}get value(){const{selection:e}=this,t=(null==e?void 0:e.length)||null;return t&&e[t-1]}get duration(){return"range"===this.multiSelect?fr.diff(...this.selection,"d")+1:1}gotoPrevYear(){return this.goto(-1,"year")}gotoPrevMonth(){return this.goto(-1,"month")}gotoNextMonth(){return this.goto(1,"month")}gotoNextYear(){return this.goto(1,"year")}goto(e,t){const n=this,{activeDate:i}=n,r=i&&n.getCell(i);let s;s="month"===t&&r&&(null==i?void 0:i.getMonth())===n.month.month+e?i:fr.add(r?i:n.date,e,t);const o=new Date(s);o.setDate(1);const a=fr.add(fr.add(o,1,"month"),-1,"day");if(n.minDate&&e<0&&a<n.minDate||n.maxDate&&e>0&&o>n.maxDate)return;n.isNavigating=!0;const l=n.date=s;return r&&(n.activeDate=s),n.isNavigating=!1,l}isActiveDate(e){return!(e-this.activeDate)}isSelectedDate(e){var t;return null===(t=this._selection)||void 0===t?void 0:t.has(e)}onFocusIn(e){var t;(super.onFocusIn(e),e.toWidget!==this||e._target!==this.element||this.disabled)||(null===(t=this.focusElement)||void 0===t||t.focus())}onMonthPicked({record:e,userAction:t}){var n;t&&(this.activeDate=fr.add(this.activeDate,e.value-this.activeDate.getMonth(),"month"),null===(n=this.focusElement)||void 0===n||n.focus())}onYearPickerRequested(){const{yearPicker:e}=this;e.isVisible?e.hide():(e.year=e.startYear=this.activeDate.getFullYear(),e.show(),e.focus())}onYearPickerTitleClick(){this.yearPicker.hide()}onYearPicked({value:e,source:t}){var n;const i=new Date(this.activeDate);i.setFullYear(e),this.activeDate=i,null===(n=this.focusElement)||void 0===n||n.focus({preventScroll:!0}),t.hide()}changeYearPicker(e,t){var n,i;return wm.reconfigure(t,e?wm.mergeConfigs({owner:this,appendTo:this.element,minYear:null===(n=this.minDate)||void 0===n?void 0:n.getFullYear(),maxYear:null===(i=this.maxDate)||void 0===i?void 0:i.getFullYear()},e):null,this)}get childItems(){const{_yearPicker:e}=this,t=super.childItems;return e&&t.push(e),t}updateLocalization(){const{monthField:e}=this.widgetMap,t=Rm();this.isConfiguring||t.every(((t,n)=>t[1]===e.store.getAt(n).text))||(t[e.value??this.date.getMonth()].selected=!0,e.items=t),super.updateLocalization()}changeMultiSelect(e){return"range"===e&&d.isTouchDevice&&(e="simple"),e}}Im.initClass(),Im._$name="DatePicker";class Am extends kg{static $name="DateField";static type="datefield";static alias="date";static get configurable(){return{format:"L",strictParsing:!1,fallbackFormat:"YYYY-MM-DD",timeFormat:"HH:mm:ss:SSS",keepTime:!1,pickerFormat:null,validateDateOnly:null,triggers:{expand:{cls:"b-icon-calendar",handler:"onTriggerClick",weight:200},back:{cls:"b-icon b-icon-angle-left b-step-trigger b-step-trigger-back",key:"Shift+ArrowDown",handler:"onBackClick",align:"start",weight:100},forward:{cls:"b-icon b-icon-angle-right b-step-trigger b-step-trigger-forward",key:"Shift+ArrowUp",handler:"onForwardClick",align:"end",weight:100}},calendarContainerCls:"",min:null,max:null,step:!1,stepTriggers:{$config:null,default:!0},weekStartDay:null,picker:{type:"datepicker",role:"dialog",floating:!0,scrollAction:"realign",align:{align:"t0-b0",axisLock:!0}},value:null}}changePicker(e,t){var n;if(null!=e&&e.isDatePicker)return e;const i=this,r=Im.mergeConfigs({owner:i,forElement:i.pickerAlignElement,minDate:i.min,maxDate:i.max,weekStartDay:i._weekStartDay,align:{anchor:i.overlayAnchor,target:i.pickerAlignElement},onSelectionChange:({selection:e,source:t})=>{t.isVisible&&(i._isUserAction=i._isPickerInput=!0,i.value=i.value?fr.copyTimeValues(new Date(e[0]),i.value):new Date(e[0]),i._isPickerInput=i._isUserAction=!1,t.hide())}},e);i.calendarContainerCls&&(r.cls=i.calendarContainerCls),i.value?r.value=i.value:r.activeDate||(r.activeDate=new Date);const s=Im.reconfigure(t,e?r:null,i);return null==s||null===(n=s.refresh)||void 0===n||n.flush(),s}getStepDate(e){const{step:t}=this;return fr.add(this.value,(e||1)*t.magnitude,t.unit)}stepDate(e,t=!0){const n=this;if(!n.readOnly&&n.value){const i=n.getStepDate(e);n.checkMinMax(i)||(t?(n._isUserAction=!0,n.value=i,n.autoSelect&&n.select(),n._isUserAction=!1):n.value=i)}}onBackClick(){this.stepDate(-1)}onForwardClick(){this.stepDate(1)}showPicker(e){if(this.readOnly)return;const t=this,{_picker:n}=t;if(n){const e={minDate:t.min,maxDate:t.max};t.value?e.value=t.value:n.activeDate||(e.activeDate=new Date),n.setConfig(e)}super.showPicker(e)}focusPicker(){var e;null===(e=this.picker)||void 0===e||e.focus()}checkMinMax(e){const{min:t,max:n}=this;return t&&e<t?-1:n&&e>n?1:0}get isValid(){const e=this;e.clearError("L{Field.minimumValueViolation}",!0),e.clearError("L{Field.maximumValueViolation}",!0);let{value:t}=e;if(t){let{min:n,max:i,validateDateOnly:r}=e;if(r&&(t=fr.clearTime(t,!1),n&&(n=fr.clearTime(n,!1)),i&&(i=fr.clearTime(i,!1))),n&&t<n)return e.setError("L{Field.minimumValueViolation}",!0),!1;if(i&&t>i)return e.setError("L{Field.maximumValueViolation}",!0),!1}return super.isValid}transformDateValue(e,t=!0){const n=this;return null!=e&&(fr.isDate(e)||(e="string"==typeof e?fr.parse(e,n.format,n.strictParsing)||fr.parse(e,n.fallbackFormat,n.strictParsing):new Date(e)),fr.isValidDate(e))?t&&(!n.min||e-n.min>-fr.MS_PER_DAY)&&(!n.max||e<=n.max)?n.transformTimeValue(e):e:null}transformTimeValue(e){const t=this,{keepTime:n}=t;if(e=fr.clone(e),n)if("entered"!==n&&!0!==n){const i=fr.parse(n,t.timeFormat);fr.isValidDate(i)?fr.copyTimeValues(e,i):fr.isValidDate(t.value)&&fr.copyTimeValues(e,t.value)}else!0===n&&(t._isPickerInput||t.inputting)&&fr.isValidDate(t.value)&&fr.copyTimeValues(e,t.value);else fr.clearTime(e,!1);return e}changeMin(e){return this.transformDateValue(e,!1)}updateMin(e){const{input:t,_picker:n}=this;t&&(null==e?t.removeAttribute("min"):t.min=e),n&&(n.minDate=e),this.syncInvalid()}changeMax(e){return this.transformDateValue(e,!1)}updateMax(e){const{input:t,_picker:n}=this;t&&(null==e?t.removeAttribute("max"):t.max=e),n&&(n.maxDate=e),this.syncInvalid()}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:fr.weekStartDay}updateWeekStartDay(e){this._picker&&(this._picker.weekStartDay=e)}changeValue(e,t){const n=this,i=n.transformDateValue(e);if(!e||i){if(n.clearError("L{invalidDate}"),n.hasChanged(t,i))return super.changeValue(i,t);n.inputting||n.syncInputFieldValue()}else n.inputting&&!n.validateOnInput||n.setError("L{invalidDate}")}updateValue(e,t){const n=this._picker;n&&!this.inputting&&(n.value=n.activeDate=e),super.updateValue(e,t)}changeStep(e,t){const n=typeof e;return e?("number"===n?e={magnitude:Math.abs(e),unit:t?t.unit:"day"}:"string"===n&&(e=fr.parseDuration(e)),e&&e.unit&&e.magnitude?(e.magnitude<0&&(e={magnitude:-e.magnitude,unit:e.unit}),e):void 0):null}updateStep(e){this.element.classList[e?"remove":"add"]("b-no-steppers"),this.syncInvalid()}hasChanged(e,t){return null!=e&&e.getTime&&null!=t&&t.getTime&&"entered"!==this.keepTime&&!0!==this.keepTime?!fr.isEqual(fr.clearTime(e),fr.clearTime(t)):super.hasChanged(e&&e.getTime(),t&&t.getTime())}get inputValue(){const e=this.value;return e?fr.format(e,this.format):""}updateFormat(){this.isConfiguring||this.syncInputFieldValue(!0)}updateLocalization(){super.updateLocalization(),this.syncInputFieldValue(!0)}internalOnKeyEvent(e){var t;if(super.internalOnKeyEvent(e),"keydown"===e.type){const n=this;let i;switch(e.virtualKey){case"Enter":n.isValid&&(null===(t=n.picker)||void 0===t||t.hide());break;case"ArrowLeft":(n.caretAtStart||n.selectedAll)&&(i=-1);break;case"ArrowRight":(n.caretAtEnd||n.selectedAll)&&(i=1);break;case"NumpadAdd":i=1;break;case"NumpadSubtract":i=-1}i&&n.step&&(n.stepDate(i),n.selectAll(),e.preventDefault())}}}Am.initClass(),Am._$name="DateField";class km{static $name="NumberHelper";static getLocalizedFormatter(e){return"currency"!==(null==e?void 0:e.style)||e.currency||(e.currency=yi.locale.NumberFormat.currency),"string"==typeof e?Fs.get({locale:yi.localeCode,template:e}):null!=(null==e?void 0:e.locale)?Fs.get(e):Fs.get(Object.assign({},e,{locale:yi.localeCode}))}}km._$name="NumberHelper";const Fm=e=>e.ctrlKey&&e.preventDefault();class Pm extends Ig{static $name="NumberField";static type="numberfield";static alias="number";static get configurable(){return{wrapAround:null,min:null,max:null,step:1,largeStep:0,value:null,format:"",triggers:{spin:{type:"spintrigger"}},changeOnSpin:!0,inputType:null}}construct(e){super.construct(e);const t=this;t.input.addEventListener("dblclick",(()=>{t.select()})),"number"==typeof t.changeOnSpin&&(t.bufferedSpinChange=t.buffer(t.triggerChange,t.changeOnSpin))}acceptValue(e,t){let n=!isNaN(e);if(n&&!this.hasTextSelection){n=!1;const e=this.input.value,i=parseFloat(e);e!==t&&(n=!this.acceptValue(i,e))}return n}okMax(e){return isNaN(this.max)||e<=this.max}okMin(e){return isNaN(this.min)||e>=this.min}internalOnKeyEvent(e){if("keydown"===e.type){const t=this,n=e.key;let i;if("ArrowUp"===n)t.doSpinUp(e.shiftKey),i=!0;else if("ArrowDown"===n)t.doSpinDown(e.shiftKey),i=!0;else if(!e.altKey&&!e.ctrlKey&&n&&1===n.length){const e=t.getAfterValue(n),r=t.formatter.parseStrict(e);i=!(r===t.value||"-"===e&&(isNaN(t.min)||t.min<0))&&!t.acceptValue(r,e)}"Enter"===n&&t._changedBySilentSpin&&(t.triggerChange(e,!0),t._changedBySilentSpin=!1),i&&e.preventDefault()}super.internalOnKeyEvent(e)}doSpinUp(e=!1){const t=this;if(t.readOnly)return;let n=(t.value||0)+(e?t.largeStep:t.step);t.okMin(n)||(n=t.min),t.okMax(n)?t.applySpinChange(n):t.wrapAround&&(n=t.min,t.applySpinChange(n))}doSpinDown(e=!1){const t=this,n=e?t.largeStep:t.step;if(t.readOnly)return;let i=(t.value||0)-n;t.okMax(i)||(i=t.max),t.okMin(i)?t.applySpinChange(i):t.wrapAround&&(i=t.max-t.max%n,t.applySpinChange(i))}applySpinChange(e){const t=this;t._isUserAction=!0,!0!==t.changeOnSpin&&(t._changedBySilentSpin=!0,t.silenceChange=!0,t.bufferedSpinChange&&t.bufferedSpinChange(null,!0)),t.value=e,t._isUserAction=!1,t.silenceChange=!1}triggerChange(){this.silenceChange||super.triggerChange(...arguments)}onFocusOut(e){var t;super.onFocusOut(...arguments);const n=this,{input:i}=n,r=i.value,s=n.formatter.truncate(r),o=isNaN(s)?r:n.formatValue(s);null===(t=n.triggers)||void 0===t||null===(t=t.spin)||void 0===t||null===(t=t.clickRepeater)||void 0===t||t.cancel(),n.lastTouchmove=null,r!==o&&(i.value=o),n._changedBySilentSpin&&(n.triggerChange(e,!0),n._changedBySilentSpin=!1)}internalOnInput(e){const t=this,{formatter:n,input:i}=t,{parser:r,maximumFractionDigits:s}=n,o=i.value,a=r.decimalPlaces(o);if(n.truncator&&a>s){let e,l=o;const c=n.truncate(o);if(!isNaN(c)&&(l=t.formatValue(c),e=r.decimalPlaces(l),e<s&&(l+="0".repeat(s-e),e=s),e<a)){const e=o.length-t.caretPos;i.value=l,t.caretPos=l.length-e+1}}super.internalOnInput(e)}formatValue(e){return this.formatter.format(e)}get formatter(){const e=this;return void 0!==e._formatter?e._formatter:e._formatter=km.getLocalizedFormatter(e.format)}updateStep(e){const t=this;var n;(t.element.classList.toggle("b-hide-spinner",!e),t._step=e,e&&d.isMobile)?t.touchMoveListener||(t.touchMoveListener=Xt.on({element:t.input,touchmove:"onInputSwipe",thisObj:t,throttled:{buffer:150,alt:Fm}})):null===(n=t.touchMoveListener)||void 0===n||n.call(t)}onInputSwipe(e){const{lastTouchmove:t}=this;if(t){const n=e.screenX-t.screenX,i=t.screenY-e.screenY;this["doSpin"+((Math.abs(n)>Math.abs(i)?n:i)>0?"Up":"Down")]()}e.preventDefault(),this.lastTouchmove=e}changeLargeStep(e){return e||10*this.step}get validity(){const e=this.value,t={};return null!=e&&(t.rangeUnderflow=!this.okMin(e),t.rangeOverflow=!this.okMax(e)),t.valid=!t.rangeUnderflow&&!t.rangeOverflow,t}changeValue(e,t){const n=this;if(e||0===e){let t;"number"!=typeof e&&(e="string"==typeof e?n.formatter.parse(e):Number(e),t=isNaN(e),t&&(e="")),!t&&n.format&&(e=n.formatter.round(e))}else e=void 0;return super.changeValue(e,t)}get inputValue(){return null!=this.value?this.formatValue(this.value):""}updateLocalization(){super.updateLocalization(),this._formatter=void 0,this.syncInputFieldValue()}}Pm.initClass(),Pm._$name="NumberField";class Om extends pu{static $name="TimePicker";static type="timepicker";static configurable={floating:!0,layout:"hbox",items:{hour:{label:"L{TimePicker.hour}",type:"number",min:0,max:23,highlightExternalChange:!1,format:"2>9",wrapAround:!0},minute:{label:"L{TimePicker.minute}",type:"number",min:0,max:59,highlightExternalChange:!1,format:"2>9",wrapAround:!0},second:{hidden:!0,label:"L{TimePicker.second}",type:"number",min:0,max:59,highlightExternalChange:!1,format:"2>9",wrapAround:!0},amPm:{type:"buttongroup",items:{amButton:{type:"button",text:"AM",toggleGroup:"am-pm",cls:"b-blue",onClick:"up.onAmPmButtonClick"},pmButton:{type:"button",text:"PM",toggleGroup:"am-pm",cls:"b-blue",onClick:"up.onAmPmButtonClick"}}}},autoShow:!1,trapFocus:!0,seconds:null,value:{$config:{equal:"date"},value:null},format:null,max:null,min:null,initialValue:null};construct(e){super.construct(e),this.refresh()}updateSeconds(e){this.widgetMap.second[e?"show":"hide"]()}onFieldChange(){this.isConfiguring||this.isRefreshing||(this.value=this.pickerToTime())}onAmPmButtonClick({source:e}){this._pm="pmButton"===e.ref,this._value&&(this.value=this.pickerToTime())}onInternalKeyDown(e){var t;const n=this;switch(e.key){case"Escape":return n.triggerTimeChange(n._initialValue),n.hide(),void e.preventDefault();case"Enter":return n.value=n.pickerToTime(),n.hide(),void e.preventDefault()}null===(t=super.onInternalKeyDown)||void 0===t||t.call(this,e)}pickerToTime(){const e=this,t=e._pm,{hour:n,minute:i,second:r}=e.widgetMap;n.format=e._is24Hour?"2>9":null;let s=n.value,o=new Date(e.value);return e._is24Hour||(t&&s<12&&(s+=12),t||12!==s||(s=0)),o.setHours(s),o.setMinutes(i.value),e.seconds&&o.setSeconds(r.value),e._min&&(o=fr.max(e._min,o)),e._max&&(o=fr.min(e._max,o)),o}triggerTimeChange(e){this.trigger("timeChange",{time:e})}updateInitialValue(e){this.value=e}changeValue(e){return e&&(e="string"==typeof e?fr.parse(e,this.format):e),this.isVisible||(this._initialValue=e),e??fr.getTime(0)}updateValue(e){this.isVisible&&this.triggerTimeChange(e),this.refresh()}updateFormat(e){this._is24Hour=fr.is24HourFormat(e),this.refresh()}changeMin(e){return"string"==typeof e?fr.parse(e,this.format):e}changeMax(e){return"string"==typeof e?fr.parse(e,this.format):e}refresh(){const e=this;if(!e.isConfiguring&&e.value){e.isRefreshing=!0;const{hour:t,minute:n,second:i,amButton:r,pmButton:s}=e.widgetMap,o=e.value,a=e._is24Hour,l=o.getHours(),c=e._pm=l>=12;e.element.classList[a?"add":"remove"]("b-24h"),t.min=a?0:1,t.max=a?23:12,t.value=a?l:l%12||12,n.value=o.getMinutes(),i.value=o.getSeconds(),r.pressed=!c,s.pressed=c,r.hidden=s.hidden=a,e.isRefreshing=!1}}}Om.initClass(),Om._$name="TimePicker";class Lm extends kg{static $name="TimeField";static type="timefield";static alias="time";static get configurable(){return{picker:{type:"timepicker",align:{align:"t0-b0",axisLock:!0}},format:"LT",triggers:{expand:{align:"end",handler:"onTriggerClick",compose:()=>({children:[{class:{"b-icon-clock-live":1}}]})},back:{align:"start",cls:"b-icon b-icon-angle-left b-step-trigger",key:"Shift+ArrowDown",handler:"onBackClick"},forward:{align:"end",cls:"b-icon b-icon-angle-right b-step-trigger",key:"Shift+ArrowUp",handler:"onForwardClick"}},min:null,max:null,step:"5m",stepTriggers:{$config:null,default:!0},value:null,keepDate:!0}}changePicker(e,t){const n=this;return Om.reconfigure(t,e,{owner:n,defaults:{value:n.value,forElement:n.pickerAlignElement,owner:n,align:{anchor:n.overlayAnchor,target:n.pickerAlignElement},onTimeChange({time:e}){n._isUserAction=!0,n.value=e,n._isUserAction=!1}}})}onBackClick(){const e=this,{min:t}=e;if(!e.readOnly&&e.value){const n=fr.add(e.value,-1*e.step.magnitude,e.step.unit);(!t||t.getTime()<=n)&&(e.value=n)}}onForwardClick(){const e=this,{max:t}=e;if(!e.readOnly&&e.value){const n=fr.add(e.value,e.step.magnitude,e.step.unit);(!t||t.getTime()>=n)&&(e.value=n)}}get isValid(){const e=this;e.clearError("L{minimumValueViolation}",!0),e.clearError("L{maximumValueViolation}",!0);let t=e.value;if(t){if(t=t.getTime(),e._min&&e._min.getTime()>t)return e.setError("L{minimumValueViolation}",!0),!1;if(e._max&&e._max.getTime()<t)return e.setError("L{maximumValueViolation}",!0),!1}return super.isValid}hasChanged(e,t){return null!=e&&e.getTime&&null!=t&&t.getTime?this.keepDate?e-t!=0:!fr.isSameTime(e,t):super.hasChanged(e,t)}showPicker(){const e=this,{picker:t,value:n}=e;e.readOnly||(t.value=n,t.format=e.format,t.maxTime=e.max,t.minTime=e.min,n||(e.value=t.value),super.showPicker(!0))}onPickerShow(){var e;super.onPickerShow(),this.pickerKeyDownRemover=null===(e=this.pickerKeyDownRemover)||void 0===e?void 0:e.call(this)}focusPicker(){this.picker.focus()}transformTimeValue(e){null!=e&&("string"==typeof e?(e=fr.parse(e,this.format),this.keepDate&&e&&this.value&&(e=fr.copyTimeValues(new Date(this.value),e))):e=new Date(e),fr.isValidDate(e)?this.keepDate||(e=fr.getTime(e)):e=null);const t={value:e};return this.trigger("transformTimeValue",t),e=t.value}changeMin(e){return this.transformTimeValue(e)}updateMin(e){const{input:t}=this;t&&(null==e?t.removeAttribute("min"):t.min=e),this.syncInvalid()}changeMax(e){return this.transformTimeValue(e)}updateMax(e){const{input:t}=this;t&&(null==e?t.removeAttribute("max"):t.max=e),this.syncInvalid()}changeValue(e,t){const n=this,i=n.transformTimeValue(e);if(e&&!i||n.isRequired&&""===e)n.setError("L{invalidTime}");else{if(n.clearError("L{invalidTime}"),n.hasChanged(t,i))return super.changeValue(i,t);n.inputting||n.syncInputFieldValue(!0)}}updateValue(e,t){const{expand:n}=this.triggers;n&&e&&(n.element.firstElementChild.style.animationDelay=-(60*e.getHours()+e.getMinutes())/10+"s"),super.updateValue(e,t)}changeStep(e,t){var n,i;const r=typeof e;return e?("number"===r?e={magnitude:Math.abs(e),unit:t?t.unit:"hour"}:"string"===r&&(e=fr.parseDuration(e)),null!==(n=e)&&void 0!==n&&n.unit&&null!==(i=e)&&void 0!==i&&i.magnitude?(e.magnitude<0&&(e={magnitude:-e.magnitude,unit:e.unit}),e):void 0):null}updateStep(e){this.element.classList[e?"remove":"add"]("b-no-steppers"),this.syncInvalid()}updateFormat(){this.syncInputFieldValue(!0)}get inputValue(){return fr.format(this.value,this.format)}updateLocalization(){super.updateLocalization(),this.syncInputFieldValue(!0)}}Lm.initClass(),Lm._$name="TimeField";var $m=e=>class extends(e.mixin(ch)){static configurable={altFormats:["YYYY-MM-DD"],dateFieldDefaults:{type:"datefield",autoSelect:!0,picker:null,step:"1d",internalListeners:{change:"up.onDateFieldChange"},triggers:{expand:null,back:{align:"end",weight:101}}},fieldEndDate:{ref:"fieldEndDate",cls:"b-end-date",weight:40},fieldStartDate:{ref:"fieldStartDate",cls:"b-start-date",weight:30,internalListeners:{focusIn:"up.onStartDateFocusIn",focusOut:"up.onStartDateFocusOut"}},dateStepTriggers:null,format:"ddd, MMM D",keyMap:{ArrowDown:"stepDown",ArrowUp:"stepUp","Ctrl+ArrowDown":"stepDownLarge","Ctrl+ArrowUp":"stepUpLarge"},pickingStartDate:null,stepLarge:"1 month",stepSmall:"7 days",validateDateOnly:!0,value:{$config:{type:"date[]",formats:["format","altFormats"]}}};static fenced={syncValue:!0};static prototypeProperties={_lastValue:null};get dateFieldDefaults(){return W.merge({format:this.format},this._dateFieldDefaults)}configureDateField(e,t,n){const i=this,{dateStepTriggers:r}=i;return Am.reconfigure(t,e,{owner:i,defaults:W.assign({stepTriggers:!0===r||"both"===r||r===n},i.dateFieldDefaults)})}changeFieldEndDate(e,t){return this.configureDateField(e,t,"end")}updateFieldEndDate(e){var t;e&&(null===(t=this.dateFieldContainer)||void 0===t||t.add(e))}changeFieldStartDate(e,t){return this.configureDateField(e,t,"start")}updateFieldStartDate(e){var t;e&&(null===(t=this.dateFieldContainer)||void 0===t||t.add(e))}updateFormat(e){this.isConstructing||(this.fieldEndDate.format=e,this.fieldStartDate.format=e)}updatePickingStartDate(e){this.element.classList.toggle("b-picking-start-date",Boolean(e))}updateValue(e,t){var n;null===(n=super.updateValue)||void 0===n||n.call(this,e,t),this.syncValue("value",e)}stepDown(e){this.adjustByKey(e,this.stepSmall)}stepUp(e){this.adjustByKey(e,"-"+this.stepSmall)}stepDownLarge(e){this.adjustByKey(e,this.stepLarge)}stepUpLarge(e){this.adjustByKey(e,"-"+this.stepLarge)}adjustByKey(e,t){const n=this,{_isUserAction:i}=n,{target:r}=e,s=[n.fieldStartDate,n.fieldEndDate],o=((r===s[0].input?1:r===s[1].input&&2)||0)-1,a=s[o],l=[s[0].value,s[1].value];l[o]=fr.add(l[o]??fr.clearTime(new Date),t),l[1-o]=l[1-o]??l[o],l[1]<l[0]&&(l[1-o]=l[o]),n.checkValid(l)&&(n._isUserAction=!0,s[0].value=l[0],s[1].value=l[1],n._isUserAction=i),a.selectAll(),e.preventDefault()}checkMinMax(e=this.value){const{maxDate:t,minDate:n,validateDateOnly:i}=this;let r,s,o=0;if(e&&(n||t))for(r of(s=Array.isArray(e)?e:[e],s))if(r=i?fr.clearTime(r):r,o=n&&r<n?-1:t&&r>t?1:0,o)break;return o}checkValid(e=this.value){return!this.checkMinMax(e)}hasChanged(e,t){return!W.isEqual(e,t)}onDateFieldChange({source:e,userAction:t}){const n=this,{fieldEndDate:i,fieldStartDate:r,_isUserAction:s}=n;n._isUserAction=t||s,n.syncValue(e.ref,[r.value,i.value]),n._isUserAction=s}onStartDateFocusIn(){this.pickingStartDate=!0}onStartDateFocusOut(e){this.pickingStartDate=!1}syncValue(e,t=this.value){const n=this;"fieldEndDate"!==e&&(n.fieldEndDate.value=t&&t[1]),"fieldStartDate"!==e&&(n.fieldStartDate.value=t&&t[0]),"value"!==e&&(n.value=t),!n.isConstructing&&n.hasChanged(n._lastValue,t)&&n.checkValid(t)&&n.triggerChange(),n._lastValue=t}get widgetClass(){}};const{isArray:_m}=Array,{DateSet:jm}=fr,Bm=e=>12*e.getFullYear()+e.getMonth(),Hm=/material/i;class Vm extends(cm.mixin(ch)){static $name="MultiDatePicker";static type="multidatepicker";static configurable={configureSlot:"configureDatePicker",disableReserveSlots:"inert",slots:2,baseDate:{$config:"day",value:"today"},cellRenderer:null,headerRenderer:null,weekRenderer:null,weekStartDay:null,date:{$config:"day",value:"today"},minDate:{$config:"day"},maxDate:{$config:"day"},datePickerDefaults:{type:"datepicker",activeDate:null,animateTimeShift:!1,dayNameFormat:"d1",multiSelect:"range",trapFocus:!1,internalListeners:{selectionChange:"up.onDatePickerSelectionChange"},tbar:{items:{prevMonth:{onAction:"up.onPrevMonthClick"},nextMonth:{onAction:"up.onNextMonthClick"},fields:{items:{monthField:{disabled:!0},yearButton:{disabled:!0}}}}},yearPicker:{internalListeners:{select:"up.onYearPickedMulti"}}},includeYear:e=>!e.getMonth(),items:{prevButton:{type:"button",positionable:"before",cls:"b-multidatepicker-nav-button b-multidatepicker-prev-button b-icon b-icon-previous",onAction:"up.onPrevMonthClick",hideMode:"opacity"},nextButton:{type:"button",positionable:"after",cls:"b-multidatepicker-nav-button b-multidatepicker-next-button b-icon b-icon-next",onAction:"up.onNextMonthClick",hideMode:"opacity"}},multiSelect:null,navButtons:!0,selection:{$config:"day[]"}};static fenced={syncSelection:!0};get datePickers(){return this.items.filter((e=>e.isDatePicker))}compose(){var e;const{navButtons:t}=this;return{class:{"b-multidatepicker-nav-buttons":t,[`b-multidatepicker-nav-${!0===t?Hm.test((null===(e=Wn.getThemeInfo())||void 0===e?void 0:e.name)||"")?"floating":"inline":t}`]:t}}}onInternalPaint(e){if(e.firstPaint){const e=this,{date:t}=e;t&&e.unanimated((()=>{e.scrollPos=e.posFromIndex(e.indexFromDate(t))}))}super.onInternalPaint(e)}applyDate(e,t,n){var i;const r=this,s=null==t?void 0:t.containsFocus,{_isUserAction:o}=r;let{selection:a}=r,l=s?n:t;!a||s&&e>=a[1]?(l=n,a=[e,e]):s?a=[e,a[1]||e]:e<a[0]?(l=n,a=[e,a[1]||e]):a=[a[0]||e,e],null===(i=l)||void 0===i||i.focus(),r._isUserAction=!0,r.selection=a,r._isUserAction=o}changeIncludeYear(e){return"number"==typeof e&&(e=[e]),_m(e)?t=>e.includes(t.getMonth()+1):e}configureDatePicker(e,t,n){const{includeYear:i}=t,r=fr.add(t.baseDate,e,"month");let s={date:r,activeDate:null,includeYear:i(r),multiSelect:t.multiSelect,selection:t.selection,weekStartDay:t.weekStartDay};return n||(s=Im.mergeConfigs(t.datePickerDefaults,s,{cellRenderer:t.cellRenderer,headerRenderer:t.headerRenderer,weekRenderer:t.weekRenderer})),s}ensurePlan(e){return fr.isDate(e)&&(e={date:e}),e.date&&delete(e={...e,index:this.indexFromDate(e.date)}).date,e}getCell(e){return"string"!=typeof e&&(e=fr.makeKey(e)),this.element.querySelector(`[data-date="${e}"]:not(.b-other-month)`)}indexFromDate(e){return e?Bm(e)-Bm(this.baseDate):e}onDatePickerSelectionChange({selection:e,userAction:t}){if(t){const t=this,{_isUserAction:n}=t;t._isUserAction=!0,t.syncSelection("picker",e),t._isUserAction=n}}onNextMonthClick(){this.forward()}onPrevMonthClick(){this.backward()}onYearPickedMulti({source:e,value:t}){const n=e.up("datepicker"),{focusableElement:i}=n;null==i||i.focus({preventScroll:!0}),e.hide(),t-=n.activeDate.getFullYear(),this.go(12*t)}updateAtMax(e,t){const{nextButton:n,prevButton:i}=this.widgetMap;super.updateAtMax(e,t),n&&(n.containsFocus&&(null==i||i.focus()),n.isTabbable=!e,n.hidden=e)}updateAtMin(e,t){const{nextButton:n,prevButton:i}=this.widgetMap;super.updateAtMin(e,t),i&&(i.containsFocus&&(null==n||n.focus()),i.isTabbable=!e,i.hidden=e)}changeDate(e){return e&&fr.clamp(e,this.minDate,this.maxDate)}updateDate(e){null!=e&&(this.currentIndex=this.indexFromDate(e))}updateMaxDate(){this.syncDateRange()}updateMinDate(){this.syncDateRange()}syncDateRange(){this.range=[this.minDate,this.maxDate]}updateNavButtons(e){this.detachListeners("navButtons"),!0===e&&ti.ion({theme:()=>this.recompose(),name:"navButtons",thisObj:this})}changeRange(e,t){if(_m(e)){let t,[n,i]=e;fr.isDate(n)&&(n=this.indexFromDate(n),t=!0),fr.isDate(i)&&(i=this.indexFromDate(i),t=!0),t&&(e=[n,i])}return super.changeRange(e,t)}changeSelection(e,t){if(e){if(e.isDateSet&&(t===e||null!=t&&t.equals(e)))return t}else e=new jm;return e}updateSelection(e){const t=this;t.syncSelection("selection",e),t.isConfiguring?e&&(t.date=e[0]):t.trigger("selectionChange",{selection:e,userAction:t._isUserAction})}syncSelection(e,t=this.selection){const{datePickers:n}=this;"selection"!==e&&(this.selection=t),"picker"!==e&&n.forEach((e=>e.selection=t))}}Vm.initClass(),Vm._$name="MultiDatePicker";class zm extends(Vm.mixin($m)){static $name="DateRangePicker";static type="daterangepicker";static configurable={confirmable:null,datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}},keyMap:{delegate:"confirmable"},multiSelect:"range",selection:["today","today"],stripDefaults:{bbar:{type:"confirmationbar"}},tbar:{items:{spacer:{type:"widget",flex:1,weight:0}}}};get dateFieldContainer(){return this.tbar}changeConfirmable(e){return this.bbar=e,this.bbar}updateConfirmable(e){this.detachListeners("confirmable"),null==e||e.ion({name:"confirmable",thisObj:this,choice:"doConfirm"})}get isValid(){return this.checkValid()}configureDatePicker(e,t,n){const i=super.configureDatePicker(e,t,n);return i.selection=this.selection,i}onDatePickerBeforeDateSelect({date:e}){return this.applyDate(e,this.fieldStartDate,this.fieldEndDate),!1}doConfirm({choice:e,event:t,userAction:n}){this.trigger("confirm",{choice:e,event:t,userAction:n})}internalOnKeyDown(e){const{confirmable:t}=this;let n=null==t?void 0:t.hotKeys[e.virtualKey];n?("default"===n&&(n=t.defaultButton),n&&this.doConfirm({event:e,choice:{[n]:!0,name:n}})):super.internalOnKeyDown(e)}syncSelection(e,t=this.selection){super.syncSelection(e,t),"value"!==e&&this.syncValue("selection",t)}syncValue(e,t=this.value){var n,i;const r=this,s=(null===(n=t)||void 0===n?void 0:n[1])<(null===(i=t)||void 0===i?void 0:i[0]);let o;"fieldEndDate"===e?(o=2,s&&(t=[t[1],t[1]])):"fieldStartDate"===e&&(o=1,s&&(t=[t[0],t[0]])),o&&t&&!r.isConstructing&&r.ensureVisible(t[o-1]),"selection"!==e&&r.syncSelection("value",t),super.syncValue(e,t)}triggerChange(e,t=Boolean(this._isUserAction)){const{value:n,_lastValue:i,isValid:r}=this;this.triggerFieldChange({value:n,oldValue:i,event:e,userAction:t,valid:r})}}zm.initClass(),zm._$name="DateRangePicker";class Nm extends(kg.mixin($m)){static $name="DateRangeField";static type="daterangefield";static alias="daterange";static configurable={inline:!0,confirmable:null,container:{},confirmableDefaults:{type:"daterangepicker",navButtons:"floating",trapFocus:!0,align:{align:"t100-t100",offset:'[data-ref="fieldEndDate"]',overlap:!0},fieldStartDate:{triggers:{expand:{align:"start",disabled:!0}}}},fieldEndDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:null}},fieldEndTime:null,fieldEndTimeDefaults:{ref:"fieldEndTime",cls:"b-end-time",weight:20},fieldStartDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:{handler:"up.onExpandPicker",align:"start"}}},fieldStartTime:null,fieldStartTimeDefaults:{ref:"fieldStartTime",cls:"b-start-time",weight:10},keepTime:null,keyMap:{ArrowDown:"onTriggerKeyDown",ArrowUp:"onKeyArrowUp",Enter:"onKeyEnter",Escape:"onKeyEscape"},max:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},min:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},nonConfirmableDefaults:{type:"multidatepicker",align:{align:"t100-r100"},datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}}},picker:{cls:"b-daterangefield-picker",floating:!0,hideMode:"clip",multiSelect:"range",scrollAction:"realign",align:{axisLock:!0}},pickerAlignElement:"container.element",pickerCls:null,pickTime:null,stepSmall:"7 days",timeFormat:"HH:mm:ss:SSS",triggers:{expand:null},weekStartDay:null,timeFieldDefaults:{type:"timefield",autoSelect:!0,picker:{align:{align:"b0-t0"}},triggers:{expand:null}}};get dateFieldContainer(){return this.container}get innerElements(){return[]}get maxDate(){return this.max}get minDate(){return this.min}compose(){const{pickTime:e}=this;return{class:{"b-pick-time":Boolean(e)}}}updateConfirmable(){this.isConstructing||(this.picker=this._pickerConfig)}changeEndTimeField(e,t){return Lm.reconfigure(t,e,{owner:this,defaults:Lm.mergeConfigs(this.timeFieldDefaults,this.fieldEndTimeDefaults)})}updateEndTimeField(e){e&&this.container.add(e)}changeStartTimeField(e,t){return Lm.reconfigure(t,e,{owner:this,defaults:Lm.mergeConfigs(this.timeFieldDefaults,this.fieldStartTimeDefaults)})}updateStartTimeField(e){e&&this.container.add(e)}updateKeepTime(e){e=!this.pickTime&&e,this.fieldEndDate.keepTime=e,this.fieldStartDate.keepTime=e}updateMax(e){const{fieldEndDate:t,fieldStartDate:n,_picker:i}=this;t.max=e,n.max=e,i&&(i.maxDate=e),this.syncInvalid()}updateMin(e){const{fieldEndDate:t,fieldStartDate:n,_picker:i}=this;t.min=e,n.min=e,i&&(i.minDate=e),this.syncInvalid()}changePicker(e,t){const n=this,{confirmable:i,pickerAlignElement:r}=n,s=i?n.confirmableDefaults:n.nonConfirmableDefaults,o=Tc.resolveType(s.type),a=o.mergeConfigs({owner:n,forElement:r,minDate:n.min,maxDate:n.max,selection:n.value,weekStartDay:n._weekStartDay,align:{anchor:n.overlayAnchor,target:r}},s,i&&{confirmable:i});return n._pickerConfig=e,W.isObject(e)&&(e=W.merge({type:a.type},e)),o.reconfigure(t,e,{owner:n,defaults:a})}updatePicker(e,t){super.updatePicker(e,t),this.detachListeners("dateRangeField.picker"),null==e||e.ion({name:"dateRangeField.picker",thisObj:this,selectionChange:"onPickerSelectionChange",confirm:"onPickerConfirm",focusIn:"onPickerFocusIn"})}updatePickerCls(e,t){var n;const i=null===(n=this.picker)||void 0===n||null===(n=n.element)||void 0===n?void 0:n.classList;t&&(null==i||i.remove(t)),e&&(null==i||i.add(e))}updatePickTime(e){let t=null,n=null;!0===e?t=n={}:e&&(e.fieldStartTime||e.fieldEndTime?(n=e.fieldStartTime,t=e.fieldEndTime):n=t=e),this.fieldEndTime=t,this.fieldStartTime=n}changeValue(e){const t=this;if(!e||fr.isDate(e[0])&&fr.isDate(e[1]))return t.clearError("L{DateField.invalidDate}"),e;t.setError("L{DateField.invalidDate}")}get weekStartDay(){return"number"==typeof this._weekStartDay?this._weekStartDay:fr.weekStartDay}updateWeekStartDay(e){this._picker&&(this._picker.weekStartDay=e)}maybeHidePicker(){if(!this.picker.isVisible||this.confirmable)return!1;this.hidePicker()}onDatePickerBeforeDateSelect({date:e}){return this.picker.applyDate(e,this.fieldStartDate,this.fieldEndDate),!1}onDateFieldChange({source:e}){const t=this,{ref:n}=e,i="fieldStartDate"===n?0:1,{pickTime:r}=t;let s,o,a,l,c;t.isConstructing||(s=e.value,o=1-i,l=t.value,s&&(r?(a=i?t.fieldStartTime:t.fieldEndTime,s=fr.combineDateAndTime(s,a.value)):s=fr.clearTime(s),c=[s,s],l&&(c[o]=l[o],c[1]<c[0]&&(c[o]=fr.combineDateAndTime(s,c[o]),c[1]<c[0]&&(c[o]=s))),t.syncValue(n,c)))}onKeyArrowUp(e){const t=this,{picker:n}=t;if(n.isVisible)return!t.confirmable&&t.stepUp(e);t.showPicker()}onKeyEnter(){this.maybeHidePicker()}onKeyEscape(){this.maybeHidePicker()}onExpandPicker(){this.confirmable?this.showPicker():this.togglePicker()}onPickerSelectionChange({selection:e,userAction:t}){if(!this.confirmable){const n=this,{_isUserAction:i}=n;n._isUserAction=t||i,n.syncValue("picker",e),n._isUserAction=i}}onPickerConfirm({choice:e,source:t,userAction:n}){const i=this,{_isUserAction:r}=i,s=t.containsFocus&&(t.pickingStartDate?i.fieldStartDate:i.fieldEndDate);e.ok&&(i._isUserAction=n||r,i.syncValue("picker",t.value),i._isUserAction=r),i.hidePicker(),null==s||s.focus()}onPickerFocusIn({relatedTarget:e}){const{fieldEndDate:t,fieldStartDate:n}=this.container.widgetMap,i=e===n?n:t;!this.confirmable&&i.focus()}onTriggerKeyDown(e){return this.picker.isVisible&&!this.confirmable?this.stepDown(e):super.onTriggerKeyDown(e)}focusPicker(){const{picker:e}=this,{fieldEndDate:t,fieldStartDate:n}=this.container.widgetMap,{tbar:i}=e,{fieldEndDate:r,fieldStartDate:s}=(null==i?void 0:i.widgetMap)||{},o=i?t.containsFocus&&r||s:t.containsFocus&&t||n;o.focus(),o!==e&&(e.ensureVisible({animate:!1,date:o.value}),o.selectAll())}showPicker(e){const t=this,{_picker:n}=t;t.readOnly||(n&&(n.range=[t.min,t.max],n.selection=t.value),e=e||Boolean(t.confirmable),super.showPicker(e))}get isValid(){const e=this,t=e.checkMinMax();return e.clearError("L{Field.minimumValueViolation}",!0),e.clearError("L{Field.maximumValueViolation}",!0),t?(e.setError(t<0?"L{Field.minimumValueViolation}":"L{Field.maximumValueViolation}",!0),!1):super.isValid}setupLabel(e){return super.setupLabel(W.assign({for:this.fieldStartDate.input.id},e))}syncInputFieldValue(){}syncValue(e,t=this.value){var n,i;const r=this,{_picker:s}=r,o=(null===(n=t)||void 0===n?void 0:n[1])<(null===(i=t)||void 0===i?void 0:i[0]);if(null!=s&&s.isVisible&&!r.confirmable){let n;"fieldEndDate"===e?(n=2,o&&(t=[t[1],t[1]])):"fieldStartDate"===e&&(n=1,o&&(t=[t[0],t[0]])),n&&t&&!r.isConstructing&&s.ensureVisible(t[n-1])}"picker"!==e&&s&&(s.selection=t),super.syncValue(e,t)}}Nm.initClass(),Nm._$name="DateRangeField";const Wm=new Date(2e3,0,1);class Um extends Ig{static $name="DateTimeField";static type="datetimefield";static alias="datetime";static configurable={timeField:{type:"timefield"},dateField:{type:"datefield",keepTime:!0,step:"1 d"},weekStartDay:null,inputTemplate:()=>"",ariaElement:"element"};doDestroy(){this.dateField.destroy(),this.timeField.destroy(),super.doDestroy()}get childItems(){return[this.dateField,this.timeField]}get fieldDefaults(){const{revertOnEscape:e,tabIndex:t}=this;return null==t?{revertOnEscape:e}:{revertOnEscape:e,tabIndex:t}}get focusElement(){return this.dateField.input}get innerElements(){return[this.dateField.element,this.timeField.element]}internalOnKeyEvent(){}updateRevertOnEscape(e){this.timeField.revertOnEscape=e,this.dateField.revertOnEscape=e}changeTimeField(e,t){return Lm.reconfigure(t,e,{owner:this,defaults:this.fieldDefaults})}updateTimeField(e){const t=this;Xt.on({element:e.element,keydown:"onTimeFieldKeyDown",thisObj:t}),Ne.after(e,"syncInvalid",(()=>{t.timeField&&!t.updatingInvalid&&t.syncInvalid()})),e.ion({thisObj:t,change({userAction:e,value:n}){if(e&&!t.$settingValue){const e=t.dateField.value;t._isUserAction=!0,t.value=e?fr.copyTimeValues(new Date(e),n||Wm):null,t._isUserAction=!1}}}),t.readOnly&&(e.readOnly=!0)}changeDateField(e,t){return Am.reconfigure(t,e,{owner:this,defaults:this.fieldDefaults})}updateDateField(e){const t=this;Xt.on({element:e.element,keydown:"onDateFieldKeyDown",thisObj:t}),Ne.after(e,"syncInvalid",(()=>{t.dateField&&!t.updatingInvalid&&t.syncInvalid()})),e.ion({thisObj:t,change({userAction:e,value:n}){e&&!t.$isInternalChange&&(t._isUserAction=!0,t.timeField.value=n,t.value=n,t._isUserAction=!1)},keydown({event:e}){var n;"Tab"===e.key&&!e.shiftKey&&null!==(n=t.timeField)&&void 0!==n&&n.isVisible&&e.stopPropagation()}}),t.readOnly&&(e.readOnly=!0)}updateWeekStartDay(e){this.dateField&&(this.dateField.weekStartDay=e)}changeWeekStartDay(e){var t;return"number"==typeof e?e:(null===(t=this.dateField)||void 0===t?void 0:t.weekStartDay)??fr.weekStartDay}syncInputFieldValue(e=this.isConfiguring){super.syncInputFieldValue(!0);const t=this,{dateField:n,timeField:i}=t,r=n.highlightExternalChange,s=i.highlightExternalChange;e||t.highlightExternalChange||(e=!0),t.$isInternalChange=!0,n.highlightExternalChange=!1,n.highlightExternalChange=r,e&&(i.highlightExternalChange=n.highlightExternalChange=!1),i.value=n.value=t.inputValue,n.highlightExternalChange=r,i.highlightExternalChange=s,t.$isInternalChange=!1,t.syncInvalid()}onTimeFieldKeyDown(e){const t=this;if("Enter"===e.key||"Tab"===e.key){const e=t.dateField.value;t._isUserAction=!0,t.value=e?fr.copyTimeValues(new Date(e),t.timeField.value||Wm):null,t._isUserAction=!1}}onDateFieldKeyDown(e){const t=this;"Tab"!==e.key||e.shiftKey?"Enter"===e.key&&(t.value=t.dateField.value):(e.stopPropagation(),e.preventDefault(),t.timeField.focus())}updateRequired(e){this.timeField.required=this.dateField.required=e}updateReadOnly(e,t){super.updateReadOnly(e,t),this.isConfiguring||(this.timeField.readOnly=this.dateField.readOnly=e)}onDisabled(e){this.timeField.disabled=this.dateField.disabled=e}focus(){this.dateField.focus()}hasChanged(e,t){var n,i;return null!=e&&e.getTime&&null!=t&&t.getTime?!fr.isEqual(e,t):super.hasChanged(null==e||null===(n=e.getTime)||void 0===n?void 0:n.call(e),null==t||null===(i=t.getTime)||void 0===i?void 0:i.call(t))}get isValid(){return this.timeField.isValid&&this.dateField.isValid}setError(e,t){[this.dateField,this.timeField].forEach((n=>n.setError(e,t)))}getErrors(){const e=[...this.dateField.getErrors()||[],...this.timeField.getErrors()||[]];return e.length?e:null}clearError(e,t){[this.dateField,this.timeField].forEach((n=>n.clearError(e,t)))}updateInvalid(){this.updatingInvalid=!0,this.dateField.updateInvalid(),this.timeField.updateInvalid(),this.updatingInvalid=!1}}Um.initClass(),Um._$name="DateTimeField";const Gm={lineNumber:0,column:0},Ym={lineNumber:Number.MAX_SAFE_INTEGER,column:Number.MAX_SAFE_INTEGER},qm=d.isBryntumOnline(["online"]),{pathname:Km}=globalThis.location,Xm=Km.endsWith("umd.html"),Zm=document.querySelector("script[type=module]"),Jm=Km.endsWith("module.html")||(null==Zm?void 0:Zm.src.includes("app.module.js"))||Km.endsWith("index.html")&&qm;class Qm extends gm{static $name="DemoCodeEditor";static type="democodeeditor";static configurable={mode:"vanilla",appFolder:"",collapsible:{type:"overlay",direction:"right",autoClose:!1},collapsed:!0,preferredSources:null,monitorResize:!1,editor:{lineNumbers:"off",foldingImportsByDefault:!0,minimap:{enabled:!1},ariaLabel:"Live code editor"},tbar:{overflow:null,items:{filesCombo:{type:"combo",flex:"1 1 100%",monitorResize:!1,editable:!1,fields:[{name:"text"}],listItemTpl:({text:e})=>{let t="b-fa-file";switch(e.split(".").pop()){case"js":case"jsx":case"ts":case"tsx":case"vue":t="b-fa-file-lines";break;case"css":case"scss":t="b-fa-palette";break;case"htm":case"html":case"json":t="b-fa-file-code"}const n=e.lastIndexOf("/")+1;return`<span class="b-editor-file-type b-fw-icon ${t}" ></span> <span class="b-editor-folder">${e.substring(0,n)}</span>${e.substring(n)}`},picker:{maxHeight:"calc(100vh * 3 / 4)"}}}},codeCache:{}};construct(e={}){super.construct(...arguments);const t=this,{rtl:n}=t;n&&(t.collapsible.direction="left"),new $u({targetSelector:".b-codeeditor",rightHandle:Boolean(n),leftHandle:!n,skipTranslate:!0,minWidth:190})}get isVanilla(){return"vanilla"===this.mode}get isFramework(){return"framework"===this.mode}updateMode(){this.title='<span class="title-container"><span class="title">'+(this.isVanilla?"L{CodeEditor.editor}":"L{CodeEditor.viewer}")+"</span></span>"}static loadMonacoEditor=async e=>{if(!gm.monacoLoadPromise){const t=Wn.createElement({tag:"script",parent:document.head,src:`${e}monaco-editor/min/vs/loader.js`});await new Promise((e=>t.addEventListener("load",e))),await(gm.monacoLoadPromise=new Promise((t=>{const n=globalThis.require;n.config({paths:{vs:`${e}monaco-editor/min/vs`}}),n(["vs/editor/editor.main"],(function(){t(globalThis.monaco)}))})))}};onCloseClick(){this.collapse()}async onFilesComboChange({value:e}){await this.loadCode(e)}async collapseBoilerplate(e){const{monacoInstance:t,editor:n}=this,{Selection:i}=t,r=[],s=e.findMatches("^import .*$",!0,!0);let o,a=!0;["baselines","children","segments","intervals","events","tasks","resources","assignments","dependencies","timeRanges","resourceTimeRanges","rows"].forEach((t=>{const n=`${t}\\s*(?:=|:)\\s*\\[`;for(o=e.findForwards(n,Gm,!0);o&&a;o=e.findForwards(n,a.range.getEndPosition(),!0))if(a=e.findForwards("\\](?:;|,)?\\s*$",o.range.getEndPosition(),!0),a){for(;a&&r.some((e=>e.containsRange(a.range)));)a=e.findForwards("\\](?:;|,)?\\s*$",a.range.getEndPosition(),!0);a&&r.push(new i(o.range.startLineNumber,1,a.range.endLineNumber+1,1))}}));let l,c=Gm;for(;l=e.findForwards("^\\s*//\\s*hide",c,!0);){const t=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?hide",{lineNumber:l.range.endLineNumber,column:0},!0);t&&r.push(new i(l.range.startLineNumber,1,t.range.endLineNumber+1,1)),c=(null==t?void 0:t.range.getEndPosition())||Ym}for(c=Gm;l=e.findForwards("^\\s*//\\s*region",c,!0);){const t=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?region",{lineNumber:l.range.endLineNumber,column:0},!0);t&&r.push(new i(l.range.startLineNumber,1,t.range.endLineNumber+1,1)),c=(null==t?void 0:t.range.getEndPosition())||Ym}s.length&&r.push(new i(1,1,s[s.length-1].range.startLineNumber+1,1));for(const e of r)n.setSelections([...n.getSelections(),e]),await n.getAction("editor.createFoldingRangeFromSelection").run()}set status(e){this.widgetMap.status.html=e}get isReadOnly(){return this.isFramework||"html"===this.fileExt||"js"===this.fileExt&&(this.hasImports||Xm)}toggleReadOnly(){const e=this,{contentElement:t,isReadOnly:n}=e;t.classList.toggle("readonly",n),e.status=n?"Read only"+(d.isCSP?" (Restricted by Content Security Policy)":d.isChrome||d.isFirefox?"":" (try it on Chrome or Firefox)"):"Idle",e.editor.updateOptions({readOnly:n})}async loadCode(e){e=`${this.appFolder}${e}`;const t=this,{isVanilla:n}=t;let i=t.codeCache[e],r=null;if(t.filename=e,!i)try{const n=await mi.get(location.href.replace(/[^/]*$/,"")+e);i=t.codeCache[e]=await n.text()}catch(e){i="",r=e}t.loadedCode=i,t.fileExt=e.split(".").pop();let s="plaintext";switch(t.fileExt){case"js":case"jsx":s="javascript";break;case"ts":case"tsx":case"vue":s="typescript";break;case"css":s="css";break;case"scss":s="scss";break;case"html":s="html";break;case"json":s="json"}t.language=s;const o=t.model=await t.loadText(i,s);o.findForwards=function(e,t){const n=o.findNextMatch(...arguments);if(n&&!n.range.getStartPosition().isBefore(t))return n},n&&"js"===t.fileExt&&await t.collapseBoilerplate(o),t.status=`${r?r.message:"Idle"}`,t.toggleReadOnly()}sortFileNamesWithHierarchy(e){const t=e=>{const n={};return Object.keys(e).sort(((t,n)=>{const i=null!==e[t],r=null!==e[n];return i&&!r?-1:!i&&r?1:t.localeCompare(n)})).forEach((i=>{n[i]=null!==e[i]?t(e[i]):e[i]})),n},n=(e,t="")=>{let i=[];return Object.keys(e).forEach((r=>{const s=`${t}${""!==t?"/":""}${r}`;null===e[r]?i.push(s):i=i.concat(n(e[r],s))})),i};return n(t((e=>{const t={};return e.forEach((e=>{const n=e.split("/");let i=t;n.forEach(((e,t)=>{i[e]||(i[e]=t===n.length-1?null:{}),i=i[e]}))})),t})(e)))}async initialLoadCode(){const e=this,{widgetMap:t,preferredSources:n}=e,{filesCombo:i}=t,r=i.store,s=`${e.appFolder}app.config.json`,o=(await mi.get(s,{parseJson:!0})).parsedJson,a=[];var l;e.isVanilla?(a.push(Jm?"index.module.html":Xm?"index.umd.html":"index.html",Jm?"app.module.js":Xm?"app.umd.js":"app.js"),Jm||Xm||null===(l=o.merge)||void 0===l||!l.length||(e.hasImports=!0,a.push(...o.merge)),document.head.querySelector('[href*="app.css"]')&&a.push("resources/app.css")):o.source.length?a.push(...o.source):console.warn(`No source files loaded from ${s}`);i.items=e.sortFileNamesWithHierarchy(a).map((e=>({text:e,value:e})));const c=(n||[]).map((e=>r.find((t=>e.test(t.value))))).find(Boolean)||r.first;i.value=c.value,await e.loadCode(c.value),i.onChange="up.onFilesComboChange",e.toggleReadOnly(),i.readOnly=1===r.count}static get monacoCodePath(){const e=/(.*?\/)examples/.exec(document.location.href);return e?`${e[1]}examples/_shared/browser/lib/monaco-editor`:void 0}static async toggleCodeEditor(e,t,n){return!e&&(e=new Qm({mode:"framework",appendTo:document.body,codePath:Qm.monacoCodePath,appFolder:"../",...n}),Tc.disableThrow=!0,t.icon="b-icon-spinner",await e.initialLoadCode(),t.icon="b-icon-code"),e.collapsed?(await e.expandPanel(),e.focus()):await e.collapsePanel(),e}}Qm.initClass(),Qm._$name="DemoCodeEditor";class ep extends Ag{static $name="DurationField";static type="durationfield";static alias="duration";static get defaultConfig(){return{value:null,unit:null,defaultUnit:"day",magnitude:null,useAbbreviation:!1,allowNegative:!1,decimalPrecision:null,triggers:{spin:{type:"spintrigger"}},nullValue:null}}static get configurable(){return{min:null,max:null,allowedUnits:null,step:1}}changeMin(e){return"string"==typeof e?new Ps(e):e}changeMax(e){return"string"==typeof e?new Ps(e):e}changeAllowedUnits(e){return"string"==typeof e&&(e=e.split(",")),e.length>0&&!e.includes(this.defaultUnit)&&(this.defaultUnit=e[0]),e}updateAllowedUnits(e){this.allowedUnitsRe=new RegExp(`(${e.join("|")})`,"i")}get inputValue(){return null==this.value?"":this.calcValue(!0).toString(this.useAbbreviation,this.decimalPrecision)}set unit(e){this._unit=e,this.value=this.calcValue()}get unit(){return this._unit}get unitWithDefault(){return this._unit||this.defaultUnit}set magnitude(e){this.clearError("L{invalidUnit}"),this._magnitude=e,super.value=this.calcValue()}get magnitude(){return this._magnitude}roundMagnitude(e){return e&&null!=this.decimalPrecision?W.round(e,this.decimalPrecision):e}get allowDecimals(){return 0!==this.decimalPrecision}get isValid(){const e=this,t=e.input.value,n=fr.parseDuration(t,e.allowDecimals,t.match(/[\p{Letter}\p{Mark}]+/giu)?void 0:e.unitWithDefault),i=!t||n&&null==n.magnitude;return e.skipValidation||super.isValid&&(i&&!e.required||!i&&(e.allowNegative||(null==n?void 0:n.magnitude)>=0))}internalOnChange(e){const t=this,n=t.value,i=t._lastValue;t.hasChanged(i,n)&&(t._lastValue=n,t.triggerFieldChange({value:n,event:e,userAction:!0,valid:t.isValid}))}onFocusOut(e){var t;return this.syncInputFieldValue(!0),null===(t=this.triggers)||void 0===t||null===(t=t.spin)||void 0===t||null===(t=t.clickRepeater)||void 0===t||t.cancel(),super.onFocusOut(e)}set value(e){const t=this;let n,i;if(t.getConfig("allowedUnits"),t.clearError("L{invalidUnit}"),"number"==typeof e||"string"==typeof e&&e.length>0&&!isNaN(e))n=Number(e),i=t.unitWithDefault;else if("string"==typeof e)if(/^\s*$/.test(e))n=null;else{const r=fr.parseDuration(e,t.allowDecimals,t.unitWithDefault);r&&(!t.allowedUnitsRe||t.allowedUnitsRe.test(r.unit)?(i=r.unit,n=r.magnitude):t.setError("L{invalidUnit}"))}else e&&"unit"in e&&"magnitude"in e?(i=e.unit,n=e.magnitude):(i=null,n=null);t._magnitude===n&&t._unit==i||(t._magnitude=n,i&&(t._unit=i),super.value=t.calcValue())}okMax(e){return"number"==typeof e&&(e=new Ps({unit:this.unitWithDefault,magnitude:e})),null==this.max||e<=this.max}okMin(e){return"number"==typeof e&&(e=new Ps({unit:this.unitWithDefault,magnitude:e})),null==this.min||e>=this.min}get validity(){const e=this.value,t={};return null!=e&&(t.rangeUnderflow=!this.okMin(e),t.rangeOverflow=!this.okMax(e)),t.valid=!t.rangeUnderflow&&!t.rangeOverflow,t}get value(){return super.value}calcValue(e=!1){const t=this;return t._unit&&null!=t._magnitude||!t.clearable?new Ps(e?this.roundMagnitude(t._magnitude):this._magnitude,t.unitWithDefault):null}hasChanged(e,t){return t&&!e||!t&&e||t&&e&&!e.isEqual(t)}get milliseconds(){return this.value?this.value.milliseconds:0}onInternalKeyDown(e){"ArrowUp"===e.key?this.doSpinUp():"ArrowDown"===e.key&&this.doSpinDown()}doSpinUp(){const e=this;let{value:t}=e;if(e.readOnly)return;t||(t=new Ps({magnitude:0,unit:this.defaultUnit}));let n=t.add(this._step);e.okMin(n)||(n=e.min),e.okMax(n)&&(e.value=n)}doSpinDown(){const e=this;let{value:t}=e;if(e.readOnly)return;t||(t=new Ps({magnitude:0,unit:this.defaultUnit}));let n=t.add({magnitude:-this._step.magnitude,unit:this._step.unit});e.okMax(n)||(n=e.max),e.okMin(n)&&(e.allowNegative||(e.magnitude||0)>0)&&(e.value=n)}changeStep(e,t){const n=typeof e;return e?("number"===n?e={magnitude:Math.abs(e),unit:void 0}:"string"===n&&(e=fr.parseDuration(e)),e&&e.unit&&e.magnitude&&e.magnitude<0&&(e={magnitude:-e.magnitude,unit:e.unit}),e):null}updateStep(e){this.element.classList.toggle("b-no-steppers",Boolean(e)),this.syncInvalid()}}ep.initClass(),ep._$name="DurationField";class tp extends Ic{static $name="Fit";static type="fit";static configurable={containerCls:"b-fit-container",itemCls:"b-fit-item"}}tp.initClass(),tp._$name="Fit";class np extends Nc{static $name="Editor";static type="editor";static configurable={positioned:!0,hidden:!0,layout:"fit",align:{align:"t0-t0",offset:[0,0]},hideTarget:!1,appendToTargetParent:!1,matchSize:!0,matchFont:!0,fitTargetContent:!1,inputField:"textfield",blurAction:"complete",completeKey:"Enter",cancelKey:"Escape",invalidAction:"block",completeOnChange:null,isolateFields:!0,instantUpdate:!1};afterConfigure(){const e=this;super.afterConfigure(),e.onTargetSizeChange=e.onTargetSizeChange.bind(e),Xt.on({element:e.element,keydown:"onEditorKeyDown",contextmenu:"stopMouseEvents",mousedown:"stopMouseEvents",mouseover:"stopMouseEvents",mouseout:"stopMouseEvents",mouseup:"stopMouseEvents",click:"stopMouseEvents",dblclick:"stopMouseEvents",thisObj:e}),e.ion({beforeHide:"beforeEditorHide",hide:"afterEditorHide"}),yi.ion({locale:"onLocaleChange",thisObj:e})}onLocaleChange(){const{inputField:e}=this;e&&!e.isDestroyed&&e.syncInputFieldValue&&e.syncInputFieldValue(!0)}render(e){const t=this.element.parentNode,[n]=this.getRenderContext(this,e);n.classList.add("b-editing"),super.render(...arguments),null!=t&&t.classList&&n!==t&&t.classList.remove("b-editing")}async startEdit(e){const t=this;if(e=W.assignIf(e,{align:t.align,hideTarget:t.hideTarget,matchSize:t.matchSize,matchFont:t.matchFont,fitTargetContent:t.fitTargetContent,focus:!0}),t.isVisible&&await t.completeEdit(),!1!==t.trigger("beforeStart",e)){var n,i,r;const{target:s,hideTarget:o,matchSize:a,matchFont:l,fitTargetContent:c,record:d,field:u=t.inputField.name,focus:h}=e,{inputField:g,appendToTargetParent:m}=t,{input:p}=g,f=Wn.getStyleValue(s,"font-size"),v=Wn.getStyleValue(s,"font-family");let{value:y,align:b}=e;if(d&&u&&(t.record=d,t.dataField=u,g.assignFieldValue!==Tc.prototype.assignFieldValue?y=g.value:void 0===y&&(y=d.getValue(u))),m&&s.nodeType===Node.ELEMENT_NODE&&s.parentElement.appendChild(t.element),a&&(s instanceof HTMLElement&&t.updateSize(s,a),s instanceof HTMLElement&&Hl.addResizeListener(s,t.onTargetSizeChange)),p&&(l?(p.style.fontSize=f,p.style.fontFamily=v):p.style.fontSize=p.style.fontFamily=""),t.assigningValues=!0,null===(n=g.clearError)||void 0===n||n.call(g),"setValue"in g?await g.setValue(y):g.value=y,t.assigningValues=!1,"string"==typeof b&&(b={align:b}),await t.showBy({target:s,allowTargetOut:!0,...b}),c){const e=p.scrollWidth-p.clientWidth;e>0&&(t.width+=e+Wn.scrollBarWidth)}h&&(null===(i=g.focus)||void 0===i||i.call(g)),s.nodeType===Element.ELEMENT_NODE&&o&&s.classList.add("b-hide-visibility"),t.editing=!0;const C=g.value;return t.trigger("start",{value:C}),Array.isArray(C)&&g.editingRecords&&null!==(r=C[0])&&void 0!==r&&r.isModel?t.oldValue=C.map((e=>e.copy(e.id))):(t.oldValue=C,Array.isArray(t.oldValue)&&(t.oldValue=t.oldValue.slice())),g.initialValue=t.oldValue,!0}return!1}async refreshEdit(){if(this.isVisible){const{record:e,dataField:t,inputField:n}=this;if(e&&t){const i=e.getValue(t);W.isEqual(n.value,i)||await n.setValue(i)}}}finishEdit(){const{target:e,aligningToElement:t}=this.lastAlignSpec;t&&(e.classList.remove("b-editing"),e.classList.remove("b-hide-visibility")),this.editing=!1,this.trigger("finishEdit")}onEditorKeyDown(e){var t;const n=this;switch(e.key){case n.completeKey:n.completeEdit(null,e),e.stopImmediatePropagation();break;case n.cancelKey:n.cancelEdit(e),e.stopImmediatePropagation()}null===(t=n.trigger)||void 0===t||t.call(n,"keyDown",{event:e})}stopMouseEvents(e){this.allowMouseEvents||e.stopPropagation()}onFocusOut(e){super.onFocusOut(e);const t=this;if(!t.isFinishing&&t.editing)switch(t.blurAction){case"cancel":t.cancelEdit(e);break;case"complete":t.completeEdit(null,e)}}async completeEdit(e,t){const n=this,{inputField:i,oldValue:r,record:s}=n,o=i.invalidAction||(!1===i.allowInvalid?"block":n.invalidAction),{value:a}=i;if(n.isVisible){if(i.isValid||"allow"===o){if(W.isEqual(a,r))return!1!==n.cancelEdit(t);{const t={inputField:i,record:s,value:a,oldValue:r};if(!1!==n.trigger("beforeComplete",t)){var l;if(!e)e=t.finalize||(null===(l=t.editorContext)||void 0===l?void 0:l.finalize);if(e){let s=await e(t);if(!0===s)n.onEditComplete();else{if(i.setError){const e=s||i.invalidValueError,t=()=>{n(),i.clearError(e)},n=i.ion({change:t,input:t});i.setError(e)}var c;if("block"===o)null===(c=i.focus)||void 0===c||c.call(i);else"revert"===o&&(await i.setValue(r),s=!0);s=!1}return s}return n.onEditComplete(),!0}var d;null===(d=i.focus)||void 0===d||d.call(i)}}else{var u;if("block"===o)return null===(u=i.focus)||void 0===u||u.call(i),!1;if("revert"===o)return!1!==n.cancelEdit(t)}return!1}}cancelEdit(e){const t=this,{inputField:n,oldValue:i}=t,{value:r}=n;if(!t.editing||t.isFinishing||!1===t.trigger("beforeCancel",{value:r,oldValue:i,event:e}))return!1;var s;null===(s=n.clearError)||void 0===s||s.call(n),t.isFinishing=!0,t.hide(),t.trigger("cancel",{value:r,oldValue:i,event:e}),t.finishEdit(),t.isFinishing=!1}onEditComplete(){const e=this,{record:t,dataField:n,inputField:i,oldValue:r}=e;let{value:s}=i;if(!e.isFinishing){if(e.isFinishing=!0,e.hide(),t&&(!e.instantUpdate||i._outstandingUpdate)){const e=`set${H.capitalize(n)}`;!t.isFieldModified(n)||null!=t.getUnmodified(n)||null!=s&&""!==s||(s=t.meta.modified[n]),t[e]?t[e](s):t.setValue(n,s)}e.trigger("complete",{value:s,oldValue:r}),e.finishEdit(),e.isFinishing=!1}}doDestroy(){this.createdInputField&&this.inputField.destroy(),super.doDestroy()}set owner(e){this._owner=e}get owner(){return this._owner||Tc.fromElement(this.element.parentNode)}changeInputField(e,t){const n=this;return t&&t.destroy(),"string"==typeof e&&(e={type:e}),e instanceof Tc||(e.type||(e.type="textfield"),e=Tc.create(e),n.createdInputField=!0),n.completeOnChange&&e.ion({change:"onInputFieldChange",thisObj:n}),e.parent=n,e}updateInputField(e){this.removeAll(),this.add(e)}get inputField(){return this.items[0]}onInputFieldChange(){this.containsFocus&&this.completeEdit()}onTargetSizeChange(e,t,n){t&&n&&this.updateSize(e)}updateSize(e,t=this.lastMatchSize){const n=this,i=Pt.inner(e);n.width=!1===t.width?"auto":i.width-n.align.offset[0],n.height=!1===t.height?"auto":i.height,n.lastMatchSize=t}beforeEditorHide(){if(this.editing&&!this.isFinishing)return this.cancelEdit(),!1}afterEditorHide(){this.positioned&&this.element.remove(),Hl.removeResizeListener(this.lastAlignSpec.target,this.onTargetSizeChange)}}function ip(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var i=n.call(e,t||"default");if("object"!=typeof i)return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}np.initClass(),np._$name="Editor";const rp={number:!0,boolean:!0,string:!0,date:!0,duration:!0,time:!0,auto:!0},sp={number:!0,boolean:!0,string:!0},op=e=>{var t;return"duration"===(null==e||null===(t=e.column)||void 0===t?void 0:t.type)},ap="b-fieldfilterpicker",lp={between:!0,notBetween:!0,isIncludedIn:!0,isNotIncludedIn:!0},cp={textfield:!0,datefield:!0,numberfield:!0,durationfield:!0,combo:!0,timefield:!0},dp={value:"empty",text:"L{isEmpty}",argCount:0},up={value:"notEmpty",text:"L{isNotEmpty}",argCount:0},hp={value:"=",text:"L{equals}"},gp={value:"!=",text:"L{doesNotEqual}"},mp={value:">",text:"L{isGreaterThan}"},pp={value:"<",text:"L{isLessThan}"},fp={value:">=",text:"L{isGreaterThanOrEqualTo}"},vp={value:"<=",text:"L{isLessThanOrEqualTo}"},yp={value:"between",text:"L{isBetween}",argCount:2},bp={value:"notBetween",text:"L{isNotBetween}",argCount:2},Cp={value:"isIncludedIn",text:"L{isOneOf}",isArrayValued:!0},Sp={value:"isNotIncludedIn",text:"L{isNotOneOf}",isArrayValued:!0};class Dp extends Nc{static $name="FieldFilterPicker";static type="fieldfilterpicker";static defaultOperators={string:[dp,up,hp,gp,{value:"includes",text:"L{contains}"},{value:"doesNotInclude",text:"L{doesNotContain}"},{value:"startsWith",text:"L{startsWith}"},{value:"endsWith",text:"L{endsWith}"},Cp,Sp],number:[dp,up,hp,gp,mp,pp,fp,vp,yp,bp,Cp,Sp],date:[dp,up,hp,gp,{value:"<",text:"L{isBefore}"},{value:">",text:"L{isAfter}"},yp,{value:"isToday",text:"L{isToday}",argCount:0},{value:"isTomorrow",text:"L{isTomorrow}",argCount:0},{value:"isYesterday",text:"L{isYesterday}",argCount:0},{value:"isThisWeek",text:"L{isThisWeek}",argCount:0},{value:"isNextWeek",text:"L{isNextWeek}",argCount:0},{value:"isLastWeek",text:"L{isLastWeek}",argCount:0},{value:"isThisMonth",text:"L{isThisMonth}",argCount:0},{value:"isNextMonth",text:"L{isNextMonth}",argCount:0},{value:"isLastMonth",text:"L{isLastMonth}",argCount:0},{value:"isThisYear",text:"L{isThisYear}",argCount:0},{value:"isNextYear",text:"L{isNextYear}",argCount:0},{value:"isLastYear",text:"L{isLastYear}",argCount:0},{value:"isYearToDate",text:"L{isYearToDate}",argCount:0},Cp,Sp],boolean:[{value:"isTrue",text:"L{isTrue}",argCount:0},{value:"isFalse",text:"L{isFalse}",argCount:0}],duration:[dp,up,hp,gp,mp,pp,fp,vp,yp,bp,Cp,Sp],time:[dp,up,hp,gp,mp,pp,fp,vp,yp,bp,Cp,Sp],relation:[dp,up,hp,gp,Cp,Sp],auto:[{value:"*",text:"L{contains}"}]};static get defaultValueFieldPlaceholders(){return{string:"L{enterAValue}",number:"L{enterANumber}",date:"L{selectADate}",relation:"L{selectValue}",list:"L{selectOneOrMoreValues}",duration:"L{enterAValue}",time:"L{selectATime}",auto:"L{enterAValue}"}}static#e=(()=>{ip(this,"configurable",{fields:null,disabled:!1,readOnly:!1,layout:"vbox",propertyLocked:!1,operatorLocked:!1,filter:null,propertyFieldConfig:null,operatorFieldConfig:null,valueFieldCls:null,triggerChangeOnInput:!0,items:{inputs:{type:"container",layout:"hbox",cls:`${ap}-inputs`,items:{propertyPicker:{type:"combo",items:{},cls:`${ap}-property`,placeholder:"L{FieldFilterPicker.selectAProperty}",highlightExternalChange:!1},operatorPicker:{type:"combo",items:{},cls:`${ap}-operator`,placeholder:"L{FieldFilterPicker.selectAnOperator}",highlightExternalChange:!1},valueFields:{type:"container",cls:`${ap}-values`,items:{}}}},caseSensitive:{type:"checkbox",text:"L{FieldFilterPicker.caseSensitive}",cls:`${ap}-case-sensitive`}},operators:Dp.defaultOperators,dateFormat:"L{FieldFilterPicker.dateFormat}",store:null,valueFieldPlaceholders:null,getValueFieldConfig:null}),ip(this,"buildOperatorArgCountLookup",(e=>$e.keyBy(Object.entries(e),(([e])=>e),(([,e])=>$e.keyBy(e,(({value:e})=>e),(({argCount:e})=>void 0===e?1:e))))))})();afterConstruct(){const e=this;if(!e._fields)throw new Error(`${Dp.name} requires 'fields' to be configured.`);if(!e._filter)throw new Error(`${Dp.name} requires 'filter' to be configured.`);super.afterConstruct();const{widgetMap:{propertyPicker:t,operatorPicker:n,caseSensitive:i}}=e;t.ion({select:"onPropertySelect",thisObj:e}),n.ion({select:"onOperatorSelect",thisObj:e}),i.ion({change:"onCaseSensitiveChange",thisObj:e}),e.propertyFieldConfig&&t.setConfig(e.propertyFieldConfig),e.operatorFieldConfig&&n.setConfig(e.operatorFieldConfig),t.cls=e.allPropertyPickerClasses,n.cls=e.allOperatorPickerClasses,e.populateUIFromFilter()}changeDateFormat(e){return this.L(e)}get allChildInputs(){const{propertyPicker:e,operatorPicker:t,caseSensitive:n}=this.widgetMap;return[e,t,...this.valueFields,n]}updateDisabled(e,t){super.updateDisabled(e,t),this.allChildInputs.forEach((t=>t.disabled=e))}updateReadOnly(e){const{propertyPicker:t,operatorPicker:n}=this.widgetMap;this.allChildInputs.forEach((t=>t.readOnly=e)),t.readOnly=t.readOnly||e,n.readOnly=n.readOnly||e}updatePropertyLocked(e){this.widgetMap.propertyPicker.readOnly=e||this.readOnly,this.widgetMap.propertyPicker.cls=this.allPropertyPickerClasses}updateOperatorLocked(e){this.widgetMap.operatorPicker.readOnly=e||this.readOnly,this.widgetMap.operatorPicker.cls=this.allOperatorPickerClasses}changeOperators(e){const t=e??Dp.defaultOperators;return Object.keys(t).reduce(((e,n)=>({...e,[n]:t[n].map((e=>({...e,text:this.L(e.text)})))})),{})}get isMultiSelectValueField(){var e;return["isIncludedIn","isNotIncludedIn"].includes(null===(e=this._filter)||void 0===e?void 0:e.operator)}get allPropertyPickerClasses(){var e;return new _t(`${ap}-property`,null===(e=this.propertyFieldConfig)||void 0===e?void 0:e.cls,{[`${ap}-combo-locked`]:this.propertyLocked})}get allOperatorPickerClasses(){var e;return new _t(`${ap}-operator`,null===(e=this.operatorFieldConfig)||void 0===e?void 0:e.cls,{[`${ap}-combo-locked`]:this.operatorLocked})}getValueFieldConfigs(){const e=this,{valueFieldCls:t,fieldType:n,_filter:{operator:i},onValueChange:r,filterValues:s,isMultiSelectValueField:o,operatorArgCount:a,getValueFieldConfig:l,fieldIsRelation:c,triggerChangeOnInput:d}=e,u=W.merge({},Dp.defaultValueFieldPlaceholders,e.valueFieldPlaceholders);if(!n||!i||0===a)return[];let h={type:"textfield",internalListeners:{change:r,input:d?r:null,thisObj:e},bubbleEvents:{keydown:!0},cls:t,dataset:{type:n},placeholder:e.L(u[o?"list":c?"relation":n]),highlightExternalChange:!1};return o||c?h={...h,type:"combo",multiSelect:o,createOnUnmatched:!0,items:e.getUniqueDataValues(s),value:s??[]}:["number","date","boolean","duration","time"].includes(n)&&(h.type=`${n}field`),l&&(h=e.callback(l,e,[e.filter,h])),o?[h]:$e.populate(a,(t=>[{type:"widget",tag:"div",cls:`${ap}-value-separator`,content:e.L("L{FieldFilterPicker.and}")},{...h,value:s[t]}])).flat().slice(1)}getUniqueDataValues(e=[]){var t;const n=this,{fieldType:i}=n;if(!n.store||null===(t=n._filter)||void 0===t||!t.property)return[];const{relatedDisplayField:r}=n.selectedField;let s,o;if(n.fieldIsRelation){const{foreignStore:e}=n.currentPropertyRelationConfig;r?(s=e.allRecords.reduce(((e,t)=>(null!=t.id&&e.push({text:t.getValue(r),value:t.id}),e)),[]),o=s.sort(((e,t)=>n.sortStrings(e.text,t.text)))):s=e.allRecords.map((e=>e.id))}else s=n.store.allRecords.map((e=>e.getValue(n._filter.property)));if(!o){s.push(...e);const t=$e.unique(s.reduce(((e,t)=>(null!=t&&""!==String(t).trim()&&("date"===i?e.push(t.valueOf()):"duration"===i?e.push(t.toString()):e.push(t)),e)),[]));o="string"===i?t.sort(n.sortStrings):"duration"===i?t.map((e=>new Ps(e))).filter((e=>e.isValid)).sort(n.sortDurations):t.sort(n.sortNumerics),"date"===i?o=o.map((e=>{const t=new Date(e);return{text:fr.format(t,n.dateFormat),value:e}})):"duration"===i&&(o=o.map((e=>e.toString())))}return o}sortStrings(e,t){return(e??"").localeCompare(t??"")}sortNumerics(e,t){return e-t}sortDurations(e,t){return e.valueOf()-t.valueOf()}get fieldType(){var e;return null===(e=this.selectedField)||void 0===e?void 0:e.type}get selectedField(){var e,t;return null===(e=this.fields)||void 0===e?void 0:e[null===(t=this._filter)||void 0===t?void 0:t.property]}get propertyOptions(){return Object.entries(this.fields??{}).filter((([,e])=>rp[e.type]||op(e))).map((([e,{title:t}])=>({value:e,text:t??e}))).sort(((e,t)=>e.text.localeCompare(t.text)))}get operatorOptions(){return this.operators[this.fieldIsRelation?"relation":this.fieldType]}get fieldIsRelation(){return Boolean(this.currentPropertyRelationConfig)}get currentPropertyRelationConfig(){var e;return null===(e=this.store)||void 0===e||null===(e=e.modelRelations)||void 0===e?void 0:e.find((({foreignKey:e})=>{var t;return e===(null===(t=this._filter)||void 0===t?void 0:t.property)}))}updateOperators(){delete this._operatorArgCountLookup}get operatorArgCountLookup(){return this._operatorArgCountLookup||(this._operatorArgCountLookup=Dp.buildOperatorArgCountLookup(this.operators))}updateFilter(){this._filter&&this.onFilterChange()}updateStore(e){var t;null===(t=this._store)||void 0===t||t.un(this),null==e||e.ion({refresh:"onStoreRefresh",thisObj:this}),this.inferFieldTypes()}onStoreRefresh({action:e}){this.isMultiSelectValueField&&["dataset","create","update","delete"].includes(e)&&(this.valueFields[0].items=this.getUniqueDataValues(this.filterValues))}refreshValueFields(){const e=this,{valueFields:t}=e.widgetMap,{valueFields:n,fieldType:i,operatorArgCount:r,_filter:{property:s,operator:o}}=e,a=lp[o];t.element.className=new _t({[`${ap}-values`]:!0,[`${ap}-values-multiple`]:a,[`${ap}-values-${i}`]:void 0!==i,"b-hidden":null==s||null==o||0===r});const l=e.getValueFieldConfigs();if(l.length!==n.length||l.some((({type:e},t)=>n[t].type!==e)))t.removeAll(),t.add(l);else{let e=0;for(const t of l)delete t.type,W.assign(n[e++],t)}delete e._valueFields,e.refreshCaseSensitive()}refreshCaseSensitive(){var e,t;const n=this,{fieldType:i,operatorArgCount:r,isMultiSelectValueField:s}=n,o=null===(e=n._filter)||void 0===e?void 0:e.operator,{caseSensitive:a}=n.widgetMap;a.hidden="string"!==i||!o||s||0===r,a.checked=!1!==(null===(t=n._filter)||void 0===t?void 0:t.caseSensitive)}onPropertySelect(e){var t;const n=this,{_filter:i}=n;i.property=(null===(t=e.record)||void 0===t?void 0:t.data.value)||null,n.fieldType!==n._fieldType&&(i.operator=null,i.value=null),n._fieldType=i.type=n.fieldType,n.refreshOperatorPicker(),n.refreshValueFields(),n.triggerChange()}onCaseSensitiveChange({checked:e}){this._filter.caseSensitive=e,this.triggerChange()}onOperatorSelect(e){var t;const n=this,i=n.isMultiSelectValueField,r=this.operatorArgCount;n._filter.operator=(null===(t=e.record)||void 0===t?void 0:t.data.value)||null,n.operatorArgCount!==r&&(n._filter.value=null),n.isMultiSelectValueField&&!i&&(n._filter.value=[]),n.refreshValueFields(),n.triggerChange()}triggerChange(){const{filter:e,isValid:t}=this;this.trigger("change",{filter:e,isValid:t})}onValueChange(){const{isMultiSelectValueField:e,fieldType:t,_filter:n}=this,i=this.valueFields.map((e=>e.value));e&&"date"===t?n.value=i[0].map((e=>new Date(e))):e&&"duration"===t?n.value=i[0].map((e=>new Ps(e))):("date"===t&&"between"===n.operator&&fr.isValidDate(i[1])&&i[1].setHours(23,59,59,999),n.value=1===i.length?i[0]:i),this.triggerChange()}refreshOperatorPicker(){const{operatorPicker:e}=this.widgetMap,{_filter:{operator:t,property:n},operatorOptions:i}=this;e.items=i,e.value=t,e.hidden=null===n}populateUIFromFilter(e=!1){const t=this,{filterValues:n,widgetMap:{propertyPicker:i,operatorPicker:r},_filter:{property:s,operator:o,disabled:a},propertyOptions:l,operatorOptions:c,isMultiSelectValueField:d}=t;i.items=l,r.items=c,r.hidden=null===s;let u=e;i.value!==s&&(i.value=s,t.refreshOperatorPicker(),u=!0),r.value!==o&&(null!==o&&r.items.find((({value:e})=>e===o))?r.value=o:r.clear(),u=!0),o||1!==r.items.length||(r.value=t._filter.operator=r.items[0].value),u&&t.refreshValueFields(),t.refreshCaseSensitive(),t.valueFields.forEach(((e,i)=>{d&&(e.value.length>0||n.length>0)?"date"===t.fieldType?e.value=n.map((e=>null==e?void 0:e.valueOf())):"duration"===t.fieldType?e.value=n.map((e=>null==e?void 0:e.toString())):e.value=n:i>=n.length?e.clear():e.value=n[i]})),t.allChildInputs.forEach((e=>e.disabled=t.disabled||a))}get valueFields(){return this._valueFields||(this._valueFields=this.widgetMap.valueFields.queryAll((e=>e.owner===this.widgetMap.valueFields&&cp[e.type])))}get filterValues(){var e;return null==(null===(e=this._filter)||void 0===e?void 0:e.value)?[]:$e.asArray(this._filter.value)}onFilterChange(){const e=this,t=e.fieldType,n=t!==e._fieldType;e._fieldType=e._filter.type=t,e.populateUIFromFilter(n)}get operatorArgCount(){const{fieldType:e,filter:{operator:t},operatorArgCountLookup:n}=this;return e&&t?n[e][t]:1}get isValid(){const{filter:e,fieldType:t,filterValues:n,isMultiSelectValueField:i,operatorArgCount:r}=this,{operator:s}=e,o=r>0&&null==(null==e?void 0:e.value);return Boolean(t&&s&&!o&&(i&&n.length>0||n.length===r)&&n.every((e=>null!=e&&("duration"!==t||e.isValid))))}get focusElement(){var e;return(null===(e=this.valueFields.find((e=>e.isEmptyInput))??this.operatorPicker??this.propertyPicker)||void 0===e?void 0:e.input)??super.focusElement}inferFieldTypes(){var e;if((null===(e=this.store)||void 0===e?void 0:e.totalCount)>0&&this.fields)for(const[e,t]of Object.entries(this.fields))"auto"===t.type&&(t.type=Dp.inferFieldType(this.store,e))}static inferFieldType(e,t){var n;const i=null===(n=e.find((e=>null!=e.getValue(t)),!0))||void 0===n?void 0:n.getValue(t);if(void 0!==i){const e=typeof i;if("object"===e&&i instanceof Date)return"date";if(sp[e])return e}return"auto"}static localizeOperator(e,t){const{defaultOperators:n}=Dp,i=Object.keys(n).sort(((e,n)=>e===t?-1:n===t?1:0));for(const t of i)for(const i of n[t])if(i.value===e)return Dp.L(i.text);return e}}Dp.initClass(),Dp._$name="FieldFilterPicker";class wp extends Tc{static $name="Label";static type="label";static configurable={text:null,localizableProperties:["text"]};compose(){const{text:e,html:t}=this;return{tag:"label",text:e,html:t}}}wp.initClass(),wp._$name="Label";class Ep extends Nc{static $name="FieldFilterPickerGroup";static type="fieldfilterpickergroup";static addFilterButtonDefaultText="L{FieldFilterPickerGroup.addFilter}";static#e=(()=>{ip(this,"configurable",{filters:[],fields:null,disabled:!1,readOnly:!1,layout:"vbox",store:null,limitToProperty:null,valueFieldCls:null,showAddFilterButton:!0,canDeleteFilter:null,getFieldFilterPickerConfig:null,canManageFilter:null,addFilterButtonText:null,triggerChangeOnInput:!0,items:{pickers:{type:"container",layout:"vbox",scrollable:!0,items:{}},addFilterButton:{type:"button",text:Ep.addFilterButtonDefaultText,cls:`b-${Ep.type}-add-button`,hidden:!0}},operators:null,dateFormat:"L{FieldFilterPicker.dateFormat}"}),ip(this,"childPickerType","fieldfilterpicker")})();afterConstruct(){const e=this;e.validateConfig();const{addFilterButton:t}=e.widgetMap;t.ion({click:"addFilter",thisObj:e}),t.text=e.L(t.text),e.store&&e.updateStore(e.store),super.afterConstruct()}changeDateFormat(e){return this.L(e)}validateConfig(){if(!this.fields&&!this.store)throw new Error("FieldFilterPickerGroup requires either a 'fields' or 'store' config property.")}updateFields(e){this.widgetMap.pickers.childItems.forEach((t=>t.fields=e))}updateFilters(e,t){const n=this;t&&t.filter((t=>!e.find((e=>e.id===t.id)))).forEach((e=>{var t;return null===(t=n.store)||void 0===t?void 0:t.removeFilter(e.id)})),e.forEach((e=>e.id=e.id||n.nextFilterId)),n.widgetMap.pickers.items=(null==e?void 0:e.map((e=>n.getPickerRowConfig(e))))||[]}changeFilters(e){const{canManageFilter:t,limitToProperty:n}=this;let i=e;return t&&(i=i.filter((e=>this.callback(t,this,[e])))),n&&(i=i.filter((e=>null==e.property||e.property===n))),i}updateStore(e){const t=this;if(t.detachListeners("store"),e){let n=!1;t.widgetMap.pickers.childItems.forEach((({widgetMap:{filterPicker:{filter:t,isValid:i}}})=>{i&&!e.filters.includes(t)&&(e.removeFilter(t.id,!0),e.addFilter(t,!0),n=!0)})),n&&e.filter(),t.appendFiltersFromStore(),e.ion({name:"store",filter:"onStoreFilter",thisObj:t})}t.widgetMap.pickers.childItems.forEach((t=>t.store=e))}updateShowAddFilterButton(e){this.widgetMap.addFilterButton.hidden=!e}updateAddFilterButtonText(e){this.widgetMap.addFilterButton.text=e??Ep.addFilterButtonDefaultText}appendFiltersFromStore(){const e=this;e.store.filters.forEach((t=>{var n;const i=e.canManage(t),{property:r,operator:s,id:o}=t;i&&r&&s&&(null===(n=e.filters)||void 0===n||!n.find((e=>e.id===o)))&&e.appendFilter(t)}))}canManage(e){const t=this;return!t.canManageFilter||!0===t.callback(t.canManageFilter,t,[e])}getFilterPickerConfig(e){const t=this,{fields:n,store:i,disabled:r,readOnly:s,valueFieldCls:o,operators:a,limitToProperty:l,dateFormat:c,getFieldFilterPickerConfig:d,triggerChangeOnInput:u}=t;return{type:t.constructor.childPickerType,fields:n??t.getFieldsFromStore(i),filter:e,store:i,disabled:r,readOnly:s,propertyLocked:Boolean(l),valueFieldCls:o,operators:a,dateFormat:c,internalListeners:{change:"onFilterPickerChange",thisObj:t},flex:1,triggerChangeOnInput:u,...d?t.callback(d,t,[e]):void 0}}getFieldsFromStore(e){var t;return Object.fromEntries((null===(t=e.modelClass)||void 0===t?void 0:t.fields.map((({name:e,type:t})=>[e,{type:t}])))??[])}getPickerRowConfig(e){const t=this,{disabled:n,readOnly:i,canDeleteFilter:r}=t,s=!(r&&!1===t.callback(r,t,[e]));return{type:"container",layout:"box",cls:{[`b-${Ep.type}-row`]:!0,[`b-${Ep.type}-row-removable`]:s},dataset:{separatorText:t.L("L{FieldFilterPicker.and}")},items:{activeCheckbox:{type:"checkbox",disabled:n,readOnly:i,checked:!Boolean(e.disabled),internalListeners:{change:"onFilterActiveChange",thisObj:t},cls:`b-${Ep.type}-filter-active`},filterPicker:t.getFilterPickerConfig(e),removeButton:{type:"button",ref:"removeButton",disabled:n,readOnly:i,hidden:!s,cls:`b-transparent b-${Ep.type}-remove`,icon:"b-fa-trash",internalListeners:{click:"removeFilter",thisObj:t}}}}}get allInputs(){const e=[this.constructor.childPickerType,"button","checkbox"];return this.queryAll((t=>e.includes(t.type)))}updateDisabled(e,t){super.updateDisabled(e,t),this.allInputs.forEach((t=>t.disabled=e))}updateReadOnly(e){this.allInputs.forEach((t=>t.readOnly=e))}onFilterActiveChange({source:e,checked:t}){const n=this,i=n.getFilterIndex(e),r=n.filters[i],s=n.getFilterPicker(i);r.disabled=!t,s.onFilterChange(),n.store&&s.isValid&&n.store.addFilter(r,!0),n.updateStoreFilter(),n.triggerChange()}onFilterPickerChange({source:e,filter:t,isValid:n}){const i=this,{store:r}=i,s=i.getFilterIndex(e);r&&(r.removeFilter(t.id,!0),n&&r.addFilter(t,!0),i.updateStoreFilter()),Object.assign(i.filters[s],t),i.triggerChange()}getFilterIndex(e){return parseInt(e.parent.element.dataset.itemIndex)}getPickerRow(e){return this.widgetMap.pickers.childItems[e]}getFilterPicker(e){return this.getPickerRow(e).widgetMap.filterPicker}get nextFilterId(){return this._nextId=(this._nextId||0)+1,`${this.id}-filter-${this._nextId}`}removeFilter({source:e}){const t=this,n=t.getFilterIndex(e),i=t.filters[n],r=t.getPickerRow(n),s=t.query((e=>e.isFocusable&&"container"!==e.type&&!r.contains(e)));s&&s.focus(),t.removeFilterAt(n),t.store&&(t.store.removeFilter(i.id,!0),t.updateStoreFilter()),t.trigger("remove",{filter:i}),t.triggerChange()}addFilter({property:e=null,operator:t=null,value:n=null}={}){const i=this,{filters:r}=i,s={property:i.limitToProperty||e,operator:t,value:n,disabled:!1,id:i.nextFilterId,caseSensitive:!1};if(i.trigger("beforeAddFilter",{filter:s})){var o;if(i.appendFilter(s),i.getFilterPicker(r.length-1).isValid)null===(o=i.store)||void 0===o||o.addFilter(s,!0),i.store&&i.updateStoreFilter();i.trigger("add",{filter:s}),i.triggerChange()}}appendFilter(e){const t=this;t.limitToProperty&&e.property!==t.limitToProperty||(t.filters.push(e),t.widgetMap.pickers.add(t.getPickerRowConfig(e,t.filters.length-1)))}onStoreFilter(e){const t=this;if(t._isUpdatingStore)return;const{filters:n}=e,i=n.values.reduce(((e,t)=>({...e,[t.id]:t})),{});for(let e=t.filters.length-1;e>=0;e--){const n=t.filters[e],r=i[n.id],s=t.getPickerRow(e);if(s){const{filterPicker:i,activeCheckbox:o}=s.widgetMap;if(!r&&i.isValid)t.removeFilterAt(e);else if(void 0!==r){const{operator:e,value:t,property:s,disabled:a,caseSensitive:l}=r;n!==r&&Object.assign(n,{operator:e,value:t,property:s,disabled:a,caseSensitive:l}),i.filter=n,i.onFilterChange(),o.checked=!a}}}t.appendFiltersFromStore(),t.triggerChange()}removeFilterAt(e){const{widgetMap:{pickers:t},filters:n}=this;t.remove(t.childItems[e]),n.splice(e,1),this.triggerChange()}updateStoreFilter(){var e;this._isUpdatingStore=!0,null===(e=this.store)||void 0===e||e.filter(),this._isUpdatingStore=!1}get value(){return this.filters}triggerChange(){const{filters:e}=this,t=e.filter(((e,t)=>this.getPickerRow(t).widgetMap.filterPicker.isValid));this.trigger("change",{filters:e,validFilters:t})}activateAll(){this.setAllActiveStatus(!0)}deactivateAll(){this.setAllActiveStatus(!1)}setAllActiveStatus(e){const t=this,{_filters:n,store:i}=t;n.forEach(((n,r)=>{if(e===n.disabled){const{filterPicker:s,activeCheckbox:o}=t.getPickerRow(r).widgetMap;n.disabled=!e,s.onFilterChange(),o.checked=e,e&&i&&s.isValid&&i.addFilter(n,!0)}})),t.updateStoreFilter()}get focusElement(){var e;return(null===(e=this.getPickerRow(this._filters.length-1))||void 0===e?void 0:e.widgetMap.filterPicker.focusElement)??super.focusElement}}Ep.initClass(),Ep._$name="FieldFilterPickerGroup";class Rp extends(pu.mixin(Dg)){static $name="FieldSet";static type="fieldset";static get configurable(){return{bodyTag:"fieldset",focusable:!1,localizableProperties:["label"],inline:null,inlineInternal:null,layout:{type:"box",horizontal:!1}}}static get prototypeProperties(){return{flexRowCls:"b-hbox",flexColCls:"b-vbox"}}get bodyConfig(){const e=super.bodyConfig,{className:t}=e,{inlineInternal:n,hasLabel:i,title:r}=this;return delete e.html,t["b-inline"]=n,t["b-fieldset-has-label"]=i,r&&(e.children={legendElement:{tag:"legend",text:r,class:{"b-fieldset-legend":1}}}),e}compose(){const{inlineInternal:e,label:t,labelCls:n,labelWidth:i}=this;return{class:{"b-field":t,"b-vbox":!e},children:{"labelElement > headerElement":t?{tag:"label",html:t,class:{"b-label":1,"b-align-start":1,[n]:n},style:{width:Wn.unitize("width",i)[1]}}:null}}}syncInlineInternal(){this.inlineInternal=this.inline??(null!=this.label&&"before"===this.labelPosition)}updateDisabled(e,t){super.updateDisabled(e,t),this.eachWidget((t=>{t.disabled=e}),!1)}updateInline(){this.syncInlineInternal()}updateInlineInternal(e){this.layout.horizontal=e}updateLabel(){this.syncInlineInternal()}updateLabelPosition(){this.syncInlineInternal()}}Rp.initClass(),Rp._$name="FieldSet";class xp extends Ig{static $name="FileField";static type="filefield";static get configurable(){return{multiple:null,accept:null,inputType:"file",attributes:["multiple","accept"]}}get files(){return this.input.files}pickFile(){this.input.click()}get multiple(){return this._multiple?"":null}clear(){this.input.value=null}triggerChange(e){this.triggerFieldChange({event:e,value:this.input.value,oldValue:this._lastValue,userAction:!0,valid:!0})}}xp.initClass(),xp._$name="FileField";class Tp extends Nc{static $name="FilePicker";static type="filepicker";static configurable={defaultBindProperty:"value",buttonConfig:null,fileFieldConfig:null,showBadge:!0};construct(e={}){const t=this;e.items=[Object.assign({type:"button",ref:"fileButton",text:"L{FilePicker.file}",localeClass:this},e.buttonConfig),Object.assign({type:"filefield",ref:"fileField",style:"display: none"},e.fileFieldConfig)].concat(e.items||[]),super.construct(e),t.button.ion({click:t.onButtonClick,thisObj:t}),t.fileField.ion({change:t.onFileFieldChange,thisObj:t}),t._thisIsAUsedExpression(t.fileTip)}get button(){return this.widgetMap.fileButton}get fileField(){return this.widgetMap.fileField}get files(){return this.fileField.files}get fileTip(){const e=this;return e._fileTip||(e._fileTip=new Cg({cls:"b-file-tip",forElement:e.button.element,showOnHover:!0,align:"b-t",scrollAction:"realign",internalListeners:{beforeshow(){const t=this,n=e.files;return!(!n||!n.length)&&(t.html=`${Array.from(n).map((e=>H.encodeHtml(e.name))).join("<br>")}`,!0)}}}))}clear(){const e=this;e.fileField.clear(),e.updateBadge(),e.trigger("clear")}onButtonClick({event:e}){this.fileField.pickFile(),e.preventDefault()}onFileFieldChange({valid:e}){const t=this;t.updateBadge(),t.triggerFieldChange({files:t.files,valid:e})}updateShowBadge(){this.isConfiguring||this.updateBadge()}updateBadge(){this.button.badge=this.showBadge&&this.files.length||""}}Tp.initClass(),Tp._$name="FilePicker";class Mp extends Ag{static $name="FilterField";static type="filterfield";static get configurable(){return{field:null,store:null,filterFunction:null,clearable:!0,revertOnEscape:!0,ignoreParentReadOnly:!0,keyStrokeChangeDelay:100,internalListeners:{change:"onInternalChange"}}}updateValue(e,t){super.updateValue(e,t),e&&this.isConfiguring&&this.onInternalChange({value:e})}onInternalChange({value:e}){const{store:t,field:n,filterFunction:i}=this;if(t){const r=`${n||this.id}-Filter`;if(0===e.length)t.removeFilter(r);else{let s;i?s=t=>i(t,e):(e=e.replace(/[.*+?^${}()|[\]\\]/g,"\\$&"),s=t=>{var i;return null===(i=t.getValue(n))||void 0===i?void 0:i.match(new RegExp(e,"i"))}),t.filter({id:r,filterBy:s})}}}}Mp.initClass(),Mp._$name="FilterField";const Ip=[{ref:"cancelButton",cls:"b-messagedialog-cancelbutton b-gray",text:"L{Object.Cancel}",onClick:"up.onCancelClick"},{ref:"okButton",cls:"b-messagedialog-okbutton b-raised b-blue",text:"L{Object.Ok}",onClick:"up.onOkClick"}];d.isWindows&&Ip.reverse();class Ap extends fu{static $name="MessageDialog";static type="messagedialog";static get configurable(){return{ui:"plain",centered:!0,modal:!0,hidden:!0,autoShow:!1,closeAction:"hide",title:" ",lazyItems:{$config:["lazy"],value:[{cls:"b-messagedialog-message",ref:"message"},{type:"textfield",cls:"b-messagedialog-input",ref:"input"}]},showClass:null,bbar:{overflow:null,items:Ip}}}construct(){this.okButton=this.yesButton=1,this.cancelButton=3,super.construct(...arguments)}destroy(){}async confirm(){return this.showDialog("confirm",...arguments)}async alert(){return this.showDialog("alert",...arguments)}async prompt({textField:e}){const t=this.widgetMap.input;return Tc.reconfigure(t,e),t.value=null==e?void 0:e.value,this.showDialog("prompt",...arguments)}showDialog(e,{message:t="",title:n="",cancelButton:i,okButton:r,align:s,modal:o,rootElement:a=document.body}){const l=this;return l.rootElement=a,l.getConfig("lazyItems"),l.title=l.optionalL(n),l.widgetMap.message.html=l.optionalL(t),l.showClass=`b-messagedialog-${e}`,l.modal="boolean"!=typeof o||o,l.centered=!s,r&&(r="string"==typeof r?{text:r}:r),i&&(i="string"==typeof i?{text:i}:i),r=Object.assign({},l.widgetMap.okButton.initialConfig,r),i=Object.assign({},l.widgetMap.cancelButton.initialConfig,i),r.text=l.optionalL(r.text),i.text=l.optionalL(i.text),Tc.reconfigure(l.widgetMap.okButton,r),Tc.reconfigure(l.widgetMap.cancelButton,i),l.show({align:s}),l.promise=new Promise((e=>{l.resolve=e}))}show(){const e=Wn.getActiveElement(this.element);return this.owner=this.element.contains(e)?null:Ap.fromElement(document.activeElement),super.show(...arguments)}updateShowClass(e,t){const{classList:n}=this.element;t&&n.remove(t),e&&n.add(e)}doResolve(e){const t=this,{resolve:n}=t;if(n){const i="b-messagedialog-prompt"===t.showClass;if(i&&e===t.okButton&&!t.widgetMap.input.isValid)return;t.resolve=t.reject=t.promise=null,n(i?{button:e,text:t.widgetMap.input.value}:e),t.hide()}}onInternalKeyDown(e){"Escape"===e.key?(e.stopImmediatePropagation(),this.onCancelClick()):"Enter"!==e.key||e.target.closest(".b-button")||(e.stopImmediatePropagation(),e.preventDefault(),this.onOkClick()),super.onInternalKeyDown(e)}onOkClick(){this.doResolve(kp.okButton)}onCancelClick(){this.doResolve(kp.cancelButton)}}Ap.initClass();const kp=new Proxy({},{get(e,t){const n=e.instance||(e.instance=new Ap({rootElement:document.body})),i=n[t];return"function"==typeof i?i.bind(n):i}});class Fp extends ru{static $name="PagingToolbar";static type="pagingtoolbar";static get defaultConfig(){return{store:null,defaults:{localeClass:this},items:{firstPageButton:{onClick:"up.onFirstPageClick",icon:"b-icon-first",weight:100,tooltip:"L{PagingToolbar.firstPage}"},previousPageButton:{onClick:"up.onPreviousPageClick",icon:"b-icon-previous",weight:110,tooltip:"L{PagingToolbar.prevPage}"},pageNumber:{type:"numberfield",label:"L{page}",min:1,max:1,triggers:null,onChange:"up.onPageNumberChange",highlightExternalChange:!1,weight:120},pageCount:{type:"widget",cls:"b-pagecount b-toolbar-text",weight:130},nextPageButton:{onClick:"up.onNextPageClick",icon:"b-icon-next",weight:140,tooltip:"L{PagingToolbar.nextPage}"},lastPageButton:{onClick:"up.onLastPageClick",icon:"b-icon-last",weight:150,tooltip:"L{PagingToolbar.lastPage}"},separator:{type:"widget",cls:"b-toolbar-separator",weight:151},reloadButton:{onClick:"up.onReloadClick",icon:"b-icon-reload",weight:160,tooltip:"L{PagingToolbar.reload}"},spacer:{type:"widget",cls:"b-toolbar-fill",weight:161},dataSummary:{type:"widget",cls:"b-toolbar-text",weight:170}}}}set parent(e){super.parent=e,this.store||(this.store=e.store)}get parent(){return super.parent}set store(e){const t=this;t.detachListeners("store"),t._store=e,e&&(e.ion({name:"store",beforerequest:"onStoreBeforeRequest",afterrequest:"onStoreChange",change:"onStoreChange",thisObj:t}),e.isLoading&&t.onStoreBeforeRequest())}get store(){return this._store}onStoreBeforeRequest(){this.eachWidget((e=>e.disable()))}updateLocalization(){this.updateSummary(),super.updateLocalization()}updateSummary(){const e=this,{pageCount:t,dataSummary:n}=e.widgetMap;let i=0,r=0,s=0,o=0,a=0;if(e.store){const{store:t}=e,{pageSize:n,currentPage:l}=t;i=t.count,r=t.lastPage,a=t.totalCount,s=Math.max(0,(l-1)*n+1),o=Math.min(a,s+n-1)}t.html=e.L("L{pageCountTemplate}")({lastPage:r}),n.html=i?e.L("L{summaryTemplate}")({start:s,end:o,allCount:a}):e.L("L{noRecords}")}onStoreChange(){const e=this,{widgetMap:t,store:n}=e,{count:i,lastPage:r,currentPage:s}=n,{pageNumber:o,pageCount:a,firstPageButton:l,previousPageButton:c,nextPageButton:d,lastPageButton:u,dataSummary:h}=t;e.eachWidget((e=>e.enable())),o.value=s,o.max=r,h.disabled=o.disabled=a.disabled=!i,l.disabled=c.disabled=s<=1||!i,d.disabled=u.disabled=s>=r||!i,e.updateSummary()}onPageNumberChange({value:e}){this.store.currentPage!==e&&this.store.loadPage(e)}onFirstPageClick(){this.store.loadPage(1)}onPreviousPageClick(){this.store.previousPage()}onNextPageClick(){this.store.nextPage()}onLastPageClick(){this.store.loadPage(this.store.lastPage)}onReloadClick(){this.store.loadPage(this.store.currentPage)}}Fp.initClass(),Fp._$name="PagingToolbar";const{dockIsHorz:Pp}=Td.maps,Op={top:0,down:0,left:1,bottom:2,up:2,right:3},Lp={up:{from:"translate(0,0)",to:"translate(0,-100%)"},down:{from:"translate(0,0)",to:"translate(0,100%)"},left:{from:"translate(0,0)",to:"translate(-100%,0)"},right:{from:"translate(0,0)",to:"translate(100%,0)"}};class $p extends(Td.mixin(Ir)){static $name="PanelCollapserOverlay";static type="overlay";static get configurable(){return{autoCloseDelay:1e3,autoClose:!0,revealing:{value:null,$config:null,default:!1},recollapseTool:{type:"collapsetool",cls:"b-recollapse",collapsify:"overlay",handler(){var e;null===(e=this.collapsible)||void 0===e||e.toggleReveal()}}}}static get delayable(){return{doAutoClose:0}}doAutoClose(){this.toggleReveal(!1)}updateAutoCloseDelay(e){const{doAutoClose:t}=this;(t.suspended=null==e||e<0)||(t.delay=e,t.immediate=!e)}changeRecollapseTool(e){const t=this,{panel:n}=t;if(t.isConfiguring||t.isDestroying||!n||n.isDestroying)return e;n.tools={recollapse:e}}beforeCollapse(e){if(!1===super.beforeCollapse(e))return!1;this.panel.revealed&&(e.animation=null)}applyHeaderDock(e,t=!0){var n;null===(n=this.panel)||void 0===n||n.recompose(),super.applyHeaderDock(e,t)}collapseBegin(e){const t=this,{collapseDir:n,innerElement:i}=t,{animation:r}=e,{collapseTool:s,panel:o}=t;t.configuredWidth=o._lastWidth,t.configuredHeight=o._lastHeight,t.applyHeaderDock(!0),t.lockInnerSize(),null==s||s.element.classList.add("b-collapsed"),r&&(o.element.classList.add("b-collapsing"),r.element=i,r.transform=Lp[n],e.animation=ed.run(r))}onComplete(e){var t,n;super.onComplete(e);const i=this,{panel:r}=i,{element:s}=r;i.autoCloseLeaveDetacher=null===(t=i.autoCloseLeaveDetacher)||void 0===t?void 0:t.call(i),i.autoCloseClickDetacher=null===(n=i.autoCloseClickDetacher)||void 0===n?void 0:n.call(i),i.doAutoClose.cancel(),"reveal"===e&&i.autoClose&&(r.containsFocus&&(i.autoCloseLeaveDetacher=Xt.on({element:s,mouseenter:e=>{i.doAutoClose.cancel()},mouseleave:e=>{i.doAutoClose()}})),i.autoCloseClickDetacher=Xt.on({element:document.body,thisObj:r,mousedown:e=>{var t;r.owns(e)||null!==(t=i.revealer)&&void 0!==t&&t.contains(e.target)||null==i.autoCloseDelay||i.doAutoClose.now()}}))}expandBegin(e){const t=this,{animation:n}=e,{collapseDir:i,collapseTool:r,innerElement:s,panel:o}=t,{element:a}=o;a.classList.remove("b-collapsed","b-collapsing"),t.restoreConfiguredSize(),t.lockInnerSize(!1),t.lockInnerSize(),null==r||r.element.classList.remove("b-collapsed"),n&&(a.classList.add("b-collapsed","b-expanding"),n.element=s,n.transform={from:Lp[i].to,to:Lp[i].from},e.animation=ed.run(n))}expandEnd(e){super.expandEnd(e);const{panel:t}=this;e.completed&&(t.revealed=!1),t.element.classList.remove("b-expanding")}expandRevert(e){super.expandRevert(e),this.panel.element.classList.add("b-expanding")}get innerElement(){return this.panel.overlayElement}get innerSizeElement(){return this.panel.element}get toolsConfig(){const{direction:e}=this,t=super.toolsConfig,n=this.recollapseTool;return n?{...t,recollapse:n&&W.assign({direction:e.toLowerCase()},n)}:t}lockInnerSize(e=!0){const t=this,{panel:n}=t,i=e&&n.rectangle(),r=e?[0,0,0,0]:"",s=super.lockInnerSize(e);return e&&(r[Op[t.collapseDir]]=`-${i[t.collapseDim]+10}px`),n.element.style.clipPath=e?`inset(${r.join(" ")})`:"",s}onOverlayTransitionDone(e){const t=this,{panel:n}=t;e.srcElement===n.overlayElement&&t.revealing&&(t.revealing=!1,t.onComplete(n.revealed?"reveal":"unreveal"))}onRevealerClick(){this.toggleReveal()}toggleReveal(e){const{panel:t}=this,{element:n}=t;t.collapsed&&(this.revealer=Wn.getActiveElement(n),null==e&&(e=!t.revealed),t.revealed!==e&&!1!==t.trigger("beforeToggleReveal",{reveal:e})&&(!e&&n.contains(this.revealer)&&t.revertFocus(!0),this.revealing=!0,t.revealed=e))}updateRevealing(e){const t=this,{panel:n}=t,i=/left|right/i.test(t.collapseDir)?"height":"width";n&&(t.innerElement.style[i]="0px",t.innerElement.style[`min-${i}`]="100%",n.element.classList[e?"add":"remove"]("b-panel-overlay-revealing"))}wrapCollapser(e,t){var n;const i=this,{collapseDir:r,panel:s}=i,{expandedHeaderDock:o,header:a,uiClassList:l}=s,c=null===(n=s.tools)||void 0===n?void 0:n.recollapse,[d,u]=i.splitHeaderItems({as:"element",dock:i.collapseDock}),h=Pp[o],g=s.hasHeader?s.title||(null==a?void 0:a.title)||" ":null;return c&&(c.direction=r),["overlayElement",{class:{...l,[`b-panel-overlay-header-${o}`]:1,[`b-panel-overlay-${r}`]:1,[`b-${h?"h":"v"}box`]:1,"b-panel-overlay":1,"b-box-center":1},listeners:{transitionend:e=>i.onOverlayTransitionDone(e),transitioncancel:e=>i.onOverlayTransitionDone(e)},children:{overlayHeaderElement:g&&{tag:"header",class:new _t({...l,[`b-dock-${o}`]:1,"b-panel-header":1,"b-panel-overlay-header":1},null==a?void 0:a.cls),children:[...d,{reference:"overlayTitleElement",html:g,class:{...l,[`b-align-${(null==a?void 0:a.titleAlign)||"start"}`]:1,"b-header-title":1}},...u]},[e]:t}}]}}$p.initClass(),$p._$name="PanelCollapserOverlay";class _p extends Ig{static $name="PasswordField";static type="passwordfield";static alias="password";construct(e={}){e.inputType="password",super.construct(...arguments),this.element.classList.add("b-textfield")}}_p.initClass(),_p._$name="PasswordField";class jp extends um{static $name="Radio";static type="radio";static alias="radiobutton";static get configurable(){return{inputType:"radio",clearable:null,uncheckedValue:void 0}}get textLabelCls(){return super.textLabelCls+" b-radio-label"}internalOnClick(e){!1!==super.internalOnClick(e)&&this.checked&&this.clearable&&(this.checked=!1)}updateName(e){this.toggleGroup=e}updateClearable(){}}jp.initClass(),jp._$name="Radio";class Bp extends Rp{static $name="RadioGroup";static type="radiogroup";static get configurable(){return{defaultType:"radio",clearable:null,name:null,options:{value:null,$config:{merge:"items"}},defaultBindProperty:"value"}}get existingOptions(){const{name:e}=this;return this.ensureItems().filter((t=>t.name===e))}get refPrefix(){return`${this.name||this.ref||this.id}_`}get selected(){return this.existingOptions.filter((e=>e.input.checked))[0]||null}get value(){const{selected:e}=this;return e?e.checkedValue:null}set value(e){this.existingOptions.forEach((t=>{t.isConfiguring=this.isConfiguring,t.checked=t.checkedValue===e,t.isConfiguring=!1}))}ensureItems(){return this.getConfig("options"),super.ensureItems()}changeOptions(e,t){if(!(e&&t&&W.isDeeplyEqual(t,e)))return e}convertOption(e,t,n){const i=this,{name:r}=i,s={name:r,type:"radio",value:e===i.value,ref:`${i.refPrefix}${e}`,checkedValue:e};return"string"==typeof t?s.text=t:W.assign(s,t),n?Tc.reconfigure(n,s):s}isOurRadio(e){return e.isRadio&&e.name===this.name}isolateFieldChange(e){return this.isOurRadio(e)}onChildAdd(e){super.onChildAdd(e),this.isOurRadio(e)&&e.ion({name:e.id,beforeChange:"onRadioItemBeforeChange",change:"onRadioItemChange",click:"onRadioClick",thisObj:this})}onChildRemove(e){this.isOurRadio(e)&&this.detachListeners(e.id),super.onChildRemove(e)}onRadioClick(e){const{source:t}=e;t.checked&&this.clearable&&null==t.clearable&&(t.checked=!1)}onRadioItemBeforeChange(e){if(e.checked){const t=this,{lastValue:n}=t;if(!t.reverting&&!1===t.trigger("beforeChange",t.wrapRadioEvent(e))&&null!=n&&n!==t.value)return t.reverting=!0,e.source.uncheckToggleGroupMembers(),t.value=n,t.lastValue=n,t.reverting=!1,!1}}onRadioItemChange(e){const t=this;e.checked&&!t.reverting&&(t.triggerFieldChange(t.wrapRadioEvent(e)),t.lastValue=t.value)}wrapRadioEvent(e){return{from:e,item:e.source,userAction:e.userAction,lastValue:this.lastValue,value:this.value}}updateOptions(){const e=this,{options:t,refPrefix:n}=e,i=e.existingOptions.reduce(((e,t)=>(e[t.ref.substring(n.length)]=t,e)),{});let r,s,o=0;if(t)for(r in t)s=e.convertOption(r,t[r],i[r]),delete i[r],e.insert(s,o++);const a=Object.values(i);null!=a&&a.length&&(e.remove(a),a.forEach((e=>e.destroy())))}}Bp.initClass(),Bp._$name="RadioGroup";const Hp={ArrowUp:1,ArrowDown:1,ArrowLeft:1,ArrowRight:1};class Vp extends Tc{static $name="Slider";static type="slider";static get configurable(){return{text:null,showValue:!0,showTooltip:!1,min:0,max:100,step:1,value:50,unit:null,thumbSize:20,tooltip:{$config:["lazy","nullify"],value:{type:"tooltip",align:"b-t",anchor:!1,axisLock:!0}},localizableProperties:["text"],triggerChangeOnInput:null,defaultBindProperty:"value",twinSyncConfigs:["max","min","step","value"],label:null}}compose(){const{id:e,min:t,max:n,showValue:i,step:r,text:s,value:o,unit:a="",disabled:l,readOnly:c,label:d}=this,u=`${e}-input`,h=Boolean(s||i);return{class:{"b-has-field-label":d,"b-has-label":h,"b-text":h,"b-disabled":l},children:{inputLabel:d?{tag:"label",for:u,text:d}:null,input:{tag:"input",type:"range",id:u,reference:"input",[l?"disabled":""]:l,[c?"readOnly":""]:c,min:t,max:n,step:r,value:o,listeners:{input:"onInternalInput",change:"onInternalChange",mouseover:"onInternalMouseOver",mouseout:"onInternalMouseOut"}},valueLabel:h?{tag:"label",class:"b-slider-value",for:u,text:i?s?`${s} (${o}${a})`:o+a:s}:null}}}get focusElement(){return this.input}get percentProgress(){return(this.value-this.min)/(this.max-this.min)*100}onInternalKeyDown(e){!this.readOnly&&Hp[e.key]&&e.stopImmediatePropagation()}onInternalChange(){this.updateUI(),this.triggerChange(!0),this.trigger("action",{value:this.value})}onInternalInput(){const e=this;e.readOnly?e.input.value=e.value:(e.value=parseInt(e.input.value,10),e.trigger("input",{value:e.value}),e.triggerChangeOnInput&&e.triggerChange(e))}onInternalMouseOver(){var e;const t=this,n=t.rtl?100-t.percentProgress:t.percentProgress;null===(e=t.tooltip)||void 0===e||e.showBy({target:Pt.from(t.input).inflate(t.thumbSize/2,-t.thumbSize/2),align:`b-t${Math.round(n)}`})}onInternalMouseOut(){var e;null===(e=this.tooltip)||void 0===e||e.hide()}triggerChange(e){this.triggerFieldChange({value:this.value,valid:!0,userAction:e})}updateMax(e){const t=this;t.input&&t._value>e&&(t.value=e,t.trigger("input",{value:t.value}))}updateMin(e){const t=this;t.input&&t._value<e&&(t.value=e,t.trigger("input",{value:t.value}))}changeTooltip(e,t){return e&&(e.owner=this),this.showTooltip?Cg.reconfigure(t,e,{owner:this,defaults:{forElement:this.input,html:String(this.value)+(this.unit??"")}}):null}changeValue(e){const{min:t,step:n}=this;return(e=Math.min(Math.max(e,t),this.max))>t?t+W.roundTo(e-t,n):W.roundTo(e,n)}updateValue(e){const t=this,{input:n,_tooltip:i}=t;i&&(i.html=t.value+(t.unit??"")),n&&n.value!==String(e)&&(n.value=e,t.triggerChange(!1)),t.updateUI()}updateUI(){var e,t;const n=this;(null===(e=n._tooltip)||void 0===e?void 0:e.isVisible)&&(null===(t=n._tooltip)||void 0===t||t.alignTo({target:Pt.from(n.input).inflate(n.thumbSize/2,-n.thumbSize/2),align:`b-t${Math.round(n.percentProgress)}`}))}}Vp.initClass(),Vp._$name="Slider";class zp extends um{static $name="SlideToggle";static type="slidetoggle";static get properties(){return{toggledCls:"b-slidetoggle-checked"}}construct(e){e.checked&&(e.cls=_t.from(e.cls)||{},e.cls[this.constructor.properties.toggledCls]=1),super.construct(e)}get innerElements(){const e=super.innerElements;return e.splice(1,0,this.toggleElement),this.text?e[e.length-1].class="b-slidetoggle-label":e.pop(),e}get toggleElement(){return{class:"b-slidetoggle-toggle",reference:"slideToggle",children:[{class:"b-slidetoggle-thumb",reference:"slideThumb"}]}}internalOnChange(){super.internalOnChange(),this.element.classList[this.value?"add":"remove"](this.toggledCls)}}zp.initClass(),zp._$name="SlideToggle";const Np=["b-horizontal","b-vertical"],Wp=e=>"flex"===Wn.getStyleValue(e.parentElement,"display")&&(parseInt(Wn.getStyleValue(e,"flex-basis"),10)||parseInt(Wn.getStyleValue(e,"flex-grow"),10)),Up={horizontal:!1,vertical:!0};class Gp extends Tc{static $name="Splitter";static type="splitter";static get configurable(){return{orientation:"auto",vertical:null,containerElement:{$config:"nullify",value:null},nextNeighbor:{$config:"nullify",value:null},previousNeighbor:{$config:"nullify",value:null}}}static get delayable(){return{syncState:"raf"}}doDestroy(){var e;null===(e=this.mouseDetacher)||void 0===e||e.call(this),super.doDestroy()}compose(){return{class:{"b-splitter":1},listeners:{pointerdown:"onMouseDown",mouseenter:"onMouseEnter",mouseleave:"onMouseLeave",...!d.supportsPointerEvents&&{mousedown:"onMouseDown",touchstart:"onMouseDown"}}}}get currentOrientation(){return this.vertical?"vertical":"horizontal"}getSibling(e=!0){let t,{element:n}=this;for(;!t&&(n=n[(e?"next":"previous")+"ElementSibling"]);)n.isConnected&&!Wn.isVisible(n)||(t=n);return t}get nextWidget(){let e,{element:t}=this;for(;!e&&(t=t.nextElementSibling);)e=Tc.fromElement(t,this.element.parentElement);return e}get previousWidget(){let e,{element:t}=this;for(;!e&&(t=t.previousElementSibling);)e=Tc.fromElement(t,this.element.parentElement);return e}updateContainerElement(e){var t;const n=this;n.stateDetector=null===(t=n.stateDetector)||void 0===t?void 0:t.disconnect(),e&&(n.stateDetector=new MutationObserver((()=>n.syncState())),n.stateDetector.observe(e,{attributes:!0,childList:!0}))}updateNextNeighbor(e){this.watchNeighbor(e,"next")}updatePreviousNeighbor(e){this.watchNeighbor(e,"previous")}watchNeighbor(e,t){this.detachListeners(t),null==e||e.ion({name:t,thisObj:this,collapse:"syncState",expand:"syncState",hide:"syncState",show:"syncState"})}updateOrientation(){this.syncState.now()}updateVertical(e){var t;const n=null===(t=this.element)||void 0===t?void 0:t.classList;null==n||n.add(Np[e?1:0]),null==n||n.remove(Np[e?0:1])}syncState(){const e=this,{element:t,nextWidget:n,previousWidget:i}=e;let r=Up[e.orientation]??null;if(e.nextNeighbor=n,e.previousNeighbor=i,e.disabled=n&&(n.collapsible&&n.collapsed||n.hidden)||i&&(i.collapsible&&i.collapsed||i.hidden),null!==r&&n&&i)e.containerElement=null;else if(e.containerElement=t.parentElement,e.rendered&&t.offsetParent){const e=Wn.getStyleValue(t.parentElement,"flex-direction");if(e)r=!e.startsWith("column");else{const e=t.previousElementSibling,n=t.nextElementSibling;if(!e||!n)return;const i=e.getBoundingClientRect(),s=n.getBoundingClientRect(),o=i.top<s.top?i:s,a=o===s?i:s;r=o.top===a.top}}e.vertical=r}onMouseDown(e){var t;e.preventDefault(),e.touches&&(e=e.touches[0]);const n=this,{element:i,nextNeighbor:r,previousNeighbor:s}=n,o=s?s.element:n.getSibling(!1),a=r?r.element:n.getSibling(),l=Wp(o),c=Wp(a),u=[];null===(t=n.mouseDetacher)||void 0===t||t.call(n);for(const e of i.parentElement.children)Wp(e)&&e!==i&&u.push({element:e,width:e.offsetWidth,height:e.offsetHeight});n.context={startX:e.pageX,startY:e.pageY,prevWidth:o.offsetWidth,prevHeight:o.offsetHeight,nextWidth:a.offsetWidth,nextHeight:a.offsetHeight,prevHasFlex:l,nextHasFlex:c,flexed:u,prev:o,next:a};const h={element:document,pointermove:"onMouseMove",pointerup:"onMouseUp",thisObj:n};d.supportsPointerEvents||(h.mousemove=h.touchmove="onMouseMove",h.mouseup=h.touchend="onMouseUp"),i.classList.add("b-moving"),n.mouseDetacher=Xt.on(h),n.trigger("splitterMouseDown",{event:e})}onMouseEnter(e){this.syncState(),this.trigger("splitterMouseEnter",{event:e})}onMouseLeave(e){this.trigger("splitterMouseLeave",{event:e})}onMouseMove(e){const t=this,{context:n,nextWidget:i,previousWidget:r}=t,s=n.prev.style,o=n.next.style,a=(e.pageX-n.startX)*(t.rtl?-1:1),l=e.pageY-n.startY;if(e.preventDefault(),Object.assign(n,{deltaX:a,deltaY:l}),n.started||(n.started=!0,t.trigger("dragStart",{context:n,event:e}),n.flexed.forEach((e=>{e.element.style.flexGrow=t.vertical?e.width:e.height,e.element.style.flexBasis="0"}))),t.vertical){const e=n.prevWidth+a,t=n.nextWidth-a;n.prevHasFlex?s.flexGrow=e:r?r.width=e:s.width=`${e}px`,n.nextHasFlex?o.flexGrow=t:i?i.width=t:o.width=`${t}px`}else{const e=n.prevHeight+l,t=n.nextHeight-l;n.prevHasFlex?s.flexGrow=e:r?r.height=e:s.height=`${e}px`,n.nextHasFlex?o.flexGrow=t:i?i.height=t:o.height=`${t}px`}t.trigger("drag",{context:n,event:e})}onMouseUp(e){var t;const n=this;null===(t=n.mouseDetacher)||void 0===t||t.call(n),n.mouseDetacher=null,n.element.classList.remove("b-moving"),n.context.started&&n.trigger("drop",{context:n.context,event:e}),n.context=null}render(){super.render(...arguments),this.syncState.now(),null===this.vertical&&this.syncState()}}Gp.initClass(),Gp._$name="Splitter";class Yp extends Yd{static $name="Tab";static type="tab";static get configurable(){return{active:null,index:null,isFirst:null,isLast:null,item:{value:null,$config:"nullify"},itemCls:null,tabPanel:null,titleProperty:"text",titleSource:"title",role:"tab"}}compose(){const{active:e,cls:t,index:n,isFirst:i,isLast:r}=this;return{tabindex:0,"aria-selected":e,"aria-setsize":this.owner.visibleChildCount,"aria-posinset":n+1,class:{"b-tabpanel-tab":1,"b-active":e,"b-tab-first":i,"b-tab-last":r,...t},dataset:{index:n}}}updateIndex(e){this.isFirst=!e}updateItem(e,t){var n,i;const r=this;(null==t?void 0:t.tab)===r&&(t.tab=null),e&&(e.tab=r,r[r.titleProperty]=e[r.titleSource],r.itemCls=e.cls,r.ariaElement.setAttribute("aria-controls",e.id),e.role="tabpanel"),null===(n=r.itemChangeDetacher)||void 0===n||n.call(r),r.itemChangeDetacher=e&&Ne.after(e,"onConfigChange","onItemConfigChange",r,{return:!1}),null===(i=r.itemHideDetacher)||void 0===i||i.call(r),r.itemHideDetacher=null==e?void 0:e.ion({beforeChangeHidden:"onItemBeforeChangeHidden",beforeHide:"onItemBeforeHide",beforeUpdateDisabled:"onItemBeforeUpdateDisabled",thisObj:r,prio:1e3}),r.syncMinMax()}updateItemCls(e,t){const{element:n}=this,i=n&&_t.from(null==n?void 0:n.classList,!0);n&&(i.remove(t).add(e),n.className=i.value)}updateRotate(e,t){!e!=!t&&this.syncMinMax()}syncMinMax(){const e=this,{rotate:t,tabPanel:n}=e;let{_minWidth:i,_minHeight:r,_maxWidth:s,_maxHeight:o}=e;if(n){const{tabMinWidth:a,tabMaxWidth:l}=n;null!=a&&(t?(i===a&&(i=null),r=a):(r===a&&(r=null),i=a)),null!=l&&(t?(s===l&&(s=null),o=l):(o===l&&(o=null),s=l)),e.minWidth=i,e.minHeight=r,e.maxWidth=s,e.maxHeight=o}}onItemBeforeChangeHidden({source:e,hidden:t}){if(!e.$isDeactivating&&!e.$isActivating){const{tabPanel:n}=this;this.hidden=t,t&&e===n.activeItem&&n.activateAvailableTab(e)}}onItemBeforeHide(){this.item.$isDeactivating||this.hide()}onItemBeforeUpdateDisabled({source:e,disabled:t}){const{tabPanel:n}=this;this.disabled=t,e===n.activeItem&&n.activateAvailableTab(e)}onItemConfigChange({name:e,value:t}){e===this.titleSource&&(this[this.titleProperty]=t)}}Yp.initClass(),Yp._$name="Tab";const qp=e=>e.isTab;class Kp extends ru{static $name="TabBar";static type="tabbar";static get configurable(){return{defaultType:"tab",overflow:"scroll",role:"tablist",ignoreParentReadOnly:!0}}get firstTab(){return this.tabAt(0)}get lastTab(){return this.tabAt(-1)}get tabCount(){return this._items.countOf(qp)}get tabs(){return $e.from(this._items,qp)}compose(){return{children:{toolbarContent:{class:{"b-tabpanel-tabs":1}}}}}indexOfTab(e){return this._items.indexOf(e,qp)}onChildAdd(e){super.onChildAdd(e),null==e.index&&this.syncTabs()}onChildRemove(e){super.onChildRemove(e),this.syncTabs()}onFocusIn(){const{activeIndex:e}=this.owner;isNaN(e)||this.tabs[e].focus()}syncTabs(){const{tabs:e}=this;for(let t=0,n=e.length;t<n;++t)e[t].index=t,e[t].isFirst=!t,e[t].isLast=t===n-1}tabAt(e){return this._items.find(qp,e)||null}}Kp.initClass(),Kp._$name="TabBar";const Xp=["b-slide-out-left","b-slide-out-right","b-slide-in-left","b-slide-in-right"];class Zp extends Ic{static $name="Card";static type="card";static configurable={containerCls:"b-card-container",itemCls:"b-card-item",hideChildHeaderCls:"b-hide-child-headers",animateCardChange:!0,activeItem:null,activeIndex:null};onChildAdd(e){super.onChildAdd(e);const t=this,{activeItem:n,owner:i}=t,r=null!=i.activeIndex?i.activeIndex:t.activeIndex||0,s=i.items.indexOf(e),o=null!=n?e===n:s===r;e.ion({beforeHide:"onBeforeChildHide",beforeShow:"onBeforeChildShow",thisObj:t}),o?(t._activeIndex=s,t._activeItem=e,e.show()):(e.$isDeactivating=!0,e.hide(),e.$isDeactivating=!1)}onChildRemove(e){super.onChildRemove(e);const t=this;t._activeItem===e&&t.activateSiblingOf(e),t._activeIndex=t.owner.items.indexOf(t._activeItem),e.un({beforeHide:"onBeforeChildHide",beforeShow:"onBeforeChildShow",thisObj:t})}onBeforeChildShow({source:e}){if(!this.owner.isConfiguring&&!e.$isActivating)return this.activeItem=e,!1}onBeforeChildHide({source:e}){if(!this.owner.isConfiguring&&!e.$isDeactivating)return this.activateSiblingOf(e),!1}activateSiblingOf(e){const{owner:t}=this,n=t.items.slice(),i=n.indexOf(e);n.splice(i,1),this.activeIndex=Math.min(i,n.length-1)}setActiveItem(e,t=this.activeIndex,n){const i=this,{owner:r}=i,{items:s}=r,o=e instanceof Tc,a=s[t],l=r.items[e=o?s.indexOf(e):parseInt(e,10)],c=!1!==(null==n?void 0:n.animation),d=!(null!=n&&n.silent),u={prevActiveIndex:t,prevActiveItem:a};if(l&&!l.$isActivating&&l!==a){var h;const s=a&&a.element,o=l&&l.element;if(i.animateDetacher){const e=i.animateDetacher.event;if(e.activeItem===l)return e.promise;i.animateDetacher(),e.prevActiveItem.element.classList.remove(...Xp),e.activeItem.element.classList.remove(...Xp),i.animateDetacher=null}if(u.activeIndex=e,u.activeItem=l,d&&!1===r.trigger("beforeActiveItemChange",u))return null;const g=i._activeIndex!==u.activeIndex;g&&(i._activeIndex=u.activeIndex),d&&(null===(h=r.onBeginActiveItemChange)||void 0===h||h.call(r,u)),g&&(i._activeIndex=u.prevActiveIndex),c&&s&&r.isVisible&&i.animateCardChange?u.promise=i.cardChangeAnimation=new Promise(((c,h)=>{const g=a.monitorResize;a.monitorResize=!1,i.contentElement.style.overflowX="hidden",a._hidden=!0,l.$isActivating=!0,l.show(),l.$isActivating=!1,s.classList.add(e>t?"b-slide-out-left":"b-slide-out-right"),o.classList.add(e<t?"b-slide-in-left":"b-slide-in-right"),r.isAnimating=!0,i.animateDetacher=Xt.onTransitionEnd({mode:"animation",element:o,thisObj:a,handler(){r.isAnimating=i.cardChangeAnimation=!1,i.animateDetacher?(i.animateDetacher=null,o.classList.remove(...Xp),s&&(s.classList.remove(...Xp),a.$isDeactivating=!0,a._hidden=!1,a.hide(),a.monitorResize=g,a.$isDeactivating=!1),i.contentElement.style.overflowX="",i.onActiveItemChange(u,c,!d)):i.setActiveItem(e,t,n)}}),i.animateDetacher.reject=h,i.animateDetacher.event=u})):(l.$isActivating=!0,l.show(),r.containsFocus&&l.focus(),l.$isActivating=!1,a&&(a.$isDeactivating=!0,a.hide(),a.$isDeactivating=!1),i.onActiveItemChange(u,null,!d))}return u}onActiveItemChange(e,t,n){const i=this;i._activeItem=e.activeItem,i._activeIndex=e.activeIndex,!n&&i.owner.trigger("activeItemChange",e),i.owner.containsFocus&&e.activeItem.focus(),null==t||t(e)}renderChildren(){const{owner:e}=this;e.contentElement.classList.toggle(this.hideChildHeaderCls,e.suppressChildHeaders),super.renderChildren()}changeActiveIndex(e){const{owner:t}=this;return t.isConfiguring&&!t._items?e:Math.min(e,t.items.length-1)}updateActiveIndex(e,t){this.owner.isConfiguring||this.setActiveItem(e,t)}updateActiveItem(e){this.owner.isConfiguring||this.setActiveItem(e,this.activeIndex)}get isChangingCard(){return Boolean(this.animateDetacher)}}Zp.initClass(),Zp._$name="Card";const Jp=e=>e.maximized;class Qp extends pu{static $name="TabPanel";static type="tabpanel";static alias="tabs";static get configurable(){return{activeTab:0,animateTabChange:!0,autoHeight:!1,defaultType:"container",focusable:!1,itemCls:"b-tabpanel-item",layout:{type:"card"},suppressChildHeaders:!0,tabBar:{type:"tabbar",weight:-2e3},tabMinWidth:null,tabMaxWidth:null}}get activeIndex(){return this.layout.activeIndex}get activeItem(){return this.layout.activeItem}get activeTabItemIndex(){var e;const{activeTab:t,items:n,tabBar:i}=this;return n.indexOf(null===(e=i.tabs[t])||void 0===e?void 0:e.item)}get bodyConfig(){return W.merge({className:{"b-tabpanel-body":1}},super.bodyConfig)}get focusElement(){var e;const t=this.items[this.activeTab||0];return(null==t?void 0:t.focusElement)||(null==t||null===(e=t.tab)||void 0===e?void 0:e.focusElement)}get tabPanelBody(){return this.bodyElement}finalizeInit(){super.finalizeInit();const e=this,{activeTab:t,layout:n}=e,{activeIndex:i}=n,{tabs:r}=e.tabBar,s=t>=0&&t<r.length&&e.items.indexOf(r[t].item);if(r.length>0&&(!1===s||s<0))throw new Error(`Invalid activeTab ${t} (${r.length} tabs)`);s!==i&&n.setActiveItem(s,i,{animation:!1,silent:!0}),n.animateCardChange=e.animateTabChange}onChildAdd(e){if(super.onChildAdd(e),!this.initialItems){const t=this,{tabBar:n}=t,i=t.makeTabConfig(e),r=i&&(null==n?void 0:n.firstTab),s=r&&n._items,o=r&&$e.from(t._items,(t=>t.tab||t===e)),a=r?o.indexOf(e)+s.indexOf(r):0;i&&n&&(r&&null==e.weight&&a<s.count-1?n.insert(i,a):n.add(i))}}onChildRemove(e){const{tab:t}=e,{items:n}=this;t&&(this.tabBar.remove(t),t.destroy()),e===this.activeItem&&(this._activeTab=null,n.length&&(this.activeTab=n[Math.min(this.activeIndex,n.length-1)])),super.onChildRemove(e)}isDisabledOrHiddenTab(e){const{tabs:t}=this.tabBar,n=null==t?void 0:t[e];return n&&(n.disabled||n.hidden)}findAvailableTab(e,t=1){const{tabs:n}=this.tabBar,i=n.length,r=Math.max(0,n.indexOf(e.tab));let s;r&&(t=-t);for(let e=1;e<=i&&(s=(r+(t<0?i:0)+e*t)%i,this.isDisabledOrHiddenTab(s));++e);return s}activateAvailableTab(e,t=1){this.activeTab=this.findAvailableTab(e,t)}changeActiveTab(e,t){const n=this,{tabBar:i,layout:r}=n,{tabCount:s}=i;if(e.isWidget||W.isObject(e)?(-1===n.items.indexOf(e)&&(e=n.add(e)),e=i.indexOfTab(e.tab)):e=parseInt(e,10),!n.initialItems&&s>0&&(e<-1||e>=s))throw new Error(`Invalid activeTab ${e} (${s} tabs)`);if(n.isDisabledOrHiddenTab(e)&&(e=n.findAvailableTab(e)),!r.animateCardChange||!r.cardChangeAnimation)return e;r.cardChangeAnimation.then((i=>{(null==i?void 0:i.activeIndex)!==e&&(n._activeTab=e,n.updateActiveTab(e,t))}))}async updateActiveTab(e,t){if(!this.initialItems){const{activeTabItemIndex:e,layout:i}=this;if(e>-1){const r=this.items[t],s=this.items[e];var n;if(i.activeItem!==s)i.animateCardChange&&await this.tabSelectionPromise,null!=r&&r.containsFocus&&r.tab.focus(),this.tabSelectionPromise=null===(n=i.setActiveItem(s))||void 0===n?void 0:n.promise}}}changeTabBar(e){return this.getConfig("strips"),this.strips={tabBar:e},this.strips.tabBar}makeTabConfig(e){const{tab:t}=e,n={item:e,type:"tab",active:!e.hidden,tabPanel:this,disabled:Boolean(e.disabled),hidden:e.initialConfig.hidden,weight:e.weight||0,internalListeners:{click:"onTabClick",thisObj:this},localizableProperties:{text:!1}};return!1===t?null:W.isObject(t)?Yp.mergeConfigs(n,t):n}updateAnimateTabChange(e){this.isConfiguring||(this.layout.animateCardChange=e)}updateItems(e,t){const n=this,{activeTab:i,initialItems:r}=n;let s,o=0;super.updateItems(e,t),r&&(s=Array.from(e,(e=>n.makeTabConfig(e))).filter((e=>{if(e)return e.index=o++,!0})),o&&(s[0].isFirst=!0,s[o-1].isLast=!0,s[i].active=!0,n.tabBar.add(s),n.activeTab=i))}updateTabMinWidth(e){var t;null===(t=this.tabBar)||void 0===t||t.items.forEach((t=>{t.isTab&&(t.minWidth=e)}))}updateTabMaxWidth(e){var t;null===(t=this.tabBar)||void 0===t||t.items.forEach((t=>{t.isTab&&(t.maxWidth=e)}))}updateAutoHeight(e){this.detachListeners("themeAutoHeight"),e&&ti.ion({name:"themeAutoHeight",theme:"internalOnThemeChange",thisObj:this})}applyAutoHeight(){const e=this,{layout:t,activeTab:n,element:i}=e,{animateCardChange:r}=t;if(t.animateCardChange=!1,e.flex="0 0 0%",!e.up(Jp)){const t=e.height=Math.max(...e.items.map((t=>(e.activeTab=t,i.clientHeight))))+1;e.flex=`1 1 ${t}px`}e.activeTab=n,t.animateCardChange=r}internalOnThemeChange(){this.isVisible&&this.applyAutoHeight()}onBeginActiveItemChange(e){const t=this.tabBar.tabs,{activeItem:n,prevActiveItem:i}=e;this.activeTab=t.indexOf(null==n?void 0:n.tab),null!=i&&i.tab&&(i.tab.active=!1),null!=n&&n.tab&&(n.tab.active=!0,n.tab.show())}onBeforeActiveItemChange(e){return this.trigger("beforeTabChange",e)}onActiveItemChange(e){this.trigger("tabChange",e)}onTabClick(e){this.activeTab=e.source.item}onInternalPaint(){super.onInternalPaint(...arguments),this.autoHeight&&this.applyAutoHeight()}}Qp.initClass(),Qp._$name="TabPanel";class ef extends Ig{static $name="TextAreaField";static type="textareafield";static alias="textarea";static get configurable(){return{resize:"none",inputAttributes:{tag:"textarea"}}}updateResize(e){this.input.style.resize=e}}ef.initClass(),ef._$name="TextAreaField";class tf extends kg{static $name="TextAreaPickerField";static type="textareapickerfield";static configurable={picker:{type:"widget",tag:"textarea",cls:"b-textareapickerfield-picker",scrollAction:"realign",align:{align:"t-b",axisLock:!0},autoShow:!1},triggers:{expand:{cls:"b-icon-picker",handler:"onTriggerClick"}},resize:"none",inputType:null};get inputElement(){const e=super.inputElement;return e.readOnly="readonly",e.reference="displayElement",this.ariaElement="displayElement",e}get focusElement(){var e;return null!==(e=this._picker)&&void 0!==e&&e.isVisible?this.input:this.displayElement}get needsInputSync(){return this.displayElement[this.inputValueAttr]!==String(this.inputValue??"")}showPicker(){this.picker.width=this.pickerWidth||this.pickerAlignElement.offsetWidth,super.showPicker(!0)}focusPicker(){this.input.focus()}onPickerKeyDown(e){const t=this,n=t.input;switch(e.key.trim()||e.code){case"Escape":return void t.picker.hide();case"Enter":e.ctrlKey&&(t.syncInputFieldValue(),t.picker.hide())}t.input=t.displayElement;const i=super.onPickerKeyDown(e);return t.input=n,i}syncInputFieldValue(e){this.displayElement&&(this.displayElement.value=this.inputValue),super.syncInputFieldValue(e)}changeValue(e){return null==e?"":e}changePicker(e,t){var n;const i=this,r=i.pickerWidth||(null===(n=e)||void 0===n?void 0:n.width);if(e=tf.reconfigure(t,e?b.merge({owner:i,forElement:i.pickerAlignElement,align:{matchSize:null==r,anchor:i.overlayAnchor,target:i.pickerAlignElement},id:i.id+"-input",style:{resize:i.resize},html:i.value??""},e):null,i)){const t=i.input=e.element;i.inputListenerRemover=Xt.on({element:t,thisObj:i,focus:"internalOnInputFocus",change:"internalOnChange",input:"internalOnInput",keydown:"internalOnKeyEvent",keypress:"internalOnKeyEvent",keyup:"internalOnKeyEvent"})}return e}}tf.initClass(),tf._$name="TextAreaPickerField";class nf extends Nc{static $name="UndoRedoBase";static type="undoredobase";static get configurable(){return{project:null,stm:null,text:null,color:null,showZeroActionBadge:null,cls:"b-undo-controls b-toolbar",layoutStyle:{alignItems:"stretch",flexFlow:"row nowrap",overflow:"visible"},items:{undoBtn:{type:"button",icon:"b-icon-undo",tooltip:"L{UndoRedo.UndoLastAction}",onAction:"up.onUndo"},transactionsCombo:{type:"combo",valueField:"idx",editable:!1,store:{},emptyText:"L{UndoRedo.NoActions}",onAction:"up.onTransactionSelected",displayValueRenderer:"up.transactionsDisplayValueRenderer"},redoBtn:{type:"button",icon:"b-icon-redo",tooltip:"L{UndoRedo.RedoLastAction}",onAction:"up.onRedo"}},overflowable:!0}}afterConstruct(){this.updateUndoRedoControls()}updateStm(e){this.detachListeners("undoredo"),null==e||e.ion({name:"undoredo",recordingstop:"updateUndoRedoControls",restoringstop:"updateUndoRedoControls",queueReset:"updateUndoRedoControls",disabled:"updateUndoRedoControls",thisObj:this})}changeItems(e){const{undoBtn:t,redoBtn:n}=e;return this.color&&(t&&(t.color=this.color),n&&(n.color=this.color)),this.text&&(t&&(t.text="L{UndoRedo.Undo}"),n&&(n.text="L{UndoRedo.Redo}")),super.changeItems(e)}updateProject(e){this.stm=e.stm}fillUndoRedoCombo(){const{transactionsCombo:e}=this.widgetMap;e&&(e.items=[[0,"Original data"],...this.stm.queue.map(((e,t)=>[t+1,e||`Transaction ${t+1}`]))])}updateUndoRedoControls(){const{stm:e,showZeroActionBadge:t}=this,{undoBtn:n,redoBtn:i,transactionsCombo:r}=this.widgetMap;n.badge=e.position||(t?"0":""),i.badge=e.length-e.position||(t?"0":""),n.disabled=!e.canUndo,i.disabled=!e.canRedo,this.fillUndoRedoCombo(),r&&(r.disabled=r.store.count<=1)}transactionsDisplayValueRenderer(e,t){var n;const i=(null===(n=this.stm)||void 0===n?void 0:n.position)||0;return`${i} undo actions / ${t.store.count-i-1} redo actions`}onUndo(){const{stm:e,project:t}=this;e.canUndo&&(e.revisionsEnabled?t.queue((()=>(e.undo(),t.commitAsync()))):e.undo())}onRedo(){const{stm:e,project:t}=this;e.canRedo&&(e.revisionsEnabled?t.queue((()=>(e.redo(),t.commitAsync()))):e.redo())}onTransactionSelected(e){const{stm:t}=this,n=t.position-e.value;n>0?t.canUndo&&t.undo(n):n<0&&t.canRedo&&t.redo(-n)}}nf.initClass(),nf._$name="UndoRedoBase";const rf="http://www.w3.org/2000/svg",sf={bar:1,outline:2,text:3},of=(e,t)=>parseInt(e.order,10)-parseInt(t.order,10),af=(e,t)=>parseInt(e.dataset.order,10)-parseInt(t.dataset.order,10),lf=e=>e.field,cf=()=>!1,df=/\s+/;class uf extends Tc{static type="histogram";static $name="Histogram";static get configurable(){return{data:null,values:null,series:null,topValue:null,element:{children:[{ns:rf,tag:"svg",reference:"svgElement",width:"100%",height:"100%",preserveAspectRatio:"none",children:[{ns:rf,tag:"g",reference:"scaledSvgGroup"},{ns:rf,tag:"g",reference:"unscaledSvgGroup"}]}]},omitZeroHeightBars:!1,singleTextForAllBars:!0,monitorResize:!0,getRectClass:void 0,getBarClass:(e,t,n,i)=>"",getOutlineClass:(e,t)=>"",getOutlineDOMConfig:(e,t,n)=>t,getBarTip(e,t,n,i){},getBarText:(e,t,n)=>"",getBarDOMConfig:null,getBarTextDOMConfig:(e,t,n,i)=>e,getBarTextTip(e,t,n,i){}}}static properties={refreshSuspended:0};construct(e){const t=this;super.construct(e),t.scheduleRefresh=t.createOnFrame(t.refresh,[],t,!0),t.refresh()}set tip(e){var t;const n=this;null===(t=n.tip)||void 0===t||t.destroy(),n._tip=e?Cg.new({owner:n,forElement:n.svgElement,forSelector:"rect",internalListeners:{beforeShow:"up.onBeforeTipShow"}},e):null}onElementResize(){super.onElementResize(...arguments);const e=this.svgElement.getBoundingClientRect();this.scaledSvgGroup.setAttribute("transform",`scale(${e.width} ${e.height})`)}onBeforeTipShow({source:e}){const t=parseInt(e.activeTarget.dataset.index);e.html=e.contentTemplate({histogram:this,index:t})}updateSeries(e){const t=this,n=t._series={};let i=0,r=0;for(const t in e)if(!1!==e[t]){const s=n[t]=b.merge({},e[t]);s.field||(s.field=t),s.type||(s.type="bar"),"order"in s||(s.order=10*sf[s.type]+i),"index"in s||(s.index=i),"bar"===s.type&&(s.index=r++),s.id=t,i++}!t.topValue&&t._data&&(t.topValue=t.getDataTopValue(t._data)),t.refreshSuspended||t.scheduleRefresh()}getDataTopValue(e,t){const n=Object.values(t||this.series).map(lf);let i,r=0;for(let t=0,{length:s}=e;t<s;t++){i=e[t];for(let e=0,{length:t}=n;e<t;e++)r=Math.max(r,i[n[e]])}return r}updateGetRectClass(e){G.deprecate("core","7.0.0","getRectClass is deprecated in favor of getBarClass"),this.getBarClass=e}updateData(e){const t=this;t._data=e,!t.topValue&&t._data&&t._series&&(t.topValue=t.getDataTopValue(e)),t.refreshSuspended||t.scheduleRefresh()}updateTopValue(e){const t=this;t._topValue=e,!e&&t._data&&(t._topValue=t.getDataTopValue(t._data)),t.refreshSuspended||t.scheduleRefresh()}scheduleRefresh(){}suspendRefresh(){this.refreshSuspended++}resumeRefresh(){this.refreshSuspended&&this.refreshSuspended--}refresh(e){const t=this,{series:n,_tip:i,topValue:r,singleTextForAllBars:s}=t,o=(null==e?void 0:e.args)||[],a=[],l=[];if(!n)return;const c=Object.values(n).sort(of);if(s){for(const e of c){const n=t[`draw${H.capitalize(e.type)}`](e,...o);n&&(Array.isArray(n)?a.push.apply(a,n):a.push(n))}l.push(...t.drawText(null,...o))}else{for(const e of c){const n=t[`draw${H.capitalize(e.type)}`](e,...o);n&&(Array.isArray(n)?a.push.apply(a,n):a.push(n)),"bar"===e.type&&l.push(...t.drawText(e,...o))}l.sort(af)}a.sort(af),Ll.sync({domConfig:{width:"100%",height:"100%",preserveAspectRatio:"none",dataset:{topValue:r},children:[{ns:rf,tag:"g",reference:"scaledSvgGroup",children:a},{ns:rf,tag:"g",reference:"unscaledSvgGroup",children:l}]},configEquality:cf,targetElement:t.svgElement}),i&&i.isVisible&&t.onBeforeTipShow({source:i})}drawBar(e,...t){const n=this,{topValue:i,data:r,omitZeroHeightBars:s,barStyle:o}=n,{field:a,order:l,stretch:c}=e,{length:d}=r,u=1/d,h=[],g=H.createId(e.id),m=e.index,p=c?1:void 0;let f;for(let c=0,d=0,{length:v}=r;c<v;c++,d+=f){const v=r[c];let y=v.rectConfig={ns:rf,tag:"rect",dataset:{}};const b=v[a],C=b?p||v.height||(b>i?i:b)/i:0,S=1-C,D=n.callback("getBarTip",n,[e,y,v,c,...t]);f=v.width||u,o?y.style=o:delete y.style,Object.assign(y.dataset,{index:c,order:l,series:g});const w={[`b-series-${g}`]:1,[`b-series-index-${m}`]:1},E=n.callback("getBarClass",n,[e,y,v,c,...t]);E&&E.split(df).forEach((e=>w[e]=1)),Object.assign(y,{x:d,y:S,width:f,height:C,class:w}),D?y.dataset.btip=D:delete y.dataset.btip,n.getBarDOMConfig&&(y=n.getBarDOMConfig(e,y,v,c,...t)),!y||!y.height&&s||h.push(y)}return h}changeGetBarDOMConfig(e){return e?this.bindCallback(e):null}drawOutline(e,...t){const n=this,{topValue:i,data:r}=n,{field:s,order:o,id:a}=e,l=1/r.length,c=["M 0,1"],d={ns:rf,tag:"path",dataset:{order:o,id:a}};let u,h="M",g="L";for(let e=0,t=0,{length:n}=r;e<n;e++){const n=1-r[e][s]/i;u=r[e].width||l,c.push(`${h} ${t},${n} ${g} ${t+=u},${n}`),h=g=""}return d.class=`b-series-${e.id} b-series-index-${e.index} `+n.callback("getOutlineClass",n,[e,r,...t]),d.d=c.join(" "),n.callback("getOutlineDOMConfig",n,[e,d,r,...t])||[]}drawText(e,...t){const n=this,{data:i}=n,r=1/i.length,s=[];for(let o,a=0,l=0,{length:c}=i;a<c;a++,l+=o){o=i[a].width||r;const c=n.callback("getBarText",n,[i[a],a,e,...t]);if(c){const r=n.callback("getBarTextDOMConfig",n,[{ns:rf,tag:"text",className:"b-bar-legend",html:c,left:l,width:o,x:100*(l+o/2)+"%",y:void 0!==i[a].y?i[a].y:"100%",dataset:{index:a,series:e}},i[a],a,e,...t]);if(r){const o=n.callback("getBarTextTip",n,[r,i[a],a,e,...t]);o?r.dataset.btip=o:delete r.dataset.btip,s.push(r)}}}return s}}uf.initClass(),uf._$name="Histogram";const hf="http://www.w3.org/2000/svg";class gf extends Tc{static $name="Scale";static type="scale";static get configurable(){return{scalePoints:null,scaleMaxPadding:.1,horizontal:!1,align:{value:!1,$config:{merge:"replace"}},element:{children:[{ns:hf,tag:"svg",reference:"svgElement",width:"100%",height:"100%",preserveAspectRatio:"none",children:[{ns:hf,tag:"g",reference:"scaledSvgGroup",children:[{ns:hf,tag:"path",reference:"pathElement"}]},{ns:hf,tag:"g",reference:"unscaledSvgGroup"}]}]},monitorResize:!0}}construct(e){super.construct(e),this.scheduleRefresh=this.createOnFrame(this.refresh,[],this,!0),this.refresh()}changeAlign(e){return e||(e=this.horizontal?"bottom":"right"),e}updateAlign(e,t){this.element.classList.remove(`b-align-${t}`),this.element.classList.add(`b-align-${e}`)}updateHorizontal(e,t){this.element.classList.remove("b-scale-"+(t?"horizontal":"vertical")),this.element.classList.add("b-scale-"+(e?"horizontal":"vertical"))}onElementResize(){super.onElementResize(...arguments),this.scheduleRefresh()}scheduleRefresh(){}refresh(){var e;if(!this.scalePoints)return;const t=this,{horizontal:n,width:i,height:r,align:s,scalePoints:o,scaleMaxPadding:a}=t,l=null===(e=o[o.length-1])||void 0===e?void 0:e.value,c=[],d=[],u=1/(l+a*l);t.scaledSvgGroup.setAttribute("transform",`scale(${n?i:1} ${n?1:r})`);for(const e of o){const t=Boolean(e.text),o=u*e.value;if(t){const t={ns:hf,tag:"text",className:"b-scale-tick-label",html:e.text,dataset:{tick:e.value}};n?(t.x=100*o+"%",t.y="top"===s?"1.6em":r-12):(t.x="left"===s?"12":""+(i-12),t.y=100*(1-o)+"%"),d.push(t)}n?"top"===s?c.push(`M${o},0 L${o},${t?10:5}`):c.push(`M${o},${r} L${o},${r-(t?10:5)}`):"left"===s?c.push(`M0,${1-o} L${t?10:5},${1-o}`):c.push(`M${i},${1-o} L${i-(t?10:5)},${1-o}`)}t.pathElement.setAttribute("d",c.join("")),Ll.syncChildren({domConfig:{children:d}},t.unscaledSvgGroup)}}gf.initClass(),gf._$name="Scale";const mf=[],pf=e=>"*"!==e[0],ff=(e,t)=>{const n=e[t]||null;return delete e[t],n},vf=e=>e.responsiveRoot,yf={number:e=>({width:t})=>t<=e&&e},bf=e=>(delete e.once,{configs:e,callback:ff(e,"callback"),when:ff(e,"when")}),Cf=(e,t,...n)=>{const i=n.flatMap((e=>(null==e?void 0:e.once)||mf)),r=t.mergeConfigs(...n),s=bf(r);s.once=i.length?bf(t.mergeConfigs(...i)):null;for(const t in r)t in e&&delete r[t];return s};class Sf extends Pe{static $name="AvatarRendering";static get configurable(){return{element:null,colorPrefix:"b-sch-",tooltip:null,size:null}}doDestroy(){var e;null===(e=this.tooltip)||void 0===e||e.destroy(),super.doDestroy()}updateElement(e){Xt.on({element:e,delegate:".b-resource-image",error:"onImageErrorEvent",thisObj:this,capture:!0})}changeTooltip(e){return Cg.new({forElement:this.element,forSelector:".b-resource-avatar",cls:"b-resource-avatar-tooltip"},e)}static get failedUrls(){return this._failedUrls||(this._failedUrls=new Set)}getResourceAvatar(e){if(Array.isArray(e))return e.map((e=>this.getResourceAvatar(e)));const{initials:t,color:n,iconCls:i,imageUrl:r,defaultImageUrl:s,dataset:o={},resourceRecord:a,alt:l=H.encodeHtml(null==a?void 0:a.name)}=e,c=this.getImageConfig(t,n,r,s,o,l)||this.getIconConfig(i,o,l)||this.getResourceInitialsConfig(t,n,o,l),{size:d}=this;return Object.assign(c.style,{...d?{height:d,width:d}:void 0}),c}getImageConfig(e,t,n,i,r,s){if(n=Sf.failedUrls.has(n)?i:n||i)return{tag:"img",draggable:"false",loading:"lazy",class:{"b-resource-avatar":1,"b-resource-image":1},style:{},alt:s,"aria-label":s,elementData:{defaultImageUrl:i,imageUrl:n,initials:e,color:t,dataset:r},src:n,dataset:r}}getIconConfig(e,t,n){if(e)return e&&{tag:"i",style:{},"aria-label":n,class:{"b-resource-avatar":1,"b-resource-icon":1,[e]:1},dataset:t}}getResourceInitialsConfig(e,t,n,i){const r=Wn.isNamedColor(t)&&t,s=!r&&t,{size:o}=this;return{tag:"div","aria-label":i,class:{"b-resource-avatar":1,"b-resource-initials":1,[`${this.colorPrefix}${r}`]:r},style:{backgroundColor:s||null,...o?{height:o,width:o}:void 0},text:e,dataset:n}}onImageErrorEvent({target:e}){if(!e.matches(".b-resource-avatar")||!e.isConnected)return;const{defaultImageUrl:t,initials:n,color:i,imageUrl:r,dataset:s}=e.elementData;if(t&&!e.src.endsWith(t.replace(/^[./]*/gm,"")))e.src=t;else{const{parentElement:t}=e,r=Array.from(t.childNodes).indexOf(e),o=this.getResourceInitialsConfig(n,i,s,e.alt),a=Wn.createElement(o);a.elementData=e.elementData,a.lastDomConfig=o,t.lastDomConfig&&(t.lastDomConfig.children[r]=o),t.replaceChild(a,e)}Sf.failedUrls.add(r)}}Sf._$name="AvatarRendering",window&&!window.bryntum&&(window.bryntum={});class Df{static UP=1;static NEXT_CELL=2;static DOWN=3;static PREV_CELL=4;static FIRST_COLUMN=5;static LAST_COLUMN=6;static FIRST_CELL=7;static LAST_CELL=8;static PREV_PAGE=9;static NEXT_PAGE=10;constructor(e){if(e){if(e.isLocation)return e;if(e.nodeType===Node.ELEMENT_NODE){const t=Tc.fromElement(e,"gridbase"),n=t&&e.closest(t.focusableSelector);if(n){const{dataset:i}=n.parentNode;this.init({grid:t,rowIndex:t.store.includes(i.id)?t.store.indexOf(i.id):i.index||-1,columnId:n.dataset.columnId}),this.initialTarget=e}}else this.init(e)}}init(e){var t;const n=this,i=n.grid=e.grid,{store:r,columns:s}=i,{visibleColumns:o}=s;if(e.target&&(n.actionTargets=[n._target=e.target]),e.record)n._id=e.record.id;else if("id"in e)n._id=e.id,null==e.id&&(n._rowIndex=-1);else{var a;const t=isNaN(e.row)?isNaN(e.rowIndex)?NaN:e.rowIndex:e.row;n._rowIndex=Math.max(Math.min(Number(t),r.count-1),i.hideHeaders?0:-1),n._id=null===(a=r.records[n._rowIndex])||void 0===a?void 0:a.id}if("_rowIndex"in n||(n._rowIndex=r.indexOf(n.id)),n.isSpecialRow=null===(t=n.record)||void 0===t?void 0:t.isSpecialRow,"columnId"in e)n._column=s.getById(e.columnId);else if("field"in e)n._column=s.get(e.field);else{const t=isNaN(e.column)?isNaN(e.columnIndex)?NaN:e.columnIndex:e.column;isNaN(t)?n._column="column"in e?isNaN(e.column)?e.column:o[e.column]:o[0]:(n._columnIndex=Math.min(Number(t),o.length-1),n._column=o[n._columnIndex])}"_columnIndex"in n||(n._columnIndex=o.indexOf(n._column))}get isLocation(){return!0}equals(e,t=!1){const n=this;return(null==e?void 0:e.isLocation)&&e.grid===n.grid&&(t?n.id===e.id&&n._column===e._column:e.record===n.record&&e.column===n.column&&e.target===n.target)}get rowIndex(){const{_id:e}=this,{store:t}=this.grid;return t.includes(e)?t.indexOf(e):Math.min(this._rowIndex,t.count-1)}get visibleRowIndex(){const{rowManager:e}=this.grid,{rowIndex:t}=this;return-1===t?t:Math.max(Math.min(t,e.lastFullyVisibleTow.dataIndex),e.firstFullyVisibleTow.dataIndex)}get isSelectable(){return this.grid.store.includes(this._id)&&!this.isSpecialRow}get record(){var e;if(null!==(e=this._record)&&void 0!==e&&e.isModel)return this._record;if(this._rowIndex>-1){const{store:e}=this.grid;return e.includes(this._id)?e.getById(this._id):e.records[this._rowIndex]}}get id(){return this._id}get column(){const{visibleColumns:e}=this.grid.columns;return null!=e&&e.includes(this._column)?this._column:null==e?void 0:e[this.columnIndex]}get columnId(){var e;return null===(e=this.column)||void 0===e?void 0:e.id}get columnIndex(){var e;return Math.min(this._columnIndex,(null===(e=this.grid.columns.visibleColumns)||void 0===e?void 0:e.length)-1)}move(e){const t=this,{record:n,column:i,grid:r}=t,{store:s}=r,o=r.columns.visibleColumns,a=new Df;let l=s.includes(n)?s.indexOf(n):t.rowIndex,c=o.includes(i)?o.indexOf(i):t.columnIndex;const d=r.hideHeaders?0:-1,u=s.count-1,h=o.length-1,g=l===d,m=l===u,p=0===c,f=c===h;switch(e){case Df.PREV_CELL:p?g||(c=h,l--):c--;break;case Df.NEXT_CELL:f?m||(c=0,l++):c++;break;case Df.UP:g||l--;break;case Df.DOWN:m||(-1===l?l=r.rowManager.firstFullyVisibleRow.dataIndex:l++);break;case Df.FIRST_COLUMN:c=0;break;case Df.LAST_COLUMN:c=h;break;case Df.FIRST_CELL:l=d,c=0;break;case Df.LAST_CELL:l=u,c=h;break;case Df.PREV_PAGE:l=Math.max(d,l-Math.floor(r.scrollable.clientHeight/r.rowHeight));break;case Df.NEXT_PAGE:l=Math.min(u,l+Math.floor(r.scrollable.clientHeight/r.rowHeight))}return a.init({grid:r,rowIndex:l,columnIndex:c}),a}get cell(){const e=this,{grid:t,id:n,_cell:i}=e;if(i)return i;var r;if(null==n)return null===(r=t.columns.getById(e.columnId))||void 0===r?void 0:r.element;{const{row:n}=e;var s;if(n)return n.getCell(e.columnId)||n.getCell(null===(s=t.columns.getAt(e.columnIndex))||void 0===s?void 0:s.id)}}get row(){return this.grid.getRowById(this.id)||this.grid.getRow(this.rowIndex)}get target(){const{cell:e,_target:t}=this,{focusableFinder:n}=this.grid;if(e)return t||(n.currentNode=this.grid.focusableFinderCell=e,n.nextNode()||e)}get isActionable(){const{cell:e,_target:t}=this,n=e&&Wn.getActiveElement(e),i=n&&e.compareDocumentPosition(n)&Node.DOCUMENT_POSITION_CONTAINED_BY;return Boolean(i||t&&t!==this.cell)}get isColumnHeader(){return this.cell&&-1===this.rowIndex}get isCell(){return this.cell&&this.record}}Df._$name="GridLocation";const wf=e=>"number"==typeof e||(null==e?void 0:e.endsWith("px")),Ef=/=>\s*['"]/;class Rf extends(ws.mixin(at,Ri)){static $name="Column";static type="column";get type(){return this.constructor.type}static fields=["type","text","field","renderer","afterRenderCell","width","flex","autoWidth","autoHeight",{name:"fitMode",defaultValue:"exact"},"readOnly",{name:"editor",defaultValue:{}},"cellEditor","finalizeCellEdit",{name:"managedCellEditing",defaultValue:!0},{name:"revertOnEscape",defaultValue:!0},{name:"invalidAction",defaultValue:"block"},{name:"sortable",defaultValue:!0,convert(e,t,n){if(!e)return!1;if(!0===e)return!0;const i={};return"function"==typeof e?(i.originalSortFn=e,i.sortFn=e.bind(n)):"object"==typeof e&&(Object.assign(i,e),i.fn&&(i.sortFn=i.fn,delete i.fn)),i}},{name:"searchable",defaultValue:!0},{name:"collapsible",defaultValue:!1},{name:"collapsed",defaultValue:!1},{name:"collapseMode"},{name:"filterable",defaultValue:!0,convert(e){if(!e)return!1;if(!0===e)return!0;const t={columnOwned:!0};return"function"==typeof e?t.filterFn=e:"object"==typeof e&&Object.assign(t,e),t}},{name:"sealed"},{name:"hideable",defaultValue:!0},{name:"draggable",defaultValue:!0},{name:"groupable",defaultValue:!0},{name:"resizable",defaultValue:!0},"groupRenderer","headerRenderer","tooltip","tooltipRenderer","cellCls","cls","icon","align",{name:"minWidth",defaultValue:60},"maxWidth",{name:"hidden",defaultValue:!1},{name:"locked"},{name:"region"},{name:"mergeCells",type:"boolean"},{name:"mergeable",type:"boolean",defaultValue:!0},"mergedRenderer",{name:"showColumnPicker",defaultValue:!0},{name:"enableHeaderContextMenu",defaultValue:!0},{name:"enableCellContextMenu",defaultValue:!0},"headerMenuItems","cellMenuItems","sum","summaries","summaryRenderer","responsiveLevels","tags","touchConfig","tree","filterType",{name:"htmlEncode",defaultValue:!0},{name:"htmlEncodeHeaderText",defaultValue:!0},{name:"autoSyncHtml",defaultValue:!1},{name:"alwaysClearCell",defaultValue:!0},{name:"headerWidgets"},{name:"instantUpdate",defaultValue:!1},{name:"repaintOnResize",defaultValue:!1},"editTargetSelector",{name:"exportable",defaultValue:!0},{name:"exportedType"},{name:"ariaLabel",defaultValue:"L{Column.columnLabel}"},{name:"cellAriaLabel",defaultValue:"L{cellLabel}"}];static autoExposeFields=!1;construct(e,t,n,...i){const r=this,s=null==n?void 0:n.isRoot;if(s||(r.masterStore=t,t&&(r._grid=Array.isArray(t)?t[0].grid:t.grid),r.localizableProperties=ce.mergeMethods.distinct(e.localizableProperties,["text","ariaLabel","cellAriaLabel"]),e.localeClass&&(r.localeClass=e.localeClass)),super.construct(e,t,n,...i),!s&&(r.isLeaf&&!("field"in r.data)&&(r.setData("field","_"+(r.type||"")+ ++Rf.emptyCount),r.noFieldSpecified=!0),r.width||r.flex||r.children||r.setData({width:Rf.defaultWidth,flex:null},null,!0),r.headerWidgets&&r.initHeaderWidgets(r.headerWidgets),r.isParent&&(r.meta.visibleChildren=new Set,r.collapsible&&r.grid.once("paint",(()=>r.collapsible=!0))),r.renderer)){const e=r.renderer.toString();r.rendererReturningContent=e.includes("return ")||Boolean(e.match(Ef))}}shouldSync(e){return e.isColumn&&e.text===this.text&&(e.field===this.field||String(e.renderer)===String(this.renderer))&&(!e.previousSibling&&!this.previousSibling||e.previousSibling.shouldSync(this.previousSibling))}get isCollapsible(){var e;return(null===(e=this.children)||void 0===e?void 0:e.length)>1&&this.collapsible}get collapsed(){return this.get("collapsed")}set collapsed(e){this.set("collapsed",e,!0),this.onCollapseChange(!e),this.grid.trigger("columnCollapseToggle",{column:this,collapsed:e})}onCellFocus(e){this.location=e,this._headerArialLabelSet||(this.updateHeaderAriaLabel(this.localizeProperty("ariaLabel")),this._headerArialLabelSet=!0),-1!==e.rowIndex&&this.updateCellAriaLabel(this.localizeProperty("cellAriaLabel"))}updateHeaderAriaLabel(e){Wn.setAttributes(this.element,{"aria-label":e})}updateCellAriaLabel(e){var t,n,i;null!==(t=this.location)&&void 0!==t&&t.isSpecialRow||null===(n=this.location)||void 0===n||!n.cell||(null!==(i=e)&&void 0!==i&&i.length||(e=this.location.column.text),Wn.setAttributes(this.location.cell,{"aria-label":e}))}doDestroy(){var e,t;null===(e=this.data)||void 0===e||null===(e=e.editor)||void 0===e||null===(t=e.destroy)||void 0===t||t.call(e),this.destroyHeaderWidgets(),super.doDestroy()}set headerWidgets(e){this.initHeaderWidgets(e),this.set("headerWidgets",e)}get headerWidgets(){return this.get("headerWidgets")}initHeaderWidgets(e){this.destroyHeaderWidgets();const t=this.headerWidgetMap={};for(const n of e){const e=Tc.create({owner:this,...n});e.element.classList.add("b-grid-headerwidget"),t[e.ref||e.id]=e}}destroyHeaderWidgets(){for(const t of Object.values(this.headerWidgetMap||{})){var e;null===(e=t.destroy)||void 0===e||e.call(t)}}static generateAutoCls(){const e=[];for(let t=this;t!==Rf;t=t.superclass)t.type&&t.type!==t.superclass.type&&e.push(`b-${t.type.toLowerCase()}-cell`);const t=e.join(" ");return(Rf.autoClsMap||(Rf.autoClsMap=new Map)).set(this,t),t}getCellClass(e){var t;const{record:n,column:i}=e,{cellCls:r,internalCellCls:s,grid:o,constructor:a,align:l,field:c}=i,d=n.fieldMap[c],u=(null===(t=Rf.autoClsMap)||void 0===t?void 0:t.get(a))||a.generateAutoCls(),h=e.cell.classList.contains("b-editing"),g={[o.cellCls]:o.cellCls,[u]:u,[r]:r,[s]:s,"b-cell-dirty":c&&!(null!=d&&d.calculated)&&n.isFieldModified(c)&&(i.compositeField||!1!==(null==d?void 0:d.persist)),[`b-grid-cell-align-${l}`]:l,"b-selected":o.selectionMode.cell&&o.isCellSelected(e),"b-focused":o.isFocused(e),"b-auto-height":i.autoHeight,"b-editing":h};return n.isSpecialRow&&g["b-checkbox-selection"]&&(g["b-checkbox-selection"]=!1),g}get locked(){return"locked"===this.data.region}set locked(e){this.region=e?"locked":"normal"}get region(){return this.parent.isRoot?this.get("region"):this.parent.region}set region(e){this.set("region",e)}get sortable(){const{sortable:e}=this.data;return!(!e||!(!this.noFieldSpecified&&this.field||e.sortFn))&&e}set sortable(e){this.set("sortable",e)}get groupable(){return Boolean(!(this.noFieldSpecified||!this.field)&&this.data.groupable)}set groupable(e){this.set("groupable",e)}get filterable(){return this.isLeaf&&this.data.filterable}get editor(){const e=this;let{editor:t}=e.data;if(t&&!t.isWidget){const n=e.grid.processCellEditor({editor:t,field:e.field});n?t=e.data.editor=n.editor:("string"==typeof t&&(t={type:t}),t=e.data.editor=Tc.create(W.merge(e.defaultEditor,{owner:e.grid,label:H.encodeHtml(e.text)},t)))}return t}set editor(e){this.data.editor=e}get defaultEditor(){return{type:"textfield",name:this.field}}getFilterableValue(e){return this.getRawValue(e)}get owner(){return this._owner||this.subGrid}set owner(e){this._owner=e}get grid(){var e;return this._grid||(null===(e=this.parent)||void 0===e?void 0:e.grid)}set subGrid(e){this._subGrid=e}get subGrid(){var e;return this._subGrid||(null===(e=this.grid)||void 0===e?void 0:e.getSubGridFromColumn(this))}get subGridElement(){return this.subGrid.element}get element(){return this.grid.getHeaderElement(this)}get previousVisibleSibling(){const e=this.region;let t=this.previousSibling;for(;t&&(t.hidden||t.region!==e);)t=t.previousSibling;return t}get nextVisibleSibling(){const e=this.region;let t=this.nextSibling;for(;t&&(t.hidden||t.region!==e);)t=t.nextSibling;return t}get isLastInSubGrid(){return!this.nextVisibleSibling&&(this.parent.isRoot||this.parent.isLastInSubGrid)}get allowDrag(){return!this.parent.isRoot||Boolean(this.nextVisibleSibling||this.previousVisibleSibling)}get textWrapper(){return Wn.getChild(this.element,".b-grid-header-text")}get textElement(){return Wn.down(this.element,".b-grid-header-text-content")}get contentElement(){return Wn.down(this.element,".b-grid-header-children")}get isSorted(){return this.grid.store.sorters.some((e=>e.field===this.field))}get isFocusable(){var e;return this.isLeaf&&!(null!==(e=this.grid)&&void 0!==e&&e.hideHeaders)}static get text(){return this.$meta.fields.defaults.text}get headerText(){return this.htmlEncodeHeaderText?H.encodeHtml(this.text):this.text}get isVisible(){return!this.hidden&&(!this.parent||this.parent.isVisible)}hide(e=!1,t=!1){const n=this,{parent:i}=n;if(!n.hidden){if(n.hidden=!0,i&&!i.isRoot&&!i.isTogglingAll){i.children.some((e=>!0!==e.hidden))||i.hidden||(e=!0,i.hide())}n.isParent?n.children.forEach((e=>e.hide(!0,!0))):i.isRoot||i.meta.visibleChildren[t?"add":"delete"](n),e||n.stores.forEach((e=>e.trigger("columnHide",{column:n})))}}show(e=!1){const t=this,{parent:n}=t;if(t.hidden){var i;if(t.hidden=!1,null!=n&&n.hidden&&n.show(),t.isParent)null===(i=t.meta.visibleChildren)||void 0===i||i.forEach((e=>e.show(!0)));e||t.stores.forEach((e=>e.trigger("columnShow",{column:t})))}}toggle(e){return this.hidden&&void 0===e||!0===e?this.show():!this.hidden&&void 0===e||!1===e?this.hide():void 0}toggleChildren(e=this.children,t=void 0){var n,i;const r=this;null===(n=r.grid.columns)||void 0===n||n.beginBatch(),r.isTogglingAll=!0,e.forEach((e=>e.toggle(t))),r.isTogglingAll=!1,null===(i=r.grid.columns)||void 0===i||i.endBatch()}onCollapseChange(e=void 0){const t=this;if("toggleAll"===t.collapseMode)t.toggleChildren();else{var n,i;const{firstChild:r}=t;null!=r.flex&&t.collapsed?(r.oldFlex=r.flex,r.width=r.element.offsetWidth):!t.collapsed&&r.oldFlex&&(r.flex=r.oldFlex,r.oldFlex=null),null===(n=t.grid.columns)||void 0===n||n.beginBatch(),t.isTogglingAll=!0,t.children.slice(1).forEach((t=>t.toggle(e))),t.isTogglingAll=!1,null===(i=t.grid.columns)||void 0===i||i.endBatch()}}set collapsible(e){const t=this;if(t.set("collapsible",e),t.isParent){const{headerWidgets:n=[]}=t;if(e)n.push({type:"button",ref:"collapseExpand",toggleable:!0,pressed:t.collapsed,icon:"b-icon-collapse-"+(t.grid.rtl?"right":"left"),pressedIcon:"b-icon-collapse-"+(t.grid.rtl?"left":"right"),cls:"b-grid-header-collapse-button b-transparent",onToggle:({pressed:e})=>t.collapsed=e});else{const e=n.findIndex((e=>"collapseExpand"===e.ref));e>-1&&n.splice(e,1)}t.headerWidgets=n,t.collapsed&&t.onCollapseChange(!1)}}get collapsible(){return this.get("collapsible")}generateId(){var e;const{grid:t}=this,n=[(null===(e=this.field)||void 0===e?void 0:e.replace(/\./g,"-"))??"col"];return t?(n.unshift(t.stateId??t.id),t.generatedIdIndex||(t.generatedIdIndex=0),n.push(t.generatedIdIndex+=1)):(Rf.generatedIdIndex||(Rf.generatedIdIndex=0),n.push(Rf.generatedIdIndex+=1)),this.meta.generatedId=n.join("-")}get allIndex(){return this.masterStore.indexOf(this)}measureSize(e){var t;return Wn.measureSize(e,null===(t=this.subGrid)||void 0===t?void 0:t.element)}get calcMinWidth(){const{width:e,minWidth:t}=this.data;return wf(e)&&wf(t)?Math.max(parseInt(e)||0,parseInt(t)||0):e}get width(){return this.data.width}set width(e){const t={width:e};e&&"flex"in this.data&&(t.flex=null),this.set(t)}set flex(e){const t={flex:e};e&&"width"in this.data&&(t.width=null),this.set(t)}get flex(){return this.data.flex}calculateMinWidth(){const e=this,t=e.measureSize(e.width),n=e.measureSize(e.minWidth);let i=0;return e.children&&(i=e.children.reduce(((e,t)=>e+t.calculateMinWidth()),0)),Math.max(t,n,i)}resizeToFitContent(e,t,n=!1){var i;const r=this,{grid:s,element:o,fitMode:a}=r,{rowManager:l}=s,{records:c}=s.$store,d=c.length;if(d<=0||"none"===r.fitMode||!r.fitMode||null!==(i=r.data)&&void 0!==i&&i.vue)return;const[u]=l.rows,{rowElement:h,cellElement:g}=s.beginGridMeasuring(),m=new Df({grid:s,column:r,id:null});let p,f,v,y,b,C,S=0,D={length:0,record:null};if(g._domData={columnId:r.id,row:u,rowElement:h},m._cell=g,m.updatingSingleRow=!0,m.isMeasuring=!0,g.innerHTML="",s.resizeToFitIncludesHeader&&!s.hideHeaders){if(!s.$headerPadding){const e=globalThis.getComputedStyle(o);s.$headerPadding=parseInt(e.paddingLeft)}const e=o.querySelector(".b-grid-header-text-content");e.style.cssText="flex: none; width: auto",S=e.offsetWidth+2*s.$headerPadding+2,e.style.cssText=""}for(d>1e3?(p=Math.max(Math.min(l.topIndex+Math.round(l.rowCount/2)-500,d-1e3),0),f=p+1e3):(p=0,f=d),v=p;v<f;v++){if(y=c[v],b=r.getRawValue(y),"value"===a)C=String(b).length;else if(m._record=y,m._id=y.id,m._rowIndex=v,u.renderCell(m),"textContent"===a)C=g.textContent.length;else{const e=g.offsetWidth;e>S&&(S=e)}C>D.length&&(D={record:y,length:C,rowIndex:v})}return D.length>0&&("value"===a||"textContent"===a)&&(m._record=D.record,m._id=D.record.id,m._rowIndex=D.rowIndex,u.renderCell(m),S=Math.max(S,g.offsetWidth)),Array.isArray(e)&&([e,t]=e),S=Math.max(S,e||0),S=Math.min(S,t||1e6),n||s.endGridMeasuring(),r.width=r.maxWidth?S=Math.min(S,r.maxWidth):S,S}getState(){const e=this,{parentId:t}=e,n={id:e.id,hidden:e.hidden,region:e.region,locked:e.locked,text:e.text};return e.noFieldSpecified||(n.field=e.field),null!=t&&(n.parentId=t),e.children||(n[e.flex?"flex":"width"]=e.flex||e.width),e.isCollapsible&&(n.collapsed=e.collapsed),n}applyState(e){const t=this;t.beginBatch(),"locked"in e&&(t.locked=e.locked),"width"in e&&(t.width=e.width),"flex"in e&&(t.flex=e.flex),"width"in e&&t.flex?t.flex=void 0:"flex"in e&&t.width&&(t.width=void 0),"region"in e&&(t.region=e.region),"text"in e&&(t.text=e.text),t.endBatch(),"hidden"in e&&t.toggle(!0!==e.hidden),"collapsed"in e&&(t.collapsed=e.collapsed)}remove(){const{subGrid:e,grid:t}=this,n=e&&(null==t?void 0:t.focusedCell);(null==n?void 0:n.columnId)===this.id&&(t.owns(Wn.getActiveElement(t))?t.navigateRight():t._focusedCell=new Df({grid:t,rowIndex:n.rowIndex,column:e.columns.getAdjacentVisibleLeafColumn(this.id,!0,!0)})),super.remove()}getRawValue(e){return e.getValue(this.field)}refreshCell(e){this.grid.rowManager.refreshCell(e,this.id)}refreshCells(){this.grid.refreshColumn(this)}refreshHeader(){this.grid.refreshHeader(this)}clearCell(e){e.innerHTML="",delete e._content}canEdit(e){if(e.isEditable){const t=e.isEditable(this.field);if(void 0!==t)return t}return!0}insertChild(e,t=null,n=!1){return(e=Array.isArray(e)?e:[e]).forEach((e=>{const{parent:t}=e;null!=t&&t.collapsed&&e===t.firstChild&&t.children.length>1&&1===t.children.filter((e=>!e.hidden)).length&&(e.nextSibling.hidden=!1)})),this.sealed&&!this.inProcessChildren?null:super.insertChild(...arguments)}canFillValue(){return!0}getCurrentConfig(e){var t;const n=super.getCurrentConfig(e);return null!==(t=this.sortable)&&void 0!==t&&t.originalSortFn&&(n.sortable=this.sortable.originalSortFn),n.headerRenderer===this.internalHeaderRenderer&&delete n.headerRenderer,delete n.ariaLabel,delete n.cellAriaLabel,delete n.disableRendererWarning,n}get visible(){return this.isVisible}set visible(e){this.hidden=!e}get readOnly(){const{field:e,grid:t}=this,n=Boolean(this.get("readOnly"));var i;return e&&t&&(null===(i=t.store.modelClass.getFieldDefinition(e))||void 0===i?void 0:i.calculated)||n}set readOnly(e){this.set("readOnly",e)}get renderer(){var e;return(null===(e=this.data)||void 0===e?void 0:e.renderer)||this.defaultRenderer}set renderer(e){this.set("renderer",e)}}Rf.emptyCount=0,Rf.defaultWidth=100,Rf.exposeProperties(),Rf._$name="Column";const xf={boolean:{type:"check"},date:{type:"date"},integer:{type:"number",format:{maximumFractionDigits:0}},number:{type:"number"}},Tf=[{field:"region"}];class Mf extends(Ri(gl)){static get defaultConfig(){return{modelClass:Rf,tree:!0,autoAddField:!1,syncDataOnLoad:{threshold:1},sorters:Tf,reapplySortersOnAdd:!0,useRawData:!1}}construct(e){const t=this,{grid:n}=e;n&&(n._columnStore=t,t.id=`${n.id}-columns`,n.ion({subGridCollapse:"clearSubGridCaches",subGridExpand:"clearSubGridCaches",thisObj:t})),super.construct(e),t.ion({change:t.onStoreChange,sort:()=>t.updateChainedStores(),thisObj:t,prio:1})}doDestroy(){const e=[];this.isChained||this.traverse((t=>e.push(t))),super.doDestroy(),this.isChained||e.forEach((e=>e.destroy()))}getById(e){return super.getById(e)||this.idRegister[e]}forEach(e,t=this){this.traverseWhile(((n,i)=>e.call(t,n,i)),!0)}get totalFixedWidth(){let e=0;for(const t of this)t.hidden||(t.children?t.children.forEach((t=>e+=this.calculateFixedWidth(t))):e+=this.calculateFixedWidth(t));return e}get hasFlex(){return this.visibleColumns.some((e=>e.flex))}calculateFixedWidth(e){return e.flex?e.measureSize(Rf.defaultWidth):Math.max(e.measureSize(e.width),e.measureSize(e.minWidth))}get topColumns(){return this.isChained?this.masterStore.rootNode.children.filter(this.chainedFilterFn):this.rootNode.children}get visibleColumns(){const e=this;return e._visibleColumns||(e._visibleColumns=e.leaves.filter((e=>e.isVisible&&(!e.subGrid||!e.subGrid.collapsed))).sort(e.sorterFn)),e._visibleColumns}onStoreChange({action:e,changes:t}){("update"!==e||"hidden"in t)&&this.clearCaches()}clearSubGridCaches({subGrid:e}){e.columns.clearCaches(),this.clearCaches()}clearCaches(){var e;this._visibleColumns=null,null===(e=this.masterStore)||void 0===e||e.clearCaches()}onMasterDataChanged(e){super.onMasterDataChanged(e),("update"!==e.action||"hidden"in e.changes||"region"in e.changes)&&this.clearCaches()}getAdjacentVisibleLeafColumn(e,t=!0,n=!1){const i=this.visibleColumns,r=e instanceof Rf?e:this.getById(e);let s=i.indexOf(r)+(t?1:-1);if(!i[s]){if(!n)return null;s=t?0:i.length-1}return i[s]}get bottomColumns(){return this.leaves}get(e){return this.findRecord("field",e,!0)}lookupStateColumn(e){let t=this.getById(e.id);if(!t&&e.field){const n=this.query((t=>t.field===e.field));1===n.length&&(t=n[0])}return t}createRecord(e){var t;const{grid:n={}}=this,{store:i}=n,r=null==i||null===(t=i.modelClass)||void 0===t||null===(t=t.fieldMap)||void 0===t?void 0:t[e.field];let s=this.modelClass;if(null!=r&&r.column&&(e=b.merge({},r.column,e)),e.type&&(s=Mf.getColumnClass(e.type),!s))throw new Error(`Column type '${e.type}' not registered. Please make sure you have imported the column class.`);e.locked&&(e.region="locked",delete e.locked);const o=new s(e,this);if(o.data.region||(o.data.region=n.defaultRegion||"normal"),this.autoAddField&&!o.noFieldSpecified&&i&&!r){let e=o.field;o.constructor.fieldType&&(e={name:o.field,type:o.constructor.fieldType}),i.modelClass.addField(e)}return o}indexOf(e){if(null==e)return-1;const t=super.indexOf(e);return t>-1?t:this.records.findIndex((t=>t.field===e))}removeAll(e=!1){const t=this;return t.some((e=>e.isTimeAxisColumn))?t.remove(t.query((e=>!e.isTimeAxisColumn)),e):super.removeAll(e)}get usesAutoHeight(){return this.some((e=>e.autoHeight))}get usesFlexAutoHeight(){return this.some((e=>e.autoHeight&&null!=e.flex))}resolveSyncNode(e){return e.id?super.resolveSyncNode(e):e.field?{id:e.field,node:this.allRecords.find((t=>t.field===e.field))}:e.type?{id:e.type,node:this.allRecords.find((t=>t.type===e.type))}:{id:null,node:null}}static registerColumnType(e,t=!1){e.simpleRenderer=t,(Mf.columnTypes||(Mf.columnTypes={}))[e.type]=e}static getColumnClass(e){return Mf.columnTypes&&Mf.columnTypes[e]}generateColumnForField(e,t){var n;"string"==typeof e&&this.grid&&(e=null===(n=this.grid.store)||void 0===n?void 0:n.modelClass.fieldMap[e]);let i=e.column||xf[e.type]||{};return"string"==typeof i&&(i={type:i}),i=Object.assign({text:e.text||H.separate(e.name),field:e.name},t,i),null!=e.precision&&(i.format.maximumFractionDigits=e.precision),e.columnType&&(i.type=e.columnType),this.createRecord(i)}}Mf.registerColumnType(Rf,!0),Mf._$name="ColumnStore";class If extends Rf{static type="action";static $name="ActionColumn";static fields=[{name:"actions",type:"array"},{name:"disableIfGridReadOnly",defaultValue:!1}];static defaults={minWidth:30,filterable:!1,groupable:!1,sortable:!1,editor:!1,searchable:!1,htmlEncode:!1,resizable:!1,readOnly:!0};get groupHeaderReserved(){return!0}construct(e,t){const n=this;e.renderer&&(G.deprecate("grid","7.0.0","Using deprecated `renderer` with ActionColumn, use `afterRenderCell` callback instead."),e.afterRenderCell=e.renderer,delete e.renderer),super.construct(e,t),e.width||e.flex||n.grid.ion({paint:"updateAutoWidth",thisObj:n}),n.disableIfGridReadOnly&&n.grid.element.classList.add("b-actioncolumn-readonly")}defaultRenderer({grid:e,column:t,record:n,isExport:i,callExternalRenderer:r=!0}){var s;const o=n&&"groupRowFor"in n.meta,{subGrid:a}=t,l={className:{"b-action-ct":1},children:null===(s=t.actions)||void 0===s?void 0:s.map(((e,r)=>{var s;if("visible"in e&&("function"==typeof e.visible&&!1===e.visible({record:n})||!1===e.visible))return"";if(o&&!e.showForGroup||!o&&e.showForGroup)return"";const{tooltip:l,renderer:c}=e,d="function"==typeof l||null!=l&&null!==(s=l.startsWith)&&void 0!==s&&s.call(l,"up.")?a.callback(l,a,[{record:n}]):l||"";let u;if(c){const s=a.callback(c,a,[{index:r,record:n,column:t,isExport:i,tooltip:d,action:e}])??"";"string"==typeof s?u={tag:"span",class:"b-action-item b-tool",dataset:{...Cg.encodeConfig(d),index:r},html:s}:(u=s,(u.dataset||(u.dataset={})).index=r,(u.className||(u.className={}))["b-action-item"]=1,u.className[e.cls]=e.cls)}else u={tag:"button",dataset:{...Cg.encodeConfig(d),index:r},className:{"b-tool":1,"b-action-item":1,[e.cls]:e.cls}};const h=e.ariaLabel||("string"==typeof e.tooltip?e.tooltip:void 0);return h&&(u["aria-label"]=H.encodeHtml(h)),u}))};return i?l.children.flatMap((e=>e.html||[])).join(","):l}onCellClick({grid:e,column:t,record:n,target:i}){var r;let s;if(t!==this||!(s=i.closest(".b-action-item[data-index]")))return;const o=s.dataset.index,a=null===(r=t.actions)||void 0===r?void 0:r[o],l=null==a?void 0:a.onClick;l&&this.callback(l,t,[{record:n,action:a,target:i,grid:e,column:t}])}updateAutoWidth(){const e=this,t=[],{actions:n}=e;if(!e.element)return;const i=e.actions=[];null==n||n.forEach((e=>{const n={...e};delete n.visible,n.showForGroup?(delete n.showForGroup,t.push(n)):i.push(n)})),t.length>i.length&&(e._actions=t);const r=Wn.createElement(e.defaultRenderer({column:e,record:new e.grid.store.modelClass,callExternalRenderer:!1})).outerHTML;e.width=Wn.measureText(r,e.element,!0,e.element.parentElement),e.actions=n}}Mf.registerColumnType(If),If.exposeProperties(),If._$name="ActionColumn";class Af extends Rf{static type="number";static fieldType="number";static fields=[{name:"format",defaultValue:""},"min","max","step","largeStep","unit","renderer"];static defaults={filterType:"number",align:"end"};get defaultEditor(){const{format:e,name:t,max:n,min:i,step:r,largeStep:s,align:o}=this;return W.cleanupProperties({type:"numberfield",format:e,name:t,max:n,min:i,step:r,largeStep:s,textAlign:o})}get formatter(){const e=this,{format:t}=e;let n=e._formatter;return n&&e._lastFormat===t||(e._formatter=n=km.getLocalizedFormatter(e._lastFormat=t)),n}formatValue(e,t=!0){return null!=e&&(e=this.formatter.format(e),this.unit&&t&&(e=`${e}${this.unit}`)),e??""}defaultRenderer({value:e}){return this.formatValue(e)}updateLocalization(){super.updateLocalization(),this._formatter=null}}Mf.registerColumnType(Af,!0),Af.exposeProperties(),Af._$name="NumberColumn";class kf extends Af{static type="aggregate";static fields=["function","includeParentInChangeSet"];static get defaults(){return{function:"sum",includeParentInChangeSet:!1}}construct(e,t){const n=this;n.configuredAlign="align"in e,n.configuredEditor="editor"in e,super.construct(...arguments);const{grid:i}=t;"sum"===n.function&&(n.function="sumChildren"),i&&(n.store=i.store)}set store(e){const t=this,n={update:"onRecordUpdate",thisObj:t,prio:1e3},i=t._store;if(e!==i){i&&i.un(n),t._store=e;const{modelClass:r}=e,s=r.fieldMap[t.field];s&&"number"===s.type&&(t.configuredAlign||(t.align="end"),t.configuredEditor||(t.editor="number")),e.ion(n)}}canEdit(e){return e.isLeaf}get store(){return this._store}sumChildren(...e){let t=0;for(let n=0,{length:i}=e;n<i;n++)t+=parseFloat(e[n]||0,10);return t}avg(...e){let t=0;const{length:n}=e;for(let i=0;i<n;i++)t+=parseFloat(e[i]||0,10);return t/n}onRecordUpdate({record:e,changes:t}){const n=this,{rowManager:i}=n.grid;n.field in t&&e.isLeaf&&e.bubble((e=>{const t=i.getRowFor(e);if(t){const e=t.getCell(n.field);e&&t.renderCell(e)}}),!0)}getRawValue(e){var t;let n;const i=this,{field:r}=i;if(null!==(t=e.children)&&void 0!==t&&t.length){const t=i.function,s="string"==typeof t&&"function"==typeof Math[t],{handler:o,thisObj:a}=s?{handler:Math[t],thisObj:Math}:i.resolveCallback(t);n=o.apply(a,e.children.map((e=>i.getRawValue(e)))),i.includeParentInChangeSet?e.set(r,n,!0):e.setData(r,n)}else n=e.getValue(r);return n}canFillValue({record:e}){return e.isLeaf}}Mf.registerColumnType(kf,!0),kf.exposeProperties(),kf._$name="AggregateColumn";const Ff=({source:e,value:t,userAction:n})=>{n&&e.cellInfo.record.setValue(e.name,t)};class Pf extends Rf{static $name="WidgetColumn";static type="widget";static fields=["widgets","disableRendererWarning"];static get defaults(){return{filterable:!1,sortable:!1,editor:!1,searchable:!1,fitMode:!1,alwaysClearCell:!1}}construct(e){e.disableRendererWarning||(e.renderer&&(e.afterRenderCell=e.renderer,delete e.renderer,G.deprecate("grid","7.0.0","Using deprecated `renderer` with WidgetColumn, use `afterRenderCell` callback instead.")),this.renderer&&this.renderer!==this.defaultRenderer&&(e.afterRenderCell=this.renderer,this.renderer=this.defaultRenderer,G.deprecate("grid","7.0.0","Using deprecated `renderer` with WidgetColumn, use `afterRenderCell` callback instead."))),super.construct(...arguments);const t=this,{grid:n}=t;n&&(n.widgetColumnCache?t.widgetColumnCache=n.widgetColumnCache:(t.widgetColumnCache=n.widgetColumnCache=new Map,n.ion({removeRows:"onRemoveGridRows",thisObj:this})))}onRemoveGridRows({rows:e}){e.forEach((({columnWidgets:e})=>{e&&(this.freeWidgets([...e.values()].flat()),e.clear())}))}freeWidgets(e){null==e||e.forEach((e=>{var t;const{widgetColumnCache:n}=this,{column:i}=e.cellInfo,r=`${i.id}-${e.widgetColumnIndex}`;null===(t=i.onAfterWidgetDerendered)||void 0===t||t.call(i,e),e.cellInfo=e.__boundRecordId=e.owner=null,e.element.remove(),(n.get(r)||n.set(r,[]).get(r)).push(e)})),e.length=0}freeColumnWidgets(){const{id:e}=this;this.grid.rowManager.forEach((t=>{var n;const i=null===(n=t.columnWidgets)||void 0===n?void 0:n.get(e);null!=i&&i.length&&this.freeWidgets(i)}))}hide(){this.freeColumnWidgets(),super.hide(...arguments)}getWidget(e,t){var n;const i=this,{grid:r,widgetColumnCache:s}=i,o=`${t.column.id}-${e.widgetColumnIndex}`,a=s.get(o)||s.set(o,[]).get(o);let l,{length:c}=a;return c?(l=a[--c],delete l.onBeforeDestroy,a.length=c,e.owner=r,Tc.reconfigure(l,e)):(i.onBeforeWidgetCreate(e,t),e.recomposeAsync=!1,e.owner=r,l=Tc.create(e),i.onAfterWidgetCreate(l,t),l.name&&l.ion({change:Ff})),null===(n=i.onBeforeWidgetRender)||void 0===n||n.call(i,l),l}doDestroy(){this.grid.isDestroying?([...this.widgetColumnCache.values()].flat().forEach((e=>e.destroy())),this.widgetColumnCache.clear()):this.freeColumnWidgets(),super.doDestroy()}updateReadOnly(e){this.grid.rowManager.forEach((t=>{var n;null===(n=t.columnWidgets)||void 0===n||null===(n=n.get(this.id))||void 0===n||n.forEach((t=>{t.cellInfo.record.readOnly||(t.readOnly=e)}))}))}defaultRenderer(e){const t=this,{grid:n}=t,{cellElement:i,column:r,record:s,row:o,isExport:a}=e,{widgets:l}=r;if(!a&&l){const a=o.columnWidgets||(o.columnWidgets=new Map),l=a.get(t.id);[...i.childNodes].forEach((e=>{var t;null!==(t=e.classList)&&void 0!==t&&t.contains("b-widget")||e.remove()})),e.widgets=r.widgets.map(((o,a)=>{var c,d;o.widgetColumnIndex=a;const u=(null==l?void 0:l[a])||t.getWidget(o,e);if(u.cellInfo=e,u.element.isConnected||(u.rendered?i.appendChild(u.element):u.render(i)),t.meta.isSelectionColumn||(u.readOnly=n.readOnly||s.readOnly||t.readOnly),!1!==(null===(c=t.onBeforeWidgetSetValue)||void 0===c?void 0:c.call(t,u,e))){const t=o.valueProperty||"value"in u&&"value"||u.defaultBindProperty;if(t&&(!r.noFieldSpecified&&1===r.widgets.length||u.name)){const n=u.name?s.getValue(u.name):e.value;"object"==typeof n&&u.__boundRecordId!==s.id&&(u[`_${t}`]=NaN),u.suspendEvents(),u[t]=n,u.resumeEvents(),u.__boundRecordId=s.id}}return null===(d=t.onAfterWidgetSetValue)||void 0===d||d.call(t,u,e),u})),a.set(t.id,e.widgets)}if(!l)return""}onBeforeWidgetCreate(e,t){}onAfterWidgetCreate(e,t){}resizeToFitContent(){}}Mf.registerColumnType(Pf),Pf.exposeProperties(),Pf._$name="WidgetColumn";class Of extends Pf{static $name="CheckColumn";static type="check";static fields=["checkCls","showCheckAll","onAfterWidgetSetValue","onBeforeWidgetSetValue","callOnFunctions","onBeforeToggle","onToggle","onToggleAll"];static defaults={align:"center",checkCls:null,showCheckAll:!1,sortable:!0,filterable:!0,minWidth:30,widgets:[{type:"checkbox",valueProperty:"checked"}]};construct(e,t){super.construct(...arguments);const n=this;if(n.widgets[0].cls=n.checkCls,Object.assign(n,{externalHeaderRenderer:n.headerRenderer,externalOnBeforeWidgetSetValue:n.onBeforeWidgetSetValue,externalOnAfterWidgetSetValue:n.onAfterWidgetSetValue}),n.setData({onBeforeWidgetSetValue:n.internalOnBeforeWidgetSetValue,onAfterWidgetSetValue:n.internalOnAfterWidgetSetValue,headerRenderer:n.internalHeaderRenderer}),!n.meta.isSelectionColumn){var i;const e=null===(i=n.grid)||void 0===i?void 0:i.store.modelClass;n.field?!e||"boolean"==typeof n[n.field]||e.fieldMap[n.field]||n.constructor.suppressNoModelFieldWarning||(console.warn(n.$$name+" is configured with a field, but this is not part of your Model `fields` collection."),e.addField({name:n.field,type:"boolean"})):console.warn("CheckColumn MUST be configured with a field, otherwise the checked state will not be persistent. Widgets are recycled and reused")}}doDestroy(){var e;null===(e=this.headerCheckbox)||void 0===e||e.destroy(),super.doDestroy()}internalHeaderRenderer({headerElement:e,column:t}){let n;return e.classList.add("b-check-header"),t.showCheckAll?(e.classList.add("b-check-header-with-checkbox"),t.headerCheckbox?e.appendChild(t.headerCheckbox.element):t.headerCheckbox=new um({appendTo:e,owner:this.grid,ariaLabel:"L{Checkbox.toggleSelection}",internalListeners:{change:"onCheckAllChange",thisObj:t}})):n=t.headerText,n=t.externalHeaderRenderer?t.externalHeaderRenderer.call(this,...arguments):n,t.showCheckAll?void 0:n}updateCheckAllState(e){this.headerCheckbox&&(this.headerCheckbox.suspendEvents(),this.headerCheckbox.checked=e,this.headerCheckbox.resumeEvents())}onCheckAllChange({checked:e}){const t=this;if(t.field){const{store:n}=t.grid;n.beginBatch(),n.forEach((n=>t.updateRecord(n,t.field,e))),n.endBatch()}t.trigger("toggleAll",{checked:e})}defaultRenderer(e){var t;const{value:n,isExport:i,record:r}=e,s=super.defaultRenderer(e),o=null===(t=e.widgets)||void 0===t?void 0:t[0];return i?null!=s?s:null==n?"":n:(o.readOnly=this.readOnly||r.readOnly&&!this.meta.isSelectionColumn,n?o.input.setAttribute("checked",!0):o.input.removeAttribute("checked"),s)}onBeforeWidgetRender(e,t){e.ion({beforeChange:"onBeforeCheckboxChange",change:"onCheckboxChange",thisObj:this})}onAfterWidgetDerendered(e,t){e.un({beforeChange:"onBeforeCheckboxChange",change:"onCheckboxChange",thisObj:this})}internalOnBeforeWidgetSetValue(e,{cellElement:t}){var n;t.widget=e,e.record=e.cellInfo.record,null===(n=this.externalOnBeforeWidgetSetValue)||void 0===n||n.call(this,...arguments)}internalOnAfterWidgetSetValue(e){var t;null===(t=this.externalOnAfterWidgetSetValue)||void 0===t||t.call(this,...arguments)}onBeforeCheckboxChange({source:e,checked:t,userAction:n}){const i=this,{grid:r}=i,{record:s}=e.cellInfo;return!(n&&i.field&&(!r.features.cellEdit||r.features.cellEdit.disabled)||i.meta.isSelectionColumn&&!r.isSelectable(s)&&t)&&i.trigger("beforeToggle",{record:s,checked:t})}onCheckboxChange({source:e,checked:t}){const n=this,{record:i}=e.cellInfo,{field:r}=n;r&&(n.updateRecord(i,r,t),t?n.updateCheckAllState(n.grid.store.every((e=>e[r]),null,!0)):n.updateCheckAllState(!1)),n.trigger("toggle",{record:i,checked:t,checkbox:e})}updateRecord(e,t,n){e.setValue(t,n)}onCellKeyDown({event:e,cellElement:t,record:n}){if(" "===e.key){const{target:i}=e,r=t.widget;i.matches(".b-grid-cell")&&!(null!=n&&n.readOnly||r.disabled||r.readOnly)&&(null==r||r.toggle(),e.preventDefault(),e.handled=!0)}}getCurrentConfig(e){const t=super.getCurrentConfig(e);return delete t.onBeforeWidgetSetValue,delete t.onAfterWidgetSetValue,this.externalOnBeforeWidgetSetValue&&(t.onBeforeWidgetSetValue=this.externalOnBeforeWidgetSetValue),this.externalOnAfterWidgetSetValue&&(t.onAfterWidgetSetValue=this.externalOnAfterWidgetSetValue),t}}Mf.registerColumnType(Of,!0),Of._$name="CheckColumn";class Lf extends Rf{static $name="ColorColumn";static type="color";static fields=[{name:"colorEditorType",defaultValue:"colorpicker"},"colors",{name:"addNoColorItem",defaultValue:!0}];static defaults={align:"center",editor:null};construct(){var e;super.construct(...arguments);const t=this,{grid:n}=t;t.menu=new Su({owner:n,rootElement:n.rootElement,autoShow:!1,align:"t50-b50",anchor:!0,internalListeners:{hide(){t.picker.navigator.activeItem=null,delete t._editingRecord}},items:[Object.assign({type:t.colorEditorType,ref:"list",addNoColorItem:t.addNoColorItem,colorSelected({color:e}){var n;null===(n=t._editingRecord)||void 0===n||n.set(t.field,e),t.menu.hide()}},null!==(e=t.colors)&&void 0!==e&&e.length?{colors:t.colors}:{})]})}applyValue(e,t,n){if(!this.isConstructing){const{picker:e}=this;"colors"===t?e.colors=n:"addNoColorItem"===t&&(e.addNoColorItem=n)}super.applyValue(...arguments)}get picker(){return this.menu.widgetMap.list}defaultRenderer({value:e}){let t="b-empty",n=e;if(e){const i=this.picker.getColorClassName(e);i?(t=i,n=null):t=""}return{className:"b-color-cell-inner "+t,style:{backgroundColor:n},"data-btip":e}}onCellClick({grid:e,record:t,target:n}){if(n.classList.contains("b-color-cell-inner")&&!this.readOnly&&!e.readOnly&&!t.isSpecialRow&&!t.readOnly){const{picker:e,menu:i}=this,r=t.get(this.field);this._editingRecord=t,e.deselectAll(),e.select(r),e.refresh(),i.showBy(n)}}}Mf.registerColumnType(Lf),Lf._$name="ColorColumn";class $f extends Rf{static $name="DateColumn";static type="date";static fieldType="date";static fields=["format","pickerFormat","step","min","max","renderer"];static get defaults(){return{format:"L",step:1,minWidth:85,filterType:"date"}}construct(e={},t){if(super.construct(e,t),this.grid){const{field:t}=this,{store:n}=this.grid,{modelClass:i}=n,r=t&&i.getFieldDefinition(t);if(r&&!r.isDateDataField){console.warn(`DateColumn expects the \`type\` of the model field \`${t}\` to be of type \`date\``);const s=i.addField({...r.getCurrentConfig(),type:"date",["format"in e?"format":void 0]:this.format});n.forEach((e=>e.data[r.dataSource]=s.convert(e[t])))}}}defaultRenderer({value:e}){return e?this.formatValue(e):""}groupRenderer({cellElement:e,groupRowFor:t}){e.innerHTML=this.formatValue(t)}formatValue(e){return"string"==typeof e&&(e=fr.parse(e,this.format||void 0)),fr.format(e,this.format||void 0)}set format(e){const{editor:t}=this.data;this.set("format",e),t&&(t.format=e)}get format(){return this.get("format")}get defaultEditor(){const e=this,{min:t,max:n,step:i,format:r}=e;return{name:e.field,type:"date",calendarContainerCls:"b-grid-cell-editor-related",weekStartDay:e.grid.weekStartDay,format:r,max:n,min:t,step:i}}}Mf.registerColumnType($f,!0),$f.exposeProperties(),$f._$name="DateColumn";class _f extends Af{circleHeightPercentage=.75;static type="percent";static fields=["showValue","lowThreshold","showCircle","mode"];static defaults={min:0,max:100,step:1,align:null,showCircle:!1,mode:"bar",showValue:!1,lowThreshold:0,htmlEncode:!1,searchable:!1,summaryRenderer:({sum:e})=>`${e}%`,fitMode:!1};construct(){super.construct(...arguments),this.showCircle&&(G.deprecate("core","7.0.0","PercentColumn `showCircle` is deprecated, in favor of `mode`"),this.mode="circle")}defaultRenderer({value:e,record:t,isExport:n}){var i;e=e||0;const r=this,s=r.formatValue(e,t)||e;if(n)return s;if("number"===r.mode)return s+"%";const{min:o,max:a}=r;if("circle"===r.mode){var l;const n=Math.round(r.circleHeightPercentage*r.grid.rowHeight)+"px";return{tabIndex:0,role:"progressbar","aria-valuemin":o,"aria-valuemax":a,"aria-valuenow":e,"aria-label":null===(l=r.formatAriaLabel)||void 0===l?void 0:l.call(r,e,t),className:{"b-percentdone-circle":1,"b-empty":0===e,"b-full":100===e,"b-over":e>100},style:{height:n,width:n,"--grid-percent-circle-angle":e/100+"turn"},dataset:{value:s}}}return{className:"b-percent-bar-outer",role:"progressbar","aria-valuemin":o,"aria-valuemax":a,"aria-valuenow":e,"aria-label":null===(i=r.formatAriaLabel)||void 0===i?void 0:i.call(r,e,t),tabIndex:0,children:[{tag:"div",className:{"b-percent-bar":1,"b-zero":0===e,"b-low":e<r.lowThreshold,"b-full":100===e,"b-over":e>100},style:{width:e+"%"},children:[r.showValue?{tag:"span",text:s+"%"}:void 0]}]}}resizeToFitContent(){if("number"===this.mode)return super.resizeToFitContent(...arguments)}get align(){const e=this.get("align"),{mode:t}=this;return e||("number"===t?"end":"circle"===t?"center":"start")}set align(e){this.set("align",e)}get htmlEncode(){return"number"===this.mode}get internalCellCls(){return"bar"===this.mode?"b-percent-bar-cell":""}}_f.sum="average",Mf.registerColumnType(_f,!0),_f._$name="PercentColumn";class jf extends Af{static $name="RatingColumn";static type="rating";static fieldType="number";static fields=["emptyIcon","filledIcon","editable"];static get defaults(){return{min:0,max:5,emptyIcon:"b-icon b-icon-star",filledIcon:"b-icon b-icon-star",editable:!0,filterType:"number",searchable:!1,width:"11.2em",htmlEncode:!1,minWidth:"11.2em",editor:!1,fitMode:"value"}}defaultRenderer({value:e,isExport:t}){return t?"★".repeat(e):{className:{"b-rating-cell-inner":1,"b-not-editable":!this.editable},children:$e.populate(this.max,(t=>{const n=t<e;return{tag:"i",className:{"b-rating-icon":!0,"b-filled":n,"b-empty":!n,[n?this.filledIcon:this.emptyIcon]:!0}}}))}}onCellClick({grid:e,column:t,record:n,target:i,event:r}){if(i.classList.contains("b-rating-icon")&&!e.readOnly&&t.editable){let e=[].indexOf.call(i.parentNode.childNodes,i);i.classList.contains("b-filled")&&(r.metaKey||r.shiftKey)&&(e-=1),1===n.getValue(t.field)&&0===e&&(e=-1),n.set(t.field,e+1)}}}Mf.registerColumnType(jf,!0),jf.exposeProperties(),jf._$name="RatingColumn";class Bf extends Rf{static $name="RowNumberColumn";static type="rownumber";static get defaults(){return{groupable:!1,sortable:!1,filterable:!1,searchable:!1,resizable:!1,draggable:!1,mergeable:!1,minWidth:50,width:50,align:"right",text:"#",editor:!1,readOnly:!0}}construct(e){super.construct(...arguments);const t=this,{grid:n}=t;t.internalCellCls="b-row-number-cell",t.externalHeaderRenderer=t.headerRenderer,t.setData("headerRenderer",t.internalHeaderRenderer),n&&(n.ion({bindStore:"bindStore",thisObj:t}),t.bindStore({store:n.store,initial:!0}),n.store.count&&!n.rendered&&n.ion({paint:"resizeToFitContent",thisObj:t,once:!0}))}get groupHeaderReserved(){return!0}bindStore({store:e,initial:t}){const n=this;n.detachListeners("grid"),e.ion({name:"grid",[`change${n.grid.asyncEventSuffix}`]:"onStoreChange",thisObj:n}),t||n.resizeToFitContent()||n.measureOnRender()}onStoreChange({action:e,isMove:t}){if("dataset"===e||"add"===e||"remove"===e||"removeall"===e){if("remove"===e&&t)return;const n=this.resizeToFitContent();"dataset"===e&&!n&&this.grid.store.count&&this.measureOnRender()}}measureOnRender(){this.grid.rowManager.ion({renderDone(){this.resizeToFitContent()},once:!0,thisObj:this})}defaultRenderer({record:e,grid:t}){var n;let i=e.isSpecialRow?"":t.store.indexOf(e,!0)+1;var r;null!==(n=t.splitFrom)&&void 0!==n&&n.isLockedRows&&(i+=(null===(r=t.splitFrom.features.lockRows)||void 0===r?void 0:r.numberOfLockedRows)??0);return i}resizeToFitContent(){var e;const t=this,n=null===(e=t.grid.features.lockRows)||void 0===e?void 0:e.subViews,i=(null==n?void 0:n[1])===t.grid?n[0]:t.grid,{element:r}=i,{store:s}=i,{count:o}=s;if(o&&!t.hidden){const e=r.querySelector(`.b-grid-cell[data-column-id="${t.id}"]`);if(e){const n=e.isConnected?parseInt(Wn.getStyleValue(e,"padding-left")):t._cachedCellPadding||0,i=Wn.measureText(o,e);return t.width=Math.max(t.minWidth,i+2*n),t._cachedCellPadding=n,!0}}return!1}set flex(e){}internalHeaderRenderer({headerElement:e,column:t}){var n;return e.classList.add("b-rownumber-header"),(null===(n=t.externalHeaderRenderer)||void 0===n?void 0:n.call(this,...arguments))||t.headerText}}Mf.registerColumnType(Bf,!0),Bf._$name="RowNumberColumn";class Hf extends Rf{static type="template";static fields=["template"];static get defaults(){return{htmlEncode:!1}}constructor(e,t){super(...arguments);if(!this.template)throw new Error("TemplateColumn needs a template");if("function"!=typeof this.template)throw new Error("TemplateColumn.template must be a function")}defaultRenderer(e){if(!e.record.isSpecialRow)return this.template({value:e.value,record:e.record,field:this.field})}}Mf.registerColumnType(Hf,!0),Hf.exposeProperties(),Hf._$name="TemplateColumn";class Vf extends Rf{static $name="TimeColumn";static type="time";static fieldType="date";static fields=["format"];static get defaults(){return{format:"LT",minWidth:140,filterType:"time"}}defaultRenderer({value:e}){return e?this.formatValue(e):""}groupRenderer({cellElement:e,groupRowFor:t}){e.innerHTML=this.formatValue(t)}formatValue(e){return"string"==typeof e&&(e=fr.parse(e,this.format)),fr.format(e,this.format)}set format(e){const{editor:t}=this;this.set("format",e),t&&(t.format=e)}get format(){return this.get("format")}get defaultEditor(){return{name:this.field,type:"time",format:this.format}}}Mf.registerColumnType(Vf,!0),Vf.exposeProperties(),Vf._$name="TimeColumn";class zf extends Rf{static $name="TreeColumn";static type="tree";static get defaults(){return{tree:!0,hideable:!1,minWidth:150}}static get fields(){return[{name:"expandIconCls",defaultValue:"b-icon b-icon-tree-expand"},{name:"collapseIconCls",defaultValue:"b-icon b-icon-tree-collapse"},{name:"collapsedFolderIconCls"},{name:"expandedFolderIconCls"},{name:"indentSize",defaultValue:1.7},{name:"leafIconCls",defaultValue:"b-icon b-icon-tree-leaf"},{name:"editTargetSelector",defaultValue:".b-tree-cell-value"},"renderer"]}construct(e,t,...n){super.construct(e,t,...n);const i=this;i.shouldHtmlEncode=i.htmlEncode,i.setData("htmlEncode",!1);const{renderer:r}=i;r&&(i.originalRenderer=r),i.renderer=i.treeRenderer.bind(i)}treeRenderer(e){var t;const n=this,{grid:i,cellElement:r,row:s,record:o,isExport:a}=e,l=o.instanceMeta(i.store),c=!o.isLeaf&&l.collapsed,d={className:"b-tree-cell-value"},u=[d],h={className:{"b-tree-cell-inner":1},tag:o.href?"a":"div",href:o.href,target:o.target,children:u};let g,m,{value:p}=e,f=n;const v=i.isTreeGrouped&&!o.isLeaf&&i.features.treeGroup.parentRenderer;if(n.originalRenderer||v){var y;let t;if(v){var b;if(o.field)if(f=i.columns.get(o.field),f)p=f.isWidgetColumn?p:(null===(b=f===n?f.originalRenderer:f.renderer)||void 0===b?void 0:b.call(f,{...e,column:f,value:o.name,isTreeGroup:!0}))??o.name;else p=o.name;t=i.features.treeGroup.parentRenderer({...e,field:o.field,value:p,column:f,record:o.firstGroupChild,grid:i})}else t=n.originalRenderer(e);const s=null===(y=i.hasFrameworkRenderer)||void 0===y?void 0:y.call(i,{cellContent:t,renderingColumn:f});g="object"==typeof t&&!s,p=s?"":!1===t?r.innerHTML:t,e.rendererHtml=t}if(g||(p=String(p??"")),a)return p;if(o.isLeaf)r.classList.add("b-tree-leaf-cell"),m=e.iconCls||o.iconCls||n.leafIconCls;else{var C;const t=!o.isExpanded(i.store),a=t?n.expandIconCls:n.collapseIconCls,c=t?n.collapsedFolderIconCls:n.expandedFolderIconCls;r.classList.add("b-tree-parent-cell"),s.toggleCls("b-loading-children",Boolean(l.isLoadingChildren)),u.unshift({tag:"i",className:{"b-tree-expander":1,[a]:1,"b-empty-parent":!(l.isLoadingChildren||!0===o.children||null!==(C=o.children)&&void 0!==C&&C.length)}}),o.meta.hasIcon=m=e.iconCls||o.iconCls||c}if(m&&u.splice(u.length-1,0,{tag:"i",className:{"b-tree-icon":1,[m]:1}}),s.isRow&&!o.isLeaf)if(s.setAttribute("aria-expanded",!c),c)s.removeAttribute("aria-owns");else for(const e in i.subGrids){var S,D;const t=s.elements[e];Wn.setAttributes(t,{"aria-owns":null!==(S=o.children)&&void 0!==S&&S.length?null===(D=o.children)||void 0===D?void 0:D.map((t=>`${i.id}-${e}-${t.id}`)).join(" "):null})}Array.isArray(p)?d.children=p:g?Object.assign(d,p):null!==(t=f)&&void 0!==t&&t.shouldHtmlEncode||!p.includes("<")?(h.className["b-text-value"]=1,d.text=p):d.html=p;let w=o.childLevel*n.indentSize;var E;o.isLeaf?w+=null!==(E=o.parent)&&void 0!==E&&E.meta.hasIcon?2.2:m?.5:.4:w+=m?-.15:0;return h.style=`padding-inline-start:${w}em`,h}getCurrentConfig(e){const t=super.getCurrentConfig(e);return t.renderer=this.originalRenderer,t}}Mf.registerColumnType(zf,!0),zf.exposeProperties(),zf._$name="TreeColumn";class Nf extends ws{static get fields(){return[{name:"iconCls",internal:!0},{name:"cls",internal:!0},{name:"rowHeight",internal:!0},{name:"href",internal:!0},{name:"target",internal:!0},{name:"fixed",type:"boolean",internal:!0}]}}Nf.exposeProperties(),Nf._$name="GridRowModel";class Wf extends(xi.mixin(Dh)){static configurable={copyOnly:null,keyMap:{"Ctrl+C":"copy","Ctrl+X":"cut","Ctrl+V":"paste"},useNativeClipboard:!1,toCopyString:null,toPasteValue:null,emptyValueChar:" ",dateFormat:"lll",generateNewName(e,t,n=this.client.store){const{nameField:i}=this;let r=e.getValue(i),s=2;(null==t?void 0:t.meta.generatedName)===r&&(r=t.meta.originalName);let o=r;for(;n.findRecord(i,o);)o=`${r} - ${s}`,s+=1;return e.meta.generatedName=o,e.meta.originalName=r,o}};get clipboardRecords(){return this.clipboardData||[]}cellsToString(e){const t=this;let n=0,i=0,r="";e.sort(((e,t)=>e.rowIndex===t.rowIndex?e.columnIndex-t.columnIndex:e.rowIndex-t.rowIndex));for(const l of e){var s,o;const{record:e,_column:c,rowIndex:d,columnIndex:u}=l;d>n?(r.length>0&&(r+="\n".repeat(d-n)),n=d,i=u):u>i&&(r.length>0&&(r+="\t".repeat(u-i)),i=u);let h=null==c||null===(s=c.toClipboardString)||void 0===s?void 0:s.call(c,l);var a;if(void 0===h)if(h=e.getValue(c.field),h instanceof Date)h=fr.format(h,t.dateFormat);else h=null===(a=h)||void 0===a?void 0:a.toString();t.toCopyString&&(h=t.toCopyString({currentValue:h,column:c,record:e})),h=null===(o=h)||void 0===o?void 0:o.replace(/[\n\t]/," "),r+=h||t.emptyValueChar}return r}setFromStringData(e,t=!1,n=this.client.store,i){var r;const s=this,{client:o}=s,{columns:a,_shiftSelectRange:l}=o,c=new Set,d=s.stringAs2dArray(e),u=null===(r=o.selectedCells)||void 0===r?void 0:r[0],h=[],g=[];if(!t&&null!=l&&l.some((e=>e.equals(u)))){const e=s.cellSelectorsAs2dArray(l);if((null==e?void 0:e.length)%d.length==0&&e.columnCount%d.columnCount==0)for(let t=0;t<e.length;t+=d.length)for(let n=0;n<e.columnCount;n+=d.columnCount)h.push(e[t][n])}h.length||h.push(u);for(const e of h)for(let r=0;r<d.length;r++){const l=d[r],u=t?new n.modelClass:n.getAt(e.rowIndex+r);if(u&&!u.readOnly){for(let n=0;n<l.length;n++){const r=i?null:a.visibleColumns[t?n:e.columnIndex+n],c=(null==r?void 0:r.field)||(null==i?void 0:i[n]);let d=l[n];if(c&&d&&(null==r||!r.readOnly)){var m;if(d===s.emptyValueChar&&(d=null),null!=r&&r.fromClipboardString&&(d=r.fromClipboardString({string:d,record:u})),s.toPasteValue&&(d=s.toPasteValue({currentValue:d,record:u,column:r,field:c})),"string"==typeof d&&null!==(m=u.getFieldDefinition(c))&&void 0!==m&&m.isDateDataField){const e=fr.parse(d,s.dateFormat);isNaN(e.getTime())||(d=e)}u.set(c,d,!1,!1,!1,!0),r&&g.push(o.normalizeCellContext({column:r,record:u}))}}c.add(u)}}return{modifiedRecords:[...c],targetCells:g}}cellSelectorsAs2dArray(e){const t=[];let n,i=null;for(const r of e)r.id!==i&&(i=r.id,n=[],t.push(n)),n.push(r);return t.columnCount=t[0].length,!t.some((e=>e.length!==t.columnCount))&&t}stringAs2dArray(e){const t=[],n=e.split(/\r\n|(?!\r\n)[\n-\r\x85\u2028\u2029]/).filter((e=>e.length));for(const e of n){const n=e.split("\t");if(t.columnCount&&n.length!==t.columnCount)return!1;t.columnCount=n.length,t.push(n)}return t}}Wf._$name="CopyPasteBase";const Uf=new Map,Gf=new Map,Yf="Grid",qf={Grid:"GridBase",Scheduler:"SchedulerBase",SchedulerPro:"SchedulerProBase",Gantt:"GanttBase"},Kf=/\$\d+$/;class Xf{static registerFeature(e,t=!1,n=null,i=null){i=(i=H.uncapitalize(i||Object.prototype.hasOwnProperty.call(e,"$name")&&e.$$name||e.name)).replace(Kf,""),Array.isArray(n)||(n=[n||Yf]),n.forEach((n=>{const r=qf[n]||n,s=Uf.get(r)||new Map,o=Gf.get(r)||new Map;s.set(i,e),o.set(e,t),Uf.set(r,s),Gf.set(r,o)}))}static getTypeNameFeatures(e=Yf){const t=qf[e]||e,n=Uf.get(t),i={};return n&&n.forEach(((e,t)=>i[t]=e)),i}static getTypeNameDefaultFeatures(e=Yf){const t=qf[e]||e,n=Uf.get(t),i=Gf.get(t),r={};return n&&i&&n.forEach(((e,t)=>{i.get(e)&&(r[t]=e)})),r}static getInstanceFeatures(e){return e.$meta.names.reduce(((e,t)=>Object.assign(e,this.getTypeNameFeatures(t))),{})}static getInstanceDefaultFeatures(e){return e.$meta.names.reduce(((e,t)=>Object.entries(this.getTypeNameFeatures(t)).reduce(((e,[n,i])=>(this.isDefaultFeatureForTypeName(i,t)?e[n]=i:delete e[n],e)),e)),{})}static isDefaultFeatureForTypeName(e,t=Yf){const n=qf[t]||t,i=Gf.get(n);return i&&i.get(e)||!1}static isDefaultFeatureForInstance(e,t){const n=t.$meta.names.slice().reverse();let i=null;for(let t=0,r=n.length;t<r&&null===i;++t){const r=Gf.get(n[t]);r&&r.has(e)&&(i=r.get(e))}return i||!1}static reset(){Uf.clear(),Gf.clear()}}const Zf={cut:1,copy:1,paste:1};class Jf extends Wf{static $name="CellCopyPaste";static get pluginConfig(){return{chain:["populateCellMenu","afterSelectionModeChange"]}}static configurable={useNativeClipboard:!G.isTestEnv,copyText:"L{copy}",cutText:"L{cut}",pasteText:"L{paste}",allowedDataSources:"none"};afterConstruct(){super.afterConstruct(),this.afterSelectionModeChange()}afterSelectionModeChange(){const e=this;e.client.selectionMode.cell?e._disabledBySelectionMode&&(e.disabled=!1,delete e._disabledBySelectionMode):e.disabled=!0}entityName="cell";set copyOnly(e){this._copyOnly=e}get copyOnly(){var e;return null==this._copyOnly?!(null!==(e=this.client.features.cellEdit)&&void 0!==e&&e.enabled):Boolean(this._copyOnly)}get canCopy(){var e;const{client:t}=this;return Boolean(!this.disabled&&t.selectedCells.length&&(!t._selectedRows.length||(null===(e=t.features.rowCopyPaste)||void 0===e?void 0:e.disabled)||t.focusedCell&&t.isCellSelected(t.focusedCell)))}get canCutPaste(){var e;return this.canCopy&&!this.copyOnly&&!(null!==(e=this.client.features.cellEdit)&&void 0!==e&&e.isEditing)&&!this.client.readOnly}isActionAvailable({actionName:e}){if(Zf[e])return 0===globalThis.getSelection().toString().length&&this.canCopy&&("copy"===e||this.canCutPaste)}async cut(){await this.copy(!0)}async copy(e=!1){"boolean"!=typeof e&&(e=!1);const t=this,{selectedCells:n}=t.client,i=e?n.filter((e=>{var t;return!(null!==(t=e.record)&&void 0!==t&&t.readOnly)})):n;if(i){if(e?!t.canCutPaste:!t.canCopy)return;const n=t.cellsToString(i);if(void 0===await t.writeToClipboard(n,e,{cells:i}))return;if(!0===e)for(const e of i){const{column:t,record:n}=e;if(!t.readOnly){let i=null;t.fromClipboardString&&(i=t.fromClipboardString({string:i,record:n})),e.record.set(e.column.field,i)}}t.client.trigger("copy",{cells:i,copiedDataString:n,isCut:e,entityName:t.entityName})}}async beforeCopy({data:e,isCut:t,cells:n}){return await this.client.trigger("beforeCopy",{cells:n,data:e,isCut:t,entityName:this.entityName})}async paste(){var e;const t=this,{client:n,entityName:i}=t,r=n.selectedCells[0];if(!t.canCutPaste||!r)return;const s=null===(e=await t.readFromClipboard({},!0))||void 0===e?void 0:e.data;if(!s)return;const{modifiedRecords:o,targetCells:a}=t.setFromStringData(s);1===n.selectedCells.length&&a.length>1&&n.selectCellRange(a[0],a[a.length-1]),n.trigger("paste",{clipboardData:s,targetCell:r,modifiedRecords:[...o],entityName:i})}async beforePaste({data:e}){return await this.client.trigger("beforePaste",{clipboardData:e,targetCell:this.client.selectedCell,entityName:this.entityName})}populateCellMenu({record:e,items:t}){const n=this;n.canCopy&&(t.cutCell={text:n.cutText,localeClass:n,icon:"b-icon b-icon-cut",weight:115,disabled:e.readOnly||!n.canCutPaste,onItem:()=>n.cut()},t.pasteCell={text:n.pasteText,localeClass:n,icon:"b-icon b-icon-paste",weight:120,disabled:e.readOnly||!n.canCutPaste||!1===n.hasClipboardData(),onItem:()=>n.paste()},t.copyCell={text:n.copyText,localeClass:n,cls:"b-separator",icon:"b-icon b-icon-copy",weight:110,onItem:()=>n.copy()})}}Jf._$name="CellCopyPaste",Xf.registerFeature(Jf);const Qf={finishAndEditNextRow:1,finishAndEditPrevRow:1,finishEditing:1,cancelEditing:1,finishAndEditNextCell:1,finishAndEditPrevCell:1},ev={...Qf,startEditing:1,finishAllSelected:1};class tv extends(Ir(xi)){static $name="CellEdit";static get defaultConfig(){return{autoSelect:!0,blurAction:"complete",continueEditingOnCellClick:!0,addNewAtEnd:null,addToCurrentParent:!1,autoEdit:null,editNextOnEnterPress:!0,editorClass:np,triggerEvent:"celldblclick",touchEditDelay:300,focusCellAnimationDuration:!1,multiEdit:!0,keyMap:{Enter:["startEditing","finishAndEditNextRow"],"Ctrl+Enter":["finishAllSelected","finishEditing"],"Shift+Enter":"finishAndEditPrevRow","Alt+Enter":"finishEditing",F2:["startEditing","finishEditing"],Escape:"cancelEditing",Tab:{handler:"finishAndEditNextCell",weight:100},"Shift+Tab":{handler:"finishAndEditPrevCell",weight:100}},ignoreCSSSelector:"button,.b-icon,.b-fa,svg",validateTapOut:null}}static get pluginConfig(){return{assign:["startEditing","finishEditing","cancelEditing"],before:["onElementKeyDown","onElementPointerUp"],chain:["onElementClick","bindStore"]}}construct(e,t){super.construct(e,t);const n=this,i={renderRows:"onGridRefreshed",cellClick:"onCellClick",thisObj:n};n.grid=e,"cellclick"!==n.triggerEvent&&(i[n.triggerEvent]="onTriggerEditEvent"),n.autoEdit&&!("editNextOnEnterPress"in t)&&(n.editNextOnEnterPress=!1),e.ion(i),e.rowManager.ion({changeTotalHeight:"onGridRefreshed",thisObj:n}),n.bindStore(e.store)}bindStore(e){this.detachListeners("store"),e.ion({name:"store",update:"onStoreUpdate",remove:"onStoreRemove",beforeSort:"onStoreBeforeSort",thisObj:this})}async confirm(e){let t=!0;return this.editorContext&&(kp.owner=this.editorContext.editor.inputField,e.rootElement=this.grid.rootElement,t=await kp.confirm(e),kp.owner=null),t===kp.yesButton}doDestroy(){this.grid.columns.allRecords.forEach((e=>{var t;null===(t=e._cellEditor)||void 0===t||t.destroy()})),super.doDestroy()}doDisable(e){e&&!this.isConfiguring&&this.cancelEditing(!0),super.doDisable(e)}set disabled(e){super.disabled=e}get disabled(){const{grid:e}=this;return Boolean(super.disabled||e.disabled||e.readOnly)}get isEditing(){return Boolean(this.editorContext)}get activeRecord(){var e;return(null===(e=this.editorCont