/*!
 *
 * Bryntum Scheduler Pro 6.0.5
 *
 * Copyright(c) 2024 Bryntum AB
 * https://bryntum.com/contact
 * https://bryntum.com/license
 *
 * Bryntum incorporates third-party code licensed under the MIT and Apache-2.0 licenses.
 * See the licenses below or visit https://bryntum.com/products/schedulerpro/docs/guide/SchedulerPro/licenses
 *
 * # Third Party Notices
 * 
 * Bryntum uses the following third party libraries:
 * 
 * * [Font Awesome 6 Free](https://fontawesome.com/license/free) (MIT/SIL OFL 1.1)
 * * [Roboto font](https://github.com/google/roboto) (Apache-2.0)
 * * [Styling Cross-Browser Compatible Range Inputs with Sass](https://github.com/darlanrod/input-range-sass) (MIT)
 * * [Tree Walker polyfill](https://github.com/Krinkle/dom-TreeWalker-polyfill) (MIT)
 * * [chronograph](https://github.com/bryntum/chronograph) (MIT)
 * * [later.js](https://github.com/bunkat/later) (MIT)
 * * [Monaco editor](https://microsoft.github.io/monaco-editor) (MIT)
 * * Map/Set polyfill to fix performance issues for Salesforce LWS (MIT)
 * 
 * Note: the **chronograph** and **later.js** libraries are used in Bryntum Scheduler Pro and Bryntum Gantt, but they are
 * listed for all Bryntum products since the distribution contains trial versions of the thin bundles for all other
 * products. TreeWalker is only used in the LWC bundle for Salesforce. Roboto font is only used in the material theme.
 * 
 * ## Font Awesome 6 Free
 * 
 * [Font Awesome Free 6 by @fontawesome](https://fontawesome.com/)
 * 
 * Font Awesome Free is free, open source, and GPL friendly. You can use it for commercial projects, open source projects,
 * or really almost whatever you want.
 * 
 * [Full Font Awesome Free license](https://fontawesome.com/license/free)
 * 
 * ## Roboto font
 * 
 * [Apache License Version 2.0, January 2004](https://www.apache.org/licenses/LICENSE-2.0)
 * 
 * TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 * 
 * 1. Definitions.
 * 
 * "License" shall mean the terms and conditions for use, reproduction, and distribution as defined by Sections 1 through 9
 * of this document.
 * 
 * "Licensor" shall mean the copyright owner or entity authorized by the copyright owner that is granting the License.
 * 
 * "Legal Entity" shall mean the union of the acting entity and all other entities that control, are controlled by, or are
 * under common control with that entity. For the purposes of this definition,
 * "control" means (i) the power, direct or indirect, to cause the direction or management of such entity, whether by
 * contract or otherwise, or (ii) ownership of fifty percent (50%) or more of the outstanding shares, or (iii) beneficial
 * ownership of such entity.
 * 
 * "You" (or "Your") shall mean an individual or Legal Entity exercising permissions granted by this License.
 * 
 * "Source" form shall mean the preferred form for making modifications, including but not limited to software source code,
 * documentation source, and configuration files.
 * 
 * "Object" form shall mean any form resulting from mechanical transformation or translation of a Source form, including
 * but not limited to compiled object code, generated documentation, and conversions to other media types.
 * 
 * "Work" shall mean the work of authorship, whether in Source or Object form, made available under the License, as
 * indicated by a copyright notice that is included in or attached to the work
 * (an example is provided in the Appendix below).
 * 
 * "Derivative Works" shall mean any work, whether in Source or Object form, that is based on (or derived from) the Work
 * and for which the editorial revisions, annotations, elaborations, or other modifications represent, as a whole, an
 * original work of authorship. For the purposes of this License, Derivative Works shall not include works that remain
 * separable from, or merely link (or bind by name) to the interfaces of, the Work and Derivative Works thereof.
 * 
 * "Contribution" shall mean any work of authorship, including the original version of the Work and any modifications or
 * additions to that Work or Derivative Works thereof, that is intentionally submitted to Licensor for inclusion in the
 * Work by the copyright owner or by an individual or Legal Entity authorized to submit on behalf of the copyright owner.
 * For the purposes of this definition, "submitted"
 * means any form of electronic, verbal, or written communication sent to the Licensor or its representatives, including
 * but not limited to communication on electronic mailing lists, source code control systems, and issue tracking systems
 * that are managed by, or on behalf of, the Licensor for the purpose of discussing and improving the Work, but excluding
 * communication that is conspicuously marked or otherwise designated in writing by the copyright owner as "Not a
 * Contribution."
 * 
 * "Contributor" shall mean Licensor and any individual or Legal Entity on behalf of whom a Contribution has been received
 * by Licensor and subsequently incorporated within the Work.
 * 
 * 2. Grant of Copyright License. Subject to the terms and conditions of this License, each Contributor hereby grants to
 *    You a perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable copyright license to reproduce,
 *    prepare Derivative Works of, publicly display, publicly perform, sublicense, and distribute the Work and such
 *    Derivative Works in Source or Object form.
 * 
 * 3. Grant of Patent License. Subject to the terms and conditions of this License, each Contributor hereby grants to You a
 *    perpetual, worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *    (except as stated in this section) patent license to make, have made, use, offer to sell, sell, import, and otherwise
 *    transfer the Work, where such license applies only to those patent claims licensable by such Contributor that are
 *    necessarily infringed by their Contribution(s) alone or by combination of their Contribution(s)
 *    with the Work to which such Contribution(s) was submitted. If You institute patent litigation against any entity (
 *    including a cross-claim or counterclaim in a lawsuit) alleging that the Work or a Contribution incorporated within
 *    the Work constitutes direct or contributory patent infringement, then any patent licenses granted to You under this
 *    License for that Work shall terminate as of the date such litigation is filed.
 * 
 * 4. Redistribution. You may reproduce and distribute copies of the Work or Derivative Works thereof in any medium, with
 *    or without modifications, and in Source or Object form, provided that You meet the following conditions:
 * 
 * (a) You must give any other recipients of the Work or Derivative Works a copy of this License; and
 * 
 * (b) You must cause any modified files to carry prominent notices stating that You changed the files; and
 * 
 * (c) You must retain, in the Source form of any Derivative Works that You distribute, all copyright, patent, trademark,
 * and attribution notices from the Source form of the Work, excluding those notices that do not pertain to any part of the
 * Derivative Works; and
 * 
 * (d) If the Work includes a "NOTICE" text file as part of its distribution, then any Derivative Works that You distribute
 * must include a readable copy of the attribution notices contained within such NOTICE file, excluding those notices that
 * do not pertain to any part of the Derivative Works, in at least one of the following places: within a NOTICE text file
 * distributed as part of the Derivative Works; within the Source form or documentation, if provided along with the
 * Derivative Works; or, within a display generated by the Derivative Works, if and wherever such third-party notices
 * normally appear. The contents of the NOTICE file are for informational purposes only and do not modify the License. You
 * may add Your own attribution notices within Derivative Works that You distribute, alongside or as an addendum to the
 * NOTICE text from the Work, provided that such additional attribution notices cannot be construed as modifying the
 * License.
 * 
 * You may add Your own copyright statement to Your modifications and may provide additional or different license terms and
 * conditions for use, reproduction, or distribution of Your modifications, or for any such Derivative Works as a whole,
 * provided Your use, reproduction, and distribution of the Work otherwise complies with the conditions stated in this
 * License.
 * 
 * 5. Submission of Contributions. Unless You explicitly state otherwise, any Contribution intentionally submitted for
 *    inclusion in the Work by You to the Licensor shall be under the terms and conditions of this License, without any
 *    additional terms or conditions. Notwithstanding the above, nothing herein shall supersede or modify the terms of any
 *    separate license agreement you may have executed with Licensor regarding such Contributions.
 * 
 * 6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product
 *    names of the Licensor, except as required for reasonable and customary use in describing the origin of the Work and
 *    reproducing the content of the NOTICE file.
 * 
 * 7. Disclaimer of Warranty. Unless required by applicable law or agreed to in writing, Licensor provides the Work (and
 *    each Contributor provides its Contributions) on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 *    either express or implied, including, without limitation, any warranties or conditions of TITLE, NON-INFRINGEMENT,
 *    MERCHANTABILITY, or FITNESS FOR A PARTICULAR PURPOSE. You are solely responsible for determining the appropriateness
 *    of using or redistributing the Work and assume any risks associated with Your exercise of permissions under this
 *    License.
 * 
 * 8. Limitation of Liability. In no event and under no legal theory, whether in tort (including negligence), contract, or
 *    otherwise, unless required by applicable law (such as deliberate and grossly negligent acts) or agreed to in writing,
 *    shall any Contributor be liable to You for damages, including any direct, indirect, special, incidental, or
 *    consequential damages of any character arising as a result of this License or out of the use or inability to use the
 *    Work (including but not limited to damages for loss of goodwill, work stoppage, computer failure or malfunction, or
 *    any and all other commercial damages or losses), even if such Contributor has been advised of the possibility of such
 *    damages.
 * 
 * 9. Accepting Warranty or Additional Liability. While redistributing the Work or Derivative Works thereof, You may choose
 *    to offer, and charge a fee for, acceptance of support, warranty, indemnity, or other liability obligations and/or
 *    rights consistent with this License. However, in accepting such obligations, You may act only on Your own behalf and
 *    on Your sole responsibility, not on behalf of any other Contributor, and only if You agree to indemnify, defend, and
 *    hold each Contributor harmless for any liability incurred by, or claims asserted against, such Contributor by reason
 *    of your accepting any such warranty or additional liability.
 * 
 * END OF TERMS AND CONDITIONS
 * 
 * APPENDIX: How to apply the Apache License to your work.
 * 
 * To apply the Apache License to your work, attach the following boilerplate notice, with the fields enclosed by
 * brackets "[]"
 * replaced with your own identifying information. (Don't include the brackets!)  The text should be enclosed in the
 * appropriate comment syntax for the file format. We also recommend that a file or class name and description of purpose
 * be included on the same "printed page" as the copyright notice for easier identification within third-party archives.
 * 
 * Copyright [yyyy] [name of copyright owner]
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 * 
 * [APACHE LICENSE, VERSION 2.0](http://www.apache.org/licenses/LICENSE-2.0)
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "
 * AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * ## Styling Cross-Browser Compatible Range Inputs with Sass
 * 
 * Github: [input-range-sass](https://github.com/darlanrod/input-range-sass)
 * 
 * Author: [Darlan Rod](https://github.com/darlanrod)
 * 
 * Version 1.4.1
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 Darlan Rod
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Tree Walker polyfill
 * 
 * The MIT License (MIT)
 * 
 * [Copyright 2013–2017 Timo Tijhof](https://github.com/Krinkle/dom-TreeWalker-polyfill)
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## chronograph
 * 
 * GitHub: [chronograph](https://github.com/bryntum/chronograph)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2023 Bryntum
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## later.js
 * 
 * GitHub: [later.js](https://github.com/bunkat/later)
 * 
 * The MIT License (MIT)
 * 
 * Copyright © 2013 BunKat
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Monaco editor
 * 
 * GitHub: [Monaco editor](https://microsoft.github.io/monaco-editor) (MIT)
 * 
 * The MIT License (MIT)
 * 
 * Copyright (c) 2016 - present Microsoft Corporation
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit
 * persons to whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the
 * Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * ## Map/Set polyfill to fix performance issues for Salesforce LWS
 * 
 * Copyright © 2024 Certinia Inc.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * 
 */
var n_=Object.defineProperty,s_=(i,e,t)=>e in i?n_(i,e,{enumerable:!0,configurable:!0,writable:!0,value:t}):i[e]=t,v=(i,e,t)=>(s_(i,typeof e!="symbol"?e+"":e,t),t),tD=(i,e,t)=>{if(!e.has(i))throw TypeError("Cannot "+t)},iD=(i,e,t)=>(tD(i,e,"read from private field"),t?t.call(i):e.get(i)),rD=(i,e,t)=>{if(e.has(i))throw TypeError("Cannot add the same private member more than once");e instanceof WeakSet?e.add(i):e.set(i,t)},Aa=(i,e,t,r)=>(tD(i,e,"write to private field"),r?r.call(i,t):e.set(i,t),t),kd=Object.create(null),wp=["Array","Browser",["Css","CSSHelper"],"Date","Dom","Event","Function","Object","String","TimeZone","Version"].map(i=>Array.isArray(i)?i:[i,`${i}Helper`]),nD=i=>Object.assign(Object.create(null),Object.fromEntries(i)),sD=nD(wp),a_=nD(wp.map(([i,e])=>[e,i])),Ep=i=>(e,t)=>{throw new Error(`Cannot ${i} "Helpers.${t}": object is readonly`)},o_=new Proxy(kd,{defineProperty:Ep("define property"),deleteProperty:Ep("delete"),set:Ep("assign"),get(i,e){const t=kd[e];if(!t)throw new Error(`Property not defined "Helpers.${e}": ${e in sD?`import ${sD[e]} before using it`:"invalid helper name"}`);return t}});Object.defineProperty(kd,"register",{value(i){const e=i.$name,t=a_[e];kd[t]=i}}),wp.forEach(i=>kd[i[0]]=null);var Pe=o_,aD,K=class{static cacheFlags(i=navigator.platform,e=navigator.userAgent){const t=this;t._isLinux=!!i.match(/Linux/),t._isMac=!!i.match(/Mac/),t._isWindows=!!i.match(/Win32/),t._isMobile=!!(e.match(/Mobile|Opera Mini|Opera Mobi|Puffin/)||typeof globalThis.orientation=="number"),t._isWebkit=!!(e.match(/WebKit/)&&!e.match(/Edg/)),t._firefoxVersion=t.getVersion(e,/Firefox\/(\d+)\./),t._isFirefox=t._firefoxVersion>0,t._chromeVersion=t.getVersion(e,/Chrom(?:e|ium)\/(\d+)\./),t._isChrome=t._chromeVersion>0,t._isSafari=!!e.match(/Safari/)&&!t._isChrome,t._isMobileSafari=!!e.match(/Mobile.*Safari/),t._safariVersion=t.getVersion(e,/Version\/(.*).Safari/),t._isAndroid=!!e.match(/Android/g)}static get supportsOverflowClip(){if(this._supportsOverflowClip==null){const i=document.createElement("div");i.style.overflow="clip",i.style.display="none",document.documentElement.appendChild(i),this._supportsOverflowClip=i.ownerDocument.defaultView.getComputedStyle(i).getPropertyValue("overflow")==="clip",i.remove()}return this._supportsOverflowClip}static get supportsSticky(){return!0}static getVersion(i,e){const t=i.match(e);return t?parseFloat(t[1]):0}static get isTouchDevice(){return this._isTouchDevice===void 0&&(this._isTouchDevice=globalThis.matchMedia("(any-pointer:coarse)").matches),this._isTouchDevice}static get isHoverableDevice(){return this._isHoverableDevice===void 0&&(this._isHoverableDevice=globalThis.matchMedia("(any-hover: hover)").matches),this._isHoverableDevice}static get isBrowserEnv(){return typeof window!="undefined"}static get isMac(){return this._isMac}static get isWindows(){return this._isWindows}static get isLinux(){return this._isLinux}static get isAndroid(){return this._isAndroid}static get isWebkit(){return this._isWebkit}static get isChrome(){return this._isChrome}static get chromeVersion(){return this._chromeVersion}static get isFirefox(){return this._isFirefox}static get firefoxVersion(){return this._firefoxVersion}static get isSafari(){return this._isSafari}static get safariVersion(){return this._safariVersion}static get isMobileSafari(){return this._isMobileSafari}static get isMobile(){return this._isMobile}static get platform(){const i=this;return i._isLinux?"linux":i._isMac?"mac":i._isWindows?"windows":i._isAndroid?"android":i._isMobileSafari?"ios":null}static get supportsRandomUUID(){var i,e;if(this._supportsRandomUUID===void 0)try{this._supportsRandomUUID=((e=(i=globalThis.crypto).randomUUID)==null?void 0:e.call(i).length)>0}catch(t){this._supportsRandomUUID=!1}return this._supportsRandomUUID}static get storageAvailable(){let i,e;try{return i=localStorage,e="__storage_test__",i.setItem(e,e),i.removeItem(e),!0}catch(t){return t instanceof DOMException&&(t.code===22||t.code===1014||t.name==="QuotaExceededError"||t.name==="NS_ERROR_DOM_QUOTA_REACHED")&&i.length!==0}}static setLocalStorageItem(i,e){this.storageAvailable&&localStorage.setItem(i,e)}static getLocalStorageItem(i){return this.storageAvailable&&localStorage.getItem(i)}static removeLocalStorageItem(i){this.storageAvailable&&localStorage.removeItem(i)}static get ctrlKey(){return this.isMac?"metaKey":"ctrlKey"}static get metaKey(){return this.isMac?"ctrlKey":"metaKey"}static searchParam(i,e=null,t=document.location.search){const r=new RegExp(`[?&]${i}=?([^&]*)`),n=t.match(r);return n&&n[1]||e}static getCookie(i){const e=encodeURIComponent(i)+"=",t=document.cookie.split(";");for(let r=0;r<t.length;r++){let n=t[r];for(;n.charAt(0)===" ";)n=n.substring(1,n.length);if(n.indexOf(e)===0)return decodeURIComponent(n.substring(e.length,n.length))}return""}static download(i,e){const t=document.createElement("a");t.download=i,t.href=e||i,t.style.cssText="display:none",document.body.appendChild(t),t.click(),document.body.removeChild(t)}static downloadBlob(i,e){const t=globalThis.URL.createObjectURL(i);this.download(e,t),globalThis.URL.revokeObjectURL(t)}static get queryString(){var i;const e=new URL(globalThis.location.href).searchParams;return(i=Object.fromEntries)==null?void 0:i.call(Object,e.entries())}static copyToClipboard(i){let e=!0;const t=document.createElement("textarea");t.value=i,t.style.height=t.style.width=0,document.body.appendChild(t),t.select();try{document.execCommand("copy")}catch(r){e=!1}return t.remove(),e}static isBryntumOnline(i){return i=Array.isArray(i)?i:[i],!!(/^(www\.)?bryntum\.com/.test(globalThis.location.host)||i!=null&&i.some(e=>this.queryString[e]!=null))}static get isCSP(){const{bryntum:i,document:e}=globalThis;return i.CSP==null&&(i.CSP=!!e.querySelector('meta[http-equiv="Content-Security-Policy"]')),i.CSP}};v(K,"$name","BrowserHelper"),v(K,"supportsPointerEvents",!!(globalThis.PointerEvent||globalThis.MSPointerEvent)),v(K,"supportsPointerEventConstructor",typeof PointerEvent!="undefined"),v(K,"PointerEventConstructor",globalThis.PointerEvent||globalThis.CustomEvent),v(K,"isPhone",(aD=globalThis.matchMedia)==null?void 0:aD.call(globalThis,"(max-height:414px) or (max-width:414px)").matches),Pe.register(K),K.isBrowserEnv&&K.cacheFlags(),K._$name="BrowserHelper";var{hasOwnProperty:l_,toString:d_}=Object.prototype,{isFrozen:oD}=Object,c_=/\s*<\s*/,u_=/\s*>\s*/,lD={},dD={},cD=Object.freeze({}),X=class Rt{static assign(e,...t){for(let r,n,s=0;s<t.length;s++)if(r=t[s],r)for(n in r)e[n]=r[n];return e}static assignIf(e,...t){for(let r,n,s=0;s<t.length;s++)if(r=t[s],r)for(n in r)(!(n in e)||e[n]===void 0)&&(e[n]=r[n]);return e}static blend(e,t,r){r=r||lD,e=e||{};const{clone:n=Rt.clone,merge:s=Rt.blend}=r;if(Array.isArray(t)){if(t.length>1)return t.forEach(a=>{e=Rt.blend(e,a,r)}),e;t=t[0]}if(t){let a,o,l;for(o in t)l=t[o],l&&Rt.isObject(l)&&(a=e[o],r.key=o,a&&Rt.isObject(a)?(oD(a)&&(e[o]=a=n(a,r)),l=s(a,l,r)):l=oD(l)?l:n(l,r)),e[o]=l}return e}static clone(e,t){let r=e,n;if(e&&typeof e=="object")if(t&&typeof t=="object"&&t&&(t=null),Rt.isObject(e))if(e.skipClone)r=e;else{r={};for(n in e)r[n]=Rt.clone(e[n])}else if(Array.isArray(e))for(r=[],n=e.length;n-- >0;)r[n]=Rt.clone(e[n]);else Rt.isDate(e)?r=new Date(e.getTime()):t&&(r=t(e));return r}static mergeUniformObjects(e,...t){for(const r of t)for(const n in r){const s=r[n];s&&(this.isObject(s)?this.mergeUniformObjects(e[n]||(e[n]={}),s):Array.isArray(s)?(n in e||(e[n]=[]),this.mergeArrayOfIdentityObjects(e[n],s)):e[n]=this.clone(s))}return e}static mergeArrayOfIdentityObjects(e,t){for(const r of t)if(this.isObject(r)){const n=e.find(s=>s.id===r.id);n?this.mergeUniformObjects(n,r):e.push(this.clone(r))}else e.push(r)}static createTruthyKeys(e){const t=O.split(e),r=t&&{};if(t)for(const n of t)n&&(r[n]=!0);return r}static getPath(e,t){return t.split(".").reduce((r,n)=>(r||cD)[n],e)}static getPathDefault(e,t,r){const n=Array.isArray(t)?t:typeof t=="string"?t.split("."):[t],s=n.length-1;return n.reduce((a,o,l)=>(r&&!(o in a)&&(a[o]=l===s?r:{}),(a||cD)[o]),e)}static getPropertyDescriptor(e,t){let r=null;for(let n=e;n&&!r&&!Rt.hasOwn(n,"isBase");n=Object.getPrototypeOf(n))r=Object.getOwnPropertyDescriptor(n,t);return r}static hasPath(e,t){return t.split(".").every(r=>e&&r in e?(e=e[r],!0):!1)}static getTruthyKeys(e){let t;if(typeof e=="string")t=[e];else if(Array.isArray(e))t=e.slice();else if(t=[],e)for(const r in e)e[r]&&t.push(r);return t}static getTruthyValues(e){const t=[];if(e)for(const r in e)e[r]&&t.push(e[r]);return t}static isClass(e){var t;return typeof e=="function"&&((t=e.prototype)==null?void 0:t.constructor)===e}static isDate(e){return!!(e!=null&&e.getUTCDate)&&Rt.typeOf(e)==="date"}static isPromise(e){if(Promise&&Promise.resolve)return Promise.resolve(e)===e||typeof(e==null?void 0:e.then)=="function";throw new Error("Promise not supported in your environment")}static isEmpty(e){if(e&&typeof e=="object")for(const t in e)return!1;return!0}static isObject(e){const t=e==null?void 0:e.constructor;return!!(t?t===Object||t.getPrototypeOf&&t.prototype&&!Object.getPrototypeOf(t.prototype):e&&typeof e=="object")}static isInstantiated(e){return e?typeof e=="object"&&!Rt.isObject(e):!1}static merge(e,...t){return Rt.blend(e,t)}static mergeItems(e,t,r){r=r||lD;let n,s,a,o,l,d,c;const{merge:u=Rt.blend}=r;if(e=e||{},Array.isArray(t))t.forEach(h=>{e=Rt.mergeItems(e,h,r)});else if(t)for(l in t)if(c=t[l],n=null,l.includes(">")?([l,n]=l.split(u_),s=0):l.includes("<")&&([n,l]=l.split(c_),s=1),l in e)c&&e[l]&&u&&(r.key=l,c=u(e[l],c,r)),e[l]=c;else if(!n)e[l]=c,o==null||o.set(l,o.size);else{if(!o){o=new Map,a=0;for(const h in e)o.set(h,a++)}if(a=o.get(n),e[l]=c,a==null&&s)a=o.size;else{d=d||[],a=(a||0)+s;for(const h of o){const[f,g]=h;a<=g&&(d&&(d[o.size-g-1]=f),o.set(f,g+1))}if(d)for(;d.length;){const h=d.pop(),f=e[h];delete e[h],e[h]=f}}o.set(l,a)}return e}static setPath(e,t,r){return t.split(".").reduce((n,s,a,o)=>a===o.length-1?n[s]=r:(n[s]instanceof Object||(n[s]={}),n[s]),e),e}static typeOf(e){let t,r;return e===null?r="null":e!==e?r="nan":(r=typeof e,r==="object"?e.isBase?r="instance":Array.isArray(e)?r="array":(r=dD[t=d_.call(e)])||(dD[t]=r=t.slice(8,-1).toLowerCase()):r==="function"&&e.isBase&&(r="class")),r}};Object.defineProperty(X,"hasOwn",{value:Object.hasOwn||((i,e)=>l_.call(i,e))}),X._$name="Objects";var uD,hD,fD,gD,mD=/([a-z])([A-Z])/g,h_=/[\n\r]/g,f_=/[.*+?^${}()|[\]\\]/g,g_=/[&<]/,m_=/(^[^a-z]+[^\w]+)/gi,p_=/\s+/,v_=/^[^a-z]+|[^\w:.-]+/gi,y_=(i,e)=>hD[e.toLowerCase()]||String.fromCharCode(parseInt(e.substr(2),10)),b_=(i,e)=>uD[e],C_=(i,e,t)=>`${e}-${t.toLowerCase()}`,S_=(i,e,t)=>`${e} ${t.toLowerCase()}`,D_=i=>i?`_x${[...i].map(e=>e.charCodeAt(0).toString(16)).join("")}`:"__blank__",pD={},vD={},as=[],w_=function(i,e){if(e&&typeof e=="object"){for(;as.length&&as[as.length-1]!==this;)as.pop();if(as.includes(e))return"[Circular]";as.push(e)}return e},xp=class rs{static capitalize(e){return e&&e[0].toUpperCase()+e.substr(1)}static uncapitalize(e){return e&&e[0].toLowerCase()+e.substr(1)}static hyphenate(e){const t=pD[e];return t||(pD[e]=e.replace(mD,C_))}static separate(e){const t=vD[e];return t||(vD[e]=this.capitalize(e.replace(mD,S_)))}static createId(e){return String(e).replace(m_,D_)}static makeValidDomId(e,t=""){return e==null?null:String(e).replace(v_,t)}static escapeRegExp(e,t){let r=e.replace(f_,"\\$&");return t!==void 0&&(r=new RegExp(r,t)),r}static decodeHtml(e){return e&&String(e).replace(gD,y_)}static encodeHtml(e=""){return e&&String(e).replace(fD,b_)}static encodeHtmlBR(e){var t;return(t=rs.encodeHtml(e))==null?void 0:t.replace(h_,"<br>")}static isHtml(e){return typeof e=="string"&&g_.test(e||"")}static initHtmlEntities(e){e=e||{"&":"&amp;",">":"&gt;","<":"&lt;",'"':"&quot;","'":"&#39;"};const t=Object.keys(e);uD=e,hD=t.reduce((r,n)=>(r[e[n]]=n,r),{}),fD=new RegExp(`([${t.map(r=>"[-]".includes(r)?"\\"+r:r).join("")}])`,"g"),gD=new RegExp(`(${Object.values(e).join("|")}|&#[0-9]+;)`,"ig")}static safeJsonParse(e){let t=null;try{t=JSON.parse(e)}catch(r){}return t}static safeJsonStringify(e,t=null,r=null){let n=null;try{t==="circular"&&(as.length=0,t=w_),n=JSON.stringify(e,t,r)}catch(s){}return n}static joinPaths(e,t="/"){return e.join(t).replace(new RegExp("\\"+t+"+","g"),t)}static split(e,t=p_){let r=e;return typeof r=="string"&&(r=e.trim(),r=r?r.split(t):[]),r}static xss(e,...t){const r=[];let n=t.length;for(r[n]=e[n];n-- >0;)r[n]=e[n]+rs.encodeHtml(t[n]);return r.join("")}static xssBR(e,...t){const r=[];let n=t.length;for(r[n]=e[n];n-- >0;)r[n]=e[n]+rs.encodeHtmlBR(t[n]);return r.join("")}static toJavaScriptValue(e,t){const r=X.typeOf(e);if(r==="boolean"||r==="string"||r==="number"||e===null)return rs.safeJsonStringify(e);if(e===globalThis)return"window";if(r==="date")return`new Date(${e.getFullYear()}, ${e.getMonth()}, ${e.getDate()}, ${e.getHours()}, ${e.getMinutes()}, ${e.getSeconds()}, ${e.getMilliseconds()})`;if(r==="array")return`[${e.map(n=>rs.toJavaScriptValue(n,t))}]`;if(r==="object"||r==="instance")return this.toJavaScriptString(e,t);if(r==="function"){let n=e.toString();return n.match(/^async (\w+?)\(/)?n=n.replace(/^async (\w+?)\(/,"async function("):!n.startsWith("async(")&&n.match(/^(\w+?)\(/)&&(n=n.replace(/^(\w+?)\(/,"function(")),n}if(r==="class")return e.toJavaScriptValue?e.toJavaScriptValue(t):Object.prototype.hasOwnProperty.call(e,"$name")?e.$name:e.name}static toJavaScriptString(e,t={}){var r;const n=(r=t.level)!=null?r:0,s=2;return`{
`+Object.keys(e).map(a=>" ".repeat((n+1)*s)+(a.match(/[- *]/)?`"${a}"`:a)+`: ${rs.toJavaScriptValue(e[a],{...t,level:n+1})}`).join(`,
`)+`
`+" ".repeat(n*s)+"}"}static encodeAttributeSelector(e,t){return`[${e}="${String(t).replace(/["\\]/g,"\\$&")}"]`}static generateUUID(){var e;return K.supportsRandomUUID?globalThis.crypto.randomUUID():(e=globalThis.crypto)!=null&&e.getRandomValues?("10000000-1000-4000-8000"+-1e11).replace(/[018]/g,t=>(t^globalThis.crypto.getRandomValues(new Uint8Array(1))[0]&15>>t/4).toString(16)):`${Date.now()}-${++rs.fakeNodeUUIDIndex}`}};v(xp,"$name","StringHelper"),v(xp,"fakeNodeUUIDIndex",0);var O=xp;O.initHtmlEntities(),Pe.register(O),O._$name="StringHelper";var E_=Object.freeze([]),{hasOwn:yD}=X,x_=async(i,e)=>{let t=e;for await(t of i)break;return t},bD=1.005.toFixed(2)==="1.01"?null:(i,e)=>{const t=i.toString().split("."),r=+(t[1]?t.join(".")+"1":t[0]);return i.toFixed.call(r,e)},CD=class lf extends X{static forEach(e,t){let r;if(e)if(Array.isArray(e))e.forEach(t);else for(r in e)t(e[r],r)}static transformArrayToNamedObject(e,t="ref"){const r={};return e.forEach((n,s)=>{const a=n[t]!=null&&n[t].toString().length?n[t]:s;r[a]=n}),r}static transformNamedObjectToArray(e,t="ref"){return Object.keys(e).filter(r=>e[r]).map(r=>{const n=e[r];return n[t]=r,n})}static isEqual(e,t,r=!1,n=!1){if(!n&&(e===null&&t!==null||e===void 0&&t!==void 0||t===null&&e!==null||t===void 0&&e!==void 0))return!1;if(e==null||t==null)return e==null&&t==null;if(e===t)return!0;const s=typeof e;if(s===typeof t){switch(s){case"number":case"string":case"boolean":return e===t}switch(!0){case(e instanceof Date&&t instanceof Date):return e.getTime()===t.getTime();case(Array.isArray(e)&&Array.isArray(t)):return e.length===t.length?e.every((o,l)=>Xt.isEqual(o,t[l],r)):!1;case(s==="object"&&e.constructor.prototype===t.constructor.prototype):return r?Xt.isDeeplyEqual(e,t,r):Pe.String.safeJsonStringify(e,"circular")===Pe.String.safeJsonStringify(t,"circular")}}return String(e)===String(t)}static isDeeplyEqual(e,t,r={}){if(e===t)return!0;if(!e||!t)return!1;const n=Xt.keys(e,r.ignore),s=Xt.keys(t,r.ignore);if(n.length!==s.length)return!1;for(let a=0;a<n.length;a++){const o=n[a],l=s[a];if(o!==l)return!1;const d=e[o],c=t[l];if(!(r.shouldEvaluate&&r.shouldEvaluate(o,{value:d,object:e},{value:c,object:t})===!1)){if(r.evaluate){const u=r.evaluate(o,{value:d,object:e},{value:c,object:t});if(u===!1)return!1;if(u===!0)continue}if(!Xt.isEqual(d,c,r))return!1}}return!0}static isPartial(e,t){return e=String(e).toLowerCase(),t=String(t).toLowerCase(),e.indexOf(t)!==-1}static isLessThan(e,t){return e instanceof Date&&t instanceof Date?Pe.Date.isBefore(e,t):e<t}static isMoreThan(e,t){return e instanceof Date&&t instanceof Date?Pe.Date.isAfter(e,t):e>t}static first(e,t){let r=t,n;if(e){if(e[Symbol.iterator])for(r of e)break;else if(e[Symbol.asyncIterator])r=x_(e,t);else if(lf.isObject(e)){r===void 0&&(r=E_);for(n in e){r=[n,e[n]];break}}}return r}static fork(e){let t,r,n;if(e&&e.constructor===Object){t=Object.setPrototypeOf({},e);for(r in e)n=e[r],n&&(n.constructor===Object?t[r]=Xt.fork(n):n instanceof Array&&(t[r]=n.slice()))}else t=e;return t}static copyProperties(e,t,r){let n,s;for(s=0;s<r.length;s++)n=r[s],n in t&&(e[n]=t[n]);return e}static copyPropertiesIf(e,t,r){if(t)for(const n of r)!(n in e)&&n in t&&(e[n]=t[n]);return e}static entries(e,t){const r=[],n=typeof t=="function";if(e)for(const s in e)(n?!t(s,e[s]):!(t!=null&&t[s]))&&r.push([s,e[s]]);return r}static fromEntries(e,t){if(t=t||{},e)for(let r=0;r<e.length;++r)t[e[r][0]]=e[r][1];return t}static keys(e,t,r){const n=[],s=typeof t=="function";if(e){let a=0;for(const o in e)(s?!t(o,e[o]):!(t!=null&&t[o]))&&(n.push(r?r(o,a):o),++a)}return n}static values(e,t,r){const n=[],s=typeof t=="function";if(e){let a=0;for(const o in e)(s?!t(o,e[o]):!(t!=null&&t[o]))&&(n.push(r?r(e[o],a):e[o]),++a)}return n}static pathExists(e,t){return t.split(".").every(n=>!e||!(n in e)?!1:(e=e[n],!0))}static pathifyKeys(e,t){const r={};for(const n in e)if(yD(e,n)){const s=t==null?void 0:t[n],a=(s==null?void 0:s.type)==="object"||(s==null?void 0:s.complexMapping)||!t;if(a&&Array.isArray(e[n]))r[n]=e[n].slice();else if(a&&e[n]instanceof Object){const o=this.pathifyKeys(e[n]);for(const l in o)r[`${n}.${l}`]=o[l]}else r[n]=e[n]}return r}static deletePath(e,t){t.split(".").reduce((r,n,s,a)=>{if(r==null)return null;if(yD(r,n))if(s===a.length-1)delete r[n];else return r[n]},e)}static coerce(e,t){const r=X.typeOf(e),n=X.typeOf(t),s=typeof e=="string";if(r!==n)switch(n){case"string":return String(e);case"number":return Number(e);case"boolean":return s&&(!e||e==="false"||e==="0")?!1:!!e;case"null":return s&&(!e||e==="null")?null:!1;case"undefined":return s&&(!e||e==="undefined")?void 0:!1;case"date":return s&&isNaN(e)?Pe.Date.parse(e):Date(Number(e))}return e}static wrapProperty(e,t,r,n,s=!0){const a={};let o=Object.getPrototypeOf(e),l=Object.getOwnPropertyDescriptor(o,t);for(;!l&&o&&s;)o=Object.getPrototypeOf(o),o&&(l=Object.getOwnPropertyDescriptor(o,t));l?(l.set?a.set=d=>{l.set.call(e,d),n&&n.call(e,l.get.call(e))}:a.set=n,l.get?a.get=()=>{let d=l.get.call(e);return r&&(d=r.call(e,d)),d}:a.get=r):(a.set=d=>{e[`_${t}`]=d,n&&n.call(e,d)},a.get=()=>{let d=e[`_${t}`];return r&&(d=r.call(e,d)),d}),Object.defineProperty(e,t,a)}static hookProperty(e,t,r){const n=lf.getPropertyDescriptor(r.prototype,"value"),s=lf.getPropertyDescriptor(e,t),a=`_${t}`,o=class{get value(){return s?s.get.call(this):this[a]}set value(d){s?s.set.call(this,d):this[a]=d}},l=lf.getPropertyDescriptor(o.prototype,"value");return Object.setPrototypeOf(r.prototype,o.prototype),Object.defineProperty(e,t,{configurable:!0,get:n.get||l.get,set:n.set||l.set}),()=>delete e[t]}static cleanupProperties(e,t=!1){return Object.entries(e).forEach(([r,n])=>{t?n===void 0&&delete e[r]:n==null&&delete e[r]}),e}static removeAllProperties(e){return Object.keys(e).forEach(t=>delete e[t]),e}static assertType(e,t,r){const n=X.typeOf(e);if(e!=null&&n!==t)throw new Error(`Incorrect type "${n}" for ${r}, expected "${t}"`)}static assertObject(e,t){Xt.assertType(e,"object",t)}static assertInstance(e,t){Xt.assertType(e,"instance",t)}static assertClass(e,t){Xt.assertType(e,"class",t)}static assertFunction(e,t){if(typeof e!="function"||e.isBase||e.$$name)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a function)`)}static assertNumber(e,t,r){const n=Number(e);if(typeof e!="number"||isNaN(n)||r&&e<0)throw new Error(`Incorrect type for ${t}, got "${e}" (expected a ${r?"positive ":""}Number)`)}static assertBoolean(e,t){Xt.assertType(e,"boolean",t)}static assertString(e,t){Xt.assertType(e,"string",t)}static assertArray(e,t){Xt.assertType(e,"array",t)}static toFixed(e,t){return bD?bD(e,t):e.toFixed(t)}static roundTo(e,t=1){return Math.round(e/t)*t}static round(e,t){if(t==null)return e;const r=10**t;return Math.round(e*r)/r}static getMapPath(e,t,r){const n=Array.isArray(t)?t:typeof t=="string"?t.split("."):[t],s=n.length===1,a=n[0],o=e.has(a)?e.get(a):e.set(a,s?r:{}).get(a);return s?o:Xt.getPathDefault(o,n.slice(1),r)}};v(CD,"$name","ObjectHelper");var T=CD;Pe.register(T);var Xt=T;T._$name="ObjectHelper";var SD=class mp{static setVersion(e,t){e=e.toLowerCase(),li[e]={version:t,isNewerThan(s){return mp.semanticCompareVersion(s,t,"<")},isOlderThan(s){return mp.semanticCompareVersion(s,t,">")}};let r="";typeof productName!="undefined"&&(r=`${productName}.`);const n=`${r}${e}${t.replace(/\./g,"-")}`;if(K.isBrowserEnv&&!globalThis.bryntum.silenceBundleException)if(globalThis.bryntum[n]===!0)if(this.isTestEnv)globalThis.BUNDLE_EXCEPTION=!0;else{let s=r||e;s==="core"&&(s="grid");let a=O.capitalize(s);throw s==="schedulerpro"&&(a="SchedulerPro"),new Error(`The Bryntum ${a} bundle was loaded multiple times by the application.

Common reasons you are getting this error includes:

* Imports point to different types of the bundle (e.g. *.module.js and *.umd.js)
* Imports point to both sources and bundle
* Imports do not use the shortest relative path, JS treats them as different files
* Cache busters differ between imports, JS treats ${s}.module.js?1 and ${s}.module.js?2 as different files
* Imports missing file type, verify they all end in .js

See https://bryntum.com/products/${s}/docs/guide/${a}/gettingstarted/es6bundle#troubleshooting for more information

`)}else globalThis.bryntum[n]=!0}static getVersion(e){if(e=e.toLowerCase(),!li[e])throw new Error("No version specified! Please check that you import VersionHelper correctly into the class from where you call `deprecate` function.");return li[e].version}static semanticCompareVersion(e,t,r="="){e=e||"",t=t||"";const n=e.split(/[-.]/),s=t.split(/[-.]/),a=r.includes("<"),o=(d,c)=>{const u=["rc","beta","alpha"],h=d.map(f=>{if(u.includes(f))return-u.indexOf(f)-2;const g=Number.parseInt(f);return Number.isNaN(g)?-u.length:g});for(;h.length<c;)h.push(-1);return h},l=()=>{const d=Math.max(n.length,s.length),c=o(n,d),u=o(s,d);for(let h=0;h<d;h++)if(c[h]!==u[h])return a?c[h]<u[h]:c[h]>u[h];return!0};switch(r){case"=":return e===t;case"<=":case">=":return e===t||l();case"<":case">":return e!==t&&l()}return!1}static checkVersion(e,t,r){return mp.semanticCompareVersion(li.getVersion(e),t,r)}static deprecate(e,t,r){if(li.checkVersion(e,t,"<"))console.warn(`Deprecation warning: You are using a deprecated API which will change in v${t}. ${r}`);else throw new Error(`Deprecated API use. ${r}`)}static get isTestEnv(){var e,t,r;const n=!!((e=globalThis.bryntum)!=null&&e.isTestEnv);try{return n||!!((r=(t=globalThis.parent)==null?void 0:t.bryntum)!=null&&r.isTestEnv)}catch(s){return n}}static get isDebug(){return!1}};v(SD,"$name","VersionHelper");var de=SD,li=de;K.isBrowserEnv&&(li.isTestEnv&&(K._isHoverableDevice=!0),globalThis.bryntum=Object.assign(globalThis.bryntum||{},{getVersion:li.getVersion.bind(li),checkVersion:li.checkVersion.bind(li),deprecate:li.deprecate.bind(li),license:"9c07f388-a9e9-11ec-9e5c-d094663d5c88"})),Pe.register(de),de._$name="VersionHelper";var{defineProperty:hf,getOwnPropertyDescriptor:DD}=Reflect,{hasOwnProperty:R_,toString:Rp}=Object.prototype,Tp=Symbol("instanceProperties"),wD=Symbol("configuring"),Fa=Symbol("lazyConfigValues"),ED=Rp.call(new Date),T_=/\s+/,xD=Object.hasOwn||((i,e)=>R_.call(i,e)),RD=(i,e)=>i===e?!0:i&&e&&Rp.call(i)===ED&&Rp.call(e)===ED?i.getTime()===e.getTime():!1,Mp=(i,e)=>(i.setHours(0,0,0,0),e&&i.setDate(i.getDate()+e),i),TD={now:()=>new Date,today:()=>Mp(new Date),tomorrow:()=>Mp(new Date,1),yesterday:()=>Mp(new Date,-1)},M_=(i,e)=>(i[e]=1,i),I_=(i,e)=>function(){var t;return(t=this.configObserver)==null||t.get(i,this),e.call(this)},Oe=class Ma{static get(e,t){const{cache:r}=this,n=r[e]||(r[e]=new Ma(e));let s=n,a;return t&&(a=Ma.makeCacheKey(e,t),(s=a&&r[a])||(s=n.extend(t),a&&(r[a]=s))),s}constructor(e){const t=this,r=e[0].toUpperCase()+e.substr(1);t.base=t,t.name=e,t.field="_"+e,t.capName=r,t.changer="change"+r,t.initializing="initializing"+r,t.updater="update"+r}get descriptor(){let e=this._descriptor;return(!e||!xD(this,"_descriptor"))&&(this._descriptor=e=this.makeDescriptor()),e}get initDescriptor(){let e=this._initDescriptor;return(!e||!xD(this,"_initDescriptor"))&&(this._initDescriptor=e=this.makeInitter()),e}convert(e,t){return e}equal(e,t){return e===t}extend(e){const t=Object.assign(Object.create(this),e),{convert:r,equal:n,merge:s}=e,{convertMethods:a,equalityMethods:o}=Ma;return typeof r=="string"&&!(t.convert=a[r])&&r.endsWith("[]")&&(t.convert=a[r]=Ma.makeArrayConvert(a[r.slice(0,-2)])),typeof n=="string"&&!(t.equal=o[n])&&n.endsWith("[]")&&(t.equal=o[n]=Ma.makeArrayEquals(o[n.slice(0,-2)])),typeof s=="string"&&(t.merge=Ma.mergeMethods[s]),t}define(e){const{name:t}=this,r=DD(e,t);let n=this.descriptor;r!=null&&r.get&&(n=Object.assign({},n),n.get=I_(t,r.get)),hf(e,t,n)}defineInitter(e,t){const r=this,{name:n}=r,s=e[Tp];let a,o;!s[n]&&(o=DD(e,n))&&!("value"in o)&&(s[n]=o),hf(e,n,r.initDescriptor),r.lazy&&(a=e[Fa]||(e[Fa]=new Map),a.set(n,t))}static makeArrayConvert(e){return function(t,r){return t!=null&&(Array.isArray(t)?t=t.map((n,s)=>e.call(this,n,r)):t=[e.call(this,t,r)]),t}}static makeArrayEquals(e){return(t,r)=>{let n,s=t&&r&&t.length===(n=r.length);if(s&&Array.isArray(t)&&Array.isArray(r))if(e)for(;s&&n-- >0;)s=e(t[n],r[n]);else for(;s&&n-- >0;)s=t[n]===r[n];else s=e?e(t,r):t===r;return s}}static makeCacheKey(e,t){const r=Object.keys(t).sort();for(let n,s,a,o=r.length;o-- >0;)if(a=t[n=r[o]],a==null&&a===!1)r.splice(o,1);else{if(s=typeof a,s==="function")return null;s==="string"?r[o]=`${n}:"${a}"`:s==="number"&&(r[o]=`${n}:${a}`)}return r.length?`${e}>${r.join("|")}`:e}makeDescriptor(){const{base:e,field:t,changer:r,updater:n,name:s}=this;return e!==this?e.descriptor:{get(){var a;return(a=this.configObserver)==null||a.get(s,this),this[t]},set(a){var o,l;const d=this,c=d.$meta.configs[s];let u=d[t],h,f;if(typeof a=="string"){let g=a;a.startsWith("up.")?g=(o=d.owner)==null?void 0:o.resolveProperty(a.slice(3)):a.startsWith("this.")&&(g=d.resolveProperty(a.slice(5))),g!==void 0&&typeof g!="function"&&(a=g)}c.convert!==MD&&(a=c.convert(a,d)),d[r]&&(h=(f=d[r](a,u))===void 0&&1,h||(a=f,u=d[t])),!h&&!(c.equal===ID?u===a:c.equal(u,a))&&(d[t]=a,h=2,(l=d[n])==null||l.call(d,a,u)),h&&!d.isDestroyed&&!d.onConfigChange.$nullFn&&d.onConfigChange({name:s,value:a,was:u,config:c,applied:h})}}}makeInitter(){const e=this;return e!==e.base?e.lazy?e.makeLazyInitter():e.base.initDescriptor:e.makeBasicInitter()}makeBasicInitter(){const e=this,{initializing:t,name:r}=e;return{configurable:!0,get(){const n=this;return e.removeInitter(n),n[t]=!0,n[r]=n[wD][r],n[t]=!1,n.configDone[r]=!0,n[r]},set(n){e.removeInitter(this),this.configDone[r]=!0,this[r]=n}}}makeLazyInitter(){const e=this,{initializing:t,name:r}=e;return{configurable:!0,get(){const n=this,s=n[Fa].get(r);return e.removeInitter(n),n.isDestroying||(n[t]=!0,n[r]=s,n[t]=!1),n[r]},set(n){e.removeInitter(this),this[r]=n}}}removeInitter(e){const{name:t}=this,r=e[Tp][t],n=e[Fa];r?hf(e,t,r):delete e[t],n!=null&&n.delete(t)&&!n.size&&delete e[Fa]}setDefault(e,t){hf(e.prototype,this.field,{configurable:!0,writable:!0,value:t})}merge(e,t){if(t&&e&&X.isObject(e)){if(t.isBase)return t.setConfig(e);X.isObject(t)&&(e=X.merge(X.clone(t),e))}return e}},{prototype:Ld}=Oe,{convert:MD,equal:ID}=Ld;Oe.symbols={configuring:wD,instanceProperties:Tp,lazyConfigs:Fa},Oe.cache=Object.create(null),Oe.convertMethods={array:Oe.makeArrayConvert(MD),date(i,e){let t=i,r,n,s;if(TD[i])t=TD[i]();else if(i!=null){if(typeof i!="string")r=new Date(i);else{if(s=this.formats,s){s=s.flatMap(a=>a in e?e[a]:a);for(n of s)if(r=n&&Pe.Date.parse(i,n),r)break}r||(r=Pe.Date.parse(i))}if(isNaN(r)){if(this.strict)throw new Error(`Invalid date: ${i}`)}else t=r}return t},day(i,e){return i=Oe.convertMethods.date.call(this,i,e),i==null||i.setMinutes(0,0,0),i}},Oe.equalityMethods={array:Oe.makeArrayEquals(),date:RD,day:RD,strict:Oe.equal=ID},Oe.mergeMethods={distinct(i,e){let t=e?e.slice():[];if(i!=null)if(X.isObject(i))if(e===void 0)t=i;else{let r,n;for(r in i)n=t.indexOf(r),i[r]?n<0&&t.push(r):n>-1&&t.splice(n,1)}else Array.isArray(i)?i.forEach(r=>!t.includes(r)&&t.push(r)):t.includes(i)||t.push(i);return t},merge:Oe.merge=Ld.merge,classList(i,e){if(typeof i=="string"){if(!i.length)return e;i=i.split(T_)}return Array.isArray(i)&&(i=i.reduce(M_,{})),Oe.merge(i,e)},objects(i,e){return i===!0?e||{}:Oe.merge(i,e)},replace(i){return i},items(i,e,t,r){return r?X.mergeItems(e,i,{merge:(n,s)=>Ld.merge(s,n)}):Ld.merge(i,e)}},Object.assign(Ld,{_descriptor:null,_initDescriptor:null,date:!1,lazy:!1,nullify:!1,render:!1}),Oe._$name="Config";var __=class{constructor(i,e,t,r){const n=this;let s,a;n.destroyed=!1,n.mapFwd={},n.mapRev={},n.source=i,n.syncing=!1,n.target=e,n.sourceHook=Pe.Function.after(i,"onConfigChange",o=>n.onConfigChange(o,!0),n,FD),n.targetHook=r!=null&&r.oneway?null:Pe.Function.after(e,"onConfigChange",o=>n.onConfigChange(o,!1),n,FD);for(s in t)a=t[s],a&&(typeof a!="string"&&(a=s),n.mapFwd[s]=a,n.mapRev[a]=s);n.unbind=n.destroy.bind(n),n.unbind.binding=n}destroy(){var i,e;this.destroyed||(this.destroyed=!0,(i=this.sourceHook)==null||i.call(this),(e=this.targetHook)==null||e.call(this))}onConfigChange(i,e){const t=this;(e?t.mapFwd:t.mapRev)[i.name]&&t.sync(e)}sync(i){i=i!==!1;const e=this,[t,r,n]=i?[e.source,e.target,e.mapFwd]:[e.target,e.source,e.mapRev];if(!e.syncing&&!t.isDestroying&&!r.isDestroying){let s=0,a,o,l,d,c,u;e.syncing=!0;for(o in n)d=n[o],l=t[o],l!==r[d]&&(++s,(a||(a={}))[c=d]=u=l);s>1?r.setConfig(a):s&&(r[c]=u),e.syncing=!1}}},_D=class{constructor(i){i&&Object.assign(this,i)}getInherited(i,e=!0){var t;let r=this[i];return i in this||(r=(t=this.super)==null?void 0:t.getInherited(i,e),(r||e)&&(this[i]=r=Object.create(r||null),Ip(r,"$meta",{value:this}))),r}},{getPrototypeOf:PD}=Object,{defineProperty:Ip}=Reflect,Ni=(i=>(e,t)=>i.call(e,t))(Object.prototype.hasOwnProperty),ff=Symbol("classMetaData"),AD=Symbol("mixinTag"),_p=Symbol("originalConfig"),hH=Symbol("createdAt"),Sr=Oe.symbols.configuring,P_=Oe.symbols.instanceProperties,ka=Oe.symbols.lazyConfigs,A_={merge:"replace",simple:!0},Pp=i=>Pe.Object.clone(i),Ap=()=>{},F_=i=>new _D(i),Od=i=>Pe.Object.isObject(i),FD={return:!1},kD={},k_=Object.freeze({}),LD=Object.freeze([]),L_=/^(date|day)(\[])?$/,$=class Yr{static get isBase(){return!0}get isBase(){return!0}static get declarable(){return["declarable","configurable","defaultConfig","properties","prototypeProperties"]}constructor(...e){const t=this,r=t.constructor;t.$meta.class!==r&&(r.$meta.initialized=!0),t.construct(...e),t.afterConstruct(),t.isConstructing=!1}static new(...e){return e=e.filter(t=>t),e=e.length>1?this.mergeConfigs(...e):e[0],new this(e)}construct(...e){e[0]!==null&&this.configure(...e),this.afterConfigure()}static destroy(...e){const t=r=>{r!=null&&r.destroy?r.destroy():Array.isArray(r)&&r.forEach(t)};t(e)}destroy(){const e=this,{id:t}=e;e.isDestroying=!0,e.destroy=Ap,e.doDestroy(),Object.setPrototypeOf(e,null);for(const r in e)r!=="destroy"&&r!=="isDestroying"&&delete e[r];delete e[_p],e.isDestroyed=!0,e.id=t}_thisIsAUsedExpression(e){}static get $$name(){return Ni(this,"$name")&&this.$name||Ni(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}startConfigure(e){}finishConfigure(e){}afterConfigure(){}afterConstruct(){}callback(e,t,r=LD){const{handler:n,thisObj:s}=this.resolveCallback(e,t==="this"?this:t)||k_;return n==null?void 0:n.apply(s,r)}resolveProperty(e){let t=this;for(;t;){if(Yr.hasConfigPath(t,e,!0))return Pe.Object.getPath(t,e);t=t.owner}}resolveCallback(e,t=this,r=!0){if(e!=null&&e.substring){if(e.endsWith("?")&&(r=!1,e=e.substring(0,e.length-1)),e.startsWith("up.")){for(e=e.substring(3),t=this.owner;t&&!t[e];t=t.owner);if(!t)return}else e.startsWith("this.")&&(e=e.substring(5),t=this);if(!t||!(t instanceof Object))return;e=t[e]}if(typeof e=="function")return{handler:e,thisObj:t};if(r)throw new Error(`No method named ${e} on ${t.$$name||"thisObj object"}`)}bindCallback(e,t=this){if(e){const{handler:r,thisObj:n}=this.resolveCallback(e,t);if(r)return r.bind(n)}}delay(e,t,r=e.name||e){return e=this.setTimeout?e:e.bind(this),(this.setTimeout?this:globalThis)[typeof t=="number"?"setTimeout":"requestAnimationFrame"](e,t,r)}doDestroy(){const e=this,{nullify:t}=e.$meta;if(t)for(let r=0;r<t.length;++r)e[t[r].field]!=null&&(e[t[r].name]=null)}destroyProperties(...e){var t,r;const n=this;let s;for(s of e)s in n&&(!n[Sr]||!n[Sr][s])&&((r=(t=n[s])==null?void 0:t.destroy)==null||r.call(t),delete n[s])}configure(e={}){const t=this,r=t.$meta,{beforeConfigure:n}=t.initialConfig=e,{configs:s}=r,a=t.getDefaultConfiguration();let o,l,d;t.isConfiguring=!0,Object.assign(t,t.getProperties());for(l in e)d=e[l],o=s[l],a[l]=o?o.merge(d,a[l],null,r):d;n&&(delete a.beforeConfigure,n(t,a)),t.setConfig(t[_p]=a,!0),t.isConfiguring=!1}bindConfigs(e,t,r){const n=new __(this,e,t,r);return(r==null?void 0:r.sync)!==!1&&n.sync(),n.unbind}getConfig(e,...t){const r=this[e];return t.length?[r,...t.map(n=>this[n])]:r}setConfig(e,t=!1){var r;const n=this,s=n[Sr],a=s?n.configDone:n.configDone={},o=n.$meta.configs,l=n[ka];let d,c;n[P_]={},n[Sr]=s?Object.setPrototypeOf(Object.assign({},e),s):e;for(c in e)e[c]!==null||Ni(e,c)?(d=o[c]||Oe.get(c),l!=null&&l.has(c)||d.defineInitter(n,e[c]),t||(a[c]=!1)):a[c]=!0;t&&n.startConfigure(e);for(c in e)!a[c]&&!(t&&((r=o[c])!=null&&r.lazy))&&(n[c]=e[c]);return s?n[Sr]=s:delete n[Sr],t&&n.finishConfigure(e),n}hasConfig(e){var t;const r=this,n=r[Sr];return!!(r["_"+e]!=null||((t=r[ka])==null?void 0:t.get(e))!=null||!r.configDone[e]&&n&&(n[e]!=null||Ni(n,e)))}static hasConfigPath(e,t){return t.split(".").every(r=>{var n,s,a;const o=(s=(n=e==null?void 0:e.$meta)==null?void 0:n.configs)==null?void 0:s[r];return(o&&o.descriptor.get===((a=Pe.Object.getPropertyDescriptor(e,r))==null?void 0:a.get)?e.hasConfig(r):r in e)?(e=e[r],Object!==void 0):!1})}peekConfig(e){const t=this,r=t[ka],n=t[Sr];if(r!=null&&r.has(e))return r.get(e);if(n&&e in n){if(t.configDone[e])return t[e];if(n[e]!=null||Ni(n,e))return n[e]}}triggerConfig(e){const t=this,{configDone:r}=t,n=t[ka],s=t[Sr],a=n!=null&&n.has(e)||s&&(s[e]!=null||Ni(s,e))?!r[e]:null;return a&&t.getConfig(e),a}triggerConfigs(e){const t=this,r=t.$meta.configs,n=t[ka],s=n?[...n.keys()].filter(a=>r[a].lazy===e):LD;for(const a of s)t.triggerConfig(a);return s.length?s:null}onConfigChange(){}get config(){const e={},t=this[_p];for(const r in t)e[r]=t[r];return e}static processConfigValue(e,t){if(e===globalThis)return globalThis;if(Array.isArray(e))return e.map(r=>Yr.processConfigValue(r,t));if(e instanceof Yr)return t.visited.has(e)?void 0:e.getCurrentConfig(t);if(e instanceof HTMLElement||e instanceof DocumentFragment)return null;if(Od(e)){const r={};for(const n in e)n!=="owner"&&(r[n]=Yr.processConfigValue(e[n],t));return r}return e}getConfigValue(e,t){var r;const n=this,s=n[ka];if(!((r=n.$meta.configs[e])!=null&&r.lazy))return Yr.processConfigValue(n[e],t);if(s!=null&&s.has(e))return Yr.processConfigValue(s.get(e),t)}preProcessCurrentConfigs(){}getCurrentConfig(e={}){const t=this,r=e.configs==="all"?t.config:Pp(t.initialConfig),n=e.skip||{},s=e.visited||(e.visited=new Set),a=e.depth||(e.depth=0),o={};if(!s.has(t)){s.add(t),this.preProcessCurrentConfigs(r);for(const l in r){if(n[l])continue;const d=t.getConfigValue(l,{...e,depth:a+1});d!==void 0&&(o[l]=d)}return o}}getConfigString(e={}){return Pe.String.toJavaScriptString(this.getCurrentConfig(e))}getTestCase(e={}){const t=this.isGantt?"Gantt":this.isSchedulerPro?"SchedulerPro":this.isCalendar?"Calendar":this.isScheduler?"Scheduler":this.isGrid?"Grid":this.isTaskBoard?"TaskBoard":null;if(t){const r=t.toLowerCase(),n=`../../build/${r}.module.js`;let s,a;e.import==="static"?(s=`import * as module from "${n}";Object.assign(window, module);`,a=""):(s=`import("${n}").then(module => { Object.assign(window, module);
`,a="});");const o=de.getVersion(r);return o&&(s+=`
console.log('${t} ${o}');
`),`${s}      
const ${r} = new ${t}(${this.getConfigString(e)});
${a}`}}downloadTestCase(e={}){e.output="return";const t=this.getTestCase(e);Pe.Browser.download("app.js","data:application/javascript;charset=utf-8,"+escape(t))}static initClass(){return this.$meta.class}static get $meta(){if(!Ni(this,ff)){const e=this[ff]=new _D;return e.class=this,this.setupClass(e),e}return this[ff]}static onClassMixedIn(){}static mergeConfigs(e,...t){const r=this.$meta.configs,n=Pp(e)||{};let s,a,o,l;for(a=0;a<t.length;++a)if(s=t[a],s)for(o in s)l=s[o],r[o]?l=r[o].merge(l,n[o]):n[o]&&l&&(l=Oe.merge(l,n[o])),n[o]=l;return n}static mixin(...e){let t=this,r;for(r=0;r<e.length;++r){const n=e[r],s=n[AD]||(n[AD]=Symbol("mixinTag"));t[s]||(t=n(t),t[s]=!0,Ni(t,"onClassMixedIn")&&t.onClassMixedIn())}return t}static setupClass(e){var t;const r=e.class,n=PD(r).$meta,s=r.$$name,a=n.names,o=r.prototype;if(Ip(o,"$meta",{value:e}),Object.assign(e,{super:n,config:Object.create(n.config),configs:Object.create(n.configs),declarables:n.declarables,forkConfigs:n.forkConfigs,hierarchy:Object.freeze([...n.hierarchy,r]),names:a.includes(s)?a:Object.freeze([...a,s]),properties:n.properties,nullify:(t=n.nullify)==null?void 0:t.slice()}),a!==e.names){const l=`is${s}`,d=c=>{Ni(c,l)||Ip(c,l,{get(){return!0}})};d(o),d(r)}for(let l,d,c=0;c<e.declarables.length;++c)l=e.declarables[c],Ni(r,l)&&(d=kD[l]||(kD[l]=`setup${Pe.String.capitalize(l)}`),r[d](r,e))}static setupConfigs(e,t,r){const n=e.config,s=e.configs,a=e.class,o=e.super;let{nullify:l}=e,d,c,u,h,f,g;for(const m in t)f=t[m],r?(d=s[m])?f=d.merge(f,n[m],e,o):d=Oe.get(m,A_):(c=u=h=void 0,f&&typeof f=="object"&&"$config"in f&&(u=f.$config,L_.test(String(u))&&(u={type:u}),u&&(Od(u)?u.type&&(u={convert:u.type,equal:u.type,...u},delete u.type):u=Pe.Object.createTruthyKeys(u)),h="default"in f,c=h?f.default:c,f="value"in f?f.value:null),(d=s[m])?(g=d.nullify,u&&(d=d.extend(u)),f=d.merge(f,n[m],e,o)):(d=Oe.get(m,u),d.define(a.prototype),h=!(d.field in a.prototype),g=!1),h&&d.setDefault(a,c),d.nullify&&!g&&(l||(l=e.nullify||(e.nullify=[]))).push(d)),f&&(Od(f)||Array.isArray(f))&&!Object.isFrozen(f)&&(e.forkConfigs=!0),s[m]=d,n[m]=f}static setupConfigurable(e,t){e.setupConfigs(t,e.configurable,!1)}static setupDefaultConfig(e,t){e.setupConfigs(t,e.defaultConfig,!0)}static setupDeclarable(e,t){const r=e.declarable;let n=t.declarables,s,a;for(a=0;a<r.length;++a)n.includes(r[a])||(s||(t.declarables=s=n=n.slice()),n.push(r[a]))}static setupProperties(e,t){t.properties=t.super.properties.slice(),t.properties.push(e),Object.freeze(t.properties)}static setupPrototypeProperties(e){Object.assign(e.prototype,e.prototypeProperties)}static fork(e){let t=e,r,n;if(e&&Od(e)&&!Object.isFrozen(e)){t=Object.create(e);for(r in e)n=e[r],n&&(Od(n)?t[r]=Yr.fork(n):Array.isArray(n)&&(t[r]=n.slice()))}return t}static getDefaultConfiguration(){return this.$meta.class.prototype.getDefaultConfiguration()}getDefaultConfiguration(){const e=this.$meta,t=e.forkConfigs?Yr.fork(e.config):Object.create(e.config);if(de.isTestEnv&&Pe.Browser.isBrowserEnv&&t.testConfig&&globalThis.__applyTestConfigs)for(const r in t.testConfig)t[r]=t.testConfig[r];return t}getProperties(){const e=this.$meta.properties,t={};for(let r=0;r<e.length;r++){const n=Object.getOwnPropertyDescriptor(e[r],"properties");Object.assign(t,n.get!==void 0?e[r].properties:Pp(n.value))}return t}static get superclass(){return PD(this)}classHierarchy(e){const t=this.$meta.hierarchy,r=e?t.indexOf(e):0;return r>0?t.slice(r):t}static isOfTypeName(e){return this.$meta.names.includes(e)}detachListeners(e){let t=this.$detachers;if(t=t==null?void 0:t[e],t)for(;t.length;)t.pop()()}trackDetacher(e,t){const r=this.$detachers||(this.$detachers={});(r[e]||(r[e]=[])).push(t)}untrackDetachers(e){const t=this.$detachers;if(t)for(const r in t){const n=t[r];for(let s=n.length;s-- >0;)n[s].eventer===e&&n.splice(s,1)}}},Fp=$.prototype;Fp.onConfigChange.$nullFn=Ap.$nullFn=!0,$[ff]=Fp.$meta=F_({class:$,config:Object.freeze({}),configs:Object.create(null),declarables:$.declarable,forkConfigs:!1,hierarchy:Object.freeze([$]),names:Object.freeze(["Base"]),nullify:null,properties:Object.freeze([]),super:null}),Object.assign(Fp,{$detachers:null,configObserver:null,isConstructing:!0,isDestroyed:!1,isDestroying:!1}),$.emptyFn=Ap,de.setVersion("core","6.0.5"),$._$name="Base";var OD=class FI{static clean(e){return e.reduce((t,r)=>(r!=null&&!(Array.isArray(r)&&r.length===0)&&r!==""&&t.push(r),t),[])}static from(e,t,r){const n=[];if(e)for(const s of e)(!t||t(s))&&n.push(r?r(s):s);return n}static remove(e,...t){let r,n,s=!1;t=t[0]instanceof Set?[...t[0]]:t;for(let a=0;a<t.length;a++)n=t[a],(r=e.indexOf(n))!==-1&&(e.splice(r,1),s=!0);return s}static findInsertionIndex(e,t,r=this.lexicalCompare,n){const s=t.length;let a,o;return n<s&&(a=n>0?r(t[n-1],e):0,o=n<s-1?r(e,t[n]):0,a<1&&o<1)?n:this.binarySearch(t,e,r)}static findLast(e,t,r){for(let{length:n}=e,s=n-1;s>=0;s--)if(t.call(r,e[s],s,e))return e[s]}static binarySearch(e,t,r=0,n=e.length,s=this.lexicalCompare){const a=e.length;let o,l;for(r instanceof Function?(s=r,r=0):n instanceof Function&&(s=n,n=a),--n;r<=n;)o=r+n>>1,l=s(t,e[o]),l>=0?r=o+1:l<0&&(n=o-1);return r}magnitudeCompare(e,t){return e<t?-1:e>t?1:0}lexicalCompare(e,t){return e=String(e),t=String(t),e<t?-1:e>t?1:0}static fill(e,t={},r=null){const n=[],s=Array.isArray(t)?t:[t];for(let a=0;a<e;a++)for(const o of s){const l=Object.assign({},o);r&&r(l,a),n.push(l)}return n}static populate(e,t,r=!1){const n=[];for(let s=0;s<e;s++)n.push(t(s+(r?1:0)));return n}static include(e,...t){for(const r of t)e.includes(r)||e.push(r)}static unique(e){return[...new Set(e)]}static allowNegative(e){return new Proxy(e,{get(t,r,n){if(typeof r!="string")return Reflect.get(t,r,n);const s=Number(r);return Number.isNaN(s)?Reflect.get(t,r,n):t[s<0?t.length+s:s]},set(t,r,n,s){if(typeof r!="string")return Reflect.set(t,r,n,s);const a=Number(r);return Number.isNaN(a)?Reflect.set(t,r,n,s):(t[a<0?t.length+a:a]=n,!0)}})}static delta(e,t,r=!1){if(!t)return r?{toAdd:e,toRemove:[],toKeep:[]}:{onlyInA:e,onlyInB:[],inBoth:[]};const n=[],s=[],a=new Set,o=new Set(t);for(let l=0;l<e.length;l++){const d=e[l];o.has(d)?a.add(d):n.push(d)}for(let l=0;l<t.length;l++){const d=t[l];a.has(d)||s.push(d)}return r?{toAdd:n,toRemove:s,toKeep:a}:{onlyInA:n,onlyInB:s,inBoth:[...a]}}static asArray(e){return e==null?e:e instanceof Set?Array.from(e):Array.isArray(e)?e:[e]}static identity(e){return e}static keyBy(e,t,r=FI.identity){const n=typeof t=="string"?a=>a==null?void 0:a[t]:t,s=typeof r=="string"?a=>a==null?void 0:a[r]:r;return e.reduce((a,o)=>(a[n(o)]=s(o),a),{})}static aggregate(e,t,r,n,s={}){const a=e.length,o=e[0].length,l=[];s.targetArray=l,s.arrays=e;for(let d=0;d<o;d++)s.entryIndex=d,l.push(n(d,s));for(let d=0;d<a;d++){const c=e[d];s.rowIndex=d;for(let u=0;u<o;u++){s.entryIndex=u;const h=t(c[u],s);l[u]=r(l[u],h,d,u,s)}}return l}static groupBy(e,t){const r=typeof t=="string"?n=>n==null?void 0:n[t]:t;return e.reduce((n,s)=>{const a=r(s);return(n[a]=n[a]||[]).push(s),n},{})}static groupByIndexed(e,t){return e.reduce((r,n)=>{const s=t(n);let a=r.get(s);return a===void 0&&(a=new Set,r.set(s,a)),a.add(n),r},new Map)}};v(OD,"$name","ArrayHelper");var H=OD;Pe.register(H),H._$name="ArrayHelper";var $D=/,\s*/,kp=Symbol("decompiled"),O_=/^\s*(async\s+)?([a-z_]\w*)\s*=>([\s\S]+)$/i,$_=/^\s*(async\s*)?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)\s+=>([\s\S]+)$/i,B_=/^(\s*async)?(?:\s*function)?(?:\s*([a-z_]\w*))?\s*\(((?:[a-z_]\w*(?:, [a-z_]\w*)*)?)\)([\s\S]+)$/i,{hasOwnProperty:H_}=Object.prototype,BD=class US{static after(e,t,r,n,s){const a=typeof r=="string",o=(s==null?void 0:s.return)!==!1,l=(...d)=>{const c=l.$nextHook.call(e,...d),u=n!=null&&n.isDestroyed?void 0:o?a?n[r](c,...d):r.call(n,c,...d):a?n[r](...d):r.call(n,...d);return u===void 0?c:u};return US.hookMethod(e,t,l)}static before(e,t,r,n){const s=typeof r=="string",a=(...o)=>{const l=n!=null&&n.isDestroyed?0:s?n[r](...o):r.call(n,...o);return l===!1?l:a.$nextHook.call(e,...o)};return US.hookMethod(e,t,a)}static curry(e){return function t(...r){return r.length>=e.length?e.apply(this,r):function(...n){return t.apply(this,r.concat(n))}}}static bindAll(e){for(const t in e)typeof e[t]=="function"&&(e[t]=e[t].bind(e))}static createInterceptor(e,t,r){return function(...n){const s=r||this;return t.call(s,...n)!==!1?e.call(s,...n):!1}}static createSequence(e,t,r){return(...n)=>{const s=e.call(r,...n),a=t.call(r,...n);return a===void 0?s:a}}static createThrottled(e,t,r,n,s){let a=-Number.MAX_VALUE,o,l;const d=()=>{l=0,a=performance.now(),o.push.apply(o,n),e.apply(r,o)},c=function(...u){const h=performance.now()-a;o=u,h>=t?(clearTimeout(l),d()):(l||(l=setTimeout(d,t-h)),s&&(o.push.apply(o,n),s.apply(r,o)))};return c.cancel=()=>clearTimeout(l),c}static createBuffered(e,t,r,n){let s,a;const o=()=>{a=0,l.isPending=!1,s.push.apply(s,n),e.apply(r,s)},l=function(...d){s=d,a&&clearTimeout(a),l.isPending=!0,a=setTimeout(o,t)};return l.cancel=()=>{l.isPending=!1,clearTimeout(a)},l}static decompile(e){if(!(kp in e)){const t=e.toString();let r=O_.exec(t),n,s,a,o,l;r?(n=[r[2]],s=r[3]):(r=$_.exec(t))?(l=r[2].trim(),n=l?l.split($D):[],s=r[3]):(r=B_.exec(t))&&(a=r[2],l=r[3].trim(),n=l?l.split($D):[],s=r[4]),s=s==null?void 0:s.trim(),e[kp]=o=r&&{args:n,async:!!r[1],body:s!=null&&s.startsWith("{")?s.substring(1,s.length-1).trim():s},a&&(o.name=a)}return e[kp]}static hookMethod(e,t,r){return r.$nextHook=e[t],e[t]=r,()=>{var n;if(H_.call(e,t)){let s=e[t],a;if(s===r)((n=Object.getPrototypeOf(e))==null?void 0:n[t])===r.$nextHook?delete e[t]:e[t]=r.$nextHook;else for(;a=s==null?void 0:s.$nextHook;s=a)if(a===r){s.$nextHook=r.$nextHook;break}}}}static noThrow(e,t,r){const n=e[t];e[t]=(...s)=>{try{return n.apply(e,s)}catch(a){return r==null?void 0:r(a)}}}static returnTrue(){return!0}static animate(e,t,r,n="linear"){let s=!1;const a=new Promise(o=>{const l=performance.now(),d=()=>{const c=Math.min((performance.now()-l)/e,1),u=r&&r.setTimeout?r:globalThis;s||t.call(r,this.easingFunctions[n](c))===!1&&o(),s||c===1?u.requestAnimationFrame(()=>o()):u.requestAnimationFrame(d)};d()});return a.cancel=()=>(s=!0,a.cancelled=!0,!1),a}};v(BD,"$name","FunctionHelper");var Se=BD;Pe.register(Se);var ke=.5,Qr=1.70158,di=7.5625,gf=1.525,Lp=2/2.75,Op=2.25/2.75,$p=1/2.75,Bp=1.5/2.75,Hp=2.5/2.75,jp=2.625/2.75,Vp=.75,zp=.9375,Np=.984375,j_=1.70158,V_=1.70158;Se.easingFunctions={linear:i=>i,easeInQuad:i=>Math.pow(i,2),easeOutQuad:i=>-(Math.pow(i-1,2)-1),easeInOutQuad:i=>(i/=ke)<1?ke*Math.pow(i,2):-ke*((i-=2)*i-2),easeInCubic:i=>Math.pow(i,3),easeOutCubic:i=>Math.pow(i-1,3)+1,easeInOutCubic:i=>(i/=ke)<1?ke*Math.pow(i,3):ke*(Math.pow(i-2,3)+2),easeInQuart:i=>Math.pow(i,4),easeOutQuart:i=>-(Math.pow(i-1,4)-1),easeInOutQuart:i=>(i/=ke)<1?ke*Math.pow(i,4):-ke*((i-=2)*Math.pow(i,3)-2),easeInQuint:i=>Math.pow(i,5),easeOutQuint:i=>Math.pow(i-1,5)+1,easeInOutQuint:i=>(i/=ke)<1?ke*Math.pow(i,5):ke*(Math.pow(i-2,5)+2),easeInSine:i=>-Math.cos(i*(Math.PI/2))+1,easeOutSine:i=>Math.sin(i*(Math.PI/2)),easeInOutSine:i=>-ke*(Math.cos(Math.PI*i)-1),easeInExpo:i=>i===0?0:Math.pow(2,10*(i-1)),easeOutExpo:i=>i===1?1:-Math.pow(2,-10*i)+1,easeInOutExpo:i=>i===0?0:i===1?1:(i/=ke)<1?ke*Math.pow(2,10*(i-1)):ke*(-Math.pow(2,-10*--i)+2),easeInCirc:i=>-(Math.sqrt(1-i*i)-1),easeOutCirc:i=>Math.sqrt(1-Math.pow(i-1,2)),easeInOutCirc:i=>(i/=ke)<1?-ke*(Math.sqrt(1-i*i)-1):ke*(Math.sqrt(1-(i-=2)*i)+1),easeOutBounce:i=>i<$p?di*i*i:i<Lp?di*(i-=Bp)*i+Vp:i<Hp?di*(i-=Op)*i+zp:di*(i-=jp)*i+Np,easeInBack:i=>i*i*((Qr+1)*i-Qr),easeOutBack:i=>(i=i-1)*i*((Qr+1)*i+Qr)+1,easeInOutBack:i=>{let e=j_;return(i/=ke)<1?ke*(i*i*(((e*=gf)+1)*i-e)):ke*((i-=2)*i*(((e*=gf)+1)*i+e)+2)},elastic:i=>-1*Math.pow(4,-8*i)*Math.sin((i*6-1)*(2*Math.PI)/2)+1,swingFromTo:i=>{let e=V_;return(i/=ke)<1?ke*(i*i*(((e*=gf)+1)*i-e)):ke*((i-=2)*i*(((e*=gf)+1)*i+e)+2)},swingFrom:i=>i*i*((Qr+1)*i-Qr),swingTo:i=>(i-=1)*i*((Qr+1)*i+Qr)+1,bounce:i=>i<$p?di*i*i:i<Lp?di*(i-=Bp)*i+Vp:i<Hp?di*(i-=Op)*i+zp:di*(i-=jp)*i+Np,bouncePast:i=>i<$p?di*i*i:i<Lp?2-(di*(i-=Bp)*i+Vp):i<Hp?2-(di*(i-=Op)*i+zp):2-(di*(i-=jp)*i+Np),easeFromTo:i=>(i/=ke)<1?ke*Math.pow(i,4):-ke*((i-=2)*Math.pow(i,3)-2),easeFrom:i=>Math.pow(i,4),easeTo:i=>Math.pow(i,.25)},Se._$name="FunctionHelper";var{isArray:HD}=Array,{hasOwnProperty:z_}=Object.prototype,jD={thisObj:1,detachable:1,once:1,detacher:1,prio:1,args:1,expires:1,buffer:1,throttle:1,name:1,$internal:1},VD=(i,e)=>e.prio-i.prio,Ve=i=>{var e;return e=class extends(i||$){constructor(){super(...arguments),v(this,"eventsSuspended",null)}static get declarable(){return["deprecatedEvents"]}static setupDeprecatedEvents(t,r){const n=r.getInherited("deprecatedEvents"),s=t.deprecatedEvents;for(const a in s)n[a.toLowerCase()]=n[a]=s[a]}static get configurable(){return{listeners:{value:null,$config:{merge(t,r){if(t!==null){if(!t)return r;r&&(t=t?[t]:[],t.push[HD(r)?"apply":"call"](t,r))}return t}}},internalListeners:null,bubbleEvents:null}}destroy(){this.trigger("beforeDestroy"),super.destroy()}construct(t,...r){(this.configuredListeners=t==null?void 0:t.listeners)&&(t=X.assign({},t),delete t.listeners),super.construct(t,...r),this.processConfiguredListeners()}processConfiguredListeners(){if(this.configuredListeners){const t=this,{isConfiguring:r}=t;t.isConfiguring=!1,t.listeners=t.configuredListeners,t.configuredListeners=null,t.isConfiguring=r}}doDestroy(){this.trigger("destroy"),this.removeAllListeners(!1),super.doDestroy()}static setupClass(t){super.setupClass(t),e.prototype.onListen.$nullFn=!0,e.prototype.onUnlisten.$nullFn=!0}addListener(t,r,n){var s;if(HD(t)){for(let l=0,{length:d}=t;l<d;l++)this.addListener(t[l],r);return}const a=this,o=a.$meta.getInherited("deprecatedEvents");if(typeof t=="string")return a.addListener({[t]:r,detachable:r.detachable!==!1,thisObj:n});{r=t.thisObj=t.thisObj!==void 0?t.thisObj:r;for(const u in t)if(!jD[u]&&t[u]!=null){const h=u.toLowerCase(),f=o==null?void 0:o[h],g=a.eventListeners||(a.eventListeners={}),m=H.asArray(t[u]);if(f){const{product:p,invalidAsOfVersion:y,message:b}=f;de.deprecate(p,y,b)}for(const p of m){const y=p.expires||t.expires,b={fn:typeof p=="object"?p.fn:p,thisObj:p.thisObj!==void 0?p.thisObj:r,args:p.args||t.args,prio:p.prio!==void 0?p.prio:t.prio!==void 0?t.prio:0,once:p.once!==void 0?p.once:t.once!==void 0?t.once:!1,buffer:p.buffer||t.buffer,throttle:p.throttle||t.throttle,$internal:t.$internal,catchAll:u==="catchAll"};if(y){const{alt:D}=y,S=D?y.delay:y,x=t.name||u,R=()=>{a.un(h,b),D&&!b.called&&a.callback(D,r)};a.isDelayable?a.setTimeout({fn:R,name:x,cancelOutstanding:!0,delay:S}):globalThis.setTimeout(R,S)}let C=g[h]||(g[h]=[]);C.$firing&&(g[h]=C=C.slice()),C.splice(H.findInsertionIndex(b,C,VD,C.length),0,b),!a.onListen.$nullFn&&C.length<2&&a.onListen(h),(s=a.afterAddListener)==null||s.call(a,h,b)}}t.relayAll&&a.relayAll(t.relayAll),r&&r!==a&&a.attachAutoDetacher(t,r);const l=t.detachable!==!1,d=t.name,c=t.expires||l||d?()=>{a.isDestroyed||a.removeListener(t,r)}:null;if(c&&(c.eventer=a,c.listenerName=d,d&&(r!=null&&r.trackDetacher)&&r.trackDetacher(d,c),t.expires&&a.delay(c,isNaN(t.expires)?t.expires.delay:t.expires,d),l))return c}}on(t,r,n){return this.addListener(t,r,n)}ion(t){return t.$internal=!0,this.on(t)}un(...t){this.removeListener(...t)}updateInternalListeners(t,r){r==null||r.detach(),t&&(t.detach=this.ion(t))}get listeners(){return this.eventListeners}changeListeners(t){if(this.isConfiguring)this.getConfig("internalListeners"),t&&this.on(t,this);else{if(Array.isArray(t))for(let r=0,n=t[0],{length:s}=t;r<s;n=t[++r])"thisObj"in n||(t[r]=X.assign({thisObj:this},n));else t&&!("thisObj"in t)&&(t=X.assign({thisObj:this},t));return t}}updateListeners(t,r){r&&this.un(r),t&&this.on(t)}removeListener(t,r=t.thisObj,n){const s=this;if(typeof t=="string")return s.removeListener({[t]:r},n);Object.entries(t).forEach(([a,o])=>{var l;if(!jD[a]&&o!=null){a=a.toLowerCase();const{eventListeners:d}=s,c=s.findListener(a,o,r);if(c>=0){let u=d[a];(l=s.afterRemoveListener)==null||l.call(s,a,u[c]),u.length>1?(u.$firing&&(d[a]=u=u.slice()),u.splice(c,1)):(delete d[a],s.onUnlisten.$nullFn||s.onUnlisten(a))}}}),t.thisObj&&!t.thisObj.isDestroyed&&s.detachAutoDetacher(t)}findListener(t,r,n){var s;const a=(s=this.eventListeners)==null?void 0:s[t],o=r.fn||r,l=r.thisObj||n;if(a){for(let d,c=0,{length:u}=a;c<u;c++)if(d=a[c],d.fn===o&&d.thisObj===l)return c}return-1}hasListener(t){var r;return!!((r=this.eventListeners)!=null&&r[t==null?void 0:t.toLowerCase()])}relayAll(t,r,n=!0){this.relayAllTargets||(this.relayAllTargets=[]);const{relayAllTargets:s}=this;t.ion({beforeDestroy:({source:a})=>{a===t&&s.filter(l=>l.through===t).forEach(l=>H.remove(s,l))}}),s.push({through:t,prefix:r,transformCase:n})}removeAllListeners(t=!0){var r;const n=this.eventListeners;let s,a;for(const o in n){const l=n[o];for(s=l.length;s-- >0;){const d=l[s];(!d.$internal||!t)&&(this.removeListener(o,d),a=d.thisObj,(r=a==null?void 0:a.untrackDetachers)==null||r.call(a,this))}}}relayEvents(t,r,n="",s){const a={detachable:!0,thisObj:this};return r.forEach(o=>{n&&(o=O.capitalize(o)),a[o]=(l,...d)=>(s&&(l=Object.assign({},l,{source:this})),this.trigger(n+o,l,...d))}),t.on(a)}onListen(){}onUnlisten(){}destructorInterceptor(){const{autoDetachers:t,target:r,oldDestructor:n}=this;for(let s=0;s<t.length;s++){const{dispatcher:a,config:o}=t[s];a.isDestroyed||a.removeListener(o,r)}n.call(r)}attachAutoDetacher(t,r){const n=t.thisObj||r,s="doDestroy"in n?"doDestroy":"destroy";if(s in n){let{$autoDetachers:a}=n;a||(n.$autoDetachers=a=[]),n.$oldDestructor||(n.$oldDestructor=n[s],n[s]=this.destructorInterceptor.bind({autoDetachers:a,oldDestructor:n.$oldDestructor,target:n})),a.push({config:t,dispatcher:this})}else n[s]=()=>{this.removeListener(t)}}detachAutoDetacher(t){const r=t.thisObj;r.$oldDestructor&&!r.isDestroying&&(H.remove(r.$autoDetachers,r.$autoDetachers.find(n=>n.config===t&&n.dispatcher===this)),r.$autoDetachers.length||(r["doDestroy"in r?"doDestroy":"destroy"]=r.$oldDestructor,r.$oldDestructor=null))}once(t,r){return this.ion({[t]:()=>this.callback(r),once:!0})}await(t,r={checkLog:!0,resetLog:!0,args:null}){const n=this;r===!1&&(r={checkLog:!1});const{args:s}=r;return new Promise(a=>{var o;if(r.checkLog&&((o=n._triggered)!=null&&o[t])&&(a(),r.resetLog&&n.clearLog(t)),s){const l=n.on({[t]:(...d)=>{(typeof s=="function"?s(...d):Object.keys(s).every(u=>u in d[0]&&d[0][u]===s[u]))&&(a(...d),r.resetLog&&n.clearLog(t),l())},prio:-1e4})}else n.on({[t]:(...l)=>{a(...l),r.resetLog&&n.clearLog(t)},prio:-1e4,once:!0})})}clearLog(t){this._triggered&&(t?delete this._triggered[t]:this._triggered={})}trigger(t,r){var n,s,a,o;const l=this,d=t.toLowerCase(),{eventsSuspended:c,relayAllTargets:u,callOnFunctions:h}=l;let f=(n=l.eventListeners)==null?void 0:n[d],g;if(l._triggered||(l._triggered={}),l._triggered[t]=!0,c)return c.shouldQueue&&c.queue.push(arguments),!0;if((s=l.eventListeners)!=null&&s.catchall&&((f=f?f.slice():[]).push(...l.eventListeners.catchall),f.sort(VD)),!f&&!u&&!h)return!0;if(r?"source"in r||(Object.isExtensible(r)?r.source=l:r=Object.setPrototypeOf({source:l},r)):r={source:l},r.type!==d&&(r.constructor!==Object?Reflect.defineProperty(r,"type",{get:()=>d}):r.type=d),r.eventName=t,!("bubbles"in r)&&((a=l.bubbleEvents)!=null&&a[t])&&(r.bubbles=l.bubbleEvents[t]),h){const p="on"+O.capitalize(t);if(p in l){const y=l[p]?l.callback(l[p],l,[r]):!0;let b;if(X.isPromise(y)?(g||(g=[])).push(y):b=y===!1||b,!l.isDestroyed&&z_.call(l,p)&&!((o=l.pluginFunctionChain)!=null&&o[p])){const C=Object.getPrototypeOf(l);if(p in C){const D=C[p].call(l,r);if(X.isPromise(D)?(g||(g=[])).push(D):b=D===!1||b,l.isDestroyed)return}}if(b)return!1}}let m;if(f){let p=0,y=!1;for(f.$firing=!0,p;p<f.length&&!l.isDestroyed&&!y;p++){const b=f[p];if(m===!1&&!b.$internal)continue;let C,D=b.thisObj;if(!D||!D.isDestroyed){if(b.called=!0,b.once&&l.removeListener(d,b),typeof b.fn=="string"){if(D&&(C=D[b.fn]),!C){const x=l.resolveCallback(b.fn);C=x.handler,D=x.thisObj}}else C=b.fn;if(b.buffer){if(!b.bufferFn){const x=Number(b.buffer);if(typeof x!="number"||isNaN(x))throw new Error(`Incorrect type for buffer, got "${x}" (expected a Number)`);b.bufferFn=Se.createBuffered(C,x,D,b.args)}C=b.bufferFn}if(b.throttle){const x=Number(b.throttle);if(typeof x!="number"||isNaN(x))throw new Error(`Incorrect type for throttle, got "${x}" (expected a Number)`);b.throttledFn||(b.throttledFn=Se.createThrottled(C,x,D,b.args)),C=b.throttledFn}const S=C.call(D||l,...b.args||[],r);m!==!1&&(m=S),b.$internal&&S===!1&&(y=!0),X.isPromise(S)&&(S.$internal=b.$internal,(g||(g=[])).push(S))}}if(f.$firing=!1,y)return!1}return u==null||u.forEach(p=>{let y=t;if(p.transformCase&&(y=O.capitalize(y)),p.prefix&&(y=p.prefix+y),p.through.trigger(y,r)===!1)return!1}),r.bubbles&&l.owner&&!l.owner.isDestroyed?l.owner.trigger(t,r):(g=g==null?void 0:g.filter(p=>m!==!1||p.$internal),g!=null&&g.length?new Promise(p=>{Promise.all(g).then(y=>{const b=!y.some(C=>C===!1);p(b)})}):m!==!1)}suspendEvents(t=!1){const r=this.eventsSuspended||(this.eventsSuspended={shouldQueue:t,queue:[],count:0});r.count++}resumeEvents(){const t=this.eventsSuspended;if(t&&--t.count===0&&(this.eventsSuspended=null,t.shouldQueue))for(const r of t.queue)this.trigger(...r);return!this.eventsSuspended}},v(e,"$name","Events"),e},Ei=class{static animationFrame(){return new Promise(i=>{requestAnimationFrame(i)})}static sleep(i){return new Promise(e=>{setTimeout(()=>{e()},i)})}static yield(){return Promise.resolve()}};Ei._$name="AsyncHelper";var Wp,zD=["border-top-width","border-right-width","border-bottom-width","border-left-width"],N_=["margin-top","margin-right","margin-bottom","margin-left"],W_=["padding-top","padding-right","padding-bottom","padding-left"],Jr={t:"border-top-width",r:"border-right-width",b:"border-bottom-width",l:"border-left-width"},mf={t:"padding-top",r:"padding-right",b:"padding-bottom",l:"padding-left"},ND=/^([trblc])(\d*)-([trblc])(\d*)$/i,U_=/^([trblc])(\d*)$/i,pf=["top","right","bottom","left"],$d={t:0,r:1,b:2,l:3},Up=["b-t","l-r","t-b","r-l"],G_={bt:1,tb:1,lr:2,rl:2},WD=Object.freeze([0,0]),Y_=["width","height"],Gp=(i,e=i,t=i,r=e)=>Array.isArray(i)?Gp.apply(null,i):[i,e,t,r],UD=(i,e,t,r)=>Array.isArray(i)?Gp.apply(null,i):typeof i.top=="number"?[i.top,i.right,i.bottom,i.left]:[i,e,t,r],GD=(i,e)=>{const t=ND.exec(i),r=t[1],n=t[3],s=parseInt(t[2]||50),a=parseInt(t[4]||50),o=e&&!($d[r]&1)?100-s:s,l=e&&!($d[n]&1)?100-a:a,d=G_[r+n];return{myAlignmentPoint:r+o,myEdge:r,myOffset:o,targetAlignmentPoint:n+l,targetEdge:n,targetOffset:l,startZone:$d[n],edgeAligned:d}},q_=i=>`${pf[($d[i.myEdge]+2)%4][0]}${i.myOffset}-${pf[($d[i.targetEdge]+2)%4][0]}${i.targetOffset}`,K_=i=>i==null?WD:typeof i=="number"?[i,i]:i,k=class Kt{constructor(e,t,r,n,s=!0){v(this,"isRectangle",!0),s&&(T.assertNumber(e,"Rectangle.x"),T.assertNumber(t,"Rectangle.y"),T.assertNumber(r,"Rectangle.width",!0),T.assertNumber(n,"Rectangle.height",!0));const a=this;r<0&&(e+=r,r=-r),n<0&&(t+=n,n=-n),a._x=e,a._y=t,a._width=r,a._height=n}static from(e,t,r){if(typeof e=="string"?e=document.querySelector(e):(e==null?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE&&(e=e.host||e.ownerDocument),typeof t=="string"&&(t=document.querySelector(t)),e==null||e.isRectangle)return e;if(e=e.element||e,r===void 0&&typeof t=="boolean"&&(r=t,t=null),!(t!=null&&t.isRectangle))if(t){let{scrollLeft:d,scrollTop:c}=t;K.isSafari&&t===document.body&&(d=c=0),t=Kt.from(t).translate(-d,-c)}else Wp||(Wp=new Kt(0,0,0,0)),t=Wp;const n=e===document||e===globalThis,s=e===document.body&&document.body.offsetHeight===0,a=s&&e.getBoundingClientRect(),o=s?new Kt(a.left,a.top,a.width,document.body.parentElement.scrollHeight):n?new Kt(0,0,globalThis.innerWidth,globalThis.innerHeight):e.getBoundingClientRect(),l=r||n?[0,0]:[globalThis.pageXOffset,globalThis.pageYOffset];return new Kt(o.left+l[0]-t.x,o.top+l[1]-t.y,o.width,o.height)}static fromScreen(e,t){return Kt.from(e,t,!0)}static inner(e,t,r=!1){const n=this.from(e,t,r);if(document.body.contains(e)){const s=E.getStyleValue(e,zD);n.x+=parseFloat(s[Jr.l]),n.y+=parseFloat(s[Jr.t]),n.right-=parseFloat(s[Jr.r]),n.bottom-=parseFloat(s[Jr.b])}return n}static content(e,t,r=!1){const n=this.from(e,t,r);if(document.body.contains(e)){const s=E.getStyleValue(e,zD),a=E.getStyleValue(e,W_);n.x+=parseFloat(s[Jr.l])+parseFloat(a[mf.l]),n.y+=parseFloat(s[Jr.t])+parseFloat(a[mf.t]),n.right-=parseFloat(s[Jr.r])+parseFloat(a[mf.r]),n.bottom-=parseFloat(s[Jr.b])+parseFloat(a[mf.b])}return n}static client(e,t,r=!1,n,s){const a=this.content(e,t,r),o=E.scrollBarWidth;let l;return o&&!e.classList.contains("b-hide-scroll")&&(e.scrollHeight>e.clientHeight&&E.getStyleValue(e,"overflow-y")!=="hidden"&&(l=parseFloat(E.getStyleValue(e,"padding-right")),a.right+=l-Math.max(l,o)),e.scrollWidth>e.clientWidth&&E.getStyleValue(e,"overflow-x")!=="hidden"&&(l=parseFloat(E.getStyleValue(e,"padding-bottom")),a.bottom+=l-Math.max(l,o))),n&&this.clipStickies(a,e,t,r=!1,s),a}static clipStickies(e,t,r,n=!1,s){let a=[...t.children].filter(o=>E.getStyleValue(o,"position")==="sticky");if(s){const o=s&&Kt.from(s,r,n);a=a.filter(l=>!l.contains(s)&&o.intersect(Kt.from(l)))}for(let o=0,{length:l}=a;o<l;o++){const d=a[o],c=this.fromScreen(d);parseFloat(E.getStyleValue(d,"left"))===0?e.x+=c.width:parseFloat(E.getStyleValue(d,"right"))===0?e.right-=c.width:parseFloat(E.getStyleValue(d,"top"))===0?e.y+=c.height:parseFloat(E.getStyleValue(d,"bottom"))===0&&(e.bottom-=c.height)}return e}static outer(e,t,r=!1){const n=this.from(e,t,r);if(document.body.contains(e)){const s=E.getStyleValue(e,N_);n.x-=parseFloat(s["margin-left"]),n.y-=parseFloat(s["margin-top"]),n.right+=parseFloat(s["margin-right"]),n.bottom+=parseFloat(s["margin-bottom"])}return n}static union(...e){let{x:t,y:r,right:n,bottom:s}=e[0],a;if(e.length>1)for(let o=1;o<e.length;o++)a=e[o],a.x<t&&(t=a.x),a.y<r&&(r=a.y),a.right>n&&(n=a.right),a.bottom>s&&(s=a.bottom);return new Kt(t,r,n-t,s-r)}roundPx(e=globalThis.devicePixelRatio||1){const t=this;return t._x=E.roundPx(t._x,e),t._y=E.roundPx(t._y,e),t._width=E.roundPx(t._width,e),t._height=E.roundPx(t._height,e),t}static get $$name(){return hasOwnProperty.call(this,"$name")&&this.$name||hasOwnProperty.call(this,"_$name")&&this._$name||this.name}get $$name(){return this.constructor.$$name}clone(){const e=this,t=new Kt(e.x,e.y,e.width,e.height,!1);return t.isAlignRectangle=e.isAlignRectangle,t.minHeight=e.minHeight,t.minWidth=e.minWidth,t}contains(e){const t=this;return e.isRectangle?e._x>=t._x&&e._y>=t._y&&e.right<=t.right&&e.bottom<=t.bottom:!1}intersect(e,t=!1,r=!1){const n=this,s=Math.max(n.y,e.y),a=Math.min(n.right,e.right),o=Math.min(n.bottom,e.bottom),l=Math.max(n.x,e.x);return(r?o>=s&&a>=l:o>s&&a>l)?t?!0:new Kt(l,s,a-l,o-s):!1}equals(e,t=!1){const r=t?n=>Math.round(n):n=>n;return e.isRectangle&&r(e.x)===r(this.x)&&r(e.y)===r(this.y)&&r(e.width)===r(this.width)&&r(e.height)===r(this.height)}translate(e,t){return this._x+=e||0,this._y+=t||0,this}moveTo(e,t){return e!=null&&(this._x=e),t!=null&&(this._y=t),this}getDelta(e){return[e.x-this.x,e.y-this.y]}get center(){const e=new xi(this.x+this.width/2,this.y+this.height/2,0,0);return e.target=this.target,e}set x(e){const t=e-this._x;this._x=e,this._width-=t}get x(){return this._x}get start(){return this.left}set left(e){this.x=e}get left(){return this.x}set top(e){this.y=e}get top(){return this.y}set y(e){const t=e-this._y;this._y=e,this._height-=t}get y(){return this._y}set width(e){T.assertNumber(e,"Rectangle.width",!this._allowNegative),this._width=e}get width(){return this._width}set height(e){T.assertNumber(e,"Rectangle.height",!this._allowNegative),this._height=e}get height(){return this._height}set right(e){this._width=e-this._x}get right(){return this._x+this._width}get end(){return this.right}set bottom(e){this._height=e-this._y}get bottom(){return this._y+this._height}getStart(e,t=!0){return t?e?this.right:this.left:this.top}getEnd(e,t=!0){return t?e?this.left:this.right:this.bottom}get area(){return this.width*this.height}set minWidth(e){const t=this;isNaN(e)?t._minWidth=null:(t._minWidth=Number(e),t.isAlignRectangle||(t.width=Math.max(t.width,t._minWidth)))}get minWidth(){return this._minWidth}set minHeight(e){const t=this;isNaN(e)?t._minHeight=null:(t._minHeight=Number(e),t.isAlignRectangle||(t.height=Math.max(t.height,t._minHeight)))}get minHeight(){return this._minHeight}adjust(e,t,r,n,s){const a=this;return a._allowNegative=s,a.x+=e,a.y+=t,a.width+=r,a.height+=n,a}inflate(e,t=e,r=e,n=t){return[e,t,r,n]=UD(e,t,r,n),this.adjust(-n,-e,t,r)}deflate(e,t=e,r=e,n=t){return[e,t,r,n]=UD(e,t,r,n),this.adjust(n,e,-t,-r)}constrainTo(e,t){const r=this,n=r.height,s=r.y,a=r.minWidth||r.width,o=r.minHeight||r.height;if(r.height>=e.height){if(t&&o>e.height)return!1;r._y=e.y,r.height=e.height}if(r.width>=e.width){if(t&&a>e.width)return r.y=s,r.height=n,!1;r._x=e.x,r.width=e.width}return r.translate.apply(r,r.constrainVector=[Math.min(e.right-r.right,0),Math.min(e.bottom-r.bottom,0)]),r.translate(Math.max(e.x-r.x,0),Math.max(e.y-r.y,0)),r}alignTo(e){let t=this.clone(),{target:r,constrainTo:n,constrainPadding:s}=e,a,o,l,d;if(r&&!r.isRectangle&&(r=Kt.from(r.element?r.element:r)),n){if(!n.isRectangle){d=n===globalThis||n===document;const _="ignorePageScroll"in e?e.ignorePageScroll:!d;n=Kt.from(n.element?n.element:n,null,_)}s&&(s=Gp(s),s[0]=Math.min(s[0],r.top),s[1]=Math.min(s[1],n.right-r.right),s[2]=Math.min(s[2],n.bottom-r.bottom),s[3]=Math.min(s[3],r.left),n=n.deflate.apply(n.clone(),s))}const c=this,u=K_(e.offset),{align:h,axisLock:f,anchorSize:g,anchorPosition:m,matchSize:p,position:y,rtl:b}=e,C=r&&r.width<2&&r.height<2,D=GD(h,b),S=n&&n.clone(),x=[],R=[{zone:o=D.startZone,align:h}],M=p&&Y_[D.startZone&1],I=c[M];if(M&&f?t[M]=p==="min"?Math.max(t.width,r[M]):r[M]:!D.edgeAligned&&p&&(t.width=r.width,t.height=r.height),n&&t.constrainTo(n),n&&D.startZone!=null)if(f)R.push({zone:o=(o+2)%4,align:q_(D)}),f==="flexible"&&(R.push({zone:o=(D.startZone+1)%4,align:Up[o]}),R.push({zone:o=(o+2)%4,align:Up[o]}));else for(let _=1;_<4;_++)R.push({zone:o=(o+1)%4,align:Up[o]});if(m){const _=D.startZone&1?"y":"x";a={[_]:m[_],edge:pf[(D.startZone+2)%4]}}if(S&&r&&(S.adjust(-r.width,-r.height,r.width,r.height),r.constrainTo(S)),t.minWidth=c.minWidth,t.minHeight=c.minHeight,y)t.moveTo(y.x,y.y),t.translate.apply(t,u),n&&t.constrainTo(n);else{const _=D.myEdge==="c"||D.targetEdge==="c",P=g&&!_?[g[1]+u[0],g[1]+u[1]]:u,A=r.getAlignmentPoint(D.targetAlignmentPoint),L=r.getAlignmentPoint(D.targetAlignmentPoint,P);let F=t.getAlignmentPoint(D.myAlignmentPoint),N=!C&&t.clone().translate(A[0]-F[0],A[1]-F[1]).intersect(r,!0);if(t.translate(L[0]-F[0],L[1]-F[1]),N)t.translate(-(L[0]-F[0]),-(L[1]-F[1])),F=t.getAlignmentPoint(D.myAlignmentPoint),t.translate(A[0]-F[0],A[1]-F[1]),t.translate(...P),n&&t.constrainTo(n),l=D.startZone;else if(n&&!n.contains(t)){const Y=t.clone(),G=[];let U,Z;a=null,x[0]=U=n.clone(),U.bottom=r.y-P[1],x[1]=U=n.clone(),U.x=r.right+P[0],x[2]=U=n.clone(),U.y=r.bottom+P[1],x[3]=U=n.clone(),U.right=r.x-P[0];for(let fe=0;fe<R.length;fe++){if(M&&fe===2&&(t[M]=I),U=x[l=R[fe].zone],t=t.alignTo({target:r,offsets:P,align:R[fe].align}),t.constrainTo(U,!0)&&(G.push({result:t,zone:l}),!Z||t.width<c.width||t.height<c.height)){t.align=R[fe].align;break}if(!Z||U.area>Z.area){const J=t.clone();switch(l){case 0:J.moveTo(null,U.bottom-J.height);break;case 1:J.moveTo(U.left);break;case 2:J.moveTo(null,U.top);break;case 3:J.moveTo(U.right-J.width);break}Z={area:U.area,result:J,zone:l}}}G.length?(G.length>1&&!f&&G.sort((fe,J)=>{const me=Math.sqrt((Y.x-fe.result.x)**2+(Y.y-fe.result.y)**2),Q=Math.sqrt((Y.x-J.result.x)**2+(Y.y-J.result.y)**2);return me-Q}),t=G[0].result,l=G[0].zone):(t=Z.result,l=Z.zone,d&&t.constrainTo(n))}else l=D.startZone;if(C?t.overlap=N=!1:t.overlap=N=t.intersect(r,!0),t.zone=l,g&&!N){if(!a){const Y=l&1,G=Y?"y":"x",U=Y?"bottom":"right",Z=Math.max(r[G],t[G]),fe=Math.min(r[U],t[U]);let J=Z+(fe-Z)/2-g[0]/2;const me=J+g[0];me>t[U]&&(J-=me-t[U]),J<t[G]&&(J+=t[G]-J),a={[G]:J-t[G],edge:pf[(l+2)%4]}}t.anchor=a}}return t}getAlignmentPoint(e,t=WD){e=String(e);const r=this,n=U_.exec(e)||ND.exec(e),s=n&&n[1].toLowerCase(),a=n&&Math.min(Math.max(parseInt(n[2]||50),0),100)/100;switch(s){case"t":return[r.x+r.width*a,r.y-t[1]];case"r":return[r.right+t[0],r.y+r.height*a];case"b":return[r.x+r.width*a,r.bottom+t[1]];case"l":return[r.x-t[0],r.y+r.height*a];case"c":return[r.x+r.width/2,r.y+r.height/2]}}highlight(){const e=this,t=E.createElement({parent:document.body,style:`position:absolute;z-index:9999999;pointer-events:none;
                            left:${e.x}px;top:${e.y}px;width:${e.width}px;height:${e.height}px`});return E.highlight(t).then(()=>t.remove())}visualize(e,t){const r=this,n=T.merge({style:{"inset-inline-start":`${r.x}px`,top:`${r.y}px`,width:`${r.width}px`,height:`${r.height}px`,pointerEvents:"none",...e.class?{}:{position:"absolute","z-index":9999999}}},e);return t?n:E.createElement(n)}toString(e=","){return[`${this.top}px`,`${this.right}px`,`${this.bottom}px`,`${this.left}px`].join(e)}},xi=class extends k{static from(i,e=!0){const t=e?"client":"screen";i.changedTouches&&(i=i.changedTouches[0]);const r=i[`${t}X`],n=i[`${t}Y`];return new this(r,n)}constructor(i,e){super(i,e,0,0)}constrain(i){return this.x=Math.min(Math.max(this.x,i.x),i.right-1),this.y=Math.min(Math.max(this.y,i.y),i.bottom-1),this}toArray(){return[this.x,this.y]}};k._$name="Rectangle";var os=Symbol("value"),YD=Symbol("length"),se=class Vi{static change(e,t,r,n="string"){r=Vi.normalize(r,"object");const s=Vi.normalize(e,"array").filter(a=>!r[a]);if(t){t=Vi.normalize(t,"array");for(let a=0;a<t.length;++a)s.includes(t[a])||s.push(t[a])}return Vi.normalize(s,n)}static from(e,t){return e&&(e.isDomClassList?t=t!=null?t:!0:(t=t!=null?t:X.isObject(e)&&!X.isEmpty(e),e=new Vi(e)),!e.value&&!t&&(e=null)),e||(t?new Vi:null)}static normalize(e,t="string"){e=e||"";const r=typeof e,n=t==="array",s=t==="object",a=!n&&!s;let o=r==="string",l,d,c;for(r==="object"&&(e.nodeType===Element.ELEMENT_NODE&&typeof e.getAttribute=="function"?(e=e.getAttribute("class")||"",o=!0):e!=null&&e.isDomClassList?e=e.values:e instanceof DOMTokenList?e=Array.from(e):e instanceof Map?e=Array.from(e.keys()).filter(u=>e.get(u)):e instanceof Set?e=Array.from(e):Array.isArray(e)||(e=X.getTruthyKeys(e))),o&&(e=[...new Set(O.split(e))]),d=e.length;d-- >0;)l=e[d],l.length?l.includes(" ")&&e.splice(d,1,...O.split(l)):e.splice(d,1);if(n)c=e;else if(a)c=e.join(" ");else for(c=Object.create(null),d=0;d<e.length;++d)c[e[d]]=!0;return c}constructor(...e){this.process(1,e)}clear(){for(const e in this)this[e]=!1;return this}set(...e){return this.clear().process(1,e)}get isDomClassList(){return!0}clone(){return new Vi(this)}contains(e){return typeof e=="string"&&e?!!this[e]:!1}toString(){return this.length?`${this.value} `:""}toJSON(){return this.toString()}trim(){return this.value}isEqual(e){const t=Vi.normalize(e,"array"),r=t.length;if(this.length===r){for(let n=0;n<r;n++)if(!this[t[n]])return!1;return!0}return!1}get value(){let e=this[os],t;return e==null&&(t=X.getTruthyKeys(this),this[YD]=t.length,this[os]=e=t.join(" ")),e}set value(e){const t=this,r=Object.keys(t),n=r.length;for(let s=0;s<n;s++)delete t[r[s]];e?t.process(1,[e]):delete t[os]}get values(){return X.getTruthyKeys(this)}get length(){return this.value?this[YD]:0}process(e,t){for(let r,n,s=0;s<t.length;s++)if(t[s])if(r=t[s],r.isDomClassList||X.isObject(r))for(n in r)this[n]=e?r[n]:!r[n];else for(r=Vi.normalize(t[s],"array"),n=0;n<r.length;++n)this[r[n]]=e;return delete this[os],this}assign(e){for(const t in e)!this[t]!=!e[t]&&(this[t]=e[t],delete this[os]);return this}assignTo(e){const t=e.nodeType===Element.ELEMENT_NODE?e.classList:e,r=Vi.from(t);r.add(this),t.value=r.value}add(...e){return this.process(1,e)}remove(...e){return this.process(0,e)}toggle(e,t=!this[e]){if(t=!!t,!!this[e]!==t)return this[e]=t,delete this[os],!0}split(){return X.getTruthyKeys(this)}forEach(e){return X.getTruthyKeys(this).forEach(e)}};se.prototype[os]=null,se._$name="DomClassList";var X_=["clientX","clientY","pageX","pageY","screenX","screenY"],Z_={element:1,thisObj:1,once:1,delegate:1,delay:1,capture:1,passive:1,throttled:1,autoDetach:1,expires:1,block:1,raw:1,fromGlobal:1},Q_={Spacebar:"Space",Del:"Delete",Esc:"Escape",Left:"ArrowLeft",Up:"ArrowUp",Right:"ArrowRight",Down:"ArrowDown"},J_={Control:"ctrl",Alt:"alt",Shift:"shift",Meta:"meta"},eP=/^(ctrl|shift|alt|meta)$/,tP=["altKey","bubbles","button","buttons","cancelable","clientX","clientY","ctrlKey","layerX","layerY","metaKey","pageX","pageY","returnValue","screenX","screenY","shiftKey"],iP=(...i)=>i.reduce((e,t)=>{for(let r=0,n=e.length;r<n;++r)e.push(r?`${e[r]}+${t}`:t);return e},[""]),rP=Object.fromEntries("abcdefghijklmnopqrstuvwxyz".split("").map(i=>[i,i.toUpperCase()])),nP=iP("Ctrl","Alt","Meta","Shift"),qD=i=>nP[(i.ctrlKey&&1)|(i.altKey&&2)|(i.metaKey&&4)|(i.shiftKey&&8)],sP=i=>{const e=[qD(i)],{code:t,key:r}=i;return e[e[0]?1:0]=t!=null&&t.includes("Numpad")?t:rP[r]||r,e.join("+")},{isSafari:KD}=K,Yp=new WeakMap,vf=i=>(i==null?void 0:i.nodeType)===Element.TEXT_NODE?i.parentElement:i,qp=class kI{static normalizeEvent(e){return T.copyPropertiesIf(e,e.changedTouches[0]||e.touches[0],X_)}static copyEvent(e,t){return T.copyProperties(e,t,tP)}static getXY(e){return e.touches&&(e=e.touches[0]),[e.clientX,e.clientY]}static getDistanceBetween(e,t,r){const n=at.getXY(e),s=at.getXY(t),a=n[0]-s[0],o=n[1]-s[1];return r!=null&&r.x?a:r!=null&&r.y?o:Math.sqrt(Math.pow(a,2)+Math.pow(o,2))}static getPagePoint(e){return new xi(e.pageX,e.pageY)}static getClientPoint(e){return new xi(e.clientX,e.clientY)}static addListener(e,t,r,n){return e.nodeType?typeof t=="string"?n=Object.assign({element:e,[t]:r},n):n=Object.assign({element:e},t):n=e,at.on(n)}static on(e){const t=e.element,r=e.thisObj,n=[];for(const a in e)if(!Z_[a]){let o=e[a];typeof o!="object"&&(o={handler:o});const l=o.element||t;n.push(at.addElementListener(l,a,o,e))}const s=()=>{for(let a,o=0;o<n.length;o++)a=n[o],at.removeEventListener(a[0],a[1],a[2]);n.length=0};return r&&e.autoDetach!==!1&&(r.doDestroy=Se.createInterceptor(r.doDestroy,s,r)),s}static addElementListener(e,t,r,n){const s=at.createHandler(e,t,r,n),{spec:a}=s,o=r.expires||n.expires,l=a.capture!=null||a.passive!=null?{capture:a.capture,passive:a.passive}:void 0;if(e.addEventListener(t,s,l),o){const d=r.thisObj||n.thisObj,c=d!=null&&d.isDelayable?d:globalThis,{alt:u}=o,h=u?o.delay:o,{spec:f}=s;f.expires=o,f.timerId=c[typeof h=="number"?"setTimeout":"requestAnimationFrame"](()=>{f.timerId=null,at.removeEventListener(e,t,s),u&&!s.called&&(typeof u=="string"?d[u]:u).call(d)},h,`listener-timer-${performance.now()}`)}return[e,t,s,l]}static getComposedPathTarget(e){var t;return e.composedPath()[0]||((t=e.path)==null?void 0:t[0])}static fixEvent(e,t){var r,n;if(e.isBryntumEvent)return e;if(Yp.has(e))return Yp.get(e);const{ctrlKey:s,metaKey:a,type:o,target:l}=e,d=this.getComposedPathTarget(e),c=((n=(r=d==null?void 0:d.getRootNode)==null?void 0:r.call(d))==null?void 0:n.mode)==="open",u={set(f,g,m){return g in f?Reflect.set(f,g,m):(u[g]=m,!0)},get(f,g){switch(g){case"fixed":case"isBryntumEvent":return!0;case"key":return Q_[f.key]||f.key;case"code":return f.key===" "&&!f.code?"Space":f.code;case"ctrlKey":return K.isMac&&a!==s?a:s;case"metaKey":return K.isMac&&a!==s?s:a;case"virtualKey":return sP(h);case"virtualModKeys":return qD(h);case"borderOffsetX":return isNaN(f.offsetX)?void 0:f.offsetX+(KD?0:parseInt(l.ownerDocument.defaultView.getComputedStyle(vf(l)).getPropertyValue("border-left-width")));case"borderOffsetY":return isNaN(f.offsetY)?void 0:f.offsetY+(KD?0:parseInt(l.ownerDocument.defaultView.getComputedStyle(vf(l)).getPropertyValue("border-top-width")));case"target":return c?d:vf(f.target);case"relatedTarget":return vf(f.relatedTarget);case"originalTarget":return l;case"deepTarget":return d;case"currentTarget":return u.delegatedTarget||f.currentTarget;case"browserEvent":return f;default:if(g in f){const m=Reflect.get(f,g);return typeof m=="function"?m.bind(f):m}else return u[g]}},has(f,g){return g in f||g in u}},h=new Proxy(e,u);if(Yp.set(e,h),o.startsWith("touch")&&this.normalizeEvent(h),!t)switch(o){case"keydown":ue.currentKeyDown=h;break;case"mousedown":ue.currentMouseDown=h;break;case"pointerdown":ue.currentPointerDown=h;break;case"touchstart":ue.currentTouch=h}return h}static createHandler(e,t,r,n){const s=r.delay||n.delay,a=r.throttled||n.throttled,o=r.block||n.block,l="once"in r?r.once:n.once,d="capture"in r?r.capture:n.capture,c="passive"in r?r.passive:n.passive,u="delegate"in r?r.delegate:n.delegate,h="fromGlobal"in r?r.fromGlobal:n.fromGlobal,f=r.handler,g=r.expires,m=r.thisObj||n.thisObj;let p=(y,...b)=>{at.playingDemo&&y.isTrusted||m!=null&&m.isDestroyed||(p.called=!0,(typeof f=="string"?m[f]:f).call(m,at.fixEvent(y,h),...b))};if(o){const y=p;let b,C;p=(D,...S)=>{const x=performance.now();(!b||D.target!==C||x-b>o)&&(C=D.target,b=x,y(D,...S))}}if(s!=null){const y=p,b=m!=null&&m.setTimeout?m:globalThis;p=(...C)=>{b.setTimeout(()=>{y(...C)},s)}}if(a!=null){let y,b=a;a.buffer&&(y=C=>a.alt.call(at,at.fixEvent(C,h)),b=a.buffer),m!=null&&m.isDelayable?p=m.throttle(p,{delay:b,throttled:y}):p=Se.createThrottled(p,b,m,null,y)}if(l){const y=p;p=(...b)=>{at.removeEventListener(e,t,p),y(...b)}}if(u){const y=p;p=(b,...C)=>{var D,S;b=at.fixEvent(b,h);const x=(S=(D=b.target).closest)==null?void 0:S.call(D,u);x&&(b.delegatedTarget=x,y(b,...C))}}return r.thisObj&&r.autoDetach!==!1&&(m.doDestroy=Se.createInterceptor(m.doDestroy,()=>at.removeEventListener(e,t,p),m)),p.spec={delay:s,throttled:a,block:o,once:l,thisObj:m,capture:d,expires:g,passive:c,delegate:u},p}static removeEventListener(e,t,r){const{expires:n,timerId:s,thisObj:a,capture:o}=r.spec;n!=null&&n.alt&&s&&(a!=null&&a.isDelayable?a:globalThis)[typeof n.delay=="number"?"clearTimeout":"cancelAnimationFrame"](s),e.removeEventListener(t,r,o)}static onTransitionEnd({element:e,animationName:t,property:r,handler:n,mode:s=t?"animation":"transition",duration:a=E[`get${s==="transition"?"Property":""}${O.capitalize(s)}Duration`](e,r),timeout:o,thisObj:l=globalThis,args:d=[],timerSource:c,runOnDestroy:u}){let h,f;c=c||(l.isDelayable?l:globalThis);const{isDelayable:g}=c,m=performance.now(),p=`transitionTimer${m}`,y=`timeoutTimer${m}`,b=[e,r,...d],C=()=>{var S;D(),l.isDestroyed||((S=l.$meta)!=null&&S.class.isBase?l.callback(n,l,b):n.apply(l,b))},D=at.on({element:e,[`${s}end`]({animationName:S,propertyName:x,target:R}){var M,I;R===e&&(x===r||S!=null&&S.match(t))&&(h&&(f&&((M=c.clearTimeout)==null||M.call(c,g?y:f)),(I=c.clearTimeout)==null||I.call(c,g?p:h),h=null),C())}});return o&&(f=c.setTimeout(C,Math.max(o,(a||0)+100),y)),a!=null&&(h=c.setTimeout(C,a+50,p,u)),D}static async waitForTransitionEnd(e){return new Promise(t=>{e.handler=t,kI.onTransitionEnd(e)})}static createDblClickWrapper(e,t,r){let n,s,a;return()=>{s||(s=at.on({element:e,touchstart:o=>{n=o.changedTouches[0].identifier,o.preventDefault()},touchend:o=>{if(o.changedTouches[0].identifier===n){o.preventDefault(),clearTimeout(a),n=s=null;const l=k.from(o.changedTouches[0].target,null,!0),d=o.changedTouches[0].pageX-l.x,c=o.changedTouches[0].pageY-l.y,u=Object.assign({browserEvent:o},o),h=new MouseEvent("dblclick",u);Object.defineProperties(h,{target:{value:o.target},offsetX:{value:d},offsetY:{value:c}}),typeof t=="string"&&(t=r[t]),t.call(r,h)}},once:!0}),a=setTimeout(()=>{s(),n=s=null},at.dblClickTime))}}static toSpecialKey(e,t="ctrlKey"){let r=!1;return e===!0?r=t:typeof e=="string"&&(e=e.toLowerCase(),e.match(eP)&&(r=`${e}Key`)),r}static specialKeyFromEventKey(e){return J_[e]||"no-special-key"}};v(qp,"$name","EventHelper"),v(qp,"eventNameMap",{mousedown:"MouseDown",mouseup:"MouseUp",click:"Click",dblclick:"DblClick",contextmenu:"ContextMenu",mouseenter:"MouseEnter",mouseleave:"MouseLeave",mousemove:"MouseMove",mouseover:"MouseOver",mouseout:"MouseOut",keyup:"KeyUp",keydown:"KeyDown",keypress:"KeyPress"});var j=qp;Pe.register(j);var at=j;at.longPressTime=700,at.dblClickTime=300,K.isTouchDevice&&at.on({element:document,touchmove:i=>{i.target.closest(".b-dragging")&&i.preventDefault()},passive:!1,capture:!0}),j._$name="EventHelper";var aP=14,oP={align:"t0-t0"},Bd=Node.ELEMENT_NODE,yf=Node.TEXT_NODE,{isObject:lP}=T,XD=/[+-]?\d*\.?\d+[eE]?-?\d*/g,Wi=XD.source,dP=new RegExp(`matrix\\((?:${Wi}),\\s?(?:${Wi}),\\s?(?:${Wi}),\\s?(?:${Wi}),\\s?(${Wi}),\\s?(${Wi})`),cP=new RegExp("matrix3d\\((?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(?:-?\\d*),\\s?(-?\\d*),\\s?(-?\\d*)"),bf=new RegExp(`(?:${dP.source})|(?:${cP.source})`),uP=new RegExp(`translate(3d|X)?\\((${Wi})px(?:,\\s?(${Wi})px)?`),hP=new RegExp(`translate(3d|Y)?\\((${Wi})px(?:,\\s?(${Wi})px)?`),fP=/\s+/,gP=/\s*;\s*/,mP=/\s*:\s*/,pP=/^-?((\d+(\.\d*)?)|(\.?\d+))$/,vP="$bryntum",ZD={},yP={elementData:"",for:"htmlFor",retainElement:""},bP={tag:1,html:1,text:1,children:1,tooltip:1,style:1,dataset:1,parent:1,nextSibling:1,ns:1,reference:1,class:1,className:1,unmatched:1,onlyChildren:1,listeners:1,compareHtml:1,syncOptions:1,keepChildren:1},CP=[["f","focusable"],["n","natural"],["p","programmatic"],["t","tabbable"]],SP=i=>Object.freeze(Object.fromEntries(CP.map(([e,t])=>[t,i.includes(e)]))),QD={length:1,parentRule:1,style:1},DP={INPUT:1,TEXTAREA:1},wP={BUTTON:1,IFRAME:1,EMBED:1,INPUT:1,OBJECT:1,SELECT:1,TEXTAREA:1,BODY:1},Cf=globalThis,mt=document,EP=Object.freeze({}),Kp=Array.prototype.slice,xP=Promise.resolve(),RP=["font-size","font-size-adjust","font-style","font-weight","font-family","font-kerning","font-stretch","line-height","text-transform","text-decoration","letter-spacing","word-break"],TP=i=>i._hidden,MP=(i,e,t)=>t.key==="children"?T.mergeItems(i,e,t):T.blend(i,e,t),Xp=(i,e)=>{if(i.isConnected){const t=i.ownerDocument.defaultView.getComputedStyle(i);return t.getPropertyValue("display")!=="none"&&(e||t.getPropertyValue("visibility")!=="hidden")}},en=i=>i&&i.isConnected&&(i===mt.body||!!i.offsetParent||(i.ownerDocument.defaultView&&"offsetParent"in i&&E.getStyleValue(i,"position")!=="fixed"?i.offsetParent:en(i.parentNode))),JD=i=>i instanceof Node?i:typeof i=="string"?W.createElementFromTemplate(i):W.createElement(i),Hd=Object.create(null),ew=(i,e)=>{const t=Hd[i]||[O.hyphenate(i),e];return Hd[i]||(Hd[t[0]]=Hd[i]=t),t},IP=/b-slide-in-from-\w+/,tw={auto:1,scroll:1},Sf=i=>{const e=i.ownerSVGElement?i.ownerSVGElement.parentNode:i.parentNode||i.target;return(e==null?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE?e.host:e},Df=i=>(i==null?void 0:i.nodeType)===Node.ELEMENT_NODE;["top","right","bottom","left","width","height","maxWidth","maxHeight","minWidth","minHeight","borderSpacing","borderWidth","borderTopWidth","borderRightWidth","borderBottomWidth","borderLeftWidth","insetBlockEnd","insetBlockStart","insetInlineEnd","insetInlineStart","marginTop","marginRight","marginBottom","marginLeft","marginInlineStart","marginInlineEnd","paddingTop","paddingRight","paddingBottom","paddingLeft","fontSize","letterSpacing","lineHeight","outlineWidth","textIndent","wordSpacing","insetInlineStart","insetBlockStart","insetInlineEnd","insetBlockEnd"].forEach(i=>ew(i,!0));var jd=null,_P=0,ls=null,Zp,iw,rw,wf=class ns{static get devicePixelRatio(){let e=globalThis.devicePixelRatio;if(e==null){const s=a=>`(-webkit-min-device-pixel-ratio: ${a}),
                (min--moz-device-pixel-ratio: ${a}),
                (min-resolution: ${a}dppx)`;for(let a=5*100;a>=.5*100;a-=.05*100)if(globalThis.matchMedia(s(a/100)).matches){e=a/100;break}}return e}static get usingKeyboard(){return W._usingKeyboard}static set usingKeyboard(e){return W._usingKeyboard=e}static setUsingKeyboard(e,t){W.setFocusRendition(e,t),W._usingKeyboard=t}static setFocusRendition(e,t){var r;W.enableKeyboardCssModifiers&&(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE?t?Array.from(e.children).forEach(n=>{var s;return((s=n.matches)==null?void 0:s.call(n,".b-outer"))&&n.classList.add("b-using-keyboard")}):W.removeClsGlobally(e,"b-using-keyboard"):(r=e.classList)==null||r.toggle("b-using-keyboard",t))}static async slideIn(e,t=1){const r=`b-slide-in-${t>0?"next":"previous"}`,{classList:n,parentNode:{classList:s}}=e;s.add(".b-sliding-child-element"),n.add(r),await j.waitForTransitionEnd({element:e,animationName:IP}),n.remove(r),s.remove(".b-sliding-child-element")}static getFocusability(e){let t="";if(e){const{nodeName:r}=e,n=e.getAttribute("tabIndex");t=wP[r]||(r==="A"||r==="LINK")&&e.href||e.contentEditable==="true"?"n":"",n==="-1"?t+="fp":(t||n!=null)&&(t+="ft")}return ZD[t]||(ZD[t]=SP(t))}static isFocusable(e,t){return e&&!t&&(!W.isVisible(e)||W.Widget.fromElement(e,TP))?!1:W.getFocusability(e).focusable}static isEditable(e){return!!((e.isContentEditable||DP[e.nodeName])&&!(e.readOnly||e.disabled||e.closest("[inert]")))}static isInView(e,t=!1,r){if(!en(Df(e.target)?e.target:e))return!1;const n=(r==null?void 0:r.positioned)&&ns.getStyleValue(r.element,"position")!=="fixed",s=k.from(globalThis),a=t?"contains":"intersect",o=n&&r.element.offsetParent,l=n&&k.from(o);if(s.height=mt.scrollingElement.scrollHeight,e===mt.body)return s;const d=this.getViewportIntersection(e,s,a);return d&&n&&d.translate(mt.scrollingElement.scrollLeft,mt.scrollingElement.scrollTop),n&&d?d.translate(-l.x+o.scrollLeft,-l.y+o.scrollTop):d}static getViewportIntersection(e,t,r){var n;const s=Df(e.target)?e.target:null,a=ns.getVisibleViewport(Sf(e),t,s||e),o=k.from(s||e,null,!0);return s&&(o.translate(e.offsetX+1,e.offsetY+1),o.height=o.width=0),(n=a==null?void 0:a[r])==null?void 0:n.call(a,o,!1,!0)}static getVisibleViewport(e,t,r){const n=[];let s=t,a;for(let o=e;o&&o!==mt.body;o=Sf(o)){const l=o.ownerDocument.defaultView.getComputedStyle(o);(tw[l.overflowX]||tw[l.overflowY])&&l.display!=="contents"&&(n.unshift(k.client(o,null,!0,!1,r)),a=o)}for(let o=0,{length:l}=n;s&&o<l;o++)s=s.intersect(n[o]);return a&&(s=k.clipStickies(s,a,null,!0,r)),s}static isVisible(e){var t;const r=e.ownerDocument;let n=!1;for(;e;e=Sf(e)){const s=(t=e.ownerDocument)==null?void 0:t.defaultView.getComputedStyle(e);if(n=n||s.getPropertyValue("visibility")==="visible",e===r)return!0;if(Df(e)&&!Xp(e,n))return!1}return!1}static isDOMEvent(e){return e instanceof Event}static merge(e,...t){return T.blend(e,t,{merge:MP})}static normalizeChildren(e,t,r){var n;let s=e==null?void 0:e.children,a,o,l,d,c;if((n=e==null?void 0:e.syncOptions)!=null&&n.ignoreRefs&&(r=!0),s&&!(e instanceof Node))if(Array.isArray(s))for(o=0;o<s.length;++o)W.normalizeChildren(s[o],t,r);else{d=s,e.children=s=[];for(l in d)a=d[l],a!=null&&a.isWidget&&(a=a.element),c=!l.startsWith("$")&&!W.isElement(a),c&&(t==null||t(l,!r)),a&&(a instanceof Node||(a.reference===!1?delete a.reference:c&&typeof a!="string"&&(a.reference=l),W.normalizeChildren(a,t,r)),s.push(a))}return e}static roundPx(e,t=globalThis.devicePixelRatio||1){const r=1/t;return Math.round(e/r)*r}static floorPx(e,t=globalThis.devicePixelRatio||1){const r=1/t;return Math.floor(e*r)/r}static isCustomElement(e){return!!(e!=null&&e.shadowRoot)}static elementFromPoint(e,t){let r=document.elementFromPoint(e,t);return W.isCustomElement(r)&&(r=r.shadowRoot.elementFromPoint(e,t)||r),r}static childFromPoint(e,t,r,n=e){const s=r==null?t:new k(t,r,0,0);let a=null;return Array.from(e.children).reverse().some(o=>{if(k.from(o,n).contains(s))return a=o.children.length&&W.childFromPoint(o,s,null,n)||o,!0}),a}static unitize(e,t,r="px"){const[n,s]=ew(e);return t!=null&&(t=String(t),t=s&&pP.test(t)?t+r:t),[n,t]}static get activeElement(){let e=document.activeElement;for(;e.shadowRoot;)e=e.shadowRoot.activeElement;return e}static getActiveElement(e){e!=null&&e.isWidget&&(e=e.element);let t=((e==null?void 0:e.getRootNode())||document).activeElement;for(;t!=null&&t.shadowRoot;)t=t.shadowRoot.activeElement;return t}static getRootElement(e){var t;const r=(t=e.getRootNode)==null?void 0:t.call(e),{nodeType:n}=r;return n===Node.DOCUMENT_NODE?r.body:n===Node.DOCUMENT_FRAGMENT_NODE?r:e.ownerDocument.contains(e)?e.ownerDocument.body:null}static getOutermostElement(e){var t;const r=(t=e.getRootNode)==null?void 0:t.call(e);if(r!=null&&r.body)return r==null?void 0:r.body;for(;e.parentNode!==r&&e.parentNode;)e=e.parentNode;return e}static isValidFloatRootParent(e){var t;return((t=e.tagName)==null?void 0:t.toUpperCase())==="BODY"||e.getRootNode().nodeType===Node.DOCUMENT_FRAGMENT_NODE}static getId(e){return e.id||(e.id="b-element-"+ ++_P)}static getCommonAncestor(e,t){var r,n;if(e===t)return e;for(;e&&!((r=e[e.isWidget?"owns":"contains"])!=null&&r.call(e,t)||e===t);)e=(n=e.owner)!=null&&n.isWidget&&e.owner!==e?e.owner:e.parentNode;return e}static getElement(e){return typeof e=="string"?mt.querySelector(e):e}static setAttributes(e,t){const r=W.getElement(e);if(r&&t)for(const n in t)t[n]==null?r.removeAttribute(n):r.setAttribute(n,t[n])}static addAttributeValue(e,t,r){var n;const s=W.getElement(e);s&&r&&s.setAttribute(t,[...new Set((n=s.getAttribute(t))==null?void 0:n.split(" ")).add(r)].join(" "))}static removeAttributeValue(e,t,r){var n;const s=W.getElement(e);if(s&&r){const a=new Set((n=s.getAttribute(t))==null?void 0:n.split(" "));a.delete(r),a.size?s.setAttribute(t,[...a].join(" ")):s.removeAttribute(t)}}static setLength(e,t,r){return arguments.length===1?r=typeof e=="number"?`${e}px`:e!=null?e:"":(e=W.getElement(e),r=e.style[t]=typeof r=="number"?`${r}px`:r!=null?r:""),r}static percentify(e,t=2){const r=Math.pow(10,t);return e==null||e===""||isNaN(e)?"":`${Math.round(e*r)/r}%`}static getChild(e,t){return e.querySelector(":scope>"+t)}static hasChild(e,t){return W.getChild(e,t)!=null}static children(e,t){return(t[0]===">"||t.startsWith("# "))&&(t[0]==="#"&&(t=t.substr(2)),t=":scope "+t),Array.from(e.querySelectorAll(t))}static getChildElementCount(e){return e.childElementCount}static down(e,t){var r;return e?(r=e.matches)!=null&&r.call(e,t)?e:(t=":scope "+t,e.querySelector(t)):null}static isDescendant(e,t){const r=W.getRootElement(e),n=W.getRootElement(t);return n&&r!==n&&n.host?W.isDescendant(r,n.host):e.contains(t)}static getEventElement(e,t="target"){return!e||W.isElement(e)?e:e[t]}static isElement(e){return(e==null?void 0:e.nodeType)===document.ELEMENT_NODE&&W.isNode(e)}static isReactElement(e){return(e==null?void 0:e.$$typeof)===Symbol.for("react.element")}static isNode(e){return!!e&&typeof e.nodeType=="number"&&!lP(e)}static forEachSelector(e,t,r){if(typeof e=="string")throw new Error("DomHelper.forEachSelector must provide a root element context (for shadow root scenario)");W.children(e,t).forEach(r)}static forEachChild(e,t){Array.from(e.children).forEach(t)}static removeEachSelector(e,t){W.forEachSelector(e,t,r=>r.remove())}static removeClsGlobally(e,...t){t.forEach(r=>W.forEachSelector(e,"."+r,n=>n.classList.remove(r)))}static getAncestor(e,t,r=null){let n=!1,s,a=e;for(t=H.asArray(t);a=a.parentElement;){if(t.includes(a)){n=!0;break}if(r&&a===r)break;s=a}return n?s||e:null}static getParents(e){const t=[];for(;e.parentElement;)t.push(e.parentElement),e=e.parentElement;return t}static makeValidId(e,t=""){return O.makeValidDomId(e,t)}static createElement(e={},t){var r,n;let s=t,a,o,l,d,c,u,h,f,g,m,p;if(typeof s=="boolean")throw new Error("Clean up");t&&(c=t.ignoreRefs,g=t.refOwner,m=t.refs,s=t.returnAll,p=t.syncIdField,c&&(l=!0,c=c!=="children")),typeof e.parent=="string"&&(e.parent=document.getElementById(e.parent));const y=e.parent||e.nextSibling&&e.nextSibling.parentNode,{dataset:b,html:C,reference:D,syncOptions:S,text:x}=e;if(S&&(p=S.syncIdField||p,d=S.ignoreRefs,d&&(l=!0,c=d!=="children",t={...t,ignoreRefs:!0})),c&&(g=null),e.ns?a=mt.createElementNS(e.ns,e.tag||"svg"):a=mt.createElement(e.tag||"div"),x!=null?W.setInnerText(a,x):C!=null&&(C instanceof DocumentFragment?a.appendChild(C):a.innerHTML=C),e.tooltip&&W.Widget.attachTooltip(a,e.tooltip),e.style&&W.applyStyle(a,e.style),b)for(h in b)f=b[h],f!=null&&(a.dataset[h]=f);y&&this.addChild(y,a,e.nextSibling),g&&(a.$refOwnerId=g.id),D&&!c&&(g?(a.$reference=D,g.attachRef(D,a,e)):(m||(t=Object.assign({},t),t.refs=m={}),m[D]=a,a.setAttribute("data-reference",D)));const R=e.className||e.class,M=Object.keys(e);for(R&&a.setAttribute("class",se.normalize(R)),o=0;o<M.length;++o)h=M[o],f=e[h],(u=yP[h])!=null?a[u||h]=f:!bP[h]&&h&&f!=null&&a.setAttribute(h,f);!e["aria-hidden"]&&!e.role&&!e.tabIndex&&!ns.isFocusable(a,!0)&&!a.htmlFor&&a.setAttribute("role","presentation"),(n=t==null?void 0:t.callback)==null||n.call(t,{action:"newElement",domConfig:e,targetElement:a,syncId:g?D:t.syncIdField&&((r=e.dataset)==null?void 0:r[t.syncIdField])}),s===!0?t.returnAll=s=[a]:Array.isArray(s)&&s.push(a),e.children&&(p&&(a.syncIdMap={}),H.asArray(e.children).forEach(_=>{var P,A,L,F;if(_)if(typeof _=="string"){const N=document.createTextNode(_);g&&(N.$refOwnerId=g.id),a.appendChild(N)}else if(this.isReactElement(_))(P=t==null?void 0:t.reactCallback)==null||P.call(t,{jsx:_,domConfig:e,targetElement:a});else if(isNaN(_.nodeType)){_.parent=a,!_.ns&&e.ns&&(_.ns=e.ns);const N=W.createElement(_,{...t,ignoreRefs:(L=(A=e.syncOptions)==null?void 0:A.ignoreRef)!=null?L:l}),Y=(F=_.dataset)==null?void 0:F[p];Y!=null&&(a.syncIdMap[Y]=N),delete _.parent}else a.appendChild(_)})),a.lastDomConfig=e;const I=m||s||a;return e.replaceElement&&e.replaceElement.replaceWith(I),I}static createElementFromTemplate(e,t=EP){const{array:r,raw:n,fragment:s}=t;let a;if(W.supportsTemplate){if((Zp||(Zp=mt.createElement("template"))).innerHTML=e,a=Zp.content,s)return a.cloneNode(!0)}else if(a=(iw||(iw=new DOMParser)).parseFromString(e,"text/html").body,s){const o=a.childNodes;for(a=document.createDocumentFragment();o.length;)a.appendChild(o[0]);return a}return n?a=a.childNodes:a=a.children,a.length===1&&!r?a[0]:Kp.call(a)}static triggerMouseEvent(e,t="contextmenu"){const r=this.isInView(e),n=r||k.from(e),s=n.center,a=new MouseEvent(t,{clientX:s.x,clientY:s.y,offsetX:r.width/2,offsetY:r.height/2,bubbles:!0});e.dispatchEvent(a)}static insertFirst(e,t){return t&&t.nodeType!==Bd&&t.tag&&(t=W.createElement(t)),e.insertBefore(t,e.firstElementChild)}static insertBefore(e,t,r){return t&&t.nodeType!==Bd&&t.tag&&(t=W.createElement(t)),r?e.insertBefore(t,r):W.insertFirst(e,t)}static insertAt(e,t,r){const n=Array.from(e.children);if(r>=n.length)return W.append(e,t);const s=n[r];return W.insertBefore(e,t,s)}static append(e,t){if(t.forEach){if(Array.isArray(t)&&(t=t.map(r=>JD(r))),e.append)e.append(...t);else{const r=document.createDocumentFragment();t.forEach(function(n){r.appendChild(n)}),e.appendChild(r)}return t}else return e.appendChild(JD(t))}static getTranslateX(e){const t=e.style.transform;let r=uP.exec(t);return r?parseFloat(r[2]):(r=bf.exec(t)||bf.exec(W.getStyleValue(e,"transform")),r?parseFloat(r[1]||r[3]):0)}static getTranslateY(e){const t=e.style.transform;let r=hP.exec(t);if(r){const n=parseFloat(r[r[1]==="Y"?2:3]);return isNaN(n)?0:n}else return r=bf.exec(t)||bf.exec(W.getStyleValue(e,"transform")),r?parseFloat(r[2]||r[4]):0}static getTranslateXY(e){return[W.getTranslateX(e),W.getTranslateY(e)]}static getOffsetX(e,t=null){return t?e.getBoundingClientRect().left-t.getBoundingClientRect().left:e.offsetLeft}static getOffsetY(e,t=null){return t?e.getBoundingClientRect().top-t.getBoundingClientRect().top:e.offsetTop}static getOffsetXY(e,t=null){return[W.getOffsetX(e,t),W.getOffsetY(e,t)]}static getPageX(e){return e.getBoundingClientRect().left+Cf.pageXOffset}static getPageY(e){return e.getBoundingClientRect().top+Cf.pageYOffset}static getExtremalSizePX(e,t){const r=O.hyphenate(t),n=r.split("-")[1];let s=W.getStyleValue(e,r);return/%/.test(s)?e.parentElement?s=parseInt(W.getStyleValue(e.parentElement,n),10):s=NaN:s=parseInt(s,10),s}static setScale(e,t,r=t){const n=W.getStyleValue(e,"transform").split(/,\s*/);n.length>1?(n[0].startsWith("matrix3d")?(n[0]=`matrix3d(${t}`,n[5]=r):(n[0]=`matrix(${t}`,n[3]=r),e.style.transform=n.join(",")):e.style.transform=`scale(${t}, ${r})`}static setTranslateX(e,t){const r=W.getStyleValue(e,"transform").split(/,\s*/);t=W.roundPx(t),r.length>1?(r[r[0].startsWith("matrix3d")?12:4]=t,e.style.transform=r.join(",")):e.style.transform=`translateX(${t}px)`}static setTranslateY(e,t){const r=W.getStyleValue(e,"transform").split(/,\s*/);t=W.roundPx(t),r.length>1?(r[r[0].startsWith("matrix3d")?13:5]=t,e.style.transform=r.join(",")+")"):e.style.transform=`translateY(${t}px)`}static setTop(e,t){W.setLength(e,"top",t)}static setLeft(e,t){W.setLength(e,"left",t)}static setTopLeft(e,t,r){W.setLength(e,"top",t),W.setLength(e,"left",r)}static setTopInsetInlineStart(e,t,r){W.setLength(e,"top",t),W.setLength(e,"inset-inline-start",r)}static setRect(e,{x:t,y:r,width:n,height:s}){W.setTopInsetInlineStart(e,r,t),W.setLength(e,"width",n),W.setLength(e,"height",s)}static setTranslateXY(e,t,r){if(t==null)return W.setTranslateY(e,r);if(r==null)return W.setTranslateX(e,t);t=W.roundPx(t),r=W.roundPx(r);const n=W.getStyleValue(e,"transform").split(/,\s*/),s=n[0].startsWith("matrix3d");n.length>1?(n[s?12:4]=t,n[s?13:5]=r,e.style.transform=n.join(",")+")"):e.style.transform=`translate(${t}px, ${r}px)`}static addTranslateX(e,t){W.setTranslateX(e,W.getTranslateX(e)+t)}static addTranslateY(e,t){W.setTranslateY(e,W.getTranslateY(e)+t)}static addLeft(e,t){W.setLeft(e,W.getOffsetX(e)+t)}static addTop(e,t){W.setTop(e,W.getOffsetY(e)+t)}static alignTo(e,t,r=oP,n,s="translate"){t=t instanceof k?t:k.from(t,!0);const a=k.from(e,!0);n&&(a.roundPx(),t.roundPx());const o=a.alignTo(Object.assign(r,{target:t}));if(s==="topInset"){const l=[parseInt(e.style.insetInlineStart||0,10),parseInt(e.style.top||0,10)];W.setTopInsetInlineStart(e,l[1]+o.y-a.y,l[0]+o.x-a.x)}else if(s==="topLeft"){const l=[parseInt(e.style.left||0,10),parseInt(e.style.top||0,10)];W.setTopLeft(e,l[1]+o.y-a.y,l[0]+o.x-a.x)}else{const l=W.getTranslateXY(e);W.setTranslateXY(e,l[0]+o.x-a.x,l[1]+o.y-a.y)}}static getStyleValue(e,t,r,n){const s=r?e.style:e.ownerDocument.defaultView.getComputedStyle(e,n);if(Array.isArray(t)){const a={};for(const o of t)a[o]=s.getPropertyValue(O.hyphenate(o));return a}return s.getPropertyValue(O.hyphenate(t))}static getEdgeSize(e,t,r){const n=t==="border"?"-width":"",s={raw:{}};for(const a of["top","right","bottom","left"])(!r||r.includes(a[0]))&&(s[a]=parseFloat(s.raw[a]=W.getStyleValue(e,`${t}-${a}${n}`)));return s.width=(s.left||0)+(s.right||0),s.height=(s.top||0)+(s.bottom||0),s}static parseStyle(e){if(typeof e=="string"){const t=e.split(gP);e={};for(let r=0,{length:n}=t;r<n;r++){const s=t[r].split(mP);e[s[0]]=s[1]}}return e||{}}static applyStyle(e,t,r=!1){if(typeof t=="string")r?(t.length||e.style.cssText.length)&&(e.style.cssText=t):e.style.cssText+=t;else if(t){r&&(e.style.cssText=""),t.style&&typeof t.style!="string"&&(t=T.assign({},t,t.style));let n,s;for(n in t)QD[n]||([n,s]=W.unitize(n,t[n]),s==null?e.style.removeProperty(n):e.style.setProperty(n,s));typeof t.style=="string"&&(e.style.cssText+=t.style)}}static getCSSText(e){if(typeof e=="string")return e;let t="";for(const r in e)QD[r]||(t+=`${O.hyphenate(r)}:${e[r]};`);return t}static assignClasses(e,t){T.forEach(t,(r,n)=>e.classList.toggle(n,!!r))}static toggleClasses(e,t,r=null){t=H.asArray(t),r===!0?e.classList.add(...t):r===!1?e.classList.remove(...t):t.forEach(n=>e.classList.toggle(n))}static addTemporaryClass(e,t,r,n=globalThis,s=t){r>0&&(e.classList.add(t),n.setTimeout({fn:a=>e.classList.remove(a),delay:r,name:s,args:[t],cancelOutstanding:!0}))}static getPropertyTransitionDuration(e,t){const r=globalThis.getComputedStyle(e),n=r.transitionProperty.split(", "),s=r.transitionDuration.split(", "),a=n.indexOf(O.hyphenate(t));let o;return a!==-1&&(o=parseFloat(s[a])*1e3),o}static getAnimationDuration(e){return parseFloat(W.getStyleValue(e,"animation-duration"))*1e3}static highlight(e,t=globalThis){return e instanceof k?e.highlight():new Promise(r=>{t.setTimeout(()=>{e.classList.add("b-fx-highlight"),t.setTimeout(()=>{e.classList.remove("b-fx-highlight"),r()},1e3)},0)})}static get scrollBarWidth(){if(jd===null){const e=rw||(rw=W.createElement({parent:mt.documentElement,className:"b-scrollbar-measure-element",style:"position:absolute;top:-9999em;height:100px;overflow-y:scroll"}));e.parentNode!==mt.documentElement&&mt.documentElement.appendChild(e),jd=e.offsetWidth}return jd}static get scrollBarPadElement(){return{className:"b-yscroll-pad",children:[{className:"b-yscroll-pad-sizer"}]}}static get scrollLimit(){const e=ns.createElement({parent:document.body,style:"position:absolute; left:-999px; top:0; width:5px; height:5px",children:[{style:"position:absolute; width:1px; height:1px"}]}),t=e.firstElementChild;let r=0,n=2e7;for(;n>1e6&&(t.style.transform=`translateY(${n}px)`,e.style.lineHeight=`${r=1-r}`,!(e.scrollHeight>=n));)n-=1e6;return Object.defineProperty(ns,"scrollLimit",{value:n}),e.remove(),n}static resetScrollBarWidth(){jd=null}static measureText(e,t,r=!1,n=void 0){const s=W.getMeasureElement(t,n);s[r?"innerHTML":"innerText"]=e;const a=s.clientWidth;return s.className="",a}static measureSize(e,t,r=!0){var n;if(!e)return 0;if(typeof e=="number")return e;if(!e.length)return 0;if(/^\d+(px)?$/.test(e))return parseInt(e);if(t){const s=(n=e.includes)==null?void 0:n.call(e,"%"),a=W.getMeasureElement(t,s?t.parentNode:void 0),{parentElement:o}=a;a.innerHTML="",s&&(o.style.display="contents"),a.style.minWidth=a.style.maxWidth=W.setLength(e);const l=r?a.offsetWidth:a.getBoundingClientRect().width;return o.style.display="",a.style.minWidth=a.style.maxWidth=a.className="",l}return/^\d+em$/.test(e)?parseInt(e)*aP:isNaN(e)?0:parseInt(e)}static getMeasureElement(e,t){t=t||mt.body;const r=Cf.getComputedStyle(e),n=t.offScreenDiv=t.offScreenDiv||W.createElement({parent:t,style:"position:fixed;top:-10000px;left:-10000px;visibility:hidden;contain:strict",className:"b-measure-element",children:[{style:"white-space:nowrap;display:inline-block;will-change:contents;width:auto;contain:none"}]},{returnAll:!0})[1];return RP.forEach(s=>{n.style[s]!==r[s]&&(n.style[s]=r[s])}),n.className=e.className,n.parentElement.parentElement!==t&&t.appendChild(n.parentElement),n}static stripTags(e){return(W.$domParser||(W.$domParser=new DOMParser)).parseFromString(e,"text/html").body.textContent}static sync(e,t){if(typeof e=="string")if(e===""){t.innerHTML="";return}else e=W.createElementFromTemplate(e);return W.performSync(e,t),t}static performSync(e,t){return e.outerHTML!==t.outerHTML?(W.syncAttributes(e,t),W.syncContent(e,t),W.syncChildren(e,t),!0):!1}static getSyncAttributes(e){const t={},r=[];for(let n=0;n<e.attributes.length;n++){const s=e.attributes[n];if(s.specified){const a=s.name.toLowerCase();t[a]=s.value,r.push(a)}}return{attributes:t,names:r}}static syncAttributes(e,t){const{attributes:r,names:n}=W.getSyncAttributes(e),{attributes:s,names:a}=W.getSyncAttributes(t),o=n.includes("dataset"),l=n.filter(u=>!a.includes(u)),d=a.filter(u=>!n.includes(u)&&(!o||!u.startsWith("data-"))),c=n.filter(u=>a.includes(u));if(l.length>0)for(let u=0;u<l.length;u++){const h=l[u];h==="style"?W.applyStyle(t,r.style,!0):h==="dataset"?Object.assign(t.dataset,r.dataset):t.setAttribute(h,r[h])}if(d.length>0)for(let u=0;u<d.length;u++)t.removeAttribute(d[u]);if(c.length>0)for(let u=0;u<c.length;u++){const h=c[u];if(h==="style")W.applyStyle(t,r.style,!0);else if(h==="dataset")Object.assign(t.dataset,r.dataset);else if(h==="class"&&(r.class.isDomClassList||typeof r.class=="object")){let f;r.class.isDomClassList?f=r.class:f=new se(r.class),f.isEqual(s.class)||t.setAttribute("class",f)}else s[h]!==r[h]&&t.setAttribute(h,r[h])}}static syncContent(e,t){W.getChildElementCount(e)===0&&(t.innerText=e.innerText)}static setInnerText(e,t){const{firstChild:r}=e;(r==null?void 0:r.nodeType)===Element.TEXT_NODE?r.data=t:e.textContent=t}static syncChildren(e,t){const r=this,n=Kp.call(e.childNodes),s=Kp.call(t.childNodes);for(;n.length;){const a=n.shift(),o=s.shift();if(a&&a.nodeType!==yf&&a.nodeType!==Bd)throw new Error(`Source node type ${a.nodeType} not supported by DomHelper.sync()`);if(o&&o.nodeType!==yf&&o.nodeType!==Bd)throw new Error(`Target node type ${o.nodeType} not supported by DomHelper.sync()`);if(!o)t.appendChild(a);else if(a.nodeType===o.nodeType)a.nodeType===yf?o.data=a.data:a.tagName===o.tagName?r.performSync(a,o):(t.insertBefore(a,o),o.remove());else if(a.nodeType===yf&&o.nodeType===Bd)t.innerText=a.data.trim();else{const l=a.parentElement||a;throw new Error(`Currently no support for transforming nodeType.
${l.outerHTML}`)}}s.forEach(a=>{a.remove()})}static syncClassList(e,t){const{classList:r}=e,n=typeof t=="string",s=n?t.split(fP):se.normalize(t,"array"),a=s.length;let o=r.length!==a,l;for(l=0;!o&&l<a;l++)o=!r.contains(s[l]);return o&&(e.className=n?t:s.join(" ")),o}static updateClassList(e,t){const{classList:r}=e;let n,s,a=!1;for(n in t)s=!!t[n],r.contains(n)!==s&&(r[s?"add":"remove"](n),a=!0);return a}static setTheme(e,t){e=e.toLowerCase();const{head:r}=document,n=W.getThemeInfo(t).name.toLowerCase();let s=r.querySelectorAll("[data-bryntum-theme]:not([data-loading])"),a=0;if(n===e)return xP;W.removeEachSelector(r,"#bryntum-theme[data-loading],link[data-bryntum-theme][data-loading]");const o={theme:e,prev:n};function l(d,c,u){const h=ns.createElement({tag:"link",rel:"stylesheet",dataset:{loading:!0,bryntumTheme:!0},href:d.href.replace(n,e),nextSibling:d});h.addEventListener("load",()=>{delete h.dataset.loading,ls=null,++a===s.length&&(s.forEach(f=>f.remove()),ue.trigger("theme",o),c(o))}),h.addEventListener("error",f=>{delete h.dataset.loading,u(f)})}if(s.length)return new Promise((d,c)=>{s.forEach((u,h)=>{l(u,d,c,h===s.length-1)})});{const d=r.querySelector("#bryntum-theme:not([data-loading])")||r.querySelector(`[href*="${n}.css"]:not([data-loading])`);if(!(d!=null&&d.href.includes(`${n}.css`)))throw new Error(`Theme link for ${n} not found`);return s=[d],new Promise((c,u)=>l(d,c,u))}}static get themeInfo(){return ns.getThemeInfo()}static getThemeInfo(e){if(!ls){const t=W.createElement({parent:document.body,className:"b-theme-info"}),r=W.getStyleValue(t,"content",!1,":before");if(r)try{ls=JSON.parse(r.replace(/^["']|["']$|\\/g,""))}catch(n){ls=null}ls=ls||(e?{name:e}:null),t.remove()}return ls}static async transition({element:e,selector:t="[data-dom-transition]",duration:r,action:n,thisObj:s=this,addTransition:a={},removeTransition:o={}}){const l=new Set,d=Array.from(e.querySelectorAll(t)),c=new Map(d.map(g=>{let m=0,p=g.parentElement;for(;p&&p!==e;)m++,p=p.parentElement;g.$depth=m,g.scrollHeight>g.offsetHeight&&getComputedStyle(g).overflow==="auto"&&(g.$scrollTop=g.scrollTop,l.add(g));const{parentElement:y}=g,b=k.from(g,e),C=k.from(g,y),D=getComputedStyle(y),S=parseFloat(D.borderLeftWidth);return S&&(b.left-=S,C.left-=S),[g.id,{element:g,globalBounds:b,localBounds:C,depth:m,parentElement:y}]}));n.call(s);const u=Array.from(e.querySelectorAll(t)),h=new Map(u.map(g=>{const m=k.from(g,e),p=k.from(g,g.parentElement),y=globalThis.getComputedStyle(g.parentElement),b=parseFloat(y.borderLeftWidth);return b&&(m.left-=b,p.left-=b),[g.id,{element:g,globalBounds:m,localBounds:p}]})),f=["position","top","left","width","height","padding","margin","zIndex","minWidth","minHeight","opacity","overflow"];for(const[g,m]of c){const p=h.get(g);if(p){const{element:y}=p,{style:b,parentElement:C}=y,D=parseInt(W.getStyleValue(y,"zIndex")),{globalBounds:S,localBounds:x,depth:R,parentElement:M}=m,I=M!==C;T.copyProperties(y.$initial={parentElement:C},b,f);let _;I?(p.bounds=p.globalBounds,_=S,e.appendChild(y)):(p.bounds=p.localBounds,_=x,M.appendChild(y));let P="hidden";l.has(y)&&(y.$scrollPlaceholder=W.createElement({parent:y,style:{height:y.scrollHeight}}),P="auto");const A={position:"absolute",top:`${_.top}px`,left:`${_.left}px`,width:`${_.width}px`,height:`${_.height}px`,minWidth:0,minHeight:0,margin:0,zIndex:R+(D||0),overflow:P};y.dataset.domTransition!=="preserve-padding"&&(A.padding=0),Object.assign(b,A),p.processed=!0}else{const{element:y,localBounds:b,depth:C,parentElement:D}=m;y.$initial={removed:!0},Object.assign(y.style,{position:"absolute",top:`${b.top}px`,left:`${b.left}px`,width:`${b.width}px`,height:`${b.height}px`,minWidth:0,minHeight:0,padding:0,margin:0,zIndex:C,overflow:"hidden"}),D.appendChild(y),h.set(g,{element:y,bounds:b,removed:!0,processed:!0}),u.push(y)}}for(const[,g]of h)if(!g.processed){const{element:m}=g,{style:p,parentElement:y}=m,b=g.bounds=g.localBounds;m.classList.add("b-dom-transition-adding"),T.copyProperties(m.$initial={parentElement:y},p,f),Object.assign(p,{position:"absolute",top:a.top?0:`${b.top}px`,left:a.left?0:`${b.left}px`,width:a.width?0:`${b.width}px`,height:a.height?0:`${b.height}px`,opacity:a.opacity?0:null,zIndex:y.$depth+1,overflow:"hidden"})}for(const g of l)g.scrollTop=g.$scrollTop;e.classList.add("b-dom-transition"),e.firstElementChild.offsetWidth;for(const[,{element:g,bounds:m,removed:p}]of h)p?Object.assign(g.style,{top:o.top?0:`${m.top}px`,left:o.left?0:`${m.left}px`,width:o.width?0:`${m.width}px`,height:o.height?0:`${m.height}px`,opacity:o.opacity?0:g.$initial.opacity}):Object.assign(g.style,{top:`${m.top}px`,left:`${m.left}px`,width:`${m.width}px`,height:`${m.height}px`,opacity:g.$initial.opacity});await Ei.sleep(r),e.classList.remove("b-dom-transition");for(const g of u)g.$initial&&(g.$initial.removed?g.remove():(T.copyProperties(g.style,g.$initial,f),g.$scrollPlaceholder&&(g.$scrollPlaceholder.remove(),delete g.$scrollPlaceholder),g.classList.remove("b-dom-transition-adding"),g.$initial.parentElement.appendChild(g)));for(const g of l)g.scrollTop=g.$scrollTop,delete g.$scrollTop}static async loadScript(e){return new Promise((t,r)=>{const n=document.createElement("script");n.src=e,n.onload=t,n.onerror=r,document.head.appendChild(n)})}static isNamedColor(e){return e&&!/^(#|hsl|rgb|hwb|lab|lch|oklab|oklch)/.test(e)}static createColorStyle(e){return e!=null&&e.length?this.isNamedColor(e)?`var(--cal-color-${e})`:e:""}static get NodeFilter(){return NodeFilter}static addChild(e,t,r){e.insertBefore(t,r)}static cloneStylesIntoShadowRoot(e,t){return new Promise((r,n)=>{t&&e.querySelectorAll('style, link[rel="stylesheet"]').forEach(o=>o.remove());const s=document.querySelectorAll('link[rel="stylesheet"]');let a=0;s.forEach(o=>{const l=o.cloneNode();l.addEventListener("load",()=>{a+=1,a===s.length&&r()}),l.addEventListener("error",d=>{n(l.href)}),e.appendChild(l)}),document.querySelectorAll("style").forEach(o=>{const l=o.cloneNode();l.innerText=o.innerText,e.appendChild(l)}),s.length||r()})}};v(wf,"_usingKeyboard",!1),v(wf,"enableKeyboardCssModifiers",!0),v(wf,"$name","DomHelper");var E=wf;Pe.register(E);var W=E,nw,PP=()=>W.isTouchEvent=!1,sw=()=>{W.isTouchEvent=!0,clearTimeout(nw),nw=setTimeout(PP,400)};if(mt.addEventListener("touchstart",sw,!0),mt.addEventListener("touchend",sw,!0),W.canonicalStyles=Hd,W.supportsTemplate="content"in mt.createElement("template"),W.elementPropKey=vP,W.numberRe=XD,!("children"in Node.prototype)){const i=Df;Object.defineProperty(Node.prototype,"children",{get:function(){return Array.prototype.filter.call(this.childNodes,i)}})}Element.prototype.matches||(Element.prototype.matches=Element.prototype.matchesSelector||Element.prototype.mozMatchesSelector||Element.prototype.msMatchesSelector||Element.prototype.oMatchesSelector||Element.prototype.webkitMatchesSelector||function(i){const e=(this.document||this.ownerDocument).querySelectorAll(i);let t=e.length;for(;--t>=0&&e.item(t)!==this;);return t>-1}),Cf.Element&&!Element.prototype.closest?Node.prototype.closest=Element.prototype.closest=function(i){let e=this;if(!mt.documentElement.contains(e))return null;do{if(e.matches(i))return e;e=e.parentElement||e.parentNode}while(e!==null&&e.nodeType===e.ELEMENT_NODE);return null}:Node.prototype.closest=function(i){var e;return(e=this.parentNode)==null?void 0:e.closest(i)},function(i){i.forEach(function(e){Object.prototype.hasOwnProperty.call(e,"remove")||Object.defineProperty(e,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){this.parentNode&&this.parentNode.removeChild(this)}})})}([Element.prototype,CharacterData.prototype,DocumentType.prototype]),globalThis.addEventListener("resize",()=>jd=null),E._$name="DomHelper";var Ef=new Map,AP=5,FP=i=>i.floating,kP={touchend:1,pointerup:1},LP={Meta:1,Control:1,Alt:1},aw=i=>{(La==null?void 0:La.pointerId)===i.pointerId&&(La=null)},Qp=i=>{const{touches:e}=i;if(Ef.clear(),e)for(let t=0;t<e.length;t++){const r=e.item(t);Ef.set(r.identifier,[r,i])}},ci=new class extends $.mixin(Ve){suspendFocusEvents(){xf=!0}resumeFocusEvents(){xf=!1}setupFocusListenersOnce(e,t){e&&!ci.observedElements.has(e)&&(ci.setupFocusListeners(e,t),ci.observedElements.add(e))}detachFocusListeners(e){e.$globalEventsDetacher&&(e.$globalEventsDetacher(),e.$globalEventsDetacher=null,ci.observedElements.delete(e))}setupFocusListeners(e=document,t,r=!1){let n,s,a;const o={element:e,fromGlobal:!0,touchstart(l){const{touches:d}=l;if(Qp(l),d.length===2&&d[0].target.closest(".b-widget")&&d[1].target.closest(".b-widget")){n=[d[0],d[1]],s=[(n[0].clientX+n[1].clientX)/2,(n[0].clientY+n[1].clientY)/2],a=E.elementFromPoint(s[0],s[1]);return}if(!Zt&&l.changedTouches.length===1){if(Zt=l.changedTouches[0],!K.isAndroid){const c=({clientX:f,clientY:g,type:m})=>{(kP[m]||!Zt||Math.max(Math.abs(f-Zt.clientX),Math.abs(g-Zt.clientY))>AP)&&(Jp=null,u(),clearTimeout(h))},u=t.on({element:document,touchmove:c,touchend:c,pointermove:c,pointerup:c,capture:!0}),h=setTimeout(()=>{Jp=Zt.identifier,u(),l.target.dispatchEvent(new MouseEvent("contextmenu",t.copyEvent({},l)))},t.longPressTime)}}else Zt=null},touchmove:{passive:!1,handler:l=>{const{touches:d}=l;if(d.length===2&&n){const c=[d[0],d[1]],u=t.getDistanceBetween(n[0],n[1])-t.getDistanceBetween(c[0],c[1]),h=Math.abs(n[0].clientX-n[1].clientX)-Math.abs(c[0].clientX-c[1].clientX),f=Math.abs(n[0].clientY-n[1].clientY)-Math.abs(c[0].clientY-c[1].clientY);if(Math.abs(u)>2){const g={clientX:s[0],clientY:s[1],bubbles:!0};if(ci.Widget.convertPinchToMousewheel){l.preventDefault(),l.stopImmediatePropagation();const p=new MouseEvent("wheel",{...g,ctrlKey:!0});p.deltaY=f,p.deltaX=h,a.dispatchEvent(p)}const m=new MouseEvent("bryntum-pinch",g);m.deltaY=f,m.deltaX=h,m.touchMove=l,a.dispatchEvent(m)}n=c}}},touchend:{passive:!1,handler:l=>{Qp(l),l.touches.length!==2&&(n=null),Zt&&(l.changedTouches[0].identifier===Jp?(l.stopImmediatePropagation(),l.cancelable!==!1&&l.preventDefault()):l.changedTouches.length===1&&l.changedTouches[0].identifier===Zt.identifier&&ci.trigger("globaltap",{event:l}),Zt=null)}},touchcancel:{passive:!1,handler:Qp},mousedown:{handler:l=>{Rf="mouse",Zt||ci.trigger("globaltap",{event:l}),tn=l;const d=l.ctrlKey||l.altKey||l.shiftKey||l.metaKey;!et&&d?et=new KeyboardEvent("keydown",{key:l.ctrlKey?"Control":l.shiftKey?"Shift":l.altKey?"Alt":"Meta",ctrlKey:l.ctrlKey,altKey:l.altKey,shiftKey:l.shiftKey,metaKey:l.metaKey}):et&&!d&&(et=null)},passive:!1},mouseup(){tn=null},pointerdown:{passive:!1,handler:l=>{La=l,E.setUsingKeyboard(e,!1)}},pointerup:{passive:!1,handler:aw},pointercancel:{passive:!1,handler:aw},keydown(l){const{key:d,target:c}=l;if(Rf="key",et=l,ev=c,!LP[d]){if(e.nodeType===Node.DOCUMENT_FRAGMENT_NODE)for(const u of e.children)u.matches(".b-outer")&&E.setUsingKeyboard(u,!0);else E.setUsingKeyboard(e,!0);d==="Escape"&&ci.Widget.queryAll(u=>u.isTooltip&&u.isVisible).forEach(u=>u.hide())}},mouseenter(l){ev=l.target},keypress(){Rf="key"},keyup(){et=null},focusin(l){var d;const{Widget:c}=ci,{target:u}=l;if(u!=null&&u.shadowRoot||u!=null&&u._shadowRoot)return;if(u&&c.accessibility){const x=u.firstElementChild||u,R=k.from(u),M=R.center;(E.childFromPoint(x,R.width/2,R.height/2)||x).dispatchEvent(new PointerEvent("pointerover",{bubbles:!0,clientX:M.x,clientY:M.y,pointerType:"focus"}))}if(xf||u&&!u.isConnected)return;const h=l.relatedTarget?l.relatedTarget instanceof HTMLElement?l.relatedTarget:document.body:null,f=u||document.body,g=c.fromElement(h),m=c.fromElement(f),p=E.getCommonAncestor(g,m),y=!!(h&&f.compareDocumentPosition(h)&4),b=c.query(OP);let C=null;if(f&&f!==document.body?C=E.getActiveElement(f):C=E.getActiveElement(document),b&&!b._isRevertingFocus&&(!m||!b.owns(m)&&!(b.element.compareDocumentPosition(m.element)&4&&m.up(FP))))return b.focus();let D=iv("focusout",h,u,g,m,y);for(let x=g,R;x&&x!==p;x=R)if(R=x.owner,!x.isDestroying&&x.onFocusOut&&(x.onFocusOut(D),u&&C!==E.getActiveElement(u)))return;if(p&&u===p.element)!p.isDestroying&&E.getActiveElement(p)===f&&p.focusElement&&p.focusElement!==p.element&&(!p.element.contains(C)||p.focusDescendant)&&p.setTimeout(()=>{var x;return(x=p.focus)==null?void 0:x.call(p)},0);else{D=iv("focusin",f,h,g,m,y);for(let x=m;x&&x!==p;x=x.owner)x.isDestroying||(d=x.onFocusIn)==null||d.call(x,D)}const S=E.getCommonAncestor((h==null?void 0:h.nodeType)===Element.ELEMENT_NODE?h:null,f)||f.parentNode;S&&(D=iv("focusmove",f,h,g,m,y,{bubbles:!0}),S.dispatchEvent(D))},focusout(l){if(!xf&&(!l.relatedTarget||!ci.Widget.fromElement(l.relatedTarget))){const d=l.relatedTarget&&l.relatedTarget instanceof HTMLElement?l.relatedTarget:null;o.focusin({target:d,relatedTarget:l.target}),et=tn=null}},blur:{element:globalThis,handler(l){l.target===globalThis&&(et=null,tn=null)}},capture:!0,passive:!0};r&&(tv==null||tv()),tv=this.detachEvents=e.$globalEventsDetacher=t.on(o)}get activeTouches(){return Array.from(Ef.values())}get hasActiveTouches(){return Ef.size>0}get lastInteractionType(){return Rf}get shiftKeyDown(){return!!(et!=null&&et.shiftKey)}get ctrlKeyDown(){return!!(et!=null&&et.ctrlKey||et!=null&&et.metaKey)}get altKeyDown(){return!!(et!=null&&et.altKey)}get currentOverElement(){return ev}isKeyDown(e){return e?(et==null?void 0:et.key)===e||et[(e==null?void 0:e.toLowerCase())+"Key"]===!0:!!et}isMouseDown(e=0){return(tn==null?void 0:tn.button)===e}get currentMouseDown(){return tn}set currentMouseDown(e){tn=e}get currentPointerDown(){return La}set currentPointerDown(e){La=e}get currentTouch(){return Zt}set currentTouch(e){Zt=e}get currentKeyDown(){return et}set currentKeyDown(e){et=e}},OP=i=>i.isTopModal;ci.observedElements=new Set;var Zt,Jp,xf=!1,Rf,et,tn,La,ev,tv;function iv(i,e,t,r,n,s,a){const o=new CustomEvent(i,a);return Object.defineProperty(o,"_target",{get(){return e}}),Object.defineProperty(o,"relatedTarget",{get(){return t}}),o.fromWidget=r,o.toWidget=n,o.backwards=s,o}var ue=ci,$P=/^(\w+)=(.*)$/,BP=function(i){const e={},t=i.split("&");for(const r of t){const[n,s,a]=$P.exec(r),o=decodeURIComponent(s),l=decodeURIComponent(a);if(n){let d=e[o];d?(Array.isArray(d)||(d=e[o]=[d]),d.push(l)):e[o]=l}}return e},ow=class Ia{static get(e,t){return this.fetch(e,t)}static post(e,t,r={}){return!(t instanceof FormData)&&typeof t!="string"&&(t=JSON.stringify(t),r.headers=r.headers||{},r.headers["Content-Type"]=r.headers["Content-Type"]||"application/json"),this.fetch(e,Object.assign({method:"POST",body:t},r))}static fetch(e,t){let r;if(t=X.merge({},Ia.DEFAULT_FETCH_OPTIONS,t),typeof AbortController!="undefined"&&(r=t.abortController=new AbortController,t.signal=r.signal),"credentials"in t||(t.credentials="include"),t.queryParams){const s=Object.entries(t.queryParams);if(s.length){let a=!1;if(t.headers&&t.addQueryParamsToBody===!0){const o=new Headers(t.headers).get("Content-Type");let l;switch(o){case"application/x-www-form-urlencoded":l=URLSearchParams;break;case"multipart/form-data":l=FormData;break}if(l){const d=t.body||(t.body=new l);d instanceof l&&(s.forEach(([c,u])=>d.set(c,u)),a=!0)}}a||(e+=(e.includes("?")?"&":"?")+s.map(([o,l])=>`${o}=${encodeURIComponent(l)}`).join("&"))}}const n=new Promise((s,a)=>{fetch(e,t).then(o=>{t.parseJson?o.json().then(l=>{o.parsedJson=l,s(o)}).catch(l=>{o.parsedJson=null,o.error=l,a(o)}):s(o)}).catch(o=>{o.stack=n.stack,a(o)})});return n.stack=new Error().stack,n.abort=function(){r==null||r.abort()},n}static mockUrl(e,t){const r=this;(r.mockAjaxMap||(r.mockAjaxMap={}))[e]=t,Ia.originalFetch||(Ia.originalFetch=Ia.fetch,Ia.fetch=r.mockAjaxFetch.bind(r))}static async mockAjaxFetch(e,t){const r=e.split("?");let n=this.mockAjaxMap[r[0]],s=null;if(n){typeof n=="function"&&(n=await n(r[0],r[1]&&BP(r[1]),t));try{s=(t==null?void 0:t.parseJson)&&JSON.parse(n.responseText)}catch(a){s=null,n.error=a}return n=Object.assign({status:200,ok:!0,headers:new Headers,statusText:"OK",url:e,parsedJson:s,text:()=>new Promise(a=>{a(n.responseText)}),json:()=>new Promise(a=>{a(s)})},n),new Promise(function(a,o){n.synchronous?a(n):setTimeout(function(){a(n)},"delay"in n?n.delay:100)})}else return Ia.originalFetch(e,t)}};v(ow,"DEFAULT_FETCH_OPTIONS",{});var Ri=ow;Ri._$name="AjaxHelper";var Dr=typeof self!="undefined"?self:typeof globalThis!="undefined"?globalThis:null,lw=class df{static mergeLocales(...e){const t={};return e.forEach(r=>{Object.keys(r).forEach(n=>{typeof r[n]=="object"?t[n]={...t[n],...r[n]}:t[n]=r[n]})}),t}static trimLocale(e,t){const r=(n,s)=>{e[n]&&(s?e[n][s]&&delete e[n][s]:delete e[n])};Object.keys(t).forEach(n=>{Object.keys(t[n]).length>0?Object.keys(t[n]).forEach(s=>r(n,s)):r(n)})}static normalizeLocale(e,t){if(!e)throw new Error('"nameOrConfig" parameter can not be empty');if(typeof e=="string"){if(!t)throw new Error('"config" parameter can not be empty');t.locale?t.name=e||t.name:t.localeName=e}else t=e;let r={};if(t.name||t.locale)r=Object.assign({localeName:t.name},t.locale),t.desc&&(r.localeDesc=t.desc),t.code&&(r.localeCode=t.code),t.path&&(r.localePath=t.path);else{if(!t.localeName)throw new Error(`"config" parameter doesn't have "localeName" property`);r=Object.assign({},t)}for(const n of["name","desc","code","path"])r[n]&&delete r[n];if(!r.localeName)throw new Error("Locale name can not be empty");return r}static get locales(){return Dr.bryntum.locales||{}}static set locales(e){Dr.bryntum.locales=e}static get localeName(){return Dr.bryntum.locale||"En"}static set localeName(e){Dr.bryntum.locale=e||df.localeName}static get locale(){return df.localeName&&this.locales[df.localeName]||this.locales.En||Object.values(this.locales)[0]||{localeName:"",localeDesc:"",localeCoode:""}}static publishLocale(e,t){const{locales:r}=Dr.bryntum,n=df.normalizeLocale(e,t),{localeName:s}=n;return!r[s]||t===!0?r[s]=n:r[s]=this.mergeLocales(r[s]||{},n||{}),r[s]}};v(lw,"skipLocaleIntegrityCheck",!1);var $t=lw;Dr.bryntum=Dr.bryntum||{},Dr.bryntum.locales=Dr.bryntum.locales||{},$t._$name="LocaleHelper";var HP=class extends Ve($){static get defaultConfig(){return{throwOnMissingLocale:de.isTestEnv}}construct(...i){var e;const t=this;if(super.construct(...i),K.isBrowserEnv){const r=document.querySelector("script[data-default-locale]");r?t.applyLocale(r.dataset.defaultLocale):(e=t.locale)!=null&&e.localeName&&t.applyLocale(t.locale.localeName)}}get locales(){return $t.locales}set locales(i){$t.locales=i}set locale(i){this.applyLocale(i)}get locale(){return $t.locale}get localeCode(){var i,e;return(e=(i=this.locale)==null?void 0:i.localeCode)!=null?e:"en-US"}applyLocale(i,e,t=!1){const r=this;let n;if(typeof i=="string")if(typeof e!="object"){if(n=r.locales[i],!n){if(t)return!0;throw new Error(`Locale "${i}" is not published. Publish with LocaleHelper.publishLocale() before applying.`)}}else n=$t.publishLocale(i,e);else n=$t.publishLocale(i);if(r.locale.localeName&&r.locale.localeName===n.localeName&&e!==!0)return r.locale;$t.localeName=n.localeName;const s=()=>{r.trigger("locale",n)};return n.localePath?new Promise((a,o)=>{r.loadLocale(n.localePath).then(l=>{l.text().then(d=>{new Function(d)(),K.isBrowserEnv&&(n=r.locales[n.localeName],n&&delete n.localePath),s(),a(n)})}).catch(l=>o(l))}):(s(),n)}loadLocale(i){return Ri.get(i)}set throwOnMissingLocale(i){this._throwOnMissingLocale=i}get throwOnMissingLocale(){return this._throwOnMissingLocale}},jP=new HP,$e=jP,VP=Object.getPrototypeOf(Object),dw=/L{.*?}/g,cw=/L{(.*?)}/g,uw=/((.*?)\.)?(.+)/g,zP=i=>i.replace(/{(\d+)}/gm,"[[$1]]"),hw=i=>i.replace(/\[\[(\d+)]]/gm,"{$1}"),fw=Object.freeze(Object.create(null)),qe=i=>{var e;return e=class extends(i||$){static get configurable(){return{localeClass:null,localizable:null,localizableProperties:{value:[],$config:{merge:"distinct"}}}}static clsName(t){var r,n;return typeof t=="string"?t:t===VP?"Object":t.$$name||t.name||((r=t.prototype)==null?void 0:r.$$name)||((n=t.prototype)==null?void 0:n.name)}static parseLocaleString(t){const r=[];let n;if(t!=null&&t.includes("L{"))for(t=zP(t),cw.lastIndex=0;(n=cw.exec(t))!=null;){uw.lastIndex=0;const s=uw.exec(n[1]);r.push({match:hw(n[0]),localeKey:hw(s[3]),localeClass:s[2]})}return r.length>0?r:[{match:t,localeKey:t,localeClass:void 0}]}construct(t={},...r){super.construct(t,...r),$e.ion({locale:"updateLocalization",thisObj:this}),this.updateLocalization()}get localeClass(){return this._localeClass||null}localizeProperty(t){var r,n,s;const a=this,o=X.getPath(a,t),l=((r=a.$meta.configs[t])==null?void 0:r.localeKey)||((s=(n=a.fieldMap)==null?void 0:n[t])==null?void 0:s.defaultValue);let d;if(l)if(d=e.localize(l,a,a.localeClass||a),d&&!(t in(a.initialConfig||fw))&&!(t in(a.originalData||fw)))X.setPath(a.isColumn?a.data:a,t,d);else return o;else typeof o=="string"&&(a.originalLocales=a.originalLocales||{},d=X.getPath(a.originalLocales,t),d===void 0&&(X.setPath(a.originalLocales,t,o),d=o),d&&X.setPath(a,t,d=a.optionalL(d,a)));return d||o}updateLocalization(){var t,r;this.localizable!==!1&&((t=this.localizableProperties)==null||t.forEach(this.localizeProperty,this),(r=this.trigger)==null||r.call(this,"localized"))}static getTranslation(t,r,n){const s=$e.locale;let a=null,o,l;if(s)for(const{match:d,localeKey:c,localeClass:u}of this.parseLocaleString(t)){const h=g=>{var m;const p=(m=s[g])==null?void 0:m[c];return p&&(typeof p=="function"?a=r!=null?p(r):p:typeof p=="object"||t===d?a=p:a=(a||t).replace(d,p),typeof p=="string"&&p.includes("L{")&&(a=this.getTranslation(p,r,n))),p};let f=!1;for(l=n;l&&(o=e.clsName(l))&&!(f=h(o));l=Object.getPrototypeOf(l))if(typeof l=="string")break;!f&&u&&h(u)}return a}static localize(t,r=void 0,...n){(n==null?void 0:n.length)===0&&(n=[this]);let s=null;return n.some(a=>(s=e.getTranslation(t,r,a),s!=null)),s}static L(t,r=void 0,...n){(n==null?void 0:n.length)===0&&(n=[this]);const s=this.localize(t,r,...n);if(s==null&&$e.throwOnMissingLocale&&t.includes("L{"))throw new Error(`Localization is not found for '${t}' in '${n.map(a=>e.clsName(a)).join(", ")}'. ${$e.locale.localeName?`Locale : ${$e.locale.localeName}`:""}`);return s!=null?s:t}L(t,r,n=this.localeClass){const{constructor:s}=this;return n&&e.clsName(n)!==e.clsName(s)?e.L(t,r,n,s):e.L(t,r,s)}static optionalL(t,r=void 0,...n){const s=$e.throwOnMissingLocale;$e.throwOnMissingLocale=s&&dw.test(t),(n==null?void 0:n.length)===0&&(n=[this]);const a=e.L(t,r,...n);return $e.throwOnMissingLocale=s,a}optionalL(t,r=this,n=!1){const s=$e.throwOnMissingLocale;$e.throwOnMissingLocale=s&&dw.test(t)&&!n;const a=this.L(t,r);return $e.throwOnMissingLocale=s,a}get localeManager(){return $e}get localeHelper(){return $t}},v(e,"$name","Localizable"),e};function NP(i,e){const t=T.getPropertyDescriptor(i,e);return t&&(t.get||t.set)?t:null}var ee=class extends $.mixin(Ve,qe){static get configurable(){return{clientListeners:null,disabled:!1,client:null,keyMap:null}}updateClient(i){this.owner||(this.owner=i)}updateKeyMap(i){const{client:e}=this;e.keyMap=e.mergeKeyMaps(e.keyMap,i,O.uncapitalize(this.constructor.$name))}static initPlugins(i,...e){for(const t of e)this.initPlugin(i,t)}static initPlugin(i,e,t){const r=i.plugins||(i.plugins={}),n=[i];return t&&n.push(t),r[e.$$name]=new e(...n)}get enabled(){return!this.disabled}getFocusRevertTarget(){var i;return(i=this.client)==null?void 0:i.getFocusRevertTarget()}construct(...i){const e=this;let[t,r]=i,n;i.length===1?T.isObject(t)&&(r=t,t=r.client):(r=T.assign({},r),delete r.client),e.client=t,super.construct(r),e.applyPluginConfig(t),n=e.clientListeners,n&&(n=T.assign({},n),n.thisObj=e,t.ion(n))}applyPluginConfig(i){const e=this,t=e.pluginConfig||e.constructor.pluginConfig;if(t){const{assign:r,chain:n,after:s,before:a,override:o}=t;r&&e.applyAssign(i,r),(n||s)&&e.applyChain(i,n||s),a&&e.applyChain(i,a,!1),o&&e.applyOverride(i,o)}}applyAssign(i,e){e.forEach(t=>this.assign(i,t))}applyChain(i,e,t=!0){if(Array.isArray(e))for(const r of e)this.chain(i,r,r,t);else for(const r in e)this.chain(i,r,e[r],t)}applyOverride(i,e){const t=this;t.overridden||(t.overridden={}),e.forEach(r=>{if(!t[r])throw new Error(`Trying to chain fn ${i.$$name}#${r}, but plugin fn ${t.$$name}#${r} does not exist`);typeof i[r]=="function"&&(t.overridden[r]=i[r].bind(i)),i[r]=t[r].bind(t)})}assign(i,e){const t=this,r=NP(t,e);r?Object.defineProperty(i,e,{configurable:!0,enumerable:!0,get:r.get&&r.get.bind(t),set:r.set&&r.set.bind(t)}):i[e]=t[e].bind(t)}chain(i,e,t,r=!0){let n=0;typeof e=="object"&&(e=e.fn),typeof t=="object"&&(n=t.prio||0,t=t.fn);const s=this,a=i.pluginFunctionChain||(i.pluginFunctionChain={}),o=s[t]&&s[t].bind(s),l=s.functionChainRunner;if(!o)throw new Error(`Trying to chain fn ${i.$$name}#${t}, but plugin fn ${s.$$name}#${t} does not exist`);if(!a[e]){let d=i[e];d&&(d=d.bind(i),d.$this=i,d.$prio=0),a[e]=d?[d]:[],i[e]=(...c)=>l(a[e],c)}o.$this=s,o.$prio=n,a[e][r?"push":"unshift"](o),a[e].$sorted=!1}functionChainRunner(i,e){let t,r,n;for(i.$sorted||(i.sort((s,a)=>a.$prio-s.$prio),i.$sorted=!0),r=0;r<i.length&&(t=i[r],!(!t.$this.isDestroyed&&(n=t(...e),n===!1)));r++);return n}doDisable(i){var e,t,r,n;const s=this,{constructor:a}=s,o="featureClass"in a?a.featureClass:`b-${a.$$name.toLowerCase()}`,l=O.uncapitalize(a.$$name);o&&((t=(e=s.client)==null?void 0:e._element)==null||t.classList[i?"remove":"add"](o)),s.isConfiguring||(i?s.trigger("disable"):s.trigger("enable"),(n=(r=s.client).syncSplits)==null||n.call(r,d=>{const c=d.features[l];c&&(c.disabled=i)}))}updateDisabled(i){this.doDisable(i)}throwOverrideIsMissing(i){throw new Error(`Trying to override fn ${i.plugIntoName}#${i.fnName}, but plugin fn ${i.pluginName}#${i.fnName} does not exist`)}get rootElement(){return this.client.rootElement}get state(){var i;return(i=this.constructor.stateProperties)==null?void 0:i.reduce((e,t)=>(e[t]=this[t],e),{})}};v(ee,"$name","InstancePlugin"),ee._$name="InstancePlugin";var rv=i=>{var e;return e=class extends(i||$){get plugins(){return this._plugins||(this._plugins={}),this._plugins}set plugins(t){t&&(Array.isArray(t)||(t=[t]),ee.initPlugins(this,...t)),this.initPlugins()}initPlugins(){}addPlugins(...t){ee.initPlugins(this,...t)}addPlugin(t,r){return ee.initPlugin(this,t,r)}hasPlugin(t){return this.getPlugin(t)!=null}getPlugin(t){var r;return typeof t=="function"&&(t=t.$$name),(r=this.plugins)==null?void 0:r[t]}get widgetClass(){}},v(e,"$name","Pluggable"),e},WP={localeName:"En",localeDesc:"English (US)",localeCode:"en-US",Object:{Yes:"Yes",No:"No",Cancel:"Cancel",Ok:"OK",Week:"Week",None:"None"},CodeEditor:{apply:"Apply",autoApply:"Auto apply",downloadCode:"Download code",editor:"Code editor",viewer:"Code viewer"},ColorPicker:{noColor:"No color"},Combo:{noResults:"No results",recordNotCommitted:"Record could not be added",addNewValue:i=>`Add ${i}`},FilePicker:{file:"File"},Field:{badInput:"Invalid field value",patternMismatch:"Value should match a specific pattern",rangeOverflow:i=>`Value must be less than or equal to ${i.max}`,rangeUnderflow:i=>`Value must be greater than or equal to ${i.min}`,stepMismatch:"Value should fit the step",tooLong:"Value should be shorter",tooShort:"Value should be longer",typeMismatch:"Value is required to be in a special format",valueMissing:"This field is required",invalidValue:"Invalid field value",minimumValueViolation:"Minimum value violation",maximumValueViolation:"Maximum value violation",fieldRequired:"This field is required",validateFilter:"Value must be selected from the list"},DateField:{invalidDate:"Invalid date input"},DatePicker:{gotoPrevYear:"Go to previous year",gotoPrevMonth:"Go to previous month",gotoNextMonth:"Go to next month",gotoNextYear:"Go to next year"},NumberFormat:{locale:"en-US",currency:"USD"},DurationField:{invalidUnit:"Invalid unit"},TimeField:{invalidTime:"Invalid time input"},TimePicker:{hour:"Hour",minute:"Minute",second:"Second"},List:{loading:"Loading...",selectAll:"Select All"},GridBase:{loadMask:"Loading...",syncMask:"Saving changes, please wait..."},PagingToolbar:{firstPage:"Go to first page",prevPage:"Go to previous page",page:"Page",nextPage:"Go to next page",lastPage:"Go to last page",reload:"Reload current page",noRecords:"No records to display",pageCountTemplate:i=>`of ${i.lastPage}`,summaryTemplate:i=>`Displaying records ${i.start} - ${i.end} of ${i.allCount}`},PanelCollapser:{Collapse:"Collapse",Expand:"Expand"},Popup:{close:"Close"},UndoRedo:{Undo:"Undo",Redo:"Redo",UndoLastAction:"Undo last action",RedoLastAction:"Redo last undone action",NoActions:"No items in the undo queue"},FieldFilterPicker:{equals:"equals",doesNotEqual:"does not equal",isEmpty:"empty",isNotEmpty:"not empty",contains:"contains",doesNotContain:"does not contain",startsWith:"starts with",endsWith:"ends with",isOneOf:"one of",isNotOneOf:"not one of",isGreaterThan:"greater than",isLessThan:"less than",isGreaterThanOrEqualTo:"greater or equals",isLessThanOrEqualTo:"less or equals",isBetween:"between",isNotBetween:"not between",isBefore:"before",isAfter:"after",isToday:"today",isTomorrow:"tomorrow",isYesterday:"yesterday",isThisWeek:"this week",isNextWeek:"next week",isLastWeek:"last week",isThisMonth:"this month",isNextMonth:"next month",isLastMonth:"last month",isThisYear:"this year",isNextYear:"next year",isLastYear:"last year",isYearToDate:"year to date",isTrue:"true",isFalse:"false",selectAProperty:"Select property",selectAnOperator:"Select operator",caseSensitive:"Case-sensitive",and:"and",dateFormat:"D/M/YY",selectValue:"Select value",selectOneOrMoreValues:"Select value(s)",enterAValue:"Enter value",enterANumber:"Enter number",selectADate:"Select date",selectATime:"Select time"},FieldFilterPickerGroup:{addFilter:"Add filter"},DateHelper:{locale:"en-US",weekStartDay:0,nonWorkingDays:{0:!0,6:!0},weekends:{0:!0,6:!0},unitNames:[{single:"millisecond",plural:"ms",abbrev:"ms"},{single:"second",plural:"seconds",abbrev:"s"},{single:"minute",plural:"minutes",abbrev:"min"},{single:"hour",plural:"hours",abbrev:"h"},{single:"day",plural:"days",abbrev:"d"},{single:"week",plural:"weeks",abbrev:"w"},{single:"month",plural:"months",abbrev:"mon"},{single:"quarter",plural:"quarters",abbrev:"q"},{single:"year",plural:"years",abbrev:"yr"},{single:"decade",plural:"decades",abbrev:"dec"}],unitAbbreviations:[["mil"],["s","sec"],["m","min"],["h","hr"],["d"],["w","wk"],["mo","mon","mnt"],["q","quar","qrt"],["y","yr"],["dec"]],parsers:{L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A"},ordinalSuffix:i=>{const e=["11","12","13"].find(r=>i.endsWith(r));let t="th";if(!e){const r=i[i.length-1];t={1:"st",2:"nd",3:"rd"}[r]||"th"}return i+t}}},gH=$t.publishLocale(WP),{toString:gw}=Object.prototype,UP=gw.call(new Date),Tf=new Date,nv=1e3*60*60,sv=(i,e)=>isNaN(i)||i==null?e:i,GP=/([ES]){([^}]+)}/g,mw=i=>{const e=["11","12","13"].find(r=>i.endsWith(r));let t="th";if(!e){const r=i[i.length-1];t={1:"st",2:"nd",3:"rd"}[r]||"th"}return i+t},Ct=(i,e,t)=>(nn[i]||(nn[i]=new Intl.DateTimeFormat(rn,e))).format(t),Vd=(i,e,t,r=!1)=>{let n=Ct(i,e,t);return/am|pm/i.test(n)&&(n=n.replace(/^0/,""),r&&(n=n.replace(/:00/,""))),n},YP=(i,e)=>Math.floor((i.getTime()-e.getTime()-(i.getTimezoneOffset()-e.getTimezoneOffset())*Bt.minute.millisecond)/Bt.day.millisecond)+1,pw=i=>i>=0?i:i+7,qP=/([^\w])(S+)/gm,KP=(i,e)=>e+"SSS",vw=/[:.\-/\s]/,rn="en-US",wr=mw,Mf={},zd={},nn={},av={},yw=i=>{const e=ov[i];if(!e)throw new Error("Only international formats should be used here");if(zd[i]!==void 0)return zd[i];const t=new Intl.DateTimeFormat(rn,e),r=t.formatToParts(new Date(2001,1,2,3,4,5,6)).map(n=>{const s=n.type,a=e[s];if(s==="literal")return n.value.replace(/,/g,"");if(s==="day")return a==="numeric"?"D":"DD";if(s==="month")return a==="short"?"MMM":a==="long"?"MMMM":a==="numeric"?"M":"MM";if(s==="year")return a==="numeric"?"YYYY":"YY"}).join("");return zd[i]=r},bw=2020,Cw=0,Sw=1,ov={l:{year:"numeric",month:"numeric",day:"numeric"},ll:{year:"numeric",month:"short",day:"numeric"}},ht={M:i=>i.getMonth()+1,Mo:i=>wr(ht.M(i).toString()),MM:i=>(i.getMonth()+1).toString().padStart(2,"0"),MMM:i=>Ct("MMM",{month:"short"},i),MMMM:i=>Ct("MMMM",{month:"long"},i),Q:i=>Math.ceil((i.getMonth()+1)/3),Qo:i=>wr(ht.Q(i).toString()),D:i=>i.getDate(),Do:i=>wr(ht.D(i).toString()),DD:i=>i.getDate().toString().padStart(2,"0"),DDD:i=>Math.ceil((new Date(i.getFullYear(),i.getMonth(),i.getDate(),12,0,0)-new Date(i.getFullYear(),0,0,12,0,0))/Bt.day.millisecond),DDDo:i=>wr(ht.DDD(i).toString()),DDDD:i=>ht.DDD(i).toString().padStart(3,"0"),d:i=>i.getDay(),do:i=>wr(i.getDay().toString()),d1:i=>Ct("d1",{weekday:"narrow"},i).substr(0,1),dd:i=>ht.ddd(i).substring(0,2),ddd:i=>Ct("ddd",{weekday:"short"},i),dddd:i=>Ct("dddd",{weekday:"long"},i),u:i=>{const e=nn.u||(nn.u=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",year:"numeric",month:"2-digit",day:"2-digit"})),t=e.formatToParts(i);return`${t[4].value}${t[2].value}${t[0].value}Z`},uu:i=>{const e=nn.uu||(nn.uu=new Intl.DateTimeFormat("en-GB",{timeZone:"UTC",hour12:!1,year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit",second:"2-digit"})),t=e.formatToParts(i);return`${t[4].value}${t[2].value}${t[0].value}T${t[6].value}${t[8].value}${t[10].value}Z`},e:i=>i.getDay(),E:i=>i.getDay()+1,W:i=>w.getWeekNumber(i)[1],Wo:i=>wr(ht.W(i).toString()),WW:i=>ht.W(i).toString().padStart(2,"0"),Wp:i=>`${w.localize("L{Week}")} ${ht.W(i)}`,WWp:i=>`${w.localize("L{Week}")} ${ht.WW(i)}`,Wp0:i=>`${w.localize("L{Week}")[0]}${ht.W(i)}`,WWp0:i=>`${w.localize("L{Week}")[0]}${ht.WW(i)}`,Y:i=>i.getFullYear(),YY:i=>(i.getFullYear()%100).toString().padStart(2,"0"),YYYY:i=>i.getFullYear(),A:i=>i.getHours()<12?"AM":"PM",a:i=>i.getHours()<12?"am":"pm",H:i=>i.getHours(),HH:i=>i.getHours().toString().padStart(2,"0"),h:i=>i.getHours()%12||12,hh:i=>ht.h(i).toString().padStart(2,"0"),k:i=>i.getHours()||24,kk:i=>ht.k(i).toString().padStart(2,"0"),K:i=>Vd("K",{hour:"numeric"},i),KK:i=>Vd("KK",{hour:"2-digit"},i),m:i=>i.getMinutes(),mm:i=>ht.m(i).toString().padStart(2,"0"),s:i=>i.getSeconds(),ss:i=>ht.s(i).toString().padStart(2,"0"),S:i=>Math.floor(i.getMilliseconds()/100).toString(),SS:i=>Math.floor(i.getMilliseconds()/10).toString().padStart(2,"0"),SSS:i=>i.getMilliseconds().toString().padStart(3,"0"),z:i=>Ct("z",{timeZoneName:"short"},i),zz:i=>Ct("zz",{timeZoneName:"long"},i),Z:i=>B.getGMTOffset(i),LT:i=>Vd("LT",{hour:"2-digit",minute:"2-digit"},i),LST:i=>Vd("LST",{hour:"numeric",minute:"2-digit"},i,!0),LTS:i=>Vd("LTS",{hour:"2-digit",minute:"2-digit",second:"2-digit"},i),L:i=>Ct("L",{year:"numeric",month:"2-digit",day:"2-digit"},i),l:i=>Ct("l",ov.l,i),LL:i=>Ct("LL",{year:"numeric",month:"long",day:"numeric"},i),ll:i=>Ct("ll",ov.ll,i),LLL:i=>Ct("LLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit"},i),lll:i=>Ct("lll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit"},i),LLLL:i=>Ct("LLLL",{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"long"},i),llll:i=>Ct("llll",{year:"numeric",month:"short",day:"numeric",hour:"numeric",minute:"2-digit",weekday:"short"},i)},XP=Object.keys(ht).sort((i,e)=>e.length-i.length),ZP=`^(?:${XP.join("|")})`,Dt=()=>({}),QP=i=>aA.test(i),lv=i=>QP(i)&&{milliseconds:parseInt(i.padEnd(3,"0").substring(0,3))},Dw={YYYY:i=>{const e=parseInt(i);return{year:e>=1e3&&e<=9999?e:NaN}},Y:i=>({year:parseInt(i)}),YY:i=>{const e=parseInt(i);return{year:e+(e>1968?1900:2e3)}},M:i=>({month:parseInt(i)-1}),MM:i=>({month:parseInt(i)-1}),Mo:i=>({month:parseInt(i)-1}),MMM:i=>{const e=(i||"").toLowerCase();for(const[t,r]of Object.entries(w._monthShortNamesIndex))if(e.startsWith(t))return{month:r.value}},MMMM:i=>{const e=(i||"").toLowerCase();for(const[t,r]of Object.entries(w._monthNamesIndex))if(e.startsWith(t))return{month:r.value}},DD:i=>({date:parseInt(i)}),D:i=>({date:parseInt(i)}),Do:i=>({date:parseInt(i)}),DDD:Dt,DDDo:Dt,DDDD:Dt,d:Dt,do:Dt,d1:Dt,dd:Dt,ddd:Dt,dddd:Dt,Q:Dt,Qo:Dt,W:Dt,Wo:Dt,WW:Dt,e:Dt,E:Dt,HH:i=>({hours:parseInt(i)}),hh:i=>({hours:parseInt(i)}),mm:i=>({minutes:parseInt(i)}),H:i=>({hours:parseInt(i)}),m:i=>({minutes:parseInt(i)}),ss:i=>({seconds:parseInt(i)}),s:i=>({seconds:parseInt(i)}),S:lv,SS:lv,SSS:lv,A:i=>({amPm:i.toLowerCase()}),a:i=>({amPm:i.toLowerCase()}),L:"MM/DD/YYYY",LT:"HH:mm A",LTS:"HH:mm:ss A",l:{type:"dynamic",parser:()=>yw("l")},ll:{type:"dynamic",parser:()=>yw("ll")},Z:i=>{if(!i||!xw.test(i)&&i!=="Z")return null;let e=0;if(i!=="Z"){const t=xw.exec(i);if(t){const r=t[1]==="+"?1:-1,n=parseInt(t[2])||0,s=parseInt(t[3])||0;e=r*(n*60+s)}else e=-1*new Date().getTimezoneOffset()}return{timeZone:e}}},JP=Object.keys(Dw).sort((i,e)=>e.length-i.length),ww=new RegExp(`(${JP.join("|")})`),eA=new RegExp("^(LL|LLL|lll|LLLL|llll)$"),Bt={decade:{decade:1,year:10,quarter:40,month:120,week:520,day:3652,hour:24*3652,minute:1440*3652,second:86400*3652,millisecond:864e5*3652},year:{decade:.1,year:1,quarter:4,month:12,week:52,day:365,hour:24*365,minute:1440*365,second:86400*365,millisecond:864e5*365},quarter:{decade:1/40,year:1/4,quarter:1,month:3,week:4,day:91,hour:24*91,minute:1440*91,second:86400*91,millisecond:864e5*91},month:{decade:1/120,year:1/12,quarter:1/3,month:1,week:4,day:-30,hour:-24*30,minute:-1440*30,second:-86400*30,millisecond:-864e5*30},week:{decade:-1/520,year:-1/52,quarter:-1/13,month:-1/4,day:7,hour:168,minute:10080,second:604800,millisecond:6048e5},day:{decade:-1/3652,year:-1/365,quarter:-1/91,month:-1/30,week:1/7,hour:24,minute:1440,second:86400,millisecond:864e5},hour:{decade:-1/(3652*24),year:-1/(365*24),quarter:-1/(91*24),month:-1/(30*24),week:1/168,day:1/24,minute:60,second:3600,millisecond:36e5},minute:{decade:-1/(3652*1440),year:-1/(365*1440),quarter:-1/(91*1440),month:-1/(30*1440),week:1/10080,day:1/1440,hour:1/60,second:60,millisecond:6e4},second:{decade:-1/(3652*86400),year:-1/(365*86400),quarter:-1/(91*86400),month:-1/(30*86400),week:1/604800,day:1/86400,hour:1/3600,minute:1/60,millisecond:1e3},millisecond:{decade:-1/(3652*864e5),year:-1/(365*864e5),quarter:-1/(91*864e5),month:-1/(30*864e5),week:1/6048e5,day:1/864e5,hour:1/36e5,minute:1/6e4,second:1/1e3}},Ew={ms:"millisecond",milliseconds:"millisecond",s:"second",seconds:"second",m:"minute",mi:"minute",min:"minute",minutes:"minute",h:"hour",hours:"hour",d:"day",days:"day",w:"week",weeks:"week",M:"month",mo:"month",mon:"month",months:"month",q:"quarter",quarters:"quarter",y:"year",years:"year",dec:"decade",decades:"decade"},tA=/^\s*([-+]?\d+(?:[.,]\d*)?|[-+]?(?:[.,]\d+))\s*([^\s]+)?/i,iA=/^\s*([-+]?\d+)(?![.,])\s*([^\s]+)?/i,Oa=["millisecond","second","minute","hour","day","week","month","quarter","year","decade"],rA=[["mil"],["s","sec"],["m","min"],["h","hr"],["d"],["w","wk"],["mo","mon","mnt"],["q","quar","qrt"],["y","yr"],["dec"]],dv=["decade","year","month","week","day","hour","minute","second","millisecond"],nA=["milliseconds","seconds","minutes","hours","date","month","year"],sA=i=>{const e=parseFloat(i);return isNaN(e)?null:e},aA=/^[0-9]+$/,xw=/([+-])(\d\d):*(\d\d)*$/,ui={millisecond:0,second:1,minute:2,hour:3,day:4,week:5,month:6,quarter:7,year:8,decade:9},oA={round(i,e=1){return Math.round(i/e)*e},floor(i,e=1){return Math.floor(i/e)*e},ceil(i,e=1){return Math.ceil(i/e)*e}},Rw={},cv=class Lt extends qe(){static set defaultFormat(e){B._defaultFormat=e}static get defaultFormat(){return B._defaultFormat||"YYYY-MM-DDTHH:mm:ssZ"}static set defaultParseFormat(e){this._defaultParseFormat=e}static get defaultParseFormat(){return this._defaultParseFormat||this._defaultFormat||"YYYY-MM-DDTHH:mm:ss.SSSZ"}static get today(){return Lt.clearTime(new Date,!1)}static get tomorrow(){return Lt.add(Lt.today,1,"day")}static get yesterday(){return Lt.add(Lt.today,-1,"day")}static buildParser(e){const t=e.split(ww),r=[];return t.length===1||eA.test(e)?[]:(t.reduce((n,s,a,o)=>{if(a!==0||s!=="")if(ww.test(s)){const l=this.localize("L{parsers}")||{},d=l[s]||Dw[s];if(s==="Z"&&a<o.length-2)throw new Error(`Invalid format ${e} TimeZone (Z) must be last token`);const c=typeof d=="function"||typeof d=="string"?d:d.parser();if(typeof c=="string"){const u=B.buildParser(c),h=u.pop();delete h.last,r.push(...u),n=h}else n.pattern=s,n.fn=c}else n.splitter=s,r.push(n),n={};else Object.prototype.hasOwnProperty.call(n,"pattern")&&r.push(n);return n},{}),r[r.length-1].last=!0,r)}static makeKey(e){if(e.length===10)return e;e.getTime&&(e=e.getTime());const t=Rw[Math.trunc(e/nv)];if(t)return t;Tf.setTime(e);const r=Tf.getMonth()+1,n=Tf.getDate();return Rw[Math.trunc(e/nv)]=`${Tf.getFullYear()}-${r<10?"0"+r:r}-${n<10?"0"+n:n}`}static parseKey(e){return B.parse(e,"YYYY-MM-DD")}static parse(e,t=B.defaultParseFormat,r=!1){if(e instanceof Date)return e;if(typeof e!="string"||!e)return null;const n={year:null,month:null,date:null,hours:null,minutes:null,seconds:null,milliseconds:null};t=t.replace(qP,KP);let s=av[t],a;if(s||(s=av[t]=B.buildParser(t)),e.includes("\u202F")&&(e=e.replace(/\s/g," ")),s.reduce((l,d)=>{var c;if(d.last)Object.assign(n,d.fn(l));else{let u;if(d.splitter==="T"&&l.indexOf("T")===-1)u=l.indexOf(" ");else{const g=l.indexOf("+");let{splitter:m}=d;!r&&vw.test(m)&&(m=vw),u=d.splitter!==""?l.search(typeof m=="string"?O.escapeRegExp(m):m):((c=d.pattern)==null?void 0:c.length)||-1,g>-1&&u>g&&(u=-1)}let h,f;if(u===-1||d.pattern==="SSS"&&l.match(/^\d+Z$/)){const g=l.split(/([Z\-+])/);g.length===1?(h=l,f=""):(h=g[0],f=`${g[1]}${g[2]}`)}else h=l.substring(0,u)||l,f=l.substring(u+d.splitter.length);if(d.fn){const g=d.fn(h);g?Object.assign(n,g):f=h+f}return f}},e),n.year&&!n.date&&(n.date=1),n.date>31||n.month>12)return null;const o=B.create(n,r);return o?a=o:r||(a=new Date(e)),a}static create(e,t=!1){const r={...e};let n=isNaN(r.year)||t&&(isNaN(r.month)||isNaN(r.date)),s=!1;if(!n){let o=!0;nA.forEach(l=>{(!(l in r)||isNaN(r[l]))&&(r[l]=0),o=o&&r[l]===null}),n=o}if(n||(r.amPm==="am"?r.hours=r.hours%12:r.amPm==="pm"&&(r.hours=r.hours%12+12),"timeZone"in r&&(s=!0,r.minutes-=r.timeZone),t&&(r.year==null||r.month==null||r.date==null)))return null;const a=[sv(r.year,bw),sv(r.month,Cw),sv(r.date,Sw),r.hours,r.minutes,r.seconds,r.milliseconds];return s?new Date(Date.UTC(...a)):new Date(...a)}static toUTC(e){return new Date(Date.UTC(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds()))}static format(e,t=B.defaultFormat){if(!e||isNaN(e))return null;let r=Mf[t],n="";if(!r){r=Mf[t]=[];for(let s=0;s<t.length;s++){const a=t.slice(s).match(ZP),o=a==null?void 0:a[0];if(o){const l=this.localize("L{formats}")||{},d=l[o]||ht[o];r.push(d),s+=o.length-1}else if(t[s]==="{"){const l=t.indexOf("}",s+1);l===-1?(r.push(t.substr(s+1)),s=t.length):(r.push(t.substring(s+1,l)),s=l)}else r.push(t[s])}}return r.forEach(s=>{typeof s=="string"?n+=s:n+=s(e)}),n}static formatRange(e,t){return t.replace(GP,(r,n,s)=>Lt.format(e[n==="S"?0:1],s))}static asMilliseconds(e,t=null){return typeof e=="string"&&(t=e,e=1),B.as("millisecond",e,t)}static asMonths(e){const t=B.as("ms",B.daysInMonth(e),"day"),r=(e.valueOf()-B.startOf(e,"month").valueOf())/t;return e.getYear()*12+e.getMonth()+r}static monthsToDate(e){const t=Math.floor(e),r=e-t,n=new Date(0,t),s=B.as("ms",B.daysInMonth(n),"days");return n.setTime(n.getTime()+r*s),n}static formatDelta(e,t){let r,n,s=", ";typeof t=="boolean"?r=t:t&&(r=t.abbrev,s=t.unitSeparator||s);const a=this.getDelta(e,t),o=[],l=(t==null?void 0:t.separator)||(r?"":" ");for(n in a)o.push(`${a[n]}${l}${n}`);return(t==null?void 0:t.asString)===!1?o:o.join(s)}static getDelta(e,t){let r,n,s,a,o,l,d;typeof t=="boolean"?r=t:t&&(r=t.abbrev,a=B.normalizeUnit(t.precision),l=t.maxUnit,d=!r&&t.ignoreLocale);const c={},u=r?B.getShortNameOfUnit:B.getLocalizedNameOfUnit,h=l?dv.slice(dv.indexOf(l)):dv;for(o of h)if(n=B.as(o,e),s=a===o,n=Math[s?"round":"floor"](n),(n||s&&!c.length)&&(c[d?o:u.call(B,o,n!==1)]=n,e-=B.as("ms",n,o)),s||!e)break;return c}static as(e,t,r="ms"){return typeof t=="string"&&(t=B.parseDuration(t)),typeof t=="object"&&(r=t.unit,t=t.magnitude),e===r||(e=B.normalizeUnit(e),r=B.normalizeUnit(r),e===r)?t:ui[r]>ui[e]?t*Math.abs(Bt[r][e]):t/Math.abs(Bt[e][r])}static formatContainsHourInfo(e){const t=/(\\.)/g;return/([HhKkmSsAa]|LT|L{3,}|l{3,})/.test(e.replace(t,""))}static is24HourFormat(e){return B.format(B.getTime(13,0,0),e).includes("13")}static add(e,t,r="ms",n=!0){let s;if(typeof e=="string"?s=B.parse(e):n?s=new Date(e.getTime()):s=e,typeof t=="string"){const a=Lt.parseDuration(t);t=a.magnitude,r=a.unit}else t&&typeof t=="object"&&(r=t.unit,t=t.magnitude);if(!r||t===0)return s;switch(r=B.normalizeUnit(r),r){case"millisecond":s.setTime(s.getTime()+t);break;case"second":s.setTime(s.getTime()+t*1e3);break;case"minute":s.setTime(s.getTime()+t*6e4);break;case"hour":s.setTime(s.getTime()+t*36e5);break;case"day":t%1===0?(s.setDate(s.getDate()+t),s.getHours()===23&&e.getHours()===0&&s.setHours(s.getHours()+1)):s.setTime(s.getTime()+t*864e5);break;case"week":s.setDate(s.getDate()+t*7);break;case"month":{let a=s.getDate();a>28&&(a=Math.min(a,B.getLastDateOfMonth(B.add(B.getFirstDateOfMonth(s),t,"month")).getDate())),s.setDate(a),s.setMonth(s.getMonth()+t);break}case"quarter":B.add(s,t*3,"month",!1);break;case"year":s.setFullYear(s.getFullYear()+t);break;case"decade":s.setFullYear(s.getFullYear()+t*10);break}return s}static diff(e,t,r="ms",n=!0){if(r=B.normalizeUnit(r),!e||!t)return 0;let s;switch(r){case"year":s=B.diff(e,t,"month")/12;break;case"quarter":s=B.diff(e,t,"month")/3;break;case"month":s=(t.getFullYear()-e.getFullYear())*12+(t.getMonth()-e.getMonth()),s===0&&n&&(s=B.diff(e,t,"day",n)/B.daysInMonth(e));break;case"week":s=B.diff(e,t,"day")/7;break;case"day":{const a=e.getTimezoneOffset()-t.getTimezoneOffset();s=(t-e+a*60*1e3)/864e5;break}case"hour":s=(t-e)/36e5;break;case"minute":s=(t-e)/6e4;break;case"second":s=(t-e)/1e3;break;case"millisecond":s=t-e;break}return n?s:Math.round(s)}static startOf(e,t="day",r=!0,n=B.weekStartDay){if(!e)return null;switch(t=B.normalizeUnit(t),r&&(e=B.clone(e)),t){case"year":return e.setMonth(0,1),e.setHours(0,0,0,0),e;case"quarter":return e.setMonth((B.get(e,"quarter")-1)*3,1),e.setHours(0,0,0,0),e;case"month":return e.setDate(1),e.setHours(0,0,0,0),e;case"week":{let a=e.getDay()-n;return a<0&&(a+=7),e.setDate(e.getDate()-a),e.setHours(0,0,0,0),e}case"day":return e.setHours(0,0,0,0),e;case"hour":e.getMinutes()>0&&e.setMinutes(0);case"minute":e.getSeconds()>0&&e.setSeconds(0);case"second":e.getMilliseconds()>0&&e.setMilliseconds(0);case"millisecond":return e}}static endOf(e){return new Date(e.getFullYear(),e.getMonth(),e.getDate()+1)}static clone(e){return new Date(e.getTime())}static clearTime(e,t=!0){return e?(t&&(e=new Date(e.getTime())),e.setHours(0,0,0,0),e):null}static midnight(e,t){let r=B.clearTime(e);return t&&r<e&&(r=B.add(r,1,"d")),r}static isMidnight(e){return B.midnight(e).getTime()===e.getTime()}static getTimeOfDay(e,t="ms"){const r=e.getHours()*Bt.hour.millisecond+e.getMinutes()*Bt.minute.millisecond+e.getSeconds()*Bt.second.millisecond+e.getMilliseconds();return t==="ms"?r:B.as(t,r,"ms")}static set(e,t,r){if(!t)return e;if(typeof t=="string")switch(B.normalizeUnit(t)){case"millisecond":(r!==0||e.getMilliseconds()>0)&&e.setMilliseconds(r);break;case"second":(r!==0||e.getSeconds()>0)&&e.setSeconds(r);break;case"minute":(r!==0||e.getMinutes()>0)&&e.setMinutes(r);break;case"hour":e.setHours(r);break;case"day":case"date":e.setDate(r);break;case"week":throw new Error("week not implemented");case"month":e.setMonth(r);break;case"quarter":e.setDate(1),e.setMonth((r-1)*3);break;case"year":e.setFullYear(r);break}else Object.entries(t).sort((n,s)=>ui[n[0]]-ui[s[0]]).forEach(([n,s])=>{B.set(e,n,s)});return e}static setDateToMidday(e,t=!0){return B.set(B.clearTime(e,t),"hour",12)}static constrain(e,t,r){return t!=null&&(e=B.max(e,t)),r==null?e:B.min(e,r)}static getTime(e,t=0,r=0,n=0){return e instanceof Date&&(n=e.getMilliseconds(),r=e.getSeconds(),t=e.getMinutes(),e=e.getHours()),new Date(bw,Cw,Sw,e,t,r,n)}static copyTimeValues(e,t){return e.setHours(t.getHours()),e.setMinutes(t.getMinutes()),e.setSeconds(t.getSeconds()),e.setMilliseconds(t.getMilliseconds()),e}static combineDateAndTime(e,t){return Lt.copyTimeValues(new Date(e),t)}static get isDSTEnabled(){const e=new Date().getFullYear(),t=new Date(e,0,1),r=new Date(e,6,1);return t.getTimezoneOffset()!==r.getTimezoneOffset()}static isDST(e){const t=e.getFullYear(),r=new Date(t,0,1),n=new Date(t,6,1);return e.getTimezoneOffset()<Math.max(r.getTimezoneOffset(),n.getTimezoneOffset())}static isBefore(e,t){return e<t}static isAfter(e,t){return e>t}static isEqual(e,t,r=null){return r===null?e&&t&&e.getTime()===t.getTime():B.startOf(e,r)-B.startOf(t,r)===0}static compare(e,t,r=null){return r&&(e=B.startOf(e,r),t=B.startOf(t,r)),e<t?-1:e>t?1:0}static clamp(e,t,r){if(!isNaN(e))return t!=null&&(e=Math.max(e,t)),r!=null&&(e=Math.min(e,r)),new Date(e)}static isSameDate(e,t){return B.compare(e,t,"d")===0}static isSameTime(e,t){return e.getHours()===t.getHours()&&e.getMinutes()===t.getMinutes()&&e.getSeconds()===t.getSeconds()&&e.getMilliseconds()===t.getMilliseconds()}static isStartOf(e,t){return B.isEqual(e,B.startOf(e,t))}static betweenLesser(e,t,r){return t.getTime()<=e.getTime()&&e.getTime()<r.getTime()}static betweenLesserEqual(e,t,r){return t.getTime()<=e.getTime()&&e.getTime()<=r.getTime()}static intersectSpans(e,t,r,n){return B.betweenLesser(e,r,n)||B.betweenLesser(r,e,t)}static compareUnits(e,t){return Math.sign(ui[B.normalizeUnit(e)]-ui[B.normalizeUnit(t)])}static timeSpanContains(e,t,r,n){return r-e>=0&&t-n>=0}static get weekStartDay(){return B._weekStartDay==null&&(B._weekStartDay=this.localize("L{weekStartDay}")||0),B._weekStartDay}static get nonWorkingDays(){return{...this.localize("L{nonWorkingDays}")}}static get nonWorkingDaysAsArray(){return Object.keys(this.nonWorkingDays).map(Number)}static get weekends(){return{...this.localize("L{weekends}")}}static get(e,t){switch(B.normalizeUnit(t)){case"millisecond":return e.getMilliseconds();case"second":return e.getSeconds();case"minute":return e.getMinutes();case"hour":return e.getHours();case"date":case"day":return e.getDate();case"week":return ht.W(e);case"month":return e.getMonth();case"quarter":return Math.floor(e.getMonth()/3)+1;case"year":return e.getFullYear()}return null}static daysInYear(e){const t=e.getFullYear(),r=new Date(t+1,0,1)-new Date(t,0,1);return this.as("day",r)}static daysInMonth(e){return 32-new Date(e.getFullYear(),e.getMonth(),32).getDate()}static hoursInDay(e){const t=e.getFullYear(),r=e.getMonth(),n=e.getDate(),s=new Date(t,r,n+1)-new Date(t,r,n);return this.as("hour",s)}static getNormalizedUnitDuration(e,t){let r;switch(t){case"month":r=B.asMilliseconds(B.daysInMonth(e),"day");break;case"year":r=B.asMilliseconds(B.daysInYear(e),"day");break;case"day":r=B.asMilliseconds(B.hoursInDay(e),"hour");break;default:r=B.asMilliseconds(t)}return r}static getFirstDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth(),1)}static getLastDateOfMonth(e){return new Date(e.getFullYear(),e.getMonth()+1,0)}static min(e,t){return e.getTime()<t.getTime()?e:t}static max(e,t){return e.getTime()>t.getTime()?e:t}static getNext(e,t,r=1,n=B.weekStartDay){if(t==="week"){const s=B.clone(e),a=s.getDay();return B.startOf(s,"day",!1),B.add(s,n-a+7*(r-(n<=a?0:1)),"day",!1),s.getDay()!==n&&B.add(s,1,"hour"),s}return B.startOf(B.add(e,r,t),t,!1)}static isValidDate(e){return B.isDate(e)&&!isNaN(e)}static isDate(e){return e&&gw.call(e)===UP}static getStartOfNextDay(e,t=!1,r=!1){let n=B.add(r?e:B.clearTime(e,t),1,"day");if(n.getDate()===e.getDate()){const s=B.add(B.clearTime(e,t),2,"day").getTimezoneOffset(),a=e.getTimezoneOffset();n=B.add(n,a-s,"minute")}return n}static getEndOfPreviousDay(e,t=!1){const r=t?e:B.clearTime(e,!0);return r-e?r:B.add(r,-1,"day")}static getWeekDescription(e,t=e){const r=e.getMonth()===t.getMonth()?Lt.format(e,"MMMM"):`${Lt.format(e,"MMM")} - ${Lt.format(t,"MMM")}`,n=Lt.getWeekNumber(e);return`${n[1]}, ${r} ${n[0]}`}static getWeekNumber(e,t=Lt.weekStartDay){const r=new Date(e.getFullYear(),0,1),n=new Date(e.getFullYear(),11,31),s=pw(r.getDay()-t),a=pw(n.getDay()-t),o=YP(e,r);let l;if(s<4?l=Math.floor((o+s-1)/7)+1:l=Math.floor((o+s-1)/7),l){let c=e.getFullYear();return l===53&&a<3&&(c++,l=1),[c,l]}const d=Lt.getWeekNumber(new Date(e.getFullYear()-1,11,31))[1];return[e.getFullYear()-1,d]}static formatCount(e,t){return t=B.normalizeUnit(t),e!==1&&(t+="s"),e+" "+t}static getUnitToBaseUnitRatio(e,t,r=!1){return e=B.normalizeUnit(e),t=B.normalizeUnit(t),e===t?1:Bt[e]&&Bt[e][t]&&(r||Bt[e][t]>0)?1/B.as(t,1,e):Bt[t]&&Bt[t][e]&&(r||Bt[t][e]>0)?B.as(e,1,t):-1}static getShortNameOfUnit(e){return e=B.parseTimeUnit(e),B.unitLookup[e].abbrev}static getLocalizedNameOfUnit(e,t=!1){const r=e.charAt(0)===e.charAt(0).toUpperCase();return e=B.normalizeUnit(e),e=B.parseTimeUnit(e),e=B.unitLookup[e][t?"plural":"single"],r&&(e=O.capitalize(e)),e}static normalizeUnit(e){if(!e)return null;const t=e.toLowerCase();return t==="date"||Oa.includes(t)?t:Ew[e]||Ew[t]}static getUnitByName(e){return B.normalizeUnit(e)||B.normalizeUnit(B.parseTimeUnit(e))}static getDurationInUnit(e,t,r,n){return B.diff(e,t,r,n)}static doesUnitsAlign(e,t){return!(e!==t&&t==="week")}static getSmallerUnit(e){return Oa[ui[B.normalizeUnit(e)]-1]||null}static getLargerUnit(e){return Oa[ui[B.normalizeUnit(e)]+1]||null}static round(e,t,r,n){return B.snap("round",e,t,r,n)}static floor(e,t,r,n){return B.snap("floor",e,t,r,n)}static ceil(e,t,r,n){return B.snap("ceil",e,t,r,n)}static snap(e,t,r,n,s=B.weekStartDay){const a=oA[e];if(typeof r=="string"&&(r=B.parseDuration(r)),X.isObject(r)){const l=r.magnitude||r.increment;switch(r.unit){case"week":{if(!n){const d=t.getDay();n=B.add(B.clearTime(t),d>=s?s-d:-(d-s+7),"day")}return B[e](t,`${l*7} days`,n)}case"month":{t=B.asMonths(t);let d;return n?(n=B.asMonths(n),d=n+a(t-n,l)):d=a(t,l),B.monthsToDate(d)}case"quarter":return B[e](t,`${l*3} months`,n);case"year":return B[e](t,`${l*12} months`,n);case"decade":return B[e](t,`${l*10} years`,n)}r=B.as("ms",l,r.unit)}const o=t.getTimezoneOffset()*1e3*60;if(n){const l=n.getTimezoneOffset()*1e3*60,d=t-n+l-o,c=new Date(n.getTime()+a(d,r)),u=l-c.getTimezoneOffset()*1e3*60;return u&&B.add(c,-u,"ms",!1),new Date(c)}else return new Date(a(t.valueOf()-o,r)+o)}static parseDuration(e,t=!0,r){var n;const s=t?tA:iA,a=s.exec(e);if(e==null||!a)return null;const o=sA((n=a[1])==null?void 0:n.replace(",",".")),l=B.parseTimeUnit(a[2])||r;return l?{magnitude:o,unit:l}:null}static parseTimeUnit(e){const t=e==null?null:B.durationRegEx.exec(e.toLowerCase());if(!t)return null;for(let r=0;r<Oa.length;r++)if(t[r+1])return Oa[r]}static getGMTOffset(e=new Date){if(!e)return;const t=e.getTimezoneOffset();return t?(t>0?"-":"+")+Math.abs(Math.trunc(t/60)).toString().padStart(2,"0")+":"+Math.abs(t%60).toString().padStart(2,"0"):"Z"}static fillDayNames(){const e=new Date("2000-01-01T12:00:00"),t=B._dayNames||[],r=B._dayShortNames||[];t.length=0,r.length=0;for(let n=2;n<9;n++)e.setDate(n),t.push(B.format(e,"dddd")),r.push(B.format(e,"ddd"));B._dayNames=t,B._dayShortNames=r}static getDayNames(){return B._dayNames}static getDayName(e){return B._dayNames[e]}static getDayShortNames(){return B._dayShortNames}static getDayShortName(e){return B._dayShortNames[e]}static fillMonthNames(){const e=new Date("2000-01-15T12:00:00"),t=B._monthNames||[],r=B._monthShortNames||[],n={},s={};t.length=0,r.length=0;for(let a=0;a<12;a++){e.setMonth(a);const o=B.format(e,"MMMM");t.push(o);const l=B.format(e,"MMM");r.push(l),n[o.toLowerCase()]={name:o,value:a},s[l.toLowerCase()]={name:l,value:a}}B._monthNames=t,B._monthShortNames=r,B._monthNamesIndex=n,B._monthShortNamesIndex=s}static getMonthShortNames(){return B._monthShortNames}static getMonthShortName(e){return B._monthShortNames[e]}static getMonthNames(){return B._monthNames}static getMonthName(e){return B._monthNames[e]}static set locale(e){rn=e,nn={},Mf={},zd={}}static get locale(){return rn}static setupDurationRegEx(e=[],t=[]){const r=this,n={};let s="";for(let a=0;a<t.length;a++){const o=t[a],l=e[a];l.canonicalUnitName=Oa[a],n[l.single]=n[l.single.toUpperCase()]=n[l.canonicalUnitName]=n[l.canonicalUnitName.toUpperCase()]=l,s+=`${a?"|":""}(`;for(let d=0;d<o.length;d++)s+=`${o[d].toLowerCase()}|`;if(rn=r.localize("L{locale}")||"en-US",rn!=="en-US"){const d=rA[a];for(let c=0;c<d.length;c++)s+=`${d[c]}|`}s+=`${l.single.toLowerCase()}|${l.plural.toLowerCase()}|${l.canonicalUnitName}|${l.canonicalUnitName}s)`}r.unitLookup=n,r.durationRegEx=new RegExp(`^(?:${s})$`)}static applyLocale(){const e=this,t=e.localize("L{unitAbbreviations}")||[],r=e.unitNames=e.localize("L{unitNames}");r!=="unitNames"&&(rn=e.localize("L{locale}")||"en-US",rn==="en-US"?wr=mw:wr=e.localize("L{ordinalSuffix}")||wr,Mf={},zd={},av={},nn={},B._weekStartDay=null,B.setupDurationRegEx(r,t),B.fillDayNames(),B.fillMonthNames())}};v(cv,"MS_PER_DAY",nv*24),v(cv,"$name","DateHelper");var w=cv;Pe.register(w);var B=w;B.useIntlFormat=Ct,$e.ion({locale:"applyLocale",prio:1e3,thisObj:B}),$e.locale&&B.applyLocale();var lA=class LI extends Set{get isDateSet(){return!0}add(e){return e=w.makeKey(e),this.has(e)||(this.generation=(this.generation||0)+1),super.add(e)}delete(e){return e=w.makeKey(e),this.has(e)&&this.generation++,super.delete(e)}has(e){return super.has(w.makeKey(e))}clear(){return this.size&&this.generation++,super.clear()}equals(e){return Array.isArray(e)&&(e=new LI(e)),e.size===this.size&&[...this].every(t=>e.has(t))}get dates(){return[...this].sort().map(e=>w.parseKey(e))}};w.DateSet=lA,w._$name="DateHelper";var{defineProperty:uv}=Reflect,If;K.isBrowserEnv?If=globalThis.performance:If={now(){return new Date().getTime()}};var Ce=null;if(de.isTestEnv){const i=globalThis.bryntum||(globalThis.bryntum={});Ce=i.globalDelays={timeouts:new Map,intervals:new Map,animationFrames:new Map,idleCallbacks:new Map,isEmpty(e=!1){return Ce.timeouts.size+Ce.animationFrames.size+Ce.idleCallbacks.size+(e?Ce.intervals.size:0)===0},getFiltered({ignoreTimeouts:e=[],maxDelay:t=5e3,includeIntervals:r=!1}){const n=[],s=["timeouts","animationFrames","idleCallbacks"];r&&s.push("intervals");for(const a of s){const o=Ce[a];for(const[,l]of o.entries())!e.includes(l.name)&&(!Number.isInteger(l.delay)||l.delay<t)&&n.push(l)}return n}}}var dA=Promise.resolve(),Tw=Object.freeze([]),cA=()=>{},uA=Object.freeze({}),Mw=globalThis.queueMicrotask,$a=(i,e,t,r)=>{const n=typeof e=="string",s=(r==null?void 0:r.appendArgs)||Tw,a=()=>{t.timerId=null,t.lastCallTime=If.now();const o=t.args;t.args=null,n?i[e](...o,...s):e.call(i,...o,...s),t.called=!0,++t.calls};return i=(r==null?void 0:r.thisObj)||i,t.lastCallTime=-9e9,t.calls=0,t.suspended=r==null?void 0:r.suspended,t.invoker=a,a.wrapFn=t,a},Nd=(i,e,t="clearTimeout")=>(e.cancel=()=>{e.isPending&&(i[t](e.timerId),e.args=e.timerId=null)},e.flush=()=>{e.isPending&&(i[t](e.timerId),e.timerId=null,e.invoker())},e.now=(...r)=>{e.cancel(),e.args=r,e.invoker()},e.resume=r=>{const n=e.suspended;e.suspended=r||n<1?0:n-1},e.suspend=()=>{++e.suspended},e.immediate=!1,e.suspended=e.suspended?1:0,e.timerId=null,uv(e,"isPending",{get(){return e.timerId!==null}}),e),ve=i=>{var e;return e=class extends(i||$){static get declarable(){return["delayable"]}doDestroy(){super.doDestroy(),this.clearDelayables()}clearDelayables(){const t=this,[r,n,s,a,o,l]=[t.idleCallbackIds,t.animationFrameIds,t.intervalIds,t.timeoutMap,t.timeoutIds,t.microtasksPending];t.idleCallbackIds=t.animationFrameIds=t.intervalIds=t.timeoutMap=t.timeoutIds=t.microtasksPending=null,o==null||o.forEach((d,c)=>{typeof d=="function"&&d(),clearTimeout(c),Ce==null||Ce.timeouts.delete(c)}),a==null||a.forEach((d,c)=>clearTimeout(c)),s==null||s.forEach(d=>{clearInterval(d),Ce==null||Ce.intervals.delete(d)}),n==null||n.forEach(d=>{cancelAnimationFrame(d),Ce==null||Ce.animationFrames.delete(d)}),r==null||r.forEach(d=>{cancelIdleCallback(d),Ce==null||Ce.idleCallbacks.delete(d)}),l==null||l.forEach(d=>d.cancel())}hasTimeout(t){var r;return!!((r=this.timeoutMap)!=null&&r.has(t))}asap(t,r){const n=this,s=(...o)=>{s.suspended||(s.called=!1,s.args=o,s.immediate?a():s.isPending||(s.timerId=n.queueMicrotask(a)))},a=$a(n,t,s,r);return Nd(n,s,"cancelMicrotask")}queueMicrotask(t,r,n){let s,a;!n&&r&&!Array.isArray(r)&&(n=r,r=null),n=n||uA,r=r||n.args||Tw;const o=this,l=typeof t=="string",d=l?t:t.name,c=o.microtasksPending||(o.microtasksPending=new Map),u=()=>c.delete(s),h=()=>{a===c.get(s)&&(c.delete(s),l?!o.isDestroyed&&o[t](...r):t.apply(o,r))};return o.isDestroying&&!n.runOnDestroy?cA:(s=n.cancelOutstanding?d||t:u,a={key:s,name:d,fn:t,args:r,options:n,cancel:u,wrapFn:h},u.taskDef=a,Mw?Mw(h):dA.then(h),c.set(s,a),u)}cancelMicrotask(t){t==null||t()}setTimeout({fn:t,delay:r,name:n,runOnDestroy:s,cancelOutstanding:a,args:o}){(arguments.length>1||typeof arguments[0]=="function")&&([t,r,n,s,a]=arguments),typeof t=="string"?n=t:n||(n=t.name||t),a&&this.clearTimeout(n);const l=this,d=l.timeoutIds||(l.timeoutIds=new Map),c=l.timeoutMap||(l.timeoutMap=new Map),u=setTimeout(()=>{typeof t=="string"&&(t=l[n]),d==null||d.delete(u),c==null||c.delete(n),Ce==null||Ce.timeouts.delete(u),t.apply(l,o)},r);return d.set(u,s?t:!0),Ce==null||Ce.timeouts.set(u,{fn:t,delay:r,name:n}),n&&c.set(n,u),u}clearTimeout(t){var r;let n=t;if(typeof n=="string")if(this.timeoutMap)n=this.timeoutMap.get(t),this.timeoutMap.delete(t);else return;clearTimeout(n),(r=this.timeoutIds)==null||r.delete(n),Ce==null||Ce.timeouts.delete(n)}clearInterval(t){var r;clearInterval(t),(r=this.intervalIds)==null||r.delete(t),Ce==null||Ce.intervals.delete(t)}setInterval(t,r,n){const s=setInterval(t,r);return(this.intervalIds||(this.intervalIds=new Set)).add(s),Ce==null||Ce.intervals.set(s,{fn:t,delay:r,name:n}),s}requestAnimationFrame(t,r=[],n=this){const s=this.animationFrameIds||(this.animationFrameIds=new Set),a=requestAnimationFrame(()=>{Ce==null||Ce.animationFrames.delete(a),s.delete(a)&&t.apply(n,r)});return s.add(a),Ce==null||Ce.animationFrames.set(a,{fn:t,extraArgs:r,thisObj:n}),a}requestIdleCallback(t,r=[],n=this){const s=this.idleCallbackIds||(this.idleCallbackIds=new Set),a=requestIdleCallback(()=>{Ce==null||Ce.idleCallbacks.delete(a),s.delete(a)&&t.apply(n,r)});return s.add(a),Ce==null||Ce.idleCallbacks.set(a,{fn:t,extraArgs:r,thisObj:n}),a}createOnFrame(t,r=[],n=this,s){let a;const o=(...l)=>{a!=null&&s&&(this.cancelAnimationFrame(a),a=null),a==null&&(a=this.requestAnimationFrame(()=>{typeof t=="string"&&(t=n[t]),a=null,l.push(...r),t.apply(n,l)}))};return o.cancel=()=>this.cancelAnimationFrame(a),o}cancelAnimationFrame(t){var r;cancelAnimationFrame(t),(r=this.animationFrameIds)==null||r.delete(t),Ce==null||Ce.animationFrames.delete(t)}cancelIdleCallback(t){var r;cancelIdleCallback(t),(r=this.idleCallbackIds)==null||r.delete(t),Ce==null||Ce.idleCallbacks.delete(t)}async nextAnimationFrame(){return new Promise(t=>this.requestAnimationFrame(t))}buffer(t,r){let n=r;r&&typeof r!="number"?n=r.delay:r=null;const s=(...o)=>{if(s.suspended)return;const{delay:l}=s;s.cancel(),s.called=!1,s.args=o,s.immediate||!l?a():s.timerId=this.setTimeout(a,l)},a=$a(this,t,s,r);return s.delay=n,Nd(this,s)}raf(t,r){let n=r;r&&typeof r!="boolean"?n=r.cancelOutstanding:r=null;const s=(...o)=>{s.suspended||((s.cancelOutstanding||s.immediate)&&s.cancel(),s.called=!1,s.args=o,s.immediate?a():s.isPending||(s.timerId=this.requestAnimationFrame(a)))},a=$a(this,t,s,r);return s.cancelOutstanding=n,s.raf=!0,Nd(this,s,"cancelAnimationFrame")}idle(t,r){let n=r;r&&typeof r!="boolean"?n=r.cancelOutstanding:r=null;const s=(...o)=>{s.suspended||((s.cancelOutstanding||s.immediate)&&s.cancel(),s.called=!1,s.args=o,s.immediate?a():s.isPending||(s.timerId=this.requestIdleCallback(a)))},a=$a(this,t,s,r);return s.cancelOutstanding=n,this.setTimeout(()=>this.idleCallbackIds.delete(s.timerId)&&s.now(),100),Nd(this,s,"cancelIdleCallback")}throttle(t,r){let n=r,s;r&&typeof r!="number"?(n=r.delay,s=r.throttled):r=null;const a=this,o=(...d)=>{if(o.suspended)return;const{delay:c}=o,u=If.now()-o.lastCallTime;o.args=d,o.immediate||u>=c?(a.clearTimeout(o.timerId),l()):(o.isPending||(o.timerId=a.setTimeout(l,c-u),o.called=!1),s&&(s.wrapFn.args=d,s()))},l=$a(a,t,o,r);return o.delay=n,s&&(s=$a(a,s,()=>{},r)),Nd(a,o)}static setupDelayable(t){t.setupDelayableMethods(t.delayable)}static setupDelayableMethods(t,r=null){const n=this,s=t.static,a=r||n.prototype;s&&delete t.static;for(const o in t){let l=t[o];const d=o+"Now",c=typeof l;a[d]||(a[d]=a[o]),c==="number"?l={type:"buffer",delay:l}:c==="string"&&(l={type:l}),uv(a,o,{get(){const u=this,h=u[l.type]((...f)=>u[d](...f),l);return uv(u,o,{value:h}),h}})}}get widgetClass(){}},v(e,"$name","Delayable"),e},Ba=class{get data(){return Object.create(null)}get keys(){return[]}clear(){}getItem(i){return null}removeItem(i){}setItem(i,e){}};Ba._$name="StateStorage";var hA=class extends Ba{constructor(i){super(),this.prefix=i.prefix||""}get isLocal(){return!0}get data(){const i=Iw(),e=this.keys;for(const t of e)i[t]=this.getItem(t);return i}get keys(){return _w(this.prefix,this.prefix.length)}clear(){const i=_w(this.prefix);for(const e of i)localStorage.removeItem(e)}getItem(i){const e=localStorage.getItem(this.prefix+i);return e===null?e:JSON.parse(e)}removeItem(i){return localStorage.removeItem(this.prefix+i)}setItem(i,e){return localStorage.setItem(this.prefix+i,JSON.stringify(e))}},fA=class extends Ba{constructor(){super(),this.clear()}get isMemory(){return!0}get data(){return T.clone(this._data)}get keys(){return Object.keys(this._data)}clear(){this._data=Iw()}getItem(i){return i in this._data?this._data[i]:null}removeItem(i){delete this._data[i]}setItem(i,e){this._data[i]=e}},Iw=()=>Object.create(null),_w=(i,e=0)=>{const t=[],r=localStorage.length;for(let n,s=0;s<r;++s)n=localStorage.key(s),n.startsWith(i)&&t.push(n.slice(e));return t},Pw=new Ba,hv={local:hA,memory:fA},Aw=class OI extends $.mixin(ve,Ve){static get configurable(){return{prefix:"bryntum-state:",storage:"local"}}static get delayable(){return{writeStatefuls:50}}static get instance(){return this._instance}static set instance(e){e==null?e=Fw:((typeof e=="string"||T.isClass(e)||e instanceof Ba)&&(e={storage:e}),T.isObject(e)&&(e=new OI(e))),this._instance=e}static setup(e){return this.instance=e,this.instance}doDestroy(){self.writeStatefuls.flush(),super.doDestroy()}get data(){return this.storage.data}set data(e){if(!e)this.clear();else for(const t in e)this.setValue(t,e[t])}clear(){return this.storage.clear(),this}changeStorage(e){if(e==null)e=Pw;else{if(typeof e=="string"){if(!hv[e])throw new Error(`Invalid storage type "${e}" (expected one of: "${Object.keys(hv).join('", "')}")`);e=hv[e]}T.isClass(e)&&(e=new e(this))}return e}saveStateful(e,t){(this.pendingSaves||(this.pendingSaves=[])).push([e,t]),this.writeStatefuls()}writeStatefuls(){const e=this,{pendingSaves:t}=e,r=t==null?void 0:t.length,n=[],s=[];if(e.pendingSaves=null,r){for(let a,o,l,d=0;d<r;++d)[o,a]=t[d],!o.isDestroying&&o.isSaveStatePending&&(l=o.saveState({...a,immediate:!0}),l&&(n.push(l),s.push(o)));n.length&&e.trigger("save",{stateIds:n,saved:s})}}getValue(e){return this.writeStatefuls.flush(),this.storage.getItem(e)}setValue(e,t){const r=this,{storage:n}=r,s=r.getValue(e);return t!=null?(n.setItem(e,t),r.trigger("set",{key:e,value:t,was:s})):s!==null&&(n.removeItem(e),r.trigger("remove",{key:e,was:s})),r}};v(Aw,"$name","StateProvider");var Wd=Aw,Fw=new Wd({storage:Pw});Wd._instance=Fw,Wd._$name="StateProvider";var gA=/boolean|number|string/,_f=i=>{var e;return e=class extends(i||$){afterConstruct(){super.afterConstruct(),this.stateProvider&&this.loadState()}finalizeInit(){this.stateProvider&&this.loadState(),super.finalizeInit()}get isStateful(){return!0}get isStatefulActive(){return!this.statefulSuspended&&!this.isResponsivePending&&!this.isResponsiveUpdating}get state(){return this._state=this.getState()}set state(t){this._state=t,t&&this.applyState(t)}updateStatefulEvents(t){var r;const n=this,s={name:"statefulEvents",thisObj:n};if(n.detachListeners(s.name),t&&(typeof t=="string"?t=O.split(t):Array.isArray(t)||(t=T.getTruthyKeys(t)),t.length)){for(const a of t)s[a]="onStatefulEvent";(r=n.ion)==null||r.call(n,s)}}get statefulId(){const t=this,{responsiveState:r}=t;let n=t.stateId;return n==null&&t.hasGeneratedId===!1&&t.stateful!==!1&&(n=t.id),n&&r&&(n=`${n}[${r}]`),n}get statefulness(){const{stateful:t}=this;return Array.isArray(t)?T.createTruthyKeys(t):t}get stateProvider(){var t;return(t=this._stateProvider)!=null?t:this._stateId&&Wd.instance}applyState(t){t=this.pruneState(t),t&&this.setConfig(t)}getState(){const t=this,{initialConfig:r,statefulness:n,isConstructing:s}=t,{configs:a}=t.$meta,o=s?Object.setPrototypeOf(r,t.$meta.config):t;let l=null,d,c;if(n){l={};for(d in n)if(n[d]){if(c=o[d],c!=null&&c.isStateful)c=c.state;else if(!s&&(T.isDate(c)&&(c=w.format(c,"YYYY-MM-DDTHH:mm:ssZ")),a[d].equal(c,r==null?void 0:r[d])||!gA.test(typeof c)))continue;l[d]=c}}return l}loadState(t,r){typeof t=="boolean"&&(r=t,t=null);const n=this,{statefulLoaded:s}=n;if(n.isStatefulActive&&(r||!s)){const a=n.loadStatefulData(t||(t=n.statefulId));!s&&t&&(n.defaultState=n.state,n.statefulLoaded=!0),a&&(n.state=a)}}loadStatefulData(t){var r;return t=this.isStatefulActive?t||this.statefulId:null,t&&((r=this.stateProvider)==null?void 0:r.getValue(t))}resetDefaultState(){this.defaultState&&(this.state=this.defaultState)}resumeStateful(t=!1){this.statefulSuspended=t?0:Math.max(this.statefulSuspended-1,0)}saveState(t){typeof t=="string"?t={id:t}:t=t||{};const r=this,{stateProvider:n}=r,s=t.id||r.isStatefulActive&&r.statefulId;if(s&&n)return t.immediate?(r.isSaveStatePending=!1,n.setValue(s,r.state)):r.isSaveStatePending||(r.isSaveStatePending=!0,n.saveStateful(r,t)),s}suspendStateful(){++this.statefulSuspended}onConfigChange({name:t,value:r,was:n,config:s}){if(super.onConfigChange({name:t,value:r,was:n,config:s}),!this.isConstructing&&this.isStatefulActive&&this.statefulId){const{stateful:a}=this;(Array.isArray(a)?a.includes(t):a!=null&&a[t])&&this.saveState()}}onStatefulEvent(){this.isConstructing||this.saveState()}pruneState(t){const{statefulness:r}=this;if(r){const n={};for(const s in t)r[s]&&(n[s]=t[s]);t=n}return t}get widgetClass(){}},v(e,"$name","State"),v(e,"configurable",{stateful:{value:null,$config:{merge:"classList"}},statefulEvents:{$config:{merge:"classList"},value:["stateChange"]},stateId:null,stateProvider:null}),v(e,"prototypeProperties",{statefulLoaded:!1,statefulSuspended:0}),e},kw=T.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null)),mA={string:1,number:1},Ud=i=>{var e;return e=class extends(i||$){static get declarable(){return["identifiable"]}static get configurable(){return{id:""}}static setupIdentifiable(t,r){const{identifiable:n}=t;n.idMap=Object.create(null),Reflect.defineProperty(t,"identifiable",{get(){return n}})}doDestroy(){this.constructor.unregisterInstance(this),super.doDestroy()}changeId(t){return(this.hasGeneratedId=!t)?this.generateAutoId():t}updateId(t,r){const n=this,s=n.constructor;r&&s.unregisterInstance(n,r),(!n.hasGeneratedId||s.identifiable.registerGeneratedId!==!1)&&s.registerInstance(n,t)}generateAutoId(){return this.constructor.generateId(`b-${this.$$name.toLowerCase()}-`)}static get all(){return Object.values(this.identifiable.idMap)}static generateId(t="generatedId"){return t+(kw[t]=(kw[t]||0)+1)}static registerInstance(t,r=t.id){const{idMap:n}=this.identifiable;if(r in n&&!this.disableThrow)throw new Error("Id "+r+" already in use");n[r]=t}static unregisterInstance(t,r=t.id){const{idMap:n}=this.identifiable;mA[typeof t]?delete n[t]:n[r]===t&&delete n[r]}static getById(t){const r=this.identifiable.idMap;if(r)return r[t]}static get registeredInstances(){const t=this.identifiable.idMap;return t?Object.values(t):[]}},v(e,"$name","Identifiable"),e},Lw=Symbol("STM_PROP"),Ow={parentIndex:1,orderedParentIndex:1},$w=i=>{var e;return e=class extends(i||$){static get defaultConfig(){return{stm:null}}joinStore(t){this.stm||(this.stm=t.stm)}unjoinStore(t,r=!1){var n;this.stm===t.stm&&(this.stm=null),(n=super.unjoinStore)==null||n.call(this,t,r)}get stm(){return this[Lw]}set stm(t){this[Lw]=t}beforeChronoFieldSet(t,r){var n;const s=this;return!s.inSetting&&((n=s.stm)!=null&&n.enabled)&&!Ow[t]&&!s.constructor.nonPersistableFields[t]&&s.getFieldDefinition(t)?{[t]:{value:r,oldValue:s.graph.activeTransaction.readCurrentOrProposedOrPrevious(s.$[t])}}:null}afterChronoFieldSet(t,r,n){n&&this.afterSet(t,r,!1,!1,n,!0)}shouldRecordFieldChange(t,r,n){const s=this.firstStore;return!(this.constructor.nonPersistableFields[t]||r==null&&n==null||r===n||r instanceof Date&&n instanceof Date&&r.getTime()===n.getTime()||t==="id"||t==="$PhantomId"||t==="parentId"&&s&&s.oldIdMap[r]===s.getById(n))}afterSet(t,r,n,s,a,o){const{stm:l}=this,d=this.constructor.nonPersistableFields;if(l!=null&&l.isBase&&l.shouldRecordAction&&!Ow[t]&&!d[t]&&a){let c;const[u,h]=Object.keys(a).reduce((f,g)=>{const{value:m,oldValue:p}=a[g];return this.shouldRecordFieldChange(g,p,m)&&(c=!0,f[0][g]=m,f[1][g]=p),f},[{},{}]);c&&l.onModelUpdate(this,u,h,o)}}beforeInsertChild(t){var r;const n=((r=super.beforeInsertChild)==null?void 0:r.call(this,t))||[],{stm:s}=this;return s!=null&&s.enabled&&n.push(t.reduce((a,o)=>(o.root===this.root&&a.set(o,{parent:o.parent,index:o.parent?o.parentIndex:void 0}),a),new Map)),n}afterInsertChild(t,r,n,s,a){var o;const{stm:l}=this;if(l!=null&&l.shouldRecordAction){const d=n.pop();s&&l.onModelInsertChild(this,t,s,d,a)}(o=super.afterInsertChild)==null||o.call(this,t,r,n,s)}beforeRemoveChild(t,r){const n=super.beforeRemoveChild?super.beforeRemoveChild(t,r):[],{stm:s}=this;return s!=null&&s.shouldRecordAction&&!r&&n.push(t.reduce((a,o)=>(a.set(o,{parentIndex:o.parentIndex,orderedParentIndex:o.orderedParentIndex}),a),new Map)),n}afterRemoveChild(t,r,n){var s;const{stm:a}=this;if(a!=null&&a.shouldRecordAction&&!n){const o=r.pop();t&&t.length&&a.onModelRemoveChild(this,t,o)}(s=super.afterRemoveChild)==null||s.call(this,t,r,n)}},v(e,"$name","ModelStm"),e},pA={includeFilteredOutRecords:!1},fv=i=>(i=i||!1,typeof i=="boolean"&&(i={includeFilteredOutRecords:i}),i||pA),Bw=i=>{var e;return e=class extends(i||$){static set convertEmptyParentToLeaf(t){t===!0?t={onLoad:!0,onRemove:!0}:t===!1&&(t={onLoad:!1,onRemove:!1}),this._convertEmptyParentToLeaf=t}constructor(...t){super(...t),this.children&&(this.orderedChildren=this.orderedChildren||[])}static get convertEmptyParentToLeaf(){return this._convertEmptyParentToLeaf||{onLoad:!1,onRemove:!1}}ingestChildren(t,r=this.stores){var n,s,a;const{inProcessChildren:o,constructor:l}=this,d=r==null?void 0:r[0];if(t===!0)return o?!0:[];if(t){let c=H.asArray(t);if(!c.length)return[];const u=c.length,h=[];c=(n=d==null?void 0:d.cloneImmutable(c))!=null?n:c;for(let f=0,g;f<u;f++)g=c[f],g=g.isModel?g:(s=d==null?void 0:d.createRecord(g,!1,!0))!=null?s:new l(g,null,null,!0),g=(a=d==null?void 0:d.processRecord(g))!=null?a:g,h.push(g);if(this.children===!0&&d){const f=d.createSorterFn(d.sorters);h.sort(f)}return h}}processChildren(t=this.stores){const r=this,{meta:n}=r;r.inProcessChildren=!0;const s=r.ingestChildren(r.data[r.constructor.childrenField],t);if(s){const{convertEmptyParentToLeaf:a}=r.constructor;if(a===!0||a.onLoad?s.length:Array.isArray(s)){if(n.isLeaf=!1,r.children===!0)r.children=[];else if(s.length===0){r.children=s;return}r.insertChild(s)}else s===!0?(n.isLeaf=!1,r.children=!0):r.remoteChildCount>0?n.isLeaf=!1:r.isRoot||(n.isLeaf=r.constructor.convertEmptyParentToLeaf.onLoad)}r.inProcessChildren=!1}ancestorsExpanded(t=this.firstStore){const{parent:r}=this;return!r||r.isExpanded(t)&&r.ancestorsExpanded(t)}isExpanded(t=this.firstStore){const r=this.instanceMeta(t.id);return Object.prototype.hasOwnProperty.call(r,"collapsed")||(r.collapsed=!this.expanded),!r.collapsed}get expanded(){return this.data.expanded}get childLevel(){let t=this,r=-1;for(;t&&!t.isRoot;)++r,t=t.parent;return r}get isLeaf(){return this.meta.isLeaf!==!1&&!this.isRoot}get isParent(){return!this.isLeaf}get isLoaded(){return this.isParent&&Array.isArray(this.children)}get hierarchyModificationDataToWrite(){const{parentIdField:t}=this.constructor,r=[t,"parentIndex","orderedParentIndex"].reduce((n,s)=>{var a;if(s in this.meta.modified){const o=this.constructor.getFieldDefinition(s);s===t?n[(a=o==null?void 0:o.dataSource)!=null?a:t]=this.getFieldPersistentValue(s):o.persist&&(n[o.dataSource]=this.getFieldPersistentValue(s))}return n},{});return Object.keys(r).length>0?r:null}get descendantCount(){return this.getDescendantCount()}get visibleDescendantCount(){return this.getDescendantCount(!0)}getDescendantCount(t=!1,r=this.firstStore,n=!1){let{children:s}=this;return n&&this.unfilteredChildren&&(s=this.unfilteredChildren),!s||!Array.isArray(s)||t&&!this.isExpanded(r)?0:s.reduce((a,o)=>a+o.getDescendantCount(t,r,n),s.length)}get allChildren(){return this.getAllChildren(!1)}get allUnfilteredChildren(){return this.getAllChildren(!0)}getAllChildren(t=!1){const{[t?"unfilteredChildren":"children"]:r}=this;return!r||r===!0?[]:r.reduce((n,s)=>(n.push(s),n.push.apply(n,t?s.allUnfilteredChildren:s.allChildren),n),[])}get firstChild(){const{children:t}=this;return(t==null?void 0:t.length)&&t[0]||null}get lastChild(){const{children:t}=this;return(t==null?void 0:t.length)&&t[t.length-1]||null}get previousSiblingsTotalCount(){let t=this.previousSibling,r=this.parentIndex;for(;t;)r+=t.descendantCount,t=t.previousSibling;return r}get previousOrderedSibling(){var t,r;return(r=(t=this.parent)==null?void 0:t.orderedChildren[this.orderedParentIndex-1])!=null?r:null}get nextOrderedSibling(){var t,r;return(r=(t=this.parent)==null?void 0:t.orderedChildren[this.orderedParentIndex+1])!=null?r:null}get root(){var t;return((t=this.parent)==null?void 0:t.root)||this}get parentId(){return this.parent&&!this.parent.isAutoRoot?this.parent.id:null}set parentId(t){this.setParentId(t)}setParentId(t){var r,n;const s=this,{parent:a}=s,o=t===null?(r=s.firstStore)==null?void 0:r.rootNode:(n=s.firstStore)==null?void 0:n.getById(t);o===a||!a&&!o||(s.isBatchUpdating?s.meta.batchChanges.parentId=t:o?o.appendChild(s):s.parent.removeChild(s))}static set parentIdField(t){this._parentIdField=t,Object.defineProperty(this.prototype,t,{set:function(r){this.parentId=r},get:function(){return this.parentId}})}static get parentIdField(){return this._parentIdField||"parentId"}getChildren(t){let r;return t.includeFilteredOutRecords?r=this.unfilteredChildren||this.children:t.useOrderedTree?r=this.orderedChildren:r=this.children,r}traverse(t,r,n){n=fv(n);const s=this,a=s.getChildren(n);r||t.call(s,s);for(let o=0,l=a==null?void 0:a.length;o<l;o++)a[o].traverse(t,!1,n)}traverseBefore(t,r,n){n=fv(n);const s=this,a=s.getChildren(n);for(let o=0,l=a==null?void 0:a.length;o<l;o++)a[o].traverse(t,!1,n);r||t.call(s,s)}traverseWhile(t,r,n){n=fv(n);const s=this;let a=r||t.call(s,s)!==!1;if(a){const o=s.getChildren(n);o!=null&&o.length&&(a=o.every(l=>l.traverseWhile(t,!1,n)))}return a}bubble(t,r=!1){let n=this;for(r||t.call(n,n);n.parent;)n=n.parent,t.call(n,n)}bubbleWhile(t,r=!1){let n=this,s=!0;for(r||(s=t.call(n,n));s&&n.parent;)n=n.parent,s=t.call(n,n);return s}contains(t,r=!1,n=void 0){return t&&typeof t=="object"&&(t=t.id),!this.traverseWhile(s=>s.id!=t,r,n)}getTopParent(t){let r;return t?(r=[],this.bubbleWhile(n=>(r.push(n),n.parent&&!n.parent.isRoot))):(r=null,this.bubbleWhile(n=>(r=n,n.parent&&!n.parent.isRoot))),r}appendChild(t,r=!1,n={}){return this.insertChild(t,null,r,n)}insertChild(t,r=null,n=!1,s={}){var a,o,l,d,c,u,h,f;const g=this,m=Array.isArray(t);if(t=H.asArray(t),typeof r=="number"&&(r=(o=(a=g.children)==null?void 0:a[r])!=null?o:null),!n&&((l=g.stores)==null?void 0:l.every(C=>C.trigger("beforeAdd",{records:t,parent:g})!==!1))===!1)return null;t=g.ingestChildren(t);const p=(u=(c=r==null?void 0:r.parentIndex)!=null?c:(d=g.children)==null?void 0:d.length)!=null?u:0,y=(h=g.beforeInsertChild)==null?void 0:h.call(g,t),b=g.internalAppendInsert(t,r,n,s);return b.length&&g.convertToParent(n),(f=g.afterInsertChild)==null||f.call(g,p,t,y,b,s.orderedBeforeNode),m||!b?b:b[0]}convertToParent(t=!1){const r=this,n=r.isLeaf;r.meta.isLeaf=!1,r.children||(r.children=[]),n&&!r.root.isLoading&&!t&&r.signalNodeChanged({isLeaf:{value:!1,oldValue:!0}})}signalNodeChanged(t,r=this.stores){r==null||r.forEach(n=>{n.trigger("update",{record:this,records:[this],changes:t}),n.trigger("change",{action:"update",record:this,records:[this],changes:t})})}tryInsertChild(){return this.insertChild(...arguments)}internalAppendInsert(t,r,n,s){const a=this,{stores:o,root:l,children:d}=a,{firstStore:c}=l,{parentIdField:u}=a.constructor,h=a.id;let f,g,m,p,y,b={};if(!l.isLoading&&c)for(y=[],m=0;m<t.length;m++){const C=t[m];b[C.id]=C.root===l,y[m]=C.parentIndex}if(r&&r.parent!==a&&(r=null),d){const C=r?r.parentIndex:d.length;if(d[g=C]===t[0]||d[g=C-1]===t[0])for(f=!0,m=0;f&&m<t.length;m++)t[m]!==d[g+m]&&(f=!1)}if(f)return t;for(m=0;m<t.length;m++){const C=t[m],D=C.parent;c&&!l.isLoading&&C.traverse(R=>{R.root===l&&(b[R.id]=!0)});const S=!!b[C.id],x=D===a&&S;if((D==null?void 0:D.removeChild(C,S,n,{isInserting:!0,skipIndexUpdate:x,...s}))===!1)p||(t=t.slice(),p=!0),t.splice(m--,1);else{C.parent=a,C.setData("parentId",h);const{meta:R}=C;R.modified[u]===h&&!D&&(R.oldParentId=h),D&&(R.oldParentId=D.id)}}if(t.length){Array.isArray(d)||(a.children=[]),Array.isArray(a.orderedChildren)||(a.orderedChildren=[]);const C=a.addToChildren(r,t,s);o==null||o.forEach(D=>{D.isChained||(t.forEach(S=>S.joinStore(D)),D.onNodeAddChild(a,t,C,b,n),t.forEach((S,x)=>{if(S.meta.oldParentId!=null&&(!(a.inProcessChildren||a.isLoading)||b[S.id])){const R={[u]:h,[a.getDataSource("parentIndex")]:S.parentIndex},M={},{modified:I,oldParentId:_}=S.meta,P=y[x];if(delete S.meta.oldParentId,a.id!==_&&(M[u]={value:h,oldValue:_}),S.parentIndex!==P&&(M.parentIndex={value:S.parentIndex,oldValue:P}),I[u]===a.id?Reflect.deleteProperty(I,u):u in I||(I[u]=_),b[S.id]){const A=D.getById(_);A.isLeaf&&!n&&A.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}},[D])}S.afterChange(R,M)}S.traverse(R=>{!R.ignoreBag&&!R.isLinked&&D.updateModifiedBagForRecord(R)})}))})}return t}removeChild(t,r=!1,n=!1,s={}){var a,o;const l=this,d=[],c=l.isLeaf,{children:u,stores:h}=l;if(t=H.asArray(t),t=t.filter(g=>g.parent===l),!n&&h){for(const g of h)if(!g.isChained&&g.trigger("beforeRemove",{parent:l,records:t,isMove:r})===!1)return!1}const f=(a=l.beforeRemoveChild)==null?void 0:a.call(l,t,r);for(const g of t){const{parentIdField:m}=g.constructor,{modified:p}=g.meta,y=g.parent?g.parent.id:null;!(m in p)&&!g.isLinked&&(p[m]=y);const b=l.removeFromChildren(g,s);h==null||h.forEach(C=>{if(!C.isChained){const{isRemoving:D}=C;C.isRemoving=!0,d.push(...C.onNodeRemoveChild(l,[g],b,{isMove:r,silent:n})),C.isRemoving=D}}),r||(g.parent=g.parentIndex=g.unfilteredIndex=g.nextSibling=g.previousSibling=null,g.data[m]=null)}return(l.unfilteredChildren||u).length===0&&l.constructor.convertEmptyParentToLeaf.onRemove&&!l.isRoot&&(l.meta.isLeaf=!0),l.isLeaf!==c&&!n&&!r&&l.signalNodeChanged({isLeaf:{value:!0,oldValue:!1}}),(o=l.afterRemoveChild)==null||o.call(l,t,f,r),d}clearParentId(){const t=this;Reflect.deleteProperty(t.data,t.parentIdField),Reflect.deleteProperty(t.originalData,t.parentIdField),t.meta.modified&&Reflect.deleteProperty(t.meta.modified,t.parentIdField)}replaceChildren(t){return this.clearChildren(),this.data[this.constructor.childrenField]=t,this.processChildren(),this.children}clearChildren(t=!1){const r=this,{stores:n}=r,s=r.unfilteredChildren||r.children;r.children=[],r.orderedChildren=[],s&&s!==!0&&(n.forEach(o=>{o.isChained||o.onNodeRemoveChild(r,s,0,{unfiltered:!0,silent:t})}),r.unfilteredChildren&&(r.unfilteredChildren=[]));const{convertEmptyParentToLeaf:a}=r.constructor;(a===!0||a.onRemove)&&(r.meta.isLeaf=!0)}clear(){var t;const r=this,{stores:n}=r,s=(t=r.unfilteredChildren||r.children)==null?void 0:t.slice();if(!(!r.isRoot||!s)){for(const a of n)if(!a.isChained&&a.trigger("beforeRemove",{parent:r,records:s,isMove:!1,removingAll:!0})===!1)return!1;r.children.length=r.orderedChildren.length=0,r.unfilteredChildren&&(r.unfilteredChildren.length=0),n.forEach(a=>{s.forEach(o=>{o.stores.includes(a)&&o.unjoinStore(a),o.parent=o.parentIndex=o.nextSibling=o.previousSibling=null}),a.storage.suspendEvents(),a.storage.clear(),a.storage.resumeEvents(),a.added.clear(),a.modified.clear(),a.trigger("removeAll"),a.trigger("change",{action:"removeall"})})}}updateChildrenIndices(t,r,n=!1){let s=null;for(let a=0;a<t.length;a++){const o=t[a],l=o[r];r==="parentIndex"||r==="orderedParentIndex"?l===void 0||n?o.setData(r,a):l!==a&&o.set(r,a,!0):o[r]=a,r==="parentIndex"&&(o.previousSibling=s,s&&(s.nextSibling=o),a===t.length-1&&(o.nextSibling=null),s=o)}}addToChildren(t,r,n={}){var s,a;const o=this,l=[[o.children,"parentIndex",t],[o.unfilteredChildren,"unfilteredIndex",t],[o.orderedChildren,"orderedParentIndex",(n==null?void 0:n.orderedBeforeNode)===void 0?(n==null?void 0:n.orderedParentIndex)!==void 0?o.orderedChildren[(s=n.orderedParentIndex.index)!=null?s:n.orderedParentIndex]:t:n==null?void 0:n.orderedBeforeNode]];for(const d of l){const[c,u,h]=d;if(c){let f;h?(f=c.indexOf(h),f===-1&&(f=c.length)):f=c.length,d.push(f),c.splice(f,0,...r),n!=null&&n.skipIndexUpdate||(a=n==null?void 0:n[u])!=null&&a.skip||o.updateChildrenIndices(c,u)}}return l[0][3]}removeFromChildren(t,r){var n;const s=[[this.children,"parentIndex"],[this.unfilteredChildren,"unfilteredIndex"],[this.orderedChildren,"orderedParentIndex"]];for(const a of s){const[o,l]=a;if(o){const d=o.indexOf(t);a.push(d),d>-1&&(o.splice(d,1),r!=null&&r.skipIndexUpdate||(n=r==null?void 0:r[l])!=null&&n.skip||this.updateChildrenIndices(o,l))}}return s[0][2]}sortOrderedChildren(t=!0,r=!1){const n=[];return this.isLeaf||(this.orderedChildren.sort((s,a)=>{var o,l;if(r){const d=(o=s.meta.modified.orderedParentIndex)!=null?o:s.orderedParentIndex,c=(l=a.meta.modified.orderedParentIndex)!=null?l:a.orderedParentIndex,u=d-c;return u!==0&&(n.push(s),n.push(a)),u}else return s.orderedParentIndex-a.orderedParentIndex}),t&&this.orderedChildren.forEach(s=>{n.push(...s.sortOrderedChildren(t,r))}),this.updateChildrenIndices(this.orderedChildren,"orderedParentIndex",!0)),new Set(n)}sortVisibleChildren(t=!0,r){const n=this;n.isLeaf||(n.children.sort(r),t&&n.orderedChildren.forEach(s=>s.sortVisibleChildren(t,r)),n.updateChildrenIndices(n.children,"parentIndex",!0))}sortUnfilteredChildren(t=!0,r){const n=this;!n.isLeaf&&n.unfilteredChildren&&(n.unfilteredChildren.sort(r),t&&n.orderedChildren.forEach(s=>s.sortUnfilteredChildren(t,r)),n.updateChildrenIndices(n.unfilteredChildren,"unfilteredIndex",!0))}unjoinStore(t,r=!1){var n;const s=this;s.unfilteredChildren&&(s.children=s.unfilteredChildren.slice(),s.unfilteredChildren=null),(n=super.unjoinStore)==null||n.call(this,t,r)}},v(e,"$name","TreeNode"),e},Hw={id:1,stores:1,parentIndex:1,parent:1,parentId:1,previousSibling:1,nextSibling:1,unfilteredIndex:1},vA={get(i,e){switch(e){case"proxyMeta":return this.proxyMeta;case"constructor":return i.constructor;case"setData":return this.setDataOverride;case"set":return this.setOverride;case"instanceMeta":return this.instanceMetaOverride;default:if(Hw[e])return this.proxyMeta.data[e]}return Reflect.get(i,e,this.proxyRecord)},set(i,e,t,r){return e==="parentId"?r.setParentId(t):Hw[e]?this.proxyMeta.data[e]=t:i[e]=t,!0},instanceMetaOverride(i){const{proxyMeta:e}=this,t=i.id||i,r=e.map||(e.map=T.clone(e.originalRecord.instanceMeta(t)));return r[t]||(r[t]={})},setDataOverride(i,e){i==="parentIndex"?this.proxyMeta.data.parentIndex=e:i==="parentId"?this.proxyMeta.data.parentId=e:this.proxyMeta.originalRecord.setData(i,e)},setOverride(i,e,...t){i==="parentIndex"?this.proxyMeta.data.parentIndex=e:this.proxyMeta.originalRecord.set(i,e,...t)}},jw=i=>{var e;return e=class extends(i||$){link(){if(this.isLinked)return this.$original.link();const t=this,r={...vA,proxyMeta:{originalRecord:t,data:{id:`${t.id}_link_${O.generateUUID()}`,stores:[]}}},n=new Proxy(t,r);return r.proxyRecord=n,(t.meta.linkedRecords||(t.meta.linkedRecords=[])).push(n),n}get isLinked(){var t;return!!((t=this.proxyMeta)!=null&&t.originalRecord)}get hasLinks(){return!!(!this.proxyMeta&&this.$links.length)}removeLink(t,r=null,n=!1){if(t.hasLinks)for(const s of t.$links.slice())r?H.include(r,s):s.remove(n);else t.isLinked&&H.remove(t.$original.$links,t)}beforeRemove(t){this.removeLink(this,t)}removeChild(t,r,n,s){if(!(s!=null&&s.isInserting)){t=H.asArray(t);for(const a of t)this.removeLink(a,null,n)}return super.removeChild(t,r,n,s)}get $originalId(){return this.$original.id}get $links(){var t;return(t=this.meta.linkedRecords)!=null?t:[]}},v(e,"$name","ModelLink"),v(e,"isModel",!0),e},{defineProperty:Vw}=Reflect,gv=Symbol("owner"),yA=/[\s,]+/,ds=i=>{var e;return e=class extends(i||$){static get declarable(){return["factoryable","alias","type"]}static register(t,r,n=globalThis.__BRYNTUM_EXAMPLE){const{factoryable:s}=this.initClass(),{caseless:a,registry:o}=s,l=O.split(t,yA);for(let d,c,u=0;u<l.length;++u){if(c=l[u],d=a?c.toLowerCase():c,!n&&d in o)throw new Error(`Type "${c}" already registered with ${s.class.name} factory`);o[c]=o[d]=r.initClass()}}static isA(t,r){return this.isType(t,r,!0)}static isType(t,r,n){const{factoryable:s}=this,{caseless:a,registry:o}=s,l=o[a?r.toLowerCase():r];return l?n?t instanceof l:t.constructor===l:!1}static setupAlias(t){t.register(t.alias,t)}static setupFactoryable(t,r){const n=r.super.class;let{factoryable:s}=t;s={caseless:!0,defaultType:null,extends:n.factoryable?[n]:null,typeKey:"type",...s},s.class=t,s.registry=Object.create(null),s.extends&&!Array.isArray(s.extends)&&(s.extends=[s.extends]),Vw(t,"factoryable",{get(){return s}})}static setupType(t,r){const{type:n}=t;t.register(n,t,r.replaceType),Vw(t.prototype,"type",{get:()=>n,set:s=>{if(s!==n)throw new Error("Can not mutate `type` config to different value")}})}static create(t,r){return this.reconfigure(null,t,r)}static reconfigure(t,r,n){const s=this,{factoryable:a}=s,{typeKey:o}=a;let l=n,d,c,u,h,f,g,m,p,y;if(n&&!T.isClass(n)&&(l=null,m=typeof n,m==="function"?g=n:m==="string"?l=n:T.isObject(n)?(d=n.cleanup,c=n.defaults,h=n.owner,g=n.setup,l=n.type,p=n.transform):h=n),p&&(r=typeof p=="string"?h[p](r):p(r)),y=r,typeof y=="string")r={};else if(r){if(r===!0&&(r={}),!T.isObject(r))return h&&r!==t&&(t==null?void 0:t[gv])===h&&(typeof d=="string"?h[d](t):d==null||d(t),t.destroy()),r;y=r[o]}if(y=y&&s.resolveType(y),t){if(r&&(!y||t.constructor===y))return o in r&&(r=T.assign({},r),delete r[o]),t.setConfig(r),t;h&&t[gv]===h&&(typeof d=="string"?h[d](t):d==null||d(t),t.destroy())}if(r){if(c){if(!(u=y)){if(!(u=c[o]||l||a.defaultType))throw new Error(`No default mergeType defined for ${a.class.name} factory`);u=s.resolveType(u)}u&&(r=u.mergeConfigs(c,r))}if(g){if(f=typeof g=="string"?h[g](r,y,c):g(r,y,c),f===null)return f;r=f||r}if(!y){if(!(y=r[o]||l||a.defaultType))throw new Error(`No default type defined for ${a.class.name} factory`);y=s.resolveType(y)}c&&!u&&(r=y.mergeConfigs(c,r)),o in r&&(r=T.assign({},r),delete r[o]),r=new y(r),h&&(r[gv]=h)}return r||null}static resolveType(t,r){if(typeof t!="string")return t;const{factoryable:n}=this,s=n.extends;let a=n.registry[n.caseless?t.toLowerCase():t],o;for(o=0;!a&&s&&o<s.length;++o)a=s[o].resolveType(t,!0);if(!a&&!r)throw new Error(`Invalid type name "${t}" passed to ${n.class.name} factory`);return a}},v(e,"$name","Factoryable"),e},{getOwnPropertyDescriptor:bA}=Reflect,Ht=class extends $.mixin(ds){static get factoryable(){return{defaultType:"auto"}}static get prototypeProperties(){return{compare:null,compareItems:null,dataSource:null,alwaysWrite:!1,nullable:!0,nullText:null,nullValue:void 0,persist:!0,readOnly:!1,internal:!1,calculated:!1,useProp:null,bypassEqualityOnSyncDataset:!1}}construct(i){const e=this;i&&(e.name=i.name,Object.assign(e,i)),e.compare&&(e.compareItems=(t,r)=>e.compare(t==null?void 0:t[e.name],r==null?void 0:r[e.name]))}defineAccessor(i,e){const{name:t,dataSource:r}=this;!e&&t in i&&i.$meta.hierarchy.some(n=>{var s;return((s=bA(n.prototype,t))==null?void 0:s.enumerable)===!1})||Reflect.defineProperty(i,t,{configurable:!0,enumerable:!0,get:this.complexMapping?function(){return this.complexGet(t,r)}:function(){return this.batching&&t in this.meta.batchChanges?this.meta.batchChanges[t]:this.data[r]},set(n){const s=this.$meta.fields.map[t];s&&s.readOnly||this.set(t,n)}})}isEqual(i,e){return T.isEqual(i,e)}print(i){return i==null?this.nullText:this.printValue(i)}printValue(i){return String(i)}getCurrentConfig(){const i={};for(const e in this.constructor.prototypeProperties)i[e]=this[e];return delete i.isConstructing,i}};v(Ht,"$name","DataField"),v(Ht,"type","auto"),Ht._$name="DataField";var Gd=class extends Ht{isEqual(i,e){return i===e}getAt(i,e){return i.get(this.name)[e]}};v(Gd,"$name","ArrayDataField"),v(Gd,"type","array"),Gd.initClass(),Gd._$name="ArrayDataField";var Ha=class extends Ht{static get prototypeProperties(){return{nullValue:!1}}isEqual(i,e){return i==null&&e==null?!0:super.isEqual(i,e)}convert(i){var e;return i==null?this.nullable?i:this.nullValue:((e=i.toLowerCase)==null?void 0:e.call(i))==="false"?!1:!!i}};v(Ha,"$name","BooleanDataField"),v(Ha,"type","boolean"),v(Ha,"alias","bool"),Ha.initClass(),Ha._$name="BooleanDataField";var ja=class extends Ht{static get prototypeProperties(){return{format:null}}convert(i){if(i==null)this.nullable||(i=this.nullValue);else if(i==="now")i=new Date;else if(!(i instanceof Date)){const e=i;i=w.parse(i,this.format||w.defaultParseFormat),(!i||isNaN(i))&&(i=void 0,e!==""&&console.warn(`Date parsing failed for "${this.name}" field, input: ${JSON.stringify(e)}. ${this.format?`Expected format: ${this.format}.`:'You should configure your Model field with a "format" to specify how dates should be parsed. See docs for DateDataField here: https://bryntum.com/products/scheduler/docs/api/Core/data/field/DateDataField, and see https://bryntum.com/products/scheduler/docs/api/Core/helper/DateHelper for the different formats.'}"`))}return i}serialize(i){return i instanceof Date&&(i=w.format(i,this.format||w.defaultFormat)),i}printValue(i){return w.format(i,this.format||w.defaultFormat)}};v(ja,"$name","DateDataField"),v(ja,"type","date"),ja.initClass(),ja._$name="DateDataField";var Va=class extends Ht{static get prototypeProperties(){return{nullValue:""}}convert(i){return i==null?this.nullable?i:this.nullValue:String(i)}};v(Va,"$name","StringDataField"),v(Va,"type","string"),Va.initClass(),Va._$name="StringDataField";var Yd=class extends Va{isEqual(i,e){return w.compareUnits(i,e)===0}};v(Yd,"$name","DurationUnitDataField"),v(Yd,"type","durationunit"),Yd.initClass(),Yd._$name="DurationUnitDataField";var za=class extends Ht{static get prototypeProperties(){return{nullValue:0,rounding:"round"}}convert(i){return i==null?this.nullable?i:this.nullValue:Math[this.rounding](Number(i))}};v(za,"$name","IntegerDataField"),v(za,"type","integer"),v(za,"alias","int"),za.initClass(),za._$name="IntegerDataField";var Na=class extends Ht{static get prototypeProperties(){return{complexMapping:!0}}isEqual(i,e){return i&&e&&e instanceof i.constructor&&e.id==i.id}};v(Na,"$name","ModelDataField"),v(Na,"type","model"),v(Na,"configurable",{modelClass:null}),Na.initClass(),Na._$name="ModelDataField";var cs=class extends Ht{static get prototypeProperties(){return{nullValue:0,precision:null}}isEqual(i,e){return isNaN(Number(i))&&isNaN(Number(e))||super.isEqual(i,e)}convert(i){if(i==null)return this.nullable?i:this.nullValue;if(i=Number(i),isNaN(i))return;let e=this.precision;return e?(e=10**e,i=Math.round(i*e)/e):e===0&&(i=Math.round(i)),i}};v(cs,"$name","NumberDataField"),v(cs,"type","number"),v(cs,"alias","float"),cs.initClass(),cs._$name="NumberDataField";var qd=class extends Ht{static get prototypeProperties(){return{complexMapping:!0}}};v(qd,"$name","ObjectDataField"),v(qd,"type","object"),qd.initClass(),qd._$name="ObjectDataField";var CA=i=>typeof i=="string"&&i.startsWith("_generated"),Kd=class extends Ht{init(i,e){var t;const r=this,n=`${r.name}Store`,s={skipStack:!0,syncDataOnLoad:!0,useRawData:!1};if(r.store&&T.assign(s,r.store),r.modelClass&&(s.modelClass=r.modelClass),(t=e[`init${O.capitalize(n)}`])==null||t.call(e,s),!s.storeClass&&!r.storeClass)throw new Error(`Field '${r.name}' with type 'store' must have a storeClass configured`);const a=e.meta[n]=new(s.storeClass||r.storeClass)(s);r.complexMapping?T.setPath(i,r.dataSource,a):i[r.dataSource]=a,a.verifyNoGeneratedIds=!1,a.usesId=r.usesId||!a.count||!a.every(o=>o.hasGeneratedId),a.$currentValue=r.getValue(a,e),a.ion({change:({action:o})=>{const l=r.getValue(a,e);if(!a.$isSettingStoreFieldData){const d=a.$preserveCurrentDataset;a.$preserveCurrentDataset=r.subStore&&(o==="update"||o==="remove"||o==="add"),r.$isUpdatingRecord=!0,e.set(r.name,l),r.$isUpdatingRecord=!1,a.$preserveCurrentDataset=d}a.$currentValue=l}})}set(i,e,t){var r,n;const s=this,a=`${s.name}Store`,{[a]:o}=t.meta;if(i!=null&&i.isStore&&(i=i.$currentValue),!o)return t.meta.initableValues.set(s,i),!1;o.$isSettingStoreFieldData||(o.$isSettingStoreFieldData=!0,i=(n=(r=t[`process${O.capitalize(a)}Data`])==null?void 0:r.call(t,i,t))!=null?n:i,o.$preserveCurrentDataset||(o.data=i),o.$isSettingStoreFieldData=!1,o.usesId=s.usesId||!o.count||!o.every(l=>l.hasGeneratedId))}serialize(i,e){const t=e.meta[`${this.name}Store`];return this.$isUpdatingRecord?this.getValue(t,e):t.$currentValue}getValue(i,e){const t=`get${O.capitalize(this.name)}StoreValue`;return e[t]?e[t](i):i.allRecords.map(r=>{const n=r.persistableData;return i.usesId||delete n.id,n})}isEqual(i,e){if(i==null&&e==null)return!0;if(i==null&&e!=null||i!=null&&e==null)return!1;if(i.isStore&&e.isStore)return T.isDeeplyEqual(i.$currentValue,e.$currentValue);if(i.isStore&&e.isStore||!i.isStore&&!e.isStore)return T.isEqual(i,e,!0);{const t=i.isStore?i:e,r=t.modelClass,n=r.$meta.fields.defs,s=i.isStore?i.$currentValue:e.$currentValue,a=i.isStore?e:i;if(s.length!==a.length)return!1;for(let o=0;o<n.length;o++){const l=n[o];if(l.persist)for(let d=0;d<s.length;d++){const c=s[d][l.dataSource],u=a[d][l.dataSource];if(!(c!==void 0&&u===void 0&&(l.dataSource===r.idField&&CA(c)||l.defaultValue!==void 0&&T.isEqual(l.defaultValue,c,!0)))&&!T.isEqual(c,u,!0))return!1}}return!0}}getOldValue(i){const e=i.meta[`${this.name}Store`];return e?T.clone(e.$currentValue):null}getAt(i,e){const t=i.meta[`${this.name}Store`];return t==null?void 0:t.getAt(e)}};v(Kd,"$name","StoreDataField"),v(Kd,"type","store"),Kd.initClass(),Kd._$name="StoreDataField";var zw=new RegExp(/^(.*?)\.(.*)/),mv=/(.*)\[(.*)]\.?(.*)/,{defineProperty:SA}=Reflect,{hasOwn:Xd}=T,Er=void 0,DA={children:1,data:1,meta:1},wA=["name","title","text","label","description"],EA={boolean:1,number:1,date:1,object:1},Nw={parentId:1,$PhantomId:2,id:3},pv=class GS extends $.mixin($w,Bw,jw){static get declarable(){return["fields"]}static get fields(){return[{name:"parentIndex",type:"number",persist:!1,internal:!0},{name:"orderedParentIndex",type:"number",persist:!1,internal:!0},{name:"readOnly",type:"boolean"},{name:"expanded",internal:!0}]}static set idField(e){this._assignedIdField=!0,this._idField=e}static get idField(){return this._idField}get id(){var e;return(e=this._id)!=null?e:this.getData("id")}set id(e){this.set("id",e)}static set childrenField(e){this._childrenField=e}static get childrenField(){if(!this._childrenField){const e=this.fieldMap.children;this._childrenField=(e==null?void 0:e.dataSource)||"children"}return this._childrenField}get indexPath(){const e=[];let t=this,r=t.childLevel;for(t=this;t&&!t.isRoot;t=t.parent)e[r--]=t.parentIndex+1;return e}construct(e={},t=null,r=null,n=!1,s=!1,a=!1){var o,l;const d=this,{constructor:c,fieldMap:u}=d;if(d.meta={modified:{},...c.metaConfig,...r},c.applyConfigs){const h={};(!d.useRawData||!d.useRawData.enabled)&&(e={...e});const f=d.getDefaultConfiguration();if(c.autoExposeFields)for(const g in f)g in e&&(e[g]!==void 0&&(h[g]=e[g]),delete e[g]);else for(const g in e)g in c.fieldMap||(e[g]===void 0?h[g]=f[g]:h[g]=e[g],delete e[g]);super.construct(h)}else super.construct(null);if(n||c.exposeProperties(e,a),!Xd(c,"idFieldProcessed")){let h=d.meta.idField;h||c._assignedIdField&&(h=c.idField),h&&h!==u.id.dataSource&&c.addField({name:"id",dataSource:h,internal:!0}),c._idField=u.id.dataSource,c.idFieldProcessed=!0}d._internalId=GS._internalIdCounter++,d.originalData||(d.originalData=e),d.data=c.processData(e,!1,t,d,s),d._id=u.id.complexMapping?T.getPath(d.data,c._idField):d.data[c._idField],(o=d.meta.initableValues)!=null&&o.size&&d.assignInitables(),d._id==null&&!(c.allowNullId&&d._id===null)&&d.setData("id",d.generateId(t)),d.data[c.childrenField]&&d.processChildren((l=H.asArray(t))!=null?l:[]),d.generation=0}set isCreating(e){var t;const r=this;!!r.meta.isCreating!==e&&(r.meta.isCreating=e,(t=r.stores)==null||t.forEach(n=>n.onIsCreatingToggle(r,e)))}get isCreating(){return!!this.meta.isCreating}equals(e){if(e instanceof this.constructor){for(let t=this.$meta.fields.defs,r=0,{length:n}=t;r<n;r++){const s=t[r],{name:a}=s;if(a!=="id"&&!s.isEqual(this.getValue(a),e.getValue(a)))return!1}return!0}return!1}get subclass(){return new this.constructor(Object.setPrototypeOf({id:Er},this.data),this.stores[0],null,!0)}static processData(e,t=!1,r,n,s){const{fieldMap:a,defaultValues:o}=this,{useRawData:l={enabled:!1}}=r||{},d=s||l.enabled?e:T.clone(e);let c;if(t=t||l.disableDefaultValue||s,!t||!l.disableTypeConversion&&!s)for(c in a){const u=a[c],{name:h,dataSource:f}=u,g=f!==h,m=u.complexMapping,p=m?T.getPath(d,f):d[f],y=p===void 0?m?T.getPath(d,h):d[h]:void 0,b=p!==void 0,C=y!==void 0,D=!b&&C,S=b||C,x=!l.disableTypeConversion&&u.convert;let R=D?y:p;if(!t&&f in o&&!S&&!u.fromData){let M=o[f];Array.isArray(M)?M=M.slice():M instanceof Date?M=new Date(M):M&&typeof M=="object"&&(M=T.clone(M)),m?T.setPath(d,f,M):d[f]=M,R=M}if((D||x)&&(!t||S)){const M=x?u.convert(R,e,n):R;if(M===void 0&&R===Er&&!b)continue;m?T.setPath(d,f,M):d[f]=M,g&&delete d[h]}}return this.$meta.fields.initable.length&&this.initInitables(n,d),d}static setupClass(e){super.setupClass(e),e.fields||this.setupFields(this,e)}static setupFields(e,t){var r,n,s,a,o;const l=Xd(e,"fields")&&e.fields,d=t.super.fields,c=t.fields={defs:(r=d==null?void 0:d.defs.slice())!=null?r:[],exposedData:!1,defaults:d?{...d.defaults}:{},exposed:Object.create((n=d==null?void 0:d.exposed)!=null?n:null),ordinals:Object.create((s=d==null?void 0:d.ordinals)!=null?s:null),map:Object.create((a=d==null?void 0:d.map)!=null?a:null),sources:Object.create((o=d==null?void 0:d.sources)!=null?o:null)};Xd(e,"defaults")&&Object.assign(c.defaults,e.defaults),Xd(e,"idField")&&(e.addField({name:"id",dataSource:e.idField,internal:!0}),c.exposed[e.idField]=!0),l!=null&&l.length&&l.map(e.addField,e),c.initable=c.defs.filter(u=>u.init),e.exposeRelations()}static get defaultValues(){return this.$meta.fields.defaults}static get allFields(){return this.$meta.fields.defs}get allFields(){return this.$meta.fields.defs}static get fieldMap(){return this.$meta.fields.map}get fieldMap(){return this.$meta.fields.map}static get fieldDataSourceMap(){return this.$meta.fields.sources}static exposeProperties(e,t=!0){const r=this,n=r.$meta.fields,s=t?"exposed":"map";if(e&&r.autoExposeFields&&!n.exposedData){let a,o,l;for(a in e)!n[s][a]&&a!==r.childrenField&&(l=T.typeOf(e[a]),o={name:a,dataSource:a,fromData:!0},EA[l]&&(o.type=l),r.addField(o));n.exposedData=!0}r.exposeRelations()}static addField(e){if(e==null)return;typeof e=="string"&&(e={name:e});const t=this.initClass(),r=t.$meta.fields,{ordinals:n}=r,s=r.exposed,{name:a}=e,o=r.map[a],l=e.dataSource||(e.dataSource=a);let d,c;if(!o||e.type&&e.type!==o.type)d=Ht.create(e),d.definedBy=o?o.definedBy:t,d.ordinal=o?o.ordinal:n[a]=r.defs.length;else{d=Object.create(o);for(c in e)c!=="type"&&(d[c]=e[c])}return d.owner=t,r.defs[d.ordinal]=d,r.map[a]=d,r.sources[l]=d,l.includes(".")&&(d.complexMapping=!0),d.complexMapping?s[l.split(".")[0]]=!0:s[l]=!0,"defaultValue"in d&&(r.defaults[l]=d.defaultValue),DA[a]||d.defineAccessor(t.prototype),t._nonPersistableFields=null,t._alwaysWriteFields=null,d}static removeField(e){const t=this.initClass(),r=t.$meta.fields,n=r.map[e],{ordinals:s}=r,a=s[e];if(n){r.defs.splice(a,1),delete s[e],delete r.defaults[e],delete r.exposed[e],delete r.map[e],delete r.sources[n.dataSource];for(const o in s)s[o]>a&&--s[o];delete t.prototype[e]}}static exposeRelations(){const e=this;if(!Xd(e,"exposedRelations")&&e.relations){e.exposedRelations=[];for(const t in e.relations){const r=e.relations[t];r.relationName=t,e.exposedRelations.push(r),Reflect.ownKeys(e.prototype).includes(t)||SA(e.prototype,t,{enumerable:!0,get:function(){return this.getForeign(t)},set:function(n){this.setForeign(t,n,r)}})}}}static initInitables(e,t){const r=e.meta.initableValues=new Map;for(const n of this.$meta.fields.initable){const s=T.getPath(t,n.dataSource);s!==void 0&&r.set(n,s),!n.lazy&&n.init(t,e)}}assignInitables(){const{initableValues:e}=this.meta;for(const[t,r]of e)t.set(r,this.data,this)!==!1&&e.delete(t)}static get autoExposeFields(){return!0}static fieldSorter(e,t){return(Nw[e]||100)-(Nw[t]||100)}get fields(){return this.$meta.fields.defs}getFieldDefinition(e){return this.constructor.getFieldDefinition(e)}getFieldDefinitionFromDataSource(e){return this.$meta.fields.sources[e]}get fieldNames(){return Object.keys(this.data)}static getFieldDefinition(e){var t;const r=this.fieldMap[e];if(!r){if(e.includes("[")){const[,n,,s]=e.match(mv),a=n.includes(".")?this.getFieldDefinition(n):this.fieldMap[n];if(a!=null&&a.isStoreDataField)return(t=a.modelClass)==null?void 0:t.getFieldDefinition(s)}else if(e.includes(".")){const[n,s]=e.split(".",2),a=this.fieldMap[n];if(a!=null&&a.isModelDataField&&a.modelClass)return a.modelClass.getFieldDefinition(s)}}return r}static getFieldDataSource(e){var t;return((t=this.getFieldDefinition(e))==null?void 0:t.dataSource)||e}getDataSource(e){const t=this.constructor.getFieldDefinition(e);return(t==null?void 0:t.dataSource)||(t==null?void 0:t.name)}static processField(e,t,r){const n=this.fieldMap[e];return n!=null&&n.convert?n.convert(t,this.data,r):t}initRelations(){const e=this;e.constructor.exposedRelations&&e.stores.forEach(r=>{var n;r.modelRelations||r.initRelations();const s=[];(n=r.modelRelations)==null||n.forEach(a=>{s.push({related:e.initRelation(a),config:a})}),r.updateRecordRelationCache(e,s)})}initRelation(e){const t=this,r=t.get(e.foreignKey),n=r!==Er&&typeof e.foreignStore!="string"&&e.foreignStore.getById(r),s=t.meta.relationCache||(t.meta.relationCache={});return s[e.relationName]=n||(r!=null?{id:r,placeHolder:!0}:null),n}removeRelation(e){const{relationName:t,foreignKey:r,nullFieldOnRemove:n}=e;this.meta.relationCache[t]&&(delete this.meta.relationCache[t],n&&this.setData(r,null))}getForeign(e){var t;return(t=this.meta.relationCache)==null?void 0:t[e]}setForeign(e,t,r){const n=GS.asId(t);return this.set(r.foreignKey,n)}getRelationConfig(e){var t,r;return(r=(t=this.firstStore)==null?void 0:t.modelRelations)==null?void 0:r.find(n=>n.foreignKey===e)}flatGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:this.data[t]}complexGet(e,t){return this.batching&&e in this.meta.batchChanges?this.meta.batchChanges[e]:T.getPath(this.data,t)}get(e){if(!e)return;const t=this,{fieldMap:r}=t,n=r[e];if(!n){if(e.includes("[")){const[,s,a,o]=e.match(mv),l=r[s];if(l!=null&&l.getAt){t._thisIsAUsedExpression(t[s]);const d=l.getAt(t,a);return d&&o?d.isModel?d.getValue(o):d[o]:d}return null}if(e.includes(".")){const[s,a]=e.split(".",2),o=r[s];if(o!=null&&o.isStoreDataField){const l=t[s],d=l.modelClass;return a in d.fieldMap||!(a in l)?l==null?void 0:l.getDistinctValues(a):l[a]}else if(!T.hasPath(t.data,e))return T.getPath(t,e);return t.complexGet(e,e)}}return n!=null&&n.complexMapping?t.complexGet(e,n.dataSource):t.flatGet(e,(n==null?void 0:n.dataSource)||e)}getValue(e){if(e)return e in this&&!e.includes(".")?this[e]:this.get(e)}setValue(e,t){e in this?this[e]=t:this.set(e,t)}setData(e,t){var r,n;const{data:s,fieldMap:a}=this;if(typeof e=="string"){const o=a[e],l=(r=o==null?void 0:o.dataSource)!=null?r:e;o!=null&&o.set?o.set(t,this.data,this):o!=null&&o.complexMapping?T.setPath(s,l,t):s[l]=t,o==="id"?this._id=t:e==="parentId"&&(s[this.constructor.parentIdField]=t)}else{const o=Object.keys(e);for(let l=0;l<o.length;l++){const d=o[l],c=a[d],u=(n=c==null?void 0:c.dataSource)!=null?n:d;c!=null&&c.set?c.set(t,this.data,this):u&&(c!=null&&c.complexMapping?T.setPath(s,u,e[d]):s[u]=e[d],d==="id"?this._id=t:d==="parentId"&&(s[this.constructor.parentIdField]=t))}}}getData(e){var t;const r=this.fieldMap[e],n=(t=r==null?void 0:r.dataSource)!=null?t:e;if(n)return r!=null&&r.complexMapping?T.getPath(this.data,n):this.data[n]}syncId(e){const t=this.id;if(t!==e){this._id=e,this.setData("id",e);const r={id:{value:e,oldValue:t}};this.afterChange(r,r)}}set(e,t,r=!1,n=!1,s=!1,a=!1,o=!0){var l;const d=this;if(d.isBatchUpdating)return d.inBatchSet(e,t,r||d.$silenceBatch),null;{const c=d.inSet(e,t,r,n,s,a,o);return(l=d.afterSet)==null||l.call(d,e,t,r,n,c),c}}fieldToKeys(e,t){return typeof e!="string"?T.assign({},e):{[e]:t}}inBatchSet(e,t,r){var n;const s=this,{meta:a,constructor:o,fieldMap:l}=s,d={};let c,u=!1;if(typeof e!="string"?Object.keys(s.fieldToKeys(e,t)).forEach(h=>{c=l[h]||T,t=o.processField(h,e[h],s),c.isEqual(a.batchChanges[h],t)||(d[h]={value:t,oldValue:s.get(h)},a.batchChanges[h]=t,u=!0)}):(c=l[e]||T,c.isEqual(a.batchChanges[e],t)||(d[e]={value:t,oldValue:s.get(e)},a.batchChanges[e]=t,u=!0)),u&&(s.generation++,!r)){const h={action:"update",record:s,records:[s],changes:d};(n=s.stores)==null||n.forEach(f=>f.trigger("batchedUpdate",{...h})),s.forEachLinked((f,g)=>f.trigger("batchedUpdate",{...h,record:g,records:[g]}))}}inSet(e,t,r,n,s=!1,a=!1,o=!0){var l,d,c,u,h,f,g;const m=this,{data:p,meta:y,fieldMap:b,constructor:C}=m,{prototype:D,childrenField:S,relations:x}=C,R={},M=m.fieldToKeys(e,t),I=Object.keys(M).sort(C.fieldSorter),_=(l=m.stores)==null?void 0:l.some(L=>L.isSyncingDataOnLoad),P=(d=m.stores)==null?void 0:d.some(L=>L.modificationsTracking>0);let A=!1;if(!r&&o&&!m.triggerBeforeUpdate(M))return null;m.inSetting=!0;for(let L=0;L<I.length;L++){const F=I[L];if(F===S)continue;if(F.includes("[")){const[,je,_e,br]=F.match(mv),Ot=m.fieldMap[je];if(Ot!=null&&Ot.getAt){const Cr=(u=Ot.getAt(m,_e))!=null?u:(c=Ot.onSubRecordMissingInSet)==null?void 0:c.call(Ot,m,_e);if(Cr==null)throw new Error(`The store field '${je}' does not contain a record at index ${_e} - can not set the data`);Cr.isModel?Cr.set(br,M[F]):T.setPath(Cr,br,M[F]);continue}}const N=F.includes(".");if(x&&N){const[,je,_e]=F.match(zw);if(x[je]){_e.includes(".")?m[je].set(_e,M[F]):m[je][_e]=M[F];continue}}const Y=b[F],G=Y||T,U=Y==null?void 0:Y.readOnly,Z=(h=Y==null?void 0:Y.dataSource)!=null?h:F,fe=!s&&!Y&&F in D||(Y==null?void 0:Y.useProp),J=fe?m[Z]:Y!=null&&Y.complexMapping||N?T.getPath(p,Z):p[Z],me=C.processField(F,M[F],m),Q=M[F]={value:me},re=m.getRelationConfig(F);!U&&(_&&(Y!=null&&Y.bypassEqualityOnSyncDataset)||!G.isEqual(J,me))&&(!a||me!==void 0)&&(m.generation++,Q.oldValue=(g=(f=Y==null?void 0:Y.getOldValue)==null?void 0:f.call(Y,m))!=null?g:J,A=!0,F in y.modified&&G.isEqual(y.modified[F],me,!1,!0)?(Reflect.deleteProperty(y.modified,F),m.isReverting&&(m.data[Z]=me)):!m.ignoreBag&&!P?(!(F in y.modified)&&!(J==null&&me==null)&&m.storeFieldChange(F,J),Q.oldValue===Er&&Reflect.deleteProperty(Q,"oldValue")):P&&Reflect.deleteProperty(y.modified,F),R[F]=Q,m.applyValue(fe,Z,me,s,Y),re&&!n&&(m.initRelation(re),m.stores.forEach(je=>je.cacheRelatedRecord(m,me,re.relationName,Q.oldValue))))}return A&&m.afterChange(M,R,r,n,s),m.inSetting=!1,A?R:null}applyValue(e,t,r,n,s){var a,o;const l=this;if(((s==null?void 0:s.dataSource)||t)===l.constructor.idField&&(l.$isPhantom=!1,l._id=r),((s==null?void 0:s.dataSource)||t)===l.constructor.parentIdField)(a=l.firstStore)!=null&&a.tree&&!((o=l.parent)!=null&&o.isRoot&&(r==null||!l.firstStore.getById(r)))&&(l.firstStore.getById(r)||l.firstStore.rootNode).insertChild(l,null,!1,{orderedParentIndex:{skip:!0}});else if(e)l[(s==null?void 0:s.name)||t]=r;else if(s!=null&&s.set)s.set(r,l.data,l);else{let d=s==null?void 0:s.complexMapping;if(!s&&t.includes(".")){const c=t.split(".")[0];s=l.constructor.fieldMap[c],d=(s==null?void 0:s.complexMapping)||(s==null?void 0:s.type)==="object"}d?T.setPath(l.data,t,r):l.data[t]=r}}afterChange(e,t,r,n,s){if(this.stores)for(const a of this.stores)a.onModelChange(this,e,t,r,n,s);this.forEachLinked((a,o)=>a.onModelChange(o,e,t,r,n,s))}forEachLinked(e){for(const t of this.$links)for(const r of t.stores)e(r,t)}get isPersistable(){return!this.isBatchUpdating&&!this.isCreating}get isModified(){return!!(this.meta.modified&&Object.keys(this.meta.modified).length>0)}get hasPersistableChanges(){return this.isPersistable&&!T.isEmpty(this.rawModificationData)}isFieldModified(e){return this.isModified&&e in this.meta.modified}getUnmodified(e){return this.isModified?this.meta.modified[e]:this.get(e)}getFieldPersistentValue(e){const t=typeof e=="string"?this.getFieldDefinition(e):e,r=(t==null?void 0:t.name)||e;let n;return(!t||t.persist)&&(n=this.getValue(r),t!=null&&t.serialize&&(n=t.serialize(n,this))),n}get modifications(){const e=this.rawModifications;return e&&Object.keys(e).length&&(e[this.constructor.idField]=this.id),e}get rawModifications(){const e=this,t={};if(!e.isModified)return null;let r=!1;return Object.keys(e.meta.modified).forEach(n=>{const s=e.getFieldPersistentValue(n);s!==Er&&(t[n]=s,r=!0)}),r?t:null}get modificationData(){const e=this.rawModificationData;return e&&Object.keys(e).length&&T.setPath(e,this.constructor.idField,this.id),e}get rawModificationData(){const e=this,{fieldMap:t}=e.constructor,r={};if(!e.isModified)return null;let n=!1;return Object.keys(e.meta.modified).forEach(s=>{let a=t[s],o=a==null?void 0:a.dataSource;if(s.includes(".")){const l=s.match(zw)[1];a=t[l],o=s}if(a!=null&&a.persist){const l=e.getFieldPersistentValue(s);l!==Er&&(T.setPath(r,o,l),n=!0)}}),n?r:null}get modificationDataToWrite(){const e=this.constructor.alwaysWriteFields,t=this.modificationData;return e.forEach(r=>{t[this.getFieldDefinition(r).dataSource]=this.getFieldPersistentValue(r)}),t}get persistableData(){const e=this,t={};return e.fields.forEach(r=>{const n=e.getFieldPersistentValue(r);n!==Er&&(r!=null&&r.complexMapping?T.setPath(t,r.dataSource,n):t[r.dataSource]=n)}),t}get dataByFieldName(){const{data:e}=this;return this.fields.reduce((t,r)=>(T.hasPath(e,r.dataSource)&&(t[r.name]=e[r.dataSource]),t),{})}get isCommitting(){return!!this.meta.committing}internalClearChanges(e=!0,t=!0,r=null,n=!1){var s,a;const o=this,{meta:l}=o;if(r){for(const c in r)delete l.modified[c];if(n)for(const c in l.modified)(s=o.getFieldDefinition(c))!=null&&s.persist||delete l.modified[c]}else l.modified=Object.assign({},l.modifiedMaterialized),l.modifiedMaterialized=null;const d=T.isEmpty(l.modified);l.committing=!1,t&&((a=o.stores)==null||a.forEach(c=>{if(d&&c.modified.remove(o),c.added.remove(o),e){const u=c.collectDescendants(o).all;c.added.remove(u),d&&c.modified.remove(u)}}))}clearChanges(e){var t;this.internalClearChanges(e),(t=this.stores)==null||t.forEach(r=>r.trigger("clearChanges",{record:this}))}storeFieldChange(e,t){var r;const{meta:n}=this;n.modified[e]=t,this.isBeingMaterialized&&(n.modifiedMaterialized=(r=n.modifiedMaterialized)!=null?r:{},n.modifiedMaterialized[e]=t)}revertChanges(e=!1){this.isReverting=!0,this.set(this.meta.modified,Er,e),this.isReverting=!1}setByDataSource(e){var t;const r=this,{fieldDataSourceMap:n}=r.constructor,s=T.pathifyKeys(e,n),a={};for(const o in s){const l=n[o],d=(t=l==null?void 0:l.name)!=null?t:o;a[d]=s[o]}return r.set(a)}applyChangeset(e,t="$PhantomId",r=!0){var n;const s=this,a=s.constructor,{idField:o,fieldDataSourceMap:l}=a,d=T.pathifyKeys(e,l),c=T.pathifyKeys(s.modificationData),u={},h=t in e&&!(o in e);!h&&t in d&&delete d[t];for(const g in d){const m=l[g],p=(n=m==null?void 0:m.name)!=null?n:g;(r||((m==null?void 0:m.name)===o?h:d[g]===c[g]))&&(u[p]=d[g])}const f=s.set(u);return s.internalClearChanges(!1,!0,r?null:u),f?Object.entries(f).reduce((g,[m,p])=>(g[m]=p.value,g),{}):{}}get internalId(){return this._internalId}get isPhantom(){return this.id===""||this.id==null||this.hasGeneratedId||!!this.$isPhantom}get isModel(){return!0}get hasGeneratedId(){return typeof this.id=="string"&&this.id.startsWith("_generated")}static generateId(e=this.$$name){return`_generated${e}_${O.generateUUID()}`}generateId(){return this.constructor.generateId()}static asId(e){return e!=null&&e.isModel?e.id:T.isObject(e)?e[this.fieldMap.id.dataSource]:e}get json(){return O.safeJsonStringify(this)}toJSON(){const{children:e,unfilteredChildren:t}=this,r=this.persistableData;return(t||e)&&(r[this.constructor.childrenField]=(t||e).map(n=>n.toJSON())),r}toString(){const e=this,t=wA.find(n=>n in e.constructor.fieldMap),r=t?{[e.constructor.idField]:e.id,[t]:e[t]}:e.data;return O.safeJsonStringify(r)}get isBatchUpdating(){return!!this.batching}hasBatchedChange(e){var t,r;return(r=(t=this.meta)==null?void 0:t.batchChanges)==null?void 0:r[e]}beginBatch(e=!1){const t=this;t.batching||(t.batching=0,t.meta.batchChanges={}),e&&(t.$silenceBatch=(t.$silenceBatch||0)+1),t.batching++}endBatch(e=!1,t=!1,r=!0){const n=this,{parentIdField:s}=n.constructor;if(n.batching&&(n.batching--,n.$silenceBatch&&n.$silenceBatch--,!(n.batching>0)&&!T.isEmpty(n.meta.batchChanges))){let{batchChanges:a}=n.meta;n.meta.batchChanges=null,a[s]&&(a={...a},n.parentId=a[s],delete a[s]),n.set(a,Er,e,!1,t,void 0,r)}}cancelBatch(){var e;if(this.batching){const t=this,{batchChanges:r}=t.meta,n={};if(t.batching=null,t.meta.batchChanges=null,t.generation++,!t.$silenceBatch){Object.entries(r).forEach(([a,o])=>{n[a]={oldValue:o,value:t[a]}});const s={action:"update",record:t,records:[t],changes:n};(e=t.stores)==null||e.forEach(a=>a.trigger("batchedUpdate",{...s})),t.forEachLinked((a,o)=>a.trigger("batchedUpdate",{...s,record:o,records:[o]}))}t.$silenceBatch&&t.$silenceBatch--}}triggerBeforeUpdate(e){var t;return!((t=this.stores)!=null&&t.some(r=>r.trigger("beforeUpdate",{record:this,changes:e})===!1))}copy(e=null,t){const r=this,n=T.clone(r.data),s=r.constructor.idField,a=T.isObject(t)?t.deep:t;let o;if(e&&typeof e=="object"?(o=e[s],Object.assign(n,e)):o=e,a&&r.children?n.children=r.children.map(d=>d.copy(e===!1?!1:void 0,t)):(delete n.children,delete n.expanded),r.$meta.fields.initable.length>0){const d=r.toJSON();for(const c of r.$meta.fields.initable)n[c.name]=d[c.name]}e!==!1&&(n[s]=o||r.generateId(r.firstStore));const l=new r.constructor(n,null,null,!1,!0);return l.originalInternalId=r.internalId,l}copyData(e,t,r){const n={},s=this.skipCopyFields||{};e.allFields.forEach(({name:a})=>{a!==e.constructor.idField&&!(a in s)&&(n[a]=t?e.get(a):e.getValue(a))}),this.set(n,null,r)}remove(e=!1){const t=this,{parent:r,stores:n}=t;r?r.removeChild(t):n!=null&&n.length&&!t.isSpecialRow&&n.slice().forEach(a=>a.remove(t,e,!1,!0))}beforeRemove(e,t){return super.beforeRemove(e,t)}get isValid(){return!0}get firstStore(){var e;return(e=this.stores)==null?void 0:e[0]}joinStore(e){var t,r;const n=this;(!n.stores||!n.stores.includes(e))&&(super.joinStore(e),e.register(n),n.stores?n.stores.push(e):n.stores=[e],n.unjoinedStores&&n.unjoinedStores.includes(e)&&n.unjoinedStores.splice(n.unjoinedStores.indexOf(e),1),(t=n.children)!=null&&t.length&&n.children.forEach(s=>s.joinStore(e)),n.constructor.exposedRelations&&n.initRelations(),e.tree&&!n.isRoot&&!((r=e.stm)!=null&&r.isRestoring)&&(n.instanceMeta(e.id).collapsed=!n.expanded))}unjoinStore(e,t=!1){var r,n,s;const a=this,{stores:o}=a;o!=null&&o.includes(e)&&(e.isDestroying||(e.unregister(a),a.unjoinedStores?a.unjoinedStores.push(e):a.unjoinedStores=[e]),(n=(r=a.unfilteredChildren||a.children)==null?void 0:r.forEach)==null||n.call(r,l=>l.unjoinStore(e,t)),o.splice(o.indexOf(e),1),(s=super.unjoinStore)==null||s.call(this,e,t),e.uncacheRelatedRecord(a),a.meta.map&&!e.stm&&delete a.meta.map[e.id])}isPartOfStore(e){var t;return e?e.includes(this):((t=this.stores)==null?void 0:t.length)>0}get isRemoved(){return!this.isPartOfStore()}instanceMeta(e){var t;const{meta:r}=this,n=e.id||e;return((t=r.map)==null?void 0:t[n])||this.setInstanceMeta(n,{})}setInstanceMeta(e,t){const{meta:r}=this,n=e.id||e;return r.map||(r.map={}),r.map[n]=t}get isGroupHeader(){return"groupRowFor"in this.meta}get isGroupFooter(){return"groupFooterFor"in this.meta}get isSpecialRow(){var e;return!!((e=this.meta)!=null&&e.specialRow)}get $original(){return this.isLinked?this.proxyMeta.originalRecord:this}static get nonPersistableFields(){const e=this;return e._nonPersistableFields||(e._nonPersistableFields={},e.allFields.forEach(t=>{(!t.persist||t.calculated)&&(e._nonPersistableFields[t.name]=1)})),e._nonPersistableFields}static get alwaysWriteFields(){const e=this;return e._alwaysWriteFields||(e._alwaysWriteFields=[],e.allFields.forEach(t=>{t.alwaysWrite&&e._alwaysWriteFields.push(t.name)})),e._alwaysWriteFields}get domId(){return typeof this.id=="string"?this.id.replace(/[ .]/g,"-"):this.id}static toJavaScriptValue(e){const{names:t}=this.$meta,r=t[t.length-2],n=t[t.length-3];return`class ${r} extends ${n} { static fields = ${O.toJavaScriptValue(this.fields,e)}; }`}getCurrentConfig(e){const{data:t,children:r}=this,{defaultValues:n,applyConfigs:s}=this.constructor,a=s?super.getCurrentConfig(e):{};if(a){for(const o of this.fields)if(o.persist){const l=T.getPath(t,o.dataSource);l!=null&&!o.isEqual(l,n[o.name])&&T.setPath(a,o.dataSource,$.processConfigValue(l,e))}if(r)if(Array.isArray(r)){a.children=[];for(const o of r)a.children.push(o.getCurrentConfig(e))}else a.children=r;this.hasGeneratedId&&delete a.id,delete a.parentId,delete a.parentIndex}return a}};v(pv,"$name","Model"),v(pv,"relations",null);var he=pv;he._idField="id",he._internalIdCounter=1,he._assignedIdField=!1,he.exposeProperties(),he._$name="Model";var Ww=Object.hasOwn||((i,e)=>Object.prototype.hasOwnProperty.call(i,e)),vv=null;function xA(i,e){return Object.defineProperty(i,"parser",{value:e}),e}var RA=class{constructor(i){this.formatter=i}format(i){return this.formatter.defaultFormat(i)}parse(i,e){return this.formatter.defaultParse(i,e)}resolvedOptions(){return null}},Zd=class{static get(i){if(i==null)return this.NULL;if(i instanceof this)return i;const e=typeof i=="string"?i:JSON.stringify(i),t=this.cache;let r=t.get(e);return r||(vv=e,r=new this(i),t.set(e,r)),r}static get cache(){return Ww(this,"_cache")&&this._cache||(this._cache=new Map)}static get NULL(){return Ww(this,"_null")?this._null:this._null=new this(null)}constructor(i){const e=this,{standardOptions:t}=e.constructor;if(e.cacheKey=vv,vv=null,e.initialize(),i===null)e.formatter=new RA(e);else{e.configure(i);for(const[r,n]of Object.entries(e.resolvedOptions()))n!=null&&t.includes(r)&&(e[r]=n)}}get parser(){return xA(this,new this.constructor.Parser(this))}defaultFormat(i){return i==null?i:String(i)}defaultParse(i){return i}format(i){return i==null?i:this.formatter.format(i)}parse(i,e){return i==null?i:this.parser.parse(i,e)}parseStrict(i){return this.parse(i,!0)}resolvedOptions(){return this.formatter.resolvedOptions()}};v(Zd,"standardOptions",Object.freeze([])),Zd._$name="Formatter";var Pf=O.escapeRegExp,Uw=/[\d+-]/g,Af=(i,e)=>new Intl.NumberFormat(i||void 0,e),TA=/^(?:([$])\s*)?(?:(\d+)>)?\d+(,\d+)?(?:\.((\d*)(?:#*)|[*]))?(?:\s*([%])?)?$/,MA="\u2212",IA=class{constructor(i){const e=this,t=i.locale,r=Af(t,{maximumFractionDigits:3}),n=i.is.currency?e._decodeStyle(t,{style:"currency",currency:i.currency,currencyDisplay:i.currencyDisplay}):null,s=i.is.percent?e._decodeStyle(t,{style:"percent"}):null,a=r.format(1.2).replace(Uw,"")[0],o=r.format(1e9).replace(Uw,"")[0]||"";Object.assign(e,{currency:n,decimal:a,formatter:i,grouper:o,percent:s}),e.decimal=a,e.decimalRe=Pf(a,"g"),e.grouper=o,e.stripRe=new RegExp(`(?:\\s+|${Pf(o)})`+(n?`|(?:${Pf(n.text)})`:"")+(s?`|(?:${Pf(s.text)})`:""),"g")}decimalPlaces(i){i=i.replace(this.stripRe,"");const e=i.indexOf(this.decimal)+1;return e&&i.length-e}parse(i,e){return typeof i=="string"&&(i=i.replace(this.stripRe,"").replace(this.decimalRe,".").replace(MA,"-"),i=e?Number(i):parseFloat(i),this.formatter.is.percent&&(i/=100)),i}_decodeStyle(i,e){const t=Af(i,e),r=Af(i,Object.assign(t.resolvedOptions(),{style:"decimal"})),n=t.format(0),s=r.format(0);return{suffix:n.startsWith(s),text:n.replace(s,"").trim()}}},yv=class $I extends Zd{initialize(){this._as={},this.is={decimal:!1,currency:!1,percent:!1,null:!0,from:null}}get truncator(){const e=this.maximumFractionDigits,t=Math.min(20,e+1);return e==null?null:this.as({style:"decimal",maximumFractionDigits:t,minimumFractionDigits:t},"truncator")}configure(e){typeof e!="string"?Object.assign(this,e):this.template=e;const t=this,r={},n=t.locale?$e.locales[t.locale]:$e.locale,s=n==null?void 0:n.NumberFormat,{template:a}=t,{standardOptions:o}=t.constructor;if(s)for(const l in s)t[l]==null&&typeof s[l]!="function"&&(t[l]=s[l]);if(a){const l=TA.exec(a),d=l[2],c=l[4];t.useGrouping=!!l[3],t.style=l[1]?"currency":l[6]?"percent":"decimal",d&&(t.integer=+d),c==="*"?t.fraction=[0,20]:c!=null&&(t.fraction=[l[5].length,c.length])}t._minMax("fraction",!0,!0),t._minMax("integer",!0,!1),t._minMax("significant",!1,!0);for(const l of o)t[l]!=null&&(r[l]=t[l]);t.is.from=t.from&&t.from.is,t.is[t.style]=!(t.is.null=!1),t.formatter=Af(t.locale,r)}as(e,t=null){const r=this.resolvedOptions()||{template:"9.*"},n=this._as;let s=t&&n[t];return s||(typeof e=="string"?r.style=e:Object.assign(r,e),r.from=this,s=new $I(r)),t&&(n[t]=s),s}defaultParse(e,t){return e==null?e:t?Number(e):parseFloat(e)}format(e){if(typeof e=="string"){const t=Number(e);e=isNaN(t)?this.parse(e):t}return super.format(e)}round(e){return this.parse(this.format(e))}truncate(e){const t=this,r=t.maximumFractionDigits,{truncator:n}=t;let s=t.parse(e),a;return n&&(s=n.format(s),a=s.indexOf(n.parser.decimal),a>-1&&s.length-a-1>r&&(s=s.slice(0,a+r+1)),s=n.parse(s)),s}resolvedOptions(){const e=super.resolvedOptions();for(const t in e)e[t]===void 0&&(e[t]=this[t]);return e}_minMax(e,t,r){const n=this,s=n[e];if(s!=null){const a=O.capitalize(e),o=`maximum${a}Digits`,l=`minimum${a}Digits`;typeof s=="number"?(t&&(n[l]=s),r&&(n[o]=s)):(n[l]=s[0],n[o]=s[1])}}};v(yv,"$name","NumberFormat"),v(yv,"standardOptions",["currency","currencyDisplay","locale","maximumFractionDigits","minimumFractionDigits","minimumIntegerDigits","maximumSignificantDigits","minimumSignificantDigits","style","useGrouping"]);var Ti=yv;Ti.Parser=IA,Object.assign(Ti.prototype,{currency:null,currencyDisplay:"symbol",fraction:null,from:null,integer:null,locale:null,maximumFractionDigits:null,minimumFractionDigits:null,minimumIntegerDigits:null,maximumSignificantDigits:null,minimumSignificantDigits:null,significant:null,style:"decimal",template:null,useGrouping:!0}),Zd.number=(i,e)=>Ti.get(i).format(e),$e.ion({locale:()=>Ti.cache.clear()}),Ti._$name="NumberFormat";var Le=class pp{constructor(e,t){typeof e=="number"||e===null?(this._magnitude=e,this._unit=t):(typeof e=="string"&&Object.assign(this,w.parseDuration(e)),typeof e=="object"&&Object.assign(this,e))}get magnitude(){return this._magnitude}set magnitude(e){this._magnitude=typeof e=="number"&&e}get unit(){return this._unit}set unit(e){this._unit=w.parseTimeUnit(e)}get isValid(){return this._magnitude!=null&&!!w.normalizeUnit(this._unit)}get milliseconds(){return this.isValid?Math.round(w.asMilliseconds(this._magnitude,this._unit)):0}isEqual(e){return!!e&&this._magnitude!=null&&e._magnitude!=null&&this.milliseconds===e.milliseconds}toString(e,t=1){const r=this,n=e?"getShortNameOfUnit":"getLocalizedNameOfUnit",s=e?"":" ";return r.isValid?`${Ti.get("9."+"#".repeat(t)).format(r._magnitude)}${s}${w[n](r._unit,Math.abs(r._magnitude)!==1)}`:""}toJSON(){return this.toString()}valueOf(){return this.milliseconds}add(e){return new pp({unit:this.unit,magnitude:w.as(this.unit,this.milliseconds+new pp({magnitude:e.magnitude,unit:e.unit||this.unit}).milliseconds)})}diff(e){return new pp({unit:this.unit,magnitude:w.as(this.unit,this.milliseconds-e.milliseconds)})}};Le._$name="Duration";var _A=(i,e)=>i==null?void 0:i[e],PA=/^is(this|next|last)(week|month|year)$/i,AA=["isToday","isTomorrow","isYesterday","isThisWeek","isNextWeek","isLastWeek","isThisMonth","isNextMonth","isLastMonth","isThisYear","isNextYear","isLastYear","isYearToDate"],Gw=class vp extends $.mixin(Ud){static get defaultConfig(){return{value:null,operator:null,filterBy:null,convert:null,caseSensitive:!0,id:null,type:null,internal:null,disabled:!1}}static get configurable(){return{property:null}}construct(e){typeof e=="function"&&(e={filterBy:e}),e.type?e.type==="date"&&e.value!=null&&!Array.isArray(e.value)?e.value=new Date(e.value):e.type==="duration"&&e.value!=null&&!Array.isArray(e.value)&&(e.value=new Le(e.value)):w.isDate(e.value)||Array.isArray(e.value)&&e.value.every(w.isDate)?e.type="date":e.value instanceof Le&&(e.type="duration"),super.construct(e)}get id(){return this._id||(this.internal?this._id=vp.generateId(`b-internal-${this.property}-filter-`):this._id=this.property&&`${this.property}-${this.operator}`||vp.generateId("b-filter-")),this._id}set id(e){this._id=e}onChange(e){var t;const r=this;!r.isConfiguring&&((t=r.owner)!=null&&t.onFilterChanged)&&!r.owner.isConfiguring&&r.owner.onFilterChanged(r,e)}get filterBy(){return this._filterBy||this.defaultFilterBy}set filterBy(e){this._filterBy=e}defaultFilterBy(e){const t=this;let r;return e.isModel?r=e.getValue(t.property):t._propertyItems.length>1?r=t._propertyItems.reduce(_A,e):r=e[t.property],t[t.operator](t.convert(r))}updateProperty(e){this._propertyItems=e.split("."),this.onChange("property")}set value(e){const t=this;t._value=e,Array.isArray(e)&&({date:1,duration:1}[t.type]||e.length>0&&typeof e[0]=="string")?t._filterValue=e.map(r=>t.convert(r)):!t.caseSensitive&&Array.isArray(e)&&e.length>0&&typeof e[0]=="string"?t._filterValue=e.map(r=>r==null?void 0:r.toLowerCase()):!t.caseSensitive&&typeof e=="string"?t._filterValue=e.toLowerCase():t._filterValue=t.convert(e),t.onChange("value")}get value(){return this._value}get filterValue(){return this._filterValue}set operator(e){this._operator=e,this.onChange("operator")}get operator(){const e=this;return e._operator?e._operator:Array.isArray(e.filterValue)?"isIncludedIn":typeof e.filterValue=="string"?"*":"="}convert(e){var t;return this.operator!=="sameTime"&&!(typeof this.filterValue=="string"&&e instanceof Date)&&(this.operator==="sameDay"&&(e=w.clearTime(e)),e=(t=e==null?void 0:e.valueOf())!=null?t:e),e=!this.caseSensitive&&typeof e=="string"?e.toLowerCase():e,e}filter(e){return this.filterBy(e)}startsWith(e){return String(e).startsWith(this.filterValue)}endsWith(e){return String(e).endsWith(this.filterValue)}isIncludedIn(e){return this.filterValue.length===0||this.filterValue.includes(e)}isNotIncludedIn(e){return!this.isIncludedIn(e)}includes(e){return this.filterValue.length===0||String(e).includes(this.filterValue)}doesNotInclude(e){return!this.includes(e)}sameTime(e){return w.isSameTime(e,this.filterValue)}sameDay(e){return e===this.filterValue}"="(e){return T.isEqual(e,this.filterValue)}"!="(e){return!T.isEqual(e,this.filterValue)}">"(e){return T.isMoreThan(e,this.filterValue)}">="(e){return T.isMoreThan(e,this.filterValue)||T.isEqual(e,this.filterValue)}"<"(e){return T.isLessThan(e,this.filterValue)}"<="(e){return T.isLessThan(e,this.filterValue)||T.isEqual(e,this.filterValue)}"*"(e){return T.isPartial(e,this.filterValue)}between(e){const[t,r]=this._filterValue;return(T.isMoreThan(e,t)||T.isEqual(e,t))&&(T.isLessThan(e,r)||T.isEqual(e,r))}notBetween(e){return!this.between(e)}empty(e){return e==null||String(e).length===0}notEmpty(e){return!this.empty(e)}isToday(e){return this.between(e)}isTomorrow(e){return this.between(e)}isYesterday(e){return this.between(e)}isThisWeek(e){return this.between(e)}isNextWeek(e){return this.between(e)}isLastWeek(e){return this.between(e)}isThisMonth(e){return this.between(e)}isNextMonth(e){return this.between(e)}isLastMonth(e){return this.between(e)}isThisYear(e){return this.between(e)}isNextYear(e){return this.between(e)}isLastYear(e){return this.between(e)}isYearToDate(e){return this.between(e)}isTrue(e){return e===!0}isFalse(e){return e===!1}setRelativeDateValues(){this._filterValue=vp.getRelativeDateRange(this._operator).map(e=>e.valueOf())}get isNoOp(){var e;return(this.operator==="includes"||this.operator==="isIncludedIn")&&((e=this.filterValue)==null?void 0:e.length)===0}static getRelativeDateRange(e,t=new Date){let r,n,s,a,o,l,d;switch(e){case"isYearToDate":return[w.floor(t,"1 year"),t];case"isToday":return r=w.floor(t,"1 day"),[r,w.add(r,1,"day")];case"isYesterday":return r=w.floor(t,"1 day"),[w.add(r,-1,"day"),r];case"isTomorrow":return n=w.getStartOfNextDay(t),[n,w.add(n,1,"day")];case"isThisWeek":case"isNextWeek":case"isLastWeek":case"isThisMonth":case"isNextMonth":case"isLastMonth":case"isThisYear":case"isNextYear":case"isLastYear":if(s=e.toLowerCase().match(PA),!s)throw new Error(`Unrecognized relative date expression: ${e}`);return[,l,d]=s,a=`1 ${d}`,o=w.floor(t,a),l==="next"?o=w.add(o,1,d):l==="last"&&(o=w.add(o,-1,d)),[o,w.add(o,1,d)]}}static generateFiltersFunction(e){if(!e||!e.length&&!e.count)return Se.returnTrue;for(const t of e)t.type==="date"&&AA.includes(t._operator)&&t.setRelativeDateValues();return function(t){let r=!0;for(const n of e)if(n.disabled||(r=n.filter(t)),!r)break;return r}}};v(Gw,"$name","CollectionFilter");var ft=Gw;ft._$name="CollectionFilter";var bv=T.getPathDefault(globalThis,"bryntum.idCounts",Object.create(null)),Mi=class{static generateId(i="generatedId"){return i+(bv[i]=(bv[i]||0)+1)}static reset(i){bv[i]=0}};Mi._$name="IdHelper";var Qd=class extends ${static get defaultConfig(){return{property:null,direction:"ASC",sortFn:null,convert:null,id:null,useLocaleSort:null}}construct(i){typeof i=="function"&&(i={sortFn:i}),super.construct(i)}get id(){return this._id||(this._id=this.property||Mi.generateId("b-sorter"))}set id(i){this._id=i}set sortFn(i){this._sortFn=i}get sortFn(){return this._sortFn?this._sortFn:this.defaultSortFn}defaultSortFn(i,e){const t=this,{convert:r,property:n,useLocaleSort:s}=t,a=t.direction.toLowerCase()==="desc"?-1:1;if(i=i[n],e=e[n],r&&(i=r(i),e=r(e)),s&&i!=null&&e!=null&&typeof i=="string"){if(s===!0)return String(i).localeCompare(e);if(typeof s=="string")return String(i).localeCompare(e,s);if(typeof s=="object")return String(i).localeCompare(e,s.locale,s)}return(i>e?1:i<e?-1:0)*a}static generateSortFunction(i,e){const t=i.isCollection?i.values:i,r=t.length;return(n,s)=>{let a,o;for(o=0;o<r;++o)if(a=t[o].sortFn(n,s),a)return a;return e?e(n,s):0}}};Qd._$name="CollectionSorter";var FA=()=>0,kA=(i,e)=>e-i,Cv=Symbol("filteredIndicesProperty"),Wa=Object.freeze([]),LA=Object.freeze({action:"sort",added:Wa,removed:Wa,replaced:Wa}),OA=Object.freeze({action:"filter",added:Wa,removed:Wa,replaced:Wa}),us={string:1,number:1};function Yw(i,e,t,r){if(e.unique!==!1)e.set(t,i),r&&e.count++;else{let n=e.get(t);n||(n=new Set,e.set(t,n)),n.add(i)}}function $A(i,e,t){e.unique!==!1?e.delete(t):e.has(t)&&(e.get(t).delete(i),e.get(t).size||e.delete(t))}function qw(i,e,t,r,n=!1){for(let s=0;s<i.length;s++){const a=i[s];if(a)for(let o=0;o<r;o++){const l=t[o],d=a[l],c=e[l];d!==void 0&&Yw(a,c,d,!n&&c.onDuplicate)}}}var Ii=class YS extends $.mixin(Ve){constructor(){super(...arguments),v(this,"_sortFunction",null),v(this,"_addedValues",null)}static get configurable(){return{idProperty:"id",extraKeys:null,autoFilter:!0,autoSort:!0,sorters:{$config:["lazy"],value:[]}}}get isCollection(){return!0}construct(e){this.generation=0,this._values=[],super.construct(e)}doDestroy(){var e;super.doDestroy();const t=this;t._values.length=0,t.isFiltered&&(t._filteredValues.length=0,t.filters.destroy()),(e=t._sorters)==null||e.destroy()}clear(){const e=this,t=e._values.slice();e.totalCount&&(e._values.length=0,e._filteredValues&&(e._filteredValues.length=0),e._indicesInvalid=!0,e.generation++,e.trigger("change",{action:"clear",removed:t}))}equals(e,t){if(e.isCollection&&(e=e.values),e.length===this.count){let{values:r}=this;return t&&(e=e.map(t),r=r.map(t)),H.delta(e,r).inBoth.length===this.count}return!1}replaceValues({values:e,filteredValues:t,silent:r=!1,isNewDataset:n=!1}){const s=this;let a,o;s.isFiltered&&!n?(!!t?e&&(a=s._values,s._values=e.slice()):(t=e.slice(),e=null),o=s._filteredValues,s._filteredValues=t.slice()):(a=s._values,s._values=e.slice(),t=null,s.isFiltered&&n&&s.autoFilter?(s._filterFunction=null,s._filteredValues=s._values.filter(s.filterFunction)):s._filteredValues&&(s._filteredValues.length=0)),s._indicesInvalid=!0,s._addedValues=void 0,s.generation++,r||s.trigger("change",{action:"replaceValues",replacedValues:a,replacedFilteredValues:o,values:e,filteredValues:t})}set values(e){this.invalidateIndices(),this.splice(0,this._values.length,e)}get values(){return this.isFiltered?this._filteredValues:this._values}get filteredValues(){return this._filteredValues}[Symbol.iterator](){return this.values[Symbol.iterator]()}forEach(e,t=!1){(this.isFiltered&&!t?this._filteredValues:this._values).forEach(e)}map(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).map(e)}reduce(e,t=!1,r=[]){return(this.isFiltered&&!t?this._filteredValues:this._values).reduce(e,r)}find(e,t=!1){return(this.isFiltered&&!t?this._filteredValues:this._values).find(e)}get first(){return this.values[0]}get last(){return this.values[this.count-1]}get allValues(){return this._values}get addedValues(){return this._addedValues}match(e,t=!0){const r=this,{_values:n}=r,s=[];return r.forEach(a=>{const o=e.get(a.id,!0);if(o){const l=r.indexOf(a,!0),d=n[l];n[l]=o,r.removeFromIndices(d),r.addToIndices(o)}else t&&s.push(a)}),s.length&&r.remove(s),r.isFiltered&&(r._filteredValues=r._values.filter(r.filterFunction)),s}add(...e){e.length===1?this.splice(this._values.length,null,...e):this.splice(this._values.length,null,e)}remove(...e){e.length===1?this.splice(0,...e):this.splice(0,e)}move(e,t){for(e=H.asArray(e);e.length&&e[0]===t;)e.shift();if(!e.length)return;const r=this,{_values:n}=r,s=r.indexOf(e[0],!0);if(e.length===1&&n[s+1]===t)return;r.suspendEvents(),r.remove(e),r.resumeEvents();const a=t?r.indexOf(t,!0):n.length;if(a===-1)throw new Error("Collection move beforeItem parameter must be present in Collection");return n.splice(a,0,...e),r._indicesInvalid=1,r.trigger("change",{action:"move",items:e,from:s,to:a}),a}splice(e=0,t,...r){const n=this,s=n.idProperty,a=n._values,o={},l=[],d=[],c=n.totalCount;let u,h;if((r==null?void 0:r.length)===1&&Array.isArray(r[0])&&(r=r[0]),n.trigger("beforeSplice",{index:e,toRemove:t,toAdd:r})!==!1){if(r)if(c&&r.length){const f=n.indices[s];u=[];for(let g=0;g<r.length;g++){const m=r[g],p=m[s],y=f.get(p),b=y?a.indexOf(y):-1;o[p]=!0,b!==-1?a[b]!==m&&(d.push([a[b],m]),a[b]=m):u.push(m)}}else u=r;if(t){if(typeof t=="number"){t=Math.min(t,a.length-e);for(let f=e;t;--t){const g=a[f][s];o[g]?(e++,f++):(l.push(a[f]),a.splice(f,1),h=!0)}}else{let f=u.length===0,g;t=H.asArray(t);const m=t.reduce((p,y)=>{const b=typeof y=="number",C=b?y:n.indexOf(y,!0);return f&&(g!=null&&C!==g+1||b)&&(f=!1),C>=0&&C<c&&p.push(C),g=C,p},[]).sort(kA);if(f)m.length&&(l.push.apply(l,t),a.splice(m[m.length-1],m.length),h=!0);else for(let p=0;p<m.length;p++){const y=m[p];if(y!==-1){const b=a[y][s];o[b]||(l.unshift(a[y]),a.splice(y,1),h=!0)}}}l.length&&!n._indicesInvalid&&l.forEach(n.removeFromIndices,n)}if(u.length){a.splice(Math.min(e,a.length),0,...u),h=!0,n._indicesInvalid||u.forEach(n.addToIndices,n),n._addedValues||(n._addedValues=new Set);for(const f of u)n._addedValues.add(f)}if(l.length&&n._addedValues)for(const f of l)n._addedValues.delete(f);d.length&&!n._indicesInvalid&&d.forEach(f=>{n.removeFromIndices(f[0]),n.addToIndices(f[1])}),h||d.length?(n.isSorted?n.onSortersChanged():n.isFiltered&&(n.autoFilter?n.onFiltersChanged({action:"splice",oldCount:1}):n._filteredValues.splice(Math.min(e,n._filteredValues.length),0,...u)),n.generation++,n.trigger("change",{action:"splice",removed:l,added:u,replaced:d,oldCount:c})):n.trigger("noChange",{index:e,toRemove:t,toAdd:r})}}changeId(e,t){const r=this,{idProperty:n}=r,s=us[typeof e]?e:e[n],a=r.get(s);if(a){const o=r.get(t);if(o&&a!==o)throw new Error(`Attempt to set item ${s} to already existing member's id ${t}`);r.removeIndexEntry(e,n,s),r.addIndexEntry(e,n,t),a[n]=t}}get(e,t=!1){return this.getBy(this.idProperty,e,t)}getAt(e,t=!1){return this.isFiltered&&!t?this._filteredValues[e]:this._values[e]}getBy(e,t,r=!1){return this.findItem(e,t,this.isFiltered&&r)}get count(){return this.values.length}get totalCount(){return this._values.length}updateIdProperty(e){this.addIndex({property:e,unique:!0})}changeSorters(e){return new YS({values:H.asArray(e),internalListeners:{change:"onSortersChanged",thisObj:this}})}addSorter(e){const t=e instanceof Qd?e:new Qd(e);return this.sorters.add(t),t}get isSorted(){var e;return!!((e=this._sorters)!=null&&e.count)}onSortersChanged(){const e=this;e._sortFunction=null,e._addedValues=null,e._values.sort(e.sortFunction),e.trigger("change",LA)}get sortFunction(){return this._sortFunction||(this.isSorted?this._sortFunction=Qd.generateSortFunction(this.sorters.values):this._sortFunction=FA),this._sortFunction}get filters(){return this._filters||(this._filters=new YS({internalListeners:{change:"onFiltersChanged",thisObj:this}})),this._filters}addFilter(e){const t=e instanceof ft?e:new ft(e);return this.filters.add(t),t}removeFilter(e){const{filters:t}=this;e.isCollectionFilter||(e=t.get(e)),t.remove(e)}clearFilters(){this.filters.clear()}get isFiltered(){return!!(this._filters&&this._filters.count)}onFiltersChanged({action:e,removed:t,oldCount:r}){const n=this,s=r||e==="clear"&&t.length?n._filteredValues:n._values;n._filterFunction=null,n._filteredValues=n._values.filter(n.filterFunction),n._indicesInvalid=!0;const{toAdd:a,toRemove:o}=H.delta(n._filteredValues,s,!0);n.trigger("change",{...OA,added:a,removed:o})}get filterFunction(){return this._filterFunction||(this.isFiltered?this._filterFunction=ft.generateFiltersFunction(this.filters.values):this._filterFunction=Se.returnTrue),this._filterFunction}changeExtraKeys(e){return H.asArray(e).map(r=>typeof r=="string"?{property:r,unique:!0}:r)}updateExtraKeys(e){for(let t=0;t<e.length;t++)this.addIndex(e[t])}addIndex(e){const t=this;e&&((t._indices||(t._indices={}))[e.property]=new Map,Object.assign(t._indices[e.property],e),t.invalidateIndices(),e.dependentOn&&(t.hasCompositeIndex=!0))}findIndex(e,t,r=!1){const n=this.findItem(e,t,r);return n?(this.isFiltered&&!r?this._filteredValues:this._values).indexOf(n):-1}findItem(e,t,r=!1){var n;const s=this,{isFiltered:a}=s,o=a&&!r?s.indices[Cv][e]:s.indices[e];if(o){const l=(n=o.get(t))!=null?n:typeof t=="string"&&t.length&&!isNaN(t)&&o.get(Number(t))||null;if(l!=null)return l}else{const l=a&&!r?s._filteredValues:s._values,d=l.length;for(let c=0;c<d;c++){const u=l[c];if(u[e]==t)return u}}return null}removeIndex(e){delete this._indices[e],this.hasCompositeIndex=Object.values(this.indices).some(t=>t.dependentOn)}indexOf(e,t=!1){return this.findIndex(this.idProperty,us[typeof e]?e:e[this.idProperty],t)}includes(e,t=!1){return Array.isArray(e)?e.some(r=>this.includes(r)):!!this.findItem(this.idProperty,us[typeof e]?e:e[this.idProperty],t)}get indices(){return this._indicesInvalid&&this.rebuildIndices(),this._indices}invalidateIndices(){this._indicesInvalid=!0}rebuildIndices(){const e=this,t=e.isFiltered,r=e._indices||(e._indices={}),n=Object.keys(r),s=n.length,a=e._values;let o=!1,l;t&&(l=r[Cv]={});for(let d=0;d<s;d++){const c=r[n[d]];if(c.clear(),c.onDuplicate&&(c.count=0,o=!0),t){let u=l[n[d]];u?u.clear():(u=l[n[d]]=new Map,u.unique=c.unique)}}if(qw(a,r,n,s),o)for(let d=0;d<s;d++){const c=r[n[d]];if(c.onDuplicate&&c.count>c.size){const u=new Set;for(let h=0;h<a.length;h++){const f=a[h],g=f[n[d]];u.has(g)&&c.onDuplicate(f,g,c),u.add(g)}}}t&&qw(e._filteredValues,l,n,s,!0),e._indicesInvalid=!1}getIndices(e){const t=[this.indices[e]];return this.isFiltered&&t.push(this.indices[Cv][e]),t}addToIndices(e){Object.keys(this.indices).forEach(t=>{this.addIndexEntry(e,t,e[t])})}removeFromIndices(e){Object.keys(this.indices).forEach(t=>{this.removeIndexEntry(e,t,e[t])})}removeIndexEntry(e,t,r){this.getIndices(t).forEach(n=>$A(e,n,r))}addIndexEntry(e,t,r){this.getIndices(t).forEach(n=>Yw(e,n,r))}onItemMutation(e,t){const r=this;!r._indicesInvalid&&Object.keys(r.indices).length>1&&Object.keys(t).forEach(n=>{var s;if(r.indices[n]){const{value:o,oldValue:l}=t[n];r.removeIndexEntry(e,n,l),r.addIndexEntry(e,n,o)}if(r.hasCompositeIndex){const o=Object.values(r.indices).find(l=>{var d;return(d=l.dependentOn)==null?void 0:d[n]});if(o){const l={};for(const c in o.dependentOn)l[c]=((s=t[c])==null?void 0:s.oldValue)||e[c];const d=e.buildIndexKey(l);r.removeIndexEntry(e,o.property,d),r.addIndexEntry(e,o.property,e[o.property])}}})}};Ii._$name="Collection";var Kw=new WeakMap,Jd=i=>{if(i&&typeof i=="object"){let e=Kw.get(i);e===void 0&&(e=Symbol("bscik"),Kw.set(i,e)),i=e}return i},ec=class{constructor(i){const e=this;e.generation=0,e.items=new Set,e.idMap={},e.idProperty="id",i&&(i.idProperty&&(e.idProperty=i.idProperty),i.values&&(e.values=i.values))}get(i){return this.idMap[Jd(i)]}get count(){return this.items.size}add(...i){i.length===1&&Array.isArray(i[0])&&(i=i[0]);const e=this,{items:t,idMap:r,idProperty:n}=e,s=i.length;for(let a=0;a<s;a++){const o=i[a],l=us[typeof o]?o:Jd(o[n]),d=r[l];d==null?(r[l]=o,t.add(o),e.generation++):d!==o&&(r[l]=o,t.delete(d),t.add(o))}}at(i){let e,t;i<0&&(i+=this.count);for(e of this.items)if(!i--){t=e;break}return t}remove(i){i=H.asArray(i);const{items:e,idMap:t,idProperty:r}=this,n=i.length;for(let s=0;s<n;s++){const a=i[s],o=us[typeof a]?a:Jd(a[r]),l=t[o];l!=null&&(e.delete(l),delete t[o],this.generation++)}}clear(){this.items.clear(),this.idMap={},this.generation++}countOf(i){let e=0,t;for(t of this.items)i(t)&&++e;return e}changeId(i,e){const t=this,{idMap:r,idProperty:n}=t,s=us[typeof i]?i:Jd(i[n]),a=t.get(s);if(a){const o=t.get(e);if(o&&a!==o)throw new Error(`Attempt to set item ${s} to already existing member's id ${e}`);a[n]=e,delete r[s],r[e]=a}}filter(i,e){const{items:t}=this,r=[];let n=0;return t.forEach(s=>{i.call(e,s,n++,t)&&r.push(s)}),r}includes(i){const e=us[typeof i]?i:Jd(i[this.idProperty]);return!!this.idMap[e]}map(i,e){const{items:t}=this,r=new Array(t.size);let n=0;return t.forEach(s=>{r[n]=i.call(e,s,n++,t)}),r}forEach(i,e){return this.items.forEach(i,e)}find(i,e=0){let t,r;e<0&&(e+=this.countOf(i));for(t of this.items)if(i(t)&&!e--){r=t;break}return r}[Symbol.iterator](){return this.items[Symbol.iterator]()}indexOf(i,e){let t=-1,r;for(r of this.items)if((!e||e(r))&&(++t,r===i))return t;return-1}get values(){return[...this.items]}set values(i){i=H.asArray(i),this.clear(),this.add.apply(this,i),this.generation++}get first(){for(const i of this.items)return i;return null}get last(){let i=null;for(const e of this.items)i=e;return i}sort(i){this.values=this.values.sort(i)}some(i,e){return this.values.some(i,e)}};ec._$name="Bag";var Ff=class extends ec{add(...i){return i.length===1&&Array.isArray(i[0])&&(i=i[0]),super.add(...i.filter(e=>e.isPersistable))}};Ff._$name="StoreBag";var Xw=i=>{var e;return e=class extends(i||$){static get defaultConfig(){return{autoCommit:!1}}static get properties(){return{isRemoving:!1,suspendCount:0}}remove(t,r=!1){const n=this,{storage:s}=n;if(t=H.asArray(t).reduce((a,o)=>(o=n.getById(o),o&&a.push(o),a),[]),t.length===0)return t;if(!n.tree&&!r&&n.trigger("beforeRemove",{records:t})===!1)return[];if(n.isRemoving=!0,n.isGrouped){const a=s.count,o=[],l=new Set;for(const d of t){const{groupParent:c}=d.instanceMeta(n);c.meta.collapsed&&o.push(d),H.remove(c.groupChildren,d),H.remove(c.unfilteredGroupChildren,d),c.meta.childCount--,l.add(c)}for(const d of l)d.groupChildren.length>0&&n.onModelChange(d,{},{});o.length&&s.trigger("change",{action:"splice",removed:o,added:[],replaced:[],oldCount:a})}else if(n.tree){const a=[],o=t.length>1,l=t[0],d=o?void 0:s.indexOf(l),c=t.reduce((h,f)=>{const{parent:g}=f;return g&&(h[g.id]||(h[g.id]=[g,[]]),h[g.id][1].push(f)),h},{}),u=Array.from(Object.values(c));if(!r&&n.trigger("beforeRemove",{records:t,isMove:!1,parent:o?void 0:l.parent})===!1)return n.isRemoving=!1,[];n.suspendAutoCommit(),u.sort((h,f)=>f[0].childLevel-h[0].childLevel);for(const[h,f]of u)a.push(...h.removeChild(f,!1,!0));return r||(n.trigger("remove",{parent:o?void 0:l.parent,index:d,isChild:!0,allRecords:a,isMove:!1,records:t}),n.trigger("change",{action:"remove",records:t})),n.resumeAutoCommit(),n.isRemoving=!1,t}if(t.length===0)return n.isRemoving=!1,t;for(const a of t)a.beforeRemove(t);return r&&n.suspendEvents(),s.remove(t),r&&n.resumeEvents(),n.autoCommit&&n.doAutoCommit(),n.isRemoving=!1,t}clear(t=!1){var r,n;const s=this,{storage:a}=s;if(s.storage.totalCount||(n=(r=s.rootNode)==null?void 0:r.unfilteredChildren)!=null&&n.length){if(!t&&s.trigger("beforeRemove",{records:a.allValues,removingAll:!0})===!1)return null;if(s.rootNode)if(s.isChained){const o=s.getAllDataRecords();for(let l=o.length-1,d;l>=0;l--)d=o[l],d&&!d.isDestroyed&&d.unjoinStore(s)}else s.rootNode.clearChildren(t);else if(t){const o=s.registeredRecords;for(let l=o.length-1,d;l>=0;l--)d=o[l],d&&!d.isDestroyed&&d.unjoinStore(s)}t&&(s.removed.clear(),a.suspendEvents()),a.clear(),t&&a.resumeEvents(),s.added.clear(),s.modified.clear()}}removeAll(t=!1){const r=this,n=r.storage;let s;if(r.isRemoving=!0,t){n.suspendEvents();const a=r.registeredRecords;for(let o=a.length-1,l;o>=0;o--)l=a[o],l&&!l.isDestroyed&&!l.isRoot&&l.unjoinStore(r)}return r.tree?s=r.rootNode.clear()!==!1:s=r.clear()!==null,t&&n.resumeEvents(),r.isRemoving=!1,s}add(t,r=!1,n={}){const s=this,{storage:a}=s;if(t=H.asArray(t),!(t!=null&&t.length))return;if(s.tree=s.tree||!!(s.autoTree&&t[0].children),s.tree){const l=new Map,d=s.modelClass.getFieldDataSource("parentIndex"),{parentIdField:c}=s.modelClass,u=[];return t.forEach(h=>{const f=h[c];l.has(f)||l.set(f,{append:[],insert:[]});const g=l.get(f);!h.isModel&&d in h?g.insert.push(h):g.append.push(h)}),l.forEach(({append:h,insert:f},g)=>{const m=g==null?s.rootNode:s.getById(g);if(!m)throw new Error(`Parent node with id ${g} not found, cannot add children.`);if(h.length&&u.push(...m.appendChild(h,r,n)),f.length)for(const p of f)"orderedParentIndex"in p&&("orderedParentIndex"in n&&T.isObject(n.orderedParentIndex)?n.orderedParentIndex.index=p.orderedParentIndex:n.orderedParentIndex=p.orderedParentIndex),u.push(m.insertChild(p,p[d],r,n))}),s.isFiltered&&s.reapplyFilterOnAdd&&s.filter({silent:!0}),s.reapplySortersOnAdd&&!s.isSyncingDataOnLoad&&s.sort(),u}if(!r&&s.trigger("beforeAdd",{records:t})===!1)return null;if(s.tree=s.tree||!!(s.autoTree&&t[0].children),s.tree)return s.rootNode.appendChild(t);const o=s.processRecords(t);return r&&s.suspendEvents(),s.addingClean=n.clean,a.add(o),s.addingClean=!1,r&&s.resumeEvents(),s.autoCommit&&s.doAutoCommit(),o}cloneImmutable(t){return this.useRawData.enabled&&!t[0].isModel&&!Object.isExtensible(t[0])&&(t=T.clone(t)),t}processRecords(t,r){return this.cloneImmutable(t).map(n=>{const s=this.processRecord(n.isModel?n:this.createRecord(n));return r==null||r.call(this,s),s})}insert(t,r,n=!1){var s;const a=this,o=a.storage,l=o.getAt(t),d=o.values,c=[];if(r=H.asArray(r),a.tree){const m=a.rootNode;return m.insertChild(r,(s=m.children)==null?void 0:s[t],n)}if(!n&&a.trigger("beforeAdd",{records:r})===!1)return null;let u,h,f;if(d[h=t]===r[0]||d[h=t-1]===r[0])for(u=!0,f=0;u&&f<r.length;f++)r[f]!==d[h+f]&&(u=!1);if(u)return null;const g=a.processRecords(r,m=>{const p=o.indexOf(m);m.children&&m.children.length&&a.autoTree&&(a.tree=!0),p>-1&&(p<t&&l&&t--,c.push(p)),m.meta.previousIndex=p});return a.suspendEvents(),a.storage.remove(c),a.resumeEvents(),n&&a.suspendEvents(),o.splice(t,0,...g),n&&a.resumeEvents(),a.autoCommit&&a.doAutoCommit(),g}move(t,r){this.isTree?r.parent.insertChild(t,r):this.storage.move(t,r)}acceptChanges(){const t=this;t.added.forEach(r=>r.internalClearChanges(!0,!1)),t.modified.forEach(r=>r.internalClearChanges(!0,!1)),t.added.clear(),t.modified.clear(),t.removed.clear()}commit(t=!1){const{changes:r}=this;return!t&&this.trigger("beforeCommit",{changes:r})===!1?!1:(this.acceptChanges(),t||this.trigger("commit",{changes:r}),r)}revertChanges(){const t=this,{changes:r}=t;if(r){const n={action:"clearchanges",changes:r};t.add(t.removed.values,!0),t.remove(t.added.values,!0),t.modified.forEach(s=>s.revertChanges(!0)),t.added.clear(),t.modified.clear(),t.removed.clear(),t.trigger("change",n),t.trigger("refresh",n)}}get changes(){const t=this,r=t.modified.values.filter(n=>n.rawModifications);return t.added.count||r.length||t.removed.count?{added:t.added.values.slice(),modified:r,removed:t.removed.values.slice()}:null}get hasChanges(){return!!(this.added.count||this.removed.count||this.modified.values.some(t=>t.rawModifications))}get autoCommit(){return this._autoCommit}set autoCommit(t){this._autoCommit=t,t&&this.hasChanges&&this.commit()}suspendAutoCommit(){this.suspendCount++}resumeAutoCommit(t=!0){this.suspendCount--,this.autoCommit&&t&&this.doAutoCommit()}doAutoCommit(){this.suspendCount<=0&&this.commit()}},v(e,"$name","StoreCRUD"),e},Zw=i=>{var e;return e=class extends(i||$){static get configurable(){return{applyChangesetFilterSortTarget:"changes"}}applyChangesFromStore(t){const r=this,{changes:n}=t;n&&(n.added&&r.add(n.added),n.removed&&r.remove(n.removed.map(s=>s.id)),n.modified&&n.modified.forEach(s=>{const a=r.getById(s.id);a==null||a.set(s.modifications)}))}applyChangeset(t,r=null,n="$PhantomId",s=!0,a=!1){var o,l,d,c,u;const h=this,f=(o=r==null?void 0:r(t,h))!=null?o:t,g=f.$input||f,{added:m,updated:p,modified:y,removed:b}=g,C=(l=p!=null?p:y)!=null?l:[],D=h.modelClass.getFieldDataSource("id"),S=h.modelClass.getFieldDataSource("parentId"),x=a?new Map:null,R=h.tree,M=[],I=[],_=new Set;let P=!1,A=[];if(h.trigger("startApplyChangeset"),h._groupVisibleRecordIds=[],h.isGrouped&&h.forEach(L=>{h._groupVisibleRecordIds.push(L.id)}),(m==null?void 0:m.length)>0){const L=[],F=[];for(const G of m){const U=h.getById(G[n])||h.getById(T.getPath(G,D));U?(L.push(G),R&&_.add(U.parent)):h.removed.get(G[n])||h.removed.get(T.getPath(G,D))||F.push(G)}C.unshift.apply(C,L);const N=h.reapplySortersOnAdd;h.reapplySortersOnAdd=!1;const Y=(d=h.add(F,!1,{orderedParentIndex:{skip:!0},clean:s}))!=null?d:[];if(M.push(...Y),h.reapplySortersOnAdd=N,R)for(const G of Y){const{parent:U}=G;if(U.isRoot){P=!0,A=[U];break}!U.isRoot&&A.every(Z=>!Z.contains(U))&&A.push(U),"orderedParentIndex"in G.originalData&&_.add(U)}for(const G of Y)x==null||x.set(G.id,G.data),G.internalClearChanges();R&&_.forEach(G=>{G.updateChildrenIndices(G.orderedChildren,"orderedParentIndex",!0)})}if((C==null?void 0:C.length)>0)for(const L of C){const F=L[n],N=T.getPath(L,D),Y=T.getPath(L,S),G=(c=h.getById(F))!=null?c:h.getById(N);if(G){const U=Y!=null?(u=h.getById(Y))==null?void 0:u.isLeaf:!1;this.filterTreeHierarchyChanges(_,G,L);const Z=G.applyChangeset(L,n,s);U&&h.toggleCollapse(G.parent,!1),R&&!P&&A.every(fe=>!fe.contains(G))&&(G.parent.isRoot?(P=!0,A=[G.parent]):A.push(G.parent)),x==null||x.set(N,Z),I.push(G)}}if((b==null?void 0:b.length)>0&&h.applyRemovals(b),h.applyChangesetFilterSortTarget==="changes"){const L=h.filterChangeset(M,I);A.push(...L)}if(h.afterChangesetApplied(A),R&&h.isSorted&&h.reapplySortersOnAdd&&(m!=null&&m.length||C!=null&&C.length)){const L=new Set;A.forEach(F=>{L.has(F)||(L.add(F),F.sortVisibleChildren(!1,h.sorterFn),F.sortUnfilteredChildren(!1,h.sorterFn))}),h.storage.replaceValues({values:h.collectDescendants(h.rootNode).visible,silent:!0}),h.afterPerformSort(!1)}return h._groupVisibleRecordIds=null,h.trigger("endApplyChangeset"),x}afterChangesetApplied(t){const r=new Set;t.forEach(n=>{r.has(n)||n.traverse(s=>{r.has(s)||(r.add(s),s.sortOrderedChildren(!1,!1),s.children&&s.updateChildrenIndices(s.children,"parentIndex",!0),s.unfilteredChildren&&s.updateChildrenIndices(s.unfilteredChildren,"unfilteredIndex",!0))})})}applyRemovals(t){const r=this,{removed:n}=r,s=r.modelClass.idField,a=[];for(const o of t){const l=T.getPath(o,s);if(n.includes(l)){const d=n.get(l);d.internalClearChanges(!1,!0,null),d.$isPhantom=!0,n.remove(l)}else a.push(l)}r.tree&&a.reduce((l,d)=>{var c;return r.getById(d)&&l.add((c=r.getById(d).parentNode)!=null?c:r.rootNode),l},new Set).forEach(l=>l.sortOrderedChildren(!1,!1)),r.remove(a);for(const o of a)n.remove(o)}filterChangeset(t,r){const n=this,{isFiltered:s,tree:a,isGrouped:o,filtersFunction:l}=n,d=n.isSorted?n.createSorterFn(n.sorters):void 0,{allValues:c,addedValues:u,isSorted:h}=n.storage,f=d!=null||h?d!=null?d:n.storage.sortFunction:null,g=new Set;if(!s)return[];let m=!1,p;if(o&&(p=n.groupers,n.clearGroupers(!0)),a){const b=new Set(r.filter(l));for(const D of t.filter(l))b.add(D);b.forEach(D=>D.bubble(S=>b.add(S))),b.delete(n.rootNode);const C=H.groupByIndexed(Array.from(b).filter(D=>{var S,x;return!((x=(S=D.parent)==null?void 0:S.children)!=null&&x.includes(D))}),D=>D.parent);for(const[D,S]of C)D.unfilteredChildren&&(D.children.push(...S),g.add(D),n.traverseFilter(D,!1,S))}else if(f&&!o){const{filteredValues:b}=n.storage,C=u?b.findLastIndex(x=>!u.has(x))+1:b.length,D=b.slice(0,C),S=new Set(r.filter(l));for(const x of b)S.has(x)&&S.delete(x);for(const x of S)D.push(x);D.sort(f),b.splice(0,C,...D),m=!0}else{const b=r.filter(C=>l(C)&&!n.storage.includes(C));b.length>0&&(n.includeInSubset(c,n.storage.filteredValues,b),m=!0)}const y=new Set(t.filter(b=>!l(b)));if(y.size>0){if(a)for(const b of y)H.remove(b.parent.children,b),g.add(b.parent);else H.remove(n.storage.filteredValues,y);m=!0}return p&&(n.group(p[0],null,!1,!0,!0),m=!0),a&&g.size>0?n.storage.replaceValues({values:n.collectDescendants(n.rootNode).visible,silent:!0}):m&&(n._idMap=null,n.trigger("refresh")),[...g]}filterTreeHierarchyChanges(t,r,n){this.tree&&t.has(r.parent)&&(delete n.orderedParentIndex,delete n.parentIndex)}includeInSubset(t,r,n){const s=new Set(n);let a=0,o=0,l=s.size===0;for(;o<t.length&&!l;){const d=r[a];let c=t[o];for(;d!==c;)s.has(c)&&(r.splice(a,0,c),a++,s.delete(c),l=s.size===0),c=t[++o];s.has(d)&&s.delete(d),a<r.length&&a++}return r}},v(e,"$name","StoreChanges"),e},Qw=i=>{var e;return e=class extends(i||$){static get defaultConfig(){return{filters:null,reapplyFilterOnAdd:!1,reapplyFilterOnUpdate:!1}}set reapplyFilterOnAdd(t){this.storage.autoFilter=t}get reapplyFilterOnAdd(){return this.storage.autoFilter}set filters(t){const r=this,n=r.filters;if(n.clear(),r._filtersFunction=null,t){if(t.constructor.name==="Object")for(const s of Object.entries(t))s[0]==="filterBy"&&typeof s[1]=="function"?n.add(new ft({filterBy:s[1]})):n.add(new ft(s[1].constructor.name==="Object"?Object.assign({property:s[0]},s[1]):{property:s[0],value:s[1]}));else Array.isArray(t)?n.add(...t.map(s=>s instanceof ft?s:new ft(s))):t.isCollection?n.add(...t.values):n.add(new ft({filterBy:t}));n.forEach(s=>s.owner=r)}}get filters(){return this._filters||(this._filters=new Ii({extraKeys:["property"]}))}set filtersFunction(t){this._filtersFunction=t}get filtersFunction(){const t=this,{filters:r,isGrouped:n}=t;if(!t._filtersFunction)if(r.count){const s=ft.generateFiltersFunction(r);t._filtersFunction=a=>n&&a.isSpecialRow?a.groupChildren.some(s):s(a)}else t._filtersFunction=Se.returnTrue;return t._filtersFunction}get isFiltered(){return this.filters.values.some(t=>!t.disabled)}isFilteredOut(t){return this.isFiltered&&!this.filtersFunction(t)}traverseFilter(t,r=!0,n=void 0){const s=this,{filtersFunction:a}=s,o=!t.isRoot&&a(t),l=t.unfilteredChildren||t.children;return!l||!l.length?o:(t.unfilteredChildren||(t.unfilteredChildren=t.children.slice()),t.children=t.unfilteredChildren.filter(d=>r?s.traverseFilter(d,r):a(d)||(n==null?void 0:n.has(d))),s.isSorted&&t.children.sort(s.sorterFn),t.updateChildrenIndices(t.unfilteredChildren,"unfilteredIndex",!0),t.updateChildrenIndices(t.children,"parentIndex",!0),o||!!t.children.length)}traverseClearFilter(t){const r=this;t.unfilteredChildren&&(t.children=t.orderedChildren.slice(),t.unfilteredChildren=null),t.children&&(r.isSorted&&t.children.sort(r.sorterFn),t.children.forEach(n=>r.traverseClearFilter(n)),t.updateChildrenIndices(t.children,"parentIndex",!0))}get latestFilterField(){return this.filters.last?this.filters.last.property:null}addFilter(t,r=!1){const n=this;if(t=t instanceof ft?t:new ft(t),t.owner=n,n.filters.add(t),!r){if(n.remoteFilter)return n.filter().then(()=>t);n.filter()}return t}filter(t){const r=this;let n=!1,s;if(t){let o=typeof t;if(o==="object"&&("silent"in t||"replace"in t||t.filters)&&(n=t.silent,t.replace&&r.clearFilters(t.silent||t.filters.length!==0),s=t.internal,t=t.filters,o=typeof t),t){const l=r.isFiltered;if(r.isConfiguring=!0,Array.isArray(t))t.forEach(d=>r.addFilter(d,!0),r);else if(o==="function"){const d=new ft(t);d.internal=s,r.addFilter(d,!0)}else o==="string"?r.addFilter({property:t,value:arguments[1]},!0):r.addFilter(t,!0);if(r.isConfiguring=!1,!r.isFiltered&&!l)return null}}r.filtersFunction=null;const a=r.performFilter(n);return r._idMap=null,a}suspendFilterOnUpdate(){this.filterBatching++}resumeFilterOnUpdate(t){if(this.filterBatching--,this.filterBatching<0)throw new Error("No matching `startFilterBatching` call");this.filterBatching===0&&this.needsFiltering&&(this.needsFiltering=!1,this.performFilter(t))}performFilter(t){const r=this;if(r.filterBatching>0){r.needsFiltering=!0;return}const{storage:n,filters:s,rootNode:a}=r,o=r.count;t||r.trigger("beforeFilter",{filters:s});let l,d;if(r.tree){const c=n.values;r.isFiltered?r.traverseFilter(a):r.traverseClearFilter(a);const u=r.collectDescendants(a).visible;n.replaceValues({values:u,silent:!0});const h=H.delta(u,c,!0);l=h.toAdd,d=h.toRemove}else n.ion({change({removed:c,added:u}){d=c,l=u},once:!0}),r.isFiltered?(r.isGrouped&&r.includeCollapsed(),n.addFilter({id:"primary-filter",filterBy:r.filtersFunction}),r.isGrouped&&r.excludeCollapsed()):n.filters.clear();r.afterPerformFilter(t||r.isRemoteDataLoading?null:{action:"filter",filters:s,oldCount:o,added:l,removed:d,records:r.storage.values})}afterPerformFilter(t){this.resetRelationCache(),t&&this.triggerFilterEvent(t)}triggerFilterEvent(t){this.trigger("filter",t),this.remoteFilter||(this.trigger("refresh",t),this.trigger("change",t))}filterBy(t){return this.filter(t)}removeFilter(t,r=!1){var n,s;const a=this,o=t instanceof ft?t:(n=a.filters.get(t))!=null?n:a.filters.getBy("property",t);if(o){if((s=a._filters)==null||s.remove(o),a._filtersFunction=null,!r){if(a.remoteFilter)return a.filter().then(()=>o);a.filter()}return o}}clearFilters(t=!1){if(this.filters.remove(this.filters.values.filter(r=>!r.internal)),!t)return this.filter()}convertFilterToString(t){const r=this.filters.getBy("property",t);return r&&!r.filterBy?String(r):""}doDestroy(){var t;(t=this._filters)==null||t.destroy(),super.doDestroy()}},v(e,"$name","StoreFilter"),v(e,"properties",{filterBatching:0,needsFiltering:!1}),e},BA={add:1,replace:1},HA=({_groupValue:i},{_groupValue:e})=>i<e?-1:i>e?1:0,jA=(i,e)=>i[e<0?i.length+e:e],Jw=i=>{var e;return e=class extends(i||$){static get properties(){return{collapsedGroups:new Set}}construct(t){super.construct(t),this.ion({change:"onDataChanged",thisObj:this})}get GroupRow(){var t;return this._GroupRowClass||(this._GroupRowClass=(t=class extends this.modelClass{get isCollapsed(){return this.meta.collapsed}},v(t,"isSpecialRow",!0),v(t,"fields",[{name:"_groupValue"}]),t))}updateGroupers(t){this.setGroupers(t)}setGroupers(t,r=null){const n=this,{storage:s}=n;let a;return n._idMap=null,t!=null&&t.length?n._groupers=t.map(o=>n.createGrouper(o)):n.groupers&&(delete n._groupers,n.includeCollapsed(),s.replaceValues({values:n.removeHeadersAndFooters(s._values),filteredValues:s.isFiltered?n.removeHeadersAndFooters(s._filteredValues):null,silent:!0}),a=n.group(null,null,null,!1,r==null?void 0:r.silent)),a}createGrouper(t){if(!t||t.isGrouper)return t;typeof t=="string"&&(t={field:t});const{field:r}=t,n=r==null?void 0:r.indexOf("."),s=n>0,a=r==null?void 0:r.split("."),o=s?a[0]:r,l=s?jA(a,-1):r,d=s?r.slice(n+1):r;return{isGrouper:!0,...t,complexMapping:s,rootFieldName:o,leafFieldName:l,fieldPath:d}}get unfilteredGroupRecords(){var t;const r=this;if(r.isGrouped){const{generation:n}=r.storage;((t=r._unfilteredGroupRecords)==null?void 0:t.generation)!==n&&(r._unfilteredGroupRecords=r.storage.allValues.filter(s=>s.isSpecialRow),r._unfilteredGroupRecords.generation=n)}return r._unfilteredGroupRecords||[]}getGroupHeaderForRecord(t,r=!1){if(this.isGrouped)return t?t.meta.groupRowFor?t:t.instanceMeta(this).groupParent:this.groupRecords.last}includeCollapsed(){for(const t of this.collapsedGroups)this.expand(this.getById(t),!1)}excludeCollapsed(){for(const t of this.collapsedGroups)this.collapse(this.getById(t))}onDataChange({source:t,action:r,removed:n}){var s;const a=this,{groupers:o}=a;o&&(o.length?(r==="splice"&&(n!=null&&n.length)||r==="move")&&t.replaceValues({...a.prepareGroupRecords(),silent:!0}):t.replaceValues({values:a.removeHeadersAndFooters(t._values),filteredValues:t.isFiltered?a.removeHeadersAndFooters(t._filteredValues):null,silent:!0})),(s=super.onDataChange)==null||s.call(this,...arguments)}move(t,r){const n=this;let s;if(n.isGrouped&&!n.tree){let a=r;if(r!=null&&r.isSpecialRow&&(a=n.getPrev(r,!1,!1),!a))return;const o=n.getGroupHeaderForRecord(a),l=n.groupers[0].field,{reapplyFilterOnUpdate:d}=n,c=n.modelClass.getFieldDefinition(l).type==="array";let u=o.meta.groupRowFor;if(n.reapplyFilterOnUpdate=!1,n.beginBatch(),t.forEach(h=>{if(c){const f=h.get(l);if(f.includes(u))return;{const g=h.instanceMeta(this).groupParent,m=r.isGroupHeader?r:r.instanceMeta(this).groupParent;H.remove(f,g),u=f.slice(),u.push(m._groupValue),s=!0}}h.setValue(l,u)}),n.endBatch(),c&&!s)return;if(n.reapplyFilterOnUpdate=d,n.isFiltered&&(r!=null&&r.isSpecialRow)){const{unfilteredGroupRecords:h}=n,f=h.indexOf(o);r=h[f+1]}}super.move(t,r),s&&n.group(n.groupers[0])}collapse(t){return t&&!t.meta.collapsed?(this.excludeGroupRecords(t),t.meta.collapsed=!0,this.collapsedGroups.add(t.id),this.trigger("toggleGroup",{groupRecord:t,collapse:!0}),!0):!1}expand(t,r=!0){return t!=null&&t.meta.collapsed?(this.includeGroupRecords(t),t.meta.collapsed=!1,r&&this.collapsedGroups.delete(t.id),r&&this.trigger("toggleGroup",{groupRecord:t,collapse:!1}),!0):!1}removeHeadersAndFooters(t){return t.filter(r=>(r!=null&&r.unfilteredGroupChildren&&(r.groupChildren.length=r.unfilteredGroupChildren.length=r.meta.childCount=0),r!=null&&r.isSpecialRow||r!=null&&r.isLinked&&r.instanceMeta(this).groupParent?(this.unregister(r),!1):!0))}prepareGroupRecords(){var t;const r=this,{GroupRow:n,isFiltered:s,reapplyFilterOnUpdate:a,groupRecords:o}=r,l=r.groupers[0],d=l.ascending!==!1?1:-1,{field:c,fn:u=HA,leafFieldName:h}=l,f=typeof c=="function",g=c===r.modelClass.idField,m=new Ii,p=r._groupVisibleRecordIds||[],y=S=>{const x=!s||r.filtersFunction(S);return a?x:x||p.includes(S.id)},b=!!(r.startGroupsCollapsed&&!(o!=null&&o.count));o==null||o.forEach(S=>{S.isCollapsed&&r.includeGroupRecords(S)});const C=r.removeHeadersAndFooters(r.storage._values);if(r.sorters.length&&C.sort(r.sorterFn),s&&(r.filtersFunction=null),C.forEach(S=>{const x=S,R=f?c(S):S.getValue(c),M=H.asArray(R==null?"!!novalue!!":R),I=Array.isArray(M),_=I&&!M.length,P=_?1:M.length;for(let A=0;A<P;A++){const L=_?[]:M[A],F=`group-header-${typeof L=="number"?L:O.createId(L)}`;let N=m.get(F);if(N||(N=(o==null?void 0:o.get(F))||new n({[r.modelClass.idField]:F,[g?"":h]:L,_groupValue:L},r,{collapsed:b,specialRow:!0,groupRowFor:L,groupField:h,emptyArray:_}),m.add(N),N.meta.childCount=0,N.groupChildren=[],N.unfilteredGroupChildren=[],N.stores=[r]),r.register(N),A>0){const Y=x.groupLinks||(x.groupLinks={});S=Y[L]||(Y[L]=x.link()),S.stores=[r],r.register(S)}S.instanceMeta(r).groupParent=N,y(S)&&(N.groupChildren.push(S),N.meta.childCount++),N.unfilteredGroupChildren.push(S)}}),m._values.sort((S,x)=>u(S,x)*d),r.useGroupFooters)for(let S=0,x=m.count;S<x;S++){const R=m.values[S],M=R.meta.groupRowFor,I=`group-footer-${typeof M=="number"?M:O.createId(M)}`,_=r.getById(I)||new n({[r.modelClass.idField]:I,[g?"":h]:M,_groupValue:M},r,{specialRow:!0,groupFooterFor:M,groupRecord:R});_.stores=[r],r.register(_),_.groupChildren=R.groupChildren,m.splice(++S,0,_),x++,R.groupChildren.push(_),R.unfilteredGroupChildren.push(_),R.meta.childCount++}r._idMap=null;const D={values:m.reduce((S,x)=>(x.isGroupFooter||(S.push(x),x.meta.collapsed||S.push(...x.unfilteredGroupChildren)),S),!1,[])};return s&&(D.filteredValues=D.values.filter(y)),(t=r.groupRecords)==null||t.forEach(S=>{m.includes(S)||S.destroy()}),r.groupRecords=m,D}get isGrouped(){var t;return!!((t=this.groupers)!=null&&t.length)}group(t,r,n=!1,s=!0,a=!1){var o,l;const d=this,c=d.createGrouper(t);let u;if(n?d.groupers.push(c):t&&(r==null&&!("ascending"in c)&&(c.ascending=c.fn&&((o=d.groupInfo)==null?void 0:o.field)===c.field&&((l=d.groupInfo)==null?void 0:l.fn)===c.fn?!d.groupInfo.ascending:!0),d.groupInfo=u=c,d.groupers=[d.groupInfo]),u){const{prototype:h}=d.modelClass;u.complexMapping&&!Object.prototype.hasOwnProperty.call(h,t)&&Object.defineProperty(h,t,{get(){return T.getPath(this,t)}})}if(s!==!1){if(d.remoteSort&&!d.isRemoteDataLoading)return d.sort(null,null,!1,!0).then(()=>d.onAfterGrouping(a));d.sort(null,null,!1,!0)}d.onAfterGrouping(a)}onAfterGrouping(t){if(t)return;const r=this,n=r.groupers||[];r.trigger("group",{isGrouped:r.isGrouped,groupers:n,records:r.storage.values}),r.trigger("refresh",{action:"group",isGrouped:r.isGrouped,groupers:n,records:r.storage.values})}addGrouper(t,r=!0){return this.group(t,r,!0)}removeGrouper(t){const r=this,{groupers:n}=r;if(!n)return;const s=n.findIndex(a=>a.field===t);if(s>-1)return n.splice(s,1),n.length?r.group():r.clearGroupers()}clearGroupers(t=!1){return this.setGroupers(null,{silent:t})}isRecordInGroup(t,r){var n;if(!this.isGrouped)return null;const s=(n=this.groupers[0])==null?void 0:n.field;return t.getValue(s)===r&&!t.isSpecialRow}isInCollapsedGroup(t){const{groupParent:r}=t.instanceMeta(this);return r==null?void 0:r.meta.collapsed}getGroupRecords(t){return this.isGrouped?this.storage.values.filter(r=>this.isRecordInGroup(r,t)):null}getGroupTitles(){return this.isGrouped?this.getDistinctValues(this.groupers[0].field):null}onDataChanged({changes:t,action:r}){this.isGrouped&&(!t&&BA[r]||t&&this.groupers.some(n=>n.rootFieldName in t))&&this.sort()}internalIncludeExcludeGroupRecords(t,r){const n=this,s=n.indexOf(t),a=n.allIndexOf(t),{id:o,storage:l}=n,{_filteredValues:d,_values:c}=l,{meta:u,groupChildren:h,unfilteredGroupChildren:f}=t;a===-1||u.collapsed&&!r||!u.collapsed&&r||(f.forEach(g=>g.instanceMeta(o).hiddenByCollapse=!r),r?(d&&d.splice(s+1,0,...h.filter(g=>!n.isAvailable(g.id))),l._values.splice(a+1,0,...f.filter(g=>!n.isAvailable(g.id)))):(d&&d.splice(s+1,h.length),c.splice(a+1,f.length)),l._indicesInvalid=!0,n._idMap=null)}excludeGroupRecords(t){this.internalIncludeExcludeGroupRecords(t,!1)}includeGroupRecords(t){this.internalIncludeExcludeGroupRecords(t,!0)}collectGroupRecords(t,r=!0){return(t?this.storage.allValues:this.storage.values).reduce((s,a)=>(a.isSpecialRow&&(r&&!a.isGroupFooter&&s.push(a),a.isGroupHeader&&s.push.apply(s,t?a.unfilteredGroupChildren:a.groupChildren)),s),[])}},v(e,"$name","StoreGroup"),v(e,"configurable",{groupers:null,useGroupFooters:!1,startGroupsCollapsed:null}),e},eE=i=>class extends(i||$){static get configurable(){return{objectify:null}}initProxy(){if(!globalThis.Proxy)throw new Error("Proxy not supported");return new Proxy(this,{get(r,n){if(n in r)return r[n];if(n==="$store")return r;let s=r.getById(n);return!s&&!isNaN(parseInt(n))&&(s=r.getAt(parseInt(n))),s},set(r,n,s){return n in r||r.isDestroying||n==="_triggered"?r[n]=s:r.add({[r.modelClass.idField]:n,...s}),!0},deleteProperty(r,n){return r.isDestroying?(delete r[n],!0):!!r.remove(n).length},has(r,n){if(n in r)return!0;if(n.startsWith("{")&&n.endsWith("}")){const s=O.safeJsonParse(n);n=s==null?void 0:s.id}return r.includes(n)}})}},tE=i=>{var e;return e=class extends(i||$){initRelations(t){const r=this,n=r.modelClass.exposedRelations;t&&r.modelRelations&&r.modelRelations.forEach(s=>{var a;return(a=s.storeDetacher)==null?void 0:a.call(s)}),(!r.modelRelations||r.modelRelations.length===0||t)&&!r.isChained&&(r.modelRelations=[],n==null||n.forEach(s=>{const a={...s},{foreignStore:o,relationName:l,relatedCollectionName:d}=a,c=typeof o=="string"?r[o]:o;if(a.dependentStore=r,r.modelRelations.push(a),c){a.foreignStoreProperty=a.foreignStore,a.foreignStore=c;const u=c.dependentStoreConfigs;if(u.has(r)){const h=u.get(r);if(t){const f=h.find(g=>g.relationName===l);f&&H.remove(h,f)}h.push(a)}else u.set(r,[a]);d&&c.initRelationCollection(a,r),c.count>0&&c.updateDependentStores("dataset",c.records)}}))}initRelationCollection(t,r){const n=this,s=t.relatedCollectionName,a=n.collectionStores||(n.collectionStores={});a[s]={store:r,config:t},n[s+"Store"]||(n[s+"Store"]=r),n.allRecords.length&&n.initModelRelationCollection(s,n.allRecords)}initModelRelationCollection(t,r){const n=this;r.forEach(s=>{s.traverse(a=>{const o=t in a?`$related${O.capitalize(t)}`:t;Object.defineProperty(a,o,{enumerable:!0,configurable:!0,get:function(){return n.getCollection(this,t)},set:function(l){return n.setCollection(this,t,l)}})})})}resetRelationCache(){this.relationCache={},this.forEach(t=>t.initRelations())}updateRecordRelationCache(t,r){r==null||r.forEach(n=>{const{config:s}=n,a=n.related?n.related.id:t.getValue(s.foreignKey);a!==void 0&&this.cacheRelatedRecord(t,a,s.relationName,a)})}getRelationCollection(t,r){var n;const s=he.asId(r);return((n=this.relationCache[t])==null?void 0:n[s])||[]}getCollection(t,r){var n;const{config:s,store:a}=this.collectionStores[r];return((n=a.relationCache[s.relationName])==null?void 0:n[t.id])||[]}setCollection(t,r,n){const{config:s,store:a}=this.collectionStores[r],o=a.relationCache[s.relationName]||(a.relationCache[s.relationName]={}),l=(o[t.id]||[]).slice(),d=[],c=[];a.suspendEvents(),l.forEach(u=>{n.includes(u)||(u[s.foreignKey]=null,a.remove(u),c.push(u))}),n.forEach(u=>{u.isModel instanceof he?u.stores.includes(a)||(a.add(u),d.push(u)):([u]=a.add(u),d.push(u)),u[s.foreignKey]=t.id}),a.resumeEvents(),c.length&&(a.trigger("remove",{records:c}),a.trigger("change",{action:"remove",records:c})),d.length&&(a.trigger("add",{records:d}),a.trigger("change",{action:"add",records:d}))}cacheRelatedRecord(t,r,n,s=null){const a=this,o=a.relationCache[n]||(a.relationCache[n]={});s!==null&&a.uncacheRelatedRecord(t,n,s),r!=null&&H.include(o[r]||(o[r]=[]),t)}uncacheRelatedRecord(t,r=null,n=null){const s=this;function a(o,l){const d=s.relationCache[o],c=d==null?void 0:d[l];if(c){const u=c.indexOf(t);u>=0&&c.splice(u,1),c.length===0&&delete d[l]}}n!=null?a(r,n):t.meta.relationCache&&Object.entries(t.meta.relationCache).forEach(([o,l])=>a(o,l==null?void 0:l.id))}updateDependentStores(t,r,n){var s;const a=this;a.dependentStoreConfigs.forEach(o=>{o.forEach(l=>{const{dependentStore:d,relatedCollectionName:c,relationName:u,foreignKey:h}=l,f=d.relationCache[u];if(t==="dataset")c&&this.initModelRelationCollection(c,r),d.forEach(g=>{const m=g.initRelation(l);m&&d.cacheRelatedRecord(g,m.id,u,m.id)});else if(t==="removeall"){d.forEach(g=>g.removeRelation(l)),delete d.relationCache[u];return}else t==="replace"&&(r=r.map(g=>g[1]));(t==="add"||t==="replace")&&c&&this.initModelRelationCollection(c,r),t!=="dataset"&&r.forEach(g=>{const m=f==null?void 0:f[g.id];switch(t){case"remove":m&&m.forEach(p=>p.removeRelation(l));break;case"add":case"replace":d.forEach(p=>{p.getValue(h)==g.id&&(p.initRelation(l),d.cacheRelatedRecord(p,g.id,u))});break}!n&&(m!=null&&m.length)&&l.propagateRecordChanges&&m.forEach(p=>p.stores.forEach(y=>a.notifyRelatedStore(y,p,l.relationName,g)))})})}),t!=="dataset"&&(r!=null&&r.length)&&((s=a.modelRelations)==null||s.forEach(o=>{o.propagateRecordChanges&&r.forEach(l=>{var d;const c=l[o.relationName];(d=c==null?void 0:c.stores)==null||d.forEach(u=>{a.notifyRelatedStore(u,c,o.relatedCollectionName,l)})})}))}notifyRelatedStore(t,r,n,{meta:s}){if(this.isChained||t.isChained)return;let{_ignoreRelationUpdate:a}=s,o=!1;a!=null&&a.size||(s._ignoreRelationUpdate=a=new Set,o=!0),a.has(t)||(a.add(this).add(t),r.meta._ignoreRelationUpdate=a,t.onModelChange(r,{[n]:r[n]},{[n]:r[n]},!1,!0),o&&a.clear())}updateDependentRecordIds(t,r){var n;(n=this.dependentStoreConfigs)==null||n.forEach(s=>{s.forEach(a=>{var o;const{dependentStore:l,relationName:d,foreignKey:c}=a,u=l.relationCache[d],h=(o=u==null?void 0:u[t])==null?void 0:o.slice();h==null||h.forEach(f=>{l.cacheRelatedRecord(f,r,d,t),f.meta._ignoreRelatedIdUpdate=!0,f.set(c,r,!1,!0),delete f.meta._ignoreRelatedIdUpdate})})})}},v(e,"$name","StoreRelation"),e},iE=i=>{var e;return e=class extends(i||$){sum(t,r=this.storage.values){return r?r.reduce((n,s)=>{if(s.isSpecialRow)return n;const a=Number(s.getValue(t));return isNaN(a)?n:n+a},0):0}min(t,r=this.storage.values){return r!=null&&r.length?r.reduce((n,s)=>{const a=s.getValue(t);return typeof(a==null?void 0:a.valueOf())==="number"&&(a<n||n==null)&&(n=a),n},r[0].getValue(t)):0}max(t,r=this.storage.values){return r!=null&&r.length?r.reduce((n,s)=>{const a=s.getValue(t);return typeof(a==null?void 0:a.valueOf())==="number"&&(a>n||n==null)&&(n=a),n},r[0].getValue(t)):0}average(t,r=this.storage.values){if(!(r!=null&&r.length))return 0;let n=0;const s=r.reduce((a,o)=>{if(o.isSpecialRow)return a;const l=parseFloat(o.getValue(t));return isNaN(l)?a:(n++,a+l)},0);return n>0?s/n:0}groupSum(t,r){return this.sum(r,this.getGroupRecords(t))}},v(e,"$name","StoreSum"),e},rE=(i,e)=>String(i).toLowerCase().includes(e),nE={string:rE,number:(i,e)=>i===Number(e),boolean:rE,date:(i,e)=>i instanceof Date&&e instanceof Date?i-e===0:String(i.getMonth()+1).includes(e)||String(i.getDate()).includes(e)||String(i.getFullYear()).includes(e),object:(i,e)=>i===e,undefined:(i,e)=>i===e},sE=i=>{var e;return e=class extends(i||$){search(t,r=null,n,s){const a=this.isTree&&!s?this.rootNode.allChildren:this.getAllDataRecords(s),o=a.length,l=[];if(t==null)return[];typeof t=="string"&&(t=t.toLowerCase());let d,c,u,h,f,g;for(d=0;d<o;d++){u=a[d],c=0;for(const m of r||u.fieldNames){h=u.getValue(m),f=h instanceof Date?"date":typeof h;const p=n==null?void 0:n[c];p&&(h=p(h),f="string"),g=nE[f],h&&(g!=null&&g(h,t))&&l.push({index:d,data:u,field:m,id:u.id}),c++}}return l}findByField(t,r,n=!1,s=!1){const a=this.getAllDataRecords(s),o=a.length,l=new Set,d=[];let c,u,h;for(r!=null&&(r=String(r).toLowerCase()),c=0;c<o;c++)if(u=a[c],h=u.getValue(t),!n||!l.has(h)){const f=h instanceof Date?"date":typeof h,g=nE[f];(r==null&&h===r||r===""&&h===""||r&&g(h,r))&&(d.push({id:u.id,index:c,data:u}),n&&l.add(h))}return d}find(t,r=!1){return this.getAllDataRecords(r).find(t)}findRecord(t,r,n=!1){const s=a=>T.isEqual(a[t],r);return this.isTree?this.query(s,n)[0]:this.getAllDataRecords(n).find(s)}query(t,r=!1){return this.getAllDataRecords(r).filter(t)}some(t,r=!1){return this.getAllDataRecords(r).some(t)}},v(e,"$name","StoreSearch"),e},aE=i=>{var e;return e=class extends(i||$){static get defaultConfig(){return{useLocaleSort:null}}static get configurable(){return{sorters:[],reapplySortersOnAdd:!1}}get isSorted(){return!!this.sorters.length||this.isGrouped}changeSorters(t){return t.map(r=>this.normalizeSorterConfig(r,!0))}updateReapplySortersOnAdd(t){this.storage.autoSort=t}sort(t,r,n=!1,s=!1){const a=this,o=a.allRecords,l=a.sorters?a.sorters.slice():[];let d=null,c;if(t)if(Array.isArray(t))a.sorters=t.map(u=>a.normalizeSorterConfig(u,typeof u=="string"?!0:r));else{const u=a.normalizeSorterConfig(t,r);n?(c=a.getCurrentSorterByField(u.field),c?(d=c.ascending,c.ascending=u.ascending):a.sorters.push(u)):a.sorters=[u]}return!s&&a.trigger("beforeSort",{sorters:a.sorters,records:o,currentSorters:l})===!1?(a.sorters=l,d!==null&&(c.ascending=d),null):a.performSort(s)}normalizeSorterConfig(t,r){var n,s,a;const o=this,l={ascending:r};if(typeof t=="object"?(T.assign(l,t),t.fn&&(delete l.fn,l.sortFn=t.fn),l.ascending=(n=t.ascending)!=null?n:r):typeof t=="function"?l.sortFn=t:l.field=t,l.ascending==null){const d=o.getCurrentSorterByField(l.field);l.ascending=d?!d.ascending:!0}if(l.sortFn==null){const d=(a=(s=o.modelClass)==null?void 0:s.$meta.fields.map[l.field])==null?void 0:a.compareItems;d&&(l.sortFn=d)}return l}getCurrentSorterByField(t){return typeof t=="string"&&this.sorters.find(r=>r.field===t)||null}addSorter(t,r=!0){return this.sort(t,r,!0)}removeSorter(t){const r=this.sorters.findIndex(n=>n.field===t||n.sortFn===t);if(r>-1)return this.sorters.splice(r,1),this.sort()}clearSorters(t=!1){if(this.sorters.length)return this.sorters.length=0,this.sort(void 0,void 0,void 0,t)}createSorterFn(t){const r=this.useLocaleSort;return(n,s)=>{for(let a=0;a<t.length;a++){const o=t[a],{field:l,ascending:d=!0,useLocaleSort:c=r}=o,u=o.fn||o.sortFn,h=d?1:-1;if(u){const m=u.call(o,n,s);if(m===0)continue;if(m!==null)return m*h}const f=n.isModel?n.getValue(l):n[l],g=s.isModel?s.getValue(l):s[l];if(f!==g){if(f==null)return-h;if(g==null)return h;if(c&&typeof f=="string"){if(c===!0)return String(f).localeCompare(g)*h;if(typeof c=="string")return String(f).localeCompare(g,c)*h;if(typeof c=="object")return String(f).localeCompare(g,c.locale,c)*h}if(f>g)return h;if(f<g)return-h}}return 0}}get sorterFn(){return this.createSorterFn(this.remoteSort?[{field:"_remoteSortIndex"}]:this.sorters)}performSort(t){const r=this,{rootNode:n,storage:s,sorterFn:a}=r;r.tree?(!r.isChained&&n.traverse(o=>{o.isLoaded&&o.isParent&&(o.children.sort(a),o.updateChildrenIndices(o.children,"parentIndex",!0))}),s.replaceValues({values:r.collectDescendants(n).visible,silent:!0})):r.isGrouped?s.replaceValues({...r.prepareGroupRecords(),silent:!0}):s.replaceValues({values:s.values.sort(a),silent:!0}),r.afterPerformSort(t||r.isRemoteDataLoading)}afterPerformSort(t){if(t)return;const r=this;r._idMap=null;const n={action:"sort",sorters:r.sorters,records:r.allRecords};r.trigger("sort",n),r.trigger("refresh",n)}},v(e,"$name","StoreSort"),e},oE=()=>!0,lE=i=>{var e;return e=class extends(i||$){static get defaultConfig(){return{chainedFilterFn:null,chainedFields:null,masterStore:null,doRelayToMaster:["add","remove","insert"],dontRelayToMaster:[],excludeCollapsedRecords:!0,syncSort:!0,chainFilters:null,chainSuspended:0}}static get properties(){return{chainedStores:null}}construct(t){super.construct(t);const r=this,{masterStore:n}=r;n&&(r.methodNamesToRelay.forEach(s=>r[s]=(...a)=>r.relayToMaster(s,a)),r.removeAll=(...s)=>{n.remove(r.getRange(),...s)},n.ion({changePreCommit:r.onMasterDataChangedPreCommit,change:r.onMasterDataChanged,prio:1,thisObj:r}),r.syncSort&&n.ion({sort:()=>r.sort(n.sorters),thisObj:r}),n.chainedStores||(n.chainedStores=[]),n.chainedStores.push(r),r.fillFromMaster())}get $master(){return this.masterStore||this}get isChained(){return!!this.masterStore}set chainedFilterFn(t){this._chainedFilterFn=this.thisObj?t.bind(this.thisObj):t}get chainedFilterFn(){return this._chainedFilterFn||oE}get methodNamesToRelay(){const t=Array.isArray(this.doRelayToMaster),r=Array.isArray(this.dontRelayToMaster);return t&&this.doRelayToMaster.filter(n=>!r||!this.dontRelayToMaster.includes(n))||[]}updateChainedStores(){var t;(t=this.chainedStores)==null||t.forEach(r=>r.fillFromMaster())}fillFromMaster(){const t=this,{masterStore:r,isTree:n}=t,{isFiltered:s}=r;let a=[];if(!t.isChained)throw new Error("fillFromMaster only allowed on chained store");if(t.isChainSuspended)return;let o=null;if(t.chainFilters&&s){const l=r.filters.values.filter(d=>!d.ignoreForChain);l.length&&(o=ft.generateFiltersFunction(l))}if(a=r.allRecords.filter(l=>!l.isSpecialRow&&t.chainedFilterFn(l)&&(!o||o(l))),t.masterStore.sorterFn&&s&&r.isSorted&&!r.remoteSort&&a.sort(r.sorterFn),n)if(t.idRegister={},t.internalIdRegister={},a.forEach(l=>{l.stores.includes(t)?t.register(l):l.joinStore(t)}),t.excludeCollapsedRecords){const l=t.getChildren(t.rootNode);a=t.doIncludeExclude(l,!0)}else a.forEach(l=>l.instanceMeta(t).collapsed=!1);t.isFillingFromMaster=!0,t.data=a,t.isFillingFromMaster=!1}commitToMaster(){const t=this,r=t.masterStore;if(!t.isChained)throw new Error("commitToMaster only allowed on chained store");return r.beginBatch(),r.remove(t.removed.values),r.add(t.added.values),r.endBatch(),t.commit()}relayToMaster(t,r){return this.masterStore[t](...r)}onMasterDataChangedPreCommit(t){this.onMasterDataChanged(t),this.$masterEventhandled=!0}onMasterDataChanged({action:t,changes:r,isMove:n}){var s;const a=this;if(a.$masterEventhandled){a.$masterEventhandled=!1;return}n&&t==="remove"||(t!=="update"||a.chainedFields==="*"||(s=a.chainedFields)!=null&&s.some(o=>o in r))&&a.fillFromMaster()}makeChained(t=oE,r,n){if(this.isChained){const s=t;t=a=>s(a)&&this.chainedFilterFn(a)}return new((n==null?void 0:n.storeClass)||this.constructor)({id:`${this.id}-chained-${O.generateUUID()}`,tree:!1,autoTree:!1,...n||{},masterStore:this.$master,modelClass:this.modelClass,syncDataOnLoad:!1,chainedFilterFn:t,chainedFields:r})}chain(){return this.makeChained(...arguments)}doDestroy(){var t;(t=this.chainedStores)==null||t.forEach(r=>r.destroy()),super.doDestroy()}suspendChain(){this.chainSuspended++}resumeChain(t=!1){this.chainSuspended&&!--this.chainSuspended&&t&&this.fillFromMaster()}get isChainSuspended(){return this.chainSuspended>0}},v(e,"$name","StoreChained"),e},dE=i=>{var e;return e=class extends(i||$){getState(){const{sorters:t,groupers:r,filters:n}=this,s={};return t!=null&&t.length&&(s.sorters=t.map(a=>{const o=T.cleanupProperties(T.clone(a));return delete o.fn,delete o.sortFn,o})),r!=null&&r.length&&(s.groupers=r.map(a=>{const o=T.cleanupProperties(T.clone(a));return delete o.fn,o}),s.collapsedGroups=[...this.collapsedGroups]),n!=null&&n.values.length&&(s.filters=n.values.map(a=>{const o=T.cleanupProperties(T.clone(a.config));return o.value=a.value,o.caseSensitive&&delete o.caseSensitive,o})),s}applyState(t){var r;const n=this,{sorters:s=[],groupers:a=[],filters:o=[]}=t,{sortParamName:l,filterParamName:d}=n;(n.isSorted||s.length!==0||a.length!==0)&&(n.sorters=s.filter(c=>c.field||c.sortFn&&!l),n.groupers=a.slice(),n.sort()),(r=t.collapsedGroups)==null||r.forEach(c=>{const u=n.getById(c);u&&n.collapse(u,!0)}),(n.isFiltered||o.length!==0)&&(n.filters=o.filter(c=>c.property||c.filterBy&&!d),n.filter())}},v(e,"$name","StoreState"),e},sn=class{static preWalk(i,e,t){const r=[i];let n,s;for(;r.length;)n=r.pop(),t(n),s=e(n),s&&r.push.apply(r,s.slice().reverse())}static preWalkWithParent(i,e,t){const r=[{node:i,parent:null}];for(;r.length;){const{parent:n,node:s}=r.pop();t(n,s);const a=e(s);Array.isArray(a)&&r.push(...a.slice().reverse().map(o=>({node:o,parent:s})))}}static preWalkUnordered(i,e,t){const r=[i];let n,s;for(;r.length;)n=r.pop(),t(n),s=e(n),s&&r.push.apply(r,s)}static postWalk(i,e,t){const r=new Map,n=[i];let s,a;for(;n.length;)s=n[n.length-1],r.has(s)?(t(s),n.pop()):(a=e(s),a&&n.push(...a.slice().reverse()),r.set(s,s))}static prePostWalk(i,e,t,r){const n=new Map,s=[i];let a,o;for(;s.length;)a=s[s.length-1],n.has(a)?(r(a),s.pop()):(t(a),o=e(a),o&&s.push(...o.slice().reverse()),n.set(a,a))}};sn._$name="WalkHelper";var VA=i=>String(i).padStart(6,"0"),kf=class vr{constructor(e){this.value=e,this._padded=null}set value(e){this._value=String(e!=null?e:"")}get value(){return this._value}static from(e){return e==null||e instanceof vr?e:new vr(e)}static pad(e){return e instanceof vr?e.valueOf():vr.split(e).map(VA).join(".")}static split(e){let t,r;if(e||e===0)switch(typeof e){case"object":e=String(e);case"string":for(r=e.split("."),t=r.length;t-- >0;)r[t]=parseInt(r[t],10);break;case"number":r=[e];break}return r||[]}static compare(e,t){return e===t?0:!e||!t?e?1:t?-1:0:(e=vr.pad(e),t=vr.pad(t),e<t?-1:t<e?1:0)}append(e){const t=this.value;return vr.from(t?`${t}.${e}`:e)}isEqual(e){return!vr.compare(this,e)}match(e){let t=!1;if(e){const r=this.value,n=e[0]==="*",s=e.endsWith("*"),a=e.length;n===s?t=r.indexOf(n?e.substr(1,a-2):e)>-1:n?t=r.endsWith(e.substr(1)):t=r.startsWith(e.substr(0,a-1))}return t}toString(){return this.value}toJSON(){return this.toString()}valueOf(){var e;return(e=this._padded)!=null?e:this._padded=vr.pad(this.value)}};kf._$name="Wbs";var zA=Object.freeze([]),tc=Symbol("StopBranch"),Sv=O.generateUUID(),cE=i=>{var e;return e=class extends(i||$){get StopBranch(){return tc}get isTree(){return this.tree||this.masterStore&&this.masterStore.tree}get leaves(){const t=this,r=[];return t.isTree?(t.traverse(n=>{n.isLeaf&&r.push(n)}),r):(t.allRecords.forEach(n=>{n.isLeaf&&r.push(n),n.traverse(s=>{s.isLeaf&&r.push(s)},!0)}),r)}async loadChildren(t){}onNodeAddChild(t,r,n,s,a=!1){var o;const l=this,d=t===l.rootNode&&t.isLoading,{storage:c}=l,{previousSibling:u}=r[0];let h;const{visible:f,all:g}=l.collectDescendants(r,void 0,void 0,{inCollapsedBranch:!(t.isExpanded(l)&&t.ancestorsExpanded(l)),applyFilter:l.isFiltered&&l.reapplyFilterOnAdd});if(!d&&g.length)for(const m of g)!l.modified.includes(m)&&!s[m.id]&&(l.removed.includes(m)?l.removed.remove(m):m.isLinked||l.added.add(m));if(d&&l.rootVisible&&(f.unshift(t),g.unshift(t)),f.length?(n===0||!u?h=c.indexOf(t):h=c.indexOf(u)+u.getDescendantCount(!0,l),c.suspendEvents(),l.storage.splice(++h,0,f),c.resumeEvents(),l._idMap=null):l._allRecords=null,l.updateDependentStores("add",r),d&&f.length){if(l.sorters.length&&l.sort(null,null,!1,!0),(o=l.afterLoadData)==null||o.call(l),!a){const m={action:"dataset",data:l._data,records:f};l.trigger("refresh",m),l.trigger("change",m)}}else if(!a){const m={action:"add",parent:t,isChild:!0,isMove:s,records:r,allRecords:g,index:h};if(l.trigger("add",m),l.trigger("change",m),s&&Object.values(s).some(p=>p)){const p={newParent:t,records:r.filter(y=>s[y.id]),oldParents:r.map(y=>l.getById(y.meta.oldParentId))};l.trigger("move",p)}}}onNodeRemoveChild(t,r,n,s={isMove:!1,silent:!1,unfiltered:!1}){const a=this,{storage:o}=a,l=[],d=[],{isMove:c,silent:u,unfiltered:h}=s,f=h&&a.isFiltered,g=f&&t.unfilteredChildren?t.unfilteredChildren:r;if(a.collectDescendants(g,l,d,{inCollapsedBranch:!(t.isExpanded(a)&&t.ancestorsExpanded(a)),unfiltered:f}),!c){for(const m of r)m.unjoinStore(a);for(const m of d)m.stores.includes(a)&&m.unjoinStore(a),a.added.includes(m)?a.added.remove(m):m.isLinked||a.removed.add(m);a.modified.remove(d)}if(l.length?(n=o.indexOf(l[0]),n>-1&&(o.suspendEvents(),o.splice(n,l.length),o.resumeEvents(),a._idMap=null)):(n=-1,a._allRecords=null),!u&&(a.fireRemoveEventForMoveAction||!c)){const m={action:"remove",parent:t,isChild:!0,isMove:c,records:r,allRecords:d,index:n};a.trigger("remove",m),a.trigger("change",m)}return d}collectDescendants(t,r=[],n=[],s={}){var a;const o=this,{inCollapsedBranch:l=!1,unfiltered:d=!1,applyFilter:c=!1}=s,u=Array.isArray(t)?t:(a=o.getChildren(t,d))!=null?a:[];if(c)return{visible:!l&&u.flatMap(h=>o.collectVisibleNodeDescendantsFiltered(h)),all:u.flatMap(h=>h.allChildren)};for(let h=0,f=u.length,g;h<f;h++)g=u[h],l||r.push(g),n.push(g),o.collectDescendants(g,r,n,{inCollapsedBranch:l||!g.isExpanded(o),unfiltered:d});return{visible:r,all:n}}collectVisibleNodeDescendantsFiltered(t){const r=t.unfilteredChildren||t.children;if(!r||r.length===0||!t.isLeaf&&!t.isExpanded(this))return this.filtersFunction(t)?[t]:[];const n=r.flatMap(s=>this.collectVisibleNodeDescendantsFiltered(s));return n.length||this.filtersFunction(t)?[t,...n]:[]}getChildren(t,r=!1){const n=this,s=(r||n.isChained)&&t.unfilteredChildren||t.children;return s!=null&&s.length?n.isChained?s.filter(n.chainedFilterFn).sort(n.sorterFn):s:zA}internalToggleTreeSubRecords(t,r){const n=this,{storage:s}=n,a=s.indexOf(t),o=n.doIncludeExclude(n.getChildren(t),r);if(n.isFiltered&&r&&t.unfilteredChildren&&n.updateChildrenHiddenState(t),o.length&&a!==!1){if(s.suspendEvents(),r){s.splice(a+1,0,...o);const l={action:"add",isExpand:!0,parent:t,records:o,index:a+1};n.trigger("add",l),n.trigger("change",l)}else{s.splice(a+1,o.length);const l={action:"remove",isCollapse:!0,parent:t,records:o,index:a+1};n.trigger("remove",l),n.trigger("change",l)}s.resumeEvents(),n._idMap=null}}updateChildrenHiddenState(t){var r;(r=t.unfilteredChildren)==null||r.forEach(n=>{n.instanceMeta(this.id).hidden=!1,n.isLeaf||this.updateChildrenHiddenState(n)})}doIncludeExclude(t,r,n=[]){const s=this,a=(t==null?void 0:t.length)||0;for(let o=0;o<a;o++){const l=t[o];if(!s.isChained||s.chainedFilterFn(l)){const d=l.instanceMeta(s.id);(r||!d.hidden)&&n.push(l),d.hidden=!r,l.isExpanded(s)&&s.doIncludeExclude(s.getChildren(l),r,n)}}return n}async toggleCollapse(t,r){const n=this,s=n.getById(t),a=s.instanceMeta(n);if(r===void 0&&(r=!a.collapsed),!a.isLoadingChildren&&!s.isLeaf&&s.isExpanded(n)===r){if(n.trigger("beforeToggleNode",{record:s,collapse:r}),a.collapsed=r,a.collapsed)return n.onNodeCollapse(s),!0;{n.onNodeExpand(s);let o=!0;if(!s.isLoaded){a.isLoadingChildren=!0;try{await n.loadChildren(s)}catch(l){a.collapsed=!0,o=!1,n.trigger("loadChildrenException",{record:s,exception:l})}finally{a.isLoadingChildren=!1}}return o}}}onNodeCollapse(t){if(t.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(t,!1)}onNodeExpand(t){if(t.ancestorsExpanded(this))return this.internalToggleTreeSubRecords(t,!0)}transformToTree(t){const{parentIdField:r,idField:n,childrenField:s}=this.modelClass,a=new Map,o=new Set,l=[];for(const c of t){const u=c==null?void 0:c[n];u!=null&&a.set(u,c)}const d=c=>{const u=Object.assign({},c);return u[s]=[],a.set(u[n],u),o.add(c[n]),u};for(let c of t)if(c){const u=c[n];o.has(u)?c=a.get(u):c=d(c);const h=c[r];if(h!=null){let f=a.get(h);f&&(f[s]||(f=d(f)),f[s].push(c))}else c[s]?l.push(c):c[n]!=null?l.push(d(c)):l.push(c)}return a.forEach(c=>{var u,h;(h=(u=c[s]).sort)==null||h.call(u,(f,g)=>f.parentIndex-g.parentIndex)}),l}treeifyData(t,r,n,s=!1,a){const{length:o}=r,l=[],d=[],c={};let u,h;for(u=0;u<o;u++){let g=r[u];g=g.field||g,r[u].call||(r[u]=m=>m[g],r[u].fieldName=g),l[u]=new Map}sn.preWalkWithParent({isRoot:!0,id:this.rootNode.id,children:t},g=>g.children,(g,m)=>{if(h=[],m.isLeaf){for(u=0;u<o;u++){const p=r[u],y=a?a(p(m),p.fieldName):p(m),b=l[u],C=y===""?Sv:y,D=H.asArray(C)||[Sv],S=[];if(D[0]===tc)break;(h.length>0?h:[null]).forEach(R=>{var M;for(let I=0,{length:_}=D;I<_;I++){const P=D[I],A=`${((M=R==null?void 0:R.path)!=null?M:"")+(P!=null&&P.isModel?P.id:P)}/`,L=O.makeValidDomId(`generated_${A}`,"_"),F=b.get(L)||b.set(L,{id:L,key:D[I]===Sv?"":P,path:A,readOnly:!0,children:[],generatedParent:!0,field:p.fieldName,firstGroupChild:m}).get(L);S.push(F),R&&!R.children.includes(F)&&R.children.push(F)}}),h=S}h.length?h.forEach((p,y)=>p.children.push(y?m.link():m)):d.push(m)}},!0),(n||s)&&l.forEach(g=>g.forEach((m,p,y)=>{n==null||n(m),s&&(m=this.createRecord(m),y.set(p,m))})),c.children=[...l[0].values(),...d];const f=g=>{g.children&&(g.children.sort((m,p)=>{if(m.isLeaf===p.isLeaf)if(m.isLeaf){let y;for(let b=0;!y&&b<o;b++){const C=r[b](m),D=r[b](p);if(C===tc||D===tc)return m.isLeaf<p.isLeaf?-1:m.isLeaf>p.isLeaf?1:0;y=C<D?-1:D<C?1:0}return y}else return typeof m.key=="string"&&typeof p.key=="string"?m.key.localeCompare(p.key,void 0,{numeric:!0}):m.key<p.key?-1:m.key>p.key?1:0;else return m.isLeaf<p.isLeaf?-1:m.isLeaf>p.isLeaf?1:0}),g.children.forEach(f))};return f(c),c}treeify(t,r,n=!1,s){return this.treeifyData(this.rootNode.children,t,r,n=!1,s)}treeifyFlatData(t){const{childrenField:r,parentIdField:n}=this.modelClass;let s=!1,a=!0;for(const o of t){if(o!=null&&o.isModel||Array.isArray(o==null?void 0:o[r])){a=!1;break}(o==null?void 0:o[n])!=null&&(s=!0)}return a&&s&&(t=this.transformToTree(t)),t}async indent(t){const r=this;if(t=Array.isArray(t)?t:[t],t=t.filter(n=>{let s=!!n.previousSibling;for(;s&&!n.isRoot;)s=!t.includes(n.parent),n=n.parent;return s}),t.length&&r.trigger("beforeIndent",{records:t})!==!1){t.sort((n,s)=>kf.compare(n.wbsCode,s.wbsCode)),r.beginBatch();for(const n of t){const s=n.previousSibling;s.appendChild(n),r.toggleCollapse(s,!1)}r.endBatch(),r.trigger("indent",{records:t}),r.trigger("change",{action:"indent",records:t})}}async outdent(t){const r=this;if(t=Array.isArray(t)?t:[t],t=t.filter(n=>{const{parent:s}=n;let a=s&&!s.isRoot;for(;a&&!n.isRoot;)a=!t.includes(s),n=n.parent;return a}),t.length&&r.trigger("beforeOutdent",{records:t})!==!1){t.sort((n,s)=>kf.compare(n.wbsCode,s.wbsCode)),r.beginBatch();for(const n of t){const{parent:s}=n,a=s.children.slice(s.children.indexOf(n)+1);s.parent.insertChild(n,s.nextSibling),n.appendChild(a),r.toggleCollapse(n,!1)}r.endBatch(),r.trigger("outdent",{records:t}),r.trigger("change",{action:"outdent",records:t})}}},v(e,"$name","StoreTree"),v(e,"StopBranch",tc),v(e,"configurable",{transformFlatData:null,fireRemoveEventForMoveAction:!1}),e},uE=i=>{var e;return e=class extends(i||$){static get configurable(){return{syncDataOnLoad:null,shouldSyncDataset:null,shouldSyncRecord:null,reorderOnSync:!0}}syncDataset(t){var r,n,s,a,o;const l=this,{storage:d}=l,c=(a=(r=l.shouldSyncDataset)==null?void 0:r.call(l,{data:t,store:l,records:l.records}))!=null?a:(s=(n=l.project)==null?void 0:n.shouldSyncDataset)==null?void 0:s.call(n,{data:t,store:l,records:l.records});if(c===!1)return;l.trigger("startApplyChangeset"),l.isSyncingDataOnLoad=!0;const{toAdd:u,toRemove:h,toMove:f,updated:g,ids:m}=l.tree?l.syncTreeDataset(t,c):l.syncFlatDataset(t,c);let p=(o=l.syncDataOnLoad)==null?void 0:o.threshold,y=!1;if(p&&(typeof p=="string"&&(p=parseInt(p,10)/100*l.count),y=u.length+h.length+f.length+g.length>p),l.tree){if(u.length&&l.add(u,y).forEach(D=>D.clearParentId()),f.length)for(const{parent:C,node:D,index:S}of f)l.getById(C.id).insertChild(D,S);l.remove(h,y)}else y&&l.suspendEvents(),l.remove(h),l.add(u),y&&l.resumeEvents();p&&!y&&g.forEach(({record:C,toSet:D,wasSet:S})=>l.onModelChange(C,D,S)),l.acceptChanges();const b={added:u,removed:h,updated:g,thresholdSurpassed:y};if(l.isFiltered&&!l.remoteFilter&&l.filter({silent:l.isRemoteDataLoading}),l.isGrouped)l.group(null,null,!1,!0,l.isRemoteDataLoading);else if(l.isSorted)l.remoteSort?d.replaceValues({values:d.values.sort(l.createSorterFn(l.sorters)),silent:!0}):l.sort();else if(l.reorderOnSync)if(!l.tree)d.values.some((C,D)=>m[C.id]!==D)&&(d.replaceValues({values:d.values.sort((C,D)=>m[C.id]-m[D.id]),silent:!0}),!y&&l.afterPerformSort());else{let C=!1,D=0;sn.preWalk(l.rootNode,S=>Array.isArray(S.children)&&!C?S.children:null,S=>{S.id!==m[D++]&&(C=!0)}),C&&(l.sort((S,x)=>m[S.id]-m[x.id],void 0,void 0,!0),l.clearSorters(!0),!y&&l.afterPerformSort())}y&&l.trigger("refresh",{action:"batch",data:t,records:d.values,syncInfo:b}),l.isSyncingDataOnLoad=!1,l.trigger("endApplyChangeset"),l.trigger("loadSync",b)}syncFlatDataset(t,r){if(!t)return{toRemove:this.records};const n=this,{idField:s,allFields:a}=n.modelClass,o=[],l=[],d=[],c={},u={},h=r instanceof Set,{threshold:f,keepMissingValues:g}=n.syncDataOnLoad;let m=0;if(t.forEach((p,y)=>{var b,C;p=p.isModel?p.data:p;const D=p[s],S=n.getById(D);if(!h||r.has(D))if(S){if(n.shouldSyncRecord?n.shouldSyncRecord({record:S,data:p,store:n})!==!1:p!==S.data){if((b=n.beforeSyncRecord)==null||b.call(n,{record:S,data:p}),g===!1)for(const R of a)!(R.dataSource in p)&&R.dataSource in S.data&&(p[R.dataSource]=R.defaultValue);const x=S.set(p,null,!!f);x&&d.push({record:S,wasSet:x,toSet:p}),(C=n.afterSyncRecord)==null||C.call(n,{record:S,data:p})}}else l.push(n.processRecord(n.createRecord(p)));S&&m++,c[D]=1,u[D]=y}),m<n.allRecords.filter(p=>!p.isSpecialRow).length)if(r)for(const p of r)c[p]||o.push(n.getById(p));else n.forEach(p=>{c[p.id]||o.push(p)},n,{includeFilteredOutRecords:!0,includeCollapsedGroupRecords:!0});return{toAdd:l,toRemove:o,toMove:[],updated:d,ids:u}}syncTreeDataset(t){var r;if(!t)return{toRemove:this.records};const n=this,{idField:s,parentIdField:a,childrenField:o,allFields:l}=n.modelClass,{keepMissingValues:d,threshold:c}=(r=n.syncDataOnLoad)!=null?r:{},u=[],h=[],f=[],g=[],m=new Set,p={};let y=0;return n.transformFlatData&&(t=n.treeifyFlatData(t)),sn.preWalkWithParent({isRoot:!0,id:n.rootNode.id,children:t},b=>b.children,(b,C)=>{if(b){const{id:D,node:S}=n.resolveSyncNode(C);if(S){if(n.shouldSyncRecord?n.shouldSyncRecord({record:S,data:C,store:n})!==!1:C!==S.data){let x;const R=S.children;S.parent.id!==b[s]&&f.push({node:S,parent:b,index:b[o].indexOf(C)});let M;if(S!==C){if(R!==!0&&C[o]===!0&&(S.clearChildren(),S.data[o]=S.children=!0,delete C[o],n.toggleCollapse(S,!0),x=!0),d===!1)for(const I of l)I.name!=="parentId"&&!(I.dataSource in C)&&I.dataSource in S.data&&(C[I.dataSource]=I.defaultValue);typeof C.expanded=="boolean"&&this.toggleCollapse(S,!C.expanded),M=S.set(C,null,!!c)}M?g.push({record:S,wasSet:M,toSet:C}):x&&S.signalNodeChanged({[o]:{value:!0,oldValue:R}})}m.add(S)}else C[a]=b[s],C.isModel?h.push(C):h.push({...C,...Array.isArray(C[o])?{children:[]}:void 0});p[D]=y++}}),n.totalCount!==m.size&&n.traverse(b=>{m.has(b)||u.push(b)}),{toAdd:h,toRemove:u,toMove:f,updated:g,ids:p}}resolveSyncNode(t){const r=t[this.modelClass.idField],n=this.getById(r);return{id:r,node:n}}},v(e,"$name","StoreSync"),e},ic=class extends Error{constructor(...i){super(...i),this.name="RevisionException"}};ic._$name="RevisionException";var Be=()=>{throw new Error("Abstract method call!")},ie=()=>{throw new Error("Method cannot be called at this state!")},an=class extends ${canUndo(i){Be()}canRedo(i){Be()}canCheckoutTo(i){Be()}onUndo(i){Be()}onRedo(i){Be()}onCheckoutTo(i){Be()}onCheckoutToHead(i){Be()}onStartRevision(i,e){Be()}onStopRevision(i){Be()}onStartTransaction(i){Be()}onStopTransaction(i){Be()}onStopTransactionDelayed(i){Be()}onRejectTransaction(i){Be()}onEnable(i){Be()}onDisable(i){Be()}onAutoRecordOn(i){Be()}onAutoRecordOff(i){Be()}onResetQueue(i){Be()}onModelUpdate(i){Be()}onStoreModelAdd(i){Be()}onStoreModelInsert(i){Be()}onStoreModelRemove(i){Be()}onStoreModelRemoveAll(i){Be()}onModelInsertChild(i){Be()}onModelRemoveChild(i){Be()}};an._$name="StateBase";var xe=Symbol("STATE_PROP"),hi=Symbol("STORES_PROP"),jt=Symbol("QUEUE_PROP"),_i=Symbol("POS_PROP"),Ke=Symbol("ACTION_QUEUE_PROP"),Xe=Symbol("REVISION_NAMES_PROP"),ot=Symbol("REVISION_QUEUE_PROP"),Vt=Symbol("REVISION_INDEX_PROP"),NA=Symbol("CURRENT_REV_ID_PROP"),Ae=Symbol("TRANSACTION_PROP"),fi=Symbol("TRANSACTION_TIMER_PROP"),Pi=Symbol("AUTO_RECORD_PROP"),rc=Symbol("IS_APPLYING_STASH"),pH=Object.freeze([xe,hi,jt,_i,Ke,Xe,ot,Vt,NA,Ae,fi,Pi,rc]),hE=new Map,WA=(i,e)=>{hE.set(i,e)},UA=i=>(typeof i=="string"&&(i=hE.get(i)),i),Qt={registerStmState:WA,resolveStmState:UA},Lf=(i,e)=>{const{undo:t,redo:r,revision:n}=e;let s;return t&&!r?s={[jt]:i[jt].slice(i.position),[_i]:0}:r&&!t?s={[jt]:i[jt].slice(0,i.position)}:s={[jt]:[],[_i]:0},n&&(s=Object.assign(s!=null?s:{},{[Xe]:[],[Vt]:-1,[ot]:[]})),[s,()=>{i.notifyStoresAboutQueueReset(e)}]},GA=class extends an{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){ie()}onRedo(){ie()}onEnable(i){return i.autoRecord?"autoreadystate":"readystate"}onDisable(){ie()}onAutoRecordOn(){return{[Pi]:!0}}onAutoRecordOff(){return{[Pi]:!1}}onStartTransaction(){ie()}onStopTransaction(){ie()}onStopTransactionDelayed(){ie()}onRejectTransaction(){ie()}onResetQueue(i,e){return Lf(i,e)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}},fE=new GA,YA=fE;Qt.registerStmState("disabledstate",fE);var xr=class extends ${static get defaultConfig(){return{inversed:!1}}get type(){return this.constructor.name}undo(){Be()}redo(){Be()}invert(){const i=new this.constructor({...this.initialConfig,isUserInput:this.isUserInput,inversed:!0}),{undo:e,redo:t}=i;return i.undo=t,i.redo=e,i}},wt={ADD:"AddAction",INSERT:"InsertAction",INSERT_CHILD:"InsertChildAction",REMOVE:"RemoveAction",REMOVE_ALL:"RemoveAllAction",REMOVE_CHILD:"RemoveChildAction",UPDATE:"UpdateAction",EVENT_UPDATE:"EventUpdateAction"};xr._$name="ActionBase";var gE=Symbol("MODEL_PROP"),mE=Symbol("NEW_DATA_PROP"),pE=Symbol("OLD_DATA_PROP"),Ua=class extends xr{static get defaultConfig(){return{model:void 0,newData:void 0,oldData:void 0,isInitialUserAction:!1}}get type(){return wt.UPDATE}get model(){return this[gE]}set model(i){this[gE]=i}get newData(){return this[mE]}set newData(i){this[mE]={...i}}get oldData(){return this[pE]}set oldData(i){this[pE]={...i}}undo(){const{model:i,oldData:e}=this;i.$&&Object.assign(i,e),i.set(e,null,null,null,!!i.$)}redo(){const{model:i,newData:e}=this;i.$&&Object.assign(i,e),i.set(e,null,null,null,!!i.$)}};v(Ua,"$name","UpdateAction"),Ua._$name="UpdateAction";var vE=Symbol("PARENT_MODEL_PROP"),yE=Symbol("CHILD_MODELS_PROP"),bE=Symbol("INSERT_INDEX_PROP"),CE=Symbol("ORDERED_PROP"),SE=Symbol("CONTEXT_PROP"),Of=class extends xr{static get defaultConfig(){return{parentModel:void 0,childModels:void 0,insertIndex:void 0,orderedBeforeNode:void 0,context:void 0,stores:void 0}}get type(){return wt.INSERT_CHILD}get parentModel(){return this[vE]}set parentModel(i){this[vE]=i}get childModels(){return this[yE]}set childModels(i){this[yE]=i.slice(0)}get insertIndex(){return this[bE]}set insertIndex(i){this[bE]=i}get orderedBeforeNode(){return this[CE]}set orderedBeforeNode(i){this[CE]=i}get context(){return this[SE]}set context(i){this[SE]=i}get stores(){return this[hi]}set stores(i){this[hi]=i}undo(){const{parentModel:i,context:e,childModels:t}=this,r=new Map,n=new Set;for(const s of t){const a=e.get(s);if(!a)n.add(s);else{let o=r.get(a.parent);o||(o={moveRight:[],moveLeft:[],moveFromAnotherParent:[]},r.set(a.parent,o)),a.parent===i?a.index>s.parentIndex?o.moveRight.push({parent:a.parent,model:s,index:a.index+1}):o.moveLeft.push({parent:a.parent,model:s,index:a.index}):o.moveFromAnotherParent.push({parent:a.parent,model:s,index:a.index})}}n.forEach(s=>s.parent.removeChild(s));for(const s of r.values()){const{moveRight:a,moveLeft:o,moveFromAnotherParent:l}=s;l.forEach(d=>{d.parent.insertChild(d.model,d.index)}),o.sort((d,c)=>d.index-c.index),a.sort((d,c)=>c.index-d.index)}for(const s of r.values()){const{moveRight:a,moveLeft:o}=s;o.forEach(l=>{l.parent.insertChild(l.model,l.index)}),a.forEach(l=>{l.parent.insertChild(l.model,l.index)})}}redo(){var i,e;const{parentModel:t,insertIndex:r,childModels:n,orderedBeforeNode:s}=this,a=(i=t.children)==null?void 0:i[r];t.insertChild(n,a,!1,{orderedBeforeNode:s!=null?s:(e=a==null?void 0:a.previousSibling)==null?void 0:e.nextOrderedSibling})}};v(Of,"$name","InsertChildAction"),Of._$name="InsertChildAction";var DE=Symbol("PARENT_MODEL_PROP"),wE=Symbol("CHILD_MODELS_PROP"),EE=Symbol("CONTEXT_PROP"),$f=class extends xr{static get defaultConfig(){return{parentModel:void 0,childModels:void 0,context:void 0,stores:void 0}}get type(){return wt.REMOVE_CHILD}get parentModel(){return this[DE]}set parentModel(i){this[DE]=i}get childModels(){return this[wE]}set childModels(i){this[wE]=i.slice(0)}get context(){return this[EE]}set context(i){this[EE]=i}get stores(){return this[hi]}set stores(i){this[hi]=i}undo(){const{parentModel:i,context:e,childModels:t}=this;t.sort((r,n)=>{const s=e.get(r).parentIndex,a=e.get(n).parentIndex;return s-a}),t.forEach(r=>{const n=e.get(r);i.insertChild(r,n.parentIndex,void 0,{orderedParentIndex:n.orderedParentIndex})})}redo(){this.parentModel.removeChild(this.childModels)}};v($f,"$name","RemoveChildAction"),$f._$name="RemoveChildAction";var xE=Symbol("STORE_PROP"),RE=Symbol("MODEL_LIST_PROP"),Bf=class extends xr{static get defaultConfig(){return{store:void 0,modelList:void 0,silent:!1}}get type(){return wt.ADD}get store(){return this[xE]}set store(i){this[xE]=i}get modelList(){return this[RE]}set modelList(i){this[RE]=i.slice(0)}undo(){this.store.remove(this.modelList,this.silent)}redo(){this.store.add(this.modelList,this.silent)}};v(Bf,"$name","AddAction"),Bf._$name="AddAction";var TE=Symbol("STORE_PROP"),ME=Symbol("MODEL_LIST_PROP"),IE=Symbol("INSERT_INDEX_PROP"),_E=Symbol("CONTEXT_PROP"),Hf=class extends xr{static get defaultConfig(){return{store:void 0,modelList:void 0,insertIndex:void 0,context:void 0,silent:!1,reportUndoneRemoval:!0}}get type(){return wt.INSERT}get store(){return this[TE]}set store(i){this[TE]=i}get modelList(){return this[ME]}set modelList(i){this[ME]=i.slice(0)}get insertIndex(){return this[IE]}set insertIndex(i){this[IE]=i}get context(){return this[_E]}set context(i){this[_E]=i}undo(){const{store:i,modelList:e,context:t,silent:r,reportUndoneRemoval:n}=this;e.sort((s,a)=>{const o=t.get(s),l=t.get(a);return o!==void 0&&l!==void 0?o-l:0}),e.forEach(s=>{const a=t.get(s);s._undoingInsertion=n,a!==void 0?i.insert(a,s,r):i.remove(s,r),s._undoingInsertion=!1})}redo(){const i=this;i.store.insert(i.insertIndex,i.modelList,i.silent)}};v(Hf,"$name","InsertAction"),Hf._$name="InsertAction";var PE=Symbol("STORE_PROP"),AE=Symbol("MODEL_LIST_PROP"),FE=Symbol("CONTEXT_PROP"),jf=class extends xr{static get defaultConfig(){return{store:void 0,modelList:void 0,context:void 0,silent:!1}}get type(){return wt.REMOVE}get store(){return this[PE]}set store(i){this[PE]=i}get modelList(){return this[AE]}set modelList(i){this[AE]=i.slice(0)}get context(){return this[FE]}set context(i){this[FE]=i}undo(){const{store:i,context:e,modelList:t,silent:r}=this;t.sort((n,s)=>{const a=e.get(n),o=e.get(s);return a-o}),t.forEach(n=>{const s=e.get(n);i.insert(s,n,r)})}redo(){this.store.remove(this.modelList,this.silent)}};v(jf,"$name","RemoveAction"),jf._$name="RemoveAction";var kE=Symbol("STORE_PROP"),LE=Symbol("ALL_RECORDS_PROP"),Vf=class extends xr{static get defaultConfig(){return{store:void 0,allRecords:void 0,silent:!1}}get type(){return wt.REMOVE_ALL}get store(){return this[kE]}set store(i){this[kE]=i}get allRecords(){return this[LE]}set allRecords(i){this[LE]=i.slice(0)}undo(){const{store:i,allRecords:e,silent:t}=this;i.add(e,t)}redo(){this.store.removeAll(this.silent)}};v(Vf,"$name","RemoveAllAction"),Vf._$name="RemoveAllAction";var qA=(i,e,t,r)=>new Ua({model:i,newData:e,oldData:t,isInitialUserAction:r}),KA=(i,e,t,r,n,s)=>new Of({parentModel:i,childModels:t,insertIndex:e,orderedBeforeNode:n,context:r,stores:s}),XA=(i,e,t,r)=>new $f({parentModel:i,childModels:e,context:t,stores:r}),ZA=(i,e,t)=>new Bf({store:i,modelList:e,silent:t}),QA=(i,e,t,r,n)=>new Hf({store:i,insertIndex:e,modelList:t,context:r,silent:n}),JA=(i,e,t,r)=>new jf({store:i,modelList:e,context:t,silent:r}),eF=(i,e,t)=>new Vf({store:i,allRecords:e,silent:t}),tF=i=>i.invert(),on={DATA_CORRECTION:"DATA_CORRECTION",TEMPORARY:"TEMPORARY",CONFLICT_RESOLUTION:"CONFLICT_RESOLUTION"},Jt=class extends ${static get configurable(){return{title:null,committed:!1,inputGeneration:0}}static from(i,e={}){const t=new this({...this.initialConfig,...e,inputGeneration:i.reduce((r,n)=>{var s;return Math.max(r,(s=n.inputGeneration)!=null?s:0)},0),committed:!1});return t[Ke]=i.flatMap(r=>r[Ke].filter(n=>r.inputGeneration>0?e.conflictResolutionFor?n.isUserInput===r.inputGeneration:n.isUserInput:n)),t}static createTransactionWithOriginalInput(i){const e=new this({...this.initialConfig,title:i.title,committed:!1});return e[Ke]=i[Ke].filter(t=>t.isUserInput?t.isUserInput===1:!t.isUserInput),e}construct(...i){this[Ke]=[],super.construct(...i)}get queue(){return this[Ke].slice(0)}get length(){return this[Ke].length}get filterUserInput(){return this.inputGeneration>0}addAction(i){this[Ke].push(i)}undo(){const i=this[Ke];for(let e=i.length-1;e>=0;--e)i[e].undo()}redo(){const i=this[Ke];for(let e=0,t=i.length;e<t;++e)i[e].redo()}mergeUpdateModelActions(){var i,e,t;const r=this[Ke],n=new Map,s=[];for(const a of r)if(a.isUpdateAction&&((i=a.model)!=null&&i.isModel)){const o=(e=a.isUserInput)!=null?e:0;let l=n.get(a.model);l||(l=[],n.set(a.model,l));const d=l[o];if(!d)l[o]=a,s.push(a);else for(const c in a.oldData)a.newData.hasOwnProperty(c)&&(d.oldData.hasOwnProperty(c)||(d.oldData[c]=a.oldData[c]),d.newData[c]=a.newData[c])}else if(s.push(a),a.isRemoveAction&&((t=a.modelList)!=null&&t.length))for(const o of a.modelList)n.delete(o);this[Ke]=s,this.inputGeneration=Math.max(...s.map(a=>{var o;return(o=a.isUserInput)!=null?o:0}),0)}mergeAddUpdateModelActions(){const i=this[Ke],e=new Set,t=[];for(const r of i)r.isAddAction||r.isInsertAction?r.modelList.forEach(n=>e.add(n)):r.isInsertChildAction&&r.childModels.forEach(n=>e.add(n)),(r.isUpdateAction||r.isEventUpdateAction)&&e.has(r.model)||t.push(r);this[Ke]=t,this.inputGeneration=Math.max(...t.map(r=>{var n;return(n=r.isUserInput)!=null?n:0}),0)}invert(){const i=new this.constructor({...this.initialConfig,title:this.title});return i[Ke]=this[Ke].map(e=>tF(e)),i}groupUserInput(){return this[Ke].reduce((i,e)=>{var t;const r=(t=e.isUserInput)!=null?t:"default";return i.has(r)||i.set(r,[]),i.get(r).push(e),i},new Map)}getUserInput(i){const e=new Map,t={},r=this.groupUserInput().get(i!=null?i:this.inputGeneration||"default"),n=(s,a)=>(a in t?s in t[a]||(t[a][s]=[]):t[a]={[s]:[]},t[a][s]);for(const s of r)switch(s.type){case wt.ADD:case wt.INSERT:{s.inversed?n("removed",s.store.id).push(...s.modelList):n("added",s.store.id).push(...s.modelList);break}case wt.REMOVE:case wt.REMOVE_ALL:{s.inversed?n("added",s.store.id).push(...s.modelList||s.allRecords):n("removed",s.store.id).push(...s.modelList||s.allRecords);break}case wt.INSERT_CHILD:{for(const a of s.stores)s.childModels.forEach(o=>{if(a.added.includes(o))n("added",a.id).push(o);else if(a.removed.includes(o))n("removed",a.id).push(o);else{const l=o.hierarchyModificationDataToWrite;l&&(e.has(o)?e.set(o,{...e.get(o),...l}):e.set(o,l))}});break}case wt.REMOVE_CHILD:{for(const a of s.stores)s.inversed?n("added",a.id).push(...s.childModels):n("removed",a.id).push(...s.childModels);break}case wt.UPDATE:case wt.EVENT_UPDATE:{e.has(s.model)?e.set(s.model,{...e.get(s.model),...s.newData}):e.set(s.model,{...s.newData});break}default:break}if(e.size>0&&(t.updated=e),Object.keys(t).length>0)return t}markCurrentTransactionContentUserInput(){const i=this.inputGeneration+1,e=this[Ke];let t=!1;e.forEach(r=>{r.isUserInput===void 0&&!r.isCalculated&&(r.isUserInput=i,t=!0)}),t&&(this.inputGeneration=i)}markCurrentTransactionContentCalculated(){const i=this.inputGeneration;this[Ke].forEach(t=>{t.isCalculated===void 0&&!t.isUserInput&&(t.isCalculated=i)})}normalizeUserInputGeneration(){this[Ke].forEach(i=>i.isUserInput=this.inputGeneration)}};Jt._$name="Transaction";var Dv=class extends an{canUndo(i){return 0<i.position&&i.position<=i.length}canRedo(i){return 0<=i.position&&i.position<i.length}canCheckoutTo(i,e){return i.revisionsEnabled?i[Xe].includes(e)?!0:(console.warn("Revision is not found"),!1):(console.warn("Revisions are disabled"),!1)}onUndo(i,e){let t=i.position;const r=i[jt],n=Math.max(0,t-e),s=()=>{i.notifyStoresAboutStateRestoringStart();const a=[];for(;t!==n;){const o=r[--t];o.undo(),a.push(o)}return[i.autoRecord?"autoreadystate":"readystate",()=>{i.notifyStoresAboutStateRestoringStop({cause:"undo",transactions:a})}]};return[{[xe]:"restoringstate",[_i]:n},s]}onRedo(i,e){let t=i.position;const r=i[jt],n=Math.min(r.length,t+e),s=()=>{i.notifyStoresAboutStateRestoringStart();const a=[];do{const o=r[t++];o.redo(),a.push(o)}while(t!==n);return[i.autoRecord?"autoreadystate":"readystate",()=>{i.notifyStoresAboutStateRestoringStop({cause:"redo",transactions:a})}]};return[{[xe]:"restoringstate",[_i]:n},s]}onCheckoutTo(i,e){const t=i[Xe].indexOf(e),r=Math.min(t,i[Vt]),n=Math.max(t,i[Vt]),s=t<i[Vt];let a=i[ot].slice(r,n);return s&&(a=a.filter(l=>!l.conflictResolutionFor||l.type===on.TEMPORARY).reverse(),i[ot].filter((l,d)=>d>=r&&l.dummy).forEach(l=>{i[ot].splice(i[ot].indexOf(l),1),i[Xe].splice(i[Xe].indexOf(l.title),1)})),[{[xe]:"checkoutstate",[Vt]:t},()=>{i.notifyStoresAboutCheckoutStart();for(const o of a)o[s?"undo":"redo"]()}]}onCheckoutToHead(i){ie()}onEnable(){ie()}onDisable(){return"disabledstate"}onAutoRecordOn(){return{[xe]:"autoreadystate",[Pi]:!0}}onAutoRecordOff(){ie()}onStartTransaction(i,e){const t=new Jt({title:e});return[{[xe]:"recordingstate",[Ae]:t},()=>{i.notifyStoresAboutStateRecordingStart(t)}]}onStopTransaction(){ie()}onStopTransactionDelayed(){ie()}onRejectTransaction(){ie()}onResetQueue(i,e){return Lf(i,e)}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}},OE=new Dv,zf=OE;Qt.registerStmState("readystate",OE);var Nf=class extends an{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onEnable(){}onDisable(i){const e=i[Ae];return i.notifyStoresAboutStateRecordingStop(e,{disabled:!0}),{[xe]:"disabledstate",[Ae]:null}}onAutoRecordOn(i){return[{[xe]:"autorecordingstate",[Pi]:!0},()=>{i.stopTransactionDelayed()}]}onAutoRecordOff(){ie()}onStartTransaction(){ie()}onStopTransaction(i,e){const t=i[Ae],r=i[jt];let n=i[_i];return t.length&&(!t.title&&!e&&i.getTransactionTitle?t.title=i.getTransactionTitle(t):e&&(t.title=e),r[n]=t,r.length=++n),[{[xe]:"readystate",[_i]:n,[Ae]:null},()=>{i.notifyStoresAboutStateRecordingStop(t,{stop:!0})}]}onRejectTransaction(i){const e=i[Ae];return[{[xe]:"restoringstate",[Ae]:null},()=>(e.length&&e.undo(),["readystate",()=>{i.notifyStoresAboutStateRecordingStop(e,{rejected:!0})}])]}onStopTransactionDelayed(){ie()}onResetQueue(i,e){return Lf(i,e)}onModelUpdate(i,e,t,r,n){i[Ae].addAction(i.makeModelUpdateAction(e,t,r,n))}onModelInsertChild(i,e,t,r,n,s){const a=i[Ae],o=e.stores.filter(l=>i.stores.includes(l));a.addAction(i.makeModelInsertChildAction(e,t,r,n,s,o))}onModelRemoveChild(i,e,t,r){const n=i[Ae],s=e.stores.filter(a=>i.stores.includes(a));n.addAction(i.makeModelRemoveChildAction(e,t,r,s))}onStoreModelAdd(i,e,t,r){i[Ae].addAction(i.makeStoreModelAddAction(e,t,r))}onStoreModelInsert(i,e,t,r,n,s){const a=i[Ae],o=i.makeStoreModelInsertAction(e,t,r,n,s);o.reportUndoneRemoval=!i.revisionsEnabled,a.addAction(o)}onStoreModelRemove(i,e,t,r,n){i[Ae].addAction(i.makeStoreModelRemoveAction(e,t,r,n))}onStoreRemoveAll(i,e,t,r){i[Ae].addAction(i.makeStoreRemoveAllAction(e,t,r))}},$E=new Nf,iF=$E;Qt.registerStmState("recordingstate",$E);var BE=class extends an{canUndo(){return!1}canRedo(){return!1}canCheckoutTo(){return!1}onUndo(){ie()}onRedo(){ie()}onEnable(){ie()}onDisable(){ie()}onAutoRecordOn(){return{[Pi]:!0}}onAutoRecordOff(){return{[Pi]:!1}}onStartTransaction(){ie()}onStopTransaction(){ie()}onStopTransactionDelayed(){ie()}onRejectTransaction(){ie()}onQueueReset(){ie()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}};v(BE,"$name","RestoringStateClass");var HE=new BE,jE=HE;Qt.registerStmState("restoringstate",HE);var rF=class extends Dv{onAutoRecordOn(){ie()}onAutoRecordOff(){return{[xe]:"readystate",[Pi]:!1}}onStartTransaction(i,e){const t=new Jt({title:e});return[{[xe]:"autorecordingstate",[Ae]:t},()=>{i.notifyStoresAboutStateRecordingStart(t),i.stopTransactionDelayed()}]}onModelUpdate(i,e,t,r){i.startTransaction(),i.onModelUpdate(e,t,r)}onModelInsertChild(i,e,t,r,n){i.startTransaction(),i.onModelInsertChild(e,t,r,n)}onModelRemoveChild(i,e,t,r){i.startTransaction(),i.onModelRemoveChild(e,t,r)}onStoreModelAdd(i,e,t,r){i.startTransaction(),i.onStoreModelAdd(e,t,r)}onStoreModelInsert(i,e,t,r,n,s){i.startTransaction(),i.onStoreModelInsert(e,t,r,n,s)}onStoreModelRemove(i,e,t,r,n){i.startTransaction(),i.onStoreModelRemove(e,t,r,n)}onStoreRemoveAll(i,e,t,r){i.startTransaction(),i.onStoreRemoveAll(e,t,r)}},VE=new rF,wv=VE;Qt.registerStmState("autoreadystate",VE);var nF=class extends Nf.mixin(ve){onDisable(i){const e=i[Ae],t=i[fi];return t&&this.clearTimeout(t),i.notifyStoresAboutStateRecordingStop(e,{disabled:!0}),{[xe]:"disabledstate",[Ae]:null,[fi]:null}}onAutoRecordOn(i){ie()}onAutoRecordOff(i){const e=i[fi];return e&&this.clearTimeout(e),{[xe]:"recordingstate",[Pi]:!1,[fi]:null}}onStopTransaction(i,e){const t=i[Ae],r=i[fi],n=i[jt];let s=i[_i];return r&&this.clearTimeout(r),t.length&&(!t.title&&!e&&i.getTransactionTitle?t.title=i.getTransactionTitle(t):e&&(t.title=e),n[s]=t,n.length=++s),[{[xe]:"autoreadystate",[_i]:s,[Ae]:null,[fi]:null},()=>{i.notifyStoresAboutStateRecordingStop(t,{stop:!0})}]}onStopTransactionDelayed(i){let e=i[fi];return e&&this.clearTimeout(e),e=this.setTimeout(()=>{i.stopTransaction()},i.autoRecordTransactionStopTimeout),{[xe]:Ev,[fi]:e}}onResetQueue(i,e){return Lf(i,e)}onRejectTransaction(i){const e=i[Ae],t=i[fi];return t&&this.clearTimeout(t),[{[xe]:"restoringstate",[Ae]:null,[fi]:null},()=>(e.length&&e.undo(),["autoreadystate",()=>{i.notifyStoresAboutStateRecordingStop(e,{rejected:!0})}])]}onModelUpdate(i,...e){super.onModelUpdate(i,...e),i.stopTransactionDelayed()}onModelInsertChild(i,...e){super.onModelInsertChild(i,...e),i.stopTransactionDelayed()}onModelRemoveChild(i,...e){super.onModelRemoveChild(i,...e),i.stopTransactionDelayed()}onStoreModelAdd(i,...e){super.onStoreModelAdd(i,...e),i.stopTransactionDelayed()}onStoreModelInsert(i,...e){super.onStoreModelInsert(i,...e),i.stopTransactionDelayed()}onStoreModelRemove(i,...e){super.onStoreModelRemove(i,...e),i.stopTransactionDelayed()}onStoreRemoveAll(i,...e){super.onStoreRemoveAll(i,...e),i.stopTransactionDelayed()}},Ev=new nF,sF=Ev;Qt.registerStmState("autorecordingstate",Ev);var aF=class extends Dv{canUndo(i){return!1}canRedo(i){return!1}onUndo(i){ie()}onRedo(i){ie()}onStartRevision(i,e){const t=new Jt({title:e});return[{[xe]:"revisionrecordingstate",[Ae]:t},()=>{i.notifyStoresAboutRevRecordingStart()}]}onStartTemporaryRevision(i,e,t){const r=new Jt({title:e});return t&&(r[Ke]=t[Ke].slice()),[{[xe]:"temporaryrevisionrecordingstate",[Ae]:r},()=>{i.notifyStoresAboutTempRevRecordingStart()}]}onCheckoutToHead(i){return i.notifyStoresAboutCheckoutToHead({revision:i[Xe][i[Xe].length-1]}),i.autoRecord?"autoreadystate":"readystate"}onStartTransaction(i){ie()}onStopTransaction(i){ie()}onStopTransactionDelayed(i){ie()}onRejectTransaction(i){ie()}onEnable(i){ie()}onDisable(i){ie()}onAutoRecordOn(i){ie()}onAutoRecordOff(i){ie()}onResetQueue(i){ie()}onModelUpdate(){}onModelInsertChild(){}onModelRemoveChild(){}onStoreModelAdd(){}onStoreModelInsert(){}onStoreModelRemove(){}onStoreRemoveAll(){}},zE=new aF,xv=zE;Qt.registerStmState("checkoutstate",zE);var oF=class extends Nf{canUndo(i){return!1}canRedo(i){return!1}canCheckoutTo(){return!1}onUndo(i){ie()}onRedo(i){ie()}onCheckoutToHead(i){ie()}onStopRevision(i,e){const t=i[Ae],r=i[ot],n=i[Xe],s=i[Vt]+1,a=Jt.createTransactionWithOriginalInput(t);return n.splice(s,0,a.title),r.splice(s-1,0,a),i.commitRevision(a.title),[{[xe]:"checkoutstate",[Vt]:s,[Ae]:null},()=>{i.notifyStoresAboutRevRecordingStop(a)}]}onStartTransaction(i){ie()}onStopTransaction(i){ie()}onStopTransactionDelayed(i){ie()}onRejectTransaction(i){ie()}onEnable(i){ie()}onDisable(i){ie()}onAutoRecordOn(i){ie()}onAutoRecordOff(i){ie()}onResetQueue(i){ie()}},NE=new oF,WE=NE;Qt.registerStmState("revisionrecordingstate",NE);var lF=class extends Nf{canUndo(i){return!1}canRedo(i){return!1}canCheckoutTo(){return!1}onUndo(i){ie()}onRedo(i){ie()}onCheckoutToHead(i){ie()}onStopRevision(i,e){const t=i[Ae];return[{[xe]:"checkoutstate",[Ae]:null},()=>{i.notifyStoresAboutTempRevRecordingStop(t)}]}onStartTransaction(i){ie()}onStopTransaction(i){ie()}onStopTransactionDelayed(i){ie()}onRejectTransaction(i){ie()}onEnable(i){ie()}onDisable(i){ie()}onAutoRecordOn(i){ie()}onAutoRecordOff(i){ie()}onResetQueue(i){ie()}},UE=new lF,GE=UE;Qt.registerStmState("temporaryrevisionrecordingstate",UE);var Ue=(i,e,...t)=>{const r=i.state,n=e.call(i[xe],i,...t);if(typeof n=="string")i[xe]=Qt.resolveStmState(n);else if(n instanceof an)i[xe]=n;else if(Array.isArray(n)){const[s,a]=n;typeof s=="string"?i[xe]=Qt.resolveStmState(s):s instanceof an?i[xe]=s:s&&typeof s=="object"&&(i=Object.assign(i,s),i[xe]=Qt.resolveStmState(i[xe])),typeof a=="function"&&Ue(i,a,...t)}else n&&typeof n=="object"&&(i=Object.assign(i,n),i[xe]=Qt.resolveStmState(i[xe]));r!==zf&&r!==wv&&n!==zf&&n!==wv&&i.trigger("ready")},ln=class extends Ve($){static get defaultConfig(){return{disabled:!0,autoRecord:!1,autoRecordTransactionStopTimeout:100,autoRecordMergeUpdateActions:!0,mergeAddUpdateActions:!1,makeModelUpdateAction:qA,makeModelInsertChildAction:KA,makeModelRemoveChildAction:XA,makeStoreModelAddAction:ZA,makeStoreModelInsertAction:QA,makeStoreModelRemoveAction:JA,makeStoreRemoveAllAction:eF,getTransactionTitle:null,revisionsEnabled:!1,asyncUndoRedo:!1,revisionLocalPrefix:"local-",revisionQueueMaxLength:20,revisionQueueCommittedMinLength:1}}construct(...i){Object.assign(this,{[xe]:zf,[hi]:[],[jt]:[],[_i]:0,[Ae]:null,[fi]:null,[Pi]:!1,[rc]:!1,stashedTransactions:{}}),super.construct(...i)}get state(){return this[xe]}get position(){return this[_i]}get length(){return this[jt].length}get stores(){return Array.from(this[hi])}hasStore(i){return this[hi].includes(i)}addStore(i){this.hasStore(i)||(this[hi].push(i),i.stm=this,i.forEach(e=>e.stm=this),i.isTree&&(i.rootNode.stm=this))}removeStore(i){this.hasStore(i)&&(this[hi]=this[hi].filter(e=>e!==i),i.stm=null,i.forEach(e=>e.stm=null))}forEachStore(i){this[hi].forEach(e=>i(e,e.id))}get disabled(){return this.state===YA}set disabled(i){const e=this;e.disabled!==i&&(i?Ue(e,e.state.onDisable,e):Ue(e,e.state.onEnable,e),e.trigger("stmDisabled",{disabled:i}),e.trigger("disabled",{disabled:i}))}get enabled(){return!this.disabled}enable(){this.disabled=!1}disable(){this.disabled=!0}get isReady(){return this.state===zf||this.state===wv}waitForReadiness(){return this.await("ready",!1)}get isRecording(){return this.state===iF||this.state===sF}get isApplyingStash(){return this[rc]}get shouldRecordAction(){return this.enabled&&(!this.isRestoringState||this.isApplyingStash)&&!this.isCheckingOut}get autoRecord(){return this[Pi]}set autoRecord(i){const e=this;e.autoRecord!=i&&(i?Ue(e,e.state.onAutoRecordOn,e):Ue(e,e.state.onAutoRecordOff,e))}startTransaction(i=null){Ue(this,this.state.onStartTransaction,i)}stopTransaction(i=null){const e=this;e.autoRecord&&e.autoRecordMergeUpdateActions&&e.mergeTransactionUpdateActions(),e.mergeAddUpdateActions&&e.mergeTransactionAddUpdateActions(),Ue(e,e.state.onStopTransaction,i)}stopTransactionDelayed(){Ue(this,this.state.onStopTransactionDelayed)}rejectTransaction(){Ue(this,this.state.onRejectTransaction)}get transaction(){return this[Ae]}get queue(){return this[jt].map(i=>i.title)}get rawQueue(){return this[jt]}get isRestoringState(){return this.state===jE}get isRestoring(){return this.state===jE||this.isApplyingStash||this.isNavigatingRevisions}get canUndo(){return this.state.canUndo(this)}get canRedo(){return this.state.canRedo(this)}async undo(i=1){this.isReady||await this.waitForReadiness(),Ue(this,this.state.onUndo,i)}async undoAll(){this.isReady||await this.waitForReadiness(),this.undo(this.length)}async redo(i=1){this.isReady||await this.waitForReadiness(),Ue(this,this.state.onRedo,i)}async redoAll(){this.isReady||await this.waitForReadiness(),this.redo(this.length)}resetQueue(i={undo:!0,redo:!0,revision:!0}){Ue(this,this.state.onResetQueue,i)}resetUndoQueue(){this.resetQueue({undo:!0})}resetRedoQueue(){this.resetQueue({redo:!0})}resetRevisionQueue(){this.resetQueue({revision:!0})}notifyStoresAboutStateRecordingStart(i){this.forEachStore(e=>{var t;return(t=e.onStmRecordingStart)==null?void 0:t.call(e,this,i)}),this.trigger("recordingStart",{stm:this,transaction:i})}notifyStoresAboutStateRecordingStop(i,e){const t=this;t.forEachStore(r=>{var n;return(n=r.onStmRecordingStop)==null?void 0:n.call(r,t,i,e)}),t.trigger("recordingStop",{stm:t,transaction:i,reason:e}),t.revisionsEnabled&&e.stop&&t.increaseRevision(Jt.from([i]))}notifyStoresAboutStateRestoringStart(){this.forEachStore(i=>{var e;return(e=i.onStmRestoringStart)==null?void 0:e.call(i,this)}),this.trigger("restoringStart",{stm:this})}notifyStoresAboutStateRestoringStop({cause:i,transactions:e}){const t=this;if(t.forEachStore(r=>{var n;return(n=r.onStmRestoringStop)==null?void 0:n.call(r,t)}),t.trigger("restoringStop",{stm:t,cause:i,transactions:e}),t.revisionsEnabled)if(t.asyncUndoRedo){const r=()=>{const n=Jt.from(e);t.increaseRevision(i==="undo"?n.invert():n)};t.trigger("increaseRevisionAsync",{callback:r})}else{const r=Jt.from(e);t.increaseRevision(i==="undo"?r.invert():r)}}notifyStoresAboutQueueReset(i){this.forEachStore(e=>{var t;return(t=e.onStmQueueReset)==null?void 0:t.call(e,this,i)}),this.trigger("queueReset",{stm:this,options:i})}notifyStoresAboutCheckoutStart(){this.trigger("checkoutStart",{stm:this})}notifyStoresAboutRevRecordingStart(){this.trigger("revisionRecordingStart",{stm:this})}notifyStoresAboutTempRevRecordingStart(){this.trigger("temporaryRevisionRecordingStart",{stm:this})}notifyStoresAboutRevRecordingStop(i){this.trigger("revisionRecordingStop",{stm:this,revision:i.title})}notifyStoresAboutTempRevRecordingStop(i){this.trigger("temporaryRevisionRecordingStop",{stm:this,revision:i.title})}notifyStoresAboutCheckoutToHead({revision:i}){this.trigger("checkoutToHead",{stm:this,revision:i})}onModelUpdate(i,e,t,r){Ue(this,this.state.onModelUpdate,i,e,t,r)}onModelInsertChild(i,e,t,r,n){Ue(this,this.state.onModelInsertChild,i,e,t,r,n)}onModelRemoveChild(i,e,t){Ue(this,this.state.onModelRemoveChild,i,e,t)}onStoreModelAdd(i,e,t){Ue(this,this.state.onStoreModelAdd,i,e,t)}onStoreModelInsert(i,e,t,r,n){Ue(this,this.state.onStoreModelInsert,i,e,t,r,n)}onStoreModelRemove(i,e,t,r){Ue(this,this.state.onStoreModelRemove,i,e,t,r)}onStoreRemoveAll(i,e,t){Ue(this,this.state.onStoreRemoveAll,i,e,t)}onUndoKeyPress(i){const e=this;e.enabled&&(i.shiftKey?e.canRedo&&(i.preventDefault(),e.redo()):e.canUndo&&(i.preventDefault(),e.undo()))}stash(){const i=this;if(i.transaction){const e=Mi.generateId("_stashedTransactionGeneratedId_");return i.stashedTransactions[e]=i.transaction,i.rejectTransaction(),e}}applyStash(i){const e=this,t=e.stashedTransactions[i];e[rc]=!0,t&&(e.startTransaction(t.title),t.redo(),delete e.stashedTransactions[i]),e[rc]=!1}mergeTransactionUpdateActions(i=this.transaction){i.mergeUpdateModelActions()}mergeTransactionAddUpdateActions(i=this.transaction){i.mergeAddUpdateModelActions()}canCheckoutTo(i){return(this.isReady||this.state===xv)&&this.state.canCheckoutTo(this,i)}get currentRevision(){if(this.revisionsEnabled)return this[Xe][this[Vt]]}get lastRevision(){if(this.revisionsEnabled)return this[Xe][this[Xe].length-1]}get currentRevisionTransaction(){if(this.revisionsEnabled)return this[ot][this[Vt]-1]}get lastCommittedRevision(){const i=this[ot];let e;for(let t=i.length-1;t>=0;t--)if(i[t].committed){e=i[t];break}return e}get lastCommittedRevisionId(){var i,e;return(e=(i=this.lastCommittedRevision)==null?void 0:i.title)!=null?e:this[Xe][0]}get localRevisions(){return this[ot].slice(this[ot].findIndex(i=>!i.committed))}get isCheckingOut(){return this.state===xv}get isRecordingRevision(){return this.state===WE}get isRecordingTemporaryRevision(){return this.state===GE}get isNavigatingRevisions(){return this.state===xv||this.state===WE||this.state===GE}initRevision(i,e=!0){const t=this;t.revisionsEnabled&&(t.autoRecord=e,t[Xe]=[i],t[ot]=[],t[Vt]=0)}increaseRevision(i,e){const t=this;let r;if(!t.revisionsEnabled)return;if(t.isNavigatingRevisions&&!i.type)throw new ic("Cannot add new revision when in the checkout state");if(!i[Ke].length&&!i.type)return;const n=Mi.generateId(t.revisionLocalPrefix);if(i.title=n,t.trigger("beforeRevisionAdd",{localRevisionId:n})===!1)return;const s=i.conflictResolutionFor&&t[ot].find(o=>o.type===on.TEMPORARY&&o.conflictResolutionFor===i.conflictResolutionFor);if(s?(t[Xe].splice(t[Xe].indexOf(s.title),1,n),t[ot].splice(t[ot].indexOf(s),1,i)):(t[Xe].push(n),t[ot].push(i)),i.conflictResolutionFor||(t[Vt]=t[Xe].length-1),i.type===on.TEMPORARY)return;i.filterUserInput&&(i.conflictResolutionFor||i.normalizeUserInputGeneration(),r=i.getUserInput()),!e&&t[ot].length>t.revisionQueueMaxLength&&!i.type&&t.cleanUpRevisions();const a={localRevisionId:n,userInput:r};i.conflictResolutionFor&&(a.conflictResolutionFor=i.conflictResolutionFor,a.revisionChanges=e),t.trigger("revisionAdd",a)}createDataCorrectionTransaction(){const i=new Jt({type:on.DATA_CORRECTION});this.increaseRevision(i)}createConflictResolutionRevision(i,e,t){const{transaction:r}=this;if(t=T.clone(t),e){const n=this[ot].find(s=>s.conflictResolutionFor===e);n&&(n.conflictResolutionFor=i)}this.increaseRevision(Jt.from([r],{conflictResolutionFor:i!=null?i:r.title,type:on.CONFLICT_RESOLUTION}),t)}createTemporaryConflictResolutionRevision(i,e){const{transaction:t}=this;this.increaseRevision(Jt.from([t],{conflictResolutionFor:i!=null?i:t.title,type:on.TEMPORARY}),e)}checkoutTo(i){if(!this.canCheckoutTo(i))return!1;Ue(this,this.state.onCheckoutTo,i)}checkoutToLastCommittedRevision(){this.checkoutTo(this.lastCommittedRevisionId)}checkoutToHead(){this.checkoutTo(this[Xe][this[Xe].length-1]),Ue(this,this.state.onCheckoutToHead)}checkoutToNext(){return this[Vt]+1<this[Xe].length?this.checkoutTo(this[Xe][this[Vt]+1]):!1}startRevision(i){Ue(this,this.state.onStartRevision,i)}stopRevision(){Ue(this,this.state.onStopRevision)}startTemporaryRevision(i,e){Ue(this,this.state.onStartTemporaryRevision,i,e)}stopTemporaryRevision(){Ue(this,this.state.onStopRevision)}commitRevision(i,e){const t=this[Xe],r=this[ot],n=r.find(s=>s.title===i);for(let s=r.indexOf(n)-1;s>=0;s--)if(r[s].committed===!1&&r[s].type!==on.TEMPORARY&&!r[s].conflictResolutionFor)throw new ic(`Cannot commit revision because it is preceded by an uncommitted rev id ${r[s].title}`,r);if(e){if(t.includes(e))throw new ic(`Proposed revision id (${e}) already exists`);n.title=t[t.indexOf(n.title)]=e,r.forEach(s=>{s.type===on.TEMPORARY&&s.conflictResolutionFor===i&&(s.conflictResolutionFor=e)})}n.committed=!0}cleanUpRevisions(i=this.revisionQueueCommittedMinLength){const e=this[Xe],t=this[ot],r=[];for(let n=0;n<t.length;n++){const s=t[n];if(s.committed)r.push(s);else break}r.splice(Math.max(0,r.length-1-i),Math.min(r.length,i)),t.splice(0,r.length),e.splice(1,r.length)}markCurrentTransactionContentUserInput(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentUserInput()}markCurrentTransactionContentCalculated(){(this.isRecording||this.isRecordingRevision||this.isRecordingTemporaryRevision)&&this.transaction.markCurrentTransactionContentCalculated()}};v(ln,"$name","StateTrackingManager"),ln._$name="StateTrackingManager";var YE=i=>{var e;return e=class extends(i||$){changeStm(t,r){var n;return(n=r==null?void 0:r.hasStore)!=null&&n.call(r,this)&&r.removeStore(this),t&&(t.isStateTrackingManager||(t=new ln(t)),t.hasStore(this)||t.addStore(this)),t}add(t,r=!1,n={}){let s;const{stm:a}=this;return!this.tree&&(a!=null&&a.shouldRecordAction)?(s=super.add(t,r,n),s!=null&&s.length&&a.onStoreModelAdd(this,s,r)):s=super.add(t,r,n),s}insert(t,r,n=!1){let s;const{stm:a}=this;if(!this.tree&&(a!=null&&a.shouldRecordAction)){const o=(Array.isArray(r)?r:[r]).reduce((l,d)=>{const c=d instanceof he?this.indexOf(d):void 0;return c!==void 0&&c!==-1&&l.set(d,c),l},new Map);s=super.insert(t,r),s!=null&&s.length&&(t=this.indexOf(s[0]),a.onStoreModelInsert(this,t,s,o,n))}else s=super.insert(t,r,n);return s}remove(t,r=!1,n){let s;const{stm:a}=this;if(!this.tree&&(a!=null&&a.shouldRecordAction)){const l=(Array.isArray(t)?t:[t]).map(d=>this.getById(d)).filter(d=>!!d).reduce((d,c)=>{const u=this.indexOf(c);return u!==void 0&&u!==-1&&d.set(c,u),d},new Map);s=super.remove(t,r,n),s!=null&&s.length&&a.onStoreModelRemove(this,s,l,r)}else s=super.remove(t,r,n);return s}removeAll(t){const{stm:r}=this;let n;if(r!=null&&r.shouldRecordAction){const{tree:s,rootNode:a,allRecords:o}=this,l=o.length,d=s?a.children.slice():o.slice();n=super.removeAll(t),l&&this.count===0&&r.onStoreRemoveAll(this,d,t)}else n=super.removeAll(t);return n}beforeApplyChangeset(){const{stm:t,crudManager:r}=this;let n=!1,s=null;return!(r!=null&&r.applyingChangeset)&&(t!=null&&t.enabled)&&!t.isNavigatingRevisions&&(n=!0,t.isRecording&&(s=t.stash()),this.ignoreRemoteChangesInSTM?t.disable():t.startTransaction()),{shouldResume:n,transactionId:s}}applyChangeset(t,r,n,s,a){const{shouldResume:o,transactionId:l}=this.beforeApplyChangeset(),d=super.applyChangeset(t,r,n,s,a);return this.afterApplyChangeset(o,l),d}afterApplyChangeset(t,r){if(t){const{stm:n}=this;this.ignoreRemoteChangesInSTM?n.enable():n.stopTransaction(),n.applyStash(r)}}},v(e,"$name","StoreStm"),v(e,"configurable",{stm:null,ignoreRemoteChangesInSTM:!1}),e},Ga=class{static new(i){return new this(i)}constructor(i){this.promise=new Promise((e,t)=>{this.resolve=e,this.reject=t}),i&&i(this)}catch(i){return this.promise=this.promise.catch(i),this}finally(i){return this.promise=this.promise.finally(i),this}then(...i){return this.promise=this.promise.then(...i),this}};Ga._$name="Promissory";var Ya=class extends ee.mixin(ve){static get pluginConfig(){return{override:["updateAutoLoad"],assign:["load","isLoading","lazyGetAt"],after:["afterLoadData"],before:["setStoreData"]}}static get properties(){return{loadQueue:{}}}get isLoading(){return this.client._isLoading||Object.values(this.loadQueue).some(i=>T.isPromise(i))}get storage(){return this.client.storage}set totalCount(i){this._totalCount=i}get totalCount(){return this._totalCount}setEstimatedTotalCount(i){this.totalCount=i}afterConstruct(){const i=this,{client:e}=i;e.syncDataOnLoad&&(e.syncDataOnLoad=!1),i.storeListenersDetacher=e.ion({beforeAdd:"internalOnBeforeAdd",beforeRemove:"internalOnBeforeAdd",change:"internalOnChange",commit:"internalOnCommit",endApplyChangeset:"internalOnCommit",thisObj:i}),e.requestData||(e.requestData=i.requestData),e.autoLoad&&this.requestAnimationFrame(this.load)}updateAutoLoad(i){i&&!this.client.isAjaxStore&&this.load()}internalOnBeforeAdd(){if(this.isLoading)throw new Error("Removing or adding is not allowed when a lazy loaded Store is loading")}internalOnChange(){!this.$loadLock&&(this.client.added.count||this.client.removed.count)&&(this.$loadLock=new Ga)}internalOnCommit(){!this.client.changes&&this.$loadLock&&(this.$loadLock.resolve(),this.$loadLock=null)}afterLoadData(){this.totalCount&&(this.storage.values.length=this.totalCount)}setStoreData(i){this.client.records.filter(e=>e).length&&!(i!=null&&i.length)&&(this.totalCount=null,this.loadQueue={})}clearLoaded(){const{client:i}=this;i.suspendEvents(),this.totalCount=null,i.clear(!0),this.loadQueue={},i.resumeEvents()}async requestData({startIndex:i,count:e}){}lazyGetAt(i){return this.getAt(i)}async getAt(i){var e;const t=this,{loadQueue:r,totalCount:n}=t;if(i<0||n!=null&&i>n)return null;const s=t.getFromStorage(i);return s||(await((e=t.$loadLock)==null?void 0:e.promise),r[i]?await r[i]:await t.doLazyLoad(t.calculateRange(i)),t.getFromStorage(i))}getFromStorage(i){return this.storage.getAt(i)}calculateRange(i){const{totalCount:e,loadQueue:t,chunkSize:r}=this,n=Math.max(0,i-r),s=(e?Math.min(i+r,e):i+r)-1;let a=i,o=i;for(;a>n&&!t[a-1]&&!this.getFromStorage(a-1);)a-=1;for(;o<s&&!t[o+1]&&!this.getFromStorage(o+1);)o+=1;return{startIndex:a,count:o-a+1}}async doLazyLoad({startIndex:i,count:e}){this.triggerLazyLoadStart(arguments[0]);const t=this,{loadQueue:r}=t,n=i+e-1,s=t.client.requestData(arguments[0]);for(let d=i;d<=n;d++)r[d]=s;const a=await s;if(!a)return;const{[t.totalCountProperty]:o,[t.dataProperty]:l}=a;for(let d=i;d<=n;d++)r[d]=null;o!=null?t.totalCount=o:t.totalCount==null&&e>l.length&&t.setEstimatedTotalCount(i+l.length),t.addData(l,i),t.totalCount!=null&&(t.storage.values.length=t.totalCount),t.triggerLazyLoadEnd(arguments[0],l)}addData(i,e){const{client:t,storage:r}=this;if(!(i!=null&&i.length))return;if(!t.count&&!e){t.data=i;return}for(let a=i.length-1;a>=0;a--){const o=i[a],l=t.idRegister[o.id];l&&(l.setByDataSource(o,!0),l.internalClearChanges(!1,!0,o),i.splice(a,1))}if(!i.length)return;const{values:n}=r,s=t.processRecords(i,void 0,!0);n.length<e&&(n.length=e),e==null&&(e=n.length),n.splice(e,s.length,...s),t.joinRecordsToStore(s),t.updateDependentStores("add",s);for(const a of s)t.idMap[a.id]={index:e,visibleIndex:e,record:a},e+=1,r.addToIndices(a);t.trigger("change",{action:"lazyload",records:s})}checkDuplicates(i){const{storage:e}=this;for(const t of i){const r=e.indexOf(t.id);r>=0&&e.values.splice(r,1)}}triggerLazyLoadStart(i){const e=this;e.isLoading||(e.isConfiguring?e.delay(()=>e.trigger("lazyLoadStarted"),0):e.client.trigger("lazyLoadStarted")),e.client.trigger("beforeLazyLoad",{...i})}triggerLazyLoadEnd(i,e){this.isLoading||this.client.trigger("lazyLoadEnded"),this.client.trigger("afterLazyLoad",{...i,data:e})}load(i){return this.client.count>0&&this.clearLoaded(),this.getAt(0)}doDestroy(){var i;(i=this.storeListenersDetacher)==null||i.call(this),this.loadQueue={},super.doDestroy()}};v(Ya,"$name","StoreLazyLoadPlugin"),v(Ya,"configurable",{totalCountProperty:"total",dataProperty:"data",chunkSize:100}),Ya._$name="StoreLazyLoadPlugin";var dF=i=>{var e,t;return(t=(e=i.children)==null?void 0:e.reduce((r,n)=>{var s;return r+((s=n.remoteChildCount)!=null?s:0)+1},0))!=null?t:0},Rv=i=>dF(i)>=i.remoteChildCount,cF=i=>{var e;return e=class extends i{static get pluginConfig(){var t,r;const n={};for(const a in super.pluginConfig)n[a]=[...super.pluginConfig[a]];n.override=(t=n.override)!=null?t:[],n.override.push("loadChildren","getAt");const s=(r=n.assign)==null?void 0:r.indexOf("lazyGetAt");return s>=0&&n.assign.splice(s,1),n}constructor(){super(...arguments),this.totalCount=0}load(){const t=this,{rootNode:r}=t.client,n=t.loadQueue[r.id];return n?n===!0?(t.clearLoaded(),t.load()):n:t.doLazyLoad({parent:r,startIndex:0})}changeRemoteChildCount(t,r,n){var s;if(t!=null&&t.length){const a=t.map(o=>{var l,d,c;return(c=o.parent)!=null?c:this.client.getById((d=o.parentId)!=null?d:(l=o.originalData)==null?void 0:l.parentId)});for(;a.length;){const o=a.shift();o&&(o.isRoot||a.push(o.parent),o.remoteChildCount=(s=o.remoteChildCount?o.remoteChildCount+r:o.children.length)!=null?s:0,n.add(o))}}}internalOnCommit({changes:t}){super.internalOnCommit();const r=new Set;this.changeRemoteChildCount(t.added,1,r),this.changeRemoteChildCount(t.removed,-1,r),r.forEach(n=>{this.loadQueue[n.id]=Rv(n)})}loadChildren(t){return this.doLazyLoad({parent:t,startIndex:0})}getAt(t){var r;const n=this,{loadQueue:s,client:a}=n,o=a.records[t];if(o){const{parent:l}=o;o.expanded&&o.remoteChildCount>0&&!((r=o.children)!=null&&r.length)&&!s[o.id]&&n.doLazyLoad({parent:o,startIndex:0}),o===l.lastChild&&!s[l.id]&&n.doLazyLoad({startIndex:o.parentIndex+1,parent:l})}return o}async doLazyLoad({parent:t,...r}){var n;const s=this,{loadQueue:a,client:o}=s,{id:l}=t;t.instanceMeta(o).isLoadingChildren=!0,s.triggerLazyLoadStart(arguments[0]),a[l]=o.requestData({...r,parentId:t.isRoot?"root":l,count:s.chunkSize});const{[s.totalCountProperty]:d,[s.dataProperty]:c}=await a[l];t.isRoot&&d>=0&&(t.remoteChildCount=d),s.addData(c,t),s.totalCount=o.count,a[l]=Rv(t),s.isLoading||(n=o.trigger)==null||n.call(o,"refresh",{action:"lazyload"}),s.triggerLazyLoadEnd(arguments[0],c),t.instanceMeta(o).isLoadingChildren=!1}addData(t,r){const{client:n,loadQueue:s}=this;sn.preWalk({children:t},({children:a})=>a!=null&&a.length?a:null,a=>{const{id:o,children:l}=a;o&&a.remoteChildCount>0&&(a.expanded===!1&&!(l!=null&&l.length)?a.children=!0:l!=null&&l.length&&!s[o]&&Rv(a)?s[o]=!0:l||(a.children=[]))}),n.modelClass.fieldMap.remoteChildCount||n.modelClass.addField("remoteChildCount"),r.appendChild(t,!0),n.added.clear()}},v(e,"$name","TreeStoreLazyLoadPlugin"),v(e,"configurable",{chunkSize:50}),e},uF={splice:1,clear:1},hF={includeFilteredOutRecords:!1,includeCollapsedGroupRecords:!1},Tv=(i,e)=>(e=e||!1,typeof e=="boolean"&&(e={includeFilteredOutRecords:e,includeCollapsedGroupRecords:!1}),e||hF),Wf=Symbol("useRawDataUnset"),fF={enabled:!0,disableDuplicateIdCheck:!0,disableDefaultValue:!1,disableTypeConversion:!1},gF={enabled:!0,disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1},Uf=class qr extends $.mixin(ve,Ud,Ve,rv,_f,Qw,Zw,Xw,tE,iE,sE,aE,Jw,lE,dE,cE,YE,uE,eE){static get properties(){return{relationCache:{},dependentStoreConfigs:new Map,addingClean:!1}}static get defaultConfig(){return{fields:null,autoTree:!0,data:null,tree:!1,callOnFunctions:!0,storage:null,allowNoId:!0,preventSubClassingModel:null,storeClass:null}}static get identifiable(){return{registerGeneratedId:!1}}constructor(...e){if(super(...e),this.objectify)return this.initProxy()}construct(e={}){const t=this;Object.assign(t,{added:new Ff,removed:new Ff,modified:new Ff,idRegister:{},internalIdRegister:{},oldIdMap:{}}),super.construct(e),t.initRelations()}static from(e,t={},r=null){return e&&!e.isStore&&(typeof e=="string"?e=qr.getStore(e):(Array.isArray(e)?(r&&(e=e.map(n=>n.isModel?n:r(n))),e=T.assign({},t,{data:e})):e=T.assign({},t,e),e=new qr(e))),e}equals(e){return e.isStore&&e.$master===this.$master}doDestroy(){var e,t,r,n;const s=this,a=s.registeredRecords;(t=(e=s.stm)==null?void 0:e.removeStore)==null||t.call(e,s);for(let o=a.length-1,l;o>=0;o--)l=a[o],l!=null&&l.isDestroyed||l.unjoinStore(s);(r=s._storage)==null||r.destroy(),s.isChained?s.masterStore.isDestroying||H.remove(s.masterStore.chainedStores,s):(n=s.rootNode)==null||n.destroy(),super.doDestroy()}beginBatch(){this.suspendEvents()}endBatch(){if(this.resumeEvents()){const{values:e}=this.storage;this.trigger("refresh",{action:"batch",data:e,records:e})}}set storage(e){const t=this;e!=null&&e.isCollection?t._storage=e:t._storage=new Ii(e),t._storage.autoFilter=t.reapplyFilterOnAdd,t._storage.autoSort=t.reapplySortersOnAdd;for(const r of t._storage)r.joinStore(t);t._storage.ion({change:"onDataChange",thisObj:t})}get storage(){return this._storage||(this.storage={}),this._storage}get allRecords(){var e;const t=this;if(((e=t._allRecords)==null?void 0:e.generation)!==t.storage.generation){if(t.isTree){const r=t.collectDescendants(t.rootNode,void 0,void 0,{unfiltered:!0}).all;t.rootVisible&&r.unshift(t.rootNode),t._allRecords=r}else t._allRecords=t.isGrouped?t.collectGroupRecords(!0,!0):t.storage.allValues;t._allRecords.generation=t.storage.generation}return t._allRecords}getAllDataRecords(e){const t=this;return t.tree?e?t.allRecords:t.rootNode.allChildren:t.isGrouped?t.collectGroupRecords(e,!1):(e?t.storage.allValues:t.storage.values).filter(r=>r)}onIsCreatingToggle(e,t){const r=this,n=e.isPersistable&&!t;r.added[n?"add":"remove"](e),n&&(r.trigger("addConfirmed",{record:e}),r.autoCommit&&r.doAutoCommit())}joinRecordsToStore(e){const{totalCount:t}=this;for(let r=0;r<e.length;r++){const n=e[r];n.setData("parentIndex",t+r-e.length),n.joinStore(this)}}onDataChange({source:e,action:t,added:r,removed:n,replaced:s,oldCount:a,items:o,from:l,to:d}){const c=this,u=uF[t],h=u&&(r==null?void 0:r.length),f=u&&(n==null?void 0:n.length);let g,m;if(c._idMap=null,h&&c.joinRecordsToStore(r),s==null||s.forEach(([p,y])=>{p.unjoinStore(c,!0),y.joinStore(c)}),super.onDataChange(...arguments),!c.isTree){if(h){for(const p of r)c.removed.includes(p)?c.removed.remove(p):!c.addingClean&&!p.isLinked&&c.added.add(p);g=!c.remoteFilter&&c.isFiltered&&c.reapplyFilterOnAdd,g&&c.filter({silent:!0}),m=!c.remoteSort&&c.isSorted&&c.reapplySortersOnAdd,m&&c.sort(null,null,!1,!0)}if(f){for(const p of n)p.cancelBatch(),p.unjoinStore(c),c.added.includes(p)?(c.added.remove(p),p.isBeingMaterialized&&c.removed.add(p)):!p._undoingInsertion&&!p.isCreating&&!p.isLinked&&c.removed.add(p);c.modified.remove(n),g=!c.remoteFilter&&c.isFiltered,g&&c.filter({silent:!0})}}switch(t){case"clear":c.relationCache={},c.updateDependentStores("removeall"),c.trigger("removeAll"),c.trigger("change",{action:"removeall"});break;case"splice":if(h){c.updateDependentStores("add",r);const p=r.reduce((C,D)=>{const{previousIndex:S}=D.meta;return S>-1&&S<C&&(C=S),C},r[0].meta.previousIndex),y=e.indexOf(r[0],!e.autoFilter),b={records:r,index:y};p>-1&&(b.oldIndex=p),c.trigger("add",b),c.trigger("change",Object.assign({action:"add"},b)),g&&c.triggerFilterEvent({action:"filter",filters:c.filters,oldCount:a,records:c.storage.allValues}),m&&c.trigger("sort",{action:"sort",sorters:c.sorters,records:c.storage.allValues})}n.length&&(c.updateDependentStores("remove",n),c.trigger("remove",{records:n}),c.trigger("change",{action:"remove",records:n})),s.length&&(c.updateDependentStores("replace",s),c.trigger("replace",{records:s,all:c.records.length===s.length}),c.trigger("change",{action:"replace",replaced:s,all:c.records.length===s.length}));break;case"filter":(c.isGrouped||c.isSorted)&&c.performSort(!0);break;case"move":{const p=Math.min(l,d),y=Math.min(c.storage.allValues.length-1,Math.max(l,d));for(let b=c.storage.allValues,C=p;C<=y;C++)b[C].setData("parentIndex",C);c.trigger("move",{records:o,from:l,to:d}),c.isFiltered&&c.performFilter(),c.trigger("change",{action:t,record:o[0],records:o,from:l,to:d});break}}}onDataReplaced(e,t){var r,n;const s=this,{storage:a}=s,o=a.allValues,l=s.sorters.length>0;for(let c=0;c<o.length;c++)(r=o[c])==null||r.joinStore(s);if(!s.remoteFilter&&s.isFiltered&&s.filter({silent:!0}),s.remoteSort?s.isGrouped&&a.replaceValues({...s.prepareGroupRecords(),silent:!0}):(s.isGrouped&&s.group(null,null,!1,!l,!0),l&&s.sort(null,null,!1,!0)),!s.useRawData.disableDuplicateIdCheck){const{idMap:c}=s;if(Object.keys(c).length<a.values.length){const u=[];throw a.values.forEach(h=>c[h.id]?delete c[h.id]:u.push(h)),new Error(`Id collision on ${u.map(h=>h.id)}`)}}const d={action:e,data:t,records:a.values};s.updateDependentStores(e,d.records),(n=s.afterLoadData)==null||n.call(s),s.isRemoteDataLoading||s.trigger("refresh",d),s.trigger("change",d)}onModelChange(e,t,r,n,s){const a=this,o={record:e,records:[e],changes:r,batch:e.batching!=null,fromRelationUpdate:s};if(a.storage.onItemMutation(e,r),"id"in r){const{oldValue:d,value:c}=t.id;a.updateDependentRecordIds(d,c),a.onRecordIdChange({record:e,oldValue:d,value:c})}else e.meta._ignoreRelatedIdUpdate||a.updateDependentStores("update",[e],n);const l=e.ignoreBag||e.isLinked?!1:a.updateModifiedBagForRecord(e);if(a.onUpdateRecord(e,r),!n){if("id"in r){const{oldValue:d,value:c}=t.id;a.trigger("idChange",{store:a,record:e,oldValue:d,value:c})}a.trigger("update",o),a.trigger("change",Object.assign({action:"update"},o))}a.autoCommit&&l&&a.doAutoCommit()}updateModifiedBagForRecord(e){var t;const r=this,{modified:n,added:s}=r;return e.isModified&&!e.isRoot&&e.isPartOfStore(r)?(!n.includes(e)&&!s.includes(e)&&(e.isPhantom?s.add(e):n.add(e)),e.isBeingMaterialized&&(r.modifiedMaterialized=(t=r.modifiedMaterialized)!=null?t:new Set,r.modifiedMaterialized.add(e)),!0):(n.remove(e),!1)}get idMap(){const e=this,t=!e._idMap,r=e._idMap||(e._idMap={});if(t){const n=e.storage.values;for(let s,a=0,o=0;a<n.length;a++)s=n[a],s&&(r[s.id]={index:a,visibleIndex:o,record:s}),s!=null&&s.isSpecialRow||o++;if(e.isFiltered)for(let s=0,a=e.storage._values.length;s<a;s++){const o=e.storage._values[s];o.id in r?r[o.id].unfilteredIndex=s:r[o.id]={index:-1,unfilteredIndex:s,record:o}}}return r}changeModelClass(e){const{fields:t}=this;this.originalModelClass=e;let r=e;if(t!=null&&t.length){class n extends e{static get fields(){return t}}r=n}else if(!this.preventSubClassingModel){class n extends e{}r=n}return r.initClass(),r}changeLazyLoad(e){const t=this;let r=t.constructor.$lazyLoadPluginClass;t.isTree&&(t.treeLazyLoadClass||(t.treeLazyLoadClass=class extends cF(r){}),r=t.treeLazyLoadClass);let n=t.getPlugin(r);if(e){const s=T.isObject(e);return n?s&&T.assign(n,e):n=t.addPlugin(r,s?e:null),n}else return n==null||n.destroy(),!1}changeId(e,t){return super.changeId(e!==!0&&e,t)}updateId(e,t){const r=qr.getById(e);r&&qr.unregisterInstance(r),super.updateId(e,t)}generateAutoId(){return qr.generateId("store-")}get tree(){return this._tree}set tree(e){this._tree=e,e&&!this.rootNode&&(this.rootNode=this.buildRootNode(),this.rootNode.isAutoRoot=!0)}buildRootNode(){return{}}static getStore(e,t){if(e instanceof qr)return e;if(this.getById(e))return this.getById(e);if(Array.isArray(e)){let r;const n=e.map(s=>(s instanceof he?r=s.constructor:typeof s=="string"&&(s={text:s}),s));if(!r){class s extends he{}r=s}e={autoCreated:!0,data:n,modelClass:r,allowNoId:!0},t||(t=qr)}if(t)return new t(e)}static get stores(){return qr.registeredInstances}get rootNode(){return this.masterStore?this.masterStore.rootNode:this._rootNode}set rootNode(e){var t;const r=this,n=r._rootNode;e!==n&&(n&&(r.clear(!0),r.removed.clear()),e instanceof he?(e.instanceMeta(r).collapsed=!1,r._rootNode=e):r._rootNode=e=new r.modelClass({expanded:!0,[r.modelClass.idField]:`${r.id}-rootNode`,...e},r,{isRoot:!0},!0),r._tree=!0,e.isRoot=!0,e.joinStore(r),((t=e.children)!=null&&t.length||r.rootVisible)&&(e.isLoading=!0,r.onNodeAddChild(e,e.children||[],0),e.isLoading=!1),r.trigger("rootChange",{oldRoot:n,rootNode:e}))}set data(e){this.setStoreData(e)}get data(){return this.getAllDataRecords(!0).map(e=>e.data)}setStoreData(e){const t=this,{idField:r,childrenField:n}=t.modelClass;if(e!=null&&e.length&&!Object.isExtensible(e[0])&&(t.transformFlatData||t.useRawData.enabled)&&(t.transformFlatData&&(t.useRawData=t.useRawData||{disableDuplicateIdCheck:!1,disableDefaultValue:!1,disableTypeConversion:!1}),e=T.clone(e)),t.getConfig("plugins"),t.processConfiguredListeners(),e&&!Array.isArray(e)&&(e=T.transformNamedObjectToArray(e,r)),t.tree=!t.isChained&&(t.tree||!!(t.autoTree&&(e!=null&&e.some(s=>s[n])))),e&&(t.remoteSort||t.remoteFilter))for(let s=0;s<e.length;s++)e[s]._remoteSortIndex=s;!t.syncDataOnLoad||!t._data?(t._data=e,t.tree?t.loadTreeData(e):t.loadData(e),t.added.clear(),t.removed.clear(),t.modified.clear()):t.syncDataset(e)}loadTreeData(e){const t=this,r=t.rootNode;if(t.transformFlatData&&(e=t.treeifyFlatData(e)),r.isLoading=!0,t.clear(!0),r.appendChild(e),t.updateDependentStores("dataset",[r]),r.isLoading=!1,e.length===0){const n={action:"dataset",data:[],records:[]};t.trigger("refresh",n),t.trigger("change",n)}else t.isFiltered&&t.filter()}loadData(e,t="dataset"){var r;const n=this,{storage:s,allowNoId:a}=n,o=n.modelClass.fieldMap.id.dataSource,l=n.find(c=>c.isCreating);l&&s.values.splice(n.records.indexOf(l),1);let d=n.verifyNoGeneratedIds;if(n.removeHeadersAndFooters(n.storage.values),n._idMap=null,n.oldIdMap={},e){const c=!(e[0]instanceof he),u=e.length,h=new Array(u);c&&n.modelClass.exposeProperties(e[0]);for(let f=0;f<u;f++){let g=e[f];if(c){const m=g[o];if(!a&&m==null)throw new Error(`Id required but not found on row ${f}`);d&&((r=m==null?void 0:m.startsWith)!=null&&r.call(m,"_generated"))&&(console.warn(`Generated id found in data: ${m}. Generated ids are temporary and should be replaced with real ids by the backend`),d=!1),g=n.createRecord(g,!0)}n.isFillingFromMaster||(g=n.processRecord(g,!0),g.setData("parentIndex",f)),h[f]=g}n.clear(!0),s.replaceValues({values:h,isNewDataset:!0,silent:!0}),l&&!s.values.includes(l)&&s.values.push(l),n._data=e,n.onDataReplaced(t,e)}else n.clear(!0),n._data=null;n.isSyncingDataOnLoad=!1}getRange(e,t,r=!0){return(r?this.storage.allValues:this.storage.values).slice(e,t)}createRecord(e,t=!1,r=!1){return new this._modelClass(e,this,null,t,!1,r)}processRecord(e,t=!1){return e}refreshData(){this.filter(),this.sort()}onRecordIdChange({record:e,oldValue:t,value:r}){const n=this,s=n._idMap,{idRegister:a,oldIdMap:o}=n;if(n.storage._indicesInvalid=!0,o[t]=e,s&&!s[r]){const l=s[t];delete s[t],s[r]=l}n.added.changeId(t,r),n.removed.changeId(t,r),n.modified.changeId(t,r),delete a[t],a[r]=e,e.index=n.storage.indexOf(e)}onUpdateRecord(e,t){var r;const n=this,{internalId:s}=t,{internalIdRegister:a,reapplyFilterOnUpdate:o}=n;s&&(this.storage._indicesInvalid=!0,delete a[s.oldValue],a[s.value]=e),(o===!0||(r=o.fields)!=null&&r.some(l=>l in t))&&n.isFiltered&&n.filter()}get useRawData(){var e;return this._useRawData===Wf?this.readUrl||(e=this.crudManager)!=null&&e.loadUrl?gF:{enabled:!1}:this._useRawData}changeUseRawData(e){return e===Wf?Wf:e===!0?fF:e?Object.assign(e,{enabled:!0}):{enabled:!1}}getCount(e=!0){var t,r,n;const s=this,{storage:a,groupRecords:o,isFiltered:l,isGrouped:d,isTree:c,rootNode:u}=s;if(typeof e=="boolean")return de.deprecate("core","7.0.0","getCount(true/false) deprecated in favor of getCount(options)"),e?s.count:a.totalCount-((o==null?void 0:o.count)||0);if(e.all)return this.allRecords.length;"visibleData"in e||(e.visibleData=!0);let h=0;const{visibleData:f,headersFooters:g,filteredOut:m,collapsed:p}=e,y=l?(t=o==null?void 0:o.values.reduce((C,D)=>C+(s.includes(D)?1:0),0))!=null?t:0:(r=o==null?void 0:o.count)!=null?r:0,b=a.count-y;if(f&&(h+=b),g&&d&&(l&&m?h+=(n=o.count)!=null?n:0:h+=y),m&&l&&(c?h+=u.getDescendantCount(!1,s,!0)-u.getDescendantCount(!1,s,!1):h+=a.allValues.length-a.values.length),p)if(d){let C=0;for(const D of s.collapsedGroups)C+=o.get(D).groupChildren.length;h+=C}else c&&(h+=u.descendantCount-b);return h}get count(){return this.storage.count}get originalCount(){var e;return de.deprecate("core","7.0.0","originalCount was deprecated in favor of getCount()"),this.storage.totalCount-(((e=this.groupRecords)==null?void 0:e.count)||0)}get allCount(){return de.deprecate("core","7.0.0","allCount was deprecated in favor of totalCount"),this.isTree?this.rootNode.descendantCount:this.storage.totalCount}get totalCount(){return this.getCount({all:!0})}get records(){return this.storage.values}get first(){return this.storage.values[0]}get last(){return this.storage.values[this.storage.values.length-1]}getAt(e,t=!1){return this.storage.getAt(e,t)}register(e){const t=this;if(!t.useRawData.disableDuplicateIdCheck){const r=t.isTree&&t.idRegister[e.id];if(r&&r!==e)throw new Error(`Id collision on ${e.id}`)}t.idRegister[e.id]=e,t.internalIdRegister[e.internalId]=e}unregister(e){delete this.idRegister[e.id],delete this.internalIdRegister[e.internalId]}get registeredRecords(){return Object.values(this.idRegister)}getById(e){const t=this;let r;e!=null&&e.isModel&&(r=e,e=r.id);const n=t.idRegister[e];if(r){if(r!=null&&r.hasLinks&&!n){const{allValues:s}=t.storage;return r.$links.find(a=>s.includes(a))}return r}return n}isAvailable(e){const t=this.getById(e);return t&&this.storage.includes(t)||!1}getByInternalId(e){return this.internalIdRegister[e]}includes(e){return this.isTree?this.idRegister[he.asId(e)]!=null:this.indexOf(e)>-1}indexOf(e,t=!1,r=!1){var n;if(e!=null&&e.isModel&&!((n=e.stores)!=null&&n.includes(this.$store||this))){const o=e.$links.find(l=>this.storage.allValues.includes(l));return o?this.indexOf(o,t):-1}if(this.isTree)return(r?this.rootNode.allChildren:this.storage.values).indexOf(this.getById(e));const s=he.asId(e);if(s==null)return-1;const a=this.idMap[s];return a?a[t?"visibleIndex":"index"]:-1}allIndexOf(e){return this.isTree?this.allRecords.indexOf(this.getById(e)):this.storage.indexOf(e,!0)}getDistinctValues(e,t=!1){const r=this,n=[],s={};let a;return r.forEach(o=>{if(!o.isSpecialRow&&!o.isRoot){a=o.getValue(e);const l=a instanceof Date?a.getTime():a;s[l]||(n.push(a),s[l]=1)}},r,{includeCollapsedGroupRecords:!0,includeFilteredOutRecords:t}),n}getValueCount(e,t){let r=0;return this.forEach(n=>{T.isEqual(n.getValue(e),t)&&r++}),r}set json(e){typeof e=="string"&&(e=O.safeJsonParse(e)),this.data=e}get json(){return O.safeJsonStringify(this)}get formattedJSON(){return O.safeJsonStringify(this,null,4)}toJSON(){const e=this,{persistable:t,dataSource:r}=e.modelClass.getFieldDefinition("expanded");return(e.isTree?e.rootNode.unfilteredChildren||e.rootNode.children||[]:e.allRecords).map(n=>{const s=n.toJSON();return e.tree&&n.isParent&&t&&(s[r]=n.isExpanded(e)),s})}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.project}getInlineData(e){var t;const r=[];return this.tree?(t=this.rootNode.children)==null||t.forEach(n=>r.push(n.getCurrentConfig(e))):this.forEach(n=>r.push(n.getCurrentConfig(e))),r}getCurrentConfig(e){var t;const r=super.getCurrentConfig(e),{state:n}=this;return r&&(r.data&&(r.data=this.getInlineData(e)),delete r.project,delete r.stm,delete r.asyncEvents,((t=r.modelClass)==null?void 0:t.$meta.hierarchy[r.modelClass.$meta.hierarchy.length-2])===this.constructor.defaultConfig.modelClass&&delete r.modelClass,this.tree||delete r.tree,n&&Object.assign(r,n)),r}forEach(e,t=this,r){const n=this,s=(a,o)=>{if(a&&!a.isRoot&&!a.isSpecialRow)return e.call(t,a,o)};if(r=Tv(n,r),n.isTree)n.isChained&&(r={...r,sorterFn:n.sorterFn}),n.rootNode.traverseWhile(s,!1,r);else{const a=r.includeFilteredOutRecords?n.storage.allValues:n.storage.values;if(n.isGrouped&&r.includeCollapsedGroupRecords)for(let o=0;o<a.length;o++){const l=a[o],d=r.includeFilteredOutRecords?l.unfilteredGroupChildren:l.groupChildren;if(d&&l.meta.collapsed===!0)for(let c=0;c<d.length;c++){const u=d[c];if(s(u,c)===!1)return}else if(s(l,o)===!1)return}else for(let o=0;o<a.length;o++)if(s(a[o],o)===!1)return}}map(e,t=this){return this.storage.values.map(e,t)}flatMap(e,t=this){return this.storage.values.flatMap(e,t)}every(e,t=this,r){return this.storage[r?"allValues":"values"].every(e,t)}reduce(e,t=[],r=this){return r!==this&&(e=e.bind(r)),this.storage.values.reduce(e,t,r)}[Symbol.iterator](){return this.storage.values[Symbol.iterator]()}traverse(e,t=this.rootNode,r=t===this.rootNode,n){const s=this;if(n=Tv(s,n),s.isTree){if(typeof t=="boolean"&&(r=t,t=s.rootNode),s.isChained){const a=e;e=o=>{s.chainedFilterFn(o)&&a(o)}}t.traverse(e,r,n)}else s.forEach(a=>a.traverse(e,!1,n),s,n)}traverseWhile(e,t=this.rootNode,r=t===this.rootNode,n){const s=this;if(n=Tv(s,n),s.isTree){if(typeof t=="boolean"&&(r=t,t=s.rootNode),s.isChained){const a=e;e=o=>{s.chainedFilterFn(o)&&a(o)}}t.traverseWhile(e,r,n)}else for(const a of s.storage)if(a.traverse(e,!1,n)===!1)break}getNext(e,t=!1,r=!1){const n=this,s=n.storage.values;let a=n.indexOf(e);if(a>=s.length-1)if(t)a=-1;else return null;const o=s[a+1];return r&&o&&(o.isSpecialRow||typeof r=="function"&&r(o))?n.getNext(s[a+1],t,r):o}getPrev(e,t=!1,r=!1){const n=this,s=n.storage.values;let a=n.indexOf(e);if(a===0)if(t)a=s.length;else return null;const o=s[a-1];return a>0&&r&&o&&(o.isSpecialRow||typeof r=="function"&&r(o))?n.getPrev(s[a-1],t,r):o}getAdjacent(e,t=!0,r=!1,n=!1){return t?this.getNext(e,r,n):this.getPrev(e,r,n)}getNextLeaf(e,t=!1){const r=this,n=r.leaves,s=r.getById(e);let a=n.indexOf(s);if(a>=n.length-1)if(t)a=-1;else return null;return n[a+1]}getPrevLeaf(e,t=!1){const r=this,n=r.leaves,s=r.getById(e);let a=n.indexOf(s);if(a===0)if(t)a=n.length;else return null;return n[a-1]}getAdjacentLeaf(e,t=!0,r=!1){return t?this.getNextLeaf(e,r):this.getPrevLeaf(e,r)}};v(Uf,"$name","Store"),v(Uf,"configurable",{id:!0,modelClass:he,verifyNoGeneratedIds:!0,lazyLoad:null,autoLoad:null,useRawData:Wf}),v(Uf,"$lazyLoadPluginClass",Ya);var ae=Uf;ae.initClass(),ae._$name="Store";var nc=class extends Ya{static get pluginConfig(){const i={};for(const e in super.pluginConfig)i[e]=[...super.pluginConfig[e]];return i.assign.push("updateResponseTotalProperty","updateResponseDataProperty","beforePerformSort","beforePerformFilter"),i}updateResponseTotalProperty(i){this.totalCountProperty=i}updateResponseDataProperty(i){this.dataProperty=i}async beforePerformSort(){this.clearLoaded()}async beforePerformFilter(){this.clearLoaded()}async requestData(i){const{totalCountProperty:e,dataProperty:t}=this.lazyLoad,r=await this.internalLoad(i,"Chunk",void 0,!1);return{[e]:r.json[e],[t]:r.data}}async load(i){const{client:e}=this,t=e.params;i&&(e.params={...i,...t}),await super.load(),i&&(e.params=t)}};v(nc,"$name","AjaxStoreLazyLoadPlugin"),nc._$name="AjaxStoreLazyLoad";var mF=(i,e)=>(Array.isArray(e[1])?e[1].forEach(t=>i.push(encodeURIComponent(e[0])+"="+encodeURIComponent(t))):i.push(encodeURIComponent(e[0])+"="+encodeURIComponent(e[1])),i),sc=Promise.resolve(),ac=i=>String(i).padStart(2,"0"),pF=i=>`${i.getFullYear()}-${ac(i.getMonth()+1)}-${ac(i.getDate())}T${ac(i.getHours())}:${ac(i.getMinutes())}:${ac(i.getSeconds())}.${i.getMilliseconds()}`,lt=class extends ae{constructor(){super(...arguments),v(this,"modificationsTracking",0)}static get defaultConfig(){return{headers:null,fetchOptions:null,sendAsFormData:null,writeAllFields:null,parentIdParamName:"id",filterParamName:null,restfulFilter:!1,sortParamName:null,pageParamName:null,pageStartParamName:null,pageSizeParamName:"pageSize",useRestfulMethods:null,httpMethods:{create:"POST",read:"GET",update:"PUT",delete:"DELETE"},paramsInBody:de.checkVersion("core","6.0",">=")}}suspendModificationsTracking(){this.modificationsTracking++}resumeModificationsTracking(){this.modificationsTracking--}afterConstruct(i){super.afterConstruct(i),this.autoLoad&&this.load().catch(()=>{})}get isLoading(){return super.isLoading||this._isLoading?2:this.loadTriggerPromise?1:!1}get isCommitting(){var i;return!!((i=this.commitPromise)!=null?i:this.autoCommitTimeoutPromise)}updatePageSize(i){const e=this;if(!this.isConfiguring){const t=e.currentPage=e.currentPage?Math.min(e.currentPage,Math.floor((e.totalCount+i-1)/i)):1;i&&e.loadPage(t)}}set pageParamName(i){if(this.tree)throw new Error("Paging cannot be supported for tree stores");if(this.pageStartParamName)throw new Error("Configs pageStartParamName and pageParamName are mutually exclusive");this._pageParamName=i}get pageParamName(){return this._pageParamName}set pageStartParamName(i){if(this.tree)throw new Error("Paging cannot be supported for tree stores");if(this.pageParamName)throw new Error("Configs pageParamName and pageStartParamName are mutually exclusive");this._pageStartParamName=i}get pageStartParamName(){return this._pageStartParamName}get isPaged(){return!!(this.pageParamName||this.pageStartParamName)}get allCount(){return de.deprecate("core","7.0.0","Deprecated in favor of totalCount"),"remoteTotal"in this?this.remoteTotal:super.allCount}get totalCount(){return"remoteTotal"in this?this.remoteTotal:super.totalCount}get lastPage(){if(this.isPaged)return Math.floor((this.totalCount+this.pageSize-1)/this.pageSize)}buildQueryString(i,...e){const t=i.includes("?"),r=Object.entries(Object.assign({},...e)).reduce(mF,[]).join("&");return r?(t?"&":"?")+r:""}async performSort(i){var e;const t=this;if(t.remoteSort&&!t.isRemoteDataLoading){if(t.isRemoteDataLoading=!0,await((e=t.beforePerformSort)==null?void 0:e.call(t))===!1)return;const r=await t.load();return t.afterPerformSort(i),t.isRemoteDataLoading=!1,r}else super.performSort(i)}async performFilter(i){var e,t;const r=this;if(r.filterBatching>0){r.needsFiltering=!0;return}if(r.remoteFilter){(e=r.loadingPromise)==null||e.abort(),r.isRemoteDataLoading=!0;const n=r.count,{filters:s}=r;if(await((t=r.beforePerformFilter)==null?void 0:t.call(r,{filters:s,oldCount:n}))===!1)return;r.currentPage=1;const a=await r.load(),o=i?null:{action:"filter",filters:s,oldCount:n,records:r.storage.values};return r.afterPerformFilter(o),r.trigger("refresh",o),r.isRemoteDataLoading=!1,a}else super.performFilter(i)}encodeFilterParams(i){const e=[];for(const{property:t,operator:r,value:n,caseSensitive:s}of i)e.push({field:t,operator:r,value:n,caseSensitive:s});return JSON.stringify(e,function(t,r){return t===""?r:this[t]instanceof Date?pF(this[t]):r})}encodeSorterParams(i){return JSON.stringify(i.filter(e=>!e.sortFn).map(e=>e))}buildReadUrl(){const{readUrl:i}=this;return this.restfulFilter&&this.filters.count?(i.endsWith("/")?i:i+"/")+this.filters.first.value:i}internalLoad(i,e,t,r=0){i=T.assign({},this.params,i);const n=this,s={action:"read"+e,params:i,url:n.buildReadUrl()};if(n.trigger("beforeLoad"+e,s)===!1)throw!1;return n.loadArgs=[s,i,e,t],r===!1?new Promise((a,o)=>n.sendLoadRequest(a,o)):n.loadTriggerPromise||(n.loadTriggerPromise=new Promise((a,o)=>{n.setTimeout({delay:r,fn:"sendLoadRequest",args:[a,o],cancelOutstanding:!0})}))}async sendLoadRequest(i,e){var t,r,n;const s=this,[a,o,l,d]=s.loadArgs;if(s.loadTriggerPromise=null,a.url){if(s._isLoading=!0,s.trigger(`load${l}Start`,a),s.trigger("beforeRequest",a),s.filterParamName&&s.isFiltered&&(o[s.filterParamName]=s.encodeFilterParams(s.filters.values)),s.remoteSort&&s.isSorted&&(o[s.sortParamName]=s.encodeSorterParams(s.groupers?s.groupers.concat(s.sorters):s.sorters)),s.isPaged){if(!(s.pageParamName in o||s.pageStartParamName in o)){const u=Math.min(s.currentPage||1,s.totalCount?s.lastPage:1/0);s.pageParamName?o[s.pageParamName]=u:o[s.pageStartParamName]=(u-1)*s.pageSize}o[s.pageSizeParamName]=s.pageSize}const c={headers:s.headers,parseJson:!0};s.useRestfulMethods&&(c.method=s.httpMethods.read,a.body&&(c.body=JSON.stringify(a.body)));try{const u=s.paramsInBody&&(((t=c.method)==null?void 0:t.toUpperCase())==="POST"||((r=c.method)==null?void 0:r.toUpperCase())==="PUT")&&c.body==null,h=a.url+(u?"":s.buildQueryString(a.url,o)),f=s.loadingPromise=Ri.get(h,T.assign(c,s.fetchOptions,u?{body:JSON.stringify(o)}:null)),g=await f;if(s.isDestroyed)return;const m=g.parsedJson,p=Array.isArray(m),y=p||m&&T.getPath(m,s.responseSuccessProperty)!==!1,b=p?null:T.getPath(m,s.responseTotalProperty);if(s.loadingPromise=null,s._isLoading=!1,a.response=g,a.json=m,y){if(b!=null&&(s.remoteTotal=parseInt(b,10)),s.isPaged)if(s.remoteTotal>=0){const C=s.pageParamName?o[s.pageParamName]:o[s.pageStartParamName]/s.pageSize+1;s.currentPage=Math.min(C,s.lastPage)}else throw new Error("A paged store must receive its responseTotalProperty in each data packet");a.data=p?m:T.getPath(m,s.responseDataProperty),s.suspendModificationsTracking(),await(d==null?void 0:d(a)),s.resumeModificationsTracking(),s.isPartOfProjectRaw&&(s.ignoreLoadPropagationChanges&&s.suspendModificationsTracking(),await((n=s.getProject())==null?void 0:n.commitAsync()),s.ignoreLoadPropagationChanges&&s.resumeModificationsTracking()),!s.isDestroyed&&s.trigger("load"+l,a),i(a)}else Object.assign(a,{exception:!0,exceptionType:"server",error:m==null?void 0:m.error}),!s.isDestroyed&&s.trigger("exception",a),e(a);!s.isDestroyed&&s.trigger("afterRequest",a)}catch(u){s._isLoading=!1,a.exception=!0,u instanceof Response?(a.exceptionType=u.ok?"server":"network",a.response=u,a.error=u.error):(a.exceptionType="server",a.error=u),!s.isDestroyed&&s.trigger("exception",a),e(a),!s.isDestroyed&&s.trigger("afterRequest",a)}}}async load(i){const e=this;return e.isPaged?e.loadPage(e.currentPage||1,i):e.internalLoad(i,"",t=>{e.data=t.data})}async loadChildren(i){return this.readUrl?this.internalLoad({[this.parentIdParamName]:i.id},"Children",e=>{e.parentRecord=i,i.children.length&&i.clearChildren(!0),i.data[i.constructor.childrenField]=e.data,i.processChildren(i.stores)},!1):this.immediatePromise}async loadPage(i,e){this.totalCount&&(i=Math.min(i,this.lastPage));const t=this,r=t.pageParamName?{[t.pageParamName]:i}:{[t.pageStartParamName]:(i-1)*t.pageSize};return r[t.pageSizeParamName]=t.pageSize,t.internalLoad(T.assign(r,e),"Page",n=>{t.loadData(n.data,"pageLoad")})}async nextPage(i){const e=this;return e.isPaged&&e.currentPage!==e.lastPage?e.loadPage(e.currentPage+1,i):sc}async previousPage(i){return this.isPaged&&this.currentPage!==1?this.loadPage(this.currentPage-1,i):sc}async commit(){return this.clearTimeout("autoCommit"),this.autoCommitTimeoutPromise=null,this.queueCommit()}queueCommit(){const i=this;let e;return i.commitPromise?e=i.commitPromise.then(()=>i.performCommit()):(i._commitPromiseQueueLength=0,e=i.performCommit()),i._commitPromiseQueueLength+=1,i.commitPromise=e==null?void 0:e.finally(()=>{i._commitPromiseQueueLength-=1,i._commitPromiseQueueLength===0&&(i.commitPromise=null)})}performCommit(){const i=this,{changes:e}=i,t=[];if(!e)return i.modified.count&&(i.modified.forEach(r=>r.internalClearChanges(!0,!1)),i.modified.clear()),sc;if(i.trigger("beforeCommit",{changes:e})!==!1){[...e.added,...e.modified,...e.removed].forEach(s=>s.meta.committing=!0),i.trigger("commitStart",{changes:e});const r={action:"commit",exception:!1,changes:e};let n=i.commitRemoved(r);return n&&t.push(n),n=i.commitAdded(r),n&&t.push(n),n=i.commitModified(r),n&&t.push(n),t.length?(n=t.length===1?t[0]:Promise.all(t),new Promise((s,a)=>{n.then(()=>{r.exception?(i.trigger("exception",r),a(r)):(i.trigger("commit",{changes:e}),s(r))}).catch(()=>{a(r)})})):(i.modified.forEach(s=>s.internalClearChanges(!0,!1)),i.modified.clear(),i.added.forEach(s=>s.internalClearChanges(!0,!1)),i.added.clear(),i.removed.clear(),i.trigger("commit",{changes:e}),sc)}else return sc}doAutoCommit(){const i=this;i.suspendCount<=0&&!i.hasTimeout("autoCommit")&&(i.autoCommitTimeoutPromise=new Promise(e=>{i.setTimeout({name:"autoCommit",fn:()=>{i.autoCommitTimeoutPromise=null,i.commit().then().catch(t=>{const{response:r}=t;if(!(r&&(r.ok&&r.parsedJson||[500,404].includes(r.status))))throw t}),e()},delay:i.autoCommitTimeout})}))}buildCommitUrl(i){return i+this.buildQueryString(i,this.params)}commitAdded(i){const e=this,t=[...e.added];return t.length&&e.createUrl?new Promise(r=>{const n=t.map(l=>l.persistableData),s={action:"create",params:e.params,url:e.buildCommitUrl(e.createUrl)};i.create=s,s.body={data:n},e.trigger("beforeRequest",s);let a=s.body;if(e.sendAsFormData){const l=new FormData;l.append("data",JSON.stringify(n)),a=l}const o={headers:e.headers,parseJson:!0};e.useRestfulMethods&&(o.method=e.httpMethods.create),Ri.post(s.url,a,T.assign(o,e.fetchOptions)).then(l=>{const d=l.parsedJson,c=Array.isArray(d)||d&&d.success!==!1;if(i.response=l,s.json=d,s.response=l,c){const u=e.processReturnedData(d,t,n);e.added.remove(u),e.modified.add(u.filter(h=>h.meta.modified&&!T.isEmpty(h.meta.modified))),e.trigger("commitAdded"),e.trigger("refresh",s),r(i)}else t.forEach(u=>u.meta.committing=!1),i.exception=s.exception=!0,i.exceptionType=s.exceptionType="server",e.trigger("exception",s),r(i);e.trigger("afterRequest",s)}).catch(l=>{t.forEach(d=>d.meta.committing=!1),i.exception=s.exception=!0,l instanceof Response?(i.response=l,s.exceptionType=l.ok?"server":"network",s.response=l,s.error=l.error):(s.exceptionType="server",s.error=l),!e.isDestroyed&&e.trigger("exception",s),r(i),!e.isDestroyed&&e.trigger("afterRequest",s)})}):null}commitModified(i){const e=this,t=[...e.changes.modified],r=t.length&&e.updateUrl?new Promise(n=>{const s={action:"update",params:e.params,url:e.buildCommitUrl(e.updateUrl)},a=t.map(d=>e.writeAllFields?d.persistableData:d.modificationDataToWrite).filter(d=>!T.isEmpty(d));if(a.length===0){e.modified.clear(),t.forEach(d=>d.meta.committing=!1),n();return}i.update=s,s.body={data:a},e.trigger("beforeRequest",s);let o=s.body;if(e.sendAsFormData){const d=new FormData;d.append("data",JSON.stringify(a)),o=d}const l={headers:e.headers,parseJson:!0};e.useRestfulMethods&&(l.method=e.httpMethods.update),Ri.post(s.url,o,T.assign(l,e.fetchOptions)).then(d=>{const c=d.parsedJson,u=Array.isArray(c)||c&&c.success!==!1;i.response=d,s.json=c,s.response=d,u?(e.processReturnedData(c,t,a,!0,!0),e.trigger("commitModified"),e.trigger("refresh",s),n(i)):(t.forEach(h=>h.meta.committing=!1),i.exception=s.exception=!0,s.exceptionType="server",e.trigger("exception",s),n(i)),e.trigger("afterRequest",s)}).catch(d=>{t.forEach(c=>c.meta.committing=!1),i.exception=s.exception=!0,d instanceof Response?(i.response=d,s.exceptionType=d.ok?"server":"network",s.response=d,s.error=d.error):(s.exceptionType="server",s.error=d),!e.isDestroyed&&e.trigger("exception",s),n(i),!e.isDestroyed&&e.trigger("afterRequest",s)})}):null;return!t.length&&e.modified.count&&e.modified.clear(),r}processReturnedData(i,e,t,r=!1){Array.isArray(i)||(i=T.getPath(i,this.responseDataProperty));const{idField:n}=e[0].constructor,s=!i||i.length===e.length,a=[];return e.forEach((o,l)=>{const d=r?i==null?void 0:i.find(c=>c[n]===o.id):i==null?void 0:i[l];if(s||d){const c=o.modificationDataToWrite,u=r?t.find(f=>f.id===o.id):t[l],h={};if(o.meta.committing=!1,d&&(o.syncId(d[n]),Object.assign(o.data,this.modelClass.processData(d,r,this,o))),c){for(const f in u)if(c[f]===u[f]){const g=o.getFieldDefinitionFromDataSource(f);g!=null&&g.persist&&(h[g.name]=1)}}o.internalClearChanges(!0,!0,h,!0),a.push(o)}}),a}commitRemoved(i){const e=this,{removed:t,includeChildrenInRemoveRequest:r}=e;return t.count&&e.deleteUrl?new Promise(n=>{var s,a;let o;if(r)o=t.values;else{o=[];for(const u of t.values){const h=(a=u.parentId)!=null?a:(s=u.meta.modified)==null?void 0:s.parentId;h!=null&&(h===e.rootNode.id||!t.includes(h))&&o.push(u)}}const l={action:"delete",params:e.params,url:e.buildCommitUrl(e.deleteUrl),body:{ids:o.map(u=>u.id)}};i.delete=l,e.trigger("beforeRequest",l);let d=l.body;if(e.sendAsFormData){const u=new FormData;u.append("id",JSON.stringify(d.ids)),d=u}const c={headers:e.headers,parseJson:!0};e.useRestfulMethods&&(c.method=e.httpMethods.delete),Ri.post(l.url,d,T.assign(c,e.fetchOptions)).then(u=>{const h=u.parsedJson,f=Array.isArray(h),g=f||h&&h.success!==!1;i.response=u,l.json=h,l.response=u,g?(t.forEach(m=>m.meta.committing=!1),t.clear(),e.trigger("commitRemoved"),e.trigger("refresh",l),n(i)):(t.forEach(m=>m.meta.committing=!1),i.exception=l.exception=!0,l.exceptionType="server",e.trigger("exception",l),n(i)),e.trigger("afterRequest",l)}).catch(u=>{t.forEach(h=>h.meta.committing=!1),i.exception=l.exception=!0,u instanceof Response?(i.response=u,l.exceptionType=u.ok?"server":"network",l.response=u,l.error=u.error):(l.exceptionType="server",l.error=u),!e.isDestroyed&&e.trigger("exception",l),n(i),!e.isDestroyed&&e.trigger("afterRequest",l)})}):null}get remoteFilter(){return!!(this.filterParamName||this.restfulFilter)}get remoteSort(){return!!this.sortParamName}};v(lt,"$name","AjaxStore"),v(lt,"configurable",{responseSuccessProperty:"success",responseDataProperty:"data",responseTotalProperty:"total",params:null,pageSize:50,autoCommitTimeout:10,includeChildrenInRemoveRequest:!0,ignoreLoadPropagationChanges:!1}),v(lt,"$lazyLoadPluginClass",nc),lt._$name="AjaxStore";var Gf={},He=class{static get(i,e=Gf){const t=i._domData||(i._domData={});return e===Gf?t:t[e]}static remove(i,e){const{_domData:t}=i,r=t==null?void 0:t[e];return t==null||delete t[e],r}static set(i,e,t=Gf){return t===Gf?i._domData=t=e:(i._domData||(i._domData={}))[e]=t,t}static assign(i,e){Object.assign(i._domData||(i._domData={}),e)}};He._$name="DomDataStore";var oc=class{static insertRule(i,e=document.head){const t=this.getStyleSheet(e),{cssRules:r}=t,n=r.length,s=typeof i=="string";if((s?[i]:i).forEach((a,o)=>t.insertRule(a,o)),r.length>n)return s?r[0]:Array.from(r).slice(0,i.length)}static findRule(i){let e;const t=typeof i=="function";return Array.prototype.find.call(document.head.querySelectorAll("link[rel=stylesheet],style[type*=css]"),r=>{if(e=Array.prototype.find.call(r.sheet.rules||r.sheet.cssRules,n=>t?i(n):n.selectorText===i),e)return!0}),e}static getStyleSheet(i=document.head){return i.$bryntumStylesheet||(i.$bryntumStylesheet=E.createElement({tag:"style",type:"text/css",parent:i}).sheet),i.$bryntumStylesheet}static getCSSVersion(){return getComputedStyle(document.documentElement).getPropertyValue("--bryntum-version").replace(/[" ]/gm,"")}};v(oc,"$name","CSSHelper"),Pe.register(oc),oc._$name="CSSHelper";var qE=Array.prototype.slice,KE=Object.freeze([]),vF=Object.freeze({}),XE=/[&<]/,{getPrototypeOf:ZE}=Object,{toString:yF}=Object.prototype,{isEqual:QE,isObject:bF}=T,CF={parent:1,elementData:1,ns:1,syncOptions:1},JE=()=>({ignore:CF,refsFound:new Set}),Mv={class:1,className:1,classname:1},SF={bigint:1,boolean:1,function:1,number:1,string:1,symbol:1},DF={tag:1,html:1,text:1,children:1,tooltip:1,parent:1,nextSibling:1,ns:1,reference:1,elementData:1,retainElement:1,compareHtml:1,syncOptions:1,listeners:1,isReleased:1,null:1,"":1,keepChildren:1,retainChildren:1},wF=(i,e)=>{const t="className"in e?"className":"class",r=e[t];if(r)if(typeof r=="string"){const n=r.split(" ");n.includes(i)||(n.push(i),e[t]=n.join(" "))}else Array.isArray(r)?r.includes(i)||r.push(i):r.isDomClassList?r.add(i):T.isObject(r)&&(r[i]=1)},EF=(i,e)=>{const t="className"in e?"className":"class",r=e[t];if(r)if(typeof r=="string"){const n=r.split(" ");n.includes(i)&&(n.splice(n.indexOf(i),1),e[t]=n.join(" "))}else Array.isArray(r)?r.includes(i)&&r.splice(r.indexOf(i),1):r.isDomClassList?r.remove(i):T.isObject(r)&&delete r[i]},oe=class Ye{static checkEquality(e,t,r,n){var s;if(e===t)return!0;if(e==null)return t==null;if(!e||!t)return!1;const a=typeof e;if(a!==typeof t||SF[a])return!1;let l=r.equalityCache||(r.equalityCache=new Map),d=!!n,c,u,h,f,g,m,p;if(l=l.get(e)||l.set(e,new Map).get(e),c=l.get(t),c===void 0){if(c=!0,ZE(e)!==ZE(t)||e instanceof Node)c=!1;else if(Array.isArray(e)){if(u=e.length,u!==t.length)c=!1;else for(;u-- >0;)if(!Ye.checkEquality(e[u],t[u],r,d)){c=!1;break}}else{m=e.syncOptions,f=m==null?void 0:m.ignoreRefs,f&&(d=!0,n=f!=="children"),h=r.ignore||vF;for(g in t)if(!h[g]&&!(g in e)&&!(n&&g==="reference")){c=!1;break}if(c){if(yF.call(t)==="[object Date]")c=e.getTime()===t.getTime();else if(E.isReactElement(e)||E.isReactElement(t))c=!1;else for(g in e)if(!h[g]&&!(n&&g==="reference")){if(!(g in t)){c=!1;break}if(p=e[g],!Ye.checkEquality(p,t[g],r,d)){c=!1;break}}}}!n&&bF(e)&&e.reference&&((s=r.refsFound)==null||s.add(e.reference)),l.set(t,c)}return c}static sync(e){var t;const r=e,{refOwner:n}=e,s=n==null?void 0:n.byRef,a=JE();let o=e.affected,l,d,c,u;if(typeof o=="string"&&(o=[o]),e={...e,checkEqualityOptions:a},n){if(n.byRef={},o)for(d in s)o.includes(d)||(n.byRef[d]=s[d]);e.refsWas=s}if(r.changed=Ye.performSync(e,e.targetElement),n)for(o||(o=Object.keys(s)),l=0;l<o.length;++l)d=o[l],c=s[d],a.refsFound.has(d)||c.retainElement?n.byRef[d]=c:(u=c.lastDomConfig,(t=c.blur)==null||t.call(c),c.remove(),n.detachRef(d,c,u));return e.targetElement}static performSync(e,t){const{domConfig:r,callback:n}=e,{lastDomConfig:s}=t;if((e.configEquality||Ye.checkEquality)(r,s,e.checkEqualityOptions,e.ignoreRefs))n==null||n({action:"none",domConfig:r,targetElement:t});else return r?(r.onlyChildren||(Ye.syncAttributes(r,t,e),Ye.syncContent(r,t)),r.keepChildren||Ye.syncChildren(e,t)):(t.innerHTML=null,t.syncIdMap=null),t.lastDomConfig=r!=null&&r.onlyChildren&&s?{...s,children:r.children}:r,!0;return!1}static syncDataset(e,t){const{lastDomConfig:r}=t,n=e===r,s=Object.keys(e.dataset),a=r&&r.dataset&&Object.keys(r.dataset),o=H.delta(s,a);let l,d,c,u;for(d=0;d<o.onlyInA.length;d++)l=o.onlyInA[d],u=e.dataset[l],u!=null&&t.setAttribute(`data-${O.hyphenate(l)}`,u);for(d=0;d<o.inBoth.length;d++)l=o.inBoth[d],u=e.dataset[l],(n||u!=r.dataset[l])&&(c=`data-${O.hyphenate(l)}`,u==null?t.removeAttribute(c):t.setAttribute(c,u));for(d=0;d<o.onlyInB.length;d++)t.removeAttribute(`data-${O.hyphenate(o.onlyInB[d])}`)}static addCls(e,t){const{lastDomConfig:r}=t;e=se.normalize(e,"array"),e.forEach(n=>{t.classList.add(n),wF(n,r)})}static removeCls(e,t){const{lastDomConfig:r}=t;e=se.normalize(e,"array"),e.forEach(n=>{t.classList.remove(n),EF(n,r)})}static syncClassList(e,t,r){let n=e.className||e.class,s=!1,a,o,l,d,c,u;if(r){for(o=se.normalize(t,"array"),n=se.normalize(n,"object"),u=se.normalize(r.className||r.class,"object"),c=[],l=0,d=o.length;l<d;++l)a=o[l],n[a]||!(a in u)?(u[a]=1,c.push(a)):s=!0;for(a in n)u[a]||(c.push(a),s=!0);if(!s)return;n=c.join(" ")}else n=se.normalize(n);t.setAttribute("class",n)}static getSyncAttributes(e){const t={},r=[];return e&&Object.keys(e).forEach(n=>{if(!DF[n]){const s=n.toLowerCase();t[s]=e[n],r.push(s)}}),{attributes:t,names:r}}static syncAttributes(e,t,r){const{lastDomConfig:n}=t,s=e===n,a=Ye.getSyncAttributes(e),{attributes:o,names:l}=a,{attributes:d,names:c}=s?a:Ye.getSyncAttributes(n),{onlyInA:u,onlyInB:h,inBoth:f}=s?{onlyInA:KE,onlyInB:KE,inBoth:l}:H.delta(l,c);let g,m,p=!1;for(m=0;m<u.length;m++){g=u[m];const y=o[g];g==="style"&&y!=null?E.applyStyle(t,y,!0):g==="dataset"?Ye.syncDataset(e,t):Mv[g]?(Ye.syncClassList(e,t),p=!0):y!=null&&t.setAttribute(g,y)}for(m=0;m<f.length;m++){g=f[m];const y=o[g],b=d[g];y==null?t.removeAttribute(g):g==="style"?r.strict?s?Ye.syncStyles(t,y):QE(y,b,!0)||Ye.syncStyles(t,y,b):(s||!QE(y,b,!0))&&E.applyStyle(t,y,!0):g==="dataset"?Ye.syncDataset(e,t):Mv[g]?(Ye.syncClassList(e,t,r.strict&&t.lastDomConfig),p=!0):(s||y!==b)&&t.setAttribute(g,y)}for(m=0;m<h.length;m++)g=h[m],(!Mv[g]||!p)&&t.removeAttribute(g)}static syncStyles(e,t,r){let n,s,a;if(!r)n=t;else{if(n={},t=E.parseStyle(t),r=E.parseStyle(r),t)for(s in t)a=t[s],r[s]!==a&&(n[s]=a);for(s in r)s in t||(n[s]="")}E.applyStyle(e,n)}static syncContent(e,t){var r;const{html:n,text:s}=e,a=s!=null?s:n;if(t.didSetTextContent=!1,e.elementData&&(t.elementData=e.elementData),a instanceof DocumentFragment)t.childNodes.length===1&&E.getChildElementCount(t)===0&&a.childNodes.length===1&&E.getChildElementCount(a)===0?E.setInnerText(t,a.firstChild.data):(t.innerHTML="",t.appendChild(a));else if(n!=null&&XE.test(n))t.innerHTML=String(n);else if(a!=null){const{lastDomConfig:o}=t;((r=o==null?void 0:o.children)!=null&&r.length||o!=null&&o.html&&XE.test(t.lastDomConfig.html))&&(t.innerHTML=""),E.setInnerText(t,String(a)),t.didSetTextContent=!0}}static insertTextNode(e,t,r,n,s=null){const a=document.createTextNode(e);t.insertBefore(a,s),n&&(a.$refOwnerId=n.id),r==null||r({action:"newNode",domConfig:e,targetElement:a})}static insertElement(e,t,r,n,s,a,o){var l;const d=o.ns?document.createElementNS(o.ns,e.tag||"svg"):document.createElement(e.tag||"div");t.insertBefore(d,r),Ye.performSync(o,d),a!=null&&(s[a]=d),!e.role&&!e.tabIndex&&!e["aria-hidden"]&&!E.isFocusable(d,!0)&&!d.htmlFor&&d.setAttribute("role","presentation"),n&&(d.$refOwnerId=n.id,a&&(d.$reference=a,n.attachRef(a,d,e))),(l=o.callback)==null||l.call(o,{action:"newElement",domConfig:e,targetElement:d,syncId:a})}static syncChildren(e,t){var r,n,s,a;let{domConfig:o,syncIdField:l,callback:d,releaseThreshold:c,configEquality:u,ns:h,refOwner:f,refsWas:g,strict:m,checkEqualityOptions:p,ignoreRefs:y}=e,b=null,C,D,S;const x=o.syncOptions||{};if((r=o.html)!=null?r:o.text)return;y=!!((n=x.ignoreRefs)!=null?n:y),y&&(f=g=null),"strict"in x&&(m=x.strict);const R=f?f.byRef:{},M=qE.call(o.children||[]),I=qE.call(t.childNodes),_=g||t.syncIdMap||{},P=t.releasedIdMap||{},A=F=>{for(;I.length&&I[0].parentNode!==t;)I.shift();return(F?I.shift():I[0])||null};l=x.syncIdField||l,m=x.strict||m,d=x.callback||d,u=x.configEquality||u,c="releaseThreshold"in x?x.releaseThreshold:c,l&&(t.syncIdMap=R);const L={checkEqualityOptions:p||JE(),ignoreRefs:y,refOwner:f,refsWas:g,strict:m,syncIdField:l,releaseThreshold:c,callback:d,configEquality:u};for(;M.length;){const F=M.shift();if(S=null,!F)continue;if(E.isReactElement(F)){d({jsx:F,targetElement:t,domConfig:o});continue}if(Array.isArray(F)){this.syncChildren({...e,domConfig:{...e.domConfig,children:F}},t);continue}if(F instanceof Node){D=A(),F!==D&&t.insertBefore(F,D),C=I.indexOf(F),C>-1&&I.splice(C,1);continue}const N=typeof F=="string";if(L.domConfig=F,L.ns=F.ns||h,!N){if(f?S=F.reference:l&&F.dataset&&(S=F.dataset[l]),S!=null&&!F.unmatched){const Z=_[S]||P[S];if(Z){const{lastDomConfig:fe}=Z;Z.retainElement||Ye.performSync(L,Z)&&(d==null||d({action:"reuseOwnElement",domConfig:F,targetElement:Z,lastDomConfig:fe,syncId:S})),F.retainElement&&(Z.retainElement=!0),R[S]=Z,H.remove(I,Z),delete P[S],Z.isReleased=!1,D=A(),(Z.parentNode!==t||m&&Z.nextSibling!==D)&&t.insertBefore(Z,D)}else m?Ye.insertElement(F,t,A(),f,R,S,L):(M.push(F),F.unmatched=!0);continue}F.unmatched&&delete F.unmatched}let Y=null,G=null,U;for(;!G&&(U=A(!0));){if(f){if(U.$refOwnerId!==f.id)continue;if(U.$reference){if(!m)continue;Y=U;break}G=U}else U.retainElement||(G=U);G||(b||(b=[])).push(U)}if(Y||!G)N?Ye.insertTextNode(F,t,d,f,Y):Ye.insertElement(F,t,Y,f,R,S,L);else if(!N&&G.nodeType===Node.ELEMENT_NODE&&(F.tag||"div").toLowerCase()===G.tagName.toLowerCase()){const{lastDomConfig:Z}=G,fe=Ye.performSync(L,G);if(l&&((s=Z==null?void 0:Z.dataset)==null?void 0:s[l])!=null){const J=Z.dataset[l];delete P[J],delete _[J]}S!=null&&(R[S]=G),G.isReleased=!1,fe&&(d==null||d({action:"reuseElement",domConfig:F,targetElement:G,lastDomConfig:Z,syncId:S}))}else N&&G.nodeType===Node.TEXT_NODE?G.data=F:(N?Ye.insertTextNode(F,t,d,f,G):Ye.insertElement(F,t,G,f,R,S,L),(a=G.blur)==null||a.call(G),G.remove())}if(!(t.didSetTextContent&&I.length===1&&I[0].nodeType===Node.TEXT_NODE)&&!o.retainChildren){for(;D=A(!0);)(!f||D.$refOwnerId===f.id&&!D.$reference)&&(b||(b=[])).push(D);b&&Ye.syncChildrenCleanup(t,b,R,d,f,c,l)}}static syncChildrenCleanup(e,t,r,n,s,a,o){var l;let d=0,c;for(const u of t){const{lastDomConfig:h}=u;if(u.nodeType===Element.TEXT_NODE){u.remove();continue}u.retainElement?o&&h&&(r[u.dataset[o]]=u):!s&&o&&(a==null||d<a)?(u.isReleased||(u.className="b-released",u.isReleased=!0,h!=null&&h.dataset&&(e.releasedIdMap||(e.releasedIdMap={}),e.releasedIdMap[h.dataset[o]]=u),n==null||n({action:"releaseElement",domConfig:h,lastDomConfig:h,targetElement:u}),h&&(h.isReleased=!0,h.className&&(h.className="b-released"),h.class&&(h.class="b-released"),h.style&&(h.style=null))),d++):((l=u.blur)==null||l.call(u),u.remove(),s&&(c=u.$reference,c&&s.detachRef(c,u,h)),e.releasedIdMap&&o&&(h!=null&&h.dataset)&&delete e.releasedIdMap[h.dataset[o]],n==null||n({action:"removeElement",domConfig:u.lastDomConfig,lastDomConfig:u.lastDomConfig,targetElement:u}))}}static removeChild(e,t){if(e.contains(t)){const r=e.syncIdMap;if(r){const n=Object.values(r).indexOf(t);n>-1&&delete r[Object.keys(r)[n]]}e.removeChild(t)}}static addChild(e,t,r){e.appendChild(t),e.syncIdMap||(e.syncIdMap={}),e.syncIdMap[r]=t}static getChild(e,t){var r;const n=String(t).split(".");for(const s of n)if(e=(r=e==null?void 0:e.syncIdMap)==null?void 0:r[s],!e)return null;return e}};oe._$name="DomSync";var Ui=class yp{static init(){const e=["fullscreenEnabled","requestFullscreen","exitFullscreen","fullscreenElement"],t=a=>e.map(o=>{let l=a+O.capitalize(o);return a==="moz"&&(l=l.replace("screen","Screen"),"mozCancelFullScreen"in document&&o==="exitFullscreen"&&(l="mozCancelFullScreen")),l});this.functions="fullscreenEnabled"in document&&e||"webkitFullscreenEnabled"in document&&t("webkit")||"mozFullScreenEnabled"in document&&t("moz")||"msFullscreenEnabled"in document&&t("ms")||[];const r=["fullscreenchange","fullscreenerror"],n=["MSFullscreenChange","MSFullscreenError"],s=a=>r.map(o=>a+O.capitalize(o));this.events="fullscreenEnabled"in document&&r||"webkitFullscreenEnabled"in document&&s("webkit")||"mozFullscreenEnabled"in document&&s("moz")||"msFullscreenEnabled"in document&&n||[],this.onFullscreenChange(this.onInternalFullscreenChange.bind(this))}static get enabled(){return!!(this.functions[0]&&document[this.functions[0]])}static async request(e){return this.functions[1]&&(e==null?void 0:e[this.functions[1]]())}static async exit(){return this.functions[2]&&document[this.functions[2]]()}static get isFullscreen(){return!!this.element}static get element(){return this.functions[3]&&document[this.functions[3]]}static onFullscreenChange(e){this.events[0]&&document.addEventListener(this.events[0],e)}static unFullscreenChange(e){this.events[0]&&document.removeEventListener(this.events[0],e)}static onInternalFullscreenChange(){const e=globalThis.bryntum,{element:t}=yp;if(!(yp.isFullscreen&&e._floatRoot||!yp.isFullscreen&&!e._floatRoot))if(t){if(!t.closest(".b-floatroot")){const r=E.getRootElement(t),{floatRoot:n}=r;n&&(e._floatRoot=n,e._oldParent=n.parentElement,t.appendChild(n))}}else e._floatRoot&&e._oldParent.appendChild(e._floatRoot),e._oldParent=null,e._floatRoot=null}};Ui.init(),Ui._$name="Fullscreen";var Iv=null,_v=[],xF=i=>{var e;return i.nodeType===i.ELEMENT_NODE&&((e=i.ownerDocument.defaultView)==null?void 0:e.getComputedStyle(i).getPropertyValue("position"))==="absolute"},gt=class BI{static addResizeListener(e,t){const r=this;if((e===document||e===globalThis)&&(e=document.body),e.nodeType===e.DOCUMENT_FRAGMENT_NODE&&(e=e.host),e.classList.contains("b-resize-monitored")||(e.classList.add("b-resize-monitored"),e._bResizemonitor={handlers:[]}),e===document.body)r.hasWindowResizeListener||(globalThis.addEventListener("resize",r.onWindowResize),r.hasWindowResizeListener=!0);else if(globalThis.ResizeObserver)r.resizeObserver||(r.resizeObserver=new ResizeObserver(r.onElementResize)),r.resizeObserver.observe(e);else{e.classList.add("b-no-resizeobserver");const[n,s,a]=E.createElement({parent:e,className:"b-resize-monitors",children:[{className:"b-resize-monitor-expand"},{className:"b-resize-monitor-shrink"}]},{returnAll:!0});s.scrollLeft=s.scrollTop=a.scrollLeft=a.scrollTop=1e6,s.addEventListener("scroll",r.onSizeMonitorScroll,!0),a.addEventListener("scroll",r.onSizeMonitorScroll,!0),(t.targetMutationMonitor=new MutationObserver(o=>{const l=[],d=[];for(const u of o)u.type==="childList"&&(l.push.apply(l,u.addedNodes),d.push.apply(d,u.removedNodes));const c=[...l.filter(u=>!d.includes(u)),...d.filter(u=>!l.includes(u))];c.length!==0&&(c.length>0&&c.every(xF)||s.dispatchEvent(new CustomEvent("scroll",{bubbles:!1})))})).observe(e,{childList:!0,subtree:!0}),t.monitorElement=n}e._bResizemonitor.handlers.push(t)}static removeResizeListener(e,t){if(e){(e===document||e===globalThis)&&(e=document.body);const r=e._bResizemonitor;let n=0;r&&r.handlers&&(H.remove(r.handlers,t),n=r.handlers.length),n||(e.classList.remove("b-resize-monitored"),this.resizeObserver?this.resizeObserver.unobserve(e):(t.monitorElement&&(t.monitorElement.remove(),t.monitorElement=null),t.targetMutationMonitor&&t.targetMutationMonitor.disconnect()))}}static onElementResize(e){for(const t of e){const r=t.target,n=r._bResizemonitor,s=t.contentRect||r.getBoundingClientRect();if(en(r)&&(!n.rectangle||s.width!==n.rectangle.width||s.height!==n.rectangle.height)){const a=n.rectangle;n.rectangle=s;for(const o of n.handlers)o(r,a,s)}}}static onSizeMonitorScroll(e){var t;if(e.target.isConnected||(t=document.body)!=null&&t.contains(e.target)){e.stopImmediatePropagation();const r=e.target.parentNode,n=r.parentNode,s=n._bResizemonitor,a=n.getBoundingClientRect();(!s.rectangle||a.width!==s.rectangle.width||a.height!==s.rectangle.height)&&(_v.push([n,s.rectangle,a]),s.rectangle=a,Iv||(Iv=requestAnimationFrame(BI.fireResizeEvents))),r.firstChild.scrollLeft=r.firstChild.scrollTop=r.childNodes[1].scrollTop=r.childNodes[1].scrollLeft=1e6}}static onWindowResize(e){const t=document.body,r=t._bResizemonitor,n=r.rectangle;r.rectangle=document.documentElement.getBoundingClientRect();for(const s of r.handlers)s(t,n,r.rectangle)}static fireResizeEvents(){for(const e of _v)for(const t of e[0]._bResizemonitor.handlers)e[0].offsetParent&&t.apply(this,e);Iv=null,_v.length=0}static removeGlobalListeners(){globalThis.removeEventListener("resize",this.onWindowResize)}};gt._$name="ResizeMonitor";var e0={auto:"auto",true:"auto",false:"hidden","hidden-scroll":"auto",clip:K.supportsOverflowClip?"clip":"hidden"},t0="b-widget-scroller",Pv={block:"nearest"},i0=Promise.resolve(),r0=i=>new Promise(e=>j.on({element:i===document.documentElement?globalThis:i,scroll:e,once:!0})),RF={x:1},qa={auto:1,scroll:1},TF={true:1,auto:1},MF={overflowX:"auto",overflowY:"auto"},IF=i=>{var e,t,r,n;let s,a,o,l;return i?typeof i=="number"?s=a=o=l=i:(s=(e=i.top)!=null?e:0,a=(t=i.bottom)!=null?t:0,o=(r=i.start)!=null?r:0,l=(n=i.end)!=null?n:0):s=a=o=l=0,{top:s,bottom:a,start:o,end:l}},hs=class cf extends ve(Ve($)){static get configurable(){return{widget:null,element:{$config:{nullify:!0},value:null},contentElement:{$config:{nullify:!0},value:null},overflowX:null,overflowY:null,translate:null,behavior:null,x:0,y:0,rtlSource:null,propagateSync:null}}static get delayable(){return{onScrollEnd:{type:"buffer",delay:100}}}get isRTL(){var e;return!!((e=this.rtlSource)!=null&&e.rtl)}syncOverflowState(){const e=this,{hasOverflowX:t,hasOverflowY:r,element:n}=e,s=e.hasOverflowX=n.scrollWidth>n.clientWidth,a=e.hasOverflowY=n.scrollHeight>n.clientHeight;if(t!==s||r!==a){const o=new se(n.classList,{"b-horizontal-overflow":s,"b-vertical-overflow":a});E.syncClassList(n,o),e.isConfiguring||e.trigger("overflowChange",{x:s,y:a})}}hasOverflow(e="y"){const t=this,r=t[`overflow${e.toUpperCase()}`],n=t[`overflow${e==="y"?"x":"y"}`];if(!E.scrollBarWidth||!TF[r]||n==="hidden-scroll"){const s=e==="y"?"Height":"Width";return t[`scroll${s}`]>t[`client${s}`]}return t[`hasOverflow${e.toUpperCase()}`]}hasScrollbar(e="y"){const{element:t}=this;if(t&&E.scrollBarWidth){const r=e==="y",n=r?"Width":"Height",s=t[`client${n}`],a=parseInt(E.getStyleValue(t,`border${r?"Left":"Top"}Width`))+parseInt(E.getStyleValue(t,`border${r?"Right":"Bottom"}Width`)),o=t[`offset${n}`]-a-s;return Math.abs(o-E.scrollBarWidth)<2}}addPartner(e,t=RF){const r=this;typeof t=="string"&&(t={[t]:1}),r.partners||(r.partners={}),r.partners[e.id]={scroller:e,axes:t},t.x&&(e.x=r.x),t.y&&(e.y=r.y),e.isPartneredWith(r)||e.addPartner(r,t)}eachPartner(e){const{partners:t}=this;t&&Object.values(t).forEach(e)}removePartner(e){e&&this.isPartneredWith(e)&&(delete this.partners[e.id],e.removePartner(this))}isPartneredWith(e){var t;return!!((t=this.partners)!=null&&t[e.id])}clearPartners(){this.partners&&Object.values(this.partners).forEach(e=>e.scroller.removePartner(this))}async scrollIntoView(e,t=Pv){const r=this,{isRectangle:n}=e,s=n?e:k.from(e),{xDelta:a,yDelta:o}=r.getDeltaTo(e,t),l=r.scrollBy(a,o,t);return(t.highlight||t.focus)&&l.then(()=>{var d,c;e=n?s.translate(-a,-o):(c=(d=t.elementAfterScroll)==null?void 0:d.call(t))!=null?c:e,t.highlight&&(isNaN(t.highlight)?(r.widget||r).callback(t.highlight,null,[e]):E.highlight(e,r)),t.focus&&e.focus({preventScroll:!0})}),l}static async scrollIntoView(e,t=Pv,r=!1){const n=k.from(e),s=typeof t=="object"?t.animate:t,a=cf._globalScroller||(cf._globalScroller=new cf),o=[];a.rtlSource={rtl:r};let l=0,d=0,c;t.maxWidth&&(n.width=Math.min(n.width,t.maxWidth),t.maxWidth=null),t.maxHeight&&(n.height=Math.min(n.height,t.maxHeight),t.maxHeight=null);for(let u=e.parentNode;u.nodeType===Node.ELEMENT_NODE;u=u.parentNode){if(u===document.body&&u!==document.scrollingElement)continue;const h=u===document.scrollingElement?MF:u.ownerDocument.defaultView.getComputedStyle(u),f=He.get(u,"scroller");if(t.y!==!1&&(f!=null&&f.hasOverflowY||qa[h.overflowY]&&u.scrollHeight>u.clientHeight)||t.x!==!1&&(f!=null&&f.hasOverflowX||qa[h.overflowX]&&u.scrollWidth>u.clientWidth)){let g=a;f?g=f:(a.element=u,a.positionDirty=!0);const{xDelta:m,yDelta:p}=g.getDeltaTo(n,t);(m||p)&&(o.push({element:u,x:u.scrollLeft,y:u.scrollTop,xDelta:m,yDelta:p}),n.translate(-m,-p),l+=m,d+=p)}}if(o.length){const u=Math.abs(l),h=Math.abs(d);let f=s&&(typeof s=="number"?s:typeof s.duration=="number"?s.duration:300);if(f&&(u>10||h>10))Math.max(u,h)<50&&(f=Math.min(f,500)),c=a.scrollAnimation=Se.animate(f,g=>{const m=g===1;for(const{element:p,x:y,y:b,xDelta:C,yDelta:D}of o)a.element=p,C&&(a.x=Math[r?"min":"max"](y+(m?C:Math.round(C*g)),0)),D&&(a.y=Math.max(b+(m?D:Math.round(D*g)),0))},null,s.easing),c.then(()=>{a.scrollAnimation=null});else if(u>=1||h>=1){for(const{element:g,xDelta:m,yDelta:p}of o)g.scrollTop+=p,g.scrollLeft+=m;return r0(o[o.length-1].element)}}else c=i0;return(t.highlight||t.focus)&&c.then(()=>{t.highlight&&(isNaN(t.highlight)?a.callback(t.highlight,null,[e]):E.highlight(e,a)),t.focus&&e.focus({preventScroll:!0})}),c}scrollBy(e=0,t=0,r=Pv){const n=this,s=typeof r=="object"?r.animate:r,a=Math.abs(e),o=Math.abs(t);n.scrollAnimation&&(n.scrollAnimation.cancel(),n.scrollAnimation=null),(e||t)&&(n.silent=r.silent);let l=s&&(typeof s=="number"?s:typeof s.duration=="number"?s.duration:300);if(l&&(a>10||o>10)){const{x:d,y:c}=n;let u=d,h=c;return Math.max(a,o)<50&&(l=Math.min(l,500)),n.scrollAnimation=Se.animate(l,f=>{var g,m;const p=f===1;if(e){if(Math.abs(n.x-u)>1&&!r.force)return(g=n.scrollAnimation)==null?void 0:g.cancel();n.x=Math.max(d+(p?e:Math.round(e*f)),0)}if(t){if(Math.abs(n.y-h)>1&&!r.force)return(m=n.scrollAnimation)==null?void 0:m.cancel();n.y=Math.max(c+(p?t:Math.round(t*f)),0)}u=n.x,h=n.y},n,s.easing),n.element.classList.add("b-scrolling"),n.scrollAnimation.then(()=>{n.isDestroyed||(n.element.classList.remove("b-scrolling"),n.scrollAnimation=null)}),n.scrollAnimation}else{if(e||t){const d=n.x,c=n.y;if(Math.round(a)>=1&&(n.x+=e),Math.round(o)>=1&&(n.y+=t),n.x!==d||n.y!==c)return r0(n.element)}return i0}}async scrollTo(e,t,r){const{x:n,y:s}=this,a=e==null?0:e-n,o=t==null?0:t-s;return this.scrollingToCenter=r==null?void 0:r.scrollingToCenter,this.scrollBy(a,o,r)}doDestroy(){var e,t;const r=this;r._element&&(r._element.removeEventListener("scroll",r.scrollHandler),(e=r.wheelListenerRemover)==null||e.call(r)),(t=r.scrollAnimation)==null||t.cancel(),Object.values(r.partners||{}).forEach(({scroller:n})=>n.removePartner(r)),super.doDestroy()}onElMutation(e){const t=this,[r,n]=E.getTranslateXY(t.element);if(t._x!==-r||t.y!==-n){const s=new CustomEvent("scroll",{bubbles:!0});Object.defineProperty(s,"target",{get:()=>t.element}),t.onScroll(s)}}onElResize(){const e=this,{widget:t}=e;t!=null&&t.isAnimating?t.findListener("animationend","onElResize",e)===-1&&t.ion({animationEnd:"onElResize",thisObj:e,once:!0}):e.syncOverflowState()}onScroll(e){const t=this,{_x:r,_y:n,element:s}=t;let a=0;t.overflowX==="clip"&&s.scrollLeft!==r&&(s.scrollLeft=r,++a),t.overflowY==="clip"&&s.scrollTop!==n&&(s.scrollTop=n,++a),a!==2&&(!t.widget||!t.widget.isDestroyed)&&(t.positionDirty=!0,s.classList.contains("b-scrolling")||s.classList.add("b-scrolling"),e.widget=t.widget,e.scrollingToCenter=t.scrollingToCenter,t.silent||t.trigger("scroll",e),t.syncPartners(),t.controllingPartner=null,t.onScrollEnd(e))}syncPartners(e,t=this.propagateSync){const r=this;r.partners&&Object.values(r.partners).forEach(({axes:n,scroller:s})=>{(s!==r.controllingPartner||e)&&s.sync(r,n)&&t&&s.syncPartners(e,t)})}onScrollEnd(e){const t=this;t.silent&&(t.silent=!1),t.trigger("scrollEnd",e),t.scrollingToCenter=!1,t.controllingPartner=null,t.element.classList.remove("b-scrolling")}getDeltaTo(e,t){const r=this;if(!r.viewport)return{xDelta:0,yDelta:0};const{x:n,y:s,scrollWidth:a,scrollHeight:o,isRTL:l}=r,d=e instanceof k?e:k.from(e),c=t.block||"nearest",u=r.viewport,h=IF(t.edgeOffset);t.maxWidth&&(d.x<u.x?(d.x=d.right-t.maxWidth,h.start=0):(d.width=Math.min(d.width,t.maxWidth),h.end=0)),t.maxHeight&&(d.y<u.y?(d.y=d.bottom-t.maxHeight,h.top=0):(d.height=Math.min(d.height,t.maxHeight),h.bottom=0));const f=t.x!==!1&&u.width>=d.width+(h.start+h.end)?h:{start:0,end:0},g=t.y!==!1&&u.height>=d.height+(h.top+h.bottom)?h:{top:0,bottom:0},m=new k(l?u.right+n-a:u.x-n,u.y-s,a,o),p=d.clone().adjust(-f.start,-g.top,f.end,g.bottom,!0).constrainTo(m),y=p.clone(),b=r.isRTL?-1:1;let C=0,D=0;if(c==="start")y.moveTo(u.x+(r.isRTL?u.width-y.width:0),u.y),C=p.x-y.x,D=p.y-y.y;else if(c==="end")y.moveTo(u.x+(r.isRTL?0:u.width-y.width),u.bottom-y.height),C=p.x-y.x,D=p.y-y.y;else if(c==="center"){const S=u.center;y.moveTo(S.x-y.width/2,S.y-y.height/2),C=C||p.x-y.x,D=D||p.y-y.y}else y.width>u.width?C=y.x-u.x:y.right>u.right?C=y.right-u.right:y.x<u.x&&(C=y.x-u.x),y.height>u.height?D=y.y-u.y:y.bottom>u.bottom?D=y.bottom-u.bottom:y.y<u.y&&(D=y.y-u.y);return C=b*Math.round(C),D=Math.round(D),t.constrainToScrollable!==!1&&(C=Math.max(Math.min(C,r.maxX-n),-n),D=Math.max(Math.min(D,r.maxY-s),-s)),{xDelta:t.x===!1?0:C,yDelta:t.y===!1?0:D}}get viewport(){return k.client(this.element)}updateWidget(e){this.rtlSource=this.owner=e}updateElement(e,t){var r;const n=this;if(n===cf._globalScroller){n._element=e,n.positionDirty=!0;return}const s=n.scrollHandler||(n.scrollHandler=n.onScroll.bind(n)),a=n.resizeHandler||(n.resizeHandler=n.onElResize.bind(n));if(t&&(He.remove(t,"scroller"),n.translate?(r=n.mutationObserver)==null||r.disconnect():(t.removeEventListener("scroll",s),t.classList.remove(t0),t.style.overflowX=t.style.overflowY=""),gt.removeResizeListener(t,a)),e){if(He.set(e,"scroller",n),n.translate){if(n.mutationObserver||(n.mutationObserver=new MutationObserver(n.mutationHandler||(n.mutationHandler=n.onElMutation.bind(n)))),n._x=n._y=0,document.contains(e)){const[o,l]=E.getTranslateXY(e);n._x=-o,n._y=-l}n.mutationObserver.observe(e,{attributes:!0})}else e.addEventListener("scroll",s),e.classList.add(t0);gt.addResizeListener(e,a),n.widget||(n.rtlSource={get rtl(){return E.getStyleValue(e,"direction")==="rtl"}}),n.isRTL&&e.classList.add("b-rtl"),n.positionDirty&&(n.updateOverflowX(n.overflowX),n.updateOverflowY(n.overflowY)),n.syncOverflowState(),n.isConfiguring&&(n._x&&n.updateX(n._x),n._y&&n.updateY(n._y))}n.positionDirty=!0}get x(){const e=this,{element:t}=e;if(t&&e.positionDirty){if(e.translate){const[r,n]=E.getTranslateXY(t);e._x=-r,e._y=-n}else e._x=Math.abs(t.scrollLeft),e._y=t.scrollTop;e.positionDirty=!1}return e._x}get scrollLeft(){return this.x*(this.isRTL?-1:1)}changeX(e){if(e=Math.max(e,0),!this.isConfiguring||e)return e;this._x=e}updateContentElement(e){e&&(e=typeof e=="string"?this.element.querySelector(e):e,gt.addResizeListener(e,this.resizeHandler))}updateX(e){var t;const r=this,{behavior:n,element:s}=r;s&&!((t=r.widget)!=null&&t.isConfiguring)&&(e=Math.round(e),r.trigger("scrollStart",{x:e}),r.translate?E.setTranslateX(s,-e):n?s.scrollTo({behavior:n,left:r.isRTL?-e:e}):s.scrollLeft=r.isRTL?-e:e),r.positionDirty=!0}sync(e,t){const r=this,{x:n,y:s}=t;let a=!1;return n&&r.x!==e.x&&(r.controllingPartner=e,r.x=e.x,a=!0),s&&r.y!==e.y&&(r.controllingPartner=e,r.y=e.y,a=!0),a}get y(){const e=this,{element:t}=e;if(t&&e.positionDirty){if(e.translate){const[r,n]=E.getTranslateXY(t);e._x=-r,e._y=-n}else e._x=t.scrollLeft,e._y=t.scrollTop;e.positionDirty=!1}return e._y}changeY(e){if(!this.isConfiguring||e)return e;this._y=e}updateY(e){const t=this,{behavior:r,element:n,widget:s}=t;n&&!(s!=null&&s.isConfiguring)&&(t.trigger("scrollStart",{y:e}),t.translate?E.setTranslateY(n,-e):r?n.scrollTo({behavior:r,top:e}):n.scrollTop=e),t.positionDirty=!0}get maxX(){return this.scrollWidth-this.clientWidth}get maxY(){return this.scrollHeight-this.clientHeight}get lastScrollLeft(){return(this.scrollWidth-this.clientWidth)*(this.isRTL?-1:1)}updateOverflowX(e,t){const r=this,{element:n,translate:s}=r,{style:a,classList:o}=n;t==="hidden-scroll"&&o.remove("b-hide-scroll"),e==="hidden-scroll"&&!s&&(qa[r.overflowY]?(e="hidden",r.enableWheel()):o.add("b-hide-scroll")),s||(a.overflowX=e0[e]||e),r.isConfiguring||(r.positionDirty=!0,r.syncOverflowState())}updateOverflowY(e,t){const r=this,{element:n,translate:s}=r,{style:a,classList:o}=n;t==="hidden-scroll"&&o.remove("b-hide-scroll"),e==="hidden-scroll"&&!s&&(qa[r.overflowX]?(e="hidden",r.enableWheel()):o.add("b-hide-scroll")),s||(a.overflowY=e0[e]||e),r.isConfiguring||(r.positionDirty=!0,r.syncOverflowState())}enableWheel(){this.wheelListenerRemover||(this.wheelListenerRemover=j.on({element:this.element,wheel:"onWheel",thisObj:this}))}onWheel(e){const t=this,{overflowX:r,overflowY:n}=t,s=e.deltaX,a=e.deltaY,o=Math.abs(s)-Math.abs(a);r==="hidden-scroll"&&qa[n]&&o>0?t.x+=s:n==="hidden-scroll"&&qa[r]&&o<0&&(t.y+=a)}get scrollWidth(){var e,t;return(t=(e=this.element)==null?void 0:e.scrollWidth)!=null?t:0}set scrollWidth(e){const t=this,{element:r,isRTL:n}=t;let s=t.widthStretcher;s&&e==null?(s.remove(),t.widthStretcher=null):e&&(e=Math.abs(e),s||(s=t.widthStretcher=E.createElement({className:"b-scroller-stretcher b-horizontal-stretcher",retainElement:!0})),s.style.transform=`translateX(${(e-1)*(n?-1:1)}px)`,r&&!r.contains(s)&&r.insertBefore(s,r.firstElementChild)),t.propagate!==!1&&t.eachPartner(({scroller:a})=>{a.propagate=!1,a.scrollWidth=e,delete a.propagate}),t.positionDirty=!0,t.syncOverflowState()}get scrollHeight(){var e,t;return(t=(e=this.element)==null?void 0:e.scrollHeight)!=null?t:0}set scrollHeight(e){const t=this,r=t.stretcher||(t.stretcher=E.createElement({className:"b-scroller-stretcher"}));r.style.transform=`translateY(${e-1}px)`,t.element&&t.element.lastChild!==r&&t.element.appendChild(r),t.positionDirty=!0,t.syncOverflowState()}get clientWidth(){var e;return((e=this.element)==null?void 0:e.clientWidth)||0}get clientHeight(){var e;return((e=this.element)==null?void 0:e.clientHeight)||0}get id(){return this._id||(this.widget?this._id=`${this.widget.id}-scroller`:this._id=Mi.generateId("scroller-")),this._id}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(),delete e.widget,delete e.element}};hs._$name="Scroller";var n0=i=>{var e;return e=class extends(i||$){get widgetClass(){}get keyMapElement(){return this.element}get keyMapSubComponents(){return this.features}matchKeyMapEntry(t,r=this.keyMap){if(r&&!t.handled&&t.key!==void 0)return T.keys(r).find(n=>{const{altKey:s,ctrlKey:a,metaKey:o,shiftKey:l}=t,d=n.toLowerCase().split("+"),c=n.endsWith("+")?"+":d.pop(),u=c==="space"?" ":c,h=d.includes("alt"),f=d.includes("ctrl"),g=d.includes("meta"),m=d.includes("shift");return u===t.key.toLowerCase()&&(h?s:!s)&&(f?a:!a)&&(g?o:!o)&&(m?l:!l)})}performKeyMapAction(t){var r,n;const s=this,{keyMap:a}=s;let o=!1,l,d,c,u;if(a&&!t.handled&&t.key!==void 0){const h=s.matchKeyMapEntry(t);if(a[h]){const f=H.asArray(a[h]);t.fromKeyMap=!0,t.widget=this;for(l of f){if(u=!0,T.isObject(l)){if(!l.handler)continue;l.preventDefault===!1&&(u=!1),l=l.handler}if(typeof l=="string"){const{thisObj:g,handler:m}=s.resolveKeyMapAction(l);if(((r=g.isActionAvailable)==null?void 0:r.call(g,{key:h,action:l,event:t,actionName:l.split(".").pop()}))!==!1&&m.call(g,t)!==!1){o=!0;break}}else if(l.call(s,t)!==!1){o=!0;break}}o&&(u&&t.preventDefault(),t.handled=!0)}if(!o&&(c=T.getTruthyKeys(a.delegate))){for(d of c)if(d=T.getPath(s,d),o=(n=d==null?void 0:d.performKeyMapAction)==null?void 0:n.call(d,t),o)break}}return o}resolveKeyMapAction(t){const r=this,{keyMapSubComponents:n}=r;if(t.startsWith("up.")||t.startsWith("this."))return r.resolveCallback(t);if(n&&t.includes(".")){const[s,a]=t.split(".");if(s&&a)return{thisObj:n[s],handler:n[s][a]}}return{thisObj:r,handler:r[t]}}updateKeyMap(t){var r;const n=this,s=T.keys(t);(r=n.keyMapDetacher)==null||r.call(n),n.keyMapDetacher=(s.length||null)&&j.on({element:n.keyMapElement,keydown:"keyMapOnKeyDown",thisObj:n})}keyMapOnKeyDown(t){this.performKeyMapAction(t)}mergeKeyMaps(t,r,n=null){const s={};t&&T.assign(s,t);for(const a in r){if(!r[a])continue;const o=H.asArray(t==null?void 0:t[a]),l=[];if(o!=null&&o.length&&l.push(...o),!(o!=null&&o.some(d=>{const c=d.handler?d.handler:d;return typeof c=="string"&&c.startsWith(n+".")}))){for(const d of H.asArray(r[a]))T.isObject(d)&&d.handler?l.push(T.assignIf({handler:(n?n+".":"")+d.handler},d)):typeof d=="function"?l.push(d):l.push((n?n+".":"")+d);l.sort((d,c)=>{const u=(d.weight||0)-(c.weight||0);return u===0&&(o!=null&&o.length)?o.indexOf(d)-o.indexOf(c):u})}s[a]=l}return s}},v(e,"$name","KeyMap"),v(e,"configurable",{keyMap:{value:null,$config:{merge:"objects",nullify:!0}}}),e},s0=i=>{var e;return e=class extends(i||$){get widgetClass(){}get isRTL(){return this.rtl}updateRtl(t){const{element:r}=this;r&&(r.classList.toggle("b-rtl",t===!0),r.classList.toggle("b-ltr",t===!1))}startConfigure(t){var r,n;if((r=super.startConfigure)==null||r.call(this,arguments),!t.floating&&t.rtl==null){const s=this,a=t.rootElement||t.forElement||((n=s.parent)==null?void 0:n.contentElement)||(s.floating?s.floatRoot:s.changeElementRef(s.getRenderContext(t)[0]||t.adopt));if(a)t.rtl=a.nodeType===1&&getComputedStyle(a).getPropertyValue("direction")==="rtl";else{const o=t.owner||t.parent;o?t.rtl=o[o.isConfiguring?"peekConfig":"getConfig"]("rtl"):t.rtl=getComputedStyle(document.body).getPropertyValue("direction")==="rtl"}t.rtl&&(s.configDone.rtl=!1)}}render(...t){var r,n,s;(r=super.render)==null||r.call(this,...t),(K.isChrome&&K.chromeVersion<87||K.isFirefox&&K.firefoxVersion<66||K.isSafari&&K.safariVersion<14.1)&&this.element.classList.add("b-legacy-inset"),(getComputedStyle(this.element).direction==="rtl"||(n=this.owner)!=null&&n.rtl)&&(this.rtl=!0,(s=this.childItems)==null||s.forEach(a=>a.rtl=!0))}},v(e,"$name","RTL"),v(e,"configurable",{rtl:null}),e},a0=Object.freeze({highlight:!1,onlyName:!1}),_F=Object.freeze([]),PF=Object.freeze({sync:!1}),Yf=[],AF=["clip","display","opacity"],Av="highlightExternalChange",Fv=/transparent|rgba\(0,\s*0,\s*0,\s*0\)/,qf=Symbol("renderConfigObserver"),FF=/<div|<button|<input|<p|<br|<li/,kF={INPUT:1,TEXTAREA:1},o0=(i,e,t,r)=>{let n=(t==null?void 0:t.listeners)||(t==null?void 0:t.internalListeners);if(n=(n==null?void 0:n.on)||n,n){const s=j.on(T.assign({element:e,thisObj:i},n));r?(i._refListeners||(i._refListeners=Object.create(null)))[r]=s:t.listeners={on:n,un:s}}},l0=(i,e)=>i&&e&&e[T.keys(i)[0]]?Oe.merge(i,e):i,LF=i=>{i.isVisible&&i.triggerPaint()},OF=/^:not\((.+)\)$/,$F=/absolute|fixed/i,BF=i=>i.scale!=null,{hasOwn:fs}=T,{defineProperty:d0}=Reflect,c0=i=>parseFloat(i)*(i.endsWith("ms")?1:1e3),u0=["b-aligned-above","b-aligned-right","b-aligned-below","b-aligned-left"],HF={configurable:!0,value:!1},h0=/(?:L\{([^}.]+)\})/,f0=/^([trblc])(\d*)-([trblc])(\d*)$/i,jF=(i,e)=>(f0.test(i)&&(i={align:i}),f0.test(e)&&(e={align:e}),Oe.merge(i,e)),VF=/^[\w.]+$/,g0={1:"maxHeight",2:"height",4:"maxWidth",8:"width"},zF=i=>!i.isRipple&&!i.closest(e=>e.isMessageDialog||e.isSharedTooltip),kv=i=>E.getStyleValue(i,"display")==="contents"?kv(i.parentNode):i,NF=i=>{if(i!=null&&i.target){const{ownerSVGElement:e}=i.target,t=e==null?void 0:e.getBoundingClientRect();if(e)return{target:i.target.ownerSVGElement,offsetX:i.clientX-t.x,offsetY:i.clientY-t.y};let{offsetX:r,offsetY:n}=i,s=kv(i.target);if(E.getStyleValue(i.target,"display")==="contents"){const a=s.getBoundingClientRect(s);r-=a.x,n-=a.y}return{target:kv(i.target),offsetX:r,offsetY:n}}},Kf=class ge extends $.mixin(qe,Ve,ve,Ud,ds,n0,s0){static mergeCls(e,t){return t&&e?e=new se(t).assign(typeof e=="string"?new se(e):e):e&&!e.isDomClassList&&(e=new se(e)),e}static get configurable(){return{element:!0,callOnFunctions:!0,hideMode:{$config:null,default:"display"},id:null,html:{$config:"lazy",value:null},content:{$config:"lazy",value:null},cls:{$config:{merge:"classList"},value:null},ui:{$config:{merge:"classList"},value:null},collapsify:null,contentElementCls:{$config:{merge:"classList"},value:null},defaultCls:{$config:{merge:"classList"},value:null},dock:null,parent:null,tab:null,elementAttributes:null,htmlCls:{$config:{merge:"classList"},value:{"b-html":1}},style:null,disabled:null,readOnly:{value:null,default:!1,$config:null},ignoreParentReadOnly:null,adopt:null,appendTo:null,insertBefore:null,insertFirst:null,dataset:null,tooltip:{$config:["lazy","nullify"],value:null},showTooltipWhenDisabled:!0,preventTooltipOnTouch:null,monitorResize:{$config:["lazy","nullify"],value:null},masked:{$config:"nullify",value:null},maskDefaults:{target:"element"},floating:null,positionable:null,positioned:null,draggable:null,align:{$config:{merge:jF},value:"t-b"},centered:null,constrainTo:void 0,anchor:null,owner:{$config:["lazy","nullify"],value:null},scrollAction:null,hideAnimation:{$config:{merge:l0},value:null},showAnimation:{$config:{merge:l0},value:null},top:null,right:null,bottom:null,left:null,x:null,y:null,scrollable:{$config:["lazy","nullify"],value:null},scrollerClass:hs,defaultBindProperty:"html",defaultAction:null,overflowable:{value:null,default:!0,$config:null},width:null,height:null,maxHeight:null,maxWidth:null,minWidth:null,minHeight:null,scaleToFitWidth:null,allowGrowWidth:!0,margin:null,flex:null,weight:null,alignSelf:null,ripple:null,title:null,localizableProperties:["title","ariaLabel","ariaDescription"],requireSize:!1,ref:null,hidden:null,textAlign:null,ignoreScrollDuration:500,tag:"div",recomposeAsync:null,rootElement:null,htmlMutationObserver:{$config:["lazy","nullify"],value:{childList:!0,subtree:!0}},role:{$config:"lazy",value:"presentation"},ariaLabel:{$config:"lazy",value:null},ariaDescription:{$config:"lazy",value:null},ariaLive:{$config:"lazy",value:null},ariaElement:"element",ariaHasPopup:null,realignTimeout:300,testConfig:{ignoreScrollDuration:100,realignTimeout:50},maximizeOnMobile:null,twinForwardEvents:{$config:{merge:"classList"},value:null},twinSyncConfigs:{$config:{merge:"classList"},value:["disabled"]}}}static get prototypeProperties(){return{hasGeneratedId:!1,hasPainted:!1,innerItem:!0}}static get declarable(){return["renderConfigs"]}static get delayable(){return{recompose:"raf",doHideOrRealign:"raf",onAlignConstraintChange:"raf"}}static get factoryable(){return{defaultType:"widget"}}static get identifiable(){return{}}static get all(){return super.all}static get recomposeAsync(){return ge._recomposeAsync}static set recomposeAsync(e){if(ge._recomposeAsync=e,e!=null){const{all:t}=ge;for(let r=0;r<t.length;++r)t[r].isComposable&&(t[r].recomposeAsync=e)}}updateWeight(){var e,t;this.isPainted&&((t=(e=this.parent)==null?void 0:e.onChildWeightChange)==null||t.call(e,this))}isA(e){return this.isType(e,!0)}isType(e,t){return ge.isType(this,e,t)}static setupRenderConfigs(e,t){const r=t.getInherited("renderConfigs"),{renderConfigs:n}=e;if(n){if(Array.isArray(n))for(const s of n)r[s]=!0;else T.assign(r,n);r[qf]=null}}static weightSortFn({weight:e},{weight:t}){return typeof e=="string"||typeof t=="string"?String(e).localeCompare(String(t)):(e!=null?e:Number.MAX_SAFE_INTEGER)-(t!=null?t:Number.MAX_SAFE_INTEGER)}construct(e={},...t){const r=this,{domSyncCallback:n}=r,{recomposeAsync:s}=ge;if(s!=null&&r.recomposeAsync==null&&(r.recomposeAsync=s),!globalThis.bryntum.cssVersion){const a=globalThis.bryntum.cssVersion=oc.getCSSVersion(),o=de.getVersion("core");a&&a!==o&&console.warn(`CSS version ${a} doesn't match bundle version ${o}!
Make sure you have imported css from the appropriate product version.`)}r.configureAriaDescription=e.ariaDescription,r._isAnimatingCounter=0,r.alignmentChanges=0,r.byRef=Object.create(null),r.onTargetResize=r.onTargetResize.bind(r),r.onFullscreenChange=r.onFullscreenChange.bind(r),r.domSyncCallback=n.$nullFn?null:n.bind(r),r._isUserAction=!1,super.construct(e,...t),r.finalizeInit()}startConfigure(e){super.startConfigure(e),this.getConfig("element")}finalizeInit(){var e;const t=this,{adopt:r}=t,n=t.insertBefore||t.appendTo||t.insertFirst||r;t.getConfig("html"),t.getConfig("content"),n&&(r&&(t.element.classList.remove("b-hidden"),t._hidden=!1),t.owner||(e=n.nodeType?n:document.getElementById(n))!=null&&e.isConnected?t.render():(t.onFirstResizeAfterConnect=t.onFirstResizeAfterConnect.bind(t),gt.addResizeListener(n,t.onFirstResizeAfterConnect)))}onFirstResizeAfterConnect(e){gt.removeResizeListener(e,this.onFirstResizeAfterConnect),!this.isDestroyed&&!this.rendered&&this.render()}doDestroy(){var e,t,r,n;const s=this,{preExistingElements:a,element:o,adopt:l,_refListeners:d,_rootElement:c,eventRoot:u,ownedWidgets:h}=s;if(Ui.element===o&&Ui.exit(),d&&(Object.values(d,f=>f()),s._refListeners=null),o){const f=!s._tooltip&&c&&((e=ge.Tooltip)==null?void 0:e.getSharedTooltip(c,u,!0));if((f==null?void 0:f.owner)===s&&(f.owner=null,f.hide()),s.onExitFullscreen(),s.clearTimeout("scrollListenerTimeout"),s.clearTimeout("resizeListenerTimeout"),s.removeTransientListeners(),s.floating||s.positioned||s.positionable?s.isPainted&&s.hide(!1):s.revertFocus(),gt.removeResizeListener(o.parentElement,s.onParentElementResize),gt.removeResizeListener(o,s.onElementResize),l){for(let g=Array.from(o.childNodes),m=0,{length:p}=g;m<p;m++){const y=g[m];!a.includes(y)&&y!==s.floatRoot&&y.remove()}o.className=s.adoptedElementClassName,o.style.cssText=s.adoptedElementCssText}(t=s.dragEventDetacher)==null||t.call(s),(r=s.dragOverEventDetacher)==null||r.call(s),s.dragGhost.remove()}(n=s.connectedObserver)==null||n.disconnect(),super.doDestroy(),h&&Object.values(h).forEach(f=>{var g;return(g=f.destroy)==null?void 0:g.call(f)}),u&&Promise.resolve().then(()=>{Object.values(ge.identifiable.idMap).some(zF)||ue.detachFocusListeners(u)}),l||o.remove()}get assignValueDefaults(){return a0}get valueName(){return this.name||this.ref||this.id}getValueName(e){return e=e&&typeof e=="object"?e.onlyName:e,e?this.name:this.valueName}assignFieldValue(e,t,r){const n=this,s=n.defaultBindProperty;s in n&&(n[s]=r)}assignValue(e,t=a0){const r=this,n=r[Av],s=r.getValueName(t);s&&(!e||s in e)&&(t.highlight===!1&&(r[Av]=!1),r.assignFieldValue(e,s,e?e[s]:null),r[Av]=n)}gatherValue(e){const t=this,r=t.defaultBindProperty;t.constructor!==ge&&r in t&&(e[t.name||t.ref||t.id]=t[r])}gatherValues(e){this.eachWidget(t=>t.gatherValue(e),!1)}addToOverflowMenu(e,t,r){const n=this.ensureOverflowTwin(t,r);e.items.push(n)}get twinForwardEventPairs(){const e=this._twinForwardEvents;return e?T.entries(e):_F}configureOverflowTwin(e){const t=this,{twinSyncConfigs:r}=t;let n=T.clone(t.initialConfig),s,a;if(delete n.id,delete n.listeners,delete n.internalListeners,delete n.parent,n.hidden=!1,n.type=t.type,n._overflowTwinOrigin=t,n.owner=t.owner,t.twinForwardEventPairs.forEach(([o])=>{delete n[`on${O.capitalize(o)}`]}),r)for(s in r)a=r[s],a&&(delete n[s],n[typeof a=="string"?a:s]=t[s]);return e&&(n=typeof e=="function"?e(n)||n:T.assign(n,e)),n}createOverflowTwin(e){const t=this,r=t.configureOverflowTwin(e),n=ge.create(r),{twinSyncConfigs:s}=t;return s&&t.bindConfigs(n,s,PF),t.twinForwardEventPairs.forEach(([a,o])=>{n.ion({[a]:l=>{t.overflowTwin===l.source&&(l=T.assign({},l),delete l.source,t.trigger(typeof o=="string"?o:l.eventName,l))}})}),n}ensureOverflowTwin(e,t){let{overflowTwin:r}=this;return r||(this.overflowTwin=r=this.createOverflowTwin(e),t==null||t(r)),r}get isComposable(){return!this.compose.$nullFn}adoptElement(e){const t=this,r=typeof e=="string"?document.getElementById(e):e,n=ge.fromElement(r);return n&&n.adopt&&n!==t&&(typeof n.adopt=="string"?document.getElementById(n.adopt):n.adopt)===r&&n.destroy(),t.preExistingElements=Array.from(r.childNodes),t.adoptedElementClassName=r.className,t.adoptedElementCssText=r.style.cssText,r.lastDomConfig=null,r.$refOwnerId=t.id,r.className=r.style.cssText="",r}addRefAccessor(e,t){const{prototype:r}=this.constructor;d0(r,t,{writable:!0,value:null}),d0(r,e,{get(){return this.recompose.flush(),this[t]},set(n){this[t]=n}})}attachRef(e,t,r){const n=this,s="_"+e;t.dataset&&(t.dataset.ownerCmp=n.id),n.isComposable&&(s in n||n.addRefAccessor(e,s),o0(n,t,r,e)),n.byRef[e]=t,n[e]=t}detachRef(e,t,r){const n=this,s=n._refListeners;s!=null&&s[e]&&(s[e](),delete s[e]),n[e]=null,delete n.byRef[e]}afterRecompose(){}compose(){const{widgetClassList:e}=this;return{class:{...se.normalize(e,"object")}}}doCompose(){const e=this,{$meta:t}=e,r=t.hierarchy,n=t.renderConfigs||t.getInherited("renderConfigs");let{composers:s}=t,a=null,o,l,d,c;if(e.recompose.suspend(),!s){for(t.composers=s=[],d=r.indexOf(ge);d<r.length;++d)c=r[d].prototype,fs(c,"compose")&&s.push(c);fs(n,qf)||(n[qf]={get(u){u!=="element"&&(n[u]=!0)}})}for(e.configObserver=n[qf],d=0;d<s.length;++d)o=s[d].compose.call(e,a),a=a?E.merge(a,o):o;return fs(e,"compose")&&(o=e.compose)&&(o=o.call(e,a),E.merge(a,o)),e.configObserver=null,E.normalizeChildren(a,(u,h)=>{h&&(l="_"+u,l in e||e.addRefAccessor(u,l))})}get element(){return this.isComposable&&!this.isDestroying&&this.recompose.flush(),this._element}domSyncCallback(e){}changeElement(e){const t=this,r=t.isComposable,{adopt:n}=t;return t.id=t.id||(n==null?void 0:n.id)||null,n?e=t.adoptElement(n):r&&(e=t.doCompose()),typeof e=="string"?e=E.createElementFromTemplate(e):T.isObject(e)?(e=E.createElement(e,{refOwner:t,callback:t.domSyncCallback}),t.recompose.resume()):E.isReactElement(t.peekConfig("html"))?e=document.createElement("div"):e.nodeType!==1&&(e=E.createElementFromTemplate(t.template(t))),!e.id&&(e.id=t.id),t.elementAttributes&&E.setAttributes(e,t.elementAttributes),e}updateElement(e){const t=this,r=t.isComposable;t.adopt&&(t._hidden=!0,r&&t.recomposeNow()),r&&o0(t,e,e.lastDomConfig);const{className:n}=e,{contentElement:s,contentElementCls:a,isComposable:o}=t,l=s!==e,d=!o&&e.querySelectorAll("[data-reference]"),c=o?[]:t.widgetClassList;let u=(l||!o)&&t.uiClasses;if(n&&c.unshift(n),t._hidden&&c.push("b-hidden",`b-hide-mode-${t.hideMode}`),t._readOnly&&c.push("b-readonly"),Se.noThrow(e,"remove"),u?(a!=null&&a.value&&(u=u.slice(),u.push(a.value)),u=u.join(" ")):u=a==null?void 0:a.value,u&&(l?s.className+=" "+u:c.push(u)),!t.parent){const{defaultCls:h}=t,{outerCls:f}=ge;c.push(...h?f.filter(g=>!(g in h)||h[g]):f)}if(e.className=c.join(" "),d)for(let h,f=0;f<d.length;++f)h=d[f],t.attachRef(h.getAttribute("data-reference"),h),h.removeAttribute("data-reference");t.scaleToFitWidth||t.getConfig("monitorResize"),t.getConfig("role"),t.getConfig("ariaLabel"),t.getConfig("ariaDescription"),t._html&&t.getConfig("htmlMutationObserver"),t.trigger("elementCreated",{element:e})}updateAriaDescription(e){const{ariaElement:t}=this,r=`${this.id}-aria-desc-el`;if(e){const n=this._ariaDescEl||(this._ariaDescEl=E.createElement({className:"b-aria-desc-element",id:r,parent:t}));n.innerText=e.match(h0)?this.L(e,this):e,E.addAttributeValue(t,"aria-describedBy",r)}else E.removeAttributeValue(t,"aria-describedBy",r)}updateAriaLabel(e){E.setAttributes(this.ariaElement,{"aria-label":e!=null&&e.match(h0)?this.L(e,this):e})}updateAriaHasPopup(e){E.setAttributes(this.ariaElement,{"aria-haspopup":e})}updateAriaLive(e){E.setAttributes(this.ariaElement,{"aria-live":e})}updateRole(e){var t,r;e?(t=this.ariaElement)==null||t.setAttribute("role",e):(r=this.ariaElement)==null||r.removeAttribute("role")}get ariaElement(){this.getConfig("element");const{_ariaElement:e}=this;return e.nodeType===Node.ELEMENT_NODE?e:T.getPath(this,e)}isCollapsified({collapsed:e,alt:t}){const{collapsify:r}=this,n=r==="hide",s=r===!1,a=r==null;return t?r==="overlay"||a&&e:s||n||a&&!e}async recompose(){return this.recomposeInternal()}async recomposeInternal(){const e=this,t={targetElement:e.element,domConfig:e.doCompose(),refOwner:e,callback:e.domSyncCallback,strict:!0};if(e.transitionRecompose){if(e.isTransitioningDom=!0,await E.transition(T.assign({element:e.element,action(){oe.sync(t)}},e.transitionRecompose)),e.isDestroyed)return;e.isTransitioningDom=!1,e.trigger("transitionedRecompose")}else oe.sync(t);t.changed&&(e.afterRecompose(),e.trigger("recompose")),e.resumeRecompose()}resumeRecompose(){this.recompose.resume()}changeElementRef(e){if(typeof e=="string"){const t=e;if(!(e=document.getElementById(t)))throw new Error(`No element found with id '${t}'`)}return e}changeAppendTo(e){return this.changeElementRef(e)}updateAppendTo(e){!this.isConfiguring&&e&&this.render()}changeInsertBefore(e){return this.changeElementRef(e)}updateInsertBefore(e){!this.isConfiguring&&e&&this.render()}changeInsertFirst(e){return this.changeElementRef(e)}updateInsertFirst(e){!this.isConfiguring&&e&&this.render()}getRenderContext(e=this,t){let r=t||e.appendTo,{insertFirst:n,insertBefore:s}=e;return n&&(r=n,s=r.firstChild),s&&(r=s.parentElement),[r,s||void 0]}render(e,t=!0){var r;const n=this,{element:s}=n,[a,o]=n.getRenderContext(n,e);n.emptyCache(),n.syncElement&&n.currentElement?E.sync(s,n.currentElement):(a==null||a.insertBefore(s,o),n.currentElement=s),(r=s.parentElement)!=null&&r.closest(".b-widget")&&s.classList.remove(...ge.outerCls),super.render(a,t),n.rendered=!0,n.getConfig("role"),t&&(n.getConfig("contentRange"),n.triggerPaint()),n.setupFocusListeners()}template({tag:e,html:t,htmlCls:r,name:n}){const s=this;typeof t=="string"&&VF.test(t)&&s.resolveCallback(t,s,!1)&&(t=s.callback(t,s,[s]));const a=t!=null&&t.call?t.call(s,s):t;return`<${e} class="${a?r:""}" ${n?`data-name="${n}"`:""}>${a||""}</${e}>`}updateRecomposeAsync(e){this.recompose.immediate=!e}onConfigChange({name:e}){var t;this._element&&!this.isDestroying&&((t=this.$meta.renderConfigs)!=null&&t[e])&&this.recompose()}preProcessCurrentConfigs(e){super.preProcessCurrentConfigs(e),delete e.parent}getConfigValue(e,t){return e==="style"?this._style:super.getConfigValue(e,t)}getCurrentConfig(e){const t=super.getCurrentConfig(e);return(e==null?void 0:e.depth)>0&&(t.type=this.type),t}get dataset(){return this.element.dataset}changeDataset(e){T.assign(this.dataset,e)}get dragGhost(){return this.constructor._dragGhost||(this.constructor._dragGhost=E.createElement({html:"\xA0",style:"position:absolute;top:-10000em;left:-10000em"}))}updateParent(e){const{_element:t}=this;t&&t.classList[e?"remove":"add"](...ge.outerCls)}get constrainTo(){let e=this._constrainTo;if(e=e===void 0?globalThis:(e==null?void 0:e.nodeType)===Node.DOCUMENT_FRAGMENT_NODE?e.host||e.ownerDocument:e,this.positioned){const{offsetParent:t}=this.element;if(t&&E.getStyleValue(t,"overflow")==="hidden")e=k.from(t).moveTo(0,0);else if(e&&!e.isRectangle){const r=e===document||e===globalThis;e=k.from(e,t),r&&e.translate(globalThis.pageXOffset,globalThis.pageYOffset)}}return e}updateCentered(e){const t=this,{element:r,_anchorElement:n}=t;if(e&&!t.floating&&!t.positioned)throw new Error("`centered` is only relevant when a Widget is `floating` or `positioned`");e?(r.classList.add("b-centered"),r.style.transform=r.style.left=r.style.insetInlineStart=r.style.right=r.style.top="",n==null||n.classList.add("b-hide-display"),r.classList.remove("b-anchored")):r.classList.remove("b-centered")}get contentElement(){return this.element}get contentRange(){const e=this,t=e._contentRange||(e._contentRange=new Range);return t.collapsed&&(e.initializingHtml&&e.adopt?t.setStart(e.contentElement,0):t.selectNodeContents(e.contentElement)),t}fixRefOwnerId(e,t,r){if(e.$refOwnerId===r){e.$refOwnerId=t;for(let{childNodes:n}=e,s=n.length;s-- >0;)this.fixRefOwnerId(n[s],t,r)}}get placement(){var e;const t=this,{element:r}=t;let n,s,a;if(r!=null&&r.offsetParent&&!$F.test(E.getStyleValue(r,"position"))){const o=r.nextElementSibling,l=r.previousElementSibling,d=!o&&l;s=E.getStyleValue(r.parentElement,"flex-direction"),s?s=s.startsWith("row")?"h":"v":(n=(e=o||l)==null?void 0:e.getBoundingClientRect(),a=n&&r.getBoundingClientRect(),s=n&&Math.abs(n.top-a.top)<Math.abs(n.left-a.left)?"h":"v"),s+=s==="h"?d?"r":"l":d?"b":"t"}return s}updateId(e,t){if(super.updateId(e,t),t){const{byRef:r,element:n}=this;for(const s in r)r[s].dataset&&(r[s].dataset.ownerCmp=e);n.id=e,this.fixRefOwnerId(n,e,t)}}get style(){const{element:e}=this;return(e==null?void 0:e.ownerDocument.defaultView.getComputedStyle(e))||this._style}updateStyle(e){this.element&&E.applyStyle(this.element,e)}updateTitle(e){this.titleElement&&(this.titleElement.innerHTML=e)}beforeAlignTo(e){}alignTo(e){var t,r;const n=this,{lastAlignSpec:s,element:a}=n,{offsetParent:o,style:l,classList:d}=a;if(s&&(s.monitorIntersection&&n.intersectionObserver.unobserve(s.target),isFinite(s.zone)&&a.classList.remove(u0[s.zone])),!e){n.removeTransientListeners(),n.anchor=n.lastAlignSpec=null;return}n.beforeAlignTo(e),(e.nodeType===Element.ELEMENT_NODE||e.isWidget||e.$$name==="Point")&&(e={target:e}),n.releaseSizeConstraints();const{scrollable:c,constrainTo:u}=n,h=E.measureSize(E.getStyleValue(a,"minHeight"),a),f=E.measureSize(E.getStyleValue(a,"minWidth"),a),g=n.positioned&&E.getStyleValue(a,"position")!=="fixed",m=n.scale||1,p=e.target,y=e.realignEvent||NF(e.domEvent||e.event||(((t=p==null?void 0:p.target)==null?void 0:t.nodeType)===Node.ELEMENT_NODE?p:null)),b=((r=y==null?void 0:y.target)==null?void 0:r.nodeType)===Element.ELEMENT_NODE,C=b?y.target:p!=null&&p.isRectangle?p:(p==null?void 0:p.element)||p,D=(C==null?void 0:C.nodeType)===Element.ELEMENT_NODE;e=e.realignTarget?T.clone(e):T.merge({aligningToEvent:b,aligningToElement:D,constrainTo:u,align:"b-t",axisLock:n.axisLock,anchor:n.anchor},n.align,e),b&&(e.domEvent=y);const S=e.minWidth||f,x=e.minHeight||h;if(n.lastAlignSpec=e,D&&(e.target=e.anchoredTo=C,en(C instanceof SVGElement?C.closest("svg"):C))){if(e=Object.setPrototypeOf({},e),e.target=n.lastAlignSpec.targetRect=e.realignTarget||(e.allowTargetOut?k.from(C,g?o:null,!g):E.isInView(b?y:C,!1,n)),!e.target){const U=n.hide();return n.isDestroyed||(n.lastAlignSpec.targetOutOfView=!0),U}e.target.height=Math.max(e.target.height,1),e.target.width=Math.max(e.target.width,1)}if(e.anchor&&(e.anchorSize=n.anchorSize,a.contains(n.anchorPathElement)||a.appendChild(n.anchorElement)),typeof e.offset=="string"){const U=a.querySelector(e.offset),Z=k.from(U),fe=Z.getAlignmentPoint(e.align),J=k.from(a),me=J.getAlignmentPoint(e.align);e.offset=[me[0]-fe[0],me[1]-fe[1]]}n.isAligning=!0,n.trigger("beforeAlign",e);const R=k.from(a,g?o:null,!0),{width:M,height:I}=R;R.isAlignRectangle=!0,S&&(R.minWidth=S*m),x&&(R.minHeight=x*m),n.isAligning=!1,e.rtl=n.rtl,(e.align.includes("s")||e.align.includes("e"))&&(n.rtl?e.align=e.align.replace(/s/g,"r").replace(/e/g,"l"):e.align=e.align.replace(/s/g,"l").replace(/e/g,"r"));const _=n.lastAlignSpec.result=R.alignTo(e);let{align:P,anchor:A,x:L,y:F,width:N,height:Y,overlap:G}=_;if(n.lastAlignSpec.zone=_.zone,Y!=I){const U=Y<I;n.alignmentChanges=n.alignmentChanges|(U?1:2),l[n.alignedHeightStyle=g0[n.alignmentChanges&3]]=`${Y/m}px`,U&&!n._minHeight&&h&&(l.minHeight=`${Math.min(Y,h)/m}px`),c&&(c.overflowY=U)}if(N!=M){const U=N<M;n.alignmentChanges=n.alignmentChanges|(U?4:8),l[n.alignedWidthStyle=g0[n.alignmentChanges&12]]=`${N/m}px`,U&&!n._minWidth&&f&&(l.minWidth=`${Math.min(N,f)/m}px`),c&&(c.overflowX=U)}if(P&&n.alignmentChanges){const U=k.from(a,g?o:null,!0);e.align=P;const Z=n.lastAlignSpec.result=U.alignTo(e);A=Z.anchor,L=Z.x,F=Z.y,N=Z.width,Y=Z.height}if(n.centered||n.setXY(L,F),!_.overlap&&isFinite(_.zone)&&d.add(u0[_.zone]),A!=null&&A.edge){let{edge:U}=A;const{anchorElement:Z}=n,{style:fe}=Z,{style:J}=Z.firstChild,me=k.from(a),Q=[];U==="top"||U==="bottom"?(Q[0]=A.x,Q[1]=U==="top"?1:me.height-1):(Q[0]=U==="left"?1:me.width-1,Q[1]=A.y),fe.display="none";let re=E.childFromPoint(a,...Q);if((re!=null&&re.matches(":focus")||re===ue.currentOverElement)&&a.compareDocumentPosition(re)&Node.DOCUMENT_POSITION_CONTAINED_BY&&(re=re.parentNode),re&&re!==document){let je=E.getStyleValue(re,"background-color");for(;je.match(Fv)&&E.getStyleValue(re,"position")!=="absolute"&&(re=re.parentNode,re!==document);)je=E.getStyleValue(re,"background-color");je.match(Fv)?n.anchorPathElement.setAttribute("fill",n.defaultAnchorBackgroundColor):n.anchorPathElement.setAttribute("fill",je)}fe.transform=fe.display="",(U==="left"||U==="right")&&(U=U==="left"?n.rtl?"end":"start":n.rtl?"start":"end"),Z.className=`b-anchor b-anchor-${U}`,A.x&&(A.x/=m),A.y&&(A.y/=m),J.left=`${A.x||0}px`,J.translate=`0 ${A.y||0}px`,d.add("b-anchored")}else n._anchorElement&&(n.anchorElement.classList.add("b-hide-display"),d.remove("b-anchored"));if(!D){l.pointerEvents="none";const U=E.elementFromPoint(L,F);n.owns(U)||(n.lastAlignSpec.anchoredTo=U),l.pointerEvents=""}if((n.scrollAction==="realign"&&D||n.scrollAction==="hide")&&!n.documentScrollListener&&(n.clearTimeout("scrollListenerTimeout"),e.monitorTargetMutation&&!n.targetObserver&&(n.targetObserver||(n.targetObserver=new MutationObserver(n.onTargetParentMutation.bind(n)))).observe(E.getRootElement(C),{childList:!0,attributes:!0,subtree:!0}),n.setTimeout(()=>{const U=D?C:n.lastAlignSpec.anchoredTo,Z=U?E.getRootElement(U):null;n.documentScrollListener=j.addListener({element:document,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:n}),Z!=null&&Z.mode&&(n.targetRootScrollListener=j.addListener({element:Z,scroll:"doHideOrRealign",transitionend:"realignOnTransitionEnd",capture:!0,thisObj:n}))},n.scrollAction==="hide"?n.ignoreScrollDuration:0,"scrollListenerTimeout")),D&&(e.monitorResize&&!n.observedTargetEl&&(gt.addResizeListener(C,n.onTargetResize),n.observedTargetEl=C),e.monitorIntersection&&!(G||C.contains(a)||C.ownerSVGElement)&&n.intersectionObserver.observe(C)),!K.isAndroid&&!n.observedConstrainEl){const U=u!=null&&u.isRectangle?globalThis:u;n.clearTimeout("resizeListenerTimeout"),n.setTimeout(()=>{n.observedConstrainEl=U||globalThis,gt.addResizeListener(n.observedConstrainEl,n.onAlignConstraintChange)},n.ignoreScrollDuration,"resizeListenerTimeout")}}onTargetParentMutation(e){var t;const{element:r,lastAlignSpec:n}=this;n!=null&&n.aligningToElement&&((t=n.target)!=null&&t.isConnected?e.some(({target:s})=>s.contains(n.target)&&!r.contains(s))&&this.realign():this.hide())}get intersectionObserver(){return this._intersectionObserver||(this._intersectionObserver=new IntersectionObserver(this.onTargetIntersectionchange.bind(this),{root:K.isSafari?this.rootElement:this.rootElement.ownerDocument}))}onTargetIntersectionchange(e){if(!this.isDestroyed){const t=e[e.length-1];t.isIntersecting||this.onAlignTargetOutOfView(t.target)}}onTargetResize(){const{lastAlignSpec:e}=this;if(e){const{width:t,height:r}=e.targetRect,{width:n,height:s}=e.target.getBoundingClientRect();(n!==t||s!==r)&&this.onAlignConstraintChange(...arguments)}}onAlignTargetOutOfView(e){this.hide(),this.lastAlignSpec&&(this.lastAlignSpec.targetOutOfView=!0)}onAlignConstraintChange(e,t,{height:r}){const{style:n}=this.contentElement,{overflowY:s}=n;this.setTimeout(this.realign,50),t&&r>t.height&&(n.overflowY="hidden",this.requestAnimationFrame(()=>n.overflowY=s))}realign(){const e=this,{lastAlignSpec:t}=e;if((e.floating||e.positioned)&&t&&e.isVisible){if(t.aligningToElement){const r=t.target.contains(this.element),n=E.isInView(t.target,!1,e);if(!t.allowTargetOut&&(!en(t.target)||!n)){e.hide(),e.isDestroyed||(e.lastAlignSpec.targetOutOfView=!0);return}t.realignEvent=t.domEvent,t.realignTarget=r||t.aligningToEvent?null:n}E.addTemporaryClass(e.element,"b-realigning",e.realignTimeout,e),e.alignTo(t)}}rectangle(e,t,r){return this.rectangleOf("element",e,t,r)}rectangleOf(e,t,r,n){return typeof t!="string"?(n=r,r=t,t=""):t==="border"&&(t=""),typeof r=="boolean"&&(n=r,r=void 0),e!=="element"&&r===void 0&&(r=this.element),r=r!=null&&r.isWidget?r.element:r,typeof e=="string"&&(e=this[e]),k[t||"from"](e,r,n)}releaseSizeConstraints(){const e=this,{scrollable:t,element:r,alignmentChanges:n}=e,{style:s}=r;n&12&&(E.setLength(r,e.alignedWidthStyle,e[`_last${O.capitalize(e.alignedWidthStyle)}`]||""),s.minWidth=e._minWidth||"",t&&(t.overflowY=t.config.overflowY)),n&3&&(E.setLength(r,e.alignedHeightStyle,e[`_last${O.capitalize(e.alignedHeightStyle)}`]||""),s.minHeight=e._minHeight||"",t&&(t.overflowX=t.config.overflowX)),e.alignmentChanges=0}toFront(){const{element:e}=this,t=this.floating?this.floatRoot:this.positioned?e==null?void 0:e.parentNode:null,r=document.createDocumentFragment();if(this.containsFocus){for(let n=e.nextSibling,s;n;n=s)s=n.nextSibling,t.contains(n)&&!this.owns(n)&&r.appendChild(n);t.insertBefore(r,e)}else t.appendChild(e)}updateRef(e){this.element.dataset.ref=e}get overflowElement(){return this.contentElement}get maxHeightElement(){return this.element}changeAlign(e){return typeof e=="string"?{align:e}:e}changeScrollable(e,t){return typeof e=="boolean"&&(e={overflowX:e,overflowY:e}),e?(e.element=this.overflowElement,e.widget=this,e.isScroller||(e=t?t.setConfig(e):new this.scrollerClass(e)),e.syncOverflowState()):t==null||t.destroy(),e}handleReactElement(e){var t;const r=this.closest(s=>s.reactComponent),n=(r==null?void 0:r.reactComponent)||((t=bryntum==null?void 0:bryntum.query(s=>{var a;return!!((a=s.reactComponent)!=null&&a.state)}))==null?void 0:t.reactComponent);n==null||n.processWidgetContent({reactElement:e,widget:this,reactComponent:n})}get html(){return this.isConfiguring?this.content||this._html:this.contentElement.innerHTML}changeHtml(e){return e&&typeof e=="object"&&!E.isReactElement(e)&&!Array.isArray(e)&&(e=[e]),e}updateHtml(e){const t=this;t.noChildElements=typeof e=="string"&&!FF.test(e),t.initializingElement||t.insertContent(e,!(t.initializingHtml&&t.adopt))}changeHtmlMutationObserver(e,t){const r=this,{contentElement:n}=r;if(t==null||t.disconnect(),e){const s=new MutationObserver(()=>{r.updatingHtml?r.updatingHtml=!1:r._html=n.innerHTML});return s.observe(n,e),s}}updateContent(e){this.initializingElement||this.insertContent(e)}insertContent(e,t=!1){const r=this,{element:n,contentElement:s,htmlCls:a,contentRange:o,autoClose:l}=r,d=t&&s===n&&r._anchorElement;if(E.isReactElement(e))return r.handleReactElement(e);if(r.updatingHtml=!0,r.getConfig("htmlMutationObserver"),d&&n.removeChild(d),a&&a.values.forEach(c=>n.classList[e?"add":"remove"](c)),r.autoClose=!1,e){let c,u;typeof e=="object"?(u=document.createDocumentFragment(),Array.isArray(e)?oe.sync({domConfig:{children:e,onlyChildren:!0},targetElement:u}):oe.sync({domConfig:{...e,onlyChildren:!0},targetElement:u})):t?(s.innerHTML=e,c=!0):(t||o.deleteContents(),u=E.createElementFromTemplate(e,{fragment:!0})),c||(t?(s.innerHTML="",s.appendChild(u)):n.isConnected?o.insertNode(u):s.insertBefore(u,s.firstChild))}else t||!n.isConnected?s.innerHTML="":o.deleteContents();r.autoClose=l,d&&n.appendChild(d),r.contentRangeStartOffset=o.startOffset,r.contentRangeEndOffset=o.endOffset,s.classList.toggle("b-no-child-elements",r.noChildElements),r.isComposable&&r.recompose(),(r.floating||r.positioned)&&!r.isAligning&&r.realign()}onThemeChange(){var e;this._anchorSize=null,(e=this.anchorElement)!=null&&e.offsetParent&&this.realign()}get anchorSize(){const e=this;let t=this._anchorSize;if(!t){const r=parseFloat(E.getStyleValue(e.element,"border-top-width")),n=E.getStyleValue(e.element,"border-top-color"),s=e.anchorElement,{className:a}=s,o=s.firstElementChild,l=e.anchorPathElement=o.lastElementChild,d=e._hidden;s.className="b-anchor b-anchor-top";let c=E.getStyleValue(e.contentElement,"background-color");c.match(Fv)&&(c=E.getStyleValue(e.element,"background-color")),e.defaultAnchorBackgroundColor=c,t=o.getBoundingClientRect();const[u,h]=t=e._anchorSize=[t.width,t.height];s.className=a,o.setAttribute("height",h+r),o.setAttribute("width",u),l.setAttribute("d",`M0,${h}L${u/2},0.5L${u},${h}`),r&&(l.setAttribute("stroke-width",r),l.setAttribute("stroke",n)),t[1]-=r,d&&e.syncHiddenCls(),e.themeChangeListener||(e.themeChangeListener=ue.ion({theme:"onThemeChange",thisObj:e})),e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}return t}get anchorElement(){const e=this;if(!e._anchorElement){const t=e.floating||e.positioned,r=`${e.id}-shadow-filter`;e._anchorElement=E.createElement({parent:e.element,className:"b-anchor b-anchor-top",children:[{tag:"svg",ns:"http://www.w3.org/2000/svg",version:"1.1",class:"b-pointer-el",children:[t?{tag:"defs",children:[{tag:"filter",id:r,children:[{tag:"feDropShadow",dx:0,dy:-1,stdDeviation:1,"flood-opacity":.2}]}]}:null,{tag:"path",[t?"filter":""]:`url(#${r})`}]}]})}return e._anchorElement}updateAnchor(e){this._anchorElement&&this._anchorElement.classList[e?"remove":"add"]("b-hide-display")}updateDraggable(e){var t,r,n;const s=this,{element:a}=s;e?(s.dragEventDetacher=j.addListener({element:a,dragstart:"onWidgetDragStart",dragend:"onWidgetDragEnd",thisObj:s}),s.dragDetacher=j.on({element:a,mousedown(o){const{target:l}=o,d=ge.fromElement(l);(!o.target.closest(".b-field-inner")&&d===this||this.strips&&Object.values(this.strips).includes(d))&&a.setAttribute("draggable","true")},thisObj:s})):((t=s.dragEventDetacher)==null||t.call(s),(r=s.dragOverEventDetacher)==null||r.call(s),(n=s.dragDetacher)==null||n.call(s))}onWidgetDragStart(e){var t;const r=this;if(!r.validateDragStartEvent(e))return;const{element:n,align:s,constrainTo:a}=r,o=r.positioned&&E.getStyleValue(n,"position")!=="fixed",l=o?n.parentElement:r.rootElement,d=k.from(n,o?l:null),c=e.clientX,u=e.clientY,h=document.scrollingElement||document.body,[f,g]=o?E.getOffsetXY(n,l):r.getXY(),m=(t=o?k.content(l).moveTo(0,0):a&&(a!=null&&a.isRectangle?a:k.from(a)))==null?void 0:t.deflate(s.constrainPadding||0),p={element:l,dragover:y=>{n.classList.remove("b-centered"),d.moveTo(f+y.clientX-c-(o?0:h.scrollLeft),g+y.clientY-u-(o?0:h.scrollTop)),m&&d.constrainTo(m),E.setTopInsetInlineStart(n,d.y,d.x)}};K.isTouchDevice&&(p.touchmove=y=>y.preventDefault()),r.floatRoot.appendChild(r.dragGhost),r.setDragImage(e),e.dataTransfer.effectAllowed="none",r.dragOverEventDetacher=j.addListener(p),r.alignTo()}validateDragStartEvent(e){var t;const r=this,{element:n}=r,s=E.elementFromPoint(e.clientX,e.clientY),{handleSelector:a}=r.draggable;if(a){const o=(t=OF.exec(a))==null?void 0:t[1];if(o){if(s.closest(`#${n.id} ${o}`))return e.preventDefault(),!1}else if(!s.closest(`#${n.id} ${a}`))return e.preventDefault(),!1}return!0}setDragImage(e){e.dataTransfer.setDragImage&&(e.dataTransfer.setData("application/node type",""),e.dataTransfer.setDragImage(this.dragGhost,-9999,-9999))}setStyle(e,t){return E.applyStyle(this.element,T.isObject(e)?e:{[e]:t}),this}onWidgetDragEnd(){this.dragGhost.remove(),this.dragOverEventDetacher(),this.element.removeAttribute("draggable")}changeFloating(e){return!!e}changePositioned(e){return!!e}updatePositionable(e){this.element.classList.toggle("b-positionable",!!e),e&&(this.innerItem=!1)}updatePositioned(e){this.element.classList.toggle("b-positioned",!!e),e&&(this.innerItem=!1)}getXY(){const{element:e}=this;return[E.getPageX(e),E.getPageY(e)]}setXY(e,t){const r=this,{element:n}=r;if(r.floating||r.positioned){if(e!=null?r._x=e:e=r._x,t!=null?r._y=t:t=r._y,E.getStyleValue(n,"position")==="fixed"){const s=n.getBoundingClientRect(),[a,o]=E.getTranslateXY(n),l=e-s.x,d=t-s.y;E.setTranslateXY(n,a+l,o+d)}else r.rtl?E.setTopInsetInlineStart(n,t,n.offsetParent.offsetWidth-n.offsetWidth-e):E.setTopInsetInlineStart(n,t,e);r.isConstructing?r.centered=!1:n.classList.remove("b-centered")}}setPos(e,t){const r=this,{positionable:n}=r;[e,t]=E.unitize(e,t!=null?t:""),r.element.style[e]=t,r.top==null&&r.right==null&&r.bottom==null&&r.left==null?(n==="after"||n==="before")&&(r.positionable=null):n||(r.positionable="before")}updateBottom(e){this.setPos("bottom",e)}updateLeft(e){this.setPos("inset-inline-start",e)}updateRight(e){this.setPos("inset-inline-end",e)}updateTop(e){this.setPos("top",e)}get x(){return this.getXY()[0]}changeX(e){this.setXY(e)}get y(){return this.getXY()[1]}changeY(e){this.setXY(null,e)}get width(){const e=this,t=e.element;return e.monitorResize?(e._width==null&&(e._width=t.offsetWidth),e._width):t.offsetWidth}changeWidth(e){const t=this;if(E.setLength(t.element,"width",e),t._lastWidth=e,t._flex=null,t.element.style.flex="",t.monitorResize)t._oldWidth=t._width,t._width=null;else return e}clearWidthCache(){this._width=null}get maxWidth(){return E.measureSize(this.element.style.maxWidth,this.element)}updateMaxWidth(e){this._lastMaxWidth=e,E.setLength(this.element,"maxWidth",e)}get minWidth(){return E.measureSize(this.element.style.minWidth,this.element)}updateMinWidth(e){E.setLength(this.element,"minWidth",e)}updateFlex(e){this.getConfig("width"),(typeof e=="number"||!isNaN(e))&&(e=`${e} ${e}`),this.element.style.flex=e,this.element.style.width=""}updateAlignSelf(e){this.element.style.alignSelf=e}updateMargin(e){this.element.style.margin=this.parseTRBL(e).join(" ")}updateTextAlign(e,t){t&&this.element.classList.remove(`b-text-align-${t}`),this.element.classList.add(`b-text-align-${e}`)}updatePlaceholder(e){this.input&&(e==null?this.input.removeAttribute("placeholder"):this.input.placeholder=e)}get height(){const e=this,t=e.element;return e.monitorResize?(e._height==null&&(e._height=t.offsetHeight),e._height):t.offsetHeight}changeHeight(e){E.setLength(this.element,"height",e),this._lastHeight=e,this._height=null}get maxHeight(){return E.measureSize(this.maxHeightElement.style.maxHeight,this.element)}updateMaxHeight(e){this._lastMaxHeight=e,E.setLength(this.maxHeightElement,"maxHeight",e)}get minHeight(){return E.measureSize(this.element.style.minHeight,this.element)}updateMinHeight(e){E.setLength(this.element,"minHeight",e)}updateDisabled(e=!1,t){const r=this,{element:n,focusElement:s,ariaElement:a}=r;r.trigger("beforeUpdateDisabled",{disabled:e}),!(e&&(r.revertFocus(),!r._disabled!=!e))&&(n&&(n.classList[e?"add":"remove"]("b-disabled"),e==="inert"?n.inert=!0:t==="inert"&&(n.inert=!1),s&&(s.disabled=e),a&&a.setAttribute("aria-disabled",!!e)),r.onDisabled(e))}onDisabled(e){}disable(){this.disabled=!0}enable(){this.disabled=!1}requestFullscreen(){const e=this,t=Ui.request(e.floating?e.floatRoot:e.element);return Ui.onFullscreenChange(e.onFullscreenChange),e.element.classList.add("b-fullscreen"),t}exitFullscreen(){return Ui.exit()}onFullscreenChange(){Ui.isFullscreen||this.onExitFullscreen()}onExitFullscreen(){Ui.unFullscreenChange(this.onFullscreenChange),this.element.classList.remove("b-fullscreen")}get tooltip(){var e;const t=this;if(t._tooltip)return t._tooltip;{const r=(e=ge.Tooltip)==null?void 0:e.getSharedTooltip(t.rootElement,t.eventRoot);if(r&&r.activeTarget===t._element&&r.isVisible)return r}}changeTooltip(e,t){const r=this,{element:n}=r;if(e){if(!(r.preventTooltipOnTouch&&K.isTouchDevice))if(!e.isTooltip&&e.constructor.name!=="Object"&&(e={html:typeof e=="string"?e:r.placeholder,textContent:!0}),t!=null&&t.isTooltip||e.newInstance)e.type="tooltip",e.forElement||(e.forElement=n),!("showOnHover"in e)&&!e.forSelector&&(e.showOnHover=!0),"autoClose"in e||(e.autoClose=!0),e=ge.reconfigure(t,e,r),r.detachListeners("tooltipValueListener"),r.configureAriaDescription||e.ion({name:"tooltipValueListener",innerHtmlUpdate:"onTooltipValueChange",thisObj:r});else{n.dataset.btip=!0,r.tipConfig=e;return}}else if(t)if(e==null&&t.isTooltip)t.destroy();else{t.html=null;return}else delete n.dataset.btip;return e}onTooltipValueChange({value:e,source:t}){this.ariaDescription=typeof e=="string"?e:t.contentElement.innerText}get tooltipText(){const e=this._tooltip;if(e)return e.isTooltip?e.contentElement.innerText:typeof e=="string"?e:e.html;if(this.tipConfig)return this.tipConfig.html}get isVisible(){const e=this,{element:t}=e;let r;return!!(t&&!e._hidden&&!e.isDestroying&&t.isConnected&&(!e.requireSize||en(t))&&(!(r=e.parent)||r.isVisible))}get isVisibleForValidation(){const e=this,{element:t}=e;let r;return!!(t&&(!e._hidden||e.tab&&!e.tab.hidden)&&!e.isDestroying&&t.isConnected&&(!(r=e.containingWidget)||r.isVisibleForValidation))}whenVisible(e,t=this,r,n=e.toString()){var s;const a=this;a.isVisible&&a.isPainted?((s=a.toCallWhenVisible)==null||s.delete(n),a.callback(e,t,r)):(a.toCallWhenVisible||(a.toCallWhenVisible=new Map)).set(n,{callback:e,thisObj:t,args:r})}focus(){var e;(e=this.focusableElement)==null||e.focus({preventScroll:!0})}get focusability(){return E.getFocusability(this.focusElement)}get focusableElement(){const e=this,t=!e.isDestroying&&e.isVisible&&!e.disabled&&e.focusElement;return(t===document.body||(t==null?void 0:t.offsetParent))&&t}get focusElement(){}get isFocusable(){return!!this.focusableElement}get isTabbable(){return this.focusability.tabbable}set isTabbable(e){const{focusability:t,focusElement:r}=this,[n,s]=t.natural?[!e&&"-1",e]:[e&&"0",!e];r&&!e!=!t.tabbable&&(s&&r.removeAttribute("tabIndex"),n&&r.setAttribute("tabIndex",n))}async show({align:e,animate:t=!0}={}){var r;const n=this,{element:s,floating:a}=n,{style:o}=s,l=t&&n.showAnimation;let d,c,u=!n.isVisible;return u&&(u=n.trigger("beforeShow"),T.isPromise(u)&&(u=await u)),u!==!1&&((r=n.internalBeforeShow)==null?void 0:r.call(n))!==!1?new Promise(h=>{if(n.cancelHideShowAnimation(),n.updateCentered(n._centered),a){const f=n.floatRoot;f.contains(s)||(n.rendered?f.appendChild(n.element):n.render(f,!1)),o.transform.includes("scale")&&(n.scale=null,o.transform=o.transformOrigin="");const g=n.closest(BF);if(g){const{scale:m}=g;n.scale=m,o.transform=`scale(${m})`,o.transformOrigin="0 0"}}if(n._hidden=!1,n.syncHiddenCls(),a&&!Xp(s))return n.hide(!1),h();if(n.onConfigChange({name:"hidden",value:!1,was:!0,config:n.$meta.configs.hidden}),l){d=Object.keys(l)[0],c=l[d];const f=n.currentAnimation={showing:!0,styleProp:d,resolve:h};n.isAnimating=!0,o.transition="none",o[d]=c.from,E.getStyleValue(s,d),n.currentAnimation.detacher=j.onTransitionEnd({element:s,property:d,duration:c0(c.duration)+20,handler:()=>n.afterHideShowAnimate(f),thisObj:n}),o.transition=`${d} ${c.duration} ease ${c.delay}`,o[d]=c.to}n.afterShow(e,l?null:h)}):Promise.resolve()}async showBy(e,t,r){const n=this,s=Array.isArray(e);if(s||typeof e=="number"){const a=s?e:[e,t];e=Object.assign({target:new xi(a[0]+1,a[1]+1),matchSize:!1,align:"t0-b0"},s?t:r)}if(n.requireSize=!0,n.isVisible)E.addTemporaryClass(n.element,"b-realigning",300,n),n.alignTo(e);else return n.show({align:e})}afterShow(e,t){var r,n;const s=this;s.trigger("show"),s._configuredAnchorState=s.anchor,(n=(r=s.owner)==null?void 0:r.onChildShow)==null||n.call(r,s),s.triggerPaint(),(s.floating||s.positioned)&&(e?s.alignTo(e):s.centered?s.alignTo({target:s.constrainTo,align:"c-c"}):s.forElement&&s.alignTo(s.forElement)),t==null||t()}onChildHide(e){var t;e.floating&&((t=this.ariaElement)==null||t.removeAttribute("aria-owns"))}onChildShow(e){var t;e.floating&&((t=this.childItems)!=null&&t.includes[e])&&(this.ariaHasPopup=e.role,this.ariaElement.setAttribute("aria-owns",e.id))}triggerPaint(){var e;const t=this,{element:r,toCallWhenVisible:n}=t,s=!t.isPainted;if(t.isVisible){if(s&&(t.getConfig("scrollable"),t.scaleToFitWidth&&!t.monitorResize&&(t.onParentElementResize=t.onParentElementResize.bind(t),gt.addResizeListener(r.parentElement,t.onParentElementResize),t.updateScale()),!t.hideBryntumDomMessage&&(t.isTaskBoardBase||t.isGridBase||t.isCalendar)&&r.insertBefore(new Comment("POWERED BY BRYNTUM (https://bryntum.com)"),r.firstChild),t.onConnectedCallback&&globalThis.ResizeObserver&&(t.connectedObserver=new ResizeObserver(()=>{t.isElementConnected&&!r.isConnected?(t.onConnectedCallback(!1),t.isElementConnected=!1):!t.isElementConnected&&r.isConnected&&(t.onConnectedCallback(!0,t.isElementConnected==null),t.isElementConnected=!0)}),t.connectedObserver.observe(r))),t.eachWidget(LF,!1),s&&(t.getConfig("tooltip"),!ge.Ripple&&ge.RippleClass&&(ge.Ripple=new ge.RippleClass({rootElement:t.rootElement})),globalThis.DocsBrowser&&t.floating&&t.closest(a=>{var o;return(o=a.element)==null?void 0:o.closest(".fiddlePanelResult,.b-owned-by-fiddle")})&&r.classList.add("b-owned-by-fiddle")),t.isPainted=!0,s&&t.triggerConfigs("paint"),t.onInternalPaint({firstPaint:s}),t.trigger("paint",{firstPaint:s}),(e=t.afterInternalPaint)==null||e.call(t,{firstPaint:s}),n!=null&&n.size){for(const{callback:a,thisObj:o,args:l}of n.values())t.callback(a,o,l);n.clear()}s&&t.monitorResize&&!t.scaleToFitWidth&&gt.onElementResize([{target:r}]),t.hasPainted=!0}}onInternalPaint(){}cancelHideShowAnimation(){const e=this,{currentAnimation:t,element:r}=e;t&&(e.isAnimating=!1,r.classList.contains("b-hiding")&&(r.classList.remove("b-hiding"),e._hidden=!1),t.detacher(),t.resolve(),r.style.transition=r.style[t.styleProp]="",e.currentAnimation=null,e.trigger(`${t.showing?"show":"hide"}AnimationEnd`))}afterHideShowAnimate(e){const t=this;e===t.currentAnimation&&(t.element.classList.remove("b-hiding"),t.cancelHideShowAnimation(),t._hidden&&t.afterHideAnimation())}suspendVisibility(){this._visibilitySuspended=(this._visibilitySuspended||0)+1,Object.defineProperty(this,"isVisible",HF)}resumeVisibility(e=!0){--this._visibilitySuspended||(delete this.isVisible,e&&this.triggerPaint())}hide(e=!0){return new Promise(t=>{const r=this;if(!r._hidden&&r.trigger("beforeHide",{animate:e})!==!1){const{element:n,lastAlignSpec:s}=r,{style:a}=n,o=e&&r.hideAnimation;if(r.clearTimeout("scrollListenerTimeout"),r.clearTimeout("resizeListenerTimeout"),r._hidden=!0,s&&(s.targetOutOfView=null,s.monitorIntersection&&(r.intersectionObserver.takeRecords(),r.intersectionObserver.unobserve(s.target))),r.onConfigChange({name:"hidden",value:!0,was:!1,config:r.$meta.configs.hidden}),!n){t();return}if(n.contains(E.getActiveElement(n))&&r.revertFocus(!0),r.isDestroyed){t();return}if(r.cancelHideShowAnimation(),o){const l=Object.keys(o)[0],d=o[l];if(Number(getComputedStyle(r.element)[l])!==d.to){const c=r.currentAnimation={hiding:!0,styleProp:l,resolve:t};n.classList.add("b-hiding"),r.isAnimating=!0,r.currentAnimation.detacher=j.onTransitionEnd({element:n,property:l,duration:c0(d.duration)+20,handler:()=>r.afterHideShowAnimate(c),thisObj:r}),a[l]=d.from,E.getStyleValue(n,l),a.transition=`${l} ${d.duration} ease ${d.delay}`,a[l]=d.to}else r.syncHiddenCls()}else r.syncHiddenCls();r.ownedWidgets&&Object.values(r.ownedWidgets).forEach(l=>{var d;return l.floating&&((d=l.hide)==null?void 0:d.call(l,e))}),r.afterHide(!o&&t,o)}else t(!1)})}realignOnTransitionEnd(e){this.doHideOrRealign(e)}doHideOrRealign({target:e,isTrusted:t}){const r=this,{lastAlignSpec:n,element:s}=r,a=n==null?void 0:n.anchoredTo,o=n==null?void 0:n.target,l=n==null?void 0:n.position,d=E.getActiveElement(r);if(!t||!en(s)||e&&(s.contains(e)||e.nodeType===Element.ELEMENT_NODE&&r.owns(e)||e.nodeType===Element.DOCUMENT_NODE&&s.contains(d)&&kF[d]&&globalThis.innerHeight<document.body.offsetHeight))return;if(n.aligningToElement){const u=E.isInView(o,!1,r);if(u&&u.equals(n.targetRect))return}const c=r.scrollAction==="hide"&&r.getXY();if(r.realign(),!r.isDestroyed&&Xp(s)&&r.scrollAction==="hide"){const[u,h]=r.getXY(),f=u!==c[0]||h!==c[1];(n!=null&&n.aligningToEvent||(f||(o==null?void 0:o.$$name)==="Point"||l)&&(!a||!en(a)||e&&E.isDescendant(e,a)))&&r.hide()}}afterHide(e=null,t=this.hideAnimation){var r,n;const s=this;s._anchor=s._configuredAnchorState,s.removeTransientListeners(),t||s.afterHideAnimation(),s.trigger("hide"),(n=(r=s.owner)==null?void 0:r.onChildHide)==null||n.call(r,s),e&&e()}removeTransientListeners(){var e,t;const r=this,{targetObserver:n}=r;r.clearTimeout("resizeListenerTimeout"),r.clearTimeout("scrollListenerTimeout"),n&&(n.disconnect(),delete r.targetObserver),r.documentScrollListener=(e=r.documentScrollListener)==null?void 0:e.call(r),r.targetRootScrollListener=(t=r.targetRootScrollListener)==null?void 0:t.call(r),r.observedTargetEl&&(gt.removeResizeListener(r.observedTargetEl,r.onTargetResize),r.observedTargetEl=!1),r.observedConstrainEl&&(gt.removeResizeListener(r.observedConstrainEl,r.onAlignConstraintChange),r.observedConstrainEl=!1)}afterHideAnimation(){const e=this,{element:t}=e;!e.hasOwnProperty("_hideMode")&&e.floating&&e.floatRoot.contains(t)?t.remove():e.syncHiddenCls(),e.defaultAnchorBackgroundColor&&e.anchorPathElement.setAttribute("fill",e.defaultAnchorBackgroundColor)}changeHidden(e){const t=this;let r;return t.isConfiguring?(r=!!e,t.syncHiddenCls(r)):(t.trigger("beforeChangeHidden",{hidden:e}),e?t.hide():t.show()),r}syncHiddenCls(e=this._hidden){const{element:t,hideMode:r}=this,n={"b-hidden":e};for(const s of AF)n[`b-hide-mode-${s}`]=s===r&&(e||s!=="display");E.assignClasses(t,n)}get assignedId(){return this.hasGeneratedId?null:this.id}get owner(){return this.parent||this._owner||this.containingWidget}changeOwner(e){if(!this.parent)return e}updateOwner(e,t){const{id:r}=this;t&&(t.ownedWidgets&&delete t.ownedWidgets[r],E.removeAttributeValue(t.ariaElement,"aria-owns",r)),e&&((e.ownedWidgets||(e.ownedWidgets={}))[r]=this,E.addAttributeValue(e.ariaElement,"aria-owns",r))}get containingWidget(){var e,t;let r=this.parent;if(!r){const n=((e=this.forElement)==null?void 0:e.nodeType)===Element.ELEMENT_NODE?this.forElement:(t=this.element)==null?void 0:t.parentNode;r=(n==null?void 0:n.closest(".b-widget"))&&ge.fromElement(n)}return r}get previousSibling(){return this.getSibling(-1)}get nextSibling(){return this.getSibling(1)}getSibling(e){const t=this,{parent:r}=t,n=r?r.childItems:Array.from(t.element.parentElement.querySelectorAll(".b-widget"));return r?n[n.indexOf(t)+e]:ge.fromElement(n[n.indexOf(t.element)+e])}up(e,t,r){var n;const{owner:s}=this;return e?(n=s==null?void 0:s.closest)==null?void 0:n.call(s,e,t,r):s}closest(e,t,r){const n=typeof r,s=n==="number",a=n==="string";for(let o=this,l=1;o;o=o.owner,l++){if(ge.widgetMatches(o,e,t))return o;if(s&&l>=r)return;if(a&&ge.widgetMatches(o,r,t))return;if(o===r)return}}owns(e,t){if(e){if("eventPhase"in e&&(e=e.target),e.nodeType===Element.ELEMENT_NODE){if(this.element.contains(e))return!0;e=e.getAttribute("owned-by")?ge.getById(e.getAttribute("owned-by")):ge.fromElement(e)}for(;e;){if(e===this||t&&this.ownedWidgets&&Object.values(this.ownedWidgets).some(r=>r.owns(e,!0)))return!0;e=e.owner}}return!1}eachAncestor(e){let t=this.owner;for(;t;){if(e(t)===!1)return!1;t=t.owner}return!0}changeMaximizeOnMobile(e){const t=this;if(t.floating&&K.isMobile){const{initialConfig:r}=t;e?(t.centered=t.modal=!1,t.maximized=!0):(t.centered=r.centered,t.modal=r.modal,t.maximized=r.maximized)}}changeMonitorResize(e,t){const r=this.scaleToFitWidth?!1:!!e;if(r!==!!t)return r}updateMonitorResize(e){const t=this;fs(t,"onElementResize")||(t.onElementResize=t.onElementResize.bind(t)),gt[e?"addResizeListener":"removeResizeListener"](t.element,t.onElementResize)}changeReadOnly(e){if(e=!!e,!!this._readOnly!==e)return e}updateReadOnly(e){var t;(t=this.element)==null||t.classList[e?"add":"remove"]("b-readonly"),this.isConfiguring||(this.eachWidget(r=>{r.ignoreParentReadOnly||("_originalReadOnly"in r||(r._originalReadOnly=r.config.readOnly||!1),r.readOnly=e||r._originalReadOnly)},!1),this.trigger("readOnly",{readOnly:e}))}eachWidget(e,t=!0,r){const n=r?this.childItemsOrderedByRelevance:this.childItems,s=(n==null?void 0:n.length)||0,a={};for(let o=0;o<s;o++){const l=n[o];if(a.down=t,e(l,a)===!1||a.down&&l.eachWidget&&l.eachWidget(e,t,r)===!1)return!1}return!0}queryAll(e){const t=[];return this.eachWidget(r=>{e(r)&&t.push(r)}),t}query(e,t){let r=null;return this.eachWidget(n=>{if(e(n))return r=n,!1},!0,t),r}getWidgetByRef(e){var t,r;return e instanceof ge?e:((t=this==null?void 0:this.widgetMap)==null?void 0:t[e])||((r=this==null?void 0:this.owner)==null?void 0:r.getWidgetByRef(e))}onFocusIn(e){const t=this,{element:r}=t;t.containsFocus=!0,t.focusInEvent=e,(t.floating||t.positioned)&&t.toFront(),r.classList.add("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),r.contains(e._target)&&t.onInternalKeyDown&&!t.keyDownListenerRemover&&(t.keyDownListenerRemover=j.on({element:r,keydown:"onInternalKeyDown",thisObj:t})),t.trigger("focusin",e)}onFocusOut(e){const t=this;t.keyDownListenerRemover&&(t.keyDownListenerRemover(),t.keyDownListenerRemover=null),t.isDestroyed||(e.relatedTarget||t.revertFocus(!t.isVisible),t.containsFocus=!1,t.element.classList.remove("b-contains-focus"),t.updateAriaLabel(t.localizeProperty("ariaLabel")),t.updateAriaDescription(t.localizeProperty("ariaDescription")),t.trigger("focusout",e))}captureFocus(){const e=this,t=E.getActiveElement(e),r=e.contains(t)&&e.captureFocusItem(t);return(n,s)=>{r&&!e.isDestroying&&(E.getActiveElement(e)!==t||s)&&r(n)}}captureFocusItem(e){return(t=!0)=>{this.contains(e)&&(t?e.focus():e.focus({preventScroll:!0}))}}contains(e,t){const{element:r}=this;if(e&&r)return e.isWidget&&(e=e.element),r.contains(e)&&(!t||r!==e)}revertFocus(e){var t;const r=this,n=E.getActiveElement(r);let s=(t=r.focusInEvent)==null?void 0:t.relatedTarget;(e||r.containsFocus&&(s==null?void 0:s.nodeType)===Element.ELEMENT_NODE&&r.element.contains(n))&&((!s||!E.isFocusable(s))&&(s=r.getFocusRevertTarget()),r._isRevertingFocus=!0,s&&E.isFocusable(s)?(s._isRevertingFocus=!0,s.focus({preventScroll:!0}),s._isRevertingFocus=!1):n==null||n.blur(),r._isRevertingFocus=!1)}getFocusRevertTarget(){var e;const t=this,{owner:r,focusInEvent:n}=t,s=n&&n.backwards?1:-1;let a=n&&n.relatedTarget;const o=a&&ge.fromElement(a);if(r&&!r.isDestroyed&&(!a||!E.isFocusable(a)||o&&!o.isFocusable)){if(a=null,r.eachWidget){const l=[];if(r.eachWidget(d=>{(d===t||d.isFocusable)&&l.push(d)},!1),l.length>1){const d=l.indexOf(t);a=l[d+s]||l[d-s]}}!a&&r.isFocusable&&(a=r),a=a?a.focusElement:(e=r.getFocusRevertTarget)==null?void 0:e.call(r)}return a}getStaticWidgetClasses(e,t){const r=new se,n=this.$meta.hierarchy;let s,a,o,l,d;for(a=n.indexOf(e);a<n.length;++a)s=n[a],d=Reflect.getOwnPropertyDescriptor(s.prototype,"widgetClass"),d!=null&&d.get?l=d.get.call(this):(o=fs(s,"$$name")||fs(s,"$name")||fs(s,"_$name")?s.$$name:s.name,(o.length<3||o.includes("$"))&&console.warn(`Class "${o}" extending "${s.$name}" should have "$name" static getter with no less than 3 chars.`),l=`b-${o.toLowerCase()}`),l&&r.add(t?l+t:l);return r}get rootUiClass(){return ge}get staticClassList(){const{$meta:e}=this;let t=e.staticClassList;return t||(e.staticClassList=t=this.getStaticWidgetClasses(ge),K.isTouchDevice&&t.add("b-touch")),t}get uiClasses(){return this.getConfig("ui"),this._uiClasses}get uiClassList(){return this.getConfig("ui"),this._uiClassList}get widgetClassList(){const e=this,{cls:t,defaultCls:r,uiClasses:n}=e;let{staticClassList:s}=e;(r||t)&&(s=s.clone(),r&&s.assign(r),t&&s.assign(t));const a=s.values;return n&&a.push(...n),e.floating&&a.push("b-floating"),e.collapsify==="hide"&&a.push("b-collapsify-hide"),a}changeCls(e){return se.from(e)}updateCls(e,t){if(!this.isConfiguring&&!this.isComposable){const{element:r}=this;t&&T.getTruthyKeys(t).forEach(n=>r.classList.remove(n)),e.assignTo(r)}}changeContentElementCls(e){return se.from(e)}changeHtmlCls(e){return se.from(e)}changeDefaultCls(e){return se.from(e,!0)}updateHideMode(){this.hasPainted&&this.syncHiddenCls()}changeUi(e){return se.from(e)}updateUi(e){let t=null,r,n;if(e){const s=this.getStaticWidgetClasses(this.rootUiClass);for(n in e)if(e[n])for(r in s)s[r]&&((t||(t=new se))[`${r}-ui-${n}`]=1)}this._uiClasses=t==null?void 0:t.values,this._uiClassList=t}fromCache(e,t=!1,r=this.element){var n;if(!r)return null;const s=this;return(n=s.cache)!=null&&n[e]?s.cache[e]:(s.cache||(s.cache={}),s.cache[e]=t?E.children(r,e):r.querySelector(e))}emptyCache(){this.cache&&(this.cache={})}changeMasked(e,t){var r;if(((r=this.masked)==null?void 0:r.type)!=="trial"){if((e===!0||e==="")&&(e="\xA0"),t&&!t.isDestroyed)typeof e=="string"?(t.text=e,e=t):e?(t.setConfig(e),e=t):t.destroy();else if(e){const n=ge.resolveType("mask");e=n.mergeConfigs(this.maskDefaults,e),e.owner=this,e=n.mask(e)}return e||null}}onMaskAutoClose(e){e.isDestroyed&&e===this.masked&&(this.masked=null)}mask(e){return this.masked=e,this.masked}unmask(){this.masked=null}onInternalResize(e,t,r,n,s){this._width=e.offsetWidth,this._height=e.offsetHeight}onElementResize(e,t){var r;const n=this,{element:s}=n,a=(r=n._width)!=null?r:n._oldWidth,o=n._height,l=s.offsetWidth,d=s.offsetHeight;n.floating&&t&&n.onFloatingWidgetResize(...arguments),!n.suspendResizeMonitor&&(a!==l||o!==d)&&(n.onInternalResize(s,l,d,a,o),n.trigger("resize",{width:l,height:d,oldWidth:a,oldHeight:o}))}onFloatingWidgetResize(e,t,r){const n=this,{lastAlignSpec:s,constrainTo:a}=n;if(n.isVisible&&s&&s.target){const o=!t||r.height!==t.height,l=!t||r.width!==t.width,d=a&&!k.from(a).contains(k.from(n.element,null,!0));(o&&s.zone!==2||l&&s.zone!==1||d)&&n.requestAnimationFrame(()=>n.realign())}}updateScale(){const e=this,t=e.element,r=t.parentElement;e.configuredWidth||(e.configuredWidth=e.width),t.style.display="none";const n=k.client(r),s=n.width/e.configuredWidth,a=e.scale=e.allowGrowWidth?Math.min(s,1):s;t.style.transform=`scale(${a})`,t.style.transformOrigin="top left",t.style.display="",e.allowGrowWidth&&s>1&&(e.width=e.configuredWidth*s)}onParentElementResize(e){this.updateScale()}parseTRBL(e,t="px"){if(e=e||0,typeof e=="number")return[`${e}${t}`,`${e}${t}`,`${e}${t}`,`${e}${t}`];const r=e.split(" "),n=r.length;return n===1?r[1]=r[2]=r[3]=r[0]:n===2?(r[2]=r[0],r[3]=r[1]):n===3&&(r[3]=r[1]),[isFinite(r[0])?`${r[0]}${t}`:r[0],isFinite(r[1])?`${r[1]}${t}`:r[2],isFinite(r[2])?`${r[2]}${t}`:r[3],isFinite(r[3])?`${r[3]}${t}`:r[4]]}get documentRoot(){var e;return((e=this.owner)==null?void 0:e.documentRoot)||this.element.getRootNode()}get eventRoot(){var e,t;return(e=this.element)!=null&&e.isConnected?E.getRootElement(this.element):((t=this.owner)==null?void 0:t.eventRoot)||this._rootElement}get rootElement(){var e,t;const r=this;if(!r._rootElement){let n=((e=r.owner)==null?void 0:e.rootElement)||E.getRootElement(r.forElement||((t=r.element)!=null&&t.isConnected?r.element:r.getRenderContext()[0]||r.element));n||(n=document.body),r._rootElement=n}return r._rootElement}get floatRoot(){var e;const t=this,{rootElement:r}=t;let{floatRoot:n}=r;if(n)r.contains(n)||r.appendChild(n);else{const{outerCls:s}=ge,a=(e=E.getThemeInfo(null,r))==null?void 0:e.name;if(!E.isValidFloatRootParent(r))throw new Error("Attaching float root to wrong root");a&&s.push(`b-theme-${a.toLowerCase()}`),n=r.floatRoot=E.createElement({className:`b-float-root ${s.join(" ")}`,parent:r}),Yf.push(n),K.isAndroid&&(n.style.height=`${screen.height}px`,j.on({element:globalThis,orientationchange:()=>n.style.height=`${screen.height}px`,thisObj:this})),ue.ion({theme:({theme:o,prev:l})=>{n.classList.add(`b-theme-${o.toLowerCase()}`),n.classList.remove(`b-theme-${l.toLowerCase()}`)}})}return n.classList.toggle("b-rtl",!!t.rtl),n}get floatRootMaxZIndex(){let e=1;return Array.from(this.floatRoot.children).forEach(t=>{const r=parseInt(getComputedStyle(t).zIndex||0,10);r>e&&(e=r)}),e}get accessibility(){return this.constructor.accessibility}static get accessibility(){return document.body.classList.contains("b-accessibility")}set accessibility(e){this.constructor.accessibility=e}static set accessibility(e){document.body.classList.toggle("b-accessibility",!!e)}static get floatRoots(){return Yf}static removeFloatRoot(e){Yf.splice(Yf.indexOf(e),1)}static get outerCls(){const e=["b-outer"],{platform:t}=K;return t&&e.push(`b-${t}`),K.isTouchDevice&&e.push("b-touch-events"),K.isMobile&&e.push("b-mobile"),E.scrollBarWidth?e.push("b-visible-scrollbar"):e.push("b-overlay-scrollbar"),K.isChrome?e.push("b-chrome"):K.isSafari?e.push("b-safari"):K.isFirefox&&e.push("b-firefox"),K.isPhone&&e.push("b-phone"),globalThis.ResizeObserver||e.push("b-no-resizeobserver"),e}get isAnimating(){return this._isAnimatingCounter>0}set isAnimating(e){const t=this,{_isAnimatingCounter:r}=t;t._isAnimatingCounter=Math.max(0,r+(e?1:-1)),r===0&&e?(t.element.classList.add("b-animating"),t.trigger("animationStart")):r===1&&!e&&(t.element.classList.remove("b-animating"),t.trigger("animationEnd"))}async waitForAnimations(){this.isAnimating&&await this.await("animationEnd",{checkLog:!1})}async executeAndAwaitAnimations(e,t){const r=e.getAnimations({subtree:!0});await t();const n=e.getAnimations({subtree:!0}),s=H.delta(r,n).onlyInB,a=s.filter(o=>o.effect.getTiming().iterations!==1/0);a.length&&await Promise.allSettled(a.map(o=>o.finished))}static query(e,t=!1){const{idMap:r}=ge.identifiable;for(const n in r)if(ge.widgetMatches(r[n],e,t))return r[n];return null}static queryAll(e,t=!1){const{idMap:r}=ge.identifiable,n=[];for(const s in r)ge.widgetMatches(r[s],e,t)&&n.push(r[s]);return n}static fromElement(e,t,r){const n=typeof t;e&&!e.nodeType&&(e=e.target),(n==="number"||t&&t.nodeType===Element.ELEMENT_NODE)&&(r=t,t=null);let s=e,a=0,o,l,d;for(typeof r!="number"&&(o=r,r=Number.MAX_VALUE),n==="string"&&(t=t.toLowerCase());s&&s.nodeType===Element.ELEMENT_NODE&&a<r&&s!==o;){if(l=s.dataset&&s.dataset.ownerCmp||s.id,l){if(d=ge.getById(l),d)if(t){if(n==="function"){if(t(d))return d}else if(ge.widgetMatches(d,t,!0))return d}else return d;a++}s=Sf(s)}return null}static fromSelector(e){const t=document.querySelector(e);return t?ge.fromElement(t):null}triggerFieldChange(e,t=!0){var r;t?this.trigger("change",e):e.source=this,(r=this.eachAncestor)==null||r.call(this,n=>{var s,a;if((s=n.onFieldChange)==null||s.call(n,e),(a=n.isolateFieldChange)!=null&&a.call(n,this))return!1})}isolateFieldChange(e){return this.isolateFields}setupFocusListeners(){ue.setupFocusListenersOnce(this.eventRoot,j)}static widgetMatches(e,t,r){return t==="*"?!0:typeof t=="function"?t(e):ge.isType(e,t,r)}static attachTooltip(e,t){return typeof t=="string"&&(t={html:t}),ge.create(Object.assign({forElement:e},t),"tooltip"),e}static append(e,t={}){return(t instanceof HTMLElement||typeof t=="string")&&(t={appendTo:t}),H.asArray(e).map(r=>ge.create(T.assign({},t,r)))}changeDock(e){return e==="start"?"left":e==="end"?"right":e}updateRtl(e){super.updateRtl(e),this.eachWidget(t=>{"rtl"in t.initialConfig||(t.rtl=e)})}};v(Kf,"$name","Widget"),v(Kf,"type","widget"),v(Kf,"convertPinchToMousewheel",!0);var V=Kf,WF=V.prototype;["compose","domSyncCallback"].forEach(i=>WF[i].$nullFn=!0),V.initClass(),E.Widget=V,ue.Widget=V,Object.assign(globalThis.bryntum||(globalThis.bryntum={}),{Widget:V,get:(i=globalThis.$0)=>i.nodeType?V.fromElement(i):V.getById(i),query:V.query,queryAll:V.queryAll,fromElement:V.fromElement,fromSelector:V.fromSelector}),V._$name="Widget";var Gi=class extends $.mixin(Ve,ds){get contentElement(){var i;return(i=this.owner)==null?void 0:i.contentElement}onChildAdd(i){}onChildRemove(i){}renderChildren(){const i=this,{owner:e,itemCls:t}=i,{contentElement:r,items:n}=e,s=e.itemCls,a=n==null?void 0:n.length;if(a){e.textContent=!1;for(let o,l,d=0;d<a;d++){const c=n[d],{element:u,positionable:h}=c,{classList:f}=u;u.dataset.itemIndex=d,f.contains("b-outer")&&f.remove(...V.outerCls),t&&f.add(t),s&&f.add(s),l=r,h&&(o=e.getPositionableLocation(h),(l=o[0])||(l=o[1].parentElement,c.insertBefore=o[1])),c.render(l,!!e.isPainted)}}i.syncPendingConfigs(),i.syncChildCount()}removeChild(i){const e=this,{element:t}=i,{owner:r,itemCls:n}=e,{contentElement:s}=r,a=r.itemCls;s.contains(t)&&t.remove(),delete t.dataset.itemIndex,n&&t.classList.remove(n),a&&t.classList.remove(a),e.fixChildIndices(),e.syncChildCount()}appendChild(i){const{element:e}=i,{owner:t,itemCls:r}=this,{contentElement:n}=t,s=t.itemCls;e.dataset.itemIndex=t.indexOfChild(i),t.textContent=!1,r&&e.classList.add(r),s&&e.classList.add(s),i.render(n,!!t.isPainted),this.syncChildCount()}insertChild(i,e){const t=this,{element:r}=i,{owner:n,itemCls:s}=t,{contentElement:a}=n,o=E.getChild(a,`[data-item-index="${e}"]`),l=n.itemCls;n.textContent=!1,s&&r.classList.add(s),l&&r.classList.add(l),a.insertBefore(r,o),i.render(null,!!n.isPainted),t.fixChildIndices(),t.syncChildCount()}fixChildIndices(){this.owner.items.forEach((i,e)=>{i.element.dataset.itemIndex=e})}syncChildCount(){var i;const{owner:e}=this,{length:t}=e.items;(i=e.contentElement)==null||i.classList[t===1?"add":"remove"]("b-single-child")}syncConfigLater(i){const e=this.pendingConfigs||(this.pendingConfigs=[]);e.includes(i)||e.push(i)}syncConfigStyle({name:i,style:e,classes:t,map:r}){const n=this,s=`b-box-${i}-`,{contentElement:a}=n,o=n[i];let l=(r==null?void 0:r[o])||o;if(a){if(t){const{classList:d}=a;t.forEach(c=>{c!==l&&d.remove(s+c)}),t.includes(l)&&(d.add(s+l),l="")}a.style[e]=l}else n.syncConfigLater(i)}syncPendingConfigs(){const i=this,{pendingConfigs:e}=i;let t;if(e)for(i.pendingConfigs=null;t=e.pop();)i[i.$meta.configs[t].updater](i[t])}};v(Gi,"type","default"),v(Gi,"configurable",{owner:null,containerCls:"b-auto-container",itemCls:null}),v(Gi,"factoryable",{defaultType:"default"}),Gi.initClass(),Gi._$name="Layout";var m0=0,UF=i=>i.ripple,lc=class extends V{static get defaultConfig(){return{old_element:{children:[{className:"b-ripple-inner",reference:"rippleElement"}]},element:{children:[{tag:"svg",class:"b-ripple-inner",reference:"rippleElement",ns:"http://www.w3.org/2000/svg",version:"1.1",viewBox:"0 0 100 100",children:[{reference:"circleElement",tag:"circle",cx:"0",cy:"0",r:10}]}]},floating:!0,hideAnimation:!1,showAnimation:!1,scrollAction:"realign",color:"rgba(0,0,0,.3)",startRadius:10,radius:100}}afterConstruct(){super.afterConstruct(),j.on({element:this.rootElement,mousedown:"onRippleControllingEvent",thisObj:this,capture:!0,once:!0})}onRippleControllingEvent(i){var e;const t=this;t.show();const r=E.getStyleValue(t.circleElement,"animationName");t.hide(),(e=t.listenerDetacher)==null||e.call(t),r&&r!=="none"&&(t.listenerDetacher=j.on({mousedown:{element:t.rootElement,capture:!0,handler:"onMousedown"},touchstart:{element:t.rootElement,capture:!0,handler:"onTouchStart"},animationend:{element:t.circleElement,handler:"onAnimationEnd"},thisObj:t}),i.type==="mousedown"&&(t.onMousedown(i),ue.ion({theme:"onRippleControllingEvent",thisObj:this})))}onTouchStart(i){m0=performance.now(),this.handleTriggerEvent(i)}onMousedown(i){performance.now()-m0>200&&this.handleTriggerEvent(i)}handleTriggerEvent(i){const e=V.fromElement(i.target,UF);if(e){const t=e.ripple,r=t.delegate?i.target.closest(t.delegate):e.focusElement||e.element;if(r){const n=T.assign({event:i,target:r,radius:this.radius},t);if(typeof n.clip=="string"&&(n.clip=e[n.clip]||i.target.closest(n.clip),!n.clip))return;this.ripple(n)}}}ripple({event:i,point:e=j.getClientPoint(i),target:t=i.target,clip:r=t,radius:n=this.radius,color:s=this.color}){this.clip=r,r=k.from(r,null,!0);const a=this,o=r.getDelta(e),l=a.rippleElement.style,d=a.circleElement,c=E.getStyleValue(t,"border-radius");a.hide(),l.transform=`translateX(${o[0]}px) translateY(${o[1]}px)`,l.height=l.width=`${n}px`,a.element.style.borderRadius=c,d.setAttribute("r",n),d.setAttribute("fill",s),a.showBy({target:r,align:"c-c",matchSize:!0})}onAnimationEnd(i){i.animationName==="b-ripple-expand"&&this.hide()}};v(lc,"$name","Ripple"),v(lc,"type","ripple"),V.RippleClass=lc,lc._$name="Ripple";var Lv=i=>i.element.classList.contains("b-visible"),GF=i=>!Lv(i)&&i.isVisible,Ka=class St extends V{static get(e){return He.get(e,"masks")||He.set(e,"masks",[])}static getActive(e){return St.get(e).find(Lv)||null}static getPending(e){return St.get(e).filter(GF).sort(V.weightSortFn)}static mask(e,t=document.body){return St.new({target:t},e)}static mergeConfigs(...e){return e=e.map(t=>typeof t=="string"?{text:t}:t),super.mergeConfigs(...e)}static sync(e){const t=St.getActive(e),r=!t&&St.getPending(e)[0]||null,n=t||r,s=(n==null?void 0:n.mode)||"",a=s.endsWith("blur")?`b-masked-${s}`:"";let o,l,d;r&&(l=r.element.classList,r.showDelay&&!e.classList.contains("b-masked")&&(l.add("b-delayed-show"),r.delayedShow()),l.add("b-visible")),e.classList.toggle("b-masked",!!n);for(o of e.children)l=o.classList,l.contains("b-mask")||(d=Array.from(l).filter(c=>c.startsWith("b-masked-")&&a!==c),d.length&&l.remove(...d),a&&l.add(a))}static unmask(e=document.body){var t;const r=St.get(e),n=r.length;return n?(t=r[n-1])==null?void 0:t.close():null}static unmaskAll(e=document.body){return St.get(e).filter(t=>!Lv(t)).forEach(t=>t.destroy()),St.unmask(e)}destroy(){this.type!=="trial"&&super.destroy()}compose(){const{icon:e,maxProgress:t,mode:r,progress:n,showDelay:s,text:a,useTransition:o}=this;return{class:{"b-mask":1,"b-delayed-show":s,"b-progress":t,"b-prevent-transitions":!o,[`b-mask-${r}`]:1},children:{maskContent:{class:"b-mask-content",children:{progressElement:t?{class:"b-mask-progress-bar",style:{width:`${Math.max(0,Math.min(100,Math.round(n/t*100)))}%`}}:null,maskText:{class:"b-mask-text",html:(e?`<i class="b-mask-icon ${e}"></i>`:"")+a}}}}}}generateAutoId(){const{type:e}=this;return`mask${typeof e=="string"?e.trim():""}-${St.counter++}`}updateAutoClose(e){this.deferredClose.cancel(),e&&(this.deferredClose.delay=e,this.deferredClose())}updateCover(){this.syncCover()}syncCover(){var e,t;(t=(e=this.owner)==null?void 0:e.syncMaskCover)==null||t.call(e,this)}set error(e){this.setConfig({...this.errorDefaults,text:e})}onOwnerResize(){this.syncCover()}updateOwner(e){this.detachListeners("cover"),e==null||e.ion({name:"cover",recompose:"onOwnerResize",resize:"onOwnerResize",thisObj:this})}updateShowDelay(e){const{delayedShow:t}=this;t.delay=e,e||t.flush()}changeTarget(e){return e===void 0?e=document.body:typeof e=="string"&&(e=this.owner[e]),e}updateTarget(e,t){const r=this,{id:n,element:s}=r,a=t&&St.get(t);t&&(t[n]===r&&delete t[n],H.remove(a,r),St.sync(t)),e?(e[n]||(e[n]=r),s.parentNode!==e&&e.appendChild(s),H.include(St.get(e),r),St.sync(e)):s.remove()}deferredClose(){var e;const t=this,{owner:r}=t;t.close().then(()=>{var n;return(n=r==null?void 0:r.onMaskAutoClose)==null?void 0:n.call(r,t)}),(e=r==null?void 0:r.onMaskAutoClosing)==null||e.call(r,t)}delayedShow(){this.element.classList.remove("b-delayed-show")}updateHidden(e,t){var r;(r=super.updateHidden)==null||r.call(this,e,t),e&&this.element.classList.remove("b-visible"),St.sync(this.target)}afterShow(...e){var t;(t=super.afterShow)==null||t.call(this,...e),St.sync(this.target)}afterHide(...e){var t;(t=super.afterHide)==null||t.call(this,...e),this.element.classList.remove("b-visible"),St.sync(this.target)}async close(){await this.hide(),this.destroy()}};v(Ka,"$name","Mask"),v(Ka,"type","mask"),v(Ka,"configurable",{autoClose:null,cover:null,icon:"b-icon b-icon-spinner",errorDefaults:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},maxProgress:null,mode:"dark",progress:null,target:{$config:"nullify",value:void 0},text:null,type:null,showDelay:null,useTransition:!1}),v(Ka,"delayable",{deferredClose:0,delayedShow:0,syncCover:{type:"throttle",delay:100}}),v(Ka,"counter",0);var gs=Ka;gs.initClass(),gs._$name="Mask";var YF=Object.freeze({}),{isArray:Xa}=Array,qF=i=>i.weight,p0=i=>i&&!i.hidden,KF=["display","flex-direction"],XF={default:1,box:1},ZF=Symbol("options"),dt=class extends V{static get configurable(){return{items:null,lazyItems:{$config:["lazy"],value:null},defaults:null,defaultType:"widget",layoutStyle:null,itemCls:null,layout:{type:"default"},namedItems:{$config:"lazy",value:null},overflowable:{value:null,default:!1,$config:null},textContent:!0,record:null,strictRecordMapping:null,autoUpdateRecord:null,autoUpdateFields:null,hideWhenEmpty:null,contentElMutationObserver:{$config:["lazy","nullify"],value:!0},isolateFields:!1,focusDescendant:!1,defaultBindProperty:null,defaultFocus:null}}static get prototypeProperties(){return{flexRowCls:"b-flex-row",flexColCls:"b-flex-column",initialItems:!0}}startConfigure(i){const e=i.items||i.lazyItems;(this.hasItems=!!(e&&(Xa(e)?e:Object.keys(e)).length))||(this.initialItems=!1),super.startConfigure(i)}get firstItem(){return this.getAt(0)}get lastItem(){return this.getAt(-1)}getPositionableItems(i,e){var t;const r=((t=this._items)==null?void 0:t.filter(n=>i?n.positionable===i:n.positionable))||[];return e?Object.fromEntries(r.map((n,s)=>[`$${n.positionable}${s}`,n.element])):r}getPositionableLocation(i){return[this.contentElement]}getAt(i){return this.ensureItems().at(i)}remove(...i){let e=!0;i.length===1&&(Xa(i[0])?i=i[0]:e=!1);const t=this,{_items:r}=t,n=[];for(let s=0;s<i.length;s++){const a=i[s];r.includes(a)&&(r.remove(a),t.layout.removeChild(a),n.push(a),t.onChildRemove(a))}return e?n:n[0]}removeAll(){return this.remove(this.items)}add(...i){const e=this,t=e.ensureItems(),r=[];let n=!0,s,a,o;for(i.length===1&&(Xa(i[0])?i=i[0]:n=!1),a=0;a<i.length;a++)s=i[a],s.isWidget?s.parent=e:s=e.createWidget(s),(s==null?void 0:s.weight)!=null?(o=H.findInsertionIndex(s,t.values,V.weightSortFn),r.push(e.insert(s,o))):s&&(t.includes(s)||(t.add(s),e.onChildAdd(s),e.layout.appendChild(s),r.push(s)));return n?r:r[0]}ensureItems(){const i=this;return i.getConfig("items"),i.getConfig("lazyItems"),i._items||(i.items=[]),i._items}insert(i,e){const t=this,r=t.ensureItems();i instanceof V?i.parent=t:i=t.createWidget(i),r.includes(e)&&(e=t.indexOfChild(e)),e=Math.min(e,r.count);const n=r.values;return n.splice(e,0,i),r.values=n,t.onChildAdd(i),t.layout.insertChild(i,e),i}indexOfChild(i){return this.items.indexOf(i)}changeLazyItems(i){this.items=i,this.layout.renderChildren()}onChildWeightChange(i){var e;if(this.items.length>1){const{lastItem:t}=this;this._items.sort(V.weightSortFn);const{items:r}=this;this.contentElement.insertBefore(i.element,((e=r[r.indexOf(i)+1])==null?void 0:e.element)||t.element.nextSibling)}}changeItems(i,e){const t=this,r=[],n=new ec;return Xa(i)?t.processItemsArray(i,r):i&&t.processItemsObject(i,t.namedItems,r),r.some(qF)&&r.sort(V.weightSortFn),n.add(r),e&&e.forEach(s=>{t.remove(s),!n.includes(s)&&s._createdBy===t&&s.destroy()}),n}afterConstruct(){const{rtl:i}=this,{classList:e}=this.contentElement;e.toggle("b-rtl",i===!0),e.toggle("b-ltr",i===!1)}updateRtl(i){super.updateRtl(i);const{contentElement:e}=this;e&&(e.classList.toggle("b-rtl",i===!0),e.classList.toggle("b-ltr",i===!1))}updateItems(i,e){let t=0;i.forEach(r=>{this.onChildAdd(r),e&&!e.temporary&&this.layout.insertChild(r,t),++t}),this.initialItems=!1}updateHideWhenEmpty(){this.syncChildCount(this.rendered)}get items(){const i=this;if(i.getConfig("lazyItems"),!i._items){if(i.initializingItems)return[];i._items=new ec,i._items.temporary=!0}return i._items.values}processItemsArray(i,e){const t=i.length;let r,n;for(r=0;r<t;r++)n=i[r],n instanceof V?(n.parent=this,n.element.classList.remove(...V.outerCls)):n=this.createWidget(n),n&&((n.ref||n.id)&&this.addDescendant(n),e.push(n))}processItemsObject(i,e,t=[]){let r,n;for(n in i)r=i[n],r&&(e&&n in e&&(r=typeof r=="object"?T.merge(T.clone(e[n]),r):e[n]),r&&(r instanceof V?r.parent=this:(r instanceof Object&&(r.ref=n),r=this.createWidget(r)),r&&(r.ref=n,this.addDescendant(r),t.push(r))));return t}onChildAdd(i){const e=this;if(i.innerItem&&e.readOnly&&!i.ignoreParentReadOnly&&(i.readOnly=!0),e.onChildAddLayout(i),i.ref||i.id)for(let t=e;t;t=t.parent)t.addDescendant(i);e.syncChildCount(!0),!e.onConfigChange.$nullFn&&e.onConfigChange({name:"items",config:e.$meta.configs.items})}onChildAddLayout(i){i.innerItem&&this.layout.onChildAdd(i)}onChildHide(i){var e;super.onChildHide(i),(e=this._items)!=null&&e.includes(i)&&this.syncChildCount(!0)}onChildShow(i){var e;super.onChildShow(i),(e=this._items)!=null&&e.includes(i)&&this.syncChildCount(!0)}syncChildCount(i){if(!this.isConfiguring&&!this.isDestroying){const e=this,{items:t,hasItems:r}=e,n=t.filter(p0),{length:s}=n;if(e.visibleChildCount=s,e.hideWhenEmpty&&i){const a=!s;!!e._hidden!==a&&(e.hidden=a)}t.forEach(a=>a.element.classList.remove("b-last-visible-child","b-first-visible-child")),s&&(n[0].element.classList.add("b-first-visible-child"),n[s-1].element.classList.add("b-last-visible-child")),e.hasItems=!!e.childItems.length,e.contentElement.classList[s?"remove":"add"]("b-no-visible-children"),e.isComposable?r!==e.hasItems&&e.recompose():e.updateTextContent(e._textContent)}}syncFlexDirection(){const i=this,{contentElement:e,flexColCls:t,flexRowCls:r}=i,n=new se(e.className),s=E.getStyleValue(e,KF);n[r]=n[t]=0,s.display==="flex"&&(n[s["flex-direction"]==="row"?r:t]=1),E.syncClassList(e,n)}addDescendant(i){const e=i.ref||i.id,t=this._widgetMap||(this._widgetMap={});t[e]||(t[e]=i)}cleanupWidgetMap(i){const e=this,t=new Map,r=i.ref||i.id;r&&t.set(r,i),i.eachWidget(n=>{const s=n.ref||n.id;s&&t.set(s,n)});for(let n=e;n;n=n.parent)for(const[s,a]of t)n.widgetMap[s]===a&&delete n.widgetMap[s]}onChildRemove(i){const e=this;e.cleanupWidgetMap(i),e.layout.onChildRemove(i),e.syncChildCount(!0),!e.onConfigChange.$nullFn&&e.onConfigChange({name:"items",config:e.$meta.configs.items})}get widgetMap(){return this._widgetMap||(this._widgetMap={}),this.initializingItems||this.getConfig("items"),this._widgetMap}changeRecord(i){return this._record=i==null?YF:null,i}updateRecord(i){var e;const t=this;(e=t.recordUpdateDetacher)==null||e.call(t),t.trigger("beforeSetRecord",{record:i}),t.clearError(),t._hasChanges=!1,t.setValues(i,{onlyName:t.strictRecordMapping,highlight:!!t.$highlight}),t.autoUpdateFields&&(i!=null&&i.firstStore)&&(t.recordUpdateDetacher=i.firstStore.ion({update:t.onRecordUpdated,thisObj:t}))}setRecord(i,e){this.$highlight=e,this.record=i,this.$highlight=!1}onRecordUpdated({record:i}){i===this.record&&this.setValues(this.record,!0,!0)}onFieldChange({source:i,userAction:e}){const t=this,{hasChanges:r}=t;if(t.autoUpdateRecord&&e){const{record:n,strictRecordMapping:s}=t,{name:a,ref:o,isValid:l=!0,defaultBindProperty:d}=i,c=i[d||"value"],u=s?a:a||o;n&&u&&l&&(n.isModel?n.setValue(u,c):n[u]=c)}if(!t.isSettingValues){const{initialValues:n}=t;if(n){const s=i.getValueName(n[ZF]);s&&((t.changeSet||(t.changeSet={}))[s]=!T.isEqual(i.value,n[s]),t._hasChanges=!!(t.changeSet&&Object.values(t.changeSet).some(a=>a)))}t.hasChanges!==r&&t.trigger("dirtyStateChange",{dirty:t.hasChanges})}}get hasChanges(){return!!this._hasChanges}getValues(i){const e={};return this.eachWidget((t,r)=>{t.isolateFields?r.down=!1:"name"in t&&(!i||i(t))&&(e[t.name]=t.value)},!0),e}get values(){const i={};return this.gatherValue(i),i}set values(i){this.assignValue(i)}get isSettingValues(){return!!this.assigningValues}get assigningValues(){var i;return this._assigningValues||((i=this.parent)==null?void 0:i.assigningValues)}set assigningValues(i){this._assigningValues=i}assignValue(i,e){super.assignValue(i,e),this.isolateFields||this.setValues(i,e)}gatherValue(i){super.gatherValue(i),this.isolateFields||this.gatherValues(i)}setValues(i,e=this.assignValueDefaults){const t=this;t.assigningValues=e,t.initialValues={optionsProp:e},t.eachWidget(r=>{const n=r.getValueName(e);n&&(!i||n in i)&&(t.initialValues[n]=(i==null?void 0:i[n])||null),r.assignValue(i,e)},!1),t.assigningValues=!1}get hasNoChildren(){const i=this,{items:e,lazyItems:t}=i.initialConfig,r=e&&(Xa(e)?e:T.values(e)),n=t&&(Xa(t)?t:T.values(t)),s=i.isConfiguring?n||r:i.items;return!(s!=null&&s.filter(p0).length)}afterRecompose(){super.afterRecompose(),this.realign()}updateTextContent(i){const e=this;if(!e.isComposable){const t=!!(i&&e.hasNoChildren),{classList:r}=e.contentElement;t!==r.contains("b-text-content")&&(r[t?"add":"remove"]("b-text-content"),e.rendered&&e.realign())}}updateLayoutStyle(i){E.applyStyle(this.contentElement,i)}updateElement(i){if(super.updateElement(...arguments),i){const{classList:e}=this.contentElement,{containerCls:t}=this.layout;e.add("b-content-element"),t&&e.add(t)}}onInternalPaint(){var i;(i=super.onInternalPaint)==null||i.call(this,...arguments),this.getConfig("contentElMutationObserver")}changeContentElMutationObserver(i,e){if(e&&(e.takeRecords(),e.disconnect()),i){const t=this,{element:r,contentElement:n}=t;i=new MutationObserver(s=>t.onContentElMutation(s)),i.observe(n,{attributes:!0}),n!==r&&i.observe(r,{attributes:!0}),t.syncFlexDirection()}return i}onContentElMutation(i){XF[this.layout.type]&&this.isVisible&&i.some(e=>this.contentElement.contains(e.target))&&this.syncFlexDirection()}changeLayout(i,e){return Gi.reconfigure(e,i,{owner:this,defaults:{owner:this}})}get childItems(){return this.items}get childItemsOrderedByRelevance(){return this.items}getWidgetById(i){return this.widgetMap[i]}processWidgetConfig(i){}setupWidgetConfig(i,e){const t=this;typeof i=="string"?i={html:i}:i.nodeType===Element.ELEMENT_NODE&&(i={element:i,id:i.id}),(typeof e=="string"||!e&&(e=i.type))&&(e==="checkbox"&&K.isMobile&&V.resolveType("slidetoggle",!0)&&(e=i.type="slidetoggle"),e=V.resolveType(e,!0)),i=(e||V).mergeConfigs(t.defaults,i,{parent:t});for(let r=i.parent;r;r=r.parent)if(r.processWidgetConfig(i)===!1)return null;return t.trigger("beforeWidgetCreate",{widgetConfig:i})===!1?null:i}createWidget(i){const e=V.create(this.setupWidgetConfig(i),this.defaultType);return e&&(e._createdBy=this),e}updateDefaults(i,e){if(!this.isConfiguring&&i){const t=Object.entries(i);this.eachWidget(r=>{t.forEach(([n,s])=>{(!e||r[n]===e[n])&&(r[n]=s)})},!1)}}render(){this.getConfig("lazyItems"),this.layout.renderChildren(),this.syncChildCount(),super.render(...arguments)}get focusElement(){let i=this.defaultFocus&&this.query(this.defaultFocus);return(!this.defaultFocus||!i)&&(i=this.query(e=>e.isFocusable,!0)),i?i.focusElement:super.focusElement}doDestroy(){var i;(i=this._items)==null||i.forEach(e=>{var t;return(t=e.destroy)==null?void 0:t.call(e)}),this.layout.destroy(),super.doDestroy()}get isValid(){let i=!0;return this.eachWidget(e=>{"isValid"in e&&e.isVisibleForValidation&&!e.isValid&&(i=!1)},!0),i}clearError(){this.eachWidget(i=>{var e;return(e=i.clearError)==null?void 0:e.call(i)})}};v(dt,"$name","Container"),v(dt,"type","container"),dt.initClass(),dt._$name="Container";var{assign:dc}=T,v0=()=>performance.now(),QF={start:!1},JF=/^[.\d]+([^\d].*)?$/,y0=i=>{const e=i.$bryntum||(i.$bryntum={});return e.transitions||(e.transitions=Object.create(null))},b0=(i,e)=>{var t;return typeof i=="string"&&(e=(t=JF.exec(i))==null?void 0:t[1],i=parseFloat(i)),i&&i*(e==="s"||!e&&i<10?1e3:1)},Ov=i=>{const e=T.values(y0(i)).filter(t=>t.completed==null).map(t=>t.toString());i.style.transition=e.join(", ")},C0=i=>class extends i{static get prototypeProperties(){return{_delay:null,_duration:null,_retain:null,_timing:null,_unit:null,owner:null,reverting:null}}constructor(...t){super(...t),this.id=++ek}start(){this.startTime=v0()}get delay(){var t,r,n;return b0((n=(r=this._delay)!=null?r:(t=this.owner)==null?void 0:t.delay)!=null?n:0,this.unit)}set delay(t){this._delay=t}get duration(){var t;const{owner:r,unit:n}=this;return b0((t=this._duration)!=null?t:r?r.duration:Tt.defaultDuration,n)}set duration(t){this._duration=t}get elapsed(){return v0()-this.startTime}get remaining(){return this.duration-this.elapsed}get retain(){var t,r;return(r=this._retain)!=null?r:(t=this.owner)==null?void 0:t.retain}set retain(t){this._retain=t}get timing(){var t,r;return(r=this._timing)!=null?r:(t=this.owner)==null?void 0:t.timing}set timing(t){this._timing=t}get unit(){var t,r;return(r=this._unit)!=null?r:(t=this.owner)==null?void 0:t.unit}set unit(t){this._unit=t}},ek=0,S0=class HI extends $.mixin(C0){static get prototypeProperties(){return{element:null,property:null,from:null,to:null,completed:null,promissory:null,reverting:null}}afterConstruct(){super.afterConstruct();const e=this,{element:t,transitions:r}=e;let{property:n}=e;[n,e.to]=E.unitize(n,e.to),e.from=E.unitize(n,e.from)[1],e.promissory=new Ga,e.property=n;const s=r[n];r[n]=e;let{from:a}=e;s&&(e.from=s.to,a=null,s.destroy()),a===null&&(a=e.getCurrentStyleValue(),s||(e.from=a)),t.style[n]=a,e.getCurrentStyleValue()}doDestroy(){const e=this;e.finish(!1),e.completed&&!e.retain&&e.clearStyle(),super.doDestroy()}get promise(){var e;return(e=this.promissory)==null?void 0:e.promise}get transitions(){return y0(this.element)}clearStyle(){this.setStyle("")}finish(e){const t=this,{transitions:r,promissory:n,property:s}=t;n&&(t.completed=e,t.promissory=null,n.resolve(e),r[s]===t?(delete r[s],e||(Ov(t.element),t.clearStyle())):t.completed=!1)}getCurrentStyleValue(){return E.getStyleValue(this.element,this.property)}revert(){const{duration:e,elapsed:t,element:r,from:n,property:s,_retain:a,_timing:o}=this;return new HI({element:r,property:s,retain:a,timing:o,duration:Math.round(Math.min(e,t)),reverting:this,to:n,unit:"ms"})}setStyle(e){this.element.style[this.property]=e}start(){const e=this,{delay:t,duration:r,element:n,property:s}=e;j.onTransitionEnd({element:n,property:s,duration:t+r+20,thisObj:e.owner,handler:()=>{var a;return(a=e.finish)==null?void 0:a.call(e,!0)}}),super.start(),e.setStyle(e.to)}toString(){const{delay:e,duration:t,property:r,timing:n}=this;return`${r} ${t}ms ${n||"ease-in-out"}${e?` ${e}ms`:""}`}};v(S0,"$name","AnimatorTransition");var $v=S0;$v.initClass();var D0=class zi extends $.mixin(C0){static get prototypeProperties(){return{element:null,finalize:null,prefinalize:null,completed:null,items:null}}static register(e,t){if(T.isObject(e)){T.entries(e).forEach(r=>zi.register(...r));return}zi.fx[e]=t,zi[e]=r=>(E.isElement(r)?r={element:r,[e]:{}}:(r={element:r.element,[e]:r},delete r[e].element),zi.run(r))}static run(e){return new zi(e).start()}constructor(e){var t;super(null);const r=this,n=[],s={};let a,o,l,d;if(Array.isArray(e))r.items=e;else for(l in e)(zi.specialPropsRe.test(l)?r:s)[l]=e[l];T.keys(s).forEach(c=>{d=s[c],d!=null&&d!==!1&&d===d&&((o=zi.fx[c])?(d=dc(r.defaults,o(d,r,c)),d.owner=r,a=new zi(d)):(d=dc(r.defaults,typeof d=="object"?d:{to:d}),d.owner=r,d.property=c,a=new $v(d)),n.push(a))}),(t=r.items)==null||t.forEach(c=>{T.isInstantiated(c)?c.owner=r:(c=dc(r.defaults,c),c.owner=r,c=new zi(c)),n.push(c)}),r.items=n,r.promise=(n.length===1?n[0].promise:Promise.all(n.map(c=>c.promise))).then(c=>{var u;return(u=r.finish)==null||u.call(r,c),r.completed||!1})}doDestroy(){this.items.forEach(e=>e.destroy()),super.doDestroy()}get defaults(){return{element:this.element}}get retain(){const{_retain:e,finalize:t,owner:r}=this;return e!=null?e:t?!1:r?r.retain:!0}set retain(e){super.retain=e}done(){return this.promise}finish(e){var t,r;const n=this,{items:s}=n;for(Ov(n.element),n.completed=typeof e=="boolean"?e:!e.some(a=>!a),(t=n.prefinalize)==null||t.call(n,n.completed,n);s.length;)s.pop().destroy();(r=n.finalize)==null||r.call(n,n.completed,n)}revert(e){var t;const r=this,{reverting:n}=r,s=!e||((t=e.start)!=null?t:!0);let a=r.defaults;return n&&(n.finalize&&(a.finalize=n.finalize),n.prefinalize&&(a.prefinalize=n.prefinalize),a.retain=n._retain),a=dc(a,e,{items:r.items.map(o=>o.revert(QF)),reverting:r}),a=new zi(a),s&&a.start(),a}start(){const{element:e,items:t}=this;return super.start(),t.length&&(Ov(e),t.forEach(r=>r.start())),this}};v(D0,"$name","Animator");var Tt=D0;Tt.initClass().Transition=$v,Tt.specialPropsRe=new RegExp(`^(?:${Object.keys(Tt.prototypeProperties).concat(Object.keys(Tt.superclass.prototypeProperties)).map(i=>i[0]==="_"?i.substr(1):i).join("|")})$`),Tt.defaultDuration=200,Tt.fx={},Tt.register({puff(i){return i===!0?i={}:typeof i!="object"?i={transform:`scale(${i})`}:i.scale&&(i=T.clone(i),i.transform=`scale(${i.scale})`,delete i.scale),dc({opacity:0,transform:"scale(8)"},i)}}),Tt._$name="Animator";var Xf=class extends $.mixin(ve){static get configurable(){return{element:null,delegate:null,delay:500,startRate:2,endRate:20,accelerateDuration:4e3,pressedCls:"b-pressed"}}doDestroy(){var i;(i=this.mousedownRemover)==null||i.call(this),this.cancel(),super.doDestroy()}cancel(){var i,e,t;const r=this;(i=r.activeElement)==null||i.classList.remove(r.pressedCls),r.activeElement=null,(e=r.acceleration)==null||e.cancel(),r.activeListenerRemover=(t=r.activeListenerRemover)==null?void 0:t.call(r),r.clearTimeout(r.autoRepeatTimer),r.clearTimeout(r.repeatTimer)}updateElement(i){var e;(e=this.mousedownRemover)==null||e.call(this),this.mousedownRemover=j.on({element:i,mousedown:"onMouseDown",thisObj:this})}onMouseDown(i){const e=this,t=e.delegate?i.target.closest(e.delegate):e.element;e.cancel(),t&&(e.activeElement=t,e.triggerEvent=i,t.classList.add(e.pressedCls),e.activeListenerRemover=j.on({mouseup:{element:document,capture:!0,handler:"onMouseUp"},mousemove:{element:t,handler:"onTargetMouseMove"},mouseleave:{element:t,handler:"onTargetMouseLeave"},mouseenter:{element:t,handler:"onTargetMouseEnter"},thisObj:e}),e.autoRepeatTimer=e.setTimeout("startAutoRepeat",e.delay))}onMouseUp(){this.cancel()}onTargetMouseLeave(){this.activeElement.classList.remove(this.pressedCls),this.clearTimeout(this.repeatTimer)}onTargetMouseEnter(i){const e=this;i.buttons?(e.activeElement.classList.add(e.pressedCls),e.triggerEvent=i,e.fireClick()):e.cancel()}onTargetMouseMove(i){this.triggerEvent=i}startAutoRepeat(){const i=this;i.interval=i.startInterval=1e3/i.startRate,i.accelerationDelta=i.startInterval-1e3/i.endRate,i.fireClick(),i.acceleration=Se.animate(i.accelerateDuration,i.nextTick,i,"easeOutQuad")}nextTick(i){this.interval=this.startInterval-this.accelerationDelta*i}fireClick(){const i=this,e=new MouseEvent("click",i.triggerEvent);i.triggerEvent.target.dispatchEvent(e),i.repeatTimer=i.setTimeout(i.fireClick,i.interval)}};Xf._$name="ClickRepeater";var tk=/^(?:undefined|null|LEFT|RIGHT)$/,ik={TOP:"BOTTOM",RIGHT:"LEFT",BOTTOM:"TOP",LEFT:"RIGHT"},w0=i=>{const e=i==null?void 0:i.toUpperCase();return[e,e==="LEFT"||e==="RIGHT"]},Zf=i=>{var e;return e=class extends(i||$){static get configurable(){return{rotate:null,invertRotate:null}}compose(){const{rotate:t}=this;return{class:{[`b-rotate-${(t||"").toLowerCase()}`]:t,"b-rotate-vertical":t}}}syncRotationToDock(t){if(tk.test(String(this.rotate))){const[r,n]=w0(t);this.rotate=n?this.invertRotate?ik[r]:r:null}}get widgetClass(){return null}},v(e,"$name","Rotatable"),e},ms=class extends V.mixin(Zf){compose(){const{align:i,href:e}=this;return{tag:e!=null?"a":"button",class:{[`b-align-${i||"end"}`]:1,"b-icon":1},listeners:{click:"onInternalClick"}}}get focusElement(){return this.element}get panel(){var i,e;if((i=this.parent)!=null&&i.isPanel&&((e=this.element)!=null&&e.parentNode.matches(".b-panel-header")))return this.parent}changeAlign(i){return i}onInternalClick(i){const e=this,{handler:t,panel:r}=e,n={domEvent:i,tool:e};e.disabled||(e.trigger("click",n),e.isDestroyed||(e.trigger("action",n),!e.isDestroyed&&(r==null?void 0:r.trigger("toolClick",n))!==!1&&t&&e.callback(t,r,[i,r,e])))}onInternalKeyDown(i){(i.key.trim()||i.code)==="Enter"&&i.stopPropagation()}updateDisabled(i,e){var t;super.updateDisabled(i,e),i&&((t=this.repeat)==null||t.cancel())}changeRepeat(i,e){return e==null||e.destroy(),i&&Xf.new({element:this.element},i)}};v(ms,"$name","Tool"),v(ms,"type","tool"),v(ms,"configurable",{align:{value:null,$config:{merge:"replace"}},href:null,repeat:null,defaultBindProperty:null}),ms.initClass(),ms._$name="Tool";var rk=/right/i,nk=i=>(i.collapsed||i.collapsing)&&i.owner.expandedHeaderDock==="top"&&i.owner.collapsible.direction.match(rk)?"start":"end",cc=class extends ms{static get configurable(){return{autoAlign:!0,collapsed:null,collapsing:null,collapsify:!1,direction:"up",defaultBindProperty:null}}compose(){const{collapsed:i,direction:e}=this;return{class:{[`b-icon-collapse-${e}`]:1,"b-collapsed":i}}}changeAutoAlign(i){return i===!0?nk:i}syncAutoAlign(){const{autoAlign:i}=this;i&&(this.align=i(this))}updateAutoAlign(){this.syncAutoAlign()}updateCollapsed(){this.syncAutoAlign()}updateCollapsing(){this.syncAutoAlign()}updateDirection(){this.syncAutoAlign()}};v(cc,"$name","CollapseTool"),v(cc,"type","collapsetool"),cc.initClass(),cc._$name="CollapseTool";var E0=/^(?:UP|DOWN|LEFT|RIGHT)$/,sk=/^(left|top)$/i,ak={},x0=/^b-dock-(top|left|right|bottom)$/,Bv="b-panel-collapse-revealer",ok=/^(?:left|right)$/i,Qf="b-collapse-unflex",{round:dn}=Math,R0=["up","down","left","right"].reduce((i,e)=>(i[e.toUpperCase()]=i[e]=e,i),{}),Hv={top:["top","bottom"],right:["right","left"],bottom:["bottom","top"],left:["left","right"]},lk={hl:"LEFT",hr:"RIGHT",vb:"DOWN",vt:"UP"},dk={h:"w",w:"h"},T0={up:"top",right:"right",down:"bottom",left:"left"},Jf={top:!1,right:!0,bottom:!1,left:!0},ck={top:"UP",right:"RIGHT",bottom:"DOWN",left:"LEFT"},M0={top:i=>`translate(0, -${dn(i.height||0)}px)`,bottom:i=>`translate(0, ${dn(i.height||0)}px)`,right:i=>`translate(${dn(i.width||0)}px, 0)`,left:i=>`translate(-${dn(i.width||0)}px, 0)`},uk=0,Rr=class extends $.mixin(ds){static get configurable(){return{animation:{duration:200},collapsed:{value:null,$config:null,default:!1},direction:null,collapseTooltip:"L{Collapse}",expandTooltip:"L{Expand}",panel:{value:null,$config:"nullify"},supportAxis:null,tool:{type:"collapsetool",handler(i){var e;(e=this.collapsible)==null||e.onCollapseClick(i)}}}}static get factoryable(){return{defaultType:"inline"}}get collapsing(){return this.collapsingExpanding==="collapsing"}get collapsingExpanding(){var i;const e=(i=this.currentOperation)==null?void 0:i.collapsing;return e==null?null:e?"collapsing":"expanding"}get currentDock(){var i,e,t,r;return(r=(t=(e=(i=this.panel)==null?void 0:i.header)==null?void 0:e.dock)==null?void 0:t.toLowerCase())!=null?r:"top"}get expanding(){return this.collapsingExpanding==="expanding"}get collapseTool(){var i,e;return(e=(i=this.panel)==null?void 0:i.tools)==null?void 0:e.collapse}get collapseDim(){return ok.test(this.collapseDir)?"width":"height"}getCollapseDir(i){var e;let{direction:t,panel:r}=this;if(!t||E0.test(t)){const n=r==null?void 0:r.placement;n?t=lk[n]:t=ck[((e=r==null?void 0:r.header)==null?void 0:e.dock)||"top"]}return i?R0[t]:t}get collapseDir(){return this.getCollapseDir(!0)}get collapseDock(){return this.collapseInfo[0]}get collapseInfo(){const{panel:i}=this,e=i.hasHeader&&i.expandedHeaderDock;let t=T0[this.collapseDir],r=!1;return e&&((r=Jf[t]!==Jf[e])||(t=e)),[t,r]}get toolsConfig(){const{direction:i,tool:e}=this;return e&&{collapse:T.assign({direction:i.toLowerCase()},e)}}beforeCollapse(i){const{panel:e}=this,{element:t}=e;t.contains(E.getActiveElement(t))&&e.revertFocus(!0)}changeTool(i){const e=this,{panel:t}=e;if(e.isConfiguring||e.isDestroying||!t||t.isDestroying)return i;t.tools={collapse:i}}collapse(i){var e,t;const r=this,{panel:n}=r,s={id:++uk,completed:!1,panel:n};let{currentOperation:a}=r;return i=i!=null?i:!0,T.isObject(i)&&(s.collapsed=!0,T.assign(s,i),i=s.collapsed,delete s.collapsed),s.collapsing=i,s.previous=a!=null?a:null,i!==r.collapsed?a?a.collapsing!==i&&(s.animation=a.animation.revert({finalize(){var o;(o=r.collapseFinalize)==null||o.call(r,s,!0)}}),s.collapsing=i,a=s):(s.animation=T.clone(("animation"in s?s:r).animation),r.beforeCollapse(s)!==!1&&(s.animation&&(s.animation.finalize=o=>{var l;return(l=r.collapseFinalize)==null?void 0:l.call(r,s,o)}),n.changingCollapse=!0,r[i?"collapseBegin":"expandBegin"](s),s.animation?a=s:(s.completed=!0,r[i?"collapseEnd":"expandEnd"](s)),n.changingCollapse=!1,s.animation||r.onComplete(i?"collapse":"expand"))):a&&a.collapsing!==i&&(r[i?"expandRevert":"collapseRevert"](s),s.animation=a.animation.revert({finalize(){var o;(o=r.collapseFinalize)==null||o.call(r,s,!1)}}),a=s),r.currentOperation=a,(t=(e=a==null?void 0:a.animation)==null?void 0:e.done())!=null?t:Promise.resolve(i===r.collapsed)}collapseFinalize(i,e){const t=this,{currentOperation:r,panel:n}=t,s=n.collapsed?"expand":"collapse";r===i&&(t.currentOperation=null,i.completed=e,n.changingCollapse=!0,t[s+"End"](i),n.changingCollapse=!1,e&&t.onComplete(s))}applyHeaderDock(i,e=!0){const t=this,{currentDock:r,panel:n}=t,{header:s}=n,a=i?t.collapseDock:n.expandedHeaderDock;a!==r&&n.hasHeader&&(n.header=s?typeof s=="string"?{title:s}:T.clone(n.header):{},n.header.dock=a,e&&n.recompose.flush())}composeHeader(i){const{panel:e}=this,{class:t}=i,r=e.expandedHeaderDock||Object.keys(t).filter(n=>t[n]&&x0.test(n)).map(n=>x0.exec(n)[1][0]);return t[Bv]=1,t[`b-collapsible-${r[0]}${this.collapseDir[0]}`]=1,i}composeTitle(i){return i.class[Bv]=1,i}collapseBegin(i){var e;const t=this,{animation:r}=i,{collapseDim:n,collapseTool:s,panel:a}=t,{element:o,placement:l}=a,[d,c]=t.collapseInfo,u=s==null?void 0:s.element.classList,h=!l||l[0]==="h"&&n==="width"||l[0]==="v"&&n==="height";t.configuredWidth=a._lastWidth,t.configuredHeight=a._lastHeight,t.transverseCollapse=c,t.applyHeaderDock(!0);const f=a.rectangle(),g=t.lockInnerSize().moveTo(0,0),m=g.clone(),p=Hv[d],y=(e=a.headerElement)==null?void 0:e.getBoundingClientRect(),b=dn((y==null?void 0:y[n])||0);o.classList.toggle(Qf,h),r?(m[p[0]]=m[p[1]],o.classList.add("b-collapsing"),u==null||u.add("b-collapsed","b-collapsing"),s&&(s.collapsing=!0),u&&(u.remove("b-collapsed"),a.rectangle(),u.remove("b-collapsing"),u.add("b-collapsed")),r.element=o,r.retain=!0,r[n]={from:dn(f[n]),to:b},r.items=[{element:t.innerElement,retain:!1,clip:{from:`rect(${g})`,to:`rect(${m})`}}],c&&r.items.push({element:a.headerElement,duration:r.duration,retain:!1,transform:{from:M0[d](y),to:"translate(0, 0)"}}),i.animation=Tt.run(r)):(o.style[n]=`${b}px`,s&&(u.add("b-collapsing","b-collapsed"),s.rectangle(),u.remove("b-collapsing")))}collapseEnd(i){const e=this,{collapseTool:t}=e;e.panel.element.classList.remove("b-collapsing"),t&&(t.collapsing=!1),i.completed?e.collapsed=!0:(e.applyHeaderDock(!1),e.restoreConfiguredSize(),e.lockInnerSize(!1))}collapseRevert(i){var e;(e=this.collapseTool)==null||e.element.classList.remove("b-collapsed")}expandBegin(i){const e=this,{animation:t}=i,{collapseDim:r,collapseTool:n,panel:s}=e,[a,o]=e.collapseInfo,{element:l}=s,d=l.classList,c=d.contains(Qf),u=s.rectangle();d.remove("b-collapsed","b-collapsing"),s.element.style[r]="",e.restoreConfiguredSize(),e.lockInnerSize(!1);const h=s.rectangle(),f=e.lockInnerSize().moveTo(0,0),g=f.clone(),m=Hv[e.collapseDock];n==null||n.element.classList.remove("b-collapsed"),t&&(g[m[0]]=g[m[1]],d.add("b-collapsed","b-expanding"),c&&d.add(Qf),t.element=l,t[r]={from:dn(u[r]),to:dn(h[r])},t.items=[{element:e.innerElement,retain:!1,clip:{from:`rect(${g})`,to:`rect(${f})`}}],o&&t.items.push({element:s.headerElement,duration:t.duration,retain:!1,transform:{from:"translate(0, 0)",to:M0[a](u)}}),i.animation=Tt.run(t))}expandEnd(i){const e=this;e.panel.element.classList.remove("b-expanding"),i.completed&&(e.collapsed=!1,e.applyHeaderDock(!1),e.restoreConfiguredSize(),e.lockInnerSize(!1))}expandRevert(i){var e;(e=this.collapseTool)==null||e.element.classList.add("b-collapsed")}get innerElement(){return this.panel.collapseWrapElement||this.panel.bodyWrapElement}get innerSizeElement(){return this.transverseCollapse?this.panel.element:this.innerElement}get supportAxis(){let{_supportAxis:i}=this;const e=i===!0;return(e||i==null)&&(i=this.collapseDim[0],(e||E.getStyleValue(this.panel.element,"position")==="absolute")&&(i+=dk[i])),i||""}lockInnerSize(i=!0){const e=this,{innerElement:t,panel:r}=e,n=i?e.supportAxis:"",s=r.element,a=r.headerElement,o=i&&a&&k.from(a,s),l=i&&k.from(e.innerSizeElement,s),d=t.style;return a&&(a.style.minWidth=n.includes("w")?`${o.width}px`:"",a.style.minHeight=n.includes("h")?`${o.height}px`:""),d.width=i?`${l.width}px`:"",d.height=i?`${l.height}px`:"",t.classList[i?"add":"remove"]("b-panel-collapse-size-locker"),l}onCollapseClick(i){let e=this.collapsing?!1:this.expanding?!0:!this.collapsed;i.altKey&&(e={animation:null,collapsed:e}),this.collapse(e)}onComplete(i){var e;(e=this.panel)==null||e.trigger(i)}onPanelHeaderClick({event:i}){i.button===0&&this.panel.collapsed&&i.target.classList.contains(Bv)&&this.onRevealerClick()}onPanelConfigChange({name:i,value:e}){const t=this,{panel:r}=t;i==="collapsed"?r.isPainted&&(t.collapsed=e):i==="header"&&!r.changingCollapse&&t.syncDirection()}onPanelPaint(){this.syncDirection(),this.panel.collapsed&&!this.collapsed&&this.collapse({animation:null,collapsed:!0})}onRevealerClick(){this.panel._collapse({collapsed:!1})}restoreConfiguredSize(i){const{configuredHeight:e,configuredWidth:t,panel:r}=this;i=i!=null?i:"wh",r.element.classList.remove(Qf),t!=null&&i.includes("w")&&(r.width=t),e!=null&&i.includes("h")&&(r.height=e)}splitHeaderItems({as:i,dock:e}=ak){var t;return(t=this.panel)==null?void 0:t.splitHeaderItems({as:i,dock:e,alt:!0})}syncDirection(){const i=this,{direction:e}=i;(!e||E0.test(e))&&(i.direction=i.getCollapseDir())}changeCollapsed(i){return!!i}updateCollapsed(i){const{collapseTool:e,panel:t}=this;t&&(t.collapsed=i,t.element.classList[i?"add":"remove"]("b-collapsed")),e&&(e.collapsed=i)}updateDirection(i){const{collapseTool:e,panel:t}=this;e&&(e.direction=R0[i]),t!=null&&t.rendered&&t.recompose()}updatePanel(i){var e;const t=this;t.syncDirection(),(e=t.panelChangeDetacher)==null||e.call(t),t.panelChangeDetacher=i&&Se.after(i,"onConfigChange","onPanelConfigChange",t,{return:!1})}wrapCollapser(i,e){var t;const r=this,[n,s]=r.collapseInfo;if(!s)return[i,e];const{collapseDir:a,panel:o}=r,{expandedHeaderDock:l,header:d,uiClassList:c}=o,u=(t=o.tools)==null?void 0:t.recollapse,[h,f]=r.splitHeaderItems({as:"element",dock:n}),g=o.hasHeader?o.title||(d==null?void 0:d.title)||"\xA0":null,m=g&&{tag:"header",class:new se({...c,[`b-dock-${l}`]:1,"b-panel-header":1,"b-panel-collapser-header":1},d==null?void 0:d.cls),children:[...h,{reference:"collapserTitleElement",html:g,class:{...c,[`b-align-${(d==null?void 0:d.titleAlign)||"start"}`]:1,"b-header-title":1}},...f]};return u&&(u.direction=a),["collapseWrapElement",{class:{...c,[`b-panel-collapser-header-${l}`]:1,[`b-panel-collapser-${a}`]:1,[`b-${Jf[l]?"h":"v"}box`]:1,"b-panel-collapser":1,"b-box-center":1},children:sk.test(l)?{collapserHeaderElement:m,[i]:e}:{[i]:e,collapserHeaderElement:m}}]}};v(Rr,"$name","PanelCollapser"),v(Rr,"type","inline"),Rr.maps={clipByDock:Hv,dockByDirection:T0,dockIsHorz:Jf},Rr.initClass(),Rr._$name="PanelCollapser";var uc=Symbol("pendingCreate"),ps=class extends ${static get prototypeProperties(){return{cleanup:null,configName:null,created:null,factory:null,inferType:"name",owner:null,ownerName:null,proxyable:typeof Proxy!="undefined",setup:null,transform:null}}static get properties(){return{defaults:{},instances:{},object:Object.create({})}}get proxy(){const i=this;let e=null;return i.proxyable&&(e=new Proxy(i.instances,{get(t,r){return i.get(r)},set(t,r,n){return i.set(r,n),!0},deleteProperty(t,r){return i.set(r,null),!0}})),Reflect.defineProperty(i,"proxy",{configurable:!0,value:e}),e}get target(){return this.proxy||this.object}define(i,e){const t=this,{transform:r}=t,n=r?r(e,i):e,s=T.isInstantiated(n);t.instances[i]=uc,s||t.setDefaults(i,n),t.defineProp(i,!0),s&&t.set(i,n)}defineProp(i,e){const t=this,{object:r}=t;t.proxy||Reflect.defineProperty(e?Object.getPrototypeOf(r):r,i,{configurable:!e,enumerable:!0,get(){return t.get(i)},set(n){return t.set(i,n)}})}flush(){var i;const e=this;try{e.updating=!0;for(const t in e.defaults)e.get(t);e.afterConfigureOwner=(i=e.afterConfigureOwner)==null?void 0:i.call(e)}finally{e.updating=!1}}get(i){const{defaults:e,instances:t}=this;return t[i]===uc&&this.set(i,uc),t[i]||e[i]&&null}set(i,e){var t;const r=this,{cleanup:n,configName:s,defaults:a,factory:o,instances:l,owner:d,setup:c,transform:u,updating:h}=r,f=d&&s&&!h,g=l[i]===uc?null:l[i],m=o.reconfigure(g,e===uc?{}:e||null,{cleanup:n&&(p=>n(p,i)),defaults:a[i]||r.setDefaults(i,{}),owner:r.owner,setup:c&&((p,y,b)=>c(p,i,y,b)),transform:u&&(p=>u(p,i))});if(m!==g){const p=f&&{...l};l[i]=m,m?(r.defineProp(i),(t=r.created)==null||t.call(r,m,i)):(delete r.object[i],delete l[i]),f&&d.onConfigChange({name:s,config:d.$meta.configs[s],value:r.target,was:p})}}setDefaults(i,e){const{defaults:t,factory:r,inferType:n,instances:s,owner:a,ownerName:o}=this,{typeKey:l}=r.factoryable;return e=e===!0?{}:T.assign({},e),(n==="name"||n===!0&&!e[l])&&(e[l]=i),o&&(e[o]=a),e.beforeConfigure=d=>{s[i]=d},t[i]=e}update(i){const e=this,{owner:t}=e;let r,n;try{if(e.updating=!0,i)for(r in i)n=i[r],e.defaults[r]?e.set(r,n):n&&e.define(r,n);else for(r in e.instances)e.set(r,null)}finally{e.updating=!1}t&&(t.isConfiguring?e.afterConfigureOwner||(e.afterConfigureOwner=Se.before(t,"afterConfigure","flush",e)):e.flush())}};ps.initClass(),ps._$name="DynamicObject";var hk=[],jv={},fk={align:1,weight:1},Vv=i=>{var e;return e=class extends(i||V){static get configurable(){return{tools:{value:null,$config:{nullify:!0}},toolDefaults:{"*":{type:"tool",align:"end"}}}}byWeightSortFn(t,r){return(t.weight||0)-(r.weight||0)}byWeightReverseSortFn(t,r){return(r.weight||0)-(t.weight||0)}gatherTools({align:t,alt:r,refs:n}=jv){var s,a,o;const{collapsed:l,tools:d}=this,c={collapsed:l,alt:r};let u=[],h,f,g,m,p;for(f in d)p=d[f],h=(o=(a=(s=p==null?void 0:p.align)==null?void 0:s.align)!=null?a:p==null?void 0:p.align)!=null?o:"end",h===t&&p.isCollapsified(c)&&u.push(p);if(u.sort(this[t==="end"?"byWeightReverseSortFn":"byWeightSortFn"]),n){const y=n==="widget",b={};for(g=0;g<u.length;++g)m=u[g],b[m.ref]=y?m:m.element;u=b}return u}getEndTools({alt:t,refs:r}=jv){return this.gatherTools({align:"end",alt:t,refs:r})}getStartTools({alt:t,refs:r}=jv){return this.gatherTools({align:"start",alt:t,refs:r})}get childItems(){return[...this.getStartTools(),...this._items||hk,...this.getEndTools()]}changeTools(t,r){const n=this,s=n.$tools||(n.$tools=new ps({configName:"tools",factory:V,inferType:!1,owner:n,created(a){var o,l;a.innerItem=!1,(l=a.syncRotationToDock)==null||l.call(a,(o=n.header)==null?void 0:o.dock),Se.after(a,"onConfigChange",(d,{name:c})=>{fk[c]&&n.onConfigChange({name:"tools",value:s.target})}),n.onChildAdd(a)},setup(a,o){return a=T.merge({},n.toolDefaults["*"],n.toolDefaults[o],a),a.parent=n,a.ref=o,a}}));if(s.update(t),!r)return s.target}get widgetClass(){}},v(e,"$name","Toolable"),e},I0=["b-hbox","b-vbox"],gk={name:"align",style:"alignItems"},mk={name:"contentAlign",style:"alignContent"},pk={name:"direction",style:"flexDirection"},vk={name:"justify",style:"justifyContent",classes:["stretch"]},yk={name:"wrap",style:"flexWrap",map:{false:"nowrap",true:"wrap",reverse:"wrap-reverse"}},cn=class extends Gi{get vertical(){return this.horizontal===!1}set vertical(i){return this.horizontal=!i}updateAlign(){this.syncConfigStyle(gk)}updateContentAlign(){this.syncConfigStyle(mk)}updateDirection(){this.syncConfigStyle(pk)}updateHorizontal(){var i;const e=this,t=(i=e.contentElement)==null?void 0:i.classList,r=Number(e.vertical);t?(t.remove(I0[1-r]),t.add(I0[r])):e.syncConfigLater("horizontal"),e.syncDirection()}updateJustify(){this.syncConfigStyle(vk)}updateReverse(){this.syncDirection()}updateWrap(){this.syncConfigStyle(yk)}syncDirection(){const i=this,{reverse:e}=i;i.direction=e?`${i.vertical?"column":"row"}${e?"-reverse":""}`:null}};v(cn,"$name","Box"),v(cn,"type","box"),v(cn,"alias","hbox"),v(cn,"configurable",{containerCls:"b-box-container",itemCls:"b-box-item",align:null,contentAlign:null,direction:null,horizontal:!0,justify:null,reverse:null,wrap:null}),cn.initClass(),cn._$name="Box";var Za=class extends cn{};v(Za,"$name","VBox"),v(Za,"type","vbox"),v(Za,"configurable",{horizontal:!1}),Za.initClass(),Za._$name="VBox";var zv=i=>{var e;return e=class extends(i||$){static get configurable(){return{badge:null}}compose(){const{badge:t}=this;return{dataset:{badge:t},class:{"b-badge":t!=null&&t!==""}}}},v(e,"$name","Badge"),e},_0=/(?:^|\s)b-icon-/,P0=/(?:^|\s)b-fa-/,bk=["items","type","widgets","html","listeners"],A0=Symbol("defaultListener"),gi=class extends V.mixin(zv,Zf){static get configurable(){return{icon:null,menuIcon:"b-icon-picker",pressedIcon:null,pressedCls:null,iconAlign:"start",behaviorType:"button",text:{value:null,$config:null,default:""},color:null,toggleable:void 0,pressed:!1,toggleGroup:null,supportsPressedClick:!1,supportsUnpressing:!1,ripple:{radius:75},twinForwardEvents:{item:"action"},twinSyncConfigs:null,localizableProperties:["text"],menu:{$config:["lazy","nullify"],value:null},menuDefaults:{type:"menu",autoShow:!1,autoClose:!0,floating:!0,scrollAction:"realign",align:"t0-b0"},href:null,target:null,tabIndex:null,defaultBindProperty:null}}construct(...i){super.construct(...i),this.ion({hide:"onInternalHide"})}get twinSyncConfigs(){if(this.toggleable)return{pressed:"checked"}}updateElement(i,e){var t,r,n;const s=this,{constructor:a}=s,o=super.updateElement(i,e),l=s.peekConfig("menu"),d=l?l.isWidget?l.role:((r=(t=a.resolveType(l.type))==null?void 0:t.configurable)==null?void 0:r.role)||((n=a.configurable.menuDefaults)==null?void 0:n.type)||"menu":!1;return s.ariaHasPopup=d,o}compose(){const{color:i,href:e,icon:t,iconAlign:r,pressed:n,pressedIcon:s,target:a,text:o,toggleable:l,toggleGroup:d,menuIcon:c,behaviorType:u,tabIndex:h,pressedCls:f}=this,g=this.hasConfig("menu"),m=n&&s?s:t;return{tag:e?"a":"button",href:e,target:a,tabIndex:h,type:u,class:{[`b-icon-align-${r}`]:t,[i]:!!i,"b-pressed":n&&l,"b-text":!!o,"b-has-menu":g,...n&&f?Object.fromEntries(f.split(" ").map(p=>[p,1])):{}},[l&&!g?"aria-pressed":""]:n,dataset:{group:d},listeners:{click:"onInternalClick",mousedown:"onInternalMousedown"},children:{iconElement:(t||s)&&{"aria-hidden":!0,tag:"i",class:{...se.normalize(m,"object"),"b-button-icon":1,"b-icon":_0.test(m),"b-fa":P0.test(m)}},label:o&&{tag:"label",for:this.id,text:o},menuIconElement:g&&c&&{tag:"i",class:{"b-icon":_0.test(c),"b-fa":P0.test(c),"b-button-menu-icon":1,[c]:1}}}}}onInternalHide(){var i;(i=this._menu)==null||i.hide()}get childItems(){return this._menu&&[this.menu]}onFocusOut(i){var e;super.onFocusOut(i),(e=this.menu)==null||e.hide()}get focusElement(){return this.element}changeText(i){return i==null?"":i}changeToggleable(i){return i===void 0&&(i=!!(this.toggleGroup||this.config.menu)),i}changeMenu(i,e){const t=this,{element:r}=t;return i?(i.isWidget?(i.forElement=r,i.owner=t,i.constrainTo=t.rootElement):(typeof i=="object"&&!bk.some(n=>n in i)&&(i={lazyItems:i}),i=V.reconfigure(e,i?T.merge({owner:t,constrainTo:t.rootElement,forElement:r},t.menuDefaults,i):null,t)),i.align.constrainPadding=10,t.detachListeners(A0),i.ion({name:A0,beforeShow:"onMenuBeforeShow",hide:"onMenuHide",show:"onMenuShow",thisObj:this})):e==null||e.destroy(),i}onMenuBeforeShow({source:i}){return this.trigger("beforeShowMenu",{menu:i})}onMenuShow(){this.ariaElement.setAttribute("aria-expanded",!0)}onMenuHide(){this.ariaElement.setAttribute("aria-expanded",!1),this.toggle(!1)}updateMenu(i){this.toggleable=!!i}updatePressed(i){var e,t;const r=this;if(!r.toggleable||r.isConfiguring)return;const{menu:n}=r;i&&E.forEachSelector(r.rootElement,`button[data-group=${r.toggleGroup}]`,s=>{s!==r.element&&(V.getById(s.id).pressed=!1)}),n&&(n.owner=r,n.forElement=r.element,n.initialConfig.minWidth||(n.minWidth=r.width),n.align.minHeight=(e=n._minHeight)!=null?e:100,n.align.minWidth=(t=n._minWidth)!=null?t:100,n[i?"show":"hide"]()),r.trigger("toggle",{pressed:i,userAction:r._isUserAction})}configureOverflowTwin(i){const e=this,t=super.configureOverflowTwin(i),{menu:r}=e;return t.type=V.resolveType("menuitem"),r?t.menu=e.constructor.mergeConfigs(t.menu,{type:"menu",items:r.items.map(n=>n.ensureOverflowTwin())}):e.toggleable&&(t.checked=e.pressed),t.text||(t.text=e.text||e.tooltipText),t}onInternalMousedown(i){var e;(e=this._menu)!=null&&e.containsFocus&&this.pressed&&i.preventDefault()}changeTooltip(i,e){const t=this,r=(i==null?void 0:i.html)||i;return!t.ariaLabel&&!t.text&&typeof r=="string"&&(t.ariaLabel=t.optionalL(r,t)),super.changeTooltip(i,e)}onInternalClick(i){const e=this,t={event:i};if(!e.disabled){if(e._isUserAction=!0,e.toggleable){const r=e.toggleGroup&&e.pressed&&!e.supportsUnpressing;if(r&&!e.supportsPressedClick||(r||e.toggle(!e.pressed),e.isDestroyed))return}e.trigger("click",t),e.isDestroyed||e.trigger("action",t),e.href||(i.preventDefault(),i.stopPropagation()),e._isUserAction=!1}}toggle(i=!this.pressed){this.trigger("beforeToggle",{pressed:i,userAction:this._isUserAction})!==!1&&(this.pressed=i)}};v(gi,"$name","Button"),v(gi,"type","button"),gi.initClass(),gi._$name="Button";var F0={refs:"element"},Ck=i=>i.element.style.margin="",Sk=i=>i.isToolbar,k0=i=>i[0]+(i[1].minifiable?0:9e9),L0={hidden:!1,width:""},Dk={...L0,flex:""},wk={flex:1,hidden:1,maxWidth:1,minWidth:1,width:1,disabled:1},Ek=[{box:"hbox",clientSizeProp:"clientWidth",edgeProp:"right",flexDir:"row",horizontal:!0,max:"maxX",overflow:"overflowX",pos:"x",scrollSize:"scrollWidth",sizeProp:"width"},{box:"vbox",clientSizeProp:"clientHeight",edgeProp:"bottom",flexDir:"column",horizontal:!1,max:"maxY",overflow:"overflowY",pos:"y",scrollSize:"scrollHeight",sizeProp:"height"}],xk={delay:0,startRate:40,endRate:200,accelerateDuration:500},Rk={menu:1,pressed:1},Qa=class jI extends dt.mixin(Vv){static getEvictionList(e){const t=e.filter(r=>r.overflowable!=="none");return t.forEach((r,n)=>t[n]=[n,r]),t.sort((r,n)=>k0(n)-k0(r)),t}compose(){const e=this,{axisProps:t,dock:r}=e,n=e.getEndTools(F0),s=e.getStartTools(F0);return{class:{[`b-dock-${r}`]:1,[`b-${r}-toolbar`]:1,[`b-${t.box}`]:1},children:{...s,toolbarContent:{class:{"b-box-center":1,"b-toolbar-content":1}},...n}}}get axisProps(){return Ek[this.layout.horizontal?0:1]}get contentElement(){return this.toolbarContent}get overflowMenuButton(){var e;return(e=this.tools)==null?void 0:e.overflowMenuButton}get overflowType(){const{overflow:e}=this;return typeof e=="string"?e:e==null?void 0:e.type}onChildAdd(e){var t;super.onChildAdd(e),this.processAddedLeafItem(e),(t=e.syncRotationToDock)==null||t.call(e,this.dock)}onChildRemove(e){super.onChildRemove(e),this.syncOverflowVisibility()}processAddedLeafItem(e){Se.after(e,"onConfigChange",this.onLeafItemConfigChange,e),e.isContainer&&e.eachWidget(t=>this.processAddedLeafItem(t))}onInternalPaint({firstPaint:e}){var t;(t=super.onInternalPaint)==null||t.call(this,...arguments),e&&this.getConfig("overflow")}updateDock(e){var t;const r=this,{layout:n}=r,{vertical:s}=n;if(n.vertical=w0(e)[1],!r.initialItems){s!==n.vertical&&r.updateOverflow(r.overflow);for(const a of r.childItems)(t=a.syncRotationToDock)==null||t.call(a,e)}}updateOverflow(e,t){var r,n;const s=this,{axisProps:a,contentElement:o,overflowType:l}=s,{flexDir:d}=a,c=(r=s.overflowMenuButton)==null?void 0:r._menu,u={};if(c&&(e?c==null||c.removeAll():c.eachWidget(h=>{h._overflowTwinOrigin.overflowTwin=null})),t==="menu"?u.overflowMenuButton=null:t==="scroll"&&(u.overflowScrollStart=u.overflowScrollEnd=null),l==="menu")(n=s.scrollable)==null||n.destroy(),o.style.overflow=o.style.overflowX=o.style.overflowY="",u.overflowMenuButton={cls:{[`b-${d}-menu`]:1}};else if(l==="scroll"){const h=typeof e=="object"&&(e==null?void 0:e.repeat)||xk;s.scrollable={[a.overflow]:"hidden-scroll",element:o,internalListeners:{scroll:"onContentScroll",thisObj:s}},u.overflowScrollStart={repeat:h,invertRotate:!0,cls:{[`b-${d}-start-scroller`]:1}},u.overflowScrollEnd={repeat:h,invertRotate:!0,cls:{[`b-${d}-end-scroller`]:1}}}s.tools=u,l?(o.classList.add("b-overflow"),s.monitorResize=!0,s.syncOverflowVisibility()):(o.classList.remove("b-overflow"),s.monitorResize=!1)}onContentScroll(){this.syncScrollerState()}onStartScrollClick(){this.scrollable[this.axisProps.pos]-=2}onEndScrollClick(){this.scrollable[this.axisProps.pos]+=2}onInternalResize(){super.onInternalResize(...arguments),this.isPainted&&this.syncOverflowVisibility()}syncOverflowVisibility(){const e=this,{overflowType:t,contentElement:r,isVisible:n}=e,{clientSizeProp:s,edgeProp:a,sizeProp:o}=e.axisProps,{overflowMenuButton:l,overflowScrollStart:d,overflowScrollEnd:c}=e.tools,u=e.rtl&&e.layout.horizontal,h=t==="menu",f=()=>Math.ceil(r[s]+(!d||d.hidden?0:d.rectangle("outer")[o])+(!c||c.hidden?0:c.rectangle("outer")[o])),g=()=>{if(_.length===0)return 0;const P=_[_.length-1].rectangle(r);return Math.floor(u?r[s]-P.left:P[a])};let m,p,y,b,C,D,S,x,R,M,I,_;if(!(!n||!t||e.items.length===0)){if(e.inSyncOverflowVisibility=!0,l==null||l.hide(),e.eachWidget((P,A)=>{S=P.minifiable,M=P.overflowable,M=S?M||S:M,P.floating?A.down=!1:(A.down=!M,P.innerItem&&(P._toolbarOverflow&&(P.hidden=P._toolbarOverflow=!1),P._toolbarMinified&&(P.minified=P._toolbarMinified=!1),P.isVisible&&(S&&(x||(x=[])).push(P),M&&(_||(_=[])).push(P))))}),_&&(m=f(),p=g()),_&&p>m)if(h){for(;p>m&&(C=x==null?void 0:x.pop());)D=p,C._toolbarMinified=!0,C.minified=!0,p=g(),D-=p,(R||(R=[])).push([C,D]);if(p>m){l.show(),m=f(),b=jI.getEvictionList(_);for(y of b)p>m&&(C=y[1],C._toolbarOverflowWidth=C.width,C._toolbarOverflow=!0,C.hidden=!0,_.splice(_.indexOf(C),1),(I||(I=[])).push(y),p=g());if(I){for(I.sort((P,A)=>P[0]-A[0]).forEach((P,A)=>I[A]=P[1]);R!=null&&R.length;)[C,D]=R.pop(),p+D<=m&&!C._toolbarOverflow&&(p+=D,C.minified=C._toolbarMinified=!1);e.syncOverflowMenuButton(I)}else l.hide()}}else c.show(),d.show(),e.syncScrollerState();else h||(c==null||c.hide(),d==null||d.hide());e.inSyncOverflowVisibility=!1}}syncOverflowMenuButton(e){var t;const r=this,{axisProps:n,overflowMenuButton:s}=r,a={cls:"b-toolbar-overflow-menu",minWidth:280,items:[],align:{align:n.horizontal?"t100-b100":"r100-l100",axisLock:"flexible"}};for(const o of e)r.overflowItemFilter(o)&&o.addToOverflowMenu(a,r.horizontal?Dk:L0,Ck);if(a.items.forEach(o=>{let l=o._overflowTwinOrigin,d=l.parent.indexOfChild(l);l.parent!==r&&(d=r.indexOfChild(l.parent)+d/1e5),o.weight=d}),(t=s._menu)!=null&&t.isMenu){const o=s.menu,{toAdd:l,toRemove:d}=H.delta(a.items,o.items,!0);o.remove(d),o.add(l)}else s.menu=a}syncScrollerState(){const e=this,{axisProps:t,scrollable:r}=e,{overflowScrollStart:n,overflowScrollEnd:s}=e.tools,a=r[t.pos],o=r[t.max];n.disabled=!a,s.disabled=Math.abs(Math.ceil(a))>=Math.abs(o)}overflowItemFilter(e){const{filter:t}=this.overflow;return!!(t?t.call(this,e):E.getChildElementCount(e.element))}onLeafItemConfigChange(e,{name:t,value:r}){const n=this,s=n.up(Sk),a=s.hasConfig("overflow"),{overflowTwin:o}=n;!a||s!=null&&s.inSyncOverflowVisibility||t==="hidden"&&r===n._toolbarOverflow||!wk[t]&&(n._width!=null&&!n.monitorResize||n._flex&&!String(n._flex).endsWith("auto"))||(o&&!Rk[t]&&(o[t]=r),s!=null&&s.isPainted&&n.ref!=="overflowMenuButton"&&((n.isTextField||n.isSlider||n.isCheckbox)&&t==="value"&&(n.containsFocus||o!=null&&o.containsFocus)||s.syncOverflowVisibility()))}createWidget(e){e==="->"?e={type:"widget",cls:"b-toolbar-fill"}:e==="|"?e={type:"widget",cls:"b-toolbar-separator"}:typeof e=="string"&&(e={type:"widget",cls:"b-toolbar-text",html:e});const t=super.createWidget(e);return this.widgetCls&&t.element.classList.add(this.widgetCls),t}};v(Qa,"$name","Toolbar"),v(Qa,"type","toolbar"),v(Qa,"delayable",{syncOverflowVisibility:{type:"raf",cancelOutstanding:!0}}),v(Qa,"configurable",{defaultType:"button",dock:"top",layout:{type:"box"},overflow:{$config:["lazy","nullify"],value:{type:"menu"}},toolDefaults:{overflowMenuButton:{type:"button",hidden:!0,icon:"b-icon-menu",menuIcon:null,ariaLabel:"Show overflowing items",defaultCls:{"b-overflow-button":1}},overflowScrollEnd:{handler:"up.onEndScrollClick",hidden:!0,defaultCls:{"b-icon-angle-right":1,"b-overflow-button":1,"b-icon":1}},overflowScrollStart:{align:"start",handler:"up.onStartScrollClick",hidden:!0,defaultCls:{"b-icon-angle-left":1,"b-overflow-button":1,"b-icon":1}}},widgetCls:null,ignoreParentReadOnly:!0}),v(Qa,"prototypeProperties",{flexRowCls:"b-hbox",flexColCls:"b-vbox"});var Ja=Qa;Ja.initClass(),Ja._$name="Toolbar";var Tk=i=>!i.classList.contains("b-focus-trap")&&!i.classList.contains("b-hidden")&&E.getFocusability(i).focusable?E.NodeFilter.FILTER_ACCEPT:E.NodeFilter.FILTER_SKIP,O0=[],Mk={},Nv=[O0,O0],$0=(i,e,t)=>{const{vertical:r}=i;return delete i.vertical,{...i,class:{...e,[`b-${r?"v":"h"}box`]:1,"b-box-center":1,"b-panel-bar-wrap":!t}}},Wv=(i,e,t=!1)=>{const r={vertical:t,children:i?[i]:[]};return e&&(r.tag=e),r},eg=(i,e)=>{i!=null&&i.classList?i==null||i.classList.add(e):i!=null&&i.class&&(typeof i.class=="string"&&(i.class={[i.class]:1}),i.class[e]=1)},Ik={dock:1,hidden:1,weight:1},Yi={top:[!0,!0],bottom:[!0,!1],left:[!1,!0],right:[!1,!1]},B0={header:1,"pre-header":1},Uv=class bp extends dt.mixin(_f,Vv){static get configurable(){return{localizableProperties:["title"],collapsed:{value:null,$config:null,default:!1},collapsible:{value:null,$config:"nullify"},bodyCls:{$config:{merge:"classList"},value:null},bodyTag:null,bodyWrapTag:null,trapFocus:null,title:null,header:null,stateful:["collapsed"],stripDefaults:{"*":{type:"toolbar",dock:"top"},bbar:{dock:"bottom",weight:-1e3},tbar:{weight:-1e3}},strips:{value:null,$config:"nullify"},toolDefaults:{close:{weight:-1e3},collapse:{weight:-990}},footer:null,revealed:null,tbar:null,bbar:null,role:"region"}}updateElement(e,t){const r=super.updateElement(e,t);return this.titleElement&&E.setAttributes(this.ariaElement,{"aria-describedby":this.titleElement.id}),r}get bodyWrapRootElement(){return this[this._bodyWrapRootName]}changeFooter(e){return e&&(e.dock==="start"?e.dock="left":e.dock==="end"&&(e.dock="right")),e}compose(){const e=this,{collapsible:t,focusable:r,hasItems:n,revealed:s,tools:a}=e,o=e.composeHeader(),l=e.getPositionableItems("after",!0),d=e.getPositionableItems("before",!0),c=(o==null?void 0:o.class["b-dock-left"])||(o==null?void 0:o.class["b-dock-right"]);let u=e.composeBody(),h="bodyWrapElement";return t&&([h,u]=t.wrapCollapser(h,u)),e._bodyWrapRootName=h,{tabIndex:n&&r!==!1||r?0:null,class:{[`b-panel-collapsible-${t==null?void 0:t.type}`]:t,[`b-panel-collapse-${t==null?void 0:t.collapseDir}`]:t,[`b-${c?"h":"v"}box`]:1,"b-panel-collapsible":t,"b-panel-has-header":o,"b-panel-has-tools":a?1:0,"b-panel-overlay-revealed":s},children:{topFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-top-focus-trap":1}},...d,headerElement:o,[h]:u,...l,bottomFocusTrap:{"aria-hidden":!0,tabIndex:0,class:{"b-focus-trap":1,"b-end-focus-trap":1}}}}}composeBody(){var e,t;const r=this,{bodyCls:n,bodyConfig:s,bodyWrapTag:a,footer:o,uiClassList:l}=r,d=T.values(r.strips,(C,D)=>!Yi[D==null?void 0:D.dock]).sort(r.byWeightSortFn),c={top:null,right:null,bottom:null,left:null};let u,h,f,g,m,p,y;for(o&&(f=o.dock||"bottom",d.unshift({dock:f,element:{tag:"footer",reference:"footerElement",html:typeof o=="string"?o:o.html,class:{...l,[`b-dock-${f}`]:1,[`${o.cls||""}`]:1}}})),n&&(s[m="className"]||(m="class"),s[m]=new se(s[m]).assign(n)),g=d.length;g-- >0;)u=d[g],[p,h]=Yi[u.dock],y?y.vertical!==p&&(y=Wv($0(y,l),"",p)):y=Wv(s,a,p),y.children[h?"unshift":"push"](u.element),c[u.dock]=u;eg(c.top,"b-innermost"),eg(c.right,"b-innermost"),eg(c.bottom,"b-innermost"),eg(c.left,"b-innermost");const b=$0(y||Wv(s,a),l,!0);return b.class[`${(e=r.layout)==null?void 0:e.containerCls}-panel`]=!!((t=r.layout)!=null&&t.containerCls),b.class["b-panel-body-wrap"]=1,b.class[`b-${r.$$name.toLowerCase()}-body-wrap`]=1,b}get hasHeader(){if(this.header===!1)return!1;const{header:e,title:t,tools:r,parent:n}=this,s=this.maximizable||Object.values(r||{}).some(a=>!a.hidden);return e||!(n!=null&&n.suppressChildHeaders)&&(t||s)}get rootUiClass(){return bp}composeHeader(e){var t;const r=this;if(!r.hasHeader&&!e)return;const n=r.header||{},s=n.dock||"top",[a,o]=r.splitHeaderItems({as:"element",dock:s}),l=r.$meta.hierarchy,d=r.composeTitle(n),c=new se({[`b-dock-${s}`]:1,...r.uiClassList},n.cls);let u,h;for(u=l.indexOf(bp);u<l.length;++u)h=l[u].$$name,h!=="Grid"&&(c[`b-${h.toLowerCase()}-header`]=1);const f={tag:"header",class:c,children:[...a,d,...o]};return((t=r.collapsible)==null?void 0:t.composeHeader(f))||f}composeTitle(e){var t;const r=typeof e=="string"?e:this.title||e.title,n={reference:"titleElement",id:`${this.id}-panel-title`,html:r!=null?r:"\xA0",class:{[`b-align-${e.titleAlign||"start"}`]:1,"b-header-title":1,...this.uiClassList}};return T.isObject(r)&&(delete n.html,T.merge(n,r)),((t=this.collapsible)==null?void 0:t.composeTitle(n))||n}updateTitle(){}afterRecompose(){var e;super.afterRecompose();const t=this,{headerElement:r}=t;(e=t._headerClickDetacher)==null||e.call(t),t._headerClickDetacher=r&&j.on({element:r,click:n=>{var s;return(s=t.trigger)==null?void 0:s.call(t,"panelHeaderClick",{event:n})}})}onPanelHeaderClick(e){var t;(t=this.collapsible)==null||t.onPanelHeaderClick(e)}onInternalPaint(){var e;super.onInternalPaint(...arguments),(e=this.collapsible)==null||e.onPanelPaint(this)}splitHeaderItems({as:e,dock:t,alt:r}=Mk){var n,s,a,o;const l=this,d=e==="element",{collapsed:c}=l,u=l.getEndTools({alt:r}),h=l.getStartTools({alt:r}),f=T.values(l.strips,(b,C)=>!B0[C==null?void 0:C.dock]&&C.isCollapsified({collapsed:c,alt:r}));let g=Nv,m,p,y;if(f.length+u.length+h.length){for(g=[p=[...h,...f.filter(b=>b.dock==="pre-header").sort(l.byWeightSortFn)],m=[...f.filter(b=>b.dock==="header").sort(l.byWeightReverseSortFn),...u]],y=0;y<p.length;++y)t&&((s=(n=p[y]).syncRotationToDock)==null||s.call(n,t)),d&&(p[y]=p[y].element);for(y=0;y<m.length;++y)t&&((o=(a=m[y]).syncRotationToDock)==null||o.call(a,t)),d&&(m[y]=m[y].element)}return g}set bodyConfig(e){this._bodyConfig=e}get bodyConfig(){const e=this,{bodyTag:t}=e,r=T.merge({reference:"bodyElement",className:{...e.getStaticWidgetClasses(bp,"-content"),"b-box-center":1,"b-text-content":e.textContent&&e.hasNoChildren}},e._bodyConfig);return t&&(r.tag=t),r}changeBodyCls(e){return se.from(e)}changeTbar(e){return this.getConfig("strips"),this.strips={tbar:e},this.strips.tbar}changeBbar(e){return this.getConfig("strips"),this.strips={bbar:e},this.strips.bbar}get childItems(){var e;const t=this,r=T.values(t.strips,(l,d)=>!Yi[d==null?void 0:d.dock]).sort(t.byWeightSortFn),[n,s]=t.splitHeaderItems(),[a,o]=((e=t.collapsible)==null?void 0:e.splitHeaderItems())||Nv;return[...n,...a,...s,...o,...r.filter(l=>Yi[l.dock][1]),...t.items,...r.filter(l=>!Yi[l.dock][1]).reverse()]}get childItemsOrderedByRelevance(){var e;const t=this,r=T.values(t.strips,(l,d)=>!Yi[d==null?void 0:d.dock]).sort(t.byWeightSortFn),[n,s]=t.splitHeaderItems(),[a,o]=((e=t.collapsible)==null?void 0:e.splitHeaderItems())||Nv;return[...t.items,...r.filter(l=>!Yi[l.dock][1]).reverse(),...n,...a,...s,...o,...r.filter(l=>Yi[l.dock][1])]}changeStrips(e,t){const r=this,n=r.$strips||(r.$strips=new ps({configName:"strips",factory:V,inferType:!1,owner:r,created(s){var a;const{dock:o}=s;if(!B0[o]&&!Yi[o])throw new Error(`Invalid dock value "${o}"; must be: top, left, right, bottom, header, or pre-header`);Se.after(s,"onConfigChange",(l,{name:d})=>{Ik[d]&&r.onConfigChange({name:"strips",value:n.target})}),s.innerItem=!1,r.onChildAdd(s),s.parent=r,(a=s.layout)==null||a.renderChildren(),s.hasItems&&(r.hasItems=!0)},setup(s,a){return s=T.merge(T.clone(r.stripDefaults["*"]),r.stripDefaults[a],s),s.parent=r,s.ref=a,s},transform(s){return Array.isArray(s)&&(s={items:s}),s||null}}));if(n.update(e),!t)return n.target}get collapsing(){var e;return(e=this.collapsible)==null?void 0:e.collapsing}get collapsingExpanding(){var e;return(e=this.collapsible)==null?void 0:e.collapsingExpanding}get expanding(){var e;return(e=this.collapsible)==null?void 0:e.expanding}changeCollapsed(e){const t=this,{collapsible:r}=t;if(t.recompose.flush(),e=!!e,!r||t.changingCollapse||!t.isPainted)return e;r==null||r.collapse({animation:null,collapsed:e})}changeCollapsible(e,t){const r=this;return r.getConfig("tools"),e&&(e===!0?e={}:typeof e=="string"&&(e={[Yi[e]?"direction":"type"]:e})),Rr.reconfigure(t,e,{owner:r,defaults:{panel:r},cleanup(){r.collapsed&&(t.collapse({animation:null,collapsed:!1}),r._collapsed=1)}})}updateCollapsible(e){const t=this,r=e==null?void 0:e.toolsConfig;t.tools={collapse:(r==null?void 0:r.collapse)||null,recollapse:(r==null?void 0:r.recollapse)||null},e&&t.isPainted&&t.collapsed&&(t._collapsed=1),t.collapsed===1&&(t.collapsed=!0)}_collapse(e,t){var r;return t!==!0&&t!==void 0&&(t===!1?e.collapsed=!e.collapsed:typeof t=="number"?e.animation={duration:t}:t===null?e.animation=t:t===!0||("animation"in t?T.merge(e,t):e.animation=t)),(r=this.collapsible)==null?void 0:r.collapse(e)}collapse(e){return this.collapsePanel(e)}expand(e){return this.expandPanel(e)}collapsePanel(e){return this._collapse({collapsed:!0},e)}expandPanel(e){return this._collapse({collapsed:!1},e)}toggleCollapsed(e){return this.collapsed?this.expand(e):this.collapse(e)}get expandedHeaderDock(){var e,t,r;return(r=(t=this._expandedHeaderDock)!=null?t:(e=this.initialConfig.header)==null?void 0:e.dock)!=null?r:"top"}set expandedHeaderDock(e){this._expandedHeaderDock=e==null?void 0:e.toLowerCase()}updateHeader(e){this.changingCollapse||(this.expandedHeaderDock=e==null?void 0:e.dock)}updateTrapFocus(e){var t;const r=this,{element:n}=r,{classList:s}=n,a=e==="before",o=e==="after";s.toggle("b-focus-trapped",e&&!a&&!o),s.toggle("b-focus-trapped-before",a),s.toggle("b-focus-trapped-after",o),r.focusTrapListener=(t=r.focusTrapListener)==null?void 0:t.call(r),e&&(r.focusTrapListener=j.on({element:n,focusin:"onFocusTrapped",delegate:".b-focus-trap",thisObj:r}),r.treeWalker||(r.treeWalker=r.setupTreeWalker(n,E.NodeFilter.SHOW_ELEMENT,Tk)))}setupTreeWalker(e,t,r){return document.createTreeWalker(e,t,r)}onFocusTrapped(e){const t=this,r=t.treeWalker,n=e.target===t.bottomFocusTrap,s=e.target===t.topFocusTrap;(s||n)&&t.trigger("focusTrap",{bottom:n,top:s})!==!1&&(n?(r.currentNode=t.topFocusTrap,r.nextNode()):(r.currentNode=t.bottomFocusTrap,r.previousNode()),t.requestAnimationFrame(()=>r.currentNode.focus()))}get focusElement(){return this.hasItems&&(super.focusElement||this.element)}get contentElement(){return this.element&&this.bodyElement}getPositionableLocation(e){let t,r;return e==="before"?r=this.headerElement||this.bodyWrapRootElement:e==="after"?r=this.bottomFocusTrap:t=this.contentElement,[t,r]}get widgetClassList(){var e;const t=this,r=super.widgetClassList;return t.hasHeader&&r.push("b-panel-has-header",`b-header-dock-${((e=t.header)==null?void 0:e.dock)||"top"}`),t.tbar&&r.push("b-panel-has-top-toolbar"),t.bbar&&r.push("b-panel-has-bottom-toolbar"),r}};v(Uv,"$name","Panel"),v(Uv,"type","panel");var ei=Uv;ei.initClass(),ei._$name="Panel";var Gv=class _a extends ei{static get configurable(){return{autoShow:!0,autoClose:!0,showOnClick:!1,forElement:null,monitorResize:!0,floating:!0,hidden:!0,axisLock:!0,hideAnimation:{opacity:{from:1,to:0,duration:".3s",delay:"0s"}},showAnimation:{opacity:{from:0,to:1,duration:".4s",delay:"0s"}},stripDefaults:{bbar:{layout:{justify:"flex-end"}}},testConfig:{hideAnimation:null,showAnimation:null},closeAction:"hide",trapFocus:!0,focusOnToFront:!0,closable:null,maximizable:null,modal:null,maximized:null,tools:{close:{cls:"b-popup-close",handler:"close",weight:-1e3,ariaLabel:"L{Popup.close}",hidden:!0},maximize:{cls:"b-popup-expand",handler:"toggleMaximized",weight:-999,hidden:!0}},highlightReturnedFocus:!0,role:"dialog"}}finalizeInit(){const e=this,{forElement:t}=e;e.anchoredTo=t,e.initialAnchor=e.anchor,t&&e.showOnClick!==!1&&(e.initialConfig.autoShow||(e.autoShow=!1),j.on({element:t,[e.showOnClick===2?"contextmenu":"click"]:"onElementUserAction",thisObj:e,capture:!0})),super.finalizeInit(),e.autoShow&&(!t||E.isVisible(t))&&(e.autoShow===!0?e.show():e.setTimeout(()=>e.show(),e.autoShow))}onInternalPaint({firstPaint:e}){var t;(t=super.onInternalPaint)==null||t.call(this,...arguments);const r=this;e&&r.headerElement&&j.on({element:r.headerElement,dblclick:r.onHeaderDblClick,thisObj:r})}doDestroy(){this.syncModalMask(),super.doDestroy()}compose(){const{hasNoChildren:e,textContent:t}=this;return{class:{"b-text-popup":!!(t&&e)}}}close(){if(!this._hidden){const e=this.trigger("beforeClose");if(T.isPromise(e))return e.then(t=>{t!==!1&&this.doClose()}),e;if(e===!1)return e}this.doClose()}doClose(){var e,t;const r=this,{closeAction:n}=r;if(!r._hidden||n==="destroy"){r.containsFocus&&r.highlightReturnedFocus&&r.setTimeout(()=>E.setFocusRendition(r.rootElement,!0),0),r.modal&&n==="destroy"&&r.revertFocus(),r.unmask();const s=r.items.length&&((e=r.items.find(a=>a.errorTip))==null?void 0:e.errorTip);return s&&((t=s.pointerOverOutDetacher)==null||t.call(s),s.hide()),r[n]()}}toggleMaximized(){this.maximized=!this.maximized}updateMaximized(e){E.toggleClasses(this.element,["b-maximized"],e)}onInternalKeyDown(e){const t=this;e.key==="Escape"&&(e.stopImmediatePropagation(),t.floating||t.positioned?t.close(!0):t.collapsible&&(t.revealed?t.collapsible.toggleReveal():t.collapse()))}onDocumentMouseDown({event:e}){const t=this,{owner:r}=t,{target:n}=e;if(t.isVisible){if(e.type!=="touchend"&&(r!=null&&r.isButton)&&r._menu===t&&r.element.contains(n))return e.preventDefault(),!1;if(t.modal&&n===_a.modalMask)e.preventDefault(),t.modal.closeOnMaskTap?t.close():t.containsFocus||t.focus();else if(!t.owns(n,!0)&&t.autoClose)if(t.containsFocus){const s=E.getActiveElement(t.element);j.on({element:document,once:!0,expires:100,[e.type]:a=>{a.defaultPrevented&&E.getActiveElement(t.element)===s&&t.close()}})}else t.close()}}get isTopModal(){return!this._isRevertingFocus&&E.isVisible(_a.modalMask)&&this.element.previousElementSibling===_a.modalMask}onFocusIn(e){const t=E.getActiveElement(this);super.onFocusIn(e),E.getActiveElement(this)===t&&e.target===this.element&&this.focus()}onFocusOut(e){!(globalThis.visualViewport&&globalThis.visualViewport.height<document.documentElement.clientHeight-1)&&!this.modal&&this.autoClose&&this.close(),super.onFocusOut(e)}afterShow(){const e=this;(e.autoClose||e.modal)&&e.addDocumentMouseDownListener(),super.afterShow(...arguments),e.toFront()}toFront(){this.floating&&(super.toFront(),this.syncModalMask()),this.focusOnToFront&&this.focus()}addDocumentMouseDownListener(){this.mouseDownRemover||(this.mouseDownRemover=ue.ion({globaltap:"onDocumentMouseDown",thisObj:this}))}updateModal(e){if(e){const t=this;t.floating=!0,typeof t._x!="number"&&typeof t._y!="number"&&(t.centered=!0,t.anchor=!1)}}syncModalMask(){const e=this,{modal:t,element:r}=e;if(r.setAttribute("aria-modal",!!t),t&&e.isVisible)e.modalMask.classList.remove("b-hide-display"),e.modalMask.classList.toggle("b-modal-transparent",!!t.transparent),r.classList.add("b-modal"),e.modalMask.setAttribute("owned-by",e.id);else if(e.isPainted){r.classList.remove("b-modal");const n=e.floatRoot.querySelectorAll(".b-modal"),s=n.length?_a.fromElement(n[n.length-1],"popup"):null;s?s.syncModalMask():_a.modalMask.classList.add("b-hide-display")}}afterHide(){var e;const t=this;super.afterHide(...arguments),(e=t.mouseDownRemover)==null||e.call(t),t.mouseDownRemover=null,t.syncModalMask()}onElementUserAction(e){const{showOnClick:t}=this;(typeof t!="number"||t===e.button)&&(e.button===2&&e.preventDefault(),this.show())}onHeaderDblClick(){this.maximizable&&this.toggleMaximized()}updateClosable(e){this.tools.close.hidden=!e}updateMaximizable(e){this.tools.maximize.hidden=!e}get modalMask(){const{modalMask:e}=_a;return e.nextElementSibling!==this.element&&this.floatRoot.insertBefore(e,this.element),e}static get modalMask(){return this._modalMask||(this._modalMask=E.createElement({className:"b-modal-mask b-hide-display"}),j.on({element:this._modalMask,wheel:e=>e.preventDefault()})),this._modalMask}};v(Gv,"$name","Popup"),v(Gv,"type","popup");var Mt=Gv;Mt.initClass(),Mt._$name="Popup";var _k=/^b-icon-/,Pk=/^b-fa-/,vs=class extends V{static get configurable(){return{checked:null,separator:null,toggleGroup:null,menu:{value:null,$config:["lazy","nullify"]},icon:null,text:null,closeParent:null,href:null,radio:null,target:null,localizableProperties:["text"],role:"menuitem",openMenuDelay:120}}updateElement(i,e){const t=super.updateElement(i,e);return typeof this.checked=="boolean"&&(this.role="menuitemcheckbox"),this.ariaHasPopup=this.hasMenu?"menu":!1,t}compose(){var i;const e=this,{checked:t,href:r,hasMenu:n,radio:s,separator:a,target:o,text:l}=e,d=typeof t=="boolean",c=e.icon||(d?"b-fw-icon":""),u=`b-icon-${s?"radio-":""}`,h=typeof l=="object";return{tag:r?"a":"div",tabIndex:-1,href:r,target:o,class:{"b-has-submenu":n,"b-checked":t,"b-separator":a||((i=e.cls)==null?void 0:i["b-separator"])},dataset:{group:e.toggleGroup},[d?"aria-checked":""]:t,[n?"aria-expanded":""]:!1,children:{iconElement:c&&{"aria-hidden":!0,tag:"i",class:{"b-fa":Pk.test(c),"b-icon":_k.test(c),"b-menuitem-icon":1,[`${u}checked`]:t===!0,[`${u}unchecked`]:t===!1,...se.normalize(c,"object")}},textElement:{tag:"span",[h?void 0:"text"]:h?void 0:l,class:{"b-menu-text":1,"b-menu-custom-content":h},children:h?[l]:null},subMenuIcon:n&&{"aria-hidden":!0,tag:"i",class:{"b-fw-icon":1,"b-icon-sub-menu":1}}}}}doAction(i){const e=this,t=this.parent,r={menu:t,item:e,element:e.element,bubbles:!0,domEvent:i};if(typeof e.checked=="boolean"){const n=!e.checked;(!e.toggleGroup||n)&&(e.checked=!e.checked)}else e.href&&i.key&&e.element.click();e.trigger("beforeItem",r),e.trigger("item",r),e.closeParent&&t&&(t.rootMenu.close(),i&&!e.href&&i.preventDefault())}get focusElement(){return this.element}get contentElement(){return this.textElement}get isFocusable(){const{focusElement:i}=this;return i&&this.isVisible&&(i===document.body||i.offsetParent)}get hasMenu(){return this.hasConfig("menu")}get childItems(){const{_menu:i}=this;return i?[i]:[]}get radio(){var i;return!!((i=this._radio)!=null?i:this.toggleGroup)}onFocusIn(i){const{menu:e}=this;super.onFocusIn(i),!this.disabled&&e&&(e.clearTimeout(e.closeTimer),this.delay("openMenu",e.closeTimer?0:this.openMenuDelay),e.closeTimer=null)}onFocusOut(i){var e;const t=this;t.clearTimeout("openMenu"),super.onFocusOut(i);const r=t._menu;r&&!((e=t.owner)!=null&&e.ignoreFocusOut)&&(E.usingKeyboard?t.closeMenu():(r.clearTimeout(r.closeTimer),r.closeTimer=r.setTimeout(()=>t.closeMenu(),r.closeMenuDelay)))}openMenu(i){const{menu:e,parent:t}=this;!this.disabled&&e&&(e.focusOnToFront=i,t.isMenu?t.openSubMenu(this.element,this):e.show())}onChildShow(i){super.onChildShow(i),this.ariaElement.setAttribute("aria-expanded",!0)}closeMenu(){this._menu.isWidget&&this.menu.close(),this.menu.closeTimer=null}onChildHide(i){super.onChildHide(i),this.ariaElement.setAttribute("aria-expanded",!1)}changeToggleGroup(i){return i&&typeof this.checked!="boolean"&&(this.checked=!1),i}changeChecked(i,e){if(this.isConfiguring||typeof e=="boolean")return!!i}updateChecked(i){const e=this;e.isConfiguring||(e.toggleGroup&&e.uncheckToggleGroupMembers(),e.element.setAttribute("aria-checked",i),e.trigger("toggle",{menu:e.owner,item:e,element:e.element,bubbles:!0,checked:i}))}getToggleGroupMembers(){const i=this,{checked:e,toggleGroup:t,element:r}=i,n=[];return e&&t&&E.forEachSelector(i.rootElement,`[data-group=${t}]`,s=>{if(s!==r){const a=V.fromElement(s);a&&n.push(a)}}),n}uncheckToggleGroupMembers(){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach(i=>i.checked=!1)}get closeParent(){return(typeof this.checked=="boolean"?this._closeParent:this._closeParent!==!1)&&!this.hasMenu}changeMenu(i,e){const t=this,{constrainTo:r,scrollAction:n,focusOnHover:s}=t.owner;return i&&typeof i=="object"&&!("items"in i)&&!("widgets"in i)&&!("html"in i)&&(i={lazyItems:i}),qi.reconfigure(e,i,{owner:t,defaults:{type:"menu",align:"s0-e0",anchor:!0,autoClose:!0,autoShow:!1,cls:{"b-sub-menu":1},forElement:t.element,owner:t,ariaLabel:t.text,focusOnHover:s,constrainTo:r,scrollAction:n}})}};v(vs,"$name","MenuItem"),v(vs,"type","menuitem"),vs.initClass(),vs._$name="MenuItem";var Ak={ArrowUp:1,ArrowDown:1,ArrowRight:1,ArrowLeft:1,Enter:1,Escape:1},qi=class extends Mt{construct(i){Array.isArray(i)&&(i={lazyItems:i}),super.construct(i),j.on({element:this.element,click:"onMouseClick",mouseover:"onMouseOver",mouseenter:"onMouseEnter",mouseleave:"onMouseLeave",thisObj:this})}afterShow(){const{items:i,element:e}=this;i.some(n=>n.hasConfig("menu"))&&e.classList.add("b-menu-with-submenu"),i.some(n=>n.icon)&&e.classList.add("b-menu-with-icon"),super.afterShow(...arguments)}createWidget(i){return typeof i=="string"&&(i={text:i}),super.createWidget(i)}get focusElement(){var i;const e=this,t=(i=e.parentMenu)==null?void 0:i.element.contains(E.getActiveElement(e.parentMenu)),r=e.items[0];return t||E.usingKeyboard||!(r instanceof vs)?super.focusElement:e.element}onDocumentMouseDown({event:i}){if(!this.parentMenu||!this.parentMenu.owns(i.target))return super.onDocumentMouseDown(...arguments)}hide(i){var e,t;const r=this;super.hide(i),r.isVisible||((t=(e=r.currentSubMenu)==null?void 0:e.hide)==null||t.call(e,i),r.parentMenu&&(r.parentMenu.currentSubMenu=null))}show(){const i=super.show(...arguments),{parentMenu:e}=this;return this.isVisible&&e&&(e.currentSubMenu=this),i}onMouseClick(i){const e=i.target.closest(".b-menuitem");e&&this.triggerElement(e,i)}onMouseOver(i){var e;if(this.focusOnHover!==!1){const t=(e=i.relatedTarget)==null?void 0:e.closest(".b-widget"),r=i.target.closest(".b-widget"),n=V.fromElement(r);!E.isTouchEvent&&r&&r!==t&&n.parent===this&&this.setTimeout({fn:"handleMouseOver",delay:30,args:[n],cancelOutstanding:!0})}}handleMouseOver(i){i.focus()}onMouseEnter(){this.clearTimeout(this.closeTimer);const{parentMenu:i}=this;i&&(i.ignoreFocusOut=!0,i.setTimeout(()=>i.ignoreFocusOut=!1,500),i.clearTimeout(i.hideSubMenuTimer))}onMouseLeave(i){const e=this,{relatedTarget:t}=i,r=t&&e.owns(t);let n=t instanceof HTMLElement&&V.fromElement(t),s=!r;if(n){for(;n.ownerCmp;)n=n.ownerCmp;s&=!E.getAncestor(n.element,[i.target])}!r&&s&&(e.currentSubMenu&&(e.hideSubMenuTimer=e.setTimeout(()=>{var a;return(a=e.currentSubMenu)==null?void 0:a.hide()},e.closeMenuDelay)),e.element.contains(E.getActiveElement(e))&&E.getActiveElement(e).matches(".b-menuitem")&&e.focusElement.focus())}onInternalKeyDown(i){const e=V.fromElement(i),t=e&&e!==this&&!(e instanceof vs);if(i.key==="Escape"){(t?this:this.rootMenu).close();return}if(super.onInternalKeyDown(i),t)return;Ak[i.key]&&i.preventDefault();const r=this.element,n=E.getActiveElement(r);this.navigateFrom(n!==r&&r.contains(n)?n:null,i.key,i)}navigateFrom(i,e,t){var r,n;const s=this,{treeWalker:a}=s,o=i&&s.getItem(i),l=s.rtl?"ArrowLeft":"ArrowRight",d=s.rtl?"ArrowRight":"ArrowLeft";let c;switch(e){case"ArrowUp":a.currentNode=i||(i=s.bottomFocusTrap),a.previousNode(),c=a.currentNode,(r=o==null?void 0:o.menu)==null||r.hide(!1);break;case"ArrowDown":a.currentNode=i||(i=s.topFocusTrap),a.nextNode(),c=a.currentNode,(n=o==null?void 0:o.menu)==null||n.hide(!1);break;case" ":i&&!i.classList.contains("b-disabled")&&(o!=null&&o.menu?s.openSubMenu(i,o):s.triggerElement(i,t));break;case l:if(i&&(o!=null&&o.menu)&&!i.classList.contains("b-disabled")){const u=s.openSubMenu(i,o);u==null||u.focus()}else a.currentNode=i||(i=s.topFocusTrap),a.nextNode(),c=a.currentNode;break;case d:s.isSubMenu?s.hide():i||(a.currentNode=i||(i=s.topFocusTrap),a.nextNode(),c=a.currentNode);break;case"Enter":i&&!i.classList.contains("b-disabled")&&s.triggerElement(i,t);break}c&&(c===s.element?s.navigateFrom(s.bottomFocusTrap,"ArrowUp",t):c===i?s.navigateFrom(s.topFocusTrap,"ArrowDown",t):c.focus())}getItem(i){if(i!=null)return typeof i=="number"?this.items[i]:i.nodeType===Element.ELEMENT_NODE?V.fromElement(i,"menuitem",this.contentElement):this.items.find(e=>e.id==i)}triggerElement(i,e){const t=this.getItem(i);t&&!t.disabled&&t.doAction(e)}get isSubMenu(){var i;return this===((i=this.owner)==null?void 0:i.menu)}openSubMenu(i,e){var t;const r=this,n=e.menu;if(n){if(!n.isVisible){const s={item:e,element:i};if(r.trigger("beforeSubMenu",s)===!1||((t=e.onBeforeSubMenu)==null?void 0:t.call(e,s))===!1)return;n.show(),n.isVisible&&!n.isMenu&&(r.currentSubMenu=n)}return n}}set selectedElement(i){const e=this,t=e._selectedElement;if(t){const r=e.getItem(t),n=r==null?void 0:r.menu;n==null||n.hide(),t.classList.remove("b-active")}if(e._selectedElement=i,i){const r=E.isFocusable(i);i.classList.add("b-active"),e.scrollable.scrollIntoView(i,{animate:!r,focus:r})}}get selectedElement(){return this._selectedElement}selectFirst(){const i=this.treeWalker;i.currentNode=this.topFocusTrap,i.nextNode(),this.requestAnimationFrame(()=>i.currentNode.focus())}get parentMenu(){var i;const e=this.owner;return e&&(e.isMenu?e:(i=e.up)==null?void 0:i.call(e,"menu"))}get rootMenu(){let i=this;for(;i.parentMenu instanceof this.constructor;)i=i.parentMenu;return i}};v(qi,"$name","Menu"),v(qi,"type","menu"),v(qi,"configurable",{layout:"vbox",focusable:!0,showAnimation:null,hideAnimation:{opacity:{from:1,to:0,duration:".15s",delay:"0s"}},align:{align:"t-b"},scrollAction:"hide",focusOnHover:null,scrollable:!1,defaultType:"menuitem",tools:{close:!1},role:"menu",ariaElement:"bodyElement",closeMenuDelay:200}),qi.initClass(),qi._$name="Menu";var tg,ys=class extends ee{static get configurable(){return{type:null,menu:{$config:["lazy","nullify"],value:{type:"menu",autoShow:!1,closeAction:"hide",constrainTo:globalThis,scrollAction:null}},items:{},triggerEvent:null,clickTriggerSelector:null,preventNativeMenu:null,keyMap:{" ":{handler:"showContextMenuByKey",weight:100},"Ctrl+Space":"showContextMenuByKey"}}}static get pluginConfig(){return{assign:["showContextMenu"],chain:["onElementContextMenu","onElementClick","onElementDblClick"]}}construct(...i){var e;if(super.construct(...i),!((e=this.type)!=null&&e.length))throw new Error("Config 'type' is required to be specified for context menu")}onElementContextMenu(i){this.onElementEvent(i)}onElementClick(i){this.onElementEvent(i)}onElementDblClick(i){this.onElementEvent(i)}onElementEvent(i){if(!i.handled&&this.triggerEvent===i.type){if(i.ctrlKey===!0&&!K.isMac){i.preventDefault();return}const e=i;if(tg){const{target:t}=tg;i=new MouseEvent(i.type,i),Object.defineProperties(i,{target:{value:t},offsetX:{value:e.offsetX},offsetY:{value:e.offsetY}}),i.preventDefault=function(){e.preventDefault(),e.handled=!0},i=j.fixEvent(i)}this.internalShowContextMenu(i)}else i.type==="click"&&this.clickTriggerSelector&&i.target.matches(this.clickTriggerSelector)&&this.internalShowContextMenu(i,{align:"l-r",target:i.target})}showContextMenuByKey(i){if(!E.isEditable(i.target)){const{target:e}=i;if(e)return tg=i,E.triggerMouseEvent(e,this.triggerEvent),i.handled=!0,i.preventDefault(),i.stopImmediatePropagation(),tg=null,!0}return!1}internalShowContextMenu(i,e){const t=this;let r;t.disabled||!i.handled&&!i.defaultPrevented&&(r=t.getDataFromEvent(i))&&t.shouldShowMenu(r)&&(i.type==="contextmenu"&&K.isSafari&&!i.ctrlKey&&i.metaKey&&j.on({element:i.target,capture:!0,once:!0,thisObj:this,click(n){n.preventDefault(),n.stopImmediatePropagation()}}),r.domEvent=i,t.showContextMenu(r,e))}getDataFromEvent(i){return{feature:this,event:i,targetElement:this.getTargetElementFromEvent(i)}}getTargetElementFromEvent(i){return i.target}async showContextMenu(i,e){var t,r;const n=this,s=E.isDOMEvent(i),a=s?n.getDataFromEvent(i):i,o=s?i:a.domEvent;if((t=n._menu)==null||t.hide(),n.disabled)return;n.menuContext=a;const{type:l,client:d,processItems:c}=n,u=E.isInView(a.targetElement).center;if(X.assign(a,{point:o!=null&&o.clientX?[o.clientX+1,o.clientY+1]:[u.x,u.y],menu:n,items:{},selection:d.selectedRecords}),n.callChainablePopulateMenuMethod(a),X.merge(a.items,n.baseItems),n.preventNativeMenu&&n.preventDefaultEvent(a),(!c||await n.callback(c,d,[a])!==!1)&&n.hasActiveMenuItems(a)&&(n.populateItemsWithData(a),n.beforeContextMenuShow(a)!==!1)){const{menu:h}=n,{featureItems:f}=h,{items:g}=a;n.preventDefaultEvent(a);let m=d.trigger(`${l}MenuBeforeShow`,a);if(T.isPromise(m)&&(o.handled=!0,m=await m),!Object.values(g).some(p=>p))return;m!==!1&&(f&&(h.remove(f),H.asArray(f).forEach(p=>p.destroy())),h.featureItems=h.add(...Array.isArray(g)?g:h.processItemsObject(g)),h.showBy(e||{target:a.domEvent,align:"s0-e100"}),(r=n.touchMoveDetacher)==null||r.call(n),n.touchMoveDetacher=j.on({element:d.element,touchmove:()=>h.hide(),thisObj:h,once:!0}),o&&(o.preventDefault(),o.handled=!0))}}get baseItems(){if(!this._baseItems){const i=this,{namedItems:e}=i,t=i._baseItems=X.assign({},i.items);for(const r in t){const n=t[r];n&&(e&&r in e?t[r]=typeof n=="object"?X.merge(X.clone(e[r]),n):e[r]:n===!0&&delete t[r])}}return this._baseItems}hideContextMenu(i){var e;(e=this.menu)==null||e.hide(i)}callChainablePopulateMenuMethod(i){var e,t;(t=(e=this.client)[`populate${O.capitalize(this.type)}Menu`])==null||t.call(e,i)}hasActiveMenuItems(i){return Object.values(i.items).some(e=>e&&!e.hidden)}shouldShowMenu(){return!0}beforeContextMenuShow(i){}populateItemsWithData(i){}preventDefaultEvent(i){var e;(e=i.event)==null||e.preventDefault()}get triggerEvent(){return this._triggerEvent||this.client.contextMenuTriggerEvent}changeMenu(i,e){const t=this,{client:r,type:n}=t;if(i)return qi.reconfigure(e,i?qi.mergeConfigs({owner:r,rootElement:r.rootElement,onItem(s){r.trigger(`${n}MenuItem`,s)},onToggle(s){r.trigger(`${n}MenuToggleItem`,s)},onDestroy(){t.menu=null},onBeforeItem(s){Object.assign(s,t.menuContext)},onShow({source:s}){t.menuContext.menu=s,r.trigger(`${n}MenuShow`,t.menuContext)}},i):null,t);e!=null&&e.isWidget&&e.destroy()}};v(ys,"$name","ContextMenuBase"),ys._$name="ContextMenuBase";var Fk=i=>{var e;return e=class extends(i||$){initContainerDrag(){const t=this;if(t.mode||(t.mode="container"),t.mode==="container"&&!t.containers)throw new Error("Container drag mode must specify containers")}grabContainerDrag(t){const r=this;if(!r.ignoreSelector||!t.target.closest(r.ignoreSelector)){const n=E.getAncestor(t.target,r.containers,r.outerElement);if(n){const s=n.getBoundingClientRect();r.context={element:n,valid:!0,action:"container",offsetX:t.pageX-s.left,offsetY:t.pageY-s.top,originalPosition:{parent:n.parentElement,prev:n.previousElementSibling,next:n.nextElementSibling}}}return!0}return!1}startContainerDrag(t){var r;const n=this,{context:s,floatRootOwner:a}=n,{element:o}=s,l=o.cloneNode(!0),d=a==null?void 0:a.element.closest(".b-outer");l.classList.add(n.dragProxyCls,n.draggingCls),((a==null?void 0:a.floatRoot)||E.getRootElement(o)).appendChild(l),s.dragProxy=l,s.dragging=o,o.classList.add(n.dropPlaceholderCls),(r=d==null?void 0:d.parentElement)!=null&&r.matches(".b-float-root")&&(l.style.zIndex=a.floatRootMaxZIndex+1)}onContainerDragStarted(t){const r=this,{context:n}=r,{element:s,dragProxy:a}=n,o=s.getBoundingClientRect();if(r.autoSizeClonedTarget)a.style.width=o.width+"px",a.style.height=o.height+"px",E.setTranslateXY(n.dragProxy,o.left,o.top);else if(r.useCenteredCursor){const l=a.getBoundingClientRect();Object.assign(n,{offsetX:l.width/2,offsetY:l.height/2}),E.setTranslateXY(a,t.clientX,t.clientY)}}updateContainerDrag(t){var r;const n=this,{context:s}=n;if(!s.started||!s.targetElement)return;const a=E.getAncestor(s.targetElement,n.containers,"b-gridbase"),o=(r=s.dragging)==null?void 0:r.contains(E.getActiveElement(s.dragging));a&&E.isDescendant(s.element,a)||(o&&ue.suspendFocusEvents(),a&&s.valid?n.moveNextTo(a,t):n.revertPosition(),o&&ue.resumeFocusEvents(),t.preventDefault())}finishContainerDrag(t){const r=this,{context:n}=r,{dragging:s,dragProxy:a,valid:o,draggedTo:l,insertBefore:d,originalPosition:c}=n;s&&(n.valid=!!(o&&(l||r.externalDropTargetSelector&&t.target.closest(r.externalDropTargetSelector))&&(s!==d||c.parent!==l)),n.finalize=(u=n.valid)=>{!u&&r.context&&r.revertPosition(),s.classList.remove(r.dropPlaceholderCls),a.remove(),r.reset()},n.async=!1,r.trigger("drop",{context:n,event:t}),n.async||n.finalize())}abortContainerDrag(t=!1,r=null,n=!1){const s=this,{context:a}=s;a.dragging&&(a.dragging.classList.remove(s.dropPlaceholderCls),a.dragProxy.remove(),s.revertPosition()),n||s.trigger(t?"drop":"abort",{context:a,event:r}),s.reset()}updateContainerProxy(t){var r;const n=this,{context:s}=n,a=s.dragProxy;let o=t.pageX-s.offsetX,l=t.pageY-s.offsetY;typeof n.minX=="number"&&(o=Math.max(n.minX,o)),typeof n.maxX=="number"&&(o=Math.min(n.maxX-a.offsetWidth,o)),typeof n.minY=="number"&&(l=Math.max(n.minY,l)),typeof n.maxY=="number"&&(l=Math.min(n.maxY-a.offsetHeight,l)),n.lockX?E.setTranslateY(a,l):n.lockY?E.setTranslateX(a,o):E.setTranslateXY(a,o,l);let d;if(t.type==="touchmove"){const c=t.changedTouches[0];d=E.elementFromPoint(c.clientX,c.clientY)}else d=t.target;s.targetElement=((r=this.resolveTargetElement)==null?void 0:r.call(this,d))||d}moveNextTo(t,r){const{context:n}=this,s=n.dragging,a=t.parentElement;if(t!==s){const o=k.from(t).center.x;this.isRTL&&r.pageX>o||!this.isRTL&&r.pageX<o?(a.insertBefore(s,t),n.insertBefore=t):t.nextElementSibling?t.nextElementSibling!==s?(n.insertBefore=t.nextElementSibling,a.insertBefore(s,t.nextElementSibling)):!n.insertBefore&&s.parentElement.lastElementChild!==s&&(n.insertBefore=t.nextElementSibling):(a.appendChild(s),n.insertBefore=null),n.draggedTo=a}}revertPosition(){const{context:t}=this,{dragging:r}=t,{parent:n,next:s}=t.originalPosition;s?s.previousSibling===r||!s&&r===n.lastChild||n.insertBefore(r,s):n.appendChild(r),t.draggedTo=null}},v(e,"$name","DragHelperContainer"),e},kk={pageXOffset:0,pageYOffset:0},Lk=i=>{var e;return e=class extends ve(i||$){static get configurable(){return{positioning:null,skipUpdatingElement:null}}initTranslateDrag(){const t=this;!t.isElementDraggable&&t.targetSelector&&(t.isElementDraggable=r=>r.closest(t.targetSelector))}grabTranslateDrag(t){const r=this.getTarget(t);return r?(this.context={valid:!0,element:r,startPageX:t.pageX,startPageY:t.pageY,startClientX:t.clientX,startClientY:t.clientY},!0):!1}getTarget(t){return t.target.closest(this.targetSelector)}getX(t){return this.positioning==="absolute"?parseFloat(t.style.left,10):this.positioning==="inset"?parseFloat(getComputedStyle(t).insetInlineStart,10):E.getTranslateX(t)}getY(t){return this.positioning==="absolute"?parseFloat(t.style.top,10):this.positioning==="inset"?parseFloat(getComputedStyle(t).insetBlockStart,10):E.getTranslateY(t)}getXY(t){if(this.positioning==="absolute")return[t.offsetLeft,t.offsetTop];if(this.positioning==="inset"){const r=getComputedStyle(t);return[parseFloat(r.insetInlineStart,10),parseFloat(r.insetBlockStart,10)]}return E.getTranslateXY(t)}setXY(t,r,n){this.skipUpdatingElement||(this.positioning==="absolute"?(t.style.left=r+"px",t.style.top=n+"px"):this.positioning==="inset"?(t.style.insetInlineStart=r+"px",t.style.insetBlockStart=n+"px"):E.setTranslateXY(t,r,n))}startTranslateDrag(t){const r=this,{context:n,outerElement:s,proxySelector:a}=r,o=r.dragWithin=r.dragWithin||r.cloneTarget&&document.body;let l=n.dragProxy||n.element;const d=l,c=l.parentElement;if(r.cloneTarget){const f=a?l.querySelector(a):l;let{width:g,height:m,x:p,y}=k.from(f,k.outer(o));r.isRTL&&l.style.insetInlineStart&&(p=k.outer(o).right-k.from(l).right),l=r.createProxy(l);let b=p,C=y;if(r.autoSizeClonedTarget&&(l.style.width=`${g}px`,l.style.height=`${m}px`),l.classList.add(r.dragProxyCls,r.draggingCls),l.classList.remove("b-hover","b-selected","b-focused"),o.appendChild(l),!r.autoSizeClonedTarget||a){const D=l.getBoundingClientRect(),{x:S,y:x}=o.getBoundingClientRect(),R=t.clientX-S,M=t.clientY-x+(o!==document.body?document.body.getBoundingClientRect().y:0);b=R-D.width/2,C=M-D.height/2,n.startPageX=t.pageX,n.startPageY=t.pageY}r.setXY(l,b,C),d.classList.add("b-drag-original"),r.hideOriginalElement&&d.classList.add("b-hidden")}l.classList.add(r.draggingCls);const u=r.getX(l),h=r.getY(l);Object.assign(n,{element:l,grabbed:d,grabbedParent:c,grabbedNextSibling:l.nextElementSibling,elementStartX:u,elementStartY:h,elementX:r.positioning==="inset"?u:E.getOffsetX(l,o||s),elementY:r.positioning==="inset"?h:E.getOffsetY(l,o||s),scrollX:0,scrollY:0,scrollManagerElementContainsDragProxy:!r.cloneTarget||o===s}),o&&(n.parentElement=l.parentElement,o!==l.parentElement&&o.appendChild(l),r.updateTranslateProxy(t))}onTranslateDragStarted(){const t=this,{context:r}=t;let{relatedElements:n}=r;if(t.unifiedProxy&&r.element.classList.add("b-drag-main","b-drag-unified-proxy"),(n==null?void 0:n.length)>0){r.relatedElStartPos=[],r.relatedElDragFromPos=[];const{proxySelector:s}=t;let[a,o]=[r.elementStartX,r.elementStartY];r.originalRelatedElements=n,n=r.relatedElements=n.map((l,d)=>{const c=s?l.querySelector(s):l,{x:u,y:h,width:f,height:g}=k.from(c,t.dragWithin),m=t.cloneTarget?t.createProxy(l):l;return m.classList.add(t.draggingCls),m.classList.remove("b-hover","b-selected","b-focused"),t.cloneTarget&&(t.setXY(m,u,h),t.dragWithin.appendChild(m),m.classList.add(t.dragProxyCls),t.autoSizeClonedTarget&&(m.style.width=`${f}px`,m.style.height=`${g}px`),t.hideOriginalElement&&l.classList.add("b-hidden"),l.classList.add("b-drag-original")),r.relatedElStartPos[d]=r.relatedElDragFromPos[d]=t.getXY(m),t.unifiedProxy&&(m.classList.add("b-drag-unified-animation","b-drag-unified-proxy"),a+=t.unifiedOffset,o+=t.unifiedOffset,t.setXY(m,a,o),r.relatedElDragFromPos[d]=[a,o],m.style.zIndex=100-d),m}),t.unifiedProxy&&n&&n.length>0&&j.onTransitionEnd({element:n[0],property:"transform",handler(){n.forEach(l=>l.classList.remove("b-drag-unified-animation"))},thisObj:t,once:!0})}}applyConstraints(t,r,n){const s=this,{constrain:a,dragWithin:o}=s,{pageXOffset:l,pageYOffset:d}=o===document.body?globalThis:kk;return o&&a&&(r<0&&(r=0),r+t.offsetWidth>o.scrollWidth&&(r=o.scrollWidth-t.offsetWidth),n<0&&(n=0),n+t.offsetHeight>o.scrollHeight&&(n=o.scrollHeight-t.offsetHeight)),typeof s.minX=="number"&&(r=Math.max(s.minX+l,r)),typeof s.maxX=="number"&&(r=Math.min(s.maxX+l,r)),typeof s.minY=="number"&&(n=Math.max(s.minY+d,n)),typeof s.maxY=="number"&&(n=Math.min(s.maxY+d,n)),{constrainedX:r,constrainedY:n}}updateTranslateProxy(t,r){const n=this,{lockX:s,lockY:a,context:o}=n,l=o.dragProxy||o.element,{relatedElements:d,relatedElDragFromPos:c}=o,u=n.isRTL&&n.positioning==="inset"?-1:1;o.scrollManagerElementContainsDragProxy&&r&&(o.scrollX=r.getRelativeLeftScroll(l),o.scrollY=r.getRelativeTopScroll(l)),o.pageX=t.pageX,o.pageY=t.pageY,o.clientX=t.clientX,o.clientY=t.clientY;let h=o.elementStartX+(t.pageX-o.startPageX+o.scrollX)*u,f=o.elementStartY+t.pageY-o.startPageY+o.scrollY;if(n.snapCoordinates){const p=n.snapCoordinates({element:l,newX:h,newY:f});h=p.x,f=p.y}const{constrainedX:g,constrainedY:m}=n.applyConstraints(l,h,f);if((o.started||g!==h||m!==f)&&n.setXY(l,s?void 0:g,a?void 0:m),d){const p=s?0:g-o.elementStartX,y=a?0:m-o.elementStartY;d.forEach((b,C)=>{const[D,S]=c[C];n.setXY(b,D+p,S+y)})}o.newX=g,o.newY=m}async finishTranslateDrag(t){const r=this,n=r.context,{target:s}=t,a=!r.lockX&&Math.round(n.newX)!==Math.round(n.elementStartX),o=!r.lockY&&Math.round(n.newY)!==Math.round(n.elementStartY),l=n.dragProxy||n.element,{relatedElements:d}=n;if(!r.ignoreSamePositionDrop||a||o)if(n.valid===!1)await r.abortTranslateDrag(!0,t);else{const c=!r.allowDropOutside&&k.from(r.dragWithin||r.outerElement);c&&(typeof r.minX!="number"&&r.minX!==!0&&t.pageX<c.left||typeof r.maxX!="number"&&r.maxX!==!0&&t.pageX>c.right||typeof r.minY!="number"&&r.minY!==!0&&t.pageY<c.top||typeof r.maxY!="number"&&r.maxY!==!0&&t.pageY>c.bottom)?await r.abortTranslateDrag(!0,t):(n.finalize=async(u=n.valid)=>{if(n.finalized){console.warn("DragHelper: Finalizing already finalized drag");return}n.finalized=!0,!u&&r.context&&await r.abortTranslateDrag(!0,null,!0),r.isDestroyed||(r.trigger("dropFinalized",{context:n,event:t,target:s}),r.reset()),!r.cloneTarget&&l.parentElement!==n.grabbedParent&&[l,...d||[]].forEach(h=>h.style.transform="")},n.async=!1,await r.trigger("drop",{context:n,event:t,target:s}),n.async||await n.finalize())}else r.abortTranslateDrag(!1,t)}async abortTranslateDrag(t=!1,r=null,n=!1){var s,a;const o=this,{cloneTarget:l,context:d,proxySelector:c,dragWithin:u,draggingCls:h}=o,{relatedElements:f,relatedElStartPos:g,grabbed:m}=d,p=d.dragProxy||d.element;if(d.valid=!1,(s=o.scrollManager)==null||s.stopMonitoring(),d.aborted){console.warn("DragHelper: Aborting already aborted drag");return}let{elementStartX:y,elementStartY:b}=d;const C=y!==o.getX(p)||b!==o.getY(p);if(p&&d.started){if(!l&&u&&u!==d.grabbedParent&&d.grabbedParent.insertBefore(p,d.grabbedNextSibling),l&&c){const D=m.querySelector(c)||m,{x:S,y:x}=k.from(D);y=S,b=x}if(p.classList.add("b-aborting"),o.setXY(p,y,b),f==null||f.forEach((D,S)=>{D.classList.remove(h),D.classList.add("b-aborting"),o.setXY(D,g[S][0],g[S][1])}),n||o.trigger(t?"drop":"abort",{context:d,event:r}),p.isConnected&&!o.isDestroying&&C){const D=o.positioning==="inset"?"inset":"transform";await j.waitForTransitionEnd({element:p,property:E.getPropertyTransitionDuration(p,D)?D:"all",thisObj:o,once:!0,timeout:300,runOnDestroy:!0})}o.isDestroyed||o.trigger("abortFinalized",{context:d,event:r})}(a=o.context)!=null&&a.started&&o.reset()}cleanUp(){const t=this,{context:r,cloneTarget:n,draggingCls:s,dragProxyCls:a}=t,o=r.dragProxy||r.element,{relatedElements:l,originalRelatedElements:d,grabbed:c}=r,u=n&&(t.removeProxyAfterDrop||!r.valid),h=[s,"b-aborting",a,"b-drag-main","b-drag-unified-proxy"];o.classList.remove(...h),u&&o.remove(),l==null||l.forEach(f=>{u?f.remove():f.classList.remove(...h)}),c.classList.remove("b-drag-original","b-hidden"),d==null||d.forEach(f=>f.classList.remove("b-hidden","b-drag-original"))}},v(e,"$name","DragHelperTranslate"),e},bs={move:"onMouseMove",up:"onMouseUp",docclick:"onDocumentClick",touchstart:"onTouchStart",touchmove:"onTouchMove",touchend:"onTouchEnd",keydown:"onKeyDown",keyup:"onKeyDownUp"},Cs=class extends $.mixin(Ve,Fk,Lk){static get defaultConfig(){return{dragProxyCls:"b-drag-proxy",invalidCls:"b-drag-invalid",draggingCls:"b-dragging",dropPlaceholderCls:"b-drop-placeholder",dragThreshold:5,outerElement:document.body,dragWithin:null,unifiedProxy:null,monitoringConfig:null,constrain:!0,minX:null,maxX:null,minY:null,maxY:null,mode:"translateXY",isElementDraggable:null,targetSelector:null,dropTargetSelector:null,dropTargetCls:null,proxySelector:null,cloneTarget:!1,autoSizeClonedTarget:!0,hideOriginalElement:!1,containers:null,ignoreSelector:null,startEvent:null,lockX:!1,lockY:!1,touchStartDelay:200,scrollManager:null,snapCoordinates:null,unifiedOffset:5,removeProxyAfterDrop:!0,clickSwallowDuration:50,ignoreSamePositionDrop:!0,allowDropOutside:null,floatRootOwner:null,mouseMoveListenerElement:document,externalDropTargetSelector:null,testConfig:{clickSwallowDuration:50,touchStartDelay:100},rtlSource:null,createProxy:null,resolveTargetElement:null,disabled:!1}}construct(i){const e=this;super.construct(i),e.initListeners(),e.isContainerDrag?e.initContainerDrag():e.initTranslateDrag(),e.onScrollManagerScrollCallback=e.onScrollManagerScrollCallback.bind(e)}doDestroy(){this.reset(!0),super.doDestroy()}initListeners(){const i=this,{outerElement:e}=i,t={element:e,pointerdown:"onPointerDown",thisObj:i};i.mouseMoveListenerElement=i.getMouseMoveListenerTarget(e),j.on(t)}getMouseMoveListenerTarget(i){const e=i.getRootNode();let t=this.mouseMoveListenerElement;return e.nodeType===Node.DOCUMENT_FRAGMENT_NODE&&e.mode==="closed"&&(t=i.closest(".b-outer")||t),t}get isRTL(){var i;return!!((i=this.rtlSource)!=null&&i.rtl)}onPointerDown(i){const e=this;if(i.button!==0||e.context||e.disabled||e.isElementDraggable&&!e.isElementDraggable(i.target,i))return;if(e.startEvent=i,e.isContainerDrag?e.grabContainerDrag(i):e.grabTranslateDrag(i)){const r=globalThis;e.blurDetacher=j.on({element:r,blur:e.onWindowBlur,thisObj:e});const n={element:e.mouseMoveListenerElement,thisObj:e,capture:!0,keydown:bs.keydown,keyup:bs.keyup};if(i.pointerType==="touch"?(e.touchStartTimer=e.setTimeout(()=>e.touchStartTimer=null,e.touchStartDelay,"touchStartDelay"),n.touchmove={handler:bs.touchmove,passive:!1},n.touchend=n.pointerup=bs.touchend):(n.pointermove=bs.move,n.pointerup=bs.up),e.dragListenersDetacher=j.on(n),e.dragWithin&&e.dragWithin!==e.outerElement&&e.outerElement.contains(e.dragWithin)){const s=k.from(e.dragWithin,e.outerElement);e.minY=s.top,e.maxY=s.bottom,e.minX=s.left,e.maxX=s.right}}}async internalMove(i){var e,t;if(i.scrollInitiated)return;const r=this,{context:n}=r,s=j.getDistanceBetween(r.startEvent,i);if(r.touchStartTimer&&s>r.dragThreshold){r.abort(!0);return}if(!r.touchStartTimer&&(n!=null&&n.element)&&(n.started||s>=r.dragThreshold)&&((e=i.target)==null?void 0:e.nodeType)===Node.ELEMENT_NODE){if(!n.started){const o=j.getXY(r.startEvent),l=j.getXY(i),d=Math.abs(o[0]-l[0])>=Math.abs(o[1]-l[1])?"horizontal":"vertical";if(!n.beforeDragStartFired&&r.trigger("beforeDragStart",{context:n,event:i,initialDirection:d})===!1)return r.abort();if(n.beforeDragStartFired=!0,Math.abs(j.getDistanceBetween(r.startEvent,i,{x:r.lockY,y:r.lockX}))<r.dragThreshold)return;r.isContainerDrag?r.startContainerDrag(i):r.startTranslateDrag(i),n.started=!0,(t=r.scrollManager)==null||t.startMonitoring(T.merge({scrollables:[{element:r.dragWithin||r.outerElement}],callback:r.onScrollManagerScrollCallback},r.monitoringConfig)),n.outermostEl=E.getOutermostElement(i.target),n.outermostEl.classList.add("b-draghelper-active"),r.dropTargetSelector&&r.dropTargetCls&&E.getRootElement(r.outerElement).querySelectorAll(r.dropTargetSelector).forEach(u=>u.classList.add(r.dropTargetCls));const c=r.trigger("dragStart",{context:n,event:i,initialDirection:d});T.isPromise(c)&&await c,r.onKeyDownUp(i),n.moveUnblocked=!0,r.isContainerDrag?r.onContainerDragStarted(i):r.onTranslateDragStarted(i),r.trigger("afterDragStart",{context:n,event:i,initialDirection:d})}n.moveUnblocked?r._cachedMouseEvent?(r.update(i),r.update(r._cachedMouseEvent),delete r._cachedMouseEvent):r.update(i):r._cachedMouseEvent=i}}onScrollManagerScrollCallback(i){var e;const{lastMouseMoveEvent:t}=this;(e=this.context)!=null&&e.element&&t&&(t.isScroll=!0,this.update(t,i))}onTouchMove(i){var e;((e=i.changedTouches)==null?void 0:e.length)===1&&(this.context&&!this.touchStartTimer&&i.preventDefault(),this.internalMove(i))}onMouseMove(i){this.internalMove(i)}update(i,e){const t=this,{context:r}=t;let n=t.getMouseMoveEventTarget(i);i.type==="touchmove"&&(n=j.getComposedPathTarget(i)),r.target=n;let s=t.allowDropOutside||!t.dragWithin||t.dragWithin.contains(i.target);s&&t.dropTargetSelector&&(s=s&&!!(n!=null&&n.closest(t.dropTargetSelector))),t.isContainerDrag?t.updateContainerProxy(i,e):t.updateTranslateProxy(i,e),r.valid=s,t.trigger("drag",{context:r,event:i}),t.isContainerDrag&&t.updateContainerDrag(i,e),r.valid=r.valid&&s;for(const a of t.draggedElements)a.classList.toggle(t.invalidCls,!r.valid);i&&(t.lastMouseMoveEvent=i)}get draggedElements(){var i;const{context:e}=this;return[e.dragProxy||e.element,...(i=e.relatedElements)!=null?i:[]]}async abort(i=!1){var e,t;const r=this,{context:n}=r;(t=(e=r.scrollManager)==null?void 0:e.stopMonitoring)==null||t.call(e),r.removeListeners(),n!=null&&n.started&&!n.aborted?(n.element.getBoundingClientRect(),n.valid=!1,r.isContainerDrag?r.abortContainerDrag(void 0,void 0,i):r.abortTranslateDrag(void 0,void 0,i),n.aborted=!0):r.reset(!0)}removeListeners(){var i,e;(i=this.dragListenersDetacher)==null||i.call(this),(e=this.blurDetacher)==null||e.call(this)}reset(i){const e=this,{context:t}=e;if(t!=null&&t.started){for(const r of e.draggedElements)r.classList.remove(e.invalidCls);t.outermostEl.classList.remove("b-draghelper-active"),e.isContainerDrag?t.dragProxy.remove():e.cleanUp(),e.dropTargetSelector&&e.dropTargetCls&&E.getRootElement(e.outerElement).querySelectorAll(e.dropTargetSelector).forEach(r=>r.classList.remove(e.dropTargetCls))}e.removeListeners(),i||e.trigger("reset"),e.context=e.lastMouseMoveEvent=null}onTouchEnd(i){E.getOutermostElement(i.target).classList.remove("b-no-touch-scroll"),this.onMouseUp(i)}onDocumentClick(i){i.stopPropagation()}onMouseUp(i){var e;const t=this,{context:r}=t;t.removeListeners(),r&&((e=t.scrollManager)==null||e.stopMonitoring(),r.started?r.moveUnblocked?(i.stopPropagation(),r.finalizing=!0,t.isContainerDrag?t.finishContainerDrag(i):t.finishTranslateDrag(i),j.on({element:document,thisObj:t,click:bs.docclick,capture:!0,expires:t.clickSwallowDuration,once:!0})):t.ion({drag(){t.onMouseUp(i)},once:!0}):t.reset(!0))}onKeyDown(i){var e;(e=this.context)!=null&&e.started&&i.key==="Escape"&&(i.stopImmediatePropagation(),this.abort()),this.onKeyDownUp(i)}onKeyDownUp(i){var e;(e=this.context)==null||e.element.classList.toggle("b-drag-copy",i[K.ctrlKey]||i[K.metaKey])}onWindowBlur(){this.context&&!this.context.finalizing&&this.abort()}createProxy(i){this.proxySelector&&(i=i.querySelector(this.proxySelector)||i);const e=i.cloneNode(!0);return e.removeAttribute("id"),e}get isContainerDrag(){return this.mode==="container"}async animateProxyTo(i,e={align:"c-c"}){const{context:t,draggedElements:r}=this,{element:n}=t,s=i.isRectangle?i:k.from(i);r.forEach(a=>{a.classList.add("b-drag-final-transition"),E.alignTo(a,s,e,void 0,void 0,this.positioning==="inset"?"topInset":"translate")}),await j.waitForTransitionEnd({element:n,property:"all",thisObj:this,once:!0}),r.forEach(a=>a.classList.remove("b-drag-final-transition"))}get isDragging(){var i;return!!((i=this.context)!=null&&i.started)}getMouseMoveEventTarget(i){return i.isScroll?E.elementFromPoint(i.clientX,i.clientY):i.target}};Cs._$name="DragHelper";var Tr={down:"onMouseDown",move:"onMouseMove",up:"onMouseUp",docclick:"onDocumentClick",touchstart:{handler:"onTouchStart",passive:!1},touchmove:"onTouchMove",touchend:"onTouchEnd",keydown:"onKeyDown"},Ss=class extends Ve($){static get defaultConfig(){return{resizingCls:"b-resizing",dragThreshold:5,handleSize:10,dynamicHandleSize:null,reservedSpace:10,touchHandleSize:30,minWidth:1,maxWidth:0,minHeight:1,maxHeight:0,outerElement:document.body,scroller:null,allowResize:null,dragWithin:null,isElementResizable:null,targetSelector:null,leftHandle:!0,rightHandle:!0,topHandle:!0,bottomHandle:!0,handleSelector:null,handleContainerSelector:null,startEvent:null,grab:null,invalidCls:"b-resize-invalid",handleVisibilityThreshold:null,skipTranslate:!1,direction:"horizontal",clickSwallowDuration:50,constrainToParent:!0,rtlSource:null}}construct(i){const e=this;super.construct(i),!e.handleSelector&&!K.isHoverableDevice&&(e.handleSize=e.touchHandleSize),e.handleVisibilityThreshold=e.handleVisibilityThreshold||2*e.handleSize,e.initListeners(),e.initResize()}doDestroy(){this.abort(!0),super.doDestroy()}updateSkipUpdatingElement(i){i&&(this.skipTranslate=!0)}getX(i){return this.positioning==="inset"?parseFloat(getComputedStyle(i).insetInlineStart,10):E.getTranslateX(i)}getY(i){return this.positioning==="inset"?parseFloat(getComputedStyle(i).insetBlockStart,10):E.getTranslateY(i)}setX(i,e){this.positioning==="inset"?i.style.insetInlineStart=e+"px":E.setTranslateX(i,e)}setY(i,e){this.positioning==="inset"?i.style.insetBlockStart=e+"px":E.setTranslateY(i,e)}initResize(){const i=this;if(!i.isElementResizable&&i.targetSelector&&(i.isElementResizable=e=>e.closest(i.targetSelector)),i.grab){const{edge:e,element:t,event:r}=i.grab;i.startEvent=r;const n=i.getX(t)||t.offsetLeft,s=i.getY(t)||t.offsetTop;i.context={element:t,edge:e,valid:!0,async:!1,elementStartX:n,elementStartY:s,newX:n,newY:s,elementWidth:t.offsetWidth,elementHeight:t.offsetHeight,startX:r.clientX+i.scrollLeft,startY:r.clientY+i.scrollTop,finalize:()=>{var a;return(a=i.reset)==null?void 0:a.call(i)}},t.classList.add(i.resizingCls),i.internalStartResize(i.isTouch)}}initListeners(){const i=this,e={element:i.outerElement,mousedown:Tr.down,touchstart:Tr.touchstart,thisObj:i};!i.handleSelector&&K.isHoverableDevice&&(e.mousemove={handler:Tr.move,delegate:i.targetSelector},e.mouseleave={handler:"onMouseLeaveTarget",delegate:i.targetSelector,capture:!0}),j.on(e)}get isRTL(){var i;return!!((i=this.rtlSource)!=null&&i.rtl)}get scrollLeft(){return this.scroller?this.scroller.x:this.outerElement.scrollLeft}get scrollTop(){return this.scroller?this.scroller.y:this.outerElement.scrollTop}internalStartResize(i){var e;const t={element:document,keydown:Tr.keydown,thisObj:this};i?(t.touchmove=Tr.touchmove,t.touchend=t.pointerup=Tr.touchend):(t.mousemove=Tr.move,t.mouseup=Tr.up),this.removeDragListeners=j.on(t),(e=this.onResizeHandlePointerDown)==null||e.call(this,this.startEvent)}removeDragListeners(){}reset(){var i;(i=this.removeDragListeners)==null||i.call(this),this.context=null,this.trigger("reset")}canResize(i,e){return!this.isElementResizable||this.isElementResizable(i,e)}onPointerDown(i,e){const t=this;t.startEvent=e,t.canResize(e.target,e)&&t.grabResizeHandle(i,e)&&(e.stopImmediatePropagation(),e.type==="touchstart"&&e.preventDefault(),t.internalStartResize(i))}onTouchStart(i){i.touches.length>1||this.onPointerDown(!0,i)}onMouseDown(i){i.button===0&&this.onPointerDown(!1,i)}internalMove(i,e){var t;const r=this,{context:n,direction:s}=r;n!=null&&n.element&&(n.started||j.getDistanceBetween(r.startEvent,e)>=r.dragThreshold)?(n.started||((t=r.scrollManager)==null||t.startMonitoring(T.merge({scrollables:[{element:r.dragWithin||r.outerElement,direction:s}],callback:a=>{var o;return((o=r.context)==null?void 0:o.element)&&r.lastMouseMoveEvent&&r.update(r.lastMouseMoveEvent,a)}},r.monitoringConfig)),r.trigger("resizeStart",{context:n,event:e}),n.started=!0),r.update(e)):!i&&!r.handleSelector&&r.checkResizeHandles(e)}onTouchMove(i){this.internalMove(!0,i)}onMouseMove(i){this.internalMove(!1,i)}onPointerUp(i,e){var t,r,n;const s=this,a=s.context;(t=s.removeDragListeners)==null||t.call(s),a?((r=s.scrollManager)==null||r.stopMonitoring(),a.started&&j.on({element:E.getRootElement(e.target),thisObj:s,click:Tr.docclick,expires:s.clickSwallowDuration,capture:!0,once:!0}),s.finishResize(e)):(n=s.reset)==null||n.call(s)}onTouchEnd(i){this.onPointerUp(!0,i)}onMouseUp(i){this.onPointerUp(!1,i)}onDocumentClick(i){i.stopPropagation()}onKeyDown(i){i.key==="Escape"&&this.abort()}update(i){const e=this,{context:t,constrainToParent:r}=e,{element:n}=t;if(r){const s=k.from(e.outerElement);t.currentX=Math.max(Math.min(i.clientX,s.right),s.x)+e.scrollLeft,t.currentY=Math.max(Math.min(i.clientY,s.bottom),s.y)+e.scrollTop}else t.currentX=i.clientX+e.scrollLeft,t.currentY=i.clientY+e.scrollTop;n.classList.add(e.resizingCls),e.updateResize(i)&&(e.trigger("resizing",{context:t,event:i}),n.classList.toggle(e.invalidCls,t.valid===!1)),e.lastMouseMoveEvent=i}abort(i=!1){var e,t;const r=this;(t=(e=r.scrollManager)==null?void 0:e.stopMonitoring)==null||t.call(e),r.context?r.abortResize(null,i):r.isDestroyed||r.reset()}grabResizeHandle(i,e){var t;const r=this;if(r.allowResize&&!r.allowResize(e.target,e))return!1;const n=r.handleSelector,s=e.type==="touchstart"?e.changedTouches[0]:e,a=s.clientX,o=s.clientY;let l=r.targetSelector?e.target.closest(r.targetSelector):e.target;if(l){let d;if(n)if(e.target.matches(n))r.direction==="horizontal"?e.pageX<E.getPageX(l)+l.offsetWidth/2?d=r.isRTL?"right":"left":d=r.isRTL?"left":"right":e.pageY<E.getPageY(l)+l.offsetHeight/2?d="top":d="bottom";else return!1;else if(r.direction==="horizontal"?r.overLeftHandle(e,l)?d=r.isRTL?"right":"left":r.overRightHandle(e,l)&&(d=r.isRTL?"left":"right"):r.overTopHandle(e,l)?d="top":r.overBottomHandle(e,l)&&(d="bottom"),!d)return r.context=null,!1;e.type==="touchstart"&&e.preventDefault();const c=(t=r.internalBeforeStart)==null?void 0:t.call(r,{element:l,edge:d});if(c&&(l=c.element,d=c.edge),r.trigger("beforeResizeStart",{element:l,event:e})!==!1){const u=r.getX(l)||l.offsetLeft,h=r.getY(l)||l.offsetTop;return r.context={element:l,edge:d,isTouch:i,valid:!0,async:!1,direction:r.direction,elementStartX:u,elementStartY:h,newX:u,newY:h,elementWidth:l.offsetWidth,elementHeight:l.offsetHeight,startX:a+r.scrollLeft,startY:o+r.scrollTop,finalize:()=>{var f;return(f=r.reset)==null?void 0:f.call(r)}},l.classList.add(r.resizingCls),!0}}return!1}checkResizeHandles(i){const e=this,t=e.targetSelector?i.target.closest(e.targetSelector):i.target;let r=!1;return t&&(!e.allowResize||e.allowResize(i.target,i))?(e.currentElement=e.handleContainerSelector?i.target.closest(e.handleContainerSelector):i.target,e.currentElement&&(e.direction==="horizontal"?r=e.overLeftHandle(i,t)||e.overRightHandle(i,t):r=e.overTopHandle(i,t)||e.overBottomHandle(i,t),r?e.highlightHandle():e.unHighlightHandle())):e.currentElement&&e.unHighlightHandle(),r}onMouseLeaveTarget(i){const e=this;e.currentElement=e.handleContainerSelector?i.target.closest(e.handleContainerSelector):i.target,e.currentElement&&e.unHighlightHandle()}updateResize(i){const e=this,{context:t,allowEdgeSwitch:r,skipTranslate:n,skipUpdatingElement:s}=e;let a;r&&(e.direction==="horizontal"?t.edge=t.currentX>t.startX?"right":"left":t.edge=t.currentY>t.startY?"bottom":"top");const{element:o,elementStartX:l,elementStartY:d,elementWidth:c,elementHeight:u,edge:h}=t,{style:f}=o,g=(t.currentX-t.startX)*(e.positioning==="inset"&&e.isRTL?-1:1),m=t.currentY-t.startY,p=E.getExtremalSizePX(o,"minWidth")||e.minWidth,y=E.getExtremalSizePX(o,"maxWidth")||e.maxWidth,b=E.getExtremalSizePX(o,"minHeight")||e.minHeight,C=E.getExtremalSizePX(o,"maxHeight")||e.maxHeight,D=h==="right"&&(!e.isRTL||e.positioning==="inset")||h==="bottom"?1:-1,S=c+g*D,x=u+m*D;let R=Math.max(p,S),M=Math.max(b,x);if(y>0&&(R=Math.min(R,y)),C>0&&(M=Math.min(M,C)),e.direction==="horizontal"&&c!==R){if(s||(f.flex="",f.width=Math.abs(R)+"px"),t.newWidth=R,h==="left"||R<0){const I=Math.max(Math.min(l+c-e.minWidth,l+g),0);n||e.setX(o,Math.round(I)),t.newX=I}else h==="right"&&r&&!n&&e.setX(o,l);a=!0}else e.direction==="vertical"&&u!==x&&(s||(f.flex="",f.height=Math.abs(M)+"px"),t.newHeight=M,h==="top"||M<0?(t.newY=Math.max(Math.min(d+u-e.minHeight,d+m),0),n||e.setY(o,t.newY)):h==="bottom"&&r&&!n&&e.setY(o,d),a=!0);return a}finishResize(i){var e;const t=this,r=t.context,n={context:r,event:i};if(r.element.classList.remove(t.resizingCls),r.started){let s=!1;t.direction==="horizontal"?s=r.newWidth&&r.newWidth!==r.elementWidth:s=r.newHeight&&r.newHeight!==r.elementHeight,t.trigger(s?"resize":"cancel",n),r.async||r.finalize()}else(e=t.reset)==null||e.call(t)}abortResize(i=null,e=!1){const t=this,r=t.context;r.element.classList.remove(t.resizingCls),t.direction==="horizontal"?((r.edge==="left"||r.allowEdgeSwitch&&!r.skipTranslate)&&t.setX(r.element,r.elementStartX),r.element.style.width=r.elementWidth+"px"):(t.setY(r.element,r.elementStartY),r.element.style.height=r.elementHeight+"px"),!e&&t.trigger("cancel",{context:r,event:i}),t.isDestroyed||t.reset()}highlightHandle(){const i=this,e=i.targetSelector?i.currentElement.closest(i.targetSelector):i.currentElement;i.currentElement.classList.add("b-resize-handle"),e.classList.add("b-over-resize-handle")}unHighlightHandle(){const i=this,e=i.targetSelector?i.currentElement.closest(i.targetSelector):i.currentElement;e&&e.classList.remove("b-over-resize-handle"),i.currentElement.classList.remove("b-resize-handle"),i.currentElement=null}overAnyHandle(i,e){return this.overStartHandle(i,e)||this.overEndHandle(i,e)}overStartHandle(i,e){return this.direction==="horizontal"?this.overLeftHandle(i,e):this.overTopHandle(i,e)}overEndHandle(i,e){return this.direction==="horizontal"?this.overRightHandle(i,e):this.overBottomHandle(i,e)}getDynamicHandleSize(i,e){const t=i?2:1,{handleSize:r}=this;return this.dynamicHandleSize&&r*t>e-this.reservedSpace?Math.max(Math.floor((e-this.reservedSpace)/t),0):r}overLeftHandle(i,e){const t=this,{offsetWidth:r}=e;if(t.leftHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=k.from(e);return n.width=t.getDynamicHandleSize(t.rightHandle,r),n.width>0&&n.contains(j.getPagePoint(i))}return!1}overRightHandle(i,e){const t=this,{offsetWidth:r}=e;if(t.rightHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=k.from(e);return n.x=n.right-t.getDynamicHandleSize(t.leftHandle,r),n.width>0&&n.contains(j.getPagePoint(i))}return!1}overTopHandle(i,e){const t=this,{offsetHeight:r}=e;if(t.topHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=k.from(e);return n.height=t.getDynamicHandleSize(t.bottomHandle,r),n.height>0&&n.contains(j.getPagePoint(i))}return!1}overBottomHandle(i,e){const t=this,{offsetHeight:r}=e;if(t.bottomHandle&&t.canResize(e,i)&&(r>=t.handleVisibilityThreshold||t.dynamicHandleSize)){const n=k.from(e);return n.y=n.bottom-t.getDynamicHandleSize(t.bottomHandle,r),n.height>0&&n.contains(j.getPagePoint(i))}return!1}};v(Ss,"configurable",{skipUpdatingElement:null}),Ss._$name="ResizeHelper";var H0=/>[ \t\r\n]+</g,Ok=/\s\s+/g,mi=class VI{static tpl(e,...t){let r=0,n=t.map((s,a)=>{let o=e[a];return Array.isArray(s)?o+=s.reduce((l,d)=>l+=(typeof d=="string"?d.trim():d)+`
`,""):(s===void 0&&(s=""),o+=typeof s=="string"?s.trim():s),r++,o}).join("");return r<=e.length&&(n+=e[e.length-1]),n.replace(H0,"><").replace(Ok," ").trim()}static docsTpl(e,...t){let r=0,n=t.map((s,a)=>{let o=e[a];return Array.isArray(s)?o+=s.reduce((l,d)=>l+=(typeof d=="string"?d.trim():d)+`
`,""):(s===void 0&&(s=""),o+=typeof s=="string"?s.trim():s),r++,o}).join("");return r<=e.length&&(n+=e[e.length-1]),n.replace(H0,"><").trim()}static repeat(e){return function(...t){return VI.tpl(...t).repeat(e)}}static loop(e){}};mi._$name="TemplateHelper";var $k=class extends Array{constructor(i,e){super(),this.timeZone=i,this.year=e}},Bk=class{constructor(i,e){this.asString=i,this.timeZone=e,this.asArray=jk(i)}get asLocalDate(){return this._asLocalDate||(this._asLocalDate=new Date(...this.asArray)),this._asLocalDate}get asTicksUtc(){return this._asTicksUtc||(this._asTicksUtc=new Date(Date.UTC(...this.asArray)).getTime()),this._asTicksUtc}},j0=(i,e)=>{const t=i.toLocaleString("sv-SE",{timeZone:e});return new Bk(t,e)},Hk=(i,e)=>{const{asTicksUtc:t,asString:r}=j0(new Date(i),e);return{offset:(i-t)/6e4,tzTicksUtc:t,tzString:r}},jk=i=>{const e=i.split(/[\s-:]/).map(t=>t*1);return e[1]-=1,e},Vk=-6e4,zk=36e5,V0=-864e5,hc=2592e6,z0=(i,e)=>{const t=N0.get(i,e);if(t)return t;const r=new $k(i,e),n=new Date(Date.UTC(e,0,1)).getTime();let s=n,a=hc,o=0,l=[],d=null,c,u,h,f;for(;!f;)({offset:h,tzTicksUtc:c,tzString:u}=Hk(s,i)),d==null?(d=h,r.push({offset:h})):a>0&&h!==d?a=a===hc?V0:Vk:a<0&&h===d&&(a===V0?a=zk:(r.length===1?(r.push(l),d=l.offset):(r[0].startTicks=l.startTicks,r[0].startDateString=l.startDateString,f=!0),a=hc)),l={offset:h,startDateString:u,startTicks:c},a===hc&&(s=n,s+=o*hc,o+=1),s+=a,o>11&&(f=!0);return N0.set(r),r},N0={_cache:{},get(i,e){var t;return(t=this._cache[i])==null?void 0:t[e]},set(i){const{timeZone:e}=i,{_cache:t}=this;t[e]||(t[e]={}),t[e][i.year]=i}},Ze=class{static toTimeZone(i,e){if(typeof e=="number")return this.toUtcOffset(i,e);const t=j0(i,e);return t.asArray[3]!==t.asLocalDate.getHours()&&console.warn("Incorrect time zone conversion due to local DST-switch detected"),t.asLocalDate}static fromTimeZone(i,e){if(typeof e=="number")return this.fromUtcOffset(i,e);const t=this.dateAsArray(i),r=z0(e,i.getUTCFullYear());let n=r[0].offset;if(r.length===2){const s=Date.UTC(...t);s>=r[1].startTicks&&s<r[0].startTicks&&(n=r[1].offset)}return t[4]+=n,new Date(Date.UTC(...t))}static toUtcOffset(i,e){const t=i.getTimezoneOffset()+e;return new Date(i.getTime()+t*60*1e3)}static fromUtcOffset(i,e){const t=-i.getTimezoneOffset()-e;return new Date(i.getTime()+t*60*1e3)}static dateAsArray(i){return[i.getFullYear(),i.getMonth(),i.getDate(),i.getHours(),i.getMinutes(),i.getSeconds(),i.getMilliseconds()]}};v(Ze,"$name","TimeZoneHelper"),Ze.findOffsetDates=z0,Pe.register(Ze),Ze._$name="TimeZoneHelper";var ig=class Pd extends V{static get configurable(){return{testConfig:{destroyTimeout:1,timeout:1e3},floating:!0,timeout:2500,autoDestroy:null,destroyTimeout:200,showProgress:!0,color:null,sideMargin:20,side:"bottom",role:"alert"}}changeSide(e){return e=="top"||e=="bottom"?e+="-end":(e==="start"||e=="end")&&(e="bottom-"+e),e}compose(){const{appendTo:e,color:t,html:r,showProgress:n,style:s,timeout:a,side:o}=this;return{parent:e||this.floatRoot,class:{...se.normalize(t,"object"),[`b-side-${o}`]:1,"b-toast-hide":1},html:r,style:{...E.parseStyle(s),"--side":o.split("-")[0]},children:{progressElement:n&&{style:`animation-duration:${a/1e3}s;`,class:{"b-toast-progress":1}}},listeners:{click:"hide"}}}doDestroy(){this.untoast(),super.doDestroy()}getNextInset(e){const{sideMargin:t,element:r}=this;return parseInt(r.style[e],10)+r.offsetHeight+t}async show(){var e,t;await super.show(...arguments);const r=this,{element:n,side:s}=r,a=Pd.toasts[s],o=s.split("-")[0];a.includes(r)||(n.style[o]=((t=(e=a[0])==null?void 0:e.getNextInset(o))!=null?t:r.sideMargin)+"px",a.unshift(r),n.getBoundingClientRect(),n.classList.remove("b-toast-hide"),r.timeout>0&&(r.hideTimeout=r.setTimeout("hide",r.timeout)),E.addAttributeValue(document.body,"aria-describedby",r.id))}async hide(){const e=this;e.untoast(),e.element.classList.add("b-toast-hide"),e.autoDestroy&&!e.destroyTimer&&(e.destroyTimer=e.setTimeout("destroy",e.destroyTimeout))}untoast(){const e=Pd.toasts[this.side];e.includes(this)&&e.splice(e.indexOf(this),1),E.removeAttributeValue(document.body,"aria-describedby",this.id)}static hideAll(){Object.keys(Pd.toasts).forEach(e=>Pd.toasts[e].slice().reverse().forEach(t=>t.hide()))}static show(e){const t=Pd.new({autoDestroy:!0,rootElement:document.body},typeof e=="string"?{html:e}:e);return t.show(),t}};v(ig,"$name","Toast"),v(ig,"type","toast"),v(ig,"toasts",{"top-start":[],"top-end":[],"bottom-start":[],"bottom-end":[]});var Ki=ig;Ki.initClass(),Ki._$name="Toast";var W0=class{static getById(i){return de.deprecate("core","7.0.0","Use Widget.getById instead"),V.getById(i)}static fromElement(i,e,t){return de.deprecate("core","7.0.0","Use Widget.fromElement instead"),V.fromElement(i,e,t)}static createWidget(i={}){return de.deprecate("core","7.0.0","Use Widget.create instead"),i.isWidget?i:V.create(i)}static append(i,e){if(de.deprecate("core","7.0.0","Use a Container instead"),i=Array.isArray(i)&&i||[i],(e instanceof HTMLElement||typeof e=="string")&&(e={appendTo:e}),e.insertFirst){const t=typeof e.insertFirst=="string"?document.getElementById(e.insertFirst):e.insertFirst;t.firstChild?e.insertBefore=t.firstChild:e.appendTo=t}return i.map(t=>V.create(T.assign({},e||{},t)))}static openPopup(i,e){return de.deprecate("core","7.0.0","Use Popup directly instead"),V.create(T.assign({forElement:i},typeof e=="string"?{html:e}:e),"popup")}static showContextMenu(i,e){de.deprecate("core","7.0.0","Use Menu directly instead");const t=this;return t.currentContextMenu&&t.currentContextMenu.destroy(),i instanceof HTMLElement?e.forElement=i:(e.forElement=document.body,Array.isArray(i)&&(i=new xi(...i)),i instanceof xi&&(e.align={position:i})),e.internalListeners={destroy:t.currentContextMenu=null},t.currentContextMenu=V.create(e,"menu")}static attachTooltip(i,e){return de.deprecate("core","7.0.0","Use Tooltip directly instead"),V.attachTooltip(i,e)}static hasTooltipAttached(i){return de.deprecate("core","7.0.0","Will be removed"),V.resolveType("tooltip").hasTooltipAttached(i)}static destroyTooltipAttached(i){return de.deprecate("core","7.0.0","Will be removed"),V.resolveType("tooltip").destroyTooltipAttached(i)}static mask(i,e="Loading"){if(de.deprecate("core","7.0.0","Use Mask directly instead"),i)return i instanceof HTMLElement&&(i={target:i,text:e}),gs.mask(i,i.target)}static unmask(i,e=!0){de.deprecate("core","7.0.0","Use Mask directly instead"),i.mask&&(e?i.mask.close():i.mask.hide())}static toast(i){return de.deprecate("core","7.0.0","Use Toast directly instead"),Ki.show(i)}};W0._$name="WidgetHelper";var U0=class{static convertFromObject(i,e={}){X.assignIf(e,{rootName:"root",elementName:"element",includeHeader:!0,rootElementForArray:!0});const{rootName:t,elementName:r,includeHeader:n,rootElementForArray:s}=e;let{xmlns:a}=e;a=a?` xmlns="${a}"`:"";const o=n?'<?xml version="1.0" encoding="UTF-8" standalone="yes"?>':"",l=d=>{const c=[];for(const u in d){const h=d[u];if(Array.isArray(h)){s&&c.push(`<${u}>`);for(const f of h)r.length?c.push(`<${r}>`):c.push(`<${u}>`),c.push(l(f)),r.length?c.push(`</${r}>`):c.push(`</${u}>`);s&&c.push(`</${u}>`)}else X.isObject(h)?c.push(`<${u}>${l(h)}</${u}>`):h==null?c.push(`<${u}/>`):c.push(`<${u}>${O.encodeHtml(h)}</${u}>`)}return c.join("")};return`${o}<${t}${a}>${l(i)}</${t}>`}};U0._$name="XMLHelper";var eo=class{constructor(){this.random100=[46,2,36,46,54,59,18,20,71,55,88,98,13,61,61,40,2,15,3,32,51,45,64,25,81,85,54,13,57,49,64,22,81,94,0,62,17,7,11,2,33,99,85,26,83,83,96,26,20,89,91,38,26,13,11,79,32,30,5,51,70,7,5,56,58,77,37,89,40,80,78,59,26,36,8,51,60,23,86,5,11,96,64,94,87,64,4,78,17,85,35,0,90,86,23,55,53,9,35,59,29,2,64,42,8,49,43,73,6,53,38,9,39,31,32,40,49,13,78,68,20,99,24,78,35,91,73,46,67,76,89,69,30,69,25,3,4,55,1,65,66,76,83,19,67,1,95,24,54,45,56,40,67,92,72,4,69,8,47,50,27,2,38,9,14,83,12,14,62,95,22,47,35,18,38,14,86,64,68,61,52,69,39,93,20,73,32,52,74,6,56,68,99,29,24,92,40,67,6,72,31,41,91,53,80,55,33,97,97,99,18,20,5,27,82,84,61,78,27,67,7,42,75,95,91,25,63,21,70,36,46,0,1,45,84,6,86,15,10,62,96,94,10,23,93,83,94,47,5,29,29,52,51,37,77,96,43,72,43,14,54,14,72,52,4,39,15,26,68,28,25,76,60,50,22,40,72,74,68,58,8,48,40,62,52,24,9,26,47,44,49,96,7,77,90,45,76,47,5,86,1,36,18,42,19,90,34,23,70,32,69,79,0,99,57,80,72,21,19,72,85,68,4,40,86,62,0,63,4,11,69,31,78,31,21,78,29,84,13,53,57,10,26,50,24,30,90,42,51,96,93,21,99,23,81,0,89,43,86,63,93,19,54,71,92,36,4,95,37,99,60,29,23,50,68,95,57,95,77,53,99,78,75,12,92,47,23,14,0,41,98,11,34,64,26,90,50,23,38,31,74,76,16,76,66,23,22,72,48,50,20,36,37,58,5,43,49,64,81,30,8,21,98,75,60,17,50,42,27,38,90,74,45,68,67,27,31,15,58,76,41,99,23,98,53,98,56,19,79,2,4,38,96,24,65,51,43,42,41,60,46,7,90,65,3,27,63,99,51,44,86,1,54,40,15,74,3,81,51,63,87,79,84,72,22,38,96,95,33,41,21,99,21,69,7,49,40,52,41,6,91,19,76,40,54,17,33,11,11,0,1,32,94,33,13,18,45,7,85,61,42,54,45,72,78,96,17,9,80,87,41,96,66,0,8,59,18,21,2,28,64,75,97,32,80,86,97,97,55,2,73,75,11,89,67,58,70,76,12,46,64,17,22,97,25,35,93,57,82,46,57,61,31,74,27,4,32,85,53,86,53,53,42,5,28,50,65,63,70,61,73,37,13,80,7,34,22,3,26,6,62,78,12,56,87,41,58,64,31,27,45,35,18,66,62,43,89,69,94,93,33,74,2,43,85,37,82,41,74,9,15,44,33,42,65,19,1,49,78,12,29,9,78,7,55,12,45,40,33,16,86,14,52,16,73,76,0,98,75,91,78,46,99,95,90,69,78,45,62,55,37,88,49,77,27,83,38,73,39,1,75,40,65,83,54,95,7,73,4,30,26,36,89,21,5,95,11,14,87,45,36,21,77,55,5,66,51,98,48,62,74,58,23,82,30,28,19,53,89,76,98,8,34,70,28,54,16,52,35,93,54,54,72,49,18,93,72,90,71,73,15,60,38,80,76,53,70,39,69,25,5,31,61,46,6,54,34,31,52,33,36,79,76,44,29,28,38,1,66,2,90,91,1,76,78,31,55,37,71,2,3,38,85,0,95,42,2,39,57,87,61,77,98,2,24,80,48,27,47,71,15,7,49,60,86,3,2,29,38,54,36,59,83,27,47,9,36,42,8,73,85,9,16,73,60,39,12,43,25,23,29,28,47,40,77,20,89,22,30,41,59,96,19,56,20,76,73,39,46,72,40,47,37,52,29,79,37,39,50,41,87,66,17,75,31,45,26,88,70,11,90,40,74,9,32,65,72,61,6,93,54,15,84,22,99,47,10,96,4,84,19,85,73,45,25,16,8,94,99,39,28,26,68,87,48,1,65,86,46,86,7,60,82,45,75,38,56,41,35,30,86,91,97,85,45,5,14,69,85,96,37,18,26,16,38,16,1,44,94,85,58,60,20,5,47,52,41,50,71,43,42,67,64,38,65,83,99,78,96,33,20,98,24,6,2,25,16,16,44,63,24,68,56,49,91,15,59,99,27,43,34,28,36,45,1,10,19,54,26,75,17,88,96,63,24,71,93,72,97,66,87,18,86],this.randomCache={},this.rndIndex=0}nextRandom(i){const{randomCache:e}=this;let t;return e[i]?t=e[i]:(t=this.random100.filter(r=>r<i),e[i]=t),t[this.rndIndex++%t.length]}reset(){this.rndIndex=0}fromArray(i){return i[this.nextRandom(i.length)]}randomArray(i,e){const t=[],r=this.nextRandom(e+1),n={};for(let s=0,a=this.nextRandom(i.length);s<r;s++){for(;n[a];)a=this.nextRandom(i.length);n[a]=!0,t.push(i[a])}return t}};eo._$name="RandomGenerator";var Nk=["Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.","Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.","Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.","Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.","Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.","Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui atione voluptatem sequi nesciunt.","Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.","Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur?","Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"],fc=class Cp{static reset(){this.rnd.reset(),this.rndTime.reset(),this.rndRating.reset()}static get cities(){return["Stockholm","Barcelona","Paris","Dubai","New York","San Francisco","Washington","Montreal"]}static get namesWithAvatars(){return["Adam","Amit","Angelo","Arcady","Arnold","Barbara","Celia","Chang","Dan","Daniel","Dave","david","Don","Doug","Emilia","George","Gloria","Henrik","Hitomi","James","Jane","Jenny","John","Jong","Karen","Kate","Lee","Linda","Lisa","Lola","Macy","Madison","Malik","Mark","Mary","Maxim","Melissa","Mike","Rob","Steve","Team","Theo"]}static get firstNames(){return["Mike","Linda","Don","Karen","Doug","Jenny","Daniel","Melissa","John","Jane","Theo","Lisa","Adam","Mary","Barbara","James","David"]}static get surNames(){return["McGregor","Ewans","Scott","Smith","Johnson","Adams","Williams","Brown","Jones","Miller","Davis","More","Wilson","Taylor","Anderson","Thomas","Jackson"]}static get teams(){return["Lions","Eagles","Tigers","Horses","Dogs","Cats","Panthers","Rats","Ducks","Cougars","Hens","Roosters"]}static get foods(){return["Pancake","Burger","Fish n chips","Carbonara","Taco","Salad","Bolognese","Mac n cheese","Waffles"]}static get colors(){return["Blue","Green","Red","Yellow","Pink","Purple","Orange","Teal","Black"]}static get skills(){return["JavaScript","CSS","TypeScript","React","Vue","Angular","Java","PHP","Python","C#","C++","BASIC","COBOL","FORTRAN","PASCAL","SQL"]}static get tasks(){return["Meetings","Documentation","Email communication","Project management","Budgeting","Marketing and advertising","Customer service","Research and analysis","Data entry","IT support","Employee management","Sales and business development","Event planning","Graphic design","Writing and editing","Presentation","Travel arrangements and expense management","Training and development","Quality assurance","Customer support","Technical writing","Social media management","Translation","Legal research","Data analysis and visualization","Video editing and production","Network admin","Content creation","Market research","Public relations","Teaching and training","Recruiting","Product development"]}static generateName(){const{rnd:e,namesWithAvatars:t,surNames:r}=this,n=e.fromArray(t),s=e.fromArray(r);return`${n} ${s}`}static*generate(e,t=!1,r=1){var n;let s,a;typeof e=="object"&&(t=e.randomHeight,r=(n=e.initialId)!=null?n:1,s=e.addSkills,a=e.rowCallback,e=e.count);const o=this,{rnd:l,rndTime:d,rndRating:c,rndText:u,firstNames:h,surNames:f,teams:g,foods:m,colors:p,cities:y,skills:b}=o;for(let C=0;C<e;C++){const D=l.fromArray(h),S=l.fromArray(f),x=`${D} ${String.fromCharCode(65+C%25)} ${S}`,R=l.nextRandom(60)+1,M=new Date(2019,0,R),I=new Date(2019,0,R+l.nextRandom(30)+2),_={id:r>-1?C+r:void 0,title:"Row "+C,name:x,firstName:D,surName:S,city:l.fromArray(y),team:l.fromArray(y)+" "+l.fromArray(g),age:10+l.nextRandom(80),food:l.fromArray(m),color:l.fromArray(p),score:l.nextRandom(100)*10,rank:l.nextRandom(100)+1,start:M,finish:I,time:w.getTime(d.nextRandom(24),d.nextRandom(12)*5),percent:l.nextRandom(100),done:l.nextRandom(100)<50,rating:c.nextRandom(5),active:R>30,relatedTo:Math.min(e-1,C+r+l.nextRandom(10)),notes:Nk[u.nextRandom(7)+1]};s&&(_.skills=l.randomArray(b,typeof s=="number"?s:7));const P=a==null?void 0:a(_);P&&Object.assign(_,P),t&&(_.rowHeight=l.nextRandom(t===!0?20:t)*5+20),yield _}}static generateData(e,t=!1,r=1,n=!0){let s=e;typeof e!="object"&&(s={count:e,randomHeight:t,initialId:r,reset:n}),s.reset!==!1&&this.reset(),Cp.overrideRowCount&&(s.count=Cp.overrideRowCount);const a=[],o=this.generate(s);for(let l=0;l<s.count;l++)a.push(o.next().value);return a}static generateEvents({viewStartDate:e,viewEndDate:t,nbrResources:r=50,nbrEvents:n=5,dependencies:s,tickUnit:a="days",minDuration:o=2,maxDuration:l=10,gap:d=1,eventCallback:c}){const u=this.generateData(r),h=[];let f,g;s=[];for(let m=0;m<=r;m++)for(let p=0;p<=n;p++){const y=Math.round(Math.random()*(l-1-o))+o,b=h.length+1;f=p===0?w.add(e,Math.round(Math.random()*3)*d,a):w.add(g,d,a),g=w.add(f,y,a),h.push({id:b,name:this.tasks[(m+p)%(this.tasks.length-1)],startDate:f,duration:y,endDate:g,resourceId:m}),c==null||c(h[h.length-1]),s&&m>0&&s.push({id:s.length+1,from:b-1,to:b})}return{resources:u,events:h,dependencies:s}}static generateOneEventPerTickAndResource({startDate:e,endDate:t,nbrResources:r=50,tickUnit:n="days"}){const s=this.generateData(r),a=[],o=w.getDurationInUnit(e,t,n);for(let l=0;l<=r;l++)for(let d=0;d<o;d++)a.push({id:a.length+1,resourceId:l,name:this.tasks[(l+d)%(this.tasks.length-1)],startDate:w.add(e,d,n),duration:1,durationUnit:n});return{resources:s,events:a}}static generateRow(){return Cp.generateData(1,!1,-1,!1)[0]}};v(fc,"rnd",new eo),v(fc,"rndTime",new eo),v(fc,"rndRating",new eo),v(fc,"rndText",new eo);var G0=fc;G0._$name="DataGenerator";var Wk=["action","target","to","deltaX","deltaY","x","y","text"],Y0=class extends Ve(ve()){static get defaultConfig(){return{repeat:!0,outerElement:document.body,callOnFunctions:!0}}construct(i){super.construct(i);const e=this;e.widget&&(e.outerElement=e.widget.element,e.widget.playingDemo=!0),j.playingDemo=!0,Object.assign(e,{prevTarget:null,currentStep:0,mouse:E.createElement({parent:e.outerElement,tag:"div",className:"simulated-mouse"}),timeoutId:null,innerIntervalId:null,mouseOutElements:[]}),e.intervalId=e.setInterval(e.nextStep.bind(e),1e3),e.outerElement.classList.add("b-playing-demo"),e.outerElement.addEventListener("click",t=>{t.isTrusted&&e.abort()})}doDestroy(){this.abort()}abort(i=!1){const e=this;e.mouse.style.top="-100px",e.clearInterval(e.intervalId),e.timeoutId&&e.clearTimeout(e.timeoutId),e.innerIntervalId&&e.clearInterval(e.innerIntervalId),e.outerElement.classList.remove("b-playing-demo"),e.widget&&(e.widget.playingDemo=!1),j.playingDemo=!1,e.trigger(i?"done":"abort")}triggerEvent(i,e,t){if(!i)return null;let r;if(e.startsWith("mouse")){const n=this.mouse.getBoundingClientRect();r=new MouseEvent(e,Object.assign({view:globalThis,bubbles:!0,cancelable:!0,clientX:n.left,clientY:n.top},t||{}))}else r=document.createEvent("Event"),r.initEvent(e,!0,!1);return i.dispatchEvent(r),r}handleMouseMove(i,e){const t=this,r=t.mouse;r.classList.add("quick"),t.mouseDown&&r.classList.add("drag");const n=k.from(r,t.outerElement),s=n.x,a=n.y;let o=0,l=0;if(i.to)if(typeof i.to=="string"){const c=t.outerElement.querySelector(i.to);if(c){const u=k.from(c,t.outerElement),h=u.x+u.width/2,f=u.y+u.height/2;o=(h-s)/10,l=(f-a)/10}}else i.to.x?o=(i.to.x-s)/10:(o=i.to[0]/10,l=i.to[1]/10);else i.deltaX?o=i.deltaX/10:i.x&&(o=(i.x-s)/10);i.deltaY&&(l=i.deltaY/10);let d=0;t.innerIntervalId=t.setInterval(()=>{if(t.shouldPause)return;d++===9&&(clearInterval(t.innerIntervalId),i.then&&i.then());const c=s+o*d,u=a+l*d;r.style.left=c+"px",r.style.top=u+"px";const h=r.getBoundingClientRect(),f=h.left,g=h.top,m=E.elementFromPoint(f,g);m!==t.prevTarget&&(t.prevTarget&&(t.mouseOutElements.push(t.prevTarget),E.isDescendant(t.mouseOutElements[0],m)||(t.mouseOutElements.forEach(p=>t.triggerEvent(p,"mouseout")),t.mouseOutElements.length=0)),t.prevTarget=m,t.triggerEvent(m,"mouseover")),t.triggerEvent(m,i.action,{clientX:f,clientY:g})},50)}getTarget(i){const e=this,t=i.target;return t?typeof t=="function"?t(i):document.querySelector(t):e.prevTarget||e.outerElement}normalizeStep(i){if(i.action)return typeof i.action=="function"?i.action(i):i;if(typeof i=="function")return i(),i;for(const e in i)Object.hasOwnProperty.call(i,e)&&!Wk.includes(e)&&(i.action=e.toLowerCase(),i.to=i[e]);return!i.target&&(typeof i.to=="string"||typeof i.to=="function")&&(i.target=i.to),i}get isScrolling(){const i=this,e=i.outerElement.getBoundingClientRect(),t=i.lastTop&&e.top!==i.lastTop;return i.lastTop=e.top,t}get isInView(){const i=this.outerElement.getBoundingClientRect();return i.top<globalThis.innerHeight&&i.bottom>0}get shouldPause(){return!this.isInView||this.isScrolling||document.hidden||!document.hasFocus()}nextStep(){const i=this;if(i.shouldPause)return;if(i.currentStep===i.steps.length)if(i.repeat)i.currentStep=0;else return i.abort(!0);i.currentStep===0&&i.trigger("initialize");const e=i.mouse,t=i.normalizeStep(i.steps[i.currentStep++]),r=i.getTarget(t),n=t.action;if(r&&n)if(e.className="simulated-mouse",n==="mousemove")i.handleMouseMove(t,r);else{if(r!==i.prevTarget){const s=k.from(r,i.outerElement);e.style.left=s.x+s.width/2+"px",e.style.top=s.y+s.height/2+"px"}n==="mousedown"&&(i.mouseDown=!0),n==="mouseup"&&(i.mouseDown=!1),i.timeoutId=i.setTimeout(()=>{if(i.prevTarget=r,e.classList.add(n),n==="type"){const s=V.fromElement(r),a=t.text.split("|");s.value=a[a.length===1||s.value!=a[0]?0:1]}else i.triggerEvent(r,n)},n==="type"?100:550)}}};Y0._$name="DemoBot";var{defineProperty:Uk}=Object,Gk=Symbol("fencible"),Yk=[],q0=i=>Array.from(new Set(i)),Yv=i=>i?q0(O.split(i)):Yk,to=i=>{var e;return e=class extends(i||$){static setupFenced(t,r){const{fenced:n}=t,s=r.getInherited("fenced");let a,o,l,d,c;for(d in n)c=n[d],c===!0&&(c=d),T.isObject(c)||(c={all:c}),a=Yv(c.all),o=Yv(c.any),l=c.lock?Yv(c.lock):q0(a.concat(o)),o=o.length?o:null,s[d]={any:o,all:a,lock:l}}construct(...t){const r=this,n=Object.getPrototypeOf(r),s=r.$meta.getInherited("fenced"),a=r[Gk]={},o=l=>!a[l];return T.forEach(s,({any:l,all:d,lock:c},u)=>{Uk(r,u,{configurable:!0,value(...h){if(d.every(o)&&(!l||l.some(o))){let f;try{for(f of c)a[f]=(a[f]||0)+1;return n[u].apply(r,h)}finally{for(f of c)--a[f]}}}})}),super.construct(...t)}get widgetClass(){}},v(e,"$name","Fencible"),v(e,"declarable",["fenced"]),e},{floor:K0,max:rg,min:ng}=Math,Xi=class extends $.mixin(to){get direction(){const{name:i}=this,{events:e,scrollStarted:t}=this.owner;let r=0,n,s,a;for(n=e.length;n-- >0&&(a=e[n][i],!(s!=null&&(r=s-a,r)));)s=a;return!r&&s!=null&&(r=s-t[i]),r}get drift(){return this._drift||0}get driftRange(){const{range:i}=this;return[i[0],rg(i[0],i[1]-this.scrollSize)]}get items(){var i;return(i=this.owner)==null?void 0:i.items}get safeZone(){const{drift:i,scrollSize:e}=this,t=K0(this.owner.safetyMargin*e);return[i+t,i+e-t]}get scroller(){var i,e;return(e=(i=this.owner)==null?void 0:i.client)==null?void 0:e.scrollable}get scrollLimit(){var i;return(i=this.owner)==null?void 0:i.scrollLimit}get vast(){const{range:i}=this;return i?i[1]-i[0]>this.scrollSize:!1}changePos(i){const{range:e}=this;return ng(rg(i||0,e[0]),e[1])}updatePos(i){this.sync({pos:i})}updateDrift(i){const e=this,{pos:t,range:r}=e,n=t-i;if(e.scrollPos===n){const s=new CustomEvent("scroll",{detail:"driftChange"});e.owner.scroller.element.dispatchEvent(s)}else r[0]<=t&&t<r[1]&&(e.scrollPos=n)}changeRange(i,e){const[t,r]=Array.isArray(i)?i:[0,i],n=[t||0,r==null?1/0:r];if(!e||n[0]!==e[0]||n[1]!==e[1])return n}updateRange(i){this.scrollSize=i[1]-i[0],this.sync({range:i})}changeScrollSize(i){return ng(i,this.scrollLimit)}snap(){const i=this,{direction:e,items:t,owner:r,pos:n,range:s}=i;let a,o,l,d;for(a of t)if([o,l]=i.getItemSpan(a),o<=n&&n<l){o<n?(d=e<0&&o>=s[0]?o:l,i.pos=d,r.watchForEnd()):r.scrolling=!1;break}}sync(i){const e=Object.assign(this,i),{_drift:t,range:r,vast:n}=e;if(r&&r[0]!==r[1]){let{pos:s}=e,a;const o=s<r[0]||s>=r[1];if((s==null||o)&&(s=r[1]<0?r[0]:ng(rg(0,r[0]),r[1])),!n)a=r[0];else{const{driftRange:l,safeZone:d,scrollSize:c}=e;t==null||s<d[0]||s>d[1]?a=ng(rg(l[0],K0(s-c/2)),l[1]):a=t}e.scroller.positionDirty=!0,e.overflow="hidden-scroll",e.drift=a,a!==t?o?(e.positionDirty=!1,e._pos=null,e.pos=s):e.positionDirty=!0:(i==null?void 0:i.pos)!=null?(e.scrollPos=s-a,e.positionDirty=!0):(e.positionDirty&&(e.positionDirty=!1,e._pos=null),e.pos=e.scrollPos+a),(i!=null&&i.range||a!==t)&&e.owner.syncItems()}else e.overflow="hidden"}toLogical(i){return i+this.drift}toPhysical(i){const e=i-this.drift;return e>=0&&e<this.scrollLimit?e:NaN}};v(Xi,"configurable",{owner:null,drift:null,overflow:null,pos:{value:null,default:0,$config:"lazy"},range:{value:null,$config:"lazy"},scrollSize:null}),v(Xi,"fenced",{sync:!0});var qk=class extends Xi{get name(){return"x"}get other(){var i;return(i=this.owner)==null?void 0:i.y}get scrollPos(){return this.scroller.x}set scrollPos(i){this.scroller.x=i}get scrollSize(){return this.scroller.scrollWidth}set scrollSize(i){super.scrollSize=i}getItemSpan(i){const e=i.$vxy,{x:t}=e;return[t,t+e.width]}updateScrollSize(i){this.scroller.scrollWidth=i}updateOverflow(i){this.scroller.overflowX=i}},Kk=class extends Xi{get name(){return"y"}get other(){var i;return(i=this.owner)==null?void 0:i.x}get scrollPos(){return this.scroller.y}set scrollPos(i){this.scroller.y=i}get scrollSize(){return this.scroller.scrollHeight}set scrollSize(i){super.scrollSize=i}getItemSpan(i){const e=i.$vxy,{y:t}=e;return[t,t+e.height]}updateScrollSize(i){this.scroller.scrollHeight=i}updateOverflow(i){this.scroller.overflowY=i}};Xi.X=qk,Xi.Y=Kk,Xi._$name="Axis";var X0="b-infinity-scroller",Xk=Object.freeze({width:0,height:0}),qv=(i,e)=>{const t="v"+e;t in i||Object.defineProperty(i,t,{configurable:!0,get(){var r;return(r=this.$vxy)==null?void 0:r[e]},set(r){this.$vxy&&(this.$vxy[e]=r)}})},Kv=class extends ${get height(){return this.getDim("height")}get width(){return this.getDim("width")}get x(){return this._x}set x(i){this.moveTo(i)}get xy(){return[this._x,this._y]}set xy(i){this.moveTo(...i)}get y(){return this._y}set y(i){this.moveTo(null,i)}getDim(i){const e=this,{widget:t}=e,r="_"+i;return t?t.monitorResize?t[i]:e[r]||(e[r]=t[i]):0}moveTo(i,e){i!=null&&(this._x=i),e!=null&&(this._y=e),this.sync()}sync(){const i=this,{owner:e,widget:t}=i,{element:r}=t,n=e.x.toPhysical(i.x),s=e.y.toPhysical(i.y),a=isNaN(n+s);i.hidden=a,a?i.size=Xk:r.style.transform=`translate(${n}px, ${s}px)`}updateHidden(i){var e,t;(t=(e=this.widget)==null?void 0:e.element)==null||t.classList.toggle("b-scroll-hidden",i)}updateWidget(i,e){e==null||e.element.classList.remove("b-infinity-scroller-item"),i&&(i.element.classList.add("b-infinity-scroller-item"),qv(i,"x"),qv(i,"y"),qv(i,"xy"))}};v(Kv,"configurable",{hidden:null,owner:null,widget:null}),v(Kv,"prototypeProperties",{_height:0,_width:0,_x:0,_y:0});var sg=class extends $.mixin(Ve){get element(){var i;return(i=this.scroller)==null?void 0:i.element}get events(){return this._events||(this._events=[])}get items(){var i;return(((i=this.client)==null?void 0:i.items)||[]).filter(e=>e.$vxy)}get lastEvent(){var i;return(i=this._events)==null?void 0:i[this._events.length-1]}get pos(){return[this.x.pos,this.y.pos]}changeScrollLimit(i){return i||E.scrollLimit}updateAnimate(i,e){var t;const r=(t=this.element)==null?void 0:t.classList;e&&(r==null||r.remove(`b-infinity-scroller-${e}`)),i&&(r==null||r.add(`b-infinity-scroller-${i}`))}updateClient(i){this.scroller=(i==null?void 0:i.scrollable)||null}updateScroller(i,e){var t;this.detachListeners("scroller"),(t=e==null?void 0:e.element)==null||t.classList.remove(X0),i&&(i.element.classList.add(X0),i.ion({thisObj:this,name:"scroller",scroll:"onInternalScroll"}))}changeX(i){return Xi.X.new(i,{owner:this})}changeY(i){return Xi.Y.new(i,{owner:this})}onInternalScroll(i){const e=this,{lastPos:t,scrolling:r}=e;r||(e.scrolling="maybe"),e.sync();const n=[e.x.pos,e.y.pos];t&&t[0]===n[0]&&t[1]===n[1]?e.scrolling=r:(e.lastPos=n,e.pushEvent(i),r||(e.scrolling=!0),e.triggerScroll("scroll",i))}onInternalScrollEnd(){const i=this,{scrolling:e}=i;e&&(e==="snap"?i.updateScrolling(e):i.scrolling=i.snap?"snap":!1)}pushEvent(i){const e=this,{events:t}=e,r={event:i,x:e.x.pos,y:e.y.pos},n=t[t.length-1];if(i.type===(n==null?void 0:n.event.type)&&n.x===r.x&&n.y===r.y)n.event=i;else for(n||(e.scrollStarted=r),t.push(r);t.length>3;)t.shift()}scrollTo(i){var e,t;const r=this,{scrollingTo:n}=r,s=r.x.pos,a=r.y.pos,o=(e=i==null?void 0:i.x)!=null?e:s+(i==null?void 0:i.dx)||0,l=(t=i==null?void 0:i.y)!=null?t:a+(i==null?void 0:i.dy)||0,d=o-s,c=l-a,u=d||c,h=(i==null?void 0:i.animate)!==!1&&(i==null?void 0:i.animate)!==null;if(n){if(n.scroll.x===o&&n.scroll.y===l&&n.scroll.animate===h)return n.promise;n.finish()}const f=r.scrollingTo=Ga.new();return f.scroll={x:o,y:l,animate:h},u&&r.unanimated(!h,()=>{d&&(r.x.pos=o),c&&(r.y.pos=l)}),u&&h?(f.cancel=r.ion({once:!0,scrollEnd(){f.resolve(r.x.pos===o&&r.y.pos===l)}}),f.finish=()=>{f.cancel&&(f.cancel(),f.cancel=null,f.resolve(!1),r.scrollStarted=null)}):f.resolve(!0),f.finally(()=>{r.scrollingTo===f&&(r.scrollingTo=null)}),f.promise}suppressAnim(i){const e=this,t=e._suppressAnim||0,r=e._suppressAnim=Math.max(0,t+(i?1:-1));e.scroller.behavior=r?"instant":null}sync(){this.unanimated(()=>{this.x.sync(),this.y.sync()})}syncItems(){for(const i of this.items)i.$vxy.sync()}triggerScroll(i,e,t=this.x.pos,r=this.y.pos){this.trigger(i,{widget:this.client,relatedEvent:e,x:t,y:r})}updateScrolling(i,e){const t=this,r=e==="maybe",{lastEvent:n}=t;i?r?(t.watchForEnd(),t.scrollEnded=null,t.triggerScroll("scrollStart",n.event,n.x,n.y),t.element.classList.add("b-scrolling")):i==="snap"&&t[t.snap].snap():e&&((n==null?void 0:n.event.detail)==="driftChange"||!r)&&(t.scrollEnded=n,t.events.length=0,t.triggerScroll("scrollEnd",n.event,n.x,n.y),t.element.classList.remove("b-scrolling"))}unanimated(i,e){if(typeof i=="function"&&(e=i,i=!0),!i)e();else{this.suppressAnim(!0);try{e()}finally{this.suppressAnim(!1)}}}virtualize(i){typeof i=="string"&&(i=this.client.widgetMap[i]);let e=i.$vxy;return(!e||e.owner!==this)&&(e==null||e.destroy(),i.$vxy=e=new Kv({owner:this,widget:i})),e}watchForEnd(){const i=this,{client:e,scrollIdle:t,scrollStarted:r}=i;let n=0,s,a;(function o(){if(!i.isDestroyed&&!e.isDestroyed&&r===i.scrollStarted){if(a=i.pos,!s||s[0]!==a[0]||s[1]!==a[1])s=a,n=0;else if(++n>=t&&!ue.hasActiveTouches){i.onInternalScrollEnd();return}e.requestAnimationFrame(o)}})()}};v(sg,"configurable",{animate:"smooth",client:null,safetyMargin:.01,scroller:null,scrollIdle:8,scrolling:null,scrollLimit:{value:0,$config:"lazy"},snap:null,x:{},y:{}}),sg._$name="InfinityScroller";var Z0=i=>{var e;return e=class extends i{get infinityScrollerDefaults(){return{animate:this.animate}}compose(){return{}}changeInfinityScroller(t,r){return r?r.setConfig(t):r=sg.new({client:this},this.infinityScrollerDefaults,t),r}onChildAdd(t){var r;return t.innerItem&&((r=this._infinityScroller)==null||r.virtualize(t)),super.onChildAdd(t)}onInfiniteScroll(){this.syncSoon()}onInfiniteScrollEnd(){this.syncSoon.now()}onInfiniteScrollStart(){}onInternalResize(t,r,n,s,a){super.onInternalResize(t,r,n,s,a),this.hasPainted&&this.syncSoon()}onInternalPaint(t){var r;(r=super.onInternalPaint)==null||r.call(this,t),t.firstPaint&&(this.syncSoon.now(),this.infinityScroller.ion({thisObj:this,scroll:"onInfiniteScroll",scrollStart:"onInfiniteScrollStart",scrollEnd:"onInfiniteScrollEnd"}))}get scrollingTo(){return this.infinityScroller.scrollingTo}scrollTo(t){return this.infinityScroller.scrollTo(t)}sync(){this.infinityScroller.sync()}syncSoon(){const t=this;t.isPainted&&(t.recompose.flush(),t.infinityScroller.animate=t.animate,t.sync())}unanimated(t,r){return this.infinityScroller.unanimated(t,r)}updateAnimation(){this._infinityScroller&&this.syncSoon()}get widgetClass(){}},v(e,"configurable",{animate:"smooth",infinityScroller:{value:{},$config:"lazy"},monitorResize:!0,scrollable:{}}),v(e,"delayable",{syncSoon:"raf"}),e},Mr=class extends $.mixin(Ve,ds){static get configurable(){return{ownerCmp:null,itemsTabbable:null,target:null,keyEventTarget:null,processEvent:null,itemSelector:null,activeItem:null,focusCls:"b-active",keys:null,allowCtrlKey:null,allowShiftKey:null,scrollDuration:50,disabled:null,datasetIdProperty:"id",testConfig:{scrollDuration:1}}}static get factoryable(){return{defaultType:"navigator"}}get activeItem(){const{_activeItem:i}=this;if(this.target.contains(i))return i;this._activeItem=null}updateOwnerCmp(i){this.itemSelector||(this.itemSelector=`.${this.ownerCmp.itemCls}`),E.setAttributes(this.keyEventTarget,{"aria-activedescendant":`${this.owner.id}-active-descendant`})}set navigationEvent(i){const{owner:e}=this;this._navigationEvent=e.navigationEvent=i,i&&Promise.resolve(1).then(()=>this.navigationEvent=null)}get navigationEvent(){return this._navigationEvent}static getComposedKeyName(i){const e=(i.key||"").trim()||i.code;return`${i.ctrlKey?"CTRL+":""}${i.shiftKey?"SHIFT+":""}${i.altKey?"ALT+":""}${e}`}onKeyDown(i){var e;const t=this,{ownerCmp:r,itemSelector:n,activeItem:s,itemsTabbable:a}=t,{target:o}=i,l=t.firstItem,d=(i.key||"").trim()||i.code,c=t.constructor.getComposedKeyName(i),u=o.matches(n)||o===t.keyEventTarget;if(!t.disabled&&t.processEvent&&(i=t.processEvent.call(r,i)),i&&!t.disabled&&l&&t.target.offsetParent&&u){if(!a){if(t.inlineFlow==null){const h=l.parentNode,f=E.getStyleValue(l,"position"),g=E.getStyleValue(l,"display"),m=E.getStyleValue(l,"float");t.inlineFlow=f==="absolute"||g==="inline"||g==="inline-block"||m==="left"||m==="right"||E.getStyleValue(h,"display")==="flex"&&E.getStyleValue(h,"flex-direction")==="row"}t.prevKey||(t.inlineFlow?(t.prevKey="ArrowLeft",t.nextKey="ArrowRight"):(t.prevKey="ArrowUp",t.nextKey="ArrowDown"))}if(t.navigationEvent=i,s)switch(d){case t.prevKey:if(t.disabled||i.ctrlKey&&!t.allowCtrlKey||i.shiftKey&&!t.allowShiftKey)return;i.preventDefault(),i.handled=!0,t.navigatePrevious(i);break;case t.nextKey:if(t.disabled||i.ctrlKey&&!t.allowCtrlKey||i.shiftKey&&!t.allowShiftKey)return;i.preventDefault(),i.handled=!0,t.navigateNext(i);break;default:{const h=(e=t.keys)==null?void 0:e[c];if(h&&!t.disabled){if(t.callback(h,t.thisObj||r,[i])===!1)return}else r.onInternalKeyDown&&r.onInternalKeyDown(i);if(E.getActiveElement(o)!==o&&i.preventDefault(),a)return}}else{if(a)return;(d===t.nextKey||d===t.prevKey)&&(t.activeItem=t.getDefaultNavigationItem(i))}t.activeItem!==s&&t.triggerNavigate(i)}}getDefaultNavigationItem(i){const{target:e,itemSelector:t,prevKey:r,nextKey:n}=this;if(e.compareDocumentPosition(i.target)&4&&i.key===r)return e.querySelector(`${t}:last-of-type`);if(e.compareDocumentPosition(i.target)&2&&i.key===n)return e.querySelector(`${t}`)}navigatePrevious(i){const e=this,t=e.previous;i.preventDefault(),t&&e.ownerCmp.scrollable.scrollIntoView(t,{animate:e.scrollDuration}).then(()=>{e.activeItem=t,e.triggerNavigate(i)})}navigateNext(i){const e=this,t=e.next;i.preventDefault(),t&&e.ownerCmp.scrollable.scrollIntoView(t,{animate:e.scrollDuration}).then(()=>{e.activeItem=t,e.triggerNavigate(i)})}get owner(){return this.ownerCmp}get firstItem(){return this.target.querySelector(this.itemSelector)}get previous(){return this.getAdjacent(-1)}get next(){return this.getAdjacent(1)}getAdjacent(i=1,e=this.activeItem){const t=this.treeWalker;if(t.currentNode=e,t[i<0?"previousNode":"nextNode"](),t.currentNode!==this.activeItem)return t.currentNode}onTargetFocusIn(i){var e;const t=this,{target:r,relatedTarget:n}=i,{owner:s,itemsTabbable:a,skipScrollIntoView:o,previousActiveItem:l}=t;r.matches(".b-focus-trap")||(r.matches(t.itemSelector)?(t.skipScrollIntoView=!0,t.activeItem=r,t.skipScrollIntoView=o,t.activeItem&&a&&t.triggerNavigate(i)):r===t.target&&((n?r.compareDocumentPosition(n):0)&Node.DOCUMENT_POSITION_CONTAINED_BY?(e=s.previousSibling)==null||e.focus():t.activeItem=l&&t.target.contains(l)?l:0))}onTargetFocusOut(i){const e=this,{relatedTarget:t}=i;t!=null&&t.matches(".b-focus-trap")||(!t||!e.target.contains(t)||!t.matches(e.itemSelector))&&e.activeItem&&(e.activeItem=null,e.itemsTabbable&&e.triggerNavigate(i))}onTargetMouseDown(i){const e=this,t=i.target.closest(e.itemSelector);e.navigationEvent=i,e.itemsTabbable?t===e.activeItem&&e.triggerNavigate(i):e.ownerCmp.itemsFocusable===!1?e.onFocusGesture(i):t&&(i.preventDefault(),t.focus({preventScroll:!0}))}onTargetClick(i){var e;const t=this,{skipScrollIntoView:r}=t;if(t.skipNextClick||(e=t.navigationEvent)!=null&&e.ignoreNavigation){t.skipNextClick=!1;return}t.disabled||(t.skipScrollIntoView=!0,t.processEvent&&(i=t.processEvent.call(t.ownerCmp,i)),i&&(t.activeItem=i.target.closest(t.itemSelector),t.triggerNavigate(i)),t.skipScrollIntoView=r)}onFocusGesture(i){(i.target===this.ownerCmp.contentElement||i.target.closest(this.itemSelector)&&this.ownerCmp.itemsFocusable===!1)&&i.preventDefault()}acceptNode(i){return i.offsetParent&&i.matches&&i.matches(this.itemSelector)?E.NodeFilter.FILTER_ACCEPT:E.NodeFilter.FILTER_SKIP}changeActiveItem(i){return i!=null&&(this.ownerCmp.getItem?i=this.ownerCmp.getItem(i):typeof i=="number"&&(i=this.target.querySelector(this.itemSelector+`:nth-child(${i+1})`))),i}updateActiveItem(i,e){var t;const r=this,{ownerCmp:n}=r,s=e&&r.target.contains(e),a=i&&E.isFocusable(i)&&i!==E.getActiveElement(i);if(s&&(r.previousActiveItem=e),e&&(e.classList.remove(r.focusCls),e.removeAttribute("id")),i!=null){if(r.skipScrollIntoView?a&&i.focus({preventScroll:!0}):(t=n.scrollable)==null||t.scrollIntoView(i,{block:"nearest",focus:a,silent:r.scrollSilently}),i===e&&s)return;i.classList.add(r.focusCls),i.id=`${r.owner.id}-active-descendant`,r._activeItem=i}else r._activeItem=null,e===E.getActiveElement(e)&&n.revertFocus()}updateTarget(i,e){const t=this,r={element:i,thisObj:t,focusin:"onTargetFocusIn",focusout:"onTargetFocusOut",mousedown:{handler:"onTargetMouseDown",delegate:t.itemSelector}};!t.itemsTabbable&&!t.itemsFocusable&&(r.click="onTargetClick"),Object.prototype.hasOwnProperty.call(t,"acceptNode")||(t.acceptNode=t.acceptNode.bind(t),t.acceptNode.acceptNode=t.acceptNode),j.on(r),t.treeWalker=t.setupTreeWalker(i,E.NodeFilter.SHOW_ELEMENT,t.acceptNode),t.keyEventTarget||(t.keyEventTarget=i),(t.targetMutationMonitor=new MutationObserver(t.onTargetChildListChange.bind(t))).observe(i,{childList:!0,subtree:!0})}setupTreeWalker(i,e,t){return document.createTreeWalker(i,e,t)}onTargetChildListChange(){var i;const e=this,{activeItem:t,datasetIdProperty:r}=e;t&&(e.target.contains(t)?t.classList.contains(e.focusCls)||t.classList.add(e.focusCls):e.activeItem=e.target.querySelector(`${e.itemSelector}.${e.focusCls}[data-${O.hyphenate(r)}="${t.dataset[r]}"]`)||((i=e.target.querySelector(`${e.itemSelector}.${e.focusCls}`))==null?void 0:i[t.dataset.index])||null)}changeKeyEventTarget(i){this._keyEventTarget=i,j.on({element:i,keydown:"onKeyDown",thisObj:this})}triggerNavigate(i,e=this.activeItem){var t;const r={event:i,item:e,oldItem:this.previousActiveItem};this.trigger("navigate",r),(t=this.ownerCmp)==null||t.trigger("navigate",r)}};v(Mr,"$name","Navigator"),v(Mr,"type","navigator"),Mr._$name="Navigator";var Zk=class extends $.mixin(Ve){constructor(){super(...arguments),v(this,"hasNativeAccess",!0),v(this,"_content",null)}async writeText(i,e){const t=this,{_content:r}=t;if(e&&t.hasNativeAccess)try{await navigator.clipboard.writeText(i)}catch(n){t.hasNativeAccess=!1}r!==i&&(t._content=i,t.triggerContentChange(r,!1,!0))}writeData(i,e){this._dataContent=i,this._contentSource=e}async readText(i){const e=this,{_content:t}=e;if(i&&e.hasNativeAccess)try{const r=await navigator.clipboard.readText();return t!==r&&(e._content=r,e._dataContent=e._contentSource=null,e.triggerContentChange(t,!0)),r}catch(r){e.hasNativeAccess=!1}return t}readData(i){if(!(i&&!H.asArray(i).includes(this._contentSource)))return this._dataContent}triggerPaste(i){this.trigger("paste",{source:i,text:this._content})}triggerContentChange(i,e=!1,t=!1){this.trigger("contentChange",{fromRead:e,fromWrite:t,oldText:i,newText:this._content})}async clear(i){await this.writeText("",i),this.writeData(null)}},Q0=i=>{var e;return e=class extends(i||$){construct(...t){super.construct(...t),globalThis.bryntum.clipboard||(globalThis.bryntum.clipboard=new Zk),globalThis.bryntum.clipboard.ion({paste:"onClipboardPaste",contentChange:"onClipboardContentChange",thisObj:this})}get clipboard(){return globalThis.bryntum.clipboard}onClipboardPaste({text:t,source:r}){var n;const s=this,{clipboardText:a,isCut:o}=s,l=s.compareClipboardText(a,t);l&&o?((n=s.handleCutData)==null||n.call(s,{text:t,source:r}),s.isCut=!1,s.cutData=null):l||s.clearClipboard(!1)}onClipboardContentChange({newText:t}){this.compareClipboardText(this.clipboardText,t)||this.clearClipboard(!1)}set cutData(t){var r,n;const s=this;(r=s._cutData)==null||r.forEach(a=>s.setIsCut(a,!1)),s._cutData=H.asArray(t),(n=s._cutData)==null||n.forEach(a=>s.setIsCut(a,!0))}get cutData(){return this._cutData}async writeToClipboard(t,r,n={}){if(await this.beforeCopy({data:t,isCut:r,...n})===!1)return;const s=this,a=typeof t=="string",o=a?t:s.stringConverter?s.stringConverter(t):O.safeJsonStringify(t),l=a?o:s.cloneData?s.cloneData({data:t,stringData:o,isPaste:!1}):T.clone(t);return s.clipboardText=o,s.clipboard.writeData(l,s.$$name),await s.clipboard.writeText(o,s.useNativeClipboard),s.clipboardData=l,s.originalData=t,s.isCut=r,s.cutData=r&&!a?t:null,{data:r?t:l,clonedData:l,originalData:t,stringData:o}}async readFromClipboard(t={},r=!1){var n;const s=this,{clipboard:a}=s,o=await a.readText(s.useNativeClipboard),l=s.compareClipboardText(s.clipboardText,o),d=l?s.originalData:[];let c=a.readData(s.allowedDataSources);l||s.clearClipboard(!1);const{isCut:u}=s;if((u||!c||c===o)&&(c=s.transformClipboardText(o)),c&&!u&&typeof c!="string"&&s.cloneData&&(c=s.cloneData({data:c,isPaste:!0})),!(c==null||Array.isArray(c)&&c.length===0||await((n=s.beforePaste)==null?void 0:n.call(s,{data:c,text:o,originalData:d,...t,isCut:u,isOwn:l}))===!1))return r||a.triggerPaste(s),{data:c,text:o,isOwn:l,isCut:u,originalData:d}}async clearClipboard(t=!0){const r=this;r.clipboardData=r.originalData=r.clipboardText=r.cutData=null,r.isCut=!1,t&&await r.clipboard.clear(r.useNativeClipboard)}compareClipboardText(t,r){const n=/\r\n|(?!\r\n)[\n-\r\x85\u2028\u2029]/g;return(t==null?void 0:t.replace(n,`
`))===(r==null?void 0:r.replace(n,`
`))}transformClipboardText(t){const r=this;return r.compareClipboardText(r.clipboardText,t)?r.isCut?r.originalData:r.clipboardData:r.stringParser&&t?r.stringParser(t):t}hasClipboardData(){const{clipboard:t}=this,{_content:r}=t;if(!(this.useNativeClipboard&&t.hasNativeAccess))return!!(r&&this.transformClipboardText(r))}},v(e,"$name","Clipboardable"),v(e,"configurable",{useNativeClipboard:!1,allowedDataSources:null}),e},J0=i=>{var e;return e=class extends(i||$){construct(...t){super.construct(...t),this.finalizer=null,this.finalizing=null,this.isFinalized=!1,this.isFinalizing=!1}doFinalize(){this.destroy()}finalize(){const t=this;let r=t.finalizing;return!r&&!t.isFinalized&&(t.isFinalizing=!0,t.finalizing=r=t._awaitFinalizer()),r}async _awaitFinalizer(){const t=this;try{await t.finalizer}finally{t.finalizing=null,t.isFinalized=!0,t.doFinalize()}}},v(e,"$name","Finalizable"),e},Xv=Symbol("dragAbort"),ag=Symbol("dragInit"),ex=Symbol("dragDrag"),Zv=Symbol("dragDrop"),Qk={x:"horizontal",y:"vertical"},io=class extends $.mixin(J0,ve,Ud){static get configurable(){return{itemElement:null,scrollManager:null,monitoringConfig:null,source:null,target:null,targetElement:null,threshold:5,touchStartDelay:300,event:null}}static get identifiable(){return{}}construct(...i){super.construct(...i);const e=this,{event:t}=e;Object.assign(e,{altKey:null,cleaners:[],ctrlKey:null,data:new Map,element:t.target,endEvent:null,lastMoveEvent:null,metaKey:null,previousTarget:null,scrollerAction:null,shiftKey:null,state:ag,startEvent:t,touchStartTimer:null,_valid:!0}),"touches"in t&&e.touchStartDelay&&(e.touchStartTimer=e.setTimeout(()=>e.touchStartTimer=null,e.touchStartDelay,"touchStartDelay"));const r=globalThis;j.on({element:r,blur:"onWindowBlur",thisObj:e,autoDetach:!0})}doDestroy(){const i=this,{source:e,target:t}=i;i.cleanup(),(t==null?void 0:t.dropping)===i&&(t.dropping=null),(e==null?void 0:e.dragging)===i&&(e.dragging=null),super.doDestroy()}onWindowBlur(){this.started&&!this.completed&&this.abort()}get aborted(){return this.state===Xv}get completed(){return this.isDestroying||this.aborted||this.endEvent!==null}get pending(){return this.state===ag}get started(){return this.state!==ag&&!this.aborted}get valid(){return this.started&&this.targetElement!=null&&this._valid}set valid(i){this._valid=i}async get(i){if(this.aborted)throw new Error("Data is not available on aborted drag");if(!this.completed)throw new Error("Data is not available until drag completion");if(Array.isArray(i))return Promise.all(i.map(t=>this.get(t)));let e=this.data.get(i);return typeof e=="function"&&(e=await e(),this.data.set(i,e)),e}has(i){return this.data.has(i)}peek(i){if(this.aborted)throw new Error("Data is not available on aborted drag");if(Array.isArray(i))return i.map(t=>this.peek(t));let e=this.data.get(i);return typeof e=="function"&&(e=!0),e}set(i,e){this.data.set(i,e)}changeTarget(i,e){if(i!==e){const t=this;t._target=i,t.previousTarget=e,e&&(e.dropping=null),i&&(i.dropping=t,i.dropping!==t&&(i=null,t.valid=!1)),t._target=e}return i}updateTarget(i,e){const t=this;e&&t.source.dragLeaveTarget(t,e),i&&(t.valid=!0,i.dragMove(t),t.source.dragEnterTarget(t))}updateTargetElement(i){let e,t,r,n,s;for(s=i;s;s=s.parentElement)if(t=He.get(s,"droppables"),t){for(n=0;n<t.length;++n)if(e=t[n],e.dropRootElement.contains(i)&&(r=e.droppableSelector,(!r||i.closest(`#${E.getId(e.dropRootElement)} ${r}`))&&(this.target=e,this.target===e)))return}}abort(){const i=this,{element:e,source:t}=i;e==null||e.getBoundingClientRect(),i.state!==Zv&&(i.state=Xv,i.cleanup()),t==null||t.endDrag(i)}begin(){const i=this,{source:e}=i,t=e.beforeDrag(i);return t!==!1&&(e.dragging=i),t}cleanup(){let i;for(;i=this.cleaners.pop();)i()}end(i){const e=this,{lastMoveEvent:t,target:r}=e,{dragSwallowClickTime:n}=e.source;if(e.event=e.domEvent=e.endEvent=i,e.syncFlags(),e.started){if(((t==null?void 0:t.clientX)!==i.clientX||(t==null?void 0:t.clientY)!==i.clientY||(t==null?void 0:t.target)!==i.target)&&e.track(),n){const s=globalThis;j.on({element:s,capture:!0,expires:n,once:!0,click(a){a.stopPropagation()}})}e.state=Zv,r!==e.source&&(r==null||r.dragDrop(e))}}fakeKey(i,e){const t=this,{lastMoveEvent:r}=t;if(r&&t.element){let n;r.isKey=!0,i.key==="Alt"?t.altKey!==e&&(t.altKey=e,n=!0):i.key==="Control"&&t.ctrlKey!==e&&(t.ctrlKey=e,n=!0),n&&(t.event=t.domEvent=r,t.track())}}keyDown(i){this.completed||(i.key==="Escape"?this.abort():this.isDragToggleKey(i.key)&&this.fakeKey(i,!0))}keyUp(i){!this.completed&&this.isDragToggleKey(i.key)&&this.fakeKey(i,!1)}getDistance(i){return j.getDistanceBetween(this.startEvent,i)}isDragToggleKey(i){return i==="Control"||i==="Alt"}move(i){const e=this,{target:t}=i,r=e.getDistance(i),n=r>=e.threshold;if(e.syncFlags(),e.touchStartTimer){n&&e.abort();return}if(t&&t.nodeType===Node.ELEMENT_NODE&&t.isConnected){if(n&&!e.started&&(e.event=e.domEvent=i,e.start()===!1)){e.abort();return}i.touches&&(e.startEvent.preventDefault(),i.preventDefault(),i.stopPropagation()),e.started&&!e.completed&&(e.lastMoveEvent=e.event=e.domEvent=i,i.type==="touchmove"&&(i.preventDefault(),i.stopImmediatePropagation()),e.track())}}start(){const i=this,{scrollManager:e,monitoringConfig:t,source:r}=i,{draggingBodyCls:n,dragLock:s}=r,a=r.dragRootElement;if(i.state=ex,e){const l=e.startMonitoring(X.merge({scrollables:[{element:a}],direction:Qk[s]||s||"both",callback(d){const{lastMoveEvent:c}=i;c&&i.element&&(c.isScroll=!0,i.event=i.domEvent=c,i.scrollerAction=d,i.track(),i.scrollerAction=null)}},t));i.cleaners.push(l)}const o=r.dragRootElement.closest(".b-outer")||document.body;if(o.classList.add(n),i.cleaners.push(()=>o.classList.remove(n)),r.startDrag(i)===!1)return i.cleanup(),!1}syncFlags(){const i=this,{event:e}=i;i.altKey=e.altKey,i.ctrlKey=e.ctrlKey||e.metaKey,i.metaKey=e.metaKey,i.shiftKey=e.shiftKey}track(){const i=this,{event:e,source:t,target:r}=i;let n=e.target,s;e.type==="touchmove"&&(s=e.changedTouches[0],n=E.elementFromPoint(s.clientX,s.clientY)),i.targetElement=n,r===i.target&&(r==null||r.dragMove(i)),t.trackDrag(i)}};v(io,"$name","DragContext"),io.prototype.STATE=io.STATE=Object.freeze({ABORTED:Xv,INIT:ag,DRAGGING:ex,DROPPED:Zv}),io._$name="DragContext";var tx=class zI extends $.mixin(ds){static get configurable(){return{dragging:null}}static get factoryable(){return{defaultType:zI}}updateDragging(e,t){t&&this.close(t),e&&this.open(e)}close(e){}open(e){}dragStart(e){this.dragging=e}dragMove(e){}dragEnd(e){this.dragging=null}};v(tx,"type","default");var gc=tx;gc.initClass(),gc._$name="DragProxy";var Qv=i=>{var e;return e=class extends(i||$){static get configurable(){return{dragging:{$config:"nullify",value:null},draggingClsSelector:null,dragDocumentListeners:{element:document,keydown:"onDragKeyDown",keyup:"onDragKeyUp",contextmenu:"onDragContextMenu",mousemove:"onDragPointerMove",mouseup:"onDragPointerUp",pointerup:"onDragPointerUp",touchend:"onDragPointerUp",touchmove:{handler:"onDragPointerMove",passive:!1}},dragItemSelector:null,dragItemOverCls:null,dragLock:null,dragMinDistance:1,dragProxy:{$config:["lazy","nullify"],value:null},dragRootElement:{$config:"nullify",value:null},dragSameTargetDrop:!1,dragSelector:null,ignoreSelector:null,dragSwallowClickTime:50,dragThreshold:5,dragTouchStartDelay:300,dropTargetSelector:null,overItem:null,testConfig:{dragSwallowClickTime:50}}}static get properties(){return{draggingCls:"b-draggable-active",draggingBodyCls:"b-draghelper-active",draggingItemCls:"b-dragging-item",draggingStartedCls:"b-draggable-started",draggableCls:"b-draggable"}}beforeDrag(t){const{dragRootElement:r,dragSelector:n,ignoreSelector:s}=this,a=n&&t.element.closest(n);return!n||!!(a&&a===r||r.contains(a)&&(!s||!t.element.matches(s)))}dragStart(t){}dragOver(t){}dragEnterTarget(t){}dragLeaveTarget(t,r){}dragDrop(t){}dragEnd(t){}get activeDrag(){const{dragging:t}=this;return t!=null&&t.started&&!t.completed?t:null}get dragEventer(){return this.trigger?this:null}get draggingClassElement(){const{draggingClsSelector:t,dragRootElement:r}=this;return t?r==null?void 0:r.closest(t):r}beginDrag(t){const{draggingCls:r,draggingClassElement:n}=this;r&&n&&(n.classList.add(r),t.cleaners.push(()=>n.classList.remove(r)))}async endDrag(t){const r=this,{dragEventer:n,dragProxy:s}=r;t.valid&&await r.dragDrop(t),!r.isDestroyed&&(t.pending?t.destroy():(r.dragEnd(t),s==null||s.dragEnd(t),n==null||n.trigger(t.valid?"drop":"dragCancel",{drag:t,event:t.event}),r.finalizeDrag(t)))}async finalizeDrag(t){var r;await((r=t.finalize)==null?void 0:r.call(t))}moveDrag(t){if(this.dragOver(t)!==!1){const{dragEventer:r,dragProxy:n}=this;n==null||n.dragMove(t),r==null||r.trigger("drag",{drag:t,event:t.event})}}setupDragContext(t){const r=this,{dragItemSelector:n,id:s}=r,{target:a}=t;return{event:t,id:s?`${s}-drag-${r._nextDragId=(r._nextDragId||0)+1}`:null,itemElement:n?a.closest(n):a,touchStartDelay:r.dragTouchStartDelay,source:r,threshold:r.dragThreshold}}startDrag(t){const{draggingStartedCls:r,draggingClassElement:n,draggingItemCls:s,dragEventer:a,dragProxy:o}=this,{itemElement:l}=t;if((a==null?void 0:a.trigger("beforeDragStart",{drag:t,event:t.event}))===!1)return!1;r&&n&&(n.classList.add(r),t.cleaners.push(()=>n.classList.remove(r))),s&&l&&(l.classList.add(s),t.cleaners.push(()=>l.classList.remove(s))),o==null||o.dragStart(t);const d=this.dragStart(t);return d!==!1&&(a==null||a.trigger("dragStart",{drag:t,event:t.event})),d}trackDrag(t){var r;const{dropTargetSelector:n}=this;t.valid=!(n&&!((r=t.targetElement)!=null&&r.closest(n))),this.moveDrag(t)}configureListeners(t){const r=this,n=T.assign({thisObj:r},r.dragDocumentListeners);return"touches"in t.startEvent?(delete n.mousemove,delete n.mouseup):(delete n.contextmenu,delete n.touchmove,delete n.touchend,delete n.pointerup),n.element=E.getRootElement(r.dragRootElement),n}updateDragging(t,r){const n=this;if(t){const s=n.configureListeners(t);t.cleaners.push(j.on(s)),n.beginDrag(t)}else r&&r.destroy()}changeDragProxy(t,r){return gc.reconfigure(r,t,{owner:this,defaults:{owner:this}})}updateDragRootElement(t,r){var n;const s=this,{draggableCls:a,dragItemSelector:o,onDragItemMouseMove:l}=s;if(r==null||r.classList.remove(a),(n=s._dragRootDetacher)==null||n.call(s),t){const d={thisObj:s,element:t,mousedown:"onDragMouseDown",touchstart:"onDragTouchStart",pointerdown:c=>{var u,h;return c.pointerId&&((h=(u=c.target).releasePointerCapture)==null?void 0:h.call(u,c.pointerId))}};l&&(d.mousemove={delegate:o,handler:"onDragItemMouseMove"}),(s.dragItemOverCls||l||s.onDragItemMouseEnter||s.onDragItemMouseLeave)&&Object.assign(d,{mouseover:{delegate:o,handler:"onDragItemMouseOver"},mouseout:{delegate:o,handler:"onDragItemMouseOut"}}),t.classList.add(a),s._dragRootDetacher=j.on(d)}}onDragItemMouseOver(t){this.overItem=t}onDragItemMouseOut(t){this.dragging||(this.overItem=t)}changeOverItem(t){var r;return this.enterLeaveEvent=t,t.type==="mouseout"?((r=t.relatedTarget)==null?void 0:r.closest(this.dragItemSelector))||null:t.target.closest(this.dragItemSelector)}updateOverItem(t,r){var n,s;const a=this,{dragItemOverCls:o}=a;r&&(o&&r.classList.remove(o),(n=a.onDragItemMouseLeave)==null||n.call(a,a.enterLeaveEvent,r)),t&&(o&&t.classList.add(o),(s=a.onDragItemMouseEnter)==null||s.call(a,a.enterLeaveEvent,t))}onDragContextMenu(t){t.preventDefault()}onDragKeyDown(t){this.dragging.keyDown(t)}onDragKeyUp(t){this.dragging.keyUp(t)}onDragMouseDown(t){t.button===0&&this.onDragPointerDown(t)}onDragPointerDown(t){let{dragging:r}=this;r?r.isFinalizing||r.abort():(r=this.setupDragContext(t),r&&(r=new io(r),r.begin()===!1&&r.destroy()))}changeDragging(t,r){return r==null||r.destroy(),t}onDragPointerMove(t){const{changedTouches:r}=t,{dragging:n}=this;n&&!n.completed&&(!r||r.length===1)&&(n==null||n.move(t))}onDragPointerUp(t){const{dragging:r}=this;r&&!r.completed&&(r.end(t),this.endDrag(r))}onDragTouchStart(t){t.touches.length===1&&this.onDragPointerDown(t)}},v(e,"$name","Draggable"),e},ix=i=>{var e;return e=class extends(i||$){static get configurable(){return{droppableSelector:null,dropping:null,dropRootElement:{$config:"nullify",value:null}}}get dropEventer(){return this.trigger?this:null}get droppableCls(){return"b-droppable"}dragEnter(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("dragEnter",{drag:t,event:t.event})}dragMove(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("dragMove",{drag:t,event:t.event})}dragDrop(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("drop",{drag:t,event:t.event})}dragLeave(t){var r;return(r=this.dropEventer)==null?void 0:r.trigger("dragLeave",{drag:t,event:t.event})}changeDropping(t,r){if(t!==r){const n=this;r&&(r.aborted||!r.completed)&&n.dragLeave(r),t&&(n._dropping=t,n.dragEnter(t)===!1&&(t=null),n._dropping=r)}return t}updateDropRootElement(t,r){const n=this,{droppableCls:s}=n;let a,o,l;r&&(a=He.get(r,"droppables"),l=!0,Array.isArray(a)&&(o=a.indexOf(n))>-1&&(a.length<2?He.remove(r,"droppables"):(a.splice(o,1),a.forEach(d=>{s===d.droppableCls&&(l=!1)}))),l&&r.classList.remove(s)),t&&(a=He.get(t,"droppables"),a?a.push(n):He.set(t,"droppables",[n]),t.classList.add(s))}},v(e,"$name","Droppable"),e},Jk=i=>{var e;return e=class extends(i||$){static get configurable(){return{features:null}}static get declarable(){return["featureable"]}static setupFeatureable(t){const r={ownerName:"client",...t.featureable};r.factory.initClass(),Reflect.defineProperty(t,"featureable",{get(){return r}})}doDestroy(){var t;const r=this.features;super.doDestroy();for(const n in r){const s=r[n];(t=s.destroy)==null||t.call(s)}}hasFeature(t){var r;return!!((r=this.features)!=null&&r[t])}changeFeatures(t,r){if(this.isDestroying)return;const n=this,{featureable:s}=n.constructor,a=n.$features||(n.$features=new ps({configName:"features",factory:s.factory,owner:n,ownerName:s.ownerName}));if(a.update(t),!r)return a.target}get widgetClass(){}getCurrentConfig(t){const r=super.getCurrentConfig(t),{features:n}=r;if(n)for(const s in n)Object.keys(n[s]).length===0&&(n[s]=!0);return r}},v(e,"$name","Featureable"),e},Ge={e:"b-hover-edge",t:"b-hover-top",r:"b-hover-right",b:"b-hover-bottom",l:"b-hover-left"},eL={[Ge.e]:1,[Ge.t]:1,[Ge.r]:1,[Ge.b]:1,[Ge.l]:1},tL={t:[Ge.e,Ge.t],r:[Ge.e,Ge.r],b:[Ge.e,Ge.b],l:[Ge.e,Ge.l],tr:[Ge.e,Ge.t,Ge.r],bl:[Ge.e,Ge.b,Ge.l],tl:[Ge.e,Ge.t,Ge.l],br:[Ge.e,Ge.b,Ge.r]},iL=i=>{var e;return e=class extends i.mixin(ve){static get configurable(){return{hoverCls:null,hoverAnimationCls:null,hoverRootCls:null,hoverRootActiveCls:null,hoverDelay:null,hoverElement:null,hoverIgnoreElement:null,hoverEdges:null,hoverEdgeSize:10,hoverRootElement:{$config:"nullify",value:null},hoverSelector:null,hoverTarget:{$config:"nullify",value:null},hoverTrack:null,hoverZone:null}}static get delayable(){return{setHoverTarget:0}}hoverEnter(t){}hoverIgnore(t){var r;return(r=this.hoverIgnoreElement)==null?void 0:r.contains(t)}hoverLeave(t){}hoverMove(t){}onHoverMouseMove(t){const r=this,{hoverEdges:n,hoverEdgeSize:s,hoverTarget:a}=r;if(a){if(n){const{top:o,left:l,width:d,height:c,right:u,bottom:h}=a.getBoundingClientRect(),{clientX:f,clientY:g}=t,m=l+d/2,p=o+c/2,y=g<(s?o+s:p),b=f>=(s?u-s:m),C=g>=(s?h-s:p),D=f<(s?l+s:m),S=y||C?y?"t":"b":"",x=b||D?b?"r":"l":"";r.hoverZone=(n.includes(S)?S:"")+(n.includes(x)?x:"")}r.hoverEvent=t,r.hoverTrack&&r.hoverMove(t)}}onHoverMouseOver(t){this.hoverEvent=t,this.hoverElement=t.target}onHoverMouseOut(t){this.hoverEvent=t,this.hoverElement=t.relatedTarget}updateHoverDelay(t){this.setHoverTarget.delay=t}changeHoverEdges(t){return t===!0?"trbl":(t||"").replace("v","tb").replace("h","lr")}updateHoverEdges(){this.syncHoverListeners()}changeHoverElement(t){if(!this.hoverIgnore(t))return t}updateHoverElement(t){const{hoverSelector:r}=this;r&&(t=t==null?void 0:t.closest(r)),this.setHoverTarget(t)}updateHoverRootElement(t,r){const{hoverRootCls:n}=this;n&&(r==null||r.classList.remove(n),t==null||t.classList.add(n)),this.syncHoverListeners()}changeHoverTarget(t,r){return r&&(this.hoverZone=null),t}updateHoverTarget(t,r){const n=this,{hoverCls:s,hoverAnimationCls:a,hoverRootActiveCls:o,hoverRootElement:l}=n;o&&(l==null||l.classList[t?"add":"remove"](o)),r&&(s&&r.classList.remove(s),a&&r.classList.remove(a),n.hoverLeave(r)),t&&(s&&t.classList.add(s),n.hoverEnter(r),n.hoverTrack&&n.hoverMove(n.hoverEvent),a&&(t.getBoundingClientRect(),t.classList.add(a)))}updateHoverTrack(){this.syncHoverListeners()}updateHoverZone(t){const{hoverAnimationCls:r,hoverTarget:n}=this;if(n){const{className:s}=n,a=se.change(s,t?tL[t]:null,eL);s!==a&&(n.className=a,t&&r&&(n.classList.remove(r),n.getBoundingClientRect(),n.classList.add(r)))}}setHoverTarget(t){this.hoverTarget=t}syncHoverListeners(){var t;const r=this,n=r.hoverRootElement,s={element:n,thisObj:r,mouseover:"onHoverMouseOver",mouseout:"onHoverMouseOut"};(r.hoverTrack||r.hoverEdges)&&(s.mousemove="onHoverMouseMove"),(t=r._hoverRootDetacher)==null||t.call(r),r._hoverRootDetacher=n&&j.on(s)}},v(e,"$name","Hoverable"),e},Jv=i=>{var e;return e=class extends i{static get configurable(){return{loadMaskDefaults:{useTransition:!0,showDelay:1e3},loadMaskError:{icon:"b-icon b-icon-warning",autoClose:3e3,showDelay:0},loadMask:{text:"L{GridBase.loadMask}"},syncMask:{text:"L{GridBase.syncMask}"},localizableProperties:["loadMask.text","syncMask.text"],testConfig:{loadMaskError:{icon:"b-icon b-icon-warning",autoClose:500,showDelay:0}}}}applyLoadMask(){const t=this,{loadMask:r}=t;return r&&(t.masked=gs.mergeConfigs(t.loadMaskDefaults,r)),t.masked}applyMaskError(t){const{loadMaskError:r,masked:n}=this;return r===!1?n.hide():n&&(T.assign(n.errorDefaults,r),n.error=t),n}get widgetClass(){}},v(e,"$name","LoadMaskable"),e},rL={constructor:1,prototype:1,name:1,length:1,arguments:1,caller:1,callee:1,__proto__:1},rx=class{static apply(i){if(!i.target)throw new Error("Override must specify what it overrides, using static getter target");if(!i.target.class)throw new Error("Override must specify which class it overrides, using target.class");if(!this.shouldApplyOverride(i))return!1;const e=Object.getOwnPropertyNames(i),t=Object.getOwnPropertyNames(i.prototype);return e.splice(e.indexOf("target"),1),this.internalOverrideAll(i.target.class,e,i),this.internalOverrideAll(i.target.class.prototype,t,i.prototype),!0}static internalOverrideAll(i,e,t){Reflect.ownKeys(t).forEach(r=>{if(e.includes(r)&&!rL[r]){const n=Object.getOwnPropertyDescriptor(t,r);let s=i,a=null;for(;!a&&s;)a=Object.getOwnPropertyDescriptor(s,r),a||(s=Object.getPrototypeOf(s));a&&this.internalOverride(s,r,n,a)}})}static internalOverride(i,e,t,r){const n=i._overridden=i._overridden||{};n[e]=i[e],r.get?Object.defineProperty(i,e,{enumerable:!1,configurable:!0,get:t.get}):i[e]=t.value}static shouldApplyOverride(i){const e=i.target;if(!e.maxVersion&&!e.minVersion)return!0;if(!e.product)throw new Error("Override must specify product when using versioning");return!(e.maxVersion&&de[e.product].isNewerThan(e.maxVersion)||e.minVersion&&de[e.product].isOlderThan(e.minVersion))}};rx._$name="Override";var og=60*1e3,Ds=60*og,Ir=24*Ds,nL=/(\d+)?:?(\d*)/,Ai=class Kr{static format(e){const t=Math.floor(e/Ds),r=Math.floor(e/og)%60;return`${t}:${r<10?"0":""}${r}`}static parse(e){const t=typeof e;if(t==="string"){const r=nL.exec(e);e=Number(r[1]||0)*Ds+Number(r[2]||0)*og}else t!=="number"?e=w.getTimeOfDay(e):e<=24&&(e*=Ds);return Math.min(Math.max(Math.floor(e),0),Ir)}constructor(e){let t=0,r,n;e!=null&&e.isDayView?(t=e.dayStartShift,r=e.dayStartTime,n=e.dayEndTime):typeof e=="number"?t=r=n=e:e&&(t=e.startShift,r=e.timeStart,n=e.timeEnd),this.startShift=t=Kr.parse(t||0),this.timeEnd=(n==null?(t+Ir)%Ir:Kr.parse(n))||Ir,this.timeStart=r==null?t:Kr.parse(r)}get startHour(){return Math.floor(this.timeStart/Ds)}get endHour(){return Math.floor(this.timeEnd/Ds)}get startTimeOffsetMs(){const{startShift:e,timeStart:t}=this;return t<e?Ir-e+t:t-e}get today(){return this.startOfDay(new Date)}ceil(e){const t=this.startOfDay(e);return t<e&&t.setDate(t.getDate()+1),t}contains(e){return!this.outside(e)}dateKey(e){return e=this.shiftDate(e,-1),w.makeKey(e)}dayOfDate(e){return this.shiftDate(w.clearTime(e))}dayOfWeek(e){return e=this.shiftDate(e,-1),e.getDay()}delta(e,t="ms"){const{timeStart:r}=this,n=Kr.parse(e),s=(this.startShift&&n<r?n+Ir:n)-r;return t==="ms"?s:w.as(t,s,"ms")}duration(e="ms"){const{timeStart:t,timeEnd:r}=this,n=t<r?r-t:Ir-t+r;return e==="ms"?n:w.as(e,n,"ms")}equals(e){return this.startShift===(e==null?void 0:e.startShift)&&this.timeStart===e.timeStart&&this.timeEnd===e.timeEnd}intersects(e,t){const r=this,{timeStart:n,timeEnd:s}=r,[a,o]=r._dateRangeArgs(e,t),[l,d]=r.timeRange(a,o);return n<s?l<d?l<s&&n<=d:l<s||n<=d:!(l<d)||l<s||n<=d}isIntraDay(e,t){const r=this,[n,s]=r._dateRangeArgs(e,t),a=r.startOfDay(n),o=Ir-w.diff(a,s,"ms");return o<0?!1:o>0||a<n}isInterDay(e){return e.allDay||!this.isIntraDay(...arguments)}outside(e){const{startShift:t,timeStart:r,timeEnd:n}=this,s=Kr.parse(e);return r<n?s<r?s<t?1:-1:s<n?0:s<t?-1:1:s<n||s>=r?0:s<t?1:-1}parseKey(e){return this.dayOfDate(w.parseKey(e))}shiftDate(e,t=1){const{startShift:r}=this,n=typeof e;return e=n==="number"?new Date(e):n==="string"?w.parse(e):new Date(e.getTime()),t&&r&&e.setMilliseconds(t>0?r:-r),e}sortEvents(e,t){const r=this.startOfDay(e);return t==null?void 0:t.sort((n,s)=>{n=n.eventRecord||n,s=s.eventRecord||s;let{startDate:a}=n,{startDate:o}=s;return a?o?(a=a<r?r:a,o=o<r?r:o,a-o||s.endDate-o-(n.endDate-a)):1:-1})}startOfDay(e){return e=this.shiftDate(e,-1),e=w.clearTime(e),e=this.shiftDate(e),e}timeRange(e,t){const[r,n]=this._dateRangeArgs(e,t);return[w.getTimeOfDay(r),w.getTimeOfDay(n)]}toString(){const{startShift:e,timeEnd:t,timeStart:r}=this,n=e?`@${Kr.format(e)}`:"",s=Kr.format(r);return r===t?e?n:s:`${s}-${Kr.format(t)}${n}`}_dateRangeArgs(e,t){return e.isModel?[e.startDate,e.endingDate]:[e,t]}};Ai.MIDNIGHT=new Ai({startShift:0,timeStart:0,timeEnd:24}),Ai.MILLIS_PER_MINUTE=og,Ai.MILLIS_PER_HOUR=Ds,Ai.MILLIS_PER_DAY=Ir,Ai._$name="DayTime";var nx=class NI extends Ve($){static get configurable(){return{date:{$config:{equal:"date"},value:w.clearTime(new Date)},month:null,year:null,weekStartDay:null,hideNonWorkingDays:null,nonWorkingDays:null,sixWeeks:null}}configure(e){super.configure(e),this.updateDayNumbers(),e.date&&(this.date=e.date),this.generation=0}changeDate(e){if(!this.isConfiguring){if(e=typeof e=="string"?w.parse(e,"YYYY-MM-DD"):new Date(e),isNaN(e))throw new Error("Month date ingestion must be passed a Date, or a valid YYYY-MM-DD date string");return e}}updateDate(e,t){const r=this,{dayColumnIndex:n,weekCount:s}=r,a=w.getFirstDateOfMonth(e),o=w.getLastDateOfMonth(a),l=n[a.getDay()],d=n[o.getDay()],c=!t||e.getFullYear()!==t.getFullYear(),u=!t||e.getMonth()!==t.getMonth(),h=r.eventListeners&&(t?e.getDate()!==t.getDate()|(r.getWeekId(e)!==r.getWeekId(t))<<1|u<<2|c<<3:15);if(r._year=e.getFullYear(),r._month=e.getMonth(),r.startDayOfMonth=1-l,r.endDayOfMonth=o.getDate()+(6-d),r.sixWeeks&&(r.endDayOfMonth+=(6-r.weekCount)*7),(!r.weekBase||c)&&r.calculateWeekBase(),(u||c)&&r.generation++,h){const f={newDate:e,oldDate:t,changes:{d:!0,w:!!(h&2),m:!!(h&12),y:!!(h&8),r:r.weekCount!==s}};r.trigger("dateChange",f),h&2&&r.trigger("weekChange",f),h&12&&r.trigger("monthChange",f),h&8&&r.trigger("yearChange",f)}}calculateWeekBase(){const e=this,{dayColumnIndex:t}=e,r=new Date(e.year,0,1),n=new Date(e.year,11,31),s=e.month?e.getOtherMonth(r):e;e.dayColumnIndex[r.getDay()]>3?e.weekBase=s.startDate:e.weekBase=new Date(e.year,0,s.startDayOfMonth-7);const a=Math.floor(w.diff(e.weekBase,n,"day")/7);e.has53weeks=a===53&&t[n.getDay()]>2}getWeekStart(e){if(typeof e=="number")return w.add(this.weekBase,Math.max(e,1)*7,"day");const t=this,[r,n]=e;return r===t.year?t.getWeekStart(n):t.getOtherMonth(new Date(r,0,1)).getWeekStart(n)}getOtherMonth(e){const t=this,r=t===sx?new NI(null):sx;return r.configure({weekBase:null,weekStartDay:t.weekStartDay,nonWorkingDays:t.nonWorkingDays,hideNonWorkingDays:t.hideNonWorkingDays,sixWeeks:t.sixWeeks,date:new Date(e.getFullYear(),0,1)}),r.date=e,r.updateDate(r.date,r.date),r}changeYear(e){const t=new Date(this.date);t.setFullYear(e),this.date=t}changeMonth(e){const t=new Date(this.date);t.setMonth(e),this.date=t}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:w.weekStartDay}updateWeekStartDay(){const e=this;e.updateDayNumbers(),!e.isConfiguring&&e.date&&(e.weekBase=null,e.updateDate(e.date,e.date))}get nonWorkingDays(){return this._nonWorkingDays||w.nonWorkingDays}changeNonWorkingDays(e){return T.assign({},e)}updateNonWorkingDays(){this.updateDayNumbers()}updateHideNonWorkingDays(){this.updateDayNumbers()}updateSixWeeks(){this.isConfiguring||this.updateDate(this.date,this.date)}get dayCount(){return this.endDayOfMonth+1-this.startDayOfMonth}get weekCount(){return this.dayCount/7}get startDate(){const e=this;if(e.year!=null&&e.month!=null&&e.startDayOfMonth!=null)return new Date(e.year,e.month,e.startDayOfMonth)}get endDate(){const e=this;if(e.year!=null&&e.month!=null&&e.startDayOfMonth!=null)return new Date(e.year,e.month,e.endDayOfMonth)}eachDay(e){for(let t=this.startDayOfMonth;t<=this.endDayOfMonth;t++)e(new Date(this.year,this.month,t))}eachWeek(e){const t=this,{weekCount:r}=t;for(let n=t.startDayOfMonth,s=0;s<r;s++){const a=[],o=t.getWeekNumber(new Date(t.year,t.month,n));for(let l=0;l<7;l++,n++)a.push(new Date(t.year,t.month,n));e(o,a)}}getWeekNumber(e){const t=this;if(e=w.clearTime(e),e.getFullYear()!==t.year)return t.getOtherMonth(new Date(e.getFullYear(),0,1)).getWeekNumber(e);let r=Math.floor(w.diff(t.weekBase,e,"day")/7),n=e.getFullYear();if(r)r===53&&!t.has53weeks?(r=1,n++):r>53&&(r=r%52);else return t.getOtherMonth(new Date(t.year-1,0,1)).getWeekNumber(new Date(t.year,0,0));return[n,r]}getWeekId(e){const t=this.getWeekNumber(e);return t[0]*100+t[1]}getCellData(e,t,r=Ai.MIDNIGHT){const n=this,s=e.getDay(),a=n.visibleDayColumnIndex[s],o=n.nonWorkingDays[s],l=n.hideNonWorkingDays&&o;return(e<n.startDate||e>n.endDate)&&(n.month=e.getMonth()),{day:s,dayTime:r,visibleColumnIndex:a,isNonWorking:o,week:n.getOtherMonth(e).getWeekNumber(e),key:w.format(e,"YYYY-MM-DD"),columnIndex:n.dayColumnIndex[s],date:new Date(e),dayEnd:r.duration("s"),tomorrow:r.dayOfDate(w.add(e,1,"day")),isOtherMonth:Math.sign(e.getMonth()+e.getFullYear()*12-(t.month+t.year*12)),visible:!l&&e>=t.startDate&&e<w.add(t.endDate,1,"day"),isRowStart:a===0,isRowEnd:a===n.visibleColumnCount-1}}updateDayNumbers(){const e=this,{weekStartDay:t,nonWorkingDays:r,hideNonWorkingDays:n}=e,s=e.dayColumnIndex=[],a=e.canonicalDayNumbers=[],o=e.visibleDayColumnIndex=[];let l=0;for(let d=0;d<7;d++){const c=(t+d)%7;a[d]=c,s[c]=d,(!n||!r[c])&&(o[c]=l++)}e.visibleColumnCount=l,e.weekLength=n?7-T.keys(r).length:7}};v(nx,"$name","Month");var mc=nx,sx=new mc(null);mc._$name="Month";var sL=0,ax=new WeakMap,aL=(...i)=>i.map(e=>{let t;return e&&typeof e=="object"||typeof e=="function"?(t=ax.get(e),t===void 0&&(t=++sL,ax.set(e,t))):t=String(e),t}).join("-"),un=i=>{const e=new Map;return(...t)=>{const r=aL(t);let n=e.get(r);return n===void 0&&(n=i(...t),e.set(r,n)),n}},pc=i=>{const e=new Map,t=c=>c[0],r=c=>c[1],n=(c,u)=>t(c).push(u),s=(c,u)=>r(c).push(u),a=(c,u)=>r(c).some(h=>T.isEqual(h,u)),o=()=>[[],[]],l=c=>!r(c).length&&!t(c).length,d=c=>{let u=e.get(c);return u===void 0&&(u=o(),e.set(c,u)),u};return(c,u)=>{const h=d(c);l(h)?(n(h,u),i(c,f=>{a(h,f)||(s(h,f),t(h).forEach(g=>g(f)))})):(n(h,u),r(h).forEach(f=>u(f)))}},ox=Symbol("success"),oL=Symbol("failure"),lg=(i,e)=>[ox,i,e],ey=i=>[oL,i],ty=i=>i.length&&i[0]===ox,vc=i=>typeof i=="function"&&!i.length?i():i,dg=un(i=>pc((e,t)=>t(lg(i,e)))),lL=un(i=>pc((e,t)=>{const r=Math.min(i.length,e.length),n=e.substr(0,r),s=e.substr(r);t(n===i?lg(n,s):ey(s))})),cg=(i,e)=>(t,r)=>vc(i)(t,n=>{if(ty(n)){const[,s,a]=n;e(s)(a,r)}else r(n)}),dL=un((...i)=>{const e=un((t,r)=>pc(cg(t,n=>cg(r,s=>dg([].concat(n,s))))));return i.reduce(e,dg([]))}),cL=un((...i)=>pc((e,t)=>i.forEach(r=>vc(r)(e,t)))),uL=un(i=>(e,t)=>{const r=new RegExp(`^${i}`),n=r.exec(e);if(n){const s=n[0],a=e.substr(s.length);t(lg(s,a))}else t(ey(e))}),hL=un((i,e)=>cg(i,(...t)=>dg(e(...[].concat.apply([],t))))),lx=(i,e)=>{const t=[];return i(e,r=>{if(ty(r)){const[,,n]=r;n===""&&t.push(r)}}),t},fL=i=>(e,t)=>t?vc(i)(e,t):lx(vc(i),e),gL={memo:un,memoCps:pc,success:lg,failure:ey,isSuccess:ty,resolveParser:vc,succeed:dg,string:lL,bind:cg,seq:dL,alt:cL,regexp:uL,red:hL,runParser:lx,defineParser:fL},ug=class extends $.mixin(ve,Ve){static get configurable(){return{element:null,zoneWidth:50,scrollSpeed:5,direction:"both",startScrollDelay:500,stopScrollWhenPointerOut:!1,testConfig:{scrollSpeed:2,startScrollDelay:100},activeScroll:{$config:["lazy"],value:{}},monitoring:{$config:["lazy","nullify"],value:!0},owner:null}}changeMonitoring(i,e){return e==null||e.clear(),new Map}doDestroy(){this.stopMonitoring(),super.doDestroy()}get isScrolling(){return Object.keys(this.activeScroll).length!==0}get rtl(){var i;return(i=this.owner)==null?void 0:i.rtl}startMonitoring(i={}){const e=this,{element:t,direction:r}=e,{scrollables:n=[],direction:s=r,callback:a}=i,o=[];return n.length||n.push({element:t}),n.forEach(l=>{const d=l.element;typeof d=="string"?E.forEachSelector(t,d,c=>{e.createMonitor(c,l.direction||s,l.callback||a),o.push(c)}):(e.createMonitor(d,l.direction||s,l.callback||a),o.push(d))}),function(){var d;(d=e.stopMonitoring)==null||d.call(e,o)}}createMonitor(i,e,t){const{monitoring:r}=this;r.has(i)||r.set(i,new mL({scrollManager:this,element:i,direction:e,callback:t}))}stopMonitoring(i){const e=this,{monitoring:t}=e;if(i=H.asArray(i),t){if(!i){t.forEach(r=>e.stopMonitoring(r.element));return}i.forEach(r=>{const n=t.get(r);r.classList.remove("b-scrolling"),n&&(n.destroy(),t.delete(r))})}}requestScroll(i,e){const{activeScroll:t}=this;return i in t&&t[i]!==e?!1:(t[i]=e,!0)}releaseScroll(i){const{activeScroll:e={}}=this;Object.keys(e).forEach(t=>{e[t]===i&&delete e[t]})}getRelativeScroll(i,e="left"){let t=0;return this.monitoring.forEach((r,n)=>{E.isDescendant(n,i)&&(t+=e==="left"?r.scrollRelativeLeft:r.scrollRelativeTop)}),t}},mL=class extends ${construct(i){const e=this,{element:t}=i,r=t.scrollLeft,n=t.scrollTop;Object.assign(i,{startScrollLeft:r,startScrollTop:n}),super.construct(i),j.on({element:t,scroll:"onElementScroll",pointermove:"onMouseMove",capture:!0,thisObj:e}),j.on({element:t,pointerleave:"onPointerLeave",thisObj:e})}doDestroy(){this.stopScroll(!0),super.doDestroy()}startScroll(){const i=this;i.pendingScrollFinalize&&(i.scrollManager.releaseScroll(i),i.pendingScrollFinalize=!1),i.scrolling=!0,i.performScroll()}stopScroll(i=null){const e=this,t=()=>{e.pendingScrollFinalize=!1,e.isDestroyed||(e.scrollManager.releaseScroll(e),e.scrolling=!1)};e.scrollRequested&&(e.scrollManager.cancelAnimationFrame(e.frameId),e.scrollRequested=!1),e.scrollManager.clearTimeout(e.scrollTimeout),e.scrollTimeout=null,!i&&(e.ongoingScrollTop||e.ongoingScrollLeft)?(e.pendingScrollFinalize=!0,Promise.all([e.ongoingScrollTop,e.ongoingScrollLeft].filter(Boolean)).then(()=>e.pendingScrollFinalize&&t())):(e.ongoingScrollTop=e.ongoingScrollLeft=null,t())}onPointerLeave(){this.scrollManager.stopScrollWhenPointerOut&&this.stopScroll()}onMouseMove(i){const e=this,{scrollManager:t}=e,r=e.element.getBoundingClientRect(),n=t.zoneWidth,s=t.scrollSpeed;if(e.scrollDeltaX=e.scrollDeltaY=0,e.direction!=="vertical"){const{scrollLeft:a,scrollWidth:o,clientWidth:l}=e.element;t.rtl?i.clientX<r.left+n&&o+a-l>=1?e.scrollDeltaX=-Math.round((n+(r.left-i.clientX))/s)-1:i.clientX>r.right-n&&a<0&&(e.scrollDeltaX=Math.round((n-(r.right-i.clientX))/s)+1):i.clientX>r.right-n&&o-a-l>=1?e.scrollDeltaX=Math.round((n-(r.right-i.clientX))/s)+1:i.clientX<r.left+n&&a>0&&(e.scrollDeltaX=-Math.round((n+(r.left-i.clientX))/s)-1)}if(e.direction!=="horizontal"){const{scrollTop:a,scrollHeight:o,clientHeight:l}=e.element;i.clientY>r.bottom-n&&o-a-l>=1?e.scrollDeltaY=Math.round((n-(r.bottom-i.clientY))/s)+1:i.clientY<r.top+n&&a>0&&(e.scrollDeltaY=-Math.round((n+(r.top-i.clientY))/s)-1)}e.scrollDeltaX!==0&&!t.requestScroll("horizontal",e)&&(e.scrollDeltaX=0),e.scrollDeltaY!==0&&!t.requestScroll("vertical",e)&&(e.scrollDeltaY=0),e.scrollDeltaX===0&&e.scrollDeltaY===0?e.scrolling&&e.stopScroll():e.scrollTimeout||(e.scrollTimeout=t.setTimeout(()=>e.startScroll(),t.startScrollDelay))}performScroll(){const i=this,{element:e,scrollManager:t}=i;if(i.scrolling&&!i.scrollRequested){if(i.scrollDeltaX!==0){const r=e.scrollLeft,n=Math.min(r+i.scrollDeltaX,e.scrollWidth-e.clientWidth);e.scrollLeft=n,e.scrollLeft!==r?i.ongoingScrollLeft=new Promise(s=>e.addEventListener("scroll",a=>{var o;(o=t.trigger)==null||o.call(t,"scroll",{event:a,deltaY:i.scrollDeltaY,deltaX:i.scrollDeltaX}),s()},{once:!0})):(i.ongoingScrollLeft=null,i.scrollDeltaX=0)}if(i.scrollDeltaY!==0){const r=e.scrollTop,n=Math.min(r+i.scrollDeltaY,e.scrollHeight-e.clientHeight);e.scrollTop=n,e.scrollTop!==r?i.ongoingScrollTop=new Promise(s=>e.addEventListener("scroll",a=>{var o;(o=t.trigger)==null||o.call(t,"scroll",{event:a,deltaY:i.scrollDeltaY,deltaX:i.scrollDeltaX}),s()},{once:!0})):(i.ongoingScrollTop=null,i.scrollDeltaY=0)}i.scrollDeltaX!==0||i.scrollDeltaY!==0?(i.scrollRequested=!0,i.frameId=i.scrollManager.requestAnimationFrame(()=>{i.scrollRequested=!1,i.performScroll(i)})):i.stopScroll()}}onElementScroll(){var i,e;(e=(i=this.config)==null?void 0:i.callback)==null||e.call(this.thisObj||this.scrollManager,this)}get scrollLeft(){return this.element.scrollLeft}get scrollTop(){return this.verticalElement?this.verticalElement.scrollTop:this.element.scrollTop}get scrollRelativeLeft(){return this.scrollLeft-this.startScrollLeft}get scrollRelativeTop(){return this.scrollTop-this.startScrollTop}getRelativeLeftScroll(i){return this.scrollManager.getRelativeScroll(i,"left")}getRelativeTopScroll(i){return this.scrollManager.getRelativeScroll(i,"top")}};ug._$name="ScrollManager";var pL={left:!0,right:!0,top:!0,bottom:!0,transform:!0},vL={true:1,false:1},yL=Promise.resolve(),iy=class Xr extends Mt{static get configurable(){return{autoHide:!0,mouseOffsetX:15,mouseOffsetY:15,html:{$config:{equals:()=>!1}},getHtml:null,forElement:null,trackMouse:null,updateContentOnMouseMove:!1,forSelector:null,hideOnDelegateChange:null,anchorToTarget:!0,showOnHover:null,hoverDelay:500,autoShow:!1,dismissDelay:0,hideDelay:500,loadingMsg:"Loading...",allowOver:null,anchor:!0,align:{align:"b-t",minHeight:300},axisLock:!0,activeTarget:{$config:{equal:(e,t)=>e==null&&t==null||e===t},value:null},testConfig:{hideDelay:100,hoverDelay:100,showAnimation:null,hideAnimation:null},role:"tooltip",describedElement:null}}afterConfigure(){const e=this,{forSelector:t}=e;t&&(e.showOnHover=e.showOnHover!==!1,e.forElement||(e.anchorToTarget||(e.trackMouse=!0),e.forElement=e.rootElement.host||e.rootElement)),super.afterConfigure(),e.forElement&&e.showOnHover&&(e.pointerOverOutDetacher=j.on({element:e.forElement,pointerover:"internalOnPointerOver",pointerout:"internalOnPointerOut",thisObj:e}))}doDestroy(){var e;(e=this.pointerOverOutDetacher)==null||e.call(this),super.doDestroy()}set focusOnToFront(e){super.focusOnToFront=e}get focusOnToFront(){var e;return((e=this.triggeredByEvent)==null?void 0:e.pointerType)==="focus"?!1:super.focusOnToFront&&E.usingKeyboard}get focusElement(){const e=super.focusElement;if(e!==this.element)return e}get anchorToTarget(){return this._anchorToTarget&&!this.trackMouse}get anchor(){return super.anchor&&!this.trackMouse}set anchor(e){super.anchor=e}onDocumentMouseDown({event:e}){var t;const r=this,{triggeredByEvent:n}=r;n&&E.isTouchEvent&&e.pageX===n.pageX&&e.pageY===n.pageY&&(t=r.activeTarget)!=null&&t.contains(e.target)&&performance.now()-n.timeStamp<500||(r.abortDelayedShow(),super.onDocumentMouseDown({event:e}))}internalOnPointerOver(e){const t=this,{target:r,relatedTarget:n}=e,{forElement:s,forSelector:a,activeTarget:o}=t;let l;if(!(t.disabled||t.owner&&!t.owner.showTooltipWhenDisabled&&t.owner.disabled)&&!(t.allowOver&&t.element.contains(r))){if(a){const d=e.target.closest("[data-btip]");if(d&&!d.matches(a)){o&&t.handleForElementOut();return}if(l=t.filterTarget(r),o!=null&&o.contains(r)&&o.contains(n)&&l===o||l&&(n==null?void 0:n.closest(a))===l&&!n.dataset.btip)return}else if(!s.contains(n))l=s;else return;l?t.handleForElementOver(e,l):o&&t.handleForElementOut()}}filterTarget(e){return e.closest(this.forSelector)}realignOnTransitionEnd(e){var t;const r=this,{currentOverElement:n}=Xr;if(pL[e.propertyName]){if(r.allowOver&&r.element.contains(n))return;(t=r.activeTarget)!=null&&t.contains(n)&&!r.trackMouse&&r.realign()}}async handleForElementOver(e,t){const r=this,{activeTarget:n,hideOnDelegateChange:s,anchorToTarget:a}=r,o=t!==n,l=o&&s;if(r.trigger("pointerOver",{event:e,target:t})===!1)r.internalOnPointerOut(e);else{if(r.triggeredByEvent=e,r.hasTimeout("hide")&&(r.abortDelayedHide(),!o))return;if(!s&&r.element.classList.contains("b-hiding")&&r.cancelHideShowAnimation(),!r._hidden&&l&&r.hide(!1),r.activeTarget&&r.hasTimeout("show")&&r.clearTimeout("show"),r.activeTarget=t,r.isVisible){r.lastAlignSpec=null;const d=r.updateContent();if(X.isPromise(d)&&!r.loadingMsg&&await d,r.trigger("beforeShow")===!1)return r.hide();r.alignTo({[a?"target":"position"]:a?t:"mouse",overlap:!(a&&r.anchor)}),r.trigger("show"),r.afterShowByTarget()}else r.activeTarget=t,r.delayShow(t)}}async delayShow(e){var t;const r=this;if((t=r.currentAnimation)!=null&&t.showing&&r.cancelHideShowAnimation(),!r.isVisible&&!r.hasTimeout("show"))if(!r.hoverDelay||r.forSelector&&Date.now()-r.lastHidden<r.quickShowInterval){const n=r.updateContent();X.isPromise(n)&&!r.loadingMsg&&await n,r.showByTarget(e)}else r.addDocumentMouseDownListener(),!r.listeningForMouseMove&&!r.anchorToTarget&&(r.mouseMoveRemover=j.on({element:r.rootElement,mousemove:"onMouseMove",thisObj:r})),r.setTimeout(async()=>{if(r.activeTarget===e&&e.isConnected){const n=r.updateContent();X.isPromise(n)&&!r.loadingMsg&&await n,r.showByTarget(e)}},!r.triggeredByEvent||r.triggeredByEvent.type==="pointerover"?r.hoverDelay:0,"show",!0);else r.isVisible&&r.showByTarget(e)}changeAllowOver(e){return this.inAfterShow||(this.configuredAllowOver=e),e}updateAllowOver(e){var t;const r=this,{element:n}=r;n.classList.toggle("b-allow-over",!!e),e?r.allowOverlisteners=j.on({element:n,mouseenter:"onOwnElementMouseEnter",mouseleave:"internalOnPointerOut",thisObj:r}):(t=r.allowOverlisteners)==null||t.call(r)}updateContent(){const e=this;if(e.getHtml){const t=e.callback(e.getHtml,e,[{tip:e,element:e.element,activeTarget:e.activeTarget,event:e.triggeredByEvent}]);return e.html=t,t}}get hasContent(){return!!(E.isReactElement(this._html)||this._html!==""&&typeof this.html=="string"&&this.html.length||this.items.length)}internalBeforeShow(){return(this.updateContentOnMouseMove||this.hasContent)&&!this.disabled}showAsyncMessage(e=this.optionalL(this.loadingMsg)){e&&(this.html=`
                <div class="b-tooltip-loading">
                    <i class="b-icon b-icon-spinner"></i>
                    ${O.encodeHtml(e)}
                </div>
            `)}showByTarget(e){var t;const r=this,{anchorToTarget:n}=r;r.mouseMoveRemover=(t=r.mouseMoveRemover)==null?void 0:t.call(r),r.showBy({[n?"target":"position"]:n?e:"mouse",overlap:!(n&&r.anchor)})}afterShowByTarget(){const e=this,{dismissDelay:t}=e;e.abortDelayedShow(),t&&e.setTimeout("hide",t),e.element.parentNode&&e.toFront(),!e.mouseMoveRemover&&(e.trackMouse||e.updateContentOnMouseMove)&&(e.mouseMoveRemover=j.on({element:e.rootElement,pointermove:"onMouseMove",thisObj:e})),e.inAfterShow=!0,e.allowOver=e.allowOver||e.configuredAllowOver!=!1&&e.childItems.some(r=>r.isVisible&&!r.disabled&&r.focusElement),e.inAfterShow=!1}updateActiveTarget(e,t){const r=this,n=E.getActiveElement(e);e?(r.isConfiguring||r.trigger("overTarget",{newTarget:e,lastTarget:t}),r.describedElement=e.contains(n)?n:null):(r.trigger("targetOut",{lastTarget:t}),r.describedElement=null)}updateDescribedElement(e,t){e&&E.addAttributeValue(e,"aria-describedby",this.id),t&&E.removeAttributeValue(t,"aria-describedby",this.id)}internalOnPointerOut(e){var t;const r=this,n=e.type==="pointerover"?e.target:e.relatedTarget;r.allowOver&&(r.element.contains(n)||r.owns(n,!0))||r.element.contains(n)&&((t=r.activeTarget)!=null&&t.contains(n))||r.activeTarget&&!r.activeTarget.contains(n)&&r.handleForElementOut()}handleForElementOut(){const e=this,{hideDelay:t}=e;if(e.trigger("pointerOut")===!1)return e.activeTarget=null,!0;e.abortDelayedShow(),e.isVisible&&t!==!1&&(e.abortDelayedHide(),t>0?e.setTimeout("hide",t):e.hide())}show(e){const t=this;!e&&t.forElement&&t.anchorToTarget&&!t.forSelector?t.showByTarget(t.forElement):super.show(...arguments),t.isVisible?t.afterShowByTarget():t.activeTarget=null}get hoverDelay(){var e;return((e=this.triggeredByEvent)==null?void 0:e.pointerType)==="focus"?0:this._hoverDelay}get hideDelay(){var e;return((e=this.triggeredByEvent)==null?void 0:e.pointerType)==="focus"?0:this.autoHide?this._hideDelay:!1}hide(){var e,t;const r=this;if(r.abortDelayedShow(),r._hidden)return yL;{r.abortDelayedHide();const n=super.hide(...arguments);return r.lastHidden=Date.now(),r.activeTarget=null,(e=r.mouseMoveRemover)==null||e.call(r),r.mouseMoveRemover=null,(t=r.transitionEndDetacher)==null||t.call(r),r.transitionEndDetacher=null,n}}abortDelayedShow(){var e,t,r;const n=this;n.hasTimeout("show")&&((e=n.mouseDownRemover)==null||e.call(n),n.mouseDownRemover=null,n.clearTimeout("show"),(t=n.mouseMoveRemover)==null||t.call(n),n.mouseMoveRemover=null,(r=n.transitionEndDetacher)==null||r.call(n),n.transitionEndDetacher=null)}abortDelayedHide(){this.clearTimeout("hide")}realign(){const e=this,t=e.lastAlignSpec;!e.isConfiguring&&!e.isVisible&&(t!=null&&t.targetOutOfView)&&(t.allowTargetOut||E.isInView(t.target,!1,e))&&(e.show(),t.targetOutOfView=!1),super.realign()}alignTo(e){const t=this,r=(t.mouseOffsetX||1)*(t.rtl?-1:1),n=t.mouseOffsetY||1,s=Math.max(Math.min(r,5),0),a=Math.max(Math.min(n,5),0);if(!t.isVisible)return;let o;!t.anchorToTarget&&e.position==="mouse"&&(o=new xi(t.triggeredByEvent.pageX-globalThis.scrollX,t.triggeredByEvent.pageY-globalThis.scrollY),e.position=new xi(o.x+(r||1)-(r<0?t.width:0),o.y+(n||1)-(n<0?t.height:0))),e&&!(t.triggeredByEvent&&t.element.contains(t.triggeredByEvent.target))&&e.nodeType===Node.ELEMENT_NODE&&(e={target:e}),super.alignTo(e),o&&t.lastAlignSpec.result.inflate(a,s).contains(o)&&(t.lastAlignSpec.position="mouse",t.mouseOffsetY=-n,t.mouseOffsetX=-r,t.realign(),t.mouseOffsetY=n,t.mouseOffsetX=r)}set html(e){super.html=e,this.isVisible&&this.realign()}get html(){return super.html}changeHtml(e){const t=this;if(X.isPromise(e)){t.showAsyncMessage(),e.target=t.activeTarget,e.then(r=>{e.target===t.activeTarget&&(t.html=r)});return}return typeof e!="object"&&(e=e!=null?t.optionalL(String(e)):""),e}updateHtml(e,t){const r=this;let n=e==="";n||(super.updateHtml(e,t),r.hasContent?X.isPromise(e)||r.trigger("innerHtmlUpdate",{value:e}):n=!0),n&&r.hide()}onMouseMove(e){const t=this,{forElement:r,activeTarget:n}=t,s=t.hasTimeout("hide"),a=e.target;if(t.triggeredByEvent=e,!t._hidden){let o;const l=n==null?void 0:n.contains(a),d=!l&&t.forSelector&&n&&!s&&a.nodeType===Node.ELEMENT_NODE&&!a.matches(t.forSelector)&&!(t.allowOver&&t.element.contains(a)),c=r!=null&&r.document?r.document.documentElement:r,u=c&&(c.contains?c.contains(a):c.compareDocumentPosition(a)&16);if(d&&(o=t.handleForElementOut()),o||!s||u){if(t.dismissDelay&&!s&&t.setTimeout("hide",t.dismissDelay),t.updateContentOnMouseMove&&t.getHtml&&(t.html=t.callback(t.getHtml,t,[{tip:t,element:t.element,forElement:n,event:e}]),!t.html)){t.hide();return}t.trackMouse&&t.alignTo({position:"mouse",ignorePageScroll:!0})}}}onElementUserAction(e){const{showOnClick:t}=this;(typeof t!="number"||t===e.button)&&(e.button===2&&e.preventDefault(),this.internalOnPointerOver(e))}onOwnElementMouseEnter(e){this.abortDelayedHide()}static getSharedTooltip(e,t,r){var n,s,a;let o=(s=(n=t.bryntum)==null?void 0:n.tooltip)==null?void 0:s.get(Xr);if(!o&&!r){(a=t.bryntum)!=null&&a.tooltip||T.setPath(t,"bryntum.tooltip",new Map);const l=t.bryntum.tooltip;l.set(Xr,!0),o=new Xr({forElement:t,rootElement:e,forSelector:"[data-btip]",resetCfg:{},isSharedTooltip:!0,cls:"b-tooltip-shared",internalListeners:{pointerOver({source:d,target:c}){for(const f in d.resetCfg)f==="listeners"?d.un(d.resetCfg[f].set):f!=="html"&&(d[f]=d.resetCfg[f].was);d.resetCfg={};const u=V.getById(c.id),h=(u==null?void 0:u.tipConfig)||d.gatherDataConfigs(c.dataset);if(u&&u.element!==c||!u&&c.matches(".b-widget")||u!=null&&u.disabled&&!u.showTooltipWhenDisabled)return!1;d._owner=u,d.element.classList.toggle("b-target-disabled",!!(u!=null&&u.disabled));for(const f in h)d.resetCfg[f]={set:h[f],was:d[f]},f==="listeners"?d.ion(h[f]):d[f]=h[f]},hide({source:d}){d.owner=null}},gatherDataConfigs(d){const c=this,u={};for(const h in d)if(h.startsWith("btip"))if(h.length>4){const f=O.uncapitalize(h.substr(4));if(f in c.getDefaultConfiguration()){const g=d[h];u[f]=vL[g]?g==="true":isNaN(g)?g:parseInt(g,10)}}else u.html=d[h];return u},filterTarget(d){const c=d.closest(this.forSelector);if(c)return c;if(Xr.showOverflow&&d.closest(".b-widget"))for(;(d==null?void 0:d.nodeType)===Element.ELEMENT_NODE;){if(E.getStyleValue(d,"text-overflow")==="ellipsis"&&d.clientWidth<d.scrollWidth)return this.html=O.encodeHtml(d.textContent),d;d=d.parentNode}}}),j.on({element:t,mouseenter:d=>Xr.currentOverElement=d.target,keydown:d=>Xr.currentOverElement=d.target,capture:!0,thisObj:o}),l.set(Xr,o)}return o}static encodeConfig(e){const t={};if(typeof e=="string")t.btip=e;else for(const r in e)t[`btip${r==="html"?"":O.capitalize(r)}`]=e[r];return t}};v(iy,"$name","Tooltip"),v(iy,"type","tooltip");var Te=iy;Te.initClass(),Object.defineProperty(V,"tooltip",{get(){return Te.getSharedTooltip(document.body,document.body)}}),V.Tooltip=Te,Te._$name="Tooltip";var hg=class extends gc{static get configurable(){return{align:"t10-b50",offset:20,tooltip:{$config:["lazy","nullify"],value:{type:"tooltip"}}}}open(){this.getConfig("tooltip")}close(){var i;(i=this.tooltip)==null||i.hide()}dragMove(i){const{offset:e,tooltip:t}=this,{event:r}=i;t&&(t.isVisible||t.show(),t.alignTo({align:this.align,target:new k(r.clientX-e,r.clientY-e,e*2,e*2)}))}changeTooltip(i,e){return V.reconfigure(e,i,this)}};v(hg,"type","tip"),hg.initClass(),hg._$name="DragTipProxy";var ry=i=>{var e;return e=class extends(i||$){get hasLabel(){return!!this.label}compose(){const{hasLabel:t,labelPosition:r}=this;return{class:{[`b-label-${r}`]:t,"b-has-label":t}}}changeLabel(t){return t||""}setupLabel(t){return T.assign({tag:"label",for:`${this.id}-input`,class:`b-label b-align-${t.align||"start"}`},t)}updateLabelWidth(t){this.labelElement&&(this.labelElement.style.flex=`0 0 ${E.setLength(t)}`,this.inputWrap.style.flexBasis=t==null?"":"auto")}get widgetClass(){}},v(e,"$name","Labelable"),v(e,"configurable",{label:null,labelPosition:"before",labelCls:null,labelWidth:{value:null,$config:{localeKey:"L{labelWidth}"}}}),e},yc=(i=$)=>{var e;return e=class extends i.mixin(qe){get widgetClass(){}doDestroy(){const t=this,r=t._rootElement&&t.constructor.getSharedErrorTooltip(t._rootElement,{doNotCreate:!0,cachePath:t.errorTooltipCachePath});super.doDestroy(),(r==null?void 0:r.field)===t&&r.hide()}get errorTip(){return this.constructor.getSharedErrorTooltip(this.rootElement,{cachePath:this.errorTooltipCachePath,tooltipConfig:this.errorTooltipConfig})}static get errorTip(){return this.getSharedErrorTooltip(document.body)}static getSharedErrorTooltip(t,r={}){var n;const{doNotCreate:s,cachePath:a="errorTooltip",tooltipConfig:o}=r;let l=(n=t.bryntum)==null?void 0:n[a];return!l&&!s&&(t.bryntum=t.bryntum||{},l=Te.new({cls:"b-field-error-tip",forSelector:".b-field.b-invalid .b-field-inner",align:{align:"l-r",monitorTargetMutation:!0},axisLock:"flexible",scrollAction:"realign",trapFocus:!1,rootElement:t,onBeforeShow(){const d=this,c=V.fromElement(d.activeTarget);if(c){const u=c.getErrors();if(u)return d.html=u.join("<br>"),d.field=c,!0}return!1}},o),t.bryntum[a]=l),l}setError(t,r,n){const s=this;if((s.errors||(s.errors={}))[t]=s.optionalL(t),r||s.syncInvalid(),n){const a=()=>{s.clearError(t),o()},o=s.ion({keydown:a,focusOut:a})}}clearError(t,r){const n=this;n.errors&&(t?delete n.errors[t]:n.errors={}),r||n.syncInvalid()}getErrors(){const t=this;if(!t.isValid){const r=t.validity,n=T.keys(r).find(o=>o!=="valid"&&o!=="customError"&&r[o]),s=t.errors&&Object.values(t.errors);let a;if(s!=null&&s.length?a=s:r.customError?a=[t.input.validationMessage]:n?a=[t.L(n,{min:t.min,max:t.max})]:a=[t.L(t.invalidValueError)],(a==null?void 0:a.length)>0)return a}}syncInvalid(){const t=this,{isPainted:r}=t;if(t.updatingInvalid=!0,r){const{isValid:n,element:s,inputWrap:a}=t;if(s.classList[n?"remove":"add"]("b-invalid"),n){const o=t.constructor.getSharedErrorTooltip(t.rootElement,{doNotCreate:!0,cachePath:this.errorTooltipCachePath});o!=null&&o.isVisible&&o.field===t&&o.hide()}else if(a){const o=t.errorTip;o&&(t.containsFocus||t.isVisible&&a.contains(Te.currentOverElement))&&(o.activeTarget===a&&o.isVisible?o.onBeforeShow():(o.activeTarget=a,o.showBy(a)))}}t.updatingInvalid=!1}},v(e,"$name","Validatable"),e},bc=class extends dt{static get configurable(){return{animation:{duration:300},collapsed:null,collapser:{value:null,$config:"nullify"},syncableConfigs:null,syncConfigTriggers:{$config:{merge:"classList"},value:null},testConfig:{animation:{duration:10}}}}static get delayable(){return{syncChildConfigs:"raf"}}get inline(){var i;return(i=this.owner.inline)!=null?i:this.ensureItems().count===1}changeCollapsed(i){if(this.togglingCollapse)return this.togglingCollapse=!1,i;this.toggleCollapse(!!i)}updateCollapsed(i){var e;this.collapser=(e=this.collapser)==null?void 0:e.destroy(),this.setCollapsedCls(i)}updateCollapser(i,e){e&&e.completed==null&&(!e.reverting||!i)&&e.destroy(),this.setOwnerCls("b-collapsing",i)}get collapsing(){const{collapser:i}=this;return i!=null&&i.collapsed}get collapsingExpanding(){return this.collapser!=null}get expanding(){const{collapser:i}=this;return i!=null&&!i.collapsed}collapse(i){this.toggleCollapse(!0,i)}expand(i){this.toggleCollapse(!1,i)}setCollapsedCls(i){this.setOwnerCls("b-collapsed",i)}setOwnerCls(i,e){var t,r;(r=(t=this.owner)==null?void 0:t.element)==null||r.classList[e?"add":"remove"](i)}syncChildConfigs(){const i=this,{owner:e,syncableConfigs:t}=i;if(t){let r,n;for(r in t)n=t[r](e),i.eachWidget(s=>{s[r]=n},!1)}e.afterSyncChildConfigs(i)}syncContainer(){const{inline:i,layout:e}=this;this.autoLayout&&(e.horizontal=i,e.justify=i?"center":"stretch")}toggleCollapse(i,e){const t=this,{animation:r,collapser:n,inline:s}=t,{containerWrapElement:a}=t.owner,o=l=>{l&&(t.element.style.height="",t.togglingCollapse=!0,t.collapsed=i,t.collapser=null)};if(i==null&&(i=!t.collapsed),e!==!1&&e!==null&&(!a||!t.isVisible?e=null:(e===!0?e={}:typeof e=="number"&&(e={duration:e}),e=r||e?T.merge({},r,e):null)),!e)t.togglingCollapse=!0,t.collapsed=i;else if(n&&i!==n.collapsed)t.collapser=n.revert({finalize:o}),t.collapser.collapsed=i;else if(!n&&i!==t.collapsed){!i&&t.setCollapsedCls(!1);const{element:l}=t,{height:d}=l.getBoundingClientRect(),c=s?1:d;!i&&t.setCollapsedCls(!0),l.style.height=`${d}px`,t.collapser=Tt.run(T.merge({finalize:o,element:a,[s?"opacity":"height"]:{from:i?c:0,to:i?0:c}},e)),t.collapser.collapsed=i}}};v(bc,"$name","FieldContainer"),v(bc,"type","fieldcontainer"),bc.initClass(),bc._$name="FieldContainer";var bL=(i,e)=>(i.weight||0)-(e.weight||0),CL=(i,e)=>(e.weight||0)-(i.weight||0),ny=[],SL={align:!0,weight:!0},sy=class qS extends V.mixin(zv,ry,yc){static get configurable(){return{defaultBindProperty:"value",skipValidation:null,placeholder:null,value:"",name:null,labels:null,required:null,clearable:null,revertOnEscape:null,hint:null,hintHtml:null,inputWidth:null,keyStrokeChangeDelay:0,readOnly:null,editable:!0,defaultAction:"change",stepTriggers:null,triggers:null,highlightExternalChange:!1,localizableProperties:["label","title","placeholder","labelWidth"],autoSelect:!1,autoComplete:"off",spellCheck:null,validateOnInput:!0,inputAttributes:null,inputType:"text",inputAlign:null,attributes:{value:["placeholder","autoComplete","spellCheck","minLength","maxLength","pattern","tabIndex","min","max"],$config:{merge:"distinct"}},nullValue:{$config:null,value:null,default:null},updatedClsDuration:500,inputReadOnly:!1,ariaElement:"input",container:{$config:"nullify",value:null},containerDefaults:{type:"fieldcontainer",syncableConfigs:{disabled:e=>e.disabled},syncConfigTriggers:{disabled:1}},containValues:null,inline:null,testConfig:{updatedClsDuration:10},keyMap:{},twinSyncConfigs:["value"]}}static get delayable(){return{highlightChanged:"raf"}}doDestroy(){var e,t,r;const n=this,{triggers:s}=n;if((e=n.inputListenerRemover)==null||e.call(n),(t=n.keyListenerRemover)==null||t.call(n),(r=n.container)==null||r.destroy(),super.doDestroy(),s)for(const a of Object.values(s))a.destroy()}get childItems(){const{container:e,triggers:t}=this,r=t?Object.values(t):[];return e?[...r,...e.childItems]:r}get invalidValueError(){return"L{invalidValue}"}construct(e){super.construct(e);const t=this;t.keyStrokeChangeDelay&&(t.changeOnKeyStroke=t.buffer(t.internalOnChange,t.keyStrokeChangeDelay))}changeKeyMap(e){var t;const r=this;let n={};e&&(r._fieldKeyMap?T.assign(n,r._fieldKeyMap):(r._fieldKeyMap=e,T.assign(n,e)));for(const s in r.triggers)(t=r.triggers[s])!=null&&t.keyMap&&(n=r.mergeKeyMaps(n,r.triggers[s].keyMap,s));return n}get keyMapSubComponents(){return this.triggers}onFocusIn(e){const t=this;t.valueOnFocus=T.clone(t.value),t.validOnFocus=!(t.errors&&Object.keys(t.errors).length),super.onFocusIn(e),t.focusing=!0,t.syncInvalid(),t.focusing=!1}onFocusOut(e){super.onFocusOut(e),this.syncRequired(),this.onEditComplete()}onEditComplete(){}get rootUiClass(){return qS}compose(){this.getConfig("clearable");const e=this,{container:t,innerElements:r,label:n,labels:s,labelCls:a,readOnly:o,stepTriggers:l,triggers:d}=e,c=T.values(d,(m,p)=>!p),u=c.filter(m=>m.align==="start").sort(bL),h=c.filter(m=>m.align!=="start").sort(CL),f=e.setupLabel.bind(e),g=[...u.map(m=>m.element),...r,...h.map(m=>m.element)];return{class:{"b-has-step-triggers":l,"b-has-start-trigger":u.length,"b-no-input":!r.length,"b-readonly":o,"b-field-container":!!t,"b-field-container-inline":t==null?void 0:t.inline},children:[...(s||ny).filter(m=>m&&m.align!=="end").map(f),(n||null)&&f({reference:"labelElement",class:`b-label b-align-start ${a||""}`,html:n}),g.length?{class:"b-field-inner",reference:"inputWrap",children:g}:null,...(s||ny).filter(m=>(m==null?void 0:m.align)==="end").map(f),...t?[{reference:"containerWrapElement",children:[t.element],class:{"b-field-container-wrap":1}}]:ny]}}updateElement(e,t){var r;const n=this,s=n.initialConfig.value,{input:a}=n;super.updateElement(e,t),s!=null&&(n.value=s),n.syncEmpty(),n.updateInputReadOnly(n.inputReadOnly),n.syncInvalid();const o=a||n.focusElement;(r=n.keyListenerRemover)==null||r.call(n),n.keyListenerRemover=o&&j.on({element:o,thisObj:n,keydown:"internalOnKeyEvent",keypress:"internalOnKeyEvent",keyup:"internalOnKeyEvent"})}get innerElements(){return[this.inputElement]}get inputElement(){const{attributes:e,inputAttributes:t,id:r,inputCls:n,inputType:s,name:a}=this,o=T.assign({reference:"input",tag:"input",type:s,name:a||r,id:`${r}-input`,retainElement:!0},t);n&&(o.class=n);for(let l,d,c=e.length;c-- >0;)l=e[c],d=this[l],d!=null&&(o[l]=d);return o}get caretPos(){return this.textSelection[0]}set caretPos(e){this.textSelection=e}get focusElement(){return this.input}get textSelection(){var e;const t=this.input;let r;try{r=[t.selectionStart,t.selectionEnd,t.selectionDirection]}catch(n){r=((e=t.value)==null?void 0:e.length)||0,r=[r,r]}return r}set textSelection(e){typeof e=="number"?this.select(e,e):this.select(...e)}get hasTextSelection(){const[e,t]=this.textSelection;return e&&t-e>0}getAfterValue(e){const[t,r]=this.textSelection,n=this.input.value;return`${n.substr(0,t)}${e}${n.substr(r||t)}`}select(e,t){const r=this.focusElement;if(r.value.length){if(arguments.length===0){this.selectAll();return}if(!this.supportsTextSelection)return;r.setSelectionRange(e,t)}}moveCaretToEnd(){const e=this.input;if(e.createTextRange){const t=e.createTextRange();t.collapse(!1),t.select()}else this.supportsTextSelection&&this.select(e.value.length,e.value.length)}selectAll(){this.focusElement.select()}get caretAtEnd(){return this.textSelection[1]===this.input.value.length}get caretAtStart(){return!this.textSelection[1]}get selectedAll(){const{textSelection:e}=this;return!e[0]&&e[1]===this.input.value.length}syncEmpty(){var e;const{isEmptyInput:t,isEmpty:r,element:n}=this,s=(e=this.triggers)==null?void 0:e.clear,a=t&&r;n&&(s&&s[a?"hide":"show"](),n.classList.toggle("b-empty",a))}updateHint(){this.syncHint()}updateHintHtml(){this.syncHint()}syncHint(){const e=this,{input:t,hint:r,hintHtml:n}=e,s=t==null?void 0:t.parentElement;if(t){let a=n||r;const o=e.hintElement||a&&(e.hintElement=E.createElement({parent:s,className:"b-field-hint",nextSibling:t.nextSibling,children:[{className:"b-field-hint-content"}]}));o&&(typeof a=="function"&&(a=a({source:e,value:e.value})),o.firstChild[n?"innerHTML":"textContent"]=a||""),e.element.classList[a?"remove":"add"]("b-field-no-hint")}}updateEditable(){this.syncInputReadOnly()}syncInputReadOnly(){this.getConfig("readOnly"),this.inputReadOnly=this._readOnly||this.editable===!1}updateInputReadOnly(e){const t=this,{input:r,inputListenerRemover:n}=t;r&&(r.readOnly=e?"readOnly":null,e?t.inputListenerRemover=n==null?void 0:n():n||(t.inputListenerRemover=j.on({element:r,thisObj:t,focus:"internalOnInputFocus",change:"internalOnChange",input:"internalOnInput"})))}changeReadOnly(e){return!!e}updateReadOnly(e){this.syncInputReadOnly()}updateClearable(e){const t=this;t.getConfig("triggers"),t.triggers={clear:e&&T.assign({cls:"b-icon-remove",weight:1e3,key:"Shift+backspace",handler(){t.clear(...arguments)}},e)||null}}changeTriggers(e,t){const r=this,n=r.$triggers||(r.$triggers=new ps({configName:"triggers",factory:qS.Trigger,inferType:!1,owner:r,created(s){Se.after(s,"onConfigChange",(a,{name:o})=>{SL[o]&&r.onConfigChange({name:"triggers",value:n.target})})},setup(s,a){s.reference=s.ref=a,s.parent=r}}));if(e&&!r.stepTriggers&&(e.back||e.forward)&&(e=T.assign({},e),delete e.back,delete e.forward),n.update(e),r.element&&(r.keyMap=r.keyMap),!t)return n.target}updateInputWidth(e){this.input.style.width=E.setLength(e),this.element.classList.add("b-has-width")}updateInputAlign(e){this.input.style.textAlign=e}get isValid(){const e=this;if(!e.disabled&&!e.skipValidation){if(e.syncRequired(),e.checkValidity&&e.callback(e.checkValidity,e,[e]),e.errors&&Object.keys(e.errors).length)return!1;const t=e.validity;if(t)return t.valid}return!0}get isEmpty(){return this.value==null||this.value===""}get isEmptyInput(){return!this.input||this.input.value==null||this.input.value===""}get validity(){const e=this.input;return e==null?void 0:e.validity}async setValue(e){this.value=e}changeValue(e,t){return e==null&&(e=this.nullValue),this.hasChanged(t,e)?e:(e===""&&this.syncRequired(),t)}updateValue(e,t){const r=this;r.isConfiguring||(r.syncRequired(),r.inputting||r.triggerChange()),r.inputting||(r._lastValue=e),r.syncInputFieldValue()}hasChanged(e,t){return t!==e}syncInputFieldValue(e=!1){const t=this,{input:r,parent:n,inputValueAttr:s,inputValue:a}=t;if(r&&!t.inputting&&r[s]!==a&&(r[s]=a,!t.isConfiguring&&!t.containsFocus&&t.highlightExternalChange)){if(r.classList.remove("b-field-updated"),t.clearTimeout("removeUpdatedCls"),n){const{assigningValues:o}=n;(o===!0||(o==null?void 0:o.highlight)===!1)&&(e=!0)}e||t.highlightChanged()}t.syncEmpty(),t.syncInvalid()}highlightChanged(){this.input.classList.add("b-field-updated"),this.setTimeout("removeUpdatedCls",this.updatedClsDuration)}removeUpdatedCls(){this.input.classList.remove("b-field-updated")}get inputValue(){return this.value==null?"":this.value}get inputValueAttr(){return"value"}get supportsTextSelection(){const e=this.focusElement;return e&&(e.tagName.toLowerCase()==="textarea"||e.type&&/text|search|password|tel|url/.test(e.type))}internalOnInputFocus(){this.autoSelect&&this.selectAll()}internalOnChange(e){const t=this;t.hasChanged(t._lastValue,t.value)&&t.isValid&&(t.triggerChange(e,!0),t._lastValue=t.value)}triggerChange(e,t=!!this._isUserAction){const r=this,{value:n,_lastValue:s,isValid:a}=r;r.syncHint(),r.triggerFieldChange({value:n,oldValue:s,event:e,userAction:t,valid:a}),r.defaultAction==="change"&&r.trigger("action",{value:n,oldValue:s,event:e,userAction:t,valid:a})}fetchInputValue(){this.value=this.input[this.inputValueAttr]}internalOnInput(e){var t;const r=this;r.validateOnInput||r.errorTip.hide(),r.inputting=!0,r.fetchInputValue(),r.inputting=!1,r.trigger("input",{value:r.value,event:e}),(t=r.changeOnKeyStroke)==null||t.call(r,e)}get needsInputSync(){var e;return this.input[this.inputValueAttr]!==String((e=this.inputValue)!=null?e:"")}internalOnKeyEvent(e){const t=this,{value:r}=t;let n=!1;if(e.type==="keydown"&&e.key==="Escape"&&!(t.readOnly||t.disabled)){const s=t.isValid,a="initialValue"in t?t.initialValue:t.valueOnFocus,o=t.hasChanged(a,r),{needsInputSync:l}=t;t.revertOnEscape&&(!s||o||l)?(o&&(t.value=a),l&&t.syncInputFieldValue(!0),t.clearError(),n=(o||l)&&t.isValid||s!==t.validOnFocus):!t.isEmpty&&t.clearable&&t.revertOnEscape&&(t.clear(),e.stopPropagation())}t.isDestroyed||(n&&e.stopImmediatePropagation(),t.trigger(e.type,{event:e}))}clear(e){const t=this,{value:r}=t;(r!==t.nullValue||t.input.value.length>0)&&(t.value=t.nullValue,t.clearError(),t.syncInvalid(),t.trigger("clear",{event:e}))}onDisabled(){this.syncInvalid()}syncRequired(){var e;const t=this;!t.isConfiguring&&(!t.focusing||t.accessibility)&&t.required&&t.isEmpty&&!((e=t.parent)!=null&&e.isSettingValues)?t.setError("L{fieldRequired}",t.updatingInvalid):t.clearError("L{fieldRequired}",t.updatingInvalid)}get containerCollapsed(){var e;return(e=this.container)==null?void 0:e.collapsed}set containerCollapsed(e){const{container:t}=this;t&&(t.collapsed=e)}afterSyncChildConfigs(e){}changeContainer(e,t){e&&(Array.isArray(e)||!("type"in e||"items"in e))&&(e={items:e});const r=this,n=e&&T.merge({owner:r,layout:"box"},r.containerDefaults),s=V.reconfigure(t,e,{owner:r,defaults:n});if(s&&(s.autoLayout=(n==null?void 0:n.layout)==="box",s===t)){s.syncContainer();return}return s}onConfigChange(e){var t,r;super.onConfigChange(e),(r=(t=this.container)==null?void 0:t.syncConfigTriggers)!=null&&r[e.name]&&this.container.syncChildConfigs()}assignValue(e,t){const r=this,{container:n,containValues:s}=r,a=r.getValueName(t),o=e&&a in e;n&&s!==!1?e&&s==="nested"?o&&(e=T.clone(e[a]),super.assignValue({[a]:e&&!("value"in e)||e.value},t),e&&delete e.value,n.assignValue(e,t)):(super.assignValue(e,t),n.assignValue(e,t)):super.assignValue(e,t)}gatherValue(e){super.gatherValue(e),this.gatherValues(e)}gatherValues(e,t){const r=this,{container:n,containValues:s,valueName:a}=r,o=typeof s;t=t!=null?t:a in e,n&&s!==!1&&(s==="nested"?t&&(e[a]={value:e[a],...n.values}):(s===!0||s==null&&t||o==="string"&&r[s]||o==="function"&&s(r))&&n.gatherValues(e))}updateContainer(e,t){t&&this.detachListeners(t.id),e&&(e.rendered||e.render(),e.syncContainer(),e.syncChildConfigs())}};v(sy,"$name","Field"),v(sy,"type","field");var ct=sy,Cc;ct.Trigger=(Cc=class extends V{static get factoryable(){return{defaultType:ct.Trigger,extends:null}}get field(){return this.parent}construct(){super.construct(...arguments),this.key&&(this.keyMap={[this.key]:"onClick"})}compose(){return{"aria-hidden":!0,class:{[`b-align-${this.align||"end"}`]:1,"b-icon":1},listeners:{click:"onClick",mousedown:"onMousedown"}}}changeAlign(i){return i}onClick(i){const e=this,{field:t}=e;t.disabled||t.readOnly||(i.key&&i.preventDefault(),t.trigger("trigger",{trigger:e})!==!1&&e.handler&&(t._isUserAction=!0,t.callback(e.handler,t,[i,e]),t._isUserAction=!1))}onMousedown(i){const e=this.field;!("key"in i)&&E.isTouchEvent&&e.editable&&(e.editable=!1,e.setTimeout(()=>e.editable=!0,500)),i.preventDefault(),E.getActiveElement(e.input)!==e.input&&e.focus()}},v(Cc,"$name","FieldTrigger"),v(Cc,"type","trigger"),v(Cc,"configurable",{align:null,weight:null,role:null}),Cc);var Sc;ct.SpinTrigger=(Sc=class extends ct.Trigger{compose(){return{children:{upButton:{class:{"b-icon":1,"b-spin-up":1}},downButton:{class:{"b-icon":1,"b-spin-down":1}}}}}updateRepeat(i){var e;(e=this.clickRepeater)==null||e.destroy(),this.clickRepeater=i?Xf.new({element:this.element},i):null}onClick(i){const e=this,{field:t}=e;t._isUserAction=!0,t.disabled||t.readOnly||(i.target===e.upButton?t.doSpinUp(i.shiftKey):i.target===e.downButton&&t.doSpinDown(i.shiftKey)),t._isUserAction=!1}get isFocusable(){return!this.disabled&&super.isFocusable}},v(Sc,"$name","SpinTrigger"),v(Sc,"type","spintrigger"),v(Sc,"configurable",{repeat:{$config:["nullify"],value:!0}}),Sc),ct.Trigger.initClass(),ct.SpinTrigger.initClass(),V.register(ct.Trigger,"trigger"),V.register(ct.SpinTrigger,"spintrigger"),ct._$name="Field";var Fi=class extends ct{construct(i){(i==null?void 0:i.inputType)==="hidden"&&(i.hidden=!0),super.construct(...arguments)}};v(Fi,"$name","TextField"),v(Fi,"type","textfield"),v(Fi,"alias","text"),v(Fi,"configurable",{nullValue:""}),Fi.initClass(),Fi._$name="TextField";var _r=class extends Fi{static get configurable(){return{editable:!0,pickerAlignElement:"inputWrap",value:null,triggers:{expand:{cls:"bars"}},autoExpand:null,picker:{value:{floating:!0},$config:["lazy","nullify"]},inputType:"text",monitorResize:!0,nullValue:null}}doDestroy(){var i;(i=this.globalTapListener)==null||i.call(this),super.doDestroy()}changeEditable(i){return K.isMobile&&this.initialConfig.editable!==!0&&(i=!1),i}updateEditable(i){var e;const t=this,{element:r,ariaElement:n,nonEditableClickTarget:s}=t,{expand:a}=t.triggers,o=globalThis.matchMedia("(max-width: 410px)").matches;super.updateEditable(...arguments),r.classList.toggle("b-not-editable",!i),i===!1?(K.isMobile&&o&&(a==null||a.hide()),n==null||n.removeAttribute("aria-autocomplete"),(e=t.globalTapListener)==null||e.call(t),s&&j.on({element:s,click:l=>{const d=s.getRootNode().elementFromPoint(l.clientX,l.clientY);l.target===s&&d===s&&t.onTriggerClick(l)},thisObj:t})):(a==null||a.show(),n==null||n.setAttribute("aria-autocomplete","list"),t.globalTapListener=ue.ion({globaltap:"showKeyboard",thisObj:t}))}get nonEditableClickTarget(){return this.input}updateElement(i,e){var t;const r=super.updateElement(i,e),n=this.peekConfig("picker"),s=n?n.isWidget?n.role:(t=this.constructor.resolveType(n.type))==null?void 0:t.$meta.config.role:!1;return E.setAttributes(this.ariaElement,{"aria-expanded":!1}),this.ariaHasPopup=s,r}get pickerAlignElement(){const{_pickerAlignElement:i}=this;return i.nodeType===Node.ELEMENT_NODE?i:T.getPath(this,i)}changePicker(i,e){throw new Error("changePicker() must be implemented in PickerField subclass implementations")}updatePicker(i){this.detachListeners("pickerField.picker"),i==null||i.ion({name:"pickerField.picker",thisObj:this,show:"onPickerShow",hide:"onPickerHide"})}get childItems(){const i=super.childItems;return this._picker&&i.push(this.picker),i}onEditComplete(){super.onEditComplete(),this.hidePicker()}onElementResize(i){const e=this;e.pickerVisible&&e.picker.requestAnimationFrame(e.picker.realign,null,e.picker),super.onElementResize(i)}internalOnKeyEvent(i){const e=this;let t=!0;if(i.type==="keydown"&&!e.disabled&&!i.shiftKey&&!i.ctrlKey)if(e.pickerVisible){const{picker:r}=e;i.key==="Escape"?(i.preventDefault(),i.stopImmediatePropagation(),e.hidePicker(),t=!1):r.onInternalKeyDown?r.onInternalKeyDown(i):i.key==="ArrowDown"&&r.focusable&&r.focus()}else i.key==="ArrowDown"&&e.picker&&e.onTriggerKeyDown(i);t&&super.internalOnKeyEvent(i)}onFocusIn(i){var e;const t=this,r=(e=ue.currentPointerDown)==null?void 0:e.target;super.onFocusIn(i),t.autoExpand&&!(r!=null&&r.matches(".b-fieldtrigger"))&&(t.minChars=0,t.onTriggerClick(i))}onTriggerClick(i){this.disabled||this.togglePicker("key"in i)}onTriggerKeyDown(i){this.trigger("triggerKey",{event:i})!==!1&&(i.stopImmediatePropagation(),i.preventDefault(),this.onTriggerClick(i))}showKeyboard({event:i}){const e=this.input;E.isTouchEvent&&E.getActiveElement(e)===e&&i.target===e&&(ue.suspendFocusEvents(),e.blur(),e.focus(),ue.resumeFocusEvents())}togglePicker(i){this.pickerVisible?this.hidePicker():this.showPicker(i)}showPicker(i){const e=this,{picker:t}=e;t&&(E.setAttributes(e.ariaElement,{"aria-controls":t.id,"aria-expanded":!0}),t.show(),t.isVisible&&i&&e.focusPicker())}onPickerShow(){const i=this;i.pickerVisible=!0,i.element.classList.add("b-open"),i.trigger("togglePicker",{show:!0}),i.pickerTapOutRemover=ue.ion({globaltap:"onPickerTapOut",thisObj:i}),i.pickerKeyDownRemover=j.on({element:i.picker.element,keydown:"onPickerKeyDown",thisObj:i})}onPickerHide(){var i,e,t;const r=this;(i=r.ariaElement)==null||i.setAttribute("aria-expanded",!1),r.pickerVisible=!1,r.element.classList.remove("b-open"),r.trigger("togglePicker",{show:!1}),(e=r.pickerTapOutRemover)==null||e.call(r),(t=r.pickerKeyDownRemover)==null||t.call(r)}onPickerTapOut({event:i}){!this.containsFocus&&!this.owns(i.target)&&this.hidePicker()}onPickerKeyDown(i){if(i.key==="Tab"&&!this.picker.trapFocus){const e=E.getActiveElement(this.input),t=new KeyboardEvent("keydown",i);this.input.dispatchEvent(t),t.defaultPrevented&&i.preventDefault(),E.getActiveElement(this.input)===e?this.input.focus():i.preventDefault(),this.isDestroyed||this.hidePicker()}}hidePicker(){this.pickerVisible&&this.picker.hide()}focusPicker(){}focus(){const i=this.input;E.isTouchEvent&&this.editable&&(i.readOnly=!0,this.setTimeout(()=>i.readOnly=!1,500)),super.focus()}};v(_r,"$name","PickerField"),v(_r,"type","pickerfield"),_r._$name="PickerField";var hn=document.createRange(),pi=class extends V{construct(i,...e){var t;const r=this;Array.isArray(i)&&(i={items:i}),super.construct(i,...e);const{element:n}=r,{classList:s}=n;r.multiSelect&&s.add("b-multiselect"),(t=r.store)!=null&&t.count?r.refresh():s.add("b-empty"),j.on({element:n,delegate:r.itemSelector,mouseover:"onMouseOver",thisObj:r}),j.on({element:n,click:"onClick",thisObj:r})}doDestroy(){var i;this.detachListeners("store"),(i=this.navigator)==null||i.destroy(),super.doDestroy()}onFocusIn(i){var e;this.restoreActiveItem((e=i._target)==null?void 0:e.closest(this.itemSelector)),super.onFocusIn(i)}get isVirtualized(){return typeof this.virtualize=="number"?this.store.count>this.virtualize:!!this.virtualize}outOfViewTpl(i,e){return`<li class="b-list-item b-out-of-view" data-index="${e}" data-id="${O.encodeHtml(i.id)}"></li>`}onItemIntersection(i,e){if(e){const t=parseInt(i.dataset.index),r=this.store.getAt(t);E.sync(this.itemWrapperTpl(r,t),i),this.itemIntersectionObserver.unobserve(i)}}contentTpl(){const i=this,e=Math.ceil(i.height/i.listItemHeight),t=i.store.records.map((r,n)=>!i.isVirtualized||n<e?i.itemWrapperTpl(r,n):i.outOfViewTpl(r,n));return i.multiSelect&&i.selectAllItem!==!1&&t.unshift(i.selectAllItemTpl()),i.title&&t.unshift(`<li class="b-list-item b-list-title">${i.title}</li>`),mi.tpl`${t}`}itemWrapperTpl(i,e){const t=this,{selected:r,getItemStyle:n,store:s,tooltipTemplate:a}=t,o=(a==null?void 0:a(i))||"",l=`style="${n?t.callback(n,t,[i]):""};--tree-level:${i.childLevel||0}"`,d=t.callback(t.isSelectable,t,[i]);return s.isGrouped&&!i.isGroupHeader&&i.instanceMeta(s).groupParent.meta.collapsed||!i.ancestorsExpanded(s)?"":mi.tpl`<li ${l} class="${t.getItemClasses(i,e)}" role="option" ${o?`data-btip="${O.encodeHtml(o)}"`:""} aria-selected="${r.includes(i)}" data-index="${e}" ${d?"":"data-noselect"} data-id="${O.encodeHtml(i.id)}" ${t.itemsFocusable?'tabindex="-1"':""}>${t.itemContentTpl(i,e)}</li>`}itemContentTpl(i,e){if(i.isGroupHeader||i.isParent&&this.store.excludeCollapsedRecords!==!1){let t=this.groupHeaderTpl(i,i.isParent?this.itemTpl(i,e):O.capitalize(i.meta.groupRowFor));if(this.collapsibleGroups||i.isParent){const r=i.isParent?i.instanceMeta(this.store).collapsed:i.meta.collapsed;t+=`<button class="b-button b-tool b-icon b-icon-collapse-${r?"right":"down"} b-list-expander-icon" data-noselect></button>`}return t}return`${this.itemIconTpl(i,e)}${this.itemTpl(i,e)}`}itemIconTpl(i,e){return this.multiSelect&&this.callback(this.isSelectable,this,[i])?`<i class="b-selected-icon b-icon ${this.selectIconCls}"></i>`:""}selectAllItemTpl(){const i=this.allSelected?"b-selected":"";return`<li class="${this.itemCls} b-select-all-item ${i}" data-noselect data-select-all data-id="select-all" ${this.itemsFocusable?'tabindex="-1"':""}>${this.itemIconTpl({})}<div>${this.L("selectAll")}</div></li>`}getItemClasses(i){var e,t;const r=this,{getItemCls:n}=r,s=(e=r._navigator)==null?void 0:e.activeItem,a=(s==null?void 0:s.dataset.id)==i.id,o="groupRowFor"in i.meta?"b-list-item-group-header":i.isParent?"b-list-item-tree-parent":"",l=r.selected.includes(i)||((t=i.groupChildren)==null?void 0:t.every(c=>r.selected.includes(c))),d=n?this.callback(n,this,[i]):"";return`${r.itemCls} ${i.cls||""} ${d} ${l?r.selectedCls:""} ${a?r.navigator.focusCls:""} ${o}`}onBeforeStoreLoad(){this.mask(this.L("L{loading}"))}onAfterStoreRequest(){this.unmask()}onStoreChange({source:i,action:e,records:t,record:r,changes:n,isCollapse:s}){const a=this,{selected:o}=a;switch(e){case"dataset":{o.match(i.storage,!a._externallyOwnedSelection);break}case"remove":s||o.remove(t);break;case"clear":a.deselectAll();break;case"update":{const{id:l}=n;l&&E.setAttributes(a.contentElement.querySelector(O.encodeAttributeSelector("data-id",l.oldValue)),{"data-id":l.value}),a.refreshItem(r);return}}a.refresh()}onStoreRefresh(){this._selected?this.refresh():this.getConfig("selected")}refresh(){var i;const e=this;if(e.isVisible&&e.store){const t=(i=e.navigator)==null?void 0:i.activeItem;e.itemIntersectionObserver&&(e.itemIntersectionObserver.disconnect(),e.itemIntersectionObserver=null),e.paintListener=null;const r=E.createElementFromTemplate(e.contentTpl(),{fragment:!0});if(e.clearItems().insertNode(r),e.element.classList.toggle("b-virtualized",e.isVirtualized),e.isVirtualized){e.itemIntersectionObserver=new IntersectionObserver(n=>{for(const s of n)e.onItemIntersection(s.target,s.isIntersecting,s)});for(const n of e.element.querySelectorAll(e.itemSelector))e.itemIntersectionObserver.observe(n);e.listItemHeight=e.element.children[0].clientHeight}t&&e.restoreActiveItem(t),e.refreshCount=(e.refreshCount||0)+1,e.element.classList.toggle("b-empty",e.store.count===0),e.updateSelectAllState()}else e.paintListener||(e.paintListener=e.once("paint","refresh"))}clearItems(){const i=this,{contentElement:e}=i,t=e.querySelector(i.itemSelector),r=e.lastChild;if(t){const n=e.querySelectorAll(`${i.itemSelector}:not(.b-mask)`);hn.setStartBefore(t),hn.setEndAfter(n[n.length-1]),hn.deleteContents()}else r?(hn.setStartAfter(r),hn.setEndAfter(r)):(hn.setStart(e,0),hn.setEnd(e,0));return hn}refreshItem(...i){for(const e of i){const t=this.getItem(e);if(t){const r=this.store.indexOf(e),n=E.createElementFromTemplate(this.itemWrapperTpl(e,r));E.sync(n,t)}}}getItem(i){if(i!=null)return typeof i=="number"?this.contentElement.querySelector(`[data-index="${i<0?this.store.count+i:i}"]`):(i.nodeType===Element.ELEMENT_NODE&&(i=i.dataset.id),(i==null?void 0:i.id)!=null&&(i=i.id),this.contentElement.querySelector(O.encodeAttributeSelector("data-id",i)))}getRecordFromElement(i){return i.target&&(i=i.target),i=i.closest(this.itemSelector),this.store.getAt(parseInt(i.dataset.index))}updateItems(i){this.store.data=H.asArray(i!=null?i:[]).map(e=>typeof e=="string"?{[this.displayField]:e}:e)}updateDisabled(i,e){super.updateDisabled(i,e),this.navigator&&(this.navigator.disabled=i)}updateLocalization(){super.updateLocalization(),this.refresh()}updateTitle(){this.refresh()}changeSelected(i,e){const t=this,r={change:"onInternalSelectionChange",thisObj:t};if(i){if(i.isCollection)t._externallyOwnedSelection=!0,i.ion(r);else if(t._externallyOwnedSelection=!1,i=H.asArray(i).reduce((n,s)=>(s=s.isModel?s:t.store.getById(s),s&&t.callback(t.isSelectable,t,[s])&&n.push(s),n),[]),e)e.splice(0,e.count,i),i=e,t.refresh();else{const n=i;i=t._selected=new Ii({internalListeners:r}),i.add(n)}i!==e&&(e==null||e.un(r))}else e==null||e.destroy();return i}updateSelected(i){i&&this.refresh()}get itemSelector(){return`.${this.itemCls}`}get selected(){return this._selected}updateMultiSelect(i,e){!i&&e&&this.selected.count>1&&this.deselect(this.selected.allValues.slice(1))}get store(){return this.getConfig("items"),this._store}changeStore(i){const e=this;if(i instanceof ae||(Array.isArray(i)&&(i={data:i}),i=new ae(i)),e.detachListeners("store"),i){const t={name:"store",change:"onStoreChange",refresh:"onStoreRefresh",thisObj:e};i.readUrl&&(t.beforeLoad="onBeforeStoreLoad",t.afterRequest="onAfterStoreRequest"),i.isGrouped&&(e.element.classList.add("b-grouped"),t.groupchange="onStoreRefresh"),i.ion(t),i.tree&&i.traverse(r=>{r.isParent&&!r.expanded&&i.onNodeExpand(r)})}return i}updateStore(i){i!=null&&i.records.length&&this.getConfig("selected"),this.refresh()}changeNavigator(i,e){const t=this,{element:r}=t;return r&&(i=Mr.reconfigure(e,i?Mr.mergeConfigs({ownerCmp:t,disabled:t.disabled,target:r,keyEventTarget:r},i):null,t),(i==null?void 0:i.keyEventTarget)===r&&!t.itemsTabbable&&(r.tabIndex=0)),i}get minAlignHeight(){const i=this.element.lastElementChild,e=this.minHeight;if(e!=null)return i?Math.min(i.offsetTop+i.offsetHeight,e):0}alignTo(...i){super.minHeight=this.minAlignHeight,super.alignTo(...i)}hide(...i){return this.navigator&&(this.navigator.activeItem=null),super.hide(...i)}show(){const{refreshCount:i}=this,{previousActiveItem:e}=this.navigator;super.minHeight=this._minHeight;const t=super.show(...arguments);return this.refreshCount===i&&this.restoreActiveItem(e,!0),t}restoreActiveItem(i=this.navigator.previousActiveItem,e="nearest"){const t=this,{navigator:r,lastAlignSpec:n}=t;if(i!=null){if(typeof e!="string"){const s=n?n.zone:1;e=s&1?"nearest":s?"start":"end"}i=t.getItem(i),i&&!t.disabled&&(t.scrollable.scrollIntoView(i,{block:e}),r.activeItem=i)}}onMouseOver(i){const e=this,t=i.currentTarget;!E.isTouchEvent&&t&&e.navigator&&e.activateOnMouseover&&e.setTimeout({fn:"handleMouseOver",delay:30,args:[t],cancelOutstanding:!0})}handleMouseOver(i){this.navigator.activeItem=i}onClick(i){const e=i.target.closest(this.itemSelector);e?this.onItemClick(e,i):this.clearSelectionOnEmptySpaceClick&&this.deselectAll()}onSpaceKey(i){(i.target.nodeName.toUpperCase()!=="INPUT"||i.target.readOnly)&&this.onEnterKey(i)}onEnterKey(i){const e=this.navigator.activeItem;e&&!this.disabled&&(this.onItemClick(e,i),i.stopImmediatePropagation(),i.preventDefault())}onInternalKeyDown(i){const e=this;switch(i.key){case"ArrowLeft":e.collapseItem();break;case"ArrowRight":e.expandItem();break;case" ":e.onSpaceKey(i);break;case"Enter":e.onEnterKey(i);break}}collapseItem(){const{activeItem:i}=this.navigator;i&&this.toggleCollapse(this.getRecordFromElement(i),!0)}expandItem(){const{activeItem:i}=this.navigator;i&&this.toggleCollapse(this.getRecordFromElement(i),!1)}onItemClick(i,e){const t=this,{allowGroupSelect:r}=t,n=parseInt(i.dataset.index),s=t.store.getAt(n),a=s==null?void 0:s.isSpecialRow,o=i.contains(e.target.closest("[data-noselect]"));if(!(t.disabled||t.trigger("beforeItem",{item:i,record:s,index:n,event:e,userAction:!0})===!1)){if(t._isUserAction=!0,i.contains(e.target.closest("[data-select-all]")))t.onSelectAllClick(i,e);else if(e.target.matches(".b-list-expander-icon")){t.toggleCollapse(s);return}else if(s&&!o&&(!a||r)){const{selected:l}=t,{groupParent:d}=s.instanceMeta(t.store);if(t.multiSelect){let c=l.includes(s),u=s;t.toggleAllIfCtrlPressed&&e.ctrlKey?u=t.store.records:r&&a&&(c=!s.groupChildren.some(h=>!l.includes(h)),i.classList.toggle("b-selected",!c),u=s.groupChildren),l[c?"remove":"add"](u),!a&&d&&r&&t.getItem(d).classList.toggle("b-selected",d.groupChildren.every(f=>l.includes(f)))}else l.splice(0,l.count,s)}t.isDestroyed||(t.lastClicked=s,t.trigger("item",{item:i,record:s,index:n,event:e,userAction:!0}),t._isUserAction=!1)}}onInternalSelectionChange({action:i,removed:e,added:t,replaced:r}){const n=this,{selectedCls:s,unselectedCls:a}=n;let o,l;if(i==="clear")for(l of n.element.querySelectorAll(`.${s}`))l.classList.remove(s),l.setAttribute("aria-selected",!1),a&&l.classList.remove(a);else if(i!=="replaceValues"){for(o of e)l=n.getItem(o),l&&(l.classList.remove(s),l.setAttribute("aria-selected",!1));for(o of t)l=n.getItem(o),l&&(l.classList.add(s),l.setAttribute("aria-selected",!0))}n.selectAllItem&&n.updateSelectAllState(),n.trigger("selectionChange",{selected:n.selected.values})}onSelectAllClick(i){i.classList.contains(this.selectedCls)?this.deselectAll():this.selectAll()}updateSelectAllState(){var i;(i=this.element.querySelector(".b-select-all-item"))==null||i.classList.toggle(this.selectedCls,this.allSelected)}updateAllowGroupSelect(){this.refresh()}get allSelected(){const{selected:i,store:e}=this;return i.count&&(e.isFiltered?e.records.every(t=>i.includes(t)):e.count===i.count)}selectAll(i){const e=this;(e.multiSelect||!i)&&(e.selected.add(e.store.records),i&&!e.navigator.activeItem&&(e.navigator.activeItem=e.getItem(-1)))}deselectAll(){this.selected.clear()}select(i){const{store:e}=this,{modelClass:t}=e;i=H.asArray(i).reduce((r,n)=>(n=e.getById(t.asId(n)),n&&r.push(n),r),[]),this.selected.add(i)}deselect(i){const{modelClass:e}=this.store;i=H.asArray(i).reduce((t,r)=>(r=this.selected.get(e.asId(r)),r&&t.push(r),t),[]),this.selected.remove(i)}toggleCollapse(i,e){const{store:t}=this;i.isGroupHeader?(e=e===void 0?!i.meta.collapsed:e,t[e?"collapse":"expand"](i),this.refresh(),this.trigger("toggleGroup",{groupRecord:i,collapse:e})):i.isParent&&(e=e===void 0?!i.instanceMeta(t).collapsed:e,i.instanceMeta(t).collapsed=e,this.refresh(),this.trigger("toggleNode",{record:i,collapse:e}))}updateCollapsibleGroups(i,e){if(e&&!i){const{store:t}=this;t.groupRecords.forEach(r=>t.expand(r))}this.refresh()}};v(pi,"$name","List"),v(pi,"type","list"),v(pi,"configurable",{itemCls:"b-list-item",selectedCls:"b-selected",selectIconCls:"b-icon-check",tag:"ul",items:null,displayField:"text",store:{value:{},$config:"lazy"},navigator:!0,scrollable:{overflowX:!1,overflowY:!0},itemsFocusable:!0,multiSelect:!1,toggleAllIfCtrlPressed:!1,collapsibleGroups:!1,selectAllItem:!1,itemTpl(i){let e=O.encodeHtml(i.getValue(this.displayField));return(e==null||e==="")&&(e="&nbsp;"),e},tooltipTemplate:null,getItemStyle:null,getItemCls:null,groupHeaderTpl(i,e){let t=O.encodeHtml(e);return(t==null||t==="")&&(t="&nbsp;"),`${(this.allowGroupSelect||i.isParent)&&this.isSelectable(i)?this.itemIconTpl(i):""}${t}`},allowGroupSelect:!0,clearSelectionOnEmptySpaceClick:!1,selected:{$config:["nullify","lazy"],value:[]},activateOnMouseover:null,role:"listbox",keyMap:{"Ctrl+a":"selectAll"},title:null,virtualize:null,listItemHeight:10,isSelectable:()=>!0}),pi.initClass(),pi.prototype.navigatorClass=Mr,pi._$name="List";var fn=class extends pi{itemContentTpl(i,e){const t=this;return mi.tpl`${t.iconTpl?this.iconTpl(i):""}
            ${t.itemTpl(i,e)}
            ${t.closable?'<div class="b-icon b-close-icon b-icon-clear" data-noselect></div>':""}`}onInternalKeyDown(i){const e=this,{selected:t}=e,{generation:r}=t;e.closable&&t.count&&(i.key==="Delete"||i.key==="Backspace")?(e.closeHandler?e.callback(e.closeHandler,e.owner,[t.values,{isKeyEvent:!0}]):e.store.remove(t.values),t.generation!==r&&i.stopImmediatePropagation()):super.onInternalKeyDown(i)}updateClosable(i){this.element.classList[i?"add":"remove"]("b-chips-closable"),this.navigator&&(this.navigator.disabled=!i),this.isConfiguring||this.refresh()}onClick(i){const e=this,t=i.target.closest(`.${e.itemCls}`);if(e.closable&&i.target.classList.contains("b-close-icon")){const r=e.store.getAt(parseInt(t.dataset.index));e.closeHandler?e.callback(e.closeHandler,e.owner,[[r]]):e.store.remove(r)}else super.onClick(i)}};v(fn,"$name","ChipView"),v(fn,"type","chipview"),v(fn,"configurable",{itemCls:"b-chip",multiSelect:!1,closable:!0,iconTpl:null,closeHandler:null}),fn.initClass(),fn._$name="ChipView";var ay="L{fieldRequired}",ro="L{validateFilter}",DL="L{Field.tooShort}",wL="L{recordNotCommitted}",EL=/[\w\s]/,ze=class extends _r{static get configurable(){return{primaryFilter:{},picker:{type:"list",floating:!0,scrollAction:"realign",itemsFocusable:!1,activateOnMouseover:!0,align:{align:"t0-b0",axisLock:!0},maxHeight:324,scrollable:{overflowY:!0},autoShow:!1,focusOnHover:!1},multiSelect:null,items:null,store:null,valueField:void 0,displayField:"text",clearWhenInputEmpty:null,pickerWidth:null,minChars:null,selected:null,listItemTpl:null,displayValueRenderer:null,listCls:null,triggers:{expand:{cls:"b-icon-picker",handler:"onTriggerClick"}},filterParamName:null,encodeFilterParams:i=>i.map(e=>e.value),filterOnEnter:!1,hideTrigger:null,overlayAnchor:null,keyStrokeFilterDelay:null,defaultAction:"select",triggerAction:"all",filterOperator:"startsWith",caseSensitive:!1,hidePickerOnSelect:null,chipView:{$config:["lazy","nullify"],value:{type:"combochipview"}},chipStore:{$config:["lazy","nullify"],value:{}},filterSelected:null,emptyText:null,value:null,valueCollection:{$config:["nullify","lazy"],value:{}},validateFilter:!0,clearTextOnPickerHide:!0,clearTextOnSelection:!0,destroyStore:!1,multiValueSeparator:",",createOnUnmatched:null,role:"combobox",inlinePicker:null,testConfig:{keyStrokeFilterDelay:0},localizeDisplayFields:!1,buildItems:null,sortItemsOnLocaleChange:!1}}static get queryLast(){return"last"}construct(i){super.construct(...arguments),this.store||(this.items=[]),this.filterOnEnter&&(this.hideTrigger=!0)}startConfigure(i){this.usingRecordAsValue=i.valueField===null,super.startConfigure(...arguments)}afterConfigure(){super.afterConfigure();const i=this;T.hasOwn(i,"_value")||(i._value=i.valueField===i.displayField?"":null,i._lastValue=i._lastValue||i._value)}get childItems(){const{_chipView:i}=this,e=super.childItems;return i&&e.push(i),e}get innerElements(){var i;const e=(i=this._chipView)==null?void 0:i.element,{input:t,inputElement:r}=this;return e&&oe.sync({targetElement:t,domConfig:r}),[e||r]}updateInlinePicker(i){i&&(this.element.classList.add("b-inline-picker"),this.getConfig("picker"),this.triggers.expand=null,this.pickerVisible=!0)}hidePicker(){if(!this.inlinePicker)return super.hidePicker(...arguments)}changeChipStore(i){return i&&!(i instanceof ae)&&(i=new ae(ae.mergeConfigs({storage:this.valueCollection},i))),i}updateChipStore(i,e){e==null||e.destroy()}changeChipView(i,e){const t=this;if(t.element.classList[i?"add":"remove"]("b-uses-chipview"),i){const{input:r}=t;return t.chipStore||(t.chipStore={}),fg.reconfigure(e,i,{defaults:{parent:t,insertBefore:r,store:t.chipStore,closable:!t.readOnly,navigator:{type:"combochipnavigator",keyEventTarget:r}}})}e==null||e.destroy()}updateChipView(i){var e;const t=this;t._chipViewEventDetacher=(e=t._chipViewEventDetacher)==null?void 0:e.call(t),t.chipStore=i==null?void 0:i.store,i&&(i.element.appendChild(t.input),t._chipViewEventDetacher=j.on({element:i.element,mousedown:"onChipViewMousedown",thisObj:t}))}updateMultiSelect(i,e){const t=this,{input:r,element:n}=t,s=!t.isConfiguring;let{value:a}=t;if(n.classList[i?"add":"remove"]("b-multiselect"),i){const{chipView:o}=t,{parentNode:l}=r,d=o==null?void 0:o.element;d&&d!==l&&(l.insertBefore(d,r),d.appendChild(r),t.chipView.refresh()),r.value="",s&&(a=H.asArray(a))}else{const o=t._chipView,{parentNode:l}=r,d=o==null?void 0:o.element;d===l&&(d.parentNode.insertBefore(r,d),d.remove(),n.classList.remove("b-uses-chipview")),s&&typeof a!="string"&&(a=a!=null&&a.length?a[0]:null)}s&&(t.value=a)}onChipViewMousedown(i){i.preventDefault(),this.containsFocus||this.focus()}onChipClose(i,e={}){(e.isKeyEvent&&this.input.value===""||!e.isKeyEvent)&&(this._isUserAction=!0,this.valueCollection.remove(i),this._isUserAction=!1)}updateFilterParamName(i){this.hideTrigger!==!1&&(this.hideTrigger=!!i)}updateHideTrigger(i){this.element.classList[i?"add":"remove"]("b-hide-trigger")}updateKeyStrokeFilterDelay(i){this.filterOnInput.delay=i}updateReadOnly(i){super.updateReadOnly(...arguments),this._chipView&&(this._chipView.closable=!i)}updateDisabled(i,e){super.updateDisabled(i,e),this._chipView&&(this._chipView.closable=!i)}updateFilterOperator(i){this.primaryFilter&&(this.primaryFilter.operator=i)}get minChars(){var i;return(i=this._minChars)!=null?i:this.remoteFilter?4:1}get validateFilter(){return this._validateFilter&&!this.createOnUnmatched}get items(){return this.store.allRecords}updateBuildItems(i){i&&(this.items=i.call(this))}changeItems(i){const e=this;if(i==null){if(e.store&&!e.store.isItemStore)return;i=[]}if(e.buildItems&&!(i!=null&&i.length)&&(i=e.buildItems()),i instanceof ae){e.store=i;return}const t=e.displayField;let r,n=e.valueField,s;if(Array.isArray(i)?s=i.map(a=>{let o=a;return a instanceof he?(r=a.constructor,n||(e.valueField=n=r.idField)):typeof a=="string"||typeof a=="number"?(n||(e.valueField=n=e.displayField),o={[n]:a,[t]:a}):(n||(e.valueField=n="value"),Array.isArray(a)&&(o={[n]:a[0],[t]:a[1]})),a.selected&&(e.value=o),o}):(n||(e.valueField=n="value"),s=[],Object.entries(i).forEach(([a,o])=>{s.push({[n]:a,[t]:o})})),e.store)e.store.data=s;else{const a=n===t?{name:"value",dataSource:t}:n;if(!r){class o extends he{static get idField(){return e.valueField}static set idField(d){super.idField=d}static get fields(){const d=[a,t];return e.localizeDisplayFields&&d.push("localeClass"),d}}r=o}e.store=new ae({isItemStore:!0,data:s,idField:n,verifyNoGeneratedIds:!1,modelClass:r,useRawData:!1})}}get value(){const i=this,{valueCollection:e,valueField:t}=i;if(t==null)return i.multiSelect?e.values.slice():e.first;let r;return i.multiSelect?r=e.count?e.map(n=>n[t]):i._lastValue||[]:r=e.count?e.first[t]:i._lastValue,r}set value(i){super.value=i}get needsInputSync(){return this.usesChipView?!1:!this.editable}changeValue(i,e){var t,r;const n=this;if(i===e){n.syncInputFieldValue(!0);return}if(!n.multiSelect&&Array.isArray(i)&&i.length>1)throw new Error("Multiple values cannot be set to a non-multiSelect Combo");n.triggerConfig("items"),n.inputting||(t=n._chipView)==null||t.selected.clear(),n.store||(n.items=[]);const{valueField:s,displayField:a,store:o,valueCollection:l,_picker:d}=n,{storage:c}=o,u=(r=n.hidePickerOnSelect)!=null?r:!n.multiSelect,h=n._isUserAction||(d==null?void 0:d._isUserAction)||u&&n.pickerVisible||!1;if(!n.remoteFilter&&o.isAjaxStore&&!o.count){o.ion({load:()=>n.value=i,once:!0,thisObj:n}),n._lastValue=i;return}let f;if(i!=null){const g=Array.isArray(i),m=g?i.slice():[i];if(n.remoteFilter){if(i!=null){if(T.isObject(i)||i.isModel)o.getById(i.id)?n.valueCollection.splice(0,n.valueCollection.count,o.getById(i.id)):(o.data=[i],n.valueCollection.splice(0,n.valueCollection.count,o.first));else{const b=n.isConfiguring;n.primaryFilter.setConfig({value:i,disabled:!1}),o.performFilter(!0).then(()=>{if(n.isDestroyed)return;const{isConfiguring:C}=n;n.isConfiguring=b,l.splice(0,l.count,o.allRecords),n.isConfiguring=C})}return}}else o.isFiltered?(o.isChained&&o.fillFromMaster(),n.primaryFilter.disabled=!0,o.filter()):o.isChained&&o.fillFromMaster();for(let b=0,C=m.length;b<C;b++){let D=m[b];if(D instanceof he)c.includes(D,!0)||o.add(D);else{const S=T.isObject(D);S&&s&&(D=D[o.modelClass.fieldMap[s].dataSource]),f=c.getBy(a,D)||c.getBy(s,D)||l.getBy(a,D)||l.getBy(s,D),f instanceof Set&&(f=[...f][0]),f?(S&&f.set(m[b]),m[b]=f):(m.splice(b,1),C--,b--)}}const p=!m.length,y=l.generation;l.splice(0,l.count,m),p&&(n._value=g&&i.length===0?null:i,n._lastValue=n._value),(p||l.generation===y)&&n.syncInputFieldValue(),n.syncEmpty(),p&&!n.isConfiguring&&n.triggerFieldChange({value:i,oldValue:e,userAction:h,valid:n.isValid})}else if(l.count)l.clear();else{const g=n._value;n._value=null,n.syncInputFieldValue(),n.syncEmpty(),n.isConfiguring||n.triggerFieldChange({value:i,oldValue:g,userAction:h,valid:n.isValid})}n._lastValue=n._value}hasChanged(i,e){return this.multiSelect?!T.isEqual(i,e):super.hasChanged(...arguments)}onComboStoreChange({action:i}){i!=="filter"&&this.syncInputFieldValue(!0)}syncInputFieldValue(i){var e;this.usesChipView?(e=this.chipView)==null||e.refresh():super.syncInputFieldValue(i)}get usesChipView(){return!!(this.multiSelect&&this._chipView)}get isEmpty(){return this.valueCollection.count===0}get inputValue(){const i=this;let e=i.selected?i.selected[i.displayField]:i.value;return i.displayValueRenderer&&(e=i.callback(i.displayValueRenderer,i,[i.selected,i])),e==null?"":e}get nonEditableClickTarget(){var i;return this.multiSelect&&((i=this.chipView)==null?void 0:i.element)||super.nonEditableClickTarget}changeValueCollection(i,e){if(e==null||e.destroy(),i)return i.isCollection||(i=new Ii({internalListeners:{noChange:"onValueCollectionNoChange",change:"onValueCollectionChange",prio:-1e3,thisObj:this}})),i}changePrimaryFilter(i){return i.isCollectionFilter?i.setConfig({disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive}):(typeof i=="function"&&(i={filterBy:i}),i=new ft({id:"primary",disabled:!0,property:this.displayField,operator:this.filterOperator,caseSensitive:this.caseSensitive,...i})),i}changeStore(i){const e=this,t=[],{valueCollection:r,keyStrokeFilterDelay:n,filterParamName:s}=e;if(Array.isArray(i)){e.items=i;return}let a;if(i){if(i.isStore){const o=i.filters.get("primary");e.remoteFilter&&(i.filterParamName=s),a=i.remoteFilter,o?e.primaryFilter=o:t.push(e.primaryFilter)}else typeof i=="string"?i=ae.getStore(i):(i=new(i.readUrl?lt:ae)(i),e.destroyStore=!0),a=e.remoteFilter||i.restfulFilter,a&&s&&(i.filterParamName=s,e.encodeFilterParams&&(i.encodeFilterParams=e.encodeFilterParams)),t.push(e.primaryFilter);if(!e.valueField&&!e.usingRecordAsValue&&(e.valueField=i.modelClass.idField),e.filterSelected){const o=l=>!e.containsFocus||!r.includes(l);a?(i.storage.autoFilter=!0,i.storage.addFilter({id:`${e.id}-selected-filter`,filterBy:o})):(t.push(o),i.reapplyFilterOnAdd=!0)}r.addIndex({property:e.displayField,unique:!1}),r.addIndex({property:e.valueField,unique:!0}),t.forEach(o=>i.addFilter(o,!0)),a?e.keyStrokeFilterDelay=Math.max(300,n||0):e.keyStrokeFilterDelay=n!=null?n:10}return i}updateStore(i,e){const t=this,{_picker:r}=t;let n;t.destroyStore&&e&&e.destroy(),r&&(r.store=i),i.storage.addIndex({property:t.displayField,unique:!1}),i.storage.addIndex({property:t.valueField,unique:!0}),n={filter:"onStoreFilter"},t.displayValueRenderer&&((n||(n={})).change="onComboStoreChange"),t.detachListeners("store"),i!=null&&i.storage&&t.valueCollection.match(i.storage),t.syncInputFieldValue(),n&&(n.name="store",n.thisObj=t,i.ion(n))}get remoteFilter(){var i;return!!(this.filterParamName||(i=this._store)!=null&&i.restfulFilter)}get record(){return this.selected}get records(){return this.valueCollection.values.slice()}get selected(){const{store:i}=this;return this.multiSelect?this.valueCollection.values.slice().sort((e,t)=>i.indexOf(e)-i.indexOf(t))[0]:this.valueCollection.first}onEditComplete(){const i=this,e=i.valueCollection.count;super.onEditComplete(),e&&(i.clearError(ro),i.syncInputFieldValue()),i.required&&!e&&i.setError(ay)}onTriggerClick(i){var e;const t=this,r="key"in i;if(!(t.remoteFilter&&t.filterOnEnter)){if(t.pickerVisible)t.hidePicker();else if(!t.readOnly&&!t.disabled)switch((e=t.triggerAction)==null?void 0:e.toLowerCase()){case"all":t.doFilter(null,r);break;case"last":t.doFilter(t.lastQuery,r);break;default:t.doFilter(t.input.value,r)}}}internalOnInput(i){const e=this;e.clearWhenInputEmpty&&e.input.value===""&&e.clear(),e.syncEmpty(),e.syncInputWidth(),e.filterOnInput(i),e.trigger("input",{value:e.input.value,event:i})}filterOnInput(i){const e=this,{value:t}=i.type==="input"?i.target:e.input,r=t.length;e.inputting=!0,e.inlinePicker||r>=e.minChars&&(!e.filterOnEnter||i.key==="Enter")?e.doFilter(t):(e.validateFilter&&!e.remoteFilter&&e[r?"setError":"clearError"](ro),e.hidePicker()),e.inputting=!1}syncInputWidth(){const i=this;if(i.usesChipView){const e=i.input,t=i._inputPadding||(i._inputPadding=E.getEdgeSize(e,"padding","lr")),r=e.value||"",n=E.measureText(r+"W",e,!1,i.element)+t.width;e.style.flex=`1 1 ${Math.ceil(n)}px`}}doFilter(i,e){var t;const r=this,{store:n,picker:s}=r,a=i==null||i==="";r.lastQuery=i,r.primaryFilter.setConfig({value:i,disabled:a}),r.remoteFilter&&n.clear(!0);const o=()=>{const{navigator:l,isVisible:d}=s;n.count?!a&&l&&(l.activeItem=0):!r.remoteFilter&&!a&&(l&&(l.activeItem=null),r.validateFilter&&r.setError(ro)),d&&s.realign()};(t=r.filterPromise=n.filter())==null||t.then(()=>{r.filterPromise=null,o()}),r.inlinePicker||(s!=null&&s.isVisible?s.lastAlignSpec.zone===0&&s.realign():r.showPicker(e)),r.filterPromise||o()}onStoreFilter({source:i}){const e=this,t=e._picker,r=t==null?void 0:t.element.dataset,{count:n}=i;e.remoteFilter&&(n?t&&(t.navigator.activeItem=0):e.validateFilter&&e.setError(ro),e.filterSelected&&e.valueCollection.count&&(i.storage.onFiltersChanged({action:"splice",oldCount:1}),t&&t.refresh())),r&&(e.createOnUnmatched&&!n&&e.primaryFilter.value!=null?r.addNewValue=e.L("L{addNewValue}")(e.primaryFilter.value):r==null||delete r.addNewValue)}onValueCollectionChange({source:i}){var e,t,r,n;const s=this,{multiSelect:a,_picker:o}=s,l=(e=s.hidePickerOnSelect)!=null?e:!a,d=a?i.values.slice():i.first,c=i.values.slice(),u=s._isUserAction||(o==null?void 0:o._isUserAction)||l&&s.pickerVisible||!1,h=s._value;if(l&&s.hidePicker(),a&&s.clearTextOnSelection&&(s.input.value=""),!i.count&&s.required?s.setError(ay):(s.clearError(ay),s.clearError(ro)),s.validateFilter&&d&&s.clearError(ro),s.filterSelected){const g=o==null?void 0:o.navigator,m=Number((r=(t=g==null?void 0:g.activeItem)==null?void 0:t.dataset)==null?void 0:r.index);s.remoteFilter?(s.store.storage.onFiltersChanged({action:"splice",oldCount:1}),s._picker&&s._picker.refresh()):s.store.filter(),isNaN(m)||(g.activeItem=Math.min(o.store.count,m))}s._value=null,s._lastValue=null;const f=s.cacheCurrentValue(s.value);s.syncInputFieldValue(),s.syncEmpty(),s.isConfiguring||(f!==h&&!s.onConfigChange.$nullFn&&s.onConfigChange({name:"value",value:f,was:h,config:s.$meta.configs.value}),s.triggerFieldChange({value:f,oldValue:h,userAction:u,valid:s.isValid}),(n=s.trigger)==null||n.call(s,"select",{record:d,records:c,userAction:u}),s.defaultAction==="select"&&s.trigger("action",{value:f,record:d,records:c,userAction:u}))}cacheCurrentValue(i){return this._value=i}onValueCollectionNoChange({toAdd:i}){!this.inlinePicker&&!this.multiSelect&&i.length&&this.pickerVisible&&(this.picker.hide(),this.syncInputFieldValue())}showPicker(){var i;const e=this,{picker:t}=e;e.readOnly||e.inlinePicker||(t.multiSelect=e.multiSelect,super.showPicker(...arguments),e.overlayAnchor&&!t.align.offset&&(t.align.offset=-t.anchorSize[1],t.realign()),t.restoreActiveItem&&(e.multiSelect?t.restoreActiveItem(((i=t.navigator)==null?void 0:i.previousActiveItem)||e.selected||0,!0):t.restoreActiveItem(e.selected||0,!0)),e.input.focus())}changePicker(i,e){if(i){const t=this,r=t.pickerWidth||(i==null?void 0:i.width),n=pi.mergeConfigs({owner:t,store:t.store,selected:t.valueCollection,multiSelect:t.multiSelect,cls:t.listCls,displayField:t.displayField,forElement:t.pickerAlignElement,align:{matchSize:r==null?"min":!1,anchor:t.overlayAnchor,target:t.pickerAlignElement,minHeight:t.inlinePicker?null:Math.min(3,t.store.count)*40},[t.listItemTpl?"itemTpl":void 0]:t.listItemTpl,width:r,navigator:{keyEventTarget:t.input}},i);t.inlinePicker&&Object.assign(n,{floating:!1,align:null,activateOnMouseover:!1,maxHeight:null,appendTo:t.element}),i=pi.reconfigure(e,i?n:null,t),i.element.classList.add("b-combo-picker"),i.element.dataset.emptyText=t.emptyText?t.L(t.emptyText):t.L("L{noResults}"),i.ion({navigate:"onPickerNavigate",thisObj:t}),j.on({element:i.element,pointerdown:s=>t.onPickerNavigate({event:s}),thisObj:t})}else e==null||e.destroy();return i}onPickerNavigate({event:i}){i.target.matches("[data-add-new-value]")&&this.addNewRecord(this.primaryFilter.value)}onPickerHide(){const i=this;super.onPickerHide(),i.multiSelect&&i.clearTextOnPickerHide&&!i.errors&&(i.input.value="")}async internalOnKeyEvent(i){var e;const t=this,r=t.input[t.inputValueAttr],n=r.length,{key:s}=i,{primaryFilter:a,store:o,multiSelect:l,minChars:d,_picker:c,_chipView:u}=t;let h;if(i.type==="keydown"&&(c!=null&&c.isVisible)&&c.navigator){const{activeItem:f}=c.navigator;if(f&&l&&s===t.multiValueSeparator){t.input.value="",c.onItemClick(f,i),a.setConfig({value:"",disabled:!0}),o.filter(),c.hide(),i.preventDefault();return}if(!f&&t.createOnUnmatched&&(l&&s===t.multiValueSeparator||s==="Enter")){i.preventDefault(),await t.addNewRecord(r);return}}t.editable?u&&!u.selected.count&&i.type==="keydown"&&s==="Backspace"&&!n&&(u.navigator.activeItem=t.valueCollection.count-1,i.stopImmediatePropagation()):t.pickerVisible&&(s==="Backspace"&&((e=a.value)!=null&&e.length)?(a.value=a.value.substring(0,a.value.length-1),t.store.filter(),c.restoreActiveItem(0)):i.type==="keypress"&&s.match(EL)&&((!t.lastFilterKeypressTime||i.timeStamp-t.lastFilterKeypressTime>2e3)&&(a.value=""),a.setConfig({value:(a.value||"")+s,disabled:!1}),t.store.filter(),c.restoreActiveItem(0)),t.lastFilterKeypressTime=i.timeStamp),t.pickerVisible&&s==="Enter"&&t.primaryFilter.value===t.input.value&&(h=!0),super.internalOnKeyEvent(...arguments),i.type==="keydown"&&s==="Enter"&&!h&&t.remoteFilter&&(n>=d?(i.stopPropagation(),t.filterOnInput.now(i)):n>0&&(i.stopPropagation(),t.setError(DL+` (${d})`,!1,!0)))}async addNewRecord(i){var e,t;const r=this,{store:n,_picker:s,valueCollection:a,multiSelect:o,primaryFilter:l}=r,d=n.remoteFilter&&n.autoCommit;r.filterPromise&&await r.filterPromise,d||(l.setConfig({value:"",disabled:!0}),n.filter()),r._isUserAction=!0;const[c]=n.add(r.callback(r.createOnUnmatched,r,[i,r]));if(n.isCommitting){let u;try{await n.autoCommitTimeoutPromise,await n.commitPromise}catch(h){u=(t=(e=h.response)==null?void 0:e.parsedJson)==null?void 0:t.error}c.isPhantom&&(r.clearError(),r.setError(u||wL,!1,!0),n.remove(c),n.removed.remove(c))}d&&(l.setConfig({value:"",disabled:!0}),n.filter()),r.input.value="",n.includes(c)&&a.splice(o?a.count:0,o?0:a.count,c),s==null||s.hide(),r._isUserAction=!1}changeCreateOnUnmatched(i){return i===!0&&(i=this.defaultRecordCreator),i}defaultRecordCreator(i){return this.store.createRecord({[this.displayField]:i})}updateLocalizeDisplayFields(i){i?this.localizableProperties.push("store"):H.remove(this.localizableProperties,"store")}localizeProperty(i){return i==="store"?this.localizeStore():super.localizeProperty(i)}localizeStore(){var i;const e=this,{displayField:t}=e;let{localizedDisplayFieldsMap:r}=e;r||(e.localizedDisplayFieldsMap=r=new Map),!e.store&&e.buildItems&&(e.items=e.buildItems());for(const n of e.items)if(n.id){let s=r.get(n.id);!s&&((i=n[t])!=null&&i.startsWith("L{"))&&(s=n[t],r.set(n.id,s)),s&&(n[t]=(n.localeClass||e).L(s))}e.sortItemsOnLocaleChange&&e.store.sort(),e.syncInputFieldValue()}createOverflowTwin(i){return super.createOverflowTwin({store:this.store,...i})}};v(ze,"$name","Combo"),v(ze,"type","combo"),v(ze,"alias","combobox,dropdown"),v(ze,"delayable",{filterOnInput:0});var fg=class extends fn{static get defaultConfig(){return{closeHandler:"up.onChipClose",itemsFocusable:!1,multiSelect:!0,itemTpl(i){return O.encodeHtml(i.getValue(this.owner.displayField))},scrollable:{overflowY:"auto"}}}};v(fg,"$name","ComboChipView"),v(fg,"type","combochipview");var oy=class extends Mr{static get configurable(){return{allowShiftKey:!0}}onTargetClick(i){const e=this,t=i.target.closest(e.itemSelector);t&&!i.target.classList.contains("b-close-icon")&&(!i.shiftKey&&!t.contains(i.target.closest("[data-noselect]"))&&e.ownerCmp.selected.clear(),e.inClickHandler=!0,e.activeItem=t,e.inClickHandler=!1)}onKeyDown(i){i.key!=="Enter"&&!i.target.selectionStart&&!i.target.selectionEnd&&super.onKeyDown(i)}updateActiveItem(i,e){const t=this.ownerCmp;super.updateActiveItem(i,e),i&&!this.inClickHandler&&t.selected.add(t.getRecordFromElement(i))}navigatePrevious(i){const e=this.ownerCmp;e.navigator.activeItem&&!i.shiftKey&&e.selected.clear(),this.previous?super.navigatePrevious(i):this.activeItem=null}navigateNext(i){const e=this.ownerCmp;e.navigator.activeItem&&!i.shiftKey&&e.selected.clear(),this.next?super.navigateNext(i):this.activeItem=null}};v(oy,"$name","ComboChipNavigator"),v(oy,"type","combochipnavigator"),ze.initClass(),fg.initClass(),oy.initClass(),ze._$name="Combo";var Dc=class extends ze{static get configurable(){return{positiveValue:!0,positiveText:null,negativeValue:!1,negativeText:null,store:{value:[],$config:"lazy"},value:!1}}changeStore(i,e){const t=this;return super.changeStore(new ae({data:[{id:t.positiveValue,text:t.positiveText||t.L("L{Object.Yes}")},{id:t.negativeValue,text:t.negativeText||t.L("L{Object.No}")}]}),e)}};v(Dc,"$name","BooleanCombo"),v(Dc,"type","booleancombo"),Dc.initClass(),Dc._$name="BooleanCombo";var xL=({$toggleOrder:i},{$toggleOrder:e})=>(e||0)-(i||0),dx={click:"resetValueCache",beforeToggle:"onItemBeforeToggle",toggle:"onItemToggle"},gg=class WI extends dt.mixin(Zf,yc){afterConstruct(){super.afterConstruct(),this.ion({change:"internalOnChange"})}get inputWrap(){return this.element}get isValid(){let e=super.isValid;const t=this,{toggleable:r}=t;return t.clearError("L{Field.fieldRequired}",!0),e&&!t.disabled&&(t.required&&!t.value||r&&t.pressed.length<r[0])&&(e=!1,t.setError("L{Field.fieldRequired}",!0)),t.checkValidity&&t.callback(t.checkValidity,t,[t])===!1&&(e=!1),e&&t.errors&&Object.keys(t.errors).length&&(e=!1),e}get pressed(){return this.items.filter(e=>e.pressed).sort(xL)}internalOnChange(){this.syncInvalid()}onChildAdd(e){super.onChildAdd(e),e.ion({thisObj:this,...dx,prio:1e4})}onChildRemove(e){e.un({thisObj:this,...dx}),super.onChildRemove(e)}onItemBeforeToggle({pressed:e}){const{toggleable:t}=this;return e||!t||this.pressed.length>t[0]}onItemToggle(e){const t=this,r=(t.toggleCount||0)+1,{toggleable:n}=t;t.resetValueCache(),!t.isSettingValue&&(!t.toggleGroup||e.pressed)&&(n&&(e.source.$toggleOrder=r,t.toggleCount=r,t.isSettingValue=!0,t.pressed.slice(n[1]).forEach(s=>s.pressed=!1),t.isSettingValue=!1),t.triggerFieldChange({value:t.value,userAction:!0,event:e}))}resetValueCache(){this._value=null}createWidget(e){const t=this;return t.constructor.resolveType(e.type||"button").isButton&&(t.color&&!e.color&&(e.color=t.color),!e.toggleGroup&&t.toggleGroup&&(e.toggleGroup=t.toggleGroup),t.toggleable&&(e.toggleable=!0)),t.columns&&(e.width=`${100/t.columns}%`),e=super.createWidget(e),t.relayEvents(e,["click","action","toggle"]),e}changeToggleable(e){return e===!0?e=[0,1/0]:typeof e=="number"&&(e=[1,e]),e||null}updateToggleable(e){e&&!this.isConstructing&&this.pressed.slice(e[1]).forEach(t=>t.pressed=!1)}changeToggleGroup(e,t){return e===!0?t||WI.generateId("toggleGroup"):e}updateRotate(e){this.eachWidget(t=>{t.rotate!==!1&&(t.rotate=e)})}get valueAsArray(){const e=[];return this.items.forEach(t=>{t.pressed&&t.value!==void 0&&e.push(t.value)}),e}get value(){const e=this;return e._value||(e._value=e.valueAsArray.join(e.valueSeparator)),e._value}set value(e){const t=this,r=t.value;e==null?e=[]:typeof e=="string"?e=e.split(t.valueSeparator):Array.isArray(e)||(e=[e]),t._value=e.join(t.valueSeparator),t.isSettingValue=!0,t.items.forEach(n=>{n.value!==void 0&&(n.pressed=e.includes(n.value))}),t.isSettingValue=!1,!t.isConfiguring&&r!==t.value&&t.triggerFieldChange({value:t.value,userAction:!!t._isUserAction})}get validity(){return{}}onDisabled(e){this.syncInvalid(),this.items.forEach(t=>t.disabled=e||!t.ignoreParentReadOnly&&this.readOnly)}updateReadOnly(e){super.updateReadOnly(e),this.updateDisabled(this.disabled)}addToOverflowMenu(e,t,r){const{toggleable:n,toggleGroup:s}=this;(s||(n==null?void 0:n[0])===1&&n[1]===1)&&(t={...t,radio:!0}),this.items.forEach(a=>a.addToOverflowMenu(e,t,r))}get widgetClassList(){const e=super.widgetClassList;return this.columns&&e.push("b-columned"),e}updateUseGap(e){e||this.element.classList.add("b-no-gap")}};v(gg,"$name","ButtonGroup"),v(gg,"type","buttongroup"),v(gg,"configurable",{defaultType:"button",cls:null,items:null,color:null,useGap:!1,toggleGroup:null,valueSeparator:",",columns:null,hideWhenEmpty:!0,defaultBindProperty:"value",errorTooltipCachePath:"buttonGroupErrorTooltip",errorTooltipConfig:{forSelector:".b-buttongroup.b-invalid"},overflowable:!0,toggleable:null});var no=gg;no.initClass(),no._$name="ButtonGroup";var ly={0:1,6:1},gn=class extends ei{static get configurable(){return{layout:"vbox",textContent:!1,date:{$config:"date"},month:{},year:null,weekStartDay:null,sixWeeks:!0,showWeekColumn:null,disabledDates:null,headerRenderer:null,weekRenderer:null,cellRenderer:null,disableWeekends:null,disableNonWorkingDays:null,hideNonWorkingDays:null,hideNonWorkingDaysCls:"b-hide-nonworking-days",nonWorkingDays:null,tip:null,dayCellCls:"b-calendar-cell",dayHeaderCls:"b-calendar-day-header",disabledCls:"b-disabled-date",otherMonthCls:"b-other-month",weekendCls:"b-weekend",todayCls:"b-today",nonWorkingDayCls:"b-nonworking-day",dayNameFormat:"ddd",minRowHeight:{$config:["lazy"],value:null},minColumnWidth:{$config:["lazy"],value:null},disableOtherMonthCells:null,disableOtherMonthCellsCls:"b-disable-othermonth-cells",hideOtherMonthCells:null,hideOtherMonthCellsCls:"b-hide-othermonth-cells",animateTimeShift:!0}}construct(i){super.construct(i),this.refreshCount||this.refresh()}onInternalPaint({firstPaint:i}){var e;(e=super.onInternalPaint)==null||e.call(this,...arguments),i&&(this.refreshCount||this.refresh(),this.getConfig("minColumnWidth"),this.getConfig("minRowHeight"))}get overflowElement(){return this.weeksElement}doDestroy(){var i;(i=this.tip)==null||i.destroy(),super.doDestroy()}updateMinRowHeight(i){this.element.style.setProperty("--min-row-height",E.setLength(i)),this.scrollable={overflowY:i?"auto":!1}}updateMinColumnWidth(i){const e=this;e.element.style.setProperty("--min-column-width",E.setLength(i)),e.scrollable={overflowX:i?"auto":!1},e.overflowElement.classList[i?"add":"remove"]("b-min-columnwidth")}getDateFromDomEvent(i){const e=(i.nodeType===Element.ELEMENT_NODE?i:i.target).closest(`#${this.id} [data-date]`);if(e)return w.parseKey(e.dataset.date)}changeTip(i,e){const t=this;return Te.reconfigure(e,i,{owner:t,defaults:{type:"tooltip",owner:t,id:`${t.id}-cell-tip`,forElement:t.bodyElement,forSelector:`.${t.dayCellCls}`}})}updateTip(i){this.detachListeners("tip"),i==null||i.ion({pointerOver:"onTipOverCell",name:"tip",thisObj:this})}updateElement(i,e){const t=this;super.updateElement(i,e),t.updateHideNonWorkingDays(t.hideNonWorkingDays),t.weekdayCells=Array.from(i.querySelectorAll(".b-calendar-day-header")),t.weekElements=Array.from(i.querySelectorAll(".b-calendar-week")),t.weekDayElements=Array.from(i.querySelectorAll(".b-calendar-days")),t.cellElements=[];for(let r=0,{length:n}=t.weekDayElements;r<n;r++)t.cellElements.push(t.weekDayElements[r].previousSibling,...t.weekDayElements[r].children)}changeDate(i){if(i=typeof i=="string"?w.parse(i):new Date(i),isNaN(i))throw new Error("CalendarPanel date ingestion must be passed a Date, or a YYYY-MM-DD date string");return w.clearTime(i)}updateDate(i){this.month.date=i,this.element.dataset.month=w.format(i,"YYYY-MM")}updateDayNameFormat(){const i=new Date("2000-06-04T12:00:00");this.shortDayNames=[];for(let e=4;e<11;e++)i.setDate(e),this.shortDayNames.push(w.format(i,this.dayNameFormat))}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:w.weekStartDay}updateWeekStartDay(i){const e=this;if(e._month){e.month.weekStartDay=i,e.dayNames=[];for(let t=0;t<7;t++)e.dayNames[t]=e.shortDayNames[e.canonicalDayNumbers[t]];e.refreshCount&&e.refresh()}}updateHideNonWorkingDays(i){var e;this.contentElement.classList.toggle(this.hideNonWorkingDaysCls,!!i),(e=this.scrollable)==null||e.syncOverflowState(),this._month&&(this.month.hideNonWorkingDays=i),this.isConfiguring||this.refresh()}updateHideOtherMonthCells(i){var e;this.element.classList.toggle(this.hideOtherMonthCellsCls,!!i),(e=this.scrollable)==null||e.syncOverflowState()}updateDisableOtherMonthCells(i){var e;this.element.classList.toggle(this.disableOtherMonthCellsCls,!!i),(e=this.scrollable)==null||e.syncOverflowState()}get nonWorkingDays(){return this._nonWorkingDays||this._localeNonWorkingDays||(this._localeNonWorkingDays=w.nonWorkingDays)}get weekends(){return this._localeWeekends||(this._localeWeekends=w.weekends)}changeNonWorkingDays(i){return T.assign({},i)}updateNonWorkingDays(i){var e;this._month&&(this.month.nonWorkingDays=i,this.refresh(),(e=this.scrollable)==null||e.syncOverflowState())}get visibleDayColumnIndex(){return this.month.visibleDayColumnIndex}get dayColumnIndex(){return this.month.dayColumnIndex}get canonicalDayNumbers(){return this.month.canonicalDayNumbers}get visibleColumnCount(){return this.month.visibleColumnCount}get weekLength(){return this.month.weekLength}get startDate(){return this.month.startDate}get duration(){return w.diff(this.month.startDate,this.month.endDate,"day")+1}get endDate(){const{endDate:i}=this.month;if(i)return w.add(i,1,"day")}changeMonth(i,e){const t=this;if(!(i instanceof mc)){if(typeof i=="number"){if(e){e.month=i;return}const r=t.date||w.clearTime(new Date);r.setMonth(i),i={date:r}}i=mc.new({weekStartDay:t.weekStartDay,nonWorkingDays:t.nonWorkingDays,hideNonWorkingDays:t.hideNonWorkingDays,sixWeeks:t.sixWeeks},i)}return i.ion({dateChange:"onMonthDateChange",thisObj:t}),i}onMonthDateChange({source:i,newDate:e,oldDate:t,changes:r}){const n=this;if(n.year=i.year,!n.isConfiguring){if(!n.getCell(e)||r.m||r.y){const{isVisible:s}=n;n.refresh(),n.animateTimeShift&&s&&E.slideIn(n.contentElement,e>t?1:-1)}n.trigger("dateChange",{changes:r,value:e,oldValue:t})}}updateYear(i){this.month.year=i}updateShowWeekNumber(i){this.updateShowWeekColumn(i)}updateShowWeekColumn(i){const e=this;e.element.classList[i?"add":"remove"]("b-show-week-column"),e.floating&&(e.isAligning||e.realign())}updateSixWeeks(i){this.month&&(this.month.sixWeeks=i,this.refresh())}refresh(){this.doRefresh()}doRefresh(){var i;this.getConfig("element");const e=this,t=e.timeZone!=null?e.timeZone:(i=e.project)==null?void 0:i.timeZone,r=t!=null?Ze.toTimeZone(new Date,t):new Date,{weekElements:n,weekDayElements:s,date:a,month:o,dayCellCls:l,dayHeaderCls:d,disabledCls:c,otherMonthCls:u,weekendCls:h,todayCls:f,nonWorkingDayCls:g,nonWorkingDays:m,canonicalDayNumbers:p,sixWeeks:y}=e;if(r.setHours(0,0,0,0),!a){e.date=r;return}e.element.style.setProperty("--visible-week-count",o.weekCount),e.trigger("beforeRefresh"),e.getConfig("dayNameFormat");for(let S=0;S<7;S++){const x=e.weekdayCells[S],R=e.canonicalDayNumbers[S],M={[d]:1,[h]:ly[R],[g]:m[R]};e.headerRenderer?(x.innerHTML="",e.callback(e.headerRenderer,e,[x,S,R])):E.setInnerText(x,e.shortDayNames[R]),E.syncClassList(x,M),x.dataset.columnIndex=S,x.dataset.cellDay=R}let b=0,C=0,D=6;for(let S=6;S>=0;S--)if(!m[p[S]]){D=S;break}n[4].classList.toggle("b-hide-display",o.weekCount<5&&!y),n[5].classList.toggle("b-hide-display",o.weekCount<6&&!y),o.eachWeek((S,x)=>{const R=s[b],M=[R.previousSibling,...R.children];n[b].dataset.week=`${S[0]},${S[1]}`,e.weekRenderer?e.callback(e.weekRenderer,e,[M[0],S]):M[0].innerText=S[1];for(let I=0;I<7;I++){const _=x[I],P=_.getDay(),A=w.makeKey(_),L=m[P],F=M[I+1],N={[l]:1,[c]:e.isDisabledDate(_),[u]:_.getMonth()!==o.month,[h]:ly[P],[f]:_.getTime()===r.getTime(),[g]:L,"b-last-working-day":I===D,"b-first-visible-cell":!(_-(e.firstVisibleDate||-1)),"b-last-visible-cell":!(_-(e.lastVisibleDate||-1)),[`b-day-of-week-${P}`]:1};E.syncClassList(F,N),F.dataset.date=A,F.dataset.cellIndex=C,F.dataset.columnIndex=I,F.lastDomConfig&&(delete F.lastDomConfig.class,delete F.lastDomConfig.className),e.cellRenderer?e.callback(e.cellRenderer,e,[{cell:F,date:_,day:P,rowIndex:b,cellIndex:C,columnIndex:I,key:A,week:S,row:n[b],source:e,visibleColumnIndex:e.visibleDayColumnIndex[P]}]):F.innerHTML=_.getDate(),C++}b++}),e.visibleWeekCount=b,e.floating&&(e.isAligning||e.realign()),e.refreshCount=(e.refreshCount||0)+1,e.trigger("refresh")}isDisabledDate(i){const e=this,t=i.getDay(),{disabledDates:r}=e;if(e.disableWeekends&&ly[t]||e.disableNonWorkingDays&&e.nonWorkingDays[t])return!0;if(r)return Array.isArray(r)?(i=w.clearTime(i,!0),r.some(n=>!(w.clearTime(n,!0)-i))):e.callback(r,e,[i])}get bodyConfig(){const i=super.bodyConfig,e=[];i.children=[{tag:"div",className:"b-calendar-row b-calendar-weekdays",reference:"weekdaysHeader",children:[{class:"b-week-number-cell"},...H.fill(7,{class:this.dayHeaderCls}),E.scrollBarPadElement]},{className:"b-weeks-container notranslate",reference:"weeksElement",tabIndex:-1,children:e}];for(let t=0;t<6;t++){const r={className:"b-calendar-row b-calendar-week",dataset:{rowIndex:t},children:[{className:"b-week-number-cell"},{className:"b-calendar-days",children:[{},{},{},{},{},{},{}],syncOptions:{ignoreRefs:!0,strict:!1}}]};e.push(r)}return i}get firstVisibleDate(){if(this.hideOtherMonthCells){const{year:i,month:e}=this.month;return new Date(i,e,1)}for(const i=this,e=i.month.startDate;;e.setDate(e.getDate()+1))if(!i.hideNonWorkingDays||!i.nonWorkingDays[e.getDay()])return e}get lastVisibleDate(){const i=w.add(this.endDate,-1,"d");if(this.hideOtherMonthCells)return i;for(const e=this,t=i;;t.setDate(t.getDate()-1))if(!e.hideNonWorkingDays||!e.nonWorkingDays[t.getDay()])return t}getCell(i,e){typeof i!="string"&&(i=w.makeKey(i));const t=this.weeksElement.querySelector(`[data-date="${i}"]`);if(t&&(!e||!t.classList.contains(this.otherMonthCls)))return t}onTipOverCell({source:i,target:e}){i.date=w.parseKey(e.dataset.date)}updateLocalization(){this._localeNonWorkingDays=this._localeWeekends=null,this.updateDayNameFormat(),this.updateWeekStartDay(this.weekStartDay),super.updateLocalization()}};v(gn,"$name","CalendarPanel"),v(gn,"type","calendarpanel"),gn.initClass(),gn._$name="CalendarPanel";var{abs:RL,ceil:cx,floor:TL,max:ux,min:dy}=Math,hx="b-carousel-item",ML=[0,0],vi=Symbol("carouselIndex"),cy=Symbol("carouselSyncGen"),mg="b-carousel-reserve",IL=`${mg}-before`,_L=`${mg}-after`,PL=(i,e)=>i[vi]-e[vi],AL="b-carousel-first",FL="b-carousel-last",uy="b-carousel-visible",fx=["x","y"],gx=["y","x"],wc={h:{minSize:"minWidth",offsetPos:"offsetLeft",offsetSize:"offsetWidth",size:"width",vxy:["vx","vy"],xy:fx},v:{minSize:"minHeight",offsetSize:"offsetHeight",size:"height",vxy:["vy","vx"],xy:gx}};wc.h.other=wc.v,wc.v.other=wc.h;var Pr=class extends ei.mixin(to,Z0){compose(){const{carouselClasses:i}=this;return{class:{...i}}}get allSlots(){return this.ensureItems().values.filter(i=>i.innerItem).sort(PL)}get bodyConfig(){const{carouselClasses:i,emptyHtml:e,emptyText:t}=this,r=super.bodyConfig;return T.merge(r,{className:{"b-vbox":1,...i},children:{innerCt:{class:{"b-carousel-inner-ct":1,"b-box-center":1}},emptyElement:{class:{"b-carousel-empty-text":1,"b-box-center":1},html:e||O.xss`${t}`}}})}get carouselClasses(){const{empty:i,vertical:e}=this;return{"b-carousel-empty":i,"b-carousel-vertical":e}}get contentElement(){return this.innerCt}get currentIndex(){return this.indexFromPos(this.scrollPos)}set currentIndex(i){this.goto(i)}get focusedSlot(){const{innerCt:i}=this;let e=null,t,r;for(t=E.getActiveElement();t;t=r)if(r=t.parentElement,r===i){e=V.fromElement(t);break}return e}get infinityScrollerDefaults(){const i=this,[e,t]=i.vertical?gx:fx;return T.merge(super.infinityScrollerDefaults,{snap:i.snap&&e,[e]:{overflow:"hidden-scroll",range:i.scrollRange,pos:0},[t]:{overflow:"hidden"}})}get propNames(){return wc[this.vertical?"v":"h"]}get scrollAxis(){return this.infinityScroller[this.vertical?"y":"x"]}get scrolling(){return this.infinityScroller.scrolling}get scrollPos(){return this.scrollAxis.pos}set scrollPos(i){this.scrollAxis.pos=i}get scrollRange(){const{range:i,slotSize:e}=this;return e?[i[0]*e,i[1]*e]:[0,1/0]}get shrinkWrap(){const i=this._shrinkWrap;return i==="auto"?E.getStyleValue(this.element,"position")==="absolute":i}get lastVisibleIndex(){var i;return(i=this.lastVisibleSlot)==null?void 0:i[vi]}get visibleSlots(){return this.allSlots.filter(i=>i.element.classList.contains(uy))}updateAtMax(i){this.element.classList.toggle("b-carousel-at-max",i)}updateAtMin(i){this.element.classList.toggle("b-carousel-at-min",i)}changeConfigureSlot(i){if(typeof i=="string"){const e=`_${i}Fn`;return this[e]||(this[e]=(...t)=>this[i](...t))}return i}triggerSlotVisibility(){const{firstVisibleSlot:i,lastVisibleSlot:e}=this;this.trigger("slotVisibility",{firstVisibleSlot:i,lastVisibleSlot:e})}updateFirstVisibleSlot(i){this.triggerSlotVisibility()}updateLastVisibleSlot(){this.triggerSlotVisibility()}changeRange(i){var e,t;if(i=i?[(e=i[0])!=null?e:-1/0,(t=i[1])!=null?t:1/0]:[0,0],i[0]!==i[1]){let r;if(i[1]<i[0]&&(r="denormalized"),r)throw new Error(`Invalid carousel range [${i[0]}, ${i[1]}): ${r}`)}return i}updateRange(i){this.empty=!(i[0]<i[1]),this.syncSoon()}updateShrinkWrap(){this.isPainted&&this.syncSoon()}updateVertical(){this.isPainted&&this.syncSoon()}convertIndexPos(i,e){const t=this,{allSlots:r,propNames:n}=t,[s,a]=t.range,o=Math.floor((s+a)/2),l=r.length,d=r[l-1],c=n.vxy[0],u=s<=0&&0<a;if(!e&&!(s<=i&&i<a))return null;let h=t.slotSize||100,f,g,m,p,y,b,C,D;if(l){h=0;for(D of r){if(m=D[vi],f=D[c],h=h||D.$vxy[n.size],D===r[0]&&(p=m,C=f,i<(e?f:m)))break;if(e){if(i===f)return m;if(i<f)return m-1}else if(i===m)return f;if(D===d){if(g=f+D.$vxy[n.size],e&&i<g)return m;y=m+1,b=g}}h=h||t.slotSize||100}else{if(e&&0<=i&&i<h)return u?0:o;C=0,b=h,p=u?0:o,y=p+1}return e?i<C?ux(p-cx((C-i)/h),s):dy(y+TL((i-b)/h),a):i<p?C-(p-i)*h:b+(i-y)*h}ensurePlan(i){return i}ensureVisible(i){const e=this;if(e.lastScrollPos==null)e._afterSync=()=>e.ensureVisible({...i,animate:!1});else if(e.scrolling&&e.hasPainted)e._afterScroll=()=>e.ensureVisible(i);else{const{index:t,animate:r}=e.ensurePlan(i),{currentIndex:n,lastVisibleIndex:s}=e;let a;return t<n?a=t-n:s<t&&(a=t-s),a&&e.go(a,r)}}getSlotIndex(i){return i==null?void 0:i[vi]}indexFromPos(i){return this.convertIndexPos(i,!0)}posFromIndex(i){return this.convertIndexPos(i,!1)}slotFromIndex(i){for(const e of this.allSlots)if(e[vi]===i)return e;return null}backward(i){return this.go(-1,i)}forward(i){return this.go(1,i)}go(i,e){return this.goto(this.currentIndex+i,e)}goto(i,e){const t=this;if(t.lastScrollPos==null)t._afterSync=()=>{const{scrollPos:r}=t;t.goto(i,!1),!t.hasPainted&&r!==t.scrollPos&&t.sync()};else if(t.scrolling&&t.hasPainted)t._afterScroll=()=>t.goto(i,e);else{const{range:r,slots:n}=t,s=r[1]-(typeof n=="number"?n-1:0),a=dy(s-1,ux(r[0],i)),o=RL(t.currentIndex-a),l=t.posFromIndex(a);return o>=t.allSlots.length&&(e=!1),t.scrollTo({animate:e,[t.scrollAxis.name]:l})}}onChildAdd(i){return i.innerItem&&i.element.classList.add(hx),super.onChildAdd(i)}onChildRemove(i){return i.innerItem&&i.element.classList.remove(hx),super.onChildRemove(i)}onInfiniteScrollEnd(i){super.onInfiniteScrollEnd(i);const{_afterScroll:e}=this;this._afterScroll=null,e==null||e()}onSlotFocusTrap({source:i,top:e}){const t=this,r=e?-1:1,n=i[vi],s=t.slotFromIndex(n+r);return s.element.classList.contains(mg)?t.scrollOnTab&&t.go(r).then(a=>{var o;a&&((o=s.element)==null||o.focus())}):s.element.focus(),!1}resync(){this.sync()}sync(){var i;if(this.syncCount=(this.syncCount||0)+1,!this.empty){const e=this,{allSlots:t,disableReserveSlots:r,innerCt:n,scrollAxis:s,propNames:a,reserveSlots:o,slots:l}=e,[d,c]=e.range,u=s.pos,h=V.resolveType(((i=e.defaults)==null?void 0:i.type)||e.defaultType),f=e.indexFromPos(u),g=e.posFromIndex(f),m=u-g,p=[o,o],y=e.syncGen=(e.syncGen||0)+1;e.scrolling&&u>(e.lastScrollPos||0)&&m&&(--p[0],++p[1]),e.lastScrollPos=u,n.style.setProperty("--carousel-item-offset",`${Math.abs(m)}px`),e.shrinkWrapped||(n.style[a.minSize]="");let b=n[a.offsetSize],C=!1,D=!1,S=null,x=null,R,M,I,_;e.unanimated(()=>{const{_afterSync:P}=e,A=l&&l!=="auto"?e.syncFixed(f,a,t,h,p,l,d,c):e.syncDynamic(f,a,t,h,p,l,b,d,c),L=[],F=t.filter(N=>N[cy]!==y);F.length&&(F.forEach(N=>e.detachListeners(`${N.id}-listeners`)),e.remove(F)),n.style[a.other.minSize]=`${A[a.other.size]}px`,b=n[a.offsetSize];for(_ of t)if(!F.includes(_)){const N=s.getItemSpan(_),Y=u+b,G=N[1]<=u,U=Y<=N[0],Z=!G&&!U,fe=Z&&N[0]<=u,J=Z&&N[1]>=Y;Z&&(_[vi]===d&&(D=!0),_[vi]===c-1&&(C=!0)),fe&&(S=_),J&&(x=_),L.push([_,_.element.classList,{[mg]:G||U,[IL]:G,[AL]:fe,[uy]:Z,[FL]:J,[_L]:U}])}for([_,R,I]of L){r&&(_.disabled=I[uy]?!1:r);for(M in I)R.toggle(M,I[M])}e.atMax=C,e.atMin=D,e.firstVisibleSlot=S,e.lastVisibleSlot=x,s.other.range=ML,e.syncDomOrder(F.length?e.allSlots:t),s.sync({range:e.scrollRange}),s.pos!==u?e.resync():P&&(e._afterSync=null,P())})}}syncDomOrder(i){const e=E.getActiveElement();let t,r,n;for(n=i.length;n-- >1;)r=i[n].element,t||r.classList.add("b-last-visible-child"),t=i[n-1].element,t.classList.remove("b-last-visible-child"),r.classList.remove("b-first-visible-child"),t.nextSibling!==r&&t.parentElement.insertBefore(t,r);t==null||t.classList.add("b-first-visible-child"),this.element.contains(e)&&e!==E.getActiveElement()&&e.focus()}syncDynamic(i,e,t,r,n,s,a,o,l){const d=this,{offsetSize:c}=e,u=s==="auto",h=u?"":null;let[f,g]=n,m=1,p=0,y,b,C;for(C=i;o<=C&&C<l;C+=m){if(b=d.syncSlot(t,r,C,h),y=y||b,p<a){if(p+=b.element[c],u)return d.syncFixed(i,e,t,r,n,cx(a/p));if(m>0){if(C+1<l&&(p<a||g))continue;f+=g,g=0}}if(--g<1){if(m<0||!f)break;m=-1,C=i,g=f}}return y}syncFixed(i,e,t,r,n,s,a,o){const l=this,{shrinkWrap:d,shrinkWrapped:c}=l,u=`${100/s}%`,h=i+s;let f=i-n[0],g=h+n[1],m=0,p,y,b,C,D;for(;g>o;)--f,--g;for(;f<a;)++f,++g;for(D=f;D<g;++D)y=l.syncSlot(t,r,D,d&&!c?"":u),D===i&&(p=y),d?(b||(b=[])).push(y):y[e.size]=u;if(d){for(C=dy(h,g-n[1]),D=C-s;D<C;++D)m+=b[D-f][e.size];for(y of b)y[e.size]=u;m&&(l.innerCt.style[e.minSize]=`${m}px`,l.shrinkWrapped=!0)}return p}syncSlot(i,e,t,r){const n=this,{propNames:s,syncGen:a}=n,o=r!==null;let l=null,d,c,u,h,f;for(h of i)if(h[cy]!==a){if(c=h[vi],c===t){u=h,o&&(u[s.size]=r);break}(!l||c>l[vi])&&(l=h)}return u||(d=n.configureSlot(t,n,l),l?(u=l,o&&(u[s.size]=r),delete d.type,u.setConfig(d)):(f=d.type?V.resolveType(d.type):e,d=f.mergeConfigs(n.defaults,d),o&&(d[s.size]=r),u=n.add(d),i.push(u),u.ion({thisObj:n,name:`${u.id}-listeners`,focusTrap:"onSlotFocusTrap"})),u[vi]=t,n.slotSize||(n.slotSize=u[s.size]),u[s.vxy[0]]=t*n.slotSize),u[cy]=a,u}};v(Pr,"$name","Carousel"),v(Pr,"type","carousel"),v(Pr,"configurable",{atMax:null,atMin:null,configureSlot:(i,e,t)=>({}),disableReserveSlots:null,empty:null,emptyHtml:null,emptyText:"No items to display",firstVisibleSlot:null,lastVisibleSlot:null,range:[null,null],reserveSlots:1,scrollOnTab:null,shrinkWrap:"auto",slots:null,snap:!0,vertical:null}),v(Pr,"delayable",{triggerSlotVisibility:"raf"}),v(Pr,"fenced",{resync:!0}),Pr.initClass(),Pr._$name="Carousel";var kL=i=>!i.value,Ar=class extends ct{static get configurable(){return{inputType:"checkbox",autoCollapse:null,toggleGroupRootElement:null,containerDefaults:{syncableConfigs:{disabled:i=>i.disabled||!i.value},syncConfigTriggers:{autoCollapse:1,value:1}},text:"",checkedValue:!0,uncheckedValue:!1,color:null,value:"",toggleGroup:null,localizableProperties:["label","text"],twinSyncConfigs:{value:"checked"}}}construct(i){"checked"in i&&(i=T.assign({},i),i.value=i.checked,delete i.checked),super.construct(i),this.syncHasText()}get textLabelCls(){return"b-checkbox-label"}get innerElements(){return[this.inputElement,{tag:"label",class:this.textLabelCls,for:`${this.id}-input`,reference:"textLabel",html:this.text||""}]}get inputElement(){const i=super.inputElement;return this.toggleGroup&&(i.dataset={group:this.toggleGroup}),i.listeners={click:"internalOnClick",change:"internalOnChange",input:"internalOnInput"},i}get checked(){return this.value}set checked(i){this.value=i}syncHasText(){this.element.classList[this.text?"add":"remove"]("b-text")}updateText(i){this.textLabel&&(this.syncHasText(),this.textLabel.innerHTML=i)}afterSyncChildConfigs(i){super.afterSyncChildConfigs(i);let{autoCollapse:e}=this;e&&(e=e===!0?kL:e,i.collapsed=e(this))}assignFieldValue(i,e,t){this.value=t===this.checkedValue||(t===this.uncheckedValue?!1:null)}fetchInputValue(){this.readOnly||(this.value=this.input.checked)}gatherValue(i){var e;const t=this,r=t.value?t.checkedValue:t.uncheckedValue,n=r!==void 0,{valueName:s}=t;n&&(i[s]=r),t.gatherValues(i,n),r===!0&&((e=i[s])==null?void 0:e.value)===r&&delete i[s].value}changeValue(i){return i==="false"?!1:!!i}updateValue(i){var e;const t=this,r=t.input.checked!==i;t.input.checked=i,(e=t.container)==null||e.syncChildConfigs(),r&&!t.inputting&&!t.isConfiguring&&(t.uncheckToggleGroupMembers(),t.triggerChange(!1,null))}get inputValueAttr(){return"checked"}updateColor(i,e){const t=this.element.classList;e&&t.remove(e),i&&t.add(i)}getToggleGroupRootElement(){const i=this.toggleGroupRootElement;let e;return i&&typeof i=="string"&&this.element&&(e=this.element.closest(i)),e||this.rootElement}getToggleGroupMembers(){const i=this,{toggleGroup:e,input:t,type:r}=i,n=[];return e&&E.forEachSelector(i.getToggleGroupRootElement(),`input[type=${r}][data-group=${e}]`,s=>{if(s!==t){const a=V.fromElement(s);a&&n.push(a)}}),n}uncheckToggleGroupMembers(i){this.checked&&this.toggleGroup&&this.getToggleGroupMembers().forEach(e=>{e._propagatingUserActionFrom=this,e.checked=!1,e._propagatingUserActionFrom=null})}check(){this.checked=!0}uncheck(){this.checked=!1}toggle(){this.checked=!this.checked}internalOnClick(i){return this.readOnly?(i.preventDefault(),!1):this.trigger("click",{event:i})}internalOnChange(i){const e=this;if(e.readOnly&&e.value!==e.input.checked){e.input.checked=e.value;return}e.value=e.input.checked,e.inputting||(e.inputting=!0,e.triggerChange(!0,i),e.inputting=!1)}updateInputReadOnly(i){}triggerChange(i,e){const t=this,{checked:r}=t.input,n={checked:r,value:r,oldValue:!r,userAction:i,valid:!0,event:e};if(t._propagatingUserActionFrom&&(n.propagatingUserActionFrom=t._propagatingUserActionFrom),!r&&i&&t.toggleGroup&&t.getToggleGroupMembers().filter(a=>a.isVisible&&!a.disabled).length||t.trigger("beforeChange",n)===!1)t.input.checked=t._value=!r;else return t.triggerFieldChange(n,!1),i&&t.uncheckToggleGroupMembers(i),t.trigger("action",n),t.trigger("change",n),!0}configureOverflowTwin(i){const e=this,t=super.configureOverflowTwin(i);return t.type=V.resolveType("menuitem"),t.text||(t.text=e.label||e.text||e.tooltipText),t}};v(Ar,"$name","Checkbox"),v(Ar,"type","checkbox"),v(Ar,"alias","check"),Ar.initClass(),Ar._$name="Checkbox";var Ec,Fr=class extends ei{construct(i={}){const e=this;e.editorReady=new Promise((t,r)=>{e.resolveEditorReady=t,e.rejectEditorReady=r}),super.construct(...arguments),e.editorReady.then(()=>{ue.ion({theme:({theme:t})=>e.editor.updateOptions({theme:t.toLowerCase().includes("dark")?"vs-dark":"vs-light"}),thisObj:e}),e.element.style.setProperty("--vscode-menu-background",getComputedStyle(e.element.querySelector(".monaco-editor")).getPropertyValue("--vscode-menu-background"))})}get monacoInstance(){return globalThis.monaco}focus(){this.editor.focus()}static set monacoLoadPromise(i){Ec=i}static get monacoLoadPromise(){return Ec}async updateCodePath(i,e){var t;const r=this;e&&((t=r.loaderScript)==null||t.remove()),Ec||(Ec=new Promise(n=>{const s=()=>{const l=globalThis.require;l.config({paths:{vs:`${i}/min/vs`}}),l(["vs/editor/editor.main"],function(){r.isDestroyed||n(globalThis.monaco)}),o.removeEventListener("error",a),o.removeEventListener("load",s)},a=()=>{const l=`Code editor path to Monaco editor ${i} is incorrect`;o.removeEventListener("error",a),o.removeEventListener("load",s),Ki.show(l),r.rejectEditorReady(l)},o=r.loaderScript=E.createElement({tag:"script",parent:document.head,src:`${i}/min/vs/loader.js`});o.addEventListener("error",a),o.addEventListener("load",s)})),globalThis.monaco=await Ec,r.getConfig("editor"),r.getConfig("text")}updateReadOnly(i){const{readOnly:e}=this.widgetMap;e&&(e.hidden=!i),this.editor.updateOptions({readOnly:i})}updateStatus(i){const{status:e}=this.widgetMap;e&&(e.html=i)}changeEditor(i,e){var t,r;const n=this;return(t=e==null?void 0:e.dispose)==null||t.call(e),i&&(i=n.monacoInstance.editor.create(n.contentElement,Oe.merge({theme:n.theme||(r=E.themeInfo)!=null&&r.name.toLowerCase().includes("dark")?"vs-dark":"vs-light",padding:{top:14}},i)),n.monacoInstance.languages.typescript.javascriptDefaults.setDiagnosticsOptions({noSuggestionDiagnostics:!0}),i.onDidChangeCursorPosition(n.onCursorMove.bind(n)),i.onDidChangeConfiguration(n.onEditorConfigChange.bind(n)),i.onDidDispose(n.onEditorDestroy.bind(n)),n.resolveEditorReady(i)),i}get text(){var i;return((i=this.codeModel)==null?void 0:i.getValue())||this._text}changeText(i){var e;return this._text=(e=this.codeModel)==null?void 0:e.getValue(),i}updateText(i){var e,t;const{codeModel:r}=this;i!=null?r?r.setValue(i):this.loadText(i):(t=(e=this.codeModel)==null?void 0:e.dispose)==null||t.call(e)}async loadText(i=this.text,e=this.language){var t;const r=this;r._text=i,r._language=e,(t=r.codeModel)==null||t.dispose(),await r.editorReady;const n=r.codeModel=r.monacoInstance.editor.createModel(i,e);return r.editor.setModel(n),r.trigger("load",{model:n,text:i}),n}onEditorDestroy(){var i,e;(e=(i=this.codeModel)==null?void 0:i.dispose)==null||e.call(i),this.codeModel=null}onEditorConfigChange(){const i=this;i.editor&&(i.readOnly=i.editor.getOptions().get(i.monacoInstance.editor.EditorOptions.readOnly.id))}onCursorMove({position:i}){var e;(e=this.widgetMap.cursorPos)==null||e.setPosition(i)}};v(Fr,"$name","CodeEditor"),v(Fr,"type","codeeditor"),v(Fr,"configurable",{textContent:!1,scrollable:null,codePath:null,editor:{$config:["lazy","nullify"],value:{automaticLayout:!0,scrollBeyondLastLine:!1}},header:{cls:"demo-header"},bbar:{overflow:null,items:{readOnly:{hidden:!0,type:"widget",cls:"b-icon b-icon-locked"},status:{type:"widget",html:"\xA0"},cursorPos:{type:"widget",html:"\xA0",setPosition({lineNumber:i,column:e}){this.element.innerHTML=`Ln ${i}, Col ${e}`}}}},readOnly:null,text:{$config:["lazy","nullify"],value:null},language:null,theme:null,status:null}),Fr.initClass(),Fr._$name="CodeEditor";var ws=class extends pi{configure(i){super.configure(i),this.setItems(),this.ion({item:"onColorSelect"})}setItems(){const i=this,{colors:e,colorClasses:t}=i;let r=t||e;i.addNoColorItem&&(i.store.modelClass.allowNullId=!0,r=[...r,null]),i.items=r.map(n=>!n||typeof n=="string"?{color:n,text:(t?O.capitalize(n):n)||i.L("L{noColor}")}:n)}afterConfigure(){var i;super.afterConfigure(...arguments),(this.addNoColorItem||this.value)&&this.select((i=this.value)!=null?i:null)}updateColors(){this.isConfiguring||this.setItems()}updateAddNoColorItem(){this.isConfiguring||this.setItems()}onColorSelect({record:i}){var e;this.refresh();const t={color:i.color,record:i,bubbles:!0};(e=this.colorSelected)==null||e.call(this,t),this.trigger("colorSelected",t)}select(i){(!i||typeof i=="string")&&(i=this.store.findRecord("color",i!=null?i:null)),i&&super.select(i)}updateColumns(i){this.style=`grid-template-columns:repeat(${i}, 1fr);`}getColorClassName(i){var e,t;return(e=this.colorClasses)!=null&&e.includes(i)||(t=this.colorClasses)!=null&&t.find(r=>r&&r.color===i)?this.colorClassPrefix+i:i?"":"b-no-color"}};v(ws,"$name","ColorPicker"),v(ws,"type","colorpicker"),v(ws,"configurable",{itemsFocusable:!1,navigator:{focusCls:"b-color-active"},itemWrapperTpl(i,e){const{selected:t}=this,{color:r,text:n}=i,s=this.getColorClassName(r);return mi.tpl`
                    <li
                        class="${this.getItemClasses(i,e)} ${s}"
                        role="option"
                        aria-selected="${t.includes(i)}"
                        data-index="${e}"
                        data-id="${O.encodeHtml(r)}"
                        data-btip="${n}"
                        ${this.itemsFocusable?'tabindex="-1"':""}
                        style="${s?"":"background-color: "+r}"
                    ></li>`},colorClasses:null,colorClassPrefix:null,colors:["#45171D","#F03861","#FF847C","#FECEA8","#A5F2E7","#AA83F3","#8983F3","#A10054","#073059","#2866AB","#5FBDC5","#D8D95C","#FFDEDE","#F7F3CE","#C5ECBE","#3E3E3E","#405559","#68868C","#EDEDED","#D3D6DB","#3A4750","#303841","#BE3144"],addNoColorItem:!0,columns:6,colorSelected:null,store:{useRawData:!1}}),ws.initClass(),ws._$name="ColorPicker";var kr=class extends ze{configure(i){var e;const t=(e=i.picker)!=null?e:{};i.colors&&(t.colors=i.colors),"addNoColorItem"in i&&(t.addNoColorItem=i.addNoColorItem),i.picker=t,super.configure(i)}updatePicker(i,e){super.updatePicker(i,e),i&&(this.items=i.store.records)}updateColors(i){this.isConfiguring||(this.picker.colors=i)}updateAddNoColorItem(i){this.isConfiguring||(this.picker.addNoColorItem=i)}set value(i){this.store||(this.items=[],this.store=this.picker.store),i||(i=this.store.findRecord("color",null)),super.value=i}showPicker(){this.picker.refresh(),super.showPicker(...arguments)}get value(){return super.value}syncInputFieldValue(...i){var e;const t=this,{value:r}=t;let n=(e=t.picker)==null?void 0:e.getColorClassName(r);n||(t.colorBox.style.color=r),n="b-colorbox "+n,t.colorBox.className=n,t.showBoxForNoColor||t.element.classList.toggle("b-colorless",!r),super.syncInputFieldValue(...i)}get innerElements(){return[{reference:"colorBox",className:"b-colorbox"},...super.innerElements]}};v(kr,"$name","ColorField"),v(kr,"type","colorfield"),v(kr,"configurable",{displayField:"text",valueField:"color",editable:!1,picker:{type:"colorpicker",align:{align:"t100-b100",matchSize:!1}},showBoxForNoColor:!0,colors:null,addNoColorItem:!0}),kr.initClass(),kr._$name="ColorField";var LL=["ok","cancel","yes","no"].reduce((i,e,t,r)=>(i[e]=Object.freeze({...Object.fromEntries(r.map(n=>[n,!1])),name:e,approve:"ok,yes".includes(e),[e]:!0}),i),Object.create(null)),mx=["b-raised","b-blue"],px=["b-gray"],pg=K.isWindows,OL=/(?:\s+,?|,)\s*/,$L=/^(icon|menu|text)$/,Es=class extends Ja{get buttons(){return this.items.filter(i=>i.isButton)}get cancelButton(){return this.widgetMap.cancel||null}get noButton(){return this.widgetMap.no||null}get okButton(){return this.widgetMap.ok||null}get yesButton(){return this.widgetMap.yes||null}changeItems(i,e){return typeof i=="string"&&(i=Object.fromEntries(i.split(OL).map(t=>[t,!0]))),super.changeItems(i,e)}clickButton(i,e){const t=this,{widgetMap:r,defaultButton:n}=t;let s=e?r.cancel||r.no:r[n],a,o;if(!s){for([o,a]of Object.entries(r))if(o!==n){s=a;break}}s==null||s.onInternalClick(i)}doCancel(i){this.clickButton(i,!0)}doDefault(i){this.clickButton(i)}onButtonClick(i){this.trigger("choice",{...i,choice:LL[i.source.ref],source:this,userAction:!0})}onChildAdd(i){super.onChildAdd(i),Se.before(i,"onConfigChange","onChildConfigChange",this),this.syncButtons()}onChildConfigChange({name:i}){$L.test(i)&&this.syncButtons()}onChildRemove(i){super.onChildRemove(i),this.syncButtons()}onInternalPaint(i){super.onInternalPaint(i),i.firstPaint&&this.syncButtons.resume(),this.syncButtons.now()}syncButtons(){const i=this,e=i.isDestroying?[]:i.buttons,{defaultButton:t}=i;let r,n;i.syncWidthButtons!==!1&&e.forEach(s=>{(n=s.text)&&(r=Math.max(r||0,n.length+!!s.icon+!!s.menu))}),e.forEach(s=>{const{classList:a}=s.element,o=s.ref===t;a.add(...o?mx:px),a.remove(...o?px:mx),a.toggle("b-default-button",o),s.minWidth=r&&s.text?`${r}em`:null})}updateAutoWidthButtons(){this.syncButtons()}updateDefaultButton(){this.syncButtons()}};v(Es,"$name","ConfirmationBar"),v(Es,"type","confirmationbar"),v(Es,"configurable",{defaultButton:"ok",defaultType:"button",items:"ok,cancel",keyMap:{Enter:"doDefault",NumpadEnter:"doDefault",Escape:"doCancel"},namedItems:{yes:{cls:"b-yes-button",text:"L{Object.Yes}",onClick:"up.onButtonClick",weight:pg?100:130},no:{cls:"b-no-button",text:"L{Object.No}",onClick:"up.onButtonClick",weight:pg?110:120},ok:{cls:"b-ok-button",text:"L{Object.Ok}",onClick:"up.onButtonClick",weight:pg?120:110},cancel:{cls:"b-cancel-button",text:"L{Object.Cancel}",onClick:"up.onButtonClick",weight:pg?130:100}},syncWidthButtons:null}),v(Es,"delayable",{syncButtons:{type:"raf",suspended:!0}}),Es.initClass(),Es._$name="ConfirmationBar";var mn=class extends ei{construct(i){super.construct({year:new Date().getFullYear(),...i}),j.on({element:this.contentElement,click:"onYearClick",delegate:".b-yearpicker-year",thisObj:this})}get focusElement(){return this.getYearButton(this.year)||this.getYearButton(this.startYear)}getYearButton(i){return this.contentElement.querySelector(`.b-yearpicker-year[data-year="${i}"]`)}get value(){return this.year}set value(i){this.year=i}onYearClick({target:i}){const e=Math.min(Math.max(parseInt(i.innerText),this.minYear||1),this.maxYear||9999);this.year===e?this.trigger("select",{oldValue:e,value:e}):this.year=e}handleTitleClick(i){this.trigger("titleClick",i)}previous(){this.startYear=this.startYear-this.yearButtonCount}next(){this.startYear=this.endYear+1}ingestYear(i){if(!isNaN(i))return T.isDate(i)?i.getFullYear():i}changeYear(i){if(i=this.ingestYear(i))return Math.min(Math.max(i,this.minYear||1),this.maxYear||9999)}updateYear(i,e){const t=this;!t.startYear||i>t.endYear?t.startYear=i:i<t.startYear&&(t.startYear=i-(t.yearButtonCount-1)),t.isConfiguring||t.trigger("select",{oldValue:e,value:i})}get endYear(){return this.startYear+this.yearButtonCount-1}changeStartYear(i){if(i=this.ingestYear(i))return i=this.minYear?Math.max(i,this.minYear):i,this.maxYear?Math.min(i,this.maxYear-(this.yearButtonCount-1)):i}async updateStartYear(i,e){this.isVisible&&E.slideIn(this.contentElement,Math.sign(i-e))}composeBody(){this.getConfig("year");const{startYear:i}=this,e=super.composeBody(),t=e.children[this.tbar?1:0].children=[];this.widgetMap.title.text=`${`000${i}`.slice(-4)} - ${`000${this.endYear}`.slice(-4)}`;for(let r=0,n=i;r<this.yearButtonCount;r++,n++)t.push({tag:"button",dataset:{year:n},class:{"b-yearpicker-year":1,"b-selected":n===this.year},text:`000${n}`.slice(-4)});return e}};v(mn,"$name","YearPicker"),v(mn,"type","yearpicker"),v(mn,"configurable",{textContent:!1,tbar:{overflow:null,items:{previous:{type:"tool",cls:"b-icon b-icon-previous",onAction:"up.previous",weight:100},title:{type:"button",cls:"b-yearpicker-title",weight:200,onAction:"up.handleTitleClick"},next:{type:"tool",cls:"b-icon b-icon-next",onAction:"up.next",weight:300}}},itemCls:"b-year-container",yearButtonCount:12,year:null,minYear:null,maxYear:null,startYear:null}),mn.initClass(),mn._$name="YearPicker";var so=class extends Fi{static get configurable(){return{readOnly:!0,editable:!1,cls:"b-display-field",template:null,ariaElement:"displayElement"}}get focusElement(){}changeReadOnly(){return!0}changeEditable(){return!1}get inputElement(){return{tag:"span",id:`${this.id}-input`,reference:"displayElement",html:this.template?this.template(this.value):O.encodeHtml(this.value)}}};v(so,"$name","DisplayField"),v(so,"type","displayfield"),v(so,"alias","display"),so.initClass(),so._$name="DisplayField";var vx=()=>w.getMonthNames().map((i,e)=>[e,i]),yx=(i,e)=>i.valueOf()-e.valueOf(),{DateSet:vg}=w,BL=Object.freeze([]),hy=class extends ze{static get configurable(){return{editable:!1,inputAttributes:{tag:"div",tabIndex:-1},inputValueAttr:"innerHTML",highlightExternalChange:!1,monitorResize:!1,triggers:{expand:!1},picker:{align:{align:"t-b",axisLock:!0,matchSize:!1},cls:"b-readonly-combo-list",scrollable:{overflowX:!1}}}}};v(hy,"$name","ReadOnlyCombo"),v(hy,"type","readonlycombo"),hy.initClass();var Zi=class extends gn{static get delayable(){return{refresh:"raf"}}static get configurable(){return{activeDate:{$config:"date",value:"today"},focusable:!0,textContent:!1,tbar:{overflow:null,items:{prevYear:{cls:"b-icon b-icon-first b-datepicker-nav-button",onAction:"up.gotoPrevYear",tooltip:"L{DatePicker.gotoPrevYear}"},prevMonth:{cls:"b-icon b-icon-previous b-datepicker-nav-button",onAction:"up.gotoPrevMonth",tooltip:"L{DatePicker.gotoPrevMonth}"},fields:{type:"container",cls:"b-datepicker-title",items:{monthField:{type:"readonlycombo",cls:"b-datepicker-monthfield",items:vx(),internalListeners:{select:"up.onMonthPicked"}},yearButton:{type:"button",cls:"b-datepicker-yearbutton",internalListeners:{click:"up.onYearPickerRequested"}}}},nextMonth:{cls:"b-icon b-icon-next b-datepicker-nav-button",onAction:"up.gotoNextMonth",tooltip:"L{DatePicker.gotoNextMonth}"},nextYear:{cls:"b-icon b-icon-last b-datepicker-nav-button",onAction:"up.gotoNextYear",tooltip:"L{DatePicker.gotoNextYear}"}}},yearPicker:{value:{type:"YearPicker",yearButtonCount:16,trapFocus:!0,positioned:!0,hidden:!0,internalListeners:{titleClick:"up.onYearPickerTitleClick",select:"up.onYearPicked"}},$config:"lazy"},date:null,minDate:{$config:"date",value:null},maxDate:{$config:"date",value:null},focusDisabledDates:null,multiSelect:null,selection:{$config:{equal:(i,e)=>i&&i.equals(e)},value:null},editMonth:{$config:"lazy",value:null},includeYear:{$config:"lazy",value:null},dayNameFormat:"dd",trapFocus:!0,role:"grid",focusDescendant:!0,alwaysRefreshOnMonthChange:null,highlightSelectedWeek:null}}static get prototypeProperties(){return{outOfRangeCls:"b-out-of-range",activeCls:"b-active-date",selectedCls:"b-selected-date"}}construct(i){const e=this;super.construct(i),e.externalCellRenderer=e.cellRenderer,e.cellRenderer=e.internalCellRenderer,e.element.setAttribute("aria-activedescendant",`${e.id}-active-day`),e.weeksElement.setAttribute("role","grid"),e.weekElements.forEach(t=>t.setAttribute("role","row")),e.element.setAttribute("ariaLabelledBy",e.widgetMap.fields.id),j.on({element:e.weeksElement,click:{handler:"onCellClick",delegate:`.${e.dayCellCls}:not(.${e.disabledCls}):not(.${e.outOfRangeCls})`},mousedown:{handler:"onCellMousedown",delegate:`.${e.dayCellCls}`},thisObj:e}),e.getConfig("editMonth"),e.getConfig("includeYear"),e.refresh.flush()}afterHide(){var i;(i=this._yearPicker)==null||i.hide(),super.afterHide(...arguments)}doDestroy(){var i,e;(i=this.yearButton)==null||i.destroy(),(e=this.monthField)==null||e.destroy(),super.doDestroy()}get activeDayCell(){return this.weeksElement.querySelector(`#${this.id}-active-day`)}get focusElement(){return!this.disabled&&this.activeDayCell||this.element}onMonthDateChange(i){const e=super.onMonthDateChange(i);return this.refresh.flush(),e}updateEditMonth(i){const{monthField:e,yearButton:t}=this.widgetMap,r=i===!1;e.readOnly=r,t.disabled=r}updateIncludeYear(i){const{yearButton:e}=this.widgetMap;e.hidden=i===!1}doRefresh(...i){const e=this,{date:t}=e,r=e.activeDayCell,n=w.betweenLesser(e.activeDate,e.month.startDate,e.month.endDate)?e.activeDate:e._activeDate=t;e.getConfig("tbar"),super.doRefresh(...i),e.widgetMap.monthField.value=t.getMonth(),e.widgetMap.yearButton.text=t.getFullYear();const s=w.parseKey(r==null?void 0:r.dataset.date);n-s&&e.syncActiveDate(n,s)}internalCellRenderer({cell:i,date:e}){const t=this,{activeCls:r,selectedCls:n,externalCellRenderer:s}=t,a=t.isSelectedDate(e),o={[r]:r&&t.isActiveDate(e),[n]:a,[t.outOfRangeCls]:t.minDate&&e<t.minDate||t.maxDate&&e>t.maxDate};if(a&&t.multiSelect){const l=!t.isSelectedDate(w.add(e,-1,"d")),d=!t.isSelectedDate(w.add(e,1,"d"));o["b-range-start"]=l,o["b-range-end"]=d,o["b-in-range"]=!l&&!d}E.updateClassList(i,o),i.innerHTML=`<div class="b-datepicker-cell-inner">${e.getDate()}</div>`,i.setAttribute("role","gridcell"),i.setAttribute("aria-label",w.format(e,"MMMM D, YYYY")),t.isActiveDate(e)?i.id=`${t.id}-active-day`:i.removeAttribute("id"),s&&(arguments[0].cell=i.firstChild,t.callback(s,this,arguments))}onCellMousedown(i){const e=i.target.closest("[data-date]");this.focusable?(e.focus(),E.getActiveElement(e)===e&&i.preventDefault()):i.preventDefault(),this.activeDate=w.parseKey(e.dataset.date)}onCellClick(i){const e=i.target.closest("[data-date]");this.onUIDateSelect(w.parseKey(e.dataset.date),i)}onUIDateSelect(i,e){const t=this,{lastClickedDate:r,multiSelect:n}=t;t.isDisabledDate(i)||t.trigger("beforeDateSelect",{date:i,event:e})!==!1&&(t.lastClickedDate=i,t.activatingEvent=e,n?t.handleMultiSelect(r,i,e):(t.date=t.selection=i,t.floating&&t.hide()),t.activatingEvent=null)}handleMultiSelect(i,e,t){const r=this,{multiSelect:n}=r,s=r._selection||(r._selection=new vg),a=s.dates,o=n==="range"||n==="simple",l=n==="simple"||E.isTouchEvent,{size:d,generation:c}=s,u=d&&{[w.makeKey(w.add(a[0],-1,"d"))]:1,[w.makeKey(a[0])]:1,[w.makeKey(a[a.length-1])]:1,[w.makeKey(w.add(a[a.length-1],1,"d"))]:1},h=s.has(e),f=h?"delete":"add",g=o&&(u==null?void 0:u[w.makeKey(e)]);if(l&&d>1)s.clear(),s.add(e);else if(t.ctrlKey)(n===!0||!d||g)&&(s[f](e),o&&!s.has(r.rangeStartDate)&&r.rangeStartDate.setDate(r.rangeStartDate.getDate()+(e<a[1]?1:-1)));else if((l||t.shiftKey)&&d){const[p,y]=[new Date(o?r.rangeStartDate||(r.rangeStartDate=a[0]):i),e].sort(yx);o&&s.clear();for(const b=p;b<=y;b.setDate(b.getDate()+1))s.add(b)}else s.has(e)&&s.size===1||(s.clear(),s.add(e));const m=s.size;m===1?r.rangeStartDate=e:m||(r.rangeStartDate=null),s.generation!==c&&r.updateSelection(s)}updateHighlightSelectedWeek(i){this.element.classList.toggle("b-highlight-selected-week",!!i)}updateMultiSelect(i){this.element.classList.toggle("b-multiselect",!!i),i||(this.selection=[...this.selection][0])}get selection(){const{_selection:i}=this,e=i?i.dates:BL;return this.multiSelect==="range"&&e.length?[e[0],e[e.length-1]]:e}changeSelection(i,e){const t=this;let r,n;if(!i)r=new vg;else if(i.isDateSet){if(e===i||e!=null&&e.equals(i))return e;n=T.first(i),r=i}else if(i.forEach||(i=[i]),i.forEach((s,a)=>i[a]=t.changeDate(s)),n=i[0],i.sort(yx),t.multiSelect==="range"&&i.length===2){r=new vg;for(const s=new Date(i[0]);s<=i[1];s.setDate(s.getDate()+1))r.add(s)}else n=i[0],r=new vg(i);return n&&(t.rangeStartDate=w.clearTime(n)),r}updateSelection(i){const e=this,{dates:t}=i,r=e.multiSelect==="range"?[t[0],t[t.length-1]]:t;e.isConfiguring||(e.refresh.now(),e.trigger("selectionChange",{selection:r,userAction:!!e.activatingEvent}))}onInternalKeyDown(i){const e=this,t=i.key.trim()||i.code,r=e.activeDate;let n=new Date(r);if(t==="Escape"&&e.floating)return e.hide();if(r&&e.weeksElement.contains(i.target)){do switch(t){case"ArrowLeft":i.preventDefault(),i.ctrlKey?n=e.gotoPrevMonth():n.setDate(n.getDate()-1);break;case"ArrowUp":i.preventDefault(),n.setDate(n.getDate()-7);break;case"ArrowRight":i.preventDefault(),i.ctrlKey?n=e.gotoNextMonth():n.setDate(n.getDate()+1);break;case"ArrowDown":i.preventDefault(),n.setDate(n.getDate()+7);break;case"Enter":return e.onUIDateSelect(r,i)}while(e.isDisabledDate(n)&&!e.focusDisabledDates);if(e.minDate&&n<e.minDate||e.maxDate&&n>e.maxDate)return;e.activeDate=n}}changeMinDate(i){return i&&gn.prototype.changeDate.apply(this,arguments)}updateMinDate(i){this._yearpicker&&(this._yearpicker.minYear=i==null?void 0:i.getFullYear()),this.refresh()}changeMaxDate(i){return i&&gn.prototype.changeDate.apply(this,arguments)}updateMaxDate(i){this._yearpicker&&(this._yearpicker.maxYear=i==null?void 0:i.getFullYear()),this.refresh()}changeDate(i){return w.clamp(super.changeDate(i),this.minDate,this.maxDate)}updateDate(i,e){const t=this,{month:r}=t;if(t.isConfiguring&&!t.initializingActiveDate&&("selection"in t.initialConfig||(t.selection=i),"activeDate"in t.initialConfig||(t.activeDate=i)),!r.date||i.getMonth()===r.month||!t.getCell(i)||t.alwaysRefreshOnMonthChange||t.isNavigating)super.updateDate(i);else{const n=r.getOtherMonth(i),s=t.eventListeners&&(e?i.getDate()!==e.getDate()|(n.getWeekId(i)!==r.getWeekId(e))<<1|(i.getMonth()!==(e==null?void 0:e.getMonth()))<<2|(i.getFullYear()!==(e==null?void 0:e.getFullYear()))<<3:15);t.trigger("dateChange",{changes:{d:!0,w:!!(s&2),m:!!(s&12),y:!!(s&8),r:n.weekCount!==r.weekCount},value:i,oldValue:e})}}changeActiveDate(i,e){const t=this;if(i==="today"&&(i=new Date),t.trigger("beforeActiveDateChange",{activeDate:i,oldActiveDate:e})!==!1){if(i=i?t.changeDate(i):t.date||(t.date=w.clearTime(new Date)),isNaN(i))throw new Error("DatePicker activeDate must be passed a Date, or a YYYY-MM-DD date string");return w.clamp(i,t.minDate,t.maxDate)}}updateActiveDate(i,e){const t=this,{isConfiguring:r}=t;(r||!t.getCell(i))&&(t.initializingActiveDate=r,t.date=i,t.initializingActiveDate=!1),!r&&!t.refresh.isPending&&t.syncActiveDate(i,e)}syncActiveDate(i,e){const t=this,{activeCls:r}=t,n=t.getCell(i),s=e&&t.getCell(e),a=E.getActiveElement(t.element);n&&(t.focusable&&n.setAttribute("tabIndex","0"),r&&n.classList.add(r),n.id=`${t.id}-active-day`,t.weeksElement.contains(a)&&n.focus()),s&&s!==n&&(t.focusable&&s.removeAttribute("tabIndex"),r&&s.classList.remove(r),s.removeAttribute("id"))}set value(i){const e=this,{selection:t,duration:r}=e;if(e.isNavigating=!0,i){if(i=e.changeDate(i,e.value),e.multiSelect==="range"&&(t==null?void 0:t.length)===2){w.betweenLesserEqual(i,...t)||(i<t[0]?e.selection=[i,w.add(i,r-1,"d")]:e.selection=[w.add(i,-(r-1),"d"),i]),e.date=e.activeDate=i;return}i!==void 0&&(e.selection=i,e.date=e.activeDate=i)}else e.date=e.activeDate=new Date,e.selection=null;e.isNavigating=!1}get value(){const{selection:i}=this,e=(i==null?void 0:i.length)||null;return e&&i[e-1]}get duration(){return this.multiSelect==="range"?w.diff(...this.selection,"d")+1:1}gotoPrevYear(){return this.goto(-1,"year")}gotoPrevMonth(){return this.goto(-1,"month")}gotoNextMonth(){return this.goto(1,"month")}gotoNextYear(){return this.goto(1,"year")}goto(i,e){const t=this,{activeDate:r}=t,n=r&&t.getCell(r);let s;e==="month"&&n&&(r==null?void 0:r.getMonth())===t.month.month+i?s=r:s=w.add(n?r:t.date,i,e);const a=new Date(s);a.setDate(1);const o=w.add(w.add(a,1,"month"),-1,"day");if(t.minDate&&i<0&&o<t.minDate||t.maxDate&&i>0&&a>t.maxDate)return;t.isNavigating=!0;const l=t.date=s;return n&&(t.activeDate=s),t.isNavigating=!1,l}isActiveDate(i){return!(i-this.activeDate)}isSelectedDate(i){var e;return(e=this._selection)==null?void 0:e.has(i)}onFocusIn(i){var e;super.onFocusIn(i),i.toWidget===this&&i._target===this.element&&!this.disabled&&((e=this.focusElement)==null||e.focus())}onMonthPicked({record:i,userAction:e}){var t;e&&(this.activeDate=w.add(this.activeDate,i.value-this.activeDate.getMonth(),"month"),(t=this.focusElement)==null||t.focus())}onYearPickerRequested(){const{yearPicker:i}=this;i.isVisible?i.hide():(i.year=i.startYear=this.activeDate.getFullYear(),i.show(),i.focus())}onYearPickerTitleClick(){this.yearPicker.hide()}onYearPicked({value:i,source:e}){var t;const r=new Date(this.activeDate);r.setFullYear(i),this.activeDate=r,(t=this.focusElement)==null||t.focus({preventScroll:!0}),e.hide()}changeYearPicker(i,e){var t,r;return mn.reconfigure(e,i?mn.mergeConfigs({owner:this,appendTo:this.element,minYear:(t=this.minDate)==null?void 0:t.getFullYear(),maxYear:(r=this.maxDate)==null?void 0:r.getFullYear()},i):null,this)}get childItems(){const{_yearPicker:i}=this,e=super.childItems;return i&&e.push(i),e}updateLocalization(){var i;const{monthField:e}=this.widgetMap,t=vx();!this.isConfiguring&&!t.every((r,n)=>r[1]===e.store.getAt(n).text)&&(t[(i=e.value)!=null?i:this.date.getMonth()].selected=!0,e.items=t),super.updateLocalization()}changeMultiSelect(i){return i==="range"&&K.isTouchDevice&&(i="simple"),i}};v(Zi,"$name","DatePicker"),v(Zi,"type","datepicker"),Zi.initClass(),Zi._$name="DatePicker";var It=class extends _r{static get configurable(){return{format:"L",strictParsing:!1,fallbackFormat:"YYYY-MM-DD",timeFormat:"HH:mm:ss:SSS",keepTime:!1,pickerFormat:null,validateDateOnly:null,triggers:{expand:{cls:"b-icon-calendar",handler:"onTriggerClick",weight:200},back:{cls:"b-icon b-icon-angle-left b-step-trigger b-step-trigger-back",key:"Shift+ArrowDown",handler:"onBackClick",align:"start",weight:100},forward:{cls:"b-icon b-icon-angle-right b-step-trigger b-step-trigger-forward",key:"Shift+ArrowUp",handler:"onForwardClick",align:"end",weight:100}},calendarContainerCls:"",min:null,max:null,step:!1,stepTriggers:{$config:null,default:!0},weekStartDay:null,picker:{type:"datepicker",role:"dialog",floating:!0,scrollAction:"realign",align:{align:"t0-b0",axisLock:!0}},value:null}}changePicker(i,e){var t;if(i!=null&&i.isDatePicker)return i;const r=this,n=Zi.mergeConfigs({owner:r,forElement:r.pickerAlignElement,minDate:r.min,maxDate:r.max,weekStartDay:r._weekStartDay,align:{anchor:r.overlayAnchor,target:r.pickerAlignElement},onSelectionChange:({selection:a,source:o})=>{o.isVisible&&(r._isUserAction=r._isPickerInput=!0,r.value=r.value?w.copyTimeValues(new Date(a[0]),r.value):new Date(a[0]),r._isPickerInput=r._isUserAction=!1,o.hide())}},i);r.calendarContainerCls&&(n.cls=r.calendarContainerCls),r.value?n.value=r.value:n.activeDate||(n.activeDate=new Date);const s=Zi.reconfigure(e,i?n:null,r);return(t=s==null?void 0:s.refresh)==null||t.flush(),s}getStepDate(i){const{step:e}=this;return w.add(this.value,(i||1)*e.magnitude,e.unit)}stepDate(i,e=!0){const t=this;if(!t.readOnly&&t.value){const r=t.getStepDate(i);t.checkMinMax(r)||(e?(t._isUserAction=!0,t.value=r,t.autoSelect&&t.select(),t._isUserAction=!1):t.value=r)}}onBackClick(){this.stepDate(-1)}onForwardClick(){this.stepDate(1)}showPicker(i){if(this.readOnly)return;const e=this,{_picker:t}=e;if(t){const r={minDate:e.min,maxDate:e.max};e.value?r.value=e.value:t.activeDate||(r.activeDate=new Date),t.setConfig(r)}super.showPicker(i)}focusPicker(){var i;(i=this.picker)==null||i.focus()}checkMinMax(i){const{min:e,max:t}=this;return e&&i<e?-1:t&&i>t?1:0}get isValid(){const i=this;i.clearError("L{Field.minimumValueViolation}",!0),i.clearError("L{Field.maximumValueViolation}",!0);let{value:e}=i;if(e){let{min:t,max:r,validateDateOnly:n}=i;if(n&&(e=w.clearTime(e,!1),t&&(t=w.clearTime(t,!1)),r&&(r=w.clearTime(r,!1))),t&&e<t)return i.setError("L{Field.minimumValueViolation}",!0),!1;if(r&&e>r)return i.setError("L{Field.maximumValueViolation}",!0),!1}return super.isValid}transformDateValue(i,e=!0){const t=this;return i!=null&&(w.isDate(i)||(typeof i=="string"?i=w.parse(i,t.format,t.strictParsing)||w.parse(i,t.fallbackFormat,t.strictParsing):i=new Date(i)),w.isValidDate(i))?e&&(!t.min||i-t.min>-w.MS_PER_DAY)&&(!t.max||i<=t.max)?t.transformTimeValue(i):i:null}transformTimeValue(i){const e=this,{keepTime:t}=e;if(i=w.clone(i),!t)w.clearTime(i,!1);else if(t!=="entered"&&t!==!0){const r=w.parse(t,e.timeFormat);w.isValidDate(r)?w.copyTimeValues(i,r):w.isValidDate(e.value)&&w.copyTimeValues(i,e.value)}else t===!0&&(e._isPickerInput||e.inputting)&&w.isValidDate(e.value)&&w.copyTimeValues(i,e.value);return i}changeMin(i){return this.transformDateValue(i,!1)}updateMin(i){const{input:e,_picker:t}=this;e&&(i==null?e.removeAttribute("min"):e.min=i),t&&(t.minDate=i),this.syncInvalid()}changeMax(i){return this.transformDateValue(i,!1)}updateMax(i){const{input:e,_picker:t}=this;e&&(i==null?e.removeAttribute("max"):e.max=i),t&&(t.maxDate=i),this.syncInvalid()}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:w.weekStartDay}updateWeekStartDay(i){this._picker&&(this._picker.weekStartDay=i)}changeValue(i,e){const t=this,r=t.transformDateValue(i);if(i&&!r){(!t.inputting||t.validateOnInput)&&t.setError("L{invalidDate}");return}if(t.clearError("L{invalidDate}"),t.hasChanged(e,r))return super.changeValue(r,e);t.inputting||t.syncInputFieldValue()}updateValue(i,e){const t=this._picker;t&&!this.inputting&&(t.value=t.activeDate=i),super.updateValue(i,e)}changeStep(i,e){const t=typeof i;if(!i)return null;if(t==="number"?i={magnitude:Math.abs(i),unit:e?e.unit:"day"}:t==="string"&&(i=w.parseDuration(i)),i&&i.unit&&i.magnitude)return i.magnitude<0&&(i={magnitude:-i.magnitude,unit:i.unit}),i}updateStep(i){this.element.classList[i?"remove":"add"]("b-no-steppers"),this.syncInvalid()}hasChanged(i,e){return i!=null&&i.getTime&&(e!=null&&e.getTime)&&this.keepTime!=="entered"&&this.keepTime!==!0?!w.isEqual(w.clearTime(i),w.clearTime(e)):super.hasChanged(i&&i.getTime(),e&&e.getTime())}get inputValue(){const i=this.value;return i?w.format(i,this.format):""}updateFormat(){this.isConfiguring||this.syncInputFieldValue(!0)}updateLocalization(){super.updateLocalization(),this.syncInputFieldValue(!0)}internalOnKeyEvent(i){var e;if(super.internalOnKeyEvent(i),i.type==="keydown"){const t=this;let r;switch(i.virtualKey){case"Enter":t.isValid&&((e=t.picker)==null||e.hide());break;case"ArrowLeft":(t.caretAtStart||t.selectedAll)&&(r=-1);break;case"ArrowRight":(t.caretAtEnd||t.selectedAll)&&(r=1);break;case"NumpadAdd":r=1;break;case"NumpadSubtract":r=-1;break}r&&t.step&&(t.stepDate(r),t.selectAll(),i.preventDefault())}}};v(It,"$name","DateField"),v(It,"type","datefield"),v(It,"alias","date"),It.initClass(),It._$name="DateField";var yg=class{static getLocalizedFormatter(i){return(i==null?void 0:i.style)==="currency"&&!i.currency&&(i.currency=$e.locale.NumberFormat.currency),typeof i=="string"?Ti.get({locale:$e.localeCode,template:i}):(i==null?void 0:i.locale)!=null?Ti.get(i):Ti.get(Object.assign({},i,{locale:$e.localeCode}))}};v(yg,"$name","NumberHelper"),yg._$name="NumberHelper";var HL=i=>i.ctrlKey&&i.preventDefault(),ao=class extends ct{static get configurable(){return{wrapAround:null,min:null,max:null,step:1,largeStep:0,value:null,format:"",triggers:{spin:{type:"spintrigger"}},changeOnSpin:!0,inputType:null}}construct(i){super.construct(i);const e=this;e.input.addEventListener("dblclick",()=>{e.select()}),typeof e.changeOnSpin=="number"&&(e.bufferedSpinChange=e.buffer(e.triggerChange,e.changeOnSpin))}acceptValue(i,e){let t=!isNaN(i);if(t&&!this.hasTextSelection){t=!1;const r=this.input.value,n=parseFloat(r);r!==e&&(t=!this.acceptValue(n,r))}return t}okMax(i){return isNaN(this.max)||i<=this.max}okMin(i){return isNaN(this.min)||i>=this.min}internalOnKeyEvent(i){if(i.type==="keydown"){const e=this,t=i.key;let r;if(t==="ArrowUp")e.doSpinUp(i.shiftKey),r=!0;else if(t==="ArrowDown")e.doSpinDown(i.shiftKey),r=!0;else if(!i.altKey&&!i.ctrlKey&&t&&t.length===1){const n=e.getAfterValue(t),s=e.formatter.parseStrict(n);r=!(s===e.value||n==="-"&&(isNaN(e.min)||e.min<0))&&!e.acceptValue(s,n)}t==="Enter"&&e._changedBySilentSpin&&(e.triggerChange(i,!0),e._changedBySilentSpin=!1),r&&i.preventDefault()}super.internalOnKeyEvent(i)}doSpinUp(i=!1){const e=this;if(e.readOnly)return;let t=(e.value||0)+(i?e.largeStep:e.step);e.okMin(t)||(t=e.min),e.okMax(t)?e.applySpinChange(t):e.wrapAround&&(t=e.min,e.applySpinChange(t))}doSpinDown(i=!1){const e=this,t=i?e.largeStep:e.step;if(e.readOnly)return;let r=(e.value||0)-t;e.okMax(r)||(r=e.max),e.okMin(r)?e.applySpinChange(r):e.wrapAround&&(r=e.max-e.max%t,e.applySpinChange(r))}applySpinChange(i){const e=this;e._isUserAction=!0,e.changeOnSpin!==!0&&(e._changedBySilentSpin=!0,e.silenceChange=!0,e.bufferedSpinChange&&e.bufferedSpinChange(null,!0)),e.value=i,e._isUserAction=!1,e.silenceChange=!1}triggerChange(){this.silenceChange||super.triggerChange(...arguments)}onFocusOut(i){var e,t,r;super.onFocusOut(...arguments);const n=this,{input:s}=n,a=s.value,o=n.formatter.truncate(a),l=isNaN(o)?a:n.formatValue(o);(r=(t=(e=n.triggers)==null?void 0:e.spin)==null?void 0:t.clickRepeater)==null||r.cancel(),n.lastTouchmove=null,a!==l&&(s.value=l),n._changedBySilentSpin&&(n.triggerChange(i,!0),n._changedBySilentSpin=!1)}internalOnInput(i){const e=this,{formatter:t,input:r}=e,{parser:n,maximumFractionDigits:s}=t,a=r.value,o=n.decimalPlaces(a);if(t.truncator&&o>s){let l=a,d;const c=t.truncate(a);if(!isNaN(c)&&(l=e.formatValue(c),d=n.decimalPlaces(l),d<s&&(l+="0".repeat(s-d),d=s),d<o)){const u=a.length-e.caretPos;r.value=l,e.caretPos=l.length-u+1}}super.internalOnInput(i)}formatValue(i){return this.formatter.format(i)}get formatter(){const i=this;return i._formatter!==void 0?i._formatter:i._formatter=yg.getLocalizedFormatter(i.format)}updateStep(i){var e;const t=this;t.element.classList.toggle("b-hide-spinner",!i),t._step=i,i&&K.isMobile?t.touchMoveListener||(t.touchMoveListener=j.on({element:t.input,touchmove:"onInputSwipe",thisObj:t,throttled:{buffer:150,alt:HL}})):(e=t.touchMoveListener)==null||e.call(t)}onInputSwipe(i){const{lastTouchmove:e}=this;if(e){const t=i.screenX-e.screenX,r=e.screenY-i.screenY,n=Math.abs(t)>Math.abs(r)?t:r;this[`doSpin${n>0?"Up":"Down"}`]()}i.preventDefault(),this.lastTouchmove=i}changeLargeStep(i){return i||this.step*10}get validity(){const i=this.value,e={};return i!=null&&(e.rangeUnderflow=!this.okMin(i),e.rangeOverflow=!this.okMax(i)),e.valid=!e.rangeUnderflow&&!e.rangeOverflow,e}changeValue(i,e){const t=this;if(i||i===0){let r;typeof i!="number"&&(i=typeof i=="string"?t.formatter.parse(i):Number(i),r=isNaN(i),r&&(i="")),!r&&t.format&&(i=t.formatter.round(i))}else i=void 0;return super.changeValue(i,e)}get inputValue(){return this.value!=null?this.formatValue(this.value):""}updateLocalization(){super.updateLocalization(),this._formatter=void 0,this.syncInputFieldValue()}};v(ao,"$name","NumberField"),v(ao,"type","numberfield"),v(ao,"alias","number"),ao.initClass(),ao._$name="NumberField";var xs=class extends ei{construct(i){super.construct(i),this.refresh()}updateSeconds(i){this.widgetMap.second[i?"show":"hide"]()}onFieldChange(){!this.isConfiguring&&!this.isRefreshing&&(this.value=this.pickerToTime())}onAmPmButtonClick({source:i}){this._pm=i.ref==="pmButton",this._value&&(this.value=this.pickerToTime())}onInternalKeyDown(i){var e;const t=this;switch(i.key){case"Escape":t.triggerTimeChange(t._initialValue),t.hide(),i.preventDefault();return;case"Enter":t.value=t.pickerToTime(),t.hide(),i.preventDefault();return}(e=super.onInternalKeyDown)==null||e.call(this,i)}pickerToTime(){const i=this,e=i._pm,{hour:t,minute:r,second:n}=i.widgetMap;t.format=i._is24Hour?"2>9":null;let s=t.value,a=new Date(i.value);return i._is24Hour||(e&&s<12&&(s=s+12),!e&&s===12&&(s=0)),a.setHours(s),a.setMinutes(r.value),i.seconds&&a.setSeconds(n.value),i._min&&(a=w.max(i._min,a)),i._max&&(a=w.min(i._max,a)),a}triggerTimeChange(i){this.trigger("timeChange",{time:i})}updateInitialValue(i){this.value=i}changeValue(i){return i&&(i=typeof i=="string"?w.parse(i,this.format):i),this.isVisible||(this._initialValue=i),i!=null?i:w.getTime(0)}updateValue(i){this.isVisible&&this.triggerTimeChange(i),this.refresh()}updateFormat(i){this._is24Hour=w.is24HourFormat(i),this.refresh()}changeMin(i){return typeof i=="string"?w.parse(i,this.format):i}changeMax(i){return typeof i=="string"?w.parse(i,this.format):i}refresh(){const i=this;if(!i.isConfiguring&&i.value){i.isRefreshing=!0;const{hour:e,minute:t,second:r,amButton:n,pmButton:s}=i.widgetMap,a=i.value,o=i._is24Hour,l=a.getHours(),d=i._pm=l>=12;i.element.classList[o?"add":"remove"]("b-24h"),e.min=o?0:1,e.max=o?23:12,e.value=o?l:l%12||12,t.value=a.getMinutes(),r.value=a.getSeconds(),n.pressed=!d,s.pressed=d,n.hidden=s.hidden=o,i.isRefreshing=!1}}};v(xs,"$name","TimePicker"),v(xs,"type","timepicker"),v(xs,"configurable",{floating:!0,layout:"hbox",items:{hour:{label:"L{TimePicker.hour}",type:"number",min:0,max:23,highlightExternalChange:!1,format:"2>9",wrapAround:!0},minute:{label:"L{TimePicker.minute}",type:"number",min:0,max:59,highlightExternalChange:!1,format:"2>9",wrapAround:!0},second:{hidden:!0,label:"L{TimePicker.second}",type:"number",min:0,max:59,highlightExternalChange:!1,format:"2>9",wrapAround:!0},amPm:{type:"buttongroup",items:{amButton:{type:"button",text:"AM",toggleGroup:"am-pm",cls:"b-blue",onClick:"up.onAmPmButtonClick"},pmButton:{type:"button",text:"PM",toggleGroup:"am-pm",cls:"b-blue",onClick:"up.onAmPmButtonClick"}}}},autoShow:!1,trapFocus:!0,seconds:null,value:{$config:{equal:"date"},value:null},format:null,max:null,min:null,initialValue:null}),xs.initClass(),xs._$name="TimePicker";var ki=class extends _r{static get configurable(){return{picker:{type:"timepicker",align:{align:"t0-b0",axisLock:!0}},format:"LT",triggers:{expand:{align:"end",handler:"onTriggerClick",compose:()=>({children:[{class:{"b-icon-clock-live":1}}]})},back:{align:"start",cls:"b-icon b-icon-angle-left b-step-trigger",key:"Shift+ArrowDown",handler:"onBackClick"},forward:{align:"end",cls:"b-icon b-icon-angle-right b-step-trigger",key:"Shift+ArrowUp",handler:"onForwardClick"}},min:null,max:null,step:"5m",stepTriggers:{$config:null,default:!0},value:null,keepDate:!0}}changePicker(i,e){const t=this;return xs.reconfigure(e,i,{owner:t,defaults:{value:t.value,forElement:t.pickerAlignElement,owner:t,align:{anchor:t.overlayAnchor,target:t.pickerAlignElement},onTimeChange({time:r}){t._isUserAction=!0,t.value=r,t._isUserAction=!1}}})}onBackClick(){const i=this,{min:e}=i;if(!i.readOnly&&i.value){const t=w.add(i.value,-1*i.step.magnitude,i.step.unit);(!e||e.getTime()<=t)&&(i.value=t)}}onForwardClick(){const i=this,{max:e}=i;if(!i.readOnly&&i.value){const t=w.add(i.value,i.step.magnitude,i.step.unit);(!e||e.getTime()>=t)&&(i.value=t)}}get isValid(){const i=this;i.clearError("L{minimumValueViolation}",!0),i.clearError("L{maximumValueViolation}",!0);let e=i.value;if(e){if(e=e.getTime(),i._min&&i._min.getTime()>e)return i.setError("L{minimumValueViolation}",!0),!1;if(i._max&&i._max.getTime()<e)return i.setError("L{maximumValueViolation}",!0),!1}return super.isValid}hasChanged(i,e){return i!=null&&i.getTime&&(e!=null&&e.getTime)?this.keepDate?i-e!==0:!w.isSameTime(i,e):super.hasChanged(i,e)}showPicker(){const i=this,{picker:e,value:t}=i;i.readOnly||(e.value=t,e.format=i.format,e.maxTime=i.max,e.minTime=i.min,t||(i.value=e.value),super.showPicker(!0))}onPickerShow(){var i;super.onPickerShow(),this.pickerKeyDownRemover=(i=this.pickerKeyDownRemover)==null?void 0:i.call(this)}focusPicker(){this.picker.focus()}transformTimeValue(i){i!=null&&(typeof i=="string"?(i=w.parse(i,this.format),this.keepDate&&i&&this.value&&(i=w.copyTimeValues(new Date(this.value),i))):i=new Date(i),w.isValidDate(i)?this.keepDate||(i=w.getTime(i)):i=null);const e={value:i};return this.trigger("transformTimeValue",e),i=e.value,i}changeMin(i){return this.transformTimeValue(i)}updateMin(i){const{input:e}=this;e&&(i==null?e.removeAttribute("min"):e.min=i),this.syncInvalid()}changeMax(i){return this.transformTimeValue(i)}updateMax(i){const{input:e}=this;e&&(i==null?e.removeAttribute("max"):e.max=i),this.syncInvalid()}changeValue(i,e){const t=this,r=t.transformTimeValue(i);if(i&&!r||t.isRequired&&i===""){t.setError("L{invalidTime}");return}if(t.clearError("L{invalidTime}"),t.hasChanged(e,r))return super.changeValue(r,e);t.inputting||t.syncInputFieldValue(!0)}updateValue(i,e){const{expand:t}=this.triggers;t&&i&&(t.element.firstElementChild.style.animationDelay=-((i.getHours()*60+i.getMinutes())/10)+"s"),super.updateValue(i,e)}changeStep(i,e){const t=typeof i;if(!i)return null;if(t==="number"?i={magnitude:Math.abs(i),unit:e?e.unit:"hour"}:t==="string"&&(i=w.parseDuration(i)),i!=null&&i.unit&&(i!=null&&i.magnitude))return i.magnitude<0&&(i={magnitude:-i.magnitude,unit:i.unit}),i}updateStep(i){this.element.classList[i?"remove":"add"]("b-no-steppers"),this.syncInvalid()}updateFormat(){this.syncInputFieldValue(!0)}get inputValue(){return w.format(this.value,this.format)}updateLocalization(){super.updateLocalization(),this.syncInputFieldValue(!0)}};v(ki,"$name","TimeField"),v(ki,"type","timefield"),v(ki,"alias","time"),ki.initClass(),ki._$name="TimeField";var fy=i=>{var e;return e=class extends i.mixin(to){get dateFieldDefaults(){return T.merge({format:this.format},this._dateFieldDefaults)}configureDateField(t,r,n){const s=this,{dateStepTriggers:a}=s;return It.reconfigure(r,t,{owner:s,defaults:T.assign({stepTriggers:a===!0||a==="both"||a===n},s.dateFieldDefaults)})}changeFieldEndDate(t,r){return this.configureDateField(t,r,"end")}updateFieldEndDate(t){var r;t&&((r=this.dateFieldContainer)==null||r.add(t))}changeFieldStartDate(t,r){return this.configureDateField(t,r,"start")}updateFieldStartDate(t){var r;t&&((r=this.dateFieldContainer)==null||r.add(t))}updateFormat(t){this.isConstructing||(this.fieldEndDate.format=t,this.fieldStartDate.format=t)}updatePickingStartDate(t){this.element.classList.toggle("b-picking-start-date",!!t)}updateValue(t,r){var n;(n=super.updateValue)==null||n.call(this,t,r),this.syncValue("value",t)}stepDown(t){this.adjustByKey(t,this.stepSmall)}stepUp(t){this.adjustByKey(t,"-"+this.stepSmall)}stepDownLarge(t){this.adjustByKey(t,this.stepLarge)}stepUpLarge(t){this.adjustByKey(t,"-"+this.stepLarge)}adjustByKey(t,r){var n,s;const a=this,{_isUserAction:o}=a,{target:l}=t,d=[a.fieldStartDate,a.fieldEndDate],c=(l===d[0].input&&1||l===d[1].input&&2||0)-1,u=d[c],h=[d[0].value,d[1].value];h[c]=w.add((n=h[c])!=null?n:w.clearTime(new Date),r),h[1-c]=(s=h[1-c])!=null?s:h[c],h[1]<h[0]&&(h[1-c]=h[c]),a.checkValid(h)&&(a._isUserAction=!0,d[0].value=h[0],d[1].value=h[1],a._isUserAction=o),u.selectAll(),t.preventDefault()}checkMinMax(t=this.value){const{maxDate:r,minDate:n,validateDateOnly:s}=this;let a=0,o,l;if(t&&(n||r)){l=Array.isArray(t)?t:[t];for(o of l)if(o=s?w.clearTime(o):o,a=n&&o<n?-1:r&&o>r?1:0,a)break}return a}checkValid(t=this.value){return!this.checkMinMax(t)}hasChanged(t,r){return!T.isEqual(t,r)}onDateFieldChange({source:t,userAction:r}){const n=this,{fieldEndDate:s,fieldStartDate:a,_isUserAction:o}=n;n._isUserAction=r||o,n.syncValue(t.ref,[a.value,s.value]),n._isUserAction=o}onStartDateFocusIn(){this.pickingStartDate=!0}onStartDateFocusOut(t){this.pickingStartDate=!1}syncValue(t,r=this.value){const n=this;t!=="fieldEndDate"&&(n.fieldEndDate.value=r&&r[1]),t!=="fieldStartDate"&&(n.fieldStartDate.value=r&&r[0]),t!=="value"&&(n.value=r),!n.isConstructing&&n.hasChanged(n._lastValue,r)&&n.checkValid(r)&&n.triggerChange(),n._lastValue=r}get widgetClass(){}},v(e,"configurable",{altFormats:["YYYY-MM-DD"],dateFieldDefaults:{type:"datefield",autoSelect:!0,picker:null,step:"1d",internalListeners:{change:"up.onDateFieldChange"},triggers:{expand:null,back:{align:"end",weight:101}}},fieldEndDate:{ref:"fieldEndDate",cls:"b-end-date",weight:40},fieldStartDate:{ref:"fieldStartDate",cls:"b-start-date",weight:30,internalListeners:{focusIn:"up.onStartDateFocusIn",focusOut:"up.onStartDateFocusOut"}},dateStepTriggers:null,format:"ddd, MMM D",keyMap:{ArrowDown:"stepDown",ArrowUp:"stepUp","Ctrl+ArrowDown":"stepDownLarge","Ctrl+ArrowUp":"stepUpLarge"},pickingStartDate:null,stepLarge:"1 month",stepSmall:"7 days",validateDateOnly:!0,value:{$config:{type:"date[]",formats:["format","altFormats"]}}}),v(e,"fenced",{syncValue:!0}),v(e,"prototypeProperties",{_lastValue:null}),e},{isArray:bx}=Array,{DateSet:jL}=w,Cx=i=>i.getFullYear()*12+i.getMonth(),VL=/material/i,pn=class extends Pr.mixin(to){get datePickers(){return this.items.filter(i=>i.isDatePicker)}compose(){var i;const{navButtons:e}=this,t=e===!0?VL.test(((i=E.getThemeInfo())==null?void 0:i.name)||"")?"floating":"inline":e;return{class:{"b-multidatepicker-nav-buttons":e,[`b-multidatepicker-nav-${t}`]:e}}}onInternalPaint(i){if(i.firstPaint){const e=this,{date:t}=e;t&&e.unanimated(()=>{e.scrollPos=e.posFromIndex(e.indexFromDate(t))})}super.onInternalPaint(i)}applyDate(i,e,t){const r=this,n=e==null?void 0:e.containsFocus,{_isUserAction:s}=r;let{selection:a}=r,o=n?t:e;!a||n&&i>=a[1]?(o=t,a=[i,i]):n?a=[i,a[1]||i]:i<a[0]?(o=t,a=[i,a[1]||i]):a=[a[0]||i,i],o==null||o.focus(),r._isUserAction=!0,r.selection=a,r._isUserAction=s}changeIncludeYear(i){return typeof i=="number"&&(i=[i]),bx(i)?e=>i.includes(e.getMonth()+1):i}configureDatePicker(i,e,t){const{includeYear:r}=e,n=w.add(e.baseDate,i,"month");let s={date:n,activeDate:null,includeYear:r(n),multiSelect:e.multiSelect,selection:e.selection,weekStartDay:e.weekStartDay};return t||(s=Zi.mergeConfigs(e.datePickerDefaults,s,{cellRenderer:e.cellRenderer,headerRenderer:e.headerRenderer,weekRenderer:e.weekRenderer})),s}ensurePlan(i){return w.isDate(i)&&(i={date:i}),i.date&&(i={...i,index:this.indexFromDate(i.date)},delete i.date),i}getCell(i){return typeof i!="string"&&(i=w.makeKey(i)),this.element.querySelector(`[data-date="${i}"]:not(.b-other-month)`)}indexFromDate(i){return i&&Cx(i)-Cx(this.baseDate)}onDatePickerSelectionChange({selection:i,userAction:e}){if(e){const t=this,{_isUserAction:r}=t;t._isUserAction=!0,t.syncSelection("picker",i),t._isUserAction=r}}onNextMonthClick(){this.forward()}onPrevMonthClick(){this.backward()}onYearPickedMulti({source:i,value:e}){const t=this,r=i.up("datepicker"),{focusableElement:n}=r;n==null||n.focus({preventScroll:!0}),i.hide(),e-=r.activeDate.getFullYear(),t.go(e*12)}updateAtMax(i,e){const{nextButton:t,prevButton:r}=this.widgetMap;super.updateAtMax(i,e),t&&(t.containsFocus&&(r==null||r.focus()),t.isTabbable=!i,t.hidden=i)}updateAtMin(i,e){const{nextButton:t,prevButton:r}=this.widgetMap;super.updateAtMin(i,e),r&&(r.containsFocus&&(t==null||t.focus()),r.isTabbable=!i,r.hidden=i)}changeDate(i){return i&&w.clamp(i,this.minDate,this.maxDate)}updateDate(i){i!=null&&(this.currentIndex=this.indexFromDate(i))}updateMaxDate(){this.syncDateRange()}updateMinDate(){this.syncDateRange()}syncDateRange(){this.range=[this.minDate,this.maxDate]}updateNavButtons(i){this.detachListeners("navButtons"),i===!0&&ue.ion({theme:()=>this.recompose(),name:"navButtons",thisObj:this})}changeRange(i,e){if(bx(i)){let[t,r]=i,n;w.isDate(t)&&(t=this.indexFromDate(t),n=!0),w.isDate(r)&&(r=this.indexFromDate(r),n=!0),n&&(i=[t,r])}return super.changeRange(i,e)}changeSelection(i,e){if(!i)i=new jL;else if(i.isDateSet&&(e===i||e!=null&&e.equals(i)))return e;return i}updateSelection(i){const e=this;e.syncSelection("selection",i),e.isConfiguring?i&&(e.date=i[0]):e.trigger("selectionChange",{selection:i,userAction:e._isUserAction})}syncSelection(i,e=this.selection){const{datePickers:t}=this;i!=="selection"&&(this.selection=e),i!=="picker"&&t.forEach(r=>r.selection=e)}};v(pn,"$name","MultiDatePicker"),v(pn,"type","multidatepicker"),v(pn,"configurable",{configureSlot:"configureDatePicker",disableReserveSlots:"inert",slots:2,baseDate:{$config:"day",value:"today"},cellRenderer:null,headerRenderer:null,weekRenderer:null,weekStartDay:null,date:{$config:"day",value:"today"},minDate:{$config:"day"},maxDate:{$config:"day"},datePickerDefaults:{type:"datepicker",activeDate:null,animateTimeShift:!1,dayNameFormat:"d1",multiSelect:"range",trapFocus:!1,internalListeners:{selectionChange:"up.onDatePickerSelectionChange"},tbar:{items:{prevMonth:{onAction:"up.onPrevMonthClick"},nextMonth:{onAction:"up.onNextMonthClick"},fields:{items:{monthField:{disabled:!0},yearButton:{disabled:!0}}}}},yearPicker:{internalListeners:{select:"up.onYearPickedMulti"}}},includeYear:i=>!i.getMonth(),items:{prevButton:{type:"button",positionable:"before",cls:"b-multidatepicker-nav-button b-multidatepicker-prev-button b-icon b-icon-previous",onAction:"up.onPrevMonthClick",hideMode:"opacity"},nextButton:{type:"button",positionable:"after",cls:"b-multidatepicker-nav-button b-multidatepicker-next-button b-icon b-icon-next",onAction:"up.onNextMonthClick",hideMode:"opacity"}},multiSelect:null,navButtons:!0,selection:{$config:"day[]"}}),v(pn,"fenced",{syncSelection:!0}),pn.initClass(),pn._$name="MultiDatePicker";var oo=class extends pn.mixin(fy){get dateFieldContainer(){return this.tbar}changeConfirmable(i){return this.bbar=i,this.bbar}updateConfirmable(i){this.detachListeners("confirmable"),i==null||i.ion({name:"confirmable",thisObj:this,choice:"doConfirm"})}get isValid(){return this.checkValid()}configureDatePicker(i,e,t){const r=super.configureDatePicker(i,e,t);return r.selection=this.selection,r}onDatePickerBeforeDateSelect({date:i}){return this.applyDate(i,this.fieldStartDate,this.fieldEndDate),!1}doConfirm({choice:i,event:e,userAction:t}){this.trigger("confirm",{choice:i,event:e,userAction:t})}internalOnKeyDown(i){const{confirmable:e}=this;let t=e==null?void 0:e.hotKeys[i.virtualKey];t?(t==="default"&&(t=e.defaultButton),t&&this.doConfirm({event:i,choice:{[t]:!0,name:t}})):super.internalOnKeyDown(i)}syncSelection(i,e=this.selection){super.syncSelection(i,e),i!=="value"&&this.syncValue("selection",e)}syncValue(i,e=this.value){const t=this,r=(e==null?void 0:e[1])<(e==null?void 0:e[0]);let n;i==="fieldEndDate"?(n=2,r&&(e=[e[1],e[1]])):i==="fieldStartDate"&&(n=1,r&&(e=[e[0],e[0]])),n&&e&&!t.isConstructing&&t.ensureVisible(e[n-1]),i!=="selection"&&t.syncSelection("value",e),super.syncValue(i,e)}triggerChange(i,e=!!this._isUserAction){const{value:t,_lastValue:r,isValid:n}=this;this.triggerFieldChange({value:t,oldValue:r,event:i,userAction:e,valid:n})}};v(oo,"$name","DateRangePicker"),v(oo,"type","daterangepicker"),v(oo,"configurable",{confirmable:null,datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}},keyMap:{delegate:"confirmable"},multiSelect:"range",selection:["today","today"],stripDefaults:{bbar:{type:"confirmationbar"}},tbar:{items:{spacer:{type:"widget",flex:1,weight:0}}}}),oo.initClass(),oo._$name="DateRangePicker";var Rs=class extends _r.mixin(fy){get dateFieldContainer(){return this.container}get innerElements(){return[]}get maxDate(){return this.max}get minDate(){return this.min}compose(){const{pickTime:i}=this;return{class:{"b-pick-time":!!i}}}updateConfirmable(){this.isConstructing||(this.picker=this._pickerConfig)}changeEndTimeField(i,e){return ki.reconfigure(e,i,{owner:this,defaults:ki.mergeConfigs(this.timeFieldDefaults,this.fieldEndTimeDefaults)})}updateEndTimeField(i){i&&this.container.add(i)}changeStartTimeField(i,e){return ki.reconfigure(e,i,{owner:this,defaults:ki.mergeConfigs(this.timeFieldDefaults,this.fieldStartTimeDefaults)})}updateStartTimeField(i){i&&this.container.add(i)}updateKeepTime(i){i=!this.pickTime&&i,this.fieldEndDate.keepTime=i,this.fieldStartDate.keepTime=i}updateMax(i){const{fieldEndDate:e,fieldStartDate:t,_picker:r}=this;e.max=i,t.max=i,r&&(r.maxDate=i),this.syncInvalid()}updateMin(i){const{fieldEndDate:e,fieldStartDate:t,_picker:r}=this;e.min=i,t.min=i,r&&(r.minDate=i),this.syncInvalid()}changePicker(i,e){const t=this,{confirmable:r,pickerAlignElement:n}=t,s=r?t.confirmableDefaults:t.nonConfirmableDefaults,a=V.resolveType(s.type),o=a.mergeConfigs({owner:t,forElement:n,minDate:t.min,maxDate:t.max,selection:t.value,weekStartDay:t._weekStartDay,align:{anchor:t.overlayAnchor,target:n}},s,r&&{confirmable:r});return t._pickerConfig=i,T.isObject(i)&&(i=T.merge({type:o.type},i)),a.reconfigure(e,i,{owner:t,defaults:o})}updatePicker(i,e){super.updatePicker(i,e),this.detachListeners("dateRangeField.picker"),i==null||i.ion({name:"dateRangeField.picker",thisObj:this,selectionChange:"onPickerSelectionChange",confirm:"onPickerConfirm",focusIn:"onPickerFocusIn"})}updatePickerCls(i,e){var t,r;const n=(r=(t=this.picker)==null?void 0:t.element)==null?void 0:r.classList;e&&(n==null||n.remove(e)),i&&(n==null||n.add(i))}updatePickTime(i){let e=null,t=null;i===!0?e=t={}:i&&(i.fieldStartTime||i.fieldEndTime?(t=i.fieldStartTime,e=i.fieldEndTime):t=e=i),this.fieldEndTime=e,this.fieldStartTime=t}changeValue(i){const e=this;if(i&&!(w.isDate(i[0])&&w.isDate(i[1]))){e.setError("L{DateField.invalidDate}");return}return e.clearError("L{DateField.invalidDate}"),i}get weekStartDay(){return typeof this._weekStartDay=="number"?this._weekStartDay:w.weekStartDay}updateWeekStartDay(i){this._picker&&(this._picker.weekStartDay=i)}maybeHidePicker(){if(!this.picker.isVisible||this.confirmable)return!1;this.hidePicker()}onDatePickerBeforeDateSelect({date:i}){return this.picker.applyDate(i,this.fieldStartDate,this.fieldEndDate),!1}onDateFieldChange({source:i}){const e=this,{ref:t}=i,r=t==="fieldStartDate"?0:1,{pickTime:n}=e;let s,a,o,l,d;e.isConstructing||(s=i.value,a=1-r,l=e.value,s&&(n?(o=r?e.fieldStartTime:e.fieldEndTime,s=w.combineDateAndTime(s,o.value)):s=w.clearTime(s),d=[s,s],l&&(d[a]=l[a],d[1]<d[0]&&(d[a]=w.combineDateAndTime(s,d[a]),d[1]<d[0]&&(d[a]=s))),e.syncValue(t,d)))}onKeyArrowUp(i){const e=this,{picker:t}=e;if(t.isVisible)return e.confirmable?!1:e.stepUp(i);e.showPicker()}onKeyEnter(){this.maybeHidePicker()}onKeyEscape(){this.maybeHidePicker()}onExpandPicker(){this.confirmable?this.showPicker():this.togglePicker()}onPickerSelectionChange({selection:i,userAction:e}){if(!this.confirmable){const t=this,{_isUserAction:r}=t;t._isUserAction=e||r,t.syncValue("picker",i),t._isUserAction=r}}onPickerConfirm({choice:i,source:e,userAction:t}){const r=this,{_isUserAction:n}=r,s=e.containsFocus&&(e.pickingStartDate?r.fieldStartDate:r.fieldEndDate);i.ok&&(r._isUserAction=t||n,r.syncValue("picker",e.value),r._isUserAction=n),r.hidePicker(),s==null||s.focus()}onPickerFocusIn({relatedTarget:i}){const{fieldEndDate:e,fieldStartDate:t}=this.container.widgetMap,r=i===t?t:e;!this.confirmable&&r.focus()}onTriggerKeyDown(i){return this.picker.isVisible&&!this.confirmable?this.stepDown(i):super.onTriggerKeyDown(i)}focusPicker(){const{picker:i}=this,{fieldEndDate:e,fieldStartDate:t}=this.container.widgetMap,{tbar:r}=i,{fieldEndDate:n,fieldStartDate:s}=(r==null?void 0:r.widgetMap)||{},a=r?e.containsFocus&&n||s:e.containsFocus&&e||t;a.focus(),a!==i&&(i.ensureVisible({animate:!1,date:a.value}),a.selectAll())}showPicker(i){const e=this,{_picker:t}=e;e.readOnly||(t&&(t.range=[e.min,e.max],t.selection=e.value),i=i||!!e.confirmable,super.showPicker(i))}get isValid(){const i=this,e=i.checkMinMax();return i.clearError("L{Field.minimumValueViolation}",!0),i.clearError("L{Field.maximumValueViolation}",!0),e?(i.setError(e<0?"L{Field.minimumValueViolation}":"L{Field.maximumValueViolation}",!0),!1):super.isValid}setupLabel(i){return super.setupLabel(T.assign({for:this.fieldStartDate.input.id},i))}syncInputFieldValue(){}syncValue(i,e=this.value){const t=this,{_picker:r}=t,n=(e==null?void 0:e[1])<(e==null?void 0:e[0]);if(r!=null&&r.isVisible&&!t.confirmable){let s;i==="fieldEndDate"?(s=2,n&&(e=[e[1],e[1]])):i==="fieldStartDate"&&(s=1,n&&(e=[e[0],e[0]])),s&&e&&!t.isConstructing&&r.ensureVisible(e[s-1])}i!=="picker"&&r&&(r.selection=e),super.syncValue(i,e)}};v(Rs,"$name","DateRangeField"),v(Rs,"type","daterangefield"),v(Rs,"alias","daterange"),v(Rs,"configurable",{inline:!0,confirmable:null,container:{},confirmableDefaults:{type:"daterangepicker",navButtons:"floating",trapFocus:!0,align:{align:"t100-t100",offset:'[data-ref="fieldEndDate"]',overlap:!0},fieldStartDate:{triggers:{expand:{align:"start",disabled:!0}}}},fieldEndDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:null}},fieldEndTime:null,fieldEndTimeDefaults:{ref:"fieldEndTime",cls:"b-end-time",weight:20},fieldStartDate:{internalListeners:{triggerKey:"up.onTriggerKey"},triggers:{expand:{handler:"up.onExpandPicker",align:"start"}}},fieldStartTime:null,fieldStartTimeDefaults:{ref:"fieldStartTime",cls:"b-start-time",weight:10},keepTime:null,keyMap:{ArrowDown:"onTriggerKeyDown",ArrowUp:"onKeyArrowUp",Enter:"onKeyEnter",Escape:"onKeyEscape"},max:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},min:{$config:{type:"date",formats:["format","altFormats"],strict:!0}},nonConfirmableDefaults:{type:"multidatepicker",align:{align:"t100-r100"},datePickerDefaults:{focusable:!1,internalListeners:{beforeDateSelect:"up.onDatePickerBeforeDateSelect"}}},picker:{cls:"b-daterangefield-picker",floating:!0,hideMode:"clip",multiSelect:"range",scrollAction:"realign",align:{axisLock:!0}},pickerAlignElement:"container.element",pickerCls:null,pickTime:null,stepSmall:"7 days",timeFormat:"HH:mm:ss:SSS",triggers:{expand:null},weekStartDay:null,timeFieldDefaults:{type:"timefield",autoSelect:!0,picker:{align:{align:"b0-t0"}},triggers:{expand:null}}}),Rs.initClass(),Rs._$name="DateRangeField";var Sx=new Date(2e3,0,1),Ts=class extends ct{doDestroy(){this.dateField.destroy(),this.timeField.destroy(),super.doDestroy()}get childItems(){return[this.dateField,this.timeField]}get fieldDefaults(){const{revertOnEscape:i,tabIndex:e}=this;return e==null?{revertOnEscape:i}:{revertOnEscape:i,tabIndex:e}}get focusElement(){return this.dateField.input}get innerElements(){return[this.dateField.element,this.timeField.element]}internalOnKeyEvent(){}updateRevertOnEscape(i){this.timeField.revertOnEscape=i,this.dateField.revertOnEscape=i}changeTimeField(i,e){return ki.reconfigure(e,i,{owner:this,defaults:this.fieldDefaults})}updateTimeField(i){const e=this;j.on({element:i.element,keydown:"onTimeFieldKeyDown",thisObj:e}),Se.after(i,"syncInvalid",()=>{e.timeField&&!e.updatingInvalid&&e.syncInvalid()}),i.ion({thisObj:e,change({userAction:t,value:r}){if(t&&!e.$settingValue){const n=e.dateField.value;e._isUserAction=!0,e.value=n?w.copyTimeValues(new Date(n),r||Sx):null,e._isUserAction=!1}}}),e.readOnly&&(i.readOnly=!0)}changeDateField(i,e){return It.reconfigure(e,i,{owner:this,defaults:this.fieldDefaults})}updateDateField(i){const e=this;j.on({element:i.element,keydown:"onDateFieldKeyDown",thisObj:e}),Se.after(i,"syncInvalid",()=>{e.dateField&&!e.updatingInvalid&&e.syncInvalid()}),i.ion({thisObj:e,change({userAction:t,value:r}){t&&!e.$isInternalChange&&(e._isUserAction=!0,e.timeField.value=r,e.value=r,e._isUserAction=!1)},keydown({event:t}){var r;t.key==="Tab"&&!t.shiftKey&&((r=e.timeField)!=null&&r.isVisible)&&t.stopPropagation()}}),e.readOnly&&(i.readOnly=!0)}updateWeekStartDay(i){this.dateField&&(this.dateField.weekStartDay=i)}changeWeekStartDay(i){var e,t;return typeof i=="number"?i:(t=(e=this.dateField)==null?void 0:e.weekStartDay)!=null?t:w.weekStartDay}syncInputFieldValue(i=this.isConfiguring){super.syncInputFieldValue(!0);const e=this,{dateField:t,timeField:r}=e,n=t.highlightExternalChange,s=r.highlightExternalChange;!i&&!e.highlightExternalChange&&(i=!0),e.$isInternalChange=!0,t.highlightExternalChange=!1,t.highlightExternalChange=n,i&&(r.highlightExternalChange=t.highlightExternalChange=!1),r.value=t.value=e.inputValue,t.highlightExternalChange=n,r.highlightExternalChange=s,e.$isInternalChange=!1,e.syncInvalid()}onTimeFieldKeyDown(i){const e=this;if(i.key==="Enter"||i.key==="Tab"){const t=e.dateField.value;e._isUserAction=!0,e.value=t?w.copyTimeValues(new Date(t),e.timeField.value||Sx):null,e._isUserAction=!1}}onDateFieldKeyDown(i){const e=this;i.key==="Tab"&&!i.shiftKey?(i.stopPropagation(),i.preventDefault(),e.timeField.focus()):i.key==="Enter"&&(e.value=e.dateField.value)}updateRequired(i){this.timeField.required=this.dateField.required=i}updateReadOnly(i,e){super.updateReadOnly(i,e),this.isConfiguring||(this.timeField.readOnly=this.dateField.readOnly=i)}onDisabled(i){this.timeField.disabled=this.dateField.disabled=i}focus(){this.dateField.focus()}hasChanged(i,e){var t,r;return i!=null&&i.getTime&&(e!=null&&e.getTime)?!w.isEqual(i,e):super.hasChanged((t=i==null?void 0:i.getTime)==null?void 0:t.call(i),(r=e==null?void 0:e.getTime)==null?void 0:r.call(e))}get isValid(){return this.timeField.isValid&&this.dateField.isValid}setError(i,e){[this.dateField,this.timeField].forEach(t=>t.setError(i,e))}getErrors(){const i=[...this.dateField.getErrors()||[],...this.timeField.getErrors()||[]];return i.length?i:null}clearError(i,e){[this.dateField,this.timeField].forEach(t=>t.clearError(i,e))}updateInvalid(){this.updatingInvalid=!0,this.dateField.updateInvalid(),this.timeField.updateInvalid(),this.updatingInvalid=!1}};v(Ts,"$name","DateTimeField"),v(Ts,"type","datetimefield"),v(Ts,"alias","datetime"),v(Ts,"configurable",{timeField:{type:"timefield"},dateField:{type:"datefield",keepTime:!0,step:"1 d"},weekStartDay:null,inputTemplate:()=>"",ariaElement:"element"}),Ts.initClass(),Ts._$name="DateTimeField";var gy={lineNumber:0,column:0},Dx={lineNumber:Number.MAX_SAFE_INTEGER,column:Number.MAX_SAFE_INTEGER},zL=K.isBryntumOnline(["online"]),{pathname:my}=globalThis.location,bg=my.endsWith("umd.html"),wx=document.querySelector("script[type=module]"),py=my.endsWith("module.html")||(wx==null?void 0:wx.src.includes("app.module.js"))||my.endsWith("index.html")&&zL,xc=class KS extends Fr{construct(e={}){super.construct(...arguments);const t=this,{rtl:r}=t;r&&(t.collapsible.direction="left"),new Ss({targetSelector:".b-codeeditor",rightHandle:!!r,leftHandle:!r,skipTranslate:!0,minWidth:190})}get isVanilla(){return this.mode==="vanilla"}get isFramework(){return this.mode==="framework"}updateMode(){this.title='<span class="title-container"><span class="title">'+(this.isVanilla?"L{CodeEditor.editor}":"L{CodeEditor.viewer}")+"</span></span>"}onCloseClick(){this.collapse()}async onFilesComboChange({value:e}){await this.loadCode(e)}async collapseBoilerplate(e){const{monacoInstance:t,editor:r}=this,{Selection:n}=t,s=[],a=e.findMatches("^import .*$",!0,!0);let o,l=!0;["baselines","children","segments","intervals","events","tasks","resources","assignments","dependencies","timeRanges","resourceTimeRanges","rows"].forEach(u=>{const h=`${u}\\s*(?:=|:)\\s*\\[`;for(o=e.findForwards(h,gy,!0);o&&l;o=e.findForwards(h,l.range.getEndPosition(),!0))if(l=e.findForwards("\\](?:;|,)?\\s*$",o.range.getEndPosition(),!0),l){for(;l&&s.some(f=>f.containsRange(l.range));)l=e.findForwards("\\](?:;|,)?\\s*$",l.range.getEndPosition(),!0);l&&s.push(new n(o.range.startLineNumber,1,l.range.endLineNumber+1,1))}});let d,c=gy;for(;d=e.findForwards("^\\s*//\\s*hide",c,!0);){const u=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?hide",{lineNumber:d.range.endLineNumber,column:0},!0);u&&s.push(new n(d.range.startLineNumber,1,u.range.endLineNumber+1,1)),c=(u==null?void 0:u.range.getEndPosition())||Dx}for(c=gy;d=e.findForwards("^\\s*//\\s*region",c,!0);){const u=e.findForwards("^\\s*//\\s*end(?:-|(?:\\s*))?region",{lineNumber:d.range.endLineNumber,column:0},!0);u&&s.push(new n(d.range.startLineNumber,1,u.range.endLineNumber+1,1)),c=(u==null?void 0:u.range.getEndPosition())||Dx}a.length&&s.push(new n(1,1,a[a.length-1].range.startLineNumber+1,1));for(const u of s)r.setSelections([...r.getSelections(),u]),await r.getAction("editor.createFoldingRangeFromSelection").run()}set status(e){this.widgetMap.status.html=e}get isReadOnly(){return this.isFramework||this.fileExt==="html"||this.fileExt==="js"&&(this.hasImports||bg)}toggleReadOnly(){const e=this,{contentElement:t,isReadOnly:r}=e;t.classList.toggle("readonly",r),r?e.status="Read only"+(K.isCSP?" (Restricted by Content Security Policy)":!K.isChrome&&!K.isFirefox?" (try it on Chrome or Firefox)":""):e.status="Idle",e.editor.updateOptions({readOnly:r})}async loadCode(e){e=`${this.appFolder}${e}`;const t=this,{isVanilla:r}=t;let n=t.codeCache[e],s=null;if(t.filename=e,!n)try{const l=await Ri.get(location.href.replace(/[^/]*$/,"")+e);n=t.codeCache[e]=await l.text()}catch(l){n="",s=l}t.loadedCode=n,t.fileExt=e.split(".").pop();let a="plaintext";switch(t.fileExt){case"js":case"jsx":a="javascript";break;case"ts":case"tsx":case"vue":a="typescript";break;case"css":a="css";break;case"scss":a="scss";break;case"html":a="html";break;case"json":a="json";break}t.language=a;const o=t.model=await t.loadText(n,a);o.findForwards=function(l,d){const c=o.findNextMatch(...arguments);if(c&&!c.range.getStartPosition().isBefore(d))return c},r&&t.fileExt==="js"&&await t.collapseBoilerplate(o),t.status=`${s?s.message:"Idle"}`,t.toggleReadOnly()}sortFileNamesWithHierarchy(e){const t=s=>{const a={};return s.forEach(o=>{const l=o.split("/");let d=a;l.forEach((c,u)=>{d[c]||(d[c]=u===l.length-1?null:{}),d=d[c]})}),a},r=s=>{const a={};return Object.keys(s).sort((l,d)=>{const c=s[l]!==null,u=s[d]!==null;return c&&!u?-1:!c&&u?1:l.localeCompare(d)}).forEach(l=>{a[l]=s[l]!==null?r(s[l]):s[l]}),a},n=(s,a="")=>{let o=[];return Object.keys(s).forEach(l=>{const d=`${a}${a!==""?"/":""}${l}`;s[l]===null?o.push(d):o=o.concat(n(s[l],d))}),o};return n(r(t(e)))}async initialLoadCode(){var e;const t=this,{widgetMap:r,preferredSources:n}=t,{filesCombo:s}=r,a=s.store,o=`${t.appFolder}app.config.json`,l=(await Ri.get(o,{parseJson:!0})).parsedJson,d=[];t.isVanilla?(d.push(py?"index.module.html":bg?"index.umd.html":"index.html",py?"app.module.js":bg?"app.umd.js":"app.js"),!py&&!bg&&((e=l.merge)!=null&&e.length)&&(t.hasImports=!0,d.push(...l.merge)),document.head.querySelector('[href*="app.css"]')&&d.push("resources/app.css")):l.source.length?d.push(...l.source):console.warn(`No source files loaded from ${o}`),s.items=t.sortFileNamesWithHierarchy(d).map(u=>({text:u,value:u}));const c=(n||[]).map(u=>a.find(h=>u.test(h.value))).find(Boolean)||a.first;s.value=c.value,await t.loadCode(c.value),s.onChange="up.onFilesComboChange",t.toggleReadOnly(),s.readOnly=a.count===1}static get monacoCodePath(){const e=/(.*?\/)examples/.exec(document.location.href);return e?`${e[1]}examples/_shared/browser/lib/monaco-editor`:void 0}static async toggleCodeEditor(e,t,r){return!e&&(e=new KS({mode:"framework",appendTo:document.body,codePath:KS.monacoCodePath,appFolder:"../",...r}),V.disableThrow=!0,t.icon="b-icon-spinner",await e.initialLoadCode(),t.icon="b-icon-code"),e.collapsed?(await e.expandPanel(),e.focus()):await e.collapsePanel(),e}};v(xc,"$name","DemoCodeEditor"),v(xc,"type","democodeeditor"),v(xc,"configurable",{mode:"vanilla",appFolder:"",collapsible:{type:"overlay",direction:"right",autoClose:!1},collapsed:!0,preferredSources:null,monitorResize:!1,editor:{lineNumbers:"off",foldingImportsByDefault:!0,minimap:{enabled:!1},ariaLabel:"Live code editor"},tbar:{overflow:null,items:{filesCombo:{type:"combo",flex:"1 1 100%",monitorResize:!1,editable:!1,fields:[{name:"text"}],listItemTpl:({text:i})=>{const e=i.split(".").pop();let t="b-fa-file";switch(e){case"js":case"jsx":case"ts":case"tsx":case"vue":t="b-fa-file-lines";break;case"css":case"scss":t="b-fa-palette";break;case"htm":case"html":case"json":t="b-fa-file-code";break}const r=i.lastIndexOf("/")+1,n=i.substring(0,r),s=i.substring(r);return`<span class="b-editor-file-type b-fw-icon ${t}" ></span> <span class="b-editor-folder">${n}</span>${s}`},picker:{maxHeight:"calc(100vh * 3 / 4)"}}}},codeCache:{}}),v(xc,"loadMonacoEditor",async i=>{if(!Fr.monacoLoadPromise){const e=E.createElement({tag:"script",parent:document.head,src:`${i}monaco-editor/min/vs/loader.js`});await new Promise(t=>e.addEventListener("load",t)),await(Fr.monacoLoadPromise=new Promise(t=>{const r=globalThis.require;r.config({paths:{vs:`${i}monaco-editor/min/vs`}}),r(["vs/editor/editor.main"],function(){t(globalThis.monaco)})}))}});var vy=xc;vy.initClass(),vy._$name="DemoCodeEditor";var Ms=class extends Fi{static get defaultConfig(){return{value:null,unit:null,defaultUnit:"day",magnitude:null,useAbbreviation:!1,allowNegative:!1,decimalPrecision:null,triggers:{spin:{type:"spintrigger"}},nullValue:null}}static get configurable(){return{min:null,max:null,allowedUnits:null,step:1}}changeMin(i){return typeof i=="string"?new Le(i):i}changeMax(i){return typeof i=="string"?new Le(i):i}changeAllowedUnits(i){return typeof i=="string"&&(i=i.split(",")),i.length>0&&!i.includes(this.defaultUnit)&&(this.defaultUnit=i[0]),i}updateAllowedUnits(i){this.allowedUnitsRe=new RegExp(`(${i.join("|")})`,"i")}get inputValue(){return this.value==null?"":this.calcValue(!0).toString(this.useAbbreviation,this.decimalPrecision)}set unit(i){this._unit=i,this.value=this.calcValue()}get unit(){return this._unit}get unitWithDefault(){return this._unit||this.defaultUnit}set magnitude(i){this.clearError("L{invalidUnit}"),this._magnitude=i,super.value=this.calcValue()}get magnitude(){return this._magnitude}roundMagnitude(i){return i&&this.decimalPrecision!=null?T.round(i,this.decimalPrecision):i}get allowDecimals(){return this.decimalPrecision!==0}get isValid(){const i=this,e=i.input.value,t=w.parseDuration(e,i.allowDecimals,e.match(/[\p{Letter}\p{Mark}]+/gui)?void 0:i.unitWithDefault),r=!e||t&&t.magnitude==null;return i.skipValidation||super.isValid&&(r&&!i.required||!r&&(i.allowNegative||(t==null?void 0:t.magnitude)>=0))}internalOnChange(i){const e=this,t=e.value,r=e._lastValue;e.hasChanged(r,t)&&(e._lastValue=t,e.triggerFieldChange({value:t,event:i,userAction:!0,valid:e.isValid}))}onFocusOut(i){var e,t,r;return this.syncInputFieldValue(!0),(r=(t=(e=this.triggers)==null?void 0:e.spin)==null?void 0:t.clickRepeater)==null||r.cancel(),super.onFocusOut(i)}set value(i){const e=this;let t,r;if(e.getConfig("allowedUnits"),e.clearError("L{invalidUnit}"),typeof i=="number"||typeof i=="string"&&i.length>0&&!isNaN(i))t=Number(i),r=e.unitWithDefault;else if(typeof i=="string")if(/^\s*$/.test(i))t=null;else{const n=w.parseDuration(i,e.allowDecimals,e.unitWithDefault);n&&(!e.allowedUnitsRe||e.allowedUnitsRe.test(n.unit)?(r=n.unit,t=n.magnitude):e.setError("L{invalidUnit}"))}else i&&"unit"in i&&"magnitude"in i?(r=i.unit,t=i.magnitude):(r=null,t=null);(e._magnitude!==t||e._unit!=r)&&(e._magnitude=t,r&&(e._unit=r),super.value=e.calcValue())}okMax(i){return typeof i=="number"&&(i=new Le({unit:this.unitWithDefault,magnitude:i})),this.max==null||i<=this.max}okMin(i){return typeof i=="number"&&(i=new Le({unit:this.unitWithDefault,magnitude:i})),this.min==null||i>=this.min}get validity(){const i=this.value,e={};return i!=null&&(e.rangeUnderflow=!this.okMin(i),e.rangeOverflow=!this.okMax(i)),e.valid=!e.rangeUnderflow&&!e.rangeOverflow,e}get value(){return super.value}calcValue(i=!1){const e=this;return(!e._unit||e._magnitude==null)&&e.clearable?null:new Le(i?this.roundMagnitude(e._magnitude):this._magnitude,e.unitWithDefault)}hasChanged(i,e){return e&&!i||!e&&i||e&&i&&!i.isEqual(e)}get milliseconds(){return this.value?this.value.milliseconds:0}onInternalKeyDown(i){i.key==="ArrowUp"?this.doSpinUp():i.key==="ArrowDown"&&this.doSpinDown()}doSpinUp(){const i=this;let{value:e}=i;if(i.readOnly)return;e||(e=new Le({magnitude:0,unit:this.defaultUnit}));let t=e.add(this._step);i.okMin(t)||(t=i.min),i.okMax(t)&&(i.value=t)}doSpinDown(){const i=this;let{value:e}=i;if(i.readOnly)return;e||(e=new Le({magnitude:0,unit:this.defaultUnit}));let t=e.add({magnitude:-this._step.magnitude,unit:this._step.unit});i.okMax(t)||(t=i.max),i.okMin(t)&&(i.allowNegative||(i.magnitude||0)>0)&&(i.value=t)}changeStep(i,e){const t=typeof i;return i?(t==="number"?i={magnitude:Math.abs(i),unit:void 0}:t==="string"&&(i=w.parseDuration(i)),i&&i.unit&&i.magnitude&&i.magnitude<0&&(i={magnitude:-i.magnitude,unit:i.unit}),i):null}updateStep(i){this.element.classList.toggle("b-no-steppers",!!i),this.syncInvalid()}};v(Ms,"$name","DurationField"),v(Ms,"type","durationfield"),v(Ms,"alias","duration"),Ms.initClass(),Ms._$name="DurationField";var lo=class extends Gi{};v(lo,"$name","Fit"),v(lo,"type","fit"),v(lo,"configurable",{containerCls:"b-fit-container",itemCls:"b-fit-item"}),lo.initClass(),lo._$name="Fit";var yi=class extends dt{afterConfigure(){const i=this;super.afterConfigure(),i.onTargetSizeChange=i.onTargetSizeChange.bind(i),j.on({element:i.element,keydown:"onEditorKeyDown",contextmenu:"stopMouseEvents",mousedown:"stopMouseEvents",mouseover:"stopMouseEvents",mouseout:"stopMouseEvents",mouseup:"stopMouseEvents",click:"stopMouseEvents",dblclick:"stopMouseEvents",thisObj:i}),i.ion({beforeHide:"beforeEditorHide",hide:"afterEditorHide"}),$e.ion({locale:"onLocaleChange",thisObj:i})}onLocaleChange(){const{inputField:i}=this;i&&!i.isDestroyed&&(i.syncInputFieldValue?i.syncInputFieldValue(!0):i instanceof ct)}render(i){const e=this.element.parentNode,[t]=this.getRenderContext(this,i);t.classList.add("b-editing"),super.render(...arguments),e!=null&&e.classList&&t!==e&&e.classList.remove("b-editing")}async startEdit(i){var e,t,r;const n=this;if(i=T.assignIf(i,{align:n.align,hideTarget:n.hideTarget,matchSize:n.matchSize,matchFont:n.matchFont,fitTargetContent:n.fitTargetContent,focus:!0}),n.isVisible&&await n.completeEdit(),n.trigger("beforeStart",i)!==!1){const{target:s,hideTarget:a,matchSize:o,matchFont:l,fitTargetContent:d,record:c,field:u=n.inputField.name,focus:h}=i,{inputField:f,appendToTargetParent:g}=n,{input:m}=f,p=E.getStyleValue(s,"font-size"),y=E.getStyleValue(s,"font-family");let{value:b,align:C}=i;if(c&&u&&(n.record=c,n.dataField=u,f.assignFieldValue!==V.prototype.assignFieldValue?b=f.value:b===void 0&&(b=c.getValue(u))),g&&s.nodeType===Node.ELEMENT_NODE&&s.parentElement.appendChild(n.element),o&&(s instanceof HTMLElement&&n.updateSize(s,o),s instanceof HTMLElement&&gt.addResizeListener(s,n.onTargetSizeChange)),m&&(l?(m.style.fontSize=p,m.style.fontFamily=y):m.style.fontSize=m.style.fontFamily=""),n.assigningValues=!0,(e=f.clearError)==null||e.call(f),"setValue"in f?await f.setValue(b):f.value=b,n.assigningValues=!1,typeof C=="string"&&(C={align:C}),await n.showBy({target:s,allowTargetOut:!0,...C}),d){const S=m.scrollWidth-m.clientWidth;S>0&&(n.width+=S+E.scrollBarWidth)}h&&((t=f.focus)==null||t.call(f)),s.nodeType===Element.ELEMENT_NODE&&a&&s.classList.add("b-hide-visibility"),n.editing=!0;const D=f.value;return n.trigger("start",{value:D}),Array.isArray(D)&&f.editingRecords&&((r=D[0])!=null&&r.isModel)?n.oldValue=D.map(S=>S.copy(S.id)):(n.oldValue=D,Array.isArray(n.oldValue)&&(n.oldValue=n.oldValue.slice())),f.initialValue=n.oldValue,!0}return!1}async refreshEdit(){if(this.isVisible){const{record:i,dataField:e,inputField:t}=this;if(i&&e){const r=i.getValue(e);T.isEqual(t.value,r)||await t.setValue(r)}}}finishEdit(){const{target:i,aligningToElement:e}=this.lastAlignSpec;e&&(i.classList.remove("b-editing"),i.classList.remove("b-hide-visibility")),this.editing=!1,this.trigger("finishEdit")}onEditorKeyDown(i){var e;const t=this;switch(i.key){case t.completeKey:t.completeEdit(null,i),i.stopImmediatePropagation();break;case t.cancelKey:t.cancelEdit(i),i.stopImmediatePropagation();break}(e=t.trigger)==null||e.call(t,"keyDown",{event:i})}stopMouseEvents(i){this.allowMouseEvents||i.stopPropagation()}onFocusOut(i){super.onFocusOut(i);const e=this;if(!e.isFinishing&&e.editing)switch(e.blurAction){case"cancel":e.cancelEdit(i);break;case"complete":e.completeEdit(null,i)}}async completeEdit(i,e){var t,r,n,s;const a=this,{inputField:o,oldValue:l,record:d}=a,c=o.invalidAction||(o.allowInvalid===!1?"block":a.invalidAction),{value:u}=o;if(a.isVisible){if(!o.isValid&&c!=="allow"){if(c==="block")return(t=o.focus)==null||t.call(o),!1;if(c==="revert")return a.cancelEdit(e)!==!1}else{if(T.isEqual(u,l))return a.cancelEdit(e)!==!1;{const h={inputField:o,record:d,value:u,oldValue:l};if(a.trigger("beforeComplete",h)===!1)(r=o.focus)==null||r.call(o);else if(i||(i=h.finalize||((n=h.editorContext)==null?void 0:n.finalize)),i){let f=await i(h);if(f===!0)a.onEditComplete();else{if(o.setError){const g=f||o.invalidValueError,m=()=>{p(),o.clearError(g)},p=o.ion({change:m,input:m});o.setError(g)}c==="block"?(s=o.focus)==null||s.call(o):c==="revert"&&(await o.setValue(l),f=!0),f=!1}return f}else return a.onEditComplete(),!0}}return!1}}cancelEdit(i){var e;const t=this,{inputField:r,oldValue:n}=t,{value:s}=r;if(t.editing&&!t.isFinishing&&t.trigger("beforeCancel",{value:s,oldValue:n,event:i})!==!1)(e=r.clearError)==null||e.call(r),t.isFinishing=!0,t.hide(),t.trigger("cancel",{value:s,oldValue:n,event:i}),t.finishEdit(),t.isFinishing=!1;else return!1}onEditComplete(){const i=this,{record:e,dataField:t,inputField:r,oldValue:n}=i;let{value:s}=r;if(!i.isFinishing){if(i.isFinishing=!0,i.hide(),e&&(!i.instantUpdate||r._outstandingUpdate)){const a=`set${O.capitalize(t)}`;e.isFieldModified(t)&&e.getUnmodified(t)==null&&(s==null||s==="")&&(s=e.meta.modified[t]),e[a]?e[a](s):e.setValue(t,s)}i.trigger("complete",{value:s,oldValue:n}),i.finishEdit(),i.isFinishing=!1}}doDestroy(){this.createdInputField&&this.inputField.destroy(),super.doDestroy()}set owner(i){this._owner=i}get owner(){return this._owner||V.fromElement(this.element.parentNode)}changeInputField(i,e){const t=this;return e&&e.destroy(),typeof i=="string"&&(i={type:i}),i instanceof V||(i.type||(i.type="textfield"),i=V.create(i),t.createdInputField=!0),t.completeOnChange&&i.ion({change:"onInputFieldChange",thisObj:t}),i.parent=t,i}updateInputField(i){this.removeAll(),this.add(i)}get inputField(){return this.items[0]}onInputFieldChange(){this.containsFocus&&this.completeEdit()}onTargetSizeChange(i,e,t){e&&t&&this.updateSize(i)}updateSize(i,e=this.lastMatchSize){const t=this,r=k.inner(i);t.width=e.width===!1?"auto":r.width-t.align.offset[0],t.height=e.height===!1?"auto":r.height,t.lastMatchSize=e}beforeEditorHide(){if(this.editing&&!this.isFinishing)return this.cancelEdit(),!1}afterEditorHide(){this.positioned&&this.element.remove(),gt.removeResizeListener(this.lastAlignSpec.target,this.onTargetSizeChange)}};v(yi,"$name","Editor"),v(yi,"type","editor"),v(yi,"configurable",{positioned:!0,hidden:!0,layout:"fit",align:{align:"t0-t0",offset:[0,0]},hideTarget:!1,appendToTargetParent:!1,matchSize:!0,matchFont:!0,fitTargetContent:!1,inputField:"textfield",blurAction:"complete",completeKey:"Enter",cancelKey:"Escape",invalidAction:"block",completeOnChange:null,isolateFields:!0,instantUpdate:!1}),yi.initClass(),yi._$name="Editor";var yy={number:!0,boolean:!0,string:!0,date:!0,duration:!0,time:!0,auto:!0},NL={number:!0,boolean:!0,string:!0},by=i=>{var e;return((e=i==null?void 0:i.column)==null?void 0:e.type)==="duration"},WL=i=>yy[i==null?void 0:i.type]||by(i),Ex="",ti="b-fieldfilterpicker",UL={between:!0,notBetween:!0,isIncludedIn:!0,isNotIncludedIn:!0},GL={textfield:!0,datefield:!0,numberfield:!0,durationfield:!0,combo:!0,timefield:!0},ne={empty:{value:"empty",text:"L{isEmpty}",argCount:0},notEmpty:{value:"notEmpty",text:"L{isNotEmpty}",argCount:0},"=":{value:"=",text:"L{equals}"},"!=":{value:"!=",text:"L{doesNotEqual}"},">":{value:">",text:"L{isGreaterThan}"},"<":{value:"<",text:"L{isLessThan}"},">=":{value:">=",text:"L{isGreaterThanOrEqualTo}"},"<=":{value:"<=",text:"L{isLessThanOrEqualTo}"},between:{value:"between",text:"L{isBetween}",argCount:2},notBetween:{value:"notBetween",text:"L{isNotBetween}",argCount:2},isIncludedIn:{value:"isIncludedIn",text:"L{isOneOf}",isArrayValued:!0},isNotIncludedIn:{value:"isNotIncludedIn",text:"L{isNotOneOf}",isArrayValued:!0}},Is=class Zr extends dt{static get defaultValueFieldPlaceholders(){return{string:"L{enterAValue}",number:"L{enterANumber}",date:"L{selectADate}",relation:"L{selectValue}",list:"L{selectOneOrMoreValues}",duration:"L{enterAValue}",time:"L{selectATime}",auto:"L{enterAValue}"}}afterConstruct(){const e=this;if(!e._fields)throw new Error(`${Zr.name} requires 'fields' to be configured.`);if(!e._filter)throw new Error(`${Zr.name} requires 'filter' to be configured.`);super.afterConstruct();const{widgetMap:{propertyPicker:t,operatorPicker:r,caseSensitive:n}}=e;t.ion({select:"onPropertySelect",thisObj:e}),r.ion({select:"onOperatorSelect",thisObj:e}),n.ion({change:"onCaseSensitiveChange",thisObj:e}),e.propertyFieldConfig&&t.setConfig(e.propertyFieldConfig),e.operatorFieldConfig&&r.setConfig(e.operatorFieldConfig),t.cls=e.allPropertyPickerClasses,r.cls=e.allOperatorPickerClasses,e.populateUIFromFilter()}changeDateFormat(e){return this.L(e)}get allChildInputs(){const{propertyPicker:e,operatorPicker:t,caseSensitive:r}=this.widgetMap;return[e,t,...this.valueFields,r]}updateDisabled(e,t){super.updateDisabled(e,t),this.allChildInputs.forEach(r=>r.disabled=e)}updateReadOnly(e){const{propertyPicker:t,operatorPicker:r}=this.widgetMap;this.allChildInputs.forEach(n=>n.readOnly=e),t.readOnly=t.readOnly||e,r.readOnly=r.readOnly||e}updatePropertyLocked(e){this.widgetMap.propertyPicker.readOnly=e||this.readOnly,this.widgetMap.propertyPicker.cls=this.allPropertyPickerClasses}updateOperatorLocked(e){this.widgetMap.operatorPicker.readOnly=e||this.readOnly,this.widgetMap.operatorPicker.cls=this.allOperatorPickerClasses}changeOperators(e){const t=e!=null?e:Zr.defaultOperators;return Object.keys(t).reduce((r,n)=>({...r,[n]:t[n].map(s=>({...s,text:this.L(s.text)}))}),{})}get isMultiSelectValueField(){var e;return["isIncludedIn","isNotIncludedIn"].includes((e=this._filter)==null?void 0:e.operator)}get allPropertyPickerClasses(){var e;return new se(`${ti}-property`,(e=this.propertyFieldConfig)==null?void 0:e.cls,{[`${ti}-combo-locked`]:this.propertyLocked})}get allOperatorPickerClasses(){var e;return new se(`${ti}-operator`,(e=this.operatorFieldConfig)==null?void 0:e.cls,{[`${ti}-combo-locked`]:this.operatorLocked})}getValueFieldConfigs(){const e=this,{valueFieldCls:t,fieldType:r,_filter:{operator:n},onValueChange:s,filterValues:a,isMultiSelectValueField:o,operatorArgCount:l,getValueFieldConfig:d,fieldIsRelation:c,triggerChangeOnInput:u}=e,h=T.merge({},Zr.defaultValueFieldPlaceholders,e.valueFieldPlaceholders);if(!r||!n||l===0)return[];let f={type:"textfield",internalListeners:{change:s,input:u?s:null,thisObj:e},bubbleEvents:{keydown:!0},cls:t,dataset:{type:r},placeholder:e.L(h[o?"list":c?"relation":r]),highlightExternalChange:!1};return o||c?f={...f,type:"combo",multiSelect:o,createOnUnmatched:!0,items:e.getUniqueDataValues(a),value:a!=null?a:[]}:["number","date","boolean","duration","time"].includes(r)&&(f.type=`${r}field`),d&&(f=e.callback(d,e,[e.filter,f])),o?[f]:H.populate(l,g=>[{type:"widget",tag:"div",cls:`${ti}-value-separator`,content:e.L("L{FieldFilterPicker.and}")},{...f,value:a[g]}]).flat().slice(1)}getUniqueDataValues(e=[]){var t;const r=this,{fieldType:n}=r;if(!r.store||!((t=r._filter)!=null&&t.property))return[];const{relatedDisplayField:s}=r.selectedField;let a,o;if(r.fieldIsRelation){const{foreignStore:l}=r.currentPropertyRelationConfig;s?(a=l.allRecords.reduce((d,c)=>(c.id!=null&&d.push({text:c.getValue(s),value:c.id}),d),[]),o=a.sort((d,c)=>r.sortStrings(d.text,c.text))):a=l.allRecords.map(d=>d.id)}else a=r.store.allRecords.map(l=>l.getValue(r._filter.property));if(!o){a.push(...e);const l=H.unique(a.reduce((d,c)=>(c!=null&&String(c).trim()!==""&&(n==="date"?d.push(c.valueOf()):n==="duration"?d.push(c.toString()):d.push(c)),d),[]));n==="string"?o=l.sort(r.sortStrings):n==="duration"?o=l.map(d=>new Le(d)).filter(d=>d.isValid).sort(r.sortDurations):o=l.sort(r.sortNumerics),n==="date"?o=o.map(d=>{const c=new Date(d);return{text:w.format(c,r.dateFormat),value:d}}):n==="duration"&&(o=o.map(d=>d.toString()))}return o}sortStrings(e,t){return(e!=null?e:Ex).localeCompare(t!=null?t:Ex)}sortNumerics(e,t){return e-t}sortDurations(e,t){return e.valueOf()-t.valueOf()}get fieldType(){var e;return(e=this.selectedField)==null?void 0:e.type}get selectedField(){var e,t;return(t=this.fields)==null?void 0:t[(e=this._filter)==null?void 0:e.property]}get propertyOptions(){var e;return Object.entries((e=this.fields)!=null?e:{}).filter(([,t])=>yy[t.type]||by(t)).map(([t,{title:r}])=>({value:t,text:r!=null?r:t})).sort((t,r)=>t.text.localeCompare(r.text))}get operatorOptions(){return this.operators[this.fieldIsRelation?"relation":this.fieldType]}get fieldIsRelation(){return!!this.currentPropertyRelationConfig}get currentPropertyRelationConfig(){var e,t;return(t=(e=this.store)==null?void 0:e.modelRelations)==null?void 0:t.find(({foreignKey:r})=>{var n;return r===((n=this._filter)==null?void 0:n.property)})}updateOperators(){delete this._operatorArgCountLookup}get operatorArgCountLookup(){return this._operatorArgCountLookup||(this._operatorArgCountLookup=Zr.buildOperatorArgCountLookup(this.operators))}updateFilter(){this._filter&&this.onFilterChange()}updateStore(e){var t;(t=this._store)==null||t.un(this),e==null||e.ion({refresh:"onStoreRefresh",thisObj:this}),this.inferFieldTypes()}onStoreRefresh({action:e}){this.isMultiSelectValueField&&["dataset","create","update","delete"].includes(e)&&(this.valueFields[0].items=this.getUniqueDataValues(this.filterValues))}refreshValueFields(){const e=this,{valueFields:t}=e.widgetMap,{valueFields:r,fieldType:n,operatorArgCount:s,_filter:{property:a,operator:o}}=e,l=UL[o];t.element.className=new se({[`${ti}-values`]:!0,[`${ti}-values-multiple`]:l,[`${ti}-values-${n}`]:n!==void 0,"b-hidden":a==null||o==null||s===0});const d=e.getValueFieldConfigs();if(d.length!==r.length||d.some(({type:c},u)=>r[u].type!==c))t.removeAll(),t.add(d);else{let c=0;for(const u of d)delete u.type,T.assign(r[c++],u)}delete e._valueFields,e.refreshCaseSensitive()}refreshCaseSensitive(){var e,t;const r=this,{fieldType:n,operatorArgCount:s,isMultiSelectValueField:a}=r,o=(e=r._filter)==null?void 0:e.operator,{caseSensitive:l}=r.widgetMap;l.hidden=n!=="string"||!o||a||s===0,l.checked=((t=r._filter)==null?void 0:t.caseSensitive)!==!1}onPropertySelect(e){var t;const r=this,{_filter:n}=r;n.property=((t=e.record)==null?void 0:t.data.value)||null,r.fieldType!==r._fieldType&&(n.operator=null,n.value=null),r._fieldType=n.type=r.fieldType,r.refreshOperatorPicker(),r.refreshValueFields(),r.triggerChange()}onCaseSensitiveChange({checked:e}){this._filter.caseSensitive=e,this.triggerChange()}onOperatorSelect(e){var t;const r=this,n=r.isMultiSelectValueField,s=this.operatorArgCount;r._filter.operator=((t=e.record)==null?void 0:t.data.value)||null,r.operatorArgCount!==s&&(r._filter.value=null),r.isMultiSelectValueField&&!n&&(r._filter.value=[]),r.refreshValueFields(),r.triggerChange()}triggerChange(){const{filter:e,isValid:t}=this;this.trigger("change",{filter:e,isValid:t})}onValueChange(){const e=this,{isMultiSelectValueField:t,fieldType:r,_filter:n}=e,s=this.valueFields.map(a=>a.value);t&&r==="date"?n.value=s[0].map(a=>new Date(a)):t&&r==="duration"?n.value=s[0].map(a=>new Le(a)):(r==="date"&&n.operator==="between"&&w.isValidDate(s[1])&&s[1].setHours(23,59,59,999),n.value=s.length===1?s[0]:s),e.triggerChange()}refreshOperatorPicker(){const{operatorPicker:e}=this.widgetMap,{_filter:{operator:t,property:r},operatorOptions:n}=this;e.items=n,e.value=t,e.hidden=r===null}populateUIFromFilter(e=!1){const t=this,{filterValues:r,widgetMap:{propertyPicker:n,operatorPicker:s},_filter:{property:a,operator:o,disabled:l},propertyOptions:d,operatorOptions:c,isMultiSelectValueField:u}=t;n.items=d,s.items=c,s.hidden=a===null;let h=e;n.value!==a&&(n.value=a,t.refreshOperatorPicker(),h=!0),s.value!==o&&(o===null||!s.items.find(({value:f})=>f===o)?s.clear():s.value=o,h=!0),!o&&s.items.length===1&&(s.value=t._filter.operator=s.items[0].value),h&&t.refreshValueFields(),t.refreshCaseSensitive(),t.valueFields.forEach((f,g)=>{u&&(f.value.length>0||r.length>0)?t.fieldType==="date"?f.value=r.map(m=>m==null?void 0:m.valueOf()):t.fieldType==="duration"?f.value=r.map(m=>m==null?void 0:m.toString()):f.value=r:g>=r.length?f.clear():f.value=r[g]}),t.allChildInputs.forEach(f=>f.disabled=t.disabled||l)}get valueFields(){return this._valueFields||(this._valueFields=this.widgetMap.valueFields.queryAll(e=>e.owner===this.widgetMap.valueFields&&GL[e.type]))}get filterValues(){var e;return((e=this._filter)==null?void 0:e.value)==null?[]:H.asArray(this._filter.value)}onFilterChange(){const e=this,t=e.fieldType,r=t!==e._fieldType;e._fieldType=e._filter.type=t,e.populateUIFromFilter(r)}get operatorArgCount(){const{fieldType:e,filter:{operator:t},operatorArgCountLookup:r}=this;return e&&t?r[e][t]:1}get isValid(){const e=this,{filter:t,fieldType:r,filterValues:n,isMultiSelectValueField:s,operatorArgCount:a}=e,{operator:o}=t,l=a>0&&(t==null?void 0:t.value)==null;return!!(r&&o&&!l&&(s&&n.length>0||n.length===a)&&n.every(d=>d!=null&&(r!=="duration"||d.isValid)))}get focusElement(){var e,t,r,n;return(n=(r=(t=(e=this.valueFields.find(s=>s.isEmptyInput))!=null?e:this.operatorPicker)!=null?t:this.propertyPicker)==null?void 0:r.input)!=null?n:super.focusElement}inferFieldTypes(){var e;if(((e=this.store)==null?void 0:e.totalCount)>0&&this.fields)for(const[t,r]of Object.entries(this.fields))r.type==="auto"&&(r.type=Zr.inferFieldType(this.store,t))}static inferFieldType(e,t){var r;const n=(r=e.find(s=>s.getValue(t)!=null,!0))==null?void 0:r.getValue(t);if(n!==void 0){const s=typeof n;if(s==="object"&&n instanceof Date)return"date";if(NL[s])return s}return"auto"}static localizeOperator(e,t){const{defaultOperators:r}=Zr,n=Object.keys(r).sort((s,a)=>s===t?-1:a===t?1:0);for(const s of n)for(const a of r[s])if(a.value===e)return Zr.L(a.text);return e}};v(Is,"$name","FieldFilterPicker"),v(Is,"type","fieldfilterpicker"),v(Is,"defaultOperators",{string:[ne.empty,ne.notEmpty,ne["="],ne["!="],{value:"includes",text:"L{contains}"},{value:"doesNotInclude",text:"L{doesNotContain}"},{value:"startsWith",text:"L{startsWith}"},{value:"endsWith",text:"L{endsWith}"},ne.isIncludedIn,ne.isNotIncludedIn],number:[ne.empty,ne.notEmpty,ne["="],ne["!="],ne[">"],ne["<"],ne[">="],ne["<="],ne.between,ne.notBetween,ne.isIncludedIn,ne.isNotIncludedIn],date:[ne.empty,ne.notEmpty,ne["="],ne["!="],{value:"<",text:"L{isBefore}"},{value:">",text:"L{isAfter}"},ne.between,{value:"isToday",text:"L{isToday}",argCount:0},{value:"isTomorrow",text:"L{isTomorrow}",argCount:0},{value:"isYesterday",text:"L{isYesterday}",argCount:0},{value:"isThisWeek",text:"L{isThisWeek}",argCount:0},{value:"isNextWeek",text:"L{isNextWeek}",argCount:0},{value:"isLastWeek",text:"L{isLastWeek}",argCount:0},{value:"isThisMonth",text:"L{isThisMonth}",argCount:0},{value:"isNextMonth",text:"L{isNextMonth}",argCount:0},{value:"isLastMonth",text:"L{isLastMonth}",argCount:0},{value:"isThisYear",text:"L{isThisYear}",argCount:0},{value:"isNextYear",text:"L{isNextYear}",argCount:0},{value:"isLastYear",text:"L{isLastYear}",argCount:0},{value:"isYearToDate",text:"L{isYearToDate}",argCount:0},ne.isIncludedIn,ne.isNotIncludedIn],boolean:[{value:"isTrue",text:"L{isTrue}",argCount:0},{value:"isFalse",text:"L{isFalse}",argCount:0}],duration:[ne.empty,ne.notEmpty,ne["="],ne["!="],ne[">"],ne["<"],ne[">="],ne["<="],ne.between,ne.notBetween,ne.isIncludedIn,ne.isNotIncludedIn],time:[ne.empty,ne.notEmpty,ne["="],ne["!="],ne[">"],ne["<"],ne[">="],ne["<="],ne.between,ne.notBetween,ne.isIncludedIn,ne.isNotIncludedIn],relation:[ne.empty,ne.notEmpty,ne["="],ne["!="],ne.isIncludedIn,ne.isNotIncludedIn],auto:[{value:"*",text:"L{contains}"}]}),v(Is,"configurable",{fields:null,disabled:!1,readOnly:!1,layout:"vbox",propertyLocked:!1,operatorLocked:!1,filter:null,propertyFieldConfig:null,operatorFieldConfig:null,valueFieldCls:null,triggerChangeOnInput:!0,items:{inputs:{type:"container",layout:"hbox",cls:`${ti}-inputs`,items:{propertyPicker:{type:"combo",items:{},cls:`${ti}-property`,placeholder:"L{FieldFilterPicker.selectAProperty}",highlightExternalChange:!1},operatorPicker:{type:"combo",items:{},cls:`${ti}-operator`,placeholder:"L{FieldFilterPicker.selectAnOperator}",highlightExternalChange:!1},valueFields:{type:"container",cls:`${ti}-values`,items:{}}}},caseSensitive:{type:"checkbox",text:"L{FieldFilterPicker.caseSensitive}",cls:`${ti}-case-sensitive`}},operators:Is.defaultOperators,dateFormat:"L{FieldFilterPicker.dateFormat}",store:null,valueFieldPlaceholders:null,getValueFieldConfig:null}),v(Is,"buildOperatorArgCountLookup",i=>H.keyBy(Object.entries(i),([e])=>e,([,e])=>H.keyBy(e,({value:t})=>t,({argCount:t})=>t===void 0?1:t)));var Qi=Is;Qi.initClass(),Qi._$name="FieldFilterPicker";var co=class extends V{compose(){const{text:i,html:e}=this;return{tag:"label",text:i,html:e}}};v(co,"$name","Label"),v(co,"type","label"),v(co,"configurable",{text:null,localizableProperties:["text"]}),co.initClass(),co._$name="Label";var vn=class Ad extends dt{afterConstruct(){const e=this;e.validateConfig();const{addFilterButton:t}=e.widgetMap;t.ion({click:"addFilter",thisObj:e}),t.text=e.L(t.text),e.store&&e.updateStore(e.store),super.afterConstruct()}changeDateFormat(e){return this.L(e)}validateConfig(){if(!this.fields&&!this.store)throw new Error("FieldFilterPickerGroup requires either a 'fields' or 'store' config property.")}updateFields(e){this.widgetMap.pickers.childItems.forEach(t=>t.fields=e)}updateFilters(e,t){const r=this;t&&t.filter(n=>!e.find(s=>s.id===n.id)).forEach(n=>{var s;return(s=r.store)==null?void 0:s.removeFilter(n.id)}),e.forEach(n=>n.id=n.id||r.nextFilterId),r.widgetMap.pickers.items=(e==null?void 0:e.map(n=>r.getPickerRowConfig(n)))||[]}changeFilters(e){const{canManageFilter:t,limitToProperty:r}=this;let n=e;return t&&(n=n.filter(s=>this.callback(t,this,[s]))),r&&(n=n.filter(s=>s.property==null||s.property===r)),n}updateStore(e){const t=this;if(t.detachListeners("store"),e){let r=!1;t.widgetMap.pickers.childItems.forEach(({widgetMap:{filterPicker:{filter:n,isValid:s}}})=>{s&&!e.filters.includes(n)&&(e.removeFilter(n.id,!0),e.addFilter(n,!0),r=!0)}),r&&e.filter(),t.appendFiltersFromStore(),e.ion({name:"store",filter:"onStoreFilter",thisObj:t})}t.widgetMap.pickers.childItems.forEach(r=>r.store=e)}updateShowAddFilterButton(e){this.widgetMap.addFilterButton.hidden=!e}updateAddFilterButtonText(e){this.widgetMap.addFilterButton.text=e!=null?e:Ad.addFilterButtonDefaultText}appendFiltersFromStore(){const e=this;e.store.filters.forEach(t=>{var r;const n=e.canManage(t),{property:s,operator:a,id:o}=t;n&&s&&a&&!((r=e.filters)!=null&&r.find(l=>l.id===o))&&e.appendFilter(t)})}canManage(e){const t=this;return!t.canManageFilter||t.callback(t.canManageFilter,t,[e])===!0}getFilterPickerConfig(e){const t=this,{fields:r,store:n,disabled:s,readOnly:a,valueFieldCls:o,operators:l,limitToProperty:d,dateFormat:c,getFieldFilterPickerConfig:u,triggerChangeOnInput:h}=t;return{type:t.constructor.childPickerType,fields:r!=null?r:t.getFieldsFromStore(n),filter:e,store:n,disabled:s,readOnly:a,propertyLocked:!!d,valueFieldCls:o,operators:l,dateFormat:c,internalListeners:{change:"onFilterPickerChange",thisObj:t},flex:1,triggerChangeOnInput:h,...u?t.callback(u,t,[e]):void 0}}getFieldsFromStore(e){var t,r;return Object.fromEntries((r=(t=e.modelClass)==null?void 0:t.fields.map(({name:n,type:s})=>[n,{type:s}]))!=null?r:[])}getPickerRowConfig(e){const t=this,{disabled:r,readOnly:n,canDeleteFilter:s}=t,a=!(s&&t.callback(s,t,[e])===!1);return{type:"container",layout:"box",cls:{[`b-${Ad.type}-row`]:!0,[`b-${Ad.type}-row-removable`]:a},dataset:{separatorText:t.L("L{FieldFilterPicker.and}")},items:{activeCheckbox:{type:"checkbox",disabled:r,readOnly:n,checked:!e.disabled,internalListeners:{change:"onFilterActiveChange",thisObj:t},cls:`b-${Ad.type}-filter-active`},filterPicker:t.getFilterPickerConfig(e),removeButton:{type:"button",ref:"removeButton",disabled:r,readOnly:n,hidden:!a,cls:`b-transparent b-${Ad.type}-remove`,icon:"b-fa-trash",internalListeners:{click:"removeFilter",thisObj:t}}}}}get allInputs(){const e=[this.constructor.childPickerType,"button","checkbox"];return this.queryAll(t=>e.includes(t.type))}updateDisabled(e,t){super.updateDisabled(e,t),this.allInputs.forEach(r=>r.disabled=e)}updateReadOnly(e){this.allInputs.forEach(t=>t.readOnly=e)}onFilterActiveChange({source:e,checked:t}){const r=this,n=r.getFilterIndex(e),s=r.filters[n],a=r.getFilterPicker(n);s.disabled=!t,a.onFilterChange(),r.store&&a.isValid&&r.store.addFilter(s,!0),r.updateStoreFilter(),r.triggerChange()}onFilterPickerChange({source:e,filter:t,isValid:r}){const n=this,{store:s}=n,a=n.getFilterIndex(e);s&&(s.removeFilter(t.id,!0),r&&s.addFilter(t,!0),n.updateStoreFilter()),Object.assign(n.filters[a],t),n.triggerChange()}getFilterIndex(e){return parseInt(e.parent.element.dataset.itemIndex)}getPickerRow(e){return this.widgetMap.pickers.childItems[e]}getFilterPicker(e){return this.getPickerRow(e).widgetMap.filterPicker}get nextFilterId(){return this._nextId=(this._nextId||0)+1,`${this.id}-filter-${this._nextId}`}removeFilter({source:e}){const t=this,r=t.getFilterIndex(e),n=t.filters[r],s=t.getPickerRow(r),a=t.query(o=>o.isFocusable&&o.type!=="container"&&!s.contains(o));a&&a.focus(),t.removeFilterAt(r),t.store&&(t.store.removeFilter(n.id,!0),t.updateStoreFilter()),t.trigger("remove",{filter:n}),t.triggerChange()}addFilter({property:e=null,operator:t=null,value:r=null}={}){var n;const s=this,{filters:a}=s,o={property:s.limitToProperty||e,operator:t,value:r,disabled:!1,id:s.nextFilterId,caseSensitive:!1};s.trigger("beforeAddFilter",{filter:o})&&(s.appendFilter(o),s.getFilterPicker(a.length-1).isValid&&((n=s.store)==null||n.addFilter(o,!0),s.store&&s.updateStoreFilter()),s.trigger("add",{filter:o}),s.triggerChange())}appendFilter(e){const t=this;(!t.limitToProperty||e.property===t.limitToProperty)&&(t.filters.push(e),t.widgetMap.pickers.add(t.getPickerRowConfig(e,t.filters.length-1)))}onStoreFilter(e){const t=this;if(t._isUpdatingStore)return;const{filters:r}=e,n=r.values.reduce((s,a)=>({...s,[a.id]:a}),{});for(let s=t.filters.length-1;s>=0;s--){const a=t.filters[s],o=n[a.id],l=t.getPickerRow(s);if(l){const{filterPicker:d,activeCheckbox:c}=l.widgetMap;if(!o&&d.isValid)t.removeFilterAt(s);else if(o!==void 0){const{operator:u,value:h,property:f,disabled:g,caseSensitive:m}=o;a!==o&&Object.assign(a,{operator:u,value:h,property:f,disabled:g,caseSensitive:m}),d.filter=a,d.onFilterChange(),c.checked=!g}}}t.appendFiltersFromStore(),t.triggerChange()}removeFilterAt(e){const{widgetMap:{pickers:t},filters:r}=this;t.remove(t.childItems[e]),r.splice(e,1),this.triggerChange()}updateStoreFilter(){var e;this._isUpdatingStore=!0,(e=this.store)==null||e.filter(),this._isUpdatingStore=!1}get value(){return this.filters}triggerChange(){const{filters:e}=this,t=e.filter((r,n)=>this.getPickerRow(n).widgetMap.filterPicker.isValid);this.trigger("change",{filters:e,validFilters:t})}activateAll(){this.setAllActiveStatus(!0)}deactivateAll(){this.setAllActiveStatus(!1)}setAllActiveStatus(e){const t=this,{_filters:r,store:n}=t;r.forEach((s,a)=>{if(e===s.disabled){const{filterPicker:o,activeCheckbox:l}=t.getPickerRow(a).widgetMap;s.disabled=!e,o.onFilterChange(),l.checked=e,e&&n&&o.isValid&&n.addFilter(s,!0)}}),t.updateStoreFilter()}get focusElement(){var e,t;return(t=(e=this.getPickerRow(this._filters.length-1))==null?void 0:e.widgetMap.filterPicker.focusElement)!=null?t:super.focusElement}};v(vn,"$name","FieldFilterPickerGroup"),v(vn,"type","fieldfilterpickergroup"),v(vn,"addFilterButtonDefaultText","L{FieldFilterPickerGroup.addFilter}"),v(vn,"configurable",{filters:[],fields:null,disabled:!1,readOnly:!1,layout:"vbox",store:null,limitToProperty:null,valueFieldCls:null,showAddFilterButton:!0,canDeleteFilter:null,getFieldFilterPickerConfig:null,canManageFilter:null,addFilterButtonText:null,triggerChangeOnInput:!0,items:{pickers:{type:"container",layout:"vbox",scrollable:!0,items:{}},addFilterButton:{type:"button",text:vn.addFilterButtonDefaultText,cls:`b-${vn.type}-add-button`,hidden:!0}},operators:null,dateFormat:"L{FieldFilterPicker.dateFormat}"}),v(vn,"childPickerType","fieldfilterpicker");var Cg=vn;Cg.initClass(),Cg._$name="FieldFilterPickerGroup";var uo=class extends ei.mixin(ry){static get configurable(){return{bodyTag:"fieldset",focusable:!1,localizableProperties:["label"],inline:null,inlineInternal:null,layout:{type:"box",horizontal:!1}}}static get prototypeProperties(){return{flexRowCls:"b-hbox",flexColCls:"b-vbox"}}get bodyConfig(){const i=super.bodyConfig,{className:e}=i,{inlineInternal:t,hasLabel:r,title:n}=this;return delete i.html,e["b-inline"]=t,e["b-fieldset-has-label"]=r,n&&(i.children={legendElement:{tag:"legend",text:n,class:{"b-fieldset-legend":1}}}),i}compose(){const{inlineInternal:i,label:e,labelCls:t,labelWidth:r}=this;return{class:{"b-field":e,"b-vbox":!i},children:{"labelElement > headerElement":(e||null)&&{tag:"label",html:e,class:{"b-label":1,"b-align-start":1,[t]:t},style:{width:E.unitize("width",r)[1]}}}}}syncInlineInternal(){var i;this.inlineInternal=(i=this.inline)!=null?i:this.label!=null&&this.labelPosition==="before"}updateDisabled(i,e){super.updateDisabled(i,e),this.eachWidget(t=>{t.disabled=i},!1)}updateInline(){this.syncInlineInternal()}updateInlineInternal(i){this.layout.horizontal=i}updateLabel(){this.syncInlineInternal()}updateLabelPosition(){this.syncInlineInternal()}};v(uo,"$name","FieldSet"),v(uo,"type","fieldset"),uo.initClass(),uo._$name="FieldSet";var Rc=class extends ct{static get configurable(){return{multiple:null,accept:null,inputType:"file",attributes:["multiple","accept"]}}get files(){return this.input.files}pickFile(){this.input.click()}get multiple(){return this._multiple?"":null}clear(){this.input.value=null}triggerChange(i){this.triggerFieldChange({event:i,value:this.input.value,oldValue:this._lastValue,userAction:!0,valid:!0})}};v(Rc,"$name","FileField"),v(Rc,"type","filefield"),Rc.initClass(),Rc._$name="FileField";var ho=class extends dt{construct(i={}){const e=this;i.items=[Object.assign({type:"button",ref:"fileButton",text:"L{FilePicker.file}",localeClass:this},i.buttonConfig),Object.assign({type:"filefield",ref:"fileField",style:"display: none"},i.fileFieldConfig)].concat(i.items||[]),super.construct(i),e.button.ion({click:e.onButtonClick,thisObj:e}),e.fileField.ion({change:e.onFileFieldChange,thisObj:e}),e._thisIsAUsedExpression(e.fileTip)}get button(){return this.widgetMap.fileButton}get fileField(){return this.widgetMap.fileField}get files(){return this.fileField.files}get fileTip(){const i=this;return i._fileTip||(i._fileTip=new Te({cls:"b-file-tip",forElement:i.button.element,showOnHover:!0,align:"b-t",scrollAction:"realign",internalListeners:{beforeshow(){const e=this,t=i.files;return t&&t.length?(e.html=`${Array.from(t).map(r=>O.encodeHtml(r.name)).join("<br>")}`,!0):!1}}}))}clear(){const i=this;i.fileField.clear(),i.updateBadge(),i.trigger("clear")}onButtonClick({event:i}){this.fileField.pickFile(),i.preventDefault()}onFileFieldChange({valid:i}){const e=this;e.updateBadge(),e.triggerFieldChange({files:e.files,valid:i})}updateShowBadge(){this.isConfiguring||this.updateBadge()}updateBadge(){this.button.badge=this.showBadge&&this.files.length||""}};v(ho,"$name","FilePicker"),v(ho,"type","filepicker"),v(ho,"configurable",{defaultBindProperty:"value",buttonConfig:null,fileFieldConfig:null,showBadge:!0}),ho.initClass(),ho._$name="FilePicker";var Tc=class extends Fi{static get configurable(){return{field:null,store:null,filterFunction:null,clearable:!0,revertOnEscape:!0,ignoreParentReadOnly:!0,keyStrokeChangeDelay:100,internalListeners:{change:"onInternalChange"}}}updateValue(i,e){super.updateValue(i,e),i&&this.isConfiguring&&this.onInternalChange({value:i})}onInternalChange({value:i}){const{store:e,field:t,filterFunction:r}=this;if(e){const n=`${t||this.id}-Filter`;if(i.length===0)e.removeFilter(n);else{let s;r?s=a=>r(a,i):(i=i.replace(/[.*+?^${}()|[\]\\]/g,"\\$&"),s=a=>{var o;return(o=a.getValue(t))==null?void 0:o.match(new RegExp(i,"i"))}),e.filter({id:n,filterBy:s})}}}};v(Tc,"$name","FilterField"),v(Tc,"type","filterfield"),Tc.initClass(),Tc._$name="FilterField";var xx=[{ref:"cancelButton",cls:"b-messagedialog-cancelbutton b-gray",text:"L{Object.Cancel}",onClick:"up.onCancelClick"},{ref:"okButton",cls:"b-messagedialog-okbutton b-raised b-blue",text:"L{Object.Ok}",onClick:"up.onOkClick"}];K.isWindows&&xx.reverse();var Cy=class UI extends Mt{static get configurable(){return{ui:"plain",centered:!0,modal:!0,hidden:!0,autoShow:!1,closeAction:"hide",title:"\xA0",lazyItems:{$config:["lazy"],value:[{cls:"b-messagedialog-message",ref:"message"},{type:"textfield",cls:"b-messagedialog-input",ref:"input"}]},showClass:null,bbar:{overflow:null,items:xx}}}construct(){this.okButton=this.yesButton=1,this.cancelButton=3,super.construct(...arguments)}destroy(){}async confirm(){return this.showDialog("confirm",...arguments)}async alert(){return this.showDialog("alert",...arguments)}async prompt({textField:e}){const t=this.widgetMap.input;return V.reconfigure(t,e),t.value=e==null?void 0:e.value,this.showDialog("prompt",...arguments)}showDialog(e,{message:t="",title:r="",cancelButton:n,okButton:s,align:a,modal:o,rootElement:l=document.body}){const d=this;return d.rootElement=l,d.getConfig("lazyItems"),d.title=d.optionalL(r),d.widgetMap.message.html=d.optionalL(t),d.showClass=`b-messagedialog-${e}`,d.modal=typeof o=="boolean"?o:!0,d.centered=!a,s&&(s=typeof s=="string"?{text:s}:s),n&&(n=typeof n=="string"?{text:n}:n),s=Object.assign({},d.widgetMap.okButton.initialConfig,s),n=Object.assign({},d.widgetMap.cancelButton.initialConfig,n),s.text=d.optionalL(s.text),n.text=d.optionalL(n.text),V.reconfigure(d.widgetMap.okButton,s),V.reconfigure(d.widgetMap.cancelButton,n),d.show({align:a}),d.promise=new Promise(c=>{d.resolve=c})}show(){const e=E.getActiveElement(this.element);return this.owner=this.element.contains(e)?null:UI.fromElement(document.activeElement),super.show(...arguments)}updateShowClass(e,t){const{classList:r}=this.element;t&&r.remove(t),e&&r.add(e)}doResolve(e){const t=this,{resolve:r}=t;if(r){const n=t.showClass==="b-messagedialog-prompt";if(n&&e===t.okButton&&!t.widgetMap.input.isValid)return;t.resolve=t.reject=t.promise=null,r(n?{button:e,text:t.widgetMap.input.value}:e),t.hide()}}onInternalKeyDown(e){e.key==="Escape"?(e.stopImmediatePropagation(),this.onCancelClick()):e.key==="Enter"&&!e.target.closest(".b-button")&&(e.stopImmediatePropagation(),e.preventDefault(),this.onOkClick()),super.onInternalKeyDown(e)}onOkClick(){this.doResolve(Sy.okButton)}onCancelClick(){this.doResolve(Sy.cancelButton)}};v(Cy,"$name","MessageDialog"),v(Cy,"type","messagedialog");var Rx=Cy;Rx.initClass();var Sy=new Proxy({},{get(i,e){const t=i.instance||(i.instance=new Rx({rootElement:document.body})),r=t[e];return typeof r=="function"?r.bind(t):r}}),ii=Sy,Mc=class extends Ja{static get defaultConfig(){return{store:null,defaults:{localeClass:this},items:{firstPageButton:{onClick:"up.onFirstPageClick",icon:"b-icon-first",weight:100,tooltip:"L{PagingToolbar.firstPage}"},previousPageButton:{onClick:"up.onPreviousPageClick",icon:"b-icon-previous",weight:110,tooltip:"L{PagingToolbar.prevPage}"},pageNumber:{type:"numberfield",label:"L{page}",min:1,max:1,triggers:null,onChange:"up.onPageNumberChange",highlightExternalChange:!1,weight:120},pageCount:{type:"widget",cls:"b-pagecount b-toolbar-text",weight:130},nextPageButton:{onClick:"up.onNextPageClick",icon:"b-icon-next",weight:140,tooltip:"L{PagingToolbar.nextPage}"},lastPageButton:{onClick:"up.onLastPageClick",icon:"b-icon-last",weight:150,tooltip:"L{PagingToolbar.lastPage}"},separator:{type:"widget",cls:"b-toolbar-separator",weight:151},reloadButton:{onClick:"up.onReloadClick",icon:"b-icon-reload",weight:160,tooltip:"L{PagingToolbar.reload}"},spacer:{type:"widget",cls:"b-toolbar-fill",weight:161},dataSummary:{type:"widget",cls:"b-toolbar-text",weight:170}}}}set parent(i){super.parent=i,this.store||(this.store=i.store)}get parent(){return super.parent}set store(i){const e=this;e.detachListeners("store"),e._store=i,i&&(i.ion({name:"store",beforerequest:"onStoreBeforeRequest",afterrequest:"onStoreChange",change:"onStoreChange",thisObj:e}),i.isLoading&&e.onStoreBeforeRequest())}get store(){return this._store}onStoreBeforeRequest(){this.eachWidget(i=>i.disable())}updateLocalization(){this.updateSummary(),super.updateLocalization()}updateSummary(){const i=this,{pageCount:e,dataSummary:t}=i.widgetMap;let r=0,n=0,s=0,a=0,o=0;if(i.store){const{store:l}=i,{pageSize:d,currentPage:c}=l;r=l.count,n=l.lastPage,o=l.totalCount,s=Math.max(0,(c-1)*d+1),a=Math.min(o,s+d-1)}e.html=i.L("L{pageCountTemplate}")({lastPage:n}),t.html=r?i.L("L{summaryTemplate}")({start:s,end:a,allCount:o}):i.L("L{noRecords}")}onStoreChange(){const i=this,{widgetMap:e,store:t}=i,{count:r,lastPage:n,currentPage:s}=t,{pageNumber:a,pageCount:o,firstPageButton:l,previousPageButton:d,nextPageButton:c,lastPageButton:u,dataSummary:h}=e;i.eachWidget(f=>f.enable()),a.value=s,a.max=n,h.disabled=a.disabled=o.disabled=!r,l.disabled=d.disabled=s<=1||!r,c.disabled=u.disabled=s>=n||!r,i.updateSummary()}onPageNumberChange({value:i}){this.store.currentPage!==i&&this.store.loadPage(i)}onFirstPageClick(){this.store.loadPage(1)}onPreviousPageClick(){this.store.previousPage()}onNextPageClick(){this.store.nextPage()}onLastPageClick(){this.store.loadPage(this.store.lastPage)}onReloadClick(){this.store.loadPage(this.store.currentPage)}};v(Mc,"$name","PagingToolbar"),v(Mc,"type","pagingtoolbar"),Mc.initClass(),Mc._$name="PagingToolbar";var{dockIsHorz:YL}=Rr.maps,qL={top:0,down:0,left:1,bottom:2,up:2,right:3},Dy={up:{from:"translate(0,0)",to:"translate(0,-100%)"},down:{from:"translate(0,0)",to:"translate(0,100%)"},left:{from:"translate(0,0)",to:"translate(-100%,0)"},right:{from:"translate(0,0)",to:"translate(100%,0)"}},Ic=class extends Rr.mixin(ve){static get configurable(){return{autoCloseDelay:1e3,autoClose:!0,revealing:{value:null,$config:null,default:!1},recollapseTool:{type:"collapsetool",cls:"b-recollapse",collapsify:"overlay",handler(){var i;(i=this.collapsible)==null||i.toggleReveal()}}}}static get delayable(){return{doAutoClose:0}}doAutoClose(){this.toggleReveal(!1)}updateAutoCloseDelay(i){const{doAutoClose:e}=this;(e.suspended=i==null||i<0)||(e.delay=i,e.immediate=!i)}changeRecollapseTool(i){const e=this,{panel:t}=e;if(e.isConfiguring||e.isDestroying||!t||t.isDestroying)return i;t.tools={recollapse:i}}beforeCollapse(i){if(super.beforeCollapse(i)===!1)return!1;this.panel.revealed&&(i.animation=null)}applyHeaderDock(i,e=!0){var t;(t=this.panel)==null||t.recompose(),super.applyHeaderDock(i,e)}collapseBegin(i){const e=this,{collapseDir:t,innerElement:r}=e,{animation:n}=i,{collapseTool:s,panel:a}=e;e.configuredWidth=a._lastWidth,e.configuredHeight=a._lastHeight,e.applyHeaderDock(!0),e.lockInnerSize(),s==null||s.element.classList.add("b-collapsed"),n&&(a.element.classList.add("b-collapsing"),n.element=r,n.transform=Dy[t],i.animation=Tt.run(n))}onComplete(i){var e,t;super.onComplete(i);const r=this,{panel:n}=r,{element:s}=n;r.autoCloseLeaveDetacher=(e=r.autoCloseLeaveDetacher)==null?void 0:e.call(r),r.autoCloseClickDetacher=(t=r.autoCloseClickDetacher)==null?void 0:t.call(r),r.doAutoClose.cancel(),i==="reveal"&&r.autoClose&&(n.containsFocus&&(r.autoCloseLeaveDetacher=j.on({element:s,mouseenter:a=>{r.doAutoClose.cancel()},mouseleave:a=>{r.doAutoClose()}})),r.autoCloseClickDetacher=j.on({element:document.body,thisObj:n,mousedown:a=>{var o;!n.owns(a)&&!((o=r.revealer)!=null&&o.contains(a.target))&&r.autoCloseDelay!=null&&r.doAutoClose.now()}}))}expandBegin(i){const e=this,{animation:t}=i,{collapseDir:r,collapseTool:n,innerElement:s,panel:a}=e,{element:o}=a;o.classList.remove("b-collapsed","b-collapsing"),e.restoreConfiguredSize(),e.lockInnerSize(!1),e.lockInnerSize(),n==null||n.element.classList.remove("b-collapsed"),t&&(o.classList.add("b-collapsed","b-expanding"),t.element=s,t.transform={from:Dy[r].to,to:Dy[r].from},i.animation=Tt.run(t))}expandEnd(i){super.expandEnd(i);const{panel:e}=this;i.completed&&(e.revealed=!1),e.element.classList.remove("b-expanding")}expandRevert(i){super.expandRevert(i),this.panel.element.classList.add("b-expanding")}get innerElement(){return this.panel.overlayElement}get innerSizeElement(){return this.panel.element}get toolsConfig(){const i=this,{direction:e}=i,t=super.toolsConfig,r=i.recollapseTool;return r?{...t,recollapse:r&&T.assign({direction:e.toLowerCase()},r)}:t}lockInnerSize(i=!0){const e=this,{panel:t}=e,r=i&&t.rectangle(),n=i?[0,0,0,0]:"",s=super.lockInnerSize(i);return i&&(n[qL[e.collapseDir]]=`-${r[e.collapseDim]+10}px`),t.element.style.clipPath=i?`inset(${n.join(" ")})`:"",s}onOverlayTransitionDone(i){const e=this,{panel:t}=e;i.srcElement===t.overlayElement&&e.revealing&&(e.revealing=!1,e.onComplete(t.revealed?"reveal":"unreveal"))}onRevealerClick(){this.toggleReveal()}toggleReveal(i){const{panel:e}=this,{element:t}=e;e.collapsed&&(this.revealer=E.getActiveElement(t),i==null&&(i=!e.revealed),e.revealed!==i&&e.trigger("beforeToggleReveal",{reveal:i})!==!1&&(!i&&t.contains(this.revealer)&&e.revertFocus(!0),this.revealing=!0,e.revealed=i))}updateRevealing(i){const e=this,t=/left|right/i,{panel:r}=e,n=t.test(e.collapseDir)?"height":"width";r&&(e.innerElement.style[n]="0px",e.innerElement.style[`min-${n}`]="100%",r.element.classList[i?"add":"remove"]("b-panel-overlay-revealing"))}wrapCollapser(i,e){var t;const r=this,{collapseDir:n,panel:s}=r,{expandedHeaderDock:a,header:o,uiClassList:l}=s,d=(t=s.tools)==null?void 0:t.recollapse,[c,u]=r.splitHeaderItems({as:"element",dock:r.collapseDock}),h=YL[a],f=s.hasHeader?s.title||(o==null?void 0:o.title)||"\xA0":null;return d&&(d.direction=n),["overlayElement",{class:{...l,[`b-panel-overlay-header-${a}`]:1,[`b-panel-overlay-${n}`]:1,[`b-${h?"h":"v"}box`]:1,"b-panel-overlay":1,"b-box-center":1},listeners:{transitionend:g=>r.onOverlayTransitionDone(g),transitioncancel:g=>r.onOverlayTransitionDone(g)},children:{overlayHeaderElement:f&&{tag:"header",class:new se({...l,[`b-dock-${a}`]:1,"b-panel-header":1,"b-panel-overlay-header":1},o==null?void 0:o.cls),children:[...c,{reference:"overlayTitleElement",html:f,class:{...l,[`b-align-${(o==null?void 0:o.titleAlign)||"start"}`]:1,"b-header-title":1}},...u]},[i]:e}}]}};v(Ic,"$name","PanelCollapserOverlay"),v(Ic,"type","overlay"),Ic.initClass(),Ic._$name="PanelCollapserOverlay";var fo=class extends ct{construct(i={}){i.inputType="password",super.construct(...arguments),this.element.classList.add("b-textfield")}};v(fo,"$name","PasswordField"),v(fo,"type","passwordfield"),v(fo,"alias","password"),fo.initClass(),fo._$name="PasswordField";var go=class extends Ar{static get configurable(){return{inputType:"radio",clearable:null,uncheckedValue:void 0}}get textLabelCls(){return super.textLabelCls+" b-radio-label"}internalOnClick(i){super.internalOnClick(i)!==!1&&this.checked&&this.clearable&&(this.checked=!1)}updateName(i){this.toggleGroup=i}updateClearable(){}};v(go,"$name","Radio"),v(go,"type","radio"),v(go,"alias","radiobutton"),go.initClass(),go._$name="Radio";var _s=class extends uo{static get configurable(){return{defaultType:"radio",clearable:null,name:null,options:{value:null,$config:{merge:"items"}},defaultBindProperty:"value"}}get existingOptions(){const{name:i}=this;return this.ensureItems().filter(e=>e.name===i)}get refPrefix(){return`${this.name||this.ref||this.id}_`}get selected(){return this.existingOptions.filter(i=>i.input.checked)[0]||null}get value(){const{selected:i}=this;return i?i.checkedValue:null}set value(i){this.existingOptions.forEach(e=>{e.isConfiguring=this.isConfiguring,e.checked=e.checkedValue===i,e.isConfiguring=!1})}ensureItems(){return this.getConfig("options"),super.ensureItems()}changeOptions(i,e){if(!(i&&e&&T.isDeeplyEqual(e,i)))return i}convertOption(i,e,t){const r=this,{name:n}=r,s={name:n,type:"radio",value:i===r.value,ref:`${r.refPrefix}${i}`,checkedValue:i};return typeof e=="string"?s.text=e:T.assign(s,e),t?V.reconfigure(t,s):s}isOurRadio(i){return i.isRadio&&i.name===this.name}isolateFieldChange(i){return this.isOurRadio(i)}onChildAdd(i){super.onChildAdd(i),this.isOurRadio(i)&&i.ion({name:i.id,beforeChange:"onRadioItemBeforeChange",change:"onRadioItemChange",click:"onRadioClick",thisObj:this})}onChildRemove(i){this.isOurRadio(i)&&this.detachListeners(i.id),super.onChildRemove(i)}onRadioClick(i){const{source:e}=i;e.checked&&this.clearable&&e.clearable==null&&(e.checked=!1)}onRadioItemBeforeChange(i){if(i.checked){const e=this,{lastValue:t}=e;if(!e.reverting&&e.trigger("beforeChange",e.wrapRadioEvent(i))===!1&&t!=null&&t!==e.value)return e.reverting=!0,i.source.uncheckToggleGroupMembers(),e.value=t,e.lastValue=t,e.reverting=!1,!1}}onRadioItemChange(i){const e=this;i.checked&&!e.reverting&&(e.triggerFieldChange(e.wrapRadioEvent(i)),e.lastValue=e.value)}wrapRadioEvent(i){return{from:i,item:i.source,userAction:i.userAction,lastValue:this.lastValue,value:this.value}}updateOptions(){const i=this,{options:e,refPrefix:t}=i,r=i.existingOptions.reduce((l,d)=>(l[d.ref.substring(t.length)]=d,l),{});let n=0,s,a;if(e)for(s in e)a=i.convertOption(s,e[s],r[s]),delete r[s],i.insert(a,n++);const o=Object.values(r);o!=null&&o.length&&(i.remove(o),o.forEach(l=>l.destroy()))}};v(_s,"$name","RadioGroup"),v(_s,"type","radiogroup"),_s.initClass(),_s._$name="RadioGroup";var KL={ArrowUp:1,ArrowDown:1,ArrowLeft:1,ArrowRight:1},_c=class extends V{static get configurable(){return{text:null,showValue:!0,showTooltip:!1,min:0,max:100,step:1,value:50,unit:null,thumbSize:20,tooltip:{$config:["lazy","nullify"],value:{type:"tooltip",align:"b-t",anchor:!1,axisLock:!0}},localizableProperties:["text"],triggerChangeOnInput:null,defaultBindProperty:"value",twinSyncConfigs:["max","min","step","value"],label:null}}compose(){const{id:i,min:e,max:t,showValue:r,step:n,text:s,value:a,unit:o="",disabled:l,readOnly:d,label:c}=this,u=`${i}-input`,h=!!(s||r);return{class:{"b-has-field-label":c,"b-has-label":h,"b-text":h,"b-disabled":l},children:{inputLabel:c?{tag:"label",for:u,text:c}:null,input:{tag:"input",type:"range",id:u,reference:"input",[l?"disabled":""]:l,[d?"readOnly":""]:d,min:e,max:t,step:n,value:a,listeners:{input:"onInternalInput",change:"onInternalChange",mouseover:"onInternalMouseOver",mouseout:"onInternalMouseOut"}},valueLabel:h?{tag:"label",class:"b-slider-value",for:u,text:r?s?`${s} (${a}${o})`:a+o:s}:null}}}get focusElement(){return this.input}get percentProgress(){return(this.value-this.min)/(this.max-this.min)*100}onInternalKeyDown(i){!this.readOnly&&KL[i.key]&&i.stopImmediatePropagation()}onInternalChange(){this.updateUI(),this.triggerChange(!0),this.trigger("action",{value:this.value})}onInternalInput(){const i=this;if(i.readOnly){i.input.value=i.value;return}i.value=parseInt(i.input.value,10),i.trigger("input",{value:i.value}),i.triggerChangeOnInput&&i.triggerChange(i)}onInternalMouseOver(){var i;const e=this,t=e.rtl?100-e.percentProgress:e.percentProgress;(i=e.tooltip)==null||i.showBy({target:k.from(e.input).inflate(e.thumbSize/2,-e.thumbSize/2),align:`b-t${Math.round(t)}`})}onInternalMouseOut(){var i;(i=this.tooltip)==null||i.hide()}triggerChange(i){this.triggerFieldChange({value:this.value,valid:!0,userAction:i})}updateMax(i){const e=this;e.input&&e._value>i&&(e.value=i,e.trigger("input",{value:e.value}))}updateMin(i){const e=this;e.input&&e._value<i&&(e.value=i,e.trigger("input",{value:e.value}))}changeTooltip(i,e){var t;return i&&(i.owner=this),this.showTooltip?Te.reconfigure(e,i,{owner:this,defaults:{forElement:this.input,html:String(this.value)+((t=this.unit)!=null?t:"")}}):null}changeValue(i){const e=this,{min:t,step:r}=e;return i=Math.min(Math.max(i,t),e.max),i>t?t+T.roundTo(i-t,r):T.roundTo(i,r)}updateValue(i){var e;const t=this,{input:r,_tooltip:n}=t;n&&(n.html=t.value+((e=t.unit)!=null?e:"")),r&&r.value!==String(i)&&(r.value=i,t.triggerChange(!1)),t.updateUI()}updateUI(){var i,e;const t=this;(i=t._tooltip)!=null&&i.isVisible&&((e=t._tooltip)==null||e.alignTo({target:k.from(t.input).inflate(t.thumbSize/2,-t.thumbSize/2),align:`b-t${Math.round(t.percentProgress)}`}))}};v(_c,"$name","Slider"),v(_c,"type","slider"),_c.initClass(),_c._$name="Slider";var mo=class extends Ar{static get properties(){return{toggledCls:"b-slidetoggle-checked"}}construct(i){i.checked&&(i.cls=se.from(i.cls)||{},i.cls[this.constructor.properties.toggledCls]=1),super.construct(i)}get innerElements(){const i=super.innerElements;return i.splice(1,0,this.toggleElement),this.text?i[i.length-1].class="b-slidetoggle-label":i.pop(),i}get toggleElement(){return{class:"b-slidetoggle-toggle",reference:"slideToggle",children:[{class:"b-slidetoggle-thumb",reference:"slideThumb"}]}}internalOnChange(){super.internalOnChange(),this.element.classList[this.value?"add":"remove"](this.toggledCls)}};v(mo,"$name","SlideToggle"),v(mo,"type","slidetoggle"),mo.initClass(),mo._$name="SlideToggle";var Tx=["b-horizontal","b-vertical"],wy=i=>E.getStyleValue(i.parentElement,"display")==="flex"&&(parseInt(E.getStyleValue(i,"flex-basis"),10)||parseInt(E.getStyleValue(i,"flex-grow"),10)),XL={horizontal:!1,vertical:!0},Lr=class extends V{static get configurable(){return{orientation:"auto",vertical:null,containerElement:{$config:"nullify",value:null},nextNeighbor:{$config:"nullify",value:null},previousNeighbor:{$config:"nullify",value:null}}}static get delayable(){return{syncState:"raf"}}doDestroy(){var i;(i=this.mouseDetacher)==null||i.call(this),super.doDestroy()}compose(){return{class:{"b-splitter":1},listeners:{pointerdown:"onMouseDown",mouseenter:"onMouseEnter",mouseleave:"onMouseLeave",...!K.supportsPointerEvents&&{mousedown:"onMouseDown",touchstart:"onMouseDown"}}}}get currentOrientation(){return this.vertical?"vertical":"horizontal"}getSibling(i=!0){let{element:e}=this,t;for(;!t&&(e=e[`${i?"next":"previous"}ElementSibling`]);)(!e.isConnected||E.isVisible(e))&&(t=e);return t}get nextWidget(){let{element:i}=this,e;for(;!e&&(i=i.nextElementSibling);)e=V.fromElement(i,this.element.parentElement);return e}get previousWidget(){let{element:i}=this,e;for(;!e&&(i=i.previousElementSibling);)e=V.fromElement(i,this.element.parentElement);return e}updateContainerElement(i){var e;const t=this;t.stateDetector=(e=t.stateDetector)==null?void 0:e.disconnect(),i&&(t.stateDetector=new MutationObserver(()=>t.syncState()),t.stateDetector.observe(i,{attributes:!0,childList:!0}))}updateNextNeighbor(i){this.watchNeighbor(i,"next")}updatePreviousNeighbor(i){this.watchNeighbor(i,"previous")}watchNeighbor(i,e){this.detachListeners(e),i==null||i.ion({name:e,thisObj:this,collapse:"syncState",expand:"syncState",hide:"syncState",show:"syncState"})}updateOrientation(){this.syncState.now()}updateVertical(i){var e;const t=(e=this.element)==null?void 0:e.classList;t==null||t.add(Tx[i?1:0]),t==null||t.remove(Tx[i?0:1])}syncState(){var i;const e=this,{element:t,nextWidget:r,previousWidget:n}=e;let s=(i=XL[e.orientation])!=null?i:null;if(e.nextNeighbor=r,e.previousNeighbor=n,e.disabled=r&&(r.collapsible&&r.collapsed||r.hidden)||n&&(n.collapsible&&n.collapsed||n.hidden),s!==null&&r&&n)e.containerElement=null;else if(e.containerElement=t.parentElement,e.rendered&&t.offsetParent){const a=E.getStyleValue(t.parentElement,"flex-direction");if(a)s=!a.startsWith("column");else{const o=t.previousElementSibling,l=t.nextElementSibling;if(!o||!l)return;const d=o.getBoundingClientRect(),c=l.getBoundingClientRect(),u=d.top<c.top?d:c,h=u===c?d:c;s=u.top===h.top}}e.vertical=s}onMouseDown(i){var e;i.preventDefault(),i.touches&&(i=i.touches[0]);const t=this,{element:r,nextNeighbor:n,previousNeighbor:s}=t,a=s?s.element:t.getSibling(!1),o=n?n.element:t.getSibling(),l=wy(a),d=wy(o),c=[];(e=t.mouseDetacher)==null||e.call(t);for(const h of r.parentElement.children)wy(h)&&h!==r&&c.push({element:h,width:h.offsetWidth,height:h.offsetHeight});t.context={startX:i.pageX,startY:i.pageY,prevWidth:a.offsetWidth,prevHeight:a.offsetHeight,nextWidth:o.offsetWidth,nextHeight:o.offsetHeight,prevHasFlex:l,nextHasFlex:d,flexed:c,prev:a,next:o};const u={element:document,pointermove:"onMouseMove",pointerup:"onMouseUp",thisObj:t};K.supportsPointerEvents||(u.mousemove=u.touchmove="onMouseMove",u.mouseup=u.touchend="onMouseUp"),r.classList.add("b-moving"),t.mouseDetacher=j.on(u),t.trigger("splitterMouseDown",{event:i})}onMouseEnter(i){this.syncState(),this.trigger("splitterMouseEnter",{event:i})}onMouseLeave(i){this.trigger("splitterMouseLeave",{event:i})}onMouseMove(i){const e=this,{context:t,nextWidget:r,previousWidget:n}=e,s=t.prev.style,a=t.next.style,o=(i.pageX-t.startX)*(e.rtl?-1:1),l=i.pageY-t.startY;if(i.preventDefault(),Object.assign(t,{deltaX:o,deltaY:l}),t.started||(t.started=!0,e.trigger("dragStart",{context:t,event:i}),t.flexed.forEach(d=>{d.element.style.flexGrow=e.vertical?d.width:d.height,d.element.style.flexBasis="0"})),e.vertical){const d=t.prevWidth+o,c=t.nextWidth-o;t.prevHasFlex?s.flexGrow=d:n?n.width=d:s.width=`${d}px`,t.nextHasFlex?a.flexGrow=c:r?r.width=c:a.width=`${c}px`}else{const d=t.prevHeight+l,c=t.nextHeight-l;t.prevHasFlex?s.flexGrow=d:n?n.height=d:s.height=`${d}px`,t.nextHasFlex?a.flexGrow=c:r?r.height=c:a.height=`${c}px`}e.trigger("drag",{context:t,event:i})}onMouseUp(i){var e;const t=this;(e=t.mouseDetacher)==null||e.call(t),t.mouseDetacher=null,t.element.classList.remove("b-moving"),t.context.started&&t.trigger("drop",{context:t.context,event:i}),t.context=null}render(){super.render(...arguments),this.syncState.now(),this.vertical===null&&this.syncState()}};v(Lr,"$name","Splitter"),v(Lr,"type","splitter"),Lr.initClass(),Lr._$name="Splitter";var po=class extends gi{static get configurable(){return{active:null,index:null,isFirst:null,isLast:null,item:{value:null,$config:"nullify"},itemCls:null,tabPanel:null,titleProperty:"text",titleSource:"title",role:"tab"}}compose(){const{active:i,cls:e,index:t,isFirst:r,isLast:n}=this,s=this.owner.visibleChildCount;return{tabindex:0,"aria-selected":i,"aria-setsize":s,"aria-posinset":t+1,class:{"b-tabpanel-tab":1,"b-active":i,"b-tab-first":r,"b-tab-last":n,...e},dataset:{index:t}}}updateIndex(i){this.isFirst=!i}updateItem(i,e){var t,r;const n=this;(e==null?void 0:e.tab)===n&&(e.tab=null),i&&(i.tab=n,n[n.titleProperty]=i[n.titleSource],n.itemCls=i.cls,n.ariaElement.setAttribute("aria-controls",i.id),i.role="tabpanel"),(t=n.itemChangeDetacher)==null||t.call(n),n.itemChangeDetacher=i&&Se.after(i,"onConfigChange","onItemConfigChange",n,{return:!1}),(r=n.itemHideDetacher)==null||r.call(n),n.itemHideDetacher=i==null?void 0:i.ion({beforeChangeHidden:"onItemBeforeChangeHidden",beforeHide:"onItemBeforeHide",beforeUpdateDisabled:"onItemBeforeUpdateDisabled",thisObj:n,prio:1e3}),n.syncMinMax()}updateItemCls(i,e){const{element:t}=this,r=t&&se.from(t==null?void 0:t.classList,!0);t&&(r.remove(e).add(i),t.className=r.value)}updateRotate(i,e){!i!=!e&&this.syncMinMax()}syncMinMax(){const i=this,{rotate:e,tabPanel:t}=i;let{_minWidth:r,_minHeight:n,_maxWidth:s,_maxHeight:a}=i;if(t){const{tabMinWidth:o,tabMaxWidth:l}=t;o!=null&&(e?(r===o&&(r=null),n=o):(n===o&&(n=null),r=o)),l!=null&&(e?(s===l&&(s=null),a=l):(a===l&&(a=null),s=l)),i.minWidth=r,i.minHeight=n,i.maxWidth=s,i.maxHeight=a}}onItemBeforeChangeHidden({source:i,hidden:e}){if(!i.$isDeactivating&&!i.$isActivating){const{tabPanel:t}=this;this.hidden=e,e&&i===t.activeItem&&t.activateAvailableTab(i)}}onItemBeforeHide(){this.item.$isDeactivating||this.hide()}onItemBeforeUpdateDisabled({source:i,disabled:e}){const{tabPanel:t}=this;this.disabled=e,i===t.activeItem&&t.activateAvailableTab(i)}onItemConfigChange({name:i,value:e}){i===this.titleSource&&(this[this.titleProperty]=e)}};v(po,"$name","Tab"),v(po,"type","tab"),po.initClass(),po._$name="Tab";var Sg=i=>i.isTab,Pc=class extends Ja{static get configurable(){return{defaultType:"tab",overflow:"scroll",role:"tablist",ignoreParentReadOnly:!0}}get firstTab(){return this.tabAt(0)}get lastTab(){return this.tabAt(-1)}get tabCount(){return this._items.countOf(Sg)}get tabs(){return H.from(this._items,Sg)}compose(){return{children:{toolbarContent:{class:{"b-tabpanel-tabs":1}}}}}indexOfTab(i){return this._items.indexOf(i,Sg)}onChildAdd(i){super.onChildAdd(i),i.index==null&&this.syncTabs()}onChildRemove(i){super.onChildRemove(i),this.syncTabs()}onFocusIn(){const{activeIndex:i}=this.owner;isNaN(i)||this.tabs[i].focus()}syncTabs(){const{tabs:i}=this;for(let e=0,t=i.length;e<t;++e)i[e].index=e,i[e].isFirst=!e,i[e].isLast=e===t-1}tabAt(i){return this._items.find(Sg,i)||null}};v(Pc,"$name","TabBar"),v(Pc,"type","tabbar"),Pc.initClass(),Pc._$name="TabBar";var Dg=["b-slide-out-left","b-slide-out-right","b-slide-in-left","b-slide-in-right"],vo=class extends Gi{onChildAdd(i){super.onChildAdd(i);const e=this,{activeItem:t,owner:r}=e,n=r.activeIndex!=null?r.activeIndex:e.activeIndex||0,s=r.items.indexOf(i),a=t!=null?i===t:s===n;i.ion({beforeHide:"onBeforeChildHide",beforeShow:"onBeforeChildShow",thisObj:e}),a?(e._activeIndex=s,e._activeItem=i,i.show()):(i.$isDeactivating=!0,i.hide(),i.$isDeactivating=!1)}onChildRemove(i){super.onChildRemove(i);const e=this;e._activeItem===i&&e.activateSiblingOf(i),e._activeIndex=e.owner.items.indexOf(e._activeItem),i.un({beforeHide:"onBeforeChildHide",beforeShow:"onBeforeChildShow",thisObj:e})}onBeforeChildShow({source:i}){if(!this.owner.isConfiguring&&!i.$isActivating)return this.activeItem=i,!1}onBeforeChildHide({source:i}){if(!this.owner.isConfiguring&&!i.$isDeactivating)return this.activateSiblingOf(i),!1}activateSiblingOf(i){const{owner:e}=this,t=e.items.slice(),r=t.indexOf(i);t.splice(r,1),this.activeIndex=Math.min(r,t.length-1)}setActiveItem(i,e=this.activeIndex,t){var r;const n=this,{owner:s}=n,{items:a}=s,o=i instanceof V,l=a[e],d=s.items[i=o?a.indexOf(i):parseInt(i,10)],c=(t==null?void 0:t.animation)!==!1,u=!(t!=null&&t.silent),h={prevActiveIndex:e,prevActiveItem:l};if(d&&!d.$isActivating&&d!==l){const f=l&&l.element,g=d&&d.element;if(n.animateDetacher){const p=n.animateDetacher.event;if(p.activeItem===d)return p.promise;n.animateDetacher(),p.prevActiveItem.element.classList.remove(...Dg),p.activeItem.element.classList.remove(...Dg),n.animateDetacher=null}if(h.activeIndex=i,h.activeItem=d,u&&s.trigger("beforeActiveItemChange",h)===!1)return null;const m=n._activeIndex!==h.activeIndex;m&&(n._activeIndex=h.activeIndex),u&&((r=s.onBeginActiveItemChange)==null||r.call(s,h)),m&&(n._activeIndex=h.prevActiveIndex),c&&f&&s.isVisible&&n.animateCardChange?h.promise=n.cardChangeAnimation=new Promise((p,y)=>{const b=l.monitorResize;l.monitorResize=!1,n.contentElement.style.overflowX="hidden",l._hidden=!0,d.$isActivating=!0,d.show(),d.$isActivating=!1,f.classList.add(i>e?"b-slide-out-left":"b-slide-out-right"),g.classList.add(i<e?"b-slide-in-left":"b-slide-in-right"),s.isAnimating=!0,n.animateDetacher=j.onTransitionEnd({mode:"animation",element:g,thisObj:l,handler(){if(s.isAnimating=n.cardChangeAnimation=!1,!n.animateDetacher){n.setActiveItem(i,e,t);return}n.animateDetacher=null,g.classList.remove(...Dg),f&&(f.classList.remove(...Dg),l.$isDeactivating=!0,l._hidden=!1,l.hide(),l.monitorResize=b,l.$isDeactivating=!1),n.contentElement.style.overflowX="",n.onActiveItemChange(h,p,!u)}}),n.animateDetacher.reject=y,n.animateDetacher.event=h}):(d.$isActivating=!0,d.show(),s.containsFocus&&d.focus(),d.$isActivating=!1,l&&(l.$isDeactivating=!0,l.hide(),l.$isDeactivating=!1),n.onActiveItemChange(h,null,!u))}return h}onActiveItemChange(i,e,t){const r=this;r._activeItem=i.activeItem,r._activeIndex=i.activeIndex,!t&&r.owner.trigger("activeItemChange",i),r.owner.containsFocus&&i.activeItem.focus(),e==null||e(i)}renderChildren(){const{owner:i}=this;i.contentElement.classList.toggle(this.hideChildHeaderCls,i.suppressChildHeaders),super.renderChildren()}changeActiveIndex(i){const{owner:e}=this;return e.isConfiguring&&!e._items?i:Math.min(i,e.items.length-1)}updateActiveIndex(i,e){this.owner.isConfiguring||this.setActiveItem(i,e)}updateActiveItem(i){this.owner.isConfiguring||this.setActiveItem(i,this.activeIndex)}get isChangingCard(){return!!this.animateDetacher}};v(vo,"$name","Card"),v(vo,"type","card"),v(vo,"configurable",{containerCls:"b-card-container",itemCls:"b-card-item",hideChildHeaderCls:"b-hide-child-headers",animateCardChange:!0,activeItem:null,activeIndex:null}),vo.initClass(),vo._$name="Card";var ZL=i=>i.maximized,yo=class extends ei{static get configurable(){return{activeTab:0,animateTabChange:!0,autoHeight:!1,defaultType:"container",focusable:!1,itemCls:"b-tabpanel-item",layout:{type:"card"},suppressChildHeaders:!0,tabBar:{type:"tabbar",weight:-2e3},tabMinWidth:null,tabMaxWidth:null}}get activeIndex(){return this.layout.activeIndex}get activeItem(){return this.layout.activeItem}get activeTabItemIndex(){var i;const{activeTab:e,items:t,tabBar:r}=this;return t.indexOf((i=r.tabs[e])==null?void 0:i.item)}get bodyConfig(){return T.merge({className:{"b-tabpanel-body":1}},super.bodyConfig)}get focusElement(){var i;const e=this.items[this.activeTab||0];return(e==null?void 0:e.focusElement)||((i=e==null?void 0:e.tab)==null?void 0:i.focusElement)}get tabPanelBody(){return this.bodyElement}finalizeInit(){super.finalizeInit();const i=this,{activeTab:e,layout:t}=i,{activeIndex:r}=t,{tabs:n}=i.tabBar,s=e>=0&&e<n.length&&i.items.indexOf(n[e].item);if(n.length>0&&(s===!1||s<0))throw new Error(`Invalid activeTab ${e} (${n.length} tabs)`);s!==r&&t.setActiveItem(s,r,{animation:!1,silent:!0}),t.animateCardChange=i.animateTabChange}onChildAdd(i){if(super.onChildAdd(i),!this.initialItems){const e=this,{tabBar:t}=e,r=e.makeTabConfig(i),n=r&&(t==null?void 0:t.firstTab),s=n&&t._items,a=n&&H.from(e._items,l=>l.tab||l===i),o=n?a.indexOf(i)+s.indexOf(n):0;r&&t&&(n&&i.weight==null&&o<s.count-1?t.insert(r,o):t.add(r))}}onChildRemove(i){const{tab:e}=i,{items:t}=this;e&&(this.tabBar.remove(e),e.destroy()),i===this.activeItem&&(this._activeTab=null,t.length&&(this.activeTab=t[Math.min(this.activeIndex,t.length-1)])),super.onChildRemove(i)}isDisabledOrHiddenTab(i){const{tabs:e}=this.tabBar,t=e==null?void 0:e[i];return t&&(t.disabled||t.hidden)}findAvailableTab(i,e=1){const{tabs:t}=this.tabBar,r=t.length,n=Math.max(0,t.indexOf(i.tab));n&&(e=-e);let s;for(let a=1;a<=r&&(s=(n+(e<0?r:0)+a*e)%r,!!this.isDisabledOrHiddenTab(s));++a);return s}activateAvailableTab(i,e=1){this.activeTab=this.findAvailableTab(i,e)}changeActiveTab(i,e){const t=this,{tabBar:r,layout:n}=t,{tabCount:s}=r;if(i.isWidget||T.isObject(i)?(t.items.indexOf(i)===-1&&(i=t.add(i)),i=r.indexOfTab(i.tab)):i=parseInt(i,10),!t.initialItems&&s>0&&(i<-1||i>=s))throw new Error(`Invalid activeTab ${i} (${s} tabs)`);if(t.isDisabledOrHiddenTab(i)&&(i=t.findAvailableTab(i)),n.animateCardChange&&n.cardChangeAnimation)n.cardChangeAnimation.then(a=>{(a==null?void 0:a.activeIndex)!==i&&(t._activeTab=i,t.updateActiveTab(i,e))});else return i}async updateActiveTab(i,e){var t;if(!this.initialItems){const{activeTabItemIndex:r,layout:n}=this;if(r>-1){const s=this.items[e],a=this.items[r];n.activeItem!==a&&(n.animateCardChange&&await this.tabSelectionPromise,s!=null&&s.containsFocus&&s.tab.focus(),this.tabSelectionPromise=(t=n.setActiveItem(a))==null?void 0:t.promise)}}}changeTabBar(i){return this.getConfig("strips"),this.strips={tabBar:i},this.strips.tabBar}makeTabConfig(i){const{tab:e}=i,t={item:i,type:"tab",active:!i.hidden,tabPanel:this,disabled:!!i.disabled,hidden:i.initialConfig.hidden,weight:i.weight||0,internalListeners:{click:"onTabClick",thisObj:this},localizableProperties:{text:!1}};return e===!1?null:T.isObject(e)?po.mergeConfigs(t,e):t}updateAnimateTabChange(i){this.isConfiguring||(this.layout.animateCardChange=i)}updateItems(i,e){const t=this,{activeTab:r,initialItems:n}=t;let s=0,a;super.updateItems(i,e),n&&(a=Array.from(i,o=>t.makeTabConfig(o)).filter(o=>{if(o)return o.index=s++,!0}),s&&(a[0].isFirst=!0,a[s-1].isLast=!0,a[r].active=!0,t.tabBar.add(a),t.activeTab=r))}updateTabMinWidth(i){var e;(e=this.tabBar)==null||e.items.forEach(t=>{t.isTab&&(t.minWidth=i)})}updateTabMaxWidth(i){var e;(e=this.tabBar)==null||e.items.forEach(t=>{t.isTab&&(t.maxWidth=i)})}updateAutoHeight(i){this.detachListeners("themeAutoHeight"),i&&ue.ion({name:"themeAutoHeight",theme:"internalOnThemeChange",thisObj:this})}applyAutoHeight(){const i=this,{layout:e,activeTab:t,element:r}=i,{animateCardChange:n}=e;if(e.animateCardChange=!1,i.flex="0 0 0%",!i.up(ZL)){const s=i.height=Math.max(...i.items.map(a=>(i.activeTab=a,r.clientHeight)))+1;i.flex=`1 1 ${s}px`}i.activeTab=t,e.animateCardChange=n}internalOnThemeChange(){this.isVisible&&this.applyAutoHeight()}onBeginActiveItemChange(i){const e=this.tabBar.tabs,{activeItem:t,prevActiveItem:r}=i;this.activeTab=e.indexOf(t==null?void 0:t.tab),r!=null&&r.tab&&(r.tab.active=!1),t!=null&&t.tab&&(t.tab.active=!0,t.tab.show())}onBeforeActiveItemChange(i){return this.trigger("beforeTabChange",i)}onActiveItemChange(i){this.trigger("tabChange",i)}onTabClick(i){this.activeTab=i.source.item}onInternalPaint(){super.onInternalPaint(...arguments),this.autoHeight&&this.applyAutoHeight()}};v(yo,"$name","TabPanel"),v(yo,"type","tabpanel"),v(yo,"alias","tabs"),yo.initClass(),yo._$name="TabPanel";var bo=class extends ct{static get configurable(){return{resize:"none",inputAttributes:{tag:"textarea"}}}updateResize(i){this.input.style.resize=i}};v(bo,"$name","TextAreaField"),v(bo,"type","textareafield"),v(bo,"alias","textarea"),bo.initClass(),bo._$name="TextAreaField";var wg=class GI extends _r{get inputElement(){const e=super.inputElement;return e.readOnly="readonly",e.reference="displayElement",this.ariaElement="displayElement",e}get focusElement(){var e;return(e=this._picker)!=null&&e.isVisible?this.input:this.displayElement}get needsInputSync(){var e;return this.displayElement[this.inputValueAttr]!==String((e=this.inputValue)!=null?e:"")}showPicker(){this.picker.width=this.pickerWidth||this.pickerAlignElement.offsetWidth,super.showPicker(!0)}focusPicker(){this.input.focus()}onPickerKeyDown(e){const t=this,r=t.input;switch(e.key.trim()||e.code){case"Escape":t.picker.hide();return;case"Enter":e.ctrlKey&&(t.syncInputFieldValue(),t.picker.hide());break}t.input=t.displayElement;const n=super.onPickerKeyDown(e);return t.input=r,n}syncInputFieldValue(e){this.displayElement&&(this.displayElement.value=this.inputValue),super.syncInputFieldValue(e)}changeValue(e){return e==null?"":e}changePicker(e,t){var r;const n=this,s=n.pickerWidth||(e==null?void 0:e.width);if(e=GI.reconfigure(t,e?X.merge({owner:n,forElement:n.pickerAlignElement,align:{matchSize:s==null,anchor:n.overlayAnchor,target:n.pickerAlignElement},id:n.id+"-input",style:{resize:n.resize},html:(r=n.value)!=null?r:""},e):null,n),e){const a=n.input=e.element;n.inputListenerRemover=j.on({element:a,thisObj:n,focus:"internalOnInputFocus",change:"internalOnChange",input:"internalOnInput",keydown:"internalOnKeyEvent",keypress:"internalOnKeyEvent",keyup:"internalOnKeyEvent"})}return e}};v(wg,"$name","TextAreaPickerField"),v(wg,"type","textareapickerfield"),v(wg,"configurable",{picker:{type:"widget",tag:"textarea",cls:"b-textareapickerfield-picker",scrollAction:"realign",align:{align:"t-b",axisLock:!0},autoShow:!1},triggers:{expand:{cls:"b-icon-picker",handler:"onTriggerClick"}},resize:"none",inputType:null});var Ey=wg;Ey.initClass(),Ey._$name="TextAreaPickerField";var Co=class extends dt{static get configurable(){return{project:null,stm:null,text:null,color:null,showZeroActionBadge:null,cls:"b-undo-controls b-toolbar",layoutStyle:{alignItems:"stretch",flexFlow:"row nowrap",overflow:"visible"},items:{undoBtn:{type:"button",icon:"b-icon-undo",tooltip:"L{UndoRedo.UndoLastAction}",onAction:"up.onUndo"},transactionsCombo:{type:"combo",valueField:"idx",editable:!1,store:{},emptyText:"L{UndoRedo.NoActions}",onAction:"up.onTransactionSelected",displayValueRenderer:"up.transactionsDisplayValueRenderer"},redoBtn:{type:"button",icon:"b-icon-redo",tooltip:"L{UndoRedo.RedoLastAction}",onAction:"up.onRedo"}},overflowable:!0}}afterConstruct(){this.updateUndoRedoControls()}updateStm(i){this.detachListeners("undoredo"),i==null||i.ion({name:"undoredo",recordingstop:"updateUndoRedoControls",restoringstop:"updateUndoRedoControls",queueReset:"updateUndoRedoControls",disabled:"updateUndoRedoControls",thisObj:this})}changeItems(i){const{undoBtn:e,redoBtn:t}=i;return this.color&&(e&&(e.color=this.color),t&&(t.color=this.color)),this.text&&(e&&(e.text="L{UndoRedo.Undo}"),t&&(t.text="L{UndoRedo.Redo}")),super.changeItems(i)}updateProject(i){this.stm=i.stm}fillUndoRedoCombo(){const{transactionsCombo:i}=this.widgetMap;i&&(i.items=[[0,"Original data"],...this.stm.queue.map((e,t)=>[t+1,e||`Transaction ${t+1}`])])}updateUndoRedoControls(){const{stm:i,showZeroActionBadge:e}=this,{undoBtn:t,redoBtn:r,transactionsCombo:n}=this.widgetMap;t.badge=i.position||(e?"0":""),r.badge=i.length-i.position||(e?"0":""),t.disabled=!i.canUndo,r.disabled=!i.canRedo,this.fillUndoRedoCombo(),n&&(n.disabled=n.store.count<=1)}transactionsDisplayValueRenderer(i,e){var t;const r=((t=this.stm)==null?void 0:t.position)||0;return`${r} undo actions / ${e.store.count-r-1} redo actions`}onUndo(){const{stm:i,project:e}=this;i.canUndo&&(i.revisionsEnabled?e.queue(()=>(i.undo(),e.commitAsync())):i.undo())}onRedo(){const{stm:i,project:e}=this;i.canRedo&&(i.revisionsEnabled?e.queue(()=>(i.redo(),e.commitAsync())):i.redo())}onTransactionSelected(i){const{stm:e}=this,t=e.position-i.value;t>0?e.canUndo&&e.undo(t):t<0&&e.canRedo&&e.redo(-t)}};v(Co,"$name","UndoRedoBase"),v(Co,"type","undoredobase"),Co.initClass(),Co._$name="UndoRedoBase";var yn="http://www.w3.org/2000/svg",QL={bar:1,outline:2,text:3},JL=(i,e)=>parseInt(i.order,10)-parseInt(e.order,10),Mx=(i,e)=>parseInt(i.dataset.order,10)-parseInt(e.dataset.order,10),eO=i=>i.field,tO=()=>!1,iO=/\s+/,Ps=class extends V{static get configurable(){return{data:null,values:null,series:null,topValue:null,element:{children:[{ns:yn,tag:"svg",reference:"svgElement",width:"100%",height:"100%",preserveAspectRatio:"none",children:[{ns:yn,tag:"g",reference:"scaledSvgGroup"},{ns:yn,tag:"g",reference:"unscaledSvgGroup"}]}]},omitZeroHeightBars:!1,singleTextForAllBars:!0,monitorResize:!0,getRectClass:void 0,getBarClass(i,e,t,r){return""},getOutlineClass(i,e){return""},getOutlineDOMConfig(i,e,t){return e},getBarTip(i,e,t,r){},getBarText(i,e,t){return""},getBarDOMConfig:null,getBarTextDOMConfig(i,e,t,r){return i},getBarTextTip(i,e,t,r){}}}construct(i){const e=this;super.construct(i),e.scheduleRefresh=e.createOnFrame(e.refresh,[],e,!0),e.refresh()}set tip(i){var e;const t=this;(e=t.tip)==null||e.destroy(),i?t._tip=Te.new({owner:t,forElement:t.svgElement,forSelector:"rect",internalListeners:{beforeShow:"up.onBeforeTipShow"}},i):t._tip=null}onElementResize(){super.onElementResize(...arguments);const i=this.svgElement.getBoundingClientRect();this.scaledSvgGroup.setAttribute("transform",`scale(${i.width} ${i.height})`)}onBeforeTipShow({source:i}){const e=parseInt(i.activeTarget.dataset.index);i.html=i.contentTemplate({histogram:this,index:e})}updateSeries(i){const e=this,t=e._series={};let r=0,n=0;for(const s in i)if(i[s]!==!1){const a=t[s]=X.merge({},i[s]);a.field||(a.field=s),a.type||(a.type="bar"),"order"in a||(a.order=QL[a.type]*10+r),"index"in a||(a.index=r),a.type==="bar"&&(a.index=n++),a.id=s,r++}!e.topValue&&e._data&&(e.topValue=e.getDataTopValue(e._data)),e.refreshSuspended||e.scheduleRefresh()}getDataTopValue(i,e){const t=Object.values(e||this.series).map(eO);let r=0,n;for(let s=0,{length:a}=i;s<a;s++){n=i[s];for(let o=0,{length:l}=t;o<l;o++)r=Math.max(r,n[t[o]])}return r}updateGetRectClass(i){de.deprecate("core","7.0.0","getRectClass is deprecated in favor of getBarClass"),this.getBarClass=i}updateData(i){const e=this;e._data=i,!e.topValue&&e._data&&e._series&&(e.topValue=e.getDataTopValue(i)),e.refreshSuspended||e.scheduleRefresh()}updateTopValue(i){const e=this;e._topValue=i,!i&&e._data&&(e._topValue=e.getDataTopValue(e._data)),e.refreshSuspended||e.scheduleRefresh()}scheduleRefresh(){}suspendRefresh(){this.refreshSuspended++}resumeRefresh(){this.refreshSuspended&&this.refreshSuspended--}refresh(i){const e=this,{series:t,_tip:r,topValue:n,singleTextForAllBars:s}=e,a=(i==null?void 0:i.args)||[],o=[],l=[];if(!t)return;const d=Object.values(t).sort(JL);if(s){for(const c of d){const u=e[`draw${O.capitalize(c.type)}`](c,...a);u&&(Array.isArray(u)?o.push.apply(o,u):o.push(u))}l.push(...e.drawText(null,...a))}else{for(const c of d){const u=e[`draw${O.capitalize(c.type)}`](c,...a);u&&(Array.isArray(u)?o.push.apply(o,u):o.push(u)),c.type==="bar"&&l.push(...e.drawText(c,...a))}l.sort(Mx)}o.sort(Mx),oe.sync({domConfig:{width:"100%",height:"100%",preserveAspectRatio:"none",dataset:{topValue:n},children:[{ns:yn,tag:"g",reference:"scaledSvgGroup",children:o},{ns:yn,tag:"g",reference:"unscaledSvgGroup",children:l}]},configEquality:tO,targetElement:e.svgElement}),r&&r.isVisible&&e.onBeforeTipShow({source:r})}drawBar(i,...e){const t=this,{topValue:r,data:n,omitZeroHeightBars:s,barStyle:a}=t,{field:o,order:l,stretch:d}=i,{length:c}=n,u=1/c,h=[],f=O.createId(i.id),g=i.index,m=d?1:void 0;let p;for(let y=0,b=0,{length:C}=n;y<C;y++,b+=p){const D=n[y];let S=D.rectConfig={ns:yn,tag:"rect",dataset:{}};const x=D[o],R=x?m||D.height||(x>r?r:x)/r:0,M=1-R,I=t.callback("getBarTip",t,[i,S,D,y,...e]);p=D.width||u,a?S.style=a:delete S.style,Object.assign(S.dataset,{index:y,order:l,series:f});const _={[`b-series-${f}`]:1,[`b-series-index-${g}`]:1},P=t.callback("getBarClass",t,[i,S,D,y,...e]);P&&P.split(iO).forEach(A=>_[A]=1),Object.assign(S,{x:b,y:M,width:p,height:R,class:_}),I?S.dataset.btip=I:delete S.dataset.btip,t.getBarDOMConfig&&(S=t.getBarDOMConfig(i,S,D,y,...e)),S&&(S.height||!s)&&h.push(S)}return h}changeGetBarDOMConfig(i){return i?this.bindCallback(i):null}drawOutline(i,...e){const t=this,{topValue:r,data:n}=t,{field:s,order:a,id:o}=i,l=1/n.length,d=["M 0,1"],c={ns:yn,tag:"path",dataset:{order:a,id:o}};let u,h="M",f="L";for(let g=0,m=0,{length:p}=n;g<p;g++){const y=1-n[g][s]/r;u=n[g].width||l,d.push(`${h} ${m},${y} ${f} ${m+=u},${y}`),h=f=""}return c.class=`b-series-${i.id} b-series-index-${i.index} `+t.callback("getOutlineClass",t,[i,n,...e]),c.d=d.join(" "),t.callback("getOutlineDOMConfig",t,[i,c,n,...e])||[]}drawText(i,...e){const t=this,{data:r}=t,n=1/r.length,s="100%",a=[];for(let o=0,l,d=0,{length:c}=r;o<c;o++,d+=l){l=r[o].width||n;const u=t.callback("getBarText",t,[r[o],o,i,...e]);if(u){const h=t.callback("getBarTextDOMConfig",t,[{ns:yn,tag:"text",className:"b-bar-legend",html:u,left:d,width:l,x:`${(d+l/2)*100}%`,y:r[o].y!==void 0?r[o].y:s,dataset:{index:o,series:i}},r[o],o,i,...e]);if(h){const f=t.callback("getBarTextTip",t,[h,r[o],o,i,...e]);f?h.dataset.btip=f:delete h.dataset.btip,a.push(h)}}}return a}};v(Ps,"type","histogram"),v(Ps,"$name","Histogram"),v(Ps,"properties",{refreshSuspended:0}),Ps.initClass(),Ps._$name="Histogram";var Ac="http://www.w3.org/2000/svg",So=class extends V{static get configurable(){return{scalePoints:null,scaleMaxPadding:.1,horizontal:!1,align:{value:!1,$config:{merge:"replace"}},element:{children:[{ns:Ac,tag:"svg",reference:"svgElement",width:"100%",height:"100%",preserveAspectRatio:"none",children:[{ns:Ac,tag:"g",reference:"scaledSvgGroup",children:[{ns:Ac,tag:"path",reference:"pathElement"}]},{ns:Ac,tag:"g",reference:"unscaledSvgGroup"}]}]},monitorResize:!0}}construct(i){super.construct(i),this.scheduleRefresh=this.createOnFrame(this.refresh,[],this,!0),this.refresh()}changeAlign(i){return i||(i=this.horizontal?"bottom":"right"),i}updateAlign(i,e){this.element.classList.remove(`b-align-${e}`),this.element.classList.add(`b-align-${i}`)}updateHorizontal(i,e){this.element.classList.remove(`b-scale-${e?"horizontal":"vertical"}`),this.element.classList.add(`b-scale-${i?"horizontal":"vertical"}`)}onElementResize(){super.onElementResize(...arguments),this.scheduleRefresh()}scheduleRefresh(){}refresh(){var i;if(!this.scalePoints)return;const e=this,{horizontal:t,width:r,height:n,align:s,scalePoints:a,scaleMaxPadding:o}=e,l=(i=a[a.length-1])==null?void 0:i.value,d=[],c=[],u=1/(l+o*l);e.scaledSvgGroup.setAttribute("transform",`scale(${t?r:1} ${t?1:n})`);for(const h of a){const f=!!h.text,g=u*h.value;if(f){const m={ns:Ac,tag:"text",className:"b-scale-tick-label",html:h.text,dataset:{tick:h.value}};t?(m.x=`${g*100}%`,m.y=s==="top"?"1.6em":n-12):(m.x=s==="left"?"12":`${r-12}`,m.y=`${(1-g)*100}%`),c.push(m)}t?s==="top"?d.push(`M${g},0 L${g},${f?10:5}`):d.push(`M${g},${n} L${g},${n-(f?10:5)}`):s==="left"?d.push(`M0,${1-g} L${f?10:5},${1-g}`):d.push(`M${r},${1-g} L${r-(f?10:5)},${1-g}`)}e.pathElement.setAttribute("d",d.join("")),oe.syncChildren({domConfig:{children:c}},e.unscaledSvgGroup)}};v(So,"$name","Scale"),v(So,"type","scale"),So.initClass(),So._$name="Scale";var rO=i=>{var e;return e=class extends(i||$){compose(){const{minified:t}=this;return{class:{"b-minified":t}}}get widgetClass(){}},v(e,"$name","Minifiable"),v(e,"configurable",{minifiable:!0,minified:null}),e},nO=[],sO=i=>i[0]!=="*",Ix=(i,e)=>{const t=i[e]||null;return delete i[e],t},aO=i=>i.responsiveRoot,_x={number:i=>({width:e})=>e<=i&&i},Px=i=>(delete i.once,{configs:i,callback:Ix(i,"callback"),when:Ix(i,"when")}),Ax=(i,e,...t)=>{const r=t.flatMap(a=>(a==null?void 0:a.once)||nO),n=e.mergeConfigs(...t),s=Px(n);s.once=r.length?Px(e.mergeConfigs(...r)):null;for(const a in n)a in i&&delete n[a];return s},oO=(i,e)=>{let t,r=Proxy.revocable(i,{get(a,o){return t&&(t[o]=!0),i[o]}}),n=Se.after(i,"onConfigChange",(a,{name:o})=>{t!=null&&t[o]&&e()}),s=i.ion({resize:()=>{e()}});return i.monitorResize=!0,{widget:i,get object(){return r==null?void 0:r.proxy},destroy(){r&&(r.revoke(),n(),s(),r=n=s=null)},reset(){t=Object.create(null)}}},lO=i=>{var e;return e=class extends(i||$).mixin(ve,to){get isResponsivePending(){return this.responsiveUpdateCount===0&&this.hasConfig("responsive")}get isResponsiveUpdating(){var t;return this._responsiveUpdating||((t=this.responsiveWidget)==null?void 0:t._responsiveUpdating)}updateResponsive(t){var r;const n=this,s=n.constructor,{initialConfig:a,responsiveDefaults:o}=n,l=Array.from(new Set(T.keys(t).concat(T.keys(o)))).filter(sO);let d=null,c,u,h,f;if(t){d={"*":Ax(a,s,o["*"],t["*"])};for(u of l)h=t[u],h!==null&&h!==!1&&(c=c||h&&"when"in h,d[u]=Ax(a,s,o["*"],o[u],t["*"],h),f=d[u].when,d[u].when=((r=_x[typeof f])==null?void 0:r.call(_x,f))||f)}n.$responsiveStates=d,n.$responsiveWhen=c,n.syncResponsiveWidget()}updateResponsiveState(t,r){var n,s,a,o;const l=this,{$responsiveStates:d}=l,c=++l.responsiveStateChanges===1,u=(n=l.element)==null?void 0:n.classList,h=d["*"],f=d[t]||h,g=c&&(f.once||h.once),m=c&&l.isStateful,p=l.responsiveWidget;let y=f.configs,b=g==null?void 0:g.configs,C;b&&(y=y?l.constructor.mergeConfigs(y,b):b),r&&(u==null||u.remove(`b-responsive-${r.toLowerCase()}`)),t&&(u==null||u.add(`b-responsive-${t.toLowerCase()}`)),m&&(b=l.loadStatefulData(),b&&(y=y?l.constructor.mergeConfigs(y,b):b),l.suspendStateful()),l._responsiveUpdating=!0;try{(s=l.trigger)==null||s.call(l,"beforeResponsiveStateChange",{state:t,oldState:r,target:p}),y&&l.setConfig(y);for(C of[f.callback,g==null?void 0:g.callback])(a=typeof C=="string"?l[C]:C)==null||a.call(l,{source:l,state:t,oldState:r,target:p,initial:c});(o=l.trigger)==null||o.call(l,"responsiveStateChange",{state:t,oldState:r,target:p})}finally{l._responsiveUpdating=!1,m&&l.resumeStateful()}}get responsiveTarget(){return this.responsiveWidget||this._responsiveTarget}updateResponsiveTarget(){this.syncResponsiveWidget()}updateResponsiveWidget(t){var r;const n=this,s=t&&n.responsiveUpdate;(r=n.$responsiveWrapper)==null||r.destroy(),n.$responsiveWrapper=t&&oO(t,s),s==null||s.now()}responsiveUpdate(){const t=this,{$responsiveStates:r,$responsiveWrapper:n}=t,s=n==null?void 0:n.widget;if(r&&n){let a=null,o=0,l=r,d,c;s&&s!==t&&!t.$responsiveWhen&&(s.getConfig("responsive"),l=s.$responsiveStates||l),n.reset();for(c in r)c!=="*"&&(d=l[c].when(n.object,K),d!=null&&d!==!1&&(!a||d<o)&&(a=c,o=d));++t.responsiveUpdateCount,t.responsiveState=a}}syncResponsiveWidget(){var t;const r=this;let n=null,s;if(!r.isDestroying&&r.responsive){if(s=r.responsiveTarget,!(n=s))n=!r.responsiveRoot&&((t=r.up)==null?void 0:t.call(r,aO))||r;else if(typeof s=="string"&&(n=s==="@"?r:s[0]==="@"?r[s.substring(1)]:r.up(s),!n))throw new Error(`No match for responsiveTarget="${s}"`);if(!n.isWidget)throw new Error(`${n.constructor.$$name} is not a widget and cannot be a responsiveTarget`)}return r.responsiveWidget=n,n}},v(e,"$name","Responsive"),v(e,"configurable",{responsive:{$config:{lazy:"paint"},value:null},responsiveDefaults:{small:{when:400},medium:{when:800},large:{when:()=>1/0},"*":{}},responsiveRoot:null,responsiveState:null,responsiveTarget:{value:null,$config:{lazy:"paint"}},responsiveWidget:{value:null,$config:{nullify:!0}}}),v(e,"delayable",{responsiveUpdate:"raf"}),v(e,"fenced",{syncResponsiveWidget:!0}),v(e,"prototypeProperties",{responsiveStateChanges:0,responsiveUpdateCount:0}),e},dO=i=>{var e;return e=class extends(i||$){changeCssVarPrefix(t){return T.assertString(t,"prefix"),t&&!t.endsWith("-")&&(t=t+"-"),t||""}changeCss(t){T.assertObject(t,"css");const r=this;if(!globalThis.Proxy)throw new Error("Proxy not supported");const n=new Proxy({},{get(s,a){var o;return(o=getComputedStyle(r.element||document.documentElement).getPropertyValue(`--${r.cssVarPrefix}${O.hyphenate(a)}`))==null?void 0:o.trim()},set(s,a,o){return(r.element||document.documentElement).style.setProperty(`--${r.cssVarPrefix}${O.hyphenate(a)}`,o),!0}});return t&&(r._element?T.assign(n,t):r.$initialCSS=t),n}updateElement(t,...r){super.updateElement(t,...r),this.$initialCSS&&T.assign(this.css,this.$initialCSS)}get widgetClass(){}},v(e,"$name","Styleable"),v(e,"configurable",{cssVarPrefix:"",css:{}}),e},Fx=class XS extends ${static get configurable(){return{element:null,colorPrefix:"b-sch-",tooltip:null,size:null}}doDestroy(){var e;(e=this.tooltip)==null||e.destroy(),super.doDestroy()}updateElement(e){j.on({element:e,delegate:".b-resource-image",error:"onImageErrorEvent",thisObj:this,capture:!0})}changeTooltip(e){return Te.new({forElement:this.element,forSelector:".b-resource-avatar",cls:"b-resource-avatar-tooltip"},e)}static get failedUrls(){return this._failedUrls||(this._failedUrls=new Set)}getResourceAvatar(e){if(Array.isArray(e))return e.map(h=>this.getResourceAvatar(h));const{initials:t,color:r,iconCls:n,imageUrl:s,defaultImageUrl:a,dataset:o={},resourceRecord:l,alt:d=O.encodeHtml(l==null?void 0:l.name)}=e,c=this.getImageConfig(t,r,s,a,o,d)||this.getIconConfig(n,o,d)||this.getResourceInitialsConfig(t,r,o,d),{size:u}=this;return Object.assign(c.style,{...u?{height:u,width:u}:void 0}),c}getImageConfig(e,t,r,n,s,a){if(r=XS.failedUrls.has(r)?n:r||n,r)return{tag:"img",draggable:"false",loading:"lazy",class:{"b-resource-avatar":1,"b-resource-image":1},style:{},alt:a,"aria-label":a,elementData:{defaultImageUrl:n,imageUrl:r,initials:e,color:t,dataset:s},src:r,dataset:s}}getIconConfig(e,t,r){if(e)return e&&{tag:"i",style:{},"aria-label":r,class:{"b-resource-avatar":1,"b-resource-icon":1,[e]:1},dataset:t}}getResourceInitialsConfig(e,t,r,n){const s=E.isNamedColor(t)&&t,a=!s&&t,{size:o}=this;return{tag:"div","aria-label":n,class:{"b-resource-avatar":1,"b-resource-initials":1,[`${this.colorPrefix}${s}`]:s},style:{backgroundColor:a||null,...o?{height:o,width:o}:void 0},text:e,dataset:r}}onImageErrorEvent({target:e}){if(!e.matches(".b-resource-avatar")||!e.isConnected)return;const{defaultImageUrl:t,initials:r,color:n,imageUrl:s,dataset:a}=e.elementData;if(t&&!e.src.endsWith(t.replace(/^[./]*/gm,"")))e.src=t;else{const{parentElement:o}=e,l=Array.from(o.childNodes).indexOf(e),d=this.getResourceInitialsConfig(r,n,a,e.alt),c=E.createElement(d);c.elementData=e.elementData,c.lastDomConfig=d,o.lastDomConfig&&(o.lastDomConfig.children[l]=d),o.replaceChild(c,e)}XS.failedUrls.add(s)}};v(Fx,"$name","AvatarRendering");var Eg=Fx;Eg._$name="AvatarRendering",window&&!window.bryntum&&(window.bryntum={});var Li=class wi{constructor(e){if(e){if(e.isLocation)return e;if(e.nodeType===Node.ELEMENT_NODE){const t=V.fromElement(e,"gridbase"),r=t&&e.closest(t.focusableSelector);if(r){const{dataset:n}=r.parentNode;this.init({grid:t,rowIndex:t.store.includes(n.id)?t.store.indexOf(n.id):n.index||-1,columnId:r.dataset.columnId}),this.initialTarget=e}}else this.init(e)}}init(e){var t,r;const n=this,s=n.grid=e.grid,{store:a,columns:o}=s,{visibleColumns:l}=o;if(e.target&&(n.actionTargets=[n._target=e.target]),e.record)n._id=e.record.id;else if("id"in e)n._id=e.id,e.id==null&&(n._rowIndex=-1);else{const d=isNaN(e.row)?isNaN(e.rowIndex)?NaN:e.rowIndex:e.row;n._rowIndex=Math.max(Math.min(Number(d),a.count-1),s.hideHeaders?0:-1),n._id=(t=a.records[n._rowIndex])==null?void 0:t.id}if("_rowIndex"in n||(n._rowIndex=a.indexOf(n.id)),n.isSpecialRow=(r=n.record)==null?void 0:r.isSpecialRow,"columnId"in e)n._column=o.getById(e.columnId);else if("field"in e)n._column=o.get(e.field);else{const d=isNaN(e.column)?isNaN(e.columnIndex)?NaN:e.columnIndex:e.column;isNaN(d)?n._column="column"in e?isNaN(e.column)?e.column:l[e.column]:l[0]:(n._columnIndex=Math.min(Number(d),l.length-1),n._column=l[n._columnIndex])}"_columnIndex"in n||(n._columnIndex=l.indexOf(n._column))}get isLocation(){return!0}equals(e,t=!1){const r=this;return(e==null?void 0:e.isLocation)&&e.grid===r.grid&&(t?r.id===e.id&&r._column===e._column:e.record===r.record&&e.column===r.column&&e.target===r.target)}get rowIndex(){const{_id:e}=this,{store:t}=this.grid;return t.includes(e)?t.indexOf(e):Math.min(this._rowIndex,t.count-1)}get visibleRowIndex(){const{rowManager:e}=this.grid,{rowIndex:t}=this;return t===-1?t:Math.max(Math.min(t,e.lastFullyVisibleTow.dataIndex),e.firstFullyVisibleTow.dataIndex)}get isSelectable(){return this.grid.store.includes(this._id)&&!this.isSpecialRow}get record(){var e;if((e=this._record)!=null&&e.isModel)return this._record;if(this._rowIndex>-1){const{store:t}=this.grid;return t.includes(this._id)?t.getById(this._id):t.records[this._rowIndex]}}get id(){return this._id}get column(){const{visibleColumns:e}=this.grid.columns;return e!=null&&e.includes(this._column)?this._column:e==null?void 0:e[this.columnIndex]}get columnId(){var e;return(e=this.column)==null?void 0:e.id}get columnIndex(){var e;return Math.min(this._columnIndex,((e=this.grid.columns.visibleColumns)==null?void 0:e.length)-1)}move(e){const t=this,{record:r,column:n,grid:s}=t,{store:a}=s,o=s.columns.visibleColumns,l=new wi;let d=a.includes(r)?a.indexOf(r):t.rowIndex,c=o.includes(n)?o.indexOf(n):t.columnIndex;const u=s.hideHeaders?0:-1,h=a.count-1,f=o.length-1,g=d===u,m=d===h,p=c===0,y=c===f;switch(e){case wi.PREV_CELL:p?g||(c=f,d--):c--;break;case wi.NEXT_CELL:y?m||(c=0,d++):c++;break;case wi.UP:g||d--;break;case wi.DOWN:m||(d===-1?d=s.rowManager.firstFullyVisibleRow.dataIndex:d++);break;case wi.FIRST_COLUMN:c=0;break;case wi.LAST_COLUMN:c=f;break;case wi.FIRST_CELL:d=u,c=0;break;case wi.LAST_CELL:d=h,c=f;break;case wi.PREV_PAGE:d=Math.max(u,d-Math.floor(s.scrollable.clientHeight/s.rowHeight));break;case wi.NEXT_PAGE:d=Math.min(h,d+Math.floor(s.scrollable.clientHeight/s.rowHeight));break}return l.init({grid:s,rowIndex:d,columnIndex:c}),l}get cell(){var e,t;const r=this,{grid:n,id:s,_cell:a}=r;if(a)return a;if(s==null)return(e=n.columns.getById(r.columnId))==null?void 0:e.element;{const{row:o}=r;if(o)return o.getCell(r.columnId)||o.getCell((t=n.columns.getAt(r.columnIndex))==null?void 0:t.id)}}get row(){return this.grid.getRowById(this.id)||this.grid.getRow(this.rowIndex)}get target(){const{cell:e,_target:t}=this,{focusableFinder:r}=this.grid;if(e)return t||(r.currentNode=this.grid.focusableFinderCell=e,r.nextNode()||e)}get isActionable(){const{cell:e,_target:t}=this,r=e&&E.getActiveElement(e);return!!(r&&e.compareDocumentPosition(r)&Node.DOCUMENT_POSITION_CONTAINED_BY||t&&t!==this.cell)}get isColumnHeader(){return this.cell&&this.rowIndex===-1}get isCell(){return this.cell&&this.record}};v(Li,"UP",1),v(Li,"NEXT_CELL",2),v(Li,"DOWN",3),v(Li,"PREV_CELL",4),v(Li,"FIRST_COLUMN",5),v(Li,"LAST_COLUMN",6),v(Li,"FIRST_CELL",7),v(Li,"LAST_CELL",8),v(Li,"PREV_PAGE",9),v(Li,"NEXT_PAGE",10);var De=Li;De._$name="GridLocation";var kx=i=>typeof i=="number"||(i==null?void 0:i.endsWith("px")),cO=/=>\s*['"]/,Fc=class yr extends he.mixin(Ve,qe){get type(){return this.constructor.type}construct(e,t,r,...n){const s=this,a=r==null?void 0:r.isRoot;if(a||(s.masterStore=t,t&&(s._grid=Array.isArray(t)?t[0].grid:t.grid),s.localizableProperties=Oe.mergeMethods.distinct(e.localizableProperties,["text","ariaLabel","cellAriaLabel"]),e.localeClass&&(s.localeClass=e.localeClass)),super.construct(e,t,r,...n),!a&&(s.isLeaf&&!("field"in s.data)&&(s.setData("field","_"+(s.type||"")+ ++yr.emptyCount),s.noFieldSpecified=!0),!s.width&&!s.flex&&!s.children&&s.setData({width:yr.defaultWidth,flex:null},null,!0),s.headerWidgets&&s.initHeaderWidgets(s.headerWidgets),s.isParent&&(s.meta.visibleChildren=new Set,s.collapsible&&s.grid.once("paint",()=>s.collapsible=!0)),s.renderer)){const o=s.renderer.toString();s.rendererReturningContent=o.includes("return ")||!!o.match(cO)}}shouldSync(e){return e.isColumn&&e.text===this.text&&(e.field===this.field||String(e.renderer)===String(this.renderer))&&(!e.previousSibling&&!this.previousSibling||e.previousSibling.shouldSync(this.previousSibling))}get isCollapsible(){var e;return((e=this.children)==null?void 0:e.length)>1&&this.collapsible}get collapsed(){return this.get("collapsed")}set collapsed(e){this.set("collapsed",e,!0),this.onCollapseChange(!e),this.grid.trigger("columnCollapseToggle",{column:this,collapsed:e})}onCellFocus(e){this.location=e,this._headerArialLabelSet||(this.updateHeaderAriaLabel(this.localizeProperty("ariaLabel")),this._headerArialLabelSet=!0),e.rowIndex!==-1&&this.updateCellAriaLabel(this.localizeProperty("cellAriaLabel"))}updateHeaderAriaLabel(e){E.setAttributes(this.element,{"aria-label":e})}updateCellAriaLabel(e){var t,r;!((t=this.location)!=null&&t.isSpecialRow)&&((r=this.location)!=null&&r.cell)&&(e!=null&&e.length||(e=this.location.column.text),E.setAttributes(this.location.cell,{"aria-label":e}))}doDestroy(){var e,t,r;(r=(t=(e=this.data)==null?void 0:e.editor)==null?void 0:t.destroy)==null||r.call(t),this.destroyHeaderWidgets(),super.doDestroy()}set headerWidgets(e){this.initHeaderWidgets(e),this.set("headerWidgets",e)}get headerWidgets(){return this.get("headerWidgets")}initHeaderWidgets(e){this.destroyHeaderWidgets();const t=this.headerWidgetMap={};for(const r of e){const n=V.create({owner:this,...r});n.element.classList.add("b-grid-headerwidget"),t[n.ref||n.id]=n}}destroyHeaderWidgets(){var e;for(const t of Object.values(this.headerWidgetMap||{}))(e=t.destroy)==null||e.call(t)}static generateAutoCls(){const e=[];for(let r=this;r!==yr;r=r.superclass)r.type&&r.type!==r.superclass.type&&e.push(`b-${r.type.toLowerCase()}-cell`);const t=e.join(" ");return(yr.autoClsMap||(yr.autoClsMap=new Map)).set(this,t),t}getCellClass(e){var t;const{record:r,column:n}=e,{cellCls:s,internalCellCls:a,grid:o,constructor:l,align:d,field:c}=n,u=r.fieldMap[c],h=((t=yr.autoClsMap)==null?void 0:t.get(l))||l.generateAutoCls(),f=e.cell.classList.contains("b-editing"),g={[o.cellCls]:o.cellCls,[h]:h,[s]:s,[a]:a,"b-cell-dirty":c&&!(u!=null&&u.calculated)&&r.isFieldModified(c)&&(n.compositeField||(u==null?void 0:u.persist)!==!1),[`b-grid-cell-align-${d}`]:d,"b-selected":o.selectionMode.cell&&o.isCellSelected(e),"b-focused":o.isFocused(e),"b-auto-height":n.autoHeight,"b-editing":f};return r.isSpecialRow&&g["b-checkbox-selection"]&&(g["b-checkbox-selection"]=!1),g}get locked(){return this.data.region==="locked"}set locked(e){this.region=e?"locked":"normal"}get region(){return this.parent.isRoot?this.get("region"):this.parent.region}set region(e){this.set("region",e)}get sortable(){const{sortable:e}=this.data;return!e||(this.noFieldSpecified||!this.field)&&!e.sortFn?!1:e}set sortable(e){this.set("sortable",e)}get groupable(){return!!(!(this.noFieldSpecified||!this.field)&&this.data.groupable)}set groupable(e){this.set("groupable",e)}get filterable(){return this.isLeaf&&this.data.filterable}get editor(){const e=this;let{editor:t}=e.data;if(t&&!t.isWidget){const r=e.grid.processCellEditor({editor:t,field:e.field});r?t=e.data.editor=r.editor:(typeof t=="string"&&(t={type:t}),t=e.data.editor=V.create(T.merge(e.defaultEditor,{owner:e.grid,label:O.encodeHtml(e.text)},t)))}return t}set editor(e){this.data.editor=e}get defaultEditor(){return{type:"textfield",name:this.field}}getFilterableValue(e){return this.getRawValue(e)}get owner(){return this._owner||this.subGrid}set owner(e){this._owner=e}get grid(){var e;return this._grid||((e=this.parent)==null?void 0:e.grid)}set subGrid(e){this._subGrid=e}get subGrid(){var e;return this._subGrid||((e=this.grid)==null?void 0:e.getSubGridFromColumn(this))}get subGridElement(){return this.subGrid.element}get element(){return this.grid.getHeaderElement(this)}get previousVisibleSibling(){const e=this.region;let t=this.previousSibling;for(;t&&(t.hidden||t.region!==e);)t=t.previousSibling;return t}get nextVisibleSibling(){const e=this.region;let t=this.nextSibling;for(;t&&(t.hidden||t.region!==e);)t=t.nextSibling;return t}get isLastInSubGrid(){return!this.nextVisibleSibling&&(this.parent.isRoot||this.parent.isLastInSubGrid)}get allowDrag(){return!this.parent.isRoot||!!(this.nextVisibleSibling||this.previousVisibleSibling)}get textWrapper(){return E.getChild(this.element,".b-grid-header-text")}get textElement(){return E.down(this.element,".b-grid-header-text-content")}get contentElement(){return E.down(this.element,".b-grid-header-children")}get isSorted(){return this.grid.store.sorters.some(e=>e.field===this.field)}get isFocusable(){var e;return this.isLeaf&&!((e=this.grid)!=null&&e.hideHeaders)}static get text(){return this.$meta.fields.defaults.text}get headerText(){return this.htmlEncodeHeaderText?O.encodeHtml(this.text):this.text}get isVisible(){return!this.hidden&&(!this.parent||this.parent.isVisible)}hide(e=!1,t=!1){const r=this,{parent:n}=r;r.hidden||(r.hidden=!0,n&&!n.isRoot&&!n.isTogglingAll&&!n.children.some(a=>a.hidden!==!0)&&!n.hidden&&(e=!0,n.hide()),r.isParent?r.children.forEach(s=>s.hide(!0,!0)):n.isRoot||n.meta.visibleChildren[t?"add":"delete"](r),e||r.stores.forEach(s=>s.trigger("columnHide",{column:r})))}show(e=!1){var t;const r=this,{parent:n}=r;r.hidden&&(r.hidden=!1,n!=null&&n.hidden&&n.show(),r.isParent&&((t=r.meta.visibleChildren)==null||t.forEach(s=>s.show(!0))),e||r.stores.forEach(s=>s.trigger("columnShow",{column:r})))}toggle(e){if(this.hidden&&e===void 0||e===!0)return this.show();if(!this.hidden&&e===void 0||e===!1)return this.hide()}toggleChildren(e=this.children,t=void 0){var r,n;const s=this;(r=s.grid.columns)==null||r.beginBatch(),s.isTogglingAll=!0,e.forEach(a=>a.toggle(t)),s.isTogglingAll=!1,(n=s.grid.columns)==null||n.endBatch()}onCollapseChange(e=void 0){var t,r;const n=this;if(n.collapseMode==="toggleAll")n.toggleChildren();else{const{firstChild:s}=n;s.flex!=null&&n.collapsed?(s.oldFlex=s.flex,s.width=s.element.offsetWidth):!n.collapsed&&s.oldFlex&&(s.flex=s.oldFlex,s.oldFlex=null),(t=n.grid.columns)==null||t.beginBatch(),n.isTogglingAll=!0,n.children.slice(1).forEach(a=>a.toggle(e)),n.isTogglingAll=!1,(r=n.grid.columns)==null||r.endBatch()}}set collapsible(e){const t=this;if(t.set("collapsible",e),t.isParent){const{headerWidgets:r=[]}=t;if(e)r.push({type:"button",ref:"collapseExpand",toggleable:!0,pressed:t.collapsed,icon:`b-icon-collapse-${t.grid.rtl?"right":"left"}`,pressedIcon:`b-icon-collapse-${t.grid.rtl?"left":"right"}`,cls:"b-grid-header-collapse-button b-transparent",onToggle:({pressed:n})=>t.collapsed=n});else{const n=r.findIndex(s=>s.ref==="collapseExpand");n>-1&&r.splice(n,1)}t.headerWidgets=r,t.collapsed&&t.onCollapseChange(!1)}}get collapsible(){return this.get("collapsible")}generateId(){var e,t,r;const{grid:n}=this,s=[(t=(e=this.field)==null?void 0:e.replace(/\./g,"-"))!=null?t:"col"];return n?(s.unshift((r=n.stateId)!=null?r:n.id),n.generatedIdIndex||(n.generatedIdIndex=0),s.push(n.generatedIdIndex+=1)):(yr.generatedIdIndex||(yr.generatedIdIndex=0),s.push(yr.generatedIdIndex+=1)),this.meta.generatedId=s.join("-")}get allIndex(){return this.masterStore.indexOf(this)}measureSize(e){var t;return E.measureSize(e,(t=this.subGrid)==null?void 0:t.element)}get calcMinWidth(){const{width:e,minWidth:t}=this.data;return kx(e)&&kx(t)?Math.max(parseInt(e)||0,parseInt(t)||0):e}get width(){return this.data.width}set width(e){const t={width:e};e&&"flex"in this.data&&(t.flex=null),this.set(t)}set flex(e){const t={flex:e};e&&"width"in this.data&&(t.width=null),this.set(t)}get flex(){return this.data.flex}calculateMinWidth(){const e=this,t=e.measureSize(e.width),r=e.measureSize(e.minWidth);let n=0;return e.children&&(n=e.children.reduce((s,a)=>s+a.calculateMinWidth(),0)),Math.max(t,r,n)}resizeToFitContent(e,t,r=!1){var n;const s=this,{grid:a,element:o,fitMode:l}=s,{rowManager:d}=a,{records:c}=a.$store,u=c.length;if(u<=0||s.fitMode==="none"||!s.fitMode||(n=s.data)!=null&&n.vue)return;const[h]=d.rows,{rowElement:f,cellElement:g}=a.beginGridMeasuring(),m=new De({grid:a,column:s,id:null});let p=0,y,b,C,D,S,x,R={length:0,record:null};if(g._domData={columnId:s.id,row:h,rowElement:f},m._cell=g,m.updatingSingleRow=!0,m.isMeasuring=!0,g.innerHTML="",a.resizeToFitIncludesHeader&&!a.hideHeaders){if(!a.$headerPadding){const I=globalThis.getComputedStyle(o);a.$headerPadding=parseInt(I.paddingLeft)}const M=o.querySelector(".b-grid-header-text-content");M.style.cssText="flex: none; width: auto",p=M.offsetWidth+a.$headerPadding*2+2,M.style.cssText=""}for(u>1e3?(y=Math.max(Math.min(d.topIndex+Math.round(d.rowCount/2)-500,u-1e3),0),b=y+1e3):(y=0,b=u),C=y;C<b;C++){if(D=c[C],S=s.getRawValue(D),l==="value")x=String(S).length;else if(m._record=D,m._id=D.id,m._rowIndex=C,h.renderCell(m),l==="textContent")x=g.textContent.length;else{const M=g.offsetWidth;M>p&&(p=M)}x>R.length&&(R={record:D,length:x,rowIndex:C})}return R.length>0&&(l==="value"||l==="textContent")&&(m._record=R.record,m._id=R.record.id,m._rowIndex=R.rowIndex,h.renderCell(m),p=Math.max(p,g.offsetWidth)),Array.isArray(e)&&([e,t]=e),p=Math.max(p,e||0),p=Math.min(p,t||1e6),r||a.endGridMeasuring(),s.width=s.maxWidth?p=Math.min(p,s.maxWidth):p,p}getState(){const e=this,{parentId:t}=e,r={id:e.id,hidden:e.hidden,region:e.region,locked:e.locked,text:e.text};return e.noFieldSpecified||(r.field=e.field),t!=null&&(r.parentId=t),e.children||(r[e.flex?"flex":"width"]=e.flex||e.width),e.isCollapsible&&(r.collapsed=e.collapsed),r}applyState(e){const t=this;t.beginBatch(),"locked"in e&&(t.locked=e.locked),"width"in e&&(t.width=e.width),"flex"in e&&(t.flex=e.flex),"width"in e&&t.flex?t.flex=void 0:"flex"in e&&t.width&&(t.width=void 0),"region"in e&&(t.region=e.region),"text"in e&&(t.text=e.text),t.endBatch(),"hidden"in e&&t.toggle(e.hidden!==!0),"collapsed"in e&&(t.collapsed=e.collapsed)}remove(){const{subGrid:e,grid:t}=this,r=e&&(t==null?void 0:t.focusedCell);(r==null?void 0:r.columnId)===this.id&&(t.owns(E.getActiveElement(t))?t.navigateRight():t._focusedCell=new De({grid:t,rowIndex:r.rowIndex,column:e.columns.getAdjacentVisibleLeafColumn(this.id,!0,!0)})),super.remove()}getRawValue(e){return e.getValue(this.field)}refreshCell(e){this.grid.rowManager.refreshCell(e,this.id)}refreshCells(){this.grid.refreshColumn(this)}refreshHeader(){this.grid.refreshHeader(this)}clearCell(e){e.innerHTML="",delete e._content}canEdit(e){if(e.isEditable){const t=e.isEditable(this.field);if(t!==void 0)return t}return!0}insertChild(e,t=null,r=!1){return e=Array.isArray(e)?e:[e],e.forEach(n=>{const{parent:s}=n;s!=null&&s.collapsed&&n===s.firstChild&&s.children.length>1&&s.children.filter(a=>!a.hidden).length===1&&(n.nextSibling.hidden=!1)}),this.sealed&&!this.inProcessChildren?null:super.insertChild(...arguments)}canFillValue(){return!0}getCurrentConfig(e){var t;const r=super.getCurrentConfig(e);return(t=this.sortable)!=null&&t.originalSortFn&&(r.sortable=this.sortable.originalSortFn),r.headerRenderer===this.internalHeaderRenderer&&delete r.headerRenderer,delete r.ariaLabel,delete r.cellAriaLabel,delete r.disableRendererWarning,r}get visible(){return this.isVisible}set visible(e){this.hidden=!e}get readOnly(){var e;const{field:t,grid:r}=this,n=!!this.get("readOnly");return t&&r&&((e=r.store.modelClass.getFieldDefinition(t))==null?void 0:e.calculated)||n}set readOnly(e){this.set("readOnly",e)}get renderer(){var e;return((e=this.data)==null?void 0:e.renderer)||this.defaultRenderer}set renderer(e){this.set("renderer",e)}};v(Fc,"$name","Column"),v(Fc,"type","column"),v(Fc,"fields",["type","text","field","renderer","afterRenderCell","width","flex","autoWidth","autoHeight",{name:"fitMode",defaultValue:"exact"},"readOnly",{name:"editor",defaultValue:{}},"cellEditor","finalizeCellEdit",{name:"managedCellEditing",defaultValue:!0},{name:"revertOnEscape",defaultValue:!0},{name:"invalidAction",defaultValue:"block"},{name:"sortable",defaultValue:!0,convert(i,e,t){if(!i)return!1;if(i===!0)return!0;const r={};return typeof i=="function"?(r.originalSortFn=i,r.sortFn=i.bind(t)):typeof i=="object"&&(Object.assign(r,i),r.fn&&(r.sortFn=r.fn,delete r.fn)),r}},{name:"searchable",defaultValue:!0},{name:"collapsible",defaultValue:!1},{name:"collapsed",defaultValue:!1},{name:"collapseMode"},{name:"filterable",defaultValue:!0,convert(i){if(!i)return!1;if(i===!0)return!0;const e={columnOwned:!0};return typeof i=="function"?e.filterFn=i:typeof i=="object"&&Object.assign(e,i),e}},{name:"sealed"},{name:"hideable",defaultValue:!0},{name:"draggable",defaultValue:!0},{name:"groupable",defaultValue:!0},{name:"resizable",defaultValue:!0},"groupRenderer","headerRenderer","tooltip","tooltipRenderer","cellCls","cls","icon","align",{name:"minWidth",defaultValue:60},"maxWidth",{name:"hidden",defaultValue:!1},{name:"locked"},{name:"region"},{name:"mergeCells",type:"boolean"},{name:"mergeable",type:"boolean",defaultValue:!0},"mergedRenderer",{name:"showColumnPicker",defaultValue:!0},{name:"enableHeaderContextMenu",defaultValue:!0},{name:"enableCellContextMenu",defaultValue:!0},"headerMenuItems","cellMenuItems","sum","summaries","summaryRenderer","responsiveLevels","tags","touchConfig","tree","filterType",{name:"htmlEncode",defaultValue:!0},{name:"htmlEncodeHeaderText",defaultValue:!0},{name:"autoSyncHtml",defaultValue:!1},{name:"alwaysClearCell",defaultValue:!0},{name:"headerWidgets"},{name:"instantUpdate",defaultValue:!1},{name:"repaintOnResize",defaultValue:!1},"editTargetSelector",{name:"exportable",defaultValue:!0},{name:"exportedType"},{name:"ariaLabel",defaultValue:"L{Column.columnLabel}"},{name:"cellAriaLabel",defaultValue:"L{cellLabel}"}]),v(Fc,"autoExposeFields",!1);var Ne=Fc;Ne.emptyCount=0,Ne.defaultWidth=100,Ne.exposeProperties(),Ne._$name="Column";var uO={boolean:{type:"check"},date:{type:"date"},integer:{type:"number",format:{maximumFractionDigits:0}},number:{type:"number"}},hO=[{field:"region"}],We=class Fd extends qe(ae){static get defaultConfig(){return{modelClass:Ne,tree:!0,autoAddField:!1,syncDataOnLoad:{threshold:1},sorters:hO,reapplySortersOnAdd:!0,useRawData:!1}}construct(e){const t=this,{grid:r}=e;r&&(r._columnStore=t,t.id=`${r.id}-columns`,r.ion({subGridCollapse:"clearSubGridCaches",subGridExpand:"clearSubGridCaches",thisObj:t})),super.construct(e),t.ion({change:t.onStoreChange,sort:()=>t.updateChainedStores(),thisObj:t,prio:1})}doDestroy(){const e=[];this.isChained||this.traverse(t=>e.push(t)),super.doDestroy(),this.isChained||e.forEach(t=>t.destroy())}getById(e){return super.getById(e)||this.idRegister[e]}forEach(e,t=this){this.traverseWhile((r,n)=>e.call(t,r,n),!0)}get totalFixedWidth(){let e=0;for(const t of this)t.hidden||(t.children?t.children.forEach(r=>e+=this.calculateFixedWidth(r)):e+=this.calculateFixedWidth(t));return e}get hasFlex(){return this.visibleColumns.some(e=>e.flex)}calculateFixedWidth(e){return e.flex?e.measureSize(Ne.defaultWidth):Math.max(e.measureSize(e.width),e.measureSize(e.minWidth))}get topColumns(){return this.isChained?this.masterStore.rootNode.children.filter(this.chainedFilterFn):this.rootNode.children}get visibleColumns(){const e=this;return e._visibleColumns||(e._visibleColumns=e.leaves.filter(t=>t.isVisible&&(!t.subGrid||!t.subGrid.collapsed)).sort(e.sorterFn)),e._visibleColumns}onStoreChange({action:e,changes:t}){e==="update"&&!("hidden"in t)||this.clearCaches()}clearSubGridCaches({subGrid:e}){e.columns.clearCaches(),this.clearCaches()}clearCaches(){var e;this._visibleColumns=null,(e=this.masterStore)==null||e.clearCaches()}onMasterDataChanged(e){super.onMasterDataChanged(e),(e.action!=="update"||"hidden"in e.changes||"region"in e.changes)&&this.clearCaches()}getAdjacentVisibleLeafColumn(e,t=!0,r=!1){const n=this.visibleColumns,s=e instanceof Ne?e:this.getById(e);let a=n.indexOf(s)+(t?1:-1);if(!n[a])if(r)a=t?0:n.length-1;else return null;return n[a]}get bottomColumns(){return this.leaves}get(e){return this.findRecord("field",e,!0)}lookupStateColumn(e){let t=this.getById(e.id);if(!t&&e.field){const r=this.query(n=>n.field===e.field);r.length===1&&(t=r[0])}return t}createRecord(e){var t,r;const{grid:n={}}=this,{store:s}=n,a=(r=(t=s==null?void 0:s.modelClass)==null?void 0:t.fieldMap)==null?void 0:r[e.field];let o=this.modelClass;if(a!=null&&a.column&&(e=X.merge({},a.column,e)),e.type&&(o=Fd.getColumnClass(e.type),!o))throw new Error(`Column type '${e.type}' not registered. Please make sure you have imported the column class.`);e.locked&&(e.region="locked",delete e.locked);const l=new o(e,this);if(l.data.region||(l.data.region=n.defaultRegion||"normal"),this.autoAddField&&!l.noFieldSpecified&&s&&!a){let d=l.field;l.constructor.fieldType&&(d={name:l.field,type:l.constructor.fieldType}),s.modelClass.addField(d)}return l}indexOf(e){if(e==null)return-1;const t=super.indexOf(e);return t>-1?t:this.records.findIndex(r=>r.field===e)}removeAll(e=!1){const t=this;return t.some(n=>n.isTimeAxisColumn)?t.remove(t.query(n=>!n.isTimeAxisColumn),e):super.removeAll(e)}get usesAutoHeight(){return this.some(e=>e.autoHeight)}get usesFlexAutoHeight(){return this.some(e=>e.autoHeight&&e.flex!=null)}resolveSyncNode(e){return e.id?super.resolveSyncNode(e):e.field?{id:e.field,node:this.allRecords.find(t=>t.field===e.field)}:e.type?{id:e.type,node:this.allRecords.find(t=>t.type===e.type)}:{id:null,node:null}}static registerColumnType(e,t=!1){e.simpleRenderer=t,(Fd.columnTypes||(Fd.columnTypes={}))[e.type]=e}static getColumnClass(e){return Fd.columnTypes&&Fd.columnTypes[e]}generateColumnForField(e,t){var r;typeof e=="string"&&this.grid&&(e=(r=this.grid.store)==null?void 0:r.modelClass.fieldMap[e]);let n=e.column||uO[e.type]||{};return typeof n=="string"&&(n={type:n}),n=Object.assign({text:e.text||O.separate(e.name),field:e.name},t,n),e.precision!=null&&(n.format.maximumFractionDigits=e.precision),e.columnType&&(n.type=e.columnType),this.createRecord(n)}},fO=(i,e)=>({update:({store:t,record:r,changes:n})=>{let s=!0;return("width"in n||"minWidth"in n||"maxWidth"in n||"flex"in n)&&(s=i.call(e,{store:t,record:r,changes:n})),s}});We.registerColumnType(Ne,!0),We._$name="ColumnStore";var bn=class extends Ne{get groupHeaderReserved(){return!0}construct(i,e){const t=this;i.renderer&&(de.deprecate("grid","7.0.0","Using deprecated `renderer` with ActionColumn, use `afterRenderCell` callback instead."),i.afterRenderCell=i.renderer,delete i.renderer),super.construct(i,e),!i.width&&!i.flex&&t.grid.ion({paint:"updateAutoWidth",thisObj:t}),t.disableIfGridReadOnly&&t.grid.element.classList.add("b-actioncolumn-readonly")}defaultRenderer({grid:i,column:e,record:t,isExport:r,callExternalRenderer:n=!0}){var s;const a=t&&"groupRowFor"in t.meta,{subGrid:o}=e,l={className:{"b-action-ct":1},children:(s=e.actions)==null?void 0:s.map((d,c)=>{var u,h;if("visible"in d&&(typeof d.visible=="function"&&d.visible({record:t})===!1||d.visible===!1)||a&&!d.showForGroup||!a&&d.showForGroup)return"";const{tooltip:f,renderer:g}=d,m=typeof f=="function"||(u=f==null?void 0:f.startsWith)!=null&&u.call(f,"up.")?o.callback(f,o,[{record:t}]):f||"";let p;if(g){const b=(h=o.callback(g,o,[{index:c,record:t,column:e,isExport:r,tooltip:m,action:d}]))!=null?h:"";typeof b=="string"?p={tag:"span",class:"b-action-item b-tool",dataset:{...Te.encodeConfig(m),index:c},html:b}:(p=b,(p.dataset||(p.dataset={})).index=c,(p.className||(p.className={}))["b-action-item"]=1,p.className[d.cls]=d.cls)}else p={tag:"button",dataset:{...Te.encodeConfig(m),index:c},className:{"b-tool":1,"b-action-item":1,[d.cls]:d.cls}};const y=d.ariaLabel||(typeof d.tooltip=="string"?d.tooltip:void 0);return y&&(p["aria-label"]=O.encodeHtml(y)),p})};return r?l.children.flatMap(d=>d.html||[]).join(","):l}onCellClick({grid:i,column:e,record:t,target:r}){var n;let s;if(e!==this||!(s=r.closest(".b-action-item[data-index]")))return;const a=s.dataset.index,o=(n=e.actions)==null?void 0:n[a],l=o==null?void 0:o.onClick;l&&this.callback(l,e,[{record:t,action:o,target:r,grid:i,column:e}])}updateAutoWidth(){const i=this,e=[],{actions:t}=i;if(!i.element)return;const r=i.actions=[];t==null||t.forEach(s=>{const a={...s};delete a.visible,a.showForGroup?(delete a.showForGroup,e.push(a)):r.push(a)}),e.length>r.length&&(i._actions=e);const n=E.createElement(i.defaultRenderer({column:i,record:new i.grid.store.modelClass,callExternalRenderer:!1})).outerHTML;i.width=E.measureText(n,i.element,!0,i.element.parentElement),i.actions=t}};v(bn,"type","action"),v(bn,"$name","ActionColumn"),v(bn,"fields",[{name:"actions",type:"array"},{name:"disableIfGridReadOnly",defaultValue:!1}]),v(bn,"defaults",{minWidth:30,filterable:!1,groupable:!1,sortable:!1,editor:!1,searchable:!1,htmlEncode:!1,resizable:!1,readOnly:!0}),We.registerColumnType(bn),bn.exposeProperties(),bn._$name="ActionColumn";var bi=class extends Ne{get defaultEditor(){const{format:i,name:e,max:t,min:r,step:n,largeStep:s,align:a}=this;return T.cleanupProperties({type:"numberfield",format:i,name:e,max:t,min:r,step:n,largeStep:s,textAlign:a})}get formatter(){const i=this,{format:e}=i;let t=i._formatter;return(!t||i._lastFormat!==e)&&(i._formatter=t=yg.getLocalizedFormatter(i._lastFormat=e)),t}formatValue(i,e=!0){return i!=null&&(i=this.formatter.format(i),this.unit&&e&&(i=`${i}${this.unit}`)),i!=null?i:""}defaultRenderer({value:i}){return this.formatValue(i)}updateLocalization(){super.updateLocalization(),this._formatter=null}};v(bi,"type","number"),v(bi,"fieldType","number"),v(bi,"fields",[{name:"format",defaultValue:""},"min","max","step","largeStep","unit","renderer"]),v(bi,"defaults",{filterType:"number",align:"end"}),We.registerColumnType(bi,!0),bi.exposeProperties(),bi._$name="NumberColumn";var Do=class extends bi{static get defaults(){return{function:"sum",includeParentInChangeSet:!1}}construct(i,e){const t=this;t.configuredAlign="align"in i,t.configuredEditor="editor"in i,super.construct(...arguments);const{grid:r}=e;t.function==="sum"&&(t.function="sumChildren"),r&&(t.store=r.store)}set store(i){const e=this,t={update:"onRecordUpdate",thisObj:e,prio:1e3},r=e._store;if(i!==r){r&&r.un(t),e._store=i;const{modelClass:n}=i,s=n.fieldMap[e.field];s&&s.type==="number"&&(e.configuredAlign||(e.align="end"),e.configuredEditor||(e.editor="number")),i.ion(t)}}canEdit(i){return i.isLeaf}get store(){return this._store}sumChildren(...i){let e=0;for(let t=0,{length:r}=i;t<r;t++)e+=parseFloat(i[t]||0,10);return e}avg(...i){let e=0;const{length:t}=i;for(let r=0;r<t;r++)e+=parseFloat(i[r]||0,10);return e/t}onRecordUpdate({record:i,changes:e}){const t=this,{rowManager:r}=t.grid;t.field in e&&i.isLeaf&&i.bubble(n=>{const s=r.getRowFor(n);if(s){const a=s.getCell(t.field);a&&s.renderCell(a)}},!0)}getRawValue(i){var e;let t;const r=this,{field:n}=r;if((e=i.children)!=null&&e.length){const s=r.function,a=typeof s=="string"&&typeof Math[s]=="function",{handler:o,thisObj:l}=a?{handler:Math[s],thisObj:Math}:r.resolveCallback(s);t=o.apply(l,i.children.map(d=>r.getRawValue(d))),r.includeParentInChangeSet?i.set(n,t,!0):i.setData(n,t)}else t=i.getValue(n);return t}canFillValue({record:i}){return i.isLeaf}};v(Do,"type","aggregate"),v(Do,"fields",["function","includeParentInChangeSet"]),We.registerColumnType(Do,!0),Do.exposeProperties(),Do._$name="AggregateColumn";var gO=({source:i,value:e,userAction:t})=>{t&&i.cellInfo.record.setValue(i.name,e)},Or=class extends Ne{static get defaults(){return{filterable:!1,sortable:!1,editor:!1,searchable:!1,fitMode:!1,alwaysClearCell:!1}}construct(i){i.disableRendererWarning||(i.renderer&&(i.afterRenderCell=i.renderer,delete i.renderer,de.deprecate("grid","7.0.0","Using deprecated `renderer` with WidgetColumn, use `afterRenderCell` callback instead.")),this.renderer&&this.renderer!==this.defaultRenderer&&(i.afterRenderCell=this.renderer,this.renderer=this.defaultRenderer,de.deprecate("grid","7.0.0","Using deprecated `renderer` with WidgetColumn, use `afterRenderCell` callback instead."))),super.construct(...arguments);const e=this,{grid:t}=e;t&&(t.widgetColumnCache?e.widgetColumnCache=t.widgetColumnCache:(e.widgetColumnCache=t.widgetColumnCache=new Map,t.ion({removeRows:"onRemoveGridRows",thisObj:this})))}onRemoveGridRows({rows:i}){i.forEach(({columnWidgets:e})=>{e&&(this.freeWidgets([...e.values()].flat()),e.clear())})}freeWidgets(i){i==null||i.forEach(e=>{var t;const{widgetColumnCache:r}=this,{column:n}=e.cellInfo,s=`${n.id}-${e.widgetColumnIndex}`;(t=n.onAfterWidgetDerendered)==null||t.call(n,e),e.cellInfo=e.__boundRecordId=e.owner=null,e.element.remove(),(r.get(s)||r.set(s,[]).get(s)).push(e)}),i.length=0}freeColumnWidgets(){const{id:i}=this;this.grid.rowManager.forEach(e=>{var t;const r=(t=e.columnWidgets)==null?void 0:t.get(i);r!=null&&r.length&&this.freeWidgets(r)})}hide(){this.freeColumnWidgets(),super.hide(...arguments)}getWidget(i,e){var t;const r=this,{grid:n,widgetColumnCache:s}=r,a=`${e.column.id}-${i.widgetColumnIndex}`,o=s.get(a)||s.set(a,[]).get(a);let l,{length:d}=o;return d?(l=o[--d],delete l.onBeforeDestroy,o.length=d,i.owner=n,V.reconfigure(l,i)):(r.onBeforeWidgetCreate(i,e),i.recomposeAsync=!1,i.owner=n,l=V.create(i),r.onAfterWidgetCreate(l,e),l.name&&l.ion({change:gO})),(t=r.onBeforeWidgetRender)==null||t.call(r,l),l}doDestroy(){this.grid.isDestroying?([...this.widgetColumnCache.values()].flat().forEach(i=>i.destroy()),this.widgetColumnCache.clear()):this.freeColumnWidgets(),super.doDestroy()}updateReadOnly(i){this.grid.rowManager.forEach(e=>{var t,r;(r=(t=e.columnWidgets)==null?void 0:t.get(this.id))==null||r.forEach(n=>{n.cellInfo.record.readOnly||(n.readOnly=i)})})}defaultRenderer(i){const e=this,{grid:t}=e,{cellElement:r,column:n,record:s,row:a,isExport:o}=i,{widgets:l}=n;if(!o&&l){const d=a.columnWidgets||(a.columnWidgets=new Map),c=d.get(e.id);[...r.childNodes].forEach(u=>{var h;(h=u.classList)!=null&&h.contains("b-widget")||u.remove()}),i.widgets=n.widgets.map((u,h)=>{var f,g;u.widgetColumnIndex=h;const m=(c==null?void 0:c[h])||e.getWidget(u,i);if(m.cellInfo=i,m.element.isConnected||(m.rendered?r.appendChild(m.element):m.render(r)),e.meta.isSelectionColumn||(m.readOnly=t.readOnly||s.readOnly||e.readOnly),((f=e.onBeforeWidgetSetValue)==null?void 0:f.call(e,m,i))!==!1){const p=u.valueProperty||"value"in m&&"value"||m.defaultBindProperty;if(p&&(!n.noFieldSpecified&&n.widgets.length===1||m.name)){const y=m.name?s.getValue(m.name):i.value;typeof y=="object"&&m.__boundRecordId!==s.id&&(m[`_${p}`]=NaN),m.suspendEvents(),m[p]=y,m.resumeEvents(),m.__boundRecordId=s.id}}return(g=e.onAfterWidgetSetValue)==null||g.call(e,m,i),m}),d.set(e.id,i.widgets)}if(!l)return""}onBeforeWidgetCreate(i,e){}onAfterWidgetCreate(i,e){}resizeToFitContent(){}};v(Or,"$name","WidgetColumn"),v(Or,"type","widget"),v(Or,"fields",["widgets","disableRendererWarning"]),We.registerColumnType(Or),Or.exposeProperties(),Or._$name="WidgetColumn";var As=class extends Or{construct(i,e){var t;super.construct(...arguments);const r=this;if(r.widgets[0].cls=r.checkCls,Object.assign(r,{externalHeaderRenderer:r.headerRenderer,externalOnBeforeWidgetSetValue:r.onBeforeWidgetSetValue,externalOnAfterWidgetSetValue:r.onAfterWidgetSetValue}),r.setData({onBeforeWidgetSetValue:r.internalOnBeforeWidgetSetValue,onAfterWidgetSetValue:r.internalOnAfterWidgetSetValue,headerRenderer:r.internalHeaderRenderer}),!r.meta.isSelectionColumn){const n=(t=r.grid)==null?void 0:t.store.modelClass;r.field?n&&typeof r[r.field]!="boolean"&&!n.fieldMap[r.field]&&!r.constructor.suppressNoModelFieldWarning&&(console.warn(r.$$name+" is configured with a field, but this is not part of your Model `fields` collection."),n.addField({name:r.field,type:"boolean"})):console.warn("CheckColumn MUST be configured with a field, otherwise the checked state will not be persistent. Widgets are recycled and reused")}}doDestroy(){var i;(i=this.headerCheckbox)==null||i.destroy(),super.doDestroy()}internalHeaderRenderer({headerElement:i,column:e}){let t;return i.classList.add("b-check-header"),e.showCheckAll?(i.classList.add("b-check-header-with-checkbox"),e.headerCheckbox?i.appendChild(e.headerCheckbox.element):e.headerCheckbox=new Ar({appendTo:i,owner:this.grid,ariaLabel:"L{Checkbox.toggleSelection}",internalListeners:{change:"onCheckAllChange",thisObj:e}})):t=e.headerText,t=e.externalHeaderRenderer?e.externalHeaderRenderer.call(this,...arguments):t,e.showCheckAll?void 0:t}updateCheckAllState(i){this.headerCheckbox&&(this.headerCheckbox.suspendEvents(),this.headerCheckbox.checked=i,this.headerCheckbox.resumeEvents())}onCheckAllChange({checked:i}){const e=this;if(e.field){const{store:t}=e.grid;t.beginBatch(),t.forEach(r=>e.updateRecord(r,e.field,i)),t.endBatch()}e.trigger("toggleAll",{checked:i})}defaultRenderer(i){var e;const{value:t,isExport:r,record:n}=i,s=super.defaultRenderer(i),a=(e=i.widgets)==null?void 0:e[0];return r?s!=null?s:t==null?"":t:(a.readOnly=this.readOnly||n.readOnly&&!this.meta.isSelectionColumn,t?a.input.setAttribute("checked",!0):a.input.removeAttribute("checked"),s)}onBeforeWidgetRender(i,e){i.ion({beforeChange:"onBeforeCheckboxChange",change:"onCheckboxChange",thisObj:this})}onAfterWidgetDerendered(i,e){i.un({beforeChange:"onBeforeCheckboxChange",change:"onCheckboxChange",thisObj:this})}internalOnBeforeWidgetSetValue(i,{cellElement:e}){var t;e.widget=i,i.record=i.cellInfo.record,(t=this.externalOnBeforeWidgetSetValue)==null||t.call(this,...arguments)}internalOnAfterWidgetSetValue(i){var e;(e=this.externalOnAfterWidgetSetValue)==null||e.call(this,...arguments)}onBeforeCheckboxChange({source:i,checked:e,userAction:t}){const r=this,{grid:n}=r,{record:s}=i.cellInfo;return t&&r.field&&(!n.features.cellEdit||n.features.cellEdit.disabled)||r.meta.isSelectionColumn&&!n.isSelectable(s)&&e?!1:r.trigger("beforeToggle",{record:s,checked:e})}onCheckboxChange({source:i,checked:e}){const t=this,{record:r}=i.cellInfo,{field:n}=t;n&&(t.updateRecord(r,n,e),e?t.updateCheckAllState(t.grid.store.every(s=>s[n],null,!0)):t.updateCheckAllState(!1)),t.trigger("toggle",{record:r,checked:e,checkbox:i})}updateRecord(i,e,t){i.setValue(e,t)}onCellKeyDown({event:i,cellElement:e,record:t}){if(i.key===" "){const{target:r}=i,n=e.widget;r.matches(".b-grid-cell")&&!(t!=null&&t.readOnly||n.disabled||n.readOnly)&&(n==null||n.toggle(),i.preventDefault(),i.handled=!0)}}getCurrentConfig(i){const e=super.getCurrentConfig(i);return delete e.onBeforeWidgetSetValue,delete e.onAfterWidgetSetValue,this.externalOnBeforeWidgetSetValue&&(e.onBeforeWidgetSetValue=this.externalOnBeforeWidgetSetValue),this.externalOnAfterWidgetSetValue&&(e.onAfterWidgetSetValue=this.externalOnAfterWidgetSetValue),e}};v(As,"$name","CheckColumn"),v(As,"type","check"),v(As,"fields",["checkCls","showCheckAll","onAfterWidgetSetValue","onBeforeWidgetSetValue","callOnFunctions","onBeforeToggle","onToggle","onToggleAll"]),v(As,"defaults",{align:"center",checkCls:null,showCheckAll:!1,sortable:!0,filterable:!0,minWidth:30,widgets:[{type:"checkbox",valueProperty:"checked"}]}),We.registerColumnType(As,!0),As._$name="CheckColumn";var $r=class extends Ne{construct(){var i;super.construct(...arguments);const e=this,{grid:t}=e;e.menu=new qi({owner:t,rootElement:t.rootElement,autoShow:!1,align:"t50-b50",anchor:!0,internalListeners:{hide(){e.picker.navigator.activeItem=null,delete e._editingRecord}},items:[Object.assign({type:e.colorEditorType,ref:"list",addNoColorItem:e.addNoColorItem,colorSelected({color:r}){var n;(n=e._editingRecord)==null||n.set(e.field,r),e.menu.hide()}},(i=e.colors)!=null&&i.length?{colors:e.colors}:{})]})}applyValue(i,e,t){if(!this.isConstructing){const{picker:r}=this;e==="colors"?r.colors=t:e==="addNoColorItem"&&(r.addNoColorItem=t)}super.applyValue(...arguments)}get picker(){return this.menu.widgetMap.list}defaultRenderer({value:i}){let e="b-empty",t=i;if(i){const r=this.picker.getColorClassName(i);r?(e=r,t=null):e=""}return{className:"b-color-cell-inner "+e,style:{backgroundColor:t},"data-btip":i}}onCellClick({grid:i,record:e,target:t}){if(t.classList.contains("b-color-cell-inner")&&!this.readOnly&&!i.readOnly&&!e.isSpecialRow&&!e.readOnly){const{picker:r,menu:n}=this,s=e.get(this.field);this._editingRecord=e,r.deselectAll(),r.select(s),r.refresh(),n.showBy(t)}}};v($r,"$name","ColorColumn"),v($r,"type","color"),v($r,"fields",[{name:"colorEditorType",defaultValue:"colorpicker"},"colors",{name:"addNoColorItem",defaultValue:!0}]),v($r,"defaults",{align:"center",editor:null}),We.registerColumnType($r),$r._$name="ColorColumn";var Cn=class extends Ne{static get defaults(){return{format:"L",step:1,minWidth:85,filterType:"date"}}construct(i={},e){if(super.construct(i,e),this.grid){const{field:t}=this,{store:r}=this.grid,{modelClass:n}=r,s=t&&n.getFieldDefinition(t);if(s&&!s.isDateDataField){console.warn(`DateColumn expects the \`type\` of the model field \`${t}\` to be of type \`date\``);const a=n.addField({...s.getCurrentConfig(),type:"date",["format"in i?"format":void 0]:this.format});r.forEach(o=>o.data[s.dataSource]=a.convert(o[t]))}}}defaultRenderer({value:i}){return i?this.formatValue(i):""}groupRenderer({cellElement:i,groupRowFor:e}){i.innerHTML=this.formatValue(e)}formatValue(i){return typeof i=="string"&&(i=w.parse(i,this.format||void 0)),w.format(i,this.format||void 0)}set format(i){const{editor:e}=this.data;this.set("format",i),e&&(e.format=i)}get format(){return this.get("format")}get defaultEditor(){const i=this,{min:e,max:t,step:r,format:n}=i;return{name:i.field,type:"date",calendarContainerCls:"b-grid-cell-editor-related",weekStartDay:i.grid.weekStartDay,format:n,max:t,min:e,step:r}}};v(Cn,"$name","DateColumn"),v(Cn,"type","date"),v(Cn,"fieldType","date"),v(Cn,"fields",["format","pickerFormat","step","min","max","renderer"]),We.registerColumnType(Cn,!0),Cn.exposeProperties(),Cn._$name="DateColumn";var Fs=class extends bi{constructor(){super(...arguments),v(this,"circleHeightPercentage",.75)}construct(){super.construct(...arguments),this.showCircle&&(de.deprecate("core","7.0.0","PercentColumn `showCircle` is deprecated, in favor of `mode`"),this.mode="circle")}defaultRenderer({value:i,record:e,isExport:t}){var r,n;i=i||0;const s=this,a=s.formatValue(i,e)||i;if(t)return a;if(s.mode==="number")return a+"%";const{min:o,max:l}=s;if(s.mode==="circle"){const d=Math.round(s.circleHeightPercentage*s.grid.rowHeight)+"px";return{tabIndex:0,role:"progressbar","aria-valuemin":o,"aria-valuemax":l,"aria-valuenow":i,"aria-label":(r=s.formatAriaLabel)==null?void 0:r.call(s,i,e),className:{"b-percentdone-circle":1,"b-empty":i===0,"b-full":i===100,"b-over":i>100},style:{height:d,width:d,"--grid-percent-circle-angle":`${i/100}turn`},dataset:{value:a}}}return{className:"b-percent-bar-outer",role:"progressbar","aria-valuemin":o,"aria-valuemax":l,"aria-valuenow":i,"aria-label":(n=s.formatAriaLabel)==null?void 0:n.call(s,i,e),tabIndex:0,children:[{tag:"div",className:{"b-percent-bar":1,"b-zero":i===0,"b-low":i<s.lowThreshold,"b-full":i===100,"b-over":i>100},style:{width:i+"%"},children:[s.showValue?{tag:"span",text:a+"%"}:void 0]}]}}resizeToFitContent(){if(this.mode==="number")return super.resizeToFitContent(...arguments)}get align(){const i=this.get("align"),{mode:e}=this;return i||(e==="number"?"end":e==="circle"?"center":"start")}set align(i){this.set("align",i)}get htmlEncode(){return this.mode==="number"}get internalCellCls(){return this.mode==="bar"?"b-percent-bar-cell":""}};v(Fs,"type","percent"),v(Fs,"fields",["showValue","lowThreshold","showCircle","mode"]),v(Fs,"defaults",{min:0,max:100,step:1,align:null,showCircle:!1,mode:"bar",showValue:!1,lowThreshold:0,htmlEncode:!1,searchable:!1,summaryRenderer:({sum:i})=>`${i}%`,fitMode:!1}),Fs.sum="average",We.registerColumnType(Fs,!0),Fs._$name="PercentColumn";var Sn=class extends bi{static get defaults(){return{min:0,max:5,emptyIcon:"b-icon b-icon-star",filledIcon:"b-icon b-icon-star",editable:!0,filterType:"number",searchable:!1,width:"11.2em",htmlEncode:!1,minWidth:"11.2em",editor:!1,fitMode:"value"}}defaultRenderer({value:i,isExport:e}){return e?"\u2605".repeat(i):{className:{"b-rating-cell-inner":1,"b-not-editable":!this.editable},children:H.populate(this.max,t=>{const r=t<i;return{tag:"i",className:{"b-rating-icon":!0,"b-filled":r,"b-empty":!r,[r?this.filledIcon:this.emptyIcon]:!0}}})}}onCellClick({grid:i,column:e,record:t,target:r,event:n}){if(r.classList.contains("b-rating-icon")&&!i.readOnly&&e.editable){let s=[].indexOf.call(r.parentNode.childNodes,r);r.classList.contains("b-filled")&&(n.metaKey||n.shiftKey)&&(s=s-1),t.getValue(e.field)===1&&s===0&&(s=-1),t.set(e.field,s+1)}}};v(Sn,"$name","RatingColumn"),v(Sn,"type","rating"),v(Sn,"fieldType","number"),v(Sn,"fields",["emptyIcon","filledIcon","editable"]),We.registerColumnType(Sn,!0),Sn.exposeProperties(),Sn._$name="RatingColumn";var kc=class extends Ne{static get defaults(){return{groupable:!1,sortable:!1,filterable:!1,searchable:!1,resizable:!1,draggable:!1,mergeable:!1,minWidth:50,width:50,align:"right",text:"#",editor:!1,readOnly:!0}}construct(i){super.construct(...arguments);const e=this,{grid:t}=e;e.internalCellCls="b-row-number-cell",e.externalHeaderRenderer=e.headerRenderer,e.setData("headerRenderer",e.internalHeaderRenderer),t&&(t.ion({bindStore:"bindStore",thisObj:e}),e.bindStore({store:t.store,initial:!0}),t.store.count&&!t.rendered&&t.ion({paint:"resizeToFitContent",thisObj:e,once:!0}))}get groupHeaderReserved(){return!0}bindStore({store:i,initial:e}){const t=this;t.detachListeners("grid"),i.ion({name:"grid",[`change${t.grid.asyncEventSuffix}`]:"onStoreChange",thisObj:t}),!e&&!t.resizeToFitContent()&&t.measureOnRender()}onStoreChange({action:i,isMove:e}){if(i==="dataset"||i==="add"||i==="remove"||i==="removeall"){if(i==="remove"&&e)return;const t=this.resizeToFitContent();i==="dataset"&&!t&&this.grid.store.count&&this.measureOnRender()}}measureOnRender(){this.grid.rowManager.ion({renderDone(){this.resizeToFitContent()},once:!0,thisObj:this})}defaultRenderer({record:i,grid:e}){var t,r,n;let s=i.isSpecialRow?"":e.store.indexOf(i,!0)+1;return(t=e.splitFrom)!=null&&t.isLockedRows&&(s+=(n=(r=e.splitFrom.features.lockRows)==null?void 0:r.numberOfLockedRows)!=null?n:0),s}resizeToFitContent(){var i;const e=this,t=(i=e.grid.features.lockRows)==null?void 0:i.subViews,r=(t==null?void 0:t[1])===e.grid?t[0]:e.grid,{element:n}=r,{store:s}=r,{count:a}=s;if(a&&!e.hidden){const o=n.querySelector(`.b-grid-cell[data-column-id="${e.id}"]`);if(o){const l=o.isConnected?parseInt(E.getStyleValue(o,"padding-left")):e._cachedCellPadding||0,d=E.measureText(a,o);return e.width=Math.max(e.minWidth,d+2*l),e._cachedCellPadding=l,!0}}return!1}set flex(i){}internalHeaderRenderer({headerElement:i,column:e}){var t;return i.classList.add("b-rownumber-header"),((t=e.externalHeaderRenderer)==null?void 0:t.call(this,...arguments))||e.headerText}};v(kc,"$name","RowNumberColumn"),v(kc,"type","rownumber"),We.registerColumnType(kc,!0),kc._$name="RowNumberColumn";var wo=class extends Ne{static get defaults(){return{htmlEncode:!1}}constructor(i,e){super(...arguments);const t=this;if(!t.template)throw new Error("TemplateColumn needs a template");if(typeof t.template!="function")throw new Error("TemplateColumn.template must be a function")}defaultRenderer(i){if(!i.record.isSpecialRow)return this.template({value:i.value,record:i.record,field:this.field})}};v(wo,"type","template"),v(wo,"fields",["template"]),We.registerColumnType(wo,!0),wo.exposeProperties(),wo._$name="TemplateColumn";var Dn=class extends Ne{static get defaults(){return{format:"LT",minWidth:140,filterType:"time"}}defaultRenderer({value:i}){return i?this.formatValue(i):""}groupRenderer({cellElement:i,groupRowFor:e}){i.innerHTML=this.formatValue(e)}formatValue(i){return typeof i=="string"&&(i=w.parse(i,this.format)),w.format(i,this.format)}set format(i){const{editor:e}=this;this.set("format",i),e&&(e.format=i)}get format(){return this.get("format")}get defaultEditor(){return{name:this.field,type:"time",format:this.format}}};v(Dn,"$name","TimeColumn"),v(Dn,"type","time"),v(Dn,"fieldType","date"),v(Dn,"fields",["format"]),We.registerColumnType(Dn,!0),Dn.exposeProperties(),Dn._$name="TimeColumn";var Eo=class extends Ne{static get defaults(){return{tree:!0,hideable:!1,minWidth:150}}static get fields(){return[{name:"expandIconCls",defaultValue:"b-icon b-icon-tree-expand"},{name:"collapseIconCls",defaultValue:"b-icon b-icon-tree-collapse"},{name:"collapsedFolderIconCls"},{name:"expandedFolderIconCls"},{name:"indentSize",defaultValue:1.7},{name:"leafIconCls",defaultValue:"b-icon b-icon-tree-leaf"},{name:"editTargetSelector",defaultValue:".b-tree-cell-value"},"renderer"]}construct(i,e,...t){super.construct(i,e,...t);const r=this;r.shouldHtmlEncode=r.htmlEncode,r.setData("htmlEncode",!1);const{renderer:n}=r;n&&(r.originalRenderer=n),r.renderer=r.treeRenderer.bind(r)}treeRenderer(i){var e,t,r,n,s,a,o;const l=this,{grid:d,cellElement:c,row:u,record:h,isExport:f}=i,g=h.instanceMeta(d.store),m=!h.isLeaf&&g.collapsed,p={className:"b-tree-cell-value"},y=[p],b={className:{"b-tree-cell-inner":1},tag:h.href?"a":"div",href:h.href,target:h.target,children:y};let C,D,{value:S}=i,x=l;const R=d.isTreeGrouped&&!h.isLeaf&&d.features.treeGroup.parentRenderer;if(l.originalRenderer||R){let I;R?(h.field&&(x=d.columns.get(h.field),x?S=x.isWidgetColumn?S:(t=(e=x===l?x.originalRenderer:x.renderer)==null?void 0:e.call(x,{...i,column:x,value:h.name,isTreeGroup:!0}))!=null?t:h.name:S=h.name),I=d.features.treeGroup.parentRenderer({...i,field:h.field,value:S,column:x,record:h.firstGroupChild,grid:d})):I=l.originalRenderer(i);const _=(r=d.hasFrameworkRenderer)==null?void 0:r.call(d,{cellContent:I,renderingColumn:x});C=typeof I=="object"&&!_,S=_?"":I===!1?c.innerHTML:I,i.rendererHtml=I}if(C||(S=String(S!=null?S:"")),f)return S;if(h.isLeaf)c.classList.add("b-tree-leaf-cell"),D=i.iconCls||h.iconCls||l.leafIconCls;else{const I=!h.isExpanded(d.store),_=I?l.expandIconCls:l.collapseIconCls,P=I?l.collapsedFolderIconCls:l.expandedFolderIconCls;c.classList.add("b-tree-parent-cell"),u.toggleCls("b-loading-children",!!g.isLoadingChildren),y.unshift({tag:"i",className:{"b-tree-expander":1,[_]:1,"b-empty-parent":!g.isLoadingChildren&&h.children!==!0&&!((n=h.children)!=null&&n.length)}}),h.meta.hasIcon=D=i.iconCls||h.iconCls||P}if(D&&y.splice(y.length-1,0,{tag:"i",className:{"b-tree-icon":1,[D]:1}}),u.isRow&&!h.isLeaf)if(u.setAttribute("aria-expanded",!m),m)u.removeAttribute("aria-owns");else for(const I in d.subGrids){const _=u.elements[I];E.setAttributes(_,{"aria-owns":(s=h.children)!=null&&s.length?(a=h.children)==null?void 0:a.map(P=>`${d.id}-${I}-${P.id}`).join(" "):null})}Array.isArray(S)?p.children=S:C?Object.assign(p,S):x!=null&&x.shouldHtmlEncode||!S.includes("<")?(b.className["b-text-value"]=1,p.text=S):p.html=S;let M=h.childLevel*l.indentSize;return h.isLeaf?M+=(o=h.parent)!=null&&o.meta.hasIcon?2.2:D?.5:.4:M+=D?-.15:0,b.style=`padding-inline-start:${M}em`,b}getCurrentConfig(i){const e=super.getCurrentConfig(i);return e.renderer=this.originalRenderer,e}};v(Eo,"$name","TreeColumn"),v(Eo,"type","tree"),We.registerColumnType(Eo,!0),Eo.exposeProperties(),Eo._$name="TreeColumn";var Ji=class extends he{static get fields(){return[{name:"iconCls",internal:!0},{name:"cls",internal:!0},{name:"rowHeight",internal:!0},{name:"href",internal:!0},{name:"target",internal:!0},{name:"fixed",type:"boolean",internal:!0}]}};Ji.exposeProperties(),Ji._$name="GridRowModel";var xo=class extends ee.mixin(Q0){get clipboardRecords(){return this.clipboardData||[]}cellsToString(i){var e;const t=this;let r=0,n=0,s="";i.sort((a,o)=>a.rowIndex===o.rowIndex?a.columnIndex-o.columnIndex:a.rowIndex-o.rowIndex);for(const a of i){const{record:o,_column:l,rowIndex:d,columnIndex:c}=a;d>r?(s.length>0&&(s+=`
`.repeat(d-r)),r=d,n=c):c>n&&(s.length>0&&(s+="	".repeat(c-n)),n=c);let u=(e=l==null?void 0:l.toClipboardString)==null?void 0:e.call(l,a);u===void 0&&(u=o.getValue(l.field),u instanceof Date?u=w.format(u,t.dateFormat):u=u==null?void 0:u.toString()),t.toCopyString&&(u=t.toCopyString({currentValue:u,column:l,record:o})),u=u==null?void 0:u.replace(/[\n\t]/," "),s+=u||t.emptyValueChar}return s}setFromStringData(i,e=!1,t=this.client.store,r){var n,s;const a=this,{client:o}=a,{columns:l,_shiftSelectRange:d}=o,c=new Set,u=a.stringAs2dArray(i),h=(n=o.selectedCells)==null?void 0:n[0],f=[],g=[];if(!e&&(d!=null&&d.some(m=>m.equals(h)))){const m=a.cellSelectorsAs2dArray(d);if((m==null?void 0:m.length)%u.length===0&&m.columnCount%u.columnCount===0)for(let p=0;p<m.length;p+=u.length)for(let y=0;y<m.columnCount;y+=u.columnCount)f.push(m[p][y])}f.length||f.push(h);for(const m of f)for(let p=0;p<u.length;p++){const y=u[p],b=e?new t.modelClass:t.getAt(m.rowIndex+p);if(b&&!b.readOnly){for(let C=0;C<y.length;C++){const D=r?null:l.visibleColumns[e?C:m.columnIndex+C],S=(D==null?void 0:D.field)||(r==null?void 0:r[C]);let x=y[C];if(S&&x&&!(D!=null&&D.readOnly)){if(x===a.emptyValueChar&&(x=null),D!=null&&D.fromClipboardString&&(x=D.fromClipboardString({string:x,record:b})),a.toPasteValue&&(x=a.toPasteValue({currentValue:x,record:b,column:D,field:S})),typeof x=="string"&&((s=b.getFieldDefinition(S))!=null&&s.isDateDataField)){const R=w.parse(x,a.dateFormat);isNaN(R.getTime())||(x=R)}b.set(S,x,!1,!1,!1,!0),D&&g.push(o.normalizeCellContext({column:D,record:b}))}}c.add(b)}}return{modifiedRecords:[...c],targetCells:g}}cellSelectorsAs2dArray(i){const e=[];let t=null,r;for(const n of i)n.id!==t&&(t=n.id,r=[],e.push(r)),r.push(n);return e.columnCount=e[0].length,e.some(n=>n.length!==e.columnCount)?!1:e}stringAs2dArray(i){const e=[],t=i.split(/\r\n|(?!\r\n)[\n-\r\x85\u2028\u2029]/).filter(r=>r.length);for(const r of t){const n=r.split("	");if(e.columnCount&&n.length!==e.columnCount)return!1;e.columnCount=n.length,e.push(n)}return e}};v(xo,"configurable",{copyOnly:null,keyMap:{"Ctrl+C":"copy","Ctrl+X":"cut","Ctrl+V":"paste"},useNativeClipboard:!1,toCopyString:null,toPasteValue:null,emptyValueChar:" ",dateFormat:"lll",generateNewName(i,e,t=this.client.store){const{nameField:r}=this;let n=i.getValue(r),s=2;(e==null?void 0:e.meta.generatedName)===n&&(n=e.meta.originalName);let a=n;for(;t.findRecord(r,a);)a=`${n} - ${s}`,s+=1;return i.meta.generatedName=a,i.meta.originalName=n,a}}),xo._$name="CopyPasteBase";var Lc=new Map,Ro=new Map,xg="Grid",Rg={Grid:"GridBase",Scheduler:"SchedulerBase",SchedulerPro:"SchedulerProBase",Gantt:"GanttBase"},mO=/\$\d+$/,z=class{static registerFeature(i,e=!1,t=null,r=null){r=O.uncapitalize(r||Object.prototype.hasOwnProperty.call(i,"$name")&&i.$$name||i.name),r=r.replace(mO,""),Array.isArray(t)||(t=[t||xg]),t.forEach(n=>{const s=Rg[n]||n,a=Lc.get(s)||new Map,o=Ro.get(s)||new Map;a.set(r,i),o.set(i,e),Lc.set(s,a),Ro.set(s,o)})}static getTypeNameFeatures(i=xg){const e=Rg[i]||i,t=Lc.get(e),r={};return t&&t.forEach((n,s)=>r[s]=n),r}static getTypeNameDefaultFeatures(i=xg){const e=Rg[i]||i,t=Lc.get(e),r=Ro.get(e),n={};return t&&r&&t.forEach((s,a)=>{r.get(s)&&(n[a]=s)}),n}static getInstanceFeatures(i){return i.$meta.names.reduce((e,t)=>Object.assign(e,this.getTypeNameFeatures(t)),{})}static getInstanceDefaultFeatures(i){return i.$meta.names.reduce((e,t)=>Object.entries(this.getTypeNameFeatures(t)).reduce((r,[n,s])=>(this.isDefaultFeatureForTypeName(s,t)?r[n]=s:delete r[n],r),e),{})}static isDefaultFeatureForTypeName(i,e=xg){const t=Rg[e]||e,r=Ro.get(t);return r&&r.get(i)||!1}static isDefaultFeatureForInstance(i,e){const t=e.$meta.names.slice().reverse();let r=null;for(let n=0,s=t.length;n<s&&r===null;++n){const a=Ro.get(t[n]);a&&a.has(i)&&(r=a.get(i))}return r||!1}static reset(){Lc.clear(),Ro.clear()}},pO={cut:1,copy:1,paste:1},Oc=class extends xo{constructor(){super(...arguments),v(this,"entityName","cell")}static get pluginConfig(){return{chain:["populateCellMenu","afterSelectionModeChange"]}}afterConstruct(){super.afterConstruct(),this.afterSelectionModeChange()}afterSelectionModeChange(){const i=this;i.client.selectionMode.cell?i._disabledBySelectionMode&&(i.disabled=!1,delete i._disabledBySelectionMode):i.disabled=!0}set copyOnly(i){this._copyOnly=i}get copyOnly(){var i;return this._copyOnly==null?!((i=this.client.features.cellEdit)!=null&&i.enabled):!!this._copyOnly}get canCopy(){var i;const{client:e}=this;return!!(!this.disabled&&e.selectedCells.length&&(!e._selectedRows.length||(i=e.features.rowCopyPaste)!=null&&i.disabled||e.focusedCell&&e.isCellSelected(e.focusedCell)))}get canCutPaste(){var i;return this.canCopy&&!this.copyOnly&&!((i=this.client.features.cellEdit)!=null&&i.isEditing)&&!this.client.readOnly}isActionAvailable({actionName:i}){if(pO[i])return globalThis.getSelection().toString().length===0&&this.canCopy&&(i==="copy"||this.canCutPaste)}async cut(){await this.copy(!0)}async copy(i=!1){typeof i!="boolean"&&(i=!1);const e=this,{selectedCells:t}=e.client,r=i?t.filter(n=>{var s;return!((s=n.record)!=null&&s.readOnly)}):t;if(r){if(i?!e.canCutPaste:!e.canCopy)return;const n=e.cellsToString(r);if(await e.writeToClipboard(n,i,{cells:r})===void 0)return;if(i===!0)for(const s of r){const{column:a,record:o}=s;if(!a.readOnly){let l=null;a.fromClipboardString&&(l=a.fromClipboardString({string:l,record:o})),s.record.set(s.column.field,l)}}e.client.trigger("copy",{cells:r,copiedDataString:n,isCut:i,entityName:e.entityName})}}async beforeCopy({data:i,isCut:e,cells:t}){return await this.client.trigger("beforeCopy",{cells:t,data:i,isCut:e,entityName:this.entityName})}async paste(){var i;const e=this,{client:t,entityName:r}=e,n=t.selectedCells[0];if(!e.canCutPaste||!n)return;const s=(i=await e.readFromClipboard({},!0))==null?void 0:i.data;if(!s)return;const{modifiedRecords:a,targetCells:o}=e.setFromStringData(s);t.selectedCells.length===1&&o.length>1&&t.selectCellRange(o[0],o[o.length-1]),t.trigger("paste",{clipboardData:s,targetCell:n,modifiedRecords:[...a],entityName:r})}async beforePaste({data:i}){return await this.client.trigger("beforePaste",{clipboardData:i,targetCell:this.client.selectedCell,entityName:this.entityName})}populateCellMenu({record:i,items:e}){const t=this;t.canCopy&&(e.cutCell={text:t.cutText,localeClass:t,icon:"b-icon b-icon-cut",weight:115,disabled:i.readOnly||!t.canCutPaste,onItem:()=>t.cut()},e.pasteCell={text:t.pasteText,localeClass:t,icon:"b-icon b-icon-paste",weight:120,disabled:i.readOnly||!t.canCutPaste||t.hasClipboardData()===!1,onItem:()=>t.paste()},e.copyCell={text:t.copyText,localeClass:t,cls:"b-separator",icon:"b-icon b-icon-copy",weight:110,onItem:()=>t.copy()})}};v(Oc,"$name","CellCopyPaste"),v(Oc,"configurable",{useNativeClipboard:!de.isTestEnv,copyText:"L{copy}",cutText:"L{cut}",pasteText:"L{paste}",allowedDataSources:"none"}),Oc._$name="CellCopyPaste",z.registerFeature(Oc);var Lx={finishAndEditNextRow:1,finishAndEditPrevRow:1,finishEditing:1,cancelEditing:1,finishAndEditNextCell:1,finishAndEditPrevCell:1},vO={...Lx,startEditing:1,finishAllSelected:1},$c=class extends ve(ee){static get defaultConfig(){return{autoSelect:!0,blurAction:"complete",continueEditingOnCellClick:!0,addNewAtEnd:null,addToCurrentParent:!1,autoEdit:null,editNextOnEnterPress:!0,editorClass:yi,triggerEvent:"celldblclick",touchEditDelay:300,focusCellAnimationDuration:!1,multiEdit:!0,keyMap:{Enter:["startEditing","finishAndEditNextRow"],"Ctrl+Enter":["finishAllSelected","finishEditing"],"Shift+Enter":"finishAndEditPrevRow","Alt+Enter":"finishEditing",F2:["startEditing","finishEditing"],Escape:"cancelEditing",Tab:{handler:"finishAndEditNextCell",weight:100},"Shift+Tab":{handler:"finishAndEditPrevCell",weight:100}},ignoreCSSSelector:"button,.b-icon,.b-fa,svg",validateTapOut:null}}static get pluginConfig(){return{assign:["startEditing","finishEditing","cancelEditing"],before:["onElementKeyDown","onElementPointerUp"],chain:["onElementClick","bindStore"]}}construct(i,e){super.construct(i,e);const t=this,r={renderRows:"onGridRefreshed",cellClick:"onCellClick",thisObj:t};t.grid=i,t.triggerEvent!=="cellclick"&&(r[t.triggerEvent]="onTriggerEditEvent"),t.autoEdit&&!("editNextOnEnterPress"in e)&&(t.editNextOnEnterPress=!1),i.ion(r),i.rowManager.ion({changeTotalHeight:"onGridRefreshed",thisObj:t}),t.bindStore(i.store)}bindStore(i){this.detachListeners("store"),i.ion({name:"store",update:"onStoreUpdate",remove:"onStoreRemove",beforeSort:"onStoreBeforeSort",thisObj:this})}async confirm(i){let e=!0;return this.editorContext&&(ii.owner=this.editorContext.editor.inputField,i.rootElement=this.grid.rootElement,e=await ii.confirm(i),ii.owner=null),e===ii.yesButton}doDestroy(){this.grid.columns.allRecords.forEach(i=>{var e;(e=i._cellEditor)==null||e.destroy()}),super.doDestroy()}doDisable(i){i&&!this.isConfiguring&&this.cancelEditing(!0),super.doDisable(i)}set disabled(i){super.disabled=i}get disabled(){const{grid:i}=this;return!!(super.disabled||i.disabled||i.readOnly)}get isEditing(){return!!this.editorContext}get activeRecord(){var i;return((i=this.editorContext)==null?void 0:i.record)||null}getEditorForCell({id:i,cell:e,column:t,columnId:r,editor:n}){const s=this,{grid:a,editorClass:o}=s;let l=t.cellEditor,d=0;t.editTargetSelector&&(d=e.querySelector(t.editTargetSelector).offsetLeft),n.autoSelect=s.autoSelect,l!=null&&l.isEditor||(l=t.data.cellEditor=o.create(o.mergeConfigs({type:o.type,constrainTo:null,cls:"b-cell-editor",inputField:n,blurAction:"none",invalidAction:t.invalidAction,completeKey:!1,cancelKey:!1,owner:a,align:{align:"t0-t0",offset:[d,0]},internalListeners:s.getEditorListeners(t.managedCellEditing),onInternalKeyDown:s.onEditorKeydown.bind(s),allowMouseEvents:n.allowMouseEvents,instantUpdate:t.instantUpdate},l))),l.minHeight=a.rowHeight,l.inputField!==n&&(l.remove(l.items[0]),l.add(n));const c=l.inputField,u=t.instantUpdate&&!n.cellEditValueSetter;return l.instantUpdate=u,l.align.offset[0]=d,u&&(T.wrapProperty(n,"value",null,h=>{const{editorContext:f}=s;if(f){const{record:g}=f,{field:m}=f.column;f.editor.isValid&&!T.isEqual(g.getValue(m),h)&&(!(c!=null&&c.isDateField)||c!=null&&c._isPickerInput?(g.setValue(m,h),c._outstandingUpdate=!1):c._outstandingUpdate=!0)}}),n.cellEditValueSetter=!0),Object.assign(l.element.dataset,{rowId:i,columnId:r,field:t.field}),l.inputField.revertOnEscape=t.revertOnEscape,s.editor=l}getEditorListeners(i){return{focusOut:i?"onEditorFocusOut":null,focusIn:"onEditorFocusIn",start:"onEditorStart",beforeComplete:"onEditorBeforeComplete",complete:"onEditorComplete",beforeCan