const PIBOARD_EXCLUDE_STATUS = Vue.component('piboard-exclude-status', {
	template:
	`
<div>
	<div class="overlay" style="display: block;"></div>
	<div class="ui-dialog set-pop excludeitems" style="top: 0 !important;">		
		<div v-if="loader.show" class="loader">
			<div>
				<div class="loaderinteg"></div>
				<div v-html="loader.text"></div>
			</div>
		</div>
		
		<div class="DFCB editBoardSettingPopHead mb-0">
			<h2 class="editBoardSettingPopTitle">Exclude Items from Queries <span class="infotxt tooltip ml-10" style="top: -1px;"><span class="hovtooltipB wid3 lft">Select statuses and issue types of child items to exclude when fetching features from Azure DevOps. Excluded items will not be retrieved during adding the new filter, resync, or via webhook.</span></span></h2>
			<i title="Close" class="c-point ti-close" @click="onClickCloseButton"></i>
		</div>
		<div class="cntr" style=" min-height: 200px;">			
			<div class="rec lblm">
				<label>Item Types</label>
				<div class="selectcont">
				<vz-select
					:options="itemTypesOptions"
					:multiple="true"
					value-type="value"
					v-model="selectedItemTypes"
				/>
				</div>
			</div>
			<div class="rec lblm">
				<label>Statuses</label>
				<div class="selectcont">
				<vz-select
					:options="statusesOptions"
					:multiple="true"
					value-type="value"
					v-model="selectedStatuses"
					:groups-enabled="true"
				/>
				</div>
			</div>
			
			<div class="rec btn">
				<a class="button FR" @click="onClickSaveButton"> Save </a>
			</div>			
		</div>

	</div>		
</div>
	`,
	props: ["board","projects"],

	data() {
		return {
			loader: {
				show: false,
				text: ""
			},
			
			itemTypesOptions: [],
			statusesOptions: [],
			
			selectedItemTypes: [],
			selectedStatuses: []
		}
	},
	created() {
		this.initialiseSettings();
	},
	mounted() {
		
	},
	methods: {
		
		/////////////////////////////////////////////////////////////////
		////////////     LOGIC
		initialiseSettings: function () {
			
			let categoryToName = {"ToDo":"To Do","InProgress":"In Progress","Done":"Done","Misc":"Misc"};
			
			var statusGroups = [];
			var statusGroupsMap = {};

			var dupCheck = {};
			
			var itemTypesOptions = [];
			
			if (this.board.session.excludeTfsStatuses) {
				this.selectedStatuses = this.board.session.excludeTfsStatuses;
			}
			
			if (this.board.session.excludeTfsItemTypes) {
				this.selectedItemTypes = this.board.session.excludeTfsItemTypes;
			}
			
			if (!_.isEmpty(this.projects)) {
				
				_.each(this.projects, project => {

					if (project.itemTypesJSON) {
						let itemTypes = JSON.parse(project.itemTypesJSON);
						itemTypes = itemTypes.value;
						
						_.each(itemTypes, itemType=> {
							if (!dupCheck[itemType.name]) {
								dupCheck[itemType.name] = true;
								
								itemTypesOptions.push({id:itemType.name, title:itemType.name});
							}
						});
					}
					_.each(project.workFlow.statuses, st => {
						if (!dupCheck[st.category + st.title]) {
							dupCheck[st.category + st.title] = true;
							var group = statusGroupsMap[st.category];
							if (!group) {
								group = { title: categoryToName[st.category], items: [] };
								statusGroups.push(group);
								statusGroupsMap[st.category] = group;
							}
							group.items.push({ title: st.title, id: st.title });
						}
					});
				});
			}
			this.statusesOptions = statusGroups;
			this.itemTypesOptions = itemTypesOptions;
		},
		/////////////////////////////////////////////////////////////////
		////////////     API CALLS
		saveSettings: function () {
			
			let _this = this;
			let data = {};
			
			_this.loader.show = true;
			
			data.sessionId = _this.board.session.id;
			
			data.excludeTfsStatuses = this.selectedStatuses;
			data.excludeTfsItemTypes = this.selectedItemTypes;
						 
			 axios.post("/pi/setExcludeItemInSession",data )
			 .then(resonse=> {
				 _this.loader.show = false;
				 if (resonse.data.success) {
					 let session = resonse.data.session;
					 
					 _this.board.session.excludeTfsStatuses = session.excludeTfsStatuses;
					 _this.board.session.excludeTfsItemTypes = session.excludeTfsItemTypes;
					 
					 _this.$emit("saved");
				 }
			 })
			 .catch(error=> {
				 _this.loader.show = false;
			 });
			 
		},
		/////////////////////////////////////////////////////////////////
		////////////     EVENTS
		onClickCloseButton: function () {
			this.$emit("close");
		},
		onClickSaveButton: function () {
			this.saveSettings();
		}
	}
});





