const PI_USER_PICKER = Vue.component('pi-user-picker', {
	template: 
	/*html*/`
	<div class="p-rel usrpkr">
		<div class="addrm" v-if="showButton">
			<a href="javascript:void(0);" class="ti-plus ico adatch" @click="onClickAddButton">{{addButtonToolTip}}</a>
		</div>
		<template v-if="!_.isEmpty(selectedTitle)">
			<div class="slctdn c-point" @click="onClickAddButton">
				<div class="DAJ mr-30">{{selectedTitle}}</div>
			</div>
		</template>
		<template v-else>
			<div v-if="renderSelect" class="selectcont" @click="onClickDropdown">
    	    	<input type="text" v-model="searchQuery" :disabled="disabled" :placeholder="placeholder" lazy @input="onChangeSearchQuery" @focus="onTextFocusIn" @blur="onTextFocusOut" @click="onClickDropdown" @keyup="onSearchItemsKeyUp" />
			</div>
    	    <input v-else type="text" v-model="searchQuery" :disabled="disabled" :placeholder="placeholder" lazy @input="onChangeSearchQuery" @focus="onTextFocusIn" @blur="onTextFocusOut" @click="onClickDropdown" @keyup="onSearchItemsKeyUp" />
			
			<!-- <a href="javascript:void(0);" v-if="!multiple" class="ti-close rmvico p-abs" title="Remove User" @click="clearSelectedUser"></a>-->
		</template>
		<div v-if="showList && !createUser.show" v-click-outside="onClickOutsideOfList" class="drop_boxa addusr dd-list" :class="!multiple? 'single-select': ''">
			<div v-if="loader.show" class="loader" style="z-index:9999"><div><div class="loaderinteg"></div></div></div>
			<div class="head"> Select User
			    <a href="javascript:void(0);" @click="onClickDoneButton" class="button-w FR">Done</a>
			</div>
			<input v-if="showButton || !_.isEmpty(selectedTitle)" type="text" v-model="searchQuery" :placeholder="placeholder" lazy @input="onChangeSearchQuery" @keyup="onSearchItemsKeyUp" />
			<ul v-if="listMode == 0" @scroll="onScrollUsersList">			
				<li class="in" v-for="(user,index) in pageableUsers" @click="Object.keys(user).length == 0? clearSelectedUser() : onSelectSuggestion(user,index)" :style="{backgroundColor:(selectedSearchItem == index ? '#8f8f8f' : '')}">
					<div v-if="Object.keys(user).length == 0" class="rec" :class="[_.isEmpty(value)? 'highlight-selected': '']">
						<label class="pcut">
							<!--<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>-->
							Unassigned
						</label>					
					</div>
					<div v-else class="rec" :class="[multiple? 'custom-checkbox': '', user.selected? 'highlight-selected': '']">
						<input v-if="multiple" type="checkbox" :checked="user.selected" @click="onSelectSuggestion(user,index)"/>
						<label v-if="user.userType == 'ALM_JIRA'" class="pcut" :title="user.email && user.isValid?user.email+' (ALM Jira User)': null">
							<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>
							{{user.fullName}} 
						</label>
						<label v-else-if="user.userType == 'ALM_TFS'" class="pcut" :title="user.email && user.isValid?user.email+' (ALM Azure/TFS User)': null">
							<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>
							{{user.fullName}} 
						</label>
						<label v-else-if="user.userType == 'NON_FUNCTIONAL'"class="pcut" :title="user.email && user.isValid?user.email+' (Non-Functional User)': null">
							<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>
							{{user.fullName}} 
						</label>
						<label v-else class="pcut" :title="user.email && user.isValid?user.email: null">
							<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>
							{{user.fullName}} 
						</label>
					</div>
				</li>
			</ul>
			<ul v-if="listMode == 1">
				<li class="in" v-for="(user,index) in searchUsers" @click="Object.keys(user).length == 0? clearSelectedUser() : onSelectSuggestion(user,index)" :style="{backgroundColor:(selectedSearchItem == index ? '#8f8f8f' : '')}">					
					<div v-if="Object.keys(user).length == 0" class="rec" :class="[_.isEmpty(value)? 'highlight-selected': '']">
						<label class="pcut">
							<!--<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>-->
							Unassigned
						</label>					
					</div>				
					<div v-else class="rec" :class="[multiple? 'custom-checkbox': '', user.selected? 'highlight-selected': '']">
						<input v-if="multiple" type="checkbox" :checked="user.selected" @click="onSelectSuggestion(user,index)"/>
						<label class="pcut" :title="user.email && user.isValid?user.email: null">
							<div class="pic p-abs" v-html="userImageOrInitialHtml(user, true)"> </div>
							{{user.fullName}}
						</label>
					</div>
				</li>
				<li v-if="searchUsers.length == 0 && searchCompleted" class="nofound">No user found</li>
			</ul>
			<div class="btm-btn crt">
				<a v-if="almName!=''" href="javascript:void(0);" @click="onSelectSearchFromALM" class="crtev ti-search a">Search From {{almName}}</a>
				<a v-if="showCreateUser" href="javascript:void(0);" @click="onSelectCreateNew"     class="crtev ti-plus" :class="[almName? 'b': '']">  Create</a>
			</div>
		</div>
		
		<div v-if="createUser.show" >
			<div class="overlay" style="display: block;"></div>
			<div class="ui-dialog minipop dpls adevnt crtus">
				<div class="head">Create Non-Kendis User <a @click="onClickCancelUser" href="javascript:void(0);" class="rmv-ico ti-close" title="Close"></a> </div>
				<div class="cntr prow">
					<div v-if="createUser.loader.show" class="loader" style="z-index:9999"><div><div class="loaderinteg"></div></div></div>
			
					<div class="rec lblm half a">
						<label>First Name</label>
						<input maxlength="255" type="text" v-model="createUser.firstName" :class="createUser.errors.firstName?'red':''" />
					</div>
					<div class="rec lblm half b">
						<label>Last Name</label>
						<input maxlength="255" type="text" v-model="createUser.lastName" :class="createUser.errors.lastName?'red':''" />
					</div>
					<div class="rec lblm">
						<label>Email</label>
						<input type="text" v-model="createUser.email" :class="createUser.errors.email?'red':''" />
					</div>
					
				</div>
				<div class="rec btn">
					<button @click="onClickSaveUser" class="FR">Save</button>
					<a href="javascript:void(0);" @click="onClickCancelUser" class="cncl FR">Cancel</a>
				</div>
			</div>
		</div>

		<div v-if="searchAlm.show" >
			<div class="overlay" style="display: block;"></div>
			<div class="ui-dialog minipop dpls adevnt srch single-select">
				<div class="head">Search From {{almName}} <a @click="onAlmPopupCancel" href="javascript:void(0);" class="rmv-ico ti-close" title="Close"></a> </div>
				<div class="cntr prow findUsr">
					<div v-if="searchAlm.loader.show" class="loader" style="z-index:9999">
						<div>
							<div class="loaderinteg"></div>
							<span class="LOADER-TITLE" v-html="searchAlm.loader.text"></span>
						</div>
					</div>			
					<div class="rec lblm">
						<label>Search User</label>
						<input type="text" v-model="searchAlm.searchQuery" @keyup="onSearchItemsKeyUpALM" />
						<a href="javascript:void(0);" @click="onAlmPopupClickSearch" class="ti-search srch ico p-abs" title="Search"></a>						
					</div>
					<ul> 
						<li class="rec" v-for="(user, userIndex) in searchAlm.users" @click="onAlmPopupSelectUser(user)">
							<label>{{user.fullName}}</label>
						</li>
						<li v-if="searchAlm.users.length == 0 && searchAlm.searchCompleted" class="nofound">No user found</li>
					</ul>
				</div>
			</div>
		</div>
		
	</div>
	`,
	props:  {
		value: {
			type: null,
			default: () => { return []}
		},
		almAccount: {
			type: Object,
			default: () => { return {}}
		},
		multiple: {
			type: Boolean,
			default: () => { return false }
		},
		clearOnSelect: {
			type: Boolean,
			default: () => { return false }
		},
		showButton: {
			type: Boolean,
			default: () => { return false }
		},
        disabled: {
            type: Boolean,
	        default: () => { return false }
        },		
        allowUnassigned: {
            type: Boolean,
	        default: () => { return false }
        },		
		placeholder: {
			type: String,
			default: () => { return "Select" }
		},
		addButtonToolTip: {
			type: String,
			default: () => { return "Add User" }
		},
		renderSelect: {
			type: Boolean,
			default: () => { return false }
		},
		existingValues: {
			type: Array,
			default: () => { return [] }
		},
		showCreateUser: {
			type: Boolean,
			default: () => { return true }
		},
		usersMeta: {
			type: Boolean,
			default: () => { return false }
		},
		selectedTitle: {
			type: String,
			default: () => { return "" }
		}
	},
	watch: {
		'value': {
			handler(val, oldVal) {
				this.selectValue(val);
			},
			deep: true,
			immediate: true
		},
	},
	mixins: [userMixin, popupAutoDirectionMixin],
	model: {
			event: `select`
	},
	data() {
		return {
			loader: {
				show : false,
				text : "",
			},
			
			showList : false,
			selectedSearchItem : -1,
			
			suggestions : [],
			createUser: {
				loader: {
					show: false,
					text: "",
				},
				show : false,
				firstName : "",
				lastName : "",
				email : "",
				errors: {
					firstName : false,
					lastName : false,
					email : false,
				}
			},
			searchAlm: {
				loader: {
					show: false,
					text: "",
				},
				show: false,
				users: [],
				searchCompleted : false,
				searchQuery: ""
			},
			selectedUserMap: {},
			selectedUsers: [],

			listMode : 0,
			pageableUsers: [],
			pageIndex: 0,
			pageSize : 30,
			pageLoading: false,

			searchQuery: "",
			searchUsers: [],
			searchCompleted: false,
		}
	},
	mounted() {
	},
	created() {
		this.$options.almUsers = [];
		this.selectValue(this.value);
	},
	computed: {
		almName: function () {
			if (this.almAccount.type == "tfs") {
				return "AzureDevOps";
			}
			else if (this.almAccount.type == "jira") {
				return "JIRA";
			}
			else {
				return "";
			}
		},
		userSelected: function () {
			return function (user){
				return this.selectedUserMap[user.id] ? true : false;
			};
		},
	},
	methods: {
		//////////////////////////////////////////////////////
		////////////////    LOGIC
		validateItemForSearch: function (item, search) {
			if (item.tfs) {
				return true;
			}else {
				var match1 = item.fullName.toLowerCase().indexOf(search);
				var match2 = 0;
				if (match1 == -1) {
					match2 = item.email.toLowerCase().indexOf(search);
				}
				return match1 != -1 && match2 != -1;
			}
		},
		validateCreateUser: function () {
			this.createUser.errors.firstName = _.isEmpty(this.createUser.firstName);
			this.createUser.errors.lastName  = _.isEmpty(this.createUser.lastName);
			
			const re = /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
			
			this.createUser.errors.email = !re.test(String(this.createUser.email).toLowerCase());
			if (this.createUser.errors.firstName || this.createUser.errors.lastName || this.createUser.errors.email) {
				return false;
			}
			return true;
		},
		capitalizeFirstCharacter: function (text) {
			return text.replace(/\w\S*/g, function (txt) {
				return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
			});
		},
		selectValue: function (value) {
			
			var _this = this;
			
			_this.selectedUsers = [];
			_this.selectedUserMap = {};
			
			if (!_.isEmpty(value)) {
				
				if (_this.multiple) {
					let names = [];
					_.each(value, user=>{
						_this.selectedUsers.push(user);
						_this.selectedUserMap[user.id] = true;
						names.push(user.fullName);
					});
					_this.searchQuery = names.join(', ');
				}else {
					_this.searchQuery = value.fullName;
					_this.selectedUsers.push(value);
					_this.selectedUserMap[value.id] = true;
				}

			}else {
				if(_this.allowUnassigned && !_this.multiple) {
					this.searchQuery = "Unassigned"
				}
				else {
					this.searchQuery = "";
				}
			}
		},
		//////////////////////////////////////////////////////
		////////////////    API CALLS
		createUserCall: function (user) {

			/*if (_.isEmpty(user.email)) {
				this.getUserDetailJira(user);
				return;
			}*/

			var _this = this;
			_this.loader.text = "";
			_this.loader.show = true;
			
			axios.post('/pijourney/createUser', user)
				.then(response => {
					_this.loader.show = false;
					if (!_.isEmpty(response.data) ) {
						if (response.data.success) {
							_this.listMode = 0;
							_this.$emit('user-added',response.data.user);
							_this.onSelectSuggestion(response.data.user);
							_this.onClickCancelUser();
                            _this.pageableUsers.push(response.data.user);

							showTopMessage("User has been added.","success");

						}else if(response.data.reason == "AlreadyExist") {
							showTopMessage("User already exist.","warning");
						}
					}
				})
				.catch(error => {
					_this.loader.show = false;
					showTopMessage("Unable to perform request.","warning");
				});
		},
		getUserDetailJira: function (user) {
			var _this = this;
			_this.loader.text = "";
			_this.loader.show = true;
			var userId = user.userName;
			axios.get('/pijourney/getJiraUser/'+ _this.almAccount.id +"/"+userId)
				.then(response => {
					_this.loader.show = false;
					if (!_.isEmpty(response.data) ) {
						if (response.data.success) {
							var result = JSON.parse(response.data.content);
							user.email = result.emailAddress;
							_this.createUserCall(user);
						}
					}
				})
				.catch(error => {
					_this.loader.show = false;
					showTopMessage("Unable to perform request.","warning");
				});
		},
		fetchMoreUsersFromMeta: function () {
			var _this = this;
			if(_this.$parent.$options._users){
				_this.afterfetchMoreUsersOnScroll({data : { users : _.slice(_this.$parent.$options._users, _this.pageIndex, _this.pageIndex + _this.pageSize)}});
			}else{
				var waitForRootOptions = setInterval(function() {
					if (typeof _this.$root.$options !="undefined" && typeof _this.$root.$options._users !="undefined") {
						clearInterval(waitForRootOptions);
						_this.$parent.$options._users = _.cloneDeep(_this.$root.$options._users);
						_this.afterfetchMoreUsersOnScroll({data : { users : _.slice(_this.$parent.$options._users, _this.pageIndex, _this.pageIndex + _this.pageSize)}});
					}
				}, 50);
			}
		},
		fetchMoreUsersOnScroll: function () {

			var _this = this;
			_this.pageLoading = true;

			if (_this.pageableUsers && _this.pageableUsers.length == 0) {
				_this.loader.show = true;
			}
			if(_this.usersMeta === true){
				_this.fetchMoreUsersFromMeta();
			}else{
				axios.get('/pijourney/getUsers/'+ _this.pageIndex +"/"+ _this.pageSize)
					.then(response => {
						_this.afterfetchMoreUsersOnScroll(response);
					})
					.catch(error => {
						_this.pageLoading = false;
						_this.loader.show = false;
					});
			}
			
			
		},
		afterfetchMoreUsersOnScroll: function (response) {
			let _this = this;
			_this.pageLoading = false;
			_this.loader.show = false;
			
			if(_this.allowUnassigned && !_this.multiple && _.isEmpty(_this.pageableUsers)) {
				_this.pageableUsers.push({})
			}
			if (!_.isEmpty(response.data) ) {
				var users = response.data.users;
				const fetchedUserIds = new Set(users.map(user => user.id));

				// Add existing users that are not in the fetched data
				_this.existingValues.forEach(existingUser => {
					if (!fetchedUserIds.has(existingUser.id)) {
						existingUser.selected = _this.selectedUserMap[existingUser.id] ? true : false;
						_this.pageableUsers.unshift(existingUser);
					}
				});

				users.forEach(user => {
					user.selected = _this.selectedUserMap[user.id] ? true : false;
					_this.pageableUsers.push(user);
				});
			}
		},
		searchUsersCall: function () {

			var _this = this;
			var body = { query: this.searchQuery };

			if (_this.$options.cancelTokenSource && _this.$options.cancelTokenSource != undefined) {
				cancelTokenSource.cancel();
			}
			_this.$options.cancelTokenSource = axios.CancelToken.source();
			axios.post('/pijourney/searchUsers', body, { cancelToken: _this.$options.cancelTokenSource.token })
				.then(response => {
					_this.$options.cancelTokenSource = undefined;
					if (!_.isEmpty(response.data)) {
						var users = response.data.users;
						_.each(users, user=>{
							user.selected = _this.selectedUserMap[user.id] ? true : false;
						});
						_this.searchUsers = users;
					}
					if(_this.allowUnassigned && !_this.multiple) {
						var unassigned = "unassigned";
						if(unassigned.includes(_this.searchQuery.toLowerCase())) {
							_this.searchUsers.unshift({});
						}
					}
					_this.searchCompleted = true;
					
				})
				.catch(error => {
					_this.$options.cancelTokenSource = undefined;
				});
		},
		searchUserFromAlm: function (searchQuery) {

			var _this = this;

			if (_this.almAccount.type === "tfs") {
				_this.searchAlm.loader.text = "Searching..."+getAlmUserInfo(true);
			}
			else {
				_this.searchAlm.loader.text = 'Searching...<div class="alusifut"><div class="almusrinf brd">Jira User:<b> '+this.almAccount.username+'</b></div></div>';
			}
			
			_this.searchAlm.loader.show = true;
			axios.get('/pijourney/searchUserOnAlm/' + _this.almAccount.id + "/" + searchQuery)
				.then(response => {
					_this.searchAlm.loader.show = false;
					if(response.data.kendisError){
						onAlmError(response.data.kendisError);
					}
					if (response.data && response.data.success) {
						if (response.data.almType === "tfs") {
							var result = JSON.parse(response.data.content);
							_this.searchAlm.users = [];
							_.each(result.members, _user=>{
								var user = {};
								user.fullName = _user.user.displayName;
								user.email 	  = _user.user.mailAddress;
								//user.userName = _user.user.principalName;
								user.almType  = response.data.almType;
								_this.searchAlm.users.push(user);
							});
						}else {
							var result = JSON.parse(response.data.content);
							_this.searchAlm.users = [];
							_.each(result.users.users, _user=>{
								//if (_user.accountId) {
									var user = {};
									user.fullName = _user.displayName;
									//user.userName = _user.accountId;
									user.almType  = response.data.almType;
									_this.searchAlm.users.push(user);
									if (_user.html) {
										var html = _user.html.replaceAll("</strong>","");
										html = html.replaceAll("<strong>","");
										html = html.split(" - ");
										if (html.length == 2) {
											user.email = html[1];
										}
									}
								//}
							});
						}
						_this.searchAlm.searchCompleted = true;
					}
					else if (response.data.reason == 401) {
						showTopMessage("401 - Unauthorised Access.","warning");
					}
					else if (response.data.reason == 404) {
						showTopMessage("404 - Resource not found.","warning");
					}
				})
				.catch(error => {
					_this.searchAlm.loader.show = false;
				});
		},
		//////////////////////////////////////////////////////
		////////////////    EVENTS
		onClickDropdown: function () {
			if (this.showList) {
				this.resetSelection();
				this.showList = false;
			}
			else {

				this.searchCompleted = false;
				this.showList = true;
				//... clear user
				this.onClickCancelUser();
			// if (this.searchQuery.length < 3) {
				this.listMode  = 0;
				this.pageIndex = 0;
				this.pageableUsers = [];
				this.fetchMoreUsersOnScroll();
			// }

			}
		},
		onTextFocusIn: function () {
			
		},
		onTextFocusOut: function (event) {
		},
		onClickOutsideOfList: function (event) {
			if (!this.$el.contains(event.target)) {
				this.resetSelection();
				this.showList = false;
			}
		},
		onClickDoneButton: function (event) {
			this.showList = false;
		},
		onChangeSearchQuery: function (event) {

			this.showList = true;
			var _this     = this;
			_this.searchCompleted = false;
			if (_this.searchQuery && _this.searchQuery.length>=3) {
				_this.selectedSearchItem = -1;
				_this.listMode = 1;
				_this.searchUsers = [];
				_this.searchUsersCall();
			}else {
				_this.selectedSearchItem = -1;
				_this.listMode = 0;
			}
		},
		onSearchItemsKeyUp: function (event) {

			if (event.key == 'Enter') {
				if (this.suggestions.length > 0) {
					if (this.selectedSearchItem >= 0 && this.selectedSearchItem < this.suggestions.length) {
						var selectedItem = this.suggestions[this.selectedSearchItem];
						this.onSelectSuggestion(selectedItem);
					}
				}
			} else
				if (event.key == 'ArrowDown') {
					if (this.selectedSearchItem === -1 || this.selectedSearchItem >= this.suggestions.length) {
						this.selectedSearchItem = 0;
					}
					else {
						if (this.selectedSearchItem < this.suggestions.length - 1) {
							this.selectedSearchItem++;
						} else {
							this.selectedSearchItem = 0;
						}
					}
					// var listDiv = $('#event-search-list');
					// var slctd = $("#event-search-list-item-" + this.selectedSearchItem).focus();

					// if (slctd.length > 0) {
					// 	if (slctd.offset().top > (listDiv.children().offset().top + listDiv.children().height())
					// 		|| (slctd.offset().top + slctd.height()) < listDiv.children().offset().top) {
					// 		listDiv.children().scrollTop(slctd.offset().top - listDiv.children().children(":visible:first").offset().top);
					// 	}
					// }

				} else if (event.key == 'ArrowUp') {
					if (this.selectedSearchItem === -1 || this.selectedSearchItem >= this.suggestions.length) {
						this.selectedSearchItem = 0;
					} else {
						if (this.selectedSearchItem > 0) {
							this.selectedSearchItem--;
						} else {
							this.selectedSearchItem = this.suggestions.length - 1;
						}
					}

					// var listDiv = $('#event-search-list');
					// var slctd = $("#event-search-list-item-" + this.selectedSearchItem).focus();

					// if (slctd.length > 0) {
					// 	if (slctd.offset().top > (listDiv.children().offset().top + listDiv.children().height())
					// 		|| (slctd.offset().top + slctd.height()) < listDiv.children().offset().top) {
					// 		listDiv.children().scrollTop(slctd.offset().top - listDiv.children().children(":visible:first").offset().top);
					// 	}
					// }
				}
		},
		onSearchItemsKeyUpALM: function (event) {
			if (event.key == 'Enter') {
				this.onAlmPopupClickSearch();
			}
		},
		onSelectSuggestion: function (user) {
			
			var _this = this;
			if (user.id) {				
				user.selected = true;
				if (!_this.multiple) {
					_this.selectedUserMap = {};
				}
				if (!_this.selectedUserMap[user.id]) {
					_this.selectedUserMap[user.id] = true;
					_this.selectedUsers.push(user);
				}else {
					if (_this.multiple) {
						user.selected = false;
						_this.selectedUserMap[user.id] = false;
						var index = _.findIndex(_this.selectedUsers, { id: user.id });
						if (index > -1) {
							_this.selectedUsers.splice(index, 1);
						}
					}
				}
				if (!_this.multiple) {
					var output = _.clone(user);
					delete output.selected;
					_this.$emit("select", user);
					_this.showList = false;
					if (!_this.clearOnSelect) {
						_this.searchQuery = user.fullName;
					}else {
						_this.searchQuery = "";
						_this.selectedUserMap = {};
					}

				} else {
					var output = _.cloneDeep(_this.selectedUsers);
                    _this.searchQuery = "";
                    output.forEach(function (user,index) {
                        delete user.selected;
                        _this.searchQuery += user.fullName;
                        if (index < output.length-1) {
                            _this.searchQuery += ", ";
                        }
                    });

					_this.$emit("select",output);
				}
			}
		},
		onScrollUsersList: function (event) {
			if ((event.target.offsetHeight + event.target.scrollTop) >= event.target.scrollHeight) {
				if (this.listMode == 0) {
					if (!this.pageLoading) {
						this.pageIndex += 1;
						this.fetchMoreUsersOnScroll();
					}
				}
			}
		},
		//..............
		onClickAddButton: function () {
			this.onClickDropdown();
		},
		//..................................
		onSelectSearchFromALM: function () {

			this.searchAlm.searchCompleted = false;
			this.searchAlm.loader.show = false;
			this.searchAlm.searchQuery = this.searchQuery;
			this.searchAlm.users       = [];
			this.searchAlm.show        = true;
		},
		onSelectCreateNew: function () {

			this.createUser.loader.show = false;
			this.createUser.errors.firstName = false;
			this.createUser.errors.lastName = false;
			this.createUser.errors.email = false;
			// if (!_.isEmpty(this.searchQuery)) {

			// 	var parts = this.searchQuery.split(" ");
			// 	this.createUser.firstName = this.capitalizeFirstCharacter(parts[0]);
			// 	if (parts.length>1) {
			// 		this.createUser.lastName = this.capitalizeFirstCharacter(parts[1]);
			// 	}else {
			// 		this.createUser.lastName = "";
			// 	}

			// }else {
			this.createUser.firstName = "";
			this.createUser.lastName = "";
			// }
			this.createUser.email = "";
			this.createUser.show = true;
		},
		//........ ALM events
		onAlmPopupSelectUser: function (user) {

			var user = user;

			var requestBody = {};
			requestBody.fullName = user.fullName;
			var nameParts = user.fullName.split(" ");
			requestBody.firstName = nameParts[0];
			if (nameParts.length > 1) {
				requestBody.lastName = nameParts[1];
			}
			requestBody.email = user.email;
			//requestBody.userName = user.userName;
			if (user.almType == "tfs") {
				requestBody.userType = "ALM_TFS";
			}else if (user.almType == "jira")  {
				requestBody.userType = "ALM_JIRA";
			}

			this.createUserCall(requestBody);
			this.onAlmPopupCancel();
		},
		onAlmPopupCancel: function () {
			this.searchAlm.loader.show = false;
			this.searchAlm.users = [];
			this.searchAlm.searchQuery = "";
			this.searchAlm.show = false;
			this.searchAlm.searchCompleted = false;
		},
		onAlmPopupClickSearch: function () {
			if (!_.isEmpty(this.searchAlm.searchQuery)) {
				this.searchAlm.searchCompleted = false;
				this.searchAlm.users = [];
				this.searchUserFromAlm(this.searchAlm.searchQuery);
			}
		},

		//........ Create new events
		onClickCancelUser: function () {

			this.createUser.errors.firstName = false;
			this.createUser.errors.lastName  = false;
			this.createUser.errors.email     = false;

			this.createUser.firstName = "";
			this.createUser.lastName  = "";
			this.createUser.email     = "";
			this.createUser.show      = false;
		},
		onClickSaveUser: function () {
			if (this.validateCreateUser()) {
				var requestBody = {
					firstName: this.createUser.firstName,
					lastName:  this.createUser.lastName,
					email:     this.createUser.email,
					userType : "NON_FUNCTIONAL"
				};
				this.createUserCall(requestBody);
			}
		},
		clearSelectedUser: function() {
			var _this = this;
			var selectedUserIndex 	= _.findIndex(_this.pageableUsers, {selected: true});
			if(selectedUserIndex > -1) {
				_this.pageableUsers[selectedUserIndex].selected = false;
			}
			_this.searchQuery 		= "";			
			_this.selectedUserMap 	= {};
			_this.selectedUsers 	= [];
			_this.showList 			= false;
			_this.$forceUpdate();
			_this.$emit('select', null);
		},
		resetSelection: function() {
			if(this.allowUnassigned && !this.multiple) {
				if(_.isEmpty(this.selectedUsers)) {
					this.searchQuery = "Unassigned"
				}
				else {
					this.searchQuery = this.selectedUsers[0].fullName;
				}
			}			
		}
	}
});
