var userMixin = {
    methods: {
        userImageOrInitialHtml: function (user, short) {
            
            var html = "";
            if (user && user.picturePath && (typeof agendaPublicShare =="undefined" || !agendaPublicShare)) {
                var imgPath = s3_resource_url + user.picturePath;
                html = '<img src="' + imgPath +'" alt="' + user.fullName + '" title="' + user.fullName + '" />';
            } else {
                if (user.fullName) {
                    var initials = this.getInitials(user.fullName);
                    html = '<div class="initial" style="background-color:' + user.backgroundColor +'" >' + initials + '</div>';
                }
            }
            if (short) {
                return html;
            }else {
                return html +" "+ user.fullName;
            }
        },
        userImage: function (user) {
            var imgPath
            if (user && user.picturePath) {
                imgPath = s3_resource_url + user.picturePath;
            }
            return imgPath;
        },
        getInitials: function (name) {
            var nameArray = name.split(" ");
            var initials = nameArray[0].charAt(0);
            if (nameArray[1])
                initials = initials + "" + nameArray[1].charAt(0);
            return initials;
        },
        //KENDIS, NON_FUNCTIONAL, ALM_JIRA, ALM_TFS
        
    }
};

var popupAutoDirectionMixin = {
    props: {
        containerClass: {
            type: String,
            default: () => { return undefined }
        },
    },
    watch: {
        'showList': {
            handler(val, oldVal) {
                if (val) {
                    var _this = this;
                    Vue.nextTick(function () {
                        _this.popupAutoDirection();
                    });
                }
            },
            immediate: true
        },
        'showAdd': {
            handler(val, oldVal) {
                if (val) {
                    var _this = this;
                    Vue.nextTick(function () {
                        _this.popupAutoDirection();
                    });
                }
            },
            immediate: true
        },
    },
    methods: {
        popupAutoDirection: function () {
            var popup = $(this.$el).find(".dd-list");
            var popupPosition = popup.offset();

            var popupHeight = popup.height();

            var windowHeight;
            var windowTop = 0;
            if (this.containerClass == undefined ) {
                windowHeight = $(window).height();
            }else {
                var container = $("."+this.containerClass);
                windowHeight = container.height();
                windowTop  = container.offset().top;
            }
            
            var spaceAtTop  = popupPosition.top - windowTop;
            var spaceAtDown = windowHeight - spaceAtTop;

            var bottomDiff = spaceAtDown - popupHeight;
            
            if (bottomDiff < spaceAtTop && spaceAtDown < spaceAtTop) {
                popup.removeClass("dir-down");
                popup.addClass("dir-up");
            } else {
                popup.removeClass("dir-up");
                popup.addClass("dir-down");
            }
        }
    }
};