const PI_COLLECTIONS_PICKER = Vue.component('pi-collections-picker', {
	template: 
	`
	<div class="p-rel usrpkr">
		<div class="srbtn ti-search" @click="onClickDropdown">
	    	<input type="text" v-model="searchQuery" :disabled="disabled" :placeholder="placeholder" lazy @input="onChangeSearchQuery" @focus="onTextFocusIn" @blur="onTextFocusOut" @click="onClickDropdown" @keyup="onSearchItemsKeyUp" />
		</div>
		<div v-if="showList" v-click-outside="onClickOutsideOfList" class="drop_boxa addusr dd-list" :class="!multiple? 'single-select': ''">
			<div v-if="loader.show" class="loader" style="z-index:9999"><div><div class="loaderinteg"></div></div></div>
			<div class="head"> Select Collection
			    <a href="javascript:void(0);" @click="onClickDoneButton" class="button-w FR">Done</a>
			</div>
			<ul >			
				<li class="pd-10 brd-bt" v-for="(suggestion,index) in suggestions" @click="onSelectSuggestion(suggestion);">
					<div>{{suggestion.title}}</div>
				</li>
				<li v-if="searchCompleted && suggestions.length == 0">No collections found</li>
			</ul>
		</div>
	</div>
	`,
	props:  {
		value: {
			type: Object,
			default: () => { return {}}
		},
		multiple: {
			type: Boolean,
			default: () => { return false }
		},
		clearOnSelect: {
			type: Boolean,
			default: () => { return false }
		},
        disabled: {
            type: Boolean,
	        default: () => { return false }
        },	
		placeholder: {
			type: String,
			default: () => { return "Select Collection" }
		}
	},
	watch: {
		'value': {
			handler(val, oldVal) {
				this.selectValue(val);
			},
			deep: true,
			immediate: true
		},
	},
	mixins: [],
	model: {
			event: `select`
	},
	data() {
		return {
			loader: {
				show : false,
				text : "",
			},
			
			showList : false,
			selectedSearchItem : -1,
			
			suggestions : [],

			searchQuery: "",
			searchCompleted: false,
		}
	},
	mounted() {
	},
	created() {
		this.selectValue(this.value);
	},
	computed: {
		
	},
	methods: {
		//////////////////////////////////////////////////////
		////////////////    LOGIC
		selectValue: function (value) {
			
			var _this = this;
			
			if (_.isEmpty(value)) {
				this.searchQuery = "";
			}
			else {
				this.searchQuery = value.title;
			}
		},
		//////////////////////////////////////////////////////
		////////////////    API CALLS
		searchCollectionsCall: function () {

			var _this = this;
			var body = { query: this.searchQuery };

			_this.searchCompleted = false;

			if (_this.$options.cancelTokenSource && _this.$options.cancelTokenSource != undefined) {
				_this.$options.cancelTokenSource.cancel();
			}
			_this.$options.cancelTokenSource = axios.CancelToken.source();
			axios.post('/releasetrain/searchCollections', body, { cancelToken: _this.$options.cancelTokenSource.token })
				.then(response => {
					_this.$options.cancelTokenSource = undefined;
					if (!_.isEmpty(response.data)) {
						var collections = response.data.collections;
						_this.suggestions = collections;
						_this.searchCompleted = true;
					}					
				})
				.catch(error => {
					_this.$options.cancelTokenSource = undefined;
				});
		},
		//////////////////////////////////////////////////////
		////////////////    EVENTS
		onClickDropdown: function () {
			if (this.showList) {
				this.showList = false;
			}
			else {
				
			}
		},
		onTextFocusIn: function () {
			
		},
		onTextFocusOut: function (event) {
			
		},
		onClickOutsideOfList: function (event) {
			if (!this.$el.contains(event.target)) {
				this.resetSelection();
				this.showList = false;
			}
		},
		onClickDoneButton: function (event) {
			this.showList = false;
			this.resetSelection();
		},
		onChangeSearchQuery: function (event) {

			this.showList = true;
			var _this     = this;
			_this.searchCompleted = false;
			if (_this.searchQuery && _this.searchQuery.length>=3) {
				_this.selectedSearchItem = -1;
				_this.searchCollectionsCall();
			}else {
				_this.selectedSearchItem = -1;
				_this.suggestions = [];
				this.searchCompleted = false;
			}
		},
		onSearchItemsKeyUp: function (event) {

			if (event.key == 'Enter') {
				if (this.suggestions.length > 0) {
					if (this.selectedSearchItem >= 0 && this.selectedSearchItem < this.suggestions.length) {
						var selectedItem = this.suggestions[this.selectedSearchItem];
						this.onSelectSuggestion(selectedItem);
					}
				}
			} else
				if (event.key == 'ArrowDown') {
					if (this.selectedSearchItem === -1 || this.selectedSearchItem >= this.suggestions.length) {
						this.selectedSearchItem = 0;
					}
					else {
						if (this.selectedSearchItem < this.suggestions.length - 1) {
							this.selectedSearchItem++;
						} else {
							this.selectedSearchItem = 0;
						}
					}
					
				} else if (event.key == 'ArrowUp') {
					if (this.selectedSearchItem === -1 || this.selectedSearchItem >= this.suggestions.length) {
						this.selectedSearchItem = 0;
					} else {
						if (this.selectedSearchItem > 0) {
							this.selectedSearchItem--;
						} else {
							this.selectedSearchItem = this.suggestions.length - 1;
						}
					}
				}
		},
		onSelectSuggestion: function (collection) {
			var _this = this;
			_this.$emit("select",collection);
			
			_this.showList = false;
			_this.selectValue(collection);
		},
		
		//..................................
		//........ Create new events
		resetSelection: function() {
			this.selectValue(this.value);
			this.searchCompleted = false;
		}
	}
});
