(function( $, undefined ) {

    $.widget( "app.slider", $.ui.slider, {    
        // Called when the slider is instantiated.
        _create: function() {
            
            this._super();
    
            var cnt = this.options.min + this.options.step,
                background = this.element.css( "border-color" ),
                left;
    
			var $ticks = ['<div class="ui-slider-tick" style="left: 0%;"></div>'];
            while ( cnt < this.options.max ) {
                
                // Compute the "left" CSS property for the next tick mark.
				
                left = ( cnt / this.options.max * 100 ).toFixed( 2 ) ;
				$ticks.push('<div class="ui-slider-tick" style="left: '+left+'%;"></div>');    
                cnt += this.options.step;
            }
			$ticks.push('<div class="ui-slider-tick" style="left: 100%;"></div>');
			this.element.append($ticks);
        }
    });
})( jQuery );

var sliderMinimuValue = 0;

var labels = {

    0: "10",
    1: "20",
    2: "30",
    3: "40",
    4: "50",
    5: "60",
    6: "70",
    7: "80",
    8: "90",
    9: "100",
    10: "110",
    11: "120",
    12: "130",
    13: "140",
    14: "150",
    15: "160",
    16: "170",
    17: "180",
    18: "190",
    19: "200"
};

var prices = {

		0: "10",
	    1: "20",
	    2: "30",
	    3: "40",
	    4: "50",
	    5: "60",
	    6: "70",
	    7: "80",
	    8: "90",
	    9: "100",
	    10: "110",
	    11: "120",
	    12: "130",
	    13: "140",
	    14: "150",
	    15: "160",
	    16: "170",
	    17: "180",
	    18: "190",
	    19: "200"
}

var map = {
	'localPro' : {
		'yearly' : 16*12,
		'quarterly' : 18*3,
        'monthly' : 20,
        'weekly' : '0'
    },
    'local' : {
		'yearly' : 13*12,
		'quarterly' : 14*3,
        'monthly' : 15,
        'weekly' : '0'
    },
    'cloud' : {
        'yearly' : 8*12,
		'quarterly' : 9*3,
        'monthly' : 10,
        'weekly' : '0'
    },
};

$(document).ready(function() {
	$('#subStory').click(function(evt){
		if(this.checked){
			$('.bsc-price').text('5');
			$('.pro-price').text('10');
		}else{
			$('.bsc-price').text('7');
			$('.pro-price').text('14');
		}
	});
    $("#emp-range").slider({
		dots: false,
        range: "min",
        animate: false,
        min: 0,
        max: 19,
        step: 1,
        slide: 
            function(event, ui) 
            {
        	   if (ui.value < sliderMinimuValue) { 
          	     $(this).slider('value',sliderMinimuValue);
          	   onSliderMinimumLimitSelect ();
          	     return false;
          	  }
              update(1,ui.value); //changed
              calcualtePrice(ui.value);
            }
    });

    $('button').on('click',function(event) {
		if(this.id){
			$(this.parentElement.parentElement).find('.active-option').removeClass('active-option');
			this.classList.add('active-option');
			calcualtePrice();
			
			if(this.classList.contains('dropdown-item')){
				$(this).closest('#types').children(':first').text(this.textContent);
			}
			$('#types').removeClass('open');
		}else{
			$('#types').toggleClass('open');
			event.stopPropagation();
			event.preventDefault();
		}
    });
    
	$(document.body).click(function(evt){
		if($(evt.target).closest('#types').length ==0){
			$('#types').removeClass('open');
		}
	});
    update();
    calcualtePrice();
});
        
        
function update(slider,val) {

    if(undefined === val) val = 0;
    var amount = labels[val];
	var $rang = $('#emp-range');
	$rang.removeClass('last');
	if(val == 4){
		$rang.addClass('last');
	}
	$rang.find('a').html('<label><span class="glyphicon glyphicon-chevron-left"></span> '+amount+' <span class="glyphicon glyphicon-chevron-right"></span></label>');
}

function calcualtePrice(slider_val, package_val, type_val){

	if(undefined === slider_val)
		slider_val = $("#emp-range").slider('value');
	if(undefined === type_val)
		type_val = $('#types .active-option').attr('id');
	if(undefined === package_val)
		package_val = $('#packages .active-option').attr('id');
	
	if(type_val != 'localPro' && $('#quarterly.active-option').length > 0){
		$('#p_msg').show();
	}else{
		$('#p_msg').hide();
	}
	if(slider_val > 3){
		$('#max_msg').show();
	}else{
		$('#max_msg').hide();
	}
	
	var numberOfUsers    = labels[slider_val];
	var durationInMonths = 0;
	if (package_val == 'monthly') {
		durationInMonths = 1;
	}else if (package_val == 'quarterly') {
		durationInMonths = 3;
	}else if (package_val == 'yearly') {
		durationInMonths = 12;
	}
	
    var totalPrice = prices[slider_val]*(map[type_val][package_val]);
    onUpdatePriceCalculatorPlan (numberOfUsers, durationInMonths, totalPrice);
    
    $("#total").val('$'+totalPrice);
}

function setCalculatorUserCount (userCount) {
	
	var fisrtValue = Number(labels[0]);
	if (userCount < fisrtValue) {
		userCount = fisrtValue;
	}
	
	var key = Object.keys(labels).filter(function(key) {return labels[key] === (""+userCount)})[0];
	$("#emp-range").slider('value',key);
	
	update(undefined,key);
	calcualtePrice();	
}

function setCalculatorDuration (duration) {
	var id = "";
	if (duration == 1) {
		id = "#monthly";
	}else if (duration == 3) {
		id = "#quarterly";
	}else {
		id = "#yearly";
	}
	
	var element = $(id);
	
	element.parent().parent().find('.active-option').removeClass('active-option');
	element.addClass('active-option');
	
	calcualtePrice();
}

function setCalculatorMinimumUserCount (userCount) {
	
	var fisrtValue = Number(labels[0]);
	if (userCount < fisrtValue) {
		userCount = fisrtValue;
		
	}else {
		
		var keys = Object.keys(labels);
		var minimumValue = 0;
		
		for (i = 0; i < keys.length ; i++) { 
			var count = Number (labels[keys[i]]);
			if (userCount <= count) {
				userCount = count;
				break;
			}
		}
	}
	
	var key = Object.keys(labels).filter(function(key) {return labels[key] === (""+userCount)})[0];
	sliderMinimuValue = key;
	
	return userCount;
}

function setPackageType (type) {
	
	$("#dd-item-cont").find('.active-option').removeClass('active-option');
	
	var item
	if (type == 0) {
		item = $("#cloud");
	}else if (type == 1) {
		item = $("#local");
	}else {
		item = $("#localPro");
	}
	item.addClass('active-option');
	$('#types').children(':first').text(item.html());
}

function onSliderMinimumLimitSelect () {
	
}



