const PATTERN_PICKER = Vue.component('pattern-picker', {
    template: /*html*/`
        <div class="pattern-picker">
            <div class="pattern-wrapper">
                <em class="paticons none-grid DIB" :class="[_.isEmpty(value) ? 'active' : '']" @click="onSelectPattern(undefined)"></em>
                <em class="paticons line-grid DIB" :class="[value === 'line-grid' ? 'active' : '']" @click="onSelectPattern('line-grid')"></em>
                <em class="paticons dot-grid DIB" :class="[value === 'dot-grid' ? 'active' : '']" @click="onSelectPattern('dot-grid')"></em>
                <em class="paticons bubble-grid DIB" :class="[value === 'bubble-grid' ? 'active' : '']" @click="onSelectPattern('bubble-grid')"></em>
                <em class="paticons slash-grid DIB" :class="[value === 'slash-grid' ? 'active' : '']" @click="onSelectPattern('slash-grid')"></em>
                <em class="paticons square-grid DIB" :class="[value === 'square-grid' ? 'active' : '']" @click="onSelectPattern('square-grid')"></em>
                <em class="paticons extra-grid-1 DIB" :class="[value === 'extra-grid-1' ? 'active' : '']" @click="onSelectPattern('extra-grid-1')"></em>
                <em class="paticons extra-grid-2 DIB" :class="[value === 'extra-grid-2' ? 'active' : '']" @click="onSelectPattern('extra-grid-2')"></em>
                <em class="paticons extra-grid-3 DIB" :class="[value === 'extra-grid-3' ? 'active' : '']" @click="onSelectPattern('extra-grid-3')"></em>
                <em class="paticons extra-grid-4 DIB" :class="[value === 'extra-grid-4' ? 'active' : '']" @click="onSelectPattern('extra-grid-4')"></em>
                <em class="paticons extra-grid-5 DIB" :class="[value === 'extra-grid-5' ? 'active' : '']" @click="onSelectPattern('extra-grid-5')"></em>
            </div>
        </div>
    `,

    props: {
        value: {
			type: String,
			default: () => { return undefined }
		},
    },

    model: {
		prop: "value",
		event: "select"
	},

    watch: {
		"value": {
			handler(newValue, oldValue) {
				this._value = newValue;
			}
		}
	},

    methods: {
        onSelectPattern(pattern) {
			this._value = pattern;
			this.$emit('select', pattern);
		},
    },
});
