let objectivesVU;
function fetchData() {
    // Replace this with your actual data fetching logic
    console.log("Fetching data...");
}

function initPage(){
	initObjectivesComponent();
}

// router.beforeEach((to, from, next) => {
// 	const app = router.app; // Access the root Vue instance

// 	// Check the condition from the root instance
// 	if (app.$root.showCheckIn) {
// 		next(); // Allow the navigation
// 	} else {
// 		const checkCondition = setInterval(() => {
// 			if (app.$root.showCheckIn) {
// 				clearInterval(checkCondition);
// 				next(to.fullPath); // Redirect to the intended route once the condition is met
// 			}
// 		}, 100);
// 	}
// });
function initObjectivesComponent(){
	Vue.use(VueRouter);
	Vue.directive('sortable', {
	    inserted: function (el) {
	        var sortable = new Sortable(el, el.options)
	        if (this.arg && !this.vm.sortable) {
	            this.vm.sortable = {}
	        }
	        // Throw an error if the given ID is not unique
	        if (this.arg && this.vm.sortable[this.arg]) {
	            console.warn('[vue-sortable] cannot set already defined sortable id: \'' + this.arg + '\'')
	        } else if (this.arg) {
	            this.vm.sortable[this.arg] = sortable
	        }
	    },
	    update: function (el, binding, vnode) {
	        if (binding.value) {
	
	        }
	    },
	    bind: function (el, binding) {
	        el.options = binding.value || {}; // in "bind"
	    }
	});

	const router = new VueRouter({
		routes: [
			{
				path: '/:viewId',
	            name: 'list-objectives',
	            component: LIST_OBJECTIVES,
	            props: route => ({
					customViewId: route.params.viewId,
					isMockingMode: true,
					showCreationMenu: true,
					shouldLoadObjectives: true,
					isGlobalObjectiveView: true,
					board: {
						session: {
							id: "-1",
							uncommittedObjEnabled: false,
						},
					},
				}),
				children : [

					]
			},
			{
				path: '/:viewKey/okr-roadmaps/:roadmapId/:viewId',
				component: OKRS_ROADMAP_COMPONENT,
				props: route => ({
					releaseTrainId: route.params.releaseTrainId,
					isGlobalObj: true,
					roadmapId: route.params.roadmapId,
					viewId : route.params.viewId,
					viewKey : route.params.viewKey
				}),
			},
			{
				path: '/checkin/:checkInId',
				name: 'checkin-url-wrapper',
				component: CHECKIN_URL_WRAPPER,
				props: route => ({
					checkInId: route.params.checkInId,
					isMockingMode: true, // Set your condition here
				}),
			},


		]
	});

	// Objectives View
	objectivesVU = new Vue({
	    el: '#ObjectivesTab',
		router,
	    data() {
			return {
                flags : {boards : false,teams : false,containers : false, status: false, batches : false , solutionBoards : false, refetchData:false},
		        itemTemplate: {
		            templateToRenderer	: {},
		            statuses			: [],
		        },
		        board					: {},
		        solutionBoard			: {},
		        boardSession			: [],
		        boardsForLinking		: [],
				allWorkspaceTypes		: [],
		        objectivesList			: [],
		        showObjectivesListing	: false,
		        showObjectiveComponent	: false,
				dataLoaded				: false,
				showCheckIn				: false,
		        objectiveType			: "",
			}
	    },
	    created: function () {
			this.fetchWorkSpaceTypes();
			//this.fetchReleaseTrains();
	    },
		mounted: function() {
			document.getElementById("ObjectivesTab").addEventListener("scroll", () => {
			    //clearTimeout(scrollingTimer);
				fetchData();
			    scrollingTimer = setTimeout(onScrollStopped, 300);
			});		
			
		},
	    component: {
	        'boards-list-linked-items':BOARDS_LIST_LINKED_ITEMS,
	        'check-in-listing': CHECK_IN_LISTING,	
	        'list-linked-items': LIST_LINKED_ITEMS,
	        'objective-row-component': OBJECTIVE_ROW_COMPONENT,
			'objective-list-linked-items': OBJECTIVE_LIST_LINKED_ITEMS,
	        'objective-group-component': OBJECTIVE_GROUP_COMPONENT,
	        'dynamic-popup-container': DYNAMIC_POPUP_CONTAINER,
	        'list-objectives': LIST_OBJECTIVES,
	        'objective-menu-component': OBJECTIVE_MENU_COMPONENT,
	        'add-custom-objective-form-component': ADD_CUSTOM_OBJECTIVE_FORM_COMPONENT,
	        'objective-link': OBJECTIVE_LINK,
	        'link-okr'      : LINK_OKR,
			'objective-group-progress': OBJECTIVE_GROUP_PROGRESS,
			'objective-theme-progress': OBJECTIVE_THEME_PROGRESS,
			'objectives-custom-views': OBJECTIVES_CUSTOM_VIEWS,
	    },
	    methods: {
			fetchWorkSpaceTypes: function() {
				let _this = this;
				axios.get('releasetrain/getAllWorkSpaceTypes')
				.then(response=>{
					if(response && response.data) {
						_this.allWorkspaceTypes = response.data.workSpaceTypes;
						kendisStore.commit('setWorkspaceTypes', _this.allWorkspaceTypes);
						_this.dataLoaded = true;
					}
				})
				.catch(error=>{
					console.error(error);
				});
			},	
	        onOpenObjectivesView: function () {
	            let _this = this;
	            axios.get('/objective/templateForObjectives')
	                .then(response => {
	                    if (!_.isEmpty(response.data)) {
	                        if (response.status == "200") {
	                            _this.itemTemplate = {};
	                            _this.itemTemplate.model = {};
	                            _this.itemTemplate.model.fields = {};
	                            _this.itemTemplate.templateToRenderer = response.data.template;
	                            if (response.data.itemTypeList) {
	                                _this.itemTemplate.itemTypeList = response.data.itemTypeList;
	                            }
	                            this.showObjectivePopUp = true;
	                            this.$forceUpdate();
	                        }
	                    }
	                })
	                .catch(error => {
	                    console.log(error)
	                });
	        },
	        getDummyBoard: function(entityId) {
	            let batchDummyBoard = {};
	            batchDummyBoard.teams = [];
	            batchDummyBoard.session = {
	                id: entityId,
	                uncommittedObjEnabled: false,
	            };
	            return batchDummyBoard;
	        },
	        onAddObjectiveForPiBoard: function (board) {
	            this.board = board;
	            this.boardSession = [];
	            this.boardSession.push({id: this.board.session.id, name: this.board.session.title});
	            this.onOpenObjectivesView();
	        },
	        onAddObjectiveForSolutionBoard: function (board) {
	            let _this = this;
	            this.solutionBoard = board;
	            if (_.isEmpty(_this.boardsForLinking)) {
	                _this.boardsForLinking = _.map(_this.solutionBoard.piBoards, board => {
	                    return {"id": board.sessionId, "name": board.title}
	                });
	            }
	            this.onOpenObjectivesView();
	        },
	
	        listObjectives: function (board) {
	            this.board = board
	            this.boardSession = [];
	            this.boardSession.push({id: this.board.session.id, name: this.board.session.title});
	            this.showObjectivesListing = true;
	        },
	        onDeleteObjective: function (id) {
	            console.log(id);
	        },
	
	        onCloseObjectivePopUp: function () {
	            this.showObjectivesListing = false;
	            this.$forceUpdate();
	        },
	
	        closeObjectivesListingPopUp: function () {
	            this.showObjectivesListing = false;
	        }
	    }
	});
}