const OBJECTIVE_MENU_COMPONENT = Vue.component('objective-menu-component', {
    mixins : [CALCULATION_SETTINGS_MIXIN, window.ExportEnabledMixin || {}],

    props: {
        teams: {
            type: Array, default: () => {
                return [];
            }
        },
        isSolutionBoard: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        objectiveMenuOptions: {
            type: Object,
            default: () => {
                return {}
            }
        },
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isObjectiveMainView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        board: {
            type: Object,
            default: () => {
                return {};
            }
        },
        isMockingMode: {
            type: Boolean,
            default: () =>{ return false }
        },
        isArt: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        showObjectiveBanner: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isGlobalObjectiveView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        customView: {
            type: Object,
            default: () => {
                return {};
            }
        },
        isBatchView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isSOSPage: {
            type: Boolean,
            default: false,
        },
        artCollections: {
            type: Array,
            default: () => {
                return [];
            }
        }
    },

    template: /*html*/`
        <div v-if="!showObjectiveBanner" class="prow">
            <div id="OBJ-TOP-FOOTER" class="obtop objtb aa DAB p-rel"> 
            	<div class="lft DFA">
            	    <div class="ttl elips" v-if="isArt && isMockingMode && _.isEmpty(customView)">Collection OKRs</div>
                    <div class="ttl elips" v-if="isBatchView">Batch OKRs</div>
            	    <a href="javascript:void(0)" @click="toggleExpand" v-if="!isMockingMode && getObjectiveGroupList && getObjectiveGroupList.length > 0" class="expnd o-add FL DJA ml-10">
						<template>
            	        	<span v-if="!isAllExpand" class="ti-angle-right ico FL ftsb">Expand All</span>
							<span v-else class="ti-angle-down ico FL ftsb">Collapse All</span>
						</template>
            	    </a>
	                <a v-if="!isSolutionBoard && !readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE_GROUP && !isMockingMode" href="javascript:void(0);" class="o-add ti-plus addf FL ml-10" id="add-t" @click="onAddTeamClick">Add <span class="teamClass"></span></a> 
	                <a v-if="!readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE_GROUP && !isMockingMode"                     href="javascript:void(0);" class="o-add ti-plus addf FL ml-10" id="add-c" @click="onAddCustomClick">Add Custom</a>
	                <a v-if="!readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE_GROUP && isMockingMode"                      href="javascript:void(0);" class="o-add ti-plus addf FL ml-10" id="add-c" @click="onSelectAddCustomObjective">Add Custom</a>
	                <a v-if="!readOnlyView && $options.permissions && $options.permissions.EDIT_OBJECTIVE_GROUP && isMockingMode && !isArt && !isBatchView && customView?.id !== '-1'" href="javascript:void(0);" class="o-add ti-plus addf FL ml-10" id="add-c" @click="onSelectAddCollectionObjective">Add Collection</a>

                    <div v-if="addMenu.showCollections" class="oplvlslc" style="display:block; width: 300px;">
						<treeselect
							:multiple="false"
							:options="workspaceList"
							:flat="true"
							placeholder="Search or Select Collection..."
							no-children-text="No Sub Level"
							:clearable="false"
                            @select="onSelectCollection"
						/>
					</div>
		            
	                <vuepopup v-if="showTeamSelection && !isSolutionBoard" @close="onClosePopupTeam" class="oTeam">
                    <div class="ui-multiselect-menu ui-widget ui-widget-content ui-corner-all ui-multiselect-single" style="width: 257px; display:block">
                        <div class="ui-widget-header ui-corner-all ui-multiselect-header ui-helper-clearfix ui-multiselect-hasfilter">
                            <div class="ui-multiselect-filter">
                                Filter: <input placeholder="Enter keywords" type="search" v-model="searchTeam" @input="onSearchTeam" />
                            </div>
                        </div>
                        <ul class="ui-multiselect-checkboxes ui-helper-reset">
                            <li class="ui-multiselect-disabled ">
                                <label for="ui-multiselect-o-team-option-0" title="" class="ui-corner-all ui-state-disabled ui-state-active check">
                                    <input id="ui-multiselect-o-team-option-0" name="multiselect_o-team" type="radio" value="-1" title="Select Team" checked="checked" aria-selected="true" disabled="disabled" />
                                    <span class="lbl">Select Team</span>
                                </label>
                            </li>

                            <template v-for="team in filteredTeams">
                                <li :class="[team.disabled ? 'ui-multiselect-disabled' : '']">
                                    <label title="" class="ui-corner-all" :class="[team.disabled ? 'ui-state-disabled' : '']">
                                        <input @click="onSelectTeam(team)" name="multiselect_o-team" type="radio" :value="team.id">
                                        <span class="lbl">{{team.title}}</span>
                                    </label>
                                </li>
                            </template>
                        </ul>
                    </div>
		            </vuepopup>
                </div>
                
                <div class="rht DFA">
			    	<div v-if="!isMockingMode && !isSolutionBoardPi && !isSosView" class="w-230 rnd4 c-point selectcont wht">
	                    <vz-select v-model="filteredGroups" :options="getGroupOptions" label="title" track-by="id" :multiple="true" @select="updateFilteredGroups" value-type="value" selected-title="Select Objective Groups" empty-selection-text="Select Objective Groups"></vz-select>						
			    	</div>
			    	<div v-if="((isGlobalObjectiveView || filteredObjectiveGroups && filteredObjectiveGroups.length > 0) || (getObjectiveGroupList && getObjectiveGroupList.length > 0))" class="c-point prgbtn" @click="$emit('progress')" title="Progress"></div>


			    	<div v-if="!isMockingMode" @click.stop="showStatusEstimateFilter = !showStatusEstimateFilter" class="withicon slctdn DFA p-rel c-point rnd4">
			    		<div class="wicon DAJ" :class="getEstimateIconClass()">%</div>
						<vuepopup v-if="showStatusEstimateFilter" @close="showStatusEstimateFilter = false">
				    		<div class="drop_box nwmu lnk artp" style="display: block;">
								<ul>
									<li v-if="!_.isEmpty(statusAndEstimateFilters[5])" @click="onSelectStatusEstimateFilter(statusAndEstimateFilters[5])" :class="selectedStatusEstimateFilter.code === 'OBJ_KR_WEIGHTS_FORMULA' ? 'active' : ''"><a href="javascript:void(0);" class="DFA"><div class="wicon f DAJ">%</div> Use value set at OKR level </a></li>
									<li @click="onSelectStatusEstimateFilter(statusAndEstimateFilters[0])" :class="selectedStatusEstimateFilter.code === 'LINKED_ITEM_STATUS' ? 'active' : ''"><a href="javascript:void(0);" class="DFA"><div class="wicon a DAJ">%</div> By Linked Items Status</a></li>
									<li @click="onSelectStatusEstimateFilter(statusAndEstimateFilters[1])" :class="selectedStatusEstimateFilter.code === 'CHILDREN_LINKED_ITEM_STATUS' ? 'active' : ''"><a href="javascript:void(0);" class="DFA"><div class="wicon b DAJ">%</div> By Children of Linked Items (Stories) - Status</a></li>
									<li @click="onSelectStatusEstimateFilter(statusAndEstimateFilters[2])" :class="selectedStatusEstimateFilter.code === 'CHILDREN_LINKED_ITEM_ESTIMATE' ? 'active' : ''"><a href="javascript:void(0);" class="DFA"><div class="wicon c DAJ">%</div> By Children of Linked Items (Stories) - Estimate</a></li>
									<li @click="onSelectStatusEstimateFilter(statusAndEstimateFilters[3])" :class="selectedStatusEstimateFilter.code === 'TEAM_STORY_STATUS' ? 'active' : ''"><a href="javascript:void(0);" class="DFA"><div class="wicon d DAJ">%</div> By Team Stories - Status</a></li>
									<li @click="onSelectStatusEstimateFilter(statusAndEstimateFilters[4])" :class="selectedStatusEstimateFilter.code === 'TEAM_STORY_ESTIMATE' ? 'active' : ''"><a href="javascript:void(0);" class="DFA"><div class="wicon e DAJ">%</div> By Team Stories - Estimate</a></li>
								</ul>	
							</div>
						</vuepopup>						
			    	</div>

                    <div v-if="isMockingMode &&  !(customView && customView.id === '-1') && !isBatchView" class="c-point button nwabtn okrdmp" :class="{ 'disabled': isOkrRoadmapLoading }" @click="!isOkrRoadmapLoading && onClickOpenRoadmap()">
                        <span v-if="isOkrRoadmapLoading">Loading...</span>
                        <span v-else>OKRs Roadmap</span>
                    </div>                    

                    <div v-if="isMockingMode && isFilterApplied" class="">
                        <a class="c-point und key fs-13" @click="resetFilters()">Reset Filter</a>
                    </div>
                    <div v-if="isMockingMode" @click.stop="timePeriodFilter.showFilter = !timePeriodFilter.showFilter" class="withicon slctdn DFA p-rel c-point rnd4">
			    		<div class="DAJ mr-30">Time Period</div>
						<time-period-filter-popup v-if="timePeriodFilter.showFilter" :filter="timePeriodFilter.filter" :view-type="'okrList'" @onTimePeriodFilter="onTimePeriodFilter"  />
			    	</div>

                    <div v-if="isMockingMode" class="w-150">
						<pi-user-picker class="h-auto" v-model="objectiveFilters.responsible" :multiple="true" :show-create-user="false" :show-button="false" :allow-unassigned="true" placeholder="Responsible" @select="onFilterResponsible"/>
					</div>

                    <div v-if="isMockingMode" class="selectcont h-auto w-auto rnd4">
						<vz-select v-model="objectiveFilters.collections" :show-item-key="true" empty-selection-text="Collection Associations" selected-title="Collection Associations" :multiple="true" track-by="id" value-type="id" label="title" :options="collections" class="multi-filter" @select="onFilterAssociation" ></vz-select>
					</div>

                    <div v-if="isMockingMode" class="selectcont h-auto w-150 rnd4">
						<vz-select v-model="objectiveFilters.statuses" empty-selection-text="Statuses" selected-title="Statuses" :multiple="true" track-by="id" value-type="id" label="title" :options="okrStatuses" class="multi-filter" @select="onFilterStatus"></vz-select>
					</div>


			    	<div v-if="!isGlobalObjectiveView || customView?.id === '-1'" class="c-point button h-auto rnd4 DFA" @click="onClickShowCheckIns">Check-Ins</div>
			    	<div class="spr-vrt chkinspr cssHide"></div>
			    	<div class="srch srchnww"><input type="text" placeholder="Search..." class="srch ht-32 rnd6" v-model="searchQuery" @input="onInputSearch"/></div> 
                    <div v-if="!isMockingMode" class="FR export mnuout">
                        <a href="javascript:void(0);" onclick="showOverLay(this,'#opt_export' )" class="slctdn nw impr FR rnd4"><em class="ti-import"></em></a>
                        <ul class="drop_box" id="opt_export">
                            <li><a href="javascript:void(0);" class="applyfilter" @click="onReportClick('csv')">Export CSV</a></li>
                            <li><a href="javascript:void(0);" class="applyfilter" @click="onReportClick('xls')">Export Excel</a></li>
                            <li v-if="isExportEnabled">
                               <export-button :exported-filename="board.session ? board.session.title + ' - Objectives' : 'Objectives'" 
                                :html-element="htmlElement" :display-as-menu-option="true"
                                    :ids-to-remove="['obj_settings', 'LFT-HEADER','OBJ-TOP-FOOTER', 'OBJ_MANAGEMENT', 'TOGGLE_CHART',
                                    'CLOSE_OBJS','OBJ_TIMELINE']"                                    
                                    pageName="pi-objectives"
                                   />
                            </li>
                        </ul>
                    </div>
                    <div v-if="isMockingMode" class="FR export mnuout">
                        <a href="javascript:void(0);" onclick="showOverLay(this,'#opt_export' )" class="slctdn nw impr FR rnd4"><em class="ti-import"></em></a>
                        <ul class="drop_box" id="opt_export">
                            <li><a href="javascript:void(0);" class="applyfilter" @click="onExportTypeClick('csv')">Export CSV</a></li>
                            <li><a href="javascript:void(0);" class="applyfilter" @click="onExportTypeClick('xlsx')">Export Excel</a></li>
                        </ul>
                    </div>
	                <div class="spr-vrt cssHide" v-if="!readOnlyView"></div>

                	<div v-if="!readOnlyView && $options.permissions.VIEW_OBJECTIVE_SETTINGS && !isMockingMode" class="stngmn DAJ c-point" onclick="showOverLay(this,'#obj_settings' );" @click="setAutoFocus()"><em class="stgico3 ico DB mr-10"></em> Settings</div>
                	<div v-else-if="!readOnlyView && isMockingMode && $options.permissions.VIEW_OBJECTIVE_SETTINGS" class="stngmn DAJ c-point" @click="showSettingsPopup=true"><em class="stgico3 ico DB mr-10"></em> Settings</div> 
                	<div class="drop_box nwmu obj_settings" id="obj_settings">
	                <div class="overlay" style="display: block;"></div>
	                <div class="objcont prow" v-on:keydown="handleESCEvent" ref="objSettings" tabindex="0">
	                	<div class="hd ftsb">Settings <span onclick="closeAllOverLay()" class="rmv-ico ti-close rnd DAJ" title="Close"></span></div>
	                	<div class="head ftsb">Objectives</div>
	                	<ul>                		
	                        <li>	                            
	                            <div class="switch-button grn switch-button-sm FR">
	                                <input id="bvAchievement" type="checkbox" v-model="menuOptions.isBVAchievementEnabled" />
	                                <span @click="setObjectiveMenuSingleOption('isBVAchievementEnabled')"><label for="bvAchievement"></label></span>
	                            </div>
	                            <div class="text ftsb FL">BV Achievement</div>
	                        </li>
	                        <li>	                            
	                            <div class="switch-button grn switch-button-sm FR">
	                                <input id="unCommitted" type="checkbox" v-model="menuOptions.isUnCommittedEnabled" />
	                                <span @click="setObjectiveMenuSingleOption('isUnCommittedEnabled')">
	                                    <label for="unCommitted"></label>
	                                </span>
	                            </div>
	                            <div class="text ftsb FL">Uncommitted Objectives</div>
	                        </li> 
	                        <li>	                            
	                            <div class="switch-button grn switch-button-sm FR">
	                                <input id="showStatus" type="checkbox" v-model="menuOptions.isStatusEnabled" />
	                                <span @click="setObjectiveMenuSingleOption('isStatusEnabled')">
	                                    <label for="showStatus"></label>
	                                </span>
	                            </div>
	                            <div class="text ftsb FL">Objective Status</div>
	                        </li>
	                        <li>	                            
	                            <div class="switch-button grn switch-button-sm FR">
	                                <input id="completionColumn" type="checkbox" v-model="menuOptions.isProgressEnabled" />
	                                <span @click="setObjectiveMenuSingleOption('isProgressEnabled')">
	                                    <label for="completionColumn"></label>
	                                </span>
	                            </div>
	                            <div class="text ftsb FL">% Completion Column</div>
	                        </li>                                             
	                        <li>
	                            <a href="javascript:void(0);" class="text ftsb" @click="redirectToWorkFlow">Workflow settings</a> 
	                        </li>
	                        
	                        <li>
                                <div class="switch-button grn switch-button-sm FR">
                                    <input ref="okr" id="okr" type="checkbox" v-model="menuOptions.isOkrEnabled" />
                                    <span @click="setObjectiveMenuSingleOption('isOkrEnabled')">
                                        <label for="okr"></label>
                                    </span>
                                </div>
                                <div class="text ftsb FL">Key Result Style</div>
	                          </li>
                            <span v-show="menuOptions.isOkrEnabled">
	                            <li class="head ftsb">Key Results</li>
	                            <li>                                
	                                <div class="switch-button grn switch-button-sm FR">
	                                    <input id="bvAchievementOkr" type="checkbox" v-model="menuOptions.isOkrBVAchievementEnabled" />
	                                    <span @click="setObjectiveMenuSingleOption('isOkrBVAchievementEnabled')">
	                                        <label for="bvAchievementOkr"></label>
	                                    </span>
	                                </div>
	                                <div class="text ftsb FL">BV Achievement</div>
	                            </li>
	                            <li>                                
	                                <div class="switch-button grn switch-button-sm FR">
	                                    <input id="statusOkr" type="checkbox" v-model="menuOptions.isOkrStatusEnabled" />
	                                    <span @click="setObjectiveMenuSingleOption('isOkrStatusEnabled')">
	                                        <label for="statusOkr"></label>
	                                    </span>
	                                </div>
	                                <div class="text ftsb FL">Key Results Status</div>
	                            </li>
	                            <li><a href="javascript:void(0);" class="text ftsb" @click="redirectToWorkFlow">Workflow Settings</a></li>
                            </span>
                            <li class="head ftsb">Other Actions</li>
                            <li><a href="javascript:void(0);" class="text ftsb" @click="onReportClick('csv')">Export CSV</a></li>
                            <li><a href="javascript:void(0);" class="text ftsb" @click="onReportClick('xls')">Export Excel</a></li>
                            <li v-if="isExportEnabled">
                                <export-button :exported-filename="board.session ? board.session.title + ' - Objectives' : 'Objectives'"
                                    class="okrExport" :html-element="htmlElement" :display-as-menu-option="true"
                                    :ids-to-remove="['obj_settings', 'LFT-HEADER','OBJ-TOP-FOOTER', 'OBJ_MANAGEMENT', 'TOGGLE_CHART',
                                    'CLOSE_OBJS','OBJ_TIMELINE']"                                    
                                    pageName="pi-objectives"
                                    />
                            </li>
                            <li><a href="javascript:void(0);" class="text ftsb" @click="openExcludeItemSettings = true">Calculation Settings</a></li>
                            <li v-if="!readOnlyView && !showUnLinkedItems">
								<a href="javascript:void(0);" class="text ftsb" @click="viewUnLinkedItems">View Linked Items Not on the Board</a>
							</li>
                            <li v-else-if="!readOnlyView && showUnLinkedItems">
								<a href="javascript:void(0);" class="text ftsb" @click="viewUnLinkedItems">View All Linked Items</a>
							</li>
	                    </ul>
                    </div>
                    </div>                    
	            </div>
            </div>
            <div>
				<vuepopup v-if="showSettingsPopup" >
					<objective-settings-popup :type="isArt || isBatchView ? 'objective' : 'customView'" :custom-view="customView" @close="showSettingsPopup = false;" @update-objective-workspace="updateObjectiveWorkspace" @onSaveCustomViewColumns="onSaveCustomViewColumns"></objective-settings-popup>
				</vuepopup>
			</div>
            
            <exclude-items v-if="openExcludeItemSettings" ref="excludeItemsSettings" @save-exclude-item="saveExcludeItemsSettings"  @close="openExcludeItemSettings = false;" :active-session-board = "activeBoard" viewType="Objectives"></exclude-items>
            
            <!-- Export Options Popup start -->
            <div v-if="exportOptions.showPopup" @close="closeExportPopup">
            <div class="overlay" style="display: block;"></div>
                <div class="ui-dialog set-pop exprtcsv showallselect p-fix " style="display: block;">
                    <div class="head DFCB">
                        <span class="hdins">Export Objectives</span>
                        <div class="DFA">
                            <a href="javascript:void(0);" tabindex="-1" class="rmv-ico ti-close rnd DAJ" @click="closeExportPopup"></a>
                        </div>
                    </div>
                    <div class="cntr">
                    	<div class="rec lblm DFA">
                    		<label class="mb-0">Export Type:</label>
                    		<div class="xtag ftsb rnd4">{{ exportOptions.exportType?.toLowerCase() === 'xlsx' ? 'Excel' : 'CSV' }}</div>
                    	</div>
                        <div class="rec">
                            <div class="hdbl ftsb mb-20">
                                Select Export Option
                                <span class="infotxt ml-5 tooltip">
                                    <span class="hovtooltipB rnd4 wdt3 lft">Default exports the current view of objectives with all fields. Use Column Selection to create a custom sheet with only the data you need.</span>
                                </span>
                            </div>
                            
                                <div class="radio-button mb-20 DFA p-rel mid">
                                    <input id="exportDefault" type="radio" v-model="exportOptions.selectionType" value="default" @change="onExportSelectionChange">
                                    <label for="exportDefault" class="mn blk" style="color: black">Default</label>
                                </div>
                                <div class="radio-button DFA p-rel mid">
                                    <input id="exportColumnSelection" type="radio" v-model="exportOptions.selectionType" value="columnSelection" @change="onExportSelectionChange">
                                    <label for="exportColumnSelection" class="mn blk" style="color: black">Column Selection</label>
                                </div>
                            
                        </div>
                        
                        <div class="rec " v-if="exportOptions.selectionType === 'columnSelection'">
                            <div class="hdbl ftsb mb-20">
                                Select Columns
                                <span class="infotxt ml-5 tooltip">
                                    <span class="hovtooltipB rnd4 wdt3 lft">Select fields (e.g., Responsible, Description, Progress) that you want as columns in the final spreadsheet.</span>
                                </span>
                            </div>
                            <div class="selectcont rnd4 statusDrop export-columns-multiselect">
                                <vz-select 
                                    :multiple="true" 
                                    v-model="exportOptions.selectedColumns" 
                                    empty-selection-text="Select columns to export" 
                                    :selected-title="'Columns (' + (exportOptions.selectedColumns?.length || 0) + ')'"
                                    class="multi-filter" 
                                    value-type="value"
                                    :options="filteredAvailableColumns"                               
                                    @select="onExportColumnSelect"
                                />
                            </div>
                        </div>
                    </div><!-- .cntr end -->
                    <div class="rec btn">
                        <button class="expbtn FR rnd4" @click="confirmExport"> Export </button>
                        <a href="javascript:void(0);" class="FR cncl" @click="closeExportPopup">Cancel</a>
                    </div>
                </div>
                
            </div><!-- Export Options Popup end -->
            
            <ProgressBar 
                v-if="showProgress"
                title="Generating Export File"
                :progressValue="currentProgress"
                :showPercentage="true"
                :allowCancel="true"
                :exportError="exportError"
                :downloadSuccessful="downloadSuccessful"
                message="Please wait while we prepare your export file..."
                @cancel="cancelExport"
                @close="closeProgress"
            ></ProgressBar>
        </div>`,

    components: {
        'treeselect': VueTreeselect.Treeselect,
    },

    data() {
        return {
            isExportEnabled: false,
            isLocalDeployment: false,
            selectedStatusEstimateFilter: {},
            activeBoard					: {},
			menuOptions					: {},
            filteredTeams				: [],
			filteredGroups				: [],
            //Change name only and not keys, add all checks on keys and not names
            statusAndEstimateFilters: [
                {id: 1, code: 'LINKED_ITEM_STATUS', name: 'By Linked Items Status'},
                {id: 2, code: 'CHILDREN_LINKED_ITEM_STATUS', name: 'By Children of Linked Items (Stories) - Status'},
                {id: 3, code: 'CHILDREN_LINKED_ITEM_ESTIMATE', name: 'By Children of Linked Items (Stories) - Estimate'},
                {id: 4, code: 'TEAM_STORY_STATUS', name: 'By Team Stories - Status'},
                {id: 5, code: 'TEAM_STORY_ESTIMATE', name: 'By Team Stories - Estimate'}
            ],
            searchQuery					: "",
            searchTeam					: "",
            searchCollection            : "",
            showExportPopup				: 'none',
            openExcludeItemSettings		: false,
            showTeamSelection			: false,
			showStatusEstimateFilter	: false,
            isAllExpand					: false,
			showUnLinkedItems			: false,
			showSettingsPopup			: false,
			addMenu: {
				show: false,

				showCollections: false,
				loadingCollections: false,
				collections: []
			},
            timePeriodFilter            : {
                showFilter              : false,
                filter                  : {},
            },
            settings: {
                show: false,
            },
            collections: [],
            workspaceList: [],
            objectiveFilters: {
                responsible: [],
                collections: [],
                statuses: [],
                search: "",
            },
            htmlElement: null,
            isExpandAll: true,
            searchQuery: '',
            selectedTeam: '',
            selectedBoard: '',
            selectedSolution: '',
            isObjectiveBacklogColumnsOpen: false,
            isObjectiveSettingsOpen: false,
            isObjectiveWorksSpaceSettingsOpen: false,
            isObjectiveFiltersSettingsOpen: false,
            isObjectiveCalculationSettingsOpen: false,
            isObjectiveProgressSettingsOpen: false,
            dropdownValueMap: {},
            customColumns: [],
            okrCustomColumns: [],
            cvCustomColumns: [],
            isOkrRoadmapLoading: false,
            
            showProgress: false,
            currentProgress: 0,
            exportError: false,
            downloadSuccessful: false,
            exportOptions: {
                showPopup: false,
                exportType: '',
                selectionType: 'default', // 'default' or 'columnSelection'
                selectedColumns: [],
                preventClose: false, // Flag to prevent accidental popup closing
                availableColumns: [
                    { id: 'hLevel', title: 'H-Level' },
                    { id: 'hType', title: 'H-Type' },
                    { id: 'itemId', title: 'Item ID' },
                    { id: 'title', title: 'Title' },
                    { id: 'description', title: 'Description' },
                    { id: 'immediateParentId', title: 'Immediate Parent ID' },
                    { id: 'immediateParentType', title: 'Immediate Parent Type' },
                    { id: 'objectiveGroupName', title: 'Objective Group Name (L1)' },
                    { id: 'timePeriod', title: 'Time Period' },
                    { id: 'status', title: 'Status' },
                    { id: 'progress', title: 'Progress (%)' },
                    { id: 'progressCriteria', title: 'Progress Criteria' },
                    { id: 'association', title: 'Association' },
                    { id: 'startDate', title: 'Start Date' },
                    { id: 'endDate', title: 'End Date' },
                    { id: 'lastUpdated', title: 'Last Updated' },
                    { id: 'responsible', title: 'Responsible' },
                    { id: 'objType', title: 'OBJ Type' },
                    { id: 'krProgressCriteria', title: 'KR Progress Criteria' },
                    { id: 'linkedItems', title: 'Linked Items' },
                    { id: 'krStartValue', title: 'KR start value' },
                    { id: 'krTargetValue', title: 'KR Target Value' },
                    { id: 'krProgress', title: 'KR progress' },
                    { id: 'lastComment', title: 'Last Comment' },
                    { id: 'lastCommentOn', title: 'Last Comment On' }
                ]
            },
            // Request id for export (used for polling/cancel)
            exportRequestId: null
        }
    },

    computed: {
        // Filter out H-Level and H-Type from dropdown selection while keeping them in availableColumns
        filteredAvailableColumns: function() {
            return this.exportOptions.availableColumns.filter(column => 
                column.id !== 'hLevel' && column.id !== 'hType'
            );
        },
        getObjectiveGroupList: function () {
            return kendisStore.getters.getOjectiveGroups();
        },
		
		workspace: function() {
			return kendisStore.getters.getObjectiveWorkspace();
		},
		filteredObjectiveGroups: function() {
			return kendisStore.state.filteredGroups
		},
		isSolutionBoardPi: function() {
			return window.location.href.indexOf('solutions') > -1;
		},
		isSosView: function() {
			let queryString = window.location.search;
			const urlParams = new URLSearchParams(queryString);
			let viewIndex = urlParams.get("moreOptionsIndex");
			return 	viewIndex == 10;		
		},
        okrStatuses() {
            const statsues = kendisStore.getters.getObjectiveTemplate().statuses;
            if (_.isEmpty(statsues)) {
                return [];
            }
            return statsues;
        },
        isFilterApplied() {
            return (!_.isEmpty(this.timePeriodFilter.filter) && !_.isEmpty(this.timePeriodFilter.filter.selectedValues)) || Object.values(this.objectiveFilters).some(filter => filter.length > 0);
        },
		getGroupOptions () {
			var teamsMap = {};
			_.each(this.teams, team => {
				teamsMap[team.id] = team;
			});
			var options = [];
			_.each(this.getObjectiveGroupList, group=> {
				var teamBaseItemLink = _.find(group.baseItemLinks, {type : "Objective-Group"});
				if(teamBaseItemLink) {
					if(teamBaseItemLink.teamId == "0") {
						options.push(group);
					}else{
						var team = teamsMap[teamBaseItemLink.teamId];
						if(team) {
							options.push({title : team.title, id : group.id});
						}
					}
				}
			});
			return options;
		}
    },

    watch: {
        teams: function (_new, _old) {
            this.filteredTeams = _new;
        },
        artCollections: {
            handler: function (_new, _old) {
                if (!_.isEmpty(_new)) {
                    this.collections = _new;
                }
            }
        },
        legacyThemeEnabled: {
            handler: function (newValue) {
                if (typeof newValue === "boolean") {
                    this.additionalSettingsLegacyThemeEnabled = newValue;
                    this.additionalSettingsLegacyThemeEnabledOriginal = newValue;
                    this.isAdditionalSettingsChanged = false;
                }
            }
        },
        "menuOptions.isOkrEnabled" :{
            handler: function(_new, _old){
                //If it's the main objective page only then show objective weights formula option in dropdown.
               let index = _.findIndex(this.statusAndEstimateFilters, {code: 'OBJ_KR_WEIGHTS_FORMULA'});
                if (this.menuOptions.isOkrEnabled && index === -1){
                    this.statusAndEstimateFilters.push({id: 6, code: 'OBJ_KR_WEIGHTS_FORMULA', name: 'Use Objective and Key Result Weights'});
                    this.selectedStatusEstimateFilter = this.statusAndEstimateFilters[this.statusAndEstimateFilters.length - 1];
                    localStorage.setItem("completion_criteria_" + this.activeBoard.session.id, JSON.stringify(this.selectedStatusEstimateFilter))
                    kendisStore.commit('setObjectiveCompletionCriteria', this.selectedStatusEstimateFilter);
                }else if (index > -1){
                    this.statusAndEstimateFilters.splice(index, 1);
                    index = _.findIndex(this.statusAndEstimateFilters, {code: 'CHILDREN_LINKED_ITEM_STATUS'});
                    this.selectedStatusEstimateFilter = this.statusAndEstimateFilters[index];
                    localStorage.setItem("completion_criteria_" + this.activeBoard.session.id, JSON.stringify(this.selectedStatusEstimateFilter))
                    kendisStore.commit('setObjectiveCompletionCriteria', this.selectedStatusEstimateFilter);
                }
            },
        },
		filteredObjectiveGroups: {
			handler: function(_new, _old) {
				this.filteredGroups = kendisStore.getters.getFilteredGroups();
			}
		}
    },

    created() {
        // Check export availability once when component is created
        var self = this;
        if (window.AppConfig && window.AppConfig.load) {
            window.AppConfig.load().then(function(config) {
                var exportServerUrl = config.exportServerUrl || config.exportserverUrl || config.export_server_url;
                self.isExportEnabled = typeof exportServerUrl === 'string' && exportServerUrl.trim().length > 0;
            }).catch(function(error) {
                self.isExportEnabled = false;
            });
        } else {
            console.log('AppConfig not available');
            this.isExportEnabled = false;
        }
        this.isLocalDeployment = $('meta[name="isLocalDeployment"]').attr("content") == "true";
		this.menuOptions = _.cloneDeep(this.objectiveMenuOptions);
        if(this.isMockingMode){
            this.activeBoard = this.board.session;
        }else {
            this.activeBoard = this.board;
        }
        this.$options.permissions = kendisStore.getters.getObjectiveAndOkrPermissions();
	},

    mounted() {
        if (typeof document !== 'undefined') {
            this.htmlElement = document.documentElement;
        }
        if(this.isMockingMode){
            this.activeBoard = this.board;}

        if (localStorage.getItem("completion_criteria_" + this.activeBoard.session.id)){
            this.selectedStatusEstimateFilter = JSON.parse(localStorage.getItem("completion_criteria_" + this.activeBoard.session.id));
        }else{
         this.selectedStatusEstimateFilter = this.statusAndEstimateFilters[1];
         localStorage.setItem("completion_criteria_" + this.activeBoard.session.id, JSON.stringify(this.selectedStatusEstimateFilter));
        }
        this.onSelectStatusEstimateFilter();
        this.filteredTeams = _.cloneDeep(this.teams);
        let searchQuery = kendisStore.getters.getObjectivesSearchQuery();
        if (!_.isEmpty(searchQuery)){
            this.searchQuery = searchQuery;
        }
		if(!this.isMockingMode && !this.isSolutionBoardPi && !this.isSosView) {
			let groups = JSON.parse(localStorage.getItem("filteredGroups_"+this.board.id));
			if(_.isEmpty(groups)) {
				groups = [];
				_.each(this.getObjectiveGroupList, obGrp=> {
					groups.push(obGrp.id);
				});
			}
			this.filteredGroups = groups;
		} else {
			this.filteredGroups = kendisStore.getters.getFilteredGroups();			
		}

        if (!_.isEmpty(this.artCollections)) {
            this.collections = this.artCollections;
        }
    },
	
    methods: {
        onClickOpenRoadmap(){
            this.isOkrRoadmapLoading = true;
            this.$emit("onOpenRoadmap");
        },

        onAddTeamClick: function () {
            //create team group objective
            this.showTeamSelection = true;
        },

        onAddCustomClick: function () {
			if (this.isMockingMode) {
				this.addMenu.show = true;
			}
			else {
				this.$emit("onAddCustomClickHandle", true);
			}
        },

        onSelectAddCustomObjective: function () {
			this.addMenu.show = false;
			this.$emit("onAddCustomClickHandle", true);
		},

		onSelectAddCollectionObjective: function () {
            if (this.addMenu.showCollections) {
                this.addMenu.showCollections = false;
                return;
            }
			if (kendisStore.getters.getArtCollections().length > 0) {
                let collections = kendisStore.getters.getArtCollections();
                collections = collections.filter(col => col.id && col.id !== "-1" && col.type);
                this.addMenu.collections = collections;
                this.collections = collections;
            }
			if (_.isEmpty(this.addMenu.collections)) {
				//....   load collections
				this.addMenu.loadingCollections = true;

				let _this = this;

				let data = {};
				data.fetchTypes = false;

				axios.post("/releasetrain/release-trains", data)
					.then(response => {
						_this.addMenu.loadingCollections = false;
						if (response.data) {
                            let collections = response.data.releaseTrains;
                            collections = collections.filter(col => col.id && col.id !== "-1" && col.type);
							_this.addMenu.collections = collections;
                            _this.collections = collections;
						}
					}).catch(error => {
						_this.addMenu.loadingCollections = false;
					});
			}
			else {
				this.addMenu.loadingCollections = false;
			}
            this.prepareCollections();
		},

        prepareCollections() {
            let collections = this.addMenu.collections;

            let collectionsToDisabled = [];
            this.getObjectiveGroupList.forEach(group => {
                group.baseItemLinks.forEach(link => {
                    if (link.linkType === 'art_link_objective' && link.sessionId !== "-1") {
                        collectionsToDisabled.push(link.sessionId);
                    }
                })
            });

            this.workspaceList = [];
            let rootWorkSpaces = [];
            let workspaceMap = {};

            _.each(collections, workspace => {
                if(_.isEmpty(workspaceMap[workspace.id])) {
                    workspaceMap[workspace.id] = {id: workspace.id, label: workspace.title, children: [], isDisabled: collectionsToDisabled.includes(workspace.id)};
                }
            })

            _.each(collections, workspace => {
                if(workspace.linkedWorkSpaces && workspace.linkedWorkSpaces.length > 0) {
                    _.each(workspace.linkedWorkSpaces, linkedWorkSpaceId => {
                        let parent = workspaceMap[linkedWorkSpaceId];
                        if(parent) {
                            parent.children.push(workspaceMap[workspace.id]);
                        }
                    });
                } else {
                    rootWorkSpaces.push(workspaceMap[workspace.id]);
                }
            });

            this.workspaceList = rootWorkSpaces;
            this.addMenu.showCollections = true;
        },

		onSelectCollection: function (collection) {
            const selectedCollection = this.collections.find(item => item.id === collection.id);

			this.addMenu.loadingCollections = false;
			this.addMenu.showCollections = false;
			this.addMenu.show = false;

			this.$emit("addCollectionObjectiveGroup", selectedCollection);
		},

        onSelectTeam: function (team) {
            if (!team.disabled) {
                this.showTeamSelection = false;
                team.disabled = true;
                this.$emit("addTeamObjectiveGroup", team);
            }
        },

        onClosePopupTeam: function () {
            this.showTeamSelection = false;
        },

        onSearchTeam: function () {
            let _this = this;
            _this.filteredTeams = [];
            if (_this.searchText === "") {
                _this.filteredTeams = _this.teams;
            } else {
                _.forEach(_this.teams, function (team) {
                    if (team.title.toLowerCase().includes(_this.searchTeam.toLowerCase())) {
                        _this.filteredTeams.push(team);
                    }
                });
            }
        },

        onSearchCollection() {
            let _this = this;
            _this.addMenu.collections = [];
            if (_this.searchCollection === "") {
                _this.addMenu.collections = _this.collections;
            } else {
                _.forEach(_this.collections, function (collection) {
                    if (collection.title.toLowerCase().includes(_this.searchCollection.toLowerCase()) || collection.key.toLowerCase().includes(_this.searchCollection.toLowerCase())) {
                        _this.addMenu.collections.push(collection);
                    }
                });
            }
        },

        onSelectStatusEstimateFilter: function (value) {
			if(!_.isEmpty(value)) {
				this.selectedStatusEstimateFilter = value;
			}
            localStorage.setItem("completion_criteria_" + this.activeBoard.session.id, JSON.stringify(this.selectedStatusEstimateFilter))
            kendisStore.commit('setObjectiveCompletionCriteria', this.selectedStatusEstimateFilter);
            this.$emit("updateCompletionCriteria",this.selectedStatusEstimateFilter.code);
        },

        onInputSearch: function (e) {
            kendisStore.commit("setObjectivesSearchQuery", this.searchQuery);
            this.objectiveFilters.search = this.searchQuery;
            this.$emit('onSearchInputChange', this.searchQuery, e.inputType);
        },

        onSaveCustomViewColumns(columns) {
            this.showSettingsPopup = false;
            let data = _.cloneDeep(this.customView);
            data.columnSettings = columns;
            axios.post('/objective/cv/save', data)
                .then(response => {
                    if (response.status === 200) {
                        showTopMessage("Columns settings updated!", 'success');
                        this.$emit("updateCustomViewSettings", response.data.view);
                    }
                })
                .catch(error => {
                    console.error(error);
                })
        },

		setObjectiveMenuSingleOption: function(key) {
			let requestBody = {};
			requestBody[key] = !this.menuOptions[key];
            if(this.isMockingMode){
                requestBody["sessionId"] = this.board.session.id;
            }else {
                requestBody["sessionId"] = vueInstance.activeBoard.session.id;
            }

			axios.post('objective/updateMenuPermissionBySessionId', requestBody)
			.then(response=> {
				if(response.status == "200"){
					if(key == "isOkrEnabled") {
						window.location.reload();
					}
		            kendisStore.commit('setObjectiveMenuSingleOption', {item: key});
				}
			})
			.catch(error => {
				console.log(error);
			});
		},

        onReportClick : function(type){
            this.$emit('exportReport', type);
        },

        onExportTypeClick: function(type) {
            this.exportOptions.exportType = type;
            this.exportOptions.showPopup = true;
            this.exportOptions.selectionType = 'default';
            this.exportOptions.selectedColumns = [];
            closeAllOverLay();
            
            // Ensure popup stays open during column selection
            this.$nextTick(() => {
                if (this.exportOptions.showPopup) {
                    // Add a flag to prevent accidental closing
                    this.exportOptions.preventClose = false;
                }
            });
        },

        onExportSelectionChange: function() {
            if (this.exportOptions.selectionType === 'default') {
                this.exportOptions.selectedColumns = [];
            } else if (this.exportOptions.selectionType === 'columnSelection') {
                // Pre-select default columns when column selection is chosen
                this.preSelectDefaultColumns();
            }
        },

        onExportColumnSelect: function(selectedColumns) {
            this.exportOptions.selectedColumns = selectedColumns;
            // Prevent popup from closing when selecting columns
            this.$nextTick(() => {
                if (!this.exportOptions.showPopup) {
                    this.exportOptions.showPopup = true;
                }
            });
        },

        preSelectDefaultColumns: function() {
            let defaultColumns = ['title'];
            if (this.$parent && this.$parent.getColumnSettings) {
                const columnSettings = this.$parent.getColumnSettings;
                if (columnSettings && Array.isArray(columnSettings)) {
                    defaultColumns = defaultColumns.concat(columnSettings);
                }
            }

            this.exportOptions.selectedColumns = [...new Set(defaultColumns)];
        },

        confirmExport: function() {
            if (this.exportOptions.selectionType === 'columnSelection' && (!this.exportOptions.selectedColumns || this.exportOptions.selectedColumns.length === 0)) {
                showTopMessage("Please select at least one column for export.", "warning");
                return;
            }

            // Prepare export configuration for parent component
            const exportConfig = {
                type: this.exportOptions.exportType, // 'csv' or 'xls'
                selectionType: this.exportOptions.selectionType, // 'default' or 'columnSelection'
                selectedColumns: this.exportOptions.selectedColumns, // Array of selected column objects
                isDefaultExport: this.exportOptions.selectionType === 'default',
            };
            this.closeExportPopup();
            this.startExportWithProgress(exportConfig);
        },

        closeExportPopup: function() {
            this.exportOptions.showPopup = false;
            this.exportOptions.exportType = '';
            this.exportOptions.selectionType = 'default';
            this.exportOptions.selectedColumns = [];
            this.exportOptions.preventClose = false;
        },

        // Method to prevent popup from closing during column selection
        preventPopupClose: function(event) {
            event.stopPropagation();
            event.preventDefault();
        },

        // Start export with progress tracking using existing helpers
        startExportWithProgress: function(exportConfig) {
            // Initialize progress tracking UI
            this.exportRequestId = getNewUUID();
            // Mirror to ProgressBar props
            this.showProgress = true;
            this.currentProgress = 0;
            this.exportError = false;
            this.downloadSuccessful = false;

            // Let parent perform the actual request using the same requestId
            // so both sides share the poll key
            this.$emit('exportTheme', exportConfig, this.exportRequestId);

            // Use existing polling utility
            var _this = this;
            startPoll(this.exportRequestId, function(data){
                if(data && typeof data.progress !== 'undefined'){
                    _this.currentProgress = parseInt(data.progress || 0, 10);
                }
                if(data && (data.srcPath || data.name || data.path)){
                    // Final payload received via stored content, trigger download helper
                    downloadFromPath(data);
                    _this.downloadSuccessful = true;
                    setTimeout(function(){
                        _this.showProgress = false;
                    }, 1200);
                }
            }, this, 2000);
        },

        // Handle errors using existing helpers only
        handleExportError: function(errorMessage) {
            showTopMessage(errorMessage, "error");
            var _this = this;
            setTimeout(function(){
                _this.showProgress = false;
                _this.exportRequestId = null;
            }, 3000);
        },

        // Cancel export
        cancelExport: function() {
            // Signal backend to cancel the export job using the same requestId
            try {
                if (this.exportRequestId) {
                    axios.post('/objective/export/cancel', { requestId: this.exportRequestId })
                        .then(() => { showTopMessage('Cancelling export...', 'info'); })
                        .catch((error) => { console.error('Failed to cancel export:', error); });
                }
            } catch(e){ console.error('Error stopping poll:', e); }
            // stop global poll interval for this id as well
            if (typeof stopPoll === 'function' && this.exportRequestId){
                stopPoll(this.exportRequestId);
            }
            
            this.showProgress = false;
            this.exportRequestId = null;
            
            showTopMessage("Export cancelled", "info");
        },
        closeProgress: function(){
            this.showProgress = false;
        },

        resetFilters() {
            this.objectiveFilters.responsible = [];
            this.objectiveFilters.collections = [];
            this.objectiveFilters.statuses = [];
            this.objectiveFilters.search = "";
            this.searchQuery = "";
            this.timePeriodFilter.filter = {};
            this.$emit('resetFilters');
        },

        onTimePeriodFilter(value) {
            if (_.isEmpty(value)) {
                this.timePeriodFilter.filter = {};
            } else {
                this.timePeriodFilter.filter = value;
            }
            this.$emit('onTimePeriodFilter', this.timePeriodFilter.filter);
        },

        onFilterResponsible(responsibles) {
            this.objectiveFilters.responsible = responsibles;
            this.$emit('onFilterResponsible', this.objectiveFilters.responsible);
        },

        onFilterAssociation(collections) {
            this.objectiveFilters.collections = collections;
            this.$emit('onFilterAssociation', this.objectiveFilters.collections);
        },

        onFilterStatus(statuses) {
            this.objectiveFilters.statuses = statuses;
            this.$emit('onFilterStatus', this.objectiveFilters.statuses);
        },

        onClickExport: function (){
            this.showExportPopup = 'block';
        },

        onClosePopup : function () {
            this.showExportPopup = 'none';
        },

        redirectToWorkFlow: function () {
            window.location.href="administration#workflow";
        },

        saveExcludeItemsSettings : function(statsExclusion){
            let _this = this;
            _this.openExcludeItemSettings 	= false;
            if (statsExclusion.viewType === VIEW_NAME_ENUM.OBJECTIVES_EXCLUDEITEMS_VIEWTYPE.code){
                _this.$emit("save-excluded-items", statsExclusion.excludedItems);
            }
        },

        handleESCEvent: function (event){
            let objSettingsElement = document.getElementById("obj_settings");
            if (event.key === 'Escape' || event.keyCode === 27) {
                objSettingsElement.style.display = "none";
            }
        },

        setAutoFocus: function () {
            let objSettingsElement = document.getElementById("obj_settings");
            if (objSettingsElement.style.display === "block") {
                this.$refs.objSettings.focus();
            }
        },

        toggleExpand: function () {
            this.isAllExpand = !this.isAllExpand;
            this.$emit("toggleExpand", this.isAllExpand);
        },
		viewUnLinkedItems: function() {
			this.showUnLinkedItems = !this.showUnLinkedItems;
			kendisStore.commit('setShowUnLinkedItems', this.showUnLinkedItems)
		},
		getEstimateIconClass: function() {
            if (this.selectedStatusEstimateFilter) {
                if (this.selectedStatusEstimateFilter.code === 'OBJ_KR_WEIGHTS_FORMULA') {
                    return 'f';
                } else if (this.selectedStatusEstimateFilter.code === 'LINKED_ITEM_STATUS') {
                    return 'a';
                } else if (this.selectedStatusEstimateFilter.code === 'CHILDREN_LINKED_ITEM_STATUS') {
                    return 'b';
                } else if (this.selectedStatusEstimateFilter.code === 'CHILDREN_LINKED_ITEM_ESTIMATE') {
                    return 'c';
                } else if (this.selectedStatusEstimateFilter.code === 'TEAM_STORY_STATUS') {
                    return 'd';
                } else if (this.selectedStatusEstimateFilter.code === 'TEAM_STORY_ESTIMATE') {
                    return 'e';
                }
            }
		},
		onClickShowCheckIns: function() {
			this.$emit('show-check-ins');
		},
		updateObjectiveWorkspace: function(workspace) {
			this.showSettingsPopup = false;
			this.$emit('update-objective-workspace', workspace);
		},
		updateFilteredGroups: function() {
			
			let groups = [];
			if(this.filteredGroups) {
				groups = this.filteredGroups;
			} else {
				groups = [];				
			}
			kendisStore.commit("setFilteredGroups", groups);
			
			let queryString = window.location.search;
			const urlParams = new URLSearchParams(queryString);
			let viewIndex = urlParams.get("moreOptionsIndex");
			if(!_.isEmpty(viewIndex) && viewIndex == 3) {			
				localStorage.setItem("filteredGroups_"+this.board.id, JSON.stringify(groups));
			}
		},
        showStrategicThemes() {
            this.$emit("showStrategicThemes");
        }
    }
});

let OBJECTIVE_SETTINGS_MENU = Vue.component('objective-settings-popup', {
	template :/*html*/`
		<div class="detailPopUps">
			<div class="overlay" style="display: block;"></div>
			<div class="ui-dialog set-pop add-pop detaildialog p-fix" style="display: block;">
				<div class="head pb-0 brdrnone">
		            <div class="DFA JB pb-20">
						<span class="fs-20 ftsb pl-10" v-if="type === 'release-train' ">Backlog Items Column Settings</span>
						<span class="fs-20 ftsb pl-10" v-else>Settings</span>
						<div class="DFA">
							<a href="javascript:void(0);" title="Close" tabindex="-1" class="rmv-ico ti-close rnd DAJ" @click="$emit('close')"></a>
<!--							<button class="p-abs svout b"  @click="onSaveAccessRoles"> Save </button>-->
						</div>
					</div>
					
					<div class="maintabs">
			        	<div class="tabgenrl" v-if="type !== 'customView'" :class="[tab == 0?'active':'']" @click="onChangeTab(0, type)">
			        	    <template v-if="type === 'release-train'">
                                <label class="ftsb clrblck DIB mb-0 c-point" >Columns</label>
                                <span class="infotxt  ml-5 lngtip tooltip tipher">
                                    <span class="hovtooltip wht-nwrp">Default Columns For Backlog Items</span>
                                </span>
							</template>
							<template v-else>
			        		<label class="ftsb clrblck DIB mb-0 c-point" >Basic Details</label>
							<span class="infotxt  ml-5 lngtip tooltip tipher">
								<span class="hovtooltip wht-nwrp">Basic Details</span>
							</span>
							</template>
						</div>
						<div  v-if="type !== 'objective' && type !== 'customView'" class="tabgenrl" :class="[tab == 1?'active':'']" @click="onChangeTab(1, type)">
						    <template v-if = "type === 'release-train'">
                                <label class="ftsb clrblck DIB mb-0 c-point" >Default Filter</label>
                                <span class="infotxt  ml-5 lngtip tooltip tipher">
                                    <span class="hovtooltip wht-nwrp">Default Filter For Backlog Items</span>
                                </span>
							</template>
						    <template v-else>
                                <label class="ftsb clrblck DIB mb-0  c-point" >Users & Permissions</label>
                                <span class="infotxt  ml-5 lngtip tooltip tipher">
                                    <span class="hovtooltip wht-nwrp">Users & Permissions</span>
                                </span>
							</template>
						</div>
						<div v-if="type === 'release-train'" class="tabgenrl" :class="[tab == 2?'active':'']" @click="onChangeTab(2, type)">
                            <label class="ftsb clrblck DIB mb-0 c-point" >Default Item Settings</label>
                            <span class="infotxt  ml-5 lngtip tooltip tipher">
                                <span class="hovtooltip wht-nwrp">Default Settings For Creating New Backlog Item</span>
                            </span>		
						</div>
                        <div v-if="['objective','customView'].includes(type)" class="tabgenrl" :class="[tab == 3 ? 'active':'']" @click="onChangeTab(3, type)">
                            <label class="ftsb clrblck DIB mb-0 c-point">Columns for Listing</label>
                            <span class="infotxt  ml-5 lngtip tooltip tipher">
                                <span class="hovtooltip wht-nwrp">OKR Listing Columns</span>
                            </span>
                        </div>
                        <div v-if="type === 'objective' || (type === 'customView' && !_.isEmpty(customView))" class="tabgenrl" :class="[tab == 5 ? 'active':'']" @click="onChangeTab(5, type)">
                            <label class="ftsb clrblck DIB mb-0 c-point">Columns for Linked Items</label>
                            <span class="infotxt  ml-5 lngtip tooltip tipher">
                                <span class="hovtooltip wht-nwrp">Linked Items Columns</span>
                            </span>
                        </div>
                        <div v-if="type === 'customView' && _.isEmpty(customView)" class="tabgenrl" :class="[tab == 6 ? 'active':'']" @click="onChangeTab(6, type)">
                            <label class="ftsb clrblck DIB mb-0 c-point">Columns for Strategic Themes</label>
                            <span class="infotxt  ml-5 lngtip tooltip tipher">
                                <span class="hovtooltip wht-nwrp">Column Settings for Strategic Themes List View</span>
                            </span>
                        </div>
                        <div v-if="type === 'customView' && _.isEmpty(customView) && legacyGroupsCount === 0" class="tabgenrl" :class="[tab == 7 ? 'active':'']" @click="onChangeTab(7, type)">
                            <label class="ftsb clrblck DIB mb-0 c-point">Additional Settings</label>
                            <span class="infotxt  ml-5 lngtip tooltip tipher">
                                <span class="hovtooltip wht-nwrp">Additional Settings for Strategic Themes</span>
                            </span>
                        </div>
						<!--<div class="tabgenrl" :class="[tab == 3?'active':'']" @click="tab = 3">
							<label class="ftsb clrblck DIB mb-0  c-point">Check-In Settings</label> 
							<span class="infotxt  ml-5 lngtip tooltip tipher">
								<span class="hovtooltip wht-nwrp">Check-In Settings</span>
							</span>
						</div>						
						<div class="tabgenrl" :class="[tab == 2?'active':'']" @click="tab = 2">
							<label class="ftsb clrblck DIB mb-0  c-point">Other Settings</label> 
							<span class="infotxt  ml-5 lngtip tooltip tipher">
								<span class="hovtooltip wht-nwrp">Other Settings</span>
							</span>
						</div>-->
					</div>
		        </div>
				<div class="popUpWraper detailpop backlogSettingsPopUp">
					<div class="pd-10 pb-0" v-if="tab == 0">
					    <div class="popUpBody">
                             <div v-if="workspaceObj" class="DFA pd-10 mt-20">
                                    <label class="ftsb mb-0 mr-5">Title</label>
                                    <input class="w-60pc" type="text" v-model="workspaceObj.title" @change="onChangeWorkSpaceTitle" />
                                    <span class="w-30pc  infotxt  DIB ml-15 tooltip"><span class="hovtooltip">This will be the name of the module</span></span>
                                </div>
                             <div class="pd-10 pl-20" v-if="type === 'release-train' && !_.isEmpty(hierarchyLevels)">
                                    <label>Select Hierarchy Level</label>
                                    <div class="DFA a">
                                        <div class="selectcont w-350 linkitemBorderRadius">
                                            <vz-select 
                                                :options="hierarchyLevels" 
                                                v-model="currentSelectedHierarchyLevelForColumns" 
                                                label="title" 
                                                track-by="id" 
                                                :multiple="false" 
                                                @select="value => onSelectHierarchy(value, 'columns')"
                                            ></vz-select>
                                        </div>
                                        <a href="javascript:void(0);" class="text ml-20 und" @click="viewItemHierarchy">View Linked Hierarchy</a>
                                    </div>
                                </div>
                              <!--<div v-if="type === 'release-train' && !_.isEmpty(filterCriteriaList)" class="rec lblm" style="block !important;">
                                    <label>Select Default Filter</label>
                                    <div class="selectcont">
                                        <vz-select label="name" 
                                            empty-selection-text="Saved Filters" class="multi-filter"
                                            value-type="object" v-model="selectedCriteria" 
                                            :options="filterCriteriaList"
                                        />
                                    </div>
                                     <a v-if="!_.isEmpty(defaultFilter) && !removeDefaultCriteria" href="javascript:void(0);" @click="onRemoveDefaultFilter" class="reset url mt-5 DIB a">Remove Default Filter</a>
                                </div>-->
                             <div v-if="type !== 'objective'" class="pd-10 pl-20 linkedColumns">
                                    <label>Select Columns for Linked Items</label>
                                    <span class="mb-10 light DB">Select layout of this view. Add, remove and reorder columns.</span>
                                     <draggable :list="selectedColumns" fallbackTolerance="1" direction="vertical"  ghost-class="ghost-item" delay=100 animation=150 easing="cubic-bezier(1, 0, 0, 1)" @start="onItemDragStart" @end="onItemDragEnd" >
                                        <div v-for="(column, columnIndex) in selectedColumns" :key="columnIndex" class="selectcont wht h-auto mb-10 moveout w-470 linkitemBorderRadius">
                                            <div class="moveico" style="left:-20px;top:10px;"></div>
                                            <vz-select label="title" track-by="id" :title="column.title" :disabled="!column.editable"
                                                :empty-selection-text="column.title" class="multi-filter"
                                                value-type="object"  v-model="selectedColumnValue[columnIndex]"
                                                :options="$options.columnOptions" @select="onColumnSelectValue(columnIndex)"
                                            />
                                            <a v-if="selectedColumns.length > 1" class="rmv p-abs ti-trash" style="top:12px; right:-20px" href="javascript:void(0);" @click="onRemoveColumn(columnIndex)"></a>
                                        </div>
                                    </draggable>
                                    <a class="ti-plus addf" href="javascript:void(0);" title="Add Column" @click="addNewColumn">Add Column</a>
                             </div>
                        </div>
                         <div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD; padding: 15px 10px;">
						    <button class="svout c rnd4" @click="handleSaveAction">Save</button>
						 </div>
					</div>
					<div class="pd-10 pb-0" v-else-if="tab == 1">
                        <div class="popUpBody">
                            <template v-if="type === 'release-train' ">
                                <div class="pd-10" v-if="!_.isEmpty(hierarchyLevels)">
                                    <label>Select Hierarchy Level</label>
                                    <div class="DFA b">
                                    <div class="selectcont w-350 linkitemBorderRadius">
                                        <vz-select 
                                            :options="hierarchyLevels" 
                                            v-model="currentSelectedHierarchyLevelForFilter" 
                                            label="title" 
                                            track-by="id" 
                                            :multiple="false" 
                                            @select="value => onSelectHierarchy(value, 'filter')"
                                        ></vz-select>
                                    </div>
                                    <a href="javascript:void(0);" class="text ml-20 und" @click="viewItemHierarchy">View Linked Hierarchy</a>
                                    </div>
                                </div>
                                <div class="pd-10" style="block !important;">
                                    <label>Select Default Filter</label>
                                    <div class="DFA" v-if="!_.isEmpty(filterCriteriaList)">
                                        <div class="selectcont w-470 linkitemBorderRadius">
                                            <vz-select label="name" 
                                                empty-selection-text="Saved Filters" class="multi-filter"
                                                value-type="object" v-model="selectedCriteria" 
                                                :options="filterCriteriaList"
                                                @select="onSelectDefaultFilter"
                                            />
                                        </div>
                                        <a v-if="!_.isEmpty(defaultFilter) && !removeDefaultCriteria" href="javascript:void(0);" @click="onRemoveDefaultFilter" class="reset und url ml-20 DIB b">Remove Default Filter</a>
                                    </div>
                                    <template v-else>
                                        <div class="nofound">No Saved Filters Found. Kindly create a new filter to set as default.</div>			
                                    </template>
                                     
                                </div>
                            </template>
                            <template v-else>
                                <roles-permission :workspaceId="workspace.id" @update="onUpdateAccessRoles"></roles-permission>
                            </template>
                        </div>
						<div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD;padding: 15px 10px;">
						    <button  class="svout d" @click="handleSaveAction" >Save</button>
						</div>
					</div>
					<div  v-else-if="tab == 1">
						<roles-permission :workspaceId="workspace.id" @update="onUpdateAccessRoles"></roles-permission>
					</div>
					<div class="pd-10 pb-0" v-else-if="tab == 2">
					    <div class="popUpBody">
                            <div class="pd-20 brd-bt" v-if="!_.isEmpty(hierarchyLevels)">
                                <label>Hierarchy Level</label>
                                <div class="DFA c">
                                <div class="selectcont w-350 linkitemBorderRadius">
                                    <vz-select 
                                        empty-selection-text="Select Hierarchy Level" 
                                        :options="hierarchyLevels" 
                                        v-model="currentSelectedHierarchyLevelForItem" 
                                        label="title" 
                                        track-by="id" 
                                        :multiple="false" 
                                        @select="value => onSelectHierarchy(value, 'item')"
                                    ></vz-select>
                                </div>
                                <a href="javascript:void(0);" class="text ml-20 und" @click="viewItemHierarchy">View Linked Hierarchy</a>
                                </div>
                            </div>
                            <div class="pd-20 custom-checkbox pt-30">
                                <input id="restrictionEnabledCheckBox" type="checkbox" :checked="enableProjectRestriction" @change="onToggleRestriction"/>
                                <label for="restrictionEnabledCheckBox" class="mn blk" id="restrictionEnabledLabel">Restrict Projects And Issue Types</label>
                            </div>
    
                            <template v-if="!isRestrictionEnabled">
                                <div class="pd-20 c DFA brd-bt pt-0">
                                    <div class="aa mr-20 w-350" style="block !important;">
                                        <label>Default Project  <a href="javascript:void(0);" class="FR more und" @click="loadProjectPopup">Find Project</a></label>
                                        <template v-if="showProjectsDropdown">
                                            <div class="selectcont linkitemBorderRadius">
                                                <vz-select label="name" 
                                                    empty-selection-text="Select Default Project" class="multi-filter"
                                                    value-type="object" v-model="selectedDefaultProject" 
                                                    :options="projectsList"
                                                    @select="onSelectDefaultProject"
                                                />
                                            </div>
                                        </template>
                                        <template v-else>
                                            <div class="nofound t-left">No Projects Found.</div>	
                                        </template>
                                       
                                        <tfs-link-projects v-if="alm.type === 'tfs' && showProjectPopup"
                                            :alm="alm"
                                            :linked-projects="tfsProjects"
                                            :release-train-key="releaseTrain.key"
                                            @linked="onLinkTfsProject"
                                            @close="showProjectPopup = false;"></tfs-link-projects>
                                            
                                        <template v-if="jiraLoader.show">
                                             <div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE">{{jiraLoader.text}}</span></div></div> 
                                        </template>
                                            
                                        <jira-explorer v-if="alm.type === 'jira' && showProjectPopup" @close="showProjectPopup = false;" :selected-items="jiraProjectLinkPopupSelectedItems" :alm-account="alm"  type="projects" @select="onLinkJiraProject" ></jira-explorer>
                                    </div>
                                    <div v-if="showDefaultIssueTypeDropdown" class="bb w-350" style="block !important;">
                                        <label>Default Item Type</label>
                                        <div class="selectcont linkitemBorderRadius">
                                            <template v-if="alm.type === 'tfs'">
                                                <vz-select :multiple="false" label="name" 
                                                    empty-selection-text="Select Default Item Type" class="multi-filter"
                                                    value-type="object" v-model="selectedDefaultItemType" track-by="referenceName"
                                                    :options="tfsItemTypes"
                                                    @select="onSelectDefaultIssuetype"
                                                />
                                            </template>
                                            <template v-else>
                                                <div v-if="jiraIssueTypesLoading" class="loader"><div><div class="loaderinteg"></div>Loading ...</div></div>
                                                <vz-select v-else :multiple="false" label="name" 
                                                    empty-selection-text="Select Default Issue Type" class="multi-filter"
                                                    value-type="object" v-model="selectedDefaultItemType" track-by="id"
                                                    :options="jiraIssueTypes"
                                                    @select="onSelectDefaultIssuetype"
                                                />
                                            </template>
                                        </div>
                                    </div>
                                    <div v-if="selectedDefaultProject && selectedDefaultProject.id !== '-1' && ( (alm.type === 'jira' && !jiraIssueTypesLoading && _.isEmpty(jiraIssueTypes)) || (alm.type === 'tfs' && _.isEmpty(tfsItemTypes)) )" class="nofound bb w-350 txt-strt mb-0 mt-20">No issue types found against this hierarchy level.</div>	
                                </div>
                                <div v-if="alm.type === 'jira' && !_.isEmpty(selectedDefaultItemType)" id="default-item-status" class="pd-10 c DFA brd-bt pt-25 pb-25" style="block !important; padding-right: 0;">
                                    <label>Default Status</label> 
                                    <div class="selectcont w-350">
                                        <div v-if="jiraStatusesLoading" class="loader"><div><div class="loaderinteg"></div>Fetching Statuses</div></div>                                
                                        <vz-select v-else label="title" 
                                            empty-selection-text="Select Default Status" class="multi-filter"
                                            value-type="object" v-model="selectedDefaultStatus" track-by="id"
                                            :options="statuses"
                                        />                       
                                    </div>
                                </div>
                                <div v-if="alm.type === 'jira' && !_.isEmpty(selectedDefaultItemType) " id="default-jira-fields" class="pd-10 c DFA brd-bt pt-25 pb-25" style="block !important; padding-right: 0;">
                                    <h2 class="hd jira prow">
                                        <span class="txt">Jira Fields</span>
                                         <div class="selectcont clrd ddConfigJiraFields">
                                            <vz-select label="name" 
                                                empty-selection-text="Select Jira Fields" class="multi-filter" selected-title="Select Jira Fields" value-type="object" 
                                                track-by="key" :options="jiraFieldsOptions"
                                                @select="onSelectJiraFieldDropdownValue"
                                            />
                                        </div>
                                    </h2>
                                    <!-- <span class='txt'>Jira Fields</span> -->
                                   
                                    <div v-if="defaultJiraFieldOptions && defaultJiraFieldOptions.length > 0" class="rec restrecrd" style="block !important;">
                                        <draggable :list="defaultJiraFieldOptions" fallbackTolerance="1" direction="vertical" class="wbox"  ghost-class="ghost-item" delay=100 animation=150 easing="cubic-bezier(1, 0, 0, 1)"  @end="onEndDrag" >
                                            <div v-for="jiraField in defaultJiraFieldOptions" class="moveout ">
                                            <div class="inn p-rel DFA">
                                                <div class="moveico ti-move"></div>
                                                <div class="ttl rc c1">{{ jiraField.name }}</div>
                                                <div class="DAJ p-abs icons">
                                                    <template v-if="!jiraField.required">
                                                    <a href="javascript:void(0)" class="ti-more-alt fmico ico" @click="jiraField.showMenuOverlay = !jiraField.showMenuOverlay"></a>
                                                    <vuepopup v-if="jiraField.showMenuOverlay" @close="jiraField.showMenuOverlay=false;">
                                                        <div class="drop_box nwmu arr-top add" style="display:block;">
                                                            <ul>
                                                                <li class="c-point" @click.stop="onRemoveJiraField(jiraField)">Remove</li>
                                                            </ul>
                                                        </div>
                                                    </vuepopup>
                                                    </template>
                                                    <template v-else>
                                                    <span class="infotxt  ml-5 lngtip tooltip tipher">
                                                        <span class="hovtooltip wht-nwrp">This is a required field. It cannot be removed.</span>
                                                    </span>
                                                    </template>
                                                </div>
                                            </div>
                                            </div>
                                        </draggable>
                                   </div>
                                </div>
                            </template>
                            
                            <template v-else>
                                <div class="pd-20 c DFA brd-bt pt-0">
                                     <div class="b w-350 mr-20">
                                        <label>Allowed Projects <a href="javascript:void(0);" class="FR more und" @click="loadProjectPopup">Find Project</a></label>
                                        <template v-if="showProjectsDropdown">
                                            <div class="selectcont linkitemBorderRadius">
                                                <vz-select label="name" 
                                                    empty-selection-text="Select Project" class="multi-filter"
                                                    value-type="object" v-model="selectedRestrictedProject" 
                                                    :options="projectsList"
                                                    @select="onSelectDefaultProject"
                                                />
                                            </div>
                                        </template>
                                        <template v-else>
                                            <div class="nofound t-left">No Projects Found.</div>
                                        </template>
                                        
                                        <tfs-link-projects v-if="alm.type === 'tfs' && showProjectPopup"
                                            :alm="alm"
                                            :linked-projects="tfsProjects"
                                            :release-train-key="releaseTrain.key"
                                            @linked="onLinkTfsProject"
                                            @close="showProjectPopup = false;"></tfs-link-projects>
                                            
                                        <template v-if="jiraLoader.show">
                                             <div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE">{{jiraLoader.text}}</span></div></div> 
                                        </template>
                                            
                                        <jira-explorer v-if="alm.type === 'jira' && showProjectPopup" @close="showProjectPopup = false;" :selected-items="jiraProjectLinkPopupSelectedItems" :alm-account="alm"  type="projects" @select="onLinkJiraProject" ></jira-explorer>	
                                     </div>                                
                                     <div v-if="showRestrictedIssueTypeDropdown" class="pd-10" style="block !important; width: 350px; paddin-right: 0;">
                                        <label>Allowed Issue Types</label>                                
                                        <template v-if="alm.type === 'tfs'">
                                            <div class="selectcont linkitemBorderRadius">
                                                <vz-select label="name" 
                                                    empty-selection-text="Select Default Item Type" :multiple="true" class="multi-filter"
                                                    value-type="object" v-model="selectedRestrictedIssueTypes" track-by="referenceName"
                                                    :options="tfsItemTypes" 
                                                />
                                            </div>
                                        </template>
                                        <template v-else>
                                            <div v-if="jiraIssueTypesLoading" class="loader"><div><div class="loaderinteg"></div>Loading ...</div></div>
                                            <div class="selectcont linkitemBorderRadius" v-else>
                                                <vz-select label="name" 
                                                    empty-selection-text="Select Default Issue Type" :multiple="true" class="multi-filter"
                                                    value-type="object" v-model="selectedRestrictedIssueTypes" track-by="id"
                                                    :options="jiraIssueTypes" 
                                                />
                                            </div>
                                        </template>                                
                                     </div>
                                     <div v-if="!_.isEmpty(this.selectedRestrictedProject) && ( (alm.type === 'jira' && !jiraIssueTypesLoading && _.isEmpty(jiraIssueTypes)) || (alm.type === 'tfs' && _.isEmpty(tfsItemTypes)) )" class="nofound bb w-350 txt-strt mb-0 mt-20">No issue types found against this hierarchy level.</div>	
                                    
                                     <div v-if="!_.isEmpty(selectedRestrictedProject) && !_.isEmpty(selectedRestrictedIssueTypes)" class="pt-20">
                                          <button @click="editRestriction ? updateRestriction() : addRestriction()" class="addStory">
                                            {{ editRestriction ? 'Update' : 'Add' }}
                                         </button>
                                     </div>
                                </div>
                               <div v-if="restrictedProjectsAndIssueTypes && restrictedProjectsAndIssueTypes.length > 0" class="pd-10 restrecrd" style="block !important;">
                                    <draggable :list="restrictedProjectsAndIssueTypes" fallbackTolerance="1" direction="vertical" class="wbox"  ghost-class="ghost-item" delay=100 animation=150 easing="cubic-bezier(1, 0, 0, 1)"  @end="onEndDrag" >
                                        <div v-for="(restrictionObject, restrictionObjectIndex) in restrictedProjectsAndIssueTypes" :key="restrictionObjectIndex" class="moveout ">
                                        <div class="inn p-rel DFA">
                                            <div class="moveico ti-move"></div>
                                            <div class="ttl rc c1">{{ restrictionObject.restrictedProject.name }}</div>
                                            <div class="rc c1">
                                            <div class="spttg DIB FN" v-for="(issueType, issueTypeIndex) in restrictionObject.restrictedIssueTypes" :key="issueTypeIndex">
                                                <span clas="ftsb DIB fs-12" style="font-size: 11px;">{{ issueType.name }}</span> 
                                            </div>
                                            </div>
                                            
                                            <div class="DAJ p-abs icons">
                                                <a href="javascript:void(0)" class="ti-more-alt fmico ico" @click="restrictionObject.showMenuOverlay = !restrictionObject.showMenuOverlay"></a>
                                                <vuepopup v-if="restrictionObject.showMenuOverlay" @close="restrictionObject.showMenuOverlay=false;">
                                                    <div class="drop_box nwmu arr-top add rnd6" style="display:block;">
                                                        <ul>
                                                            <li class="c-point" @click.stop="onEditRestrictedObject(restrictionObject, restrictionObjectIndex)">Edit</li>
                                                            <li class="c-point" @click.stop="onRemoveRestrictedObject(restrictionObject)">Remove</li>
                                                        </ul>
                                                    </div>
                                                </vuepopup>
                                            </div>
                                        </div>
                                        </div>
                                    </draggable>
                               </div> 
                            </template> 
                        </div>
                        <div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD;padding: 15px 10px;">
                            <button class="svout a" @click="handleSaveAction">Save</button>   
                       </div>                    
                    </div>
                    <div class="pd-10 pb-0" v-if="tab == 3">
                        <div class="popUpBody">
                            <div class="pd-10 pl-20">
                                <label>Select Columns for {{type === 'customView' && customView ? 'Strategic Theme OKRs' : 'Objectives'}}</label>
                                <span class="mb-10 light DB">Select layout of OKRs view. Add, remove and reorder columns.</span>
                                <draggable :list="selectedOKRColumns" fallbackTolerance="1" direction="vertical" ghost-class="ghost-item" delay=100 animation=150 easing="cubic-bezier(1, 0, 0, 1)" @start="onOkrItemDragStart" @end="onOkrItemDragEnd">
                                    <div v-for="(column, index) in selectedOKRColumns" :key="index" class="selectcont wht h-auto mb-10 moveout w-470 linkitemBorderRadius">
                                        <div class="moveico"style="left:-20px;top:10px;"></div>
                                        <vz-select label="title" track-by="id" :options="okrColumnOptions" value-type="object" class="multi-filter" :title="column.title"
                                            :empty-selection-text="column.title" v-model="selectedOKRColumnValues[index]" @select="onOkrColumnSelectValue(index)"
                                        />
                                        <a v-if="selectedOKRColumns.length > 1" class="rmv p-abs ti-trash" style="top:12px; right:-20px" href="javascript:void(0);" @click="onRemoveOkrColumn(index)"></a>
                                    </div>
                                </draggable>
                                <a class="ti-plus addf" v-if="selectedOKRColumns.length < 4" href="javascript:void(0);" title="Add Column" @click="addNewOkrColumn">Add Column</a>
                            </div>
                        </div>
                        <div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD; padding: 15px 10px;">
						    <button class="svout c rnd4" @click="handleSaveAction">Save</button>
						</div>
                    </div>
                    <div class="pd-10 pb-0" v-if="tab == 5">
                        <div class="popUpBody">
                            <div class="pd-10 pl-20 linkedColumns">
                                <label>Select Columns for Linked Items</label>
                                <span class="mb-10 light DB">Select layout of this view. Add, remove and reorder columns.</span>
                                <draggable :list="selectedColumns" fallbackTolerance="1" direction="vertical"  ghost-class="ghost-item" delay=100 animation=150 easing="cubic-bezier(1, 0, 0, 1)" @start="onItemDragStart" @end="onItemDragEnd" >
                                    <div v-for="(column, columnIndex) in selectedColumns" :key="columnIndex" class="selectcont wht h-auto mb-10 moveout w-470 linkitemBorderRadius">
                                        <div class="moveico" style="left:-20px;top:10px;"></div>
                                        <vz-select label="title" track-by="id" :title="column.title" :disabled="!column.editable"
                                            :empty-selection-text="column.title" class="multi-filter"
                                            value-type="object"  v-model="selectedColumnValue[columnIndex]"
                                            :options="$options.columnOptions" @select="onColumnSelectValue(columnIndex)"
                                        />
                                        <a v-if="selectedColumns.length > 1" class="rmv p-abs ti-trash" style="top:12px; right:-20px" href="javascript:void(0);" @click="onRemoveColumn(columnIndex)"></a>
                                    </div>
                                </draggable>
                                <a class="ti-plus addf" href="javascript:void(0);" title="Add Column" @click="addNewColumn">Add Column</a>
                            </div>
                        </div>
                        <div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD; padding: 15px 10px;">
						    <button class="svout c rnd4" @click="handleSaveAction">Save</button>
						</div>
                    </div>
                    <div class="pd-10 pb-0" v-if="tab == 6">
                        <div class="popUpBody">
                            <div class="pd-10 pl-20">
                                <label>Select Columns for Strategic Themes</label>
                                <span class="mb-10 light DB">Select layout of Strategic themes view. Add, remove and reorder columns.</span>
                                <draggable :list="selectedCVColumns" fallbackTolerance="1" direction="vertical" ghost-class="ghost-item" delay=100 animation=150 easing="cubic-bezier(1, 0, 0, 1)" @start="onCVItemDragStart" @end="onCVItemDragEnd">
                                    <div v-for="(column, index) in selectedCVColumns" :key="index" class="selectcont wht h-auto mb-10 moveout w-470 linkitemBorderRadius">
                                        <div class="moveico"style="left:-20px;top:10px;"></div>
                                        <vz-select label="title" track-by="id" :options="cvColumnOptions" value-type="object" class="multi-filter" :title="column.title"
                                            :empty-selection-text="column.title" v-model="selectedCVColumnValues[index]" @select="onCVColumnSelectValue(index)"
                                        />
                                        <a v-if="selectedCVColumns.length > 1 && column.id !== 'title'" class="rmv p-abs ti-trash" style="top:12px; right:-20px" href="javascript:void(0);" @click="onRemoveCVColumn(index)"></a>
                                    </div>
                                </draggable>
                                <a class="ti-plus addf" v-if="selectedCVColumns.length < cvColumnOptions.length" href="javascript:void(0);" title="Add Column" @click="addNewCVColumn">Add Column</a>
                            </div>
                        </div>
                        <div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD; padding: 15px 10px;">
						    <button class="svout c rnd4" @click="handleSaveAction">Save</button>
						</div>
                    </div>
                    <div class="pd-10 pb-0" v-if="tab == 7 && legacyGroupsCount === 0">
                        <div class="popUpBody">
                            <div class="pd-20 brd-bt">
                                <label class="ftsb mb-5">Legacy Strategic Themes</label>
                                <span class="mb-10 light DB">Enable or disable the legacy Strategic Themes experience for all users.</span>
                                <div class="DFA JB a">
                                    <div class="mr-20">
                                        <div class="mn blk mb-5">Legacy Theme Enabled</div>
                                    </div>
                                    <div class="switch-button grn switch-button-sm FR">
                                        <input id="legacyThemeToggle" type="checkbox" :checked="additionalSettingsLegacyThemeEnabled" @change="onAdditionalSettingsToggle"/>
                                        <span><label for="legacyThemeToggle"></label></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="DF JE" :class="{'disabled': !isSaveButtonActive}" style="border-top:1px solid #CED5DD; padding: 15px 10px;">
						    <button class="svout c rnd4" @click="handleSaveAction">Save</button>
						</div>
                    </div>
				</div>
		    </div>
		</div>
	`,
	props : {
        type: {
            type: String,
            default: () => {
                return "";
            }
        },
        releaseTrainId: {
            type: String,
            default: () => {
                return "";
            }
        },
        releaseTrain: {
            type: Object,
            default: () => {
                return {};
            }
        },
        linkedAlmHierarchy: {
            type: String,
            default: () => {
                return "";
            }
        },
        dynamicAlmFields: {
            type: Array,
            default: () => {
                return [];
            }
        },
        currentHierarchyLevel: {
            type: Object,
            default: () => {
                return {};
            }
        },
        tfsProjects: {
			type: Array,
			default : () => {
                return [];
            }
		},
        jiraProjects: {
			type: Array,
			default : () => {
                return [];
            }
		},
        alm: {
			type: Object,
			default : () => {
                return {};
            }
		},
        customView: {
            type: Object,
            default: () => {
                return {};
            }
        },
        legacyGroupsCount: {
            type: Number,
            default: () => {
                return 0;
            }
        },
        legacyThemeEnabled: {
            type: Boolean,
            default: false,
        },
    },
	components: {
		'roles-permission' : ROLES_PERMISSION,
		vuejsDatepicker,
		//"pi-site-popup" : PI_SITE_POP,
        'draggable': vuedraggable
    },
    data() {
		return {
			tab                                     : 1,			
			workspaceObj                            : {},
			checkInConfig: {
				startDate		: '',
				endDate			: '',
				rangeType		: '',
				error			: {},
				_frequency		: 0,
			},
			disabledDates: {
				to				: ''
			},
            emoji: {
                search			: "",
                positiveShow	: false,
                negativeShow	: false,
                emojiGroup: {
                    positiveEmojis: {
                        id		: "positiveEmojis",
                        classes	: "positiveEmojis",
                        emojis	: [],
                    },
                    negativeEmojis: {
                        id		: "negativeEmojis",
                        classes	: "negativeEmojis",
                        emojis	: [],
                    }
                },
            },													
			defaultSite								: {},			
            selectedHierarchyLevelForColumns        : {},
            selectedHierarchyLevelForFilter         : {},
            selectedHierarchyLevelForItem           : {},
            selectedCriteria                        : {},
            selectedDefaultProject                  : {},
            selectedRestrictedProject               : {},
            selectedDefaultItemType                 : {},
            selectedDefaultStatus                   : {},
            selectedRestrictedIssueTypes            : [],
            defaultFilter                           : {},
			RANGE_CODES								: [],
            selectedRestrictedIssueTypes            : [],
			activeAccessRoles                       : [],
            hierarchyLevels                         : [],
            selectedColumns                         : [],
            selectedOKRColumns                      : [],
            selectedCVColumns                       : [
                {
                    id                              : "title",
                    title                           : "Title",
                    disabled                        : true,
                },
            ],
            okrColumnsMap                           : {},
            cvColumnsMap                            : {},
            okrColumnOptions                        : [],
            cvColumnOptions                         : [],
            selectedOKRColumnValues                 : [],
            selectedCVColumnValues                  : [],
            selectedColumnValue                     : [],
            filterCriteriaList                      : [],
            projectsList                            : [],
            tfsItemTypes                            : [],
            jiraIssueTypes                          : [],
            statuses                                : [],
            restrictedListOriginal                  : [],
            restrictedProjectsAndIssueTypes         : [],
            jiraProjectLinkPopupSelectedItems       : [],
            jiraFieldsOptions                       : [],
            jiraFieldsOptionsCopy                   : [],
            defaultJiraFieldOptions                 : [],
			showAddSite								:  false,
            isColumnsSettingsChanged                : false,
            isFilterSettingsChanged                 : false,
            isItemSettingsChanged                   : false,
            removeDefaultCriteria                   : false,
            jiraIssueTypesLoading                   : false,
            jiraStatusesLoading                     : false,
            enableProjectRestriction                : false,
            editRestriction                         : false,
            editRestrictionIndex                    : -1,
            tfsProjectId                            : "",
            defaultIssueType                        : "",
            defaultProject                          : "",
            defaultStatus                           : "",
            showProjectPopup                        : false,
            saveUserPermissions                     : false,
            jiraLoader                              : {
                                                        show: false,
                                                        text: '',
                                                    },
            currentSelectedHierarchyLevelForColumns : {},
            currentSelectedHierarchyLevelForFilter  : {},
            currentSelectedHierarchyLevelForItem    : {},
            errorOccurred                           : false,
            isExpandAll: true,
            searchQuery: '',
            selectedTeam: '',
            selectedBoard: '',
            selectedSolution: '',
            isObjectiveBacklogColumnsOpen: false,
            isObjectiveSettingsOpen: false,
            isObjectiveWorksSpaceSettingsOpen: false,
            isObjectiveFiltersSettingsOpen: false,
            isObjectiveCalculationSettingsOpen: false,
            isObjectiveProgressSettingsOpen: false,
            collections: [],
            dropdownValueMap: {},
            customColumns: [],
            okrCustomColumns: [],
            cvCustomColumns: [],
            isOkrRoadmapLoading: false,
            additionalSettingsLegacyThemeEnabled           : this.legacyThemeEnabled,
            additionalSettingsLegacyThemeEnabledOriginal   : this.legacyThemeEnabled,
            isAdditionalSettingsChanged                    : false,
		}
	},
	created () {
        if (this.type !== 'batch'){
            this.tab = 0;
        }
        if (this.type === 'objective'){
            this.tab = 3;
        }
        if (this.type === 'customView'){
            this.tab = _.isEmpty(this.customView) ? 6 : 3;
        }

		this.workspaceObj = _.cloneDeep(this.workspace);
		this.disabledDates.to = new Date();
		this.disabledDates.to.setHours(0,0,0,0);
		this.$options.repeatValues	= [{id:1,title:'Every Week'},{id:2,title:'Every 2 Weeks'},{id:3,title:'Every 3 Weeks'},{id:4,title:'Every 4 Weeks'}];
        this.initializeColumns();
        this.initializeAdditionalSettings();
	},
	computed :{
		workspace () {
			if(this.type == "objective" || this.type === 'customView'){
				return kendisStore.getters.getObjectiveWorkspace();					
			}else if(this.type == 'batch'){
				return kendisStore.getters.getBatchWorkspace();
			}
		},
        isRestrictionEnabled: function (){
            return this.enableProjectRestriction;
        },
        showDefaultIssueTypeDropdown() {
            return ((this.alm.type=='tfs' && !_.isEmpty(this.tfsItemTypes)) || (this.alm.type=='jira' && !_.isEmpty(this.jiraIssueTypes))) && this.selectedDefaultProject.id !== "-1";
        },
        showRestrictedIssueTypeDropdown() {
            return ((this.alm.type=='tfs' && !_.isEmpty(this.tfsItemTypes)) || (this.alm.type=='jira' && !_.isEmpty(this.jiraIssueTypes))) && !_.isEmpty(this.selectedRestrictedProject);
        },
        showProjectsDropdown() {
            return (this.alm.type=='tfs' || this.alm.type=='jira') && this.containsProjects;
        },
        isSaveButtonActive() {
            if (this.tab === 0 || this.tab === 3 || this.tab === 5 || this.tab === 6) {
                return this.isColumnsSettingsChanged;
            } else if (this.tab === 1) {
                return (this.type === 'release-train' && this.isFilterSettingsChanged) || (this.type === 'batch' && this.saveUserPermissions);
            } else if (this.tab === 2) {
                return this.isItemSettingsChanged;
            } else if (this.tab === 7) {
                return this.isAdditionalSettingsChanged;
            }
        },
        containsProjects() {
            return this.projectsList.some(project => {return project.id !== "-1" || project.name !== "Select Default Project";});
        }
	},
	methods: {
		//------------------ EVENTS---------------//
        handleSaveAction() {
          // Early return if the save button is not active
          if (!this.isSaveButtonActive) return;

          // If we're in tab 1 and the type is not 'release-train', save user access roles
          if (this.tab === 1 && this.type !== "release-train") {
            this.saveUserAccessRoles();
          } else {
            // For all other cases, save backlog item settings
            this.saveBackLogItemSettings();
          }
        },
		onUpdateAccessRoles : function (accessRoles){
            if (!_.isEmpty(accessRoles)) {
                this.activeAccessRoles = accessRoles;
                this.saveUserPermissions = true;
            }
		},
        onChangeWorkSpaceTitle : function (){
            if (!this.isColumnsSettingsChanged){
                this.isColumnsSettingsChanged = true;
            }
        },
        initializeColumns: function () {

            this.$options.columsMap = {};
            this.$options.columsMap["r_st"] = { id: "r_st", title: "% Completion By Rollup (Status)", sortCommand: "", sort: false, disabled: false, editable: true, class: "c4" };
            this.$options.columsMap["r_sp"] = { id: "r_sp", title: "% Completion By Rollup (Estimate)", sortCommand: "", sort: false, disabled: false, editable: true, class: "c4" };
            this.$options.columsMap["c_st"] = { id: "c_st", title: "% Completion By Done Children", sortCommand: "", sort: false, disabled: false, editable: true, class: "c4" };
            this.$options.columsMap["status"] = { id: "status", title: "Status", sortCommand: "statusTitle", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["children"] = { id: "children", title: "Children Count", sortCommand: "childCount", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["estimate"] = { id: "estimate", title: "Estimate (SP)", sortCommand: "totalEstimate", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["startDate"] = { id: "startDate", title: "Start Date", sortCommand: "startDate", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["endDate"] = { id: "endDate", title: "End Date", sortCommand: "endDate", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["boards"] = { id: "boards", title: "Kendis Board", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["teams"] = { id: "teams", title: "Teams (Kendis)", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["sprints"] = { id: "sprints", title: "Sprints (Kendis)", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["solutionBoards"] = { id: "solutionBoards", title: "Solution Boards", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["links"] = { id: "links", title: "Dependencies", sortCommand: "", sort: true, disabled: false, editable: true , class:"c3"};
            this.$options.columsMap["fetchedBy"] = { id: "fetchedBy", title: "Fetched By", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["project"] = { id: "project", title: "Project", sortCommand: "fields.tfsProject", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["areaPath"] = { id: "areaPath", title: "Area Path", sortCommand: "fields.tfsAreaPath", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["iterationPath"] = { id: "iterationPath", title: "Iteration Path", sortCommand: "fields.tfsIterationPath", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["responsible"] = { id: "responsible", title: "Responsible", sortCommand: "fields.CreatedBy", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["parent"] = { id: "parent", title: "Parent", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["updated"] = { id: "updated", title: "Updated On", sortCommand: "updatedOn", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["created"] = { id: "created", title: "Created On", sortCommand: "createdOn", sort: true, disabled: false, editable: true, class: "c3" };
            this.$options.columsMap["creater"] = { id: "creater", title: "Creator", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" };
            if (this.type !== 'release-train') {
                this.$options.columsMap["c_linked_st"] = {
                    id: "c_linked_st",
                    title: "% Completion By Linked Items Status",
                    sortCommand: "",
                    sort: false,
                    disabled: false,
                    editable: true,
                    class: "c4"
                };
                this.$options.columsMap["compStatus"] = {
                    id: "compStatus",
                    title: "% Completion",
                    sortCommand: "",
                    sort: false,
                    disabled: false,
                    editable: true,
                    class: "c3"
                };
            }

            this.$options.columnOptions = Object.values(this.$options.columsMap);

            if (!_.isEmpty(this.dynamicAlmFields)){
                // this.$options.columnOptions = this.$options.columnOptions.concat(this.dynamicAlmFields);
                for (let field of this.dynamicAlmFields) {
                    let idExists = this.$options.columnOptions.some(option => option.id === field.id);

                    if (!idExists) {
                        field.disabled = false;
                        field.editable = true;
                      this.$options.columnOptions.push(field);
                    }
                }
            }

            this.okrColumnsMap = {};
            this.okrColumnsMap["timePeriod"] = {title: "Time Period", id: "timePeriod", disabled: false};
            this.okrColumnsMap["association"] = {title: "Associations", id: "association", disabled: false};
            this.okrColumnsMap["responsible"] = {title: "Responsible", id: "responsible", disabled: false};
            this.okrColumnsMap["progress"] = {title: "Progress", id: "progress", disabled: false};
            this.okrColumnsMap["status"] = {title: "Status", id: "status", disabled: false};

            this.okrColumnOptions = Object.values(this.okrColumnsMap);

            this.cvColumnsMap = {};
            this.cvColumnsMap["title"] = {title: "Title", id: "title", disabled: true}
            this.cvColumnsMap["key"] = {title: "Key", id: "key", disabled: false};
            this.cvColumnsMap["shortSummary"] = {title: "Short Summary", id: "shortSummary", disabled: false};
            this.cvColumnsMap["type"] = {title: "Type", id: "type", disabled: false};
            this.cvColumnsMap["timePeriod"] = {title: "Time Period", id: "timePeriod", disabled: false};
            this.cvColumnsMap["association"] = {title: "Associations", id: "association", disabled: false};
            this.cvColumnsMap["responsible"] = {title: "Responsible", id: "responsible", disabled: false};
            this.cvColumnsMap["status"] = {title: "Status", id: "status", disabled: false};
            this.cvColumnsMap["priority"] = {title: "Priority", id: "priority", disabled: false};
            this.cvColumnsMap["owner"] = {title: "Owner", id: "owner", disabled: false};

            this.cvColumnOptions = Object.values(this.cvColumnsMap);

            let workSpaceId = this.type === "release-train" ? this.releaseTrainId : this.workspaceObj.id;

            if (this.type === "release-train"){
                this.fetchHierarchies(this.releaseTrainId);
            }else{
                this.fetchBacklogItemsSettings(workSpaceId);
            }

        },
        onColumnSelectValue : function (selectedColumnIndex){
            let oldOption = _.find(this.$options.columnOptions, { id: this.selectedColumns[selectedColumnIndex].id });
            if (oldOption){
                oldOption.disabled = false;
            }
			let newOption = _.find(this.$options.columnOptions, { id: this.selectedColumnValue[selectedColumnIndex].id });
            if (newOption) {
                newOption.disabled = true;
            }
			this.selectedColumns[selectedColumnIndex] = this.selectedColumnValue[selectedColumnIndex];
            this.isColumnsSettingsChanged = true;
        },
        onOkrColumnSelectValue(index) {
            let oldColumn = _.find(this.okrColumnOptions, { id: this.selectedOKRColumns[index].id });
            if (oldColumn) {
                oldColumn.disabled = false;
            }
            let newColumn = _.find(this.okrColumnOptions, { id: this.selectedOKRColumnValues[index].id });
            if (newColumn) {
                newColumn.disabled = true;
            }
            this.selectedOKRColumns[index] = this.selectedOKRColumnValues[index];
            this.isColumnsSettingsChanged = true;
        },
        onCVColumnSelectValue(index) {
            let oldColumn = _.find(this.cvColumnOptions, { id: this.selectedCVColumns[index].id });
            if (oldColumn) {
                oldColumn.disabled = false;
            }
            let newColumn = _.find(this.cvColumnOptions, { id: this.selectedCVColumnValues[index].id });
            if (newColumn) {
                newColumn.disabled = true;
            }
            this.selectedCVColumns[index] = this.selectedCVColumnValues[index];
            this.isColumnsSettingsChanged = true;
        },
        addNewColumn : function (){
            let dummyColumn = { id: "new-dummy-column", title: "Select Column To Add", sortCommand: "", sort: false, disabled: false, editable: true, class: "c3" }
            this.selectedColumns.push(dummyColumn);
        },
        addNewOkrColumn : function (){
            let dummyColumn = { id: "new-dummy-column", title: "Select Column to Add", disabled: false }
            this.selectedOKRColumns.push(dummyColumn);
        },
        addNewCVColumn : function (){
            let dummyColumn = { id: "new-dummy-column", title: "Select Column to Add", disabled: false }
            this.selectedCVColumns.push(dummyColumn);
        },
        onRemoveColumn: function(columnIndex) {
			let oldOption = _.find(this.$options.columnOptions, { id: this.selectedColumns[columnIndex].id });
            if (oldOption) {
                oldOption.disabled = false;
            }
			this.selectedColumns.splice(columnIndex, 1);
			this.selectedColumnValue.splice(columnIndex,1);
            this.isColumnsSettingsChanged = true;
		},
        onRemoveOkrColumn: function(columnIndex) {
            let oldColumn = _.find(this.okrColumnOptions, { id: this.selectedOKRColumns[columnIndex].id });
            if (oldColumn) {
                oldColumn.disabled = false;
            }
            this.selectedOKRColumns.splice(columnIndex, 1);
            this.selectedOKRColumnValues.splice(columnIndex, 1);
            this.isColumnsSettingsChanged = true;
        },
        onRemoveCVColumn: function(columnIndex) {
            let oldColumn = _.find(this.cvColumnOptions, { id: this.selectedCVColumns[columnIndex].id });
            if (oldColumn) {
                oldColumn.disabled = false;
            }
            this.selectedCVColumns.splice(columnIndex, 1);
            this.selectedCVColumnValues.splice(columnIndex, 1);
            this.isColumnsSettingsChanged = true;
        },
        clearExistingProjectAndIssueTypesData: function (){
            if (!_.isEmpty(this.restrictedProjectsAndIssueTypes)){
                this.restrictedProjectsAndIssueTypes = [];
            }

            if (!_.isEmpty(this.restrictedListOriginal)){
                this.restrictedListOriginal = [];
            }

            if (!_.isEmpty(this.selectedDefaultProject)){
                this.selectedDefaultProject = {};
            }

            if (!_.isEmpty(this.selectedDefaultItemType)){
                this.selectedDefaultItemType = {};
            }

            if (!_.isEmpty(this.defaultProject)){
                this.defaultProject = "";
            }

            if (!_.isEmpty(this.defaultIssueType)){
                this.defaultIssueType = "";
            }

            if (!_.isEmpty(this.selectedRestrictedProject)){
                this.selectedRestrictedProject = {};
            }

            if (!_.isEmpty(this.selectedRestrictedIssueTypes)){
                this.selectedRestrictedIssueTypes = [];
            }

            if (!_.isEmpty(this.jiraIssueTypes)){
                this.jiraIssueTypes = [];
            }

            if (!_.isEmpty(this.tfsItemTypes)){
                this.tfsItemTypes = [];
            }

            if (!_.isEmpty(this.projectsList)){
                this.projectsList = [];
            }

        },
        clearExistingFilters: function () {
            if (!_.isEmpty(this.defaultFilter)){
                this.defaultFilter = {};
            }

            if (!_.isEmpty(this.selectedCriteria)) {
                this.selectedCriteria = {};
            }

            if (this.removeDefaultCriteria){
                this.removeDefaultCriteria = false;
            }
        },
        onItemDragStart: function(evt) {

		},
        onItemDragEnd: function (evt) {
            this.selectedColumnValue = _.cloneDeep(this.selectedColumns);
            this.isColumnsSettingsChanged = true;
        },
        onOkrItemDragStart: function(evt) {

		},
        onCVItemDragStart: function(evt) {

		},
        onOkrItemDragEnd: function (evt) {
            this.selectedOKRColumnValues = _.cloneDeep(this.selectedOKRColumns);
            this.isColumnsSettingsChanged = true;
        },
        onCVItemDragEnd: function (evt) {
            this.selectedCVColumnValues = _.cloneDeep(this.selectedCVColumns);
            this.isColumnsSettingsChanged = true;
        },
        fetchHierarchies: function(releaseTrainId) {
            let _this = this;
            let requestBody = {
                "releaseTrainId"   : releaseTrainId,
                "fetchHierarchies" : true,
            }
            axios.post("/releasetrain/fetch-release-train-hierarchies-and-filters", requestBody)
            .then(response => {
                if (response.status == "200" && !_.isEmpty(response.data.hierarchyLevels)) {
                    _this.hierarchyLevels = response.data.hierarchyLevels;
                    if (!_.isEmpty(_this.currentHierarchyLevel)){
                        _this.selectedHierarchyLevelForColumns = _this.currentHierarchyLevel;
                        _this.selectedHierarchyLevelForFilter = _this.currentHierarchyLevel;
                        _this.selectedHierarchyLevelForItem = _this.currentHierarchyLevel;

                        _this.currentSelectedHierarchyLevelForColumns = _this.currentHierarchyLevel;
                        _this.currentSelectedHierarchyLevelForFilter = _this.currentHierarchyLevel;
                        _this.currentSelectedHierarchyLevelForItem = _this.currentHierarchyLevel;
                    }else{
                        _this.selectedHierarchyLevelForColumns = _this.hierarchyLevels[0];
                        _this.selectedHierarchyLevelForFilter = _this.hierarchyLevels[0];
                        _this.selectedHierarchyLevelForItem = _this.hierarchyLevels[0];

                        _this.currentSelectedHierarchyLevelForColumns = _this.hierarchyLevels[0];
                        _this.currentSelectedHierarchyLevelForFilter = _this.hierarchyLevels[0];
                        _this.currentSelectedHierarchyLevelForItem = _this.hierarchyLevels[0];
                    }

                    if (this.tab === 0){
                        _this.fetchBacklogItemsSettings(releaseTrainId, _this.selectedHierarchyLevelForColumns.id);
                    }else if (this.tab === 1){
                        _this.fetchFiltersByHierarchyLevel(_this.workspaceObj.id, _this.selectedHierarchyLevelForFilter);
                    }
                }
            })
            .catch(error => {
                console.error("Error occurred while fetching hierarchy levels: ", error);
            });
        },
        onSelectHierarchy(selectedValue, type) {
            // Update temporary variables with the new selection
            if (type === 'columns') {
                this.currentSelectedHierarchyLevelForColumns = selectedValue;
            } else if (type === 'filter') {
                this.currentSelectedHierarchyLevelForFilter = selectedValue;
            } else if (type === 'item') {
                this.currentSelectedHierarchyLevelForItem = selectedValue;
            }

            const updateSelectedHierarchyLevels = () => {
                this.selectedHierarchyLevelForColumns = this.currentSelectedHierarchyLevelForColumns;
                this.selectedHierarchyLevelForFilter = this.currentSelectedHierarchyLevelForFilter;
                this.selectedHierarchyLevelForItem = this.currentSelectedHierarchyLevelForItem;
            };
            const fetchDataBasedOnTab = () => {
                if (this.tab === 0) {
                    this.fetchBacklogItemsSettings(this.releaseTrainId, this.currentSelectedHierarchyLevelForColumns.id);
                } else if (this.tab === 1) {
                    this.clearExistingFilters();
                    this.fetchFiltersByHierarchyLevel(this.releaseTrainId, this.currentSelectedHierarchyLevelForFilter);
                } else if (this.tab === 2) {
                    this.clearExistingProjectAndIssueTypesData();
                    this.fetchBacklogItemsSettings(this.releaseTrainId, this.currentSelectedHierarchyLevelForItem.id);
                }
            };

            const confirmAndFetchData = () => {
                this.saveBackLogItemSettings().then(() => {
                    updateSelectedHierarchyLevels();
                    fetchDataBasedOnTab();
                });
            };

            const revertChangesAndFetchData = () => {
                this.resetChangedSettingsFlags();
                updateSelectedHierarchyLevels();
                fetchDataBasedOnTab();
            };

            // Check for unsaved changes
            if (this.isColumnsSettingsChanged || this.isFilterSettingsChanged || this.isItemSettingsChanged) {
                askFromSweetAlertWrapper(
                    'Changes are not saved in current hierarchy level. Do you want to save them before proceeding?',
                    [confirmAndFetchData],
                    [revertChangesAndFetchData],
                    "Changes are not saved"
                );
            } else {
                updateSelectedHierarchyLevels();
                fetchDataBasedOnTab();
            }
        },

        onChangeTab: function (tab, type) {
            const _this = this;

            // Function to handle tab change and data fetching
            const handleTabChange = () => {
                _this.tab = tab;
                switch (_this.tab) {
                    case 0:
                        _this.fetchBacklogItemsSettings(type === "release-train" ? _this.releaseTrainId : _this.workspaceObj.id, type === "release-train" ? _this.selectedHierarchyLevelForColumns.id : undefined);
                        break;
                    case 1:
                        if (type === "release-train") {
                            _this.clearExistingFilters();
                            _this.fetchFiltersByHierarchyLevel(_this.releaseTrainId, _this.selectedHierarchyLevelForFilter);
                        } else if (type === "batch") {
                            _this.saveUserPermissions = false;
                        }
                        break;
                    case 2:
                        _this.clearExistingProjectAndIssueTypesData();
                        _this.fetchBacklogItemsSettings(_this.releaseTrainId, _this.selectedHierarchyLevelForItem.id);
                        break;
                        case 7:
                            _this.initializeAdditionalSettings();
                            break;
                }
            };

            // Check if settings have changed and need saving
            if (this.isColumnsSettingsChanged || this.isFilterSettingsChanged || this.isItemSettingsChanged) {
                askFromSweetAlertWrapper(
                    'Changes are not saved in current tab. Do you want to save them and change the tab?',
                    [() => {
                        _this.saveBackLogItemSettings()
                            .then(handleTabChange)
                            .catch(error => {
                                console.error(error);
                            });
                    }],
                    //On reject change the tabs without saving data and reset the flags for changed settings
                    [() => {
                        _this.resetChangedSettingsFlags();
                        handleTabChange();
                    }],
                    "Changes are not saved"
                );
            } else {
                handleTabChange();
            }
        },

        fetchBacklogItemsSettings: function (workSpaceId, hierarchyLevelId){
            let _this = this;
            let requestBody = {
                releaseTrainId: workSpaceId
            }
            if (hierarchyLevelId){
                requestBody.hierarchyLevelId = hierarchyLevelId;
            }else{
                requestBody.hierarchyLevelId = "-1"
            }

            axios.post('/releasetrain/fetch-backlog-items-settings', requestBody)
            .then(response => {
                if (_this.tab === 0 || _this.tab === 3 || _this.tab === 5 || _this.tab === 6) {
                    let selectedColumnsIds;
                    if (!_.isEmpty(response.data.backlogItemColumns)) {
                        selectedColumnsIds = response.data.backlogItemColumns;
                    } else {
                        selectedColumnsIds = ["status", "children", "estimate", "boards"];

                        if (_this.type === "release-train") {
                            selectedColumnsIds.push("r_st");
                        } else {
                            selectedColumnsIds.push("compStatus");
                        }
                    }

                    _this.selectedColumns = _this.filterBacklogColumns(selectedColumnsIds);

                    _this.selectedColumnValue = _.cloneDeep(_this.selectedColumns);

                    let selectedOkrColumnIds;
                    let selectedCvColumnIds
                    if (this.type === "customView" && !_.isEmpty(_this.customView) && !_.isEmpty(_this.customView.columnSettings)) {
                        selectedOkrColumnIds = _this.customView.columnSettings;
                    } else if (!_.isEmpty(_this.workspaceObj.columnSettings)) {
                        selectedOkrColumnIds = _this.workspaceObj.columnSettings;
                    } else {
                        selectedOkrColumnIds = ["timePeriod", "association", "responsible", "progress", "status"];
                    }

                    if (!_.isEmpty(_this.workspaceObj.customViewColumnSettings)) {
                        selectedCvColumnIds = _this.workspaceObj.customViewColumnSettings;
                    } else {
                        selectedCvColumnIds = ["title", "shortSummary", "type", "status", "timePeriod", "responsible", "owner"];
                    }

                    _this.selectedOKRColumns = _this.filterOKRColumns(selectedOkrColumnIds);
                    _this.selectedOKRColumnValues = _.cloneDeep(_this.selectedOKRColumns);

                    _this.selectedCVColumns = _this.filterCVColumns(selectedCvColumnIds);
                    _this.selectedCVColumnValues = _.cloneDeep(_this.selectedCVColumns);

                }else if (_this.tab === 1 && !_.isEmpty(response.data.defaultFilterCriteria)) {
                     _this.defaultFilter = response.data.defaultFilterCriteria;
                     _this.selectedCriteria = _this.defaultFilter;
                     localStorage.setItem("default_backlog_filter_" + workSpaceId + "_" + hierarchyLevelId, JSON.stringify(_this.selectedCriteria));

                }else if (_this.tab === 2) {
                    _this.enableProjectRestriction = response.data.isRestrictionApplied;

                    _this.initializeTfsAndJiraProjectsList();

                    if (_this.containsProjects && !_.isEmpty(response.data.defaultProject) && !_.isEmpty(response.data.defaultItemType)) {
                        _this.defaultProject = response.data.defaultProject;
                        let projectKey = _this.alm.type === "tfs" ? "tfsId" : "jiraProjectKey";
                        _this.selectedDefaultProject = _.find(_this.projectsList, { [projectKey]: _this.defaultProject });

                        _this.defaultIssueType = response.data.defaultItemType;

                        if (response.data.defaultStatus){
                            _this.defaultStatus = response.data.defaultStatus;
                        }

                        if (response.data.defaultJiraFields){
                            _this.defaultJiraFieldOptions = response.data.defaultJiraFields;
                        }

                        _this.fetchAndPopulateIssueTypes();
                    }else if (!_this.enableProjectRestriction){
                        _this.selectedDefaultProject = _.find(_this.projectsList, { id : "-1" });
                    }

                    if (response.data.restrictedProjectsAndIssueTypes){
                        _this.restrictedListOriginal = response.data.restrictedProjectsAndIssueTypes;

                        if (_this.enableProjectRestriction){
                            _this.restrictedProjectsAndIssueTypes = _this.processRestrictedProjectsAndIssueTypes(_this.restrictedListOriginal);
                        }
                    }
                }
            })
            .catch(error => {
                console.error(error);
            });

        },
        filterBacklogColumns: function (selectedColumnsIds) {
            let _this = this;
            let selectedColumnsArray = [];

            if (!_.isEmpty(_this.$options.columnOptions)) {
                _.each(_this.$options.columnOptions, option => {
                    option.disabled = false;
                });

                // Filter the columnOptions array to include only columns with IDs in selectedColumnsIds
                selectedColumnsArray = _this.$options.columnOptions.filter(column => selectedColumnsIds.includes(column.id))
                                        // For each filtered column, set the disabled property to true
                                        .map(column => {
                                            column.disabled = true;
                                            return column;
                                        })
                                        .sort((a, b) => {
                                            const indexA = selectedColumnsIds.indexOf(a.id);
                                            const indexB = selectedColumnsIds.indexOf(b.id);
                                            return indexA - indexB;
                                        });
            }

            return selectedColumnsArray;
        },

        filterOKRColumns(selectedOkrColumnIds) {
            let _this = this;

            let selectedColumnsArray = [];

            if (!_.isEmpty(_this.okrColumnsMap)) {
                _.each(_this.okrColumnsMap, option => {
                    option.disabled = false;
                });

                selectedColumnsArray = _this.okrColumnOptions.filter(column => selectedOkrColumnIds.includes(column.id))
                    .map(column => {
                        column.disabled = true;
                        return column;
                    }).sort((a, b) => {
                        const indexA = selectedOkrColumnIds.indexOf(a.id);
                        const indexB = selectedOkrColumnIds.indexOf(b.id);
                        return indexA - indexB;
                    });
            }

            return selectedColumnsArray;
        },

        filterCVColumns(selectedCVColumnIds) {
            let _this = this;

            let selectedColumnsArray = [];

            if (!_.isEmpty(_this.cvColumnsMap)) {
                _.each(_this.cvColumnsMap, option => {
                    if (option.id !== 'title') {
                        option.disabled = false;
                    }
                });

                selectedColumnsArray = _this.cvColumnOptions.filter(column => selectedCVColumnIds.includes(column.id))
                    .map(column => {
                        column.disabled = true;
                        return column;
                    }).sort((a, b) => {
                        const indexA = selectedCVColumnIds.indexOf(a.id);
                        const indexB = selectedCVColumnIds.indexOf(b.id);
                        return indexA - indexB;
                    });
            }

            if (!selectedColumnsArray.some(column => column.id === 'title')) {
                selectedColumnsArray.unshift(_this.cvColumnsMap['title']);
            }
            return selectedColumnsArray;
        },

        fetchFiltersByHierarchyLevel: function (releaseTraindId, selectedHierarchyLevel){
          let _this = this;
          axios.get("/releasetrain/fetch-filters-by-hierarchy-level/" + releaseTraindId + "/" + selectedHierarchyLevel.level)
            .then(response => {
                if (response.status == "200" && !_.isEmpty(response.data.filterCriterias)) {
                    _this.filterCriteriaList = response.data.filterCriterias;
                    _this.fetchBacklogItemsSettings(releaseTraindId, selectedHierarchyLevel.id);
                }else{
                    _this.filterCriteriaList = [];
                }
            })
            .catch(error => {
                console.error("Error occurred while fetching filters by hierarchy level: ",error);
            })
        },
        revertHierarchyLevels: function (){
            this.currentSelectedHierarchyLevelForColumns = this.selectedHierarchyLevelForColumns;
            this.currentSelectedHierarchyLevelForFilter = this.selectedHierarchyLevelForFilter;
            this.currentSelectedHierarchyLevelForItem = this.selectedHierarchyLevelForItem;
        },
        saveBackLogItemSettings: function () {
            const requestBody = {};
            this.errorOccurred = false;

            // Set workSpaceId if releaseTrainId is available
            if (!_.isEmpty(this.releaseTrainId)) {
                requestBody.workSpaceId = this.releaseTrainId;
            }
            switch (this.tab) {
                case 0:
                case 3:
                case 5:
                case 6:
                    this.handleTabZero(requestBody);
                    break;
                case 1:
                    this.handleTabOne(requestBody);
                    break;
                case 2:
                    this.handleTabTwo(requestBody);
                    break;
                case 7:
                    this.handleTabSeven(requestBody);
                    break;
            }

            if (this.errorOccurred){
                this.revertHierarchyLevels();
                // this.resetChangedSettingsFlags();
                return;
            } // Halt execution if an error occurred

            if (this.type === 'customView' && !_.isEmpty(this.customView) && this.tab === 3) {
                this.$emit('onSaveCustomViewColumns', requestBody.okrColumnIds);
                return;
            }

            // Update workSpaceTitle if workspace titles don't match
            if (!_.isEmpty(this.workspace) && this.workspace.title !== this.workspaceObj.title) {
                requestBody.workSpaceTitle = this.workspaceObj.title;
            }

            return axios.post('/releasetrain/save-backlog-item-settings', requestBody)
                .then(response => this.handleResponse(response))
                .catch(error => console.log(error));
        },

        handleTabZero: function (requestBody) {
            // Set hierarchy level id for columns based on the type and selected hierarchy level
            if (this.type === "release-train" && !_.isEmpty(this.selectedHierarchyLevelForColumns)) {
                requestBody.hierarchyLevelIdForColumns = this.selectedHierarchyLevelForColumns.id;
            } else {
                // Default values if type is not "release-train" or selectedHierarchyLevelForColumns is empty
                requestBody.hierarchyLevelIdForColumns = "-1";
                requestBody.workSpaceId = this.workspaceObj.id;
            }

            // Check for unassigned column and show message if found
            if (!_.isEmpty(this.selectedColumns)) {
                const hasUnassignedColumn = this.selectedColumns.some(column => column.id === "new-dummy-column");
                if (hasUnassignedColumn) {
                    showTopMessage("Kindly select a value for newly added column.", "warning", 2000);
                    this.errorOccurred = true;
                    return;
                }
                // Map selected column ids and filter out empty ids
                requestBody.columnIds = this.selectedColumns.map(column => column.id).filter(id => id);
            }
            if (!_.isEmpty(this.selectedOKRColumns)) {
                const hasUnassignedOkrColumn = this.selectedOKRColumns.some(column => column.id === "new-dummy-column");
                if (hasUnassignedOkrColumn) {
                    showTopMessage("Kindly select a value for newly added OKR column.", "warning", 2000);
                    this.errorOccurred = true;
                    return;
                }

                requestBody.okrColumnIds = this.selectedOKRColumns.map(column => column.id).filter(id => id);
            }
            if (!_.isEmpty(this.selectedCVColumns)) {
                const hasUnassignedOkrColumn = this.selectedCVColumns.some(column => column.id === "new-dummy-column");
                if (hasUnassignedOkrColumn) {
                    showTopMessage("Kindly select a value for newly added OKR column.", "warning", 2000);
                    this.errorOccurred = true;
                    return;
                }

                requestBody.cvColumnIds = this.selectedCVColumns.map(column => column.id).filter(id => id);
            }
            return requestBody;
        },

        handleTabOne: function (requestBody) {
            if (!_.isEmpty(this.selectedHierarchyLevelForFilter)) {
                requestBody.hierarchyLevelIdForFilter = this.selectedHierarchyLevelForFilter.id;
            }

            this.handleSelectedCriteria(requestBody);
        },

        handleTabTwo: function (requestBody) {
            if (!_.isEmpty(this.selectedHierarchyLevelForItem)) {
                requestBody.hierarchyLevelIdForItemSettings = this.selectedHierarchyLevelForItem.id;
            }

            if (this.isItemSettingsChanged) {
                this.handleItemSettingsChange(requestBody);
            }
        },

        /**
         * Applies Additional Settings payload for Strategic Themes.
         * @param {Object} requestBody the current save request body
         */
        handleTabSeven: function (requestBody) {
            if (this.type === "customView" && _.isEmpty(this.customView)) {
                requestBody.legacyThemeEnabled = this.additionalSettingsLegacyThemeEnabled;
            }
        },

        /**
         * Initializes Additional Settings state for Strategic Themes.
         */
        initializeAdditionalSettings: function () {
            if (this.type !== "customView" || !_.isEmpty(this.customView) || this.legacyGroupsCount <= 0) {
                return;
            }
            if (typeof this.legacyThemeEnabled === "boolean") {
                this.additionalSettingsLegacyThemeEnabled = this.legacyThemeEnabled;
                this.additionalSettingsLegacyThemeEnabledOriginal = this.legacyThemeEnabled;
            } else {
                this.additionalSettingsLegacyThemeEnabled = false;
                this.additionalSettingsLegacyThemeEnabledOriginal = false;
            }
            this.isAdditionalSettingsChanged = false;
        },

        /**
         * Handles toggle interaction for enabling legacy Strategic Themes.
         * @param {Event} event change event from the toggle
         */
        onAdditionalSettingsToggle: function (event) {
            this.additionalSettingsLegacyThemeEnabled = !!event.target.checked;
            this.isAdditionalSettingsChanged = this.additionalSettingsLegacyThemeEnabled !== this.additionalSettingsLegacyThemeEnabledOriginal;
        },

        handleSelectedCriteria: function (requestBody) {
            // If selectedCriteria is not empty, set defaultFilter and filterId in requestBody
            if (!_.isEmpty(this.selectedCriteria)) {
                this.defaultFilter = this.selectedCriteria;
                requestBody.filterId = this.selectedCriteria.id;
            }else{
                requestBody.removeDefaultFilter = true;
                this.defaultFilter = {};
            }
        },

        handleItemSettingsChange: function (requestBody) {
            if (!this.enableProjectRestriction) {
                this.setProjectAndItemType(requestBody);
            } else {
                this.setRestrictedProjectsAndIssueTypes(requestBody);
            }

            requestBody.restrictionApplied = this.enableProjectRestriction;
        },

       setProjectAndItemType(requestBody) {
            // Initialize default values for project and item type
            requestBody.defaultProject = "";
            requestBody.defaultItemType = "";

            // Check if the default project is not selected
            if (this.selectedDefaultProject.id === "-1") {
                // Early return if no default project is selected
                return;
            }

            // Check if the default item type is not set
            if (_.isEmpty(this.selectedDefaultItemType)) {
                showTopMessage("Kindly select a default item type", "warning", 3000);
                this.errorOccurred = true;
                return; // Early return if no default item type is selected
            }

            // Set default project and item type based on the ALM type
            if (this.alm.type === "tfs") {
                requestBody.defaultProject = this.selectedDefaultProject.tfsId;
                requestBody.defaultItemType = this.selectedDefaultItemType.referenceName;
            } else { // Assume any other type defaults to handling for "jira"
                requestBody.defaultProject = this.selectedDefaultProject.jiraProjectKey;
                requestBody.defaultItemType = this.selectedDefaultItemType.id;

                if (!_.isEmpty(this.selectedDefaultStatus)){
                    requestBody.defaultStatus = this.selectedDefaultStatus.id;
                }

                if (!_.isEmpty(this.defaultJiraFieldOptions)){
                    requestBody.defaultJiraFields = this.defaultJiraFieldOptions.map(item => item.key);
                }
            }
        },

        setRestrictedProjectsAndIssueTypes: function (requestBody) {
            if (_.isEmpty(this.restrictedProjectsAndIssueTypes)) {
                showTopMessage("Kindly add projects and issue types to restrict.", "warning", 3000);
                this.errorOccurred = true;
                return;
            }

            const simplifiedList = this.restrictedProjectsAndIssueTypes.map(item => ({
                restrictedProject: this.alm.type === "tfs" ? item.restrictedProject.tfsId : item.restrictedProject.jiraProjectKey,
                restrictedIssueTypes: item.restrictedIssueTypes.map(issueType => this.alm.type === "tfs" ? issueType.referenceName : issueType.id)
            }));

            if (!_.isEmpty(simplifiedList)) {
                requestBody.restrictedProjectsAndIssueTypes = simplifiedList;
            }
        },

        handleResponse: function (response) {
            if (response.status == "200" && response.data.updatedWorkSpace) {
                showTopMessage("Settings Saved", 'success');
                let updatedWorkSpace = response.data.updatedWorkSpace;
                if (!_.isEmpty(this.defaultFilter) && this.removeDefaultCriteria) {
                    this.removeDefaultCriteria = false;
                }

                this.emitUpdateEvent(updatedWorkSpace);
                this.resetChangedSettingsFlags();
                if (typeof response.data.legacyThemeEnabled === "boolean") {
                    this.additionalSettingsLegacyThemeEnabled = response.data.legacyThemeEnabled;
                    this.additionalSettingsLegacyThemeEnabledOriginal = response.data.legacyThemeEnabled;
                    this.isAdditionalSettingsChanged = false;
                    this.$emit("update-legacy-theme", response.data.legacyThemeEnabled);
                }
            }
        },

        emitUpdateEvent: function (updatedWorkSpace) {
            if (this.type === "objective" && !_.isEmpty(updatedWorkSpace.backlogSettingsMap)) {
                this.$emit("update-objective-workspace", updatedWorkSpace);
            } else if (this.type === "batch" && !_.isEmpty(updatedWorkSpace.backlogSettingsMap)) {
                this.handleBatchWorkspaceUpdate(updatedWorkSpace);
            } else if (this.type === 'customView' && !_.isEmpty(updatedWorkSpace.customViewColumnSettings)) {
                this.$emit("update-custom-view-workspace", updatedWorkSpace);
            } else {
                this.handleReleaseTrainUpdate(updatedWorkSpace);
            }
        },

        handleBatchWorkspaceUpdate: function (updatedWorkSpace) {
            // Update the batch workspace in the store
            kendisStore.commit('setBatchWorkspace', updatedWorkSpace);
            // Clear specific local storage items related to batch workspace
            for (let key in localStorage) {
                if (key.includes("batch_group_Backlog_Columns") || key.includes("Batch_Backlog_Columns")) {
                    localStorage.removeItem(key);
                }
            }
        },

        handleReleaseTrainUpdate: function (updatedWorkSpace) {
            if (updatedWorkSpace.backlogSettingsMap && updatedWorkSpace.backlogSettingsMap[this.selectedHierarchyLevelForColumns.id] && updatedWorkSpace.backlogSettingsMap[this.selectedHierarchyLevelForColumns.id].backLogItemsColumns) {
                localStorage.setItem(updatedWorkSpace.id + "_" + this.selectedHierarchyLevelForColumns.id + "_Backlog_Columns", JSON.stringify(updatedWorkSpace.backlogSettingsMap[this.selectedHierarchyLevelForColumns.id].backLogItemsColumns));
            }
            this.$emit("update-release-train", updatedWorkSpace, this.selectedHierarchyLevelForColumns.id, this.selectedHierarchyLevelForFilter.id, this.removeDefaultCriteria, this.isColumnsSettingsChanged, this.isFilterSettingsChanged);
        },
        saveUserAccessRoles: function () {
            let _this = this;
            if (!_.isEmpty(_this.workspaceObj)) {
                _this.workspaceObj.accessRoles = _this.activeAccessRoles;
                axios.post("/admin/save/workspace", _this.workspaceObj)
				.then(response => {
					if (response.data) {
                            if (this.type == 'batch') {
                                kendisStore.commit("setBatchWorkspace",response.data.workSpace);
                            }
                            showTopMessage("Settings Saved", 'success');
                            _this.saveUserPermissions = false;
						// _this.$emit('close');
					}
				}).catch(error => {

				});
            }
		},
	
		//------------------ EVENTS---------------//
        insertWithArgument(emoji, type) {
            if(type == 'positive') {
                if(!this.emoji.emojiGroup['positiveEmojis']) {
                    this.emoji.emojiGroup['positiveEmojis'] = {
                        id: "positiveEmojis",
                        classes: "positiveEmojis",
                        emojis: [],
                    }
                }
                this.emoji.emojiGroup['positiveEmojis'].emojis.push({symbol: emoji , classes: "posEmojiIcon"});
                // Hide on click
                this.$refs["positiveEmojiPicker"].display.visible = false;
            } else if(type == 'negative') {
                if(!this.emoji.emojiGroup['negativeEmojis']) {
                    this.emoji.emojiGroup['negativeEmojis'] = {
                        id: "negativeEmojis",
                        classes: "negativeEmojis",
                        emojis: [],
                    }
                }
                this.emoji.emojiGroup['negativeEmojis'].emojis.push({symbol: emoji , classes: "negEmojiIcon"});
                // Hide on click
                this.$refs["negativeEmojiPicker"].display.visible = false;
            }
        },
        insert(emoji) {
        },
        onEmojiClick(event, group) {
            if(group == 'positive') {
                if(!this.emoji.emojiGroup['positiveEmojis']) {
                    this.emoji.emojiGroup['positiveEmojis'] = {
                        id: "positiveEmojis",
                        classes: "positiveEmojis",
                        emojis: [],
                    }
                }
                this.emoji.emojiGroup['positiveEmojis'].emojis.push({symbol: event.detail.unicode , classes: "posEmojiIcon"});
            } else if(group == 'negative') {
                if(!this.emoji.emojiGroup['negativeEmojis']) {
                    this.emoji.emojiGroup['negativeEmojis'] = {
                        id: "negativeEmojis",
                        classes: "negativeEmojis",
                        emojis: [],
                    }
                }
                this.emoji.emojiGroup['negativeEmojis'].emojis.push({symbol: event.detail.unicode , classes: "negEmojiIcon"});
            }
            this.emoji.positiveShow = false;
            this.emoji.negativeShow = false;
        },
		onSelectAddSite: function() {
			this.showAddSite = true;
		},
		onSitePopupSaved:  function () {},
        onSelectDefaultFilter: function (){
            if (!_.isEmpty(this.selectedHierarchyLevelForFilter) && !_.isEmpty(this.selectedCriteria)){
                this.isFilterSettingsChanged = true;
            }
        },
        onRemoveDefaultFilter: function () {
            this.removeDefaultCriteria = true;
            this.selectedCriteria = {};
            this.isFilterSettingsChanged = true;
        },
        initializeTfsAndJiraProjectsList: function () {
            let _this = this;
            if (!_this.enableProjectRestriction){
                _this.projectsList = [{
                    id: "-1",
                    name: "Select Default Project"
                }];
            }

            if (_this.alm.type === "tfs" && !_.isEmpty(_this.tfsProjects)){
                _this.projectsList = _this.projectsList.concat(_this.tfsProjects);
            }else if (_this.alm.type === "jira" && !_.isEmpty(_this.jiraProjects)){
                _this.projectsList = _this.projectsList.concat(_this.jiraProjects);
            }

            if (_this.enableProjectRestriction){

                if (!_.isEmpty(_this.restrictedProjectsAndIssueTypes)) {
                    _.each(_this.restrictedProjectsAndIssueTypes, restrictedProjectAndIssueType => {
                        let project = _.find(_this.projectsList, {id: restrictedProjectAndIssueType.restrictedProject.id});
                        if (project) {
                            project.disabled = true;
                        }
                    });
                }
            }
        },
        onSelectDefaultProject : function (){
            this.fetchAndPopulateIssueTypes();
            if (!this.isItemSettingsChanged){
                this.isItemSettingsChanged = true;
            }
        },
        fetchAndPopulateIssueTypes: function (){
            if ( (!_.isEmpty(this.selectedHierarchyLevelForItem) && this.selectedDefaultProject.id !== "-1" || (this.enableProjectRestriction && !_.isEmpty(this.selectedRestrictedProject)) )){
                if (!_.isEmpty(this.selectedDefaultItemType)){
                    this.selectedDefaultItemType = {};
                }

                if (this.enableProjectRestriction && !_.isEmpty(this.selectedRestrictedIssueTypes)){
                    this.selectedRestrictedIssueTypes = [];
                }

                if (!_.isEmpty(this.jiraIssueTypes)){
                    this.jiraIssueTypes = [];
                }

                if (!_.isEmpty(this.tfsItemTypes)){
                    this.tfsItemTypes = [];
                }

                if (this.alm.type === "tfs") {
                    this.fetchTfsItemTypes();
                    if (!_.isEmpty(this.tfsItemTypes) && !_.isEmpty(this.defaultIssueType)){
                        this.selectedDefaultItemType = _.find(this.tfsItemTypes, {referenceName: this.defaultIssueType});
                    }
                }else{
                    let selectedProject;

                    if (this.enableProjectRestriction && !_.isEmpty(this.selectedRestrictedProject)){
                    	selectedProject = this.selectedRestrictedProject;
                    }else{
                    	selectedProject = this.selectedDefaultProject
                    }

                    if (!_.isEmpty(this.jiraIssueTypes)) {
                        this.jiraIssueTypes = [];
                    }

                    this.fetchJiraIssueTypes(selectedProject);
                }

            }
        },
        onSelectDefaultIssuetype : function (){
            if (!this.isItemSettingsChanged){
                this.isItemSettingsChanged = true;
            }
        },
        fetchTfsItemTypes: function (tfsProject){
            let hierarchyLevelMapping = _.find(this.selectedHierarchyLevelForItem.almHierarchyLevelMappings, {almAccountId: this.alm.id});
            let tfsWorkItemTypesMap = {};

            if (hierarchyLevelMapping && hierarchyLevelMapping.tfsWorkItemTypes) {
                _.each(hierarchyLevelMapping.tfsWorkItemTypes, tfsWorkItemType => {
                    tfsWorkItemTypesMap[tfsWorkItemType.name] = true;
                });
            }

            let selectedProject;

            if (tfsProject) {
                selectedProject = tfsProject;
            }else if (this.enableProjectRestriction && !_.isEmpty(this.selectedRestrictedProject)){
                selectedProject = this.selectedRestrictedProject;
            }else{
                selectedProject = this.selectedDefaultProject;
            }

            if (selectedProject && selectedProject.itemTypesJSON) {
                let itemTypes = JSON.parse(selectedProject.itemTypesJSON).value;

                if (itemTypes) {
                    let tfsItemTypes = [];
                    _.each(itemTypes, itemType => {
                        if (tfsWorkItemTypesMap[itemType.name]) {
                            tfsItemTypes.push(itemType);
                        }
                    });

                    this.tfsItemTypes = tfsItemTypes;
                }
            }

        },
        fetchJiraIssueTypes: function (selectedProject){
            let _this = this;
            this.jiraIssueTypesLoading = true;
            let url = "/alm/" + _this.alm.id + "/projects/" + selectedProject.jiraProjectKey +"/types?fields=true&local=true";
            return axios.get(url)
            .then(response => {
                if (response.status == "200" &&  !_.isEmpty(response.data.issueTypes)) {
                    let hierarchyLevelMapping = _.find(_this.selectedHierarchyLevelForItem.almHierarchyLevelMappings, {almAccountId: _this.alm.id});
                    let jiraIssueTypesMap = {};

                    if (hierarchyLevelMapping && hierarchyLevelMapping.jiraIssueTypes) {
                        _.each(hierarchyLevelMapping.jiraIssueTypes, jiraIssueTypes => {
                            jiraIssueTypesMap[jiraIssueTypes.id] = true;
                        });
                    }

                    let issueTypes = response.data.issueTypes;

                    if (typeof issueTypes === 'string'){
                        issueTypes = JSON.parse(issueTypes);
                    }

                    if (issueTypes) {
                        let jiraIssueTypeList = [];
                        _.each(issueTypes, issueType => {
                            if (jiraIssueTypesMap[issueType.id]) {
                                jiraIssueTypeList.push(issueType);
                            }
                        });

                        if (!_.isEmpty(jiraIssueTypeList)) {
                            _this.jiraIssueTypes = jiraIssueTypeList;
                        }

                        if (!_.isEmpty(_this.jiraIssueTypes)){
                            if (!_.isEmpty(_this.defaultIssueType)){
                                _this.selectedDefaultItemType = _.find(_this.jiraIssueTypes, {id: _this.defaultIssueType});
                            }else{
                                _this.selectedDefaultItemType = _this.jiraIssueTypes[0];
                            }

                            if (_this.selectedDefaultItemType && !_.isEmpty(_this.selectedDefaultItemType.fields) && _.isEmpty(_this.jiraFieldsOptions) && _.isEmpty(_this.jiraFieldsOptionsCopy)){
                                _this.jiraFieldsOptions = _this.filterAndSeparateFields(_this.selectedDefaultItemType.fields);

                                _this.jiraFieldsOptionsCopy = _this.getCopyOfOriginalFields(_this.selectedDefaultItemType.fields);
                            }
                        }else{
                            _this.jiraIssueTypes = [];
                            _this.selectedDefaultItemType = {};
                        }

                        if (_this.jiraIssueTypesLoading) {
                            _this.jiraIssueTypesLoading = false;
                        }

                        let defaultProject;
                        let defaultIssueType;

                        if (!_.isEmpty(_this.defaultProject)){
                            defaultProject = _this.defaultProject;
                        }else if (!_.isEmpty(_this.selectedDefaultProject.jiraProjectKey)){
                            defaultProject = _this.selectedDefaultProject.jiraProjectKey;
                        }

                        if (!_.isEmpty(_this.defaultIssueType)){
                            defaultIssueType = _this.defaultIssueType;
                        }else if (!_.isEmpty(_this.selectedDefaultItemType.id)){
                            defaultIssueType = _this.selectedDefaultItemType.id;
                        }


                        if (!_.isEmpty(_this.statuses) && !_.isEmpty(_this.selectedDefaultStatus)){
                            _this.statuses = [];
                            _this.selectedDefaultStatus = {};
                        }

                        if (defaultProject && defaultIssueType) {
                            _this.jiraStatusesLoading = true;
                            _this.fetchJiraStatuses(defaultProject, defaultIssueType);
                        }
                    }
                }
            }).catch(error => {
                console.error(error);
            });
        },
        onToggleRestriction() {
            this.enableProjectRestriction = !this.enableProjectRestriction;

            if (this.enableProjectRestriction) {
                const defaultProjectIndex = _.findIndex(this.projectsList, {id: "-1"});
                if (defaultProjectIndex !== -1) {
                    this.projectsList.splice(defaultProjectIndex, 1);
                }

                this.selectedRestrictedProject = {};
                this.selectedRestrictedIssueTypes = [];

                if (!_.isEmpty(this.restrictedListOriginal)) {
                    this.restrictedProjectsAndIssueTypes = this.processRestrictedProjectsAndIssueTypes(this.restrictedListOriginal);
                } else if (!_.isEmpty(this.defaultProject) && !_.isEmpty(this.defaultIssueType)) {
                    this.initializeDefaultRestrictions();
                }
            } else {
                this.projectsList.unshift({ id: "-1", name: "Select Default Project" });
                this.selectedDefaultProject = _.find(this.projectsList, {id : "-1"});
                this.restrictedProjectsAndIssueTypes = [];
            }

            this.isItemSettingsChanged = true;
            this.$forceUpdate();
        },

        initializeDefaultRestrictions() {
            const defaultProjectFinder = this.alm.type === "tfs" ? {tfsId: this.defaultProject} : {jiraProjectKey: this.defaultProject};
            const defaultProject = _.find(this.projectsList, defaultProjectFinder);

            const fetchIssueTypes = this.alm.type === "tfs" ? this.fetchTfsItemTypes.bind(this, defaultProject) : this.fetchJiraIssueTypes.bind(this, defaultProject);

            fetchIssueTypes().then(() => {
                const issueTypeFinder = this.alm.type === "tfs" ? {referenceName: this.defaultIssueType} : {id: this.defaultIssueType};
                const restrictedIssueTypes = [_.find(this.alm.type === "tfs" ? this.tfsItemTypes : this.jiraIssueTypes, issueTypeFinder)];

                if (!_.isEmpty(restrictedIssueTypes[0]) && !this.restrictedProjectsAndIssueTypes.some(item => item.restrictedProject.id === defaultProject.id)) {
                    this.restrictedProjectsAndIssueTypes.unshift({
                        restrictedProject: defaultProject,
                        restrictedIssueTypes: restrictedIssueTypes,
                        showMenuOverlay: false
                    });
                }
            }).catch(error => console.error(error));
        },
        addRestriction: function (){
            if (!_.isEmpty(this.selectedRestrictedProject) && !_.isEmpty(this.selectedRestrictedIssueTypes)){
                // Check if the object already exists in the list
                const exists = this.restrictedProjectsAndIssueTypes.some(item =>
                    item.restrictedProject.id === this.selectedRestrictedProject.id);

                // If the object doesn't exist, push it
                if (!exists) {
                    this.restrictedProjectsAndIssueTypes.push({
                        restrictedProject: this.selectedRestrictedProject,
                        restrictedIssueTypes: this.selectedRestrictedIssueTypes,
                        showMenuOverlay     : false
                    });

                    if (!this.isItemSettingsChanged){
                        this.isItemSettingsChanged = true;
                    }

                    this.selectedRestrictedProject = {};
                    this.selectedRestrictedIssueTypes = [];

                    if (this.alm.type === "tfs"){
                        this.tfsItemTypes  = [];
                    }
                }else{
                    showTopMessage("Restriction already exists", "warning");
                }
            }else{
                let message = "";

                if (_.isEmpty(this.selectedRestrictedProject) && _.isEmpty(this.selectedRestrictedIssueTypes)){
                    message = "Please select a project and issue type.";
                }else if (_.isEmpty(this.selectedRestrictedProject)){
                    message = "Please select a project.";
                }else if (_.isEmpty(this.selectedRestrictedIssueTypes)){
                    message = "Atleast one issue type must be selected";
                }

                showTopMessage(message, "warning");
            }
        },
        updateRestriction: function () {
            if (this.editRestrictionIndex !== -1) {
                if (!_.isEmpty(this.selectedRestrictedProject) && !_.isEmpty(this.selectedRestrictedIssueTypes)) {
                    // Find index of a project with the same ID as the selected project, excluding the current editRestrictionIndex
                    const duplicateIndex = this.restrictedProjectsAndIssueTypes.findIndex((item, index) => {
                        return item.restrictedProject.id === this.selectedRestrictedProject.id && index !== this.editRestrictionIndex;
                    });

                    // If a duplicate project is found, show a message and return
                    if (duplicateIndex !== -1) {
                        showTopMessage("This project already exists in the list.", "warning");
                        return;
                    }

                    // Update the project and issue types at editRestrictionIndex
                    this.restrictedProjectsAndIssueTypes[this.editRestrictionIndex].restrictedProject = this.selectedRestrictedProject;
                    this.restrictedProjectsAndIssueTypes[this.editRestrictionIndex].restrictedIssueTypes = this.selectedRestrictedIssueTypes;

                    // Set flag if item settings have changed
                    if (!this.isItemSettingsChanged) {
                        this.isItemSettingsChanged = true;
                    }

                    // Reset selected project and issue types
                    this.selectedRestrictedProject = {};
                    this.selectedRestrictedIssueTypes = [];
                    this.editRestrictionIndex = -1;

                    // Additional logic for "tfs" type
                    if (this.alm.type === "tfs") {
                        this.tfsItemTypes = [];
                    }

                    // Reset edit restriction flag
                    this.editRestriction = false;
                } else {
                    // Construct the appropriate message based on missing selections
                    let message = "";

                    if (_.isEmpty(this.selectedRestrictedProject) && _.isEmpty(this.selectedRestrictedIssueTypes)) {
                        message = "Please select a project and issue type.";
                    } else if (_.isEmpty(this.selectedRestrictedProject)) {
                        message = "Please select a project.";
                    } else if (_.isEmpty(this.selectedRestrictedIssueTypes)) {
                        message = "At least one issue type must be selected.";
                    }

                    showTopMessage(message, "warning");
                }
            }
        },

        processRestrictedProjectsAndIssueTypes(restrictedList) {
            let _this = this;
            let newRestrictedList = [];
            let jiraIssueTypesList = [];

            if (_this.alm.type === "jira"){
                if (!_.isEmpty(_this.selectedHierarchyLevelForItem)) {
                    let hierarchyLevelMapping = _.find(_this.selectedHierarchyLevelForItem.almHierarchyLevelMappings, {almAccountId: _this.alm.id});

                    if (hierarchyLevelMapping && !_.isEmpty(hierarchyLevelMapping.jiraIssueTypes)) {
                        jiraIssueTypesList = hierarchyLevelMapping.jiraIssueTypes;
                    }
                }
            }

            restrictedList.forEach(item => {
                let newObject = {};
                let project;

                if (_this.alm.type === "tfs") {
                    project = _.find(_this.projectsList, { tfsId: item.restrictedProject });

                    if (!_.isEmpty(project)){
                        _this.fetchTfsItemTypes(project);
                    }
                } else if ((_this.alm.type === "jira")) {
                    project = _.find(_this.projectsList, { jiraProjectKey: item.restrictedProject });
                }

                let issueTypesList = _this.alm.type === "tfs" ? _this.tfsItemTypes : jiraIssueTypesList;
                let issueTypeProperty = _this.alm.type === "tfs" ? "referenceName" : "id";

                let newListForIssueTypes = item.restrictedIssueTypes.map(issueTypeId =>
                    _.find(issueTypesList, { [issueTypeProperty]: issueTypeId })
                ).filter(issueTypeObj => issueTypeObj);

                if (project && newListForIssueTypes && newListForIssueTypes.length > 0) {
                    newObject.restrictedProject = project;
                    newObject.restrictedIssueTypes = newListForIssueTypes;
                    newObject.showMenuOverlay = false;
                    newRestrictedList.push(newObject);
                }
            });

            if (_this.enableProjectRestriction && !_.isEmpty(_this.tfsItemTypes)){
                _this.tfsItemTypes = [];
            }

            return newRestrictedList;
        },
        onEndDrag: function (){
            if (!this.isItemSettingsChanged) {
                this.isItemSettingsChanged = true;
            }
        },
        onEditRestrictedObject: function (restrictedObject, restrictionObjectIndex){
            restrictedObject.showMenuOverlay = false;
            if (restrictedObject.restrictedProject){
                this.selectedRestrictedProject = restrictedObject.restrictedProject;

                if (this.alm.type == "tfs"){
                    this.fetchTfsItemTypes(this.selectedRestrictedProject);

                    if (restrictedObject.restrictedIssueTypes){
                        this.selectedRestrictedIssueTypes = restrictedObject.restrictedIssueTypes;
                    }
                }else{
                    this.fetchJiraIssueTypes(this.selectedRestrictedProject).then(() => {
                        if (restrictedObject.restrictedIssueTypes){
                            this.selectedRestrictedIssueTypes = restrictedObject.restrictedIssueTypes;
                        }
                    });
                }
            }

            if (restrictionObjectIndex > -1){
                this.editRestrictionIndex = restrictionObjectIndex;
            }

            this.editRestriction = true;

        },
        onRemoveRestrictedObject: function (restrictedObject){
            askFromSweetAlertWrapper(
                    'Are you sure you want to remove this restriction?',
                    [() => {
                        restrictedObject.showMenuOverlay = false;
                        this.restrictedProjectsAndIssueTypes = _.filter(this.restrictedProjectsAndIssueTypes, function (obj) {
                            return obj.restrictedProject.id !== restrictedObject.restrictedProject.id;
                        });
            
                        if (!this.isItemSettingsChanged){
                            this.isItemSettingsChanged = true;
                        }

                        if (this.editRestriction && restrictedObject.restrictedProject.id === this.selectedRestrictedProject.id){
                            this.editRestriction = false;
                            this.selectedRestrictedProject = {};
                            this.selectedRestrictedIssueTypes = [];
                        }
                    }],
                    [takeNoAction]
                );
        },
        viewItemHierarchy: function (type) {
            let url = window.location.origin + "/administration#itemHierarchyTab/edit/" + this.linkedAlmHierarchy;
            window.open(url, "_blank");
        },
        loadProjectPopup: function (){
            if (this.alm.type === "jira"){
                this.jiraProjectLinkPopupSelectedItems = _.map(this.jiraProjects, fm => {
                    if (fm.jiraProjectKey)
                        return fm.jiraProjectKey;
                });
            }

            this.showProjectPopup = true;
        },
        onLinkTfsProject: function (project){
            if (project){
                this.projectsList.push(project);
                this.$emit("tfs-project-linked", project);
            }
            this.showProjectPopup = false;
        },
        onLinkJiraProject: function(item) {
            let _this = this;
            let key = item.key != undefined ? item.key : item.jiraKey;
            if (key) {
                if (key == -1) {
                    return;
                }
                _this.jiraLoader.text = "loading project data...";
                _this.jiraLoader.show = true;
                _this.showProjectPopup = false;

                let url					= "/alm/sync-statuses";
                let param				= {};
                param.projects			= { [key] : {}};
                param.almConfigurations = { almAccount : { id : _this.alm.id}};
                param.isAlmBacklog		= true;


                axios.post(url, param).then(res => {
                    _this.onSaveProjectLinking(key);
                });
            }
        },
        onSaveProjectLinking: function(key) {
            let data = {};
            data.almAccountId = this.alm.id;
            data.projectKey = key;
            let _this = this;
            axios.post("/releasetrain/save/jiraProject", data)
                .then(response => {
                    if (!_.isEmpty(response.data.jiraProjectIssueTypes)) {
                        let jiraProject = response.data.jiraProjectIssueTypes[0];
                        _this.projectsList.push(jiraProject);
                        _this.jiraLoader.show = false;
                        _this.$emit("jira-project-linked", jiraProject);
                    }
                }).catch(error => {

                });
        },
        fetchJiraStatuses: function(selectedProjectKey, selectedIssueId) {
            let _this = this;

            if(!_.isEmpty(selectedProjectKey) && !_.isEmpty(selectedIssueId)) {
                let url = "/alm/load-statuses";
                let param = {
                    projects: { [selectedProjectKey] : {} },
                    almConfigurations: { almAccount : { id : _this.alm.id } },
                    isAlmBacklog : true
                };

                axios.post(url, param)
                    .then(response => {
                        if (_.isArray(response.data) && response.data.length > 0){
                            _this.statuses = getJiraStatusGroupedList(response.data, undefined, selectedProjectKey, selectedIssueId);

                            if (!_.isEmpty(_this.statuses) && !_.isEmpty(_this.defaultStatus)){
                                _this.selectedDefaultStatus = _.find(_this.statuses, { id : _this.defaultStatus });
                            }

                            _this.jiraStatusesLoading = false;
                        }
                    })
                    .catch(function(error) {
                        console.error('Error fetching statuses: ', error);

                        // renderALMWithError(error, this);
                    });
            }
        },
        filterAndSeparateFields: function(fieldsObject) {
            // Convert the object into an array of its values
            let fieldsArray = Object.values(fieldsObject);
            let fieldsToSkip = ["project", "parent", "issuetype", "summary", "attachment", "issuelinks", "timetracking"]

            if (_.isEmpty(this.defaultJiraFieldOptions)) {
                // Filter out required fields and ensure the field is not in the fieldsToSkip,
                // then map to include only the specified properties
                this.defaultJiraFieldOptions = fieldsArray.filter(field =>
                    field.required === true && !fieldsToSkip.includes(field.key)
                ).map(field => {
                    return {
                        key: field.key,
                        name: field.name,
                        required: field.required,
                    };
                });
            }else{
                // Create a new array based on the keys in this.defaultJiraFieldOptions
                let updatedDefaultJiraFieldOptions = [];
                this.defaultJiraFieldOptions.forEach(keyString => {
                    let correspondingObject = fieldsArray.find(item => item.key === keyString);
                    if (correspondingObject) {
                        updatedDefaultJiraFieldOptions.push({
                            key: correspondingObject.key,
                            name: correspondingObject.name,
                            required: correspondingObject.required,
                            showMenuOverlay : false
                        });
                    }
                });
                this.defaultJiraFieldOptions = updatedDefaultJiraFieldOptions;
            }

            // Return the array excluding the fields in defaultJiraFieldOptions
            return fieldsArray.filter(field =>
                field.required !== true && !this.defaultJiraFieldOptions.some(option => option.key === field.key)
                && !fieldsToSkip.includes(field.key)
                && !(field.schema.custom &&  field.schema.custom.endsWith(":rm-teams-custom-field-team"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":gh-epic-status"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":gh-epic-link"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":jpo-custom-field-parent"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":participants"))
            );
        },
        getCopyOfOriginalFields: function(fieldsObject) {
            let fieldsArray = Object.values(fieldsObject);
            let fieldsToSkip = ["project", "parent", "issuetype", "summary", "attachment", "issuelinks", "timetracking"]

            return fieldsArray.filter(field =>
                field.required !== true && !fieldsToSkip.includes(field.key)
                && !(field.schema.custom &&  field.schema.custom.endsWith(":rm-teams-custom-field-team"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":gh-epic-status"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":gh-epic-link"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":jpo-custom-field-parent"))
                && !(field.schema.custom &&  field.schema.custom.endsWith(":participants"))
            );
        },
        onSelectJiraFieldDropdownValue: function (selectedField){
            let _this = this;

            let selectedIndex = _.findIndex(_this.jiraFieldsOptions, function(option) {
                return option.key === selectedField.key;
            });

            if (selectedIndex !== -1) {
                _this.jiraFieldsOptions.splice(selectedIndex, 1);
            }

            _this.defaultJiraFieldOptions.push({
                key : selectedField.key,
                name : selectedField.name,
                required : selectedField.required,
                showMenuOverlay : false
            });
        },
        onRemoveJiraField: function (field) {
            let _this = this;

            let deletedIndex = _.findIndex(_this.defaultJiraFieldOptions, function (option) {
                return option.key === field.key;
            });

            if (deletedIndex !== -1) {
                _this.defaultJiraFieldOptions.splice(deletedIndex, 1);
            }

            let newItemIndex = _.findIndex(_this.jiraFieldsOptionsCopy, function (option) {
                return option.key === field.key;
            });

            if (newItemIndex !== -1) {
                _this.jiraFieldsOptions.splice(newItemIndex, 0, field);
            }
        },
        resetChangedSettingsFlags: function (){
            let _this = this;
            _this.isColumnsSettingsChanged = false;
            _this.isFilterSettingsChanged = false;
            _this.isItemSettingsChanged = false;
            _this.isAdditionalSettingsChanged = false;
        }
	},

    // Component lifecycle hooks
    beforeDestroy() {
        if (typeof stopPoll === 'function' && this.exportRequestId){
            stopPoll(this.exportRequestId);
        }
        this.showProgress = false;
    }
	
});



