Vue.use(VeeValidate);
const RISK_ROW_COMPONENT = Vue.component('risk-row-component', {

    name: 'risk-row-component',

    props: ["multiselectValues", "riskList", "riskRegister", "riskids"],

    template: `
    <div  class="reports riskreg">
        <div>
        <risk v-if="riskPopup.show" :risk-register="riskPopup.register" :meta="riskPopup.meta"
						:board="riskRegister.sessionBoard" :current-risk="riskPopup.risk" :open-risk-from-board="openRiskFromBoard"
						@create="onSaveRisk($event, true)" @update="onSaveRisk($event, false)" @delete="onDeleteRisk"
						@cancel="riskPopup.show = false; showOverlay = false;"></risk>
             <div id="link-item-container" class="link-item-container"></div>
             	<div v-if="showOverlay" id="overlay-risk" class="overlay cssShow"></div>
		    <link-item v-if="showItemsSearch" :boards="[{id:riskRegister.sessionBoard.session.id,name:riskRegister.sessionBoard.session.title}]"
		    	title="Search features and stories" :fit-container="true" container="link-item-container"
		    	:selected-items="selectedRisk.linkedItemsIds"
		    	:session-boards="$options._linkPopupData.sessionBoards" :data="$options._linkPopupData.data"
		    	@data-loaded="onLoadLinkPopupData" @cancel="showItemsSearch=false; showOverlay = false;"
		    	@save="saveLinkedItems1($event, selectedRisk)"></link-item>
       </div>
       <div class="prow repshowdata">
			<div>
				<div class="tbout">
					<table class="table">
						<thead>
							<tr class="rec">
								<th id="checkRiskNumber" v-show="checkIfColumnActive('risk')" class="idn">
									<a href="javascript:void(0)" @click="sortBy('riskNumber')">Risk #</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='riskNumber' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('riskTitle')" id="checkRiskTitle" class="dsc brd-rht">Risk Title</th>
								<th v-show="checkIfColumnActive('linkedItems')" id="checkLinkedItems" class="lnkitm brd-rht splft" title="Linked Items count">
									<a href="javascript:void(0)" @click="sortBy('itemsCount')">Linked Items</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='itemsCount' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('riskLevel')" id="checkRiskLevel">
									<a href="javascript:void(0)" @click="sortBy('riskLevel')">Risk Level</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='riskLevel' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('status')" id="checkStatus" class="stat">
									<a href="javascript:void(0)" @click="sortBy('status')">Status</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='status' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('raisedDate')" id="raisedDate" class="rdate">
									<a href="javascript:void(0)" @click="sortBy('raisedDate')">Raised Date</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='raisedDate' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('resolutionDate')" id="checkResolution"
									class="trd" title="Target Resolution Date">
									<a href="javascript:void(0)" @click="sortBy('resolutionDate')">Target Resolution Date</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='resolutionDate' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>

								<th v-show="checkIfColumnActive('responsible')" id="checkResponsible" class="rspsbl" title="Responsible">
									<a href="javascript:void(0)" @click="sortBy('responsible')">Responsible</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='responsible' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('convCount')" id="checkConvCount" class="t-center">
									<a href="javascript:void(0)" @click="sortBy('conversationCount')">Conversation</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='conversationCount' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('team')" id="checkTeams" class="tmpnl">
									<a href="javascript:void(0)" @click="sortBy('teams')" class="teamsClass">Teams</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='teams' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
								<th v-show="checkIfColumnActive('sprint')" id="checkSprints" class="sppnl">
									<a href="javascript:void(0)" @click="sortBy('sprints')" class="sprintsClass">Iterations</a>
									<em class="updn" v-bind:class="[sortColumn&&sortColumn=='sprints' ? (!sortAsc ? 'ti-arrow-up':'ti-arrow-down') : '']" />
								</th>
							</tr>
						</thead>
						<tbody>
							<template v-for="(risk, index) in risks">
								<tr class="rec" :key="risk.id">
									<td v-show="checkIfColumnActive('risk')" class="idn"><a
											href="javascript:void(0);" @click="onClickOpenRisk(risk)">{{getSessionRiskRegister().registerKey}}-{{risk.riskNumber
									}}</a></td>
									<td v-show="checkIfColumnActive('riskTitle')" class="dsc brd-rht"
										title="Risk Title" @click="onClickOpenRisk(risk)">
										{{ risk.riskTitle }}</td>

									<td v-show="checkIfColumnActive('linkedItems')"
										class="lnkitm brd-rht splft" title="Linked Items count"
										v-if="_.isEmpty(risk.linkedItemsIds)">
										<div class="mnu button btn-blue rskhdn"
											@click="closeAllExpandedRisks(risk);showSearch(risk);">+
										</div>
									</td>
									<td v-show="checkIfColumnActive('linkedItems')"
										class="lnkitm brd-rht splft" title="Linked Items count"
										v-if="risk.showLinkedItems == false && risk.linkedItemsIds.length > 0">
										<div class="mnu" @click="showLinkedItems(risk);">
											{{risk.linkedItemsIds.length}}</div>
									</td>
									<td v-show="checkIfColumnActive('linkedItems')"
										class="lnkitm brd-rht splft expand" title="Linked Items count"
										v-if="risk.showLinkedItems == true && risk.linkedItemsIds.length > 0">
										<div class="mnu" @click="showLinkedItems(risk);">
											{{risk.linkedItemsIds.length}}</div>
									</td>
									<td v-show="checkIfColumnActive('riskLevel')"
										v-if="risk.probability && risk.impact" title="Level">
										<div class="rsklvl txt"
											:style="{'background-color': calculateRiskLevel(risk.probability, risk.impact, riskLevelList).color}">{{
									calculateRiskLevel(risk.probability, risk.impact,
									riskLevelList).title }}</div>
									</td>
									<td v-if="!(risk.probability && risk.impact)" title="Level">
										<div class="rsklvl txt">N/A</div>
									</td>
									<td v-show="checkIfColumnActive('status')" class="stat"
										v-if="risk.status" title="Status">{{
								risk.status.title }}</td>
									<td class="stat" v-if="!risk.status" title="Status">N/A</td>
									<td v-show="checkIfColumnActive('raisedDate')" title="Raised Date"
										class="rsdt">{{
								getFormattedDateBritish(risk.raisedDate) }}</td>
									<td v-show="checkIfColumnActive('resolutionDate')"
										title="Target Resolution Date" class="trd">{{
								getFormattedDateBritish(risk.resolutionDate) }}</td>
									<td v-show="checkIfColumnActive('responsible')" v-if="risk.responsible">
										<div class="pic tooltip">
											<div v-html="getUserImage(risk.responsible)"></div>
											<div class="hovtooltipB">{{risk.responsible.fullName}}</div>
										</div>
									</td>
									<td v-show="checkIfColumnActive('responsible')" v-if="!risk.responsible">
										<div class="pic"></div>
									</td>

									<td v-show="checkIfColumnActive('convCount')" class="t-center chat" title="Conversations Count"><span class="c-point"><em class="icon-comment-empty" @click="onClickOpenRisk(risk)"></em>{{risk.conversationCount}}</span></td>
									<td v-show="checkIfColumnActive('team')" class="tmpnl">
										<span>{{boardRiskTeams(riskRegister.sessionBoard.session.id,risk.boardTeams)}}</span>
									</td>
									<td v-show="checkIfColumnActive('sprint')" class="sppnl">
										<span>{{boardRiskSprints(riskRegister.sessionBoard.session.id,risk.boardSprints)}}</span>
									</td>
								</tr>
								<div v-if="checkIfColumnActive('linkedItems') && risk.showLinkedItems "
										class="mrow">
										<risk_linked_items :risk="risk" :board-id="riskRegister.sessionBoard.id"
											:session-id="riskRegister.sessionBoard ? riskRegister.sessionBoard.session.id : ''"
											@remove-item-link="unlinkItemToRiskAction"
											v-if="risk.linkedItems.length > 0 || !_.isEmpty(risk.linkedItemsById)">
										</risk_linked_items>
										<ul class="table inn a">
											<li v-if="risk.linkedItems && (risk.linkedItems.length + risk.externalLinks.length) == 0 && _.isEmpty(risk.linkedItemsById)"
												class="nofound">
												{{risk.loading ? 'Loading...' :  'No items linked'}}
											</li>
										</ul>
										<ul class="table inn a rskhdn">
											<li class="rec link"
												v-if="!_.isEmpty(risk.linkedItems) || ! _.isEmpty(risk.linkedItemsById)">
												<div class="rc c2">
													<a href="javascript:void(0);"
														@click="showSearch(risk);"
														class="ti-plus addf">Link a new item</a>
												</div>
											</li>
										</ul>
									</div>
							</template>
						</tbody>
					</table>
				</div>
			</div>
	   </div>
</div>
	`,

    data() {
        return {
            sortColumn: 'riskNumber',
            sortAsc: true,
            showItemsSearch: false,
            showOverlay : false,
            selectedRisk: {},
            editRiskData:'',
            copyRisks:[],
            risks:[],
            riskPopup: {
                show : false,
                risk : undefined,
                meta : {},
                register : undefined,
            },
            workFlows: [],
            users: [],
            openRiskFromBoard:false,
        }
    },

    watch: {
        riskList:function(_newList,_oldList){
            this.risks=_newList;
            this.sortBy(this.sortColumn,this.sortAsc)
        }
    },

    mounted() {
        this.risks=this.riskList;
        this.sortBy(this.sortColumn,this.sortAsc)
    },

    computed:{
        isItemFromCurrentSession: function () {
            return function (item) {
                var sessionBoard = item.sessionBoards[0];
                return sessionBoard.id === this.riskRegister.sessionBoard.id;
            };
        },
        boardRiskSprints: function(){
            return function(sessionId,sprints){
                var sprintNames = [];
                _.each(sprints,sprint=>{
                    if(sprint.sessionId == sessionId){
                        sprintNames.push(sprint.sprintTitle);
                    }
                });
                sprintNames = sprintNames.join(', ');
                return sprintNames;
            }
        },

        boardRiskTeams: function(){
            return function(sessionId,teams){
                var teamNames = [];
                _.each(teams,team=>{
                    if(team.sessionId == sessionId){
                        teamNames.push(team.teamTitle);
                    }
                });
                teamNames = teamNames.join(', ');
                return teamNames;
            }
        },
        riskLevelList: function () {
            if (this.getSessionRiskRegister()) {
                var riskMatrix = this.getSessionRiskRegister().riskMatrix;
                riskMatrix.riskLevelList.sort((a, b) => (a.lowerLimit < b.lowerLimit) ? 1 : -1);
                return (riskMatrix ? riskMatrix.riskLevelList : []);
            }
            return [];
        },

    },

    methods: {
        sortBy: function (colName, notFlip) {
            if (notFlip === undefined)
                this.sortAsc = !this.sortAsc;
            if (colName != this.sortColumn)
                this.sortAsc = true;
            this.sortColumn = colName;
            var sortMode = [this.sortAsc ? 'asc' : 'desc'];

            var _this = this;
            if (colName == 'riskLevel') {
                this.risks = _.orderBy(this.risks, function (risk) {
                    if (!risk.probability || !risk.impact) {
                        return -1;
                    } else {
                        return _this.riskLevel(risk.probability, risk.impact).lowerLimit;
                    }
                }, [sortMode]);
            } else if (colName == 'probability') {
                this.risks = _.orderBy(this.risks, function (risk) {
                    if (!risk.probability) {
                        return -1;
                    } else {
                        return risk.probability.value;
                    }
                }, [sortMode]);
            } else if (colName == 'impact') {
                this.risks = _.orderBy(this.risks, function (risk) {
                    if (!risk.impact) {
                        return -1;
                    } else {
                        return risk.impact.value;
                    }
                }, [sortMode]);
            } else if (colName == 'status') {
                this.risks = _.orderBy(this.risks, function (risk) {
                    if (!risk.status) {
                        return -1;
                    } else {
                        if (risk.status.category === 'ToDo') {
                            return 0;
                        } else if (risk.status.category === 'InProgress') {
                            return 1;
                        } else if (risk.status.category === 'Done') {
                            return 2;
                        } else {
                            return 3;
                        }
                    }
                }, [sortMode]);
            } else if (colName === 'itemsCount') {
                this.risks = _.orderBy(this.risks, function (risk) {
                    if (_.isEmpty(risk.linkedItemsIds)) {
                        return 0;
                    } else {
                        return risk.linkedItemsIds.length;
                    }
                }, [sortMode]);
            } else if (colName === 'responsible') {
                var sortedRiskOnResponsible = [];
                var unsortedRisk = [];
                _.each(this.risks, risk => {
                    if (risk.responsible) {
                        sortedRiskOnResponsible = sortedRiskOnResponsible.concat(risk);
                    } else {
                        unsortedRisk = unsortedRisk.concat(risk);
                    }
                });

                sortedRiskOnResponsible = _.orderBy(sortedRiskOnResponsible, function (risk) {
                    return risk.responsible.firstName.toLowerCase();
                }, [sortMode])

                if (sortMode[0] === "desc") {
                    this.risks = unsortedRisk;
                    if (!_.isEmpty(sortedRiskOnResponsible)) {
                        this.risks = this.risks.concat(sortedRiskOnResponsible);
                    }
                } else {
                    this.risks = sortedRiskOnResponsible;
                    if (!_.isEmpty(unsortedRisk)) {
                        this.risks = this.risks.concat(unsortedRisk);
                    }
                }


            } else if (colName === 'teams') {
                var teamSequence = JSON.parse(JSON.stringify(this.riskRegister.sessionBoard.teamSequence)); // getting board's team sequence
                if (sortMode[0] === "desc") {
                    teamSequence = teamSequence.reverse();					// reversing sequence for descending order
                }
                var sortedRiskOnTeams = [];
                var unsortedRisk = [];
                unsortedRisk = _.filter(this.risks, risk => {				// storing all risks which are not linked to any teams
                    if (_.isEmpty(risk.boardTeams)) {
                        return risk;
                    }

                })
                var firstLoop = true;
                _.each(teamSequence, teamSeq => {
                    sortedRiskOnTeams = sortedRiskOnTeams.concat(_.filter(this.risks, risk => {			// sorting risks according to sequence
                        if (!_.isEmpty(risk.boardTeams)) {
                            var boardTeam
                            var notPresent = true;
                            for (var i = 0; i < risk.boardTeams.length; i++) {
                                if (risk.boardTeams[i].sessionId == this.riskRegister.sessionBoard.session.id) {
                                    boardTeam = risk.boardTeams[i];
                                    notPresent = false;
                                    break;
                                }
                            }
                            if (boardTeam != undefined) {
                                if (boardTeam.teamId == teamSeq) {
                                    return risk;
                                }
                            }
                            if (notPresent && (_.isEmpty(unsortedRisk) || firstLoop)) {  // checking if there is risk which donot have any team linked for that specific session
                                unsortedRisk = unsortedRisk.concat(risk);
                            }

                        }

                    }));
                    firstLoop = false;
                })
                if (sortMode[0] === "asc") {
                    if (!_.isEmpty(sortedRiskOnTeams)) {
                        this.risks = unsortedRisk;
                        this.risks = this.risks.concat(sortedRiskOnTeams);					// concatinating risk which did not have any teams linked
                    }
                } else {
                    if (!_.isEmpty(sortedRiskOnTeams)) {
                        this.risks = sortedRiskOnTeams;
                        this.risks = this.risks.concat(unsortedRisk);					// concatinating risk which did not have any teams linked
                    }
                }

            } else if (colName === 'sprints') {
                var boardContainers = JSON.parse(JSON.stringify(this.riskRegister.sessionBoard.containers));
                boardContainers = _.orderBy(boardContainers, ["sequence"], [sortMode]);
                var sortedRiskOnContainers = [];
                var unsortedRisk = _.filter(this.risks, risk => {				// storing all risks which are not linked to any sprints
                    if (_.isEmpty(risk.boardSprints)) {
                        return risk;
                    }
                })
                var firstLoop = true;
                _.each(boardContainers, containerSeq => {
                    sortedRiskOnContainers = sortedRiskOnContainers.concat(_.filter(this.risks, risk => {			// sorting risks according to sequence
                        if (!_.isEmpty(risk.boardSprints)) {
                            var boardSprint
                            var notPresent = true;
                            for (var i = 0; i < risk.boardSprints.length; i++) {
                                if (risk.boardSprints[i].sessionId == this.riskRegister.sessionBoard.session.id) {
                                    boardSprint = risk.boardSprints[i];
                                    notPresent = false;
                                    break;
                                }
                            }
                            if (boardSprint != undefined) {
                                if (boardSprint.sprintId == containerSeq.id) {
                                    return risk;
                                }
                            }

                            if (notPresent && (_.isEmpty(unsortedRisk) || firstLoop)) {  // checking if there is risk which donot have any sprint linked for that specific session
                                unsortedRisk = unsortedRisk.concat(risk);
                            }
                        }

                    }));
                    firstLoop = false;
                })

                if (sortMode[0] === "asc") {

                    if (!_.isEmpty(sortedRiskOnContainers)) {
                        this.risks = unsortedRisk;
                        this.risks = this.risks.concat(sortedRiskOnContainers);					// concatinating risk which did not have any teams linked
                    }
                } else {
                    if (!_.isEmpty(sortedRiskOnContainers)) {
                        this.risks = sortedRiskOnContainers;
                        this.risks = this.risks.concat(unsortedRisk);					// concatinating risk which did not have any sprints linked
                    }
                }

            } else {
                this.risks = _.orderBy(this.risks, [colName], [sortMode]);
            }

            this.risks.map(r => r.showConversations = false);
        },

        showLinkedItems: function(risk){
            this.showOverlay = false;
            this.showItemsSearch = false;
            this.closeAllExpandedRisks(risk);
            risk.showLinkedItems = !risk.showLinkedItems;

            if(!risk.linkedItems || risk.linkedItems.length <= 0){
                this.fetchLinkedItems(risk);
            }
            this.$forceUpdate();
        },

        fetchLinkedItems: function(risk){
            getRiskLinkedItems(risk);/**defined in risk.js**/
        },

        closeAllExpandedRisks: function(risk){
            this.showOverlay = false;
            for(var i = 0 ; i < this.risks.length ; i ++){
                if(!risk || this.risks[i].id != risk.id)
                    this.risks[i].showLinkedItems = false;
            }
        },

        showSearch: function(risk){

            this.selectedRisk = risk;

            this.setLinkItemsPopupData();
            this.showItemsSearch = true;

            this.showOverlay     = true;
        },

        onLoadLinkPopupData: function (data) {

            var popupData      = {};
            popupData.features = data.features;
            popupData.stories  = data.stories;

            this.$options._linkPopupData               = {};
            this.$options._linkPopupData.data          = popupData;
            this.$options._linkPopupData.sessionBoards = data.sessionBoards;
        },

        saveLinkedItems1: function(items,risk) {

            var linkedItems = risk.linkedItems;

            risk.linkedItems    = [];
            risk.linkedItemsIds = [];

            var _this = this;
            if (!_.isEmpty(linkedItems)) {
                _.each(linkedItems,item=>{
                    if (!_this.isItemFromCurrentSession(item)) {
                        risk.linkedItemsIds.push(item.id);
                    }
                });
            }
            _.each(items,item=>{
                risk.linkedItemsIds.push(item.id);
            });

            this.updateRiskItems(risk);
            var index = _.findIndex(this.copyRisks, { id: risk.id });
            this.copyRisks[index] = risk;
            showTopMessage("Item linked", 'success');
        },

        updateRiskItems: function (risk) {
            updateRiskLinks(risk);
        },

        loadMetaDataForEditPopUp: function () {
            var params = new ajaxParams('/riskregister/get-all', 'GET', null, 'loadMetaDataForEditPopUpCallback', undefined, this);
            ajaxRequest(params);
        },

        loadMetaDataForEditPopUpCallback: function (response) {
            if (response) {
                this.users = response['users'];
                this.riskMatrices = response['riskMatrices'];
                this.workFlows = response['workFlows'];
                this.$options._users = this.users;
                if(this.getSessionRiskRegister()){
                    if(this.getSessionRiskRegister().workflow.id){
                        var riskstatus = _.find(this.workFlows,workflow=>{
                            if(workflow.id == this.getSessionRiskRegister().workflow.id){
                                return workflow.statuses;
                            }
                        });
                        this.$options._statuses = riskstatus.statuses;
                    }

                }

                this.$forceUpdate();
                this.openEditPopup();
            }
        },

        openEditPopup:function (){
            let risk=this.editRiskData;
            if (!risk) {
                risk = {};
            }

            var sessions = [{id:this.riskRegister.sessionBoard.session.id,name:this.riskRegister.sessionBoard.session.title}];
            var linkedBoards = [{id:this.riskRegister.sessionBoard.session.id,name:this.riskRegister.sessionBoard.session.title}];

            this.riskPopup.meta     = {};
            this.riskPopup.meta.linkedBoards = linkedBoards;
            this.riskPopup.meta.sessions     = sessions;
            this.riskPopup.meta.workFlows    = this.workFlows;
            this.riskPopup.meta.users        = this.users;

            this.riskPopup.register = JSON.parse(JSON.stringify(this.getSessionRiskRegister()));
            this.riskPopup.risk = risk;
            this.riskPopup.show = true;
            this.openRiskFromBoard = true;
            this.showOverlay = true;
        },

        onClickOpenRisk: function (risk) {
            this.loadMetaDataForEditPopUp();
            this.editRiskData=risk;
        },

        unlinkItemToRiskAction: function (item, risk) {
            var obj = {};
            obj.risk = risk;
            obj.item = item;
            askFromSweetAlertWrapper("Are you sure to unlink this Item ?",
                [this.unlinkItemToRisk, obj],
                [takeNoAction]);
        },
        unlinkItemToRisk: function (obj) {
            var item = obj.item;
            var risk = obj.risk;
            var index = risk.linkedItemsIds.indexOf(item.id);
            if (index > -1) {
                risk.linkedItemsIds.splice(index, 1);
            }
            var index = _.findIndex(risk.linkedItems, { id: item.id });
            if (index > -1) {
                risk.linkedItems = [];
                this.updateRiskItems(risk);
                showTopMessage("Item unlinked", 'success');
            }
            var copyIndex = _.findIndex(this.copyRisks, { id: risk.id });
            this.copyRisks[copyIndex] = risk;
            this.$forceUpdate();
        },


        setLinkItemsPopupData: function (linkedBoards) {

            if (this.$options._linkPopupData && this.$options._linkPopupData.data != undefined ) {

            }
            else {
                this.$options._linkPopupData              = {};
                this.$options._linkPopupData.linkedBoards = undefined;
                this.$options._linkPopupData.data         = undefined;
            }
        },

        checkIfColumnActive: function (column) {
            for (var i = 0; i < this.multiselectValues.length; i++) {
                if (column === this.multiselectValues[i].value) {
                    return true;
                }
            }
            return false;
        },

        getSessionRiskRegister: function () {
            return this.riskRegister;
        },

        riskLevel: function (probability, impact) {
            return this.calculateRiskLevel(probability, impact, this.riskLevelList);
        },

        calculateRiskLevel: function (probability, impact) {
            return calculateRiskLevel(probability, impact, this.riskLevelList);
        },


        getFormattedDateBritish: function (date) {
            var dateFinal = '';
            var mydate = new Date(date);
            var monthFromDate = mydate.getMonth();
            const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
                "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
            ];
            if (mydate.getFullYear() === 'NaN' || monthNames[monthFromDate] === undefined || mydate.getDate() === 'NaN') {
                return '';
            }
            dateFinal = mydate.getDate() + ' ' + monthNames[monthFromDate] + ' ' + mydate.getFullYear();
            return dateFinal;
        },

        getUserImage: function (user) {
            if (user)
                return getUserImage(user, 'data-action="pic-menu"');
            return getUserImage(loggedInUser, 'data-action="pic-menu"');
        },


        onDeleteRisk: function (riskId) {
            var index = _.findIndex(this.risks,{id:riskId});
            if (index > -1) {
                this.risks.splice(index,1);
            }
            var copyIndex = _.findIndex(this.copyRisks,{id:riskId});
            if (copyIndex > -1) {
                this.copyRisks.splice(copyIndex,1);
            }
            this.$emit("onRiskDelete",riskId);
        },

        onSaveRisk: function (risk, isNew) {

            risk.show = true;
            risk.showLinkedItems = false;
            risk.showConversations = false;
            risk.itemsCount = risk.linkedItemsIds.length;

            if (risk.probability && risk.impact) {
                risk.riskLevel = this.riskLevel(risk.probability,risk.impact);
            }
            if (isNew) {
                this.risks.splice(0,0,risk);
                this.copyRisks.splice(0,0,risk);
            }
            else {
                var index = _.findIndex(this.risks,{id:risk.id});
                if (index > -1) {
                    this.risks.splice(index,1,risk);
                    var copyIndex = _.findIndex(this.copyRisks,{id:risk.id});
                    if(copyIndex>-1){
                        this.copyRisks.splice(copyIndex,1,risk);
                    }
                }
            }
            if(this.sortColumn ==='teams' || this.sortColumn ==='sprints'){
                this.sortColumn = 'riskNumber';
            }
            this.$emit("riskUpdated",risk);
        },


    }
});