var syncId = getNewUUID();
$(document).ready(function () {
    new Vue({
        el: '#my-view',

        components: {
            'my-view': MY_VIEW,
            //Dependencies Components
            'list-dependencies': LIST_DEPENDENCIES,
            'board-row-dependences': ROWDEPENDENCIES,
            'row-alm-dependency': ROWALMDEPENDENCY,
            //Risks Components
            'list-risks': LIST_RISKS,
            'risk-row-component': RISK_ROW_COMPONENT,
            'impedimemt-row-component': IMPEDIMENT_ROW_COMPONENT,
            'risk_linked_items': RISK_LINKED_ITEMS,
            'risk': RISK,
            //Impediments Components
            'list-impediments': LIST_IMPEDIMENTS,
            'edit-impediment': IMPEDIMENT,
            'feature-details': Featuredetail,
            //Action Points Components
            'list-action-points': LIST_ACTION_POINTS,
            'dynamic-popup-container':DYNAMIC_POPUP_CONTAINER
        }
    })
})
const MY_VIEW = Vue.component('my-view', {

    name: 'my-view',

    template: `
    <div class="mcontainer">
        <div class="headmn prow"><div class="mnico FL"></div> <div class="nam ftsb FL">My View</div></div>
        <div class="nwtb head prow">
           <span class="tabs" :class="{active:tab.active}" v-for="tab in tabs" :key="tab.id"  @click="changeTab(tab.text)">{{tab.text}} <span class="count ftsb" v-if="tab.count>0">({{tab.count}})</span></span>
         </div>
        <list-dependencies v-if="itemType==='Dependencies'" 
            :itemLinkList="dependenciesData.itemLinkList"
            :almDependenciesList="dependenciesData.itemJiraDependencyList"
            :sessionBoardsMetaMap="dependenciesData.sessionBoardsMetaMap"
            :linkTypeList="dependenciesData.linkTypeList"
            :watcherList="dependenciesData.watcherList"
            :isLoading="dependenciesData.isLoading"
            :dependencyStatusesListMap="dependenciesData.dependencyStatusesListMap"
            @onDependenciesCountUpdate="updateDependenciesCount"
        />
                        
        <list-risks v-if="itemType==='Risks'"
            :risksList="risksData.risksList"
            :riskRegisterList="risksData.riskRegisterList"
            :watcherList="risksData.watcherList"
            :sessionBoards="risksData.sessionBoards"
            :riskRegisterIdsListMap="risksData.riskRegisterIdsListMap"
            :workFlows="risksData.workFlows"
            :isLoading="risksData.isLoading"
            @onRiskCountUpdate="updateRisksCount"
        />
        
        <list-impediments v-if="itemType==='Impediments'"
           :impediments-list="impedimentsData.items"
           :session-list-map="impedimentsData.sessionsMap"
           :is-loading="impedimentsData.isLoading"
        />
        <list-action-points v-if="itemType==='Action Points'"
           :action-points-list="actionPointsData.items"
           :session-list-map="actionPointsData.sessionsMap"
           :is-loading="actionPointsData.isLoading"
        />
    </div>
	`,

    data() {
        return {
            tabs: {
                "Dependencies": {id: 1, active: false, text: 'Dependencies', count: 0},
                "Risks": {id: 2, active: false, text: 'Risks', count: 0},
                "Impediments": {id: 3, active: false, text: 'Impediments', count: 0},
                "Action Points": {id: 4, active: false, text: 'Action Points', count: 0}
            },
            itemType: 'Dependencies',
            dependenciesData: {
                isLoading: true,
            },
            risksData: {
                isLoading: true,
            },
            impedimentsData: {
                isLoading: true,
            },
            actionPointsData: {
                isLoading: true,
            },
            loggedInUserId: '',
            defaultView: "Dependencies",
        }
    },

    mounted() {
        let _this = this;
        _this.tabs[_this.itemType].active = true;
        const fetchDataInterval = setInterval(() => {
            if (_this.defaultView === "Dependencies") {
                _this.fetchDependenciesList(loggedInUser.id);
            } else if (_this.defaultView === "Risks") {
                _this.fetchRisksList(loggedInUser.id);
            } else if (_this.defaultView === "Impediments") {
                _this.fetchImpedimentsList(loggedInUser.id);
            } else if (_this.defaultView === "Action Points") {
                _this.fetchActionPointsList(loggedInUser.email);
            }
            clearInterval(fetchDataInterval);
        }, 1000)
    },

    watch: {
        itemType: function (newTab, oldTab) {
            if (newTab === this.tabs["Dependencies"].text) {
                this.fetchDependenciesList(loggedInUser.id);
            } else if (newTab === this.tabs["Risks"].text) {
                this.fetchRisksList(loggedInUser.id);
            } else if (newTab === this.tabs["Impediments"].text) {
                this.fetchImpedimentsList(loggedInUser.id);
            } else if (newTab === this.tabs["Action Points"].text) {
                this.fetchActionPointsList(loggedInUser.email);
            }
        }
    },

    methods: {
        updateDependenciesCount: function (count) {
            this.tabs["Dependencies"].count = count;
        },

        updateRisksCount: function (count) {
            this.tabs["Risks"].count = count;
        },

        changeTab: function (tab) {
            let _this = this;
            _.forEach(_this.tabs, function (tab) {
                tab.active = false;
            })
            this.tabs[tab].active = true;
            this.itemType = tab;
        },

        fetchImpedimentsList: function (userId) {
            let _this = this;
            let requestBody = {};
            requestBody["userId"] = userId
            axios.post('my-view/list-impediments', requestBody)
                .then(response => {
                    _this.processImpedimentsListingResponse(response.data);
                })
                .catch(error => {
                    console.error("Impediments fetch error", error);
                });
        },

        fetchActionPointsList: function (userEmail) {
            let _this = this;
            let requestBody = {};
            requestBody["data-mention-id"] = userEmail;
            axios.post('my-view/list-actionpoints', requestBody)
                .then(response => {
                    _this.processActionPointsListingResponse(response.data);
                })
                .catch(error => {
                    console.error("Action Points fetch error", error);
                });
        },

        processImpedimentsListingResponse: function (data) {
            this.impedimentsData = data;
            this.impedimentsData.isLoading = false;
        },

        processActionPointsListingResponse: function (data) {
            this.actionPointsData = data;
            this.actionPointsData.isLoading = false;
        },

        fetchDependenciesList: function (userId) {
            let _this = this;
            let requestBody = {};
            requestBody["userId"] = userId;
            axios.post('my-view/list-dependencies', requestBody)
                .then(response => {
                    _this.processDependenciesListingResponse(response.data)
                })
                .catch(error => {
                    console.error("Dependencies Fetch Error", error);
                });
        },

        processDependenciesListingResponse: function (data) {
            this.dependenciesData = data;
            this.dependenciesData.isLoading = false;
        },

        fetchRisksList: function (userId) {
            let _this = this;
            let requestBody = {};
            requestBody["userId"] = userId;
            axios.post('my-view/list-risks', requestBody)
                .then(response => {
                    _this.processRisksListingResponse(response.data)
                })
                .catch(error => {
                    console.error("Risks Fetch Error", error);
                });
        },

        processRisksListingResponse: function (data) {
            this.risksData = data;
            this.risksData.isLoading = false;
        }

    }
});