const LIST_IMPEDIMENTS = Vue.component('list-impediments', {

    name: 'list-impediments',

    props: ["sessionListMap","impedimentsList", "isLoading"],

    template: `
    <div class="container">
      	<div class="fltout DF">
	        <div class="FG"></div>
	        <div class="aa DF">
		        <div class="selectcont wht">
		            <select v-model="selectedBoard"  @change="onSelectFilter">
		                <option :value="{}">All Boards</option>
		                <option v-for="(board,key) in sessionListMap" :value="board">{{board.title}}</option>
		            </select>
		        </div>		      
		        <div class="selectcont wht">
		            <select v-model="selectedStatus"  @change="onSelectFilter">
		                <option value="All" >Status</option>
		                <option value="Open" >Open</option>
		                <option value="Closed" >Closed</option>
		            </select>
		        </div>
		        <div class="selectcont wht">
		           <vz-select v-model="multiselectValues" :options="multiselectOptions" :multiple="true" label="name" track-by="name" @select="onColumnListUpdation()" />
		        </div>
		         <div class="srbtn p-rel ti-search">
		            <input type="text" v-model="searchQuery" placeholder="Search Risk..." @input="onSelectFilter" />
		        </div>		        
	        </div>
        </div>

		<template v-if="!_.isEmpty(itemGroupBySession) && sessionListMap">
			<template v-if="Object.keys(selectedBoard).length == 0">
				<ul v-for="(sessionGroup, key) in itemGroupBySession" class="list-group">
	               <h1 class="register-title" ><div class="arric b FL"></div>{{sessionListMap[key].title}}</h1>
	               <impedimemt-row-component
						:key="key+'-'+impRowKey"
	                   	:multiselect-values="multiselectValues"
	                  	:impedimemt-list="sessionGroup"
						:severity-field-id="severityFieldId"
						:resolution-date-field-id="resolutionDateFieldId"
						:session="sessionListMap[key]"
	               />
		        </ul>
			</template>
			<template v-else>
				<ul class="list-group">
	               <h1 class="register-title"><div class="arric b FL"></div>{{sessionListMap[selectedBoard.id].title}}</h1>
	               <impedimemt-row-component
						:key="sessionListMap[selectedBoard.id]+'-'+impRowKey"
	                   	:multiselect-values="multiselectValues"
	                  	:impedimemt-list="itemGroupBySession[selectedBoard.id]"
						:severity-field-id="severityFieldId"
						:resolution-date-field-id="resolutionDateFieldId"
						:session="sessionListMap[selectedBoard.id]"
	               />
		        </ul>
			</template>			
        </template>
        
       <edit-impediment v-if="editPopup.show"
	       :impediment="editPopup.impediment" 
	       :board="editPopup.board"
	       @save="saveImpedimentPopup($event, 'viewTop')" 
	       @close="closeImpedimentPopup" 
	       @openFeatureDetailPopup="openFeatureDetailPopup"
       />

       <div class="container">
	       <vuepopup v-if="showFeatureDetailView" >
	           <div class="overlay" style="display: block;" @click="showFeatureDetailView = false"></div>
	           <feature-details @onclosepopup="showFeatureDetailView = false;"  :itemid="featureDetailsView.itemId" :board="featureDetailsView.board"> </feature-details>
	       </vuepopup>
       </div>
    </div>
	`,

    data() {
        return {
            editPopup: {
                show: false,
                impediment: '',
                board: ''
            },
            showFeatureDetailView:false,
            featureDetailsView:{
                itemId:'',
                board:'',
            },
			itemGroupBySession: {},
            collapseRegisterTitle: true,
            selectedStatus: "All",
            defaultCollapseFlag: true,
            selectedBoard: {},
            _filteredRisksList: [],	
            filteredStatusAndSearchRisksList: [],

            multiselectOptions: [
				{"name": "Title",  			"value": "title"}, 
				{"name": "Status", 			"value": "status"}, 
				{"name": "Severity", 		"value": "severity"}, 
				{"name": "Resolution Date", "value": "resolutionDate"}, 
				//{"name": "Conversation", 	"value": "convCount"}, 
			],
            multiselectValues: [
				{"name": "Title", 			"value": "title"}, 
				{"name": "Status", 			"value": "status"},
				{"name": "Severity",		"value": "severity"},
				{"name": "Resolution Date",	"value": "resolutionDate"}, 
				//{"name": "Conversation", "value": "convCount"}, 
			],

			searchQuery: '',
			selectedStatus: 'All',
			severityFieldId: '',
			resolutionDateFieldId: '',
			impRowKey: 0
			
        }
    },

    watch: {
        impedimentsList: function (_newList, _oldList) {
            let _this = this;
            if (_newList && !(_newList.length > 0)) {
                return;
            }
			var impWithTemplate = _.find(_newList, imp=>{
				if (imp.fieldsTemplate) {
					return Object.keys(imp.fieldsTemplate).length>0;
				}
			});
			
			var severityField = _.find(impWithTemplate.fieldsTemplate.configuredFields, {title: "Severity"});
			_this.severityFieldId = severityField.id;
			
			var resolutionDateField = _.find(impWithTemplate.fieldsTemplate.configuredFields, {title: "Resolution Date"});			
			_this.resolutionDateFieldId = resolutionDateField.id;
			
			_this.itemGroupBySession = {};
			_this.groupBySession();
            // this.onSelectFilter();
        },
		sessionListMap: function (_newMap, _oldMap) {
            let _this = this;			
            if (_newMap && !(Object.keys(_newMap).length > 0)) {
                return;
            }
			_this.itemGroupBySession = {};
			_this.groupBySession();
		}
    },
	computed: {
	},
    mounted() {
		this.groupBySession();
    },
    methods: {
        openFeatureDetailPopup:function(param){
            this.featureDetailsView=param;
            this.showFeatureDetailView=true;
            this.editPopup.show=false;
        },
        openEditPopup: function (impediment, scrumId) {
            var copy = _.cloneDeep(impediment);
            var genTime = new Date(copy.updatedOn);
            copy._status = {id: copy.checked + ''};
            if (isNaN(genTime.getTime())) {
                genTime = new Date(copy.createdOn);
                if (isNaN(genTime.getTime())) {
                    copy._updatedOn = null;
                } else {
                    copy._updatedOn = dateFormat(genTime, 'default');
                }
            } else {
                copy._updatedOn = dateFormat(genTime, 'default');
            }
            this.onEditExtractMentionUser(impediment.title);
            this.editPopup.impediment = copy;
            this.editPopup.orignal = impediment;
            this.editPopup.board = impediment.sessionBoard;
            this.editPopup.show = true;
        },

        onEditExtractMentionUser: function (text) {
            MENTION_USERS = [];
            if (!_.isEmpty(text)) {
                var ckResult = ckEditorHtmlToText(text, USERS_FOR_EDITOR);
                if (ckResult && ckResult.mentions && ckResult.mentions.length > 0) {
                    MENTION_USERS = ckResult.mentions
                }
            }
        },

        closeImpedimentPopup: function () {
            this.editPopup.show = false;
        },

        saveImpedimentPopup: function (event, impdtView) {
            console.log(event, impdtView)
            this.editPopup.show = false;
            showTopMessage(event.key + " has been updated.", "success");
        },
		groupBySession: function() {
			let _this = this;
			_.each(_this.impedimentsList, imp=>{
				if(!_.isEmpty(imp.baseItemLinks)) {
					let sessionMap = {};
					_.each(imp.baseItemLinks, itemLink=>{
						if(itemLink.sessionId) {
							let sessionId = itemLink.sessionId;
							if(!sessionMap[sessionId]) {
								sessionMap[sessionId] = true;
								if(!_this.itemGroupBySession[sessionId]) {
									_this.itemGroupBySession[sessionId] = [];
								}
								var searchStringMatch = imp.title.replace(/<[^>]*>/g, ' ').replace(/\s{2,}/g, ' ').replaceAll('&nbsp;','').trim().toLowerCase().
								includes(_this.searchQuery.trim().toLowerCase()) ||  imp.key.toLowerCase().includes(_this.searchQuery.trim().toLowerCase());
								let statusMatch = _this.selectedStatus== "All" || (imp.status.category == "ToDo" && _this.selectedStatus == "Open") 
								|| (imp.status.category == "Done" && _this.selectedStatus == "Closed");
								if(searchStringMatch && statusMatch) {								
									_this.itemGroupBySession[sessionId].push(imp);
								}
							}
						}
					});
				}
			});	
			_this.impRowKey += 1;
			_this.$forceUpdate();		
		},
		onSelectFilter: function() {
			this.itemGroupBySession = {};
			this.groupBySession();
		},		
        onColumnListUpdation: function () {
            
        },				
    }
});