Vue.component('list-webhook-activity', {
    template:
        `
        <div id="webhookActivityListing" class="mt-50">
            <div class="mid-container">        
                <div class="pg-head prow">
                    <h1 class="hd">Webhook Activity List</h1>
                    <div class="srch FR ml-10">
                        <input type="text" v-model="findJiraKey" placeholder="Find by Jira key" @input="filterWebhookActivityList()" />
                    </div>
                </div>
                <div>
                    <ul class="prow" style="margin-top: 3%">
                        <li v-for="webhookActivity in filteredWebhookActivityList" style="margin: 1%">
                            
                            <p v-if = "webhookActivity.causedReasons"><b>Caused Reasons:</b> {{ webhookActivity.causedReasons }}</p>
                            <p><b>Logs:</b> {{ webhookActivity.logs }}</p>
                            
                            <p v-if = "webhookActivity.jiraId"><b>Jira ID:</b> {{ webhookActivity.jiraId }}</p>
                            <p v-if = "webhookActivity.jiraKey"><b>Jira Key:</b> {{ webhookActivity.jiraKey }}</p>

                            <p v-if = "webhookActivity.jiraSourceIssueId"><b>Jira Source Issue ID:</b> {{ webhookActivity.jiraSourceIssueId }}</p>
                            <p v-if = "webhookActivity.jiraSourceIssueKey"><b>Jira Source Issue Key:</b> {{ webhookActivity.jiraSourceIssueKey }}</p>
                            
                            <p v-if = "webhookActivity.jiraDestinationIssueId"><b>Jira Destination Issue ID:</b> {{ webhookActivity.jiraDestinationIssueId }}</p>
                            <p v-if = "webhookActivity.jiraDestinationIssueKey"><b>Jira Destination Issue Key:</b> {{ webhookActivity.jiraDestinationIssueKey }}</p>
                                                                                    
                            <p><b>Alm Account ID:</b> {{ webhookActivity.almAccId }}</p>
                            <p><b>Created On:</b> {{timestampToDateTime(webhookActivity.createdOn)}}</p>
                            <hr/>
                        </li> 
                    </ul>
                </div>
            </div>
        </div>

    `,
    data() {
        return {
            webhookActivityList: [],
            filteredWebhookActivityList: [],
            findJiraKey: ''
        }
    },

    mounted() {
        axios.get("/webhook/health").then(response => {
            if (response.data) {
                this.webhookActivityList = response.data.webhookActivity;
                this.filteredWebhookActivityList = this.webhookActivityList;
            }
        }).catch(error => {
            console.log(error)
        })
    },

    methods: {
        filterWebhookActivityList: function () {
            if (!this.findJiraKey || this.findJiraKey.length < 1) {
                this.filteredWebhookActivityList = this.webhookActivityList;
            } else {
                this.filteredWebhookActivityList = [];
                const jiraKeyToFind = this.findJiraKey.toLowerCase();
                this.filteredWebhookActivityList = this.webhookActivityList.filter((webhookActivity) => {
                    const jiraKeys = [];
                    if (webhookActivity.jiraKey) {
                        jiraKeys.push(webhookActivity.jiraKey);
                    }
                    if (webhookActivity.jiraSourceIssueKey) {
                        jiraKeys.push(webhookActivity.jiraSourceIssueKey);
                    }
                    if (webhookActivity.jiraDestinationIssueKey) {
                        jiraKeys.push(webhookActivity.jiraDestinationIssueKey);
                    }
                    let found = false;
                    for (const jiraKey in jiraKeys) {
                        if (jiraKeys[jiraKey].toLowerCase().includes(jiraKeyToFind)) {
                            found = true;
                            break;
                        }
                    }
                    return found;
                })
            }
        },
        timestampToDateTime: function(timestamp){
            const date = new Date(timestamp);

            const year = date.getFullYear();
            const month = date.getMonth() + 1;
            const day = date.getDate();

            const hours = date.getHours();
            const minutes = date.getMinutes();
            const seconds = date.getSeconds();

            return `${year}-${this.padZero(month)}-${this.padZero(day)} ${this.padZero(hours)}:${this.padZero(minutes)}:${this.padZero(seconds)}`;
        },
        padZero: function(number){
            return number.toString().padStart(2, '0');
        }
    }
});

new Vue({
    el: "#webhook-health"
});

