var URL_PARAMETER_MIXIN = {
    data() {
        return {

        }
    },
    methods: {
        getUrlParams: function () {

            let fullPath = window.location.href;
            let pathParts = fullPath.split("?");

            let params = {};

            if (pathParts.length == 2) {
                let paramStr = pathParts[1];
                let paramPairs = paramStr.split("&");
                for (let i = 0 ; i < paramPairs.length; i++) {
                    let keyValue = paramPairs[i].split("=");
                    params[keyValue[0]] = keyValue[1];
                }
            }
            return params;
        },
        setUrlParams: function (params) {

            let fullPath = this.$route.fullPath;
            let pathParts = fullPath.split("?");

            let paramsStr = getParamsStr(params);
            let finalPath = pathParts[0] + "?" + paramsStr;

            this.$router.push({ path: finalPath});

            function getParamsStr(params) {
                let str = "";
                for (key in params) {
                    if (str.length == 0) {
                        str += (key+"="+params[key]);
                    }else {
                        str += ("&"+key+"="+params[key]);
                    }
                }
                return str;
            }

            return params;
        },
        getUrlParam: function (key) {
            let params = this.getUrlParams();
            return params[key];
        },
        setUrlParam: function (key, value) {
            let params = this.getUrlParams();
            params[key] = value;

            this.setUrlParams(params);
        },
        deleteUrlParam: function (key) {

            let params = this.getUrlParams();
            delete params[key];

            this.setUrlParams(params);
        },

    }
}


var objectivesRtVU = undefined;
var USERS_FOR_EDITOR = null;
syncId = getNewUUID();
let isScrolling;
Vue.use(EmojiPicker);

function toggleDraggable(option) {
    if(typeof objectivesRtVU != "undefined") {
	    if(objectivesRtVU.$refs &&  objectivesRtVU.$refs['objectivesRef'] && !_.isEmpty(objectivesRtVU.$refs['objectivesRef'].sortableInstance)) {
	        objectivesRtVU.$refs['objectivesRef'].sortableInstance.option('disabled', option);
	    }
	}else if(typeof objectivesVU != "undefined") {
	    if(objectivesVU.$refs &&  objectivesVU.$refs['objectivesRef'] && !_.isEmpty(objectivesVU.$refs['objectivesRef'].sortableInstance)) {
	        objectivesVU.$refs['objectivesRef'].sortableInstance.option('disabled', option);
	    }
	}else if(typeof vueInstance != "undefined") {
	    if(vueInstance.$refs &&  vueInstance.$refs['objectivesRef'] && !_.isEmpty(vueInstance.$refs['objectivesRef'].sortableInstance)) {
	        vueInstance.$refs['objectivesRef'].sortableInstance.option('disabled', option);
	    }
	}
}
const LIST_OBJECTIVES = Vue.component('list-objectives', {
    mixins: [MILESTONE_MIXIN, OBJECTIVE_MIXIN, CALCULATION_SETTINGS_MIXIN, URL_PARAMETER_MIXIN, PAGE_LOAD_MIXIN],
    props: {
        customViewId: {
            type: String,
            default: () => {
                return "";
            }
        },
		customView: {
            type: Object,
            default: () => {
                return undefined;
            }
        },
        shouldLoadObjectives: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        showCreationMenu: {
            type: Boolean,
            default: () => {
                return true;
            }
        },

        objectiveGroups: {
            type: Array,
            default: () => {
                return []
            }
        },
        isSolutionBoard: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isArt: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        releaseTrainId: {
            type: String,
            default: () => {
                return "";
            }
        },
        board: {
            type: Object,
            default: () => {
                return {};
            }
        },
        solutionBoard: {
            type: Object,
            default: () => {
                return {};
            }
        },
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isObjectiveMainView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        hideOkr: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        isMockingMode: {
            type: Boolean,
            default: () =>{ return false }
        },
		isFeatureDetailView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
		isGlobalObjectiveView: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
		enablePrioritizedOkrs: {
            type: Boolean,
            default: () => {
                return false;
            }
		},
        isBatchView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        isSOSPage: {
            type: Boolean,
            default: false,
        },
        isPdfExport: {
            type: Boolean,
            default: () => false
        },
    },

    template: /*html*/`
              <div class="anltcspad predictive active pibrdobj " :class="isMockingMode? 'obj-rt': ''" @scroll="scrolling">
                    <objective-theme-progress v-if="showObjectiveThemeProgress && !loader.show" :objectiveGroupsId="allGroupIds" :isArt="isArt" :isGlobalObjectiveView="isGlobalObjectiveView" :radioTypeSelection="'objectiveGroup'" @closeThemeProgress="closeThemeProgress" :isOkrEnabled="objectiveMenuOptions['isOkrEnabled']" :objectiveGroupList="unFilteredObjectiveGroupList" :board="board" :allObjectiveIds="allObjectiveIds" :completionCriteria="completionCriteria" :customView="activeCustomView" :releaseTrainTitle="releaseTrainTitle"/>
                    <custom-view-popup v-if="customViewPopup.show"
                        :view="activeCustomView"
                        :statuses="cvStatuses"
                        :collections="collections"
                        :priorities="cvPriorities"
                        :types="cvTypes"
                        :read-only="!cvPermissions.includes('strategic-themes-create-edit')"
                        @close="onCustomViewClose"
                        @create="onCustomViewCreate"
                        @update="onCustomViewUpdate"
                        >
                    </custom-view-popup>
                    <div v-if="!_.isEmpty(activeCustomView)" :style="{backgroundColor: activeCustomView.color ? activeCustomView.color : '#fff'}" class="custom-view-header mb-10" :class="activeCustomView?.color ? 'darkver' : 'lightver'">
                        <div class="cnthd p-rel">
                        <div @click="onClickBackButton" class="DFA c-point backara" :style="{color: activeCustomView.textColor || (activeCustomView.color ? '#ffffff' : '#000000')}"> 
                        	<em class="arr-backaa DIB mr-5 DFA">
                        		<svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg" :style="{fill: activeCustomView.textColor || (activeCustomView.color ? '#ffffff' : '#000000')}">
								<path d="M9 18C13.9603 18 18 13.9603 18 9C18 4.03967 13.9603 0 9 0C4.03967 0 0 4.03967 0 9C0 13.9603 4.03967 18 9 18ZM9 0.939457C13.4342 0.939457 17.0605 4.54697 17.0605 9C17.0605 13.453 13.453 17.0605 9 17.0605C4.56576 17.0605 0.939457 13.4342 0.939457 9C0.939457 4.56576 4.56576 0.939457 9 0.939457ZM4.77244 9.3382C4.6785 9.24426 4.64092 9.13152 4.64092 9C4.64092 8.86848 4.69729 8.75574 4.77244 8.6618L7.29019 6.14405C7.47808 5.95616 7.77871 5.95616 7.94781 6.14405C8.1357 6.33194 8.1357 6.63257 7.94781 6.80167L6.21921 8.53027H12.8894C13.1524 8.53027 13.3591 8.73695 13.3591 9C13.3591 9.26305 13.1524 9.46973 12.8894 9.46973H6.238L7.9666 11.1983C8.15449 11.3862 8.15449 11.6868 7.9666 11.8559C7.87265 11.9499 7.75992 11.9875 7.62839 11.9875C7.49687 11.9875 7.38413 11.9499 7.29019 11.8559L4.77244 9.3382Z" fill=""/>
								</svg>
                        	</em> Back  
                        </div>
                            
                        <div v-if="activeCustomView.id !== '-1'" class="button h-auto rnd4 dtlbtn" :style="{color: activeCustomView.textColor || (activeCustomView.color ? '#ffffff' : '#000000')}" @click="onCustomViewOpenPopup">Details</div>

                        <div class="view-title mb-20">
                            <div class="DFA">
                                <div v-if="activeCustomView?.icon" class="ml-10 group-coll-icon"><i :style="{color: activeCustomView.textColor || (activeCustomView.color ? '#ffffff' : '#000000')}" class="material-symbols-outlined mr-10 icol">{{activeCustomView.icon}}</i></div>
                                <span class="fs-24 ftsb" :class="activeCustomView?.color ? 'whtclr' : ''" :style="{color: activeCustomView.textColor || (activeCustomView.color ? '#ffffff' : '#000000')}">{{activeCustomView.title}}</span>
                            </div>
                            <span class="fs-13 w-70pc mt-10" style="text-align: center;" v-if="activeCustomView.shortSummary" :class="activeCustomView?.color ? 'whtclr' : ''" :style="{color: activeCustomView.textColor || (activeCustomView.color ? '#ffffff' : '#000000')}">{{activeCustomView.shortSummary}}</span>
                        </div>
                        </div>
                        <div class="paticons-bg" :class="activeCustomView?.color ? (activeCustomView?.backgroundPattern + '-bg') : ''"></div>
                    </div>
					<div v-if="newLoader" class=" soskeltonl"></div>
              		<div class="" v-if="loader.show || cvLoader">

              		<div class="okrSekeltonWrap">
              				<div class="prow" is-bv-achievement-enabled="true">
              					<div class="obtop objtb aa DFCB p-rel">
              						<div class="lft DFA">
              							
              							<div class="singleBarAnimation p-rel mr-10">
									        <div class="loading-line customLine"></div>
								        </div>
								        <div class="singleBarAnimation p-rel">
									        <div class="loading-line customLine"></div>
								        </div>
              						</div> 
              						<div class="rht DFA">
              							<div class="srch ti-search nww ml-20">
              								<input type="text" placeholder="Search..." class="srch activeText" style="width: 200px;">
              							</div> 
              						</div>
              					</div>
              				</div>
              				
              				
              				<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0 customHdLine"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
							  <div class="oDetail prow">
							  	<div class="rec hd inn normal objout DFCB pr-10">
							  		<div class="lft DFA pl-10">
							  			<div class="singleBarAnimation p-rel pl-5">
									        <div class="loading-line customLine"></div>
								    	</div>
								    </div> 
							  		<div class="rht DFA">
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx"> 
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										   	</div>
							  			</div>
							  		</div>
							  </div> 
							</div>
							
							
						</div>
						              				<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0 customHdLine"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
							  <div class="oDetail prow">
							  	<div class="rec hd inn normal objout DFCB pr-10">
							  		<div class="lft DFA pl-10">
							  			<div class="singleBarAnimation p-rel pl-5">
									        <div class="loading-line customLine"></div>
								    	</div>
								    </div> 
							  		<div class="rht DFA">
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx"> 
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										   	</div>
							  			</div>
							  		</div>
							  </div> 
							</div>
							<div class="oDetail prow">
							  	<div class="rec hd inn normal objout DFCB pr-10">
							  		<div class="lft DFA pl-10">
							  			<div class="singleBarAnimation p-rel pl-5">
									        <div class="loading-line customLine"></div>
								    	</div>
								    </div> 
							  		<div class="rht DFA">
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx"> 
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										   	</div>
							  			</div>
							  		</div>
							  </div> 
							</div>
						</div>
						              				<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0 customHdLine"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
						</div>
						              				<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0 customHdLine"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
						</div>
						              				<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0 customHdLine"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
							  <div class="oDetail prow">
							  	<div class="rec hd inn normal objout DFCB pr-10">
							  		<div class="lft DFA pl-10">
							  			<div class="singleBarAnimation p-rel pl-5">
									        <div class="loading-line customLine"></div>
								    	</div>
								    </div> 
							  		<div class="rht DFA">
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx"> 
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										   	</div>
							  			</div>
							  		</div>
							  </div> 
							</div>
							 <div class="oDetail prow">
							  	<div class="rec hd inn normal objout DFCB pr-10">
							  		<div class="lft DFA pl-10">
							  			<div class="singleBarAnimation p-rel pl-5">
									        <div class="loading-line customLine"></div>
								    	</div>
								    </div> 
							  		<div class="rht DFA">
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx">
							  				<div class="singleBarAnimation p-rel">
											    <div class="loading-line customLine"></div>
										    </div>
							  			</div> 
							  			<div class="rc c1  fx"> 
							  				<div class="singleBarAnimation p-rel">
											     <div class="loading-line customLine"></div>
										   	</div>
							  			</div>
							  		</div>
							  </div> 
							</div>
						</div>
						              				<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0 customHdLine"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
							  
						</div>
						<div class="table content oTable nwobj active rmv-obj-arch rmv-okr-arch"  style="border-left: 7px solid #B5C4CE;">
              					<div class="rec hd oTitle list DFCB pl-10">
              						<div class="lft DFA w-full">
              							<div class="singleBarAnimation p-rel okrSekeltoncardHd w-full">
									        <div class="loading-line w-full mt-0"></div>
								    	</div>
									</div> 
									<div class="rht DFA">
										<div class="rhtinsd DF ml-10 pr-10">
												<div class="singleBarAnimation p-rel">
									        		<div class="loading-line customLine"></div>
								    			</div>
												<div class="spr-vrt ml-10 mr-10"></div> 
												<div class="singleBarAnimation p-rel">
											       <div class="loading-line customLine"></div>
										    	</div>
										</div>
									</div>
							   </div> 
							  
						</div>
              		</div>
              		</div>
                <template v-if="isLoaded && !cvLoader">
                    <div class="lft DFA c-point casOkraccord" :class="[showPrioritizedOkrs? 'mb-0' : 'mb-10 bdrbtm']" v-if="enablePrioritizedOkrs && (!_.isEmpty(prioritizedOkrs) || !_.isEmpty(prioritizedOkrGroup))" @click="showPrioritizedOkrs = !showPrioritizedOkrs;">
                    <div class="casOkraccordinner">
                        <em class="acrd-arr mr-5" :class="[showPrioritizedOkrs? 'ti-angle-down' : 'ti-angle-right']" style="color: #9a12b3"></em>
                        <span class="DFA-a">
                            <b data-action="accord-o" style="color: #9a12b3;"> Cascading Top-Down OKRs</b>
                        </span>
                         </div>
                    </div>
                    <objective-group-component 
                        v-if ="!_.isEmpty(prioritizedOkrGroup) && showPrioritizedOkrs"
                        :objective-group="prioritizedOkrGroup" 
                        :group-type="getGroupType(prioritizedOkrGroup.baseItemLinks)"
                        :board="getDummyBoard('-1')"
                        :teams-list="teams"
                        :is-user-searching="isUserSearching"
                        :objective-list="prioritizedOkrGroup.baseItemList"
                        :kr-progress-criteria-field-id = "krProgressCriteriaFieldId"
                        :is-global-objective-view="true"
                        :read-only-view="true"
                        :is-mocking-mode = "true"
                        :is-prioritized-obj-listing-view= "true"
                        :isObjectiveMainView="isObjectiveMainView"
                        :isGlobalObjectiveView="isGlobalObjectiveView"
                        :is-batch-view="isBatchView"
                        :isSOSPage="isSOSPage"
                        :customView="activeCustomView"
                        @expandCollapseGroupObjective = "onExpandCollapseObjective"
                    />

                    <!--<objective-group-component 
                        v-if ="!_.isEmpty(prioritizedOkrs) && showPrioritizedOkrs"
                        v-for="objectiveGroup in prioritizedOkrs" 
                        :objective-group="objectiveGroup" 
                        :group-type="getGroupType(objectiveGroup.baseItemLinks)"
                        :board="getDummyBoard('-1')"
                        :teams-list="teams"
                        :is-user-searching="isUserSearching"
                        :objective-list="objectiveGroup.baseItemList"
                        :objective-group-list="prioritizedOkrs"
                        :is-global-objective-view="true"
                        :read-only-view="true"
                        :is-mocking-mode = "true"
                        :is-prioritized-obj-listing-view= "true"
                        :departments-map="departmentsMap"
                        :sessions-map="sessionsMap"
                        :batches-map="batchesMap"
                        @expandCollapseGroupObjective = "onExpandCollapseObjective"
                    />-->
                  <div class="DF w-full lstobjcont">
					<div :class="showCheckIns ? 'chkInMode scrollBar' : 'w-full offcheckin'">
                     <objective-menu-component 
                       v-if="showCreationMenu && !loader.show && !isFeatureDetailView && !isPdfExport"
                       :key="menuComponentKey"
                       ref="obj-menu"
                       :board="board"
                       :teams="teams"
                       :is-solution-board="isSolutionBoard"
                       :is-okr-enabled="isOkrEnabled"
                       :is-objective-main-view="isObjectiveMainView"
                       :uncommitted-obj-enabled="isUncommittedObjEnabled()"
                       :is-bv-achievement-enabled="isBvAchievementEnabled"
                       :is-status-enabled="isStatusEnabled"
                       :objective-menu-options="objectiveMenuOptions"
                       :read-only-view="readOnlyView"
                       :is-art="isArt"
                       :show-objective-banner="showObjectiveBanner"
                       :is-mocking-mode = "isMockingMode"
                       @onOpenRoadmap = "onOpenRoadmap"
                       :isGlobalObjectiveView="isGlobalObjectiveView"
                       :custom-view="_.isEmpty(customView) ? activeCustomView : customView"
                       :is-batch-view="isBatchView"
                       :art-collections="collections"
                       @addCollectionObjectiveGroup="onAddCollectionObjectiveGroup"
                       :isSOSPage="isSOSPage"
                       @uncommittedObjToggle="toggleUncommittedObjOption"
                       @toggleBvAchievementEnabled="toggleBvAchievementEnabled"
                       @onAddCustomClickHandle="onAddCustomClickHandle"
                       @addTeamObjectiveGroup="addTeamObjectiveGroup"
                       @onSearchInputChange="doFilterObjectiveList"
                       @exportReport="exportReport"
                       @exportTheme="exportTheme"
                       @statusToggle="statusToggle"
                       @toggleExpand="toggleExpand"
					   @show-check-ins="changeCheckIns(true)"
                       @save-excluded-items="saveExcludeItems"
                       @update-objective-workspace="updateObjectiveWorkspace"
                       @progress="openThemeProgressPopup"
                       @updateCustomViewSettings="updateCustomViewSettings"
                       @onTimePeriodFilter="applyTimePeriodFilter"
                       @updateCompletionCriteria="updateCompletionCriteria"
                       @showStrategicThemes="showStrategicThemes"
                       @onFilterResponsible="applyResponsibleFilter"
                       @onFilterAssociation="applyAssociationFilter"
                       @onFilterStatus="applyStatusFilter"
                       @resetFilters="resetFilters"
                     />
                   
                   <add-custom-objective-form-component 
                        v-for="count in addCustomFormCounter" 
                        :board="board"
                        @createCustomGroupObjective="onCreateCustomObjective"
                        @closeCustomObjectiveView="closeCustomObjectiveView"/>
                        
                   <div :ref="'draggableElement'" class="tabin prog_2 ui-sortable scrollBar" data-type="parent" :key="reRenderKey">
                       <template v-if="getObjectivesList && getObjectivesList.length>0">
							<template v-if="!isMockingMode && filteredGroups.length == 0">
							    <div class="nofound"> No Objective Group Selected </div>
							</template>
                            <objective-group-component 
                                v-for="objectiveGroup in getObjectivesList"
								v-show="showGroup(objectiveGroup.id)" 
								v-observe-visibility="(isVisible, entry) => onVisiblityChange(isVisible, entry, objectiveGroup)"
                                :ref="'objectiveGroup-'+objectiveGroup.id"
                                :key="objectiveGroup.id + objectiveGrpKeyMap[objectiveGroup.id]"
                                :objective-group="objectiveGroup" 
                                :board="board"
                                :is-solution-board="true"
                                :solution-board="solutionBoard"
                                :group-type="getGroupType(objectiveGroup.baseItemLinks)"
                                :teams-list="teams"
                                :is-user-searching="isUserSearching"
                                :objective-list="objectiveGroup.baseItemList"
                                :is-uncommitted-objective-enabled="isUncommittedObjEnabled()"
                                :objective-group-list="getObjectivesList"
                                :is-bv-achievement-enabled="isBvAchievementEnabled"
                                :is-status-enabled="isStatusEnabled"
                                :read-only-view="readOnlyView"
                                :hide-okr="hideOkr"
                                :is-mocking-mode = "isMockingMode"
                                :is-feature-detail-view="isFeatureDetailView"
                                :is-global-objective-view="isGlobalObjectiveView"
                                :kr-progress-criteria-field-id = "krProgressCriteriaFieldId"
								:is-art="isArt"
								:release-train-id="releaseTrainId"
								:departments-map="departmentsMap"
		                        :sessions-map="sessionsMap"								
								:batches-map="batchesMap"
								:is-items-loaded="isItemsLoaded"
								:use-old-api-for-old-state-data="useOldApiForOldStateData"
                                :objective-column-settings="getColumnSettings"
                                :time-period-filter="timePeriodFilter"
                                :kr-parent-time-period-field-id="timePeriodFieldId"
                                :isObjectiveMainView="isObjectiveMainView"
                                :isGlobalObjectiveView="isGlobalObjectiveView"
                                :kr-parent-start-date-field-id="startDateFieldId"
                                :kr-parent-end-date-field-id="endDateFieldId"
                                :isSOSPage="isSOSPage"
                                :is-batch-view="isBatchView"
                                :customView="activeCustomView"
                                @updateGroupSilently="onUpdateObjectiveGroup"
                                @updateGroupObjective="onUpdateObjectiveGroup"
                                @expandCollapseGroupObjective = "onExpandCollapseObjective"
                                @onObjectiveGroupDelete="confirmDeleteObjectiveGroup"
                                @updateReRenderKey="updateReRenderKey"
                                @updateGroupList="updateGroupList"
                                @open-obj-from-other-group="openLinkedObjFromOtherGroup"
                                @updateObjectiveGroupList="updateObjectiveGroupList"
                            />
                       </template>
                       <div class="" v-else-if="isMockingMode && getObjectivesList.length === 0 && showObjectiveBanner && (isArt || isBatchView)">
                       		<div class="nobrdcnt">
							<div v-if="roleErrorMessage !='' "class="expmsg" v-html="roleErrorMessage"></div>
                       			<div class="noBrdhd">
                       				<div class="DFCB">
                       						<div class="okrBrdhd DFA">
							  					<img class="mr-5" src="assets/icons/edit3.svg" alt="Strategic" /> 
							  						Strategic Themes
							  					<div class="spr-vrt ml-20"></div>
							  					<a href="javascript:void(0);" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE && (isArt || isBatchView)" id="add-c" class="okr-add ti-plus addf FL" @click="onAddCustomClickHandle">Add</a>
    											<!-- <a href="javascript:void(0);" id="add-c" class="okr-add ti-plus addf FL">Add Custom</a> -->
							  				</div>
							  				<div>
							  					<div class="rht DFA">
							  						<div class="c-point button h-auto nwabtn DFA mr-10" @click="changeCheckIns">Check-Ins</div>
							  						<div class="withicon slctdn DFA p-rel c-point h-auto">
							  						<div class="wicon DAJ b">%</div> <!----></div> 
							  							<div class="srch ti-search nww ml-10">
							  								<input type="text" placeholder="Search..." class="srch rnd6" style="width: 200px;" />
							  							</div>
							  							 <!----> 
							  								<div id="obj_settings" class="drop_box nwmu obj_settings">
							  									<div class="overlay" style="display: block;"></div> 
						  										<div tabindex="0" class="objcont prow">
						  											<div class="hd ftsb">
						  												Settings <span onclick="closeAllOverLay()" title="Close" class="rmv-ico ti-close rnd DAJ"></span>
						  											</div> 
						  											<div class="head ftsb"> Objectives </div> 
						  											<ul>
						  												<li>
							  												<div class="switch-button grn switch-button-sm FR">
							  													<input id="bvAchievement" type="checkbox"> 
							  													<span>
							  														<label for="bvAchievement"></label>
							  													</span>
							  												</div> 
							  												<div class="text ftsb FL">
							  													BV Achievement
							  												</div>
						  												</li> 
						  												<li>
						  													<div class="switch-button grn switch-button-sm FR">
						  														<input id="unCommitted" type="checkbox"> 
						  														<span>
						  															<label for="unCommitted"></label>
						  														</span>
						  													</div> 
						  													<div class="text ftsb FL">
						  														Uncommitted Objectives
						  													</div>
						  												</li> 
						  												<li>
						  													<a href="javascript:void(0);" class="text ftsb">
						  														Workflow settings
						  													</a>
						  												</li> 
						  												<li>
						  													<div class="switch-button grn switch-button-sm FR">
						  														<input id="okr" type="checkbox"> 
						  														<span>
						  															<label for="okr"></label>
						  														</span>
						  													</div> 
						  													<div class="text ftsb FL">
						  														Key Result Style
						  													</div>
						  												</li> 
						  												<span style="display: none;">
						  													<li class="head ftsb">
						  														Key Results
						  													</li> 
						  													<li>
						  														<div class="switch-button grn switch-button-sm FR">
						  															<input id="bvAchievementOkr" type="checkbox"> 
						  															<span>
						  																<label for="bvAchievementOkr"></label>
						  															</span>
						  														</div> 
						  														<div class="text ftsb">BV Achievement</div>
						  													</li> 
						  													<li>
						  														<a href="javascript:void(0);" class="text ftsb">
						  															Workflow Settings
						  														</a>
						  													</li>
						  											  </span> 
						  											  <li class="head ftsb">Other Actions</li> 
							  											  <li>
							  											  	<a href="javascript:void(0);" class="text ftsb">Export CSV</a>
							  											  </li> 
						  											  <li>
						  											  	<a href="javascript:void(0);" class="text ftsb">
						  											  		Export Excel</a>
						  											  </li> 
						  											  <li>
						  											  	<a href="javascript:void(0);" class="text ftsb">
						  											  		Calculation Settings</a>
						  											  </li> 
						  											  <li>
						  											    <a href="javascript:void(0);" class="text ftsb">
						  											    	View Linked Items Not on the Board</a>
						  											  </li>
						  										</ul>
						  									</div>
							  								</div>
							  							</div>
							  				</div>
							  				
                       				</div>
                       				
		                       	</div>
		                       	<div class="nobrdPopW okrbg">
						  			<div class="nobrdPop">
						  				<div class="mt-30">
							  				<div class="kLogo">
			                                    <img src="assets/imgs/k-logo.png" alt="">
			                                </div>
						  					<div class="mb-30 txt-cntr">
						  						<img class="" src="assets/icons/nookr.svg" alt="">
						  					</div>
						  					<div class="DFA JC">
							  					<div>
							  						<h2 class="nobrdhed">OKRs - Align Your Organization with objectives & key results</h2>
							  						<p class="mb-30 txt-cntr">You need to create a Strategic Theme and then can start adding OKRs.</p>
							  						<div  class="DF JC mb-10" v-if="$options.permissions && $options.permissions.EDIT_OBJECTIVE ">
														<button  class="crtboard button" @click="onAddCustomClickHandle"><em class="ti-plus ico"></em>Create Now</button>
													</div>
							  						<div class="txt-cntr">
										        		<a href="https://help.kendis.io/en/articles/8159737-how-to-use-okrs" target="_blank">Learn more</a>
										        	</div>
							  					</div>
							  					
  											</div>
						  				</div>
						  			</div>
  							  	</div>
	                       	</div>
                       </div>
                       <div class="emptyview" v-else-if="isMockingMode && getObjectivesList.length === 0 && showObjectiveBanner && !isArt && !isBatchView && !isObjectiveFiltersApplied">
                       		<div class="prow wboxaa">
                                <div class="gting fs-20"><em class="ti-pin-alt DIB pinico mt-10"></em> Getting Started with Strategic Themes</div>
                                <div class="crttxt mt-15 pb-15">Create and Track Objective with Flexibility</div>
                                <div class="brd-bt"></div>

                                <div class="brd-bt pb-15 mt-15">
                                    <div class="txtund brd-bt pb-15">You have two options:</div>
                                    <div class="mt-15 DF"><em class="ti-check checkic shapeab DAJ mr-10"></em> 
                                    	<div><strong>Collections: </strong> Assign objectives to existing Collections, structured round teams or specific groups.</div>
                                    </div>
                                    <div class="mt-15 DF"><em class="ti-check checkic shapeab DAJ mr-10"></em> 
                                    	<div><strong>Custom Groups: </strong>Organize objectives in a way that fits your strategy - group them freely outside Collections.</div>
                                    </div>
                                </div>

                                <div class="brd-bt pb-15 mt-15">
                                    <div class="txtund brd-bt pb-15">Your Next Steps:</div>
                                    <div class="mt-15 DFA"><em class="nmbric shapeab DAJ mr-10">1</em> Select a <strong class="mr-lr-5"> Collection </strong> or create a <strong class="mr-lr-5"> Custom Group</strong>.</div>
                                    <div class="mt-10 DFA"><em class="nmbric shapeab DAJ mr-10">2</em> Add objectives to align with your Strategic Theme.</div>
                                    <div class="mt-10 DFA"><em class="nmbric shapeab DAJ mr-10">3</em> Track progress with real-time updates.</div>
                                </div>

                                <div class="brd-bt pb-15 mt-15 fs-14"> <em class="rocketpng DIB mr-10"></em> Start building your objectives now! </div>

                                <div class="DAJ mt-15 btnbt">
                                    <div v-if="userPermissions.includes('edit-objective-group') && !addCollectionGroup.showCollections" class="mr-10 button-w ti-plus addf rnd4 blue" @click="onSelectAddCollectionObjective"> Add Objectives for Collections</div>
                                    <div v-if="addCollectionGroup.showCollections" class="oplvlslc mr-10" style="display:block; width: 350px;">
                                        <treeselect
                                            :multiple="false"
                                            :options="addCollectionGroup.collections"
                                            :flat="true"
                                            placeholder="Search or Select Collection..."
                                            no-children-text="No Sub Level"
                                            :clearable="false"
                                            @select="onSelectCollection"
                                        />
                                    </div>
                                    <div v-if="userPermissions.includes('edit-objective-group')" class="mr-10 button-w ti-plus addf rnd4 gren" @click="onAddCustomClickHandle">Custom Objective Group</div>
                                    <div class="txt-cntr">
										<a href="https://help.kendis.io/en/articles/8159737-how-to-use-okrs" class="txtuln" target="_blank">Learn more</a>
									</div>
                                </div>
                            </div>
                       </div>
                       <div class="nofound prow wbox" v-else-if="!isMockingMode && getObjectivesList.length === 0">No Result Found</div>
                       <div class="nofound prow wbox" v-else-if="isObjectiveFiltersApplied && getObjectivesList.length === 0">No Result Found</div>
                       <!--<div v-if="loader.show" class="loader p-fix"><div class="aa-load"><div class="loaderinteg"></div>Loading...</div></div>-->
                       </div>
						
                  </div>
                    <check-in-listing v-if="showCheckIns" id="check-ins" class="chkInWrap"
                     :objective-group-list="objectiveGroupList"
                     :context="board.session"
					 :is-mocking-mode="isMockingMode"
                     @change-check-ins="changeCheckIns"/>
				</div>
                  </template>
              </div>
	`,

    components: {
        'treeselect': VueTreeselect.Treeselect,
    },

    data() {
        return {
            addCustomFormCounter		: 0,
            menuComponentKey    		: 0,
            reRenderKey					: -1,
            isUserSearching				: false,
            showObjectiveBanner			: false,
            isStatusEnabled				: false,
            isOkrEnabled				: false,
            showPrioritizedOkrs 		: false,
            isLoaded					: false,
			isScrolling					: false,
			isItemsLoaded				: false,
			showCheckIns				: false,			
	        useOldApiForOldStateData    : false,
            isBvAchievementEnabled		: true,
            isDraggable					: true,
			teams 						: [],
            objectiveGroupList			: [],
			objectiveGroupsForReadOnly 	: [],
			prioritizedOkrs 			: [],
			userPermissions 			: [],
			groupsForCalculation		: [],
			type						: 'objective',
			roleErrorMessage 			: '',
            krProgressCriteriaFieldId   : '',
            sortableInstance			: null,
			batchesMap					: {},
			departmentsMap 				: {},
			sessionsMap					: {},
            objectiveMenuOptions		: {},
            selectedTeam				: {},
			visibleGroupsMapById		: {},
			prioritizedOkrGroup			: {},
			
            backlogSortableOptions : {
                disabled				: false,
                forceFallback			: true,
                fallbackTolerance		: 1,
                ghostClass				: 'ui-sortable-placeholder1',
                chosenClass				: 'sortable-chosen',
                dragClass				: 'sortable-drag',
                animation               : 150,
                scroll                   : true,
                group					: {name: 'main_group', pull: true, put: true, revertClone: true},
                onEnd					: this.onDragChange
            },

            timePeriodFilter            : {},
            timePeriodFieldId           : '',
            timePeriodKRFieldId         : '',
            responsibleFieldId          : '',
            responsibleKRFieldId        : '',
            unFilteredObjectiveGroupList: [],
            defaultOkrRoadmap: undefined,
            completionCriteria: '',
            showObjectiveThemeProgress: false,
            allGroupIds: [],
            allObjectiveIds: [],
            startDateFieldId            : '',
            endDateFieldId              : '',
            activeCustomView            : {},
            cvStatuses                  : [],
            cvPriorities                : [],
            cvTypes                     : [],
            collections                 : [],
            customViewPopup             : {
                show: false,
            },
            addCollectionGroup          : {
				showCollections         : false,
				collections             : []
			},
            cvUserPermissionsMap: {},
			cvPermissions: [],
            cvLoader : false,
            objectiveFilters: {
                responsible: [],
                collections: [],
                statuses: [],
                searchQuery: '',
            },
			newLoader : true
        }

    },

    computed: {
        getGroupType: function () {
            return function (baseItemLinks) {
                _.forEach(baseItemLinks, function (baseItemLink) {
                    if (baseItemLink && baseItemLink.teamId) {
                        return "team";
                    }
                });
                return "custom";
            }
        },
		getObjectivesList : function() {
            return this.objectiveGroupList;
			// return kendisStore.state.ojectiveGroups;
		},
		originalObjectiveGroupList : function() {
			return kendisStore.state.ojectiveGroups;
		},
        objectiveGrpKeyMap: function(){
            return kendisStore.getters.getObjectiveGroupKeyMap();
        },
        objOkrPopupContainerMap: function (){
            return kendisStore.getters.getObjOkrPopupContainerMap();
        },
        excludeItemsData: function() {
            return kendisStore.getters.getExcludeItemsData();
        },
        getObjectiveWorkspace () {
            return kendisStore.getters.getObjectiveWorkspace();
        },
		showGroup: function() {
			return function(objId) {
				if(this.isMockingMode || window.location.href.indexOf("solutions") > -1) {
					return true;
				}
				return _.indexOf(kendisStore.state.filteredGroups, objId) > -1;
			}
		},
		filteredGroups: function() {
            if(!this.isGlobalObjectiveView){
                this.allGroupIds = kendisStore.state.filteredGroups;
            }
			return kendisStore.state.filteredGroups;
		},
        getColumnSettings() {
            if (this.customView && this.customView.columnSettings) {
                return this.customView.columnSettings;
            }
            if (this.activeCustomView && this.activeCustomView.columnSettings) {
                return this.activeCustomView.columnSettings;
            }
            return this.getObjectiveWorkspace.columnSettings;
        },
        isObjectiveFiltersApplied() {
            return Object.values(this.objectiveFilters).some(filter => filter.length > 0);
        },
        releaseTrainTitle(){
            if(this.releaseTrainId && this.collections && this.collections.length > 0){
                let releaseTrain = this.collections.find(col => col.id === this.releaseTrainId);
                if(releaseTrain){
                    return releaseTrain.title;
                }
            }
            return "";
        }
    },

    watch: {
        objectiveGroupList: function (_newList, _oldList) {
            if (_newList) {
                this.toggleLoader(false);
                if(this.getUrlParam("objectiveGroupsId") !== undefined && this.getUrlParam("isArt") !== undefined) {
                    this.showObjectiveThemeProgress = true;
                }
            }
            if (this.board) {
                this.refreshTeamList(_newList);
            }
			this.newLoader = false;
        },
        originalObjectiveGroupList: function (_newList, _oldList){
			if(this.shouldLoadObjectives && !this.readOnlyView) {
	            this.objectiveGroupList = _newList;
			}
            this.allGroupIds = _newList.map(group => group.id);
            this.allObjectiveIds = _newList.flatMap(group =>
                group.baseItemList ? group.baseItemList.map(item => item.id) : []
            );
        }
        /*objectiveGrpKeyMap : {
            handler: function (){
                this.$forceUpdate();
            },
            deep : true
        },*/

    },

    created() {
        if (!_.isEmpty(this.customView)) {
            this.activeCustomView = this.customView;
        }
        if (_.isEmpty(kendisStore.getters.getCustomViews())) {
            this.fetchCustomViews();
        } else if (!this.isArt && this.isMockingMode && _.isEmpty(this.activeCustomView)) {
            this.activeCustomView = kendisStore.getters.getCustomViews().find(view => view.key === this.customViewId);
        }

        if (!_.isEmpty(this.activeCustomView)) {
            this.setCustomViewPermissions();
        }
		/*if(window.location.pathname.indexOf('/org') > -1){
			if(!checkFlagOnORG( loggedInUser,'objectives')){
				window.location.hash = window.location.hash.split('/objectives')[0]+'/backlog';
			}
		}*/
		this.toggleLoader(true);
		this.initOnReady('Objectives','onReadyBoard');
    },

    mounted() {
		this.initOnReady('Objectives','mountOnReadyBoard');
    },
    beforeDestroy(){
        if (objectivesRtVU){
            objectivesRtVU = undefined;
        }
	},
    methods: {
        async getCustomViewIdByKey(key){
          const response = await fetch(`objective/get-custom-view-id-by-key/${key}`, {
            headers: getFetchAPIHeadersForKendis(),
            credentials: 'include', // Include cookies for CSRF-TOKEN
          });
          if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
          }
            return response.data
        },
        async onOpenRoadmap() {
            try {
                if (this.defaultOkrRoadmap) {
                    const pathSuffix = this.isGlobalObjectiveView
                        ? `/okr-roadmaps/${this.defaultOkrRoadmap.key}/${this.activeCustomView.id}`
                        : `/okr-roadmaps/${this.defaultOkrRoadmap.key}`;
                    this.$router.push(this.$route.path + pathSuffix);
                } else {
                    const context = this.isGlobalObjectiveView
                        ? { id: this.activeCustomView.id }
                        : { id: this.board.session.id };
                    const request = {
                        name: "OKRs Roadmap Default",
                        viewType: "OKR_ROADMAP",
                        defaultOkrRoadmap: true,
                        ...(this.isGlobalObjectiveView ? { objectiveCustomView: context } : { workSpace: context })
                    };
                    const response = await axios.post('/releasetrain/kanban/save', request);
                    const okrRoadmap = response.data.board;
                    const pathSuffix = this.isGlobalObjectiveView
                        ? `/okr-roadmaps/${okrRoadmap.key}/${this.activeCustomView.id}`
                        : `/okr-roadmaps/${okrRoadmap.key}`;
                    this.$router.push(this.$route.path + pathSuffix);
                }
            } catch (error) {
                console.log(error);
                // Reset loading state on error
                if (this.$refs && this.$refs['obj-menu']) {
                    this.$refs['obj-menu'].isOkrRoadmapLoading = false;
                }
            }
        },

		onReadyBoard : function(){
			if(typeof board != "undefined") {
			    USERS_FOR_EDITOR = board._users;
			}
			else if(typeof vueInstance != "undefined") {
			    USERS_FOR_EDITOR = vueInstance.$options._users;	
			}
			this.fetchExcludedItems();
        	this.initObjectiveModalTemplate();
        	this.loadCustomViewWorkflow();
			this.fetchCollections();
		},
		mountOnReadyBoard : function(){
			let _this = this;
	        if (_this.shouldLoadObjectives) {
	            if (!_.isEmpty(_this.board)) {
	                //it will load all the objective groups for a specified session board
	
	                if(!_this.isMockingMode){
	                    _this.loadObjectiveGroupsListBySessionBoardId();	
	                } else {
						_this.toggleLoader(false);
					}
	            } else {
	                _this.loadObjectiveGroupsListBySolutionId();
	            }
	        } else {
	            this.toggleLoader(false);
				let filteredObjectiveGroups = [];
	            this.objectiveGroupList = this.objectiveGroups;
				_.each(this.objectiveGroupList, obGrp=>{
					filteredObjectiveGroups.push(obGrp.id);				
				});
				kendisStore.commit("setFilteredGroups", filteredObjectiveGroups);			
	            this.objectiveGroupsForReadOnly = _.cloneDeep(this.objectiveGroups);
				let requestBody = {};
				requestBody.sessionId = this.board.session.id;
				requestBody.isMockingMode = this.isMockingMode;
	            // this.originalObjectiveGroupList = _.cloneDeep(this.objectiveGroups);
	            axios.post('objective/load-objective-groups-data', requestBody)
	                .then(response => {
	                    if (response.status == "200") {
	                        kendisStore.commit("setOjectiveGroups", response.data.objectiveGroupsList)
	                    }
	                })
	                .catch(error => {
	                    console.error("Error loading objective groups data.", error);
	                });
				_this.isItemsLoaded = true;
	        }
	        _this.reRenderKey = _this.generateRandomKey();
	        _this.$options.permissions = kendisStore.getters.getObjectiveAndOkrPermissions();
	        if(!_this.isMockingMode) {
				_this.fetchPrioritizedObjectives(_this.board.session.id);
			}
			let isScrolling;
			isScrolling = setTimeout(() => {
				if(!_.isEmpty(this.groupsForCalculation)) {
					this.fetchCompletion();
					window.clearTimeout(isScrolling);
				}
			}, 3000);				
			//this.fetchCompletion();
		},

		onClickBackButton: function () {
            if (this.isArt || this.customView?.id === "-1") {
			    this.$emit("close");
            } else {
                window.location.href = "/objectives";
            }
		},

		onRecieveObjectiveUpdate: function (objective) {
            _.each(this.getObjectivesList, group=> {
				let component = this.$refs["objectiveGroup-"+group.id];
				if (_.isArray(component)) {
					component[0].checkForObjectiveUpdate(objective);
				}
				else {
					component.checkForObjectiveUpdate(objective);
				}
			});
		},
		changeCheckIns: function(value) {
			let _this = this;
	    	_this.showCheckIns = value;
			if(_this.showCheckIns) {
				_this.$nextTick(()=>{
					_this.resizableCheckIn();
				})
			}
	    },
        fetchDefaultOkrRoadmap: function (){
            let _this = this;
            // Call API when data is loaded for objectives
            //                                  /releasetrain/{releaseTrainId}/kanban/boards
            // ViewType :"OKR_ROADMAP",
            // defaultOkrRoadmap === true
            // If no result
            // then create a new board with ViewType = "OKR_ROADMAP" and defaultOkrRoadmap = true
            // Else use the retrieved one to open component

            let request = {
                viewType: "OKR_ROADMAP",
                context:this.isGlobalObjectiveView ?"ObjCustomView":"Collection",
            }
            let contextId =
                    this.isGlobalObjectiveView ?
                        this.activeCustomView.id : this.board.session.id

            fetch(`/releasetrain/${contextId}/kanban/boards`, {
                method: "POST",
                headers: getFetchAPIHeadersForKendis(),
                credentials: 'include', // Include cookies for CSRF-TOKEN
                body: JSON.stringify(request)
                 })
                .then(response => {
                    if (!response.ok) {
                        // Handle non-200 status codes
                        console.error(`Error: ${response.status} ${response.statusText}`);
                        return null;
                    }
                    return response.json(); // Parse JSON if response is OK
                })
                .then(response => {
                    if (response && response.boards && response.boards.length > 0) {
                        // Use the retrieved board
                        for(let okrRoadmap of response.boards) {
                            if(okrRoadmap.defaultOkrRoadmap){
                               this.defaultOkrRoadmap = okrRoadmap
                                break;
                            }
                        }

                    }

                })
                .catch(error => {
                    console.error('Error during fetch:', error);
                });

        },

		fetchWorkspace : function () {
			kendisStore.commit('setObjectiveWorkspace',{});
			var _this = this;
			_this.roleErrorMessage = "";
			axios.get("/releasetrain/get/workspace-module/" + this.type)
				.then(response => {
					if (response.data) {
						if(response.data.workspace) {
							kendisStore.commit('setObjectiveWorkspace',response.data.workspace);

                            if (!_this.isGlobalObjectiveView) {
                                let workspace = {};
                                if (this.isBatchView) {
                                    workspace = kendisStore.getters.getBatchWorkspace();
                                } else {
                                    workspace = {id: _this.board.session.id}
                                }
                                this.setObjectivePermissions(_.isEmpty(workspace) ? {id: _this.board.session.id} : workspace);
                            } else {
							    _this.setObjectivePermissions(this.activeCustomView);
                            }
						}
						_this.setupPermissions();
						if (_this.isMockingMode && !_.isEmpty(_this.board)) {
							_this.loadObjectiveGroupsListByObjectId();								
						/*	if(!_.isEmpty(this.userPermissions)){
							}else{
								//_this.roleErrorMessage = "You do not have any role assigned for Objectives";
								_this.showObjectiveBanner = true;
							}*/
						}
                            _this.fetchDefaultOkrRoadmap();

                    }
				}).catch(error => {

				});
		},

		setObjectivePermissions: function(wS) {
			var objectiveRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return (o.workSpace && o.workSpace.id && o.workSpace.id == wS.id) || (o.customView && o.customView.id && o.customView.id === wS.id);
			});
			var roles = [];
			var permissions = [];
			if(loggedInUser.isAdmin === true && _.isEmpty(objectiveRoles)) {
				permissions = loggedInUser.permissions;
			}
			_.each(objectiveRoles, accessRole => {
				if (loggedInUser.isGuest === true) {
					permissions = [];
				} else if (loggedInUser.isAdmin === true) {
					permissions = loggedInUser.permissions;
				} else {
					_.each(accessRole.roles, role => {
						roles.push(role);
						permissions = _.union(permissions, _.difference(loggedInUser.permissions, role.restrictions))
					});
				}
			});

            if (!_.isEmpty(this.activeCustomView) && this.activeCustomView.id === "-1") {
                this.userPermissions = loggedInUser.permissions;
            } else {
			    this.userPermissions = permissions;
            }
		},

        setCustomViewPermissions() {
			let strategicThemeRoles = _.filter(loggedInUser.accessRoles, role => !_.isEmpty(role.customView) && role.customView.id === this.activeCustomView.id);

			let roles = [];
			let permissions = [];
			let permissionsMap = {};

			if (loggedInUser.isAdmin && _.isEmpty(strategicThemeRoles)) {
				this.cvPermissions = loggedInUser.permissions;
			} else {
				_.each(strategicThemeRoles, role => {
					if (loggedInUser.isGuest) {
						permissions = [];
					} else if (loggedInUser.isAdmin) {
						permissions = loggedInUser.permissions;
					} else {
						_.each(role.roles, r => {
							roles.push(r);
							permissions = _.union(permissions, _.difference(loggedInUser.permissions, r.restrictions));
						})
					}
					permissionsMap[role.customView.id] = permissions;
                    this.cvPermissions = _.union(this.cvPermissions, permissions);
				});
			}

			this.cvUserPermissionsMap = permissionsMap;

            if(this.isMockingMode && _.isEmpty(this.cvPermissions) && this.activeCustomView.id !== "-1") {
				alertFromSweetAlertWrapper("You do not have access", this.redirectToHome);
			}
		},

        redirectToHome : function () {
			window.location.href = "/objectives";
		},

		isActionAllowed: function(action) {
			var permissions = this.userPermissions;
			if ((permissions && permissions.length > 0 && permissions.indexOf(action) > -1)) {
				return true;
			} else {
				return false;
			}
		},
		
        isUncommittedObjEnabled: function () {
            if (this.isSolutionBoard) {
                return this.solutionBoard.uncommittedObjEnabled;
            }
            return this.board.session.uncommittedObjEnabled;
        },

        toggleBvAchievementEnabled: function (val) {
            this.isBvAchievementEnabled = val;
        },

		onAddCollectionObjectiveGroup: function (collection) {

			let objective = {};

			//............   team link
			let teamLink = {};
            teamLink.type = "Objective-Group";
            teamLink.teamId = 0;
            if (this.isSolutionBoard) {
                teamLink.solutionId = this.solutionBoard.id;
            } else if(this.isMockingMode){
                teamLink.linkType = "art_link_objective";
                teamLink.sessionId = this.board.session.id;
			} else{
                teamLink.sessionId = this.board.session.id;
                teamLink.sessionBoardId = this.board.id;
            }

            //.......... collection link
            let collectionLink = {};
            collectionLink.type = "Objective-Group";
            collectionLink.teamId = 0;

            collectionLink.linkType = "art_link_objective";
            collectionLink.sessionId = collection.id;

            objective.baseItemLinks = [];
            objective.baseItemLinks.push(teamLink);
            objective.baseItemLinks.push(collectionLink);
            //.............................................
            objective.type = "Objective-Group"
			objective.headerColor = collection.color ? collection.color : "#f9bf3b";
            objective.title = collection.title;

            objective.expand = false;

            if(_.find(kendisStore.getters.getObjectiveGroupTemplate().statuses, {"category":"ToDo"}) != -1) {
                objective.status = _.find(kendisStore.getters.getObjectiveGroupTemplate().statuses, {"category": "ToDo"});
            }

            let metaMap = {};
            if(this.isMockingMode){
                metaMap.syncId = syncId;
                metaMap.sessionId = this.board.session.id
                metaMap.teamId = 0;
                metaMap.boardId = this.board.session.id
            }else{
                metaMap.syncId = syncId;
                metaMap.sessionId = vueInstance.activeBoard.session.id;
                metaMap.teamId = 0;
                metaMap.boardId = this.board.id;}

            if ((this.customView && this.customView.id != "-1") || (this.activeCustomView && this.activeCustomView.id != "-1")) {
				metaMap.viewId = this.customView ? this.customView.id : this.activeCustomView.id;
                objective.linkedCustomView = this.customView ? this.customView.id : this.activeCustomView.id;
			}

            if (collection && collection.id) {
                metaMap.collectionId = collection.id;
            }

            objective.metaMap = JSON.stringify(metaMap);
            this.onCreateObjective(objective);

		},
        applyResponsibleFilter(filter) {
            this.objectiveFilters.responsible = filter;
            this.loadObjectiveGroupsListByObjectId(true);
        },
        applyStatusFilter(filter) {
            this.objectiveFilters.statuses = filter;
            this.loadObjectiveGroupsListByObjectId(true);
        },
        applyAssociationFilter(filter) {
            this.objectiveFilters.collections = filter;
            this.loadObjectiveGroupsListByObjectId(true);
        },
        resetFilters() {
            this.objectiveFilters = {
                responsible: [],
                collections: [],
                statuses: [],
                searchQuery: '',
            };
            this.timePeriodFilter = {};
            this.loadObjectiveGroupsListByObjectId(true);
        },
        applyTimePeriodFilter(filter) {
            this.timePeriodFilter = filter;
        	this.loadObjectiveGroupsListByObjectId(true);
        	/*return;
        
            if (_.isEmpty(filter.selectedValue)) {
                this.objectiveGroupList = _.cloneDeep(this.unFilteredObjectiveGroupList);
                return;
            }
        
            this.objectiveGroupList = _.cloneDeep(this.unFilteredObjectiveGroupList);
        
            _.each(this.objectiveGroupList, (group) => {
                _.each(group.baseItemList, (objective) => {
                    let objectiveMatches = false;
                    let krMatches = false;
        
                    if (filter.byObjectives) {
                        if (objective.fields && objective.fields[this.timePeriodFieldId]) {
                            objectiveMatches = filter.selectedValues[filter.selectedYear].includes(objective.fields[this.timePeriodFieldId].title) &&
                                objective.fields[this.timePeriodFieldId].selectedYear === filter.selectedYear;
                        }
                    } else {
                        objectiveMatches = true;
                    }
        
                    if (filter.byKrs) {
                        let matchingKRs = _.filter(objective.baseItemList, (kr) => {
                            if (kr.fields && kr.fields[this.timePeriodKRFieldId]) {
                                return filter.selectedValues[filter.selectedYear].includes(kr.fields[this.timePeriodKRFieldId].title) &&
                                    kr.fields[this.timePeriodKRFieldId].selectedYear === filter.selectedYear;
                            }
                            return false;
                        });
        
                        krMatches = matchingKRs.length > 0;
                    } else {
                        krMatches = true;
                    }
        
                    if (filter.byObjectives && filter.byKrs) {
                        objective.shouldInclude = objectiveMatches && krMatches;
                    } else if (filter.byObjectives) {
                        objective.shouldInclude = objectiveMatches;
                    } else if (filter.byKrs) {
                        objective.shouldInclude = krMatches && !_.isEmpty(objective.baseItemList);
                    } else {
                        objective.shouldInclude = true;
                    }
                });
        
                group.baseItemList = _.filter(group.baseItemList, (objective) => {
                    return objective.shouldInclude;
                });
            });
        
            this.objectiveGroupList = _.filter(this.objectiveGroupList, (group) => {
                return group.baseItemList.length > 0;
            });*/
        },

        onCreateCustomObjective: function (objective) {
            let teamLink = {};
            teamLink.type = "Objective-Group";
            teamLink.teamId = 0;
            if (this.isSolutionBoard) {
                teamLink.solutionId = this.solutionBoard.id;
            } else if(this.isMockingMode){
                teamLink.linkType = "art_link_objective";	
                teamLink.sessionId = this.board.session.id;
			} else{
                teamLink.sessionId = this.board.session.id;
                teamLink.sessionBoardId = this.board.id;
            }
            objective.type = "Objective-Group"
			objective.headerColor = objective.headerColor ? objective.headerColor : "#f9bf3b";
            objective.baseItemLinks = [];
            objective.expand = false;
            objective.baseItemLinks.push(teamLink);
            if(_.find(kendisStore.getters.getObjectiveGroupTemplate().statuses, {"category":"ToDo"}) != -1) {
                objective.status = _.find(kendisStore.getters.getObjectiveGroupTemplate().statuses, {"category": "ToDo"});
            }

            let metaMap = {};
            if(this.isMockingMode){
                metaMap.syncId = syncId;
                metaMap.sessionId = this.board.session.id
                metaMap.teamId = 0;
                metaMap.boardId = this.board.session.id
            }else{
                metaMap.syncId = syncId;
                metaMap.sessionId = vueInstance.activeBoard.session.id;
                metaMap.teamId = 0;
                metaMap.boardId = this.board.id;}

            if ((this.customView && this.customView.id != "-1") || (this.activeCustomView && this.activeCustomView.id != "-1")) {
				metaMap.viewId = this.customView ? this.customView.id : this.activeCustomView.id;
                objective.linkedCustomView = this.customView ? this.customView.id : this.activeCustomView.id;
			}

            objective.metaMap = JSON.stringify(metaMap);
            this.onCreateObjective(objective);
        },

        toggleOkrOption: function (val) {
            this.isOkrEnabled = val;
        },

        toggleUncommittedObjOption: function () {
            let _this = this;
            let body = {};
            if(this.isSolutionBoard){
                body.id = this.solutionBoard.id;
                body.uncommittedObjEnabled = val;
                axios.post("objective/enableUncommittedObjForSolution/", body)
                    .then(response => {
                        if (response.status == "200") {
                            _this.solutionBoard = response.data;
                        }
                    })
                    .catch(error => {
                        console.log("Error While Uncommited Objective Option  Update." + error);
                    });
            }else {
                body.id = this.board.session.id;
                body.uncommittedObjEnabled = val;
                axios.post("objective/enableUncommittedObj/", body)
                    .then(response => {
                        if (response.status == "200") {
                            _this.board.session = response.data;
                        }
                    })
                    .catch(error => {
                        console.log("Error While Uncommited Objective Option  Update." + error);
                    });
            }
        },

        loadCustomViewWorkflow() {
			axios.get("/objective/cv/get-workflows").then(res => {
				if (res.data.success) {
					this.cvStatuses = res.data.statuses;
					this.cvPriorities = res.data.themePriorities;
					this.cvTypes = res.data.themeTypes;
				}
			}).catch(error=>{
			});
		},

        fetchCollections: function () {
			if (_.isEmpty(this.collections)) {

				let _this = this;
				let data = {};
				data.fetchTypes = false;

				axios.post("/releasetrain/release-trains", data)
					.then(response => {
						if (response.data) {
							kendisStore.commit('setArtCollections',response.data.releaseTrains);
							_this.collections = response.data.releaseTrains;
						}
					}).catch(error => {
					});
			}
		},

        onSelectAddCollectionObjective() {
            let collections = this.collections;
            collections = collections.filter(collection => collection.id !== "-1" && collection.type);

            let collectionsToDisabled = [];
            this.getObjectivesList.forEach(group => {
                group.baseItemLinks.forEach(link => {
                    if (link.linkType === 'art_link_objective' && link.sessionId !== "-1") {
                        collectionsToDisabled.push(link.sessionId);
                    }
                })
            });

            this.addCollectionGroup.collections = [];
            let rootWorkSpaces = [];
            let workspaceMap = {};

            _.each(collections, workspace => {
                if(_.isEmpty(workspaceMap[workspace.id])) {
                    workspaceMap[workspace.id] = {id: workspace.id, label: workspace.title, children: [], isDisabled: collectionsToDisabled.includes(workspace.id)};
                }
            })

            _.each(collections, workspace => {
                if(workspace.linkedWorkSpaces && workspace.linkedWorkSpaces.length > 0) {
                    _.each(workspace.linkedWorkSpaces, linkedWorkSpaceId => {
                        let parent = workspaceMap[linkedWorkSpaceId];
                        if(parent) {
                            parent.children.push(workspaceMap[workspace.id]);
                        }
                    });
                } else {
                    rootWorkSpaces.push(workspaceMap[workspace.id]);
                }
            });

            this.addCollectionGroup.collections = rootWorkSpaces;
            this.addCollectionGroup.showCollections = true;
        },

        onSelectCollection: function (collection) {
            const selectedCollection = this.collections.find(item => item.id === collection.id);

			this.addCollectionGroup.show = false;
            this.onAddCollectionObjectiveGroup(selectedCollection);
        },

        onCustomViewOpenPopup() {
            this.customViewPopup.show = true;
        },

        onCustomViewClose() {
            this.customViewPopup.show = false;
        },

        onCustomViewCreate: function(customView) {
			this.onCustomViewClose();
			this.addViewToList(customView);
		},

        onCustomViewUpdate: function(customView) {
			this.onCustomViewClose();
			this.updateViewPropperties(customView);
		},

        addViewToList(customView) {
            let views = kendisStore.getters.getCustomViews();
            views.push(customView);
            kendisStore.commit('setCustomViews', views);
            this.activeCustomView = customView;
            this.loadObjectiveGroupsListByObjectId();
        },

        updateViewPropperties(customView) {
            let views = kendisStore.getters.getCustomViews();
            let index = views.findIndex(view => view.id === customView.id);
            views[index] = customView;
            kendisStore.commit('setCustomViews', views);
            this.activeCustomView = customView;
            this.loadObjectiveGroupsListByObjectId();
        },

        onUpdateObjectiveGroup: function(objectiveGroup) {
            if (!objectiveGroup) {
                return;
            }
            let requestBody = {};
            let _this = this;

            if (!objectiveGroup.metaMap){
                let metaMap = {};
                metaMap.syncId = syncId;
                if(typeof vueInstance != "undefined" && vueInstance.activeBoard && vueInstance.activeBoard.session) {
                    metaMap.sessionId = vueInstance.activeBoard.session.id;
                }
                requestBody.metaMap = JSON.stringify(metaMap);
            } else {
                requestBody.metaMap = objectiveGroup.metaMap;
            }

            requestBody.id = objectiveGroup.id;
            requestBody.title = objectiveGroup.title;
            requestBody.fields = objectiveGroup.fields;
            requestBody.description = objectiveGroup.description;
            requestBody.headerColor = objectiveGroup.headerColor;
            requestBody.status = objectiveGroup.status;
            requestBody.type = objectiveGroup.type;
            requestBody.sequence = objectiveGroup.sequence;

            axios.post('external-entitites/save-base-item/custom-objective-save', requestBody).then(response => {
                if(response.status == 200) {
                    if(response.data.impediment && response.data.impediment !== undefined) {
                        let updatedGroup = response.data.impediment;
                        let sessionId = "";

                        if(_this.isMockingMode){
                            sessionId = _this.board.session.id;
                        }
                        else if (typeof board != "undefined"){
                            sessionId = board._board.session.id
                        }
                        else if (typeof vueInstance != "undefined"){
                            sessionId = vueInstance.activeBoard.session.id
                        }

                        updatedGroup.expand = localStorage.getItem('objective_expand_' + sessionId + '_' + updatedGroup.id)
                        _this.updateGroupList(updatedGroup);
                    }
                    showTopMessage("Objective Group Updated", 'success');
                }
            }).catch(error => {
                console.error("Objective Update error", error);
            });
        },

        fetchCustomViews() {
                let _this = this;

                let data = {};

                data.releaseTrainId = this.isArt ? this.releaseTrainId : null;
                data.archive = false;

                this.cvLoader = true;
                axios.post("/objective/cv/all", data).then(res => {
                    if (res.data.success) {
                        let views = [];
                        if (this.tabIndex == 0) {
                            views.push({id:"-1", title: "Default View", key:""});
                        }
                        views.push(...res.data.views);
                        kendisStore.commit('setCustomViews', views);
                        if (this.customViewId && _.isEmpty(this.customView) && !this.isArt && this.isMockingMode) {
                            this.activeCustomView = views.find(view => view.key == this.customViewId);
                        } else {
                            this.activeCustomView = this.customView;
                        }

                        //conflict resolution from BAU-349
                        if (!_.isEmpty(this.activeCustomView)) {
                            this.setCustomViewPermissions();
                            this.fetchDefaultOkrRoadmap();
                        }
                        if (this.isMockingMode && _.isEmpty(this.activeCustomView) && (!this.isArt && !this.isBatchView)) {
                            alertFromSweetAlertWrapper("You do not have access", this.redirectToHome);
                            return;
                        }

                        this.cvLoader = false;

                        if (!_this.isGlobalObjectiveView) {
                            let workspace = {};
                            if (this.isBatchView) {
                                workspace = kendisStore.getters.getBatchWorkspace();
                            } else {
                                workspace = {id: _this.board.session.id}
                            }
                            this.setObjectivePermissions(_.isEmpty(workspace) ? {id: _this.board.session.id} : workspace);
                        } else {
                            this.setObjectivePermissions(this.activeCustomView);
                        }
                        this.setupPermissions();

                        this.setCustomViewPermissions();
                    }
                }).catch(error=>{
                });
        },

        onUpdateObjective: function (requestBody, oldIndex, newIndex) {
            let _this = this;
            if (!requestBody.metaMap){
                let metaMap = {};
                metaMap.syncId = syncId;
				if(typeof vueInstance != "undefined" && vueInstance.activeBoard && vueInstance.activeBoard.session) {
                	metaMap.sessionId = vueInstance.activeBoard.session.id;
				}
                requestBody.metaMap = JSON.stringify(metaMap);
            }
            axios.post('external-entitites/save-base-item/popup-save', requestBody).then(response => {
                if(response.status == 200) {
                    if(response.data.impediment && response.data.impediment !== undefined) {
                        let updatedGroup = response.data.impediment;
						if(oldIndex != "undefined" && newIndex != "undefined" && oldIndex > -1 && newIndex > -1 && oldIndex != newIndex) {
							let group = _this.objectiveGroupList[oldIndex];
							_this.objectiveGroupList.splice(oldIndex, 1);
							_this.objectiveGroupList.splice(newIndex, 0, group);
							
						}
                        let sessionId = "";

                        if(_this.isMockingMode){
                            sessionId = _this.board.session.id;
                        }
                        else if (typeof board != "undefined"){
                            sessionId = board._board.session.id
                        }
                        else if (typeof vueInstance != "undefined"){
                            sessionId = vueInstance.activeBoard.session.id
                        }

                        let expandValue = localStorage.getItem('objective_expand_' + sessionId + '_' + updatedGroup.id);
                        updatedGroup.expand = JSON.parse(expandValue);
                        _this.updateGroupList(updatedGroup);
                    }
		            showTopMessage("Objective Group Updated", 'success');
                }
            }).catch(error => {
                console.error("Objective Update error", error);
            });
        },

        onExpandCollapseObjective : function (objective){
            let _this = this

            let sessionId = "";
			let solutionBoardId = "";
            if(_this.isMockingMode){
                sessionId = _this.board.session.id;
            }
            else if (typeof vueInstance != "undefined"){
				if(vueInstance.activeBoard && vueInstance.activeBoard.session) {
                	sessionId = vueInstance.activeBoard.session.id;
				} else if(vueInstance.activeSolutionBoard && vueInstance.activeSolutionBoard.id) {
					solutionBoardId = vueInstance.activeSolutionBoard.id;
				}
            }

            if (objective.isPrioritizedOkr){
                /*let index = _.findIndex(_this.prioritizedOkrs, {id: objective.id});
                if (index > -1){
                    _this.prioritizedOkrs[index].expand = !_this.prioritizedOkrs[index].expand;
                }
                localStorage.setItem('objective_expand_' + sessionId + '_' + objective.id, JSON.stringify(_this.prioritizedOkrs[index].expand));*/
                _this.prioritizedOkrGroup.expand = !_this.prioritizedOkrGroup.expand;
                localStorage.setItem('objective_expand_' + sessionId + '_' + objective.id, JSON.stringify(_this.prioritizedOkrGroup.expand));


            }else{
                let index = _.findIndex(_this.objectiveGroupList, {id: objective.id});

                if(_.isEmpty(solutionBoardId)) {
                    localStorage.setItem('objective_expand_' + sessionId + '_' + objective.id, JSON.stringify(!_this.objectiveGroupList[index].expand))
                }
                else {
                    localStorage.setItem('objective_expand_' + solutionBoardId + '_' + objective.id, JSON.stringify(!_this.objectiveGroupList[index].expand))
                }

                if (index > -1) {
                    _this.objectiveGroupList[index].expand = !_this.objectiveGroupList[index].expand;
                    let storePayload = {};
                    storePayload.group = _this.objectiveGroupList[index];
                    kendisStore.commit("updateSingleGroup",storePayload);
                }
				let objectivesFetched = kendisStore.getters.getIsObjectivesOfGroupFetched(objective.id);
				if(_this.isMockingMode) {
					_this.fetchGroupsData([objective.id])
				}
            }
        },

        onCreateObjective: function (objective) {
			let _this = this;
            axios.post('objective/update-objective', objective).then(response => {
                if(response && response.data &&  response.data.id) {
                    if (!_.isEmpty(this.activeCustomView)) {
                        this.updateCustomView();
                    }
                    this.showObjectiveBanner = false;
                    let newObjectiveGroup = response.data;
                    if (_this.customView) {
						if (!_this.customView.baseItemLinks) {
							_this.customView.baseItemLinks = [];
						}
						let link = {};
						link.type = "objective-group";
						link.baseItemId = newObjectiveGroup.id;
						_this.customView.baseItemLinks.push(link);
					}
					newObjectiveGroup.expand = true;
                    if (_.isEmpty(newObjectiveGroup.baseItemList)){
                        newObjectiveGroup.baseItemList = [];
                    }
                    kendisStore.commit("addToGroup", newObjectiveGroup);
					let filteredObjectiveGroups = kendisStore.getters.getFilteredGroups();
					filteredObjectiveGroups.push(newObjectiveGroup.id);
					kendisStore.commit("setFilteredGroups", filteredObjectiveGroups);
					localStorage.setItem("filteredGroups_"+this.board.id, JSON.stringify(filteredObjectiveGroups));					

                    let objGrpKeyMap = _.cloneDeep(kendisStore.getters.getObjectiveGroupKeyMap());
                    let groupId = response.data.id;
                    // objGrpKeyMap[groupId] = 0;
                    Vue.set(objGrpKeyMap, groupId , 0);
                    kendisStore.commit("setObjGrpKeyMap", objGrpKeyMap);
					
                    // _this.originalObjectiveGroupList = kendisStore.getters.getOjectiveGroups();
					if (_this.$refs && _this.$refs['obj-menu']) {
						_this.doFilterObjectiveList(_this.$refs['obj-menu'].searchQuery);
					}
					
                    showTopMessage("Objective Group Created.", "success");
                    if (_this.$options.permissions && _this.$options.permissions.EDIT_OBJECTIVE){
                       _this.$nextTick(() => {
                            if (_this.$refs['objectiveGroup-'+response.data.id] && Array.isArray(_this.$refs['objectiveGroup-'+response.data.id])) {
                                let element = _this.$refs['objectiveGroup-'+response.data.id][0];
                                element.showCommittedObjectiveForm();
                            }
	                    });
                    }
					if(_this.isMockingMode) {
						let completionsMap = {};
						completionsMap[groupId] = 0.0;
						let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
						Object.assign(savedCompletionMap, completionsMap);
						kendisStore.commit("setOkrCompletionMap", savedCompletionMap);						
					}
                    if(typeof objectivesRtVU != "undefined") {
	                    if (objectivesRtVU.$refs['objectivesRef'] && (objectivesRtVU.$refs['objectivesRef'].sortableInstance === undefined || objectivesRtVU.$refs['objectivesRef'].sortableInstance === null)){
	                        _this.$nextTick(()=>{
	                            _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
	                        });
	                    }
					}else if(typeof vueInstance != "undefined") {
	                    if (vueInstance.$refs['objectivesRef'] && (vueInstance.$refs['objectivesRef'].sortableInstance === undefined || vueInstance.$refs['objectivesRef'].sortableInstance === null)){
	                        _this.$nextTick(()=>{
	                            _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
	                        });
	                    }
					} else if(typeof objectivesVU != "undefined") {
	                    if (objectivesVU.$refs['objectivesRef'] && (objectivesVU.$refs['objectivesRef'].sortableInstance === undefined || objectivesVU.$refs['objectivesRef'].sortableInstance === null)){
	                        _this.$nextTick(()=>{
	                            _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
	                        });
	                    }						
					}

                    _this.closeCustomObjectiveView();
					
                }
            }).catch(error => {
                console.error("Objective save error", error);
            });
        },

        addTeamObjectiveGroup: function (team) {
            let teamLink = {};
            let objective = {};
            teamLink.type = "Objective-Group";
            teamLink.teamId = team.id;
            objective.title = team.title;
            teamLink.sessionId = this.board.session.id;
            teamLink.sessionBoardId = this.board.id;
 			/*if(this.isArt){
                teamLink.linkType = "art_link_objective";	
			} */
            objective.type = "Objective-Group"
            //objective.expand = true;
            objective.baseItemLinks = [];
            objective.baseItemLinks.push(teamLink);
            if(_.find(kendisStore.getters.getObjectiveGroupTemplate().statuses, {"category":"ToDo"}) != -1) {
                objective.status = _.find(kendisStore.getters.getObjectiveGroupTemplate().statuses, {"category": "ToDo"});
            }

            let metaMap = {};
            metaMap.syncId = syncId;
            metaMap.sessionId = vueInstance.activeBoard.session.id;
            metaMap.teamId = team.id;
            metaMap.boardId = this.board.id;
            if (this.customView && this.customView.id != "-1") {
				metaMap.viewId = this.customView.id;
			}
            objective.metaMap = JSON.stringify(metaMap);
            this.onCreateObjective(objective);
        },
		afterLoadObjectiveGroups: function(response) {
			let _this = this;
			let objAndKrLinkedItemsMap = response.objAndKrLinkedItemsMap;
			if(!_.isEmpty(objAndKrLinkedItemsMap)) {
                let linkedObjectiveItems = []
				_.each(_this.objectiveGroupList, objGrp=>{
					if(!_.isEmpty(objGrp.baseItemList)) {
						_.each(objGrp.baseItemList, obj=>{
							let objLinkedItemsMap = objAndKrLinkedItemsMap[obj.id];
							if(!_.isEmpty(objLinkedItemsMap)) {
								obj.linkedItems = objLinkedItemsMap.linkedItems;
								obj.linkedItemsIds = objLinkedItemsMap.linkedItemsIds;
								obj.linkedItemsById = objLinkedItemsMap.linkedItemsById;

                                _.forEach(obj.linkedItems, item => {
                                    if(!linkedObjectiveItems.includes(item.id)){
                                        linkedObjectiveItems.push(item.id);
                                    }
                                });
							}							
							if(!_.isEmpty(obj.baseItemList)) {
								_.each(obj.baseItemList, kr=>{
									let krLinkedItemsMap = objAndKrLinkedItemsMap[kr.id];
									if(!_.isEmpty(objLinkedItemsMap)) {
										kr.linkedItems = krLinkedItemsMap.linkedItems;
										kr.linkedItemsIds = krLinkedItemsMap.linkedItemsIds;
										kr.linkedItemsById = krLinkedItemsMap.linkedItemsById;									
									}									
								})
							}							
						})
					}
				})
				kendisStore.commit("setLinkedObjectiveMap", linkedObjectiveItems);
				_this.objectiveGroupListFetchResponse();
			}
			_this.isItemsLoaded = true;
            _this.reRenderKey = _this.generateRandomKey();
            _this.$nextTick(()=>{
                _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
				let containerInfo = kendisStore.getters.getObjOkrPopupContainerMap();
				if(containerInfo) {
					_.forOwn(containerInfo, function (value, key){
	                    if (value.isPopupOpen){
	                       toggleDraggable(true)
	                    }
	                });
				}
            })

		},
        loadObjectiveGroupsListBySessionBoardId: function () {
			let _this = this;
			if(_this.board.session.activeSessionBoard != _this.board.id && !_this.useOldApiForOldStateData){
				_this.loadOldStateObjectives();
				return;
			}
			let requestId 	= getNewUUID();
			startPoll(requestId, function(response){
				_this.afterLoadObjectiveGroups(response);
			});
            axios.get('objective/get-objective-groups-list-by-session-id/' + this.board.session.id +'/'+requestId+'/'+this.board.id)
                .then(response => {
                    if (response.status == "200") {
                        _this.toggleLoader(false);
                        _this.objectiveGroupList = response.data.objectiveGroups;
						_this.objectiveGroupListFetchResponse(response);
						_this.$emit("objectives-loaded");
                    }
                })
                .catch(error => {
                    _this.toggleLoader(false);
                    console.error("Item save error", error);

                })
        },
        loadOldStateObjectives: function () {
			let _this = this;
			let requestId 	= getNewUUID();
            axios.get('objective/load-old-state-objectives/'+this.board.id)
            .then(response => {
                if (response.status == "200") {
					if(!_.isEmpty(response.data)) {
						_this.toggleLoader(false);
						if (response.data.old_state_objectives) {
							response.data = JSON.parse(response.data.old_state_objectives);
							_this.objectiveGroupList = response.data.objectiveGroups;
							_this.objectiveGroupListFetchResponse(response);
						}
						_this.isItemsLoaded = true;
					} else {
						_this.useOldApiForOldStateData = true;
						_this.loadObjectiveGroupsListBySessionBoardId();
						_this.reRenderKey = _this.generateRandomKey();
					}
                }
            })
            .catch(error => {
                _this.toggleLoader(false);
                console.error("Item save error", error);

            })
        },
		afterFetchCompletion: function(response) {
			let _this = this;
			let completionsMap = response.completionById;
			kendisStore.commit("setOkrCompletionMap", completionsMap);
            if(typeof objectivesRtVU != "undefined") {
                if (objectivesRtVU.$refs['objectivesRef'] && (objectivesRtVU.$refs['objectivesRef'].sortableInstance === undefined || objectivesRtVU.$refs['objectivesRef'].sortableInstance === null)){
                    _this.$nextTick(()=>{
                        _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
                    });
                }
            }else if(typeof vueInstance != "undefined") {
                if (vueInstance.$refs['objectivesRef'] && (vueInstance.$refs['objectivesRef'].sortableInstance === undefined || vueInstance.$refs['objectivesRef'].sortableInstance === null)){
                    _this.$nextTick(()=>{
                        _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
                    });
                }
            } else if(typeof objectivesVU != "undefined") {
                if (objectivesVU.$refs['objectivesRef'] && (objectivesVU.$refs['objectivesRef'].sortableInstance === undefined || objectivesVU.$refs['objectivesRef'].sortableInstance === null)){
                    _this.$nextTick(()=>{
                        _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
                    });
                }
            }
		},
        loadObjectiveGroupsListByObjectId: function (hideLoader) {
            let _this = this;
            if (!hideLoader) {
				_this.toggleLoader(true);
			}
			
			let requestBody = {};
			let requestId = getNewUUID();
			requestBody.sessionId = this.board.session.id;
			requestBody.isMockingMode = this.isMockingMode;
			requestBody.requestId = requestId;

			if (this.customView || this.activeCustomView) {
				requestBody.viewId = this.customView ? this.customView.id : this.activeCustomView.id;
			}
			_this.isItemsLoaded = true;

			/*startPoll(requestId, function(response){
				_this.afterFetchCompletion(response);
			});*/
			
			requestBody.timePeriodFieldId = this.timePeriodFieldId;
			requestBody.timePeriodKRFieldId = this.timePeriodKRFieldId;
			
			let filter = this.timePeriodFilter;
            if (!_.isEmpty(filter.selectedValues)) {
                requestBody.timeperiods = filter.selectedValues;
                requestBody.byKrs = filter.byKrs;
                requestBody.byObjectives = filter.byObjectives;
            }
            else {
				requestBody.timeperiods = {};
			}

            if (_.isEmpty(requestBody.viewId) && this.customViewId) {
                requestBody.viewKey = this.customViewId;
            }

            if (!_.isEmpty(this.objectiveFilters.responsible)) {
                requestBody.responsibles = this.objectiveFilters.responsible.map(res => res.id);
                requestBody.responsibleFieldId = this.responsibleFieldId;
                requestBody.krResponsibleFieldId = this.responsibleKRFieldId;
            }

            if (!_.isEmpty(this.objectiveFilters.statuses)) {
                requestBody.statuses = this.objectiveFilters.statuses.map(status => status.id);
            }

            if (!_.isEmpty(this.objectiveFilters.collections)) {
                requestBody.collections = this.objectiveFilters.collections.map(collection => collection.id);
            }

            if (!_.isEmpty(this.objectiveFilters.searchQuery)) {
                requestBody.searchQuery = this.objectiveFilters.searchQuery;
            }
			
            axios.post('objective/get-objective-groups-list-by-object-id', requestBody)
                .then(response => {
                    if (response.status == "200") {
                        _this.toggleLoader(false);
                        _this.objectiveGroupList = response.data.objectiveGroups;
                        _this.unFilteredObjectiveGroupList = response.data.objectiveGroups;
                        if (_this.isMockingMode && _this.objectiveGroupList.length === 0){
							if (_.isEmpty(filter.selectedValues) && !this.isObjectiveFiltersApplied) {
								_this.showObjectiveBanner = true;
							}
                        }
						let departments = response.data.departments;
						if(departments) {
							_.each(departments, dpt=>{
								_this.departmentsMap[dpt.id] = {};
								_this.departmentsMap[dpt.id] = dpt;								
							});						
						}
						let batches = response.data.batches;
						if(batches) {
							_.each(batches, batch=>{
								_this.batchesMap[batch.id] = {};
								_this.batchesMap[batch.id] = batch;								
							});						
						}
						let sessions = response.data.sessions;
						if(sessions) {
							_.each(sessions, session=>{
								_this.sessionsMap[session.id] = {};
								_this.sessionsMap[session.id] = session;								
							})
						}
						let sessionBoards = response.data.sessionBoards
						if(sessionBoards) {
							let sessionBoardsMap = {}
							_.each(sessionBoards, sb=>{
								sessionBoardsMap[sb.id] = sb;
							});
							kendisStore.commit("setSessionBoardsMap", sessionBoardsMap);
						}
                        let objectivesByGroups = {};
                        let sessionId = "";
                        if(_this.isMockingMode){
                            sessionId = _this.board.session.id;
                        }
                        else if (typeof board != "undefined"){
                            sessionId = board._board.session.id
                        }
                        else if (typeof vueInstance != "undefined"){
                            sessionId = vueInstance.activeBoard.session.id
                        }
                        let objGrpKeyMap = {};
						let groupIds = [];
                        _.each(_this.objectiveGroupList, obGrp=>{
                            objGrpKeyMap[obGrp.id] = 0;
                            let localStorageExpandValue = localStorage.getItem('objective_expand_' + sessionId + '_' + obGrp.id);
							if(localStorageExpandValue === "true") {
								groupIds.push(obGrp.id);
							}
                            obGrp.expand = JSON.parse(localStorageExpandValue) === true
                            if(!_.isEmpty(obGrp.baseItemList)) {
                                objectivesByGroups[obGrp.id] = obGrp.baseItemList;
                            }
                        });
						if(!_.isEmpty(groupIds)) {
                            if(this.filteredGroups && this.filteredGroups.length > 0){
                                this.allGroupIds = this.filteredGroups;
                            } else {
                                this.allGroupIds = groupIds;
                            }
 							_this.fetchGroupsData(groupIds);
						}
						
                        //_this.originalObjectiveGroupList = _.cloneDeep(response.data.objectiveGroups);
                        let objectivesState = {};
                        objectivesState.objectivesByGroups = objectivesByGroups;
                        objectivesState.objectiveGroupList = _this.objectiveGroupList;
                        kendisStore.commit("setGroupsAndRows", objectivesState);
                        kendisStore.commit("setObjGrpKeyMap", objGrpKeyMap);
                        // ********************************************************** //
                        //          Saving Linked Objective Map in KendisStore        //
                        // ********************************************************** //

                        let linkedObjectiveItems = []
                        _.forEach(_this.objectiveGroupList, (groups) => {
                            _.forEach(groups, group => {
                                _.forEach(group, objective => {
                                    if(objective.linkedItems && objective.linkedItems != undefined && objective.linkedItems.length > 0) {
                                        _.forEach(objective.linkedItems, item => {
                                            if(!linkedObjectiveItems.includes(item.id)){
                                                linkedObjectiveItems.push(item.id);
                                            }
                                        });
                                    }
                                });
                            })
                        });
                        kendisStore.commit("setLinkedObjectiveMap", linkedObjectiveItems);

                        // ********************************************************** //
			            if(typeof objectivesRtVU != "undefined") {
			                if (objectivesRtVU.$refs['objectivesRef'] && (objectivesRtVU.$refs['objectivesRef'].sortableInstance === undefined || objectivesRtVU.$refs['objectivesRef'].sortableInstance === null)){
			                    _this.$nextTick(()=>{
			                        _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
			                    });
			                }
			            }else if(typeof vueInstance != "undefined") {
			                if (vueInstance.$refs['objectivesRef'] && (vueInstance.$refs['objectivesRef'].sortableInstance === undefined || vueInstance.$refs['objectivesRef'].sortableInstance === null)){
			                    _this.$nextTick(()=>{
			                        _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
			                    });
			                }
			            } else if(typeof objectivesVU != "undefined") {
			                if (objectivesVU.$refs['objectivesRef'] && (objectivesVU.$refs['objectivesRef'].sortableInstance === undefined || objectivesVU.$refs['objectivesRef'].sortableInstance === null)){
			                    _this.$nextTick(()=>{
			                        _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
			                    });
			                }
			            }
						_this.$emit("objectives-loaded");
                    }
                })
                .catch(error => {
                    _this.toggleLoader(false);
                    console.error("Item save error", error);

                })
        },
		fetchGroupsData: function(groupIds) {
			let _this = this;
			let requestBody = {};
			requestBody.sessionId = this.board.session.id;
			requestBody.groupIds = groupIds;
			
			requestBody.timePeriodFieldId = this.timePeriodFieldId;
			requestBody.timePeriodKRFieldId = this.timePeriodKRFieldId;
			
			let filter = this.timePeriodFilter;
            if (!_.isEmpty(filter.selectedValues)) {
                requestBody.timeperiods = filter.selectedValues;
                requestBody.byKrs = filter.byKrs;
                requestBody.byObjectives = filter.byObjectives;
            }
            else {
				requestBody.timeperiods = {};
			}

            if (!_.isEmpty(this.objectiveFilters.responsible)) {
                requestBody.responsibles = this.objectiveFilters.responsible.map(res => res.id);
                requestBody.responsibleFieldId = this.responsibleFieldId;
                requestBody.krResponsibleFieldId = this.responsibleKRFieldId;
            }

            if (!_.isEmpty(this.objectiveFilters.statuses)) {
                requestBody.statuses = this.objectiveFilters.statuses.map(status => status.id);
            }

            if (!_.isEmpty(this.objectiveFilters.collections)) {
                requestBody.collections = this.objectiveFilters.collections.map(collection => collection.id);
            }

            if (!_.isEmpty(this.objectiveFilters.searchQuery)) {
                requestBody.searchQuery = this.objectiveFilters.searchQuery;
            }
			
			axios.post('objective/get-objectives-of-group', requestBody)
			.then(response=>{
				if (response.status == "200") {
					let groups = response.data.objectiveGroups;
                    let sessionId = "";
                    if(_this.isMockingMode){
                        sessionId = _this.board.session.id;
                    }
                    else if (typeof board != "undefined"){
                        sessionId = board._board.session.id
                    }
                    else if (typeof vueInstance != "undefined"){
                        sessionId = vueInstance.activeBoard.session.id
                    }
					let objectivesFetchedMap = {};
					_.each(groups, grp=>{
						let grpIndex = _.findIndex(_this.objectiveGroupList, {"id": grp.id});
						_this.objectiveGroupList.splice(grpIndex, 1, grp);
						objectivesFetchedMap[grp.id] = true;
					});
					kendisStore.commit('setIsObjectivesOfGroupFetched', objectivesFetchedMap)
                    _.each(_this.objectiveGroupList, obGrp=>{
                        let localStorageExpandValue = localStorage.getItem('objective_expand_' + sessionId + '_' + obGrp.id);
                        obGrp.expand = JSON.parse(localStorageExpandValue) === true
                    });
					
					let departments = response.data.departments;
					if(departments) {
						_.each(departments, dpt=>{
							_this.departmentsMap[dpt.id] = {};
							_this.departmentsMap[dpt.id] = dpt;								
						});						
					}
					let batches = response.data.batches;
					if(batches) {
						_.each(batches, batch=>{
							_this.batchesMap[batch.id] = {};
							_this.batchesMap[batch.id] = batch;								
						});						
					}
					let sessions = response.data.sessions;
					if(sessions) {
						_.each(sessions, session=>{
							_this.sessionsMap[session.id] = {};
							_this.sessionsMap[session.id] = session;								
						})
					}
				}
			})
			.catch(error=>{
				console.error(error);
			})
		},
        loadObjectiveGroupsListBySolutionId: function () {
			let _this = this;
            axios.get('objective/get-objective-groups-list-by-solution-id/' + this.solutionBoard.id)
                .then(response => {
                    if (response.status == "200") {
                        _this.toggleLoader(false);
                        _this.objectiveGroupList = response.data.objectiveGroups;
                        // _this.originalObjectiveGroupList = JSON.parse(JSON.stringify(response.data.objectiveGroups));
                    }
                })
                .catch(error => {
                    _this.toggleLoader(false);
                    console.error("Item save error", error);

                })
        },
		objectiveGroupListFetchResponse: function(response) {
			let _this = this;			
			let objectivesByGroups = {};
            let sessionId = "";
			let solutionBoardId = "";
            if (typeof vueInstance != "undefined"){
				if(vueInstance.activeBoard && vueInstance.activeBoard.session) {
                	sessionId = vueInstance.activeBoard.session.id
				} else if(vueInstance.activeSolutionBoard && vueInstance.activeSolutionBoard.id) {
					solutionBoardId = vueInstance.activeSolutionBoard.id
				}
            }
            let objGrpKeyMap = {};
            let popupContainerMap = {};
			let filteredObjectiveGroups = [];
			_.each(_this.objectiveGroupList, obGrp=>{
				filteredObjectiveGroups.push(obGrp.id);
                objGrpKeyMap[obGrp.id] = 0;
                popupContainerMap[obGrp.id] = {};
				let localStorageExpandValue = false;
				if(_.isEmpty(solutionBoardId)) {
                	localStorageExpandValue = localStorage.getItem('objective_expand_' + sessionId + '_' + obGrp.id)
				}
				else {
                	localStorageExpandValue = localStorage.getItem('objective_expand_' + solutionBoardId + '_' + obGrp.id)								
				}
                obGrp.expand = JSON.parse(localStorageExpandValue) === true || localStorageExpandValue === null;
				if(!_.isEmpty(obGrp.baseItemList)) {
					objectivesByGroups[obGrp.id] = obGrp.baseItemList;
				}
			});
			let queryString = window.location.search;
			const urlParams = new URLSearchParams(queryString);
			let viewIndex = urlParams.get("moreOptionsIndex");
			if(!_.isEmpty(localStorage.getItem("filteredGroups_"+this.board.id)) && !_.isEmpty(viewIndex) && viewIndex == 3) {
				filteredObjectiveGroups = JSON.parse(localStorage.getItem("filteredGroups_"+this.board.id));
			}
			kendisStore.commit("setFilteredGroups", filteredObjectiveGroups);
			
			if(this.readOnlyView) {
				if(response) {
					_this.objectiveGroupsForReadOnly = _.cloneDeep(response.data.objectiveGroups);
				} else {
					_this.objectiveGroupsForReadOnly = _this.objectiveGroupList;
				}
			}
			let objectivesState = {};
			objectivesState.objectivesByGroups = objectivesByGroups;
			objectivesState.objectiveGroupList = _this.objectiveGroupList;
			kendisStore.commit("setGroupsAndRows", objectivesState);
			kendisStore.commit("setObjGrpKeyMap", objGrpKeyMap);
            let objPopupContainerMap = kendisStore.getters.getObjOkrPopupContainerMap();
            if (_.isEmpty(objPopupContainerMap)){
               kendisStore.commit("setObjOkrPopupContainerMap", popupContainerMap);
            }
			
		},
        refreshTeamList: function (_newList) {
            _newList = _.cloneDeep(this.originalObjectiveGroupList);
            if(this.isUserSearching) {
                return;
            }
            var teamsList = _.cloneDeep(this.board.teams);
            var teamObjectiveCreated = [];
            _.forEach(_newList, function (item) {
                _.forEach(item.baseItemLinks, function (item2) {
                    teamObjectiveCreated.push(item2.teamId);
                });
            });

            _.forEach(teamsList, function (team) {
                if (teamObjectiveCreated.includes(team.id)) {
                    team.disabled = true;
                } else {
                    team.disabled = false;
                }
            });
            this.teams = teamsList;
        },

        confirmDeleteObjectiveGroup: function (objectiveGroupId) {
            askFromSweetAlertWrapper('You want to delete objective group?', [this.deleteObjectiveGroup, [objectiveGroupId]], [takeNoAction]);
        },

        deleteObjectiveGroup: function (objectiveGroupId) {
            this.allGroupIds = this.allGroupIds.filter(groups => !groups.includes(objectiveGroupId));
            let _this = this;
            let requestBody = {};
            let metaMap = {};
            if(_this.isMockingMode){
                metaMap = {
                    "syncId" : syncId,
                    "sessionId" : _this.board.session.id,
                }
            }
            else{
                metaMap = {
                    "syncId" : syncId,
                    "sessionId" : vueInstance.activeBoard.session.id,
                }

            }

            requestBody.objId = objectiveGroupId[0];
            requestBody.metaMap = JSON.stringify(metaMap);

            axios.post('/objective/delete-objective', requestBody).then(response => {
                if (response && response.status == "200") {
                    // _.remove(_this.originalObjectiveGroupList, {id: objectiveGroupId[0]});
                    if (_this.objectiveGroupList.length !== _this.originalObjectiveGroupList.length){
                        _this.objectiveGroupList = _this.originalObjectiveGroupList;
                    }
                     let groupIndex = _.findIndex(_this.objectiveGroupList, {id: objectiveGroupId[0]});
                    if (groupIndex > -1){
                        _this.objectiveGroupList.splice(groupIndex, 1);
                    }
                    _this.refreshTeamList(_this.objectiveGroupList);
                    _this.menuComponentKey += 1;

                    /*if (_this.objectiveGroupList.length !== _this.originalObjectiveGroupList.length){
                        _this.objectiveGroupList = _this.originalObjectiveGroupList;
                    }*/

                    kendisStore.commit("setOjectiveGroups", _this.objectiveGroupList);
                    if(_this.objectiveGrpKeyMap.hasOwnProperty(objectiveGroupId)){
                        delete _this.objectiveGrpKeyMap[objectiveGroupId];
                        kendisStore.commit("setObjGrpKeyMap", _this.objectiveGrpKeyMap);
                    }
                    // _this.$forceUpdate();
                    showTopMessage("Objective group deleted.", 'success');
                    if (_this.objectiveGroupList.length === 0 && _this.isMockingMode && !this.isObjectiveFiltersApplied){
                        _this.showObjectiveBanner = true;
                    }
                    if (!_.isEmpty(_this.activeCustomView)) {
                        _this.updateCustomView();
                    }
                }
            }).catch(error => {
                console.error("Objective delete error", error);
            });
        },

        updateCustomView() {
            this.fetchCustomViews();
        },

        cancelAction: function () {
            this.$emit("close");
        },

        onAddCustomClickHandle: function () {
            this.addCustomFormCounter++;
            this.showObjectiveBanner = false;
        },

        //.........drag and drop methods
        onDragChange: function (evt) {
            let _this = this;
            let toDataType = evt.to.getAttribute("data-type");
            if(toDataType === "committed" || toDataType === "uncommitted"){
                _this.updateReRenderKey(_this.generateRandomKey());
				_this.$nextTick(()=>{
		            _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);							
				})
                return;
            }
			if(evt.oldIndex != evt.newIndex) {
	            let result = _this.calculateNewSequenceOfItem(evt.newIndex, evt.oldIndex, _this.objectiveGroupList, 'sequence');
	            let objective = _this.objectiveGroupList[evt.oldIndex];
	            objective.sequence = result.value;
	            if (!objective.metaMap || objective.metaMap == "undefined") {
	                let metaMap = {};
	                metaMap.sosId = "0";
	                metaMap.boardId = this.board.id;
	                objective.metaMap = JSON.stringify(metaMap);
	            }
	            let requestBody = {
	                id: objective.id,
	                sequence: objective.sequence,
	                metaMap: objective.metaMap
	            }
				
	            _this.onUpdateObjective(requestBody, evt.oldIndex, evt.newIndex);
			}
        },

        doFilterObjectiveList: function (searchQuery, eventType) {
            if (!_.isEmpty(searchQuery) && eventType === "insertText" || eventType === "deleteContentBackward"){
                toggleDraggable(true);
            }
            if (this.isMockingMode) {
                this.objectiveFilters.searchQuery = searchQuery;
                this.loadObjectiveGroupsListByObjectId(true);
            }
            else {
                let tempArray = [];
                if(this.readOnlyView) {
                    tempArray = _.cloneDeep(this.objectiveGroupsForReadOnly);
                } else {
                    tempArray = _.cloneDeep(this.originalObjectiveGroupList);
                }
                if (!_.isEmpty(this.timePeriodFilter) && !_.isEmpty(this.timePeriodFilter.selectedValues)) {
                    tempArray = this.applyTimePeriodFilterOnSearch(tempArray);
                }
                this.objectiveGroupList = this.filterArray(tempArray, searchQuery);
                if(this.objectiveGroupList.length > 0) {
                    _.forEach(this.objectiveGroupList, function (group) {
                        if (eventType === "insertText" || eventType === "deleteContentBackward"){
                            group.expand = true;
                        }
                        kendisStore.commit("incrementObjGrpKeyMap", group.id);
                        if(typeof vueInstance != "undefined" && vueInstance.$refs &&  vueInstance.$refs['objectivesRef'] && vueInstance.$refs['objectivesRef'].$refs && vueInstance.$refs['objectivesRef'].$refs['objectiveGroup-'+group.id] && vueInstance.$refs['objectivesRef'].$refs['objectiveGroup-'+group.id].length > 0) {
                            if(vueInstance.$refs['objectivesRef'].$refs['objectiveGroup-' + group.id][0] && vueInstance.$refs['objectivesRef'].$refs['objectiveGroup-' + group.id][0].$children && vueInstance.$refs['objectivesRef'].$refs['objectiveGroup-' + group.id][0].$children.length > 0){
                                _.forEach(vueInstance.$refs['objectivesRef'].$refs['objectiveGroup-' + group.id][0].$children, function(child) {
                                    child.toggleShowLinkedItemsComponent(true);
                                });
                            }
                        }
                    });
                }
                if (_.isEmpty(searchQuery) && eventType === "insertText" || eventType === "deleteContentBackward"){
                    toggleDraggable(false);
                }
            }
        },

        applyTimePeriodFilterOnSearch(list) {
            let filter = this.timePeriodFilter;
            if (_.isEmpty(filter.selectedValues)) {
                return list;
            }
        
            _.each(list, (group) => {
                _.each(group.baseItemList, (objective) => {
                    let objectiveMatches = false;
                    let krMatches = false;
        
                    if (filter.byObjectives) {
                        if (objective.fields && objective.fields[this.timePeriodFieldId]) {
                            objectiveMatches = filter.selectedValues[filter.selectedYear].includes(objective.fields[this.timePeriodFieldId].title) &&
                                objective.fields[this.timePeriodFieldId].selectedYear === filter.selectedYear;
                        }
                    } else {
                        objectiveMatches = true;
                    }
        
                    if (filter.byKrs) {
                        let matchingKRs = _.filter(objective.baseItemList, (kr) => {
                            if (kr.fields && kr.fields[this.timePeriodKRFieldId]) {
                                return filter.selectedValues[filter.selectedYear].includes(kr.fields[this.timePeriodKRFieldId].title) &&
                                    kr.fields[this.timePeriodKRFieldId].selectedYear === filter.selectedYear;
                            }
                            return false;
                        });
        
                        krMatches = matchingKRs.length > 0;
                    } else {
                        krMatches = true;
                    }
        
                    if (filter.byObjectives && filter.byKrs) {
                        objective.shouldInclude = objectiveMatches && krMatches;
                    } else if (filter.byObjectives) {
                        objective.shouldInclude = objectiveMatches;
                    } else if (filter.byKrs) {
                        objective.shouldInclude = krMatches && !_.isEmpty(objective.baseItemList);
                    } else {
                        objective.shouldInclude = true;
                    }
                });
        
                group.baseItemList = _.filter(group.baseItemList, (objective) => {
                    return objective.shouldInclude;
                });
            });
        
            list = _.filter(list, (group) => {
                return group.baseItemList.length > 0;
            });

            return list;
        },

        markHighLights: function(input, context){
            let markInstance = new Mark(context);
            markInstance.mark(input, {
                "element": "highlight",
                "caseSensitive": false,
                acrossElements: true
            });
        },

        exportReport: function (_type){
            let _this = this;
			let completionCriteria = kendisStore.getters.getObjectiveCompletionCriteria();
            let requestBody = {
                sessionId: _this.board.session.id,
                type: _type,
            };
			if(completionCriteria && completionCriteria.code != "OBJ_KR_WEIGHTS_FORMULA") {
				requestBody.completionCriteria = completionCriteria.code;
			}
            let params = new ajaxParams("/objective/export-report", "POST",requestBody,'downloadFromPath','onDownloadError');
			ajaxRequest(params);
        },

        exportTheme: function (_type, requestId) {
            // 1. Set side effects related to the export action
            this.isItemsLoaded = true;

            // 2. Delegate the complex payload creation to a helper method
            let requestBody = this._buildExportRequestBody(_type, requestId);

            // 3. Perform the action (send the request)
            let params = new ajaxParams("/objective/export-theme", "POST", requestBody, 'downloadFromPath', 'onDownloadError');
            ajaxRequest(params);
        },

        _buildExportRequestBody: function (_type, requestId) {
            // Initialize with basic properties
            let requestBody = {
                sessionId: this.board.session.id,
                isMockingMode: this.isMockingMode,
                timePeriodFieldId: this.timePeriodFieldId,
                timePeriodKRFieldId: this.timePeriodKRFieldId,
                collectionId: this.releaseTrainId,
                viewType: this.viewType,
                type: _type // Pass the original _type object
            };

            if (requestId) {
                requestBody.requestId = requestId;
            }

            // --- View ---
            if (this.customView || this.activeCustomView) {
                requestBody.viewId = this.customView ? this.customView.id : this.activeCustomView.id;
            } else if (this.customViewId) {
                // Fallback to viewKey if viewId wasn't set
                requestBody.viewKey = this.customViewId;
            }

            // --- Time Period Filter ---
            let filter = this.timePeriodFilter;
            if (!_.isEmpty(filter.selectedValues)) {
                requestBody.timeperiods = filter.selectedValues;
                requestBody.byKrs = filter.byKrs;
                requestBody.byObjectives = filter.byObjectives;
            } else {
                requestBody.timeperiods = {};
            }

            // --- Objective Filters ---
            if (!_.isEmpty(this.objectiveFilters.responsible)) {
                requestBody.responsibles = this.objectiveFilters.responsible.map(res => res.id);
                requestBody.responsibleFieldId = this.responsibleFieldId;
                requestBody.krResponsibleFieldId = this.responsibleKRFieldId;
            }

            if (!_.isEmpty(this.objectiveFilters.statuses)) {
                requestBody.statuses = this.objectiveFilters.statuses.map(status => status.id);
            }

            if (!_.isEmpty(this.objectiveFilters.collections)) {
                requestBody.collections = this.objectiveFilters.collections.map(collection => collection.id);
            }

            if (!_.isEmpty(this.objectiveFilters.searchQuery)) {
                requestBody.searchQuery = this.objectiveFilters.searchQuery;
            }

            // --- Column Selection ---
            // Delegate the complex column logic to another helper
            // This helper will *mutate* requestBody, following the original logic
            this._applyColumnSelection(requestBody, _type);

            return requestBody;
        },

        _applyColumnSelection: function (requestBody, _type) {
            if (_type && _type.selectionType === 'columnSelection') {
                if (!_.isEmpty(_type.selectedColumns)) {
                    // Clone the array to avoid mutating the original _type.selectedColumns directly
                    let selectedColumnKeys = [..._type.selectedColumns];

                    // Ensure required columns are always included
                    if (!selectedColumnKeys.includes('hType')) {
                        selectedColumnKeys.unshift('hType');
                    }
                    if (!selectedColumnKeys.includes('hLevel')) {
                        selectedColumnKeys.unshift('hLevel');
                    }

                    // This modifies requestBody.type.selectedColumns (since requestBody.type *is* _type)
                    requestBody.type.selectedColumns = selectedColumnKeys;
                } else {
                    // No columns selected, use default
                    requestBody.columnSelection = "default";
                }
            } else {
                // Not in column selection mode, use default
                requestBody.columnSelection = "default";
            }
        },

        initObjectiveModalTemplate: function(){
            let _this = this;
			let sessionId = "";
            if(_this.isMockingMode){
                sessionId = _this.board.session.id;
            }
			else if(vueInstance && vueInstance.activeBoard && vueInstance.activeBoard.session) {
            	sessionId = vueInstance.activeBoard.session.id
			}
			else if(!_.isEmpty(_this.board) && _this.board.session) {
				sessionId = _this.board.session.id
			}
            axios.get('objective/get-objective-modal-template/'+sessionId).then(function(response){
                // This API return two template FIRST for objective template
                // & SECOND for objective group template
                // To access use data.objectiveTemplate
                // TO access use data.groupTemplate
                let templates = {};
                let progressCriteriaGroupFields = [];
				templates.objectiveGroupTemplate = {scheme: response.data.groupTemplate.scheme	,statuses: response.data.groupTemplate.statuses, fieldsMap: []};
				templates.objectiveTemplate = {scheme: response.data.objectiveTemplate.scheme	,statuses: response.data.objectiveTemplate.statuses, fieldsMap: []};
                if(templates.objectiveTemplate.scheme.fieldsTemplate) {
					let objCounter = 0;
                    _.each(templates.objectiveTemplate.scheme.fieldsTemplate.configuredFields, field=>{
						if(field.isGroup) {
							field.subTemplate 					= {};
							field.subTemplate.configuredFields 	= field.groupFields;
                            _.each(field.groupFields, _field => {
                                _field.tabIndex = objCounter++;
                                templates.objectiveTemplate.fieldsMap[_field.id] = _field.title;
                                if (_field.title === 'Time Period') {
                                    _this.timePeriodFieldId = _field.id;
                                }
                                if (_field.title === 'Start Date') {
                                    _this.startDateFieldId = _field.id;
                                }
                                if (_field.title === 'End Date') {
                                    _this.endDateFieldId = _field.id;
                                }
                                if (_field.title === 'Responsible') {
                                    _this.responsibleFieldId = _field.id;
                                }
                            });
						}
					})
				}
                templates.okrTemplate		= {scheme: response.data.okrTemplate.scheme			,statuses: response.data.okrTemplate.statuses, fieldsMap: []};
				if(templates.okrTemplate.scheme.fieldsTemplate) {
					let okrCounter = 0;
                    _.each(templates.okrTemplate.scheme.fieldsTemplate.configuredFields, field=>{
						if(field.isGroup) {
							/*if(field.title == "Progress Criteria") {
								field.groupFields[0].options.splice(2,1);
							}*/
							field.subTemplate 					= {};
							field.subTemplate.configuredFields 	= field.groupFields;
                            _.each(field.groupFields, _field => {
                                _field.tabIndex = okrCounter++;
                                templates.okrTemplate.fieldsMap[_field.id] = _field.title;
                                if (_field.title === 'Time Period') {
                                    _this.timePeriodKRFieldId = _field.id;
                                }
                                if (_field.title === 'Responsible') {
                                    _this.responsibleKRFieldId = _field.id;
                                }
                            });
						}
					})
				}
                let configuredFieldObj = templates.okrTemplate.scheme.fieldsTemplate.configuredFields.find(field => {
                    return field.title === "Progress Criteria";
                });
                _.each(configuredFieldObj.groupFields, groupField => {
                    if (groupField.title === "Progress Criteria"){
                        _this.krProgressCriteriaFieldId = groupField.id;
                    }
                    progressCriteriaGroupFields.push({
                        "title" : groupField.title,
                        "id"    : groupField.id
                    });
                })
                kendisStore.commit("setOkrProgressCriteriaGroupFields", progressCriteriaGroupFields);
                kendisStore.commit("setObjectiveAndOkrTemplate",templates);
                if(response.data.objectiveMenuOptions){
                    let temp = response.data.objectiveMenuOptions;
                    let objectiveMenuOptions = {};
                    objectiveMenuOptions.isBVAchievementEnabled = temp.bvachievementEnabled;
                    objectiveMenuOptions.isUnCommittedEnabled = temp.unCommittedEnabled;
                    objectiveMenuOptions.isStatusEnabled = temp.statusEnabled;
                    objectiveMenuOptions.isProgressEnabled = temp.progressEnabled;
                    objectiveMenuOptions.isOkrEnabled = temp.okrEnabled;
                    objectiveMenuOptions.isOkrBVAchievementEnabled = temp.okrBVAchievementEnabled;
                    objectiveMenuOptions.isOkrStatusEnabled = temp.okrStatusEnabled;
                    kendisStore.commit("setObjectiveMenuOptions", objectiveMenuOptions);
                    _this.objectiveMenuOptions = objectiveMenuOptions;
                    _this.isLoaded = true;
					_this.$emit("data-loaded");
                }
                let startFieldObj = configuredFieldObj.groupFields.find(field => {
                    return field.title === "Start";
                });
				if(_.isEmpty(startFieldObj)) {
					_this.updateKrTemplate();
				}

				if (!_this.isMockingMode) {
					_this.setupPermissions();
				} else {
					_this.fetchWorkspace();
				}

            }).catch(error => {
                console.log(error)
            });
        },

        statusToggle: function(val){
            this.isStatusEnabled = val;
        },
        setupPermissions: function () {
            let EDIT_OBJECTIVE;
			let EDIT_OBJECTIVE_GROUP;
			let DELETE_OBJECTIVE_GROUP;
            let LINK_UNLINK_OBJECTIVE_ITEMS;
            let DELETE_OBJECTIVE;
            let EDIT_OKR;
            let LINK_UNLINK_OKR_ITEMS;
            let DELETE_OKR;
            let VIEW_OBJECTIVE_SETTINGS;
            if(this.isMockingMode){
                VIEW_OBJECTIVE_SETTINGS 	= this.isActionAllowed("global-objective-settings");
				EDIT_OBJECTIVE_GROUP		= this.isActionAllowed("global-edit-objective-group");
				DELETE_OBJECTIVE_GROUP		= this.isActionAllowed("global-delete-objective-group");
                EDIT_OBJECTIVE 				= this.isActionAllowed("global-edit-objective");
                LINK_UNLINK_OBJECTIVE_ITEMS = this.isActionAllowed("global-link-unlink-objective");
                DELETE_OBJECTIVE		    = this.isActionAllowed("global-delete-objective");
                EDIT_OKR 					= this.isActionAllowed("global-edit-okr");
                LINK_UNLINK_OKR_ITEMS		= this.isActionAllowed("global-link-unlink-okr");
                DELETE_OKR 					= this.isActionAllowed("global-delete-okr");
            }

            else if (isBoardJS()) {
                if (!_.isEmpty(board) && !_.isEmpty(board._board) &&
                    board._board.session ) {

                    let wsId = board._board.session.workSpace.id ;

                    VIEW_OBJECTIVE_SETTINGS 	= board.isActionAllowed(wsId, "objective-settings");
					DELETE_OBJECTIVE_GROUP		= board.isActionAllowed(wsId, "delete-objective-group");
                    EDIT_OBJECTIVE_GROUP 		= board.isActionAllowed(wsId, "edit-objective-group");
                    EDIT_OBJECTIVE 				= board.isActionAllowed(wsId, "edit-objective");
                    LINK_UNLINK_OBJECTIVE_ITEMS = board.isActionAllowed(wsId, "link-unlink-objective");
                    DELETE_OBJECTIVE		    = board.isActionAllowed(wsId, "delete-objective");
                    EDIT_OKR 					= board.isActionAllowed(wsId, "edit-okr");
                    LINK_UNLINK_OKR_ITEMS		= board.isActionAllowed(wsId, "link-unlink-okr");
                    DELETE_OKR 					= board.isActionAllowed(wsId, "delete-okr");
                }
            }else if (isPiBoardJS() ) {
                if (this && vueInstance.activeBoard &&
                    vueInstance.activeBoard.session ) {

                    VIEW_OBJECTIVE_SETTINGS 	= vueInstance.isActionAllowed("objective-settings");
                    EDIT_OBJECTIVE_GROUP 		= vueInstance.isActionAllowed("edit-objective-group")
					DELETE_OBJECTIVE_GROUP		= vueInstance.isActionAllowed("delete-objective-group");
                    EDIT_OBJECTIVE 				= vueInstance.isActionAllowed("edit-objective");
                    LINK_UNLINK_OBJECTIVE_ITEMS = vueInstance.isActionAllowed("link-unlink-objective");
                    DELETE_OBJECTIVE		    = vueInstance.isActionAllowed("delete-objective");
                    EDIT_OKR 					= vueInstance.isActionAllowed("edit-okr");
                    LINK_UNLINK_OKR_ITEMS		= vueInstance.isActionAllowed("link-unlink-okr");
                    DELETE_OKR 					= vueInstance.isActionAllowed("delete-okr");
                }
            }

            let permissions = {
                VIEW_OBJECTIVE_SETTINGS 	: VIEW_OBJECTIVE_SETTINGS,
				EDIT_OBJECTIVE_GROUP		: EDIT_OBJECTIVE_GROUP,
				DELETE_OBJECTIVE_GROUP		: DELETE_OBJECTIVE_GROUP,
                EDIT_OBJECTIVE 				: EDIT_OBJECTIVE,
                LINK_UNLINK_OBJECTIVE_ITEMS : LINK_UNLINK_OBJECTIVE_ITEMS,
                DELETE_OBJECTIVE 		    : DELETE_OBJECTIVE,
                EDIT_OKR 					: EDIT_OKR,
                LINK_UNLINK_OKR_ITEMS		: LINK_UNLINK_OKR_ITEMS,
                DELETE_OKR					: DELETE_OKR
            };
	        this.$options.permissions = permissions;
            kendisStore.commit('setObjectiveAndOkrPermissions', permissions);
        },
        updateReRenderKey: function(newKey){
            this.reRenderKey = newKey;
        },
        updateGroupList: function(updatedValue) {
            let _this = this;
            if(typeof updatedValue == "object" && !Array.isArray(updatedValue)){
                // object received
                let index = _.findIndex(_this.objectiveGroupList, {id: updatedValue.id});
                if(_this.objectiveGroupList[index].baseItemList && _this.objectiveGroupList[index].baseItemList.length > 0) {
                    updatedValue.baseItemList = _this.objectiveGroupList[index].baseItemList;
                } else {
                    updatedValue.baseItemList = [];
                }
                //_this.objectiveGroupList[index] = updatedValue;
				Vue.set(_this.objectiveGroupList, index, updatedValue);
            } else if(updatedValue === "revertFrontEndChanges") {
                _this.objectiveGroupList = _this.originalObjectiveGroupList;
                _this.updateReRenderKey(_this.generateRandomKey());
				_this.$nextTick(()=>{
		            _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);							
				})
            } else {
                if(_this.isMockingMode){
                    _this.loadObjectiveGroupsListByObjectId();
                }else{
                    _this.loadObjectiveGroupsListBySessionBoardId();

                }
            }
        },
        saveExcludeItems: function (excludedItems){
            kendisStore.commit('setExcludeItemsData', excludedItems);
            _.each(this.objectiveGroupList, objGrp => {
                kendisStore.commit("incrementObjGrpKeyMap", objGrp.id);
            });
        },
        updateObjectiveGroupList: function (payload, event){
            let _this = this;
            if (!_.isEmpty(payload)){
                if (event === "delete-objective"){
                    _.each(_this.objectiveGroupList, objGrp => {
                        let index = _.findIndex(objGrp.baseItemList, {id : payload.deletedObjective.id});
                        if (index > -1){
                            objGrp.baseItemList.splice(index, 1);
                            index =  _.findIndex(objGrp.baseItemLinks, {baseItemId : payload.deletedObjective.id});
                            if (index > -1){
                                objGrp.baseItemLinks.splice(index, 1);
                            }
                            kendisStore.commit("incrementObjGrpKeyMap", objGrp.id);
                        }
                    });

                }
                /*else if (event === "save-objective"){
                    let originalListIndex = _.findIndex(_this.originalObjectiveGroupList, {id : payload.parentGroup.id});
                    if (originalListIndex > -1){
                        if (!_this.originalObjectiveGroupList[originalListIndex].baseItemList) {
                            _this.originalObjectiveGroupList[originalListIndex].baseItemList = [];
                        }

                        let objectiveExists = _.some(_this.originalObjectiveGroupList[originalListIndex].baseItemList, { id: payload.updatedObjective.id });

                        if (!objectiveExists) {
                            _this.originalObjectiveGroupList[originalListIndex].baseItemList.push(payload.updatedObjective);
                        }
                        _this.originalObjectiveGroupList[originalListIndex].baseItemLinks = payload.parentGroup.baseItemLinks;
                        kendisStore.commit("updateSingleGroup", _this.originalObjectiveGroupList[originalListIndex]);
                    }
                }else if (event === "team-linking"){
                    let groupListIndex = _.findIndex(_this.objectiveGroupList, {id : payload.linkedGroup.id});
                    if (groupListIndex > -1){
                        if (!_this.objectiveGroupList[groupListIndex].baseItemList) {
                            _this.objectiveGroupList[groupListIndex].baseItemList = [];
                        }

                        let objectiveExists = _.some(_this.objectiveGroupList[groupListIndex].baseItemList, { id: payload.linkedObjective.id });

                        if (!objectiveExists) {
                            _this.objectiveGroupList[groupListIndex].baseItemList.push(payload.linkedObjective);
                        }
                        _this.objectiveGroupList[groupListIndex].baseItemLinks = payload.linkedGroup.baseItemLinks;
                        // _this.originalObjectiveGroupList = _.cloneDeep(_this.objectiveGroupList);
                        _this.originalObjectiveGroupList = kendisStore.getters.getOjectiveGroups();
                    }
                }else if (event === "team-unlinking"){
                    let groupListIndex = _.findIndex(_this.objectiveGroupList, {id : payload.unLinkedGroup.id});
                    if (groupListIndex > -1){
                        let objectiveIndex = _.findIndex(_this.objectiveGroupList[groupListIndex].baseItemList, {id : payload.unLinkedObjective.id});
                        if (objectiveIndex > -1) {
                            _this.objectiveGroupList[groupListIndex].baseItemList.splice(objectiveIndex, 1);
                            _.remove(_this.objectiveGroupList[groupListIndex].baseItemLinks, {baseItemId : payload.unLinkedObjective.id});
                            // _this.originalObjectiveGroupList = _.cloneDeep(_this.objectiveGroupList);
                            _this.originalObjectiveGroupList = kendisStore.getters.getOjectiveGroups();
                        }
                    }
                }*/
            }
        },
        onPushReceived: function (item){
            let _this = this;
            if (syncId !== item.metaMap.syncId && _this.board.session.id === item.metaMap.sessionId && _this.board.session.activeSessionBoard == _this.board.id){
                if (item.action === "createObjectiveGroup"){
                     _this.handlePushForGroupCreation(item);
                }else if (item.action === "impedimentAndActionPointCreate"){
                    _this.handlePushForObjAndOkrCreation(item);
                }else if (item.action === "impedimentAndActionPointUpdate"){
                    if (item.data.savedImpediment.type !== "Objective-Group" && item.data.changedFields.length > 0){
                        if (item.metaMap.groupId && _this.objOkrPopupContainerMap[item.metaMap.groupId] && _this.objOkrPopupContainerMap[item.metaMap.groupId].isPopupOpen && _this.objOkrPopupContainerMap[item.metaMap.groupId].itemTemplate.model.id === item.data.savedImpediment.id){
                            let message = '';
                            let fieldsLength = item.data.changedFields.length;
                            _.each(item.data.changedFields, (cf, cfIndex)=>{
                                message = message + cf;
                                if(cfIndex+1 < fieldsLength) {
                                    message = message + ", "
                                }
                                else {
                                    message = message + " "
                                }
                            });
                            if(!_.isEmpty(item.data.changedFields)) {
                                if (item.data.changedFields.length > 1){
                                    message = message + " have been updated.";
                                }else{
                                    message = message + " has been updated.";
                                }
                            }
                            askFromSweetAlertWrapper(message+' Clicking Yes will override the current content',
                                [_this.handlePushForEdit, item],
                                [takeNoAction]
                            );
                        }else{
                          _this.handlePushForEdit(item);
                        }
                    }else{
                        _this.handlePushForGroupEdit(item);
                    }
                }else if(item.action === "impedimentAndActionPointUpdate" && item.data.savedImpediment.type === "Objective-Group" && item.data.changedFields.length === 0){
                    _this.updateGroupBaseItemLinks(item.data.savedImpediment);
                }else if (item.action === "itemLinking"){
                    _this.handlePushForItemLinking(item);
                }else if (item.action === "removeLinkedItem"){
                    _this.handlePushForRemoveItemLinking(item);
                }else if (item.action === "deleteObjective"){
                    _this.handlePushForDelete(item);
                }else if (item.action === "linkToTeamAndGroups"){
                    let objectiveId = "";
                    if (item.data.linkedObjective){
                        objectiveId = item.data.linkedObjective.id;
                    }else{
                        objectiveId = item.data.unLinkedObjective.id;
                    }
                    if (item.metaMap.groupId && _this.objOkrPopupContainerMap[item.metaMap.groupId].isPopupOpen && _this.objOkrPopupContainerMap[item.metaMap.groupId].itemTemplate.model.id === objectiveId){
                       askFromSweetAlertWrapper('Teams of the current objective have been updated. Clicking "Yes" will override the current content',
                            [_this.handlePushForTeamLinking, item],
                            [takeNoAction]
                        );
                    }else{
                        _this.handlePushForTeamLinking(item);
                    }
                }else if (item.action === "updateObjectiveGroups"){
                    _this.handlePushForDraggableUpdates(item);
                }
                // this.originalObjectiveGroupList = kendisStore.getters.getOjectiveGroups();
            }
        },
        handlePushForGroupCreation: function (item){
            let _this = this;
            kendisStore.commit("addToGroup", item.data);
            this.menuComponentKey += 1;
            if (this.objectiveGroupList.length === 1){
                _this.$nextTick(()=>{
                    _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);
                });
            }
            let objGrpKeyMap = _.cloneDeep(kendisStore.getters.getObjectiveGroupKeyMap());
            let groupId = item.data.id;
            // objGrpKeyMap[groupId] = 0;
            Vue.set(objGrpKeyMap, groupId , 0);
            kendisStore.commit("setObjGrpKeyMap", objGrpKeyMap);
        },
        handlePushForObjAndOkrCreation: function (item){
            let storePayload = {};
            if (item.data.savedImpediment.type === "KR"){
                if (item.metaMap.objectiveId){
                    storePayload.objectiveId = item.metaMap.objectiveId;
                }
                if (item.metaMap.createOkrFromObjPopup){
                    storePayload.createOkrFromObjPopup = item.metaMap.createOkrFromObjPopup;
                }
                storePayload.okr = item.data.savedImpediment;
                storePayload.isPushCase = true;
                storePayload.isPushForSave = true;
                if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                    storePayload.isSearchEmpty = false;
                }
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }else{
                let objectiveGroupsList = kendisStore.getters.getOjectiveGroups();
                let objectiveGroup = _.find(objectiveGroupsList, {"id": item.metaMap.groupId});
                let objIndex = _.findIndex(objectiveGroup.baseItemList, {"id" : item.data.savedImpediment.id});
                if (objIndex === -1){
                    if (item.data.savedImpediment.type.includes("Objective") && _.isEmpty(item.data.savedImpediment.baseItemList)){
                        item.data.savedImpediment.baseItemList = [];
                    }
                    if (objectiveGroup.baseItemList){
                        objectiveGroup.baseItemList.push(item.data.savedImpediment);
                    }else{
                        objectiveGroup.baseItemList = [];
                        objectiveGroup.baseItemList.push(item.data.savedImpediment);
                    }
                    storePayload.group = objectiveGroup;
                    if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                        storePayload.isSearchEmpty = false;
                    }
                    kendisStore.commit("updateSingleGroup", storePayload)
                }
            }
        },
        handlePushForEdit: function (item){
            let storePayload = {};
            if (item.data.savedImpediment.type === "KR"){
                storePayload.objectiveId = item.metaMap.objectiveId;
                storePayload.okr = item.data.savedImpediment;
            }else{
                storePayload.objective = item.data.savedImpediment;
            }
            storePayload.isPushCase = true;
            storePayload.isPushForEdit = true;
            if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                storePayload.isSearchEmpty = false;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
        },
        handlePushForGroupEdit: function (item){
            let storePayload = {};
            if (item.data.savedImpediment.type === "Objective-Group"){
                storePayload.group = item.data.savedImpediment;
                storePayload.isPushForGroupEdit = true;
                if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                    storePayload.isSearchEmpty = false;
                }
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
        },
        handlePushForItemLinking: function (item){
            let storePayload = {};
            if (item.data.savedImpediment.type === "KR"){
                storePayload.objectiveId = item.metaMap.objectiveId;
                storePayload.okr = item.data.savedImpediment;
                storePayload.linkedItems = item.data.linkedItems;
            }else{
                storePayload.objective = item.data.savedImpediment;
                storePayload.linkedItems = item.data.linkedItems;
            }
            storePayload.isPushCase = true;
            storePayload.isPushForItemLinking = true;
            if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                storePayload.isSearchEmpty = false;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
        },
        handlePushForRemoveItemLinking: function (item){
            let storePayload = {};
            if (item.data.savedImpediment.type === "KR"){
                storePayload.objectiveId = item.metaMap.objectiveId;
                storePayload.okr = item.data.savedImpediment;
                storePayload.linkedItemToRemove = item.data.linkedItemToRemove;
            }else{
                storePayload.objective = item.data.savedImpediment;
                storePayload.linkedItemToRemove = item.data.linkedItemToRemove;
            }
            storePayload.isPushCase = true;
            storePayload.isPushForRemoveItemLinking = true;
            if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                storePayload.isSearchEmpty = false;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
        },
        handlePushForDelete: function (item){
            let storePayload = {};
            if (item.data.deletedItem.type === "KR"){
                storePayload.objectiveId = item.data.parentItem.id;
                storePayload.okr = item.data.deletedItem;
                if (item.metaMap.createOkrFromObjPopup){
                    storePayload.createOkrFromObjPopup = item.metaMap.createOkrFromObjPopup;
                }
            }else if (item.data.deletedItem.type === "Objective-Committed" || item.data.deletedItem.type === "Objective-Uncommitted"){
                // storePayload.groupId = item.data.parentItem.id;
                storePayload.objective = item.data.deletedItem;
            }else{
                storePayload.group = item.data.deletedItem;
            }
            storePayload.isPushCase = true;
            storePayload.isPushForDelete = true;
            if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                storePayload.isSearchEmpty = false;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            this.menuComponentKey += 1;
            },
        handlePushForTeamLinking: function(item) {
          let storePayload = {};
          if (item.data.linkedGroup){
            storePayload.linkedGroup = item.data.linkedGroup;
            storePayload.linkedObjective = item.data.linkedObjective;
          }else{
             storePayload.unLinkedGroup = item.data.unLinkedGroup;
             storePayload.unLinkedObjective = item.data.unLinkedObjective;
          }
          storePayload.teamsAndGroups = item.data.teamsAndGroups;
          storePayload.isPushForTeamLinking = true;
          if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                storePayload.isSearchEmpty = false;
            }
          kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
        },
        handlePushForDraggableUpdates : function (item){
            let storePayload = {
                fromGroup                 : item.data.fromGroup,
                toGroup                   : item.data.toGroup,
                movedObjId                : item.data.movedObjId,
                isPushForDraggableUpdates : true
            };
            if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                storePayload.isSearchEmpty = false;
            }
            kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
        },
        updateGroupBaseItemLinks: function (group){
            let storePayload = {};
            let groupList = kendisStore.getters.getOjectiveGroups();
            let groupIndex = _.findIndex(groupList, {id : group.id});
            if (groupIndex > -1){
                groupList[groupIndex].baseItemLinks = group.baseItemLinks;
                storePayload.group = groupList[groupIndex];
                if (this.$refs['obj-menu'] && !_.isEmpty(this.$refs['obj-menu'].searchQuery)){
                        storePayload.isSearchEmpty = false;
                    }
                kendisStore.commit("updateSingleGroup", storePayload);
            }
        },
        fetchExcludedItems: function () {
            let _this = this;
            let excludedItemsData = {};

            let requestBody = {};
            requestBody["sessionId"] = _this.board.session.id;
            requestBody["viewType"] = VIEW_NAME_ENUM.OBJECTIVES_EXCLUDEITEMS_VIEWTYPE.code;

            axios.post('/plan/fetch-excluded-items', requestBody)
                .then(response => {
                    if (response.status === 200 && response && response.data && !response.data.error) {
                        excludedItemsData = response.data.statsExclusion.excludedItems;
                        kendisStore.commit('setExcludeItemsData', excludedItemsData);
                    }
                })
                .catch(error => {
                    console.error("Error while fetching excluded items from DB: ", error);

                });

        },
        toggleExpand: function(option) {
			let _this = this;
            _.each(this.objectiveGroupList, function(obj) {
                obj.expand = option;
            });
            this.updateReRenderKey(this.generateRandomKey());
			_this.$nextTick(()=>{
	            _this.createDynamicSortableInstance('objectivesRef', 'draggableElement', _this.backlogSortableOptions);							
			})

        },

        filterArray: function (array, searchTerm) {
            let _this = this;
            searchTerm = searchTerm.toLowerCase();
            const filteredArray = array.filter((group) => {
                // Highlight matched titles and linked items
                if(group.baseItemList) {
                    group.baseItemList.forEach((obj) => {
                        obj.highlightedTitle = _this.highlightText(obj.title, searchTerm);
                        obj.highlightedKey   = _this.highlightText(obj.key, searchTerm);
                        if (obj.baseItemList && obj.baseItemList.length > 0) {
                            _.each(obj.baseItemList, function (okr) {
                                okr.highlightedTitle = _this.highlightText(okr.title, searchTerm);
                                okr.highlightedKey   = _this.highlightText(okr.key, searchTerm);
                            });
                        }
                        if(obj.linkedItems && obj.linkedItems.length > 0) {
                            _.each(obj.linkedItems, function (item) {
                                item.highlightedTitle = _this.highlightText(item.title, searchTerm);
                                if(item.jiraKey !== undefined && item.jiraKey !== null) {
                                    item.highlightedKey = _this.highlightText(item.jiraKey, searchTerm);
                                } else if(item.kendisKey !== undefined && item.kendisKey !== null) {
                                    item.highlightedKey = _this.highlightText(item.kendisKey, searchTerm);
                                } else if(item.tfsId !== undefined && item.tfsId !== null) {
                                    item.highlightedKey = _this.highlightText(item.tfsId, searchTerm);
                                }
                            });
                        }
                    });
                }

                // Check if search term is in base items or linked items
                return group.title.toLowerCase().includes(searchTerm) ||
                    (group.baseItemList && group.baseItemList.some((objective) => {
                        if (objective.linkedItems) {
                            return objective.linkedItems.some((linkedItem) => (
                                _this.verifyItemsToExclude(linkedItem, _this.excludeItemsData) && linkedItem.title.toLowerCase().includes(searchTerm) ||
                                (linkedItem.jiraKey ? linkedItem.jiraKey.toLowerCase().includes(searchTerm) : false ||
                                linkedItem.tfsId ? linkedItem.tfsId.toLowerCase().includes(searchTerm) : false ||
                                linkedItem.kendisKey ? linkedItem.kendisKey.toLowerCase().includes(searchTerm) : false)
                            ))
                        } else {
                            return false;
                        }
                    })) ||
                    (group.baseItemList && group.baseItemList.some((obj) =>
                        obj.title.toLowerCase().includes(searchTerm) ||
                        obj.key.toLowerCase().includes(searchTerm) ||
                        (obj.baseItemList && obj.baseItemList.some((_okr) => _okr.title.toLowerCase().includes(searchTerm) || _okr.key.toLowerCase().includes(searchTerm)))
                    ));
            });

            if (searchTerm === '') {
                return array;
            } else if (filteredArray.length === 0) {
                return [];
            } else {
                return filteredArray;
            }
        },
        highlightText: function (text, searchTerm) {
            const searchTermEscaped = searchTerm.replace(/[()\\]/g, '\\$&');
            const regex = new RegExp(`(${searchTermEscaped})`, 'gi');
            return text.replace(regex, '<b style="background-color: yellow">$1</b>');
        },
        createDynamicSortableInstance: function(ref, element, config) {
            let _this = this;
            if(typeof objectivesRtVU != "undefined") {
	            if (objectivesRtVU.$refs[ref]){
	               const draggableElement = objectivesRtVU.$refs[ref].$refs[element];
	                if(draggableElement) {
	                    _this.sortableInstance = Sortable.create(draggableElement, config);
	                }
	            }
			}else if(typeof vueInstance != "undefined") {
	            if (vueInstance.$refs[ref]){
	               const draggableElement = vueInstance.$refs[ref].$refs[element];
	                if(draggableElement) {
	                    _this.sortableInstance = Sortable.create(draggableElement, config);
	                }
	            }
			} else if(typeof objectivesVU != "undefined") {
	            if (objectivesVU.$refs[ref]){
                    let draggableElement = null;
                    if (this.activeCustomView && this.activeCustomView.id === "-1") {
                        draggableElement = objectivesVU.$refs[ref].$refs[ref].$refs[element];
                    } else {
                        draggableElement = objectivesVU.$refs[ref].$refs[element]
                    }
                    if (!draggableElement) {
                        draggableElement = _this.$refs[element];
                    }
	                if(draggableElement) {
	                    _this.sortableInstance = Sortable.create(draggableElement, config);
	                }
	            }				
			}
        },
        openLinkedObjFromOtherGroup: function (linkedObj, groupId){
            let _this = this;
            if (_this.$refs["objectiveGroup-" + groupId] &&  _this.$refs["objectiveGroup-" + groupId][0].$refs["row_" + linkedObj.id]){
                _this.$refs["objectiveGroup-" + groupId][0].$refs["row_" + linkedObj.id][0].openModalForEditing(linkedObj);
            }
        },
        closeCustomObjectiveView: function (){
            if(this.addCustomFormCounter > 0){
			    this.addCustomFormCounter--;
            }
            if (this.objectiveGroupList.length === 0 && this.isMockingMode && this.addCustomFormCounter == 0 && !this.isObjectiveFiltersApplied){
                this.showObjectiveBanner = true;
            }
        },
        fetchPrioritizedObjectives: function(sessionId) {
			let _this = this;
            let isObjectiveListingView = false;
			axios.get('objective/fetch-prioritized/' + sessionId + '/' + isObjectiveListingView)
			.then(response=>{
                if (response.data && !_.isEmpty(response.data.objectiveGroupList)){
                    _this.prioritizedOkrs = response.data.objectiveGroupList;

                    _.each(_this.prioritizedOkrs, objGrp=>{
                        let localStorageExpandValue = localStorage.getItem('objective_expand_' + sessionId + '_' + objGrp.id);
                        objGrp.expand = JSON.parse(localStorageExpandValue) === true;
                        objGrp.isPrioritizedOkr = true;
                    });
                }
                if (response.data && !_.isEmpty(response.data.objectives)){
					_this.prioritizedOkrGroup.id = "-1";
					_this.prioritizedOkrGroup.title = "List of OKRs";
					_this.prioritizedOkrGroup.baseItemList = response.data.objectives; 
					_this.prioritizedOkrGroup.isPrioritizedOkr = true;
                    let localStorageExpandValue = localStorage.getItem('objective_expand_' + sessionId + '_' + _this.prioritizedOkrGroup.id);
                    _this.prioritizedOkrGroup.expand = JSON.parse(localStorageExpandValue) === true;
                }
			})
			.catch(error=>{
                console.error("Error fetching prioritized objectives.", error);
			})
		},
		getDummyBoard: function(entityId) {
            let dummyBoard = {};
            dummyBoard.teams = [];
            dummyBoard.session = {
                id: entityId,
                uncommittedObjEnabled: false,
            };
            return dummyBoard;
        },
		fetchCompletion: function() {
			let _this = this;
			let requestBody = {};
			requestBody.sessionId = _this.board.session.id;
			requestBody.groupIds = _this.groupsForCalculation;
			axios.post('objective/calculate-progress-for-select-groups',requestBody)
			.then(response=>{
				if(response && response.data && response.data.completionById) {
					let completionsMap = response.data.completionById;
					let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
					Object.assign(completionsMap, savedCompletionMap);
					kendisStore.commit("setOkrCompletionMap", completionsMap);
				}
			})
			.catch(error=>{
				console.error(error);
			});
			_this.groupsForCalculation = [];			
		},
		onVisiblityChange: function(isVisible, entry, objectiveGroup) {
			this.visibleGroupsMapById[objectiveGroup.id] = isVisible;
			let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
			if(isVisible && this.isMockingMode && typeof savedCompletionMap[objectiveGroup.id] == "undefined") {
				this.groupsForCalculation.push(objectiveGroup.id);
			}
		},
		scrolling: function() {
			let _this = this;
			if(this.isMockingMode) {
				_this.isScrolling = true;
				window.clearTimeout(isScrolling);
				isScrolling = setTimeout(() => {
			        _this.isScrolling = false;
					let savedCompletionMap = kendisStore.getters.getOkrCompletionMap();
					_this.groupsForCalculation = Object.keys(_this.visibleGroupsMapById).filter(key => (_this.visibleGroupsMapById[key] && typeof savedCompletionMap[key]== 'undefined'))
					if(!_.isEmpty(_this.groupsForCalculation)) {
						_this.fetchCompletion();
					}
					window.clearTimeout(isScrolling);
				}, 3000);
			}
		},
		resizableCheckIn: function() {
			$(document).ready(function() {
				$("#check-ins").resizable({
					handles : 'w',
					//minWidth: window.innerWidth/2.33,
					maxWidth: window.innerWidth/2,
				});
			});			
			//console.log("Haha");
		},
		updateKrTemplate: function() {
			let _this = this;
			axios.patch('objective/update-kr-template')
			.then(response=>{
				if(response.data && response.data.startField) {
					let krTemplate = kendisStore.getters.getOkrTemplate();
					krTemplate.scheme.fieldsTemplate.configuredFields[1].groupFields.splice(1,0,response.data.startField);
					kendisStore.commit("setOkrTemplate", krTemplate);
				}
			})
			.catch(error=>{
				console.error(error);
			})
		},
        updateObjectiveWorkspace: function (workSpace){
            let _this = this;
            if (_this.isMockingMode) {
                kendisStore.commit("setObjectiveWorkspace", workSpace);
                for (let key in localStorage) {
                    if (key.includes("Objective_Backlog_Columns")) {
                        localStorage.removeItem(key);
                    }
                }
                _.each(_this.objectiveGroupList, objGrp => {
                    _this.objectiveGrpKeyMap[objGrp.id] += 1;
                });
                kendisStore.commit("setObjGrpKeyMap", _this.objectiveGrpKeyMap);
            }
		},
        openThemeProgressPopup(){
            this.showObjectiveThemeProgress = true;
        },
        closeThemeProgress(){
            this.showObjectiveThemeProgress = false;
        },
        updateCompletionCriteria(newVal){
            this.completionCriteria = newVal;
        },
        updateCustomViewSettings(customView) {
            if (this.isMockingMode && !this.isArt) {
                this.activeCustomView.columnSettings = customView.columnSettings;

                _.each(this.objectiveGroupList, objGrp => {
                    this.objectiveGrpKeyMap[objGrp.id] += 1;
                });

                kendisStore.commit("setObjGrpKeyMap", this.objectiveGrpKeyMap);
            }
        },
        showStrategicThemes(mode) {
            this.$emit("showCustomViews", mode);
        }
    }
});
