const LINK_TARGET_POPUP = {
	name: 'link-target-popup',
	props: {
		sourceItem: {
			type: Object,
			default: () => { return {} }
		},
		boards: {
			type: Array,
			default: () => { return [] }
		},
		linkTypeOptions: {
			type: Array,
			default: () => { return [] }
		},
		epics: {
			type: Array,
			default: () => { return [] }			
		},
		heading: {
			type: String,
			default: () => { return '' }
		},
		selectedBoardId: {
			type: String,
			default: () => { return '' }
		},		
		type: {
			type: String,
			default: () => { return 'Feature' }			
		},
		showBoardList: {
			type: Boolean,
			default: () => { return true }
		},		
		showSprint: {
			type: Boolean,
			default: () => { return true }
		},
		showItemType: {
			type: Boolean,
			default: () => { return true }
		},
		showLinkTypeDropdown: {
			type: Boolean,
			default: () => { return false }			
		},
		multiple: {
			type: Boolean,
			default: () => { return true }
		},
		groupByOrphanFeatures: {
			type: Boolean,
			default: () => { return false }			
		}
	},
	template: '#link-target-popup-temp',
	data: function () {
		return {
			selectedBoard: undefined,
			selectedSprint: "-1",
			selectedItemType: "Feature",
			boardOptions: {},
			items: [],
			itemsGroup: {},
			selectedItemsMap: {},
			searchQuery: "",
			linkType: {},
			linkTypeError:  false
		}
	},
	computed: {

	},
	components: {

	},
	created() {
		this.getJiraUrlOfItem = vueInstance.getJiraUrlOfItem;
		var boardOptions = [];
		_.each(this.boards, board => {
			boardOptions.push({ id: board.id, title: board.session.title });
		});
		this.boardOptions = boardOptions;

		this.selectedBoard = this.boardOptions[0];

		var _this = this;
		if(_this.selectedBoardId != "") {
			this.selectedBoard = _.find(this.boards, b => {
				return b.id == _this.selectedBoardId;
			});			
		}
		else {
			this.selectedBoard = _.find(this.boards, b => {
				return b.id == _this.boardOptions[0].id;
			});
		}
		var itemType = localStorage.getItem("link-target-item-type");
		if (!_.isEmpty(itemType) && (itemType === "Feature" || itemType === "Epic")) {
			this.selectedItemType = itemType;
		} else {
			this.selectedItemType = "Feature";
		}
		this.filterItems();
	},
	methods: {
		////////////////////////////////////
		///////////   LOGIC   //////////////
		////////////////////////////////////
		filterItems: function () {

			var _this = this;
			var items = [];

			var tempMap = {};
			_this.itemsGroup = {};
			if(_this.type != "Epic") { 
				if (_this.selectedBoard && _this.selectedBoard != undefined) {
					_.each(_this.selectedBoard.containers, sprint => {
	
						if (_this.selectedSprint == "-1" || _this.selectedSprint == sprint.id) {
	
							if (this.selectedItemType === 'Epic') {
								_.each(sprint.plannedEpics, ic => {
	
									if (!tempMap[ic.item.id] && ic.item.id != '-1' && ic.item.id != _this.sourceItem.id) {
										var _item = {};
	
										tempMap[ic.item.id] = true;
	
										_item.show = true;
										_item.id = ic.item.id;
										_item.title = ic.item.title;
										_item.type = ic.item.type;
	
										_item.tfsId = ic.item.tfsId;
										_item.tfsURL = ic.item.tfsURL;
										_item.jiraKey = ic.item.jiraKey;
										_item.kendisKey = ic.item.kendisKey;
										_item.externalReferenceURL = ic.item.externalReferenceURL;
	
										_item.containerId = sprint.id;
										_item.selected = _this.selectedItemsMap[_item.id] ? true : false;
										_item.sessionId = _this.selectedBoard.session.id;
										
										items.push(_item);
									}
								});
							} else {
								var orphanFeatureIdsMap = {};
								if(_this.groupByOrphanFeatures) {
									_.each(sprint.plannedEpics, ep=>{
										if(ep.item && ep.item.id == "-1") {
											_.each(ep.subItems, ic=>{ 
												var _item = {};
			
												_item.show = true;
												_item.id = ic.id;
												_item.title = ic.title;
												_item.type = ic.type;
												
												_item.tfsId = ic.tfsId;
												_item.tfsURL = ic.tfsURL;
												_item.jiraKey = ic.jiraKey;
												_item.kendisKey = ic.kendisKey;
												_item.externalReferenceURL = ic.externalReferenceURL;
												
												_item.containerId = sprint.id;
												_item.selected = _this.selectedItemsMap[_item.id] ? true : false;
												_item.sessionId = _this.selectedBoard.session.id;
												_item.sessionBoardId = ic.sessionBoards[0].id;
												
												if(!_this.itemsGroup['Features without Parent Epics']) {
													_this.itemsGroup['Features without Parent Epics'] = [];
												}
												_this.itemsGroup['Features without Parent Epics'].push(_item);
												orphanFeatureIdsMap[ic.id] = _item;
												items.push(_item);
											});
										}
									});
									_.each(sprint.plannedFeatures, ic=>{
										if(!orphanFeatureIdsMap[ic.item.id]) {
											var _item = {};
		
											_item.show = true;
											_item.id = ic.item.id;
											_item.title = ic.item.title;
											_item.type = ic.item.type;
		
											_item.tfsId = ic.item.tfsId;
											_item.tfsURL = ic.item.tfsURL;
											_item.jiraKey = ic.item.jiraKey;
											_item.kendisKey = ic.item.kendisKey;
											_item.externalReferenceURL = ic.item.externalReferenceURL;
		
											_item.containerId = sprint.id;
											_item.selected = _this.selectedItemsMap[_item.id] ? true : false;
											_item.sessionId = _this.selectedBoard.session.id;
											_item.sessionBoardId = ic.item.sessionBoards[0].id;
											
											if(!_this.itemsGroup['Features with Parent Epic']) {
												_this.itemsGroup['Features with Parent Epic'] = [];													
											}
											_this.itemsGroup['Features with Parent Epic'].push(_item);
											items.push(_item);
										}
									})
								}
								else {
									_.each(sprint.plannedFeatures, ic => {		
										if (ic.item.id != _this.sourceItem.id) {
											var _item = {};
		
											_item.show = true;
											_item.id = ic.item.id;
											_item.title = ic.item.title;
											_item.type = ic.item.type;
		
											_item.tfsId = ic.item.tfsId;
											_item.tfsURL = ic.item.tfsURL;
											_item.jiraKey = ic.item.jiraKey;
											_item.kendisKey = ic.item.kendisKey;
											_item.externalReferenceURL = ic.item.externalReferenceURL;
		
											_item.containerId = sprint.id;
											_item.selected = _this.selectedItemsMap[_item.id] ? true : false;
											_item.sessionId = _this.selectedBoard.session.id;
											_item.sessionBoardId = ic.item.sessionBoards[0].id;
		
											items.push(_item);
										}
									});
								}
							}								
						}
					});
				}
			}
			else {
				_.each(_this.epics, ic => {
					var _item = {};
					_item = _.cloneDeep(ic);
					_item.show = true;
					tempMap[ic.id] = true;
					_item.show = true;
					items.push(_item);
				});
			}
			_this.items = items;
			if (!_.isEmpty(_this.searchQuery)) {
				_this.searchItems();
			}
		},
		searchItems: function () {
			var _this = this;
			var searchQuery = "";
			if (!_.isEmpty(_this.searchQuery)) {
				searchQuery = _this.searchQuery.toLowerCase();
			}
			_.each(this.items, item => {
				item.show = vueInstance.validateItemForQuery(item, searchQuery);
			});
		},
		////////////////////////////////////
		///////////   EVENTS  //////////////
		////////////////////////////////////
		onClickCancel: function () {
			this.$emit('close');
		},
		onClickSave: function () {

			var _this = this;
			var requestBody = {};
			var keys = Object.keys(_this.selectedItemsMap);
			if (_.isEmpty(keys)) {

			} else {
				var targets = [];
				_.each(keys, key => {
					targets.push(_this.selectedItemsMap[key]);
				});
				if(_this.showLinkTypeDropdown) {
					requestBody.linkType = _this.linkType;
				}
				requestBody.items = targets;				
				_this.$emit("save", requestBody);
			}
		},
		onSelectBoard: function (board) {
			this.selectedBoard = _.find(this.boards, b => {
				return b.id == board.id;
			});
			this.filterItems();
		},
		onSelectItemType: function () {
			localStorage.setItem("link-target-item-type", this.selectedItemType);
			this.filterItems();
		},
		onSelectSprint: function () {
			this.filterItems();
		},
		onSelectItem: function (item) {
			var _this = this;
			if(_this.multiple) {
				if (this.selectedItemsMap[item.id]) {
					delete this.selectedItemsMap[item.id];
					item.selected = false;
				} else {
					var items = Object.keys(this.selectedItemsMap);
					if (items.length < 5) {
						this.selectedItemsMap[item.id] = item;
						item.selected = true;
					} else {
						showTopMessage("You can add maximum 5 receivers", "warning");
					}
				}
			}
			else {
				if (this.selectedItemsMap[item.id]) {
					delete this.selectedItemsMap[item.id];
					item.selected = false;
				} else {
					this.selectedItemsMap[item.id] = {};
					this.selectedItemsMap[item.id] = item;
					item.selected = true;
				}				
			}
		},
		//..................
		onChangeSeachQuery: function () {
			this.searchItems();
		}
	},
}
