function GET_IMPEDIMENT_LINKED_ITEMS_TEMPLATE() {
return Vue.component('impediment_linked_items', {
	template: `
		<div>
			<template v-if="showProgress">
				<div class="achivt prog_1 prg">
					<label>Completion</label>
					<div><span
							:style="{width: completion[byTypePopup.selectedOption.id] +'%'}"></span>
					</div>
					<strong>{{completion[byTypePopup.selectedOption.id]+'%'}}</strong>
				</div>		
				<div class="selectcont olnk" v-if="risk.linkedItems && risk.linkedItems.length > 0">
					<button type="button" class="ui-multiselect ui-widget ui-state-default ui-corner-all"
						aria-haspopup="true" style="width: 265px;" @click="onClickByType">
						<span
							class="ui-icon ui-icon-triangle-2-n-s"></span><span>{{"% By " +  byTypePopup.selectedOption.title}}</span>
					</button>
	
					<vuepopup v-if="byTypePopup.show" @close="byTypePopup.show = false;">
						<div class="ui-multiselect-menu ui-widget ui-widget-content ui-corner-all ui-multiselect-single"
							style="width: 100px; display:block">
							<ul class="ui-multiselect-checkboxes ui-helper-reset">
								<li v-for="option in byTypePopup.options" class=" "><label title=""
										class="ui-corner-all"
										:class="[byTypePopup.selectedOption.id == option.id ? 'ui-state-active' : '']"><input
											name="multiselect_o-linkType" type="radio" :value="option.id"
											:title="option.title"
											:checked="byTypePopup.selectedOption.id == option.id"
											@click="onChangeByTypeDropdown(option)"><span
											class="lbl">{{option.title}}</span></label></li>
							</ul>
						</div>
					</vuepopup>
				</div>
			</template>		

			<ul class="table inn">
				<template v-for="item in risk.linkedItems">
					<li v-if="isBoardToGroup(item)" class="rec hd" :id="'linked_items_board_'+(item.sessionBoards && item.sessionBoards[0] && item.sessionBoards[0].session ? item.sessionBoards[0].session.id : '')" style="background-color:#F1F4F8;">
						<div class="rc c2">{{ item.sessionBoards ? item.sessionBoards[0].session.title : '' }}</div>
					</li>
					<li class="rec" :class="[(isCurrentSessionItem(item) ? '' : 'disabled')]"
						:data-sb="item.sessionBoards && item.sessionBoards[0] && item.sessionBoards[0].session ? item.sessionBoards[0].session.id : ''"
						:data-stitle="item.sessionBoards ? item.sessionBoards[0].session.title : ''">
						
						
						<a v-if="item.jiraKey" 	 :class="itemIcon(item)" target="_blank" :href="item.jiraURL ? item.jiraURL : item.externalReferenceURL " class="rc c1">{{item.jiraKey }}</a>
						<a v-if="item.kendisKey" :class="itemIcon(item)" target="_blank" :href="item.externalReferenceURL " class="rc c1">{{item.kendisKey }}</a>
						<template v-if="item.tfsId">
							<img v-if="item.tfsItemTypeIcon"  :src="item.tfsItemTypeIcon" class="azurico" alt="Azure" /> 																			
							<a target="_blank" :href="item.tfsURL" class="rc c1">{{ item.tfsId }}</a>
						</template>
								
						<div class="rc c2">{{ item.title }}</div> <!-- <div class="rc c3">{{ item.status.color }}</div> -->
						<div class="rc c3 status">
							<span v-if="item.status" :class="{'sts a':item.status.category === 'ToDo', 'sts b':item.status.category === 'InProgress', 'sts c':item.status.category === 'Done','sts d':item.status.category === 'Misc',}">{{ item.status.title }}</span>
						</div>
						<div class="rc c4 spctg">
							<span>{{ item.storyPoints }}</span>
						</div>
						<div class="r-icons">
							<a v-if="linkUnlinkPermission && !boardId" @click="removeLinkedItem(item)" class="ico ti-close" title="Unlink Item" href="javascript:void(0);"></a>
							<a v-else-if="linkUnlinkPermission && isCurrentSessionItem(item)" @click="removeLinkedItem(item)" class="ico ti-close" title="Unlink Item" href="javascript:void(0);"></a>
						</div>
					</li>
				</template>
				<template v-if="!_.isEmpty(risk.linkedItemsById)">
					<template v-for="(item,val) in risk.linkedItemsById">
						<li v-if="isBoardToGroup(item,2)" class="rec hd" :id="'linked_items_board_'+(item.session_id ? item.session_id : '')" style="background-color:#F1F4F8;">
							<div class="rc c2">{{ item.session_title ? item.session_title : '' }}</div>
						</li>
						<li class="rec" :class="[(isCurrentSessionItem(item) ? '' : 'disabled')]" :data-sb="item.session_id ? item.session_id : ''"	:data-stitle="item.session_title ? item.session_title : ''">
							<div class="rc c1 delwgt">
								<a target="_blank" :href="item.externalReferenceURL">{{item.key }}</a>
							</div>
							<div style="border:0;font-style: italic;" class="rc c2">Item does't exist on the board 1</div>
							<div class="r-icons" v-if="editPermission && isCurrentSessionItem(item)">
								<a @click="removeLinkedExternalItemId(val, item)" title="Unlink Item" href="javascript:void(0);" class="ico ti-close"></a>
							</div>
						</li>
					</template>
				</template>
			</ul>
		</div>	
	`,
	props: ["risk", "boardId", "sessionId", "showProgress", "editPermission", "linkUnlinkPermission"],
	data: function () {
		return { 
			boardMap: {},
			byTypePopup : {
				show : false,
				options : [
					{title:"Linked Items Status",id:1},
					{title:"Children of Linked Items (Stories) - Status",id:2},
					{title:"Children of Linked Items (Stories) - Estimate",id:3},
					{title:"Team Stories - Status",id:4},
					{title:"Team Stories - Estimate",id:5}
				],
				selectedOption : {id:1,title:"Linked Items Status"},
			},			
		}
	},
	components: {},
	computed: {
		itemIcon: function() {
			return function(item) {
				return getItemIcon(item);
			}
		},
		initRisk: function () {
			return function (num) {
				this.boardMap = {};
				return true;
			};
		},
		isCurrentSessionItem: function () {
			return function (item) {
				if (item.sessionBoard_id != undefined && item.sessionBoards == undefined) {
					item.sessionBoards = [{ id: item.sessionBoard_id, session: { id: item.session_id } }];
				}

				if (item.session_id != undefined && item.sessionBoards[0].session == undefined) {
					item.sessionBoards[0].session = { id: item.session_id };
				}

				if (this.boardId) {
					var ret = item.sessionBoards[0].id === this.boardId;
					if (ret) {
						if (item.sessionBoard_id && this.risk.activeBoardIds && !this.risk.activeBoardIds[this.boardId]) {
							return false;
						}
						return true;
					} else if (item.sessionBoard_id != undefined && this.sessionId && item.sessionBoards[0].session.id === this.sessionId) {
						if (this.risk.activeBoardIds && !this.risk.activeBoardIds[this.boardId]) {
							return false;
						} else {
							return true;
						}
					} else {
						return false;
					}
				} else {
					return true;
				}
			};
		},
		isBoardToGroup: function () {
			return function (item) {
				if (item.session_id != undefined && item.sessionBoards == undefined) {
					item.sessionBoards = [{ id: item.sessionBoard_id, session: { id: item.session_id } }];
				}

				if (this.risk.linkedItemsById != undefined) {
					delete this.risk.linkedItemsById[item.id];
				}

				if (item.session_id != undefined && item.sessionBoards[0].session == undefined) {
					item.sessionBoards[0].session = { id: item.session_id };
				}

				if (this.boardMap[item.sessionBoards[0].session.id] == undefined) {
					this.boardMap[item.sessionBoards[0].session.id] = item.sessionBoards[0].session;
					return true;
				} else {
					return false;
				}
			};
		},
		completion: function() {

			var _this = this;

			//............................................
			var totalCount1 = 0;
			var totalCount2 = 0;
			var totalCount3 = 0;
			var totalCount4 = 0;
			var totalCount5 = 0;

			var doneCount1 = 0;
			var doneCount2 = 0;
			var doneCount3 = 0;
			var doneCount4 = 0;
			var doneCount5 = 0;
			//............................................

			if (_this.risk && !_.isEmpty(_this.risk.linkedItems)) {
				//....................................................

				_.each(_this.risk.linkedItems, item => {

					if (item) {

						var isValidParent = true;
						if (isValidParent) {
							//....................................................
							// by card type
							if (item.status && item.status.category === "Done") {
								doneCount1++;
							}
							totalCount1++;
							// by linked item status
							var childs = item.subItems;
							if (item.type === 'Feature') {
								if (!_.isEmpty(childs)) {
									_.each(childs, child => {

										var isValidChild = true;
										if (item.teamId) {
											var existInTeam;
											if (!_.isEmpty(child.teamContainers)) {
												var existInTeam = _.find(child.teamContainers, function(tc) { return tc.team.id === items.teamId });
											}
											if (!existInTeam) {
												isValidChild = false;
											}
										}

										if (child.status && child.status.category === "Done") {
											doneCount2++;
											doneCount3 += child.storyPoints ? child.storyPoints : 0;
											if (isValidChild) {
												doneCount4++;
												doneCount5 += child.storyPoints ? child.storyPoints : 0;
											}
										}
										totalCount2++;
										totalCount3 += child.storyPoints ? child.storyPoints : 0;
										if (isValidChild) {
											totalCount4++;
											totalCount5 += child.storyPoints ? child.storyPoints : 0;
										}
									});
								}
							}
							else {
								if (item.status && item.status.category === "Done") {
									doneCount2++;
									doneCount3 += item.storyPoints ? item.storyPoints : 0;

									doneCount4++;
									doneCount5 += item.storyPoints ? item.storyPoints : 0;
								}
								totalCount2++;
								totalCount3 += item.storyPoints ? item.storyPoints : 0;

								totalCount4++;
								totalCount5 += item.storyPoints ? item.storyPoints : 0;
							}
						}

					}

				});
			}

			//..........................................................
			//....................................................

			var completion = [];

			//..............................
			//..............................
			if (totalCount1 > 0) {
				completion[1] = Math.trunc((doneCount1 / totalCount1) * 100);
			}
			else {
				completion[1] = 0;				
			}
			//..............................
			if (totalCount2 > 0) {
				completion[2] = Math.trunc((doneCount2 / totalCount2) * 100);
			}
			else {
				completion[2] = 0;				
			}			
			//..............................
			if (totalCount3 > 0) {
				completion[3] = Math.trunc((doneCount3 / totalCount3) * 100);
			}
			else {
				completion[3] = 0;				
			}			
			//..............................
			if (totalCount4 > 0) {
				completion[4] = Math.trunc((doneCount4 / totalCount4) * 100);
			}
			else {
				completion[4] = 0;				
			}			
			//..............................
			if (totalCount5 > 0) {
				completion[5] = Math.trunc((doneCount5 / totalCount5) * 100);
			}
			else {
				completion[5] = 0;				
			}
			return completion;
		},		
	},
	beforeCreate: function () {

	},
	created: function () {
		this.boardMap = {};
	},
	mounted: function () {
		var $el = $(this.$el);

		this.$nextTick(() => {
			if (this.boardMap) {
				var id = '', i = 0;
				for (bid in this.boardMap) {
					$el.find('[data-sb="' + bid + '"]').insertAfter('#linked_items_board_' + bid);
					id = bid;
					i++;
				}
		
			}
		});
	},
	methods: {
		removeLinkedItem: function (item) {
			this.$emit('remove-item-link', item, this.risk);
		},
		/*removeLinkedExternalItemIdAction: function (itemId) {
			askFromSweetAlertWrapper("Are you sure to unlink this Item ?",
				[this.removeLinkedExternalItemId, itemId],
				[takeNoAction]);


		},*/
		removeLinkedExternalItemId: function (itemId) {
			var _this = this;
			var item = {};
			item.id = itemId;
			item.isDeletedItem = true;
			_this.$emit('remove-item-link', item, _this.risk);			
			/*axios.get('/riskregister/delete-lost-link/' + this.risk.id + '/' + itemId)
				.then(response => {
					if (response.data) {
						if (_this.risk.linkedItemsIds) {
							var index = _this.risk.linkedItemsIds.indexOf(response.data);
							if (index > -1) {
								_this.risk.linkedItemsIds.splice(index, 1);
							}
						}
						delete _this.risk.linkedItemsById[response.data];
						if (_this.risk.showLinkedItems === undefined) {
							_this.$parent.needUpdate = true;
							_this.$parent.showItemsTab = false;
							this.$nextTick(() => {
								_this.$parent.showItemsTab = true;
							});
						} else {
							_this.risk.showLinkedItems = false;
							this.$nextTick(() => {
								_this.risk.showLinkedItems = true;
							});
						}
					}
				})
				.catch(error => {
					handleSoSErrorMsg(error);
				});*/

		},
		onClickByType : function () {
			this.byTypePopup.show = true;
		},
		onChangeByTypeDropdown : function (value) {			
			this.byTypePopup.selectedOption = value;
			this.byTypePopup.show = false;
		},		

	}
});
}