var vueInstance;
function initializeVueInstance(){
	
var app = new Vue({
  el: '#app',
  data: {
    selectedNodes: {},
    shapeToDraw : "Rectangle",
    actionType : "none",
    subActionType: "none"
  },
  mounted() {
	  vueInstance = this;
  },
  methods: {
	  onClickActionType : function(actionType){
		  this.actionType = actionType;
		  if(this.actionType == "none"){
			  var tool = board.toolManager.findTool("DragCreating");
		      if (tool !== null) tool.isEnabled = false;
		      var tool = board.toolManager.findTool("FreehandDrawing");
		      if (tool !== null) tool.isEnabled = false;
		  }else if(this.actionType == "shape"){
			  var tool = board.toolManager.findTool("DragCreating");
		      if (tool !== null) tool.isEnabled = true;
		      var tool = board.toolManager.findTool("FreehandDrawing");
		      if (tool !== null) tool.isEnabled = false;
		  }else if(this.actionType == "pen"){
			  var tool = board.toolManager.findTool("DragCreating");
			  if (tool !== null) tool.isEnabled = false;
			  var tool = board.toolManager.findTool("FreehandDrawing");
			  if (tool !== null) tool.isEnabled = true;
		  }
	  },
	  
	  onClickSubActionType : function(subActionType){
		  this.subActionType = subActionType;
	  },
	  onClickProperty : function(property, value){
		  board.startTransaction("change color");
		  board.selection.each(function (obj) {
			  board.model.setDataProperty(obj.data, property, value)
		  });
		  board.commitTransaction("change color");
		  
	  }
  }

});//end of vue instance
}
