var vueGoInstance;
var hamnaEditor;

Vue.directive('focus', {
	inserted: function (el) {
		el.focus();
	},
	update: function (el) {
		Vue.nextTick(function () {
			el.focus();
		})
	}
});

function viewFullScreen(show) {
	if (show === undefined) show = !isFullScreen();

	var elem = document.documentElement;
	if (show) {
		if (elem.requestFullscreen) elem.requestFullscreen();
		else if (elem.webkitRequestFullScreen) elem.webkitRequestFullScreen();
		else if (elem.mozRequestFullScreen) elem.mozRequestFullScreen();
		else if (elem.msRequestFullscreen) elem.msRequestFullscreen();
	} else {
		if (document.exitFullscreen) document.exitFullscreen();
		else if (document.webkitExitFullscreen) document.webkitExitFullscreen();
		else if (document.mozCancelFullScreen) document.mozCancelFullScreen();
		else if (document.msExitFullscreen) document.msExitFullscreen();
	}
}

function isFullScreen() {
	return !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
}

var EDITOR_CONFIG = {
	heading: {
		options: [
			{ model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
			{ model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
			{ model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' },
			{ model: 'normale', view: 'div', title: 'Normal', class: 'ck-heading_normal' },
		]
	},
	fontBackgroundColor: {
		documentColors: 2 // Disable document colors section.
	},
	fontColor: {
		columns: 4,
		documentColors: 12,
		// ...
	},
	toolbar: ["heading", "bold", "italic", '|', "bulletedList", "numberedList", "fontColor", "fontBackgroundColor", 'undo', 'redo'],
	startupFocus: true,
}

// "#ffffff00",

var _colorOptions = [
	{
		value: "#FF8A80",
		type: 1
	},
	{
		value: "#FF80AB",
		type: 1
	},
	{
		value: "#EA80FC",
		type: 1
	},
	{
		value: "#B388FF",
		type: 1
	},
	{
		value: "#699bf7",
		type: 1
	},
	{
		value: "#82B1FF",
		type: 1
	},
	{
		value: "#d27c2c",
		type: 1
	},
	{
		value: "#545454",
		type: 1
	},
	{
		value: "#FF1744",
		type: 1
	},

	{
		value: "#F50057",
		type: 1
	},
	{
		value: "#D500F9",
		type: 1
	},
	{
		value: "#651FFF",
		type: 1
	},
	{
		value: "#2979FF",
		type: 1
	},
	{
		value: "#D50000",
		type: 1
	},
	{
		value: "#C51162",
		type: 1
	},
	{
		value: "#AA00FF",
		type: 1
	},
	{
		value: "#6200EA",
		type: 1
	},
	{
		value: "#2962FF",
		type: 1
	},

	{
		value: "#A7FFEB",
		type: 1
	},
	{
		value: "#CCFF90",
		type: 1
	},
	{
		value: "#FFFF8D",
		type: 1
	},
	{
		value: "#CFD8DC",
		type: 1
	},
	{
		value: "#546E7A",
		type: 1
	},
	{
		value: "#1DE9B6",
		type: 1
	},
	{
		value: "#76FF03",
		type: 1
	},
	{
		value: "#FFC400",
		type: 1
	},
	{
		value: "#90A4AE",
		type: 1
	},
	{
		value: "#37474F",
		type: 1
	},
	{
		value: "#00BFA5",
		type: 1
	},
	{
		value: "#64DD17",
		type: 1
	},
	{
		value: "#FFAB00",
		type: 1
	},
	{
		value: "#607D8B",
		type: 1
	},
	{
		value: "#263238",
		type: 1
	}
];

var _textColorOptions = [
	{
		value: "#f24e1e",
		type: 1
	},
	{
		value: "#ffc700",
		type: 1
	},
	{
		value: "#0fa958",
		type: 1
	},
	{
		value: "#699bf7",
		type: 1
	},
	{
		value: "#9747ff",
		type: 1
	},
	{
		value: "#d27c2c",
		type: 1
	},
	{
		value: "#545454",
		type: 1
	},
	{
		value: "#ffffff",
		type: 1
	}
];

var _linksColorOptions = [
	{
		value: "#f24e1e",
		type: 1
	},
	{
		value: "#ffc700",
		type: 1
	},
	{
		value: "#0fa958",
		type: 1
	},
	{
		value: "#699bf7",
		type: 1
	},
	{
		value: "#9747ff",
		type: 1
	},
	{
		value: "#d27c2c",
		type: 1
	},
	{
		value: "#545454",
		type: 1
	},
	{
		value: "#ffffff",
		type: 1
	}
];

var _noteColors = [{
	value: "#F2F4F6", type: 1
}, {
	value: "#FCFAA2", type: 1
}, {
	value: "#CCF780", type: 1
}, {
	value: "#F2C920", type: 1
}, {
	value: "#BEDC45", type: 1
}, {
	value: "#F38B38", type: 1
}, {
	value: "#83CC62", type: 1
}, {
	value: "#EB536C", type: 1
}, {
	value: "#58BBB3", type: 1
}, {
	value: "#E27DAD", type: 1
}, {
	value: "#5DD0F8", type: 1
}, {
	value: "#F9C1D9", type: 1
}, {
	value: "#96BFF3", type: 1
}, {
	value: "#AF71BA", type: 1
}, {
	value: "#687AFF", type: 1
}, {
	value: "#000000", type: 1
}];

var _frameColors = [{
	value: "#F2F4F6", type: 1
}, {
	value: "#FCFAA2", type: 1
}, {
	value: "#CCF780", type: 1
}, {
	value: "#F2C920", type: 1
}, {
	value: "#BEDC45", type: 1
}, {
	value: "#F38B38", type: 1
}, {
	value: "#83CC62", type: 1
}, {
	value: "#EB536C", type: 1
}, {
	value: "#58BBB3", type: 1
}, {
	value: "#E27DAD", type: 1
}, {
	value: "#5DD0F8", type: 1
}, {
	value: "#F9C1D9", type: 1
}, {
	value: "#96BFF3", type: 1
}, {
	value: "#AF71BA", type: 1
}, {
	value: "#687AFF", type: 1
}, {
	value: "#000000", type: 1
}];

var _fontsList = [
	{ value: "Arial (sans-serif)", code: "Arial ,sans-serif" },
	{ value: "Verdana (sans-serif)", code: "Verdana ,sans-serif" },
	{ value: "Helvetica (sans-serif)", code: "Helvetica ,sans-serif" },
	{ value: "Tahoma (sans-serif)", code: "Tahoma ,sans-serif" },
	{ value: "Trebuchet MS (sans-serif)", code: "Trebuchet MS ,sans-serif" },
	{ value: "Times New Roman (serif)", code: "Times New Roman ,serif" },
	{ value: "Georgia (serif)", code: "Georgia ,serif" },
	{ value: "Garamond (serif)", code: "Garamond ,serif" },
	{ value: "Courier New (monospace)", code: "Courier New ,monospace" },
	{ value: "Brush Script MT (cursive)", code: "Brush Script MT ,cursive" }
];

function getCursorOfType(type) {
	if (type === "pointer") {
		return "default";
	}
	else if (type === "crosshair") {
		return "crosshair";
	}
	else if (type === "text") {
		return "text";
	}
	else {
		return "";
	}
}

function convertLoggedInUser() {
	if (!vueGoInstance.isPublicLinkUrl) {
		return { id: loggedInUser.id, email: loggedInUser.email, userName: loggedInUser.userName, firstName: loggedInUser.firstName, lastName: loggedInUser.lastName, fullName: loggedInUser.fullName };
	}
	else {
		return { name: vueGoInstance.anonymousUser.name, email: vueGoInstance.anonymousUser.email, external: true, companyId: vueGoInstance.anonymousUser.companyId };
	}
}

const NODE_OPTIONS_MENU = Vue.component('node-options-menu', {
	template: `
	<div class="DAJ">
		<template v-for="(option, optionIndex) in menuOptions" >
			<div :class="[selectedOption == optionIndex ? 'active':'', (option.type != -1 ) ? 'icon1': '' ]" @click="onSelectOption(option, optionIndex);" :title="option.tooltip" >
				<!-- Main Option -->
				<div class="sprt" v-if="option.type == -1" ></div>
				<img v-if="option.type == 0" :src="option.icon" alt="" />
				<div v-if="option.type == 1" class="bxr ml" :style="{backgroundColor: option.value}"></div>
				<div v-if="option.type == 2" class="bxr ml" :style="{border: '4px solid '+option.value}"></div>
				<div v-if="option.type == 3">
					<img :src="option.icon" alt="" />
					<span>Type</span>
				</div>

				<div v-if="option.type == 4" class="fnud DAJ prow">
					<span class="txt">{{option.value}}</span>
					<div class="dnarr"></div>
					<span @click="onTextFontSizeChange(option,1, $event);" class="ic up"></span>
					<span @click="onTextFontSizeChange(option,-1, $event);"class="ic dn"></span>
				</div>
				
				<div v-if="option.type == 5">
					<img :src="option.icon" alt="" />
					<div class="undln" :style={backgroundColor:option.value}></div>
				</div>

				<img v-if="option.type == 6" :src="option.icon" alt="" class="emoji-img" style="width:40px;height:40px;" />
				<div v-if="option.type == 7" >{{option.value}}</div>
				<div v-if="option.type == 8" >
					<input type="range" min="1" max="15" class="pslider" :style="{backgroundSize: (( ((option.value-1)/14) * 100 )+'%')}" :value="option.value" @change="onChangeSliderValue" >
				</div>

				<div v-if="option.type == 9" class="fnud DAJ prow">
					<img v-if="option.icon" :src="option.icon" alt="" />
					<span class="txt">{{option.title}}</span>
					<span class="txt">{{option.value}}</span>
				</div>

				<div v-if="option.subOptions && option.type != 4" class="dnarr"></div>

				<vuepopup v-if="option.expanded && selectedOption == optionIndex" @close="option.expanded = false;">
					<!-- Sub Options -->
					<template v-if="option.subOptionsType == 'link_type'">
						<div class="nodhvr artp arlt d">						
							<div class="DAJ">
								<div class="icon1" :class="[option.subOptions.route == 0 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'route',0);">
									<img src="/assets/icons/collab/line-type1.svg" alt="aaa" class="a" />
								</div>
								<div class="icon1" :class="[option.subOptions.route == 1 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'route',1);">
									<img src="/assets/icons/collab/line-type2.svg" alt="bbb" />
								</div>
								<div class="icon1" :class="[option.subOptions.route == 2 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'route',2);">
									<img src="/assets/icons/collab/line-type3.svg" alt="ccc" />
								</div>
							</div>
							<div class="DAJ">
								<div class="icon1" :class="[option.subOptions.lineType == 0 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'lineType',0);">
									<img src="/assets/icons/collab/line.svg" alt="x" />
								</div>
								<div class="icon1" :class="[option.subOptions.lineType == 1 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'lineType',1);">
									<img src="/assets/icons/collab/line-dashed.svg" alt="y" />
								</div>
								<div class="icon1" :class="[option.subOptions.lineType == 2 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'lineType',2);">
									<img src="/assets/icons/collab/line-dotted.svg" alt="z" />
								</div>
							</div>
							<div class="cont bdtp">
								<label>Thickness</label>
								<input type="range" min="1" max="10" class="pslider" :style="{backgroundSize: (( ((option.subOptions.thickness-1)/9) * 100 )+'%')}" :value="option.subOptions.thickness" @change="onChangeLinkTypeValue(option,'thickness',$event);"/>
							</div>
						</div>
					</template>

					<template v-else-if="option.subOptionsType == 'text_alignment'">
						<div class="nodhvr artp algn inrmn">
							<div class="DF">
								<div class="icon1" :class="[option.value == 'left' ? 'active' : '']" @click="onClickProperty({value:'left'}, $event);">
									<img src="/assets/icons/collab/align_left.svg" alt="left" />
								</div>
								<div class="icon1" :class="[option.value == 'center' ? 'active' : '']" @click="onClickProperty({value:'center'}, $event);">
									<img src="/assets/icons/collab/align_center.svg" alt="center" />
								</div>
								<div class="icon1" :class="[option.value == 'right' ? 'active' : '']" @click="onClickProperty({value:'right'}, $event);">
									<img src="/assets/icons/collab/align_right.svg" alt="right" />
								</div>
							</div>
						</div>
					</template>

					<template v-else-if="option.subOptionsType == 'emoji'">
						<div class="nodhvr artp algn inrmn emoji">
							<ul>
								<li v-for="(sopt, soptIndex) in $options._emojis"  @click="onClickProperty(sopt, $event);">
									<img :src="sopt.icon" alt="" style="width:40px;height:40px;" />
								</li>
							</ul>
						</div>
					</template>

					<template v-else-if="option.subOptionsType == 'border_menu'">
						<div class="nodhvr artp inrmn opta a">
							<div class="DAJ">
								<div class="icon1" :class="[option.subOptions.lineType == 0 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'lineType',0);">
									<img src="/assets/icons/collab/line.svg" alt="Line" class="zah" />
								</div>
								<div class="icon1" :class="[option.subOptions.lineType == 1 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'lineType',1);">
									<img src="/assets/icons/collab/line-dashed.svg" alt="Line" />
								</div>
								<div class="icon1" :class="[option.subOptions.lineType == 2 ? 'active' : '']" @click="onChangeLinkTypeValue(option,'lineType',2);">
									<img src="/assets/icons/collab/line-dotted.svg" alt="Line" />
								</div>
							</div>

							<input type="range" min="1" max="10" :style="{backgroundSize: (( ((option.subOptions.thickness-1)/9) * 100 )+'%')}" class="pslider" :value="option.subOptions.thickness" @change="onChangeLinkTypeValue(option,'thickness',$event);"/>
							
							<div class="DFA clbr">
								<div class="clr-a bxr ml cr" @click="onClickProperty({value:'#ffffff'}, $event);"></div>
								<div class="clr-a bxr ml"    @click="onClickProperty({value:'#ffffff'}, $event);"></div>
							</div>
							<ul>
								<li v-for="(sopt, soptIndex) in option.subOptions.colors"  @click="onClickProperty(sopt, $event);">
									<div class="clr-a bxr ml" :style="{backgroundColor: sopt.value}"></div>
								</li>
							</ul>
							
						</div>
					</template>
					<template v-else-if="option.subOptionsType == 'color_menu'">
						<div class="nodhvr artp inrmn opta b">
							<input v-if="option.subOptions.showOpacity" type="range" min="0" max="100" :style="{backgroundSize: (option.subOptions.opacity+'%')}" class="pslider" v-model="option.subOptions.opacity" />
							<div class="DFA clbr">
								<div class="clr-a bxr ml cr" @click="onClickProperty({value:'#ffffff00'}, $event);" v-if="option.subOptions.showTransparent"></div>
								<div class="clr-a bxr ml"    @click="onClickProperty({value:'#ffffff'}, $event);"></div>
							</div>
							<ul>
								<li v-for="(sopt, soptIndex) in option.subOptions.colors"  @click="onClickProperty(sopt, $event);">
									<div class="clr-a bxr ml" :style="{backgroundColor: sopt.value}"></div>
								</li>
							</ul>
							
						</div>
					</template>
					<template v-else-if="option.subOptionsType == 'text_list'">
						<div class="nodhvr artp inrmn ictxt a">
							<ul>
								<li class="menu-item" v-for="(sopt, soptIndex) in option.subOptions"  @click="onClickProperty(sopt, $event);">
									<span class="txt">{{sopt.value}}</span>
								</li>
							</ul>
						</div>
					</template>
					<template v-else-if="option.subOptionsType == 'notAllowedItems'">
						<div class="nodhvr artp inrmn ictxt b">
							<a href="javascript:void(0);" class="close" @click="onCloseAllowedItemList"></a>
							<ul>
								<li class="menu-item" v-for="(sopt, soptIndex) in option.subOptions.options"  @click="onClickProperty(sopt, $event);" :class="[option.subOptions.selectedItems[sopt.id]?'selected':'']">
									<span class="ico"><img :src="sopt.icon" alt="Shape" /></span> <span class="txt">{{sopt.value}}</span>
								</li>
							</ul>
						</div>
					</template>
					<template v-else-if="option.subOptionsType == 'object_list'">
						<div class="nodhvr artp inrmn ictxt c">
							<ul>
								<li class="menu-item" v-for="(sopt, soptIndex) in option.subOptions"  @click="onClickProperty(sopt, $event);">
									<span class="ico"><img :src="sopt.icon" alt="Shape" /></span> <span class="txt">{{sopt.value}}</span> <span class="val">{{sopt.count}}</span>								
								</li>
							</ul>
						</div>
					</template>
					<template  v-else-if="option.subOptionsType == 'other_options'">
						<ul class="menuclb show-menu txtmnu dtmn">
							
							<template v-for="(sopt, soptIndex) in option.options">
								<li v-if="sopt.id" :id="sopt.id" 
									class="menu-item DFA mr-a" :class="[sopt.enabled ? '': 'disabled']" 
									@click="onContextMenuCommand($event, sopt.id, sopt);">
									<div class="ico">
										<img :src="sopt.icon" alt="">
									</div>
									{{sopt.title}}
								</li>
								<li v-else class="sprtV"></li>
							</template>
							
						</ul>
					</template>
					<template v-else>
						<div class="nodhvr artp inrmn shaps" v-if="option.subOptions && option.subOptions.length > 0" :style="subOptionsContainerStyle(option)">
							<ul class="DF aa">
								<li v-for="(sopt, soptIndex) in option.subOptions" class="icon1" :class="sopt.selected ? 'active' : ''" @click="onClickProperty(sopt, $event);">
									<div v-if="sopt.type == 1" class="bxr in" :style="{backgroundColor: sopt.value}"></div>
									<img v-if="sopt.type == 2" :src="sopt.icon" alt="" />
									<div v-if="sopt.type == 3" >{{sopt.value}}</div>
									<div v-if="sopt.type == 4" class="bxr in" :style="{backgroundColor: sopt.value}"></div>
								</li>
							</ul>
						</div>
					</template>
				</vuepopup>

			</div>
		</template>
	</div>
	`,
	props: [],
	data() {
		return {
			selectedOption: -1,
			menuOptions: [],
			recentEmojis: []
		}
	},
	computed: {
	},
	mounted() {
	},
	computed: {
		subOptionsContainerStyle: function () {
			return function (option) {
				if (option.subOptionsType == "list") {
					return "{width:'56px' ; maxheight:'200px'; overflow: auto; left: '0px'}"
				}
				return "";
			};
		},
		linkFonSubOptions: function () {
			return function (option) {
				var options = [];
				for (var i = option.from; i <= option.to; i += option.step) {
					options.push({ value: i });
				}
				return options;
			};
		}
	},
	created() {

		this.$options._emojis = [
			{ icon: "/assets/js/lib/golab/Emojis/1F60A.png", value: 1 },
			{ icon: "/assets/js/lib/golab/Emojis/1F60B.png", value: 2 },
			{ icon: "/assets/js/lib/golab/Emojis/1F60C.png", value: 3 },
			{ icon: "/assets/js/lib/golab/Emojis/1F60D.png", value: 4 },
			{ icon: "/assets/js/lib/golab/Emojis/1F60E.png", value: 5 },
			{ icon: "/assets/js/lib/golab/Emojis/1F60F.png", value: 6 },
			{ icon: "/assets/js/lib/golab/Emojis/1F61A.png", value: 7 },
			{ icon: "/assets/js/lib/golab/Emojis/1F61B.png", value: 8 },
			{ icon: "/assets/js/lib/golab/Emojis/1F61C.png", value: 9 },
			{ icon: "/assets/js/lib/golab/Emojis/1F61D.png", value: 10 },
			{ icon: "/assets/js/lib/golab/Emojis/1F61E.png", value: 11 },
			{ icon: "/assets/js/lib/golab/Emojis/1F61F.png", value: 12 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62A.png", value: 13 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62B.png", value: 14 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62C.png", value: 15 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62D.png", value: 16 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62E-200D-1F4A8.png", value: 17 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62E.png", value: 18 },
			{ icon: "/assets/js/lib/golab/Emojis/1F62F.png", value: 19 }
		];

		this.$options._commands = [
			{ id: 0, title: "Edit", disabled: false, shortKey: "" },
			{ id: 0, title: "Info", disabled: false, shortKey: "" },
			{ id: 0, title: "Lock", disabled: false, shortKey: "" },
			{ id: 0, title: "Bring to front", disabled: false, shortKey: "" },
			{ id: 0, title: "Send to back", disabled: false, shortKey: "" },
			{ id: 0, title: "Copy", disabled: false, shortKey: "" },
			{ id: 0, title: "Duplicate", disabled: false, shortKey: "" },
			{ id: 0, title: "Save as teamplate", disabled: false, shortKey: "" },
			{ id: 0, title: "Delete", disabled: false, shortKey: "" }
		];

		/*
		0 for text
		1 for color
		2 svg icon
		 */

		this.$options._linkArrowOptionsFrom = [
			{
				icon: "",
				value: "none",
				type: 3
			},
			{
				icon: "/assets/icons/collab/arrow-s3.svg",
				value: "Backward",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_triangle.svg",
				value: "BackwardOpenTriangle",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_circle.svg",
				value: "Circle",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_square.svg",
				value: "Block",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_diamond.svg",
				value: "Diamond",
				type: 2
			}
		];
		this.$options._linkArrowOptionsTo = [
			{
				icon: "",
				value: "none",
				type: 3
			},
			{
				icon: "/assets/icons/collab/arrow-s3.svg",
				value: "Standard",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_triangle.svg",
				value: "OpenTriangle",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_circle.svg",
				value: "Circle",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_square.svg",
				value: "Block",
				type: 2
			},
			{
				icon: "/assets/js/lib/golab/icons/_diamond.svg",
				value: "Diamond",
				type: 2
			}
		];

		this.$options._shapeOptions = [
			{
				icon: "/assets/icons/collab/rectangle-1.svg",
				value: "Rectangle",
				type: 2
			},
			{
				icon: "/assets/icons/collab/rectangle1.svg",
				value: "RoundedRectangle",
				type: 2
			},
			{
				icon: "/assets/icons/collab/rectangle2.svg",
				value: "Parallelogram",
				type: 2
			},
			{
				icon: "/assets/icons/collab/rectangle3.svg",
				value: "Diamond",
				type: 2
			},
			{
				icon: "/assets/icons/collab/star-s.svg",
				value: "FivePointedStar",
				type: 2
			},
			{
				icon: "/assets/icons/collab/elipse.svg",
				value: "Ellipse",
				type: 2
			},
			{
				icon: "/assets/icons/collab/polygon.svg",
				value: "Triangle",
				type: 2
			},
			{
				icon: "/assets/icons/collab/union.svg",
				value: "Arrow",
				type: 2
			}
		];
		this.selectedOption = this.subActionType;
	},
	methods: {
		//////////////////////////////////////////////////////
		////////////////    LOGIC
		getOtherOptions: function (item) {

			if (board.selection.count == 0) {
				return [];
			}

			var lastItem = board.selection.first().data;
			var cmd = board.commandHandler;
			var locked = lastItem.lock ? true : false;

			var isMultiple = board.selection.count > 1;

			if (lastItem.category === "Arrow") {
				return [
					{
						title: "Send to Back",
						id: "pushBack",
						enabled: !locked,
						icon: "/assets/icons/collab/flip_back.svg"
					},
					{
						title: "Bring to Front",
						id: "pullFront",
						enabled: !locked,
						icon: "/assets/icons/collab/flip_front.svg"
					},
					{
					},
					{
						title: "Delete",
						id: "delete",
						enabled: cmd.canDeleteSelection(),
						icon: "/assets/icons/collab/delete.svg"
					}
				];
			}

			var otherOptions = [
				{
					title: "Send to Back",
					id: "pushBack",
					enabled: !locked,
					icon: "/assets/icons/collab/flip_back.svg"
				},
				{
					title: "Bring to Front",
					id: "pullFront",
					enabled: !locked,
					icon: "/assets/icons/collab/flip_front.svg"
				},
				{

				},
				{
					title: "Duplicate",
					id: "crt-same",
					enabled: true,
					icon: "/assets/icons/collab/duplicate.svg"
				},
				{
					title: "Cut",
					id: "cut",
					enabled: cmd.canCutSelection(),
					icon: "/assets/icons/collab/cut.svg"
				},
				{
					title: "Copy",
					id: "copy",
					enabled: cmd.canCopySelection(),
					icon: "/assets/icons/collab/copy.svg"
				},
				{
					title: "Paste",
					id: "paste",
					enabled: cmd.canPasteSelection(board.toolManager.contextMenuTool.mouseDownPoint),
					icon: "/assets/icons/collab/paste.svg"
				},
				{
					title: "Delete",
					id: "delete",
					enabled: cmd.canDeleteSelection(),
					icon: "/assets/icons/collab/delete.svg"
				}
			];

			if (lastItem.category === "FRAME") {

				var sendToBack   = otherOptions[0];
				var bringToFront = otherOptions[1];

				sendToBack.enabled = false;
				bringToFront.enabled = false;

				var notAllowedItems = {};
				if (lastItem.notAllowedItems) {
					_.each(lastItem.notAllowedItems, _item => {
						notAllowedItems[_item] = true;
					});
				}

				otherOptions.splice(0, 0, {});

				///  add text
				otherOptions.splice(0, 0, {
					title: "Add Text",
					id: "crt-text",
					enabled: !locked && (notAllowedItems["TEXT"] ? false : true) && !isMultiple,
					icon: "/assets/icons/collab/text1.svg"
				});
				///  add note
				otherOptions.splice(0, 0, {
					title: "Add Sticky Note",
					id: "crt-note",
					enabled: !locked && (notAllowedItems["NOTE"] ? false : true) && !isMultiple,
					icon: "/assets/icons/collab/note-1.svg"
				});
			}
			return otherOptions;
		},
		createShapeMenuOptions: function (item) {
			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}

			var shape = _.find(this.$options._shapeOptions, { value: item.figure });
			if (!shape) {
				shape = this.$options._shapeOptions[0];
			}

			this.menuOptions = [
				{
					id: "figure",
					selected: false,
					value: item.figure,
					icon: shape.icon,
					expanded: false,
					type: 0,
					tooltip: "Shape",
					subOptionsType: 0,
					subOptions: this.$options._shapeOptions
				},
				{
					type: -1
				},
				{
					id: "textFont",
					selected: false,
					value: item.textFont,
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 0,
					tooltip: "Font",
					subOptionsType: "text_list",
					subOptions: _fontsList
				},
				{
					id: "textSize",
					selected: false,
					value: item.textSize,
					expanded: false,
					type: 4,
					tooltip: "Font size",
					subOptionsType: "text_list",
					subOptions: [{ value: 8 }, { value: 12 }, { value: 14 }, { value: 18 }, { value: 24 }, { value: 36 }, { value: 48 }, { value: 64 }, { value: 128 }]
				},
				{
					id: "textStyle",
					selected: false,
					value: item.textStyle,
					expanded: false,
					icon: "assets/js/lib/golab/icons/text_bold.svg",
					type: 0,
					tooltip: "Text style",
					subOptionsType: 1,
					subOptions: [
						{ icon: "/assets/js/lib/golab/icons/text_bold.svg", value: "bold", type: 2, selected: item.bold },
						{ icon: "/assets/js/lib/golab/icons/text_italic.svg", value: "italic", type: 2, selected: item.italic },
						{ icon: "/assets/js/lib/golab/icons/text_underlined.svg", value: "underline", type: 2, selected: item.underline }
					]
				},
				{
					id: "textAlignment",
					selected: false,
					value: "",
					icon: "/assets/js/lib/golab/icons/align_center.svg",
					expanded: false,
					tooltip: "Text alignment",
					type: 0,
					subOptionsType: "text_alignment",
					subOptions: {
						alignment: item.textAlignment
					}
				},
				// {
				// 	id: "textHyperlink",
				// 	selected: false,
				// 	value: "",
				// 	tooltip: "Hyperlink",
				// 	icon: "assets/js/lib/golab/icons/text_link.svg",
				// 	expanded: false,
				// 	type: 0
				// },
				{
					type: -1
				},
				{
					id: "textColor",
					selected: false,
					value: item.textColor ? item.textColor : "#000",
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					tooltip: "Text color",
					type: 5,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: false, showTransparent: false, opacity:100}
				},
				{
					id: "textBg",
					selected: false,
					value: item.textBg ? item.textBg : "transparent",
					icon: "/assets/js/lib/golab/icons/text_edit.svg",
					expanded: false,
					tooltip: "Text highlight",
					type: 5,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.textBg)}
				},
				{
					type: -1
				},
				{
					id: "fill",
					selected: false,
					value: item.fill,
					icon: "",
					expanded: false,
					tooltip: "Background color",
					type: 1,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.fill)}
				},
				{
					id: "border",
					selected: false,
					value: item.border,
					icon: "",
					expanded: false,
					type: 2,
					subOptionsType: "border_menu",
					tooltip: "Stroke color",
					subOptions: {
						thickness: item.thickness ? item.thickness : 1,
						lineType: item.lineType ? item.lineType : 0,
						color: item.border ? item.border : "#000",
						colors: _colorOptions,
					}
				},
				{
					id: "lock",
					selected: false,
					value: "none",
					tooltip: "Lock item",
					icon: "/assets/icons/collab/unlock.svg",
					expanded: false,
					type: 0
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];

		},
		createTextMenuOptions: function (item) {
			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}
			this.menuOptions = [
				{
					id: "textFont",
					selected: false,
					value: item.textFont,
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 0,
					tooltip: "Font",
					subOptionsType: "text_list",
					subOptions: _fontsList
				},
				{
					type: -1
				},
				{
					id: "textSize",
					selected: false,
					value: item.textSize,
					expanded: false,
					type: 4,
					tooltip: "Font size",
					subOptionsType: "text_list",
					subOptions: [{ value: 8 }, { value: 12 }, { value: 14 }, { value: 18 }, { value: 24 }, { value: 36 }, { value: 48 }, { value: 64 }, { value: 128 }]
				},
				{
					type: -1
				},
				{
					id: "textStyle",
					selected: false,
					value: item.textStyle,
					expanded: false,
					icon: "/assets/js/lib/golab/icons/text_bold.svg",
					type: 0,
					subOptionsType: 1,
					tooltip: "Text style",
					subOptions: [
						{ icon: "/assets/js/lib/golab/icons/text_bold.svg", value: "bold", type: 2, selected: item.bold },
						{ icon: "/assets/js/lib/golab/icons/text_italic.svg", value: "italic", type: 2, selected: item.italic },
						{ icon: "/assets/js/lib/golab/icons/text_underlined.svg", value: "underline", type: 2, selected: item.underline }
					]
				},
				{
					id: "textAlignment",
					selected: false,
					value: "",
					icon: "/assets/js/lib/golab/icons/align_center.svg",
					expanded: false,
					tooltip: "Text alignment",
					type: 0,
					subOptionsType: "text_alignment",
					subOptions: {
						alignment: item.textAlignment
					}
				},
				{
					type: -1
				},
				{
					id: "textColor",
					selected: false,
					value: item.textColor ? item.textColor : "#000",
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 5,
					tooltip: "Text color",
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: false, showTransparent: false, opacity:100}
				},
				{
					id: "textBg",
					selected: false,
					value: item.textBg ? item.textBg : "transparent",
					icon: "/assets/js/lib/golab/icons/text_edit.svg",
					expanded: false,
					tooltip: "Text highlight",
					type: 5,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.textBg)}
				},
				{
					type: -1
				},
				{
					id: "lock",
					selected: false,
					value: "none",
					tooltip: "Lock item",
					icon: "/assets/icons/collab/unlock.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];
		},
		createFrameMenuOptions: function (item) {

			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}

			var allItemTypes = [{ id: "TEXT", value: "Text", icon: "/assets/icons/collab/text1.svg" }, { id: "FRAME", value: "Frame", icon: "/assets/icons/collab/frame-1.svg" }, { id: "NOTE", value: "Note", icon: "/assets/icons/collab/note-1.svg" }, { id: "FreehandDrawing", value: "Pencil Drawing", icon: "/assets/icons/collab/pen1.svg" }, { id: "SHAPE", value: "Shape", icon: "/assets/icons/collab/rectangle-1.svg" }];
			var allowDropItemsMap = {};
			_.each(allItemTypes, type => {
				allowDropItemsMap[type.id] = true;
			});
			if (item.notAllowedItems) {
				_.each(item.notAllowedItems, item => {
					allowDropItemsMap[item] = false;
				});
			}

			this.menuOptions = [
				{
					id: "fill",
					selected: false,
					value: item.fill,
					icon: "",
					expanded: false,
					tooltip: "Background color",
					type: 1,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.fill)}
				},
				{
					type: -1,
				},
				{
					id: "showHeader",
					selected: false,
					value: item.showHeader,
					tooltip: "Show Header",
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1,
				},
				// {
				// 	id: "layout",
				// 	selected: false,
				// 	value: item.layout,
				// 	tooltip: "Layout",
				// 	icon: item.layout == "layout" ? "/assets/icons/grid.svg" : "/assets/icons/layers.svg",
				// 	expanded: false,
				// 	type: 0
				// },

				// {
				// 	type: -1,
				// },
				{
					id: "fitcontent",
					selected: false,
					tooltip: "Resize to fit the content",
					value: "Fit Content",
					expanded: false,
					type: 7
				},
				{ type: -1 },
				{
					id: "notAllowedItems",
					selected: false,
					tooltip: "Allow item of types to drop in frame",
					value: "Allow items",
					expanded: false,
					type: 7,
					subOptionsType: "notAllowedItems",
					subOptions: {
						options: allItemTypes,
						selectedItems: allowDropItemsMap
					}
				}
				,
				{
					type: -1,
				},
				{
					id: "lock",
					selected: false,
					value: "none",
					tooltip: "Lock item",
					icon: "/assets/icons/collab/unlock.svg",
					expanded: false,
					type: 0
				}
				,
				{ type: -1 },
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];

			var layoutOptionIndex = 4;
			var textIndex = 2;
			if (item.showHeader) {

				var textSize = {
					id: "textSize",
					selected: false,
					value: item.textSize,
					expanded: false,
					type: 4,
					tooltip: "Header Text Font size",
					subOptionsType: "text_list",
					subOptions: [{ value: 8 }, { value: 12 }, { value: 14 }, { value: 18 }, { value: 24 }, { value: 36 }, { value: 48 }, { value: 64 }, { value: 128 }]
				};
				this.menuOptions.splice(textIndex + 1, 0, textSize);

				var textAlign = {
					id: "textAlignment",
					selected: false,
					value: item.textAlignment,
					icon: "/assets/js/lib/golab/icons/align_center.svg",
					expanded: false,
					tooltip: "Header Text alignment",
					type: 0,
					subOptionsType: "text_alignment",
				};
				this.menuOptions.splice(textIndex + 2, 0, textAlign);

				var textColor = {
					id: "textColor",
					selected: false,
					value: item.textColor ? item.textColor : "#000",
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 5,
					tooltip: "Header Text color",
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: false, showTransparent: false, opacity:100}
				};
				this.menuOptions.splice(textIndex + 3, 0, textColor);

				var textBg = {
					id: "textBg",
					selected: false,
					value: item.textBg ? item.textBg : "transparent",
					icon: "/assets/js/lib/golab/icons/text_edit.svg",
					expanded: false,
					tooltip: "Header Background",
					type: 5,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.textBg)}
				};
				this.menuOptions.splice(textIndex + 4, 0, textBg);

				layoutOptionIndex += 4;
			}

			// if (item.layout && item.layout === "layout") {

			// 	var subOptions = [{ value: "Auto" }, { value: 1 }, { value: 2 }, { value: 3 }, { value: 4 }, { value: 5 }, { value: 6 }, { value: 7 }, { value: 8 }, { value: 9 }, { value: 10 }];

			// 	var rows = {
			// 		id: "rows", value: item.rows ? item.rows : "Auto",
			// 		tooltip: "Number of Rows", expanded: false, type: 9, title: "Rows",
			// 		icon: "/assets/icons/collab/rows.svg"
			// 	};
			// 	rows.subOptionsType = "text_list";
			// 	rows.subOptions = subOptions;
			// 	this.menuOptions.splice(layoutOptionIndex + 1, 0, rows);

			// 	var columns = {
			// 		id: "columns", value: item.columns ? item.columns : "Auto",
			// 		tooltip: "Number of Columns", expanded: false, type: 9, title: "Columns",
			// 		icon: "/assets/icons/collab/columns.svg"
			// 	};
			// 	columns.subOptionsType = "text_list";
			// 	columns.subOptions = subOptions;
			// 	this.menuOptions.splice(layoutOptionIndex + 2, 0, columns);
			// }
		},
		createNoteMenuOptions: function (item) {

			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}

			this.menuOptions = [
				{
					id: "textSize",
					selected: false,
					value: item.textSize,
					expanded: false,
					type: 4,
					tooltip: "Font size",
					subOptionsType: "text_list",
					subOptions: [{ value: "Auto" }, { value: 8 }, { value: 12 }, { value: 14 }, { value: 18 }, { value: 24 }, { value: 36 }, { value: 48 }, { value: 64 }, { value: 128 }]
				},
				{
					type: -1
				},
				{
					id: "textFont",
					selected: false,
					value: item.textFont,
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					tooltip: "Font",
					type: 0,
					subOptionsType: "text_list",
					subOptions: _fontsList
				},
				{
					id: "textAlignment",
					selected: false,
					value: item.textAlignment,
					icon: "/assets/js/lib/golab/icons/align_center.svg",
					expanded: false,
					tooltip: "Text alignment",
					type: 0,
					subOptionsType: "text_alignment"
				},
				{
					id: "textColor",
					selected: false,
					value: item.textColor ? item.textColor : "#000",
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 5,
					tooltip: "Text color",
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: false, showTransparent: false, opacity:100}
				},
				{
					type: -1
				},
				{
					id: "fill",
					selected: false,
					value: item.fill,
					icon: "",
					expanded: false,
					tooltip: "Background",
					type: 1,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:100}
				},
				{
					type: -1
				},
				// {
				// 	id: "emoji",
				// 	selected: false,
				// 	value: "",
				// 	icon: "/assets/js/lib/golab/Emojis/1F60A.png",
				// 	expanded: false,
				// 	tooltip: "Reactions",
				// 	type: 6,
				// 	subOptionsType: "emoji",
				// 	subOptions: [[]]
				// },
				// {
				// 	type: -1
				// },
				{
					id: "lock",
					selected: false,
					value: "none",
					tooltip: "Lock item",
					icon: "/assets/icons/collab/unlock.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];
		},
		createLinkMenuOptions: function (item) {

			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}

			var fromArrow = _.find(this.$options._linkArrowOptionsFrom, { value: item.fromArrow });
			if (!fromArrow) {
				fromArrow = this.$options._linkArrowOptionsFrom[0];
			}
			var toArrow = _.find(this.$options._linkArrowOptionsTo, { value: item.toArrow });
			if (!toArrow) {
				toArrow = this.$options._linkArrowOptionsTo[0];
			}

			this.menuOptions = [

				{
					id: "fromArrow",
					selected: false,
					value: item.fromArrow,
					icon: fromArrow.icon,
					expanded: false,
					type: fromArrow.type == 2 ? 0 : 7,
					tooltip: "From arrow",
					subOptions: this.$options._linkArrowOptionsFrom,
					subOptionsType: "list"
				},

				{
					id: "toArrow",
					selected: false,
					value: item.toArrow,
					tooltip: "To arrow",
					icon: toArrow.icon,
					expanded: false,
					type: toArrow.type == 2 ? 0 : 7,
					subOptions: this.$options._linkArrowOptionsTo,
					subOptionsType: "list"
				},
				{
					type: -1
				},
				{
					id: "type",
					selected: false,
					//icon: "assets/js/lib/golab/icons/none.svg",
					expanded: false,
					type: 3,
					tooltip: "Line type, route & thickness",
					subOptionsType: "link_type",
					subOptions: {
						thickness: item.thickness,
						lineType: item.lineType,
						route: item.route
					}
				},
				{
					id: "fill",
					selected: false,
					value: item.fill,
					icon: "",
					expanded: false,
					tooltip: "Line color",
					type: 1,
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.fill)}
				},
				{
					type: -1
				},
				{
					id: "addText",
					selected: false,
					tooltip: "Add text",
					icon: "/assets/js/lib/golab/icons/text.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];
			// if (!_.isEmpty(item.text) || item.showText) {
			var position = {
				id: "textPosition",
				selected: false,
				value: item.textPosition,
				icon: item.textPosition == 0 ? "/assets/js/lib/golab/icons/link-text-ori-none.svg" : "/assets/js/lib/golab/icons/link-text-ori-along.svg",
				tooltip: "Text position",
				expanded: false,
				type: 0
			};
			var color = {
				id: "textColor",
				selected: false,
				value: item.textColor,
				icon: "/assets/icons/collab/text1.svg",
				expanded: false,
				tooltip: "Text color",
				type: 5,
				subOptionsType: "color_menu",
				subOptions: {colors:_colorOptions, showOpacity: false, showTransparent: false, opacity:100}
			};
			var font = {
				id: "textSize",
				selected: false,
				value: item.textSize,
				tooltip: "Text size",
				expanded: false,
				type: 4,
				subOptionsType: "text_list",
				subOptions: [{ value: 12 }, { value: 14 }, { value: 18 }, { value: 24 }, { value: 36 }, { value: 48 }, { value: 64 }, { value: 128 }]
			};
			this.menuOptions.splice(8, 0, position);
			this.menuOptions.splice(9, 0, color);
			this.menuOptions.splice(10, 0, font);
			// }
		},
		createMultipleItemMenue: function (items) {

			var _this = this;

			this.menuOptions = [];
			var itemType = items[0].category;

			var multipleTypes = false;
			var allLocked = true;
			var allUnLocked = true;

			_.each(items, function (item) {
				if (item.category !== itemType) {
					multipleTypes = true;
				}
				if (item.lock) {
					allUnLocked = false;
				}
				else {
					allLocked = false;
				}
			});

			if (multipleTypes) {
				if (allLocked) {
					this.createLockItemMenue(items[items.length - 1]);
				}
				else {

					var groupedItems = _.groupBy(items, "category");
					var allKeys = Object.keys(groupedItems);

					var _categoryToNameIcon = {
						"TEXT": { name: "Text", icon: "/assets/icons/collab/text1.svg" },
						"FRAME": { name: "Frame", icon: "/assets/icons/collab/frame-1.svg" },
						"SHAPE": { name: "Shape", icon: "/assets/icons/collab/rectangle-1.svg" },
						"FreehandDrawing": { name: "Drawing", icon: "/assets/icons/collab/pen1.svg" },
						"NOTE": { name: "Stick Note", icon: "/assets/icons/collab/note-1.svg" },
						"Arrow": { name: "Link", icon: "/assets/icons/collab/arrow-s1.svg" }
					};

					var subOptions = [];
					_.each(allKeys, key => {
						var list = groupedItems[key];

						var nameIcon = _categoryToNameIcon[key];

						var option = {
							category: key,
							value: nameIcon.name,
							count: list.length,
							list: list,
							icon: nameIcon.icon
						};
						subOptions.push(option);
					});

					var multi_objects_option = {
						id: "multiObjects",
						selected: false,
						value: "" + items.length + " Objects",
						expanded: false,
						type: 7,
						tooltip: "Selected Objects",
						subOptionsType: "object_list",
						subOptions: subOptions
					};
					this.menuOptions.push(multi_objects_option);
					if (allUnLocked) {
						this.menuOptions.push({ type: -1 });
						this.menuOptions.push({
							id: "lock",
							selected: false,
							value: "none",
							tooltip: "Lock item",
							icon: "/assets/icons/collab/unlock.svg",
							expanded: false,
							type: 0
						});
					}
				}
			}
			else {

				var lastItem = items[items.length - 1].data;
				if (lastItem.category === "FRAME") {
					this.createFrameMenuOptions(lastItem);
				}
				else if (lastItem.category === "TEXT") {
					this.createTextMenuOptions(lastItem);
				}
				else if (lastItem.category === "NOTE") {
					this.createNoteMenuOptions(lastItem);
				}
				else if (lastItem.category === "SHAPE") {
					this.createShapeMenuOptions(lastItem);
				}
				else if (lastItem.category === "Arrow") {
					this.createLinkMenuOptions(lastItem);
				}
				else if (lastItem.category === "FreehandDrawing") {
					this.createDrawingItemMenu(lastItem);
				}

				if (lastItem.category !== "Arrow" && allUnLocked) {
					var makeSameSize = {
						id: "samesize",
						selected: false,
						value: "Make Same Size",
						expanded: false,
						type: 7,
						tooltip: "Make all objects of same size",
						subOptionsType: "text_list",
						subOptions: [{ value: "Same as First", id: 0 }, { value: "Same as Last", id: 1 }, { value: "Same as Smallest", id: 2 }, { value: "Same as Biggest", id: 3 }]
						// subOptions: [{ value: "0", id: 0 }, { value: "1", id: 1 }, { value: "2", id: 2 }, { value: "3", id: 3 }]
					};
					this.menuOptions.splice(this.menuOptions.length - 3, 0, makeSameSize);
					this.menuOptions.splice(this.menuOptions.length - 3, 0, { type: -1 });
				}
			}
		},
		createLockItemMenue: function (item) {
			this.menuOptions = [
				{
					id: "unlock",
					selected: false,
					value: "none",
					tooltip: "Unlock item",
					icon: "/assets/icons/collab/lock.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];
		},
		createDrawingItemMenu: function (item) {

			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}

			this.menuOptions = [
				{
					id: "thickness",
					selected: false,
					value: item.thickness ? item.thickness : 1,
					expanded: false,
					type: 8,
					tooltip: "Thickness",
					subOptionsType: 0,
				},
				{
					type: -1
				},
				{
					id: "border",
					selected: false,
					value: item.border,
					icon: "",
					expanded: false,
					type: 2,
					tooltip: "Stroke color",
					subOptionsType: "color_menu",
					subOptions: {colors:_colorOptions, showOpacity: true, showTransparent: true, opacity:this.getOpacity(item.border)}
				},
				{
					type: -1
				},
				{
					id: "lock",
					selected: false,
					value: "none",
					tooltip: "Lock item",
					icon: "/assets/icons/collab/unlock.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];

		},
		createPictureItemMenu: function (item) {

			if (item.lock) {
				this.createLockItemMenue(item);
				return;
			}

			this.menuOptions = [
				{
					id: "lock",
					selected: false,
					value: "none",
					tooltip: "Lock item",
					icon: "/assets/icons/collab/unlock.svg",
					expanded: false,
					type: 0
				},
				{
					type: -1
				},
				{
					id: "other_options",
					selected: false,
					tooltip: "More options",
					value: "none",
					icon: "/assets/js/lib/golab/icons/more_horiz.svg",
					expanded: false,
					type: 0,
					subOptionsType: "other_options",
					options: this.getOtherOptions(item)
				}
			];

		},
		shapeToIcon: function (shape) {
			return this.$options._shapeToIcon[shape];
		},
		iconToShape: function (icon) {
			return this.$options._iconToShape[icon];
		},
		updateFrameLayout: function (layout) {

			var frames = [];
			board.model.startTransaction(MOD_TRNS_NODE_LAYOUT);
			try {
				board.selection.each(function (obj) {
					if (obj instanceof go.Group) {
						obj.data.layout = layout;
						frames.push(obj);
						board.model.updateTargetBindings(obj.data);
					}
				});
			} catch (error) {

			}
			board.model.commitTransaction(MOD_TRNS_NODE_LAYOUT);

			setTimeout(function () {
				_.each(frames, frame => {
					if (frame.layout) {
						frame.layout.isValidLayout = false;
					}
				});
				board.layoutDiagram();
			}, 200);
		},
		resizeToFitContent: function (group) {

			var allNodes = new go.List();
			group.memberParts.each(function (part) {
				if (!(part instanceof go.Link)) {
					allNodes.add(part);
				}
			});

			if (allNodes.count) {

				const membnds = group.diagram.computePartsBounds(allNodes);

				var xDelta = 0;
				var yDelta = 0;

				var margin = 10;

				xDelta = membnds.x - group.position.x + margin;
				yDelta = membnds.y - group.position.y + margin;

				var groupWidth;
				var groupHeight;

				groupWidth = membnds.size.width + xDelta;
				groupHeight = membnds.size.height + yDelta;

				group.width = groupWidth;
				group.height = groupHeight;
			}

		},
		getOpacity: function (ahex) {

			if (_.isEmpty(ahex)) {
				return 100;
			}

			ahex = ahex.substring(1, ahex.length);
			ahex = ahex.split('');

			var a = ahex[3] + ahex[3];

			if (ahex.length >= 6) {
				a = ahex[6] + (ahex[7] ? ahex[7] : ahex[6]);
			}
			var int_a = parseInt(a, 16);

			int_a = int_a / 255;
			if (int_a < 1 && int_a > 0) int_a = int_a.toFixed(2);

			if (isNaN(int_a)) {
				return 100;
			}
			else {
				return int_a * 100;
			}
		},
		addOpacity: function (color , opacity) {
			opacity = opacity / 100;
			var _opacity = Math.round(Math.min(Math.max(opacity || 1, 0), 1) * 255);
    		return color + _opacity.toString(16).toUpperCase();
		},
		//////////////////////////////////////////////////////
		////////////////    API CALLS

		//////////////////////////////////////////////////////
		////////////////    EVENTS
		onSelectOption: function (option, index) {

			if (option.type == -1) {
				return;
			}

			if (option.id == "linkArrowSwitch") {
				return;
			}

			this.selectedOption = index;

			var _this = this;

			option.expanded = true;

			if (option.id == "lock" || option.id == "unlock") {
				var lock = option.id == "lock" ? true : false;

				board.model.startTransaction(MOD_TRNS_NODE_LOCK);
				try {
					var selectedObjs = [];
					board.selection.each(function (obj) {
						obj.data.lock = lock;
						board.model.updateTargetBindings(obj.data);
						selectedObjs.push(obj);
					});
				} catch (error) {

				}
				board.model.commitTransaction(MOD_TRNS_NODE_LOCK);

				_this.setSelectedItems(selectedObjs);
				Vue.nextTick(function () {
					adjustSelectionAdronment();
				});
			}
			else if (option.id == "layout") {

				var layout;
				if (option.value == "layout") {
					layout = "none";
				}
				else {
					layout = "layout";
				}
				option.value = layout;

				this.updateFrameLayout(layout);

				board.selection.each(function (obj) {	//save auto resizing location nad size to DB
					obj.findSubGraphParts().each(function (n) {
						var updateLocation = { "_id": n.data._id, "loc": n.data.loc, "layout": obj.data.layout }
						updateNodeProperty(updateLocation);
						sendSocketRequest({ "key": n.data.key, "synId": synId, "eventType": "changeProperty", "category": "node", "loc": n.data.loc, "layout": obj.data.layout })
					});
					vueGoInstance.updateArcheTypeNodeData(obj.data.category, "layout", obj.data.layout);
					_this.setSelectedItems([obj]);
				});
			}
			else if (option.id == "textPosition") {
				option.value = option.value == 0 ? 1 : 0;
				option.icon = option.value == 0 ? "/assets/js/lib/golab/icons/link-text-ori-none.svg" : "/assets/js/lib/golab/icons/link-text-ori-along.svg";

				board.model.startTransaction(MOD_TRNS_NODE_UPD_PROP);

				try {
					board.selection.each(function (obj) {
						// obj.data.textPosition = option.value;
						// board.model.updateTargetBindings(obj.data);
						board.model.setDataProperty(obj.data, "textPosition", option.value);
						vueGoInstance.updateArcheTypeNodeData(obj.data.category, "textPosition", obj.data.textPosition);
					});
				} catch (error) {

				}

				board.model.commitTransaction(MOD_TRNS_NODE_UPD_PROP);
			}
			else if (option.id == "addText") {
				board.commandHandler.editTextBlock();
				// board.selection.each(function (node) {
				// 	if (node instanceof go.Link) {

				// 	}
				// });
			}
			else if (option.id == "showHeader") {

				option.value = !option.value;
				// if (option.value) {
				// 	board.commandHandler.editTextBlock();
				// }

				board.model.startTransaction(MOD_TRNS_NODE_UPD_PROP);
				try {
					var selectedItem = [];
					board.selection.each(function (node) {	//save auto resizing location nad size to DB
						
						board.model.setDataProperty(node.data, "showHeader", option.value);
						
						vueGoInstance.updateArcheTypeNodeData(node.data.category, "showHeader", node.data.showHeader);
						selectedItem.push(node);
					});
				} catch (error) {

				}
				board.model.commitTransaction(MOD_TRNS_NODE_UPD_PROP);

				_this.setSelectedItems(selectedItem);

				setTimeout(function () {
					_.each(selectedItem, frame => {
						if (frame.layout) {
							frame.layout.isValidLayout = false;
						}
					});
					board.layoutDiagram();
				}, 200);
			}
			else if (option.id == "other_options") {
				// other_options
				option.options = this.getOtherOptions();
			}
			else if (option.id == "fitcontent") {

				board.startTransaction(MOD_TRNS_NODE_UPD_PROP);
				try {
					var selectedItem = [];
					board.selection.each(function (node) {	//save auto resizing location nad size to DB
						_this.resizeToFitContent(node);
						selectedItem.push(node);
					});
				} catch (error) {
				}
				board.commitTransaction(MOD_TRNS_NODE_UPD_PROP);
				_this.setSelectedItems(selectedItem);
			}
		},
		onClickProperty: function (option, event) {

			var _this = this;

			event.stopPropagation();

			var mainOption = this.menuOptions[this.selectedOption];
			var value = option.value;
			var property = mainOption.id;

			var updateTargetBindings = false;

			if (property == "fill") {
				this.menuOptions[this.selectedOption].value = value;
			}
			else if (property == "figure") {
				this.menuOptions[this.selectedOption].icon = option.icon;
			}
			else if (property == "border") {
				this.menuOptions[this.selectedOption].value = option.value;
			}
			else if (property == "textSize") {
				this.menuOptions[this.selectedOption].value = option.value;
			}
			else if (property == "textColor") {
				this.menuOptions[this.selectedOption].value = option.value;
			}
			else if (property == "textFont") {
				value = option.code;
				updateTargetBindings = true;
			}
			else if (property == "textBg") {
				this.menuOptions[this.selectedOption].value = option.value;
			}
			else if (property == "textAlignment") {
				this.menuOptions[this.selectedOption].value = option.value;
			}
			else if (property == "textStyle") {
				option.selected = !option.selected;

				updateTargetBindings = true;

				value = option.selected;
				property = option.value;
			}
			else if (property == "emoji") {
				this.$emit("add-emoji", option);
			}
			else if (property == "fromArrow" || property == "toArrow") {
				mainOption.type = option.type == 2 ? 0 : 7;
				mainOption.value = option.value;
				mainOption.icon = option.icon;
			}
			else if (property == "rows") {
				mainOption.value = option.value;
				if (mainOption.value !== "Auto") {
					var otherOption = _.find(this.menuOptions, { id: "columns" });
					otherOption.value = "Auto";
				}
				var layoutOption = _.find(this.menuOptions, { id: "layout" });
				this.updateFrameLayout(layoutOption.value);
			}
			else if (property == "columns") {

				mainOption.value = option.value;
				if (mainOption.value !== "Auto") {
					var otherOption = _.find(this.menuOptions, { id: "rows" });
					otherOption.value = "Auto";
				}
				var layoutOption = _.find(this.menuOptions, { id: "layout" });
				this.updateFrameLayout(layoutOption.value);
			}
			else if (property == "multiObjects") {

				var noteSelectedItems = [];
				var selectedItems = [];

				board.selection.each(function (node) {
					if (node.data) {
						if (node.data.category != option.category) {
							noteSelectedItems.push(node);
						}
						else {
							selectedItems.push(node);
						}
					}
				});
				_.each(noteSelectedItems, item => {
					item.isSelected = false;
				});
				board.raiseDiagramEvent("ChangingSelection", board.selection);
				mainOption.expanded = false;
				this.setSelectedItems(selectedItems);

				return;
			}
			else if (property == "samesize") {

				var size;
				var scale;
				var node;

				//.. fist = 0, last = 1, smallest = 2, biggest = 3
				if (option.id == 0) {
					node = board.selection.first();
				}
				else if (option.id == 1) {
					board.selection.each(function (n) {
						node = n;
					});
				}
				else if (option.id == 2) {
					var area = 1000000;
					board.selection.each(function (n) {
						var a = n.actualBounds.size.width * n.actualBounds.size.height;
						if (a < area) {
							area = a;
							node = n;
						}
					});
				}
				else if (option.id == 3) {
					var area = 0;
					board.selection.each(function (n) {
						var a = n.actualBounds.size.width * n.actualBounds.size.height;
						if (a > area) {
							area = a;
							node = n;
						}
					});
				}
				scale = node.scale;
				size = node.actualBounds.size;

				board.startTransaction(MOD_TRNS_NODE_UPD_PROP);
				try {
					board.selection.each(function (node) {
						if (node.data.category === "TEXT") {
							board.model.setDataProperty(node.data, "width", size.width);
						}
						else if (node.data.category === "NOTE") {
							board.model.setDataProperty(node.data, "size", go.Size.stringify(size));
							board.model.setDataProperty(node.data, "scale", scale);
						}
						else {
							board.model.setDataProperty(node.data, "size", go.Size.stringify(size));
						}
					});
				} catch (error) {

				}
				board.commitTransaction(MOD_TRNS_NODE_UPD_PROP);
			}
			else if (property == "notAllowedItems") {
				// 
				if (mainOption.subOptions.selectedItems[option.id]) {
					mainOption.subOptions.selectedItems[option.id] = false;
				}
				else {
					mainOption.subOptions.selectedItems[option.id] = true;
				}
				var notAllowedItems = [];
				_.each(Object.keys(mainOption.subOptions.selectedItems), key => {
					if (!mainOption.subOptions.selectedItems[key]) {
						notAllowedItems.push(key);
					}
				});
				value = notAllowedItems;
			}

			if (property !== "notAllowedItems") {
				mainOption.expanded = false;
				this.selectedOption = -1;
			}

			board.startTransaction(MOD_TRNS_NODE_UPD_PROP);
			try {
				board.selection.each(function (obj) {

					if (property === "textSize" && obj.data && obj.data.category === "NOTE") {

						var preValue = obj.data.textSize;
						if (preValue != "Auto" && value == "Auto") {
							board.model.setDataProperty(obj.data, "autoFont", preValue);
						}
						if (preValue === "Auto" && value !== "Auto") {
							board.model.setDataProperty(obj.data, "autoFont", 8);
						}
					}

					if (property === "rows") {
						if (value !== "Auto") {
							board.model.setDataProperty(obj.data, "columns", "Auto");
							vueGoInstance.updateArcheTypeNodeData(obj.data.category, "columns", "Auto");
						}
					}
					if (property === "columns") {
						if (value !== "Auto") {
							board.model.setDataProperty(obj.data, "rows", "Auto");
							vueGoInstance.updateArcheTypeNodeData(obj.data.category, "rows", "Auto");
						}
					}

					board.model.setDataProperty(obj.data, property, value);
					if (obj.data && obj.data.category === "NOTE") {
						if (property === "textSize") {
							var result = adjustAutoFont(obj, value === "Auto", value);
							if (result.changeMode) {
								var option = _.find(_this.menuOptions, { id: "textSize" });
								option.value = result.textBlock.part.data.textSize;
							}
						}
						else if (property === "textFont") {
							var result = adjustAutoFont(obj, obj.data.textSize, obj.data.autoFont);
							if (result.changeMode) {
								var option = _.find(_this.menuOptions, { id: "textSize" });
								option.value = result.textBlock.part.data.textSize;
							}
						}
					}
					if (updateTargetBindings) {
						board.model.updateTargetBindings(obj.data);
					}
					vueGoInstance.updateArcheTypeNodeData(obj.data.category, property, value);
				});
			} catch (error) {
			}
			board.commitTransaction(MOD_TRNS_NODE_UPD_PROP);

			if (property == "textSize") {
				if (board.toolManager.textEditingTool.textBlock != null) {
					setTextAreaPoperties(board.toolManager.textEditingTool.textBlock, board, board.toolManager.textEditingTool);
				}
				setTimeout(function () {
					var updateLayout = false;
					board.selection.each(function (frame) {
						if (frame.data && frame.data.category === "FRAME" && frame.layout) {
							frame.layout.isValidLayout = false;
							updateLayout = true;
						}
					});
					if (updateLayout) {
						board.layoutDiagram();
					}
				}, 0);
			}
		},
		onChangeLinkTypeValue: function (option, property, value) {
			if (property == "thickness") {
				value = parseInt(value.target.value);
				option.subOptions.thickness = value;
			}
			else if (property == "lineType") {
				option.subOptions.lineType = value;
			}
			else if (property == "route") {
				option.subOptions.route = value;
			}
			//.............
			board.startTransaction(MOD_TRNS_NODE_UPD_PROP);
			try {
				board.selection.each(function (obj) {
					board.model.setDataProperty(obj.data, property, value);
					vueGoInstance.updateArcheTypeNodeData(obj.data.category, property, value);
				});
			} catch (error) {
			}
			board.commitTransaction(MOD_TRNS_NODE_UPD_PROP);
		},
		onTextFontSizeChange: function (option, change, event) {

			event.stopPropagation();

			var _this = this;

			var preValue = option.value;

			var index = _.findIndex(option.subOptions, function (v) {
				return v.value == option.value;
			});

			index += change;

			if (index >= option.subOptions.length) {
				index = option.subOptions.length - 1;
			}
			else if (index < 0) {
				index = 0;
			}
			var value = option.subOptions[index].value;

			if (value == "Auto" || preValue == "Auto") {
				return;
			}

			var property = "textSize";
			option.value = value;

			board.startTransaction(MOD_TRNS_NODE_UPD_PROP);
			try {
				board.selection.each(function (obj) {
					board.model.setDataProperty(obj.data, property, value);
					if (obj.data && obj.data.category === "NOTE") {
						var result = adjustAutoFont(obj, value === "Auto", value);
						if (result.changeMode) {
							var option = _.find(_this.menuOptions, { id: "textSize" });
							option.value = result.textBlock.part.data.textSize;
						}
					}
					vueGoInstance.updateArcheTypeNodeData(obj.data.category, property, value);
				});
			} catch (error) {
			}
			board.commitTransaction(MOD_TRNS_NODE_UPD_PROP);

			if (board.toolManager.textEditingTool.textBlock != null) {
				setTextAreaPoperties(board.toolManager.textEditingTool.textBlock, board, board.toolManager.textEditingTool);
			}

			setTimeout(function () {
				var updateLayout = false;
				board.selection.each(function (frame) {
					if (frame.data && frame.data.category === "FRAME" && frame.layout) {
						frame.layout.isValidLayout = false;
						updateLayout = true;
					}
				});
				if (updateLayout) {
					board.layoutDiagram();
				}
			}, 0);
		},
		onChangeSliderValue: function (event) {

			var mainOption = this.menuOptions[0];
			var property = "";
			var value = "";
			// if (mainOption.id == "pen") {
			value = parseInt(event.target.value);
			mainOption.value = value;
			property = "thickness";
			// }

			//......
			board.startTransaction(MOD_TRNS_NODE_UPD_PROP);
			try {
				board.selection.each(function (obj) {
					board.model.setDataProperty(obj.data, property, value);
					vueGoInstance.updateArcheTypeNodeData(obj.data.category, property, value);
				});
			} catch (error) {
			}
			board.commitTransaction(MOD_TRNS_NODE_UPD_PROP);
		},
		onContextMenuCommand: function (event, value, option) {

			if (option && !option.enabled) {
				return;
			}

			event.stopPropagation();

			var option = _.find(this.menuOptions, { id: "other_options" });
			option.expanded = false;

			onContextMenuCommand(event, value);
		},
		onCloseAllowedItemList: function (event) {
			event.stopPropagation();
			this.selectedOption = -1;
		},
		//////////////////////////////////////////////////////
		////////////////    INPUT
		setSelectedItems: function (items) {
			if (vueGoInstance.userRights.canWrite) {
				this.selectedOption = -1;
				if (items.length == 1) {
					var item = items[0];
					if (item.type && item.type.va == "Link") {
						this.createLinkMenuOptions(item.data);
					}
					else {
						if (item.data.category === "FRAME") {
							this.createFrameMenuOptions(item.data);
						}
						else if (item.data.category === "TEXT") {
							this.createTextMenuOptions(item.data);
						}
						else if (item.data.category === "NOTE") {
							this.createNoteMenuOptions(item.data);
						}
						else if (item.data.category === "SHAPE") {
							this.createShapeMenuOptions(item.data);
						}
						else if (item.data.category === "Arrow") {
							this.createLinkMenuOptions(item.data);
						}
						else if (item.data.category === "FreehandDrawing") {
							this.createDrawingItemMenu(item.data);
						}
						else if (item.data.category === "PICTURE") {
							this.createPictureItemMenu(item.data);
						}
					}
				} else {
					var _items = [];
					_.each(items, item => {
						_items.push(item.data);
					});
					this.createMultipleItemMenue(items);
				}

				Vue.nextTick(function () {
					updateNodeEditingMenu();
				});
			}
		}
	}
});

const NoteEditor = Vue.component('note-editor', {
	name: 'note-editor',
	props: ["board", "user", "users"],
	components: {
		//'ckeditor': CKEditor.component,
	},
	template:
		`	<div>
			
			<div class="row" style="padding-top: 20px;">
		        <div class="col-7">
		            <h1>Collaborative Editor</h1>
		        </div>
	   		 </div>
			
			<div class="usrsh">
				<div class="picu a" v-if="users">
					<div :class="[showActiveEditor?'active':'']" v-if="data.noteActiveUserStatus" v-for="(data,index) in activeUsers" style="padding-top: 6px;border-radius: 50px; background-color:red; width:34px; height: 34px;text-align:center;">
						{{getUserInitials(data.firstName, data.lastName)}}
					</div>
				</div>
			</div>
				
			<!--<ckeditor :config="editorConfig" ref="noterefs" :editor="notesEditor" v-model="activeText"  @keyup="autoSave"></ckeditor>-->
		</div>
	`,
	data() {
		return {
			activeText: '',
			saved: '',
			editorConfig: EDITOR_CONFIG,
			notesEditor: ClassicEditor,
			showActiveEditor: false,
			note: '',
			//collaboratorsList: [],
		}
	},
	created() {
		//this.activeText = this.board.noteDescription;
		this.activeUsers = this.users;
		this.getNoteDescription(this.board.id);
	},
	mounted() {
		setTimeout(() => {
			hamnaEditor = vueGoInstance.$children[1].$children[0].instance;
		}, 2000);
		this.activeUsers = this.users;

	},
	methods: {
		check: function () {
			console.log("Key down");
		},
		getNoteDescription: function (boardId) {
			//	var data = {id: boardId }
			axios.post("/graphx/note/" + boardId)
				.then(response => {
					console.log(response);
					if (response) {
						this.note = response.data.note;
						this.activeText = this.note.description;
					}
				})
				.catch(error => {

				});
		},
		saveNoteDescription: function (text) {
			//var _this = this;
			var data = { description: text, id: this.board.id }
			axios.post("/graphx/note/save", data)
				.then(response => {
					//_this.board.noteDescription = response.data.board.noteDescription;
					//sendSocketRequest({"synId": synId,"category":"note", "eventType": "saveNote", "saveNote" : _this.board.noteDescription });
					this.activeText = response.data.note.description;
					this.note.description = response.data.note.description;
					//showTopMessage('Note saved', 'success');
				})
				.catch(error => {

				});
		},

		autoSave: function () {
			setTimeout(() => {
				applyLocalChanges(this.board.id, this.user.id);
				this.saveNoteDescription(this.activeText);
			}, 1000);

		},

		getActiveUsers: function () {
			var collaborators = this.board.collaborators;
			if (collaborators) {
				_.each(collaborators, collaborator => {
					_.each(this.activeUsers, user => {
						if (collaborator.user.id == user) {

							this.getUserInitials(collaborator.user.firstName, collaborator.user.lastName);

						}
					})
				});
			}
		},

		getUserInitials: function (firstName, lastName) {
			var initials = "";
			//	if (this.user) {
			if (!_.isEmpty(firstName)) {
				initials += firstName.substring(0, 1);
			}
			if (!_.isEmpty(lastName)) {
				initials += lastName.substring(0, 1);
			}
			//	}
			return initials.toUpperCase();
		},

	}

});

const CanvasFolder = Vue.component('canvas-folder', {
	name: 'canvas-folder',
	props: ["folder", "parentFolderId", "index", "folderType", "view", "selectedFolderContent"],
	template: `


		<!--
		---------------------------------------------------------------------------------------------------------------------------
		<li v-if="folder && !folder.archived">
          <a href="javascript:void(0)" style="font-size:15px; padding-top:10px;" class="FL" v-on:click="onClickFolder(folder)">{{folder.title}}</a>
          <div class="seccog" style="top:17px;">
			
			<span v-if="!folder.folderId">
			
			<div class='crtboard button FR' data-overlayopener="card-menu" @click="showCreateOptionsMenu = !showCreateOptionsMenu;"><img src="/assets/icons/collab/plus.svg" alt="plus" />Create</div>
			<vuepopup v-if="showCreateOptionsMenu" @close="showCreateOptionsMenu = false;">
				<div id="card-menu" class="drop_box fmn-over" style="display:block;margin-left: 820px;">
					<ul>
						<li><a href="javascript:void(0)" v-on:click="createBoard(folder.id)"  title='Create Board'>Create Board</a></li>
				   		<li><a href="javascript:void(0)" v-on:click="createFolder(folder.id)"  title='Create Folder'>Create Folder</a></li>
					</ul>
				</div>
			</vuepopup>
			</span>
			
			<span v-if="folderType != 'rootFolder'">
			
			<div class='crtboard button FR' data-overlayopener="card-menu" @click="showMenu = !showMenu;"><i class='ti-plus ico'></i>Edit/Delete</div>
			<vuepopup v-if="showMenu" @close="showMenu = false;">
				<div id="card-menu" class="drop_box fmn-over" style="display:block;margin-left: 700px;">
					<ul>
						<li><a href="javascript:void(0)" v-on:click="onClickEdit(folder)"> {{!folder.folderId ? 'Edit Folder': 'Edit Board'}}</a></li>
				   		<li><a href="javascript:void(0)" v-on:click="confirmDelete(folder.id, index, parentFolderId)">{{!folder.folderId ? 'Delete Folder': 'Delete Board'}}</a></li>
					</ul>
				</div>
			</vuepopup>
			
			<div  v-if="folder.folderId" > 
				<a v-if=" folder.favorite" href="javascript:void(0)" @click="markFavorite()"><img src="/assets/icons/collab/star.svg" alt="star" />unstar</a>
				<a v-else="!folder.favorite" href="javascript:void(0)" @click="markFavorite()"><img src="/assets/icons/collab/star-s.svg" alt="star" />star</a>
				
				<a v-if="folder.locked" href="javascript:void(0);" @click="lockUnLockBoard()" class="url" ><img src="/assets/icons/collab/lock.svg" alt="lock" /> Unlock</a>	
				<a v-else="!folder.locked" href="javascript:void(0);" @click="lockUnLockBoard()"><img src="/assets/icons/collab/unlock.svg" alt="lock" /> Lock</a>
				
				<a v-if="!folder.archived" href="javascript:void(0);" class="sesico delbrd" @click="onArchiveBoard()"><i class="ti-archive"></i>Archive</a>	
				
				<a id="copySession" @click="openDuplicateBoardDialog()" class="txt" href="javascript:void(0);"> <i class="ti-layers ico-img"></i>Copy Board</a> 

			
			</div>
			</span>
          </div>
        </li>

      <create-board v-if="createFolderPopup.show" :list="foldersList" :event-type="eventType" :id="rootFolderId" :type="createFolderPopup.type" :model="createFolderPopup.model" @close-popup="closeBoardPopup" @save="onFolderCreate" @update="onFolderUpdate" @duplicate-board="onDuplicateBoard"></create-board>
	  
	<div v-if="folder && folder.canvasFolder && showSubItems">
		<div v-for="(subFolder, index) in folder.canvasFolder">
			<canvas-folder :folder="subFolder" :parent-folder-id="folder.id" :index="index"></canvas-folder>
		</div>
	</div>
	
	<div v-if="folder && folder.canvasBoard && showBoards">
		<div v-for="(subFolder, index) in folder.canvasBoard">
			<div v-if="!subFolder.archived">
				<canvas-folder :folder="subFolder" :parent-folder-id="folder.id" :index="index"></canvas-folder>
			</div>
		</div>
	</div>-->
	
	
	<!-- FOLDER BASED IMPLEMENTATION-->
	
	<!--<div v-if="folderType == 'rootFolder'">
		<div v-if="folder && folder.canvasFolder && showSubItems">
			<div v-for="(subFolder, index) in folder.canvasFolder">
				<canvas-folder :folder="subFolder" :parent-folder-id="folder.id" :index="index"></canvas-folder>
			</div>
		</div>
		
		<div v-if="folder && folder.canvasBoard && showRootBoards">
			<div v-for="(subFolder, index) in folder.canvasBoard">
				<div v-if="!subFolder.archived">
					<canvas-folder :folder="subFolder" :parent-folder-id="folder.id" :index="index"></canvas-folder>
				</div>
			</div>
		</div>
	</div>
	---------------------------------------------------------------------------------------------------------------------------
			<div class="hd">
				<div class="rc c1"></div>
				<div class="rc c2">Owner</div>
				<div class="rc c2">Modified</div>
				<div class="rc c3">Starred</div>
			</div>
	-->
	
<span class="wrklist" :class="[folder.folderId ? 'board' : 'folder']">
	<div v-if="folder" class="prow" :class="[view == 'grid'? 'grid' : 'list']">
		<a v-if="!folder.isSystem" class="ti-more-alt icomr" href="javascript:void(0)" @click="showAddNewMenu = true;" title="Settings"></a>
		<template>
		<vuepopup v-if="showAddNewMenu" @close="showAddNewMenu = false;">
			<div id="addFeatMenu" class="drop_box nwmu artp" style="display:block">
			<!-- BOARD -->
			<ul v-if="folder.folderId && !folder.archived">
				<li>
					<a v-if="folder.locked" href="javascript:void(0);" @click="lockUnLockBoard()"><img class="ico" src="/assets/icons/collab/lock.svg" alt="lock" /> Unlock</a>	
					<a v-else="!folder.locked" href="javascript:void(0);" @click="lockUnLockBoard()"><img class="ico" src="/assets/icons/collab/unlock.svg" alt="lock" /> Lock</a>		
				</li>
				<li v-if="folder.type != 'template'">
					<a v-if="!folder.archived" href="javascript:void(0);" @click="onArchiveBoard()"><em class="ico ti-archive"></em>Archive</a>	
				</li>
				<li>
					<a id="copySession" @click="openDuplicateBoardDialog()" href="javascript:void(0);"> <em class="ico ti-layers"></em>Copy</a> 
				</li>
				<li>
					<a href="javascript:void(0)" v-on:click="onClickEdit(folder)"><img src="/assets/icons/collab/edit-blk.svg" alt="Edit" class="ico" />Edit</a>
				</li>
		   		<li>
					<a v-if="folder.type != 'template'" href="javascript:void(0)" v-on:click="confirmDelete(folder.id,parentFolderId, folder)"><img class="ico" src="../assets/icons/collab/trash.svg" alt="Trash" />Delete</a>
					<a v-else href="javascript:void(0)" v-on:click="confirmDelete(folder.id, folder)"><img class="ico" src="../assets/icons/collab/trash.svg" alt="Trash" />Delete</a>
				</li>					
			</ul>
			
			<ul v-if="folder.folderId && folder.archived">
				<li>
					<a href="javascript:void(0);" @click="onUnArchiveBoard()"><em class="ico ti-archive"></em>Unarchive</a>	
				</li>
			</ul>
			
			<!-- FOLDER -->
			<ul v-if="!folder.folderId">
				<!--<li><a href="javascript:void(0)" v-on:click="createBoard(folder.id)"  title='Create Board'>Create Board</a></li>
			   		<li><a href="javascript:void(0)" v-on:click="createFolder(folder.id)"  title='Create Folder'>Create Folder</a></li>-->
				<li>
					<a href="javascript:void(0)" v-on:click="onClickEdit(folder)"><img src="/assets/icons/collab/edit-blk.svg" alt="Edit" class="ico" />Edit</a>
				</li>
			   	<li>
					<a href="javascript:void(0)" v-on:click="confirmDelete(folder.id,parentFolderId, folder)"><img class="ico" src="../assets/icons/collab/trash.svg" alt="Trash" />Delete</a>
				</li>
			</ul>
			</div>
		</vuepopup>
		</template>
		
		<div class="c-point mrow miout" @click="onClickFolder(folder)">
			<span class="docs" v-if="!folder.folderId">{{getDocumentsCount(folder)}} docs</span>
			<!--<div class="midico" :class="[folder.folderId ? widgetTextStyle(folder) : 'folder']"></div>	-->
			<div class="midico DAJ" :class="[folder.folderId ? 'board' : 'folder']" :style="{background:widgetTextStyle(folder)}"><img id='board-image' v-if="folder.folderId && folder.thumbnailPath" :src="boardThumbnailPath" alt='Preview' /></div>
	
			<span v-if="!folder.folderId">			
				<div class='crtboard button FR' data-overlayopener="card-menu" @click="showCreateOptionsMenu = !showCreateOptionsMenu;"><img src="/assets/icons/collab/plus.svg" alt="plus" />Create</div>			
				<vuepopup v-if="showCreateOptionsMenu" @close="showCreateOptionsMenu = false;">
					<div id="card-menu" class="drop_box fmn-over" style="display:block;">
						<ul>
							<li><a href="javascript:void(0)" v-on:click="createBoard(folder.id)"  title='Create Board'>Create Board</a></li>
					   		<li><a href="javascript:void(0)" v-on:click="createFolder(folder.id)"  title='Create Folder'>Create Folder</a></li>
						</ul>
					</div>
				</vuepopup>			
			</span>
		</div>
			
		<div class="btmbr tltp">
			<div class="rc c1 ttl">
				<a :href="getFolderPath(folder)" class="elp" >{{folder.title}}</a>
				<span class="docin" v-if="!folder.folderId">{{getDocumentsCount(folder)}} documents</span>
			</div>
			<div class="light elp" @click=" onClickFolder(folder)">
				<span class="cbnme rc c2">{{getUserFullname(folder)}}</span>
				<span class="dsn">,</span> 
				<span class="dt rc c2">{{formatDate(folder.createdOn)}}</span>
			</div>
			<div class="tltphv tp"><span>Created by {{getUserFullname(folder)}} on {{formatDate(folder.createdOn)}} at {{formatTime(folder.createdOn)}}</span></div>
			
			<div v-if="folder.folderId && !folder.archived && (folder.type != 'template')" class="star rc c3">
				<a v-if="folder.favorite" href="javascript:void(0)" @click="markFavorite(false)" class="fll"><img src="/assets/icons/collab/star-fll-14.svg" alt="star" /></a>
				<a v-else="!folder.favorite" href="javascript:void(0)" @click="markFavorite(true)" class="emp"><img src="/assets/icons/collab/star-emp-14.svg" alt="star" /></a>
			</div>	
					
		</div>	
		</div>
	
		<create-board v-if="createFolderPopup.show" :list="foldersList" :event-type="eventType" :id="rootFolderId" :type="createFolderPopup.type" :model="createFolderPopup.model" @close-popup="closeBoardPopup" @save="onFolderCreate" @update="onFolderUpdate" @duplicate-board="onDuplicateBoard"></create-board>

		<div v-if="folder && folder.canvasFolder && showSubItems">
			<div v-for="(subFolder, index) in folder.canvasFolder">
				<canvas-folder :folder="subFolder" :parent-folder-id="folder.id" :index="index"></canvas-folder>
			</div>
		</div>
	
		<div v-if="folder && folder.canvasBoard && showBoards">
			<div v-for="(subFolder, index) in folder.canvasBoard">
				<div v-if="!subFolder.archived">
					<canvas-folder :folder="subFolder" :parent-folder-id="folder.id" :index="index"></canvas-folder>
				</div>
			</div>		
		</div>
	</span>
	`,
	data() {
		return {
			createFolderPopup: { show: false, model: {}, type: '' },
			rootFolderId: '',
			favoriteBoards: [],
			archivedBoards: [],
			showSubItems: false,
			showBoards: true,
			showRootBoards: false,
			showCreateOptionsMenu: false,
			showMenu: false,
			eventType: '',
			foldersList: [],
			templatesList: [],
			boardIdKey: '',
			showAddNewMenu: false,
			breadcrumbsArray: [],
			boardView: '',
			boardThumbnailPath: '',
		}
	},
	created() {

		if (this.folderType == 'rootFolder') {
			this.showSubItems = true;
			this.showRootBoards = true;
		}

	},
	mounted() {
		this.boardView = this.view;
	},
	computed: {
	},
	methods: {
		getUserFullname: function (folder) {
			var collaborators = folder.collaborators;
			var fullname;
			if (collaborators) {
				_.each(collaborators, collaborator => {
					if (collaborator.admin == true) {
						fullname = collaborator.user.fullName;
					}
					/*if (collaborator.user.id == loggedInUser.id) {
						fullname = loggedInUser.fullName;
					}*/
				});
			}
			return fullname;
		},
		getFavoriteBoard: function (board) {
			this.favoriteBoards = store.getters.getFavoriteBoardsList();
			if (this.favoriteBoards) {
				_.each(this.favoriteBoards, favboard => {
					if (favboard.id == board.id) {
						board.favorite = favboard.favorite;
					}
				});
			}
			return board.favorite;
		},
		widgetTextStyle: function (folder) {
			if (folder.folderId) {
				if (folder.thumbnailPath) {
					// Use MongoDB GridFS endpoint instead of S3
					this.boardThumbnailPath = "/upload/retrieve-image/" + folder.thumbnailPath;
				} else {
					//this.boardThumbnailPath = "assets/icons/collab/nw-board.svg";
					this.boardThumbnailPath = 'board'
				}
			}
			return this.boardThumbnailPath;
		},
		getFolderPath: function (folder) {
			if (!folder.archived) {
				return window.location.origin + window.location.pathname + "#/" + folder.id;
			}
		},
		formatDate: function (_date) {
			if (!_date) {
				return "";
			}
			var date = new Date(_date);
			return date.format("d mmm yyyy");
		},
		formatTime: function (_date) {
			if (!_date) {
				return "";
			}
			var date = new Date(_date);
			return date.format("h:MM");
		},
		getDocumentsCount: function (folder) {
			let stack = [];
			var documentsCount = 0;

			if (folder.canvasBoard) {
				_.each(folder.canvasBoard, board => {
					if (board) {
						documentsCount = documentsCount + 1;
					}
				});
			}

			if (folder.canvasFolder) {
				_.each(folder.canvasFolder, folder => {
					if (folder) {
						documentsCount = documentsCount + 1;
						stack.push(folder);
					}
				});
			}

			while (stack.length > 0) {
				var folder = stack.pop();
				if (folder.canvasBoard != undefined) {
					_.each(folder.canvasBoard, board => {
						if (board) {
							documentsCount = documentsCount + 1;
						}
					});
				}
				if (folder.canvasFolder) {
					_.each(folder.canvasFolder, folder => {
						if (folder) {
							documentsCount = documentsCount + 1;
							stack.push(folder);
						}
					});
				}

			}

			return documentsCount;
		},
		onClickFolder: function (folder) {
			if (!folder.archived) {
				if (folder.folderId) {
					this.$router.push('/detail/' + folder.id);
				} else {
					this.$parent.hideNewFolderButton = true;
					this.$parent.selectedFolderContent = [];

					this.$router.push('/' + folder.id);

					var folder1 = _.find(this.$parent.breadCrumbsName, { id: folder.id });

					if (!folder1) {
						this.$parent.breadCrumbsName.push(folder);
					}
				}
			}


			this.$forceUpdate();
		},
		createFolder: function (id) {
			this.createFolderPopup.model = {};
			this.createFolderPopup.show = true;
			this.createFolderPopup.type = 'folder';
			this.rootFolderId = id;
		},
		createBoard: function (id) {
			this.createFolderPopup.model = {};
			this.createFolderPopup.show = true;
			this.createFolderPopup.type = 'board';
			this.rootFolderId = id;
		},
		onFolderCreate: function (dataModel, type, id, template) {
			if (type == 'board') {
				this.onBoardCreate(dataModel, id, template);
			} else {
				if (dataModel.title === "") {
					console.log("your title is empty")
				} else {
					var data = { title: dataModel.title, id: id }
					axios.post("/graphx/folder/create", data)
						.then(response => {
							//	alert('Folder created successfully');
							showTopMessage('Folder created successfully', 'success');

							this.createFolderPopup.show = false;
							if (!this.folder.canvasFolder) {
								this.folder.canvasFolder = [];
							}
							this.folder.canvasFolder.push(response.data.folder);
							this.foldersList = store.getters.getFoldersList();
							this.foldersList.push(response.data.folder);
							store.commit('setFoldersList', this.foldersList);
						})
						.catch(error => {

						});
				}
			}

		},
		onBoardCreate: function (dataModel, folderId, template) {
			if (dataModel.title === "") {
				console.log("your title is empty")
			} else if (template) {
				console.log(template);
				var data = { title: dataModel, folderId: folderId, templateId: template.id }
				axios.post("/graphx/board/create/using_template", data)
					.then(response => {
						showTopMessage('Board created successfully', 'success');
						console.log(response);
						this.createFolderPopup.show = false;

						this.folder.canvasBoard = response.data.folder.canvasBoard;
						this.$router.push('/detail/' + response.data.boardId);
					})
					.catch(error => {

					});
			}
			else {
				var data = { title: dataModel.title, folderId: folderId }
				axios.post("/graphx/board/create", data)
					.then(response => {
						showTopMessage('Board created successfully', 'success');
						console.log(response);
						this.createFolderPopup.show = false;

						this.folder.canvasBoard = response.data.folder.canvasBoard;
						//this.$router.push('/detail/' + response.data.board.id);
					})
					.catch(error => {

					});
			}


		},
		onClickEdit: function (folder) {
			this.createFolderPopup.model = { _id: folder.id, title: folder.title };
			this.createFolderPopup.show = true;

			if (!folder.folderId) {
				this.createFolderPopup.type = 'folder';
				this.eventType = 'edit-folder';
			} else {
				if (folder.type == 'template') {
					this.createFolderPopup.type = 'template';
				} else {
					this.createFolderPopup.type = 'board';
				}

				this.eventType = 'edit-board';
			}
		},
		openDuplicateBoardDialog: function () {
			this.createFolderPopup.model = { _id: this.folder.id, title: this.folder.title + '-Copy' };
			this.createFolderPopup.show = true;

			if (this.folder.type == 'template') {
				this.createFolderPopup.type = 'template';
			} else {
				this.createFolderPopup.type = 'board';
			}

			this.eventType = 'duplicateBoard';
			//this.foldersList = this.list;
		},
		onDuplicateBoard: function (dataModel, type, selectedFolder) {
			console.log(selectedFolder);

			if (!selectedFolder && type == 'board') {
				//showTopMessage('Please select folder', 'warning');
			}
			else {
				if (type == 'board') {
					var data = { title: dataModel.title, boardIdToBeCopied: dataModel._id, folderId: selectedFolder.id }
					axios.post("/graphx/board/duplicate", data)
						.then(response => {
							showTopMessage('Board copied successfully', 'success');
							console.log(response.data.board);
							this.createFolderPopup.show = false;

							this.foldersList = store.getters.getFoldersList();

							var folder = _.find(this.foldersList, { id: selectedFolder.id });
							if (folder) {
								if (!folder.canvasBoard) {
									folder.canvasBoard = [];
								}
								folder.canvasBoard.push(response.data.board);
							}
							//this.foldersList.push(folder);
							store.commit('setFoldersList', this.foldersList);
							this.$router.push('/detail/' + response.data.board.id);
						})
						.catch(error => {
							console.log(error);
						});
				}
				if (type == 'template') {
					var data = { title: dataModel.title, boardIdToBeCopied: dataModel._id }
					axios.post("/graphx/template/duplicate", data)
						.then(response => {
							showTopMessage('Template copied successfully', 'success');
							console.log(response.data.template);
							this.createFolderPopup.show = false;

							this.templatesList = store.getters.getTemplates();

							this.templatesList.push(response.data.template);

							store.commit('setTemplate', this.templatesList);

							//	this.$router.push('/detail/' + response.data.template.id);

							this.$parent.selectedFolderContent.push(response.data.template)

						})
						.catch(error => {
							console.log(error);
						});
				}
			}
		},
		onFolderUpdate: function (dataModel, type, selectedFolder) {
			if (type == 'board') {
				this.onBoardUpdate(dataModel, selectedFolder);
			} else {
				if (dataModel.title === "") {
					//showTopMessage('Folder title cannot be empty', 'warning');
				} else {
					var data = { title: dataModel.title, id: dataModel._id }
					axios.post("/graphx/folder/update", data)
						.then(response => {
							console.log(response);
							this.createFolderPopup.show = false;
							showTopMessage("Folder title updated", 'success');

							if (this.folder.id == response.data.folder.id) {
								this.folder.title = response.data.folder.title;
							}
							//this.$router.push('/detail/' + response.data.boardId);
						})
						.catch(error => {
							console.log(error);
						});
				}
			}
		},
		onBoardUpdate: function (dataModel, selectedFolder) {
			if (dataModel.title === "") {
				//showTopMessage('Title cannot be empty', 'warning');
			} else {
				currentFolderId = this.$route.params["id"];
				var data = { title: dataModel.title, id: dataModel._id, selectedFolderId: selectedFolder.id, currentFolderId: currentFolderId }
				axios.post("/graphx/board/update", data)
					.then(response => {
						if (response) {
							this.createFolderPopup.show = false;

							//update title of board on client side
							_.each(this.$parent.selectedFolderContent, board => {
								if (board.id == response.data.board.id) {
									if (_.isEmpty(selectedFolder)) {
										showTopMessage("Title updated", 'success');
										board.title = dataModel.title;
									}

									if (!_.isEmpty(selectedFolder)) {
										board.folderId = selectedFolder.id;
									}

								}
							});

							if (!_.isEmpty(selectedFolder)) {
								showTopMessage("Board moved successfully", 'success');
								//get selected folder from folders list and move the new board
								var folder = _.find(this.$parent.foldersList, { id: selectedFolder.id });
								if (folder) {
									if (!folder.canvasBoard) {
										folder.canvasBoard = [];
									}
									folder.canvasBoard.push(response.data.board);
								}

								//delete from current context and current folder
								var index = _.findIndex(this.$parent.selectedFolderContent, { id: response.data.board.id });
								if (index > -1) {
									this.$parent.selectedFolderContent.splice(index, 1);
								}

								var currentFolder = _.find(this.$parent.foldersList, { id: currentFolderId });
								if (currentFolder) {
									if (currentFolder.canvasBoard) {
										var find = _.findIndex(currentFolder.canvasBoard, { id: response.data.board.id });
										if (find > -1) {
											currentFolder.canvasBoard.splice(find, 1);
										}
									}
								}
							}
						}
						//this.$router.push('/detail/' + response.data.boardId);
					})
					.catch(error => {
						console.log(error);
					});
			}
		},
		getBoardsListMappedById: function (folder) {
			var boardMappedbyId = {};
			let stack = [];

			if (folder.canvasBoard) {
				_.each(folder.canvasBoard, board => {
					if (board) {
						this.boardsList.push(board);
					}
				});
			}

			if (folder.canvasFolder) {
				_.each(folder.canvasFolder, folder => {
					if (folder) {
						stack.push(folder);
					}
				});
			}

			while (stack.length > 0) {
				var folder = stack.pop();
				if (folder.canvasBoard != undefined) {
					_.each(folder.canvasBoard, board => {
						if (board) {
							this.boardsList.push(board);
						}
					});
				}
				if (folder.canvasFolder) {
					_.each(folder.canvasFolder, folder => {
						if (folder) {
							stack.push(folder);
						}
					});
				}

			}
			return this.boardsList;

		},
		confirmDelete: function (id, parentFolderId, folder) {
			if (!this.folder.folderId) {
				askFromSweetAlertWrapper("This will delete the folder.",
					[this.deleteFolder, [id, parentFolderId, folder]], [takeNoAction]);
			} else if (this.folder.type == 'template') {
				askFromSweetAlertWrapper("This will delete the template.",
					[this.deleteTemplate, [id, parentFolderId, folder]], [takeNoAction]);
			}
			else {
				askFromSweetAlertWrapper("This will delete the board.",
					[this.deleteFolder, [id, parentFolderId, folder]], [takeNoAction]);
			}
		},
		deleteTemplate: function (data) {
			var templateId = data[0];
			axios.delete('/graphx/delete/template/' + templateId)
				.then(response => {
					if (response.data.itemRemoved > 0) {
						showTopMessage("Template deleted successfully", "success");
						this.removeTemplates(templateId);

						// delete the target template
						//const index = this.$parent.selectedFolderContent.indexOf(data[2]);
						var index = _.findIndex(this.$parent.selectedFolderContent, { id: templateId });
						if (index > -1) {
							this.$parent.selectedFolderContent.splice(index, 1);
						}
					}
				})
				.catch(error => {

				});
		},
		removeTemplates: function (templateId) {
			this.templates = store.getters.getTemplates();
			var index = _.findIndex(this.templates, { id: templateId });
			if (index > -1) {
				this.templates.splice(index, 1);
			}
			return store.commit('setTemplate', this.templates);
		},
		deleteFolder: function (data) {
			if (!this.folder.folderId) {
				//delete folder
				//if (confirm("Do you want to delete this folder.It will delete all the folders and boards in it?") == true) {
				axios.delete('/graphx/delete/folder/' + data[0] + '/' + data[1])

					.then(response => {
						if (response.data.itemRemoved > 0) {
							showTopMessage('Folder deleted successfully', 'success');
							//first remove boards of target folder from archived boards list
							var list = this.getBoardsListMappedById(this.folder);

							this.archivedBoards = store.getters.getArchivedBoards();
							var archBoardsList = _.cloneDeep(this.archivedBoards);
							if (this.archivedBoards) {
								_.each(this.archivedBoards, board => {
									if (list[board.id]) {
										const index = archBoardsList.indexOf(board.id);
										archBoardsList.splice(index, 1);
										store.commit('setArchivedBoards', archBoardsList);

									}
								});
							}

							//removing boards from fav list
							this.favoriteBoards = store.getters.getFavoriteBoardsList();
							var favBoards = _.cloneDeep(this.favoriteBoards);
							if (this.favoriteBoards) {
								_.each(this.favoriteBoards, board => {
									if (list && list[board.id]) {
										var boardPosition = _.findIndex(this.favoriteBoards, { id: board.id });
										favBoards.splice(boardPosition, 1);
										store.commit('setFavoriteBoards', favBoards);
										this.$forceUpdate();
									}
								});
							}
							//delete folder from store
							this.foldersList = store.getters.getFoldersList();
							var folderPos = _.findIndex(this.foldersList, { id: data[0] });
							if (folderPos > -1) {
								this.foldersList.splice(folderPos, 1);
							}
							store.commit('setFoldersList', this.foldersList);

							//then delete the target folder
							const index = this.$parent.selectedFolderContent.indexOf(data[2]);
							if (index > -1) {
								this.$parent.selectedFolderContent.splice(index, 1);
							}
						}
					})
					.catch(error => {
						console.log(error);
					});
				//}
			} else {
				//delete board
				var boardId = data[0];
				var folderId = data[1];
				var board = data[2];

				axios.delete('/graphx/delete/board/' + boardId + '/' + folderId)
					.then(response => {
						showTopMessage('Board deleted successfully', 'success');
						if (response.data.itemRemoved > 0) {
							//then delete the target board
							const index = this.$parent.selectedFolderContent.indexOf(board);
							if (index > -1) {
								this.$parent.selectedFolderContent.splice(index, 1);
							}

							this.foldersList = store.getters.getFoldersList();
							var folder = _.find(this.foldersList, { id: this.$route.params["id"] });
							if (folder) {
								if (folder.canvasBoard) {
									_.each(folder.canvasBoard, board => {
										if (board.id == boardId) {
											var boardPosition = _.findIndex(folder.canvasBoard, { id: board.id });
											folder.canvasBoard.splice(boardPosition, 1);
											store.commit('setFoldersList', this.foldersList);
											this.$forceUpdate();
										}
									});
								}
							}
							this.removeFavoriteBoards(boardId);
							this.removeArchivedBoards(boardId);
						}
					})
					.catch(error => {
						console.log(error);
					});
			}
		},
		markFavorite: function (starredFlag) {
			var _this = this;
			var data = {};
			data.uid = loggedInUser.id;
			data.boardId = this.folder.id;
			data.starred = starredFlag;

			axios.post('/graphx/mark-favorite', data)
				.then(response => {
					if (response.data.board) {
						_this.folder.favorite = response.data.board.favorite;
						if (_this.folder.favorite)  //if true
						{
							showTopMessage('Board marked favorite', 'success');
							_this.saveFavoriteBoards(_this.folder);
						}
						else {
							showTopMessage('Board marked unfavorite', 'success');
							_this.removeFavoriteBoards(_this.folder.id);
						}
					}
					_this.$forceUpdate();

				})
				.catch(error => {
					console.log(error);
				});
		},
		lockUnLockBoard: function () {
			var _this = this;
			axios.post('/graphx/lock-board/' + _this.folder.id)
				.then(response => {
					if (response.data.board) {
						_this.folder.locked = response.data.board.locked;
						if (_this.folder.locked) {
							if (_this.folder.type != 'template') {
								showTopMessage('Board locked successfully', 'success');
							} else {
								showTopMessage('Template locked successfully', 'success');
							}

						} else {
							if (_this.folder.type != 'template') {
								showTopMessage('Board unlocked successfully', 'success');
							} else {
								showTopMessage('Template unlocked successfully', 'success');
							}

						}
					}
				})
				.catch(error => {
					console.log(error);
				})
		},
		onArchiveBoard: function () {
			var _this = this;
			axios.get('/graphx/archive-board/' + _this.folder.id)
				.then(response => {
					if (response.data.board) {
						_this.folder.archived = response.data.board.archived;
						if (_this.folder.archived) {
							_this.saveArchivedBoards(_this.folder);
							_this.$forceUpdate();
							showTopMessage('Board archived successfully', 'success');
						}
					}
				})
				.catch(error => {
					console.log(error);
				})
		},
		onUnArchiveBoard: function () {
			var _this = this;
			//unarchive it and remove from archived boards list
			axios.get('/graphx/archive-board/' + _this.folder.id)
				.then(response => {
					if (response.data.board) {
						showTopMessage('Board unarchived successfully', 'success');
						_this.folder.archived = response.data.board.archived;
						_this.removeArchivedBoards(_this.folder.id);
						_this.$forceUpdate();
					}
				})
				.catch(error => {
					console.log(error);
				});
		},
		saveFavoriteBoards: function (board) {
			this.favoriteBoards = store.getters.getFavoriteBoardsList();
			this.favoriteBoards.push(board);
			return store.commit('setFavoriteBoards', this.favoriteBoards);
		},
		removeFavoriteBoards: function (boardId) {
			this.favoriteBoards = store.getters.getFavoriteBoardsList();
			var index = _.findIndex(this.favoriteBoards, { id: boardId });
			if (index > -1) {
				this.favoriteBoards.splice(index, 1);
			}
			return store.commit('setFavoriteBoards', this.favoriteBoards);
		},
		saveArchivedBoards: function (board) {
			this.archivedBoards = store.getters.getArchivedBoards();
			this.archivedBoards.push(board);
			return store.commit('setArchivedBoards', this.archivedBoards);
		},
		removeArchivedBoards: function (boardId) {
			this.archivedBoards = store.getters.getArchivedBoards();
			var index = _.findIndex(this.archivedBoards, { id: boardId });
			if (index > -1) {
				this.archivedBoards.splice(index, 1);
			}
			return store.commit('setArchivedBoards', this.archivedBoards);
		},
		closeBoardPopup: function () {
			this.createFolderPopup.show = false;
		},
		removeFavoriteBoardsIfFolderDeleted: function (folder) {
			return store.commit('removeFavoriteBoardsIfFolderDeleted', folder);
		}
	}
});

const BOARD_HISTORY = Vue.component('board-history', {
	name: 'board-history',
	props: ["boardId", "users"],
	template: `
	<div class="nodhvr artp arrh lst DB board-history" v-click-outside="onClickOutside">					
		<div class="head ftsb">Board History</div>
		<ul class="manul bbhistory">
			<li v-for="(group, groupIndex) in logsGroups">				
				<div class="day">{{group.key}}</div>				
				<ul>
					<li v-for="(logModel, logIndex) in group.logs" class="rec">						
						<div class="usr p-rel"><strong>{{logModel.user}}</strong> <div class="evt p-abs">{{logModel.event}}</div> <div class="dt p-abs">{{logModel.date}}</div></div>						
												

						<ul class="spr">
							<li v-for="(item, itemIndex) in logModel.items" class="rec">
								<div class="itmnm">{{item.itemName}}</div>
								<div class="itmtxt" v-if="item.text">{{item.text}}</div>
								<!-- <a class="restore" v-if="logModel.log.event == 'Deleted'" @click="onClickRestoreItem(logModel.log, item, logIndex, itemIndex);">Restore</a> -->
							</li>
						</ul>
					</li>
				</ul>

			</li>
		</ul>
		
	</div>
	`,
	data() {
		return {
			logs: [],
			logsGroups: [],
			pageIndex: 0,
			pageSize: 30,
			startTime: 0,
			canLoadMore: true,
			loadingData: false,
		}
	},
	created() {

	},
	mounted() {
		this.loadHistoryLog(this.pageIndex);
		// onScrollPagination($('.bbhistory').attr("loading", 'false').attr('page', 0), this.loadHistoryLog);
		var _this = this;
		$('.bbhistory').on('scroll', function () {
			let div = $(this).get(0);
			if (div.scrollTop + div.clientHeight >= div.scrollHeight) {
				// do the lazy loading here
				_this.loadNextPage();
			}
		});
		this.startTime = (new Date()).getTime();
	},
	computed: {
	},
	methods: {
		//.....................................
		processAuditLogs: function (logs) {

			var usersMap = {};
			if (this.users) {
				usersMap = _.keyBy(this.users, "id");
			}

			var _this = this;

			var partsMapById = {};
			var partsMapByKey = {};

			_.each(board.model.nodeDataArray, node => {
				partsMapById[node._id] = node;
				partsMapByKey[node.key] = node;
			});
			_.each(board.model.linkDataArray, node => {
				partsMapById[node._id] = node;
			});

			var groupByDate = {};
			var groups = [];

			_.each(logs, log => {
				//.... Create,Update,Delete
				var logModel = { log: log };

				var catagoryToNameMap = {
					"FRAME": "Frame",
					"NOTE": "Sticky Note",
					"SHAPE": "Shape",
					"TEXT": "Text",
					"FreehandDrawing": "Freehand Drawing",
					"Arrow": "Link"
				};

				if (log.createdByExternalUser) {
					logModel.user = log.createdBy;
				}
				else {
					if (usersMap[log.createdBy]) {
						logModel.user = usersMap[log.createdBy].fullName;
					} else {
						logModel.user = "Deleted User";
					}
				}
				logModel.date = _this.formatActivityDate(log.createdOn, "HH:MM:ss");
				logModel.event = log.event;

				_.each(log.items, item => {
					var orgItem = partsMapById[item._id];
					if (orgItem) {
						item.category = orgItem.category;
						item.key = orgItem.key;
						item.group = orgItem.group;
						item.text = orgItem.text;
						item.itemName = catagoryToNameMap[orgItem.category];

						if (orgItem.category === "Arrow") {
							if (orgItem.from && orgItem.to) {
								var fromItem = partsMapByKey[orgItem.from];
								var toItem = partsMapByKey[orgItem.to];
								if (fromItem && toItem) {
									var fromText = catagoryToNameMap[fromItem.category] + (!_.isEmpty(fromItem.text) ? (" (" + fromItem.text + ")") : "");
									var toText = catagoryToNameMap[toItem.category] + (!_.isEmpty(toItem.text) ? (" (" + toItem.text + ")") : "");
									item.itemName += " :: " + fromText + " -> " + toText;
									//<span class='ico ti-arrow-right'></span>
								}
							}
						}
					}
					else {
						item.itemName = catagoryToNameMap[item.category] ? catagoryToNameMap[item.category] : item.category;
					}
				});

				if (log.event == "Updated") {
					if (log.items && log.items.length > 1 &&
						log.items[0].category === "FRAME" &&
						log.items[1].category !== "FRAME" && log.items[1].group === log.items[0].key) {
						logModel.items = [log.items[0]];
					}
					else {
						logModel.items = log.items;
					}
				}
				else {
					logModel.items = log.items;
				}
				// _this.logs.push(logModel);

				var truncDate = _this.formatActivityDate(log.createdOn, "ddd mmm dd yyyy");
				var group = groupByDate[truncDate];
				if (!group) {
					group = { key: truncDate, logs: [], date: log.createdOn };
					groups.push(group);
					groupByDate[truncDate] = group;
				}
				group.logs.push(logModel);
			});
			groups = _.sortBy(groups, "date");

			this.logsGroups = this.logsGroups.concat(groups);
		},
		formatActivityDate: function (date, format) {
			return dateFormat(new Date(date), format);
		},

		//.....................................
		loadNextPage: function () {
			if (!this.loadingData && this.canLoadMore) {
				this.pageIndex ++;
				this.loadHistoryLog(this.pageIndex);
			}
		},
		loadHistoryLog: function (page) {

			var _this = this;

			var postData     = {};
			postData.boardId = this.boardId;
			postData.offset  = page;
			postData.limit   = this.pageSize;

			_this.loadingData = true;

			axios.post('/graphx/board/history', postData)
				.then(response => {
					_this.loadingData = false;
					if (response.data && response.data.success) {
						_this.processAuditLogs(response.data.logs);
						_this.canLoadMore = response.data.logs.length == _this.pageSize;

						// Vue.nextTick(function () {
						// 	$('.board-history').attr("loading", response.data.logs.length < _this.pageSize ? 'true' : 'false').attr('page', response.data.page);
						// });
					}
				})
				.catch(error => {
					_this.loadingData = false;
				});
		},
		//.....................................
		onClickRestoreItem: function (log, item, logIndex, itemIndex) {

			var copy = _.cloneDeep(item);

			delete copy._id;
			delete copy.key;

			var node;
			if (copy.category === "Arrow") {
				board.model.commit(() => {
					board.model.addLinkData(copy);
				}, null);
				node = board.findLinkForData(copy);
			}
			else {
				board.model.commit(() => {
					board.model.addNodeData(copy);
				}, null);
				node = board.findNodeForData(copy);
			}

			item.key = node.key;

			restoreItem(log, item, node);

			log.items.splice(itemIndex, 1);
			if (log.items == 0) {
				this.logs.splice(logIndex, 1);
			}
		},
		onClickOutside: function () {
			var currentTime = (new Date()).getTime();
			if (currentTime - this.startTime > 100) {
				this.$emit("close");
			}
		}
	}
});

const BOARDLIST = Vue.component('board-list', {
	name: 'board-list',
	template: `
	<div id="board-list">	
		<!--
		<div class="lft-bar" style="background-color: #08C198;">
			<ul><li class="logo font-sbold"><a href="http://localhost:8080/sessions"><span class="lgimg"><img style="" alt="/" src="../assets/imgs/k-logo1.png"></span></a></li></ul>
		</div> 
		-->
		<!--<div class="header DFA">
			<div class="srch DAJ p-rel"><input type="text" autocomplete="off" name="title" placeholder="Search Boards and Folders" v-model="searchQuery" @input="onApplyFilter" class="srwinp" /></div>
			<div class="DAJ">
				<a href="javascript:void(0);" class="DAJ share button ml-20">Share</a>
				<div class="usrsh ml-20"><div class="picu a"><div class="initial DAJ">ZR</div></div></div>
			</div>
		</div>-->
	
    <div class="wkflstg">

		<div v-if="filteredItems && showFilteredItems" class="a">
			<div v-for="(item, index) in filteredItems">
				<canvas-folder :folder="item" :parent-folder-id="item.folderId" :index="index"></canvas-folder>
			</div>
		</div>
		  
		<div v-if="!showFilteredItems" class="a">
			
			<!-- TREE BASED IMPLEMENTATION -->
			<!--
			-----------------------------------------------------------------------------------------------------------------------------------------------
			<div class="head font-sbold" style="font-size:16px;margin:20px 0;">My Documents</div>
			
			<div v-if="rootFolder">
				<canvas-folder :folder="rootFolder" :parent-folder-id="rootFolder.id" :folder-type="'rootFolder'" :key="canvasFolderComponentKey"></canvas-folder>
			</div>
			
			<div  class="head font-sbold" style="font-size:16px;margin:20px 0;">Favorite Boards
				<span v-if="stateFavorite && stateFavorite.length > 0"">
					<div v-for="(board, index) in stateFavorite">
						{{board.title}}
						<a v-if="board.favorite" href="javascript:void(0)" @click="markUnFavoriteFromFavoriteBoards(board)">
							<img src="/assets/icons/collab/star.svg" alt="star" /> unstar
						</a>
					</div>
				</span>
				<span  class="nofound wbox" v-else>No favorite boards</span>
			</div>
			
			<div class="head font-sbold" style="font-size:16px;margin:20px 0;">Archived Boards
				<span v-if="stateArchived && stateArchived.length > 0">
					<div v-for="(board, index) in stateArchived">
						{{board.title}}
						<a v-if="board.archived" href="javascript:void(0);" class="sesico delbrd" @click="onUnArchiveBoard(board)"><i class="ti-archive"></i> Un Archive</a>
					</div>
				</span>
				<span  class="nofound wbox" v-else>No archived boards</span>
			</div>
			
			<div class="head font-sbold" style="font-size:16px;margin:20px 0;">Boards shared with me
				<span v-if="stateShared && stateShared.length > 0">
					<div v-for="(board, index) in stateShared">
						<a href="javascript:void(0);" @click="onClickBoard(board.id)">{{board.title}}</a>
					</div>
				</span>
				<span  class="nofound wbox" v-else>No shared boards</span>
			</div>
			
			<div class="head font-sbold" style="font-size:16px;margin:20px 0;">Templates
				<span v-if="stateTemplate && stateTemplate.length > 0">
					<div>Personal templates</div>
					<div v-for="(template, index) in stateTemplate">
						<a href="javascript:void(0);" @click="onClickBoard(template.id)">{{template.title}}</a> 
						<span><button @click="confirmDelete(template)">Delete</button></span>
						<span><button @click="editTemplate(template)">Edit</button></span>
					</div>
				</span>
				<span  class="nofound wbox" v-else>No templates created</span>
				
				<span v-if="stateSharedTemplate && stateSharedTemplate.length > 0">
					<div>Shared templates</div>
					<div v-for="(template, index) in stateSharedTemplate">
						<a href="javascript:void(0);" @click="onClickBoard(template.id)">{{template.title}}</a> 
						<span><button @click="editTemplate(template)">Edit</button></span>
					</div>
				</span>
				<span  class="nofound wbox" v-else>No shared templates</span>
				
			</div>
			-----------------------------------------------------------------------------------------------------------------------------------------------
			-->
			<!-- FOLDER BASED IMPLEMENTATION -->
			
			<template v-if="loaderShow">
				<div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE">Fetching data</span></div></div>
			</template>
			
			<div class="prow mr-tb-30">
			<div class="whtabs FL">
				<!--<div class="tabs" @click="onSwitchMainTabs(0);" :class="[currentMainTab == 0 ? 'active' : '']">
					<img class="icoflt" src="../assets/icons/collab/home-ico.svg" alt="Home" />
					Home
				</div>-->
				<div class="tabs" @click="onSwitchMainTabs(1);" :class="[currentMainTab == 1 ? 'active' : '']">
					<img class="icoflt" src="../assets/icons/collab/documnt-ico.svg" alt="Documents" />
					Documents
				</div>
				<div class="tabs" @click="onSwitchMainTabs(2);" :class="[currentMainTab == 2 ? 'active' : '']">
					<img class="icoflt" src="../assets/icons/collab/templt-ico.svg" alt="Templates" />
					Templates
				</div>
			</div>
			<div class="rhtbtns FR" v-if="!hideNewButtons">
				<a class="button FL share" href="javascript:void(0);" v-on:click="createBoard()"> <em class="ti-plus ico"></em>New Board</a>
				<a v-if="!hideNewFolderButton" class="button FL ml-20" href="javascript:void(0);" v-on:click="createFolder()"><em class="ti-plus ico"></em>New Folder</a>
			</div>
			</div>
			
			<div class="mintabs prow mb-20">
				<a class="tabs" href="javascript:void(0);" @click="onSwitchTabs(1);" :class="[(currentTab == 1 || currentTemplateTab == 1) ? 'active' : '']"><img class="ico" src="../assets/icons/collab/recet-docm.svg" alt="My Documents" />{{currentMainTab==1 ? "My Documents" : "My Templates"}}</a>
				<a class="tabs" href="javascript:void(0);" @click="onSwitchTabs(2);" :class="[(currentTab == 2|| currentTemplateTab == 2) ? 'active' : '']"><img class="ico" src="../assets/icons/collab/star-docm.svg" alt="Starred Documents" /> {{currentMainTab==1 ? "Starred Documents" : "System Templates"}}</a>
				<!--<a v-if="!hideTrashTab" class="tabs" href="javascript:void(0);" @click="onSwitchTabs(3);" :class="[(currentTab == 3 || currentTemplateTab == 3)? 'active' : '']"><img class="ico" src="../assets/icons/collab/recomd.svg" alt="Documents" />Recommended for You</a>-->
				<a class="tabs" href="javascript:void(0);" @click="onSwitchTabs(4);" :class="[(currentTab == 4 || currentTemplateTab == 4) ? 'active' : '']"><img class="ico" src="../assets/icons/collab/shared.svg" alt="Shared with Me" />{{currentMainTab==1 ? "Shared Boards with Me" : "Shared Templates with Me"}}</a>
				<a v-if="!hideTrashTab" class="tabs" href="javascript:void(0);" @click="onSwitchTabs(5);" :class="[(currentTab == 5 || currentTemplateTab == 5)? 'active' : '']"><img class="ico" src="../assets/icons/collab/trash.svg" alt="Trash" />Archived</a>
			</div>
			
			<div class="mntbut prow">
				<div class="FR grid ml-20 DFA">
					<a href="javascript:void(0);" @click="onToggleBoardView('grid')" title="Grid View" :class="[boardView == 'grid' ? 'active' : '']"><img class="icoflt" src="../assets/icons/collab/grid.svg" alt="Grid" /></a>
					<a href="javascript:void(0);" @click="onToggleBoardView('list')" title="List View" :class="[boardView == 'list' ? 'active' : '']" class="ml-10"><img class="icoflt" src="../assets/icons/collab/list.svg" alt="List" /></a>
				</div>
				<!--<div class="selectcont wht FR ml-20">
				   <select>
		    		   <option value="1">Last Viewed</option>				       
				   </select>
				</div>-->
				<!--<div class="selectcont wht FR">
				   <select>
		    		   <option value="1">Owned by Anyone</option>				       
				   </select>
				</div>-->
			</div>
		
			<div v-if="currentMainTab == 1" class="prow">
				<!-- <div class="head font-sbold" style="font-size:16px;margin:20px 0;" @click="onSwitchTabs(1);" :class="[currentTab == 1 ? 'active' : '']">My Documents</div> -->
			
			<div v-if="currentTab == 1">
			
				<div class="brdcrmb prow"><span v-for="(folder, index) in breadCrumbsName"><a href="javascript:void(0)" @click="displaySelectedFolderContent(folder)"> {{folder.title}} </a> <em class="ti-angle-right ico"></em> </span></div>
			
				<span v-if="selectedFolderContent" v-for="(board, index) in selectedFolderContent">
					<canvas-folder v-if="!board.archived" :selected-folder-content="selectedFolderContent" :folder="board" :parent-folder-id="rootFolder.id" :key="canvasFolderComponentKey" :view="boardView"></canvas-folder>
				</span>
				<span v-if="selectedFolderContent.length == 0" class="nofound wbox">No documents</span>
			</div>
			
			<!-- <div  class="head font-sbold" style="font-size:16px;margin:20px 0;" @click="onSwitchTabs(2);" :class="[currentTab == 2 ? 'active' : '']">Starred Documents -->
				<div v-if="currentTab == 2">
					<span v-if="stateFavorite && stateFavorite.length > 0">
						<div v-if="!board.archived && (board.type != 'template')" v-for="(board, index) in stateFavorite">							
							<!-- {{board.title}} <a v-if="board.favorite" href="javascript:void(0)" @click="markUnFavoriteFromFavoriteBoards(board)"><img src="/assets/icons/collab/star.svg" alt="star" /> unstar</a>-->							
							<canvas-folder :folder="board" :selected-folder-content="selectedFolderContent"  :key="canvasFolderComponentKey" :view="boardView"></canvas-folder>							
						</div>
					</span>
					<span v-else class="nofound wbox"> No favorite boards</span>
				</div>
			</div>
			
			<div v-if="currentTab == 3" class="prow">
				<span class="nofound wbox">Nothing recommended</span>
			</div>
			
			
			<!--<div class="head font-sbold" style="font-size:16px;margin:20px 0;" @click="onSwitchTabs(4);" :class="[currentTab == 4 ? 'active' : '']">Shared with Me-->
				<div v-if="currentTab == 4" class="prow">
					<span v-if="stateShared && stateShared.length > 0">
						<div v-for="(board, index) in selectedFolderContent">
							<canvas-folder :folder="board" :key="canvasFolderComponentKey" :view="boardView"></canvas-folder>		
							<!--<a href="javascript:void(0);" @click="onClickBoard(board.id)">{{board.title}}</a>-->							
						</div>
					</span>
					<span v-else class="nofound wbox">No shared boards</span>
				</div>
			<!--</div>-->
			
			<div v-if="currentTab == 5" class="prow">
				<span v-if="stateArchived && stateArchived.length > 0">
					<div v-if="board.archived" v-for="(board, index) in stateArchived">
						<canvas-folder :folder="board" :key="canvasFolderComponentKey" :view="boardView"></canvas-folder>
						<!--<a v-if="board.archived" href="javascript:void(0);" class="sesico delbrd" @click="onUnArchiveBoard(board)"><i class="ti-archive"></i> Un Archive</a>-->
					</div>
				</span>
				<span v-else class="nofound wbox">No archived boards</span>
				<!--<span>Nothing in trash</span>-->
			</div>
		
		</div>
	
	<div v-if="currentMainTab == 2">
		<!--<div class="head font-sbold" style="font-size:16px;margin:20px 0;" @click="onSwitchTemplateTabs(1);" :class="[currentTemplateTab == 1 ? 'active' : '']">My Templates</div>-->

		<div v-if="currentTemplateTab == 1" class="prow">
			<span v-if="selectedFolderContent && selectedFolderContent.length > 0">
				<div v-if="!template.isSystem" v-for="(template, index) in selectedFolderContent">
					<canvas-folder :folder="template" :key="canvasFolderComponentKey" :view="boardView"></canvas-folder>
					<!--<a href="javascript:void(0);" @click="onClickBoard(template.id)">{{template.title}}</a> 
					<span><button @click="confirmDelete(template)">Delete</button></span>
					<span><button @click="editTemplate(template)">Edit</button></span>-->
				</div>
			</span>
			<span v-else class="nofound wbox">No templates created</span>
		</div>
		
		<div v-if="currentTemplateTab == 2" class="prow">
			<span v-if="customTemplates && customTemplates.length > 0">
				<div v-for="(template, index) in customTemplates">
					<canvas-folder :folder="template" :view="boardView"></canvas-folder>
				</div>
			</span>
			<span v-else class="nofound wbox">No custom templates created</span>
		</div>
		
		<!--<div class="head font-sbold" style="font-size:16px;margin:20px 0;" @click="onSwitchTemplateTabs(4);" :class="[currentTemplateTab == 4 ? 'active' : '']">Shared with Me</div>-->

		<div v-if="currentTemplateTab == 4" class="prow">
			<span v-if="stateSharedTemplate && stateSharedTemplate.length > 0">
				<div v-for="(template, index) in stateSharedTemplate">	
					<canvas-folder :folder="template" :key="canvasFolderComponentKey" :view="boardView"></canvas-folder>
					<!--<a href="javascript:void(0);" @click="onClickBoard(template.id)">{{template.title}}</a> 
					<span><button @click="editTemplate(template)">Edit</button></span>-->
				</div>
			</span>
			<span v-else class="nofound wbox">No shared templates</span>
	   </div>
	</div>
	
	</div>
     <!-- <ul v-for="(data,index) in boards" class="session prow">
        <li>
          <a href="javascript:void(0)" v-on:click="onClickBoard(data.id)" style="font-size:15px; padding-top:10px;" class="FL">{{data.title}}</a>
          <div class="seccog" style="top:17px;">
			<button v-on:click="onCilckEditBoard(data)" class="ml-20">Edit Board</button>
          	<button v-on:click="deleteBoard(data.id, index)">Delete Board</button>
          </div>
        </li>
      </ul>-->

      <create-board v-if="createBoardPopup.show" :type="createBoardPopup.type" :model="createBoardPopup.model" @close-popup="closeBoardPopup" @save="onBoardCreate" @update="onBoardUpdate"></create-board>
	</div>

  </div>
		`,
	data() {
		return {
			sharedBoards: [],
			//folders: [],
			rootFolder: {},
			favoriteBoards: [],
			archivedBoards: [],
			createBoardPopup: { show: false, model: {}, type: '' },
			showSubItems: false,
			showBoards: false,
			foldersList: [],
			boardsList: [],
			templates: [],
			customTemplates: [],
			sharedTemplates: [],
			searchQuery: '',
			canvasFolderComponentKey: 0,
			filteredItems: [],
			showFilteredItems: false,
			currentTab: 0,
			currentMainTab: 0,
			currentTemplateTab: 0,
			selectedFolderContent: [],
			breadcrumbsArray: [],
			boardView: '',
			loaderShow: false,
			breadCrumbsName: [],
			hideNewButtons: false,
			hideTrashTab: false,
			hideNewFolderButton: false,
		}
	},
	computed: {
		stateArchived() {
			return this.archivedBoards = store.getters.getArchivedBoards();
		},
		stateFavorite() {
			return this.favoriteBoards = store.getters.getFavoriteBoardsList();
		},
		stateShared() {
			return this.sharedBoards = store.getters.getSharedBoards();
		},
		stateTemplate() {
			//personal templates
			return this.templates = store.getters.getTemplates();
		},
		stateSharedTemplate() {
			//shared templates
			return this.sharedTemplates = store.getters.getSharedTemplates();
		},
		stateBreadcrumbsArray() {
			//shared templates
			return this.breadcrumbsArray = store.getters.getbreadcrumbsArray();
		},
	},
	mounted() {
		showLeftHeader();
		this.currentMainTab = 1;
		//this.boardView = 'grid';	

		this.boardView = localStorage.getItem("boardView");

		if (!this.boardView) {
			this.boardView = 'grid';
			localStorage.setItem("boardView", this.boardView);
		}

		//	this.currentTab = parseInt(localStorage.getItem("currentTab"));

		if (!this.currentTab) {
			this.currentTab = 1;
		}
	},
	created() {
		//this.getLoggedInUser();

		this.loadFolders();
		this.loadTemplates();

		if (this.favoriteBoards) {
			return store.commit('setFavoriteBoards', this.favoriteBoards);
		}

		if (this.archivedBoards) {
			return store.commit('setArchivedBoards', this.archivedBoards);
		}

		this.stateFavorite();
		this.stateArchived();
		this.stateShared();
		this.stateTemplate();
		this.stateSharedTemplate();

	},
	beforeRouteUpdate(to, from, next) {

		var folder = _.find(this.foldersList, { id: to.params.id });

		if (!folder) {
			var board = _.find(this.boardsList, { id: to.params.id });
		}
		if (!board) {
			var sharedBoard = _.find(this.sharedBoards, { id: to.params.id });
		}
		if (!sharedBoard) {
			var template = _.find(this.templates, { id: to.params.id });
		}

		if (template && to.fullPath != '/templates') {
			this.$router.push('/detail/' + to.params.id);
		}

		if (sharedBoard && to.fullPath != '/templates') {
			this.$router.push('/detail/' + to.params.id);
		}

		if (board && to.fullPath != '/templates') {
			//board
			this.$router.push('/detail/' + to.params.id);
		}

		if (folder != undefined && to.fullPath != '/templates') {
			//folder
			this.getSelectedFolderContent(folder);

			var index = _.findIndex(this.breadCrumbsName, { id: folder.id })
			var len = this.breadCrumbsName.length - 1;
			//exist
			if (index > -1) {
				this.breadCrumbsName.splice(index + 1, len);
			}
			//not exist
			if (index == -1) {
				this.breadCrumbsName.push(folder);
			}
		}

		if (to.fullPath == '/templates') {
			this.getSelectedFolderContent(this.templates, 'templates');
		}

		//copy profile1 url to profile2 then show the default case
		if (board == undefined && folder == undefined && sharedBoard == undefined && template == undefined && to.fullPath != '/templates') {
			this.$router.push('/');
			this.loadFolders();
			this.onSwitchMainTabs(1);
			//window.location.url = "/collab";
		}

		next();
	},
	components: {
		'canvas-folder': CanvasFolder
	},
	methods: {
		getLoggedInUser: function () {
			// var host 	 = window.location.host;
			// var protocol = window.location.protocol;
			// axios.get("/plan/userInfo?host="+ host + "&protocol="+protocol )
			// .then(response => {
			// 	loggedInUser = response.data;
			// 	companyId = loggedInUser.loggedInUserCompany.company.id;
			this.loadFolders();
			//this.loadSharedBoards();
			//this.loadTemplates();
			// })
			// .catch(error => {
			// });
		},
		getBoardsListMappedById: function (folder) {
			var boardMappedbyId = {};
			let stack = [];

			if (folder.canvasBoard) {
				_.each(folder.canvasBoard, board => {
					if (board) {
						this.boardsList.push(board);
					}
				});
			}

			if (folder.canvasFolder) {
				_.each(folder.canvasFolder, folder => {
					if (folder) {
						stack.push(folder);
					}
				});
			}

			while (stack.length > 0) {
				var folder = stack.pop();
				if (folder.canvasBoard != undefined) {
					_.each(folder.canvasBoard, board => {
						if (board) {
							this.boardsList.push(board);
						}
					});
				}
				if (folder.canvasFolder) {
					_.each(folder.canvasFolder, folder => {
						if (folder) {
							stack.push(folder);
						}
					});
				}

			}
			return this.boardsList;
		},
		displaySelectedFolderContent: function (folder) {
			this.hideNewFolderButton = false;
			this.$router.push('/' + folder.id);
			var index = _.findIndex(this.breadCrumbsName, { id: folder.id })
			var len = this.breadCrumbsName.length - 1;
			//exist
			if (index > -1) {
				this.breadCrumbsName.splice(index + 1, len);
			}

			this.getSelectedFolderContent(folder);
		},
		onToggleBoardView: function (view) {
			this.boardView = view;
			localStorage.setItem("boardView", this.boardView);
		},
		getSelectedFolderContent: function (folder, flag) {
			this.selectedFolderContent = [];

			var boardMap = {};
			_.each(this.favoriteBoards, board => {   // first creating map for fav boards
				boardMap[board.id] = board.favorite;
			});

			if (flag == 'templates') {
				_.each(folder, board => {
					this.selectedFolderContent.push(board);
				});
			}

			if (flag == 'shared') {
				_.each(folder, board => {
					this.selectedFolderContent.push(board);

					if (boardMap[board.id]) {
						board.favorite = boardMap[board.id];
					} else {
						board.favorite = false;
					}
				});
			}

			if (flag != 'shared') {
				if (folder.canvasBoard) {
					_.each(folder.canvasBoard, board => {
						if (board && board.rowStatus != -1) {
							//documentsCount = documentsCount + 1;
							this.selectedFolderContent.push(board);

							if (boardMap[board.id]) {
								board.favorite = boardMap[board.id];
							} else {
								board.favorite = false;
							}
						}
					});
				}

				if (folder.canvasFolder) {
					_.each(folder.canvasFolder, folder => {
						if (folder && folder.rowStatus != -1) {
							this.selectedFolderContent.push(folder);
						}
					});
				}
			}
			this.selectedFolderContent = this.selectedFolderContent.sort((f, s) => s.createdOn - f.createdOn);
			return this.selectedFolderContent;
		},
		onSwitchTemplateTabs: function (tabNum) {
			if (tabNum == 1) {
				this.currentTemplateTab = 1;
			} else if (tabNum == 2) {
				this.currentTemplateTab = 2;
			} else if (tabNum == 3) {
				this.currentTemplateTab = 3;
			}
			else if (tabNum == 4) {
				this.currentTemplateTab = 4;
			} else if (tabNum == 5) {
				this.currentTemplateTab = 5;
			}
		},
		onSwitchMainTabs: function (tabNum) {
			if (tabNum == 1) {
				this.displaySelectedFolderContent(this.rootFolder);
				this.currentMainTab = 1;
				this.currentTab = 1;
				this.currentTemplateTab = 0;
				this.hideNewButtons = false;
				this.hideTrashTab = false;

			} else if (tabNum == 2) {
				this.$router.push('/templates');
				//this.getSelectedFolderContent(this.templates, 'templates')
				this.currentMainTab = 2;
				this.currentTemplateTab = 1;
				this.currentTab = 0;
				this.hideNewButtons = true;
				this.hideTrashTab = true;
			}
		},
		onSwitchTabs: function (tabNum) {
			if (this.currentMainTab == 1) {
				this.currentTemplateTab = 0;
				if (tabNum == 1) {
					this.displaySelectedFolderContent(this.rootFolder);
					this.currentTab = 1;
				} else if (tabNum == 2) {
					this.currentTab = 2;
				}
				else if (tabNum == 3) {
					this.currentTab = 3;
				}
				else if (tabNum == 4) {
					//shared boards
					this.getSelectedFolderContent(this.sharedBoards, 'shared')
					this.currentTab = 4;
				}
				else if (tabNum == 5) {
					this.currentTab = 5;
				}
			}
			if (this.currentMainTab == 2) {
				this.currentTab = 0;
				if (tabNum == 1) {
					this.currentTemplateTab = 1;
				} else if (tabNum == 2) {
					this.currentTemplateTab = 2;
				} else if (tabNum == 3) {
					this.currentTemplateTab = 3;
				}
				else if (tabNum == 4) {
					this.currentTemplateTab = 4;
				} else if (tabNum == 5) {
					this.currentTemplateTab = 5;
				}
			}

			//localStorage.setItem("currentTab" , this.currentTab);
		},
		loadTemplates: function () {
			axios.get('/graphx/template/all/' + loggedInUser.id)
				.then(response => {
					if (!_.isEmpty(response.data)) {
						if (response.data.success) {
							if (response.data.templates) {
								_.each(response.data.templates, template => {
									if (template.type == 'template') {
										//shared templates
										if (template.createdBy != loggedInUser.userName) {
											if (this.sharedTemplates && this.sharedTemplates.length > 0) {
												var index = _.findIndex(this.sharedTemplates, { id: template.id })
												//not exist
												if (index < 0) {
													this.sharedTemplates.push(template);
												}
											} else {
												this.sharedTemplates.push(template);
											}
										}
										//personal templates
										if (template.createdBy == loggedInUser.userName) {
											if (this.templates && this.templates.length > 0) {
												var exist = _.findIndex(this.templates, { id: template.id });
												//not exist
												if (exist < 0) {
													this.templates.push(template);
												}
											} else {
												this.templates.push(template);
											}
										}
									}
								});
							}

							if (response.data.systemTemplates) {
								this.customTemplates = response.data.systemTemplates;
							}

							var id = this.$route.params["id"];

							if (id == 'templates') {
								this.getSelectedFolderContent(this.templates, 'templates');
								this.currentMainTab = 2;
								this.currentTemplateTab = 1;
								this.hideNewButtons = true;
								this.hideTrashTab = true;
							}
							//this.templates = response.data.templates;
							store.commit('setTemplate', this.templates);
							store.commit('setSharedTemplates', this.sharedTemplates);
						}
					}
				})
				.catch(error => {
				});
		},
		loadSharedBoards: function () {
			axios.get('/graphx/shared-board/list/' + loggedInUser.id)
				.then(response => {
					this.sharedBoards = response.data.boards;
					store.commit('setSharedBoards', this.sharedBoards);
				})
				.catch(error => {
				});
		},
		getFoldersListMappedById: function (rootFolder) {
			let stack = [];
			this.foldersList = store.getters.getFoldersList();
			//check if folder is present or not in folders list
			var folderObjPresentOrNot = _.find(this.foldersList, { id: rootFolder.id });

			//if not present then push in folders list
			if (!folderObjPresentOrNot) {
				this.foldersList.push(rootFolder);
			}
			//else update the folder in folders list 
			else {
				var exist = _.findIndex(this.foldersList, { id: rootFolder.id });
				//exist
				if (exist > -1) {
					this.foldersList[exist] = rootFolder;
				}
			}

			if (rootFolder.canvasFolder) {
				_.each(rootFolder.canvasFolder, folder => {
					stack.push(folder);
				});
			}

			while (stack.length > 0) {
				var folder = stack.pop();

				if (folder) {
					//check if folder is present or not in folders list
					var folderObj = _.find(this.foldersList, { id: folder.id });

					//if not present then push in folders list
					if (!folderObj) {
						this.foldersList.push(folder);
					}
					//else update the folder in folders list 
					else {
						var exist = _.findIndex(this.foldersList, { id: folder.id });
						//exist
						if (exist > -1) {
							this.foldersList[exist] = folder;
						}
					}

					store.commit('setFoldersList', this.foldersList);

					if (folder.canvasFolder) {
						_.each(folder.canvasFolder, folder => {
							stack.push(folder);
						});
					}
				}
			}
			return this.foldersList;
		},
		updateArchivedBoardsList: function (board) {
			if (this.archivedBoards && this.archivedBoards.length > 0) {
				var exist = _.findIndex(this.archivedBoards, { id: board.id });
				//not exist
				if (exist < 0) {
					this.archivedBoards.push(board);
				}
			} else {
				this.archivedBoards.push(board);
			}
			store.commit('setArchivedBoards', this.archivedBoards);
		},
		loadFolders: function () {
			let stack = [];
			this.loaderShow = true;
			axios.get('/graphx/folder/list/' + loggedInUser.id)
				.then(response => {
					this.loaderShow = false;
					this.rootFolder = response.data.folders[0];

					this.favoriteBoards = response.data.starredBoards;
					store.commit('setFavoriteBoards', this.favoriteBoards);

					this.sharedBoards = response.data.sharedBoards;
					store.commit('setSharedBoards', this.sharedBoards);

					this.getFoldersListMappedById(this.rootFolder);
					this.getBoardsListMappedById(this.rootFolder);

					_.each(this.rootFolder.canvasBoard, board => {
						if (board && board.folderId && board.archived) {
							this.updateArchivedBoardsList(board);
						}
					});

					_.each(this.rootFolder.canvasFolder, folder => {
						if (folder.canvasBoard) {
							_.each(folder.canvasBoard, board => {
								if (board && board.folderId && board.archived) {
									this.updateArchivedBoardsList(board);
								}
							});
						}
						if (folder.canvasFolder) {
							_.each(folder.canvasFolder, folder => {
								if (folder) {
									stack.push(folder);
								}

							});
						}

					});

					while (stack.length > 0) {
						var folder = stack.pop();
						if (folder.canvasBoard) {
							_.each(folder.canvasBoard, board => {
								if (board && board.folderId && board.archived) {
									this.updateArchivedBoardsList(board);
								}

							});
						}
						if (folder.canvasFolder) {
							_.each(folder.canvasFolder, folder => {
								stack.push(folder);
							});
						}
					}


					var id = this.$route.params["id"];

					if (id == 'templates') {
						//id = this.$router.push('/');
						this.getSelectedFolderContent(this.templates, 'templates');
					}

					if (id != 'templates') {
						var folder = _.find(this.foldersList, { id: id });

						if (id && folder) {
							//this.breadCrumbsName=[];
							//var folder = _.find(this.foldersList, { id: id });
							if (folder) {
								this.hideNewFolderButton = false;
								this.getSelectedFolderContent(folder);
								this.getBreadcrumbsArray1(folder);
								this.breadCrumbsName.reverse();
							}

						} else {
							this.hideNewFolderButton = false;
							this.$router.push('/' + this.rootFolder.id);
							this.breadCrumbsName = [];
							if (this.breadCrumbsName.length > 0) {
								var folder = _.find(this.breadCrumbsName, { id: this.rootFolder.id });
								if (!folder) {
									this.breadCrumbsName.push(this.rootFolder);
								}
							} else {
								this.breadCrumbsName.push(this.rootFolder);
							}
							this.getSelectedFolderContent(this.rootFolder);
						}
					}
				})
				.catch(error => {
					console.log(error);
				});
		},
		getBreadcrumbsArray1: function (folder) {
			if (!folder.parentFolder) {
				var fol = _.find(this.breadCrumbsName, { id: folder.id });
				if (!fol) {
					this.breadCrumbsName.push(folder);
					return;
				}
			}

			if (folder.parentFolder) {
				this.breadCrumbsName.push(folder);
				var folder1 = _.find(this.foldersList, { id: folder.parentFolder });
				if (folder1) {
					this.getBreadcrumbsArray1(folder1);
				}
			}
		},
		isMatchFoundOrNot: function (board) {
			var matchFound = false;
			//this.filteredItems = [];
			if (!_.isEmpty(this.searchQuery)) {
				if (board.title) {	// search on item's title
					matchFound = (board.title.toLowerCase().includes(this.searchQuery.toLowerCase()));
				}
			}

			if (matchFound) {
				this.filteredItems.push(board);
			}
		},
		onApplyFilter: function () {
			let stack = [];
			this.filteredItems = [];

			this.isMatchFoundOrNot(this.rootFolder);

			_.each(this.rootFolder.canvasBoard, board => {
				this.isMatchFoundOrNot(board);

			});

			_.each(this.rootFolder.canvasFolder, folder => {
				this.isMatchFoundOrNot(folder);

				if (folder.canvasBoard) {
					_.each(folder.canvasBoard, board => {
						this.isMatchFoundOrNot(board);
					});
				}
				if (folder.canvasFolder) {
					_.each(folder.canvasFolder, folder => {
						stack.push(folder);
					});
				}

			});

			while (stack.length > 0) {
				var folder = stack.pop();
				//folder.filterOn = true;
				this.isMatchFoundOrNot(folder);
				if (folder.canvasBoard != undefined) {
					_.each(folder.canvasBoard, board => {
						this.isMatchFoundOrNot(board);
					});
				}
				if (folder.canvasFolder) {
					_.each(folder.canvasFolder, folder => {
						stack.push(folder);
					});
				}

			}

			if (this.filteredItems.length > 0) {
				this.showFilteredItems = true;
			} else {
				this.showFilteredItems = false;
			}

			this.canvasFolderComponentKey += 1
			this.$forceUpdate();
		},
		markUnFavoriteFromFavoriteBoards: function (board) {
			if (board.favorite) {
				//mark it unfavorite and remove from favorite boards list
				axios.get('/graphx/mark-favorite/' + board.id)
					.then(response => {
						showTopMessage('Board marked unfavorite', 'success');
						board.favorite = response.data.board.favorite;
						this.removeFavoriteBoards(board.id);
					});
			}
		},
		removeFavoriteBoards: function (boardId) {
			this.favoriteBoards = store.getters.getFavoriteBoardsList();
			var index = _.findIndex(this.favoriteBoards, { id: boardId });
			if (index > -1) {
				this.favoriteBoards.splice(index, 1);
			}
			return store.commit('setFavoriteBoards', store.state.favoriteBoards);
		},
		onUnArchiveBoard: function (board) {
			if (board.archived) {
				//unarchive it and remove from archived boards list
				axios.get('/graphx/archive-board/' + board.id)
					.then(response => {
						if (response.data.board) {
							showTopMessage('Board unarchived successfully', 'success');
							board.archived = response.data.board.archived;
							this.removeArchivedBoards(board.id);
							_this.$forceUpdate();
						}
					})
					.catch(error => {
						console.log(error);
					});
			}
		},
		removeArchivedBoards: function (boardId) {
			this.archivedBoards = store.getters.getArchivedBoards();
			var index = _.findIndex(this.archivedBoards, { id: boardId });
			if (index > -1) {
				this.archivedBoards.splice(index, 1);
			}
			return store.commit('setArchivedBoards', this.archivedBoards);
		},
		onClickBoard: function (id) {
			this.$router.push('/detail/' + id);
		},
		onClickFolder: function (folder) {
			//this.showSubItems = false;
			if (folder.canvasFolder) {
				if (this.showSubItems == true) {
					this.showSubItems = false;
				} else {
					this.showSubItems = true;
				}
			}

			if (folder.canvasBoard) {
				if (this.showBoards == true) {
					this.showBoards = false;
				} else {
					this.showBoards = true;
				}
			}
		},

		onCilckEditBoard: function (board) {
			this.createBoardPopup.model = { _id: board.id, title: board.title };
			this.createBoardPopup.show = true;
		},
		createBoard: function () {
			this.createBoardPopup.model = {};
			this.createBoardPopup.show = true;
			this.createBoardPopup.type = 'board';
		},
		createFolder: function () {
			this.createBoardPopup.model = {};
			this.createBoardPopup.show = true;
			this.createBoardPopup.type = 'folder';
			//this.rootFolder.id = id;
		},
		deleteBoard: function (id, index) {
			axios.delete('/graphx/delete/board/' + id)
				.then(response => {
					if (response.data.itemRemoved > 0) {
						this.boards.splice(index, 1);
					}
				})
				.catch(error => {

				});
		},
		closeBoardPopup: function () {
			this.createBoardPopup.show = false;
		},
		onBoardCreate: function (dataModel, type, folderId, selectedTemplate, selectedWorkspace) {
			if (type == 'folder') {
				this.onFolderCreate(dataModel, type, selectedTemplate, selectedWorkspace);
			} else {
				var id;
				if (this.$route.params["id"]) {
					id = this.$route.params["id"];
				} else {
					id = this.rootFolder.id;
				}
				//simple board creation
				if (!selectedTemplate.id) {
					if (dataModel.title === "") {
						//showTopMessage('Please enter board title', 'warning');

					} else {
						var data = { title: dataModel.title, folderId: id }
						axios.post("/graphx/board/create", data)
							.then(response => {
								showTopMessage('Board created successfully', 'success');
								this.createBoardPopup.show = false;
								this.selectedFolderContent.push(response.data.board);

								var folder = _.find(this.foldersList, { id: id });
								if (!folder.canvasBoard) {
									folder.canvasBoard = [];
								}
								folder.canvasBoard = response.data.folder.canvasBoard;
								this.$router.push('/detail/' + response.data.board.id);
							})
							.catch(error => {

							});
					}
				}
				//create board using template
				else {
					var data = { title: dataModel, folderId: id, templateId: selectedTemplate.id }
					axios.post("/graphx/board/create/using_template", data)
						.then(response => {
							showTopMessage('Board created successfully', 'success');
							this.createBoardPopup.show = false;
							//	this.rootFolder.canvasBoard = response.data.folder.canvasBoard;
							this.selectedFolderContent.push(response.data.board);

							var folder = _.find(this.foldersList, { id: id });
							if (!folder.canvasBoard) {
								folder.canvasBoard = [];
							}
							folder.canvasBoard = response.data.folder.canvasBoard;
							this.$router.push('/detail/' + response.data.board.id);
						})
						.catch(error => {

						});
				}
			}
		},
		onFolderCreate: function (dataModel, type, folderAccessType, selectedWorkspace) {
			if (dataModel.title === "") {
				//showTopMessage('Please enter folder title', 'warning');
			}
			else {
				console.log(selectedWorkspace);
				var id;
				if (this.$route.params["id"]) {
					id = this.$route.params["id"];
				} else {
					id = this.rootFolder.id;
				}
				if (folderAccessType.key && selectedWorkspace.id) {
					var data = { title: dataModel.title, id: id, folderAccessType: folderAccessType.key, selectedWorkspace: selectedWorkspace.id }
				} else if (folderAccessType.key && !selectedWorkspace.id) {
					var data = { title: dataModel.title, id: id, folderAccessType: folderAccessType.key }
				} else {
					var data = { title: dataModel.title, id: id }
				}
				axios.post("/graphx/folder/create", data)
					.then(response => {
						console.log(response);
						showTopMessage('Folder created successfully', 'success');
						this.createBoardPopup.show = false;
						/*
						if(!this.rootFolder.canvasFolder) {
							this.rootFolder.canvasFolder = [];
						}*/
						//this.rootFolder.canvasFolder.push(response.data.folder);

						this.selectedFolderContent.push(response.data.folder);

						this.foldersList = store.getters.getFoldersList();
						this.foldersList.push(response.data.folder);
						store.commit('setFoldersList', this.foldersList);

						var folder = _.find(this.foldersList, { id: id });
						if (!folder.canvasFolder) {
							folder.canvasFolder = [];
						}
						folder.canvasFolder.push(response.data.folder);
					})
					.catch(error => {

					});
			}
		},
		onBoardUpdate: function (dataModel) {
			if (dataModel.title === "") {
				console.log("your title is empty")
			} else {
				var data = { title: dataModel.title, id: dataModel._id }
				axios.post("/graphx/board/update", data)
					.then(response => {
						console.log(response);
						this.createBoardPopup.show = false;
						this.$router.push('/detail/' + response.data.boardId);
					})
					.catch(error => {

					});
			}
		},
		confirmDelete: function (template) {
			askFromSweetAlertWrapper("This will delete the template.",
				[this.deleteTemplate, template], [takeNoAction]);
		},
		deleteTemplate: function (template) {
			axios.delete('/graphx/delete/template/' + template.id)
				.then(response => {
					if (response.data.itemRemoved > 0) {
						showTopMessage("Template deleted successfully", "success");
						this.removeTemplates(template.id);
					}
				})
				.catch(error => {

				});
		},
		editTemplate(template) {
			this.$router.push('/detail/' + template.id);
		},
		removeTemplates: function (templateId) {
			this.templates = store.getters.getTemplates();
			var index = _.findIndex(this.templates, { id: templateId });
			if (index > -1) {
				this.templates.splice(index, 1);
			}
			return store.commit('setTemplate', this.templates);
		},
	}
});

const BOARDDETAIL = Vue.component('detail', {
	name: 'detail',
	template: `
<div>
	
	<div v-if="showMessageWithHyperlink" id="top-message" class="success"  style="visibility:visible;">
		<em class="ti-close rmv-ico" title="Close" onclick="hideTopMessage('undefined');"></em>
		<div id="top-message-desc" class="msg">Template has been saved, and is now available in the 
			<a class="DIB" href="javascript:void(0);" style="color: #fff;text-decoration: underline;" @click="redirectToTemplatesList()">templates list</a>
		</div>
	</div>

	<div v-if="attentionManagement.following" id="followlayer" class="followlayer" @click="onUnfollowAttention">
		<div class="followname">Following {{attentionManagement.followName}} </div>
	</div>
	<div class="container" :class="[framesList.show ? 'lftopen' : '']">
    <div id="board" :style="boardStyle" :class="[boardDetail.board.type==='template' ? 'template' : '']"></div>
	
	<template v-if="loaderShow">
		<div id="body-loader" class="loader"><div><div class="loaderinteg"></div><span class="LOADER-TITLE">Saving data</span></div></div>
	</template>
	
    <div class="header DFA">

		<div id="logDiv"></div>
		<div v-if="boardDetail.board.type != 'template'" class="back mt-5 c-point" @click="onClickLogo(boardDetail.board)">
			<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M9 18C13.9603 18 18 13.9603 18 9C18 4.03967 13.9603 0 9 0C4.03967 0 0 4.03967 0 9C0 13.9603 4.03967 18 9 18ZM9 0.939457C13.4342 0.939457 17.0605 4.54697 17.0605 9C17.0605 13.453 13.453 17.0605 9 17.0605C4.56576 17.0605 0.939457 13.4342 0.939457 9C0.939457 4.56576 4.56576 0.939457 9 0.939457ZM4.77244 9.3382C4.6785 9.24426 4.64092 9.13152 4.64092 9C4.64092 8.86848 4.69729 8.75574 4.77244 8.6618L7.29019 6.14405C7.47808 5.95616 7.77871 5.95616 7.94781 6.14405C8.1357 6.33194 8.1357 6.63257 7.94781 6.80167L6.21921 8.53027H12.8894C13.1524 8.53027 13.3591 8.73695 13.3591 9C13.3591 9.26305 13.1524 9.46973 12.8894 9.46973H6.238L7.9666 11.1983C8.15449 11.3862 8.15449 11.6868 7.9666 11.8559C7.87265 11.9499 7.75992 11.9875 7.62839 11.9875C7.49687 11.9875 7.38413 11.9499 7.29019 11.8559L4.77244 9.3382Z" fill="#000"/>
			</svg>
		</div>
		<!-- <div class="logo DF"><a href="javascript:void(0);" @click="onClickLogo(boardDetail.board)"><img src="/assets/icons/collab/logo.svg" alt="Kendis" /></a></div> -->
		<div class="sprt mr-lr-15"></div>
		<template v-if="!boardDetail.board.locked">
		<div class="undout">
			<div v-if="userRights.canWrite" :class="isUndoEnable ? '' : 'disabled'" class="DAJ tltp"><a class="icut DAJ" href="javascript:void(0);" @click="onClickUndo()"><img src="/assets/icons/collab/undo-1.svg"         alt="Undo" class="icon" /></a><div class="tltphv tp">Undo</div></div>
			<div class="sprt"></div>
			<div v-if="userRights.canWrite" :class="isRedoEnable ? '' : 'disabled'" class="DAJ tltp"><a class="icut DAJ" href="javascript:void(0);" @click="onClickRedo()"><img src="/assets/icons/collab/redo-1.svg"   alt="Redo" class="icon" /></a><div class="tltphv tp">Redo</div></div>
		</div>
		</template>
		<!--<div v-if="!boardDetail.savingAnimation" class="logo">All changing saved </div>	-->
		
<!--	<div class="p-abs" style="top:8px; left:400px;">-->
<!--			mouse sending : <strong style="font-weight: 600;">{{mouseSendSocketReqCount}}</strong> -->
<!--			activity sending : <strong style="font-weight: 600;">{{activitySendSocketReqCount}}</strong>-->
<!--		</div>-->
<!--		<div class="p-abs" style="top:25px;left:400px;">-->
<!--			mouse receiving : <strong style="font-weight: 600;">{{mouseReceiveSocketReqCount}} </strong> -->
<!--			activity receiving : <strong style="font-weight: 600;">{{activityReceiveSocketReqCount}}</strong>-->
<!--		</div>-->
		
		
		
		<div class="hdrmd DAJ"> 
			<div :class="boardDetail.board.locked ? 'disabled' : ''" v-if="boardDetail.board.type != 'template'">
				<!--<div v-if="!isPublicLinkUrl">
					<div v-if="boardStarredFlagValue"><img src="/assets/icons/collab/star.svg" alt="star" style="max-width:15px;"/></div>
					<div v-else="!boardStarredFlagValue"><img src="/assets/icons/collab/star-s.svg" alt="star" style="max-width:17px;"/></div>
				</div>-->
			</div>
			
			
			
			<!-- <a href="javascript:void(0);" v-if="boardDetail.board.sessions && !isPublicLinkUrl" class="brdcrmb ftsb ti-angle-right" @click="onClickRedirectToActiveSessionBoard">{{boardDetail.board.session.title}}</a> -->
			<!-- <a href="javascript:void(0);" v-if="boardDetail.board.solutionBoards && !isPublicLinkUrl" class="brdcrmb ftsb ti-angle-right" @click="onClickRedirectToActiveSessionBoard">{{boardDetail.board.solutionBoard.title}}</a> -->
			
			<!-- 07-10-25 <a href="javascript:void(0);" v-if="boardDetail.board && !isPublicLinkUrl" class="brdcrmb ftsb ti-angle-right" @click="onClickRedirectToActiveSessionBoard">{{boardContext?.title}}</a> --> 
			
			<div class="DFA" :class="boardDetail.board.locked ? 'disabled' : ''">
				<div class="opld DAJ c-point tltp" @click="onClickOpenExportPopup">
					<div class="txt poppins elips">{{boardDetail.board.title}}</div>
					<div class="tltphv tp">{{boardDetail.board.title}}</div>
					<!-- <img v-if="!isPublicLinkUrl" src="/assets/icons/collab/ardn.svg" alt="Upload" class="icon" /> -->
				</div>
				<div v-if="boardDetail.board.type == 'template'" @click="onClickEditTemplate" class="edt ico ml-10 mr-0 c-point tltp">
					<div class="tltphv tp">Edit Title</div>
				</div>
			</div>
			
			<div v-if="boardDetail.board.type !='template'">
				<div class="svld load" v-if="boardDetail.savingAnimation && !boardDetail.errorWhileSaving">
					<img src="/assets/icons/collab/loader.svg" alt="loader" />
				</div>
				<div id="cloud_failure" class="svld clud tltp" v-else-if="boardDetail.errorWhileSaving">
					<img src="/assets/icons/collab/cloud_failure.svg" alt="Save" /> <div class="tltphv tp">Changes Not Saved</div>
				</div>
				
				<div id="cloud_success" class="svld clud tltp" v-else>
					<div v-if="showCloudSuccessIcon">
						<img src="/assets/icons/collab/cloud_success.svg" alt="Save" /> <div class="tltphv tp">Changes Saved</div>
					</div>
				</div>
			</div>
			
			<a href="javascript:void(0);" v-if="boardDetail.board.type=='template'" class="svtmp button rnd4 DIB ml-10" @click="onClickSaveButton">Save</a>
			
			<div v-if="boardDetail.board.locked && boardDetail.isActiveUser" class="shstate FR c-point" >
     			<div class="btn lock c-point rnd4 ml-10 tooltip">
     				<div class=" tooltip inn"> 
     					<i class="ico ti-lock"></i>
     					<div class="hovtooltip">
     						<strong v-if="boardDetail.board.locked">{{boardDetail.board.type != "template" ? 'Board is locked' : 'Template is locked'}}</strong>
						</div>
     				</div>
     			</div>
         	</div>
			
<!--			<div v-if="exportPopup.show" class="nodhvr artp arrh lst wd4 DB">-->
<!--			<div v-click-outside="onCloseExportPopup"></div>-->
<!--				<ul>-->
<!--					<li><a v-if="userRights.canWrite" class="DFA" href="javascript:void(0);" v-on:click="onClickEditBoardSettings()"><img src="/assets/icons/collab/edit-blk.svg" alt="Edit" class="ico edi" />{{boardDetail.board.type != "template" ? 'Edit Board Settings' : 'Edit Template Settings'}}</a></li>-->
<!--					<li><a v-if="userRights.canWrite" class="DFA" href="javascript:void(0);" v-on:click="onShowTemplatePopup()">     <img src="/assets/icons/collab/templt-1.svg" alt="Save" class="ico sav" />   Save as Template</a></li>-->
<!--					<li><a class="DFA" href="javascript:void(0);" v-on:click="onClickDownloadPdf()">      <img src="/assets/icons/collab/pdf.svg" alt="Export" class="ico pdf" />    Export as PDF</a></li>-->
<!--					<li><a class="DFA" href="javascript:void(0);" v-on:click="onClickDownloadImage()">    <img src="/assets/icons/collab/upload-in2.svg" alt="Export" class="ico" /> Export as Image</a></li>-->
<!--					&lt;!&ndash;<li><a v-if="userRights.canWrite" class="DFA" href="javascript:void(0);" v-on:click="onCreatePreview">           <img src="/assets/js/lib/golab/icons/fit_screen-1.svg" alt="Export" class="ico prv" style="width: 24px;" /> Select preview area</a></li>&ndash;&gt;-->
<!--				</ul>-->
<!--			</div>-->
			<div class="betacs">Beta</div>
		</div>	
		
		<div class="dtut"></div>
		
		<div class="head-rht DAJ" :class="boardDetail.board.locked ? 'disabled' : ''">
			<div class="srch DAJ p-rel ml-15">
				<a href="javascript:void(0);" @click="onClickSearchBar">
					<input type="text" :class="search.query ? 'srinp active' : 'srinp'" placeholder="Search" v-model="search.query" ref="search" @change="onChangeSearchText" @input="onInputSearchText"/>
				</a>

				<ul v-if="search.items" :class="[search.query ? 'drop_boxa' : '']" >
					<li v-for="(item, itemIndex) in search.items" :key="item.key" @click="onSelectSearchItem(item, itemIndex)">{{item.title}}</li>
				</ul>
				<ul v-if="search.query && search.items.length == 0" class="drop_boxa"><li>No results</li></ul>
			</div>
			<div class="DAJ">
                <!-- <a class="shrt icot DAJ active" @click="onUnfollowAttention">unfollow</a>	-->
				<!-- <div v-if="boardDetail.board.type != 'template'">
					<div class="tltp shuo" v-if="boardDetail.isCollaboratorsCursor">
						<a class="shrt icot DAJ active ml-20" @click="onToggleCollaboratorCursor()"><img src="/assets/icons/collab/pointer1.svg" alt="Arrow" /></a>
						<div class="tltphv tp whtspc">Hide collaborators cursors</div>
					</div>
					<div class="tltp shuo" v-else>
						<a class="shrt icot DAJ ml-20" @click="onToggleCollaboratorCursor()"><img src="/assets/icons/collab/pointer1.svg" alt="Arrow" /></a>
						<div class="tltphv tp whtspc">Show collaborators cursors</div>
					</div>		
				</div> -->		
				<div class="usrsh">
					<!--<div v-if="user" class="picu a">
						<img id='profile-image' v-if="profilePicturePath" :src="profilePicturePath" alt='' width='80px' height='80px'></img>
						<div v-if="!profilePicturePath" class="initial DAJ">{{getUserInitials()}}</div>
					</div>-->
					<div v-if="boardActiveUsers.length > 0" class="picu b">
						<!--<img v-if="profilePicturePath" src="/assets/imgs/pic1.png" alt="Profile" />-->
						<div class="initial DAJ tooltip" v-for="(data,index) in boardActiveUsers" @click="onFollowAttention(data)">{{getActiveUserInitials(data.firstName, data.lastName)}}<div class="hovtooltipB">Follow {{data.firstName}}</div></div>
					</div>
					<div class="picu DAJ plus c-point" @click="onToggleShowBoardActiveUsers()" v-if="boardActiveUsers.length > 1">+{{getBoardActiveUsersCount()}}</div>
					
					<div v-if="collaboratorsPopup.show" class="nodhvr artp arrh lst wd2 DB">
						<div v-click-outside="onCloseCollaboratorsPopup"></div>
						<ul>
							<li v-for="(data,index) in collaboratorsPopup.list">
								<a class="DFA" href="javascript:void(0);" @click="onFollowAttention(data)">{{data.firstName}} {{data.lastName}}</a>
							</li>
						</ul>
					</div>					
				</div>
				<div class="sprt mr-lr-15"></div>
				<div v-if="user" class="usrprf tltp">
					<div class="picu">
						<a href="javascript:void(0);" @click="onToggleProfilePopup()">
							<img id='profile-image' v-if="profilePicturePath" :src="profilePicturePath" alt='' width='80px' height='80px'></img>
						</a>
						<a href="javascript:void(0);" v-if="!profilePicturePath && !isPublicLinkUrl" class="initial DAJ" @click="onToggleProfilePopup()">{{getUserInitials()}}</a>
						<a href="javascript:void(0);" v-if="!profilePicturePath && isPublicLinkUrl" class="initial DAJ" @click="onToggleProfilePopup()">{{getUserInitials(unnamedUser)}}</a>

					</div>
					<div v-if="!isPublicLinkUrl" class="tltphv tp">{{user.fullName}} (you)</div>
					<div v-if="isPublicLinkUrl" class="tltphv tp">{{unnamedUser.name}} (you)</div>
				</div>
				
				<!-- <div v-if="profilePopup.show" class="nodhvr artp lst wd2 DB"  >	
					<div v-click-outside="onCloseProfilePopup"></div>
					<ul>
						<li><a class="DFA" href="javascript:void(0);" @click="onBringAllToMe">Bring everyone to me</a></li>
					</ul>
				</div> -->
				
				<div class="sprt mr-lr-20" v-if="isShareEnable"></div>				
			</div>
			<div class="DAJ p-rel">
				<a v-if="userRights.canWrite && !isPublicLinkUrl && boardDetail.board.type!='template'" class="DAJ share button ml-15 rnd4" @click="onClickShare()" href="javascript:void(0);">Share</a> <!-- v-if="isShareEnable" -->
				<!--<a class="DAJ share button" href="javascript:void(0);" @click="onClickPublicLink">Public Link</a>-->
				<!-- <div class="sprt DAJ mr-lr-20"></div> -->
				<a v-if="!isPublicLinkUrl && boardDetail.board.type!='template'" class="button-w icut stg rnd4" href="javascript:void(0);" @click="settingsPopup.show = !settingsPopup.show;" >
					<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M9.81406 7.99487C9.81406 8.99646 9.00514 9.80829 8.00734 9.80829C7.00935 9.80829 6.20044 8.99646 6.20044 7.99487C6.20044 6.99347 7.00935 6.18164 8.00734 6.18164C9.00514 6.18164 9.81406 6.99347 9.81406 7.99487Z" fill="#495961"/>
					<path d="M15.4784 9.15813C15.7652 9.11775 16 8.84652 16 8.55573V7.43322C16 7.14244 15.7654 6.87104 15.4784 6.83011L14.7132 6.7204C14.4264 6.67947 14.1203 6.41912 14.0329 6.1418L13.5701 5.01814C13.4347 4.7613 13.4666 4.3608 13.641 4.12866L14.1038 3.51192C14.2781 3.27978 14.2531 2.9217 14.0485 2.71594L13.2576 1.92219C13.0527 1.7166 12.6956 1.69116 12.4637 1.86558L11.8448 2.33152C11.6129 2.50595 11.2137 2.53803 10.9572 2.40288L9.84605 1.9445C9.56974 1.85729 9.31049 1.55047 9.27009 1.26229L9.16629 0.523474C9.12605 0.235648 8.8558 0 8.56606 0L7.44809 0.000184384C7.15836 0.000184384 6.88793 0.235644 6.84716 0.523659L6.74207 1.2636C6.70091 1.55143 6.4415 1.85859 6.16516 1.9462L5.0439 2.41066C4.78761 2.54655 4.38893 2.51447 4.15743 2.33949L3.55739 1.8859C3.3259 1.71092 2.96892 1.73599 2.76409 1.94158L1.97319 2.73534C1.76834 2.94093 1.74298 3.29936 1.91678 3.53207L2.36892 4.13682C2.54272 4.36952 2.57432 4.77019 2.43947 5.02739L1.98201 6.13995C1.89455 6.41726 1.58847 6.67763 1.30168 6.71856L0.521592 6.8303C0.234801 6.87123 0 7.14283 0 7.4334V8.55592C0 8.84669 0.234613 9.11753 0.521592 9.15832L1.30092 9.26857C1.58772 9.30896 1.89377 9.56912 1.98106 9.84643L2.43467 10.9529C2.56952 11.2103 2.53737 11.6111 2.36357 11.8437L1.88755 12.4801C1.71375 12.7128 1.73892 13.0712 1.94396 13.2769L2.73486 14.0706C2.93971 14.2762 3.29666 14.3015 3.52816 14.1263L4.15797 13.65C4.38946 13.475 4.78849 13.443 5.04445 13.5787L6.16697 14.0433C6.44329 14.1309 6.70253 14.4379 6.74275 14.7259L6.84784 15.4765C6.88807 15.7644 7.15833 16 7.44807 16H8.56637C8.8561 16 9.12652 15.7645 9.1673 15.4765L9.27423 14.7248C9.31501 14.437 9.57479 14.1298 9.85075 14.0422L10.967 13.5799C11.2233 13.4444 11.6224 13.4763 11.8538 13.6513L12.4527 14.1041C12.6842 14.2791 13.0412 14.254 13.246 14.0485L14.0369 13.2549C14.2418 13.0493 14.2671 12.6909 14.0933 12.4582L13.643 11.8558C13.4692 11.6231 13.4376 11.2224 13.5727 10.9656L14.0336 9.84395C14.1209 9.56664 14.4268 9.30646 14.714 9.2661L15.4784 9.15813ZM8.00773 11.6289C6.00758 11.6289 4.38603 10.0017 4.38603 7.99431C4.38603 5.98694 6.00772 4.35954 8.00773 4.35954C10.0079 4.35954 11.6293 5.98708 11.6293 7.99431C11.6293 10.0017 10.0077 11.6289 8.00773 11.6289Z" fill="#495961"/>
					</svg>
				</a>
				
				<board-history v-if="boardHistory.show" :board-id="boardDetail.board.id" :users="companyUsers" @close="boardHistory.show=false;"/>

				<!--<div class="sprt DAJ mr-lr-20"></div>
				<div class="menua DF DAJ" style="right: 20px;opacity: 1;">
					<a class="icut DAJ stg" href="javascript:void(0);" @click="onClickOpenNotesSection()" ><img src="/assets/icons/collab/grid.svg" alt="Note" class="icon" /></a>
				</div>-->
				
				<div v-if="settingsPopup.show" class="nodhvr artp arrh lst wd4 DB stng">					
					<div v-click-outside="onCloseSettingsPopup"></div>
					<ul>
						<!--<li><a class="DFA" href="javascript:void(0);"><img src="/assets/icons/collab/lock2.svg" alt="Setting" class="ico" /> Lock the Board</a></li>
						<li><a class="DFA" href="javascript:void(0);" @click="onChangeBoardColor(1)"><img src="/assets/icons/collab/bgbx.svg" alt="Setting" class="ico" /> Background Color</a></li>
						<li><a class="DFA" href="javascript:void(0);" @click="onChangeGridBackground(3 )"><img src="/assets/icons/collab/bggrid.svg" alt="Setting" class="ico" /> Background Grid</a></li>
						<li><a class="DFA" href="javascript:void(0);"><img src="/assets/icons/collab/bgguid.svg"   alt="Setting" class="ico" style=" margin-left: -2px;" /> Alignment Guides</a></li>
						<li><a class="DFA" href="javascript:void(0);"><img src="/assets/icons/collab/pointerb.svg" alt="Setting" class="ico" style="2px 11px 0 5px;" /> Collaborators Cursor</a></li>
						<li><a class="DFA" href="javascript:void(0);" @click="settingsPopup.shortcutPopup = !settingsPopup.shortcutPopup;"><div class="ico"><img src="/assets/icons/collab/shortcut.svg" alt="shortcuts" /></div> Shortcuts</a></li>-->
						<li v-if="!isPublicLinkUrl"><a class="DFA" href="javascript:void(0);" @click="onClickBoardHistoryButton"><div class="ico time"><em class="ti-time ico"></em></div> History</a></li>
						<li><a v-if="userRights.canWrite" class="DFA" href="javascript:void(0);" v-on:click="onClickEditBoardSettings()"><img src="/assets/icons/collab/edit-blk.svg" alt="Edit" class="ico edi" />{{boardDetail.board.type != "template" ? 'Edit Board Settings' : 'Edit Template Settings'}}</a></li>
						<li><a v-if="userRights.canManageTemplate" class="DFA" href="javascript:void(0);" v-on:click="onShowTemplatePopup()">     <img src="/assets/icons/collab/templt-1.svg" alt="Save" class="ico sav" />   Save as Template</a></li>
						<li><a class="DFA" href="javascript:void(0);" v-on:click="onClickDownloadPdf()">      <img src="/assets/icons/collab/pdf.svg" alt="Export" class="ico pdf" />    Export as PDF</a></li>
						<li><a class="DFA" href="javascript:void(0);" v-on:click="onClickDownloadImage()">    <img src="/assets/icons/collab/upload-in2.svg" alt="Export" class="ico" /> Export as Image</a></li>
						<!--<li><a v-if="userRights.canWrite" class="DFA" href="javascript:void(0);" v-on:click="onCreatePreview">           <img src="/assets/js/lib/golab/icons/fit_screen-1.svg" alt="Export" class="ico prv" style="width: 24px;" /> Select preview area</a></li>-->
					</ul>
				</div>
				
			</div>
		</div>
    </div>
    
    <div class="DAJ" v-if="settingsPopup.shortcutPopup" >
		<div class="overlay" style="display: block;"></div>
		<div class="add-pop ui-dialog shrtct" style="display: block;" >
			<div class="head">Shortcuts<a href="javascript:void(0);" @click="onCloseShortcutPopup()" title="Close" class="close"></a></div>
			<div class="cntr mrow">
			
				<div class="hd prow">Tools</div>
				<div class="rcut prow">			
				<div v-for="(option,index) in toolsArray" class="rec DFA">
					<div class="ico DFA"><img :src="option.url" alt="option" class="ico" /> </div>
					<div class="sht fs">{{option.key}}</div>
					<div class="txt">{{option.action}}</div>
				</div>
				</div>

				<div class="hd mt-30 prow gn">General</div>
				<div class="rcut prow">
				<div v-for="(option,index) in generalToolsArray" class="rec DFA gn">
					<div class="sht">{{option.key}}</div>
					<div class="txt">{{option.action}}</div>
				</div>
				</div>
				
				<div class="hd mt-30 prow gn">Navigation</div>
				<div class="rcut prow">
				<div v-for="(option,index) in navigationToolsArray" class="rec DFA gn">
					<div class="sht">{{option.key}}</div>
					<div class="txt">{{option.action}}</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	
	<div v-if="notesPopup.show" id="content" class="rightbar">
		<a href="javascript:void(0);" class="close" @click="onCloseNotesSection()" ></a>
		<note-editor :board="boardDetail.board" :user="user" ref="noteEditorComp" :users = "boardActiveUsers"></note-editor>
	</div>


    <div id="node-editing-options" class="node-editing-options menuclb" ref="nodeEditingMenu">
      <node-options-menu ref="optionMenu" @add-emoji="onSelectAddEmoji"/>
	</div>
	
	<div v-if="linkDropPopup.show" :style="{left:linkDropPopup.left, top:linkDropPopup.top}" class="nodhvr show-menu lnkdrp" v-click-outside="onLinkDropClose">
	<ul>
		<li class="button-w btn" @click="onLinkDropCreateNode('SAME');">Add the Same Object</li>
		<li @click="onLinkDropCreateNode('TEXT');"><img class="icon" src="/assets/icons/collab/text1.svg" alt="Text" /></li>
		<li @click="onLinkDropCreateNode('NOTE');"><img class="icon" src="/assets/icons/collab/note-1.svg" alt="Note" /></li>
	
		<li @click="onLinkDropCreateNode('SHAPE', 'Rectangle');">        <img class="icon" src="/assets/icons/collab/box1.svg" alt="rectangle" style="width: 22px;" /></li>
		<li @click="onLinkDropCreateNode('SHAPE', 'RoundedRectangle');"> <img class="icon" src="/assets/icons/collab/rectangle-1.svg" alt="rectangle" /></li>
		<li @click="onLinkDropCreateNode('SHAPE', 'Ellipse');">          <img class="icon" src="/assets/icons/collab/elipse.svg" alt="rectangle" /></li>
		<li @click="onLinkDropCreateNode('SHAPE', 'Dimond');">           <img class="icon" src="/assets/icons/collab/rectangle3.svg" alt="rectangle" /></li>
		<li @click="onLinkDropCreateNode('SHAPE', 'Parallelogram');">    <img class="icon" src="/assets/icons/collab/rectangle2.svg" alt="rectangle" /></li>
		<li @click="onLinkDropCreateNode('SHAPE', 'Triangle');">         <img class="icon" src="/assets/icons/collab/polygon.svg" alt="Polygon" /></li>
    </ul>
    </div>

	<div id="leftnav" v-if="userRights.canWrite" :class="boardDetail.board.locked ? 'disabled' : ''" class="leftnav" tabindex="-1" v-click-outside="onClickOutsideOfTools">	

	  <div class="icon1 tltp" v-for="(option,index) in tools.options" :class="[actionType == option.id ? 'active' : '']" v-on:click="onClickActionType(option)">
		<img :src="option.icon" :style="option.style" alt="" />
		<div class="tltphv bm">{{option.tooltip}}</div>
		<template v-if="option.id == 'pen' ">
			<div v-if="option.expanded" class="nodhvr lftar pen">
				<ul class="DAJ">
					<li v-on:click="onClickShape('BrushPen', $event)" title="Pen" :class="[paintBrush.selectedType=='BrushPen'?'active':'']">  
						<img class="icon" src="/assets/icons/collab/p-pen.svg" alt="rectangle" />
					</li>
					<li v-on:click="onClickShape('BrushHighlighter', $event)" title="Highlighter" :class="[paintBrush.selectedType=='BrushHighlighter'?'active':'']">  
						<img class="icon" src="/assets/icons/collab/p-highlighter.svg" alt="rectangle" />
					</li>
					<li v-on:click="onClickShape('BrushEraser', $event)" title="Eraser" :class="[paintBrush.selectedType=='BrushEraser'?'active':'']">  
						<img class="icon" src="/assets/icons/collab/p-eraser.svg" alt="rectangle" />
					</li>
					<div v-if="paintBrush.selectedType !== 'BrushEraser'" class="sprt mr-lr-10"></div>

					<template v-if=" paintBrush.selectedType === 'BrushPen' ">
					<li v-for="(opt, ind) in paintBrush.penColors" :class="[paintBrush.selectedPen==ind?'active':'']" @click="onClickPainBrush(opt,ind, $event);">  
						<div class="p-circ DAJ"><div class="crcin" :style="{backgroundColor:opt.color, width: ((opt.thickness/15)*22)+'px' , height: ((opt.thickness/15)*22)+'px'}"></div></div>
						
						<template v-if="ind == paintBrush.selectedPen && opt.expand">
							<div class="nodhvr circ">
								<input type="range" min="1" max="10" class="pslider" :style="{backgroundSize: (( ((opt.thickness-1)/9) * 100 )+'%')}" :value="opt.thickness" @change="onChangePainBrushTickness">
								<ul >
									<li v-for="(sopt, soptIndex) in paintBrush.penColorOptions"  @click="onChangePainBrushColor(sopt, $event);">
										<div class="p-circ" :style="{backgroundColor: sopt.value}"></div>
									</li>
								</ul>
							</div>
						</template>
					</li>
					</template>
					
					<template v-if=" paintBrush.selectedType === 'BrushHighlighter' ">
					<li v-for="(opt, ind) in paintBrush.highlighterColors" :class="[paintBrush.selectedHighlighter==ind?'active':'']" @click="onClickPainBrush(opt,ind, $event);">
						<div class="p-circ DAJ"><div class="crcin" :style="{backgroundColor:opt.color, width: ((opt.thickness/15)*22)+'px' , height: ((opt.thickness/15)*22)+'px' }"   ></div></div>

						<template v-if="ind == paintBrush.selectedHighlighter && opt.expand">
							<div class="nodhvr circ">
								<input type="range" min="5" max="15" class="pslider" :style="{backgroundSize: (( ((opt.thickness-5)/10) * 100 )+'%')}" :value="opt.thickness" @change="onChangePainBrushTickness">
								<ul >
									<li v-for="(sopt, soptIndex) in paintBrush.highlighterColorOptions"  @click="onChangePainBrushColor(sopt, $event);">
										<div class="p-circ" :style="{backgroundColor: sopt.value}"></div>
									</li>
								</ul>
							</div>
						</template>

					</li>
					</template>
				</ul>
			</div>
	  	</template>

		<template v-if="option.id == 'shape' ">
			<div v-if="option.expanded" class="nodhvr lftar shape b">
				<ul class="DAJ">
					<li v-on:click="onClickShape('Rectangle', $event)" :class="[(selectedShape==='Rectangle' || selectedShape==='Default')?'active':'']">  <img class="icon" src="/assets/icons/collab/rectangle-1.svg" alt="rectangle" /></li>
					<li v-on:click="onClickShape('RoundedRectangle', $event)" :class="[selectedShape==='RoundedRectangle'?'active':'']">  <img class="icon" src="/assets/icons/collab/rectangle1.svg" alt="rectangle" /></li>
					<li v-on:click="onClickShape('Parallelogram', $event)" :class="[selectedShape==='Parallelogram'?'active':'']">                 <img class="icon" src="/assets/icons/collab/rectangle2.svg" alt="rectangle" /></li>
					<li v-on:click="onClickShape('Diamond', $event)" :class="[selectedShape==='Diamond'?'active':'']">                 <img class="icon" src="/assets/icons/collab/rectangle3.svg" alt="rectangle" /></li>
				</ul>
				<ul class="DAJ">	
					<li v-on:click="onClickShape('FivePointedStar', $event)" :class="[selectedShape==='FivePointedStar'?'active':'']">            <img class="icon" src="/assets/icons/collab/star-s.svg" alt="star" />        </li>
					<li v-on:click="onClickShape('Ellipse', $event)" :class="[selectedShape==='Ellipse'?'active':'']">              <img class="icon" src="/assets/icons/collab/elipse.svg" alt="elipse" />      </li>
					<li v-on:click="onClickShape('Triangle', $event)" :class="[selectedShape==='Triangle'?'active':'']">             <img class="icon" src="/assets/icons/collab/polygon.svg" alt="polygon" />    </li>
					<li v-on:click="onClickShape('Arrow', $event)" :class="[selectedShape==='Arrow'?'active':'']">            <img class="icon" src="/assets/icons/collab/union.svg" alt="star" />        </li>
				</ul>
			</div>
		  </template>
		  <template v-if="option.id == 'frame' ">
			<div v-if="option.expanded" class="nodhvr lftar adfrm"> 
				<div class="DFA" @click="createFrame"><img src="/assets/icons/collab/frame-1.svg" alt="Frame" /> Add Frame</div> 
			</div>
			<!-- <ul class="DAJ">
				<li v-on:click="onClickShape('r_0:0', $event)"  :class="[(selectedFrame==='r_0:0' || selectedShape==='Default')?'active':'']"> Custom</li>
				<li v-on:click="onClickShape('r_16:9', $event)" :class="[(selectedFrame==='r_16:9' || selectedShape==='Default')?'active':'']"> 16 : 9</li>
				<li v-on:click="onClickShape('r_4:3', $event)"  :class="[(selectedFrame==='r_4:3' || selectedShape==='Default')?'active':'']">  4 : 3</li>
				<li v-on:click="onClickShape('r_1:1', $event)"  :class="[(selectedFrame==='r_1:1' || selectedShape==='Default')?'active':'']">  1 : 1</li>
			</ul> -->				
			
	  	</template>
		<template v-else-if="option.id == 'note' ">
			<div v-if="option.expanded" class="nodhvr lftar note">
				<ul>
					<li v-for="(opt, optIndex) in noteColors" v-on:click="onClickShape(opt.value, $event)" >
						<svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M1 34.975V3.025C1 1.90662 1.90662 1 3.025 1H34.975C36.0934 1 37 1.90662 37 3.025V23.6845C37 24.2216 36.7867 24.7366 36.4069 25.1164L24.6734 36.8499C24.5773 36.946 24.4469 37 24.311 37H3.025C1.90662 37 1 36.0934 1 34.975Z" :fill="opt.value+30" :stroke="opt.value" stroke-width="2"/>
						<path d="M24.9375 37V26.45C24.9375 25.6147 25.6147 24.9375 26.45 24.9375H37" :stroke="opt.value" stroke-width="2"/>
						</svg>
					</li>
					<li class="full"><a href="javascript:void(0);" class="button-w" v-on:click="onClickAddNotesInBulk()">Bulk Mode</a></li>
				</ul>
			</div>
		</template>
		<template v-else-if="option.id == 'link' ">
			<div v-if="option.expanded" class="nodhvr lftar arrw">
				<ul class="DAJ">
					<li v-on:click="onClickShape('ArrowSquare', $event)" :class="[(selectedLink==='ArrowSquare'  || selectedLink==='Default')?'active':'']">     <img class="icon" style="max-width: 24px" src="/assets/icons/collab/arrow-square.svg" alt="arrowsquare" /></li>
					<li v-on:click="onClickShape('Arrow', $event)" :class="[selectedLink==='Arrow'?'active':'']"><img class="icon" src="/assets/icons/collab/arrow-s1.svg" alt="" /></li>
           			<li v-on:click="onClickShape('Line', $event)"  :class="[selectedLink==='Line'?'active':'']"> <img class="icon" src="/assets/icons/collab/arrow-s2.svg" alt="" /></li>
           			<!--<li v-on:click="onClickShape('Bubble', $event)":class="[selectedLink==='Bubble'?'active':'']"> <img class="icon" src="/assets/icons/collab/arrow-s4.svg" alt="" /></li>-->
				</ul>
			</div>
	  	</template>
	  	<template v-else-if="option.id == 'image' ">
			<input accept="image/*" type="file" id="upload-file" name="upload" @change="onChooseImageFile" style="display: none;" />

	  	</template>
	  </div>
    </div>
<!--    <div v-if="boardPreview.isControls" class="leftnav ">-->
<!--    	<div>Select area for preview </div>-->
<!--		<a  href="javascript:void(0);" @click="onSaveBoardPreview"> Save </a>-->
<!--		<a  href="javascript:void(0);" @click="onCancelBoardPreview"> Cancel </a>-->
<!--	</div>-->
    <div class="btmbar1" style="display: none;">
      <div class="icon1"><label><input type="checkbox" onclick="board.allowRotate = !board.allowRotate;   updateAllAdornments()" checked="checked" />Allow Rotating</label></div>
      <div class="icon1"><label><input type="checkbox" onclick="board.allowReshape = !board.allowReshape; updateAllAdornments()" checked="checked" />Allow Reshaping</label></div>
      <div class="icon1"><label><input type="checkbox" onclick="board.allowResize = !board.allowResize;   updateAllAdornments()" checked="checked" />Allow Resizing</label></div>
      <div class="icon1" onclick="board.undoManager.undo()"><img src="/assets/js/lib/golab/icons/undo-1.svg" alt="-" /></div>
      <div class="icon1" onclick="board.undoManager.redo()"><img src="/assets/js/lib/golab/icons/redo-1.svg" alt="-" /></div>
    </div>
  <!-- <div class="btmcanv"> -->
      <!--<div id="miniboard" class="mncanvs"></div>-->
      <div class="cnvsico" style="display:none">
        <!-- <div class="icon1" onclick="board.zoomToFit();"><img src="/assets/js/lib/golab/icons/fit_screen-1.svg" alt="" /></div> -->
        <!-- <div class="icon1" v-on:click="onClickDownloadPdf()" ><img src="/assets/js/lib/golab/icons/file_download.svg" alt="" /></div>
        <div class="icon1" v-on:click="onClickDownloadImage()" ><img src="/assets/js/lib/golab/icons/file_download.svg" alt="" /></div> -->
        <!--
        <div class="icon1">
	        <input id="file-input" style="display: none" type="file" accept="image/*" @change="onUploadImageNode">
			<label for="file-input"><img src="/assets/icons/collab/unlock.svg" alt="" /></label>
        </div>
        -->
        <!--<div class="icon1"><img src="/assets/icons/collab/unlock.svg" alt="" /></div>
        <div class="icon1"><img src="/assets/icons/layers.svg" alt="" /></div>
        <div class="icon1" v-on:click="onShowTemplatePopup()"><img src="/assets/icons/settings.svg" alt="" /></div>
        <div class="icon1" v-on:click="onclickShareUrl()" ><img src="/assets/js/lib/golab/icons/share.svg" alt="" /></div>
        <div class="icon1"  v-on:click="onclickShareUrl()" ><img src="/assets/js/lib/golab/icons/share.svg" alt="" /></div>-->
      </div>
   <!--</div>-->
	<ul id="nodeContextMenu" class="menuclb txtmnu">

	  	<li id="nodeContextMenu_pushBack"  class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);">  <div class="ico"><img src="/assets/icons/collab/flip_back.svg" alt="Add" /></div>  Send to Back</li>
		<li id="nodeContextMenu_pullFront" class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/flip_front.svg" alt="Add" /></div> Bring to Front</li>
		<li class="sprtV"></li>
		<li id="nodeContextMenu_crt-same"  class="menu-item DFA mr-e" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/duplicate.svg" alt="Add" /></div> Duplicate</li>
		<li id="nodeContextMenu_cut"       class="menu-item DFA mr-f" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/cut.svg" alt="Add" /></div>       Cut</li>
		<li id="nodeContextMenu_copy"      class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/copy.svg" alt="Add" /></div>      Copy</li>
		<li id="nodeContextMenu_paste"     class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/paste.svg" alt="Add" /></div>     Paste</li>
		<li id="nodeContextMenu_delete"    class="menu-item DFA mr-d" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/delete.svg" alt="Add" /></div>    Delete</li>
      
	</ul>
	<ul id="frameContextMenu" class="menuclb txtmnu">
		<li id="frameContextMenu_crt-note"  class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/note-1.svg" alt="Add" /></div> Add Sticky Note</li>
		<li id="frameContextMenu_crt-text"  class="menu-item DFA mr-b" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/text1.svg" alt="Add" /></div> Add Text</li>
		<!-- <li class="sprtV"></li>
		<li id="frameContextMenu_pushBack"  class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);">  <div class="ico"><img src="/assets/icons/collab/flip_back.svg" alt="Add" /></div>  Send to Back</li>
		<li id="frameContextMenu_pullFront" class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/flip_front.svg" alt="Add" /></div> Bring to Front</li> -->
		<li class="sprtV"></li>
		<li id="frameContextMenu_crt-same"  class="menu-item DFA mr-e" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/duplicate.svg" alt="Add" /></div> Duplicate</li>
		<li id="frameContextMenu_cut"       class="menu-item DFA mr-f" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/cut.svg" alt="Add" /></div>       Cut</li>
		<li id="frameContextMenu_copy"      class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/copy.svg" alt="Add" /></div>      Copy</li>
		<li id="frameContextMenu_paste"     class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/paste.svg" alt="Add" /></div>     Paste</li>
		<li id="frameContextMenu_delete"    class="menu-item DFA mr-d" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/delete.svg" alt="Add" /></div>    Delete</li>		
	</ul>
	<ul id="boardContextMenu" class="menuclb txtmnu">
	  <li id="boardContextMenu_paste"     class="menu-item DFA mr-a" onclick="onContextMenuCommand(event);"> <div class="ico"><img src="/assets/icons/collab/paste.svg" alt="Add" /></div>     Paste</li>
    </ul>
   
	<div class="menuclb lftmn lft DF DAJ" :class="boardDetail.board.locked ? 'disabled' : ''">	
		<div class="tltp" :class="[selectedAction == 'zoomToFit' ? 'active icon1' : 'icon1']" @click="onToggleZoomToFit">
			<img src="/assets/js/lib/golab/icons/fit_screen-1.svg" alt="" />
			<div class="tltphv bm">Zoom to fit content </div>
		</div>
		<div class="tltp" :class="[selectedAction == 'fullScreen' ? 'active icon1 ent' : 'icon1 ent']" @click="onToggleFullScreen">
			<img src="/assets/icons/collab/zoom-1.svg" alt="" />
			<div class="tltphv bm">Enter/Exit Full Screen</div>
		</div>
		<div class="tltp" :class="[selectedAction == 'miniMap' ? 'active icon1 mini' : 'icon1 mini tltp']" @click="onToggleMiniboard">
			<span class="img"></span>
			<div class="tltphv bm">Mini Map </div>
		</div>

		<div class="tltp" v-if="userRights.canWrite && !isPublicLinkUrl" :class="[selectedAction == 'templates' ? 'active icon1 m' : 'icon1 m']" @click="onClickOpenTemplatesPopup">
			<img src="/assets/icons/collab/templt-1.svg" alt="Templates" class="icoflt">
			<div class="tltphv bm">Apply Template</div>
		</div>
		
		<div class="sprt mr-lr-10"></div>
		<div class="icon1 p tltp" @click="onChangeZoomScale(-1);" ><img src="/assets/icons/collab/minus.svg" alt="" />
			<div class="tltphv bm">Zoom out</div>
		</div>
		<div class="icon1 t">{{zoomPercentage}}%</div>
		<div class="icon1 p tltp" @click="onChangeZoomScale(1);"><img src="/assets/icons/collab/plus.svg" alt="" />
			<div class="tltphv bm">Zoom in</div>
		</div>
	</div>
	
	<div v-show="miniBoard.show" id="miniboard" class=""></div>
	
	<!--<a class="lfhelp" href="javascript:void(0)"><img src="/assets/icons/collab/help.svg" alt="" /></a>-->
	
	<div class="menuclb lftmn rht DF" style="right:315px;">
		<div class="icon1 a"><img src="/assets/icons/collab/rhtshp1.svg" alt="" /></div>
		<div class="icon1 b"><img src="/assets/icons/collab/rhtshp2.svg" alt="" /></div>
		<div class="icon1 c"><img src="/assets/icons/collab/rhtshp3.svg" alt="" /></div>
	</div>
    
    <create-share-url2 v-if="shareBoardPopup.show" @close-popup="onCloseShareBoardPopup" @update-board-detail="updateBoardDetail" @save="onCreateUrl" @stop-share = "onStopShareUrl" @delete-collaborator="deleteCollaborator" :board="boardDetail.board" :share-board-rights="boardDetail.metaMap.shareBoardRights"></create-share-url2>
    <save-as-template v-if="saveAsTemplatePopup.show" :boardId = boardId :board="boardDetail.board" :image="saveAsTemplatePopup.boardImage" @close-template="onCloseSaveAsTemplatePopup" @save-template="onSaveAsTemplatePopup" ></save-as-template>
 <!--   <board-preview v-if="boardPreview.show" :boardImage = boardPreview.boardIamge @close-preview="onClosePreviewPopup" @save-preview="onSaveBoardPreview"></board-preview>-->
	<edit-board-settings v-if="editBoardSettingsPopup.show" :board="boardDetail.board" :user="user" @close-popup="onCloseEditBoardSettingsPopup" @save-board-settings="onSaveBoardSettings"></edit-board-settings> 
	<add-bulk-notes v-if="openBulkModeForNotes" :board="boardDetail.board" @close-popup="onCloseBulkNotesSection"></add-bulk-notes> 
	<template-popup v-if="templatePopup.show" :flag="'apply-template'" :list="templatePopup.list" @close-template-popup="onCloseTemplatePopup"></template-popup>
	<share-public-link v-if="sharePublicLinkPopup.show" :board="boardDetail.board" @close-share-link-popup="onCloseShareLinkPopup"></share-public-link>
	
	</div>
  <div id="content" class="leftbar" v-if="framesList.show">
		<div class="head poppins">Frames <a href="javascript:void(0)" class="close" @click="onCloseFramesList();clearFramesMap();"></a></div>
		<div class="cont">
	      <ul>
			<li v-for="(data, key) in allFramesModelData" v-on:click = "onFrameListSelectFrame(key)">
				<frame-diagram :model=data :id=key></frame-diagram>  
				<a href="javascript:void(0)" class="over">Frame: {{data.text}}</a>
			</li>
	      </ul>
		</div>
    </div>
</div>

	
		`,
	props: ["boardData", "access", "list", "anonymousUser","companyId","isLoggedIn","tenant"],

	data() {
		return {
			user: {},
			boardContext: "",
			clickedContext: "",
			boardStarredFlagValue: false,
			profilePicturePath: undefined,
			selectedNodes: {},
			shapeToDraw: "Rectangle",
			desiredSize: "120 60",
			noteColors: _noteColors,

			noteTemplate: { category: "NOTE", linkable: true, angle: 0, size: "250 250", lock: false, border: "black", fill: "#FCFAA2", text: "", textPosition: 0, textSize: "Auto", autoFont: 10, textColor: "#000", showText: false, isEditable: true, reactions: [], lockBy: "", link: "", linkTo: "", bold: false, italic: false, underline: false },
			shapeTemplate: { category: "SHAPE", linkable: true, angle: 0, size: "250 250", lock: false, text: "", textPosition: 0, textSize: 12, textColor: "#000", showText: false, isEditable: true, lockBy: "", link: "", linkTo: "", bold: false, italic: false, underline: false },
			textTemplate: { category: "TEXT", linkable: true, angle: 0, width: 250, lock: false, fill: "white", border: "black", text: "", textPosition: 0, textSize: 12, textColor: "#000", showText: false, isEditable: true, lockBy: "", link: "", linkTo: "", bold: false, italic: false, underline: false },
			frameTemplate: { category: "FRAME", isGroup: true, angle: 0, lock: false, isEditable: true, lockBy: "", showHeader: false, text: "Frame", textAlignment: "left", textSize: 12, textColor: "#ffffff", textBg: "#000000", link: "", linkTo: "", bold: false, italic: false, underline: false, notAllowedItems: [] },
			linkTemplate: { category: "Arrow", isGroup: true, angle: 0, lock: false, fill: "black", toArrow: "none", fromArrow: "none", fromPortId: "", toPortId: "", thickness: 2.5, route: 0, lineType: 0, text: "", textPosition: 0, textSize: 12, textColor: "#000", showText: false, isEditable: true, bold: false, italic: false, underline: false },

			actionType: "none",
			subActionType: "none",
			selectedItemType: "abc",
			selectedShape: {},
			selectedNote: {},
			selectedFrame: {},
			selectedLink: {},
			selectedPaintBrush: {},
			selectedAction: '',
			paintBrush: {
				selectedType: "",
				selectedPen: 0,
				selectedHighlighter: 0,
				penColorOptions: _colorOptions,
				highlighterColorOptions: _colorOptions,
				penColors: [
					{ thickness: 1, color: _colorOptions[1].value, expand: false },
					{ thickness: 3, color: _colorOptions[2].value, expand: false },
					{ thickness: 5, color: _colorOptions[3].value, expand: false }
				],
				highlighterColors: [
					{ thickness: 5, color: _colorOptions[1].value, expand: false },
					{ thickness: 8, color: _colorOptions[2].value, expand: false },
					{ thickness: 12, color: _colorOptions[3].value, expand: false }
				]
			},

			boardId: "",
			nodes: [],
			links: [],
			boardStyle: { backgroundColor: "" , letterSpacing: "0px"},
			boardDetail: {
				board: {},
				expand: false,
				savingAnimation: false,
				isActiveUser: true,
				isCollaboratorsCursor: true,
				errorWhileSaving: false,
			},
			companyUsers: [],

			framesList: {
				show: false,
				list: []
			},
			miniBoard: {
				show: false,
			},
			collaboratorsPopup: {
				show: false,
				list: []
			},
			profilePopup: {
				show: false,
			},
			notesPopup: {
				show: false,
			},
			frames: [],
			shareBoardPopup: { show: false },
			editBoardSettingsPopup: { show: false },
			saveAsTemplatePopup: { show: false, model: [] },
			hostUrl: "",
			shareUrl: "",
			tools: {
				linkActive: false,
				options: [
					{
						id: "pointer",
						value: "pointer",
						icon: "/assets/icons/collab/pointer1.svg",
						expanded: false,
						tooltip: "Selection Tool"
					},
					{
						id: "panning",
						value: "panning",
						icon: "/assets/icons/collab/hand2.svg",
						expanded: false,
						tooltip: "Panning Tool"
					},
					{
						id: "note",
						value: "note",
						icon: "/assets/icons/collab/note-yellow.svg",
						expanded: false,
						tooltip: "Stick Note Tool",
                        style: "width: 80%"
					},
					{
						id: "shape",
						value: "Rectangle",
						icon: "/assets/icons/collab/rectangle-1.svg",
						expanded: false,
						tooltip: "Shape Tool"
					},
					{
						id: "pen",
						value: "pencil",
						icon: "/assets/icons/collab/pen1.svg",
						expanded: false,
						tooltip: "Drawing Tools"
					},
					{
						id: "text",
						value: "text",
						icon: "/assets/icons/collab/text1.svg",
						expanded: false,
						tooltip: "Text Tool"
					},
					{
						id: "frame",
						value: "frame",
						icon: "/assets/icons/collab/frame-1.svg",
						expanded: false,
						tooltip: "Frame Tool"
					},
					{
						id: "link",
						value: "ArrowSquare",
						icon: "/assets/icons/collab/arrow-square.svg",
						expanded: false,
						tooltip: "Linking Tools"
					},
					{
						id: "image",
						value: "Picture",
						icon: "/assets/icons/upload-image.svg",
						expanded: false,
						tooltip: "Upload Image"
					}
				]
			},
			search: {
				query: "",
				items: [],
				focusedItem: -1
			},
			exportPopup: {
				show: false
			},
			settingsPopup: {
				show: false,
				shortcutPopup: false
			},
			isShareEnable: false,
			zoomPercentage: 100,
			isRedoEnable: false,
			isUndoEnable: false,
			templates: [],
			noteActiveUsers: [],
			boardActiveUsers: [],
			attentionManagement: {
				broadcast: false,
				following: false,
				followName: "",
				followingList: []
			},
			boardPreview: {
				show: false,
				isLeftNav: true,
				isControls: false,
				boardIamge: ""
			},
			openBulkModeForNotes: false,
			boardScale: 0,
			loaderShow: false,
			goToNode: "",

			linkDropPopup: {
				show: false,
				left: "1px",
				top: "1px",
				linkData: {}
			},
			mouseSendSocketReqCount: 0,
			mouseReceiveSocketReqCount: 0,
			activitySendSocketReqCount: 0,
			activityReceiveSocketReqCount: 0,
			showMessageWithHyperlink: false,
			templatePopup: {
				show: false,
				list: [],
			},
			toolsArray: [
				{ key: 'V', action: 'select tool', url: "/assets/icons/collab/pointer1.svg" },
				{ key: 'T', action: 'text', url: "/assets/icons/collab/text1.svg" },
				{ key: 'N', action: 'sticky note', url: "/assets/icons/collab/note-1.svg" },
				{ key: 'S', action: 'shapes', url: "/assets/icons/collab/rectangle-1.svg" },
				{ key: 'L', action: 'connection line', url: "/assets/icons/collab/arrow-s1.svg" },
				{ key: 'P', action: 'pen', url: "/assets/icons/collab/pen1.svg" },
				{ key: 'F', action: 'frames', url: "/assets/icons/collab/frame-1.svg" },
				{ key: 'M', action: 'minimap', url: "/assets/icons/collab/map.svg" },
				{ key: 'A', action: 'panning', url: "/assets/icons/collab/hand2.svg" },
			],
			generalToolsArray: [
				{ key: 'Ctrl+A ', action: 'select all' },
				{ key: 'PgUp', action: 'bring to front' },
				{ key: 'PgDn', action: 'push to back' },
				{ key: 'esc', action: 'select tool' },
				{ key: 'enter', action: 'edit text' },
				{ key: 'backspace', action: 'delete' },
			],
			navigationToolsArray: [
				// { key: 'Ctrl +', action: 'zoom in' },
				// { key: 'Ctrl -', action: 'zoom out' },
				{ key: 'Shift + 1 ', action: 'Zoom to fit content' },
				{ key: 'Ctrl + F ', action: 'search' },
			],
			boardVersion: 0,
			boardHistory: {
				show: false
			},
			unnamedUser: {},
			sharePublicLinkPopup: {
				show: false,
			},
			isPublicLinkUrl: false,
			userRights: {
				canWrite: false,
				canRead: true,
				canManageTemplate: false
			},
			loggedInUserWorkSpacesMap: [],
			showCloudSuccessIcon: false,
			currentTempNodeKey: '',
		}
	},
	watch: {
		$route(to, from) {
			console.log(to);
			console.log(from);
			zoomToFitNodeWithKey(to.params.goTo, true, 1)
		}
	},
	mounted() {
		vueGoInstance = this;

		this.getClickedContext();

		var url = window.location.pathname;
		
		
		if (url.includes("template")) {
			//vueGoInstance.isBoardLocked = true;
		}
		
		if (!url.includes("public_share")) {
			if (this.$route && this.$route.params && this.$route.params.goTo) {
				this.goToNode = this.$route.params.goTo;
			}
			this.isPublicLinkUrl = false;
		}
		else {
			this.isPublicLinkUrl = true;
		}
		this.unnamedUser = this.anonymousUser;

		hideLeftHeader();
		this.loadUser();

		if (_.isEmpty(this.boardData)) {
			this.boardId = this.$route.params.id
		}
		else {
			this.boardId = this.boardData;
		}

		if (this.isPublicLinkUrl) {

		}else {
			this.userRights.canWrite = true;
		}

		initializeBoard();
		initializeCollabApi();
		initializeCollabPusher();

		this.loadBoardModel();
		this.loadCompanyUsers();

		var linkingTool = board.toolManager.findTool("Linking");
		linkingTool.archetypeLinkData = this.linkTemplate;
		linkingTool.temporaryLink = getLinkTemplateArrow();

		document.onkeyup = function (event) {
			onDocummentKeyDown (event);
		};
	},
	computed: {
		allFramesModelData: function () {
			var frameMap = {}
			this.nodes.forEach(node => {
				if (node.category === "FRAME") {
					frameMap[node.key] = node
				}
			})
			return frameMap;
		},
	},
	created() {

		//this.actionType = "pointer";
		vueGoInstance = this;
		this.hostUrl = location.protocol + '//' + location.host;

		setTimeout(function () {
			this.templates = store.getters.getTemplates();
		}, 5000);
		//this.templates = store.getters.getTemplates();

		//.......................
		this.$options.shapesDetailMap = {
			"Default": { icon: "/assets/icons/collab/rectangle-1.svg" },

			"Rectangle": { icon: "/assets/icons/collab/rectangle-1.svg" },
			"RoundedRectangle": { icon: "/assets/icons/collab/rectangle1.svg" },
			"Parallelogram": { icon: "/assets/icons/collab/rectangle2.svg" },
			"Diamond": { icon: "/assets/icons/collab/rectangle3.svg" },

			"FivePointedStar": { icon: "/assets/icons/collab/star-s.svg" },
			"Ellipse": { icon: "/assets/icons/collab/elipse.svg" },
			"Triangle": { icon: "/assets/icons/collab/polygon.svg" },
			"Arrow": { icon: "/assets/icons/collab/union.svg" }
		};
		this.$options.linksDetailMap = {
			"Default": { icon: "/assets/icons/collab/arrow-square.svg" },
			"Arrow": { icon: "/assets/icons/collab/arrow-s1.svg" },
			"Line": { icon: "/assets/icons/collab/arrow-s2.svg" },
			"Bubble": { icon: "/assets/icons/collab/arrow-s4.svg" },
			"ArrowSquare": { icon: "/assets/icons/collab/arrow-square.svg" },
		};
	},
	beforeDestroy() {
		clearPusher();
	},
	methods: {

		///////////////////////////////////////////////////////
		///////////////      PUBLIC 
		showOrHideCloudSuccessIcon: function () {
			var _this = this;
			_this.showCloudSuccessIcon = true;
			setTimeout(function () {
				//document.getElementById('cloud_success').style.visibility = "hidden";
				_this.showCloudSuccessIcon = false;
			}, 3000);
		},
		isBoardLocked: function () {
			return this.boardDetail.board.locked;
		},
		enableUndoRedo: function () {
			//if undo true
			if (board.undoManager.canUndo()) {
				this.isUndoEnable = true;
			} else {
				this.isUndoEnable = false;
			}

			//if redo true
			if (board.undoManager.canRedo()) {
				this.isRedoEnable = true;
			} else {
				this.isRedoEnable = false;
			}
		},
		cancelCreateLinkTool: function () {
			this.actionType = "none";
			var tool = board.toolManager.findTool("DragCreating");
			if (tool !== null) tool.isEnabled = false;
			var tool = board.toolManager.findTool("FreehandDrawing");
			if (tool !== null) tool.isEnabled = false;
			this.tools.linkActive = false;
		},
		selectToolbarOptionLink: function () {
			var link_option = _.find(this.tools.options, { id: "link" });
			this.onClickActionType(link_option);
		},
		updateArcheTypeNodeData: function (nodeType, property, value, shape) {

			if (nodeType === "FreehandDrawing") {
				return;
			}
			if (property === "text" || property === "reactions") {
				return;
			}

			if (property === "size") {
				var newSize = value.copy();
				newSize = new go.Size(newSize.width * board.scale, newSize.height * board.scale);
				value = go.Size.stringify(newSize);
			}

			var template;

			if (nodeType === "NOTE") {
				template = this.noteTemplate;
				template.reactions = [];
			}
			else if (nodeType === "FRAME") {
				template = this.frameTemplate;
			}
			else if (nodeType === "SHAPE") {
				template = this.shapeTemplate;
			}
			else if (nodeType === "Arrow") {
				template = this.linkTemplate;
				if(!shape || shape === "Arrow"){
					template.route = 1;
				}
				else if(shape === "Line"){
					template.route = 1;
				}
				else if(shape === "Bubble"){
					template.route = 1;
				}
				else if(shape === "ArrowSquare"){
					template.route = 2;
				}
			}
			else if (nodeType === "TEXT") {
				template = this.textTemplate;
			}
			else if (nodeType === "PICTURE") {
				template = this.textTemplate;
			}
			template[property] = value;

			var templateStr = JSON.stringify(template);

			localStorage.setItem(this.boardDetail.board.id + ":defaultTemplateData:" + nodeType, templateStr);
		},
		getDataObjectWithCategory: function (nodeType) {

			if (nodeType === "NOTE") {
				return _.cloneDeep(this.noteTemplate);
			}
			else if (nodeType === "FRAME") {
				return _.cloneDeep(this.frameTemplate);
			}
			else if (nodeType === "SHAPE") {
				return _.cloneDeep(this.shapeTemplate);
			}
			else if (nodeType === "Arrow") {
				return _.cloneDeep(this.linkTemplate);
			}
			else if (nodeType === "TEXT") {
				return _.cloneDeep(this.textTemplate);
			}
			return "";
		},
		lockSelectedNode: function () {

		},
		/////////////////////////////////////////////////////////
		/////////////      HELPER
		addNoteActiveUser: function () {
			sendSocketRequest({ "synId": synId, "category": "note", "eventType": "addNoteActiveUser", "userId": this.user.id, "user": this.boardActiveUsers, "boardId": this.boardId });
		},
		updateExistingNodesOnTemplateSave: function (existingNodesList) {
			let requestBody = existingNodesList;
			axios.post('/graphx/node/update_template/' + vueGoInstance.boardDetail.board.id, requestBody)
				.then(response => {

					if (response) {
						console.log(response);
					}

				})
				.catch(error => {
					console.log(error);
				});
		},

		getClickedContext: function () {
			const hash = window.location.hash;
			const queryString = hash.split('?')[1];
			let context = "";
			let id = "";

			if (queryString) {
				const params = new URLSearchParams(queryString);
				const art = params.get('art');
				const session = params.get('session');
				const solution = params.get('solution');
				id  = "";
				if (art) {
					context = "workspace";
					this.clickedContext = "/org#/ART/";
					id = art;
				} else if (session) {
					console.log("Session ID:", session);
					context = "session";
					this.clickedContext = "/session?id=";
					id = session;
				} else if (solution) {
					console.log("Solution ID:", solution);
					context = "solution";
					this.clickedContext = "/solutions#/";
					id = solution;
				}
			}

			let requestBody = {
				context: context,
				id: id,
			};

			axios.post('/graphx/get/clickedContext', requestBody)
				.then(response => {
					if (response.data) {
						this.boardContext = response.data.context;
					}
				})
				.catch(error => {
					console.log(error);
				});
		},

		updateExistingLinksOnTemplateSave: function (existingLinksList) {
			let requestBody = existingLinksList;
			axios.post('/graphx/link/update_template/' + vueGoInstance.boardDetail.board.id, requestBody)
				.then(response => {

					if (response) {
						this.loaderShow = false;
						showTopMessage('Template saved successfully', 'success');
						console.log(response);
					}

				})
				.catch(error => {
					console.log(error);
				});
		},
		getUserInitials: function (anonymousUser) {
			var initials = "";
			if(anonymousUser) {
				if(!_.isEmpty(anonymousUser.name)) {
					initials += anonymousUser.name.substring(0, 1);
				}
			}
			else {
				if (!_.isEmpty(this.user.firstName)) {
					initials += this.user.firstName.substring(0, 1);
				}
				if (!_.isEmpty(this.user.lastName)) {
					initials += this.user.lastName.substring(0, 1);
				}
			}
			return initials.toUpperCase();
		},
		getActiveUserInitials: function (firstName, lastName) {
			var initials = "";
			//	if (this.user) {
			if (!_.isEmpty(firstName)) {
				initials += firstName.substring(0, 1);
			}
			if (!_.isEmpty(lastName)) {
				initials += lastName.substring(0, 1);
			}
			//	}
			return initials.toUpperCase();
		},
		enableDefaultTools: function (enable) {
			if (board.toolManager.actionTool) board.toolManager.actionTool.isEnabled = enable;
			if (board.toolManager.clickSelectingTool) board.toolManager.clickSelectingTool.isEnabled = enable;
			if (board.toolManager.dragSelectingTool) board.toolManager.dragSelectingTool.isEnabled = enable;
			if (board.toolManager.resizingTool) board.toolManager.resizingTool.isEnabled = enable;
			if (board.toolManager.draggingTool) board.toolManager.draggingTool.isEnabled = enable;
			if (board.toolManager.rotatingTool) board.toolManager.rotatingTool.isEnabled = enable;
		},
		enableCreationTools: function (enable) {
			if (board.toolManager.clickCreatingTool) board.toolManager.clickCreatingTool.isEnabled = enable;
			var dragCreating = board.toolManager.findTool("DragCreating");
			if (dragCreating) dragCreating.isEnabled = enable;
		},
		setFrameType: function (type) {

			if (type.startsWith("r_")) {
				var cols = type.split("_");
				cols = cols[1].split(":");

				this.updateArcheTypeNodeData("FRAME", "type", "ratio");
				this.updateArcheTypeNodeData("FRAME", "sizeRatio", [parseFloat(cols[0]), parseFloat(cols[1])]);
			}
			else {

			}
			var dragCreating = board.toolManager.findTool("DragCreating");
			if (dragCreating) {
				var ratio = 0;
				if (this.frameTemplate.sizeRatio && this.frameTemplate.sizeRatio[0] > 0) {
					ratio = this.frameTemplate.sizeRatio[0] / this.frameTemplate.sizeRatio[1];
				}
				dragCreating.widthToHeightRatio = ratio;
			}
		},
		createFrame: function () {

			var parts = board.findPartsIn(board.viewportBounds
				,
				function (part) {
					return (part instanceof go.Group) ? part : null;
				},
				function (part) {
					return part.data && part.data.category === "FRAME";
				}
				, true);

			var rect;
			if (parts.count > 0) {
				parts = parts.toArray();
				var rightMostIndex = -1
				var rightMostPosition = -1000000;

				for (var i = 0; i < parts.length; i++) {
					var frame = parts[i];
					var pos = frame.actualBounds.x + frame.actualBounds.width;
					if (pos > rightMostPosition) {
						rightMostPosition = pos;
						rightMostIndex = i;
					}
				}

				var marginFromLeft = 20;
				var rightMostFrame = parts[rightMostIndex];

				var size;
				if (this.frameTemplate.size) {
					size = go.Size.parse(this.frameTemplate.size);
					rect = new go.Rect(rightMostFrame.location.x + rightMostFrame.actualBounds.width + marginFromLeft, rightMostFrame.location.y, size.width / board.scale, size.height / board.scale);
				}
				else {
					var width = board.viewportBounds.width * 0.5;
					var height = board.viewportBounds.height * 0.7;
					rect = new go.Rect(rightMostFrame.location.x + rightMostFrame.actualBounds.width + marginFromLeft, rightMostFrame.location.y, width, height);
				}
				this.updateArcheTypeNodeData("FRAME", "size", rect.size);
			}
			else {

				var width = board.viewportBounds.width * 0.5;
				var height = board.viewportBounds.height * 0.7;

				rect = new go.Rect(board.viewportBounds.centerX - (width * 0.5), board.viewportBounds.centerY - (height * 0.5), width, height);

				this.updateArcheTypeNodeData("FRAME", "size", rect.size);
			}

			var copyData = _.cloneDeep(this.frameTemplate);
			copyData.loc = "" + rect.x + " " + rect.y;

			board.model.startTransaction(MOD_TRNS_FRAME_ADD);
			board.model.addNodeData(copyData);
			board.model.commitTransaction(MOD_TRNS_FRAME_ADD);

			zoomToFitFrame(rect);
		},
		getUrlParameter: function(sParam) {
                var sPageURL = decodeURIComponent(window.location.search.substring(1)),
                    sURLVariables = sPageURL.split('&'),
                    sParameterName,
                    i;

                for (i = 0; i < sURLVariables.length; i++) {
                    sParameterName = sURLVariables[i].split('=');

                    if (sParameterName[0] === sParam) {
                        return sParameterName[1] === undefined ? true : sParameterName[1];
                    }
                }
        },
		getUrlHashParameter : function(sParam){
			var sPageURL = decodeURIComponent(window.location.hash.substring(1)),
                    sURLVariables = sPageURL.split('&'),
                    sParameterName,
                    i;
			for (i = 0; i < sURLVariables.length; i++) {
                    sParameterName = sURLVariables[i].split('=');
					var sParameterName2 = sParameterName[0].split("?")
                    if (sParameterName2[1] === sParam) {
                        return sParameterName[1] === undefined ? true : sParameterName[1];
                    }
                }
		},
		setNodeAndLinks: function () {
			this.nodes = board.model.nodeDataArray;
			this.links = board.model.linkDataArray;
		},
		clearFramesMap: function () {
			framesMap = new Map();
		},
		//////////////////////////////////////////////////////////
		/////////////     EVENTS
		onClickRedirectToActiveSessionBoard: function () {
			// console.log("board detail is : ", this.boardDetail);
			if(this.clickedContext.includes("session")){
				window.location  = this.clickedContext + this.boardContext?.activeSessionBoard;
			}else{
				window.location  = this.clickedContext + this.boardContext?.id;
			}
			// if(this.boardDetail.board.session) {
			// 	window.location =  'session' + '?id=' + this.boardDetail.board.session.activeSessionBoard;
			// } else if (this.boardDetail.board.solutionBoard) {
			// 	window.location =  'solutions#' + '/board?id=' + this.boardDetail.board.solutionBoard.id;
			// }
		},
		onClickLogo: function (board) {
			if(this.isPublicLinkUrl){
				window.location = "https://kendis.io/";
			}else{
				if(this.clickedContext.includes("session")){
					window.location  = this.clickedContext + this.boardContext?.activeSessionBoard;
				}else{
					window.location  = this.clickedContext + this.boardContext?.id;
				}
				// if(board.session) {
				// 	window.location =  'session' + '?id=' + board.session.activeSessionBoard;
				// } else if (board.solutionBoard) {
				// 	window.location =  'solutions#' + '/board?id=' + board.solutionBoard.id;
				// }
			}

		},
		onBringAllToMe: function () {

			if (this.isPublicLinkUrl) {
				return;
			}

			this.attentionManagement.broadcast = true;
			this.attentionManagement.following = false;
			this.attentionManagement.followingList = [];
			showTopMessage("You bring everyone to your screen")
			var reqData = {
				"category": "changeViewPort", "eventType": "broadcast", "position": go.Point.stringify(board.position),
				"scale": board.scale, "boardId": this.boardId, "broadcast": true, "followName": loggedInUser.firstName
			}
			sendSocketRequest(reqData)
		},
		onUnfollowAttention: function () {

			if (this.isPublicLinkUrl) {
				return;
			}

			this.attentionManagement.following = false;
			this.attentionManagement.followName = "";
			var reqData = {
				"category": "changeViewPort", "eventType": "unfollow",
				"userId": loggedInUser.id, "boardId": this.boardId
			}
			sendSocketRequest(reqData)
		},
		onFollowAttention: function (data) {

			// if (this.isPublicLinkUrl) {
			// 	return;
			// }

			// this.attentionManagement.broadcast = false;
			// this.attentionManagement.following = true;
			// this.attentionManagement.followName = data.firstName;
			// this.attentionManagement.followingList = [];
			// var reqData = {
			// 	"category": "changeViewPort", "eventType": "follow",
			// 	"leaderId": data.id, "followerId": loggedInUser.id, "boardId": this.boardId
			// }
			// sendSocketRequest(reqData)
		},
		onToggleMiniboard: function () {
			this.miniBoard.show = !this.miniBoard.show;
			if (this.miniBoard.show) {
				localStorage.setItem(this.boardDetail.board.id + "-hideMiniboard", "true");
				this.selectedAction = 'miniMap';
			} else {
				localStorage.setItem(this.boardDetail.board.id + "-hideMiniboard", "");
				this.selectedAction = '';
			}
		},
		onClickUndo: function () {
			var _this = this;
			if (board.undoManager.canUndo()) {
				board.undoManager.undo();
				_this.$forceUpdate();
			} else {
				_this.isUndoEnable = false;
			}
		},
		onClickRedo: function () {
			if (board.undoManager.canRedo()) {
				board.undoManager.redo();
			} else {
				this.isRedoEnable = false;
			}
		},
		onChangeGridBackground: function (id) {
			var dottedGrid = $gojs(go.Panel, "Grid", { gridCellSize: new go.Size(10, 10) },
				$gojs(go.Shape, "LineH", { strokeDashArray: [1, 9], stroke: "gray" }));
			var boxGrid = $gojs(go.Panel, "Grid", {},
				$gojs(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.05 }),
				$gojs(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.1, interval: 10 }),
				$gojs(go.Shape, "LineH", { stroke: "lightgray", strokeWidth: 0.3, interval: 20 }),
				$gojs(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.05 }),
				$gojs(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.1, interval: 10 }),
				$gojs(go.Shape, "LineV", { stroke: "lightgray", strokeWidth: 0.3, interval: 20 })
			);
			var plainGrid = $gojs(go.Panel, "Grid", { gridCellSize: new go.Size(10, 10) }, $gojs(go.Shape, { stroke: "gray" }));

			var map = new Map();
			map.set(1, dottedGrid);
			map.set(2, boxGrid);
			map.set(3, plainGrid);
			board.startTransaction("change Grid");
			board.grid = map.get(id);
			board.commitTransaction("change Grid");
		},
		onChangeBoardColor: function (id) {
			var backgroundColor = new Map();
			backgroundColor.set(1, "red");
			this.boardStyle.backgroundColor = backgroundColor.get(id)
		},
		//............................
		onConnectionRestored: function () {
			if (this.isBoardLocked()) {
				this.populateBoardModel(false)
			}
			this.boardDetail.isActiveUser = true;
			this.boardDetail.board.locked = false;
			hideTopMessage();
		},
		onConnectionLost: function () {
			showTopMessage("Reconnecting..", "success", -1);

			vueGoInstance.boardDetail.isActiveUser = false;
			vueGoInstance.boardDetail.board.locked = true;
		},

		//...........
		onSaveBoardSettings: function (data) {
			this.boardDetail.board.title = data.title;
			this.boardDetail.board.backgroundColor = data.backgroundColor;
			this.boardDetail.board.backgroundPattern = data.backgroundPattern;
		},
		//...........
		onCloseShareLinkPopup: function () {
			this.sharePublicLinkPopup.show = false;
		},
		onClickOpenExportPopup: function () {
			if (!this.isPublicLinkUrl) {
				this.exportPopup.show = !this.exportPopup.show;
			}
		},
		onClickOpenTemplatesPopup: function () {
			if (this.miniBoard.show) {
				this.miniBoard.show = false;
			}
			this.selectedAction = 'templates';
			this.templatePopup.show = true;
		},
		onCloseTemplatePopup: function () {
			this.selectedAction = '';
			this.templatePopup.show = false;
		},
		onCloseProfilePopup: function () {
			this.profilePopup.show = false;
		},
		onCloseBulkNotesSection: function () {
			this.openBulkModeForNotes = false;
		},
		onCloseCollaboratorsPopup: function () {
			this.collaboratorsPopup.show = false;
		},
		onCloseExportPopup: function () {
			this.exportPopup.show = false;
		},
		onCloseSettingsPopup: function () {
			this.settingsPopup.show = false;
		},
		onCloseShortcutPopup: function () {
			this.settingsPopup.shortcutPopup = false;
		},
		onClickOpenNotesSection: function () {
			this.notesPopup.show = !this.notesPopup.show;
			this.addNoteActiveUser();
		},
		onCloseNotesSection: function () {
			this.notesPopup.show = false;
			sendSocketRequest({ "synId": synId, "category": "note", "eventType": "removeNoteActiveUser", "user": this.user, "boardId": this.boardId });
		},

		//........... search related
		onClickSearchBar: function () {
			this.onInputSearchText();
		},
		onChangeSearchText: function () {

		},
		onInputSearchText: function () {

			var _this = this;

			if (!_.isEmpty(_this.search.query)) {
				_this.search.focusedItem = -1;
				var items = [];
				var query = _this.search.query.toLowerCase();
				_.each(board.model.nodeDataArray, nodeData => {
					if (!_.isEmpty(nodeData.text) && nodeData.text.toLowerCase().includes(query)) {
						var item = { title: nodeData.text, data: nodeData, key: nodeData.key };
						items.push(item);
					}
				});
				this.search.items = items;
			}
			else {
				this.search.focusedItem = -1;
				this.search.items = [];
			}
		},
		onSelectSearchItem: function (item, index) {
			// this.search.focusedItem = -1;
			// this.search.items = [];
			zoomToFitNodeWithKey(item.key, true, 1.5);
		},
		//........... board popup
		onClickSaveButton: function () {
			this.loaderShow = true;
			var nodesList = [];
			var existingNodesList = [];

			var currentNodesMappedbyId = {};
			_.each(board.model.nodeDataArray, node => {
				if (node._id) {
					currentNodesMappedbyId[node._id] = node;
				}

				if (!node.boardId) {
					nodesList.push(node);
				} else if (node.boardId && node._id) {
					existingNodesList.push(node);
				}
			});

			var linksList = [];
			var existingLinksList = [];
			var currentLinksMappedbyId = {};
			_.each(board.model.linkDataArray, link => {

				if (link._id) {
					currentLinksMappedbyId[link._id] = link;
				}
				if (!link.boardId) {
					linksList.push(link);
				} else if (link.boardId && link._id) {
					existingLinksList.push(link);
				}

			});

			nodesList.forEach(node => {
				delete node.__gohashid
				delete node._id
				delete node.boardId
			})
			linksList.forEach(link => {
				delete link.__gohashid
				delete link._id
				delete link.boardId
			})

			let requestBody = { "boardId": this.boardId, "nodes": nodesList, "links": linksList, "type": 'template', "currentNodes": currentNodesMappedbyId, "currentLinks": currentLinksMappedbyId }

			//creating new nodes and links
			axios.post('/graphx/template/update', requestBody)
				.then(response => {

					if (response.data.success) {
						this.updateExistingNodesOnTemplateSave(existingNodesList);
						this.updateExistingLinksOnTemplateSave(existingLinksList);
					}

				})
				.catch(error => {
				});
		},
		
		//...........		
		onToggleCollaboratorsPopup: function () {
			this.collaboratorsPopup.show = !this.collaboratorsPopup.show;
			//	var countCollaborators = 0;
			var collaborators = this.boardDetail.board.collaborators;
			if (collaborators) {
				_.each(collaborators, collaborator => {
					if (collaborator.user.id != this.user.id) {
						if (this.collaboratorsPopup.list.length > 0) {
							var exist = _.findIndex(this.collaboratorsPopup.list, { id: collaborator.user.id });
							if (exist == -1) {
								this.collaboratorsPopup.list.push({ id: collaborator.user.id, name: collaborator.user.fullName });
							}

						} else {
							this.collaboratorsPopup.list.push({ id: collaborator.user.id, name: collaborator.user.fullName });
						}
					}
				});
			}
		},
		onToggleShowBoardActiveUsers: function () {
			this.collaboratorsPopup.show = !this.collaboratorsPopup.show;
			var count = this.boardActiveUsers.length - 1;
			for (var j = 1; j <= count; j++) {
				var exist = _.findIndex(this.collaboratorsPopup.list, { id: this.boardActiveUsers[j].id });
				if (exist == -1) {
					this.collaboratorsPopup.list.push({ id: this.boardActiveUsers[j].id, firstName: this.boardActiveUsers[j].firstName, lastName: this.boardActiveUsers[j].lastName });
				}
				//this.collaboratorsPopup.list.push({id: this.boardActiveUsers[j].id, firstName: this.boardActiveUsers[j].firstName, lastName: this.boardActiveUsers[j].lastName});
			}
		},
		onToggleProfilePopup: function () {
			this.profilePopup.show = !this.profilePopup.show;
		},
		onToggleCollaboratorCursor: function () {
			this.boardDetail.isCollaboratorsCursor = !this.boardDetail.isCollaboratorsCursor;
			this.boardActiveUsers.forEach(user => {
				var cursorData = board.model.findNodeDataForKey(user.id)
				var cursorNode = board.findNodeForKey(user.id)
				if (cursorData) {
					board.model.setDataProperty(cursorData, "visible", this.boardDetail.isCollaboratorsCursor);
					liveStreamMap.set("cursor" + cursorData.key, cursorNode);
				}
			})

		},
		onToggleFramesList: function () {
			this.framesList.show = !this.framesList.show;
			if (this.framesList.show) {
				localStorage.setItem(this.boardDetail.board.id + "-hideFramesList", true);
			} else {
				localStorage.setItem(this.boardDetail.board.id + "-hideFramesList", false);
			}
		},
		onCloseFramesList: function () {
			this.framesList.show = false;
			localStorage.setItem(this.boardDetail.board.id + "-hideFramesList", false);
		},
		//............    creation tool bar
		
		onClickActionType: function (option) {

			_.each(this.tools.options, opt => {
				opt.expanded = false;
			});
			option.expanded = true;
			this.actionType = option.id;

			//saving action type in local preferences
			if (this.actionType) {
				localStorage.setItem(this.boardDetail.board.id + "-actionType", this.actionType);
			} else {
				localStorage.setItem(this.boardDetail.board.id + "-actionType", "pointer");
			}

			this.subActionType = "";

			this.tools.linkActive = false;

			//........   reset tools
			var freehandDrawing = board.toolManager.findTool("FreehandDrawing");
			if (freehandDrawing) freehandDrawing.isEnabled = false;

			var eraserTool = board.toolManager.findTool("EraserTool");
			if (eraserTool) eraserTool.isEnabled = false;

			if (board.toolManager.panningTool) board.toolManager.panningTool.isEnabled = false;
			this.enableCreationTools(false);

			this.tools.linkActive = false;
			var dragCreating = board.toolManager.findTool("DragCreating");
			if (dragCreating) {
				dragCreating.widthToHeightRatio = 0;
			}

			if (board.toolManager.linkingTool) board.toolManager.linkingTool.isEnabled = false;

			this.enableDefaultTools(false);

			//.................
			_.each(this.paintBrush.penColors, op => { op.expand = false; });
			_.each(this.paintBrush.highlighterColors, op => { op.expand = false; });
			//..................

			if (this.actionType == "pointer") {
				board.commit(function () { board.defaultCursor = "default"})
				// board.defaultCursor = "url(" + option.icon + "), default";
				this.enableDefaultTools(true);
			}
			if (this.actionType == "panning") {
				board.commit(function () { board.defaultCursor = "url(" + option.icon + "), default"; }, null)
				// board.defaultCursor = "url(" + option.icon + "), default";
				this.enableDefaultTools(false);
				if (board.toolManager.panningTool) board.toolManager.panningTool.isEnabled = true;
				board.clearSelection();
			}
			else if (this.actionType == "shape") {

				board.commit(function () { board.defaultCursor = "crosshair"; }, null)
				// board.defaultCursor = "crosshair";
				this.enableCreationTools(true);

				if (dragCreating !== null) {
					dragCreating.createLink = false;
					dragCreating.archetypeNodeData = vueGoInstance.shapeTemplate;
					board.toolManager.clickCreatingTool.archetypeNodeData = vueGoInstance.shapeTemplate;
				}

			}
			else if (this.actionType == "note") {

				board.commit(function () { board.defaultCursor = "url(" + option.icon + "), default"; }, null)
				// board.defaultCursor = "url(" + option.icon + "), default";
				this.enableCreationTools(true);

				if (dragCreating !== null) {
					dragCreating.widthToHeightRatio = 1;
					dragCreating.createLink = false;
					dragCreating.archetypeNodeData = vueGoInstance.noteTemplate;
					board.toolManager.clickCreatingTool.archetypeNodeData = vueGoInstance.noteTemplate;
				}
			}
			else if (this.actionType == "frame") {

				board.commit(function () { board.defaultCursor = getCursorOfType("crosshair"); }, null);
				// board.defaultCursor = getCursorOfType("crosshair");
				this.enableCreationTools(true);
				if (dragCreating !== null) {
					dragCreating.createLink = false;
					dragCreating.archetypeNodeData = vueGoInstance.frameTemplate;
					board.toolManager.clickCreatingTool.archetypeNodeData = vueGoInstance.frameTemplate;
				}
				this.setFrameType(this.selectedFrame);
			}
			else if (this.actionType == "text") {

				board.commit(function () { board.defaultCursor = getCursorOfType("text"); }, null);
				// board.defaultCursor = getCursorOfType("text");
				this.enableCreationTools(true);

				if (dragCreating !== null) {
					dragCreating.createLink = false;
					dragCreating.archetypeNodeData = vueGoInstance.textTemplate;
					board.toolManager.clickCreatingTool.archetypeNodeData = vueGoInstance.textTemplate;
				}
			}
			else if (this.actionType == "pen") {

				
				// board.defaultCursor = "url(" + option.icon + "), default";
				var drawingTool = board.toolManager.findTool("FreehandDrawing");
				var eraserTool = board.toolManager.findTool("EraserTool");

				if (this.paintBrush.selectedType === "BrushPen") {

					board.commit(function () { board.defaultCursor = "url(" + option.icon + "), default"; }, null);

					drawingTool.isEnabled = true;
					eraserTool.isEnabled = false;
					drawingTool.archetypePartData.thickness = this.paintBrush.penColors[this.paintBrush.selectedPen].thickness;
					drawingTool.archetypePartData.border = this.paintBrush.penColors[this.paintBrush.selectedPen].color;
				}
				else if (this.paintBrush.selectedType === "BrushHighlighter") {

					board.commit(function () { board.defaultCursor = "url(" + option.icon + "), default"; }, null);

					drawingTool.isEnabled = true;
					eraserTool.isEnabled = false;
					drawingTool.archetypePartData.thickness = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].thickness;
					drawingTool.archetypePartData.border = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].color + "50";
				}
				else if (this.paintBrush.selectedType === "BrushEraser") {

					board.commit(function () { 
						board.defaultCursor = "url(/assets/icons/collab/p-eraser.svg), default" ;
					}, null);

					drawingTool.isEnabled = false;
					eraserTool.isEnabled = true;
				}
			}
			else if (this.actionType == "link") {

				board.commit(function () { board.defaultCursor = getCursorOfType("crosshair") }, null)
				// board.defaultCursor = getCursorOfType("crosshair");

				board.clearSelection(false);

				this.tools.linkActive = true;
				if (this.selectedLink == "Arrow") {
					this.linkTemplate.toArrow = "Standard";
				}
				else if (this.selectedLink == "Line") {
					this.linkTemplate.toArrow = "none";
				}
				else if (this.selectedLink == "Bubble") {
					this.linkTemplate.toArrow = "Standard";
				}
				else if (this.selectedLink == "ArrowSquare") {
					this.linkTemplate.toArrow = "Standard";
				}
				if (dragCreating !== null) {
					dragCreating.isEnabled = true;
					dragCreating.createLink = true;
					dragCreating.archetypeLinkData = this.linkTemplate;
					board.toolManager.clickCreatingTool.archetypeNodeData = this.linkTemplate;
				}

				var linkingTool = board.toolManager.findTool("Linking");
				linkingTool.archetypeLinkData = this.linkTemplate;
				linkingTool.temporaryLink = getLinkTemplateArrow();
				board.toolManager.linkingTool.temporaryLink.data = $.extend({}, linkingTool.archetypeLinkData, board.model.modelData);

				if (board.toolManager.linkingTool) board.toolManager.linkingTool.isEnabled = true;
			}
			else if(this.actionType == "image"){
				let option = {
					id: "pointer",
					value: "pointer",
				}
				this.onClickActionType(option);
				$("#upload-file").click();
			}
		},
		onClickAddNotesInBulk: function () {
			this.openBulkModeForNotes = !this.openBulkModeForNotes;
		},
		onChooseImageFile: function (input) {
			if (input.target.files && input.target.files[0] && input.target.files[0].type.startsWith("image/")) {
				const file = input.target.files[0];

				addImageNode(file, go.Point.stringify(board.viewportBounds.center));
			}
		},
		onClickShape: function (shape, event) {

			event.stopPropagation();

			_.each(this.tools.options, opt => {
				opt.expanded = false;
			});
			if (this.actionType == "link") {

				this.selectedLink = shape;

				//saving link in local preferences
				if (this.selectedLink) {
					localStorage.setItem(this.boardDetail.board.id + "-selectedLink", this.selectedLink);
				} else {
					localStorage.setItem(this.boardDetail.board.id + "-selectedLink", "");
				}

				var link_option = _.find(this.tools.options, { id: "link" });
				link_option.icon = this.$options.linksDetailMap[this.selectedLink].icon;

				link_option.value = shape;

				if (shape == "Arrow") {
					this.updateArcheTypeNodeData("Arrow", "toArrow", "Standard");
				}
				else {
					this.updateArcheTypeNodeData("Arrow", "toArrow", "none", shape);
				}

				var dragCreating = board.toolManager.findTool("DragCreating");
				if (dragCreating !== null) {
					dragCreating.isEnabled = true;
					dragCreating.createLink = true;
					dragCreating.archetypeLinkData = this.linkTemplate;
					board.toolManager.clickCreatingTool.archetypeNodeData = this.linkTemplate;
				}

				var linkingTool = board.toolManager.findTool("Linking");
				linkingTool.archetypeLinkData = this.linkTemplate;
				linkingTool.temporaryLink = getLinkTemplateArrow();
				board.toolManager.linkingTool.temporaryLink.data = $.extend({}, linkingTool.archetypeLinkData, board.model.modelData);
			}
			else if (this.actionType == "pen") {

				var option = _.find(this.tools.options, { id: "pen" });
				option.expanded = true;

				if (shape.startsWith("Brush")) {
					this.paintBrush.selectedType = shape;
					localStorage.setItem(this.boardDetail.board.id + "-paintBrush.selectedType", this.paintBrush.selectedType);
				}
				var drawingTool = board.toolManager.findTool("FreehandDrawing");

				board.commit(function () { board.defaultCursor = "url(" + option.icon + "), default" }, null)
				// board.defaultCursor = "url(" + option.icon + "), default";
				var drawingTool = board.toolManager.findTool("FreehandDrawing");
				var eraserTool = board.toolManager.findTool("EraserTool");

				if (this.paintBrush.selectedType === "BrushPen") {
					drawingTool.isEnabled = true;
					eraserTool.isEnabled = false;
					drawingTool.archetypePartData.thickness = this.paintBrush.penColors[this.paintBrush.selectedPen].thickness;
					drawingTool.archetypePartData.border = this.paintBrush.penColors[this.paintBrush.selectedPen].color;
				}
				else if (this.paintBrush.selectedType === "BrushHighlighter") {
					drawingTool.isEnabled = true;
					eraserTool.isEnabled = false;
					drawingTool.archetypePartData.thickness = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].thickness;
					drawingTool.archetypePartData.border = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].color + "50";
				}
				else if (this.paintBrush.selectedType === "BrushEraser") {

					board.commit(function () { 
						// /assets/icons/collab/p-eraser.svg
						board.defaultCursor = "url(/assets/icons/collab/p-eraser.svg), default";
					}, null);
					drawingTool.isEnabled = false;
					eraserTool.isEnabled = true;
				}
			}
			else if (this.actionType == "shape") {
				this.selectedShape = shape;

				//saving shape in local preferences
				if (this.selectedShape) {
					localStorage.setItem(this.boardDetail.board.id + "-selectedShape", this.selectedShape);
				} else {
					localStorage.setItem(this.boardDetail.board.id + "-selectedShape", "");
				}

				this.updateArcheTypeNodeData("SHAPE", "figure", this.selectedShape);

				var option = _.find(this.tools.options, { id: "shape" });
				option.icon = this.$options.shapesDetailMap[this.selectedShape].icon;
			}
			else if (this.actionType == "note") {

				this.selectedNote = shape;
				//saving shape in local preferences
				if (this.selectedNote) {
					localStorage.setItem(this.boardDetail.board.id + "-selectedNote", this.selectedNote);
				} else {
					localStorage.setItem(this.boardDetail.board.id + "-selectedNote", "");
				}
				this.updateArcheTypeNodeData("NOTE", "fill", this.selectedNote);

				board.toolManager.clickCreatingTool.archetypeNodeData = this.noteTemplate;
				board.toolManager.findTool("DragCreating").archetypeNodeData = this.noteTemplate;
			}
			else if (this.actionType == "frame") {

				this.selectedFrame = shape;
				//saving shape in local preferences
				if (this.selectedFrame) {
					localStorage.setItem(this.boardDetail.board.id + "-selectedFrame", this.selectedFrame);
				} else {
					localStorage.setItem(this.boardDetail.board.id + "-selectedFrame", "");
				}
				this.setFrameType(this.selectedFrame);

				board.toolManager.clickCreatingTool.archetypeNodeData = this.frameTemplate;
				board.toolManager.findTool("DragCreating").archetypeNodeData = this.frameTemplate;

				this.createFrame();
			}
		},
		onClickPainBrush: function (value, index, event) {

			event.stopPropagation();

			_.each(this.paintBrush.penColors, op => { op.expand = false; });
			_.each(this.paintBrush.highlighterColors, op => { op.expand = false; });

			var drawingTool = board.toolManager.findTool("FreehandDrawing");
			if (drawingTool) {
				if (this.paintBrush.selectedType === "BrushPen") {

					if (this.paintBrush.selectedPen != index) {
						this.paintBrush.selectedPen = index;

						drawingTool.archetypePartData.thickness = this.paintBrush.penColors[this.paintBrush.selectedPen].thickness;
						drawingTool.archetypePartData.border = this.paintBrush.penColors[this.paintBrush.selectedPen].color;
					}
					else {
						this.paintBrush.penColors[this.paintBrush.selectedPen].expand = true;
					}
				}
				else {

					if (this.paintBrush.selectedHighlighter != index) {
						this.paintBrush.selectedHighlighter = index;

						drawingTool.archetypePartData.thickness = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].thickness;
						drawingTool.archetypePartData.border = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].color + "50";
					}
					else {
						this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].expand = true;
					}
				}
			}
		},
		onChangePainBrushColor: function (option, event) {
			event.stopPropagation();

			var drawingTool = board.toolManager.findTool("FreehandDrawing");
			if (drawingTool) {
				if (this.paintBrush.selectedType === "BrushPen") {
					this.paintBrush.penColors[this.paintBrush.selectedPen].color = option.value;
					drawingTool.archetypePartData.border = this.paintBrush.penColors[this.paintBrush.selectedPen].color;
				}
				else {

					this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].color = option.value;
					drawingTool.archetypePartData.border = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].color + "50";
				}
			}
		},
		onChangePainBrushTickness: function (event) {
			event.stopPropagation();
			var value = parseInt(event.target.value);

			var drawingTool = board.toolManager.findTool("FreehandDrawing");
			if (drawingTool) {
				if (this.paintBrush.selectedType === "BrushPen") {
					this.paintBrush.penColors[this.paintBrush.selectedPen].thickness = value;
					drawingTool.archetypePartData.thickness = this.paintBrush.penColors[this.paintBrush.selectedPen].thickness;
				}
				else {

					this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].thickness = value;
					drawingTool.archetypePartData.thickness = this.paintBrush.highlighterColors[this.paintBrush.selectedHighlighter].thickness;
				}
			}
		},
		onClickOutsideOfTools: function () {
			_.each(this.tools.options, opt => {
				opt.expanded = false;
			});
		},
		///////////////////////////////////////////////////////////
		//////////////     API CALLS
		loadCompanyUsers: function () {

			if (vueGoInstance.isPublicLinkUrl) {
				return;
			}
			var _this = this;

			axios.get('/graphx/users')
				.then(response => {
					if (response.data && response.data.success) {
						_this.companyUsers = response.data.users;
					}
				})
				.catch(error => {
				});
		},
		loadUser: function () {
			// axios.get('/graphx/profile/', 'user')
			// .then(response => {
			if (vueGoInstance.isPublicLinkUrl) {
				this.user = vueGoInstance.anonymousUser;
			} else {
				this.user = loggedInUser;
			}

			if (this.boardDetail.board.type != 'template') {
				//show online users
				var activeUser = {};
				var today = new Date();
				var uniqueId = getNewUUID();
				
				if (vueGoInstance.isPublicLinkUrl) {
					uniqueId = vueGoInstance.anonymousUser.email;
					var user = { "isOnline": true, "id": uniqueId, "firstName": vueGoInstance.anonymousUser.name, "lastName": "", "lastActive": today, "noteActiveUserStatus": false, "noteLastActiveTime": today };
				} else {
					var user = { "isOnline": true, "id": this.user.id, "firstName": this.user.firstName, "lastName": this.user.lastName, "lastActive": today, "noteActiveUserStatus": false, "noteLastActiveTime": today };
				}

				//var user = { "isOnline": false, "id": this.user.id, "firstName": this.user.firstName, "lastName": this.user.lastName, "lastActive": today, "noteActiveUserStatus": false, "noteLastActiveTime": today };
				if (vueGoInstance.isPublicLinkUrl) {
					activeUser[uniqueId] = user;
				} else {
					activeUser[this.user.id] = user;
				}
				//activeUser[this.user.id] = user;

				setInterval(() => {
					setStompClientState();

					if (vueGoInstance.isPublicLinkUrl) {
						sendSocketRequest({ "synId": synId, "category": "user", "eventType": "addActiveUser", "userId":uniqueId, "user": activeUser, "boardId": this.boardId });

					} else {
						sendSocketRequest({ "synId": synId, "category": "user", "eventType": "addActiveUser", "userId": this.user.id, "user": activeUser, "boardId": this.boardId });
					}
					_.each(vueGoInstance.boardActiveUsers, activeUser => {
						if (activeUser) {
							var currentTime = new Date();
							var lastActiveTime = new Date(activeUser.lastActive);

							diff = currentTime.getTime() - lastActiveTime.getTime();
							
							if (diff > 40000) {
								activeUser.isOnline = false;
								var index = _.findIndex(vueGoInstance.boardActiveUsers, { id: activeUser.id });
								//const index = vueGoInstance.boardActiveUsers.indexOf(activeUser);
								if (index >= 0) {
									vueGoInstance.boardActiveUsers.splice(index, 1)
								}
							}
						}
					});
				}, 60000);
			}

			if (this.user && this.user.picturePath) {
				this.profilePicturePath = s3_resource_url + this.user.picturePath;
			} else {
				this.profilePicturePath = undefined;
			}

			// })
			// .catch(error => {
			//
			// });
			//}
		},
		loadCollaborators: function () {
			var countCollaborators = 0;
			var collaborators = this.boardDetail.board.collaborators;
			if (collaborators) {
				_.each(collaborators, collaborator => {
					if (collaborator.user.id != this.user.id) {
						//this.collaboratorsPopup.list.push({name: collaborator.user.fullName});
						countCollaborators = countCollaborators + 1;
					}
				});
			}
			return countCollaborators;
		},
		getBoardActiveUsersCount: function () {
			var count = 0;

			if (this.boardActiveUsers.length > 1) {
				count = this.boardActiveUsers.length;
			}
			return count - 1;
		},
		//used
		loadTemplates: function () {

			if (!vueGoInstance.isPublicLinkUrl) {
				axios.get('/graphx/template/all/' +  this.boardDetail?.board?.collaborationType?.id)
					.then(response => {
						if (!_.isEmpty(response.data)) {
							if (response.data.success) {
								/*if (response.data.templates) {
									_.each(response.data.templates, template => {
										if (template.type == 'template') {
											//personal templates
											if (template.createdBy == loggedInUser.userName) {
												if (this.templatePopup.list && this.templatePopup.list.length > 0) {
													var exist = _.findIndex(this.templatePopup.list, { id: template.id });
													//not exist
													if (exist < 0) {
														this.templatePopup.list.push(template);
													}
												} else {
													this.templatePopup.list.push(template);
												}
											}
										}
									});
								}*/
								this.templatePopup.list = [];
								if (response.data.systemTemplates) {
									this.templatePopup.list = response.data.systemTemplates;
								}
								if (response.data.templates) {
									_.each(response.data.templates, templ=> {
										this.templatePopup.list.push(templ);
									});
								}
							}
						}
					})
					.catch(error => {
					});
			}
		},		
		loadBoardModel : function () {
			
			var _this = this;

			if (_this.user.id == undefined) {
				_this.user.id = 'public';
			}

			var apiUrl;
			if (this.isPublicLinkUrl) {
				var token = this.getUrlParameter("token");
				apiUrl = '/graphx/public_share/board/' +this.tenant+"/"+ _this.boardId + '/'+'?token='+token;
			} else {
				apiUrl = '/graphx/board/' + _this.boardId + '/' + _this.user.id;
			}
			axios.get(apiUrl)
			.then(response => {
				if (response.data.board && response.data.board.rowStatus != -1) {
					hideTopMessage();
					var index = -1;
					var boardData = response.data.board;
					_this.boardStarredFlagValue = response.data.starred;
					
					if (!_this.isPublicLinkUrl) {
						index = _.findIndex(response.data.board.collaborators, collab => {
							if (!collab.external) {
								return collab.user.id == loggedInUser.id;
							}

						});
						//..............   check in collections
						var workSpaces = _this.getAllowedWorkSpaces();
						var workSpaceFound = false;
						if(response.data.board.workSpaces) {
							for(var i = 0; i < response.data.board.workSpaces.length; i++){
								if(workSpaces[response.data.board.workSpaces[i].id]){
									var permissionToWrite = _.filter(workSpaces[response.data.board.workSpaces[i].id].permissions, permission => {
										if (permission == "edit-collab-board") { return permission; }
									});
	
									if (!_.isEmpty(permissionToWrite)) {
										_this.userRights.canWrite = true;
									} else {
										_this.userRights.canWrite = false;
									}
									
									var permissionToTemplate = _.filter(workSpaces[response.data.board.workSpaces[i].id].permissions, permission => {
										if (permission == "manage-template-collab-board") { return permission; }
									});
									
									if (!_.isEmpty(permissionToTemplate)) {
										_this.userRights.canManageTemplate = true;
									} else {
										_this.userRights.canManageTemplate = false;
									}
									
									workSpaceFound = true;
									break;
								}
							}
						}
						//...........   check in session boards
						if (!_.isEmpty(response.data.board.session)) {
							let workspaces = [];
							let duplicationCheckMap = {};
							_.each(response.data.board.session,session=> {
								if (session.workSpace) {
									if (!duplicationCheckMap[session.workSpace.id]) {
										duplicationCheckMap[session.workSpace.id] =  true;
										workspaces.push(session.workSpace);
									}
								}
							});
							for(var i = 0; i < workspaces.length; i++){
								if(workSpaces[workspaces[i].id]){
									var permissionToWrite = _.filter(workSpaces[workspaces[i].id].permissions, permission => {
										if (permission == "edit-collab-board") { return permission; }
									});
	
									if (!_.isEmpty(permissionToWrite)) {
										_this.userRights.canWrite = true;
									} else {
										_this.userRights.canWrite = false;
									}
									
									var permissionToTemplate = _.filter(workSpaces[workspaces[i].id].permissions, permission => {
										if (permission == "manage-template-collab-board") { return permission; }
									});
									
									if (!_.isEmpty(permissionToTemplate)) {
										_this.userRights.canManageTemplate = true;
									} else {
										_this.userRights.canManageTemplate = false;
									}
									
									workSpaceFound = true;
									break;
								}
							}
						}
						//...................   check in solution areas
						var allowedSolutionAreas = _this.getAllowedSolutionAreas();
						if (!_.isEmpty(response.data.board.solutionBoard)) {
							let solutionAreas = [];
							let duplicationCheckMap = {};
							_.each(response.data.board.solutionBoard,solutionBoard=> {
								if (solutionBoard.solutionArea) {
									if (!duplicationCheckMap[solutionBoard.solutionArea.id]) {
										duplicationCheckMap[solutionBoard.solutionArea.id] =  true;
										solutionAreas.push(solutionBoard.solutionArea);
									}
								}
							});
							if (_.isEmpty(solutionAreas)) {
								_this.userRights.canWrite = true;
								_this.userRights.canManageTemplate = true;
							}
							for(var i = 0; i < solutionAreas.length; i++){
								if(allowedSolutionAreas[solutionAreas[i].id]){
									var permissionToWrite = _.filter(allowedSolutionAreas[solutionAreas[i].id].permissions, permission => {
										if (permission == "edit-collab-board") { return permission; }
									});
	
									if (!_.isEmpty(permissionToWrite)) {
										_this.userRights.canWrite = true;
									} else {
										_this.userRights.canWrite = false;
									}
									
									var permissionToTemplate = _.filter(allowedSolutionAreas[solutionAreas[i].id].permissions, permission => {
										if (permission == "manage-template-collab-board") { return permission; }
									});
									
									if (!_.isEmpty(permissionToTemplate)) {
										_this.userRights.canManageTemplate = true;
									} else {
										_this.userRights.canManageTemplate = false;
									}
									
									workSpaceFound = true;
									break;
								}
							}
						}
						
					}
					
					if(_this.isPublicLinkUrl || !workSpaceFound){
						var token = this.getUrlParameter("token");
						if(!token){
							token = this.getUrlHashParameter("accessToken")
						}
						if (boardData.publicLinks) {
							var publicLink = _.find(boardData.publicLinks,{"token":token});
							if (publicLink) {
								index = 0;
								_this.userRights.canWrite = publicLink.accessLevel == 1;
							}
						}
					}
					
					
					_this.boardDetail.board = boardData;
					if (_this.boardDetail.board.type == "template") {
						//_this.boardDetail.board.locked = true;
					}

					_this.boardVersion = _this.boardDetail.board?.version;
					
					_this.shareUrl = boardData.url;
					
					if (_this.isLoggedIn) {
						_.each(loggedInUser.accessRoles, accessRole => {
							_this.loggedInUserWorkSpacesMap[accessRole.workSpace.id] = true;
						});
						if(response.data.board.workSpaces) {
							_.each(response.data.board.workSpaces, workspace=> {
								if(_this.loggedInUserWorkSpacesMap[workspace.id]) {
									_this.populateBoardModel(true);
									window.location = '/collab#' + '/detail/' + _this.boardId;
								} 
							})
						} else {
							_this.populateBoardModel(true);
						}	
					}
					else {
						_this.populateBoardModel(true);
					}
					
					_this.loadTemplates();
					
				} else if (response.data.board && response.data.board.rowStatus == -1) {
					showTopMessage('You dont have access to this board');
					//window.location = window.location.origin + '/session' + '?id=' + response.data.board.session.activeSessionBoard
					window.location = window.location.origin + '/unAuthorized';
				}
			})
			.catch(error => {

			});
		},
		populateBoardModel: function (initialLoad) {

			var _this = this;

			if (_this.user.id == undefined) {
				_this.user.id = 'public';
			}

			var apiUrl;
			if (this.isPublicLinkUrl) {
				var token = this.getUrlParameter("token");
				apiUrl = '/graphx/public_share/boardData/' + _this.tenant + '/' + _this.boardId+ '/'+'?token='+token;
			} else {
				apiUrl = '/graphx/boardData/' + _this.boardId + '/' + _this.user.id;
			}
			axios.get(apiUrl)
				.then(response => {
					if (response.data.success) {
						

					//	if (index > -1) {
							
							//_this.boardDetail.board = boardData;

						//	_this.boardVersion = _this.boardDetail.board.version;

							if (initialLoad) {
								initializeBoardGrid();
							}

						//	_this.shareUrl = boardData.url
							var nodes = response.data.nodes;
							var links = response.data.links;

						//	_this.boardStarredFlagValue = response.data.starred;

							board.clear();

							if (initialLoad) {
								var boardScale = localStorage.getItem(_this.boardDetail.board.id + "-boardScale");
								if (boardScale) {
									boardScale = parseFloat(boardScale);
									board.scale = boardScale;
								}
								var boardPosition = localStorage.getItem(_this.boardDetail.board.id + "-boardPosition");
								if (boardPosition) {
									boardPosition = go.Point.parse(boardPosition);
									board.initialPosition = boardPosition;
									board.position = boardPosition;
								}
							}

							var graphLinkModel = new go.GraphLinksModel(nodes, links);
							graphLinkModel.linkKeyProperty = "key";
							graphLinkModel.linkFromPortIdProperty = "fromPort";
							graphLinkModel.linkToPortIdProperty = "toPort";
							
							try{
							board.model = graphLinkModel;
							}
							catch(e) {
								console.log(e);
							}

							//..........................

							
							_this.setNodeAndLinks();
							_this.boardVersion = response.data?.version;

							if (initialLoad) {

								_this.actionType = "pointer";

								//.........................................................

								var noteTemplate = localStorage.getItem(_this.boardDetail.board.id + ":defaultTemplateData:" + "NOTE");
								var frameTemplate = localStorage.getItem(_this.boardDetail.board.id + ":defaultTemplateData:" + "FRAME");
								var shapeTemplate = localStorage.getItem(_this.boardDetail.board.id + ":defaultTemplateData:" + "SHAPE");
								var linkTemplate = localStorage.getItem(_this.boardDetail.board.id + ":defaultTemplateData:" + "Arrow");
								var textTemplate = localStorage.getItem(_this.boardDetail.board.id + ":defaultTemplateData:" + "TEXT");
								var pictureTemplate = localStorage.getItem(_this.boardDetail.board.id + ":defaultTemplateData:" + "PICTURE");

								if (noteTemplate) _this.noteTemplate = JSON.parse(noteTemplate);
								if (frameTemplate) _this.frameTemplate = JSON.parse(frameTemplate);
								if (shapeTemplate) _this.shapeTemplate = JSON.parse(shapeTemplate);
								if (linkTemplate) _this.linkTemplate = JSON.parse(linkTemplate);
								if (textTemplate) _this.textTemplate = JSON.parse(textTemplate);
								if (pictureTemplate) _this.textTemplate = JSON.parse(pictureTemplate);

								//.........................................................

								//...............................
								_this.selectedShape = localStorage.getItem(_this.boardDetail.board.id + "-selectedShape");
								if (!_this.selectedShape) {
									_this.selectedShape = "Default";
								}

								vueGoInstance.shapeTemplate.figure = (_this.selectedShape == "Default") ? "Rectangle" : _this.selectedShape;
								if (vueGoInstance.boardDetail) {
									vueGoInstance.boardDetail.metaMap = {};
									vueGoInstance.boardDetail.metaMap.shareBoardRights = response.data.shareBoardMeta;
								}

								var shape_option = _.find(_this.tools.options, { id: "shape" });
								shape_option.icon = _this.$options.shapesDetailMap[_this.selectedShape].icon;

								//..................................
								var selectedFrame = localStorage.getItem(_this.boardDetail.board.id + "-selectedFrame");
								if (!selectedFrame) {
									selectedFrame = "r_0:0";
								}
								_this.selectedFrame = selectedFrame;
								_this.setFrameType(_this.selectedFrame);

								//............................
								_this.paintBrush.selectedType = localStorage.getItem(_this.boardDetail.board.id + "-paintBrush.selectedType");
								if (!_this.paintBrush.selectedType) {
									_this.paintBrush.selectedType = "BrushPen";
								}

								//..............................
								_this.selectedLink = localStorage.getItem(_this.boardDetail.board.id + "-selectedLink");
								if (!_this.selectedLink) {
									_this.selectedLink = "Default";
								}
								var link_option = _.find(_this.tools.options, { id: "link" });
								link_option.icon = _this.$options.linksDetailMap[_this.selectedLink].icon;
								if (_this.selectedLink == "Arrow") {
									_this.linkTemplate.toArrow = "Standard";
								}
								else if (_this.selectedLink == "Line") {
									_this.linkTemplate.toArrow = "none";
								}
								else if (_this.selectedLink == "Bubble") {
									_this.linkTemplate.toArrow = "Standard";
								}
								else if (_this.selectedLink == "ArrowSquare" || _this.selectedLink == "Default") {
									_this.linkTemplate.toArrow = "Standard";
								}
								//..................................

								var hideframeslist = localStorage.getItem(_this.boardDetail.board.id + "-hideFramesList");

								if (hideframeslist === 'true') {
									_this.framesList.show = true;
								}

								var hideMiniBoard = localStorage.getItem(_this.boardDetail.board.id + "-hideMiniboard");
								_this.miniBoard.show = _.isEmpty(hideMiniBoard) ? false : true;
								if (_this.miniBoard.show) {
									_this.selectedAction = 'miniMap';
								}

								board.addDiagramListener("InitialLayoutCompleted", function (e) {
									if (vueGoInstance.goToNode) {
										zoomToFitNodeWithKey(vueGoInstance.goToNode, true, 1)
									}
								});

								var _option = _.find(_this.tools.options, { id: _this.actionType });
								if (_option) {
									_this.onClickActionType(_option);
								}
								if (_this.boardDetail.board.locked) {
									board.isReadOnly = true;
									var option = _.find(vueGoInstance.tools.options, { id: "panning" });
									vueGoInstance.onClickActionType(option);
								}
								if (!_this.userRights.canWrite) {
									board.isReadOnly = true;
								}

							}

					
					} else if (response.data.board == null) {
						//board not found
						showTopMessage('This board does not exist');
						_this.$router.push('/');
					}
				})
				.catch(error => {

				});
		},
		onSaveAsTemplatePopup: function (dataModel) {
			if (_.isEmpty(dataModel.title)) {
				
			} else {
				let nodes = board.model.nodeDataArray;
				let links = board.model.linkDataArray;
				nodes.forEach(node => {
					delete node.__gohashid
					delete node._id
					delete node.boardId
				});
				links.forEach(link => {
					delete link.__gohashid
					delete link._id
					delete link.boardId
				});

				let requestBody = { "title": dataModel.title, "nodes": nodes, "links": links, "userId": loggedInUser.id, "type": 'template' }
				requestBody.description = dataModel.description;
				if(dataModel.collabType?.id !== "selectTeams" && dataModel.collabType?.id !== "selectSessions" && dataModel.collabType?.id !== "selectSolutionBoards") {
					requestBody.collaborationType = dataModel.collabType.id;
				}else if(dataModel.collabType?.id === "selectTeams"){
					requestBody.piTeamArea  = dataModel.piTeamArea;
				}else if(dataModel.collabType?.id === "selectSessions"){
					requestBody.piSessions = dataModel.piSessions;
				}else if(dataModel.collabType?.id === "selectSolutionBoards"){
					requestBody.solutionBoards = dataModel.workspaceSolutionBoards;
				}

				requestBody.image = dataModel.image;
				
				requestBody.createdFromBoard = dataModel.createdFromBoard;
				if (dataModel.existingTemplateId) {
					requestBody.existingTemplateId = dataModel.existingTemplateId;	
				}
				
				axios.post('/graphx/template/save', requestBody)
					.then(response => {
						this.closeTemplatePopup();
						this.showMessageWithHyperlink = true;

						showTopMessage("Template has been created", "success");

						var templates = store.getters.getTemplates();
						templates.push(response.data.template);
						return store.commit('setTemplate', templates);
					})
					.catch(error => {
					});
			}
		},
		onCloseSaveAsTemplatePopup: function () {
			this.saveAsTemplatePopup.show = false;
		},
		//..................
		
		saveOnDragEnd: function () {
			var id = this.$route.params.id;
		},
		onClickDownloadPdf: function () {
			var pdfOptions =  // shared by both ways of generating PDF
			{
				// layout: "landscape",  // instead of "portrait"
				// pageSize: "A4"        // instead of "LETTER"
			};

			generatePdf(function (blob) {
				var datauri = window.URL.createObjectURL(blob);
				var a = document.createElement("a");
				a.style = "display: none";
				a.href = datauri;
				a.download = vueGoInstance.boardDetail.board.title;

				if (window.navigator.msSaveBlob !== undefined) {  // IE 11 & Edge
					window.navigator.msSaveBlob(blob, a.download);
					window.URL.revokeObjectURL(datauri);
					return;
				}

				document.body.appendChild(a);
				requestAnimationFrame(function () {
					a.click();
					window.URL.revokeObjectURL(datauri);
					document.body.removeChild(a);
				});
			}, board, pdfOptions);
		},
		onClickDownloadImage: function () {
			board.makeImageData({ background: "white", returnType: "blob", callback: downloadImageCallback });
		},
		onCreatePreview: function () {
			// previewMode = true;
			// if(board.findNodeForKey("preview")) return;
			// this.boardPreview.isLeftNav = false;
			// this.boardPreview.isControls = true;
			// board.nodes.each(n => {if(n.key === "preview") return; n.selectable=false});
			// board.links.each(n => {n.selectable=false});
			// board.model.addNodeData({"category":"PREVIEW", "key":"preview", "loc":go.Point.stringify(board.viewportBounds.center),
			// "selected":true, "opacity":0.09, "size": "200 200"});
			// var leftNodeWidth =Math.sqrt(Math.pow(board.viewportBounds.center.x - board.viewportBounds.position.x,2)
			// 	+ Math.pow(board.viewportBounds.position.y - board.viewportBounds.position.y, 2));
			// var topNodeHeight = Math.sqrt(Math.pow(board.viewportBounds.position.y - board.viewportBounds.center.y, 2));
			// var bottomNodeHeight = Math.abs(board.viewportBounds.height - (200+topNodeHeight));
			//
			// // Main Preview side Nodes
			// board.model.addNodeData({"category":"PREVIEW", "key":"previewLeft",
			// 	"size":go.Size.stringify(new go.Size(leftNodeWidth, board.viewportBounds.size.height )),
			// 	"loc":go.Point.stringify(board.viewportBounds.position), "selected":false, "opacity": .7, "selectable":false, "visible":true});
			// board.model.addNodeData({"category":"PREVIEW", "key":"previewRight",
			// 	"size": go.Size.stringify(new go.Size(board.viewportBounds.size.width-(leftNodeWidth+200), board.viewportBounds.size.height )),
			// 	"loc":go.Point.stringify(new go.Point(board.viewportBounds.center.x+200, board.viewportBounds.y)),
			// 	"selected":false, "opacity": .7, "selectable":false,"visible":true});
			// board.model.addNodeData({"category":"PREVIEW", "key":"previewTop",
			// 	"size":go.Size.stringify(new go.Size(200, topNodeHeight )),
			// 	"loc":go.Point.stringify(new go.Point(board.viewportBounds.center.x, board.viewportBounds.y)),
			// 	"selected":false, "opacity": .7, "selectable":false, "visible":true});
			// board.model.addNodeData({"category":"PREVIEW", "key":"previewBottom",
			// 	"size":go.Size.stringify(new go.Size(200, bottomNodeHeight )),
			// 	"loc":go.Point.stringify(new go.Point(board.viewportBounds.center.x, board.viewportBounds.y +(200+topNodeHeight))),
			// 	"selected":false, "opacity": .7, "selectable":false, "visible":true});
			// this.exportPopup.show = false;
			this.boardPreview.boardIamge = board.makeImageData(
				{ background: "White", showGrid: true, scale: .5, position: board.documentBounds, maxSize: new go.Size(Infinity, Infinity) }
			);
			this.boardPreview.show = true;
		},
		onSaveBoardPreview: function (imageData) {
			// previewMode = false;
			// var size = board.findNodeForKey("preview").desiredSize;
			// var pos = go.Point.stringify(board.findNodeForKey("preview").position);
			// var bitmap = board.makeImageData({position:go.Point.parse(pos), size: new go.Size(size.width,size.height)})
			// uploadBoardPreview(this.boardId, bitmap)
			// console.log(bitmap)
			// this.onCancelBoardPreview();

			uploadBoardPreview(this.boardId, imageData)
			console.log(imageData)
			this.onClosePreviewPopup()
		},
		onClosePreviewPopup: function () {
			this.boardPreview.show = false;
		},
		onClickEditBoardSettings: function () {
			this.editBoardSettingsPopup.show = true;
		},
		onUploadImageNode: function (file) {
			var input = file.target;
			var reader = new FileReader();
			reader.onload = function () {
				var dataURL = reader.result;
				var key = nodeCustomKey(board.model)
				board.model.commit(function () {
					board.model.addNodeData({
						"category": "PICTURE",
						"loader": true,
						key: key
					})
				}, null)
				uploadImageToMongoGridFS(file).then(res => {
					if (res.success) {
						var path = s3_resource_url + res.path;

						board.model.commit(function () {
							var node = board.findNodeForKey(key);
							if (node != null) {
								board.remove(node);
							}
						}, null);

						board.startTransaction(MOD_TRNS_NODE_ADD);
						board.model.addNodeData({
							"category": "PICTURE",
							"source": path,
							"loader": true,
							key: nodeCustomKey(board.model)
						});
						board.commitTransaction(MOD_TRNS_NODE_ADD);
						console.log(path)
					}
				})
			}
			reader.readAsDataURL(input.files[0]);

		},
		onclickShareUrl: function () {
			this.shareBoardPopup.show = true;
			if (!this.shareUrl) {
				this.onCreateUrl()
			}
		},
		onClickShare: function () {
			this.shareBoardPopup.show = true;
			if (!this.shareUrl) {
				this.onCreateUrl()
			}
		},
		onClickPublicLink: function () {
			this.sharePublicLinkPopup.show = true;
			/*if (!this.shareUrl) {
				this.onCreateUrl()
			}*/
		},
		onCloseShareBoardPopup: function () {
			this.shareBoardPopup.show = false;
		},
		onShowTemplatePopup: function () {
			board.toolManager.textEditingTool.doCancel();
			
			let boardImage = board.makeImageData(
				{ background: "White", showGrid: true, scale: .5, position: board.documentBounds, maxSize: new go.Size(Infinity, Infinity) }
			);
			this.saveAsTemplatePopup.boardImage = boardImage;
			this.saveAsTemplatePopup.show = true
		},
		closeTemplatePopup: function () {
			this.saveAsTemplatePopup.show = false
		},
		onCloseEditBoardSettingsPopup: function () {
			this.editBoardSettingsPopup.show = false;
		},
		redirectToTemplatesList: function () {
			this.$router.push('/templates');
		},
		updateBoardDetail: function (boardDetail) {
			this.boardDetail.board = boardDetail;
		},
		onCreateUrl: function () {
			var id = this.boardId
			var params = { "readonly": true, edit: false, "boardId": id }
			var requestBody = { params: JSON.stringify(params) };
			axios.post('/graphx/createShareUrl/' + id, requestBody)
				.then(response => {
					this.shareUrl = response.data.url;
				})
				.catch(error => {
				});
		},
		onStopShareUrl: function () {
			var id = this.boardId
			axios.get('/graphx/stopShareUrl/' + id)
				.then(response => {
					if (!_.isEmpty(response.data)) {
						if (response.data.success) {
							this.shareUrl = "";
							this.onCloseShareBoardPopup();
						}
					}
				})
				.catch(error => {
				});
		},
		deleteCollaborator: function (userId) {
			let index = 0;
			axios.delete('/graphx/collaborator/delete/' + this.boardDetail.board.id + '/' + userId)
				.then(response => {
					if (response.data.success) {
						showTopMessage('Collaborator deleted successfully', 'success');
						this.boardDetail.board.collaborators.forEach(collaborator => {
							if (collaborator.user.id === userId) {
								this.boardDetail.board.collaborators.splice(index, 1)
							}
							index++;
						})
						sendSocketRequest({ "synId": synId, "category": "shareBoard", "eventType": "deleteCollaborator", "collaboratorsList": this.boardDetail.board.collaborators });
					}
				})
				.catch(error => {

				});
		},
		graphFrames: function () {
			this.framesList.list = board.model.nodeDataArray.filter(checkFrame);
			function checkFrame(node) {
				return node.category === "FRAME";
			}
		},
		onFrameListSelectFrame: function (key) {
			var node = board.findNodeForKey(key);
			sendSocketRequest({ "key": node.data.key, "synId": synId, "category": "node", "eventType": "focusOnNode" })
			zoomToFitNodeWithKey(key, true, 6);
		},
		onChangeZoomScale: function (value) {

			var scale = board.scale * 100;
			scale = Math.round(scale);
			var remainder = scale % 10;

			var incrment = 0;
			if (remainder == 0) {
				incrment = value * 10;
			}
			else {
				if (value > 0) {
					incrment = 10 - remainder;
				} else {
					incrment = -remainder;
				}
			}
			scale += incrment;

			board.commit(function () {
				board.scale = scale / 100;
			}, null);
		},
		onBoardScaleUpdated: function () {
			var scale = Math.round(board.scale * 100);
			this.zoomPercentage = scale;
		},
		onToggleZoomToFit: function () {
			board.zoomToFit();
			this.selectedAction = 'zoomToFit';
			this.miniBoard.show = false;
		},
		onToggleFullScreen: function () {
			viewFullScreen(!isFullScreen());
			this.selectedAction = 'fullScreen';
			if (this.miniBoard.show) {
				this.miniBoard.show = false;
			}
		},
		onSelectAddEmoji: function (option) {

			var _this = this;

			var _option = _.clone(option);

			if (board.selection) {
				board.selection.each(function (node) {

					var reactions;
					if (node.data.reactions) {
						reactions = _.cloneDeep(node.data.reactions);
					} else {
						reactions = [];
					}

					var reactionIndex = _.findIndex(reactions, { value: _option.value });

					var user = _this.convertLoggedInUser();
					if (reactionIndex > -1) {
						var reaction = reactions[reactionIndex];

						if (user.external) {
							var exist = _.findIndex(reaction.extUsers, { email: user.email });
							if (exist > -1) {
								reaction.extUsers.splice(exist, 1);
								if (_.isEmpty(reaction.extUsers) && _.isEmpty(reaction.users)) {
									reactions.splice(reactionIndex, 1);
								}
							} else {
								reaction.extUsers.push(user);
							}
						}
						else {
							var exist = _.findIndex(reaction.users, { id: user.id });
							if (exist > -1) {
								reaction.users.splice(exist, 1);
								if (_.isEmpty(reaction.users) && _.isEmpty(reaction.extUsers)) {
									reactions.splice(reactionIndex, 1);
								}
							} else {
								reaction.users.push(user);
							}
						}
					}
					else {
						var reaction = _.cloneDeep(_option);
						reaction.extUsers = [];
						reaction.users    = [];
						if (user.external) {
							reaction.extUsers.push(user);
						}else {
							reaction.users.push(user);
						}
						reactions.push(reaction);
					}

					// board.model.startTransaction("AddEmoji");

					var textBlock = node.findObject("textBlock");
					if (textBlock && textBlock.part && textBlock.part.data && textBlock.panel && textBlock.part.data.category === "NOTE") {
						var auto = textBlock.part.data.textSize === "Auto";
						var result = adjustAutoFont(textBlock, auto);
						if (result.changeMode) {
							_this.$refs.optionMenu.setSelectedItems([node]);
						}
					}

					board.model.setDataProperty(node.data, "reactions", reactions);
					board.model.updateTargetBindings(node.data);

					// board.model.commitTransaction("AddEmoji");
				});
			}
		},
		convertLoggedInUser: function () {
			return convertLoggedInUser();
		},
		onNodeCreate: function () {

			var option = _.find(this.tools.options, { id: "pointer" });
			this.onClickActionType(option);

			// this.enableCreationTools(false);	
			// // if (this.actionType !== "pointer") {
			// 	if ((board.toolManager.linkingTool && board.toolManager.linkingTool.isEnabled) || this.actionType === "link") {
			// 		if (board.toolManager.linkingTool) board.toolManager.linkingTool.isEnabled = false;
			// 		var dragCreating = board.toolManager.findTool("DragCreating");
			// 		if (dragCreating !== null) {
			// 			dragCreating.isEnabled = false;
			// 			dragCreating.createLink = false;
			// 		}
			// 	}
			// 	var option = _.find(this.tools.options, {id: "pointer"});
			// 	this.actionType = option.id;
			// 	board.defaultCursor = "url("+option.icon+"), default";
			// 	// if (this.actionType === "link") {
			// 	this.enableDefaultTools(true);
			// 	// }
			// }
		},
		showLinkDropPopup: function (link) {

			this.linkDropPopup.linkData = link.data;

			var lastPoint = board.lastInput.documentPoint;
			this.linkDropPopup.point = lastPoint;

			var diagramBound = board.viewportBounds;

			var x = (lastPoint.x - diagramBound.x) * board.scale;
			var y = (lastPoint.y - diagramBound.y) * board.scale;

			// nodeBound.width *= board.scale;
			// nodeBound.height *= board.scale;

			// var documentWidth = document.documentElement.scrollWidth;
			// var documentHeight = document.documentElement.scrollHeight;

			// var menuWidth = editingMenuElement.scrollWidth;
			// var menuHeight = editingMenuElement.scrollHeight

			// x += (nodeBound.width * 0.5) - (menuWidth * 0.5);

			// x = Math.max(x, 50);
			// x = Math.min(x, documentWidth - menuWidth - 50);

			// var spaceAtTop = y;
			// var spaceAtBottom = documentHeight - (y + nodeBound.width);

			// var margin = 20;
			// if (spaceAtTop < menuHeight + margin) {
			// 	y += (nodeBound.height + margin);
			// }
			// else {
			// 	y -= (menuHeight + margin);
			// }

			this.linkDropPopup.left = x + "px";
			this.linkDropPopup.top = y + "px";
			this.linkDropPopup.show = true;
			this.linkDropPopup.showTime = new Date().getTime();
		},
		onLinkDropCreateNode: function (category, type) {

			this.linkDropPopup.show = false;

			var link = board.findLinkForData(this.linkDropPopup.linkData);
			var documentBounds = link.fromNode.getDocumentBounds();

			var position;
			// if (this.linkDropPopup.point.y <= documentBounds.x + documentBounds.height) {
			// 	position = new go.Point(this.linkDropPopup.point.x, documentBounds.y);
			// }
			// else {
			position = new go.Point(this.linkDropPopup.point.x, this.linkDropPopup.point.y);
			// }
			var copyData;

			if (category === "SAME") {

				copyData = _.cloneDeep(link.fromNode.data);
				copyData.text = "";
				delete copyData.key;
				delete copyData._id;
				delete copyData.__gohashid;
			}
			else if (category === "TEXT") {

				copyData = _.cloneDeep(this.textTemplate);
				copyData.loc = "" + position.x + " " + position.y;
				copyData.width = 200;
			}
			else if (category === "SHAPE") {

				copyData = _.cloneDeep(this.shapeTemplate);
				copyData.size = link.fromNode.data.size;
				copyData.figure = type;
			}
			else if (category === "NOTE") {

				copyData = _.cloneDeep(this.noteTemplate);

				var bound = link.fromNode.actualBounds;
				var size = new go.Size(0, 0);

				if (bound.width > bound.height) {
					size = new go.Size(bound.width, bound.width);
				}
				else {
					size = new go.Size(bound.height, bound.height);
				}
				copyData.size = go.Size.stringify(size);
			}

			copyData.loc = "" + position.x + " " + position.y;

			board.model.commit(model => {
				model.addNodeData(copyData);
			}, MOD_TRNS_NODE_ADD);

			var newNode = board.findPartForData(copyData);
			if (board.allowSelect) {
				board.clearSelection();
				newNode.isSelected = true;
			}

			board.model.commit(model => {
				model.setToKeyForLinkData(link.data, newNode.key);
			}, MOD_TRNS_LINK_UPDATE);

			board.raiseDiagramEvent("ChangingSelection", board.selection);

			var option = _.find(this.tools.options, { id: "pointer" });
			this.onClickActionType(option);
		},
		onLinkDropClose: function () {
			var thisTime = new Date().getTime();
			if (thisTime - this.linkDropPopup.showTime > 200) {
				this.linkDropPopup.linkData = {};
				this.linkDropPopup.show = false;
			}
		},
		onClickBoardHistoryButton: function (event) {
			event.stopPropagation();
			this.boardHistory.show = !this.boardHistory.show;
			this.settingsPopup.show = false;
		},
		getAllowedWorkSpaces: function() {
			var _workSpacesMap = {};
			
			var filteredAccessRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return o.workSpace ? true : false;
			});
			
			var uniqWS = _.uniqBy(filteredAccessRoles, function(o) {
				return o.workSpace.id;
			});

			var workSpaceRoleGroup = _.groupBy(filteredAccessRoles, function(o) {
				return o.workSpace.id;
			});
			$.each(uniqWS, function(index, ws) {
				var space = {}
				space.id = ws.workSpace.id
				space.roles = [];
				space.permissions = [];
				space.restrictions = [];
				
				if (loggedInUser.isAdmin === true) {
					space.permissions = loggedInUser.permissions;
				} else {
					var accessRoles = workSpaceRoleGroup[space.id];
					if (accessRoles && accessRoles.length > 0) {
						$.each(accessRoles, function(i, accessRole) {
							$.each(accessRole.roles, function(j, role) {
								space.roles.push(role);
								space.permissions = _.union(space.permissions, _.difference(loggedInUser.permissions, role.restrictions))
							});
						});
					}
				}
				_workSpacesMap[space.id] = space;
			});
			return _workSpacesMap;
		},
		getAllowedSolutionAreas: function() {
			var _workSpacesMap = {};
			
			var filteredAccessRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return o.solutionArea ? true : false;
			});
			
			var uniqWS = _.uniqBy(filteredAccessRoles, function(o) {
				return o.solutionArea.id;
			});

			var workSpaceRoleGroup = _.groupBy(filteredAccessRoles, function(o) {
				return o.solutionArea.id;
			});
			$.each(uniqWS, function(index, ws) {
				var space = {}
				space.id = ws.solutionArea.id
				space.roles = [];
				space.permissions = [];
				space.restrictions = [];
				
				if (loggedInUser.isAdmin === true) {
					space.permissions = loggedInUser.permissions;
				} else {
					var accessRoles = workSpaceRoleGroup[space.id];
					if (accessRoles && accessRoles.length > 0) {
						$.each(accessRoles, function(i, accessRole) {
							$.each(accessRole.roles, function(j, role) {
								space.roles.push(role);
								space.permissions = _.union(space.permissions, _.difference(loggedInUser.permissions, role.restrictions))
							});
						});
					}
				}
				_workSpacesMap[space.id] = space;
			});
			return _workSpacesMap;
		},
		//.................................................
		onClickEditTemplate: function () {
			
			board.toolManager.textEditingTool.doCancel();
			this.saveAsTemplatePopup.boardImage = undefined;
			this.saveAsTemplatePopup.show = true;
		}
	}
});

const TEMPLATE = Vue.component('template-popup', {
	name: 'template-popup',
	template: `
		<div>
			<div class="overlay" style="display: block;"></div>
			<div id="template-popup" class="add-pop ui-dialog tmppop" style="display: block;">
			<div class="head">
				Template Project
				<a v-if="flag == 'apply-template'" href="javascript:void(0);" @click="onPopupClose" title="Close" class="close"></a>
				<span v-if="!showPreview"><a href="javascript:void(0);" v-if="flag == 'use-template'" class="ti-arrow-left p-abs back ico"  @click="onPopupClose">Back</a> </span>
			</div>
			<div class="rec">
			<div class="itmsrc">
				<em class="ti-filter filtr"></em> <em class="ti-search srico"></em> 
				<input type="text" autocomplete="off" name="title" placeholder="Search..." v-model="searchQuery" @input="onApplyFilter" class="search_input flt activeText"/>
			</div>
			</div>
				
			<div class="cntr bgn mrow" v-if="!showPreview">
			
				<div class="nofound" v-if="templatesList.length == 0">No results found</div>
				<div class="FL wrklist" v-bind:value="{ id: template.id, title: template.title }" v-for="template in templatesList">
					<div class="prow grid">
						<!--<a href="javascript:void(0)" title="Settings" class="ti-more-alt icomr"></a>-->
						<div class="midico board DAJ">
							<img id='board-image' v-if="template.title == 'Planning Retro Template' " src="../assets/imgs/CollaborationBoard-Template.png" alt='Preview' />
							<img v-else :src="thumbnailPath(template)" alt='Preview' />
						</div> 
						<div class="btmbr">
							<div class="rc c1 ttl"><a href="javascript:void(0)" class="elp">{{template.title}}</a></div> 
							<!--<div class="light elp">
								<span class="dsn">Created by</span> 
								<span class="cbnme rc c2">{{getFullname(template)}}</span> 
								<span class="dsn">,</span> 
								<span class="dt rc c2">{{formatDate(template.createdOn)}}</span>
							</div>-->
							
							<!--<div class="star rc c3"><a href="javascript:void(0)" class="emp"><img src="/assets/icons/collab/star-emp-14.svg" alt="star"></a></div>-->
						</div>
						<div class="btns DF p-abs">
                            <div class="over"></div>
                            <div class="cont">
                                <div class="txt">Manage your workflow in a highly flexible and visual way.</div>
								<!--<a href="javascript:void(0)" @click="onClickDeleteBoard(template)" class="ti-trash dlt p-abs" title="Delete"></a>-->
                                <div class="btu">
                                    <a href="javascript:void(0)" class="button share FL" @click="onClickUseButton(template)">Use</a>                                        
                                   <a href="javascript:void(0)" class="button-w FR" @click="onClickPreviewButton(template)">Preview</a>

                                </div>
                            </div>
                        </div>
					
					</div>
				</div>
				</div>
					<div class="cntr prv mrow" v-if="showPreview">
					<div class="shprvw wrklist DF">
						<a class="back goico p-abs" href="javascript:void(0)" id="wiz-prev-step" @click="onClickGoBack()"><em class="ti-arrow-left ico"></em> Back to Templates</a>
						
						<div class="lftar FL w-half">
                            <div class="ttl">{{template.title}}</div>
                            <div class="btns">
                                <a href="javascript:void(0)" class="button share" @click="onClickUseButton(template)">Use Template</a>
                            </div>
                        </div>
                        
                        <div class="rhtar FL w-half wbox DAJ">                            
                            <div class="prvw DAJ" :style="{background:widgetTextStyle(template)}">
                                <img v-if="template.title == 'Planning Retro Template'" id='board-image' src="../assets/imgs/CollaborationBoard-Template.png" alt='Preview' />
                                <img v-else :src="thumbnailPath(template)" alt='Preview' />
                            </div>
                            <!--<div class="nofound" v-else>No preview available</div>-->
                        </div>
	
						<!--<div class="prow grid">
							<a href="javascript:void(0)" title="Settings" class="ti-more-alt icomr"></a>
							<div class="btmbr">
								<div class="rc c1 ttl"><a href="javascript:void(0)" class="elp">{{template.title}}</a></div> 
								<div class="star rc c3"><a href="javascript:void(0)" class="emp"><img src="/assets/icons/collab/star-emp-14.svg" alt="star"></a></div>
							</div>											
							<div class="btns DF p-abs"><a href="javascript:void(0)" @click="onClickUseButton(template)">Use Template</a></div>
						</div>-->				
						<!--<span v-if="showPreview">
							<a href="javascript:void(0)" id="wiz-prev-step" class="back goico p-abs" style="top: -6px;" @click="onClickGoBack()" title="Go Back"><i class="ti-arrow-left ico">Back to Templates</i></a>
							<div class="prow grid">
								<a href="javascript:void(0)" title="Settings" class="ti-more-alt icomr"></a>
								<div class="midico board" style="top: 44%;"></div>						
								<div class="btmbr">
									<div class="rc c1 ttl"><a href="javascript:void(0)" class="elp">{{template.title}}</a></div> 
									<div class="star rc c3"><a href="javascript:void(0)" class="emp"><img src="/assets/icons/collab/star-emp-14.svg" alt="star"></a></div>
								</div>													
								<div class="btns DF p-abs"><a href="javascript:void(0)" @click="onClickUseButton(template)">Use Template</a></div>
							</div>
						</span>-->
					</div>				
				</div>
			</div>
		</div>
	`,
	props: ["list", "folderId", "type", "title", "flag"],
	data() {
		return {
			selectedTemplate: '',
			template: '',
			showPreview: false,
			searchQuery: '',
			templatesList: [],
			boardThumbnailPath: '',
		}
	},
	created() {
		this.templatesList = this.list;
		this.filteredTemplatelist = this.list;
	},
	computed: {
		thumbnailPath: function() {
			return function(template) {
				if (template.thumbnailPath) {
					// Use MongoDB GridFS endpoint instead of S3
					return "/upload/retrieve-image/" + template.thumbnailPath;
				}
				return "";
			};
		},
	},
	methods: {
		/*onClickDeleteBoard: function (template) {
            axios.delete('/graphx/delete/session-collab-board/' + template.id)
            .then(response => {
                if (response.data.itemRemoved > 0) {
                    showTopMessage('Board deleted', 'warning');
                    var index = _.findIndex(this.templatesList, { id: template.id });
                    if (index > -1) {
                        this.templatesList.splice(index, 1);
                    }
                }
            })
            .catch(error => {
            });
        },*/
		getFullname: function (template) {
			var collaborators = template.collaborators;
			var fullname;
			if (collaborators) {
				_.each(collaborators, collaborator => {
					if (collaborator.user.id == loggedInUser.id) {
						fullname = loggedInUser.fullName;
					}
				});
			}
			return fullname;
		},
		widgetTextStyle: function (template) {
			if (template.folderId) {
				if (template.thumbnailPath) {
					// Use MongoDB GridFS endpoint instead of S3
					this.boardThumbnailPath = "/upload/retrieve-image/" + template.thumbnailPath;
				} else {
					//this.boardThumbnailPath = "assets/icons/collab/nw-board.svg";
					this.boardThumbnailPath = 'board'
				}
			}
			return this.boardThumbnailPath;
		},
		formatDate: function (_date) {
			if (!_date) {
				return "";
			}
			var date = new Date(_date);
			return date.format("d mmm yyyy");
		},
		onClickUseButton: function (template) {
			//this.$emit('use-template', );
			//if creating board using template

			if (this.flag == 'apply-template') {
				this.applyTemplate(template);
			}
			if (this.flag == 'use-template') {
				var templateTitle;
				if (this.title) {
					templateTitle = this.title;
				} else {
					templateTitle = template.title;
				}
				this.selectedTemplate = { id: template.id, title: templateTitle };
				if (this.selectedTemplate) {
					var template = this.selectedTemplate;
					this.$emit('use-template', this.selectedTemplate, this.type, this.folderId, this.selectedTemplate);
				}
			}
		},
		applyTemplate: function (template) {

			var data = {};
			data.templateTitle = template.title;
			if (template.id) {
				data.templateId = template.id;
			}

			data.boardId = this.$route.params["id"];

			var _validNodeTypesMap = {
				"TEXT": true,
				"NOTE": true,
				"SHAPE": true,
				"FreehandDrawing": true,
				"FRAME": true
			}

			var maxKey = -1000000;
			_.each(board.model.nodeDataArray, node=> {
				if (_validNodeTypesMap[node.category]) {
					if (node.key > maxKey) {
						maxKey = node.key;
					}
				}
			});
			if (board.model.nodeDataArray.length == 0) {
				maxKey = 0;
			}
			var firstKey = maxKey + 1;

			axios.post('/graphx/apply_template', data)
				.then(response => {
					if (response) {
						showTopMessage('Template applied successfully', 'success');
						board.startTransaction(MOD_TRNS_BOARD_APP_TEMP);
						if(response.data.nodes) {
							var nodes = [];
							if (data.templateId) {
								nodes = response.data.nodes;
							}else {
								nodes = JSON.parse(response.data.nodes);
							} 

							var keysMap = {};
							_.each(nodes,node=> {
								var oldKey = node.key;
								var newKey = firstKey;
								firstKey ++;

								node.key = newKey;
								keysMap[oldKey] = newKey;
							});
							_.each(nodes,node=> {
								if (node.hasOwnProperty("group")) {
									var oldGroup = node.group;
									var newGroup = keysMap[oldGroup];

									node.group = newGroup;
								}
							});

							board.model.addNodeDataCollection(nodes);
						}
						
						if(response.data.links) {
							board.model.addLinkDataCollection(response.data.links);
						}
						
						board.commitTransaction(MOD_TRNS_BOARD_APP_TEMP);
						this.onPopupClose();
						board.zoomToFit();
					}
				})
				.catch(error => {

				});
		},
		onClickPreviewButton: function (template) {
			this.showPreview = true;
			this.template = template;
		},
		onClickGoBack: function () {
			this.showPreview = false;
		},
		onPopupClose: function () {
			this.$emit('close-template-popup');
		},
		onApplyFilter: function () {
			this.templatesList = _.filter(this.filteredTemplatelist, template => {
				var filtered = true;
				if (!_.isEmpty(this.searchQuery)) {
					if (template.title) {	// search on item's title
						filtered = (template.title.toLowerCase().includes(this.searchQuery.toLowerCase()));
					}
				}
				return filtered;
			});
		},
	}
})

const CREATEBOARD = Vue.component('create-board', {
	name: 'create-board',
	template: `
	<div>
		<div class="overlay" style="display: block;"></div>
		<div id="create-board" class="add-pop ui-dialog crtbrd" style="display: block;">
						
			<div class="head" v-show="showCreateBoardSection">
				{{getPopUpHeading()}}
				<a href="javascript:void(0);" @click="onPopupClose" title="Close" class="close"></a>
			</div>
			
			<div class="cntr mrow">				
				<div v-if="duplicateBoardEvent == 'duplicateBoard' && type=='board'" class="rec lblm half role"  v-show="showCreateBoardSection">
				<label>Select Folder</label>
				<div class="selectcont" required :class="[showSelectRed ? 'required' : '']">
				   <select v-model='selectedFolder'>
	        		   <option value="" disabled hidden>Choose Folder</option>
				       <option v-for="folder in foldersList" v-bind:value="{ id: folder.id, title: folder.title }">
				         {{folder.breadcrumbsHistory}}
				       </option>
				   </select>
					<span v-if="showSelectRed" class="mstxt red-msg">Folder is required</span>
				</div></div>
			
				<div class="rec lblm" v-show="showCreateBoardSection" v-on:keyup.enter="onPopupSave">
					<input id="title" type="text" required  v-model="dataModel.title" placeholder="Title" :class="[showFieldRed ? 'required inpnw ' : 'inpnw ']"  @blur="checkValidation" v-focus/>
					<span v-if="showFieldRed" id="title" class="mstxt red-msg">Title field is empty</span>	
				</div>
				
				<div class="rec lblm half" v-if="type == 'folder'">
					<label>Folder Access Type</label>
					<div class="selectcont">
					  <select v-model='selectedAccessType' @change="onChangeAccessType(selectedAccessType.key)">
				       <option v-for="accessType in folderAccessType" v-bind:value="{key:accessType.key, value:accessType.value}">
				         {{ accessType.value }}
				       </option>
				   	  </select>
					</div>
				</div>
				
				<div v-if="workSpaces.length > 0" class="rec lblm half">
					<label>Workspace</label>
					<div class="selectcont">
					  <select v-model='selectedWorkSpace'>
				       <option v-for="workSpace in workSpaces" v-bind:value="{id: workSpace.id}">
				         {{ workSpace.title }}
				       </option>
				   	  </select>
					</div>
				</div>
				
				<div>
				<div v-if="type== 'board' && eventType == 'edit-board' && currentFolder" class="rec lblm">
					<label>Folder</label>
					<div class="selectcont">
					  <select v-model='selectedFolder'>
	        		   <option value="" disabled hidden>{{currentFolder.title}}</option>
				       <option v-for="folder in foldersListForMovingBoard" v-bind:value="{ id: folder.id, title: folder.title }">
				         {{ folder.breadcrumbsHistory }}
				       </option>
				   	</select>
					</div>
				</div>
				</div>
				
				<!--<div v-if="type== 'board' && duplicateBoardEvent != 'duplicateBoard'" class="rec lblm half">
					<label>Choose from template</label>
					<div class="selectcont">
					   <select v-model='selectedTemplate'>
		        		   <option value="" disabled hidden>Choose template</option>
					       <option v-for="template in templatesList" v-bind:value="{ id: template.id, title: template.title }">
					         {{ template.title }}
					       </option>
					   </select>
					</div>
				</div>-->
			
				<div v-if="type == 'board' && duplicateBoardEvent != 'duplicateBoard'">
					<template-popup v-if="templatePopup.show" :flag="'use-template'" :title = "dataModel.title" :list="templatesList" :folder-id="folderId" :type="folderType" @close-template-popup="onCloseTemplatePopup" @use-template="useTemplate"></template-popup>
				</div>
							
				<div class="rec btn">
					<button @click="onPopupSave" class="FR">Save</button>
					<a href="javascript:void(0)" @click="onPopupClose" class="FR cncl url">Cancel</a>
					<a class="FL temp mt-10" href="javascript:void(0)" v-show="showCreateBoardSection" v-if="type == 'board'  && duplicateBoardEvent != 'duplicateBoard' && eventType !='edit-board'" v-on:click="templatePopup.show=true;">Choose from Templates</a>
				</div>
			</div>
		</div>
	</div>
		`,
	props: ["model", "type", "id", "eventType"],
	data() {
		return {
			dataModel: {
				title: ""
			},
			templatePopup: {
				show: false
			},
			currentFolder: {},
			folderType: '',
			folderId: '',
			duplicateBoardEvent: '',
			foldersList: [],
			foldersListForMovingBoard: [],
			templatesList: [],
			selectedFolder: '',
			selectedTemplate: '',
			showCreateBoardSection: false,
			showFieldRed: false,
			showSelectRed: false,
			loaderShow: false,
			folderAccessType: [],
			selectedAccessType: {},
			workSpaces: [],
			selectedWorkSpace: {},
		}
	},
	mounted() { },
	created() {
		if (this.model && this.model._id) {
			this.dataModel = _.cloneDeep(this.model);
		}

		if (this.type) {
			//this.dataModel = _.cloneDeep(this.model);
			this.folderType = _.cloneDeep(this.type);
		}

		if (this.id) {
			this.folderId = _.cloneDeep(this.id);
		}

		if (this.eventType) {
			this.duplicateBoardEvent = _.cloneDeep(this.eventType);
		}

		this.foldersList = store.getters.getFoldersList();
		this.templatesList = store.getters.getTemplates();

		this.currentFolder = _.find(this.foldersList, { id: this.$route.params["id"] });

		this.foldersListForMovingBoard = _.cloneDeep(store.getters.getFoldersList());
		var index = _.findIndex(this.foldersListForMovingBoard, { id: this.$route.params["id"] });
		if (index > -1) {
			this.foldersListForMovingBoard.splice(index, 1);
		}

		this.showCreateBoardSection = true;
		this.getBreadcrumbsHistoryForMovingBoard();
		this.getBreadcrumbsHistory();

		this.folderAccessType = [{ key: 'PrivateAccess', value: 'Private Access' }, { key: 'Restricted', value: 'Restricted' }];

	},
	methods: {
		getPopUpHeading: function () {
			var heading = '';
			if (this.eventType == 'duplicateBoard' && this.type == 'template') {
				heading = 'Duplicate Template';
			} else if (this.eventType == 'duplicateBoard' && this.type == 'board') {
				heading = 'Duplicate Board';
			}
			else if (this.eventType == 'edit-board' && this.type == 'template') {
				heading = 'Edit Template';
			} else if (this.eventType == 'edit-board' && this.type == 'board') {
				heading = 'Edit Board';
			} else if (this.eventType == 'edit-folder' && this.type == 'folder') {
				heading = 'Edit Folder';
			} else if (this.eventType == undefined && this.type == 'board') {
				heading = 'New Board';
			} else if (this.eventType == undefined && this.type == 'folder') {
				heading = 'New Folder';
			}
			return heading;
		},
		getBreadcrumbsHistory: function () {
			_.each(this.foldersList, fol => {
				if (fol.breadcrumbsHistory == undefined) {
					fol.breadcrumbsHistory = '';
				}
				if (_.isEmpty(fol.breadcrumbsHistory)) {
					fol.breadcrumbsHistory = this.getBreadcrumbsArray1(fol);
					fol.breadcrumbsHistory = fol.breadcrumbsHistory.slice(0, -1);
				}
			});
		},
		getBreadcrumbsHistoryForMovingBoard: function () {
			_.each(this.foldersListForMovingBoard, fol => {
				if (fol.breadcrumbsHistory == undefined) {
					fol.breadcrumbsHistory = '';
				}
				if (_.isEmpty(fol.breadcrumbsHistory)) {
					fol.breadcrumbsHistory = this.getBreadcrumbsArray1(fol);
					fol.breadcrumbsHistory = fol.breadcrumbsHistory.slice(0, -1);
				}
			});
		},
		getBreadcrumbsArray1: function (folder) {
			if (!folder.parentFolder) {
				return folder.title + "/";
			}

			if (folder.parentFolder) {
				var folder1 = _.find(this.foldersList, { id: folder.parentFolder });
				if (folder1) {
					var crumb = this.getBreadcrumbsArray1(folder1);
				}
			}
			return crumb + folder.title + '/';
		},
		checkValidation: function () {
			if (this.dataModel.title == '') {
				this.showFieldRed = true;
			} else {
				this.showFieldRed = false;
			}
		},
		onPopupClose: function () {
			this.$emit('close-popup');
		},
		onPopupSave: function () {
			if (this.model._id && this.duplicateBoardEvent != 'duplicateBoard') {
				this.$emit('update', this.dataModel, this.folderType, this.selectedFolder);
			}
			else if (this.model._id && this.duplicateBoardEvent == 'duplicateBoard') {
				var folder = this.selectedFolder;

				if (!folder) {
					this.showSelectRed = true;
				} else {
					this.showSelectRed = false;
				}
				this.$emit('duplicate-board', this.dataModel, this.folderType, folder);
			}
			else {

				//if creating board using template
				if (this.selectedTemplate) {
					var template = this.selectedTemplate;
					this.$emit('save', this.dataModel, this.folderType, this.folderId, template);
				} else {
					//simple board creation
					if (this.dataModel.title == '') {
						this.showFieldRed = true;
					} else {
						this.showFieldRed = false;
					}
					this.$emit('save', this.dataModel, this.folderType, this.folderId, this.selectedAccessType, this.selectedWorkSpace);
				}


			}
		},
		useTemplate: function (selectedTemplate, type, folderId, selectedTemplate) {
			this.$emit('save', selectedTemplate.title, type, folderId, selectedTemplate);
		},
		onCloseTemplatePopup: function () {
			this.templatePopup.show = false;
		},
		onChangeAccessType: function (accesskey) {
			if (accesskey == 'Restricted') {
				console.log(accesskey);
				this.drawWorkSpaces();
			}
		},
		drawWorkSpaces: function () {

			axios.get("/admin/workspaces")
				.then(response => {

					this.workSpaces = response.data.workSpaces;
				})
				.catch(error => {
				});

		},
	}
});

const DUPLICATEBOARD = Vue.component('duplicate-board', {
	name: 'duplicate-board',
	template: `
		<div>
		<div class="overlay" style="display: block;"></div>
		<div id="create-board" class="add-pop ui-dialog crtbrd" style="display: block;">	
			<div class="head">Duplicate Board<a href="javascript:void(0);" @click="onPopupClose" title="Close" class="close"></a></div>
			
			<div class="cntr mrow">				
				<!-- <div v-if="board.type != 'template'" class="rec lblm half role">
				<label>Select Folder</label>
				<div class="selectcont">
				   <select v-model='selectedFolder'>
	        		   <option value="" disabled hidden>Choose Folder</option>
				       <option v-for="folder in foldersList" v-bind:value="{ id: folder.id, title: folder.title }">
				         {{ folder.breadcrumbsHistory }}
				       </option>
				   </select>
				</div>
				</div> -->
			
				<div class="rec lblm" v-on:keyup.enter="onPopupSave">
					<label>Board Title</label>
					<input id="title" type="text" required  v-model="title" placeholder="Title" :class="[showFieldRed ? 'required' : '']"  @blur="checkValidation"></input>
					<span v-if="showFieldRed" id="title" class="mstxt red-msg">Title field is empty</span>
				</div>
				
				<!-- Show PI Board picker only when board is associated with sessions -->
				<div v-if="boardToBeSaved.session && boardToBeSaved.session.length > 0" class="rec lblm" >
					<label>PI Board <span class="infotxt ml-10 tooltip usrtip"><span class="hovtooltipBleft">Search PI Board by name</span></span></label>
					<pi-board-picker v-model="piBoard" />
				</div>
				
				<!-- Show Solution Board picker only when board is associated with solution boards -->
				<div v-if="boardToBeSaved.solutionBoard && boardToBeSaved.solutionBoard.length > 0" class="rec lblm" >
					<label>Solution Board <span class="infotxt ml-10 tooltip usrtip"><span class="hovtooltipBleft">Search Solution Board by name</span></span></label>
					<pi-solution-board-picker v-model="solutionBoard" />
				</div>
				
				<!-- Show Collection picker only when board is associated with workspaces -->
				<div v-if="boardToBeSaved.workSpaces && boardToBeSaved.workSpaces.length > 0" class="rec lblm" >
					<label>Collection <span class="infotxt ml-10 tooltip usrtip"><span class="hovtooltipBleft">Search Collection by name</span></span></label>
					<pi-collections-picker v-model="collection" />
				</div>
				
				<div class="rec btn">
					<button @click="onPopupSave" class="FR">Save</button>
					<a href="javascript:void(0)" @click="onPopupClose" class="FR cncl url">Cancel</a>
				</div>
			</div>
		</div>
		</div>
		`,
	props: ["list", "board"],
	data() {
		return {
			boardToBeSaved: {},
			foldersList: [],
			selectedFolder: '',
			title: '',
			showFieldRed: false,
			
			piBoard: undefined,
			solutionBoard: undefined,
			collection: undefined
		}
	},
	created() {
		this.loadFolders();

		/*if(this.foldersList.size > 0) {
			this.getBreadcrumbsHistory(this.foldersList);
		}*/

		this.boardToBeSaved = _.cloneDeep(this.board);
		this.title = this.boardToBeSaved.title;
		
		// Initialize the appropriate picker based on board associations
		if (this.boardToBeSaved.session && this.boardToBeSaved.session.length > 0) {
			this.piBoard = this.boardToBeSaved.session[0]; // Use first session
		}
		
		if (this.boardToBeSaved.solutionBoard && this.boardToBeSaved.solutionBoard.length > 0) {
			this.solutionBoard = this.boardToBeSaved.solutionBoard[0]; // Use first solution board
		}
		
		if (this.boardToBeSaved.workSpaces && this.boardToBeSaved.workSpaces.length > 0) {
			this.collection = this.boardToBeSaved.workSpaces[0]; // Use first workspace
		}
	},
	methods: {
		//////////// LOGIC ////////////////////////////////////////
		checkValidation: function () {
			if (this.title == '') {
				this.showFieldRed = true;
			} else {
				this.showFieldRed = false;
			}
		},
		getBreadcrumbsHistory: function () {
			_.each(this.foldersList, fol => {
				if (fol.breadcrumbsHistory == undefined) {
					fol.breadcrumbsHistory = '';
				}
				if (_.isEmpty(fol.breadcrumbsHistory)) {
					fol.breadcrumbsHistory = this.getBreadcrumbsArray1(fol);
					fol.breadcrumbsHistory = fol.breadcrumbsHistory.slice(0, -1);
				}
			});

		},
		getBreadcrumbsArray1: function (folder) {
			if (!folder.parentFolder) {
				return folder.title + "/";
			}

			if (folder.parentFolder) {
				var folder1 = _.find(this.foldersList, { id: folder.parentFolder });
				if (folder1) {
					var crumb = this.getBreadcrumbsArray1(folder1);
				}
			}
			return crumb + folder.title + '/';
		},
		///////////////API CALLS /////////////////////////////////
		loadFolders: function () {
			//load folders api
			axios.get('/graphx/folder/list/' + loggedInUser.id)
				.then(response => {
					this.foldersList = response.data.folders;
					this.getBreadcrumbsHistory();
				})
				.catch(error => {

				});
		},
		////////////////////////EVENT HANDLER///////////////////////////////
		onPopupClose: function () {
			this.$emit('close-popup');
		},
		onPopupSave: function () {
			if (this.title === "") {
				console.log("your title is empty")
				this.showFieldRed = true;
			}
			/*else if (!this.selectedFolder && this.boardToBeSaved.type != 'template') {
				showTopMessage('Please select folder', 'warning');
			}*/
			else {
				if (this.boardToBeSaved.type != 'template') {
					var data = { 
						title: this.title, 
						boardIdToBeCopied: this.boardToBeSaved.id, 
						folderId: this.selectedFolder.id 
					};
					
					// Add the appropriate association based on what's available
					if (this.piBoard && this.piBoard.id) {
						data.sessionId = this.piBoard.id;
					} else if (this.solutionBoard && this.solutionBoard.id) {
						data.solutionBoardId = this.solutionBoard.id;
					} else if (this.collection && this.collection.id) {
						data.workSpaceId = this.collection.id;
					}
					
					axios.post("/graphx/board/duplicate", data)
						.then(response => {
							showTopMessage('Board duplicated successfully', 'success');
							var folder = _.find(this.foldersList, { id: this.selectedFolder.id });

							if (folder) {
								if (!folder.canvasBoard) {
									folder.canvasBoard = [];
								}
								folder.canvasBoard.push(response.data.board);
							}
							const hash = window.location.hash;
							const queryString = hash.split('?')[1];
							let context = "";
							let id = "";

							if (queryString) {
								const params = new URLSearchParams(queryString);
								const art = params.get('art');
								const session = params.get('session');
								const solution = params.get('solution');
								id  = "";

								if (art) {
									context = "art";
									id = art;
								} else if (session) {
									context = "session";
									id = session;
								} else if (solution) {
									context = "solution";
									id = solution;
								}
							}
							var boardURL = `/collab#/detail/${response.data.board.id}?${context}=${id}`;
							window.open(boardURL);
							this.onPopupClose();
						})
						.catch(error => {

						});
				}
				if (this.boardToBeSaved.type == 'template') {
					var data = { title: this.title, boardIdToBeCopied: this.boardToBeSaved.id}
					axios.post("/graphx/template/duplicate", data)
						.then(response => {
							showTopMessage('<a>Template copied successfully</a>', 'success');
							console.log(response.data.template);
							this.onPopupClose();
						})
						.catch(error => {
							console.log(error);
						});
				}
			}
		},
	}
});

const SHAREPUBLICLINK = Vue.component('share-public-link', {
	name: 'share-public-link',
	template: `
		<div class="DAJ">
		<div class="overlay" style="display: block;"></div>
		<div id="create-share-url" class="add-pop ui-dialog adusrpop" style="display: block;">
			<div class="head">Share Public Link <a href="javascript:void(0);" @click="onPopupClose" title="Close" class="close"></a></div>
			<div class="rec lblm">
				<label>Add User</label>
				<ul class="addusr addusrinp">
				 <!-- <li v-for="(collaborator, index) in userEmails" class="add">
					<span>{{ collaborator }}<a href="javascript:void(0);" v-on:click = "onClickDeleteInput(index)"   title="Remove" class="close"></a></span>
				  </li>-->
				  <li>
					<input id="title" type="text" required v-model="inputText" placeholder="Enter Email"></input>
				  </li>
				</ul>
			</div>
			<div class="rec lblm half role-a">
				<label>Assign Role</label>
				 <div class="selectcont">
					<select v-model="selectedRight">
						 <option disabled value="">Select... </option>
						 <option v-for="(right, key) in shareRights" :value="key">{{right}}</option>
					 </select>
				 </div>
			<div style="display:flex"><a href="javascript:void(0);" @click="onPopupShare(inputText, selectedRight )" class="share button FR">Share</a></div>
			</div>
			
			<div>Public Links</div>
			<div v-for="(link, index) in publicLinks">{{link}}</div>
			
		</div>
		</div>
	`,
	props: ["board"],
	data() {
		return {
			inputText: '',
			selectedRight: '',
			shareRights: { 3: "Write", 1: "Read" },
			publicLinks: [],
		}
	},
	created() {
		this.getBoardPublicLinks();
	},
	methods: {
		getBoardPublicLinks: function () {
			axios.post('/graphx/getBoardPublicLinks/' + this.board.id)
				.then(response => {
					this.publicLinks = response.data.boardPublicLinks;
				})
				.catch(error => {
				});
		},
		onPopupShare: function (email, selectedRight) {
			if (!_.isEmpty(email) && selectedRight != "") {
				//var requestBody = { "email": email, "right": selectedRight, "boardId": this.board.id }
				var id = this.board.id;
				var params = { "readonly": true, edit: false, "boardId": id, "userEmail": email, "right": selectedRight }
				var requestBody = { params: JSON.stringify(params) };
				axios.post('/graphx/createShareUrl/' + id, requestBody, params)

					.then(response => {
						if (response.data.success) {
							this.selectedRight = "";
							this.email = '';
							this.publicLinks.unshift(response.data.url);
						}
					})
					.catch(error => {
					});
			}
		},
		onPopupClose: function () {
			this.$emit('close-share-link-popup');
		},
	}
});

const CREATESHAREURL = Vue.component('create-share-url', {
	name: 'create-share-url',
	template: `
	<div class="DAJ">
		<div class="overlay" style="display: block;"></div>
		<div id="create-share-url" class="add-pop ui-dialog adusrpop" style="display: block;">
			<div class="head">Create Share Url <a href="javascript:void(0);" @click="onPopupClose" title="Close" class="close"></a></div>
				<div class="cntr mrow">
					<div class="rec lblm">
						<label>Add User</label>
						<ul class="addusr addusrinp" :class="[showFieldRed ? 'required' : '']" >
						  <li v-for="(collaborator, index) in userEmails" class="add">
							<span>{{ collaborator }}<a href="javascript:void(0);" v-on:click = "onClickDeleteInput(index)"   title="Remove" class="close"></a></span>
						  </li>
						  <li>
							<input id="title" type="text" required v-model="inputText" placeholder="Enter Email"  @blur="onInputFocusOut"></input>
						  </li>
						<span v-if="showFieldRed" id="title" class="mstxt red-msg">Email field is empty</span>
						</ul>
					</div>
					<div class="rec lblm half role-a">
						<label>Assign Role</label>
						 <div class="selectcont">
							<select v-model="selectedRight">
								 <option disabled value="">Select... </option>
								 <option v-for="(right, key) in shareRights" :value="key">{{right}}</option>
							 </select>
						 </div>
					</div>
					<div class="rec lblm clbrtr-aa">
					<label>Public Link</label>
						<input type="text" v-model="this.$parent.hostUrl + this.$parent.shareUrl" />
						<a href="javascript:void(0);" @click="onClickStopSharing" class="share ">Stop Sharing</a>
						<a href="javascript:void(0);" @click="onClickCopyShareLink" class="share ">Copy Link</a>
						<a href="javascript:void(0);" @click="onClickShareLink" class="share ">Share Link</a>
					</div>
					<div class="rec lblm clbrtr">						
						<label>Collaborators</label>
						<ul class="lstng">
						<div v-for="(collaborator, index) in existingCollaborators">
						  <li>
							  <span class="nm">{{ collaborator.fullName }}</span> 
							  <span v-if="!collaborator.admin"  class="rl">{{collaborator.access}}</span> 
							  <span v-if="collaborator.admin" class="rl">Admin</span>
							  <a v-if="!collaborator.admin" href="javascript:void(0);" @click="deleteCollaborator(index)" title="Remove" class="close"></a>
						  </li>
						</div>
						</ul>
					</div>
					
					<div class="rec lblm clbrtr">						
						<label>External Collaborators</label>
						<ul class="lstng">
						<div v-for="(collaborator, index) in externalCollaborators">
						  <li>
							  <span class="nm">{{ collaborator.email }}</span> 
							  <span v-if="!collaborator.admin"  class="rl">{{collaborator.access}}</span> 
							  <span v-if="collaborator.admin" class="rl">Admin</span>
							  <span><a href="javascript:void(0);" @click="onClickCopyExternalUserLink(collaborator.token)" class="share ">Copy Link</a></span>
					 		  <span><a href="javascript:void(0);" @click="onClickStopExternalLinkSharing(collaborator, index)" class="share ">Stop Sharing</a></span>
							  <!--<span><i v-if="!collaborator.admin" class="ti-close rmv-ico" title="Close"@click="deleteCollaborator(index)" ></i></span>-->
						  </li>
						</div>
						</ul>
					</div>
					
					<div v-if="showShareLinkPopup" id="create-share-url" class="add-pop ui-dialog adusrpop" style="display: block;">
						<div class="head">Share Url <a href="javascript:void(0);" @click="onClickShowShareLinkPopupClose" title="Close" class="close"></a></div>
						<div class="rec lblm">
							<label>Add User</label>
							<ul class="addusr addusrinp" :class="[showFieldRed ? 'required' : '']" >
							  <li v-for="(collaborator, index) in userEmails" class="add">
								<span>{{ collaborator }}<a href="javascript:void(0);" v-on:click = "onClickDeleteInput(index)"   title="Remove" class="close"></a></span>
							  </li>
							  <li>
								<input id="title" type="text" required v-model="inputText" placeholder="Enter Email"  @blur="onInputFocusOut"></input>
							  </li>
							<span v-if="showFieldRed" id="title" class="mstxt red-msg">Email field is empty</span>
							</ul>
						</div>
						<div class="rec lblm half role-a">
						<label>Assign Role</label>
						 <div class="selectcont">
							<select v-model="selectedRight">
								 <option disabled value="">Select... </option>
								 <option v-for="(right, key) in shareRights" :value="key">{{right}}</option>
							 </select>
						 </div>
						</div>
					</div>
	
				</div>
				<div class="rec btn">
					<a href="javascript:void(0);" @click="onPopupShare(userEmails, selectedRight )" class="share button FR">Share</a>
					<!--<a href="javascript:void(0)" @click="onPopupClose" class="button FR">Done</a>-->
				</div>
		</div>
		</div>
		`,
	props: ["board"],
	data() {
		return {
			dataModel: {
				shareUrl: ""
			},
			allUsers: [],
			userEmails: [],
			inputText: "",
			shareRights: { 3: "Write", 1: "Read" },
			selectedRight: "",
			existingCollaborators: [],
			externalCollaborators: [],
			showFieldRed: false,
			showShareLinkPopup: false,
		}
	},
	mounted() {
		this.getAllUsers();
		this.loadCollaborators();
	},
	created() {
		if (this.model && this.model._id) {
			this.dataModel = _.cloneDeep(this.model);
		}
	},
	methods: {
		onClickDeleteInput: function (index) {
			if (index > -1) {
				this.userEmails.splice(index, 1);
			}
		},
		onInputFocusOut: function () {
			if (this.inputText != "") {
				this.userEmails.push(this.inputText);
			}
			if (this.inputText == '') {
				this.showFieldRed = true;
			} else {
				this.showFieldRed = false;
			}
			this.inputText = "";

		},
		loadCollaborators: function () {
			if (this.board && this.board.collaborators) {
				this.board.collaborators.forEach(collaborator => {
					if (collaborator.external) {
						this.setExternalCollaborators(collaborator);
					} else {
						this.setExistingCollaborators(collaborator);
					}

				});
			}
		},
		getAllUsers: function () {
			axios.get('/admin/users')
				.then(response => {
					this.allUsers = response.data[0];
				})
				.catch(error => {
				});
		},
		onPopupClose: function () {
			this.$emit('close-popup');
		},
		onPopupShare: function (userEmails, selectedRight) {
			if (_.isEmpty(userEmails)) {
				this.showFieldRed = true;
			}
			if (selectedRight == "") {
				showTopMessage('Please select right', 'warning');
			}
			if (!_.isEmpty(userEmails) && selectedRight != "") {
				var requestBody = { "emails": userEmails, "right": selectedRight, "boardId": this.board.id }
				axios.post('/graphx/board/permission', requestBody)
					.then(response => {
						this.selectedRight = "";
						this.userEmails = [];
						if (response.data.board) {
							showTopMessage('Board shared successfully', 'success');
							this.$emit('update-board-detail', response.data.board);
							this.existingCollaborators = [];
							this.externalCollaborators = [];
							response.data.board.collaborators.forEach(collaborator => {
								if (collaborator.external) {
									this.setExternalCollaborators(collaborator);
								} else {
									this.setExistingCollaborators(collaborator);
								}

							})
						}
						/*else {
							showTopMessage('User is not a kendis user', 'warning');
						}*/
					})
					.catch(error => {
					});
			}
		},
		onClickStopSharing: function () {
			this.$emit('stop-share');
		},
		onClickCopyShareLink: function () {
			console.log(this.$parent.hostUrl);
			console.log(this.$parent.shareUrl);
			var text = this.$parent.hostUrl + this.$parent.shareUrl;
			navigator.clipboard.writeText(text);
		},
		onClickCopyExternalUserLink: function (accessToken) {
			var url = "/graphx/board/public_share/root?token=" + accessToken;
			var text = this.$parent.hostUrl + url;
			navigator.clipboard.writeText(text);
		},
		onClickStopExternalLinkSharing: function (collaborator, index) {
			var requestBody = { "boardId": this.board.id, "token": collaborator.token };
			//var boardId = this.board.id;
			//var token = collaborator.token;
			axios.post('/graphx/stopExternalShareUrl', requestBody)
				.then(response => {
					if (!_.isEmpty(response.data)) {
						if (response.data.success) {
							showTopMessage('External Collaborator deleted successfully', 'success');
							this.board.collaborators.forEach(collaborator => {
								if (collaborator.external && collaborator.token === response.data.accessToken) {
									this.board.collaborators.splice(index, 1)
								}

							});

							if (index > -1) {
								this.externalCollaborators.splice(index, 1);
							}
						}
					}
				})
				.catch(error => {
				});
		},
		onClickShareLink: function () {
			this.showShareLinkPopup = true;
		},
		onClickShowShareLinkPopupClose: function () {
			this.showShareLinkPopup = false;
		},
		setExistingCollaborators: function (collaborator) {
			if (collaborator.user) {
				let user = {}
				user.fullName = collaborator.user.fullName
				user.id = collaborator.user.id
				user.access = this.shareRights[collaborator.access]
				user.admin = collaborator.admin
				this.existingCollaborators.push(user)
			}
		},
		setExternalCollaborators: function (collaborator) {
			if (collaborator) {
				let user = {}
				user.fullName = collaborator.externalUser.fullName;
				user.id = collaborator.externalUser.id;
				user.email = collaborator.externalUser.email;
				user.access = this.shareRights[collaborator.access];
				user.admin = collaborator.admin;
				user.isExternal = collaborator.external;
				user.token = collaborator.token;
				this.externalCollaborators.push(user);
			}
		},
		deleteCollaborator: function (index) {
			this.$emit("delete-collaborator", this.existingCollaborators[index].id)
			console.log(this.existingCollaborators[index].id)
			if (index > -1) {
				this.existingCollaborators.splice(index, 1);
			}
		}
	}
});

const CREATESHAREURL2 = Vue.component('create-share-url2', {
	name: 'create-share-url2',
	template: `
	<div class="DAJ">
		<div class="overlay" style="display: block;"></div>
		<div id="create-share-url" class="add-pop ui-dialog cplnk" style="display: block;">
			<div class="head">Share Link <a href="javascript:void(0);" @click="onPopupClose" title="Close" class="close"></a></div>
			<div class="cntr prow">				
					<div v-for="(right,index) in shareBoardRights" class="rec DFA">
						<div class="switch-button-class">
							<input type="checkbox" @change="onEnableShareRights(right.code)" :id="index" v-bind:class="[boardShareRightsValue[right.code] === true ? 'checked': 'unchecked']">
							<span class="a"><label :for="index"></label></span>
						</div>
						<span class="txt ftsb">{{right.narrative}}</span>
						<button class="p-abs prbtn" v-if="boardShareRightsValue[right.code]" @click="copyShareBoardLink($event,right.code)">Copy Link</button>
					</div>				
				</div>
				</div>
				
		</div>
		</div>
		`,
	props: ["board","shareBoardRights"],
	data() {
		return {
			
			boardShareRightsValue:[],
		}
	},
	created() {
		this.initializeShareBoardRights();
	},
	methods: {
		initializeShareBoardRights: function() {
			var _this = this;
			_.each(this.shareBoardRights, right => {
				_this.boardShareRightsValue[right.code] = false;
			});
			if (this.board.publicLinks) {
				_.each(this.board.publicLinks, link => {
					if (link.token) {
						_this.boardShareRightsValue[link.accessLevel] = true;
					}
				});
			}

		},
		
		onPopupClose: function () {
			this.$emit('close-popup');
		},
		
		onEnableShareRights : function (code){			
			var _this = this;
			if(_this.boardShareRightsValue[code]){
				_this.boardShareRightsValue[code] = false;
			}else{
				_this.boardShareRightsValue[code] = true;
			}
			_this.$forceUpdate();
			
			var requestBody = {"boardId": this.board.id, "code" : code, "value" :_this.boardShareRightsValue[code], params:{"boardId": this.board.id, "companyId":loggedInUser.loggedInUserCompany.company.id, "right":code}};
			// requestBody.params = JSON.stringify(requestBody.params);
			
			axios.post('/graphx/setShareBoardToken', requestBody)
			.then(response => {
				if (!_.isEmpty(response.data)) {
					if (response.data.success) {
						_this.board.publicLinks = response.data.publicLinks;
					}
				}
			})
			.catch(error => {
			});	
				
		},
		copyShareBoardLink: function(event,code){
			var accessToken;
			_.each(this.board.publicLinks, link => {
				if (link.accessLevel == code) {
					accessToken = link.token;
				}
			});

			var url = "/graphx/public_share/board/root?token="+accessToken;
			
			// Get current URL parameters to preserve context (consistent with existing code)
			const hash = window.location.hash;
			const queryString = hash.split('?')[1];
			
			if (queryString) {
				url += "&" + queryString;
			}

			var text = this.$parent.hostUrl + url;
			navigator.clipboard.writeText(text);
			
			// changing button text
			var oldText =  event.target.textContent;
			event.target.textContent = "Link Copied";
			setTimeout(function() {
				event.target.textContent = oldText;
			}, 5000);
			
		},
		onClickStopSharing: function () {
			this.$emit('stop-share');
		},
		onClickCopyShareLink: function () {
			console.log(this.$parent.hostUrl);
			console.log(this.$parent.shareUrl);
			var text = this.$parent.hostUrl + this.$parent.shareUrl;
			navigator.clipboard.writeText(text);
		},
		onClickCopyExternalUserLink: function (accessToken) {
			var url = "/graphx/public_share/board/root?token="+accessToken;
			var text = this.$parent.hostUrl + url;
			navigator.clipboard.writeText(text);
		},
	}
});

const SAVEASTEMPLATE = Vue.component('save-as-template', {
	name: 'save-as-template',
	template: `
		<div>
		<div class="overlay" style="display: block;"></div>
		<div id="create-board" class="add-pop ui-dialog svtmp" style="display: block;">
			
			<div class="head"> {{board.type !== 'template' ? 'Save As Template' : 'Edit Template'}} <a href="javascript:void(0);" @click="onCloseTemplate" title="Close" class="close"></a></div>
			
			<div class="cntr mrow">
				<div class="rec lblm pt-0" >
					<label>Title</label>
					<input id="title" type="text" required  v-model="dataModel.title" class="rnd4" placeholder="Title" :class="{'required':dataModel.errors.title}"  @blur="checkValidation"></input>
				</div>
				
				<div class="rec lblm pt-0" >
					<label>Description</label>
					<textarea v-model="dataModel.description" class="rnd4"></textarea>
				</div>
				
				<div v-if="board.type !== 'template'" class="rec lblm pt-0" :class="{'required':dataModel.errors.type}" >
					<label>Type</label>
					<div class="selectcont rnd4">
					<vz-select :options="types" value-type="object" v-model="dataModel.collabType">
					</vz-select>
					</div>
				</div>
				
				<div v-if="showTeamDropdown" class="rec lblm pt-0">
					<label class="form-label ftsb">Select Team</label>
					<div class="selectcont rnd4">
						<vz-select 
							v-if="sessionTeams.length > 0"
							:multiple="true" 
							track-by="id" 
							empty-selection-text="Choose Teams"
							selected-title="Teams Selected"
							v-model="chosenTeams" 
							:options="sessionTeams"
							class="multi-filter" 
							value-type="object"
							placeholder="Choose Teams"
						/>
					</div>
                </div>
				
				<div v-if="showSessionDropdown" class="rec lblm pt-0">
					<label class="form-label ftsb">Select Program Boards</label>
					<div class="selectcont rnd4">
						<vz-select 
							v-if="solutionSessions.length > 0"
							:multiple="true" 
							track-by="id" 
							empty-selection-text="Choose Program Boards"
							selected-title="Program Boards Selected"
							v-model="chosenSessions" 
							:options="solutionSessions"
							class="multi-filter" 
							value-type="object"
							placeholder="Choose Program Boards"
						/>
					</div>
                </div>
				
				<div v-if="showSolutionDropdown" class="rec lblm pt-0">
					<label class="form-label ftsb">Select Solution Boards</label>
					<div class="selectcont rnd4">
						<vz-select 
							v-if="workspaceSolutionBoards.length > 0"
							:multiple="true" 
							track-by="id" 
							empty-selection-text="Choose Solution Boards"
							selected-title="Solution Boards Selected"
							v-model="chosenWorkspaceSolutionBoards" 
							:options="workspaceSolutionBoards"
							class="multi-filter" 
							value-type="object"
							placeholder="Choose Solution Boards"
						/>
					</div>
                </div>
				
				<div class="rec btn">
					<button @click="onSaveTemplate" class="FR rnd4">Save</button>
					<a href="javascript:void(0)" @click="onCloseTemplate" class="FR cncl url">Cancel</a>
				</div>
			</div>
		</div>
		</div>
		`,
	props: ["boardId","board","image"],
	data() {
		return {
			pendingTeamTypeSelection: false,
			chosenTeams: [],
			contextBoard: null,
			showTeamDropdown: false,
			sessionTeams: [],
			// Solution context properties
			pendingSessionTypeSelection: false,
			chosenSessions: [],
			showSessionDropdown: false,
			solutionSessions: [],
			// Workspace/Collections context properties
			showSolutionDropdown: false,
			chosenWorkspaceSolutionBoards: [],
			workspaceSolutionBoards: [],
			dataModel: {
				title: "",
				description: "",
				collabType: undefined,
				piTeamArea: {},
				piSessions: [],
				workspaceSolutionBoards: [],
				errors: {
					title: false,
					type: false
				}
			},
			types:[],
			context: "",
			contextId: "",
			existingTemplate: undefined
		}
	},
	mounted() {
		//this.loadAllTemplates();
	},

	watch:{
		"dataModel.collabType"(newVal) {
			if (newVal?.id === "selectTeams") {
				this.showTeamDropdown = true;
				this.showSessionDropdown = false;
				this.showSolutionDropdown = false;
			} else if (newVal?.id === "selectSessions") {
				this.showSessionDropdown = true;
				this.showTeamDropdown = false;
				this.showSolutionDropdown = false;
			} else if (newVal?.id === "selectSolutionBoards") {
				this.showSolutionDropdown = true;
				this.showTeamDropdown = false;
				this.showSessionDropdown = false;
			} else {
				this.showTeamDropdown = false;
				this.showSessionDropdown = false;
				this.showSolutionDropdown = false;
			}
		},
	},

	created() {
		
		if (this.board && this.board.type && this.board.type == "template") {
			this.dataModel.title = this.board.title;
			this.dataModel.description = this.board.description;
		}
		else {
			
			let fullPath = this.$route.fullPath;
			let pathParts = fullPath.split("?");

			let params = {};

			if (pathParts.length == 2) {
				let paramStr = pathParts[1];
				let paramPairs = paramStr.split("&");
				for (let i = 0; i < paramPairs.length; i++) {
					let keyValue = paramPairs[i].split("=");
					params[keyValue[0]] = keyValue[1];
				}
			}

			const solution = params["solution"];
			const session = params["session"];
			const workspace = params["art"];
			if (session) {
				this.context = "session";
				this.contextId = session;
			}
			else if (solution) {
				this.context = "solution";
				this.contextId = solution;
			}
			else if (workspace) {
				this.context = "workspace";
				this.contextId = workspace;
			}

			if (this.board && this.board.collaborationType) {
				this.dataModel.collabType = this.board.collaborationType;
			}
			//console.log(this.image);

			this.loadCollaborationTypes();
			this.loadExistingTemplates();
		}
	},
	methods: {
		////////////////////LOGIC////////////////////////////////////
		checkValidation: function () {
			if (this.dataModel.title == '') {
				this.showFieldRed = true;
			} else {
				this.showFieldRed = false;
			}
		},
		/////////////////////API////////////////////////////////
		
		
		loadExistingTemplates: function () {
			let _this = this;
			axios.get('/graphx/template/byCreatedFromBoard/' + this.board.id )
				.then(response => {
					if (response.data) {
						let templates = response.data.templates;
						if (templates && templates.length > 0) {
							let latestTemplate = templates[templates.length-1];
							if (latestTemplate) {
								
								let collab = _.find(latestTemplate.collaborators, col=> {
									return col.user.userName == loggedInUser.userName;
								});
								if (collab) {
									_this.existingTemplate = latestTemplate;
									_this.dataModel.title  = latestTemplate.title;
									_this.dataModel.description = latestTemplate.description;
									
									if (latestTemplate?.collaborationType) {
										_this.dataModel.collabType = latestTemplate.collaborationType;
									} else if (_this.context === "session") {
										this.dataModel.piTeamArea = latestTemplate?.piTeamArea;
										this.fetchContextBoard(this.contextId, true);
									} else if (_this.context === "solution") {
										var sessionIds = [];
										if (latestTemplate?.session && latestTemplate.session.length > 0) {
											sessionIds = latestTemplate.session.map(function(session) {
												return session.id;
											});
										}
										this.dataModel.piSessions = sessionIds;
										this.fetchSolutionContextSessions(this.contextId, true);
									} else if (_this.context === "workspace") {
										var sessionIds = [];
										if (latestTemplate?.session && latestTemplate.session.length > 0) {
											sessionIds = latestTemplate.session.map(function(session) {
												return session.id;
											});
										}
										this.dataModel.piSessions = sessionIds;
										
										var workspaceSolutionBoardIds = [];
										if (latestTemplate?.solutionBoard && latestTemplate.solutionBoard.length > 0) {
											workspaceSolutionBoardIds = latestTemplate.solutionBoard.map(function(solution) {
												return solution.id;
											});
										}
										this.dataModel.workspaceSolutionBoards = workspaceSolutionBoardIds;
										this.fetchWorkspaceContextBoards(this.contextId, true);
									}
								}
							}
						}
					}
				})
				.catch(error => {

				});
		}, 
		loadCollaborationTypes: function () {
			let _this = this;
			_this.types = [];
			let data = {};
			data.context = this.context;
			
			 if(this.context === "session") {
                id = this.contextId;
				this.fetchContextBoard(id);
                //data.origin = "sessionBoard";
            } else if(this.context === "solution") {
                id = this.contextId;
				 this.fetchSolutionContextSessions(id);
            } else if(this.context === "workspace") {
                id = this.contextId;
				 this.fetchWorkspaceContextBoards(id);
            } else if(this.context) {
                id = this.contextId;
            }

			_this.createTypesRelatedToContext(id, data)
				.then(function(createResult) {
					return axios.post(`/collaboration-type/getAllTypes/${id}`, data);
				})
                .then(response => {
                    this.loadingTypes = false;
                    if (response.data && response.data.success) {
                       this.allContextTypes = response.data.types;
                       let types = response.data.types;
                       _.each(types, type=> {
						   if (!["sessionTeam", "solutionPiBoard", "workspacePiBoard", "workspaceSolutionBoard"]
							   .includes(type.defaultOrigin)) {
							   _this.types.push({
								   id: type.id,
								   title: type?.defaultOrigin
									   ? type.title.charAt(0).toUpperCase() + type.title.slice(1)
									   : type.title,
								   team: true
							   });
						   }
					   });
						if (!this?.board) {
							_this.dataModel.collabType = types.find(type => type?.defaultOrigin === this.context);
						}
                    }
                })
                .catch(error => {
                    this.loadingTypes = false;
                });
			
			/*_this.types = [];
			
			_this.types.push({id:"general", title: "General"});
			
			if (_this.context == "session") {
				
				_this.types.push({id:"inspectandadopt", title: "Inspect And Adopt",inspectandadopt: true});
				
				axios.get('/pi/session/'+this.contextId+'/teams')
				.then(response => {
					if (response.data) {
						let teams = response.data.teams;
						if (teams) {
							_.each(teams, team=> {
								_this.types.push({id:team.id, title: team.title,team: true});
							});
						}
						_this.loadCustomCollaboration();
					}
				})
				.catch(error => {

				});
			}
			else if (_this.context == "solution") {
				
				axios.get('/solution/board/piboards/'+this.contextId)
				.then(response => {
					if (response.data) {
						let sessions = response.data.sessions;
						if (sessions) {
							_.each(sessions, session=> {
								_this.types.push({id:session.id, title: session.title,piboard: true});
							});
						}
						_this.loadCustomCollaboration();
					}
				})
				.catch(error => {

				});
			}
			else if (_this.context == "workspace") {
				
				axios.get('/releasetrain/'+this.contextId+'/solutionBoards/piboards/byKey')
				.then(response => {
					if (response.data) {
						let sessions = response.data.sessions;
						if (sessions) {
							_.each(sessions, session=> {
								_this.types.push({id:session.id, title: session.title,piboard: true});
							});
						}
						
						let solutionBoards = response.data.solutionBoards;
						if (solutionBoards) {
							_.each(solutionBoards, solution=> {
								_this.types.push({id:solution.id, title: solution.title, solution: true});
							});
						}
						_this.loadCustomCollaboration();
					}
				})
				.catch(error => {

				});
				
			}			*/
			
		},

		createTypesRelatedToContext(id, data){
			const _this = this;
			return new Promise(function(resolve, reject){
				axios.post(`/collaboration-type/createAllTypes/${id}`,data)
					.then(function(response){
						if (response.data && response.data.success) {
							resolve(true);
						} else {
							resolve(false);
						}
					})
					.catch(function(error){
						console.error(error);
						resolve(false);
					});
			});
		},

		fetchContextBoard(id, populateType = false) {

			axios.get(`/plan/getBoard/${id}`)
				.then(response => {
					if (response.data.board) {
						this.contextBoard = response.data.board

						// only push when has not that type
						if (!this.types.some(t => t.id === "selectTeams")) {
							this.types.push({
								id: "selectTeams",
								title: this.contextBoard.session?.teamsLabel,
								team: true
							});
						}

						if(populateType ){
							this.dataModel.collabType = this.types.find(type => type.id === "selectTeams");
						}

						this.populateSessionTeams(this.contextBoard);
					}
				})
				.catch(error => {
					console.error('Error searching users:', error);
				})
		},

		fetchSolutionContextSessions(id, populateType = false) {
			axios.get(`/solution/sessions/${id}`)
				.then(response => {
					if (response.data && response.data.success) {
						const sessions = response.data.sessions;
						this.contextBoard =  sessions;
						if (!this.types.some(t => t.id === "selectSessions")) {
							this.types.push({
								id: "selectSessions",
								title: "Program Boards",
								session: true
							});
						}

						if (populateType) {
							this.dataModel.collabType = this.types.find(type => type.id === "selectSessions");
						}

						this.populateSolutionSessions(this.contextBoard);
					}
				})
				.catch(error => {
					console.error('Error fetching solution sessions:', error);
				});
		},

		fetchWorkspaceContextBoards(id, populateType = false) {
			axios.get(`/releasetrain/${id}/solutionBoards/piboards`)
				.then(response => {
					if (response.data) {
						const data = response.data;
						this.contextBoard = data;
						if (data.sessions && data.sessions.length > 0) {
							if (!this.types.some(t => t.id === "selectSessions")) {
								this.types.push({
									id: "selectSessions",
									title: "Program Boards",
									session: true
								});
							}
						}
						if (data.solutionBoards && data.solutionBoards.length > 0) {
							if (!this.types.some(t => t.id === "selectSolutionBoards")) {
								this.types.push({
									id: "selectSolutionBoards",
									title: "Solution Boards",
									solutionBoard: true
								});
							}
						}

						if (populateType) {
							if (this.dataModel.workspaceSolutionBoards && this.dataModel.workspaceSolutionBoards.length > 0) {
								this.dataModel.collabType = this.types.find(type => type.id === "selectSolutionBoards");
							} else if (this.dataModel.piSessions && this.dataModel.piSessions.length > 0) {
								this.dataModel.collabType = this.types.find(type => type.id === "selectSessions");
							}
						}

						this.populateSolutionSessions(data.sessions || []);
						this.populateWorkspaceSolutionBoards(data.solutionBoards || []);
					}
				})
				.catch(error => {
					console.error('Error fetching workspace context boards:', error);
				});
		},

		populateSessionTeams(board) {
			if(board?.teams){
				this.sessionTeams = board.teams.map(team => ({
					id: team.id,
					title: team.title,
					identifier: "team"
				}));
			}

			if(this.context==="session" && this.dataModel.piTeamArea){
				const teamIds = this.dataModel.piTeamArea[this.contextId] || [];

				this.chosenTeams = this.sessionTeams.filter(team =>
					teamIds.includes(team.id)
				);
			}
		},

		populateSolutionSessions(sessions) {
			if(sessions?.length > 0){
				this.solutionSessions = sessions.map(session => ({
					id: session.id,
					title: session.title,
					identifier: "session"
				}));
			}

			if((this.context==="solution" || this.context==="workspace") && this.dataModel.piSessions){
				const sessionIds = this.dataModel.piSessions || [];

				this.chosenSessions = this.solutionSessions.filter(session =>
					sessionIds.includes(session.id)
				);
			}
		},


		populateWorkspaceSolutionBoards(solutionBoards) {
			console.log('populateWorkspaceSolutionBoards called with:', solutionBoards);
			console.log('Current dataModel.workspaceSolutionBoards:', this.dataModel.workspaceSolutionBoards);
			
			if(solutionBoards?.length > 0){
				this.workspaceSolutionBoards = solutionBoards.map(solution => ({
					id: solution.id,
					title: solution.title,
					identifier: "workspaceSolutionBoard"
				}));
			}

			if(this.context==="workspace" && this.dataModel.workspaceSolutionBoards){
				const solutionIds = this.dataModel.workspaceSolutionBoards || [];

				this.chosenWorkspaceSolutionBoards = this.workspaceSolutionBoards.filter(solution =>
					solutionIds.includes(solution.id)
				);
			}
		},

		loadCustomCollaboration: function () {
			let _this = this;
			axios.post('/collaboration-type/context/'+this.contextId, data)
				.then(response => {
					if (response.data) {
						_.each(response.data.type, type=> {
							type.custom = true;
							_this.types.push(type);
						});
					}
				})
				.catch(error => {

				});
		},
		applyTemplate: function (template) {

			var data = {};
			data.templateId = template.id;
			data.boardId = this.boardId;

			axios.post('/graphx/apply_template', data)
				.then(response => {
					if (response) {
						board.startTransaction(null);
						board.model.addNodeDataCollection(response.data.nodes);
						board.model.addLinkDataCollection(response.data.links);
						board.commitTransaction(null)
						this.$emit('close-template');
					}
				})
				.catch(error => {

				});
		},
		loadAllTemplates: function () {
			axios.get('/graphx/template/all/' + this.board?.collaborationType?.id)
				.then(response => {
					if (!_.isEmpty(response.data)) {
						if (response.data.success) {
							//	this.availableTemplates = response.data.templates;
							if (response.data.templates) {
								_.each(response.data.templates, template => {
									if (template.type == 'template') {
										this.availableTemplates.push(template);
									}
								});
							}
							//this.templates = response.data.templates;
							//store.commit('setTemplate',this.templates);
						}
					}
				})
				.catch(error => {
					
				});
		},
		//////////////////EVENT HANDLER////////////////////////////////////
		onCloseTemplate: function () {
			this.$emit('close-template');
		},
		onSaveTemplate: function () {
			
			this.dataModel.errors.title = _.isEmpty(this.dataModel.title);
			this.dataModel.errors.type  = _.isEmpty(this.dataModel.collabType);
			
			if (this.board.type && this.board.type == "template") {
				if (this.dataModel.errors.title) {
					return;
				}
				
				const _this = this;
				
				var payload = {
					boardId: _this.board.id,
					title: _this.dataModel.title,
					description: _this.dataModel.description
				};

				axios.post('/graphx/board/update-title-description', payload)
					.then(function(response) {
						if (response && response.data && response.data.success) {
							showTopMessage("Template updated", 'success');
							
							_this.board.title = response.data.board.title;
							_this.board.description = response.data.board.description;
							_this.$emit('close-template');
						}
					})
					.catch(function(error) {
						console.log('Error updating board:', error);
						if (error.response && error.response.data) {
							showTopMessage(error.response.data.message || 'Error updating board', 'error');
						} else {
							showTopMessage('Error updating board', 'error');
						}
					});

			}
			else {
				if (this.dataModel.errors.title || this.dataModel.errors.type) {
					return;
				}
				this.dataModel.image = this.image;
				this.dataModel.context = this.context;
				this.dataModel.contextId = this.contextId;
				this.dataModel.createdFromBoard = this.board.id;
				if (this.context === "session" && this.chosenTeams.length > 0) {
					if (!this.dataModel.piTeamArea) {
						this.dataModel.piTeamArea = {};
					}
					this.dataModel.piTeamArea[this.contextId] = this.chosenTeams.map(team => team?.id);
				}

				if ((this.context === "solution" || this.context === "workspace") && this.chosenSessions.length > 0) {
					this.dataModel.piSessions = this.chosenSessions.map(session => session?.id);
				}

				if (this.context === "workspace" && this.chosenWorkspaceSolutionBoards.length > 0) {
					this.dataModel.workspaceSolutionBoards = this.chosenWorkspaceSolutionBoards.map(solution => solution?.id);
				}

				let _this = this;
				if (this.existingTemplate && this.existingTemplate.title == this.dataModel.title) {
					askFromSweetAlertWrapper("Do you want to replace existing template.",
						[() => {
							_this.dataModel.existingTemplateId = _this.existingTemplate.id;
							_this.dataModel.replace = true;
							_this.$emit('save-template', _this.dataModel);
						}], [() => {

						}]);
				}
				else {
					_this.dataModel.replace = false;
					_this.$emit('save-template', _this.dataModel);
				}
			}
			
		},
	}
});

const BOARDPREVIEW = Vue.component('board-preview', {
	name: 'board-preview',
	template: `
		<div>

		<!--<div class="overlay" style="display: block;"></div>
		<div id="create-board" class="add-pop ui-dialog takebrd" style="display: block;">
			<div class="head">Take Board Preview <a href="javascript:void(0);" @click="onClosePreview" title="Close" class="close"></a></div>-->

		<!-- <div class="overlay" style="display: block;"></div> -->
		<div id="create-board" class="takebrd" style="display: block;" v-click-outside="onClosePreview">
			<!-- <div class="head">Take Board Preview <a href="javascript:void(0);" @click="onClosePreview" title="Close" class="close"></a></div> -->


				
				<img id="image" style="max-width: 100%;" :src="boardImage" />				
				
				<div class="rec btn DFA">
					<div class="txt FL">Select area for a board preview</div>
					<a href="javascript:void(0)" @click="onClosePreview" class="button-w">Cancel</a>
					<button @click="onSavePreview" class="ml-20">Save</button>
				</div>
			
		</div>
		</div>
		`,
	props: ["boardImage"],
	data() {
		return {
			cropper: ""
		}
	},
	mounted() {
		var options = {
			aspectRatio: 16 / 9,
			dragMode: 'move',
			viewMode: 3

		};
		var image = document.getElementById('image');
		this.cropper = new Cropper(image, options);
	},
	created() {
	},
	methods: {
		onClosePreview: function () {
			this.$emit('close-preview');
		},
		onSavePreview: function () {
			var uploadedImageType = 'image/jpeg';
			var canvas = this.cropper.getCroppedCanvas({
				width: 160,
				height: 160,
			});
			var imageData = canvas.toDataURL(uploadedImageType)
			this.$emit('save-preview', imageData);
		}
	}
});

const EDITBOARDSETTINGS = Vue.component('edit-board-settings', {
	name: 'edit-board-settings',
	template: `
	<div>
		<div class="overlay" style="display: block;"></div>
		<div id="create-board" class="add-pop ui-dialog edtbrd" style="display: block;">
			<a href="javascript:void(0);" @click="onCloseTemplate" title="Close" class="close"></a>
			<div class="cntr mrow">
				<div class="rec lblm ttl">
					<!-- <label>Board Title</label> -->
					
					<input id="title" type="text" required  v-model="title" placeholder="Title" :class="[showFieldRed ? ' inpnw required' : 'inpnw']"  @blur="checkValidation" v-on:keyup.enter="onSaveBoardSettings"/>
					<span v-if="showFieldRed" id="title" class="mstxt red-msg">Title field is empty</span>				
				</div>
				
				<div class="rec lblm clr">
					<label>Background Colors</label>
					<div class="DF">
						<div class="clin" v-for="(color, index) in backgroundColors">
							<a :class="[selectedColor===color?'active':'']" href="javascript:void(0);" @click="onSelectColor(color)" v-bind:style="{'background-color':color}"></a>
						</div>
					</div>
				</div>
				
				<div class="rec lblm ptrn">
					<label>Background Pattern</label>
					<div class="DF ptin">
						
						<div class="ptin" v-for="(pattern, index) in backgroundPattern">
							<a :class="[selectedPattern === pattern.value? 'active' : '']" href="javascript:void(0);" @click="onSelectPattern(pattern.value)">
								<img :src="pattern.url2" alt="Setting" class="ico" />
							</a>
						</div>
						
						<!--<a class="DFA" href="javascript:void(0);" :class="[selectedPattern=== 'a'?'active':'']"  @click="onSelectPattern('a')"><img src="/assets/icons/collab/bggrid.svg" alt="..." class="ico a" /></a>
						<a class="DFA" href="javascript:void(0);" :class="[selectedPattern=== 'b'?'active':'']"  @click="onSelectPattern('b')"><img src="/assets/icons/collab/bgguid.svg" alt="..." class="ico b" /></a>
						<a class="DFA" href="javascript:void(0);" :class="[selectedPattern=== 'c'?'active':'']"  @click="onSelectPattern('c')"><em class="ti-menu ico c" /></a>
						<a class="DFA" href="javascript:void(0);" :class="[selectedPattern=== 'd'?'active':'']"  @click="onSelectPattern('d')"><em class="ti-layout-grid4 ico d" /></a>
						<a class="DFA" href="javascript:void(0);" :class="[selectedPattern=== 'e'?'active':'']"  @click="onSelectPattern('e')"><em class="ti-view-grid ico e" /></a>-->
					</div>
				</div>
				
				<div class="rec info">
					<div class="rec lblm">
						<label>Owner</label> <span class="txt"> {{board.createdBy}}</span>	
					</div>
					
					<div class="rec lblm">
						<label>Created</label> <span class="txt"> {{formatDate(board.createdOn)}}</span>	
					</div>
						
					<div class="rec lblm">
						<label>Last Modified</label> <span class="txt"> {{formatDate(board.updatedOn)}}</span>	
					</div>
					
					<!--<div v-if="boardDetail.type != 'template'" class="rec lblm">
						<label>Location</label> <span class="txt"> {{getFolderName()}}</span>	
					</div>
					<div class="rec lblm">
						<label>Number of Collaborators</label> <span class="txt"> {{getCollaborators()}}</span>	
					</div>-->
				</div>
				
				<div class="rec btn">
					<button @click="onDuplicateBoard(boardDetail);" class="FL mr-20 button-w">Duplicate</button>
					<!--<button @click="onShareBoard()"          class="FL button-w">Share</button>-->
					<button @click="onSaveBoardSettings"     class="FR">Save</button>
					<a href="javascript:void(0)" @click="onCloseTemplate" class="FR cncl url">Cancel</a>
				</div>
			</div>
		</div>
		
		<!--<div v-if="openDialogPopup" class="add-pop ui-dialog" style="display: block;margin-top:60px;">
			<div class="head"><a href="javascript:void(0);" @click="openDialogPopup = false;" title="Close" class="close"></a></div>
				<div class="rec lblm">
					<input id="title" type="text" v-model="updatedTitle" placeholder="Board Title" class="a"></input>					
				</div>
			</div>
		</div>-->
		
		<duplicate-board v-if="showDuplicateBoardPopup" :list="foldersList" :board="boardDetail" @close-popup="closeDuplicateBoardPopup" ></duplicate-board>
		
		</div>
	`,
	props: ["board", "user"],
	data() {
		return {
			boardDetail: {},
			title: "",
			updatedTitle: '',
			foldersList: [],
			folder: {},
			backgroundColors: [],
			selectedColor: '',
			selectedPattern: '',
			openDialogPopup: false,
			backgroundPattern: [],
			showDuplicateBoardPopup: false,
			showFieldRed: false,
		}
	},
	created() {
		if (this.board && this.board.id) {
			this.title = _.cloneDeep(this.board.title);
			this.updatedTitle = _.cloneDeep(this.board.title);
			this.boardDetail = _.cloneDeep(this.board);
		}

		if (this.boardDetail.type != 'template') {
			this.getFolderLocation();
		}

		this.backgroundColors = ["#EEEEEE", "#B4BDC2", "#2A3135", "#FFF9E7", "#EFF6E9", "#E2F6FA", "#ECE7F4", "#F9E5EC","#E2F2F0"];

		this.backgroundPattern = [
			{
				title: 'dotted',
				value: 'dotted',
				url2: "/assets/icons/collab/bggrid.svg"
			},
			{
				title: 'lines',
				value: 'lines',
				url2: "/assets/icons/collab/bgguid.svg"
			},
			{
				title: 'plain',
				value: 'plain',
				url2: "/assets/icons/collab/bgguid1.svg"
			}
		];

		this.selectedColor = this.boardDetail.backgroundColor;
		this.selectedPattern = this.boardDetail.backgroundPattern;
	},
	methods: {
		//////////////LOGIC//////////////////////////////
		checkValidation: function () {
			if (this.title == '') {
				this.showFieldRed = true;
			} else {
				this.showFieldRed = false;
			}
		},
		getCollaborators: function () {
			var countCollaborators = 0;
			var collaborators = this.boardDetail.collaborators;
			if (collaborators) {
				_.each(collaborators, collaborator => {
					if (collaborator.user.id != this.user.id) {
						countCollaborators = countCollaborators + 1;
					}
				});
			}
			return countCollaborators;
		},
		/*getFolderName: function () {

			return this.folder.title;
		},*/
		formatDate: function (_date) {
			if (!_date) {
				return "";
			}
			var date = new Date(_date);
			return date.format("d mmm yyyy");
		},

		/////////////////API/////////////////////////
		getFolderLocation: function () {
			//get folder
			axios.get('/graphx/folder/' + this.boardDetail.folderId)
				.then(response => {
					this.folder = response.data.folder;
				})
				.catch(error => {

				});
		},
		onSaveBoardSettings: function () {
			var _this = this;
			if (_this.title === "") {
				_this.showFieldRed = true;
			}  else if(_this.title.length > 256) {
				showTopMessage('String length must not exceed 256 characters', 'warning')
			} 
			 else {
				var data = {
					title: _this.title,
					id: _this.boardDetail.id,
					backgroundColor: _this.selectedColor,
					backgroundPattern: _this.selectedPattern,
					setupAssociations: true,
				}
				axios.post("/graphx/board/update", data)
					.then(response => {
						console.log(response);
						if (response.data.board.type == 'template') {
							showTopMessage('Template setting saved', 'success');
						} else {
							showTopMessage('Board setting saved', 'success');
						}

						_this.boardDetail.title = _this.title;
						_this.boardDetail.backgroundColor = _this.selectedColor;
						_this.boardDetail.backgroundPattern = _this.selectedPattern;
						_this.$emit('save-board-settings', data);
						_this.onCloseTemplate();
						initializeBoardGrid();
					})
					.catch(error => {

					});
			}
		},
		////////////EVENT HANDLER/////////////////////////
		onCloseTemplate: function () {
			this.$emit('close-popup');
		},
		onSelectColor: function (color) {
			this.selectedColor = color;
		},
		onSelectPattern: function (pattern) {
			this.selectedPattern = pattern;
		},
		closeDuplicateBoardPopup: function () {
			this.showDuplicateBoardPopup = false;
		},
		onDuplicateBoard: function () {
			this.showDuplicateBoardPopup = true;
		},
	},
});

const ADDBULKNOTES = Vue.component('add-bulk-notes', {
	name: 'add-bulk-notes',
	template: `
	<div>
		<div class="overlay" style="display: block;"></div>
		<div class="ui-dialog addbulk" style="display: block;">
			<a href="javascript:void(0);" @click="onClosePopup" title="Close" class="close"></a>
			<div class="blkut">
				<input id="title" type="text" v-model="noteTitle" placeholder="Type and Press Enter to add Note" class="inpnw" v-on:keyup.enter="onClickEnter(noteTitle)" v-focus/>
				<div class="done p-abs" v-if="noteCount > 0" @click="onClickDone">Done <span class="light">({{noteCount}})</span></div>
				<div v-if="notesList.length > 0" class="rec">
					<div class="rc" v-for="(note, index) in notesList">{{note.text}}</div>
				</div>
			</div>
		</div>
	</div>
			
	`,
	props: ["board"],
	data() {
		return {
			boardDetail: {},
			noteTitle: '',
			notesList: [],
			noteCount: 0,
		}
	},
	created() {
		this.boardDetail = this.board;
	},
	methods: {
		onClosePopup: function () {
			this.$emit('close-popup');
		},
		onClickEnter: function (title) {
			this.noteTitle = '';
			this.noteCount += 1;

			var nodeData = _.cloneDeep(vueGoInstance.noteTemplate);

			var size;
			if (nodeData.size) {
				size = go.Size.parse(nodeData.size);
				size = new go.Size(size.width / board.scale, size.height / board.scale);
			}
			else {
				size = new go.Size(200 / board.scale, 200 / board.scale);
			}
			nodeData.size = go.Size.stringify(size);

			nodeData['text'] = title;
			this.notesList.unshift(nodeData);
		},
		onClickDone: function () {

			addBulkNote(this.notesList);
			this.$emit('close-popup');
		},
	}
});

const FRAMEDIAGRAM = Vue.component('frame-diagram', {
	name: 'frame-diagram',
	template: `
        <div>
        <div :id="id" style="flex-grow: 1; height: 150px;"></div>
        </div>
        `,
	props: ["model", "id"],
	data() {
		return {

		}
	},
	mounted() {
		this.initDiagram()
		this.addNodes()
	},
	created() {
	},
	methods: {
		initDiagram: function () {
			var $gojs = go.GraphObject.make;
			var diagram = $gojs(go.Diagram, this.id, { allowVerticalScroll: false });
			diagram.nodeTemplate =
				$gojs(go.Node, "Auto",
					{
						name: "NODE",
						locationSpot: go.Spot.TopLeft,
						locationObjectName: "SHAPE",
						minSize: new go.Size(40, 40),
						selectable: false,
						selectionObjectName: "SHAPE"
					},
					// these Bindings are TwoWay because the DraggingTool and ResizingTool modify the target properties
					new go.Binding("location", "loc", go.Point.parse).makeTwoWay(go.Point.stringify),
					new go.Binding("desiredSize", "size", go.Size.parse).makeTwoWay(go.Size.stringify),
					$gojs(go.Shape,
						{ // the border
							alignment: go.Spot.TopLeft, stretch: go.GraphObject.Fill,
							name: "SHAPE", fill: "white", cursor: "pointer",
						},
						new go.Binding("figure").makeTwoWay(),
						new go.Binding("fill").makeTwoWay(),
						new go.Binding("stroke", "border").makeTwoWay(),
						new go.Binding("strokeWidth", "thickness").makeTwoWay(),
						new go.Binding("strokeDashArray", "", function (data) {
							if (!data.lineType) {
								return [];
							}
							return data.lineType == 0 ? [] : (data.lineType == 1 ? [data.thickness * 3, data.thickness * 3] : [data.thickness * 1, data.thickness * 2]);
						}),
					),
					// this Shape prevents mouse events from reaching the middle of the port
					// $gojs(go.Shape, { width: 100, height: 40, strokeWidth: 0, fill: "transparent" }),
					$gojs(go.TextBlock,
						{ margin: 1, textAlign: "center", overflow: go.TextBlock.OverflowEllipsis },
						new go.Binding("textAlign", "alignment").makeTwoWay(),
						new go.Binding("alignment", "alignment", function (value) {
							return value == "right" ? go.Spot.Right : (value === "left" ? go.Spot.Left : go.Spot.Center);
						}).makeTwoWay(),
						new go.Binding("text").makeTwoWay(),
						new go.Binding("stroke", "textColor").makeTwoWay(),
						new go.Binding("background", "textBg").makeTwoWay(),
						new go.Binding("font", "textSize", function (textSize) {
							return "" + textSize + "px sans-serif";
						})
					)
				);

			diagram.frameTemplate = $gojs(go.Group, "Vertical", { click: function (e) { console.log(e) } },
				$gojs(go.Panel, "Auto",
					$gojs(go.Shape, { fill: "transparent" }),
					$gojs(go.Placeholder,
						{ padding: 12, margin: new go.Margin(20, 0, 0, 0), alignment: go.Spot.TopLeft })
				)
			);
			diagram.linkTemplate = $gojs(go.Link,
				{
					selectable: false, resegmentable: true, selectionAdornmentTemplate: getLinkSelectionAdornmentTemplate(),
					relinkableFrom: true, relinkableTo: true, reshapable: true,
					curve: go.Link.Bezier,
					fromEndSegmentLength: 3.0,
					toEndSegmentLength: 3.0
				},
				new go.Binding("routing", "route", function (route) {
					return route == 1 ? go.Link.Orthogonal : (route == 0 ? go.Link.Normal : go.Link.Bezier);
				}),
				new go.Binding("curve", "route", function (route) {
					return route == 2 ? go.Link.Bezier : go.Link.None;
				}),
				new go.Binding("points").makeTwoWay(),

				new go.Binding("points").makeTwoWay(),
				$gojs(go.Shape,  // the link path shape
					{ isPanelMain: true, strokeWidth: 2 },
					new go.Binding("stroke", "fill").makeTwoWay(),
					new go.Binding("strokeDashArray", "", function (data) {
						return data.lineType == 0 ? [] : (data.lineType == 1 ? [data.thickness * 3, data.thickness * 3] : [data.thickness * 1, data.thickness * 2]);
					}),
					new go.Binding("strokeWidth", "thickness").makeTwoWay(),
				),
				$gojs(go.Shape,  // the arrowhead
					{
						fromArrow: "Standard", scale: 1, segmentIndex: -1, segmentOrientation: go.Link.OrientAlong, alignmentFocus: go.Spot.Left
					},
					new go.Binding("visible", "fromArrow", function (fromArrow) {
						return fromArrow == "none" ? false : true;
					}),
					new go.Binding("scale", "thickness").makeTwoWay(),
					new go.Binding("fromArrow", "fromArrow"),
					new go.Binding("stroke", "fill"),
					new go.Binding("fill", "fill")
				),
				$gojs(go.Shape,  // the arrowhead
					{ toArrow: "Standard", scale: 1, segmentOrientation: go.Link.OrientUpright },
					new go.Binding("visible", "toArrow", function (toArrow) {
						return toArrow == "none" ? false : true;
					}),
					new go.Binding("scale", "thickness").makeTwoWay(),
					new go.Binding("toArrow", "toArrow"),
					new go.Binding("stroke", "fill"),
					new go.Binding("fill", "fill")
				),
				$gojs(go.TextBlock, "", {
					editable: true,
					segmentOffset: new go.Point(0, 0)
				},
					// this is a Link label
					// new go.Binding("text", "text").makeTwoWay(),
					new go.Binding("segmentOrientation", "textPosition", function (textPosition) {
						return textPosition == 0 ? go.Link.None : go.Link.OrientUpright;
					}),
					new go.Binding("stroke", "textColor").makeTwoWay(),
					new go.Binding("font", "textSize", function (textSize) {
						return "" + textSize + "px sans-serif";
					})
				)
			);
			var nodedataArray = []
			diagram.model = new go.GraphLinksModel(nodedataArray);
			diagram.isEnabled = false;
			framesMap.set(this.id, diagram);
		},
		addNodes: function () {
			var it = board.findNodeForKey(this.id).memberParts
			while (it.next()) {
				var member = it.value.data;
				if (member.category === "Arrow") {
					framesMap.get(this.id).model.addLinkData(it.value.data)
				} else {
					framesMap.get(this.id).model.addNodeData(it.value.data);
				}
			}
		}
	}
});

const store = new Vuex.Store({
	state: {
		favoriteBoards: [],
		archivedBoards: [],
		foldersList: [],
		sharedBoards: [],
		templates: [],
		sharedTemplates: [],
		breadcrumbsArray: [],
	},
	mutations: {
		setFavoriteBoards(state, favoriteBoards) {
			state.favoriteBoards = favoriteBoards
		},
		setArchivedBoards(state, archivedBoards) {
			state.archivedBoards = archivedBoards;
		},
		setFoldersList(state, foldersList) {
			state.foldersList = foldersList;
		},
		setSharedBoards(state, sharedBoards) {
			state.sharedBoards = sharedBoards;
		},
		setTemplate(state, template) {
			state.templates = template;
		},
		setSharedTemplates(state, sharedTemplates) {
			state.sharedTemplates = sharedTemplates;
		},
		setbreadcrumbsArray(state, breadcrumbsArray) {
			state.breadcrumbsArray = breadcrumbsArray;
		},
	},
	getters: {
		getFavoriteBoardsList: (state) => () => {
			return state.favoriteBoards;
		},
		getArchivedBoards: (state) => () => {
			return state.archivedBoards;
		},
		getFoldersList: (state) => () => {
			return state.foldersList;
		},
		getSharedBoards: (state) => () => {
			return state.sharedBoards;
		},
		getTemplates: (state) => () => {
			return state.templates;
		},
		getSharedTemplates: (state) => () => {
			return state.sharedTemplates;
		},
		getbreadcrumbsArray: (state) => () => {
			return state.breadcrumbsArray;
		}
	}
})

var arrowTypeOptions = [
	{
		type: "Standard",
		reverse: "Backward"
	},
	{
		type: "Standard",
		reverse: "Standard"
	},
	{
		type: "Triangle",
		reverse: "BackwardTriangle"
	},
	{
		type: "BackwardTriangle",
		reverse: "Triangle"
	},
	{
		type: "Boomerang",
		reverse: "BackwardBoomerang"
	},
	{
		type: "BackwardBoomerang",
		reverse: "Boomerang"
	},
	{
		type: "SidewaysV",
		reverse: "BackwardV"
	},
	{
		type: "BackwardV",
		reverse: "SidewaysV"
	},
	{
		type: "OpenTriangle",
		reverse: "BackwardOpenTriangle"
	},
	{
		type: "BackwardOpenTriangle",
		reverse: "OpenTriangle"
	},
	{
		type: "OpenTriangleLine",
		reverse: "BackwardOpenTriangleLine"
	},
	{
		type: "BackwardOpenTriangleLine",
		reverse: "OpenTriangleLine"
	},
	{
		type: "OpenTriangleTop",
		reverse: "BackwardOpenTriangleTop"
	},
	{
		type: "BackwardOpenTriangleTop",
		reverse: "OpenTriangleTop"
	},

	{
		type: "OpenTriangleBottom",
		reverse: "BackwardOpenTriangleBottom"
	},
	{
		type: "BackwardOpenTriangleBottom",
		reverse: "OpenTriangleBottom"
	},
	{
		type: "HalfTriangleTop",
		reverse: "BackwardHalfTriangleTop"
	},
	{
		type: "BackwardHalfTriangleTop",
		reverse: "HalfTriangleTop"
	},
	{
		type: "HalfTriangleBottom",
		reverse: "BackwardHalfTriangleBottom"
	},
	{
		type: "BackwardHalfTriangleBottom",
		reverse: "HalfTriangleBottom"
	},
	{
		type: "ForwardSemiCircle",
		reverse: "BackwardSemiCircle"
	},
	{
		type: "BackwardSemiCircle",
		reverse: "ForwardSemiCircle"
	},
	{
		type: "Feather",
		reverse: "BackwardFeather"
	},
	{
		type: "BackwardFeather",
		reverse: "Feather"
	},
	{
		type: "DoubleFeathers",
		reverse: "Backward"
	},
	{
		type: "BackwardDoubleFeathers",
		reverse: "DoubleFeathers"
	},
	{
		type: "BackwardDoubleFeathers",
		reverse: "Backward"
	},
	{
		type: "TripleFeathers",
		reverse: "BackwardTripleFeathers"
	},
	{
		type: "BackwardTripleFeathers",
		reverse: "TripleFeathers"
	},
	{
		type: "ForwardSlash",
		reverse: "BackSlash"
	},
	{
		type: "BackSlash",
		reverse: "ForwardSlash"
	},
	{
		type: "DoubleForwardSlash",
		reverse: "DoubleBackSlash"
	},
	{
		type: "DoubleBackSlash",
		reverse: "DoubleForwardSlash"
	},
	{
		type: "TripleForwardSlash",
		reverse: "TripleBackSlash"
	},
	{
		type: "TripleBackSlash",
		reverse: "TripleForwardSlash"
	},
	{
		type: "Fork",
		reverse: "BackwardFork"
	},
	{
		type: "BackwardFork",
		reverse: "Fork"
	},
	{
		type: "LineFork",
		reverse: "BackwardLineFork"
	},
	{
		type: "BackwardLineFork",
		reverse: "LineFork"
	},
	{
		type: "CircleFork",
		reverse: "BackwardCircleFork"
	},
	{
		type: "BackwardCircleFork",
		reverse: "CircleFork"
	},
	{
		type: "CircleLineFork",
		reverse: "BackwardCircleLineFork"
	},
	{
		type: "BackwardCircleLineFork",
		reverse: "CircleLineFork"
	}
	,
	{
		type: "Circle",
	},
	{
		type: "Block"
	},
	{
		type: "StretchedDiamond"
	},
	{
		type: "Diamond"
	},
	{
		type: "Chevron"
	},
	{
		type: "StretchedChevron"
	},
	{
		type: "NormalArrow"
	},
	{
		type: "TailedNormalArrow"
	},
	{
		type: "DoubleTriangle"
	},
	{
		type: "BigEndArrow"
	},
	{
		type: "ConcaveTailArrow"
	},
	{
		type: "RoundedTriangle"
	},
	{
		type: "SimpleArrow"
	},
	{
		type: "AccelerationArrow"
	},
	{
		type: "BoxArrow"
	},
	{
		type: "TriangleLine"
	},
	{
		type: "CircleEndedArrow"
	},
	{
		type: "DynamicWidthArrow"
	},
	{
		type: "EquilibriumArrow"
	},
	{
		type: "FastForward"
	},
	{
		type: "Kite"
	},
	{
		type: "HalfArrowTop"
	},
	{
		type: "HalfArrowBottom"
	},
	{
		type: "OpposingDirectionDoubleArrow"
	},
	{
		type: "PartialDoubleTriangle"
	},
	{
		type: "LineCircle"
	},
	{
		type: "DoubleLineCircle"
	},
	{
		type: "TripleLineCircle"
	},
	{
		type: "CircleLine"
	},
	{
		type: "DiamondCircle"
	},
	{
		type: "PlusCircle"
	},
	{
		type: "OpenRightTriangleTop"
	},
	{
		type: "OpenRightTriangleBottom"
	},
	{
		type: "Line"
	},
	{
		type: "DoubleLine"
	},
	{
		type: "TripleLine"
	},
	{
		type: "PentagonArrow"
	}
]
