$( document ).ready(function(){
	var waitForAxios = setInterval(function() {				             
		if(typeof axios != "undefined"){
			clearInterval(waitForAxios);
			interceptAxioCalls();
		}
	}, 50);
})
function showLeftHeader(){
    $("#LFT-HEADER").show()
}
function hideLeftHeader(){
    $("#LFT-HEADER").hide()
}
function _arrayBufferToBase64( buffer ) {
    var binary = '';
    var bytes = new Uint8Array( buffer );
    var len = bytes.byteLength;
    for (var i = 0; i < len; i++) {
        binary += String.fromCharCode( bytes[ i ] );
    }
    return window.btoa( binary );
}
function interceptAxioCalls(){
	/****************************** interceptors for axio request *********************/
	axios.defaults.headers.common = {
		'X-Requested-With': 'XMLHttpRequest',
		'X-CSRF-TOKEN': $('meta[name="_csrf"]').attr("content"),
	}
	
	axios.interceptors.request.use((config) => {
		return config;
	},
	(error) => {
			console.log('request error . . . . ..');
			return Promise.reject(error);
		}
	);
	axios.interceptors.response.use((response) => {
		return response;
	},
	(error) => {
			if(403 === error.response.status){
				window.location.reload();
			}
			console.log('response error . . . . ..');
			return Promise.reject(error);
		}
	);
	/*************************** interceptors for axio request  ************************/
}