
$gojs = go.GraphObject.make;
synId = getNewUUID();

$( document ).ready(function(){
//document.addEventListener("DOMContentLoaded", function(event) {
	
    app = new Vue({
        el: '#app',
        data: {
            boardId: "",
			companyId: "",
			userEmail: "",
			tenant: "",
			userName: '',
            initialised: false,
            readonly:"",
            edit:"",
 			publicShareToken: "" ,
            initialised: false,
			registerAnonymousUser: false,
			showFieldRed: false,
			matchFound: false,
			showEmailFieldRed: false,
            anonymousUser: {},
			loggedInUserWorkSpacesMap: {},
			currentUser: undefined,
			currentUserAccessRoles: {},
			isLoggedIn : false
        },
        created() {
			this.getLoggedInUser();
          //  this.getLoggedInUser();
			//this.initialised = true;
			//this.registerAnonymousUser = false;
        },
        mounted() {
           // this.loadData();
        },
        components: {
            'detail': BOARDDETAIL
        },
        methods: {
			getLoggedInUser2: function () {
				var _this=this;
				 var token = _this.getUrlParameter("token");
				axios.get('/graphx/public_share/profile?token='+token)
				.then(response => {
					if(response.data.user) {
						_this.currentUser = response.data.user;
						_this.currentUserAccessRoles = response.data.userAccessRoles;
						
						_.each(_this.currentUserAccessRoles, role=> {
							_this.loggedInUserWorkSpacesMap[role.workSpace.id]=true;
						});
						
						_this.isLoggedIn = true;
						_this.loadData();
						
					} 
					if(response.data.user == undefined) {
						var anonymousUser = localStorage.getItem("anonymousUser");
						anonymousUser = JSON.parse(anonymousUser);
						if(!_.isEmpty(anonymousUser)) {
							if(!_.isEmpty(anonymousUser.email) && !_.isEmpty(anonymousUser.name)) {
								_this.userEmail = anonymousUser.email;
								_this.userName = anonymousUser.name;
							}
						}
						_this.currentUser = 'not logged in'
						_this.isLoggedIn = false;
						_this.loadData();
					}
				 	
				 })
				 .catch(error => {
				 });
			},
			getLoggedInUser: function () {
				var _this = this;
				var host 	 = window.location.host;
				var protocol = window.location.protocol;
				axios.get("/plan/userInfo?host="+ host + "&protocol="+protocol )
					.then(response => {
						if(typeof response.data === 'object') {
							_this.currentUser = response.data;
						}
						if (_this.currentUser) {
							let companyId = _this.currentUser.loggedInUserCompany.company.id;
							_.each(_this.currentUser.accessRoles, accessRole => {
								_this.loggedInUserWorkSpacesMap[accessRole.workSpace.id] = true;
							});
							_this.isLoggedIn = true;
							_this.loadData();
						}

						if (_this.currentUser == undefined) {
							this.checkAnonymousUser();
						}

					})
				 .catch(error => {
					 this.checkAnonymousUser();
					_this.registerAnonymousUser = true;
				 });
			},
            getUrlParameter: function(sParam) {
                var sPageURL = decodeURIComponent(window.location.search.substring(1)),
                    sURLVariables = sPageURL.split('&'),
                    sParameterName,
                    i;

                for (i = 0; i < sURLVariables.length; i++) {
                    sParameterName = sURLVariables[i].split('=');

                    if (sParameterName[0] === sParam) {
                        return sParameterName[1] === undefined ? true : sParameterName[1];
                    }
                }
            },
            loadData: function () {

                var token = this.getUrlParameter("token");
                var _this = this;
                var requestBody = { token: token };

                axios.post('/graphx/public_share/decryptShareUrl?token='+token, requestBody)
                    .then(response => {
                    //    if (!_.isEmpty(response.data)) {
                            if (response.data.success) {
                                
                                if(response.data.board) {
									_this.boardId = response.data.board.id;
									_this.companyId = response.data.companyId;
									_this.tenant = response.data.tenant;

								if(response.data.board.workSpaces && response.data.board.workSpaces.length > 0) {
									_.each(response.data.board.workSpaces, workspace=> {
										// if(_this.loggedInUserWorkSpacesMap[workspace.id]) {
											//_this.populateBoardModel(true);
											_this.initialised = true;
											_this.registerAnonymousUser = false;
											// Preserve context parameters from the original share URL
											var originalUrl = window.location.href;
											var contextParams = '';
											
											// Extract parameters from the original share URL
											if (originalUrl.includes('?')) {
												var urlParams = new URLSearchParams(originalUrl.split('?')[1]);
												// Remove the token parameter as it will be replaced with accessToken
												urlParams.delete('token');
												contextParams = urlParams.toString();
											}
											
											var redirectUrl = '/collab#/detail/' + _this.boardId + '?accessToken=' + token;
											if (contextParams) {
												redirectUrl += '&' + contextParams;
											}
											if(this.isLoggedIn) {
												window.location = redirectUrl;
											}
										// }
									})
								}
								// else if (response.data.board.solutionBoard  && _this.isLoggedIn){
								// 	_this.initialised = true;
								// 	_this.registerAnonymousUser = false;
								// 	window.location = '/collab#' + '/detail/' + _this.boardId +'?token='+token;
								// }
								else {
									// Board has no workspaces, proceed with direct access
									_this.initialised = true;
									_this.registerAnonymousUser = false;
									// Preserve context parameters from the original share URL
									var originalUrl = window.location.href;
									var contextParams = '';
									
									// Extract parameters from the original share URL
									if (originalUrl.includes('?')) {
										var urlParams = new URLSearchParams(originalUrl.split('?')[1]);
										// Remove the token parameter as it will be replaced
										urlParams.delete('token');
										contextParams = urlParams.toString();
									}
									
									var redirectUrl = '/collab#/detail/' + _this.boardId + '?token=' + token;
									if (contextParams) {
										redirectUrl += '&' + contextParams;
									}
									if(this.isLoggedIn) {
										window.location = redirectUrl;
									}
								}
                                    
								if(_.isEmpty(_this.userEmail) && _.isEmpty(_this.userName) && !_this.isLoggedIn){
									_this.registerAnonymousUser = true;
									_this.initialised = false;
								 }
								else if (_this.userEmail && _this.userName){
									this.anonymousUser = {'name': this.userName, 'email':this.userEmail, 'companyId':this.companyId};
									_this.initialised = true;
									_this.registerAnonymousUser = false;
								 }
									
									/*response.data.board.collaborators.forEach(collaborator => {
										if(collaborator.token == token) {
											if(!collaborator.externalUser.fullName) {
												_this.userEmail = collaborator.externalUser.email
												this.registerAnonymousUser = true;
											} else {
												_this.userEmail = collaborator.externalUser.email;
												_this.userName = collaborator.externalUser.fullName;
												_this.companyId = collaborator.companyId;
												_this.initialised = true;
												_this.anonymousUser = {'name': _this.userName, 'email':_this.userEmail, 'companyId':_this.companyId};	
											}
											
										}
									});*/
                            	}
                        	}

						//}

                    })
                    .catch(error => {
						// todo
                    });
            },
			checkAnonymousUser: function(){
				let anonymousUser = localStorage.getItem("anonymousUser");
				anonymousUser = JSON.parse(anonymousUser);
				if (!_.isEmpty(anonymousUser)) {
					if (!_.isEmpty(anonymousUser.email) && !_.isEmpty(anonymousUser.name)) {
						this.userEmail = anonymousUser.email;
						this.userName = anonymousUser.name;
					}
				}
				this.currentUser = 'not logged in'
				this.isLoggedIn = false;
				this.loadData();
			},
			saveAnonymousUser: function () {
				this.checkValidation();
				if (this.userEmail) {
					this.matchFound = this.validateEmail(this.userEmail);
					if(!this.matchFound) {
						showTopMessage('Invalid email')
					} else {
						//this.showEmailFieldRed = false;
					}
				}
				
				if(this.matchFound){
					this.anonymousUser = {'name': this.userName, 'email':this.userEmail, 'companyId':this.companyId};
					
					localStorage.setItem("anonymousUser", JSON.stringify(this.anonymousUser));
					this.loadData();
				}
			},
			checkValidation: function () {
				if (this.userName == '') {
					this.showFieldRed = true;
				} 
				else {
					this.showFieldRed = false;
				}
				
				if(this.userEmail == '') {
					this.showEmailFieldRed = true;
				} else {
					this.showEmailFieldRed = false;
				}
			},
			validateEmail:function (inputText)
			{
				var mailformat = /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/;
				if(inputText.match(mailformat))
				{
					return true;
				}
				else
				{	
					return false;
				}
			}

        }
    });
})