"use strict";


function NotePanelLayout() {
  go.PanelLayout.call(this);
  this.name = "NotePanelLayout";
}
go.Diagram.inherit(NotePanelLayout, go.PanelLayout);
go.Panel.definePanelLayout('Note', new NotePanelLayout());

NotePanelLayout.prototype.measure = function (panel, width, height, elements, union, minw, minh) {

  if (width == Infinity) width = 0;
  if (height == Infinity) height = 0;

  var maxWidth = 0;
  var totalHeight = 0;

  for (var i = 0; i < elements.length; i++) {
    var elem = elements[i];
    this.measureElement(elem, width , height , minw, minh);
    totalHeight += elem.measuredBounds.height;
    maxWidth = Math.max(maxWidth, elem.measuredBounds.width);
  }
  union.width  = maxWidth ;
  union.height = totalHeight;
}

NotePanelLayout.prototype.arrange = function (panel, elements, union) {

  var panelBound = panel.panel.actualBounds.copy();
  if (panelBound.width == 0 && panel.part && panel.part.data && panel.part.data.size) {
    var size = go.Size.parse(panel.part.data.size);
    panelBound.size = size;
  }

  var elem1 = elements[0];
  var elem2 = elements[1];
  
  var margin = 0;
  var bound2 = elem2.measuredBounds;
  
  // var totalWidth  = (panelBound.width - (margin * 2)) / panel.part.scale;
  var totalWidth  = (panelBound.width) / panel.part.scale;
  var totalHeight = (panelBound.height) / panel.part.scale;
  
  if (totalWidth < 0) {
    totalWidth = 0;
  }
  if (totalHeight < 0) {
    totalHeight = 0;
  }
  var textBlockActualHeight = totalHeight - bound2.height;
  var delta = textBlockActualHeight - elem1.measuredBounds.height;
  
  this.arrangeElement(elem2, margin, textBlockActualHeight, totalWidth, bound2.height);
  this.arrangeElement(elem1, margin, margin  + delta * 0.5, totalWidth, textBlockActualHeight);
}