"use strict";

function GridFlowPanelLayout() {
  go.PanelLayout.call(this);
  this.name = "GridFlow";
}
go.Diagram.inherit(GridFlowPanelLayout, go.PanelLayout);

GridFlowPanelLayout.prototype.measure = function (panel, width, height, elements, union, minw, minh) {
  
  var panelBound = panel.part.getDocumentBounds();

  var spaceBetweenRows = 5;
  var rowWidth = 0;
  var _height   = 0; 

  for (var i = 0; i < elements.length; i++) {
    var elem = elements[i];
    this.measureElement(elem, Infinity, height, minw, minh);
    if (i == 0) {
      _height = elem.height;
    }
    if (rowWidth + (elem.width + spaceBetweenRows) > width) {
      _height += (elem.height + spaceBetweenRows);
      rowWidth = 0;
    }
    else {
      rowWidth += (elem.width + spaceBetweenRows + spaceBetweenRows);
    }
  }
  union.width  = width;
  union.height = _height;
}

GridFlowPanelLayout.prototype.arrange = function (panel, elements, union) {


  var panelBound = panel.part.getDocumentBounds();

  var spaceBetweenRows = 5;

  var y = 0;
  var x = 0; 

  for (var i = 0; i < elements.length; i++) {
    var elem = elements[i];

    if (x + (elem.width + spaceBetweenRows) > union.width) {
      y += (elem.height + spaceBetweenRows);
      x = 0;
    }
    
    this.arrangeElement(elem, x, y, elem.width, elem.height);
    x += (elem.width + spaceBetweenRows);
  }
}