class FrameLayout extends go.GridLayout {

	constructor(init) {
		super();
		if (init)
			Object.assign(this, init);
	}

	doLayout(group) {
		var diagram = this.diagram;

		if (group.memberParts && group.memberParts.count && group.data && group.data.layout == "layout") {

			var groupBound = group.getDocumentBounds();
			var partWidth = 0;
			var columns = 0;

			var canReduceWidth = false;
			var canReduceHeight = false;

			if (group.data.columns == undefined) {
				group.data.columns = "Auto";
			}
			if (group.data.rows == undefined) {
				group.data.rows = "Auto";
			}

			if (group.data.columns === "Auto" && group.data.rows === "Auto") {
				columns = "Auto";
			}
			else if (group.data.columns !== "Auto") {
				columns = group.data.columns;
				// canReduceWidth = true;
			}
			else if (group.data.rows !== "Auto") {
				columns = Math.ceil(group.memberParts.count / group.data.rows);
				// canReduceHeight = true;
			}

			var wrappingColumn = 0;
			if (columns === "Auto") {
				group.memberParts.each(function(part) {
					if (!(part instanceof go.Link)) {
						if (partWidth < groupBound.width) {
							var bound = part.getDocumentBounds();
							if (bound.width != Infinity) {
								partWidth += bound.width;
							}
						}
						if (partWidth < groupBound.width) {
							wrappingColumn++;
						}
					}
				});
			} else {
				wrappingColumn = columns;
			}

			this.wrappingColumn = wrappingColumn;
		}

		var allNodes = new go.List();
		group.memberParts.each(function(part) {
			if (!(part instanceof go.Link)) {
				allNodes.add(part);
			}
			// if (part instanceof go.Group) {
			//   part.layout = new go.Layout();
			// }
		});

		go.GridLayout.prototype.doLayout.call(this, group);

		diagram.startTransaction("FrameLayout");

		if (group.memberParts && group.memberParts.count && group.data && group.data.layout == "layout") {

			const membnds = group.diagram.computePartsBounds(allNodes);

			var xDelta = 0;
			var yDelta = 0;

			var margin = 10;

			xDelta = membnds.x - group.position.x + margin;
			yDelta = membnds.y - group.position.y + margin;

			var groupWidth;
			var groupHeight;

			if (canReduceWidth) {
				groupWidth = membnds.size.width + xDelta;
			}
			else {
				groupWidth = Math.max(membnds.size.width + xDelta, group.width);
			}
			if (canReduceHeight) {
				groupHeight = membnds.size.height + yDelta;
			}
			else {
				groupHeight = Math.max(membnds.size.height + yDelta, group.height);
			}

			group.width = groupWidth;
			group.height = groupHeight;
		}

		diagram.commitTransaction("FrameLayout");
	}


	initialOrigin(origin) {
		const group = this.group;
		if (group) {
			const shape = group.findObject("Placeholder");
			if (shape) {
				return shape.getDocumentPoint(go.Spot.TopLeft).offset(10, 10);
			}
		}
		return super.initialOrigin(origin);
	}
}