"use strict";


function CustomViewboxPanelLayout() {
  go.PanelLayout.call(this);
  this.name = "CustomViewboxPanelLayout";
}
go.Diagram.inherit(CustomViewboxPanelLayout, go.PanelLayout);

CustomViewboxPanelLayout.prototype.measure = function (panel, width, height, elements, union, minw, minh) {
  // go.Panel.Viewbox.prototype.measure.call(panel, width, height, elements, union, minw, minh);

  if (width == Infinity) width = 0;
  if (height == Infinity) height = 0;

  for (var i = 0; i < elements.length; i++) {
    var elem = elements[i];
    this.measureElement(elem, width, height, minw, minh);
  }
  union.width  = width;
  union.height = height;
}

CustomViewboxPanelLayout.prototype.arrange = function (panel, elements, union) {

  console.log("CustomViewboxPanelLayout");

  var textBlock = elements[0];

  var containerBounds = panel.getDocumentBounds();
  var textBounds      = textBlock.getDocumentBounds();

  var x = (containerBounds.width * 0.5) - (textBounds.width * 0.5);
  var y = (containerBounds.height * 0.5) - (textBounds.height * 0.5);

  console.log("x1 :" + containerBounds.width + " ,y1 :" + containerBounds.height + ": x2 :" + textBounds.width + " ,y2 :" + textBounds.height + ": x3 :" + x + " ,y3 :" + y);
  textBlock.position = new go.Point(x, y);
  this.arrangeElement(textBlock, x, y, textBounds.width, textBounds.height);
}