
$gojs = go.GraphObject.make;

var nodeHoverAdornment = $gojs(go.Adornment, "Auto",
  $gojs(go.Shape, "Rectangle",
    { fill: "rgba(0,0,0,0.2)", stroke: "dodgerblue", strokeWidth: 2 }),
  $gojs(go.Placeholder),
);

function initialiseMouseMoveListenerForLinkingTool() {

  if (board === null) return;

  board.toolManager.standardMouseOver = function () {
    
    go.ToolManager.prototype.standardMouseOver.call(this);

    if (board.toolManager.linkingTool && board.toolManager.linkingTool.isEnabled) {
      
    }
    else {
      board.toolManager.linkingTool.clearHighlightedNode();
      return;
    }
    var pointerPosition = board.lastInput.documentPoint.copy();
    var targetNode = board.findPartAt(pointerPosition, false);

    if (targetNode && targetNode.data && (targetNode.data.linkable || targetNode.data.category === "PICTURE")) {
      
      if (board.toolManager.linkingTool.highlightedNode !== null) {
        if (targetNode != nodeHoverAdornment.adornedObject) {
          board.toolManager.linkingTool.highlightedNode.removeAdornment("LinkingToolHover");
          board.toolManager.linkingTool.highlightedNode = null;
        }
      }

      if (board.toolManager.linkingTool.highlightedNode == null) {
        board.commit(function(){
          nodeHoverAdornment.adornedObject = targetNode;
          targetNode.addAdornment("LinkingToolHover", nodeHoverAdornment);
        },null);
        board.toolManager.linkingTool.highlightedNode = targetNode;
      }
      else {
        
      }
    }else {
      board.toolManager.linkingTool.clearHighlightedNode();
    }
  };
}


class CustomLinkingTool extends go.LinkingTool {

	constructor(init) {
		super();

		this.name = "Linking";
		this._highlightedNode = null;

		if (init)
			Object.assign(this, init);
	}


	doActivate() {
		if (this.temporaryToNode) {
			var nodeTemplate = $gojs(go.Node, "Auto",
				{
					layerName: "Tool"
				},
				$gojs(go.Shape, { fill: "rgba(0,0,0,0.15)", stroke: "dodgerblue", strokeWidth: 1 })

			);

			// var pointerPosition = board.lastInput.documentPoint.copy();
			// pointerPosition.u = true;
			// pointerPosition.x = NaN;
			// pointerPosition.y = NaN;
			//this.temporaryToNode.location = pointerPosition;
			this.temporaryToNode = nodeTemplate;
		}
		super.doActivate();
	};


	doMouseMove() {
		var diagram = this.diagram;
		if (diagram === null) return;
		
		super.doMouseMove();

		var pointerPosition = diagram.lastInput.documentPoint.copy();
		var targetNode = diagram.findPartAt(pointerPosition, false);

		if (targetNode && targetNode.data) {

		}
	}

	doMouseUp() {
		var diagram = this.diagram;
		if (diagram === null) return;

		super.doMouseUp();

		this.clearHighlightedNode();
	}

	doDeactivate() {
		super.doDeactivate();


		if (vueGoInstance.currentTempNodeKey) {
			const tempNode = board.findNodeForKey(vueGoInstance.currentTempNodeKey);
			if (tempNode) {
				board.commit(() => {
					board.model.removeNodeData(tempNode.data);
				}, null);
			}
			vueGoInstance.currentTempNodeKey = null; // clear it
		}

		if (board.selection) {
			board.selection.each(function(link) {
				if (link.type && link.type.name === "Link" && link.toNode == null && link.fromNode !== null) {
					vueGoInstance.showLinkDropPopup(link);
				}
			});
		}
		board.toolManager.linkingTool.clearHighlightedNode();
	}
	
	clearHighlightedNode() {
		if (board.toolManager.linkingTool.highlightedNode != null) {
			board.commit(function() {
				board.toolManager.linkingTool.highlightedNode.removeAdornment("LinkingToolHover");
			}, null);
			board.toolManager.linkingTool.highlightedNode = null;
		}
	}
	
	get highlightedNode () {
		return this._highlightedNode;
	}
	
	set highlightedNode (val) {
		this._highlightedNode = val;
	}
	
}