
/***********************************************************/
/************** central utilities for watcher **************/
/************** history and conversation      **************/
/***********************************************************/

var EMOJI_SYMBOLS = [
'🎯',
'🍾',
'💯',
'👍',
'🥳',
'👎',
'🤔',
'😞'
];
var EMOJI_TO_CODE = {}, CODE_TO_EMOJI = {};
for(let i = 0 ; i < EMOJI_SYMBOLS.length ; i++){
    EMOJI_TO_CODE[EMOJI_SYMBOLS[i]] = i+'';
    CODE_TO_EMOJI[i+''] = EMOJI_SYMBOLS[i];
}
function downloadDescription (event) {	
	var descriptionDomId = "description-download-" + event.target.dataset.descriptionId;
	var descriptionHTML	 = document.getElementById(descriptionDomId).innerHTML;
	var request 	 = {}
	request["descriptionHTML"] = descriptionHTML;
	axios.post('external-entitites/export-description', request)
	.then(response=>{
		if(response.data){
			downloadFromPath(response.data);
		}
	}).catch(error=>{
		console.error("Description download error", error);
	});
}

function editorHtmlToText (html, users, items) {
	var str1 		= $(html);
	var userTags 	= str1.find(".mention");
	mentions 		= [];
	itemMentions 	= [];
	if (!_.isEmpty(userTags)) {

		for (var i = 0; i < userTags.length; i++) {
			var tag = userTags[i];
			if(tag.dataset.isUser === 'true') {
				var userId = tag.dataset.mentionId;
				var user = _.find(users, { userName: userId });
				if(user) {
					var metionStr = "~~[~" + user.fullName + "~]  [-" + user.userName + "-]~~";
					html = html.replace(tag.outerHTML, metionStr);
					mentions.push(user.userName);
				}
			}
			else if(tag.dataset.isUser === 'false') {
				var itemId = tag.dataset.mentionId;
				var item = _.find(items, { id: itemId });
				if(item)
					itemMentions.push(item.id);				
			}
		}
	}
	return {text : html, mentions : mentions, itemMentions: itemMentions};
}

function formatConversation (text) {
	/* need to imporove this logic*/
	var regexp = /\~~\[~(.*?)\~]/;
	var txt = '';
	while(txt != text) {
		txt = text;
		//text = text.replace(regexp, '<b style="color: #43d5f9" >$1</b>');
		text = text.replace(regexp, '<b class="taguser" >$1</b>');
		text = text.replace(/\n/g, "<br />");
	}

	// ----------------------
	regexp = /\[-(.*?)\]~~/;
	txt = '';
	while(txt != text) {
		txt = text;
		text = text.replace(regexp, '');
	}

	// ----------------------
	return text;
}
function sendEmailNotification (eventType,emailsList,content){
    var _this                   = this;
    var requestBody             = {};
    requestBody["emailType"]    = eventType
    requestBody["emailList"]    = emailsList
    requestBody["content"]   	= content
    axios.post('external-entitites/send-email-notification',requestBody)
    .then(response => {
        if(response.data){
            console.log(response.data)
        }
    })
}
function getFormattedDateForChat (date) {
	var dateFinal = '';
	var mydate = new Date(date);
	var monthFromDate = mydate.getMonth();
	const monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
		];
	dateFinal = mydate.getDate() + ' ' + monthNames[monthFromDate] + ' at '
	var hours = mydate.getHours();
	var minutes = mydate.getMinutes();
	var ampm = hours >= 12 ? 'PM' : 'AM';
	hours = hours % 12;
	hours = hours ? hours : 12; // the hour '0' should be '12'
	minutes = minutes < 10 ? '0'+minutes : minutes;

	var time = hours + ':' + minutes + ' ' + ampm;
	dateFinal += time;
	return dateFinal;
}
function texToTributeHtml (text,users) {
	var lines = text.split("\n");
	
	var html = "";
	_.each(lines,(line,lineIndex)=>{
		if (lineIndex>0) {
			html += "<div>";
		}
		var lineSegments = line.split("~~");
		_.each(lineSegments,segment=>{
			if (segment.endsWith("-]")) {
				
				var components = segment.split("]  [-");
				var userId = components[1];
				userId = userId.replace ("-]","");
				
				var user = _.find(users,{userName:userId});
				html +=('<span class="mention" data-mention="'+user.fullName+'" data-user-id="'+user.userName+'">'+user.fullName+'</span>&nbsp;');
				
			}else {
				html += segment;
			}
		});
		if (lineIndex>0) {
			html += "</div>";
		}
	});
	return html;	
}
function customItemRenderer( item ) {
    const itemElement = document.createElement( 'div' );
    const userNameElement = document.createElement( 'span' );

    itemElement.classList.add( 'mention_avatar' );
    var avatar = getUserIcon(item);
    itemElement.innerHTML +=avatar
    userNameElement.classList.add( 'mention__item__user-name' );
    userNameElement.textContent = item.id;
    itemElement.appendChild( userNameElement );
    return itemElement;
}
function getUserDetailsToolTip(elem){
	
	return "<div class='b'> <b>"+(elem.dataset.mentionId)+"</b></div>";
}
function openFeatureDetailView(event) {
	if (event && event.target.dataset.mentionId != "undefined" && event.target.dataset.isUser === "false") {
		sosVU.$options.itemId = event.target.dataset.mentionId
		if(sosVU.checkIftemPresent(event.target.dataset.mentionId)){
			sosVU.showFeatureDetailView = true;
			sosVU.activeEditor = '';
			if(sosVU.editPopup.show) {
				sosVU.editPopup.show = false;
			}			
		}else{
			showTopMessage("Item is not Present on board", 'warning');
		}
	}
}

function setTaggedItemDetailClick(_ckdiv){
	if(_ckdiv.children.length > 0){
		if(_ckdiv.children[0].dataset.hover == undefined){
			//_ckdiv.removeAttribute('onmouseenter');
			$(_ckdiv).find('[data-mention-id][data-is-user="false"]').click(function(evt){
				openFeatureDetailView(evt);
				evt.stopPropagation();
				evt.preventDefault();
			});
			_ckdiv.children[0].dataset.hover = true;
		}else{
			
		}
	}
}

function mentionCustomization(editor) {
	// The upcast converter will convert <a class="mention" href="" data-mention-id="">
	// elements to the model 'mention' attribute.
	editor.conversion.for('upcast').elementToAttribute({
		view: {
			name: 'span',
			key: 'data-mention',
			classes: 'mention',
			attributes: {
				'data-mention-id'	: true,
				'data-is-user' 		: true,
				'data-mention' 		: true,
				'title'				: true,
				'onclick'			: true
			}
		},
		model: {
			key: 'mention',
			value: viewItem => {
				// The mention feature expects that the mention attribute value
				// in the model is a plain object with a set of additional attributes.
				// In order to create a proper object, use the toMentionAttribute helper method:
				const mentionAttribute = editor.plugins.get('Mention').toMentionAttribute(viewItem, {
					// Add any other properties that you need.
//					itemURL: viewItem.getAttribute( 'href' ),
					userName: viewItem.getAttribute('data-mention-id'),
					isUser	: viewItem.getAttribute('data-is-user'),
					title	: viewItem.getAttribute('title')
				});
				return mentionAttribute;
			}
		},
		converterPriority: 'high'
	});

	// Downcast the model 'mention' text attribute to a view <a> element.
	editor.conversion.for('downcast').attributeToElement({
		model: 'mention',
		view: (modelAttributeValue, { writer }) => {
			// Do not convert empty attributes (lack of value means no mention).
			if (!modelAttributeValue) {
				return;
			}

			return writer.createAttributeElement('span', {
                class : modelAttributeValue.userName ? 'mention ck-user' : 'mention ck-item',				
				'data-mention'		: modelAttributeValue.id,
				'data-mention-id'	: modelAttributeValue.userName ? modelAttributeValue.userName: modelAttributeValue.itemId,
				'data-is-user' 		: modelAttributeValue.userType ? true : false,
				'title'				: (modelAttributeValue.isUser && modelAttributeValue.isUser == "false") || (modelAttributeValue.itemId) ? modelAttributeValue.title : modelAttributeValue.userType ? modelAttributeValue.userName+'-'+modelAttributeValue.userType :modelAttributeValue.title,
			}, {
				// Make mention attribute to be wrapped by other attribute elements.
				priority: 20,
				// Prevent merging mentions together.
				id: modelAttributeValue.uid
			});
			
		},
		converterPriority: 'high'
	});
	
}
/*******************************************************/
var CONVERSATION_EDITOR_CONFIG = {
		// The configuration of the editor.
		extraPlugins: [mentionCustomization],
		toolbar: ["undo", "redo", '|', "heading", "bold", "italic", '|', "blockQuote", "link", "numberedList", "bulletedList", 'fontBackgroundColor'],
		mention: {
			feeds: [
				{
					marker: '@',
					feed: [],
					itemRenderer : customItemRenderer
				}
				],
		},
		isCurrentUserAdmin: false,
};

const CONVERSATIONS_GENERIC = Vue.component('' +
	'conversations-generic', {
	name: 'conversations-generic',
	props: {
		users: {
			type: Array,
			default: () => { return [] }
		},
		disabled: {
			type: Boolean,
			default: () => { return false }
		},
		isEnable: {
			type: Boolean,
			default: () => { return false }
		},
		usersFetched: {
			type: Boolean,
			default: () => { return false }
		}
	},
	template: `
		<div class="cnvrstn prow">
		   <div v-if="chatBoxEnable && editorConfigComplete" class="prow txtar">
		      <div class="pic">
		         <div v-html="getUserImage()"></div>
		      </div>
		      <ckeditor v-if="showEditor"
		         :config="conversationEditorConfig" :editor="editor"
		         v-model="conversationTextArea"></ckeditor>
			  <div v-else @click="showEditor = true;" class="inptxt"> Add a comment... </div>
		      <div class="menu-container1" ref="mentionListContainer"></div>		      
		      <div class="btnout DFCB mt-15">
		      	<div v-if="showEditor" class="DAJ">
			      	<a href="javascript:void(0);" v-if="isEditConversation" @click="onUpdateConversation()" :class="[conversationText ? 'btn button btn-blue mr-10' : 'btn button btn-blue mr-10']">Update</a>
			      	<button v-if="!isEditConversation" @click="onNewConversation()" :class="[conversationText ? 'btn btn-blue e mr-10' : 'btn btn-blue f mr-10']" :disabled="disabled">Send</button>
			      	<a @click="showEditor = false;" href="javascript:void(0);" class="cncl FR cncl mt-0">Cancel</a>
		      	</div>
		      	<div class="cmts spctg"> Comments <span>{{ conversations.length }}</span></div>
		      </div>
		   </div>
		   <div v-else class="edtrout ck-content" @click="chatBoxEnable=true;">
		   </div>
		   <ul class="table chat prow">
		      <li v-if="!_.isEmpty(conversations)" v-for="(conv, index) in conversations" :class="[loggedInUser.id == conv.user.id ? 'mine' : '', conv.first ? 'first' : '', conv.last ? 'last' : '']">
		         <div class="pic">
		            <div v-html="getUserImage(conv.user)"></div>
		         </div>
		         <div class="DFA ml-55 mb-10">
		         <div class="name font-sbold mr-10">{{ conv.user.fullName }}</div>
		         <div class="date">{{ getFormattedDate(conv.createdOn) }}</div>
		         </div>
		         <div class="msg">
		            
		            <div class="txt">
		               <span class="in" v-html="formatConversation(conv.text)"></span> <span v-if="conv.updatedOn" title="Updated" class="ti-pencil edtd"></span>
		            </div>
		            
		            <div class="r-icons">
		               <a v-if="!disabled && (loggedInUser.loggedInUserCompany.isAdmin || loggedInUser.id == conv.user.id)" href="javascript:void(0);" @click="onEditConversation(conv)" class="ico ti-pencil" title="Edit"></a> 
		               <a v-if="!disabled && (loggedInUser.loggedInUserCompany.isAdmin || loggedInUser.id == conv.user.id)" href="javascript:void(0);" @click="onDeleteConversationAction(conv)" class="ico ti-trash" title="Delete"></a>
		            </div>
		         </div>
		      </li>
		   </ul>
		</div>
	`,
	// :class="{'mine':conv.mine&&!conv.first&&!conv.last,'':!conv.mine&&!conv.first&&!conv.last,'mine first':conv.mine&&conv.first&&!conv.last,'mine last':conv.mine&&!conv.first&&conv.last,'first':!conv.mine&&conv.first&&!conv.last,'last':!conv.mine&&!conv.first&&conv.last,'first last':!conv.mine&&conv.first&&conv.last,'mine first last':conv.mine&&conv.first&&conv.last,}">
	watch: {
		'users': {
			handler(val, oldVal) {
				var _this = this;
				if(_this.usersFetched) {
					if (!_.isEmpty(_this.users) && _.isEmpty(_this.conversationEditorConfig.mention.feeds[0].feed)) {
						_this.userTagOptions.values = _this.users;
						_.each(_this.users, usr => {
							
							var newAddedUser = {id:('@'+usr.fullName) ,userName: usr.userName,firstName: usr.firstName,lastName: usr.lastName,backgroundColor: usr.backgroundColor,picturePath: usr.picturePath,fullName : usr.fullName, userType : usr.userType };
							_this.usersForCkEditor.push(newAddedUser);
							//values.push({key:usr.fullName,value:usr.userName});
							_this.conversationEditorConfig.mention.feeds[0].feed.push(newAddedUser);
						});
						/*if(!_.isEmpty(_this.conversationEditorConfig.mention.feeds[0].feed)) {
							_this.editorConfigComplete = true;
						}*/
					}
					_this.editorConfigComplete = true;					
				}
			},
			immediate: true
		}
	},
	data: function () {
		return {
			conversation			: {},
			conversations			: [],
			isEditConversation		: false,
			conversationText		: "",
			userTagOptions			: {
				trigger				: "@",
				positionMenu		: false,
				selectClass			: 'user-tag',
				menuContainer		: document.querySelector(".menu-container1"),
				selectTemplate		: function (item) {
					return '<span data-userId=' + item.original.value + '><b class="taguser"></span>' + item.original.key + '</b>';
				},
				values				: [],
			},
			conversationEditorConfig: CONVERSATION_EDITOR_CONFIG,
			editor					: ClassicEditor,
			conversationTextArea	: '',
			chatBoxEnable			: '',
			loggedInUser			: {},
			editorConfigComplete	: false,
			showEditor				: false,
			usersForCkEditor		: []
		}
	},
	created() {
		this.chatBoxEnable = this.isEnable;
		this.loadConversations();
	},
	mounted() {
		var _this 	= this;
		var ele 	= document.getElementById("mention-list-1");
		this.userTagOptions.menuContainer = ele;

		var values 	= [];
		if (!_.isEmpty(this.users)  && _.isEmpty(this.conversationEditorConfig.mention.feeds[0].feed)) {
			_this.userTagOptions.values = _this.users;
			_.each(this.users, usr => {
				//values.push({key:usr.fullName,value:usr.userName});
				this.conversationEditorConfig.mention.feeds[0].feed.push({ id: ('@' + usr.fullName), userName: usr.userName, userType : usr.userType });
				_this.editorConfigComplete = true;
			});
		}
		if(!_.isEmpty(_this.conversationEditorConfig.mention.feeds[0].feed)) {
			_this.editorConfigComplete = true;
		}
		this.loggedInUser = loggedInUser;
	},
	components: {
		'ckeditor': CKEditor.component
	},
	methods: {

		/////////////////////////////////////////////
		/////////   OTHERS
		loadConversations: function () {
			var _this = this;
			var requestBody = {};
			requestBody.entityId = _this.$parent.entityId;
			requestBody.entityType = _this.$parent.entityType;
			axios.post('external-entitites/conversation/fetch', requestBody)
			.then(response => {
				_this.conversations = response.data.conversation;
				_this.$emit("conversation-loaded", _this.conversations.length);
			})
			.catch(error => {
				console.error("Conversation fetch error", error)
			});
		},
		getUserImage: function (user) {
			if (user)
				return getUserImage(user, 'data-action="pic-menu"');
			return getUserImage(loggedInUser, 'data-action="pic-menu"');
		},
		getFormattedDate: function (date) {
			return getFormattedDateForChat(date);
		},
		formatConversation: function (text) {
			return formatConversation(text);
		},
		deleteConversation: function (conversation) {
			//......  delete conversation call
			var _this = this;
			axios.delete('external-entitites/conversation/delete/'+conversation.id)
			.then(response => {
				var index = _.findIndex(_this.conversations, {"id": conversation.id});
				_this.conversations.splice(index, 1);
				_this.$emit("conversation-deleted");				
			})
			.catch(error=>{
				console.error("Comment delete error", error);
			});
			// this.$emit('delete', conversation);
		},
		addConversation: function (conversation) {
			//					this.conversations.push(conversation);
			this.$forceUpdate();
		},
		removeConversation: function (conversation) {
			//					var index = _.findIndex(this.conversations,{id:conversation.id});
			//					this.conversations.splice(index,1);
			this.$forceUpdate();
		},
		/////////////////////////////////////////////
		/////////   EVENTS
		onNewConversation: function () {

			var tributeHtml = this.conversationTextArea;
			if (_.isEmpty(tributeHtml)) {
				return;
			}
			
			var ckResult 				= editorHtmlToText(tributeHtml, this.users);
			this.conversation 			= {};
			this.conversation.user 		= {};
			this.conversation.user.id 	= this.loggedInUser.id;
			this.conversation.text 		= ckResult.text;
			this.conversation.appUrl 	= window.location.href;
			//.....................
			//  save conversation call
			// this.$emit('save', this.conversation);
			this.saveConversation(ckResult.mentions);
			
		},

		onDeleteConversationAction: function (conv) {
			askFromSweetAlertWrapper("Are you sure to remove this Conversation ?",
				[this.deleteConversation, conv],
				[takeNoAction]);
		},

		onEditConversation: function (conv) {
			this.conversation = conv;
			this.chatBoxEnable = true;
			var html = texToTributeHtml(conv.text, this.users);
			this.conversationTextArea = html;
			this.isEditConversation = true;
			this.showEditor = true;
		},
		onUpdateConversation: function () {

			var tributeHtml = this.conversationTextArea;

			if (_.isEmpty(tributeHtml)) {
				return;
			}
			var ckResult				= editorHtmlToText(tributeHtml, this.users);
			this.conversation.text 		= ckResult.text;
			this.conversation.updatedOn = this.conversation.createdOn;
			this.isEditConversation 	= false;

			//.....................
			//  save conversation call
			// this.$emit('save', this.conversation);
			this.saveConversation(ckResult.mentions);
		},
		
		saveConversation: function(mentions) {
			var _this 				= this;
			var requestBody 		= {};
			if(_this.conversation.id && _this.conversation.id!= '') {
				requestBody.id 		= _this.conversation.id;
			}
			requestBody.appUrl 		= _this.conversation.appUrl;
			requestBody.user 		= _this.conversation.user;
			requestBody.text 		= _this.conversation.text;
			requestBody.entityType 	= _this.$parent.entityType;
			requestBody.entityId 	= _this.$parent.entityId;
			let conversationMentions = [];
			conversationMentions.push(loggedInUser.userName)
			conversationMentions = conversationMentions.concat(mentions);

			requestBody.mentions 	= mentions;
						
			axios.post('external-entitites/conversation/save', requestBody)
			.then(response=>{
				_this.conversationTextArea 	= '';
				if(!requestBody.id || requestBody.id == undefined)
					_this.conversations.splice(0,0, response.data.conversation);
					_this.$emit("conversation-added");
				if(_this.$parent.showWatchers){
					if(!_.isEmpty(conversationMentions)) {
						_this.addMentionsToWatchers(conversationMentions);
					}
				}
				this.showEditor = false;
			})
			.catch(error => {
				console.error("conversation save error", error);
			})
			
		},
		addMentionsToWatchers: function(watchers) {
			if(watchers && watchers.length > 0){
				var _this = this;
				axios.post('external-entitites/watchers/save-watchers/'+_this.$parent.entityId+'/'+_this.$parent.entityType, watchers)
				.then(response => {
					if(response && response.data && !_.isEmpty(response.data.watchers)) {
						showTopMessage("Tagged Users added to watcher list", 'success');
					}
				})
				.catch(error => {
					console.error("Conversation watcher error", error);
				});
			}
		}
	},
});
const WATCHERS = Vue.component('watchers', {
	name: 'watchers',
	props: {
		enableAddEdit: {
			type: Boolean,
			default: () => { return true }
		},
	},	
	template: `
		<div class="wtchlst mrow">
		   <ul class="table rec list">
		      <li v-for="watcher in watcherList" class="watcherList">
		         <div class="txt" :class="[_.isEmpty(watcher.user) || (watcher.user && watcher.user.isValid && activeUser(watcher.user))?'':'invalid-user']">{{ watcher.title }}</div>
		         <button v-if="enableAddEdit" @click='removeFromWatcherListAction(watcher)'
		            class="button-w wtchbtn">UnWatch</button>
		      </li>
		      <li class="wtsrch">
		         <a v-if="enableAddEdit" href="javascript:void(0);"
		            v-show='!showSearchWatchersField' @click='showSearchWatcherField()'>
		         <i class="ti-plus ico"></i> Add New Watchers
		         </a>
		         <div v-show='showSearchWatchersField' class="prow lblm swl">
		            <label>Search Watchers</label> <input v-model='searchFieldValue'
		               type="text" placeholder='search users/groups'
		               @input='searchWatchers()' /> <a href="javascript:void(0);"
		               @click='hideSearchWatcherField()'
		               v-show='showSearchWatchersField' class="rmv-ico ti-close swcls"></a>
		            <ul class="table">
		               <li class="rec" v-for="watcher in searchedWatchers">
		                  <div class="rc c1">{{ watcher.title }}</div>
		                  <b class='ltag'
		                     v-if="watcher.user">User</b> <b class='ltag'
		                     v-if="watcher.group">Group</b>
		                  <div class="r-icons">
		                     <a href="javascript:void(0);"
		                        v-if="!checkIfWatcherAdded(watcher)"
		                        @click='addToWatcherList(watcher)' class="ti-plus addf ico">
		                     Add to Watchers List</a> <a href="javascript:void(0);"
		                        v-if="checkIfWatcherAdded(watcher)" disabled
		                        class="ti-eye ico">Already Watching</a>
		                  </div>
		               </li>
		            </ul>
		         </div>
		      </li>
		   </ul>
		</div>	
	`,
	data: function () {
		return {
			watcherList				: [],
			searchedWatchers		: '',
			searchFieldValue		: '',
			showSearchWatchersField	: false,
			actionInProgress		: false,
		}
	},
	computed: {
		activeUser: function() {
			return function(user) {
				if(user.userCompanies) {
					let compId = "";
					if(!_.isEmpty(cid)) {
						compId = cid;
					} else if(!_.isEmpty(companyId)) {
						compId = companyId;
					}
					var company = _.find(user.userCompanies, function(o){return o.company.id == compId});
					if(company) {
						return company.isActive;
					}
				}
				return true;
			}
		}
	},
	mounted() {
		this.fetchWatchers();
	},
	methods: {
		fetchWatchers: function () {
			var _this 				= this;
			var requestBody 		= {};
			requestBody.entityType 	= _this.$parent.entityType;
			requestBody.entityId 	= _this.$parent.entityId;
			axios.post('external-entitites/watchers/get-watchers/', requestBody)
			.then(response => {
				_this.watcherList 	= response.data.watchers;

			}).catch(error => { });
		},
		showSearchWatcherField: function () {
			this.showSearchWatchersField = true;
		},
		hideSearchWatcherField: function () {
			this.showSearchWatchersField = false;
			this.searchedWatchers = ''
			this.searchFieldValue = ''
		},
		searchWatchers: function () {
			var _this = this;
			_this.searchedWatchers = [];
			if (_this.searchFieldValue)
				axios.get('external-entitites/watchers/search-watchers/' + _this.searchFieldValue)
				.then(response => { 
					_this.searchedWatchers = response.data.watchers; 
				})
				.catch(error => {});
		},
		addToWatcherList: function (watcher) {
			var _this = this;
			if (_this.actionInProgress) {
				return;
			}

			watcher.entityType = _this.$parent.entityType;
			watcher.entityId = _this.$parent.entityId;
			_this.actionInProgress = true;

			axios.post('external-entitites/watchers/save-watcher/', watcher)
			.then(response => {
				_this.actionInProgress = false;
				_this.watcherList.push(response.data.watchers);
				showTopMessage("Added to watcher list", 'success');
			})
			.catch(error => {
				_this.actionInProgress = false;
			});
		},
		removeFromWatcherListAction: function (watcher) {
			askFromSweetAlertWrapper("Do you want to remove them from Watchers list?",
				[this.removeFromWatcherList, watcher],
				[takeNoAction]);
		},
		removeFromWatcherList: function (watcher) {
			var _this = this;
			axios.post('external-entitites/watchers/delete-watcher/'+ watcher.id)
			.then(response => {
				var index = _.findIndex(_this.watcherList, { id: watcher.id });
				if (index > -1) {
					_this.watcherList.splice(index, 1);
					showTopMessage("Removed from watcher list", 'success');
				}
			})
			.catch(error => { });
		},
		checkIfWatcherAdded: function (watcher) {
			for (var i = 0; i < this.watcherList.length; i++) {
				if (this.watcherList[i].watcherId === watcher.watcherId) {
					return true;
				}
			}
			return false;
		},

	},
});
const HISTORY = Vue.component('history', {
	props: {
		isMockingMode: {
            type: Boolean,
            default: () =>{ return false }			
		}
	},
	name: 'history',
	template:`
		<div class="cnvrstn history prow p-rel">
		   <div v-if="startLoader" class="loader"><div><div class="loaderinteg"></div></div></div>		
			<ul class="prow">
				<li v-if="historyList.length > 0" v-for="(history, historyIndex) in historyList">
					<div v-html="history" class="ti-eraser ico" />
				</li>
				<li v-if="historyList.length == 0" class="nofound">History not available</li>
			</ul>
		</div>
	`,
	data() {
		return {
			historyList: [],
			startLoader: false,
		}
	},
	computed: {},
	mounted() {
		this.fetchHistory();
	},
	created() {},
	methods: {
		fetchHistory: function() {
			var _this = this;
			_this.startLoader = true;
			var requestBody = {};
			requestBody.entityId = _this.$parent.entityId;
			requestBody.entityType = _this.$parent.entityType;
			requestBody.zoneOffset = -(new Date().getTimezoneOffset());
			if(_this.isMockingMode) {
				requestBody.isMockingMode = true;
			}
			axios.post('external-entitites/history/fetch-history', requestBody)
			.then(response=>{
				_this.historyList = response.data.history;
				_this.startLoader = false;				
			})
			.catch(error=>{
				console.error("History fetch error", error);
			})
		}
	}
});
const ACTION_POINTS = Vue.component('action-points', {
	name: 'action-points',
	template:`
		<div class="cnvrstn history prow p-rel">
		<div class="pd-10 DF">
			<a @click="showNewAPForm = true;" class="button-w  h-auto nwabtn"><em class="ti-plus addf"></em>Add</a>
		</div>
		<div class="pd-10 FL">
			<template v-if="showNewAPForm">
				<input type="text" v-model="newActionPoint.title" @change="saveActionPoints(null)"/>
				<button @click="saveActionPoints" class="FR savBtn mt-10" >Save</button>
				<a @click="cancelAction" class="FR cncl mt-22 c-point">Cancel</a>				
			</template>
		</div>
			<div v-if="startLoader" class="loader"><div><div class="loaderinteg"></div></div></div>		
			<ul class="prow pl-0">
				<li class="custom-checkbox DFA" v-if="actionPointsList.length > 0" v-for="(ap, apIndex) in actionPointsList">
					<input id="action1" type="checkbox" v-model="ap.value" @change="saveActionPoints(ap)"/>
					<label class="actionLbl" for="action1"></label>
					<span>{{ap.title}}</span>
				</li>
			</ul>
		</div>
	`,
	props: {
		entityType: {
			type: String,
			default: () => {return ""}
		},
		entityId: {
			type: String,
			default: () => {return ""}
		},		
	},
	data() {
		return {
			actionPointsList	: [],
			newActionPoint		: {
				title		: "",
				value		: false,
				entityId	: this.entityId,
				entityType	: this.entityType,
			},
			startLoader			: false,
			showNewAPForm		: false,
		}
	},
	computed: {},
	mounted() {
		this.fetchActionPoints();
	},
	created() {},
	methods: {
		fetchActionPoints: function() {
			let _this = this;
			_this.startLoader = true;
			let requestBody = {};
			requestBody.entityId = _this.entityId;
			requestBody.entityType = _this.entityType;
			axios.post('external-entitites/action-point/fetch', requestBody)
			.then(response=>{
				_this.actionPointsList = response.data.actionPoints;
				_this.startLoader = false;
			})
			.catch(error=>{
				console.error("Action Points fetch error", error);
			})
		},
		saveActionPoints: function(ap) {
			let _this = this;
			_this.startLoader = true;
			let requestBody = {};			
			if(!_.isEmpty(ap)) {
				requestBody.id 			= ap.id;				
				requestBody.value 		= ap.value;
				requestBody.title 		= ap.title;				
				requestBody.entityId 	= _this.entityId;
				requestBody.entityType 	= _this.entityType;				
			} else {
				requestBody 			= _this.newActionPoint;
			}
			axios.post('external-entitites/action-point/save', requestBody)
			.then(response=>{
				let actionPoint = response.data.actionPoint;
				let index = _.findIndex(_this.actionPointsList, {"id": actionPoint.id});
				if(index < 0) {
					_this.actionPointsList.push(actionPoint);
				} else {
					_this.actionPointsList.splice(index, 1, actionPoint);
				}
				_this.startLoader 		= false;
				_this.cancelAction();
			})
			.catch(error=>{
				console.error("Action Point save error", error);
			})
		},
		onDeleteActionPoint: function (ap) {
			askFromSweetAlertWrapper("Are you sure to remove this Action Point?",
				[this.deleteActionPoint, ap],
				[takeNoAction]);
		},
		deleteActionPoint: function (ap) {
			let _this = this;
			axios.delete('external-entitites/action-point/delete/'+ap.id)
			.then(response => {
				let index = _.findIndex(_this.actionPointsList, {"id": ap.id});
				_this.actionPointsList.splice(index, 1);
			})
			.catch(error=>{
				console.error("Action Point delete error", error);
			});
		},
		cancelAction: function() {
			this.showNewAPForm 	= false;
			this.newActionPoint = {
				title		: "",
				value		: false,
				entityId	: this.entityId,
				entityType	: this.entityType,
				
			};
		}

	}
});


const EMOJIS = Vue.component('emojis', {
	template: `
		<div>
			<div class="DFA">
				<template v-for="(group, index) in emojiGroup">
					<div :class="group.classes">
						<span v-for="emoji in group.emojis" :class="emoji.classes" @click="onClickReaction(emoji.symbol)">
							{{emoji.symbol}}
							<span v-if="groupedEmoji[EMOJI_TO_CODE[emoji.symbol]] && groupedEmoji[EMOJI_TO_CODE[emoji.symbol]].length > 0" :class="[group.classes=='positiveEmojis'? 'posemojiCount' : 'negemojiCount']" class="tooltip">{{groupedEmoji[EMOJI_TO_CODE[emoji.symbol]].length}}
								<div class="hovtooltip">
									<ul>
										<li class="DFA mb-10" v-for="(answer, answerIndex) in groupedEmoji[EMOJI_TO_CODE[emoji.symbol]]" :class="[answer.user.isValid?'':'invalid-user']">
											<div class="pic mr-5" v-html="getUserImage(answer.user)"></div>
											<div>
												<div class="txt-strt" v-if="answer.user.fullName">{{answer.user.fullName}}</div>
												<div class="txt b fs-12" v-if="answer.user.email && answer.user.isValid" style="opacity: 0.5">{{answer.user.email}}</div>
											</div>
										</li>
									</ul>
								</div>	
							</span>						
						</span>
					</div>
				</template>
				<!--<emoji-picker @emoji="insert">
                	<div class="moreBtnWrap" slot="emoji-invoker" slot-scope="{ events: { click: clickEvent } }" @click.stop="clickEvent">
                    	<span class="moreBtn" title="Add More">
                    		<img src="/assets/icons/plus-lrg.svg" alt=".." class="w-30">
						</span>
                    </div>
                    <div slot="emoji-picker" slot-scope="{ emojis, insert, display }">
                    	<div>
                            <div>
                            	<div v-for="(emojiGrp, category) in emojis" :key="category">
                                	<h5>{{ category }}</h5>
                                    <div>
                                        <span
                                          v-for="(emoji, emojiName) in emojiGrp"
                                          :key="emojiName"
                                          @click="insertWithArgument(emoji, emojiGroup.otherEmojis.id)"
                                          :title="emojiName" style="font-size: 25px;"
                                        >{{ emoji }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </emoji-picker>-->
				
			</div>
		</div>
	`,
	props: {
		entityId: {
			type: String,
			default() {
				return "";
			}
		},
		entityType: {
			type: String,
			default() {
				return "";
			}
		},
		users: {
			type: Array,
			default: () => { return [] }
		},
		refreshEmoji: {
			type: Boolean,
			default() {
				return false;
			}
		}
	},
	data() {
		return {
			emojiConversations: [],
			groupedEmoji: {},
			emojiGroup: {
				positiveEmojis: {
					id: 'positiveEmojis',
					classes: "positiveEmojis",
					emojis: [
						{symbol: CODE_TO_EMOJI['0'], classes: "posEmojiIcon"},
						{symbol: CODE_TO_EMOJI['1'], classes: "posEmojiIcon"},
						{symbol: CODE_TO_EMOJI['2'], classes: "posEmojiIcon"},
						{symbol: CODE_TO_EMOJI['3'], classes: "posEmojiIcon"},
						{symbol: CODE_TO_EMOJI['4'], classes: "posEmojiIcon"},
					]
				},
				negativeEmojis: {
					id: 'negativeEmojis',
					classes: "negativeEmojis",
					emojis: [
						{symbol: CODE_TO_EMOJI['5'], classes: "negEmojiIcon"},
						{symbol: CODE_TO_EMOJI['6'], classes: "negEmojiIcon"},
						{symbol: CODE_TO_EMOJI['7'], classes: "negEmojiIcon"},
					]
				},
				otherEmojis: {
					id: 'otherEmojis',
					classes: 'otherEmojis',
					emojis: []
				}

			},
			
		}
	},
	created() {
		this.loadEmojiConversations();
	},
	watch: {
		"emojiConversations.length": {
			handler(newValue, oldValue) {
				if(newValue != oldValue) {
					this.createEmojiGroup();
				}
			}
		},
		"refreshEmoji": {
			handler(newValue, oldValue) {
				if(this.refreshEmoji) {
					this.loadEmojiConversations();
				}
			}
		}
	},
	methods: {
		onClickReaction(reaction) {
			let conversation = {};
			conversation.user = {id: loggedInUser.id};
			conversation.conversationType = "Emoji";
			conversation.entityId = this.entityId;
			conversation.entityType = this.entityType;
			conversation.text = EMOJI_TO_CODE[reaction]//reaction;

			let allowReaction = true;
			let reactedConversation = {};
			if(this.groupedEmoji[EMOJI_TO_CODE[reaction]]) {
				for(let i = 0; i < this.groupedEmoji[EMOJI_TO_CODE[reaction]].length; i++) {
					if(this.groupedEmoji[EMOJI_TO_CODE[reaction]][i] &&
						this.groupedEmoji[EMOJI_TO_CODE[reaction]][i].user &&
						this.groupedEmoji[EMOJI_TO_CODE[reaction]][i].user.id == loggedInUser.id) {
						allowReaction = false;
						reactedConversation = this.groupedEmoji[EMOJI_TO_CODE[reaction]][i];
						break;
					}
				}
			}

			if(allowReaction) {
				this.requestSaveEmojiConversation(conversation);
			} else {
				this.requestRemoveEmojiReaction(reactedConversation.id);
			}



		},
		createEmojiGroup() {
			let _this = this;
			let groupedData = _.groupBy(this.emojiConversations, "text");
			
			//let map1 = _.groupBy(_this.emojiGroup.positiveEmojis.emojis,'symbol');
			//let map2 = _.groupBy(_this.emojiGroup.negativeEmojis.emojis,'symbol');
			_.each(groupedData, (value, key)=>{
				let emojiIndex = _.findIndex(_this.emojiGroup.positiveEmojis.emojis, {"symbol": CODE_TO_EMOJI[key]});
				if(emojiIndex < 0) {
					emojiIndex = _.findIndex(_this.emojiGroup.negativeEmojis.emojis, {"symbol": CODE_TO_EMOJI[key]});
					if(emojiIndex < 0) {
						_this.emojiGroup.otherEmojis.emojis.push({symbol: CODE_TO_EMOJI[key], classes: "othEmojiIcon"})
					}
				}
			});
			this.groupedEmoji = groupedData;
		},
		insertWithArgument(emoji, type) {
			let _this = this;
			if(this.$refs[type] && this.$refs[type].length > 0) {
				this.$refs[type][0].display.visible = false;
			}

			// API call with checkin id and required fields goes here
			let request = {};
			_this.onInsertEmoji(emoji, type);
			// axios.post('/').then(response => {
			//  // emit here
			// }).catch(error => {
			//
			// });
		},
		insert(emoji) {

		},
		loadEmojiConversations() {
			let _this = this;
			let requestBody = {};
			requestBody.entityId = _this.entityId;
			requestBody.entityType = _this.entityType;
			requestBody.conversationType = "Emoji";
			axios.post('/external-entitites/conversation/fetch', requestBody)
				.then(response => {
					_this.emojiConversations = response.data.conversation;
					if(_this.emojiConversations && _this.emojiConversations.length > 0) {
						_this.createEmojiGroup();
					}
				})
				.catch(error => {
					console.error("Conversation fetch error", error)
				});
		},
		requestSaveEmojiConversation: function(requestBody) {
			let _this = this;
			axios.post('/external-entitites/conversation/save', requestBody)
				.then(response=>{
					let conversation = response.data.conversation;
					let conversationIndex = _.findIndex(_this.emojiConversations, {id: conversation.id});

					if(conversationIndex > -1) {
						_this.emojiConversations.splice(conversationIndex, 1, conversation);
					} else {
						_this.emojiConversations.push(conversation);
					}
					showTopMessage("Reaction saved successfully", "success", 2000);
					_this.$emit('refresh', true);
				})
				.catch(error => {
					console.error("conversation save error", error);
					showTopMessage("Error Saving Reaction", "warning", 2000);
				})

		},
		requestRemoveEmojiReaction(conversationId) {
			axios.delete("/external-entitites/conversation/delete/"+conversationId).then(response => {
				if(response.data.success) {
					let conversationIndex = _.findIndex(this.emojiConversations, {id: conversationId});
					if(conversationIndex > -1) {
						this.emojiConversations.splice(conversationIndex, 1);
						showTopMessage("Reaction Removed", "success", 2000);
					}
					this.$emit("refresh", false);
				}
			}).catch(error => {
				console.log(error);
				showTopMessage("Failed to Remove Reaction", "warning", 2000);
			})
		},
		onInsertEmoji(emoji, type) {
			if(this.emojiGroup[type] && this.emojiGroup[type].emojis && this.emojiGroup[type].emojis.length > 0) {
				this.emojiGroup[type].emojis.push({symbol: CODE_TO_EMOJI[emoji], classes: this.emojiGroup[type].emojis[0].classes});
				// after pushing send update to other clients here
			}
		},
		getUserImage: function (user) {
			if (user)
				return getUserImage(user, 'data-action="pic-menu"');
			return getUserImage(loggedInUser, 'data-action="pic-menu"');
		},
	},
});

const EXTERNAL_ENTITIES = Vue.component('external-entities', {
	props: {
		showConversations: {
			type: Boolean,
			default: () => {return true}
		},
		showWatchers: {
			type: Boolean,
			default: () => {return true}
		},
		showHistory: {
			type: Boolean,
			default: () => {return true}
		},
		showAttachments: {
			type: Boolean,
			default: () => {return true}
		},
		entityType: {
			type: String,
			default: () => {return null}
		},
		entityId: {
			type: String,
			default: () => {return null}
		},
		board: {
			type: Object,
			default: () => {return {}}
		},
		workspace: {
			type: Object,
			default: () => {return {}}
		},
        globalMode:  {
            type: Boolean,
            default: () => {return false}
        },
	},
	components: {
		'conversations-generic' : CONVERSATIONS_GENERIC,
		'watchers': WATCHERS
	},
	template:`
	<div>
		<div class="cnvrstn tab cnvrstncomn prow">
			<div class="rec hd lblm pd-0">
				<label v-if= "showConversations" :class="[showConversationTab ? 'active' : '']" @click="hideAllTabs(); showConversationTab=true;"><strong>Conversations</strong></label>
				<label v-if= "showHistory" :class="[showHistoryTab ? 'active' : '']" @click="hideAllTabs(); showHistoryTab=true;"><strong>History</strong></label>
				<label v-if= "showWatchers" :class="[showWatcherTab ? 'active' : '']" @click="hideAllTabs(); showWatcherTab=true;"><strong>Watched By</strong></label>
				<label v-if= "showAttachments" :class="[showAttachmentTab ? 'active' : '']" @click="hideAllTabs(); showAttachmentTab=true;"><strong>Attachments</strong></label>
			</div>
			<div v-if="showConversationTab">
				<conversations-generic @save="saveConversation($event)" @delete="deleteConversation($event)" :is-enable="true" :users="users" :users-fetched="usersFetched"></conversations-generic>
			</div>
			<div v-if="showHistoryTab">
				<history :entity-id="entityId" :entity-type="entityType"></history>
			</div>
			<div v-if="showWatcherTab">
				<watchers :entity-id="entityId" :entity-type="entityType"></watchers>
			</div>
			<div v-if="showAttachmentTab">
				<!-- Attachment here -->
			</div>
		</div>
	</div>
	`,
	data() {
		return {
			showConversationTab	: true,
			showHistoryTab		: false,
			usersFetched		: false,
			showWatcherTab		: false,
			showAttachmentTab	: false,
			conversations		: [],
			users				: [],
			items				: [],
		}
	},
	mounted() {},
	created() {
		this.loadData();
	},
	methods: {
        hideAllTabs: function () {
            this.showConversationTab = false;
            this.showHistoryTab = false;
            this.showWatcherTab = false;
            this.showAttachmentTab = false;
        },
        loadData: function () {
            var _this = this;
            _this.loadDataForTagging();
        },
        loadDataForTagging: function () {
            var _this = this;
            if (_.isEmpty(ITEMS_FOR_EDITOR)) {
				if (_this.board && _this.board.id) {
					axios.get("/plan/items1/" + _this.board.id)
                    .then(response => {
                        _this.items = response.data;
                        ITEMS_FOR_EDITOR = response.data;
                    })
                    .catch(error => {
                        console.error("loadMentionFeeds:items", error);
                    })
				}
            } else {
                _this.items = ITEMS_FOR_EDITOR;
            }
            if (_this.globalMode) {
                axios.get("/graphx/users")
                    .then(response => {
                        if (response.data.hasOwnProperty("success") && response.data.success) {
                            _this.users = response.data.users;
                            USERS_FOR_EDITOR = response.data.users
                            _this.usersFetched = true;
                        }
                    })
                    .catch(error => {
                        console.error("loadMentionFeeds:users", error);
                    })
            } else {
				let workspaceId = undefined;
				if (_this.board && _this.board.id) {
					workspaceId = _this.board.session.workSpace.id;
				}
				else if (_this.workspace && _this.workspace.id) {
					workspaceId = _this.workspace.id;
				}
                if (_.isEmpty(USERS_FOR_EDITOR)) {
                    axios.get("/admin/all-users?workSpaceId=" + workspaceId)
                        .then(response => {
                            _this.users = response.data.users;
                            USERS_FOR_EDITOR = response.data.users
                            _this.usersFetched = true;
                        })
                        .catch(error => {
                            console.error("loadMentionFeeds:users", error);
                        })
                } else {
                    _this.usersFetched = true;
                    _this.users = USERS_FOR_EDITOR;
                    _this.usersFetched = true;
                }
            }
        }
    }
})