const CREATE_COLLAB_BOARD = Vue.component('create-collaboration-board', {
    name: 'create-collaboration-board',
    template: `
        <div class="create-board-overlay">
            <div class="create-board-modal ui-dialog">
                <!-- Loading State -->
                <div v-if="isLoading" class="loader-container">
                    <div class="loader">
                        <div class="aa">
                            <div class="loaderinteg"></div>
                            <span class="LOADER-TITLE">Loading board data...</span>
                        </div>
                    </div>
                </div>
                <h2 class="modal-title">
                	{{popupTitle}}
                	<a href="javascript:void(0);" class="rmv-ico ti-close" @click="onCancel"></a>
                </h2>
                
                <div class="cntr-container">
                <div class="tab-container">
                    <button class="tab-btn DFA":class="{ active: currentTab === 'basic-info' }" @click="currentTab = 'basic-info'">
                        Details
                        <span class="infotxt tooltip mht nw2 nwhv">
                            <span class="hovtooltipB wdt3">Start by naming your board, selecting its type, and choosing where it should be available in Kendis.</span>
                        </span>
                    </button>
                    <button class="tab-btn DFA" :class="{ active: currentTab === 'associations' }" @click="currentTab = 'associations'">
                        Associations
                        <span class="infotxt tooltip mht nw2 nwhv"><span class="hovtooltipB wdt3">Choose the specific Program Boards, Collections, or Solution Boards where this board should be accessible.</span></span>
                    </button>
                </div>

                <!-- Basic Info Tab -->
                <div v-if="currentTab === 'basic-info'" class="tab-content">
                    <div class="form-section mb-20">
                        <label class="form-label ftsb">Board Name</label>
                        <input                        	
                            type="text" 
                            v-model="boardData.title" 
                            class="form-input rnd4"
                            :class="{ 'title-validation-error': validationErrors.title }"
                            placeholder="Enter board name"
                            maxlength="100"
                            :disabled="isEditMode && !permissions.EDIT_COLLAB_BOARD"
                        />
                        <div v-if="isEditMode && !permissions.EDIT_COLLAB_BOARD" class="permission-notice">
                            <i class="ti-lock"></i> Board name cannot be changed due to permission restrictions
                        </div>
                    </div>

                    <div class="form-section mb-20 p-rel">
                        <label class="form-label ftsb">Description</label>
                        <textarea 
                            v-model="boardData.description" 
                            class="form-textarea rnd4"
                            placeholder="Enter board description"
                            rows="4"
                            maxlength="250"
                            :disabled="isEditMode && !permissions.EDIT_COLLAB_BOARD"
                        ></textarea>
                        <div class="character-count">
                            <span :class="{ 'near-limit': boardData.description.length > 200, 'at-limit': boardData.description.length >= 250 }">
                                {{ boardData.description.length }}/250
                            </span>
                        </div>
                        <div v-if="isEditMode && !permissions.EDIT_COLLAB_BOARD" class="permission-notice">
                            <i class="ti-lock"></i> Description cannot be changed due to permission restrictions
                        </div>
                    </div>
                    
                    <!--      Color and line pattern selection       -->
                    <div class="form-section bg-color">
                        <div class="rec lblm clr mb-30" :class="{ 'disabled-section': isEditMode && !permissions.EDIT_COLLAB_BOARD }">
                            <label>Background Colors</label>
                            <div class="DF">
                                <div class="clin" v-for="(color, index) in backgroundColors">
                                    <a :class="[selectedColor===color?'active':'']" href="javascript:void(0);" @click="onSelectColor(color)" v-bind:style="{'background-color':color}"></a>
                                </div>
                            </div>
                            <div v-if="isEditMode && !permissions.EDIT_COLLAB_BOARD" class="permission-notice">
                                <i class="ti-lock"></i> Background color cannot be changed due to permission restrictions
                            </div>
                        </div>
                        
                        <div class="rec lblm ptrn mb-30" :class="{ 'disabled-section': isEditMode && !permissions.EDIT_COLLAB_BOARD }">
                            <label>Background Pattern</label>
                            <div class="DF ptin">                                
                            <div class="ptin" v-for="(pattern, index) in backgroundPattern">
                                <a :class="[selectedPattern === pattern.value? 'active' : '']" href="javascript:void(0);" @click="onSelectPattern(pattern.value)">
                                    <img :src="pattern.url2" alt="Setting" class="ico" />
                                </a>
                            </div>
                            </div>
                            <div v-if="isEditMode && !permissions.EDIT_COLLAB_BOARD" class="permission-notice">
                                <i class="ti-lock"></i> Background pattern cannot be changed due to permission restrictions
                            </div>
                        </div>
                    </div>

                    <!-- Type Selection -->
                    <div class="form-section mb-20 board-type">
                        <label class="form-label ftsb">
                            Board Type
                            <span class="infotxt tooltip mht nw2 nwhv ml-10">
                                <span class="hovtooltipB wdt3">Choose the board type to categorize this Collab board. These types help you organize and locate boards across your context.</span>
                            </span>
                        </label>
                        <div class="selectcont rnd4">
                        <vz-select 
                            v-if="navigationLinks"
                            :multiple="false" 
                            track-by="id" 
                            empty-selection-text="Board Type"
                            :selected-title="getSelectedTypeTitle"
                            v-model="boardData.selectedType" 
                            :options="navigationLinks"
                            class="multi-filter" 
                            value-type="object"
                            placeholder="Board Type"
                            :disabled="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE"
                        /></div>
                        <div v-if="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE" class="permission-notice">
                            <i class="ti-lock"></i> Type cannot be changed due to permission restrictions
                        </div>
                         <!-- Show selected type info -->
<!--	                    <div v-if="boardData.selectedType" class="selected-tags">-->
<!--	                        <div class="bxtagG">-->
<!--	                            {{ getSelectedTypeTitle }}-->
<!--	                            <a href="javascript:void(0);" class="remove-tag" @click="clearSelectedType()" v-if="!isEditMode || permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE">×</a>-->
<!--	                        </div>-->
<!--	                    </div>	-->
                    </div>

                    <!-- Team Selection Dropdown (only for session context when "Select Teams" is chosen) -->
                    <div v-if="showTeamDropdown" class="form-section mb-20">
                        <label class="form-label ftsb">Select Team</label>
                        <div class="selectcont rnd4">
                            <vz-select 
                                v-if="sessionTeams.length > 0"
                                :multiple="true" 
                                track-by="id" 
                                empty-selection-text="Choose Teams"
                                :selected-title="getTeamsDropdownTitle"
                                v-model="chosenTeams" 
                                :options="sessionTeams"
                                class="multi-filter" 
                                value-type="object"
                                placeholder="Choose Teams"
                                :disabled="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE"
                            />
                        </div>
                        <div v-if="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE" class="permission-notice">
                            <i class="ti-lock"></i> Team cannot be changed due to permission restrictions
                        </div>
                        <div v-if="chosenTeams && chosenTeams.length > 0 && !isDefaultTeamSelection" class="selected-tags">
                            <div v-for="team in chosenTeams" :key="team.id" class="bxtagG">
                                {{ team.title }}
                                <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeChosenTeam(team)" v-if="!isEditMode || permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE">×</a>
                            </div>
                        </div>
                    </div>

                    <!-- Session Selection Dropdown (only for solution context when "Select Sessions" is chosen) -->
<!--                    <div v-if="showSessionDropdown && contextType === 'solution'" class="form-section mb-20">-->
<!--                        <label class="form-label ftsb">Select Session</label>-->
<!--                        <div class="selectcont rnd4">-->
<!--                            <vz-select -->
<!--                                v-if="solutionSessions.length > 0"-->
<!--                                :multiple="false" -->
<!--                                track-by="id" -->
<!--                                empty-selection-text="Choose Session"-->
<!--                                :selected-title="chosenSession && chosenSession.title ? chosenSession.title : ''"-->
<!--                                v-model="chosenSession" -->
<!--                                :options="solutionSessions"-->
<!--                                class="multi-filter" -->
<!--                                value-type="object"-->
<!--                                placeholder="Choose Session"-->
<!--                                :disabled="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE"-->
<!--                            />-->
<!--                        </div>-->
<!--                        <div v-if="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE" class="permission-notice">-->
<!--                            <i class="ti-lock"></i> Session cannot be changed due to permission restrictions-->
<!--                        </div>-->
<!--                        &lt;!&ndash; Show selected session info &ndash;&gt;-->
<!--&lt;!&ndash;                        <div v-if="chosenSession" class="selected-tags">&ndash;&gt;-->
<!--&lt;!&ndash;                            <div class="bxtagG">&ndash;&gt;-->
<!--&lt;!&ndash;                                {{ chosenSession.title }}&ndash;&gt;-->
<!--&lt;!&ndash;                                <a href="javascript:void(0);" class="remove-tag" @click="clearChosenSession()" v-if="!isEditMode || permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE">×</a>&ndash;&gt;-->
<!--&lt;!&ndash;                            </div>&ndash;&gt;-->
<!--&lt;!&ndash;                        </div>&ndash;&gt;-->
<!--                    </div>-->

                    <!-- Program Board Selection Dropdown (only for collection context when "Select Program Boards" is chosen) -->
<!--                    <div v-if="showProgramBoardDropdown && (viewType)" class="form-section mb-20">-->
<!--                        <label class="form-label ftsb">Select Program Board</label>-->
<!--                        <div class="selectcont rnd4">-->
<!--                            <vz-select -->
<!--                                v-if="collectionProgramBoards.length > 0"-->
<!--                                :multiple="false" -->
<!--                                track-by="id" -->
<!--                                empty-selection-text="Choose Program Board"-->
<!--                                :selected-title="chosenProgramBoard && chosenProgramBoard.title ? chosenProgramBoard.title : ''"-->
<!--                                v-model="chosenProgramBoard" -->
<!--                                :options="collectionProgramBoards"-->
<!--                                class="multi-filter" -->
<!--                                value-type="object"-->
<!--                                placeholder="Choose Program Board"-->
<!--                                :disabled="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE"-->
<!--                            />-->
<!--                        </div>-->
<!--                        <div v-if="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE" class="permission-notice">-->
<!--                            <i class="ti-lock"></i> Program Board cannot be changed due to permission restrictions-->
<!--                        </div>-->
<!--                        &lt;!&ndash; Show selected program board info &ndash;&gt;-->
<!--&lt;!&ndash;                        <div v-if="chosenProgramBoard" class="selected-tags">&ndash;&gt;-->
<!--&lt;!&ndash;                            <div class="bxtagG">&ndash;&gt;-->
<!--&lt;!&ndash;                                {{ chosenProgramBoard.title }}&ndash;&gt;-->
<!--&lt;!&ndash;                                <a href="javascript:void(0);" class="remove-tag" @click="clearChosenProgramBoard()" v-if="!isEditMode || permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE">×</a>&ndash;&gt;-->
<!--&lt;!&ndash;                            </div>&ndash;&gt;-->
<!--&lt;!&ndash;                        </div>&ndash;&gt;-->
<!--                    </div>-->

<!--                    &lt;!&ndash; Solution Board Selection Dropdown (only for collection context when "Select Solution Boards" is chosen) &ndash;&gt;-->
<!--                    <div v-if="showSolutionBoardDropdown && (viewType)" class="form-section mb-20">-->
<!--                        <label class="form-label ftsb">Select Solution Board</label>-->
<!--                        <div class="selectcont rnd4">-->
<!--                            <vz-select -->
<!--                                v-if="collectionSolBoards.length > 0"-->
<!--                                :multiple="false" -->
<!--                                track-by="id" -->
<!--                                empty-selection-text="Choose Solution Board"-->
<!--                                :selected-title="chosenSolutionBoard && chosenSolutionBoard.title ? chosenSolutionBoard.title : ''"-->
<!--                                v-model="chosenSolutionBoard" -->
<!--                                :options="collectionSolBoards"-->
<!--                                class="multi-filter" -->
<!--                                value-type="object"-->
<!--                                placeholder="Choose Solution Board"-->
<!--                                :disabled="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE"-->
<!--                            />-->
<!--                        </div>-->
<!--                        <div v-if="isEditMode && !permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE" class="permission-notice">-->
<!--                            <i class="ti-lock"></i> Solution Board cannot be changed due to permission restrictions-->
<!--                        </div>-->
<!--                        &lt;!&ndash; Show selected solution board info &ndash;&gt;-->
<!--&lt;!&ndash;                        <div v-if="chosenSolutionBoard" class="selected-tags">&ndash;&gt;-->
<!--&lt;!&ndash;                            <div class="bxtagG">&ndash;&gt;-->
<!--&lt;!&ndash;                                {{ chosenSolutionBoard.title }}&ndash;&gt;-->
<!--&lt;!&ndash;                                <a href="javascript:void(0);" class="remove-tag" @click="clearChosenSolutionBoard()" v-if="!isEditMode || permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE">×</a>&ndash;&gt;-->
<!--&lt;!&ndash;                            </div>&ndash;&gt;-->
<!--&lt;!&ndash;                        </div>&ndash;&gt;-->
<!--                    </div>-->


                    <div class="form-section rhtsd">
                        <label class="form-label ftsb">Associate With
                            <span class="infotxt tooltip mht nw2 nwhv ml-10"><span class="hovtooltipB wdt3">Select where this board should appear. You can link it with a Program Board, Solution Board, or Collection</span></span>
                        </label>
                        
                        <div class="association-type-cards">
                            <div 
                                class="association-card" 
                                :class="{ 
                                    active: boardData.associations.includes('piboard'), 
                                    disabled: !permissions.ALLOW_ASSOCIATION_COLLAB_BOARD
                                }"
                                @click="toggleAssociation('piboard')"
                            >
                                <div class="card-checkbox" :class="{ 
                                    checked: boardData.associations.includes('piboard'),
                                    'association-validation-error': validationErrors.associate
                                }"></div>
                                <span>Program Board</span>
                                </div>
                            <div 
                                class="association-card"
                                :class="{ 
                                    active: boardData.associations.includes('solutionboard'), 
                                    disabled: !permissions.ALLOW_ASSOCIATION_COLLAB_BOARD
                                }"
                                @click="toggleAssociation('solutionboard')"
                            >
                                <div class="card-checkbox" :class="{ 
                                    checked: boardData.associations.includes('solutionboard'),
                                    'association-validation-error': validationErrors.associate
                                }"></div>
                                <span>Solution Board</span>
                            </div>
                            <div 
                                class="association-card"
                                :class="{ 
                                    active: boardData.associations.includes('collections'), 
                                    disabled: !permissions.ALLOW_ASSOCIATION_COLLAB_BOARD
                                }"
                                @click="toggleAssociation('collections')"
                            >
                                <div class="card-checkbox" :class="{ 
                                    checked: boardData.associations.includes('collections'),
                                    'association-validation-error': validationErrors.associate
                                }"></div>
                                <span>Collections</span>
                            </div>
                        </div>
                        <div v-if="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD" class="permission-notice">
                            <i class="ti-lock"></i> Associations cannot be changed due to permission restrictions
                        </div>
                        <div class="DAJE">
                        	<button class="view-associations-btn mt-15 rnd4 " @click="currentTab = 'associations'" >View Associations →</button>
                        </div>

                    </div>
                </div>

                <!-- Associations Tab -->
                <div v-if="currentTab === 'associations'" class="tab-content">
                    <!-- Permission Notice -->
                    <div v-if="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD" class="permission-notice-full">
                        <i class="ti-lock"></i> Associations cannot be modified due to permission restrictions
                    </div>
                    
                    <!-- Program Board Section -->
                    <div class="association-section" :class="{ 
                        disabled: !permissions.ALLOW_ASSOCIATION_COLLAB_BOARD,
                        'association-section-validation-error': validationErrors.associationSections
                    }">
                        <div class="section-header ftsb" @click="toggleSection('program')">
                            <i class="ti-angle-right" :class="{ expanded: expandedSections.program }"></i>
                            Program Board ({{boardData.piBoards.length}})
                        </div>
                        <div class="section-content" v-if="expandedSections.program">
                        
                            <div class="session-coll-drop">
                                <label class="form-label ftsb">Select Collections</label>
                                <div class="selectcont rnd4">
                                    <vz-select 
                                        v-if="collectionOptions"
                                        :multiple="true" 
                                        track-by="id" 
                                        empty-selection-text="Choose Collection"
                                        selected-title="Collections"
                                        v-model="programBoardCollections" 
                                        :options="collectionOptions"
                                        value-type="object"
                                        placeholder="Choose Collection"
                                        @select="onPiBoardCollectionSelectValue"
                                        :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                    />
                                </div>
                                <div class="selected-tags">
	                                <div v-for="collection in programBoardCollections" :key="collection.id" class="bxtagG">
	                                    {{collection.title}}
	                                    <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removePIBoardCollection(collection)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
	                                </div>
	                            </div>
                            </div>
                            <div class="form-section statusDrop create-collab-association">
                                <label class="form-label ftsb">Select Program Boards</label>
                                <div class="selectcont rnd4">
                                <vz-select 
                                    v-if="boardsOptions"
                                    :multiple="true" 
                                    track-by="id" 
                                    empty-selection-text="Choose Program Boards"
                                    selected-title="Program Boards"
                                    v-model="boardData.piBoards" 
                                    :options="boardsOptions"
                                    class="multi-filter" 
                                    value-type="object"
                                    placeholder="Choose Program Boards"
                                    @select="onPiBoardSelectValue"
                                    :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                /></div>
                                <div class="selected-tags">
	                                <div v-for="board in boardData.piBoards" :key="board.id" class="bxtagG">
	                                    {{board.title}}
	                                    <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeBoard(board)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
	                                </div>
	                            </div>
                            </div>
                           

                            <div class="additional-associations">
                                <label class="custom-checkbox DFA mb-10">
                                    <input
    									id="showAssociations"
                                        type="checkbox" 
                                        v-model="showAdditionalAssociations"
                                        :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                    >
                                    <label for="showAssociations">Add additional associations</label>
                                    <span class="infotxt tooltip mht nw2 nwhv ml-10">
                                    	<span class="hovtooltipB wdt3">Enable this option to associate the Collaboration Board with additional contexts within Program Board</span>
                                    </span>
                                </label>

                                <!-- Additional Linking Options -->
                                <div class="form-section selectcont rnd4 statusDrop create-collab-association" v-if="showAdditionalAssociations">
                                    <vz-select 
                                        v-if="additionaLinkingOptions"
                                        :multiple="true" 
                                        track-by="id" 
                                        empty-selection-text="Additional Linkings"
                                        selected-title="Additional Linkings"
                                        v-model="boardData.additionalLinkings" 
                                        :options="additionaLinkingOptions"
                                        class="multi-filter" 
                                        value-type="value"
                                        placeholder="Multi-Select"
                                        @select="onAdditionalLinkingSelectValue"
                                        :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                    />                                    
                                </div>
                                <div class="selected-tags" :class="{'has-selections': selectedAdditionalLinkings.length > 0}">
                                    <div v-for="linking in selectedAdditionalLinkings" :key="linking.id" class="bxtagG">
                                        {{linking.title}}
                                        <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeAdditionalLinking(linking)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
                                    </div>
                                </div>

                                <!-- Team Selection -->
                                <div class="form-section selectcont rnd4 statusDrop create-collab-association team-selection" v-if="showAdditionalAssociations && boardData?.additionalLinkings?.includes('teams')">
                                    <vz-select 
                                        v-if="teamSessionOptions"
                                        :multiple="true"
                                        label="label"                         
                                        track-by="id"
                                        empty-selection-text="Teams"
                                        selected-title="Teams"
                                        v-model="boardData.teams"
                                        :options="teamSessionOptions"
                                        class="multi-filter"
                                        value-type="object"
                                        placeholder="Multi-Select"
                                        :groups-enabled="true"
                                        group-label="label"                  
                                        group-values="children"               
                                        :show-select-all="true"               
                                        :show-select-all-on-group="true"
                                        option-title="label"                  
                                        @select="onTeamSelectValue"
                                        :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                    />
                                    <!-- Selected Teams Tags -->                                    
                                </div>
                                <div class="selected-tags" v-if="selectedTeams.length > 0 && boardData.additionalLinkings.includes('teams')">
                                    <div v-for="team in selectedTeams" :key="team.id" class="bxtagG tooltip">
                                        {{ team.label }}
                                        <span class="session-indicator hovtooltip">{{ team.sessionTitle }}</span>
                                        <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeTeam(team)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Solution Board Section -->
                    <div class="association-section" :class="{ 
                        disabled: !permissions.ALLOW_ASSOCIATION_COLLAB_BOARD,
                        'association-section-validation-error': validationErrors.associationSections
                    }">
                        <div class="section-header ftsb" @click="toggleSection('solution')">
                            <i class="ti-angle-right" :class="{ expanded: expandedSections.solution }"></i>
                            Solution Board ({{ boardData?.solutionBoards?.length ?? 0 }})
                        </div>
                        <div class="section-content" v-if="expandedSections.solution">
                            <div class="session-coll-drop">
                                <label class="form-label ftsb">Select Collections</label>
                                <div class="selectcont rnd4">
                                    <vz-select 
                                        v-if="solutionCollectionOptions"
                                        :multiple="true" 
                                        track-by="id" 
                                        empty-selection-text="Choose Collection"
                                        selected-title="Collections"
                                        v-model="solutionBoardCollections" 
                                        :options="solutionCollectionOptions"
                                        value-type="object"
                                        placeholder="Choose Collection"
                                        @select="onSolutionBoardCollectionSelectValue"
                                        :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                    />
                                </div>
                                <div class="selected-tags">
                                    <div v-for="collection in solutionBoardCollections" :key="collection.id" class="bxtagG">
                                        {{collection.title}}
                                        <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeSolutionBoardCollection(collection)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
                                    </div>
                                </div>
                             </div>
                        
                            <div class="form-section statusDrop sol-drop">
                                <label class="form-label ftsb">Select Solution Boards</label>
                                <div class="selectcont rnd4">
                                <vz-select 
                                    v-if="solutionBoardOptions"
                                    :multiple="true" 
                                    track-by="id" 
                                    empty-selection-text="Choose Solution Boards"
                                    selected-title="Solution Boards"
                                    v-model="boardData.solutionBoards" 
                                    :options="solutionBoardOptions"
                                    class="multi-filter" 
                                    value-type="value"
                                    placeholder="Choose Solution Boards"
                                    @select="onSolutionBoardSelectValue"
                                    :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                />
                                </div>
                                <div class="selected-tags">
	                                <div v-for="board in selectedSolutionBoards" :key="board.id" class="bxtagG">
	                                    {{board.title}}
	                                    <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeSolutionBoard(board)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
	                                </div>
	                            </div>
                            </div>
                            
                        </div>
                    </div>

                    <!-- Collections Section -->
                    <div class="association-section" :class="{ 
                        disabled: !permissions.ALLOW_ASSOCIATION_COLLAB_BOARD,
                        'association-section-validation-error': validationErrors.associationSections
                    }">
                        <div class="section-header ftsb" @click="toggleSection('collections')">
                            <i class="ti-angle-right" :class="{ expanded: expandedSections.collections }"></i>
                            Collections ({{boardData.collections?.length}})
                        </div>
                        <div class="section-content" v-if="expandedSections.collections">
                            <div class="form-section statusDrop b">
                                <label class="form-label ftsb">Select Collections</label>
                                <div class="selectcont rnd4">
                                <vz-select 
                                    v-if="collectionOptions"
                                    :multiple="true" 
                                    track-by="id" 
                                    empty-selection-text="Choose Collections"
                                    selected-title="Collections"
                                    v-model="boardData.collections" 
                                    :options="collectionOptions"
                                    class="multi-filter" 
                                    value-type="value"
                                    placeholder="Choose Collections"
                                    :disabled="!permissions.ALLOW_ASSOCIATION_COLLAB_BOARD"
                                />
                                </div>
                            
	                            <div class="selected-tags">
	                                <div v-for="collection in selectedCollections" :key="collection.id" class="bxtagG">
	                                    {{collection.title}}
	                                    <a href="javascript:void(0);" class="remove-tag" title="remove" @click="removeCollection(collection)" v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD">×</a>
	                                </div>
	                            </div>
                            </div>
                        </div>
                    </div>

                    <button class="create-back-btn rnd4" @click="currentTab = 'basic-info'">
                        ← Back to Details
                    </button>
                </div>
                </div>

                <!-- Footer Actions -->
                <div class="modal-footer rec btn">
                    <a href="javascript:void(0);" class="cncl FR mr-0" @click="onCancel">Cancel</a>
                    <button 
                        v-if="permissions.ALLOW_ASSOCIATION_COLLAB_BOARD || permissions.EDIT_COLLAB_BOARD || permissions.CREATE_COLLAB_BOARD"
                        type="button" 
                        class="rnd4" 
                        @click="onSave" 
                    >
                        {{ !isEditMode 
                          ? 'Create Board' 
                          : (editBoard?.id ? 'Update Board' : 'Copy Board') }}
                    </button>
                </div>
            </div>
        </div>
    `,

    props: {
        solutionArea:{
            type: Array,
            default: () => []
        },
        listContext:{
            type: Object,
            default: () => ({})
        },
        availablePiBoards: {
            type: Array,
            default: () => []
        },
        availableTeams: {
            type: Array,
            default: () => []
        },
        contextType: {
            type: String,
            default: ""
        },
        contextTitle: {
            type: String,
            default: ""
        },
        sessionId: {
            type: String,
            default: ""
        },
        board: {
            type: Object,
            default: () => ({})
        },
        editBoard: {
            type: Object,
            default: {}
        },
        subContext: {
            type: String,
            default: ""
        },
        teamId: {
            type: [Object, String, Number],
            default: null
        },
        solutionId: {
            type: String,
            default: ""
        },
        workspaceId: {
            type: String,
            default: ""
        },
        viewType: {
            type: String,
            default: ""
        },
        releaseTrainId: {
            type: String,
            default: ""
        },
        selectedTemplate: {
            type: Object,
            default: null
        },
        allBoards:{
            type: Array,
            default: () => []
        },
        unfilteredLinks:{
            type: Array,
            default: () => []
        },
        collections:{
            type: Object,
            default: null
        },
        activeSolutionBoard:{
            type: Object,
            default: null
        },
        solutionBoards:{
            type: Array,
            default: () => []
        },
        links: {
            type: Array,
            default: () => []
        },
        collectionAssociatedSolBoards:{
            type: Array,
            default: () => []
        },
        collectionAssociatedProgramBoards:{
            type: Array,
            default: () => []
        },
        selectedLink:{
            type: String,
            default: ""
        },
        selectedTeam:{
            type: String,
            default: ""
        },
        selectedPiBoard:{
            type: String,
            default: ""
        },
        permissions: {
            type: Object,
            default: () => ({
                CREATE_COLLAB_BOARD: false,
                EDIT_COLLAB_BOARD: false,
                DELETE_COLLAB_BOARD: false,
                ALLOW_ASSOCIATION_COLLAB_BOARD: false,
                MOVE_COLLAB_BOARD_TO_OTHER_TYPE: false
            })
        }
    },


    computed:{
        isLoading() {
            return this.isLoadingBoards || this.isLoadingSolutions || this.isLoadingCollections;
        },
        teamSessionOptions() {
            const selectedBoards = this.boardData.piBoards;
            if (!selectedBoards || !Array.isArray(selectedBoards) || selectedBoards?.length === 0) {
                return [];
            }

            // Create a map of unique boards with their teams
            const boardsMap = new Map();

            selectedBoards.forEach(selectedBoard => {
                if (!selectedBoard || !selectedBoard.id) return;

                // If we already processed this board, skip
                if (boardsMap.has(selectedBoard.id)) return;

                const boardWithTeams = this.allBoards.find(b =>
                    b.session && b.session.id === selectedBoard.id
                );

                if (!boardWithTeams) return;

                boardsMap.set(selectedBoard.id, {
                    id: selectedBoard.id,
                    label: selectedBoard.title || boardWithTeams.session.title,
                    boardId: selectedBoard.boardId || boardWithTeams.id,
                    teams: boardWithTeams.teams || []
                });
            });

            // Convert map to array and create options
            return Array.from(boardsMap.values()).map(board => ({
                id: board.id,
                label: board.label,
                children: board.teams.map(team => ({
                    sessionId: board.id,
                    boardId: board.boardId,
                    teamId: team.id,
                    id: `${board.id}_${team.id}`,
                    label: team.title
                }))
            }));
        },
        hasSelectedAssociations() {
            return this.boardData.associations?.length > 0;
        },
        hasValidAssociations() {
            // Check if there are actual selections for the chosen associations
            let hasSelectedItems = false;

            if (this.boardData.piBoards && this.boardData.piBoards?.length > 0) {
                hasSelectedItems = true;
            }
            if (this.boardData.solutionBoards && this.boardData.solutionBoards?.length > 0) {
                hasSelectedItems = true;
            }
            if (this.boardData.collections && this.boardData.collections?.length > 0) {
                hasSelectedItems = true;
            }

            return hasSelectedItems;
        },
        selectedCollections() {
            return this.collectionOptions.filter(opt =>
                this.boardData?.collections?.includes(opt.id)
            );
        },
        selectedSolutionBoards() {
            return this.solutionBoardOptions.filter(opt =>
                this.boardData?.solutionBoards?.includes(opt.id)
            );
        },
        selectedAdditionalLinkings() {
            return this.additionaLinkingOptions.filter(opt =>
                this.boardData.additionalLinkings.includes(opt.id)
            );
        },
        selectedTeams() {
            // Return all selected teams including duplicates with session context
            return this.boardData.teams.map(team => {
                // Find the session/board title for this team
                const sessionBoard = this.allBoards.find(board => board.session && board.session.id === team.sessionId);
                return {
                    ...team,
                    sessionTitle: sessionBoard ? sessionBoard.session.title : 'Unknown Session'
                };
            });
        },
        isValid() {
            return this.boardData.title.trim() && this.boardData.associations?.length > 0;
        },

        getSelectedTypeTitle() {
            if (!this.boardData.selectedType) {
                return 'General';
            }
            
            // Handle both object and string types
            const typeId = typeof this.boardData.selectedType === 'object' ? this.boardData.selectedType.id : this.boardData.selectedType;
            
            // If it's an object with a title, return the title directly
            if (typeof this.boardData.selectedType === 'object' && this.boardData.selectedType.title) {
                return this.boardData.selectedType.title;
            }
            
            // Handle special dropdown types
            if (typeId === 'selectTeams') {
                return 'Teams';
            } else if (typeId === 'selectSessions') {
                return 'Program Boards';
            } else if (typeId === 'selectProgramBoards') {
                return 'Program Boards';
            } else if (typeId === 'selectSolutionBoards') {
                return 'Solution Boards';
            }
            
            // Handle regular types from navigation links
            if (this.navigationLinks && Array.isArray(this.navigationLinks)) {
                const selectedType = this.navigationLinks.find(type => type && type.id === typeId);
                return selectedType && selectedType.title ? selectedType.title : 'General';
            }
            
            return 'General';
        },

        getTeamsDropdownTitle() {
            if (this.isDefaultTeamSelection && this.chosenTeams && this.chosenTeams.length === this.sessionTeams.length) {
                return 'All Teams (Default)';
            }
            return 'Teams Selected';
        }
    },

    created(){
        this.setColorAndPattern();
        this.additionaLinkingOptions.push({id: "teams", title: "Teams"});
        this.additionaLinkingOptions.push({id: "inspect-adapt", title: "Inspect & Adapt"});
        this.loadAssociationOptions();

        // Set edit mode based on whether editBoard is provided
        this.isEditMode = this.editBoard && Object.keys(this.editBoard)?.length > 0;

        this.$nextTick(() => {
            if(this.contextType === "session"){
                this.boardData.associations.push("piboard");
            }else if(this.contextType === "solution"){
                this.boardData.associations.push('solutionboard')
            }else if(this.viewType){
                this.boardData.associations.push('collections');
            }
        });

        // Initialize data and handle edit mode
            this.fetchContextTypes()
            // Control moves here only after fetchContextTypes completes
            if (this.editBoard && Object.keys(this.editBoard)?.length > 0) {
                this.initializeRequiredData();
                this.$nextTick(() => {
                    this.editDataSelection();
                });
            }
            else {
                this.initializeRequiredData();
                // Set the selected type based on the selectedLink prop
                this.setSelectedTypeFromLink();

                // Add a retry mechanism for collection context to ensure selected type is set
                if ((this.viewType) && this.selectedLink) {
                    this.$nextTick(() => {
                        // Retry after a short delay to ensure all data is loaded
                        setTimeout(() => {
                            this.setSelectedTypeFromLink();
                        }, 500);
                    });
                }
            }
        // });
                		
        if (this.isEditMode) {
            if(this.editBoard?.id){
                this.popupTitle = "Edit Collab Board";
            }else{
                this.popupTitle = "Copy Collab Board";
            }
		}
		else if (this.selectedTemplate && (this.selectedTemplate.id || this.selectedTemplate.title == "Planning Retro Template")) {
			this.popupTitle = this.selectedTemplate.title;
			this.boardData.description = this.selectedTemplate.description || '';
		}
		else {
			this.popupTitle = "Create New Collab Board";
		}
        
        if (this.selectedTemplate && (this.selectedTemplate.id || this.selectedTemplate.title == "Planning Retro Template")) {
			this.boardData.title = this.contextTitle+" - "+this.selectedTemplate.title;
		}
    },

    mounted() {
        if(this.contextType === "solution"){
            let payload = {};
            if(!this.activeSolutionBoard?.workSpace && !this.activeSolutionBoard?.solutionArea){
                payload = {id: "-1", title: "Legacy Solution Boards"};
                this.solutionBoardCollections = [payload];
            }else if(this.activeSolutionBoard?.solutionArea){
                payload = {id: this.activeSolutionBoard?.solutionArea?.id, title: this.activeSolutionBoard?.solutionArea?.title , linkedCollections: this.activeSolutionBoard?.solutionArea?.linkedCollections};
                this.solutionBoardCollections = [payload];
            }else{
                payload = {id: this.activeSolutionBoard?.workSpace?.id, title: this.activeSolutionBoard?.workSpace?.title};
                this.solutionBoardCollections = [payload];
            }
            if(!this.editBoard || Object.keys(this.editBoard)?.length === 0) {
                this.onSolutionBoardCollectionSelectValue([payload]);
            }
        }

        // this.navigationLinks = this.links;
        if(this.contextType === "session"){
            this.programBoardCollections = [{id: this.board.session.workSpace?.id, title: this.board.session.workSpace?.title}];
            this.onPiBoardCollectionSelectValue([this.board.session.workSpace]);
        }
    },

    data() {
        return {
            backgroundColors: [],
            selectedColor: '',
            selectedPattern: '',
            backgroundPattern: [],
            contextBoard: {},
			popupTitle: "",
            allLinks : [],
            solutionCollectionOptions: [],
            autoAddedCollectionIds: new Set(),
            autoAddedSolutionBoardIds: new Set(),
            isLoadingBoards: false,
            isLoadingSolutions: false,
            isLoadingCollections: false,
            // sharing
            editTeamOptions: [],
            viewToken: null,
            editToken: null,
            baseUrl: window.location.origin,
            publicViewLink: '',
            publicEditLink: '',
            searchedUsers: [],
            programBoardCollections: [],
            solutionBoardCollections: [],
            userSearchLoading: false,
            showPublicLinks: false,

            selectedUsers: [],
            additionaLinkingOptions: [],
            teamOptions: [],
            teamOptionsBySession: [],
            boardsOptions: [],
            associationOptions: [],
            // allBoards: [],
            allBoardsMap: {},
            // solutionBoards: [],
            solutionBoardOptions: [],
            collectionOptions: [],
            // collections: [],
            workSpaceAccessRoles : [],
            currentTab: 'basic-info',
            saving: false,
            userSearchQuery: '',
            isEditMode: false, // Add missing isEditMode property
            boardData: {
                collections: [],
                additionalLinkings: [],
                teams: [],
                title: '',
                description: '',
                selectedTags: [],
                associations: [],
                piBoards: [],
                solutionBoards: [],
                selectedTeams: [],
                publicView: false,
                publicEdit: false,
                privateBoard: false,
                selectedType: 'general' // Added for type selection
            },
            validationErrors: {
                title: false,
                description: false,
                associations: false,
                associationSections: false,
                associate: false
            },
            navigationLinks: [],
            teams: [],
            expandedSections: {
                program: false,
                solution: false,
                collections: false
            },
            showAdditionalAssociations: false,
            // Team selection for session context
            showTeamDropdown: false,
            sessionTeams: [],
            chosenTeams: [],
            // Session selection for solution context
            showSessionDropdown: false,
            solutionSessions: [],
            chosenSession: null,
            // Collection board selection for workspace context
            showProgramBoardDropdown: false,
            collectionProgramBoards: [],
            chosenProgramBoard: null,
            showSolutionBoardDropdown: false,
            collectionSolBoards: [],
            chosenSolutionBoard: null,
            isSyncingTeams: false,
            isDefaultTeamSelection: true, // Track if teams are in default state (all selected)
        }
    },


    watch: {
        'boardData.title'(newVal) {
            // Clear title validation error when user starts typing
            if (newVal && newVal.trim() && this.validationErrors.title) {
                this.validationErrors.title = false;
            }
        },

        'boardData.description'(newVal) {
            // Clear description validation error when user starts typing
            if (newVal && newVal.trim() && this.validationErrors.description) {
                this.validationErrors.description = false;
            }
        },

        showAdditionalAssociations(newVal) {
            if (!newVal) {
                // Clear additional selections when checkbox is unchecked
                this.boardData.additionalLinkings = [];
                this.boardData.teams = [];
            }
        },

        // Watch for changes in selectedType to handle Inspect and Adapt special case
        'boardData.selectedType': {
            handler(newVal) {
                if (newVal) {
                    const typeId = typeof newVal === 'object' ? newVal.id : newVal;
                    if (typeId === 'inspect') {
                    }
                    // Handle "Select Teams" option for session context
                    if (typeId === 'selectTeams' && this.contextType === "session") {
                        this.showTeamDropdown = true;
                        this.populateSessionTeams();
                        this.chosenTeams = this.sessionTeams.slice();
                        this.$nextTick(() => {
                            this.syncTeamsToAdditionalLinks();
                        });
                        this.showSessionDropdown = false;
                        this.chosenSession = null;
                        this.showProgramBoardDropdown = false;
                        this.chosenProgramBoard = null;
                        this.showSolutionBoardDropdown = false;
                        this.chosenSolutionBoard = null;
                    }
                    // Handle "Select Sessions" option for solution context
                    else if (typeId === 'selectSessions' && this.contextType === "solution") {
                        this.showSessionDropdown = true;
                        this.populateSolutionSessions();
                        this.showTeamDropdown = false;
                        this.chosenTeams = [];
                        this.showProgramBoardDropdown = false;
                        this.chosenProgramBoard = null;
                        this.showSolutionBoardDropdown = false;
                        this.chosenSolutionBoard = null;
                    }
                    // Handle "Select Program Boards" option for collection context
                    else if (typeId === 'selectProgramBoards' && (this.viewType)) {
                        this.showProgramBoardDropdown = true;
                        this.populateCollectionProgramBoards();
                        this.showTeamDropdown = false;
                        this.chosenTeams = [];
                        this.showSessionDropdown = false;
                        this.chosenSession = null;
                        this.showSolutionBoardDropdown = false;
                        this.chosenSolutionBoard = null;
                    }
                    // Handle "Select Solution Boards" option for collection context
                    else if (typeId === 'selectSolutionBoards' && (this.viewType)) {
                        this.showSolutionBoardDropdown = true;
                        this.populateCollectionSolutionBoards();
                        this.showTeamDropdown = false;
                        this.chosenTeams = [];
                        this.showSessionDropdown = false;
                        this.chosenSession = null;
                        this.showProgramBoardDropdown = false;
                        this.chosenProgramBoard = null;
                    }
                    else {
                        this.showTeamDropdown = false;
                        this.chosenTeams = [];
                        // this.showSessionDropdown = false;
                        // this.chosenSession = null;
                        // this.showProgramBoardDropdown = false;
                        // this.chosenProgramBoard = null;
                        // this.showSolutionBoardDropdown = false;
                        // this.chosenSolutionBoard = null;
                    }
                }
            },
            deep: true
        },

        // Watch for collection data to be loaded and set selected type
        'collectionAssociatedSolBoards': {
            handler(newVal) {
                if (newVal && newVal.length > 0 && this.selectedLink && !this.editBoard) {
                    this.$nextTick(() => {
                        this.setSelectedTypeFromLink();
                    });
                }
            },
            deep: true
        },

        'collectionAssociatedProgramBoards': {
            handler(newVal) {
                if (newVal && newVal.length > 0 && this.selectedLink && !this.editBoard) {
                    this.$nextTick(() => {
                        this.setSelectedTypeFromLink();
                    });
                }
            },
            deep: true
        },

        // Watch for changes in listContext to update selected type
        listContext: {
            handler(newVal) {
                if (newVal && newVal.type && this.navigationLinks && this.navigationLinks.length > 0) {
                    this.$nextTick(() => {
                        this.setSelectedTypeFromLink();
                    });
                }
            },
            deep: true,
            immediate: true
        },

        chosenTeams: {
            handler(newVal, oldVal) {
                if (!this.isSyncingTeams && this.contextType === "session" && 
                    newVal !== oldVal && newVal && oldVal) {
                    // Once user has interacted, never go back to default state
                    if (this.isDefaultTeamSelection && newVal.length !== this.sessionTeams.length) {
                        this.isDefaultTeamSelection = false;
                    }
                    // Note: We don't set isDefaultTeamSelection back to true even if all teams are selected again
                    this.syncTeamsToAdditionalLinks();
                }
            },
            deep: true
        }
    },

    methods: {

        setColorAndPattern: function (){
            this.backgroundColors = ["#EEEEEE", "#B4BDC2", "#2A3135", "#FFF9E7", "#EFF6E9", "#E2F6FA", "#ECE7F4", "#F9E5EC","#E2F2F0"];
            this.backgroundPattern = [
                {
                    title: 'lines',
                    value: 'lines',
                    url2: "/assets/icons/collab/bgguid.svg"
                },
                {
                    title: 'dotted',
                    value: 'dotted',
                    url2: "/assets/icons/collab/bggrid.svg"
                },
                {
                    title: 'plain',
                    value: 'plain',
                    url2: "/assets/icons/collab/bgguid1.svg"
                }
            ];
            if(this.editBoard && Object.keys(this.editBoard).length > 0){
                this.selectedColor = this.editBoard.backgroundColor;
                this.selectedPattern = this.editBoard.backgroundPattern;
            }else {
                this.selectedColor = this.backgroundColors[0];
                this.selectedPattern = this.backgroundPattern[0].value;
            }
        },

        onSelectColor: function (color) {
            // Check permission before allowing color change in edit mode
            if (this.isEditMode && !this.permissions.EDIT_COLLAB_BOARD) {
                // showTopMessage('You don\'t have permission to change background color', 'error');
                return;
            }
            this.selectedColor = color;
        },
        onSelectPattern: function (pattern) {
            // Check permission before allowing pattern change in edit mode
            if (this.isEditMode && !this.permissions.EDIT_COLLAB_BOARD) {
                // showTopMessage('You don\'t have permission to change background pattern', 'error');
                return;
            }
            this.selectedPattern = pattern;
        },

        onPiBoardCollectionSelectValue: function (data){
            let payload = {};
            payload.requestId = getNewUUID();
            payload.workSpacesIds = data.map(col => col.id);

            this.boardsOptions = [];

            // Clear validation error when collections are selected
            if (data && data.length > 0) {
                this.validationErrors.associations = false;
                this.validationErrors.associationSections = false;
            }
            axios.post('plan/boards', payload)
                .then(response => {
                    if (response.data?.parentBoards) {
                        response.data.parentBoards.forEach(board => {
                            const piBoard = {
                                id: board?.session?.id,
                                title: board?.session?.title,
                                boardId: board?.id,
                                teams: board?.teams
                            };
                            const exists = this.boardsOptions.some(b => b.boardId === piBoard.boardId);
                            if (!exists) {
                                this.boardsOptions.push(piBoard);
                            }
                        });

                        // Remove boards from boardData.piBoards that are not in the new options
                        const availableBoardIds = this.boardsOptions.map(board => board.id);
                        this.boardData.piBoards = this.boardData.piBoards.filter(board =>
                            availableBoardIds.includes(board.id)
                        );
                    }
                })
                .catch(error => {
                    console.error('Error searching users:', error);
                    showTopMessage('Failed to fetch boards related to collection', 'error');
                })
        },

        onSolutionBoardCollectionSelectValue: function (data){
            let payload = {};
            payload.solutionAreaId = [];
            payload.collectionId = [];
            // this.boardData.solutionBoards = [];
            // payload.solutionAreaId
            // payload.collectionId
            data.forEach(selCol => {
                if(selCol?.linkedCollections){
                    payload.solutionAreaId.push(selCol?.id);
                }else{
                    payload.collectionId.push(selCol?.id);
                }
            });
            this.solutionBoardOptions = [];

            // Clear validation error when collections are selected
            if (data && data.length > 0) {
                this.validationErrors.associations = false;
                this.validationErrors.associationSections = false;
            }

            axios.post('/solutionarea/getSolutionBoards/solArea/collections', payload)
                .then(response => {
                    if (response.data && response.data.boards) {
                        response.data.boards.forEach(board => {
                            const solutionBoard = {
                                id: board?.id,
                                title: board?.title
                            };

                            if (this.contextType === "solution" && board.id === this.solutionId) {
                                if (!this.boardData.solutionBoards.includes(board.id)) {
                                    this.boardData.solutionBoards.push(board.id);
                                }
                            }

                            this.solutionBoardOptions.push(solutionBoard);
                        });

                        // Remove boards from boardData.solutionBoards that are not in the new options
                        const availableBoardIds = this.solutionBoardOptions.map(board => board.id);
                        this.boardData.solutionBoards = this.boardData.solutionBoards.filter(board =>
                            availableBoardIds.includes(board)
                        );
                    }
                })
                .catch(error => {
                    console.error('Error searching users:', error);
                    showTopMessage('Failed to fetch solution boards related to collection', 'error');
                })
        },

        // Helper function to get the actual title from collaborationType
        getActualTitle: function(collaborationType) {

            // If title looks like an ID (long alphanumeric string), try to find the actual title from allLinks
            if (this.allLinks && this.allLinks.length > 0) {
                const matchingLink = this.allLinks.find(link => link.id === collaborationType.title);
                if (matchingLink) {
                    return matchingLink.title;
                }
            }

            return collaborationType.title;
        },

        fetchContextTypes: function (){
            // return new Promise((resolve, reject) => {
                let data = {};
                let fetchedLinks = [];

                if(this.contextType === "session") {
                    if(!this.sessionId) {
                        const params = new URLSearchParams(window.location.search);
                        const sessionId = params.get('id');
                        id = sessionId;
                        data.origin = "sessionBoard";
                    }else{
                        id = this.sessionId;
                    }
                } else if(this.contextType === "solution") {
                    id = this.solutionId;
                } else if(this.viewType) {
                    id = this.releaseTrainId;
                }

                data.context = this.contextType;

                if(this.viewType){
                    data.context = "workspace";
                }

                // axios.post(`/collaboration-type/context/${id}`, data)
                //     .then(response => {
                //         if (response.data.success) {
                            // First, add all fetched types to fetchedLinks
                            this.unfilteredLinks.forEach(type => {
                                this.allLinks = this.unfilteredLinks;
                                if(!type.defaultOrigin){
                                    fetchedLinks.push({id: type?.id, title: type?.title, rowStatus: type?.rowStatus})
                                }
                            });

                            // Now apply the filtering logic to get the latest status
                            if(this.editBoard && Object.keys(this.editBoard).length > 0){
                                // In edit mode, only filter deleted custom types
                                this.navigationLinks = fetchedLinks.filter(link => {
                                    // Only check rowStatus for custom types (not default types)
                                    const isDefaultType = link.id === "general" || link.id === "inspect" || link.id === "teams";

                                    if (!isDefaultType && link.rowStatus === 1) {
                                        // Check if this deleted custom type is the one attached to the current board
                                        if (this.editBoard.collaborationType && this.editBoard.collaborationType.id === link.id) {
                                            return true; // Keep it if it's attached to the current board
                                        }
                                        return false; // Remove other deleted custom types
                                    }

                                    return true; // Keep all default types and non-deleted custom types
                                });

                                // In edit mode, ensure the board's actual collaboration type is available in navigationLinks
                                // in case of diff context types show that types always in edit case.
                                if (this.editBoard.collaborationType && this.editBoard.collaborationType.id) {
                                    if(this.editBoard.collaborationType?.defaultOrigin){
                                        if(["session", "sessionInspect", "sessionTeam"].includes(this.editBoard.collaborationType?.defaultOrigin)
                                            && this.contextType !== "session"){
                                            let actualTitle = this.getActualTitle(this.editBoard.collaborationType);
                                            // Add the board's type to navigationLinks if it's not already there
                                            this.navigationLinks.push({
                                                id: this.editBoard.collaborationType.id,
                                                title: actualTitle,
                                                rowStatus: this.editBoard.collaborationType.rowStatus || 0
                                            });
                                        }else if(["solutionPiBoard", "solution"].includes(this.editBoard.collaborationType?.defaultOrigin)
                                            && this.contextType !== "solution"){
                                            this.navigationLinks.push({
                                                id: this.editBoard.collaborationType.id,
                                                title: actualTitle,
                                                rowStatus: this.editBoard.collaborationType.rowStatus || 0
                                            });
                                        }else if(["workspace", "workspaceSolutionBoard", "workspacePiBoard"].includes(this.editBoard.collaborationType?.defaultOrigin)
                                            && !this.viewType) {
                                            this.navigationLinks.push({
                                                id: this.editBoard.collaborationType.id,
                                                title: actualTitle,
                                                rowStatus: this.editBoard.collaborationType.rowStatus || 0
                                            });
                                        }

                                    }else {
                                        const boardTypeExists = this.allLinks.some(link => link.id == this.editBoard.collaborationType.id);
                                        if (!boardTypeExists) {
                                            // Find the actual title from allLinks if title contains an ID
                                            let actualTitle = this.getActualTitle(this.editBoard.collaborationType);
                                            // Add the board's type to navigationLinks if it's not already there


                                            this.navigationLinks.push({
                                                id: this.editBoard.collaborationType.id,
                                                title: actualTitle,
                                                rowStatus: this.editBoard.collaborationType.rowStatus || 0
                                            });
                                        }
                                    }
                                }else{  // No type case
                                    const entries = Object.entries(this.editBoard.context);
                                    entries.forEach(([key, value]) => {
                                        if(key === "session") {
                                            this.fetchContextBoard(value);
                                        }
                                    });
                                //     fetch session and its team mainly team and show them.
                                }

                            } else {
                                // In create mode, remove teams and deleted custom types
                                this.navigationLinks = fetchedLinks.filter(link => {
                                    if (link?.id === "teams") {
                                        return false;
                                    }

                                    // Only check rowStatus for custom types (not default types)
                                    const isDefaultType = link.id === "general" || link.id === "inspect" || link.id === "teams";

                                    if (!isDefaultType && link.rowStatus === 1) {
                                        return false; // Remove deleted custom types
                                    }

                                    return true; // Keep all default types and non-deleted custom types
                                });
                            }

                            // Add teams from the board
                            // need to chack where logic goes also need to show teams dropdown for that.
                            if(this.contextType === "session") {
                                this.navigationLinks.push({id:"general", title:"General"})
                                this.navigationLinks.push({id:"inspect", title:"Inspect and Adapt"})
                                // Add "Teams" option instead of individual teams
                                if(this.board?.teams && this.board.teams.length > 0) {
                                    this.navigationLinks.push({id:"selectTeams", title:this.board?.session?.teamsLabel, identifier: "selectTeams"});
                                }
                            }else if(this.contextType === "solution"){
                                this.navigationLinks.push({id:"general", title:"General"})
                                // Add "Program Boards" option instead of individual sessions
                                // if(this.activeSolutionBoard?.piBoards && this.activeSolutionBoard.piBoards.length > 0) {
                                //     this.navigationLinks.push({id:"selectSessions", title:"Program Boards", identifier: "selectSessions"});
                                // }
                            }
                            else if(this.viewType){
                                this.navigationLinks.push({id:"general", title:"General"})
                                // Add "Program Boards" option instead of individual program boards
                                // if(this.collectionAssociatedProgramBoards && this.collectionAssociatedProgramBoards.length > 0) {
                                //     this.navigationLinks.push({id:"selectProgramBoards", title:"Program Boards", identifier: "selectProgramBoards"});
                                // }
                                // Add "Solution Boards" option instead of individual solution boards
                                // if(this.collectionAssociatedSolBoards && this.collectionAssociatedSolBoards.length > 0) {
                                //     this.navigationLinks.push({id:"selectSolutionBoards", title:"Solution Boards", identifier: "selectSolutionBoards"});
                                // }
                            }

            //             }
            //             resolve(); // Resolve the promise when everything is complete
            //         })
            //         .catch(error => {
            //             console.error('Error loading solution boards:', error);
            //             reject(error); // Reject the promise if there's an error
            //         });
            // });
        },

        initializeRequiredData() {
            this.loadAllBoards()
            this.isLoadingBoards = false;

            // this.loadSolutionBoards()
            this.isLoadingSolutions = false;

            this.fetchReleaseTrains()
            this.isLoadingCollections = false;

            // if (this.editBoard) {
            //     if (!this.allBoards || !this.allBoards.length) {
            //         throw new Error('Failed to load boards data');
            //     }
            //     if (!this.solutionBoards) {
            //         throw new Error('Failed to load solution boards');
            //     }
            //     if (!this.collections || !this.collections.workspaces) {
            //         throw new Error('Failed to load collections');
            //     }
            // }

            return true;
        },

        fetchContextBoard(id) {

            axios.get(`/plan/getBoard/${id}`)
                .then(response => {
                    if (response.data.board) {
                        this.contextBoard = response.data.board

                        if (!this.navigationLinks.some(link => link.id === "selectTeams")) {
                            this.navigationLinks.push({
                                id: "selectTeams",
                                title: this.contextBoard.session?.teamsLabel,
                                rowStatus: 0
                            });
                        }
                        this.populateSessionTeams(this.contextBoard);
                        this.showTeamDropdown = true;
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'selectTeams') || 'selectTeams';

                        // flatten all team IDs from piTeamArea
                        const teamIds = Object.values(this.editBoard.piTeamArea || {}).flat();

                        const selectedTeams = this.sessionTeams.filter(team => teamIds.includes(team.id));
                        if (selectedTeams) {
                            this.chosenTeams = selectedTeams;
                        }
                    }
                })
                .catch(error => {
                    console.error('Error searching users:', error);
                })
        },

        onBackToTemplates() {
            this.$emit('back-to-templates');
        },

        onPiBoardSelectValue: function (selectedBoard){
            // Clear validation error when program boards are selected
            if (selectedBoard && selectedBoard.length > 0) {
                this.validationErrors.associations = false;
                this.validationErrors.associationSections = false;
            }
            if(this.boardData?.associations?.includes('collections')) {
                const uniqueIds = new Set(this.boardData.collections);

                selectedBoard.forEach(board => {
                    const b = this.allBoardsMap[board.boardId];
                    const workspace = b?.session?.workSpace;
                    // console.log("workspace is : ", workspace);
                    if (workspace && this.collectionOptions.find(opt => opt.id === workspace.id)) {
                        uniqueIds.add(workspace.id);
                        this.autoAddedCollectionIds.add(workspace.id);
                    }
                    // Set automatically prevents duplicates
                });

                this.boardData.collections = Array.from(uniqueIds);
            }
            
            // NEW LOGIC: If solution boards are enabled, automatically select associated solution boards
            if(this.boardData?.associations?.includes('solutionboard')) {
                const uniqueSolutionBoardIds = new Set(this.boardData.solutionBoards || []);
                selectedBoard.forEach(board => {
                    const b = this.allBoardsMap[board.boardId];
                    const sessionId = b?.session?.id;
                    if (sessionId) {
                        this.solutionBoards.forEach(solutionBoard => {
                            if (solutionBoard.piSessions?.includes(sessionId)) {
                                uniqueSolutionBoardIds.add(solutionBoard.id);
                                this.autoAddedSolutionBoardIds.add(solutionBoard.id);
                            }
                        });
                    }
                });

                this.boardData.solutionBoards = Array.from(uniqueSolutionBoardIds);
            }
        },

        onTeamSelectValue: function(selectedTeams) {
            if (this.contextType === "session" && this.boardData.additionalLinkings.includes('teams')) {
                this.syncTeamsFromAdditionalLinks();
            }
        },

        editDataSelection: function() {
            if (!this.editBoard) {
                // Handle new board creation
                this.$nextTick(() => {
                    // Set associations based on context
                    if(this.contextType === "session") {
                        this.boardData.associations = this.boardData.associations || [];
                        this.boardData.associations.push("piboard");

                        // Handle team selection for session team context
                        if(this.subContext === "sessionTeam" && this.teamId) {
                            this.boardData.additionalLinkings = this.boardData.additionalLinkings || [];
                            this.boardData.additionalLinkings.push("teams");

                            const selectedBoard = this.boardData.piBoards[0];
                            if (selectedBoard) {
                                const boardWithTeams = this.allBoards.find(b =>
                                    b.session && b.session.id === selectedBoard.id
                                );

                                if (boardWithTeams) {
                                    const team = boardWithTeams.teams.find(t => t.id === this.teamId.id);
                                    if (team) {
                                        this.boardData.teams = [{
                                            sessionId: selectedBoard.id,
                                            boardId: selectedBoard.boardId || boardWithTeams.id,
                                            teamId: team.id,
                                            id: `${selectedBoard.id}_${team.id}`,
                                            label: team.title
                                        }];
                                    }
                                }
                            }
                        }
                    } else if(this.contextType === "solution") {
                        this.boardData.associations = this.boardData.associations || [];
                        this.boardData.associations.push('solutionboard');
                    } else if(this.viewType) {
                        this.boardData.associations = this.boardData.associations || [];
                        this.boardData.associations.push('collections');
                    }
                    
                    // Clear validation errors when setting up initial associations
                    this.$nextTick(() => {
                        this.clearValidationErrors();
                    });
                });
                return;
            }


            // Handle edit mode
            this.boardData.title = this.editBoard.title || '';
            this.boardData.description = this.editBoard?.description || '';
            this.boardData.associations = this.extractAssociations(this.editBoard) || [];
            this.boardData.teams = [];
            this.boardData.additionalLinkings = this.extractAdditionalLinkings(this.editBoard) || [];
            
            // Populate collections based on program boards in edit mode (for solution context)
            if (this.editBoard.session && this.editBoard.session.length > 0) {
                const uniqueIds = new Set();
                const programBoardCollectionsArray = [];

                this.editBoard.session.forEach(board => {
                    const workspace = board?.workSpace;
                    if (workspace && !uniqueIds.has(workspace.id)) {
                        uniqueIds.add(workspace.id);
                        programBoardCollectionsArray.push({
                            id: workspace.id,
                            title: workspace.title
                        });
                    }
                });

                this.onPiBoardCollectionSelectValue(programBoardCollectionsArray);
                this.programBoardCollections = programBoardCollectionsArray;
            }

            // Populate collections based on solution boards in edit mode (for solution context)
            if (this.editBoard.solutionBoard && this.editBoard.solutionBoard.length > 0) {
                const uniqueIds = new Set();
                const solutionBoardCollectionsArray = [];

                this.editBoard.solutionBoard.forEach(board => {
                    if (board && board.workSpace) {
                        const workspace = board.workSpace;
                        // console.log("solution workspace is : ", workspace);
                        if (workspace && !uniqueIds.has(workspace.id)) {
                            uniqueIds.add(workspace.id);
                            solutionBoardCollectionsArray.push({
                                id: workspace.id,
                                title: workspace.title
                            });
                        }
                    }else if(!board?.workSpace && !board?.solutionArea){
                        if (!uniqueIds.has("-1")) {
                            uniqueIds.add("-1");
                            solutionBoardCollectionsArray.push({
                                id: "-1",
                                title: "Legacy Solution Boards"
                            });
                        }
                    }else{
                        solutionBoardCollectionsArray.push({
                            id: board?.solutionArea?.id,
                            title: board?.solutionArea?.title,
                            linkedCollections: board?.solutionArea?.linkedCollections
                        });
                    }
                });

                this.onSolutionBoardCollectionSelectValue(solutionBoardCollectionsArray);
                this.solutionBoardCollections = solutionBoardCollectionsArray;
            }


            // Clear validation errors when loading existing data
            this.$nextTick(() => {
                this.clearValidationErrors();
            });

            // Set the selected type from edit board's collaboration type
            if (this.editBoard && this.editBoard.collaborationType && this.navigationLinks && this.navigationLinks.length > 0) {
                // Check if it's a special type based on defaultOrigin
                if (this.editBoard.collaborationType?.defaultOrigin === 'sessionInspect') {
                    this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'inspect') || 'inspect';
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'sessionTeam') {
                    // For team types, set "Select Teams" and populate team dropdown
                    this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'selectTeams') || 'selectTeams';
                    this.showTeamDropdown = true;
                    this.populateSessionTeams();
                    
                    // Find and set the selected team
                    if (this.editBoard.collaborationType.teams) {
                        const sessionId = Object.keys(this.editBoard.collaborationType.teams)[0];
                        if (this.listContext?.id && this.sessionTeams.length > 0) {
                            const selectedTeam = this.sessionTeams.find(team => team.id === this.listContext?.id);
                            if (selectedTeam) {
                                this.chosenTeams = [selectedTeam];
                            }
                        }
                    }
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'solutionPiBoard') {
                    // console.log("sel link is : ",this.selectedLink);
                    // console.log("list context is : ", this.listContext);
                    // For session types in solution context, set "Select Sessions" and populate session dropdown
                    this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'selectSessions') || 'selectSessions';
                    this.showSessionDropdown = true;
                    this.populateSolutionSessions();
                    
                    // Find and set the selected session
                    if (this.editBoard.collaborationType.sessions) {
                        // const sessionIds = this.editBoard.collaborationType.sessions;
                        if (this.listContext?.id && this.solutionSessions.length > 0) {
                            const selectedSession = this.solutionSessions.find(session => session.id === this.listContext?.id);
                            if (selectedSession) {
                                this.chosenSession = selectedSession;
                            }
                        }
                    }
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'workspacePiBoard') {
                    // For program board types in collection context, set "Select Program Boards" and populate dropdown
                    this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'selectProgramBoards') || 'selectProgramBoards';
                    this.showProgramBoardDropdown = true;
                    this.populateCollectionProgramBoards();
                    
                    // Find and set the selected program board
                    if (this.editBoard.collaborationType.sessions) {
                        if (this.listContext?.id && this.collectionProgramBoards.length > 0) {
                            const selectedProgramBoard = this.collectionProgramBoards.find(board => board.id === this.listContext.id);
                            if (selectedProgramBoard) {
                                this.chosenProgramBoard = selectedProgramBoard;
                            }
                        }
                    }
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'workspaceSolutionBoard') {
                    // For solution board types in collection context, set "Select Solution Boards" and populate dropdown
                    this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'selectSolutionBoards') || 'selectSolutionBoards';
                    this.showSolutionBoardDropdown = true;
                    this.populateCollectionSolutionBoards();
                    // Find and set the selected solution board
                    if (this.editBoard.collaborationType.solutionBoards) {
                        if (this.listContext?.id && this.collectionSolBoards.length > 0) {
                            const selectedSolutionBoard = this.collectionSolBoards.find(board => board.id === this.listContext?.id);
                            if (selectedSolutionBoard) {
                                this.chosenSolutionBoard = selectedSolutionBoard;
                            }
                        }
                    }
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'session') {
                    // Check if it's "General" type
                    if (this.editBoard.collaborationType.title === 'General' || this.editBoard.collaborationType.title === 'general') {
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'general') || 'general';
                    } else {
                        // It's a custom type in session context
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === this.editBoard.collaborationType.id) || this.editBoard.collaborationType.id;
                    }
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'solution') {
                    // Check if it's "General" type in solution context
                    if (this.editBoard.collaborationType.title === 'General' || this.editBoard.collaborationType.title === 'general') {
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'general') || 'general';
                    } else {
                        // It's a custom type in solution context
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === this.editBoard.collaborationType.id) || this.editBoard.collaborationType.id;
                    }
                } else if (this.editBoard.collaborationType?.defaultOrigin === 'workspace') {
                    // Check if it's "General" type in workspace context
                    if (this.editBoard.collaborationType.title === 'General' || this.editBoard.collaborationType.title === 'general') {
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === 'general') || 'general';
                    } else {
                        // It's a custom type in workspace context
                        this.boardData.selectedType = this.navigationLinks.find(link => link.id === this.editBoard.collaborationType.id) || this.editBoard.collaborationType.id;
                    }
                } else {
                    // It's a custom type (no defaultOrigin)
                    this.boardData.selectedType = this.navigationLinks.find(link => link.id === this.editBoard.collaborationType.id) || this.editBoard.collaborationType.id;
                }
            } else {
                const key = Object.keys(this.editBoard.context)[0];
                if(key === "session"){
                    const entries = Object.entries(this.editBoard.context);
                    entries.forEach(([key, value]) => {
                        if(key === "session") {
                            this.fetchContextBoard(value);
                        }
                    });
                }else{
                    this.boardData.selectedType = 'general';
                }
            }

            // Automatically check the additional associations checkbox if needed
            if (this.editBoard.piInspectAndAdapt?.length > 0 ||
                (this.editBoard.piTeamArea && Object.keys(this.editBoard.piTeamArea).length > 0)) {
                this.showAdditionalAssociations = true;
            }

            // Set PI Boards with unique entries
            if (this.editBoard.session && Array.isArray(this.editBoard.session)) {
                const uniqueBoards = new Map();
                this.editBoard.session.forEach(session => {
                    if (!session || !session.id) return;
                    if (uniqueBoards.has(session.id)) return;

                    uniqueBoards.set(session.id, {
                        id: session.id,
                        title: session.title,
                        boardId: session.activeSessionBoard || session.id
                    });
                });
                this.boardData.piBoards = Array.from(uniqueBoards.values());
            }

            // Set Solution Boards
            if (this.editBoard.solutionBoard && Array.isArray(this.editBoard.solutionBoard)) {
                this.boardData.solutionBoards = this.editBoard.solutionBoard
                    .filter(sb => sb && sb.id)
                    .map(sb => sb.id);
            }

            // Set Collections
            if (this.editBoard.workSpaces && Array.isArray(this.editBoard.workSpaces)) {
                this.boardData.collections = this.editBoard.workSpaces
                    .filter(ws => ws && ws.id)
                    .map(ws => ws.id);
            }

            // Set Teams from piTeamArea in edit mode
            if (this.editBoard.piTeamArea) {
                // First, create a map of all available teams from selected boards
                const availableTeamsMap = new Map();
                this.boardData.piBoards.forEach(selectedBoard => {
                    const boardWithTeams = this.allBoardsMap[selectedBoard.boardId];
                    if (boardWithTeams && boardWithTeams.teams) {
                        boardWithTeams.teams.forEach(team => {
                            const teamKey = `${selectedBoard.id}_${team.id}`;
                            availableTeamsMap.set(teamKey, {
                                sessionId: selectedBoard.id,
                                boardId: selectedBoard.boardId || boardWithTeams.id,
                                teamId: team.id,
                                id: teamKey,
                                label: team.title
                            });
                        });
                    }
                });

                // Then, select teams that exist in piTeamArea
                Object.entries(this.editBoard.piTeamArea).forEach(([boardId, teamIds]) => {
                    // if (!Array.isArray(teamIds)) return;
                    const board = this.allBoards.find(b => b.session.id === boardId);
                    if (!board || !board.session) return;

                    teamIds.forEach(teamId => {
                        const teamKey = `${board.session.id}_${teamId}`;
                        const teamOption = availableTeamsMap.get(teamKey);

                        if (teamOption) {
                            this.boardData.teams.push(teamOption);
                        }
                    });
                });
            }

            // Ensure teams array is unique
            const uniqueTeams = new Map();
            this.boardData.teams.forEach(team => {
                if (!uniqueTeams.has(team.id)) {
                    uniqueTeams.set(team.id, team);
                }
            });
            this.boardData.teams = Array.from(uniqueTeams.values());

            this.$forceUpdate();
        },

        extractAssociations(board) {
            const associations = [];

            if (board.session && board.session.length > 0) {
                associations.push('piboard');
            }

            if (board.solutionBoard && board.solutionBoard.length > 0) {
                associations.push('solutionboard');
            }

            if (board.workSpaces && board.workSpaces.length > 0) {
                associations.push('collections');
            }

            return associations;
        },

        extractAdditionalLinkings(board) {
            const linkings = [];

            // Check if teams are linked (piTeamArea exists and has data)
            if (board.piTeamArea && Object.keys(board.piTeamArea).length > 0) {
                linkings.push('teams');
            }

            // Check if inspect & adapt is linked
            if (board.piInspectAndAdapt && board.piInspectAndAdapt.length > 0) {
                linkings.push('inspect-adapt');
            }

            return linkings;
        },

        extractTeams(board) {
            const selectedBoard = this.boardData.piBoards;
            if (!selectedBoard || selectedBoard.length === 0) {
                return [];
            }

            // const result = selBoards.map(board => ({
            //     id: board.id,
            //     label: board.title,
            //     children: board.teams ? board.teams.map(team => ({
            //         sessionId: board.id,
            //         boardId: board?.boardId,
            //         teamId: team.id,
            //         id:`${board.id}_${team.id}`,
            //         label: team.title
            //     })) : []
            // }));
            //


            const teams = [];

            if (board.piTeamArea) {
                Object.entries(board.piTeamArea).forEach(([teamAreaKey, teamArray]) => {
                    const board = this.allBoards.find(board => board.id === teamAreaKey);
                    teamArray.forEach(team =>{
                        const selTeam = board.teams.find(team => team.id === team);
                        teams.push({
                            sessionId: board.session.id,
                            boardId: teamAreaKey,
                            teamId: team,
                            id:`${board.session.id}_${team}`,
                            label: selTeam.title
                        });
                    })
                });
            }
            return teams;
        },

        // sharing logic start
        generateViewLink() {
            if (this.boardData.publicView && !this.viewToken) {
                this.viewToken = this.generateUUID();
                this.updatePublicViewLink();
            }
            if (!this.boardData.publicView) {
                this.viewToken = null;
                this.publicViewLink = '';
            }
        },

        generateEditLink() {
            if (this.boardData.publicEdit && !this.editToken) {
                this.editToken = this.generateUUID();
                this.updatePublicEditLink();
            }
            if (!this.boardData.publicEdit) {
                this.editToken = null;
                this.publicEditLink = '';
            }
        },

        // Add these methods to the methods section:
        searchUsers() {
            if (!this.userSearchQuery || this.userSearchQuery.length < 2) {
                this.searchedUsers = [];
                return;
            }

            this.userSearchLoading = true;

            axios.get(`/graphx/users/search?query=${encodeURIComponent(this.userSearchQuery)}`)
                .then(response => {
                    if (response.data.success) {
                        this.searchedUsers = response.data.users || [];
                    }
                })
                .catch(error => {
                    console.error('Error searching users:', error);
                    showTopMessage('Failed to search users', 'error');
                })
                .finally(() => {
                    this.userSearchLoading = false;
                });
        },

        addUserToBoard(user) {
            if (!this.selectedUsers.find(u => u.id === user.id)) {
                this.selectedUsers.push(user);
            }
            this.userSearchQuery = '';
            this.searchedUsers = [];
        },

        removeUserFromBoard(userIndex) {
            this.selectedUsers.splice(userIndex, 1);
        },

        copyPublicLink(linkType) {
            const link = linkType === 'view' ? this.publicViewLink : this.publicEditLink;
            if (link) {
                navigator.clipboard.writeText(link).then(() => {
                    showTopMessage(`${linkType} link copied to clipboard, `, 'success');
                }).catch(() => {
                    // Fallback for older browsers
                    const textArea = document.createElement('textarea');
                    textArea.value = link;
                    document.body.appendChild(textArea);
                    textArea.select();
                    document.execCommand('copy');
                    document.body.removeChild(textArea);
                    showTopMessage(`${linkType} link copied to clipboard catch`, 'success');
                });
            }
        },

        generateUUID() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = Math.random() * 16 | 0,
                    v = c == 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        },

        updatePublicViewLink() {
            if (this.viewToken) {
                this.publicViewLink = `${this.baseUrl}/graphx/public/board/${this.viewToken}`;
            } else {
                this.publicViewLink = '';
            }
        },

        updatePublicEditLink() {
            if (this.editToken) {
                this.publicEditLink = `${this.baseUrl}/graphx/public/board/${this.editToken}`;
            } else {
                this.publicEditLink = '';
            }
        },

        // sharing logic end

        onAdditionalLinkingSelectValue(){
            // console.log("linking opt are : ", this.boardData.additionalLinkings);
        },

        removeAdditionalLinking(linking) {
            // Check permission before allowing additional linking removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.boardData.additionalLinkings.indexOf(linking.id);
            if (index > -1) {
                this.boardData.additionalLinkings.splice(index, 1);
                // If we're removing 'teams', also clear the teams selection
                if (linking.id === 'teams') {
                    this.boardData.teams = [];
                }
            }
        },

        onAssociationSelectValue(){
            const associations = this.boardData.associations || [];

            const hasCollections = associations.includes("collections");
            const hasSolution = associations.includes("solutionboard");

            if (hasCollections || hasSolution) {
                this.onPiBoardSelectValue(this.boardData.piBoards);
            }

            //reverse logic
            if (!hasCollections) {
                this.boardData.collections = this.boardData.collections.filter(
                    id => !this.autoAddedCollectionIds.has(id)
                );
                this.autoAddedCollectionIds.clear();
            }

            if (!hasSolution) {
                this.boardData.solutionBoards = this.boardData.solutionBoards.filter(
                    id => !this.autoAddedSolutionBoardIds.has(id)
                );
                this.autoAddedSolutionBoardIds.clear();
            }
        },

        loadAssociationOptions() {
            this.associationOptions = [
                { id: 'piboard', title: 'PI Board', value: 'piboard' },
                { id: 'solutionboard', title: 'Solution Board', value: 'solutionboard' },
                { id: 'collections', title: 'Collections', value: 'collections' }
            ];
        },

        onCancel() {
            this.$emit('cancel');
        },

        onSave() {
            // Validate the form
            if (!this.validateForm()) {
                this.scrollToFirstError();
                return;
            }

            const title = (this.boardData?.title || '').trim();
            const description = (this.boardData?.description || '').trim();

            this.saving = true;

            const teamAreaMap = {};
            let teamSessionList = [];


            this.boardData.teams.forEach(tArea => {
                if (!teamAreaMap[tArea.sessionId]) {
                    teamAreaMap[tArea.sessionId] = [];
                    teamSessionList.push(tArea.sessionId);
                }
                teamAreaMap[tArea.sessionId].push(tArea.teamId);
            });

            let sessionId = this.board?.session?.id;

            if(!sessionId && this.editBoard){
                sessionId = Object.values(this.editBoard?.context || {})[0];
            }

            if (this.chosenTeams?.length > 0) {
                if (!teamAreaMap[sessionId]) {
                    teamAreaMap[sessionId] = [];
                }

                this.chosenTeams.forEach(team => {
                    if (team?.id && !teamAreaMap[sessionId].includes(team.id)) {
                        teamAreaMap[sessionId].push(team.id);
                    }
                });
            }

            const hasAssociations =
                (this.boardData.piBoards && this.boardData.piBoards.length > 0) ||
                (this.boardData.solutionBoards && this.boardData.solutionBoards.length > 0) ||
                (this.boardData.collections && this.boardData.collections.length > 0) ||
                (this.boardData.additionalLinkings?.includes("inspect-adapt") && this.boardData.piBoards?.length > 0) ||
                (this.boardData.additionalLinkings?.includes("teams") && Object.keys(teamAreaMap).length > 0);

            if (!hasAssociations) {
                showTopMessage('Board must have at least one Association.', 'error');
                return;
            }

            const data = {
                id :this.editBoard ? this.editBoard?.id : "",
                title: this.boardData.title.trim(),
                description: (this.boardData?.description || '').trim(),

                associations: this.boardData.associations,
                piBoards: this.boardData.piBoards.map(board => board?.id),
                solutionBoards: this.boardData.solutionBoards,
                collections: this.boardData.collections,
                additionalLinkings: this.boardData.additionalLinkings,
                selectedTeams: this.boardData.selectedTeams,
                publicView: this.boardData.publicView,
                publicEdit: this.boardData.publicEdit,
                privateBoard: this.boardData.privateBoard,
                flag: 'collaboration-link',
                // teamArea: [...this.boardData.teams],
                contextType: this.contextType,
                activeSessionId: this.sessionId,
                sharedUsers: this.selectedUsers.map(user => user.id),
                // sharing payload
                // Send the generated tokens
                viewToken: this.viewToken,
                editToken: this.editToken,

                piInspectAndAdapt: this.boardData?.additionalLinkings?.includes("inspect-adapt") ? this.boardData.piBoards.map(board => board?.id) : [],
                piTeamArea: teamAreaMap && Object.keys(teamAreaMap).length > 0 ? teamAreaMap : undefined,
                backgroundColor: this.selectedColor,
                backgroundPattern: this.selectedPattern
            };

            // Handle both object and string types for selectedType
            // In edit mode, don't send collaboration type if it's "general" to prevent type switching bugs
            if (this.editBoard && Object.keys(this.editBoard).length > 0 && this.editBoard?.id) {
                const typeId = typeof this.boardData.selectedType === 'object' ? this.boardData.selectedType.id : this.boardData.selectedType;
                if (typeId === 'general') {
                    // Don't send selectedType for general type in edit mode to prevent type switching
                } else {
                    // For non-general types in edit mode, send the selected type
                    if (typeof this.boardData.selectedType === 'object') {
                        data.selectedType = this.boardData.selectedType.id || 'general';
                    } else {
                        data.selectedType = this.boardData.selectedType || 'general';
                    }
                }
            } else {
                // In create mode, always send the selected type
                if (typeof this.boardData.selectedType === 'object') {
                    data.selectedType = this.boardData.selectedType.id || 'general';
                } else {
                    data.selectedType = this.boardData.selectedType || 'general';
                }
            }

            if(this.contextType === "session") {
                const typeId = typeof this.boardData.selectedType === 'object' ? this.boardData.selectedType.id : this.boardData.selectedType;
                const isMongoId = /^[a-f\d]{24}$/i.test(typeId);
                
                if (typeId === "selectTeams" && this.chosenTeams && this.chosenTeams.length > 0) {
                    // Handle team selection from the new dropdown
                    data.typeOrigin = "sessionTeam";
                    // data.selectedType = this.chosenTeams.map(team => team.id);
                }
                // else if (this.boardData.selectedType?.identifier === "team") {
                //     data.typeOrigin = "sessionTeam";
                // }
                else if(typeId === "inspect") {
                    data.typeOrigin = "sessionInspect";
                } else if(!isMongoId) {
                    data.typeOrigin = "session";
                }
            }
            else if(this.contextType === "solution") {
                const typeId = typeof this.boardData.selectedType === 'object' ? this.boardData.selectedType.id : this.boardData.selectedType;
                const isMongoId = /^[a-f\d]{24}$/i.test(typeId);
                
                if (typeId === "selectSessions" && this.chosenSession) {
                    // Handle session selection from the new dropdown
                    data.typeOrigin = "solutionPiBoard";
                    data.selectedType = this.chosenSession.id;
                }
                // else if (this.boardData.selectedType?.identifier === "piBoard") {
                //     data.typeOrigin = "solutionPiBoard";
                // }
                else if(!isMongoId) {
                    data.typeOrigin = "solution";
                }
            }
            else if(this.viewType) {
                const typeId = typeof this.boardData.selectedType === 'object' ? this.boardData.selectedType.id : this.boardData.selectedType;
                const isMongoId = /^[a-f\d]{24}$/i.test(typeId);
                
                if (typeId === "selectProgramBoards" && this.chosenProgramBoard) {
                    // Handle program board selection from the new dropdown
                    data.typeOrigin = "workspacePiBoard";
                    data.selectedType = this.chosenProgramBoard.id;
                } else if (typeId === "selectSolutionBoards" && this.chosenSolutionBoard) {
                    // Handle solution board selection from the new dropdown
                    data.typeOrigin = "workspaceSolutionBoard";
                    data.selectedType = this.chosenSolutionBoard.id;
                }
                // else if (this.boardData.selectedType?.identifier === "collectionPiBoard") {
                //     data.typeOrigin = "workspacePiBoard";
                // } else if (this.boardData.selectedType?.identifier === "collectionSolBoard") {
                //     data.typeOrigin = "workspaceSolutionBoard";
                // }
                else if(!isMongoId) {
                    data.typeOrigin = "workspace";
                }
            }

            // console.log("data is : ", data);
            // return;

            this.$emit('save', data);
        },

        // copyPublicLink() {
        //     // Implementation for copying public link
        //     showTopMessage('Link copied to clipboard', 'success');
        // },

        searchUsers() {
            // Implementation for searching users
        },

        setSaving(value) {
            this.saving = value;
        },

        clearValidationErrors() {
            this.validationErrors.title = false;
            this.validationErrors.description = false;
            this.validationErrors.associations = false;
            this.validationErrors.associationSections = false;
            this.validationErrors.associate = false;
        },

        validateForm() {
            let isValid = true;
            
            // Clear previous validation errors
            this.clearValidationErrors();
            
            // Validate title
            const title = (this.boardData?.title || '').trim();
            if (!title) {
                this.validationErrors.title = true;
                isValid = false;
            }
            
            // Validate description length
            const description = (this.boardData?.description || '').trim();
            if (description.length > 250) {
                this.validationErrors.description = true;
                isValid = false;
            }
            
            // Validate associations - check if at least one of the three main options is selected
            const hasValidAssociations = this.boardData?.associations && 
                this.boardData.associations.some(association => 
                    ['piboard', 'solutionboard', 'collections'].includes(association)
                );
            
            // Additional validation: check if items are actually selected for the chosen associations
            let hasSelectedItems = false;

            if (this.boardData.piBoards && this.boardData.piBoards.length > 0) {
                hasSelectedItems = true;
            }
            if (this.boardData.solutionBoards && this.boardData.solutionBoards.length > 0) {
                hasSelectedItems = true;
            }
            if (this.boardData.collections && this.boardData.collections.length > 0) {
                hasSelectedItems = true;
            }

            // Set associate error if no associations are selected
            if (!hasValidAssociations) {
                this.validationErrors.associate = true;
                isValid = false;
            }
            
            // Set associationSections error if associations are selected but no items are chosen
            if (hasValidAssociations && !hasSelectedItems) {
                this.validationErrors.associationSections = true;
                isValid = false;
            }
            
            return isValid;
        },

        scrollToFirstError() {
            this.$nextTick(() => {
                // Find the first error element
                const titleError = document.querySelector('.form-section.required');
                if (titleError) {
                    titleError.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    return;
                }
                
                // If no title error, scroll to associations error
                const associationSection = document.querySelector('.form-section.rhtsd.required');
                if (associationSection) {
                    associationSection.scrollIntoView({ behavior: 'smooth', block: 'center' });
                }
            });
        },

        // loadSolutionBoards: function () {
        //     this.isLoadingSolutions = true;
        //     this.solutionBoards?.forEach(solBoard => {
        //         if(this.contextType === "solution" && solBoard.id === this.solutionId){
        //            this.boardData.solutionBoards.push(solBoard.id);
        //         }
        //         this.solutionBoardOptions.push({id: solBoard.id, title: solBoard.title});
        //     })
        // },

        // fetching of piboards:

        loadAllBoards: function () {
            this.isLoadingBoards = true;
            let selBoards = [];
            let selectedTeam = null;
            // this.allBoards = response.data.boards;
            this.allBoardsMap = {};

            this.allBoards.forEach(board => {
                const piBoard = {
                    id: board?.session?.id,
                    title: board?.session?.title,
                    boardId: board?.id,
                    teams: board?.teams
                };
                this.allBoardsMap[board?.id] = board;

                if(this.contextType === "session" && board?.session?.id === this.sessionId){
                    this.boardData.piBoards.push(piBoard);
                    if(this.subContext === "sessionTeam"){
                        const selectedBoardIds = this.boardData.piBoards.map(b => b.boardId);

                        selBoards = this.allBoards.filter(board =>
                            selectedBoardIds.includes(board.id)
                        );

                        this.boardData.piBoards.forEach(piBoard => {
                            const match = selBoards.find(b => b.id === piBoard.boardId);
                            if (match) {
                                piBoard.teams = match.teams || [];
                            }
                        });
                    }else if(this.subContext === "sessionInspect"){
                        this.showAdditionalAssociations = true;
                    }

                }
                // this.boardsOptions.push(piBoard);
            });
            if(this.subContext === "sessionInspect"){
                this.boardData.additionalLinkings.push("inspect-adapt");
            }else if(this.subContext === "sessionTeam") {
                this.boardData.additionalLinkings.push("teams");
            }

            // selBoards
            if(this.editBoard && Object.keys(this.editBoard)?.length > 0) {
                this.boardData?.piBoards?.forEach(sessionObject => {
                    sessionObject?.teams?.forEach(team => {
                        // Add null check for piTeamArea
                        const teamAreaObj = this.editBoard?.piTeamArea?.[sessionObject?.id];
                        if (teamAreaObj && teamAreaObj.includes(team?.id)) {
                            this.boardData.teams.push({
                                sessionId: sessionObject.id,
                                boardId: sessionObject?.boardId,
                                teamId: team?.id,
                                id: `${sessionObject.id}_${team?.id}`,
                                label: team?.title
                            });
                        }

                        // this.boardData.teams.push({
                        //     sessionId: sessionObject.id,
                        //     boardId: sessionObject?.boardId,
                        //     teamId: selectedTeam.id,
                        //     id: `${sessionObject.id}_${selectedTeam.id}`,
                        //     label: selectedTeam.title
                        // });
                    })

                });
            }else if(this.teamId){
                selectedTeam = this.boardData.piBoards[0].teams.find(team => team?.id === this.teamId.id);
                const sessionObject = this.boardData.piBoards[0];
                this.boardData.teams.push({
                    sessionId: sessionObject.id,
                    boardId: sessionObject?.boardId,
                    teamId: selectedTeam?.id,
                    id: `${sessionObject.id}_${selectedTeam?.id}`,
                    label: selectedTeam?.title
                });

            }
        },

        fetchReleaseTrains: function () {
            this.isLoadingCollections = true;
            this.collectionOptions = []; // Clear existing options
            
            this.collections?.workspaces?.forEach(releaseTrain => {
                // if (releaseTrain?.type) {
                    if ((this.viewType) && releaseTrain.key === this.releaseTrainId) {
                        this.boardData.collections = [releaseTrain.id];
                        // Clear validation error when collections are automatically set
                        this.validationErrors.associations = false;
                        this.validationErrors.associationSections = false;
                    }
                    this.collectionOptions.push({id: releaseTrain.id, title: releaseTrain.title});
                // }
            })

            this.solutionCollectionOptions = JSON.parse(JSON.stringify(this.collectionOptions));
            this.collections?.solutionAreas?.forEach(solArea => {
                this.solutionCollectionOptions.push({id: solArea.id, title: solArea.title, linkedCollections: solArea?.linkedCollections});
            })
            this.solutionCollectionOptions.push({id: "-1", title: "Legacy Solution Boards"});
        },

        toggleAssociation(type) {
            // Check permission before allowing association changes
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.boardData.associations.indexOf(type);
            if (index === -1) {
                this.boardData.associations.push(type);
            } else {
                this.boardData.associations.splice(index, 1);
            }
            
            // Clear validation error when any of the three main association types are selected
            const hasMainAssociations = this.boardData.associations.some(association => 
                ['piboard', 'solutionboard', 'collections'].includes(association)
            );
            if (hasMainAssociations) {
                this.validationErrors.associations = false;
                this.validationErrors.associate = false;
                // Only clear associationSections error if there are actual selections
                if (this.hasValidAssociations) {
                    this.validationErrors.associationSections = false;
                }
            }
            
            this.onAssociationSelectValue();
        },
        toggleSection(section) {
            this.$set(this.expandedSections, section, !this.expandedSections[section]);
        },
        removeBoard(board) {
            // Check permission before allowing board removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.boardData.piBoards.findIndex(b => b.id === board.id);
            if (index > -1) {
                this.boardData.piBoards.splice(index, 1);
                this.boardData.teams = this.boardData?.teams?.filter(team => team.boardId !== board.boardId);
            }

            // remove workspace selection when sessionBoard is unchecked
            const b = this.allBoardsMap[board.boardId];
            const workspace = b?.session?.workSpace;
            if(workspace) {
                this.removeCollection(workspace);
            }
        },
        removeCollection(collection) {
            // Check permission before allowing collection removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.boardData.collections.indexOf(collection.id);
            if (index > -1) {
                this.boardData.collections.splice(index, 1);
            }
        },

        removeTeam(team) {
            // Check permission before allowing team removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.boardData.teams.findIndex(t => t.id === team.id);
            if (index > -1) {
                this.boardData.teams.splice(index, 1);

                if (this.contextType === "session" && this.boardData.additionalLinkings.includes('teams')) {
                    this.syncTeamsFromAdditionalLinks();
                }
            }
        },

        removePIBoardCollection(collection) {
            // Check permission before allowing collection removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.programBoardCollections.findIndex(col => col.id === collection.id);
            if (index > -1) {
                this.programBoardCollections.splice(index, 1);
                
                // After removing collection, refresh the boards based on remaining collections
                this.onPiBoardCollectionSelectValue(this.programBoardCollections);
            }
        },

        removeSolutionBoardCollection(collection) {
            // Check permission before allowing collection removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.solutionBoardCollections.findIndex(col => col.id === collection.id);
            if (index > -1) {
                this.solutionBoardCollections.splice(index, 1);
                
                // After removing collection, refresh the boards based on remaining collections
                this.onSolutionBoardCollectionSelectValue(this.solutionBoardCollections);
            }
        },

        onSolutionBoardSelectValue(selectedBoard) {
            // Clear validation error when solution boards are selected
            if (selectedBoard) {
                this.validationErrors.associations = false;
                this.validationErrors.associationSections = false;
            }
            
            // Populate collections based on selected solution boards
            if (this.boardData?.associations?.includes('collections')) {
                const uniqueIds = new Set(this.boardData.collections || []);
                const solutionBoardCollectionsArray = [];

                selectedBoard.forEach(board => {
                    // For solution boards, we need to get the workspace from the solution board
                    // This might need to be adjusted based on your data structure
                    const solutionBoard = this.solutionBoards.find(sb => sb.id === board);
                    if (solutionBoard && solutionBoard.workSpace) {
                        const workspace = solutionBoard.workSpace;
                        if (workspace && this.collectionOptions.find(opt => opt.id === workspace.id)) {
                            uniqueIds.add(workspace.id);
                            this.autoAddedCollectionIds.add(workspace.id);
                            
                            // Add to solutionBoardCollections array for the dropdown
                            const collectionOption = this.collectionOptions.find(opt => opt.id === workspace.id);
                            if (collectionOption && !solutionBoardCollectionsArray.find(item => item.id === workspace.id)) {
                                solutionBoardCollectionsArray.push({
                                    id: workspace.id,
                                    title: workspace.title
                                });
                            }
                        }
                    }
                });

                this.boardData.collections = Array.from(uniqueIds);
                this.solutionBoardCollections = solutionBoardCollectionsArray;
            }
        },
        removeSolutionBoard(board) {
            // Check permission before allowing solution board removal
            if (!this.permissions.ALLOW_ASSOCIATION_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to modify associations', 'error');
                return;
            }

            const index = this.boardData.solutionBoards.indexOf(board.id);
            if (index > -1) {
                this.boardData.solutionBoards.splice(index, 1);
            }
        },
        // selectedSolutionBoards() {
        //     return this.solutionBoardOptions.filter(opt =>
        //         this.boardData.solutionBoards.includes(opt.id)
        //     );
        // }
        setSelectedTypeFromLink() {
            // Wait for all required data to be loaded before setting the selected type
            if (!this.navigationLinks || this.navigationLinks?.length === 0) {
                // If navigation links are not loaded yet, retry after a short delay
                this.$nextTick(() => {
                    this.setSelectedTypeFromLink();
                });
                return;
            }

            // For collection context, also wait for collection data
            if ((this.viewType)) {
                if (!this.collectionAssociatedSolBoards || !this.collectionAssociatedProgramBoards) {
                    this.$nextTick(() => {
                        this.setSelectedTypeFromLink();
                    });
                    return;
                }
            }

            // Handle special navigation selections with specific items
            
            // Session context - Teams selection (check listContext first)
            if (this.listContext && this.listContext.type === "team" && this.contextType === "session") {
                // Set dropdown to "Teams"
                // Find the selectTeams object from navigationLinks
                const selectTeamsObject = this.navigationLinks.find(link => link && link.id === 'selectTeams');
                if (selectTeamsObject) {
                    this.boardData.selectedType = selectTeamsObject;
                } else {
                    this.boardData.selectedType = "selectTeams";
                }
                
                // Show team dropdown and populate it
                this.showTeamDropdown = true;
                this.populateSessionTeams();
                
                // Find and set the specific team - try both listContext.id and selectedTeam
                this.$nextTick(() => {
                    let team = null;
                    
                    // First try listContext.id
                    if (this.listContext.id) {
                        team = this.board?.teams?.find(t => t.id === this.listContext.id);
                    }
                    
                    // If not found, try selectedTeam
                    if (!team && this.selectedTeam) {
                        team = this.board?.teams?.find(t => t.id === this.selectedTeam);
                    }
                    
                    if (team) {
                        this.chosenTeams = [team];
                    }
                });
                return;
            }
            
            // Handle other contexts with selectedLink
            if (this.selectedLink && this.navigationLinks.length > 0) {

                // Solution context - Program Boards selection
                if (this.listContext.type === "piBoard" && this.selectedPiBoard && this.contextType === "solution") {
                    // Set dropdown to "Program Boards"
                    const selectSessionsObject = this.navigationLinks.find(link => link && link.id === 'selectSessions');
                    if (selectSessionsObject) {
                        this.boardData.selectedType = selectSessionsObject;
                    } else {
                        this.boardData.selectedType = "selectSessions";
                    }
                    // Show session dropdown and populate it
                    this.showSessionDropdown = true;
                    this.populateSolutionSessions();
                    // Find and set the specific session
                    this.$nextTick(() => {
                        const board = this.allBoards.find(b => b?.session?.id === this.selectedPiBoard);
                        if (board?.session) {
                            this.chosenSession = board.session;
                        }
                    });
                    return;
                }

                // Collection context - Program Boards selection
                if (this.listContext.type === "piBoard" && this.selectedPiBoard && (this.viewType)) {
                    // Set dropdown to "Program Boards"
                    const selectProgramBoardsObject = this.navigationLinks.find(link => link && link.id === 'selectProgramBoards');
                    if (selectProgramBoardsObject) {
                        this.boardData.selectedType = selectProgramBoardsObject;
                    } else {
                        this.boardData.selectedType = "selectProgramBoards";
                    }
                    // Show program board dropdown and populate it
                    this.showProgramBoardDropdown = true;
                    this.populateCollectionProgramBoards();
                    // Find and set the specific program board
                    this.$nextTick(() => {
                        const piBoard = this.collectionAssociatedProgramBoards.find(pb => pb.id === this.selectedPiBoard);
                        if (piBoard) {
                            this.chosenProgramBoard = piBoard;
                        }
                    });
                    return;
                }

                // Collection context - Solution Boards selection
                if (this.listContext.type === "solutionBoard" && this.selectedPiBoard && (this.viewType)) {
                    // Set dropdown to "Solution Boards"
                    const selectSolutionBoardsObject = this.navigationLinks.find(link => link && link.id === 'selectSolutionBoards');
                    if (selectSolutionBoardsObject) {
                        this.boardData.selectedType = selectSolutionBoardsObject;
                    } else {
                        this.boardData.selectedType = "selectSolutionBoards";
                    }
                    // Show solution board dropdown and populate it
                    this.showSolutionBoardDropdown = true;
                    this.populateCollectionSolutionBoards();
                    // Find and set the specific solution board
                    this.$nextTick(() => {
                        const solBoard = this.collectionAssociatedSolBoards.find(sb => sb.id === this.selectedPiBoard);
                        if (solBoard) {
                            this.chosenSolutionBoard = solBoard;
                        }
                    });
                    return;
                }

                // Handle regular navigation links (general, inspect, custom types)
                const matchingLink = this.navigationLinks.find(link => link.id === this.selectedLink);
                if (matchingLink) {
                    this.boardData.selectedType = matchingLink;
                } else {
                    // If no matching link found, default to general
                    const generalLink = this.navigationLinks.find(link => link.id === 'general');
                    this.boardData.selectedType = generalLink || 'general';
                }
            } else {
                // If no selectedLink prop or no navigation links, default to general
                const generalLink = this.navigationLinks.find(link => link.id === 'general');
                this.boardData.selectedType = generalLink || 'general';
            }
        },

        clearSelectedType() {
            // Check permission before allowing type clearing in edit mode
            if (this.isEditMode && !this.permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE) {
                showTopMessage('You don\'t have permission to change the collaboration type', 'error');
                return;
            }
            
            this.boardData.selectedType = 'general';
            this.showTeamDropdown = false;
            this.chosenTeams = [];
            this.showSessionDropdown = false;
            this.chosenSession = null;
            this.showProgramBoardDropdown = false;
            this.chosenProgramBoard = null;
            this.showSolutionBoardDropdown = false;
            this.chosenSolutionBoard = null;
        },

        populateSessionTeams(board) {
            if (this.contextType === "session" && this.board?.teams) {
                this.sessionTeams = this.board.teams.map(team => ({
                    id: team.id,
                    title: team.title,
                    identifier: "team"
                }));
            }else if(board?.teams){
                this.sessionTeams = board.teams.map(team => ({
                    id: team.id,
                    title: team.title,
                    identifier: "team"
                }));
            }
        },

        clearChosenTeams() {
            this.chosenTeams = [];
            this.isDefaultTeamSelection = false; // User has made changes
            // Sync to Additional Links after clearing teams
            if (this.contextType === "session") {
                this.syncTeamsToAdditionalLinks();
            }
        },

        removeChosenTeam(teamToRemove) {
            this.chosenTeams = this.chosenTeams.filter(team => team.id !== teamToRemove.id);
            this.isDefaultTeamSelection = false; // User has made changes
            // Sync to Additional Links after removing team
            if (this.contextType === "session") {
                this.syncTeamsToAdditionalLinks();
            }
        },

        populateSolutionSessions() {
            if (this.contextType === "solution" && this.activeSolutionBoard?.piBoards) {
                this.solutionSessions = this.activeSolutionBoard.piBoards.map(piBoard => {
                    const board = this.allBoards.find(board => board?.session.id === piBoard.sessionId);
                    return {
                        id: board?.session.id,
                        title: board?.session.title,
                        identifier: "piBoard"
                    };
                }).filter(session => session.id && session.title); // Filter out invalid sessions
            }
        },

        clearChosenSession() {
            this.chosenSession = null;
        },

        populateCollectionProgramBoards() {
            if ((this.viewType) && this.collectionAssociatedProgramBoards) {
                this.collectionProgramBoards = this.collectionAssociatedProgramBoards.map(piBoard => ({
                    id: piBoard.id,
                    title: piBoard.title,
                    identifier: "collectionPiBoard"
                }));
            }
        },

        populateCollectionSolutionBoards() {
            if ((this.viewType) && this.collectionAssociatedSolBoards) {
                this.collectionSolBoards = this.collectionAssociatedSolBoards.map(solBoard => ({
                    id: solBoard.id,
                    title: solBoard.title,
                    identifier: "collectionSolBoard"
                }));
            }
        },

        clearChosenProgramBoard() {
            this.chosenProgramBoard = null;
        },

        clearChosenSolutionBoard() {
            this.chosenSolutionBoard = null;
        },

        syncTeamsToAdditionalLinks() {
            if (this.contextType !== "session" || this.isSyncingTeams) {
                return;
            }

            this.isSyncingTeams = true;

            try {
                const currentSessionId = this.board?.session?.id || this.sessionId;
                if (!currentSessionId) {
                    return;
                }
                this.boardData.teams = this.boardData.teams.filter(team => team.sessionId !== currentSessionId);
                if (!this.chosenTeams || this.chosenTeams.length === 0) {
                    return;
                }
                this.chosenTeams.forEach(team => {
                    const teamData = {
                        sessionId: currentSessionId,
                        boardId: this.board?.id || currentSessionId,
                        teamId: team.id,
                        id: `${currentSessionId}_${team.id}`,
                        label: team.title
                    };
                    const existingTeam = this.boardData.teams.find(t => t.id === teamData.id);
                    if (!existingTeam) {
                        this.boardData.teams.push(teamData);
                    }
                });
            } finally {
                this.isSyncingTeams = false;
            }
        },

        syncTeamsFromAdditionalLinks() {
            if (this.contextType !== "session" || this.isSyncingTeams || !this.boardData.additionalLinkings.includes('teams')) {
                return;
            }

            this.isSyncingTeams = true;
            try {
                const currentSessionId = this.sessionId || "";
                if (!currentSessionId) {
                    return;
                }
                const currentSessionTeams = this.boardData.teams ?
                    this.boardData.teams.filter(team => team.sessionId === currentSessionId) : [];
                this.chosenTeams = currentSessionTeams.map(team => ({
                    id: team.teamId,
                    title: team.label,
                    identifier: "team"
                }));
                
                // Once user has interacted, never go back to default state
                // Always set to false when syncing from Additional Links
                this.isDefaultTeamSelection = false;
            } finally {
                this.isSyncingTeams = false;
            }
        }
    }
});
