
const TEMPLATE_PREVIEW = Vue.component('template-preview', {
    name: 'template-preview',
    template: 
    `
    <div class="create-board-overlay">
	<div class="create-board-modal tmp-preview">		
		<div class="cntr-container DF p-rel">
			<a href="javascript:void(0);" class="rmv-ico rnd DAJ ti-close" @click="$emit('close');"></a>
			<div class="lftsd p-rel">
				<div class="ttl poppins mb-10">{{template.title}}</div>
				<div class="dsc fs-14 mb-20" v-html="template.description"></div>
				<button type="button" class="btn h-36 mt-10 rnd4 txt-wht brd-no" @click="$emit('use',template);" >Use Template</button>
				<div class="copylnktp p-abs w-full" v-if="template.id">
					<a @click="onClickCopySharableUrl" class="button-w copylnk txgrn brgrn DIB rnd4"><em class="ti-link mr-10 fs-16 txgrn"></em>Copy Link to Share</a> 
				</div>
			</div>
			<div class="rhtsd p-rel">				
				<div class="prvw DAJ">
					<img v-if="template.title=='Planning Retro Template'" id="board-image" src="../assets/imgs/CollaborationBoard-Template.png" alt="Preview" />
					<img v-else :src="imagePath" alt="Preview" />
				</div>
				<a v-if="template.title!='Planning Retro Template'" @click="onClickExpandTemplate" class="button-w w-full h-auto">
					See Full View
					<svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
					  <path d="M4.92 10.44H2.68L10.44 2.68V4.92H12V0H7.08V1.56H9.32L1.56 9.32V7.08H0V12H4.92V10.44Z" fill="#6664D5"/>
					</svg>
				</a>
			</div>			
		</div>
	</div>
    </div>
    `,

    props: ['template'],

    watch: {
        
    },

    data() {
        return {
            imagePath: ""
        }
    },

    created() {
		this.imagePath = "/upload/retrieve-image/" + this.template.thumbnailPath;
    },

    methods: {
		onClickCopySharableUrl: function () {
			const urlRoot = window.location.origin;
			let copyUrl = urlRoot+"/graphx/template?boardId="+this.template.id;
			navigator.clipboard.writeText(copyUrl);
			showTopMessage("URL copied to clipboard","success");
		},
		onClickExpandTemplate: function () {
			const urlRoot = window.location.origin;
			let copyUrl = urlRoot+"/graphx/template?boardId="+this.template.id;
			window.open(copyUrl, "_blank");
		}
    }

});




const COLLABORATION_TEMPLATES = Vue.component('collaboration-templates', {
    name: 'collaboration-templates',
// Replace the template section with this:
    template: `
    <div :class="['collaboration-templates', displayMode === 'inline' ? 'collaboration-templates-inline' : 'collaboration-templates-overlay', { 'is-modal': isModal }]">
    
    <template-preview v-if="previewPopup.show" :template="previewPopup.template" 
    	@use="onUseTemplatePreview"
    	@close="onCloseTemplatePreview">
    </template-preview>
    
    <div :class="displayMode === 'inline' ? 'templates-inline-container DFAaa' : 'templates-modal'">
        <!-- Header with title and close button - only show in modal mode -->
        <h2 v-if="displayMode !== 'inline'" class="modal-title">
            Select Template for Collaboration Board                
            <a href="javascript:void(0);" class="rmv-ico ti-close" @click="onCancel"></a>
        </h2>
        <div class="cntr-container--a">
            <!-- Loading state -->
            <div v-if="loading " class="template-loading">
                <div class="temp-loaderinteg"></div>
                <div class="no-templates">Loading templates...</div>
            </div>
            
            <!-- No templates message -->
<!--            <div v-else-if="!localTemplatesList || localTemplatesList.length === 0" class="no-templates">-->
<!--                <p>No templates available</p>-->
<!--            </div>-->
            
            <!-- Templates horizontal container -->
            <div v-else :class="displayMode === 'inline' ? 'templates-scroll-container-inline' : 'templates-scroll-container'" >
                <div class="templates-horizontal-list">
                    <!-- No Template Option -->
                    <div 
                        class="template-card no-template-card"
                        :class="{ 
                            'selected': templateSelected && (templateSelected === 'no-template' || templateSelected.title === 'No Template' || (templateSelected.id === null && templateSelected.title === 'No Template')),
                            'disabled': !permissions.CREATE_COLLAB_BOARD
                        }"
                        @click.stop="onClickCreateNewBoard"
                    >
                        <div class="template-preview" @click.stop="onClickCreateNewBoard">
                        <div class="no-template-icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
								<circle opacity="0.12" cx="20" cy="20" r="20" fill="#26BAA1"/>
								<path d="M20 11.5C20.2611 11.5 20.4725 11.7116 20.4727 11.9727V19.5273H28.0273C28.2884 19.5275 28.5 19.7389 28.5 20C28.5 20.2611 28.2884 20.4725 28.0273 20.4727H20.4727V28.0273C20.4725 28.2884 20.2611 28.5 20 28.5C19.7389 28.5 19.5275 28.2884 19.5273 28.0273V20.4727H11.9727C11.7116 20.4725 11.5 20.2611 11.5 20C11.5 19.7389 11.7116 19.5275 11.9727 19.5273H19.5273V11.9727C19.5275 11.7116 19.7389 11.5 20 11.5Z" stroke="#1E9984"/>
							</svg>
                        </div>
                        </div>
                        <div class="template-info template-info">No Template</div>
                        <!-- 
                        <div class="template-info">
                            <h4 class="template-title">No Template</h4>
                            <p class="template-description">Create a blank collaboration board from scratch.</p>
                        </div>
                        
				    	
                        <div class="template-actions" v-if="displayMode !== 'inline'">
                            <button class="btn btn-primary use-template-btn" @click.stop="permissions.CREATE_COLLAB_BOARD ? onClickCreateNewBoard : null" :disabled="!permissions.CREATE_COLLAB_BOARD">
                                Create Blank Board
                            </button>
                        </div>   -->                    

                    </div>
                    
                    <!-- Template Items -->
                    <div 
                        v-if="calculationComplete"
                        v-for="template in displayedTemplates" 
                        :key="template.id" 
                        class="template-card"
                        :class="{ 'selected': templateSelected && templateSelected !== 'no-template' && templateSelected.id === template.id }"
                    >
                        <div class="template-preview">
                            <img v-if="template.title == 'Planning Retro Template'" src="../assets/imgs/CollaborationBoard-Template.png" alt="Template Preview" />
                            <img v-else :src="thumbnailPath(template)"  alt="image" />
                        </div>
                        <!--
                        <div class="template-info">
                            <h4 class="template-title">{{template.title}}</h4>
                            <p class="template-description">{{template.description || 'Manage your workflow in a highly flexible and visual way.'}}</p>
                        </div>
                        -->
				    	<div class="template-info ftsb">{{template.title}}</div>
                        <div class="template-actions trnsn">
                        	<div v-if="template.title != 'Planning Retro Template' && permissions.MANAGE_TEMPLATES" class="actions-dropdown p-abs">
	                    		<a href="javascript:void(0);" class="actions-menu-btn DAJ ti-more-alt" @click="onClickMenuButton(template);"></a>
	                    		<vuepopup v-if="templateActionMenu==template.id" class="drop_box nwmu sml artp actions-menu" style="display: block;" @close="templateActionMenu='';">
		                    		<ul>
		                    			<li @click="onClickCopySharableUrl(template);">Copy Link</li>
		                    			<li @click="onClickEditTemplate(template);">Edit</li>
		                    			<li @click="onClickDeleteTemplate(template);">Delete</li>
		                    		</ul>
	                    		</vuepopup>
	                    	</div>
                        	<div class="txt">Structure your team’s sprint planning retro...</div>
                        	<div class="btn DFA gap-10px">
	                            <button v-if="permissions.CREATE_COLLAB_BOARD" class="button-w whtbtn h-auto rnd4" @click="onTemplateClick(template)">Use</button>
	                            <button class="button-w clrbtn h-auto rnd4" @click="onClickPreviewTemplate(template)">Preview</button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Show All Templates Button with count -->
                    <div class="show-more-container">
                        <a href="javascript:void(0);" class="show-more-btn und wht-nwrp" @click="openExploreTemplatesPopup">
                            Show All ({{ localTemplatesList.length }})
                        </a>
                    </div>
                </div>
            </div>
          </div>
    </div>
    </div>
`,

    props: ['sessionId', 'workspaceId', 'solutionId', 'batchId', 'objectiveCustomViewId', 'contextType', 'viewType', 'removeSelection', 'templatesLoaded', 'selectedTemplate', 'templatesList', 'displayMode','selectedType','permissions', 'isModal'],

    watch: {
        removeSelection(newVal, oldVal) {
            if (newVal){
                this.templateSelected = null;
                this.$emit('selection-cleared');
            }
        },
        // Sync selected template from props
        selectedTemplate(newVal) {
            this.templateSelected = newVal;
        },
        // Sync templates list from props
        templatesList(newVal) {
            if (newVal && newVal.length > 0) {
                this.localTemplatesList = newVal;
                if (!this.calculationComplete) {
                    var self = this;
                    this.$nextTick(function() {
                        setTimeout(function() {
                            self.calculateVisibleTemplates();
                        }, 50);
                    });
                }
            }
        },
        selectedType(newVal) {
            if(newVal?.id) {
                this.fetchTemplates();
            }
        }
    },
    
    computed: {
		thumbnailPath: function() {
			return function(template) {
				if (template.thumbnailPath) {
					// Use MongoDB GridFS endpoint instead of S3
					return "/upload/retrieve-image/" + template.thumbnailPath;
				}
				return "";
			};
		},
		
		// Computed property for displayed templates
		displayedTemplates() {
			if (this.showAllTemplates || this.localTemplatesList.length <= this.initialDisplayCount) {
				return this.localTemplatesList;
			}
			return this.localTemplatesList.slice(0, this.initialDisplayCount);
		},
		
		// Computed property for remaining templates count
		remainingTemplatesCount() {
			if (this.showAllTemplates || this.localTemplatesList.length <= this.initialDisplayCount) {
				return 0;
			}
			return this.localTemplatesList.length - this.initialDisplayCount;
		},
		
		// Check if show more/less button should be displayed
		// shouldShowToggleButton() {
		// 	return this.localTemplatesList.length > this.initialDisplayCount;
		// }
	},

    data() {
        return {
            templateSelected: null,
            localTemplatesList: [],
            loading: true,
            error: null,
            previewPopup: {
				show: false,
				template: undefined
			},
            showAllTemplates: false,
            initialDisplayCount: 4,
            templateActionMenu: "",
            cardWidth: 240,
            cardGap: 20,
            calculationComplete: false
        }
    },

    mounted() {
        this.templateSelected = this.selectedTemplate;
        // Use props if available, otherwise fetch
        if (this.templatesList && this.templatesList.length > 0) {
            this.localTemplatesList = this.templatesList;
            this.loading = true;
        } else {
            // Set loading to true when fetching templates
            if(this.selectedType?.id) {
                this.fetchTemplates();
            }
        }

        var self = this;
        this.$nextTick(function() {
            if (self.localTemplatesList && self.localTemplatesList.length > 0) {
                setTimeout(function() {
                    self.calculateVisibleTemplates();
                }, 50);
            } else {
                setTimeout(function() {
                    if (self.localTemplatesList && self.localTemplatesList.length > 0) {
                        self.calculateVisibleTemplates();
                    }
                }, 200);
            }
        });
    },

    methods: {
        
        onCancel() {
            this.$emit('close');
        },

        onClickCreateNewBoard(template) {
            // Check permissions before proceeding
            if (!this.permissions.CREATE_COLLAB_BOARD) {
                // console.log('User does not have permission to create collaboration board');
                return;
            }
            
            // if (this.templateSelected === 'no-template') {
            //     this.templateSelected = null;
            //     // Emit null selection to parent
            //     this.$emit('template-select', {
            //         id: null,
            //         title: null,
            //         template: null
            //     });
            // } else {
            //     // Clear any previous selection and select no-template
            //     this.templateSelected = 'no-template';
            //     // Emit to parent that no template is selected
            //     this.$emit('template-select', {
            //         id: null,
            //         title: 'No Template',
            //         template: null
            //     });
            // }
            
            this.$emit('template-used', {
                id: null,
                title: 'No Template',
                template: null
            });

            this.$forceUpdate();
        },

        onTemplateClick(template) {
            this.$emit('template-used', template);
            // if (this.templateSelected &&
            //     this.templateSelected !== 'no-template' &&
            //     this.templateSelected.id === template.id) {
            //     // If the same template is clicked again, unselect it
            //     this.templateSelected = null;
            //     console.log("Template unselected:", template.title);
            //
            //     this.$emit('template-select', {
            //         id: null,
            //         title: null,
            //         template: null
            //     });
            // } else {
            //     // Clear any previous selection and set new template
            //     this.templateSelected = template;
            //     console.log("Template selected:", template);
            //
            //     this.$emit('template-select', {
            //         id: template.id,
            //         title: template.title,
            //         template: template
            //     });
            // }

            this.$forceUpdate();
        },
        onClickPreviewTemplate: function (template) {
			this.previewPopup.template = template;
			this.previewPopup.show = true;
		},

        fetchTemplates() {
            this.loading = true
            this.error = null;
            let id = "";
            if(this.contextType === "session") {
                id = this.sessionId;
                if (!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);
                    id = params.get('id');
                }
            }
            else if(this.viewType) {
                id = this.workspaceId;
            }

            if(this.selectedType?.id) {
                let data = {
                    association: this.selectedType?.type,
                    contextId: this.contextType === "session" ? String(id) : (this.contextType === "solution" ? String(this.solutionId) : (this.viewType ? String(id) : "")),
                    context: this.viewType ? "workspace" : this.contextType
                };

                axios.post('/graphx/template/all/' + this.selectedType?.id, data)
                    .then(response => {
                        if (response.data && response.data.success) {
                            this.loading = false;
                            this.localTemplatesList = [];

                            if (response.data.templates) {
                                _.each(response.data.templates, templ => {
                                    this.localTemplatesList.push(templ);
                                });
                            }

                            this.$emit('templates-fetched', response.localTemplatesList || []);

                            var self = this;
                            this.$nextTick(function() {
                                setTimeout(function() {
                                    self.calculateVisibleTemplates();
                                }, 200);
                            });
                        } else {
                            this.loading = false;
                            this.error = 'Failed to load templates';
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching templates:', error);
                        this.loading = false;
                        this.error = 'Failed to load templates';
                    })
            }
        },
        
        onCloseTemplatePreview: function () {
			this.previewPopup.template = undefined;
			this.previewPopup.show = false;
		},
		onUseTemplatePreview: function (template) {
			this.onCloseTemplatePreview();
			 this.$emit('template-used', template);
		},
		onClickCopySharableUrl: function (template) {
			const urlRoot = window.location.origin;
			let copyUrl = urlRoot+"/graphx/template?boardId="+template.id;
			navigator.clipboard.writeText(copyUrl);
			showTopMessage("URL copied to clipboard","success");
		},
		onClickDeleteTemplate: function (template) {
			let _this = this;
			askFromSweetAlertWrapper("Do you want to delete this template.",
					[()=>{
						_this.loading = true;
						axios.delete("/graphx/delete/template/"+template.id)
						.then(response=> {
							_this.loading = false;
							if (response.data) {
								// Remove from localTemplatesList (main source of truth)
								let localIndex = _.findIndex(_this.localTemplatesList, {id: template.id});
								if (localIndex > -1) {
									_this.localTemplatesList.splice(localIndex, 1);
								}
								
								// Recalculate visible templates to show hidden ones
								_this.calculateVisibleTemplates();
								
								// Emit success event for explore-collaboration-templates
								_this.$emit('template-deleted-success', template.id);
							}
						})
						.catch(error=> {
							_this.loading = false;
						})
						;
					}], [()=>{
						
					}]);
		},
		onClickEditTemplate: function (template) {
			const urlRoot = window.location.origin;
			let copyUrl = urlRoot+"/graphx/template?boardId="+template.id;
			window.open(copyUrl, "_blank");
		},
		onClickMenuButton: function (template) {
			this.templateActionMenu = template.id;
		},
		
		// Toggle show all templates
		toggleShowAllTemplates() {
			this.showAllTemplates = !this.showAllTemplates;
		},

		// Open explore templates popup
		openExploreTemplatesPopup() {
			// Pass the current selected type and a flag indicating this is from "Show All"
            this.$emit('open-explore-templates', true);
		},

		// Handle edit template event from explore-collaboration-templates
		onEditTemplate(template) {
			this.onClickEditTemplate(template);
		},

		// Handle delete template event from explore-collaboration-templates
		onDeleteTemplate(template) {
			this.onClickDeleteTemplate(template);
		},

		calculateVisibleTemplates() {
			var container = this.$el.querySelector('.templates-horizontal-list');
			if (!container) {
				container = this.$el.querySelector('.templates-container');
			}
			if (!container) {
				container = this.$el.querySelector('.templates-scroll-container');
			}

			if (!container) {
				return;
			}

			this.containerWidth = container.offsetWidth;

			// Account for padding (20px left + 20px right = 40px)
			var availableWidth = this.containerWidth - 40;

			// Account for "Show All" button width (approximately 80px + 20px gap)
			var showAllButtonWidth = 100;
			availableWidth = availableWidth - showAllButtonWidth;

			// Calculate how many cards can fit
			// Formula: (availableWidth + gap) / (cardWidth + gap)
			// We add gap to availableWidth because the last card doesn't need a gap after it
			var totalCardsThatCanFit = Math.floor((availableWidth + this.cardGap) / (this.cardWidth + this.cardGap));

			// Subtract 1 for the "No Template" card (which is always shown)
			var visibleCount = Math.max(1, totalCardsThatCanFit - 1);

			this.initialDisplayCount = visibleCount;
			this.calculationComplete = true;
			this.loading = false;
		}

    }

});
