const COLLABORATION_BOARD = Vue.component('collaboration-board', {
    name: 'collaboration-board',
    template: `
        <div class="collab-listing" :class="[viewType ? 'orgview' : 'pnlAnalytics active', subContext === 'sessionInspect' ? 'no-left-menu' : '']" :id="viewType === 'ART' || viewType === 'D' ? 'collabFullPage' : 'pnlAnalytics'">
            <div class="collab-left-menu" v-if="subContext !== 'sessionInspect'">
                <div class="tophd DFCB">
                    <div class="bname ftsb pr-10 DFA">
                    	<div v-if="!viewType" class="back-btn c-point tooltip" @click="onClose">
                    		<em class="back-ico"></em>
                    		<span class="hovtooltipB sml">Back</span>
                    	</div>
		            	<span class="spr-vrt"></span>
                    	Board Types 
                    	<span class="infotxt tooltip mht15 nw2 nwhv">
                            <span class="hovtooltipB wdt26">Use board types to organize your Collab boards into meaningful categories. Click the ‘+’ to add new custom types for better grouping.</span>
                        </span>
                    </div>
                    <div class="plus-icon p-rel" @click="toggleTypeDropdown">
                    <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M19 -1.31134e-07C20.6569 -5.87107e-08 22 1.34315 22 3L22 19C22 20.6569 20.6569 22 19 22L3 22C1.34315 22 1.00441e-06 20.6569 1.07683e-06 19L1.77621e-06 3C1.84864e-06 1.34314 1.34315 -9.0294e-07 3 -8.30516e-07L19 -1.31134e-07Z" fill="#27B59D"/>
						<path d="M11 6C10.7015 6 10.4595 6.24201 10.4595 6.54054V10.4595H6.54054C6.24201 10.4595 6 10.7015 6 11C6 11.2986 6.24201 11.5406 6.54054 11.5406H10.4595V15.4595C10.4595 15.758 10.7015 16 11 16C11.2985 16 11.5405 15.758 11.5405 15.4595V11.5406H15.4595C15.758 11.5406 16 11.2986 16 11C16 10.7015 15.758 10.4595 15.4595 10.4595H11.5405V6.54054C11.5405 6.24201 11.2985 6 11 6Z" fill="white"/>
					</svg>
					<div v-if="showTypeDropdown" class="drop_box nwmu artp lft" :class="['type-dropdown', (viewType) ? 'type-dropdown-margin-left' : '']" @click.stop style="display:block;">
					<ul>
						<li class="head ftsb DFCB">
							Board Types
							<button class="h-auto rnd4" @click="closeTypeDropdown">Done</button>
						</li>
						<!-- Search input -->
						<li class="srchout">
							<input v-model="typeSearchQuery" type="text" placeholder="Search types..." class="inpsrch" />
						</li>
						<!-- Types list with individual add buttons -->
	                    <template v-for="(type, idx) in filteredTypes">
                            <li :key="type.id" class="type-item">
                                <div class="itmname">{{ type.title }}</div>
                                <span @click="addSingleType(type)" class="addf ti-plus txgrn fs-12">Add</span>
                             </li>
	                    </template>
	                     <li v-if="loadingTypes" class="loader-overlay">
                            <div class="collaboration-board-loader-container">
                                <div class="loader">
                                    <div class="aa">
                                        <div class="loaderinteg"></div>
                                        <span class="LOADER-TITLE">Loading board types...</span>
                                    </div>
                                </div>
                            </div>
                        </li>
	                    <li v-if="filteredTypes.length === 0 && !showAddTypeInput" class="nofound">No types found matching your search</li>
	                 </ul>
	                <div class="btm" v-if="!showAddTypeInput && permissions.CREATE_COLLAB_BOARD">	                                                
                        <a href="javascript:void(0);" class="addf ti-plus" @click="showCreateNewTypeInput">Create New Type</a>
                    </div>	                
	                </div>
                    </div>
                </div>
                <ul class="collab-menu-list">
                    <li v-if="showAddTypeInput" :key="'add-type-inline'" class="add-type-inline">
                        <input v-model="newTypeName" type="text" placeholder="Type name" class="inp rnd4" />
                        <span class="confirm-icon" @click="addType">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="9" cy="9" r="9" fill="#E6F4F1"/>
                                <path d="M5 9L8 12L13 7" stroke="#1E9984" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                        </span>
                        <span class="cancel-icon" @click="cancelAddType">
                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <circle cx="9" cy="9" r="9" fill="#F8D7DA"/>
                                <path d="M6 6L12 12" stroke="#E74C3C" stroke-width="2" stroke-linecap="round"/>
                                <path d="M12 6L6 12" stroke="#E74C3C" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                        </span>
                    </li>
                    <li v-for="(link, index) in displayedLinks" :key="link.id" >                        
                        <div class="DF" :class="['collab-menu-link', {selected: selectedLink === link.id}]" @click="selectLink(link)" >
	                        <span class="listicon mr-10">
	                        	<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
								  <path fill-rule="evenodd" clip-rule="evenodd" d="M0 1.79106C0 0.802141 0.802125 0 1.79106 0H12.2089C13.1979 0 14 0.802125 14 1.79106V12.2089C14 13.1979 13.1979 14 12.2089 14H1.79106C0.802141 14 0 13.1979 0 12.2089V1.79106ZM8.72996 2.85751C8.63961 2.6933 8.4632 2.59562 8.27579 2.60539C8.08839 2.61577 7.92357 2.73236 7.85154 2.90513L4.98547 9.78308L3.521 7.11969C3.43493 6.96403 3.27132 6.86696 3.09308 6.86696H1.791C1.52118 6.86696 1.30264 7.0855 1.30264 7.35532C1.30264 7.62514 1.52118 7.84368 1.791 7.84368H2.80434L4.61853 11.1419C4.70888 11.3067 4.88529 11.4043 5.0727 11.3946C5.2601 11.3842 5.42493 11.2676 5.49695 11.0948L8.36303 4.21689L9.82749 6.88028C9.91356 7.03594 10.0778 7.13301 10.2554 7.13301H12.2088C12.4787 7.13301 12.6972 6.91447 12.6972 6.64465C12.6972 6.37482 12.4787 6.15629 12.2088 6.15629H10.5442L8.72996 2.85751Z" />
								</svg>
	                        </span>
	                        <span class="nm">{{ link.title }}</span>
	                        <span v-if="link.id === 'teams' && currentSessionBoard && currentSessionBoard.teams && currentSessionBoard.teams.length" class="team-count">{{ currentSessionBoard.teams.length }}</span>
	                        <span v-if="link.id === 'programBoards' && activeSolutionBoard && activeSolutionBoard?.piSessions && activeSolutionBoard?.piSessions?.length" class="team-count">{{ activeSolutionBoard?.piSessions?.length }}</span>
	                        <span v-if="link.id === 'collectionPiBoard' && collectionAssociatedProgramBoards && collectionAssociatedProgramBoards?.length" class="team-count">{{ collectionAssociatedProgramBoards?.length }}</span>
	                        <span v-if="link.id === 'collectionSolBoard' && collectionAssociatedSolBoards && collectionAssociatedSolBoards?.length" class="team-count">{{ collectionAssociatedSolBoards?.length }}</span>
	                        <span v-if="link.id === 'general'" class="team-count">{{ getTeamBoardCount('general') }}</span>
	                        <span v-if="link.id === 'inspect'" class="team-count">{{ getTeamBoardCount('inspect') }}</span>
	                        <span v-if="link.id !== 'teams' && link.id !== 'programBoards' && link.id !== 'collectionPiBoard' && link.id !== 'collectionSolBoard' && link.id !== 'general' && link.id !== 'inspect'" class="team-count">{{ getTeamBoardCount(link.id) }}</span>
	                        
	                        <!-- Team count and dropdown indicator for teams -->
	                        <span v-if="link.id === 'teams' || link.id === 'programBoards' || link.id === 'collectionPiBoard' || link.id === 'collectionSolBoard'" class="teams-indicator">
	                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg" :class="{ 'rotated': selectedLink === link.id }">
	                                <path d="M3 4.5L6 7.5L9 4.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
	                            </svg>
	                        </span>
	                        
	                        <!-- Three-dot menu for custom types with zero board count -->
	                        <span v-if="isCustomTypeWithZeroBoards(link)" class="type-menu-btn" @click.stop="toggleTypeMenu(link.id)">
	                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
	                                <circle cx="8" cy="4" r="1.5" fill="#6B7280"/>
	                                <circle cx="8" cy="8" r="1.5" fill="#6B7280"/>
	                                <circle cx="8" cy="12" r="1.5" fill="#6B7280"/>
	                            </svg>
	                            
	                            <!-- Type menu dropdown -->
	                            <div v-if="activeTypeMenu === link.id" class="type-menu-dropdown" @click.stop>
	                                <ul>
	                                    <li class="type-menu-item" @click="removeType(link)">
	                                        <i class="ti-trash"></i>
	                                        <span>Remove</span>
	                                    </li>
	                                </ul>
	                            </div>
	                        </span>
                        </div>
                        <ul v-if="link.id === 'teams' && selectedLink === 'teams' && currentSessionBoard && currentSessionBoard.teams && currentSessionBoard.teams.length" class="collab-menu-submenu">
                            <li v-for="team in getSortedTeams()" :key="team.id" :class="['collab-menu-sublink', {selected: selectedTeam === team.id}]" @click.stop="selectTeam(team)">
                                <span>{{ team.title }}</span>
                                <span class="team-count">{{ getTeamBoardCount(team.id) }}</span>
                            </li>
                        </ul>
                        <ul v-if="link.id === 'programBoards' && selectedLink === 'programBoards' && activeSolutionBoard && activeSolutionBoard?.piBoards && activeSolutionBoard?.piBoards?.length" class="collab-menu-submenu">
                            <li v-for="piBoard in getSortedPiBoards()" :key="piBoard.sessionId" :class="['collab-menu-sublink', {selected: selectedPiBoard === piBoard.sessionId}]" @click.stop="selectPiBoard(piBoard)">
                                <span>{{ getPiTitle(piBoard.sessionId) }}</span>
                                <span class="team-count">{{ getTeamBoardCount(piBoard.sessionId) }}</span>
                            </li>
                        </ul>
                        <ul v-if="link.id === 'collectionPiBoard' && selectedLink === 'collectionPiBoard' && collectionAssociatedProgramBoards && collectionAssociatedProgramBoards?.length" class="collab-menu-submenu">
                            <li v-for="piBoard in getSortedCollectionPiBoards()" :key="piBoard.id" :class="['collab-menu-sublink', {selected: selectedPiBoard === piBoard.id}]" @click.stop="selectCollectionPiBoard(piBoard)">
                                <span>{{ piBoard.title }}</span>
                                <span class="team-count">{{ getTeamBoardCount(piBoard.id) }}</span>
                            </li>
                        </ul>
                        <ul v-if="link.id === 'collectionSolBoard' && selectedLink === 'collectionSolBoard' && collectionAssociatedSolBoards && collectionAssociatedSolBoards?.length" class="collab-menu-submenu">
                            <li v-for="solBoard in getSortedCollectionSolBoards()" :key="solBoard.id" :class="['collab-menu-sublink', {selected: selectedPiBoard === solBoard.id}]" @click.stop="selectCollectionSolBoard(solBoard)">
                                <span>{{ solBoard.title }}</span>
                                <span class="team-count">{{ getTeamBoardCount(solBoard.id) }}</span>
                            </li>
                        </ul>
                    </li>
                    
                    <!-- Show More/Less Button -->
                    <li v-if="links.length > 10" class="show-more-container">
                        <button class="button share DIB rnd4" @click="toggleShowAllLinks">
                            <span v-if="!showAllLinks">Show More</span>
                            <span v-else>Show Less</span>
                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg" :class="{ 'rotated': showAllLinks }">
                                <path d="M3 4.5L6 7.5L9 4.5" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </li>
                </ul>
            </div>
            
            <!-- right content start  -->
            <div class="ltngcntar">
	            <!-- Loading overlay for all data -->
	            <div v-if="isLoadingData || isBoardsLoaded || isCollectionsLoading" class="loader-overlay">
	                <div class="collaboration-board-loader-container">
	                    <div class="loader">
	                        <div class="aa">
	                            <div class="loaderinteg"></div>
	                            <span class="LOADER-TITLE">Loading board data...</span>
	                        </div>
	                    </div>
	                </div>
	            </div>
	
	            <div :class="viewType ? 'head-colab DFCB art' : 'head-colab DFCB nrml'">            
	            	<div class="lft DFA">
	            		<a v-if="viewType" href="javascript:void(0);" class="back-btn" @click="goBackToMenu"><em class="back-ico"></em>Back</a>
		            	<span v-if="viewType" class="spr-vrt"></span>
		            	<!-- <em class="prmbrdico mr-10"></em> -->            
                        <div :class="viewType ? 'bname' : 'bname ftsb'">{{getCurrentContextTitle}} - Collab Boards</div>
<!--		                <span class="context-info bname ftsb" v-if="contextType && sessionId">{{getContextLabel()}}</span>-->
<!--		                <span class="board-count" v-if="collabBoards && collabBoards.length > 0">({{collabBoards.length}} board{{collabBoards.length !== 1 ? 's' : ''}})</span>-->
		            </div>    
<!--		            <div class="rht DFA"> -->
<!--	                	<a href="javascript:void(0);" class="button ti-plus addf rnd4 ml-10" @click="openCollaborationBoards()" v-if="permissions.CREATE_COLLAB_BOARD">Create Board</a>                    -->
<!--&lt;!&ndash;	            		<a v-if="!viewType && subContext !== 'sessionInspect'" class="rmv-ico ti-close rnd DAJ sml" @click="onClose"></a> &ndash;&gt;-->
<!--	            	</div>-->
	           </div>
	           
		        <!-- Loading State -->
	            <div v-if="loading" class="loader-container" style="text-align: center; padding: 50px;">
	                <div class="loader"><div class="aa"><div class="loaderinteg"></div><span class="LOADER-TITLE">Loading collaboration boards...</span></div></div>
	            </div>
		            
	            <!-- Error State -->
	            <div v-else-if="error" class="outcont mrow">
	                <div class="error-container" style="text-align: center; padding: 50px;">
	                    <i class="ti-alert" style="font-size: 48px; color: #e74c3c; margin-bottom: 15px; display: block;"></i>
	                    <h3>Error Loading Boards</h3>
	                    <p>{{error}}</p>
	<!--                    <a class="button DIB" href="javascript:void(0);" @click="loadBoards()">Retry</a>-->
	                </div>
	            </div>
	             
	            <!-- Main Content Area -->
	            <div v-else :class="viewType ? 'clblistout' : 'clblistout'">
	                <!-- Templates Section - New Entry Point -->
	                <div class="templates-section-main" v-if="!isLoadingData" :class="{ 'expanded': showTemplatesSection }">
	                    <div class="temp-header ftsb" >
	                        <div class="ftsb fs-14" @click="toggleTemplatesSection"> <em class="icon-right-dir arrd p-rel DIB mr-5 trnsn"></em>Templates</div>
	                        <a href="javascript:void(0);" @click="openExploreTemplatesPopup" class="button rnd4" style="margin-top: -10px;"> Explore Templates </a>
	                    </div>
	                    <div v-if="showTemplatesSection" class="templates-content">
	                        <collaboration-templates
	                        ref="collaborationTemplates"
	                        :selected-type="selectedType"
	                        :session-id="sessionId"
	                        :workspace-id="releaseTrainId"
	                        :solution-id="solutionId"
	                        :removeSelection="removeTemplateSelection"
	                        :batch-id="batchId"
	                        :objective-custom-view-id="objectiveCustomViewId"
	                        :context-type="contextType"
	                        :view-type="viewType"
	                        :selected-template="currentSelectedTemplate"
	                        :templates-list="currentCollaborationTemplates || []"
	                        :templates-loaded="currentTemplatesLoaded"
	                        :display-mode="'inline'"
	                        :is-modal="false"
	                        @template-used="onTemplateUsed"
	                        @templates-fetched="onTemplatesFetched"
	                        @template-select="onTemplateSelect"
	                        @selection-cleared="onSelectionCleared"
	                        @open-explore-templates="openExploreTemplatesPopup"
	                        @template-deleted-success="onTemplateDeletedSuccess"
	                        :permissions="permissions"
	                    />
	                    </div>
	                </div>
	
	                <!-- Original Templates Popup Section -->
	                <div class="templates-section" v-if="showTemplatesPopup">
	                    <div class="section-header">System Templates</div>
	                    <collaboration-templates
	                        ref="collaborationTemplatesModal"
                            :session-id="sessionId"
                            :selected-type="selectedType"
                            :workspace-id="releaseTrainId"
                            :solution-id="solutionId"
                            :removeSelection="removeTemplateSelection"
                            :batch-id="batchId"
                            :objective-custom-view-id="objectiveCustomViewId"
                            :context-type="contextType"
                            :view-type="viewType"
                            :selected-template="currentSelectedTemplate"
                            :templates-list="currentCollaborationTemplates || []"
                            :templates-loaded="currentTemplatesLoaded"
                            :is-modal="true"
                            @template-used="onTemplateUsed"
                            @templates-fetched="onTemplatesFetched"
                            @close="closeCollaborationBoards"
                            @template-select="onTemplateSelect"
                            @selection-cleared="onSelectionCleared"
                            @open-explore-templates="openExploreTemplatesPopup"
                            @template-deleted-success="onTemplateDeletedSuccess"
                            :permissions="permissions"
                        />
		                </div>

                    <!-- Explore Templates Popup Section -->
                    <div class="explore-templates-section" v-if="showExploreTemplatesPopup">
                    <explore-collaboration-templates
                        :is-show-all-templates="showAllTemplates"
                        ref="exploreTemplates"
                        :contextTypes="allContextTypes"
                        :session-id="sessionId"
                        :context-type="contextType"
                        :workspace-id="releaseTrainId"
                        :solution-id="solutionId"
                        :batch-id="batchId"
                        :objective-custom-view-id="objectiveCustomViewId"
                        :view-type="viewType"
                        :templates="availableTemplates"
                        :templates-loaded="!templatesLoading"
                        :selected-type="selectedType"
                        :collection-associated-program-boards="collectionAssociatedProgramBoards"
                        :collection-associated-sol-boards="collectionAssociatedSolBoards"
                        @close="closeExploreTemplatesPopup"
                        @template-used="onTemplateUsed"
                        @edit-template="onEditTemplate"
                        @delete-template="onDeleteTemplate"
                        @preview-template="onPreviewTemplate"
                        @copy-template-link="onCopyTemplateLink"
                        :permissions="permissions"
                    />
                    </div>
	                
	                <collaboration-board-listing
	                    ref="boardListing"
	                    :collab-boards="collabBoards"
	                    :loading="loading"
	                    :error="error"
	                    :session-id="sessionId"
	                    :context-type="contextType"
	                    :view-type="viewType"
	                    :sub-context="subContext"
	                    :team-id="teamId"
	                    :solution-id="solutionId"
	                    :release-train-id="releaseTrainId"
	                    :teams="teams"
	                    :listContext="listContext"
	                    :team-options="teamOptions"
	                    :session-boards="allSessionBoards"
	                    :session-board-map="allSessionBoardsMap"
	                    :session-board-options="boardsOptions"
	                    :solution-boards="solutionBoards"
	                    :solution-board-options="solutionBoardOptions"
	                    :collections="collections"
	                    :collection-options="collectionOptions"
	                    @open-collaboration-board-create-popup="openCollaborationBoards"
	                    @create-board="onCreateBoard"
	                    @edit-board="onEditBoard"
	                    @copy-board="onCopyBoard"
	                    @is-boards-load="isBoardsLoad"
	                    @delete-board="onDeleteBoard"
	                    @board-click="onBoardClick"
	                    @board-options="onBoardOptions"
	                    @boards-loaded="onBoardsLoaded"
	                    @board-moved="onBoardMoved"
	                    :permissions="permissions"
	                />
	            </div>
		            
	            <create-collaboration-board
	                v-if="(showCreateBoardModal || isEditMode) && (contextType === 'session' ? programBoard : true) && linksFetched"
	                ref="createBoardModal"
	                :available-pi-boards="availablePiBoards"
	                :available-teams="availableTeams"
	                :context-type="contextType"
	                :session-id="sessionId"
	                :board="programBoard"
	                :editBoard="editBoard"
	                :subContext="subContext"
	                :teamId="teamId"
	                :allBoards="allSessionBoards"
	                :collections="collections"
	                :context-title="getCurrentContextTitle"
	                :solutionBoards="solutionBoards"
	                :solutionId="solutionId"
	                :selectedLink="selectedLink"
	                :selectedTeam="selectedTeam"
	                :solutionArea="solutionArea"
	                :selectedPiBoard="selectedPiBoard"
	                :activeSolutionBoard="activeSolutionBoard"
	                :collectionAssociatedProgramBoards="collectionAssociatedProgramBoards"
	                :collectionAssociatedSolBoards="collectionAssociatedSolBoards"
	                :workspaceId="workspaceId"
	                :listContext="listContext"
	                :releaseTrainId="releaseTrainId"
	                :viewType="viewType"
	                :selectedTemplate="currentSelectedTemplate"
	                :links="links"
	                :unfilteredLinks="allLinks"
	                @back-to-templates="backToTemplateSelection"
	                @cancel="onCreateBoardCancel"
	                @save="onCreateBoardSave"
	                :permissions="permissions"
	            />
    		</div><!-- right content end  -->
      </div>
    `,

    props: ["sessionId", "contextType", "workspaceId", "solutionId", "batchId", "objectiveCustomViewId", "board", "subContext", "teamId", "solutionBoard", "releaseTrainId", "viewType", "selectedTemplate", "templatesLoaded", "collaborationTemplates"],

    data() {
        return {
            showAllTemplates: false,
            selectedType: undefined,
            loadingTypes: false,
            isCollectionsLoading: true,
            linksFetched: false,
            allLinks: [],
            isBoardsLoaded: true,
            solutionArea: [],
            programBoard: {},
            teams: [],
            links: [],
            listContext: {},
            teamOptions: [],
            currentSessionBoard: null,
            allSessionBoards : [],
            allSessionBoardsMap: {},
            boardsOptions: [],
            solutionBoards: [],
            activeSolutionBoard: null,
            activeReleaseTrain: null,
            collectionAssociatedProgramBoards: [],
            collectionAssociatedSolBoards: [],
            solutionBoardOptions : [],
            collections: [],
            collectionOptions: [],
            isLoadingData: false, // Add this line for the new loader state

            showTemplatesPopup: false,
            showExploreTemplatesPopup: false,
            removeTemplateSelection: false,
            editBoard: {},
            showCreateBoardModal: false,
            availablePiBoards: [],
            availableTeams: [],

            // Local template state management for standalone usage
            localSelectedTemplate: null,
            localTemplatesLoaded: false,
            localCollaborationTemplates: [],

            collabBoards: [],
            loading: false,
            error: null,
            isEditMode: false,
            formSubmitting: false,
            selectedLink: null,
            selectedTeam: null,
            selectedPiBoard: null,
            // Types dropdown state
            showTypeDropdown: false,
            types: [], // Array of {id, title}
            selectedTypes: [], // Array of selected type ids
            showAddTypeInput: false,
            newTypeName: '',
            typeSearchQuery: '', // Search query for filtering types
            
            // Templates for main section
            availableTemplates: [],
            allContextTypes: [],
            templatesLoading: false,

            // Add permissions object
            permissions: {
                CREATE_COLLAB_BOARD: false,
                EDIT_COLLAB_BOARD: false,
                DELETE_COLLAB_BOARD: false,
                ALLOW_ASSOCIATION_COLLAB_BOARD: false,
                MOVE_COLLAB_BOARD_TO_OTHER_TYPE: false,
                MANAGE_TEMPLATES: false
            },
            
            // Templates section toggle
            showTemplatesSection: true, // Default to expanded
            
            // Team board counts
            teamBoardCounts: {}, // Object to store team ID -> board count mapping
            activeTypeMenu: "",
            
            // Show more/less functionality for collab-left-menu
            showAllLinks: false,
            boardListingLoaded: false,
            solutionListingLoaded: false,
            collectionListingLoaded: false,
        }
    },

    computed: {
        // Use props if available (parent component), otherwise use local state (standalone)
        
        allListingsLoaded() {
            return this.boardListingLoaded && this.solutionListingLoaded && this.collectionListingLoaded;
        },
        
        currentSelectedTemplate() {
            return this.selectedTemplate !== undefined ? this.selectedTemplate : this.localSelectedTemplate;
        },

        currentTemplatesLoaded() {
            return this.templatesLoaded !== undefined ? this.templatesLoaded : this.localTemplatesLoaded;
        },

        currentCollaborationTemplates() {
            return this.collaborationTemplates !== undefined ? this.collaborationTemplates : this.localCollaborationTemplates;
        },

        isStandalone() {
            // Check if we're being used standalone (no parent props)
            return this.selectedTemplate === undefined && this.templatesLoaded === undefined && this.collaborationTemplates === undefined;
        },

        getCurrentContextTitle() {
            let title = "";

            if (this.contextType === "session") {
                if (!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);
                    const sessionId = params.get('id');
                    title = this.allSessionBoardsMap[sessionId]?.title || "";
                } else {
                    title = this.getPiTitle(this.sessionId);
                }
            } else if (this.contextType === "solution") {
                const sol = this.solutionBoards.find(sol => sol.id === this.solutionId);
                title = sol?.title || "";
            } else if (this.viewType) {
                const col = this.collections?.workspaces?.find(col => col?.key === this.releaseTrainId);
                title = col?.title || "";
            }

            return title;
        },

        // Calculate total board count across all teams
        totalTeamBoardCount() {
            if (!this.teamBoardCounts || Object.keys(this.teamBoardCounts).length === 0) {
                return 0;
            }
            return Object.values(this.teamBoardCounts).reduce((sum, count) => sum + count, 0);
        },

        // Calculate total board count across all PI boards for solution context
        totalPiBoardCount() {
            if (!this.teamBoardCounts || Object.keys(this.teamBoardCounts).length === 0) {
                return 0;
            }
            return Object.values(this.teamBoardCounts).reduce((sum, count) => sum + count, 0);
        },

        // Calculate total board count for collection PI boards
        totalCollectionPiBoardCount() {
            if (!this.teamBoardCounts || Object.keys(this.teamBoardCounts).length === 0 || !this.collectionAssociatedProgramBoards) {
                return 0;
            }
            return this.collectionAssociatedProgramBoards.reduce((sum, board) => {
                return sum + (this.teamBoardCounts[board.id] || 0);
            }, 0);
        },

        // Calculate total board count for collection solution boards
        totalCollectionSolBoardCount() {
            if (!this.teamBoardCounts || Object.keys(this.teamBoardCounts).length === 0 || !this.collectionAssociatedSolBoards) {
                return 0;
            }
            return this.collectionAssociatedSolBoards.reduce((sum, board) => {
                return sum + (this.teamBoardCounts[board.id] || 0);
            }, 0);
        },

        // Filtered types based on search query
        filteredTypes() {
            if (!this.typeSearchQuery.trim()) {
                return this.types;
            }
            const query = this.typeSearchQuery.toLowerCase();
            return this.types.filter(type => 
                type.title.toLowerCase().includes(query)
            );
        },

        // Displayed links for collab-left-menu (show first 10 or all based on showAllLinks)
        displayedLinks() {
            if (this.showAllLinks || this.links.length <= 10) {
                return this.links;
            }
            return this.links.slice(0, 10);
        }
    },

    mounted() {
        this.getAllTypesRelatedToContext().then(() => {
            if(this.contextType === "session"){
                this.getPiBoard();
            }
            this.fetchContextTypes();
        });
        // if(this.viewType === "ART" || this.viewType === "D") {
        //     this.getReleaseTrain();
        // }

        // Setup permissions
        this.setupPermissions();

        // Add click listener to close type menus when clicking outside
        document.addEventListener('click', this.closeTypeMenus);
    },

    created(){
        this.isLoadingData = true;
        this.loadAllData();
        // if(loggedInUser?.id){
        //     this.loadAvailableTemplates();
        // }
    },

    beforeDestroy() {
        // Clean up event listener
        document.removeEventListener('click', this.closeTypeMenus);
    },
    beforeRouteLeave(to, from, next) {
		next();
		if (typeof releaseTrainVue !== "undefined") {
			releaseTrainVue.store.setShowLeftMenuBar(true);
		}
	},

    watch: {
        listContext: {
            handler(newVal) {

                if (this.contextType === "session") {
                    this.getSessionType(newVal);
                }
                else if (this.contextType === "solution") {
                    this.getSolutionType(newVal);
                }
                else if (this.viewType) {
                    this.getWorkspaceType(newVal);
                }
            },
            deep: true,
            immediate: true
        },

        selectedType:{
            handler(newVal) {
                // console.log("selected Type Id is : ", newVal);
                // here selected type id will be displayed
            },
            deep: true,
            immediate: true
        },
        
        allListingsLoaded:{
            handler(newVal) {
                if (newVal) {
					this.setupPermissions();
				}
            },
            deep: true,
            immediate: true
        }
    },

    methods: {
        getWorkspaceType(newVal){
            if (newVal?.type === "solutionBoard") this.handleSolutionBoardContext(newVal);
            else if (newVal?.type === "piBoard")  this.handlePiBoardContext(newVal);
            else if (newVal?.id !== "general") this.handleCustomType(newVal);
            else this.handleGeneralContext("workspace");
        },

        getSolutionType(newVal){
            if(newVal?.id === "general") this.handleGeneralContext("solution");
            else if (newVal?.type === "piBoard") this.handleSolutionPiBoardContext(newVal);
            else this.handleCustomType(newVal);
        },

        getSessionType(newVal){
            if (newVal?.type === "team") this.handleTeamContext(newVal);
            else if (newVal?.id !== "general" && newVal?.id !== "inspect") this.handleCustomType(newVal);
            else if(newVal?.id === "general") this.handleGeneralContext("session");
            else this.handleGeneralContext("sessionInspect");
        },

        getAllTypesRelatedToContext(){
            const _this = this;
            _this.loadingTypes  =  true;
            return new Promise(function(resolve){
                let data = {};
                let id ="";

                if(_this.contextType === "session") {
                    if(!_this.sessionId) {
                        const params = new URLSearchParams(window.location.search);
                        const sessionId = params.get('id');
                        id = sessionId;
                        data.origin = "sessionBoard";
                    }else{
                        id = _this.sessionId;
                    }

                } else if(_this.contextType === "solution") {
                    id = _this.solutionId;
                } else if(_this.viewType) {
                    id = _this.releaseTrainId;
                }

                data.context = _this.contextType;

                if(_this.viewType){
                    data.context = "workspace";
                }

                // First create types, then get all types
                _this.createTypesRelatedToContext(id, data)
                    .then(function(createResult) {
                        return axios.post(`/collaboration-type/getAllTypes/${id}`, data);
                    })
                    .then(function(response){
                        // _this.loadingTypes = false;
                        if (response.data && response.data.success) {

                            _.each(response.data.types, type=> {
                                if (!["sessionTeam", "solutionPiBoard", "workspacePiBoard", "workspaceSolutionBoard"]
                                    .includes(type.defaultOrigin)) {
                                    _this.allContextTypes.push(type);
                                }
                            });
                            // _this.allContextTypes = response.data.type;
                            resolve(true);
                        } else {
                            resolve(false);
                        }
                    })
                    .catch(function(error){
                        _this.loadingTypes = false;
                        console.error(error);
                        resolve(false);
                    });
            });

        },

        createTypesRelatedToContext(id, data){
            const _this = this;
            return new Promise(function(resolve, reject){
                axios.post(`/collaboration-type/createAllTypes/${id}`,data)
                    .then(function(response){
                        // _this.loadingTypes = false;
                        if (response.data && response.data.success) {
                            resolve(true);
                        } else {
                            resolve(false);
                        }
                    })
                    .catch(function(error){
                        console.error(error);
                        resolve(false);
                    });
            });
        },

        isBoardsLoad(){
            this.isBoardsLoaded = true;
        },

        getPiBoard() {
            let data = {};
            let id = "";
            let context = "session";

            if(!this.sessionId) {
                const params = new URLSearchParams(window.location.search);
                const sessionId = params.get('id');
                id = sessionId;
                context = "sessionBoard";
            }else{
                context = "session";
                id = this.sessionId;
            }

            data.id = id;
            data.context = context;

            axios.post('/pi/find/board', data)
                .then(res => {
                    if(res.data?.sessionBoard){
                        this.programBoard = res.data.sessionBoard;
                        this.currentSessionBoard = this.programBoard;
                    }
                })
                .catch(error => {
                    console.error('Error fetching PI Board:', error);
                });
        },

        getReleaseTrain(types) {
            let data = {};
            data.requestId = getNewUUID();
            data.id = this.releaseTrainId;

            let filters = [];
            axios.post("/releasetrain/" + this.releaseTrainId, data)
                .then(res => {
                    this.activeReleaseTrain = res.data.releaseTrain;
                    this.fetchPiSolutionBoardsForReleaseTrain(types);
                        // this.fetchListRelatedToSelectedLink({id: "general", title: "General"});

                })
                .catch(error => {
                    console.error('Error fetching release trains:', error);
                });
        },

        getPiTitle: function(sessionId){
            const board = this.allSessionBoards.find(board => board?.session.id === sessionId);
            if(board?.session){
                return board?.session?.title;
            }
            return null;
        },

        linkWithContext: function (){

            let data = {};
            data.types = this.selectedTypes;

            if(this.contextType === "session") {
                id = this.sessionId;
            } else if(this.contextType === "solution") {
                id = this.solutionId;
            } else if(this.viewType) {
                id = this.releaseTrainId;
            }

            data.context = this.contextType;

            if(this.viewType){
                data.context = "workspace";
            }

            axios.post(`/collaboration-type/link/${id}`, data)
                .then(response => {
                    this.isLoadingData = true;
                    if (response.data.success) {
                        // this.links
                        this.showTypeDropdown =  false;
                        this.fetchContextTypes();
                    }
                })
                .catch(error => {
                    console.error('Error loading solution boards:', error);
                });

        },

        fetchContextTypes: function (){
            this.linksFetched = false;
            let data = {};
            this.links = [];
            let id ="";

            if(this.contextType === "session") {
                if(!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);
                    const sessionId = params.get('id');
                    id = sessionId;
                    data.origin = "sessionBoard";
                }else{
                    id = this.sessionId;
                }

            } else if(this.contextType === "solution") {
                id = this.solutionId;
            } else if(this.viewType) {
                id = this.releaseTrainId;
            }

            data.context = this.contextType;

            if(this.viewType){
                data.context = "workspace";
            }

            axios.post(`/collaboration-type/context/${id}`, data)
                .then(response => {
                    this.isLoadingData = false;
                    if (response.data.success) {
                        this.allLinks = response.data.type
                        this.linksFetched = true;
                        this.links.push({id:"general", title:"General"})
                        if(this.contextType === "session") {
                            this.links.push({id:"inspect", title:"Inspect and Adapt"})
                            this.links.push({id:"teams", title:"Teams"})

                            response.data.type.forEach(type => {
                                if(!type?.defaultOrigin) {
                                    this.links.push({id: type?.id, title: type?.title, rowStatus: type?.rowStatus})
                                }
                            })
                            
                            // Set default selected tab based on subContext
                            if (this.subContext === "sessionInspect") {
                                this.selectedLink = "inspect";
                                this.fetchListRelatedToSelectedLink({id: "inspect", title: "Inspect and Adapt"});
                            } else {
                                this.selectedLink = "general";
                                this.fetchListRelatedToSelectedLink({id: "general", title: "General"});
                            }

                        } else if(this.contextType === "solution") {
                            id = this.solutionId;
                            this.links.push({id:"programBoards", title:"Program Boards"});
                            response.data.type.forEach(type => {
                                if(!type?.defaultOrigin) {
                                    this.links.push({id: type?.id, title: type?.title, rowStatus: type?.rowStatus})
                                }
                            });
                            this.selectedLink = "general";
                            this.fetchListRelatedToSelectedLink({id: "general", title: "General"});
                        } else if(this.viewType) {
                            this.getReleaseTrain(response.data.type);

                            // First add the fetched collaboration types (custom types)

                            // Then add Program Board and Solution Board at the end
                            // if(this.collectionAssociatedProgramBoards?.length > 0){
                            //     this.links.push({id:"collectionPiBoard", title:"Program Board"});
                            // }
                            // if(this.collectionAssociatedSolBoards?.length > 0) {
                            //     this.links.push({id: "collectionSolBoard", title: "Solution Board"});
                            // }
                            //
                            // // Set default selected tab
                            // this.selectedLink = "general";
                            // this.fetchListRelatedToSelectedLink({id: "general", title: "General"});
                        }


                    }
                })
                .catch(error => {
                    this.isLoadingData = false;
                    console.error('Error loading solution boards:', error);
                });

        },

        loadAllBoards: function () {
            const promise = new Promise((resolve, reject) => {
                axios.get('/pi/getAllBoards')
                    .then(response => {
                        if (response.data) {
                            this.allSessionBoards = response.data.boards;
                            this.allSessionBoardsMap = {};
                            const uniqueTeamIds = new Set();

                            this.allSessionBoards.forEach(board => {
                                const piBoard = {
                                    id: board?.session?.id,
                                    title: board?.session?.title,
                                    boardId: board?.id,
                                    teams: board?.teams
                                };


                                // if(this.sessionId === board?.session?.id){
                                //     this.currentSessionBoard = board;
                                // }


                                if (board?.teams && Array.isArray(board.teams)) {
                                    board.teams.forEach(team => {
                                        if (team && !uniqueTeamIds.has(team.id)) {
                                            uniqueTeamIds.add(team.id);
                                            // this.teams.push(team);

                                            // Check if a team with this title already exists in teamOptions
                                            const titleExists = this.teamOptions.some(option =>
                                                option.title === team.title
                                            );

                                            // Only add to teamOptions if both id and title are unique
                                            if (!titleExists) {
                                                this.teamOptions.push({
                                                    id: team.id,
                                                    title: team.title
                                                });
                                            }
                                        }
                                    });
                                }

                                this.allSessionBoardsMap[board?.id] = board;
                                this.boardsOptions.push(piBoard);
                            });
                            this.boardListingLoaded = true;
                           resolve(response);
                        }
                    })
                    .catch(error => {
                        console.error('Error loading boards:', error);
                        reject(error);
                    });
            });
            return promise;
        },

        loadSolutionBoards: function () {
            const promise = new Promise((resolve, reject) => {
                var _this = this;
                var requestId = getNewUUID();
                var data = { requestId: requestId };

                axios.post('/solution/boards', data)
                    .then(response => {
                        if (response.data.success) {
                            _this.solutionBoards = response.data.solutionBoards;
                            _this.solutionListingLoaded = true;
                            response.data?.solutionBoards?.forEach(solBoard => {
                                if(solBoard.id === this.solutionId){
                                    this.activeSolutionBoard = solBoard;
                                }
                                _this.solutionBoardOptions.push({id: solBoard.id, title: solBoard.title});
                            })
                            resolve(response);
                        }
                    })
                    .catch(error => {
                        console.error('Error loading solution boards:', error);
                        reject(error);
                    });
            });
            return promise;
        },

        fetchReleaseTrains: function () {
            this.isCollectionsLoading = true;
            const promise = new Promise((resolve, reject) => {
                let _this = this;
                let data = {};
                data.fetchTypes = true;
                // axios.post("/releasetrain/release-trains", data)
                axios.get("/solutionarea/getSolutionAreasAndCollections")
                    .then(res => {
                        // this.isCollectionsLoading = false;
                        _this.collections = res.data;
                        _this.collectionListingLoaded = true;
                        _this.solutionArea = res.data?.solutionBoards;
                        _this.collections?.workspaces?.forEach(releaseTrain => {
                            // if (releaseTrain?.type) {
                                _this.collectionOptions.push({id: releaseTrain.id, title: releaseTrain.title});
                            // }
                        })
                        resolve(res);
                    })
                    .catch(error => {
                        this.isCollectionsLoading = false;
                        console.error('Error fetching release trains:', error);
                        reject(error);
                    });
            });
            return promise;
        },

        fetchPiSolutionBoardsForReleaseTrain: function(types) {
            axios.get("/releasetrain/" + this.activeReleaseTrain.id + "/solutionBoards/piboards")
                .then(res => {
                    this.collectionAssociatedProgramBoards = res.data.sessions;
                    this.collectionAssociatedSolBoards = res.data.solutionBoards;
                    
                    // Add Program Board and Solution Board at the end of the links array
                    if(this.collectionAssociatedProgramBoards?.length > 0){
                        this.links.push({id:"collectionPiBoard", title:"Program Board"});
                    }
                    if(this.collectionAssociatedSolBoards?.length > 0) {
                        this.links.push({id: "collectionSolBoard", title: "Solution Board"});
                    }

                    types.forEach(type => {
                        if(!type?.defaultOrigin) {
                            this.links.push({id: type?.id, title: type?.title, rowStatus: type?.rowStatus});
                        }
                    });

                    this.selectedLink = "general";
                    this.fetchListRelatedToSelectedLink({id: "general", title: "General"});

                })
                .catch(error => {
                    console.error('Error fetching PI boards for release train:', error);
                });
        },

        onTemplatesFetched: function(templates) {
            if (this.isStandalone) {
                // Store templates locally when standalone
                this.localCollaborationTemplates = templates;
                this.localTemplatesLoaded = true;
            } else {
                // Emit to parent when used with parent component
                this.$emit('templates-fetched', templates);
            }
        },

        backToTemplateSelection: function() {
            this.showCreateBoardModal = false;
            this.showTemplatesPopup = true;
        },

        closeCollaborationBoards(){
            this.showTemplatesPopup = false;
        },

        closeTemplatesPopup(){
            this.showTemplatesPopup = false;
        },

        closeExploreTemplatesPopup(){
            this.showExploreTemplatesPopup = false;
            this.showAllTemplates = false; // Reset flag when closing
        },


        goBackToMenu() {
            if (this.viewType) {
                this.$router.push(`/${this.viewType}/`+this.releaseTrainId+"/backlog");
            }
        },

        onTemplateUsed(template) {
            if (this.isStandalone) {
                // Store template locally when standalone
                this.localSelectedTemplate = template;
            } else {
                // Emit to parent when used with parent component
                this.$emit('template-selected', template);
            }
            this.showCreateBoardModal = true;
        },

        onEditTemplate(template) {
            // Call the existing method from collaboration-templates component
            if (this.$refs.collaborationTemplates) {
                this.$refs.collaborationTemplates.onClickEditTemplate(template);
            } else if (this.$refs.collaborationTemplatesModal) {
                this.$refs.collaborationTemplatesModal.onClickEditTemplate(template);
            }
        },

        onDeleteTemplate(template) {
            // Call the existing method from collaboration-templates component
            if (this.$refs.collaborationTemplates) {
                this.$refs.collaborationTemplates.onClickDeleteTemplate(template);
            } else if (this.$refs.collaborationTemplatesModal) {
                this.$refs.collaborationTemplatesModal.onClickDeleteTemplate(template);
            }
        },

        onPreviewTemplate(template) {
            // Call the existing method from collaboration-templates component
            this.showExploreTemplatesPopup = false;
            if (this.$refs.collaborationTemplates) {
                this.$refs.collaborationTemplates.onClickPreviewTemplate(template);
            } else if (this.$refs.collaborationTemplatesModal) {
                this.$refs.collaborationTemplatesModal.onClickPreviewTemplate(template);
            }
        },

        onCopyTemplateLink(template) {
            // Call the existing method from collaboration-templates component
            if (this.$refs.collaborationTemplates) {
                this.$refs.collaborationTemplates.onClickCopySharableUrl(template);
            } else if (this.$refs.collaborationTemplatesModal) {
                this.$refs.collaborationTemplatesModal.onClickCopySharableUrl(template);
            }
        },

        onTemplateDeletedSuccess(templateId) {
            // Forward the success event to explore-collaboration-templates
            if (this.$refs.exploreTemplates) {
                this.$refs.exploreTemplates.removeTemplateFromList(templateId);
            }
        },

        onTemplateSelect(templateData) {
            if (this.isStandalone) {
                // Store template locally when standalone
                this.localSelectedTemplate = templateData;
            } else {
                // Emit to parent when used with parent component
                this.$emit('template-selected', templateData);
            }
            this.showCreateBoardModal = true;
        },

        openCollaborationBoards() {
            // Close the dropdown first
            // team.showCollabBoard = false;

            this.showTemplatesPopup = true;

            this.editBoard = {}
            this.isEditMode = false;

            // Set the context for creating the board
            this.createBoardContext = {
                sessionId: this.activeBoard?.session?.id ,
                contextType: 'session' // or determine based on your context
            };

            // Show the create board modal
            // this.showCreateBoardModal = true;
        },

        openExploreTemplatesPopup(isFromShowAll) {
            // Set the selected type for explore templates to match the current context
            // if (selectedType) {
            //     this.selectedType = selectedType;
            // }
            // Only set showAllTemplates to true if explicitly from "Show All" button
            this.showAllTemplates = isFromShowAll === true;
            this.showExploreTemplatesPopup = true;
        },

        closeCreateBoardModal() {
            this.showCreateBoardModal = false;
        },



        onBoardsLoaded() {
            // Update local boards list when child component loads new data

            this.isBoardsLoaded = false;
            // this.collabBoards = boards;
            //
            // // Refresh board counts when boards are loaded
            // if (this.shouldFetchBoardCounts()) {
            //     this.fetchTeamBoardCounts();
            // }
        },

        onCreateBoard() {
            // Check permissions before allowing create
            if (!this.permissions.CREATE_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to create collaboration boards', 'error');
                return;
            }

            this.showCreateBoardModal = true;
        },

        // loadAvailableTemplates() {
        //     this.templatesLoading = true;
        //
        //     axios.get('/graphx/template/all/' + loggedInUser.id)
        //         .then(response => {
        //             if (response.data && response.data.success) {
        //                 this.availableTemplates = response.data.systemTemplates || [];
        //                 this.templatesLoading = false;
        //             } else {
        //                 console.error('Failed to load templates');
        //                 this.templatesLoading = false;
        //             }
        //         })
        //         .catch(error => {
        //             console.error('Error fetching templates:', error);
        //             this.templatesLoading = false;
        //         });
        // },


        onCreateBoardCancel() {
            this.isEditMode = false;
            this.editBoard = {};
            this.showCreateBoardModal = false;
        },

        clearSelection() {
            if (this.isStandalone) {
                // Clear template locally when standalone
                this.localSelectedTemplate = null;
            } else {
                // Emit to parent to clear selected template
                this.$emit('template-selected', null);
            }
        },

        onSelectionCleared: function () {
            this.removeTemplateSelection = false;
        },

        onCreateBoardSave(boardData) {
            this.editBoard = {};
            const data = {
                // Basic board info
                id: boardData.id,
                title: boardData.title,
                description: (boardData?.description || '').trim(),
                flag: boardData.flag,
                sessionId: boardData.piBoards || [],
                solutionId: boardData.solutionBoards || [],
                workSpaceId: boardData.collections || [],
                batchId: [],
                objectiveCustomViewId: [],
                piInspectAndAdapt: boardData.piInspectAndAdapt || [],
                piTeamArea: boardData.piTeamArea || null,
                type: boardData.selectedType,
                defaultOrigin: boardData.typeOrigin,
                backgroundColor: boardData.backgroundColor,
                backgroundPattern: boardData.backgroundPattern
            };

            if(data?.defaultOrigin === 'sessionInspect'){
                data.piInspectAndAdapt = data.piInspectAndAdapt.concat(data.sessionId);
            }

            const flag = this.viewType
                ? "workspace"
                : this.contextType;

            if(this.contextType === "session") {
                id = this.sessionId;
            } else if(this.contextType === "solution") {
                id = this.solutionId;
            } else if(this.viewType) {
                id = this.releaseTrainId;
            }
            data.context = { [flag]: id };
            let apiCall = "";

            // console.log("data before sav is : ", data)
            // return;

            if (this.isEditMode && boardData?.id) {
                apiCall = axios.post("/graphx/board/update", data);
            } else if (this.currentSelectedTemplate?.title && this.currentSelectedTemplate.title !== "No Template") {
                data.templateId = this.currentSelectedTemplate.id;
                apiCall = axios.post("/graphx/board/create/using_template", data);
            } else {
                apiCall = axios.post("/graphx/board/create", data);
            }

            apiCall
                .then(response => {
                    if (response.data && response.data.board) {
                        if(this.editBoard){
                            showTopMessage('Board updated successfully', 'success');
                        }else{
                            showTopMessage('Board created successfully', 'success');
                        }

                        this.removeTemplateSelection = true;
                        this.showTemplatesPopup = false;
                        this.$emit('board-created', response.data.board);

                        // Notify child component of new board
                        this.$refs.boardListing.onBoardCreated(response.data.board, flag, id, this.subContext);

                        // Refresh board counts for supported contexts
                        if (this.shouldFetchBoardCounts()) {
                            this.fetchTeamBoardCounts();
                        }
                    }
                })
                .catch(error => {
                    console.error('Error creating board:', error);
                    showTopMessage('Failed to create board', 'error');
                })
                .finally(() => {
                    this.showCreateBoardModal = false;
                    this.isEditMode = false;
                });
        },

        shouldShowBoardInCurrentContext(board) {
            // For inspect and adapt context
            if (this.subContext === 'sessionInspect') {
                // Check if current sessionId is in board's sessions
                return board.piInspectAndAdapt && board.piInspectAndAdapt.some(session => session === this.sessionId);
            }

            // For team area context
            if (this.subContext === 'sessionTeam') {
                if (board.piTeamArea && this.teamId && this.board?.id) {
                    const teamId = typeof this.teamId === 'object' ? this.teamId.id : this.teamId;
                    const teamsForBoard = board.piTeamArea[this.sessionId];
                    return Array.isArray(teamsForBoard) && teamsForBoard.includes(teamId);
                }
                return false;
            }
            if (this.subContext === 'session') {
                if (board.session && this.sessionId) {
                    return Array.isArray(board.session) && board.session.some(
                        session => session?.id === this.sessionId
                    );
                }
                return false;
            }

            return false;
        },

        onEditBoard(board) {
            this.editBoard = board;
            this.isEditMode = true;
            this.showCreateBoardModal = true;
        },

        onCopyBoard(board) {
            this.editBoard = {
                ...board,
                id: null,
                title: `Copy of ${board.title}`,
            };

            this.isEditMode = false;
            this.showCreateBoardModal = true;
        },

        resetBoardForm() {
            this.boardForm = {
                id: null,
                title: '',
                description: '',
                template: '',
                tags: [],
                tagsInput: ''
            };
        },


        closeBoardForm() {
            this.resetBoardForm();
        },

        addTag() {
            if (this.boardForm.tagsInput.trim()) {
                const newTags = this.boardForm.tagsInput.split(',').map(tag => tag.trim()).filter(tag => tag);
                newTags.forEach(tag => {
                    if (!this.boardForm.tags.includes(tag)) {
                        this.boardForm.tags.push(tag);
                    }
                });
                this.boardForm.tagsInput = '';
            }
        },

        removeTag(index) {
            this.boardForm.tags.splice(index, 1);
        },

        onDeleteBoard(board) {
            // Check permissions before allowing delete
            if (!this.permissions.DELETE_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to delete collaboration boards', 'error');
                return;
            }
            axios.delete(`/graphx/delete/session-collab-board/${board.id}`)
                .then(response => {
                    if (response.data.itemRemoved > 0) {
                        showTopMessage('Board deleted successfully', 'warning');
                        // Notify child component of deleted board
                        this.$refs.boardListing.onBoardDeleted(board.id);
                        
                        // Refresh board counts for supported contexts
                        if (this.shouldFetchBoardCounts()) {
                            this.fetchTeamBoardCounts();
                        }
                    }
                })
                .catch(error => {
                    console.error('Error deleting board:', error);
                    showTopMessage('Failed to delete board', 'error');
                });

        },

        onBoardMoved(board) {
            // Refresh board counts when a board is moved to a different type
            if (this.shouldFetchBoardCounts()) {
                this.fetchTeamBoardCounts();
            }
        },

        onBoardClick(board) {
            let id = "";
            let context = "";
            if(this.contextType === "session") {
                id = this.sessionId;
                context = "session";
            } else if(this.contextType === "solution") {
                id = this.solutionId;
                context = "solution";
            } else if(this.viewType) {
                id = this.releaseTrainId;
                context = "art";
            }

            window.open(`/collab#/detail/${board.id}?${context}=${id}`, '_blank');
        },

        onBoardOptions(board) {
            // Handle board options menu - you can implement dropdown menu here
        },

        onClose() {
            // Reset template state when used standalone
            if (this.isStandalone) {
                this.localSelectedTemplate = null;
                this.localTemplatesLoaded = false;
                this.localCollaborationTemplates = [];
            }

            this.$emit('close');
        },

        getContextLabel() {
            const labels = {
                'session': ' - PI Board Session',
                'solution': ' - Solution Board',
                'workspace': ' - Collection',
                'batch': ' - Batch ',
                'objectiveCustomView': ' - Collection OKR'
            };
            return labels[this.contextType] || '(Session)';
        },

        loadAllData() {

            // Promise.all([
                this.loadAllBoards()
                this.loadSolutionBoards()
            this.fetchReleaseTrains().then(() => {
                this.isCollectionsLoading = false;
            });

            // ])
            // .then(([boardsResponse, solutionResponse, releaseTrainsResponse]) => {
            // })
            // .catch(error => {
            //     console.error('Error loading data:', error);
            //     showTopMessage('Failed to load some data', 'error');
            // })
            // .finally(() => {
                this.fetchTeamBoardCounts();
            //     this.isLoadingData = false;
            // });
        },

        loadTypes() {
            this.loadingTypes = true;
            // this.loading = true;
            axios.get('/collaboration-type/all')
                .then(response => {
                    this.loadingTypes = false;
                    if (response.data?.success) {
                        // Get the IDs of types that are already in the navigation links
                        const linkTypeIds = this.links
                            .filter(link => link.id !== 'general' && link.id !== 'inspect' && link.id !== 'teams' && link.id !== 'programBoards' && link.id !== 'collectionPiBoard' && link.id !== 'collectionSolBoard')
                            .map(link => link.id);

                        // Only show types that are NOT already associated (filter out already selected ones)
                        this.types = []
                        response.data.types.forEach(type => {
                            if(!type?.defaultOrigin && !linkTypeIds.includes(type.id)){
                                this.types.push(type);
                            }
                        })
                        // Clear selections since we're only showing unselected types
                        this.selectedTypes = [];
                    }
                })
                .catch(error => {
                    this.loadingTypes = false;
                    console.error('Error loading types:', error);
                })
        },

        toggleTypeDropdown() {
            if (!this.showTypeDropdown) {
                this.loadTypes(); // Only load when opening
                this.typeSearchQuery = ''; // Clear search when opening
            }
            this.showTypeDropdown = !this.showTypeDropdown;
            if (!this.showTypeDropdown) {
                this.showAddTypeInput = false;
                this.newTypeName = '';
                this.typeSearchQuery = '';
            }
        },

        closeTypeDropdown() {
            this.showTypeDropdown = false;
            this.showAddTypeInput = false;
            this.newTypeName = '';
            this.typeSearchQuery = '';
        },

        addSingleType(type) {
            let data = {};
            data.types = [type.id];

            let id = "";
            if(this.contextType === "session") {
                id = this.sessionId;
            } else if(this.contextType === "solution") {
                id = this.solutionId;
            } else if(this.viewType) {
                id = this.releaseTrainId;
            }

            data.context = this.contextType;

            if(this.viewType){
                data.context = "workspace";
            }

            axios.post(`/collaboration-type/link/${id}`, data)
                .then(response => {
                    if (response.data.success) {
                        // Remove the type from the frontend list
                        this.types = this.types.filter(t => t.id !== type.id);
                        this.allContextTypes.push(response.data.type[0]);
                        const linkedType = response.data.type[0];
                        this.allLinks.push(response.data.type[0]);
                        this.links.push({id: linkedType?.id, title: linkedType?.title, rowStatus: linkedType?.rowStatus})
                        // this.fetchContextTypes();
                    }
                })
                .catch(error => {
                    console.error('Error linking type:', error);
                });
        },
        addType() {
            let data = {};
            const name = this.newTypeName.trim();
            let id = "";
            if(this.contextType === "session") {
                if(!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);

                    const sessionId = params.get('id');
                    id = sessionId;
                    data.origin = "sessionBoard";
                }else{
                    id = this.sessionId;
                }

            } else if(this.contextType === "solution") {
                id = this.solutionId;
            } else if(this.viewType) {
                id = this.releaseTrainId;
            }

            data.id = id;
            data.title = name;
            data.context = this.contextType;

            if(this.viewType){
                data.context = "workspace";
            }

            if (name) {
                // id is missing
                axios.post(`/collaboration-type/create`, data)
                    .then(response => {
                        if (response.data?.success) {
                            this.showAddTypeInput = false;
                            this.newTypeName = '';
                            this.showTypeDropdown = false;
                            const type = response.data.type;

                            this.allContextTypes.push(type);

                            this.allLinks.push(type);
                            if(this.contextType === "session") {
                                if(!this.sessionId) {
                                    const params = new URLSearchParams(window.location.search);
                                    const sessionBoardId = params.get('id');
                                    if(type.sessions[0].activeSessionBoard === sessionBoardId) {
                                        this.links.push({id: type?.id, title: type?.title})
                                    }
                                }else{
                                    if(type.sessions[0].id === this.sessionId) {
                                        this.links.push({id: type?.id, title: type?.title})
                                    }
                                }

                            } else if(this.contextType === "solution") {
                                // Check if the type was created for the current solution board
                                if(type.solutionBoards && type.solutionBoards.length > 0 && type.solutionBoards[0].id === this.solutionId) {
                                    this.links.push({id: type?.id, title: type?.title})
                                }
                            } else if(this.viewType) {
                                if(type.workSpaces[0].key === this.releaseTrainId) {
                                    this.links.push({id: type?.id, title: type?.title})
                                }
                                id = this.releaseTrainId;
                            }

                            this.loadTypes();
                        }
                    })
                    .catch(error => {
                        showTopMessage('Failed to add type', 'error');
                    });
            }
            this.showAddTypeInput = false;
            this.newTypeName = '';
        },

        cancelAddType() {
            this.showAddTypeInput = false;
            this.newTypeName = '';
        },

        showCreateNewTypeInput() {
            this.showAddTypeInput = true;
            this.showTypeDropdown = false;
            // Scroll to the bottom of the collab-menu-list to show the input field
            // this.$nextTick(() => {
            //     const menuList = document.querySelector('.collab-left-menu .collab-menu-list');
            //     if (menuList) {
            //         menuList.scrollTop = menuList.scrollHeight;
            //     }
            // });
        },

        selectLink(link) {

            if (link.id === 'teams') {
                this.selectedLink = this.selectedLink === 'teams' ? null : 'teams';
                // Fetch team board counts when teams dropdown is expanded
                if (this.selectedLink === 'teams') {
                    this.fetchTeamBoardCounts();
                }
            } else if (link.id === 'programBoards') {
                this.selectedLink = this.selectedLink === 'programBoards' ? null : 'programBoards';
                // Fetch board counts when program boards dropdown is expanded
                if (this.selectedLink === 'programBoards') {
                    this.fetchTeamBoardCounts();
                }
            } else if (link.id === 'collectionPiBoard') {
                this.selectedLink = this.selectedLink === 'collectionPiBoard' ? null : 'collectionPiBoard';
                // Fetch board counts when collection PI board dropdown is expanded
                if (this.selectedLink === 'collectionPiBoard') {
                    this.fetchTeamBoardCounts();
                }
            } else if (link.id === 'collectionSolBoard') {
                this.selectedLink = this.selectedLink === 'collectionSolBoard' ? null : 'collectionSolBoard';
                // Fetch board counts when collection solution board dropdown is expanded
                if (this.selectedLink === 'collectionSolBoard') {
                    this.fetchTeamBoardCounts();
                }
            } else {
                this.selectedLink = link.id;
                this.selectedTeam = null;
                this.selectedPiBoard = null;
                this.fetchListRelatedToSelectedLink(link);
            }
        },
        selectTeam(team) {
            this.fetchListRelatedToTeam(team);
            this.selectedLink = 'teams';
            this.selectedTeam = team.id;
        },

        fetchListRelatedToTeam: function (payload){
            this.listContext = payload;
            this.listContext.type = "team";
        },

        fetchListRelatedToSelectedLink: function (payload){
            this.listContext = payload
        },

        selectPiBoard(piBoard) {
            this.selectedPiBoard = piBoard.sessionId;
            this.fetchListRelatedToSelectedLink({id: piBoard.sessionId, title: this.getPiTitle(piBoard.sessionId), type: "piBoard"});
        },

        selectCollectionPiBoard(piBoard) {
            this.selectedPiBoard = piBoard.id;
            this.fetchListRelatedToSelectedLink({
                id: piBoard.id,
                title: piBoard.title,
                type: "piBoard"
            });
        },
        selectCollectionSolBoard(solBoard) {
            this.selectedPiBoard = solBoard.id;
            this.fetchListRelatedToSelectedLink({
                id: solBoard.id,
                title: solBoard.title,
                type: "solutionBoard"
            });
        },

        // Add permission checking methods
        getAllowedWorkSpaces() {
            return getAllowedWorkSpacesForUser(loggedInUser);
        },

		getAllowedSolutionAreas: function() {
			var _workSpacesMap = {};
			
			var filteredAccessRoles = _.filter(loggedInUser.accessRoles, function(o) {
				return o.solutionArea ? true : false;
			});
			
			var uniqWS = _.uniqBy(filteredAccessRoles, function(o) {
				return o.solutionArea.id;
			});

			var workSpaceRoleGroup = _.groupBy(filteredAccessRoles, function(o) {
				return o.solutionArea.id;
			});
			$.each(uniqWS, function(index, ws) {
				var space = {}
				space.id = ws.solutionArea.id
				space.roles = [];
				space.permissions = [];
				space.restrictions = [];
				
				if (loggedInUser.isAdmin === true) {
					space.permissions = loggedInUser.permissions;
				} else {
					var accessRoles = workSpaceRoleGroup[space.id];
					if (accessRoles && accessRoles.length > 0) {
						$.each(accessRoles, function(i, accessRole) {
							$.each(accessRole.roles, function(j, role) {
								space.roles.push(role);
								space.permissions = _.union(space.permissions, _.difference(loggedInUser.permissions, role.restrictions))
							});
						});
					}
				}
				_workSpacesMap[space.id] = space;
			});
			return _workSpacesMap;
		},

        // Optimized permission checking - checks all permissions in a single loop
        setupPermissions() {
            if (!this.$options._workSpacesMap) {
                this.$options._workSpacesMap = this.getAllowedWorkSpaces();
            }
            if (!this.$options._solutionAreasMap) {
				this.$options._solutionAreasMap = this.getAllowedSolutionAreas();
			}

            // Initialize all permissions to false
            this.permissions = {
                EDIT_COLLAB_BOARD: false,
                CREATE_COLLAB_BOARD: false,
                DELETE_COLLAB_BOARD: false,
                ALLOW_ASSOCIATION_COLLAB_BOARD: false,
                MOVE_COLLAB_BOARD_TO_OTHER_TYPE: false,
                MANAGE_TEMPLATES: false
            };

            // Check if user is admin - if so, grant all permissions
            if (loggedInUser.isAdmin || loggedInUser.isSuperAdmin) {
                this.permissions = {
                    CREATE_COLLAB_BOARD: true,
                    EDIT_COLLAB_BOARD: true,
                    DELETE_COLLAB_BOARD: true,
                    ALLOW_ASSOCIATION_COLLAB_BOARD: true,
                    MOVE_COLLAB_BOARD_TO_OTHER_TYPE: true,
                    MANAGE_TEMPLATES: true
                };
                return;
            }

            // Check permissions across all accessible workspaces in a single loop
            const permissionActions = {
                CREATE_COLLAB_BOARD: "create-collab-board",
                EDIT_COLLAB_BOARD: "edit-collab-board",
                DELETE_COLLAB_BOARD: "delete-collab-board",
                ALLOW_ASSOCIATION_COLLAB_BOARD: "allow-assocoiation-collab-board",
                MOVE_COLLAB_BOARD_TO_OTHER_TYPE: "move-collab-board-to-other-type",
                MANAGE_TEMPLATES: "manage-template-collab-board"
            };

            /*for (let workspaceId in this.$options._workSpacesMap) {
                let ws = this.$options._workSpacesMap[workspaceId];

                if (ws && ws.permissions && ws.permissions.length > 0) {

                    // Check each permission type
                    for (let permissionKey in permissionActions) {
                        const permissionString = permissionActions[permissionKey];
                        const hasPermission = ws.permissions.indexOf(permissionString) > -1;

                        if (!this.permissions[permissionKey] && hasPermission) {
                            this.permissions[permissionKey] = true;
                        }
                    }
                }
            }
            
            for (let workspaceId in this.$options._solutionAreasMap) {
                let ws = this.$options._solutionAreasMap[workspaceId];

                if (ws && ws.permissions && ws.permissions.length > 0) {

                    // Check each permission type
                    for (let permissionKey in permissionActions) {
                        const permissionString = permissionActions[permissionKey];
                        const hasPermission = ws.permissions.indexOf(permissionString) > -1;

                        if (!this.permissions[permissionKey] && hasPermission) {
                            this.permissions[permissionKey] = true;
                        }
                    }
                }
            }*/
            let solutionAreaId = undefined;
            let workspaceId    = undefined;
            
			if (this.allListingsLoaded) {
				if (this.contextType === "session") {
					let sessionId = undefined;
					if (!this.sessionId) {
						const params = new URLSearchParams(window.location.search);
						sessionId = params.get('id');
					} else {
						sessionId = this.sessionId;
					}
					
					let sessionboard = _.find(this.allSessionBoards,sb=>{
						if (sb.session && sb.session.id == sessionId) {
							return true;
						}
						return false;
					});
					if (sessionboard) {
						workspaceId = sessionboard.session.workSpace.id;
					}
					
				} else if (this.contextType === "solution") {
					const sol = this.solutionBoards.find(sol => sol.id === this.solutionId);
					if (sol) {
						if (sol.solutionArea) {
							solutionAreaId = sol.solutionArea.id;
						}
						else if (sol.workSpace) {
							workspaceId = sol.workSpace.id;
						}
					}
				} else if (this.viewType) {
					const col = this.collections?.workspaces?.find(col => col?.key === this.releaseTrainId);
					if (col) {
						workspaceId = col.id;
					}
				}
			}
			if (workspaceId) {
				let ws = this.$options._workSpacesMap[workspaceId];

                if (ws && ws.permissions && ws.permissions.length > 0) {

                    // Check each permission type
                    for (let permissionKey in permissionActions) {
                        const permissionString = permissionActions[permissionKey];
                        const hasPermission = ws.permissions.indexOf(permissionString) > -1;

                        if (!this.permissions[permissionKey] && hasPermission) {
                            this.permissions[permissionKey] = true;
                        }
                    }
                }
			}
			else if (solutionAreaId) {
				
				let ws = this.$options._solutionAreasMap[solutionAreaId];

                if (ws && ws.permissions && ws.permissions.length > 0) {

                    // Check each permission type
                    for (let permissionKey in permissionActions) {
                        const permissionString = permissionActions[permissionKey];
                        const hasPermission = ws.permissions.indexOf(permissionString) > -1;

                        if (!this.permissions[permissionKey] && hasPermission) {
                            this.permissions[permissionKey] = true;
                        }
                    }
                }
			}
			else {
				/*this.permissions = {
                    CREATE_COLLAB_BOARD: true,
                    EDIT_COLLAB_BOARD: true,
                    DELETE_COLLAB_BOARD: true,
                    ALLOW_ASSOCIATION_COLLAB_BOARD: true,
                    MOVE_COLLAB_BOARD_TO_OTHER_TYPE: true,
                    MANAGE_TEMPLATES: true
                };*/
			}
        },

        // Helper method to check if a specific action is allowed (for backward compatibility)
        isActionAllowed(action) {
            if (!this.permissions) {
                this.setupPermissions();
            }

            // Map action to permission key
            const actionToPermissionMap = {
                "create-collab-board": "CREATE_COLLAB_BOARD",
                "edit-collab-board":   "EDIT_COLLAB_BOARD",
                "delete-collab-board": "DELETE_COLLAB_BOARD",
                "allow-assocoiation-collab-board": "ALLOW_ASSOCIATION_COLLAB_BOARD",
                "move-collab-board-to-other-type": "MOVE_COLLAB_BOARD_TO_OTHER_TYPE",
                "manage-template-collab-board": "MANAGE_TEMPLATES"
            };

            const permissionKey = actionToPermissionMap[action];
            return permissionKey ? this.permissions[permissionKey] : false;
        },

        // Toggle templates section visibility
        toggleTemplatesSection() {
            this.showTemplatesSection = !this.showTemplatesSection;
        },

        // Fetch board counts for teams or PI boards based on context
        fetchTeamBoardCounts() {
            // Define context mapping for cleaner code
            const contextConfig = {
                session: { id: this.sessionId, label: 'team board', context: 'session' },
                solution: { id: this.solutionId, label: 'PI board', context: 'solution' }
            };

            // Handle workspace context
            if (this.viewType) {
                contextConfig.workspace = { 
                    id: this.releaseTrainId, 
                    label: 'workspace board', 
                    context: 'workspace' 
                };
            }

            const config = contextConfig[this.contextType] || contextConfig.workspace;

            if(this.contextType === "session"){
                if(!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);
                    const sessionId = params.get('id');
                    contextConfig.session.id = sessionId;
                    contextConfig.session.context = 'sessionBoard'
                }else{
                    contextConfig.session.id = this.sessionId;
                }
            }
            
            // Early return if context is not supported or ID is missing
            if (!config || !config.id) {
                this.teamBoardCounts = {};
                return;
            }

            const data = { context: config.context };

            axios.post(`/graphx/getBoardCount/${config.id}`, data)
                .then(response => {
                    if (response.data && response.data.success) {
                        this.teamBoardCounts = response.data.boardCounts || {};
                    } else {
                        this.teamBoardCounts = {};
                    }
                })
                .catch(error => {
                    console.error(`Error fetching ${config.label} counts:`, error);
                    this.teamBoardCounts = {};
                });
        },

        // Get board count for a specific team or PI board
        getTeamBoardCount(id) {
            return this.teamBoardCounts[id] || 0;
        },

        // Check if current context supports board counting
        shouldFetchBoardCounts() {
            return ['session', 'solution'].includes(this.contextType) || 
                   (this.viewType);
        },

        // Get teams sorted by board count in descending order
        getSortedTeams() {
            if (!this.currentSessionBoard || !this.currentSessionBoard.teams) {
                return [];
            }
            
            return this.currentSessionBoard.teams.slice().sort((a, b) => {
                const countA = this.getTeamBoardCount(a.id);
                const countB = this.getTeamBoardCount(b.id);
                return countB - countA; // Descending order (highest count first)
            });
        },

        // Get PI boards sorted by board count in descending order
        getSortedPiBoards() {
            if (!this.activeSolutionBoard || !this.activeSolutionBoard.piBoards) {
                return [];
            }
            
            return this.activeSolutionBoard.piBoards.slice().sort((a, b) => {
                const countA = this.getTeamBoardCount(a.sessionId);
                const countB = this.getTeamBoardCount(b.sessionId);
                return countB - countA; // Descending order (highest count first)
            });
        },

        // Get collection PI boards sorted by board count in descending order
        getSortedCollectionPiBoards() {
            if (!this.collectionAssociatedProgramBoards) {
                return [];
            }
            
            return this.collectionAssociatedProgramBoards.slice().sort((a, b) => {
                const countA = this.getTeamBoardCount(a.id);
                const countB = this.getTeamBoardCount(b.id);
                return countB - countA; // Descending order (highest count first)
            });
        },

        // Get collection solution boards sorted by board count in descending order
        getSortedCollectionSolBoards() {
            if (!this.collectionAssociatedSolBoards) {
                return [];
            }
            
            return this.collectionAssociatedSolBoards.slice().sort((a, b) => {
                const countA = this.getTeamBoardCount(a.id);
                const countB = this.getTeamBoardCount(b.id);
                return countB - countA; // Descending order (highest count first)
            });
        },

        isCustomTypeWithZeroBoards(link) {
            // Check if the link is a custom type (not general, inspect, teams, programBoards, collectionPiBoard, collectionSolBoard)
            // and if its board count is 0.
            const isCustomType = !['general', 'inspect', 'teams', 'programBoards', 'collectionPiBoard', 'collectionSolBoard'].includes(link.id);
            const hasZeroBoards = this.getTeamBoardCount(link.id) === 0;
            return isCustomType && hasZeroBoards;
        },

        toggleTypeMenu(typeId) {
            // Close other menus first
            if (this.activeTypeMenu === typeId) {
                this.activeTypeMenu = null;
            } else {
                this.activeTypeMenu = typeId;
            }
        },

        closeTypeMenus(event) {
            // Close type menus when clicking outside
            if (!event.target.closest('.type-menu-btn') && !event.target.closest('.type-menu-dropdown')) {
                this.activeTypeMenu = null;
            }
        },

        removeType(link) {

            this.activeTypeMenu = null;

            // Use the custom confirmation modal
            askFromSweetAlertWrapper(
                "Are you sure you want to remove this type from the current context? This will unlink it but not delete the type itself.",
                [() => this.performRemoveType(link), null],
                [takeNoAction],
                "Are you sure?",
                "Yes"
            );
        },

        performRemoveType(link) {
            let data = {};
            data.types = [link.id];

            let id = "";
            if(this.contextType === "session") {
                if(!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);
                    const sessionId = params.get('id');
                    id = sessionId;
                } else {
                    id = this.sessionId;
                }
            } else if(this.contextType === "solution") {
                id = this.solutionId;
            } else if(this.viewType) {
                id = this.releaseTrainId;
            }

            data.context = this.contextType;

            if(this.viewType){
                data.context = "workspace";
            }

            axios.post(`/collaboration-type/unlink/${id}`, data)
                .then(response => {
                    if (response.data.success) {
                        showTopMessage('Type removed successfully', 'success');
                        // Remove from links arrays
                        this.allLinks = this.allLinks.filter(l => l.id !== link.id);
                        this.links = this.links.filter(l => l.id !== link.id);
                        // Add back to available types
                        this.loadTypes();
                    } else {
                        showTopMessage('Failed to remove type', 'error');
                    }
                })
                .catch(error => {
                    console.error('Error removing type:', error);
                    showTopMessage('Failed to remove type', 'error');
                });
        },

        // Toggle show all links functionality
        toggleShowAllLinks() {
            this.showAllLinks = !this.showAllLinks;
        },

        handleSolutionBoardContext(newVal) {
            this.allContextTypes.find(type => {
                const boardFound = type?.solutionBoards?.some(board => board.id === newVal?.id);
                const collection = type?.workSpaces?.some(workSpace => workSpace.key === this.releaseTrainId);
                if (boardFound && collection) {
                    this.selectedType = type;
                    return true;
                }else{
                    this.selectedType = newVal;
                }
                return false;
            });
        },

        handlePiBoardContext(newVal) {
            this.allContextTypes.find(type => {
                const boardFound = type?.sessions?.some(session => session.id === newVal?.id);
                const collection = type?.workSpaces?.some(workSpace => workSpace.key === this.releaseTrainId);
                if (boardFound && collection) {
                    this.selectedType = type;
                    return true;
                }else{
                    this.selectedType = newVal;
                }
                return false;
            });
        },

        handleSolutionPiBoardContext(newVal) {
            this.allContextTypes.find(type => {
                const boardFound = type?.sessions?.some(session => session.id === newVal?.id);
                const solution = type?.solutionBoards?.some(solution => solution.id === this.solutionId);
                if (boardFound && solution) {
                    this.selectedType = type;
                    return true;
                }else{
                    this.selectedType = newVal;
                }
                return false;
            });
        },

        handleGeneralContext(origin) {
            this.allContextTypes.find(type => {
                if (type.defaultOrigin === origin) {
                    this.selectedType = type;
                    return true;
                }
                return false;
            });
        },
        handleTeamContext(newVal) {
            this.allContextTypes.find(type => {
                const teamIdsArrays = Object.values(type?.teams || {});
                const teamFound = teamIdsArrays.some(idsArray => idsArray.includes(newVal?.id));
                if (teamFound) {
                    this.selectedType = type;
                    return true;
                }else{
                    this.selectedType = newVal;
                }
                return false;
            });
        },

        handleCustomType(newVal){
            this.allContextTypes.find(type => {
                if (type?.id === newVal?.id) {
                    this.selectedType = type;
                    return true;
                }
                return false;
            });
        }

    }
});
