const COLLABORATION_BOARD_LISTING = Vue.component('collaboration-board-listing', {
    name: 'collaboration-board-listing',
    template: `
        <div class="dashboardTabsWraper">
<!--        	<div class="maintabs nw grn">-->
<!--        		<div class="tabgenrl" :class="{ active: activeTab === 'all' }" @click="switchTab('all')">Association <span class="infotxt tooltip ml-5"><span class="hovtooltipB">View all collaboration boards</span></span></div>-->
<!--        		<div class="tabgenrl" :class="{ active: activeTab === 'context' }" @click="switchTab('context')">Created from Context <span class="infotxt tooltip ml-5"><span class="hovtooltipB">View boards created from current context</span></span></div>-->
<!--        	</div>-->
        
            
	    	<div class="maintbconta inn rnd8">
                
                <div class="clbfilt DFCB">
                <div class="lft DFA">
                	 <div class="srchcrt p-rel">
                        <input v-model="searchText" type="text" placeholder="Search..." class="rnd4 pr-50" @input="onSearchInput" />
                        <em class="ico srchnw search-icon DF p-abs"></em>
                    </div>
                </div>
                <div class="rht DFA">  
                	<a href="javascript:void(0);" @click="onCreateNewBoard()" class="button ti-plus addf rnd4 ml-10" v-if="permissions.CREATE_COLLAB_BOARD">Create Board</a>
<!--                	<a -->
<!--                	    href="javascript:void(0);" -->
<!--                	    class="reset und ftsb" -->
<!--                	    @click="resetFilters" -->
<!--                	    v-if="boardData?.teams?.length > 0 || boardData?.piBoards?.length > 0 || boardData?.solutionBoards?.length > 0 || boardData?.collections?.length > 0"-->
<!--                	> Reset</a>                   -->
                    
<!--                    <div class="selectcont rnd4 rhtsd statusDrop">-->
<!--                        <vz-select -->
<!--                            v-if="teamOptions"-->
<!--                            :multiple="true" -->
<!--                            track-by="title" -->
<!--                            :empty-selection-text="teamsFilterTitle"-->
<!--                            :selected-title="teamsFilterTitle"-->
<!--                            v-model="boardData.teams" -->
<!--                            :options="teamOptions"-->
<!--                            class="multi-filter" -->
<!--                            value-type="value"-->
<!--                            placeholder="Choose Team"-->
<!--                        />-->
<!--                    </div>-->
<!--                    <div class="selectcont rnd4 rhtsd statusDrop create-collab-association">-->
<!--                        <vz-select -->
<!--                            v-if="sessionBoardOptions"-->
<!--                            :multiple="true" -->
<!--                            track-by="id" -->
<!--                            :empty-selection-text="programBoardsFilterTitle"-->
<!--                            :selected-title="programBoardsFilterTitle"-->
<!--                            v-model="boardData.piBoards" -->
<!--                            :options="sessionBoardOptions"-->
<!--                            class="multi-filter" -->
<!--                            value-type="value"-->
<!--                            placeholder="Choose Program Boards"-->
<!--                        />-->
<!--                    </div>-->
                   
<!--                    <div class="selectcont rnd4 rhtsd statusDrop"> -->
<!--                        <vz-select -->
<!--                            v-if="solutionBoardOptions"-->
<!--                            :multiple="true" -->
<!--                            track-by="id" -->
<!--                            :empty-selection-text="solutionBoardsFilterTitle"-->
<!--                            :selected-title="solutionBoardsFilterTitle"-->
<!--                            v-model="boardData.solutionBoards" -->
<!--                            :options="solutionBoardOptions"-->
<!--                            class="multi-filter" -->
<!--                            value-type="value"-->
<!--                            placeholder="Choose Solution Boards"-->
<!--                        />-->
<!--                    </div>-->
                    
<!--                    <div class="selectcont rnd4 rhtsd statusDrop">-->
<!--                        <vz-select -->
<!--                            v-if="collectionOptions"-->
<!--                            :multiple="true" -->
<!--                            track-by="id" -->
<!--                            :empty-selection-text="collectionsFilterTitle"-->
<!--                            :selected-title="collectionsFilterTitle"-->
<!--                            v-model="boardData.collections" -->
<!--                            :options="collectionOptions"-->
<!--                            class="multi-filter" -->
<!--                            value-type="value"-->
<!--                            placeholder="Choose Collections"-->
<!--                        />-->
<!--                    </div>-->
<!--                    <button class="button-w txgrn brgrn wht-nwrp rnd4" @click="fetchFilteredData()"> Update Filter</button>                   -->
                    </div>
                </div>

                <!-- Board Table -->
                <div v-if="filteredBoards && filteredBoards.length > 0" class="tableContainer table">
                        
                            <div class="rec hd">
                                <div class="rc c1 dashTitle c-point" @click="onClickSort('title')">
                                    Board
                                    <img v-if="sortBy.value === 'title'" src="/assets/icons/Dashboard/sort.svg" alt="Sort" class="ml-5 c-point sortIcon" :class="{'active': sortBy.ascending}"/>
                                </div>
                                <div class="rc c2 created">Associations</div>
                                <div class="rc c3 created c-point" @click="onClickSort('createdOn')">
                                    Created
                                    <img v-if="sortBy.value === 'createdOn'" src="/assets/icons/Dashboard/sort.svg" alt="Sort" class="ml-5 c-point sortIcon" :class="{'active': sortBy.ascending}"/>
                                </div>
<!--                                <div class="rc c3 created">Updated</div>-->
                            </div>
                        
                            <div v-for="(board, index) in filteredBoards" :key="board.id" class="rec" @click="onClickBoard(board)">
                                <!-- Board Title -->
                                <div class="rc c1">
                                    <div class="board-info">
                                        <div class="board-icon">
                                        	<svg width="28" height="20" viewBox="0 0 28 20" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M0.336371 6.15966C0.0243056 6.03466 0 5.75741 0 5.67546C0 5.5935 0.0243056 5.31626 0.336371 5.19146L12.6636 0.25666C13.0891 0.0863167 13.5388 0 13.9999 0C14.4611 0 14.9108 0.0863167 15.3363 0.25666L27.6635 5.19146C27.9756 5.31647 27.9999 5.59351 27.9999 5.67546C27.9999 5.7574 27.9756 6.03466 27.6635 6.15945L15.3363 11.0943C14.9108 11.2646 14.4611 11.3511 13.9999 11.3511C13.5388 11.3511 13.0891 11.2648 12.6636 11.0945L0.336371 6.15966ZM27.6635 13.8403C27.9756 13.9653 27.9999 14.2426 27.9999 14.3245C27.9999 14.4065 27.9756 14.6837 27.6635 14.8085L15.3363 19.7433C14.9108 19.9137 14.4611 20 13.9999 20C13.5388 20 13.0891 19.9137 12.6636 19.7433L0.336371 14.8085C0.0243056 14.6837 0 14.4065 0 14.3245C0 14.2426 0.0243056 13.9653 0.336371 13.8406L3.62892 12.5225L12.3961 16.0321C12.9094 16.2374 13.4545 16.3402 13.9998 16.3402C14.5452 16.3402 15.0903 16.2374 15.6033 16.0321L24.3711 12.5223L27.6635 13.8403ZM27.6635 10.484L15.3363 15.4188C14.9108 15.5891 14.4611 15.6755 13.9999 15.6755C13.5388 15.6755 13.0891 15.5891 12.6636 15.4188L0.336371 10.484C0.0243056 10.3592 0 10.082 0 10C0 9.91806 0.0243056 9.64081 0.336371 9.51602L3.62892 8.19798L12.3961 11.7076C12.9094 11.9129 13.4545 12.0156 13.9998 12.0156C14.5452 12.0156 15.0903 11.9129 15.6033 11.7076L24.3711 8.19798L27.6636 9.51602C27.9757 9.64082 28 9.91806 28 10C28 10.082 27.9756 10.3592 27.6635 10.484Z" fill="#26BAA1"/>
											</svg>
                                        </div>
                                        <div class="board-content">
                                            <div class="board-link"><strong>{{board.title}}</strong></div>
                                            <div class="board-meta" v-if="board?.description"><small class="text-muted">{{board.description}}</small></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Associations -->
                                <div class="rc c2 associations" @click.stop>
                                    <div v-if="loading" class="loading-associations">
                                        <i class="ti-reload loading-spinner"></i>
                                    </div>
                                    <div v-else class="associations-container">
                                        <!-- Teams -->
                                        <div v-if="getTeamAssociations(board).length > 0 && teamsMeta" class="association-group">
                                            <div v-for="team in getTeamAssociations(board)" 
                                                 :key="team.id" 
                                                 class="association-tag team-tag"
                                                 @click="onAssociationClick('team', team)">
                                                {{team.title}}
                                            </div>
                                        </div>
                                        
                                        <!-- Program Boards OR Inspect and Adapt -->
                                        <div v-if="getInspectAndAdaptAssociations(board)?.length > 0" class="association-group">
                                            <div v-for="inspect in getInspectAndAdaptAssociations(board)" 
                                                 :key="inspect.id" 
                                                 class="association-tag inspect-tag"
                                                 @click="onAssociationClick('inspect', inspect)">
                                                {{inspect.title}}
                                            </div>
                                        </div>
                                        <div v-else-if="getProgramBoardAssociations(board).length > 0" class="association-group">
                                            <div v-for="program in getProgramBoardAssociations(board)" 
                                                 :key="program.id" 
                                                 class="association-tag program-tag"
                                                 @click="onAssociationClick('session', program)">
                                                {{program.title}}
                                            </div>
                                        </div>
                                        
                                        <!-- Solution Boards -->
                                        <div v-if="getSolutionBoardAssociations(board).length > 0" class="association-group">
                                            <div v-for="solution in getSolutionBoardAssociations(board)" 
                                                 :key="solution.id" 
                                                 class="association-tag solution-tag"
                                                 @click="onAssociationClick('solution', solution)">
                                                {{solution.title}}
                                            </div>
                                        </div>
                                        
                                        <!-- Collections -->
                                        <div v-if="getCollectionAssociations(board).length > 0" class="association-group">
                                            <div v-for="collection in getCollectionAssociations(board)" 
                                                 :key="collection.id" 
                                                 class="association-tag collection-tag"
                                                 @click="onAssociationClick('collection', collection)">
                                                {{collection.title}}
                                            </div>
                                        </div>
                                        
                                        <span v-if="!hasAnyAssociations(board)" class="text-muted">No associations</span>
                                    </div>
                                </div>

                                <!-- Created Date -->
                                <div class="rc c3 created">
                                    <span class="date-text" :title="'Created by ' + getCreatedBy(board) + ' on ' + getFullDateTime(board.createdOn)">{{formatDateTime(board.createdOn)}}</span>
                                </div>
<!--                                <div class="rc c3 created">-->
<!--                                  <span class="date-text">{{ board.updatedOn ? formatDate(board.updatedOn) : '-' }}</span>-->
<!--                                </div>-->
                                <!-- Owner -->
<!--                                <div class="rec c3 owner" @click.stop>-->
<!--                                    <div class="owner-info">-->
<!--                                        <div class="owner-avatar">-->
<!--                                            <img v-if="getOwnerUser(board) && getOwnerUser(board).picturePath" -->
<!--                                                 :src="getUserPictureUrl(getOwnerUser(board))" -->
<!--                                                 :alt="getCreatedBy(board)" />-->
<!--                                            <div v-else class="avatar-initials">-->
<!--                                                {{getOwnerInitials(board)}}-->
<!--                                            </div>-->
<!--                                        </div>-->
<!--                                        <span class="owner-name">{{getCreatedBy(board)}}</span>-->
<!--                                    </div>-->
<!--                                </div>-->
                                
                                <!-- Actions Column -->
                                
                                    <div class="actions-dropdown p-abs" :class="{ active: activeDropdown === board.id }" @click.stop>
                                        <a href="javascript:void(0);" class="actions-menu-btn DAJ ti-more-alt" @click="toggleActionsMenu(board.id, $event)"></a>
                                        
                                        <!-- Dropdown Menu -->
                                        <div v-if="activeDropdown === board.id" class="drop_box nwmu sml artp actions-menu" style="display:block;"><ul>
                                            <li class="actions-menu-item DFA" @click="onEditBoard(board)">
                                                <i class="ti-settings icolf"></i>
                                                <span>Setting</span>
                                            </li>
                                            <li class="actions-menu-item DFA" @click="onMoveToType(board)" v-if="permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE">
                                                <i class="ti-export icolf"></i>
                                                <span>Move To</span>
                                            </li>
                                            <li class="actions-menu-item DFA" @click="onCopyBoard(board)">
                                                <i class="ti-layers icolf"></i>
                                                <span>Copy Board</span>
                                            </li>
                                            <li class="actions-menu-item DFA" @click="onDelete(board)" v-if="permissions.DELETE_COLLAB_BOARD">
                                                <i class="ti-trash icolf"></i>
                                                <span>Delete Board</span>
                                            </li>
                                        </ul></div>
                                    </div> <!-- Menu End -->                                 
                                
                            </div>      <!-- rec End -->                 
                </div><!-- Table End -->

                <!-- Filter Empty State -->
                <div v-else-if="searchText.trim()!=='' && boards.length === 0" class="empty-state">
                    <div class="empty-content">
                        <h3>No boards found</h3>
                        <p>Refine your search to see matching boards.</p>
                    </div>
                </div>
                <!-- Empty State -->
                <div v-else-if="!loading" class="empty-state">
                    <div class="empty-content">
                        <div class="empty-icon"></div>
                        <h3>No Collaboration Boards</h3>
                        <p>Create your first collaboration board to get started with visual collaboration.</p>
                        <a class="button share DIB rnd4" href="javascript:void(0);" @click="onCreateNewBoard()" v-if="permissions.CREATE_COLLAB_BOARD"><em class="ti-plus ico" ></em>Add Collaboration Board</a>
                    </div>
                </div>

                <!-- Loading State -->
                <div v-if="loading" class="loading-state">
                    <div class="loading-content">
                        <i class="ti-reload loading-spinner"></i>
                        <p>Loading boards...</p>
                    </div>
                </div>
            </div>
            
            <a class="ti-plus addf ftsb mt-10 DIB crtlstng" href="javascript:void(0);" @click="onCreateNewBoard()" v-if="permissions.CREATE_COLLAB_BOARD && boards?.length > 0">Create Board</a>
          
            <div v-if="boards?.length > 0" class="pagging t-center">
                <input hidden="hidden" type="number" title="temporary binding due to redrening issue"/>
                <template>
                    <div class="paginator collab">
                       <vue-ads-pagination :key="paginationKey" :total-items="pagination.totalItemSize" :items-per-page="pagination.pageSize" v-on:page-change="onPaginatorChangePage">
                            <template slot-scope="props"><div class="txt">{{ props.start }} to {{ props.end }} of {{ props.total }} Items</div></template>
                       </vue-ads-pagination>
                   </div>
                   <span class="selectcont rnd4 pgsize" style="margin-left: 0;">
                       <select v-model="pagination.pageSize" class="" @change="onChangePageSizeofpopup">
                            <option v-for="option in pagination.pageSizeOptions" :value="option">{{option}}</option>
                       </select>
                   </span>
                </template>            
            </div>            
            
              
            <!-- Move To Type Modal -->
            <div v-if="showMoveToModal" class="create-board-overlay">
                <div class="create-board-modal ui-dialog movedialg">
                    <h2 class="head">
                        Move Collab Board
                        <a href="javascript:void(0);" class="rmv-ico ti-close" @click="closeMoveToModal"></a>
                    </h2>
                    
                    <div class="cntr prow">
                        <div class="rec">
                            <label class="form-label ftsb">Current Type</label>
                            <div class="slctdntag FL ftsb rnd4 p-rel">{{ getCurrentTypeName(selectedBoard) }}</div>
                        </div>
                        
                        <div class="rec">
                            <label class="form-label ftsb">Select New Type
	                            <span class="infotxt tooltip mht nw2 nwhv ml-10">
	                                <span class="hovtooltipB wdt35">Change the type to relocate this collab board to another category.</span>
	                            </span>
                            </label>                            
                            <div class="selectcont rnd4">
                                <vz-select 
                                    :multiple="false" 
                                    track-by="id" 
                                    empty-selection-text="Select Type"
                                    :selected-title="getSelectedTypeTitle"
                                    v-model="selectedTypeId" 
                                    :options="availableTypes"
                                    class="multi-filter" 
                                    value-type="object"
                                    placeholder="Select Type"
                                    @change="onTypeSelectionChange"
                                />
                            </div>
                        </div>
                        
                        <div v-if="showTeamDropdown" class="form-section mb-20">
                            <label class="form-label ftsb">Select Team</label>
                            <div class="selectcont rnd4">
                                <vz-select 
                                    v-if="sessionTeams.length > 0"
                                    :multiple="true" 
                                    track-by="id" 
                                    empty-selection-text="Choose Teams"
                                    selected-title="Teams Selected"
                                    v-model="chosenTeams" 
                                    :options="sessionTeams"
                                    class="multi-filter" 
                                    value-type="object"
                                    placeholder="Choose Teams"
                                    :disabled="!permissions.MOVE_COLLAB_BOARD_TO_OTHER_TYPE"
                                />
                            </div>
                        </div>
                    </div>
                    
                    <div class="rec btn">
				    	<button type="button" class="rnd4 FR" @click="confirmMoveToType">Confirm</button>
                        <a href="javascript:void(0);" class="cncl FR" @click="closeMoveToModal">Cancel</a>
<!--                        :disabled="!selectedTypeId || selectedTypeId === getCurrentTypeId(selectedBoard) || isMovingType"-->
                    </div>
                </div>
            </div>
        </div>`,

    props: {
        listContext:{
            default: null
        },
        sessionId: {
            default: ''
        },
        contextType: {
            type: String,
            default: ''
        },
        subContext: {
            type: String,
            default: ''
        },
        teamId: {
            type: [Object, String, Number],
            default: null
        },
        solutionId: {
            type: String,
            default: ''
        },
        workspaceId: {
            type: String,
            default: ''
        },
        viewType: {
            type: String,
            default: ''
        },
        releaseTrainId: {
            type: String,
            default: ''
        },
        searchQuery: {
            type: String,
            default: ''
        },
        sessionBoards: {
            type: Array,
            default: () => []
        },
        sessionBoardMap: {
            type: Object,
            default: () => ({})
        },
        sessionBoardOptions: {
            type: Array,
            default: () => []
        },
        solutionBoards: {
            type: [Object, Array],  // Allow both Object and Array
            default: () => ({})
        },
        solutionBoardOptions: {
            type: Array,
            default: () => []
        },
        collections: {
            type: [Object, Array],  // Allow both Object and Array
            default: () => ({})
        },
        collectionOptions: {
            type: Array,
            default: () => []
        },
        teams: {
            type: [Object, Array],  // Allow both Object and Array
            default: () => ({})
        },
        teamOptions: {
            type: Array,
            default: () => []
        },
        permissions: {
            type: Object,
            default: () => ({
                CREATE_COLLAB_BOARD: false,
                DELETE_COLLAB_BOARD: false,
                ALLOW_ASSOCIATION_COLLAB_BOARD: false,
                MOVE_COLLAB_BOARD_TO_OTHER_TYPE: false
            })
        }
    },

    data() {
        return {
            contextBoard: null,
            showTeamDropdown: false,
            chosenTeams: [],
            sessionTeams: [],
            isBoardCreatedEmit: false,
            teamsMeta: [],
            applyFilters: false,
            urlId: "",
            boardData: {
                collections: [],
                teams: [],
                piBoards: [],
                solutionBoards: [],
            },
            searchText: "",
            filters: [],
            currentPageIndex: -1,
            loading: false,
            error: null,
            boards: [],
            filteredBoards: [],
            activeDropdown: null,
            pagination: {
                currentPage: 0, // Start with 0-based indexing
                pageSize: 10,
                totalItemSize: 0,
                pageSizeOptions: [10, 25, 50, 100]
            },
            paginationKey: 0,
            isPageChangeInProgress: false,
            // activeTab: 'all', // Added for tab functionality
            currentRequest: null, // Add this to track current request
            lastRequestTime: 0, // Add this to track request timing
            searchDebounceTimeout: null, // Add this line for debouncing

            // Move To Type Modal properties
            showMoveToModal: false,
            selectedBoard: null,
            selectedTypeId: null,
            availableTypes: [],
            moveToType: null,
            isMovingType: false,

            // Sorting properties
            sortBy: {
                value: 'createdOn', // default sort by title
                ascending: false
            }
        }
    },

    computed: {
        // Computed properties for filter dropdown titles with counts
        teamsFilterTitle() {
            const count = this.boardData.teams ? this.boardData.teams.length : 0;
            return `Teams (${count})`;
        },

        programBoardsFilterTitle() {
            const count = this.boardData.piBoards ? this.boardData.piBoards.length : 0;
            return `Program Boards (${count})`;
        },

        solutionBoardsFilterTitle() {
            const count = this.boardData.solutionBoards ? this.boardData.solutionBoards.length : 0;
            return `Solution Boards (${count})`;
        },

        collectionsFilterTitle() {
            const count = this.boardData.collections ? this.boardData.collections.length : 0;
            return `Collections (${count})`;
        },

        getSelectedTypeTitle() {
            if (!this.selectedTypeId) {
                return '';
            }

            // Handle both object and string cases
            const typeId = typeof this.selectedTypeId === 'object' ? this.selectedTypeId.id : this.selectedTypeId;
            const selectedType = this.availableTypes.find(type => type.id === typeId);
            return selectedType ? selectedType.title : '';
        }
    },

    watch: {
        selectedTypeId: {
            handler(newType){
                if(newType?.id === "selectTeams"){
                    this.showTeamDropdown = true;
                }else{
                    this.showTeamDropdown = false;
                }
            }
        },

        searchQuery: {
            handler(newVal) {
                this.searchText = newVal || "";
                // Clear any existing timeout
                if (this.searchDebounceTimeout) {
                    clearTimeout(this.searchDebounceTimeout);
                }

                // Set a new timeout
                this.searchDebounceTimeout = setTimeout(() => {
                    // Update filters with search text
                    this.updateFiltersWithSearch();
                    // Reset to page 1 when searching
                    this.resetPagination();
                    this.loadBoards();
                }, 300); // Wait for 300ms after the user stops typing
            },

        },

        listContext: {
            handler(newVal, oldVal) {
                // Reset to page 1 when context changes
                this.$set(this.pagination, 'currentPage', 0);
                this.paginationKey += 1;
                this.loadBoards(newVal);
            },
            deep: true // If listContext is an object and you want to watch nested changes
        },

        // 'pagination.currentPage': {
        //     handler(newVal, oldVal) {
        //         // Remove the watcher - we'll handle page changes directly in onPaginatorChangePage
        //     }
        // },

        'pagination.pageSize': {
            handler() {
                this.resetPagination();
                this.loadBoards();
            }
        }
    },

    mounted() {
            // Initialize search text from prop
            this.searchText = this.searchQuery || "";

            // const params = new URLSearchParams(window.location.search);
            //
            // const sessionId = params.get('id');
            // const tab = params.get('tab');
            // const moreOptionsIndex = params.get('moreOptionsIndex');
            // const moreOptionsSubIndex = params.get('moreOptionsSubIndex');
            //
            // this.urlId = sessionId;
            //
            // const board = this.sessionBoardMap[sessionId];
            // this.urlId = sessionId;

            // You can now use `sessionId` or other values as needed
            // this.sessionId = sessio

            this.loadBoards();
        // document.addEventListener('click', this.handleClickOutside);
    },

    // beforeDestroy() {
    //     document.removeEventListener('click', this.handleClickOutside);
    // },

    components: {
        VueAdsPagination: window["vue-ads-pagination"].default,
        VueAdsPageButton: window["vue-ads-pagination"].VueAdsPageButton,
    },

    methods: {

        resetFilters: function(){
            this.applyFilters = false;
            this.boardData.collections = [];
            this.boardData.solutionBoards = [];
            this.boardData.piBoards = [];
            this.boardData.teams = [];
            this.filters = [];
            this.$set(this.pagination, 'currentPage', 0);
            this.paginationKey += 1;
            this.loadBoards();
        },

        fetchFilteredData: function (){
            this.applyFilters = true;
            // Initialize filters array
            this.filters = [];

            // Add search filter if search text exists
            if (this.searchText && this.searchText.trim()) {
                this.filters.push({"search": this.searchText.trim()});
            }

            // Add other filters
            this.filters.push({"workspace": this.boardData.collections});
            this.filters.push({"solution": this.boardData.solutionBoards});
            this.filters.push({"session": this.boardData.piBoards});

            const selectedTeamIds = [];
            this.boardData?.teams?.forEach(selectedTeam => {
                // Find all teams in this.teams array that match the selected team's title
                const matchingTeams = this.teamsMeta?.filter(team =>
                    team.title === selectedTeam
                );

                // Add all matching team IDs to our array
                matchingTeams.forEach(team => {
                    if (!selectedTeamIds.includes(team.id)) {
                        selectedTeamIds.push(team.id);
                    }
                });
            });

            // Add team filter with all matching IDs
            this.filters.push({"team": selectedTeamIds});

            this.$set(this.pagination, 'currentPage', 0);
            // when user type something make query for first page
            this.paginationKey += 1;
            this.loadBoards();

        },

        loadBoards() {
            if (this.isPageChangeInProgress) {
                return;
            }
            this.$emit('is-boards-load');
            // Cancel any pending request
            if (this.currentRequest) {
                this.currentRequest.cancel();
            }

            const requestTime = Date.now();
            this.lastRequestTime = requestTime;

            // this.loading = true;
            this.error = null;
            this.isPageChangeInProgress = true;

            const flag = this.viewType
                ? "workspace"
                : this.contextType;

            const payload = {
                flag,
                teamId: this.subContext === "sessionTeam" ? this.teamId.id : "",
                subContext: this.subContext,
                page: this.pagination.currentPage,
                pageSize: this.pagination.pageSize
            };
            let id = "";
            if(this.contextType === "session") {
                if(!this.sessionId){
                    const params = new URLSearchParams(window.location.search);
                    const sessionId = params.get('id');
                    id  = sessionId;
                    payload.idContext = "sessionBoard";
                    // id = sessionId;
                    // data.origin = "sessionBoard";
                }else {
                    id = this.sessionId;
                }
                //console.log("context type is : ", this.listContext);

                // Default to "general" if no listContext is provided
                if (!this.listContext || Object.keys(this.listContext).length === 0) {
                    payload.defaultTypeOrigin = "session";
                    payload.collabType = "general";
                } else if(this.listContext?.type === "team"){
                    payload.defaultTypeOrigin = "sessionTeam"
                    payload.collabType = this.listContext.id;
                }else{
                    const isMongoId = /^[a-f\d]{24}$/i.test(this.listContext.id);
                    if(!isMongoId) {
                        payload.defaultTypeOrigin = "session"
                        payload.collabType = this.listContext.id;
                    }else{
                        payload.collabType = this.listContext.id;
                    }
                }

            } else if(this.contextType === "solution") {
                id = this.solutionId;

                // Handle solution board logic
                if (!this.listContext || Object.keys(this.listContext).length === 0) {
                    payload.defaultTypeOrigin = "solution";
                    payload.collabType = "general";
                } else if(this.listContext?.type === "piBoard"){
                    payload.defaultTypeOrigin = "solutionPiBoard";
                    payload.collabType = this.listContext.id;
                } else {
                    const isMongoId = /^[a-f\d]{24}$/i.test(this.listContext.id);
                    if(!isMongoId) {
                        payload.defaultTypeOrigin = "solution";
                        payload.collabType = this.listContext.id;
                    } else {
                        payload.collabType = this.listContext.id;
                    }
                }
            } else if(this.viewType) {
                id = this.releaseTrainId;

                // Handle workspace logic
                if (!this.listContext || Object.keys(this.listContext).length === 0) {
                    payload.defaultTypeOrigin = "workspace";
                    payload.collabType = "general";
                } else if(this.listContext?.type === "piBoard"){
                    payload.defaultTypeOrigin = "workspacePiBoard";
                    payload.collabType = this.listContext.id;
                } else if(this.listContext?.type === "solutionBoard"){
                    payload.defaultTypeOrigin = "workspaceSolutionBoard";
                    payload.collabType = this.listContext.id;
                } else {
                    const isMongoId = /^[a-f\d]{24}$/i.test(this.listContext.id);
                    if(!isMongoId) {
                        payload.defaultTypeOrigin = "workspace";
                        payload.collabType = this.listContext.id;
                    } else {
                        payload.collabType = this.listContext.id;
                    }
                }
            }

            // if (this.activeTab === "context") {
            //     payload.listContext = "context";
            // }else{
            //     payload.listContext = "associated";
            // }

            payload.context = { [flag]: id };

            // Use existing filters array which may include search and other filters
            if (this.filters && this.filters.length > 0) {
                payload.filter = this.filters;
            }

            // Add sorting parameters
            payload.sort = {
                field: this.sortBy.value,
                ascending: this.sortBy.ascending
            };

            // Create a new CancelToken
            const CancelToken = axios.CancelToken;
            const source = CancelToken.source();
            this.currentRequest = source;

            //console.log("payload is : ", payload, id);
            // return;

            axios.post(`/graphx/session-collaboration-boards/${id}`, payload, {
                cancelToken: source.token
            })
                .then(response => {
                    this.$emit('boards-loaded');
                    // Check if this is still the most recent request
                    if (requestTime < this.lastRequestTime) {
                        return;
                    }

                    if (response.data && response.data.success) {
                        const paginatedResult = response.data.paginatedResult;
                        // Safely access teamsMeta with fallback to empty array
                        this.teamsMeta = paginatedResult?.teamsMeta || [];
                        // Update boards - safely access items with fallback
                        this.boards = (paginatedResult?.items || []).filter(board => !board.archived && board.rowStatus !== -1);
                        // Update pagination info - backend now returns 0-based page
                        this.$set(this.pagination, 'totalItemSize', paginatedResult?.totalItems || 0);
                        this.$set(this.pagination, 'pageSize', paginatedResult?.pageSize || this.pagination.pageSize);
                        this.$set(this.pagination, 'currentPage', paginatedResult?.currentPage || 0);
                        this.handleSearch(this.searchQuery);
                    } else {
                        this.error = 'Failed to load collaboration boards';
                    }
                })
                .catch(error => {
                    if (axios.isCancel(error)) {
                        return;
                    }
                    console.error('Error loading collaboration boards:', error);
                    this.error = 'Failed to load collaboration boards. Please try again.';
                })
                .finally(() => {
                    if (requestTime === this.lastRequestTime) {
                        this.loading = false;
                        this.isPageChangeInProgress = false;
                        this.currentRequest = null;
                    }
                });
        },

        onSearchInput() {
            // Clear existing timeout
            if (this.searchDebounceTimeout) {
                clearTimeout(this.searchDebounceTimeout);
            }

            // Debounce search to avoid too many API calls
            this.searchDebounceTimeout = setTimeout(() => {
                // Update filters with search text
                this.updateFiltersWithSearch();
                this.resetPagination();
                this.loadBoards();
            }, 300);
        },

        updateFiltersWithSearch() {
            // Remove any existing search filters
            this.filters = this.filters.filter(filter => !filter.hasOwnProperty('search'));

            // Add new search filter if search text exists
            if (this.searchText && this.searchText.trim()) {
                this.filters.unshift({"search": this.searchText.trim()});
            }
        },

        handleSearch(query) {
            // Since backend is already filtering, just assign boards directly to filteredBoards
            this.filteredBoards = this.boards.slice();
            this.currentPageIndex = this.pagination.currentPage;
            // Don't update totalItemSize here as it should reflect the total from backend
        },

        onClickSort(sortKey) {
            // Toggle ascending/descending if clicking the same column
            if (sortKey === this.sortBy.value) {
                this.$set(this.sortBy, 'ascending', !this.sortBy.ascending);
            } else {
                // Set new sort field and default to ascending
                this.$set(this.sortBy, 'ascending', true);
                this.$set(this.sortBy, 'value', sortKey);
            }

            // Reload data with new sorting
            this.loadBoards();
        },

        resetPagination() {
            this.pagination.currentPage = 0;
            this.pagination.totalItemSize = 0;
        },

        onPaginatorChangePage(page) {
            // page is already 0-based from the pagination component
            // console.log("Pagination component page (0-based):", page);
            // if(this.currentPageIndex === page) {
                this.$set(this.pagination, 'currentPage', page);
                this.loadBoards();
            // }
        },

        onChangePageSizeofpopup() {
            const newSize = this.pagination.pageSize;
            this.resetPagination();
            this.loadBoards();
        },

        // Board action methods
        onBoardCreated(board, flag, id, subContext) {
            this.isBoardCreatedEmit = true;
            this.$set(this.pagination, 'currentPage', 0);
            this.paginationKey += 1;
            this.loadBoards();
        },

        onBoardDeleted(boardId) {
            const index = this.boards.findIndex(b => b.id === boardId);
            if (index !== -1) {
                this.boards.splice(index, 1);
                this.handleSearch(this.searchQuery);
            }
        },


        // Actions menu start

        toggleActionsMenu(boardId, event) {
            event.stopPropagation();
            this.activeDropdown = this.activeDropdown === boardId ? null : boardId;
        },

        onEditBoard(board) {
            this.activeDropdown = null;
            this.$emit('edit-board', board);
        },

        onCopyBoard(board) {
            this.activeDropdown = null;
            this.$emit('copy-board', board);
        },

        onDelete(board){
            // Check permissions before allowing delete
            if (!this.permissions.DELETE_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to delete collaboration boards', 'error');
                this.activeDropdown = null;
                return;
            }
            askFromSweetAlertWrapper(
                "Are you sure you want to delete this board?",
                [() => this.$emit('delete-board', board), null],
                [takeNoAction]
            );
            this.activeDropdown = null;
        },

        // Close dropdown when clicking outside
        handleClickOutside(event) {
            if (!event.target.closest('.actions-dropdown')) {
                this.activeDropdown = null;
            }
        },

        // Actions menu end

        // Move To Type functionality
        onMoveToType(board) {
            this.selectedBoard = board;
            this.populateMoveTeamOptions();
            this.selectedTypeId = null;
            this.showMoveToModal = true;
            this.activeDropdown = null;
            this.loadAvailableTypes();

        },

        populateMoveTeamOptions(){
            this.showTeamDropdown = true;
            const teamIds = Object.values(this.selectedBoard.piTeamArea || {})
                .flat();

            this.chosenTeams = teamIds
                .map(teamId => this.teamsMeta?.find(t => t.id === teamId))
                .filter(team => !!team) // only keep valid matches
                .map(team => ({
                    id: team.id,
                    title: team.title
                }));
        },

        loadAvailableTypes() {
            // Get context details
            let id = "";
            let data = {};

            if (this.contextType === "session") {
                if (!this.sessionId) {
                    const params = new URLSearchParams(window.location.search);
                    const sessionId = params.get('id');
                    id = sessionId;
                    data.origin = "sessionBoard";
                } else {
                    id = this.sessionId;
                }
            } else if (this.contextType === "solution") {
                id = this.solutionId;
            } else if (this.viewType) {
                id = this.releaseTrainId;
            }

            data.context = this.contextType;
            if (this.viewType) {
                data.context = "workspace";
            }

            axios.post(`/collaboration-type/context/${id}`, data)
                .then(response => {
                    if (response.data.success) {
                        this.availableTypes = [
                            { id: "general", title: "General" }
                        ];

                        // Add context-specific default types
                        if (this.contextType === "session") {
                            this.availableTypes.push({ id: "inspect", title: "Inspect and Adapt" });

                            // Add teams for session context - get teams from current session board
                            // if (this.$parent && this.$parent.currentSessionBoard && this.$parent.currentSessionBoard.teams) {
                                // this.$parent.currentSessionBoard.teams.forEach(team => {
                                //     this.availableTypes.push({
                                //         id: team.id,
                                //         title: team.title,
                                //         identifier: "team"
                                //     });
                                // });
                                this.fetchContextBoard(this.sessionId);
                            // }
                        }

                        // Add custom types (non-default origin types)
                        response.data.type.forEach(type => {
                            if (!type.defaultOrigin && type.rowStatus !== 1) {
                                this.availableTypes.push({
                                    id: type.id,
                                    title: type.title
                                });
                            }
                        });

                        // Add solution context specific types
                        // if (this.contextType === "solution") {
                        //     // Add PI Boards for solution context - get from active solution board
                        //     if (this.$parent && this.$parent.activeSolutionBoard && this.$parent.activeSolutionBoard.piBoards) {
                        //         this.$parent.activeSolutionBoard.piBoards.forEach(piBoard => {
                        //             const board = this.sessionBoards.find(board => board?.session?.id === piBoard.sessionId);
                        //             if(board?.session) {
                        //                 this.availableTypes.push({
                        //                     id: board.session.id,
                        //                     title: board.session.title,
                        //                     identifier: "solutionPiBoard"
                        //                 });
                        //             }
                        //         });
                        //     }
                        // }

                        // Add collection context specific types
                        // if (this.viewType) {
                        //     // Add Program Boards for collection context
                        //     if (this.$parent && this.$parent.collectionAssociatedProgramBoards) {
                        //         this.$parent.collectionAssociatedProgramBoards.forEach(programBoard => {
                        //             this.availableTypes.push({
                        //                 id: programBoard.id,
                        //                 title: programBoard.title,
                        //                 identifier: "workspacePiBoard"
                        //             });
                        //         });
                        //     }
                        //
                        //     // Add Solution Boards for collection context
                        //     if (this.$parent && this.$parent.collectionAssociatedSolBoards) {
                        //         this.$parent.collectionAssociatedSolBoards.forEach(solutionBoard => {
                        //             this.availableTypes.push({
                        //                 id: solutionBoard.id,
                        //                 title: solutionBoard.title,
                        //                 identifier: "workspaceSolutionBoard"
                        //             });
                        //         });
                        //     }
                        // }

                        // Set the current type as selected
                        // this.$nextTick(() => {
                        //     this.selectedTypeId = this.getCurrentTypeId(this.selectedBoard);
                        // });
                    }
                })
                .catch(error => {
                    console.error('Error loading collaboration types:', error);
                    showTopMessage('Failed to load collaboration types', 'error');
                });
        },

        fetchContextBoard(id) {
            axios.get(`/plan/getBoard/${id}`)
                .then(response => {
                    if (response.data.board) {
                        this.contextBoard = response.data.board;
                        this.availableTypes.push({
                            id: "selectTeams",
                            title: response.data.board?.session?.teamsLabel,
                            identifier: "team"
                        });

                        this.sessionTeams = response.data.board.teams.map(team => ({
                            id: team.id,
                            title: team.title,
                        }));
                    }
                })
                .catch(error => {
                    console.error('Error fetching board:', error);
                })
        },

        selectType(typeId) {
            this.moveToType  = typeId;
            this.selectedTypeId = typeId; // Store the full object
        },

        onTypeSelectionChange(selectedType) {
            if (selectedType) {
                this.moveToType = selectedType;
                this.selectedTypeId = selectedType; // Store the full object
                this.showTeamDropdown = true;
            } else {
                this.moveToType = null;
                this.selectedTypeId = null;
            }
        },

        closeMoveToModal() {
            this.showMoveToModal = false;
            this.selectedBoard = null;
            this.selectedTypeId = null;
            this.moveToType = null;
            this.availableTypes = [];
        },

        confirmMoveToType() {
            if (!this.selectedTypeId || !this.selectedBoard) {
                return;
            }

            this.isMovingType = true;
            this.showTeamDropdown = false;

            const data = {
                ...this.selectedBoard,
                sessionId: this.selectedBoard.session.map(session => session.id) || [],
                solutionId: this.selectedBoard.solutionBoard.map(solutionBoard => solutionBoard.id) || [],
                workSpaceId: this.selectedBoard.workSpaces.map(workSpace => workSpace.id) || [],
            };

            delete data.sessions;
            delete data.solutionBoards;
            delete data.workSpaces;

            const sessionId = this.contextBoard?.session?.id;

            if (data.piTeamArea && data.piTeamArea[sessionId]) {
                const chosenTeamIds = this.chosenTeams.map(t => t.id);
                data.piTeamArea[sessionId] = data.piTeamArea[sessionId].filter(
                    teamId => !chosenTeamIds.includes(teamId)
                );

                if (data.piTeamArea[sessionId].length === 0) {
                    delete data.piTeamArea[sessionId];
                }
            }

            // Get the selected type ID (handle both object and string cases)
            const selectedTypeId = typeof this.selectedTypeId === 'object' ? this.selectedTypeId.id : this.selectedTypeId;

            // Set type origin based on context and selected type
            if (this.contextType === "session") {
                if (selectedTypeId === "inspect") {
                    data.defaultOrigin = "sessionInspect";
                } else if (selectedTypeId === "general") {
                    data.defaultOrigin = "session";
                } else {
                    // Check if it's a custom type or team type
                    const selectedType = this.availableTypes.find(type => type.id === selectedTypeId);
                    if (selectedType && selectedType.identifier === "team") {
                        data.defaultOrigin = "sessionTeam";
                    }
                }
            } else if (this.contextType === "solution") {
                if (selectedTypeId === "general") {
                    data.defaultOrigin = "solution";
                } else {
                    // Check if it's a solutionPiBoard type or custom type
                    const selectedType = this.availableTypes.find(type => type.id === selectedTypeId);
                    if (selectedType && selectedType.identifier === "solutionPiBoard") {
                        data.defaultOrigin = "solutionPiBoard";
                    }
                }
            } else if (this.viewType) {
                if (selectedTypeId === "general") {
                    data.defaultOrigin = "workspace";
                } else {
                    // Check if it's a workspace specific type or custom type
                    const selectedType = this.availableTypes.find(type => type.id === selectedTypeId);
                    if (selectedType && selectedType.identifier === "workspacePiBoard") {
                        data.defaultOrigin = "workspacePiBoard";
                    } else if (selectedType && selectedType.identifier === "workspaceSolutionBoard") {
                        data.defaultOrigin = "workspaceSolutionBoard";
                    }
                }
            }

            // Set the type based on selectedTypeId
            data.type = selectedTypeId || 'general';


            axios.post("/graphx/board/update", data)
                .then(response => {
                    if (response.data && response.data.board) {
                        showTopMessage('Board type updated successfully', 'success');
                        this.closeMoveToModal();
                        
                        // Refresh the board list to show updated type
                        this.loadBoards();
                        
                        // Emit event to parent to refresh board counts
                        this.$emit('board-moved', response.data.board);
                    }
                })
                .catch(error => {
                    console.error('Error updating board type:', error);
                    showTopMessage('Failed to update board type', 'error');
                })
                .finally(() => {
                    this.isMovingType = false;
                });
        },

        getCurrentTypeName(board) {
            if (!board || !board.collaborationType) {
                return this.contextBoard?.session?.teamsLabel;
            }

            if(board.collaborationType?.defaultOrigin){
                return board.collaborationType.title.charAt(0).toUpperCase() + board.collaborationType.title.slice(1);
            }

            return board.collaborationType.title || 'General';
        },

        // getCurrentTypeId(board) {
        //     if (!board || !board.collaborationType) {
        //         return 'general';
        //     }
        //
        //     const collaborationType = board.collaborationType;
        //
        //     // Check for special default origin types
        //     if (collaborationType.defaultOrigin === 'sessionInspect') {
        //         return 'inspect';
        //     } else if (collaborationType.defaultOrigin === 'session' && collaborationType.title === 'General') {
        //         return 'general';
        //     } else if (collaborationType.defaultOrigin === 'solution' && collaborationType.title === 'General') {
        //         return 'general';
        //     } else if (collaborationType.defaultOrigin === 'workspace' && collaborationType.title === 'General') {
        //         return 'general';
        //     } else if (collaborationType.defaultOrigin === 'solutionPiBoard') {
        //         // For solution PI board types, return the session ID that this board is associated with
        //         if (collaborationType.sessions && collaborationType.sessions.length > 0) {
        //             // Find which session this board is associated with
        //             for (let session of collaborationType.sessions) {
        //                 if (board.session && board.session.some(boardSession => boardSession.id === session.id)) {
        //                     return session.id;
        //                 }
        //             }
        //             // Fallback to first session if direct match not found
        //             return collaborationType.sessions[0].id;
        //         }
        //     } else if (collaborationType.defaultOrigin === 'workspacePiBoard') {
        //         // For workspace PI board types, return the session ID
        //         if (collaborationType.sessions && collaborationType.sessions.length > 0) {
        //             return collaborationType.sessions[0].id;
        //         }
        //     } else if (collaborationType.defaultOrigin === 'workspaceSolutionBoard') {
        //         // For workspace solution board types, return the solution board ID
        //         if (collaborationType.solutionBoards && collaborationType.solutionBoards.length > 0) {
        //             return collaborationType.solutionBoards[0].id;
        //         }
        //     } else if (collaborationType.defaultOrigin === 'sessionTeam') {
        //         // For session team types, return the team ID
        //         if (collaborationType.teams) {
        //             const sessionId = Object.keys(collaborationType.teams)[0];
        //             const teamIds = collaborationType.teams[sessionId];
        //             if (teamIds && teamIds.length > 0) {
        //                 return teamIds[0];
        //             }
        //         }
        //     }
        //
        //     // For custom types (no defaultOrigin), return the actual ID
        //     return collaborationType.id;
        // },

        // Move To Type functionality end

        onClickBoard(board) {
            this.$emit('board-click', board);
        },

        onCreateNewBoard() {
            // Check permissions before allowing create
            if (!this.permissions.CREATE_COLLAB_BOARD) {
                showTopMessage('You don\'t have permission to create collaboration boards', 'error');
                return;
            }

            this.$emit('open-collaboration-board-create-popup');
        },

        getBoardGroup(board) {
            // Extract group information - adjust based on your data structure
            if (board.group) return board.group;
            if (board.collaborators && board.collaborators.length > 0) {
                const groupName = board.collaborators[0].groupName || board.collaborators[0].group;
                if (groupName) return groupName;
            }
            return null;
        },

        getCreatedBy(board) {
            const owner = this.getOwnerUser(board);
            if (owner) {
                return owner.fullName || owner.userName || 'Unknown';
            }
            return board.createdBy || 'Unknown';
        },

        getOwnerUser(board) {
            if (board.collaborators && board.collaborators.length > 0) {
                const admin = board.collaborators.find(c => c.admin && c.user);
                if (admin && admin.user) {
                    return admin.user;
                }
            }
            return board.owner || null;
        },

        getOwnerInitials(board) {
            const name = this.getCreatedBy(board);
            const nameParts = name.split(' ');
            if (nameParts.length >= 2) {
                return nameParts[0].charAt(0).toUpperCase() + nameParts[1].charAt(0).toUpperCase();
            }
            return name.charAt(0).toUpperCase() + (name.charAt(1) || '').toUpperCase();
        },

        getDisplayCollaborators(collaborators) {
            return collaborators ? collaborators.slice(0, 3) : []; // Show only 3 avatars
        },

        getCollaboratorName(collaborator) {
            if (collaborator.external && collaborator.externalUser) {
                return collaborator.externalUser.fullName || collaborator.externalUser.email || 'External User';
            } else if (collaborator.user) {
                return collaborator.user.fullName || collaborator.user.userName || 'User';
            }
            return 'Unknown';
        },

        getCollaboratorInitials(collaborator) {
            const name = this.getCollaboratorName(collaborator);
            const nameParts = name.split(' ');
            if (nameParts.length >= 2) {
                return nameParts[0].charAt(0).toUpperCase() + nameParts[1].charAt(0).toUpperCase();
            }
            return name.charAt(0).toUpperCase() + (name.charAt(1) || '').toUpperCase();
        },

        getUserPictureUrl(user) {
            if (user.picturePath) {
                return user.picturePath.startsWith('http') ? user.picturePath : `/assets/pictures/${user.picturePath}`;
            }
            return null;
        },

        formatDate(dateString) {
            if (!dateString) return '';
            const date = new Date(dateString);
            const options = {
                year: 'numeric',
                month: 'short',
                day: 'numeric'
            };
            return date.toLocaleDateString('en-US', options);
        },

        formatDateTime(dateString) {
            if (!dateString) return '';
            const date = new Date(dateString);
            const dateOptions = {
                year: 'numeric',
                month: 'short',
                day: 'numeric'
            };
            const timeOptions = {
                hour: '2-digit',
                minute: '2-digit',
                hour12: true
            };
            const dateStr = date.toLocaleDateString('en-US', dateOptions);
            const timeStr = date.toLocaleTimeString('en-US', timeOptions);
            return `${dateStr} at ${timeStr}`;
        },

        getFullDateTime(dateString) {
            if (!dateString) return '';
            const date = new Date(dateString);
            return date.toLocaleString('en-US', {
                year: 'numeric',
                month: 'long',
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit',
                second: '2-digit',
                hour12: true
            });
        },

        // Tab functionality
        // switchTab(tab) {
        //     this.activeTab = tab;
        //     this.$set(this.pagination, 'currentPage', 0);
        //     // Force pagination component to re-render
        //     this.paginationKey += 1;
        //     this.loadBoards();
        // },

        // Add new methods for getting associations
        getTeamAssociations(board) {
            if (!board.piTeamArea || typeof board.piTeamArea !== "object") return [];
            return Object.values(board.piTeamArea) // get all lists of teamIds
                .flat() // flatten into a single array of teamIds
                .map(teamId => {
                    const team = this.teamsMeta?.find(t => t.id === teamId);
                    return {
                        id: teamId,
                        title: team?.title || teamId
                    };
                });
        },

        getInspectAndAdaptAssociations(board) {
            if (!board.piInspectAndAdapt || !Array.isArray(board.piInspectAndAdapt) || (Array.isArray(board.piInspectAndAdapt) && board.piInspectAndAdapt.length === 0)) return [];
            return board?.session?.map(inspectId => {
                // const matchedSession = this.sessionBoards.find(sb => sb.session?.id === inspectId);
                return {
                    id: inspectId?.activeSessionBoard,
                    title: inspectId ? `I&A: ${inspectId?.title || inspectId}` : `I&A: ${inspectId}`,
                    sessionId: inspectId.id
                };
            });
        },

        getProgramBoardAssociations(board) {
            // Only return program boards if there are no inspect and adapt items
            if (board.piInspectAndAdapt && Array.isArray(board.piInspectAndAdapt) && board.piInspectAndAdapt.length > 0) {
                return [];
            }

            if (!board.session || !Array.isArray(board.session)) return [];

            return board.session.map(session => {
                // const matchedSession = this.sessionBoards.find(sb => sb.session?.id === session.id);
                return {
                    id: session?.activeSessionBoard,
                    sessionId: session.id,
                    title: session?.title || session.id
                };
            });
        },

        getSolutionBoardAssociations(board) {
            if (!board.solutionBoard || !Array.isArray(board.solutionBoard)) return [];

            return board.solutionBoard.map(solution => {
                // const matched = this.solutionBoards.find(sb => sb.id === solution.id);
                return {
                    id: solution.id,
                    title: solution?.title || solution.id
                };
            });
        },

        getCollectionAssociations(board) {
            if (!board.workSpaces) return [];
            return board.workSpaces.map(workspace => ({
                id: workspace.key,
                title: workspace.title
            }));
        },

        hasAnyAssociations(board) {
            return this.getTeamAssociations(board).length > 0 ||
                   this.getInspectAndAdaptAssociations(board)?.length > 0 ||
                   this.getProgramBoardAssociations(board).length > 0 ||
                   this.getSolutionBoardAssociations(board).length > 0 ||
                   this.getCollectionAssociations(board).length > 0;
        },

        onAssociationClick(type, item) {
            if(type === 'collection' && item?.id) {
                window.location = `/org#/ART/${item.id}/backlog`;
                // window.location.reload();
            }
            else if(type === 'team') {
                // Redirect to team view
                // window.location.href = `/team?id=${item.id}`;
            } else if(type === 'solution') {
                // Redirect to solution board
                window.location = `/solutions#/${item.id}`;
                this.$nextTick(() => {
                    setTimeout(() => window.location.reload(), 500);
                })
            } else if(type === 'inspect') {
                // Redirect to inspect & adapt view with session ID
                window.location.href = `/session?id=${item.id}&moreOptionsIndex=6&moreOptionsSubIndex=-1&tab=collab`;
            } else if(type === 'session') {
                // Redirect to program board/session view
                window.location.href = `/session?id=${item.id}`;
            }
            // this.$emit('association-click', { type, item });
        }
    }
});

