const customUserRenderer = (user)  => {
	const userElement = document.createElement( 'div' );

	const userNameElement = document.createElement( 'span' );

	userNameElement.setAttribute('id', user.userName);

	userElement.classList.add( 'mention_avatar' );
	var avatar = getUserIcon(user);
	userElement.innerHTML += avatar
	userNameElement.classList.add( 'mention__item__user-name' );
	userNameElement.textContent = user.fullName;
	userElement.appendChild( userNameElement );
	return userElement;
}


const customObjectiveRenderer = (objective) => {
	const objectiveElement = document.createElement( 'div' );

	const objectiveKeyElement = document.createElement( 'a' );
	objectiveKeyElement.textContent = " [" + objective.key + "] ";

	let objectiveTitleElement = document.createElement( 'span' );
	objectiveTitleElement.textContent = objective.title;
	if(objective.parentId) {
		objectiveTitleElement.setAttribute("title", objective.parentId);
	}


	objectiveElement.appendChild( objectiveKeyElement );
	objectiveElement.appendChild( objectiveTitleElement);

	return objectiveElement;
}

function mentionCustomizer(editor) {

	editor.conversion.for( 'downcast' ).attributeToElement( {
		model: 'mention',
		view: ( modelAttributeValue, { writer } ) => {

			let userMentionFeeds = CHECK_IN_EDITOR_CONFIG.mention.feeds[0].feed;
			let objectiveMentionFeeds = CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed;

			if ( !modelAttributeValue ) {
				return;
			}

			let dataMentionId;
			if ( modelAttributeValue.id[ 0 ] === '@' ) {
				if(!_.isEmpty(userMentionFeeds)) {
					let user = _.find(userMentionFeeds, {id: modelAttributeValue.id});
					if(user) {
						dataMentionId = user.email;

						return writer.createAttributeElement( 'span', {
							class: 'mention mention-user',
							'data-mention': modelAttributeValue.id,
							'data-email-mention-id': dataMentionId,
						}, {
							priority: 20,
							id: modelAttributeValue.uid
						} );
					} else {
						return writer.createAttributeElement( 'span', {
							class: 'mention mention-user',
							'data-mention': modelAttributeValue.id,
							'data-email-mention-id': modelAttributeValue.id,
						}, {
							priority: 20,
							id: modelAttributeValue.uid
						} );
				}
				}
			} else if(modelAttributeValue.id[0] === '#') {
				let objective = _.find(objectiveMentionFeeds, {id: modelAttributeValue.id});
				if(objective) {
					dataMentionId = objective.objectiveId;

					let parentObjective = _.find(objectiveMentionFeeds, {objectiveId: objective.parentId});

					return writer.createAttributeElement( 'span', {
						class: 'mention mention-obj',
						title: parentObjective? parentObjective.title + " -> " + objective.title: objective.title,
						'data-mention': modelAttributeValue.id,
						'data-objective-mention-id': dataMentionId,
						'data-title-mention-id': parentObjective? parentObjective.title + " -> " + objective.title: objective.title,
					}, {
						priority: 20,
						id: modelAttributeValue.uid
					} );
				}  else {
					let text = modelAttributeValue.id;
					let id = text.substring(0, text.indexOf(' '));
					return writer.createAttributeElement( 'span', {
						class: 'mention mention-obj',
						title: text.substring(text.indexOf(' ') + 1),
						'data-mention': modelAttributeValue.id,
						'data-objective-mention-id': id,
						'data-title-mention-id': id,
					}, {
						priority: 20,
						id: modelAttributeValue.uid
					} );					
				}


				editor.model.document.on('change:data', () => {
					let editorData = editor.getData();
					editor.setData(editorData);

				});
			}


		},
		converterPriority: 'high'
	} );

}

var CHECK_IN_EDITOR_CONFIG 	 = {
	fontBackgroundColor: {
		documentColors: 2 // Disable document colors section.
	},
	toolbar: ["bold", "italic", "BGColor", '|', "link", "bulletedList", "numberedList", "fontBackgroundColor", 'undo', 'redo'],
	link: {
		addTargetToExternalLinks: true,
	},
	extraPlugins: [mentionCustomizer],
	startupFocus: true,
	mention 	: {
		dropdownLimit: 4,
		feeds 	: [
			{	marker		   : '@',
				feed		   : [],
				itemRenderer   : customUserRenderer,
			},
			{	marker		   : '#',
				feed		   : [],
				itemRenderer   : customObjectiveRenderer,
			}
		],
	}
}


const CHECKIN_URL_WRAPPER = Vue.component('checkin-url-wrapper', {
	template: `
		<div class="chkInWrap">
			<check-in-popup v-if="checkInPopup.show"
				:is-mocking-mode="isMockingMode"			
				:fetched-objectives="meta.objectivesList"
			   	:context="meta.context" 
			    :is-update="checkInPopup.isUpdate"
				:check-in="checkInPopup.checkIn" 
				:users-by-username="meta.usersByUsername"
				:users="meta.users"
				@save="onClickSaveCheckIn"
				@close="$emit('close')"
			/>
		</div>
	`,
	props: ['checkInId', 'isMockingMode'],
	data() {
		return {
			checkInPopup: {
				show: false,
				checkIn: {},
				isUpdate: false,
			},
			meta: {
				usersByUsername: {},
				objectivesList: [],
				context: {},
				users: [],
				objectivesLoaded: false,
				usersLoaded: false,
				contextLoaded: false,
			},
			usersPagination: {
				pageIndex: 0,
				pageSize: 20,
			}

		}
	},
	created() {
		CHECK_IN_EDITOR_CONFIG.mention.feeds[0].feed = [];
		CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed = [];
		this.fetchCheckInInformation();
		this.requestLoadUsers();
	},
	mounted() {

	},
	computed: {
		metaLoaded() {
			return this.meta.objectivesLoaded && this.meta.usersLoaded && this.meta.contextLoaded;
		}
	},
	watch: {
		"meta.context" : {
			handler(newValue, oldValue) {
				this.populateMentionObjectives();
			}
		},
		"metaLoaded": {
			handler(newValue, oldValue) {
				if(newValue) {
					this.checkInPopup.show = true;
					this.checkInPopup.isUpdate = true;
				}
			}
		}
	},
	methods: {
		fetchCheckInInformation() {
			let _this = this;
			axios.get("external-entitites/check-in/"+this.checkInId).then(response => {
				console.log(response.data);
				if(response.data) {
					let checkIn = response.data.checkIn;
					if(window.location.pathname == "/objectives") {
						_this.meta.context = {id: "-1"};
						_this.meta.contextLoaded = true;						
					} else { 
						let contextId = Object.keys(checkIn.relationMap)[0];
	
						_this.meta.context = {id: contextId};
						_this.meta.contextLoaded = true;
					}
					_this.checkInPopup.checkIn = checkIn;

					kendisStore.commit('setCheckInTemplate', {scheme: response.data.scheme});

					let userByUsername = response.data.usersByUsername;

					if(userByUsername) {
						Object.keys(userByUsername).forEach(key => {
							if(!_this.meta.usersByUsername[key]) {   // If user is not in list add him.
								_this.meta.usersByUsername[key] = userByUsername[key];
							}
						});
					}

				}
			}).catch(error => {
				console.log(error);
			});
		},
		requestLoadUsers(clear) {
			if(clear) {
				this.usersPagination.pageIndex = 0;
			}

			this.loadMentionUsers();
		},
		loadMentionUsers: function() {
			// Fetching Users for Mentions
			axios.get('/pijourney/getUsers/'+ this.usersPagination.pageIndex +"/"+ this.usersPagination.pageSize)
				.then(response => {
					if (!_.isEmpty(response.data) ) {
						let users = response.data.users;
						for(let  i = 0; i < users.length; i++) {

							let isUserPresent = _.find(this.meta.users, {id: users[i].id});
							if(!isUserPresent) {
								this.meta.users.push(users[i]);
							}

							CHECK_IN_EDITOR_CONFIG.mention.feeds[0].feed.push(
								{
									id: ('@' + users[i].fullName),
									userName: users[i].userName,
									fullName: users[i].fullName,
									backgroundColor: users[i].backgroundColor
								});
						}

						if(users.length == this.usersPagination.pageSize) {
							this.usersPagination.pageIndex++;
							this.requestLoadUsers();
						}

						this.meta.usersLoaded = true;
					}
				}).catch(error => {
				console.log(error);
			});
		},
		populateMentionObjectives: function() {
			let request = {};
			if(this.meta.context && this.meta.context.id) {
				request.contextId = this.meta.context.id;
			}
			axios.post("/objective/get-objectives-and-kr", request).then(response => {
				let objectives = response.data.objectives;
				this.meta.objectivesList = objectives;

				CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed = [];
				for(let  i = 0; i < objectives.length; i++) {
					let currentObjective = objectives[i];
					CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed.push(
						{
							id: ('#[' + currentObjective.key + "] " + currentObjective.title ),
							key: currentObjective.key,
							title: currentObjective.title,
						}
					);
				}

				this.meta.objectivesLoaded = true;
			}).catch(error => {
				console.log(error);
			});
		},
		onClickSaveCheckIn(responseData, close) {
			if(close) {
				this.checkInPopup.show = false;
				this.$router.go(-1);
			}

		}
	}

});


const CHECKIN_INLINE = Vue.component('checkin-inline', {
	template: `
			<div class="w-full p-rel">
				<template v-if="socketData.isEditing">
					<div class="DFA JC typing">
						<div class="mb-20">
							<div class="loaderTyping"></div>
						</div>
						<div class="txt-cntr">
							<p class="typeMsg">{{getUserByUsername(socketData.userName)}} is typing the Check-In Details.</p>
						</div>
					</div>						
				</template>
				<template v-else>
					<div class="mb-10">
						<input v-model="editCheckIn.title"  placeholder="Enter Your Title" ref="titleRef" 
							   :class="['titleInput', validationErrors.title ? 'required' : '']"
							   maxlength="255" tabindex="2" type="text" class="form-control activeText" />
					</div>
						
					<div v-if="validationErrors.title">
						<span class="mstxt red-msg">Title is required</span>
					</div>													
					<div>
						<ckeditor v-if="checkIn.id" :config="$options.ckEditorConfig" v-model="editCheckIn.description" :editor="$options.ckEditorType" @focus="editStart = true"></ckeditor>
					</div>
						
						
					<span @click="onClickSaveButton(true)" class="p-abs expandChkIn">
						<img src="./assets/icons/expandChkIn.svg" class="ml-5 mt-10 c-point" />
					</span>
				</template>
				<div class="DF AlignBase JE" style="gap: 10px;">
					<button @click="onClickCancelButton" class="cncl h-auto disabled">Cancel</button>
					<button @click="onClickSaveButton(undefined)" class="savBtn h-auto" >{{checkIn.id?  'Save' : 'Create'}}</button>	
				</div>							
			</div>
	`,
	watch: {
		editStart : {
			handler(newValue, oldValue) {
				if(this.socketData.stompClient.connected && !this.socketData.isEditing) {
					/* checkin push commented temporarily 
					this.socketData.stompClient.send("/websocket/checkin.editing",
						{token: loggedInUser.userName},
						JSON.stringify({userName: loggedInUser.email, checkInId: this.checkIn.id,  messageType: 'EDITING'})
					);
					*/					
				}
			},
			deep: true
		}
	},
	props: {
		isUpdate: {
			type: Boolean,
			default() {
				return false;
			}
		},
		checkIn: {
			type: Object,
			default() {
				return {};
			}
		},
		context: {
			type: Object,
			default() {
				return {};
			},
		},
	},
	mixins: [commonMixin, CHECK_IN_MIXIN],
	components: {
		'ckeditor': CKEditor.component,
	},
	created() {
		//................
		this.$options.ckEditorConfig = CHECK_IN_EDITOR_CONFIG;
		this.$options.ckEditorType = ClassicEditor;

		if(this.isUpdate) {
			this.editCheckIn = _.cloneDeep(this.checkIn);
			this.openSocket();			
		}
	},
	mounted() {
		 this.$refs.titleRef.focus();
	},
	data() {
		return {
			editCheckIn: {
				title: this.getCheckInTitle(),
				description: "",
			},
			validationErrors: {
				title: false,
			},
			saveAllowed: true,
			editStart: false
		}
	},
	methods: {
		/////////////////////////////////////////////
		//         EVENTS
		onClickSaveButton(calledFromExpand) {
			//// Run Validation Checks
			if(this.validateSave()) {
				if(this.saveAllowed) {
					this.saveAllowed = false;
					this.saveCheckIn(calledFromExpand);
					this.saveAllowed = true;
				}
			}
		},
		onClickCancelButton() {
			if(this.editCheckIn.id) {
				this.onClickCancel();
				this.selectedField = "";
				this.onUserDisconnect();
			}
			this.$emit('cancel');
		},
		onClickExpandView() {
			this.$emit('expand', this.editCheckIn);
		},
		////////////////////////////////////////////
		///        HELPERS
		validateSave() {
			let _this = this;

			let validationErrors = {};
			let isValid = true;
			if (!_.isEmpty(this.editCheckIn.title)) {
				_this.editCheckIn.title = _this.editCheckIn.title.trim();
			}
			validationErrors.title = _.isEmpty(_this.editCheckIn.title);

			if (validationErrors.title) {
				isValid = false;
			}


			Vue.set(this,"validationErrors",validationErrors);
			return isValid;
		},
		saveCheckIn(calledFromExpand) {
			let checkIn = _.cloneDeep(this.editCheckIn);

			let request = {};
			request.checkIn = checkIn;
			if(this.context && this.context.id) {
				request.contextId = this.context.id;
			}

			let users = getMentionUsers(checkIn.description);
			let objectives = getMentionObjectives(checkIn.description);
			request.mentionedUsers = users;
			request.checkInBaseUrl = window.location.href;
			request.mentionedObjectives = objectives;


			this.requestSaveCheckIn(request, calledFromExpand);
		},
				
		////////////////////////////////////////////
		///        API CALLS
		requestSaveCheckIn(request, calledFromExpand) {
			let _this = this;
			let isUpdate = _this.editCheckIn.id != undefined;
			axios.post('external-entitites/check-in/save', request)
				.then(response=>{
					if(response && response.data) {
						let responseData = response.data;
						_this.editCheckIn.title = this.getCheckInTitle();
						_this.editCheckIn.description = "";
						if(calledFromExpand) {
							_this.$emit('save-and-expand', responseData);							
						} else {
							_this.$emit('save', responseData);
						}
						if(isUpdate && response.data.checkIn){
							_this.sendPushOnSave(response.data.checkIn);
						}
					}
			}).catch(error=>{
				console.error(error);
			});
		},
	}

});



const CHECK_IN = Vue.component('check-in', {
	template: `
    <div>
      <template v-if="inlineEdit">
        <div class="mb-30 p-rel">
          <checkin-inline 
            :is-update="checkIn.isEditable" 
            :check-in="checkIn" 
            @cancel="onClickCancelEdit" 
            @expand="onClickExpandView" 
            @save="onClickSave"
            @save-and-expand="onSaveAndExpandInCheckInCard">
          </checkin-inline>
          <div class="chkInNmbr tooltip">
            <span class="chkInCount">{{dateFormat(checkIn.createdOn, 'd mmm')}}</span>
			<div class="hovtooltipB ffall">
	            <div><b>Date:</b> {{dateFormat(checkIn.createdOn, 'default')}}</div>
	            <div class="DFA" v-if="checkIn.createdBy && usersByUsername[checkIn.createdBy]">
				  <b>Created By:</b> 
	              <div v-html="getUserImage(usersByUsername[checkIn.createdBy])" class="pic mr-5 ml-5"></div>
	              <span class="chkInUsrNam">{{usersByUsername[checkIn.createdBy].fullName}}</span>
	            </div>
			</div>
          </div>
        </div>
      </template>
      <template v-else>
        <div class="p-rel">
          <div class="chkInNmbr tooltip">
            <span class="chkInCount">{{dateFormat(checkIn.createdOn, 'd mmm')}}</span>
			<div class="hovtooltipB ffall">
	            <div><b>Date:</b> {{dateFormat(checkIn.createdOn, 'default')}}</div>
	            <div class="DFA" v-if="checkIn.createdBy && usersByUsername[checkIn.createdBy]">
				  <b>Created By:</b> 
	              <div v-html="getUserImage(usersByUsername[checkIn.createdBy])" class="pic mr-5 ml-5"></div>
	              <span class="chkInUsrNam">{{usersByUsername[checkIn.createdBy].fullName}}</span>
	            </div>
			</div>
          </div>
          <div class="chkInUsrCard w-full tooltip" @dblclick="onClickInlineEditCheckIn">
			<em class="menu-vert DAJ FR c-point" @click="showEditOptionsPopup = true;"></em>
			<vuepopup v-if="showEditOptionsPopup" @close="showEditOptionsPopup = false;">
				<div class="drop_box nwmu artp sml" style="display:block">
					<ul>
						<li @click="onClickInlineEditCheckIn" class="c-point"><em class="ti-pencil mr-10"></em>Edit</li>
						<li @click="onClickEditCheckIn" class="c-point"><em class="ti-eye mr-10"></em>View</li>
						<li @click="onClickDeleteCheckIn" class="c-point"><em class="ti-trash mr-10"></em>Delete</li>					
					</ul>
				</div>
			</vuepopup>
            <div v-if="!_.isEmpty(checkIn.title)" class="chkInUsrBadg elips">{{checkIn.title}}</div>
            <div v-if="checkIn.description !== ''" class="editable ck-content scrollBar">
              <div v-html="visibleDescription"></div>
              <div v-if="hasMoreWords" @click="showMore" class="show-more-btn">Show more</div>
            </div>
            <!--<div class="hovtooltipB"> Double click for edit</div>-->
          </div>
        </div>
        <div class="DAB">
          <div class="lft DFA">
            <div class="tooltip emout DFA">
              <span class="ico emoji DIB c-point"></span>
              <span class="count">{{emojiCount}}</span>
              <div class="pop hovtooltip">
                <span v-for="emoji in emojis" :class="emoji.classes" @click="onClickReaction(emoji.symbol)">{{emoji.symbol}}</span>
              </div>         
            </div>
            <div @click="openCommentSection" class="DFA emout cmnt c-point">
              <span class="ico cmnt-ico DIB"></span>
              <span class="count">{{conversationCount}}</span>
            </div>
          </div>
          <!--<div class="rht chkInDate">{{dateFormat(checkIn.createdOn, 'default')}}</div>-->
        </div>
      </template>
    </div>
  `,
	mixins: [commonMixin],
	props: {
		inlineEdit: {
			type: Boolean,
			default() {
				return false;
			}
		},
		checkIn: {
			type: Object,
			default() {
				return {};
			}
		},
		usersByUsername: {
			type: Object,
			default() {
				return {};
			}
		},
		users: {
			type: Array,
			default() {
				return [];
			}
		}
	},
	data() {
		return {
			conversationCount: 0,
			emojiCount: 0,
			emojis: [
				{symbol: "🎯", classes: "posEmojiIcon"},
				{symbol: "🍾", classes: "posEmojiIcon"},
				{symbol: "💯", classes: "posEmojiIcon"},
				{symbol: "👍", classes: "posEmojiIcon"},
				{symbol: "🥳", classes: "posEmojiIcon"},
				{symbol: "👎", classes: "negEmojiIcon"},
				{symbol: "🤔", classes: "negEmojiIcon"},
				{symbol: "😞", classes: "negEmojiIcon"},
			],
			wordsVisible: 70,
			descriptionWords: [],
			showEditOptionsPopup: false
		};
	},
	computed: {
		visibleDescription() {
			return this.truncateHtml(this.checkIn.description, this.wordsVisible);
		},
		hasMoreWords() {
			return this.descriptionWords.length > this.wordsVisible;
		}
	},
	watch: {
		'checkIn.description': {
			immediate: true,
			handler(newDescription) {
				if (newDescription) {
					this.descriptionWords = this.splitIntoWords(newDescription);
				}
			}
		}
	},
	created() {
		this.fetchConversationCount();
		this.fetchEmojiCount();
	},
	methods: {
		showMore() {
			this.wordsVisible += 70;
		},
		splitIntoWords(description) {
			const tempDiv = document.createElement('div');
			tempDiv.innerHTML = description;
			const textContent = tempDiv.innerText || tempDiv.textContent || '';
			return textContent.split(/\s+/).filter(word => word.length > 0);
		},
		truncateHtml(html, maxWords) {
			let wordCount = 0;
			const tempDiv = document.createElement('div');
			tempDiv.innerHTML = html;

			const truncateNode = (node) => {
				if (node.nodeType === Node.TEXT_NODE) {
					const words = node.textContent.split(/\s+/).filter(word => word.length > 0);
					if (wordCount + words.length > maxWords) {
						const truncatedWords = words.slice(0, maxWords - wordCount);
						node.textContent = truncatedWords.join(' ') + (words.length > truncatedWords.length ? '...' : '');
					} else {
						node.textContent = words.join(' ');
					}
					wordCount += words.length;
				} else if (node.nodeType === Node.ELEMENT_NODE) {
					for (let i = 0; i < node.childNodes.length; i++) {
						if (wordCount >= maxWords) {
							node.removeChild(node.childNodes[i--]);
						} else {
							truncateNode(node.childNodes[i]);
						}
					}
				}
			};

			truncateNode(tempDiv);
			return tempDiv.innerHTML;
		},

		onClickInlineEditCheckIn() {
			this.$emit('inline-edit', this.checkIn);
		},
		onClickEditCheckIn() {
			this.$emit('edit', this.checkIn);
		},
		onClickCancelEdit() {
			this.$emit('cancel', this.checkIn);
		},
		onClickExpandView(checkIn) {
			this.$emit('expand', checkIn);
		},
		onClickSave(checkIn) {
			this.$emit('save', checkIn);
		},
		onClickDeleteCheckIn() {
			this.$emit('delete', this.checkIn);
		},
		openCommentSection() {
			this.$emit("open-comment", this.checkIn);
		},
		fetchConversationCount() {
			let _this = this;
			let requestBody = {};
			requestBody.entityId = _this.checkIn.id;
			requestBody.entityType = "BaseItem";
			axios.post('external-entitites/conversation/fetch/count', requestBody)
				.then(response => {
					if (response.data && response.data.count) {
						_this.conversationCount = response.data.count;
					}
				})
				.catch(error => {
					console.error(error);
				});
		},
		fetchEmojiCount() {
			let _this = this;
			let requestBody = {};
			requestBody.entityId = _this.checkIn.id;
			requestBody.entityType = "BaseItem";
			requestBody.conversationType = "Emoji"
			axios.post('external-entitites/conversation/fetch/count', requestBody)
				.then(response => {
					if (response.data && response.data.count) {
						_this.emojiCount = response.data.count;
					}
				})
				.catch(error => {
					console.error(error);
				});
		},
		onClickReaction(emoji) {
			this.$emit("emoji-select", emoji, this.checkIn);
		},
		onSaveAndExpandInCheckInCard(response) {
			this.$emit('expand', response);
		}
	}
});


const CHECK_IN_LISTING = Vue.component('check-in-listing', {
	template:`
		<div>
			<check-in-popup v-if="checkInPopup.show"
				:fetched-objectives="objectivesList"
			    :context="context" 
			    :is-update="checkInPopup.isUpdate"
				:check-in="checkInPopup.checkIn" 
				:users-by-username="usersByUsername"
				:users="usersPagination.users"
				:open-comment-section="openCommentSection"
				:selected-field-for-edit="selectedField"
				:is-mocking-mode="isMockingMode"
				@update-description="onUpdateCheckInDescription"
				@close="onClickCloseCheckInPopup" 
				@save="onSaveCheckIn" 
				@emoji-save="onUpdateEmojiCount"
				@conversation-added="onNewConversationAdded"
				@conversation-loaded="onLoadConversation"
				@conversation-deleted="onDeleteConversation"				
			/>
			<div class="DFCB chkHd">
				<div class="DFA">
					<span class="ml-5 c-point closeChkIn" @click="toggleCheckIns"><img src="./assets/icons/CloseChkIn.svg" alt="." /></span>
					
					<div class="chkInTitle ml-10 p-rel">
						<span>Check-Ins</span>
						<div @click="refreshCheckIn" class="refshico c-point" :class="isRefreshing ? 'active' : ''"></div>
						<img v-if="showCheckMarkAfterRefresh" src="./assets/icons/check1.svg" class="checkIcon p-abs" alt="." />
					</div>
				</div>
				<div class="chkHdActions DFA">
					<div class="srch srchnww mr-10"><input type="text" placeholder="Search..." class="srch h-34 rnd4" v-model="searchQuery" @input="handleInput"  maxlength="255"/></div>
					<div class="">
						<button v-if="enableNewButton" @click="showCreateNewMenu=true;" class="crtboard button"><em class="ti-plus ico"></em> New <em class="arrbtn icc"></em></button>
						<vuepopup v-if="showCreateNewMenu" @close="showCreateNewMenu = false;">
							<div class="drop_box nwmu artp sml" style="display:block">
								<ul @click="showCreateNewMenu = false;">
									<li @click="inlineCreateCheckIn.show = true" class="c-point">Inline</li>
									<li @click="onClickOpenCheckInPopup" class="c-point">Full View</li>								
								</ul>
							</div>
						</vuepopup>
					</div>					
				</div>
			</div>
			<div class="chkInSection scrollBar">				
				<div v-if="inlineCreateCheckIn.show" :class="inlineCreateCheckIn.show? 'chkInedtr': 'adNewChkIn'">
					<checkin-inline 						
					    :context="context"
						@cancel="inlineCreateCheckIn.show = false;" 
						@expand="(checkIn) => onClickOpenCheckInPopup(undefined, checkIn)"
						@save="onSaveCheckIn"
						@save-and-expand="onSaveAndExpand"></checkin-inline>
				</div>
				<div>
					<div v-if="isLoading" class="DF" v-for="index in 5" :key="index">
						<div class="skeleton number"></div>
						<div class="skeleton checkin-item"></div>
					</div>
				</div>
				<div  class="pb-20">
					<template v-for="grp in dayGroups">
						<template v-if="checkInsGroupByCreation[grp] && !_.isEmpty(checkInsGroupByCreation[grp])">
							<span class="line">
								<h2><span>{{addSpaceBeforeCapitalLetters(grp)}}</span></h2>
							</span>
							<ul class="ChkInsDetailsWraper">
								<li v-for="checkIn in checkInsGroupByCreation[grp]">																	
									<check-in 
										:key="checkIn.id"
										:ref="'checkIn_'+ checkIn.id"
										:check-in="checkIn" 
										:users-by-username="usersByUsername"
										:inline-edit="checkIn.isEditable"
										:users="usersPagination.users"
									    @cancel="(checkIn) => onClickCancelEdit(undefined, checkIn, grp, false)" 
									    @edit="(checkIn) => onClickOpenCheckInPopup(undefined, checkIn)"
									    @expand="onSaveAndExpand($event)"
									    @inline-edit="onClickInlineEdit(checkIn, grp, false)" 
										@save="onSaveCheckIn($event, undefined, grp, false)"
										@delete="onclickDeleteCheckIn"
										@open-comment="(checkIn) => onClickOpenComment(checkIn)"
										@emoji-select="(emoji, checkIn) => onSaveReaction(emoji, checkIn)"
									></check-in>
								</li>
							</ul>
						</template>
					</template>
					<template v-for="grp in olderDatesGroups">
						<template v-if="checkInsGroupByCreation.Older && !_.isEmpty(checkInsGroupByCreation.Older[grp])">
							<span class="line">
								<h2><span>{{formatDate(grp)}}</span></h2>
							</span>							
							<ul class="ChkInsDetailsWraper">
								<li v-for="checkIn in checkInsGroupByCreation.Older[grp]">
									<check-in 
										:key="checkIn.id"
										:ref="'checkIn_'+ checkIn.id"
										:check-in="checkIn" 
										:users-by-username="usersByUsername"
										:inline-edit="checkIn.isEditable"
										:users="usersPagination.users"
									    @cancel="(checkIn) => onClickCancelEdit(undefined, checkIn, grp, true)" 
									    @edit="(checkIn) => onClickOpenCheckInPopup(undefined, checkIn) "
									    @expand="onSaveAndExpand($event)"
									    @inline-edit="onClickInlineEdit(checkIn, grp, true)" 
										@save="onSaveCheckIn"
										@delete="onclickDeleteCheckIn"
										@open-comment="(checkIn) => onClickOpenComment(checkIn)"
										@emoji-select="(emoji, checkIn) => onSaveReaction(emoji, checkIn)"										
									></check-in>
								</li>
							</ul>
						</template>
					</template>					
					<ul v-if="_.isEmpty(checkInsList) && !inlineCreateCheckIn.show && !isRefreshing" class="ChkInsDetailsWraper t-center">
						<template v-if="!_.isEmpty(searchQuery)">
							<li class="nofound">No Check-In(s) found against the search string "{{searchQuery}}"</li>						
						</template>					
						<template v-else>
							<li class="nofound">There are no Check-Ins here yet, click to create new</li>
							<button @click="inlineCreateCheckIn.show=true;" class="crtboard button h-auto DIB rnd6 mb-10">New Check-in</button>
							<!-- <div><a href="#" class="und" target="_blank">Learn More</a></div> -->
						</template>
					</ul>
					<a v-if="!_.isEmpty(checkInsList)" class="DFA JC c-point lodmor" @click="onClickLoadMore">
						<span class="refshico-green DB mr-5"></span>
						<template v-if="checkInsList.length == 0">
							(0 of {{totalCountAgainstQuery}})
						</template>
						<template v-else>
							(1 - {{checkInsList.length}} of {{totalCountAgainstQuery}}) 
						</template>
						Load More
					</a>
				</div>
			</div>
		</div>
	`,
	props: {
		objectiveGroupList: {
			type: Array,
			default() {
				return [];
			}
		},
		context: {
			type: Object,
			default() {
				return {};
			}
		},
        isMockingMode: {
            type: Boolean,
            default: () => { return false }
        },
	},
	data: function() {
		return this.initialData();
	},
	components: {
        'ckeditor': CKEditor.component,
	},
	created: function() {
		this.onCreatedCalled();
	},
	mounted: function() {},
	watch: {
		/*"objectiveGroupList": {
			handler(newValue, oldValue) {
				this.populateMentionObjectives();
			}
		},
		"searchQuery" :  {
			handler(newValue, oldValue) {
				this.checkInsList = [];
				this.pagination.pageIndex = 0;


				this.fetchCheckIns();
			}
		},*/
	},
	methods: {
		////////////////////////////////////////////
		///     EVENTS
		onClickOpenCheckInPopup: function(event, checkIn) {
			if(checkIn) {
				this.checkInPopup.checkIn = checkIn;
				if(checkIn.id) {
					this.checkInPopup.isUpdate=  true;
					if(this.isMockingMode) {
						let pathname = this.pathname;
						pathname = pathname[pathname.length - 1] == '/' ? pathname : pathname + '/';
						history.replaceState(null, '', pathname+'checkin/'+checkIn.id);
					} else {
						let url = new URL(window.location.href);
						let params = url.searchParams;
						params.set("moreOptionsSubIndex",'1');
						params.set("checkInId",checkIn.id);
						
						history.replaceState(null, null, "?"+params.toString());
					}
				}
				this.onClickCancelEdit(event, checkIn);
			}
			this.inlineCreateCheckIn.show = false;
			this.checkInPopup.show = true;
		},
		onClickCloseCheckInPopup: function() {
			this.checkInPopup.show = false;
			this.checkInPopup.checkIn = {};
			this.checkInPopup.isUpdate = false;
			this.inlineCreateCheckIn.show = false;
			this.openCommentSection = false;
			this.selectedField = "";
			history.replaceState(null, '', this.pathname);
		},
		onSaveCheckIn: function(responseData, closePopup, group, isOlderDateGroup) {

			let _this = this;


			let checkIn = responseData.checkIn;
			let userByUsername = responseData.usersByUsername;

			if(userByUsername) {
				Object.keys(userByUsername).forEach(key => {
					if(!_this.usersByUsername[key]) {   // If user is not in list add him.
						_this.usersByUsername[key] = userByUsername[key];
					}
				});
			}

			this.addCheckInToList([checkIn], true);
			this.checkInsGroupByCreation = {};
			this.groupCheckIns(_this.checkInsList);
			if(closePopup) {
				this.onClickCloseCheckInPopup();
				this.$nextTick(()=>{
					_this.onClickOpenCheckInPopup(undefined, checkIn);				
				});
			} else {
				if(this.inlineCreateCheckIn.show) {
					this.inlineCreateCheckIn.show = false;
					_this.$nextTick(()=>{
						if(this.$refs && this.$refs['checkIn_'+ checkIn.id]) {
							this.$refs['checkIn_'+ checkIn.id][0].onClickInlineEditCheckIn();
						}					
					});
				}
			}
			this.$forceUpdate();
		},
		onClickInlineEdit: function(checkIn, group, isOlderDateGroup) {
			let checkInFromList = {};
			if(isOlderDateGroup) {
				checkInFromList = _.find(this.checkInsGroupByCreation.Older[group], {id: checkIn.id});
			} else {
				checkInFromList = _.find(this.checkInsGroupByCreation[group], {id: checkIn.id});
			}
			if(checkInFromList) {
				checkInFromList.isEditable = true;
			}
			this.$forceUpdate();
		},
		onClickCancelEdit: function(event, checkIn, group, isOlderDateGroup) {
			let checkInFromList = {};
			if(isOlderDateGroup) {
				checkInFromList = _.find(this.checkInsGroupByCreation.Older[group], {id: checkIn.id});
			} else {
				checkInFromList = _.find(this.checkInsGroupByCreation[group], {id: checkIn.id});
			}
			if(checkInFromList) {
				checkInFromList.isEditable = false;
			}
			this.$forceUpdate();
		},
		onUpdateCheckInDescription: function(checkInId, description) {
			let checkInFromList = _.find(this.checkInsList, {id: checkInId});
			if(checkInFromList) {
				checkInFromList.description = description;
			}
		},
		initialData: function() {
			return  {
				checkInPopup: {
					show	: false,
					checkIn	: {},
					isUpdate: false,

				},
				inlineCreateCheckIn: {
					show: false,
				},
				pagination: {
					pageSize	: 10,
					pageIndex	: 0,
				},
				usersPagination: {
					pageSize	: 20,
					pageIndex	: 0,
					users		: [],
				},
				oldPageIndex				: 0,
				totalCountAgainstQuery		: 0,
				checkInsList				: [],
				objectivesList 				: [],
				searchQuery					: '',
				pathname					: '',
				selectedField				: '',

				enableAddEdit				: false,
				showCheckInPopup			: false,
				showCheckMarkAfterRefresh	: false,
				openCommentSection			: false,
				showCreateNewMenu			: false,
				isRefreshing				: true,
				isLoading					: true,
				enableNewButton				: true,
				editorConfig				: CHECK_IN_EDITOR_CONFIG,
				editor						: ClassicEditor,

				usersByUsername				: {},
				checkInForEditing			: {},
				checkInsGroupByCreation		: {},

				checkInsListEditing			: [],
				dayGroups 					: ["Today", "Yesterday", "ThisWeek", "LastWeek"],
				olderDatesGroups			: []
			}

		},
		///////////////////////////////////////////////
		//// HELPER
		onCreatedCalled: function() {
			CHECK_IN_EDITOR_CONFIG.mention.feeds[0].feed = [];
			CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed = [];
			
			this.isRefreshing = true;
			this.fetchCheckIns();
			this.requestLoadUsers(true);
			this.populateMentionObjectives();
			this.pathname = window.location.href;
			this.debouncedFunction = _.debounce(this.onInputSearch, 500);
			if(!this.isMockingMode) {
				this.enableNewButton = vueInstance.activeBoard.id == vueInstance.activeBoard.session.activeSessionBoard; 
			}
			//this.fetchCheckInTemplate();
		},
		addCheckInToList: function(checkIns, addToTop) {
			let _this = this;
			if(!_.isEmpty(checkIns)) {
				_.forEach(checkIns, function(checkIn) {
					let updatedCheckIn = Object.assign({}, checkIn, {isEditable: false});
					let checkInIndex = _.findIndex(_this.checkInsList, {id: checkIn.id});
					if(checkInIndex > -1) {
						// Send to it's index
						_this.checkInsList.splice(checkInIndex, 1, updatedCheckIn);
					} else {
						// Add to Top
						if(addToTop) {
							_this.checkInsList.splice(0, 0, updatedCheckIn);
							_this.totalCountAgainstQuery += 1;
						} else {
							_this.checkInsList.push(updatedCheckIn);
							_this.totalCountAgainstQuery += 1;
						}

					}


				});
			}
		},
		toggleCheckIns: function() {
      		this.$emit("change-check-ins", this.showCheckIns);
		},
		onInputSearch: function() {
			let _this = this;
			if(!_.isEmpty(_this.searchQuery)) {
				_this.pagination.pageIndex = 0;
				_this.checkInsList = [];
				_this.checkInsListEditing = [];
				_this.checkInsGroupByCreation = {};
				_this.fetchCheckIns();
			} else if(_.isEmpty(_this.searchQuery)) {
				_this.checkInsList = [];
				_this.pagination.pageIndex = 0;
				_this.checkInsListEditing = [];
				_this.checkInsGroupByCreation = {};
				for(let i = 0; i <= _this.oldPageIndex; i++) {
					_this.pagination.pageIndex = i;
					_this.fetchCheckIns();
				}
			}
		},
		fetchCheckIns: function() {
			let _this = this;
			this.isLoading = true;
			let requestBody = {};
			if(this.context && this.context.id) {
				if(this.context.id == "-1") {    // Send Global Objective Workspace id.
					requestBody.relationId = kendisStore.getters.getObjectiveWorkspace().id;
				} else {
					requestBody.relationId = this.context.id;
				}

			} else {
				requestBody.relationId = kendisStore.getters.getObjectiveWorkspace().id;
			}

			requestBody.pageIndex = _this.pagination.pageIndex;
			requestBody.pageSize = _this.pagination.pageSize;
			requestBody.searchQuery = _this.searchQuery;
			axios.post('external-entitites/check-in/get', requestBody)
			.then(response=>{
				if(response && response.data) {
					if(_.isEmpty(response.data.checkIns)) {
						_this.pagination.pageIndex--;
					}
					if(_.isEmpty(_this.searchQuery)) {
						let checkInList = response.data.checkIns;
						_this.addCheckInToList(checkInList, false);
						kendisStore.commit('setCheckInTemplate', {scheme: response.data.scheme});
					} else {
						let checkInList = response.data.checkIns;
						_this.addCheckInToList(checkInList, false);
					}

					_this.groupCheckIns(response.data.checkIns);
					Object.assign(_this.usersByUsername, response.data.usersByUsername);
					_this.totalCountAgainstQuery = response.data.checkInsCount;
					this.isLoading = false;
					_this.$forceUpdate();
				}
			})
			.catch(error=>{
				console.error(error);
			});
		},
		onClickLoadMore: function() {
			this.pagination.pageIndex++;
			if(_.isEmpty(this.searchQuery)) {
				this.oldPageIndex = this.pagination.pageIndex;
			}
			this.fetchCheckIns();
		},
		onClose: function() {
			this.checkInForEditing 	= {};
			this.showCheckInPopup 	= false;
		},
		requestLoadUsers: function(clear) {
			if(clear) {
				this.pagination.pageIndex = 0;
			}

			this.loadMentionUsers();
		},
		loadMentionUsers: function() {
			// Fetching Users for Mentions
			axios.get('/pijourney/getUsers/'+ this.usersPagination.pageIndex +"/"+ this.usersPagination.pageSize)
				.then(response => {
					if (!_.isEmpty(response.data) ) {
						let users = response.data.users;
						for(let  i = 0; i < users.length; i++) {

							let isUserPresent = _.find(this.usersPagination.users, {id: users[i].id});
							if(!isUserPresent) {
								this.usersPagination.users.push(users[i]);
							}

							CHECK_IN_EDITOR_CONFIG.mention.feeds[0].feed.push(
								{
									id: ('@' + users[i].fullName),
									userName: users[i].email,
									fullName: users[i].fullName,
									backgroundColor: users[i].backgroundColor,
									email: users[i].email,
								});

						}

						if(users.length == this.usersPagination.pageSize) {
							this.usersPagination.pageIndex++;
							this.requestLoadUsers();
						}
					}
			}).catch(error => {
				console.log(error);
			});
		},
		populateMentionObjectives: function() {
			let _this = this;
			this.isLoading = true;
			let request = {};
			if(this.context && this.context.id) {
				request.contextId = this.context.id;
			}
			request.isMockingMode = this.isMockingMode;
			axios.post("/objective/get-objectives-and-kr", request).then(response => {
				let objectives = response.data.objectives;
				this.objectivesList = objectives;

				CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed = [];
				for(let  i = 0; i < objectives.length; i++) {
					let currentObjective = objectives[i];

					let parentId = undefined;

					let parentLink = _.find(currentObjective.baseItemLinks, {linkType: "parent_objective"});
					if(parentLink) {
						parentId = parentLink.baseItemId;
					}

					CHECK_IN_EDITOR_CONFIG.mention.feeds[1].feed.push(
						{
							id: ('#[' + currentObjective.key + "] " + currentObjective.title ),
							objectiveId: currentObjective.id,
							key: currentObjective.key,
							title: currentObjective.title,
							parentId: parentId,
						}
					);
				}
				_this.isRefreshing = false;
				_this.showCheckMarkAfterRefresh = true;
				setTimeout(() => {
					_this.showCheckMarkAfterRefresh = false;  // Hide the Refresh check mark after 1 second
				}, 1000);
				this.isLoading = false;
			}).catch(error => {
				console.log(error);
			});
		},
		refreshCheckIn: function() {
			Object.assign(this.$data, this.initialData());
			this.onCreatedCalled();
		},
		onSaveAndExpand: function(response) {
			this.onSaveCheckIn(response);
			this.onClickOpenCheckInPopup(undefined, response.checkIn);
			this.selectedField = "description";
		},
		onclickDeleteCheckIn: function(checkIn) {
            let _this = this;
            askFromSweetAlertWrapper("This will delete the Check-In with title " + checkIn.title,
                [_this.onDeleteCheckIn, checkIn],
                [takeNoAction]);
		},
		onDeleteCheckIn: function(checkIn) {
			let _this = this;
			axios.delete('external-entitites/check-in/delete/'+checkIn.id)
			.then(response=>{
				if(response && response.status === 200) {
					let checkInIndex = _.findIndex(_this.checkInsList, {"id": checkIn.id})
					if(checkInIndex > -1) {
						_this.checkInsList.splice(checkInIndex, 1);
						_this.checkInsGroupByCreation = {};
						_this.groupCheckIns(_this.checkInsList);
						_this.totalCountAgainstQuery -= 1;
					}
				}
			})
			.catch(error=>{
				console.error(error);
			});
		},
		groupCheckIns: function(checkInsList) {
			const groups = {
		        Today: [],
		        Yesterday: [],
		        ThisWeek: [],
		        LastWeek: [],
		        Older: {}
		    };

		    const now = new Date();
		    const today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
		    const yesterday = new Date(today);
		    yesterday.setDate(today.getDate() - 1);

		    const startOfWeek = new Date(today);
		    startOfWeek.setDate(today.getDate() - today.getDay());

		    const startOfLastWeek = new Date(startOfWeek);
		    startOfLastWeek.setDate(startOfWeek.getDate() - 7);

		    const endOfLastWeek = new Date(startOfLastWeek);
		    endOfLastWeek.setDate(startOfLastWeek.getDate() + 6);

		    checkInsList.forEach(obj => {
				const createdOn = new Date(obj.createdOn);

				if (createdOn >= today) {
		            groups.Today.push(obj);
		        } else if (createdOn >= yesterday && createdOn < today) {
		            groups.Yesterday.push(obj);
		        } else if (createdOn >= startOfWeek) {
		            groups.ThisWeek.push(obj);
		        } else if (createdOn >= startOfLastWeek && createdOn < startOfWeek) {
		            groups.LastWeek.push(obj);
		        } else {
		            const dateStr = createdOn.toISOString().split('T')[0];
		            if (!groups.Older[dateStr]) {
		                groups.Older[dateStr] = [];
		            }
		            groups.Older[dateStr].push(obj);
		        }
		    });

		    // Sort each group by createdOn date
		    const sortByCreatedOn = (a, b) => new Date(b.createdOn) - new Date(a.createdOn);

		    groups.Today.sort(sortByCreatedOn);
		    groups.Yesterday.sort(sortByCreatedOn);
		    groups.ThisWeek.sort(sortByCreatedOn);
		    groups.LastWeek.sort(sortByCreatedOn);

		    for (const date in groups.Older) {
		        groups.Older[date].sort(sortByCreatedOn);
		    }
			let sortedOlderKeys = Object.keys(groups.Older).sort((a, b) => {
			  // Convert date strings to Date objects
				const dateA = new Date(a);
				const dateB = new Date(b);
				// Compare dates
				return dateB - dateA; // For descending order
			});
			if(_.isEmpty(this.checkInsGroupByCreation)) {
		    	this.checkInsGroupByCreation = groups;
			} else {
				this.checkInsGroupByCreation["Today"] 		= this.checkInsGroupByCreation["Today"].concat(groups["Today"])
				this.checkInsGroupByCreation["Yesterday"] 	= this.checkInsGroupByCreation["Yesterday"].concat(groups["Yesterday"])
				this.checkInsGroupByCreation["ThisWeek"] 	= this.checkInsGroupByCreation["ThisWeek"].concat(groups["ThisWeek"])
				this.checkInsGroupByCreation["LastWeek"] 	= this.checkInsGroupByCreation["LastWeek"].concat(groups["LastWeek"])
			    for (const date in groups.Older) {
			        if(!this.checkInsGroupByCreation.Older[date]) {
						this.checkInsGroupByCreation.Older[date] = [];
					}
					this.checkInsGroupByCreation.Older[date] = this.checkInsGroupByCreation.Older[date].concat(groups.Older[date]);
			    }
			}
			if(_.isEmpty(this.olderDatesGroups)) {
				this.olderDatesGroups = sortedOlderKeys;
			} else {
				let mergedArray = this.olderDatesGroups.concat(sortedOlderKeys);

				// Remove duplicates using Set and Array.from
				this.olderDatesGroups = Array.from(new Set(mergedArray));
			}
		},
		addSpaceBeforeCapitalLetters: function(inputString) {
			return inputString.replace(/(?<!^)([A-Z])/g, ' $1');
		},
		formatDate: function (dateString) {
		    // Parse the input date string
		    const date = new Date(dateString);

		    // Define arrays for days and months
		    const daysOfWeek = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
		    const monthsOfYear = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

		    // Get the day of the week, month, and day from the parsed date
		    const dayOfWeek = daysOfWeek[date.getDay()];
		    const month = monthsOfYear[date.getMonth()];
		    const day = date.getDate();
		    const year = date.getFullYear();

		    // Construct the formatted date string
		    const formattedDate = `${dayOfWeek} ${month} ${day} ${year}`;

		    return formattedDate;
		},
		onClickOpenComment: function(checkIn) {
			this.openCommentSection = true;
			this.onClickOpenCheckInPopup(undefined, checkIn);
		},
		onSaveReaction: function(emoji, checkIn) {
			let _this = this;
			let conversation = {};
			conversation.user = {id: loggedInUser.id};
			conversation.conversationType = "Emoji";
			conversation.entityId = checkIn.id;
			conversation.entityType = "BaseItem";
			conversation.text = EMOJI_TO_CODE[emoji];

			axios.post('/external-entitites/conversation/save/emoji', conversation)
			.then(response=>{
				if(response.data) {
					if(response.data.conversation) {
						_this.$refs['checkIn_'+checkIn.id][0].emojiCount += 1;
					} else {
						_this.$refs['checkIn_'+checkIn.id][0].emojiCount -= 1;
					}
				}
				showTopMessage("Reaction saved successfully", "success", 2000);
			})
			.catch(error => {
				console.error("conversation save error", error);
				showTopMessage("Error Saving Reaction", "warning", 2000);
			})

		},
		handleInput: function() {
			// Debounce the method you want to call after 3 seconds
			this.debouncedFunction();
		},
		onUpdateEmojiCount: function(incrementCount, checkIn) {
			if(incrementCount) {
				this.$refs['checkIn_'+checkIn.id][0].emojiCount += 1;
			} else {
				this.$refs['checkIn_'+checkIn.id][0].emojiCount -= 1;
			}
		},
		onNewConversationAdded: function(checkIn) {
			this.$refs['checkIn_'+checkIn.id][0].conversationCount += 1;
		},
		onLoadConversation: function(count, checkIn) {
			this.$refs['checkIn_'+checkIn.id][0].conversationCount = count;
		},
		onDeleteConversation: function(checkIn) {
			this.$refs['checkIn_'+checkIn.id][0].conversationCount -= 1;
		}
	}
});