const BOARDS_LIST_LINKED_ITEMS = Vue.component('boards-list-linked-items', {
    props: {
        linkedItems: {
            type: Array,
            default: () => {
                return [];
            }
        },
		objectiveTeam: {
			type: Object,
			default: () => {
				return {};
			}
		},
        showList: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        editPermission: {
            type: Boolean,
            default: () =>{ return true }
        },
        readOnlyView: {
            type: Boolean,
            default: () => {
                return false;
            }
        },
        displayMode: {
            type: String,
            default: () => { return "default" }
        },

    },

    template: `

        <div>
        <div   v-for="sessionId in sessionList">
            <div class="ftsb pt-20 pb-20 pl-10 fs-22"> 
                {{sessionsMap[sessionId].session.title}} ({{boardItemsLinkedMap[sessionId].length}})
            </div>
            <ul v-if="boardItemsLinkedMap[sessionId].length > 0" class="o-items table prow listview mb-50 wbxa" :class="[showList ? 'd-block': '']">
              <li v-for="(linkData,linkIndex) in boardItemsLinkedMap[sessionId]" :key="linkData.randomId" :class="[boardItemsLinkedMap[sessionId][linkIndex].expandChild ? 'active' : '' ] ">
                <div class="rec aa DFA mb-0" @click="onClickLinkAccordian(sessionId,linkIndex)">
                <i  class="ti-angle-right acrd-arrin efangle" @click="onClickLinkAccordian(sessionId,linkIndex)"></i>
                 <img class="azurico" v-if="linkData.jiraIssueTypeId !== 'undefined'" :src="getIssueTypeIconUrl(linkData)" />					

                  <div style="border: 0" class="rc c2 rpkey">

                    <template v-if="linkData.tfsId">
                        <a :href="linkData.tfsURL" target="_blank">{{linkData.tfsId}}</a>
                        <img v-if="!_.isEmpty(linkData.tfsItemTypeIcon)" :src="linkData.tfsItemTypeIcon" alt="Azure" class="azurico">										
                    </template>
                    <a v-else-if="linkData.kendisKey" href="javascript:void(0);">{{linkData.kendisKey}}</a>
                    <a v-else-if="linkData.jiraKey" :href="linkData.jiraURL" :class="itemIcon(linkData)">{{linkData.jiraKey}}</a>
                  </div>
                  <div style="border: 0" class="rc c2 rpttl" :title="linkData.title" v-html="linkData.title"></div>
                  <div style="border: 0" class="rc c4 status" title="Status">
                    <span v-if="linkData.status" class="sts FL" :class="[linkData.status.category === 'ToDo' ? 'a' : (linkData.status.category === 'InProgress' ? 'b' : 'c')]">{{linkData.status.title}}</span>
                  </div>
                  <div style="border: 0" class="rc c4 statuses" title="Child counts">
                    <div class="statuses_cat">
                      <span v-if="linkData.childContByStatus && linkData.childContByStatus['ToDo']" title="ToDo"
                      class="sts a fs-10">{{linkData.childContByStatus['ToDo']}}</span>
                      <span v-if="linkData.childContByStatus && linkData.childContByStatus['InProgress']" title="In Progress"
                      class="sts b fs-10">{{linkData.childContByStatus['InProgress']}}</span>
                      <span v-if="linkData.childContByStatus && linkData.childContByStatus['Done']" title="Done"
                      class="sts c fs-10">{{linkData.childContByStatus['Done']}}</span>
                    </div>
                 </div>
                  <div style="border: 0" class="rc c4 w2">
                    <div class="prct_cat">
                      <span class="prct FR font-sbold"></span>
                      <template >{{linkData.completionPercentage+'%'}}</template>
                    </div>  
                  </div>
    
                  <div style="border: 0" class="rc c4 w2 points" title="Estimates">
                    <span>{{getFormatedDecimal(linkData.storyPoints)}}</span>
                  </div>
    
                  <div style="overflow: visible; border: 0" class="rc c4 tmtg wd-m">
                    <div v-for="team in linkData.teams" class="tm lbl-bg tooltip" :style="{color:team.color}">
                      <div v-if="team.label" class="line" :style="{backgroundColor:team.color}"></div>
                      {{team.label}}
                      <div class="hovtooltipB">{{team.title}}</div>
                    </div>
                  </div>
    
                  <div style="overflow: visible; border: 0" class="rc c4 spctg wd-m">
                    <template v-for="container in linkData.containers">
                      <span v-if="container.label" class="tooltip">{{container.label}}
                        <div class="hovtooltipB">{{container.title}}</div>
                      </span>
                   </template>
                  </div>
    
                    <em v-if="editPermission && !readOnlyView" class="rmv-ico ti-close e rnd sml DAJ efremv" @click.stop="onClickRemoveLink(sessionId,linkIndex)" title="Remove"></em>
    
                </div>	
    
                 <ul v-if="boardItemsLinkedMap[sessionId][linkIndex].expandChild" class="sub-items pl-20">
                   <div v-for="child in linkData.subItems" class="rec mb-0">
                     <template v-if="showChildItem(child)">
                        <img class="azurico" v-if="child.jiraIssueTypeId !== 'undefined'" :src="getIssueTypeIconUrl(child)" />					

                       <div style="border: 0" class="rc c2 rpkey">
                            <template v-if="child.tfsId">
                                <a :href="child.tfsURL" target="_blank">{{child.tfsId}}</a>
                                <img v-if="!_.isEmpty(child.tfsItemTypeIcon)" :src="child.tfsItemTypeIcon" alt="Azure" class="azurico">										
                            </template>
                            <a v-else-if="child.kendisKey" href="javascript:void(0);">{{child.kendisKey}}</a>
                            <a v-else-if="child.jiraKey" :href="child.jiraURL" :class="itemIcon(child)">{{child.jiraKey}}</a>
    
                         <!--<a v-if="child.tfsId" :href="child.tfsURL"
                           target="_blank">{{child.tfsId}}</a>
                         <a v-else-if="child.jiraKey" :href="child.jiraURL"
                           target="_blank">{{child.jiraKey}}</a>
                         <a v-else-if="child.kendisKey" href="javascript:void(0);"
                           target="_blank">{{child.kendisKey}}</a>-->
                      </div>
                       <div style="border: 0" class="rc c2 rpttl" title="s1">{{child.title}}</div>
                       <div style="border: 0" class="rc c2 status" title="Status">
                         <span class="sts FL"
                           :class="[child.status.category === 'ToDo' ? 'a' : (child.status.category === 'InProgress' ? 'b' : 'c')]">{{child.status.title}}</span>
                       </div>
    
                       <div style="border: 0" class="rc c2 statuses" title="Child counts">
                         <div class="statuses_cat"></div>
                       </div>
                       <div style="border: 0" class="rc c2 w2 ">
                         <div class="prct_cat">
                           <span class="prct FR font-sbold"></span>
                         </div>
                        </div>
    
                        <div style="border: 0" class="rc c2 w2 points" title="Estimates">
                          <span>{{getFormatedDecimal(child.storyPoints)}}</span>
                        </div>
    
                        <div style="overflow: visible; border: 0" class="rc c2 tmtg wd-m">
                          <div v-for="team in child.teams" class="tm lbl-bg tooltip"
                            :style="{color:team.color}">
                            <div v-if="team.label" class="line" :style="{backgroundColor:team.color}">
                            </div>
                            {{team.label}}
                            <div class="hovtooltipB">{{team.title}}</div>
                          </div>
                        </div>
    
                       <div style="overflow: visible; border: 0" class="rc c2 spctg wd-m">
                         <template v-for="container in child.containers">
                           <span v-if="container.label" class="tooltip">{{container.label}}
                             <div class="hovtooltipB">{{container.title}}</div>
                           </span>
                         </template>
                       </div>
                     </template>
                  </div>
    
                </ul>
    
              </li>
            </ul>
        </div>
        </div>
	         `,

    data() {
        return {
            //maps for fast searvching
            boardItemsLinkedMap: {},
            sessionsMap:{},
            itemsMap:{},
            sessionList:[],
            issueTypesMeta:{},
        }
    },

    watch: {
        linkedItems: function (_newList, _oldList) {
            this.populateItemsData(_newList);
            this.createBatchesToItemLinkingMap();
            this.fetchItemsMeta()
        }
    },
	computed: {
		showChildItem: function() {
			let _this = this;
			return function(item) {
				let show = false;
				if(_.isEmpty(_this.objectiveTeam) || item.type == "Feature") {
					show = true;
				}
				if(item.teamContainers) {
					let containers = item.teamContainers;
					for(let i = 0; i < containers.length;  i++) {
						if(containers[i].team && containers[i].team.id == _this.objectiveTeam.id) {
							show = true;
							break;
						}
					}
				}
				return show
			}
		},
		itemIcon: function() {
			return function(item) {
				return getItemIcon(item);
			}
		}						
	},
	
    created() {
    },

    mounted() {
        this.populateItemsData(this.linkedItems);
        this.createBatchesToItemLinkingMap();
        this.fetchItemsMeta();

    },

    methods: {
        validate : function() {
            return this.boardItemsLinkedMap && this.boardItemsLinkedMap.length > 0;
        },
        fetchItemsMeta : function (){
            try {
                let boardIdsString = this.sessionList.join(',');
                axios.get('/plan/getMetaInfo/' + boardIdsString)
                    .then(response => {
                        if (response && response.data) {
                            let issueTypesInfoTypes= new Map();
                            let responseDataMap = new Map(Object.entries(response.data));

                            for (let [key, value] of responseDataMap) {
                                if (value && value.jiraProjectIssueTypes) {
                                    _.each(value.jiraProjectIssueTypes, project => {
                                        if (project.issueTypes) {
                                            const issueTypesJson = JSON.parse(project.issueTypes);
                                            _.each(issueTypesJson, issType => {
                                                if (issType.id && issType.iconUrl) {
                                                    if (issType.iconUrl){
                                                        issueTypesInfoTypes.set("icon_"+issType.id, issType.iconUrl);
                                                    }
                                                    if (issType.name){
                                                        issueTypesInfoTypes.set("name_"+issType.id, issType.name);
                                                    }
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                            this.issueTypesMeta=issueTypesInfoTypes;

                        }
                    })
                    .catch(error => {
                        console.log("Exception occured while getting meta function");
                    });
            }catch (e){
                console.log("Exception occured while getting meta function"+e);
            }finally {
            }

        },
        getIssueTypeIconUrl: function(item) {
            let resultIconUrl = '';
            try {
                if (item && item.jiraFieldByKey && item.jiraFieldByKey.issuetype && item.jiraFieldByKey.issuetype.iconUrl) {
                    resultIconUrl = item.jiraFieldByKey.issuetype.iconUrl;
                } else {
                    if (this.issueTypesMeta && item.jiraIssueTypeId) {
                        resultIconUrl = this.issueTypesMeta.get("icon_" + item.jiraIssueTypeId);
                    }
                }
            }catch (e) {
                console.log(e)
            }
            return resultIconUrl;
        },
        createBatchesToItemLinkingMap: function() {
            let _this = this;
            let boardItemMapTemp = {};
            let sessionsMap = {};
            let itemsMap = {};
            let sessionList = [];

            this.linkedItems.forEach(item=>{
                if(item.sessionBoards){
                    item.sessionBoards.forEach(sessionBoard=>{
                        if(sessionBoard.session){
                            if (boardItemMapTemp[sessionBoard.session.id]=== undefined) {
                                boardItemMapTemp[sessionBoard.session.id] = [];
                            }
                            item.completionPercentage =   _this.calculateCompletionPercentage(item);

                            boardItemMapTemp[sessionBoard.session.id].push(item)
                            if(sessionsMap[sessionBoard.session.id]=== undefined){
                                sessionList.push(sessionBoard.session.id);
                                sessionsMap[sessionBoard.session.id]  = sessionBoard;

                            }
                        }
                    })
                }
                itemsMap[item.id] = item;
            })
            this.boardItemsLinkedMap = boardItemMapTemp;
            this.itemsMap = itemsMap;
            this.sessionsMap = sessionsMap;
            this.sessionList = sessionList;

        },
        calculateCompletionPercentage : function(item){
            let completedStories = 0;
            if(!item.subItems  ||  item.subItems.length==0){
                if(item.status && item.status.category == "Done"){
                    return 100;
                }else{
                    return 0;
                }
            }

            let noOfAllStories= item.subItems.length
            item.subItems.forEach(subItem =>{
                if(subItem.status && subItem.status.category == "Done" ) {
                    completedStories = completedStories + 1;
                }
            });
            return Math.round(completedStories/noOfAllStories*100);
        },

        onClickLinkAccordian: function (sessionId,itemIndex) {
            this.boardItemsLinkedMap[sessionId][itemIndex].expandChild = !this.boardItemsLinkedMap[sessionId][itemIndex].expandChild;
            this.$forceUpdate();
        },

        populateItemsData: function (items) {
            let _this = this;
            if (items.length > 0) {
                _.each(items, function (item) {
                    let containers = [];
                    let teams = [];
                    //.......................
                    // let teamContainers = _this.getTeamAndContainers(item);
                    // containers = teamContainers["containers"]
                    // teams = teamContainers["teams"]
                    // //.......................
                    // item.containers = _.isEmpty(containers) ? [{}] : containers;
                    // item.teams = _.isEmpty(teams) ? [{}] : teams;
                    if (item.subItems && item.subItems.length > 0) {
                        let storyPoints = 0;
                        let childCount = {"ToDo": 0, "InProgress": 0, "Done": 0, "Misc": 0};
                        _.each(item.subItems, child => {
                            // let teamContainers = _this.getTeamAndContainers(child);
                            // child.containers = teamContainers["containers"];
                            // child.teams = teamContainers["teams"];
                            if (child.status) {
                                storyPoints += (child.storyPoints ? child.storyPoints : 0);
                                childCount[child.status.category] += 1;
                            }
                        });
                        item.childContByStatus = childCount;
                        item.storyPoints = storyPoints;
                    }
                    item.expandChild = false;
                })
            }
        },

        getTeamAndContainers: function (item) {
            let _this = this;
            let teams = [];
            let containers = [];
            if (!_.isEmpty(item.teamContainers)) {
                _.each(item.teamContainers, tc => {

                    //.........................
                    let teamExist = false;
                    _.each(teams, et => {
                            if (et.id === tc.team.id) {
                                teamExist = true;
                                return;
                            }
                    });
                    if (!teamExist) {
                        let team = _.find(_this.$parent.board.teams, {id: tc.team.id});
                        teams.push(team);
                    }
                    //........................
                    let containerExist = false;
                    _.each(containers, et => {
                            if (et.id === tc.container.id) {
                                containerExist = true;
                                return;
                            }
                    });
                    if (!containerExist) {
                        let container = _.find(_this.$parent.board.containers, {id: tc.container.id});
                        containers.push(container);
                    }
                });
            }
            return {"teams": teams, "containers": containers};
        },

        getFormatedDecimal: function (value) {
            if (!value) {
                return 0;
            }
            return getFormated(value);
        },

        onClickRemoveLink: function (sessionId,index) {
            let _this = this;
            askFromSweetAlertWrapper("Do you want to remove this link?",
                [_this.unlinkItem, _this.boardItemsLinkedMap[sessionId][index]],
                [takeNoAction]);
        },

        unlinkItem: function (item) {
            let _this = this;
            let requestBody = {};
            requestBody.id = _this.$parent.$parent.batchData.id;
            requestBody.itemId = item.id;

                requestBody.metaMap = {
                    "syncId" : syncId,
                }
            axios.post('batch/remove-base-item-link', requestBody)
                .then(response => {
                    if (response && response.status == "200") {
                        _.remove(_this.linkedItems, {id: item.id});
                        Object.keys( _this.boardItemsLinkedMap).forEach(function (key){
                            _.remove(_this.boardItemsLinkedMap[key], {id: item.id});

                        });
                            _this.$forceUpdate();
                        _this.$emit("remove-linked-item", item.id);
                    }
                })
                .catch(error => {
                    console.error("Item Link remove error", error);
                    handleSoSErrorMsg(error);
                })
        },
    }
});