const BATCH_GROUP_COMPONENT = Vue.component('batch-group-component', {
    mixins: [OBJECTIVE_MIXIN],
    props: {

        batchIndex: {
            type: String,
            default: () => {
                return "";
            }
        },
        batchGroupObj: {
            type: Object,
            default: () => {
                return {};

            }
        }
    },
    data() {
        return {
            objectives: [],
            committedList: [],
            newObjectiveData: {
                title: "",
                bvPlan: 0,
                bvActual: 0
            },
            newObjective: {},
            editObjectiveData: {},
            itemTemplate: {
                showEditPopUp: false,
                showMileStonePopup: false,
                templateToRenderer: {},
                statuses: [],
                itemType: {},
            },
            objectiveGroup: {
                type: Object,
                default: () => {
                    return {};
                }
            },
            // objectURL: "",
            showMenuOverlay: false,
			childLayout : {},
            loading: false,
            createSubBatchOption: false,
        }
    },
    watch: {
        '$root.batches.expandAll': {
            handler: function(expandAll) {
                this.batchGroupObj.showChildren = true;
                this.changeShowChildrenOnRoot(true);
            },
        },
        '$root.batches.minimizeAll': {
            handler: function(minimizeAll) {
                this.batchGroupObj.showChildren = false;
                this.changeShowChildrenOnRoot(false);

            },
        }
    },
    computed: {
        pathToBatch(){ //has the url to open batch detail view
            let baseRoute=this.$route.path;
            if(baseRoute[baseRoute.length-1] != '/'){
                baseRoute = baseRoute+ '/';
            }
            return baseRoute+this.batchGroupObj.key
        },
        style() {
            let style = {
                backgroundColor: this.batchGroupObj.headerColor ? this.batchGroupObj.headerColor + '10' : '',
            };
            if (this.batchGroupObj.headerColor && this.batchGroupObj.headerColor != '') {
                style.borderLeft = '5px solid ' + this.batchGroupObj.headerColor;
            }
            return style;
        },
        getKey(){
            if(this.batchGroupObj.highlightedKey && !_.isEmpty(this.batchGroupObj.highlightedKey)){
                return this.batchGroupObj.highlightedKey;
            }
            return this.batchGroupObj.key;
        },
        getTitle(){
            if(this.batchGroupObj.highlightedText && !_.isEmpty(this.batchGroupObj.highlightedText)){
                return this.batchGroupObj.highlightedText;
            }
            return this.objectiveGroup.title;
        },
        startDate: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objectiveGroup.id && this.objectiveGroup.fields && !_.isEmpty(this.objectiveGroup.fields)){
                for(let fieldId in this.objectiveGroup.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'Start Date'){
                        return this.trimDate(this.objectiveGroup.fields[fieldId]);
                    }
                }
            }
        },
        endDate: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objectiveGroup.id && this.objectiveGroup.fields && !_.isEmpty(this.objectiveGroup.fields)){
                for(let fieldId in this.objectiveGroup.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'End Date'){
                        return this.trimDate(this.objectiveGroup.fields[fieldId]);
                    }
                }
            }
        },
        batchTypes: function() {
            if (!_.isEmpty(this.$root.batches.fieldsData) && this.objectiveGroup.fields) {
                for (let fieldId in this.$root.batches.fieldsData) {
                    if (this.$root.batches.fieldsData[fieldId].identifier === 'BATCH_TYPE') {
                        let batchTypeValue = this.objectiveGroup.fields[fieldId];
                        if (batchTypeValue) {
                            // Get the field definition with allowedObjects
                            let fieldDefinition = this.$root.batches.fieldsData[fieldId];
                            let allowedObjects = fieldDefinition.allowedObjects || [];
                        
                            // Convert batchTypeValue to array if needed
                            let selectedValues = Array.isArray(batchTypeValue) ? batchTypeValue : [batchTypeValue];
                            
                            // Map selected values to full objects from allowedObjects
                            let selectedTypes = [];
                            selectedValues.forEach(selectedValue => {
                                let matchingObject = allowedObjects.find(obj => obj.id === selectedValue.id);
                                if (matchingObject) {
                                    selectedTypes.push(matchingObject);
                                }
                               
                            });
                        
                            return selectedTypes;
                        }
                        return [];
                    }
                }
            }
            return [];
        },
        batchResponsiblesNames: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objectiveGroup.id && this.objectiveGroup.fields && !_.isEmpty(this.objectiveGroup.fields)){
                for(let fieldId in this.objectiveGroup.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'Responsibles'){
                        //get full name of users
                        let responsibles = this.objectiveGroup.fields[fieldId];
                        let responsiblesFullName = [];
                        if(responsibles && responsibles.length > 0){
                            responsibles.forEach(responsible => {

                                if(responsible){
                                    responsiblesFullName.push(responsible.fullName);
                                }
                            });
                        }

                        return responsiblesFullName;
                    }
                }
            }
        },
        batchResponsiblesObjects: function () {
            if(!_.isEmpty(this.$root.batches.fieldsData) && this.objectiveGroup.id && this.objectiveGroup.fields && !_.isEmpty(this.objectiveGroup.fields)){
                for(let fieldId in this.objectiveGroup.fields){
                    if(this.$root.batches.fieldsData[fieldId] && this.$root.batches.fieldsData[fieldId].title == 'Responsibles'){
                        //get full name of users
                        let responsibles = this.objectiveGroup.fields[fieldId];
                        return responsibles;
                    }
                }
            }
        },
        itemCounts: function (){
            let itemCount =0;
            if(this.objectiveGroup.baseItemLinks) {
                this.objectiveGroup.baseItemLinks.forEach(link => {
                    if (link.itemId && link.itemId != "") {
                        itemCount = itemCount + 1;
                    }
                });
                if(itemCount==0){
                    itemCount="-";
                }
            }
            return itemCount;
        },
        sortedChildren: function () {
            let _this = this;
            try {
                let unsortedBatchChildren = this.batchGroupObj.baseItemList;
                //we change the sequence of the batches according to the links sequence so that the batches are sorted according to the sequence of the links
                //for the parent batch sort the main sequence of batch will be used
                if (unsortedBatchChildren) {
                    unsortedBatchChildren.forEach(batch => {
                        if (_this.batchChildrenSequenceMap) {
                            batch.sequence = _this.batchChildrenSequenceMap[batch.id];
                        }
                    });
                    unsortedBatchChildren.sort(function (a, b) {
                        return a.sequence - b.sequence;
                    });
                    return unsortedBatchChildren;
                }
            }
            catch (e) {
                console.log("Error in sorting batch children");
            }
            return [];
        },
        batchChildrenSequenceMap: function() {
            let baseItemSequenceMap = {};
            let baseItem = this.batchGroupObj;
            if (baseItem.baseItemLinks) {
                baseItem.baseItemLinks.forEach(function (link) {
                    if (link.linkType == "Child-Batch"
                        && link.baseItemId != ""
                        && link.baseItemId != null) {
                        baseItemSequenceMap[link.baseItemId] = link.sequence;
                    }
                });
            }
            return baseItemSequenceMap;
        },
        batchCalculation() {
            return function (id, criteria) {
                if (!_.isEmpty(this.$root.batches.batchCompletionMap[id])) {
                    let value = 0;

                    if (criteria) {
                        if (criteria === 'r_st') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByRollupStatus;
                        } else if (criteria === 'r_sp') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByRollupEstimate;
                        } else if (criteria === 'c_st') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByDoneChildren;
                        } else if (criteria === 'c_lis') {
                            value = this.$root.batches.batchCompletionMap[id].calculationByLinkedItems;
                        }
                        return value > 0 ? value.toFixed(2) : 0;
                    } else {
                        value = this.$root.batches.batchCompletionMap[id].calculationByLinkedItems ? this.$root.batches.batchCompletionMap[id].calculationByLinkedItems : 0;
                        return value;
                    }
                }
                return 0;
            }
        },
    },
    created() {
		this.$options.permissions = kendisStore.getters.getBatchesPermissions();
    },

    mounted() {
        // this.objectiveGroup= this.$root.batches.treeForm[this.batchIndex];
        //
        // let baseRoute=this.$route.path;
        // if(baseRoute[baseRoute.length-1] != '/'){
        //     baseRoute = baseRoute+ '/';
        // }
        // this.objectURL=baseRoute+this.$root.batches.treeForm[this.batchIndex].key
        this.objectiveGroup= this.batchGroupObj; //copy of reference
    },


    template: `
        <div v-if="loading" class="loader"><div><div class="loaderinteg"></div>Loading ...</div></div>
        
		<div v-else class="prow" :class="[objectiveGroup.expand ? 'active' : '']">
		    <dynamic-popup-container 
				 ref="itemPopup"
		         v-if="itemTemplate.showEditPopUp"
		         @close = "onCLoseEditPopUp"
		         @save = "onSaveBatch"
		         @saved-batch-criteria="onSaveBatchCompletionCriteria"
		         :template-to-render="itemTemplate.templateToRenderer"
		         :template-statuses = "itemTemplate.statuses"
		         :item-type="itemTemplate.itemType"
		         :fields-value="itemTemplate.model"
		         :template = "itemTemplate"
				 :show-notify-watchers="false"
		         :show-attachments="false"
		         :show-watchers="true"
		         :show-history="true"
		         :show-conversations="true"
		         :entity-type="'BaseItem'"
		         :entity-id="itemTemplate.id"
				 :displayMode ="'Batches'"
				 :showObjectiveLinking="true"
				 :showNotifyWatchers="false"
				 :system-fields="childLayout ? childLayout.systemFieldsToExclude : []"


		    />
		<div class="rec parent" :class="[batchGroupObj.showChildren ? 'active' : '']" :style="style"
		     @mouseover="createSubBatchOption = true"
		     @mouseleave="createSubBatchOption = false">
		        <div>
		            <em title="Move" class="p-abs move ti-move"></em>
		        </div>
		        
				<div class="rc c2"> 
					<em v-if="batchGroupObj.baseItemList && !_.isEmpty(batchGroupObj.baseItemList)" class="ti-angle-right arrdn c-point" @click="toggleChildren" ></em>			 			
					<div class="tlout"><router-link :to="pathToBatch" exact class="mr-5" v-html="getKey"></router-link>
					<span class="ttl" v-html="getTitle"> </span></div>
		    	</div>
		    	                    

		    	<div  class="rc c3">
		    	    <span v-if="$root.flags.isBatchCompletionMapLoaded">        
		    	        <div v-if="!$root.batches.batchCompletionMap[batchGroupObj.id]" class="progrs-bar DFA  pt-5 batchProgrsBar batchListProgressBar">
		    	             <div class="bar batchBar mr-10 ">
                                <div class="bn" style="width:0%"></div>
                             </div> 
                             <div class="">
                                0%
                             </div> 
                        </div>     
                        <div v-else class="progrs-bar DFA  pt-5 batchProgrsBar batchListProgressBar">
                            <div class="bar batchBar mr-10 ">
                                <div class="bn" :style="{width:(batchCalculation(batchGroupObj.id, batchGroupObj.fields.selectedCriteria)+'%')}"></div>
                            </div> 
                            <div class="">
                                {{batchCalculation(batchGroupObj.id, batchGroupObj.fields.selectedCriteria)+'%'}}
                            </div>
                        </div>
		    	    </span>
<!--		    	    if a new batch is added then show 0% completion as items are note linked-->
		    	    <span v-else>     
                        <div class="minldr">
                            <div class="loaderinteg"></div>
                        </div>    
                    </span>                              
		        </div>
		    	<div class="rc c3">
		    	    <multiple-users-display-component :batch-responsibles-objects="batchResponsiblesObjects" ></multiple-users-display-component>
		    	</div>
		    	<div class="rc c3"><div class="pt-5">{{startDate}}</div></div>
	            <div class="rc c3"><div class="pt-5">{{endDate}}</div></div>
				<div class="rc c4 status"><span class="sts pt-5 btchsts" v-bind:class="{ a: batchGroupObj.status.category=='ToDo',b: batchGroupObj.status.category=='InProgress',c: batchGroupObj.status.category=='Done' }">{{batchGroupObj.status.title}}</span></div>
				<div class="rc c3 blnk">
				    <div class="DFA-a FW pt-5">
				        <div v-for="(type, index) in batchTypes" :key="type.id || index" 
				             class="spttg nsw mxwd tooltip mr-5 mb-5" 
				             style="color: rgb(38, 186, 161);">
				            <span class="sss" style="background-color: rgba(38, 186, 161, 0.19); color: rgb(38, 186, 161);">
				                {{type.title}}
				            </span>
				            <div class="hovtooltipB">{{type.title}}</div>
				        </div>
				    </div>
				</div>
				 <div v-if="$options.permissions.MANAGE_BATCH_GROUP || $options.permissions.ADD_EDIT_BATCH" class="rc c3 DF">
				    <a v-if = "createSubBatchOption" class="ti-plus addf pt-5 c-point wht-nwrp" @click.stop="onAddSubBatchClick">
                        Create Sub-Batch
				    </a>
				 </div>
            	<!-- <div class="r-icons DFA"><a href="javascript:void(0);" @click="onAddSubBatchClick" class="ti-plus addf ml-20">Add</a></div> -->
            	<em class="ti-more-alt menu icoa DAJ" @click.stop="onClickShowMenuPopup" v-if="$options.permissions.MANAGE_BATCH_GROUP || $options.permissions.ADD_EDIT_BATCH"></em>
                <vuepopup v-if="showMenuOverlay" @close="showMenuOverlay=false">
                	<div class="drop_box nwmu artp sml" style="display:block">
                    <ul>
                    <template>
                    	<li class="c-point" @click.stop="onAddSubBatchClick">Add Sub-Batch</li>
                    </template>
                    </ul>
                    </div>
                </vuepopup>
			</div>
				<draggable :value="sortedChildren"
							    animation=150 easing="cubic-bezier(1, 0, 0, 1)"
								@start="onItemDragStart"
								@end="onItemDragEnd" >
								
                                <sub-batch-component v-show="batchGroupObj.showChildren"  v-for="objective in sortedChildren"
                                    :group-id="batchGroupObj.id"
                                    :key="objective.id"
                                    :objective="objective"
                                    :okr-list="objective.baseItemList"
                                    :parent-color = "batchGroupObj.headerColor"
                                    :parent-batch="batchGroupObj"/>
				</draggable>

		</div>	
		
	`,
    components:{
        'multiple-users-display-component':MultipleUsersDisplayComponent,
    },
    methods: {
        /**
         * Gets the Batch Type field information from parent batch group
         * @returns {Object} Object containing fieldId and parentValue, or null if not found
         */
        getParentBatchTypeInfo() {
            try {
                // Find the Batch Type field in fieldsData
                let batchTypeFieldId = null;
                let parentBatchTypeValue = null;

                if (this.$root.batches.fieldsData) {
                    for (let fieldId in this.$root.batches.fieldsData) {
                        const field = this.$root.batches.fieldsData[fieldId];
                        if (field && field.identifier === 'BATCH_TYPE') {
                            batchTypeFieldId = fieldId;
                            break;
                        }
                    }
                }

                // Get parent's Batch Type value if field exists and parent has fields
                if (batchTypeFieldId && this.batchGroupObj && this.batchGroupObj.fields) {
                    parentBatchTypeValue = this.batchGroupObj.fields[batchTypeFieldId];
                }

                return {
                    fieldId: batchTypeFieldId,
                    parentValue: parentBatchTypeValue
                };
            } catch (error) {
                console.error('Error getting parent batch type info:', error);
                return null;
            }
        },
        changeShowChildrenOnRoot(showChildren){
            try {
                if (this.$root.batches.keyMap[this.batchGroupObj.id]) {
                    this.$root.batches.keyMap[this.batchGroupObj.id].showChildren = showChildren;
                }
            }catch (e) {
                console.log("Error in changing show children on root")
            }
        },

        toggleChildren: function() {
            this.batchGroupObj.showChildren=!this.batchGroupObj.showChildren;
            this.changeShowChildrenOnRoot(this.batchGroupObj.showChildren);
            this.$forceUpdate();
        },
        onItemDragEnd: function(evt) {
            this.sortLinkedBatch(evt.newIndex, evt.oldIndex);
        },
        onItemDragStart: function(evt) {

        },
        calculateNewSequenceOfItem: function(newIndex, oldIndex, list, key) {
            var sequence;
            if (_.isEmpty(list)) {
                sequence = 0;
            } else {
                if (newIndex == 0) {
                    var nextItem = list[0]
                    sequence = nextItem[key] - 1000;

                } else if (newIndex >= list.length - 1) {
                    var preItem = list[list.length - 1];
                    sequence = preItem[key] + 1000;

                } else {

                    var preItem;
                    var nextItem;

                    if (oldIndex == -1 || oldIndex > newIndex) {
                        preItem = list[newIndex - 1];
                        nextItem = list[newIndex];
                    }
                    else {
                        preItem = list[newIndex];
                        nextItem = list[newIndex + 1];
                    }

                    sequence = (parseFloat(preItem[key]) + parseFloat(nextItem[key])) / 2.0;
                }
            }
            return { value: sequence, key: key };
        },

        sortLinkedBatch: function(newIndex, oldIndex) {

            var _this = this;
            var linkedBatch =  _this.batchGroupObj

            var item = this.sortedChildren[oldIndex];
            var sequenceObject = this.calculateNewSequenceOfItem(newIndex, oldIndex, this.sortedChildren, "sequence");
            // value, key

            var data = {};
            data.linkedBatchId = item.id;
            data.sequence = "" + sequenceObject.value;
            data.batchId= this.objectiveGroup.id;
            this.loading=true;
            axios.post('/batch/update-linked-child-batches-sequence/'+syncId, data)
                .then(res => {

                    if (res.status=="200") {

                        item.sequence = data.sequence;
                        linkedBatch.baseItemLinks.forEach(function (link) {
                            if (link.linkType == "Child-Batch" && link.baseItemId == item.id) {
                                Vue.set(link, "sequence", data.sequence);
                            }
                        });

                    }else{
                        onAlmError(res.data.error);
                    }
                    _this.loading=false;

                }).catch(error => {
                _this.loading=false;
                console.log(error)
            });
        },

        onClickShowMenuPopup: function () {
            this.showMenuOverlay = !this.showMenuOverlay;
        },
        getKeys(){
            let a=Object.keys(this.objectiveGroup.fields);
           return  a;
        },
        trimDate(dataTime){
            if(dataTime instanceof Date){
                return dataTime.toISOString().substring(0,10);
            }
            return dataTime.substring(0,10);
        },
        onCLoseEditPopUp: function () {
            let _this = this;
            _this.itemTemplate.showEditPopUp = false;
            _this.$forceUpdate();
        },

		onAddSubBatchClick: function() {
			let _this = this;
	        _this.itemTemplate = {};
	        _this.itemTemplate.model = {};
	        _this.itemTemplate.model.fields = {};
            _this.itemTemplate.model.status = {};
            _this.itemTemplate.statuses = [];
            
            // Set default status
            if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                _this.itemTemplate.model.status  = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
            }
            
            // Inherit Batch Type from parent batch group
            const batchTypeInfo = _this.getParentBatchTypeInfo();
            if (batchTypeInfo && batchTypeInfo.fieldId && batchTypeInfo.parentValue) {
                // Ensure Batch Type value is always an array for multiselect field
                const batchTypeValue = Array.isArray(batchTypeInfo.parentValue) 
                    ? batchTypeInfo.parentValue 
                    : [batchTypeInfo.parentValue];
                _this.itemTemplate.model.fields[batchTypeInfo.fieldId] = batchTypeValue;
            }
            
		    _this.itemTemplate.templateToRenderer = kendisStore.getters.getBatchTemplate().scheme.fieldsTemplate;
			_this.itemTemplate.statuses = kendisStore.getters.getBatchTemplate().statuses;
            _this.itemTemplate.itemType = kendisStore.getters.getBatchTemplate().scheme.itemType;			
	        _this.itemTemplate.showEditPopUp = true;
			// render custom layout for sub batch
			//_this.renderCustomLayout();
			_this.$forceUpdate();			
		},
        setBaseItemStatus: function (requestBody) {
            if (_.isEmpty(requestBody.status)) {
                if(requestBody.type=="Batch"){
                    if (_.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchTemplate().statuses, {"category": "ToDo"});
                    }
                }else{
                    if (_.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"}) !== -1) {
                        requestBody.status = _.find(kendisStore.getters.getBatchGroupTemplate().statuses, {"category": "ToDo"});
                    }
                }
            }
        },
		renderCustomLayout : function () {
			var _this = this;
			var batchGroup = this.$root.batches.treeForm[this.batchIndex];
			if(batchGroup && !_.isEmpty(batchGroup.baseItemLinks)) {
				var baseItemLink = _.find(batchGroup.baseItemLinks, {type : batchGroup.type});
				if(baseItemLink && !_.isEmpty(baseItemLink.childLayout)) {
					this.childLayout = baseItemLink.childLayout;
					Vue.nextTick(function() {
						if (!_.isEmpty(_this.childLayout.fields)) {
							if (_this.$refs["itemPopup"]) {
								_.each(_this.childLayout.fields, (field) => {
									_this.$refs["itemPopup"].onAddCustomFieldInContainer(field, _this.childLayout);
								});
							}
						}
					});
				}
			}
			if (_.isEmpty(this.childLayout)) {
				axios.get("/customfield/get/default-layout/" + "Batch")
					.then(response => {
						if (response.data) {
							_this.childLayout = response.data;
							Vue.nextTick(function() {
								if (!_.isEmpty(_this.childLayout.fields)) {
									if (_this.$refs["itemPopup"]) {
										_.each(_this.childLayout.fields, (field) => {
											_this.$refs["itemPopup"].onAddCustomFieldInContainer(field);
										});
									}
								}
							});
						}
					}).catch(error => {
	
					});
			}
		},
		onSaveBatch: function(requestBody) {
			console.log("Data", requestBody)
            let _this = this;
			delete requestBody.bvPlan;
			delete requestBody.bvActual;
            let baseItemLinks = {type: "Batch"};
            let baseItemLinkParent = {linkType: "Parent-Batch", baseItemId:_this.objectiveGroup.id};
            requestBody.baseItemLinks = [];
            requestBody.baseItemLinks.push(baseItemLinks);
            requestBody.baseItemLinks.push(baseItemLinkParent);
            requestBody.starred = false;
            this.setBaseItemStatus(requestBody);
            axios.post('external-entitites/save-base-item/popup-save', requestBody)
            .then(response => {
                if (response.status == "200" && response && response.data) {
                    let baseItem = _.clone(_this.objectiveGroup);	
                    let okr = response.data.impediment;	
                    let baseItemLink = {};
                    baseItemLink.baseItemId = okr.id;
                    baseItemLink.linkType="Child-Batch";
                    baseItem.baseItemLinks.push(baseItemLink);
                    baseItem.metaMap = "{}";
                    baseItem.baseItemLists=[];
                    baseItem.linkedItems=[];
                    if (!_this.objectiveGroup.baseItemList) {
                        _this.objectiveGroup.baseItemList = [];
                    }
                        let newBatch = _.clone(requestBody);
                        newBatch.title = response.data.impediment.title;
                        newBatch.key = response.data.impediment.key;
                        newBatch.id = response.data.impediment.id;
                    newBatch.showChildren = false;

                    // _this.objectiveGroup.baseItemList.push(newBatch);
                    // _this.objectiveGroup.showChildren = true;
                    _this.$emit('add-sub-batch-event', newBatch, _this.objectiveGroup.id);

                    axios.post('external-entitites/save-base-item/popup-save', baseItem)
                    .then(response => {
                        if (response.status == "200" ) {
                            _this.$root.flags.refetchData = true;
                        }
                    })
                    .catch(error => {
                        console.error("Item save error", error);
                    });	
                }
                _this.$forceUpdate();

            })
            .catch(error => {
                console.error("Item save error", error);

            });
            _this.onCLoseEditPopUp();
		},
        onSaveBatchCompletionCriteria(batchId, criteria) {
            if (this.objectiveGroup.id === batchId) {
                this.objectiveGroup.fields.selectedCriteria = criteria;
            }
        },

    }
});
