Vue.use(Pinia.PiniaVuePlugin);
Vue.use(Pinia.createPinia());

const useBacklogItemRendererStore = Pinia.defineStore('backlogItemRendererStore', {
    state() {
        return {
            flags: {
                boards : false,
                teams : false,
                containers : false,
                status: false,
                batches : false ,
                solutionBoards : false,
                filterNames :false
            },
            backlogItemsMetaDetails:{
                backlogItemsStatusesMap:{},
                backlogItemsSessionBoardMap:{},
                backlogItemsSolutionBoardMap:{},
                backlogItemsTeamsMap:{},
                backlogItemsSprintsMap:{},
                backlogItemsFilterNamesMap:{},
                bkItemFilterMap:{},
            },
            parentView: "",
        }
    },
    actions: {

    },
    getters: {

    }
});
const BACKLOG_ITEM_COMMON = Vue.component("backlog-item-gen", {
    store: useBacklogItemRendererStore,
    template: /*html*/`
    	<div class="prow">
            <div :class="['rec', showChild ? 'active' : '']" style="display: inline-flex">
  				<div class="rc c1 arra DF">
  					<em v-if="childCount > 0" @click="onToggleShowChild" class="ti-angle-right arrd c-point"></em>
  				</div>
              
                    <div class="rc c1 objky DF">
                        <a v-if="item.almKey" class="key fs-12 ftsb jiraKeyHandle kendisOnly" :href="item.url" target="_blank">{{item.almKey}}</a>
                        <a v-else-if="item.fields && item.fields.externalKey" class="key fs-12 ftsb jiraKeyHandle kendisOnly" :href="item.fields.externalLink" target="_blank">{{item.fields.externalKey}}</a>
                   		<a v-else-if="item.kendisKey" class="key fs-12 ftsb jiraKeyHandle kendisOnly" target="_blank">{{item.kendisKey}}</a>

                    </div>	
                    <div class="rc c2 ttl DF" @click="onSelectItem">
                        <span v-if="!_.isEmpty(getBackLogItemIconUrl(item))" class="key-a"
    						<span v-if="item.fields.tfsProjectId == undefined" class="jira" :class="getBackLogItemIconUrl(item)"></span>
                        	<img v-else :src="getBackLogItemIconUrl(item)" class="azurico" alt=" "  />
                        </span>
                        <div>{{item.title}}</div>
                    </div>
                 <div v-if="isSelectable"  class="p-abs custom-checkbox selectitemCheck">
					<input :id="'bckitemchk:'+getItemLink.id"  type="checkbox" :value = "getItemLink" v-model="$parent.selectedItems" @change = "$parent.onChangeSelectedItems"> 
					<label :for="'bckitemchk:'+getItemLink.id"></label> 
				</div>
               <template v-for="column in columns">
               
					<div v-if="column == 'status'" class="rc c3 status  DF">
<!--					if the item has status title then show the status title else fetch from meta-->

					    <span class="sts ftsb" v-if="item.status && item.status.title && item.status.category" :class="!item.status.category ? 'd' : item.status.category == 'ToDo' ? 'a' : item.status.category == 'InProgress' ? 'b' : item.status.category == 'Done' ? 'c' : 'd' " >{{item.status.title}}</span>
						<span class="sts ftsb" v-else-if="flags.status == true && item.status" :class="!backlogItemsStatusesMap[item.releaseTrainId+':'+item.status.id] ? 'd' : backlogItemsStatusesMap[item.releaseTrainId+':'+item.status.id].category == 'ToDo' ? 'a' : backlogItemsStatusesMap[item.releaseTrainId+':'+item.status.id].category == 'InProgress' ? 'b' : backlogItemsStatusesMap[item.releaseTrainId+':'+item.status.id].category == 'Done' ? 'c' : 'd' " >{{statusTitle}}</span>

						<span v-else>--</span>
					</div>
					<div v-else-if="column == 'children'" class="rc c3 statuses_cat DF v">
					<span class="ChildCnt">
						<span v-for="info in childCountsByStatusCategory"
							class="sts fs-10 ftsb"
							:class="[info.category == 0 ? 'a' : (info.category == 1 ? 'b' : (info.category == 2 ? 'c' : 'd'))]"
							:title="info.category == 0 ? ( 'ToDo '+ info.count) : (info.category == 1 ? 'In Progress ' : (info.category == 2 ? 'Done ' : 'Misc ')) + info.count">{{info.count}}</span>
					</span>
					</div>				
					<div v-else-if="column == 'estimate'"  class="rc c3 spctg DFA-a" :title="totalEstimateTooltip"><span class="ftsb">{{totalEstimate}}</span></div>
					<div v-else-if="column == 'startDate'" class="rc c3 spctg DFA-a"><span v-if="item.fields && item.fields.StartDate">{{formatDate(item.fields.StartDate,'dd mmm, yy')}}</span></div>
					<div v-else-if="column == 'endDate'"   class="rc c3 spctg DFA-a"><span v-if="item.fields && item.fields.EndDate">{{formatDate(item.fields.EndDate,'dd mmm, yy')}}</span></div>			
					<div v-else-if="column == 'boards'"    class="rc c3 blnk DFA-a">						
                        <div v-if="flags.boards">	
                        <div v-for="(boardTtile, index) in visibleBoards" class="spttg nsw mxwd tooltip">
                            <span :style="{backgroundColor:boardTtile.color+30, color:boardTtile.color}">
                                {{boardTtile.prefix ? boardTtile.prefix : boardTtile.title}}
                            </span>
                            <div class="hovtooltipB">{{ boardTtile.title }}</div>
                        </div>	
                        <div v-if="hiddenBoardCount > 0" class="spttg nsw mxwd tooltip">
                            <span>+{{hiddenBoardCount}}</span>
                            <div class="hovtooltip DF DW">
                                <div v-for="hiddenBoard in hiddenBoards" class="spttg nsw mxwd">
                                    <span :style="{backgroundColor:hiddenBoard.color+30, color:hiddenBoard.color}">
                                        {{  hiddenBoard.prefix ? hiddenBoard.prefix : hiddenBoard.title }}
                                    </span>
                                </div>
                            </div>
                        </div>							
                        </div>	
					</div>
					<div v-else-if="column == 'solutionBoards'" class="rc c3 blnk DF-a">
					    <div v-if = "flags.solutionBoards" v-for="boardTtile in visibleItems(solutionBoardsTitles)" class="spttg nsw mxwd tooltip">
                            <span :style="{backgroundColor:boardTtile.color+30, color:boardTtile.color}"
                            >{{boardTtile.prefix?boardTtile.prefix:boardTtile.title}}</span>
                             <div class="hovtooltipB ">{{boardTtile.title}}</div>								
                        </div>		
                        <div v-if="flags.solutionBoards && hiddenItemCount(solutionBoardsTitles) > 0" class="spttg nsw mxwd tooltip">
                            <span>+{{hiddenItemCount(solutionBoardsTitles)}}</span>
                            <div class="hovtooltip DF DW">
                                <div v-for="boardTtile in hiddenItems(solutionBoardsTitles)" class="spttg nsw mxwd">
                                    <span :style="{backgroundColor:boardTtile.color+30, color:boardTtile.color}"
                                    >{{boardTtile.prefix?boardTtile.prefix:boardTtile.title}}</span>							
                                </div>	
                            </div>
                        </div>				
					</div>
					<div v-else-if="column == 'teams'" class="rc c3 tm DF-b">
						<div v-if ="flags.teams">
							<div class="tm lbl-bg tooltip" v-for="(team,key) in visibleItems(Object.values(itemTeams))" v-if="team && team.id" v-bind:style="{color:team.color}">
								<div class="line" v-bind:style="{'background-color':(team.color+30)}"></div>
								{{team.label}}<div class="hovtooltipB">{{team.title}}</div>
							</div>
                            <div v-if="hiddenItemCount(Object.values(itemTeams)) > 0" class="spttg nsw mxwd tooltip" style="margin-right: 45px; float: right;">
								<span>+{{hiddenItemCount(Object.values(itemTeams))}}</span>
								<div class="hovtooltip DF DW">
									<div class="tm lbl-bg" v-for="(team,key) in hiddenItems(Object.values(itemTeams))" v-if="team && team.id" v-bind:style="{color:team.color}">
										<div class="line" v-bind:style="{'background-color':(team.color+30)}"></div>
										{{team.label}}
									</div>
								</div>
							</div>
						</div>
					</div>

					<div v-else-if="column == 'sprints'" class="rc c3 sp DF-c">
						<div v-if="flags.containers">
							<div v-for="sprint in visibleItems(itemSprints)" v-if="sprint && sprint.id" class="spttg nsw mxwd tooltip">
								<span>{{sprint.label}}</span>
								<div class="hovtooltipB">{{sprint.title}}</div>
							</div>
                            <div v-if="hiddenItemCount(itemSprints) > 0" class="spttg nsw mxwd tooltip">
                                <span>+{{hiddenItemCount(itemSprints)}}</span>
                                <div class="hovtooltip DF DW">
                                    <div v-for="sprint in hiddenItems(itemSprints)" v-if="sprint && sprint.id" class="spttg nsw mxwd">
                                        <span>{{sprint.label}}</span>
                                    </div>
                                </div>
                            </div>
						</div>
					</div>
					
					<div v-else-if="column == 'links'" class="rc c3 dpnd DF">
						<div v-if="item.dependencyLinkIds && item.dependencyLinkIds.length > 0" @click="onClickOpenDependency" class="c-point button-w brgrn txgrn">
							{{item.dependencyLinkIds.length}}
						</div>
					</div>
					
					<div v-else-if="column == 'parent'" class="rc c3 DF">
						<div v-if="item.parents">
							<div v-for="parent in item.parents">
								<a v-if="parent.almKey" class="key ftsb jiraKeyHandle kendisOnly" :href="parent.url" target="_blank">{{parent.almKey}}</a>
								<div>{{parent.title}}</div>
							</div>
						</div>
					</div>
					<div v-else-if="column == 'responsible'" class="rc c3 DF">
						<span v-if="item.fields.AssignedTo && item.fields.AssignedTo.displayName">{{item.fields.AssignedTo.displayName}}</span>
						<span v-if="item.fields.assignee">{{item.fields.assignee.displayName}}</span>
					</div>
					<div v-else-if="column == 'project'" class="rc c3 DF">
						<span >{{item.fields.tfsProject}}</span>
					</div>
					<div v-else-if="column == 'areaPath'" class="rc c3 DF">
						<span >{{item.fields.tfsAreaPath}}</span>
					</div>
					<div v-else-if="column == 'iterationPath'" class="rc c3 DF">
						<span >{{item.fields.tfsIterationPath}}</span>
					</div>
					<div v-else-if="column == 'updated'" class="rc c3 DF">
						{{formatDate(item.updatedOn,'dd mmm, yy')}}
					</div>
					<div v-else-if="column == 'created'" class="rc c3 DF">
						{{formatDate(item.createdOn,'dd mmm, yy')}}
					</div>
					<div v-else-if="column == 'creater'" class="rc c3 DF">
						<span v-if="item.fields.CreatedBy && item.fields.CreatedBy.displayName">{{item.fields.CreatedBy.displayName}}</span>
						<span v-if="item.fields.reporter">{{item.fields.reporter.displayName}}</span>
					</div>
					<div v-else-if="column == 'compStatus'" class="rc c3 DF">						
						<div class="val ftsb">{{completionByChildrenStatus+'%'}}</div>					
					</div>
					<div v-else-if="column == 'compEstimate'" class="rc c4 DF">
						<div class="progrs-bar DAJ">
							<div class="bar mr-10 ">
								<div class="bn" :style="{width:(completionByChildrenStorypoints+'%')}"></div>
							</div>
							<div class="val ftsb">{{completionByChildrenStorypoints+'%'}}</div>
						</div>
					</div>
					<div v-else-if="column == 'fetchedBy'" class="rc c3 DF">
						<span v-if="item.fetchedBy">{{item.fetchedBy.fullName}}</span>
					</div>
<!--					<div v-else-if="column == 'filter'" class="rc c3 DFA">-->
<!--						<span>{{item.filterName}}</span>-->
<!--					</div>-->
					<div v-else-if="item.fields[column]" class="rc c3 DFA">
						<div><span v-html="calculateFieldData(item.fields, column)"></span></div>
					</div>
					<div v-else-if="column == 'r_sp'" class="rc c4 DF">
						<div class="progrs-bar DF JC pt-5">
							<div class="bar mr-10 ">
								<div class="bn" :style="{width:(compByRollupStorypoints+'%')}"></div>
							</div>
							<div class="val ftsb">{{compByRollupStorypoints+'%'}}</div>
						</div>
					</div>
					<div v-else-if="column == 'r_st'" class="rc c4 DF">
						<div class="progrs-bar DF JC pt-5">
							<div class="bar mr-10 ">
								<div class="bn" :style="{width:(compByRollupStatus+'%')}"></div>
							</div>
							<div class="val ftsb">{{compByRollupStatus+'%'}}</div>
						</div>
					</div>
					<div v-else-if="column == 'c_st'" class="rc c4 DF">
						<div class="progrs-bar DF JC pt-5">
							<div class="bar mr-10 ">
								<div class="bn" :style="{width:(compByDoneChildren+'%')}"></div>
							</div>
							<div class="val ftsb">{{compByDoneChildren+'%'}}</div>
						</div>
					</div>
<!--					<template v-else-if = "column == 'c_linked_st'"></template>-->
					
					<div v-else class="rc c4 DF">
						<span>--</span>
					</div>
				</template>
				<em v-if = "!isSubChild && linkUnlinkPermission && !readOnly "  title="Close" class="rmv-ico ti-close rnd sml DAJ" @click="onConfirmUnlinkItem(item,baseItem.id)"></em>

            </div>
             <div v-if="showChild && item.baseItemList" class="child prow">
				<div v-if="loadingChild" class="loadchild prow ftsb"> <div class="loader"><div class="DAJ light"><div class="loaderinteg"></div>loading children ...</div></div></div>
                <backlog-item-gen v-for="(backLogItem,backLogItemIndex) in item.baseItemList" 
                :backlog-items-session-board-map="store.backlogItemsMetaDetails.backlogItemsSessionBoardMap" 
                :backlog-items-statuses-map="store.backlogItemsMetaDetails.backlogItemsStatusesMap" 
                :backlog-items-solution-board-map="store.backlogItemsMetaDetails.backlogItemsSolutionBoardMap" 
                :backlog-items-teams-map="store.backlogItemsMetaDetails.backlogItemsTeamsMap" 
                :backlog-items-sprints-map="store.backlogItemsMetaDetails.backlogItemsSprintsMap" 
                :item = "backLogItem"
                 :key="backLogItem.id" 
                 :base-item="baseItem"
                 :is-sub-child="true"
                 :columns="columns"
                 :read-only="readOnly"
                 :release-train-id="releaseTrainId"
                 :item-type="itemType"
                 @open-dependency="onOpenDependency"
                 ></backlog-item-gen>
            </div>   
    	</div>
`,
    props: {
        item : {
            type: Object,
            default: () => { return {} }
        },
        baseItem:{
            type: Object,
            default: () => { return {} }
        },
        isSubChild : {
            type: Boolean,
            default: () => { return false }
        },
        columns:{
            type: Array,
            default: function () {
                return []
            }
        },
        backlogItemsSessionBoardMap:{
            type: Object,
            default: () => { return {} }
        },
        backlogItemsStatusesMap:{
            type: Object,
            default: () => { return {} }
        },
        backlogItemsSolutionBoardMap:{
            type: Object,
            default: () => { return {} }
        },
        backlogItemsTeamsMap:{
            type: Object,
            default: () => { return {} }
        },
        backlogItemsSprintsMap:{
            type: Object,
            default: () => { return {} }
        },
        releaseTrainId:'',
        linkUnlinkPermission: {
            type: Boolean,
            default: () => { return true }
        },
        readOnly: {
            type: Boolean,
            default: () => { return false }
        },
        isSelectable: {
            type: Boolean,
            default: () => { return false }
        },
        itemType: {
            type: String,
            default: () => { return "" }
        }

    },

    data(){
        return{
            loader: {
                show: false,
                title: ""
            },
            loadingChild: false,
            showChild: false,
        }

    },
    created(){
    },
    mounted(){
    },
    beforeDestroy() {
      this.itemsGroupedByReleaseTrain = {};
    },
    computed:{
        store() {
          return this.$store;
        },
        flags() {
          return this.store.flags;
        },
        compByRollupStorypoints() {
            if (this.flags.status) {
				
                let totalStoryPoints = this.item.leafStoryPoints;
                if (!totalStoryPoints) {
                    totalStoryPoints = 0;
                }
                let doneStoryPoints = 0;
                if (!_.isEmpty(this.item.leafStoryPointsArray)) {
                    let statusesByIdMap = this.backlogItemsStatusesMap;
                    _.each(this.item.leafStoryPointsArray, storyPointsByStatus => {
                        let status = statusesByIdMap[this.item.releaseTrainId+":"+storyPointsByStatus.status];
                        if (status && status.category == "Done") {
                            doneStoryPoints += (storyPointsByStatus.storyPoints ? storyPointsByStatus.storyPoints : 0);
                        }
                    });
                }
                if (totalStoryPoints > 0) {
                    let percentage = (doneStoryPoints / totalStoryPoints) * 100;
                    return Math.round(percentage);
                }
            }
            return 0;
        },
        compByDoneChildren() {

            if (this.flags.status) {
                if (this.item.childrenStatuses && !_.isEmpty(this.item.childrenStatuses)) {

                    let statusesByIdMap = this.backlogItemsStatusesMap;

                    let childCount = this.item.childrenStatuses.length;
                    let doneChildCount = 0;
                    _.each(this.item.childrenStatuses, statusId => {
                        let status = statusesByIdMap[this.item.releaseTrainId+":"+statusId];
                        if (status && status.category == "Done") {
                            doneChildCount++;
                        }
                    });
                    let percentage = (doneChildCount / childCount) * 100;

                    return Math.round(percentage);
                }
            }

            return 0;
        },
        compByRollupStatus() {
            if (this.flags.status) {

                let totalChild = 0;
                let doneChild  = 0;
                if (this.item.leafStoryPointsArray && !_.isEmpty(this.item.leafStoryPointsArray)) {
                    let statusesByIdMap = this.backlogItemsStatusesMap;
                    _.each(this.item.leafStoryPointsArray, storyPointsByStatus => {
                        let status = statusesByIdMap[this.item.releaseTrainId+":"+storyPointsByStatus.status];
                        if (status && status.category == "Done") {
                            doneChild += 1;
                        }
                        totalChild += 1;
                    });
                }
                if (totalChild > 0) {
                    let percentage = (doneChild / totalChild) * 100;
                    return Math.round(percentage);
                }
            }
            return 0;
        },
        statusTitle() {
            if(!this.item.status || !this.backlogItemsStatusesMap){
                return;
            }
            return this.backlogItemsStatusesMap[this.item.releaseTrainId+":"+this.item.status.id]? this.backlogItemsStatusesMap[this.item.releaseTrainId+":"+this.item.status.id].title : 'other'
        },
        itemSprints(){
            let sprints = [];
            let _this = this;

            this.item.teamContainerRelations.forEach(relation => {
                if(relation.sprintId && _this.backlogItemsSprintsMap[relation.sprintId]){
                    sprints.push( _this.backlogItemsSprintsMap[relation.sprintId]);

                }
            })
            return sprints;
        },
        itemTeams(){
            let teams = {};
            let _this = this;

            this.item.teamContainerRelations.forEach(relation => {
                if(relation.teamId && _this.backlogItemsTeamsMap[relation.teamId]){
                    teams[relation.teamId]=( _this.backlogItemsTeamsMap[relation.teamId]);
                }
            })
            return teams;

        },
        completionByChildrenStatus() {

            if (this.flags.status && !_.isEmpty(this.item.childrenStatuses)) {

                let statusesByIdMap = this.backlogItemsStatusesMap;

                let childCount = this.item.childrenStatuses.length;
                let doneChildCount = 0;
                _.each(this.item.childrenStatuses, statusId => {
                    let status = statusesByIdMap[this.item.releaseTrainId+":"+statusId];
                    if (status && status.category == "Done") {
                        doneChildCount++;
                    }
                });
                let percentage = (doneChildCount / childCount) * 100;

                return Math.round(percentage);
            }


            return 0;
        },
        completionByChildrenStorypoints() {
            if(this.flags.status) {

                let totalStoryPoints = this.item.childStoryPoints;
                if (!totalStoryPoints) {
                    totalStoryPoints = 0;
                }
                let doneStoryPoints = 0;
                if (!_.isEmpty(this.item.childStoryPointsByStatus)) {
                    let statusesByIdMap = this.backlogItemsStatusesMap;
                    _.each(this.item.childStoryPointsByStatus, storyPointsByStatus => {
                        let status = statusesByIdMap[this.item.releaseTrainId+":"+storyPointsByStatus.status];
                        if (status && status.category == "Done") {
                            doneStoryPoints += (storyPointsByStatus.storyPoints ? storyPointsByStatus.storyPoints : 0);
                        }
                    });
                }
                if (totalStoryPoints > 0) {
                    let percentage = (doneStoryPoints / totalStoryPoints) * 100;
                    return Math.round(percentage);
                }
            }
            return 0;
        },
        filterName(){
            if(this.flags.filterNames  && this.backlogItemsMetaDetails.backlogItemsFilterNamesMap && this.backlogItemsMetaDetails.bkItemFilterMap && this.backlogItemsMetaDetails.bkItemFilterMap[this.item.id]){
                return this.backlogItemsMetaDetails.backlogItemsFilterNamesMap[this.backlogItemsMetaDetails.bkItemFilterMap[this.item.id]];
            }
            return "--";

        },
        boardsTitles(){
            let _this = this;
            let parentChildBoardsTitles = [];
            if(this.flags.boards) {

                let boardRelations = this.item.boardRelations;
                if(boardRelations){
                    boardRelations.forEach(function (board) {
                        if (_this.backlogItemsSessionBoardMap[board.sessionBoardId] && _this.backlogItemsSessionBoardMap[board.sessionBoardId].session) {
                            let boardDetail = {
                                id: board.sessionBoardId,
                                title: _this.backlogItemsSessionBoardMap[board.sessionBoardId].session.title,
                                prefix: _this.backlogItemsSessionBoardMap[board.sessionBoardId].session.prefix,
                                color:  _this.backlogItemsSessionBoardMap[board.sessionBoardId].session.prefixColor,

                            }
                            parentChildBoardsTitles.push(boardDetail);
                        }
                    });
                }

                let childBoards = this.item.childBoards;
                if (childBoards) {
                    childBoards.forEach(function (boardId) {
                        if (_this.backlogItemsSessionBoardMap[boardId] && _this.backlogItemsSessionBoardMap[boardId].session) {
                            let boardDetail = {
                                id: boardId,
                                title: _this.backlogItemsSessionBoardMap[boardId].session.title,
                                prefix: _this.backlogItemsSessionBoardMap[boardId].session.prefix,
                                color:  _this.backlogItemsSessionBoardMap[boardId].session.prefixColor,

                            }
                            parentChildBoardsTitles.push(boardDetail);
                        }
                    });
                }
                //remove duplicates from parentChildBoardsTitles based on objects id
                parentChildBoardsTitles = parentChildBoardsTitles.filter((thing, index, self) =>
                        index === self.findIndex((t) => (
                            t.id === thing.id
                        ))
                );
            }
            return parentChildBoardsTitles;

        },
        solutionBoardsTitles(){
            let _this=this;
            let parentChildBoardsTitles = [];
            if(this.flags.solutionBoards) {
                let boardRelations = this.item.solutionRelations;
                if(boardRelations) {
                    boardRelations.forEach(function (board) {
                        if (_this.backlogItemsSolutionBoardMap[board.solutionId]) {
                            let boardDetail = {
                                id: board.solutionId,
                                title: _this.backlogItemsSolutionBoardMap[board.solutionId].title,
                                prefix: _this.backlogItemsSolutionBoardMap[board.solutionId].prefix,
                                color: _this.backlogItemsSolutionBoardMap[board.solutionId].prefixColor,
                            }
                            parentChildBoardsTitles.push(boardDetail);
                        }
                    });
                }

                let childBoards = this.item.childSolutionBoards;
                if (childBoards) {
                    childBoards.forEach(function (boardId) {
                        if (_this.backlogItemsSolutionBoardMap[boardId]) {
                            let boardDetail = {
                                id: boardId,
                                title: _this.backlogItemsSolutionBoardMap[boardId].title,
                                prefix: _this.backlogItemsSolutionBoardMap[boardId].title,
                                color: _this.backlogItemsSolutionBoardMap[boardId].prefixColor,

                            }
                            parentChildBoardsTitles.push(boardDetail);
                        }
                    });
                }


                //remove duplicates from parentChildBoardsTitles based on objects id
                parentChildBoardsTitles = parentChildBoardsTitles.filter((thing, index, self) =>
                        index === self.findIndex((t) => (
                            t.id === thing.id
                        ))
                );
            }
            return parentChildBoardsTitles;
        },
        childCount() {
            if (this.item.childrenStatuses) {
                return this.item.childrenStatuses.length;
            } else {
                return 0;
            }
        },
        totalEstimate() {
            let estimate = 0;
            if(this.item.leafStoryPoints){
                estimate= this.item.leafStoryPoints;
            } else {
                estimate= 0;
            }
            if (!Number.isInteger(estimate)) {
                estimate = estimate.toFixed(2);
            }

            let itemEstimate = this.item.storyPoints;
			if (itemEstimate && !Number.isInteger(itemEstimate)) {
				itemEstimate = itemEstimate.toFixed(2);
			}

            if (this.item.childStoryPointsByStatus.length > 0) {
				return `${itemEstimate ? itemEstimate : ""} (${estimate})`;
			}
			return `${itemEstimate ? itemEstimate : " "}`;
        },
        totalEstimateTooltip() {
            let parentSp = 0;
            let childSp = 0;
            if(!this.item.storyPoints){
                parentSp = 0;
            }else {
                parentSp = this.item.storyPoints;
            }
            if(!this.item.leafStoryPoints){
                childSp = 0;
            }else{
                childSp = this.item.leafStoryPoints;
            }
            if (!Number.isInteger(parentSp)) {
				parentSp = parentSp.toFixed(2);
			}
            if (!Number.isInteger(childSp)) {
                childSp = childSp.toFixed(2);
            }

            return `Rollup estimate: ${childSp}\nItem estimates: ${parentSp ? parentSp : " "}`;
        },

        childCountsByStatusCategory() {

            var open = 0;
            var inprog = 0;
            var done = 0;
            var misc = 0;
            if (this.flags.status && !_.isEmpty(this.item.childrenStatuses)) {
                let statusesByIdMap = this.backlogItemsStatusesMap;
                _.each(this.item.childrenStatuses, statusId => {
                    let status = statusesByIdMap[this.item.releaseTrainId+":"+statusId];
                    if (status) {
                        if (status.category === 'ToDo') {
                            open++;
                        } else if (status.category === 'InProgress') {
                            inprog++;
                        } else if (status.category === 'Done') {
                            done++;
                        } else {
                            misc++;
                        }
                    } else {
                        misc++;
                    }
                });

                var infos = [];
                if (open > 0)
                    infos.push({category: 0, count: open});

                if (inprog > 0)
                    infos.push({category: 1, count: inprog});

                if (done > 0)
                    infos.push({category: 2, count: done});

                if (misc > 0)
                    infos.push({category: 3, count: misc});

                return infos;
            }
            return [];
        },
        getItemLink: function(){
            let _this = this;
            let links =  this.$parent.baseItemLinks.filter(link => link.linkType === "backLogItem");
            let link = links.find(link => (link.baseItemId === _this.item.id && link.releaseTrainId ===_this.releaseTrainId));
            return link;
        },
        visibleBoards() {
            return this.boardsTitles.slice(0, 2);
        },
        hiddenBoards() {
            return this.boardsTitles.slice(2);
        },
        hiddenBoardCount() {
            return this.hiddenBoards.length;
        },
    },
    methods: {
        checkFlag(item){
           return this.flags.status === true && item.status
        },
        getBackLogItemIconUrl(item) {
            let itemIconUrl = "";
            if(item && item.fields) {
                if(!_.isEmpty(item.fields.tfsProjectId)) {
                    itemIconUrl = item.fields.itemTypeIcon;
                } else if (item.fields.issuetype || item.almFields && item.almFields.issuetype) {
                	itemIconUrl = styleJiraIcon(this.$root, item);
                }
            }
            return itemIconUrl ? itemIconUrl : '';
        },
        onConfirmUnlinkItem: function (item, baseItemId) {
            let _this = this;
            let message = "";
            if(_this.itemType == "BacklogItem") {
                message = "Are you sure you want to unlink this item? Doing so will result in unlinking it from all the release trains and PI boards."
            }else{
                message = "Are you sure you want to unlink this item?"
            }
            askFromSweetAlertWrapper(message,
                [function (){
                    _this.unlinkBackLogItem(item, baseItemId);
                }],
                [takeNoAction]);
        },
        unlinkBackLogItem(item,baseItemId){
            let _this = this;
            let data = {};
            data.backlogItemId = item.id;
            data.batchId = baseItemId;
            let url = '/batch/unlink-backlog-item-batch/' + syncId;
            if(_this.itemType == "BacklogItem") {
                data.backlogItemId = baseItemId;  // Milestone Id
                data.itemsToUnlink = [item.id];   // Item to Unlink
                data.itemType = "Milestone";     // Item Type Milestone
                url = "/releasetrain/backlog-item/unlink-item"
            }

            _this.loader.show = true;
            _this.loader.title = "Unlinking Backlog Item ...";

            axios.post( url, data)
                .then(res => {
                    if (res.status=="200"  ) {
                        _this.loader.show = false;
                        showTopMessage("Backlog Item Unlinked Successfully.", "success");
                        _this.$emit('unlinkBackLogItem',item.id);
                    }else{
                        onAlmError(res.data.error);
                    }
                })
                .catch(err => {
                    _this.loader.show = false;
                    console.log(err);
                }).finally(() => { _this.loader.show = false;
            });

        },
        formatDate: function(date, format) {
            if (date) {
                return dateFormat(date, format);
            }
            return "";
        },
        onToggleShowChild: function(event) {
            if (event) {
                event.stopPropagation();
            }
            if (this.childCount > 0) {
                this.showChild = !this.showChild;
                if (this.showChild && !this.loadingChild && !this.childrenLoaded) {
                    this.loadChildren();
                }
            }
        },
        onSelectItem: function () {
            this.$emit("select", this.item);
        },
        loadChildren() {

            var _this = this;

            var data = {};
            data.backlogItemId = _this.item.id;
            data.releaseTrainId = _this.releaseTrainId;
            data.rollupSprints = true;
            data.rollupBatches = true;
            data.rollupStoryPointsArray = true;
            data.fetchParents = true;

            _this.loadingChild = true;

            axios.post('/releasetrain/backlog/backlogItemChildren', data)
                .then(res => {
                    if (res.data && res.data.children) {

                        _this.loadingChild = false;
                        let children = res.data.children;
                        _.each(children, child=> {
							child.releaseTrainId = _this.releaseTrainId;
						});
                        _this.setParentsOfItems(_this.releaseTrainId, children, res.data.parents);
                        Vue.set(_this.item, "baseItemList", children);
                    }
                }).catch(error => {
                _this.loadingChild = false;
            });
        },
        setParentsOfItems: function (rtId, items, parents) {
            if (parents) {
                let parentsMap = _.keyBy(parents, "id");
                _.each(items, item => {
                    let parents = [];
                    if (item.parentRelationMap[rtId]) {
                        relations = item.parentRelationMap[rtId];
                        _.each(relations, rel => {
                            let parent = parentsMap[rel.backlogItemId];
                            if (parent) {
                                parents.push(parent);
                            }
                        });
                    }
                    item.parents = parents;
                });
            }
            return items;
        },
        visibleItems(items) {
            items = _.compact(items);
            return items && items.slice(0, 2);
        },
        hiddenItems(items) {
            items = _.compact(items);
            return items && items.slice(2);
        },
        hiddenItemCount(items) {
            items = _.compact(items);
            return items && this.hiddenItems(items).length;
        },
        onClickOpenDependency: function() {
            this.$emit('open-dependency', this.item);
        },

    },
});
const BACKLOG_ITEMS_RENDERER = Vue.component("backlog-items-renderer", {
    store: useBacklogItemRendererStore,
    template: /*html*/`
<div v-if="!isListingView || !_.isEmpty(itemsGroupedByReleaseTrain)" class="">

		<backlog-item-popup
			v-if="backlogItemPopup.show"
			:item="backlogItemPopup.item"
			:batch-id="backlogItemPopup.batchId"
			:release-train-id="backlogItemPopup.releaseTrainId"
			:meta-load-required="backlogItemPopup.metaLoadRequired"
			:load-alm-id="true"
			@close="onItemPopupClose"
		    @create="onItemPopupCreateItem"
		    @update="onItemPopupUpdateItem"
			:system-fields="systemFieldsForLayout"
		/>

		<rt-item-dependency-list
			v-if="itemDependencyPopup.show"
			:release-train="releaseTrain"
			:item="itemDependencyPopup.item"
			:read-only="true"
			:alm-account="itemDependencyPopup.alm"
			@close="onItemDependencyPopupClose"
		/>

        <div  v-if="loading || isLoadingPrp" class="loader">
        	<div>
        		<div class="loaderinteg"></div>
        			Loading ...
        	</div>
        </div>

        <div class="DFA p-abs grpby" v-if="!isListingView">
            
            <div class="selectcont wht h-auto nwsl sml cuswid groupByDrop rnd4">
            <vz-select :multiple="false" empty-selection-text="Select Group By" class="multi-filter" 
                 value-type="value" :options="groupBy.options" v-model="groupBy.value"
                 @select="onGroupBySelectValue" />
            </div>
            <div class="selectcont wht h-auto ml-10 sml cuswid columnDrop rnd4">			
            <vz-select :multiple="true" empty-selection-text="Columns" selected-title="Columns" class="multi-filter" 
								value-type="value" :options="$options.columnOptions" v-model="columns"
								:show-select-all=true :default-columns="defaultColumns" @on-revert="revertToDefaultColumns" @select="onColumnSelectValue" />
			 </div>
			 <div v-if="baseItemAttachedRTsList && baseItemAttachedRTsList.length > 0 && groupBy.value !== 'Collections' "  class="selectcont wht h-auto nwsl sml ml-10 cuswid rnd4">
                <vz-select :options="baseItemAttachedRTsList" v-model="selectedReleaseTrainMap" empty-selection-text="Select ART" label="title" track-by="id" :multiple="false" @select="onArtSelect"></vz-select>
            </div>
         </div>
	<div class="ov-auto lstngut" :class="isAllGroupsCollapsed?'collection-collapsed':' '">
         <div v-if="!isListingView" class="rec hd aaa">
	          <div class="rc c1 arra"></div>
	          <div class="rc c1 objky">Key</div> 
	          <div class="rc c2">Title</div> 
		      <template v-for="column in columns">
		          <div class="rc status" :class="[$options.columsMap[column].class]">{{$options.columsMap[column].title}}</div>       
			  </template>
       	</div>

        <div v-if="_.isEmpty(baseItemAttachedRTsList)" >
        	<div class="nofound prow wbox">No Items Attached.</div>                
        </div>
        <!--        generic groupby   -->
        <div v-else-if = "groupBy.applied && !(groupBy.value === 'Collections') " class="acc-grpby">
            <template v-if="_.isEmpty(backlogItemsGroupedGeneric)"> 
                <div class="emptyMsg" >No Groups Found</div>
            </template>
            <div v-else v-for = "groupName in Object.keys(backlogItemsGroupedGeneric)" class="accrout prow-b">
            <div  class="ab acrdpd">
                      	<div  @click="expandItem(backlogItemsGroupedGeneric[groupName])" :class="['accord', 'DFA',backlogItemsGroupedGeneric[groupName].expanded?'active':'' ]" >
                      	    <div class="rc c2 ttl DFA">
	                            <em class="ti-angle-right arrd c-point"></em> 
	                            
	                             <div v-if = "groupName === 'undefined'" class="name ftsb">No Group</div> 

                                   <!-- for filters-->
	                            <div v-else-if = " store.flags.filterNames && groupBy.value === 'filterId'" class="name ftsb">{{store.backlogItemsMetaDetails.backlogItemsFilterNamesMap[groupName].name}}</div> 
	                                <!-- for status group by-->
	                            <div v-else-if = "store.flags.status && groupBy.value === 'statusId'" class="name ftsb">{{store.backlogItemsMetaDetails.backlogItemsStatusesMap[groupName].title}}</div> 
                            	<div v-else-if = "groupBy.value === 'responsible'" class="name ftsb">{{groupName}}</div> 
                            	<div v-else-if = "store.flags.boards && groupBy.value === 'Session'
                            	&& store.backlogItemsMetaDetails.backlogItemsSessionBoardMap[groupName] 
                            	&& store.backlogItemsMetaDetails.backlogItemsSessionBoardMap[groupName].session 
                            	&& store.backlogItemsMetaDetails.backlogItemsSessionBoardMap[groupName].session.title"
                            	 class="name ftsb">{{store.backlogItemsMetaDetails.backlogItemsSessionBoardMap[groupName].session.title}}</div> 

                                <!-- count-->
						    	<div v-if="itemsGroupedByReleaseTrain[selectedReleaseTrainMap.id]" class="count">{{backlogItemsGroupedGeneric[groupName].groupItems.length}}</div>
						    </div>
                            <!--added this loop to fill empty sapce of accordian-->
						    <template v-for="column in columns">
						    	 <div class="rc status" :class="[$options.columsMap[column].class]"></div>       
                            </template>	
    					</div>   
    					     <div v-if = "backlogItemsGroupedGeneric[groupName].expanded" v-for = "item in backlogItemsGroupedGeneric[groupName].groupItems">
                              <draggable :value="backlogItems"
                                    animation=150 easing="cubic-bezier(1, 0, 0, 1)"
                                    @start="onItemDragStart"
                                    @end="onItemDragEnd" >
                               <backlog-item-gen 
                               :backlog-items-session-board-map="store.backlogItemsMetaDetails.backlogItemsSessionBoardMap" 
                               :backlog-items-statuses-map="store.backlogItemsMetaDetails.backlogItemsStatusesMap" 
                               :backlog-items-solution-board-map="store.backlogItemsMetaDetails.backlogItemsSolutionBoardMap" 
                               :backlog-items-teams-map="store.backlogItemsMetaDetails.backlogItemsTeamsMap" 
                               :backlog-items-sprints-map="store.backlogItemsMetaDetails.backlogItemsSprintsMap"
                               :item = "item"
                               :key="item.id"
                               :base-item="baseItem"
                               @unlinkBackLogItem="removeBackLogItem"
                               @select="onItemWidgetSelectItem"
                               @open-dependency="onOpenDependency"
                               :is-sub-child="false"
                               :columns="columns"
                               :link-unlink-permission="linkUnlinkPermission"
                               :release-train-id="selectedReleaseTrainMap.id"
                               :item-type="itemType">
                                </backlog-item-gen>
                            </draggable>
                 </div>
            </div>
            </div>
        </div>
        <div v-else-if = "!groupBy.applied">
            	<div v-if="isSelectable"  class="p-abs custom-checkbox selectitemCheck">
					<input :id="'select-all-:'+baseItem.id"  type="checkbox" v-model="isSelectAll" @change = "onChangeSelectedAllItems"> 
					<label :for="'select-all-:'+baseItem.id"></label> 
				</div>
          <div class="accrout prow-a">
            <div class="emptyMsg" v-if = "backlogItems && _.isEmpty(backlogItems)">No Items Found</div>
          	<div  class="ab acrdpd" >
                   
         		<div :class="['accord', 'DFA', 'active' ]" >
                      	<template v-if="artsCompletionPercentages[selectedReleaseTrainMap.id]">
                      	  <div class="rc c1 arra"></div> 
                          <div class="rc c1 objky"></div> 
                          <div class="rc c2 ttl DFA">
	                            <em class="ti-angle-right arrd c-point"></em> 
	                            <div class="name ftsb">{{selectedReleaseTrainMap.title}}</div> 
	<!--                        <div class="name ftsb" v-else>No PI Attached</div> -->
						    	<div v-if="itemsGroupedByReleaseTrain[selectedReleaseTrainMap.id]" class="count">{{itemsGroupedByReleaseTrain[selectedReleaseTrainMap.id].length}}</div>
    					   </div>
                      		<template v-for="column in columns">
                                 <div v-if="column == 'r_sp'" class="rc c4 DFA">
                          
                                 <div  class="progrs-bar DFA JC pt-5 tooltip">
                                     <div class="bar mr-10 ">
						    	        <div class="bn" :style="{width:(artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStorypointsGroup.percentage+'%')}"></div>
						        	</div>
						        	<div class="val ftsb">{{artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStorypointsGroup.percentage+'%'}}</div>
                                <div class="hovtooltip">
                                    <div>Done: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStorypointsGroup.done}}</div>
                                     <div>Total: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStorypointsGroup.total}}</div>
                                </div>
                                </div>
                                </div>
                                <div v-else-if="column == 'r_st'" class="rc c4 DFA">
                                <div  class="progrs-bar DFA JC pt-5 tooltip">
                                      <div class="bar mr-10 ">
                                            <div class="bn" :style="{width:(artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStatusGroup.percentage+'%')}"></div>
                                      </div>
                                      <div class="val ftsb">{{artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStatusGroup.percentage+'%'}}</div>
                                
                                <div class="hovtooltip">
                                    <div>Done: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStatusGroup.done}}</div>
                                     <div>Total: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByRollupStatusGroup.total}}</div>
                                </div>
                                  </div>
                                 </div>
                                 
                                <div v-else-if="column == 'c_st'" class="rc c4 DFA">
                                <div  class="progrs-bar DFA JC pt-5 tooltip">
                                    <div class="bar mr-10 ">
                                        <div class="bn" :style="{width:(artsCompletionPercentages[selectedReleaseTrainMap.id].compByDoneChildrenGroup.percentage+'%')}"></div>
                                    </div>
                                    <div class="val ftsb">{{artsCompletionPercentages[selectedReleaseTrainMap.id].compByDoneChildrenGroup.percentage+'%'}}</div>
                                <div class="hovtooltip">
                                    <div>Done: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByDoneChildrenGroup.done}}</div>
                                     <div>Total: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByDoneChildrenGroup.total}}</div>
                                </div>
                                </div>
                                </div>
                                 <div v-else-if="column == 'c_linked_st'" class="rc c4 DFA">
                                <div  class="progrs-bar DFA JC pt-5 tooltip">
                                    <div class="bar mr-10 ">
                                        <div class="bn" :style="{width:(artsCompletionPercentages[selectedReleaseTrainMap.id].compByLinkedItemsGroup.percentage+'%')}"></div>
                                    </div>
                                    <div class="val ftsb">{{artsCompletionPercentages[selectedReleaseTrainMap.id].compByLinkedItemsGroup.percentage+'%'}}</div>
                                 <div class="hovtooltip">
                                    <div>Done: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByLinkedItemsGroup.done}}</div>
                                     <div>Total: {{artsCompletionPercentages[selectedReleaseTrainMap.id].compByLinkedItemsGroup.total}}</div>
                                </div>
                                </div>
                                </div>
		                        <div v-else class="rc  status" :class="[$options.columsMap[column].class]"></div>       
                          </template>	
						</template> 
                      	</div>
                      	
            	        <draggable :value="backlogItems"
							    animation=150 easing="cubic-bezier(1, 0, 0, 1)"
								@start="onItemDragStart"
								@end="onItemDragEnd" >
                            <backlog-item-gen v-for="(backLogItem,backLogItemIndex) in backlogItems" 
                            :backlog-items-session-board-map="store.backlogItemsMetaDetails.backlogItemsSessionBoardMap" 
                            :backlog-items-statuses-map="store.backlogItemsMetaDetails.backlogItemsStatusesMap" 
                            :backlog-items-solution-board-map="store.backlogItemsMetaDetails.backlogItemsSolutionBoardMap" 
                            :backlog-items-teams-map="store.backlogItemsMetaDetails.backlogItemsTeamsMap" 
                            :backlog-items-sprints-map="store.backlogItemsMetaDetails.backlogItemsSprintsMap"
                            :item = "backLogItem"
                            :key="backLogItem.id"
                            :base-item="baseItem"
                            :read-only="readOnly"
                            @unlinkBackLogItem="removeBackLogItem"
                            @select="onItemWidgetSelectItem"
                            @open-dependency="onOpenDependency"
                            :is-sub-child="false"
                            :columns="columns"
							:link-unlink-permission="linkUnlinkPermission"
                            :release-train-id="selectedReleaseTrainMap.id"
                            :is-selectable="isSelectable"
                            :item-type="itemType">
                            </backlog-item-gen>
                </draggable>
                </div>
                </div>
        </div>
           
		    <div v-else-if="groupBy.applied && (groupBy.value === 'Collections' || groupBy.value === '-1')" class="acc-grpby">
<div v-if="isSelectable"  class="p-abs custom-checkbox selectitemCheck">
					<input :id="'select-all-:'+baseItem.id"  type="checkbox" v-model="isSelectAll" @change = "onChangeSelectedAllItems"> 
					<label :for="'select-all-:'+baseItem.id"></label> 
				</div>                   
				<div class="accrout prow-b">
                      <div v-if="baseItemAttachedRTsList.length > 0 && releaseTrain.id !== '-1'" class="ab acrdpd" v-for="releaseTrain in baseItemAttachedRTsList" >
                      	<div :class="['accord', 'DFA', releaseTrain.expand ? 'active':'' ]" @click="showItemsForReleaseTrain(releaseTrain)">
                           
    			
                      	<template v-if="artsCompletionPercentages[releaseTrain.id]">
                      	  <div class="rc c1 arra"></div> 
                          <div class="rc c1 objky"></div> 
                          <div class="rc c2 ttl DFA">
	                            <em class="ti-angle-right arrd c-point"></em> 
	                            <div class="name ftsb">{{releaseTrain.title}}</div> 
	                            <!-- <div class="name ftsb" v-else>No PI Attached</div> -->
						    	<div v-if="itemsGroupedByReleaseTrain[releaseTrain.id]" class="count">{{itemsGroupedByReleaseTrain[releaseTrain.id].length}}</div>
                                <div v-if="getCompletionPercentage(releaseTrain)" class="progrs-bar DFA JC pt-5 tooltip FR ml-auto mr-20">
                                    <div class="bar mr-10 ">
                                        <div class="bn" :style="{width:(getCompletionPercentage(releaseTrain).percentage+'%')}"></div>
                                    </div>
                                    <div class="val ftsb">{{getCompletionPercentage(releaseTrain).percentage+'%'}}</div>
                                    <div class="hovtooltip">
                                        <span>Done: {{getCompletionPercentage(releaseTrain).done}}</span>
                                        <span>Total: {{getCompletionPercentage(releaseTrain).total}}</span>
                                    </div>
                                </div>
    					   </div>
                      		<template v-for="column in columns">
                                 <div v-if="column == 'r_sp'" class="rc c4 DFA">
                                 <div  class="progrs-bar DFA JC pt-5 tooltip">
                                     <div class="bar mr-10 ">
						    	        <div class="bn" :style="{width:(artsCompletionPercentages[releaseTrain.id].compByRollupStorypointsGroup.percentage+'%')}"></div>
						        	</div>
						        	<div class="val ftsb">{{artsCompletionPercentages[releaseTrain.id].compByRollupStorypointsGroup.percentage+'%'}}</div>
                                <div class="hovtooltip">
                               
                                    <span>Done: {{artsCompletionPercentages[releaseTrain.id].compByRollupStorypointsGroup.done}}</span>
                                     <span>Total: {{artsCompletionPercentages[releaseTrain.id].compByRollupStorypointsGroup.total}}</span>
                                </div>
                                </div>
                                </div>
                                <div v-else-if="column == 'r_st'" class="rc c4 DFA">
                                <div  class="progrs-bar DFA JC pt-5 tooltip">
                                      <div class="bar mr-10 ">
                                            <div class="bn" :style="{width:(artsCompletionPercentages[releaseTrain.id].compByRollupStatusGroup.percentage+'%')}"></div>
                                      </div>
                                      <div class="val ftsb">{{artsCompletionPercentages[releaseTrain.id].compByRollupStatusGroup.percentage+'%'}}</div>
                                 <div class="hovtooltip">
                                    <span>Done: {{artsCompletionPercentages[releaseTrain.id].compByRollupStatusGroup.done}}</span>
                                     <span>Total: {{artsCompletionPercentages[releaseTrain.id].compByRollupStatusGroup.total}}</span>
                                </div>
                                 </div>
                                 </div>
                                 
                                <div v-else-if="column == 'c_st'" class="rc c4 DFA">
                                <div  class="progrs-bar DFA JC pt-5 tooltip">
                                    <div class="bar mr-10 ">
                                        <div class="bn" :style="{width:(artsCompletionPercentages[releaseTrain.id].compByDoneChildrenGroup.percentage+'%')}"></div>
                                    </div>
                                    <div class="val ftsb">{{artsCompletionPercentages[releaseTrain.id].compByDoneChildrenGroup.percentage+'%'}}</div>
                                  <div class="hovtooltip">
                                    <span>Done: {{artsCompletionPercentages[releaseTrain.id].compByDoneChildrenGroup.done}}</span>
                                     <span>Total: {{artsCompletionPercentages[releaseTrain.id].compByDoneChildrenGroup.total}}</span>
                                </div>
                                </div>
                                </div>
                                <div v-else-if="column == 'c_linked_st'" class="rc c4 DFA">
                                <div  class="progrs-bar DFA JC pt-5 tooltip">
                                    <div class="bar mr-10 ">
                                        <div class="bn" :style="{width:(artsCompletionPercentages[releaseTrain.id].compByLinkedItemsGroup.percentage+'%')}"></div>
                                    </div>
                                    <div class="val ftsb">{{artsCompletionPercentages[releaseTrain.id].compByLinkedItemsGroup.percentage+'%'}}</div>
                                 <div class="hovtooltip">
                                    <span>Done: {{artsCompletionPercentages[releaseTrain.id].compByLinkedItemsGroup.done}}</span>
                                     <span>Total: {{artsCompletionPercentages[releaseTrain.id].compByLinkedItemsGroup.total}}</span>
                                </div>
                                </div>
                                </div>
		                        <div v-else class="rc  status" :class="[$options.columsMap[column].class]"></div>       
                          </template>	
						</template> 
						<template v-else >
						   <div class="rc c2 ttl DFA">
	                            <em class="ti-angle-right arrd c-point"></em> 
	                            <div class="name ftsb">{{releaseTrain.title}}</div> 
	<!--                        <div class="name ftsb" v-else>No PI Attached</div> -->
						    	<div v-if="itemsGroupedByReleaseTrain[releaseTrain.id]" class="count">{{itemsGroupedByReleaseTrain[releaseTrain.id].length}}</div>
    					   </div>
                        </template>
                      	</div>
                      <div class="emptyMsg" v-if = " (itemsGroupedByReleaseTrain[releaseTrain.id] && itemsGroupedByReleaseTrain[releaseTrain.id].length == 0 && releaseTrain.expand)">No Items in the group</div>
                        <div class="emptyMsg" v-else-if = "(!itemsGroupedByReleaseTrain[releaseTrain.id] && releaseTrain.expand ) && !isLoadingPrp">Linked Items are Archived</div>
                    	<div v-else-if = "itemsGroupedByReleaseTrain[releaseTrain.id] && itemsGroupedByReleaseTrain[releaseTrain.id].length > 0 && releaseTrain.expand" >
                              <template v-for="(item,itemIndex) in itemsGroupedByReleaseTrain[releaseTrain.id]">    
                              <backlog-item-gen 
                              :item = "item" 
                              :key="item.id"
                              :release-train-id="releaseTrain.id"
                              :backlog-items-session-board-map="store.backlogItemsMetaDetails.backlogItemsSessionBoardMap" 
                              :backlog-items-statuses-map="store.backlogItemsMetaDetails.backlogItemsStatusesMap" 
                              :backlog-items-solution-board-map="store.backlogItemsMetaDetails.backlogItemsSolutionBoardMap" 
                              :backlog-items-teams-map="store.backlogItemsMetaDetails.backlogItemsTeamsMap" 
                              :backlog-items-sprints-map="store.backlogItemsMetaDetails.backlogItemsSprintsMap"
                              :base-item="baseItem"
                              :read-only="readOnly"
                              @unlinkBackLogItem="removeBackLogItem"
                              @select="onItemWidgetSelectItem"
                              @open-dependency="onOpenDependency"
                              :is-sub-child="false"
                              :columns="columns"
							  :link-unlink-permission="linkUnlinkPermission"
							  :is-selectable="isSelectable"
							  :item-type="itemType"
                              ></backlog-item-gen>
                              </template>
	                    </div>
                      </div>
                    </div>
             </div>
<!--             <div v-else>-->
<!--                   <div class="accrout prow-c">-->
<!--                      <div class="ab acrdpd" v-for="(group,groupIndex) in backlogItemsGrouped" >-->
<!--                      	<div class="accord DFA" @click="expandItem(backlogItemsGrouped[groupIndex])" :class="group.expanded?'active':''">-->
<!--                      		<div class="rc c2 ttl DFA">-->
<!--	                            <em class="ti-angle-right arrd c-point"></em> -->
<!--	                            <div class="name ftsb" v-if = "!_.isEmpty(group._id)">{{backLogItemSessionBoardMap[group._id.id].session.title}}</div> -->
<!--	                            <div class="name ftsb" v-else>No Program Boards Attached</div>-->
<!--	                      		<div class="count">{{group.count}}</div>-->
<!--                      		</div>-->
<!--                      	</div>-->
<!--                      	<div v-if = "group.groupItems.length==0" class="nofound">No Items in the group</div>-->
<!--                      		-->
<!--                    	<div v-if = "group.groupItems && group.expanded" v-for="(item,itemIndex) in group.groupItems">-->
<!--                              <backlog-item-gen -->
<!--                              :item = "item" -->
<!--                              :key="item.id"-->
<!--                              :back-log-item-session-board-map="store.backlogItemsMetaDetails.backlogItemsSessionBoardMap" -->
<!--                              :backlog-items-statuses-map="store.backlogItemsMetaDetails.backlogItemsStatusesMap" -->
<!--                              :backlog-items-solution-board-map="store.backlogItemsMetaDetails.backlogItemsSolutionBoardMap" -->
<!--                              :backlog-items-teams-map="store.backlogItemsMetaDetails.backlogItemsTeamsMap" -->
<!--                              :backlog-items-sprints-map="store.backlogItemsMetaDetails.backlogItemsSprintsMap"-->
<!--                              :base-item="baseItem"-->
<!--                              :read-only="readOnly"-->
<!--                              @unlinkBackLogItem="removeBackLogItem"-->
<!--                              @select="onItemWidgetSelectItem"-->
<!--                              :is-sub-child="false"-->
<!--                              :columns="columns"-->
<!--                              :release-train-id="selectedReleaseTrainMap.id"-->
<!--							  :link-unlink-permission="linkUnlinkPermission"-->
<!--                              ></backlog-item-gen>-->
<!--	                    </div>-->
<!--                      </div>                    -->
<!--                    </div>-->
<!--             </div>-->
             </div>
    </div>`,
    props: {
        baseItem:{
			type: Object,
			default: () => { return {} }
		},
        // backLogItemsGrouped:{},
        // backLogItems: {
        //     type: Array,
        //     default: function () {
        //         return []
        //     }},
        baseItemLinks: {
            type: Array,
            default: function () {
                return []
        }},
        // itemsGroupedByReleaseTrain:{
		// 	type: Object,
		// 	default: () => { return {} }
		// },
        backLogItemSessionBoardMap:{
			type: Object,
			default: () => { return {} }
		},
        backlogItemsStatusesMap:{
			type: Object,
			default: () => { return {} }
		},
        backlogItemsSolutionBoardMap:{
			type: Object,
			default: () => { return {} }
		},
        backlogItemsTeamsMap:{
			type: Object,
			default: () => { return {} }
		},
        backlogItemsSprintsMap:{
			type: Object,
			default: () => { return {} }
		},
		isListingView: {
			type: Boolean,
			default: () => {return false }
		},
		linkUnlinkPermission: {
			type: Boolean,
			default: () => { return true }
		},
        viewType: {
          type: String,
            default: () => { return "" }
        },
        readOnly: {
            type: Boolean,
            default: () => { return false }

        },
        releaseTrain: {
            type: Object,
            default: () => { return {} }
        },
        isLoadingPrp:{
            type : Boolean,
            default : () => {return false}

        },
        isSelectable:{
            type : Boolean,
            default : () => {return false}

        },
        selectedItemsProp:{
            type : Array,
            default : () => {return []}
        },
        itemType: {
          type: String,
          default: () => { return "" }
        },
        hierarchyLevel: {
            type: Object,
            default: () => { return {} }
        },
        completionCriteria: {
            type: String,
            default: () => { return "" }
        }
    },

    components:{
        'backlog-item-gen': BACKLOG_ITEM_COMMON,
    },
    data(){
        return{
            loader: {
                show: false,
                title: ""
            },

            columns:[],
            groupBy: {
                applied: false,
                options: [
                    { title: "No Group", id: "-1" },
                    { title: "Program Boards", id: "Session" },
                    { title: "Collections", id: "Collections" },
                    //commenting out as the complete code is present in this branch ,DEV-8238
                    // { title: "Filters", id: "filterId" },
                    { title: "Status", id: "statusId" },
                    { title: "Responsible", id: "responsible" },

                ],
                value: "Collections"
            },
            sessionMap:{},
            backlogItems:[],
            backlogItemsGrouped: {},

            releaseTrains : [],
            releaseTrainsMap : {},
            selectedReleaseTrainMap: {},
            loading : false,
            baseItemAttachedRTsList:[],
            artsCompletionPercentages:{},
            backlogItemPopup: {
				show: false,
				item:undefined,
				releaseTrainId: undefined,
				metaLoadRequired: true,
                itemType: "",
                releaseTrain: {},
			},
            itemDependencyPopup: {
				show: false,
				item: undefined,
				alm: undefined
			},
            isAllGroupsCollapsed: false,
            itemsGroupedByReleaseTrain: {},
            filterIdItemIdsMap:{},
            loadingItems : false,
            backlogItemsGroupedGeneric:{},
            defaultColumns : [],
			systemFieldsForLayout : []
        }
    },
    created(){
        this.initializeColumns();
    },
    updated(){
        // console.log("updated");
        if(this.$parent){
            if(this.$parent.adjustSizeOnSubComponentUpdate){
                this.$parent.adjustSizeOnSubComponentUpdate(this.baseItem.id);
            }
        }
    },
    mounted(){
        // this.store.backLogItemsCopy=this.backLogItems;
        // this.backLogItemsGroupedCopy=this.backLogItemsGrouped;

            this.fetchReleaseTrainsOfAttachedBacklogItems();
            // this.fetchRTsOfAttachedBacklogItems(this.baseItem, this.viewType,this.viewType, this.flags, this.globalView);
            // this.onGroupBySelectValue();
            // if (!_.isEmpty(this.attachedReleaseTrains)){
            //     this.populateAttachedRTList(this.attachedReleaseTrains);
            // }
            this.groupBy.applied = true;

    },
    components : {
        'draggable': vuedraggable,
    },
    computed: {
        store() {
            return this.$store;
        },
        flags() {
            return this.store.flags;
        },
        compByRollupStorypointsGroup() {
            if (this.flags.status) {


            }
            return 0;
        },

        onStatusChange(){
            let _this = this;
            if( this.flags.status && this.itemsGroupedByReleaseTrain && !_.isEmpty(this.itemsGroupedByReleaseTrain)){
                return true;
            }
            return false;
        },

        workspace () {
			if(this.baseItem.itemType && (this.baseItem.itemType.title === "Objective" || this.baseItem.itemType.title === "KR")){
				return kendisStore.getters.getObjectiveWorkspace();
			}else if(this.baseItem.itemType && (this.baseItem.itemType.title === "batch_group" || this.baseItem.itemType.title === "Batch")){
				return kendisStore.getters.getBatchWorkspace();
			}
		},

        getCompletionPercentage(){
            return function(collection) {
                if (this.baseItem && !_.isEmpty(this.baseItem.completionCriteria)) {
                    const completion = this.artsCompletionPercentages[collection.id];
                    const criteria = this.baseItem.completionCriteria;
                    if (criteria === "CHILDREN_LINKED_ITEM_ESTIMATE") {
                        return completion.compByRollupStorypointsGroup;
                    } else if (criteria === "Status") {
                        return completion.compByRollupStatusGroup;
                    } else if (criteria === "CHILDREN_LINKED_ITEM_STATUS") {
                        return completion.compByDoneChildrenGroup;
                    } else if (criteria === "LINKED_ITEM_STATUS") {
                        return completion.compByLinkedItemsGroup;
                    }
                }
                return undefined;
            }
        }

    },
    watch:{
      viewType: {
          handler(newValue, oldValue) {
              this.itemsGroupedByReleaseTrain = {};
              this.fetchReleaseTrainsOfAttachedBacklogItems();
          }
        },
        onStatusChange:function (newVal,oldVal) {
            let _this=this;
            if(newVal) {
                let totalChild = 0;
                let doneChild = 0;
                let doneChildCount = 0;
                let childCount = 0;
                let doneStoryPoints = 0;
                let totalStoryPoints = 0;
                let linkedItemsCount = 0;
                let doneLinkedItemsCount = 0;
                if (!_.isEmpty(_this.itemsGroupedByReleaseTrain) && !_.isEmpty(_this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap)) {
                    _.each(_this.itemsGroupedByReleaseTrain, (itesm, artId) => {
                        totalChild = 0;
                        doneChild = 0;
                        doneChildCount = 0;
                        childCount = 0;
                        doneStoryPoints = 0;
                        totalStoryPoints = 0;
                        linkedItemsCount = 0;
                        doneLinkedItemsCount = 0;
                        if (_this.itemsGroupedByReleaseTrain[artId] && _this.itemsGroupedByReleaseTrain[artId].length > 0) {
                            _.each(_this.itemsGroupedByReleaseTrain[artId], item => {
                                linkedItemsCount++;
                                if (item.status && _this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap && _this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap[item.releaseTrainId+":"+item.status.id] && _this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap[item.releaseTrainId+":"+item.status.id].category === "Done") {
                                    doneLinkedItemsCount++;
                                }
                                if (item.leafStoryPointsArray && !_.isEmpty(item.leafStoryPointsArray)) {
                                    let statusesByIdMap = this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap;
                                    _.each(item.leafStoryPointsArray, storyPointsByStatus => {
                                        let status = statusesByIdMap[storyPointsByStatus.status];
                                        if (status && status.category == "Done") {
                                            doneChild += 1;
                                        }
                                        totalChild += 1;
                                    });
                                }
                                if (item.childrenStatuses && !_.isEmpty(item.childrenStatuses)) {
                                    let statusesByIdMap = this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap;
                                    childCount = childCount + item.childrenStatuses.length;
                                    _.each(item.childrenStatuses, statusId => {
                                        let status = statusesByIdMap[item.releaseTrainId+":"+statusId];
                                        if (status && status.category == "Done") {
                                            doneChildCount++;
                                        }
                                    });
                                }
                                if (item.leafStoryPoints) {
                                    totalStoryPoints += item.leafStoryPoints;
                                }
                                if (!_.isEmpty(item.leafStoryPointsArray)) {
                                    let statusesByIdMap = this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap;
                                    _.each(item.leafStoryPointsArray, storyPointsByStatus => {
                                        let status = statusesByIdMap[item.releaseTrainId+":"+storyPointsByStatus.status];
                                        if (status && status.category == "Done") {
                                            doneStoryPoints += (storyPointsByStatus.storyPoints ? storyPointsByStatus.storyPoints : 0);
                                        }
                                    });
                                }

                            });
                        }
                        _this.artsCompletionPercentages[artId] = {
                            compByRollupStatusGroup: {},
                            compByDoneChildrenGroup: {},
                            compByRollupStorypointsGroup: {},
                            compByLinkedItemsGroup: {}
                        };
                        if (totalChild > 0) {
                            let percentage = (doneChild / totalChild) * 100;
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStatusGroup, 'percentage', Math.round(percentage));
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStatusGroup, 'done', doneChild);
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStatusGroup, 'total', totalChild);
                        } else {
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStatusGroup, 'percentage', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStatusGroup, 'done', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStatusGroup, 'total', 0);
                        }
                        if (childCount > 0) {
                            Vue.set(_this.artsCompletionPercentages[artId].compByDoneChildrenGroup, 'percentage', Math.round((doneChildCount / childCount) * 100));
                            Vue.set(_this.artsCompletionPercentages[artId].compByDoneChildrenGroup, 'done', doneChildCount);
                            Vue.set(_this.artsCompletionPercentages[artId].compByDoneChildrenGroup, 'total', childCount);
                        } else {
                            Vue.set(_this.artsCompletionPercentages[artId].compByDoneChildrenGroup, 'percentage', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByDoneChildrenGroup, 'done', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByDoneChildrenGroup, 'total', 0);
                        }
                        if (totalStoryPoints > 0) {
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStorypointsGroup, 'percentage', Math.round((doneStoryPoints / totalStoryPoints) * 100));
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStorypointsGroup, 'done', doneStoryPoints);
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStorypointsGroup, 'total', totalStoryPoints);
                        } else {
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStorypointsGroup, 'percentage', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStorypointsGroup, 'done', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByRollupStorypointsGroup, 'total', 0);
                        }
                        if (linkedItemsCount > 0) {
                            Vue.set(_this.artsCompletionPercentages[artId].compByLinkedItemsGroup, 'percentage', Math.round((doneLinkedItemsCount / linkedItemsCount) * 100));
                            Vue.set(_this.artsCompletionPercentages[artId].compByLinkedItemsGroup, 'done', doneLinkedItemsCount);
                            Vue.set(_this.artsCompletionPercentages[artId].compByLinkedItemsGroup, 'total', linkedItemsCount);

                        } else {
                            Vue.set(_this.artsCompletionPercentages[artId].compByLinkedItemsGroup, 'percentage', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByLinkedItemsGroup, 'done', 0);
                            Vue.set(_this.artsCompletionPercentages[artId].compByLinkedItemsGroup, 'total', 0);
                        }
                        _this.$forceUpdate();

                    });
                }
            }
        },
        "baseItemLinks" : {
            handler(newValue, oldValue) {
                this.groupBy.value = "Collections";
                this.baseItemAttachedRTsList = [];
                this.itemsGroupedByReleaseTrain = {};
                this.fetchReleaseTrainsOfAttachedBacklogItems();
                this.groupBy.applied = true;
            }
        }
    },
    methods: {
        groupReleaseTrainItems(attribute) {
            let _this = this;
            let data = {};
            if(this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id]) {
                if (attribute === "filterId") {
                    let filteredItems = _.filter(this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id], item => {
                        return (item.filterName !== undefined && item.filterName !== "");
                    });
                    data = _.groupBy(filteredItems, this.groupBy.value);
                } else if (attribute === "statusId") {
                    data = _.groupBy(this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id], "status.id");
                } else if (attribute === "responsible") {
                    if (this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id]
                        && this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id].length > 0
                        && this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id][0].fields.tfsProjectId) {
                        data = _.groupBy(this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id], "fields.AssignedTo.displayName");
                    } else {
                        data = _.groupBy(this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id], "fields.assignee.displayName");
                    }
                } else if (attribute === "Session") {
                        this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id].forEach(item => {
                            if(item.boardRelations && item.boardRelations.length > 0) {
                                item.boardRelations.forEach(value => {
                                    if (!data[value.sessionBoardId]) {
                                        data[value.sessionBoardId] = [];
                                    }
                                    data[value.sessionBoardId].push(item);
                                });
                            }else{
                                if (!data[undefined]) {
                                    data[undefined] = [];
                                }
                                data[undefined].push(item);
                            }
                        });
                    }

                if (data && !_.isEmpty(data)) {
                    _.each(data, (items, key) => {
                        let group = {};
                        group.groupItems = items;
                        group.expanded = true;
                        Vue.set(data, key, group);
                    });
                }
            }
            Vue.set(_this, 'backlogItemsGroupedGeneric', data);
        },
        fetchFilterItemIds: function (filters) {
            //create request
            let _this = this;
            let data = {};
            _.each(filters, filter => {
                data[filter.id]=
                    {
                        filter:filter.criteria,
                        hierachLevel: filter.level.toString()
                    };
            })

            axios.post('/releasetrain/' + _this.selectedReleaseTrainMap.id + '/backlog/ids', data)
                .then(res => {
                    if(res.data){
                        _this.filterIdItemIdsMap = res.data;
                    }
                });
        },
        // createGroupedBacklogItemData() {
        //     let filteredItems = _.filter(this.itemsGroupedByReleaseTrain[this.selectedReleaseTrainMap.id], item => {
        //         return (item.filterName!=undefined && item.filterName!="");
        //     });
        //
        //     let data = _.groupBy(filteredItems, this.groupBy.value);
        //     if(data){
        //         _.each(data, (items, key) => {
        //             let group = {};
        //             group.groupItems = items;
        //             group.expanded = true;
        //             Vue.set(data, key, group);
        //         });
        //     }
        //     this.backlogItemsGroupedGeneric = data;
        // },
        expandItem: function(group) {
            if (group && group.expanded!==undefined) {
                Vue.set(group, 'expanded', !group.expanded);
            }
        },
        ////////////////////////////  Events ////////////////////////////////////////////
        onColumnSelectValue: function(values) {
            if (!_.isEmpty(this.defaultColumns)) {
				// Sort values based on this.defaultColumns
				values.sort((a, b) => {
					const indexA = this.defaultColumns.indexOf(a);
					const indexB = this.defaultColumns.indexOf(b);

					// If both values are in this.defaultColumns, sort based on their index
					if (indexA >= 0 && indexB >= 0) {
						return indexA - indexB;
					}

					// If only one of them is in this.defaultColumns, prioritize the one that is
					if (indexA >= 0) {
						return -1;
					}
					if (indexB >= 0) {
						return 1;
					}

					// If none of them are in this.defaultColumns, maintain their original order
					return 0;
				});
			}

            // Safely determine the itemType, ensuring it's always a string.
            const itemType = (this.baseItem.itemType && this.baseItem.itemType.title) ? this.baseItem.itemType.title : (typeof this.baseItem.fields.itemType === 'string' ? this.baseItem.fields.itemType : '');

            if (itemType) {
                const localStorageKey = `${this.baseItem.id}_${itemType}_Backlog_Columns`;
                localStorage.setItem(localStorageKey, JSON.stringify(values));

                if (itemType === 'Objective' || itemType === 'KR') {
                    this.$emit('updateBacklogItemsColumns');
                }
            }

        },
        onChangeSelectedItems: function(){
            let _this= this ;
            let emissionObj = {
                selectedItems: this.selectedItems,
                baseItemId: this.baseItem.id
            }
            this.isSelectAll = false;
            _this.$emit('abc',emissionObj);
        },
        onChangeSelectedAllItems: function(){
            let _this= this ;
            let emissionObj = {
                baseItemId: this.baseItem.id,
                selectAll: this.isSelectAll
            }
            _this.$emit('select-all-items',emissionObj);
        },
        areCollectionsColapsed() {
            //check if all collections are colapsed
            let _this=this;
            if (this.baseItemAttachedRTsList && this.baseItemAttachedRTsList.length > 0){
                for(let a of this.baseItemAttachedRTsList){
                    if(a.expand){
                        _this.isAllGroupsCollapsed = false;
                        return false;
                    }
                }
            }
            _this.isAllGroupsCollapsed = true;
        },


        expandGroup(groupIndex){
            Vue.set(this.backlogItemsGrouped[groupIndex], 'expanded', !this.backlogItemsGrouped[groupIndex].expanded);
            if(this.backlogItemsGrouped[groupIndex].expanded){
                this.isAllGroupsCollapsed = false;
            }else{
                this.isAllGroupsCollapsed = true;

            }
        },
        initializeColumns: function () {

            this.$options.columsMap = {};
            this.$options.columsMap["c_linked_st"] = { id: "c_linked_st", title: "% Completion By Linked Items Status", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["r_st"] = { id: "r_st", title: "% Completion By Rollup (Status)", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["r_sp"] = { id: "r_sp", title: "% Completion By Rollup (Estimate)", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["c_st"] = { id: "c_st", title: "% Completion By Done Children", sortCommand: "", sort: false , class:"c4"};
            this.$options.columsMap["status"] = { id: "status", title: "Status", sortCommand: "statusTitle", sort: false, class:"c3" };
            this.$options.columsMap["children"] = { id: "children", title: "Children Count", sortCommand: "childCount", sort: false , class:"c3"};
            this.$options.columsMap["estimate"] = { id: "estimate", title: "Estimate (SP)", sortCommand: "totalEstimate", sort: false , class:"c3"};
            this.$options.columsMap["compStatus"] = { id: "compStatus", title: "% Completion", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["startDate"] = { id: "startDate", title: "Start Date", sortCommand: "startDate", sort: true , class:"c3"};
            this.$options.columsMap["endDate"] = { id: "endDate", title: "End Date", sortCommand: "endDate", sort: true , class:"c3"};
            //commented as story is moved to spillover
            // this.$options.columsMap["filter"] = { id: "filter", title: "Filter", sortCommand: "", sort: false , class:"c3"}

            this.$options.columsMap["boards"] = { id: "boards", title: "Kendis Board", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["teams"] = { id: "teams", title: "Teams (Kendis)", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["sprints"] = { id: "sprints", title: "Sprints (Kendis)", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["links"] = { id: "links", title: "Dependencies", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["solutionBoards"] = { id: "solutionBoards", title: "Solution Boards", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["fetchedBy"] = { id: "fetchedBy", title: "Fetched By", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["project"] = { id: "project", title: "Project", sortCommand: "fields.tfsProject", sort: true , class:"c3"};
            this.$options.columsMap["areaPath"] = { id: "areaPath", title: "Area Path", sortCommand: "fields.tfsAreaPath", sort: true , class:"c3"};
            this.$options.columsMap["iterationPath"] = { id: "iterationPath", title: "Iteration Path", sortCommand: "fields.tfsIterationPath", sort: true , class:"c3"};
            this.$options.columsMap["responsible"] = { id: "responsible", title: "Responsible", sortCommand: "fields.CreatedBy", sort: true , class:"c3"}
            this.$options.columsMap["parent"] = { id: "parent", title: "Parent", sortCommand: "", sort: false , class:"c3"};
            this.$options.columsMap["updated"] = { id: "updated", title: "Updated On", sortCommand: "updatedOn", sort: true , class:"c3"}
            this.$options.columsMap["created"] = { id: "created", title: "Created On", sortCommand: "createdOn", sort: true , class:"c3"}
            this.$options.columsMap["creater"] = { id: "creater", title: "Creator", sortCommand: "", sort: false , class:"c3"}
            this.$options.columnOptions = Object.values(this.$options.columsMap);

            const workSpace = !_.isEmpty(this.workspace) ? this.workspace : !_.isEmpty(this.releaseTrain) ? this.releaseTrain : undefined;

            if (workSpace) {
                this.fetchBacklogItemsSettings(workSpace);
            }
        },
        onItemDragStart: function(evt) {

        },
        onItemDragEnd: function(evt) {
            this.sortBacklogItem(evt.newIndex, evt.oldIndex);
        },
        sortBacklogItem: function(newIndex, oldIndex) {

            var _this = this;

            var item = this.backlogItems[oldIndex];
            var sequenceObject = this.calculateNewSequenceOfItem(newIndex, oldIndex, this.backlogItems, "sequence");
            // value, key

            var data = {};
            data.baseItemId = item.id;
            data.sequence = "" + sequenceObject.value;
            data.batchId=_this.baseItem.id;
            this.loading=true;
            axios.post('/batch/update-link-sequence/'+syncId, data)
                .then(res => {
                    if (res.status=="200"  ) {

                        item.sequence = data.sequence;
                        _this.baseItemLinks.forEach(function (link) {
                            if (link.linkType == "backLogItem"
                                && link.baseItemId == item.id
                                && link.releaseTrainId == _this.selectedReleaseTrainMap.id) {
                                Vue.set(link, 'sequence', item.sequence);
                            }
                        });

                        //.......   set array
                        if (oldIndex > newIndex) {
                            _this.backlogItems.splice(oldIndex, 1);
                            _this.backlogItems.splice(newIndex, 0, item);

                        } else {
                            _this.backlogItems.splice(newIndex + 1, 0, item);
                            _this.backlogItems.splice(oldIndex, 1);
                        }
                        //sort backLogItemsCopy by sequence
                        _this.backlogItems.sort(function(a, b) {
                            return a.sequence - b.sequence;
                        });

                    }else{
                        onAlmError(res.data.error);
                    }
                    _this.loading=false;

                }).catch(error => {
                _this.loading=false;
                console.log(error)
            });
        },
        calculateNewSequenceOfItem: function(newIndex, oldIndex, list, key) {
            var sequence;
            if (_.isEmpty(list)) {
                sequence = 0;
            } else {
                if (newIndex == 0) {
                    var nextItem = list[0]
                    sequence = nextItem[key] - 1000;

                } else if (newIndex >= list.length - 1) {
                    var preItem = list[list.length - 1];
                    sequence = preItem[key] + 1000;

                } else {

                    var preItem;
                    var nextItem;

                    if (oldIndex == -1 || oldIndex > newIndex) {
                        preItem = list[newIndex - 1];
                        nextItem = list[newIndex];
                    }
                    else {
                        preItem = list[newIndex];
                        nextItem = list[newIndex + 1];
                    }

                    sequence = (parseFloat(preItem[key]) + parseFloat(nextItem[key])) / 2.0;
                }
            }
            return { value: sequence, key: key };
        },
        removeBackLogItem: function (itemId) {
            let _this = this;
            //remove item from backLogItemsCopy
            let index = this.backlogItems.findIndex(item => item.id === itemId);
            if (index > -1) {
                this.backlogItems.splice(index, 1);
            }

            //remove item from backLogItemsGroupedCopy
            Object.entries(this.backlogItemsGrouped).forEach(([key, value]) => {
                let groupIndex = value.groupItems.findIndex(item => item.id === itemId);
                if (groupIndex > -1) {
                    value.groupItems.splice(groupIndex, 1);
                    value.count= value.count-1;
                }
            })

            if (_this.$parent.templateToRender && _this.$parent.templateToRender.type === "Objective" || _this.$parent.objectiveData && _this.$parent.objectiveData.type.includes("Objective")) {
                let storePayload = {};
                storePayload.objective = {
                    "id": _this.baseItem.id,
                    "backLogItemsGrouped" : _this.backlogItemsGrouped,
                    "backLogItems" : _this.backlogItems
                };
                storePayload.fields = ["backLogItemsGrouped", "backLogItems"];
                storePayload.stopReload = true;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }else if (_this.$parent.templateToRender && _this.$parent.templateToRender.type === "KR" || _this.$parent.objectiveData && _this.$parent.objectiveData.type === "KR"){
                let storePayload = {};
                storePayload.okr = {
                    "id": _this.baseItem.id,
                    "backLogItemsGrouped" : _this.backlogItemsGrouped,
                    "backLogItems" : _this.backlogItems
                };
                storePayload.fields = ["backLogItemsGrouped", "backLogItems"];
                storePayload.objectiveId = _this.$parent.parentId;
                storePayload.stopReload = true;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }
            _this.$emit('remove-backLog-item', itemId);

        },
        fetchGroupItems: function(group){
            return group.groupItems;
        },
        onGroupBySelectValue: function() {
            this.isAllGroupsCollapsed = false;
            if (this.groupBy.value === "-1") {
                if (this.baseItemAttachedRTsList && this.baseItemAttachedRTsList.length > 0){
                    this.selectedReleaseTrainMap = this.baseItemAttachedRTsList[0]
                    this.loadBacklogItems(this.selectedReleaseTrainMap.id);
                    // this.$emit("onSelectReleaseTrain", this.selectedReleaseTrainMap.id, this.viewType,this.flags, this.globalView);
                }
                this.groupBy.applied = false;
            }else if (this.groupBy.value === "Collections") {
                if (this.baseItemAttachedRTsList[0]){
                    this.baseItemAttachedRTsList[0].expand = false;
                    this.groupBy.applied = true;
                    this.loadBacklogItems(this.baseItemAttachedRTsList[0].id);
                    // this.$emit("showItemsForReleaseTrain", this.baseItemAttachedRTsList[0].id, this.viewType,this.flags, this.globalView);
                    // this.loading = true;
                    // this.$emit("showItemsForReleaseTrain", this.baseItemAttachedRTsList[0].id);
                }
            }
            else if(this.groupBy.value === "Session"){
                if (this.baseItemAttachedRTsList && this.baseItemAttachedRTsList.length > 0){
                    this.selectedReleaseTrainMap = this.baseItemAttachedRTsList[0];
                    this.loadBacklogItems(this.selectedReleaseTrainMap.id);
                    // this.$emit("onSelectReleaseTrain", this.selectedReleaseTrainMap.id, this.viewType,this.flags, this.globalView);
                }
                this.groupBy.applied = true;
            }
            else if(this.groupBy.value === "statusId"){
                if (this.baseItemAttachedRTsList && this.baseItemAttachedRTsList.length > 0){
                    this.selectedReleaseTrainMap = this.baseItemAttachedRTsList[0];
                    this.loadBacklogItems(this.selectedReleaseTrainMap.id);
                    // this.$emit("onSelectReleaseTrain", this.selectedReleaseTrainMap.id, this.viewType,this.flags, this.globalView);
                }
                this.groupBy.applied = true;
               // this.groupReleaseTrainItems(this.groupBy.value);
            }
            else if(this.groupBy.value === "responsible"){
                if (this.baseItemAttachedRTsList && this.baseItemAttachedRTsList.length > 0){
                    this.selectedReleaseTrainMap = this.baseItemAttachedRTsList[0];
                    this.loadBacklogItems(this.selectedReleaseTrainMap.id);
                    // this.$emit("onSelectReleaseTrain", this.selectedReleaseTrainMap.id, this.viewType,this.flags, this.globalView);
                }
                this.groupBy.applied = true;
                // this.groupReleaseTrainItems(this.groupBy.value);
            }
            else {
                this.groupBy.applied = true;
            }

            // this.loadBacklogItemsForBatch();
        },
        onArtSelect: function (){
            let _this = this;
            if (!_.isEmpty(_this.selectedReleaseTrainMap)){
                _this.loadBacklogItems(_this.selectedReleaseTrainMap.id);
                // _this.$emit("onSelectReleaseTrain", _this.selectedReleaseTrainMap.id, this.viewType,this.flags, this.globalView)
            }

        },
        // processBacklogItems: function(backLogItems) {
        //     let unProcessedBackLogItems = backLogItems;
        //     let sessionBoardIds=[];
        //     unProcessedBackLogItems.forEach(backLogItem => {
        //         if(backLogItem._id.id && backLogItem._id.id!=""){
        //             sessionBoardIds.push(backLogItem._id.id);
        //         }
        //     });
        //     this.attachSessionTitle(sessionBoardIds,backLogItems);
        // },
        // attachSessionTitle: function(sessionBoardIds,backLogItems) {
        //     let _this = this;
        //     axios.post('/pi/fetch-session-boards-title', sessionBoardIds)
        //         .then(res => {
        //             this.sessionMap = res.data.sessionBoardIdTitleMap;
        //             backLogItems.forEach(backLogItem => {
        //                 if(!backLogItem._id.id){
        //                     backLogItem._id.title="No PI Board";
        //                 }else{
        //                     if(this.sessionMap[backLogItem._id.id]){
        //                         backLogItem._id.title=this.sessionMap[backLogItem._id.id];
        //                     }else{
        //                         backLogItem._id.title="";
        //
        //                     }
        //                 }
        //             });
        //
        //             _this.backlogItems = backLogItems;
        //
        //         }).catch(error => {
        //         console.error(error);
        //
        //     });
        // },

        fetchReleaseTrains: function () {
            //fetch all release trains
            let _this = this;
            let data = {};
            data.fetchTypes = true;
            data.fetchArchived = true;
            axios.get("/releasetrain/release-trains-without-pi").then(res => {
                _this.releaseTrains = res.data.releaseTrains;
                _this.releaseTrains.forEach(releaseTrain => {
                    _this.releaseTrainsMap[releaseTrain.id] = releaseTrain;
                });

                let releaseTrainIndex = _.findIndex(_this.releaseTrains, {default: false});
                if (releaseTrainIndex > -1) {
                    _this.selectedReleaseTrainMap = _this.releaseTrains[releaseTrainIndex];
                }
                let releaseTrains = [];
                let releaseTrainsMap = {};
                //get artRelationMap from backlogItems
                let data = {};
                data.batchId = this.baseItem.id
                axios.post("/batch/get-attached-release-trains",data).then(res => {
                    if (res.status == "200" && res.data && res.data.attachedReleaseTrains){
                        res.data.attachedReleaseTrains.forEach(releaseTrainId => {
                            Vue.set(releaseTrainsMap, releaseTrainId, {});
                            if(_this.releaseTrainsMap[releaseTrainId]) {
                                releaseTrainsMap[releaseTrainId].id = releaseTrainId;
                                releaseTrainsMap[releaseTrainId].title = _this.releaseTrainsMap[releaseTrainId].title;
                                releaseTrainsMap[releaseTrainId].rowStatus = _this.releaseTrainsMap[releaseTrainId].rowStatus;
                            }
                                Vue.set(releaseTrainsMap[releaseTrainId], 'expand', false);
                        });
                        // _this.baseItemAttachedRTsList=Object.values(releaseTrainsMap);
                        this.populateAttachedRTList(releaseTrainsMap);
                        _this.onGroupBySelectValue();
                    }
                }).catch(error => {
                    console.log(error);
                });

            }).catch(error => {
                console.log(error);
            });
        },

        showItemsForReleaseTrain: function (releaseTrain){
            releaseTrain.expand = !releaseTrain.expand;
            this.areCollectionsColapsed();

            if (releaseTrain.expand){
                this.loadBacklogItems(releaseTrain.id);
                // this.$emit("showItemsForReleaseTrain", releaseTrain.id, this.viewType, this.flags, this.globalView);
                // this.loading = true;
                // this.$emit("showItemsForReleaseTrain", releaseTrain.id);
            }
        },
        //......................................................
        //.........    Item widget
        onItemWidgetSelectItem: function (item) {

            if (this.baseItem.itemType && this.baseItem.itemType.title !== "Objective" && this.baseItem.itemType.title !== "KR") {
                let currentItemRelation = _.find(this.baseItemLinks, link => {
                    return link.linkType && link.linkType == "backLogItem" && link.baseItemId === item.id;
                });
                if (currentItemRelation) {

                    let itemCopy = _.cloneDeep(item);
                    if( !itemCopy.status.category && this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap[itemCopy.releaseTrainId+":"+itemCopy.status.id]){
                        itemCopy.status = this.$store.backlogItemsMetaDetails.backlogItemsStatusesMap[itemCopy.releaseTrainId+":"+itemCopy.status.id];
                    }
					if(_.isEmpty(itemCopy.almKey) && this.$parent && this.$parent.$store && this.$parent.$store.customLayouts && this.$parent.$store.customLayouts.kendisCard) {
						this.systemFieldsForLayout = this.$parent.$store.customLayouts.kendisCard.systemFieldsToExclude;
					}else{
						this.systemFieldsForLayout = [];
					}

                    this.backlogItemPopup.item = itemCopy;
                    this.backlogItemPopup.batchId = undefined;
                    this.backlogItemPopup.releaseTrainId = currentItemRelation.releaseTrainId;
                    this.backlogItemPopup.show = true;
                }
            }
        },
        //......................................................
        //.........    BACKLOG ITEM POPUP
        fetchItemRollups: function (itemIds, releaseTrainId, callback) {
            let data = {}
            data.releaseTrainId = releaseTrainId;
            data.itemIds = itemIds;

            data.rollupTeams = true;
            data.rollupSprints = true;
            data.rollupBatches = true;
            data.rollupStoryPointsArray = true;
            data.fetchGroupItems = true;

            axios.post("/releasetrain/backlog/items", data)
                .then(res => {
                    if (res.data) {
                        callback(res.data);
                    }
                }).catch(error => {
                callback(error);
            });

        },
        addItemInList: function (item, releaseTrain) {
            if (!this.groupBy.applied) {
                if (!this.backlogItems) {
                    this.backlogItems = [];
                }
                this.backlogItems.push(item);
            }
            else {
                if (this.groupBy.value === 'Collections') {
                    if (!this.baseItemAttachedRTsList) {
                        this.baseItemAttachedRTsList = [];
                    }
                    let rt = _.find(this.baseItemAttachedRTsList,{id:releaseTrain.id});
                    if (!rt) {
                        this.baseItemAttachedRTsList.push(releaseTrain);
                    }
                    if (!this.itemsGroupedByReleaseTrain[releaseTrain.id]) {
                        this.itemsGroupedByReleaseTrain[releaseTrain.id] = [];
                    }else {
                        this.itemsGroupedByReleaseTrain[releaseTrain.id].push(item);
                    }
                    this.$forceUpdate();
                }
                else {

                }
            }
        },
    updateItemAttributes: function (orgItem, newItem) {

            orgItem.fields      = newItem.fields;
            orgItem.status      = newItem.status;
            orgItem.storyPoints = newItem.storyPoints;
            orgItem.title       = newItem.title;

            orgItem.almType      = newItem.almType;
            orgItem.almAccountId = newItem.almAccountId;
            orgItem.url          = newItem.url;
            orgItem.almItemId    = newItem.almItemId;
            orgItem.almKey       = newItem.almKey;

            orgItem.description       = newItem.description;
            orgItem.otherRequirements = newItem.otherRequirements;

            orgItem.updatedBy   = newItem.updatedBy;
            orgItem.updatedOn   = newItem.updatedOn;

            //...... roll ups
            orgItem.batchRelations  = newItem.batchRelations;
            orgItem.boardRelations  = newItem.boardRelations;
            orgItem.parentRelations = newItem.parentRelations;
            orgItem.parents         = newItem.parents;
            orgItem.relations       = newItem.relations;

            orgItem.solutionRelations      = newItem.solutionRelations;
            orgItem.teamContainerRelations = newItem.teamContainerRelations;

            orgItem.childBatches        = newItem.childBatches;
            orgItem.childBoards         = newItem.childBoards;
            orgItem.childContainers     = newItem.childContainers;
            orgItem.childRelations      = newItem.childRelations;
            orgItem.childSolutionBoards = newItem.childSolutionBoards;
            orgItem.childStoryPoints    = newItem.childStoryPoints;
            orgItem.childrenStatuses    = newItem.childrenStatuses;
            orgItem.childStoryPointsByStatus = newItem.childStoryPointsByStatus;

        },
        onClickCreateBacklogItem: function (itemType) {
            this.backlogItemPopup.item = {};
            this.backlogItemPopup.batchId = this.baseItem.id;
            this.backlogItemPopup.releaseTrainId = undefined;
            this.backlogItemPopup.show = true;

            this.backlogItemPopup.itemType = itemType;
        },
        onItemPopupClose: function () {
            this.backlogItemPopup.releaseTrainId = undefined;
            this.backlogItemPopup.batchId = undefined;
            this.backlogItemPopup.show = false;
            this.backlogItemPopup.itemType = "";
        },
        onItemPopupCreateItem: function (itemData, createAnOther) {
            let _this = this;
            let newItem = itemData.item;
            let releaseTrain = itemData.releaseTrain;
            this.fetchItemRollups([newItem.id], releaseTrain.id, response=> {
                let items = response.items;
                _.each(items,item=>{
                    item.status = newItem.status;
                    _this.addItemInList(item, releaseTrain);
                });
            });
            if (!createAnOther) {
                this.backlogItemPopup.item = undefined;
                this.onItemPopupClose();
            }
        },
        onItemPopupUpdateItem: function (itemData) {

            let _this = this;
            let newItem = itemData.item;
            let releaseTrain = itemData.releaseTrain;
            this.fetchItemRollups([newItem.id], releaseTrain.id, response=> {
                let items = response.items;
                _.each(items,item=>{
                    item.status = newItem.status;
                    //.......   update item here
                    if( _this.itemsGroupedByReleaseTrain[releaseTrain.id]) {
                        _this.itemsGroupedByReleaseTrain[releaseTrain.id].forEach(function (itemInList) {
                            if (itemInList.id == newItem.id) {
                                _this.updateItemAttributes(itemInList, newItem);
                            }
                        })
                    }
                    _this.updateItemAttributes(_this.backlogItemPopup.item, item);
                    _this.backlogItemPopup.item = undefined;
                });
            });
            _this.onItemPopupClose();
        },

        onOpenDependency: function(item) {
            let _this = this;
            _this.itemDependencyPopup.item = item;
            if (_this.releaseTrain && _this.releaseTrain.almAccounts && _this.releaseTrain.almAccounts.length > 0) {
                _this.itemDependencyPopup.alm = _this.releaseTrain.almAccounts[0];
            }
            _this.itemDependencyPopup.show = true;
        },

        onItemDependencyPopupClose: function() {
            this.itemDependencyPopup.item = undefined;
            this.itemDependencyPopup.alm = undefined;
            this.itemDependencyPopup.show = false;
        },


        fetchReleaseTrainsOfAttachedBacklogItems: function () {
            //fetch attached release trains of linked backlog items
            let _this = this;
            let data = {};
            data.batchId = this.baseItem.id;
            let url = "/batch/get-attached-release-trains";

            if(this.itemType == "BacklogItem") {
                url = "/releasetrain/backlog-item/get-attached-release-trains";
                data.backlogItemId = this.baseItem.id;
            }

            axios.post(url,data).then(res => {
                if (res.status == "200" && res.data && res.data.attachedReleaseTrains){
                    _this.attachedReleaseTrains = res.data.attachedReleaseTrains;
                    if (!_.isEmpty(_this.attachedReleaseTrains)) {
                        this.populateAttachedRTList(res.data.attachedReleaseTrains);
                        this.onGroupBySelectValue();
                        this.loadBacklogItems(_this.attachedReleaseTrains[0].id);
                    }
                }
            }).catch(error => {
                console.log(error);
            });
        },
        populateAttachedRTList: function (attachedReleaseTrains){
            let _this = this;
            if (!_.isEmpty(attachedReleaseTrains)){
                let releaseTrainsMap = {};
                _.each(attachedReleaseTrains, releaseTrain => {
                    Vue.set(releaseTrainsMap, releaseTrain.id, {});
                    // releaseTrainsMap[releaseTrainId] = {};
                    releaseTrainsMap[releaseTrain.id].id = releaseTrain.id;
                    releaseTrainsMap[releaseTrain.id].title = releaseTrain.title;
                    releaseTrainsMap[releaseTrain.id].rowStatus = releaseTrain.rowStatus;
                    Vue.set(releaseTrainsMap[releaseTrain.id], 'expand', false);
                });
                _this.baseItemAttachedRTsList = Object.values(releaseTrainsMap);
                _this.baseItemAttachedRTsList[0].expand = false;
                _this.selectedReleaseTrainMap  = _this.baseItemAttachedRTsList[0];
            }
        },

        loadBacklogItems: function(releaseTrainId) {
            let _this = this;
            this.loadingItems=true;
            _this.turnMetaFlagOff();
            _this.activeLoader=true;
            let data= _this.createRequestDataForBacklogItems(releaseTrainId);

            let artId = null;
            if (releaseTrainId && releaseTrainId !== "-1"){
                artId = releaseTrainId;
            }

            // if(this.viewType == 'TASK' || this.viewType == 'MILESTONE' || this.viewType == '') {
            //     data.hierachLevel = "-1000";
            // } else {
            //     data.hierachLevel = undefined;
            // }

            // data.hierachLevel =  this.viewType == 'TASK' || this.viewType == 'MILESTONE'? "-1000": undefined;
            data.fetchMilestones = true;
            axios.post('/releasetrain/' + artId + '/backlog', data)
                .then(res => {
                    if (res.data.result) {
                        this.backlogItems = res.data.result.items;
                        _.each(this.backlogItems, item=> {
							item.releaseTrainId = releaseTrainId;
						});
                        if(this.backlogItems) {
                          _this.fetchBacklogItemsMeta(res.data.result.items,releaseTrainId,this.baseItem);
                        }
                    }
                }).catch(error => {
                _this.activeLoader=false
                _this.loadingItems=false;

                console.error(error)
            });

            // let data2 = _.clone(data);
            // data2.fetchGroupItems = true;
            // data2.groupBy = "Session"
            // data2.rollupToGroups=true;
            // data2.hierachLevel =  this.viewType == 'TASK'? "-1000": undefined;
            // _this.loadBacklogItemsGroupedForBatch(artId,data2, this.baseItem);
        },
        fetchBacklogItemsMeta: function(fetchedItems,releaseTrainId,baseItem) {
            this.fetchSolutionBoardData(fetchedItems);
            this.fetchBoardMeta(fetchedItems);
            this.populateStatusMap(fetchedItems, releaseTrainId);
            this.processBacklogItems(fetchedItems,this.getBacklogItemsSequenceMap(baseItem), releaseTrainId);
        },
        turnMetaFlagOff: function() {
            this.store.flags.status = false;
            this.store.flags.boards = false;
            this.store.flags.teams = false;
            this.store.flags.containers = false;
            this.store.flags.batches = false;
            this.store.flags.solutionBoards = false;
            this.store.flags.filterNames = false;
        },
        createRequestDataForBacklogItems: function(releaseTrainId) {
            let data = {};
            let _this = this;
            let backLogItemIds = [];
            data.rollupBatches = true;
            data.rollupSprints = true;
            data.rollupSprints = true;
            data.rollupStoryPointsArray = true;
            data.sortBy = "sequence";
            data.sortOrder = "1"
            data.requestId = getNewUUID();
            data.filter = {};
            data.filter.rules = [];
            data.filter.condition = "AND";
            data.loadStatuses = true;
            if(this.baseItemLinks) {
                    this.baseItemLinks.filter(baseItemLink => (baseItemLink.linkType === "backLogItem") && ( releaseTrainId && releaseTrainId !== "-1" ? releaseTrainId === baseItemLink.releaseTrainId : true))
                        .forEach(function (baseItemLink) {
                            backLogItemIds.push(baseItemLink.baseItemId);
                            if(baseItemLink.filterId && baseItemLink.filterId !== "") {
                                _this.store.backlogItemsMetaDetails.bkItemFilterMap[baseItemLink.baseItemId] = baseItemLink.filterId;
                            }
                        });
            }


            data.filter.rules.push({key: "itemIds", value: backLogItemIds , type: "array", almType: "",});

            /*if (this.displayMode === "Objective"){
                data.filter.rules.push({key: "objective", value: [baseItemId], type: "array", almType: "",});
            }else{
                data.filter.rules.push({key: "batch", value: [baseItemId], type: "array", almType: "",});
            }*/
            return data;
        },
        fetchSolutionBoardData: function(backlogItems) {
            let _this=this;
            //populate backlogItemsSolutionBoardMap based on backlogItems.solutionRelations
            //create a list of solutionId from backlogItems.solutionRelations
            let solutionIds = [];
            backlogItems.forEach(backlogItem => {
                if(backlogItem.solutionRelations && backlogItem.solutionRelations.length>0) {
                    backlogItem.solutionRelations.forEach(solutionRelation => {
                        solutionIds.push(solutionRelation.solutionId);
                    });
                }
                if(backlogItem.childSolutionBoards && backlogItem.childSolutionBoards.length>0) {
                    backlogItem.childSolutionBoards.forEach(childSolutionBoardId=> {
                        solutionIds.push(childSolutionBoardId);
                    });
                }
            });
            //remove duplicates from solutionIds
            solutionIds = solutionIds.filter((value, index, self) => self.indexOf(value) === index);

            //fetch solution board data for solutionIds
            if(solutionIds.length>0) {
                axios.post('/pi/fetch-solution-boards-title', solutionIds)
                    .then(res => {
                        if (res.data) {
                            Object.keys( res.data.solutionBoardIdTitleMap).forEach(function(key) {
                                _this.store.backlogItemsMetaDetails.backlogItemsSolutionBoardMap[key] =  res.data.solutionBoardIdTitleMap[key];
                            });

                            if (this.baseItem.itemType && this.baseItem.itemType.title === "Objective") {
                                let storePayload = {};
                                storePayload.objective = {
                                    "id": this.baseItem.id,
                                    "backlogItemsMetaDetails": _this.store.backlogItemsMetaDetails
                                };
                                storePayload.fields = ["backlogItemsMetaDetails"];
                                storePayload.stopReload = true;
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                            }else if (this.baseItem.itemType && this.baseItem.itemType.title === "KR"){
                                    let storePayload = {};
                                    storePayload.okr = {
                                        "id" :  this.baseItem.id,
                                        "backlogItemsMetaDetails" : _this.store.backlogItemsMetaDetails
                                    };
                                    storePayload.fields = ["backlogItemsMetaDetails"];
                                    storePayload.stopReload = true;
                                    kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                            }

                            // Set Flag to the Store.
                            this.store.flags.solutionBoards = true;

                        }
                    }).catch(error => {
                    console.error(error)
                });
            }

        },
        getSessionBoardIdsfromBacklogItems: function(backlogItems) {
            let sessionBoardIds=[];
            backlogItems.forEach(backlogItem => {
                backlogItem.boardRelations.forEach(boardRelation => {
                    if(boardRelation.sessionBoardId && boardRelation.sessionBoardId!=""){
                        sessionBoardIds.push(boardRelation.sessionBoardId);
                    }
                });
                backlogItem.childBoards.forEach(childBoardId => {
                    sessionBoardIds.push(childBoardId);
                });
            });
        },
        getSessionIdsfromBacklogItems: function(backlogItems) {
            let result = {
                sessionIds: [],
                childSessionBoardIds: []
            }
            try {
                backlogItems.forEach(backlogItem => {
                    backlogItem.boardRelations.forEach(boardRelation => {
                        if (boardRelation.sessionBoardId && boardRelation.sessionBoardId != "") {
                            result.sessionIds.push(boardRelation.sessionId);
                        }
                    });
                    backlogItem.childBoards.forEach(childBoardId => {
                        result.childSessionBoardIds.push(childBoardId);
                    });
                });
            }
            catch (e) {
                console.log(e);
            }
            return result;
        },
        fetchBoardMeta: function(backlogItems) {
            let _this = this;
            let ids = this.getSessionIdsfromBacklogItems(backlogItems);

            //ids structure   let result = {
            //                 sessionIds: [],
            //                 childSessionBoardIds: []
            //             }

            axios.post('/pi/fetch-session-boards-title', ids)
                .then(res => {
                    Object.keys(res.data.sessionBoardIdTitleMap).forEach(function(key) {
                        _this.store.backlogItemsMetaDetails.backlogItemsSessionBoardMap[key] = res.data.sessionBoardIdTitleMap[key];
                    });
                    Object.keys(res.data.teams).forEach(function(key) {
                        _this.store.backlogItemsMetaDetails.backlogItemsTeamsMap[key] = res.data.teams[key];
                    });
                    Object.keys(res.data.containers).forEach(function(key) {
                        _this.store.backlogItemsMetaDetails.backlogItemsSprintsMap[key] = res.data.containers[key];
                    });

                    if (this.baseItem.itemType && this.baseItem.itemType.title === "Objective") {
                        let storePayload = {};
                        storePayload.objective = {
                            "id": this.baseItem.id,
                            "backlogItemsMetaDetails": _this.store.backlogItemsMetaDetails
                        };
                        storePayload.fields = ["backlogItemsMetaDetails"];
                        storePayload.stopReload = true;
                        kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                    }else if (this.baseItem.itemType && this.baseItem.itemType.title === "KR"){
                        let storePayload = {};
                        storePayload.okr = {
                            "id" : this.baseItem.id,
                            "backlogItemsMetaDetails" : _this.store.backlogItemsMetaDetails
                        };
                        storePayload.fields = ["backlogItemsMetaDetails"];
                        storePayload.stopReload = true;
                        kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                    }
                    _this.store.flags.boards = true;
                    _this.store.flags.teams = true;
                    _this.store.flags.containers = true;
                }).catch(error => {
                console.error(error);
            });
        },
        populateStatusMap: function(backlogItems, releaseTrainId) {
            let _this = this;
            let statusIds = [];
            //fetching status ides from parents and children
            backlogItems.forEach(backlogItem => {
                if(backlogItem.status && backlogItem.status.id) {
                    statusIds.push(backlogItem.status.id);
                }
                backlogItem.childrenStatuses.forEach(childStatusId => {
                    statusIds.push(childStatusId);
                });
                backlogItem.childStoryPointsByStatus.forEach(childStoryPointsByStatus => {
                    statusIds.push(childStoryPointsByStatus.status);
                })
            });

            //remove duplicates from statusIds
            statusIds = statusIds.filter((value, index, self) => self.indexOf(value) === index);

            axios.post('/pi/fetch-statuses',statusIds)
                .then(res => {
                        if (res.data && res.data.statusIdTitleMap) {
                            Object.keys(res.data.statusIdTitleMap).forEach(function(key) {
								
								let status = res.data.statusIdTitleMap[key];
								if (status.categoryMappingByCollectionId && status.categoryMappingByCollectionId[releaseTrainId]) {
									status.category = status.categoryMappingByCollectionId[releaseTrainId];
								}
								let newKey = releaseTrainId +":"+ key;
								_this.store.backlogItemsMetaDetails.backlogItemsStatusesMap[key] = status;
                                _this.store.backlogItemsMetaDetails.backlogItemsStatusesMap[newKey] = status;
                            });
                            if (this.baseItem.itemType && this.baseItem.itemType.title === "Objective") {
                                let storePayload = {};
                                storePayload.objective = {
                                    "id": this.baseItem.id,
                                    "backlogItemsMetaDetails": _this.store.backlogItemsMetaDetails
                                };
                                storePayload.fields = ["backlogItemsMetaDetails"];
                                storePayload.stopReload = true;
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                            }else if (this.baseItem.itemType && this.baseItem.itemType.title === "KR"){
                                let storePayload = {};
                                storePayload.okr = {
                                    "id" :  this.baseItem.id,
                                    "backlogItemsMetaDetails" : _this.store.backlogItemsMetaDetails
                                };
                                storePayload.fields = ["backlogItemsMetaDetails"];
                                storePayload.stopReload = true;
                                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
                            }
                            _this.store.flags.status = true;
                        }
                    }
                ).catch(error => {
                console.error(error)

            });
        },
        getBacklogItemsSequenceMap: function(baseItem) {
            //create a map contining baseItemId as key and sequence as value from fieldsValue.baseItemLinks
            let baseItemSequenceMap = {};
            if(baseItem.baseItemLinks && this.baseItem.baseItemLinks.length>0) {
                this.baseItem.baseItemLinks.forEach(baseItemLink => {
                    if(baseItemLink.baseItemId && baseItemLink.linkType && baseItemLink.linkType=="backLogItem") {
                        baseItemSequenceMap[baseItemLink.baseItemId] = baseItemLink.sequence;``
                    }
                });
            }
            return baseItemSequenceMap;
        },
        processBacklogItems: function(items, baseItemSequenceMap, releaseTrainId) {
            let _this = this;
            let unProcessedBackLogItems = items;
            unProcessedBackLogItems.forEach(backLogItem => {
                if(baseItemSequenceMap){
                    backLogItem.sequence = baseItemSequenceMap[backLogItem.id];
                }
            });
            //sort by sequence
            unProcessedBackLogItems.sort(function(a, b) {
                return a.sequence - b.sequence;
            });
            _this.backlogItems=unProcessedBackLogItems;

            //add newly attached release train to the list
            /*
            if(this.$refs['backlogitemscomponent'+releaseTrainId]){
                let index = _.findIndex(this.$refs['backlogitemscomponent'+releaseTrainId].baseItemAttachedRTsList, function(o) { return o.id == releaseTrainId; });
                if(index === -1){
                    Vue.set( this.$refs['backlogitemscomponent'+releaseTrainId].baseItemAttachedRTsList, this.$refs['backlogitemscomponent'+releaseTrainId].baseItemAttachedRTsList.length, {id:releaseTrainId,title:'new',expand:false})
                }
            }*/

            if (releaseTrainId && !_.isEmpty(unProcessedBackLogItems)){
                Vue.set(_this.itemsGroupedByReleaseTrain, releaseTrainId, unProcessedBackLogItems);
                // _this.itemsGroupedByReleaseTrain[releaseTrainId] = unProcessedBackLogItems;
            }
            this.groupReleaseTrainItems(this.groupBy.value)
            this.loadingItems=false;

            if (this.baseItem.itemType && this.baseItem.itemType.title === "Objective") {
                let storePayload = {};
                storePayload.objective = {
                    "id": this.baseItem.id,
                    "backLogItems": _this.backlogItems,
                    "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                };
                storePayload.fields = ["itemsGroupedByReleaseTrain"];
                storePayload.updateBacklogItems = true;
                storePayload.stopReload = true;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }else if (this.baseItem.itemType && this.baseItem.itemType.title === "KR"){
                let storePayload = {};
                storePayload.okr = {
                    "id" :  this.baseItem.id,
                    "backLogItems" : _this.backlogItems,
                    "itemsGroupedByReleaseTrain" : _this.itemsGroupedByReleaseTrain
                };
                storePayload.fields = ["itemsGroupedByReleaseTrain"];
                storePayload.updateBacklogItems = true;
                storePayload.stopReload = true;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }
        },
        loadBacklogItemsGroupedForBatch: function(artId,data) {
            let _this=this;
            axios.post('/releasetrain/' + artId + '/backlog', data)
                .then(res => {
                    if (res.data) {
                        _this.processBacklogItemsGroups(res.data.result.items, this.baseItem);
                        _this.activeLoader=false
                    }
                }).catch(error => {
                _this.activeLoader=false
                console.error(error)
            });
        },
        processBacklogItemsGroups: function(backLogItems, baseItem) {
            let _this = this;
            let backLogItemGroupedMap= {};
            backLogItems.forEach(backLogItem => {
                if(!backLogItem._id.id || backLogItem._id.id=="null" ){
                    backLogItemGroupedMap["-1"]=backLogItem;
                }else{
                    backLogItemGroupedMap[backLogItem._id.id]=backLogItem;
                }
            });
            _this.backlogItemsGrouped = backLogItemGroupedMap;
            if (baseItem.itemType && baseItem.itemType.title === "Objective") {
                let storePayload = {};
                storePayload.objective = {
                    "id": baseItem.id,
                    "backLogItemsGrouped": _this.backlogItemsGrouped
                };
                storePayload.fields = ["backLogItemsGrouped"];
                storePayload.stopReload = true;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }else if (baseItem.itemType && baseItem.itemType.title === "KR"){
                let storePayload = {};
                storePayload.okr = {
                    "id" :  baseItem.id,
                    "backLogItemsGrouped" : _this.backlogItemsGrouped
                };
                storePayload.fields = ["backLogItemsGrouped"];
                storePayload.stopReload = true;
                kendisStore.commit("updateObjectiveAndOkrsInGroups", storePayload);
            }
        },
        fetchBacklogItemsSettings(workSpace) {
            // Function to determine the item type title, prioritizing the baseItem's itemType title, falling back to fields.itemType if necessary
            const getItemTypeTitle = () => {
                if (this.baseItem.itemType && this.baseItem.itemType.title) {
                    return this.baseItem.itemType.title;
                }
                return typeof this.baseItem.fields.itemType === 'string' ? this.baseItem.fields.itemType : '';
            };

            // Construct the localStorage key using the baseItem's ID and item type
            const localStorageKey = `${this.baseItem.id}_${getItemTypeTitle()}_Backlog_Columns`;
            const localStorageItem = localStorage.getItem(localStorageKey);

            // Check if the settings are already stored in localStorage
            if (!_.isEmpty(localStorageItem) && localStorageItem !== "undefined") {
                // Parse and assign the columns from localStorage if available
                this.columns = JSON.parse(localStorageItem);

                // If a workSpace is provided and it has backlogSettingsMap, set the defaultColumns accordingly
                if (workSpace && !_.isEmpty(workSpace.backlogSettingsMap)) {
                    const hierarchyLevelId = !_.isEmpty(this.hierarchyLevel) ? this.hierarchyLevel.id : '-1';
                    this.defaultColumns = workSpace.backlogSettingsMap[hierarchyLevelId]?.backLogItemsColumns || [];
                }
                return; // Early return to avoid fetching settings if they are already present in localStorage
            }

            // Fetch settings from the server as a fallback if not found in localStorage
            axios.post('/releasetrain/fetch-backlog-items-settings', {
                releaseTrainId: workSpace.id,
                hierarchyLevelId: !_.isEmpty(this.hierarchyLevel) ? this.hierarchyLevel.id : '-1'
            })
            .then(response => {
                const backlogItemColumns = response.data.backlogItemColumns;
                // Check if the server response contains backlogItemColumns and update accordingly
                if (!_.isEmpty(backlogItemColumns)) {
                    this.defaultColumns = backlogItemColumns;
                    this.columns = this.defaultColumns;
                } else {
                    // Use default columns if the response does not contain specific columns
                    this.columns = ["status", "children", "estimate", "boards", "compStatus"];
                }
            })
            .catch(error => {
                // Log the error to the console and consider notifying the user or handling the error gracefully
                console.error("Failed to fetch backlog items settings:", error);
            });
        },
        revertToDefaultColumns : function () {
            this.columns = this.defaultColumns;
            localStorage.setItem(this.baseItem.id + "_" + this.baseItem.itemType.title + "_Backlog_Columns", JSON.stringify(this.defaultColumns));
            if (this.baseItem.itemType && (this.baseItem.itemType.title === "Objective" || this.baseItem.itemType.title === "KR")) {
                this.$emit("updateBacklogItemsColumns");
            }
        }
    },
});
